####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python UnitMonitor.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    unit(category='length',conversionFactor=0.01,name='centi'),
    meta(content='UnitMonitor.x3d',name='title'),
    meta(content='Units component example showing simple computer monitor',name='description'),
    meta(content='Myeong Won Lee',name='creator'),
    meta(content='1 August 2009',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='UnitExamples.pdf',name='reference'),
    meta(content='http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd',name='reference'),
    meta(content='https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement',name='reference'),
    meta(content='X3D UNIT statement',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Units/UnitMonitor.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='UnitMonitor.x3d'),
    Background(groundColor=[(0.05,0.1,0.3)],skyColor=[(0.05,0.1,0.3)]),
    Transform(rotation=(-1,0,0,-1.571),scale=(0.5,0.5,0.5),translation=(50,13.57,0),
      children=[
      Viewpoint(description='monitor',position=(0.0,0.0,1.0)),
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(0.388,0.388,0.888))),
        geometry=IndexedFaceSet(coordIndex=[41,40,43,-1,42,43,40,-1,1,0,9,-1,8,9,0,-1,9,8,5,-1,4,5,8,-1,3,1,10,-1,9,10,1,-1,10,9,7,-1,5,7,9,-1,2,3,11,-1,10,11,3,-1,11,10,6,-1,7,6,10,-1,0,2,8,-1,11,8,2,-1,8,11,4,-1,6,4,11,-1,2,0,12,-1,12,14,2,-1,3,2,14,-1,14,15,3,-1,1,3,15,-1,15,13,1,-1,0,1,13,-1,13,12,0,-1,14,12,16,-1,16,18,14,-1,15,14,18,-1,18,19,15,-1,13,15,19,-1,19,17,13,-1,12,13,17,-1,17,16,12,-1,18,16,20,-1,20,22,18,-1,19,18,22,-1,22,23,19,-1,17,19,23,-1,23,21,17,-1,16,17,21,-1,21,20,16,-1,22,20,24,-1,24,26,22,-1,23,22,26,-1,26,27,23,-1,21,23,27,-1,27,25,21,-1,20,21,25,-1,25,24,20,-1,5,4,28,-1,28,29,5,-1,7,5,29,-1,29,31,7,-1,6,7,31,-1,31,30,6,-1,4,6,30,-1,30,28,4,-1,49,48,50,-1,50,51,49,-1,31,29,33,-1,33,35,31,-1,30,31,35,-1,35,34,30,-1,28,30,34,-1,34,32,28,-1,33,32,36,-1,36,37,33,-1,35,33,37,-1,37,39,35,-1,34,35,39,-1,39,38,34,-1,32,34,38,-1,38,36,32,-1,37,36,40,-1,40,41,37,-1,39,37,41,-1,41,43,39,-1,38,39,43,-1,43,42,38,-1,36,38,42,-1,42,40,36,-1,29,28,44,-1,44,45,29,-1,28,32,46,-1,46,44,28,-1,32,33,47,-1,47,46,32,-1,33,29,45,-1,45,47,33,-1,45,44,48,-1,48,49,45,-1,44,46,50,-1,50,48,44,-1,46,47,51,-1,51,50,46,-1,47,45,49,-1,49,51,47,-1,54,52,55,-1,53,55,52,-1,56,58,57,-1,56,59,58,-1,56,60,59,-1,56,61,60,-1,56,62,61,-1,56,63,62,-1,56,64,63,-1,56,65,64,-1,56,66,65,-1,56,67,66,-1,56,68,67,-1,56,69,68,-1,56,70,69,-1,56,71,70,-1,56,72,71,-1,56,73,72,-1,56,74,73,-1,56,75,74,-1,56,76,75,-1,56,77,76,-1,56,78,77,-1,56,79,78,-1,56,80,79,-1,56,81,80,-1,56,82,81,-1,56,83,82,-1,56,84,83,-1,56,85,84,-1,56,86,85,-1,56,87,86,-1,56,88,87,-1,56,57,88,-1,57,90,89,-1,57,58,90,-1,58,91,90,-1,58,59,91,-1,59,92,91,-1,59,60,92,-1,60,93,92,-1,60,61,93,-1,61,94,93,-1,61,62,94,-1,62,95,94,-1,62,63,95,-1,63,96,95,-1,63,64,96,-1,64,97,96,-1,64,65,97,-1,65,98,97,-1,65,66,98,-1,66,99,98,-1,66,67,99,-1,67,100,99,-1,67,68,100,-1,68,101,100,-1,68,69,101,-1,69,102,101,-1,69,70,102,-1,70,103,102,-1,70,71,103,-1,71,104,103,-1,71,72,104,-1,72,105,104,-1,72,73,105,-1,73,106,105,-1,73,74,106,-1,74,107,106,-1,74,75,107,-1,75,108,107,-1,75,76,108,-1,76,109,108,-1,76,77,109,-1,77,110,109,-1,77,78,110,-1,78,111,110,-1,78,79,111,-1,79,112,111,-1,79,80,112,-1,80,113,112,-1,80,81,113,-1,81,114,113,-1,81,82,114,-1,82,115,114,-1,82,83,115,-1,83,116,115,-1,83,84,116,-1,84,117,116,-1,84,85,117,-1,85,118,117,-1,85,86,118,-1,86,119,118,-1,86,87,119,-1,87,120,119,-1,87,88,120,-1,88,89,120,-1,88,57,89,-1,89,122,121,-1,89,90,122,-1,90,123,122,-1,90,91,123,-1,91,124,123,-1,91,92,124,-1,92,125,124,-1,92,93,125,-1,93,126,125,-1,93,94,126,-1,94,127,126,-1,94,95,127,-1,95,128,127,-1,95,96,128,-1,96,129,128,-1,96,97,129,-1,97,130,129,-1,97,98,130,-1,98,131,130,-1,98,99,131,-1,99,132,131,-1,99,100,132,-1,100,133,132,-1,100,101,133,-1,101,134,133,-1,101,102,134,-1,102,135,134,-1,102,103,135,-1,103,136,135,-1,103,104,136,-1,104,137,136,-1,104,105,137,-1,105,138,137,-1,105,106,138,-1,106,139,138,-1,106,107,139,-1,107,140,139,-1,107,108,140,-1,108,141,140,-1,108,109,141,-1,109,142,141,-1,109,110,142,-1,110,143,142,-1,110,111,143,-1,111,144,143,-1,111,112,144,-1,112,145,144,-1,112,113,145,-1,113,146,145,-1,113,114,146,-1,114,147,146,-1,114,115,147,-1,115,148,147,-1,115,116,148,-1,116,149,148,-1,116,117,149,-1,117,150,149,-1,117,118,150,-1,118,151,150,-1,118,119,151,-1,119,152,151,-1,119,120,152,-1,120,121,152,-1,120,89,121,-1,121,154,153,-1,121,122,154,-1,122,155,154,-1,122,123,155,-1,123,156,155,-1,123,124,156,-1,124,157,156,-1,124,125,157,-1,125,158,157,-1,125,126,158,-1,126,159,158,-1,126,127,159,-1,127,160,159,-1,127,128,160,-1,128,161,160,-1,128,129,161,-1,129,162,161,-1,129,130,162,-1,130,163,162,-1,130,131,163,-1,131,164,163,-1,131,132,164,-1,132,165,164,-1,132,133,165,-1,133,166,165,-1,133,134,166,-1,134,167,166,-1,134,135,167,-1,135,168,167,-1,135,136,168,-1,136,169,168,-1,136,137,169,-1,137,170,169,-1,137,138,170,-1,138,171,170,-1,138,139,171,-1,139,172,171,-1,139,140,172,-1,140,173,172,-1,140,141,173,-1,141,174,173,-1,141,142,174,-1,142,175,174,-1,142,143,175,-1,143,176,175,-1,143,144,176,-1,144,177,176,-1,144,145,177,-1,145,178,177,-1,145,146,178,-1,146,179,178,-1,146,147,179,-1,147,180,179,-1,147,148,180,-1,148,181,180,-1,148,149,181,-1,149,182,181,-1,149,150,182,-1,150,183,182,-1,150,151,183,-1,151,184,183,-1,151,152,184,-1,152,153,184,-1,152,121,153,-1,185,442,443,-1,185,443,444,-1,185,444,445,-1,185,445,446,-1,185,446,447,-1,185,447,448,-1,185,448,449,-1,185,449,450,-1,185,450,451,-1,185,451,452,-1,185,452,453,-1,185,453,454,-1,185,454,455,-1,185,455,456,-1,185,456,457,-1,185,457,458,-1,185,458,459,-1,185,459,460,-1,185,460,461,-1,185,461,462,-1,185,462,463,-1,185,463,464,-1,185,464,465,-1,185,465,466,-1,185,466,467,-1,185,467,468,-1,185,468,469,-1,185,469,470,-1,185,470,471,-1,185,471,472,-1,185,472,473,-1,185,473,442,-1,153,154,187,-1,187,186,153,-1,154,155,188,-1,188,187,154,-1,155,156,189,-1,189,188,155,-1,156,157,190,-1,190,189,156,-1,157,158,191,-1,191,190,157,-1,158,159,192,-1,192,191,158,-1,159,160,193,-1,193,192,159,-1,160,161,194,-1,194,193,160,-1,161,162,195,-1,195,194,161,-1,162,163,196,-1,196,195,162,-1,163,164,197,-1,197,196,163,-1,164,165,198,-1,198,197,164,-1,165,166,199,-1,199,198,165,-1,166,167,200,-1,200,199,166,-1,167,168,201,-1,201,200,167,-1,168,169,202,-1,202,201,168,-1,169,170,203,-1,203,202,169,-1,170,171,204,-1,204,203,170,-1,171,172,205,-1,205,204,171,-1,172,173,206,-1,206,205,172,-1,173,174,207,-1,207,206,173,-1,174,175,208,-1,208,207,174,-1,175,176,209,-1,209,208,175,-1,176,177,210,-1,210,209,176,-1,177,178,211,-1,211,210,177,-1,178,179,212,-1,212,211,178,-1,179,180,213,-1,213,212,179,-1,180,181,214,-1,214,213,180,-1,181,182,215,-1,215,214,181,-1,182,183,216,-1,216,215,182,-1,183,184,217,-1,217,216,183,-1,184,153,186,-1,186,217,184,-1,186,187,219,-1,219,218,186,-1,187,188,220,-1,220,219,187,-1,188,189,221,-1,221,220,188,-1,189,190,222,-1,222,221,189,-1,190,191,223,-1,223,222,190,-1,191,192,224,-1,224,223,191,-1,192,193,225,-1,225,224,192,-1,193,194,226,-1,226,225,193,-1,194,195,227,-1,227,226,194,-1,195,196,228,-1,228,227,195,-1,196,197,229,-1,229,228,196,-1,197,198,230,-1,230,229,197,-1,198,199,231,-1,231,230,198,-1,199,200,232,-1,232,231,199,-1,200,201,233,-1,233,232,200,-1,201,202,234,-1,234,233,201,-1,202,203,235,-1,235,234,202,-1,203,204,236,-1,236,235,203,-1,204,205,237,-1,237,236,204,-1,205,206,238,-1,238,237,205,-1,206,207,239,-1,239,238,206,-1,207,208,240,-1,240,239,207,-1,208,209,241,-1,241,240,208,-1,209,210,242,-1,242,241,209,-1,210,211,243,-1,243,242,210,-1,211,212,244,-1,244,243,211,-1,212,213,245,-1,245,244,212,-1,213,214,246,-1,246,245,213,-1,214,215,247,-1,247,246,214,-1,215,216,248,-1,248,247,215,-1,216,217,249,-1,249,248,216,-1,217,186,218,-1,218,249,217,-1,218,219,251,-1,251,250,218,-1,219,220,252,-1,252,251,219,-1,220,221,253,-1,253,252,220,-1,221,222,254,-1,254,253,221,-1,222,223,255,-1,255,254,222,-1,223,224,256,-1,256,255,223,-1,224,225,257,-1,257,256,224,-1,225,226,258,-1,258,257,225,-1,226,227,259,-1,259,258,226,-1,227,228,260,-1,260,259,227,-1,228,229,261,-1,261,260,228,-1,229,230,262,-1,262,261,229,-1,230,231,263,-1,263,262,230,-1,231,232,264,-1,264,263,231,-1,232,233,265,-1,265,264,232,-1,233,234,266,-1,266,265,233,-1,234,235,267,-1,267,266,234,-1,235,236,268,-1,268,267,235,-1,236,237,269,-1,269,268,236,-1,237,238,270,-1,270,269,237,-1,238,239,271,-1,271,270,238,-1,239,240,272,-1,272,271,239,-1,240,241,273,-1,273,272,240,-1,241,242,274,-1,274,273,241,-1,242,243,275,-1,275,274,242,-1,243,244,276,-1,276,275,243,-1,244,245,277,-1,277,276,244,-1,245,246,278,-1,278,277,245,-1,246,247,279,-1,279,278,246,-1,247,248,280,-1,280,279,247,-1,248,249,281,-1,281,280,248,-1,249,218,250,-1,250,281,249,-1,250,251,283,-1,283,282,250,-1,251,252,284,-1,284,283,251,-1,252,253,285,-1,285,284,252,-1,253,254,286,-1,286,285,253,-1,254,255,287,-1,287,286,254,-1,255,256,288,-1,288,287,255,-1,256,257,289,-1,289,288,256,-1,257,258,290,-1,290,289,257,-1,258,259,291,-1,291,290,258,-1,259,260,292,-1,292,291,259,-1,260,261,293,-1,293,292,260,-1,261,262,294,-1,294,293,261,-1,262,263,295,-1,295,294,262,-1,263,264,296,-1,296,295,263,-1,264,265,297,-1,297,296,264,-1,265,266,298,-1,298,297,265,-1,266,267,299,-1,299,298,266,-1,267,268,300,-1,300,299,267,-1,268,269,301,-1,301,300,268,-1,269,270,302,-1,302,301,269,-1,270,271,303,-1,303,302,270,-1,271,272,304,-1,304,303,271,-1,272,273,305,-1,305,304,272,-1,273,274,306,-1,306,305,273,-1,274,275,307,-1,307,306,274,-1,275,276,308,-1,308,307,275,-1,276,277,309,-1,309,308,276,-1,277,278,310,-1,310,309,277,-1,278,279,311,-1,311,310,278,-1,279,280,312,-1,312,311,279,-1,280,281,313,-1,313,312,280,-1,281,250,282,-1,282,313,281,-1,282,283,315,-1,315,314,282,-1,283,284,316,-1,316,315,283,-1,284,285,317,-1,317,316,284,-1,285,286,318,-1,318,317,285,-1,286,287,319,-1,319,318,286,-1,287,288,320,-1,320,319,287,-1,288,289,321,-1,321,320,288,-1,289,290,322,-1,322,321,289,-1,290,291,323,-1,323,322,290,-1,291,292,324,-1,324,323,291,-1,292,293,325,-1,325,324,292,-1,293,294,326,-1,326,325,293,-1,294,295,327,-1,327,326,294,-1,295,296,328,-1,328,327,295,-1,296,297,329,-1,329,328,296,-1,297,298,330,-1,330,329,297,-1,298,299,331,-1,331,330,298,-1,299,300,332,-1,332,331,299,-1,300,301,333,-1,333,332,300,-1,301,302,334,-1,334,333,301,-1,302,303,335,-1,335,334,302,-1,303,304,336,-1,336,335,303,-1,304,305,337,-1,337,336,304,-1,305,306,338,-1,338,337,305,-1,306,307,339,-1,339,338,306,-1,307,308,340,-1,340,339,307,-1,308,309,341,-1,341,340,308,-1,309,310,342,-1,342,341,309,-1,310,311,343,-1,343,342,310,-1,311,312,344,-1,344,343,311,-1,312,313,345,-1,345,344,312,-1,313,282,314,-1,314,345,313,-1,314,315,347,-1,347,346,314,-1,315,316,348,-1,348,347,315,-1,316,317,349,-1,349,348,316,-1,317,318,350,-1,350,349,317,-1,318,319,351,-1,351,350,318,-1,319,320,352,-1,352,351,319,-1,320,321,353,-1,353,352,320,-1,321,322,354,-1,354,353,321,-1,322,323,355,-1,355,354,322,-1,323,324,356,-1,356,355,323,-1,324,325,357,-1,357,356,324,-1,325,326,358,-1,358,357,325,-1,326,327,359,-1,359,358,326,-1,327,328,360,-1,360,359,327,-1,328,329,361,-1,361,360,328,-1,329,330,362,-1,362,361,329,-1,330,331,363,-1,363,362,330,-1,331,332,364,-1,364,363,331,-1,332,333,365,-1,365,364,332,-1,333,334,366,-1,366,365,333,-1,334,335,367,-1,367,366,334,-1,335,336,368,-1,368,367,335,-1,336,337,369,-1,369,368,336,-1,337,338,370,-1,370,369,337,-1,338,339,371,-1,371,370,338,-1,339,340,372,-1,372,371,339,-1,340,341,373,-1,373,372,340,-1,341,342,374,-1,374,373,341,-1,342,343,375,-1,375,374,342,-1,343,344,376,-1,376,375,343,-1,344,345,377,-1,377,376,344,-1,345,314,346,-1,346,377,345,-1,346,347,379,-1,379,378,346,-1,347,348,380,-1,380,379,347,-1,348,349,381,-1,381,380,348,-1,349,350,382,-1,382,381,349,-1,350,351,383,-1,383,382,350,-1,351,352,384,-1,384,383,351,-1,352,353,385,-1,385,384,352,-1,353,354,386,-1,386,385,353,-1,354,355,387,-1,387,386,354,-1,355,356,388,-1,388,387,355,-1,356,357,389,-1,389,388,356,-1,357,358,390,-1,390,389,357,-1,358,359,391,-1,391,390,358,-1,359,360,392,-1,392,391,359,-1,360,361,393,-1,393,392,360,-1,361,362,394,-1,394,393,361,-1,362,363,395,-1,395,394,362,-1,363,364,396,-1,396,395,363,-1,364,365,397,-1,397,396,364,-1,365,366,398,-1,398,397,365,-1,366,367,399,-1,399,398,366,-1,367,368,400,-1,400,399,367,-1,368,369,401,-1,401,400,368,-1,369,370,402,-1,402,401,369,-1,370,371,403,-1,403,402,370,-1,371,372,404,-1,404,403,371,-1,372,373,405,-1,405,404,372,-1,373,374,406,-1,406,405,373,-1,374,375,407,-1,407,406,374,-1,375,376,408,-1,408,407,375,-1,376,377,409,-1,409,408,376,-1,377,346,378,-1,378,409,377,-1,378,379,411,-1,411,410,378,-1,379,380,412,-1,412,411,379,-1,380,381,413,-1,413,412,380,-1,381,382,414,-1,414,413,381,-1,382,383,415,-1,415,414,382,-1,383,384,416,-1,416,415,383,-1,384,385,417,-1,417,416,384,-1,385,386,418,-1,418,417,385,-1,386,387,419,-1,419,418,386,-1,387,388,420,-1,420,419,387,-1,388,389,421,-1,421,420,388,-1,389,390,422,-1,422,421,389,-1,390,391,423,-1,423,422,390,-1,391,392,424,-1,424,423,391,-1,392,393,425,-1,425,424,392,-1,393,394,426,-1,426,425,393,-1,394,395,427,-1,427,426,394,-1,395,396,428,-1,428,427,395,-1,396,397,429,-1,429,428,396,-1,397,398,430,-1,430,429,397,-1,398,399,431,-1,431,430,398,-1,399,400,432,-1,432,431,399,-1,400,401,433,-1,433,432,400,-1,401,402,434,-1,434,433,401,-1,402,403,435,-1,435,434,402,-1,403,404,436,-1,436,435,403,-1,404,405,437,-1,437,436,404,-1,405,406,438,-1,438,437,405,-1,406,407,439,-1,439,438,406,-1,407,408,440,-1,440,439,407,-1,408,409,441,-1,441,440,408,-1,409,378,410,-1,410,441,409,-1,410,411,443,-1,443,442,410,-1,411,412,444,-1,444,443,411,-1,412,413,445,-1,445,444,412,-1,413,414,446,-1,446,445,413,-1,414,415,447,-1,447,446,414,-1,415,416,448,-1,448,447,415,-1,416,417,449,-1,449,448,416,-1,417,418,450,-1,450,449,417,-1,418,419,451,-1,451,450,418,-1,419,420,452,-1,452,451,419,-1,420,421,453,-1,453,452,420,-1,421,422,454,-1,454,453,421,-1,422,423,455,-1,455,454,422,-1,423,424,456,-1,456,455,423,-1,424,425,457,-1,457,456,424,-1,425,426,458,-1,458,457,425,-1,426,427,459,-1,459,458,426,-1,427,428,460,-1,460,459,427,-1,428,429,461,-1,461,460,428,-1,429,430,462,-1,462,461,429,-1,430,431,463,-1,463,462,430,-1,431,432,464,-1,464,463,431,-1,432,433,465,-1,465,464,432,-1,433,434,466,-1,466,465,433,-1,434,435,467,-1,467,466,434,-1,435,436,468,-1,468,467,435,-1,436,437,469,-1,469,468,436,-1,437,438,470,-1,470,469,437,-1,438,439,471,-1,471,470,438,-1,439,440,472,-1,472,471,439,-1,440,441,473,-1,473,472,440,-1,441,410,442,-1,442,473,441,-1,474,476,475,-1,474,477,476,-1,474,478,477,-1,474,479,478,-1,474,480,479,-1,474,481,480,-1,474,482,481,-1,474,483,482,-1,474,484,483,-1,474,485,484,-1,474,486,485,-1,474,487,486,-1,474,488,487,-1,474,489,488,-1,474,490,489,-1,474,491,490,-1,474,492,491,-1,474,493,492,-1,474,494,493,-1,474,495,494,-1,474,496,495,-1,474,497,496,-1,474,498,497,-1,474,475,498,-1,475,500,499,-1,475,476,500,-1,476,501,500,-1,476,477,501,-1,477,502,501,-1,477,478,502,-1,478,503,502,-1,478,479,503,-1,479,504,503,-1,479,480,504,-1,480,505,504,-1,480,481,505,-1,481,506,505,-1,481,482,506,-1,482,507,506,-1,482,483,507,-1,483,508,507,-1,483,484,508,-1,484,509,508,-1,484,485,509,-1,485,510,509,-1,485,486,510,-1,486,511,510,-1,486,487,511,-1,487,512,511,-1,487,488,512,-1,488,513,512,-1,488,489,513,-1,489,514,513,-1,489,490,514,-1,490,515,514,-1,490,491,515,-1,491,516,515,-1,491,492,516,-1,492,517,516,-1,492,493,517,-1,493,518,517,-1,493,494,518,-1,494,519,518,-1,494,495,519,-1,495,520,519,-1,495,496,520,-1,496,521,520,-1,496,497,521,-1,497,522,521,-1,497,498,522,-1,498,499,522,-1,498,475,499,-1,499,524,523,-1,499,500,524,-1,500,525,524,-1,500,501,525,-1,501,526,525,-1,501,502,526,-1,502,527,526,-1,502,503,527,-1,503,528,527,-1,503,504,528,-1,504,529,528,-1,504,505,529,-1,505,530,529,-1,505,506,530,-1,506,531,530,-1,506,507,531,-1,507,532,531,-1,507,508,532,-1,508,533,532,-1,508,509,533,-1,509,534,533,-1,509,510,534,-1,510,535,534,-1,510,511,535,-1,511,536,535,-1,511,512,536,-1,512,537,536,-1,512,513,537,-1,513,538,537,-1,513,514,538,-1,514,539,538,-1,514,515,539,-1,515,540,539,-1,515,516,540,-1,516,541,540,-1,516,517,541,-1,517,542,541,-1,517,518,542,-1,518,543,542,-1,518,519,543,-1,519,544,543,-1,519,520,544,-1,520,545,544,-1,520,521,545,-1,521,546,545,-1,521,522,546,-1,522,523,546,-1,522,499,523,-1,523,548,547,-1,523,524,548,-1,524,549,548,-1,524,525,549,-1,525,550,549,-1,525,526,550,-1,526,551,550,-1,526,527,551,-1,527,552,551,-1,527,528,552,-1,528,553,552,-1,528,529,553,-1,529,554,553,-1,529,530,554,-1,530,555,554,-1,530,531,555,-1,531,556,555,-1,531,532,556,-1,532,557,556,-1,532,533,557,-1,533,558,557,-1,533,534,558,-1,534,559,558,-1,534,535,559,-1,535,560,559,-1,535,536,560,-1,536,561,560,-1,536,537,561,-1,537,562,561,-1,537,538,562,-1,538,563,562,-1,538,539,563,-1,539,564,563,-1,539,540,564,-1,540,565,564,-1,540,541,565,-1,541,566,565,-1,541,542,566,-1,542,567,566,-1,542,543,567,-1,543,568,567,-1,543,544,568,-1,544,569,568,-1,544,545,569,-1,545,570,569,-1,545,546,570,-1,546,547,570,-1,546,523,547,-1,571,547,548,-1,571,548,549,-1,571,549,550,-1,571,550,551,-1,571,551,552,-1,571,552,553,-1,571,553,554,-1,571,554,555,-1,571,555,556,-1,571,556,557,-1,571,557,558,-1,571,558,559,-1,571,559,560,-1,571,560,561,-1,571,561,562,-1,571,562,563,-1,571,563,564,-1,571,564,565,-1,571,565,566,-1,571,566,567,-1,571,567,568,-1,571,568,569,-1,571,569,570,-1,571,570,547,-1,572,573,574,-1,572,574,575,-1,572,575,576,-1,572,576,577,-1,572,577,578,-1,572,578,579,-1,572,579,580,-1,572,580,581,-1,572,581,582,-1,572,582,583,-1,572,583,584,-1,572,584,585,-1,572,585,586,-1,572,586,587,-1,572,587,588,-1,572,588,589,-1,572,589,590,-1,572,590,573,-1,573,591,592,-1,573,592,574,-1,574,592,593,-1,574,593,575,-1,575,593,594,-1,575,594,576,-1,576,594,595,-1,576,595,577,-1,577,595,596,-1,577,596,578,-1,578,596,597,-1,578,597,579,-1,579,597,598,-1,579,598,580,-1,580,598,599,-1,580,599,581,-1,581,599,600,-1,581,600,582,-1,582,600,601,-1,582,601,583,-1,583,601,602,-1,583,602,584,-1,584,602,603,-1,584,603,585,-1,585,603,604,-1,585,604,586,-1,586,604,605,-1,586,605,587,-1,587,605,606,-1,587,606,588,-1,588,606,607,-1,588,607,589,-1,589,607,608,-1,589,608,590,-1,590,608,591,-1,590,591,573,-1,591,609,610,-1,591,610,592,-1,592,610,611,-1,592,611,593,-1,593,611,612,-1,593,612,594,-1,594,612,613,-1,594,613,595,-1,595,613,614,-1,595,614,596,-1,596,614,615,-1,596,615,597,-1,597,615,616,-1,597,616,598,-1,598,616,617,-1,598,617,599,-1,599,617,618,-1,599,618,600,-1,600,618,619,-1,600,619,601,-1,601,619,620,-1,601,620,602,-1,602,620,621,-1,602,621,603,-1,603,621,622,-1,603,622,604,-1,604,622,623,-1,604,623,605,-1,605,623,624,-1,605,624,606,-1,606,624,625,-1,606,625,607,-1,607,625,626,-1,607,626,608,-1,608,626,609,-1,608,609,591,-1,609,627,628,-1,609,628,610,-1,610,628,629,-1,610,629,611,-1,611,629,630,-1,611,630,612,-1,612,630,631,-1,612,631,613,-1,613,631,632,-1,613,632,614,-1,614,632,633,-1,614,633,615,-1,615,633,634,-1,615,634,616,-1,616,634,635,-1,616,635,617,-1,617,635,636,-1,617,636,618,-1,618,636,637,-1,618,637,619,-1,619,637,638,-1,619,638,620,-1,620,638,639,-1,620,639,621,-1,621,639,640,-1,621,640,622,-1,622,640,641,-1,622,641,623,-1,623,641,642,-1,623,642,624,-1,624,642,643,-1,624,643,625,-1,625,643,644,-1,625,644,626,-1,626,644,627,-1,626,627,609,-1,627,645,646,-1,627,646,628,-1,628,646,647,-1,628,647,629,-1,629,647,648,-1,629,648,630,-1,630,648,649,-1,630,649,631,-1,631,649,650,-1,631,650,632,-1,632,650,651,-1,632,651,633,-1,633,651,652,-1,633,652,634,-1,634,652,653,-1,634,653,635,-1,635,653,654,-1,635,654,636,-1,636,654,655,-1,636,655,637,-1,637,655,656,-1,637,656,638,-1,638,656,657,-1,638,657,639,-1,639,657,658,-1,639,658,640,-1,640,658,659,-1,640,659,641,-1,641,659,660,-1,641,660,642,-1,642,660,661,-1,642,661,643,-1,643,661,662,-1,643,662,644,-1,644,662,645,-1,644,645,627,-1,645,663,664,-1,645,664,646,-1,646,664,665,-1,646,665,647,-1,647,665,666,-1,647,666,648,-1,648,666,667,-1,648,667,649,-1,649,667,668,-1,649,668,650,-1,650,668,669,-1,650,669,651,-1,651,669,670,-1,651,670,652,-1,652,670,671,-1,652,671,653,-1,653,671,672,-1,653,672,654,-1,654,672,673,-1,654,673,655,-1,655,673,674,-1,655,674,656,-1,656,674,675,-1,656,675,657,-1,657,675,676,-1,657,676,658,-1,658,676,677,-1,658,677,659,-1,659,677,678,-1,659,678,660,-1,660,678,679,-1,660,679,661,-1,661,679,680,-1,661,680,662,-1,662,680,663,-1,662,663,645,-1,663,681,682,-1,663,682,664,-1,664,682,683,-1,664,683,665,-1,665,683,684,-1,665,684,666,-1,666,684,685,-1,666,685,667,-1,667,685,686,-1,667,686,668,-1,668,686,687,-1,668,687,669,-1,669,687,688,-1,669,688,670,-1,670,688,689,-1,670,689,671,-1,671,689,690,-1,671,690,672,-1,672,690,691,-1,672,691,673,-1,673,691,692,-1,673,692,674,-1,674,692,693,-1,674,693,675,-1,675,693,694,-1,675,694,676,-1,676,694,695,-1,676,695,677,-1,677,695,696,-1,677,696,678,-1,678,696,697,-1,678,697,679,-1,679,697,698,-1,679,698,680,-1,680,698,681,-1,680,681,663,-1,681,699,700,-1,681,700,682,-1,682,700,701,-1,682,701,683,-1,683,701,702,-1,683,702,684,-1,684,702,703,-1,684,703,685,-1,685,703,704,-1,685,704,686,-1,686,704,705,-1,686,705,687,-1,687,705,706,-1,687,706,688,-1,688,706,707,-1,688,707,689,-1,689,707,708,-1,689,708,690,-1,690,708,709,-1,690,709,691,-1,691,709,710,-1,691,710,692,-1,692,710,711,-1,692,711,693,-1,693,711,712,-1,693,712,694,-1,694,712,713,-1,694,713,695,-1,695,713,714,-1,695,714,696,-1,696,714,715,-1,696,715,697,-1,697,715,716,-1,697,716,698,-1,698,716,699,-1,698,699,681,-1,717,700,699,-1,717,701,700,-1,717,702,701,-1,717,703,702,-1,717,704,703,-1,717,705,704,-1,717,706,705,-1,717,707,706,-1,717,708,707,-1,717,709,708,-1,717,710,709,-1,717,711,710,-1,717,712,711,-1,717,713,712,-1,717,714,713,-1,717,715,714,-1,717,716,715,-1,717,699,716,-1],
          coord=Coordinate(point=[(-93.63,0,65.71),(93.63,0,65.71),(-93.63,0,-52.08),(93.63,0,-52.08),(-93.63,-12.19,65.71),(93.63,-12.19,65.71),(-93.63,-12.19,-52.08),(93.63,-12.19,-52.08),(-94.53,-6.094,66.21),(94.53,-6.094,66.21),(94.53,-6.094,-52.58),(-94.53,-6.094,-52.58),(-92.73,0.6,64.53),(92.73,0.6,64.53),(-92.73,0.6,-50.9),(92.73,0.6,-50.9),(-85.06,0.7,50.59),(85.06,0.7,50.59),(-85.06,0.7,-44.32),(85.06,0.7,-44.32),(-84.25,-0.1,49.47),(84.25,-0.1,49.47),(-84.25,-0.1,-43.2),(84.25,-0.1,-43.2),(-84.25,-7.6,49.47),(84.25,-7.6,49.47),(-84.25,-7.6,-43.2),(84.25,-7.6,-43.2),(-91.33,-14.73,63.41),(91.33,-14.73,63.41),(-91.33,-14.73,-49.78),(91.33,-14.73,-49.78),(-79.63,-22.79,51.71),(79.63,-22.79,51.71),(-79.63,-22.79,-38.08),(79.63,-22.79,-38.08),(-42.35,-44.29,43.29),(42.35,-44.29,43.29),(-42.35,-44.29,-29.66),(42.35,-44.29,-29.66),(-16.47,-48.99,37.56),(16.47,-48.99,37.56),(-16.47,-48.99,-23.93),(16.47,-48.99,-23.93),(-15.72,-15.4,62.47),(18.78,-15.4,62.47),(-15.74,-19.93,55.8),(18.79,-19.93,55.8),(-15.72,-16.26,62.77),(18.78,-16.26,62.77),(-15.74,-20.8,56.1),(18.79,-20.8,56.1),(-87.85,-3.1,55.89),(87.85,-3.1,55.89),(-87.85,-3.1,-48.52),(87.85,-3.1,-48.52),(0,-23.46,88.97),(45.88,-23.46,89.27),(44.99,-33.86,89.27),(42.38,-43.86,89.27),(38.14,-53.08,89.27),(32.44,-61.16,89.27),(25.49,-67.79,89.27),(17.56,-72.72,89.27),(8.95,-75.75,89.27),(0,-76.78,89.27),(-8.95,-75.75,89.27),(-17.56,-72.72,89.27),(-25.49,-67.79,89.27),(-32.44,-61.16,89.27),(-38.14,-53.08,89.27),(-42.38,-43.86,89.27),(-44.99,-33.86,89.27),(-45.88,-23.46,89.27),(-44.99,-13.06,89.27),(-42.38,-3.056,89.27),(-38.14,6.162,89.27),(-32.44,14.24,89.27),(-25.49,20.87,89.27),(-17.56,25.8,89.27),(-8.95,28.83,89.27),(0,29.86,89.27),(8.95,28.83,89.27),(17.56,25.8,89.27),(25.49,20.87,89.27),(32.44,14.24,89.27),(38.14,6.162,89.27),(42.38,-3.056,89.27),(44.99,-13.06,89.27),(46.32,-23.46,89.04),(45.43,-33.96,89.04),(42.79,-44.06,89.04),(38.51,-53.37,89.04),(32.75,-61.52,89.04),(25.73,-68.22,89.04),(17.73,-73.19,89.04),(9.037,-76.26,89.04),(0,-77.29,89.04),(-9.037,-76.26,89.04),(-17.73,-73.19,89.04),(-25.73,-68.22,89.04),(-32.75,-61.52,89.04),(-38.51,-53.37,89.04),(-42.79,-44.06,89.04),(-45.43,-33.96,89.04),(-46.32,-23.46,89.04),(-45.43,-12.96,89.04),(-42.79,-2.858,89.04),(-38.51,6.449,89.04),(-32.75,14.61,89.04),(-25.73,21.3,89.04),(-17.73,26.28,89.04),(-9.037,29.34,89.04),(0,30.37,89.04),(9.037,29.34,89.04),(17.73,26.28,89.04),(25.73,21.3,89.04),(32.75,14.61,89.04),(38.51,6.449,89.04),(42.79,-2.858,89.04),(45.43,-12.96,89.04),(46.32,-23.46,86.93),(45.43,-33.96,86.93),(42.79,-44.06,86.93),(38.51,-53.37,86.93),(32.75,-61.52,86.93),(25.73,-68.22,86.93),(17.73,-73.19,86.93),(9.037,-76.26,86.93),(0,-77.29,86.93),(-9.037,-76.26,86.93),(-17.73,-73.19,86.93),(-25.73,-68.22,86.93),(-32.75,-61.52,86.93),(-38.51,-53.37,86.93),(-42.79,-44.06,86.93),(-45.43,-33.96,86.93),(-46.32,-23.46,86.93),(-45.43,-12.96,86.93),(-42.79,-2.858,86.93),(-38.51,6.449,86.93),(-32.75,14.61,86.93),(-25.73,21.3,86.93),(-17.73,26.28,86.93),(-9.037,29.34,86.93),(0,30.37,86.93),(9.037,29.34,86.93),(17.73,26.28,86.93),(25.73,21.3,86.93),(32.75,14.61,86.93),(38.51,6.449,86.93),(42.79,-2.858,86.93),(45.43,-12.96,86.93),(45.88,-23.46,86.69),(44.99,-33.86,86.69),(42.38,-43.86,86.69),(38.14,-53.08,86.69),(32.44,-61.16,86.69),(25.49,-67.79,86.69),(17.56,-72.72,86.69),(8.95,-75.75,86.69),(0,-76.78,86.69),(-8.95,-75.75,86.69),(-17.56,-72.72,86.69),(-25.49,-67.79,86.69),(-32.44,-61.16,86.69),(-38.14,-53.08,86.69),(-42.38,-43.86,86.69),(-44.99,-33.86,86.69),(-45.88,-23.46,86.69),(-44.99,-13.06,86.69),(-42.38,-3.056,86.69),(-38.14,6.162,86.69),(-32.44,14.24,86.69),(-25.49,20.87,86.69),(-17.56,25.8,86.69),(-8.95,28.83,86.69),(0,29.86,86.69),(8.95,28.83,86.69),(17.56,25.8,86.69),(25.49,20.87,86.69),(32.44,14.24,86.69),(38.14,6.162,86.69),(42.38,-3.056,86.69),(44.99,-13.06,86.69),(0,-23.46,61.28),(35.55,-23.46,86.42),(34.87,-31.52,86.42),(32.84,-39.27,86.42),(29.56,-46.41,86.42),(25.14,-52.67,86.42),(19.75,-57.81,86.42),(13.6,-61.63,86.42),(6.935,-63.98,86.42),(0,-64.77,86.42),(-6.935,-63.98,86.42),(-13.6,-61.63,86.42),(-19.75,-57.81,86.42),(-25.14,-52.67,86.42),(-29.56,-46.41,86.42),(-32.84,-39.27,86.42),(-34.87,-31.52,86.42),(-35.55,-23.46,86.42),(-34.87,-15.4,86.42),(-32.84,-7.649,86.42),(-29.56,-0.5062,86.42),(-25.14,5.754,86.42),(-19.75,10.89,86.42),(-13.6,14.71,86.42),(-6.935,17.06,86.42),(0,17.86,86.42),(6.935,17.06,86.42),(13.6,14.71,86.42),(19.75,10.89,86.42),(25.14,5.754,86.42),(29.56,-0.5062,86.42),(32.84,-7.649,86.42),(34.87,-15.4,86.42),(25.1,-23.46,85.75),(24.62,-29.15,85.75),(23.19,-34.62,85.75),(20.87,-39.66,85.75),(17.75,-44.08,85.75),(13.94,-47.71,85.75),(9.604,-50.41,85.75),(4.896,-52.07,85.75),(0,-52.63,85.75),(-4.896,-52.07,85.75),(-9.604,-50.41,85.75),(-13.94,-47.71,85.75),(-17.75,-44.08,85.75),(-20.87,-39.66,85.75),(-23.19,-34.62,85.75),(-24.62,-29.15,85.75),(-25.1,-23.46,85.75),(-24.62,-17.77,85.75),(-23.19,-12.3,85.75),(-20.87,-7.254,85.75),(-17.75,-2.834,85.75),(-13.94,0.7933,85.75),(-9.604,3.489,85.75),(-4.896,5.149,85.75),(0,5.709,85.75),(4.896,5.149,85.75),(9.604,3.489,85.75),(13.94,0.7933,85.75),(17.75,-2.834,85.75),(20.87,-7.254,85.75),(23.19,-12.3,85.75),(24.62,-17.77,85.75),(14.27,-23.46,84.16),(14,-26.7,84.16),(13.19,-29.81,84.16),(11.87,-32.68,84.16),(10.09,-35.19,84.16),(7.93,-37.25,84.16),(5.462,-38.79,84.16),(2.785,-39.73,84.16),(0,-40.05,84.16),(-2.785,-39.73,84.16),(-5.462,-38.79,84.16),(-7.93,-37.25,84.16),(-10.09,-35.19,84.16),(-11.87,-32.68,84.16),(-13.19,-29.81,84.16),(-14,-26.7,84.16),(-14.27,-23.46,84.16),(-14,-20.22,84.16),(-13.19,-17.11,84.16),(-11.87,-14.24,84.16),(-10.09,-11.73,84.16),(-7.93,-9.666,84.16),(-5.462,-8.133,84.16),(-2.785,-7.189,84.16),(0,-6.87,84.16),(2.785,-7.189,84.16),(5.462,-8.133,84.16),(7.93,-9.666,84.16),(10.09,-11.73,84.16),(11.87,-14.24,84.16),(13.19,-17.11,84.16),(14,-20.22,84.16),(10.82,-23.46,81.9),(10.61,-24.51,81.9),(9.996,-25.53,81.9),(8.996,-26.47,81.9),(7.651,-27.29,81.9),(6.011,-27.96,81.9),(4.14,-28.46,81.9),(2.111,-28.77,81.9),(0,-28.87,81.9),(-2.111,-28.77,81.9),(-4.141,-28.46,81.9),(-6.011,-27.96,81.9),(-7.651,-27.29,81.9),(-8.996,-26.47,81.9),(-9.996,-25.53,81.9),(-10.61,-24.51,81.9),(-10.82,-23.46,81.9),(-10.61,-22.4,81.9),(-9.996,-21.39,81.9),(-8.996,-20.45,81.9),(-7.651,-19.63,81.9),(-6.011,-18.96,81.9),(-4.14,-18.46,81.9),(-2.111,-18.15,81.9),(0,-18.05,81.9),(2.111,-18.15,81.9),(4.14,-18.46,81.9),(6.011,-18.96,81.9),(7.651,-19.63,81.9),(8.996,-20.45,81.9),(9.996,-21.39,81.9),(10.61,-22.4,81.9),(10.82,-23.46,66.47),(10.61,-24.51,66.47),(9.996,-25.53,66.47),(8.996,-26.47,66.47),(7.651,-27.29,66.47),(6.011,-27.96,66.47),(4.14,-28.46,66.47),(2.111,-28.77,66.47),(0,-28.87,66.47),(-2.111,-28.77,66.47),(-4.141,-28.46,66.47),(-6.011,-27.96,66.47),(-7.651,-27.29,66.47),(-8.996,-26.47,66.47),(-9.996,-25.53,66.47),(-10.61,-24.51,66.47),(-10.82,-23.46,66.47),(-10.61,-22.4,66.47),(-9.996,-21.39,66.47),(-8.996,-20.45,66.47),(-7.651,-19.63,66.47),(-6.011,-18.96,66.47),(-4.14,-18.46,66.47),(-2.111,-18.15,66.47),(0,-18.05,66.47),(2.111,-18.15,66.47),(4.14,-18.46,66.47),(6.011,-18.96,66.47),(7.651,-19.63,66.47),(8.996,-20.45,66.47),(9.996,-21.39,66.47),(10.61,-22.4,66.47),(10.77,-23.46,65.57),(10.56,-24.57,65.57),(9.948,-25.63,65.57),(8.953,-26.61,65.57),(7.614,-27.47,65.57),(5.982,-28.18,65.57),(4.121,-28.7,65.57),(2.101,-29.02,65.57),(0,-29.13,65.57),(-2.101,-29.02,65.57),(-4.121,-28.7,65.57),(-5.982,-28.18,65.57),(-7.614,-27.47,65.57),(-8.953,-26.61,65.57),(-9.948,-25.63,65.57),(-10.56,-24.57,65.57),(-10.77,-23.46,65.57),(-10.56,-22.35,65.57),(-9.948,-21.29,65.57),(-8.953,-20.31,65.57),(-7.614,-19.45,65.57),(-5.982,-18.74,65.57),(-4.121,-18.22,65.57),(-2.101,-17.9,65.57),(0,-17.79,65.57),(2.101,-17.9,65.57),(4.121,-18.22,65.57),(5.982,-18.74,65.57),(7.614,-19.45,65.57),(8.953,-20.31,65.57),(9.948,-21.29,65.57),(10.56,-22.35,65.57),(10.77,-23.46,63.67),(10.56,-24.57,63.67),(9.948,-25.63,63.67),(8.953,-26.61,63.67),(7.614,-27.47,63.67),(5.982,-28.18,63.67),(4.121,-28.7,63.67),(2.101,-29.02,63.67),(0,-29.13,63.67),(-2.101,-29.02,63.67),(-4.121,-28.7,63.67),(-5.982,-28.18,63.67),(-7.614,-27.47,63.67),(-8.953,-26.61,63.67),(-9.948,-25.63,63.67),(-10.56,-24.57,63.67),(-10.77,-23.46,63.67),(-10.56,-22.35,63.67),(-9.948,-21.29,63.67),(-8.953,-20.31,63.67),(-7.614,-19.45,63.67),(-5.982,-18.74,63.67),(-4.121,-18.22,63.67),(-2.101,-17.9,63.67),(0,-17.79,63.67),(2.101,-17.9,63.67),(4.121,-18.22,63.67),(5.982,-18.74,63.67),(7.614,-19.45,63.67),(8.953,-20.31,63.67),(9.948,-21.29,63.67),(10.56,-22.35,63.67),(10.73,-23.46,61.68),(10.52,-24.32,61.68),(9.909,-25.14,61.68),(8.918,-25.9,61.68),(7.584,-26.57,61.68),(5.959,-27.11,61.68),(4.105,-27.52,61.68),(2.092,-27.77,61.68),(0,-27.86,61.68),(-2.092,-27.77,61.68),(-4.105,-27.52,61.68),(-5.959,-27.11,61.68),(-7.584,-26.57,61.68),(-8.918,-25.9,61.68),(-9.909,-25.14,61.68),(-10.52,-24.32,61.68),(-10.73,-23.46,61.68),(-10.52,-22.6,61.68),(-9.909,-21.78,61.68),(-8.918,-21.02,61.68),(-7.584,-20.35,61.68),(-5.959,-19.8,61.68),(-4.105,-19.4,61.68),(-2.092,-19.15,61.68),(0,-19.06,61.68),(2.092,-19.15,61.68),(4.105,-19.4,61.68),(5.959,-19.8,61.68),(7.584,-20.35,61.68),(8.918,-21.02,61.68),(9.909,-21.78,61.68),(10.52,-22.6,61.68),(5.981,-23.46,61.28),(5.866,-23.94,61.28),(5.526,-24.4,61.28),(4.973,-24.82,61.28),(4.229,-25.19,61.28),(3.323,-25.5,61.28),(2.289,-25.72,61.28),(1.167,-25.86,61.28),(0,-25.91,61.28),(-1.167,-25.86,61.28),(-2.289,-25.72,61.28),(-3.323,-25.5,61.28),(-4.229,-25.19,61.28),(-4.973,-24.82,61.28),(-5.526,-24.4,61.28),(-5.866,-23.94,61.28),(-5.981,-23.46,61.28),(-5.866,-22.98,61.28),(-5.526,-22.52,61.28),(-4.973,-22.1,61.28),(-4.229,-21.73,61.28),(-3.323,-21.42,61.28),(-2.289,-21.19,61.28),(-1.167,-21.05,61.28),(0,-21.01,61.28),(1.167,-21.05,61.28),(2.289,-21.19,61.28),(3.323,-21.42,61.28),(4.229,-21.73,61.28),(4.973,-22.1,61.28),(5.526,-22.52,61.28),(5.866,-22.98,61.28),(-9.671,-19.49,61.54),(-9.671,-16.57,61.54),(-9.671,-16.67,61.99),(-9.671,-16.97,62.42),(-9.671,-17.43,62.78),(-9.671,-18.03,63.07),(-9.671,-18.74,63.24),(-9.671,-19.49,63.3),(-9.671,-20.24,63.24),(-9.671,-20.95,63.07),(-9.671,-21.55,62.78),(-9.671,-22.02,62.42),(-9.671,-22.31,61.99),(-9.671,-22.41,61.54),(-9.671,-22.31,61.08),(-9.671,-22.02,60.65),(-9.671,-21.55,60.29),(-9.671,-20.95,60.01),(-9.671,-20.24,59.83),(-9.671,-19.49,59.77),(-9.671,-18.74,59.83),(-9.671,-18.03,60.01),(-9.671,-17.43,60.29),(-9.671,-16.97,60.65),(-9.671,-16.67,61.08),(-9.015,-16.41,61.54),(-9.015,-16.51,62.02),(-9.015,-16.82,62.47),(-9.015,-17.31,62.86),(-9.015,-17.95,63.15),(-9.015,-18.69,63.34),(-9.015,-19.49,63.41),(-9.015,-20.29,63.34),(-9.015,-21.03,63.15),(-9.015,-21.67,62.86),(-9.015,-22.16,62.47),(-9.015,-22.47,62.02),(-9.015,-22.57,61.54),(-9.015,-22.47,61.05),(-9.015,-22.16,60.6),(-9.015,-21.67,60.21),(-9.015,-21.03,59.92),(-9.015,-20.29,59.73),(-9.015,-19.49,59.67),(-9.015,-18.69,59.73),(-9.015,-17.95,59.92),(-9.015,-17.31,60.21),(-9.015,-16.82,60.6),(-9.015,-16.51,61.05),(9.015,-16.41,61.54),(9.015,-16.51,62.02),(9.015,-16.82,62.47),(9.015,-17.31,62.86),(9.015,-17.95,63.15),(9.015,-18.69,63.34),(9.015,-19.49,63.41),(9.015,-20.29,63.34),(9.015,-21.03,63.15),(9.015,-21.67,62.86),(9.015,-22.16,62.47),(9.015,-22.47,62.02),(9.015,-22.57,61.54),(9.015,-22.47,61.05),(9.015,-22.16,60.6),(9.015,-21.67,60.21),(9.015,-21.03,59.92),(9.015,-20.29,59.73),(9.015,-19.49,59.67),(9.015,-18.69,59.73),(9.015,-17.95,59.92),(9.015,-17.31,60.21),(9.015,-16.82,60.6),(9.015,-16.51,61.05),(9.671,-16.57,61.54),(9.671,-16.67,61.99),(9.671,-16.97,62.42),(9.671,-17.43,62.78),(9.671,-18.03,63.07),(9.671,-18.74,63.24),(9.671,-19.49,63.3),(9.671,-20.24,63.24),(9.671,-20.95,63.07),(9.671,-21.55,62.78),(9.671,-22.02,62.42),(9.671,-22.31,61.99),(9.671,-22.41,61.54),(9.671,-22.31,61.08),(9.671,-22.02,60.65),(9.671,-21.55,60.29),(9.671,-20.95,60.01),(9.671,-20.24,59.83),(9.671,-19.49,59.77),(9.671,-18.74,59.83),(9.671,-18.03,60.01),(9.671,-17.43,60.29),(9.671,-16.97,60.65),(9.671,-16.67,61.08),(9.671,-19.49,61.54),(79.83,2.008,56.13),(79.83,1.928,55.31),(79.55,1.928,55.36),(79.31,1.928,55.5),(79.12,1.928,55.72),(79.02,1.928,55.99),(79.02,1.928,56.27),(79.12,1.928,56.54),(79.31,1.928,56.76),(79.55,1.928,56.9),(79.83,1.928,56.95),(80.12,1.928,56.9),(80.36,1.928,56.76),(80.55,1.928,56.54),(80.64,1.928,56.27),(80.64,1.928,55.99),(80.55,1.928,55.72),(80.36,1.928,55.5),(80.12,1.928,55.36),(79.83,1.697,54.58),(79.31,1.697,54.68),(78.84,1.697,54.95),(78.5,1.697,55.36),(78.31,1.697,55.86),(78.31,1.697,56.4),(78.5,1.697,56.9),(78.84,1.697,57.31),(79.31,1.697,57.58),(79.83,1.697,57.68),(80.36,1.697,57.58),(80.83,1.697,57.31),(81.17,1.697,56.9),(81.36,1.697,56.4),(81.36,1.697,55.86),(81.17,1.697,55.36),(80.83,1.697,54.95),(80.36,1.697,54.68),(79.83,1.343,54.05),(79.12,1.343,54.17),(78.5,1.343,54.54),(78.03,1.343,55.09),(77.78,1.343,55.77),(77.78,1.343,56.49),(78.03,1.343,57.17),(78.5,1.343,57.72),(79.12,1.343,58.09),(79.83,1.343,58.21),(80.55,1.343,58.09),(81.17,1.343,57.72),(81.64,1.343,57.17),(81.88,1.343,56.49),(81.88,1.343,55.77),(81.64,1.343,55.09),(81.17,1.343,54.54),(80.55,1.343,54.17),(79.83,0.9082,53.76),(79.02,0.9082,53.91),(78.31,0.9082,54.32),(77.78,0.9082,54.95),(77.5,0.9082,55.72),(77.5,0.9082,56.54),(77.78,0.9082,57.31),(78.31,0.9082,57.94),(79.02,0.9082,58.35),(79.83,0.9082,58.5),(80.64,0.9082,58.35),(81.36,0.9082,57.94),(81.88,0.9082,57.31),(82.17,0.9082,56.54),(82.17,0.9082,55.72),(81.88,0.9082,54.95),(81.36,0.9082,54.32),(80.64,0.9082,53.91),(79.83,0.4459,53.76),(79.02,0.4459,53.91),(78.31,0.4459,54.32),(77.78,0.4459,54.95),(77.5,0.4459,55.72),(77.5,0.4459,56.54),(77.78,0.4459,57.31),(78.31,0.4459,57.94),(79.02,0.4459,58.35),(79.83,0.4459,58.5),(80.64,0.4459,58.35),(81.36,0.4459,57.94),(81.88,0.4459,57.31),(82.17,0.4459,56.54),(82.17,0.4459,55.72),(81.88,0.4459,54.95),(81.36,0.4459,54.32),(80.64,0.4459,53.91),(79.83,0.01154,54.05),(79.12,0.01154,54.17),(78.5,0.01154,54.54),(78.03,0.01154,55.09),(77.78,0.01154,55.77),(77.78,0.01154,56.49),(78.03,0.01154,57.17),(78.5,0.01154,57.72),(79.12,0.01154,58.09),(79.83,0.01154,58.21),(80.55,0.01154,58.09),(81.17,0.01154,57.72),(81.64,0.01154,57.17),(81.88,0.01154,56.49),(81.88,0.01154,55.77),(81.64,0.01154,55.09),(81.17,0.01154,54.54),(80.55,0.01154,54.17),(79.83,-0.3426,54.58),(79.31,-0.3426,54.68),(78.84,-0.3426,54.95),(78.5,-0.3426,55.36),(78.31,-0.3426,55.86),(78.31,-0.3426,56.4),(78.5,-0.3426,56.9),(78.84,-0.3426,57.31),(79.31,-0.3426,57.58),(79.83,-0.3426,57.68),(80.36,-0.3426,57.58),(80.83,-0.3426,57.31),(81.17,-0.3426,56.9),(81.36,-0.3426,56.4),(81.36,-0.3426,55.86),(81.17,-0.3426,55.36),(80.83,-0.3426,54.95),(80.36,-0.3426,54.68),(79.83,-0.5737,55.31),(79.55,-0.5737,55.36),(79.31,-0.5737,55.5),(79.12,-0.5737,55.72),(79.02,-0.5737,55.99),(79.02,-0.5737,56.27),(79.12,-0.5737,56.54),(79.31,-0.5737,56.76),(79.55,-0.5737,56.9),(79.83,-0.5737,56.95),(80.12,-0.5737,56.9),(80.36,-0.5737,56.76),(80.55,-0.5737,56.54),(80.64,-0.5737,56.27),(80.64,-0.5737,55.99),(80.55,-0.5737,55.72),(80.36,-0.5737,55.5),(80.12,-0.5737,55.36),(79.83,-0.654,56.13)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for UnitMonitor.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python UnitMonitor.py load and self-test diagnostics complete.")
