package Basic.Units;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Units component example for a computer disk. </p>
 <p> Related links: Catalog page <a href="../../../Units/UnitDiskIndex.html" target="_blank">UnitDisk</a>,  source <a href="../../../Units/UnitDisk.java">UnitDisk.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Units/UnitDisk.x3d">UnitDisk.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Units component example for a computer disk </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Myeong Won Lee </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 August 2009 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Units/UnitExamples.pdf">UnitExamples.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd" target="_blank">http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D UNIT statement </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Units/UnitDisk.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Units/UnitDisk.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Units/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Myeong Won Lee
 */

public class UnitDisk
{
	/** Default constructor to create this object. */
	public UnitDisk ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addUnit(new unit().setName("milli").setCategory("length").setConversionFactor(0.001))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("UnitDisk.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Units component example for a computer disk"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Myeong Won Lee"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 August 2009"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("UnitExamples.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D UNIT statement"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Units/UnitDisk.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("UnitDisk.x3d"))
    .addChild(new Background().setGroundColor(new MFColor(new double[] {0.05,0.1,0.3})).setSkyColor(new MFColor(new double[] {0.05,0.1,0.3})))
    .addChild(new Transform().setRotation(-1.0,0.0,0.0,-1.571).setScale(0.4952,0.4952,0.5625).setTranslation(-200.0,-5.106,11.65)
      .addChild(new Viewpoint().setDescription("disk1").setOrientation(0.0,1.0,0.0,-0.1745).setPosition(0.0,0.0,1.0))
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.788,0.788,0.788)))
        .setGeometry(new IndexedFaceSet().setCoordIndex(getIndexedFaceSet_5_20_coordIndex())
          .setCoord(new Coordinate().setPoint(getCoordinate_6_20_point())))))
    .addChild(new Transform().setRotation(-1.0,0.0,0.0,-1.571).setScale(0.5492,0.5492,0.5625).setTranslation(-200.0,-5.106,11.65)
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.0,0.0,0.0)))
        .setGeometry(new IndexedFaceSet().setCoordIndex(getIndexedFaceSet_5_26_coordIndex())
          .setCoord(new Coordinate().setPoint(getCoordinate_6_26_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_5_20_coordIndex_1()
		{
			int[] value = {0,1,63,-1,0,63,62,-1,1,2,64,-1,1,64,63,-1,2,3,65,-1,2,65,64,-1,3,4,66,-1,3,66,65,-1,4,5,67,-1,4,67,66,-1,5,6,68,-1,5,68,67,-1,6,7,69,-1,6,69,68,-1,7,8,70,-1,7,70,69,-1,8,9,71,-1,8,71,70,-1,9,10,72,-1,9,72,71,-1,10,11,73,-1,10,73,72,-1,11,12,74,-1,11,74,73,-1,12,13,75,-1,12,75,74,-1,13,14,76,-1,13,76,75,-1,14,15,77,-1,14,77,76,-1,15,16,78,-1,15,78,77,-1,16,17,79,-1,16,79,78,-1,17,18,80,-1,17,80,79,-1,18,19,81,-1,18,81,80,-1,19,20,82,-1,19,82,81,-1,20,21,83,-1,20,83,82,-1,21,22,84,-1,21,84,83,-1,22,23,85,-1,22,85,84,-1,23,24,86,-1,23,86,85,-1,24,25,87,-1,24,87,86,-1,25,26,88,-1,25,88,87,-1,26,27,89,-1,26,89,88,-1,27,28,90,-1,27,90,89,-1,28,29,91,-1,28,91,90,-1,29,30,92,-1,29,92,91,-1,30,31,93,-1,30,93,92,-1,31,32,94,-1,31,94,93,-1,32,33,95,-1,32,95,94,-1,33,34,96,-1,33,96,95,-1,34,35,97,-1,34,97,96,-1,35,36,98,-1,35,98,97,-1,36,37,99,-1,36,99,98,-1,37,38,100,-1,37,100,99,-1,38,39,101,-1,38,101,100,-1,39,40,102,-1,39,102,101,-1,40,41,103,-1,40,103,102,-1,41,42,104,-1,41,104,103,-1,42,43,105,-1,42,105,104,-1,43,44,106,-1,43,106,105,-1,44,45,107,-1,44,107,106,-1,45,46,108,-1,45,108,107,-1,46,47,109,-1,46,109,108,-1,47,48,110,-1,47,110,109,-1,48,49,111,-1,48,111,110,-1,49,50,112,-1,49,112,111,-1,50,51,113,-1,50,113,112,-1,51,52,114,-1,51,114,113,-1,52,53,115,-1,52,115,114,-1,53,54,116,-1,53,116,115,-1,54,55,117,-1,54,117,116,-1,55,56,118,-1,55,118,117,-1,56,57,119,-1,56,119,118,-1,57,58,120,-1,57,120,119,-1,58,59,121,-1,58,121,120,-1,59,60,122,-1,59,122,121,-1,60,61,123,-1,60,123,122,-1,61,0,62,-1,61,62,123,-1,30,32,31,-1,30,33,32,-1,30,34,33,-1,30,35,34,-1,30,36,35,-1,30,37,36,-1,29,37,30,-1,28,37,29,-1,27,37,28,-1,26,37,27,-1,25,37,26,-1,24,37,25,-1,23,37,24,-1,22,37,23,-1,22,38,37,-1,21,38,22,-1,20,38,21,-1,19,38,20,-1,18,38,19,-1,17,38,18,-1,16,38,17,-1,15,38,16,-1,14,38,15,-1,13,38,14,-1,12,38,13,-1,11,38,12,-1,10,38,11,-1,9,38,10,-1,8,38,9,-1,7,38,8,-1,6,38,7,-1,6,39,38,-1,5,39,6,-1,5,40,39,-1,4,40,5,-1,4,41,40,-1,3,41,4,-1,2,41,3,-1,1,41,2,-1,0,41,1,-1,61,41,0,-1,60,41,61,-1,59,41,60,-1,58,41,59,-1,57,41,58,-1,56,41,57,-1,55,41,56,-1,54,41,55,-1,53,41,54,-1,53,42,41,-1,53,43,42,-1,53,44,43,-1,53,45,44,-1,53,46,45,-1,53,47,46,-1,53,48,47,-1,53,49,48,-1,53,50,49,-1,53,51,50,-1,53,52,51,-1,402,403,404,-1,402,404,405,-1,402,405,406,-1,402,406,407,-1,402,407,408,-1,402,408,409,-1,401,402,409,-1,400,401,409,-1,399,400,409,-1,398,399,409,-1,397,398,409,-1,396,397,409,-1,395,396,409,-1,394,395,409,-1,394,409,410,-1,393,394,410,-1,392,393,410,-1,391,392,410,-1,390,391,410,-1,389,390,410,-1,388,389,410,-1,387,388,410,-1,386,387,410,-1,385,386,410,-1,384,385,410,-1,383,384,410,-1,382,383,410,-1,381,382,410,-1,380,381,410,-1,379,380,410,-1,378,379,410,-1,378,410,411,-1,377,378,411,-1,377,411,412,-1,376,377,412,-1,376,412,413,-1,375,376,413,-1,374,375,413,-1,373,374,413,-1,372,373,413,-1,433,372,413,-1,432,433,413,-1,431,432,413,-1,430,431,413,-1,429,430,413,-1,428,429,413,-1,427,428,413,-1,426,427,413,-1,425,426,413,-1,425,413,414,-1,425,414,415,-1,425,415,416,-1,425,416,417,-1,425,417,418,-1,425,418,419,-1,425,419,420,-1,425,420,421,-1,425,421,422,-1,425,422,423,-1,425,423,424,-1,62,63,125,-1,125,124,62,-1,63,64,126,-1,126,125,63,-1,64,65,127,-1,127,126,64,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_2()
		{
			int[] value = {65,66,128,-1,128,127,65,-1,66,67,129,-1,129,128,66,-1,67,68,130,-1,130,129,67,-1,68,69,131,-1,131,130,68,-1,69,70,132,-1,132,131,69,-1,70,71,133,-1,133,132,70,-1,71,72,134,-1,134,133,71,-1,72,73,135,-1,135,134,72,-1,73,74,136,-1,136,135,73,-1,74,75,137,-1,137,136,74,-1,75,76,138,-1,138,137,75,-1,76,77,139,-1,139,138,76,-1,77,78,140,-1,140,139,77,-1,78,79,141,-1,141,140,78,-1,79,80,142,-1,142,141,79,-1,80,81,143,-1,143,142,80,-1,81,82,144,-1,144,143,81,-1,82,83,145,-1,145,144,82,-1,83,84,146,-1,146,145,83,-1,84,85,147,-1,147,146,84,-1,85,86,148,-1,148,147,85,-1,86,87,149,-1,149,148,86,-1,87,88,150,-1,150,149,87,-1,88,89,151,-1,151,150,88,-1,89,90,152,-1,152,151,89,-1,90,91,153,-1,153,152,90,-1,91,92,154,-1,154,153,91,-1,92,93,155,-1,155,154,92,-1,93,94,156,-1,156,155,93,-1,94,95,157,-1,157,156,94,-1,95,96,158,-1,158,157,95,-1,96,97,159,-1,159,158,96,-1,97,98,160,-1,160,159,97,-1,98,99,161,-1,161,160,98,-1,99,100,162,-1,162,161,99,-1,100,101,163,-1,163,162,100,-1,101,102,164,-1,164,163,101,-1,102,103,165,-1,165,164,102,-1,103,104,166,-1,166,165,103,-1,104,105,167,-1,167,166,104,-1,105,106,168,-1,168,167,105,-1,106,107,169,-1,169,168,106,-1,107,108,170,-1,170,169,107,-1,108,109,171,-1,171,170,108,-1,109,110,172,-1,172,171,109,-1,110,111,173,-1,173,172,110,-1,111,112,174,-1,174,173,111,-1,112,113,175,-1,175,174,112,-1,113,114,176,-1,176,175,113,-1,114,115,177,-1,177,176,114,-1,115,116,178,-1,178,177,115,-1,116,117,179,-1,179,178,116,-1,117,118,180,-1,180,179,117,-1,118,119,181,-1,181,180,118,-1,119,120,182,-1,182,181,119,-1,120,121,183,-1,183,182,120,-1,121,122,184,-1,184,183,121,-1,122,123,185,-1,185,184,122,-1,123,62,124,-1,124,185,123,-1,154,155,217,-1,217,216,154,-1,155,156,218,-1,218,217,155,-1,156,157,219,-1,219,218,156,-1,157,158,220,-1,220,219,157,-1,158,159,221,-1,221,220,158,-1,159,160,222,-1,222,221,159,-1,160,161,223,-1,223,222,160,-1,153,154,216,-1,216,215,153,-1,152,153,215,-1,215,214,152,-1,151,152,214,-1,214,213,151,-1,150,151,213,-1,213,212,150,-1,149,150,212,-1,212,211,149,-1,148,149,211,-1,211,210,148,-1,147,148,210,-1,210,209,147,-1,146,147,209,-1,209,208,146,-1,161,162,224,-1,224,223,161,-1,145,146,208,-1,208,207,145,-1,144,145,207,-1,207,206,144,-1,143,144,206,-1,206,205,143,-1,142,143,205,-1,205,204,142,-1,141,142,204,-1,204,203,141,-1,140,141,203,-1,203,202,140,-1,139,140,202,-1,202,201,139,-1,138,139,201,-1,201,200,138,-1,137,138,200,-1,200,199,137,-1,136,137,199,-1,199,198,136,-1,135,136,198,-1,198,197,135,-1,134,135,197,-1,197,196,134,-1,133,134,196,-1,196,195,133,-1,132,133,195,-1,195,194,132,-1,131,132,194,-1,194,193,131,-1,130,131,193,-1,193,192,130,-1,162,163,225,-1,225,224,162,-1,129,130,192,-1,192,191,129,-1,163,164,226,-1,226,225,163,-1,128,129,191,-1,191,190,128,-1,164,165,227,-1,227,226,164,-1,127,128,190,-1,190,189,127,-1,126,127,189,-1,189,188,126,-1,125,126,188,-1,188,187,125,-1,124,125,187,-1,187,186,124,-1,185,124,186,-1,186,247,185,-1,184,185,247,-1,247,246,184,-1,183,184,246,-1,246,245,183,-1,182,183,245,-1,245,244,182,-1,181,182,244,-1,244,243,181,-1,180,181,243,-1,243,242,180,-1,179,180,242,-1,242,241,179,-1,178,179,241,-1,241,240,178,-1,177,178,240,-1,240,239,177,-1,165,166,228,-1,228,227,165,-1,166,167,229,-1,229,228,166,-1,167,168,230,-1,230,229,167,-1,168,169,231,-1,231,230,168,-1,169,170,232,-1,232,231,169,-1,170,171,233,-1,233,232,170,-1,171,172,234,-1,234,233,171,-1,172,173,235,-1,235,234,172,-1,173,174,236,-1,236,235,173,-1,174,175,237,-1,237,236,174,-1,175,176,238,-1,238,237,175,-1,176,177,239,-1,239,238,176,-1,216,217,279,-1,279,278,216,-1,217,218,280,-1,280,279,217,-1,218,219,281,-1,281,280,218,-1,219,220,282,-1,282,281,219,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_3()
		{
			int[] value = {220,221,283,-1,283,282,220,-1,221,222,284,-1,284,283,221,-1,222,223,285,-1,285,284,222,-1,215,216,278,-1,278,277,215,-1,214,215,277,-1,277,276,214,-1,213,214,276,-1,276,275,213,-1,212,213,275,-1,275,274,212,-1,211,212,274,-1,274,273,211,-1,210,211,273,-1,273,272,210,-1,209,210,272,-1,272,271,209,-1,208,209,271,-1,271,270,208,-1,223,224,286,-1,286,285,223,-1,207,208,270,-1,270,269,207,-1,206,207,269,-1,269,268,206,-1,205,206,268,-1,268,267,205,-1,204,205,267,-1,267,266,204,-1,203,204,266,-1,266,265,203,-1,202,203,265,-1,265,264,202,-1,201,202,264,-1,264,263,201,-1,200,201,263,-1,263,262,200,-1,199,200,262,-1,262,261,199,-1,198,199,261,-1,261,260,198,-1,197,198,260,-1,260,259,197,-1,196,197,259,-1,259,258,196,-1,195,196,258,-1,258,257,195,-1,194,195,257,-1,257,256,194,-1,193,194,256,-1,256,255,193,-1,192,193,255,-1,255,254,192,-1,224,225,287,-1,287,286,224,-1,191,192,254,-1,254,253,191,-1,225,226,288,-1,288,287,225,-1,190,191,253,-1,253,252,190,-1,226,227,289,-1,289,288,226,-1,189,190,252,-1,252,251,189,-1,188,189,251,-1,251,250,188,-1,187,188,250,-1,250,249,187,-1,186,187,249,-1,249,248,186,-1,247,186,248,-1,248,309,247,-1,246,247,309,-1,309,308,246,-1,245,246,308,-1,308,307,245,-1,244,245,307,-1,307,306,244,-1,243,244,306,-1,306,305,243,-1,242,243,305,-1,305,304,242,-1,241,242,304,-1,304,303,241,-1,240,241,303,-1,303,302,240,-1,239,240,302,-1,302,301,239,-1,227,228,290,-1,290,289,227,-1,228,229,291,-1,291,290,228,-1,229,230,292,-1,292,291,229,-1,230,231,293,-1,293,292,230,-1,231,232,294,-1,294,293,231,-1,232,233,295,-1,295,294,232,-1,233,234,296,-1,296,295,233,-1,234,235,297,-1,297,296,234,-1,235,236,298,-1,298,297,235,-1,236,237,299,-1,299,298,236,-1,237,238,300,-1,300,299,237,-1,238,239,301,-1,301,300,238,-1,278,279,341,-1,341,340,278,-1,279,280,342,-1,342,341,279,-1,280,281,343,-1,343,342,280,-1,281,282,344,-1,344,343,281,-1,282,283,345,-1,345,344,282,-1,283,284,346,-1,346,345,283,-1,284,285,347,-1,347,346,284,-1,277,278,340,-1,340,339,277,-1,276,277,339,-1,339,338,276,-1,275,276,338,-1,338,337,275,-1,274,275,337,-1,337,336,274,-1,273,274,336,-1,336,335,273,-1,272,273,335,-1,335,334,272,-1,271,272,334,-1,334,333,271,-1,270,271,333,-1,333,332,270,-1,285,286,348,-1,348,347,285,-1,269,270,332,-1,332,331,269,-1,268,269,331,-1,331,330,268,-1,267,268,330,-1,330,329,267,-1,266,267,329,-1,329,328,266,-1,265,266,328,-1,328,327,265,-1,264,265,327,-1,327,326,264,-1,263,264,326,-1,326,325,263,-1,262,263,325,-1,325,324,262,-1,261,262,324,-1,324,323,261,-1,260,261,323,-1,323,322,260,-1,259,260,322,-1,322,321,259,-1,258,259,321,-1,321,320,258,-1,257,258,320,-1,320,319,257,-1,256,257,319,-1,319,318,256,-1,255,256,318,-1,318,317,255,-1,254,255,317,-1,317,316,254,-1,286,287,349,-1,349,348,286,-1,253,254,316,-1,316,315,253,-1,287,288,350,-1,350,349,287,-1,252,253,315,-1,315,314,252,-1,288,289,351,-1,351,350,288,-1,251,252,314,-1,314,313,251,-1,250,251,313,-1,313,312,250,-1,249,250,312,-1,312,311,249,-1,248,249,311,-1,311,310,248,-1,309,248,310,-1,310,371,309,-1,308,309,371,-1,371,370,308,-1,307,308,370,-1,370,369,307,-1,306,307,369,-1,369,368,306,-1,305,306,368,-1,368,367,305,-1,304,305,367,-1,367,366,304,-1,303,304,366,-1,366,365,303,-1,302,303,365,-1,365,364,302,-1,301,302,364,-1,364,363,301,-1,289,290,352,-1,352,351,289,-1,290,291,353,-1,353,352,290,-1,291,292,354,-1,354,353,291,-1,292,293,355,-1,355,354,292,-1,293,294,356,-1,356,355,293,-1,294,295,357,-1,357,356,294,-1,295,296,358,-1,358,357,295,-1,296,297,359,-1,359,358,296,-1,297,298,360,-1,360,359,297,-1,298,299,361,-1,361,360,298,-1,299,300,362,-1,362,361,299,-1,300,301,363,-1,363,362,300,-1,340,341,403,-1,403,402,340,-1,341,342,404,-1,404,403,341,-1,342,343,405,-1,405,404,342,-1,343,344,406,-1,406,405,343,-1,344,345,407,-1,407,406,344,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_4()
		{
			int[] value = {345,346,408,-1,408,407,345,-1,346,347,409,-1,409,408,346,-1,339,340,402,-1,402,401,339,-1,338,339,401,-1,401,400,338,-1,337,338,400,-1,400,399,337,-1,336,337,399,-1,399,398,336,-1,335,336,398,-1,398,397,335,-1,334,335,397,-1,397,396,334,-1,333,334,396,-1,396,395,333,-1,332,333,395,-1,395,394,332,-1,347,348,410,-1,410,409,347,-1,331,332,394,-1,394,393,331,-1,330,331,393,-1,393,392,330,-1,329,330,392,-1,392,391,329,-1,328,329,391,-1,391,390,328,-1,327,328,390,-1,390,389,327,-1,326,327,389,-1,389,388,326,-1,325,326,388,-1,388,387,325,-1,324,325,387,-1,387,386,324,-1,323,324,386,-1,386,385,323,-1,322,323,385,-1,385,384,322,-1,321,322,384,-1,384,383,321,-1,320,321,383,-1,383,382,320,-1,319,320,382,-1,382,381,319,-1,318,319,381,-1,381,380,318,-1,317,318,380,-1,380,379,317,-1,316,317,379,-1,379,378,316,-1,348,349,411,-1,411,410,348,-1,315,316,378,-1,378,377,315,-1,349,350,412,-1,412,411,349,-1,314,315,377,-1,377,376,314,-1,350,351,413,-1,413,412,350,-1,313,314,376,-1,376,375,313,-1,312,313,375,-1,375,374,312,-1,311,312,374,-1,374,373,311,-1,310,311,373,-1,373,372,310,-1,371,310,372,-1,372,433,371,-1,370,371,433,-1,433,432,370,-1,369,370,432,-1,432,431,369,-1,368,369,431,-1,431,430,368,-1,367,368,430,-1,430,429,367,-1,366,367,429,-1,429,428,366,-1,365,366,428,-1,428,427,365,-1,364,365,427,-1,427,426,364,-1,363,364,426,-1,426,425,363,-1,351,352,414,-1,414,413,351,-1,352,353,415,-1,415,414,352,-1,353,354,416,-1,416,415,353,-1,354,355,417,-1,417,416,354,-1,355,356,418,-1,418,417,355,-1,356,357,419,-1,419,418,356,-1,357,358,420,-1,420,419,357,-1,358,359,421,-1,421,420,358,-1,359,360,422,-1,422,421,359,-1,360,361,423,-1,423,422,360,-1,361,362,424,-1,424,423,361,-1,362,363,425,-1,425,424,362,-1,434,436,437,-1,434,437,435,-1,436,438,439,-1,436,439,437,-1,434,440,441,-1,434,441,436,-1,436,441,442,-1,436,442,438,-1,438,442,443,-1,438,443,444,-1,438,444,445,-1,438,445,446,-1,438,446,439,-1,439,446,447,-1,439,447,448,-1,439,448,449,-1,439,449,450,-1,439,450,437,-1,437,450,451,-1,437,451,435,-1,440,452,453,-1,440,453,441,-1,441,453,454,-1,441,454,442,-1,442,454,455,-1,442,455,443,-1,443,455,456,-1,443,456,444,-1,444,456,457,-1,444,457,445,-1,445,457,458,-1,445,458,446,-1,446,458,459,-1,446,459,447,-1,447,459,460,-1,447,460,448,-1,448,460,461,-1,448,461,449,-1,449,461,462,-1,449,462,450,-1,450,462,463,-1,450,463,451,-1,452,464,465,-1,452,465,453,-1,453,465,466,-1,453,466,454,-1,454,466,467,-1,454,467,455,-1,455,467,468,-1,455,468,456,-1,456,468,469,-1,456,469,457,-1,457,469,470,-1,457,470,458,-1,458,470,471,-1,458,471,459,-1,459,471,472,-1,459,472,460,-1,460,472,473,-1,460,473,461,-1,461,473,474,-1,461,474,462,-1,462,474,475,-1,462,475,463,-1,464,476,477,-1,464,477,465,-1,465,477,478,-1,465,478,466,-1,466,478,479,-1,466,479,467,-1,467,479,480,-1,467,480,468,-1,468,480,481,-1,468,481,469,-1,469,481,482,-1,469,482,470,-1,470,482,483,-1,470,483,471,-1,471,483,484,-1,471,484,472,-1,472,484,485,-1,472,485,473,-1,473,485,486,-1,473,486,474,-1,474,486,487,-1,474,487,475,-1,476,488,489,-1,476,489,477,-1,477,489,490,-1,477,490,478,-1,478,490,491,-1,478,491,479,-1,479,491,492,-1,479,492,480,-1,480,492,493,-1,480,493,481,-1,481,493,494,-1,481,494,482,-1,482,494,495,-1,482,495,483,-1,483,495,496,-1,483,496,484,-1,484,496,497,-1,484,497,485,-1,485,497,498,-1,485,498,486,-1,486,498,499,-1,486,499,487,-1,488,500,501,-1,488,501,489,-1,489,501,502,-1,489,502,490,-1,490,502,503,-1,490,503,491,-1,491,503,504,-1,491,504,492,-1,492,504,505,-1,492,505,493,-1,493,505,506,-1,493,506,494,-1,494,506,507,-1,494,507,495,-1,495,507,508,-1,495,508,496,-1,496,508,509,-1,496,509,497,-1,497,509,510,-1,497,510,498,-1,498,510,511,-1,498,511,499,-1,500,517,515,-1,500,515,501,-1,501,515,513,-1,501,513,502,-1,502,513,503,-1,503,513,504,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_5()
		{
			int[] value = {504,513,505,-1,505,513,512,-1,505,512,506,-1,506,512,507,-1,507,512,508,-1,508,512,509,-1,509,512,514,-1,509,514,510,-1,510,514,516,-1,510,516,511,-1,514,512,513,-1,514,513,515,-1,524,522,523,-1,524,523,525,-1,515,517,521,-1,521,519,515,-1,516,514,518,-1,518,520,516,-1,514,515,519,-1,519,518,514,-1,520,518,522,-1,522,524,520,-1,518,519,523,-1,523,522,518,-1,519,521,525,-1,525,523,519,-1,556,554,552,-1,556,552,550,-1,558,556,550,-1,558,550,548,-1,561,558,548,-1,561,548,546,-1,551,553,555,-1,551,555,557,-1,549,551,557,-1,549,557,559,-1,547,549,559,-1,547,559,560,-1,547,560,562,-1,547,562,564,-1,546,565,563,-1,546,563,561,-1,547,564,565,-1,547,565,546,-1,434,435,527,-1,527,526,434,-1,440,434,526,-1,526,528,440,-1,435,451,529,-1,529,527,435,-1,452,440,528,-1,528,530,452,-1,451,463,531,-1,531,529,451,-1,464,452,530,-1,530,532,464,-1,463,475,533,-1,533,531,463,-1,476,464,532,-1,532,534,476,-1,475,487,535,-1,535,533,475,-1,488,476,534,-1,534,536,488,-1,487,499,537,-1,537,535,487,-1,500,488,536,-1,536,538,500,-1,499,511,539,-1,539,537,499,-1,517,500,538,-1,538,541,517,-1,511,516,540,-1,540,539,511,-1,524,525,545,-1,545,544,524,-1,521,517,541,-1,541,543,521,-1,516,520,542,-1,542,540,516,-1,520,524,544,-1,544,542,520,-1,525,521,543,-1,543,545,525,-1,536,534,554,-1,554,556,536,-1,534,532,552,-1,552,554,534,-1,532,530,550,-1,550,552,532,-1,538,536,556,-1,556,558,538,-1,530,528,548,-1,548,550,530,-1,541,538,558,-1,558,561,541,-1,528,526,546,-1,546,548,528,-1,531,533,553,-1,553,551,531,-1,533,535,555,-1,555,553,533,-1,535,537,557,-1,557,555,535,-1,529,531,551,-1,551,549,529,-1,537,539,559,-1,559,557,537,-1,527,529,549,-1,549,547,527,-1,539,540,560,-1,560,559,539,-1,540,542,562,-1,562,560,540,-1,542,544,564,-1,564,562,542,-1,545,543,563,-1,563,565,545,-1,543,541,561,-1,561,563,543,-1,544,545,565,-1,565,564,544,-1,526,527,547,-1,547,546,526,-1,570,566,571,-1,567,571,566,-1,571,567,572,-1,568,572,567,-1,572,568,573,-1,569,573,568,-1,575,574,579,-1,578,579,574,-1,576,575,580,-1,579,580,575,-1,577,576,581,-1,580,581,576,-1,567,566,575,-1,574,575,566,-1,568,567,576,-1,575,576,567,-1,569,568,577,-1,576,577,568,-1,573,569,581,-1,577,581,569,-1,608,609,612,-1,613,612,609,-1,602,603,604,-1,605,604,603,-1,606,607,610,-1,611,610,607,-1,566,570,574,-1,578,574,570,-1,570,571,583,-1,583,582,570,-1,572,573,585,-1,585,584,572,-1,579,578,586,-1,586,587,579,-1,581,580,588,-1,588,589,581,-1,573,581,589,-1,589,585,573,-1,580,572,584,-1,584,588,580,-1,571,579,587,-1,587,583,571,-1,578,570,582,-1,582,586,578,-1,571,572,591,-1,591,590,571,-1,580,579,592,-1,592,593,580,-1,584,585,597,-1,597,596,584,-1,588,584,596,-1,596,600,588,-1,589,588,600,-1,600,601,589,-1,585,589,601,-1,601,597,585,-1,579,571,590,-1,590,592,579,-1,572,580,593,-1,593,591,572,-1,582,583,595,-1,595,594,582,-1,586,582,594,-1,594,598,586,-1,587,586,598,-1,598,599,587,-1,583,587,599,-1,599,595,583,-1,596,597,609,-1,609,608,596,-1,600,596,608,-1,608,612,600,-1,601,600,612,-1,612,613,601,-1,597,601,613,-1,613,609,597,-1,590,591,603,-1,603,602,590,-1,592,590,602,-1,602,604,592,-1,593,592,604,-1,604,605,593,-1,591,593,605,-1,605,603,591,-1,594,595,607,-1,607,606,594,-1,598,594,606,-1,606,610,598,-1,599,598,610,-1,610,611,599,-1,595,599,611,-1,611,607,595,-1,614,616,615,-1,614,617,616,-1,614,618,617,-1,614,619,618,-1,614,620,619,-1,614,621,620,-1,614,622,621,-1,614,623,622,-1,614,624,623,-1,614,625,624,-1,614,626,625,-1,614,615,626,-1,615,628,627,-1,615,616,628,-1,616,629,628,-1,616,617,629,-1,617,630,629,-1,617,618,630,-1,618,631,630,-1,618,619,631,-1,619,632,631,-1,619,620,632,-1,620,633,632,-1,620,621,633,-1,621,634,633,-1,621,622,634,-1,622,635,634,-1,622,623,635,-1,623,636,635,-1,623,624,636,-1,624,637,636,-1,624,625,637,-1,625,638,637,-1,625,626,638,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_6()
		{
			int[] value = {626,627,638,-1,626,615,627,-1,639,627,628,-1,639,628,629,-1,639,629,630,-1,639,630,631,-1,639,631,632,-1,639,632,633,-1,639,633,634,-1,639,634,635,-1,639,635,636,-1,639,636,637,-1,639,637,638,-1,639,638,627,-1,640,642,641,-1,640,643,642,-1,640,644,643,-1,640,645,644,-1,640,646,645,-1,640,647,646,-1,640,648,647,-1,640,649,648,-1,640,650,649,-1,640,651,650,-1,640,652,651,-1,640,641,652,-1,641,654,653,-1,641,642,654,-1,642,655,654,-1,642,643,655,-1,643,656,655,-1,643,644,656,-1,644,657,656,-1,644,645,657,-1,645,658,657,-1,645,646,658,-1,646,659,658,-1,646,647,659,-1,647,660,659,-1,647,648,660,-1,648,661,660,-1,648,649,661,-1,649,662,661,-1,649,650,662,-1,650,663,662,-1,650,651,663,-1,651,664,663,-1,651,652,664,-1,652,653,664,-1,652,641,653,-1,665,653,654,-1,665,654,655,-1,665,655,656,-1,665,656,657,-1,665,657,658,-1,665,658,659,-1,665,659,660,-1,665,660,661,-1,665,661,662,-1,665,662,663,-1,665,663,664,-1,665,664,653,-1,666,668,667,-1,666,669,668,-1,666,670,669,-1,666,671,670,-1,666,672,671,-1,666,673,672,-1,666,674,673,-1,666,675,674,-1,666,676,675,-1,666,677,676,-1,666,678,677,-1,666,667,678,-1,667,680,679,-1,667,668,680,-1,668,681,680,-1,668,669,681,-1,669,682,681,-1,669,670,682,-1,670,683,682,-1,670,671,683,-1,671,684,683,-1,671,672,684,-1,672,685,684,-1,672,673,685,-1,673,686,685,-1,673,674,686,-1,674,687,686,-1,674,675,687,-1,675,688,687,-1,675,676,688,-1,676,689,688,-1,676,677,689,-1,677,690,689,-1,677,678,690,-1,678,679,690,-1,678,667,679,-1,691,679,680,-1,691,680,681,-1,691,681,682,-1,691,682,683,-1,691,683,684,-1,691,684,685,-1,691,685,686,-1,691,686,687,-1,691,687,688,-1,691,688,689,-1,691,689,690,-1,691,690,679,-1,692,694,693,-1,692,695,694,-1,692,696,695,-1,692,697,696,-1,692,698,697,-1,692,699,698,-1,692,700,699,-1,692,701,700,-1,692,702,701,-1,692,703,702,-1,692,704,703,-1,692,693,704,-1,693,706,705,-1,693,694,706,-1,694,707,706,-1,694,695,707,-1,695,708,707,-1,695,696,708,-1,696,709,708,-1,696,697,709,-1,697,710,709,-1,697,698,710,-1,698,711,710,-1,698,699,711,-1,699,712,711,-1,699,700,712,-1,700,713,712,-1,700,701,713,-1,701,714,713,-1,701,702,714,-1,702,715,714,-1,702,703,715,-1,703,716,715,-1,703,704,716,-1,704,705,716,-1,704,693,705,-1,717,705,706,-1,717,706,707,-1,717,707,708,-1,717,708,709,-1,717,709,710,-1,717,710,711,-1,717,711,712,-1,717,712,713,-1,717,713,714,-1,717,714,715,-1,717,715,716,-1,717,716,705,-1,718,720,719,-1,718,721,720,-1,718,722,721,-1,718,723,722,-1,718,724,723,-1,718,725,724,-1,718,726,725,-1,718,727,726,-1,718,728,727,-1,718,729,728,-1,718,730,729,-1,718,719,730,-1,719,732,731,-1,719,720,732,-1,720,733,732,-1,720,721,733,-1,721,734,733,-1,721,722,734,-1,722,735,734,-1,722,723,735,-1,723,736,735,-1,723,724,736,-1,724,737,736,-1,724,725,737,-1,725,738,737,-1,725,726,738,-1,726,739,738,-1,726,727,739,-1,727,740,739,-1,727,728,740,-1,728,741,740,-1,728,729,741,-1,729,742,741,-1,729,730,742,-1,730,731,742,-1,730,719,731,-1,743,731,732,-1,743,732,733,-1,743,733,734,-1,743,734,735,-1,743,735,736,-1,743,736,737,-1,743,737,738,-1,743,738,739,-1,743,739,740,-1,743,740,741,-1,743,741,742,-1,743,742,731,-1,744,746,745,-1,744,747,746,-1,744,748,747,-1,744,749,748,-1,744,750,749,-1,744,751,750,-1,744,752,751,-1,744,753,752,-1,744,754,753,-1,744,755,754,-1,744,756,755,-1,744,745,756,-1,745,758,757,-1,745,746,758,-1,746,759,758,-1,746,747,759,-1,747,760,759,-1,747,748,760,-1,748,761,760,-1,748,749,761,-1,749,762,761,-1,749,750,762,-1,750,763,762,-1,750,751,763,-1,751,764,763,-1,751,752,764,-1,752,765,764,-1,752,753,765,-1,753,766,765,-1,753,754,766,-1,754,767,766,-1,754,755,767,-1,755,768,767,-1,755,756,768,-1,756,757,768,-1,756,745,757,-1,769,757,758,-1,769,758,759,-1,769,759,760,-1,769,760,761,-1,769,761,762,-1,769,762,763,-1,769,763,764,-1,769,764,765,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_7()
		{
			int[] value = {769,765,766,-1,769,766,767,-1,769,767,768,-1,769,768,757,-1,772,770,773,-1,771,773,770,-1,775,774,777,-1,776,777,774,-1,771,770,775,-1,774,775,770,-1,773,771,777,-1,775,777,771,-1,772,773,776,-1,777,776,773,-1,770,772,774,-1,776,774,772,-1,780,778,781,-1,779,781,778,-1,783,782,785,-1,784,785,782,-1,779,778,783,-1,782,783,778,-1,781,779,785,-1,783,785,779,-1,780,781,784,-1,785,784,781,-1,778,780,782,-1,784,782,780,-1,786,788,787,-1,786,789,788,-1,786,790,789,-1,786,791,790,-1,786,792,791,-1,786,793,792,-1,786,794,793,-1,786,795,794,-1,786,796,795,-1,786,797,796,-1,786,798,797,-1,786,799,798,-1,786,800,799,-1,786,801,800,-1,786,802,801,-1,786,803,802,-1,786,804,803,-1,786,805,804,-1,786,806,805,-1,786,807,806,-1,786,808,807,-1,786,809,808,-1,786,810,809,-1,786,811,810,-1,786,812,811,-1,786,813,812,-1,786,814,813,-1,786,815,814,-1,786,816,815,-1,786,817,816,-1,786,818,817,-1,786,787,818,-1,787,820,819,-1,787,788,820,-1,788,821,820,-1,788,789,821,-1,789,822,821,-1,789,790,822,-1,790,823,822,-1,790,791,823,-1,791,824,823,-1,791,792,824,-1,792,825,824,-1,792,793,825,-1,793,826,825,-1,793,794,826,-1,794,827,826,-1,794,795,827,-1,795,828,827,-1,795,796,828,-1,796,829,828,-1,796,797,829,-1,797,830,829,-1,797,798,830,-1,798,831,830,-1,798,799,831,-1,799,832,831,-1,799,800,832,-1,800,833,832,-1,800,801,833,-1,801,834,833,-1,801,802,834,-1,802,835,834,-1,802,803,835,-1,803,836,835,-1,803,804,836,-1,804,837,836,-1,804,805,837,-1,805,838,837,-1,805,806,838,-1,806,839,838,-1,806,807,839,-1,807,840,839,-1,807,808,840,-1,808,841,840,-1,808,809,841,-1,809,842,841,-1,809,810,842,-1,810,843,842,-1,810,811,843,-1,811,844,843,-1,811,812,844,-1,812,845,844,-1,812,813,845,-1,813,846,845,-1,813,814,846,-1,814,847,846,-1,814,815,847,-1,815,848,847,-1,815,816,848,-1,816,849,848,-1,816,817,849,-1,817,850,849,-1,817,818,850,-1,818,819,850,-1,818,787,819,-1,851,852,853,-1,851,853,854,-1,851,854,855,-1,851,855,856,-1,851,856,857,-1,851,857,858,-1,851,858,859,-1,851,859,860,-1,851,860,861,-1,851,861,862,-1,851,862,863,-1,851,863,864,-1,851,864,865,-1,851,865,866,-1,851,866,867,-1,851,867,868,-1,851,868,869,-1,851,869,870,-1,851,870,871,-1,851,871,872,-1,851,872,873,-1,851,873,874,-1,851,874,875,-1,851,875,876,-1,851,876,877,-1,851,877,878,-1,851,878,879,-1,851,879,880,-1,851,880,881,-1,851,881,882,-1,851,882,883,-1,851,883,852,-1,819,820,853,-1,853,852,819,-1,820,821,854,-1,854,853,820,-1,821,822,855,-1,855,854,821,-1,822,823,856,-1,856,855,822,-1,823,824,857,-1,857,856,823,-1,824,825,858,-1,858,857,824,-1,825,826,859,-1,859,858,825,-1,826,827,860,-1,860,859,826,-1,827,828,861,-1,861,860,827,-1,828,829,862,-1,862,861,828,-1,829,830,863,-1,863,862,829,-1,830,831,864,-1,864,863,830,-1,831,832,865,-1,865,864,831,-1,832,833,866,-1,866,865,832,-1,833,834,867,-1,867,866,833,-1,834,835,868,-1,868,867,834,-1,835,836,869,-1,869,868,835,-1,836,837,870,-1,870,869,836,-1,837,838,871,-1,871,870,837,-1,838,839,872,-1,872,871,838,-1,839,840,873,-1,873,872,839,-1,840,841,874,-1,874,873,840,-1,841,842,875,-1,875,874,841,-1,842,843,876,-1,876,875,842,-1,843,844,877,-1,877,876,843,-1,844,845,878,-1,878,877,844,-1,845,846,879,-1,879,878,845,-1,846,847,880,-1,880,879,846,-1,847,848,881,-1,881,880,847,-1,848,849,882,-1,882,881,848,-1,849,850,883,-1,883,882,849,-1,850,819,852,-1,852,883,850,-1,884,886,885,-1,884,887,886,-1,884,888,887,-1,884,889,888,-1,884,890,889,-1,884,891,890,-1,884,892,891,-1,884,893,892,-1,884,894,893,-1,884,895,894,-1,884,896,895,-1,884,885,896,-1,885,898,897,-1,885,886,898,-1,886,899,898,-1,886,887,899,-1,887,900,899,-1,887,888,900,-1,888,901,900,-1,888,889,901,-1,889,902,901,-1,889,890,902,-1,890,903,902,-1,890,891,903,-1,891,904,903,-1,891,892,904,-1,892,905,904,-1,892,893,905,-1,893,906,905,-1,893,894,906,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_8()
		{
			int[] value = {894,907,906,-1,894,895,907,-1,895,908,907,-1,895,896,908,-1,896,897,908,-1,896,885,897,-1,909,897,898,-1,909,898,899,-1,909,899,900,-1,909,900,901,-1,909,901,902,-1,909,902,903,-1,909,903,904,-1,909,904,905,-1,909,905,906,-1,909,906,907,-1,909,907,908,-1,909,908,897,-1,910,912,911,-1,910,913,912,-1,910,914,913,-1,910,915,914,-1,910,916,915,-1,910,917,916,-1,910,918,917,-1,910,919,918,-1,910,920,919,-1,910,921,920,-1,910,922,921,-1,910,911,922,-1,911,924,923,-1,911,912,924,-1,912,925,924,-1,912,913,925,-1,913,926,925,-1,913,914,926,-1,914,927,926,-1,914,915,927,-1,915,928,927,-1,915,916,928,-1,916,929,928,-1,916,917,929,-1,917,930,929,-1,917,918,930,-1,918,931,930,-1,918,919,931,-1,919,932,931,-1,919,920,932,-1,920,933,932,-1,920,921,933,-1,921,934,933,-1,921,922,934,-1,922,923,934,-1,922,911,923,-1,935,923,924,-1,935,924,925,-1,935,925,926,-1,935,926,927,-1,935,927,928,-1,935,928,929,-1,935,929,930,-1,935,930,931,-1,935,931,932,-1,935,932,933,-1,935,933,934,-1,935,934,923,-1,936,938,937,-1,936,939,938,-1,936,940,939,-1,936,941,940,-1,936,942,941,-1,936,943,942,-1,936,944,943,-1,936,945,944,-1,936,946,945,-1,936,947,946,-1,936,948,947,-1,936,937,948,-1,937,950,949,-1,937,938,950,-1,938,951,950,-1,938,939,951,-1,939,952,951,-1,939,940,952,-1,940,953,952,-1,940,941,953,-1,941,954,953,-1,941,942,954,-1,942,955,954,-1,942,943,955,-1,943,956,955,-1,943,944,956,-1,944,957,956,-1,944,945,957,-1,945,958,957,-1,945,946,958,-1,946,959,958,-1,946,947,959,-1,947,960,959,-1,947,948,960,-1,948,949,960,-1,948,937,949,-1,961,949,950,-1,961,950,951,-1,961,951,952,-1,961,952,953,-1,961,953,954,-1,961,954,955,-1,961,955,956,-1,961,956,957,-1,961,957,958,-1,961,958,959,-1,961,959,960,-1,961,960,949,-1,962,964,963,-1,962,965,964,-1,962,966,965,-1,962,967,966,-1,962,968,967,-1,962,969,968,-1,962,970,969,-1,962,971,970,-1,962,972,971,-1,962,973,972,-1,962,974,973,-1,962,963,974,-1,963,976,975,-1,963,964,976,-1,964,977,976,-1,964,965,977,-1,965,978,977,-1,965,966,978,-1,966,979,978,-1,966,967,979,-1,967,980,979,-1,967,968,980,-1,968,981,980,-1,968,969,981,-1,969,982,981,-1,969,970,982,-1,970,983,982,-1,970,971,983,-1,971,984,983,-1,971,972,984,-1,972,985,984,-1,972,973,985,-1,973,986,985,-1,973,974,986,-1,974,975,986,-1,974,963,975,-1,987,975,976,-1,987,976,977,-1,987,977,978,-1,987,978,979,-1,987,979,980,-1,987,980,981,-1,987,981,982,-1,987,982,983,-1,987,983,984,-1,987,984,985,-1,987,985,986,-1,987,986,975,-1,988,990,989,-1,988,991,990,-1,988,992,991,-1,988,993,992,-1,988,994,993,-1,988,995,994,-1,988,996,995,-1,988,997,996,-1,988,998,997,-1,988,999,998,-1,988,1000,999,-1,988,989,1000,-1,989,1002,1001,-1,989,990,1002,-1,990,1003,1002,-1,990,991,1003,-1,991,1004,1003,-1,991,992,1004,-1,992,1005,1004,-1,992,993,1005,-1,993,1006,1005,-1,993,994,1006,-1,994,1007,1006,-1,994,995,1007,-1,995,1008,1007,-1,995,996,1008,-1,996,1009,1008,-1,996,997,1009,-1,997,1010,1009,-1,997,998,1010,-1,998,1011,1010,-1,998,999,1011,-1,999,1012,1011,-1,999,1000,1012,-1,1000,1001,1012,-1,1000,989,1001,-1,1013,1001,1002,-1,1013,1002,1003,-1,1013,1003,1004,-1,1013,1004,1005,-1,1013,1005,1006,-1,1013,1006,1007,-1,1013,1007,1008,-1,1013,1008,1009,-1,1013,1009,1010,-1,1013,1010,1011,-1,1013,1011,1012,-1,1013,1012,1001,-1,1014,1016,1015,-1,1014,1017,1016,-1,1014,1018,1017,-1,1014,1019,1018,-1,1014,1020,1019,-1,1014,1021,1020,-1,1014,1022,1021,-1,1014,1023,1022,-1,1014,1024,1023,-1,1014,1025,1024,-1,1014,1026,1025,-1,1014,1015,1026,-1,1015,1028,1027,-1,1015,1016,1028,-1,1016,1029,1028,-1,1016,1017,1029,-1,1017,1030,1029,-1,1017,1018,1030,-1,1018,1031,1030,-1,1018,1019,1031,-1,1019,1032,1031,-1,1019,1020,1032,-1,1020,1033,1032,-1,1020,1021,1033,-1,1021,1034,1033,-1,1021,1022,1034,-1,1022,1035,1034,-1,1022,1023,1035,-1,1023,1036,1035,-1,1023,1024,1036,-1,1024,1037,1036,-1,1024,1025,1037,-1,1025,1038,1037,-1,1025,1026,1038,-1,1026,1027,1038,-1,1026,1015,1027,-1,1039,1027,1028,-1,1039,1028,1029,-1,1039,1029,1030,-1,1039,1030,1031,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_9()
		{
			int[] value = {1039,1031,1032,-1,1039,1032,1033,-1,1039,1033,1034,-1,1039,1034,1035,-1,1039,1035,1036,-1,1039,1036,1037,-1,1039,1037,1038,-1,1039,1038,1027,-1,1040,1042,1041,-1,1040,1043,1042,-1,1040,1044,1043,-1,1040,1045,1044,-1,1040,1046,1045,-1,1040,1047,1046,-1,1040,1048,1047,-1,1040,1049,1048,-1,1040,1050,1049,-1,1040,1051,1050,-1,1040,1052,1051,-1,1040,1041,1052,-1,1041,1054,1053,-1,1041,1042,1054,-1,1042,1055,1054,-1,1042,1043,1055,-1,1043,1056,1055,-1,1043,1044,1056,-1,1044,1057,1056,-1,1044,1045,1057,-1,1045,1058,1057,-1,1045,1046,1058,-1,1046,1059,1058,-1,1046,1047,1059,-1,1047,1060,1059,-1,1047,1048,1060,-1,1048,1061,1060,-1,1048,1049,1061,-1,1049,1062,1061,-1,1049,1050,1062,-1,1050,1063,1062,-1,1050,1051,1063,-1,1051,1064,1063,-1,1051,1052,1064,-1,1052,1053,1064,-1,1052,1041,1053,-1,1065,1053,1054,-1,1065,1054,1055,-1,1065,1055,1056,-1,1065,1056,1057,-1,1065,1057,1058,-1,1065,1058,1059,-1,1065,1059,1060,-1,1065,1060,1061,-1,1065,1061,1062,-1,1065,1062,1063,-1,1065,1063,1064,-1,1065,1064,1053,-1,1066,1068,1067,-1,1066,1069,1068,-1,1066,1070,1069,-1,1066,1071,1070,-1,1066,1072,1071,-1,1066,1073,1072,-1,1066,1074,1073,-1,1066,1075,1074,-1,1066,1076,1075,-1,1066,1077,1076,-1,1066,1078,1077,-1,1066,1067,1078,-1,1067,1080,1079,-1,1067,1068,1080,-1,1068,1081,1080,-1,1068,1069,1081,-1,1069,1082,1081,-1,1069,1070,1082,-1,1070,1083,1082,-1,1070,1071,1083,-1,1071,1084,1083,-1,1071,1072,1084,-1,1072,1085,1084,-1,1072,1073,1085,-1,1073,1086,1085,-1,1073,1074,1086,-1,1074,1087,1086,-1,1074,1075,1087,-1,1075,1088,1087,-1,1075,1076,1088,-1,1076,1089,1088,-1,1076,1077,1089,-1,1077,1090,1089,-1,1077,1078,1090,-1,1078,1079,1090,-1,1078,1067,1079,-1,1091,1079,1080,-1,1091,1080,1081,-1,1091,1081,1082,-1,1091,1082,1083,-1,1091,1083,1084,-1,1091,1084,1085,-1,1091,1085,1086,-1,1091,1086,1087,-1,1091,1087,1088,-1,1091,1088,1089,-1,1091,1089,1090,-1,1091,1090,1079,-1,1092,1094,1093,-1,1092,1095,1094,-1,1092,1096,1095,-1,1092,1097,1096,-1,1092,1098,1097,-1,1092,1099,1098,-1,1092,1100,1099,-1,1092,1101,1100,-1,1092,1102,1101,-1,1092,1103,1102,-1,1092,1104,1103,-1,1092,1093,1104,-1,1093,1106,1105,-1,1093,1094,1106,-1,1094,1107,1106,-1,1094,1095,1107,-1,1095,1108,1107,-1,1095,1096,1108,-1,1096,1109,1108,-1,1096,1097,1109,-1,1097,1110,1109,-1,1097,1098,1110,-1,1098,1111,1110,-1,1098,1099,1111,-1,1099,1112,1111,-1,1099,1100,1112,-1,1100,1113,1112,-1,1100,1101,1113,-1,1101,1114,1113,-1,1101,1102,1114,-1,1102,1115,1114,-1,1102,1103,1115,-1,1103,1116,1115,-1,1103,1104,1116,-1,1104,1105,1116,-1,1104,1093,1105,-1,1117,1105,1106,-1,1117,1106,1107,-1,1117,1107,1108,-1,1117,1108,1109,-1,1117,1109,1110,-1,1117,1110,1111,-1,1117,1111,1112,-1,1117,1112,1113,-1,1117,1113,1114,-1,1117,1114,1115,-1,1117,1115,1116,-1,1117,1116,1105,-1,1118,1120,1119,-1,1118,1121,1120,-1,1118,1122,1121,-1,1118,1123,1122,-1,1118,1124,1123,-1,1118,1125,1124,-1,1118,1126,1125,-1,1118,1127,1126,-1,1118,1128,1127,-1,1118,1129,1128,-1,1118,1130,1129,-1,1118,1119,1130,-1,1119,1132,1131,-1,1119,1120,1132,-1,1120,1133,1132,-1,1120,1121,1133,-1,1121,1134,1133,-1,1121,1122,1134,-1,1122,1135,1134,-1,1122,1123,1135,-1,1123,1136,1135,-1,1123,1124,1136,-1,1124,1137,1136,-1,1124,1125,1137,-1,1125,1138,1137,-1,1125,1126,1138,-1,1126,1139,1138,-1,1126,1127,1139,-1,1127,1140,1139,-1,1127,1128,1140,-1,1128,1141,1140,-1,1128,1129,1141,-1,1129,1142,1141,-1,1129,1130,1142,-1,1130,1131,1142,-1,1130,1119,1131,-1,1143,1131,1132,-1,1143,1132,1133,-1,1143,1133,1134,-1,1143,1134,1135,-1,1143,1135,1136,-1,1143,1136,1137,-1,1143,1137,1138,-1,1143,1138,1139,-1,1143,1139,1140,-1,1143,1140,1141,-1,1143,1141,1142,-1,1143,1142,1131,-1,1144,1146,1145,-1,1144,1147,1146,-1,1144,1148,1147,-1,1144,1149,1148,-1,1144,1150,1149,-1,1144,1151,1150,-1,1144,1152,1151,-1,1144,1153,1152,-1,1144,1154,1153,-1,1144,1155,1154,-1,1144,1156,1155,-1,1144,1145,1156,-1,1145,1158,1157,-1,1145,1146,1158,-1,1146,1159,1158,-1,1146,1147,1159,-1,1147,1160,1159,-1,1147,1148,1160,-1,1148,1161,1160,-1,1148,1149,1161,-1,1149,1162,1161,-1,1149,1150,1162,-1,1150,1163,1162,-1,1150,1151,1163,-1,1151,1164,1163,-1,1151,1152,1164,-1,1152,1165,1164,-1,1152,1153,1165,-1,1153,1166,1165,-1,1153,1154,1166,-1,1154,1167,1166,-1,1154,1155,1167,-1,1155,1168,1167,-1,1155,1156,1168,-1,1156,1157,1168,-1,1156,1145,1157,-1,1169,1157,1158,-1,1169,1158,1159,-1,1169,1159,1160,-1,1169,1160,1161,-1,1169,1161,1162,-1,1169,1162,1163,-1,1169,1163,1164,-1,1169,1164,1165,-1,1169,1165,1166,-1,1169,1166,1167,-1,1169,1167,1168,-1,1169,1168,1157,-1,1170,1172,1171,-1,1170,1173,1172,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_10()
		{
			int[] value = {1170,1174,1173,-1,1170,1175,1174,-1,1170,1176,1175,-1,1170,1177,1176,-1,1170,1178,1177,-1,1170,1179,1178,-1,1170,1180,1179,-1,1170,1181,1180,-1,1170,1182,1181,-1,1170,1171,1182,-1,1171,1184,1183,-1,1171,1172,1184,-1,1172,1185,1184,-1,1172,1173,1185,-1,1173,1186,1185,-1,1173,1174,1186,-1,1174,1187,1186,-1,1174,1175,1187,-1,1175,1188,1187,-1,1175,1176,1188,-1,1176,1189,1188,-1,1176,1177,1189,-1,1177,1190,1189,-1,1177,1178,1190,-1,1178,1191,1190,-1,1178,1179,1191,-1,1179,1192,1191,-1,1179,1180,1192,-1,1180,1193,1192,-1,1180,1181,1193,-1,1181,1194,1193,-1,1181,1182,1194,-1,1182,1183,1194,-1,1182,1171,1183,-1,1195,1183,1184,-1,1195,1184,1185,-1,1195,1185,1186,-1,1195,1186,1187,-1,1195,1187,1188,-1,1195,1188,1189,-1,1195,1189,1190,-1,1195,1190,1191,-1,1195,1191,1192,-1,1195,1192,1193,-1,1195,1193,1194,-1,1195,1194,1183,-1,1196,1198,1197,-1,1196,1199,1198,-1,1196,1200,1199,-1,1196,1201,1200,-1,1196,1202,1201,-1,1196,1203,1202,-1,1196,1204,1203,-1,1196,1205,1204,-1,1196,1206,1205,-1,1196,1207,1206,-1,1196,1208,1207,-1,1196,1197,1208,-1,1197,1210,1209,-1,1197,1198,1210,-1,1198,1211,1210,-1,1198,1199,1211,-1,1199,1212,1211,-1,1199,1200,1212,-1,1200,1213,1212,-1,1200,1201,1213,-1,1201,1214,1213,-1,1201,1202,1214,-1,1202,1215,1214,-1,1202,1203,1215,-1,1203,1216,1215,-1,1203,1204,1216,-1,1204,1217,1216,-1,1204,1205,1217,-1,1205,1218,1217,-1,1205,1206,1218,-1,1206,1219,1218,-1,1206,1207,1219,-1,1207,1220,1219,-1,1207,1208,1220,-1,1208,1209,1220,-1,1208,1197,1209,-1,1221,1209,1210,-1,1221,1210,1211,-1,1221,1211,1212,-1,1221,1212,1213,-1,1221,1213,1214,-1,1221,1214,1215,-1,1221,1215,1216,-1,1221,1216,1217,-1,1221,1217,1218,-1,1221,1218,1219,-1,1221,1219,1220,-1,1221,1220,1209,-1,1224,1222,1225,-1,1223,1225,1222,-1,1227,1226,1229,-1,1228,1229,1226,-1,1223,1222,1227,-1,1226,1227,1222,-1,1225,1223,1229,-1,1227,1229,1223,-1,1224,1225,1228,-1,1229,1228,1225,-1,1222,1224,1226,-1,1228,1226,1224,-1,1230,1232,1231,-1,1230,1233,1232,-1,1230,1234,1233,-1,1230,1235,1234,-1,1230,1236,1235,-1,1230,1237,1236,-1,1230,1238,1237,-1,1230,1239,1238,-1,1230,1240,1239,-1,1230,1241,1240,-1,1230,1242,1241,-1,1230,1231,1242,-1,1231,1244,1243,-1,1231,1232,1244,-1,1232,1245,1244,-1,1232,1233,1245,-1,1233,1246,1245,-1,1233,1234,1246,-1,1234,1247,1246,-1,1234,1235,1247,-1,1235,1248,1247,-1,1235,1236,1248,-1,1236,1249,1248,-1,1236,1237,1249,-1,1237,1250,1249,-1,1237,1238,1250,-1,1238,1251,1250,-1,1238,1239,1251,-1,1239,1252,1251,-1,1239,1240,1252,-1,1240,1253,1252,-1,1240,1241,1253,-1,1241,1254,1253,-1,1241,1242,1254,-1,1242,1243,1254,-1,1242,1231,1243,-1,1255,1243,1244,-1,1255,1244,1245,-1,1255,1245,1246,-1,1255,1246,1247,-1,1255,1247,1248,-1,1255,1248,1249,-1,1255,1249,1250,-1,1255,1250,1251,-1,1255,1251,1252,-1,1255,1252,1253,-1,1255,1253,1254,-1,1255,1254,1243,-1,1256,1258,1257,-1,1256,1259,1258,-1,1256,1260,1259,-1,1256,1261,1260,-1,1256,1262,1261,-1,1256,1263,1262,-1,1256,1264,1263,-1,1256,1265,1264,-1,1256,1266,1265,-1,1256,1267,1266,-1,1256,1268,1267,-1,1256,1257,1268,-1,1257,1270,1269,-1,1257,1258,1270,-1,1258,1271,1270,-1,1258,1259,1271,-1,1259,1272,1271,-1,1259,1260,1272,-1,1260,1273,1272,-1,1260,1261,1273,-1,1261,1274,1273,-1,1261,1262,1274,-1,1262,1275,1274,-1,1262,1263,1275,-1,1263,1276,1275,-1,1263,1264,1276,-1,1264,1277,1276,-1,1264,1265,1277,-1,1265,1278,1277,-1,1265,1266,1278,-1,1266,1279,1278,-1,1266,1267,1279,-1,1267,1280,1279,-1,1267,1268,1280,-1,1268,1269,1280,-1,1268,1257,1269,-1,1281,1269,1270,-1,1281,1270,1271,-1,1281,1271,1272,-1,1281,1272,1273,-1,1281,1273,1274,-1,1281,1274,1275,-1,1281,1275,1276,-1,1281,1276,1277,-1,1281,1277,1278,-1,1281,1278,1279,-1,1281,1279,1280,-1,1281,1280,1269,-1,1282,1284,1283,-1,1282,1285,1284,-1,1282,1286,1285,-1,1282,1287,1286,-1,1282,1288,1287,-1,1282,1289,1288,-1,1282,1290,1289,-1,1282,1291,1290,-1,1282,1292,1291,-1,1282,1293,1292,-1,1282,1294,1293,-1,1282,1283,1294,-1,1283,1296,1295,-1,1283,1284,1296,-1,1284,1297,1296,-1,1284,1285,1297,-1,1285,1298,1297,-1,1285,1286,1298,-1,1286,1299,1298,-1,1286,1287,1299,-1,1287,1300,1299,-1,1287,1288,1300,-1,1288,1301,1300,-1,1288,1289,1301,-1,1289,1302,1301,-1,1289,1290,1302,-1,1290,1303,1302,-1,1290,1291,1303,-1,1291,1304,1303,-1,1291,1292,1304,-1,1292,1305,1304,-1,1292,1293,1305,-1,1293,1306,1305,-1,1293,1294,1306,-1,1294,1295,1306,-1,1294,1283,1295,-1,1307,1295,1296,-1,1307,1296,1297,-1,1307,1297,1298,-1,1307,1298,1299,-1,1307,1299,1300,-1,1307,1300,1301,-1,1307,1301,1302,-1,1307,1302,1303,-1,1307,1303,1304,-1,1307,1304,1305,-1,1307,1305,1306,-1,1307,1306,1295,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_11()
		{
			int[] value = {1308,1310,1309,-1,1308,1311,1310,-1,1308,1312,1311,-1,1308,1313,1312,-1,1308,1314,1313,-1,1308,1315,1314,-1,1308,1316,1315,-1,1308,1317,1316,-1,1308,1318,1317,-1,1308,1319,1318,-1,1308,1320,1319,-1,1308,1309,1320,-1,1309,1322,1321,-1,1309,1310,1322,-1,1310,1323,1322,-1,1310,1311,1323,-1,1311,1324,1323,-1,1311,1312,1324,-1,1312,1325,1324,-1,1312,1313,1325,-1,1313,1326,1325,-1,1313,1314,1326,-1,1314,1327,1326,-1,1314,1315,1327,-1,1315,1328,1327,-1,1315,1316,1328,-1,1316,1329,1328,-1,1316,1317,1329,-1,1317,1330,1329,-1,1317,1318,1330,-1,1318,1331,1330,-1,1318,1319,1331,-1,1319,1332,1331,-1,1319,1320,1332,-1,1320,1321,1332,-1,1320,1309,1321,-1,1333,1321,1322,-1,1333,1322,1323,-1,1333,1323,1324,-1,1333,1324,1325,-1,1333,1325,1326,-1,1333,1326,1327,-1,1333,1327,1328,-1,1333,1328,1329,-1,1333,1329,1330,-1,1333,1330,1331,-1,1333,1331,1332,-1,1333,1332,1321,-1,1334,1336,1335,-1,1334,1337,1336,-1,1334,1338,1337,-1,1334,1339,1338,-1,1334,1340,1339,-1,1334,1341,1340,-1,1334,1342,1341,-1,1334,1343,1342,-1,1334,1344,1343,-1,1334,1345,1344,-1,1334,1346,1345,-1,1334,1335,1346,-1,1335,1348,1347,-1,1335,1336,1348,-1,1336,1349,1348,-1,1336,1337,1349,-1,1337,1350,1349,-1,1337,1338,1350,-1,1338,1351,1350,-1,1338,1339,1351,-1,1339,1352,1351,-1,1339,1340,1352,-1,1340,1353,1352,-1,1340,1341,1353,-1,1341,1354,1353,-1,1341,1342,1354,-1,1342,1355,1354,-1,1342,1343,1355,-1,1343,1356,1355,-1,1343,1344,1356,-1,1344,1357,1356,-1,1344,1345,1357,-1,1345,1358,1357,-1,1345,1346,1358,-1,1346,1347,1358,-1,1346,1335,1347,-1,1359,1347,1348,-1,1359,1348,1349,-1,1359,1349,1350,-1,1359,1350,1351,-1,1359,1351,1352,-1,1359,1352,1353,-1,1359,1353,1354,-1,1359,1354,1355,-1,1359,1355,1356,-1,1359,1356,1357,-1,1359,1357,1358,-1,1359,1358,1347,-1,1360,1362,1361,-1,1360,1363,1362,-1,1360,1364,1363,-1,1360,1365,1364,-1,1360,1366,1365,-1,1360,1367,1366,-1,1360,1368,1367,-1,1360,1369,1368,-1,1360,1370,1369,-1,1360,1371,1370,-1,1360,1372,1371,-1,1360,1361,1372,-1,1361,1374,1373,-1,1361,1362,1374,-1,1362,1375,1374,-1,1362,1363,1375,-1,1363,1376,1375,-1,1363,1364,1376,-1,1364,1377,1376,-1,1364,1365,1377,-1,1365,1378,1377,-1,1365,1366,1378,-1,1366,1379,1378,-1,1366,1367,1379,-1,1367,1380,1379,-1,1367,1368,1380,-1,1368,1381,1380,-1,1368,1369,1381,-1,1369,1382,1381,-1,1369,1370,1382,-1,1370,1383,1382,-1,1370,1371,1383,-1,1371,1384,1383,-1,1371,1372,1384,-1,1372,1373,1384,-1,1372,1361,1373,-1,1385,1373,1374,-1,1385,1374,1375,-1,1385,1375,1376,-1,1385,1376,1377,-1,1385,1377,1378,-1,1385,1378,1379,-1,1385,1379,1380,-1,1385,1380,1381,-1,1385,1381,1382,-1,1385,1382,1383,-1,1385,1383,1384,-1,1385,1384,1373,-1,1386,1388,1387,-1,1386,1389,1388,-1,1386,1390,1389,-1,1386,1391,1390,-1,1386,1392,1391,-1,1386,1393,1392,-1,1386,1394,1393,-1,1386,1395,1394,-1,1386,1396,1395,-1,1386,1397,1396,-1,1386,1398,1397,-1,1386,1387,1398,-1,1387,1400,1399,-1,1387,1388,1400,-1,1388,1401,1400,-1,1388,1389,1401,-1,1389,1402,1401,-1,1389,1390,1402,-1,1390,1403,1402,-1,1390,1391,1403,-1,1391,1404,1403,-1,1391,1392,1404,-1,1392,1405,1404,-1,1392,1393,1405,-1,1393,1406,1405,-1,1393,1394,1406,-1,1394,1407,1406,-1,1394,1395,1407,-1,1395,1408,1407,-1,1395,1396,1408,-1,1396,1409,1408,-1,1396,1397,1409,-1,1397,1410,1409,-1,1397,1398,1410,-1,1398,1399,1410,-1,1398,1387,1399,-1,1411,1399,1400,-1,1411,1400,1401,-1,1411,1401,1402,-1,1411,1402,1403,-1,1411,1403,1404,-1,1411,1404,1405,-1,1411,1405,1406,-1,1411,1406,1407,-1,1411,1407,1408,-1,1411,1408,1409,-1,1411,1409,1410,-1,1411,1410,1399,-1,1414,1412,1415,-1,1413,1415,1412,-1,1417,1416,1419,-1,1418,1419,1416,-1,1413,1412,1417,-1,1416,1417,1412,-1,1415,1413,1419,-1,1417,1419,1413,-1,1414,1415,1418,-1,1419,1418,1415,-1,1412,1414,1416,-1,1418,1416,1414,-1,1420,1422,1421,-1,1420,1423,1422,-1,1420,1424,1423,-1,1420,1425,1424,-1,1420,1426,1425,-1,1420,1427,1426,-1,1420,1428,1427,-1,1420,1429,1428,-1,1420,1430,1429,-1,1420,1431,1430,-1,1420,1432,1431,-1,1420,1421,1432,-1,1421,1434,1433,-1,1421,1422,1434,-1,1422,1435,1434,-1,1422,1423,1435,-1,1423,1436,1435,-1,1423,1424,1436,-1,1424,1437,1436,-1,1424,1425,1437,-1,1425,1438,1437,-1,1425,1426,1438,-1,1426,1439,1438,-1,1426,1427,1439,-1,1427,1440,1439,-1,1427,1428,1440,-1,1428,1441,1440,-1,1428,1429,1441,-1,1429,1442,1441,-1,1429,1430,1442,-1,1430,1443,1442,-1,1430,1431,1443,-1,1431,1444,1443,-1,1431,1432,1444,-1,1432,1433,1444,-1,1432,1421,1433,-1,1445,1433,1434,-1,1445,1434,1435,-1,1445,1435,1436,-1,1445,1436,1437,-1,1445,1437,1438,-1,1445,1438,1439,-1,1445,1439,1440,-1,1445,1440,1441,-1,1445,1441,1442,-1,1445,1442,1443,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_12()
		{
			int[] value = {1445,1443,1444,-1,1445,1444,1433,-1,1446,1448,1447,-1,1446,1449,1448,-1,1446,1450,1449,-1,1446,1451,1450,-1,1446,1452,1451,-1,1446,1453,1452,-1,1446,1454,1453,-1,1446,1455,1454,-1,1446,1456,1455,-1,1446,1457,1456,-1,1446,1458,1457,-1,1446,1447,1458,-1,1447,1460,1459,-1,1447,1448,1460,-1,1448,1461,1460,-1,1448,1449,1461,-1,1449,1462,1461,-1,1449,1450,1462,-1,1450,1463,1462,-1,1450,1451,1463,-1,1451,1464,1463,-1,1451,1452,1464,-1,1452,1465,1464,-1,1452,1453,1465,-1,1453,1466,1465,-1,1453,1454,1466,-1,1454,1467,1466,-1,1454,1455,1467,-1,1455,1468,1467,-1,1455,1456,1468,-1,1456,1469,1468,-1,1456,1457,1469,-1,1457,1470,1469,-1,1457,1458,1470,-1,1458,1459,1470,-1,1458,1447,1459,-1,1471,1459,1460,-1,1471,1460,1461,-1,1471,1461,1462,-1,1471,1462,1463,-1,1471,1463,1464,-1,1471,1464,1465,-1,1471,1465,1466,-1,1471,1466,1467,-1,1471,1467,1468,-1,1471,1468,1469,-1,1471,1469,1470,-1,1471,1470,1459,-1,1472,1474,1473,-1,1472,1475,1474,-1,1472,1476,1475,-1,1472,1477,1476,-1,1472,1478,1477,-1,1472,1479,1478,-1,1472,1480,1479,-1,1472,1481,1480,-1,1472,1482,1481,-1,1472,1483,1482,-1,1472,1484,1483,-1,1472,1473,1484,-1,1473,1486,1485,-1,1473,1474,1486,-1,1474,1487,1486,-1,1474,1475,1487,-1,1475,1488,1487,-1,1475,1476,1488,-1,1476,1489,1488,-1,1476,1477,1489,-1,1477,1490,1489,-1,1477,1478,1490,-1,1478,1491,1490,-1,1478,1479,1491,-1,1479,1492,1491,-1,1479,1480,1492,-1,1480,1493,1492,-1,1480,1481,1493,-1,1481,1494,1493,-1,1481,1482,1494,-1,1482,1495,1494,-1,1482,1483,1495,-1,1483,1496,1495,-1,1483,1484,1496,-1,1484,1485,1496,-1,1484,1473,1485,-1,1497,1485,1486,-1,1497,1486,1487,-1,1497,1487,1488,-1,1497,1488,1489,-1,1497,1489,1490,-1,1497,1490,1491,-1,1497,1491,1492,-1,1497,1492,1493,-1,1497,1493,1494,-1,1497,1494,1495,-1,1497,1495,1496,-1,1497,1496,1485,-1,1498,1500,1499,-1,1498,1501,1500,-1,1498,1502,1501,-1,1498,1503,1502,-1,1498,1504,1503,-1,1498,1505,1504,-1,1498,1506,1505,-1,1498,1507,1506,-1,1498,1508,1507,-1,1498,1509,1508,-1,1498,1510,1509,-1,1498,1499,1510,-1,1499,1512,1511,-1,1499,1500,1512,-1,1500,1513,1512,-1,1500,1501,1513,-1,1501,1514,1513,-1,1501,1502,1514,-1,1502,1515,1514,-1,1502,1503,1515,-1,1503,1516,1515,-1,1503,1504,1516,-1,1504,1517,1516,-1,1504,1505,1517,-1,1505,1518,1517,-1,1505,1506,1518,-1,1506,1519,1518,-1,1506,1507,1519,-1,1507,1520,1519,-1,1507,1508,1520,-1,1508,1521,1520,-1,1508,1509,1521,-1,1509,1522,1521,-1,1509,1510,1522,-1,1510,1511,1522,-1,1510,1499,1511,-1,1523,1511,1512,-1,1523,1512,1513,-1,1523,1513,1514,-1,1523,1514,1515,-1,1523,1515,1516,-1,1523,1516,1517,-1,1523,1517,1518,-1,1523,1518,1519,-1,1523,1519,1520,-1,1523,1520,1521,-1,1523,1521,1522,-1,1523,1522,1511,-1,1524,1526,1525,-1,1524,1527,1526,-1,1524,1528,1527,-1,1524,1529,1528,-1,1524,1530,1529,-1,1524,1531,1530,-1,1524,1532,1531,-1,1524,1533,1532,-1,1524,1534,1533,-1,1524,1535,1534,-1,1524,1536,1535,-1,1524,1525,1536,-1,1525,1538,1537,-1,1525,1526,1538,-1,1526,1539,1538,-1,1526,1527,1539,-1,1527,1540,1539,-1,1527,1528,1540,-1,1528,1541,1540,-1,1528,1529,1541,-1,1529,1542,1541,-1,1529,1530,1542,-1,1530,1543,1542,-1,1530,1531,1543,-1,1531,1544,1543,-1,1531,1532,1544,-1,1532,1545,1544,-1,1532,1533,1545,-1,1533,1546,1545,-1,1533,1534,1546,-1,1534,1547,1546,-1,1534,1535,1547,-1,1535,1548,1547,-1,1535,1536,1548,-1,1536,1537,1548,-1,1536,1525,1537,-1,1549,1537,1538,-1,1549,1538,1539,-1,1549,1539,1540,-1,1549,1540,1541,-1,1549,1541,1542,-1,1549,1542,1543,-1,1549,1543,1544,-1,1549,1544,1545,-1,1549,1545,1546,-1,1549,1546,1547,-1,1549,1547,1548,-1,1549,1548,1537,-1,1550,1552,1551,-1,1550,1553,1552,-1,1550,1554,1553,-1,1550,1555,1554,-1,1550,1556,1555,-1,1550,1557,1556,-1,1550,1558,1557,-1,1550,1559,1558,-1,1550,1560,1559,-1,1550,1561,1560,-1,1550,1562,1561,-1,1550,1551,1562,-1,1551,1564,1563,-1,1551,1552,1564,-1,1552,1565,1564,-1,1552,1553,1565,-1,1553,1566,1565,-1,1553,1554,1566,-1,1554,1567,1566,-1,1554,1555,1567,-1,1555,1568,1567,-1,1555,1556,1568,-1,1556,1569,1568,-1,1556,1557,1569,-1,1557,1570,1569,-1,1557,1558,1570,-1,1558,1571,1570,-1,1558,1559,1571,-1,1559,1572,1571,-1,1559,1560,1572,-1,1560,1573,1572,-1,1560,1561,1573,-1,1561,1574,1573,-1,1561,1562,1574,-1,1562,1563,1574,-1,1562,1551,1563,-1,1575,1563,1564,-1,1575,1564,1565,-1,1575,1565,1566,-1,1575,1566,1567,-1,1575,1567,1568,-1,1575,1568,1569,-1,1575,1569,1570,-1,1575,1570,1571,-1,1575,1571,1572,-1,1575,1572,1573,-1,1575,1573,1574,-1,1575,1574,1563,-1,1576,1578,1577,-1,1576,1579,1578,-1,1576,1580,1579,-1,1576,1581,1580,-1,1576,1582,1581,-1,1576,1583,1582,-1,1576,1584,1583,-1,1576,1585,1584,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_13()
		{
			int[] value = {1576,1586,1585,-1,1576,1587,1586,-1,1576,1588,1587,-1,1576,1577,1588,-1,1577,1590,1589,-1,1577,1578,1590,-1,1578,1591,1590,-1,1578,1579,1591,-1,1579,1592,1591,-1,1579,1580,1592,-1,1580,1593,1592,-1,1580,1581,1593,-1,1581,1594,1593,-1,1581,1582,1594,-1,1582,1595,1594,-1,1582,1583,1595,-1,1583,1596,1595,-1,1583,1584,1596,-1,1584,1597,1596,-1,1584,1585,1597,-1,1585,1598,1597,-1,1585,1586,1598,-1,1586,1599,1598,-1,1586,1587,1599,-1,1587,1600,1599,-1,1587,1588,1600,-1,1588,1589,1600,-1,1588,1577,1589,-1,1601,1589,1590,-1,1601,1590,1591,-1,1601,1591,1592,-1,1601,1592,1593,-1,1601,1593,1594,-1,1601,1594,1595,-1,1601,1595,1596,-1,1601,1596,1597,-1,1601,1597,1598,-1,1601,1598,1599,-1,1601,1599,1600,-1,1601,1600,1589,-1,1602,1604,1603,-1,1602,1605,1604,-1,1602,1606,1605,-1,1602,1607,1606,-1,1602,1608,1607,-1,1602,1609,1608,-1,1602,1610,1609,-1,1602,1611,1610,-1,1602,1612,1611,-1,1602,1613,1612,-1,1602,1614,1613,-1,1602,1603,1614,-1,1603,1616,1615,-1,1603,1604,1616,-1,1604,1617,1616,-1,1604,1605,1617,-1,1605,1618,1617,-1,1605,1606,1618,-1,1606,1619,1618,-1,1606,1607,1619,-1,1607,1620,1619,-1,1607,1608,1620,-1,1608,1621,1620,-1,1608,1609,1621,-1,1609,1622,1621,-1,1609,1610,1622,-1,1610,1623,1622,-1,1610,1611,1623,-1,1611,1624,1623,-1,1611,1612,1624,-1,1612,1625,1624,-1,1612,1613,1625,-1,1613,1626,1625,-1,1613,1614,1626,-1,1614,1615,1626,-1,1614,1603,1615,-1,1627,1615,1616,-1,1627,1616,1617,-1,1627,1617,1618,-1,1627,1618,1619,-1,1627,1619,1620,-1,1627,1620,1621,-1,1627,1621,1622,-1,1627,1622,1623,-1,1627,1623,1624,-1,1627,1624,1625,-1,1627,1625,1626,-1,1627,1626,1615,-1,1628,1630,1629,-1,1628,1631,1630,-1,1628,1632,1631,-1,1628,1633,1632,-1,1628,1634,1633,-1,1628,1635,1634,-1,1628,1636,1635,-1,1628,1637,1636,-1,1628,1638,1637,-1,1628,1639,1638,-1,1628,1640,1639,-1,1628,1629,1640,-1,1629,1642,1641,-1,1629,1630,1642,-1,1630,1643,1642,-1,1630,1631,1643,-1,1631,1644,1643,-1,1631,1632,1644,-1,1632,1645,1644,-1,1632,1633,1645,-1,1633,1646,1645,-1,1633,1634,1646,-1,1634,1647,1646,-1,1634,1635,1647,-1,1635,1648,1647,-1,1635,1636,1648,-1,1636,1649,1648,-1,1636,1637,1649,-1,1637,1650,1649,-1,1637,1638,1650,-1,1638,1651,1650,-1,1638,1639,1651,-1,1639,1652,1651,-1,1639,1640,1652,-1,1640,1641,1652,-1,1640,1629,1641,-1,1653,1641,1642,-1,1653,1642,1643,-1,1653,1643,1644,-1,1653,1644,1645,-1,1653,1645,1646,-1,1653,1646,1647,-1,1653,1647,1648,-1,1653,1648,1649,-1,1653,1649,1650,-1,1653,1650,1651,-1,1653,1651,1652,-1,1653,1652,1641,-1,1654,1656,1655,-1,1654,1657,1656,-1,1654,1658,1657,-1,1654,1659,1658,-1,1654,1660,1659,-1,1654,1661,1660,-1,1654,1662,1661,-1,1654,1663,1662,-1,1654,1664,1663,-1,1654,1665,1664,-1,1654,1666,1665,-1,1654,1655,1666,-1,1655,1668,1667,-1,1655,1656,1668,-1,1656,1669,1668,-1,1656,1657,1669,-1,1657,1670,1669,-1,1657,1658,1670,-1,1658,1671,1670,-1,1658,1659,1671,-1,1659,1672,1671,-1,1659,1660,1672,-1,1660,1673,1672,-1,1660,1661,1673,-1,1661,1674,1673,-1,1661,1662,1674,-1,1662,1675,1674,-1,1662,1663,1675,-1,1663,1676,1675,-1,1663,1664,1676,-1,1664,1677,1676,-1,1664,1665,1677,-1,1665,1678,1677,-1,1665,1666,1678,-1,1666,1667,1678,-1,1666,1655,1667,-1,1679,1667,1668,-1,1679,1668,1669,-1,1679,1669,1670,-1,1679,1670,1671,-1,1679,1671,1672,-1,1679,1672,1673,-1,1679,1673,1674,-1,1679,1674,1675,-1,1679,1675,1676,-1,1679,1676,1677,-1,1679,1677,1678,-1,1679,1678,1667,-1,1682,1680,1683,-1,1681,1683,1680,-1,1685,1684,1687,-1,1686,1687,1684,-1,1681,1680,1685,-1,1684,1685,1680,-1,1683,1681,1687,-1,1685,1687,1681,-1,1682,1683,1686,-1,1687,1686,1683,-1,1680,1682,1684,-1,1686,1684,1682,-1,1688,1690,1689,-1,1688,1691,1690,-1,1688,1692,1691,-1,1688,1693,1692,-1,1688,1694,1693,-1,1688,1695,1694,-1,1688,1696,1695,-1,1688,1697,1696,-1,1688,1698,1697,-1,1688,1699,1698,-1,1688,1700,1699,-1,1688,1689,1700,-1,1689,1702,1701,-1,1689,1690,1702,-1,1690,1703,1702,-1,1690,1691,1703,-1,1691,1704,1703,-1,1691,1692,1704,-1,1692,1705,1704,-1,1692,1693,1705,-1,1693,1706,1705,-1,1693,1694,1706,-1,1694,1707,1706,-1,1694,1695,1707,-1,1695,1708,1707,-1,1695,1696,1708,-1,1696,1709,1708,-1,1696,1697,1709,-1,1697,1710,1709,-1,1697,1698,1710,-1,1698,1711,1710,-1,1698,1699,1711,-1,1699,1712,1711,-1,1699,1700,1712,-1,1700,1701,1712,-1,1700,1689,1701,-1,1713,1701,1702,-1,1713,1702,1703,-1,1713,1703,1704,-1,1713,1704,1705,-1,1713,1705,1706,-1,1713,1706,1707,-1,1713,1707,1708,-1,1713,1708,1709,-1,1713,1709,1710,-1,1713,1710,1711,-1,1713,1711,1712,-1,1713,1712,1701,-1,1714,1716,1715,-1,1714,1717,1716,-1,1714,1718,1717,-1,1714,1719,1718,-1,1714,1720,1719,-1,1714,1721,1720,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_20_coordIndex_14()
		{
			int[] value = {1714,1722,1721,-1,1714,1723,1722,-1,1714,1724,1723,-1,1714,1725,1724,-1,1714,1726,1725,-1,1714,1715,1726,-1,1715,1728,1727,-1,1715,1716,1728,-1,1716,1729,1728,-1,1716,1717,1729,-1,1717,1730,1729,-1,1717,1718,1730,-1,1718,1731,1730,-1,1718,1719,1731,-1,1719,1732,1731,-1,1719,1720,1732,-1,1720,1733,1732,-1,1720,1721,1733,-1,1721,1734,1733,-1,1721,1722,1734,-1,1722,1735,1734,-1,1722,1723,1735,-1,1723,1736,1735,-1,1723,1724,1736,-1,1724,1737,1736,-1,1724,1725,1737,-1,1725,1738,1737,-1,1725,1726,1738,-1,1726,1727,1738,-1,1726,1715,1727,-1,1739,1727,1728,-1,1739,1728,1729,-1,1739,1729,1730,-1,1739,1730,1731,-1,1739,1731,1732,-1,1739,1732,1733,-1,1739,1733,1734,-1,1739,1734,1735,-1,1739,1735,1736,-1,1739,1736,1737,-1,1739,1737,1738,-1,1739,1738,1727,-1,1740,1741,1742,-1,1740,1742,1743,-1,1740,1743,1744,-1,1740,1744,1745,-1,1740,1745,1746,-1,1740,1746,1747,-1,1748,1740,1747,-1,1749,1748,1747,-1,1750,1749,1747,-1,1751,1750,1747,-1,1752,1751,1747,-1,1753,1752,1747,-1,1754,1753,1747,-1,1755,1754,1747,-1,1755,1747,1756,-1,1757,1755,1756,-1,1758,1757,1756,-1,1759,1758,1756,-1,1760,1759,1756,-1,1761,1760,1756,-1,1762,1761,1756,-1,1763,1762,1756,-1,1764,1763,1756,-1,1765,1764,1756,-1,1766,1765,1756,-1,1767,1766,1756,-1,1768,1767,1756,-1,1769,1768,1756,-1,1770,1769,1756,-1,1771,1770,1756,-1,1772,1771,1756,-1,1772,1756,1773,-1,1774,1772,1773,-1,1774,1773,1775,-1,1776,1774,1775,-1,1776,1775,1777,-1,1778,1776,1777,-1,1779,1778,1777,-1,1780,1779,1777,-1,1781,1780,1777,-1,1782,1781,1777,-1,1783,1782,1777,-1,1784,1783,1777,-1,1785,1784,1777,-1,1786,1785,1777,-1,1787,1786,1777,-1,1788,1787,1777,-1,1789,1788,1777,-1,1790,1789,1777,-1,1790,1777,1791,-1,1790,1791,1792,-1,1790,1792,1793,-1,1790,1793,1794,-1,1790,1794,1795,-1,1790,1795,1796,-1,1790,1796,1797,-1,1790,1797,1798,-1,1790,1798,1799,-1,1790,1799,1800,-1,1790,1800,1801,-1,1802,1804,1803,-1,1802,1805,1804,-1,1802,1806,1805,-1,1802,1807,1806,-1,1802,1808,1807,-1,1802,1809,1808,-1,1802,1810,1809,-1,1802,1811,1810,-1,1802,1812,1811,-1,1802,1813,1812,-1,1802,1814,1813,-1,1802,1803,1814,-1,1803,1816,1815,-1,1803,1804,1816,-1,1804,1817,1816,-1,1804,1805,1817,-1,1805,1818,1817,-1,1805,1806,1818,-1,1806,1819,1818,-1,1806,1807,1819,-1,1807,1820,1819,-1,1807,1808,1820,-1,1808,1821,1820,-1,1808,1809,1821,-1,1809,1822,1821,-1,1809,1810,1822,-1,1810,1823,1822,-1,1810,1811,1823,-1,1811,1824,1823,-1,1811,1812,1824,-1,1812,1825,1824,-1,1812,1813,1825,-1,1813,1826,1825,-1,1813,1814,1826,-1,1814,1815,1826,-1,1814,1803,1815,-1,1827,1815,1816,-1,1827,1816,1817,-1,1827,1817,1818,-1,1827,1818,1819,-1,1827,1819,1820,-1,1827,1820,1821,-1,1827,1821,1822,-1,1827,1822,1823,-1,1827,1823,1824,-1,1827,1824,1825,-1,1827,1825,1826,-1,1827,1826,1815,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_6_20_point_1()
		{
			double[] value = {-139.8,3.645,4.884,-138.1,3.645,8.775,-135.1,3.645,11.9,-131.3,3.645,14.63,-127.3,3.645,17.32,-123.7,3.645,20.35,-121.2,3.645,24.07,-120.3,3.645,28.86,-121.4,3.645,33.7,-124.2,3.645,37.54,-128.1,3.645,40.76,-132.4,3.645,43.71,-136.4,3.645,46.75,-139.5,3.645,50.24,-141.1,3.645,54.53,-141.1,3.645,147.2,-139.1,3.645,151.7,-135.7,3.645,158.0,-130.1,3.645,165.1,-121.3,3.645,172.1,-108.5,3.645,178.4,-90.78,3.645,183.0,-67.21,3.645,185.1,67.75,3.645,185.1,78.46,3.645,184.1,88.97,3.645,181.5,98.83,3.645,177.3,107.6,3.645,172.0,114.9,3.645,165.5,120.2,3.645,158.2,123.1,3.645,150.3,123.5,3.645,50.71,121.6,3.645,46.76,118.4,3.645,43.58,114.4,3.645,40.86,110.2,3.645,38.3,106.5,3.645,35.6,103.9,3.645,32.47,103.0,3.645,28.59,104.2,3.645,24.49,107.1,3.645,21.04,111.0,3.645,18.01,115.3,3.645,15.16,119.3,3.645,12.26,122.4,3.645,9.071,123.9,3.645,5.36,123.9,3.645,-107.3,122.9,3.645,-113.2,120.3,3.645,-120.0,116.4,3.645,-127.2,111.3,3.645,-133.8,105.4,3.645,-139.2,98.84,3.645,-142.8,91.85,3.645,-143.7,-62.59,3.645,-143.7,-73.98,3.645,-141.9,-87.94,3.645,-137.2,-102.9,3.645,-130.7,-117.1,3.645,-123.0,-129.1,3.645,-115.0,-137.2,3.645,-107.7,-139.8,3.645,-101.9,-139.8,30.6,4.884,-138.1,30.6,8.775,-135.1,30.6,11.9,-131.3,30.6,14.63,-127.3,30.6,17.32,-123.7,30.6,20.35,-121.2,30.6,24.07,-120.3,30.6,28.86,-121.4,30.6,33.7,-124.2,30.6,37.54,-128.1,30.6,40.76,-132.4,30.6,43.71,-136.4,30.6,46.75,-139.5,30.6,50.24,-141.1,30.6,54.53,-141.1,30.6,147.2,-139.1,30.6,151.7,-135.7,30.6,158.0,-130.1,30.6,165.1,-121.3,30.6,172.1,-108.5,30.6,178.4,-90.78,30.6,183.0,-67.21,30.6,185.1,67.75,30.6,185.1,78.46,30.6,184.1,88.97,30.6,181.5,98.83,30.6,177.3,107.6,30.6,172.0,114.9,30.6,165.5,120.2,30.6,158.2,123.1,30.6,150.3,123.5,30.6,50.71,121.6,30.6,46.76,118.4,30.6,43.58,114.4,30.6,40.86,110.2,30.6,38.3,106.5,30.6,35.6,103.9,30.6,32.47};
			return value;
		}
		private double[] getCoordinate_6_20_point_2()
		{
			double[] value = {103.0,30.6,28.59,104.2,30.6,24.49,107.1,30.6,21.04,111.0,30.6,18.01,115.3,30.6,15.16,119.3,30.6,12.26,122.4,30.6,9.071,123.9,30.6,5.36,123.9,30.6,-107.3,122.9,30.6,-113.2,120.3,30.6,-120.0,116.4,30.6,-127.2,111.3,30.6,-133.8,105.4,30.6,-139.2,98.84,30.6,-142.8,91.85,30.6,-143.7,-62.59,30.6,-143.7,-73.98,30.6,-141.9,-87.94,30.6,-137.2,-102.9,30.6,-130.7,-117.1,30.6,-123.0,-129.1,30.6,-115.0,-137.2,30.6,-107.7,-139.8,30.6,-101.9,-138.2,32.46,5.035,-136.6,32.46,8.889,-133.6,32.46,11.99,-129.8,32.46,14.69,-125.9,32.46,17.35,-122.3,32.46,20.35,-119.8,32.46,24.04,-118.9,32.46,28.79,-120.0,32.46,33.57,-122.8,32.46,37.38,-126.7,32.46,40.57,-130.9,32.46,43.5,-134.9,32.46,46.51,-138.0,32.46,49.96,-139.6,32.46,54.21,-139.6,32.46,146.0,-137.5,32.46,150.5,-134.2,32.46,156.7,-128.6,32.46,163.7,-119.9,32.46,170.7,-107.3,32.46,176.9,-89.7,32.46,181.5,-66.34,32.46,183.6,67.33,32.46,183.6,77.94,32.46,182.6,88.35,32.46,179.9,98.12,32.46,175.9,106.8,32.46,170.5,114.0,32.46,164.1,119.3,32.46,156.9,122.2,32.46,149.0,122.5,32.46,50.43,120.7,32.46,46.51,117.5,32.46,43.36,113.5,32.46,40.67,109.4,32.46,38.13,105.8,32.46,35.46,103.2,32.46,32.36,102.3,32.46,28.51,103.4,32.46,24.45,106.3,32.46,21.04,110.2,32.46,18.04,114.5,32.46,15.21,118.4,32.46,12.34,121.5,32.46,9.182,122.9,32.46,5.507,122.9,32.46,-106.1,121.9,32.46,-111.9,119.4,32.46,-118.7,115.5,32.46,-125.7,110.5,32.46,-132.3,104.6,32.46,-137.7,98.13,32.46,-141.2,91.21,32.46,-142.1,-61.77,32.46,-142.1,-73.05,32.46,-140.3,-86.88,32.46,-135.7,-101.7,32.46,-129.2,-115.8,32.46,-121.6,-127.6,32.46,-113.8,-135.7,32.46,-106.5,-138.2,32.46,-100.8,-133.7,33.47,5.479,-132.1,33.47,9.225,-129.1,33.47,12.23,-125.5,33.47,14.86,-121.6,33.47,17.45,-118.2,33.47,20.37,-115.7,33.47,23.95,-114.9,33.47,28.56,-116.0,33.47,33.21,-118.7,33.47,36.92,-122.4,33.47,40.01,-126.5,33.47,42.85,-130.4,33.47,45.78,-133.4,33.47,49.14};
			return value;
		}
		private double[] getCoordinate_6_20_point_3()
		{
			double[] value = {-134.9,33.47,53.27,-134.9,33.47,142.4,-133.0,33.47,146.8,-129.7,33.47,152.9,-124.3,33.47,159.7,-115.9,33.47,166.5,-103.6,33.47,172.5,-86.49,33.47,176.9,-63.8,33.47,179.0,66.11,33.47,179.0,76.42,33.47,178.0,86.53,33.47,175.5,96.03,33.47,171.5,104.5,33.47,166.3,111.5,33.47,160.1,116.6,33.47,153.1,119.4,33.47,145.4,119.8,33.47,49.59,118.0,33.47,45.79,114.8,33.47,42.72,111.0,33.47,40.11,107.0,33.47,37.64,103.5,33.47,35.05,100.9,33.47,32.03,100.1,33.47,28.3,101.2,33.47,24.35,104.0,33.47,21.03,107.8,33.47,18.11,111.9,33.47,15.37,115.8,33.47,12.58,118.7,33.47,9.51,120.1,33.47,5.938,120.1,33.47,-102.5,119.2,33.47,-108.2,116.7,33.47,-114.8,112.9,33.47,-121.6,108.1,33.47,-128.0,102.4,33.47,-133.2,96.04,33.47,-136.6,89.31,33.47,-137.5,-59.35,33.47,-137.5,-70.31,33.47,-135.8,-83.75,33.47,-131.3,-98.11,33.47,-125.0,-111.8,33.47,-117.6,-123.4,33.47,-110.0,-131.2,33.47,-102.9,-133.6,33.47,-97.34,-129.7,33.67,4.666,-128.7,33.67,6.976,-126.5,33.67,9.194,-123.2,33.67,11.58,-119.2,33.67,14.26,-115.2,33.67,17.67,-112.0,33.67,22.38,-110.8,33.67,28.65,-112.3,33.67,34.93,-115.8,33.67,39.67,-120.0,33.67,43.2,-124.2,33.67,46.09,-127.7,33.67,48.73,-129.9,33.67,51.24,-131.0,33.67,53.99,-131.0,33.67,141.6,-129.4,33.67,145.1,-126.4,33.67,150.6,-121.5,33.67,156.8,-113.7,33.67,163.1,-102.2,33.67,168.7,-85.81,33.67,173.0,-63.62,33.67,175.0,65.92,33.67,175.0,75.74,33.67,174.1,85.27,33.67,171.7,94.2,33.67,167.9,102.1,33.67,163.1,108.5,33.67,157.4,113.0,33.67,151.2,115.4,33.67,144.7,115.8,33.67,50.48,114.7,33.67,48.14,112.3,33.67,45.82,108.8,33.67,43.46,104.8,33.67,40.96,100.7,33.67,37.98,97.27,33.67,33.86,95.92,33.67,28.19,97.6,33.67,22.43,101.2,33.67,18.13,105.4,33.67,14.86,109.6,33.67,12.09,113.1,33.67,9.552,115.3,33.67,7.311,116.1,33.67,5.181,116.1,33.67,-102.1,115.3,33.67,-107.1,113.1,33.67,-113.1,109.6,33.67,-119.4,105.1,33.67,-125.3,100.0,33.67,-130.0};
			return value;
		}
		private double[] getCoordinate_6_20_point_4()
		{
			double[] value = {94.79,33.67,-132.8,89.05,33.67,-133.5,-59.04,33.67,-133.5,-69.37,33.67,-131.9,-82.31,33.67,-127.6,-96.35,33.67,-121.4,-109.8,33.67,-114.2,-120.9,33.67,-106.8,-127.9,33.67,-100.5,-129.6,33.67,-96.49,-128.5,33.47,4.421,-127.7,33.47,6.302,-125.8,33.47,8.282,-122.5,33.47,10.59,-118.5,33.47,13.31,-114.3,33.47,16.86,-110.8,33.47,21.91,-109.5,33.47,28.68,-111.2,33.47,35.44,-114.9,33.47,40.5,-119.3,33.47,44.15,-123.5,33.47,47.06,-126.9,33.47,49.62,-128.9,33.47,51.87,-129.8,33.47,54.21,-129.8,33.47,141.3,-128.3,33.47,144.5,-125.4,33.47,150.0,-120.6,33.47,156.0,-113.1,33.47,162.1,-101.8,33.47,167.6,-85.6,33.47,171.8,-63.56,33.47,173.8,65.87,33.47,173.8,75.54,33.47,172.9,84.89,33.47,170.5,93.66,33.47,166.9,101.4,33.47,162.1,107.6,33.47,156.6,112.0,33.47,150.6,114.2,33.47,144.5,114.6,33.47,50.75,113.7,33.47,48.84,111.5,33.47,46.75,108.2,33.47,44.46,104.1,33.47,41.95,99.87,33.47,38.86,96.17,33.47,34.41,94.68,33.47,28.16,96.52,33.47,21.85,100.4,33.47,17.27,104.7,33.47,13.89,108.9,33.47,11.1,112.3,33.47,8.645,114.3,33.47,6.652,114.9,33.47,4.953,114.9,33.47,-102.0,114.1,33.47,-106.8,112.0,33.47,-112.6,108.6,33.47,-118.8,104.2,33.47,-124.5,99.33,33.47,-129.0,94.42,33.47,-131.6,88.98,33.47,-132.3,-58.94,33.47,-132.3,-69.08,33.47,-130.7,-81.88,33.47,-126.5,-95.83,33.47,-120.3,-109.2,33.47,-113.1,-120.2,33.47,-105.8,-126.9,33.47,-99.82,-128.5,33.47,-96.24,-128.5,25.08,4.421,-127.7,25.08,6.302,-125.8,25.08,8.282,-122.5,25.08,10.59,-118.5,25.08,13.31,-114.3,25.08,16.86,-110.8,25.08,21.91,-109.5,25.08,28.68,-111.2,25.08,35.44,-114.9,25.08,40.5,-119.3,25.08,44.15,-123.5,25.08,47.06,-126.9,25.08,49.62,-128.9,25.08,51.87,-129.8,25.08,54.21,-129.8,25.08,141.3,-128.3,25.08,144.5,-125.4,25.08,150.0,-120.6,25.08,156.0,-113.1,25.08,162.1,-101.8,25.08,167.6,-85.6,25.08,171.8,-63.56,25.08,173.8,65.87,25.08,173.8,75.54,25.08,172.9,84.89,25.08,170.5,93.66,25.08,166.9,101.4,25.08,162.1};
			return value;
		}
		private double[] getCoordinate_6_20_point_5()
		{
			double[] value = {107.6,25.08,156.6,112.0,25.08,150.6,114.2,25.08,144.5,114.6,25.08,50.75,113.7,25.08,48.84,111.5,25.08,46.75,108.2,25.08,44.46,104.1,25.08,41.95,99.87,25.08,38.86,96.17,25.08,34.41,94.68,25.08,28.16,96.52,25.08,21.85,100.4,25.08,17.27,104.7,25.08,13.89,108.9,25.08,11.1,112.3,25.08,8.645,114.3,25.08,6.652,114.9,25.08,4.953,114.9,25.08,-102.0,114.1,25.08,-106.8,112.0,25.08,-112.6,108.6,25.08,-118.8,104.2,25.08,-124.5,99.33,25.08,-129.0,94.42,25.08,-131.6,88.98,25.08,-132.3,-58.94,25.08,-132.3,-69.08,25.08,-130.7,-81.88,25.08,-126.5,-95.83,25.08,-120.3,-109.2,25.08,-113.1,-120.2,25.08,-105.8,-126.9,25.08,-99.82,-128.5,25.08,-96.24,-141.8,10.33,-144.5,124.0,10.33,-144.5,-141.8,10.33,63.59,124.0,10.33,63.59,-141.8,10.33,187.2,124.0,10.33,187.2,-143.5,9.882,-144.5,-143.5,9.882,63.59,-143.5,9.882,187.2,-143.3,9.882,188.1,-142.7,9.882,188.7,-141.8,9.882,188.9,124.0,9.882,188.9,124.8,9.882,188.7,125.4,9.882,188.1,125.6,9.882,187.2,125.6,9.882,63.59,125.6,9.882,-144.5,-144.7,8.656,-144.5,-144.7,8.656,63.59,-144.7,8.656,187.2,-144.4,8.656,188.7,-143.3,8.656,189.7,-141.8,8.656,190.1,124.0,8.656,190.1,125.4,8.656,189.7,126.5,8.656,188.7,126.9,8.656,187.2,126.9,8.656,63.59,126.9,8.656,-144.5,-145.2,6.981,-144.5,-145.2,6.981,63.59,-145.2,6.981,187.2,-144.7,6.981,188.9,-143.5,6.981,190.1,-141.8,6.981,190.6,124.0,6.981,190.6,125.6,6.981,190.1,126.9,6.981,188.9,127.3,6.981,187.2,127.3,6.981,63.59,127.3,6.981,-144.5,-145.2,-16.47,-144.5,-145.2,-16.47,63.59,-145.2,-16.47,187.2,-144.7,-16.47,188.9,-143.5,-16.47,190.1,-141.8,-16.47,190.6,124.0,-16.47,190.6,125.6,-16.47,190.1,126.9,-16.47,188.9,127.3,-16.47,187.2,127.3,-16.47,63.59,127.3,-16.47,-144.5,-144.7,-18.15,-144.5,-144.7,-18.15,63.59,-144.7,-18.15,187.2,-144.4,-18.15,188.7,-143.3,-18.15,189.7,-141.8,-18.15,190.1,124.0,-18.15,190.1,125.4,-18.15,189.7,126.5,-18.15,188.7,126.9,-18.15,187.2,126.9,-18.15,63.59,126.9,-18.15,-144.5};
			return value;
		}
		private double[] getCoordinate_6_20_point_6()
		{
			double[] value = {-143.5,-19.37,-144.5,-143.5,-19.37,63.59,-143.5,-19.37,187.2,-143.3,-19.37,188.1,-142.7,-19.37,188.7,-141.8,-19.37,188.9,124.0,-19.37,188.9,124.8,-19.37,188.7,125.4,-19.37,188.1,125.6,-19.37,187.2,125.6,-19.37,63.59,125.6,-19.37,-144.5,124.0,-19.82,187.2,-141.8,-19.82,187.2,124.0,-19.82,63.59,-141.8,-19.82,63.59,124.0,-19.82,-144.5,-141.8,-19.82,-144.5,118.5,-20.02,58.15,-136.4,-20.02,58.15,118.5,-20.02,-144.5,-136.4,-20.02,-144.5,118.5,-2.083,58.15,-136.4,-2.083,58.15,118.5,-2.083,-144.4,-136.4,-2.083,-144.4,-141.8,9.924,-145.5,123.9,9.924,-145.5,-143.3,9.516,-145.5,125.4,9.516,-145.5,-144.4,8.442,-145.5,126.5,8.443,-145.5,-144.8,6.922,-145.5,126.9,6.923,-145.5,-144.8,-16.42,-145.5,126.9,-16.42,-145.5,-144.4,-17.94,-145.5,126.5,-17.94,-145.5,-143.3,-19.02,-145.5,125.4,-19.02,-145.5,123.9,-19.43,-145.5,-141.8,-19.43,-145.5,118.9,-19.61,-145.5,-136.8,-19.61,-145.5,118.9,-1.685,-145.4,-136.8,-1.685,-145.4,-141.4,7.3,-146.1,123.6,7.3,-146.1,-142.0,7.164,-146.1,124.1,7.164,-146.1,-142.0,7.075,-146.1,124.1,7.083,-146.1,-142.2,6.564,-146.1,124.3,6.575,-146.1,-142.2,-16.07,-146.1,124.3,-16.08,-146.1,-142.0,-16.58,-146.1,124.1,-16.59,-146.1,-142.0,-16.67,-146.1,124.1,-16.67,-146.1,123.5,-16.82,-146.1,-141.4,-16.82,-146.1,121.5,-16.89,-146.1,-139.4,-16.89,-146.1,121.5,0.9331,-146.0,-139.4,0.9331,-146.0,-133.4,-2.809,-113.1,-61.62,-2.809,-113.1,-28.94,-2.809,-113.1,116.2,-2.809,-113.1,-133.4,-2.809,-136.2,-61.62,-2.809,-136.2,-28.94,-2.809,-136.2,116.2,-2.809,-136.2,-133.4,-24.85,-113.1,-61.62,-24.85,-113.1,-28.94,-24.85,-113.1,116.2,-24.85,-113.1,-133.4,-24.85,-136.2,-61.62,-24.85,-136.2,-28.94,-24.85,-136.2,116.2,-24.85,-136.2,-133.4,-2.809,-142.7,-61.62,-2.809,-142.7,-28.94,-2.809,-142.7,116.2,-2.809,-142.7,-133.4,-24.85,-142.7,-61.62,-24.85,-142.7,-28.94,-24.85,-142.7,116.2,-24.85,-142.7,-59.2,-5.228,-136.4,-31.36,-5.228,-136.4,-59.2,-22.43,-136.4,-31.36,-22.43,-136.4,-128.5,-5.228,-142.9,-66.51,-5.228,-142.9,-26.52,-5.228,-142.9,113.8,-5.228,-142.9,-131.0,-22.43,-142.9,-64.03,-22.43,-142.9};
			return value;
		}
		private double[] getCoordinate_6_20_point_7()
		{
			double[] value = {-26.52,-22.43,-142.9,113.8,-22.43,-142.9,-59.2,-5.228,-119.4,-31.36,-5.228,-119.4,-59.2,-22.43,-119.4,-31.36,-22.43,-119.4,-128.5,-5.228,-125.9,-66.51,-5.228,-125.9,-26.52,-5.228,-125.9,113.8,-5.228,-125.9,-131.0,-22.43,-125.9,-64.03,-22.43,-125.9,-26.52,-22.43,-125.9,113.8,-22.43,-125.9,108.7,-9.85,-123.3,110.5,-9.85,-123.3,110.2,-10.71,-123.3,109.6,-11.34,-123.3,108.7,-11.58,-123.3,107.9,-11.34,-123.3,107.2,-10.71,-123.3,107.0,-9.85,-123.3,107.2,-8.987,-123.3,107.9,-8.355,-123.3,108.7,-8.124,-123.3,109.6,-8.355,-123.3,110.2,-8.987,-123.3,110.5,-9.85,-141.9,110.2,-10.71,-141.9,109.6,-11.34,-141.9,108.7,-11.58,-141.9,107.9,-11.34,-141.9,107.2,-10.71,-141.9,107.0,-9.85,-141.9,107.2,-8.987,-141.9,107.9,-8.355,-141.9,108.7,-8.124,-141.9,109.6,-8.355,-141.9,110.2,-8.987,-141.9,108.7,-9.85,-141.9,93.5,-9.85,-123.3,95.22,-9.85,-123.3,94.99,-10.71,-123.3,94.36,-11.34,-123.3,93.5,-11.58,-123.3,92.64,-11.34,-123.3,92.0,-10.71,-123.3,91.77,-9.85,-123.3,92.0,-8.987,-123.3,92.64,-8.355,-123.3,93.5,-8.124,-123.3,94.36,-8.355,-123.3,94.99,-8.987,-123.3,95.22,-9.85,-141.9,94.99,-10.71,-141.9,94.36,-11.34,-141.9,93.5,-11.58,-141.9,92.64,-11.34,-141.9,92.0,-10.71,-141.9,91.77,-9.85,-141.9,92.0,-8.987,-141.9,92.64,-8.355,-141.9,93.5,-8.124,-141.9,94.36,-8.355,-141.9,94.99,-8.987,-141.9,93.5,-9.85,-141.9,85.88,-9.85,-123.3,87.6,-9.85,-123.3,87.37,-10.71,-123.3,86.74,-11.34,-123.3,85.88,-11.58,-123.3,85.02,-11.34,-123.3,84.38,-10.71,-123.3,84.15,-9.85,-123.3,84.38,-8.987,-123.3,85.02,-8.355,-123.3,85.88,-8.124,-123.3,86.74,-8.355,-123.3,87.37,-8.987,-123.3,87.6,-9.85,-141.9,87.37,-10.71,-141.9,86.74,-11.34,-141.9,85.88,-11.58,-141.9,85.02,-11.34,-141.9,84.38,-10.71,-141.9,84.15,-9.85,-141.9,84.38,-8.987,-141.9,85.02,-8.355,-141.9,85.88,-8.124,-141.9,86.74,-8.355,-141.9,87.37,-8.987,-141.9,85.88,-9.85,-141.9,63.02,-9.85,-123.3,64.74,-9.85,-123.3,64.51,-10.71,-123.3,63.88,-11.34,-123.3,63.02,-11.58,-123.3,62.15,-11.34,-123.3,61.52,-10.71,-123.3,61.29,-9.85,-123.3};
			return value;
		}
		private double[] getCoordinate_6_20_point_8()
		{
			double[] value = {61.52,-8.987,-123.3,62.15,-8.355,-123.3,63.02,-8.124,-123.3,63.88,-8.355,-123.3,64.51,-8.987,-123.3,64.74,-9.85,-141.9,64.51,-10.71,-141.9,63.88,-11.34,-141.9,63.02,-11.58,-141.9,62.15,-11.34,-141.9,61.52,-10.71,-141.9,61.29,-9.85,-141.9,61.52,-8.987,-141.9,62.15,-8.355,-141.9,63.02,-8.124,-141.9,63.88,-8.355,-141.9,64.51,-8.987,-141.9,63.02,-9.85,-141.9,32.54,-9.85,-123.3,34.26,-9.85,-123.3,34.03,-10.71,-123.3,33.4,-11.34,-123.3,32.54,-11.58,-123.3,31.67,-11.34,-123.3,31.04,-10.71,-123.3,30.81,-9.85,-123.3,31.04,-8.987,-123.3,31.67,-8.355,-123.3,32.54,-8.124,-123.3,33.4,-8.355,-123.3,34.03,-8.987,-123.3,34.26,-9.85,-141.9,34.03,-10.71,-141.9,33.4,-11.34,-141.9,32.54,-11.58,-141.9,31.67,-11.34,-141.9,31.04,-10.71,-141.9,30.81,-9.85,-141.9,31.04,-8.987,-141.9,31.67,-8.355,-141.9,32.54,-8.124,-141.9,33.4,-8.355,-141.9,34.03,-8.987,-141.9,32.54,-9.85,-141.9,-13.19,-16.61,-123.3,-11.46,-16.61,-123.3,-11.69,-17.47,-123.3,-12.32,-18.1,-123.3,-13.19,-18.33,-123.3,-14.05,-18.1,-123.3,-14.68,-17.47,-123.3,-14.91,-16.61,-123.3,-14.68,-15.74,-123.3,-14.05,-15.11,-123.3,-13.19,-14.88,-123.3,-12.32,-15.11,-123.3,-11.69,-15.74,-123.3,-11.46,-16.61,-141.9,-11.69,-17.47,-141.9,-12.32,-18.1,-141.9,-13.19,-18.33,-141.9,-14.05,-18.1,-141.9,-14.68,-17.47,-141.9,-14.91,-16.61,-141.9,-14.68,-15.74,-141.9,-14.05,-15.11,-141.9,-13.19,-14.88,-141.9,-12.32,-15.11,-141.9,-11.69,-15.74,-141.9,-13.19,-16.61,-141.9,-60.11,-14.34,-43.87,-21.58,-14.34,-43.87,-60.11,-14.34,-82.21,-21.58,-14.34,-82.21,-60.11,-17.13,-43.87,-21.58,-17.13,-43.87,-60.11,-17.13,-82.21,-21.58,-17.13,-82.21,-131.9,-15.1,12.9,112.7,-15.1,12.9,-131.9,-15.1,-107.0,112.7,-15.1,-107.0,-131.9,-16.21,12.9,112.7,-16.21,12.9,-131.9,-16.21,-107.0,112.7,-16.21,-107.0,-7.903,-3.929,60.09,40.43,-3.929,60.09,39.5,-3.929,68.39,36.75,-3.929,76.37,32.28,-3.929,83.72,26.27,-3.929,90.17,18.95,-3.929,95.46,10.59,-3.929,99.39,1.526,-3.929,101.8,-7.903,-3.929,102.6,-17.33,-3.929,101.8,-26.4,-3.929,99.39,-34.76,-3.929,95.46,-42.08,-3.929,90.17};
			return value;
		}
		private double[] getCoordinate_6_20_point_9()
		{
			double[] value = {-48.09,-3.929,83.72,-52.56,-3.929,76.37,-55.31,-3.929,68.39,-56.24,-3.929,60.09,-55.31,-3.929,51.79,-52.56,-3.929,43.81,-48.09,-3.929,36.45,-42.08,-3.929,30.0,-34.76,-3.929,24.71,-26.4,-3.929,20.78,-17.33,-3.929,18.36,-7.903,-3.929,17.54,1.526,-3.929,18.36,10.59,-3.929,20.78,18.95,-3.929,24.71,26.27,-3.929,30.0,32.28,-3.929,36.45,36.75,-3.929,43.81,39.5,-3.929,51.79,40.43,-20.68,60.09,39.5,-20.68,68.39,36.75,-20.68,76.37,32.28,-20.68,83.72,26.27,-20.68,90.17,18.95,-20.68,95.46,10.59,-20.68,99.39,1.526,-20.68,101.8,-7.903,-20.68,102.6,-17.33,-20.68,101.8,-26.4,-20.68,99.39,-34.76,-20.68,95.46,-42.08,-20.68,90.17,-48.09,-20.68,83.72,-52.56,-20.68,76.37,-55.31,-20.68,68.39,-56.24,-20.68,60.09,-55.31,-20.68,51.79,-52.56,-20.68,43.81,-48.09,-20.68,36.45,-42.08,-20.68,30.0,-34.76,-20.68,24.71,-26.4,-20.68,20.78,-17.33,-20.68,18.36,-7.903,-20.68,17.54,1.526,-20.68,18.36,10.59,-20.68,20.78,18.95,-20.68,24.71,26.27,-20.68,30.0,32.28,-20.68,36.45,36.75,-20.68,43.81,39.5,-20.68,51.79,-7.903,-22.7,60.09,38.61,-22.7,60.09,37.71,-22.7,68.07,35.07,-22.7,75.75,30.77,-22.7,82.83,24.98,-22.7,89.03,17.94,-22.7,94.13,9.895,-22.7,97.91,1.17,-22.7,100.2,-7.903,-22.7,101.0,-16.98,-22.7,100.2,-25.7,-22.7,97.91,-33.74,-22.7,94.13,-40.79,-22.7,89.03,-46.58,-22.7,82.83,-50.87,-22.7,75.75,-53.52,-22.7,68.07,-54.41,-22.7,60.09,-53.52,-22.7,52.1,-50.87,-22.7,44.42,-46.58,-22.7,37.34,-40.79,-22.7,31.14,-33.74,-22.7,26.05,-25.7,-22.7,22.26,-16.98,-22.7,19.93,-7.903,-22.7,19.15,1.17,-22.7,19.93,9.895,-22.7,22.26,17.94,-22.7,26.05,24.98,-22.7,31.14,30.77,-22.7,37.34,35.07,-22.7,44.42,37.71,-22.7,52.1,-20.81,-9.85,-123.3,-19.08,-9.85,-123.3,-19.31,-10.71,-123.3,-19.94,-11.34,-123.3,-20.81,-11.58,-123.3,-21.67,-11.34,-123.3,-22.3,-10.71,-123.3,-22.53,-9.85,-123.3,-22.3,-8.987,-123.3,-21.67,-8.355,-123.3,-20.81,-8.124,-123.3,-19.94,-8.355,-123.3,-19.31,-8.987,-123.3,-19.08,-9.85,-141.9,-19.31,-10.71,-141.9,-19.94,-11.34,-141.9};
			return value;
		}
		private double[] getCoordinate_6_20_point_10()
		{
			double[] value = {-20.81,-11.58,-141.9,-21.67,-11.34,-141.9,-22.3,-10.71,-141.9,-22.53,-9.85,-141.9,-22.3,-8.987,-141.9,-21.67,-8.355,-141.9,-20.81,-8.124,-141.9,-19.94,-8.355,-141.9,-19.31,-8.987,-141.9,-20.81,-9.85,-141.9,-13.19,-9.85,-123.3,-11.46,-9.85,-123.3,-11.69,-10.71,-123.3,-12.32,-11.34,-123.3,-13.19,-11.58,-123.3,-14.05,-11.34,-123.3,-14.68,-10.71,-123.3,-14.91,-9.85,-123.3,-14.68,-8.987,-123.3,-14.05,-8.355,-123.3,-13.19,-8.124,-123.3,-12.32,-8.355,-123.3,-11.69,-8.987,-123.3,-11.46,-9.85,-141.9,-11.69,-10.71,-141.9,-12.32,-11.34,-141.9,-13.19,-11.58,-141.9,-14.05,-11.34,-141.9,-14.68,-10.71,-141.9,-14.91,-9.85,-141.9,-14.68,-8.987,-141.9,-14.05,-8.355,-141.9,-13.19,-8.124,-141.9,-12.32,-8.355,-141.9,-11.69,-8.987,-141.9,-13.19,-9.85,-141.9,-5.566,-9.85,-123.3,-3.841,-9.85,-123.3,-4.072,-10.71,-123.3,-4.704,-11.34,-123.3,-5.566,-11.58,-123.3,-6.429,-11.34,-123.3,-7.061,-10.71,-123.3,-7.292,-9.85,-123.3,-7.061,-8.987,-123.3,-6.429,-8.355,-123.3,-5.566,-8.124,-123.3,-4.704,-8.355,-123.3,-4.072,-8.987,-123.3,-3.841,-9.85,-141.9,-4.072,-10.71,-141.9,-4.704,-11.34,-141.9,-5.566,-11.58,-141.9,-6.429,-11.34,-141.9,-7.061,-10.71,-141.9,-7.292,-9.85,-141.9,-7.061,-8.987,-141.9,-6.429,-8.355,-141.9,-5.566,-8.124,-141.9,-4.704,-8.355,-141.9,-4.072,-8.987,-141.9,-5.566,-9.85,-141.9,9.675,-9.85,-123.3,11.4,-9.85,-123.3,11.17,-10.71,-123.3,10.54,-11.34,-123.3,9.675,-11.58,-123.3,8.812,-11.34,-123.3,8.18,-10.71,-123.3,7.949,-9.85,-123.3,8.18,-8.987,-123.3,8.812,-8.355,-123.3,9.675,-8.124,-123.3,10.54,-8.355,-123.3,11.17,-8.987,-123.3,11.4,-9.85,-141.9,11.17,-10.71,-141.9,10.54,-11.34,-141.9,9.675,-11.58,-141.9,8.812,-11.34,-141.9,8.18,-10.71,-141.9,7.949,-9.85,-141.9,8.18,-8.987,-141.9,8.812,-8.355,-141.9,9.675,-8.124,-141.9,10.54,-8.355,-141.9,11.17,-8.987,-141.9,9.675,-9.85,-141.9,17.29,-9.85,-123.3,19.02,-9.85,-123.3,18.79,-10.71,-123.3,18.16,-11.34,-123.3,17.29,-11.58,-123.3,16.43,-11.34,-123.3,15.8,-10.71,-123.3,15.57,-9.85,-123.3,15.8,-8.987,-123.3,16.43,-8.355,-123.3,17.29,-8.124,-123.3,18.16,-8.355,-123.3};
			return value;
		}
		private double[] getCoordinate_6_20_point_11()
		{
			double[] value = {18.79,-8.987,-123.3,19.02,-9.85,-141.9,18.79,-10.71,-141.9,18.16,-11.34,-141.9,17.29,-11.58,-141.9,16.43,-11.34,-141.9,15.8,-10.71,-141.9,15.57,-9.85,-141.9,15.8,-8.987,-141.9,16.43,-8.355,-141.9,17.29,-8.124,-141.9,18.16,-8.355,-141.9,18.79,-8.987,-141.9,17.29,-9.85,-141.9,70.64,-9.85,-123.3,72.36,-9.85,-123.3,72.13,-10.71,-123.3,71.5,-11.34,-123.3,70.64,-11.58,-123.3,69.78,-11.34,-123.3,69.14,-10.71,-123.3,68.91,-9.85,-123.3,69.14,-8.987,-123.3,69.78,-8.355,-123.3,70.64,-8.124,-123.3,71.5,-8.355,-123.3,72.13,-8.987,-123.3,72.36,-9.85,-141.9,72.13,-10.71,-141.9,71.5,-11.34,-141.9,70.64,-11.58,-141.9,69.78,-11.34,-141.9,69.14,-10.71,-141.9,68.91,-9.85,-141.9,69.14,-8.987,-141.9,69.78,-8.355,-141.9,70.64,-8.124,-141.9,71.5,-8.355,-141.9,72.13,-8.987,-141.9,70.64,-9.85,-141.9,101.1,-9.85,-123.3,102.8,-9.85,-123.3,102.6,-10.71,-123.3,102.0,-11.34,-123.3,101.1,-11.58,-123.3,100.3,-11.34,-123.3,99.63,-10.71,-123.3,99.39,-9.85,-123.3,99.63,-8.987,-123.3,100.3,-8.355,-123.3,101.1,-8.124,-123.3,102.0,-8.355,-123.3,102.6,-8.987,-123.3,102.8,-9.85,-141.9,102.6,-10.71,-141.9,102.0,-11.34,-141.9,101.1,-11.58,-141.9,100.3,-11.34,-141.9,99.63,-10.71,-141.9,99.39,-9.85,-141.9,99.63,-8.987,-141.9,100.3,-8.355,-141.9,101.1,-8.124,-141.9,102.0,-8.355,-141.9,102.6,-8.987,-141.9,101.1,-9.85,-141.9,108.7,-16.61,-123.3,110.5,-16.61,-123.3,110.2,-17.47,-123.3,109.6,-18.1,-123.3,108.7,-18.33,-123.3,107.9,-18.1,-123.3,107.2,-17.47,-123.3,107.0,-16.61,-123.3,107.2,-15.74,-123.3,107.9,-15.11,-123.3,108.7,-14.88,-123.3,109.6,-15.11,-123.3,110.2,-15.74,-123.3,110.5,-16.61,-141.9,110.2,-17.47,-141.9,109.6,-18.1,-141.9,108.7,-18.33,-141.9,107.9,-18.1,-141.9,107.2,-17.47,-141.9,107.0,-16.61,-141.9,107.2,-15.74,-141.9,107.9,-15.11,-141.9,108.7,-14.88,-141.9,109.6,-15.11,-141.9,110.2,-15.74,-141.9,108.7,-16.61,-141.9,101.1,-16.61,-123.3,102.8,-16.61,-123.3,102.6,-17.47,-123.3,102.0,-18.1,-123.3,101.1,-18.33,-123.3,100.3,-18.1,-123.3,99.63,-17.47,-123.3,99.39,-16.61,-123.3};
			return value;
		}
		private double[] getCoordinate_6_20_point_12()
		{
			double[] value = {99.63,-15.74,-123.3,100.3,-15.11,-123.3,101.1,-14.88,-123.3,102.0,-15.11,-123.3,102.6,-15.74,-123.3,102.8,-16.61,-141.9,102.6,-17.47,-141.9,102.0,-18.1,-141.9,101.1,-18.33,-141.9,100.3,-18.1,-141.9,99.63,-17.47,-141.9,99.39,-16.61,-141.9,99.63,-15.74,-141.9,100.3,-15.11,-141.9,101.1,-14.88,-141.9,102.0,-15.11,-141.9,102.6,-15.74,-141.9,101.1,-16.61,-141.9,93.5,-16.61,-123.3,95.22,-16.61,-123.3,94.99,-17.47,-123.3,94.36,-18.1,-123.3,93.5,-18.33,-123.3,92.64,-18.1,-123.3,92.0,-17.47,-123.3,91.77,-16.61,-123.3,92.0,-15.74,-123.3,92.64,-15.11,-123.3,93.5,-14.88,-123.3,94.36,-15.11,-123.3,94.99,-15.74,-123.3,95.22,-16.61,-141.9,94.99,-17.47,-141.9,94.36,-18.1,-141.9,93.5,-18.33,-141.9,92.64,-18.1,-141.9,92.0,-17.47,-141.9,91.77,-16.61,-141.9,92.0,-15.74,-141.9,92.64,-15.11,-141.9,93.5,-14.88,-141.9,94.36,-15.11,-141.9,94.99,-15.74,-141.9,93.5,-16.61,-141.9,85.88,-16.61,-123.3,87.6,-16.61,-123.3,87.37,-17.47,-123.3,86.74,-18.1,-123.3,85.88,-18.33,-123.3,85.02,-18.1,-123.3,84.38,-17.47,-123.3,84.15,-16.61,-123.3,84.38,-15.74,-123.3,85.02,-15.11,-123.3,85.88,-14.88,-123.3,86.74,-15.11,-123.3,87.37,-15.74,-123.3,87.6,-16.61,-141.9,87.37,-17.47,-141.9,86.74,-18.1,-141.9,85.88,-18.33,-141.9,85.02,-18.1,-141.9,84.38,-17.47,-141.9,84.15,-16.61,-141.9,84.38,-15.74,-141.9,85.02,-15.11,-141.9,85.88,-14.88,-141.9,86.74,-15.11,-141.9,87.37,-15.74,-141.9,85.88,-16.61,-141.9,78.26,-16.61,-123.3,79.98,-16.61,-123.3,79.75,-17.47,-123.3,79.12,-18.1,-123.3,78.26,-18.33,-123.3,77.4,-18.1,-123.3,76.76,-17.47,-123.3,76.53,-16.61,-123.3,76.76,-15.74,-123.3,77.4,-15.11,-123.3,78.26,-14.88,-123.3,79.12,-15.11,-123.3,79.75,-15.74,-123.3,79.98,-16.61,-141.9,79.75,-17.47,-141.9,79.12,-18.1,-141.9,78.26,-18.33,-141.9,77.4,-18.1,-141.9,76.76,-17.47,-141.9,76.53,-16.61,-141.9,76.76,-15.74,-141.9,77.4,-15.11,-141.9,78.26,-14.88,-141.9,79.12,-15.11,-141.9,79.75,-15.74,-141.9,78.26,-16.61,-141.9,63.02,-16.61,-123.3,64.74,-16.61,-123.3,64.51,-17.47,-123.3,63.88,-18.1,-123.3};
			return value;
		}
		private double[] getCoordinate_6_20_point_13()
		{
			double[] value = {63.02,-18.33,-123.3,62.15,-18.1,-123.3,61.52,-17.47,-123.3,61.29,-16.61,-123.3,61.52,-15.74,-123.3,62.15,-15.11,-123.3,63.02,-14.88,-123.3,63.88,-15.11,-123.3,64.51,-15.74,-123.3,64.74,-16.61,-141.9,64.51,-17.47,-141.9,63.88,-18.1,-141.9,63.02,-18.33,-141.9,62.15,-18.1,-141.9,61.52,-17.47,-141.9,61.29,-16.61,-141.9,61.52,-15.74,-141.9,62.15,-15.11,-141.9,63.02,-14.88,-141.9,63.88,-15.11,-141.9,64.51,-15.74,-141.9,63.02,-16.61,-141.9,55.69,-14.34,-24.19,77.26,-14.34,-24.19,55.69,-14.34,-62.53,77.26,-14.34,-62.53,55.69,-17.13,-24.19,77.26,-17.13,-24.19,55.69,-17.13,-62.53,77.26,-17.13,-62.53,55.4,-16.61,-123.3,57.12,-16.61,-123.3,56.89,-17.47,-123.3,56.26,-18.1,-123.3,55.4,-18.33,-123.3,54.53,-18.1,-123.3,53.9,-17.47,-123.3,53.67,-16.61,-123.3,53.9,-15.74,-123.3,54.53,-15.11,-123.3,55.4,-14.88,-123.3,56.26,-15.11,-123.3,56.89,-15.74,-123.3,57.12,-16.61,-141.9,56.89,-17.47,-141.9,56.26,-18.1,-141.9,55.4,-18.33,-141.9,54.53,-18.1,-141.9,53.9,-17.47,-141.9,53.67,-16.61,-141.9,53.9,-15.74,-141.9,54.53,-15.11,-141.9,55.4,-14.88,-141.9,56.26,-15.11,-141.9,56.89,-15.74,-141.9,55.4,-16.61,-141.9,70.64,-16.61,-123.3,72.36,-16.61,-123.3,72.13,-17.47,-123.3,71.5,-18.1,-123.3,70.64,-18.33,-123.3,69.78,-18.1,-123.3,69.14,-17.47,-123.3,68.91,-16.61,-123.3,69.14,-15.74,-123.3,69.78,-15.11,-123.3,70.64,-14.88,-123.3,71.5,-15.11,-123.3,72.13,-15.74,-123.3,72.36,-16.61,-141.9,72.13,-17.47,-141.9,71.5,-18.1,-141.9,70.64,-18.33,-141.9,69.78,-18.1,-141.9,69.14,-17.47,-141.9,68.91,-16.61,-141.9,69.14,-15.74,-141.9,69.78,-15.11,-141.9,70.64,-14.88,-141.9,71.5,-15.11,-141.9,72.13,-15.74,-141.9,70.64,-16.61,-141.9,47.78,-16.61,-123.3,49.5,-16.61,-123.3,49.27,-17.47,-123.3,48.64,-18.1,-123.3,47.78,-18.33,-123.3,46.91,-18.1,-123.3,46.28,-17.47,-123.3,46.05,-16.61,-123.3,46.28,-15.74,-123.3,46.91,-15.11,-123.3,47.78,-14.88,-123.3,48.64,-15.11,-123.3,49.27,-15.74,-123.3,49.5,-16.61,-141.9,49.27,-17.47,-141.9,48.64,-18.1,-141.9,47.78,-18.33,-141.9,46.91,-18.1,-141.9};
			return value;
		}
		private double[] getCoordinate_6_20_point_14()
		{
			double[] value = {46.28,-17.47,-141.9,46.05,-16.61,-141.9,46.28,-15.74,-141.9,46.91,-15.11,-141.9,47.78,-14.88,-141.9,48.64,-15.11,-141.9,49.27,-15.74,-141.9,47.78,-16.61,-141.9,40.16,-16.61,-123.3,41.88,-16.61,-123.3,41.65,-17.47,-123.3,41.02,-18.1,-123.3,40.16,-18.33,-123.3,39.29,-18.1,-123.3,38.66,-17.47,-123.3,38.43,-16.61,-123.3,38.66,-15.74,-123.3,39.29,-15.11,-123.3,40.16,-14.88,-123.3,41.02,-15.11,-123.3,41.65,-15.74,-123.3,41.88,-16.61,-141.9,41.65,-17.47,-141.9,41.02,-18.1,-141.9,40.16,-18.33,-141.9,39.29,-18.1,-141.9,38.66,-17.47,-141.9,38.43,-16.61,-141.9,38.66,-15.74,-141.9,39.29,-15.11,-141.9,40.16,-14.88,-141.9,41.02,-15.11,-141.9,41.65,-15.74,-141.9,40.16,-16.61,-141.9,32.54,-16.61,-123.3,34.26,-16.61,-123.3,34.03,-17.47,-123.3,33.4,-18.1,-123.3,32.54,-18.33,-123.3,31.67,-18.1,-123.3,31.04,-17.47,-123.3,30.81,-16.61,-123.3,31.04,-15.74,-123.3,31.67,-15.11,-123.3,32.54,-14.88,-123.3,33.4,-15.11,-123.3,34.03,-15.74,-123.3,34.26,-16.61,-141.9,34.03,-17.47,-141.9,33.4,-18.1,-141.9,32.54,-18.33,-141.9,31.67,-18.1,-141.9,31.04,-17.47,-141.9,30.81,-16.61,-141.9,31.04,-15.74,-141.9,31.67,-15.11,-141.9,32.54,-14.88,-141.9,33.4,-15.11,-141.9,34.03,-15.74,-141.9,32.54,-16.61,-141.9,17.29,-16.61,-123.3,19.02,-16.61,-123.3,18.79,-17.47,-123.3,18.16,-18.1,-123.3,17.29,-18.33,-123.3,16.43,-18.1,-123.3,15.8,-17.47,-123.3,15.57,-16.61,-123.3,15.8,-15.74,-123.3,16.43,-15.11,-123.3,17.29,-14.88,-123.3,18.16,-15.11,-123.3,18.79,-15.74,-123.3,19.02,-16.61,-141.9,18.79,-17.47,-141.9,18.16,-18.1,-141.9,17.29,-18.33,-141.9,16.43,-18.1,-141.9,15.8,-17.47,-141.9,15.57,-16.61,-141.9,15.8,-15.74,-141.9,16.43,-15.11,-141.9,17.29,-14.88,-141.9,18.16,-15.11,-141.9,18.79,-15.74,-141.9,17.29,-16.61,-141.9,24.92,-16.61,-123.3,26.64,-16.61,-123.3,26.41,-17.47,-123.3,25.78,-18.1,-123.3,24.92,-18.33,-123.3,24.05,-18.1,-123.3,23.42,-17.47,-123.3,23.19,-16.61,-123.3,23.42,-15.74,-123.3,24.05,-15.11,-123.3,24.92,-14.88,-123.3,25.78,-15.11,-123.3,26.41,-15.74,-123.3,26.64,-16.61,-141.9};
			return value;
		}
		private double[] getCoordinate_6_20_point_15()
		{
			double[] value = {26.41,-17.47,-141.9,25.78,-18.1,-141.9,24.92,-18.33,-141.9,24.05,-18.1,-141.9,23.42,-17.47,-141.9,23.19,-16.61,-141.9,23.42,-15.74,-141.9,24.05,-15.11,-141.9,24.92,-14.88,-141.9,25.78,-15.11,-141.9,26.41,-15.74,-141.9,24.92,-16.61,-141.9,6.539,-15.18,-73.41,28.14,-15.18,-73.41,6.539,-15.18,-94.91,28.14,-15.18,-94.91,6.539,-17.92,-73.41,28.14,-17.92,-73.41,6.539,-17.92,-94.91,28.14,-17.92,-94.91,2.054,-16.61,-123.3,3.78,-16.61,-123.3,3.548,-17.47,-123.3,2.917,-18.1,-123.3,2.054,-18.33,-123.3,1.191,-18.1,-123.3,0.5598,-17.47,-123.3,0.3287,-16.61,-123.3,0.5598,-15.74,-123.3,1.191,-15.11,-123.3,2.054,-14.88,-123.3,2.917,-15.11,-123.3,3.548,-15.74,-123.3,3.78,-16.61,-141.9,3.548,-17.47,-141.9,2.917,-18.1,-141.9,2.054,-18.33,-141.9,1.191,-18.1,-141.9,0.5598,-17.47,-141.9,0.3287,-16.61,-141.9,0.5598,-15.74,-141.9,1.191,-15.11,-141.9,2.054,-14.88,-141.9,2.917,-15.11,-141.9,3.548,-15.74,-141.9,2.054,-16.61,-141.9,-20.81,-16.61,-123.3,-19.08,-16.61,-123.3,-19.31,-17.47,-123.3,-19.94,-18.1,-123.3,-20.81,-18.33,-123.3,-21.67,-18.1,-123.3,-22.3,-17.47,-123.3,-22.53,-16.61,-123.3,-22.3,-15.74,-123.3,-21.67,-15.11,-123.3,-20.81,-14.88,-123.3,-19.94,-15.11,-123.3,-19.31,-15.74,-123.3,-19.08,-16.61,-141.9,-19.31,-17.47,-141.9,-19.94,-18.1,-141.9,-20.81,-18.33,-141.9,-21.67,-18.1,-141.9,-22.3,-17.47,-141.9,-22.53,-16.61,-141.9,-22.3,-15.74,-141.9,-21.67,-15.11,-141.9,-20.81,-14.88,-141.9,-19.94,-15.11,-141.9,-19.31,-15.74,-141.9,-20.81,-16.61,-141.9,-5.566,-16.61,-123.3,-3.841,-16.61,-123.3,-4.072,-17.47,-123.3,-4.704,-18.1,-123.3,-5.566,-18.33,-123.3,-6.429,-18.1,-123.3,-7.061,-17.47,-123.3,-7.292,-16.61,-123.3,-7.061,-15.74,-123.3,-6.429,-15.11,-123.3,-5.566,-14.88,-123.3,-4.704,-15.11,-123.3,-4.072,-15.74,-123.3,-3.841,-16.61,-141.9,-4.072,-17.47,-141.9,-4.704,-18.1,-141.9,-5.566,-18.33,-141.9,-6.429,-18.1,-141.9,-7.061,-17.47,-141.9,-7.292,-16.61,-141.9,-7.061,-15.74,-141.9,-6.429,-15.11,-141.9,-5.566,-14.88,-141.9,-4.704,-15.11,-141.9,-4.072,-15.74,-141.9,-5.566,-16.61,-141.9,2.054,-9.85,-123.3,3.78,-9.85,-123.3};
			return value;
		}
		private double[] getCoordinate_6_20_point_16()
		{
			double[] value = {3.548,-10.71,-123.3,2.917,-11.34,-123.3,2.054,-11.58,-123.3,1.191,-11.34,-123.3,0.5598,-10.71,-123.3,0.3287,-9.85,-123.3,0.5598,-8.987,-123.3,1.191,-8.355,-123.3,2.054,-8.124,-123.3,2.917,-8.355,-123.3,3.548,-8.987,-123.3,3.78,-9.85,-141.9,3.548,-10.71,-141.9,2.917,-11.34,-141.9,2.054,-11.58,-141.9,1.191,-11.34,-141.9,0.5598,-10.71,-141.9,0.3287,-9.85,-141.9,0.5598,-8.987,-141.9,1.191,-8.355,-141.9,2.054,-8.124,-141.9,2.917,-8.355,-141.9,3.548,-8.987,-141.9,2.054,-9.85,-141.9,24.92,-9.85,-123.3,26.64,-9.85,-123.3,26.41,-10.71,-123.3,25.78,-11.34,-123.3,24.92,-11.58,-123.3,24.05,-11.34,-123.3,23.42,-10.71,-123.3,23.19,-9.85,-123.3,23.42,-8.987,-123.3,24.05,-8.355,-123.3,24.92,-8.124,-123.3,25.78,-8.355,-123.3,26.41,-8.987,-123.3,26.64,-9.85,-141.9,26.41,-10.71,-141.9,25.78,-11.34,-141.9,24.92,-11.58,-141.9,24.05,-11.34,-141.9,23.42,-10.71,-141.9,23.19,-9.85,-141.9,23.42,-8.987,-141.9,24.05,-8.355,-141.9,24.92,-8.124,-141.9,25.78,-8.355,-141.9,26.41,-8.987,-141.9,24.92,-9.85,-141.9,40.16,-9.85,-123.3,41.88,-9.85,-123.3,41.65,-10.71,-123.3,41.02,-11.34,-123.3,40.16,-11.58,-123.3,39.29,-11.34,-123.3,38.66,-10.71,-123.3,38.43,-9.85,-123.3,38.66,-8.987,-123.3,39.29,-8.355,-123.3,40.16,-8.124,-123.3,41.02,-8.355,-123.3,41.65,-8.987,-123.3,41.88,-9.85,-141.9,41.65,-10.71,-141.9,41.02,-11.34,-141.9,40.16,-11.58,-141.9,39.29,-11.34,-141.9,38.66,-10.71,-141.9,38.43,-9.85,-141.9,38.66,-8.987,-141.9,39.29,-8.355,-141.9,40.16,-8.124,-141.9,41.02,-8.355,-141.9,41.65,-8.987,-141.9,40.16,-9.85,-141.9,47.78,-9.85,-123.3,49.5,-9.85,-123.3,49.27,-10.71,-123.3,48.64,-11.34,-123.3,47.78,-11.58,-123.3,46.91,-11.34,-123.3,46.28,-10.71,-123.3,46.05,-9.85,-123.3,46.28,-8.987,-123.3,46.91,-8.355,-123.3,47.78,-8.124,-123.3,48.64,-8.355,-123.3,49.27,-8.987,-123.3,49.5,-9.85,-141.9,49.27,-10.71,-141.9,48.64,-11.34,-141.9,47.78,-11.58,-141.9,46.91,-11.34,-141.9,46.28,-10.71,-141.9,46.05,-9.85,-141.9,46.28,-8.987,-141.9,46.91,-8.355,-141.9,47.78,-8.124,-141.9,48.64,-8.355,-141.9};
			return value;
		}
		private double[] getCoordinate_6_20_point_17()
		{
			double[] value = {49.27,-8.987,-141.9,47.78,-9.85,-141.9,55.4,-9.85,-123.3,57.12,-9.85,-123.3,56.89,-10.71,-123.3,56.26,-11.34,-123.3,55.4,-11.58,-123.3,54.53,-11.34,-123.3,53.9,-10.71,-123.3,53.67,-9.85,-123.3,53.9,-8.987,-123.3,54.53,-8.355,-123.3,55.4,-8.124,-123.3,56.26,-8.355,-123.3,56.89,-8.987,-123.3,57.12,-9.85,-141.9,56.89,-10.71,-141.9,56.26,-11.34,-141.9,55.4,-11.58,-141.9,54.53,-11.34,-141.9,53.9,-10.71,-141.9,53.67,-9.85,-141.9,53.9,-8.987,-141.9,54.53,-8.355,-141.9,55.4,-8.124,-141.9,56.26,-8.355,-141.9,56.89,-8.987,-141.9,55.4,-9.85,-141.9,78.26,-9.85,-123.3,79.98,-9.85,-123.3,79.75,-10.71,-123.3,79.12,-11.34,-123.3,78.26,-11.58,-123.3,77.4,-11.34,-123.3,76.76,-10.71,-123.3,76.53,-9.85,-123.3,76.76,-8.987,-123.3,77.4,-8.355,-123.3,78.26,-8.124,-123.3,79.12,-8.355,-123.3,79.75,-8.987,-123.3,79.98,-9.85,-141.9,79.75,-10.71,-141.9,79.12,-11.34,-141.9,78.26,-11.58,-141.9,77.4,-11.34,-141.9,76.76,-10.71,-141.9,76.53,-9.85,-141.9,76.76,-8.987,-141.9,77.4,-8.355,-141.9,78.26,-8.124,-141.9,79.12,-8.355,-141.9,79.75,-8.987,-141.9,78.26,-9.85,-141.9,-80.12,-13.74,-123.3,-77.89,-13.74,-123.3,-78.19,-14.86,-123.3,-79.01,-15.67,-123.3,-80.12,-15.97,-123.3,-81.24,-15.67,-123.3,-82.06,-14.86,-123.3,-82.36,-13.74,-123.3,-82.06,-12.62,-123.3,-81.24,-11.81,-123.3,-80.12,-11.51,-123.3,-79.01,-11.81,-123.3,-78.19,-12.62,-123.3,-77.89,-13.74,-141.9,-78.19,-14.86,-141.9,-79.01,-15.67,-141.9,-80.12,-15.97,-141.9,-81.24,-15.67,-141.9,-82.06,-14.86,-141.9,-82.36,-13.74,-141.9,-82.06,-12.62,-141.9,-81.24,-11.81,-141.9,-80.12,-11.51,-141.9,-79.01,-11.81,-141.9,-78.19,-12.62,-141.9,-80.12,-13.74,-141.9,-91.71,-15.18,-1.586,-70.11,-15.18,-1.586,-91.71,-15.18,-23.08,-70.11,-15.18,-23.08,-91.71,-17.92,-1.586,-70.11,-17.92,-1.586,-91.71,-17.92,-23.08,-70.11,-17.92,-23.08,-97.48,-13.74,-123.3,-95.25,-13.74,-123.3,-95.55,-14.86,-123.3,-96.37,-15.67,-123.3,-97.48,-15.97,-123.3,-98.6,-15.67,-123.3,-99.42,-14.86,-123.3,-99.72,-13.74,-123.3,-99.42,-12.62,-123.3,-98.6,-11.81,-123.3,-97.48,-11.51,-123.3,-96.37,-11.81,-123.3};
			return value;
		}
		private double[] getCoordinate_6_20_point_18()
		{
			double[] value = {-95.55,-12.62,-123.3,-95.25,-13.74,-141.9,-95.55,-14.86,-141.9,-96.37,-15.67,-141.9,-97.48,-15.97,-141.9,-98.6,-15.67,-141.9,-99.42,-14.86,-141.9,-99.72,-13.74,-141.9,-99.42,-12.62,-141.9,-98.6,-11.81,-141.9,-97.48,-11.51,-141.9,-96.37,-11.81,-141.9,-95.55,-12.62,-141.9,-97.48,-13.74,-141.9,-114.8,-13.74,-123.3,-112.6,-13.74,-123.3,-112.9,-14.86,-123.3,-113.7,-15.67,-123.3,-114.8,-15.97,-123.3,-116.0,-15.67,-123.3,-116.8,-14.86,-123.3,-117.1,-13.74,-123.3,-116.8,-12.62,-123.3,-116.0,-11.81,-123.3,-114.8,-11.51,-123.3,-113.7,-11.81,-123.3,-112.9,-12.62,-123.3,-112.6,-13.74,-141.9,-112.9,-14.86,-141.9,-113.7,-15.67,-141.9,-114.8,-15.97,-141.9,-116.0,-15.67,-141.9,-116.8,-14.86,-141.9,-117.1,-13.74,-141.9,-116.8,-12.62,-141.9,-116.0,-11.81,-141.9,-114.8,-11.51,-141.9,-113.7,-11.81,-141.9,-112.9,-12.62,-141.9,-114.8,-13.74,-141.9,119.6,25.71,148.1,120.0,25.71,51.62,119.0,25.71,49.66,116.8,25.71,47.51,113.2,25.71,45.15,108.9,25.71,42.57,104.4,25.71,39.38,100.5,25.71,34.81,117.2,25.71,154.4,112.6,25.71,160.5,106.0,25.71,166.2,97.82,25.71,171.1,88.52,25.71,174.9,78.6,25.71,177.3,68.35,25.71,178.2,-68.88,25.71,178.2,98.9,25.71,28.38,-92.24,25.71,176.2,-109.4,25.71,171.9,-121.4,25.71,166.2,-129.4,25.71,159.9,-134.4,25.71,153.7,-137.5,25.71,148.1,-139.1,25.71,144.8,-139.1,25.71,55.18,-138.1,25.71,52.78,-136.0,25.71,50.46,-132.4,25.71,47.82,-127.9,25.71,44.83,-123.3,25.71,41.07,-119.3,25.71,35.86,-117.6,25.71,28.91,-119.0,25.71,21.95,100.9,25.71,21.88,-122.7,25.71,16.74,104.9,25.71,17.16,-127.1,25.71,13.09,109.6,25.71,13.69,-131.4,25.71,10.3,-134.8,25.71,7.917,-136.9,25.71,5.88,-137.7,25.71,3.945,-137.7,25.71,-99.63,-136.0,25.71,-103.3,-128.9,25.71,-109.5,-117.2,25.71,-117.0,-103.1,25.71,-124.4,-88.3,25.71,-130.8,-74.73,25.71,-135.1,-63.98,25.71,-136.8,92.85,25.71,-136.8,114.0,25.71,10.82,117.6,25.71,8.291,119.7,25.71,6.241,120.4,25.71,4.493,120.4,25.71,-105.6,119.5,25.71,-110.5,117.2,25.71,-116.5,113.6,25.71,-122.8,109.0,25.71,-128.7};
			return value;
		}
		private double[] getCoordinate_6_20_point_19()
		{
			double[] value = {103.8,25.71,-133.3,98.62,25.71,-136.0,9.675,-16.61,-123.3,11.4,-16.61,-123.3,11.17,-17.47,-123.3,10.54,-18.1,-123.3,9.675,-18.33,-123.3,8.812,-18.1,-123.3,8.18,-17.47,-123.3,7.949,-16.61,-123.3,8.18,-15.74,-123.3,8.812,-15.11,-123.3,9.675,-14.88,-123.3,10.54,-15.11,-123.3,11.17,-15.74,-123.3,11.4,-16.61,-141.9,11.17,-17.47,-141.9,10.54,-18.1,-141.9,9.675,-18.33,-141.9,8.812,-18.1,-141.9,8.18,-17.47,-141.9,7.949,-16.61,-141.9,8.18,-15.74,-141.9,8.812,-15.11,-141.9,9.675,-14.88,-141.9,10.54,-15.11,-141.9,11.17,-15.74,-141.9,9.675,-16.61,-141.9};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_5_26_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,2,3,-1,1,4,5,-1,1,5,2,-1,0,6,7,-1,0,7,1,-1,1,7,8,-1,1,8,4,-1,4,8,9,-1,4,9,10,-1,4,10,11,-1,4,11,12,-1,4,12,5,-1,5,12,13,-1,5,13,14,-1,5,14,15,-1,5,15,16,-1,5,16,2,-1,2,16,17,-1,2,17,3,-1,6,18,19,-1,6,19,7,-1,7,19,20,-1,7,20,8,-1,8,20,21,-1,8,21,9,-1,9,21,22,-1,9,22,10,-1,10,22,23,-1,10,23,11,-1,11,23,24,-1,11,24,12,-1,12,24,25,-1,12,25,13,-1,13,25,26,-1,13,26,14,-1,14,26,27,-1,14,27,15,-1,15,27,28,-1,15,28,16,-1,16,28,29,-1,16,29,17,-1,18,30,31,-1,18,31,19,-1,19,31,32,-1,19,32,20,-1,20,32,33,-1,20,33,21,-1,21,33,34,-1,21,34,22,-1,22,34,35,-1,22,35,23,-1,23,35,36,-1,23,36,24,-1,24,36,37,-1,24,37,25,-1,25,37,38,-1,25,38,26,-1,26,38,39,-1,26,39,27,-1,27,39,40,-1,27,40,28,-1,28,40,41,-1,28,41,29,-1,30,42,43,-1,30,43,31,-1,31,43,44,-1,31,44,32,-1,32,44,45,-1,32,45,33,-1,33,45,46,-1,33,46,34,-1,34,46,47,-1,34,47,35,-1,35,47,48,-1,35,48,36,-1,36,48,49,-1,36,49,37,-1,37,49,50,-1,37,50,38,-1,38,50,51,-1,38,51,39,-1,39,51,52,-1,39,52,40,-1,40,52,53,-1,40,53,41,-1,42,54,55,-1,42,55,43,-1,43,55,56,-1,43,56,44,-1,44,56,57,-1,44,57,45,-1,45,57,58,-1,45,58,46,-1,46,58,59,-1,46,59,47,-1,47,59,60,-1,47,60,48,-1,48,60,61,-1,48,61,49,-1,49,61,62,-1,49,62,50,-1,50,62,63,-1,50,63,51,-1,51,63,64,-1,51,64,52,-1,52,64,65,-1,52,65,53,-1,54,66,67,-1,54,67,55,-1,55,67,68,-1,55,68,56,-1,56,68,69,-1,56,69,57,-1,57,69,70,-1,57,70,58,-1,58,70,71,-1,58,71,59,-1,59,71,72,-1,59,72,60,-1,60,72,73,-1,60,73,61,-1,61,73,74,-1,61,74,62,-1,62,74,75,-1,62,75,63,-1,63,75,76,-1,63,76,64,-1,64,76,77,-1,64,77,65,-1,66,78,79,-1,66,79,67,-1,67,79,80,-1,67,80,68,-1,68,80,69,-1,69,80,70,-1,70,80,71,-1,71,80,81,-1,71,81,72,-1,72,81,73,-1,73,81,74,-1,74,81,75,-1,75,81,82,-1,75,82,76,-1,76,82,83,-1,76,83,77,-1,82,81,80,-1,82,80,79,-1,84,85,86,-1,84,86,87,-1,79,78,88,-1,88,89,79,-1,83,82,90,-1,90,91,83,-1,82,79,89,-1,89,90,82,-1,91,90,85,-1,85,84,91,-1,90,89,86,-1,86,85,90,-1,89,88,87,-1,87,86,89,-1,92,93,94,-1,92,94,95,-1,96,92,95,-1,96,95,97,-1,98,96,97,-1,98,97,99,-1,100,101,102,-1,100,102,103,-1,104,100,103,-1,104,103,105,-1,106,104,105,-1,106,105,107,-1,106,107,108,-1,106,108,109,-1,99,110,111,-1,99,111,98,-1,106,109,110,-1,106,110,99,-1,0,3,112,-1,112,113,0,-1,6,0,113,-1,113,114,6,-1,3,17,115,-1,115,112,3,-1,18,6,114,-1,114,116,18,-1,17,29,117,-1,117,115,17,-1,30,18,116,-1,116,118,30,-1,29,41,119,-1,119,117,29,-1,42,30,118,-1,118,120,42,-1,41,53,121,-1,121,119,41,-1,54,42,120,-1,120,122,54,-1,53,65,123,-1,123,121,53,-1,66,54,122,-1,122,124,66,-1,65,77,125,-1,125,123,65,-1,78,66,124,-1,124,126,78,-1,77,83,127,-1,127,125,77,-1,84,87,128,-1,128,129,84,-1,88,78,126,-1,126,130,88,-1,83,91,131,-1,131,127,83,-1,91,84,129,-1,129,131,91,-1,87,88,130,-1,130,128,87,-1,122,120,93,-1,93,92,122,-1,120,118,94,-1,94,93,120,-1,118,116,95,-1,95,94,118,-1,124,122,92,-1,92,96,124,-1,116,114,97,-1,97,95,116,-1,126,124,96,-1,96,98,126,-1,114,113,99,-1,99,97,114,-1,117,119,101,-1,101,100,117,-1,119,121,102,-1,102,101,119,-1,121,123,103,-1,103,102,121,-1,115,117,100,-1,100,104,115,-1,123,125,105,-1,105,103,123,-1,112,115,104,-1,104,106,112,-1,125,127,107,-1,107,105,125,-1,127,131,108,-1,108,107,127,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_26_coordIndex_2()
		{
			int[] value = {131,129,109,-1,109,108,131,-1,128,130,111,-1,111,110,128,-1,130,126,98,-1,98,111,130,-1,129,128,110,-1,110,109,129,-1,113,112,106,-1,106,99,113,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_6_26_point_1()
		{
			double[] value = {-141.8,10.33,-144.5,-141.8,10.33,63.59,124.0,10.33,63.59,124.0,10.33,-144.5,-141.8,10.33,187.2,124.0,10.33,187.2,-143.5,9.882,-144.5,-143.5,9.882,63.59,-143.5,9.882,187.2,-143.3,9.882,188.1,-142.7,9.882,188.7,-141.8,9.882,188.9,124.0,9.882,188.9,124.8,9.882,188.7,125.4,9.882,188.1,125.6,9.882,187.2,125.6,9.882,63.59,125.6,9.882,-144.5,-144.7,8.656,-144.5,-144.7,8.656,63.59,-144.7,8.656,187.2,-144.4,8.656,188.7,-143.3,8.656,189.7,-141.8,8.656,190.1,124.0,8.656,190.1,125.4,8.656,189.7,126.5,8.656,188.7,126.9,8.656,187.2,126.9,8.656,63.59,126.9,8.656,-144.5,-145.2,6.981,-144.5,-145.2,6.981,63.59,-145.2,6.981,187.2,-144.7,6.981,188.9,-143.5,6.981,190.1,-141.8,6.981,190.6,124.0,6.981,190.6,125.6,6.981,190.1,126.9,6.981,188.9,127.3,6.981,187.2,127.3,6.981,63.59,127.3,6.981,-144.5,-145.2,-16.47,-144.5,-145.2,-16.47,63.59,-145.2,-16.47,187.2,-144.7,-16.47,188.9,-143.5,-16.47,190.1,-141.8,-16.47,190.6,124.0,-16.47,190.6,125.6,-16.47,190.1,126.9,-16.47,188.9,127.3,-16.47,187.2,127.3,-16.47,63.59,127.3,-16.47,-144.5,-144.7,-18.15,-144.5,-144.7,-18.15,63.59,-144.7,-18.15,187.2,-144.4,-18.15,188.7,-143.3,-18.15,189.7,-141.8,-18.15,190.1,124.0,-18.15,190.1,125.4,-18.15,189.7,126.5,-18.15,188.7,126.9,-18.15,187.2,126.9,-18.15,63.59,126.9,-18.15,-144.5,-143.5,-19.37,-144.5,-143.5,-19.37,63.59,-143.5,-19.37,187.2,-143.3,-19.37,188.1,-142.7,-19.37,188.7,-141.8,-19.37,188.9,124.0,-19.37,188.9,124.8,-19.37,188.7,125.4,-19.37,188.1,125.6,-19.37,187.2,125.6,-19.37,63.59,125.6,-19.37,-144.5,-141.8,-19.82,-144.5,-141.8,-19.82,63.59,-141.8,-19.82,187.2,124.0,-19.82,187.2,124.0,-19.82,63.59,124.0,-19.82,-144.5,118.5,-2.083,-144.4,118.5,-2.083,58.15,-136.4,-2.083,58.15,-136.4,-2.083,-144.4,-136.4,-20.02,-144.5,-136.4,-20.02,58.15,118.5,-20.02,58.15,118.5,-20.02,-144.5,-142.0,-16.58,-146.1,-142.2,-16.07,-146.1,-142.2,6.564,-146.1,-142.0,7.075,-146.1,-142.0,-16.67,-146.1,-142.0,7.164,-146.1,-141.4,-16.82,-146.1,-141.4,7.3,-146.1};
			return value;
		}
		private double[] getCoordinate_6_26_point_2()
		{
			double[] value = {124.1,7.083,-146.1,124.3,6.575,-146.1,124.3,-16.08,-146.1,124.1,-16.59,-146.1,124.1,7.164,-146.1,124.1,-16.67,-146.1,123.6,7.3,-146.1,123.5,-16.82,-146.1,121.5,-16.89,-146.1,121.5,0.9331,-146.0,-139.4,0.9331,-146.0,-139.4,-16.89,-146.1,123.9,9.924,-145.5,-141.8,9.924,-145.5,-143.3,9.516,-145.5,125.4,9.516,-145.5,-144.4,8.442,-145.5,126.5,8.443,-145.5,-144.8,6.922,-145.5,126.9,6.923,-145.5,-144.8,-16.42,-145.5,126.9,-16.42,-145.5,-144.4,-17.94,-145.5,126.5,-17.94,-145.5,-143.3,-19.02,-145.5,125.4,-19.02,-145.5,-141.8,-19.43,-145.5,123.9,-19.43,-145.5,-136.8,-1.685,-145.4,118.9,-1.685,-145.4,-136.8,-19.61,-145.5,118.9,-19.61,-145.5};
			return value;
		}

		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=5, element #20, 13600 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_5_20_coordIndex()
		{
			MFInt32 IndexedFaceSet_5_20_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_1()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_2()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_3()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_4()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_5()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_6()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_7()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_8()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_9()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_10()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_11()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_12()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_13()))
				.append(new MFInt32(getIndexedFaceSet_5_20_coordIndex_14()));
			return IndexedFaceSet_5_20_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=6, element #20, 5484 total numbers made up of 1828 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_6_20_point()
		{
			MFVec3f Coordinate_6_20_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_6_20_point_1()))
				.append(new MFVec3f(getCoordinate_6_20_point_2()))
				.append(new MFVec3f(getCoordinate_6_20_point_3()))
				.append(new MFVec3f(getCoordinate_6_20_point_4()))
				.append(new MFVec3f(getCoordinate_6_20_point_5()))
				.append(new MFVec3f(getCoordinate_6_20_point_6()))
				.append(new MFVec3f(getCoordinate_6_20_point_7()))
				.append(new MFVec3f(getCoordinate_6_20_point_8()))
				.append(new MFVec3f(getCoordinate_6_20_point_9()))
				.append(new MFVec3f(getCoordinate_6_20_point_10()))
				.append(new MFVec3f(getCoordinate_6_20_point_11()))
				.append(new MFVec3f(getCoordinate_6_20_point_12()))
				.append(new MFVec3f(getCoordinate_6_20_point_13()))
				.append(new MFVec3f(getCoordinate_6_20_point_14()))
				.append(new MFVec3f(getCoordinate_6_20_point_15()))
				.append(new MFVec3f(getCoordinate_6_20_point_16()))
				.append(new MFVec3f(getCoordinate_6_20_point_17()))
				.append(new MFVec3f(getCoordinate_6_20_point_18()))
				.append(new MFVec3f(getCoordinate_6_20_point_19()));
			return Coordinate_6_20_point;
		}
		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=5, element #26, 1040 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_5_26_coordIndex()
		{
			MFInt32 IndexedFaceSet_5_26_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_1()))
				.append(new MFInt32(getIndexedFaceSet_5_26_coordIndex_2()));
			return IndexedFaceSet_5_26_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=6, element #26, 396 total numbers made up of 132 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_6_26_point()
		{
			MFVec3f Coordinate_6_26_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_6_26_point_1()))
				.append(new MFVec3f(getCoordinate_6_26_point_2()));
			return Coordinate_6_26_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return UnitDisk model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new UnitDisk().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Units.UnitDisk\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Units.UnitDisk self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Units/UnitDisk_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Units/UnitDisk_JavaExport.x3d"; 
                String filenameX3DV = "Units/UnitDisk_JavaExport.x3dv"; 
                String filenameJSON = "Units/UnitDisk_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
