####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python UnitCup.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    unit(category='length',conversionFactor=0.001,name='millimeters'),
    meta(content='UnitCup.x3d',name='title'),
    meta(content='Units component example for a drinking cup',name='description'),
    meta(content='Myeong Won Lee',name='creator'),
    meta(content='1 August 2009',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='UnitExamples.pdf',name='reference'),
    meta(content='http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd',name='reference'),
    meta(content='https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement',name='reference'),
    meta(content='X3D UNIT statement',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Units/UnitCup.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='UnitCup.x3d'),
    Background(groundColor=[(0.05,0.1,0.3)],skyColor=[(0.05,0.1,0.3)]),
    Transform(scale=(3.415,3.415,3.415),
      children=[
      Viewpoint(description='Cup',position=(0.0,0.0,1.0)),
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(1,0,0))),
        geometry=IndexedFaceSet(coordIndex=[0,1364,682,-1,682,1367,0,-1,341,1365,682,-1,682,1364,341,-1,165,1366,682,-1,682,1365,165,-1,343,1367,682,-1,682,1366,343,-1,2,1368,683,-1,683,1370,2,-1,342,1369,683,-1,683,1368,342,-1,165,1365,683,-1,683,1369,165,-1,341,1370,683,-1,683,1365,341,-1,1,1371,684,-1,684,1372,1,-1,343,1366,684,-1,684,1371,343,-1,165,1369,684,-1,684,1366,165,-1,342,1372,684,-1,684,1369,342,-1,0,1373,685,-1,685,1364,0,-1,344,1374,685,-1,685,1373,344,-1,166,1375,685,-1,685,1374,166,-1,341,1364,685,-1,685,1375,341,-1,3,1376,686,-1,686,1378,3,-1,345,1377,686,-1,686,1376,345,-1,166,1374,686,-1,686,1377,166,-1,344,1378,686,-1,686,1374,344,-1,2,1370,687,-1,687,1379,2,-1,341,1375,687,-1,687,1370,341,-1,166,1377,687,-1,687,1375,166,-1,345,1379,687,-1,687,1377,345,-1,0,1380,688,-1,688,1373,0,-1,346,1381,688,-1,688,1380,346,-1,167,1382,688,-1,688,1381,167,-1,344,1373,688,-1,688,1382,344,-1,4,1383,689,-1,689,1385,4,-1,347,1384,689,-1,689,1383,347,-1,167,1381,689,-1,689,1384,167,-1,346,1385,689,-1,689,1381,346,-1,3,1378,690,-1,690,1386,3,-1,344,1382,690,-1,690,1378,344,-1,167,1384,690,-1,690,1382,167,-1,347,1386,690,-1,690,1384,347,-1,0,1387,691,-1,691,1380,0,-1,348,1388,691,-1,691,1387,348,-1,168,1389,691,-1,691,1388,168,-1,346,1380,691,-1,691,1389,346,-1,5,1390,692,-1,692,1392,5,-1,349,1391,692,-1,692,1390,349,-1,168,1388,692,-1,692,1391,168,-1,348,1392,692,-1,692,1388,348,-1,4,1385,693,-1,693,1393,4,-1,346,1389,693,-1,693,1385,346,-1,168,1391,693,-1,693,1389,168,-1,349,1393,693,-1,693,1391,349,-1,0,1394,694,-1,694,1387,0,-1,350,1395,694,-1,694,1394,350,-1,169,1396,694,-1,694,1395,169,-1,348,1387,694,-1,694,1396,348,-1,6,1397,695,-1,695,1399,6,-1,351,1398,695,-1,695,1397,351,-1,169,1395,695,-1,695,1398,169,-1,350,1399,695,-1,695,1395,350,-1,5,1392,696,-1,696,1400,5,-1,348,1396,696,-1,696,1392,348,-1,169,1398,696,-1,696,1396,169,-1,351,1400,696,-1,696,1398,351,-1,0,1401,697,-1,697,1394,0,-1,352,1402,697,-1,697,1401,352,-1,170,1403,697,-1,697,1402,170,-1,350,1394,697,-1,697,1403,350,-1,7,1404,698,-1,698,1406,7,-1,353,1405,698,-1,698,1404,353,-1,170,1402,698,-1,698,1405,170,-1,352,1406,698,-1,698,1402,352,-1,6,1399,699,-1,699,1407,6,-1,350,1403,699,-1,699,1399,350,-1,170,1405,699,-1,699,1403,170,-1,353,1407,699,-1,699,1405,353,-1,0,1408,700,-1,700,1401,0,-1,354,1409,700,-1,700,1408,354,-1,171,1410,700,-1,700,1409,171,-1,352,1401,700,-1,700,1410,352,-1,8,1411,701,-1,701,1413,8,-1,355,1412,701,-1,701,1411,355,-1,171,1409,701,-1,701,1412,171,-1,354,1413,701,-1,701,1409,354,-1,7,1406,702,-1,702,1414,7,-1,352,1410,702,-1,702,1406,352,-1,171,1412,702,-1,702,1410,171,-1,355,1414,702,-1,702,1412,355,-1,0,1415,703,-1,703,1408,0,-1,356,1416,703,-1,703,1415,356,-1,172,1417,703,-1,703,1416,172,-1,354,1408,703,-1,703,1417,354,-1,9,1418,704,-1,704,1420,9,-1,357,1419,704,-1,704,1418,357,-1,172,1416,704,-1,704,1419,172,-1,356,1420,704,-1,704,1416,356,-1,8,1413,705,-1,705,1421,8,-1,354,1417,705,-1,705,1413,354,-1,172,1419,705,-1,705,1417,172,-1,357,1421,705,-1,705,1419,357,-1,0,1422,706,-1,706,1415,0,-1,358,1423,706,-1,706,1422,358,-1,173,1424,706,-1,706,1423,173,-1,356,1415,706,-1,706,1424,356,-1,10,1425,707,-1,707,1427,10,-1,359,1426,707,-1,707,1425,359,-1,173,1423,707,-1,707,1426,173,-1,358,1427,707,-1,707,1423,358,-1,9,1420,708,-1,708,1428,9,-1,356,1424,708,-1,708,1420,356,-1,173,1426,708,-1,708,1424,173,-1,359,1428,708,-1,708,1426,359,-1,0,1429,709,-1,709,1422,0,-1,360,1430,709,-1,709,1429,360,-1,174,1431,709,-1,709,1430,174,-1,358,1422,709,-1,709,1431,358,-1,11,1432,710,-1,710,1434,11,-1,361,1433,710,-1,710,1432,361,-1,174,1430,710,-1,710,1433,174,-1,360,1434,710,-1,710,1430,360,-1,10,1427,711,-1,711,1435,10,-1,358,1431,711,-1,711,1427,358,-1,174,1433,711,-1,711,1431,174,-1,361,1435,711,-1,711,1433,361,-1,0,1367,712,-1,712,1429,0,-1,343,1436,712,-1,712,1367,343,-1,175,1437,712,-1,712,1436,175,-1,360,1429,712,-1,712,1437,360,-1,1,1438,713,-1,713,1371,1,-1,362,1439,713,-1,713,1438,362,-1,175,1436,713,-1,713,1439,175,-1,343,1371,713,-1,713,1436,343,-1,11,1434,714,-1,714,1440,11,-1,360,1437,714,-1,714,1434,360,-1,175,1439,714,-1,714,1437,175,-1,362,1440,714,-1,714,1439,362,-1,1,1372,715,-1,715,1443,1,-1,342,1441,715,-1,715,1372,342,-1,176,1442,715,-1,715,1441,176,-1,364,1443,715,-1,715,1442,364,-1,2,1444,716,-1,716,1368,2,-1,365,1445,716,-1,716,1444,365,-1,176,1441,716,-1,716,1445,176,-1,342,1368,716,-1,716,1441,342,-1,91,1446,717,-1,717,1448,91,-1,363,1447,717,-1,717,1446,363,-1,176,1445,717,-1,717,1447,176,-1,365,1448,717,-1,717,1445,365,-1,90,1449,718,-1,718,1450,90,-1,364,1442,718,-1,718,1449,364,-1,176,1447,718,-1,718,1442,176,-1,363,1450,718,-1,718,1447,363,-1,2,1379,719,-1,719,1444,2,-1,345,1451,719,-1,719,1379,345,-1,177,1452,719,-1,719,1451,177,-1,365,1444,719,-1,719,1452,365,-1,3,1453,720,-1,720,1376,3,-1,367,1454,720,-1,720,1453,367,-1,177,1451,720,-1,720,1454,177,-1,345,1376,720,-1,720,1451,345,-1,92,1455,721,-1,721,1457,92,-1,366,1456,721,-1,721,1455,366,-1,177,1454,721,-1,721,1456,177,-1,367,1457,721,-1,721,1454,367,-1,91,1448,722,-1,722,1458,91,-1,365,1452,722,-1,722,1448,365,-1,177,1456,722,-1,722,1452,177,-1,366,1458,722,-1,722,1456,366,-1,3,1386,723,-1,723,1453,3,-1,347,1459,723,-1,723,1386,347,-1,178,1460,723,-1,723,1459,178,-1,367,1453,723,-1,723,1460,367,-1,4,1461,724,-1,724,1383,4,-1,369,1462,724,-1,724,1461,369,-1,178,1459,724,-1,724,1462,178,-1,347,1383,724,-1,724,1459,347,-1,93,1463,725,-1,725,1465,93,-1,368,1464,725,-1,725,1463,368,-1,178,1462,725,-1,725,1464,178,-1,369,1465,725,-1,725,1462,369,-1,92,1457,726,-1,726,1466,92,-1,367,1460,726,-1,726,1457,367,-1,178,1464,726,-1,726,1460,178,-1,368,1466,726,-1,726,1464,368,-1,4,1393,727,-1,727,1461,4,-1,349,1467,727,-1,727,1393,349,-1,179,1468,727,-1,727,1467,179,-1,369,1461,727,-1,727,1468,369,-1,5,1469,728,-1,728,1390,5,-1,371,1470,728,-1,728,1469,371,-1,179,1467,728,-1,728,1470,179,-1,349,1390,728,-1,728,1467,349,-1,94,1471,729,-1,729,1473,94,-1,370,1472,729,-1,729,1471,370,-1,179,1470,729,-1,729,1472,179,-1,371,1473,729,-1,729,1470,371,-1,93,1465,730,-1,730,1474,93,-1,369,1468,730,-1,730,1465,369,-1,179,1472,730,-1,730,1468,179,-1,370,1474,730,-1,730,1472,370,-1,5,1400,731,-1,731,1469,5,-1,351,1475,731,-1,731,1400,351,-1,180,1476,731,-1,731,1475,180,-1,371,1469,731,-1,731,1476,371,-1,6,1477,732,-1,732,1397,6,-1,373,1478,732,-1,732,1477,373,-1,180,1475,732,-1,732,1478,180,-1,351,1397,732,-1,732,1475,351,-1,95,1479,733,-1,733,1481,95,-1,372,1480,733,-1,733,1479,372,-1,180,1478,733,-1,733,1480,180,-1,373,1481,733,-1,733,1478,373,-1,94,1473,734,-1,734,1482,94,-1,371,1476,734,-1,734,1473,371,-1,180,1480,734,-1,734,1476,180,-1,372,1482,734,-1,734,1480,372,-1,6,1407,735,-1,735,1477,6,-1,353,1483,735,-1,735,1407,353,-1,181,1484,735,-1,735,1483,181,-1,373,1477,735,-1,735,1484,373,-1,7,1485,736,-1,736,1404,7,-1,375,1486,736,-1,736,1485,375,-1,181,1483,736,-1,736,1486,181,-1,353,1404,736,-1,736,1483,353,-1,96,1487,737,-1,737,1489,96,-1,374,1488,737,-1,737,1487,374,-1,181,1486,737,-1,737,1488,181,-1,375,1489,737,-1,737,1486,375,-1,95,1481,738,-1,738,1490,95,-1,373,1484,738,-1,738,1481,373,-1,181,1488,738,-1,738,1484,181,-1,374,1490,738,-1,738,1488,374,-1,7,1414,739,-1,739,1485,7,-1,355,1491,739,-1,739,1414,355,-1,182,1492,739,-1,739,1491,182,-1,375,1485,739,-1,739,1492,375,-1,8,1493,740,-1,740,1411,8,-1,377,1494,740,-1,740,1493,377,-1,182,1491,740,-1,740,1494,182,-1,355,1411,740,-1,740,1491,355,-1,97,1495,741,-1,741,1497,97,-1,376,1496,741,-1,741,1495,376,-1,182,1494,741,-1,741,1496,182,-1,377,1497,741,-1,741,1494,377,-1,96,1489,742,-1,742,1498,96,-1,375,1492,742,-1,742,1489,375,-1,182,1496,742,-1,742,1492,182,-1,376,1498,742,-1,742,1496,376,-1,8,1421,743,-1,743,1493,8,-1,357,1499,743,-1,743,1421,357,-1,183,1500,743,-1,743,1499,183,-1,377,1493,743,-1,743,1500,377,-1,9,1501,744,-1,744,1418,9,-1,379,1502,744,-1,744,1501,379,-1,183,1499,744,-1,744,1502,183,-1,357,1418,744,-1,744,1499,357,-1,98,1503,745,-1,745,1505,98,-1,378,1504,745,-1,745,1503,378,-1,183,1502,745,-1,745,1504,183,-1,379,1505,745,-1,745,1502,379,-1,97,1497,746,-1,746,1506,97,-1,377,1500,746,-1,746,1497,377,-1,183,1504,746,-1,746,1500,183,-1,378,1506,746,-1,746,1504,378,-1,9,1428,747,-1,747,1501,9,-1,359,1507,747,-1,747,1428,359,-1,184,1508,747,-1,747,1507,184,-1,379,1501,747,-1,747,1508,379,-1,10,1509,748,-1,748,1425,10,-1,381,1510,748,-1,748,1509,381,-1,184,1507,748,-1,748,1510,184,-1,359,1425,748,-1,748,1507,359,-1,99,1511,749,-1,749,1513,99,-1,380,1512,749,-1,749,1511,380,-1,184,1510,749,-1,749,1512,184,-1,381,1513,749,-1,749,1510,381,-1,98,1505,750,-1,750,1514,98,-1,379,1508,750,-1,750,1505,379,-1,184,1512,750,-1,750,1508,184,-1,380,1514,750,-1,750,1512,380,-1,10,1435,751,-1,751,1509,10,-1,361,1515,751,-1,751,1435,361,-1,185,1516,751,-1,751,1515,185,-1,381,1509,751,-1,751,1516,381,-1,11,1517,752,-1,752,1432,11,-1,383,1518,752,-1,752,1517,383,-1,185,1515,752,-1,752,1518,185,-1,361,1432,752,-1,752,1515,361,-1,100,1519,753,-1,753,1521,100,-1,382,1520,753,-1,753,1519,382,-1,185,1518,753,-1,753,1520,185,-1,383,1521,753,-1,753,1518,383,-1,99,1513,754,-1,754,1522,99,-1,381,1516,754,-1,754,1513,381,-1,185,1520,754,-1,754,1516,185,-1,382,1522,754,-1,754,1520,382,-1,11,1440,755,-1,755,1517,11,-1,362,1523,755,-1,755,1440,362,-1,186,1524,755,-1,755,1523,186,-1,383,1517,755,-1,755,1524,383,-1,1,1443,756,-1,756,1438,1,-1,364,1525,756,-1,756,1443,364,-1,186,1523,756,-1,756,1525,186,-1,362,1438,756,-1,756,1523,362,-1,90,1526,757,-1,757,1449,90,-1,384,1527,757,-1,757,1526,384,-1,186,1525,757,-1,757,1527,186,-1,364,1449,757,-1,757,1525,364,-1,100,1521,758,-1,758,1528,100,-1,383,1524,758,-1,758,1521,383,-1,186,1527,758,-1,758,1524,186,-1,384,1528,758,-1,758,1527,384,-1,12,1529,759,-1,759,1532,12,-1,387,1530,759,-1,759,1529,387,-1,187,1531,759,-1,759,1530,187,-1,386,1532,759,-1,759,1531,386,-1,13,1533,760,-1,760,1535,13,-1,388,1534,760,-1,760,1533,388,-1,187,1530,760,-1,760,1534,187,-1,387,1535,760,-1,760,1530,387,-1,24,1536,761,-1,761,1538,24,-1,385,1537,761,-1,761,1536,385,-1,187,1534,761,-1,761,1537,187,-1,388,1538,761,-1,761,1534,388,-1,23,1539,762,-1,762,1540,23,-1,386,1531,762,-1,762,1539,386,-1,187,1537,762,-1,762,1531,187,-1,385,1540,762,-1,762,1537,385,-1,13,1541,763,-1,763,1533,13,-1,390,1542,763,-1,763,1541,390,-1,188,1543,763,-1,763,1542,188,-1,388,1533,763,-1,763,1543,388,-1,14,1544,764,-1,764,1546,14,-1,391,1545,764,-1,764,1544,391,-1,188,1542,764,-1,764,1545,188,-1,390,1546,764,-1,764,1542,390,-1,25,1547,765,-1,765,1549,25,-1,389,1548,765,-1,765,1547,389,-1,188,1545,765,-1,765,1548,188,-1,391,1549,765,-1,765,1545,391,-1,24,1538,766,-1,766,1550,24,-1,388,1543,766,-1,766,1538,388,-1,188,1548,766,-1,766,1543,188,-1,389,1550,766,-1,766,1548,389,-1,14,1551,767,-1,767,1544,14,-1,393,1552,767,-1,767,1551,393,-1,189,1553,767,-1,767,1552,189,-1,391,1544,767,-1,767,1553,391,-1,15,1554,768,-1,768,1556,15,-1,394,1555,768,-1,768,1554,394,-1,189,1552,768,-1,768,1555,189,-1,393,1556,768,-1,768,1552,393,-1,26,1557,769,-1,769,1559,26,-1,392,1558,769,-1,769,1557,392,-1,189,1555,769,-1,769,1558,189,-1,394,1559,769,-1,769,1555,394,-1,25,1549,770,-1,770,1560,25,-1,391,1553,770,-1,770,1549,391,-1,189,1558,770,-1,770,1553,189,-1,392,1560,770,-1,770,1558,392,-1,15,1561,771,-1,771,1554,15,-1,396,1562,771,-1,771,1561,396,-1,190,1563,771,-1,771,1562,190,-1,394,1554,771,-1,771,1563,394,-1,16,1564,772,-1,772,1566,16,-1,397,1565,772,-1,772,1564,397,-1,190,1562,772,-1,772,1565,190,-1,396,1566,772,-1,772,1562,396,-1,27,1567,773,-1,773,1569,27,-1,395,1568,773,-1,773,1567,395,-1,190,1565,773,-1,773,1568,190,-1,397,1569,773,-1,773,1565,397,-1,26,1559,774,-1,774,1570,26,-1,394,1563,774,-1,774,1559,394,-1,190,1568,774,-1,774,1563,190,-1,395,1570,774,-1,774,1568,395,-1,16,1571,775,-1,775,1564,16,-1,399,1572,775,-1,775,1571,399,-1,191,1573,775,-1,775,1572,191,-1,397,1564,775,-1,775,1573,397,-1,17,1574,776,-1,776,1576,17,-1,400,1575,776,-1,776,1574,400,-1,191,1572,776,-1,776,1575,191,-1,399,1576,776,-1,776,1572,399,-1,28,1577,777,-1,777,1579,28,-1,398,1578,777,-1,777,1577,398,-1,191,1575,777,-1,777,1578,191,-1,400,1579,777,-1,777,1575,400,-1,27,1569,778,-1,778,1580,27,-1,397,1573,778,-1,778,1569,397,-1,191,1578,778,-1,778,1573,191,-1,398,1580,778,-1,778,1578,398,-1,17,1581,779,-1,779,1574,17,-1,402,1582,779,-1,779,1581,402,-1,192,1583,779,-1,779,1582,192,-1,400,1574,779,-1,779,1583,400,-1,18,1584,780,-1,780,1586,18,-1,403,1585,780,-1,780,1584,403,-1,192,1582,780,-1,780,1585,192,-1,402,1586,780,-1,780,1582,402,-1,29,1587,781,-1,781,1589,29,-1,401,1588,781,-1,781,1587,401,-1,192,1585,781,-1,781,1588,192,-1,403,1589,781,-1,781,1585,403,-1,28,1579,782,-1,782,1590,28,-1,400,1583,782,-1,782,1579,400,-1,192,1588,782,-1,782,1583,192,-1,401,1590,782,-1,782,1588,401,-1,18,1591,783,-1,783,1584,18,-1,405,1592,783,-1,783,1591,405,-1,193,1593,783,-1,783,1592,193,-1,403,1584,783,-1,783,1593,403,-1,19,1594,784,-1,784,1596,19,-1,406,1595,784,-1,784,1594,406,-1,193,1592,784,-1,784,1595,193,-1,405,1596,784,-1,784,1592,405,-1,30,1597,785,-1,785,1599,30,-1,404,1598,785,-1,785,1597,404,-1,193,1595,785,-1,785,1598,193,-1,406,1599,785,-1,785,1595,406,-1,29,1589,786,-1,786,1600,29,-1,403,1593,786,-1,786,1589,403,-1,193,1598,786,-1,786,1593,193,-1,404,1600,786,-1,786,1598,404,-1,19,1601,787,-1,787,1594,19,-1,408,1602,787,-1,787,1601,408,-1,194,1603,787,-1,787,1602,194,-1,406,1594,787,-1,787,1603,406,-1,20,1604,788,-1,788,1606,20,-1,409,1605,788,-1,788,1604,409,-1,194,1602,788,-1,788,1605,194,-1,408,1606,788,-1,788,1602,408,-1,31,1607,789,-1,789,1609,31,-1,407,1608,789,-1,789,1607,407,-1,194,1605,789,-1,789,1608,194,-1,409,1609,789,-1,789,1605,409,-1,30,1599,790,-1,790,1610,30,-1,406,1603,790,-1,790,1599,406,-1,194,1608,790,-1,790,1603,194,-1,407,1610,790,-1,790,1608,407,-1,20,1611,791,-1,791,1604,20,-1,411,1612,791,-1,791,1611,411,-1,195,1613,791,-1,791,1612,195,-1,409,1604,791,-1,791,1613,409,-1,21,1614,792,-1,792,1616,21,-1,412,1615,792,-1,792,1614,412,-1,195,1612,792,-1,792,1615,195,-1,411,1616,792,-1,792,1612,411,-1,32,1617,793,-1,793,1619,32,-1,410,1618,793,-1,793,1617,410,-1,195,1615,793,-1,793,1618,195,-1,412,1619,793,-1,793,1615,412,-1,31,1609,794,-1,794,1620,31,-1,409,1613,794,-1,794,1609,409,-1,195,1618,794,-1,794,1613,195,-1,410,1620,794,-1,794,1618,410,-1,21,1621,795,-1,795,1614,21,-1,414,1622,795,-1,795,1621,414,-1,196,1623,795,-1,795,1622,196,-1,412,1614,795,-1,795,1623,412,-1,22,1624,796,-1,796,1626,22,-1,415,1625,796,-1,796,1624,415,-1,196,1622,796,-1,796,1625,196,-1,414,1626,796,-1,796,1622,414,-1,33,1627,797,-1,797,1629,33,-1,413,1628,797,-1,797,1627,413,-1,196,1625,797,-1,797,1628,196,-1,415,1629,797,-1,797,1625,415,-1,32,1619,798,-1,798,1630,32,-1,412,1623,798,-1,798,1619,412,-1,196,1628,798,-1,798,1623,196,-1,413,1630,798,-1,798,1628,413,-1,22,1631,799,-1,799,1624,22,-1,417,1632,799,-1,799,1631,417,-1,197,1633,799,-1,799,1632,197,-1,415,1624,799,-1,799,1633,415,-1,12,1532,800,-1,800,1635,12,-1,386,1634,800,-1,800,1532,386,-1,197,1632,800,-1,800,1634,197,-1,417,1635,800,-1,800,1632,417,-1,23,1636,801,-1,801,1539,23,-1,416,1637,801,-1,801,1636,416,-1,197,1634,801,-1,801,1637,197,-1,386,1539,801,-1,801,1634,386,-1,33,1629,802,-1,802,1638,33,-1,415,1633,802,-1,802,1629,415,-1,197,1637,802,-1,802,1633,197,-1,416,1638,802,-1,802,1637,416,-1,23,1540,803,-1,803,1641,23,-1,385,1639,803,-1,803,1540,385,-1,198,1640,803,-1,803,1639,198,-1,419,1641,803,-1,803,1640,419,-1,24,1642,804,-1,804,1536,24,-1,420,1643,804,-1,804,1642,420,-1,198,1639,804,-1,804,1643,198,-1,385,1536,804,-1,804,1639,385,-1,35,1644,805,-1,805,1646,35,-1,418,1645,805,-1,805,1644,418,-1,198,1643,805,-1,805,1645,198,-1,420,1646,805,-1,805,1643,420,-1,34,1647,806,-1,806,1648,34,-1,419,1640,806,-1,806,1647,419,-1,198,1645,806,-1,806,1640,198,-1,418,1648,806,-1,806,1645,418,-1,24,1550,807,-1,807,1642,24,-1,389,1649,807,-1,807,1550,389,-1,199,1650,807,-1,807,1649,199,-1,420,1642,807,-1,807,1650,420,-1,25,1651,808,-1,808,1547,25,-1,422,1652,808,-1,808,1651,422,-1,199,1649,808,-1,808,1652,199,-1,389,1547,808,-1,808,1649,389,-1,36,1653,809,-1,809,1655,36,-1,421,1654,809,-1,809,1653,421,-1,199,1652,809,-1,809,1654,199,-1,422,1655,809,-1,809,1652,422,-1,35,1646,810,-1,810,1656,35,-1,420,1650,810,-1,810,1646,420,-1,199,1654,810,-1,810,1650,199,-1,421,1656,810,-1,810,1654,421,-1,25,1560,811,-1,811,1651,25,-1,392,1657,811,-1,811,1560,392,-1,200,1658,811,-1,811,1657,200,-1,422,1651,811,-1,811,1658,422,-1,26,1659,812,-1,812,1557,26,-1,424,1660,812,-1,812,1659,424,-1,200,1657,812,-1,812,1660,200,-1,392,1557,812,-1,812,1657,392,-1,37,1661,813,-1,813,1663,37,-1,423,1662,813,-1,813,1661,423,-1,200,1660,813,-1,813,1662,200,-1,424,1663,813,-1,813,1660,424,-1,36,1655,814,-1,814,1664,36,-1,422,1658,814,-1,814,1655,422,-1,200,1662,814,-1,814,1658,200,-1,423,1664,814,-1,814,1662,423,-1,26,1570,815,-1,815,1659,26,-1,395,1665,815,-1,815,1570,395,-1,201,1666,815,-1,815,1665,201,-1,424,1659,815,-1,815,1666,424,-1,27,1667,816,-1,816,1567,27,-1,426,1668,816,-1,816,1667,426,-1,201,1665,816,-1,816,1668,201,-1,395,1567,816,-1,816,1665,395,-1,38,1669,817,-1,817,1671,38,-1,425,1670,817,-1,817,1669,425,-1,201,1668,817,-1,817,1670,201,-1,426,1671,817,-1,817,1668,426,-1,37,1663,818,-1,818,1672,37,-1,424,1666,818,-1,818,1663,424,-1,201,1670,818,-1,818,1666,201,-1,425,1672,818,-1,818,1670,425,-1,27,1580,819,-1,819,1667,27,-1,398,1673,819,-1,819,1580,398,-1,202,1674,819,-1,819,1673,202,-1,426,1667,819,-1,819,1674,426,-1,28,1675,820,-1,820,1577,28,-1,428,1676,820,-1,820,1675,428,-1,202,1673,820,-1,820,1676,202,-1,398,1577,820,-1,820,1673,398,-1,39,1677,821,-1,821,1679,39,-1,427,1678,821,-1,821,1677,427,-1,202,1676,821,-1,821,1678,202,-1,428,1679,821,-1,821,1676,428,-1,38,1671,822,-1,822,1680,38,-1,426,1674,822,-1,822,1671,426,-1,202,1678,822,-1,822,1674,202,-1,427,1680,822,-1,822,1678,427,-1,29,1600,823,-1,823,1683,29,-1,404,1681,823,-1,823,1600,404,-1,203,1682,823,-1,823,1681,203,-1,430,1683,823,-1,823,1682,430,-1,30,1684,824,-1,824,1597,30,-1,431,1685,824,-1,824,1684,431,-1,203,1681,824,-1,824,1685,203,-1,404,1597,824,-1,824,1681,404,-1,41,1686,825,-1,825,1688,41,-1,429,1687,825,-1,825,1686,429,-1,203,1685,825,-1,825,1687,203,-1,431,1688,825,-1,825,1685,431,-1,40,1689,826,-1,826,1690,40,-1,430,1682,826,-1,826,1689,430,-1,203,1687,826,-1,826,1682,203,-1,429,1690,826,-1,826,1687,429,-1,30,1610,827,-1,827,1684,30,-1,407,1691,827,-1,827,1610,407,-1,204,1692,827,-1,827,1691,204,-1,431,1684,827,-1,827,1692,431,-1,31,1693,828,-1,828,1607,31,-1,433,1694,828,-1,828,1693,433,-1,204,1691,828,-1,828,1694,204,-1,407,1607,828,-1,828,1691,407,-1,42,1695,829,-1,829,1697,42,-1,432,1696,829,-1,829,1695,432,-1,204,1694,829,-1,829,1696,204,-1,433,1697,829,-1,829,1694,433,-1,41,1688,830,-1,830,1698,41,-1,431,1692,830,-1,830,1688,431,-1,204,1696,830,-1,830,1692,204,-1,432,1698,830,-1,830,1696,432,-1,31,1620,831,-1,831,1693,31,-1,410,1699,831,-1,831,1620,410,-1,205,1700,831,-1,831,1699,205,-1,433,1693,831,-1,831,1700,433,-1,32,1701,832,-1,832,1617,32,-1,435,1702,832,-1,832,1701,435,-1,205,1699,832,-1,832,1702,205,-1,410,1617,832,-1,832,1699,410,-1,43,1703,833,-1,833,1705,43,-1,434,1704,833,-1,833,1703,434,-1,205,1702,833,-1,833,1704,205,-1,435,1705,833,-1,833,1702,435,-1,42,1697,834,-1,834,1706,42,-1,433,1700,834,-1,834,1697,433,-1,205,1704,834,-1,834,1700,205,-1,434,1706,834,-1,834,1704,434,-1,32,1630,835,-1,835,1701,32,-1,413,1707,835,-1,835,1630,413,-1,206,1708,835,-1,835,1707,206,-1,435,1701,835,-1,835,1708,435,-1,33,1709,836,-1,836,1627,33,-1,437,1710,836,-1,836,1709,437,-1,206,1707,836,-1,836,1710,206,-1,413,1627,836,-1,836,1707,413,-1,44,1711,837,-1,837,1713,44,-1,436,1712,837,-1,837,1711,436,-1,206,1710,837,-1,837,1712,206,-1,437,1713,837,-1,837,1710,437,-1,43,1705,838,-1,838,1714,43,-1,435,1708,838,-1,838,1705,435,-1,206,1712,838,-1,838,1708,206,-1,436,1714,838,-1,838,1712,436,-1,33,1638,839,-1,839,1709,33,-1,416,1715,839,-1,839,1638,416,-1,207,1716,839,-1,839,1715,207,-1,437,1709,839,-1,839,1716,437,-1,23,1641,840,-1,840,1636,23,-1,419,1717,840,-1,840,1641,419,-1,207,1715,840,-1,840,1717,207,-1,416,1636,840,-1,840,1715,416,-1,34,1718,841,-1,841,1647,34,-1,438,1719,841,-1,841,1718,438,-1,207,1717,841,-1,841,1719,207,-1,419,1647,841,-1,841,1717,419,-1,44,1713,842,-1,842,1720,44,-1,437,1716,842,-1,842,1713,437,-1,207,1719,842,-1,842,1716,207,-1,438,1720,842,-1,842,1719,438,-1,34,1648,843,-1,843,1723,34,-1,418,1721,843,-1,843,1648,418,-1,208,1722,843,-1,843,1721,208,-1,440,1723,843,-1,843,1722,440,-1,35,1724,844,-1,844,1644,35,-1,441,1725,844,-1,844,1724,441,-1,208,1721,844,-1,844,1725,208,-1,418,1644,844,-1,844,1721,418,-1,46,1726,845,-1,845,1728,46,-1,439,1727,845,-1,845,1726,439,-1,208,1725,845,-1,845,1727,208,-1,441,1728,845,-1,845,1725,441,-1,45,1729,846,-1,846,1730,45,-1,440,1722,846,-1,846,1729,440,-1,208,1727,846,-1,846,1722,208,-1,439,1730,846,-1,846,1727,439,-1,35,1656,847,-1,847,1724,35,-1,421,1731,847,-1,847,1656,421,-1,209,1732,847,-1,847,1731,209,-1,441,1724,847,-1,847,1732,441,-1,36,1733,848,-1,848,1653,36,-1,443,1734,848,-1,848,1733,443,-1,209,1731,848,-1,848,1734,209,-1,421,1653,848,-1,848,1731,421,-1,47,1735,849,-1,849,1737,47,-1,442,1736,849,-1,849,1735,442,-1,209,1734,849,-1,849,1736,209,-1,443,1737,849,-1,849,1734,443,-1,46,1728,850,-1,850,1738,46,-1,441,1732,850,-1,850,1728,441,-1,209,1736,850,-1,850,1732,209,-1,442,1738,850,-1,850,1736,442,-1,36,1664,851,-1,851,1733,36,-1,423,1739,851,-1,851,1664,423,-1,210,1740,851,-1,851,1739,210,-1,443,1733,851,-1,851,1740,443,-1,37,1741,852,-1,852,1661,37,-1,445,1742,852,-1,852,1741,445,-1,210,1739,852,-1,852,1742,210,-1,423,1661,852,-1,852,1739,423,-1,48,1743,853,-1,853,1745,48,-1,444,1744,853,-1,853,1743,444,-1,210,1742,853,-1,853,1744,210,-1,445,1745,853,-1,853,1742,445,-1,47,1737,854,-1,854,1746,47,-1,443,1740,854,-1,854,1737,443,-1,210,1744,854,-1,854,1740,210,-1,444,1746,854,-1,854,1744,444,-1,37,1672,855,-1,855,1741,37,-1,425,1747,855,-1,855,1672,425,-1,211,1748,855,-1,855,1747,211,-1,445,1741,855,-1,855,1748,445,-1,38,1749,856,-1,856,1669,38,-1,447,1750,856,-1,856,1749,447,-1,211,1747,856,-1,856,1750,211,-1,425,1669,856,-1,856,1747,425,-1,49,1751,857,-1,857,1753,49,-1,446,1752,857,-1,857,1751,446,-1,211,1750,857,-1,857,1752,211,-1,447,1753,857,-1,857,1750,447,-1,48,1745,858,-1,858,1754,48,-1,445,1748,858,-1,858,1745,445,-1,211,1752,858,-1,858,1748,211,-1,446,1754,858,-1,858,1752,446,-1,38,1680,859,-1,859,1749,38,-1,427,1755,859,-1,859,1680,427,-1,212,1756,859,-1,859,1755,212,-1,447,1749,859,-1,859,1756,447,-1,39,1757,860,-1,860,1677,39,-1,449,1758,860,-1,860,1757,449,-1,212,1755,860,-1,860,1758,212,-1,427,1677,860,-1,860,1755,427,-1,50,1759,861,-1,861,1761,50,-1,448,1760,861,-1,861,1759,448,-1,212,1758,861,-1,861,1760,212,-1,449,1761,861,-1,861,1758,449,-1,49,1753,862,-1,862,1762,49,-1,447,1756,862,-1,862,1753,447,-1,212,1760,862,-1,862,1756,212,-1,448,1762,862,-1,862,1760,448,-1,39,1763,863,-1,863,1757,39,-1,451,1764,863,-1,863,1763,451,-1,213,1765,863,-1,863,1764,213,-1,449,1757,863,-1,863,1765,449,-1,40,1766,864,-1,864,1768,40,-1,452,1767,864,-1,864,1766,452,-1,213,1764,864,-1,864,1767,213,-1,451,1768,864,-1,864,1764,451,-1,51,1769,865,-1,865,1771,51,-1,450,1770,865,-1,865,1769,450,-1,213,1767,865,-1,865,1770,213,-1,452,1771,865,-1,865,1767,452,-1,50,1761,866,-1,866,1772,50,-1,449,1765,866,-1,866,1761,449,-1,213,1770,866,-1,866,1765,213,-1,450,1772,866,-1,866,1770,450,-1,40,1690,867,-1,867,1766,40,-1,429,1773,867,-1,867,1690,429,-1,214,1774,867,-1,867,1773,214,-1,452,1766,867,-1,867,1774,452,-1,41,1775,868,-1,868,1686,41,-1,454,1776,868,-1,868,1775,454,-1,214,1773,868,-1,868,1776,214,-1,429,1686,868,-1,868,1773,429,-1,52,1777,869,-1,869,1779,52,-1,453,1778,869,-1,869,1777,453,-1,214,1776,869,-1,869,1778,214,-1,454,1779,869,-1,869,1776,454,-1,51,1771,870,-1,870,1780,51,-1,452,1774,870,-1,870,1771,452,-1,214,1778,870,-1,870,1774,214,-1,453,1780,870,-1,870,1778,453,-1,41,1698,871,-1,871,1775,41,-1,432,1781,871,-1,871,1698,432,-1,215,1782,871,-1,871,1781,215,-1,454,1775,871,-1,871,1782,454,-1,42,1783,872,-1,872,1695,42,-1,456,1784,872,-1,872,1783,456,-1,215,1781,872,-1,872,1784,215,-1,432,1695,872,-1,872,1781,432,-1,53,1785,873,-1,873,1787,53,-1,455,1786,873,-1,873,1785,455,-1,215,1784,873,-1,873,1786,215,-1,456,1787,873,-1,873,1784,456,-1,52,1779,874,-1,874,1788,52,-1,454,1782,874,-1,874,1779,454,-1,215,1786,874,-1,874,1782,215,-1,455,1788,874,-1,874,1786,455,-1,42,1706,875,-1,875,1783,42,-1,434,1789,875,-1,875,1706,434,-1,216,1790,875,-1,875,1789,216,-1,456,1783,875,-1,875,1790,456,-1,43,1791,876,-1,876,1703,43,-1,458,1792,876,-1,876,1791,458,-1,216,1789,876,-1,876,1792,216,-1,434,1703,876,-1,876,1789,434,-1,54,1793,877,-1,877,1795,54,-1,457,1794,877,-1,877,1793,457,-1,216,1792,877,-1,877,1794,216,-1,458,1795,877,-1,877,1792,458,-1,53,1787,878,-1,878,1796,53,-1,456,1790,878,-1,878,1787,456,-1,216,1794,878,-1,878,1790,216,-1,457,1796,878,-1,878,1794,457,-1,43,1714,879,-1,879,1791,43,-1,436,1797,879,-1,879,1714,436,-1,217,1798,879,-1,879,1797,217,-1,458,1791,879,-1,879,1798,458,-1,44,1799,880,-1,880,1711,44,-1,460,1800,880,-1,880,1799,460,-1,217,1797,880,-1,880,1800,217,-1,436,1711,880,-1,880,1797,436,-1,55,1801,881,-1,881,1803,55,-1,459,1802,881,-1,881,1801,459,-1,217,1800,881,-1,881,1802,217,-1,460,1803,881,-1,881,1800,460,-1,54,1795,882,-1,882,1804,54,-1,458,1798,882,-1,882,1795,458,-1,217,1802,882,-1,882,1798,217,-1,459,1804,882,-1,882,1802,459,-1,44,1720,883,-1,883,1799,44,-1,438,1805,883,-1,883,1720,438,-1,218,1806,883,-1,883,1805,218,-1,460,1799,883,-1,883,1806,460,-1,34,1723,884,-1,884,1718,34,-1,440,1807,884,-1,884,1723,440,-1,218,1805,884,-1,884,1807,218,-1,438,1718,884,-1,884,1805,438,-1,45,1808,885,-1,885,1729,45,-1,461,1809,885,-1,885,1808,461,-1,218,1807,885,-1,885,1809,218,-1,440,1729,885,-1,885,1807,440,-1,55,1803,886,-1,886,1810,55,-1,460,1806,886,-1,886,1803,460,-1,218,1809,886,-1,886,1806,218,-1,461,1810,886,-1,886,1809,461,-1,45,1730,887,-1,887,1813,45,-1,439,1811,887,-1,887,1730,439,-1,219,1812,887,-1,887,1811,219,-1,463,1813,887,-1,887,1812,463,-1,46,1814,888,-1,888,1726,46,-1,464,1815,888,-1,888,1814,464,-1,219,1811,888,-1,888,1815,219,-1,439,1726,888,-1,888,1811,439,-1,57,1816,889,-1,889,1818,57,-1,462,1817,889,-1,889,1816,462,-1,219,1815,889,-1,889,1817,219,-1,464,1818,889,-1,889,1815,464,-1,56,1819,890,-1,890,1820,56,-1,463,1812,890,-1,890,1819,463,-1,219,1817,890,-1,890,1812,219,-1,462,1820,890,-1,890,1817,462,-1,46,1738,891,-1,891,1814,46,-1,442,1821,891,-1,891,1738,442,-1,220,1822,891,-1,891,1821,220,-1,464,1814,891,-1,891,1822,464,-1,47,1823,892,-1,892,1735,47,-1,466,1824,892,-1,892,1823,466,-1,220,1821,892,-1,892,1824,220,-1,442,1735,892,-1,892,1821,442,-1,58,1825,893,-1,893,1827,58,-1,465,1826,893,-1,893,1825,465,-1,220,1824,893,-1,893,1826,220,-1,466,1827,893,-1,893,1824,466,-1,57,1818,894,-1,894,1828,57,-1,464,1822,894,-1,894,1818,464,-1,220,1826,894,-1,894,1822,220,-1,465,1828,894,-1,894,1826,465,-1,47,1746,895,-1,895,1823,47,-1,444,1829,895,-1,895,1746,444,-1,221,1830,895,-1,895,1829,221,-1,466,1823,895,-1,895,1830,466,-1,48,1831,896,-1,896,1743,48,-1,468,1832,896,-1,896,1831,468,-1,221,1829,896,-1,896,1832,221,-1,444,1743,896,-1,896,1829,444,-1,59,1833,897,-1,897,1835,59,-1,467,1834,897,-1,897,1833,467,-1,221,1832,897,-1,897,1834,221,-1,468,1835,897,-1,897,1832,468,-1,58,1827,898,-1,898,1836,58,-1,466,1830,898,-1,898,1827,466,-1,221,1834,898,-1,898,1830,221,-1,467,1836,898,-1,898,1834,467,-1,48,1754,899,-1,899,1831,48,-1,446,1837,899,-1,899,1754,446,-1,222,1838,899,-1,899,1837,222,-1,468,1831,899,-1,899,1838,468,-1,49,1839,900,-1,900,1751,49,-1,470,1840,900,-1,900,1839,470,-1,222,1837,900,-1,900,1840,222,-1,446,1751,900,-1,900,1837,446,-1,60,1841,901,-1,901,1843,60,-1,469,1842,901,-1,901,1841,469,-1,222,1840,901,-1,901,1842,222,-1,470,1843,901,-1,901,1840,470,-1,59,1835,902,-1,902,1844,59,-1,468,1838,902,-1,902,1835,468,-1,222,1842,902,-1,902,1838,222,-1,469,1844,902,-1,902,1842,469,-1,49,1762,903,-1,903,1839,49,-1,448,1845,903,-1,903,1762,448,-1,223,1846,903,-1,903,1845,223,-1,470,1839,903,-1,903,1846,470,-1,50,1847,904,-1,904,1759,50,-1,472,1848,904,-1,904,1847,472,-1,223,1845,904,-1,904,1848,223,-1,448,1759,904,-1,904,1845,448,-1,61,1849,905,-1,905,1851,61,-1,471,1850,905,-1,905,1849,471,-1,223,1848,905,-1,905,1850,223,-1,472,1851,905,-1,905,1848,472,-1,60,1843,906,-1,906,1852,60,-1,470,1846,906,-1,906,1843,470,-1,223,1850,906,-1,906,1846,223,-1,471,1852,906,-1,906,1850,471,-1,51,1780,907,-1,907,1855,51,-1,453,1853,907,-1,907,1780,453,-1,224,1854,907,-1,907,1853,224,-1,474,1855,907,-1,907,1854,474,-1,52,1856,908,-1,908,1777,52,-1,475,1857,908,-1,908,1856,475,-1,224,1853,908,-1,908,1857,224,-1,453,1777,908,-1,908,1853,453,-1,63,1858,909,-1,909,1860,63,-1,473,1859,909,-1,909,1858,473,-1,224,1857,909,-1,909,1859,224,-1,475,1860,909,-1,909,1857,475,-1,62,1861,910,-1,910,1862,62,-1,474,1854,910,-1,910,1861,474,-1,224,1859,910,-1,910,1854,224,-1,473,1862,910,-1,910,1859,473,-1,52,1788,911,-1,911,1856,52,-1,455,1863,911,-1,911,1788,455,-1,225,1864,911,-1,911,1863,225,-1,475,1856,911,-1,911,1864,475,-1,53,1865,912,-1,912,1785,53,-1,477,1866,912,-1,912,1865,477,-1,225,1863,912,-1,912,1866,225,-1,455,1785,912,-1,912,1863,455,-1,64,1867,913,-1,913,1869,64,-1,476,1868,913,-1,913,1867,476,-1,225,1866,913,-1,913,1868,225,-1,477,1869,913,-1,913,1866,477,-1,63,1860,914,-1,914,1870,63,-1,475,1864,914,-1,914,1860,475,-1,225,1868,914,-1,914,1864,225,-1,476,1870,914,-1,914,1868,476,-1,53,1796,915,-1,915,1865,53,-1,457,1871,915,-1,915,1796,457,-1,226,1872,915,-1,915,1871,226,-1,477,1865,915,-1,915,1872,477,-1,54,1873,916,-1,916,1793,54,-1,479,1874,916,-1,916,1873,479,-1,226,1871,916,-1,916,1874,226,-1,457,1793,916,-1,916,1871,457,-1,65,1875,917,-1,917,1877,65,-1,478,1876,917,-1,917,1875,478,-1,226,1874,917,-1,917,1876,226,-1,479,1877,917,-1,917,1874,479,-1,64,1869,918,-1,918,1878,64,-1,477,1872,918,-1,918,1869,477,-1,226,1876,918,-1,918,1872,226,-1,478,1878,918,-1,918,1876,478,-1,54,1804,919,-1,919,1873,54,-1,459,1879,919,-1,919,1804,459,-1,227,1880,919,-1,919,1879,227,-1,479,1873,919,-1,919,1880,479,-1,55,1881,920,-1,920,1801,55,-1,481,1882,920,-1,920,1881,481,-1,227,1879,920,-1,920,1882,227,-1,459,1801,920,-1,920,1879,459,-1,66,1883,921,-1,921,1885,66,-1,480,1884,921,-1,921,1883,480,-1,227,1882,921,-1,921,1884,227,-1,481,1885,921,-1,921,1882,481,-1,65,1877,922,-1,922,1886,65,-1,479,1880,922,-1,922,1877,479,-1,227,1884,922,-1,922,1880,227,-1,480,1886,922,-1,922,1884,480,-1,55,1810,923,-1,923,1881,55,-1,461,1887,923,-1,923,1810,461,-1,228,1888,923,-1,923,1887,228,-1,481,1881,923,-1,923,1888,481,-1,45,1813,924,-1,924,1808,45,-1,463,1889,924,-1,924,1813,463,-1,228,1887,924,-1,924,1889,228,-1,461,1808,924,-1,924,1887,461,-1,56,1890,925,-1,925,1819,56,-1,482,1891,925,-1,925,1890,482,-1,228,1889,925,-1,925,1891,228,-1,463,1819,925,-1,925,1889,463,-1,66,1885,926,-1,926,1892,66,-1,481,1888,926,-1,926,1885,481,-1,228,1891,926,-1,926,1888,228,-1,482,1892,926,-1,926,1891,482,-1,56,1820,927,-1,927,1895,56,-1,462,1893,927,-1,927,1820,462,-1,229,1894,927,-1,927,1893,229,-1,484,1895,927,-1,927,1894,484,-1,57,1896,928,-1,928,1816,57,-1,485,1897,928,-1,928,1896,485,-1,229,1893,928,-1,928,1897,229,-1,462,1816,928,-1,928,1893,462,-1,68,1898,929,-1,929,1900,68,-1,483,1899,929,-1,929,1898,483,-1,229,1897,929,-1,929,1899,229,-1,485,1900,929,-1,929,1897,485,-1,67,1901,930,-1,930,1902,67,-1,484,1894,930,-1,930,1901,484,-1,229,1899,930,-1,930,1894,229,-1,483,1902,930,-1,930,1899,483,-1,57,1828,931,-1,931,1896,57,-1,465,1903,931,-1,931,1828,465,-1,230,1904,931,-1,931,1903,230,-1,485,1896,931,-1,931,1904,485,-1,58,1905,932,-1,932,1825,58,-1,487,1906,932,-1,932,1905,487,-1,230,1903,932,-1,932,1906,230,-1,465,1825,932,-1,932,1903,465,-1,69,1907,933,-1,933,1909,69,-1,486,1908,933,-1,933,1907,486,-1,230,1906,933,-1,933,1908,230,-1,487,1909,933,-1,933,1906,487,-1,68,1900,934,-1,934,1910,68,-1,485,1904,934,-1,934,1900,485,-1,230,1908,934,-1,934,1904,230,-1,486,1910,934,-1,934,1908,486,-1,58,1836,935,-1,935,1905,58,-1,467,1911,935,-1,935,1836,467,-1,231,1912,935,-1,935,1911,231,-1,487,1905,935,-1,935,1912,487,-1,59,1913,936,-1,936,1833,59,-1,489,1914,936,-1,936,1913,489,-1,231,1911,936,-1,936,1914,231,-1,467,1833,936,-1,936,1911,467,-1,70,1915,937,-1,937,1917,70,-1,488,1916,937,-1,937,1915,488,-1,231,1914,937,-1,937,1916,231,-1,489,1917,937,-1,937,1914,489,-1,69,1909,938,-1,938,1918,69,-1,487,1912,938,-1,938,1909,487,-1,231,1916,938,-1,938,1912,231,-1,488,1918,938,-1,938,1916,488,-1,59,1844,939,-1,939,1913,59,-1,469,1919,939,-1,939,1844,469,-1,232,1920,939,-1,939,1919,232,-1,489,1913,939,-1,939,1920,489,-1,60,1921,940,-1,940,1841,60,-1,491,1922,940,-1,940,1921,491,-1,232,1919,940,-1,940,1922,232,-1,469,1841,940,-1,940,1919,469,-1,71,1923,941,-1,941,1925,71,-1,490,1924,941,-1,941,1923,490,-1,232,1922,941,-1,941,1924,232,-1,491,1925,941,-1,941,1922,491,-1,70,1917,942,-1,942,1926,70,-1,489,1920,942,-1,942,1917,489,-1,232,1924,942,-1,942,1920,232,-1,490,1926,942,-1,942,1924,490,-1,60,1852,943,-1,943,1921,60,-1,471,1927,943,-1,943,1852,471,-1,233,1928,943,-1,943,1927,233,-1,491,1921,943,-1,943,1928,491,-1,61,1929,944,-1,944,1849,61,-1,493,1930,944,-1,944,1929,493,-1,233,1927,944,-1,944,1930,233,-1,471,1849,944,-1,944,1927,471,-1,72,1931,945,-1,945,1933,72,-1,492,1932,945,-1,945,1931,492,-1,233,1930,945,-1,945,1932,233,-1,493,1933,945,-1,945,1930,493,-1,71,1925,946,-1,946,1934,71,-1,491,1928,946,-1,946,1925,491,-1,233,1932,946,-1,946,1928,233,-1,492,1934,946,-1,946,1932,492,-1,61,1935,947,-1,947,1929,61,-1,495,1936,947,-1,947,1935,495,-1,234,1937,947,-1,947,1936,234,-1,493,1929,947,-1,947,1937,493,-1,62,1938,948,-1,948,1940,62,-1,496,1939,948,-1,948,1938,496,-1,234,1936,948,-1,948,1939,234,-1,495,1940,948,-1,948,1936,495,-1,73,1941,949,-1,949,1943,73,-1,494,1942,949,-1,949,1941,494,-1,234,1939,949,-1,949,1942,234,-1,496,1943,949,-1,949,1939,496,-1,72,1933,950,-1,950,1944,72,-1,493,1937,950,-1,950,1933,493,-1,234,1942,950,-1,950,1937,234,-1,494,1944,950,-1,950,1942,494,-1,62,1862,951,-1,951,1938,62,-1,473,1945,951,-1,951,1862,473,-1,235,1946,951,-1,951,1945,235,-1,496,1938,951,-1,951,1946,496,-1,63,1947,952,-1,952,1858,63,-1,498,1948,952,-1,952,1947,498,-1,235,1945,952,-1,952,1948,235,-1,473,1858,952,-1,952,1945,473,-1,74,1949,953,-1,953,1951,74,-1,497,1950,953,-1,953,1949,497,-1,235,1948,953,-1,953,1950,235,-1,498,1951,953,-1,953,1948,498,-1,73,1943,954,-1,954,1952,73,-1,496,1946,954,-1,954,1943,496,-1,235,1950,954,-1,954,1946,235,-1,497,1952,954,-1,954,1950,497,-1,63,1870,955,-1,955,1947,63,-1,476,1953,955,-1,955,1870,476,-1,236,1954,955,-1,955,1953,236,-1,498,1947,955,-1,955,1954,498,-1,64,1955,956,-1,956,1867,64,-1,500,1956,956,-1,956,1955,500,-1,236,1953,956,-1,956,1956,236,-1,476,1867,956,-1,956,1953,476,-1,75,1957,957,-1,957,1959,75,-1,499,1958,957,-1,957,1957,499,-1,236,1956,957,-1,957,1958,236,-1,500,1959,957,-1,957,1956,500,-1,74,1951,958,-1,958,1960,74,-1,498,1954,958,-1,958,1951,498,-1,236,1958,958,-1,958,1954,236,-1,499,1960,958,-1,958,1958,499,-1,64,1878,959,-1,959,1955,64,-1,478,1961,959,-1,959,1878,478,-1,237,1962,959,-1,959,1961,237,-1,500,1955,959,-1,959,1962,500,-1,65,1963,960,-1,960,1875,65,-1,502,1964,960,-1,960,1963,502,-1,237,1961,960,-1,960,1964,237,-1,478,1875,960,-1,960,1961,478,-1,76,1965,961,-1,961,1967,76,-1,501,1966,961,-1,961,1965,501,-1,237,1964,961,-1,961,1966,237,-1,502,1967,961,-1,961,1964,502,-1,75,1959,962,-1,962,1968,75,-1,500,1962,962,-1,962,1959,500,-1,237,1966,962,-1,962,1962,237,-1,501,1968,962,-1,962,1966,501,-1,65,1886,963,-1,963,1963,65,-1,480,1969,963,-1,963,1886,480,-1,238,1970,963,-1,963,1969,238,-1,502,1963,963,-1,963,1970,502,-1,66,1971,964,-1,964,1883,66,-1,504,1972,964,-1,964,1971,504,-1,238,1969,964,-1,964,1972,238,-1,480,1883,964,-1,964,1969,480,-1,77,1973,965,-1,965,1975,77,-1,503,1974,965,-1,965,1973,503,-1,238,1972,965,-1,965,1974,238,-1,504,1975,965,-1,965,1972,504,-1,76,1967,966,-1,966,1976,76,-1,502,1970,966,-1,966,1967,502,-1,238,1974,966,-1,966,1970,238,-1,503,1976,966,-1,966,1974,503,-1,66,1892,967,-1,967,1971,66,-1,482,1977,967,-1,967,1892,482,-1,239,1978,967,-1,967,1977,239,-1,504,1971,967,-1,967,1978,504,-1,56,1895,968,-1,968,1890,56,-1,484,1979,968,-1,968,1895,484,-1,239,1977,968,-1,968,1979,239,-1,482,1890,968,-1,968,1977,482,-1,67,1980,969,-1,969,1901,67,-1,505,1981,969,-1,969,1980,505,-1,239,1979,969,-1,969,1981,239,-1,484,1901,969,-1,969,1979,484,-1,77,1975,970,-1,970,1982,77,-1,504,1978,970,-1,970,1975,504,-1,239,1981,970,-1,970,1978,239,-1,505,1982,970,-1,970,1981,505,-1,123,1983,971,-1,971,1986,123,-1,508,1984,971,-1,971,1983,508,-1,240,1985,971,-1,971,1984,240,-1,507,1986,971,-1,971,1985,507,-1,124,1987,972,-1,972,1989,124,-1,509,1988,972,-1,972,1987,509,-1,240,1984,972,-1,972,1988,240,-1,508,1989,972,-1,972,1984,508,-1,135,1990,973,-1,973,1992,135,-1,506,1991,973,-1,973,1990,506,-1,240,1988,973,-1,973,1991,240,-1,509,1992,973,-1,973,1988,509,-1,134,1993,974,-1,974,1994,134,-1,507,1985,974,-1,974,1993,507,-1,240,1991,974,-1,974,1985,240,-1,506,1994,974,-1,974,1991,506,-1,124,1995,975,-1,975,1987,124,-1,511,1996,975,-1,975,1995,511,-1,241,1997,975,-1,975,1996,241,-1,509,1987,975,-1,975,1997,509,-1,125,1998,976,-1,976,2000,125,-1,512,1999,976,-1,976,1998,512,-1,241,1996,976,-1,976,1999,241,-1,511,2000,976,-1,976,1996,511,-1,136,2001,977,-1,977,2003,136,-1,510,2002,977,-1,977,2001,510,-1,241,1999,977,-1,977,2002,241,-1,512,2003,977,-1,977,1999,512,-1,135,1992,978,-1,978,2004,135,-1,509,1997,978,-1,978,1992,509,-1,241,2002,978,-1,978,1997,241,-1,510,2004,978,-1,978,2002,510,-1,125,2005,979,-1,979,1998,125,-1,514,2006,979,-1,979,2005,514,-1,242,2007,979,-1,979,2006,242,-1,512,1998,979,-1,979,2007,512,-1,126,2008,980,-1,980,2010,126,-1,515,2009,980,-1,980,2008,515,-1,242,2006,980,-1,980,2009,242,-1,514,2010,980,-1,980,2006,514,-1,137,2011,981,-1,981,2013,137,-1,513,2012,981,-1,981,2011,513,-1,242,2009,981,-1,981,2012,242,-1,515,2013,981,-1,981,2009,515,-1,136,2003,982,-1,982,2014,136,-1,512,2007,982,-1,982,2003,512,-1,242,2012,982,-1,982,2007,242,-1,513,2014,982,-1,982,2012,513,-1,126,2015,983,-1,983,2008,126,-1,517,2016,983,-1,983,2015,517,-1,243,2017,983,-1,983,2016,243,-1,515,2008,983,-1,983,2017,515,-1,127,2018,984,-1,984,2020,127,-1,518,2019,984,-1,984,2018,518,-1,243,2016,984,-1,984,2019,243,-1,517,2020,984,-1,984,2016,517,-1,138,2021,985,-1,985,2023,138,-1,516,2022,985,-1,985,2021,516,-1,243,2019,985,-1,985,2022,243,-1,518,2023,985,-1,985,2019,518,-1,137,2013,986,-1,986,2024,137,-1,515,2017,986,-1,986,2013,515,-1,243,2022,986,-1,986,2017,243,-1,516,2024,986,-1,986,2022,516,-1,127,2025,987,-1,987,2018,127,-1,520,2026,987,-1,987,2025,520,-1,244,2027,987,-1,987,2026,244,-1,518,2018,987,-1,987,2027,518,-1,128,2028,988,-1,988,2030,128,-1,521,2029,988,-1,988,2028,521,-1,244,2026,988,-1,988,2029,244,-1,520,2030,988,-1,988,2026,520,-1,139,2031,989,-1,989,2033,139,-1,519,2032,989,-1,989,2031,519,-1,244,2029,989,-1,989,2032,244,-1,521,2033,989,-1,989,2029,521,-1,138,2023,990,-1,990,2034,138,-1,518,2027,990,-1,990,2023,518,-1,244,2032,990,-1,990,2027,244,-1,519,2034,990,-1,990,2032,519,-1,128,2035,991,-1,991,2028,128,-1,523,2036,991,-1,991,2035,523,-1,245,2037,991,-1,991,2036,245,-1,521,2028,991,-1,991,2037,521,-1,129,2038,992,-1,992,2040,129,-1,524,2039,992,-1,992,2038,524,-1,245,2036,992,-1,992,2039,245,-1,523,2040,992,-1,992,2036,523,-1,140,2041,993,-1,993,2043,140,-1,522,2042,993,-1,993,2041,522,-1,245,2039,993,-1,993,2042,245,-1,524,2043,993,-1,993,2039,524,-1,139,2033,994,-1,994,2044,139,-1,521,2037,994,-1,994,2033,521,-1,245,2042,994,-1,994,2037,245,-1,522,2044,994,-1,994,2042,522,-1,129,2045,995,-1,995,2038,129,-1,526,2046,995,-1,995,2045,526,-1,246,2047,995,-1,995,2046,246,-1,524,2038,995,-1,995,2047,524,-1,130,2048,996,-1,996,2050,130,-1,527,2049,996,-1,996,2048,527,-1,246,2046,996,-1,996,2049,246,-1,526,2050,996,-1,996,2046,526,-1,141,2051,997,-1,997,2053,141,-1,525,2052,997,-1,997,2051,525,-1,246,2049,997,-1,997,2052,246,-1,527,2053,997,-1,997,2049,527,-1,140,2043,998,-1,998,2054,140,-1,524,2047,998,-1,998,2043,524,-1,246,2052,998,-1,998,2047,246,-1,525,2054,998,-1,998,2052,525,-1,130,2055,999,-1,999,2048,130,-1,529,2056,999,-1,999,2055,529,-1,247,2057,999,-1,999,2056,247,-1,527,2048,999,-1,999,2057,527,-1,131,2058,1000,-1,1000,2060,131,-1,530,2059,1000,-1,1000,2058,530,-1,247,2056,1000,-1,1000,2059,247,-1,529,2060,1000,-1,1000,2056,529,-1,142,2061,1001,-1,1001,2063,142,-1,528,2062,1001,-1,1001,2061,528,-1,247,2059,1001,-1,1001,2062,247,-1,530,2063,1001,-1,1001,2059,530,-1,141,2053,1002,-1,1002,2064,141,-1,527,2057,1002,-1,1002,2053,527,-1,247,2062,1002,-1,1002,2057,247,-1,528,2064,1002,-1,1002,2062,528,-1,131,2065,1003,-1,1003,2058,131,-1,532,2066,1003,-1,1003,2065,532,-1,248,2067,1003,-1,1003,2066,248,-1,530,2058,1003,-1,1003,2067,530,-1,132,2068,1004,-1,1004,2070,132,-1,533,2069,1004,-1,1004,2068,533,-1,248,2066,1004,-1,1004,2069,248,-1,532,2070,1004,-1,1004,2066,532,-1,143,2071,1005,-1,1005,2073,143,-1,531,2072,1005,-1,1005,2071,531,-1,248,2069,1005,-1,1005,2072,248,-1,533,2073,1005,-1,1005,2069,533,-1,142,2063,1006,-1,1006,2074,142,-1,530,2067,1006,-1,1006,2063,530,-1,248,2072,1006,-1,1006,2067,248,-1,531,2074,1006,-1,1006,2072,531,-1,132,2075,1007,-1,1007,2068,132,-1,535,2076,1007,-1,1007,2075,535,-1,249,2077,1007,-1,1007,2076,249,-1,533,2068,1007,-1,1007,2077,533,-1,133,2078,1008,-1,1008,2080,133,-1,536,2079,1008,-1,1008,2078,536,-1,249,2076,1008,-1,1008,2079,249,-1,535,2080,1008,-1,1008,2076,535,-1,144,2081,1009,-1,1009,2083,144,-1,534,2082,1009,-1,1009,2081,534,-1,249,2079,1009,-1,1009,2082,249,-1,536,2083,1009,-1,1009,2079,536,-1,143,2073,1010,-1,1010,2084,143,-1,533,2077,1010,-1,1010,2073,533,-1,249,2082,1010,-1,1010,2077,249,-1,534,2084,1010,-1,1010,2082,534,-1,133,2085,1011,-1,1011,2078,133,-1,538,2086,1011,-1,1011,2085,538,-1,250,2087,1011,-1,1011,2086,250,-1,536,2078,1011,-1,1011,2087,536,-1,123,1986,1012,-1,1012,2089,123,-1,507,2088,1012,-1,1012,1986,507,-1,250,2086,1012,-1,1012,2088,250,-1,538,2089,1012,-1,1012,2086,538,-1,134,2090,1013,-1,1013,1993,134,-1,537,2091,1013,-1,1013,2090,537,-1,250,2088,1013,-1,1013,2091,250,-1,507,1993,1013,-1,1013,2088,507,-1,144,2083,1014,-1,1014,2092,144,-1,536,2087,1014,-1,1014,2083,536,-1,250,2091,1014,-1,1014,2087,250,-1,537,2092,1014,-1,1014,2091,537,-1,89,2093,1015,-1,1015,2096,89,-1,539,2094,1015,-1,1015,2093,539,-1,251,2095,1015,-1,1015,2094,251,-1,541,2096,1015,-1,1015,2095,541,-1,112,2097,1016,-1,1016,2099,112,-1,540,2098,1016,-1,1016,2097,540,-1,251,2094,1016,-1,1016,2098,251,-1,539,2099,1016,-1,1016,2094,539,-1,113,2100,1017,-1,1017,2101,113,-1,541,2095,1017,-1,1017,2100,541,-1,251,2098,1017,-1,1017,2095,251,-1,540,2101,1017,-1,1017,2098,540,-1,89,2096,1018,-1,1018,2104,89,-1,541,2102,1018,-1,1018,2096,541,-1,252,2103,1018,-1,1018,2102,252,-1,543,2104,1018,-1,1018,2103,543,-1,113,2105,1019,-1,1019,2100,113,-1,542,2106,1019,-1,1019,2105,542,-1,252,2102,1019,-1,1019,2106,252,-1,541,2100,1019,-1,1019,2102,541,-1,114,2107,1020,-1,1020,2108,114,-1,543,2103,1020,-1,1020,2107,543,-1,252,2106,1020,-1,1020,2103,252,-1,542,2108,1020,-1,1020,2106,542,-1,89,2104,1021,-1,1021,2111,89,-1,543,2109,1021,-1,1021,2104,543,-1,253,2110,1021,-1,1021,2109,253,-1,545,2111,1021,-1,1021,2110,545,-1,114,2112,1022,-1,1022,2107,114,-1,544,2113,1022,-1,1022,2112,544,-1,253,2109,1022,-1,1022,2113,253,-1,543,2107,1022,-1,1022,2109,543,-1,115,2114,1023,-1,1023,2115,115,-1,545,2110,1023,-1,1023,2114,545,-1,253,2113,1023,-1,1023,2110,253,-1,544,2115,1023,-1,1023,2113,544,-1,89,2111,1024,-1,1024,2118,89,-1,545,2116,1024,-1,1024,2111,545,-1,254,2117,1024,-1,1024,2116,254,-1,547,2118,1024,-1,1024,2117,547,-1,115,2119,1025,-1,1025,2114,115,-1,546,2120,1025,-1,1025,2119,546,-1,254,2116,1025,-1,1025,2120,254,-1,545,2114,1025,-1,1025,2116,545,-1,116,2121,1026,-1,1026,2122,116,-1,547,2117,1026,-1,1026,2121,547,-1,254,2120,1026,-1,1026,2117,254,-1,546,2122,1026,-1,1026,2120,546,-1,89,2118,1027,-1,1027,2125,89,-1,547,2123,1027,-1,1027,2118,547,-1,255,2124,1027,-1,1027,2123,255,-1,549,2125,1027,-1,1027,2124,549,-1,116,2126,1028,-1,1028,2121,116,-1,548,2127,1028,-1,1028,2126,548,-1,255,2123,1028,-1,1028,2127,255,-1,547,2121,1028,-1,1028,2123,547,-1,117,2128,1029,-1,1029,2129,117,-1,549,2124,1029,-1,1029,2128,549,-1,255,2127,1029,-1,1029,2124,255,-1,548,2129,1029,-1,1029,2127,548,-1,89,2125,1030,-1,1030,2132,89,-1,549,2130,1030,-1,1030,2125,549,-1,256,2131,1030,-1,1030,2130,256,-1,551,2132,1030,-1,1030,2131,551,-1,117,2133,1031,-1,1031,2128,117,-1,550,2134,1031,-1,1031,2133,550,-1,256,2130,1031,-1,1031,2134,256,-1,549,2128,1031,-1,1031,2130,549,-1,118,2135,1032,-1,1032,2136,118,-1,551,2131,1032,-1,1032,2135,551,-1,256,2134,1032,-1,1032,2131,256,-1,550,2136,1032,-1,1032,2134,550,-1,89,2132,1033,-1,1033,2139,89,-1,551,2137,1033,-1,1033,2132,551,-1,257,2138,1033,-1,1033,2137,257,-1,553,2139,1033,-1,1033,2138,553,-1,118,2140,1034,-1,1034,2135,118,-1,552,2141,1034,-1,1034,2140,552,-1,257,2137,1034,-1,1034,2141,257,-1,551,2135,1034,-1,1034,2137,551,-1,119,2142,1035,-1,1035,2143,119,-1,553,2138,1035,-1,1035,2142,553,-1,257,2141,1035,-1,1035,2138,257,-1,552,2143,1035,-1,1035,2141,552,-1,89,2139,1036,-1,1036,2146,89,-1,553,2144,1036,-1,1036,2139,553,-1,258,2145,1036,-1,1036,2144,258,-1,555,2146,1036,-1,1036,2145,555,-1,119,2147,1037,-1,1037,2142,119,-1,554,2148,1037,-1,1037,2147,554,-1,258,2144,1037,-1,1037,2148,258,-1,553,2142,1037,-1,1037,2144,553,-1,120,2149,1038,-1,1038,2150,120,-1,555,2145,1038,-1,1038,2149,555,-1,258,2148,1038,-1,1038,2145,258,-1,554,2150,1038,-1,1038,2148,554,-1,89,2146,1039,-1,1039,2153,89,-1,555,2151,1039,-1,1039,2146,555,-1,259,2152,1039,-1,1039,2151,259,-1,557,2153,1039,-1,1039,2152,557,-1,120,2154,1040,-1,1040,2149,120,-1,556,2155,1040,-1,1040,2154,556,-1,259,2151,1040,-1,1040,2155,259,-1,555,2149,1040,-1,1040,2151,555,-1,121,2156,1041,-1,1041,2157,121,-1,557,2152,1041,-1,1041,2156,557,-1,259,2155,1041,-1,1041,2152,259,-1,556,2157,1041,-1,1041,2155,556,-1,89,2153,1042,-1,1042,2160,89,-1,557,2158,1042,-1,1042,2153,557,-1,260,2159,1042,-1,1042,2158,260,-1,559,2160,1042,-1,1042,2159,559,-1,121,2161,1043,-1,1043,2156,121,-1,558,2162,1043,-1,1043,2161,558,-1,260,2158,1043,-1,1043,2162,260,-1,557,2156,1043,-1,1043,2158,557,-1,122,2163,1044,-1,1044,2164,122,-1,559,2159,1044,-1,1044,2163,559,-1,260,2162,1044,-1,1044,2159,260,-1,558,2164,1044,-1,1044,2162,558,-1,89,2160,1045,-1,1045,2093,89,-1,559,2165,1045,-1,1045,2160,559,-1,261,2166,1045,-1,1045,2165,261,-1,539,2093,1045,-1,1045,2166,539,-1,122,2167,1046,-1,1046,2163,122,-1,560,2168,1046,-1,1046,2167,560,-1,261,2165,1046,-1,1046,2168,261,-1,559,2163,1046,-1,1046,2165,559,-1,112,2099,1047,-1,1047,2169,112,-1,539,2166,1047,-1,1047,2099,539,-1,261,2168,1047,-1,1047,2166,261,-1,560,2169,1047,-1,1047,2168,560,-1,13,1535,1048,-1,1048,2172,13,-1,387,2170,1048,-1,1048,1535,387,-1,262,2171,1048,-1,1048,2170,262,-1,562,2172,1048,-1,1048,2171,562,-1,12,2173,1049,-1,1049,1529,12,-1,561,2174,1049,-1,1049,2173,561,-1,262,2170,1049,-1,1049,2174,262,-1,387,1529,1049,-1,1049,2170,387,-1,90,1450,1050,-1,1050,2176,90,-1,363,2175,1050,-1,1050,1450,363,-1,262,2174,1050,-1,1050,2175,262,-1,561,2176,1050,-1,1050,2174,561,-1,91,2177,1051,-1,1051,1446,91,-1,562,2171,1051,-1,1051,2177,562,-1,262,2175,1051,-1,1051,2171,262,-1,363,1446,1051,-1,1051,2175,363,-1,14,1546,1052,-1,1052,2180,14,-1,390,2178,1052,-1,1052,1546,390,-1,263,2179,1052,-1,1052,2178,263,-1,563,2180,1052,-1,1052,2179,563,-1,13,2172,1053,-1,1053,1541,13,-1,562,2181,1053,-1,1053,2172,562,-1,263,2178,1053,-1,1053,2181,263,-1,390,1541,1053,-1,1053,2178,390,-1,91,1458,1054,-1,1054,2177,91,-1,366,2182,1054,-1,1054,1458,366,-1,263,2181,1054,-1,1054,2182,263,-1,562,2177,1054,-1,1054,2181,562,-1,92,2183,1055,-1,1055,1455,92,-1,563,2179,1055,-1,1055,2183,563,-1,263,2182,1055,-1,1055,2179,263,-1,366,1455,1055,-1,1055,2182,366,-1,15,1556,1056,-1,1056,2186,15,-1,393,2184,1056,-1,1056,1556,393,-1,264,2185,1056,-1,1056,2184,264,-1,564,2186,1056,-1,1056,2185,564,-1,14,2180,1057,-1,1057,1551,14,-1,563,2187,1057,-1,1057,2180,563,-1,264,2184,1057,-1,1057,2187,264,-1,393,1551,1057,-1,1057,2184,393,-1,92,1466,1058,-1,1058,2183,92,-1,368,2188,1058,-1,1058,1466,368,-1,264,2187,1058,-1,1058,2188,264,-1,563,2183,1058,-1,1058,2187,563,-1,93,2189,1059,-1,1059,1463,93,-1,564,2185,1059,-1,1059,2189,564,-1,264,2188,1059,-1,1059,2185,264,-1,368,1463,1059,-1,1059,2188,368,-1,16,1566,1060,-1,1060,2192,16,-1,396,2190,1060,-1,1060,1566,396,-1,265,2191,1060,-1,1060,2190,265,-1,565,2192,1060,-1,1060,2191,565,-1,15,2186,1061,-1,1061,1561,15,-1,564,2193,1061,-1,1061,2186,564,-1,265,2190,1061,-1,1061,2193,265,-1,396,1561,1061,-1,1061,2190,396,-1,93,1474,1062,-1,1062,2189,93,-1,370,2194,1062,-1,1062,1474,370,-1,265,2193,1062,-1,1062,2194,265,-1,564,2189,1062,-1,1062,2193,564,-1,94,2195,1063,-1,1063,1471,94,-1,565,2191,1063,-1,1063,2195,565,-1,265,2194,1063,-1,1063,2191,265,-1,370,1471,1063,-1,1063,2194,370,-1,17,1576,1064,-1,1064,2198,17,-1,399,2196,1064,-1,1064,1576,399,-1,266,2197,1064,-1,1064,2196,266,-1,566,2198,1064,-1,1064,2197,566,-1,16,2192,1065,-1,1065,1571,16,-1,565,2199,1065,-1,1065,2192,565,-1,266,2196,1065,-1,1065,2199,266,-1,399,1571,1065,-1,1065,2196,399,-1,94,1482,1066,-1,1066,2195,94,-1,372,2200,1066,-1,1066,1482,372,-1,266,2199,1066,-1,1066,2200,266,-1,565,2195,1066,-1,1066,2199,565,-1,95,2201,1067,-1,1067,1479,95,-1,566,2197,1067,-1,1067,2201,566,-1,266,2200,1067,-1,1067,2197,266,-1,372,1479,1067,-1,1067,2200,372,-1,18,1586,1068,-1,1068,2204,18,-1,402,2202,1068,-1,1068,1586,402,-1,267,2203,1068,-1,1068,2202,267,-1,567,2204,1068,-1,1068,2203,567,-1,17,2198,1069,-1,1069,1581,17,-1,566,2205,1069,-1,1069,2198,566,-1,267,2202,1069,-1,1069,2205,267,-1,402,1581,1069,-1,1069,2202,402,-1,95,1490,1070,-1,1070,2201,95,-1,374,2206,1070,-1,1070,1490,374,-1,267,2205,1070,-1,1070,2206,267,-1,566,2201,1070,-1,1070,2205,566,-1,96,2207,1071,-1,1071,1487,96,-1,567,2203,1071,-1,1071,2207,567,-1,267,2206,1071,-1,1071,2203,267,-1,374,1487,1071,-1,1071,2206,374,-1,19,1596,1072,-1,1072,2210,19,-1,405,2208,1072,-1,1072,1596,405,-1,268,2209,1072,-1,1072,2208,268,-1,568,2210,1072,-1,1072,2209,568,-1,18,2204,1073,-1,1073,1591,18,-1,567,2211,1073,-1,1073,2204,567,-1,268,2208,1073,-1,1073,2211,268,-1,405,1591,1073,-1,1073,2208,405,-1,96,1498,1074,-1,1074,2207,96,-1,376,2212,1074,-1,1074,1498,376,-1,268,2211,1074,-1,1074,2212,268,-1,567,2207,1074,-1,1074,2211,567,-1,97,2213,1075,-1,1075,1495,97,-1,568,2209,1075,-1,1075,2213,568,-1,268,2212,1075,-1,1075,2209,268,-1,376,1495,1075,-1,1075,2212,376,-1,20,1606,1076,-1,1076,2216,20,-1,408,2214,1076,-1,1076,1606,408,-1,269,2215,1076,-1,1076,2214,269,-1,569,2216,1076,-1,1076,2215,569,-1,19,2210,1077,-1,1077,1601,19,-1,568,2217,1077,-1,1077,2210,568,-1,269,2214,1077,-1,1077,2217,269,-1,408,1601,1077,-1,1077,2214,408,-1,97,1506,1078,-1,1078,2213,97,-1,378,2218,1078,-1,1078,1506,378,-1,269,2217,1078,-1,1078,2218,269,-1,568,2213,1078,-1,1078,2217,568,-1,98,2219,1079,-1,1079,1503,98,-1,569,2215,1079,-1,1079,2219,569,-1,269,2218,1079,-1,1079,2215,269,-1,378,1503,1079,-1,1079,2218,378,-1,21,1616,1080,-1,1080,2222,21,-1,411,2220,1080,-1,1080,1616,411,-1,270,2221,1080,-1,1080,2220,270,-1,570,2222,1080,-1,1080,2221,570,-1,20,2216,1081,-1,1081,1611,20,-1,569,2223,1081,-1,1081,2216,569,-1,270,2220,1081,-1,1081,2223,270,-1,411,1611,1081,-1,1081,2220,411,-1,98,1514,1082,-1,1082,2219,98,-1,380,2224,1082,-1,1082,1514,380,-1,270,2223,1082,-1,1082,2224,270,-1,569,2219,1082,-1,1082,2223,569,-1,99,2225,1083,-1,1083,1511,99,-1,570,2221,1083,-1,1083,2225,570,-1,270,2224,1083,-1,1083,2221,270,-1,380,1511,1083,-1,1083,2224,380,-1,22,1626,1084,-1,1084,2228,22,-1,414,2226,1084,-1,1084,1626,414,-1,271,2227,1084,-1,1084,2226,271,-1,571,2228,1084,-1,1084,2227,571,-1,21,2222,1085,-1,1085,1621,21,-1,570,2229,1085,-1,1085,2222,570,-1,271,2226,1085,-1,1085,2229,271,-1,414,1621,1085,-1,1085,2226,414,-1,99,1522,1086,-1,1086,2225,99,-1,382,2230,1086,-1,1086,1522,382,-1,271,2229,1086,-1,1086,2230,271,-1,570,2225,1086,-1,1086,2229,570,-1,100,2231,1087,-1,1087,1519,100,-1,571,2227,1087,-1,1087,2231,571,-1,271,2230,1087,-1,1087,2227,271,-1,382,1519,1087,-1,1087,2230,382,-1,12,1635,1088,-1,1088,2173,12,-1,417,2232,1088,-1,1088,1635,417,-1,272,2233,1088,-1,1088,2232,272,-1,561,2173,1088,-1,1088,2233,561,-1,22,2228,1089,-1,1089,1631,22,-1,571,2234,1089,-1,1089,2228,571,-1,272,2232,1089,-1,1089,2234,272,-1,417,1631,1089,-1,1089,2232,417,-1,100,1528,1090,-1,1090,2231,100,-1,384,2235,1090,-1,1090,1528,384,-1,272,2234,1090,-1,1090,2235,272,-1,571,2231,1090,-1,1090,2234,571,-1,90,2176,1091,-1,1091,1526,90,-1,561,2233,1091,-1,1091,2176,561,-1,272,2235,1091,-1,1091,2233,272,-1,384,1526,1091,-1,1091,2235,384,-1,78,2236,1092,-1,1092,2239,78,-1,572,2237,1092,-1,1092,2236,572,-1,273,2238,1092,-1,1092,2237,273,-1,575,2239,1092,-1,1092,2238,575,-1,79,2240,1093,-1,1093,2242,79,-1,573,2241,1093,-1,1093,2240,573,-1,273,2237,1093,-1,1093,2241,273,-1,572,2242,1093,-1,1093,2237,572,-1,102,2243,1094,-1,1094,2245,102,-1,574,2244,1094,-1,1094,2243,574,-1,273,2241,1094,-1,1094,2244,273,-1,573,2245,1094,-1,1094,2241,573,-1,101,2246,1095,-1,1095,2247,101,-1,575,2238,1095,-1,1095,2246,575,-1,273,2244,1095,-1,1095,2238,273,-1,574,2247,1095,-1,1095,2244,574,-1,79,2248,1096,-1,1096,2240,79,-1,576,2249,1096,-1,1096,2248,576,-1,274,2250,1096,-1,1096,2249,274,-1,573,2240,1096,-1,1096,2250,573,-1,80,2251,1097,-1,1097,2253,80,-1,577,2252,1097,-1,1097,2251,577,-1,274,2249,1097,-1,1097,2252,274,-1,576,2253,1097,-1,1097,2249,576,-1,103,2254,1098,-1,1098,2256,103,-1,578,2255,1098,-1,1098,2254,578,-1,274,2252,1098,-1,1098,2255,274,-1,577,2256,1098,-1,1098,2252,577,-1,102,2245,1099,-1,1099,2257,102,-1,573,2250,1099,-1,1099,2245,573,-1,274,2255,1099,-1,1099,2250,274,-1,578,2257,1099,-1,1099,2255,578,-1,80,2258,1100,-1,1100,2251,80,-1,579,2259,1100,-1,1100,2258,579,-1,275,2260,1100,-1,1100,2259,275,-1,577,2251,1100,-1,1100,2260,577,-1,81,2261,1101,-1,1101,2263,81,-1,580,2262,1101,-1,1101,2261,580,-1,275,2259,1101,-1,1101,2262,275,-1,579,2263,1101,-1,1101,2259,579,-1,104,2264,1102,-1,1102,2266,104,-1,581,2265,1102,-1,1102,2264,581,-1,275,2262,1102,-1,1102,2265,275,-1,580,2266,1102,-1,1102,2262,580,-1,103,2256,1103,-1,1103,2267,103,-1,577,2260,1103,-1,1103,2256,577,-1,275,2265,1103,-1,1103,2260,275,-1,581,2267,1103,-1,1103,2265,581,-1,81,2268,1104,-1,1104,2261,81,-1,582,2269,1104,-1,1104,2268,582,-1,276,2270,1104,-1,1104,2269,276,-1,580,2261,1104,-1,1104,2270,580,-1,82,2271,1105,-1,1105,2273,82,-1,583,2272,1105,-1,1105,2271,583,-1,276,2269,1105,-1,1105,2272,276,-1,582,2273,1105,-1,1105,2269,582,-1,105,2274,1106,-1,1106,2276,105,-1,584,2275,1106,-1,1106,2274,584,-1,276,2272,1106,-1,1106,2275,276,-1,583,2276,1106,-1,1106,2272,583,-1,104,2266,1107,-1,1107,2277,104,-1,580,2270,1107,-1,1107,2266,580,-1,276,2275,1107,-1,1107,2270,276,-1,584,2277,1107,-1,1107,2275,584,-1,82,2278,1108,-1,1108,2271,82,-1,585,2279,1108,-1,1108,2278,585,-1,277,2280,1108,-1,1108,2279,277,-1,583,2271,1108,-1,1108,2280,583,-1,83,2281,1109,-1,1109,2283,83,-1,586,2282,1109,-1,1109,2281,586,-1,277,2279,1109,-1,1109,2282,277,-1,585,2283,1109,-1,1109,2279,585,-1,106,2284,1110,-1,1110,2286,106,-1,587,2285,1110,-1,1110,2284,587,-1,277,2282,1110,-1,1110,2285,277,-1,586,2286,1110,-1,1110,2282,586,-1,105,2276,1111,-1,1111,2287,105,-1,583,2280,1111,-1,1111,2276,583,-1,277,2285,1111,-1,1111,2280,277,-1,587,2287,1111,-1,1111,2285,587,-1,83,2288,1112,-1,1112,2281,83,-1,588,2289,1112,-1,1112,2288,588,-1,278,2290,1112,-1,1112,2289,278,-1,586,2281,1112,-1,1112,2290,586,-1,84,2291,1113,-1,1113,2293,84,-1,589,2292,1113,-1,1113,2291,589,-1,278,2289,1113,-1,1113,2292,278,-1,588,2293,1113,-1,1113,2289,588,-1,107,2294,1114,-1,1114,2296,107,-1,590,2295,1114,-1,1114,2294,590,-1,278,2292,1114,-1,1114,2295,278,-1,589,2296,1114,-1,1114,2292,589,-1,106,2286,1115,-1,1115,2297,106,-1,586,2290,1115,-1,1115,2286,586,-1,278,2295,1115,-1,1115,2290,278,-1,590,2297,1115,-1,1115,2295,590,-1,84,2298,1116,-1,1116,2291,84,-1,591,2299,1116,-1,1116,2298,591,-1,279,2300,1116,-1,1116,2299,279,-1,589,2291,1116,-1,1116,2300,589,-1,85,2301,1117,-1,1117,2303,85,-1,592,2302,1117,-1,1117,2301,592,-1,279,2299,1117,-1,1117,2302,279,-1,591,2303,1117,-1,1117,2299,591,-1,108,2304,1118,-1,1118,2306,108,-1,593,2305,1118,-1,1118,2304,593,-1,279,2302,1118,-1,1118,2305,279,-1,592,2306,1118,-1,1118,2302,592,-1,107,2296,1119,-1,1119,2307,107,-1,589,2300,1119,-1,1119,2296,589,-1,279,2305,1119,-1,1119,2300,279,-1,593,2307,1119,-1,1119,2305,593,-1,85,2308,1120,-1,1120,2301,85,-1,594,2309,1120,-1,1120,2308,594,-1,280,2310,1120,-1,1120,2309,280,-1,592,2301,1120,-1,1120,2310,592,-1,86,2311,1121,-1,1121,2313,86,-1,595,2312,1121,-1,1121,2311,595,-1,280,2309,1121,-1,1121,2312,280,-1,594,2313,1121,-1,1121,2309,594,-1,109,2314,1122,-1,1122,2316,109,-1,596,2315,1122,-1,1122,2314,596,-1,280,2312,1122,-1,1122,2315,280,-1,595,2316,1122,-1,1122,2312,595,-1,108,2306,1123,-1,1123,2317,108,-1,592,2310,1123,-1,1123,2306,592,-1,280,2315,1123,-1,1123,2310,280,-1,596,2317,1123,-1,1123,2315,596,-1,86,2318,1124,-1,1124,2311,86,-1,597,2319,1124,-1,1124,2318,597,-1,281,2320,1124,-1,1124,2319,281,-1,595,2311,1124,-1,1124,2320,595,-1,87,2321,1125,-1,1125,2323,87,-1,598,2322,1125,-1,1125,2321,598,-1,281,2319,1125,-1,1125,2322,281,-1,597,2323,1125,-1,1125,2319,597,-1,110,2324,1126,-1,1126,2326,110,-1,599,2325,1126,-1,1126,2324,599,-1,281,2322,1126,-1,1126,2325,281,-1,598,2326,1126,-1,1126,2322,598,-1,109,2316,1127,-1,1127,2327,109,-1,595,2320,1127,-1,1127,2316,595,-1,281,2325,1127,-1,1127,2320,281,-1,599,2327,1127,-1,1127,2325,599,-1,87,2328,1128,-1,1128,2321,87,-1,600,2329,1128,-1,1128,2328,600,-1,282,2330,1128,-1,1128,2329,282,-1,598,2321,1128,-1,1128,2330,598,-1,88,2331,1129,-1,1129,2333,88,-1,601,2332,1129,-1,1129,2331,601,-1,282,2329,1129,-1,1129,2332,282,-1,600,2333,1129,-1,1129,2329,600,-1,111,2334,1130,-1,1130,2336,111,-1,602,2335,1130,-1,1130,2334,602,-1,282,2332,1130,-1,1130,2335,282,-1,601,2336,1130,-1,1130,2332,601,-1,110,2326,1131,-1,1131,2337,110,-1,598,2330,1131,-1,1131,2326,598,-1,282,2335,1131,-1,1131,2330,282,-1,602,2337,1131,-1,1131,2335,602,-1,88,2338,1132,-1,1132,2331,88,-1,603,2339,1132,-1,1132,2338,603,-1,283,2340,1132,-1,1132,2339,283,-1,601,2331,1132,-1,1132,2340,601,-1,78,2239,1133,-1,1133,2342,78,-1,575,2341,1133,-1,1133,2239,575,-1,283,2339,1133,-1,1133,2341,283,-1,603,2342,1133,-1,1133,2339,603,-1,101,2343,1134,-1,1134,2246,101,-1,604,2344,1134,-1,1134,2343,604,-1,283,2341,1134,-1,1134,2344,283,-1,575,2246,1134,-1,1134,2341,575,-1,111,2336,1135,-1,1135,2345,111,-1,601,2340,1135,-1,1135,2336,601,-1,283,2344,1135,-1,1135,2340,283,-1,604,2345,1135,-1,1135,2344,604,-1,101,2247,1136,-1,1136,2348,101,-1,574,2346,1136,-1,1136,2247,574,-1,284,2347,1136,-1,1136,2346,284,-1,606,2348,1136,-1,1136,2347,606,-1,102,2349,1137,-1,1137,2243,102,-1,605,2350,1137,-1,1137,2349,605,-1,284,2346,1137,-1,1137,2350,284,-1,574,2243,1137,-1,1137,2346,574,-1,113,2101,1138,-1,1138,2352,113,-1,540,2351,1138,-1,1138,2101,540,-1,284,2350,1138,-1,1138,2351,284,-1,605,2352,1138,-1,1138,2350,605,-1,112,2353,1139,-1,1139,2097,112,-1,606,2347,1139,-1,1139,2353,606,-1,284,2351,1139,-1,1139,2347,284,-1,540,2097,1139,-1,1139,2351,540,-1,102,2257,1140,-1,1140,2349,102,-1,578,2354,1140,-1,1140,2257,578,-1,285,2355,1140,-1,1140,2354,285,-1,605,2349,1140,-1,1140,2355,605,-1,103,2356,1141,-1,1141,2254,103,-1,607,2357,1141,-1,1141,2356,607,-1,285,2354,1141,-1,1141,2357,285,-1,578,2254,1141,-1,1141,2354,578,-1,114,2108,1142,-1,1142,2359,114,-1,542,2358,1142,-1,1142,2108,542,-1,285,2357,1142,-1,1142,2358,285,-1,607,2359,1142,-1,1142,2357,607,-1,113,2352,1143,-1,1143,2105,113,-1,605,2355,1143,-1,1143,2352,605,-1,285,2358,1143,-1,1143,2355,285,-1,542,2105,1143,-1,1143,2358,542,-1,103,2267,1144,-1,1144,2356,103,-1,581,2360,1144,-1,1144,2267,581,-1,286,2361,1144,-1,1144,2360,286,-1,607,2356,1144,-1,1144,2361,607,-1,104,2362,1145,-1,1145,2264,104,-1,608,2363,1145,-1,1145,2362,608,-1,286,2360,1145,-1,1145,2363,286,-1,581,2264,1145,-1,1145,2360,581,-1,115,2115,1146,-1,1146,2365,115,-1,544,2364,1146,-1,1146,2115,544,-1,286,2363,1146,-1,1146,2364,286,-1,608,2365,1146,-1,1146,2363,608,-1,114,2359,1147,-1,1147,2112,114,-1,607,2361,1147,-1,1147,2359,607,-1,286,2364,1147,-1,1147,2361,286,-1,544,2112,1147,-1,1147,2364,544,-1,104,2277,1148,-1,1148,2362,104,-1,584,2366,1148,-1,1148,2277,584,-1,287,2367,1148,-1,1148,2366,287,-1,608,2362,1148,-1,1148,2367,608,-1,105,2368,1149,-1,1149,2274,105,-1,609,2369,1149,-1,1149,2368,609,-1,287,2366,1149,-1,1149,2369,287,-1,584,2274,1149,-1,1149,2366,584,-1,116,2122,1150,-1,1150,2371,116,-1,546,2370,1150,-1,1150,2122,546,-1,287,2369,1150,-1,1150,2370,287,-1,609,2371,1150,-1,1150,2369,609,-1,115,2365,1151,-1,1151,2119,115,-1,608,2367,1151,-1,1151,2365,608,-1,287,2370,1151,-1,1151,2367,287,-1,546,2119,1151,-1,1151,2370,546,-1,105,2287,1152,-1,1152,2368,105,-1,587,2372,1152,-1,1152,2287,587,-1,288,2373,1152,-1,1152,2372,288,-1,609,2368,1152,-1,1152,2373,609,-1,106,2374,1153,-1,1153,2284,106,-1,610,2375,1153,-1,1153,2374,610,-1,288,2372,1153,-1,1153,2375,288,-1,587,2284,1153,-1,1153,2372,587,-1,117,2129,1154,-1,1154,2377,117,-1,548,2376,1154,-1,1154,2129,548,-1,288,2375,1154,-1,1154,2376,288,-1,610,2377,1154,-1,1154,2375,610,-1,116,2371,1155,-1,1155,2126,116,-1,609,2373,1155,-1,1155,2371,609,-1,288,2376,1155,-1,1155,2373,288,-1,548,2126,1155,-1,1155,2376,548,-1,106,2297,1156,-1,1156,2374,106,-1,590,2378,1156,-1,1156,2297,590,-1,289,2379,1156,-1,1156,2378,289,-1,610,2374,1156,-1,1156,2379,610,-1,107,2380,1157,-1,1157,2294,107,-1,611,2381,1157,-1,1157,2380,611,-1,289,2378,1157,-1,1157,2381,289,-1,590,2294,1157,-1,1157,2378,590,-1,118,2136,1158,-1,1158,2383,118,-1,550,2382,1158,-1,1158,2136,550,-1,289,2381,1158,-1,1158,2382,289,-1,611,2383,1158,-1,1158,2381,611,-1,117,2377,1159,-1,1159,2133,117,-1,610,2379,1159,-1,1159,2377,610,-1,289,2382,1159,-1,1159,2379,289,-1,550,2133,1159,-1,1159,2382,550,-1,107,2307,1160,-1,1160,2380,107,-1,593,2384,1160,-1,1160,2307,593,-1,290,2385,1160,-1,1160,2384,290,-1,611,2380,1160,-1,1160,2385,611,-1,108,2386,1161,-1,1161,2304,108,-1,612,2387,1161,-1,1161,2386,612,-1,290,2384,1161,-1,1161,2387,290,-1,593,2304,1161,-1,1161,2384,593,-1,119,2143,1162,-1,1162,2389,119,-1,552,2388,1162,-1,1162,2143,552,-1,290,2387,1162,-1,1162,2388,290,-1,612,2389,1162,-1,1162,2387,612,-1,118,2383,1163,-1,1163,2140,118,-1,611,2385,1163,-1,1163,2383,611,-1,290,2388,1163,-1,1163,2385,290,-1,552,2140,1163,-1,1163,2388,552,-1,108,2317,1164,-1,1164,2386,108,-1,596,2390,1164,-1,1164,2317,596,-1,291,2391,1164,-1,1164,2390,291,-1,612,2386,1164,-1,1164,2391,612,-1,109,2392,1165,-1,1165,2314,109,-1,613,2393,1165,-1,1165,2392,613,-1,291,2390,1165,-1,1165,2393,291,-1,596,2314,1165,-1,1165,2390,596,-1,120,2150,1166,-1,1166,2395,120,-1,554,2394,1166,-1,1166,2150,554,-1,291,2393,1166,-1,1166,2394,291,-1,613,2395,1166,-1,1166,2393,613,-1,119,2389,1167,-1,1167,2147,119,-1,612,2391,1167,-1,1167,2389,612,-1,291,2394,1167,-1,1167,2391,291,-1,554,2147,1167,-1,1167,2394,554,-1,109,2327,1168,-1,1168,2392,109,-1,599,2396,1168,-1,1168,2327,599,-1,292,2397,1168,-1,1168,2396,292,-1,613,2392,1168,-1,1168,2397,613,-1,110,2398,1169,-1,1169,2324,110,-1,614,2399,1169,-1,1169,2398,614,-1,292,2396,1169,-1,1169,2399,292,-1,599,2324,1169,-1,1169,2396,599,-1,121,2157,1170,-1,1170,2401,121,-1,556,2400,1170,-1,1170,2157,556,-1,292,2399,1170,-1,1170,2400,292,-1,614,2401,1170,-1,1170,2399,614,-1,120,2395,1171,-1,1171,2154,120,-1,613,2397,1171,-1,1171,2395,613,-1,292,2400,1171,-1,1171,2397,292,-1,556,2154,1171,-1,1171,2400,556,-1,110,2337,1172,-1,1172,2398,110,-1,602,2402,1172,-1,1172,2337,602,-1,293,2403,1172,-1,1172,2402,293,-1,614,2398,1172,-1,1172,2403,614,-1,111,2404,1173,-1,1173,2334,111,-1,615,2405,1173,-1,1173,2404,615,-1,293,2402,1173,-1,1173,2405,293,-1,602,2334,1173,-1,1173,2402,602,-1,122,2164,1174,-1,1174,2407,122,-1,558,2406,1174,-1,1174,2164,558,-1,293,2405,1174,-1,1174,2406,293,-1,615,2407,1174,-1,1174,2405,615,-1,121,2401,1175,-1,1175,2161,121,-1,614,2403,1175,-1,1175,2401,614,-1,293,2406,1175,-1,1175,2403,293,-1,558,2161,1175,-1,1175,2406,558,-1,111,2345,1176,-1,1176,2404,111,-1,604,2408,1176,-1,1176,2345,604,-1,294,2409,1176,-1,1176,2408,294,-1,615,2404,1176,-1,1176,2409,615,-1,101,2348,1177,-1,1177,2343,101,-1,606,2410,1177,-1,1177,2348,606,-1,294,2408,1177,-1,1177,2410,294,-1,604,2343,1177,-1,1177,2408,604,-1,112,2169,1178,-1,1178,2353,112,-1,560,2411,1178,-1,1178,2169,560,-1,294,2410,1178,-1,1178,2411,294,-1,606,2353,1178,-1,1178,2410,606,-1,122,2407,1179,-1,1179,2167,122,-1,615,2409,1179,-1,1179,2407,615,-1,294,2411,1179,-1,1179,2409,294,-1,560,2167,1179,-1,1179,2411,560,-1,67,1902,1180,-1,1180,2414,67,-1,483,2412,1180,-1,1180,1902,483,-1,295,2413,1180,-1,1180,2412,295,-1,617,2414,1180,-1,1180,2413,617,-1,68,2415,1181,-1,1181,1898,68,-1,616,2416,1181,-1,1181,2415,616,-1,295,2412,1181,-1,1181,2416,295,-1,483,1898,1181,-1,1181,2412,483,-1,124,1989,1182,-1,1182,2418,124,-1,508,2417,1182,-1,1182,1989,508,-1,295,2416,1182,-1,1182,2417,295,-1,616,2418,1182,-1,1182,2416,616,-1,123,2419,1183,-1,1183,1983,123,-1,617,2413,1183,-1,1183,2419,617,-1,295,2417,1183,-1,1183,2413,295,-1,508,1983,1183,-1,1183,2417,508,-1,68,1910,1184,-1,1184,2415,68,-1,486,2420,1184,-1,1184,1910,486,-1,296,2421,1184,-1,1184,2420,296,-1,616,2415,1184,-1,1184,2421,616,-1,69,2422,1185,-1,1185,1907,69,-1,618,2423,1185,-1,1185,2422,618,-1,296,2420,1185,-1,1185,2423,296,-1,486,1907,1185,-1,1185,2420,486,-1,125,2000,1186,-1,1186,2425,125,-1,511,2424,1186,-1,1186,2000,511,-1,296,2423,1186,-1,1186,2424,296,-1,618,2425,1186,-1,1186,2423,618,-1,124,2418,1187,-1,1187,1995,124,-1,616,2421,1187,-1,1187,2418,616,-1,296,2424,1187,-1,1187,2421,296,-1,511,1995,1187,-1,1187,2424,511,-1,69,1918,1188,-1,1188,2422,69,-1,488,2426,1188,-1,1188,1918,488,-1,297,2427,1188,-1,1188,2426,297,-1,618,2422,1188,-1,1188,2427,618,-1,70,2428,1189,-1,1189,1915,70,-1,619,2429,1189,-1,1189,2428,619,-1,297,2426,1189,-1,1189,2429,297,-1,488,1915,1189,-1,1189,2426,488,-1,126,2010,1190,-1,1190,2431,126,-1,514,2430,1190,-1,1190,2010,514,-1,297,2429,1190,-1,1190,2430,297,-1,619,2431,1190,-1,1190,2429,619,-1,125,2425,1191,-1,1191,2005,125,-1,618,2427,1191,-1,1191,2425,618,-1,297,2430,1191,-1,1191,2427,297,-1,514,2005,1191,-1,1191,2430,514,-1,70,1926,1192,-1,1192,2428,70,-1,490,2432,1192,-1,1192,1926,490,-1,298,2433,1192,-1,1192,2432,298,-1,619,2428,1192,-1,1192,2433,619,-1,71,2434,1193,-1,1193,1923,71,-1,620,2435,1193,-1,1193,2434,620,-1,298,2432,1193,-1,1193,2435,298,-1,490,1923,1193,-1,1193,2432,490,-1,127,2020,1194,-1,1194,2437,127,-1,517,2436,1194,-1,1194,2020,517,-1,298,2435,1194,-1,1194,2436,298,-1,620,2437,1194,-1,1194,2435,620,-1,126,2431,1195,-1,1195,2015,126,-1,619,2433,1195,-1,1195,2431,619,-1,298,2436,1195,-1,1195,2433,298,-1,517,2015,1195,-1,1195,2436,517,-1,71,1934,1196,-1,1196,2434,71,-1,492,2438,1196,-1,1196,1934,492,-1,299,2439,1196,-1,1196,2438,299,-1,620,2434,1196,-1,1196,2439,620,-1,72,2440,1197,-1,1197,1931,72,-1,621,2441,1197,-1,1197,2440,621,-1,299,2438,1197,-1,1197,2441,299,-1,492,1931,1197,-1,1197,2438,492,-1,128,2030,1198,-1,1198,2443,128,-1,520,2442,1198,-1,1198,2030,520,-1,299,2441,1198,-1,1198,2442,299,-1,621,2443,1198,-1,1198,2441,621,-1,127,2437,1199,-1,1199,2025,127,-1,620,2439,1199,-1,1199,2437,620,-1,299,2442,1199,-1,1199,2439,299,-1,520,2025,1199,-1,1199,2442,520,-1,72,1944,1200,-1,1200,2440,72,-1,494,2444,1200,-1,1200,1944,494,-1,300,2445,1200,-1,1200,2444,300,-1,621,2440,1200,-1,1200,2445,621,-1,73,2446,1201,-1,1201,1941,73,-1,622,2447,1201,-1,1201,2446,622,-1,300,2444,1201,-1,1201,2447,300,-1,494,1941,1201,-1,1201,2444,494,-1,129,2040,1202,-1,1202,2449,129,-1,523,2448,1202,-1,1202,2040,523,-1,300,2447,1202,-1,1202,2448,300,-1,622,2449,1202,-1,1202,2447,622,-1,128,2443,1203,-1,1203,2035,128,-1,621,2445,1203,-1,1203,2443,621,-1,300,2448,1203,-1,1203,2445,300,-1,523,2035,1203,-1,1203,2448,523,-1,73,1952,1204,-1,1204,2446,73,-1,497,2450,1204,-1,1204,1952,497,-1,301,2451,1204,-1,1204,2450,301,-1,622,2446,1204,-1,1204,2451,622,-1,74,2452,1205,-1,1205,1949,74,-1,623,2453,1205,-1,1205,2452,623,-1,301,2450,1205,-1,1205,2453,301,-1,497,1949,1205,-1,1205,2450,497,-1,130,2050,1206,-1,1206,2455,130,-1,526,2454,1206,-1,1206,2050,526,-1,301,2453,1206,-1,1206,2454,301,-1,623,2455,1206,-1,1206,2453,623,-1,129,2449,1207,-1,1207,2045,129,-1,622,2451,1207,-1,1207,2449,622,-1,301,2454,1207,-1,1207,2451,301,-1,526,2045,1207,-1,1207,2454,526,-1,74,1960,1208,-1,1208,2452,74,-1,499,2456,1208,-1,1208,1960,499,-1,302,2457,1208,-1,1208,2456,302,-1,623,2452,1208,-1,1208,2457,623,-1,75,2458,1209,-1,1209,1957,75,-1,624,2459,1209,-1,1209,2458,624,-1,302,2456,1209,-1,1209,2459,302,-1,499,1957,1209,-1,1209,2456,499,-1,131,2060,1210,-1,1210,2461,131,-1,529,2460,1210,-1,1210,2060,529,-1,302,2459,1210,-1,1210,2460,302,-1,624,2461,1210,-1,1210,2459,624,-1,130,2455,1211,-1,1211,2055,130,-1,623,2457,1211,-1,1211,2455,623,-1,302,2460,1211,-1,1211,2457,302,-1,529,2055,1211,-1,1211,2460,529,-1,75,1968,1212,-1,1212,2458,75,-1,501,2462,1212,-1,1212,1968,501,-1,303,2463,1212,-1,1212,2462,303,-1,624,2458,1212,-1,1212,2463,624,-1,76,2464,1213,-1,1213,1965,76,-1,625,2465,1213,-1,1213,2464,625,-1,303,2462,1213,-1,1213,2465,303,-1,501,1965,1213,-1,1213,2462,501,-1,132,2070,1214,-1,1214,2467,132,-1,532,2466,1214,-1,1214,2070,532,-1,303,2465,1214,-1,1214,2466,303,-1,625,2467,1214,-1,1214,2465,625,-1,131,2461,1215,-1,1215,2065,131,-1,624,2463,1215,-1,1215,2461,624,-1,303,2466,1215,-1,1215,2463,303,-1,532,2065,1215,-1,1215,2466,532,-1,76,1976,1216,-1,1216,2464,76,-1,503,2468,1216,-1,1216,1976,503,-1,304,2469,1216,-1,1216,2468,304,-1,625,2464,1216,-1,1216,2469,625,-1,77,2470,1217,-1,1217,1973,77,-1,626,2471,1217,-1,1217,2470,626,-1,304,2468,1217,-1,1217,2471,304,-1,503,1973,1217,-1,1217,2468,503,-1,133,2080,1218,-1,1218,2473,133,-1,535,2472,1218,-1,1218,2080,535,-1,304,2471,1218,-1,1218,2472,304,-1,626,2473,1218,-1,1218,2471,626,-1,132,2467,1219,-1,1219,2075,132,-1,625,2469,1219,-1,1219,2467,625,-1,304,2472,1219,-1,1219,2469,304,-1,535,2075,1219,-1,1219,2472,535,-1,77,1982,1220,-1,1220,2470,77,-1,505,2474,1220,-1,1220,1982,505,-1,305,2475,1220,-1,1220,2474,305,-1,626,2470,1220,-1,1220,2475,626,-1,67,2414,1221,-1,1221,1980,67,-1,617,2476,1221,-1,1221,2414,617,-1,305,2474,1221,-1,1221,2476,305,-1,505,1980,1221,-1,1221,2474,505,-1,123,2089,1222,-1,1222,2419,123,-1,538,2477,1222,-1,1222,2089,538,-1,305,2476,1222,-1,1222,2477,305,-1,617,2419,1222,-1,1222,2476,617,-1,133,2473,1223,-1,1223,2085,133,-1,626,2475,1223,-1,1223,2473,626,-1,305,2477,1223,-1,1223,2475,305,-1,538,2085,1223,-1,1223,2477,538,-1,79,2242,1224,-1,1224,2480,79,-1,572,2478,1224,-1,1224,2242,572,-1,306,2479,1224,-1,1224,2478,306,-1,628,2480,1224,-1,1224,2479,628,-1,78,2481,1225,-1,1225,2236,78,-1,627,2482,1225,-1,1225,2481,627,-1,306,2478,1225,-1,1225,2482,306,-1,572,2236,1225,-1,1225,2478,572,-1,134,1994,1226,-1,1226,2484,134,-1,506,2483,1226,-1,1226,1994,506,-1,306,2482,1226,-1,1226,2483,306,-1,627,2484,1226,-1,1226,2482,627,-1,135,2485,1227,-1,1227,1990,135,-1,628,2479,1227,-1,1227,2485,628,-1,306,2483,1227,-1,1227,2479,306,-1,506,1990,1227,-1,1227,2483,506,-1,80,2253,1228,-1,1228,2488,80,-1,576,2486,1228,-1,1228,2253,576,-1,307,2487,1228,-1,1228,2486,307,-1,629,2488,1228,-1,1228,2487,629,-1,79,2480,1229,-1,1229,2248,79,-1,628,2489,1229,-1,1229,2480,628,-1,307,2486,1229,-1,1229,2489,307,-1,576,2248,1229,-1,1229,2486,576,-1,135,2004,1230,-1,1230,2485,135,-1,510,2490,1230,-1,1230,2004,510,-1,307,2489,1230,-1,1230,2490,307,-1,628,2485,1230,-1,1230,2489,628,-1,136,2491,1231,-1,1231,2001,136,-1,629,2487,1231,-1,1231,2491,629,-1,307,2490,1231,-1,1231,2487,307,-1,510,2001,1231,-1,1231,2490,510,-1,81,2263,1232,-1,1232,2494,81,-1,579,2492,1232,-1,1232,2263,579,-1,308,2493,1232,-1,1232,2492,308,-1,630,2494,1232,-1,1232,2493,630,-1,80,2488,1233,-1,1233,2258,80,-1,629,2495,1233,-1,1233,2488,629,-1,308,2492,1233,-1,1233,2495,308,-1,579,2258,1233,-1,1233,2492,579,-1,136,2014,1234,-1,1234,2491,136,-1,513,2496,1234,-1,1234,2014,513,-1,308,2495,1234,-1,1234,2496,308,-1,629,2491,1234,-1,1234,2495,629,-1,137,2497,1235,-1,1235,2011,137,-1,630,2493,1235,-1,1235,2497,630,-1,308,2496,1235,-1,1235,2493,308,-1,513,2011,1235,-1,1235,2496,513,-1,82,2273,1236,-1,1236,2500,82,-1,582,2498,1236,-1,1236,2273,582,-1,309,2499,1236,-1,1236,2498,309,-1,631,2500,1236,-1,1236,2499,631,-1,81,2494,1237,-1,1237,2268,81,-1,630,2501,1237,-1,1237,2494,630,-1,309,2498,1237,-1,1237,2501,309,-1,582,2268,1237,-1,1237,2498,582,-1,137,2024,1238,-1,1238,2497,137,-1,516,2502,1238,-1,1238,2024,516,-1,309,2501,1238,-1,1238,2502,309,-1,630,2497,1238,-1,1238,2501,630,-1,138,2503,1239,-1,1239,2021,138,-1,631,2499,1239,-1,1239,2503,631,-1,309,2502,1239,-1,1239,2499,309,-1,516,2021,1239,-1,1239,2502,516,-1,83,2283,1240,-1,1240,2506,83,-1,585,2504,1240,-1,1240,2283,585,-1,310,2505,1240,-1,1240,2504,310,-1,632,2506,1240,-1,1240,2505,632,-1,82,2500,1241,-1,1241,2278,82,-1,631,2507,1241,-1,1241,2500,631,-1,310,2504,1241,-1,1241,2507,310,-1,585,2278,1241,-1,1241,2504,585,-1,138,2034,1242,-1,1242,2503,138,-1,519,2508,1242,-1,1242,2034,519,-1,310,2507,1242,-1,1242,2508,310,-1,631,2503,1242,-1,1242,2507,631,-1,139,2509,1243,-1,1243,2031,139,-1,632,2505,1243,-1,1243,2509,632,-1,310,2508,1243,-1,1243,2505,310,-1,519,2031,1243,-1,1243,2508,519,-1,84,2293,1244,-1,1244,2512,84,-1,588,2510,1244,-1,1244,2293,588,-1,311,2511,1244,-1,1244,2510,311,-1,633,2512,1244,-1,1244,2511,633,-1,83,2506,1245,-1,1245,2288,83,-1,632,2513,1245,-1,1245,2506,632,-1,311,2510,1245,-1,1245,2513,311,-1,588,2288,1245,-1,1245,2510,588,-1,139,2044,1246,-1,1246,2509,139,-1,522,2514,1246,-1,1246,2044,522,-1,311,2513,1246,-1,1246,2514,311,-1,632,2509,1246,-1,1246,2513,632,-1,140,2515,1247,-1,1247,2041,140,-1,633,2511,1247,-1,1247,2515,633,-1,311,2514,1247,-1,1247,2511,311,-1,522,2041,1247,-1,1247,2514,522,-1,85,2303,1248,-1,1248,2518,85,-1,591,2516,1248,-1,1248,2303,591,-1,312,2517,1248,-1,1248,2516,312,-1,634,2518,1248,-1,1248,2517,634,-1,84,2512,1249,-1,1249,2298,84,-1,633,2519,1249,-1,1249,2512,633,-1,312,2516,1249,-1,1249,2519,312,-1,591,2298,1249,-1,1249,2516,591,-1,140,2054,1250,-1,1250,2515,140,-1,525,2520,1250,-1,1250,2054,525,-1,312,2519,1250,-1,1250,2520,312,-1,633,2515,1250,-1,1250,2519,633,-1,141,2521,1251,-1,1251,2051,141,-1,634,2517,1251,-1,1251,2521,634,-1,312,2520,1251,-1,1251,2517,312,-1,525,2051,1251,-1,1251,2520,525,-1,86,2313,1252,-1,1252,2524,86,-1,594,2522,1252,-1,1252,2313,594,-1,313,2523,1252,-1,1252,2522,313,-1,635,2524,1252,-1,1252,2523,635,-1,85,2518,1253,-1,1253,2308,85,-1,634,2525,1253,-1,1253,2518,634,-1,313,2522,1253,-1,1253,2525,313,-1,594,2308,1253,-1,1253,2522,594,-1,141,2064,1254,-1,1254,2521,141,-1,528,2526,1254,-1,1254,2064,528,-1,313,2525,1254,-1,1254,2526,313,-1,634,2521,1254,-1,1254,2525,634,-1,142,2527,1255,-1,1255,2061,142,-1,635,2523,1255,-1,1255,2527,635,-1,313,2526,1255,-1,1255,2523,313,-1,528,2061,1255,-1,1255,2526,528,-1,87,2323,1256,-1,1256,2530,87,-1,597,2528,1256,-1,1256,2323,597,-1,314,2529,1256,-1,1256,2528,314,-1,636,2530,1256,-1,1256,2529,636,-1,86,2524,1257,-1,1257,2318,86,-1,635,2531,1257,-1,1257,2524,635,-1,314,2528,1257,-1,1257,2531,314,-1,597,2318,1257,-1,1257,2528,597,-1,142,2074,1258,-1,1258,2527,142,-1,531,2532,1258,-1,1258,2074,531,-1,314,2531,1258,-1,1258,2532,314,-1,635,2527,1258,-1,1258,2531,635,-1,143,2533,1259,-1,1259,2071,143,-1,636,2529,1259,-1,1259,2533,636,-1,314,2532,1259,-1,1259,2529,314,-1,531,2071,1259,-1,1259,2532,531,-1,88,2333,1260,-1,1260,2536,88,-1,600,2534,1260,-1,1260,2333,600,-1,315,2535,1260,-1,1260,2534,315,-1,637,2536,1260,-1,1260,2535,637,-1,87,2530,1261,-1,1261,2328,87,-1,636,2537,1261,-1,1261,2530,636,-1,315,2534,1261,-1,1261,2537,315,-1,600,2328,1261,-1,1261,2534,600,-1,143,2084,1262,-1,1262,2533,143,-1,534,2538,1262,-1,1262,2084,534,-1,315,2537,1262,-1,1262,2538,315,-1,636,2533,1262,-1,1262,2537,636,-1,144,2539,1263,-1,1263,2081,144,-1,637,2535,1263,-1,1263,2539,637,-1,315,2538,1263,-1,1263,2535,315,-1,534,2081,1263,-1,1263,2538,534,-1,78,2342,1264,-1,1264,2481,78,-1,603,2540,1264,-1,1264,2342,603,-1,316,2541,1264,-1,1264,2540,316,-1,627,2481,1264,-1,1264,2541,627,-1,88,2536,1265,-1,1265,2338,88,-1,637,2542,1265,-1,1265,2536,637,-1,316,2540,1265,-1,1265,2542,316,-1,603,2338,1265,-1,1265,2540,603,-1,144,2092,1266,-1,1266,2539,144,-1,537,2543,1266,-1,1266,2092,537,-1,316,2542,1266,-1,1266,2543,316,-1,637,2539,1266,-1,1266,2542,637,-1,134,2484,1267,-1,1267,2090,134,-1,627,2541,1267,-1,1267,2484,627,-1,316,2543,1267,-1,1267,2541,316,-1,537,2090,1267,-1,1267,2543,537,-1,50,1772,1268,-1,1268,2546,50,-1,450,2544,1268,-1,1268,1772,450,-1,317,2545,1268,-1,1268,2544,317,-1,640,2546,1268,-1,1268,2545,640,-1,51,2547,1269,-1,1269,1769,51,-1,638,2548,1269,-1,1269,2547,638,-1,317,2544,1269,-1,1269,2548,317,-1,450,1769,1269,-1,1269,2544,450,-1,146,2549,1270,-1,1270,2551,146,-1,639,2550,1270,-1,1270,2549,639,-1,317,2548,1270,-1,1270,2550,317,-1,638,2551,1270,-1,1270,2548,638,-1,145,2552,1271,-1,1271,2553,145,-1,640,2545,1271,-1,1271,2552,640,-1,317,2550,1271,-1,1271,2545,317,-1,639,2553,1271,-1,1271,2550,639,-1,61,1851,1272,-1,1272,2556,61,-1,472,2554,1272,-1,1272,1851,472,-1,318,2555,1272,-1,1272,2554,318,-1,642,2556,1272,-1,1272,2555,642,-1,50,2546,1273,-1,1273,1847,50,-1,640,2557,1273,-1,1273,2546,640,-1,318,2554,1273,-1,1273,2557,318,-1,472,1847,1273,-1,1273,2554,472,-1,145,2558,1274,-1,1274,2552,145,-1,641,2559,1274,-1,1274,2558,641,-1,318,2557,1274,-1,1274,2559,318,-1,640,2552,1274,-1,1274,2557,640,-1,147,2560,1275,-1,1275,2561,147,-1,642,2555,1275,-1,1275,2560,642,-1,318,2559,1275,-1,1275,2555,318,-1,641,2561,1275,-1,1275,2559,641,-1,62,1940,1276,-1,1276,2564,62,-1,495,2562,1276,-1,1276,1940,495,-1,319,2563,1276,-1,1276,2562,319,-1,644,2564,1276,-1,1276,2563,644,-1,61,2556,1277,-1,1277,1935,61,-1,642,2565,1277,-1,1277,2556,642,-1,319,2562,1277,-1,1277,2565,319,-1,495,1935,1277,-1,1277,2562,495,-1,147,2566,1278,-1,1278,2560,147,-1,643,2567,1278,-1,1278,2566,643,-1,319,2565,1278,-1,1278,2567,319,-1,642,2560,1278,-1,1278,2565,642,-1,148,2568,1279,-1,1279,2569,148,-1,644,2563,1279,-1,1279,2568,644,-1,319,2567,1279,-1,1279,2563,319,-1,643,2569,1279,-1,1279,2567,643,-1,51,1855,1280,-1,1280,2547,51,-1,474,2570,1280,-1,1280,1855,474,-1,320,2571,1280,-1,1280,2570,320,-1,638,2547,1280,-1,1280,2571,638,-1,62,2564,1281,-1,1281,1861,62,-1,644,2572,1281,-1,1281,2564,644,-1,320,2570,1281,-1,1281,2572,320,-1,474,1861,1281,-1,1281,2570,474,-1,148,2573,1282,-1,1282,2568,148,-1,645,2574,1282,-1,1282,2573,645,-1,320,2572,1282,-1,1282,2574,320,-1,644,2568,1282,-1,1282,2572,644,-1,146,2551,1283,-1,1283,2575,146,-1,638,2571,1283,-1,1283,2551,638,-1,320,2574,1283,-1,1283,2571,320,-1,645,2575,1283,-1,1283,2574,645,-1,148,2569,1284,-1,1284,2578,148,-1,643,2576,1284,-1,1284,2569,643,-1,321,2577,1284,-1,1284,2576,321,-1,648,2578,1284,-1,1284,2577,648,-1,147,2579,1285,-1,1285,2566,147,-1,646,2580,1285,-1,1285,2579,646,-1,321,2576,1285,-1,1285,2580,321,-1,643,2566,1285,-1,1285,2576,643,-1,151,2581,1286,-1,1286,2583,151,-1,647,2582,1286,-1,1286,2581,647,-1,321,2580,1286,-1,1286,2582,321,-1,646,2583,1286,-1,1286,2580,646,-1,152,2584,1287,-1,1287,2585,152,-1,648,2577,1287,-1,1287,2584,648,-1,321,2582,1287,-1,1287,2577,321,-1,647,2585,1287,-1,1287,2582,647,-1,147,2561,1288,-1,1288,2579,147,-1,641,2586,1288,-1,1288,2561,641,-1,322,2587,1288,-1,1288,2586,322,-1,646,2579,1288,-1,1288,2587,646,-1,145,2588,1289,-1,1289,2558,145,-1,649,2589,1289,-1,1289,2588,649,-1,322,2586,1289,-1,1289,2589,322,-1,641,2558,1289,-1,1289,2586,641,-1,149,2590,1290,-1,1290,2592,149,-1,650,2591,1290,-1,1290,2590,650,-1,322,2589,1290,-1,1290,2591,322,-1,649,2592,1290,-1,1290,2589,649,-1,151,2583,1291,-1,1291,2593,151,-1,646,2587,1291,-1,1291,2583,646,-1,322,2591,1291,-1,1291,2587,322,-1,650,2593,1291,-1,1291,2591,650,-1,145,2553,1292,-1,1292,2588,145,-1,639,2594,1292,-1,1292,2553,639,-1,323,2595,1292,-1,1292,2594,323,-1,649,2588,1292,-1,1292,2595,649,-1,146,2596,1293,-1,1293,2549,146,-1,651,2597,1293,-1,1293,2596,651,-1,323,2594,1293,-1,1293,2597,323,-1,639,2549,1293,-1,1293,2594,639,-1,150,2598,1294,-1,1294,2600,150,-1,652,2599,1294,-1,1294,2598,652,-1,323,2597,1294,-1,1294,2599,323,-1,651,2600,1294,-1,1294,2597,651,-1,149,2592,1295,-1,1295,2601,149,-1,649,2595,1295,-1,1295,2592,649,-1,323,2599,1295,-1,1295,2595,323,-1,652,2601,1295,-1,1295,2599,652,-1,146,2575,1296,-1,1296,2596,146,-1,645,2602,1296,-1,1296,2575,645,-1,324,2603,1296,-1,1296,2602,324,-1,651,2596,1296,-1,1296,2603,651,-1,148,2578,1297,-1,1297,2573,148,-1,648,2604,1297,-1,1297,2578,648,-1,324,2602,1297,-1,1297,2604,324,-1,645,2573,1297,-1,1297,2602,645,-1,152,2605,1298,-1,1298,2584,152,-1,653,2606,1298,-1,1298,2605,653,-1,324,2604,1298,-1,1298,2606,324,-1,648,2584,1298,-1,1298,2604,648,-1,150,2600,1299,-1,1299,2607,150,-1,651,2603,1299,-1,1299,2600,651,-1,324,2606,1299,-1,1299,2603,324,-1,653,2607,1299,-1,1299,2606,653,-1,28,1590,1300,-1,1300,2610,28,-1,401,2608,1300,-1,1300,1590,401,-1,325,2609,1300,-1,1300,2608,325,-1,656,2610,1300,-1,1300,2609,656,-1,29,2611,1301,-1,1301,1587,29,-1,654,2612,1301,-1,1301,2611,654,-1,325,2608,1301,-1,1301,2612,325,-1,401,1587,1301,-1,1301,2608,401,-1,154,2613,1302,-1,1302,2615,154,-1,655,2614,1302,-1,1302,2613,655,-1,325,2612,1302,-1,1302,2614,325,-1,654,2615,1302,-1,1302,2612,654,-1,153,2616,1303,-1,1303,2617,153,-1,656,2609,1303,-1,1303,2616,656,-1,325,2614,1303,-1,1303,2609,325,-1,655,2617,1303,-1,1303,2614,655,-1,39,1679,1304,-1,1304,2620,39,-1,428,2618,1304,-1,1304,1679,428,-1,326,2619,1304,-1,1304,2618,326,-1,658,2620,1304,-1,1304,2619,658,-1,28,2610,1305,-1,1305,1675,28,-1,656,2621,1305,-1,1305,2610,656,-1,326,2618,1305,-1,1305,2621,326,-1,428,1675,1305,-1,1305,2618,428,-1,153,2622,1306,-1,1306,2616,153,-1,657,2623,1306,-1,1306,2622,657,-1,326,2621,1306,-1,1306,2623,326,-1,656,2616,1306,-1,1306,2621,656,-1,155,2624,1307,-1,1307,2625,155,-1,658,2619,1307,-1,1307,2624,658,-1,326,2623,1307,-1,1307,2619,326,-1,657,2625,1307,-1,1307,2623,657,-1,40,1768,1308,-1,1308,2628,40,-1,451,2626,1308,-1,1308,1768,451,-1,327,2627,1308,-1,1308,2626,327,-1,660,2628,1308,-1,1308,2627,660,-1,39,2620,1309,-1,1309,1763,39,-1,658,2629,1309,-1,1309,2620,658,-1,327,2626,1309,-1,1309,2629,327,-1,451,1763,1309,-1,1309,2626,451,-1,155,2630,1310,-1,1310,2624,155,-1,659,2631,1310,-1,1310,2630,659,-1,327,2629,1310,-1,1310,2631,327,-1,658,2624,1310,-1,1310,2629,658,-1,156,2632,1311,-1,1311,2633,156,-1,660,2627,1311,-1,1311,2632,660,-1,327,2631,1311,-1,1311,2627,327,-1,659,2633,1311,-1,1311,2631,659,-1,29,1683,1312,-1,1312,2611,29,-1,430,2634,1312,-1,1312,1683,430,-1,328,2635,1312,-1,1312,2634,328,-1,654,2611,1312,-1,1312,2635,654,-1,40,2628,1313,-1,1313,1689,40,-1,660,2636,1313,-1,1313,2628,660,-1,328,2634,1313,-1,1313,2636,328,-1,430,1689,1313,-1,1313,2634,430,-1,156,2637,1314,-1,1314,2632,156,-1,661,2638,1314,-1,1314,2637,661,-1,328,2636,1314,-1,1314,2638,328,-1,660,2632,1314,-1,1314,2636,660,-1,154,2615,1315,-1,1315,2639,154,-1,654,2635,1315,-1,1315,2615,654,-1,328,2638,1315,-1,1315,2635,328,-1,661,2639,1315,-1,1315,2638,661,-1,156,2633,1316,-1,1316,2642,156,-1,659,2640,1316,-1,1316,2633,659,-1,329,2641,1316,-1,1316,2640,329,-1,664,2642,1316,-1,1316,2641,664,-1,155,2643,1317,-1,1317,2630,155,-1,662,2644,1317,-1,1317,2643,662,-1,329,2640,1317,-1,1317,2644,329,-1,659,2630,1317,-1,1317,2640,659,-1,159,2645,1318,-1,1318,2647,159,-1,663,2646,1318,-1,1318,2645,663,-1,329,2644,1318,-1,1318,2646,329,-1,662,2647,1318,-1,1318,2644,662,-1,160,2648,1319,-1,1319,2649,160,-1,664,2641,1319,-1,1319,2648,664,-1,329,2646,1319,-1,1319,2641,329,-1,663,2649,1319,-1,1319,2646,663,-1,155,2625,1320,-1,1320,2643,155,-1,657,2650,1320,-1,1320,2625,657,-1,330,2651,1320,-1,1320,2650,330,-1,662,2643,1320,-1,1320,2651,662,-1,153,2652,1321,-1,1321,2622,153,-1,665,2653,1321,-1,1321,2652,665,-1,330,2650,1321,-1,1321,2653,330,-1,657,2622,1321,-1,1321,2650,657,-1,157,2654,1322,-1,1322,2656,157,-1,666,2655,1322,-1,1322,2654,666,-1,330,2653,1322,-1,1322,2655,330,-1,665,2656,1322,-1,1322,2653,665,-1,159,2647,1323,-1,1323,2657,159,-1,662,2651,1323,-1,1323,2647,662,-1,330,2655,1323,-1,1323,2651,330,-1,666,2657,1323,-1,1323,2655,666,-1,153,2617,1324,-1,1324,2652,153,-1,655,2658,1324,-1,1324,2617,655,-1,331,2659,1324,-1,1324,2658,331,-1,665,2652,1324,-1,1324,2659,665,-1,154,2660,1325,-1,1325,2613,154,-1,667,2661,1325,-1,1325,2660,667,-1,331,2658,1325,-1,1325,2661,331,-1,655,2613,1325,-1,1325,2658,655,-1,158,2662,1326,-1,1326,2664,158,-1,668,2663,1326,-1,1326,2662,668,-1,331,2661,1326,-1,1326,2663,331,-1,667,2664,1326,-1,1326,2661,667,-1,157,2656,1327,-1,1327,2665,157,-1,665,2659,1327,-1,1327,2656,665,-1,331,2663,1327,-1,1327,2659,331,-1,668,2665,1327,-1,1327,2663,668,-1,154,2639,1328,-1,1328,2660,154,-1,661,2666,1328,-1,1328,2639,661,-1,332,2667,1328,-1,1328,2666,332,-1,667,2660,1328,-1,1328,2667,667,-1,156,2642,1329,-1,1329,2637,156,-1,664,2668,1329,-1,1329,2642,664,-1,332,2666,1329,-1,1329,2668,332,-1,661,2637,1329,-1,1329,2666,661,-1,160,2669,1330,-1,1330,2648,160,-1,669,2670,1330,-1,1330,2669,669,-1,332,2668,1330,-1,1330,2670,332,-1,664,2648,1330,-1,1330,2668,664,-1,158,2664,1331,-1,1331,2671,158,-1,667,2667,1331,-1,1331,2664,667,-1,332,2670,1331,-1,1331,2667,332,-1,669,2671,1331,-1,1331,2670,669,-1,160,2649,1332,-1,1332,2674,160,-1,663,2672,1332,-1,1332,2649,663,-1,333,2673,1332,-1,1332,2672,333,-1,672,2674,1332,-1,1332,2673,672,-1,159,2675,1333,-1,1333,2645,159,-1,670,2676,1333,-1,1333,2675,670,-1,333,2672,1333,-1,1333,2676,333,-1,663,2645,1333,-1,1333,2672,663,-1,161,2677,1334,-1,1334,2679,161,-1,671,2678,1334,-1,1334,2677,671,-1,333,2676,1334,-1,1334,2678,333,-1,670,2679,1334,-1,1334,2676,670,-1,162,2680,1335,-1,1335,2681,162,-1,672,2673,1335,-1,1335,2680,672,-1,333,2678,1335,-1,1335,2673,333,-1,671,2681,1335,-1,1335,2678,671,-1,159,2657,1336,-1,1336,2675,159,-1,666,2682,1336,-1,1336,2657,666,-1,334,2683,1336,-1,1336,2682,334,-1,670,2675,1336,-1,1336,2683,670,-1,157,2684,1337,-1,1337,2654,157,-1,673,2685,1337,-1,1337,2684,673,-1,334,2682,1337,-1,1337,2685,334,-1,666,2654,1337,-1,1337,2682,666,-1,163,2686,1338,-1,1338,2688,163,-1,674,2687,1338,-1,1338,2686,674,-1,334,2685,1338,-1,1338,2687,334,-1,673,2688,1338,-1,1338,2685,673,-1,161,2679,1339,-1,1339,2689,161,-1,670,2683,1339,-1,1339,2679,670,-1,334,2687,1339,-1,1339,2683,334,-1,674,2689,1339,-1,1339,2687,674,-1,157,2665,1340,-1,1340,2684,157,-1,668,2690,1340,-1,1340,2665,668,-1,335,2691,1340,-1,1340,2690,335,-1,673,2684,1340,-1,1340,2691,673,-1,158,2692,1341,-1,1341,2662,158,-1,675,2693,1341,-1,1341,2692,675,-1,335,2690,1341,-1,1341,2693,335,-1,668,2662,1341,-1,1341,2690,668,-1,164,2694,1342,-1,1342,2696,164,-1,676,2695,1342,-1,1342,2694,676,-1,335,2693,1342,-1,1342,2695,335,-1,675,2696,1342,-1,1342,2693,675,-1,163,2688,1343,-1,1343,2697,163,-1,673,2691,1343,-1,1343,2688,673,-1,335,2695,1343,-1,1343,2691,335,-1,676,2697,1343,-1,1343,2695,676,-1,158,2671,1344,-1,1344,2692,158,-1,669,2698,1344,-1,1344,2671,669,-1,336,2699,1344,-1,1344,2698,336,-1,675,2692,1344,-1,1344,2699,675,-1,160,2674,1345,-1,1345,2669,160,-1,672,2700,1345,-1,1345,2674,672,-1,336,2698,1345,-1,1345,2700,336,-1,669,2669,1345,-1,1345,2698,669,-1,162,2701,1346,-1,1346,2680,162,-1,677,2702,1346,-1,1346,2701,677,-1,336,2700,1346,-1,1346,2702,336,-1,672,2680,1346,-1,1346,2700,672,-1,164,2696,1347,-1,1347,2703,164,-1,675,2699,1347,-1,1347,2696,675,-1,336,2702,1347,-1,1347,2699,336,-1,677,2703,1347,-1,1347,2702,677,-1,152,2585,1348,-1,1348,2706,152,-1,647,2704,1348,-1,1348,2585,647,-1,337,2705,1348,-1,1348,2704,337,-1,679,2706,1348,-1,1348,2705,679,-1,151,2707,1349,-1,1349,2581,151,-1,678,2708,1349,-1,1349,2707,678,-1,337,2704,1349,-1,1349,2708,337,-1,647,2581,1349,-1,1349,2704,647,-1,163,2697,1350,-1,1350,2710,163,-1,676,2709,1350,-1,1350,2697,676,-1,337,2708,1350,-1,1350,2709,337,-1,678,2710,1350,-1,1350,2708,678,-1,164,2711,1351,-1,1351,2694,164,-1,679,2705,1351,-1,1351,2711,679,-1,337,2709,1351,-1,1351,2705,337,-1,676,2694,1351,-1,1351,2709,676,-1,151,2593,1352,-1,1352,2707,151,-1,650,2712,1352,-1,1352,2593,650,-1,338,2713,1352,-1,1352,2712,338,-1,678,2707,1352,-1,1352,2713,678,-1,149,2714,1353,-1,1353,2590,149,-1,680,2715,1353,-1,1353,2714,680,-1,338,2712,1353,-1,1353,2715,338,-1,650,2590,1353,-1,1353,2712,650,-1,161,2689,1354,-1,1354,2717,161,-1,674,2716,1354,-1,1354,2689,674,-1,338,2715,1354,-1,1354,2716,338,-1,680,2717,1354,-1,1354,2715,680,-1,163,2710,1355,-1,1355,2686,163,-1,678,2713,1355,-1,1355,2710,678,-1,338,2716,1355,-1,1355,2713,338,-1,674,2686,1355,-1,1355,2716,674,-1,149,2601,1356,-1,1356,2714,149,-1,652,2718,1356,-1,1356,2601,652,-1,339,2719,1356,-1,1356,2718,339,-1,680,2714,1356,-1,1356,2719,680,-1,150,2720,1357,-1,1357,2598,150,-1,681,2721,1357,-1,1357,2720,681,-1,339,2718,1357,-1,1357,2721,339,-1,652,2598,1357,-1,1357,2718,652,-1,162,2681,1358,-1,1358,2723,162,-1,671,2722,1358,-1,1358,2681,671,-1,339,2721,1358,-1,1358,2722,339,-1,681,2723,1358,-1,1358,2721,681,-1,161,2717,1359,-1,1359,2677,161,-1,680,2719,1359,-1,1359,2717,680,-1,339,2722,1359,-1,1359,2719,339,-1,671,2677,1359,-1,1359,2722,671,-1,150,2607,1360,-1,1360,2720,150,-1,653,2724,1360,-1,1360,2607,653,-1,340,2725,1360,-1,1360,2724,340,-1,681,2720,1360,-1,1360,2725,681,-1,152,2706,1361,-1,1361,2605,152,-1,679,2726,1361,-1,1361,2706,679,-1,340,2724,1361,-1,1361,2726,340,-1,653,2605,1361,-1,1361,2724,653,-1,164,2703,1362,-1,1362,2711,164,-1,677,2727,1362,-1,1362,2703,677,-1,340,2726,1362,-1,1362,2727,340,-1,679,2711,1362,-1,1362,2726,679,-1,162,2723,1363,-1,1363,2701,162,-1,681,2725,1363,-1,1363,2723,681,-1,340,2727,1363,-1,1363,2725,340,-1,677,2701,1363,-1,1363,2727,677,-1],
          coord=Coordinate(point=[(0,-3,0),(19.61,-3,0),(16.49,-3,-10.6),(8.145,-3,-17.84),(-2.79,-3,-19.41),(-12.84,-3,-14.82),(-18.81,-3,-5.524),(-18.81,-3,5.524),(-12.84,-3,14.82),(-2.79,-3,19.41),(8.145,-3,17.84),(16.49,-3,10.6),(38.02,2.031,0),(31.98,2.031,-20.55),(15.79,2.031,-34.58),(-5.41,2.031,-37.63),(-24.89,2.031,-28.73),(-36.48,2.031,-10.71),(-36.48,2.031,10.71),(-24.89,2.031,28.73),(-5.41,2.031,37.63),(15.79,2.031,34.58),(31.98,2.031,20.55),(38.02,14.06,0),(31.98,14.06,-20.55),(15.79,14.06,-34.58),(-5.41,14.06,-37.63),(-24.89,14.06,-28.73),(-38.24,14.71,-10.89),(-38.24,14.71,10.89),(-24.89,14.06,28.73),(-5.41,14.06,37.63),(15.79,14.06,34.58),(31.98,14.06,20.55),(38.02,25.41,0),(31.98,25.41,-20.55),(15.79,25.41,-34.58),(-5.41,25.41,-37.63),(-24.89,25.41,-28.73),(-38.05,23.54,-10.89),(-38.05,23.54,10.89),(-24.89,25.41,28.73),(-5.41,25.41,37.63),(15.79,25.41,34.58),(31.98,25.41,20.55),(38.02,54.59,0),(31.98,54.59,-20.55),(15.79,54.59,-34.58),(-5.41,54.59,-37.63),(-24.89,54.59,-28.73),(-38.05,56.46,-10.89),(-38.05,56.46,10.89),(-24.89,54.59,28.73),(-5.41,54.59,37.63),(15.79,54.59,34.58),(31.98,54.59,20.55),(38.02,65.94,0),(31.98,65.94,-20.55),(15.79,65.94,-34.58),(-5.41,65.94,-37.63),(-24.89,65.94,-28.73),(-38.24,65.29,-10.89),(-38.24,65.29,10.89),(-24.89,65.94,28.73),(-5.41,65.94,37.63),(15.79,65.94,34.58),(31.98,65.94,20.55),(38.65,77.97,0),(32.51,77.97,-20.89),(16.05,77.97,-35.16),(-5.5,77.97,-38.25),(-25.31,77.97,-29.21),(-37.08,77.97,-10.89),(-37.08,77.97,10.89),(-25.31,77.97,29.21),(-5.5,77.97,38.25),(16.05,77.97,35.16),(32.51,77.97,20.89),(34.65,68.75,0),(29.15,68.75,-18.74),(14.4,68.75,-31.52),(-4.932,68.75,-34.3),(-22.69,68.75,-26.19),(-33.25,68.75,-9.763),(-33.25,68.75,9.763),(-22.69,68.75,26.19),(-4.932,68.75,34.3),(14.4,68.75,31.52),(29.15,68.75,18.74),(0,2,0),(35.05,-2.531,0),(29.48,-2.531,-18.95),(14.56,-2.531,-31.88),(-4.988,-2.531,-34.69),(-22.95,-2.531,-26.49),(-33.63,-2.531,-9.874),(-33.63,-2.531,9.874),(-22.95,-2.531,26.49),(-4.988,-2.531,34.69),(14.56,-2.531,31.88),(29.48,-2.531,18.95),(34.09,16.25,0),(28.68,16.25,-18.43),(14.16,16.25,-31.01),(-4.851,16.25,-33.74),(-22.32,16.25,-25.76),(-32.71,16.25,-9.604),(-32.71,16.25,9.604),(-22.32,16.25,25.76),(-4.851,16.25,33.74),(14.16,16.25,31.01),(28.68,16.25,18.43),(29.84,2.469,0),(25.1,2.469,-16.13),(12.39,2.469,-27.14),(-4.246,2.469,-29.53),(-19.54,2.469,-22.55),(-28.63,2.469,-8.406),(-28.63,2.469,8.406),(-19.54,2.469,22.55),(-4.246,2.469,29.53),(12.39,2.469,27.14),(25.1,2.469,16.13),(40.75,82.53,0),(34.28,82.53,-22.03),(16.93,82.53,-37.07),(-5.799,82.53,-40.34),(-26.69,82.53,-30.8),(-39.1,82.53,-11.48),(-39.1,82.53,11.48),(-26.69,82.53,30.8),(-5.799,82.53,40.34),(16.93,82.53,37.07),(34.28,82.53,22.03),(37.83,82.53,0),(31.82,82.53,-20.45),(15.71,82.53,-34.41),(-5.383,82.53,-37.44),(-24.77,82.53,-28.59),(-36.3,82.53,-10.66),(-36.3,82.53,10.66),(-24.77,82.53,28.59),(-5.383,82.53,37.44),(15.71,82.53,34.41),(31.82,82.53,20.45),(-47.13,60.3,-7.748),(-47.13,60.3,7.748),(-48.72,61.89,-7.748),(-48.72,61.89,7.748),(-53.44,53.74,-7.451),(-53.44,53.74,7.451),(-55.79,54.01,-7.451),(-55.79,54.01,7.451),(-48.72,18.11,-7.748),(-48.72,18.11,7.748),(-47.13,19.7,-7.748),(-47.13,19.7,7.748),(-55.79,25.99,-7.451),(-55.79,25.99,7.451),(-53.44,26.26,-7.451),(-53.44,26.26,7.451),(-55.4,40,-6.442),(-55.4,40,6.442),(-57.87,40,-6.442),(-57.87,40,6.442),(12.73,-3,-3.738),(8.689,-3,-10.03),(1.888,-3,-13.13),(-5.512,-3,-12.07),(-11.16,-3,-7.173),(-13.27,-3,0),(-11.16,-3,7.173),(-5.512,-3,12.07),(1.888,-3,13.13),(8.689,-3,10.03),(12.73,-3,3.738),(27.14,-2.953,-7.97),(18.53,-2.953,-21.38),(4.026,-2.953,-28),(-11.75,-2.953,-25.73),(-23.8,-2.953,-15.29),(-28.29,-2.953,0),(-23.8,-2.953,15.29),(-11.75,-2.953,25.73),(4.026,-2.953,28),(18.53,-2.953,21.38),(27.14,-2.953,7.97),(36.46,8.009,-10.71),(24.88,8.009,-28.72),(5.408,8.009,-37.61),(-15.79,8.009,-34.57),(-31.99,8.018,-20.55),(-38.18,7.992,0),(-31.99,8.018,20.55),(-15.79,8.009,34.57),(5.408,8.009,37.61),(24.88,8.009,28.72),(36.46,8.009,10.71),(36.46,18.18,-10.71),(24.88,18.18,-28.72),(5.408,18.18,-37.61),(-15.79,18.18,-34.57),(-32.13,18.17,-20.81),(-32.13,18.17,20.81),(-15.79,18.18,34.57),(5.408,18.18,37.61),(24.88,18.18,28.72),(36.46,18.18,10.71),(36.46,40,-10.71),(24.88,40,-28.72),(5.408,40,-37.61),(-15.79,40,-34.57),(-32.01,40,-20.55),(-38.28,40,0),(-32.01,40,20.55),(-15.79,40,34.57),(5.408,40,37.61),(24.88,40,28.72),(36.46,40,10.71),(36.46,61.82,-10.71),(24.88,61.82,-28.72),(5.408,61.82,-37.61),(-15.79,61.82,-34.57),(-32.13,61.83,-20.81),(-32.13,61.83,20.81),(-15.79,61.82,34.57),(5.408,61.82,37.61),(24.88,61.82,28.72),(36.46,61.82,10.71),(36.52,71.99,-10.72),(24.93,71.99,-28.77),(5.417,71.99,-37.67),(-15.81,71.99,-34.62),(-32.04,71.98,-20.58),(-38.24,72.01,0),(-32.04,71.98,20.58),(-15.81,71.99,34.62),(5.417,71.99,37.67),(24.93,71.99,28.77),(36.52,71.99,10.72),(38.14,82.91,-11.2),(26.03,82.91,-30.04),(5.657,82.91,-39.35),(-16.51,82.91,-36.16),(-33.44,82.91,-21.49),(-39.75,82.91,0),(-33.44,82.91,21.49),(-16.51,82.91,36.16),(5.657,82.91,39.35),(26.03,82.91,30.04),(38.14,82.91,11.2),(21.92,2.083,-6.437),(14.96,2.083,-17.27),(3.252,2.083,-22.62),(-9.492,2.083,-20.78),(-19.22,2.083,-12.35),(-22.85,2.083,0),(-19.22,2.083,12.35),(-9.492,2.083,20.78),(3.252,2.083,22.62),(14.96,2.083,17.27),(21.92,2.083,6.437),(36.17,-1.25,-10.62),(24.69,-1.25,-28.49),(5.366,-1.25,-37.32),(-15.66,-1.25,-34.29),(-31.72,-1.25,-20.38),(-37.7,-1.25,0),(-31.72,-1.25,20.38),(-15.66,-1.25,34.3),(5.366,-1.25,37.32),(24.69,-1.25,28.49),(36.17,-1.25,10.62),(32.75,42.5,-9.615),(22.35,42.5,-25.79),(4.857,42.5,-33.78),(-14.18,42.5,-31.05),(-28.71,42.5,-18.45),(-34.13,42.5,0),(-28.71,42.5,18.45),(-14.18,42.5,31.05),(4.857,42.5,33.78),(22.35,42.5,25.79),(32.75,42.5,9.615),(32.33,4.672,-9.493),(22.07,4.672,-25.47),(4.795,4.672,-33.35),(-14,4.672,-30.65),(-28.35,4.672,-18.22),(-33.7,4.672,0),(-28.35,4.672,18.22),(-14,4.672,30.65),(4.795,4.672,33.35),(22.07,4.672,25.47),(32.33,4.672,9.493),(38.33,81.25,-11.26),(26.16,81.25,-30.19),(5.686,81.25,-39.55),(-16.6,81.25,-36.34),(-33.61,81.25,-21.6),(-39.95,81.25,0),(-33.61,81.25,21.6),(-16.6,81.25,36.34),(5.686,81.25,39.55),(26.16,81.25,30.19),(38.33,81.25,11.26),(34.5,80.33,-10.13),(23.54,80.33,-27.17),(5.117,80.33,-35.59),(-14.94,80.33,-32.7),(-30.25,80.33,-19.44),(-35.95,80.33,0),(-30.25,80.33,19.44),(-14.94,80.33,32.7),(5.117,80.33,35.59),(23.54,80.33,27.17),(34.5,80.33,10.13),(-42.84,60.09,1.1e-005),(-43.3,62.06,-10.87),(-44.05,63.75,1.004e-005),(-43.3,62.06,10.87),(-53.21,59.03,1.332e-005),(-51.79,58.43,-10.52),(-50.37,57.83,1.431e-005),(-51.79,58.43,10.52),(-44.05,16.25,1.004e-005),(-43.3,17.94,-10.87),(-42.84,19.91,1.004e-005),(-43.3,17.94,10.87),(-50.37,22.17,1.332e-005),(-51.79,21.57,-10.52),(-53.21,20.97,1.338e-005),(-51.79,21.57,10.52),(-54.5,32.58,1.776e-005),(-56.17,32.56,-9.31),(-57.85,32.54,1.729e-005),(-56.17,32.56,9.311),(-57.85,47.46,1.73e-005),(-56.17,47.44,-9.31),(-54.5,47.42,1.821e-005),(-56.17,47.44,9.311),(9.502,-3,-6.107),(19.06,-3,-5.596),(11.3,-3,0),(4.692,-3,-10.27),(13.01,-3,-15.01),(-1.607,-3,-11.18),(2.827,-3,-19.66),(-7.397,-3,-8.536),(-8.252,-3,-18.07),(-10.84,-3,-3.182),(-16.71,-3,-10.74),(-10.84,-3,3.182),(-19.86,-3,0),(-7.397,-3,8.536),(-16.71,-3,10.74),(-1.607,-3,11.18),(-8.252,-3,18.07),(4.692,-3,10.27),(2.827,-3,19.66),(9.502,-3,6.107),(13.01,-3,15.01),(19.06,-3,5.596),(33.61,-2.531,-9.869),(28.27,-2.953,0),(23.79,-2.953,-15.29),(22.94,-2.531,-26.47),(11.75,-2.953,-25.72),(4.985,-2.531,-34.67),(-4.024,-2.953,-27.99),(-14.55,-2.531,-31.86),(-18.52,-2.953,-21.37),(-29.47,-2.531,-18.94),(-27.13,-2.953,-7.966),(-35.03,-2.531,0),(-27.13,-2.953,7.966),(-29.47,-2.531,18.94),(-18.52,-2.953,21.37),(-14.55,-2.531,31.86),(-4.024,-2.953,27.99),(4.985,-2.531,34.67),(11.75,-2.953,25.72),(22.94,-2.531,26.47),(23.79,-2.953,15.29),(33.61,-2.531,9.869),(36.46,14.06,-10.71),(38.02,8.009,0),(36.46,2.031,-10.71),(31.98,8.009,-20.55),(24.88,14.06,-28.72),(24.88,2.031,-28.72),(15.79,8.009,-34.58),(5.408,14.06,-37.61),(5.408,2.031,-37.61),(-5.41,8.009,-37.63),(-15.79,14.06,-34.57),(-15.79,2.031,-34.57),(-24.89,8.009,-28.73),(-32.12,14.12,-20.6),(-31.97,2.031,-20.54),(-36.63,8.059,-10.73),(-39.81,13.78,0),(-38,2.031,0),(-36.63,8.059,10.73),(-32.12,14.12,20.6),(-31.97,2.031,20.54),(-24.89,8.009,28.73),(-15.79,14.06,34.57),(-15.79,2.031,34.57),(-5.41,8.009,37.63),(5.408,14.06,37.61),(5.408,2.031,37.61),(15.79,8.009,34.58),(24.88,14.06,28.72),(24.88,2.031,28.72),(31.98,8.009,20.55),(36.46,14.06,10.71),(36.46,2.031,10.71),(36.46,25.41,-10.71),(38.02,18.18,0),(31.98,18.18,-20.55),(24.88,25.41,-28.72),(15.79,18.18,-34.58),(5.408,25.41,-37.61),(-5.41,18.18,-37.63),(-15.79,25.41,-34.57),(-24.89,18.18,-28.73),(-32.11,25.25,-20.6),(-38.06,18.03,-13.65),(-32.11,25.25,20.6),(-38.06,18.03,13.65),(-24.89,18.18,28.73),(-15.79,25.41,34.57),(-5.41,18.18,37.63),(5.408,25.41,37.61),(15.79,18.18,34.58),(24.88,25.41,28.72),(31.98,18.18,20.55),(36.46,25.41,10.71),(36.46,54.59,-10.71),(38.02,40,0),(31.98,40,-20.55),(24.88,54.59,-28.72),(15.79,40,-34.58),(5.408,54.59,-37.61),(-5.41,40,-37.63),(-15.79,54.59,-34.57),(-24.89,40,-28.73),(-32.11,54.75,-20.6),(-36.75,40,-10.74),(-39.45,54.52,0),(-39.45,25.48,0),(-36.75,40,10.74),(-32.11,54.75,20.6),(-24.89,40,28.73),(-15.79,54.59,34.57),(-5.41,40,37.63),(5.408,54.59,37.61),(15.79,40,34.58),(24.88,54.59,28.72),(31.98,40,20.55),(36.46,54.59,10.71),(36.46,65.94,-10.71),(38.02,61.82,0),(31.98,61.82,-20.55),(24.88,65.94,-28.72),(15.79,61.82,-34.58),(5.408,65.94,-37.61),(-5.41,61.82,-37.63),(-15.79,65.94,-34.57),(-24.89,61.82,-28.73),(-32.12,65.88,-20.6),(-38.06,61.97,-13.65),(-32.12,65.88,20.6),(-38.06,61.97,13.65),(-24.89,61.82,28.73),(-15.79,65.94,34.57),(-5.41,61.82,37.63),(5.408,65.94,37.61),(15.79,61.82,34.58),(24.88,65.94,28.72),(31.98,61.82,20.55),(36.46,65.94,10.71),(37.07,77.97,-10.88),(38.08,71.99,0),(32.03,71.99,-20.59),(25.3,77.97,-29.2),(15.82,71.99,-34.64),(5.498,77.97,-38.24),(-5.419,71.99,-37.69),(-16.05,77.97,-35.14),(-24.94,71.99,-28.78),(-32.5,77.97,-20.89),(-36.69,71.94,-10.74),(-38.63,77.97,0),(-39.81,66.22,0),(-36.69,71.94,10.74),(-32.5,77.97,20.89),(-24.94,71.99,28.78),(-16.05,77.97,35.14),(-5.419,71.99,37.69),(5.498,77.97,38.24),(15.82,71.99,34.64),(25.3,77.97,29.2),(32.03,71.99,20.59),(37.07,77.97,10.88),(36.28,82.53,-10.65),(39.77,82.91,0),(39.08,82.53,-11.48),(33.46,82.91,-21.5),(24.76,82.53,-28.58),(26.67,82.53,-30.78),(16.52,82.91,-36.17),(5.381,82.53,-37.43),(5.797,82.53,-40.32),(-5.66,82.91,-39.36),(-15.71,82.53,-34.39),(-16.92,82.53,-37.05),(-26.04,82.91,-30.06),(-31.81,82.53,-20.44),(-34.27,82.53,-22.02),(-38.16,82.91,-11.2),(-37.81,82.53,0),(-40.73,82.53,0),(-38.16,82.91,11.2),(-31.81,82.53,20.44),(-34.27,82.53,22.02),(-26.04,82.91,30.06),(-15.71,82.53,34.39),(-16.92,82.53,37.05),(-5.66,82.91,39.36),(5.381,82.53,37.43),(5.797,82.53,40.32),(16.52,82.91,36.17),(24.76,82.53,28.58),(26.67,82.53,30.78),(33.46,82.91,21.5),(36.28,82.53,10.65),(39.08,82.53,11.48),(19.72,2.047,0),(29.07,2.469,-8.536),(16.59,2.047,-10.66),(19.84,2.469,-22.9),(8.193,2.047,-17.94),(4.312,2.469,-29.99),(-2.807,2.047,-19.52),(-12.59,2.469,-27.56),(-12.92,2.047,-14.91),(-25.49,2.469,-16.38),(-18.92,2.047,-5.557),(-30.3,2.469,0),(-18.92,2.047,5.557),(-25.49,2.469,16.38),(-12.92,2.047,14.91),(-12.59,2.469,27.56),(-2.807,2.047,19.52),(4.312,2.469,29.99),(8.193,2.047,17.94),(19.84,2.469,22.9),(16.59,2.047,10.66),(29.07,2.469,8.536),(37.72,-1.25,0),(31.73,-1.25,-20.39),(15.67,-1.25,-34.31),(-5.368,-1.25,-37.33),(-24.7,-1.25,-28.51),(-36.19,-1.25,-10.63),(-36.19,-1.25,10.63),(-24.7,-1.25,28.51),(-5.368,-1.25,37.33),(15.67,-1.25,34.31),(31.73,-1.25,20.39),(33.24,68.75,-9.759),(28.72,42.5,-18.46),(32.69,16.25,-9.599),(34.14,42.5,0),(22.68,68.75,-26.18),(14.18,42.5,-31.06),(22.31,16.25,-25.75),(4.93,68.75,-34.29),(-4.859,42.5,-33.8),(4.849,16.25,-33.73),(-14.39,68.75,-31.51),(-22.36,42.5,-25.8),(-14.15,16.25,-30.99),(-29.14,68.75,-18.73),(-32.76,42.5,-9.62),(-28.66,16.25,-18.42),(-34.64,68.75,0),(-32.76,42.5,9.62),(-34.07,16.25,0),(-29.14,68.75,18.73),(-22.36,42.5,25.8),(-28.66,16.25,18.42),(-14.39,68.75,31.51),(-4.859,42.5,33.8),(-14.15,16.25,30.99),(4.93,68.75,34.29),(14.18,42.5,31.06),(4.849,16.25,33.73),(22.68,68.75,26.18),(28.72,42.5,18.46),(22.31,16.25,25.75),(33.24,68.75,9.759),(32.69,16.25,9.599),(28.32,4.672,-18.2),(33.66,4.672,0),(13.98,4.672,-30.62),(-4.791,4.672,-33.32),(-22.04,4.672,-25.44),(-32.3,4.672,-9.484),(-32.3,4.672,9.484),(-22.04,4.672,25.44),(-4.791,4.672,33.32),(13.98,4.672,30.62),(28.32,4.672,18.2),(33.63,81.25,-21.61),(39.97,81.25,0),(16.6,81.25,-36.36),(-5.688,81.25,-39.56),(-26.18,81.25,-30.21),(-38.35,81.25,-11.26),(-38.35,81.25,11.26),(-26.18,81.25,30.21),(-5.688,81.25,39.56),(16.6,81.25,36.36),(33.63,81.25,21.61),(35.97,80.33,0),(30.26,80.33,-19.45),(14.94,80.33,-32.72),(-5.119,80.33,-35.6),(-23.56,80.33,-27.18),(-34.51,80.33,-10.13),(-34.51,80.33,10.13),(-23.56,80.33,27.18),(-5.119,80.33,35.6),(14.94,80.33,32.72),(30.26,80.33,19.45),(-42.89,60.65,8.022),(-46.84,60.02,1.276e-005),(-42.89,60.65,-8.022),(-47.92,61.1,-10.56),(-43.77,63.3,-8.022),(-49,62.18,1.171e-005),(-43.77,63.3,8.022),(-47.92,61.1,10.56),(-52.83,58.87,-7.718),(-56.22,54.06,1.517e-005),(-52.83,58.87,7.718),(-50.75,57.99,-7.718),(-54.62,53.87,-10.16),(-50.75,57.99,7.718),(-53.01,53.69,1.609e-005),(-54.62,53.87,10.16),(-43.77,16.7,8.022),(-49,17.82,1.18e-005),(-43.77,16.7,-8.022),(-47.92,18.9,-10.56),(-42.89,19.35,-8.022),(-46.84,19.98,1.171e-005),(-42.89,19.35,8.022),(-47.92,18.9,10.56),(-50.75,22.01,-7.718),(-53.01,26.31,1.532e-005),(-50.75,22.01,7.718),(-52.83,21.13,-7.718),(-54.62,26.13,-10.16),(-52.83,21.13,7.718),(-56.22,25.94,1.524e-005),(-54.62,26.13,10.16),(-54.94,32.57,-6.828),(-54.95,40,1.916e-005),(-54.94,32.57,6.828),(-57.4,32.55,-6.828),(-56.63,40,-8.784),(-57.4,32.55,6.828),(-58.32,40,1.842e-005),(-56.63,40,8.784),(-57.4,47.45,-6.828),(-57.4,47.45,6.828),(-54.94,47.43,-6.828),(-54.94,47.43,6.828),(8.196,-3,-2.406),(14.33,-3,-6.462),(15.55,-3,-2.309),(5.593,-3,-6.455),(8.558,-3,-13.18),(11.83,-3,-10.35),(1.216,-3,-8.455),(0.07312,-3,-15.72),(4.358,-3,-15.1),(-3.548,-3,-7.77),(-8.435,-3,-13.26),(-4.498,-3,-15.06),(-7.186,-3,-4.618),(-14.27,-3,-6.595),(-11.93,-3,-10.24),(-8.541,-3,0),(-15.57,-3,2.164),(-15.57,-3,-2.164),(-7.186,-3,4.618),(-11.93,-3,10.24),(-14.27,-3,6.595),(-3.548,-3,7.77),(-4.498,-3,15.06),(-8.435,-3,13.26),(1.216,-3,8.455),(4.358,-3,15.1),(0.07313,-3,15.72),(5.593,-3,6.455),(11.83,-3,10.35),(8.558,-3,13.18),(8.196,-3,2.406),(15.55,-3,2.309),(14.33,-3,6.462),(23.8,-3,-3.435),(21.88,-3,-9.977),(29.17,-2.813,-13.32),(31.74,-2.813,-4.562),(18.16,-3,-15.76),(13.01,-3,-20.22),(17.34,-2.813,-26.98),(24.24,-2.813,-21),(6.762,-3,-23.08),(0.01334,-3,-24.05),(-0.001974,-2.813,-32.07),(9.036,-2.813,-30.77),(-6.787,-3,-23.07),(-12.99,-3,-20.24),(-17.34,-2.813,-26.98),(-9.032,-2.813,-30.77),(-18.18,-3,-15.74),(-21.87,-3,-10),(-29.17,-2.813,-13.32),(-24.23,-2.813,-21),(-23.8,-3,-3.409),(-23.8,-3,3.409),(-31.74,-2.813,4.566),(-31.74,-2.813,-4.566),(-21.87,-3,10),(-18.18,-3,15.74),(-24.23,-2.813,21),(-29.17,-2.813,13.32),(-12.99,-3,20.24),(-6.787,-3,23.07),(-9.032,-2.813,30.77),(-17.34,-2.813,26.98),(0.01335,-3,24.05),(6.762,-3,23.08),(9.036,-2.813,30.77),(-0.001963,-2.813,32.07),(13.01,-3,20.22),(18.16,-3,15.76),(24.24,-2.813,21),(17.34,-2.813,26.98),(21.88,-3,9.977),(23.8,-3,3.435),(31.74,-2.813,4.562),(29.17,-2.813,13.32),(37.62,4.813,-5.406),(34.57,4.813,-15.79),(34.57,11.22,-15.79),(37.62,11.22,-5.406),(28.72,4.813,-24.89),(20.55,4.813,-31.97),(20.55,11.22,-31.97),(28.72,11.22,-24.89),(10.71,4.813,-36.47),(-0.002339,4.813,-38.01),(-0.002339,11.22,-38.01),(10.71,11.22,-36.47),(-10.71,4.813,-36.47),(-20.55,4.813,-31.97),(-20.55,11.22,-31.97),(-10.71,11.22,-36.47),(-28.72,4.813,-24.89),(-34.57,4.813,-15.79),(-34.93,11.37,-15.83),(-28.72,11.22,-24.89),(-37.62,4.813,-5.411),(-37.62,4.813,5.411),(-38.33,11.28,5.451),(-38.33,11.28,-5.451),(-34.57,4.813,15.79),(-28.72,4.813,24.89),(-28.72,11.22,24.89),(-34.93,11.37,15.83),(-20.55,4.813,31.97),(-10.71,4.813,36.47),(-10.71,11.22,36.47),(-20.55,11.22,31.97),(-0.002326,4.813,38.01),(10.71,4.813,36.47),(10.71,11.22,36.47),(-0.002326,11.22,38.01),(20.55,4.813,31.97),(28.72,4.813,24.89),(28.72,11.22,24.89),(20.55,11.22,31.97),(34.57,4.813,15.79),(37.62,4.813,5.406),(37.62,11.22,5.406),(34.57,11.22,15.79),(37.62,16.12,-5.406),(34.57,16.12,-15.79),(34.57,21.02,-15.79),(37.62,21.02,-5.406),(28.72,16.12,-24.89),(20.55,16.12,-31.97),(20.55,21.02,-31.97),(28.72,21.02,-24.89),(10.71,16.12,-36.47),(-0.002339,16.12,-38.01),(-0.002338,21.02,-38.01),(10.71,21.02,-36.47),(-10.71,16.12,-36.47),(-20.55,16.12,-31.97),(-20.55,21.02,-31.97),(-10.71,21.02,-36.47),(-28.72,16.12,-24.89),(-35.24,16.27,-16.53),(-35.2,20.59,-16.53),(-28.72,21.02,-24.89),(-35.24,16.27,16.53),(-28.72,16.12,24.89),(-28.72,21.02,24.89),(-35.2,20.59,16.53),(-20.55,16.12,31.97),(-10.71,16.12,36.47),(-10.71,21.02,36.47),(-20.55,21.02,31.97),(-0.002326,16.12,38.01),(10.71,16.12,36.47),(10.71,21.02,36.47),(-0.002326,21.02,38.01),(20.55,16.12,31.97),(28.72,16.12,24.89),(28.72,21.02,24.89),(20.55,21.02,31.97),(34.57,16.12,15.79),(37.62,16.12,5.406),(37.62,21.02,5.406),(34.57,21.02,15.79),(37.62,32.12,-5.406),(34.57,32.12,-15.79),(34.57,47.88,-15.79),(37.62,47.88,-5.406),(28.72,32.12,-24.89),(20.55,32.12,-31.97),(20.55,47.88,-31.97),(28.72,47.88,-24.89),(10.71,32.12,-36.47),(-0.002338,32.12,-38.01),(-0.002338,47.88,-38.01),(10.71,47.88,-36.47),(-10.71,32.12,-36.47),(-20.55,32.12,-31.97),(-20.55,47.88,-31.97),(-10.71,47.88,-36.47),(-28.72,32.12,-24.89),(-34.89,31.7,-15.83),(-34.89,48.3,-15.83),(-28.72,47.88,-24.89),(-38.21,31.79,-5.451),(-38.21,31.79,5.451),(-38.21,48.21,5.451),(-38.21,48.21,-5.451),(-34.89,31.7,15.83),(-28.72,32.12,24.89),(-28.72,47.88,24.89),(-34.89,48.3,15.83),(-20.55,32.12,31.97),(-10.71,32.12,36.47),(-10.71,47.88,36.47),(-20.55,47.88,31.97),(-0.002325,32.12,38.01),(10.71,32.12,36.47),(10.71,47.88,36.47),(-0.002325,47.88,38.01),(20.55,32.12,31.97),(28.72,32.12,24.89),(28.72,47.88,24.89),(20.55,47.88,31.97),(34.57,32.12,15.79),(37.62,32.12,5.406),(37.62,47.88,5.406),(34.57,47.88,15.79),(37.62,58.98,-5.406),(34.57,58.98,-15.79),(34.57,63.88,-15.79),(37.62,63.88,-5.406),(28.72,58.98,-24.89),(20.55,58.98,-31.97),(20.55,63.88,-31.97),(28.72,63.88,-24.89),(10.71,58.98,-36.47),(-0.002339,58.98,-38.01),(-0.002339,63.88,-38.01),(10.71,63.88,-36.47),(-10.71,58.98,-36.47),(-20.55,58.98,-31.97),(-20.55,63.88,-31.97),(-10.71,63.88,-36.47),(-28.72,58.98,-24.89),(-35.2,59.41,-16.53),(-35.24,63.73,-16.53),(-28.72,63.88,-24.89),(-35.2,59.41,16.53),(-28.72,58.98,24.89),(-28.72,63.88,24.89),(-35.24,63.73,16.53),(-20.55,58.98,31.97),(-10.71,58.98,36.47),(-10.71,63.88,36.47),(-20.55,63.88,31.97),(-0.002325,58.98,38.01),(10.71,58.98,36.47),(10.71,63.88,36.47),(-0.002326,63.88,38.01),(20.55,58.98,31.97),(28.72,58.98,24.89),(28.72,63.88,24.89),(20.55,63.88,31.97),(34.57,58.98,15.79),(37.62,58.98,5.406),(37.62,63.88,5.406),(34.57,63.88,15.79),(37.62,68.78,-5.406),(34.57,68.78,-15.79),(34.8,75.19,-15.9),(37.87,75.19,-5.442),(28.72,68.78,-24.89),(20.55,68.78,-31.97),(20.68,75.19,-32.19),(28.92,75.19,-25.05),(10.71,68.78,-36.47),(-0.002339,68.78,-38.01),(-0.002355,75.19,-38.26),(10.78,75.19,-36.71),(-10.71,68.78,-36.47),(-20.55,68.78,-31.97),(-20.69,75.19,-32.18),(-10.78,75.19,-36.71),(-28.72,68.78,-24.89),(-34.93,68.63,-15.83),(-34.8,75.19,-15.89),(-28.91,75.19,-25.06),(-38.33,68.72,-5.451),(-38.33,68.72,5.451),(-37.87,75.19,5.447),(-37.87,75.19,-5.447),(-34.93,68.63,15.83),(-28.72,68.78,24.89),(-28.91,75.19,25.06),(-34.8,75.19,15.89),(-20.55,68.78,31.97),(-10.71,68.78,36.47),(-10.78,75.19,36.71),(-20.69,75.19,32.18),(-0.002326,68.78,38.01),(10.71,68.78,36.47),(10.78,75.19,36.71),(-0.002341,75.19,38.26),(20.55,68.78,31.97),(28.72,68.78,24.89),(28.92,75.19,25.05),(20.68,75.19,32.19),(34.57,68.78,15.79),(37.62,68.78,5.406),(37.87,75.19,5.442),(34.8,75.19,15.9),(40.03,82.81,-5.753),(36.78,82.81,-16.8),(35.33,82.81,-16.14),(38.44,82.81,-5.525),(30.56,82.81,-26.48),(21.86,82.81,-34.02),(20.99,82.81,-32.67),(29.35,82.81,-25.43),(11.4,82.81,-38.8),(-0.00249,82.81,-40.44),(-0.002391,82.81,-38.84),(10.94,82.81,-37.26),(-11.39,82.81,-38.8),(-21.87,82.81,-34.02),(-21,82.81,-32.67),(-10.94,82.81,-37.26),(-30.56,82.81,-26.48),(-36.79,82.81,-16.8),(-35.33,82.81,-16.13),(-29.35,82.81,-25.43),(-40.03,82.81,-5.758),(-40.03,82.81,5.758),(-38.44,82.81,5.529),(-38.44,82.81,-5.529),(-36.79,82.81,16.8),(-30.56,82.81,26.48),(-29.35,82.81,25.43),(-35.33,82.81,16.13),(-21.87,82.81,34.02),(-11.39,82.81,38.8),(-10.94,82.81,37.26),(-21,82.81,32.67),(-0.002475,82.81,40.44),(11.4,82.81,38.8),(10.94,82.81,37.26),(-0.002377,82.81,38.84),(21.86,82.81,34.02),(30.56,82.81,26.48),(29.35,82.81,25.43),(20.99,82.81,32.67),(36.78,82.81,16.8),(40.03,82.81,5.753),(38.44,82.81,5.525),(35.33,82.81,16.14),(14.7,2,-4.316),(25.77,2.188,-3.838),(23.75,2.188,-10.7),(10.03,2,-11.58),(19.6,2.188,-17.16),(14.2,2.188,-21.85),(2.18,2,-15.16),(7.214,2.188,-25.04),(0.1313,2.188,-26.05),(-6.363,2,-13.93),(-7.466,2.188,-24.96),(-13.98,2.188,-21.99),(-12.89,2,-8.281),(-19.78,2.188,-16.96),(-23.65,2.188,-10.94),(-15.32,2,0),(-25.81,2.188,-3.578),(-25.81,2.188,3.578),(-12.89,2,8.281),(-23.65,2.188,10.94),(-19.78,2.188,16.96),(-6.363,2,13.93),(-13.98,2.188,21.99),(-7.466,2.188,24.96),(2.18,2,15.16),(0.1313,2.188,26.05),(7.214,2.188,25.04),(10.03,2,11.58),(14.2,2.188,21.85),(19.6,2.188,17.16),(14.7,2,4.316),(23.75,2.188,10.7),(25.77,2.188,3.838),(34.57,0.0625,-15.79),(37.62,0.0625,-5.406),(36.44,-2.063,-5.237),(33.49,-2.063,-15.3),(20.55,0.0625,-31.97),(28.72,0.0625,-24.89),(27.83,-2.063,-24.11),(19.9,-2.063,-30.97),(-0.002339,0.0625,-38.01),(10.71,0.0625,-36.47),(10.37,-2.063,-35.33),(-0.002266,-2.063,-36.82),(-20.55,0.0625,-31.97),(-10.71,0.0625,-36.47),(-10.37,-2.063,-35.33),(-19.91,-2.063,-30.97),(-34.57,0.0625,-15.79),(-28.72,0.0625,-24.89),(-27.82,-2.063,-24.11),(-33.49,-2.063,-15.29),(-37.62,0.0625,5.411),(-37.62,0.0625,-5.411),(-36.44,-2.063,-5.242),(-36.44,-2.063,5.242),(-28.72,0.0625,24.89),(-34.57,0.0625,15.79),(-33.49,-2.063,15.29),(-27.82,-2.063,24.11),(-10.71,0.0625,36.47),(-20.55,0.0625,31.97),(-19.91,-2.063,30.97),(-10.37,-2.063,35.33),(10.71,0.0625,36.47),(-0.002326,0.0625,38.01),(-0.002253,-2.063,36.82),(10.37,-2.063,35.33),(28.72,0.0625,24.89),(20.55,0.0625,31.97),(19.9,-2.063,30.97),(27.83,-2.063,24.11),(37.62,0.0625,5.406),(34.57,0.0625,15.79),(33.49,-2.063,15.3),(36.44,-2.063,5.237),(33.96,56.75,-4.88),(31.2,56.75,-14.25),(31,28.25,-14.16),(33.73,28.25,-4.848),(25.93,56.75,-22.46),(18.54,56.75,-28.86),(18.42,28.25,-28.67),(25.76,28.25,-22.32),(9.667,56.75,-32.91),(-0.002112,56.75,-34.31),(-0.002098,28.25,-34.08),(9.603,28.25,-32.7),(-9.663,56.75,-32.92),(-18.55,56.75,-28.86),(-18.43,28.25,-28.67),(-9.599,28.25,-32.7),(-25.92,56.75,-22.47),(-31.21,56.75,-14.25),(-31,28.25,-14.15),(-25.75,28.25,-22.32),(-33.96,56.75,-4.884),(-33.96,56.75,4.884),(-33.73,28.25,4.852),(-33.73,28.25,-4.852),(-31.21,56.75,14.25),(-25.92,56.75,22.47),(-25.75,28.25,22.32),(-31,28.25,14.15),(-18.55,56.75,28.86),(-9.663,56.75,32.92),(-9.599,28.25,32.7),(-18.43,28.25,28.67),(-0.0021,56.75,34.31),(9.667,56.75,32.91),(9.603,28.25,32.7),(-0.002086,28.25,34.08),(18.54,56.75,28.86),(25.93,56.75,22.46),(25.76,28.25,22.32),(18.42,28.25,28.67),(31.2,56.75,14.25),(33.96,56.75,4.88),(33.73,28.25,4.848),(31,28.25,14.16),(33.73,8.75,-4.848),(31,8.75,-14.16),(29.55,2.938,-13.47),(32.14,2.938,-4.646),(25.76,8.75,-22.32),(18.42,8.75,-28.67),(17.58,2.938,-27.31),(24.53,2.938,-21.28),(9.603,8.75,-32.7),(-0.002098,8.75,-34.08),(0.02457,2.938,-32.47),(9.125,2.938,-31.17),(-9.599,8.75,-32.7),(-18.43,8.75,-28.67),(-17.54,2.938,-27.33),(-9.172,2.938,-31.15),(-25.75,8.75,-22.32),(-31,8.75,-14.15),(-29.53,2.938,-13.51),(-24.56,2.938,-21.25),(-33.73,8.75,-4.852),(-33.73,8.75,4.852),(-32.15,2.938,4.597),(-32.15,2.938,-4.597),(-31,8.75,14.15),(-25.75,8.75,22.32),(-24.56,2.938,21.25),(-29.53,2.938,13.51),(-18.43,8.75,28.67),(-9.599,8.75,32.7),(-9.172,2.938,31.15),(-17.54,2.938,27.33),(-0.002086,8.75,34.08),(9.603,8.75,32.7),(9.125,2.938,31.17),(0.02459,2.938,32.47),(18.42,8.75,28.67),(25.76,8.75,22.32),(24.53,2.938,21.28),(17.58,2.938,27.31),(31,8.75,14.16),(33.73,8.75,4.848),(32.14,2.938,4.646),(29.55,2.938,13.47),(38.87,79.94,-5.586),(35.72,79.94,-16.32),(36.85,82.06,-16.83),(40.1,82.06,-5.763),(29.68,79.94,-25.71),(21.23,79.94,-33.04),(21.9,82.06,-34.08),(30.62,82.06,-26.53),(11.07,79.94,-37.68),(-0.002417,79.94,-39.27),(-0.002494,82.06,-40.51),(11.42,82.06,-38.87),(-11.06,79.94,-37.68),(-21.23,79.94,-33.03),(-21.91,82.06,-34.08),(-11.41,82.06,-38.87),(-29.68,79.94,-25.72),(-35.72,79.94,-16.31),(-36.85,82.06,-16.83),(-30.62,82.06,-26.53),(-38.87,79.94,-5.591),(-38.87,79.94,5.591),(-40.1,82.06,5.768),(-40.1,82.06,-5.768),(-35.72,79.94,16.31),(-29.68,79.94,25.72),(-30.62,82.06,26.53),(-36.85,82.06,16.83),(-21.23,79.94,33.03),(-11.06,79.94,37.68),(-11.41,82.06,38.87),(-21.91,82.06,34.08),(-0.002403,79.94,39.27),(11.07,79.94,37.68),(11.42,82.06,38.87),(-0.00248,82.06,40.51),(21.23,79.94,33.04),(29.68,79.94,25.71),(30.62,82.06,26.53),(21.9,82.06,34.08),(35.72,79.94,16.32),(38.87,79.94,5.586),(40.1,82.06,5.763),(36.85,82.06,16.83),(32.03,76.25,-14.63),(34.85,76.25,-5.009),(36.47,82.06,-5.241),(33.51,82.06,-15.31),(19.04,76.25,-29.62),(26.61,76.25,-23.06),(27.85,82.06,-24.13),(19.92,82.06,-31),(-0.002168,76.25,-35.21),(9.922,76.25,-33.78),(10.38,82.06,-35.35),(-0.002268,82.06,-36.84),(-19.04,76.25,-29.62),(-9.918,76.25,-33.79),(-10.38,82.06,-35.35),(-19.92,82.06,-30.99),(-32.03,76.25,-14.63),(-26.61,76.25,-23.06),(-27.84,82.06,-24.13),(-33.51,82.06,-15.3),(-34.85,76.25,5.013),(-34.85,76.25,-5.013),(-36.47,82.06,-5.246),(-36.47,82.06,5.246),(-26.61,76.25,23.06),(-32.03,76.25,14.63),(-33.51,82.06,15.3),(-27.84,82.06,24.13),(-9.918,76.25,33.79),(-19.04,76.25,29.62),(-19.92,82.06,30.99),(-10.38,82.06,35.35),(9.922,76.25,33.78),(-0.002155,76.25,35.21),(-0.002255,82.06,36.84),(10.38,82.06,35.35),(26.61,76.25,23.06),(19.04,76.25,29.62),(19.92,82.06,31),(27.85,82.06,24.13),(34.85,76.25,5.009),(32.03,76.25,14.63),(33.51,82.06,15.31),(36.47,82.06,5.241),(-40.81,58.64,-4.859),(-40.81,58.64,4.859),(-44.9,60.57,4.226),(-44.9,60.57,-4.226),(-40.91,63.18,-11.09),(-40.63,60.73,-11.09),(-45.36,61.25,-9.861),(-46.04,62.27,-9.861),(-41.49,64.5,4.859),(-41.49,64.5,-4.859),(-46.49,62.95,-4.226),(-46.49,62.95,4.226),(-40.63,60.73,11.09),(-40.91,63.18,11.09),(-46.04,62.27,9.861),(-45.36,61.25,9.861),(-51.15,60.79,4.226),(-51.15,60.79,-4.226),(-54.78,56.74,-4.161),(-54.78,56.74,4.161),(-50.47,60.33,-9.861),(-49.46,59.65,-9.861),(-52.74,56.25,-9.71),(-53.96,56.54,-9.71),(-48.78,59.2,-4.226),(-48.78,59.2,4.226),(-51.92,56.05,4.161),(-51.92,56.05,-4.161),(-49.46,59.65,9.861),(-50.47,60.33,9.861),(-53.96,56.54,9.71),(-52.74,56.25,9.71),(-41.49,15.5,-4.859),(-41.49,15.5,4.859),(-46.49,17.05,4.226),(-46.49,17.05,-4.226),(-40.63,19.27,-11.09),(-40.91,16.82,-11.09),(-46.04,17.73,-9.861),(-45.36,18.75,-9.861),(-40.81,21.36,4.859),(-40.81,21.36,-4.859),(-44.9,19.43,-4.226),(-44.9,19.43,4.226),(-40.91,16.82,11.09),(-40.63,19.27,11.09),(-45.36,18.75,9.861),(-46.04,17.73,9.861),(-48.78,20.8,4.226),(-48.78,20.8,-4.226),(-51.92,23.95,-4.161),(-51.92,23.95,4.161),(-49.46,20.35,-9.861),(-50.47,19.67,-9.861),(-53.96,23.46,-9.71),(-52.74,23.75,-9.71),(-51.15,19.21,-4.226),(-51.15,19.21,4.226),(-54.78,23.26,4.161),(-54.78,23.26,-4.161),(-50.47,19.67,9.861),(-49.46,20.35,9.861),(-52.74,23.75,9.71),(-53.96,23.46,9.71),(-54,29.22,3.902),(-54,29.22,-3.902),(-54.95,36.22,-3.578),(-54.95,36.22,3.579),(-54.89,29.18,-9.105),(-56.21,29.13,-9.105),(-57.2,36.22,-8.35),(-55.85,36.22,-8.35),(-57.09,29.09,-3.902),(-57.09,29.09,3.902),(-58.1,36.22,3.579),(-58.1,36.22,-3.578),(-56.21,29.13,9.105),(-54.89,29.18,9.105),(-55.85,36.22,8.35),(-57.2,36.22,8.35),(-57.09,50.91,3.902),(-57.09,50.91,-3.902),(-58.1,43.78,-3.578),(-58.1,43.78,3.579),(-56.21,50.87,-9.105),(-54.89,50.82,-9.105),(-55.85,43.78,-8.35),(-57.2,43.78,-8.35),(-54,50.78,-3.902),(-54,50.78,3.902),(-54.95,43.78,3.579),(-54.95,43.78,-3.578),(-54.89,50.82,9.105),(-56.21,50.88,9.105),(-57.2,43.78,8.35),(-55.85,43.78,8.35),(5.79,-3,-3.721),(11.04,-3,-4.624),(11.79,-3,-2.08),(6.882,-3,0),(17.97,-3,-8.165),(15.33,-3,-4.502),(13,-3,-8.355),(15.45,-3,0),(19.53,-3,-2.844),(2.859,-3,-6.26),(6.789,-3,-9.859),(8.793,-3,-8.123),(10.7,-3,-16.58),(10.46,-3,-12.08),(6.42,-3,-14.06),(14.89,-3,-12.95),(-0.9794,-3,-6.812),(0.3811,-3,-11.96),(3.005,-3,-11.59),(0.03583,-3,-19.73),(2.274,-3,-15.82),(-2.199,-3,-15.3),(5.525,-3,-18.95),(-4.507,-3,-5.201),(-6.148,-3,-10.27),(-3.736,-3,-11.37),(-10.64,-3,-16.62),(-6.638,-3,-14.53),(-10.12,-3,-11.68),(-5.594,-3,-18.93),(-6.603,-3,-1.939),(-10.72,-3,-5.317),(-9.292,-3,-7.547),(-17.94,-3,-8.231),(-13.44,-3,-8.639),(-14.83,-3,-4.354),(-14.94,-3,-12.9),(-6.603,-3,1.939),(-11.9,-3,1.326),(-11.9,-3,-1.326),(-19.54,-3,2.773),(-15.98,-3,0),(-14.83,-3,4.354),(-19.54,-3,-2.773),(-4.507,-3,5.201),(-9.292,-3,7.547),(-10.72,-3,5.317),(-14.94,-3,12.9),(-13.44,-3,8.639),(-10.12,-3,11.68),(-17.94,-3,8.231),(-0.9794,-3,6.812),(-3.736,-3,11.37),(-6.148,-3,10.27),(-5.594,-3,18.93),(-6.638,-3,14.53),(-2.199,-3,15.3),(-10.64,-3,16.62),(2.859,-3,6.26),(3.005,-3,11.59),(0.3811,-3,11.96),(5.526,-3,18.95),(2.274,-3,15.82),(6.42,-3,14.06),(0.03584,-3,19.73),(5.79,-3,3.721),(8.793,-3,8.123),(6.789,-3,9.859),(14.89,-3,12.95),(10.46,-3,12.08),(13,-3,8.355),(10.7,-3,16.58),(11.79,-3,2.08),(11.04,-3,4.624),(19.53,-3,2.844),(15.33,-3,4.502),(17.97,-3,8.165),(23.12,-3,-6.788),(27.99,-2.953,-4.027),(24,-3,0),(20.19,-3,-12.98),(25.73,-2.953,-11.75),(31.87,-2.531,-14.56),(30.76,-2.813,-9.033),(26.98,-2.813,-17.34),(32.08,-2.813,0),(34.68,-2.531,-4.984),(15.78,-3,-18.21),(21.37,-2.953,-18.52),(9.97,-3,-21.83),(15.29,-2.953,-23.79),(18.94,-2.531,-29.48),(21,-2.813,-24.23),(13.32,-2.813,-29.18),(26.48,-2.531,-22.94),(3.429,-3,-23.85),(7.966,-2.953,-27.14),(-3.415,-3,-23.76),(0.001964,-2.953,-28.28),(-0.002156,-2.531,-35.04),(4.563,-2.813,-31.74),(-4.565,-2.813,-31.75),(9.873,-2.531,-33.62),(-10.01,-3,-21.92),(-7.969,-2.953,-27.13),(-15.72,-3,-18.14),(-15.29,-2.953,-23.79),(-18.94,-2.531,-29.47),(-13.32,-2.813,-29.16),(-21.01,-2.813,-24.24),(-9.869,-2.531,-33.62),(-20.27,-3,-13.03),(-21.37,-2.953,-18.52),(-23.03,-3,-6.761),(-25.72,-2.953,-11.75),(-31.87,-2.531,-14.55),(-26.97,-2.813,-17.33),(-30.78,-2.813,-9.037),(-26.48,-2.531,-22.95),(-24.1,-3,0),(-27.99,-2.953,-4.023),(-23.03,-3,6.761),(-27.99,-2.953,4.023),(-34.68,-2.531,4.988),(-32.06,-2.813,0),(-30.78,-2.813,9.037),(-34.68,-2.531,-4.988),(-20.27,-3,13.03),(-25.72,-2.953,11.75),(-15.72,-3,18.14),(-21.37,-2.953,18.52),(-26.48,-2.531,22.95),(-26.97,-2.813,17.33),(-21.01,-2.813,24.24),(-31.87,-2.531,14.55),(-10.01,-3,21.92),(-15.29,-2.953,23.79),(-3.415,-3,23.76),(-7.969,-2.953,27.13),(-9.869,-2.531,33.62),(-13.32,-2.813,29.16),(-4.565,-2.813,31.75),(-18.94,-2.531,29.47),(3.429,-3,23.85),(0.001974,-2.953,28.28),(9.97,-3,21.83),(7.966,-2.953,27.14),(9.873,-2.531,33.62),(4.563,-2.813,31.74),(13.32,-2.813,29.18),(-0.002144,-2.531,35.04),(15.78,-3,18.21),(15.29,-2.953,23.79),(20.19,-3,12.98),(21.37,-2.953,18.52),(26.48,-2.531,22.94),(21,-2.813,24.23),(26.98,-2.813,17.34),(18.94,-2.531,29.48),(23.12,-3,6.788),(25.73,-2.953,11.75),(27.99,-2.953,4.027),(34.68,-2.531,4.984),(30.76,-2.813,9.033),(31.87,-2.531,14.56),(37.62,2.031,-5.406),(36.46,4.813,-10.71),(37.62,8.009,-5.406),(38.02,4.813,0),(31.98,4.813,-20.55),(34.57,8.009,-15.79),(34.57,2.031,-15.79),(34.57,14.06,-15.79),(36.46,11.22,-10.71),(31.98,11.22,-20.55),(38.02,11.22,0),(37.62,14.06,-5.406),(28.72,2.031,-24.89),(24.88,4.813,-28.72),(28.72,8.009,-24.89),(15.79,4.813,-34.58),(20.55,8.009,-31.97),(20.55,2.031,-31.97),(20.55,14.06,-31.97),(24.88,11.22,-28.72),(15.79,11.22,-34.58),(28.72,14.06,-24.89),(10.71,2.031,-36.47),(5.408,4.813,-37.61),(10.71,8.009,-36.47),(-5.41,4.813,-37.63),(-0.002339,8.009,-38.01),(-0.002339,2.031,-38.01),(-0.002339,14.06,-38.01),(5.408,11.22,-37.61),(-5.41,11.22,-37.63),(10.71,14.06,-36.47),(-10.71,2.031,-36.47),(-15.79,4.813,-34.57),(-10.71,8.009,-36.47),(-24.89,4.813,-28.73),(-20.55,8.009,-31.97),(-20.55,2.031,-31.97),(-20.55,14.06,-31.97),(-15.79,11.22,-34.57),(-24.89,11.22,-28.73),(-10.71,14.06,-36.47),(-28.72,2.031,-24.89),(-31.97,4.813,-20.54),(-28.72,8.009,-24.89),(-36.48,4.813,-10.71),(-34.66,8.046,-15.8),(-34.57,2.031,-15.79),(-35.18,14.28,-16.02),(-32.06,11.26,-20.55),(-37.1,11.42,-10.77),(-28.72,14.06,-24.89),(-37.62,2.031,-5.411),(-38,4.813,0),(-37.8,8.022,-5.421),(-36.48,4.813,10.71),(-37.8,8.022,5.421),(-37.62,2.031,5.411),(-39.47,13.97,5.323),(-38.71,11.15,0),(-37.1,11.42,10.77),(-39.47,13.97,-5.323),(-34.57,2.031,15.79),(-31.97,4.813,20.54),(-34.66,8.046,15.8),(-24.89,4.813,28.73),(-28.72,8.009,24.89),(-28.72,2.031,24.89),(-28.72,14.06,24.89),(-32.06,11.26,20.55),(-24.89,11.22,28.73),(-35.18,14.28,16.02),(-20.55,2.031,31.97),(-15.79,4.813,34.57),(-20.55,8.009,31.97),(-5.41,4.813,37.63),(-10.71,8.009,36.47),(-10.71,2.031,36.47),(-10.71,14.06,36.47),(-15.79,11.22,34.57),(-5.41,11.22,37.63),(-20.55,14.06,31.97),(-0.002326,2.031,38.01),(5.408,4.813,37.61),(-0.002326,8.009,38.01),(15.79,4.813,34.58),(10.71,8.009,36.47),(10.71,2.031,36.47),(10.71,14.06,36.47),(5.408,11.22,37.61),(15.79,11.22,34.58),(-0.002326,14.06,38.01),(20.55,2.031,31.97),(24.88,4.813,28.72),(20.55,8.009,31.97),(31.98,4.813,20.55),(28.72,8.009,24.89),(28.72,2.031,24.89),(28.72,14.06,24.89),(24.88,11.22,28.72),(31.98,11.22,20.55),(20.55,14.06,31.97),(34.57,2.031,15.79),(36.46,4.813,10.71),(34.57,8.009,15.79),(37.62,8.009,5.406),(37.62,2.031,5.406),(37.62,14.06,5.406),(36.46,11.22,10.71),(34.57,14.06,15.79),(36.46,16.12,-10.71),(37.62,18.18,-5.406),(38.02,16.12,0),(31.98,16.12,-20.55),(34.57,18.18,-15.79),(34.57,25.41,-15.79),(36.46,21.02,-10.71),(31.98,21.02,-20.55),(38.02,21.02,0),(37.62,25.41,-5.406),(24.88,16.12,-28.72),(28.72,18.18,-24.89),(15.79,16.12,-34.58),(20.55,18.18,-31.97),(20.55,25.41,-31.97),(24.88,21.02,-28.72),(15.79,21.02,-34.58),(28.72,25.41,-24.89),(5.408,16.12,-37.61),(10.71,18.18,-36.47),(-5.41,16.12,-37.63),(-0.002339,18.18,-38.01),(-0.002338,25.41,-38.01),(5.408,21.02,-37.61),(-5.41,21.02,-37.63),(10.71,25.41,-36.47),(-15.79,16.12,-34.57),(-10.71,18.18,-36.47),(-24.89,16.12,-28.73),(-20.55,18.18,-31.97),(-20.55,25.41,-31.97),(-15.79,21.02,-34.57),(-24.89,21.02,-28.73),(-10.71,25.41,-36.47),(-32.13,16.16,-20.73),(-28.72,18.18,-24.89),(-38.13,16.48,-13.06),(-35.21,18.11,-16.86),(-35.13,24.77,-16.02),(-32.12,20.91,-20.73),(-38.02,20.05,-13.06),(-28.72,25.41,-24.89),(-32.13,16.16,20.73),(-35.21,18.11,16.86),(-38.13,16.48,13.06),(-24.89,16.12,28.73),(-28.72,18.18,24.89),(-28.72,25.41,24.89),(-32.12,20.91,20.73),(-24.89,21.02,28.73),(-38.02,20.05,13.06),(-35.13,24.77,16.02),(-15.79,16.12,34.57),(-20.55,18.18,31.97),(-5.41,16.12,37.63),(-10.71,18.18,36.47),(-10.71,25.41,36.47),(-15.79,21.02,34.57),(-5.41,21.02,37.63),(-20.55,25.41,31.97),(5.408,16.12,37.61),(-0.002326,18.18,38.01),(15.79,16.12,34.58),(10.71,18.18,36.47),(10.71,25.41,36.47),(5.408,21.02,37.61),(15.79,21.02,34.58),(-0.002325,25.41,38.01),(24.88,16.12,28.72),(20.55,18.18,31.97),(31.98,16.12,20.55),(28.72,18.18,24.89),(28.72,25.41,24.89),(24.88,21.02,28.72),(31.98,21.02,20.55),(20.55,25.41,31.97),(36.46,16.12,10.71),(34.57,18.18,15.79),(37.62,18.18,5.406),(37.62,25.41,5.406),(36.46,21.02,10.71),(34.57,25.41,15.79),(36.46,32.12,-10.71),(37.62,40,-5.406),(38.02,32.12,0),(31.98,32.12,-20.55),(34.57,40,-15.79),(34.57,54.59,-15.79),(36.46,47.88,-10.71),(31.98,47.88,-20.55),(38.02,47.88,0),(37.62,54.59,-5.406),(24.88,32.12,-28.72),(28.72,40,-24.89),(15.79,32.12,-34.58),(20.55,40,-31.97),(20.55,54.59,-31.97),(24.88,47.88,-28.72),(15.79,47.88,-34.58),(28.72,54.59,-24.89),(5.408,32.12,-37.61),(10.71,40,-36.47),(-5.41,32.12,-37.63),(-0.002338,40,-38.01),(-0.002338,54.59,-38.01),(5.408,47.88,-37.61),(-5.41,47.88,-37.63),(10.71,54.59,-36.47),(-15.79,32.12,-34.57),(-10.71,40,-36.47),(-24.89,32.12,-28.73),(-20.55,40,-31.97),(-20.55,54.59,-31.97),(-15.79,47.88,-34.57),(-24.89,47.88,-28.73),(-10.71,54.59,-36.47),(-32.05,32.02,-20.55),(-28.72,40,-24.89),(-37.02,31.51,-10.77),(-34.73,40,-15.81),(-35.13,55.23,-16.02),(-32.05,47.98,-20.55),(-37.02,48.49,-10.77),(-28.72,54.59,-24.89),(-39.16,25.08,-5.323),(-38.57,32.05,0),(-37.91,40,-5.431),(-37.02,31.51,10.77),(-37.91,40,5.431),(-39.16,25.08,5.323),(-39.16,54.92,5.323),(-38.57,47.95,0),(-37.02,48.49,10.77),(-39.16,54.92,-5.323),(-32.05,32.02,20.55),(-34.73,40,15.81),(-24.89,32.12,28.73),(-28.72,40,24.89),(-28.72,54.59,24.89),(-32.05,47.98,20.55),(-24.89,47.88,28.73),(-35.13,55.23,16.02),(-15.79,32.12,34.57),(-20.55,40,31.97),(-5.41,32.12,37.63),(-10.71,40,36.47),(-10.71,54.59,36.47),(-15.79,47.88,34.57),(-5.41,47.88,37.63),(-20.55,54.59,31.97),(5.408,32.12,37.61),(-0.002325,40,38.01),(15.79,32.12,34.58),(10.71,40,36.47),(10.71,54.59,36.47),(5.408,47.88,37.61),(15.79,47.88,34.58),(-0.002325,54.59,38.01),(24.88,32.12,28.72),(20.55,40,31.97),(31.98,32.12,20.55),(28.72,40,24.89),(28.72,54.59,24.89),(24.88,47.88,28.72),(31.98,47.88,20.55),(20.55,54.59,31.97),(36.46,32.12,10.71),(34.57,40,15.79),(37.62,40,5.406),(37.62,54.59,5.406),(36.46,47.88,10.71),(34.57,54.59,15.79),(36.46,58.98,-10.71),(37.62,61.82,-5.406),(38.02,58.98,0),(31.98,58.98,-20.55),(34.57,61.82,-15.79),(34.57,65.94,-15.79),(36.46,63.88,-10.71),(31.98,63.88,-20.55),(38.02,63.88,0),(37.62,65.94,-5.406),(24.88,58.98,-28.72),(28.72,61.82,-24.89),(15.79,58.98,-34.58),(20.55,61.82,-31.97),(20.55,65.94,-31.97),(24.88,63.88,-28.72),(15.79,63.88,-34.58),(28.72,65.94,-24.89),(5.408,58.98,-37.61),(10.71,61.82,-36.47),(-5.41,58.98,-37.63),(-0.002339,61.82,-38.01),(-0.002339,65.94,-38.01),(5.408,63.88,-37.61),(-5.41,63.88,-37.63),(10.71,65.94,-36.47),(-15.79,58.98,-34.57),(-10.71,61.82,-36.47),(-24.89,58.98,-28.73),(-20.55,61.82,-31.97),(-20.55,65.94,-31.97),(-15.79,63.88,-34.57),(-24.89,63.88,-28.73),(-10.71,65.94,-36.47),(-32.12,59.09,-20.73),(-28.72,61.82,-24.89),(-38.02,59.95,-13.06),(-35.21,61.89,-16.86),(-35.18,65.72,-16.02),(-32.13,63.84,-20.73),(-38.13,63.52,-13.06),(-28.72,65.94,-24.89),(-32.12,59.09,20.73),(-35.21,61.89,16.86),(-38.02,59.95,13.06),(-24.89,58.98,28.73),(-28.72,61.82,24.89),(-28.72,65.94,24.89),(-32.13,63.84,20.73),(-24.89,63.88,28.73),(-38.13,63.52,13.06),(-35.18,65.72,16.02),(-15.79,58.98,34.57),(-20.55,61.82,31.97),(-5.41,58.98,37.63),(-10.71,61.82,36.47),(-10.71,65.94,36.47),(-15.79,63.88,34.57),(-5.41,63.88,37.63),(-20.55,65.94,31.97),(5.408,58.98,37.61),(-0.002326,61.82,38.01),(15.79,58.98,34.58),(10.71,61.82,36.47),(10.71,65.94,36.47),(5.408,63.88,37.61),(15.79,63.88,34.58),(-0.002326,65.94,38.01),(24.88,58.98,28.72),(20.55,61.82,31.97),(31.98,58.98,20.55),(28.72,61.82,24.89),(28.72,65.94,24.89),(24.88,63.88,28.72),(31.98,63.88,20.55),(20.55,65.94,31.97),(36.46,58.98,10.71),(34.57,61.82,15.79),(37.62,61.82,5.406),(37.62,65.94,5.406),(36.46,63.88,10.71),(34.57,65.94,15.79),(36.46,68.78,-10.71),(37.68,71.99,-5.415),(38.02,68.78,0),(31.98,68.78,-20.55),(34.63,71.99,-15.82),(35.14,77.97,-16.05),(36.7,75.19,-10.78),(32.19,75.19,-20.69),(38.27,75.19,0),(38.24,77.97,-5.496),(24.88,68.78,-28.72),(28.77,71.99,-24.93),(15.79,68.78,-34.58),(20.58,71.99,-32.03),(20.89,77.97,-32.51),(25.05,75.19,-28.91),(15.9,75.19,-34.81),(29.2,77.97,-25.3),(5.408,68.78,-37.61),(10.73,71.99,-36.53),(-5.41,68.78,-37.63),(-0.002343,71.99,-38.07),(-0.002378,77.97,-38.64),(5.444,75.19,-37.86),(-5.446,75.19,-37.88),(10.89,77.97,-37.07),(-15.79,68.78,-34.57),(-10.72,71.99,-36.53),(-24.89,68.78,-28.73),(-20.58,71.99,-32.02),(-20.89,77.97,-32.5),(-15.89,75.19,-34.79),(-25.06,75.19,-28.92),(-10.88,77.97,-37.07),(-32.06,68.74,-20.55),(-28.77,71.99,-24.93),(-37.1,68.58,-10.77),(-34.72,71.95,-15.82),(-35.15,77.97,-16.05),(-32.18,75.19,-20.68),(-36.72,75.19,-10.78),(-29.2,77.97,-25.3),(-39.47,66.03,-5.323),(-38.71,68.85,0),(-37.86,71.98,-5.43),(-37.1,68.58,10.77),(-37.86,71.98,5.43),(-39.47,66.03,5.323),(-38.24,77.97,5.501),(-38.25,75.19,0),(-36.72,75.19,10.78),(-38.24,77.97,-5.501),(-32.06,68.74,20.55),(-34.72,71.95,15.82),(-24.89,68.78,28.73),(-28.77,71.99,24.93),(-29.2,77.97,25.3),(-32.18,75.19,20.68),(-25.06,75.19,28.92),(-35.15,77.97,16.05),(-15.79,68.78,34.57),(-20.58,71.99,32.02),(-5.41,68.78,37.63),(-10.72,71.99,36.53),(-10.88,77.97,37.07),(-15.89,75.19,34.79),(-5.446,75.19,37.88),(-20.89,77.97,32.5),(5.408,68.78,37.61),(-0.00233,71.99,38.07),(15.79,68.78,34.58),(10.73,71.99,36.53),(10.89,77.97,37.07),(5.444,75.19,37.86),(15.9,75.19,34.81),(-0.002365,77.97,38.64),(24.88,68.78,28.72),(20.58,71.99,32.03),(31.98,68.78,20.55),(28.77,71.99,24.93),(29.2,77.97,25.3),(25.05,75.19,28.91),(32.19,75.19,20.69),(20.89,77.97,32.51),(36.46,68.78,10.71),(34.63,71.99,15.82),(37.68,71.99,5.415),(38.24,77.97,5.496),(36.7,75.19,10.78),(35.14,77.97,16.05),(40.32,82.53,-5.795),(38.79,82.81,-11.39),(39.35,82.91,-5.656),(40.45,82.81,0),(34.03,82.81,-21.87),(36.16,82.91,-16.52),(37.06,82.53,-16.93),(34.4,82.53,-15.71),(37.26,82.81,-10.94),(32.68,82.81,-21),(38.85,82.81,0),(37.43,82.53,-5.38),(30.79,82.53,-26.68),(26.48,82.81,-30.56),(30.05,82.91,-26.03),(16.8,82.81,-36.8),(21.49,82.91,-33.45),(22.02,82.53,-34.27),(20.44,82.53,-31.82),(25.43,82.81,-29.35),(16.14,82.81,-35.34),(28.58,82.53,-24.76),(11.48,82.53,-39.09),(5.754,82.81,-40.02),(11.2,82.91,-38.15),(-5.757,82.81,-40.04),(-0.002448,82.91,-39.76),(-0.002508,82.53,-40.74),(-0.002328,82.53,-37.82),(5.526,82.81,-38.43),(-5.528,82.81,-38.45),(10.66,82.53,-36.28),(-11.48,82.53,-39.09),(-16.8,82.81,-36.78),(-11.2,82.91,-38.15),(-26.49,82.81,-30.57),(-21.5,82.91,-33.45),(-22.03,82.53,-34.27),(-20.45,82.53,-31.81),(-16.13,82.81,-35.32),(-25.44,82.81,-29.36),(-10.65,82.53,-36.29),(-30.79,82.53,-26.68),(-34.01,82.81,-21.86),(-30.05,82.91,-26.04),(-38.81,82.81,-11.4),(-36.17,82.91,-16.51),(-37.06,82.53,-16.92),(-34.4,82.53,-15.71),(-32.67,82.81,-20.99),(-37.27,82.81,-10.94),(-28.58,82.53,-24.77),(-40.32,82.53,-5.8),(-40.43,82.81,0),(-39.35,82.91,-5.661),(-38.81,82.81,11.4),(-39.35,82.91,5.661),(-40.32,82.53,5.8),(-37.43,82.53,5.384),(-38.83,82.81,0),(-37.27,82.81,10.94),(-37.43,82.53,-5.384),(-37.06,82.53,16.92),(-34.01,82.81,21.86),(-36.17,82.91,16.51),(-26.49,82.81,30.57),(-30.05,82.91,26.04),(-30.79,82.53,26.68),(-28.58,82.53,24.77),(-32.67,82.81,20.99),(-25.44,82.81,29.36),(-34.4,82.53,15.71),(-22.03,82.53,34.27),(-16.8,82.81,36.78),(-21.5,82.91,33.45),(-5.757,82.81,40.04),(-11.2,82.91,38.15),(-11.48,82.53,39.09),(-10.65,82.53,36.29),(-16.13,82.81,35.32),(-5.528,82.81,38.45),(-20.45,82.53,31.81),(-0.002493,82.53,40.74),(5.754,82.81,40.02),(-0.002433,82.91,39.76),(16.8,82.81,36.8),(11.2,82.91,38.15),(11.48,82.53,39.09),(10.66,82.53,36.28),(5.526,82.81,38.43),(16.14,82.81,35.34),(-0.002314,82.53,37.82),(22.02,82.53,34.27),(26.48,82.81,30.56),(21.49,82.91,33.45),(34.03,82.81,21.87),(30.05,82.91,26.03),(30.79,82.53,26.68),(28.58,82.53,24.76),(25.43,82.81,29.35),(32.68,82.81,21),(20.44,82.53,31.82),(37.06,82.53,16.93),(38.79,82.81,11.39),(36.16,82.91,16.52),(39.35,82.91,5.656),(40.32,82.53,5.795),(37.43,82.53,5.38),(37.26,82.81,10.94),(34.4,82.53,15.71),(12.34,2,0),(20.61,2.047,-3.654),(19.32,2.047,-8.07),(10.38,2,-6.673),(29.75,2.469,-4.343),(25.45,2.188,-7.473),(25.59,2.188,0),(21.52,2.188,-13.83),(27.38,2.469,-12.43),(15.37,2.047,-14.22),(11.89,2.047,-17.23),(5.127,2,-11.23),(22.68,2.469,-19.74),(17.37,2.188,-20.05),(10.63,2.188,-23.27),(16.31,2.469,-25.26),(5.239,2.047,-20.27),(0.6834,2.047,-20.92),(-1.756,2,-12.22),(8.409,2.469,-28.87),(3.775,2.188,-26.26),(-3.641,2.188,-25.32),(0.06458,2.469,-30.07),(-6.551,2.047,-19.88),(-10.74,2.047,-17.97),(-8.082,2,-9.328),(-8.533,2.469,-28.83),(-11.02,2.188,-24.13),(-16.75,2.188,-19.34),(-16.2,2.469,-25.33),(-16.26,2.047,-13.19),(-18.75,2.047,-9.314),(-11.84,2,-3.477),(-22.76,2.469,-19.64),(-22.32,2.188,-14.34),(-24.55,2.188,-7.208),(-27.32,2.469,-12.55),(-20.81,2.047,-2.301),(-20.81,2.047,2.301),(-11.84,2,3.477),(-29.77,2.469,-4.215),(-26.53,2.188,0),(-24.55,2.188,7.208),(-29.77,2.469,4.215),(-18.75,2.047,9.314),(-16.26,2.047,13.19),(-8.082,2,9.328),(-27.32,2.469,12.55),(-22.32,2.188,14.34),(-16.75,2.188,19.34),(-22.76,2.469,19.64),(-10.74,2.047,17.97),(-6.551,2.047,19.88),(-1.756,2,12.22),(-16.2,2.469,25.33),(-11.02,2.188,24.13),(-3.641,2.188,25.32),(-8.533,2.469,28.83),(0.6835,2.047,20.92),(5.239,2.047,20.27),(5.127,2,11.23),(0.0646,2.469,30.07),(3.775,2.188,26.26),(10.63,2.188,23.27),(8.409,2.469,28.87),(11.89,2.047,17.23),(15.37,2.047,14.22),(10.38,2,6.673),(16.31,2.469,25.26),(17.37,2.188,20.05),(21.52,2.188,13.83),(22.68,2.469,19.74),(19.32,2.047,8.07),(20.61,2.047,3.654),(27.38,2.469,12.43),(25.45,2.188,7.473),(29.75,2.469,4.343),(36.46,0.0625,-10.71),(34.3,-1.25,-15.67),(31.98,0.0625,-20.55),(38.02,0.0625,0),(37.32,-1.25,-5.364),(35.32,-2.063,-10.37),(36.83,-2.063,0),(30.98,-2.063,-19.91),(24.88,0.0625,-28.72),(20.38,-1.25,-31.72),(15.79,0.0625,-34.58),(28.5,-1.25,-24.69),(24.11,-2.063,-27.82),(15.3,-2.063,-33.5),(5.408,0.0625,-37.61),(-0.002321,-1.25,-37.71),(-5.41,0.0625,-37.63),(10.63,-1.25,-36.18),(5.239,-2.063,-36.44),(-5.241,-2.063,-36.45),(-15.79,0.0625,-34.57),(-20.39,-1.25,-31.72),(-24.89,0.0625,-28.73),(-10.62,-1.25,-36.18),(-15.29,-2.063,-33.48),(-24.12,-2.063,-27.83),(-31.97,0.0625,-20.54),(-34.3,-1.25,-15.66),(-36.48,0.0625,-10.71),(-28.5,-1.25,-24.7),(-30.97,-2.063,-19.9),(-35.34,-2.063,-10.38),(-38,0.0625,0),(-37.32,-1.25,5.369),(-36.48,0.0625,10.71),(-37.32,-1.25,-5.369),(-36.81,-2.063,0),(-35.34,-2.063,10.38),(-31.97,0.0625,20.54),(-28.5,-1.25,24.7),(-24.89,0.0625,28.73),(-34.3,-1.25,15.66),(-30.97,-2.063,19.9),(-24.12,-2.063,27.83),(-15.79,0.0625,34.57),(-10.62,-1.25,36.18),(-5.41,0.0625,37.63),(-20.39,-1.25,31.72),(-15.29,-2.063,33.48),(-5.241,-2.063,36.45),(5.408,0.0625,37.61),(10.63,-1.25,36.18),(15.79,0.0625,34.58),(-0.002308,-1.25,37.71),(5.239,-2.063,36.44),(15.3,-2.063,33.5),(24.88,0.0625,28.72),(28.5,-1.25,24.69),(31.98,0.0625,20.55),(20.38,-1.25,31.72),(24.11,-2.063,27.82),(30.98,-2.063,19.91),(36.46,0.0625,10.71),(37.32,-1.25,5.364),(34.3,-1.25,15.67),(35.32,-2.063,10.37),(34.29,68.75,-4.928),(32.91,56.75,-9.663),(33.79,42.5,-4.856),(34.31,56.75,0),(28.87,56.75,-18.55),(31.05,42.5,-14.18),(31.51,68.75,-14.39),(31,16.25,-14.16),(32.69,28.25,-9.599),(28.68,28.25,-18.43),(34.09,28.25,0),(33.73,16.25,-4.848),(26.18,68.75,-22.69),(22.46,56.75,-25.92),(25.8,42.5,-22.35),(14.25,56.75,-31.21),(18.45,42.5,-28.72),(18.73,68.75,-29.15),(18.42,16.25,-28.67),(22.31,28.25,-25.75),(14.16,28.25,-31.01),(25.76,16.25,-22.32),(9.763,68.75,-33.24),(4.881,56.75,-33.95),(9.619,42.5,-32.75),(-4.883,56.75,-33.97),(-0.002102,42.5,-34.14),(-0.002133,68.75,-34.65),(-0.002098,16.25,-34.08),(4.849,28.25,-33.73),(-4.851,28.25,-33.74),(9.603,16.25,-32.7),(-9.759,68.75,-33.24),(-14.25,56.75,-31.2),(-9.615,42.5,-32.75),(-22.47,56.75,-25.93),(-18.46,42.5,-28.72),(-18.73,68.75,-29.14),(-18.43,16.25,-28.67),(-14.15,28.25,-30.99),(-22.32,28.25,-25.76),(-9.599,16.25,-32.7),(-26.18,68.75,-22.69),(-28.85,56.75,-18.54),(-25.8,42.5,-22.36),(-32.92,56.75,-9.667),(-31.05,42.5,-14.18),(-31.52,68.75,-14.39),(-31,16.25,-14.15),(-28.66,28.25,-18.42),(-32.71,28.25,-9.604),(-25.75,16.25,-22.32),(-34.29,68.75,-4.933),(-34.3,56.75,0),(-33.79,42.5,-4.86),(-32.92,56.75,9.667),(-33.79,42.5,4.86),(-34.29,68.75,4.933),(-33.73,16.25,4.852),(-34.07,28.25,0),(-32.71,28.25,9.604),(-33.73,16.25,-4.852),(-31.52,68.75,14.39),(-28.85,56.75,18.54),(-31.05,42.5,14.18),(-22.47,56.75,25.93),(-25.8,42.5,22.36),(-26.18,68.75,22.69),(-25.75,16.25,22.32),(-28.66,28.25,18.42),(-22.32,28.25,25.76),(-31,16.25,14.15),(-18.73,68.75,29.14),(-14.25,56.75,31.2),(-18.46,42.5,28.72),(-4.883,56.75,33.97),(-9.615,42.5,32.75),(-9.759,68.75,33.24),(-9.599,16.25,32.7),(-14.15,28.25,30.99),(-4.851,28.25,33.74),(-18.43,16.25,28.67),(-0.00212,68.75,34.65),(4.881,56.75,33.95),(-0.002089,42.5,34.14),(14.25,56.75,31.21),(9.619,42.5,32.75),(9.763,68.75,33.24),(9.603,16.25,32.7),(4.849,28.25,33.73),(14.16,28.25,31.01),(-0.002086,16.25,34.08),(18.73,68.75,29.15),(22.46,56.75,25.92),(18.45,42.5,28.72),(28.87,56.75,18.55),(25.8,42.5,22.35),(26.18,68.75,22.69),(25.76,16.25,22.32),(22.31,28.25,25.75),(28.68,28.25,18.43),(18.42,16.25,28.67),(31.51,68.75,14.39),(32.91,56.75,9.663),(31.05,42.5,14.18),(33.79,42.5,4.856),(34.29,68.75,4.928),(33.73,16.25,4.848),(32.69,28.25,9.599),(31,16.25,14.16),(32.69,8.75,-9.599),(33.33,4.672,-4.797),(34.09,8.75,0),(28.68,8.75,-18.43),(30.64,4.672,-13.99),(31.24,2.938,-9.174),(27.25,2.938,-17.51),(32.39,2.938,0),(22.31,8.75,-25.75),(25.45,4.672,-22.06),(14.16,8.75,-31.01),(18.21,4.672,-28.33),(21.32,2.938,-24.61),(13.45,2.938,-29.46),(4.849,8.75,-33.73),(9.484,4.672,-32.31),(-4.851,8.75,-33.74),(0.00457,4.672,-33.68),(4.634,2.938,-32.23),(-4.609,2.938,-32.06),(-14.15,8.75,-30.99),(-9.492,4.672,-32.31),(-22.32,8.75,-25.76),(-18.2,4.672,-28.33),(-13.53,2.938,-29.62),(-21.21,2.938,-24.48),(-28.66,8.75,-18.42),(-25.45,4.672,-22.05),(-32.71,8.75,-9.604),(-30.63,4.672,-13.99),(-27.39,2.938,-17.61),(-31.08,2.938,-9.125),(-34.07,8.75,0),(-33.34,4.672,-4.788),(-32.71,8.75,9.604),(-33.34,4.672,4.788),(-32.56,2.938,0),(-31.08,2.938,9.125),(-28.66,8.75,18.42),(-30.63,4.672,13.99),(-22.32,8.75,25.76),(-25.45,4.672,22.05),(-27.39,2.938,17.61),(-21.21,2.938,24.48),(-14.15,8.75,30.99),(-18.2,4.672,28.33),(-4.851,8.75,33.74),(-9.492,4.672,32.31),(-13.53,2.938,29.62),(-4.609,2.938,32.06),(4.849,8.75,33.73),(0.004582,4.672,33.68),(14.16,8.75,31.01),(9.484,4.672,32.31),(4.634,2.938,32.23),(13.45,2.938,29.46),(22.31,8.75,25.75),(18.21,4.672,28.33),(28.68,8.75,18.43),(25.45,4.672,22.06),(21.32,2.938,24.61),(27.25,2.938,17.51),(32.69,8.75,9.599),(30.64,4.672,13.99),(33.33,4.672,4.797),(31.24,2.938,9.174),(37.67,79.94,-11.06),(39.55,81.25,-5.684),(39.28,79.94,0),(33.04,79.94,-21.24),(36.35,81.25,-16.6),(38.87,82.06,-11.41),(34.09,82.06,-21.91),(40.53,82.06,0),(25.71,79.94,-29.67),(30.2,81.25,-26.17),(16.32,79.94,-35.73),(21.6,81.25,-33.62),(26.53,82.06,-30.61),(16.83,82.06,-36.86),(5.588,79.94,-38.86),(11.26,81.25,-38.34),(-5.59,79.94,-38.88),(-0.002459,81.25,-39.96),(5.765,82.06,-40.1),(-5.767,82.06,-40.11),(-16.31,79.94,-35.71),(-11.26,81.25,-38.34),(-25.72,79.94,-29.69),(-21.61,81.25,-33.61),(-16.83,82.06,-36.85),(-26.54,82.06,-30.63),(-33.03,79.94,-21.23),(-30.2,81.25,-26.17),(-37.69,79.94,-11.07),(-36.35,81.25,-16.6),(-34.08,82.06,-21.9),(-38.88,82.06,-11.42),(-39.26,79.94,0),(-39.55,81.25,-5.689),(-37.69,79.94,11.07),(-39.55,81.25,5.689),(-40.51,82.06,0),(-38.88,82.06,11.42),(-33.03,79.94,21.23),(-36.35,81.25,16.6),(-25.72,79.94,29.69),(-30.2,81.25,26.17),(-34.08,82.06,21.9),(-26.54,82.06,30.63),(-16.31,79.94,35.71),(-21.61,81.25,33.61),(-5.59,79.94,38.88),(-11.26,81.25,38.34),(-16.83,82.06,36.85),(-5.767,82.06,40.11),(5.588,79.94,38.86),(-0.002446,81.25,39.96),(16.32,79.94,35.73),(11.26,81.25,38.34),(5.765,82.06,40.1),(16.83,82.06,36.86),(25.71,79.94,29.67),(21.6,81.25,33.62),(33.04,79.94,21.24),(30.2,81.25,26.17),(26.53,82.06,30.61),(34.09,82.06,21.91),(37.67,79.94,11.06),(36.35,81.25,16.6),(39.55,81.25,5.684),(38.87,82.06,11.41),(33.78,76.25,-9.919),(32.71,80.33,-14.94),(29.63,76.25,-19.04),(35.22,76.25,0),(35.59,80.33,-5.115),(35.35,82.06,-10.38),(36.85,82.06,0),(31,82.06,-19.92),(23.05,76.25,-26.61),(19.44,80.33,-30.25),(14.63,76.25,-32.04),(27.18,80.33,-23.55),(24.12,82.06,-27.84),(15.31,82.06,-33.52),(5.01,76.25,-34.85),(-0.002214,80.33,-35.96),(-5.013,76.25,-34.86),(10.13,80.33,-34.5),(5.242,82.06,-36.46),(-5.245,82.06,-36.48),(-14.63,76.25,-32.02),(-19.44,80.33,-30.25),(-23.07,76.25,-26.62),(-10.13,80.33,-34.5),(-15.3,82.06,-33.51),(-24.13,82.06,-27.85),(-29.62,76.25,-19.03),(-32.71,80.33,-14.94),(-33.79,76.25,-9.923),(-27.18,80.33,-23.55),(-30.99,82.06,-19.92),(-35.36,82.06,-10.38),(-35.21,76.25,0),(-35.59,80.33,5.12),(-33.79,76.25,9.923),(-35.59,80.33,-5.12),(-36.84,82.06,0),(-35.36,82.06,10.38),(-29.62,76.25,19.03),(-27.18,80.33,23.55),(-23.07,76.25,26.62),(-32.71,80.33,14.94),(-30.99,82.06,19.92),(-24.13,82.06,27.85),(-14.63,76.25,32.02),(-10.13,80.33,34.5),(-5.013,76.25,34.86),(-19.44,80.33,30.25),(-15.3,82.06,33.51),(-5.245,82.06,36.48),(5.01,76.25,34.85),(10.13,80.33,34.5),(14.63,76.25,32.04),(-0.002201,80.33,35.96),(5.242,82.06,36.46),(15.31,82.06,33.52),(23.05,76.25,26.61),(27.18,80.33,23.55),(29.63,76.25,19.04),(19.44,80.33,30.25),(24.12,82.06,27.84),(31,82.06,19.92),(33.78,76.25,9.919),(35.59,80.33,5.115),(32.71,80.33,14.94),(35.35,82.06,10.38),(-40.96,58.33,1.022e-005),(-42.84,60.23,-4.384),(-40.62,59.47,-8.845),(-40.62,59.47,8.845),(-42.84,60.23,4.384),(-46.91,60.09,4.226),(-44.85,60.49,1.189e-005),(-45.07,60.83,7.748),(-45.07,60.83,-7.748),(-46.91,60.09,-4.226),(-40.76,62.08,-11.77),(-43.54,62.75,-10.17),(-41.13,64,-8.845),(-43.07,61.31,-10.17),(-47.49,60.67,-9.861),(-45.7,61.76,-10.56),(-46.32,62.69,-7.748),(-48.35,61.53,-9.861),(-41.69,64.67,0),(-43.96,63.63,4.384),(-41.13,64,8.845),(-43.96,63.63,-4.384),(-48.93,62.11,-4.226),(-46.55,63.03,1.082e-005),(-46.32,62.69,7.748),(-48.93,62.11,4.226),(-40.76,62.08,11.77),(-43.07,61.31,10.17),(-43.54,62.75,10.17),(-48.35,61.53,9.861),(-45.7,61.76,10.56),(-47.49,60.67,9.861),(-51.24,60.84,1.249e-005),(-53.11,58.99,4.21),(-50.9,60.62,7.748),(-50.9,60.62,-7.748),(-53.11,58.99,-4.21),(-56.12,54.05,-4.064),(-54.88,56.77,1.414e-005),(-54.47,56.67,-7.629),(-54.47,56.67,7.629),(-56.12,54.05,4.064),(-49.96,59.99,-10.56),(-52.35,58.67,-9.823),(-49.03,59.37,-7.748),(-51.22,58.19,-9.823),(-53.97,53.8,-9.483),(-53.35,56.4,-10.4),(-52.23,56.12,-7.629),(-55.26,53.95,-9.483),(-48.69,59.14,1.356e-005),(-50.46,57.87,-4.21),(-49.03,59.37,7.748),(-50.46,57.87,4.21),(-53.11,53.7,4.064),(-51.82,56.02,1.521e-005),(-52.23,56.12,7.629),(-53.11,53.7,-4.064),(-49.96,59.99,10.56),(-51.22,58.19,9.823),(-52.35,58.67,9.823),(-55.26,53.95,9.483),(-53.35,56.4,10.4),(-53.97,53.8,9.483),(-41.69,15.33,0),(-43.96,16.37,-4.384),(-41.13,16,-8.845),(-41.13,16,8.845),(-43.96,16.37,4.384),(-48.93,17.89,4.226),(-46.55,16.97,1.094e-005),(-46.32,17.31,7.748),(-46.32,17.31,-7.748),(-48.93,17.89,-4.226),(-40.76,17.92,-11.77),(-43.07,18.69,-10.17),(-40.62,20.53,-8.845),(-43.54,17.25,-10.17),(-48.35,18.47,-9.861),(-45.7,18.24,-10.56),(-45.07,19.17,-7.748),(-47.49,19.33,-9.861),(-40.96,21.67,0),(-42.84,19.77,4.384),(-40.62,20.53,8.845),(-42.84,19.77,-4.384),(-46.91,19.91,-4.226),(-44.85,19.51,1.082e-005),(-45.07,19.17,7.748),(-46.91,19.91,4.226),(-40.76,17.92,11.77),(-43.54,17.25,10.17),(-43.07,18.69,10.17),(-47.49,19.33,9.861),(-45.7,18.24,10.56),(-48.35,18.47,9.861),(-48.69,20.86,1.249e-005),(-50.46,22.13,4.21),(-49.03,20.63,7.748),(-49.03,20.63,-7.748),(-50.46,22.13,-4.21),(-53.11,26.3,-4.064),(-51.82,23.98,1.417e-005),(-52.23,23.88,-7.629),(-52.23,23.88,7.629),(-53.11,26.3,4.064),(-49.96,20.01,-10.56),(-51.22,21.81,-9.823),(-50.9,19.38,-7.748),(-52.35,21.33,-9.823),(-55.26,26.05,-9.483),(-53.35,23.6,-10.4),(-54.47,23.33,-7.629),(-53.97,26.2,-9.483),(-51.24,19.16,1.261e-005),(-53.11,21.01,-4.21),(-50.9,19.38,7.748),(-53.11,21.01,4.21),(-56.12,25.95,4.064),(-54.88,23.23,1.438e-005),(-54.47,23.33,7.629),(-56.12,25.95,-4.064),(-49.96,20.01,10.56),(-52.35,21.33,9.823),(-51.22,21.81,9.823),(-53.97,26.2,9.483),(-53.35,23.6,10.4),(-55.26,26.05,9.483),(-53.89,29.23,1.656e-005),(-54.61,32.58,3.724),(-54.33,29.21,7.154),(-54.33,29.21,-7.154),(-54.61,32.58,-3.724),(-55.06,40,-3.514),(-54.84,36.22,1.872e-005),(-55.29,36.22,-6.561),(-55.29,36.22,6.561),(-55.06,40,3.514),(-55.55,29.15,-9.756),(-55.5,32.57,-8.69),(-56.76,29.1,-7.154),(-56.85,32.55,-8.69),(-57.31,40,-8.199),(-56.53,36.22,-8.946),(-57.76,36.22,-6.561),(-55.96,40,-8.199),(-57.2,29.08,1.629e-005),(-57.74,32.54,-3.724),(-56.76,29.1,7.154),(-57.74,32.54,3.724),(-58.21,40,3.514),(-58.21,36.22,1.809e-005),(-57.76,36.22,6.561),(-58.21,40,-3.514),(-55.55,29.15,9.756),(-56.85,32.55,8.69),(-55.5,32.57,8.69),(-55.96,40,8.199),(-56.53,36.22,8.946),(-57.31,40,8.199),(-57.2,50.92,1.629e-005),(-57.74,47.46,3.724),(-56.76,50.9,7.154),(-56.76,50.9,-7.154),(-57.74,47.46,-3.724),(-58.21,43.78,1.809e-005),(-57.76,43.78,-6.561),(-57.76,43.78,6.561),(-55.55,50.85,-9.756),(-56.85,47.45,-8.69),(-54.33,50.79,-7.154),(-55.5,47.43,-8.69),(-56.53,43.78,-8.946),(-55.29,43.78,-6.561),(-53.89,50.77,1.718e-005),(-54.61,47.42,-3.724),(-54.33,50.79,7.154),(-54.61,47.42,3.724),(-54.84,43.78,1.889e-005),(-55.29,43.78,6.561),(-55.55,50.85,9.756),(-55.5,47.43,8.69),(-56.85,47.45,8.69),(-56.53,43.78,8.946)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for UnitCup.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python UnitCup.py load and self-test diagnostics complete.")
