package Basic.Units;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Units component example. </p>
 <p> Related links: Catalog page <a href="../../../Units/UnitClamidomonasIndex.html" target="_blank">UnitClamidomonas</a>,  source <a href="../../../Units/UnitClamidomonas.java">UnitClamidomonas.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Units/UnitClamidomonas.x3d">UnitClamidomonas.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Units component example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Myeong Won Lee </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 August 2009 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Units/UnitExamples.pdf">UnitExamples.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd" target="_blank">http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D UNIT statement </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Units/UnitClamidomonas.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Units/UnitClamidomonas.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Units/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Myeong Won Lee
 */

public class UnitClamidomonas
{
	/** Default constructor to create this object. */
	public UnitClamidomonas ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addUnit(new unit().setName("millimeters").setCategory("length").setConversionFactor(0.001))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("UnitClamidomonas.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Units component example"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Myeong Won Lee"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 August 2009"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("UnitExamples.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D UNIT statement"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Units/UnitClamidomonas.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("UnitClamidomonas.x3d"))
    .addChild(new Viewpoint().setDescription("1M view").setPosition(0.0,0.0,1.0))
    .addChild(new NavigationInfo())
    .addChild(new Background().setGroundColor(new MFColor(new double[] {0.05,0.1,0.3})).setSkyColor(new MFColor(new double[] {0.05,0.1,0.3})))
    .addChild(new Transform().setScale(0.5,0.5,0.91).setTranslation(10.0,0.0,0.0)
      .addChild(new Viewpoint().setDescription("Clamidomonas").setPosition(0.0,0.0,1.0))
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.8784,0.7765,0.3412)))
        .setGeometry(new IndexedFaceSet().setCoordIndex(getIndexedFaceSet_5_22_coordIndex())
          .setCoord(new Coordinate().setPoint(getCoordinate_6_22_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_5_22_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,2,3,-1,0,3,4,-1,0,4,5,-1,0,5,6,-1,0,6,7,-1,0,7,8,-1,0,8,9,-1,0,9,10,-1,0,10,11,-1,0,11,12,-1,0,12,13,-1,0,13,14,-1,0,14,15,-1,0,15,16,-1,0,16,17,-1,0,17,18,-1,0,18,19,-1,0,19,20,-1,0,20,21,-1,0,21,22,-1,0,22,23,-1,0,23,24,-1,0,24,25,-1,0,25,26,-1,0,26,27,-1,0,27,28,-1,0,28,29,-1,0,29,30,-1,0,30,31,-1,0,31,32,-1,0,32,1,-1,1,33,34,-1,1,34,2,-1,2,34,35,-1,2,35,3,-1,3,35,36,-1,3,36,4,-1,4,36,37,-1,4,37,5,-1,5,37,38,-1,5,38,6,-1,6,38,39,-1,6,39,7,-1,7,39,40,-1,7,40,8,-1,8,40,41,-1,8,41,9,-1,9,41,42,-1,9,42,10,-1,10,42,43,-1,10,43,11,-1,11,43,44,-1,11,44,12,-1,12,44,45,-1,12,45,13,-1,13,45,46,-1,13,46,14,-1,14,46,47,-1,14,47,15,-1,15,47,48,-1,15,48,16,-1,16,48,49,-1,16,49,17,-1,17,49,50,-1,17,50,18,-1,18,50,51,-1,18,51,19,-1,19,51,52,-1,19,52,20,-1,20,52,53,-1,20,53,21,-1,21,53,54,-1,21,54,22,-1,22,54,55,-1,22,55,23,-1,23,55,56,-1,23,56,24,-1,24,56,57,-1,24,57,25,-1,25,57,58,-1,25,58,26,-1,26,58,59,-1,26,59,27,-1,27,59,60,-1,27,60,28,-1,28,60,61,-1,28,61,29,-1,29,61,62,-1,29,62,30,-1,30,62,63,-1,30,63,31,-1,31,63,64,-1,31,64,32,-1,32,64,33,-1,32,33,1,-1,33,65,66,-1,33,66,34,-1,34,66,67,-1,34,67,35,-1,35,67,68,-1,35,68,36,-1,36,68,69,-1,36,69,37,-1,37,69,70,-1,37,70,38,-1,38,70,71,-1,38,71,39,-1,39,71,72,-1,39,72,40,-1,40,72,73,-1,40,73,41,-1,41,73,74,-1,41,74,42,-1,42,74,75,-1,42,75,43,-1,43,75,76,-1,43,76,44,-1,44,76,77,-1,44,77,45,-1,45,77,78,-1,45,78,46,-1,46,78,79,-1,46,79,47,-1,47,79,80,-1,47,80,48,-1,48,80,81,-1,48,81,49,-1,49,81,82,-1,49,82,50,-1,50,82,83,-1,50,83,51,-1,51,83,84,-1,51,84,52,-1,52,84,85,-1,52,85,53,-1,53,85,86,-1,53,86,54,-1,54,86,87,-1,54,87,55,-1,55,87,88,-1,55,88,56,-1,56,88,89,-1,56,89,57,-1,57,89,90,-1,57,90,58,-1,58,90,91,-1,58,91,59,-1,59,91,92,-1,59,92,60,-1,60,92,93,-1,60,93,61,-1,61,93,94,-1,61,94,62,-1,62,94,95,-1,62,95,63,-1,63,95,96,-1,63,96,64,-1,64,96,65,-1,64,65,33,-1,65,97,98,-1,65,98,66,-1,66,98,99,-1,66,99,67,-1,67,99,100,-1,67,100,68,-1,68,100,101,-1,68,101,69,-1,69,101,102,-1,69,102,70,-1,70,102,103,-1,70,103,71,-1,71,103,104,-1,71,104,72,-1,72,104,105,-1,72,105,73,-1,73,105,106,-1,73,106,74,-1,74,106,107,-1,74,107,75,-1,75,107,108,-1,75,108,76,-1,76,108,109,-1,76,109,77,-1,77,109,110,-1,77,110,78,-1,78,110,111,-1,78,111,79,-1,79,111,112,-1,79,112,80,-1,80,112,113,-1,80,113,81,-1,81,113,114,-1,81,114,82,-1,82,114,115,-1,82,115,83,-1,83,115,116,-1,83,116,84,-1,84,116,117,-1,84,117,85,-1,85,117,118,-1,85,118,86,-1,86,118,119,-1,86,119,87,-1,87,119,120,-1,87,120,88,-1,88,120,121,-1,88,121,89,-1,89,121,122,-1,89,122,90,-1,90,122,123,-1,90,123,91,-1,91,123,124,-1,91,124,92,-1,92,124,125,-1,92,125,93,-1,93,125,126,-1,93,126,94,-1,94,126,127,-1,94,127,95,-1,95,127,128,-1,95,128,96,-1,96,128,97,-1,96,97,65,-1,97,129,130,-1,97,130,98,-1,98,130,131,-1,98,131,99,-1,99,131,132,-1,99,132,100,-1,100,132,133,-1,100,133,101,-1,101,133,134,-1,101,134,102,-1,102,134,135,-1,102,135,103,-1,103,135,136,-1,103,136,104,-1,104,136,137,-1,104,137,105,-1,105,137,138,-1,105,138,106,-1,106,138,139,-1,106,139,107,-1,107,139,140,-1,107,140,108,-1,108,140,141,-1,108,141,109,-1,109,141,142,-1,109,142,110,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_2()
		{
			int[] value = {110,142,143,-1,110,143,111,-1,111,143,144,-1,111,144,112,-1,112,144,145,-1,112,145,113,-1,113,145,146,-1,113,146,114,-1,114,146,147,-1,114,147,115,-1,115,147,148,-1,115,148,116,-1,116,148,149,-1,116,149,117,-1,117,149,150,-1,117,150,118,-1,118,150,151,-1,118,151,119,-1,119,151,152,-1,119,152,120,-1,120,152,153,-1,120,153,121,-1,121,153,154,-1,121,154,122,-1,122,154,155,-1,122,155,123,-1,123,155,156,-1,123,156,124,-1,124,156,157,-1,124,157,125,-1,125,157,158,-1,125,158,126,-1,126,158,159,-1,126,159,127,-1,127,159,160,-1,127,160,128,-1,128,160,129,-1,128,129,97,-1,129,161,162,-1,129,162,130,-1,130,162,163,-1,130,163,131,-1,131,163,164,-1,131,164,132,-1,132,164,165,-1,132,165,133,-1,133,165,166,-1,133,166,134,-1,134,166,167,-1,134,167,135,-1,135,167,168,-1,135,168,136,-1,136,168,169,-1,136,169,137,-1,137,169,170,-1,137,170,138,-1,138,170,171,-1,138,171,139,-1,139,171,172,-1,139,172,140,-1,140,172,173,-1,140,173,141,-1,141,173,174,-1,141,174,142,-1,142,174,175,-1,142,175,143,-1,143,175,176,-1,143,176,144,-1,144,176,177,-1,144,177,145,-1,145,177,178,-1,145,178,146,-1,146,178,179,-1,146,179,147,-1,147,179,180,-1,147,180,148,-1,148,180,181,-1,148,181,149,-1,149,181,182,-1,149,182,150,-1,150,182,183,-1,150,183,151,-1,151,183,184,-1,151,184,152,-1,152,184,185,-1,152,185,153,-1,153,185,186,-1,153,186,154,-1,154,186,187,-1,154,187,155,-1,155,187,188,-1,155,188,156,-1,156,188,189,-1,156,189,157,-1,157,189,190,-1,157,190,158,-1,158,190,191,-1,158,191,159,-1,159,191,192,-1,159,192,160,-1,160,192,161,-1,160,161,129,-1,161,193,194,-1,161,194,162,-1,162,194,195,-1,162,195,163,-1,163,195,196,-1,163,196,164,-1,164,196,197,-1,164,197,165,-1,165,197,198,-1,165,198,166,-1,166,198,199,-1,166,199,167,-1,167,199,200,-1,167,200,168,-1,168,200,201,-1,168,201,169,-1,169,201,202,-1,169,202,170,-1,170,202,203,-1,170,203,171,-1,171,203,204,-1,171,204,172,-1,172,204,205,-1,172,205,173,-1,173,205,206,-1,173,206,174,-1,174,206,207,-1,174,207,175,-1,175,207,208,-1,175,208,176,-1,176,208,209,-1,176,209,177,-1,177,209,210,-1,177,210,178,-1,178,210,211,-1,178,211,179,-1,179,211,212,-1,179,212,180,-1,180,212,213,-1,180,213,181,-1,181,213,214,-1,181,214,182,-1,182,214,215,-1,182,215,183,-1,183,215,216,-1,183,216,184,-1,184,216,217,-1,184,217,185,-1,185,217,218,-1,185,218,186,-1,186,218,219,-1,186,219,187,-1,187,219,220,-1,187,220,188,-1,188,220,221,-1,188,221,189,-1,189,221,222,-1,189,222,190,-1,190,222,223,-1,190,223,191,-1,191,223,224,-1,191,224,192,-1,192,224,193,-1,192,193,161,-1,193,225,226,-1,193,226,194,-1,194,226,227,-1,194,227,195,-1,195,227,228,-1,195,228,196,-1,196,228,229,-1,196,229,197,-1,197,229,230,-1,197,230,198,-1,198,230,231,-1,198,231,199,-1,199,231,232,-1,199,232,200,-1,200,232,233,-1,200,233,201,-1,201,233,234,-1,201,234,202,-1,202,234,235,-1,202,235,203,-1,203,235,236,-1,203,236,204,-1,204,236,237,-1,204,237,205,-1,205,237,238,-1,205,238,206,-1,206,238,239,-1,206,239,207,-1,207,239,240,-1,207,240,208,-1,208,240,241,-1,208,241,209,-1,209,241,242,-1,209,242,210,-1,210,242,243,-1,210,243,211,-1,211,243,244,-1,211,244,212,-1,212,244,245,-1,212,245,213,-1,213,245,246,-1,213,246,214,-1,214,246,247,-1,214,247,215,-1,215,247,248,-1,215,248,216,-1,216,248,249,-1,216,249,217,-1,217,249,250,-1,217,250,218,-1,218,250,251,-1,218,251,219,-1,219,251,252,-1,219,252,220,-1,220,252,253,-1,220,253,221,-1,221,253,254,-1,221,254,222,-1,222,254,255,-1,222,255,223,-1,223,255,256,-1,223,256,224,-1,224,256,225,-1,224,225,193,-1,225,257,258,-1,225,258,226,-1,226,258,259,-1,226,259,227,-1,227,259,260,-1,227,260,228,-1,228,260,261,-1,228,261,229,-1,229,261,262,-1,229,262,230,-1,230,262,263,-1,230,263,231,-1,231,263,264,-1,231,264,232,-1,232,264,265,-1,232,265,233,-1,233,265,266,-1,233,266,234,-1,234,266,267,-1,234,267,235,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_3()
		{
			int[] value = {235,267,268,-1,235,268,236,-1,236,268,269,-1,236,269,237,-1,237,269,270,-1,237,270,238,-1,238,270,271,-1,238,271,239,-1,239,271,272,-1,239,272,240,-1,240,272,273,-1,240,273,241,-1,241,273,274,-1,241,274,242,-1,242,274,275,-1,242,275,243,-1,243,275,276,-1,243,276,244,-1,244,276,277,-1,244,277,245,-1,245,277,278,-1,245,278,246,-1,246,278,279,-1,246,279,247,-1,247,279,280,-1,247,280,248,-1,248,280,281,-1,248,281,249,-1,249,281,282,-1,249,282,250,-1,250,282,283,-1,250,283,251,-1,251,283,284,-1,251,284,252,-1,252,284,285,-1,252,285,253,-1,253,285,286,-1,253,286,254,-1,254,286,287,-1,254,287,255,-1,255,287,288,-1,255,288,256,-1,256,288,257,-1,256,257,225,-1,257,289,290,-1,257,290,258,-1,258,290,291,-1,258,291,259,-1,259,291,292,-1,259,292,260,-1,260,292,293,-1,260,293,261,-1,261,293,294,-1,261,294,262,-1,262,294,295,-1,262,295,263,-1,263,295,296,-1,263,296,264,-1,264,296,297,-1,264,297,265,-1,265,297,298,-1,265,298,266,-1,266,298,299,-1,266,299,267,-1,267,299,300,-1,267,300,268,-1,268,300,301,-1,268,301,269,-1,269,301,302,-1,269,302,270,-1,270,302,303,-1,270,303,271,-1,271,303,304,-1,271,304,272,-1,272,304,305,-1,272,305,273,-1,273,305,306,-1,273,306,274,-1,274,306,307,-1,274,307,275,-1,275,307,308,-1,275,308,276,-1,276,308,309,-1,276,309,277,-1,277,309,310,-1,277,310,278,-1,278,310,311,-1,278,311,279,-1,279,311,312,-1,279,312,280,-1,280,312,313,-1,280,313,281,-1,281,313,314,-1,281,314,282,-1,282,314,315,-1,282,315,283,-1,283,315,316,-1,283,316,284,-1,284,316,317,-1,284,317,285,-1,285,317,318,-1,285,318,286,-1,286,318,319,-1,286,319,287,-1,287,319,320,-1,287,320,288,-1,288,320,289,-1,288,289,257,-1,289,321,322,-1,289,322,290,-1,290,322,323,-1,290,323,291,-1,291,323,324,-1,291,324,292,-1,292,324,325,-1,292,325,293,-1,293,325,326,-1,293,326,294,-1,294,326,327,-1,294,327,295,-1,295,327,328,-1,295,328,296,-1,296,328,329,-1,296,329,297,-1,297,329,330,-1,297,330,298,-1,298,330,331,-1,298,331,299,-1,299,331,332,-1,299,332,300,-1,300,332,333,-1,300,333,301,-1,301,333,334,-1,301,334,302,-1,302,334,335,-1,302,335,303,-1,303,335,336,-1,303,336,304,-1,304,336,337,-1,304,337,305,-1,305,337,338,-1,305,338,306,-1,306,338,339,-1,306,339,307,-1,307,339,340,-1,307,340,308,-1,308,340,341,-1,308,341,309,-1,309,341,342,-1,309,342,310,-1,310,342,343,-1,310,343,311,-1,311,343,344,-1,311,344,312,-1,312,344,345,-1,312,345,313,-1,313,345,346,-1,313,346,314,-1,314,346,347,-1,314,347,315,-1,315,347,348,-1,315,348,316,-1,316,348,349,-1,316,349,317,-1,317,349,350,-1,317,350,318,-1,318,350,351,-1,318,351,319,-1,319,351,352,-1,319,352,320,-1,320,352,321,-1,320,321,289,-1,321,353,354,-1,321,354,322,-1,322,354,355,-1,322,355,323,-1,323,355,356,-1,323,356,324,-1,324,356,357,-1,324,357,325,-1,325,357,358,-1,325,358,326,-1,326,358,359,-1,326,359,327,-1,327,359,360,-1,327,360,328,-1,328,360,361,-1,328,361,329,-1,329,361,362,-1,329,362,330,-1,330,362,363,-1,330,363,331,-1,331,363,364,-1,331,364,332,-1,332,364,365,-1,332,365,333,-1,333,365,366,-1,333,366,334,-1,334,366,367,-1,334,367,335,-1,335,367,368,-1,335,368,336,-1,336,368,369,-1,336,369,337,-1,337,369,370,-1,337,370,338,-1,338,370,371,-1,338,371,339,-1,339,371,372,-1,339,372,340,-1,340,372,373,-1,340,373,341,-1,341,373,374,-1,341,374,342,-1,342,374,375,-1,342,375,343,-1,343,375,376,-1,343,376,344,-1,344,376,377,-1,344,377,345,-1,345,377,378,-1,345,378,346,-1,346,378,379,-1,346,379,347,-1,347,379,380,-1,347,380,348,-1,348,380,381,-1,348,381,349,-1,349,381,382,-1,349,382,350,-1,350,382,383,-1,350,383,351,-1,351,383,384,-1,351,384,352,-1,352,384,353,-1,352,353,321,-1,353,385,386,-1,353,386,354,-1,354,386,387,-1,354,387,355,-1,355,387,388,-1,355,388,356,-1,356,388,389,-1,356,389,357,-1,357,389,390,-1,357,390,358,-1,358,390,391,-1,358,391,359,-1,359,391,392,-1,359,392,360,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_4()
		{
			int[] value = {360,392,393,-1,360,393,361,-1,361,393,394,-1,361,394,362,-1,362,394,395,-1,362,395,363,-1,363,395,396,-1,363,396,364,-1,364,396,397,-1,364,397,365,-1,365,397,398,-1,365,398,366,-1,366,398,399,-1,366,399,367,-1,367,399,400,-1,367,400,368,-1,368,400,401,-1,368,401,369,-1,369,401,402,-1,369,402,370,-1,370,402,403,-1,370,403,371,-1,371,403,404,-1,371,404,372,-1,372,404,405,-1,372,405,373,-1,373,405,406,-1,373,406,374,-1,374,406,407,-1,374,407,375,-1,375,407,408,-1,375,408,376,-1,376,408,409,-1,376,409,377,-1,377,409,410,-1,377,410,378,-1,378,410,411,-1,378,411,379,-1,379,411,412,-1,379,412,380,-1,380,412,413,-1,380,413,381,-1,381,413,414,-1,381,414,382,-1,382,414,415,-1,382,415,383,-1,383,415,416,-1,383,416,384,-1,384,416,385,-1,384,385,353,-1,385,417,418,-1,385,418,386,-1,386,418,419,-1,386,419,387,-1,387,419,420,-1,387,420,388,-1,388,420,421,-1,388,421,389,-1,389,421,422,-1,389,422,390,-1,390,422,423,-1,390,423,391,-1,391,423,424,-1,391,424,392,-1,392,424,425,-1,392,425,393,-1,393,425,426,-1,393,426,394,-1,394,426,427,-1,394,427,395,-1,395,427,428,-1,395,428,396,-1,396,428,429,-1,396,429,397,-1,397,429,430,-1,397,430,398,-1,398,430,431,-1,398,431,399,-1,399,431,432,-1,399,432,400,-1,400,432,433,-1,400,433,401,-1,401,433,434,-1,401,434,402,-1,402,434,435,-1,402,435,403,-1,403,435,436,-1,403,436,404,-1,404,436,437,-1,404,437,405,-1,405,437,438,-1,405,438,406,-1,406,438,439,-1,406,439,407,-1,407,439,440,-1,407,440,408,-1,408,440,441,-1,408,441,409,-1,409,441,442,-1,409,442,410,-1,410,442,443,-1,410,443,411,-1,411,443,444,-1,411,444,412,-1,412,444,445,-1,412,445,413,-1,413,445,446,-1,413,446,414,-1,414,446,447,-1,414,447,415,-1,415,447,448,-1,415,448,416,-1,416,448,417,-1,416,417,385,-1,417,449,450,-1,417,450,418,-1,418,450,451,-1,418,451,419,-1,419,451,452,-1,419,452,420,-1,420,452,453,-1,420,453,421,-1,421,453,454,-1,421,454,422,-1,422,454,455,-1,422,455,423,-1,423,455,456,-1,423,456,424,-1,424,456,457,-1,424,457,425,-1,425,457,458,-1,425,458,426,-1,426,458,459,-1,426,459,427,-1,427,459,460,-1,427,460,428,-1,428,460,461,-1,428,461,429,-1,429,461,462,-1,429,462,430,-1,430,462,463,-1,430,463,431,-1,431,463,464,-1,431,464,432,-1,432,464,465,-1,432,465,433,-1,433,465,466,-1,433,466,434,-1,434,466,467,-1,434,467,435,-1,435,467,468,-1,435,468,436,-1,436,468,469,-1,436,469,437,-1,437,469,470,-1,437,470,438,-1,438,470,471,-1,438,471,439,-1,439,471,472,-1,439,472,440,-1,440,472,473,-1,440,473,441,-1,441,473,474,-1,441,474,442,-1,442,474,475,-1,442,475,443,-1,443,475,476,-1,443,476,444,-1,444,476,477,-1,444,477,445,-1,445,477,478,-1,445,478,446,-1,446,478,479,-1,446,479,447,-1,447,479,480,-1,447,480,448,-1,448,480,449,-1,448,449,417,-1,481,450,449,-1,481,451,450,-1,481,452,451,-1,481,453,452,-1,481,454,453,-1,481,455,454,-1,481,456,455,-1,481,457,456,-1,481,458,457,-1,481,459,458,-1,481,460,459,-1,481,461,460,-1,481,462,461,-1,481,463,462,-1,481,464,463,-1,481,465,464,-1,481,466,465,-1,481,467,466,-1,481,468,467,-1,481,469,468,-1,481,470,469,-1,481,471,470,-1,481,472,471,-1,481,473,472,-1,481,474,473,-1,481,475,474,-1,481,476,475,-1,481,477,476,-1,481,478,477,-1,481,479,478,-1,481,480,479,-1,481,449,480,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_6_22_point_1()
		{
			double[] value = {0,63.72,0,0,62.28,-14.65,-2.858,62.28,-14.37,-5.606,62.28,-13.53,-8.139,62.28,-12.18,-10.36,62.28,-10.36,-12.18,62.28,-8.139,-13.53,62.28,-5.606,-14.37,62.28,-2.858,-14.65,62.28,1.061e-005,-14.37,62.28,2.858,-13.53,62.28,5.606,-12.18,62.28,8.139,-10.36,62.28,10.36,-8.139,62.28,12.18,-5.606,62.28,13.53,-2.858,62.28,14.37,0,62.28,14.65,2.858,62.28,14.37,5.606,62.28,13.53,8.139,62.28,12.18,10.36,62.28,10.36,12.18,62.28,8.139,13.53,62.28,5.606,14.37,62.28,2.858,14.65,62.28,0,14.37,62.28,-2.858,13.53,62.28,-5.606,12.18,62.28,-8.139,10.36,62.28,-10.36,8.139,62.28,-12.18,5.606,62.28,-13.53,2.858,62.28,-14.37,0,58.05,-28.74,-5.606,58.05,-28.18,-11,58.05,-26.55,-15.96,58.05,-23.89,-20.32,58.05,-20.32,-23.89,58.05,-15.96,-26.55,58.05,-11,-28.18,58.05,-5.606,-28.74,58.05,0,-28.18,58.05,5.606,-26.55,58.05,11,-23.89,58.05,15.96,-20.32,58.05,20.32,-15.96,58.05,23.89,-11,58.05,26.55,-5.606,58.05,28.18,0,58.05,28.74,5.606,58.05,28.18,11,58.05,26.55,15.96,58.05,23.89,20.32,58.05,20.32,23.89,58.05,15.96,26.55,58.05,11,28.18,58.05,5.606,28.74,58.05,0,28.18,58.05,-5.606,26.55,58.05,-11,23.89,58.05,-15.96,20.32,58.05,-20.32,15.96,58.05,-23.89,11,58.05,-26.55,5.606,58.05,-28.18,0,51.24,-41.72,-8.139,51.24,-40.92,-15.96,51.24,-38.54,-23.18,51.24,-34.69,-29.5,51.24,-29.5,-34.69,51.24,-23.18,-38.54,51.24,-15.96,-40.92,51.24,-8.139,-41.72,51.24,1.061e-005,-40.92,51.24,8.139,-38.54,51.24,15.96,-34.69,51.24,23.18,-29.5,51.24,29.5,-23.18,51.24,34.69,-15.96,51.24,38.54,-8.139,51.24,40.92,1.654e-005,51.24,41.72,8.139,51.24,40.92,15.96,51.24,38.54,23.18,51.24,34.69,29.5,51.24,29.5,34.69,51.24,23.18,38.54,51.24,15.96,40.92,51.24,8.139,41.72,51.24,-1.624e-005,40.92,51.24,-8.139,38.54,51.24,-15.96,34.69,51.24,-23.18,29.5,51.24,-29.5,23.18,51.24,-34.69,15.96,51.24,-38.54,8.139,51.24,-40.92,-1.479e-005,42.26,-53.1,-10.36,42.26,-52.08,-20.32,42.26,-49.05};
			return value;
		}
		private double[] getCoordinate_6_22_point_2()
		{
			double[] value = {-29.5,42.26,-44.15,-37.54,42.26,-37.54,-44.15,42.26,-29.5,-49.05,42.26,-20.32,-52.08,42.26,-10.36,-53.1,42.26,1.061e-005,-52.08,42.26,10.36,-49.05,42.26,20.32,-44.15,42.26,29.5,-37.54,42.26,37.54,-29.5,42.26,44.15,-20.32,42.26,49.05,-10.36,42.26,52.08,1.654e-005,42.26,53.1,10.36,42.26,52.08,20.32,42.26,49.05,29.5,42.26,44.15,37.54,42.26,37.54,44.15,42.26,29.5,49.05,42.26,20.32,52.08,42.26,10.36,53.1,42.26,-1.624e-005,52.08,42.26,-10.36,49.05,42.26,-20.32,44.15,42.26,-29.5,37.54,42.26,-37.54,29.5,42.26,-44.15,20.32,42.26,-49.05,10.36,42.26,-52.08,0,31.64,-62.43,-12.18,31.64,-61.23,-23.89,31.64,-57.68,-34.69,31.64,-51.91,-44.15,31.64,-44.15,-51.91,31.64,-34.69,-57.68,31.64,-23.89,-61.23,31.64,-12.18,-62.43,31.64,0,-61.23,31.64,12.18,-57.68,31.64,23.89,-51.91,31.64,34.69,-44.15,31.64,44.15,-34.69,31.64,51.91,-23.89,31.64,57.68,-12.18,31.64,61.23,1.654e-005,31.64,62.43,12.18,31.64,61.23,23.89,31.64,57.68,34.69,31.64,51.91,44.15,31.64,44.15,51.91,31.64,34.69,57.68,31.64,23.89,61.23,31.64,12.18,62.43,31.64,-1.624e-005,61.23,31.64,-12.18,57.68,31.64,-23.89,51.91,31.64,-34.69,44.15,31.64,-44.15,34.69,31.64,-51.91,23.89,31.64,-57.68,12.18,31.64,-61.23,0,20.07,-69.37,-13.53,20.07,-68.04,-26.55,20.07,-64.09,-38.54,20.07,-57.68,-49.05,20.07,-49.05,-57.68,20.07,-38.54,-64.09,20.07,-26.55,-68.04,20.07,-13.53,-69.37,20.07,0,-68.04,20.07,13.53,-64.09,20.07,26.55,-57.68,20.07,38.54,-49.05,20.07,49.05,-38.54,20.07,57.68,-26.55,20.07,64.09,-13.53,20.07,68.04,0,20.07,69.37,13.53,20.07,68.04,26.55,20.07,64.09,38.54,20.07,57.68,49.05,20.07,49.05,57.68,20.07,38.54,64.09,20.07,26.55,68.04,20.07,13.53,69.37,20.07,-1.624e-005,68.04,20.07,-13.53,64.09,20.07,-26.55,57.68,20.07,-38.54,49.05,20.07,-49.05,38.54,20.07,-57.68,26.55,20.07,-64.09,13.53,20.07,-68.04,-1.031e-005,8.301,-73.65,-14.37,8.301,-72.23,-28.18,8.301,-68.04,-40.92,8.301,-61.23,-52.08,8.301,-52.08,-61.23,8.301,-40.92,-68.04,8.301,-28.18};
			return value;
		}
		private double[] getCoordinate_6_22_point_3()
		{
			double[] value = {-72.23,8.301,-14.37,-73.65,8.301,0,-72.23,8.301,14.37,-68.04,8.301,28.18,-61.23,8.301,40.92,-52.08,8.301,52.08,-40.92,8.301,61.23,-28.18,8.301,68.04,-14.37,8.301,72.23,1.654e-005,8.301,73.65,14.37,8.301,72.23,28.18,8.301,68.04,40.92,8.301,61.23,52.08,8.301,52.08,61.23,8.301,40.92,68.04,8.301,28.18,72.23,8.301,14.37,73.65,8.301,0,72.23,8.301,-14.37,68.04,8.301,-28.18,61.23,8.301,-40.92,52.08,8.301,-52.08,40.92,8.301,-61.23,28.18,8.301,-68.04,14.37,8.301,-72.23,-1.031e-005,-2.907,-75.09,-14.65,-2.907,-73.65,-28.74,-2.907,-69.37,-41.72,-2.907,-62.43,-53.1,-2.907,-53.1,-62.43,-2.907,-41.72,-69.37,-2.907,-28.74,-73.65,-2.907,-14.65,-75.09,-2.907,1.061e-005,-73.65,-2.907,14.65,-69.37,-2.907,28.74,-62.43,-2.907,41.72,-53.1,-2.907,53.1,-41.72,-2.907,62.43,-28.74,-2.907,69.37,-14.65,-2.907,73.65,0,-2.907,75.09,14.65,-2.907,73.65,28.74,-2.907,69.37,41.72,-2.907,62.43,53.1,-2.907,53.1,62.43,-2.907,41.72,69.37,-2.907,28.74,73.65,-2.907,14.65,75.09,-2.907,0,73.65,-2.907,-14.65,69.37,-2.907,-28.74,62.43,-2.907,-41.72,53.1,-2.907,-53.1,41.72,-2.907,-62.43,28.74,-2.907,-69.37,14.65,-2.907,-73.65,-1.479e-005,-12.89,-73.65,-14.37,-12.89,-72.23,-28.18,-12.89,-68.04,-40.92,-12.89,-61.23,-52.08,-12.89,-52.08,-61.23,-12.89,-40.92,-68.04,-12.89,-28.18,-72.23,-12.89,-14.37,-73.65,-12.89,0.0,-72.23,-12.89,14.37,-68.04,-12.89,28.18,-61.23,-12.89,40.92,-52.08,-12.89,52.08,-40.92,-12.89,61.23,-28.18,-12.89,68.04,-14.37,-12.89,72.23,0.0,-12.89,73.65,14.37,-12.89,72.23,28.18,-12.89,68.04,40.92,-12.89,61.23,52.08,-12.89,52.08,61.23,-12.89,40.92,68.04,-12.89,28.18,72.23,-12.89,14.37,73.65,-12.89,0.0,72.23,-12.89,-14.37,68.04,-12.89,-28.18,61.23,-12.89,-40.92,52.08,-12.89,-52.08,40.92,-12.89,-61.23,28.18,-12.89,-68.04,14.37,-12.89,-72.23,0.0,-21.18,-69.37,-13.53,-21.18,-68.04,-26.55,-21.18,-64.09,-38.54,-21.18,-57.68,-49.05,-21.18,-49.05,-57.68,-21.18,-38.54,-64.09,-21.18,-26.55,-68.04,-21.18,-13.53,-69.37,-21.18,0.0,-68.04,-21.18,13.53,-64.09,-21.18,26.55};
			return value;
		}
		private double[] getCoordinate_6_22_point_4()
		{
			double[] value = {-57.68,-21.18,38.54,-49.05,-21.18,49.05,-38.54,-21.18,57.68,-26.55,-21.18,64.09,-13.53,-21.18,68.04,0,-21.18,69.37,13.53,-21.18,68.04,26.55,-21.18,64.09,38.54,-21.18,57.68,49.05,-21.18,49.05,57.68,-21.18,38.54,64.09,-21.18,26.55,68.04,-21.18,13.53,69.37,-21.18,-1.624e-005,68.04,-21.18,-13.53,64.09,-21.18,-26.55,57.68,-21.18,-38.54,49.05,-21.18,-49.05,38.54,-21.18,-57.68,26.55,-21.18,-64.09,13.53,-21.18,-68.04,-1.031e-005,-27.54,-62.43,-12.18,-27.54,-61.23,-23.89,-27.54,-57.68,-34.69,-27.54,-51.91,-44.15,-27.54,-44.15,-51.91,-27.54,-34.69,-57.68,-27.54,-23.89,-61.23,-27.54,-12.18,-62.43,-27.54,0,-61.23,-27.54,12.18,-57.68,-27.54,23.89,-51.91,-27.54,34.69,-44.15,-27.54,44.15,-34.69,-27.54,51.91,-23.89,-27.54,57.68,-12.18,-27.54,61.23,0,-27.54,62.43,12.18,-27.54,61.23,23.89,-27.54,57.68,34.69,-27.54,51.91,44.15,-27.54,44.15,51.91,-27.54,34.69,57.68,-27.54,23.89,61.23,-27.54,12.18,62.43,-27.54,-1.624e-005,61.23,-27.54,-12.18,57.68,-27.54,-23.89,51.91,-27.54,-34.69,44.15,-27.54,-44.15,34.69,-27.54,-51.91,23.89,-27.54,-57.68,12.18,-27.54,-61.23,-1.031e-005,-32.02,-53.1,-10.36,-32.02,-52.08,-20.32,-32.02,-49.05,-29.5,-32.02,-44.15,-37.54,-32.02,-37.54,-44.15,-32.02,-29.5,-49.05,-32.02,-20.32,-52.08,-32.02,-10.36,-53.1,-32.02,1.508e-005,-52.08,-32.02,10.36,-49.05,-32.02,20.32,-44.15,-32.02,29.5,-37.54,-32.02,37.54,-29.5,-32.02,44.15,-20.32,-32.02,49.05,-10.36,-32.02,52.08,0,-32.02,53.1,10.36,-32.02,52.08,20.32,-32.02,49.05,29.5,-32.02,44.15,37.54,-32.02,37.54,44.15,-32.02,29.5,49.05,-32.02,20.32,52.08,-32.02,10.36,53.1,-32.02,-1.624e-005,52.08,-32.02,-10.36,49.05,-32.02,-20.32,44.15,-32.02,-29.5,37.54,-32.02,-37.54,29.5,-32.02,-44.15,20.32,-32.02,-49.05,10.36,-32.02,-52.08,0.0,-34.86,-41.72,-8.139,-34.86,-40.92,-15.96,-34.86,-38.54,-23.18,-34.86,-34.69,-29.5,-34.86,-29.5,-34.69,-34.86,-23.18,-38.54,-34.86,-15.96,-40.92,-34.86,-8.139,-41.72,-34.86,0.0,-40.92,-34.86,8.139,-38.54,-34.86,15.96,-34.69,-34.86,23.18,-29.5,-34.86,29.5,-23.18,-34.86,34.69,-15.96,-34.86,38.54};
			return value;
		}
		private double[] getCoordinate_6_22_point_5()
		{
			double[] value = {-8.139,-34.86,40.92,1.654e-005,-34.86,41.72,8.139,-34.86,40.92,15.96,-34.86,38.54,23.18,-34.86,34.69,29.5,-34.86,29.5,34.69,-34.86,23.18,38.54,-34.86,15.96,40.92,-34.86,8.139,41.72,-34.86,-1.624e-005,40.92,-34.86,-8.139,38.54,-34.86,-15.96,34.69,-34.86,-23.18,29.5,-34.86,-29.5,23.18,-34.86,-34.69,15.96,-34.86,-38.54,8.139,-34.86,-40.92,0.0,-36.46,-28.74,-5.606,-36.46,-28.18,-11.0,-36.46,-26.55,-15.96,-36.46,-23.89,-20.32,-36.46,-20.32,-23.89,-36.46,-15.96,-26.55,-36.46,-11.0,-28.18,-36.46,-5.606,-28.74,-36.46,0.0,-28.18,-36.46,5.606,-26.55,-36.46,11.0,-23.89,-36.46,15.96,-20.32,-36.46,20.32,-15.96,-36.46,23.89,-11.0,-36.46,26.55,-5.606,-36.46,28.18,0.0,-36.46,28.74,5.606,-36.46,28.18,11.0,-36.46,26.55,15.96,-36.46,23.89,20.32,-36.46,20.32,23.89,-36.46,15.96,26.55,-36.46,11.0,28.18,-36.46,5.606,28.74,-36.46,0.0,28.18,-36.46,-5.606,26.55,-36.46,-11.0,23.89,-36.46,-15.96,20.32,-36.46,-20.32,15.96,-36.46,-23.89,11.0,-36.46,-26.55,5.606,-36.46,-28.18,0.0,-37.21,-14.65,-2.858,-37.21,-14.37,-5.606,-37.21,-13.53,-8.139,-37.21,-12.18,-10.36,-37.21,-10.36,-12.18,-37.21,-8.139,-13.53,-37.21,-5.606,-14.37,-37.21,-2.858,-14.65,-37.21,0.0,-14.37,-37.21,2.858,-13.53,-37.21,5.606,-12.18,-37.21,8.139,-10.36,-37.21,10.36,-8.139,-37.21,12.18,-5.606,-37.21,13.53,-2.858,-37.21,14.37,0.0,-37.21,14.65,2.858,-37.21,14.37,5.606,-37.21,13.53,8.139,-37.21,12.18,10.36,-37.21,10.36,12.18,-37.21,8.139,13.53,-37.21,5.606,14.37,-37.21,2.858,14.65,-37.21,0.0,14.37,-37.21,-2.858,13.53,-37.21,-5.606,12.18,-37.21,-8.139,10.36,-37.21,-10.36,8.139,-37.21,-12.18,5.606,-37.21,-13.53,2.858,-37.21,-14.37,0.0,-37.43,0.0};
			return value;
		}

		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=5, element #22, 3840 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_5_22_coordIndex()
		{
			MFInt32 IndexedFaceSet_5_22_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_1()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_2()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_3()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_4()));
			return IndexedFaceSet_5_22_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=6, element #22, 1446 total numbers made up of 482 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_6_22_point()
		{
			MFVec3f Coordinate_6_22_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_6_22_point_1()))
				.append(new MFVec3f(getCoordinate_6_22_point_2()))
				.append(new MFVec3f(getCoordinate_6_22_point_3()))
				.append(new MFVec3f(getCoordinate_6_22_point_4()))
				.append(new MFVec3f(getCoordinate_6_22_point_5()));
			return Coordinate_6_22_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return UnitClamidomonas model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new UnitClamidomonas().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Units.UnitClamidomonas\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Units.UnitClamidomonas self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Units/UnitClamidomonas_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Units/UnitClamidomonas_JavaExport.x3d"; 
                String filenameX3DV = "Units/UnitClamidomonas_JavaExport.x3dv"; 
                String filenameJSON = "Units/UnitClamidomonas_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
