package Basic.Units;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Units component example for a chair. </p>
 <p> Related links: Catalog page <a href="../../../Units/UnitChairIndex.html" target="_blank">UnitChair</a>,  source <a href="../../../Units/UnitChair.java">UnitChair.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Units/UnitChair.x3d">UnitChair.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Units component example for a chair </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Myeong Won Lee </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 August 2009 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Units/UnitExamples.pdf">UnitExamples.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.igraphics.com/Standards/ISO_IEC_19775_1_2_PDAM1_Candidate_2011_05_12/Part01/concepts.html" target="_blank">http://www.igraphics.com/Standards/ISO_IEC_19775_1_2_PDAM1_Candidate_2011_05_12/Part01/concepts.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.igraphics.com/Standards/ISO_IEC_19775_1_2_PDAM1_Candidate_2011_05_12/Part01/components/core.html#UNITStatement" target="_blank">http://www.igraphics.com/Standards/ISO_IEC_19775_1_2_PDAM1_Candidate_2011_05_12/Part01/components/core.html#UNITStatement</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd" target="_blank">http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D UNIT statement </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Units/UnitChair.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Units/UnitChair.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Units/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Myeong Won Lee
 */

public class UnitChair
{
	/** Default constructor to create this object. */
	public UnitChair ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addUnit(new unit().setName("Centimeters").setCategory("length").setConversionFactor(0.01))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("UnitChair.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Units component example for a chair"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Myeong Won Lee"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 August 2009"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("UnitExamples.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.igraphics.com/Standards/ISO_IEC_19775_1_2_PDAM1_Candidate_2011_05_12/Part01/concepts.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.igraphics.com/Standards/ISO_IEC_19775_1_2_PDAM1_Candidate_2011_05_12/Part01/components/core.html#UNITStatement"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D UNIT statement"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Units/UnitChair.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("UnitChair.x3d"))
    .addChild(new Background().setGroundColor(new MFColor(new double[] {0.05,0.1,0.3})).setSkyColor(new MFColor(new double[] {0.05,0.1,0.3})))
    .addChild(new Transform().setScale(0.3415,0.3415,0.3415).setTranslation(-300.0,200.0,-300.0)
      .addChild(new Viewpoint().setDescription("Chair").setPosition(0.0,0.0,1.0))
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.0902,0.05882,0.0)))
        .setGeometry(new IndexedFaceSet().setCoordIndex(getIndexedFaceSet_5_22_coordIndex())
          .setCoord(new Coordinate().setPoint(getCoordinate_6_22_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_5_22_coordIndex_1()
		{
			int[] value = {20,19,18,-1,20,18,17,-1,21,20,17,-1,21,17,16,-1,22,21,16,-1,22,16,15,-1,23,22,15,-1,23,15,14,-1,24,23,14,-1,24,14,13,-1,25,24,13,-1,25,13,12,-1,26,25,12,-1,26,12,11,-1,27,26,11,-1,27,11,10,-1,28,27,10,-1,28,10,9,-1,29,28,9,-1,29,9,8,-1,30,29,8,-1,30,8,7,-1,31,30,7,-1,31,7,6,-1,32,31,6,-1,32,6,5,-1,33,32,5,-1,33,5,4,-1,34,33,4,-1,34,4,3,-1,35,34,3,-1,35,3,2,-1,36,35,2,-1,36,2,1,-1,0,37,36,-1,1,0,36,-1,0,1,39,-1,0,39,38,-1,1,2,40,-1,1,40,39,-1,2,3,41,-1,2,41,40,-1,3,4,42,-1,3,42,41,-1,4,5,43,-1,4,43,42,-1,5,6,44,-1,5,44,43,-1,6,7,45,-1,6,45,44,-1,7,8,46,-1,7,46,45,-1,8,9,47,-1,8,47,46,-1,9,10,48,-1,9,48,47,-1,10,11,49,-1,10,49,48,-1,11,12,50,-1,11,50,49,-1,12,13,51,-1,12,51,50,-1,13,14,52,-1,13,52,51,-1,14,15,53,-1,14,53,52,-1,15,16,54,-1,15,54,53,-1,16,17,55,-1,16,55,54,-1,17,18,56,-1,17,56,55,-1,18,19,57,-1,18,57,56,-1,19,20,58,-1,19,58,57,-1,20,21,59,-1,20,59,58,-1,21,22,60,-1,21,60,59,-1,22,23,61,-1,22,61,60,-1,23,24,62,-1,23,62,61,-1,24,25,63,-1,24,63,62,-1,25,26,64,-1,25,64,63,-1,26,27,65,-1,26,65,64,-1,27,28,66,-1,27,66,65,-1,28,29,67,-1,28,67,66,-1,29,30,68,-1,29,68,67,-1,30,31,69,-1,30,69,68,-1,31,32,70,-1,31,70,69,-1,32,33,71,-1,32,71,70,-1,33,34,72,-1,33,72,71,-1,34,35,73,-1,34,73,72,-1,35,36,74,-1,35,74,73,-1,36,37,75,-1,36,75,74,-1,37,0,38,-1,37,38,75,-1,56,57,58,-1,55,56,58,-1,55,58,59,-1,54,55,59,-1,54,59,60,-1,53,54,60,-1,53,60,61,-1,52,53,61,-1,52,61,62,-1,51,52,62,-1,51,62,63,-1,50,51,63,-1,50,63,64,-1,49,50,64,-1,49,64,65,-1,48,49,65,-1,48,65,66,-1,47,48,66,-1,47,66,67,-1,46,47,67,-1,46,67,68,-1,45,46,68,-1,45,68,69,-1,44,45,69,-1,44,69,70,-1,43,44,70,-1,43,70,71,-1,42,43,71,-1,42,71,72,-1,41,42,72,-1,41,72,73,-1,40,41,73,-1,40,73,74,-1,39,40,74,-1,74,75,38,-1,74,38,39,-1,92,91,90,-1,93,92,90,-1,93,90,89,-1,94,93,89,-1,94,89,88,-1,95,94,88,-1,95,88,87,-1,96,95,87,-1,96,87,86,-1,97,96,86,-1,97,86,85,-1,98,97,85,-1,98,85,84,-1,99,98,84,-1,99,84,83,-1,100,99,83,-1,76,107,106,-1,77,76,106,-1,77,106,105,-1,78,77,105,-1,78,105,104,-1,79,78,104,-1,79,104,103,-1,80,79,103,-1,80,103,102,-1,81,80,102,-1,81,102,101,-1,82,81,101,-1,82,101,100,-1,83,82,100,-1,76,77,109,-1,76,109,108,-1,77,78,110,-1,77,110,109,-1,78,79,111,-1,78,111,110,-1,79,80,112,-1,79,112,111,-1,80,81,113,-1,80,113,112,-1,81,82,114,-1,81,114,113,-1,82,83,115,-1,82,115,114,-1,83,84,116,-1,83,116,115,-1,84,85,117,-1,84,117,116,-1,85,86,118,-1,85,118,117,-1,86,87,119,-1,86,119,118,-1,87,88,120,-1,87,120,119,-1,88,89,121,-1,88,121,120,-1,89,90,122,-1,89,122,121,-1,90,91,123,-1,90,123,122,-1,91,92,124,-1,91,124,123,-1,92,93,125,-1,92,125,124,-1,93,94,126,-1,93,126,125,-1,94,95,127,-1,94,127,126,-1,95,96,128,-1,95,128,127,-1,96,97,129,-1,96,129,128,-1,97,98,130,-1,97,130,129,-1,98,99,131,-1,98,131,130,-1,99,100,132,-1,99,132,131,-1,100,101,133,-1,100,133,132,-1,101,102,134,-1,101,134,133,-1,102,103,135,-1,102,135,134,-1,103,104,136,-1,103,136,135,-1,104,105,137,-1,104,137,136,-1,105,106,138,-1,105,138,137,-1,106,107,139,-1,106,139,138,-1,107,76,108,-1,107,108,139,-1,122,123,124,-1,122,124,125,-1,121,122,125,-1,121,125,126,-1,120,121,126,-1,120,126,127,-1,119,120,127,-1,119,127,128,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_2()
		{
			int[] value = {118,119,128,-1,118,128,129,-1,117,118,129,-1,117,129,130,-1,116,117,130,-1,116,130,131,-1,115,116,131,-1,115,131,132,-1,138,139,108,-1,138,108,109,-1,137,138,109,-1,137,109,110,-1,136,137,110,-1,136,110,111,-1,135,136,111,-1,135,111,112,-1,134,135,112,-1,134,112,113,-1,133,134,113,-1,133,113,114,-1,132,133,114,-1,132,114,115,-1,157,156,155,-1,158,157,155,-1,158,155,154,-1,159,158,154,-1,160,159,154,-1,161,160,154,-1,162,161,154,-1,163,162,154,-1,140,163,154,-1,141,140,154,-1,141,154,153,-1,142,141,153,-1,142,153,152,-1,143,142,152,-1,144,143,152,-1,145,144,152,-1,146,145,152,-1,147,146,152,-1,148,147,152,-1,149,148,152,-1,149,152,151,-1,149,151,150,-1,140,141,165,-1,140,165,164,-1,141,142,166,-1,141,166,165,-1,142,143,167,-1,142,167,166,-1,143,144,168,-1,143,168,167,-1,144,145,169,-1,144,169,168,-1,145,146,170,-1,145,170,169,-1,146,147,171,-1,146,171,170,-1,147,148,172,-1,147,172,171,-1,148,149,173,-1,148,173,172,-1,149,150,174,-1,149,174,173,-1,150,151,175,-1,150,175,174,-1,151,152,176,-1,151,176,175,-1,152,153,177,-1,152,177,176,-1,153,154,178,-1,153,178,177,-1,154,155,179,-1,154,179,178,-1,155,156,180,-1,155,180,179,-1,156,157,181,-1,156,181,180,-1,157,158,182,-1,157,182,181,-1,158,159,183,-1,158,183,182,-1,159,160,184,-1,159,184,183,-1,160,161,185,-1,160,185,184,-1,161,162,186,-1,161,186,185,-1,162,163,187,-1,162,187,186,-1,163,140,164,-1,163,164,187,-1,179,180,181,-1,179,181,182,-1,178,179,182,-1,178,182,183,-1,178,183,184,-1,178,184,185,-1,178,185,186,-1,178,186,187,-1,178,187,164,-1,178,164,165,-1,177,178,165,-1,177,165,166,-1,176,177,166,-1,176,166,167,-1,176,167,168,-1,176,168,169,-1,176,169,170,-1,176,170,171,-1,176,171,172,-1,176,172,173,-1,175,176,173,-1,174,175,173,-1,208,207,206,-1,208,206,205,-1,209,208,205,-1,209,205,204,-1,210,209,204,-1,210,204,203,-1,211,210,203,-1,211,203,202,-1,212,211,202,-1,212,202,201,-1,213,212,201,-1,213,201,200,-1,214,213,200,-1,214,200,199,-1,215,214,199,-1,215,199,198,-1,216,215,198,-1,216,198,197,-1,217,216,197,-1,217,197,196,-1,218,217,196,-1,218,196,195,-1,219,218,195,-1,219,195,194,-1,220,219,194,-1,220,194,193,-1,221,220,193,-1,221,193,192,-1,222,221,192,-1,222,192,191,-1,223,222,191,-1,223,191,190,-1,224,223,190,-1,224,190,189,-1,188,225,224,-1,189,188,224,-1,188,189,227,-1,188,227,226,-1,189,190,228,-1,189,228,227,-1,190,191,229,-1,190,229,228,-1,191,192,230,-1,191,230,229,-1,192,193,231,-1,192,231,230,-1,193,194,232,-1,193,232,231,-1,194,195,233,-1,194,233,232,-1,195,196,234,-1,195,234,233,-1,196,197,235,-1,196,235,234,-1,197,198,236,-1,197,236,235,-1,198,199,237,-1,198,237,236,-1,199,200,238,-1,199,238,237,-1,200,201,239,-1,200,239,238,-1,201,202,240,-1,201,240,239,-1,202,203,241,-1,202,241,240,-1,203,204,242,-1,203,242,241,-1,204,205,243,-1,204,243,242,-1,205,206,244,-1,205,244,243,-1,206,207,245,-1,206,245,244,-1,207,208,246,-1,207,246,245,-1,208,209,247,-1,208,247,246,-1,209,210,248,-1,209,248,247,-1,210,211,249,-1,210,249,248,-1,211,212,250,-1,211,250,249,-1,212,213,251,-1,212,251,250,-1,213,214,252,-1,213,252,251,-1,214,215,253,-1,214,253,252,-1,215,216,254,-1,215,254,253,-1,216,217,255,-1,216,255,254,-1,217,218,256,-1,217,256,255,-1,218,219,257,-1,218,257,256,-1,219,220,258,-1,219,258,257,-1,220,221,259,-1,220,259,258,-1,221,222,260,-1,221,260,259,-1,222,223,261,-1,222,261,260,-1,223,224,262,-1,223,262,261,-1,224,225,263,-1,224,263,262,-1,225,188,226,-1,225,226,263,-1,244,245,246,-1,243,244,246,-1,243,246,247,-1,242,243,247,-1,242,247,248,-1,241,242,248,-1,241,248,249,-1,240,241,249,-1,240,249,250,-1,239,240,250,-1,239,250,251,-1,238,239,251,-1,238,251,252,-1,237,238,252,-1,237,252,253,-1,236,237,253,-1,236,253,254,-1,235,236,254,-1,235,254,255,-1,234,235,255,-1,234,255,256,-1,233,234,256,-1,233,256,257,-1,232,233,257,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_3()
		{
			int[] value = {232,257,258,-1,231,232,258,-1,231,258,259,-1,230,231,259,-1,230,259,260,-1,229,230,260,-1,229,260,261,-1,228,229,261,-1,228,261,262,-1,227,228,262,-1,262,263,226,-1,262,226,227,-1,280,279,278,-1,281,280,278,-1,281,278,277,-1,282,281,277,-1,282,277,276,-1,283,282,276,-1,283,276,275,-1,284,283,275,-1,284,275,274,-1,285,284,274,-1,285,274,273,-1,286,285,273,-1,286,273,272,-1,287,286,272,-1,287,272,271,-1,288,287,271,-1,264,295,294,-1,265,264,294,-1,265,294,293,-1,266,265,293,-1,266,293,292,-1,267,266,292,-1,267,292,291,-1,268,267,291,-1,268,291,290,-1,269,268,290,-1,269,290,289,-1,270,269,289,-1,270,289,288,-1,271,270,288,-1,264,265,297,-1,264,297,296,-1,265,266,298,-1,265,298,297,-1,266,267,299,-1,266,299,298,-1,267,268,300,-1,267,300,299,-1,268,269,301,-1,268,301,300,-1,269,270,302,-1,269,302,301,-1,270,271,303,-1,270,303,302,-1,271,272,304,-1,271,304,303,-1,272,273,305,-1,272,305,304,-1,273,274,306,-1,273,306,305,-1,274,275,307,-1,274,307,306,-1,275,276,308,-1,275,308,307,-1,276,277,309,-1,276,309,308,-1,277,278,310,-1,277,310,309,-1,278,279,311,-1,278,311,310,-1,279,280,312,-1,279,312,311,-1,280,281,313,-1,280,313,312,-1,281,282,314,-1,281,314,313,-1,282,283,315,-1,282,315,314,-1,283,284,316,-1,283,316,315,-1,284,285,317,-1,284,317,316,-1,285,286,318,-1,285,318,317,-1,286,287,319,-1,286,319,318,-1,287,288,320,-1,287,320,319,-1,288,289,321,-1,288,321,320,-1,289,290,322,-1,289,322,321,-1,290,291,323,-1,290,323,322,-1,291,292,324,-1,291,324,323,-1,292,293,325,-1,292,325,324,-1,293,294,326,-1,293,326,325,-1,294,295,327,-1,294,327,326,-1,295,264,296,-1,295,296,327,-1,310,311,312,-1,310,312,313,-1,309,310,313,-1,309,313,314,-1,308,309,314,-1,308,314,315,-1,307,308,315,-1,307,315,316,-1,306,307,316,-1,306,316,317,-1,305,306,317,-1,305,317,318,-1,304,305,318,-1,304,318,319,-1,303,304,319,-1,303,319,320,-1,326,327,296,-1,326,296,297,-1,325,326,297,-1,325,297,298,-1,324,325,298,-1,324,298,299,-1,323,324,299,-1,323,299,300,-1,322,323,300,-1,322,300,301,-1,321,322,301,-1,321,301,302,-1,320,321,302,-1,320,302,303,-1,345,344,343,-1,346,345,343,-1,346,343,342,-1,347,346,342,-1,348,347,342,-1,349,348,342,-1,350,349,342,-1,351,350,342,-1,328,351,342,-1,329,328,342,-1,329,342,341,-1,330,329,341,-1,330,341,340,-1,331,330,340,-1,332,331,340,-1,333,332,340,-1,334,333,340,-1,335,334,340,-1,336,335,340,-1,337,336,340,-1,337,340,339,-1,337,339,338,-1,328,329,353,-1,328,353,352,-1,329,330,354,-1,329,354,353,-1,330,331,355,-1,330,355,354,-1,331,332,356,-1,331,356,355,-1,332,333,357,-1,332,357,356,-1,333,334,358,-1,333,358,357,-1,334,335,359,-1,334,359,358,-1,335,336,360,-1,335,360,359,-1,336,337,361,-1,336,361,360,-1,337,338,362,-1,337,362,361,-1,338,339,363,-1,338,363,362,-1,339,340,364,-1,339,364,363,-1,340,341,365,-1,340,365,364,-1,341,342,366,-1,341,366,365,-1,342,343,367,-1,342,367,366,-1,343,344,368,-1,343,368,367,-1,344,345,369,-1,344,369,368,-1,345,346,370,-1,345,370,369,-1,346,347,371,-1,346,371,370,-1,347,348,372,-1,347,372,371,-1,348,349,373,-1,348,373,372,-1,349,350,374,-1,349,374,373,-1,350,351,375,-1,350,375,374,-1,351,328,352,-1,351,352,375,-1,367,368,369,-1,367,369,370,-1,366,367,370,-1,366,370,371,-1,366,371,372,-1,366,372,373,-1,366,373,374,-1,366,374,375,-1,366,375,352,-1,366,352,353,-1,365,366,353,-1,365,353,354,-1,364,365,354,-1,364,354,355,-1,364,355,356,-1,364,356,357,-1,364,357,358,-1,364,358,359,-1,364,359,360,-1,364,360,361,-1,363,364,361,-1,362,363,361,-1,376,391,390,-1,377,376,390,-1,377,390,389,-1,378,377,389,-1,378,389,388,-1,379,378,388,-1,379,388,387,-1,379,387,386,-1,379,386,385,-1,379,385,384,-1,379,384,383,-1,379,383,382,-1,380,379,382,-1,380,382,381,-1,376,377,393,-1,376,393,392,-1,377,378,394,-1,377,394,393,-1,378,379,395,-1,378,395,394,-1,379,380,396,-1,379,396,395,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_4()
		{
			int[] value = {380,381,397,-1,380,397,396,-1,381,382,398,-1,381,398,397,-1,382,383,399,-1,382,399,398,-1,383,384,400,-1,383,400,399,-1,384,385,401,-1,384,401,400,-1,385,386,402,-1,385,402,401,-1,386,387,403,-1,386,403,402,-1,387,388,404,-1,387,404,403,-1,388,389,405,-1,388,405,404,-1,389,390,406,-1,389,406,405,-1,390,391,407,-1,390,407,406,-1,391,376,392,-1,391,392,407,-1,392,393,409,-1,392,409,408,-1,393,394,410,-1,393,410,409,-1,394,395,411,-1,394,411,410,-1,395,396,412,-1,395,412,411,-1,396,397,413,-1,396,413,412,-1,397,398,414,-1,397,414,413,-1,398,399,415,-1,398,415,414,-1,399,400,416,-1,399,416,415,-1,400,401,417,-1,400,417,416,-1,401,402,418,-1,401,418,417,-1,402,403,419,-1,402,419,418,-1,403,404,420,-1,403,420,419,-1,404,405,421,-1,404,421,420,-1,405,406,422,-1,405,422,421,-1,406,407,423,-1,406,423,422,-1,407,392,408,-1,407,408,423,-1,408,409,425,-1,408,425,424,-1,409,410,426,-1,409,426,425,-1,410,411,427,-1,410,427,426,-1,411,412,428,-1,411,428,427,-1,412,413,429,-1,412,429,428,-1,413,414,430,-1,413,430,429,-1,414,415,431,-1,414,431,430,-1,415,416,432,-1,415,432,431,-1,416,417,433,-1,416,433,432,-1,417,418,434,-1,417,434,433,-1,418,419,435,-1,418,435,434,-1,419,420,436,-1,419,436,435,-1,420,421,437,-1,420,437,436,-1,421,422,438,-1,421,438,437,-1,422,423,439,-1,422,439,438,-1,423,408,424,-1,423,424,439,-1,424,425,441,-1,424,441,440,-1,425,426,442,-1,425,442,441,-1,426,427,443,-1,426,443,442,-1,427,428,444,-1,427,444,443,-1,428,429,445,-1,428,445,444,-1,429,430,446,-1,429,446,445,-1,430,431,447,-1,430,447,446,-1,431,432,448,-1,431,448,447,-1,432,433,449,-1,432,449,448,-1,433,434,450,-1,433,450,449,-1,434,435,451,-1,434,451,450,-1,435,436,452,-1,435,452,451,-1,436,437,453,-1,436,453,452,-1,437,438,454,-1,437,454,453,-1,438,439,455,-1,438,455,454,-1,439,424,440,-1,439,440,455,-1,440,441,457,-1,440,457,456,-1,441,442,458,-1,441,458,457,-1,442,443,459,-1,442,459,458,-1,443,444,460,-1,443,460,459,-1,444,445,461,-1,444,461,460,-1,445,446,462,-1,445,462,461,-1,446,447,463,-1,446,463,462,-1,447,448,464,-1,447,464,463,-1,448,449,465,-1,448,465,464,-1,449,450,466,-1,449,466,465,-1,450,451,467,-1,450,467,466,-1,451,452,468,-1,451,468,467,-1,452,453,469,-1,452,469,468,-1,453,454,470,-1,453,470,469,-1,454,455,471,-1,454,471,470,-1,455,440,456,-1,455,456,471,-1,456,457,473,-1,456,473,472,-1,457,458,474,-1,457,474,473,-1,458,459,475,-1,458,475,474,-1,459,460,476,-1,459,476,475,-1,460,461,477,-1,460,477,476,-1,461,462,478,-1,461,478,477,-1,462,463,479,-1,462,479,478,-1,463,464,480,-1,463,480,479,-1,464,465,481,-1,464,481,480,-1,465,466,482,-1,465,482,481,-1,466,467,483,-1,466,483,482,-1,467,468,484,-1,467,484,483,-1,468,469,485,-1,468,485,484,-1,469,470,486,-1,469,486,485,-1,470,471,487,-1,470,487,486,-1,471,456,472,-1,471,472,487,-1,472,473,489,-1,472,489,488,-1,473,474,490,-1,473,490,489,-1,474,475,491,-1,474,491,490,-1,475,476,492,-1,475,492,491,-1,476,477,493,-1,476,493,492,-1,477,478,494,-1,477,494,493,-1,478,479,495,-1,478,495,494,-1,479,480,496,-1,479,496,495,-1,480,481,497,-1,480,497,496,-1,481,482,498,-1,481,498,497,-1,482,483,499,-1,482,499,498,-1,483,484,500,-1,483,500,499,-1,484,485,501,-1,484,501,500,-1,485,486,502,-1,485,502,501,-1,486,487,503,-1,486,503,502,-1,487,472,488,-1,487,488,503,-1,488,489,505,-1,488,505,504,-1,489,490,506,-1,489,506,505,-1,490,491,507,-1,490,507,506,-1,491,492,508,-1,491,508,507,-1,492,493,509,-1,492,509,508,-1,493,494,510,-1,493,510,509,-1,494,495,511,-1,494,511,510,-1,495,496,512,-1,495,512,511,-1,496,497,513,-1,496,513,512,-1,497,498,514,-1,497,514,513,-1,498,499,515,-1,498,515,514,-1,499,500,516,-1,499,516,515,-1,500,501,517,-1,500,517,516,-1,501,502,518,-1,501,518,517,-1,502,503,519,-1,502,519,518,-1,503,488,504,-1,503,504,519,-1,504,505,521,-1,504,521,520,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_5()
		{
			int[] value = {505,506,522,-1,505,522,521,-1,506,507,523,-1,506,523,522,-1,507,508,524,-1,507,524,523,-1,508,509,525,-1,508,525,524,-1,509,510,526,-1,509,526,525,-1,510,511,527,-1,510,527,526,-1,511,512,528,-1,511,528,527,-1,512,513,529,-1,512,529,528,-1,513,514,530,-1,513,530,529,-1,514,515,531,-1,514,531,530,-1,515,516,532,-1,515,532,531,-1,516,517,533,-1,516,533,532,-1,517,518,534,-1,517,534,533,-1,518,519,535,-1,518,535,534,-1,519,504,520,-1,519,520,535,-1,520,521,537,-1,520,537,536,-1,521,522,538,-1,521,538,537,-1,522,523,539,-1,522,539,538,-1,523,524,540,-1,523,540,539,-1,524,525,541,-1,524,541,540,-1,525,526,542,-1,525,542,541,-1,526,527,543,-1,526,543,542,-1,527,528,544,-1,527,544,543,-1,528,529,545,-1,528,545,544,-1,529,530,546,-1,529,546,545,-1,530,531,547,-1,530,547,546,-1,531,532,548,-1,531,548,547,-1,532,533,549,-1,532,549,548,-1,533,534,550,-1,533,550,549,-1,534,535,551,-1,534,551,550,-1,535,520,536,-1,535,536,551,-1,536,537,553,-1,536,553,552,-1,537,538,554,-1,537,554,553,-1,538,539,555,-1,538,555,554,-1,539,540,556,-1,539,556,555,-1,540,541,557,-1,540,557,556,-1,541,542,558,-1,541,558,557,-1,542,543,559,-1,542,559,558,-1,543,544,560,-1,543,560,559,-1,544,545,561,-1,544,561,560,-1,545,546,562,-1,545,562,561,-1,546,547,563,-1,546,563,562,-1,547,548,564,-1,547,564,563,-1,548,549,565,-1,548,565,564,-1,549,550,566,-1,549,566,565,-1,550,551,567,-1,550,567,566,-1,551,536,552,-1,551,552,567,-1,566,567,552,-1,566,552,553,-1,565,566,553,-1,565,553,554,-1,564,565,554,-1,564,554,555,-1,563,564,555,-1,562,563,555,-1,561,562,555,-1,560,561,555,-1,559,560,555,-1,558,559,555,-1,558,555,556,-1,557,558,556,-1,568,569,570,-1,568,570,571,-1,568,572,573,-1,568,573,569,-1,569,573,574,-1,569,574,570,-1,570,574,575,-1,570,575,576,-1,570,576,571,-1,571,572,568,-1,572,577,578,-1,572,578,573,-1,573,578,579,-1,573,579,580,-1,573,580,574,-1,574,580,581,-1,574,581,582,-1,574,582,575,-1,575,582,583,-1,575,583,584,-1,575,584,576,-1,576,584,585,-1,576,585,586,-1,576,586,571,-1,571,586,577,-1,571,577,572,-1,577,587,578,-1,578,587,588,-1,578,588,579,-1,579,588,589,-1,579,589,590,-1,579,590,580,-1,580,590,581,-1,581,590,591,-1,581,591,592,-1,581,592,582,-1,582,592,583,-1,583,592,593,-1,583,593,594,-1,583,594,584,-1,584,594,585,-1,585,594,595,-1,585,595,596,-1,585,596,586,-1,586,596,587,-1,586,587,577,-1,587,589,588,-1,587,590,589,-1,587,591,590,-1,587,592,591,-1,587,593,592,-1,587,594,593,-1,587,595,594,-1,587,596,595,-1,597,598,599,-1,597,599,600,-1,597,601,602,-1,597,602,598,-1,598,602,603,-1,598,603,599,-1,599,603,604,-1,599,604,605,-1,599,605,600,-1,600,601,597,-1,601,606,607,-1,601,607,602,-1,602,607,608,-1,602,608,609,-1,602,609,603,-1,603,609,610,-1,603,610,611,-1,603,611,604,-1,604,611,612,-1,604,612,613,-1,604,613,605,-1,605,613,614,-1,605,614,615,-1,605,615,600,-1,600,615,606,-1,600,606,601,-1,606,616,607,-1,607,616,617,-1,607,617,608,-1,608,617,618,-1,608,618,619,-1,608,619,609,-1,609,619,610,-1,610,619,620,-1,610,620,621,-1,610,621,611,-1,611,621,612,-1,612,621,622,-1,612,622,623,-1,612,623,613,-1,613,623,614,-1,614,623,624,-1,614,624,625,-1,614,625,615,-1,615,625,616,-1,615,616,606,-1,616,618,617,-1,616,619,618,-1,616,620,619,-1,616,621,620,-1,616,622,621,-1,616,623,622,-1,616,624,623,-1,616,625,624,-1,626,627,628,-1,626,628,629,-1,626,630,631,-1,626,631,627,-1,627,631,632,-1,627,632,628,-1,628,632,633,-1,628,633,634,-1,628,634,629,-1,629,630,626,-1,630,635,636,-1,630,636,631,-1,631,636,637,-1,631,637,638,-1,631,638,632,-1,632,638,639,-1,632,639,640,-1,632,640,633,-1,633,640,641,-1,633,641,642,-1,633,642,634,-1,634,642,643,-1,634,643,644,-1,634,644,629,-1,629,644,635,-1,629,635,630,-1,635,645,636,-1,636,645,646,-1,636,646,637,-1,637,646,647,-1,637,647,648,-1,637,648,638,-1,638,648,639,-1,639,648,649,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_6()
		{
			int[] value = {639,649,650,-1,639,650,640,-1,640,650,641,-1,641,650,651,-1,641,651,652,-1,641,652,642,-1,642,652,643,-1,643,652,653,-1,643,653,654,-1,643,654,644,-1,644,654,645,-1,644,645,635,-1,645,647,646,-1,645,648,647,-1,645,649,648,-1,645,650,649,-1,645,651,650,-1,645,652,651,-1,645,653,652,-1,645,654,653,-1,655,656,657,-1,655,657,658,-1,655,659,660,-1,655,660,656,-1,656,660,661,-1,656,661,657,-1,657,661,662,-1,657,662,663,-1,657,663,658,-1,658,659,655,-1,659,664,665,-1,659,665,660,-1,660,665,666,-1,660,666,667,-1,660,667,661,-1,661,667,668,-1,661,668,669,-1,661,669,662,-1,662,669,670,-1,662,670,671,-1,662,671,663,-1,663,671,672,-1,663,672,673,-1,663,673,658,-1,658,673,664,-1,658,664,659,-1,664,674,665,-1,665,674,675,-1,665,675,666,-1,666,675,676,-1,666,676,677,-1,666,677,667,-1,667,677,668,-1,668,677,678,-1,668,678,679,-1,668,679,669,-1,669,679,670,-1,670,679,680,-1,670,680,681,-1,670,681,671,-1,671,681,672,-1,672,681,682,-1,672,682,683,-1,672,683,673,-1,673,683,674,-1,673,674,664,-1,674,676,675,-1,674,677,676,-1,674,678,677,-1,674,679,678,-1,674,680,679,-1,674,681,680,-1,674,682,681,-1,674,683,682,-1,684,685,686,-1,684,686,687,-1,684,688,689,-1,684,689,685,-1,685,689,690,-1,685,690,686,-1,686,690,691,-1,686,691,692,-1,686,692,687,-1,687,688,684,-1,688,693,694,-1,688,694,689,-1,689,694,695,-1,689,695,696,-1,689,696,690,-1,690,696,697,-1,690,697,698,-1,690,698,691,-1,691,698,699,-1,691,699,700,-1,691,700,692,-1,692,700,701,-1,692,701,702,-1,692,702,687,-1,687,702,693,-1,687,693,688,-1,693,703,694,-1,694,703,704,-1,694,704,695,-1,695,704,705,-1,695,705,706,-1,695,706,696,-1,696,706,697,-1,697,706,707,-1,697,707,708,-1,697,708,698,-1,698,708,699,-1,699,708,709,-1,699,709,710,-1,699,710,700,-1,700,710,701,-1,701,710,711,-1,701,711,712,-1,701,712,702,-1,702,712,703,-1,702,703,693,-1,703,705,704,-1,703,706,705,-1,703,707,706,-1,703,708,707,-1,703,709,708,-1,703,710,709,-1,703,711,710,-1,703,712,711,-1,713,714,715,-1,713,715,716,-1,713,717,718,-1,713,718,714,-1,714,718,719,-1,714,719,715,-1,715,719,720,-1,715,720,721,-1,715,721,716,-1,716,717,713,-1,717,722,723,-1,717,723,718,-1,718,723,724,-1,718,724,725,-1,718,725,719,-1,719,725,726,-1,719,726,727,-1,719,727,720,-1,720,727,728,-1,720,728,729,-1,720,729,721,-1,721,729,730,-1,721,730,731,-1,721,731,716,-1,716,731,722,-1,716,722,717,-1,722,732,723,-1,723,732,733,-1,723,733,724,-1,724,733,734,-1,724,734,735,-1,724,735,725,-1,725,735,726,-1,726,735,736,-1,726,736,737,-1,726,737,727,-1,727,737,728,-1,728,737,738,-1,728,738,739,-1,728,739,729,-1,729,739,730,-1,730,739,740,-1,730,740,741,-1,730,741,731,-1,731,741,732,-1,731,732,722,-1,732,734,733,-1,732,735,734,-1,732,736,735,-1,732,737,736,-1,732,738,737,-1,732,739,738,-1,732,740,739,-1,732,741,740,-1,742,743,744,-1,742,744,745,-1,742,746,747,-1,742,747,743,-1,743,747,748,-1,743,748,744,-1,744,748,749,-1,744,749,750,-1,744,750,745,-1,745,746,742,-1,746,751,752,-1,746,752,747,-1,747,752,753,-1,747,753,754,-1,747,754,748,-1,748,754,755,-1,748,755,756,-1,748,756,749,-1,749,756,757,-1,749,757,758,-1,749,758,750,-1,750,758,759,-1,750,759,760,-1,750,760,745,-1,745,760,751,-1,745,751,746,-1,751,761,752,-1,752,761,762,-1,752,762,753,-1,753,762,763,-1,753,763,764,-1,753,764,754,-1,754,764,755,-1,755,764,765,-1,755,765,766,-1,755,766,756,-1,756,766,757,-1,757,766,767,-1,757,767,768,-1,757,768,758,-1,758,768,759,-1,759,768,769,-1,759,769,770,-1,759,770,760,-1,760,770,761,-1,760,761,751,-1,761,763,762,-1,761,764,763,-1,761,765,764,-1,761,766,765,-1,761,767,766,-1,761,768,767,-1,761,769,768,-1,761,770,769,-1,775,774,773,-1,776,775,773,-1,777,776,773,-1,778,777,773,-1,771,778,773,-1,772,771,773,-1,771,772,780,-1,771,780,779,-1,772,773,781,-1,772,781,780,-1,774,775,788,-1,775,776,782,-1,775,782,788,-1,776,783,782,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_7()
		{
			int[] value = {776,777,784,-1,776,784,783,-1,777,778,785,-1,777,785,784,-1,778,771,779,-1,778,779,785,-1,779,780,787,-1,779,787,786,-1,780,781,787,-1,788,782,789,-1,782,783,789,-1,783,784,790,-1,783,790,789,-1,784,785,791,-1,784,791,790,-1,785,779,786,-1,785,786,791,-1,786,787,793,-1,786,793,792,-1,787,781,794,-1,787,794,793,-1,781,773,794,-1,773,774,795,-1,773,795,794,-1,774,788,795,-1,788,789,796,-1,788,796,795,-1,789,790,797,-1,789,797,796,-1,790,791,798,-1,790,798,797,-1,791,786,792,-1,791,792,798,-1,794,795,796,-1,794,796,797,-1,794,797,798,-1,794,798,792,-1,794,792,793,-1,803,802,801,-1,804,803,801,-1,805,804,801,-1,806,805,801,-1,799,806,801,-1,800,799,801,-1,799,800,808,-1,799,808,807,-1,800,801,809,-1,800,809,808,-1,802,803,816,-1,803,804,810,-1,803,810,816,-1,804,811,810,-1,804,805,812,-1,804,812,811,-1,805,806,813,-1,805,813,812,-1,806,799,807,-1,806,807,813,-1,807,808,815,-1,807,815,814,-1,808,809,815,-1,816,810,817,-1,810,811,817,-1,811,812,818,-1,811,818,817,-1,812,813,819,-1,812,819,818,-1,813,807,814,-1,813,814,819,-1,814,815,821,-1,814,821,820,-1,815,809,822,-1,815,822,821,-1,809,801,822,-1,801,802,823,-1,801,823,822,-1,802,816,823,-1,816,817,824,-1,816,824,823,-1,817,818,825,-1,817,825,824,-1,818,819,826,-1,818,826,825,-1,819,814,820,-1,819,820,826,-1,822,823,824,-1,822,824,825,-1,822,825,826,-1,822,826,820,-1,822,820,821,-1,831,830,829,-1,832,831,829,-1,833,832,829,-1,834,833,829,-1,827,834,829,-1,828,827,829,-1,827,828,836,-1,827,836,835,-1,828,829,837,-1,828,837,836,-1,830,831,844,-1,831,832,838,-1,831,838,844,-1,832,839,838,-1,832,833,840,-1,832,840,839,-1,833,834,841,-1,833,841,840,-1,834,827,835,-1,834,835,841,-1,835,836,843,-1,835,843,842,-1,836,837,843,-1,844,838,845,-1,838,839,845,-1,839,840,846,-1,839,846,845,-1,840,841,847,-1,840,847,846,-1,841,835,842,-1,841,842,847,-1,842,843,849,-1,842,849,848,-1,843,837,850,-1,843,850,849,-1,837,829,850,-1,829,830,851,-1,829,851,850,-1,830,844,851,-1,844,845,852,-1,844,852,851,-1,845,846,853,-1,845,853,852,-1,846,847,854,-1,846,854,853,-1,847,842,848,-1,847,848,854,-1,850,851,852,-1,850,852,853,-1,850,853,854,-1,850,854,848,-1,850,848,849,-1,859,858,857,-1,860,859,857,-1,861,860,857,-1,862,861,857,-1,855,862,857,-1,856,855,857,-1,855,856,864,-1,855,864,863,-1,856,857,865,-1,856,865,864,-1,858,859,872,-1,859,860,866,-1,859,866,872,-1,860,867,866,-1,860,861,868,-1,860,868,867,-1,861,862,869,-1,861,869,868,-1,862,855,863,-1,862,863,869,-1,863,864,871,-1,863,871,870,-1,864,865,871,-1,872,866,873,-1,866,867,873,-1,867,868,874,-1,867,874,873,-1,868,869,875,-1,868,875,874,-1,869,863,870,-1,869,870,875,-1,870,871,877,-1,870,877,876,-1,871,865,878,-1,871,878,877,-1,865,857,878,-1,857,858,879,-1,857,879,878,-1,858,872,879,-1,872,873,880,-1,872,880,879,-1,873,874,881,-1,873,881,880,-1,874,875,882,-1,874,882,881,-1,875,870,876,-1,875,876,882,-1,878,879,880,-1,878,880,881,-1,878,881,882,-1,878,882,876,-1,878,876,877,-1,887,886,885,-1,888,887,885,-1,889,888,885,-1,890,889,885,-1,883,890,885,-1,884,883,885,-1,883,884,892,-1,883,892,891,-1,884,885,893,-1,884,893,892,-1,886,887,900,-1,887,888,894,-1,887,894,900,-1,888,895,894,-1,888,889,896,-1,888,896,895,-1,889,890,897,-1,889,897,896,-1,890,883,891,-1,890,891,897,-1,891,892,899,-1,891,899,898,-1,892,893,899,-1,900,894,901,-1,894,895,901,-1,895,896,902,-1,895,902,901,-1,896,897,903,-1,896,903,902,-1,897,891,898,-1,897,898,903,-1,898,899,905,-1,898,905,904,-1,899,893,906,-1,899,906,905,-1,893,885,906,-1,885,886,907,-1,885,907,906,-1,886,900,907,-1,900,901,908,-1,900,908,907,-1,901,902,909,-1,901,909,908,-1,902,903,910,-1,902,910,909,-1,903,898,904,-1,903,904,910,-1,906,907,908,-1,906,908,909,-1,906,909,910,-1,906,910,904,-1,906,904,905,-1,915,914,913,-1,916,915,913,-1,917,916,913,-1,918,917,913,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_8()
		{
			int[] value = {911,918,913,-1,912,911,913,-1,911,912,920,-1,911,920,919,-1,912,913,921,-1,912,921,920,-1,914,915,928,-1,915,916,922,-1,915,922,928,-1,916,923,922,-1,916,917,924,-1,916,924,923,-1,917,918,925,-1,917,925,924,-1,918,911,919,-1,918,919,925,-1,919,920,927,-1,919,927,926,-1,920,921,927,-1,928,922,929,-1,922,923,929,-1,923,924,930,-1,923,930,929,-1,924,925,931,-1,924,931,930,-1,925,919,926,-1,925,926,931,-1,926,927,933,-1,926,933,932,-1,927,921,934,-1,927,934,933,-1,921,913,934,-1,913,914,935,-1,913,935,934,-1,914,928,935,-1,928,929,936,-1,928,936,935,-1,929,930,937,-1,929,937,936,-1,930,931,938,-1,930,938,937,-1,931,926,932,-1,931,932,938,-1,934,935,936,-1,934,936,937,-1,934,937,938,-1,934,938,932,-1,934,932,933,-1,943,942,941,-1,944,943,941,-1,945,944,941,-1,946,945,941,-1,939,946,941,-1,940,939,941,-1,939,940,948,-1,939,948,947,-1,940,941,949,-1,940,949,948,-1,942,943,956,-1,943,944,950,-1,943,950,956,-1,944,951,950,-1,944,945,952,-1,944,952,951,-1,945,946,953,-1,945,953,952,-1,946,939,947,-1,946,947,953,-1,947,948,955,-1,947,955,954,-1,948,949,955,-1,956,950,957,-1,950,951,957,-1,951,952,958,-1,951,958,957,-1,952,953,959,-1,952,959,958,-1,953,947,954,-1,953,954,959,-1,954,955,961,-1,954,961,960,-1,955,949,962,-1,955,962,961,-1,949,941,962,-1,941,942,963,-1,941,963,962,-1,942,956,963,-1,956,957,964,-1,956,964,963,-1,957,958,965,-1,957,965,964,-1,958,959,966,-1,958,966,965,-1,959,954,960,-1,959,960,966,-1,962,963,964,-1,962,964,965,-1,962,965,966,-1,962,966,960,-1,962,960,961,-1,971,970,969,-1,972,971,969,-1,973,972,969,-1,974,973,969,-1,967,974,969,-1,968,967,969,-1,967,968,976,-1,967,976,975,-1,968,969,977,-1,968,977,976,-1,970,971,984,-1,971,972,978,-1,971,978,984,-1,972,979,978,-1,972,973,980,-1,972,980,979,-1,973,974,981,-1,973,981,980,-1,974,967,975,-1,974,975,981,-1,975,976,983,-1,975,983,982,-1,976,977,983,-1,984,978,985,-1,978,979,985,-1,979,980,986,-1,979,986,985,-1,980,981,987,-1,980,987,986,-1,981,975,982,-1,981,982,987,-1,982,983,989,-1,982,989,988,-1,983,977,990,-1,983,990,989,-1,977,969,990,-1,969,970,991,-1,969,991,990,-1,970,984,991,-1,984,985,992,-1,984,992,991,-1,985,986,993,-1,985,993,992,-1,986,987,994,-1,986,994,993,-1,987,982,988,-1,987,988,994,-1,990,991,992,-1,990,992,993,-1,990,993,994,-1,990,994,988,-1,990,988,989,-1,999,998,997,-1,1000,999,997,-1,1001,1000,997,-1,1002,1001,997,-1,995,1002,997,-1,996,995,997,-1,995,996,1004,-1,995,1004,1003,-1,996,997,1005,-1,996,1005,1004,-1,998,999,1012,-1,999,1000,1006,-1,999,1006,1012,-1,1000,1007,1006,-1,1000,1001,1008,-1,1000,1008,1007,-1,1001,1002,1009,-1,1001,1009,1008,-1,1002,995,1003,-1,1002,1003,1009,-1,1003,1004,1011,-1,1003,1011,1010,-1,1004,1005,1011,-1,1012,1006,1013,-1,1006,1007,1013,-1,1007,1008,1014,-1,1007,1014,1013,-1,1008,1009,1015,-1,1008,1015,1014,-1,1009,1003,1010,-1,1009,1010,1015,-1,1010,1011,1017,-1,1010,1017,1016,-1,1011,1005,1018,-1,1011,1018,1017,-1,1005,997,1018,-1,997,998,1019,-1,997,1019,1018,-1,998,1012,1019,-1,1012,1013,1020,-1,1012,1020,1019,-1,1013,1014,1021,-1,1013,1021,1020,-1,1014,1015,1022,-1,1014,1022,1021,-1,1015,1010,1016,-1,1015,1016,1022,-1,1018,1019,1020,-1,1018,1020,1021,-1,1018,1021,1022,-1,1018,1022,1016,-1,1018,1016,1017,-1,1027,1026,1025,-1,1028,1027,1025,-1,1029,1028,1025,-1,1030,1029,1025,-1,1023,1030,1025,-1,1024,1023,1025,-1,1023,1024,1032,-1,1023,1032,1031,-1,1024,1025,1033,-1,1024,1033,1032,-1,1026,1027,1040,-1,1027,1028,1034,-1,1027,1034,1040,-1,1028,1035,1034,-1,1028,1029,1036,-1,1028,1036,1035,-1,1029,1030,1037,-1,1029,1037,1036,-1,1030,1023,1031,-1,1030,1031,1037,-1,1031,1032,1039,-1,1031,1039,1038,-1,1032,1033,1039,-1,1040,1034,1041,-1,1034,1035,1041,-1,1035,1036,1042,-1,1035,1042,1041,-1,1036,1037,1043,-1,1036,1043,1042,-1,1037,1031,1038,-1,1037,1038,1043,-1,1038,1039,1045,-1,1038,1045,1044,-1,1039,1033,1046,-1,1039,1046,1045,-1,1033,1025,1046,-1,1025,1026,1047,-1,1025,1047,1046,-1,1026,1040,1047,-1,1040,1041,1048,-1,1040,1048,1047,-1,1041,1042,1049,-1,1041,1049,1048,-1,1042,1043,1050,-1,1042,1050,1049,-1,1043,1038,1044,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_9()
		{
			int[] value = {1043,1044,1050,-1,1046,1047,1048,-1,1046,1048,1049,-1,1046,1049,1050,-1,1046,1050,1044,-1,1046,1044,1045,-1,1055,1054,1053,-1,1056,1055,1053,-1,1057,1056,1053,-1,1058,1057,1053,-1,1051,1058,1053,-1,1052,1051,1053,-1,1051,1052,1060,-1,1051,1060,1059,-1,1052,1053,1061,-1,1052,1061,1060,-1,1054,1055,1068,-1,1055,1056,1062,-1,1055,1062,1068,-1,1056,1063,1062,-1,1056,1057,1064,-1,1056,1064,1063,-1,1057,1058,1065,-1,1057,1065,1064,-1,1058,1051,1059,-1,1058,1059,1065,-1,1059,1060,1067,-1,1059,1067,1066,-1,1060,1061,1067,-1,1068,1062,1069,-1,1062,1063,1069,-1,1063,1064,1070,-1,1063,1070,1069,-1,1064,1065,1071,-1,1064,1071,1070,-1,1065,1059,1066,-1,1065,1066,1071,-1,1066,1067,1073,-1,1066,1073,1072,-1,1067,1061,1074,-1,1067,1074,1073,-1,1061,1053,1074,-1,1053,1054,1075,-1,1053,1075,1074,-1,1054,1068,1075,-1,1068,1069,1076,-1,1068,1076,1075,-1,1069,1070,1077,-1,1069,1077,1076,-1,1070,1071,1078,-1,1070,1078,1077,-1,1071,1066,1072,-1,1071,1072,1078,-1,1074,1075,1076,-1,1074,1076,1077,-1,1074,1077,1078,-1,1074,1078,1072,-1,1074,1072,1073,-1,1083,1082,1081,-1,1084,1083,1081,-1,1085,1084,1081,-1,1086,1085,1081,-1,1079,1086,1081,-1,1080,1079,1081,-1,1079,1080,1088,-1,1079,1088,1087,-1,1080,1081,1089,-1,1080,1089,1088,-1,1082,1083,1096,-1,1083,1084,1090,-1,1083,1090,1096,-1,1084,1091,1090,-1,1084,1085,1092,-1,1084,1092,1091,-1,1085,1086,1093,-1,1085,1093,1092,-1,1086,1079,1087,-1,1086,1087,1093,-1,1087,1088,1095,-1,1087,1095,1094,-1,1088,1089,1095,-1,1096,1090,1097,-1,1090,1091,1097,-1,1091,1092,1098,-1,1091,1098,1097,-1,1092,1093,1099,-1,1092,1099,1098,-1,1093,1087,1094,-1,1093,1094,1099,-1,1094,1095,1101,-1,1094,1101,1100,-1,1095,1089,1102,-1,1095,1102,1101,-1,1089,1081,1102,-1,1081,1082,1103,-1,1081,1103,1102,-1,1082,1096,1103,-1,1096,1097,1104,-1,1096,1104,1103,-1,1097,1098,1105,-1,1097,1105,1104,-1,1098,1099,1106,-1,1098,1106,1105,-1,1099,1094,1100,-1,1099,1100,1106,-1,1102,1103,1104,-1,1102,1104,1105,-1,1102,1105,1106,-1,1102,1106,1100,-1,1102,1100,1101,-1,1111,1110,1109,-1,1112,1111,1109,-1,1113,1112,1109,-1,1114,1113,1109,-1,1107,1114,1109,-1,1108,1107,1109,-1,1107,1108,1116,-1,1107,1116,1115,-1,1108,1109,1117,-1,1108,1117,1116,-1,1110,1111,1124,-1,1111,1112,1118,-1,1111,1118,1124,-1,1112,1119,1118,-1,1112,1113,1120,-1,1112,1120,1119,-1,1113,1114,1121,-1,1113,1121,1120,-1,1114,1107,1115,-1,1114,1115,1121,-1,1115,1116,1123,-1,1115,1123,1122,-1,1116,1117,1123,-1,1124,1118,1125,-1,1118,1119,1125,-1,1119,1120,1126,-1,1119,1126,1125,-1,1120,1121,1127,-1,1120,1127,1126,-1,1121,1115,1122,-1,1121,1122,1127,-1,1122,1123,1129,-1,1122,1129,1128,-1,1123,1117,1130,-1,1123,1130,1129,-1,1117,1109,1130,-1,1109,1110,1131,-1,1109,1131,1130,-1,1110,1124,1131,-1,1124,1125,1132,-1,1124,1132,1131,-1,1125,1126,1133,-1,1125,1133,1132,-1,1126,1127,1134,-1,1126,1134,1133,-1,1127,1122,1128,-1,1127,1128,1134,-1,1130,1131,1132,-1,1130,1132,1133,-1,1130,1133,1134,-1,1130,1134,1128,-1,1130,1128,1129,-1,1139,1138,1137,-1,1140,1139,1137,-1,1141,1140,1137,-1,1142,1141,1137,-1,1135,1142,1137,-1,1136,1135,1137,-1,1135,1136,1144,-1,1135,1144,1143,-1,1136,1137,1145,-1,1136,1145,1144,-1,1138,1139,1152,-1,1139,1140,1146,-1,1139,1146,1152,-1,1140,1147,1146,-1,1140,1141,1148,-1,1140,1148,1147,-1,1141,1142,1149,-1,1141,1149,1148,-1,1142,1135,1143,-1,1142,1143,1149,-1,1143,1144,1151,-1,1143,1151,1150,-1,1144,1145,1151,-1,1152,1146,1153,-1,1146,1147,1153,-1,1147,1148,1154,-1,1147,1154,1153,-1,1148,1149,1155,-1,1148,1155,1154,-1,1149,1143,1150,-1,1149,1150,1155,-1,1150,1151,1157,-1,1150,1157,1156,-1,1151,1145,1158,-1,1151,1158,1157,-1,1145,1137,1158,-1,1137,1138,1159,-1,1137,1159,1158,-1,1138,1152,1159,-1,1152,1153,1160,-1,1152,1160,1159,-1,1153,1154,1161,-1,1153,1161,1160,-1,1154,1155,1162,-1,1154,1162,1161,-1,1155,1150,1156,-1,1155,1156,1162,-1,1158,1159,1160,-1,1158,1160,1161,-1,1158,1161,1162,-1,1158,1162,1156,-1,1158,1156,1157,-1,1167,1166,1165,-1,1168,1167,1165,-1,1169,1168,1165,-1,1170,1169,1165,-1,1163,1170,1165,-1,1164,1163,1165,-1,1163,1164,1172,-1,1163,1172,1171,-1,1164,1165,1173,-1,1164,1173,1172,-1,1166,1167,1180,-1,1167,1168,1174,-1,1167,1174,1180,-1,1168,1175,1174,-1,1168,1169,1176,-1,1168,1176,1175,-1,1169,1170,1177,-1,1169,1177,1176,-1,1170,1163,1171,-1,1170,1171,1177,-1,1171,1172,1179,-1,1171,1179,1178,-1,1172,1173,1179,-1,1180,1174,1181,-1,1174,1175,1181,-1,1175,1176,1182,-1,1175,1182,1181,-1,1176,1177,1183,-1,1176,1183,1182,-1,1177,1171,1178,-1,1177,1178,1183,-1,1178,1179,1185,-1,1178,1185,1184,-1,1179,1173,1186,-1,1179,1186,1185,-1,1173,1165,1186,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_10()
		{
			int[] value = {1165,1166,1187,-1,1165,1187,1186,-1,1166,1180,1187,-1,1180,1181,1188,-1,1180,1188,1187,-1,1181,1182,1189,-1,1181,1189,1188,-1,1182,1183,1190,-1,1182,1190,1189,-1,1183,1178,1184,-1,1183,1184,1190,-1,1186,1187,1188,-1,1186,1188,1189,-1,1186,1189,1190,-1,1186,1190,1184,-1,1186,1184,1185,-1,1195,1194,1193,-1,1196,1195,1193,-1,1197,1196,1193,-1,1198,1197,1193,-1,1191,1198,1193,-1,1192,1191,1193,-1,1191,1192,1200,-1,1191,1200,1199,-1,1192,1193,1201,-1,1192,1201,1200,-1,1194,1195,1208,-1,1195,1196,1202,-1,1195,1202,1208,-1,1196,1203,1202,-1,1196,1197,1204,-1,1196,1204,1203,-1,1197,1198,1205,-1,1197,1205,1204,-1,1198,1191,1199,-1,1198,1199,1205,-1,1199,1200,1207,-1,1199,1207,1206,-1,1200,1201,1207,-1,1208,1202,1209,-1,1202,1203,1209,-1,1203,1204,1210,-1,1203,1210,1209,-1,1204,1205,1211,-1,1204,1211,1210,-1,1205,1199,1206,-1,1205,1206,1211,-1,1206,1207,1213,-1,1206,1213,1212,-1,1207,1201,1214,-1,1207,1214,1213,-1,1201,1193,1214,-1,1193,1194,1215,-1,1193,1215,1214,-1,1194,1208,1215,-1,1208,1209,1216,-1,1208,1216,1215,-1,1209,1210,1217,-1,1209,1217,1216,-1,1210,1211,1218,-1,1210,1218,1217,-1,1211,1206,1212,-1,1211,1212,1218,-1,1214,1215,1216,-1,1214,1216,1217,-1,1214,1217,1218,-1,1214,1218,1212,-1,1214,1212,1213,-1,1223,1222,1221,-1,1224,1223,1221,-1,1225,1224,1221,-1,1226,1225,1221,-1,1219,1226,1221,-1,1220,1219,1221,-1,1219,1220,1228,-1,1219,1228,1227,-1,1220,1221,1229,-1,1220,1229,1228,-1,1222,1223,1236,-1,1223,1224,1230,-1,1223,1230,1236,-1,1224,1231,1230,-1,1224,1225,1232,-1,1224,1232,1231,-1,1225,1226,1233,-1,1225,1233,1232,-1,1226,1219,1227,-1,1226,1227,1233,-1,1227,1228,1235,-1,1227,1235,1234,-1,1228,1229,1235,-1,1236,1230,1237,-1,1230,1231,1237,-1,1231,1232,1238,-1,1231,1238,1237,-1,1232,1233,1239,-1,1232,1239,1238,-1,1233,1227,1234,-1,1233,1234,1239,-1,1234,1235,1241,-1,1234,1241,1240,-1,1235,1229,1242,-1,1235,1242,1241,-1,1229,1221,1242,-1,1221,1222,1243,-1,1221,1243,1242,-1,1222,1236,1243,-1,1236,1237,1244,-1,1236,1244,1243,-1,1237,1238,1245,-1,1237,1245,1244,-1,1238,1239,1246,-1,1238,1246,1245,-1,1239,1234,1240,-1,1239,1240,1246,-1,1242,1243,1244,-1,1242,1244,1245,-1,1242,1245,1246,-1,1242,1246,1240,-1,1242,1240,1241,-1,1251,1250,1249,-1,1252,1251,1249,-1,1253,1252,1249,-1,1254,1253,1249,-1,1247,1254,1249,-1,1248,1247,1249,-1,1247,1248,1256,-1,1247,1256,1255,-1,1248,1249,1257,-1,1248,1257,1256,-1,1250,1251,1264,-1,1251,1252,1258,-1,1251,1258,1264,-1,1252,1259,1258,-1,1252,1253,1260,-1,1252,1260,1259,-1,1253,1254,1261,-1,1253,1261,1260,-1,1254,1247,1255,-1,1254,1255,1261,-1,1255,1256,1263,-1,1255,1263,1262,-1,1256,1257,1263,-1,1264,1258,1265,-1,1258,1259,1265,-1,1259,1260,1266,-1,1259,1266,1265,-1,1260,1261,1267,-1,1260,1267,1266,-1,1261,1255,1262,-1,1261,1262,1267,-1,1262,1263,1269,-1,1262,1269,1268,-1,1263,1257,1270,-1,1263,1270,1269,-1,1257,1249,1270,-1,1249,1250,1271,-1,1249,1271,1270,-1,1250,1264,1271,-1,1264,1265,1272,-1,1264,1272,1271,-1,1265,1266,1273,-1,1265,1273,1272,-1,1266,1267,1274,-1,1266,1274,1273,-1,1267,1262,1268,-1,1267,1268,1274,-1,1270,1271,1272,-1,1270,1272,1273,-1,1270,1273,1274,-1,1270,1274,1268,-1,1270,1268,1269,-1,1279,1278,1277,-1,1280,1279,1277,-1,1281,1280,1277,-1,1282,1281,1277,-1,1275,1282,1277,-1,1276,1275,1277,-1,1275,1276,1284,-1,1275,1284,1283,-1,1276,1277,1285,-1,1276,1285,1284,-1,1278,1279,1292,-1,1279,1280,1286,-1,1279,1286,1292,-1,1280,1287,1286,-1,1280,1281,1288,-1,1280,1288,1287,-1,1281,1282,1289,-1,1281,1289,1288,-1,1282,1275,1283,-1,1282,1283,1289,-1,1283,1284,1291,-1,1283,1291,1290,-1,1284,1285,1291,-1,1292,1286,1293,-1,1286,1287,1293,-1,1287,1288,1294,-1,1287,1294,1293,-1,1288,1289,1295,-1,1288,1295,1294,-1,1289,1283,1290,-1,1289,1290,1295,-1,1290,1291,1297,-1,1290,1297,1296,-1,1291,1285,1298,-1,1291,1298,1297,-1,1285,1277,1298,-1,1277,1278,1299,-1,1277,1299,1298,-1,1278,1292,1299,-1,1292,1293,1300,-1,1292,1300,1299,-1,1293,1294,1301,-1,1293,1301,1300,-1,1294,1295,1302,-1,1294,1302,1301,-1,1295,1290,1296,-1,1295,1296,1302,-1,1298,1299,1300,-1,1298,1300,1301,-1,1298,1301,1302,-1,1298,1302,1296,-1,1298,1296,1297,-1,1307,1306,1305,-1,1308,1307,1305,-1,1309,1308,1305,-1,1310,1309,1305,-1,1303,1310,1305,-1,1304,1303,1305,-1,1303,1304,1312,-1,1303,1312,1311,-1,1304,1305,1313,-1,1304,1313,1312,-1,1306,1307,1320,-1,1307,1308,1314,-1,1307,1314,1320,-1,1308,1315,1314,-1,1308,1309,1316,-1,1308,1316,1315,-1,1309,1310,1317,-1,1309,1317,1316,-1,1310,1303,1311,-1,1310,1311,1317,-1,1311,1312,1319,-1,1311,1319,1318,-1,1312,1313,1319,-1,1320,1314,1321,-1,1314,1315,1321,-1,1315,1316,1322,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_11()
		{
			int[] value = {1315,1322,1321,-1,1316,1317,1323,-1,1316,1323,1322,-1,1317,1311,1318,-1,1317,1318,1323,-1,1318,1319,1325,-1,1318,1325,1324,-1,1319,1313,1326,-1,1319,1326,1325,-1,1313,1305,1326,-1,1305,1306,1327,-1,1305,1327,1326,-1,1306,1320,1327,-1,1320,1321,1328,-1,1320,1328,1327,-1,1321,1322,1329,-1,1321,1329,1328,-1,1322,1323,1330,-1,1322,1330,1329,-1,1323,1318,1324,-1,1323,1324,1330,-1,1326,1327,1328,-1,1326,1328,1329,-1,1326,1329,1330,-1,1326,1330,1324,-1,1326,1324,1325,-1,1331,1332,1333,-1,1331,1333,1334,-1,1331,1335,1336,-1,1331,1336,1332,-1,1332,1336,1337,-1,1332,1337,1333,-1,1333,1337,1338,-1,1333,1338,1339,-1,1333,1339,1334,-1,1334,1335,1331,-1,1335,1340,1341,-1,1335,1341,1336,-1,1336,1341,1342,-1,1336,1342,1343,-1,1336,1343,1337,-1,1337,1343,1344,-1,1337,1344,1345,-1,1337,1345,1338,-1,1338,1345,1346,-1,1338,1346,1347,-1,1338,1347,1339,-1,1339,1347,1348,-1,1339,1348,1349,-1,1339,1349,1334,-1,1334,1349,1340,-1,1334,1340,1335,-1,1340,1350,1341,-1,1341,1350,1351,-1,1341,1351,1342,-1,1342,1351,1352,-1,1342,1352,1353,-1,1342,1353,1343,-1,1343,1353,1344,-1,1344,1353,1354,-1,1344,1354,1355,-1,1344,1355,1345,-1,1345,1355,1346,-1,1346,1355,1356,-1,1346,1356,1357,-1,1346,1357,1347,-1,1347,1357,1348,-1,1348,1357,1358,-1,1348,1358,1359,-1,1348,1359,1349,-1,1349,1359,1350,-1,1349,1350,1340,-1,1350,1352,1351,-1,1350,1353,1352,-1,1350,1354,1353,-1,1350,1355,1354,-1,1350,1356,1355,-1,1350,1357,1356,-1,1350,1358,1357,-1,1350,1359,1358,-1,1360,1361,1362,-1,1360,1362,1363,-1,1360,1364,1365,-1,1360,1365,1361,-1,1361,1365,1366,-1,1361,1366,1362,-1,1362,1366,1367,-1,1362,1367,1368,-1,1362,1368,1363,-1,1363,1364,1360,-1,1364,1369,1370,-1,1364,1370,1365,-1,1365,1370,1371,-1,1365,1371,1372,-1,1365,1372,1366,-1,1366,1372,1373,-1,1366,1373,1374,-1,1366,1374,1367,-1,1367,1374,1375,-1,1367,1375,1376,-1,1367,1376,1368,-1,1368,1376,1377,-1,1368,1377,1378,-1,1368,1378,1363,-1,1363,1378,1369,-1,1363,1369,1364,-1,1369,1379,1370,-1,1370,1379,1380,-1,1370,1380,1371,-1,1371,1380,1381,-1,1371,1381,1382,-1,1371,1382,1372,-1,1372,1382,1373,-1,1373,1382,1383,-1,1373,1383,1384,-1,1373,1384,1374,-1,1374,1384,1375,-1,1375,1384,1385,-1,1375,1385,1386,-1,1375,1386,1376,-1,1376,1386,1377,-1,1377,1386,1387,-1,1377,1387,1388,-1,1377,1388,1378,-1,1378,1388,1379,-1,1378,1379,1369,-1,1379,1381,1380,-1,1379,1382,1381,-1,1379,1383,1382,-1,1379,1384,1383,-1,1379,1385,1384,-1,1379,1386,1385,-1,1379,1387,1386,-1,1379,1388,1387,-1,1389,1390,1391,-1,1389,1391,1392,-1,1389,1393,1394,-1,1389,1394,1390,-1,1390,1394,1395,-1,1390,1395,1391,-1,1391,1395,1396,-1,1391,1396,1397,-1,1391,1397,1392,-1,1392,1393,1389,-1,1393,1398,1399,-1,1393,1399,1394,-1,1394,1399,1400,-1,1394,1400,1401,-1,1394,1401,1395,-1,1395,1401,1402,-1,1395,1402,1403,-1,1395,1403,1396,-1,1396,1403,1404,-1,1396,1404,1405,-1,1396,1405,1397,-1,1397,1405,1406,-1,1397,1406,1407,-1,1397,1407,1392,-1,1392,1407,1398,-1,1392,1398,1393,-1,1398,1408,1399,-1,1399,1408,1409,-1,1399,1409,1400,-1,1400,1409,1410,-1,1400,1410,1411,-1,1400,1411,1401,-1,1401,1411,1402,-1,1402,1411,1412,-1,1402,1412,1413,-1,1402,1413,1403,-1,1403,1413,1404,-1,1404,1413,1414,-1,1404,1414,1415,-1,1404,1415,1405,-1,1405,1415,1406,-1,1406,1415,1416,-1,1406,1416,1417,-1,1406,1417,1407,-1,1407,1417,1408,-1,1407,1408,1398,-1,1408,1410,1409,-1,1408,1411,1410,-1,1408,1412,1411,-1,1408,1413,1412,-1,1408,1414,1413,-1,1408,1415,1414,-1,1408,1416,1415,-1,1408,1417,1416,-1,1418,1419,1420,-1,1418,1420,1421,-1,1418,1422,1423,-1,1418,1423,1419,-1,1419,1423,1424,-1,1419,1424,1420,-1,1420,1424,1425,-1,1420,1425,1426,-1,1420,1426,1421,-1,1421,1422,1418,-1,1422,1427,1428,-1,1422,1428,1423,-1,1423,1428,1429,-1,1423,1429,1430,-1,1423,1430,1424,-1,1424,1430,1431,-1,1424,1431,1432,-1,1424,1432,1425,-1,1425,1432,1433,-1,1425,1433,1434,-1,1425,1434,1426,-1,1426,1434,1435,-1,1426,1435,1436,-1,1426,1436,1421,-1,1421,1436,1427,-1,1421,1427,1422,-1,1427,1437,1428,-1,1428,1437,1438,-1,1428,1438,1429,-1,1429,1438,1439,-1,1429,1439,1440,-1,1429,1440,1430,-1,1430,1440,1431,-1,1431,1440,1441,-1,1431,1441,1442,-1,1431,1442,1432,-1,1432,1442,1433,-1,1433,1442,1443,-1,1433,1443,1444,-1,1433,1444,1434,-1,1434,1444,1435,-1,1435,1444,1445,-1,1435,1445,1446,-1,1435,1446,1436,-1,1436,1446,1437,-1,1436,1437,1427,-1,1437,1439,1438,-1,1437,1440,1439,-1,1437,1441,1440,-1,1437,1442,1441,-1,1437,1443,1442,-1,1437,1444,1443,-1,1437,1445,1444,-1,1437,1446,1445,-1,1447,1448,1449,-1,1447,1449,1450,-1,1447,1451,1452,-1,1447,1452,1448,-1,1448,1452,1453,-1,1448,1453,1449,-1,1449,1453,1454,-1,1449,1454,1455,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_12()
		{
			int[] value = {1449,1455,1450,-1,1450,1451,1447,-1,1451,1456,1457,-1,1451,1457,1452,-1,1452,1457,1458,-1,1452,1458,1459,-1,1452,1459,1453,-1,1453,1459,1460,-1,1453,1460,1461,-1,1453,1461,1454,-1,1454,1461,1462,-1,1454,1462,1463,-1,1454,1463,1455,-1,1455,1463,1464,-1,1455,1464,1465,-1,1455,1465,1450,-1,1450,1465,1456,-1,1450,1456,1451,-1,1456,1466,1457,-1,1457,1466,1467,-1,1457,1467,1458,-1,1458,1467,1468,-1,1458,1468,1469,-1,1458,1469,1459,-1,1459,1469,1460,-1,1460,1469,1470,-1,1460,1470,1471,-1,1460,1471,1461,-1,1461,1471,1462,-1,1462,1471,1472,-1,1462,1472,1473,-1,1462,1473,1463,-1,1463,1473,1464,-1,1464,1473,1474,-1,1464,1474,1475,-1,1464,1475,1465,-1,1465,1475,1466,-1,1465,1466,1456,-1,1466,1468,1467,-1,1466,1469,1468,-1,1466,1470,1469,-1,1466,1471,1470,-1,1466,1472,1471,-1,1466,1473,1472,-1,1466,1474,1473,-1,1466,1475,1474,-1,1476,1477,1478,-1,1476,1478,1479,-1,1476,1480,1481,-1,1476,1481,1477,-1,1477,1481,1482,-1,1477,1482,1478,-1,1478,1482,1483,-1,1478,1483,1484,-1,1478,1484,1479,-1,1479,1480,1476,-1,1480,1485,1486,-1,1480,1486,1481,-1,1481,1486,1487,-1,1481,1487,1488,-1,1481,1488,1482,-1,1482,1488,1489,-1,1482,1489,1490,-1,1482,1490,1483,-1,1483,1490,1491,-1,1483,1491,1492,-1,1483,1492,1484,-1,1484,1492,1493,-1,1484,1493,1494,-1,1484,1494,1479,-1,1479,1494,1485,-1,1479,1485,1480,-1,1485,1495,1486,-1,1486,1495,1496,-1,1486,1496,1487,-1,1487,1496,1497,-1,1487,1497,1498,-1,1487,1498,1488,-1,1488,1498,1489,-1,1489,1498,1499,-1,1489,1499,1500,-1,1489,1500,1490,-1,1490,1500,1491,-1,1491,1500,1501,-1,1491,1501,1502,-1,1491,1502,1492,-1,1492,1502,1493,-1,1493,1502,1503,-1,1493,1503,1504,-1,1493,1504,1494,-1,1494,1504,1495,-1,1494,1495,1485,-1,1495,1497,1496,-1,1495,1498,1497,-1,1495,1499,1498,-1,1495,1500,1499,-1,1495,1501,1500,-1,1495,1502,1501,-1,1495,1503,1502,-1,1495,1504,1503,-1,1505,1506,1507,-1,1505,1507,1508,-1,1505,1509,1510,-1,1505,1510,1506,-1,1506,1510,1511,-1,1506,1511,1507,-1,1507,1511,1512,-1,1507,1512,1513,-1,1507,1513,1508,-1,1508,1509,1505,-1,1509,1514,1515,-1,1509,1515,1510,-1,1510,1515,1516,-1,1510,1516,1517,-1,1510,1517,1511,-1,1511,1517,1518,-1,1511,1518,1519,-1,1511,1519,1512,-1,1512,1519,1520,-1,1512,1520,1521,-1,1512,1521,1513,-1,1513,1521,1522,-1,1513,1522,1523,-1,1513,1523,1508,-1,1508,1523,1514,-1,1508,1514,1509,-1,1514,1524,1515,-1,1515,1524,1525,-1,1515,1525,1516,-1,1516,1525,1526,-1,1516,1526,1527,-1,1516,1527,1517,-1,1517,1527,1518,-1,1518,1527,1528,-1,1518,1528,1529,-1,1518,1529,1519,-1,1519,1529,1520,-1,1520,1529,1530,-1,1520,1530,1531,-1,1520,1531,1521,-1,1521,1531,1522,-1,1522,1531,1532,-1,1522,1532,1533,-1,1522,1533,1523,-1,1523,1533,1524,-1,1523,1524,1514,-1,1524,1526,1525,-1,1524,1527,1526,-1,1524,1528,1527,-1,1524,1529,1528,-1,1524,1530,1529,-1,1524,1531,1530,-1,1524,1532,1531,-1,1524,1533,1532,-1,1534,1535,1536,-1,1534,1536,1537,-1,1534,1538,1539,-1,1534,1539,1535,-1,1535,1539,1540,-1,1535,1540,1536,-1,1536,1540,1541,-1,1536,1541,1542,-1,1536,1542,1537,-1,1537,1538,1534,-1,1538,1543,1544,-1,1538,1544,1539,-1,1539,1544,1545,-1,1539,1545,1546,-1,1539,1546,1540,-1,1540,1546,1547,-1,1540,1547,1548,-1,1540,1548,1541,-1,1541,1548,1549,-1,1541,1549,1550,-1,1541,1550,1542,-1,1542,1550,1551,-1,1542,1551,1552,-1,1542,1552,1537,-1,1537,1552,1543,-1,1537,1543,1538,-1,1543,1553,1544,-1,1544,1553,1554,-1,1544,1554,1545,-1,1545,1554,1555,-1,1545,1555,1556,-1,1545,1556,1546,-1,1546,1556,1547,-1,1547,1556,1557,-1,1547,1557,1558,-1,1547,1558,1548,-1,1548,1558,1549,-1,1549,1558,1559,-1,1549,1559,1560,-1,1549,1560,1550,-1,1550,1560,1551,-1,1551,1560,1561,-1,1551,1561,1562,-1,1551,1562,1552,-1,1552,1562,1553,-1,1552,1553,1543,-1,1553,1555,1554,-1,1553,1556,1555,-1,1553,1557,1556,-1,1553,1558,1557,-1,1553,1559,1558,-1,1553,1560,1559,-1,1553,1561,1560,-1,1553,1562,1561,-1,1563,1564,1565,-1,1563,1565,1566,-1,1563,1567,1568,-1,1563,1568,1564,-1,1564,1568,1569,-1,1564,1569,1565,-1,1565,1569,1570,-1,1565,1570,1571,-1,1565,1571,1566,-1,1566,1567,1563,-1,1567,1572,1573,-1,1567,1573,1568,-1,1568,1573,1574,-1,1568,1574,1575,-1,1568,1575,1569,-1,1569,1575,1576,-1,1569,1576,1577,-1,1569,1577,1570,-1,1570,1577,1578,-1,1570,1578,1579,-1,1570,1579,1571,-1,1571,1579,1580,-1,1571,1580,1581,-1,1571,1581,1566,-1,1566,1581,1572,-1,1566,1572,1567,-1,1572,1582,1573,-1,1573,1582,1583,-1,1573,1583,1574,-1,1574,1583,1584,-1,1574,1584,1585,-1,1574,1585,1575,-1,1575,1585,1576,-1,1576,1585,1586,-1,1576,1586,1587,-1,1576,1587,1577,-1,1577,1587,1578,-1,1578,1587,1588,-1,1578,1588,1589,-1,1578,1589,1579,-1,1579,1589,1580,-1,1580,1589,1590,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_13()
		{
			int[] value = {1580,1590,1591,-1,1580,1591,1581,-1,1581,1591,1582,-1,1581,1582,1572,-1,1582,1584,1583,-1,1582,1585,1584,-1,1582,1586,1585,-1,1582,1587,1586,-1,1582,1588,1587,-1,1582,1589,1588,-1,1582,1590,1589,-1,1582,1591,1590,-1,1592,1593,1594,-1,1592,1594,1595,-1,1592,1596,1597,-1,1592,1597,1593,-1,1593,1597,1598,-1,1593,1598,1594,-1,1594,1598,1599,-1,1594,1599,1600,-1,1594,1600,1595,-1,1595,1596,1592,-1,1596,1601,1602,-1,1596,1602,1597,-1,1597,1602,1603,-1,1597,1603,1604,-1,1597,1604,1598,-1,1598,1604,1605,-1,1598,1605,1606,-1,1598,1606,1599,-1,1599,1606,1607,-1,1599,1607,1608,-1,1599,1608,1600,-1,1600,1608,1609,-1,1600,1609,1610,-1,1600,1610,1595,-1,1595,1610,1601,-1,1595,1601,1596,-1,1601,1611,1602,-1,1602,1611,1612,-1,1602,1612,1603,-1,1603,1612,1613,-1,1603,1613,1614,-1,1603,1614,1604,-1,1604,1614,1605,-1,1605,1614,1615,-1,1605,1615,1616,-1,1605,1616,1606,-1,1606,1616,1607,-1,1607,1616,1617,-1,1607,1617,1618,-1,1607,1618,1608,-1,1608,1618,1609,-1,1609,1618,1619,-1,1609,1619,1620,-1,1609,1620,1610,-1,1610,1620,1611,-1,1610,1611,1601,-1,1611,1613,1612,-1,1611,1614,1613,-1,1611,1615,1614,-1,1611,1616,1615,-1,1611,1617,1616,-1,1611,1618,1617,-1,1611,1619,1618,-1,1611,1620,1619,-1,1621,1622,1623,-1,1621,1623,1624,-1,1621,1625,1626,-1,1621,1626,1622,-1,1622,1626,1627,-1,1622,1627,1623,-1,1623,1627,1628,-1,1623,1628,1629,-1,1623,1629,1624,-1,1624,1625,1621,-1,1625,1630,1631,-1,1625,1631,1626,-1,1626,1631,1632,-1,1626,1632,1633,-1,1626,1633,1627,-1,1627,1633,1634,-1,1627,1634,1635,-1,1627,1635,1628,-1,1628,1635,1636,-1,1628,1636,1637,-1,1628,1637,1629,-1,1629,1637,1638,-1,1629,1638,1639,-1,1629,1639,1624,-1,1624,1639,1630,-1,1624,1630,1625,-1,1630,1640,1631,-1,1631,1640,1641,-1,1631,1641,1632,-1,1632,1641,1642,-1,1632,1642,1643,-1,1632,1643,1633,-1,1633,1643,1634,-1,1634,1643,1644,-1,1634,1644,1645,-1,1634,1645,1635,-1,1635,1645,1636,-1,1636,1645,1646,-1,1636,1646,1647,-1,1636,1647,1637,-1,1637,1647,1638,-1,1638,1647,1648,-1,1638,1648,1649,-1,1638,1649,1639,-1,1639,1649,1640,-1,1639,1640,1630,-1,1640,1642,1641,-1,1640,1643,1642,-1,1640,1644,1643,-1,1640,1645,1644,-1,1640,1646,1645,-1,1640,1647,1646,-1,1640,1648,1647,-1,1640,1649,1648,-1,1650,1651,1652,-1,1650,1652,1653,-1,1650,1654,1655,-1,1650,1655,1651,-1,1651,1655,1656,-1,1651,1656,1652,-1,1652,1656,1657,-1,1652,1657,1658,-1,1652,1658,1653,-1,1653,1654,1650,-1,1654,1659,1660,-1,1654,1660,1655,-1,1655,1660,1661,-1,1655,1661,1662,-1,1655,1662,1656,-1,1656,1662,1663,-1,1656,1663,1664,-1,1656,1664,1657,-1,1657,1664,1665,-1,1657,1665,1666,-1,1657,1666,1658,-1,1658,1666,1667,-1,1658,1667,1668,-1,1658,1668,1653,-1,1653,1668,1659,-1,1653,1659,1654,-1,1659,1669,1660,-1,1660,1669,1670,-1,1660,1670,1661,-1,1661,1670,1671,-1,1661,1671,1672,-1,1661,1672,1662,-1,1662,1672,1663,-1,1663,1672,1673,-1,1663,1673,1674,-1,1663,1674,1664,-1,1664,1674,1665,-1,1665,1674,1675,-1,1665,1675,1676,-1,1665,1676,1666,-1,1666,1676,1667,-1,1667,1676,1677,-1,1667,1677,1678,-1,1667,1678,1668,-1,1668,1678,1669,-1,1668,1669,1659,-1,1669,1671,1670,-1,1669,1672,1671,-1,1669,1673,1672,-1,1669,1674,1673,-1,1669,1675,1674,-1,1669,1676,1675,-1,1669,1677,1676,-1,1669,1678,1677,-1,1683,1682,1681,-1,1684,1683,1681,-1,1679,1684,1681,-1,1680,1679,1681,-1,1679,1680,1686,-1,1679,1686,1685,-1,1680,1681,1687,-1,1680,1687,1686,-1,1682,1683,1688,-1,1682,1688,1693,-1,1683,1684,1689,-1,1683,1689,1688,-1,1684,1690,1689,-1,1684,1679,1685,-1,1684,1685,1690,-1,1685,1686,1692,-1,1685,1692,1691,-1,1686,1687,1692,-1,1693,1688,1694,-1,1688,1689,1695,-1,1688,1695,1694,-1,1689,1690,1696,-1,1689,1696,1695,-1,1690,1685,1691,-1,1690,1691,1696,-1,1691,1692,1698,-1,1691,1698,1697,-1,1692,1687,1699,-1,1692,1699,1698,-1,1687,1681,1699,-1,1681,1682,1700,-1,1681,1700,1699,-1,1682,1693,1700,-1,1693,1694,1701,-1,1693,1701,1700,-1,1694,1695,1702,-1,1694,1702,1701,-1,1695,1696,1697,-1,1695,1697,1702,-1,1696,1691,1697,-1,1699,1700,1701,-1,1699,1701,1702,-1,1699,1702,1697,-1,1699,1697,1698,-1,1707,1706,1705,-1,1708,1707,1705,-1,1703,1708,1705,-1,1704,1703,1705,-1,1703,1704,1710,-1,1703,1710,1709,-1,1704,1705,1711,-1,1704,1711,1710,-1,1706,1707,1712,-1,1706,1712,1717,-1,1707,1708,1713,-1,1707,1713,1712,-1,1708,1714,1713,-1,1708,1703,1709,-1,1708,1709,1714,-1,1709,1710,1716,-1,1709,1716,1715,-1,1710,1711,1716,-1,1717,1712,1718,-1,1712,1713,1719,-1,1712,1719,1718,-1,1713,1714,1720,-1,1713,1720,1719,-1,1714,1709,1715,-1,1714,1715,1720,-1,1715,1716,1722,-1,1715,1722,1721,-1,1716,1711,1723,-1,1716,1723,1722,-1,1711,1705,1723,-1,1705,1706,1724,-1,1705,1724,1723,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_14()
		{
			int[] value = {1706,1717,1724,-1,1717,1718,1725,-1,1717,1725,1724,-1,1718,1719,1726,-1,1718,1726,1725,-1,1719,1720,1721,-1,1719,1721,1726,-1,1720,1715,1721,-1,1723,1724,1725,-1,1723,1725,1726,-1,1723,1726,1721,-1,1723,1721,1722,-1,1731,1730,1729,-1,1732,1731,1729,-1,1727,1732,1729,-1,1728,1727,1729,-1,1727,1728,1734,-1,1727,1734,1733,-1,1728,1729,1735,-1,1728,1735,1734,-1,1730,1731,1736,-1,1730,1736,1741,-1,1731,1732,1737,-1,1731,1737,1736,-1,1732,1738,1737,-1,1732,1727,1733,-1,1732,1733,1738,-1,1733,1734,1740,-1,1733,1740,1739,-1,1734,1735,1740,-1,1741,1736,1742,-1,1736,1737,1743,-1,1736,1743,1742,-1,1737,1738,1744,-1,1737,1744,1743,-1,1738,1733,1739,-1,1738,1739,1744,-1,1739,1740,1746,-1,1739,1746,1745,-1,1740,1735,1747,-1,1740,1747,1746,-1,1735,1729,1747,-1,1729,1730,1748,-1,1729,1748,1747,-1,1730,1741,1748,-1,1741,1742,1749,-1,1741,1749,1748,-1,1742,1743,1750,-1,1742,1750,1749,-1,1743,1744,1745,-1,1743,1745,1750,-1,1744,1739,1745,-1,1747,1748,1749,-1,1747,1749,1750,-1,1747,1750,1745,-1,1747,1745,1746,-1,1755,1754,1753,-1,1756,1755,1753,-1,1751,1756,1753,-1,1752,1751,1753,-1,1751,1752,1758,-1,1751,1758,1757,-1,1752,1753,1759,-1,1752,1759,1758,-1,1754,1755,1760,-1,1754,1760,1765,-1,1755,1756,1761,-1,1755,1761,1760,-1,1756,1762,1761,-1,1756,1751,1757,-1,1756,1757,1762,-1,1757,1758,1764,-1,1757,1764,1763,-1,1758,1759,1764,-1,1765,1760,1766,-1,1760,1761,1767,-1,1760,1767,1766,-1,1761,1762,1768,-1,1761,1768,1767,-1,1762,1757,1763,-1,1762,1763,1768,-1,1763,1764,1770,-1,1763,1770,1769,-1,1764,1759,1771,-1,1764,1771,1770,-1,1759,1753,1771,-1,1753,1754,1772,-1,1753,1772,1771,-1,1754,1765,1772,-1,1765,1766,1773,-1,1765,1773,1772,-1,1766,1767,1774,-1,1766,1774,1773,-1,1767,1768,1769,-1,1767,1769,1774,-1,1768,1763,1769,-1,1771,1772,1773,-1,1771,1773,1774,-1,1771,1774,1769,-1,1771,1769,1770,-1,1779,1778,1777,-1,1780,1779,1777,-1,1775,1780,1777,-1,1776,1775,1777,-1,1775,1776,1782,-1,1775,1782,1781,-1,1776,1777,1783,-1,1776,1783,1782,-1,1778,1779,1784,-1,1778,1784,1789,-1,1779,1780,1785,-1,1779,1785,1784,-1,1780,1786,1785,-1,1780,1775,1781,-1,1780,1781,1786,-1,1781,1782,1788,-1,1781,1788,1787,-1,1782,1783,1788,-1,1789,1784,1790,-1,1784,1785,1791,-1,1784,1791,1790,-1,1785,1786,1792,-1,1785,1792,1791,-1,1786,1781,1787,-1,1786,1787,1792,-1,1787,1788,1794,-1,1787,1794,1793,-1,1788,1783,1795,-1,1788,1795,1794,-1,1783,1777,1795,-1,1777,1778,1796,-1,1777,1796,1795,-1,1778,1789,1796,-1,1789,1790,1797,-1,1789,1797,1796,-1,1790,1791,1798,-1,1790,1798,1797,-1,1791,1792,1793,-1,1791,1793,1798,-1,1792,1787,1793,-1,1795,1796,1797,-1,1795,1797,1798,-1,1795,1798,1793,-1,1795,1793,1794,-1,1803,1802,1801,-1,1804,1803,1801,-1,1799,1804,1801,-1,1800,1799,1801,-1,1799,1800,1806,-1,1799,1806,1805,-1,1800,1801,1807,-1,1800,1807,1806,-1,1802,1803,1808,-1,1802,1808,1813,-1,1803,1804,1809,-1,1803,1809,1808,-1,1804,1810,1809,-1,1804,1799,1805,-1,1804,1805,1810,-1,1805,1806,1812,-1,1805,1812,1811,-1,1806,1807,1812,-1,1813,1808,1814,-1,1808,1809,1815,-1,1808,1815,1814,-1,1809,1810,1816,-1,1809,1816,1815,-1,1810,1805,1811,-1,1810,1811,1816,-1,1811,1812,1818,-1,1811,1818,1817,-1,1812,1807,1819,-1,1812,1819,1818,-1,1807,1801,1819,-1,1801,1802,1820,-1,1801,1820,1819,-1,1802,1813,1820,-1,1813,1814,1821,-1,1813,1821,1820,-1,1814,1815,1822,-1,1814,1822,1821,-1,1815,1816,1817,-1,1815,1817,1822,-1,1816,1811,1817,-1,1819,1820,1821,-1,1819,1821,1822,-1,1819,1822,1817,-1,1819,1817,1818,-1,1827,1826,1825,-1,1828,1827,1825,-1,1823,1828,1825,-1,1824,1823,1825,-1,1823,1824,1830,-1,1823,1830,1829,-1,1824,1825,1831,-1,1824,1831,1830,-1,1826,1827,1832,-1,1826,1832,1837,-1,1827,1828,1833,-1,1827,1833,1832,-1,1828,1834,1833,-1,1828,1823,1829,-1,1828,1829,1834,-1,1829,1830,1836,-1,1829,1836,1835,-1,1830,1831,1836,-1,1837,1832,1838,-1,1832,1833,1839,-1,1832,1839,1838,-1,1833,1834,1840,-1,1833,1840,1839,-1,1834,1829,1835,-1,1834,1835,1840,-1,1835,1836,1842,-1,1835,1842,1841,-1,1836,1831,1843,-1,1836,1843,1842,-1,1831,1825,1843,-1,1825,1826,1844,-1,1825,1844,1843,-1,1826,1837,1844,-1,1837,1838,1845,-1,1837,1845,1844,-1,1838,1839,1846,-1,1838,1846,1845,-1,1839,1840,1841,-1,1839,1841,1846,-1,1840,1835,1841,-1,1843,1844,1845,-1,1843,1845,1846,-1,1843,1846,1841,-1,1843,1841,1842,-1,1851,1850,1849,-1,1852,1851,1849,-1,1847,1852,1849,-1,1848,1847,1849,-1,1847,1848,1854,-1,1847,1854,1853,-1,1848,1849,1855,-1,1848,1855,1854,-1,1850,1851,1856,-1,1850,1856,1861,-1,1851,1852,1857,-1,1851,1857,1856,-1,1852,1858,1857,-1,1852,1847,1853,-1,1852,1853,1858,-1,1853,1854,1860,-1,1853,1860,1859,-1,1854,1855,1860,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_15()
		{
			int[] value = {1861,1856,1862,-1,1856,1857,1863,-1,1856,1863,1862,-1,1857,1858,1864,-1,1857,1864,1863,-1,1858,1853,1859,-1,1858,1859,1864,-1,1859,1860,1866,-1,1859,1866,1865,-1,1860,1855,1867,-1,1860,1867,1866,-1,1855,1849,1867,-1,1849,1850,1868,-1,1849,1868,1867,-1,1850,1861,1868,-1,1861,1862,1869,-1,1861,1869,1868,-1,1862,1863,1870,-1,1862,1870,1869,-1,1863,1864,1865,-1,1863,1865,1870,-1,1864,1859,1865,-1,1867,1868,1869,-1,1867,1869,1870,-1,1867,1870,1865,-1,1867,1865,1866,-1,1875,1874,1873,-1,1876,1875,1873,-1,1871,1876,1873,-1,1872,1871,1873,-1,1871,1872,1878,-1,1871,1878,1877,-1,1872,1873,1879,-1,1872,1879,1878,-1,1874,1875,1880,-1,1874,1880,1885,-1,1875,1876,1881,-1,1875,1881,1880,-1,1876,1882,1881,-1,1876,1871,1877,-1,1876,1877,1882,-1,1877,1878,1884,-1,1877,1884,1883,-1,1878,1879,1884,-1,1885,1880,1886,-1,1880,1881,1887,-1,1880,1887,1886,-1,1881,1882,1888,-1,1881,1888,1887,-1,1882,1877,1883,-1,1882,1883,1888,-1,1883,1884,1890,-1,1883,1890,1889,-1,1884,1879,1891,-1,1884,1891,1890,-1,1879,1873,1891,-1,1873,1874,1892,-1,1873,1892,1891,-1,1874,1885,1892,-1,1885,1886,1893,-1,1885,1893,1892,-1,1886,1887,1894,-1,1886,1894,1893,-1,1887,1888,1889,-1,1887,1889,1894,-1,1888,1883,1889,-1,1891,1892,1893,-1,1891,1893,1894,-1,1891,1894,1889,-1,1891,1889,1890,-1,1899,1898,1897,-1,1900,1899,1897,-1,1895,1900,1897,-1,1896,1895,1897,-1,1895,1896,1902,-1,1895,1902,1901,-1,1896,1897,1903,-1,1896,1903,1902,-1,1898,1899,1904,-1,1898,1904,1909,-1,1899,1900,1905,-1,1899,1905,1904,-1,1900,1906,1905,-1,1900,1895,1901,-1,1900,1901,1906,-1,1901,1902,1908,-1,1901,1908,1907,-1,1902,1903,1908,-1,1909,1904,1910,-1,1904,1905,1911,-1,1904,1911,1910,-1,1905,1906,1912,-1,1905,1912,1911,-1,1906,1901,1907,-1,1906,1907,1912,-1,1907,1908,1914,-1,1907,1914,1913,-1,1908,1903,1915,-1,1908,1915,1914,-1,1903,1897,1915,-1,1897,1898,1916,-1,1897,1916,1915,-1,1898,1909,1916,-1,1909,1910,1917,-1,1909,1917,1916,-1,1910,1911,1918,-1,1910,1918,1917,-1,1911,1912,1913,-1,1911,1913,1918,-1,1912,1907,1913,-1,1915,1916,1917,-1,1915,1917,1918,-1,1915,1918,1913,-1,1915,1913,1914,-1,1923,1922,1921,-1,1924,1923,1921,-1,1919,1924,1921,-1,1920,1919,1921,-1,1919,1920,1926,-1,1919,1926,1925,-1,1920,1921,1927,-1,1920,1927,1926,-1,1922,1923,1928,-1,1922,1928,1933,-1,1923,1924,1929,-1,1923,1929,1928,-1,1924,1930,1929,-1,1924,1919,1925,-1,1924,1925,1930,-1,1925,1926,1932,-1,1925,1932,1931,-1,1926,1927,1932,-1,1933,1928,1934,-1,1928,1929,1935,-1,1928,1935,1934,-1,1929,1930,1936,-1,1929,1936,1935,-1,1930,1925,1931,-1,1930,1931,1936,-1,1931,1932,1938,-1,1931,1938,1937,-1,1932,1927,1939,-1,1932,1939,1938,-1,1927,1921,1939,-1,1921,1922,1940,-1,1921,1940,1939,-1,1922,1933,1940,-1,1933,1934,1941,-1,1933,1941,1940,-1,1934,1935,1942,-1,1934,1942,1941,-1,1935,1936,1937,-1,1935,1937,1942,-1,1936,1931,1937,-1,1939,1940,1941,-1,1939,1941,1942,-1,1939,1942,1937,-1,1939,1937,1938,-1,1947,1946,1945,-1,1948,1947,1945,-1,1943,1948,1945,-1,1944,1943,1945,-1,1943,1944,1950,-1,1943,1950,1949,-1,1944,1945,1951,-1,1944,1951,1950,-1,1946,1947,1952,-1,1946,1952,1957,-1,1947,1948,1953,-1,1947,1953,1952,-1,1948,1954,1953,-1,1948,1943,1949,-1,1948,1949,1954,-1,1949,1950,1956,-1,1949,1956,1955,-1,1950,1951,1956,-1,1957,1952,1958,-1,1952,1953,1959,-1,1952,1959,1958,-1,1953,1954,1960,-1,1953,1960,1959,-1,1954,1949,1955,-1,1954,1955,1960,-1,1955,1956,1962,-1,1955,1962,1961,-1,1956,1951,1963,-1,1956,1963,1962,-1,1951,1945,1963,-1,1945,1946,1964,-1,1945,1964,1963,-1,1946,1957,1964,-1,1957,1958,1965,-1,1957,1965,1964,-1,1958,1959,1966,-1,1958,1966,1965,-1,1959,1960,1961,-1,1959,1961,1966,-1,1960,1955,1961,-1,1963,1964,1965,-1,1963,1965,1966,-1,1963,1966,1961,-1,1963,1961,1962,-1,1971,1970,1969,-1,1972,1971,1969,-1,1967,1972,1969,-1,1968,1967,1969,-1,1967,1968,1974,-1,1967,1974,1973,-1,1968,1969,1975,-1,1968,1975,1974,-1,1970,1971,1976,-1,1970,1976,1981,-1,1971,1972,1977,-1,1971,1977,1976,-1,1972,1978,1977,-1,1972,1967,1973,-1,1972,1973,1978,-1,1973,1974,1980,-1,1973,1980,1979,-1,1974,1975,1980,-1,1981,1976,1982,-1,1976,1977,1983,-1,1976,1983,1982,-1,1977,1978,1984,-1,1977,1984,1983,-1,1978,1973,1979,-1,1978,1979,1984,-1,1979,1980,1986,-1,1979,1986,1985,-1,1980,1975,1987,-1,1980,1987,1986,-1,1975,1969,1987,-1,1969,1970,1988,-1,1969,1988,1987,-1,1970,1981,1988,-1,1981,1982,1989,-1,1981,1989,1988,-1,1982,1983,1990,-1,1982,1990,1989,-1,1983,1984,1985,-1,1983,1985,1990,-1,1984,1979,1985,-1,1987,1988,1989,-1,1987,1989,1990,-1,1987,1990,1985,-1,1987,1985,1986,-1,1995,1994,1993,-1,1996,1995,1993,-1,1991,1996,1993,-1,1992,1991,1993,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_16()
		{
			int[] value = {1991,1992,1998,-1,1991,1998,1997,-1,1992,1993,1999,-1,1992,1999,1998,-1,1994,1995,2000,-1,1994,2000,2005,-1,1995,1996,2001,-1,1995,2001,2000,-1,1996,2002,2001,-1,1996,1991,1997,-1,1996,1997,2002,-1,1997,1998,2004,-1,1997,2004,2003,-1,1998,1999,2004,-1,2005,2000,2006,-1,2000,2001,2007,-1,2000,2007,2006,-1,2001,2002,2008,-1,2001,2008,2007,-1,2002,1997,2003,-1,2002,2003,2008,-1,2003,2004,2010,-1,2003,2010,2009,-1,2004,1999,2011,-1,2004,2011,2010,-1,1999,1993,2011,-1,1993,1994,2012,-1,1993,2012,2011,-1,1994,2005,2012,-1,2005,2006,2013,-1,2005,2013,2012,-1,2006,2007,2014,-1,2006,2014,2013,-1,2007,2008,2009,-1,2007,2009,2014,-1,2008,2003,2009,-1,2011,2012,2013,-1,2011,2013,2014,-1,2011,2014,2009,-1,2011,2009,2010,-1,2019,2018,2017,-1,2020,2019,2017,-1,2015,2020,2017,-1,2016,2015,2017,-1,2015,2016,2022,-1,2015,2022,2021,-1,2016,2017,2023,-1,2016,2023,2022,-1,2018,2019,2024,-1,2018,2024,2029,-1,2019,2020,2025,-1,2019,2025,2024,-1,2020,2026,2025,-1,2020,2015,2021,-1,2020,2021,2026,-1,2021,2022,2028,-1,2021,2028,2027,-1,2022,2023,2028,-1,2029,2024,2030,-1,2024,2025,2031,-1,2024,2031,2030,-1,2025,2026,2032,-1,2025,2032,2031,-1,2026,2021,2027,-1,2026,2027,2032,-1,2027,2028,2034,-1,2027,2034,2033,-1,2028,2023,2035,-1,2028,2035,2034,-1,2023,2017,2035,-1,2017,2018,2036,-1,2017,2036,2035,-1,2018,2029,2036,-1,2029,2030,2037,-1,2029,2037,2036,-1,2030,2031,2038,-1,2030,2038,2037,-1,2031,2032,2033,-1,2031,2033,2038,-1,2032,2027,2033,-1,2035,2036,2037,-1,2035,2037,2038,-1,2035,2038,2033,-1,2035,2033,2034,-1,2043,2042,2041,-1,2044,2043,2041,-1,2039,2044,2041,-1,2040,2039,2041,-1,2039,2040,2046,-1,2039,2046,2045,-1,2040,2041,2047,-1,2040,2047,2046,-1,2042,2043,2048,-1,2042,2048,2053,-1,2043,2044,2049,-1,2043,2049,2048,-1,2044,2050,2049,-1,2044,2039,2045,-1,2044,2045,2050,-1,2045,2046,2052,-1,2045,2052,2051,-1,2046,2047,2052,-1,2053,2048,2054,-1,2048,2049,2055,-1,2048,2055,2054,-1,2049,2050,2056,-1,2049,2056,2055,-1,2050,2045,2051,-1,2050,2051,2056,-1,2051,2052,2058,-1,2051,2058,2057,-1,2052,2047,2059,-1,2052,2059,2058,-1,2047,2041,2059,-1,2041,2042,2060,-1,2041,2060,2059,-1,2042,2053,2060,-1,2053,2054,2061,-1,2053,2061,2060,-1,2054,2055,2062,-1,2054,2062,2061,-1,2055,2056,2057,-1,2055,2057,2062,-1,2056,2051,2057,-1,2059,2060,2061,-1,2059,2061,2062,-1,2059,2062,2057,-1,2059,2057,2058,-1,2067,2066,2065,-1,2068,2067,2065,-1,2063,2068,2065,-1,2064,2063,2065,-1,2063,2064,2070,-1,2063,2070,2069,-1,2064,2065,2071,-1,2064,2071,2070,-1,2066,2067,2072,-1,2066,2072,2077,-1,2067,2068,2073,-1,2067,2073,2072,-1,2068,2074,2073,-1,2068,2063,2069,-1,2068,2069,2074,-1,2069,2070,2076,-1,2069,2076,2075,-1,2070,2071,2076,-1,2077,2072,2078,-1,2072,2073,2079,-1,2072,2079,2078,-1,2073,2074,2080,-1,2073,2080,2079,-1,2074,2069,2075,-1,2074,2075,2080,-1,2075,2076,2082,-1,2075,2082,2081,-1,2076,2071,2083,-1,2076,2083,2082,-1,2071,2065,2083,-1,2065,2066,2084,-1,2065,2084,2083,-1,2066,2077,2084,-1,2077,2078,2085,-1,2077,2085,2084,-1,2078,2079,2086,-1,2078,2086,2085,-1,2079,2080,2081,-1,2079,2081,2086,-1,2080,2075,2081,-1,2083,2084,2085,-1,2083,2085,2086,-1,2083,2086,2081,-1,2083,2081,2082,-1,2091,2090,2089,-1,2092,2091,2089,-1,2087,2092,2089,-1,2088,2087,2089,-1,2087,2088,2094,-1,2087,2094,2093,-1,2088,2089,2095,-1,2088,2095,2094,-1,2090,2091,2096,-1,2090,2096,2101,-1,2091,2092,2097,-1,2091,2097,2096,-1,2092,2098,2097,-1,2092,2087,2093,-1,2092,2093,2098,-1,2093,2094,2100,-1,2093,2100,2099,-1,2094,2095,2100,-1,2101,2096,2102,-1,2096,2097,2103,-1,2096,2103,2102,-1,2097,2098,2104,-1,2097,2104,2103,-1,2098,2093,2099,-1,2098,2099,2104,-1,2099,2100,2106,-1,2099,2106,2105,-1,2100,2095,2107,-1,2100,2107,2106,-1,2095,2089,2107,-1,2089,2090,2108,-1,2089,2108,2107,-1,2090,2101,2108,-1,2101,2102,2109,-1,2101,2109,2108,-1,2102,2103,2110,-1,2102,2110,2109,-1,2103,2104,2105,-1,2103,2105,2110,-1,2104,2099,2105,-1,2107,2108,2109,-1,2107,2109,2110,-1,2107,2110,2105,-1,2107,2105,2106,-1,2115,2114,2113,-1,2116,2115,2113,-1,2111,2116,2113,-1,2112,2111,2113,-1,2111,2112,2118,-1,2111,2118,2117,-1,2112,2113,2119,-1,2112,2119,2118,-1,2114,2115,2120,-1,2114,2120,2125,-1,2115,2116,2121,-1,2115,2121,2120,-1,2116,2122,2121,-1,2116,2111,2117,-1,2116,2117,2122,-1,2117,2118,2124,-1,2117,2124,2123,-1,2118,2119,2124,-1,2125,2120,2126,-1,2120,2121,2127,-1,2120,2127,2126,-1,2121,2122,2128,-1,2121,2128,2127,-1,2122,2117,2123,-1,2122,2123,2128,-1,2123,2124,2130,-1,2123,2130,2129,-1,2124,2119,2131,-1,2124,2131,2130,-1,2119,2113,2131,-1,2113,2114,2132,-1,2113,2132,2131,-1,2114,2125,2132,-1,2125,2126,2133,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_17()
		{
			int[] value = {2125,2133,2132,-1,2126,2127,2134,-1,2126,2134,2133,-1,2127,2128,2129,-1,2127,2129,2134,-1,2128,2123,2129,-1,2131,2132,2133,-1,2131,2133,2134,-1,2131,2134,2129,-1,2131,2129,2130,-1,2139,2138,2137,-1,2140,2139,2137,-1,2135,2140,2137,-1,2136,2135,2137,-1,2135,2136,2142,-1,2135,2142,2141,-1,2136,2137,2143,-1,2136,2143,2142,-1,2138,2139,2144,-1,2138,2144,2149,-1,2139,2140,2145,-1,2139,2145,2144,-1,2140,2146,2145,-1,2140,2135,2141,-1,2140,2141,2146,-1,2141,2142,2148,-1,2141,2148,2147,-1,2142,2143,2148,-1,2149,2144,2150,-1,2144,2145,2151,-1,2144,2151,2150,-1,2145,2146,2152,-1,2145,2152,2151,-1,2146,2141,2147,-1,2146,2147,2152,-1,2147,2148,2154,-1,2147,2154,2153,-1,2148,2143,2155,-1,2148,2155,2154,-1,2143,2137,2155,-1,2137,2138,2156,-1,2137,2156,2155,-1,2138,2149,2156,-1,2149,2150,2157,-1,2149,2157,2156,-1,2150,2151,2158,-1,2150,2158,2157,-1,2151,2152,2153,-1,2151,2153,2158,-1,2152,2147,2153,-1,2155,2156,2157,-1,2155,2157,2158,-1,2155,2158,2153,-1,2155,2153,2154,-1,2159,2160,2161,-1,2159,2161,2162,-1,2159,2163,2164,-1,2159,2164,2160,-1,2160,2164,2165,-1,2160,2165,2161,-1,2161,2165,2166,-1,2161,2166,2167,-1,2161,2167,2162,-1,2162,2163,2159,-1,2163,2168,2169,-1,2163,2169,2164,-1,2164,2169,2170,-1,2164,2170,2171,-1,2164,2171,2165,-1,2165,2171,2172,-1,2165,2172,2173,-1,2165,2173,2166,-1,2166,2173,2174,-1,2166,2174,2175,-1,2166,2175,2167,-1,2167,2175,2176,-1,2167,2176,2177,-1,2167,2177,2162,-1,2162,2177,2168,-1,2162,2168,2163,-1,2168,2178,2169,-1,2169,2178,2179,-1,2169,2179,2170,-1,2170,2179,2180,-1,2170,2180,2181,-1,2170,2181,2171,-1,2171,2181,2172,-1,2172,2181,2182,-1,2172,2182,2183,-1,2172,2183,2173,-1,2173,2183,2174,-1,2174,2183,2184,-1,2174,2184,2185,-1,2174,2185,2175,-1,2175,2185,2176,-1,2176,2185,2186,-1,2176,2186,2187,-1,2176,2187,2177,-1,2177,2187,2178,-1,2177,2178,2168,-1,2178,2180,2179,-1,2178,2181,2180,-1,2178,2182,2181,-1,2178,2183,2182,-1,2178,2184,2183,-1,2178,2185,2184,-1,2178,2186,2185,-1,2178,2187,2186,-1,2188,2189,2190,-1,2188,2190,2191,-1,2188,2192,2193,-1,2188,2193,2189,-1,2189,2193,2194,-1,2189,2194,2190,-1,2190,2194,2195,-1,2190,2195,2196,-1,2190,2196,2191,-1,2191,2192,2188,-1,2192,2197,2198,-1,2192,2198,2193,-1,2193,2198,2199,-1,2193,2199,2200,-1,2193,2200,2194,-1,2194,2200,2201,-1,2194,2201,2202,-1,2194,2202,2195,-1,2195,2202,2203,-1,2195,2203,2204,-1,2195,2204,2196,-1,2196,2204,2205,-1,2196,2205,2206,-1,2196,2206,2191,-1,2191,2206,2197,-1,2191,2197,2192,-1,2197,2207,2198,-1,2198,2207,2208,-1,2198,2208,2199,-1,2199,2208,2209,-1,2199,2209,2210,-1,2199,2210,2200,-1,2200,2210,2201,-1,2201,2210,2211,-1,2201,2211,2212,-1,2201,2212,2202,-1,2202,2212,2203,-1,2203,2212,2213,-1,2203,2213,2214,-1,2203,2214,2204,-1,2204,2214,2205,-1,2205,2214,2215,-1,2205,2215,2216,-1,2205,2216,2206,-1,2206,2216,2207,-1,2206,2207,2197,-1,2207,2209,2208,-1,2207,2210,2209,-1,2207,2211,2210,-1,2207,2212,2211,-1,2207,2213,2212,-1,2207,2214,2213,-1,2207,2215,2214,-1,2207,2216,2215,-1,2217,2218,2219,-1,2217,2219,2220,-1,2217,2221,2222,-1,2217,2222,2218,-1,2218,2222,2223,-1,2218,2223,2219,-1,2219,2223,2224,-1,2219,2224,2225,-1,2219,2225,2220,-1,2220,2221,2217,-1,2221,2226,2227,-1,2221,2227,2222,-1,2222,2227,2228,-1,2222,2228,2229,-1,2222,2229,2223,-1,2223,2229,2230,-1,2223,2230,2231,-1,2223,2231,2224,-1,2224,2231,2232,-1,2224,2232,2233,-1,2224,2233,2225,-1,2225,2233,2234,-1,2225,2234,2235,-1,2225,2235,2220,-1,2220,2235,2226,-1,2220,2226,2221,-1,2226,2236,2227,-1,2227,2236,2237,-1,2227,2237,2228,-1,2228,2237,2238,-1,2228,2238,2239,-1,2228,2239,2229,-1,2229,2239,2230,-1,2230,2239,2240,-1,2230,2240,2241,-1,2230,2241,2231,-1,2231,2241,2232,-1,2232,2241,2242,-1,2232,2242,2243,-1,2232,2243,2233,-1,2233,2243,2234,-1,2234,2243,2244,-1,2234,2244,2245,-1,2234,2245,2235,-1,2235,2245,2236,-1,2235,2236,2226,-1,2236,2238,2237,-1,2236,2239,2238,-1,2236,2240,2239,-1,2236,2241,2240,-1,2236,2242,2241,-1,2236,2243,2242,-1,2236,2244,2243,-1,2236,2245,2244,-1,2246,2247,2248,-1,2246,2248,2249,-1,2246,2250,2251,-1,2246,2251,2247,-1,2247,2251,2252,-1,2247,2252,2248,-1,2248,2252,2253,-1,2248,2253,2254,-1,2248,2254,2249,-1,2249,2250,2246,-1,2250,2255,2256,-1,2250,2256,2251,-1,2251,2256,2257,-1,2251,2257,2258,-1,2251,2258,2252,-1,2252,2258,2259,-1,2252,2259,2260,-1,2252,2260,2253,-1,2253,2260,2261,-1,2253,2261,2262,-1,2253,2262,2254,-1,2254,2262,2263,-1,2254,2263,2264,-1,2254,2264,2249,-1,2249,2264,2255,-1,2249,2255,2250,-1,2255,2265,2256,-1,2256,2265,2266,-1,2256,2266,2257,-1,2257,2266,2267,-1,2257,2267,2268,-1,2257,2268,2258,-1,2258,2268,2259,-1,2259,2268,2269,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_22_coordIndex_18()
		{
			int[] value = {2259,2269,2270,-1,2259,2270,2260,-1,2260,2270,2261,-1,2261,2270,2271,-1,2261,2271,2272,-1,2261,2272,2262,-1,2262,2272,2263,-1,2263,2272,2273,-1,2263,2273,2274,-1,2263,2274,2264,-1,2264,2274,2265,-1,2264,2265,2255,-1,2265,2267,2266,-1,2265,2268,2267,-1,2265,2269,2268,-1,2265,2270,2269,-1,2265,2271,2270,-1,2265,2272,2271,-1,2265,2273,2272,-1,2265,2274,2273,-1,2275,2276,2277,-1,2275,2277,2278,-1,2275,2279,2280,-1,2275,2280,2276,-1,2276,2280,2281,-1,2276,2281,2277,-1,2277,2281,2282,-1,2277,2282,2283,-1,2277,2283,2278,-1,2278,2279,2275,-1,2279,2284,2285,-1,2279,2285,2280,-1,2280,2285,2286,-1,2280,2286,2287,-1,2280,2287,2281,-1,2281,2287,2288,-1,2281,2288,2289,-1,2281,2289,2282,-1,2282,2289,2290,-1,2282,2290,2291,-1,2282,2291,2283,-1,2283,2291,2292,-1,2283,2292,2293,-1,2283,2293,2278,-1,2278,2293,2284,-1,2278,2284,2279,-1,2284,2294,2285,-1,2285,2294,2295,-1,2285,2295,2286,-1,2286,2295,2296,-1,2286,2296,2297,-1,2286,2297,2287,-1,2287,2297,2288,-1,2288,2297,2298,-1,2288,2298,2299,-1,2288,2299,2289,-1,2289,2299,2290,-1,2290,2299,2300,-1,2290,2300,2301,-1,2290,2301,2291,-1,2291,2301,2292,-1,2292,2301,2302,-1,2292,2302,2303,-1,2292,2303,2293,-1,2293,2303,2294,-1,2293,2294,2284,-1,2294,2296,2295,-1,2294,2297,2296,-1,2294,2298,2297,-1,2294,2299,2298,-1,2294,2300,2299,-1,2294,2301,2300,-1,2294,2302,2301,-1,2294,2303,2302,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_6_22_point_1()
		{
			double[] value = {448.6,326.6,-55.04,448.6,289.1,-65.81,448.6,154.9,-81.06,448.6,-25.41,-78.19,448.6,-91.59,-69.94,448.6,-156.5,-57.62,448.6,-218.4,-41.43,448.6,-277.8,-20.94,448.6,-330.2,2.374,448.6,-373.9,27.42,448.6,-419.5,64.08,448.6,-458.9,108.8,448.6,-491.9,159.1,448.6,-520.0,216.6,448.6,-541.1,274.8,448.6,-555.9,330.6,448.6,-569.4,407.2,448.6,-574.5,460.5,448.6,-575.5,480.4,448.6,-585.4,480.1,448.6,-584.4,459.9,448.6,-579.5,405.9,448.6,-566.3,328.4,448.6,-551.4,271.8,448.6,-530.3,212.7,448.6,-501.9,154.2,448.6,-468.3,102.5,448.6,-427.7,56.44,448.6,-380.5,18.45,448.6,-335.6,-7.333,448.6,-282.1,-31.06,448.6,-221.7,-51.79,448.6,-159.1,-68.1,448.6,-93.41,-80.47,448.6,-26.48,-88.71,448.6,155.4,-91.29,448.6,290.9,-75.64,448.6,328.8,-64.67,498.2,326.6,-55.04,498.2,289.1,-65.81,498.2,154.9,-81.06,498.2,-25.41,-78.19,498.2,-91.59,-69.94,498.2,-156.5,-57.62,498.2,-218.4,-41.43,498.2,-277.8,-20.94,498.2,-330.2,2.374,498.2,-373.9,27.42,498.2,-419.5,64.08,498.2,-458.9,108.8,498.2,-491.9,159.1,498.2,-520.0,216.6,498.2,-541.1,274.8,498.2,-555.9,330.6,498.2,-569.4,407.2,498.2,-574.5,460.5,498.2,-575.5,480.4,498.2,-585.4,480.1,498.2,-584.4,459.9,498.2,-579.5,405.9,498.2,-566.3,328.4,498.2,-551.4,271.8,498.2,-530.3,212.7,498.2,-501.9,154.2,498.2,-468.3,102.5,498.2,-427.7,56.44,498.2,-380.5,18.45,498.2,-335.6,-7.333,498.2,-282.1,-31.06,498.2,-221.7,-51.79,498.2,-159.1,-68.1,498.2,-93.41,-80.47,498.2,-26.48,-88.71,498.2,155.5,-91.29,498.2,290.9,-75.64,498.2,328.8,-64.67,448.7,-243.9,505.6,448.7,-242.3,469.7,448.7,-245.5,388.9,448.7,-264.4,305.1,448.7,-297.4,240.0,448.7,-331.0,190.5,448.7,-354.8,160.3,448.7,-391.6,122.4,448.7,-448.8,67.5,448.7,-491.2,21.06,448.7,-514.7,-11.88,448.7,-536.4,-41.57,448.7,-551.0,-69.8,448.7,-565.7,-110.9,448.7,-584.1,-165.0,448.7,-593.3,-211.8,448.7,-586.0,-212.8,448.7,-577.0,-167.2,448.7,-558.8,-113.9,448.7,-544.2,-73.34,448.7,-530.2,-46.47,448.7,-508.9,-17.29,448.7,-485.7,15.32,448.7,-444.0,60.59};
			return value;
		}
		private double[] getCoordinate_6_22_point_2()
		{
			double[] value = {448.7,-387.0,115.1,448.7,-349.8,153.5,448.7,-325.7,184.0,448.7,-291.7,234.0,448.7,-257.9,300.6,448.7,-238.2,387.3,448.7,-234.9,470.1,448.7,-236.6,506.6,492.6,-243.9,505.6,492.6,-242.3,469.7,492.6,-245.5,388.9,492.6,-264.4,305.1,492.6,-297.4,240.0,492.6,-331.0,190.5,492.6,-354.8,160.3,492.6,-391.6,122.4,492.6,-448.8,67.5,492.6,-491.2,21.06,492.6,-514.7,-11.88,492.6,-536.4,-41.57,492.6,-551.0,-69.8,492.6,-565.7,-110.9,492.6,-584.1,-165.0,492.6,-593.3,-211.8,492.6,-586.0,-212.8,492.6,-577.0,-167.2,492.6,-558.8,-113.9,492.6,-544.2,-73.34,492.6,-530.2,-46.47,492.6,-508.9,-17.29,492.6,-485.7,15.32,492.6,-444.0,60.59,492.6,-387.0,115.1,492.6,-349.8,153.5,492.6,-325.7,184.0,492.6,-291.7,234.0,492.6,-257.9,300.6,492.6,-238.2,387.3,492.6,-234.9,470.1,492.6,-236.6,506.6,1325.0,-181.2,492.7,1325.0,-190.0,338.4,1325.0,-202.6,115.2,1325.0,-211.5,-40.92,1325.0,-213.5,-48.24,1325.0,-217.5,-52.62,1325.0,-221.7,-53.95,1325.0,-232.9,-53.32,1325.0,-245.9,-52.58,1325.0,-257.1,-51.95,1325.0,-261.2,-50.25,1325.0,-264.6,-45.78,1325.0,-265.8,-38.81,1325.0,-256.9,118.3,1325.0,-244.1,344.4,1325.0,-235.4,497.8,1325.0,-233.4,503.5,1325.0,-228.9,506.8,1325.0,-222.5,507.7,1325.0,-212.8,507.2,1325.0,-202.4,506.6,1325.0,-192.8,506.0,1325.0,-186.5,504.2,1325.0,-182.4,499.7,446.3,-181.2,492.7,446.3,-190.0,338.4,446.3,-202.6,115.2,446.3,-211.5,-40.92,446.3,-213.5,-48.24,446.3,-217.5,-52.62,446.3,-221.7,-53.95,446.3,-232.9,-53.32,446.3,-245.9,-52.58,446.3,-257.1,-51.95,446.3,-261.2,-50.25,446.3,-264.6,-45.78,446.3,-265.8,-38.81,446.3,-256.9,118.3,446.3,-244.1,344.4,446.3,-235.4,497.8,446.3,-233.4,503.5,446.3,-228.9,506.8,446.3,-222.5,507.7,446.3,-212.8,507.2,446.3,-202.4,506.6,446.3,-192.8,506.0,446.3,-186.5,504.2,446.3,-182.4,499.7,1275.0,326.6,-55.04,1275.0,289.1,-65.81,1275.0,154.9,-81.06,1275.0,-25.41,-78.19,1275.0,-91.59,-69.94,1275.0,-156.5,-57.62,1275.0,-218.4,-41.43,1275.0,-277.8,-20.94,1275.0,-330.2,2.375,1275.0,-373.9,27.42,1275.0,-419.5,64.08,1275.0,-458.9,108.8};
			return value;
		}
		private double[] getCoordinate_6_22_point_3()
		{
			double[] value = {1275.0,-491.9,159.1,1275.0,-520.0,216.6,1275.0,-541.1,274.8,1275.0,-555.9,330.6,1275.0,-569.4,407.2,1275.0,-574.5,460.5,1275.0,-575.5,480.4,1275.0,-585.4,480.1,1275.0,-584.4,459.9,1275.0,-579.5,405.9,1275.0,-566.3,328.4,1275.0,-551.4,271.8,1275.0,-530.3,212.7,1275.0,-501.9,154.2,1275.0,-468.3,102.5,1275.0,-427.7,56.44,1275.0,-380.5,18.45,1275.0,-335.6,-7.333,1275.0,-282.1,-31.06,1275.0,-221.7,-51.79,1275.0,-159.1,-68.1,1275.0,-93.41,-80.47,1275.0,-26.48,-88.71,1275.0,155.5,-91.29,1275.0,290.9,-75.64,1275.0,328.8,-64.67,1325.0,326.6,-55.04,1325.0,289.1,-65.81,1325.0,154.9,-81.06,1325.0,-25.41,-78.19,1325.0,-91.59,-69.94,1325.0,-156.5,-57.62,1325.0,-218.4,-41.43,1325.0,-277.8,-20.94,1325.0,-330.2,2.374,1325.0,-373.9,27.42,1325.0,-419.5,64.08,1325.0,-458.9,108.8,1325.0,-491.9,159.1,1325.0,-520.0,216.6,1325.0,-541.1,274.8,1325.0,-555.9,330.6,1325.0,-569.4,407.2,1325.0,-574.5,460.5,1325.0,-575.5,480.4,1325.0,-585.4,480.1,1325.0,-584.4,459.9,1325.0,-579.5,405.9,1325.0,-566.3,328.4,1325.0,-551.4,271.8,1325.0,-530.3,212.7,1325.0,-501.9,154.2,1325.0,-468.3,102.5,1325.0,-427.7,56.44,1325.0,-380.5,18.45,1325.0,-335.6,-7.333,1325.0,-282.1,-31.06,1325.0,-221.7,-51.79,1325.0,-159.1,-68.1,1325.0,-93.41,-80.47,1325.0,-26.48,-88.71,1325.0,155.5,-91.29,1325.0,290.9,-75.64,1325.0,328.8,-64.67,1278.0,-243.9,505.6,1278.0,-242.3,469.7,1278.0,-245.5,388.9,1278.0,-264.4,305.1,1278.0,-297.4,240.0,1278.0,-331.0,190.5,1278.0,-354.8,160.3,1278.0,-391.6,122.4,1278.0,-448.8,67.5,1278.0,-491.2,21.06,1278.0,-514.7,-11.88,1278.0,-536.4,-41.57,1278.0,-551.0,-69.8,1278.0,-565.7,-110.9,1278.0,-584.1,-165.0,1278.0,-593.3,-211.8,1278.0,-586.0,-212.8,1278.0,-577.0,-167.2,1278.0,-558.8,-113.9,1278.0,-544.2,-73.34,1278.0,-530.2,-46.47,1278.0,-508.9,-17.29,1278.0,-485.7,15.32,1278.0,-444.0,60.59,1278.0,-387.0,115.1,1278.0,-349.8,153.5,1278.0,-325.7,184.0,1278.0,-291.7,234.0,1278.0,-257.9,300.6,1278.0,-238.2,387.3,1278.0,-234.9,470.1,1278.0,-236.6,506.6,1322.0,-243.9,505.6,1322.0,-242.3,469.7,1322.0,-245.5,388.9,1322.0,-264.4,305.1};
			return value;
		}
		private double[] getCoordinate_6_22_point_4()
		{
			double[] value = {1322.0,-297.4,240.0,1322.0,-331.0,190.5,1322.0,-354.8,160.3,1322.0,-391.6,122.4,1322.0,-448.8,67.5,1322.0,-491.2,21.06,1322.0,-514.7,-11.88,1322.0,-536.4,-41.57,1322.0,-551.0,-69.8,1322.0,-565.7,-110.9,1322.0,-584.1,-165.0,1322.0,-593.3,-211.8,1322.0,-586.0,-212.8,1322.0,-577.0,-167.2,1322.0,-558.8,-113.9,1322.0,-544.2,-73.34,1322.0,-530.2,-46.47,1322.0,-508.9,-17.29,1322.0,-485.7,15.32,1322.0,-444.0,60.59,1322.0,-387.0,115.1,1322.0,-349.8,153.5,1322.0,-325.7,184.0,1322.0,-291.7,234.0,1322.0,-257.9,300.6,1322.0,-238.2,387.3,1322.0,-234.9,470.1,1322.0,-236.6,506.6,1325.0,-192.9,23.62,1325.0,-45.77,9.821,1325.0,167.1,-10.14,1325.0,315.9,-24.1,1325.0,322.8,-25.67,1325.0,327.0,-28.18,1325.0,328.2,-30.69,1325.0,327.4,-37.05,1325.0,326.6,-44.39,1325.0,325.8,-50.76,1325.0,324.1,-52.99,1325.0,319.8,-54.71,1325.0,313.2,-55.01,1325.0,163.3,-40.96,1325.0,-52.18,-20.74,1325.0,-198.4,-7.032,1325.0,-203.8,-5.602,1325.0,-206.9,-2.821,1325.0,-207.7,0.8984,1325.0,-207.0,6.392,1325.0,-206.4,12.27,1325.0,-205.7,17.76,1325.0,-203.9,21.24,1325.0,-199.5,23.32,450.9,-192.9,23.62,450.9,-45.77,9.821,450.9,167.1,-10.14,450.9,315.9,-24.1,450.9,322.8,-25.67,450.9,327.0,-28.18,450.9,328.2,-30.69,450.9,327.4,-37.05,450.9,326.6,-44.39,450.9,325.8,-50.76,450.9,324.1,-52.99,450.9,319.8,-54.71,450.9,313.2,-55.01,450.9,163.3,-40.96,450.9,-52.18,-20.74,450.9,-198.4,-7.032,450.9,-203.8,-5.602,450.9,-206.9,-2.821,450.9,-207.7,0.8984,450.9,-207.0,6.392,450.9,-206.4,12.27,450.9,-205.7,17.76,450.9,-203.9,21.24,450.9,-199.5,23.32,495.8,-234.1,483.9,495.8,-234.3,488.3,495.8,-234.8,497.4,495.8,-235.2,505.3,495.8,-235.4,506.3,495.8,-236.0,506.8,495.8,-236.8,506.9,495.8,-239.0,506.8,495.8,-241.4,506.6,495.8,-243.5,506.4,495.8,-244.3,506.1,495.8,-244.7,505.4,495.8,-244.9,504.3,495.8,-244.5,496.4,495.8,-244.0,487.4,495.8,-243.8,483.1,571.1,-234.1,483.9,571.1,-234.3,488.3,571.1,-234.8,497.4,571.1,-235.2,505.3,571.1,-235.4,506.3,571.1,-236.0,506.8,571.1,-236.8,506.9,571.1,-239.0,506.8};
			return value;
		}
		private double[] getCoordinate_6_22_point_5()
		{
			double[] value = {571.1,-241.4,506.6,571.1,-243.5,506.4,571.1,-244.3,506.1,571.1,-244.7,505.4,571.1,-244.9,504.3,571.1,-244.5,496.4,571.1,-244.0,487.4,571.1,-243.8,483.1,646.5,-234.1,483.9,646.5,-234.3,488.3,646.5,-234.8,497.4,646.5,-235.2,505.3,646.5,-235.4,506.3,646.5,-236.0,506.8,646.5,-236.8,506.9,646.5,-239.0,506.8,646.5,-241.4,506.6,646.5,-243.5,506.4,646.5,-244.3,506.1,646.5,-244.7,505.4,646.5,-244.9,504.3,646.5,-244.5,496.4,646.5,-244.0,487.4,646.5,-243.8,483.1,721.9,-234.1,483.9,721.9,-234.3,488.3,721.9,-234.8,497.4,721.9,-235.2,505.3,721.9,-235.4,506.3,721.9,-236.0,506.8,721.9,-236.8,506.9,721.9,-239.0,506.8,721.9,-241.4,506.6,721.9,-243.5,506.4,721.9,-244.3,506.1,721.9,-244.7,505.4,721.9,-244.9,504.3,721.9,-244.5,496.4,721.9,-244.0,487.4,721.9,-243.8,483.1,797.2,-234.1,483.9,797.2,-234.3,488.3,797.2,-234.8,497.4,797.2,-235.2,505.3,797.2,-235.4,506.3,797.2,-236.0,506.8,797.2,-236.8,506.9,797.2,-239.0,506.8,797.2,-241.4,506.6,797.2,-243.5,506.4,797.2,-244.3,506.1,797.2,-244.7,505.4,797.2,-244.9,504.3,797.2,-244.5,496.4,797.2,-244.0,487.4,797.2,-243.8,483.1,872.6,-234.1,483.9,872.6,-234.3,488.3,872.6,-234.8,497.4,872.6,-235.2,505.3,872.6,-235.4,506.3,872.6,-236.0,506.8,872.6,-236.8,506.9,872.6,-239.0,506.8,872.6,-241.4,506.6,872.6,-243.5,506.4,872.6,-244.3,506.1,872.6,-244.7,505.4,872.6,-244.9,504.3,872.6,-244.5,496.4,872.6,-244.0,487.4,872.6,-243.8,483.1,948.0,-234.1,483.9,948.0,-234.3,488.3,948.0,-234.8,497.4,948.0,-235.2,505.3,948.0,-235.4,506.3,948.0,-236.0,506.8,948.0,-236.8,506.9,948.0,-239.0,506.8,948.0,-241.4,506.6,948.0,-243.5,506.4,948.0,-244.3,506.1,948.0,-244.7,505.4,948.0,-244.9,504.3,948.0,-244.5,496.4,948.0,-244.0,487.4,948.0,-243.8,483.1,1023.0,-234.1,483.9,1023.0,-234.3,488.3,1023.0,-234.8,497.4,1023.0,-235.2,505.3,1023.0,-235.4,506.3,1023.0,-236.0,506.8,1023.0,-236.8,506.9,1023.0,-239.0,506.8,1023.0,-241.4,506.6,1023.0,-243.5,506.4,1023.0,-244.3,506.1,1023.0,-244.7,505.4};
			return value;
		}
		private double[] getCoordinate_6_22_point_6()
		{
			double[] value = {1023.0,-244.9,504.3,1023.0,-244.5,496.4,1023.0,-244.0,487.4,1023.0,-243.8,483.1,1099.0,-234.1,483.9,1099.0,-234.3,488.3,1099.0,-234.8,497.4,1099.0,-235.2,505.3,1099.0,-235.4,506.3,1099.0,-236.0,506.8,1099.0,-236.8,506.9,1099.0,-239.0,506.8,1099.0,-241.4,506.6,1099.0,-243.5,506.4,1099.0,-244.3,506.1,1099.0,-244.7,505.4,1099.0,-244.9,504.3,1099.0,-244.5,496.4,1099.0,-244.0,487.4,1099.0,-243.8,483.1,1174.0,-234.1,483.9,1174.0,-234.3,488.3,1174.0,-234.8,497.4,1174.0,-235.2,505.3,1174.0,-235.4,506.3,1174.0,-236.0,506.8,1174.0,-236.8,506.9,1174.0,-239.0,506.8,1174.0,-241.4,506.6,1174.0,-243.5,506.4,1174.0,-244.3,506.1,1174.0,-244.7,505.4,1174.0,-244.9,504.3,1174.0,-244.5,496.4,1174.0,-244.0,487.4,1174.0,-243.8,483.1,1249.0,-234.1,483.9,1249.0,-234.3,488.3,1249.0,-234.8,497.4,1249.0,-235.2,505.3,1249.0,-235.4,506.3,1249.0,-236.0,506.8,1249.0,-236.8,506.9,1249.0,-239.0,506.8,1249.0,-241.4,506.6,1249.0,-243.5,506.4,1249.0,-244.3,506.1,1249.0,-244.7,505.4,1249.0,-244.9,504.3,1249.0,-244.5,496.4,1249.0,-244.0,487.4,1249.0,-243.8,483.1,1325.0,-234.1,483.9,1325.0,-234.3,488.3,1325.0,-234.8,497.4,1325.0,-235.2,505.3,1325.0,-235.4,506.3,1325.0,-236.0,506.8,1325.0,-236.8,506.9,1325.0,-239.0,506.8,1325.0,-241.4,506.6,1325.0,-243.5,506.4,1325.0,-244.3,506.1,1325.0,-244.7,505.4,1325.0,-244.9,504.3,1325.0,-244.5,496.4,1325.0,-244.0,487.4,1325.0,-243.8,483.1,634.5,-50.32,21.11,628.3,-47.36,20.8,624.2,-56.28,21.74,633.4,-55.97,21.7,640.7,-52.38,18.2,632.7,-43.87,17.3,619.7,-46.38,17.57,617.6,-56.81,18.67,629.1,-62.28,19.25,644.4,-52.7,13.56,639.3,-44.09,12.65,627.9,-40.84,12.31,621.9,-41.99,12.43,613.7,-48.99,13.17,612.8,-53.78,13.68,617.9,-62.38,14.58,623.2,-64.9,14.85,635.3,-64.48,14.81,640.3,-61.62,14.5,645.7,-53.18,8.1,640.2,-43.86,7.116,627.8,-40.34,6.745,621.3,-41.59,6.877,612.5,-49.17,7.677,611.5,-54.35,8.223,617.0,-63.66,9.207,622.7,-66.38,9.494,635.8,-65.93,9.447,641.2,-62.83,9.119,982.2,73.38,6.629,975.9,76.35,6.316,971.8,67.42,7.258};
			return value;
		}
		private double[] getCoordinate_6_22_point_7()
		{
			double[] value = {981.1,67.74,7.225,988.3,71.33,3.723,980.4,79.84,2.825,967.3,77.33,3.089,965.2,66.9,4.19,976.8,61.43,4.768,992.1,71.01,-0.917,986.9,79.62,-1.826,975.5,82.87,-2.168,969.5,81.72,-2.047,961.3,74.71,-1.308,960.4,69.93,-0.8027,965.5,61.32,0.1059,970.8,58.81,0.371,982.9,59.23,0.3273,987.9,62.09,0.02506,993.4,70.53,-6.379,987.8,79.85,-7.363,975.5,83.36,-7.734,969.0,82.12,-7.602,960.1,74.54,-6.802,959.1,69.36,-6.256,964.6,60.04,-5.272,970.4,57.33,-4.985,983.5,57.77,-5.032,988.9,60.87,-5.36,1156.0,73.38,6.629,1150.0,76.35,6.316,1146.0,67.42,7.258,1155.0,67.74,7.225,1162.0,71.33,3.723,1155.0,79.84,2.825,1141.0,77.33,3.089,1139.0,66.9,4.19,1151.0,61.43,4.768,1166.0,71.01,-0.917,1161.0,79.62,-1.826,1150.0,82.87,-2.168,1144.0,81.72,-2.047,1135.0,74.71,-1.308,1135.0,69.93,-0.8027,1140.0,61.32,0.1059,1145.0,58.81,0.371,1157.0,59.23,0.3273,1162.0,62.09,0.02507,1167.0,70.53,-6.379,1162.0,79.85,-7.363,1150.0,83.36,-7.734,1143.0,82.12,-7.602,1134.0,74.54,-6.802,1133.0,69.36,-6.256,1139.0,60.04,-5.272,1144.0,57.33,-4.985,1158.0,57.77,-5.032,1163.0,60.87,-5.36,1158.0,197.7,-3.721,1152.0,200.6,-3.969,1148.0,191.7,-3.222,1157.0,192.0,-3.249,1164.0,195.7,-6.671,1156.0,204.2,-7.384,1143.0,201.7,-7.174,1141.0,191.2,-6.301,1153.0,185.8,-5.842,1168.0,195.5,-11.32,1163.0,204.1,-12.04,1151.0,207.3,-12.31,1145.0,206.2,-12.21,1137.0,199.2,-11.63,1136.0,194.4,-11.23,1141.0,185.8,-10.51,1147.0,183.2,-10.3,1159.0,183.7,-10.33,1164.0,186.5,-10.57,1169.0,195.1,-16.79,1164.0,204.4,-17.57,1151.0,208.0,-17.86,1145.0,206.7,-17.76,1136.0,199.1,-17.12,1135.0,193.9,-16.69,1141.0,184.6,-15.91,1146.0,181.9,-15.68,1159.0,182.3,-15.72,1165.0,185.4,-15.98,981.8,197.7,-3.721,975.6,200.6,-3.969,971.4,191.7,-3.222,980.7,192.0,-3.249,988.0,195.7,-6.671,980.0,204.2,-7.384,966.9,201.7,-7.174,964.9,191.2,-6.301,976.4,185.8,-5.842,991.7,195.5,-11.32,986.6,204.1,-12.04,975.2,207.3,-12.31,969.2,206.2,-12.21,961.0,199.2,-11.63,960.0,194.4,-11.23,965.2,185.8,-10.51};
			return value;
		}
		private double[] getCoordinate_6_22_point_8()
		{
			double[] value = {970.5,183.2,-10.3,982.6,183.7,-10.33,987.6,186.5,-10.57,993.0,195.1,-16.79,987.5,204.4,-17.57,975.1,208.0,-17.86,968.6,206.7,-17.76,959.8,199.1,-17.12,958.7,193.9,-16.69,964.3,184.6,-15.91,970.0,181.9,-15.68,983.1,182.3,-15.72,988.5,185.4,-15.98,805.3,197.7,-3.721,799.0,200.6,-3.969,794.9,191.7,-3.222,804.2,192.0,-3.249,811.4,195.7,-6.671,803.5,204.2,-7.384,790.4,201.7,-7.174,788.3,191.2,-6.301,799.8,185.8,-5.842,815.2,195.5,-11.32,810.0,204.1,-12.04,798.6,207.3,-12.31,792.6,206.2,-12.21,784.4,199.2,-11.63,783.5,194.4,-11.23,788.6,185.8,-10.51,793.9,183.2,-10.3,806.0,183.7,-10.33,811.0,186.5,-10.57,816.5,195.1,-16.79,810.9,204.4,-17.57,798.6,208.0,-17.86,792.1,206.7,-17.76,783.2,199.1,-17.12,782.2,193.9,-16.69,787.7,184.6,-15.91,793.4,181.9,-15.68,806.6,182.3,-15.72,812.0,185.4,-15.98,637.3,197.7,-3.721,631.1,200.6,-3.969,626.9,191.7,-3.222,636.2,192.0,-3.249,643.5,195.7,-6.671,635.5,204.2,-7.384,622.4,201.7,-7.174,620.4,191.2,-6.301,631.9,185.8,-5.842,647.2,195.5,-11.32,642.1,204.1,-12.04,630.7,207.3,-12.31,624.7,206.2,-12.21,616.5,199.2,-11.63,615.5,194.4,-11.23,620.7,185.8,-10.51,625.9,183.2,-10.3,638.1,183.7,-10.33,643.1,186.5,-10.57,648.5,195.1,-16.79,643.0,204.4,-17.57,630.6,208.0,-17.86,624.1,206.7,-17.76,615.2,199.1,-17.12,614.2,193.9,-16.69,619.8,184.6,-15.91,625.5,181.9,-15.68,638.6,182.3,-15.72,644.0,185.4,-15.98,595.6,-181.8,39.41,612.7,-182.5,33.17,629.9,-183.8,22.11,450.7,-184.5,15.64,450.7,-183.6,23.19,473.0,-182.3,35.11,519.8,-181.3,43.52,571.1,-181.4,43.24,595.6,-138.7,40.75,612.7,-139.6,32.79,629.9,-141.2,18.68,473.0,-139.4,35.27,491.5,-138.7,40.75,519.8,-138.1,46.0,571.1,-138.2,45.64,595.6,-96.43,35.54,612.7,-97.33,27.58,450.7,-98.78,14.84,473.0,-97.05,30.06,519.8,-95.83,40.79,571.1,-95.87,40.43,595.6,-54.87,23.77,612.7,-55.58,17.53,629.9,-56.84,6.468,450.7,-56.71,7.545,473.0,-55.36,19.47,519.8,-54.4,27.88,571.1,-54.43,27.6,769.8,-181.8,39.41};
			return value;
		}
		private double[] getCoordinate_6_22_point_9()
		{
			double[] value = {786.9,-182.5,33.17,804.1,-183.8,22.11,624.9,-184.5,15.64,624.9,-183.6,23.19,647.3,-182.3,35.11,694.1,-181.3,43.52,745.4,-181.4,43.24,769.8,-138.7,40.75,786.9,-139.6,32.79,804.1,-141.2,18.68,647.3,-139.4,35.27,665.7,-138.7,40.75,694.1,-138.1,46.0,745.4,-138.2,45.64,769.8,-96.43,35.54,786.9,-97.33,27.58,624.9,-98.78,14.84,647.3,-97.05,30.06,694.1,-95.83,40.79,745.4,-95.87,40.43,769.8,-54.87,23.77,786.9,-55.58,17.53,804.1,-56.84,6.468,624.9,-56.71,7.545,647.3,-55.36,19.47,694.1,-54.4,27.88,745.4,-54.43,27.6,943.4,-181.8,39.41,960.5,-182.5,33.17,977.6,-183.8,22.11,798.5,-184.5,15.64,798.5,-183.6,23.19,820.8,-182.3,35.11,867.6,-181.3,43.52,918.9,-181.4,43.24,943.4,-138.7,40.75,960.5,-139.6,32.79,977.6,-141.2,18.68,820.8,-139.4,35.27,839.3,-138.7,40.75,867.6,-138.1,46.0,918.9,-138.2,45.64,943.4,-96.43,35.54,960.5,-97.33,27.58,798.5,-98.78,14.84,820.8,-97.05,30.06,867.6,-95.83,40.79,918.9,-95.87,40.43,943.4,-54.87,23.77,960.5,-55.58,17.53,977.6,-56.84,6.468,798.5,-56.71,7.545,820.8,-55.36,19.47,867.6,-54.4,27.88,918.9,-54.43,27.6,1117.0,-181.8,39.41,1134.0,-182.5,33.17,1151.0,-183.8,22.11,972.1,-184.5,15.64,972.1,-183.6,23.19,994.4,-182.3,35.11,1041.0,-181.3,43.52,1092.0,-181.4,43.24,1117.0,-138.7,40.75,1134.0,-139.6,32.79,1151.0,-141.2,18.68,994.4,-139.4,35.27,1013.0,-138.7,40.75,1041.0,-138.1,46.0,1092.0,-138.2,45.64,1117.0,-96.43,35.54,1134.0,-97.33,27.58,972.1,-98.78,14.84,994.4,-97.05,30.06,1041.0,-95.83,40.79,1092.0,-95.87,40.43,1117.0,-54.87,23.77,1134.0,-55.58,17.53,1151.0,-56.84,6.468,972.1,-56.71,7.545,994.4,-55.36,19.47,1041.0,-54.4,27.88,1092.0,-54.43,27.6,1290.0,-181.8,39.41,1307.0,-182.5,33.17,1325.0,-183.8,22.11,1145.0,-184.5,15.64,1145.0,-183.6,23.19,1168.0,-182.3,35.11,1215.0,-181.3,43.52,1266.0,-181.4,43.24,1290.0,-138.7,40.75,1307.0,-139.6,32.79,1325.0,-141.2,18.68,1168.0,-139.4,35.27,1186.0,-138.7,40.75,1215.0,-138.1,46.0,1266.0,-138.2,45.64,1290.0,-96.43,35.54,1307.0,-97.33,27.58};
			return value;
		}
		private double[] getCoordinate_6_22_point_10()
		{
			double[] value = {1145.0,-98.78,14.84,1168.0,-97.05,30.06,1215.0,-95.83,40.79,1266.0,-95.87,40.43,1290.0,-54.87,23.77,1307.0,-55.58,17.53,1325.0,-56.84,6.468,1145.0,-56.71,7.545,1168.0,-55.36,19.47,1215.0,-54.4,27.88,1266.0,-54.43,27.6,1290.0,-55.67,24.31,1307.0,-56.22,18.06,1325.0,-57.19,6.966,1145.0,-57.75,0.4747,1145.0,-57.09,8.046,1168.0,-56.05,20.0,1215.0,-55.31,28.43,1266.0,-55.34,28.15,1290.0,-12.67,26.78,1307.0,-13.37,18.8,1325.0,-14.6,4.652,1168.0,-13.15,21.29,1186.0,-12.67,26.78,1215.0,-12.21,32.04,1266.0,-12.24,31.69,1290.0,29.76,22.68,1307.0,29.06,14.7,1145.0,27.95,1.925,1168.0,29.28,17.18,1215.0,30.22,27.94,1266.0,30.19,27.58,1290.0,71.61,12.0,1307.0,71.07,5.741,1325.0,70.1,-5.349,1145.0,70.19,-4.269,1168.0,71.24,7.688,1215.0,71.97,16.12,1266.0,71.95,15.84,1117.0,-55.67,24.31,1134.0,-56.22,18.06,1151.0,-57.19,6.966,972.1,-57.75,0.4747,972.1,-57.09,8.046,994.4,-56.05,20.0,1041.0,-55.31,28.43,1092.0,-55.34,28.15,1117.0,-12.67,26.78,1134.0,-13.37,18.8,1151.0,-14.6,4.652,994.4,-13.15,21.29,1013.0,-12.67,26.78,1041.0,-12.21,32.04,1092.0,-12.24,31.69,1117.0,29.76,22.68,1134.0,29.06,14.7,972.1,27.95,1.925,994.4,29.28,17.18,1041.0,30.22,27.94,1092.0,30.19,27.58,1117.0,71.61,12.0,1134.0,71.07,5.741,1151.0,70.1,-5.349,972.1,70.19,-4.269,994.4,71.24,7.688,1041.0,71.97,16.12,1092.0,71.95,15.84,943.4,-55.67,24.31,960.5,-56.22,18.06,977.6,-57.19,6.966,798.5,-57.75,0.4747,798.5,-57.09,8.046,820.8,-56.05,20.0,867.6,-55.31,28.43,918.9,-55.34,28.15,943.4,-12.67,26.78,960.5,-13.37,18.8,977.6,-14.6,4.652,820.8,-13.15,21.29,839.3,-12.67,26.78,867.6,-12.21,32.04,918.9,-12.24,31.69,943.4,29.76,22.68,960.5,29.06,14.7,798.5,27.95,1.925,820.8,29.28,17.18,867.6,30.22,27.94,918.9,30.19,27.58,943.4,71.61,12.0,960.5,71.07,5.741,977.6,70.1,-5.349,798.5,70.19,-4.269,820.8,71.24,7.688,867.6,71.97,16.12,918.9,71.95,15.84,769.8,-55.67,24.31,786.9,-56.22,18.06,804.1,-57.19,6.966,624.9,-57.75,0.4747,624.9,-57.09,8.046};
			return value;
		}
		private double[] getCoordinate_6_22_point_11()
		{
			double[] value = {647.3,-56.05,20.0,694.1,-55.31,28.43,745.4,-55.34,28.15,769.8,-12.67,26.78,786.9,-13.37,18.8,804.1,-14.6,4.652,647.3,-13.15,21.29,665.7,-12.67,26.78,694.1,-12.21,32.04,745.4,-12.24,31.69,769.8,29.76,22.68,786.9,29.06,14.7,624.9,27.95,1.925,647.3,29.28,17.18,694.1,30.22,27.94,745.4,30.19,27.58,769.8,71.61,12.0,786.9,71.07,5.741,804.1,70.1,-5.349,624.9,70.19,-4.269,647.3,71.24,7.688,694.1,71.97,16.12,745.4,71.95,15.84,595.6,-55.67,24.31,612.7,-56.22,18.06,629.9,-57.19,6.966,450.7,-57.75,0.4747,450.7,-57.09,8.046,473.0,-56.05,20.0,519.8,-55.31,28.43,571.1,-55.34,28.15,595.6,-12.67,26.78,612.7,-13.37,18.8,629.9,-14.6,4.652,473.0,-13.15,21.29,491.5,-12.67,26.78,519.8,-12.21,32.04,571.1,-12.24,31.69,595.6,29.76,22.68,612.7,29.06,14.7,450.7,27.95,1.925,473.0,29.28,17.18,519.8,30.22,27.94,571.1,30.19,27.58,595.6,71.61,12.0,612.7,71.07,5.741,629.9,70.1,-5.349,450.7,70.19,-4.269,473.0,71.24,7.688,519.8,71.97,16.12,571.1,71.95,15.84,595.6,70.15,11.79,612.7,69.68,5.524,629.9,68.86,-5.577,450.7,68.38,-12.08,450.7,68.94,-4.497,473.0,69.83,7.473,519.8,70.45,15.91,571.1,70.43,15.63,595.6,113.1,14.82,612.7,112.5,6.831,629.9,111.5,-7.334,473.0,112.7,9.318,491.5,113.1,14.82,519.8,113.5,20.08,571.1,113.5,19.73,595.6,155.6,11.27,612.7,155.0,3.281,450.7,154.1,-9.504,473.0,155.2,5.769,519.8,156.0,16.54,571.1,156.0,16.18,595.6,197.6,1.137,612.7,197.1,-5.124,629.9,196.3,-16.23,450.7,196.4,-15.14,473.0,197.3,-3.175,519.8,197.9,5.263,571.1,197.9,4.984,943.4,70.15,11.79,960.5,69.68,5.524,977.6,68.86,-5.577,798.5,68.38,-12.08,798.5,68.94,-4.497,820.8,69.83,7.473,867.6,70.45,15.91,918.9,70.43,15.63,943.4,113.1,14.82,960.5,112.5,6.831,977.6,111.5,-7.334,820.8,112.7,9.318,839.3,113.1,14.82,867.6,113.5,20.08,918.9,113.5,19.73,943.4,155.6,11.27,960.5,155.0,3.281,798.5,154.1,-9.504,820.8,155.2,5.769,867.6,156.0,16.54,918.9,156.0,16.18};
			return value;
		}
		private double[] getCoordinate_6_22_point_12()
		{
			double[] value = {943.4,197.6,1.137,960.5,197.1,-5.124,977.6,196.3,-16.23,798.5,196.4,-15.14,820.8,197.3,-3.175,867.6,197.9,5.263,918.9,197.9,4.984,1117.0,70.15,11.79,1134.0,69.68,5.524,1151.0,68.86,-5.577,972.1,68.38,-12.08,972.1,68.94,-4.497,994.4,69.83,7.473,1041.0,70.45,15.91,1092.0,70.43,15.63,1117.0,113.1,14.82,1134.0,112.5,6.831,1151.0,111.5,-7.334,994.4,112.7,9.318,1013.0,113.1,14.82,1041.0,113.5,20.08,1092.0,113.5,19.73,1117.0,155.6,11.27,1134.0,155.0,3.281,972.1,154.1,-9.504,994.4,155.2,5.769,1041.0,156.0,16.54,1092.0,156.0,16.18,1117.0,197.6,1.137,1134.0,197.1,-5.124,1151.0,196.3,-16.23,972.1,196.4,-15.14,994.4,197.3,-3.175,1041.0,197.9,5.263,1092.0,197.9,4.984,1290.0,70.15,11.79,1307.0,69.68,5.524,1325.0,68.86,-5.577,1145.0,68.38,-12.08,1145.0,68.94,-4.497,1168.0,69.83,7.473,1215.0,70.45,15.91,1266.0,70.43,15.63,1290.0,113.1,14.82,1307.0,112.5,6.831,1325.0,111.5,-7.334,1168.0,112.7,9.318,1186.0,113.1,14.82,1215.0,113.5,20.08,1266.0,113.5,19.73,1290.0,155.6,11.27,1307.0,155.0,3.281,1145.0,154.1,-9.504,1168.0,155.2,5.769,1215.0,156.0,16.54,1266.0,156.0,16.18,1290.0,197.6,1.137,1307.0,197.1,-5.124,1325.0,196.3,-16.23,1145.0,196.4,-15.14,1168.0,197.3,-3.175,1215.0,197.9,5.263,1266.0,197.9,4.984,1290.0,196.2,0.4403,1307.0,195.7,-5.821,1325.0,194.9,-16.92,1145.0,194.4,-23.42,1145.0,195.0,-15.84,1168.0,195.9,-3.872,1215.0,196.5,4.566,1266.0,196.5,4.287,1290.0,239.2,3.475,1307.0,238.6,-4.514,1325.0,237.5,-18.68,1168.0,238.8,-2.027,1186.0,239.2,3.475,1215.0,239.6,8.739,1266.0,239.5,8.383,1290.0,281.6,-0.07425,1307.0,281.0,-8.064,1145.0,280.1,-20.85,1168.0,281.2,-5.576,1215.0,282.0,5.19,1266.0,282.0,4.834,1290.0,323.6,-10.21,1307.0,323.2,-16.47,1325.0,322.3,-27.57,1145.0,322.4,-26.49,1168.0,323.3,-14.52,1215.0,323.9,-6.082,1266.0,323.9,-6.361,1117.0,196.2,0.4403,1134.0,195.7,-5.821,1151.0,194.9,-16.92,972.1,194.4,-23.42,972.1,195.0,-15.84,994.4,195.9,-3.872,1041.0,196.5,4.566,1092.0,196.5,4.287,1117.0,239.2,3.475};
			return value;
		}
		private double[] getCoordinate_6_22_point_13()
		{
			double[] value = {1134.0,238.6,-4.514,1151.0,237.5,-18.68,994.4,238.8,-2.027,1013.0,239.2,3.475,1041.0,239.6,8.739,1092.0,239.5,8.383,1117.0,281.6,-0.07425,1134.0,281.0,-8.064,972.1,280.1,-20.85,994.4,281.2,-5.576,1041.0,282.0,5.19,1092.0,282.0,4.834,1117.0,323.6,-10.21,1134.0,323.2,-16.47,1151.0,322.3,-27.57,972.1,322.4,-26.49,994.4,323.3,-14.52,1041.0,323.9,-6.082,1092.0,323.9,-6.361,943.4,196.2,0.4403,960.5,195.7,-5.821,977.6,194.9,-16.92,798.5,194.4,-23.42,798.5,195.0,-15.84,820.8,195.9,-3.872,867.6,196.5,4.566,918.9,196.5,4.287,943.4,239.2,3.475,960.5,238.6,-4.514,977.6,237.5,-18.68,820.8,238.8,-2.027,839.3,239.2,3.475,867.6,239.6,8.739,918.9,239.5,8.383,943.4,281.6,-0.07425,960.5,281.0,-8.064,798.5,280.1,-20.85,820.8,281.2,-5.576,867.6,282.0,5.19,918.9,282.0,4.834,943.4,323.6,-10.21,960.5,323.2,-16.47,977.6,322.3,-27.57,798.5,322.4,-26.49,820.8,323.3,-14.52,867.6,323.9,-6.082,918.9,323.9,-6.361,769.8,196.2,0.4403,786.9,195.7,-5.821,804.1,194.9,-16.92,624.9,194.4,-23.42,624.9,195.0,-15.84,647.3,195.9,-3.872,694.1,196.5,4.566,745.4,196.5,4.287,769.8,239.2,3.475,786.9,238.6,-4.514,804.1,237.5,-18.68,647.3,238.8,-2.027,665.7,239.2,3.475,694.1,239.6,8.739,745.4,239.5,8.383,769.8,281.6,-0.07425,786.9,281.0,-8.064,624.9,280.1,-20.85,647.3,281.2,-5.576,694.1,282.0,5.19,745.4,282.0,4.834,769.8,323.6,-10.21,786.9,323.2,-16.47,804.1,322.3,-27.57,624.9,322.4,-26.49,647.3,323.3,-14.52,694.1,323.9,-6.082,745.4,323.9,-6.361,595.6,196.2,0.4403,612.7,195.7,-5.821,629.9,194.9,-16.92,450.7,194.4,-23.42,450.7,195.0,-15.84,473.0,195.9,-3.872,519.8,196.5,4.566,571.1,196.5,4.287,595.6,239.2,3.475,612.7,238.6,-4.514,629.9,237.5,-18.68,473.0,238.8,-2.027,491.5,239.2,3.475,519.8,239.6,8.739,571.1,239.5,8.383,595.6,281.6,-0.07425,612.7,281.0,-8.064,450.7,280.1,-20.85,473.0,281.2,-5.576,519.8,282.0,5.19,571.1,282.0,4.834,595.6,323.6,-10.21,612.7,323.2,-16.47,629.9,322.3,-27.57,450.7,322.4,-26.49};
			return value;
		}
		private double[] getCoordinate_6_22_point_14()
		{
			double[] value = {473.0,323.3,-14.52,519.8,323.9,-6.082,571.1,323.9,-6.361,769.8,70.15,11.79,786.9,69.68,5.524,804.1,68.86,-5.577,624.9,68.38,-12.08,624.9,68.94,-4.497,647.3,69.83,7.473,694.1,70.45,15.91,745.4,70.43,15.63,769.8,113.1,14.82,786.9,112.5,6.831,804.1,111.5,-7.334,647.3,112.7,9.318,665.7,113.1,14.82,694.1,113.5,20.08,745.4,113.5,19.73,769.8,155.6,11.27,786.9,155.0,3.281,624.9,154.1,-9.504,647.3,155.2,5.769,694.1,156.0,16.54,745.4,156.0,16.18,769.8,197.6,1.137,786.9,197.1,-5.124,804.1,196.3,-16.23,624.9,196.4,-15.14,647.3,197.3,-3.175,694.1,197.9,5.263,745.4,197.9,4.984,811.0,73.38,6.629,804.7,76.35,6.316,800.6,67.42,7.258,809.9,67.74,7.225,817.1,71.33,3.723,809.2,79.84,2.825,796.1,77.33,3.089,794.0,66.9,4.19,805.5,61.43,4.768,820.9,71.01,-0.917,815.7,79.62,-1.826,804.3,82.87,-2.168,798.3,81.72,-2.047,790.1,74.71,-1.308,789.2,69.93,-0.8027,794.3,61.32,0.1059,799.6,58.81,0.371,811.7,59.23,0.3273,816.7,62.09,0.02506,822.2,70.53,-6.379,816.6,79.85,-7.363,804.3,83.36,-7.734,797.8,82.12,-7.602,788.9,74.54,-6.802,787.9,69.36,-6.256,793.4,60.04,-5.272,799.1,57.33,-4.985,812.3,57.77,-5.032,817.7,60.87,-5.36,634.8,73.38,6.629,628.6,76.35,6.316,624.4,67.42,7.258,633.7,67.74,7.225,641.0,71.33,3.723,633.0,79.84,2.825,619.9,77.33,3.089,617.9,66.9,4.19,629.4,61.43,4.768,644.7,71.01,-0.917,639.6,79.62,-1.826,628.2,82.87,-2.168,622.2,81.72,-2.047,614.0,74.71,-1.308,613.0,69.93,-0.8027,618.1,61.32,0.1059,623.4,58.81,0.371,635.6,59.23,0.3273,640.5,62.09,0.02507,646.0,70.53,-6.379,640.5,79.85,-7.363,628.1,83.36,-7.734,621.6,82.12,-7.602,612.7,74.54,-6.802,611.7,69.36,-6.256,617.3,60.04,-5.272,623.0,57.33,-4.985,636.1,57.77,-5.032,641.5,60.87,-5.36,1155.0,-50.32,21.11,1149.0,-47.36,20.8,1145.0,-56.28,21.74,1154.0,-55.97,21.7,1161.0,-52.38,18.2,1153.0,-43.87,17.3,1140.0,-46.38,17.57,1138.0,-56.81,18.67,1150.0,-62.28,19.25,1165.0,-52.7,13.56,1160.0,-44.09,12.65};
			return value;
		}
		private double[] getCoordinate_6_22_point_15()
		{
			double[] value = {1149.0,-40.84,12.31,1143.0,-41.99,12.43,1134.0,-48.99,13.17,1133.0,-53.78,13.68,1139.0,-62.38,14.58,1144.0,-64.9,14.85,1156.0,-64.48,14.81,1161.0,-61.62,14.5,1166.0,-53.18,8.1,1161.0,-43.86,7.116,1149.0,-40.34,6.745,1142.0,-41.59,6.877,1133.0,-49.17,7.677,1132.0,-54.35,8.223,1138.0,-63.66,9.207,1143.0,-66.38,9.494,1157.0,-65.93,9.447,1162.0,-62.83,9.119,983.1,-50.32,21.11,976.8,-47.36,20.8,972.7,-56.28,21.74,981.9,-55.97,21.7,989.2,-52.38,18.2,981.3,-43.87,17.3,968.2,-46.38,17.57,966.1,-56.81,18.67,977.6,-62.28,19.25,992.9,-52.7,13.56,987.8,-44.09,12.65,976.4,-40.84,12.31,970.4,-41.99,12.43,962.2,-48.99,13.17,961.3,-53.78,13.68,966.4,-62.38,14.58,971.7,-64.9,14.85,983.8,-64.48,14.81,988.8,-61.62,14.5,994.2,-53.18,8.1,988.7,-43.86,7.116,976.4,-40.34,6.745,969.9,-41.59,6.877,961.0,-49.17,7.677,960.0,-54.35,8.223,965.5,-63.66,9.207,971.2,-66.38,9.494,984.4,-65.93,9.447,989.8,-62.83,9.119,809.4,-50.32,21.11,803.1,-47.36,20.8,799.0,-56.28,21.74,808.3,-55.97,21.7,815.5,-52.38,18.2,807.6,-43.87,17.3,794.5,-46.38,17.57,792.4,-56.81,18.67,803.9,-62.28,19.25,819.3,-52.7,13.56,814.1,-44.09,12.65,802.7,-40.84,12.31,796.7,-41.99,12.43,788.5,-48.99,13.17,787.6,-53.78,13.68,792.7,-62.38,14.58,798.0,-64.9,14.85,810.1,-64.48,14.81,815.1,-61.62,14.5,820.6,-53.18,8.1,815.0,-43.86,7.116,802.7,-40.34,6.745,796.2,-41.59,6.877,787.3,-49.17,7.677,786.3,-54.35,8.223,791.8,-63.66,9.207,797.5,-66.38,9.494,810.7,-65.93,9.447,816.1,-62.83,9.119,634.5,-177.0,373.9,628.3,-177.2,370.9,624.2,-176.8,379.9,633.4,-176.8,379.6,640.7,-179.5,375.8,632.7,-179.8,367.3,619.7,-179.7,369.8,617.6,-179.3,380.3,629.1,-179.1,385.8,644.4,-183.3,375.9,639.3,-183.6,367.2,627.9,-183.8,363.9,621.9,-183.7,365.1,613.7,-183.4,372.1,612.8,-183.2,376.9,617.9,-182.9,385.6,623.2,-182.8,388.1,635.3,-182.8,387.7,640.3,-182.9,384.8,645.7,-187.7,376.0,640.2,-188.1,366.7,627.8,-188.3,363.1,621.3,-188.2,364.4,612.5,-187.9,372.0};
			return value;
		}
		private double[] getCoordinate_6_22_point_16()
		{
			double[] value = {611.5,-187.7,377.2,617.0,-187.3,386.5,622.7,-187.2,389.3,635.8,-187.2,388.8,641.2,-187.3,385.7,982.2,-183.3,249.6,975.9,-183.4,246.6,971.8,-183.1,255.6,981.1,-183.1,255.3,988.3,-185.8,251.5,980.4,-186.1,242.9,967.3,-186.0,245.4,965.2,-185.6,255.9,976.8,-185.3,261.4,992.1,-189.5,251.5,986.9,-189.9,242.9,975.5,-190.0,239.6,969.5,-190.0,240.8,961.3,-189.7,247.8,960.4,-189.5,252.6,965.5,-189.1,261.2,970.8,-189.0,263.8,982.9,-189.0,263.4,987.9,-189.2,260.5,993.4,-194.0,251.7,987.8,-194.4,242.3,975.5,-194.5,238.8,969.0,-194.5,240.0,960.1,-194.2,247.6,959.1,-193.9,252.9,964.6,-193.6,262.2,970.4,-193.4,264.9,983.5,-193.5,264.5,988.9,-193.6,261.4,1156.0,-183.3,249.6,1150.0,-183.4,246.6,1146.0,-183.1,255.6,1155.0,-183.1,255.3,1162.0,-185.8,251.5,1155.0,-186.1,242.9,1141.0,-186.0,245.4,1139.0,-185.6,255.9,1151.0,-185.3,261.4,1166.0,-189.5,251.5,1161.0,-189.9,242.9,1150.0,-190.0,239.6,1144.0,-190.0,240.8,1135.0,-189.7,247.8,1135.0,-189.5,252.6,1140.0,-189.1,261.2,1145.0,-189.0,263.8,1157.0,-189.0,263.4,1162.0,-189.2,260.5,1167.0,-194.0,251.7,1162.0,-194.4,242.3,1150.0,-194.5,238.8,1143.0,-194.5,240.0,1134.0,-194.2,247.6,1133.0,-193.9,252.9,1139.0,-193.6,262.2,1144.0,-193.4,264.9,1158.0,-193.5,264.5,1163.0,-193.6,261.4,1158.0,-186.2,124.9,1152.0,-186.2,121.9,1148.0,-186.0,130.9,1157.0,-186.0,130.6,1164.0,-188.7,126.7,1156.0,-188.9,118.2,1143.0,-188.8,120.7,1141.0,-188.6,131.2,1153.0,-188.4,136.7,1168.0,-192.4,126.7,1163.0,-192.6,118.0,1151.0,-192.7,114.7,1145.0,-192.7,115.9,1137.0,-192.5,122.9,1136.0,-192.4,127.8,1141.0,-192.2,136.4,1147.0,-192.2,138.9,1159.0,-192.2,138.5,1164.0,-192.2,135.6,1169.0,-196.9,126.7,1164.0,-197.1,117.3,1151.0,-197.2,113.8,1145.0,-197.2,115.1,1136.0,-197.0,122.7,1135.0,-196.9,127.9,1141.0,-196.7,137.2,1146.0,-196.6,140.0,1159.0,-196.6,139.5,1165.0,-196.7,136.4,981.8,-186.2,124.9,975.6,-186.2,121.9,971.4,-186.0,130.9,980.7,-186.0,130.6,988.0,-188.7,126.7,980.0,-188.9,118.2,966.9,-188.8,120.7,964.9,-188.6,131.2};
			return value;
		}
		private double[] getCoordinate_6_22_point_17()
		{
			double[] value = {976.4,-188.4,136.7,991.7,-192.4,126.7,986.6,-192.6,118.0,975.2,-192.7,114.7,969.2,-192.7,115.9,961.0,-192.5,122.9,960.0,-192.4,127.8,965.2,-192.2,136.4,970.5,-192.2,138.9,982.6,-192.2,138.5,987.6,-192.2,135.6,993.0,-196.9,126.7,987.5,-197.1,117.3,975.1,-197.2,113.8,968.6,-197.2,115.1,959.8,-197.0,122.7,958.7,-196.9,127.9,964.3,-196.7,137.2,970.0,-196.6,140.0,983.1,-196.6,139.5,988.5,-196.7,136.4,805.3,-186.2,124.9,799.0,-186.2,121.9,794.9,-186.0,130.9,804.2,-186.0,130.6,811.4,-188.7,126.7,803.5,-188.9,118.2,790.4,-188.8,120.7,788.3,-188.6,131.2,799.8,-188.4,136.7,815.2,-192.4,126.7,810.0,-192.6,118.0,798.6,-192.7,114.7,792.6,-192.7,115.9,784.4,-192.5,122.9,783.5,-192.4,127.8,788.6,-192.2,136.4,793.9,-192.2,138.9,806.0,-192.2,138.5,811.0,-192.2,135.6,816.5,-196.9,126.7,810.9,-197.1,117.3,798.6,-197.2,113.8,792.1,-197.2,115.1,783.2,-197.0,122.7,782.2,-196.9,127.9,787.7,-196.7,137.2,793.4,-196.6,140.0,806.6,-196.6,139.5,812.0,-196.7,136.4,637.3,-186.2,124.9,631.1,-186.2,121.9,626.9,-186.0,130.9,636.2,-186.0,130.6,643.5,-188.7,126.7,635.5,-188.9,118.2,622.4,-188.8,120.7,620.4,-188.6,131.2,631.9,-188.4,136.7,647.2,-192.4,126.7,642.1,-192.6,118.0,630.7,-192.7,114.7,624.7,-192.7,115.9,616.5,-192.5,122.9,615.5,-192.4,127.8,620.7,-192.2,136.4,625.9,-192.2,138.9,638.1,-192.2,138.5,643.1,-192.2,135.6,648.5,-196.9,126.7,643.0,-197.1,117.3,630.6,-197.2,113.8,624.1,-197.2,115.1,615.2,-197.0,122.7,614.2,-196.9,127.9,619.8,-196.7,137.2,625.5,-196.6,140.0,638.6,-196.6,139.5,644.0,-196.7,136.4,595.6,-168.0,506.2,612.7,-173.1,506.6,629.9,-182.2,507.2,450.7,-181.3,507.1,473.0,-171.5,506.5,571.1,-164.9,506.0,595.6,-165.0,463.3,612.7,-171.5,463.8,629.9,-183.1,464.5,473.0,-169.5,463.6,519.8,-160.7,463.0,571.1,-161.0,463.1,595.6,-167.4,420.8,612.7,-173.9,421.2,450.7,-184.3,421.9,473.0,-171.9,421.1,519.8,-163.1,420.5,571.1,-163.4,420.5,595.6,-175.1,378.6,612.7,-180.2,379.0,629.9,-189.2,379.6};
			return value;
		}
		private double[] getCoordinate_6_22_point_18()
		{
			double[] value = {450.7,-188.3,379.5,473.0,-178.6,378.9,519.8,-171.7,378.4,769.8,-168.0,506.2,786.9,-173.1,506.6,804.1,-182.2,507.2,624.9,-181.3,507.1,647.3,-171.5,506.5,745.4,-164.9,506.0,769.8,-165.0,463.3,786.9,-171.5,463.8,804.1,-183.1,464.5,647.3,-169.5,463.6,694.1,-160.7,463.0,745.4,-161.0,463.1,769.8,-167.4,420.8,786.9,-173.9,421.2,624.9,-184.3,421.9,647.3,-171.9,421.1,694.1,-163.1,420.5,745.4,-163.4,420.5,769.8,-175.1,378.6,786.9,-180.2,379.0,804.1,-189.2,379.6,624.9,-188.3,379.5,647.3,-178.6,378.9,694.1,-171.7,378.4,943.4,-168.0,506.2,960.5,-173.1,506.6,977.6,-182.2,507.2,798.5,-181.3,507.1,820.8,-171.5,506.5,918.9,-164.9,506.0,943.4,-165.0,463.3,960.5,-171.5,463.8,977.6,-183.1,464.5,820.8,-169.5,463.6,867.6,-160.7,463.0,918.9,-161.0,463.1,943.4,-167.4,420.8,960.5,-173.9,421.2,798.5,-184.3,421.9,820.8,-171.9,421.1,867.6,-163.1,420.5,918.9,-163.4,420.5,943.4,-175.1,378.6,960.5,-180.2,379.0,977.6,-189.2,379.6,798.5,-188.3,379.5,820.8,-178.6,378.9,867.6,-171.7,378.4,1117.0,-168.0,506.2,1134.0,-173.1,506.6,1151.0,-182.2,507.2,972.1,-181.3,507.1,994.4,-171.5,506.5,1092.0,-164.9,506.0,1117.0,-165.0,463.3,1134.0,-171.5,463.8,1151.0,-183.1,464.5,994.4,-169.5,463.6,1041.0,-160.7,463.0,1092.0,-161.0,463.1,1117.0,-167.4,420.8,1134.0,-173.9,421.2,972.1,-184.3,421.9,994.4,-171.9,421.1,1041.0,-163.1,420.5,1092.0,-163.4,420.5,1117.0,-175.1,378.6,1134.0,-180.2,379.0,1151.0,-189.2,379.6,972.1,-188.3,379.5,994.4,-178.6,378.9,1041.0,-171.7,378.4,1290.0,-168.0,506.2,1307.0,-173.1,506.6,1325.0,-182.2,507.2,1145.0,-181.3,507.1,1168.0,-171.5,506.5,1266.0,-164.9,506.0,1290.0,-165.0,463.3,1307.0,-171.5,463.8,1325.0,-183.1,464.5,1168.0,-169.5,463.6,1215.0,-160.7,463.0,1266.0,-161.0,463.1,1290.0,-167.4,420.8,1307.0,-173.9,421.2,1145.0,-184.3,421.9,1168.0,-171.9,421.1,1215.0,-163.1,420.5,1266.0,-163.4,420.5,1290.0,-175.1,378.6,1307.0,-180.2,379.0,1325.0,-189.2,379.6,1145.0,-188.3,379.5,1168.0,-178.6,378.9,1215.0,-171.7,378.4,1290.0,-174.7,379.5};
			return value;
		}
		private double[] getCoordinate_6_22_point_19()
		{
			double[] value = {1307.0,-179.8,379.6,1325.0,-188.8,380.0,1145.0,-188.0,379.9,1168.0,-178.2,379.6,1266.0,-171.6,379.3,1290.0,-170.8,336.7,1307.0,-177.3,336.9,1325.0,-188.8,337.3,1168.0,-175.3,336.8,1215.0,-166.5,336.5,1266.0,-166.8,336.5,1290.0,-172.2,294.1,1307.0,-178.7,294.3,1145.0,-189.1,294.7,1168.0,-176.7,294.2,1215.0,-167.9,293.9,1266.0,-168.2,293.9,1290.0,-179.0,251.7,1307.0,-184.1,251.8,1325.0,-193.2,252.2,1145.0,-192.3,252.1,1168.0,-182.5,251.8,1215.0,-175.7,251.5,1117.0,-174.7,379.5,1134.0,-179.8,379.6,1151.0,-188.8,380.0,972.1,-188.0,379.9,994.4,-178.2,379.6,1092.0,-171.6,379.3,1117.0,-170.8,336.7,1134.0,-177.3,336.9,1151.0,-188.8,337.3,994.4,-175.3,336.8,1041.0,-166.5,336.5,1092.0,-166.8,336.5,1117.0,-172.2,294.1,1134.0,-178.7,294.3,972.1,-189.1,294.7,994.4,-176.7,294.2,1041.0,-167.9,293.9,1092.0,-168.2,293.9,1117.0,-179.0,251.7,1134.0,-184.1,251.8,1151.0,-193.2,252.2,972.1,-192.3,252.1,994.4,-182.5,251.8,1041.0,-175.7,251.5,943.4,-174.7,379.5,960.5,-179.8,379.6,977.6,-188.8,380.0,798.5,-188.0,379.9,820.8,-178.2,379.6,918.9,-171.6,379.3,943.4,-170.8,336.7,960.5,-177.3,336.9,977.6,-188.8,337.3,820.8,-175.3,336.8,867.6,-166.5,336.5,918.9,-166.8,336.5,943.4,-172.2,294.1,960.5,-178.7,294.3,798.5,-189.1,294.7,820.8,-176.7,294.2,867.6,-167.9,293.9,918.9,-168.2,293.9,943.4,-179.0,251.7,960.5,-184.1,251.8,977.6,-193.2,252.2,798.5,-192.3,252.1,820.8,-182.5,251.8,867.6,-175.7,251.5,769.8,-174.7,379.5,786.9,-179.8,379.6,804.1,-188.8,380.0,624.9,-188.0,379.9,647.3,-178.2,379.6,745.4,-171.6,379.3,769.8,-170.8,336.7,786.9,-177.3,336.9,804.1,-188.8,337.3,647.3,-175.3,336.8,694.1,-166.5,336.5,745.4,-166.8,336.5,769.8,-172.2,294.1,786.9,-178.7,294.3,624.9,-189.1,294.7,647.3,-176.7,294.2,694.1,-167.9,293.9,745.4,-168.2,293.9,769.8,-179.0,251.7,786.9,-184.1,251.8,804.1,-193.2,252.2,624.9,-192.3,252.1,647.3,-182.5,251.8,694.1,-175.7,251.5,595.6,-174.7,379.5,612.7,-179.8,379.6,629.9,-188.8,380.0,450.7,-188.0,379.9,473.0,-178.2,379.6};
			return value;
		}
		private double[] getCoordinate_6_22_point_20()
		{
			double[] value = {571.1,-171.6,379.3,595.6,-170.8,336.7,612.7,-177.3,336.9,629.9,-188.8,337.3,473.0,-175.3,336.8,519.8,-166.5,336.5,571.1,-166.8,336.5,595.6,-172.2,294.1,612.7,-178.7,294.3,450.7,-189.1,294.7,473.0,-176.7,294.2,519.8,-167.9,293.9,571.1,-168.2,293.9,595.6,-179.0,251.7,612.7,-184.1,251.8,629.9,-193.2,252.2,450.7,-192.3,252.1,473.0,-182.5,251.8,519.8,-175.7,251.5,595.6,-179.3,253.1,612.7,-184.4,253.2,629.9,-193.4,253.4,450.7,-192.5,253.4,473.0,-182.8,253.2,571.1,-176.1,253.1,595.6,-174.9,210.4,612.7,-181.4,210.5,629.9,-192.9,210.8,473.0,-179.4,210.5,519.8,-170.6,210.3,571.1,-170.9,210.3,595.6,-175.9,167.8,612.7,-182.4,167.9,450.7,-192.8,168.1,473.0,-180.4,167.9,519.8,-171.6,167.7,571.1,-171.9,167.7,595.6,-182.2,125.3,612.7,-187.3,125.4,629.9,-196.4,125.6,450.7,-195.5,125.5,473.0,-185.8,125.3,519.8,-178.9,125.2,943.4,-179.3,253.1,960.5,-184.4,253.2,977.6,-193.4,253.4,798.5,-192.5,253.4,820.8,-182.8,253.2,918.9,-176.1,253.1,943.4,-174.9,210.4,960.5,-181.4,210.5,977.6,-192.9,210.8,820.8,-179.4,210.5,867.6,-170.6,210.3,918.9,-170.9,210.3,943.4,-175.9,167.8,960.5,-182.4,167.9,798.5,-192.8,168.1,820.8,-180.4,167.9,867.6,-171.6,167.7,918.9,-171.9,167.7,943.4,-182.2,125.3,960.5,-187.3,125.4,977.6,-196.4,125.6,798.5,-195.5,125.5,820.8,-185.8,125.3,867.6,-178.9,125.2,1117.0,-179.3,253.1,1134.0,-184.4,253.2,1151.0,-193.4,253.4,972.1,-192.5,253.4,994.4,-182.8,253.2,1092.0,-176.1,253.1,1117.0,-174.9,210.4,1134.0,-181.4,210.5,1151.0,-192.9,210.8,994.4,-179.4,210.5,1041.0,-170.6,210.3,1092.0,-170.9,210.3,1117.0,-175.9,167.8,1134.0,-182.4,167.9,972.1,-192.8,168.1,994.4,-180.4,167.9,1041.0,-171.6,167.7,1092.0,-171.9,167.7,1117.0,-182.2,125.3,1134.0,-187.3,125.4,1151.0,-196.4,125.6,972.1,-195.5,125.5,994.4,-185.8,125.3,1041.0,-178.9,125.2,1290.0,-179.3,253.1,1307.0,-184.4,253.2,1325.0,-193.4,253.4,1145.0,-192.5,253.4,1168.0,-182.8,253.2,1266.0,-176.1,253.1,1290.0,-174.9,210.4,1307.0,-181.4,210.5,1325.0,-192.9,210.8};
			return value;
		}
		private double[] getCoordinate_6_22_point_21()
		{
			double[] value = {1168.0,-179.4,210.5,1215.0,-170.6,210.3,1266.0,-170.9,210.3,1290.0,-175.9,167.8,1307.0,-182.4,167.9,1145.0,-192.8,168.1,1168.0,-180.4,167.9,1215.0,-171.6,167.7,1266.0,-171.9,167.7,1290.0,-182.2,125.3,1307.0,-187.3,125.4,1325.0,-196.4,125.6,1145.0,-195.5,125.5,1168.0,-185.8,125.3,1215.0,-178.9,125.2,1290.0,-182.9,126.6,1307.0,-188.0,126.7,1325.0,-197.0,126.9,1145.0,-196.1,126.9,1168.0,-186.4,126.7,1266.0,-179.7,126.6,1290.0,-178.5,83.91,1307.0,-185.0,84.03,1325.0,-196.5,84.26,1168.0,-183.0,83.99,1215.0,-174.2,83.83,1266.0,-174.5,83.83,1290.0,-179.5,41.3,1307.0,-186.0,41.42,1145.0,-196.4,41.62,1168.0,-184.0,41.38,1215.0,-175.2,41.21,1266.0,-175.5,41.22,1290.0,-185.8,-1.214,1307.0,-190.9,-1.116,1325.0,-200.0,-0.9421,1145.0,-199.1,-0.959,1168.0,-189.4,-1.147,1215.0,-182.5,-1.279,1117.0,-182.9,126.6,1134.0,-188.0,126.7,1151.0,-197.0,126.9,972.1,-196.1,126.9,994.4,-186.4,126.7,1092.0,-179.7,126.6,1117.0,-178.5,83.91,1134.0,-185.0,84.03,1151.0,-196.5,84.26,994.4,-183.0,83.99,1041.0,-174.2,83.83,1092.0,-174.5,83.83,1117.0,-179.5,41.3,1134.0,-186.0,41.42,972.1,-196.4,41.62,994.4,-184.0,41.38,1041.0,-175.2,41.21,1092.0,-175.5,41.22,1117.0,-185.8,-1.214,1134.0,-190.9,-1.116,1151.0,-200.0,-0.942,972.1,-199.1,-0.959,994.4,-189.4,-1.147,1041.0,-182.5,-1.279,943.4,-182.9,126.6,960.5,-188.0,126.7,977.6,-197.0,126.9,798.5,-196.1,126.9,820.8,-186.4,126.7,918.9,-179.7,126.6,943.4,-178.5,83.91,960.5,-185.0,84.03,977.6,-196.5,84.26,820.8,-183.0,83.99,867.6,-174.2,83.83,918.9,-174.5,83.83,943.4,-179.5,41.3,960.5,-186.0,41.42,798.5,-196.4,41.62,820.8,-184.0,41.38,867.6,-175.2,41.21,918.9,-175.5,41.22,943.4,-185.8,-1.214,960.5,-190.9,-1.116,977.6,-200.0,-0.942,798.5,-199.1,-0.959,820.8,-189.4,-1.147,867.6,-182.5,-1.279,769.8,-182.9,126.6,786.9,-188.0,126.7,804.1,-197.0,126.9,624.9,-196.1,126.9,647.3,-186.4,126.7,745.4,-179.7,126.6,769.8,-178.5,83.91,786.9,-185.0,84.03,804.1,-196.5,84.26,647.3,-183.0,83.99,694.1,-174.2,83.83,745.4,-174.5,83.83,769.8,-179.5,41.3};
			return value;
		}
		private double[] getCoordinate_6_22_point_22()
		{
			double[] value = {786.9,-186.0,41.42,624.9,-196.4,41.62,647.3,-184.0,41.38,694.1,-175.2,41.21,745.4,-175.5,41.22,769.8,-185.8,-1.214,786.9,-190.9,-1.116,804.1,-200.0,-0.942,624.9,-199.1,-0.9589,647.3,-189.4,-1.147,694.1,-182.5,-1.279,595.6,-182.9,126.6,612.7,-188.0,126.7,629.9,-197.0,126.9,450.7,-196.1,126.9,473.0,-186.4,126.7,571.1,-179.7,126.6,595.6,-178.5,83.91,612.7,-185.0,84.03,629.9,-196.5,84.26,473.0,-183.0,83.99,519.8,-174.2,83.83,571.1,-174.5,83.83,595.6,-179.5,41.3,612.7,-186.0,41.42,450.7,-196.4,41.62,473.0,-184.0,41.38,519.8,-175.2,41.21,571.1,-175.5,41.22,595.6,-185.8,-1.214,612.7,-190.9,-1.116,629.9,-200.0,-0.942,450.7,-199.1,-0.959,473.0,-189.4,-1.147,519.8,-182.5,-1.279,769.8,-179.3,253.1,786.9,-184.4,253.2,804.1,-193.4,253.4,624.9,-192.5,253.4,647.3,-182.8,253.2,745.4,-176.1,253.1,769.8,-174.9,210.4,786.9,-181.4,210.5,804.1,-192.9,210.8,647.3,-179.4,210.5,694.1,-170.6,210.3,745.4,-170.9,210.3,769.8,-175.9,167.8,786.9,-182.4,167.9,624.9,-192.8,168.1,647.3,-180.4,167.9,694.1,-171.6,167.7,745.4,-171.9,167.7,769.8,-182.2,125.3,786.9,-187.3,125.4,804.1,-196.4,125.6,624.9,-195.5,125.5,647.3,-185.8,125.3,694.1,-178.9,125.2,811.0,-183.3,249.6,804.7,-183.4,246.6,800.6,-183.1,255.6,809.9,-183.1,255.3,817.1,-185.8,251.5,809.2,-186.1,242.9,796.1,-186.0,245.4,794.0,-185.6,255.9,805.5,-185.3,261.4,820.9,-189.5,251.5,815.7,-189.9,242.9,804.3,-190.0,239.6,798.3,-190.0,240.8,790.1,-189.7,247.8,789.2,-189.5,252.6,794.3,-189.1,261.2,799.6,-189.0,263.8,811.7,-189.0,263.4,816.7,-189.2,260.5,822.2,-194.0,251.7,816.6,-194.4,242.3,804.3,-194.5,238.8,797.8,-194.5,240.0,788.9,-194.2,247.6,787.9,-193.9,252.9,793.4,-193.6,262.2,799.1,-193.4,264.9,812.3,-193.5,264.5,817.7,-193.6,261.4,634.8,-183.3,249.6,628.6,-183.4,246.6,624.4,-183.1,255.6,633.7,-183.1,255.3,641.0,-185.8,251.5,633.0,-186.1,242.9,619.9,-186.0,245.4,617.9,-185.6,255.9,629.4,-185.3,261.4,644.7,-189.5,251.5,639.6,-189.9,242.9,628.2,-190.0,239.6};
			return value;
		}
		private double[] getCoordinate_6_22_point_23()
		{
			double[] value = {622.2,-190.0,240.8,614.0,-189.7,247.8,613.0,-189.5,252.6,618.1,-189.1,261.2,623.4,-189.0,263.8,635.6,-189.0,263.4,640.5,-189.2,260.5,646.0,-194.0,251.7,640.5,-194.4,242.3,628.1,-194.5,238.8,621.6,-194.5,240.0,612.7,-194.2,247.6,611.7,-193.9,252.9,617.3,-193.6,262.2,623.0,-193.4,264.9,636.1,-193.5,264.5,641.5,-193.6,261.4,1155.0,-177.0,373.9,1149.0,-177.2,370.9,1145.0,-176.8,379.9,1154.0,-176.8,379.6,1161.0,-179.5,375.8,1153.0,-179.8,367.3,1140.0,-179.7,369.8,1138.0,-179.3,380.3,1150.0,-179.1,385.8,1165.0,-183.3,375.9,1160.0,-183.6,367.2,1149.0,-183.8,363.9,1143.0,-183.7,365.1,1134.0,-183.4,372.1,1133.0,-183.2,376.9,1139.0,-182.9,385.6,1144.0,-182.8,388.1,1156.0,-182.8,387.7,1161.0,-182.9,384.8,1166.0,-187.7,376.0,1161.0,-188.1,366.7,1149.0,-188.3,363.1,1142.0,-188.2,364.4,1133.0,-187.9,372.0,1132.0,-187.7,377.2,1138.0,-187.3,386.5,1143.0,-187.2,389.3,1157.0,-187.2,388.8,1162.0,-187.3,385.7,983.1,-177.0,373.9,976.8,-177.2,370.9,972.7,-176.8,379.9,981.9,-176.8,379.6,989.2,-179.5,375.8,981.3,-179.8,367.3,968.2,-179.7,369.8,966.1,-179.3,380.3,977.6,-179.1,385.8,992.9,-183.3,375.9,987.8,-183.6,367.2,976.4,-183.8,363.9,970.4,-183.7,365.1,962.2,-183.4,372.1,961.3,-183.2,376.9,966.4,-182.9,385.6,971.7,-182.8,388.1,983.8,-182.8,387.7,988.8,-182.9,384.8,994.2,-187.7,376.0,988.7,-188.1,366.7,976.4,-188.3,363.1,969.9,-188.2,364.4,961.0,-187.9,372.0,960.0,-187.7,377.2,965.5,-187.3,386.5,971.2,-187.2,389.3,984.4,-187.2,388.8,989.8,-187.3,385.7,809.4,-177.0,373.9,803.1,-177.2,370.9,799.0,-176.8,379.9,808.3,-176.8,379.6,815.5,-179.5,375.8,807.6,-179.8,367.3,794.5,-179.7,369.8,792.4,-179.3,380.3,803.9,-179.1,385.8,819.3,-183.3,375.9,814.1,-183.6,367.2,802.7,-183.8,363.9,796.7,-183.7,365.1,788.5,-183.4,372.1,787.6,-183.2,376.9,792.7,-182.9,385.6,798.0,-182.8,388.1,810.1,-182.8,387.7,815.1,-182.9,384.8,820.6,-187.7,376.0,815.0,-188.1,366.7,802.7,-188.3,363.1,796.2,-188.2,364.4,787.3,-187.9,372.0,786.3,-187.7,377.2};
			return value;
		}
		private double[] getCoordinate_6_22_point_24()
		{
			double[] value = {791.8,-187.3,386.5,797.5,-187.2,389.3,810.7,-187.2,388.8,816.1,-187.3,385.7};
			return value;
		}

		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=5, element #22, 17296 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_5_22_coordIndex()
		{
			MFInt32 IndexedFaceSet_5_22_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_1()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_2()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_3()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_4()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_5()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_6()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_7()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_8()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_9()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_10()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_11()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_12()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_13()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_14()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_15()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_16()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_17()))
				.append(new MFInt32(getIndexedFaceSet_5_22_coordIndex_18()));
			return IndexedFaceSet_5_22_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=6, element #22, 6912 total numbers made up of 2304 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_6_22_point()
		{
			MFVec3f Coordinate_6_22_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_6_22_point_1()))
				.append(new MFVec3f(getCoordinate_6_22_point_2()))
				.append(new MFVec3f(getCoordinate_6_22_point_3()))
				.append(new MFVec3f(getCoordinate_6_22_point_4()))
				.append(new MFVec3f(getCoordinate_6_22_point_5()))
				.append(new MFVec3f(getCoordinate_6_22_point_6()))
				.append(new MFVec3f(getCoordinate_6_22_point_7()))
				.append(new MFVec3f(getCoordinate_6_22_point_8()))
				.append(new MFVec3f(getCoordinate_6_22_point_9()))
				.append(new MFVec3f(getCoordinate_6_22_point_10()))
				.append(new MFVec3f(getCoordinate_6_22_point_11()))
				.append(new MFVec3f(getCoordinate_6_22_point_12()))
				.append(new MFVec3f(getCoordinate_6_22_point_13()))
				.append(new MFVec3f(getCoordinate_6_22_point_14()))
				.append(new MFVec3f(getCoordinate_6_22_point_15()))
				.append(new MFVec3f(getCoordinate_6_22_point_16()))
				.append(new MFVec3f(getCoordinate_6_22_point_17()))
				.append(new MFVec3f(getCoordinate_6_22_point_18()))
				.append(new MFVec3f(getCoordinate_6_22_point_19()))
				.append(new MFVec3f(getCoordinate_6_22_point_20()))
				.append(new MFVec3f(getCoordinate_6_22_point_21()))
				.append(new MFVec3f(getCoordinate_6_22_point_22()))
				.append(new MFVec3f(getCoordinate_6_22_point_23()))
				.append(new MFVec3f(getCoordinate_6_22_point_24()));
			return Coordinate_6_22_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return UnitChair model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new UnitChair().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Units.UnitChair\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Units.UnitChair self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Units/UnitChair_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Units/UnitChair_JavaExport.x3d"; 
                String filenameX3DV = "Units/UnitChair_JavaExport.x3dv"; 
                String filenameJSON = "Units/UnitChair_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
