package Basic.Units;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Units component example for a simple room table. </p>
 <p> Related links: Catalog page <a href="../../../Units/NoUnitTableIndex.html" target="_blank">NoUnitTable</a>,  source <a href="../../../Units/NoUnitTable.java">NoUnitTable.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Units/NoUnitTable.x3d">NoUnitTable.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Units component example for a simple room table </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Myeong Won Lee </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 August 2009 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Units/UnitExamples.pdf">UnitExamples.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd" target="_blank">http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement" target="_blank">https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D UNIT statement </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Units/NoUnitTable.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Units/NoUnitTable.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Units/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Myeong Won Lee
 */

public class NoUnitTable
{
	/** Default constructor to create this object. */
	public NoUnitTable ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComments(" unit category=\"length\" conversionFactor=\"0.01\" name=\"centimeters\"/ ")
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("NoUnitTable.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Units component example for a simple room table"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Myeong Won Lee"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 August 2009"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("UnitExamples.pdf"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D UNIT statement"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Units/NoUnitTable.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("NoUnitTable.x3d"))
    .addChild(new Background().setGroundColor(new MFColor(new double[] {0.05,0.1,0.3})).setSkyColor(new MFColor(new double[] {0.05,0.1,0.3})))
    .addChild(new Transform().setScale(0.3415,0.3415,0.3415)
      .addChild(new Viewpoint().setDescription("Table view").setPosition(0.0,0.0,1.0))
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(0.7686,0.3451,0.8824)))
        .setGeometry(new IndexedFaceSet().setCoordIndex(getIndexedFaceSet_5_19_coordIndex())
          .setCoord(new Coordinate().setPoint(getCoordinate_6_19_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_5_19_coordIndex_1()
		{
			int[] value = {0,8,9,-1,9,1,0,-1,1,9,10,-1,10,2,1,-1,2,10,11,-1,11,3,2,-1,3,11,12,-1,12,4,3,-1,4,12,13,-1,13,5,4,-1,5,13,14,-1,14,6,5,-1,6,14,15,-1,15,7,6,-1,16,17,25,-1,25,24,16,-1,17,18,26,-1,26,25,17,-1,18,19,27,-1,27,26,18,-1,19,20,28,-1,28,27,19,-1,20,21,29,-1,29,28,20,-1,21,22,30,-1,30,29,21,-1,22,23,31,-1,31,30,22,-1,0,1,33,-1,33,32,0,-1,1,2,34,-1,34,33,1,-1,2,3,35,-1,35,34,2,-1,4,5,37,-1,37,36,4,-1,5,6,38,-1,38,37,5,-1,6,7,39,-1,39,38,6,-1,32,33,49,-1,49,48,32,-1,33,34,50,-1,50,49,33,-1,34,35,51,-1,51,50,34,-1,36,37,53,-1,53,52,36,-1,37,38,54,-1,54,53,37,-1,38,39,55,-1,55,54,38,-1,48,49,65,-1,65,64,48,-1,50,51,67,-1,67,66,50,-1,52,53,69,-1,69,68,52,-1,54,55,71,-1,71,70,54,-1,64,65,81,-1,81,80,64,-1,65,66,82,-1,82,81,65,-1,66,67,83,-1,83,82,66,-1,68,69,85,-1,85,84,68,-1,69,70,86,-1,86,85,69,-1,70,71,87,-1,87,86,70,-1,80,81,97,-1,97,96,80,-1,82,83,99,-1,99,98,82,-1,84,85,101,-1,101,100,84,-1,86,87,103,-1,103,102,86,-1,96,97,113,-1,113,112,96,-1,97,98,114,-1,114,113,97,-1,98,99,115,-1,115,114,98,-1,100,101,117,-1,117,116,100,-1,101,102,118,-1,118,117,101,-1,102,103,119,-1,119,118,102,-1,112,113,17,-1,17,16,112,-1,113,114,18,-1,18,17,113,-1,114,115,19,-1,19,18,114,-1,115,116,20,-1,20,19,115,-1,116,117,21,-1,21,20,116,-1,117,118,22,-1,22,21,117,-1,118,119,23,-1,23,22,118,-1,7,15,40,-1,40,39,7,-1,39,40,56,-1,56,55,39,-1,55,56,72,-1,72,71,55,-1,71,72,88,-1,88,87,71,-1,87,88,104,-1,104,103,87,-1,103,104,120,-1,120,119,103,-1,119,120,31,-1,31,23,119,-1,15,14,41,-1,41,40,15,-1,14,13,42,-1,42,41,14,-1,13,12,43,-1,43,42,13,-1,11,10,45,-1,45,44,11,-1,10,9,46,-1,46,45,10,-1,9,8,47,-1,47,46,9,-1,40,41,57,-1,57,56,40,-1,41,42,58,-1,58,57,41,-1,42,43,59,-1,59,58,42,-1,44,45,61,-1,61,60,44,-1,45,46,62,-1,62,61,45,-1,46,47,63,-1,63,62,46,-1,56,57,73,-1,73,72,56,-1,58,59,75,-1,75,74,58,-1,60,61,77,-1,77,76,60,-1,62,63,79,-1,79,78,62,-1,72,73,89,-1,89,88,72,-1,73,74,90,-1,90,89,73,-1,74,75,91,-1,91,90,74,-1,76,77,93,-1,93,92,76,-1,77,78,94,-1,94,93,77,-1,78,79,95,-1,95,94,78,-1,88,89,105,-1,105,104,88,-1,90,91,107,-1,107,106,90,-1,92,93,109,-1,109,108,92,-1,94,95,111,-1,111,110,94,-1,104,105,121,-1,121,120,104,-1,105,106,122,-1,122,121,105,-1,106,107,123,-1,123,122,106,-1,108,109,125,-1,125,124,108,-1,109,110,126,-1,126,125,109,-1,110,111,127,-1,127,126,110,-1,166,167,164,-1,164,165,166,-1,167,168,163,-1,163,164,167,-1,168,169,162,-1,162,163,168,-1,169,170,161,-1,161,162,169,-1,170,171,160,-1,160,161,170,-1,171,172,159,-1,159,160,171,-1,172,173,158,-1,158,159,172,-1,8,0,32,-1,32,47,8,-1,47,32,48,-1,48,63,47,-1,63,48,64,-1,64,79,63,-1,79,64,80,-1,80,95,79,-1,95,80,96,-1,96,111,95,-1,111,96,112,-1,112,127,111,-1,127,112,16,-1,16,24,127,-1,35,3,128,-1,128,130,35,-1,4,36,131,-1,131,129,4,-1,49,50,133,-1,133,132,49,-1,51,35,130,-1,130,134,51,-1,36,52,135,-1,135,131,36,-1,53,54,137,-1,137,136,53,-1,65,49,132,-1,132,138,65,-1,50,66,139,-1,139,133,50,-1,66,65,138,-1,138,139,66,-1,67,51,134,-1,134,140,67,-1,52,68,141,-1,141,135,52,-1,69,53,136,-1,136,142,69,-1,54,70,143,-1,143,137,54,-1,70,69,142,-1,142,143,70,-1,81,82,145,-1,145,144,81,-1,83,67,140,-1,140,146,83,-1,68,84,147,-1,147,141,68,-1,85,86,149,-1,149,148,85,-1,97,81,144,-1,144,150,97,-1};
			return value;
		}
		private int[] getIndexedFaceSet_5_19_coordIndex_2()
		{
			int[] value = {82,98,151,-1,151,145,82,-1,98,97,150,-1,150,151,98,-1,99,83,146,-1,146,152,99,-1,84,100,153,-1,153,147,84,-1,101,85,148,-1,148,154,101,-1,86,102,155,-1,155,149,86,-1,102,101,154,-1,154,155,102,-1,115,99,152,-1,152,156,115,-1,100,116,157,-1,157,153,100,-1,116,115,156,-1,156,157,116,-1,24,25,159,-1,159,158,24,-1,25,26,160,-1,160,159,25,-1,26,27,161,-1,161,160,26,-1,27,28,162,-1,162,161,27,-1,28,29,163,-1,163,162,28,-1,29,30,164,-1,164,163,29,-1,30,31,165,-1,165,164,30,-1,31,120,166,-1,166,165,31,-1,120,121,167,-1,167,166,120,-1,121,122,168,-1,168,167,121,-1,122,123,169,-1,169,168,122,-1,124,125,171,-1,171,170,124,-1,125,126,172,-1,172,171,125,-1,126,127,173,-1,173,172,126,-1,123,124,170,-1,170,169,123,-1,127,24,158,-1,158,173,127,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_6_19_point_1()
		{
			double[] value = {-645,0,275,-635.6,-1.202e-005,275,-276.4,0,275,-270.6,-1.202e-005,275,270.6,-1.202e-005,275,276.4,0,275,635.6,-1.202e-005,275,645,0,275,-645,0,-275,-635.6,1.202e-005,-275,-276.4,0,-275,-270.6,1.202e-005,-275,270.6,1.202e-005,-275,276.4,0,-275,635.6,1.202e-005,-275.0,645.0,0.0,-275.0,-645.0,575.0,275.0,-635.6,575.0,275.0,-276.4,575.0,275.0,-270.6,575.0,275.0,270.6,575.0,275.0,276.4,575.0,275.0,635.6,575.0,275.0,645.0,575.0,275.0,-645.0,575.0,-275.0,-635.6,575.0,-275.0,-276.4,575.0,-275.0,-270.6,575.0,-275.0,270.6,575.0,-275.0,276.4,575.0,-275.0,635.6,575.0,-275.0,645.0,575.0,-275.0,-645.0,82.14,275.0,-635.6,82.14,275.0,-276.4,82.14,275.0,-270.6,82.14,275.0,270.6,82.14,275.0,276.4,82.14,275.0,635.6,82.14,275.0,645.0,82.14,275.0,645.0,82.14,-275.0,635.6,82.14,-275.0,276.4,82.14,-275.0,270.6,82.14,-275.0,-270.6,82.14,-275.0,-276.4,82.14,-275.0,-635.6,82.14,-275.0,-645.0,82.14,-275.0,-645.0,97.59,275.0,-635.6,97.59,275.0,-276.4,97.59,275.0,-270.6,97.59,275.0,270.6,97.59,275.0,276.4,97.59,275.0,635.6,97.59,275.0,645.0,97.59,275.0,645.0,97.59,-275.0,635.6,97.59,-275.0,276.4,97.59,-275.0,270.6,97.59,-275.0,-270.6,97.59,-275.0,-276.4,97.59,-275.0,-635.6,97.59,-275.0,-645.0,97.59,-275.0,-645.0,246.4,275.0,-635.6,246.4,275.0,-276.4,246.4,275.0,-270.6,246.4,275.0,270.6,246.4,275.0,276.4,246.4,275.0,635.6,246.4,275.0,645.0,246.4,275.0,645.0,246.4,-275.0,635.6,246.4,-275.0,276.4,246.4,-275.0,270.6,246.4,-275.0,-270.6,246.4,-275.0,-276.4,246.4,-275.0,-635.6,246.4,-275.0,-645.0,246.4,-275.0,-645.0,259.8,275.0,-635.6,259.8,275.0,-276.4,259.8,275.0,-270.6,259.8,275.0,270.6,259.8,275.0,276.4,259.8,275.0,635.6,259.8,275.0,645.0,259.8,275.0,645.0,259.8,-275.0,635.6,259.8,-275.0,276.4,259.8,-275.0,270.6,259.8,-275.0,-270.6,259.8,-275.0,-276.4,259.8,-275.0,-635.6,259.8,-275.0,-645.0,259.8,-275.0,-645.0,502.4,275.0,-635.6,502.4,275.0,-276.4,502.4,275.0,-270.6,502.4,275.0};
			return value;
		}
		private double[] getCoordinate_6_19_point_2()
		{
			double[] value = {270.6,502.4,275,276.4,502.4,275,635.6,502.4,275,645,502.4,275,645,502.4,-275,635.6,502.4,-275,276.4,502.4,-275,270.6,502.4,-275,-270.6,502.4,-275,-276.4,502.4,-275,-635.6,502.4,-275,-645,502.4,-275,-645,521.1,275,-635.6,521.1,275,-276.4,521.1,275,-270.6,521.1,275,270.6,521.1,275,276.4,521.1,275,635.6,521.1,275,645,521.1,275,645,521.1,-275,635.6,521.1,-275,276.4,521.1,-275,270.6,521.1,-275,-270.6,521.1,-275,-276.4,521.1,-275,-635.6,521.1,-275,-645,521.1,-275,-270.6,-1.202e-005,-275,270.6,-1.202e-005,-275.0,-270.6,82.14,-275.0,270.6,82.14,-275.0,-635.6,97.59,-275.0,-276.4,97.59,-275.0,-270.6,97.59,-275.0,270.6,97.59,-275.0,276.4,97.59,-275.0,635.6,97.59,-275.0,-635.6,246.4,-275.0,-276.4,246.4,-275.0,-270.6,246.4,-275.0,270.6,246.4,-275.0,276.4,246.4,-275.0,635.6,246.4,-275.0,-635.6,259.8,-275.0,-276.4,259.8,-275.0,-270.6,259.8,-275.0,270.6,259.8,-275.0,276.4,259.8,-275.0,635.6,259.8,-275.0,-635.6,502.4,-275.0,-276.4,502.4,-275.0,-270.6,502.4,-275.0,270.6,502.4,-275.0,276.4,502.4,-275.0,635.6,502.4,-275.0,-270.6,521.1,-275.0,270.6,521.1,-275.0,-645.0,575.0,-305.0,-635.6,575.0,-305.0,-276.4,575.0,-305.0,-270.6,575.0,-305.0,270.6,575.0,-305.0,276.4,575.0,-305.0,635.6,575.0,-305.0,645.0,575.0,-305.0,645.0,521.1,-305.0,635.6,521.1,-305.0,276.4,521.1,-305.0,270.6,521.1,-305.0,-270.6,521.1,-305.0,-276.4,521.1,-305.0,-635.6,521.1,-305.0,-645.0,521.1,-305.0};
			return value;
		}

		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=5, element #19, 1208 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getIndexedFaceSet_5_19_coordIndex()
		{
			MFInt32 IndexedFaceSet_5_19_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getIndexedFaceSet_5_19_coordIndex_1()))
				.append(new MFInt32(getIndexedFaceSet_5_19_coordIndex_2()));
			return IndexedFaceSet_5_19_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=6, element #19, 522 total numbers made up of 174 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_6_19_point()
		{
			MFVec3f Coordinate_6_19_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_6_19_point_1()))
				.append(new MFVec3f(getCoordinate_6_19_point_2()));
			return Coordinate_6_19_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return NoUnitTable model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new NoUnitTable().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Units.NoUnitTable\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Units.NoUnitTable self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Units/NoUnitTable_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Units/NoUnitTable_JavaExport.x3d"; 
                String filenameX3DV = "Units/NoUnitTable_JavaExport.x3dv"; 
                String filenameJSON = "Units/NoUnitTable_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
