####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python UnitBacteria.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    #  unit category="length" conversionFactor="0.000001" name="micro"/ 
    meta(content='UnitBacteria.x3d',name='title'),
    meta(content='Units component example',name='description'),
    meta(content='Myeong Won Lee',name='creator'),
    meta(content='1 August 2009',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='UnitExamples.pdf',name='reference'),
    meta(content='http://www.web3d.kr/mwlee/x3d-3.1-ext.xsd',name='reference'),
    meta(content='https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/core.html#UNITStatement',name='reference'),
    meta(content='X3D UNIT statement',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Units/UnitBacteria.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='UnitBacteria.x3d'),
    Background(groundColor=[(0.05,0.1,0.3)],skyColor=[(0.05,0.1,0.3)]),
    Transform(
      children=[
      Viewpoint(description='Bacteria',position=(0.0,0.0,1.0)),
      Shape(
        appearance=Appearance(
          material=Material(diffuseColor=(0.3412,0.8784,0.3412))),
        geometry=IndexedFaceSet(coordIndex=[0,518,254,-1,254,520,0,-1,2,519,254,-1,254,518,2,-1,1,520,254,-1,254,519,1,-1,0,521,255,-1,255,518,0,-1,3,522,255,-1,255,521,3,-1,2,518,255,-1,255,522,2,-1,0,523,256,-1,256,521,0,-1,4,524,256,-1,256,523,4,-1,3,521,256,-1,256,524,3,-1,0,525,257,-1,257,523,0,-1,5,526,257,-1,257,525,5,-1,4,523,257,-1,257,526,4,-1,0,527,258,-1,258,525,0,-1,6,528,258,-1,258,527,6,-1,5,525,258,-1,258,528,5,-1,0,529,259,-1,259,527,0,-1,7,530,259,-1,259,529,7,-1,6,527,259,-1,259,530,6,-1,0,531,260,-1,260,529,0,-1,8,532,260,-1,260,531,8,-1,7,529,260,-1,260,532,7,-1,0,533,261,-1,261,531,0,-1,9,534,261,-1,261,533,9,-1,8,531,261,-1,261,534,8,-1,0,535,262,-1,262,533,0,-1,10,536,262,-1,262,535,10,-1,9,533,262,-1,262,536,9,-1,0,537,263,-1,263,535,0,-1,11,538,263,-1,263,537,11,-1,10,535,263,-1,263,538,10,-1,0,539,264,-1,264,537,0,-1,12,540,264,-1,264,539,12,-1,11,537,264,-1,264,540,11,-1,0,520,265,-1,265,539,0,-1,1,541,265,-1,265,520,1,-1,12,539,265,-1,265,541,12,-1,1,519,266,-1,266,543,1,-1,2,544,266,-1,266,519,2,-1,14,542,266,-1,266,544,14,-1,13,543,266,-1,266,542,13,-1,2,522,267,-1,267,544,2,-1,3,546,267,-1,267,522,3,-1,15,545,267,-1,267,546,15,-1,14,544,267,-1,267,545,14,-1,3,524,268,-1,268,546,3,-1,4,548,268,-1,268,524,4,-1,16,547,268,-1,268,548,16,-1,15,546,268,-1,268,547,15,-1,4,526,269,-1,269,548,4,-1,5,550,269,-1,269,526,5,-1,17,549,269,-1,269,550,17,-1,16,548,269,-1,269,549,16,-1,5,528,270,-1,270,550,5,-1,6,552,270,-1,270,528,6,-1,18,551,270,-1,270,552,18,-1,17,550,270,-1,270,551,17,-1,6,530,271,-1,271,552,6,-1,7,554,271,-1,271,530,7,-1,19,553,271,-1,271,554,19,-1,18,552,271,-1,271,553,18,-1,7,532,272,-1,272,554,7,-1,8,556,272,-1,272,532,8,-1,20,555,272,-1,272,556,20,-1,19,554,272,-1,272,555,19,-1,8,534,273,-1,273,556,8,-1,9,558,273,-1,273,534,9,-1,21,557,273,-1,273,558,21,-1,20,556,273,-1,273,557,20,-1,9,536,274,-1,274,558,9,-1,10,560,274,-1,274,536,10,-1,22,559,274,-1,274,560,22,-1,21,558,274,-1,274,559,21,-1,10,538,275,-1,275,560,10,-1,11,562,275,-1,275,538,11,-1,23,561,275,-1,275,562,23,-1,22,560,275,-1,275,561,22,-1,11,540,276,-1,276,562,11,-1,12,564,276,-1,276,540,12,-1,24,563,276,-1,276,564,24,-1,23,562,276,-1,276,563,23,-1,12,541,277,-1,277,564,12,-1,1,543,277,-1,277,541,1,-1,13,565,277,-1,277,543,13,-1,24,564,277,-1,277,565,24,-1,13,542,278,-1,278,567,13,-1,14,568,278,-1,278,542,14,-1,26,566,278,-1,278,568,26,-1,25,567,278,-1,278,566,25,-1,14,545,279,-1,279,568,14,-1,15,570,279,-1,279,545,15,-1,27,569,279,-1,279,570,27,-1,26,568,279,-1,279,569,26,-1,15,547,280,-1,280,570,15,-1,16,572,280,-1,280,547,16,-1,28,571,280,-1,280,572,28,-1,27,570,280,-1,280,571,27,-1,16,549,281,-1,281,572,16,-1,17,574,281,-1,281,549,17,-1,29,573,281,-1,281,574,29,-1,28,572,281,-1,281,573,28,-1,17,551,282,-1,282,574,17,-1,18,576,282,-1,282,551,18,-1,30,575,282,-1,282,576,30,-1,29,574,282,-1,282,575,29,-1,18,553,283,-1,283,576,18,-1,19,578,283,-1,283,553,19,-1,31,577,283,-1,283,578,31,-1,30,576,283,-1,283,577,30,-1,19,555,284,-1,284,578,19,-1,20,580,284,-1,284,555,20,-1,32,579,284,-1,284,580,32,-1,31,578,284,-1,284,579,31,-1,20,557,285,-1,285,580,20,-1,21,582,285,-1,285,557,21,-1,33,581,285,-1,285,582,33,-1,32,580,285,-1,285,581,32,-1,21,559,286,-1,286,582,21,-1,22,584,286,-1,286,559,22,-1,34,583,286,-1,286,584,34,-1,33,582,286,-1,286,583,33,-1,22,561,287,-1,287,584,22,-1,23,586,287,-1,287,561,23,-1,35,585,287,-1,287,586,35,-1,34,584,287,-1,287,585,34,-1,23,563,288,-1,288,586,23,-1,24,588,288,-1,288,563,24,-1,36,587,288,-1,288,588,36,-1,35,586,288,-1,288,587,35,-1,24,565,289,-1,289,588,24,-1,13,567,289,-1,289,565,13,-1,25,589,289,-1,289,567,25,-1,36,588,289,-1,289,589,36,-1,25,566,290,-1,290,591,25,-1,26,592,290,-1,290,566,26,-1,38,590,290,-1,290,592,38,-1,37,591,290,-1,290,590,37,-1,26,569,291,-1,291,592,26,-1,27,594,291,-1,291,569,27,-1,39,593,291,-1,291,594,39,-1,38,592,291,-1,291,593,38,-1,27,571,292,-1,292,594,27,-1,28,596,292,-1,292,571,28,-1,40,595,292,-1,292,596,40,-1,39,594,292,-1,292,595,39,-1,28,573,293,-1,293,596,28,-1,29,598,293,-1,293,573,29,-1,41,597,293,-1,293,598,41,-1,40,596,293,-1,293,597,40,-1,29,575,294,-1,294,598,29,-1,30,600,294,-1,294,575,30,-1,42,599,294,-1,294,600,42,-1,41,598,294,-1,294,599,41,-1,30,577,295,-1,295,600,30,-1,31,602,295,-1,295,577,31,-1,43,601,295,-1,295,602,43,-1,42,600,295,-1,295,601,42,-1,31,579,296,-1,296,602,31,-1,32,604,296,-1,296,579,32,-1,44,603,296,-1,296,604,44,-1,43,602,296,-1,296,603,43,-1,32,581,297,-1,297,604,32,-1,33,606,297,-1,297,581,33,-1,45,605,297,-1,297,606,45,-1,44,604,297,-1,297,605,44,-1,33,583,298,-1,298,606,33,-1,34,608,298,-1,298,583,34,-1,46,607,298,-1,298,608,46,-1,45,606,298,-1,298,607,45,-1,34,585,299,-1,299,608,34,-1,35,610,299,-1,299,585,35,-1,47,609,299,-1,299,610,47,-1,46,608,299,-1,299,609,46,-1,35,587,300,-1,300,610,35,-1,36,612,300,-1,300,587,36,-1,48,611,300,-1,300,612,48,-1,47,610,300,-1,300,611,47,-1,36,589,301,-1,301,612,36,-1,25,591,301,-1,301,589,25,-1,37,613,301,-1,301,591,37,-1,48,612,301,-1,301,613,48,-1,37,590,302,-1,302,615,37,-1,38,616,302,-1,302,590,38,-1,50,614,302,-1,302,616,50,-1,49,615,302,-1,302,614,49,-1,38,593,303,-1,303,616,38,-1,39,618,303,-1,303,593,39,-1,51,617,303,-1,303,618,51,-1,50,616,303,-1,303,617,50,-1,39,595,304,-1,304,618,39,-1,40,620,304,-1,304,595,40,-1,52,619,304,-1,304,620,52,-1,51,618,304,-1,304,619,51,-1,40,597,305,-1,305,620,40,-1,41,622,305,-1,305,597,41,-1,53,621,305,-1,305,622,53,-1,52,620,305,-1,305,621,52,-1,41,599,306,-1,306,622,41,-1,42,624,306,-1,306,599,42,-1,54,623,306,-1,306,624,54,-1,53,622,306,-1,306,623,53,-1,42,601,307,-1,307,624,42,-1,43,626,307,-1,307,601,43,-1,55,625,307,-1,307,626,55,-1,54,624,307,-1,307,625,54,-1,43,603,308,-1,308,626,43,-1,44,628,308,-1,308,603,44,-1,56,627,308,-1,308,628,56,-1,55,626,308,-1,308,627,55,-1,44,605,309,-1,309,628,44,-1,45,630,309,-1,309,605,45,-1,57,629,309,-1,309,630,57,-1,56,628,309,-1,309,629,56,-1,45,607,310,-1,310,630,45,-1,46,632,310,-1,310,607,46,-1,58,631,310,-1,310,632,58,-1,57,630,310,-1,310,631,57,-1,46,609,311,-1,311,632,46,-1,47,634,311,-1,311,609,47,-1,59,633,311,-1,311,634,59,-1,58,632,311,-1,311,633,58,-1,47,611,312,-1,312,634,47,-1,48,636,312,-1,312,611,48,-1,60,635,312,-1,312,636,60,-1,59,634,312,-1,312,635,59,-1,48,613,313,-1,313,636,48,-1,37,615,313,-1,313,613,37,-1,49,637,313,-1,313,615,49,-1,60,636,313,-1,313,637,60,-1,49,614,314,-1,314,639,49,-1,50,640,314,-1,314,614,50,-1,62,638,314,-1,314,640,62,-1,61,639,314,-1,314,638,61,-1,50,617,315,-1,315,640,50,-1,51,642,315,-1,315,617,51,-1,63,641,315,-1,315,642,63,-1,62,640,315,-1,315,641,62,-1,51,619,316,-1,316,642,51,-1,52,644,316,-1,316,619,52,-1,64,643,316,-1,316,644,64,-1,63,642,316,-1,316,643,63,-1,52,621,317,-1,317,644,52,-1,53,646,317,-1,317,621,53,-1,65,645,317,-1,317,646,65,-1,64,644,317,-1,317,645,64,-1,53,623,318,-1,318,646,53,-1,54,648,318,-1,318,623,54,-1,66,647,318,-1,318,648,66,-1,65,646,318,-1,318,647,65,-1,54,625,319,-1,319,648,54,-1,55,650,319,-1,319,625,55,-1,67,649,319,-1,319,650,67,-1,66,648,319,-1,319,649,66,-1,55,627,320,-1,320,650,55,-1,56,652,320,-1,320,627,56,-1,68,651,320,-1,320,652,68,-1,67,650,320,-1,320,651,67,-1,56,629,321,-1,321,652,56,-1,57,654,321,-1,321,629,57,-1,69,653,321,-1,321,654,69,-1,68,652,321,-1,321,653,68,-1,57,631,322,-1,322,654,57,-1,58,656,322,-1,322,631,58,-1,70,655,322,-1,322,656,70,-1,69,654,322,-1,322,655,69,-1,58,633,323,-1,323,656,58,-1,59,658,323,-1,323,633,59,-1,71,657,323,-1,323,658,71,-1,70,656,323,-1,323,657,70,-1,59,635,324,-1,324,658,59,-1,60,660,324,-1,324,635,60,-1,72,659,324,-1,324,660,72,-1,71,658,324,-1,324,659,71,-1,60,637,325,-1,325,660,60,-1,49,639,325,-1,325,637,49,-1,61,661,325,-1,325,639,61,-1,72,660,325,-1,325,661,72,-1,61,638,326,-1,326,663,61,-1,62,664,326,-1,326,638,62,-1,74,662,326,-1,326,664,74,-1,73,663,326,-1,326,662,73,-1,62,641,327,-1,327,664,62,-1,63,666,327,-1,327,641,63,-1,75,665,327,-1,327,666,75,-1,74,664,327,-1,327,665,74,-1,63,643,328,-1,328,666,63,-1,64,668,328,-1,328,643,64,-1,76,667,328,-1,328,668,76,-1,75,666,328,-1,328,667,75,-1,64,645,329,-1,329,668,64,-1,65,670,329,-1,329,645,65,-1,77,669,329,-1,329,670,77,-1,76,668,329,-1,329,669,76,-1,65,647,330,-1,330,670,65,-1,66,672,330,-1,330,647,66,-1,78,671,330,-1,330,672,78,-1,77,670,330,-1,330,671,77,-1,66,649,331,-1,331,672,66,-1,67,674,331,-1,331,649,67,-1,79,673,331,-1,331,674,79,-1,78,672,331,-1,331,673,78,-1,67,651,332,-1,332,674,67,-1,68,676,332,-1,332,651,68,-1,80,675,332,-1,332,676,80,-1,79,674,332,-1,332,675,79,-1,68,653,333,-1,333,676,68,-1,69,678,333,-1,333,653,69,-1,81,677,333,-1,333,678,81,-1,80,676,333,-1,333,677,80,-1,69,655,334,-1,334,678,69,-1,70,680,334,-1,334,655,70,-1,82,679,334,-1,334,680,82,-1,81,678,334,-1,334,679,81,-1,70,657,335,-1,335,680,70,-1,71,682,335,-1,335,657,71,-1,83,681,335,-1,335,682,83,-1,82,680,335,-1,335,681,82,-1,71,659,336,-1,336,682,71,-1,72,684,336,-1,336,659,72,-1,84,683,336,-1,336,684,84,-1,83,682,336,-1,336,683,83,-1,72,661,337,-1,337,684,72,-1,61,663,337,-1,337,661,61,-1,73,685,337,-1,337,663,73,-1,84,684,337,-1,337,685,84,-1,73,662,338,-1,338,687,73,-1,74,688,338,-1,338,662,74,-1,86,686,338,-1,338,688,86,-1,85,687,338,-1,338,686,85,-1,74,665,339,-1,339,688,74,-1,75,690,339,-1,339,665,75,-1,87,689,339,-1,339,690,87,-1,86,688,339,-1,339,689,86,-1,75,667,340,-1,340,690,75,-1,76,692,340,-1,340,667,76,-1,88,691,340,-1,340,692,88,-1,87,690,340,-1,340,691,87,-1,76,669,341,-1,341,692,76,-1,77,694,341,-1,341,669,77,-1,89,693,341,-1,341,694,89,-1,88,692,341,-1,341,693,88,-1,77,671,342,-1,342,694,77,-1,78,696,342,-1,342,671,78,-1,90,695,342,-1,342,696,90,-1,89,694,342,-1,342,695,89,-1,78,673,343,-1,343,696,78,-1,79,698,343,-1,343,673,79,-1,91,697,343,-1,343,698,91,-1,90,696,343,-1,343,697,90,-1,79,675,344,-1,344,698,79,-1,80,700,344,-1,344,675,80,-1,92,699,344,-1,344,700,92,-1,91,698,344,-1,344,699,91,-1,80,677,345,-1,345,700,80,-1,81,702,345,-1,345,677,81,-1,93,701,345,-1,345,702,93,-1,92,700,345,-1,345,701,92,-1,81,679,346,-1,346,702,81,-1,82,704,346,-1,346,679,82,-1,94,703,346,-1,346,704,94,-1,93,702,346,-1,346,703,93,-1,82,681,347,-1,347,704,82,-1,83,706,347,-1,347,681,83,-1,95,705,347,-1,347,706,95,-1,94,704,347,-1,347,705,94,-1,83,683,348,-1,348,706,83,-1,84,708,348,-1,348,683,84,-1,96,707,348,-1,348,708,96,-1,95,706,348,-1,348,707,95,-1,84,685,349,-1,349,708,84,-1,73,687,349,-1,349,685,73,-1,85,709,349,-1,349,687,85,-1,96,708,349,-1,349,709,96,-1,85,686,350,-1,350,711,85,-1,86,712,350,-1,350,686,86,-1,98,710,350,-1,350,712,98,-1,97,711,350,-1,350,710,97,-1,86,689,351,-1,351,712,86,-1,87,714,351,-1,351,689,87,-1,99,713,351,-1,351,714,99,-1,98,712,351,-1,351,713,98,-1,87,691,352,-1,352,714,87,-1,88,716,352,-1,352,691,88,-1,100,715,352,-1,352,716,100,-1,99,714,352,-1,352,715,99,-1,88,693,353,-1,353,716,88,-1,89,718,353,-1,353,693,89,-1,101,717,353,-1,353,718,101,-1,100,716,353,-1,353,717,100,-1,89,695,354,-1,354,718,89,-1,90,720,354,-1,354,695,90,-1,102,719,354,-1,354,720,102,-1,101,718,354,-1,354,719,101,-1,90,697,355,-1,355,720,90,-1,91,722,355,-1,355,697,91,-1,103,721,355,-1,355,722,103,-1,102,720,355,-1,355,721,102,-1,91,699,356,-1,356,722,91,-1,92,724,356,-1,356,699,92,-1,104,723,356,-1,356,724,104,-1,103,722,356,-1,356,723,103,-1,92,701,357,-1,357,724,92,-1,93,726,357,-1,357,701,93,-1,105,725,357,-1,357,726,105,-1,104,724,357,-1,357,725,104,-1,93,703,358,-1,358,726,93,-1,94,728,358,-1,358,703,94,-1,106,727,358,-1,358,728,106,-1,105,726,358,-1,358,727,105,-1,94,705,359,-1,359,728,94,-1,95,730,359,-1,359,705,95,-1,107,729,359,-1,359,730,107,-1,106,728,359,-1,359,729,106,-1,95,707,360,-1,360,730,95,-1,96,732,360,-1,360,707,96,-1,108,731,360,-1,360,732,108,-1,107,730,360,-1,360,731,107,-1,96,709,361,-1,361,732,96,-1,85,711,361,-1,361,709,85,-1,97,733,361,-1,361,711,97,-1,108,732,361,-1,361,733,108,-1,97,710,362,-1,362,735,97,-1,98,736,362,-1,362,710,98,-1,110,734,362,-1,362,736,110,-1,109,735,362,-1,362,734,109,-1,98,713,363,-1,363,736,98,-1,99,738,363,-1,363,713,99,-1,111,737,363,-1,363,738,111,-1,110,736,363,-1,363,737,110,-1,99,715,364,-1,364,738,99,-1,100,740,364,-1,364,715,100,-1,112,739,364,-1,364,740,112,-1,111,738,364,-1,364,739,111,-1,100,717,365,-1,365,740,100,-1,101,742,365,-1,365,717,101,-1,113,741,365,-1,365,742,113,-1,112,740,365,-1,365,741,112,-1,101,719,366,-1,366,742,101,-1,102,744,366,-1,366,719,102,-1,114,743,366,-1,366,744,114,-1,113,742,366,-1,366,743,113,-1,102,721,367,-1,367,744,102,-1,103,746,367,-1,367,721,103,-1,115,745,367,-1,367,746,115,-1,114,744,367,-1,367,745,114,-1,103,723,368,-1,368,746,103,-1,104,748,368,-1,368,723,104,-1,116,747,368,-1,368,748,116,-1,115,746,368,-1,368,747,115,-1,104,725,369,-1,369,748,104,-1,105,750,369,-1,369,725,105,-1,117,749,369,-1,369,750,117,-1,116,748,369,-1,369,749,116,-1,105,727,370,-1,370,750,105,-1,106,752,370,-1,370,727,106,-1,118,751,370,-1,370,752,118,-1,117,750,370,-1,370,751,117,-1,106,729,371,-1,371,752,106,-1,107,754,371,-1,371,729,107,-1,119,753,371,-1,371,754,119,-1,118,752,371,-1,371,753,118,-1,107,731,372,-1,372,754,107,-1,108,756,372,-1,372,731,108,-1,120,755,372,-1,372,756,120,-1,119,754,372,-1,372,755,119,-1,108,733,373,-1,373,756,108,-1,97,735,373,-1,373,733,97,-1,109,757,373,-1,373,735,109,-1,120,756,373,-1,373,757,120,-1,109,734,374,-1,374,759,109,-1,110,760,374,-1,374,734,110,-1,122,758,374,-1,374,760,122,-1,121,759,374,-1,374,758,121,-1,110,737,375,-1,375,760,110,-1,111,762,375,-1,375,737,111,-1,123,761,375,-1,375,762,123,-1,122,760,375,-1,375,761,122,-1,111,739,376,-1,376,762,111,-1,112,764,376,-1,376,739,112,-1,124,763,376,-1,376,764,124,-1,123,762,376,-1,376,763,123,-1,112,741,377,-1,377,764,112,-1,113,766,377,-1,377,741,113,-1,125,765,377,-1,377,766,125,-1,124,764,377,-1,377,765,124,-1,113,743,378,-1,378,766,113,-1,114,768,378,-1,378,743,114,-1,126,767,378,-1,378,768,126,-1,125,766,378,-1,378,767,125,-1,114,745,379,-1,379,768,114,-1,115,770,379,-1,379,745,115,-1,127,769,379,-1,379,770,127,-1,126,768,379,-1,379,769,126,-1,115,747,380,-1,380,770,115,-1,116,772,380,-1,380,747,116,-1,128,771,380,-1,380,772,128,-1,127,770,380,-1,380,771,127,-1,116,749,381,-1,381,772,116,-1,117,774,381,-1,381,749,117,-1,129,773,381,-1,381,774,129,-1,128,772,381,-1,381,773,128,-1,117,751,382,-1,382,774,117,-1,118,776,382,-1,382,751,118,-1,130,775,382,-1,382,776,130,-1,129,774,382,-1,382,775,129,-1,118,753,383,-1,383,776,118,-1,119,778,383,-1,383,753,119,-1,131,777,383,-1,383,778,131,-1,130,776,383,-1,383,777,130,-1,119,755,384,-1,384,778,119,-1,120,780,384,-1,384,755,120,-1,132,779,384,-1,384,780,132,-1,131,778,384,-1,384,779,131,-1,120,757,385,-1,385,780,120,-1,109,759,385,-1,385,757,109,-1,121,781,385,-1,385,759,121,-1,132,780,385,-1,385,781,132,-1,121,758,386,-1,386,783,121,-1,122,784,386,-1,386,758,122,-1,134,782,386,-1,386,784,134,-1,133,783,386,-1,386,782,133,-1,122,761,387,-1,387,784,122,-1,123,786,387,-1,387,761,123,-1,135,785,387,-1,387,786,135,-1,134,784,387,-1,387,785,134,-1,123,763,388,-1,388,786,123,-1,124,788,388,-1,388,763,124,-1,136,787,388,-1,388,788,136,-1,135,786,388,-1,388,787,135,-1,124,765,389,-1,389,788,124,-1,125,790,389,-1,389,765,125,-1,137,789,389,-1,389,790,137,-1,136,788,389,-1,389,789,136,-1,125,767,390,-1,390,790,125,-1,126,792,390,-1,390,767,126,-1,138,791,390,-1,390,792,138,-1,137,790,390,-1,390,791,137,-1,126,769,391,-1,391,792,126,-1,127,794,391,-1,391,769,127,-1,139,793,391,-1,391,794,139,-1,138,792,391,-1,391,793,138,-1,127,771,392,-1,392,794,127,-1,128,796,392,-1,392,771,128,-1,140,795,392,-1,392,796,140,-1,139,794,392,-1,392,795,139,-1,128,773,393,-1,393,796,128,-1,129,798,393,-1,393,773,129,-1,141,797,393,-1,393,798,141,-1,140,796,393,-1,393,797,140,-1,129,775,394,-1,394,798,129,-1,130,800,394,-1,394,775,130,-1,142,799,394,-1,394,800,142,-1,141,798,394,-1,394,799,141,-1,130,777,395,-1,395,800,130,-1,131,802,395,-1,395,777,131,-1,143,801,395,-1,395,802,143,-1,142,800,395,-1,395,801,142,-1,131,779,396,-1,396,802,131,-1,132,804,396,-1,396,779,132,-1,144,803,396,-1,396,804,144,-1,143,802,396,-1,396,803,143,-1,132,781,397,-1,397,804,132,-1,121,783,397,-1,397,781,121,-1,133,805,397,-1,397,783,133,-1,144,804,397,-1,397,805,144,-1,133,782,398,-1,398,807,133,-1,134,808,398,-1,398,782,134,-1,146,806,398,-1,398,808,146,-1,145,807,398,-1,398,806,145,-1,134,785,399,-1,399,808,134,-1,135,810,399,-1,399,785,135,-1,147,809,399,-1,399,810,147,-1,146,808,399,-1,399,809,146,-1,135,787,400,-1,400,810,135,-1,136,812,400,-1,400,787,136,-1,148,811,400,-1,400,812,148,-1,147,810,400,-1,400,811,147,-1,136,789,401,-1,401,812,136,-1,137,814,401,-1,401,789,137,-1,149,813,401,-1,401,814,149,-1,148,812,401,-1,401,813,148,-1,137,791,402,-1,402,814,137,-1,138,816,402,-1,402,791,138,-1,150,815,402,-1,402,816,150,-1,149,814,402,-1,402,815,149,-1,138,793,403,-1,403,816,138,-1,139,818,403,-1,403,793,139,-1,151,817,403,-1,403,818,151,-1,150,816,403,-1,403,817,150,-1,139,795,404,-1,404,818,139,-1,140,820,404,-1,404,795,140,-1,152,819,404,-1,404,820,152,-1,151,818,404,-1,404,819,151,-1,140,797,405,-1,405,820,140,-1,141,822,405,-1,405,797,141,-1,153,821,405,-1,405,822,153,-1,152,820,405,-1,405,821,152,-1,141,799,406,-1,406,822,141,-1,142,824,406,-1,406,799,142,-1,154,823,406,-1,406,824,154,-1,153,822,406,-1,406,823,153,-1,142,801,407,-1,407,824,142,-1,143,826,407,-1,407,801,143,-1,155,825,407,-1,407,826,155,-1,154,824,407,-1,407,825,154,-1,143,803,408,-1,408,826,143,-1,144,828,408,-1,408,803,144,-1,156,827,408,-1,408,828,156,-1,155,826,408,-1,408,827,155,-1,144,805,409,-1,409,828,144,-1,133,807,409,-1,409,805,133,-1,145,829,409,-1,409,807,145,-1,156,828,409,-1,409,829,156,-1,145,806,410,-1,410,831,145,-1,146,832,410,-1,410,806,146,-1,158,830,410,-1,410,832,158,-1,157,831,410,-1,410,830,157,-1,146,809,411,-1,411,832,146,-1,147,834,411,-1,411,809,147,-1,159,833,411,-1,411,834,159,-1,158,832,411,-1,411,833,158,-1,147,811,412,-1,412,834,147,-1,148,836,412,-1,412,811,148,-1,160,835,412,-1,412,836,160,-1,159,834,412,-1,412,835,159,-1,148,813,413,-1,413,836,148,-1,149,838,413,-1,413,813,149,-1,161,837,413,-1,413,838,161,-1,160,836,413,-1,413,837,160,-1,149,815,414,-1,414,838,149,-1,150,840,414,-1,414,815,150,-1,162,839,414,-1,414,840,162,-1,161,838,414,-1,414,839,161,-1,150,817,415,-1,415,840,150,-1,151,842,415,-1,415,817,151,-1,163,841,415,-1,415,842,163,-1,162,840,415,-1,415,841,162,-1,151,819,416,-1,416,842,151,-1,152,844,416,-1,416,819,152,-1,164,843,416,-1,416,844,164,-1,163,842,416,-1,416,843,163,-1,152,821,417,-1,417,844,152,-1,153,846,417,-1,417,821,153,-1,165,845,417,-1,417,846,165,-1,164,844,417,-1,417,845,164,-1,153,823,418,-1,418,846,153,-1,154,848,418,-1,418,823,154,-1,166,847,418,-1,418,848,166,-1,165,846,418,-1,418,847,165,-1,154,825,419,-1,419,848,154,-1,155,850,419,-1,419,825,155,-1,167,849,419,-1,419,850,167,-1,166,848,419,-1,419,849,166,-1,155,827,420,-1,420,850,155,-1,156,852,420,-1,420,827,156,-1,168,851,420,-1,420,852,168,-1,167,850,420,-1,420,851,167,-1,156,829,421,-1,421,852,156,-1,145,831,421,-1,421,829,145,-1,157,853,421,-1,421,831,157,-1,168,852,421,-1,421,853,168,-1,157,830,422,-1,422,855,157,-1,158,856,422,-1,422,830,158,-1,170,854,422,-1,422,856,170,-1,169,855,422,-1,422,854,169,-1,158,833,423,-1,423,856,158,-1,159,858,423,-1,423,833,159,-1,171,857,423,-1,423,858,171,-1,170,856,423,-1,423,857,170,-1,159,835,424,-1,424,858,159,-1,160,860,424,-1,424,835,160,-1,172,859,424,-1,424,860,172,-1,171,858,424,-1,424,859,171,-1,160,837,425,-1,425,860,160,-1,161,862,425,-1,425,837,161,-1,173,861,425,-1,425,862,173,-1,172,860,425,-1,425,861,172,-1,161,839,426,-1,426,862,161,-1,162,864,426,-1,426,839,162,-1,174,863,426,-1,426,864,174,-1,173,862,426,-1,426,863,173,-1,162,841,427,-1,427,864,162,-1,163,866,427,-1,427,841,163,-1,175,865,427,-1,427,866,175,-1,174,864,427,-1,427,865,174,-1,163,843,428,-1,428,866,163,-1,164,868,428,-1,428,843,164,-1,176,867,428,-1,428,868,176,-1,175,866,428,-1,428,867,175,-1,164,845,429,-1,429,868,164,-1,165,870,429,-1,429,845,165,-1,177,869,429,-1,429,870,177,-1,176,868,429,-1,429,869,176,-1,165,847,430,-1,430,870,165,-1,166,872,430,-1,430,847,166,-1,178,871,430,-1,430,872,178,-1,177,870,430,-1,430,871,177,-1,166,849,431,-1,431,872,166,-1,167,874,431,-1,431,849,167,-1,179,873,431,-1,431,874,179,-1,178,872,431,-1,431,873,178,-1,167,851,432,-1,432,874,167,-1,168,876,432,-1,432,851,168,-1,180,875,432,-1,432,876,180,-1,179,874,432,-1,432,875,179,-1,168,853,433,-1,433,876,168,-1,157,855,433,-1,433,853,157,-1,169,877,433,-1,433,855,169,-1,180,876,433,-1,433,877,180,-1,169,854,434,-1,434,879,169,-1,170,880,434,-1,434,854,170,-1,182,878,434,-1,434,880,182,-1,181,879,434,-1,434,878,181,-1,170,857,435,-1,435,880,170,-1,171,882,435,-1,435,857,171,-1,183,881,435,-1,435,882,183,-1,182,880,435,-1,435,881,182,-1,171,859,436,-1,436,882,171,-1,172,884,436,-1,436,859,172,-1,184,883,436,-1,436,884,184,-1,183,882,436,-1,436,883,183,-1,172,861,437,-1,437,884,172,-1,173,886,437,-1,437,861,173,-1,185,885,437,-1,437,886,185,-1,184,884,437,-1,437,885,184,-1,173,863,438,-1,438,886,173,-1,174,888,438,-1,438,863,174,-1,186,887,438,-1,438,888,186,-1,185,886,438,-1,438,887,185,-1,174,865,439,-1,439,888,174,-1,175,890,439,-1,439,865,175,-1,187,889,439,-1,439,890,187,-1,186,888,439,-1,439,889,186,-1,175,867,440,-1,440,890,175,-1,176,892,440,-1,440,867,176,-1,188,891,440,-1,440,892,188,-1,187,890,440,-1,440,891,187,-1,176,869,441,-1,441,892,176,-1,177,894,441,-1,441,869,177,-1,189,893,441,-1,441,894,189,-1,188,892,441,-1,441,893,188,-1,177,871,442,-1,442,894,177,-1,178,896,442,-1,442,871,178,-1,190,895,442,-1,442,896,190,-1,189,894,442,-1,442,895,189,-1,178,873,443,-1,443,896,178,-1,179,898,443,-1,443,873,179,-1,191,897,443,-1,443,898,191,-1,190,896,443,-1,443,897,190,-1,179,875,444,-1,444,898,179,-1,180,900,444,-1,444,875,180,-1,192,899,444,-1,444,900,192,-1,191,898,444,-1,444,899,191,-1,180,877,445,-1,445,900,180,-1,169,879,445,-1,445,877,169,-1,181,901,445,-1,445,879,181,-1,192,900,445,-1,445,901,192,-1,181,878,446,-1,446,903,181,-1,182,904,446,-1,446,878,182,-1,194,902,446,-1,446,904,194,-1,193,903,446,-1,446,902,193,-1,182,881,447,-1,447,904,182,-1,183,906,447,-1,447,881,183,-1,195,905,447,-1,447,906,195,-1,194,904,447,-1,447,905,194,-1,183,883,448,-1,448,906,183,-1,184,908,448,-1,448,883,184,-1,196,907,448,-1,448,908,196,-1,195,906,448,-1,448,907,195,-1,184,885,449,-1,449,908,184,-1,185,910,449,-1,449,885,185,-1,197,909,449,-1,449,910,197,-1,196,908,449,-1,449,909,196,-1,185,887,450,-1,450,910,185,-1,186,912,450,-1,450,887,186,-1,198,911,450,-1,450,912,198,-1,197,910,450,-1,450,911,197,-1,186,889,451,-1,451,912,186,-1,187,914,451,-1,451,889,187,-1,199,913,451,-1,451,914,199,-1,198,912,451,-1,451,913,198,-1,187,891,452,-1,452,914,187,-1,188,916,452,-1,452,891,188,-1,200,915,452,-1,452,916,200,-1,199,914,452,-1,452,915,199,-1,188,893,453,-1,453,916,188,-1,189,918,453,-1,453,893,189,-1,201,917,453,-1,453,918,201,-1,200,916,453,-1,453,917,200,-1,189,895,454,-1,454,918,189,-1,190,920,454,-1,454,895,190,-1,202,919,454,-1,454,920,202,-1,201,918,454,-1,454,919,201,-1,190,897,455,-1,455,920,190,-1,191,922,455,-1,455,897,191,-1,203,921,455,-1,455,922,203,-1,202,920,455,-1,455,921,202,-1,191,899,456,-1,456,922,191,-1,192,924,456,-1,456,899,192,-1,204,923,456,-1,456,924,204,-1,203,922,456,-1,456,923,203,-1,192,901,457,-1,457,924,192,-1,181,903,457,-1,457,901,181,-1,193,925,457,-1,457,903,193,-1,204,924,457,-1,457,925,204,-1,193,902,458,-1,458,927,193,-1,194,928,458,-1,458,902,194,-1,206,926,458,-1,458,928,206,-1,205,927,458,-1,458,926,205,-1,194,905,459,-1,459,928,194,-1,195,930,459,-1,459,905,195,-1,207,929,459,-1,459,930,207,-1,206,928,459,-1,459,929,206,-1,195,907,460,-1,460,930,195,-1,196,932,460,-1,460,907,196,-1,208,931,460,-1,460,932,208,-1,207,930,460,-1,460,931,207,-1,196,909,461,-1,461,932,196,-1,197,934,461,-1,461,909,197,-1,209,933,461,-1,461,934,209,-1,208,932,461,-1,461,933,208,-1,197,911,462,-1,462,934,197,-1,198,936,462,-1,462,911,198,-1,210,935,462,-1,462,936,210,-1,209,934,462,-1,462,935,209,-1,198,913,463,-1,463,936,198,-1,199,938,463,-1,463,913,199,-1,211,937,463,-1,463,938,211,-1,210,936,463,-1,463,937,210,-1,199,915,464,-1,464,938,199,-1,200,940,464,-1,464,915,200,-1,212,939,464,-1,464,940,212,-1,211,938,464,-1,464,939,211,-1,200,917,465,-1,465,940,200,-1,201,942,465,-1,465,917,201,-1,213,941,465,-1,465,942,213,-1,212,940,465,-1,465,941,212,-1,201,919,466,-1,466,942,201,-1,202,944,466,-1,466,919,202,-1,214,943,466,-1,466,944,214,-1,213,942,466,-1,466,943,213,-1,202,921,467,-1,467,944,202,-1,203,946,467,-1,467,921,203,-1,215,945,467,-1,467,946,215,-1,214,944,467,-1,467,945,214,-1,203,923,468,-1,468,946,203,-1,204,948,468,-1,468,923,204,-1,216,947,468,-1,468,948,216,-1,215,946,468,-1,468,947,215,-1,204,925,469,-1,469,948,204,-1,193,927,469,-1,469,925,193,-1,205,949,469,-1,469,927,205,-1,216,948,469,-1,469,949,216,-1,205,926,470,-1,470,951,205,-1,206,952,470,-1,470,926,206,-1,218,950,470,-1,470,952,218,-1,217,951,470,-1,470,950,217,-1,206,929,471,-1,471,952,206,-1,207,954,471,-1,471,929,207,-1,219,953,471,-1,471,954,219,-1,218,952,471,-1,471,953,218,-1,207,931,472,-1,472,954,207,-1,208,956,472,-1,472,931,208,-1,220,955,472,-1,472,956,220,-1,219,954,472,-1,472,955,219,-1,208,933,473,-1,473,956,208,-1,209,958,473,-1,473,933,209,-1,221,957,473,-1,473,958,221,-1,220,956,473,-1,473,957,220,-1,209,935,474,-1,474,958,209,-1,210,960,474,-1,474,935,210,-1,222,959,474,-1,474,960,222,-1,221,958,474,-1,474,959,221,-1,210,937,475,-1,475,960,210,-1,211,962,475,-1,475,937,211,-1,223,961,475,-1,475,962,223,-1,222,960,475,-1,475,961,222,-1,211,939,476,-1,476,962,211,-1,212,964,476,-1,476,939,212,-1,224,963,476,-1,476,964,224,-1,223,962,476,-1,476,963,223,-1,212,941,477,-1,477,964,212,-1,213,966,477,-1,477,941,213,-1,225,965,477,-1,477,966,225,-1,224,964,477,-1,477,965,224,-1,213,943,478,-1,478,966,213,-1,214,968,478,-1,478,943,214,-1,226,967,478,-1,478,968,226,-1,225,966,478,-1,478,967,225,-1,214,945,479,-1,479,968,214,-1,215,970,479,-1,479,945,215,-1,227,969,479,-1,479,970,227,-1,226,968,479,-1,479,969,226,-1,215,947,480,-1,480,970,215,-1,216,972,480,-1,480,947,216,-1,228,971,480,-1,480,972,228,-1,227,970,480,-1,480,971,227,-1,216,949,481,-1,481,972,216,-1,205,951,481,-1,481,949,205,-1,217,973,481,-1,481,951,217,-1,228,972,481,-1,481,973,228,-1,217,950,482,-1,482,975,217,-1,218,976,482,-1,482,950,218,-1,230,974,482,-1,482,976,230,-1,229,975,482,-1,482,974,229,-1,218,953,483,-1,483,976,218,-1,219,978,483,-1,483,953,219,-1,231,977,483,-1,483,978,231,-1,230,976,483,-1,483,977,230,-1,219,955,484,-1,484,978,219,-1,220,980,484,-1,484,955,220,-1,232,979,484,-1,484,980,232,-1,231,978,484,-1,484,979,231,-1,220,957,485,-1,485,980,220,-1,221,982,485,-1,485,957,221,-1,233,981,485,-1,485,982,233,-1,232,980,485,-1,485,981,232,-1,221,959,486,-1,486,982,221,-1,222,984,486,-1,486,959,222,-1,234,983,486,-1,486,984,234,-1,233,982,486,-1,486,983,233,-1,222,961,487,-1,487,984,222,-1,223,986,487,-1,487,961,223,-1,235,985,487,-1,487,986,235,-1,234,984,487,-1,487,985,234,-1,223,963,488,-1,488,986,223,-1,224,988,488,-1,488,963,224,-1,236,987,488,-1,488,988,236,-1,235,986,488,-1,488,987,235,-1,224,965,489,-1,489,988,224,-1,225,990,489,-1,489,965,225,-1,237,989,489,-1,489,990,237,-1,236,988,489,-1,489,989,236,-1,225,967,490,-1,490,990,225,-1,226,992,490,-1,490,967,226,-1,238,991,490,-1,490,992,238,-1,237,990,490,-1,490,991,237,-1,226,969,491,-1,491,992,226,-1,227,994,491,-1,491,969,227,-1,239,993,491,-1,491,994,239,-1,238,992,491,-1,491,993,238,-1,227,971,492,-1,492,994,227,-1,228,996,492,-1,492,971,228,-1,240,995,492,-1,492,996,240,-1,239,994,492,-1,492,995,239,-1,228,973,493,-1,493,996,228,-1,217,975,493,-1,493,973,217,-1,229,997,493,-1,493,975,229,-1,240,996,493,-1,493,997,240,-1,229,974,494,-1,494,999,229,-1,230,1000,494,-1,494,974,230,-1,242,998,494,-1,494,1000,242,-1,241,999,494,-1,494,998,241,-1,230,977,495,-1,495,1000,230,-1,231,1002,495,-1,495,977,231,-1,243,1001,495,-1,495,1002,243,-1,242,1000,495,-1,495,1001,242,-1,231,979,496,-1,496,1002,231,-1,232,1004,496,-1,496,979,232,-1,244,1003,496,-1,496,1004,244,-1,243,1002,496,-1,496,1003,243,-1,232,981,497,-1,497,1004,232,-1,233,1006,497,-1,497,981,233,-1,245,1005,497,-1,497,1006,245,-1,244,1004,497,-1,497,1005,244,-1,233,983,498,-1,498,1006,233,-1,234,1008,498,-1,498,983,234,-1,246,1007,498,-1,498,1008,246,-1,245,1006,498,-1,498,1007,245,-1,234,985,499,-1,499,1008,234,-1,235,1010,499,-1,499,985,235,-1,247,1009,499,-1,499,1010,247,-1,246,1008,499,-1,499,1009,246,-1,235,987,500,-1,500,1010,235,-1,236,1012,500,-1,500,987,236,-1,248,1011,500,-1,500,1012,248,-1,247,1010,500,-1,500,1011,247,-1,236,989,501,-1,501,1012,236,-1,237,1014,501,-1,501,989,237,-1,249,1013,501,-1,501,1014,249,-1,248,1012,501,-1,501,1013,248,-1,237,991,502,-1,502,1014,237,-1,238,1016,502,-1,502,991,238,-1,250,1015,502,-1,502,1016,250,-1,249,1014,502,-1,502,1015,249,-1,238,993,503,-1,503,1016,238,-1,239,1018,503,-1,503,993,239,-1,251,1017,503,-1,503,1018,251,-1,250,1016,503,-1,503,1017,250,-1,239,995,504,-1,504,1018,239,-1,240,1020,504,-1,504,995,240,-1,252,1019,504,-1,504,1020,252,-1,251,1018,504,-1,504,1019,251,-1,240,997,505,-1,505,1020,240,-1,229,999,505,-1,505,997,229,-1,241,1021,505,-1,505,999,241,-1,252,1020,505,-1,505,1021,252,-1,253,1022,506,-1,506,1023,253,-1,241,998,506,-1,506,1022,241,-1,242,1023,506,-1,506,998,242,-1,253,1023,507,-1,507,1024,253,-1,242,1001,507,-1,507,1023,242,-1,243,1024,507,-1,507,1001,243,-1,253,1024,508,-1,508,1025,253,-1,243,1003,508,-1,508,1024,243,-1,244,1025,508,-1,508,1003,244,-1,253,1025,509,-1,509,1026,253,-1,244,1005,509,-1,509,1025,244,-1,245,1026,509,-1,509,1005,245,-1,253,1026,510,-1,510,1027,253,-1,245,1007,510,-1,510,1026,245,-1,246,1027,510,-1,510,1007,246,-1,253,1027,511,-1,511,1028,253,-1,246,1009,511,-1,511,1027,246,-1,247,1028,511,-1,511,1009,247,-1,253,1028,512,-1,512,1029,253,-1,247,1011,512,-1,512,1028,247,-1,248,1029,512,-1,512,1011,248,-1,253,1029,513,-1,513,1030,253,-1,248,1013,513,-1,513,1029,248,-1,249,1030,513,-1,513,1013,249,-1,253,1030,514,-1,514,1031,253,-1,249,1015,514,-1,514,1030,249,-1,250,1031,514,-1,514,1015,250,-1,253,1031,515,-1,515,1032,253,-1,250,1017,515,-1,515,1031,250,-1,251,1032,515,-1,515,1017,251,-1,253,1032,516,-1,516,1033,253,-1,251,1019,516,-1,516,1032,251,-1,252,1033,516,-1,516,1019,252,-1,253,1033,517,-1,517,1022,253,-1,252,1021,517,-1,517,1033,252,-1,241,1022,517,-1,517,1021,241,-1,1034,1035,1036,-1,1034,1036,1037,-1,1034,1037,1038,-1,1034,1038,1039,-1,1034,1039,1040,-1,1034,1040,1041,-1,1034,1041,1042,-1,1034,1042,1043,-1,1034,1043,1044,-1,1034,1044,1045,-1,1034,1045,1046,-1,1034,1046,1047,-1,1034,1047,1048,-1,1034,1048,1049,-1,1034,1049,1050,-1,1034,1050,1051,-1,1034,1051,1052,-1,1034,1052,1035,-1,1035,1053,1054,-1,1035,1054,1036,-1,1036,1054,1055,-1,1036,1055,1037,-1,1037,1055,1056,-1,1037,1056,1038,-1,1038,1056,1057,-1,1038,1057,1039,-1,1039,1057,1058,-1,1039,1058,1040,-1,1040,1058,1059,-1,1040,1059,1041,-1,1041,1059,1060,-1,1041,1060,1042,-1,1042,1060,1061,-1,1042,1061,1043,-1,1043,1061,1062,-1,1043,1062,1044,-1,1044,1062,1063,-1,1044,1063,1045,-1,1045,1063,1064,-1,1045,1064,1046,-1,1046,1064,1065,-1,1046,1065,1047,-1,1047,1065,1066,-1,1047,1066,1048,-1,1048,1066,1067,-1,1048,1067,1049,-1,1049,1067,1068,-1,1049,1068,1050,-1,1050,1068,1069,-1,1050,1069,1051,-1,1051,1069,1070,-1,1051,1070,1052,-1,1052,1070,1053,-1,1052,1053,1035,-1,1053,1071,1072,-1,1053,1072,1054,-1,1054,1072,1073,-1,1054,1073,1055,-1,1055,1073,1074,-1,1055,1074,1056,-1,1056,1074,1075,-1,1056,1075,1057,-1,1057,1075,1076,-1,1057,1076,1058,-1,1058,1076,1077,-1,1058,1077,1059,-1,1059,1077,1078,-1,1059,1078,1060,-1,1060,1078,1079,-1,1060,1079,1061,-1,1061,1079,1080,-1,1061,1080,1062,-1,1062,1080,1081,-1,1062,1081,1063,-1,1063,1081,1082,-1,1063,1082,1064,-1,1064,1082,1083,-1,1064,1083,1065,-1,1065,1083,1084,-1,1065,1084,1066,-1,1066,1084,1085,-1,1066,1085,1067,-1,1067,1085,1086,-1,1067,1086,1068,-1,1068,1086,1087,-1,1068,1087,1069,-1,1069,1087,1088,-1,1069,1088,1070,-1,1070,1088,1071,-1,1070,1071,1053,-1,1071,1089,1090,-1,1071,1090,1072,-1,1072,1090,1091,-1,1072,1091,1073,-1,1073,1091,1092,-1,1073,1092,1074,-1,1074,1092,1093,-1,1074,1093,1075,-1,1075,1093,1094,-1,1075,1094,1076,-1,1076,1094,1095,-1,1076,1095,1077,-1,1077,1095,1096,-1,1077,1096,1078,-1,1078,1096,1097,-1,1078,1097,1079,-1,1079,1097,1098,-1,1079,1098,1080,-1,1080,1098,1099,-1,1080,1099,1081,-1,1081,1099,1100,-1,1081,1100,1082,-1,1082,1100,1101,-1,1082,1101,1083,-1,1083,1101,1102,-1,1083,1102,1084,-1,1084,1102,1103,-1,1084,1103,1085,-1,1085,1103,1104,-1,1085,1104,1086,-1,1086,1104,1105,-1,1086,1105,1087,-1,1087,1105,1106,-1,1087,1106,1088,-1,1088,1106,1089,-1,1088,1089,1071,-1,1089,1107,1108,-1,1089,1108,1090,-1,1090,1108,1109,-1,1090,1109,1091,-1,1091,1109,1110,-1,1091,1110,1092,-1,1092,1110,1111,-1,1092,1111,1093,-1,1093,1111,1112,-1,1093,1112,1094,-1,1094,1112,1113,-1,1094,1113,1095,-1,1095,1113,1114,-1,1095,1114,1096,-1,1096,1114,1115,-1,1096,1115,1097,-1,1097,1115,1116,-1,1097,1116,1098,-1,1098,1116,1117,-1,1098,1117,1099,-1,1099,1117,1118,-1,1099,1118,1100,-1,1100,1118,1119,-1,1100,1119,1101,-1,1101,1119,1120,-1,1101,1120,1102,-1,1102,1120,1121,-1,1102,1121,1103,-1,1103,1121,1122,-1,1103,1122,1104,-1,1104,1122,1123,-1,1104,1123,1105,-1,1105,1123,1124,-1,1105,1124,1106,-1,1106,1124,1107,-1,1106,1107,1089,-1,1107,1125,1126,-1,1107,1126,1108,-1,1108,1126,1127,-1,1108,1127,1109,-1,1109,1127,1128,-1,1109,1128,1110,-1,1110,1128,1129,-1,1110,1129,1111,-1,1111,1129,1130,-1,1111,1130,1112,-1,1112,1130,1131,-1,1112,1131,1113,-1,1113,1131,1132,-1,1113,1132,1114,-1,1114,1132,1133,-1,1114,1133,1115,-1,1115,1133,1134,-1,1115,1134,1116,-1,1116,1134,1135,-1,1116,1135,1117,-1,1117,1135,1136,-1,1117,1136,1118,-1,1118,1136,1137,-1,1118,1137,1119,-1,1119,1137,1138,-1,1119,1138,1120,-1,1120,1138,1139,-1,1120,1139,1121,-1,1121,1139,1140,-1,1121,1140,1122,-1,1122,1140,1141,-1,1122,1141,1123,-1,1123,1141,1142,-1,1123,1142,1124,-1,1124,1142,1125,-1,1124,1125,1107,-1,1125,1143,1144,-1,1125,1144,1126,-1,1126,1144,1145,-1,1126,1145,1127,-1,1127,1145,1146,-1,1127,1146,1128,-1,1128,1146,1147,-1,1128,1147,1129,-1,1129,1147,1148,-1,1129,1148,1130,-1,1130,1148,1149,-1,1130,1149,1131,-1,1131,1149,1150,-1,1131,1150,1132,-1,1132,1150,1151,-1,1132,1151,1133,-1,1133,1151,1152,-1,1133,1152,1134,-1,1134,1152,1153,-1,1134,1153,1135,-1,1135,1153,1154,-1,1135,1154,1136,-1,1136,1154,1155,-1,1136,1155,1137,-1,1137,1155,1156,-1,1137,1156,1138,-1,1138,1156,1157,-1,1138,1157,1139,-1,1139,1157,1158,-1,1139,1158,1140,-1,1140,1158,1159,-1,1140,1159,1141,-1,1141,1159,1160,-1,1141,1160,1142,-1,1142,1160,1143,-1,1142,1143,1125,-1,1143,1161,1162,-1,1143,1162,1144,-1,1144,1162,1163,-1,1144,1163,1145,-1,1145,1163,1164,-1,1145,1164,1146,-1,1146,1164,1165,-1,1146,1165,1147,-1,1147,1165,1166,-1,1147,1166,1148,-1,1148,1166,1167,-1,1148,1167,1149,-1,1149,1167,1168,-1,1149,1168,1150,-1,1150,1168,1169,-1,1150,1169,1151,-1,1151,1169,1170,-1,1151,1170,1152,-1,1152,1170,1171,-1,1152,1171,1153,-1,1153,1171,1172,-1,1153,1172,1154,-1,1154,1172,1173,-1,1154,1173,1155,-1,1155,1173,1174,-1,1155,1174,1156,-1,1156,1174,1175,-1,1156,1175,1157,-1,1157,1175,1176,-1,1157,1176,1158,-1,1158,1176,1177,-1,1158,1177,1159,-1,1159,1177,1178,-1,1159,1178,1160,-1,1160,1178,1161,-1,1160,1161,1143,-1,1179,1162,1161,-1,1179,1163,1162,-1,1179,1164,1163,-1,1179,1165,1164,-1,1179,1166,1165,-1,1179,1167,1166,-1,1179,1168,1167,-1,1179,1169,1168,-1,1179,1170,1169,-1,1179,1171,1170,-1,1179,1172,1171,-1,1179,1173,1172,-1,1179,1174,1173,-1,1179,1175,1174,-1,1179,1176,1175,-1,1179,1177,1176,-1,1179,1178,1177,-1,1179,1161,1178,-1,1180,1181,1182,-1,1180,1182,1183,-1,1180,1183,1184,-1,1180,1184,1185,-1,1180,1185,1186,-1,1180,1186,1187,-1,1180,1187,1188,-1,1180,1188,1189,-1,1180,1189,1190,-1,1180,1190,1191,-1,1180,1191,1192,-1,1180,1192,1193,-1,1180,1193,1194,-1,1180,1194,1195,-1,1180,1195,1196,-1,1180,1196,1197,-1,1180,1197,1198,-1,1180,1198,1181,-1,1181,1199,1200,-1,1181,1200,1182,-1,1182,1200,1201,-1,1182,1201,1183,-1,1183,1201,1202,-1,1183,1202,1184,-1,1184,1202,1203,-1,1184,1203,1185,-1,1185,1203,1204,-1,1185,1204,1186,-1,1186,1204,1205,-1,1186,1205,1187,-1,1187,1205,1206,-1,1187,1206,1188,-1,1188,1206,1207,-1,1188,1207,1189,-1,1189,1207,1208,-1,1189,1208,1190,-1,1190,1208,1209,-1,1190,1209,1191,-1,1191,1209,1210,-1,1191,1210,1192,-1,1192,1210,1211,-1,1192,1211,1193,-1,1193,1211,1212,-1,1193,1212,1194,-1,1194,1212,1213,-1,1194,1213,1195,-1,1195,1213,1214,-1,1195,1214,1196,-1,1196,1214,1215,-1,1196,1215,1197,-1,1197,1215,1216,-1,1197,1216,1198,-1,1198,1216,1199,-1,1198,1199,1181,-1,1199,1217,1218,-1,1199,1218,1200,-1,1200,1218,1219,-1,1200,1219,1201,-1,1201,1219,1220,-1,1201,1220,1202,-1,1202,1220,1221,-1,1202,1221,1203,-1,1203,1221,1222,-1,1203,1222,1204,-1,1204,1222,1223,-1,1204,1223,1205,-1,1205,1223,1224,-1,1205,1224,1206,-1,1206,1224,1225,-1,1206,1225,1207,-1,1207,1225,1226,-1,1207,1226,1208,-1,1208,1226,1227,-1,1208,1227,1209,-1,1209,1227,1228,-1,1209,1228,1210,-1,1210,1228,1229,-1,1210,1229,1211,-1,1211,1229,1230,-1,1211,1230,1212,-1,1212,1230,1231,-1,1212,1231,1213,-1,1213,1231,1232,-1,1213,1232,1214,-1,1214,1232,1233,-1,1214,1233,1215,-1,1215,1233,1234,-1,1215,1234,1216,-1,1216,1234,1217,-1,1216,1217,1199,-1,1217,1235,1236,-1,1217,1236,1218,-1,1218,1236,1237,-1,1218,1237,1219,-1,1219,1237,1238,-1,1219,1238,1220,-1,1220,1238,1239,-1,1220,1239,1221,-1,1221,1239,1240,-1,1221,1240,1222,-1,1222,1240,1241,-1,1222,1241,1223,-1,1223,1241,1242,-1,1223,1242,1224,-1,1224,1242,1243,-1,1224,1243,1225,-1,1225,1243,1244,-1,1225,1244,1226,-1,1226,1244,1245,-1,1226,1245,1227,-1,1227,1245,1246,-1,1227,1246,1228,-1,1228,1246,1247,-1,1228,1247,1229,-1,1229,1247,1248,-1,1229,1248,1230,-1,1230,1248,1249,-1,1230,1249,1231,-1,1231,1249,1250,-1,1231,1250,1232,-1,1232,1250,1251,-1,1232,1251,1233,-1,1233,1251,1252,-1,1233,1252,1234,-1,1234,1252,1235,-1,1234,1235,1217,-1,1235,1253,1254,-1,1235,1254,1236,-1,1236,1254,1255,-1,1236,1255,1237,-1,1237,1255,1256,-1,1237,1256,1238,-1,1238,1256,1257,-1,1238,1257,1239,-1,1239,1257,1258,-1,1239,1258,1240,-1,1240,1258,1259,-1,1240,1259,1241,-1,1241,1259,1260,-1,1241,1260,1242,-1,1242,1260,1261,-1,1242,1261,1243,-1,1243,1261,1262,-1,1243,1262,1244,-1,1244,1262,1263,-1,1244,1263,1245,-1,1245,1263,1264,-1,1245,1264,1246,-1,1246,1264,1265,-1,1246,1265,1247,-1,1247,1265,1266,-1,1247,1266,1248,-1,1248,1266,1267,-1,1248,1267,1249,-1,1249,1267,1268,-1,1249,1268,1250,-1,1250,1268,1269,-1,1250,1269,1251,-1,1251,1269,1270,-1,1251,1270,1252,-1,1252,1270,1253,-1,1252,1253,1235,-1,1253,1271,1272,-1,1253,1272,1254,-1,1254,1272,1273,-1,1254,1273,1255,-1,1255,1273,1274,-1,1255,1274,1256,-1,1256,1274,1275,-1,1256,1275,1257,-1,1257,1275,1276,-1,1257,1276,1258,-1,1258,1276,1277,-1,1258,1277,1259,-1,1259,1277,1278,-1,1259,1278,1260,-1,1260,1278,1279,-1,1260,1279,1261,-1,1261,1279,1280,-1,1261,1280,1262,-1,1262,1280,1281,-1,1262,1281,1263,-1,1263,1281,1282,-1,1263,1282,1264,-1,1264,1282,1283,-1,1264,1283,1265,-1,1265,1283,1284,-1,1265,1284,1266,-1,1266,1284,1285,-1,1266,1285,1267,-1,1267,1285,1286,-1,1267,1286,1268,-1,1268,1286,1287,-1,1268,1287,1269,-1,1269,1287,1288,-1,1269,1288,1270,-1,1270,1288,1271,-1,1270,1271,1253,-1,1271,1289,1290,-1,1271,1290,1272,-1,1272,1290,1291,-1,1272,1291,1273,-1,1273,1291,1292,-1,1273,1292,1274,-1,1274,1292,1293,-1,1274,1293,1275,-1,1275,1293,1294,-1,1275,1294,1276,-1,1276,1294,1295,-1,1276,1295,1277,-1,1277,1295,1296,-1,1277,1296,1278,-1,1278,1296,1297,-1,1278,1297,1279,-1,1279,1297,1298,-1,1279,1298,1280,-1,1280,1298,1299,-1,1280,1299,1281,-1,1281,1299,1300,-1,1281,1300,1282,-1,1282,1300,1301,-1,1282,1301,1283,-1,1283,1301,1302,-1,1283,1302,1284,-1,1284,1302,1303,-1,1284,1303,1285,-1,1285,1303,1304,-1,1285,1304,1286,-1,1286,1304,1305,-1,1286,1305,1287,-1,1287,1305,1306,-1,1287,1306,1288,-1,1288,1306,1289,-1,1288,1289,1271,-1,1289,1307,1308,-1,1289,1308,1290,-1,1290,1308,1309,-1,1290,1309,1291,-1,1291,1309,1310,-1,1291,1310,1292,-1,1292,1310,1311,-1,1292,1311,1293,-1,1293,1311,1312,-1,1293,1312,1294,-1,1294,1312,1313,-1,1294,1313,1295,-1,1295,1313,1314,-1,1295,1314,1296,-1,1296,1314,1315,-1,1296,1315,1297,-1,1297,1315,1316,-1,1297,1316,1298,-1,1298,1316,1317,-1,1298,1317,1299,-1,1299,1317,1318,-1,1299,1318,1300,-1,1300,1318,1319,-1,1300,1319,1301,-1,1301,1319,1320,-1,1301,1320,1302,-1,1302,1320,1321,-1,1302,1321,1303,-1,1303,1321,1322,-1,1303,1322,1304,-1,1304,1322,1323,-1,1304,1323,1305,-1,1305,1323,1324,-1,1305,1324,1306,-1,1306,1324,1307,-1,1306,1307,1289,-1,1325,1308,1307,-1,1325,1309,1308,-1,1325,1310,1309,-1,1325,1311,1310,-1,1325,1312,1311,-1,1325,1313,1312,-1,1325,1314,1313,-1,1325,1315,1314,-1,1325,1316,1315,-1,1325,1317,1316,-1,1325,1318,1317,-1,1325,1319,1318,-1,1325,1320,1319,-1,1325,1321,1320,-1,1325,1322,1321,-1,1325,1323,1322,-1,1325,1324,1323,-1,1325,1307,1324,-1,1326,1327,1328,-1,1326,1328,1329,-1,1326,1329,1330,-1,1326,1330,1331,-1,1326,1331,1332,-1,1326,1332,1333,-1,1326,1333,1334,-1,1326,1334,1335,-1,1326,1335,1336,-1,1326,1336,1337,-1,1326,1337,1338,-1,1326,1338,1339,-1,1326,1339,1340,-1,1326,1340,1341,-1,1326,1341,1342,-1,1326,1342,1343,-1,1326,1343,1344,-1,1326,1344,1327,-1,1327,1345,1346,-1,1327,1346,1328,-1,1328,1346,1347,-1,1328,1347,1329,-1,1329,1347,1348,-1,1329,1348,1330,-1,1330,1348,1349,-1,1330,1349,1331,-1,1331,1349,1350,-1,1331,1350,1332,-1,1332,1350,1351,-1,1332,1351,1333,-1,1333,1351,1352,-1,1333,1352,1334,-1,1334,1352,1353,-1,1334,1353,1335,-1,1335,1353,1354,-1,1335,1354,1336,-1,1336,1354,1355,-1,1336,1355,1337,-1,1337,1355,1356,-1,1337,1356,1338,-1,1338,1356,1357,-1,1338,1357,1339,-1,1339,1357,1358,-1,1339,1358,1340,-1,1340,1358,1359,-1,1340,1359,1341,-1,1341,1359,1360,-1,1341,1360,1342,-1,1342,1360,1361,-1,1342,1361,1343,-1,1343,1361,1362,-1,1343,1362,1344,-1,1344,1362,1345,-1,1344,1345,1327,-1,1345,1363,1364,-1,1345,1364,1346,-1,1346,1364,1365,-1,1346,1365,1347,-1,1347,1365,1366,-1,1347,1366,1348,-1,1348,1366,1367,-1,1348,1367,1349,-1,1349,1367,1368,-1,1349,1368,1350,-1,1350,1368,1369,-1,1350,1369,1351,-1,1351,1369,1370,-1,1351,1370,1352,-1,1352,1370,1371,-1,1352,1371,1353,-1,1353,1371,1372,-1,1353,1372,1354,-1,1354,1372,1373,-1,1354,1373,1355,-1,1355,1373,1374,-1,1355,1374,1356,-1,1356,1374,1375,-1,1356,1375,1357,-1,1357,1375,1376,-1,1357,1376,1358,-1,1358,1376,1377,-1,1358,1377,1359,-1,1359,1377,1378,-1,1359,1378,1360,-1,1360,1378,1379,-1,1360,1379,1361,-1,1361,1379,1380,-1,1361,1380,1362,-1,1362,1380,1363,-1,1362,1363,1345,-1,1363,1381,1382,-1,1363,1382,1364,-1,1364,1382,1383,-1,1364,1383,1365,-1,1365,1383,1384,-1,1365,1384,1366,-1,1366,1384,1385,-1,1366,1385,1367,-1,1367,1385,1386,-1,1367,1386,1368,-1,1368,1386,1387,-1,1368,1387,1369,-1,1369,1387,1388,-1,1369,1388,1370,-1,1370,1388,1389,-1,1370,1389,1371,-1,1371,1389,1390,-1,1371,1390,1372,-1,1372,1390,1391,-1,1372,1391,1373,-1,1373,1391,1392,-1,1373,1392,1374,-1,1374,1392,1393,-1,1374,1393,1375,-1,1375,1393,1394,-1,1375,1394,1376,-1,1376,1394,1395,-1,1376,1395,1377,-1,1377,1395,1396,-1,1377,1396,1378,-1,1378,1396,1397,-1,1378,1397,1379,-1,1379,1397,1398,-1,1379,1398,1380,-1,1380,1398,1381,-1,1380,1381,1363,-1,1381,1399,1400,-1,1381,1400,1382,-1,1382,1400,1401,-1,1382,1401,1383,-1,1383,1401,1402,-1,1383,1402,1384,-1,1384,1402,1403,-1,1384,1403,1385,-1,1385,1403,1404,-1,1385,1404,1386,-1,1386,1404,1405,-1,1386,1405,1387,-1,1387,1405,1406,-1,1387,1406,1388,-1,1388,1406,1407,-1,1388,1407,1389,-1,1389,1407,1408,-1,1389,1408,1390,-1,1390,1408,1409,-1,1390,1409,1391,-1,1391,1409,1410,-1,1391,1410,1392,-1,1392,1410,1411,-1,1392,1411,1393,-1,1393,1411,1412,-1,1393,1412,1394,-1,1394,1412,1413,-1,1394,1413,1395,-1,1395,1413,1414,-1,1395,1414,1396,-1,1396,1414,1415,-1,1396,1415,1397,-1,1397,1415,1416,-1,1397,1416,1398,-1,1398,1416,1399,-1,1398,1399,1381,-1,1399,1417,1418,-1,1399,1418,1400,-1,1400,1418,1419,-1,1400,1419,1401,-1,1401,1419,1420,-1,1401,1420,1402,-1,1402,1420,1421,-1,1402,1421,1403,-1,1403,1421,1422,-1,1403,1422,1404,-1,1404,1422,1423,-1,1404,1423,1405,-1,1405,1423,1424,-1,1405,1424,1406,-1,1406,1424,1425,-1,1406,1425,1407,-1,1407,1425,1426,-1,1407,1426,1408,-1,1408,1426,1427,-1,1408,1427,1409,-1,1409,1427,1428,-1,1409,1428,1410,-1,1410,1428,1429,-1,1410,1429,1411,-1,1411,1429,1430,-1,1411,1430,1412,-1,1412,1430,1431,-1,1412,1431,1413,-1,1413,1431,1432,-1,1413,1432,1414,-1,1414,1432,1433,-1,1414,1433,1415,-1,1415,1433,1434,-1,1415,1434,1416,-1,1416,1434,1417,-1,1416,1417,1399,-1,1417,1435,1436,-1,1417,1436,1418,-1,1418,1436,1437,-1,1418,1437,1419,-1,1419,1437,1438,-1,1419,1438,1420,-1,1420,1438,1439,-1,1420,1439,1421,-1,1421,1439,1440,-1,1421,1440,1422,-1,1422,1440,1441,-1,1422,1441,1423,-1,1423,1441,1442,-1,1423,1442,1424,-1,1424,1442,1443,-1,1424,1443,1425,-1,1425,1443,1444,-1,1425,1444,1426,-1,1426,1444,1445,-1,1426,1445,1427,-1,1427,1445,1446,-1,1427,1446,1428,-1,1428,1446,1447,-1,1428,1447,1429,-1,1429,1447,1448,-1,1429,1448,1430,-1,1430,1448,1449,-1,1430,1449,1431,-1,1431,1449,1450,-1,1431,1450,1432,-1,1432,1450,1451,-1,1432,1451,1433,-1,1433,1451,1452,-1,1433,1452,1434,-1,1434,1452,1435,-1,1434,1435,1417,-1,1435,1453,1454,-1,1435,1454,1436,-1,1436,1454,1455,-1,1436,1455,1437,-1,1437,1455,1456,-1,1437,1456,1438,-1,1438,1456,1457,-1,1438,1457,1439,-1,1439,1457,1458,-1,1439,1458,1440,-1,1440,1458,1459,-1,1440,1459,1441,-1,1441,1459,1460,-1,1441,1460,1442,-1,1442,1460,1461,-1,1442,1461,1443,-1,1443,1461,1462,-1,1443,1462,1444,-1,1444,1462,1463,-1,1444,1463,1445,-1,1445,1463,1464,-1,1445,1464,1446,-1,1446,1464,1465,-1,1446,1465,1447,-1,1447,1465,1466,-1,1447,1466,1448,-1,1448,1466,1467,-1,1448,1467,1449,-1,1449,1467,1468,-1,1449,1468,1450,-1,1450,1468,1469,-1,1450,1469,1451,-1,1451,1469,1470,-1,1451,1470,1452,-1,1452,1470,1453,-1,1452,1453,1435,-1,1471,1454,1453,-1,1471,1455,1454,-1,1471,1456,1455,-1,1471,1457,1456,-1,1471,1458,1457,-1,1471,1459,1458,-1,1471,1460,1459,-1,1471,1461,1460,-1,1471,1462,1461,-1,1471,1463,1462,-1,1471,1464,1463,-1,1471,1465,1464,-1,1471,1466,1465,-1,1471,1467,1466,-1,1471,1468,1467,-1,1471,1469,1468,-1,1471,1470,1469,-1,1471,1453,1470,-1,1472,1473,1474,-1,1472,1474,1475,-1,1472,1475,1476,-1,1472,1476,1477,-1,1472,1477,1478,-1,1472,1478,1479,-1,1472,1479,1480,-1,1472,1480,1481,-1,1472,1481,1482,-1,1472,1482,1483,-1,1472,1483,1484,-1,1472,1484,1485,-1,1472,1485,1486,-1,1472,1486,1487,-1,1472,1487,1488,-1,1472,1488,1489,-1,1472,1489,1490,-1,1472,1490,1473,-1,1473,1491,1492,-1,1473,1492,1474,-1,1474,1492,1493,-1,1474,1493,1475,-1,1475,1493,1494,-1,1475,1494,1476,-1,1476,1494,1495,-1,1476,1495,1477,-1,1477,1495,1496,-1,1477,1496,1478,-1,1478,1496,1497,-1,1478,1497,1479,-1,1479,1497,1498,-1,1479,1498,1480,-1,1480,1498,1499,-1,1480,1499,1481,-1,1481,1499,1500,-1,1481,1500,1482,-1,1482,1500,1501,-1,1482,1501,1483,-1,1483,1501,1502,-1,1483,1502,1484,-1,1484,1502,1503,-1,1484,1503,1485,-1,1485,1503,1504,-1,1485,1504,1486,-1,1486,1504,1505,-1,1486,1505,1487,-1,1487,1505,1506,-1,1487,1506,1488,-1,1488,1506,1507,-1,1488,1507,1489,-1,1489,1507,1508,-1,1489,1508,1490,-1,1490,1508,1491,-1,1490,1491,1473,-1,1491,1509,1510,-1,1491,1510,1492,-1,1492,1510,1511,-1,1492,1511,1493,-1,1493,1511,1512,-1,1493,1512,1494,-1,1494,1512,1513,-1,1494,1513,1495,-1,1495,1513,1514,-1,1495,1514,1496,-1,1496,1514,1515,-1,1496,1515,1497,-1,1497,1515,1516,-1,1497,1516,1498,-1,1498,1516,1517,-1,1498,1517,1499,-1,1499,1517,1518,-1,1499,1518,1500,-1,1500,1518,1519,-1,1500,1519,1501,-1,1501,1519,1520,-1,1501,1520,1502,-1,1502,1520,1521,-1,1502,1521,1503,-1,1503,1521,1522,-1,1503,1522,1504,-1,1504,1522,1523,-1,1504,1523,1505,-1,1505,1523,1524,-1,1505,1524,1506,-1,1506,1524,1525,-1,1506,1525,1507,-1,1507,1525,1526,-1,1507,1526,1508,-1,1508,1526,1509,-1,1508,1509,1491,-1,1509,1527,1528,-1,1509,1528,1510,-1,1510,1528,1529,-1,1510,1529,1511,-1,1511,1529,1530,-1,1511,1530,1512,-1,1512,1530,1531,-1,1512,1531,1513,-1,1513,1531,1532,-1,1513,1532,1514,-1,1514,1532,1533,-1,1514,1533,1515,-1,1515,1533,1534,-1,1515,1534,1516,-1,1516,1534,1535,-1,1516,1535,1517,-1,1517,1535,1536,-1,1517,1536,1518,-1,1518,1536,1537,-1,1518,1537,1519,-1,1519,1537,1538,-1,1519,1538,1520,-1,1520,1538,1539,-1,1520,1539,1521,-1,1521,1539,1540,-1,1521,1540,1522,-1,1522,1540,1541,-1,1522,1541,1523,-1,1523,1541,1542,-1,1523,1542,1524,-1,1524,1542,1543,-1,1524,1543,1525,-1,1525,1543,1544,-1,1525,1544,1526,-1,1526,1544,1527,-1,1526,1527,1509,-1,1527,1545,1546,-1,1527,1546,1528,-1,1528,1546,1547,-1,1528,1547,1529,-1,1529,1547,1548,-1,1529,1548,1530,-1,1530,1548,1549,-1,1530,1549,1531,-1,1531,1549,1550,-1,1531,1550,1532,-1,1532,1550,1551,-1,1532,1551,1533,-1,1533,1551,1552,-1,1533,1552,1534,-1,1534,1552,1553,-1,1534,1553,1535,-1,1535,1553,1554,-1,1535,1554,1536,-1,1536,1554,1555,-1,1536,1555,1537,-1,1537,1555,1556,-1,1537,1556,1538,-1,1538,1556,1557,-1,1538,1557,1539,-1,1539,1557,1558,-1,1539,1558,1540,-1,1540,1558,1559,-1,1540,1559,1541,-1,1541,1559,1560,-1,1541,1560,1542,-1,1542,1560,1561,-1,1542,1561,1543,-1,1543,1561,1562,-1,1543,1562,1544,-1,1544,1562,1545,-1,1544,1545,1527,-1,1545,1563,1564,-1,1545,1564,1546,-1,1546,1564,1565,-1,1546,1565,1547,-1,1547,1565,1566,-1,1547,1566,1548,-1,1548,1566,1567,-1,1548,1567,1549,-1,1549,1567,1568,-1,1549,1568,1550,-1,1550,1568,1569,-1,1550,1569,1551,-1,1551,1569,1570,-1,1551,1570,1552,-1,1552,1570,1571,-1,1552,1571,1553,-1,1553,1571,1572,-1,1553,1572,1554,-1,1554,1572,1573,-1,1554,1573,1555,-1,1555,1573,1574,-1,1555,1574,1556,-1,1556,1574,1575,-1,1556,1575,1557,-1,1557,1575,1576,-1,1557,1576,1558,-1,1558,1576,1577,-1,1558,1577,1559,-1,1559,1577,1578,-1,1559,1578,1560,-1,1560,1578,1579,-1,1560,1579,1561,-1,1561,1579,1580,-1,1561,1580,1562,-1,1562,1580,1563,-1,1562,1563,1545,-1,1563,1581,1582,-1,1563,1582,1564,-1,1564,1582,1583,-1,1564,1583,1565,-1,1565,1583,1584,-1,1565,1584,1566,-1,1566,1584,1585,-1,1566,1585,1567,-1,1567,1585,1586,-1,1567,1586,1568,-1,1568,1586,1587,-1,1568,1587,1569,-1,1569,1587,1588,-1,1569,1588,1570,-1,1570,1588,1589,-1,1570,1589,1571,-1,1571,1589,1590,-1,1571,1590,1572,-1,1572,1590,1591,-1,1572,1591,1573,-1,1573,1591,1592,-1,1573,1592,1574,-1,1574,1592,1593,-1,1574,1593,1575,-1,1575,1593,1594,-1,1575,1594,1576,-1,1576,1594,1595,-1,1576,1595,1577,-1,1577,1595,1596,-1,1577,1596,1578,-1,1578,1596,1597,-1,1578,1597,1579,-1,1579,1597,1598,-1,1579,1598,1580,-1,1580,1598,1581,-1,1580,1581,1563,-1,1581,1599,1600,-1,1581,1600,1582,-1,1582,1600,1601,-1,1582,1601,1583,-1,1583,1601,1602,-1,1583,1602,1584,-1,1584,1602,1603,-1,1584,1603,1585,-1,1585,1603,1604,-1,1585,1604,1586,-1,1586,1604,1605,-1,1586,1605,1587,-1,1587,1605,1606,-1,1587,1606,1588,-1,1588,1606,1607,-1,1588,1607,1589,-1,1589,1607,1608,-1,1589,1608,1590,-1,1590,1608,1609,-1,1590,1609,1591,-1,1591,1609,1610,-1,1591,1610,1592,-1,1592,1610,1611,-1,1592,1611,1593,-1,1593,1611,1612,-1,1593,1612,1594,-1,1594,1612,1613,-1,1594,1613,1595,-1,1595,1613,1614,-1,1595,1614,1596,-1,1596,1614,1615,-1,1596,1615,1597,-1,1597,1615,1616,-1,1597,1616,1598,-1,1598,1616,1599,-1,1598,1599,1581,-1,1617,1600,1599,-1,1617,1601,1600,-1,1617,1602,1601,-1,1617,1603,1602,-1,1617,1604,1603,-1,1617,1605,1604,-1,1617,1606,1605,-1,1617,1607,1606,-1,1617,1608,1607,-1,1617,1609,1608,-1,1617,1610,1609,-1,1617,1611,1610,-1,1617,1612,1611,-1,1617,1613,1612,-1,1617,1614,1613,-1,1617,1615,1614,-1,1617,1616,1615,-1,1617,1599,1616,-1,1618,1619,1620,-1,1618,1620,1621,-1,1618,1621,1622,-1,1618,1622,1623,-1,1618,1623,1624,-1,1618,1624,1625,-1,1618,1625,1626,-1,1618,1626,1627,-1,1618,1627,1628,-1,1618,1628,1629,-1,1618,1629,1630,-1,1618,1630,1631,-1,1618,1631,1632,-1,1618,1632,1633,-1,1618,1633,1634,-1,1618,1634,1635,-1,1618,1635,1636,-1,1618,1636,1619,-1,1619,1637,1638,-1,1619,1638,1620,-1,1620,1638,1639,-1,1620,1639,1621,-1,1621,1639,1640,-1,1621,1640,1622,-1,1622,1640,1641,-1,1622,1641,1623,-1,1623,1641,1642,-1,1623,1642,1624,-1,1624,1642,1643,-1,1624,1643,1625,-1,1625,1643,1644,-1,1625,1644,1626,-1,1626,1644,1645,-1,1626,1645,1627,-1,1627,1645,1646,-1,1627,1646,1628,-1,1628,1646,1647,-1,1628,1647,1629,-1,1629,1647,1648,-1,1629,1648,1630,-1,1630,1648,1649,-1,1630,1649,1631,-1,1631,1649,1650,-1,1631,1650,1632,-1,1632,1650,1651,-1,1632,1651,1633,-1,1633,1651,1652,-1,1633,1652,1634,-1,1634,1652,1653,-1,1634,1653,1635,-1,1635,1653,1654,-1,1635,1654,1636,-1,1636,1654,1637,-1,1636,1637,1619,-1,1637,1655,1656,-1,1637,1656,1638,-1,1638,1656,1657,-1,1638,1657,1639,-1,1639,1657,1658,-1,1639,1658,1640,-1,1640,1658,1659,-1,1640,1659,1641,-1,1641,1659,1660,-1,1641,1660,1642,-1,1642,1660,1661,-1,1642,1661,1643,-1,1643,1661,1662,-1,1643,1662,1644,-1,1644,1662,1663,-1,1644,1663,1645,-1,1645,1663,1664,-1,1645,1664,1646,-1,1646,1664,1665,-1,1646,1665,1647,-1,1647,1665,1666,-1,1647,1666,1648,-1,1648,1666,1667,-1,1648,1667,1649,-1,1649,1667,1668,-1,1649,1668,1650,-1,1650,1668,1669,-1,1650,1669,1651,-1,1651,1669,1670,-1,1651,1670,1652,-1,1652,1670,1671,-1,1652,1671,1653,-1,1653,1671,1672,-1,1653,1672,1654,-1,1654,1672,1655,-1,1654,1655,1637,-1,1655,1673,1674,-1,1655,1674,1656,-1,1656,1674,1675,-1,1656,1675,1657,-1,1657,1675,1676,-1,1657,1676,1658,-1,1658,1676,1677,-1,1658,1677,1659,-1,1659,1677,1678,-1,1659,1678,1660,-1,1660,1678,1679,-1,1660,1679,1661,-1,1661,1679,1680,-1,1661,1680,1662,-1,1662,1680,1681,-1,1662,1681,1663,-1,1663,1681,1682,-1,1663,1682,1664,-1,1664,1682,1683,-1,1664,1683,1665,-1,1665,1683,1684,-1,1665,1684,1666,-1,1666,1684,1685,-1,1666,1685,1667,-1,1667,1685,1686,-1,1667,1686,1668,-1,1668,1686,1687,-1,1668,1687,1669,-1,1669,1687,1688,-1,1669,1688,1670,-1,1670,1688,1689,-1,1670,1689,1671,-1,1671,1689,1690,-1,1671,1690,1672,-1,1672,1690,1673,-1,1672,1673,1655,-1,1673,1691,1692,-1,1673,1692,1674,-1,1674,1692,1693,-1,1674,1693,1675,-1,1675,1693,1694,-1,1675,1694,1676,-1,1676,1694,1695,-1,1676,1695,1677,-1,1677,1695,1696,-1,1677,1696,1678,-1,1678,1696,1697,-1,1678,1697,1679,-1,1679,1697,1698,-1,1679,1698,1680,-1,1680,1698,1699,-1,1680,1699,1681,-1,1681,1699,1700,-1,1681,1700,1682,-1,1682,1700,1701,-1,1682,1701,1683,-1,1683,1701,1702,-1,1683,1702,1684,-1,1684,1702,1703,-1,1684,1703,1685,-1,1685,1703,1704,-1,1685,1704,1686,-1,1686,1704,1705,-1,1686,1705,1687,-1,1687,1705,1706,-1,1687,1706,1688,-1,1688,1706,1707,-1,1688,1707,1689,-1,1689,1707,1708,-1,1689,1708,1690,-1,1690,1708,1691,-1,1690,1691,1673,-1,1691,1709,1710,-1,1691,1710,1692,-1,1692,1710,1711,-1,1692,1711,1693,-1,1693,1711,1712,-1,1693,1712,1694,-1,1694,1712,1713,-1,1694,1713,1695,-1,1695,1713,1714,-1,1695,1714,1696,-1,1696,1714,1715,-1,1696,1715,1697,-1,1697,1715,1716,-1,1697,1716,1698,-1,1698,1716,1717,-1,1698,1717,1699,-1,1699,1717,1718,-1,1699,1718,1700,-1,1700,1718,1719,-1,1700,1719,1701,-1,1701,1719,1720,-1,1701,1720,1702,-1,1702,1720,1721,-1,1702,1721,1703,-1,1703,1721,1722,-1,1703,1722,1704,-1,1704,1722,1723,-1,1704,1723,1705,-1,1705,1723,1724,-1,1705,1724,1706,-1,1706,1724,1725,-1,1706,1725,1707,-1,1707,1725,1726,-1,1707,1726,1708,-1,1708,1726,1709,-1,1708,1709,1691,-1,1709,1727,1728,-1,1709,1728,1710,-1,1710,1728,1729,-1,1710,1729,1711,-1,1711,1729,1730,-1,1711,1730,1712,-1,1712,1730,1731,-1,1712,1731,1713,-1,1713,1731,1732,-1,1713,1732,1714,-1,1714,1732,1733,-1,1714,1733,1715,-1,1715,1733,1734,-1,1715,1734,1716,-1,1716,1734,1735,-1,1716,1735,1717,-1,1717,1735,1736,-1,1717,1736,1718,-1,1718,1736,1737,-1,1718,1737,1719,-1,1719,1737,1738,-1,1719,1738,1720,-1,1720,1738,1739,-1,1720,1739,1721,-1,1721,1739,1740,-1,1721,1740,1722,-1,1722,1740,1741,-1,1722,1741,1723,-1,1723,1741,1742,-1,1723,1742,1724,-1,1724,1742,1743,-1,1724,1743,1725,-1,1725,1743,1744,-1,1725,1744,1726,-1,1726,1744,1727,-1,1726,1727,1709,-1,1727,1745,1746,-1,1727,1746,1728,-1,1728,1746,1747,-1,1728,1747,1729,-1,1729,1747,1748,-1,1729,1748,1730,-1,1730,1748,1749,-1,1730,1749,1731,-1,1731,1749,1750,-1,1731,1750,1732,-1,1732,1750,1751,-1,1732,1751,1733,-1,1733,1751,1752,-1,1733,1752,1734,-1,1734,1752,1753,-1,1734,1753,1735,-1,1735,1753,1754,-1,1735,1754,1736,-1,1736,1754,1755,-1,1736,1755,1737,-1,1737,1755,1756,-1,1737,1756,1738,-1,1738,1756,1757,-1,1738,1757,1739,-1,1739,1757,1758,-1,1739,1758,1740,-1,1740,1758,1759,-1,1740,1759,1741,-1,1741,1759,1760,-1,1741,1760,1742,-1,1742,1760,1761,-1,1742,1761,1743,-1,1743,1761,1762,-1,1743,1762,1744,-1,1744,1762,1745,-1,1744,1745,1727,-1,1763,1746,1745,-1,1763,1747,1746,-1,1763,1748,1747,-1,1763,1749,1748,-1,1763,1750,1749,-1,1763,1751,1750,-1,1763,1752,1751,-1,1763,1753,1752,-1,1763,1754,1753,-1,1763,1755,1754,-1,1763,1756,1755,-1,1763,1757,1756,-1,1763,1758,1757,-1,1763,1759,1758,-1,1763,1760,1759,-1,1763,1761,1760,-1,1763,1762,1761,-1,1763,1745,1762,-1,1764,1765,1766,-1,1764,1766,1767,-1,1764,1767,1768,-1,1764,1768,1769,-1,1764,1769,1770,-1,1764,1770,1771,-1,1764,1771,1772,-1,1764,1772,1773,-1,1764,1773,1774,-1,1764,1774,1775,-1,1764,1775,1776,-1,1764,1776,1777,-1,1764,1777,1778,-1,1764,1778,1779,-1,1764,1779,1780,-1,1764,1780,1781,-1,1764,1781,1782,-1,1764,1782,1765,-1,1765,1783,1784,-1,1765,1784,1766,-1,1766,1784,1785,-1,1766,1785,1767,-1,1767,1785,1786,-1,1767,1786,1768,-1,1768,1786,1787,-1,1768,1787,1769,-1,1769,1787,1788,-1,1769,1788,1770,-1,1770,1788,1789,-1,1770,1789,1771,-1,1771,1789,1790,-1,1771,1790,1772,-1,1772,1790,1791,-1,1772,1791,1773,-1,1773,1791,1792,-1,1773,1792,1774,-1,1774,1792,1793,-1,1774,1793,1775,-1,1775,1793,1794,-1,1775,1794,1776,-1,1776,1794,1795,-1,1776,1795,1777,-1,1777,1795,1796,-1,1777,1796,1778,-1,1778,1796,1797,-1,1778,1797,1779,-1,1779,1797,1798,-1,1779,1798,1780,-1,1780,1798,1799,-1,1780,1799,1781,-1,1781,1799,1800,-1,1781,1800,1782,-1,1782,1800,1783,-1,1782,1783,1765,-1,1783,1801,1802,-1,1783,1802,1784,-1,1784,1802,1803,-1,1784,1803,1785,-1,1785,1803,1804,-1,1785,1804,1786,-1,1786,1804,1805,-1,1786,1805,1787,-1,1787,1805,1806,-1,1787,1806,1788,-1,1788,1806,1807,-1,1788,1807,1789,-1,1789,1807,1808,-1,1789,1808,1790,-1,1790,1808,1809,-1,1790,1809,1791,-1,1791,1809,1810,-1,1791,1810,1792,-1,1792,1810,1811,-1,1792,1811,1793,-1,1793,1811,1812,-1,1793,1812,1794,-1,1794,1812,1813,-1,1794,1813,1795,-1,1795,1813,1814,-1,1795,1814,1796,-1,1796,1814,1815,-1,1796,1815,1797,-1,1797,1815,1816,-1,1797,1816,1798,-1,1798,1816,1817,-1,1798,1817,1799,-1,1799,1817,1818,-1,1799,1818,1800,-1,1800,1818,1801,-1,1800,1801,1783,-1,1801,1819,1820,-1,1801,1820,1802,-1,1802,1820,1821,-1,1802,1821,1803,-1,1803,1821,1822,-1,1803,1822,1804,-1,1804,1822,1823,-1,1804,1823,1805,-1,1805,1823,1824,-1,1805,1824,1806,-1,1806,1824,1825,-1,1806,1825,1807,-1,1807,1825,1826,-1,1807,1826,1808,-1,1808,1826,1827,-1,1808,1827,1809,-1,1809,1827,1828,-1,1809,1828,1810,-1,1810,1828,1829,-1,1810,1829,1811,-1,1811,1829,1830,-1,1811,1830,1812,-1,1812,1830,1831,-1,1812,1831,1813,-1,1813,1831,1832,-1,1813,1832,1814,-1,1814,1832,1833,-1,1814,1833,1815,-1,1815,1833,1834,-1,1815,1834,1816,-1,1816,1834,1835,-1,1816,1835,1817,-1,1817,1835,1836,-1,1817,1836,1818,-1,1818,1836,1819,-1,1818,1819,1801,-1,1819,1837,1838,-1,1819,1838,1820,-1,1820,1838,1839,-1,1820,1839,1821,-1,1821,1839,1840,-1,1821,1840,1822,-1,1822,1840,1841,-1,1822,1841,1823,-1,1823,1841,1842,-1,1823,1842,1824,-1,1824,1842,1843,-1,1824,1843,1825,-1,1825,1843,1844,-1,1825,1844,1826,-1,1826,1844,1845,-1,1826,1845,1827,-1,1827,1845,1846,-1,1827,1846,1828,-1,1828,1846,1847,-1,1828,1847,1829,-1,1829,1847,1848,-1,1829,1848,1830,-1,1830,1848,1849,-1,1830,1849,1831,-1,1831,1849,1850,-1,1831,1850,1832,-1,1832,1850,1851,-1,1832,1851,1833,-1,1833,1851,1852,-1,1833,1852,1834,-1,1834,1852,1853,-1,1834,1853,1835,-1,1835,1853,1854,-1,1835,1854,1836,-1,1836,1854,1837,-1,1836,1837,1819,-1,1837,1855,1856,-1,1837,1856,1838,-1,1838,1856,1857,-1,1838,1857,1839,-1,1839,1857,1858,-1,1839,1858,1840,-1,1840,1858,1859,-1,1840,1859,1841,-1,1841,1859,1860,-1,1841,1860,1842,-1,1842,1860,1861,-1,1842,1861,1843,-1,1843,1861,1862,-1,1843,1862,1844,-1,1844,1862,1863,-1,1844,1863,1845,-1,1845,1863,1864,-1,1845,1864,1846,-1,1846,1864,1865,-1,1846,1865,1847,-1,1847,1865,1866,-1,1847,1866,1848,-1,1848,1866,1867,-1,1848,1867,1849,-1,1849,1867,1868,-1,1849,1868,1850,-1,1850,1868,1869,-1,1850,1869,1851,-1,1851,1869,1870,-1,1851,1870,1852,-1,1852,1870,1871,-1,1852,1871,1853,-1,1853,1871,1872,-1,1853,1872,1854,-1,1854,1872,1855,-1,1854,1855,1837,-1,1855,1873,1874,-1,1855,1874,1856,-1,1856,1874,1875,-1,1856,1875,1857,-1,1857,1875,1876,-1,1857,1876,1858,-1,1858,1876,1877,-1,1858,1877,1859,-1,1859,1877,1878,-1,1859,1878,1860,-1,1860,1878,1879,-1,1860,1879,1861,-1,1861,1879,1880,-1,1861,1880,1862,-1,1862,1880,1881,-1,1862,1881,1863,-1,1863,1881,1882,-1,1863,1882,1864,-1,1864,1882,1883,-1,1864,1883,1865,-1,1865,1883,1884,-1,1865,1884,1866,-1,1866,1884,1885,-1,1866,1885,1867,-1,1867,1885,1886,-1,1867,1886,1868,-1,1868,1886,1887,-1,1868,1887,1869,-1,1869,1887,1888,-1,1869,1888,1870,-1,1870,1888,1889,-1,1870,1889,1871,-1,1871,1889,1890,-1,1871,1890,1872,-1,1872,1890,1873,-1,1872,1873,1855,-1,1873,1891,1892,-1,1873,1892,1874,-1,1874,1892,1893,-1,1874,1893,1875,-1,1875,1893,1894,-1,1875,1894,1876,-1,1876,1894,1895,-1,1876,1895,1877,-1,1877,1895,1896,-1,1877,1896,1878,-1,1878,1896,1897,-1,1878,1897,1879,-1,1879,1897,1898,-1,1879,1898,1880,-1,1880,1898,1899,-1,1880,1899,1881,-1,1881,1899,1900,-1,1881,1900,1882,-1,1882,1900,1901,-1,1882,1901,1883,-1,1883,1901,1902,-1,1883,1902,1884,-1,1884,1902,1903,-1,1884,1903,1885,-1,1885,1903,1904,-1,1885,1904,1886,-1,1886,1904,1905,-1,1886,1905,1887,-1,1887,1905,1906,-1,1887,1906,1888,-1,1888,1906,1907,-1,1888,1907,1889,-1,1889,1907,1908,-1,1889,1908,1890,-1,1890,1908,1891,-1,1890,1891,1873,-1,1909,1892,1891,-1,1909,1893,1892,-1,1909,1894,1893,-1,1909,1895,1894,-1,1909,1896,1895,-1,1909,1897,1896,-1,1909,1898,1897,-1,1909,1899,1898,-1,1909,1900,1899,-1,1909,1901,1900,-1,1909,1902,1901,-1,1909,1903,1902,-1,1909,1904,1903,-1,1909,1905,1904,-1,1909,1906,1905,-1,1909,1907,1906,-1,1909,1908,1907,-1,1909,1891,1908,-1],
          coord=Coordinate(point=[(-0.5879,48.97,1.14),(1.744,48.97,0.9643),(2.016,48.97,2.089),(1.142,48.97,4.24),(-0.01936,48.97,3.471),(-1.189,48.97,2.664),(-2.022,48.97,1.828),(-2.919,48.97,0.6589),(-3.886,48.97,-0.5033),(-1.498,48.97,-1.374),(-0.3805,48.97,-1.192),(0.8335,48.97,0.2019),(0.1528,48.97,-0.2422),(4.205,48.75,1.195),(3.524,48.75,3.001),(1.819,48.75,4.666),(0.06344,48.75,5.523),(-2.752,48.75,4.969),(-4.393,48.75,3.323),(-4.937,48.75,0.5888),(-4.035,48.75,-1.248),(-2.371,48.75,-2.949),(-0.6534,48.75,-3.619),(2.2,48.75,-3.251),(3.882,48.75,-1.57),(5.533,47.23,1.342),(3.718,47.23,4.997),(4.017,47.23,6.444),(0.8267,47.23,8.619),(-2.839,47.23,8.458),(-8.158,47.23,3.573),(-8.181,47.23,-0.05671),(-5.777,47.23,-3.284),(-4.523,47.23,-3.418),(-0.8274,47.23,-5.094),(2.333,47.23,-5.432),(6.099,47.23,-1.86),(9.039,45.19,0.5944),(7.124,45.19,6.065),(4.066,45.19,8.032),(-0.1042,45.19,9.872),(-5.076,45.19,9.231),(-8.711,45.19,5.641),(-9.245,45.19,0.7306),(-7.293,45.19,-3.501),(-5.578,45.19,-6.604),(0.05687,45.19,-8.413),(3.564,45.19,-7.803),(8.542,45.19,-3.077),(11.96,40.85,-0.9924),(10.09,40.85,4.812),(6.919,40.85,8.952),(0.6979,40.85,11.09),(-4.223,40.85,9.923),(-9.213,40.85,5.073),(-10.32,40.85,0.05221),(-8.066,40.85,-6.069),(-3.914,40.85,-9.376),(1.933,40.85,-11.19),(7.228,40.85,-10.35),(11.23,40.85,-6.33),(12.5,34.92,1.141),(10.97,34.92,5.758),(7.429,34.92,9.409),(1.883,34.92,11.16),(-3.998,34.92,9.63),(-8.821,34.92,4.905),(-10.36,34.92,-0.9503),(-8.561,34.92,-6.522),(-5.006,34.92,-10.16),(-0.5893,34.92,-11.69),(6.421,34.92,-10.38),(11.23,34.92,-5.67),(12.24,28.78,1.132),(11.2,28.78,7.209),(6.031,28.78,11.11),(-1.38,28.78,11.39),(-5.397,28.78,9.439),(-8.596,28.78,6.088),(-10.62,28.78,1.81),(-10.57,28.78,-5.339),(-6.722,28.78,-10.35),(-0.5782,28.78,-11.47),(4.706,28.78,-8.682),(9.22,28.78,-4.219),(12.79,22.64,0.8516),(9.373,22.64,4.617),(4.291,22.64,9.243),(-0.3146,22.64,10.91),(-7.137,22.64,10.98),(-10.42,22.64,7.56),(-10.06,22.64,0.9086),(-8.364,22.64,-3.868),(-3.657,22.64,-8.811),(-0.2472,22.64,-11.94),(7.771,22.64,-10.55),(11.43,22.64,-6.811),(12.52,16.5,-0.2965),(10.02,16.5,5.154),(5.588,16.5,10.1),(0.3852,16.5,11.15),(-5.839,16.5,10.44),(-9.774,16.5,6.462),(-10.34,16.5,0.3167),(-9.382,16.5,-4.965),(-4.293,16.5,-9.358),(1.11,16.5,-11.71),(7.135,16.5,-9.689),(10.41,16.5,-6.273),(12.87,10.37,-0.7769),(11.27,10.37,5.012),(6.505,10.37,10.02),(0.3397,10.37,10.85),(-4.922,10.37,9.379),(-8.524,10.37,5.687),(-9.99,10.37,0.3552),(-9.286,10.37,-5.741),(-4.124,10.37,-10.41),(1.678,10.37,-12),(7.303,10.37,-9.771),(10.51,10.37,-6.416),(13.68,4.229,-0.5864),(10.58,4.229,4.967),(6.101,4.229,8.633),(0.5457,4.229,10.16),(-5.327,4.229,9.961),(-9.213,4.229,6.029),(-9.175,4.229,0.1809),(-7.642,4.229,-5.398),(-4.071,4.229,-9.833),(1.453,4.229,-12.69),(7.357,4.229,-11.16),(12.15,4.229,-6.461),(12.49,-1.909,-1.072),(10.97,-1.909,5.694),(4.938,-1.909,9.001),(0.747,-1.909,11.18),(-6.489,-1.909,9.63),(-8.822,-1.909,7.012),(-10.37,-1.909,0.01064),(-8.078,-1.909,-4.415),(-4.931,-1.909,-10.16),(2.027,-1.909,-11.68),(6.497,-1.909,-10.79),(11.71,-1.909,-5.734),(12.39,-8.046,0.2026),(11.4,-8.046,5.788),(8.571,-8.046,10.09),(-0.421,-8.046,11.26),(-2.856,-8.046,9.264),(-8.389,-8.046,3.939),(-10.47,-8.046,0.9986),(-9.364,-8.046,-7.488),(-5.042,-8.046,-10.53),(0.5201,-8.046,-11.6),(6.385,-8.046,-9.705),(10.43,-8.046,-5.639),(14.11,-14.18,-0.4153),(10.45,-14.18,4.364),(7.517,-14.18,10.96),(0.73,-14.18,9.8),(-3.911,-14.18,10.07),(-9.344,-14.18,4.832),(-8.744,-14.18,0.02503),(-10.4,-14.18,-6.596),(-3.358,-14.18,-9.722),(1.251,-14.18,-13.06),(8.07,-14.18,-8.831),(9.397,-14.18,-7.064),(12.27,-20.32,-0.08371),(11.39,-20.32,5.712),(7.928,-20.32,9.989),(1.679,-20.32,11.36),(-3.499,-20.32,9.275),(-8.402,-20.32,4.483),(-10.59,-20.32,-0.7775),(-9.246,-20.32,-6.944),(-4.952,-20.32,-10.52),(0.8586,-20.32,-11.5),(6.475,-20.32,-9.804),(10.55,-20.32,-5.716),(13.85,-26.46,-0.2278),(12.68,-26.46,6.005),(6.475,-26.46,9.731),(1.924,-26.46,10.02),(-4.952,-26.46,8.188),(-7.117,-26.46,5.712),(-9.006,-26.46,-0.9845),(-8.941,-26.46,-5.715),(-5.298,-26.46,-11.61),(1.029,-26.46,-12.83),(6.129,-26.46,-10.06),(10.85,-26.46,-5.423),(13.79,-32.39,-1.287),(13.48,-32.39,5.516),(8.783,-32.39,9.75),(1.717,-32.39,9.548),(-2.359,-32.39,7.053),(-5.82,-32.39,3.497),(-8.498,-32.39,-0.8099),(-9.009,-32.39,-7.645),(-4.746,-32.39,-12.25),(2.282,-32.39,-12.74),(6.396,-32.39,-9.548),(10.29,-32.39,-5.626),(11.85,-36.73,0.6215),(9.795,-36.73,4.725),(6.473,-36.73,7.505),(2.386,-36.73,7.494),(-2.669,-36.73,6.971),(-6.039,-36.73,3.605),(-6.434,-36.73,-1.375),(-6.671,-36.73,-5.538),(-3.993,-36.73,-8.863),(0.02483,-36.73,-10.79),(5.149,-36.73,-8.329),(9.164,-36.73,-4.417),(9.476,-38.78,0.4821),(8.311,-38.78,3.915),(5.742,-38.78,4.633),(1.28,-38.78,5.284),(-1.115,-38.78,4.574),(-3.565,-38.78,2.114),(-4.238,-38.78,-0.44),(-3.635,-38.78,-4.742),(-3.244,-38.78,-7.302),(0.1896,-38.78,-8.429),(3.612,-38.78,-7.243),(8.241,-38.78,-2.941),(5.062,-40.3,-1.451),(4.695,-40.3,1.545),(4.427,-40.3,3.306),(1.442,-40.3,4.798),(-0.1438,-40.3,3.978),(-3.222,-40.3,1.117),(-4.08,-40.3,-0.5775),(-2.427,-40.3,-3.455),(-0.6502,-40.3,-3.939),(2.476,-40.3,-4.344),(3.921,-40.3,-4.611),(5.49,-40.3,-3.026),(2.633,-40.52,-0.3656),(1.765,-40.52,0.6027),(1.726,-40.52,0.4092),(0.6103,-40.52,2.719),(-0.6057,-40.52,2.877),(-2.273,-40.52,1.335),(-2.03,-40.52,0.1263),(0.6439,-40.52,-0.997),(0.2596,-40.52,-1.162),(1.192,-40.52,-1.944),(2.591,-40.52,-3.629),(4.682,-40.52,-1.729),(0.3014,-40.52,0.3876),(1.241,48.97,2.24),(1.101,48.97,3.346),(0.2656,48.97,3.166),(-0.5226,48.97,2.308),(-1.052,48.97,1.698),(-1.701,48.97,1.145),(-2.715,48.97,0.357),(-3,48.97,-0.4552),(-1.817,48.97,-0.634),(-1.029,48.97,0.2237),(-0.8465,48.97,1.192),(0.2269,48.97,1.452),(3.348,48.97,2.108),(2.378,48.97,3.47),(-0.04273,48.97,5.582),(-1.816,48.97,3.92),(-2.468,48.97,3.103),(-3.271,48.97,2.315),(-5.237,48.97,0.5419),(-2.901,48.97,-1.742),(-1.571,48.97,-2.699),(0.2022,48.97,-1.037),(1.944,48.97,-1.375),(1.382,48.97,0.3347),(4.55,48.1,2.9),(2.643,48.1,4.609),(0.5079,48.1,7.241),(-2.448,48.1,6.975),(-5.433,48.1,5.86),(-6.482,48.1,2.941),(-6.796,48.1,-0.01503),(-3.953,48.1,-2.215),(-2.399,48.1,-4.057),(0.5565,48.1,-3.791),(4.123,48.1,-3.467),(4.236,48.1,-0.05612),(7.001,46.38,3.393),(5.472,46.38,6.419),(2.588,46.38,9.125),(-1.551,46.38,8.975),(-5.835,46.38,6.449),(-8.443,46.38,2.273),(-8.621,46.38,-1.865),(-5.799,46.38,-4.857),(-2.874,46.38,-6.47),(1.264,46.38,-6.32),(5.507,46.38,-4.887),(6.824,46.38,-0.7458),(9.765,43.3,2.067),(7.681,43.3,6.9),(4.525,43.3,9.628),(-0.7955,43.3,10.71),(-6.855,43.3,7.561),(-10.09,43.3,1.726),(-8.813,43.3,-3.595),(-6.073,43.3,-6.975),(-1.2,43.3,-9.148),(4.121,43.3,-10.23),(8.463,43.3,-7.637),(11.04,43.3,-3.253),(12.63,37.98,3.038),(8.093,37.98,7.705),(4.055,37.98,9.874),(-1.857,37.98,10.32),(-8.059,37.98,8.704),(-9.43,37.98,2.669),(-8.903,37.98,-3.243),(-6.877,37.98,-7.448),(-2.293,37.98,-11.74),(3.619,37.98,-12.19),(9.274,37.98,-8.447),(13.16,37.98,-2.874),(12.03,31.85,2.498),(10.26,31.85,6.666),(2.739,31.85,11.02),(-3.173,31.85,10.83),(-5.896,31.85,6.875),(-10.03,31.85,3.782),(-10.26,31.85,-2.13),(-5.65,31.85,-9.277),(-1.655,31.85,-11.24),(4.257,31.85,-11.04),(10.5,31.85,-9.485),(11.8,31.85,-3.414),(11.04,25.71,3.818),(9.116,25.71,9.844),(1.032,25.71,9.961),(-4.88,25.71,11.66),(-7.035,25.71,7.838),(-11.02,25.71,5.226),(-9.007,25.71,-0.6861),(-9.407,25.71,-8.313),(-3.215,25.71,-10.4),(2.697,25.71,-12.1),(6.744,25.71,-6.307),(13.06,25.71,-2.094),(12.26,19.57,2.126),(8.016,19.57,7.616),(2.645,19.57,11.98),(-3.267,19.57,10.64),(-8.135,19.57,8.769),(-9.804,19.57,3.861),(-11.39,19.57,-2.051),(-6.772,19.57,-7.383),(-1.215,19.57,-11.43),(4.697,19.57,-10.09),(9.38,19.57,-8.536),(10.68,19.57,-3.786),(10.94,13.44,2.179),(9.47,13.44,7.581),(4.527,13.44,12.06),(-1.385,13.44,11.75),(-6.681,13.44,7.539),(-11.13,13.44,2.27),(-11.48,13.44,-3.642),(-6.731,13.44,-8.613),(-1.278,13.44,-10.31),(4.634,13.44,-10.01),(9.421,13.44,-8.571),(10.58,13.44,-3.733),(9.713,7.298,1.706),(9.541,7.298,7.328),(3.816,7.298,10.33),(-2.096,7.298,12.79),(-6.61,7.298,7.479),(-12.35,7.298,2.871),(-9.443,7.298,-3.041),(-6.432,7.298,-8.673),(-0.7182,7.298,-9.274),(5.194,7.298,-11.73),(9.72,7.298,-8.824),(12.62,7.298,-4.206),(11.3,1.16,2.437),(9.318,1.16,7.164),(4.554,1.16,9.47),(-1.358,1.16,11.45),(-6.834,1.16,7.668),(-10.76,1.16,2.247),(-8.426,1.16,-3.665),(-6.239,1.16,-8.484),(-1.583,1.16,-10.62),(4.329,1.16,-12.59),(9.913,1.16,-8.987),(13.64,1.16,-3.475),(10.33,-4.977,2.138),(7.568,-4.977,6.399),(1.472,-4.977,11.61),(-4.44,-4.977,12.27),(-8.583,-4.977,9.148),(-11.73,-4.977,4.853),(-10.96,-4.977,-1.059),(-5.334,-4.977,-7.004),(-1.229,-4.977,-9.796),(4.683,-4.977,-10.45),(10.82,-4.977,-9.753),(11.11,-4.977,-3.774),(10.89,-11.11,2.966),(10.29,-11.11,6.061),(4.258,-11.11,9.347),(-1.654,-11.11,11.79),(-5.862,-11.11,6.846),(-11.17,-11.11,2.497),(-8.281,-11.11,-3.415),(-4.934,-11.11,-9.306),(-2.208,-11.11,-10.27),(3.704,-11.11,-12.72),(11.22,-11.11,-10.09),(13.78,-11.11,-2.946),(13.54,-17.25,2.764),(9.601,-17.25,7.464),(4.714,-17.25,12.29),(-1.197,-17.25,9.554),(-6.551,-17.25,7.428),(-8.525,-17.25,2.111),(-11.76,-17.25,-3.801),(-6.593,-17.25,-8.723),(-1.97,-17.25,-12.51),(3.942,-17.25,-9.775),(9.558,-17.25,-8.687),(10.31,-17.25,-3.148),(12.87,-23.39,3.251),(9.172,-23.39,7.978),(5.604,-23.39,11.34),(-0.3078,-23.39,10.12),(-6.98,-23.39,7.791),(-9.19,-23.39,1.359),(-10.64,-23.39,-4.553),(-7.2,-23.39,-8.36),(-2.546,-23.39,-11.95),(3.366,-23.39,-10.72),(8.951,-23.39,-8.174),(11.42,-23.39,-2.66),(12.71,-29.53,2.824),(10.58,-29.53,8.323),(5.688,-29.53,11.01),(-0.2244,-29.53,10.26),(-5.573,-29.53,6.601),(-9.355,-29.53,1.288),(-10.24,-29.53,-4.624),(-7.608,-29.53,-9.55),(-2.041,-29.53,-11.81),(3.871,-29.53,-11.06),(8.543,-29.53,-7.829),(11.82,-29.53,-3.087),(12.04,-34.84,2.315),(8.364,-34.84,6.7),(5.126,-34.84,7.769),(-0.1943,-34.84,8.784),(-6.172,-34.84,6.984),(-7.815,-34.84,1.217),(-6.616,-34.84,-4.104),(-5.837,-34.84,-7.552),(-1.493,-34.84,-11.07),(3.828,-34.84,-12.09),(8.7,-34.84,-7.836),(13.24,-34.84,-3.005),(10.05,-37.93,1.889),(9.596,-37.93,5.988),(3.562,-37.93,6.456),(-0.5768,-37.93,6.394),(-1.71,-37.93,2.96),(-5.392,-37.93,1.449),(-5.466,-37.93,-2.689),(-5.29,-37.93,-8.346),(-1.096,-37.93,-9.05),(3.042,-37.93,-8.988),(6.016,-37.93,-5.318),(9.979,-37.93,-2.249),(6.689,-39.64,1.556),(6.031,-39.64,2.948),(3.681,-39.64,4.657),(0.725,-39.64,5.166),(-2.045,-39.64,2.994),(-4.343,-39.64,0.2572),(-3.74,-39.64,-2.699),(-1.99,-39.64,-5.081),(-0.8103,-39.64,-5.866),(2.146,-39.64,-6.375),(6.086,-39.64,-5.128),(7.291,-39.64,-1.4),(2.668,-40.52,0.7339),(3.033,-40.52,2.057),(2.503,-40.52,1.726),(0.7296,-40.52,4.495),(-1.812,-40.52,2.549),(-3.951,-40.52,0.1621),(-0.6778,-40.52,-1.611),(-1.231,-40.52,-2.297),(0.05362,-40.52,-2.124),(1.827,-40.52,-4.893),(3.614,-40.52,-2.788),(5.941,-40.52,-1.04),(0.9685,-40.52,-0.9961),(0.6845,-40.52,-0.5579),(0.5131,-40.52,0.8345),(-0.2752,-40.52,2.538),(-1.469,-40.52,2.051),(-1.973,-40.52,0.936),(0.0412,-40.52,0.1477),(1.616,-40.52,-0.1025),(2.009,-40.52,-0.4035),(2.797,-40.52,-2.107),(3.769,-40.52,-2.711),(2.983,-40.52,-1.784),(1.115,48.97,2.896),(2.238,48.97,1.556),(0.7388,48.97,2.073),(0.6664,48.97,3.248),(1.571,48.97,3.09),(-0.08088,48.97,2.466),(0.6025,48.97,4.338),(-0.6603,48.97,1.82),(-0.6291,48.97,2.992),(-1.182,48.97,1.303),(-1.794,48.97,2.419),(-1.915,48.97,0.7109),(-2.359,48.97,1.27),(-2.871,48.97,-0.02342),(-3.95,48.97,0.0379),(-2.543,48.97,-0.478),(-2.587,48.97,-0.9456),(-1.692,48.97,-0.1869),(-0.9672,48.97,-1.605),(-1.216,48.97,0.9499),(0.2644,48.97,-0.2587),(-0.5729,48.97,1.569),(0.7779,48.97,-0.2749),(0.6465,48.97,0.3239),(4.381,48.75,2.252),(2.84,48.97,1.098),(2.865,48.97,3.103),(2.089,48.75,4.204),(1.124,48.97,4.313),(1.2,48.75,6.388),(-0.9291,48.97,4.568),(-1.165,48.75,5.082),(-2.305,48.97,3.699),(-4.371,48.75,4.838),(-3.073,48.97,2.856),(-4.444,48.75,1.81),(-4.016,48.97,1.428),(-5.989,48.75,-0.5546),(-3.799,48.97,-0.5721),(-3.622,48.75,-1.623),(-2.597,48.97,-2.239),(-1.687,48.75,-3.743),(-0.5387,48.97,-2.289),(0.6779,48.75,-2.437),(0.8315,48.97,-1.625),(2.839,48.75,-2.257),(2.139,48.97,-0.3251),(2.837,48.75,-0.1132),(5.143,47.23,3.358),(5.149,48.1,1.37),(3.65,48.1,4.114),(4.452,47.23,5.584),(1.908,48.1,4.979),(2.721,47.23,8.56),(-0.747,48.1,6.834),(-0.8257,47.23,8.51),(-3.806,48.1,6.689),(-5.239,47.23,5.821),(-6.247,48.1,4.302),(-8.095,47.23,1.614),(-6.278,48.1,1.274),(-8.154,47.23,-1.933),(-4.225,48.1,-1.412),(-4.96,47.23,-3.87),(-3.583,48.1,-3.207),(-2.887,47.23,-4.728),(-0.8605,48.1,-4.594),(0.6599,47.23,-4.678),(2.13,48.1,-4.918),(4.731,47.23,-4.107),(5.672,48.1,-1.6),(5.084,47.23,-0.1892),(8.178,45.19,3.221),(7.429,46.38,1.206),(5.354,46.38,4.902),(6.589,45.19,6.865),(4.908,46.38,7.477),(2.104,45.19,10.15),(0.3774,46.38,9.125),(-2.625,45.19,10.02),(-3.091,46.38,8.901),(-6.332,45.19,6.995),(-8.501,46.38,3.874),(-9.473,45.19,3.228),(-8.57,46.38,0.3233),(-9.635,45.19,-1.502),(-6.817,46.38,-4.126),(-6.18,45.19,-5.927),(-4.307,46.38,-4.954),(-2.618,45.19,-7.635),(-0.6665,46.38,-6.874),(2.112,45.19,-7.498),(3.692,46.38,-6.379),(6.742,45.19,-6.056),(7.038,46.38,-3.097),(8.015,45.19,-1.508),(10.9,40.85,2.018),(9.34,43.3,-0.4873),(9.206,43.3,4.197),(8.895,40.85,7.49),(7.138,43.3,9.594),(3.668,40.85,11.53),(1.424,43.3,11.73),(-2.096,40.85,11.28),(-3.147,43.3,9.297),(-6.853,40.85,7.653),(-8.608,43.3,4.097),(-10.62,40.85,2.86),(-11.23,43.3,-0.5619),(-10.91,40.85,-2.904),(-8.959,43.3,-6.188),(-6.66,40.85,-8.095),(-3.265,43.3,-8.517),(-1.101,40.85,-10.23),(1.336,43.3,-8.843),(4.663,40.85,-9.985),(7.02,43.3,-8.22),(9.087,40.85,-8.258),(8.855,43.3,-6.088),(10.6,40.85,-3.746),(12.94,34.92,3.249),(12.31,37.98,0.4079),(9.237,37.98,4.11),(9.511,34.92,7.444),(8.303,37.98,8.66),(4.643,34.92,10.75),(1.079,37.98,11.33),(-1.269,34.92,10.06),(-3.125,37.98,11.1),(-6.641,34.92,7.505),(-10.56,37.98,4.167),(-9.127,34.92,2.172),(-10.55,37.98,-0.27),(-9.933,34.92,-3.74),(-7.674,37.98,-7.261),(-6.569,34.92,-8.647),(-3.057,37.98,-8.696),(-2.543,34.92,-12),(0.2774,37.98,-11.53),(3.369,34.92,-11.32),(8.37,37.98,-11.13),(9.583,34.92,-8.708),(12.12,37.98,-7.318),(12.13,34.92,-2.663),(11.64,28.78,3.912),(12.71,31.85,-0.2733),(11.95,31.85,3.918),(8.105,28.78,7.723),(7.818,31.85,8.764),(1.456,28.78,12.04),(-0.7805,31.85,10.99),(-4.456,28.78,11.16),(-3.61,31.85,8.804),(-8.046,28.78,8.693),(-7.845,31.85,4.577),(-10.43,28.78,4.867),(-10.15,31.85,1.303),(-11.47,28.78,-1.045),(-7.797,31.85,-6.851),(-6.899,28.78,-7.458),(-2.831,31.85,-10.99),(-3.327,28.78,-10.9),(1.083,31.85,-11.87),(2.585,28.78,-10.02),(8.597,31.85,-11.03),(9.252,28.78,-8.428),(12,31.85,-7.51),(10.6,28.78,-1.999),(12.27,22.64,3.963),(13.7,25.71,1.063),(9.899,25.71,5.956),(6.992,22.64,8.076),(4.598,25.71,9.61),(2.708,22.64,10.97),(-2.41,25.71,10.15),(-3.204,22.64,10.63),(-6.83,25.71,10.54),(-9.159,22.64,9.635),(-9.895,25.71,7.3),(-9.793,22.64,3.808),(-9.156,25.71,2.681),(-10.2,22.64,-2.103),(-8.798,25.71,-4.128),(-7.317,22.64,-6.517),(-5.241,25.71,-9.256),(-3.387,22.64,-11.44),(-0.4971,25.71,-12.71),(2.525,22.64,-11.09),(6.187,25.71,-10.18),(8.835,22.64,-8.075),(11,25.71,-5.472),(11.87,22.64,-1.949),(11.51,16.5,2.293),(11.99,19.57,-1.064),(11.04,19.57,5.298),(8.776,16.5,8.54),(7.223,19.57,8.91),(3.391,16.5,12.88),(0.2653,19.57,11.6),(-2.52,16.5,11.27),(-4.205,19.57,9.576),(-7.376,16.5,8.126),(-8.758,19.57,5.08),(-10.55,16.5,3.23),(-10.87,19.57,0.4181),(-12.46,16.5,-2.682),(-7.971,19.57,-6.348),(-7.865,16.5,-8.025),(-4.462,19.57,-10.22),(-1.413,16.5,-10.8),(2.018,19.57,-11.26),(4.499,16.5,-9.18),(6.965,19.57,-10.88),(8.287,16.5,-7.612),(11.82,19.57,-6.13),(9.602,16.5,-3.618),(11.58,10.37,2.247),(10.33,13.44,-1.28),(10.38,13.44,5.097),(8.837,10.37,8.01),(7.931,13.44,9.578),(2.981,10.37,10.3),(1.529,13.44,13),(-2.931,10.37,11.21),(-3.497,13.44,10.13),(-7.315,10.37,8.075),(-9.413,13.44,4.481),(-10.48,10.37,3.577),(-12.52,13.44,-0.6507),(-9.406,10.37,-2.335),(-8.76,13.44,-6.946),(-7.238,10.37,-8.077),(-4.225,13.44,-9.663),(-1.358,10.37,-10.86),(2.273,13.44,-9.86),(4.554,10.37,-11.76),(7.203,13.44,-10.22),(8.913,10.37,-8.142),(11.03,13.44,-6.33),(12.66,10.37,-3.665),(11.34,4.229,2.371),(12.43,7.298,-1.335),(10.26,7.298,5.301),(8.141,4.229,7.34),(6.905,7.298,9.518),(3.723,4.229,10.12),(0.8133,7.298,11.22),(-2.189,4.229,11.41),(-4.523,7.298,10.23),(-8.01,4.229,8.663),(-9.529,7.298,5.349),(-10.72,4.229,2.949),(-10.42,7.298,-0.04542),(-9.192,4.229,-2.962),(-8.689,7.298,-6.079),(-6.446,4.229,-7.489),(-4.467,7.298,-9.565),(-1.505,4.229,-10.65),(2.338,7.298,-11.63),(4.407,4.229,-11.94),(6.961,7.298,-10.28),(9.706,4.229,-8.812),(11.1,7.298,-6.126),(12.87,4.229,-3.541),(11.45,-1.909,2.032),(12.85,1.16,-0.7801),(12.11,1.16,5.073),(8.103,-1.909,7.455),(5.573,1.16,7.967),(3.643,-1.909,9.122),(1.776,1.16,10.87),(-2.269,-1.909,11.32),(-5.855,1.16,8.666),(-8.049,-1.909,8.695),(-7.682,1.16,6.476),(-10.62,-1.909,3.017),(-10.01,1.16,-0.8594),(-8.014,-1.909,-2.895),(-6.855,1.16,-4.952),(-6.583,-1.909,-7.456),(-4.197,1.16,-11.13),(-1.104,-1.909,-10.74),(1.682,1.16,-11.99),(4.808,-1.909,-12.94),(7.231,1.16,-11.83),(9.569,-1.909,-8.696),(12.94,1.16,-6.354),(14.05,-1.909,-3.88),(11.82,-8.046,2.701),(11.39,-4.977,-0.6088),(9.493,-4.977,4.906),(8.702,-8.046,8.337),(5.725,-4.977,9.763),(2.854,-8.046,9.67),(-1.565,-4.977,12.1),(-3.058,-8.046,11),(-5.703,-4.977,10.88),(-7.45,-8.046,8.189),(-10.3,-4.977,6.347),(-10.24,-8.046,3.684),(-11.46,-4.977,1.966),(-8.663,-8.046,-2.228),(-8.979,-4.977,-5.081),(-7.625,-8.046,-7.963),(-3.999,-4.977,-8.913),(-1.895,-8.046,-11.06),(1.479,-4.977,-10.76),(4.017,-8.046,-12.39),(7.429,-4.977,-10.03),(8.527,-8.046,-7.815),(10.81,-4.977,-6.522),(13.4,-8.046,-3.211),(11.36,-14.18,2.683),(13.09,-11.11,0.2308),(11.99,-11.11,3.843),(9.224,-14.18,7.443),(6.55,-11.11,8.734),(4.069,-14.18,10.43),(1.619,-11.11,10.66),(-1.843,-14.18,11.39),(-4.878,-11.11,8.768),(-6.927,-14.18,7.747),(-7.803,-11.11,5.649),(-10.7,-14.18,2.657),(-9.766,-11.11,-0.7265),(-9.563,-14.18,-3.255),(-7.763,-11.11,-5.779),(-6.568,-14.18,-8.405),(-2.742,-11.11,-11.03),(-1.874,-14.18,-10.67),(0.4868,-11.11,-12.19),(4.038,-14.18,-11.63),(8.686,-11.11,-11.06),(9.584,-14.18,-8.709),(12.03,-11.11,-7.585),(12.5,-14.18,-3.229),(12.38,-20.32,2.98),(12.28,-17.25,0.317),(11.44,-17.25,5.299),(9.187,-20.32,9.128),(6.898,-17.25,10.51),(4.548,-20.32,11.55),(1.77,-17.25,11.35),(-1.364,-20.32,10.54),(-4.53,-17.25,9.235),(-6.965,-20.32,7.779),(-8.355,-17.25,5.355),(-9.688,-20.32,2.252),(-10.57,-17.25,-0.8544),(-10.88,-20.32,-3.66),(-9.865,-17.25,-6.073),(-8.56,-20.32,-8.373),(-4.463,-17.25,-10.56),(-2.225,-20.32,-11.53),(0.3848,-17.25,-11.51),(3.687,-20.32,-10.52),(6.964,-17.25,-9.281),(7.591,-20.32,-7.023),(9.928,-17.25,-6.129),(11.18,-20.32,-2.932),(13.28,-26.46,2.427),(12.16,-23.39,0.5184),(11.66,-23.39,4.904),(9.525,-26.46,7.783),(7.327,-23.39,9.886),(4.027,-26.46,12.82),(2.505,-23.39,11.45),(-1.885,-26.46,9.775),(-4.101,-23.39,9.045),(-6.626,-26.46,7.492),(-8.13,-23.39,4.992),(-8.787,-26.46,2.693),(-10.69,-23.39,-1.476),(-12.39,-26.46,-3.219),(-9.124,-23.39,-6.436),(-6.969,-26.46,-8.659),(-3.997,-23.39,-10.75),(-1.571,-26.46,-12.29),(0.1467,-23.39,-11.41),(4.341,-26.46,-9.244),(7.431,-23.39,-9.908),(9.182,-26.46,-8.369),(10.67,-23.39,-6.524),(9.678,-26.46,-3.485),(11.81,-32.39,1.409),(12.16,-29.53,-0.2071),(12.48,-29.53,5.527),(10.9,-32.39,7.466),(6.59,-29.53,8.761),(5.376,-32.39,10.2),(2.544,-29.53,11.45),(-0.3879,-32.39,10.51),(-4.838,-29.53,8.357),(-4.85,-32.39,5.959),(-7.316,-29.53,5.616),(-9.702,-32.39,1.415),(-10.7,-29.53,-1.509),(-9.338,-32.39,-4.349),(-7.795,-29.53,-5.812),(-6.632,-32.39,-9.789),(-4.734,-29.53,-11.44),(-0.3809,-32.39,-11.01),(1.005,-29.53,-11.4),(5.383,-32.39,-11.31),(6.694,-29.53,-11.03),(9.115,-32.39,-8.281),(12,-29.53,-5.9),(12.17,-32.39,-4.355),(10.49,-36.73,3.168),(11.97,-34.84,-0.6),(9.665,-34.84,5.444),(9.062,-36.73,6.194),(6.538,-34.84,8.119),(4.177,-36.73,7.428),(2.716,-34.84,9.504),(-0.5527,-36.73,8.061),(-3.747,-34.84,8.908),(-3.86,-36.73,4.903),(-8.149,-34.84,4.605),(-7.162,-36.73,1.475),(-8.602,-34.84,-1.654),(-6.414,-36.73,-3.255),(-7.215,-34.84,-5.68),(-5.386,-36.73,-8.018),(-4.74,-34.84,-8.906),(-2.555,-36.73,-9.59),(1.469,-34.84,-11.07),(2.174,-36.73,-10.22),(5.545,-34.84,-9.696),(7.536,-36.73,-6.727),(10.6,-34.84,-4.841),(11.24,-36.73,-1.561),(8.281,-38.78,2.371),(9.883,-37.93,-0.1912),(10.82,-37.93,3.696),(7.166,-38.78,3.927),(5.458,-37.93,5.449),(3.294,-38.78,5.685),(1.504,-37.93,7.048),(-0.2526,-38.78,5.856),(-2.541,-37.93,4.28),(-2.525,-38.78,3.525),(-3.037,-37.93,3.408),(-4.957,-38.78,1.13),(-6.115,-37.93,-0.6298),(-4.755,-38.78,-2.417),(-4.42,-37.93,-4.591),(-3,-38.78,-6.166),(-2.881,-37.93,-9.576),(-1.721,-38.78,-7.382),(0.9856,-37.93,-8.95),(1.827,-38.78,-7.553),(5.118,-37.93,-8.407),(6.691,-38.78,-5.764),(9.436,-37.93,-4.303),(8.483,-38.78,-1.176),(4.335,-40.3,-0.1966),(7.84,-39.64,0.449),(7.404,-39.64,2.004),(4.862,-40.3,2.784),(4.177,-39.64,3.806),(2.7,-40.3,2.954),(2.381,-39.64,4.558),(0.3349,-40.3,5.121),(-1.537,-39.64,3.513),(-1.599,-40.3,2.493),(-2.492,-39.64,2.383),(-4.49,-40.3,0.5415),(-3.588,-39.64,-1.372),(-1.929,-40.3,-1.823),(-2.838,-39.64,-3.331),(-1.943,-40.3,-3.968),(-1.089,-39.64,-6.383),(1.208,-40.3,-3.704),(0.2287,-39.64,-6.87),(3.572,-40.3,-5.871),(4.625,-39.64,-6.091),(4.518,-40.3,-3.677),(7.058,-39.64,-3.709),(6.897,-40.3,-2.561),(1.569,-40.52,0.2441),(3.73,-40.52,-0.121),(3.335,-40.52,1.343),(2.02,-40.52,0.6187),(2.705,-40.52,1.958),(1.225,-40.52,1.102),(1.814,-40.52,3.816),(-0.006212,-40.52,3.558),(-0.7232,-40.52,3.302),(-1.345,-40.52,2.04),(-2.603,-40.52,1.518),(-3.028,-40.52,0.7427),(-3.127,-40.52,-0.8919),(-0.1239,-40.52,-0.4889),(-1.014,-40.52,-1.91),(0.3349,-40.52,-1.325),(-0.5158,-40.52,-2.636),(0.5833,-40.52,-1.039),(0.9027,-40.52,-3.041),(1.815,-40.52,-3.495),(2.912,-40.52,-3.98),(3.7,-40.52,-2.746),(4.924,-40.52,-2.085),(4.473,-40.52,-0.9875),(1.628,-40.52,-1.527),(0.406,-40.52,-0.953),(0.3829,-40.52,-0.1425),(-0.03682,-40.52,1.714),(-0.9437,-40.52,2.42),(-1.892,-40.52,1.543),(-1.025,-40.52,0.6736),(1.138,-40.52,0.2164),(2.007,-40.52,0.122),(2.565,-40.52,-0.9391),(3.334,-40.52,-2.44),(3.435,-40.52,-2.28),(14.33,25.4,-2.546),(14.48,25.2,-3.888),(14.01,25.29,-3.54),(13.6,25.56,-3.09),(13.24,25.91,-2.595),(12.89,26.1,-2.078),(12.63,25.98,-1.568),(12.57,25.8,-1.127),(12.75,25.6,-0.8397),(13.12,25.29,-0.7798),(13.61,24.97,-0.951),(14.13,24.74,-1.271),(14.63,24.61,-1.629),(15.11,24.6,-2.008),(15.52,24.63,-2.447),(15.78,24.72,-2.957),(15.78,24.94,-3.477),(15.49,25.14,-3.879),(15.01,25.22,-4.031),(14.02,24.42,-4.78),(13.19,24.15,-4.196),(12.61,24.48,-3.626),(12.1,25.19,-3.011),(11.37,25.61,-2.201),(10.85,25.4,-1.243),(10.91,25.35,-0.2513),(11.58,25.58,0.6033),(12.53,25.32,0.9915),(13.52,24.46,0.74),(14.42,23.81,0.03289),(15.13,23.87,-0.5846),(15.69,24.27,-1.084),(16.29,24.26,-1.782),(16.81,24.21,-2.741),(16.88,24.55,-3.844),(16.16,24.93,-4.813),(15.07,24.89,-5.155),(13.96,23.61,-5.599),(12.71,22.96,-5.333),(11.7,23.09,-4.954),(11,23.73,-4.058),(10.24,24.01,-2.739),(9.921,23.78,-1.448),(10.53,23.83,-0.3393),(11.59,24.52,0.7432),(12.66,24.48,1.656),(13.86,23.29,1.839),(15.21,22.47,1.156),(16.37,22.99,0.4501),(16.97,23.85,-0.3696),(17.25,23.76,-1.53),(17.56,23.55,-2.822),(17.44,23.6,-4.088),(16.48,23.9,-5.247),(15.25,24.08,-5.833),(14.05,22.49,-6.219),(12.58,21.76,-6.722),(11.09,21.7,-6.268),(9.764,22.08,-4.728),(9.437,22.21,-2.965),(9.931,22.15,-1.497),(11.14,22.25,-0.4993),(11.94,22.93,0.2114),(12.72,23.07,1.225),(13.97,21.79,2.239),(15.61,20.91,2.324),(17.37,21.76,1.452),(18.46,22.71,-0.06632),(18.26,22.53,-1.522),(17.77,22.23,-2.99),(17.09,22.15,-4.295),(16.53,22.25,-5.027),(15.47,22.68,-5.623),(14.36,21,-5.935),(12.87,20.27,-6.621),(11.27,20.21,-6.049),(9.609,20.59,-4.489),(9.075,20.71,-2.913),(9.768,20.66,-1.444),(11,20.76,-0.2602),(11.66,21.44,0.43),(12.58,21.58,1.326),(13.95,20.3,2.523),(15.48,19.42,2.643),(17.09,20.27,1.408),(18.33,21.22,-0.3169),(18.1,21.04,-1.833),(17.4,20.74,-3.302),(16.93,20.66,-4.546),(16.71,20.76,-5.071),(15.76,21.19,-5.305),(14.55,19.32,-5.549),(13.16,18.66,-6.387),(11.57,18.8,-5.82),(9.954,19.43,-4.35),(9.558,19.71,-2.93),(10.51,19.48,-1.639),(11.65,19.54,-0.6317),(12.11,20.22,-0.1223),(12.87,20.19,0.6021),(14.05,18.99,1.888),(15.42,18.18,2.25),(16.89,18.69,1.088),(18.09,19.56,-0.6133),(17.83,19.47,-2.091),(16.88,19.25,-3.383),(16.39,19.3,-4.332),(16.35,19.6,-4.609),(15.7,19.79,-4.738),(13.59,17.84,-4.726),(12.51,17.58,-5.475),(11.32,17.9,-5.432),(10.52,18.61,-4.541),(10.66,19.04,-3.433),(11.48,18.82,-2.474),(12.6,18.77,-1.781),(13.29,19,-1.203),(13.88,18.74,-0.2878),(14.71,17.88,0.7943),(15.77,17.24,1.327),(16.84,17.29,0.9642),(17.38,17.69,-0.1153),(16.92,17.68,-1.291),(16.09,17.63,-2.249),(15.3,17.97,-2.875),(14.87,18.35,-3.265),(14.39,18.31,-3.86),(12.7,17.13,-3.324),(12.22,17.22,-3.68),(11.87,17.49,-3.854),(11.79,17.84,-3.718),(12,18.03,-3.338),(12.4,17.91,-2.828),(13.05,17.73,-2.25),(13.72,17.53,-1.604),(14.33,17.22,-0.9195),(14.88,16.9,-0.3868),(15.34,16.67,-0.07675),(15.61,16.54,0.000479),(15.59,16.53,-0.2276),(15.29,16.56,-0.6609),(14.9,16.65,-1.171),(14.33,16.87,-1.696),(13.76,17.07,-2.25),(13.22,17.15,-2.837),(13.59,16.81,-1.802),(11.91,-11.33,-5.577),(12.05,-11.64,-6.379),(11.77,-11.59,-6.159),(11.53,-11.42,-5.884),(11.31,-11.18,-5.587),(11.09,-11.02,-5.281),(10.92,-11.02,-4.984),(10.87,-11.04,-4.731),(10.97,-11.09,-4.572),(11.18,-11.21,-4.549),(11.46,-11.36,-4.665),(11.77,-11.49,-4.866),(12.07,-11.6,-5.086),(12.36,-11.66,-5.313),(12.61,-11.72,-5.572),(12.78,-11.74,-5.869),(12.79,-11.68,-6.169),(12.63,-11.61,-6.398),(12.35,-11.61,-6.477),(11.84,-12.22,-6.965),(11.35,-12.37,-6.598),(11.02,-12.15,-6.247),(10.71,-11.68,-5.879),(10.28,-11.34,-5.403),(9.948,-11.34,-4.844),(9.958,-11.24,-4.269),(10.33,-11,-3.78),(10.88,-11.05,-3.571),(11.46,-11.47,-3.745),(11.99,-11.84,-4.178),(12.4,-11.9,-4.545),(12.75,-11.81,-4.839),(13.12,-11.94,-5.248),(13.45,-12.08,-5.807),(13.5,-11.99,-6.449),(13.09,-11.86,-7.012),(12.45,-11.93,-7.204),(11.89,-12.75,-7.576),(11.17,-13.12,-7.389),(10.59,-13,-7.147),(10.19,-12.55,-6.615),(9.747,-12.25,-5.843),(9.533,-12.23,-5.09),(9.864,-12.04,-4.446),(10.47,-11.52,-3.824),(11.09,-11.42,-3.311),(11.78,-12.01,-3.237),(12.57,-12.48,-3.65),(13.26,-12.32,-4.05),(13.62,-12.02,-4.517),(13.81,-12.24,-5.189),(14.02,-12.5,-5.943),(13.95,-12.58,-6.687),(13.38,-12.49,-7.374),(12.65,-12.45,-7.727),(12.06,-13.4,-8.137),(11.22,-13.81,-8.392),(10.37,-13.8,-8.098),(9.64,-13.48,-7.183),(9.477,-13.25,-6.146),(9.735,-13.12,-5.289),(10.41,-12.89,-4.715),(10.85,-12.35,-4.318),(11.29,-12.15,-3.755),(12.02,-12.77,-3.202),(12.98,-13.29,-3.153),(14.02,-12.97,-3.622),(14.68,-12.64,-4.473),(14.59,-12.93,-5.305),(14.34,-13.24,-6.162),(13.91,-13.39,-6.94),(13.55,-13.42,-7.402),(12.9,-13.24,-7.79),(12.41,-14.2,-8.193),(11.55,-14.62,-8.548),(10.66,-14.61,-8.17),(9.752,-14.29,-7.226),(9.484,-14.06,-6.288),(9.86,-13.93,-5.431),(10.54,-13.7,-4.758),(10.88,-13.16,-4.39),(11.39,-12.96,-3.912),(12.18,-13.58,-3.258),(13.08,-14.1,-3.179),(14.05,-13.78,-3.84),(14.81,-13.45,-4.79),(14.72,-13.74,-5.645),(14.34,-14.05,-6.502),(14.03,-14.2,-7.257),(13.83,-14.23,-7.619),(13.24,-14.05,-7.816),(12.72,-15.08,-8.171),(11.92,-15.45,-8.617),(11.04,-15.33,-8.238),(10.16,-14.88,-7.341),(9.968,-14.59,-6.49),(10.5,-14.56,-5.737),(11.12,-14.37,-5.171),(11.34,-13.85,-4.914),(11.75,-13.75,-4.539),(12.43,-14.34,-3.832),(13.24,-14.81,-3.612),(14.13,-14.66,-4.234),(14.88,-14.35,-5.168),(14.77,-14.57,-5.998),(14.24,-14.83,-6.751),(13.92,-14.91,-7.338),(13.83,-14.83,-7.558),(13.4,-14.78,-7.69),(12.37,-15.79,-7.834),(11.74,-15.94,-8.241),(11.08,-15.72,-8.18),(10.65,-15.26,-7.63),(10.75,-14.92,-6.966),(11.21,-14.91,-6.407),(11.83,-14.81,-6.02),(12.2,-14.57,-5.713),(12.52,-14.62,-5.214),(13,-15.04,-4.614),(13.62,-15.41,-4.303),(14.27,-15.47,-4.483),(14.62,-15.38,-5.075),(14.39,-15.51,-5.738),(13.92,-15.65,-6.297),(13.44,-15.56,-6.685),(13.15,-15.43,-6.95),(12.84,-15.5,-7.329),(12,-16.02,-7.094),(11.72,-15.97,-7.287),(11.53,-15.8,-7.373),(11.49,-15.56,-7.28),(11.62,-15.4,-7.051),(11.84,-15.4,-6.753),(12.2,-15.43,-6.423),(12.58,-15.47,-6.06),(12.92,-15.59,-5.677),(13.24,-15.74,-5.38),(13.51,-15.87,-5.205),(13.68,-15.98,-5.154),(13.68,-16.05,-5.278),(13.52,-16.1,-5.524),(13.3,-16.12,-5.822),(12.97,-16.06,-6.135),(12.63,-16,-6.467),(12.31,-15.99,-6.815),(12.56,-15.99,-6.229),(9.121,-2.383,-8.616),(9.555,-2.612,-9.541),(9.245,-2.761,-9.502),(8.926,-2.902,-9.452),(8.624,-2.997,-9.325),(8.391,-3.027,-9.104),(8.335,-3.013,-8.806),(8.504,-2.981,-8.469),(8.804,-2.876,-8.139),(9.144,-2.672,-7.892),(9.467,-2.438,-7.828),(9.731,-2.32,-7.988),(9.905,-2.312,-8.266),(9.988,-2.335,-8.581),(10.02,-2.348,-8.897),(10.08,-2.36,-9.195),(10.11,-2.365,-9.437),(10.03,-2.397,-9.579),(9.831,-2.482,-9.598),(9.767,-2.972,-10.51),(9.245,-3.094,-10.38),(8.805,-3.275,-10.16),(8.373,-3.412,-9.758),(7.926,-3.377,-9.235),(7.778,-3.454,-8.675),(8.009,-3.563,-8.148),(8.414,-3.594,-7.692),(8.909,-3.351,-7.357),(9.459,-2.854,-7.285),(10.01,-2.708,-7.636),(10.48,-2.794,-8.09),(10.8,-2.819,-8.513),(10.95,-2.684,-8.99),(11.1,-2.559,-9.549),(11.16,-2.558,-10.12),(10.88,-2.577,-10.56),(10.35,-2.722,-10.66),(9.826,-3.747,-11.1),(9.098,-3.636,-10.73),(8.496,-3.733,-10.25),(8.008,-3.955,-9.67),(7.485,-3.854,-8.945),(7.162,-3.925,-8.191),(7.248,-3.96,-7.501),(7.692,-4.079,-6.928),(8.343,-3.949,-6.649),(9.068,-3.301,-6.765),(9.827,-3.289,-7.247),(10.48,-3.443,-7.744),(11.01,-3.356,-8.272),(11.43,-3.048,-8.948),(11.76,-2.907,-9.701),(11.77,-3.158,-10.44),(11.29,-3.202,-11.07),(10.58,-3.369,-11.32),(10.35,-4.647,-11.37),(9.438,-4.348,-10.77),(8.46,-4.365,-10.4),(7.659,-4.708,-9.89),(7.159,-4.608,-9.1),(6.709,-4.664,-8.243),(6.795,-4.593,-7.423),(7.527,-4.668,-6.617),(8.33,-4.587,-6.136),(9.177,-3.952,-6.435),(10.02,-4.054,-6.87),(10.7,-4.197,-7.523),(11.07,-3.957,-8.441),(11.57,-3.626,-9.403),(12.02,-3.528,-10.26),(11.93,-3.992,-10.91),(11.63,-4.047,-11.3),(11.13,-4.241,-11.51),(10.25,-5.456,-11.55),(9.313,-5.158,-10.76),(8.261,-5.175,-10.29),(7.529,-5.518,-9.818),(7.288,-5.418,-9.041),(6.81,-5.474,-8.184),(6.711,-5.403,-7.35),(7.435,-5.477,-6.512),(8.268,-5.397,-6.127),(9.119,-4.761,-6.615),(9.955,-4.864,-6.866),(10.61,-5.006,-7.324),(10.98,-4.767,-8.28),(11.67,-4.435,-9.298),(12.15,-4.338,-10.16),(11.8,-4.802,-10.75),(11.43,-4.856,-11.1),(11,-5.051,-11.5),(9.902,-6.078,-11.23),(9.059,-5.968,-10.43),(8.224,-6.064,-9.995),(7.755,-6.286,-9.681),(7.585,-6.185,-9.072),(7.075,-6.256,-8.319),(6.899,-6.292,-7.512),(7.584,-6.41,-6.672),(8.427,-6.28,-6.355),(9.209,-5.633,-6.894),(9.911,-5.621,-7.16),(10.37,-5.775,-7.428),(10.66,-5.687,-8.11),(11.35,-5.379,-8.995),(11.86,-5.239,-9.748),(11.51,-5.49,-10.28),(11.01,-5.533,-10.75),(10.54,-5.701,-11.24),(9.622,-6.544,-10.76),(9.063,-6.667,-10.15),(8.605,-6.847,-9.64),(8.351,-6.984,-9.305),(8.192,-6.949,-8.897),(7.82,-7.026,-8.337),(7.578,-7.135,-7.695),(7.902,-7.166,-7.173),(8.523,-6.923,-7.128),(9.138,-6.426,-7.54),(9.625,-6.281,-7.772),(9.972,-6.366,-7.948),(10.37,-6.391,-8.308),(10.99,-6.256,-8.834),(11.36,-6.131,-9.394),(11.14,-6.13,-9.918),(10.68,-6.149,-10.41),(10.16,-6.294,-10.8),(9.77,-6.994,-10.2),(9.495,-7.143,-9.945),(9.286,-7.284,-9.576),(9.147,-7.379,-9.207),(9.043,-7.409,-8.87),(8.914,-7.395,-8.572),(8.786,-7.363,-8.35),(8.791,-7.258,-8.263),(8.953,-7.054,-8.335),(9.219,-6.819,-8.481),(9.539,-6.701,-8.589),(9.893,-6.694,-8.704),(10.27,-6.717,-8.877),(10.6,-6.73,-9.121),(10.73,-6.742,-9.419),(10.63,-6.747,-9.734),(10.39,-6.778,-10.02),(10.08,-6.863,-10.2),(9.895,-7.046,-9.39),(0.9566,-19.12,-11.91),(1.478,-18.86,-13.39),(1.025,-18.81,-13.21),(0.603,-18.7,-12.94),(0.2063,-18.53,-12.64),(-0.1211,-18.41,-12.26),(-0.2495,-18.46,-11.8),(-0.17,-18.64,-11.31),(0.1421,-18.96,-10.91),(0.6041,-19.3,-10.71),(1.09,-19.5,-10.74),(1.513,-19.61,-10.98),(1.849,-19.76,-11.35),(2.13,-19.85,-11.76),(2.366,-19.87,-12.2),(2.495,-19.8,-12.66),(2.507,-19.57,-13.09),(2.31,-19.24,-13.39),(1.934,-18.97,-13.47),(0.9645,-19.48,-14.95),(0.2488,-19.77,-14.43),(-0.1275,-19.59,-14.03),(-0.36,-19.2,-13.72),(-0.7817,-19.03,-13.16),(-1.15,-18.98,-12.29),(-1.078,-19.02,-11.23),(-0.2656,-19.45,-10.21),(0.828,-20.05,-9.738),(1.81,-20.27,-9.957),(2.535,-20.4,-10.41),(2.943,-20.69,-10.71),(3.245,-20.67,-10.97),(3.766,-20.49,-11.52),(4.134,-20.51,-12.38),(3.963,-20.42,-13.47),(3.081,-19.77,-14.54),(1.956,-19.3,-15.1),(0.3571,-20.82,-15.97),(-0.7883,-21.08,-15.57),(-1.56,-20.58,-15.2),(-1.62,-20.22,-14.58),(-1.61,-20.53,-13.52),(-1.775,-20.51,-12.35),(-1.398,-20.36,-11.22),(-0.3146,-20.63,-10.05),(0.8287,-21.21,-9.245),(1.983,-21.41,-9.248),(3.129,-21.57,-9.375),(4.008,-21.92,-9.294),(4.426,-21.62,-9.688),(4.849,-21.27,-10.72),(5.013,-21.39,-11.89),(4.204,-21.73,-13.05),(2.763,-20.95,-14.45),(1.512,-20.37,-15.69),(0.9613,-22.4,-16.09),(-0.4626,-22.32,-16.5),(-1.867,-21.62,-15.9),(-2.694,-21.42,-14.47),(-2.703,-22.1,-12.91),(-2.128,-22.18,-11.59),(-1.22,-21.93,-10.65),(-0.6168,-22.06,-10.04),(0.1037,-22.64,-9.317),(1.266,-22.67,-8.444),(2.719,-22.75,-8.152),(4.299,-23.21,-8.578),(5.403,-22.79,-9.749),(5.404,-22.44,-11.22),(4.829,-22.46,-12.55),(3.93,-23.04,-13.57),(3.049,-22.4,-14.44),(2.153,-21.88,-15.34),(0.9565,-23.75,-15.74),(-0.3856,-23.67,-16.43),(-1.737,-22.97,-16),(-2.822,-22.77,-14.49),(-3.043,-23.45,-12.84),(-2.376,-23.52,-11.51),(-1.164,-23.28,-10.66),(-0.5422,-23.41,-10.14),(0.06499,-23.99,-9.244),(1.175,-24.02,-8.094),(2.681,-24.1,-7.889),(4.374,-24.56,-8.598),(5.46,-24.14,-9.886),(5.156,-23.79,-11.24),(4.489,-23.81,-12.56),(3.802,-24.39,-13.71),(3.179,-23.75,-14.46),(2.23,-23.23,-15.08),(0.6165,-24.7,-15.2),(-0.5928,-24.96,-15.48),(-1.828,-24.46,-15.34),(-2.528,-24.11,-14.3),(-2.516,-24.42,-12.99),(-2.275,-24.39,-11.82),(-1.243,-24.24,-10.94),(-0.3629,-24.51,-10.19),(0.3852,-25.09,-9.162),(1.43,-25.29,-8.473),(2.685,-25.45,-8.367),(3.96,-25.8,-8.672),(4.581,-25.5,-9.72),(4.349,-25.15,-10.97),(4.107,-25.27,-12.14),(3.297,-25.61,-13.08),(2.495,-24.83,-13.82),(1.707,-24.25,-14.69),(0.1922,-25.43,-14.21),(-0.6694,-25.72,-14.16),(-1.355,-25.54,-14.04),(-1.656,-25.15,-13.52),(-1.673,-24.98,-12.7),(-1.714,-24.93,-11.83),(-1.134,-24.97,-11.02),(-0.3288,-25.4,-10.21),(0.4727,-26,-9.467),(1.312,-26.22,-9.217),(2.18,-26.35,-9.275),(2.88,-26.64,-9.392),(3.19,-26.62,-9.899),(3.203,-26.44,-10.7),(3.243,-26.46,-11.57),(2.667,-26.37,-12.4),(1.854,-25.72,-13.22),(1.038,-25.25,-13.97),(0.6675,-26.16,-13),(0.2335,-26.11,-12.83),(-0.113,-26,-12.61),(-0.3567,-25.82,-12.31),(-0.5303,-25.71,-11.91),(-0.652,-25.76,-11.45),(-0.5231,-25.94,-10.98),(-0.1863,-26.25,-10.58),(0.2592,-26.6,-10.33),(0.7316,-26.79,-10.34),(1.168,-26.91,-10.5),(1.521,-27.06,-10.7),(1.777,-27.15,-11),(1.964,-27.16,-11.39),(2.085,-27.09,-11.85),(1.944,-26.87,-12.33),(1.594,-26.54,-12.74),(1.142,-26.27,-13),(0.7314,-26.88,-11.68),(-9.629,38.24,-6.826),(-9.199,37.97,-8.131),(-9.635,38.08,-7.949),(-10.07,38.26,-7.62),(-10.44,38.45,-7.24),(-10.69,38.52,-6.832),(-10.77,38.49,-6.412),(-10.76,38.56,-6.029),(-10.58,38.64,-5.765),(-10.24,38.61,-5.674),(-9.834,38.43,-5.709),(-9.416,38.27,-5.87),(-9.021,38.16,-6.192),(-8.661,38.06,-6.601),(-8.387,37.98,-7.041),(-8.306,37.99,-7.462),(-8.342,38.01,-7.812),(-8.509,37.99,-8.047),(-8.807,37.95,-8.146),(-8.878,37.18,-9.541),(-9.652,37.01,-9.076),(-10.33,37.34,-8.571),(-10.87,37.96,-8.146),(-11.32,37.99,-7.571),(-11.58,37.63,-6.781),(-11.59,37.73,-5.87),(-11.02,38.15,-5.084),(-10.13,38.16,-4.799),(-9.256,37.74,-4.989),(-8.569,37.63,-5.34),(-8.092,37.67,-5.843),(-7.652,37.52,-6.45),(-7.1,37.32,-7.183),(-6.843,37.5,-7.974),(-6.933,37.68,-8.725),(-7.4,37.59,-9.329),(-8.096,37.4,-9.617),(-8.636,35.83,-10.66),(-9.663,35.54,-10.42),(-10.54,36.04,-10.16),(-11.23,37.08,-9.698),(-11.8,37.13,-8.798),(-11.92,36.59,-7.734),(-11.48,36.42,-6.632),(-10.42,36.95,-5.462),(-9.262,37.12,-4.655),(-8.185,36.69,-4.529),(-7.165,36.65,-4.916),(-6.474,36.76,-5.555),(-6.171,36.45,-6.328),(-5.884,36.03,-7.293),(-5.764,36.32,-8.358),(-5.918,36.66,-9.394),(-6.599,36.49,-10.25),(-7.566,36.22,-10.68),(-8.922,34.46,-11.13),(-10.11,34.24,-11.45),(-10.98,34.81,-11.02),(-11.61,35.9,-10.14),(-12.31,35.98,-8.969),(-11.95,35.53,-7.759),(-11.17,35.17,-6.654),(-10.32,35.49,-5.678),(-9.262,35.86,-4.895),(-8.102,35.57,-4.161),(-6.877,35.59,-4.452),(-5.837,35.56,-5.191),(-5.135,35.15,-5.844),(-5.085,34.79,-6.928),(-5.44,35.14,-8.139),(-5.576,35.44,-9.331),(-6.495,35.21,-10.53),(-7.721,34.89,-11),(-9.282,33.23,-11.4),(-10.45,33.01,-11.5),(-11.27,33.58,-10.54),(-11.75,34.67,-9.535),(-12.15,34.75,-8.521),(-11.72,34.3,-7.31),(-11.4,33.94,-6.049),(-10.94,34.26,-5.194),(-9.784,34.63,-4.944),(-8.523,34.34,-4.427),(-7.399,34.36,-4.46),(-6.457,34.33,-4.956),(-5.365,33.92,-5.524),(-4.849,33.56,-6.572),(-5.278,33.91,-7.783),(-5.71,34.21,-9.011),(-6.783,33.98,-10.3),(-8.064,33.66,-11.01),(-8.939,32.29,-11.19),(-9.885,32,-11.39),(-10.56,32.5,-10.49),(-11.15,33.54,-9.192),(-11.5,33.59,-8.087),(-11.09,33.05,-7.022),(-10.7,32.88,-6.125),(-10.57,33.41,-5.796),(-9.927,33.58,-5.631),(-8.904,33.15,-5.055),(-7.83,33.1,-5.069),(-6.628,33.22,-5.596),(-5.39,32.91,-6.21),(-5.052,32.49,-7.01),(-5.463,32.78,-8.075),(-5.837,33.12,-9.276),(-6.617,32.94,-10.29),(-7.787,32.68,-10.83),(-8.524,31.76,-10.21),(-9.282,31.59,-10.46),(-9.962,31.92,-10.11),(-10.54,32.53,-9.219),(-10.85,32.57,-8.25),(-10.56,32.2,-7.46),(-10.02,32.3,-6.944),(-9.68,32.72,-6.622),(-9.289,32.73,-6.184),(-8.631,32.31,-5.663),(-7.733,32.21,-5.707),(-6.754,32.25,-6.184),(-6.078,32.1,-6.825),(-6.08,31.9,-7.542),(-6.364,32.08,-8.333),(-6.601,32.25,-9.1),(-7.036,32.17,-9.671),(-7.725,31.97,-9.984),(-8.466,31.31,-9.15),(-8.89,31.43,-9.205),(-9.284,31.61,-9.115),(-9.589,31.8,-8.838),(-9.735,31.87,-8.444),(-9.654,31.83,-8.023),(-9.369,31.9,-7.627),(-9.015,31.99,-7.26),(-8.634,31.95,-6.929),(-8.223,31.77,-6.728),(-7.806,31.61,-6.769),(-7.458,31.51,-7.004),(-7.271,31.4,-7.361),(-7.268,31.33,-7.777),(-7.35,31.33,-8.197),(-7.491,31.36,-8.572),(-7.727,31.34,-8.859),(-8.062,31.29,-9.045),(-8.488,31.16,-7.967),(-8.178,11.66,-0.5368),(-7.442,10.98,-1.78),(-7.923,10.87,-1.455),(-8.424,10.97,-1.112),(-8.936,11.26,-0.7457),(-9.411,11.58,-0.33),(-9.708,11.71,0.1313),(-9.731,11.62,0.5823),(-9.489,11.43,0.9231),(-9.079,11.3,1.04),(-8.612,11.33,0.8761),(-8.17,11.57,0.4699),(-7.782,11.9,-0.03547),(-7.43,12.13,-0.5437),(-7.092,12.19,-1.036),(-6.795,12.07,-1.498),(-6.636,11.83,-1.872),(-6.716,11.55,-2.07),(-7.014,11.26,-2.026),(-7.865,10.38,-2.832),(-8.671,9.972,-2.268),(-9.288,10.04,-1.885),(-9.82,10.46,-1.455),(-10.52,10.97,-0.7724),(-11.1,11.16,0.09448),(-10.98,10.98,1.041),(-10.23,10.41,1.939),(-9.277,10.06,2.423),(-8.361,10.22,2.16),(-7.57,10.58,1.431),(-7.019,11.11,0.8307),(-6.654,11.47,0.2893),(-6.184,11.36,-0.4283),(-5.605,11.17,-1.295),(-5.497,10.88,-2.207),(-6.079,10.91,-2.993),(-6.964,10.87,-3.259),(-8.169,9.35,-3.663),(-9.391,8.899,-3.128),(-10.35,9.11,-2.716),(-10.75,9.193,-1.869),(-11.37,9.351,-0.7314),(-11.98,9.657,0.4365),(-11.6,9.886,1.493),(-10.67,9.218,2.436),(-9.713,8.919,3.192),(-8.567,9.398,3.062),(-7.413,9.562,2.276),(-6.345,9.972,1.87),(-5.773,10.47,1.232),(-5.357,10.11,0.05961),(-4.745,9.787,-1.108),(-4.928,9.445,-2.13),(-6.026,9.795,-3.282),(-7.09,10.05,-4.044),(-7.912,8.232,-4.268),(-9.26,7.793,-4.216),(-10.33,8.042,-3.741),(-10.8,7.858,-2.244),(-11.63,7.698,-0.6443),(-12.06,8.057,0.6837),(-11.22,8.56,1.58),(-10.55,7.96,2.118),(-9.917,7.773,2.97),(-8.774,8.391,3.38),(-7.301,8.328,2.402),(-5.637,8.693,1.899),(-4.6,9.3,1.143),(-4.531,8.767,-0.1251),(-4.101,8.507,-1.453),(-4.181,8.237,-2.681),(-5.412,8.557,-3.959),(-6.644,8.966,-4.785),(-7.669,6.883,-4.654),(-8.933,6.444,-4.571),(-9.921,6.693,-4.056),(-10.49,6.51,-2.608),(-11.29,6.35,-1.008),(-11.67,6.708,0.3196),(-10.9,7.212,1.216),(-10.21,6.611,1.803),(-9.549,6.425,2.615),(-8.411,7.043,2.994),(-6.934,6.98,2.098),(-5.296,7.344,1.547),(-4.278,7.951,0.7485),(-4.143,7.419,-0.3911),(-3.763,7.159,-1.719),(-3.87,6.889,-3.075),(-5.005,7.208,-4.311),(-6.318,7.617,-5.089),(-7.124,5.467,-3.736),(-8.303,5.016,-3.426),(-9.507,5.227,-3.17),(-10.52,5.31,-2.513),(-11.42,5.468,-1.426),(-11.77,5.774,-0.2576),(-11.23,6.003,0.85),(-10.12,5.335,1.982),(-9.02,5.036,2.894),(-7.877,5.515,2.989),(-6.72,5.679,2.268),(-5.799,6.089,1.319),(-5.401,6.592,0.1966),(-5.147,6.225,-1.002),(-4.792,5.904,-2.17),(-4.692,5.562,-3.166),(-5.184,5.912,-3.833),(-6.003,6.166,-4.052),(-7.74,4.429,-2.732),(-8.653,4.023,-2.303),(-9.544,4.09,-1.824),(-10.28,4.508,-1.336),(-10.82,5.024,-0.6627),(-11.08,5.206,0.2041),(-10.98,5.034,1.16),(-10.33,4.463,2),(-9.395,4.112,2.388),(-8.467,4.269,2.26),(-7.688,4.627,1.865),(-7.121,5.166,1.222),(-6.66,5.519,0.3963),(-6.163,5.408,-0.5261),(-5.902,5.219,-1.393),(-5.96,4.933,-2.1),(-6.335,4.957,-2.602),(-6.946,4.92,-2.826),(-8.104,3.684,-1.906),(-8.552,3.57,-1.675),(-8.938,3.677,-1.263),(-9.228,3.966,-0.7921),(-9.413,4.28,-0.3107),(-9.506,4.412,0.1505),(-9.533,4.326,0.536),(-9.392,4.134,0.7718),(-9.072,4,0.8206),(-8.64,4.037,0.7505),(-8.164,4.277,0.6189),(-7.684,4.599,0.3814),(-7.233,4.836,0.04081),(-6.891,4.896,-0.3821),(-6.797,4.776,-0.8434),(-6.928,4.53,-1.287),(-7.231,4.253,-1.653),(-7.644,3.96,-1.877),(-8.009,3.891,-0.7056)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for UnitBacteria.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python UnitBacteria.py load and self-test diagnostics complete.")
