package Basic.StudentProjects;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Sound.*;
import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> A simple room containing protoype instances for chair, desk lamp, wall clock, etc. </p>
 <p> Related links: Catalog page <a href="../../../StudentProjects/RoomIndex.html" target="_blank">Room</a>,  source <a href="../../../StudentProjects/Room.java">Room.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../StudentProjects/Room.x3d">Room.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> A simple room containing protoype instances for chair, desk lamp, wall clock, etc. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Frederic Roussille </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 April 2001 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Room.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Room.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../StudentProjects/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Frederic Roussille
 */

public class Room
{
	/** Default constructor to create this object. */
	public Room ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Room.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("A simple room containing protoype instances for chair, desk lamp, wall clock, etc."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Frederic Roussille"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 April 2001"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Room.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addComments(" externprodeclare : chair ")
    .addChild(new WorldInfo().setTitle("Room.x3d"))
    .addChild(new ExternProtoDeclare("Chair").setName("Chair").setUrl(new String[] {"Chair.x3d#Chair","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Chair.x3d#Chair","Chair.wrl#Chair","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Chair.wrl#Chair"})
      .addField(new field().setName("diffuseColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
    .addChild(new ExternProtoDeclare("Desk").setName("Desk").setUrl(new String[] {"Desk.x3d#Desk","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Desk.x3d#Desk","Desk.wrl#Desk","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Desk.wrl#Desk"})
      .addField(new field().setName("diffuseColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
    .addChild(new ExternProtoDeclare("WallLamp").setName("WallLamp").setUrl(new String[] {"WallLamp.x3d#WallLamp","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/WallLamp.x3d#WallLamp","WallLamp.wrl#WallLamp","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/WallLamp.wrl#WallLamp"})
      .addField(new field().setName("lampColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("lightColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("lightIntensity").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("lightAttenuation").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("radius").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("lightLocation").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT)))
    .addChild(new NavigationInfo().setHeadlight(false))
    .addChild(new Viewpoint().setDescription("entry").setOrientation(1.0,0.0,0.0,-0.2).setPosition(16.0,23.0,75.0))
    .addChild(new Transform().setScale(0.4,0.4,0.6)
      .addChild(new Group()
        .addComments(" floor ")
        .addChild(new Shape("wall")
          .setGeometry(new ElevationGrid().setSolid(false).setXDimension(9).setXSpacing(10).setZDimension(9).setZSpacing(10).setHeight(new double[] {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0}))
          .setAppearance(new Appearance("wallpaper")
            .setTexture(new ImageTexture().setUrl(new String[] {"WallPaper.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/WallPaper.jpg"}))
            .setTextureTransform(new TextureTransform().setScale(2.0,2.0))
            .setMaterial(new Material())))
        .addComments(" left wall ")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
          .addChild(new Shape().setUSE("wall")))
        .addComments(" right wall ")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(80.0,0.0,0.0)
          .addChild(new Shape().setUSE("wall")))
        .addComments(" top ")
        .addChild(new Transform().setTranslation(0.0,80.0,0.0)
          .addChild(new Shape().setUSE("wall")))
        .addComments(" front wall ")
        .addChild(new Transform().setRotation(1.0,0.0,0.0,1.57)
          .addChild(new Shape()
            .setAppearance(new Appearance().setUSE("wallpaper"))
            .setGeometry(new IndexedFaceSet().setSolid(false).setCoordIndex(new int[] {0,1,2,7,-1,2,3,6,7,-1,4,5,6,3,-1})
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,25.0,0.0,0.0,25.0,0.0,-45.0,55.0,0.0,-45.0,55.0,0.0,0.0,80.0,0.0,0.0,80.0,0.0,-80.0,0.0,0.0,-80.0}))))))
        .addComments(" door with its interpalotors and sensors ")
        .addChild(new Transform("transform_door").setCenter(25.0,0.0,0.0)
          .addChild(new Transform().setTranslation(40.0,22.5,0.0)
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setTexture(new ImageTexture().setUrl(new String[] {"Door.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Door.jpg"})))
              .setGeometry(new Box().setSize(30.0,44.5,2.0)))
            .addChild(new TouchSensor("touch_door").setDescription("touch door to open/close")))
          .addChild(new Script("open_door_js").setSourceCode("""
ecmascript:

function set_open() {
    keyValue_changed[0][0] = 0;
    keyValue_changed[0][1] = 1;
    keyValue_changed[0][2] = 0;
    keyValue_changed[1][0] = 0;
    keyValue_changed[1][1] = 1;
    keyValue_changed[1][2] = 0;
    keyValue_changed[1][3] = -0.754;
    keyValue_changed[2][0] = 0;
    keyValue_changed[2][1] = 1;
    keyValue_changed[2][2] = 0;

  if(open == false) {
    keyValue_changed[0][3] = 0;
    keyValue_changed[2][3] = -1.57;
    open = true;
  } else {
      if(open == true) {
         keyValue_changed[0][3] = -1.57;
         keyValue_changed[2][3] = 0;
         open = false;
      }
   }
}
""")
            .addField(new field().setName("set_open").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
            .addField(new field().setName("keyValue_changed").setType(field.TYPE_MFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
            .addField(new field().setName("open").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false)))
          .addChild(new TimeSensor("clock").setCycleInterval(4.5))
          .addChild(new OrientationInterpolator("open_door").setKey(new double[] {0.0,0.5,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0}))))
        .addComments(" link to nps site ")
        .addChild(new Anchor().setDescription("link to NPS web page").setUrl(new String[] {"https://www.nps.edu"})
          .addChild(new Transform().setTranslation(40.0,22.5,-20.0)
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(0.0,0.0,0.0)))
              .setGeometry(new Box().setSize(30.0,44.5,1.0))))))
      .addComments(" Door sound ")
      .addChild(new Sound().setDirection(0.0,1.0,1.0).setLocation(40.0,0.0,0.0).setMaxBack(150).setMaxFront(150)
        .setSource(new AudioClip("grinding_door").setDescription("GrindingDoor").setUrl(new String[] {"GrindingDoor.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/GrindingDoor.wav"}))))
    .addComments(" chair inserted ")
    .addChild(new Transform().setScale(1.5,1.5,1.5).setTranslation(10.0,5.3,35.0)
      .addChild(new ProtoInstance("Chair").setContainerField("children")
        .addFieldValue(new fieldValue().setName("diffuseColor").setValue(new SFColor(0.0,0.3,0.7)))))
    .addComments(" desk inserted ")
    .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.754).setScale(0.8,0.8,0.7).setTranslation(18.0,8.1,28.0)
      .addChild(new ProtoInstance("Desk").setContainerField("children")))
    .addComments(" left wall_lamp ")
    .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setScale(2.0,2.0,2.0).setTranslation(0.05,23.0,20.0)
      .addChild(new ProtoInstance("WallLamp").setContainerField("children")
        .addFieldValue(new fieldValue().setName("lampColor").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("lightColor").setValue(new SFColor(1.0,1.0,1.0)))
        .addFieldValue(new fieldValue().setName("lightIntensity").setValue(0.8))
        .addFieldValue(new fieldValue().setName("lightAttenuation").setValue(new SFVec3f(0.0,0.0,0.0)))
        .addFieldValue(new fieldValue().setName("radius").setValue(100))
        .addFieldValue(new fieldValue().setName("lightLocation").setValue(new SFVec3f(0.0,0.0,5.0)))))
    .addComments(" right wall_lamp ")
    .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.57).setScale(2.0,2.0,2.0).setTranslation(31.99,23.0,20.0)
      .addChild(new ProtoInstance("WallLamp").setContainerField("children")
        .addFieldValue(new fieldValue().setName("lampColor").setValue(new SFColor(0.0,0.0,1.0)))
        .addFieldValue(new fieldValue().setName("lightColor").setValue(new SFColor(1.0,1.0,1.0)))
        .addFieldValue(new fieldValue().setName("lightIntensity").setValue(0.8))
        .addFieldValue(new fieldValue().setName("lightAttenuation").setValue(new SFVec3f(0.0,0.0,0.0)))
        .addFieldValue(new fieldValue().setName("radius").setValue(100))
        .addFieldValue(new fieldValue().setName("lightLocation").setValue(new SFVec3f(0.0,0.0,-5.0)))))
    .addComments(" clock inserted on the wall ")
    .addChild(new Transform().setTranslation(16.0,22.5,0.0)
      .addChild(new Inline().setUrl(new String[] {"WallClock.x3d","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/WallClock.x3d","WallClock.wrl","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/WallClock.wrl"})))
    .addComments(" desk lamp inserted in the scene ")
    .addChild(new Transform().setScale(15.0,15.0,15.0).setTranslation(16.0,8.6,25.0)
      .addChild(new Inline().setUrl(new String[] {"DeskLamp.x3d","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/DeskLamp.x3d","DeskLamp.wrl","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/DeskLamp.wrl"})))
    .addComments(" routes for the door ")
    .addChild(new ROUTE().setFromNode("touch_door").setFromField("touchTime").setToNode("clock").setToField("startTime"))
    .addChild(new ROUTE().setFromNode("touch_door").setFromField("touchTime").setToNode("open_door_js").setToField("set_open"))
    .addChild(new ROUTE().setFromNode("touch_door").setFromField("touchTime").setToNode("grinding_door").setToField("startTime"))
    .addChild(new ROUTE().setFromNode("open_door_js").setFromField("keyValue_changed").setToNode("open_door").setToField("set_keyValue"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("open_door").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("open_door").setFromField("value_changed").setToNode("transform_door").setToField("set_rotation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Room model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Room().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.StudentProjects.Room\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.StudentProjects.Room self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // StudentProjects/Room_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "StudentProjects/Room_JavaExport.x3d"; 
                String filenameX3DV = "StudentProjects/Room_JavaExport.x3dv"; 
                String filenameJSON = "StudentProjects/Room_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
