####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python PlayRoom.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='PlayRoom.x3d',name='title'),
    meta(content='X3D example Model of a Play room',name='description'),
    meta(content='3 March 2004',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Vaughn Pangelinan',name='creator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/PlayRoom.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    #  Scene Generates the house and world 
    children=[
    WorldInfo(title='PlayRoom.x3d'),
    Background(groundColor=[(.1,.4,.1)],skyColor=[(.8,.8,1)]),
    Transform(DEF='World',
      children=[
      Transform(DEF='House',
        children=[
        Transform(DEF='Walls',
          children=[
          Transform(DEF='LowerWallTransform',
            children=[
            Transform(translation=(1.25,.3,1.4),
              children=[
              Shape(
                geometry=Box(size=(1.499,.6,.201)),
                appearance=Appearance(
                  texture=ImageTexture(DEF='BrickTex',url=["brick.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/brick.jpg"]),
                  textureTransform=TextureTransform(scale=(5,2)))),
              Transform(translation=(-.7495,0,0),
                children=[
                Shape(
                  geometry=Box(size=(.001,.6,.2)),
                  appearance=Appearance(
                    texture=ImageTexture(USE='BrickTex'),
                    textureTransform=TextureTransform(scale=(.5,2))))])]),
            Transform(translation=(-1.25,.3,1.4),
              children=[
              Shape(
                geometry=Box(size=(1.499,.6,.201)),
                appearance=Appearance(
                  texture=ImageTexture(USE='BrickTex'),
                  textureTransform=TextureTransform(scale=(5,2)))),
              Transform(translation=(.7495,0,0),
                children=[
                Shape(
                  geometry=Box(size=(.001,.6,.2)),
                  appearance=Appearance(
                    texture=ImageTexture(USE='BrickTex'),
                    textureTransform=TextureTransform(scale=(.5,2))))])]),
            Transform(translation=(-1.9,.3,0),
              children=[
              Shape(
                geometry=Box(size=(.201,.6,3)),
                appearance=Appearance(
                  texture=ImageTexture(USE='BrickTex'),
                  textureTransform=TextureTransform(scale=(10,2))))]),
            Transform(translation=(1.9,.3,0),
              children=[
              Shape(
                geometry=Box(size=(.201,.6,3)),
                appearance=Appearance(
                  texture=ImageTexture(USE='BrickTex'),
                  textureTransform=TextureTransform(scale=(10,2))))]),
            Transform(translation=(0,.3,-1.4),
              children=[
              Shape(
                geometry=Box(size=(4,.6,.201)),
                appearance=Appearance(
                  texture=ImageTexture(USE='BrickTex'),
                  textureTransform=TextureTransform(scale=(12,2))))])]),
          Transform(DEF='MidLowWallTransform',
            children=[
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(1,0.9,0.7))),
              geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(-0.5,1.5),(-0.5,1.3),(-1.8,1.3),(-1.8,-1.3),(1.8,-1.3),(1.8,1.3),(0.5,1.3),(0.5,1.5),(2.0,1.5),(2.0,-1.5),(-2.0,-1.5),(-2.0,1.5),(-0.5,1.5)],solid=False,spine=[(0,.6,0),(0,.7,0)]))]),
          Transform(DEF='MidHighLeftWallTransform',
            children=[
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(1,0.9,0.7))),
              geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(-1.8,.45),(-1.8,1.3),(-0.5,1.3),(-0.5,1.5),(-2.0,1.5),(-2.0,.45),(-1.8,.45)],solid=False,spine=[(0,.7,0),(0,1.5,0)]))]),
          Transform(DEF='MidHighRightWallTransform',
            children=[
            Transform(DEF='MidHighRightFrontWallTransform',
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(1,0.9,0.7))),
                geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(0.5,1.3),(0.5,1.5),(1,1.5),(1,1.3),(0.5,1.3)],solid=False,spine=[(0,.7,0),(0,1.5,0)]))]),
            Transform(DEF='MidHighRightSideWallTransform',
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(diffuseColor=(1,0.9,0.7))),
                geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(1.8,.45),(1.8,1.3),(1.5,1.3),(1.5,1.5),(2.0,1.5),(2.0,.45),(1.8,.45)],solid=False,spine=[(0,.7,0),(0,1.5,0)]))])]),
          Transform(DEF='MidHighBackWallTransform',
            children=[
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(1,0.9,0.7))),
              geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(-1.8,-.45),(-1.8,-1.3),(1.8,-1.3),(1.8,-.45),(2.0,-.45),(2.0,-1.5),(-2.0,-1.5),(-2.0,-.45),(-1.8,-.45)],solid=False,spine=[(0,.7,0),(0,1.5,0)]))]),
          Transform(DEF='UpperWallTransform',
            children=[
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(1,0.9,0.7))),
              geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(-0.5,1.5),(-0.5,1.3),(-1.8,1.3),(-1.8,-1.3),(1.8,-1.3),(1.8,1.3),(0.5,1.3),(0.5,1.5),(2.0,1.5),(2.0,-1.5),(-2.0,-1.5),(-2.0,1.5),(-0.5,1.5)],solid=False,spine=[(0,1.5,0),(0,2,0)]))])]),
        Transform(DEF='Floor',
          children=[
          Shape(
            appearance=Appearance(DEF='WoodFloor',
              texture=ImageTexture(url=["PrintShopFloorWood.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/PrintShopFloorWood.jpg"])),
            geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
              coord=Coordinate(point=[(-2,0,-1.5),(2,0,-1.5),(2,0,1.5),(-2,0,1.5)]),
              texCoord=TextureCoordinate(point=[(0,0),(1,0),(1,1),(0,1)])))]),
        Transform(DEF='CeilingTransform',translation=(0,2,0),
          children=[
          Shape(
            appearance=Appearance(DEF='Ceiling',
              texture=ImageTexture(url=["StuccoCeiling.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/StuccoCeiling.jpg"])),
            geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
              coord=Coordinate(point=[(-1.8,0,-1.3),(1.8,0,-1.3),(1.8,0,1.3),(-1.8,0,1.3)]),
              texCoord=TextureCoordinate(point=[(0,0),(5,0),(5,5),(0,5)]))),
          Transform(scale=(.3,.3,.3),translation=(-.4,.1,-.155),
            children=[
            Shape(
              geometry=Text(length=[3],string=["Hello In Here!"]),
              appearance=Appearance(
                material=Material(diffuseColor=(0.7,0.1,.1))))])]),
        Transform(DEF='Light',scale=(.05,.05,.05),translation=(0,2,0),
          children=[
          Transform(
            children=[
            Transform(translation=(0,-2.95,0),
              children=[
              Shape(
                appearance=Appearance(
                  material=Material(DEF='BULB_MATERIAL',diffuseColor=(0.4,0.4,0.4),emissiveColor=(0.8,0.8,0.8))),
                geometry=Sphere(),),
              PointLight(DEF='LIGHTSOURCE',radius=1000),
              Transform(translation=(0,2.65,0),
                children=[
                Shape(
                  appearance=Appearance(
                    material=Material(diffuseColor=(0.4,0.4,0.4),emissiveColor=(0.1,0.1,0.1))),
                  geometry=Cylinder(height=.6,radius=0.05))])]),
            Group(
              children=[
              Transform(translation=(0,-1,0),
                children=[
                Shape(
                  appearance=Appearance(DEF='BULB_CASING',
                    material=Material(DEF='SOCKET_MATERIAL',diffuseColor=(0.4,0.4,0.16),emissiveColor=(0.4,0.4,0.16))),
                  geometry=Sphere(radius=0.5))]),
              Transform(translation=(0,-1.5,0),
                children=[
                Shape(
                  appearance=Appearance(USE='BULB_CASING'),
                  geometry=Cylinder(height=1,radius=0.5))])])])]),
        Group(DEF='FrontDoor',
          children=[
          CylinderSensor(DEF='CYLINDERSENSOR',description='Click and drag to rotate',maxAngle=0,minAngle=-2.35),
          Transform(DEF='DoorRotator',center=(-.5,0,1.45),
            children=[
            ROUTE(fromField='rotation_changed',fromNode='CYLINDERSENSOR',toField='set_rotation',toNode='DoorRotator'),
            Transform(translation=(0,1,1.425),
              children=[
              Shape(
                geometry=Box(size=(1,2,.05)),
                appearance=Appearance(DEF='Wood',
                  material=Material(diffuseColor=(.6,.5,.2)))),
              Transform(rotation=(1,0,0,1.57),translation=(.45,.15,0),
                children=[
                Shape(
                  geometry=Cylinder(height=.1,radius=.02),
                  appearance=Appearance(
                    material=Material(DEF='copper',ambientIntensity=.26,diffuseColor=(.3,.11,0),shininess=.08,specularColor=(.75,.33,0))))]),
              Transform(scale=(1,1,.5),translation=(.45,.15,.06),
                children=[
                Shape(
                  geometry=Sphere(radius=.03),
                  appearance=Appearance(
                    material=Material(USE='copper')))]),
              Transform(scale=(1,1,.5),translation=(.45,.15,-.06),
                children=[
                Shape(
                  geometry=Sphere(radius=.03),
                  appearance=Appearance(
                    material=Material(USE='copper')))])])])]),
        Transform(DEF='AllRoof',
          children=[
          Transform(DEF='FrontRoofSupport',
            children=[
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(1,0.9,0.7))),
              geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(-2,2),(2,2),(0,2.5),(-2,2)],solid=False,spine=[(0,0,1.5),(0,0,1.3)]))]),
          Transform(DEF='RearRoofSupport',
            children=[
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(1,0.9,0.7))),
              geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(-2,2),(2,2),(0,2.5),(-2,2)],solid=False,spine=[(0,0,-1.3),(0,0,-1.5)]))]),
          Transform(DEF='LeftRoof',rotation=(0,0,1,.245),translation=(0,2.501,0),
            children=[
            Shape(
              appearance=Appearance(DEF='RoofMaterial',
                texture=ImageTexture(url=["RoofRock.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/RoofRock.jpg"])),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                coord=Coordinate(point=[(0,0,-1.8),(-2.3,0,-1.8),(-2.3,0,1.8),(0,0,1.8)]),
                texCoord=TextureCoordinate(point=[(0,0),(10,0),(10,10),(0,10)])))]),
          Transform(DEF='RightRoof',rotation=(0,0,1,-.245),translation=(-.001,2.501,0),
            children=[
            Shape(
              appearance=Appearance(USE='RoofMaterial'),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                coord=Coordinate(point=[(0,0,-1.8),(2.3,0,-1.8),(2.3,0,1.8),(0,0,1.8)]),
                texCoord=TextureCoordinate(point=[(0,0),(10,0),(10,10),(0,10)])))])]),
        Transform(DEF='Window',
          children=[
          Transform(DEF='FrontWindowTransform',translation=(1.25,1.1,1.4),
            children=[
            Group(DEF='FrontWindowGroup',
              children=[
              Transform(DEF='MovingWindowTransform',translation=(0,.1,0),
                children=[
                Transform(
                  children=[
                  Shape(
                    geometry=Box(size=(.499,.721,.002)),
                    appearance=Appearance(DEF='Glass',
                      material=Material(diffuseColor=(.03,.04,.08),transparency=.85)))]),
                Transform(translation=(0,-.341,0),
                  children=[
                  Shape(
                    geometry=Box(size=(.492,.04,.02)),
                    appearance=Appearance(USE='Wood'))]),
                Transform(translation=(0,.341,0),
                  children=[
                  Shape(
                    geometry=Box(size=(.492,.04,.02)),
                    appearance=Appearance(USE='Wood'))]),
                Transform(translation=(.191,0,0),
                  children=[
                  Shape(
                    geometry=Box(size=(.04,.722,.02)),
                    appearance=Appearance(USE='Wood'))]),
                Transform(translation=(-.191,0,0),
                  children=[
                  Shape(
                    geometry=Box(size=(.04,.722,.02)),
                    appearance=Appearance(USE='Wood'))]),
                Transform(
                  children=[
                  Shape(
                    geometry=Box(size=(.472,.01,.01)),
                    appearance=Appearance(USE='Wood'))]),
                Transform(
                  children=[
                  Shape(
                    geometry=Box(size=(.01,.721,.01)),
                    appearance=Appearance(USE='Wood'))]),
                Transform(translation=(0,-.33,-.01),
                  children=[
                  Transform(rotation=(1,0,0,1.57),translation=(0,0,-.012),
                    children=[
                    Shape(
                      geometry=Cylinder(height=.025,radius=.0075),
                      appearance=Appearance(
                        material=Material(DEF='copper2',ambientIntensity=.26,diffuseColor=(.3,.11,0),shininess=.08,specularColor=(.75,.33,0))))]),
                  Transform(scale=(1,1,.5),translation=(0,0,-.02),
                    children=[
                    Shape(
                      geometry=Sphere(radius=.020),
                      appearance=Appearance(
                        material=Material(USE='copper2')))])]),
                PlaneSensor(DEF='MyPlaneSensor',description='Lift Window',maxPosition=(0,.361))]),
              Transform(DEF='FrontSill',
                children=[
                Transform(translation=(0,-.381,0),
                  children=[
                  Shape(
                    geometry=Box(size=(.502,.04,.201)),
                    appearance=Appearance(DEF='Frame',
                      material=Material(diffuseColor=(.6,.5,.2))))]),
                Transform(translation=(0,.381,0),
                  children=[
                  Shape(
                    geometry=Box(size=(.502,.04,.201)),
                    appearance=Appearance(USE='Frame'))]),
                Transform(translation=(.231,0,0),
                  children=[
                  Shape(
                    geometry=Box(size=(.04,.802,.201)),
                    appearance=Appearance(USE='Frame'))]),
                Transform(translation=(-.231,0,0),
                  children=[
                  Shape(
                    geometry=Box(size=(.04,.802,.201)),
                    appearance=Appearance(USE='Frame'))])]),
              Viewpoint(DEF='FrontWindowView',description='Front Window Opens Up',fieldOfView=1.2,orientation=(0,1,0,3.14),position=(0,0,-.65)),
              ROUTE(fromField='translation_changed',fromNode='MyPlaneSensor',toField='set_translation',toNode='MovingWindowTransform')])]),
          Transform(DEF='LeftWindowTransform',rotation=(0,1,0,-1.57),translation=(-1.9,1.1,0),
            children=[
            Group(DEF='LeftWindowGroup',
              children=[
              Transform(
                children=[
                Shape(
                  geometry=Box(size=(.899,.799,.002)),
                  appearance=Appearance(USE='Glass'))]),
              Transform(
                children=[
                Group(DEF='SideSillGroup',
                  children=[
                  Transform(translation=(0,-.381,0),
                    children=[
                    Shape(
                      geometry=Box(size=(.902,.04,.201)),
                      appearance=Appearance(USE='Frame'))]),
                  Transform(translation=(0,.381,0),
                    children=[
                    Shape(
                      geometry=Box(size=(.902,.04,.201)),
                      appearance=Appearance(USE='Frame'))]),
                  Transform(translation=(.431,0,0),
                    children=[
                    Shape(
                      geometry=Box(size=(.04,.802,.201)),
                      appearance=Appearance(USE='Frame'))]),
                  Transform(translation=(-.431,0,0),
                    children=[
                    Shape(
                      geometry=Box(size=(.04,.802,.201)),
                      appearance=Appearance(USE='Frame'))])])])])]),
          Transform(DEF='RightWindowTransform',rotation=(0,1,0,1.57),translation=(1.9,1.1,0),
            children=[
            Group(DEF='RightWindowGroup',
              children=[
              Transform(
                children=[
                Shape(
                  geometry=Box(size=(.899,.799,.002)),
                  appearance=Appearance(USE='Glass'))]),
              Transform(
                children=[
                Group(USE='SideSillGroup')])])])]),
        Transform(DEF='MessageBoardTransform',
          children=[
          Transform(scale=(1.5,1,1),translation=(0,1.2,-1.299),
            children=[
            Shape(
              appearance=Appearance(
                texture=ImageTexture(repeatS=False,repeatT=False,url=["MessageBoard.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/MessageBoard.jpg"])),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,
                coord=Coordinate(point=[(-.5,-.5,0),(.5,-.5,0),(.5,.5,0),(-.5,.5,0)])))]),
          Transform(translation=(0,1.2,-1.3),
            children=[
            Group(DEF='MessageBoardFrameGroup',
              children=[
              Transform(translation=(.005,-.461,0),
                children=[
                Shape(
                  geometry=Box(size=(1.548,.075,.04)),
                  appearance=Appearance(USE='Frame'))]),
              Transform(translation=(.005,.485,0),
                children=[
                Shape(
                  geometry=Box(size=(1.548,.075,.04)),
                  appearance=Appearance(USE='Frame'))]),
              Transform(translation=(.741,0,0),
                children=[
                Shape(
                  geometry=Box(size=(.075,.9,.04)),
                  appearance=Appearance(USE='Frame'))]),
              Transform(translation=(-.730,0,0),
                children=[
                Shape(
                  geometry=Box(size=(.075,.9,.04)),
                  appearance=Appearance(USE='Frame'))])])])]),
        Transform(DEF='RealStuffTransform',scale=(.6,.6,.6),translation=(-1.15,1.2,1.299),
          children=[
          Transform(rotation=(0,1,0,3.14),scale=(1.5,1,1),
            children=[
            Shape(
              appearance=Appearance(
                texture=ImageTexture(repeatS=False,repeatT=False,url=["RealStuff.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/RealStuff.jpg"])),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,
                coord=Coordinate(point=[(-.5,-.5,0),(.5,-.5,0),(.5,.5,0),(-.5,.5,0)])))]),
          Transform(scale=(1.06,1.06,1.06),
            children=[
            Group(DEF='RealStuffFrameGroup',
              children=[
              Transform(translation=(.005,-.461,0),
                children=[
                Shape(
                  geometry=Box(size=(1.548,.075,.04)),
                  appearance=Appearance(USE='Frame'))]),
              Transform(translation=(.005,.485,0),
                children=[
                Shape(
                  geometry=Box(size=(1.548,.075,.04)),
                  appearance=Appearance(USE='Frame'))]),
              Transform(translation=(.741,0,0),
                children=[
                Shape(
                  geometry=Box(size=(.075,.9,.04)),
                  appearance=Appearance(USE='Frame'))]),
              Transform(translation=(-.730,0,0),
                children=[
                Shape(
                  geometry=Box(size=(.075,.9,.04)),
                  appearance=Appearance(USE='Frame'))])])])])]),
      Transform(DEF='Yard',
        children=[
        Transform(DEF='AllGrass',
          children=[
          Transform(DEF='LeftGrass',translation=(0,-.011,0),
            children=[
            Shape(
              appearance=Appearance(DEF='GrassPattern',
                texture=ImageTexture(url=["grass.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/grass.jpg"])),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                coord=Coordinate(point=[(-.5,0,1.5),(-5.5,0,1.5),(-5.5,0,7.5),(-.5,0,7.5)]),
                texCoord=TextureCoordinate(point=[(0,0),(10,0),(10,10),(0,10)])))]),
          Transform(DEF='RightGrass',translation=(0,-.011,0),
            children=[
            Shape(
              appearance=Appearance(USE='GrassPattern'),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                coord=Coordinate(point=[(.5,0,1.5),(5.5,0,1.5),(5.5,0,7.5),(.5,0,7.5)]),
                texCoord=TextureCoordinate(point=[(0,0),(10,0),(10,10),(0,10)])))]),
          Transform(DEF='LeftSideGrass',translation=(0,-.011,0),
            children=[
            Shape(
              appearance=Appearance(USE='GrassPattern'),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                coord=Coordinate(point=[(-2,0,1.5),(-5.5,0,1.5),(-5.5,0,-1.5),(-2,0,-1.5)]),
                texCoord=TextureCoordinate(point=[(0,0),(10,0),(10,10),(0,10)])))]),
          Transform(DEF='RightSideGrass',translation=(0,-.011,0),
            children=[
            Shape(
              appearance=Appearance(USE='GrassPattern'),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                coord=Coordinate(point=[(2,0,1.5),(5.5,0,1.5),(5.5,0,-1.5),(2,0,-1.5)]),
                texCoord=TextureCoordinate(point=[(0,0),(10,0),(10,10),(0,10)])))]),
          Transform(DEF='BackGrass',translation=(0,-.011,0),
            children=[
            Shape(
              appearance=Appearance(USE='GrassPattern'),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                coord=Coordinate(point=[(-5.5,0,-1.5),(5.5,0,-1.5),(5.5,0,-7.5),(-5.5,0,-7.5)]),
                texCoord=TextureCoordinate(point=[(0,0),(30,0),(30,15),(0,15)])))])]),
        Transform(DEF='Walkway',translation=(0,-.011,0),
          children=[
          Shape(
            appearance=Appearance(DEF='WalkwayConcrete',
              texture=ImageTexture(url=["Concrete.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Concrete.jpg"])),
            geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
              coord=Coordinate(point=[(-.5,0,1.5),(.5,0,1.5),(.5,0,7.5),(-.5,0,7.5)]),
              texCoord=TextureCoordinate(point=[(0,0),(2,0),(2,10),(0,10)])))]),
        Transform(DEF='Fence',
          children=[
          Group(DEF='FenceGroup',
            children=[
            Transform(DEF='FenceSection',
              children=[
              Transform(translation=(0,0,7.5),
                children=[
                Group(
                  children=[
                  Shape(
                    appearance=Appearance(DEF='RightFence',
                      texture=ImageTexture(DEF='FenceImage',url=["Fence.png","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Fence.png"])),
                    geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                      coord=Coordinate(point=[(0.5,0,0),(5.5,0,0),(5.5,0.5,0),(0.5,0.5,0)]),
                      texCoord=TextureCoordinate(point=[(0,0),(10,0),(10,1),(0,1)])))])])])]),
          Transform(center=(0,0,7.5),rotation=(0,1,0,3.14),
            children=[
            Group(USE='FenceGroup')]),
          Transform(translation=(5.5,0,0),
            children=[
            Shape(
              appearance=Appearance(
                texture=ImageTexture(USE='FenceImage')),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                coord=Coordinate(point=[(0,0,7.5),(0,0,-7.5),(0,0.5,-7.5),(0,0.5,7.5)]),
                texCoord=TextureCoordinate(point=[(0,0),(30,0),(30,1),(0,1)])))]),
          Transform(translation=(-5.5,0,0),
            children=[
            Shape(
              appearance=Appearance(
                texture=ImageTexture(USE='FenceImage')),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                coord=Coordinate(point=[(0,0,7.5),(0,0,-7.5),(0,0.5,-7.5),(0,0.5,7.5)]),
                texCoord=TextureCoordinate(point=[(0,0),(30,0),(30,1),(0,1)])))]),
          Transform(rotation=(0,1,0,3.14),translation=(0,0,-7.5),
            children=[
            Shape(
              appearance=Appearance(
                texture=ImageTexture(USE='FenceImage')),
              geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                coord=Coordinate(point=[(-5.5,0,0),(5.5,0,0),(5.5,0.5,0),(-5.5,0.5,0)]),
                texCoord=TextureCoordinate(point=[(0,0),(22,0),(22,1),(0,1)])))])]),
        Transform(DEF='Trees',
          children=[
          Transform(translation=(4,.5,-1),
            children=[
            Group(DEF='FirstTree',
              children=[
              Shape(
                appearance=Appearance(DEF='Tree1',
                  texture=ImageTexture(repeatS=False,repeatT=False,url=["tree1.png","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tree1.png"])),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                  coord=Coordinate(point=[(-0.5,-0.5,0),(0.5,-0.5,0),(0.5,0.5,0),(-0.5,0.5,0)]))),
              Transform(rotation=(0,1,0,1.57),translation=(.03,0,.02),
                children=[
                Shape(
                  appearance=Appearance(USE='Tree1'),
                  geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,
                    coord=Coordinate(point=[(-0.5,-0.5,0),(0.5,-0.5,0),(0.5,0.5,0),(-0.5,0.5,0)])))])])]),
          Transform(translation=(-4,.5,-1),
            children=[
            Group(USE='FirstTree')])]),
        Transform(DEF='AllBushes',
          children=[
          Transform(translation=(0,0,-7),
            children=[
            Group(DEF='Bushes',
              children=[
              Shape(DEF='BushRow',
                appearance=Appearance(DEF='BushPattern',
                  texture=ImageTexture(repeatT=False,url=["BushPattern.png","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/BushPattern.png"])),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,texCoordIndex=[0,1,2,3],
                  coord=Coordinate(point=[(-5.5,0,0),(5.5,0,0),(5.5,0.5,0),(-5.5,0.5,0)]),
                  texCoord=TextureCoordinate(point=[(0,0),(20,0),(20,1),(0,1)]))),
              Transform(translation=(0,0,-.3),
                children=[
                Shape(USE='BushRow')])])]),
          Transform(translation=(0,.25,-13.5),
            children=[
            Transform(rotation=(0,1,0,.45),
              children=[
              Viewpoint(DEF='BushesView',description='Bushes in Backyard',fieldOfView=1.2)])])])]),
      Transform(DEF='FurnishingsTransform',
        children=[
        Group(DEF='Furnishing',
          children=[
          Transform(DEF='ToyTransform',rotation=(0,1,0,-1.57),scale=(.05,.05,.05),translation=(.15,.7,0),
            children=[
            Inline(url=["IkeaBeadToy.x3d","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaBeadToy.x3d","IkeaBeadToy.wrl","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaBeadToy.wrl"])]),
          Transform(DEF='MatTransform',scale=(1,1,.67),translation=(0,.001,0),
            children=[
            Group(DEF='AlphabetMat',
              children=[
              Shape(
                appearance=Appearance(
                  texture=ImageTexture(url=["MatTransparent.png","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/MatTransparent.png"])),
                geometry=IndexedFaceSet(coordIndex=[0,1,2,3],solid=False,
                  coord=Coordinate(point=[(-1,0,-1),(1,0,-1),(1,0,1),(-1,0,1)])))])]),
          Transform(DEF='TableTranslation',translation=(0,.61,0),
            children=[
            Inline(url=["IkeaTable.x3d","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaTable.x3d","IkeaTable.wrl","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaTable.wrl"])]),
          Transform(DEF='BlueChairTransform',rotation=(0,1,0,1.57),translation=(-.67,.31,0),
            children=[
            Inline(url=["IkeaBlueChair.x3d","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaBlueChair.x3d","IkeaBlueChair.wrl","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaBlueChair.wrl"])]),
          Transform(DEF='GreenChairTransform',rotation=(0,1,0,4.71),translation=(.67,.31,0),
            children=[
            Inline(url=["IkeaGreenChair.x3d","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaGreenChair.x3d","IkeaGreenChair.wrl","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaGreenChair.wrl"])]),
          Transform(DEF='BenchTransform',rotation=(0,1,0,3.14),translation=(0,.31,.45),
            children=[
            Inline(url=["IkeaBench.x3d","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaBench.x3d","IkeaBench.wrl","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaBench.wrl"])]),
          Transform(rotation=(0,1,0,.7),scale=(.015,.015,.015),translation=(-1.05,0,-.45),
            children=[
            Inline(url=["IkeaRockingHorse.x3d","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaRockingHorse.x3d","IkeaRockingHorse.wrl","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaRockingHorse.wrl"])])])])]),
    Group(DEF='ViewpointsGroup',
      children=[
      Viewpoint(DEF='FrontEntrance',description='Front Entrance',orientation=(1,0,0,-.15),position=(0,1.15,7)),
      Viewpoint(DEF='AtticView',description='Inside Attic',fieldOfView=1.3,orientation=(1,0,0,0),position=(0,2.3,.6)),
      Transform(DEF='TreeViewTransform',center=(5,1.3,0),rotation=(0,1,0,.78),
        children=[
        Viewpoint(DEF='TreeView',description='Tree Outside',fieldOfView=1.2,orientation=(1,0,0,-.5),position=(5,1.3,0))]),
      Viewpoint(DEF='LightView',description='LightBulb',fieldOfView=1.3,orientation=(1,0,0,0),position=(0,1.9,.6)),
      Viewpoint(DEF='AboveOutside',description='Aerial View',orientation=(1,0,0,-.35),position=(0,5,10)),
      Transform(DEF='OverheadViewTransform',translation=(1.4,1.9,1.1),
        children=[
        Transform(rotation=(0,1,0,.78),
          children=[
          Viewpoint(DEF='OverheadView',description='OverHead',fieldOfView=1.2,orientation=(1,0,0,-.45),position=(0,0,0))])]),
      Transform(DEF='FromMessageBoardTransform',rotation=(0,1,0,3.14),
        children=[
        Viewpoint(DEF='FromMessageBoardView',description='Back Against Board',fieldOfView=1.3,orientation=(1,0,0,-.2),position=(0,1,.9))]),
      Viewpoint(DEF='InRoom',description='Enter Room',fieldOfView=1.2,orientation=(1,0,0,-.15),position=(0,1,1.3)),
      Viewpoint(DEF='RealStuffView',description='Real Stuff Picture',orientation=(0,1,0,3.14),position=(-1.15,1.2,.5)),
      Transform(DEF='HorseTransform',
        children=[
        Viewpoint(DEF='HorseSideView',description='Horse Side View',position=(-1,.3,.5))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for PlayRoom.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python PlayRoom.py load and self-test diagnostics complete.")
