####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python LaetitiaSprints.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='LaetitiaSprints.x3d',name='title'),
    meta(content='An animation of human body modeled and animated in 3d Studio Max environment and then translated into x3d environment.',name='description'),
    meta(content='by Yilmaz Degirmenci',name='creator'),
    meta(content='by Yilmaz Degirmenci',name='translator'),
    meta(content='24 April 2002',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Not in H-Anim form.',name='warning'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/LaetitiaSprints.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='LaetitiaSprints.x3d'),
    Transform(rotation=(1,0,0,-1.3),scale=(1.5,1.5,1.5),translation=(0,-2,-10),
      children=[
      Inline(url=["../UniversalMediaMaterials/gridBack.wrl","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.wrl","../UniversalMediaMaterials/gridBack.x3d","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaMaterials/gridBack.x3d"]),
      Transform(rotation=(0,1,0,1.45),scale=(.42,.42,.42),translation=(0,5,0.05),
        children=[
        Transform(DEF='Body',rotation=(0,0,1,-1.57),scale=(0.023,0.028,0.013),
          children=[
          TimeSensor(DEF='Body-TIMER',cycleInterval=14.07,loop=True),
          Shape(
            appearance=Appearance(
              material=Material(ambientIntensity=1.0,diffuseColor=(0.01961,0.3529,0.3098),shininess=0.145),
              texture=ImageTexture(url=["LaetitiaBodyTemplateColor.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/LaetitiaBodyTemplateColor.jpg"])),
            geometry=IndexedFaceSet(DEF='Body-FACES',ccw=False,coordIndex=[5,7,6,-1,7,9,6,-1,2,10,1,-1,10,2,8,-1,9,10,8,-1,8,6,9,-1,7,5,11,-1,0,3,4,-1,11,4,3,-1,5,4,11,-1,14,15,16,-1,16,15,17,-1,2,1,18,-1,18,12,2,-1,17,12,18,-1,12,17,15,-1,16,19,14,-1,0,13,3,-1,19,3,13,-1,14,19,13,-1,23,22,20,-1,23,20,21,-1,23,22,20,-1,23,20,21,-1,31,32,33,-1,30,32,31,-1,31,29,28,-1,31,33,29,-1,33,32,20,-1,32,73,20,-1,32,74,73,-1,32,30,74,-1,30,86,74,-1,74,34,72,-1,12,72,2,-1,36,37,27,-1,4,5,38,-1,38,36,4,-1,39,38,40,-1,38,5,40,-1,6,40,5,-1,0,36,26,-1,36,0,4,-1,40,6,8,-1,41,44,42,-1,42,44,43,-1,44,28,45,-1,44,45,43,-1,43,46,42,-1,42,46,47,-1,42,47,48,-1,42,48,41,-1,87,48,49,-1,47,39,50,-1,47,50,48,-1,48,50,51,-1,48,52,49,-1,48,51,52,-1,8,52,51,-1,40,51,50,-1,40,50,39,-1,40,8,51,-1,8,2,52,-1,26,36,27,-1,39,53,38,-1,54,38,53,-1,27,37,25,-1,55,103,37,-1,36,38,56,-1,56,37,36,-1,53,39,46,-1,47,46,39,-1,35,101,102,-1,101,35,104,-1,56,38,54,-1,37,56,59,-1,37,59,95,-1,62,43,63,-1,45,64,63,-1,63,43,45,-1,43,92,46,-1,88,41,30,-1,49,52,72,-1,34,49,72,-1,87,49,34,-1,65,64,29,-1,33,65,29,-1,33,20,93,-1,30,31,88,-1,31,28,88,-1,86,30,41,-1,28,29,45,-1,45,29,64,-1,66,61,67,-1,55,66,68,-1,68,58,55,-1,67,68,66,-1,57,60,92,-1,69,67,61,-1,70,75,76,-1,67,69,70,-1,65,33,71,-1,2,72,52,-1,78,27,79,-1,13,80,14,-1,80,13,78,-1,81,82,80,-1,80,82,14,-1,15,14,82,-1,0,26,78,-1,78,13,0,-1,82,12,15,-1,73,83,81,-1,73,74,83,-1,74,84,83,-1,74,72,84,-1,12,84,72,-1,82,83,84,-1,82,81,83,-1,82,84,12,-1,26,27,78,-1,81,80,22,-1,85,22,80,-1,27,25,79,-1,100,79,25,-1,78,21,80,-1,21,78,79,-1,22,20,81,-1,73,81,20,-1,99,76,98,-1,98,104,35,-1,21,85,80,-1,85,21,22,-1,20,22,21,-1,79,77,21,-1,79,75,97,-1,87,86,41,-1,86,34,74,-1,86,87,34,-1,41,48,87,-1,75,70,69,-1,88,28,44,-1,44,41,88,-1,62,66,55,-1,93,24,89,-1,89,75,71,-1,69,65,71,-1,61,65,69,-1,64,65,61,-1,64,61,63,-1,63,61,66,-1,57,62,55,-1,75,89,97,-1,69,71,75,-1,90,46,53,-1,91,21,22,-1,20,22,21,-1,23,22,20,-1,23,20,21,-1,66,62,63,-1,43,62,92,-1,33,93,71,-1,62,57,92,-1,96,57,55,-1,93,89,71,-1,97,89,24,-1,79,94,77,-1,96,60,57,-1,37,96,55,-1,37,95,96,-1,95,60,96,-1,97,24,94,-1,79,97,94,-1,98,76,75,-1,100,25,98,-1,35,99,98,-1,75,100,98,-1,75,79,100,-1,55,101,103,-1,101,55,58,-1,102,101,58,-1,103,101,25,-1,103,25,37,-1,98,25,104,-1,101,104,25,-1,105,106,201,-1,108,109,110,-1,105,201,110,-1,107,201,106,-1,106,56,107,-1,109,53,110,-1,110,59,105,-1,92,110,46,-1,59,110,60,-1,92,60,110,-1,56,106,59,-1,105,59,106,-1,111,837,112,-1,112,109,113,-1,108,107,114,-1,114,113,108,-1,115,56,111,-1,837,111,56,-1,113,109,108,-1,109,112,53,-1,115,107,56,-1,107,115,114,-1,111,116,117,-1,111,117,118,-1,112,119,116,-1,121,120,122,-1,123,121,124,-1,123,124,125,-1,123,120,121,-1,119,122,120,-1,123,125,126,-1,118,127,128,-1,124,129,130,-1,131,132,129,-1,130,133,128,-1,133,132,134,-1,132,133,130,-1,132,119,134,-1,125,124,130,-1,129,132,130,-1,132,131,122,-1,119,132,122,-1,126,125,130,-1,112,113,134,-1,134,119,112,-1,133,134,113,-1,113,114,133,-1,133,114,128,-1,116,119,120,-1,116,120,123,-1,116,126,117,-1,112,116,111,-1,115,118,114,-1,111,118,115,-1,128,126,130,-1,117,126,127,-1,128,114,118,-1,126,128,127,-1,116,123,126,-1,118,117,127,-1,135,136,137,-1,138,122,139,-1,124,121,140,-1,121,137,140,-1,137,121,135,-1,122,138,121,-1,141,142,143,-1,144,145,141,-1,146,145,147,-1,148,145,146,-1,148,142,141,-1,145,148,141,-1,147,145,144,-1,142,137,136,-1,142,136,143,-1,149,150,146,-1,151,152,150,-1,151,150,153,-1,150,152,146,-1,149,153,150,-1,154,155,151,-1,156,157,155,-1,156,155,158,-1,159,160,156,-1,155,157,151,-1,161,160,159,-1,160,157,156,-1,154,158,155,-1,162,161,159,-1,163,164,162,-1,165,166,164,-1,165,164,167,-1,168,161,165,-1,140,137,161,-1,166,161,162,-1,164,166,162,-1,161,166,165,-1,140,161,168,-1,167,164,163,-1,138,135,121,-1,169,139,131,-1,139,122,131,-1,170,131,171,-1,169,131,170,-1,140,172,129,-1,171,129,172,-1,171,131,129,-1,169,170,143,-1,140,129,124,-1,143,136,169,-1,173,174,141,-1,143,175,176,-1,141,174,144,-1,146,147,174,-1,173,176,146,-1,146,176,177,-1,144,174,147,-1,177,176,175,-1,141,176,173,-1,175,143,170,-1,177,178,179,-1,180,181,146,-1,146,181,149,-1,153,181,151,-1,151,179,182,-1,151,180,179,-1,181,153,149,-1,182,179,178,-1,146,179,180,-1,182,183,184,-1,151,185,154,-1,182,184,151,-1,158,185,156,-1,156,186,184,-1,185,158,154,-1,151,186,185,-1,156,185,186,-1,187,188,162,-1,162,188,163,-1,167,188,165,-1,165,189,168,-1,165,187,189,-1,168,190,140,-1,140,190,172,-1,188,167,163,-1,162,159,187,-1,159,190,189,-1,159,184,183,-1,159,156,184,-1,151,184,186,-1,177,179,146,-1,181,180,151,-1,143,176,141,-1,174,173,146,-1,168,189,190,-1,159,189,187,-1,188,187,165,-1,191,192,193,-1,194,192,191,-1,135,194,191,-1,192,194,195,-1,196,194,197,-1,194,138,197,-1,138,194,135,-1,191,136,135,-1,193,192,195,-1,195,194,196,-1,197,138,139,-1,191,198,136,-1,169,136,198,-1,193,199,191,-1,193,200,199,-1,191,199,198,-1,196,200,195,-1,196,198,199,-1,197,169,196,-1,139,169,197,-1,169,198,196,-1,193,195,200,-1,200,196,199,-1,142,160,137,-1,160,161,137,-1,177,175,178,-1,178,183,182,-1,183,190,159,-1,183,172,190,-1,183,171,172,-1,183,178,171,-1,171,178,175,-1,175,170,171,-1,152,160,142,-1,142,148,152,-1,146,152,148,-1,151,157,152,-1,152,157,160,-1,46,110,53,-1,59,60,95,-1,201,108,110,-1,107,108,201,-1,202,298,203,-1,205,207,206,-1,202,207,298,-1,204,203,298,-1,203,204,21,-1,206,207,299,-1,207,202,77,-1,93,20,207,-1,77,24,207,-1,93,207,24,-1,21,77,203,-1,202,203,77,-1,838,209,299,-1,299,300,838,-1,209,210,206,-1,205,211,204,-1,211,205,210,-1,212,208,21,-1,300,21,208,-1,210,205,206,-1,206,299,209,-1,212,21,204,-1,204,211,212,-1,208,214,213,-1,208,215,214,-1,209,213,216,-1,218,219,217,-1,220,221,218,-1,220,222,221,-1,220,218,217,-1,216,217,219,-1,220,223,222,-1,215,225,224,-1,221,227,226,-1,228,226,229,-1,227,225,230,-1,230,231,229,-1,229,227,230,-1,229,231,216,-1,222,227,221,-1,226,227,229,-1,229,219,228,-1,216,219,229,-1,223,227,222,-1,209,231,210,-1,231,209,216,-1,230,210,231,-1,210,230,211,-1,230,225,211,-1,213,217,216,-1,213,220,217,-1,213,214,223,-1,209,208,213,-1,212,211,215,-1,208,212,215,-1,225,227,223,-1,214,224,223,-1,225,215,211,-1,223,224,225,-1,213,223,220,-1,215,224,214,-1,232,234,233,-1,235,236,219,-1,221,237,218,-1,218,237,234,-1,234,232,218,-1,219,218,235,-1,238,240,239,-1,241,238,242,-1,243,244,242,-1,245,243,242,-1,245,238,239,-1,242,238,245,-1,244,241,242,-1,239,233,234,-1,239,240,233,-1,246,243,247,-1,248,247,249,-1,248,250,247,-1,247,243,249,-1,246,247,250,-1,251,248,252,-1,253,252,254,-1,253,255,252,-1,256,253,257,-1,252,248,254,-1,258,256,257,-1,257,253,254,-1,251,252,255,-1,259,256,258,-1,260,259,261,-1,262,261,263,-1,262,264,261,-1,265,262,258,-1,237,258,234,-1,263,259,258,-1,261,259,263,-1,258,262,263,-1,237,265,258,-1,264,260,261,-1,235,218,232,-1,266,228,236,-1,236,228,219,-1,267,268,228,-1,266,267,228,-1,237,226,269,-1,268,269,226,-1,268,226,228,-1,266,240,267,-1,237,221,226,-1,240,266,233,-1,270,238,271,-1,240,273,272,-1,238,241,271,-1,243,271,244,-1,270,243,273,-1,243,274,273,-1,241,244,271,-1,274,272,273,-1,238,270,273,-1,272,267,240,-1,274,276,275,-1,277,243,278,-1,243,246,278,-1,250,248,278,-1,248,279,276,-1,248,276,277,-1,278,246,250,-1,279,275,276,-1,243,277,276,-1,279,281,280,-1,248,251,282,-1,279,248,281,-1,255,253,282,-1,253,281,283,-1,282,251,255,-1,248,282,283,-1,253,283,282,-1,284,259,285,-1,259,260,285,-1,264,262,285,-1,262,265,286,-1,262,286,284,-1,265,237,287,-1,237,269,287,-1,285,260,264,-1,259,284,256,-1,256,286,287,-1,256,280,281,-1,256,281,253,-1,248,283,281,-1,274,243,276,-1,278,248,277,-1,240,238,273,-1,271,243,270,-1,265,287,286,-1,256,284,286,-1,285,262,284,-1,288,290,289,-1,291,288,289,-1,232,288,291,-1,289,292,291,-1,293,294,291,-1,291,294,235,-1,235,232,291,-1,288,232,233,-1,290,292,289,-1,292,293,291,-1,294,236,235,-1,288,233,295,-1,266,295,233,-1,290,288,296,-1,290,296,297,-1,288,295,296,-1,293,292,297,-1,293,296,295,-1,294,293,266,-1,236,294,266,-1,266,293,295,-1,290,297,292,-1,297,296,293,-1,239,234,257,-1,257,234,258,-1,274,275,272,-1,275,279,280,-1,280,256,287,-1,280,287,269,-1,280,269,268,-1,280,268,275,-1,268,272,275,-1,272,268,267,-1,249,239,257,-1,239,249,245,-1,243,245,249,-1,248,249,254,-1,249,257,254,-1,20,299,207,-1,77,94,24,-1,298,207,205,-1,204,298,205,-1,302,305,304,-1,309,17,310,-1,18,310,17,-1,1,301,310,-1,310,18,1,-1,307,17,309,-1,19,16,308,-1,306,3,311,-1,311,3,19,-1,19,308,311,-1,17,307,16,-1,16,307,308,-1,310,301,302,-1,312,314,313,-1,313,314,315,-1,314,316,315,-1,314,317,316,-1,317,318,320,-1,316,317,320,-1,318,321,320,-1,318,322,321,-1,321,322,323,-1,322,324,323,-1,322,312,324,-1,312,319,324,-1,319,313,325,-1,316,320,326,-1,320,321,326,-1,326,321,327,-1,321,323,327,-1,327,323,328,-1,323,329,328,-1,323,324,329,-1,324,319,329,-1,329,319,325,-1,325,331,330,-1,325,313,331,-1,313,332,331,-1,313,315,332,-1,315,316,332,-1,332,316,333,-1,316,334,333,-1,316,326,334,-1,326,327,335,-1,334,326,335,-1,327,336,335,-1,327,328,336,-1,328,329,336,-1,336,329,337,-1,329,325,337,-1,337,325,330,-1,330,331,338,-1,338,331,339,-1,331,340,339,-1,331,332,340,-1,332,333,340,-1,340,333,341,-1,333,342,341,-1,333,334,342,-1,342,334,302,-1,310,302,336,-1,337,330,338,-1,338,343,307,-1,339,344,338,-1,337,309,336,-1,309,338,307,-1,302,334,335,-1,338,309,337,-1,309,310,336,-1,304,341,302,-1,335,336,302,-1,341,342,302,-1,338,344,343,-1,345,347,346,-1,348,303,347,-1,348,347,345,-1,346,347,311,-1,349,350,303,-1,349,303,348,-1,347,303,306,-1,345,343,344,-1,346,311,308,-1,346,308,343,-1,345,344,339,-1,345,339,351,-1,351,339,340,-1,352,351,340,-1,345,351,348,-1,351,352,353,-1,351,353,348,-1,348,353,349,-1,352,340,341,-1,352,354,353,-1,353,354,355,-1,353,355,349,-1,349,355,350,-1,354,341,355,-1,355,304,356,-1,355,356,350,-1,341,304,355,-1,354,352,341,-1,312,313,319,-1,347,306,311,-1,307,343,308,-1,346,343,345,-1,357,358,312,-1,358,314,312,-1,358,359,314,-1,359,360,314,-1,317,360,361,-1,314,360,317,-1,317,361,318,-1,361,362,318,-1,362,322,318,-1,362,363,322,-1,322,364,312,-1,322,363,364,-1,364,357,312,-1,365,358,357,-1,365,366,358,-1,366,359,358,-1,366,367,359,-1,367,368,359,-1,359,368,360,-1,368,361,360,-1,368,369,361,-1,369,362,361,-1,369,370,362,-1,370,363,362,-1,370,371,363,-1,371,372,363,-1,363,372,364,-1,372,365,364,-1,364,365,357,-1,373,366,365,-1,373,374,366,-1,374,367,366,-1,374,375,367,-1,375,376,367,-1,367,376,368,-1,376,369,368,-1,376,377,369,-1,377,370,369,-1,377,378,370,-1,378,371,370,-1,378,379,371,-1,379,380,371,-1,371,380,372,-1,380,373,372,-1,372,373,365,-1,381,382,383,-1,381,383,384,-1,382,385,386,-1,382,386,387,-1,388,389,390,-1,388,390,391,-1,389,392,393,-1,389,393,390,-1,392,394,395,-1,392,395,393,-1,394,396,397,-1,394,397,395,-1,396,384,398,-1,396,398,397,-1,384,383,399,-1,384,399,398,-1,383,387,399,-1,387,386,400,-1,387,400,399,-1,386,388,391,-1,386,391,400,-1,396,381,384,-1,401,396,394,-1,401,394,392,-1,402,392,389,-1,402,401,392,-1,402,389,388,-1,385,388,386,-1,382,387,383,-1,393,403,390,-1,395,404,393,-1,393,404,403,-1,391,390,405,-1,390,403,405,-1,397,406,395,-1,395,406,404,-1,391,405,406,-1,397,391,406,-1,377,388,385,-1,377,385,379,-1,375,402,388,-1,375,388,377,-1,379,385,382,-1,375,373,396,-1,375,396,401,-1,373,379,381,-1,373,381,396,-1,379,382,381,-1,375,401,402,-1,302,407,408,-1,411,412,9,-1,10,9,412,-1,1,412,301,-1,412,1,10,-1,409,411,9,-1,11,410,7,-1,306,413,3,-1,413,11,3,-1,11,413,410,-1,9,7,409,-1,7,410,409,-1,412,302,301,-1,414,415,416,-1,415,417,416,-1,416,417,418,-1,416,418,419,-1,419,422,420,-1,418,422,419,-1,420,422,423,-1,420,423,424,-1,423,425,424,-1,424,425,426,-1,424,426,414,-1,414,426,421,-1,421,427,415,-1,418,428,422,-1,423,428,429,-1,422,428,423,-1,423,429,425,-1,429,430,425,-1,425,430,431,-1,425,431,426,-1,426,431,421,-1,431,427,421,-1,427,432,433,-1,427,433,415,-1,415,433,434,-1,415,434,417,-1,417,434,418,-1,434,435,418,-1,418,435,436,-1,418,436,428,-1,429,428,437,-1,428,436,437,-1,429,437,438,-1,429,438,430,-1,430,438,431,-1,438,439,431,-1,431,439,427,-1,439,432,427,-1,432,440,433,-1,440,441,433,-1,433,441,442,-1,433,442,434,-1,434,442,435,-1,442,341,435,-1,435,341,443,-1,435,443,436,-1,436,302,437,-1,412,438,302,-1,439,440,432,-1,440,409,444,-1,441,440,445,-1,439,438,411,-1,411,409,440,-1,443,302,436,-1,440,439,411,-1,411,438,412,-1,407,302,341,-1,437,302,438,-1,341,302,443,-1,440,444,445,-1,446,447,448,-1,449,448,303,-1,449,446,448,-1,447,413,448,-1,349,303,450,-1,349,449,303,-1,448,306,303,-1,446,445,444,-1,447,410,413,-1,447,444,410,-1,446,441,445,-1,446,451,441,-1,451,442,441,-1,452,442,451,-1,446,449,451,-1,451,453,452,-1,451,449,453,-1,449,349,453,-1,452,341,442,-1,452,453,454,-1,453,455,454,-1,453,349,455,-1,349,450,455,-1,454,455,341,-1,455,456,407,-1,455,450,456,-1,341,455,407,-1,454,341,452,-1,414,421,415,-1,448,413,306,-1,409,410,444,-1,447,446,444,-1,457,414,458,-1,458,414,416,-1,458,416,459,-1,459,416,460,-1,419,461,460,-1,416,419,460,-1,419,420,461,-1,461,420,462,-1,462,420,424,-1,462,424,463,-1,424,414,464,-1,424,464,463,-1,464,414,457,-1,465,457,458,-1,465,458,466,-1,466,458,459,-1,466,459,467,-1,467,459,468,-1,459,460,468,-1,468,460,461,-1,468,461,469,-1,469,461,462,-1,469,462,470,-1,470,462,463,-1,470,463,471,-1,471,463,472,-1,463,464,472,-1,472,464,465,-1,464,457,465,-1,473,465,466,-1,473,466,474,-1,474,466,467,-1,474,467,475,-1,475,467,476,-1,467,468,476,-1,476,468,469,-1,476,469,477,-1,477,469,470,-1,477,470,478,-1,478,470,471,-1,478,471,479,-1,479,471,480,-1,471,472,480,-1,480,472,473,-1,472,465,473,-1,481,483,482,-1,481,484,483,-1,482,486,485,-1,482,487,486,-1,488,490,489,-1,488,491,490,-1,489,493,492,-1,489,490,493,-1,492,495,494,-1,492,493,495,-1,494,497,496,-1,494,495,497,-1,496,498,484,-1,496,497,498,-1,484,499,483,-1,484,498,499,-1,483,499,487,-1,487,500,486,-1,487,499,500,-1,486,491,488,-1,486,500,491,-1,496,484,481,-1,501,494,496,-1,501,492,494,-1,502,489,492,-1,502,492,501,-1,502,488,489,-1,485,486,488,-1,482,483,487,-1,493,490,503,-1,495,493,504,-1,493,503,504,-1,491,505,490,-1,490,505,503,-1,497,495,506,-1,495,504,506,-1,491,506,505,-1,497,506,491,-1,477,485,488,-1,477,479,485,-1,475,488,502,-1,475,477,488,-1,479,482,485,-1,475,496,473,-1,475,501,496,-1,473,481,479,-1,473,496,481,-1,479,481,482,-1,475,502,501,-1,53,837,56,-1,837,53,112,-1,838,300,208,-1,208,209,838,-1,497,491,496,-1,491,488,496,-1,496,500,498,-1,488,500,496,-1,500,499,498,-1,504,503,505,-1,504,505,506,-1,391,397,388,-1,397,396,388,-1,388,398,400,-1,396,398,388,-1,398,399,400,-1,403,406,405,-1,403,404,406,-1],creaseAngle=10,texCoordIndex=[346,347,348,-1,347,349,348,-1,350,351,352,-1,351,350,353,-1,349,351,353,-1,353,348,349,-1,354,355,356,-1,357,358,359,-1,356,359,358,-1,355,359,356,-1,360,361,362,-1,362,361,363,-1,350,352,364,-1,364,365,350,-1,363,365,364,-1,365,363,361,-1,366,367,368,-1,357,369,358,-1,367,358,369,-1,368,367,369,-1,385,386,387,-1,385,387,388,-1,385,386,387,-1,385,387,388,-1,389,390,391,-1,392,390,389,-1,389,393,394,-1,389,391,393,-1,391,390,387,-1,390,395,387,-1,390,396,395,-1,390,392,396,-1,392,397,396,-1,396,398,399,-1,365,399,350,-1,400,401,402,-1,359,355,403,-1,403,400,359,-1,404,405,406,-1,405,346,406,-1,348,406,346,-1,357,400,407,-1,400,357,359,-1,406,348,353,-1,408,409,410,-1,410,409,411,-1,409,394,412,-1,409,412,411,-1,411,413,410,-1,410,413,414,-1,410,414,415,-1,410,415,408,-1,416,415,417,-1,414,404,418,-1,414,418,415,-1,415,418,419,-1,415,420,417,-1,415,419,420,-1,353,420,419,-1,406,419,418,-1,406,418,404,-1,406,353,419,-1,353,350,420,-1,407,400,402,-1,404,421,405,-1,422,405,421,-1,402,401,423,-1,424,425,401,-1,400,403,426,-1,426,401,400,-1,421,404,413,-1,414,413,404,-1,427,428,429,-1,428,427,430,-1,431,405,422,-1,401,426,432,-1,401,432,433,-1,434,411,435,-1,412,436,435,-1,435,411,412,-1,411,437,413,-1,438,408,392,-1,417,420,399,-1,398,417,399,-1,416,417,398,-1,439,436,393,-1,391,439,393,-1,391,387,440,-1,392,389,438,-1,389,394,438,-1,397,392,408,-1,394,393,412,-1,412,393,436,-1,441,442,443,-1,444,441,445,-1,445,446,444,-1,443,445,441,-1,447,448,437,-1,449,443,442,-1,450,451,452,-1,443,449,450,-1,439,391,453,-1,350,399,420,-1,454,402,455,-1,369,456,368,-1,456,369,454,-1,457,458,459,-1,459,458,360,-1,361,360,458,-1,357,407,454,-1,454,369,357,-1,458,365,361,-1,395,460,457,-1,395,396,460,-1,396,461,460,-1,396,399,461,-1,365,461,399,-1,458,460,461,-1,458,457,460,-1,458,461,365,-1,407,402,454,-1,457,459,386,-1,462,386,459,-1,402,423,455,-1,463,455,423,-1,454,464,456,-1,464,454,455,-1,386,387,457,-1,395,457,387,-1,465,466,467,-1,467,430,427,-1,388,462,459,-1,462,388,386,-1,387,386,388,-1,455,468,464,-1,455,469,470,-1,416,397,408,-1,397,398,396,-1,397,416,398,-1,408,415,416,-1,451,450,449,-1,438,394,409,-1,409,408,438,-1,471,441,444,-1,440,472,473,-1,474,451,475,-1,449,476,475,-1,442,476,449,-1,477,476,442,-1,477,442,478,-1,478,442,441,-1,479,471,444,-1,480,473,481,-1,449,475,451,-1,482,413,421,-1,549,388,386,-1,387,386,388,-1,385,386,387,-1,385,387,388,-1,441,471,478,-1,411,434,437,-1,391,440,453,-1,434,447,437,-1,737,447,738,-1,440,473,453,-1,481,473,472,-1,455,740,468,-1,737,448,447,-1,401,741,424,-1,401,433,741,-1,742,448,737,-1,481,472,743,-1,455,470,740,-1,467,466,744,-1,745,746,467,-1,427,465,467,-1,744,745,467,-1,469,455,463,-1,747,428,748,-1,428,747,749,-1,429,428,749,-1,748,428,746,-1,425,423,401,-1,467,746,430,-1,428,430,746,-1,1088,1090,1089,-1,1091,1093,1092,-1,1088,1089,1092,-1,1094,1089,1090,-1,1090,1095,1094,-1,1093,1096,1092,-1,1092,1097,1088,-1,1098,1092,1099,-1,1097,1092,1100,-1,1098,1100,1092,-1,1095,1090,1097,-1,1088,1097,1090,-1,1101,1096,1102,-1,1102,1093,1104,-1,1091,1094,1105,-1,1105,1104,1091,-1,1106,1095,1101,-1,1103,1101,1095,-1,1104,1093,1091,-1,1093,1102,1096,-1,1106,1094,1095,-1,1094,1106,1105,-1,1101,1108,1107,-1,1101,1107,1109,-1,1102,1110,1108,-1,1111,1113,1112,-1,1114,1111,1115,-1,1114,1115,1116,-1,1114,1113,1111,-1,1110,1112,1113,-1,1114,1116,1117,-1,1109,1119,1118,-1,1115,1121,1120,-1,1122,1123,1121,-1,1120,1124,1118,-1,1124,1123,1125,-1,1123,1124,1120,-1,1123,1110,1125,-1,1116,1115,1120,-1,1121,1123,1120,-1,1123,1122,1112,-1,1110,1123,1112,-1,1117,1116,1120,-1,1102,1104,1125,-1,1125,1110,1102,-1,1124,1125,1104,-1,1104,1105,1124,-1,1124,1105,1118,-1,1108,1110,1113,-1,1108,1113,1114,-1,1108,1117,1107,-1,1102,1108,1101,-1,1106,1109,1105,-1,1101,1109,1106,-1,1118,1117,1120,-1,1107,1117,1119,-1,1118,1105,1109,-1,1117,1118,1119,-1,1108,1114,1117,-1,1109,1107,1119,-1,1126,1128,1127,-1,1129,1131,1130,-1,1132,1134,1133,-1,1134,1127,1133,-1,1127,1134,1126,-1,1131,1129,1134,-1,1135,1137,1136,-1,1138,1139,1135,-1,1140,1139,1141,-1,1142,1139,1140,-1,1142,1137,1135,-1,1139,1142,1135,-1,1141,1139,1138,-1,1137,1127,1128,-1,1137,1128,1136,-1,1143,1144,1140,-1,1145,1146,1144,-1,1145,1144,1147,-1,1144,1146,1140,-1,1143,1147,1144,-1,1148,1149,1145,-1,1150,1151,1149,-1,1150,1149,1152,-1,1153,1154,1150,-1,1149,1151,1145,-1,1155,1154,1153,-1,1154,1151,1150,-1,1148,1152,1149,-1,1156,1155,1153,-1,1157,1158,1156,-1,1159,1160,1158,-1,1159,1158,1161,-1,1162,1155,1159,-1,1133,1127,1155,-1,1160,1155,1156,-1,1158,1160,1156,-1,1155,1160,1159,-1,1133,1155,1162,-1,1161,1158,1157,-1,1129,1126,1134,-1,1163,1130,1164,-1,1130,1131,1164,-1,1165,1164,1166,-1,1163,1164,1165,-1,1133,1168,1167,-1,1166,1167,1168,-1,1166,1164,1167,-1,1163,1165,1136,-1,1133,1167,1132,-1,1136,1128,1163,-1,1169,1170,1135,-1,1136,1172,1171,-1,1135,1170,1138,-1,1140,1141,1170,-1,1169,1171,1140,-1,1140,1171,1173,-1,1138,1170,1141,-1,1173,1171,1172,-1,1135,1171,1169,-1,1172,1136,1165,-1,1173,1175,1174,-1,1176,1177,1140,-1,1140,1177,1143,-1,1147,1177,1145,-1,1145,1174,1178,-1,1145,1176,1174,-1,1177,1147,1143,-1,1178,1174,1175,-1,1140,1174,1176,-1,1178,1180,1179,-1,1145,1181,1148,-1,1178,1179,1145,-1,1152,1181,1150,-1,1150,1182,1179,-1,1181,1152,1148,-1,1145,1182,1181,-1,1150,1181,1182,-1,1183,1184,1156,-1,1156,1184,1157,-1,1161,1184,1159,-1,1159,1185,1162,-1,1159,1183,1185,-1,1162,1186,1133,-1,1133,1186,1168,-1,1184,1161,1157,-1,1156,1153,1183,-1,1153,1186,1185,-1,1153,1179,1180,-1,1153,1150,1179,-1,1145,1179,1182,-1,1173,1174,1140,-1,1177,1176,1145,-1,1136,1171,1135,-1,1170,1169,1140,-1,1162,1185,1186,-1,1153,1185,1183,-1,1184,1183,1159,-1,1187,1189,1188,-1,1190,1189,1187,-1,1126,1190,1187,-1,1189,1190,1191,-1,1192,1190,1193,-1,1190,1129,1193,-1,1129,1190,1126,-1,1187,1128,1126,-1,1188,1189,1191,-1,1191,1190,1192,-1,1193,1129,1130,-1,1187,1194,1128,-1,1163,1128,1194,-1,1188,1195,1187,-1,1188,1196,1195,-1,1187,1195,1194,-1,1192,1196,1191,-1,1192,1194,1195,-1,1193,1163,1192,-1,1130,1163,1193,-1,1163,1194,1192,-1,1188,1191,1196,-1,1196,1192,1195,-1,1137,1154,1127,-1,1154,1155,1127,-1,1173,1172,1175,-1,1175,1180,1178,-1,1180,1186,1153,-1,1180,1168,1186,-1,1180,1166,1168,-1,1180,1175,1166,-1,1166,1175,1172,-1,1172,1165,1166,-1,1146,1154,1137,-1,1137,1142,1146,-1,1140,1146,1142,-1,1145,1151,1146,-1,1146,1151,1154,-1,1099,1092,1096,-1,1097,1100,1197,-1,1089,1091,1092,-1,1094,1091,1089,-1,1303,1304,1305,-1,1306,1307,1308,-1,1303,1307,1304,-1,1309,1305,1304,-1,1305,1309,1310,-1,1308,1307,1311,-1,1307,1303,1312,-1,1313,1314,1307,-1,1312,1315,1307,-1,1313,1307,1315,-1,1310,1312,1305,-1,1303,1305,1312,-1,1316,1317,1311,-1,1311,1318,1316,-1,1317,1319,1308,-1,1306,1320,1309,-1,1320,1306,1319,-1,1321,1316,1310,-1,1318,1310,1316,-1,1319,1306,1308,-1,1308,1311,1317,-1,1321,1310,1309,-1,1309,1320,1321,-1,1316,1322,1323,-1,1316,1324,1322,-1,1317,1323,1325,-1,1326,1327,1328,-1,1329,1330,1326,-1,1329,1331,1330,-1,1329,1326,1328,-1,1325,1328,1327,-1,1329,1332,1331,-1,1324,1333,1334,-1,1330,1335,1336,-1,1337,1336,1338,-1,1335,1333,1339,-1,1339,1340,1338,-1,1338,1335,1339,-1,1338,1340,1325,-1,1331,1335,1330,-1,1336,1335,1338,-1,1338,1327,1337,-1,1325,1327,1338,-1,1332,1335,1331,-1,1317,1340,1319,-1,1340,1317,1325,-1,1339,1319,1340,-1,1319,1339,1320,-1,1339,1333,1320,-1,1323,1328,1325,-1,1323,1329,1328,-1,1323,1322,1332,-1,1317,1316,1323,-1,1321,1320,1324,-1,1316,1321,1324,-1,1333,1335,1332,-1,1322,1334,1332,-1,1333,1324,1320,-1,1332,1334,1333,-1,1323,1332,1329,-1,1324,1334,1322,-1,1341,1342,1343,-1,1344,1345,1346,-1,1347,1348,1349,-1,1349,1348,1342,-1,1342,1341,1349,-1,1346,1349,1344,-1,1350,1351,1352,-1,1353,1350,1354,-1,1355,1356,1354,-1,1357,1355,1354,-1,1357,1350,1352,-1,1354,1350,1357,-1,1356,1353,1354,-1,1352,1343,1342,-1,1352,1351,1343,-1,1358,1355,1359,-1,1360,1359,1361,-1,1360,1362,1359,-1,1359,1355,1361,-1,1358,1359,1362,-1,1363,1360,1364,-1,1365,1364,1366,-1,1365,1367,1364,-1,1368,1365,1369,-1,1364,1360,1366,-1,1370,1368,1369,-1,1369,1365,1366,-1,1363,1364,1367,-1,1371,1368,1370,-1,1372,1371,1373,-1,1374,1373,1375,-1,1374,1376,1373,-1,1377,1374,1370,-1,1348,1370,1342,-1,1375,1371,1370,-1,1373,1371,1375,-1,1370,1374,1375,-1,1348,1377,1370,-1,1376,1372,1373,-1,1344,1349,1341,-1,1378,1379,1345,-1,1345,1379,1346,-1,1380,1381,1379,-1,1378,1380,1379,-1,1348,1382,1383,-1,1381,1383,1382,-1,1381,1382,1379,-1,1378,1351,1380,-1,1348,1347,1382,-1,1351,1378,1343,-1,1384,1350,1385,-1,1351,1386,1387,-1,1350,1353,1385,-1,1355,1385,1356,-1,1384,1355,1386,-1,1355,1388,1386,-1,1353,1356,1385,-1,1388,1387,1386,-1,1350,1384,1386,-1,1387,1380,1351,-1,1388,1389,1390,-1,1391,1355,1392,-1,1355,1358,1392,-1,1362,1360,1392,-1,1360,1393,1389,-1,1360,1389,1391,-1,1392,1358,1362,-1,1393,1390,1389,-1,1355,1391,1389,-1,1393,1394,1395,-1,1360,1363,1396,-1,1393,1360,1394,-1,1367,1365,1396,-1,1365,1394,1397,-1,1396,1363,1367,-1,1360,1396,1397,-1,1365,1397,1396,-1,1398,1371,1399,-1,1371,1372,1399,-1,1376,1374,1399,-1,1374,1377,1400,-1,1374,1400,1398,-1,1377,1348,1401,-1,1348,1383,1401,-1,1399,1372,1376,-1,1371,1398,1368,-1,1368,1400,1401,-1,1368,1395,1394,-1,1368,1394,1365,-1,1360,1397,1394,-1,1388,1355,1389,-1,1392,1360,1391,-1,1351,1350,1386,-1,1385,1355,1384,-1,1377,1401,1400,-1,1368,1398,1400,-1,1399,1374,1398,-1,1402,1403,1404,-1,1405,1402,1404,-1,1341,1402,1405,-1,1404,1406,1405,-1,1407,1408,1405,-1,1405,1408,1344,-1,1344,1341,1405,-1,1402,1341,1343,-1,1403,1406,1404,-1,1406,1407,1405,-1,1408,1345,1344,-1,1402,1343,1409,-1,1378,1409,1343,-1,1403,1402,1410,-1,1403,1410,1411,-1,1402,1409,1410,-1,1407,1406,1411,-1,1407,1410,1409,-1,1408,1407,1378,-1,1345,1408,1378,-1,1378,1407,1409,-1,1403,1411,1406,-1,1411,1410,1407,-1,1352,1342,1369,-1,1369,1342,1370,-1,1388,1390,1387,-1,1390,1393,1395,-1,1395,1368,1401,-1,1395,1401,1383,-1,1395,1383,1381,-1,1395,1381,1390,-1,1381,1387,1390,-1,1387,1381,1380,-1,1361,1352,1369,-1,1352,1361,1357,-1,1355,1357,1361,-1,1360,1361,1366,-1,1361,1369,1366,-1,1314,1311,1307,-1,1312,1412,1315,-1,1304,1307,1306,-1,1309,1304,1306,-1,1568,1567,1566,-1,1570,1571,1572,-1,1573,1572,1571,-1,1574,1575,1572,-1,1572,1573,1574,-1,1576,1571,1570,-1,1577,1578,1579,-1,1580,1581,1582,-1,1582,1581,1577,-1,1577,1579,1582,-1,1583,1584,1578,-1,1578,1584,1579,-1,1572,1575,1591,-1,1593,1594,1595,-1,1595,1594,1596,-1,1594,1597,1596,-1,1594,1598,1597,-1,1598,1599,1600,-1,1597,1598,1600,-1,1601,1602,1603,-1,1601,1604,1602,-1,1602,1604,1605,-1,1604,1606,1605,-1,1604,1607,1606,-1,1607,1608,1606,-1,1609,1595,1610,-1,1597,1600,1611,-1,1603,1612,1613,-1,1603,1602,1612,-1,1602,1605,1612,-1,1612,1605,1614,-1,1605,1615,1614,-1,1605,1606,1615,-1,1606,1608,1615,-1,1615,1608,1616,-1,1610,1617,1618,-1,1610,1595,1617,-1,1595,1619,1617,-1,1595,1596,1619,-1,1596,1597,1619,-1,1619,1597,1620,-1,1597,1621,1620,-1,1597,1611,1621,-1,1613,1622,1623,-1,1613,1612,1622,-1,1612,1624,1622,-1,1612,1614,1624,-1,1614,1615,1624,-1,1624,1615,1625,-1,1615,1616,1625,-1,1625,1616,1626,-1,1618,1617,1627,-1,1627,1617,1628,-1,1617,1629,1628,-1,1617,1619,1629,-1,1619,1620,1629,-1,1629,1620,1630,-1,1620,1631,1630,-1,1620,1621,1631,-1,1632,1622,1591,-1,1572,1591,1624,-1,1625,1626,1633,-1,1627,1634,1584,-1,1628,1635,1627,-1,1625,1570,1624,-1,1570,1633,1576,-1,1632,1623,1622,-1,1633,1570,1625,-1,1570,1572,1624,-1,1566,1636,1637,-1,1622,1624,1591,-1,1636,1638,1637,-1,1627,1635,1634,-1,1640,1641,1642,-1,1643,1644,1641,-1,1643,1641,1640,-1,1642,1641,1582,-1,1645,1646,1644,-1,1645,1644,1643,-1,1641,1644,1580,-1,1640,1634,1635,-1,1642,1582,1579,-1,1642,1579,1634,-1,1640,1635,1628,-1,1640,1628,1647,-1,1647,1628,1629,-1,1648,1647,1629,-1,1640,1647,1643,-1,1647,1648,1649,-1,1647,1649,1643,-1,1643,1649,1645,-1,1648,1629,1630,-1,1648,1650,1649,-1,1649,1650,1651,-1,1649,1651,1645,-1,1645,1651,1646,-1,1650,1630,1651,-1,1651,1652,1653,-1,1651,1653,1646,-1,1630,1652,1651,-1,1654,1655,1656,-1,1593,1595,1609,-1,1641,1580,1582,-1,1584,1634,1579,-1,1642,1634,1640,-1,1657,1658,1593,-1,1658,1594,1593,-1,1658,1659,1594,-1,1659,1660,1594,-1,1598,1660,1661,-1,1594,1660,1598,-1,1598,1661,1599,-1,1662,1663,1601,-1,1663,1604,1601,-1,1663,1664,1604,-1,1604,1665,1607,-1,1604,1664,1665,-1,1665,1666,1607,-1,1667,1658,1657,-1,1667,1668,1658,-1,1668,1659,1658,-1,1668,1669,1659,-1,1669,1670,1659,-1,1659,1670,1660,-1,1670,1661,1660,-1,1670,1671,1661,-1,1672,1663,1662,-1,1672,1673,1663,-1,1673,1664,1663,-1,1673,1674,1664,-1,1674,1675,1664,-1,1664,1675,1665,-1,1675,1676,1665,-1,1665,1676,1666,-1,1677,1668,1667,-1,1677,1678,1668,-1,1678,1669,1668,-1,1678,1679,1669,-1,1679,1680,1669,-1,1669,1680,1670,-1,1680,1671,1670,-1,1680,1681,1671,-1,1682,1673,1672,-1,1682,1683,1673,-1,1683,1674,1673,-1,1683,1684,1674,-1,1684,1685,1674,-1,1674,1685,1675,-1,1685,1686,1675,-1,1675,1686,1676,-1,1687,1688,1689,-1,1687,1689,1690,-1,1688,1691,1692,-1,1688,1692,1693,-1,1694,1695,1696,-1,1694,1696,1697,-1,1695,1698,1699,-1,1695,1699,1696,-1,1698,1700,1701,-1,1698,1701,1699,-1,1700,1702,1703,-1,1700,1703,1701,-1,1704,1690,1705,-1,1704,1705,1706,-1,1690,1689,1707,-1,1690,1707,1705,-1,1689,1693,1707,-1,1693,1692,1708,-1,1693,1708,1707,-1,1692,1709,1710,-1,1692,1710,1708,-1,1704,1687,1690,-1,1711,1702,1700,-1,1711,1700,1698,-1,1712,1698,1695,-1,1712,1711,1698,-1,1712,1695,1694,-1,1691,1709,1692,-1,1688,1693,1689,-1,1699,1713,1696,-1,1701,1714,1699,-1,1699,1714,1713,-1,1697,1696,1715,-1,1696,1713,1715,-1,1703,1716,1701,-1,1701,1716,1714,-1,1717,1718,1719,-1,1720,1717,1719,-1,1721,1722,1723,-1,1721,1723,1724,-1,1725,1726,1722,-1,1727,1694,1728,-1,1724,1723,1729,-1,1727,1730,1702,-1,1725,1731,1732,-1,1733,1724,1734,-1,1733,1734,1731,-1,1724,1729,1734,-1,1725,1732,1726,-1,1846,1844,1845,-1,1848,1850,1849,-1,1851,1849,1850,-1,1852,1850,1853,-1,1850,1852,1851,-1,1854,1848,1849,-1,1855,1857,1856,-1,1858,1860,1859,-1,1860,1855,1859,-1,1855,1860,1857,-1,1861,1856,1862,-1,1856,1857,1862,-1,1850,1869,1853,-1,1871,1873,1872,-1,1873,1874,1872,-1,1872,1874,1875,-1,1872,1875,1876,-1,1876,1878,1877,-1,1875,1878,1876,-1,1879,1881,1880,-1,1879,1880,1882,-1,1880,1883,1882,-1,1882,1883,1884,-1,1882,1884,1885,-1,1885,1884,1886,-1,1887,1888,1873,-1,1875,1889,1878,-1,1881,1891,1890,-1,1881,1890,1880,-1,1880,1890,1883,-1,1890,1892,1883,-1,1883,1892,1893,-1,1883,1893,1884,-1,1884,1893,1886,-1,1893,1894,1886,-1,1888,1896,1895,-1,1888,1895,1873,-1,1873,1895,1897,-1,1873,1897,1874,-1,1874,1897,1875,-1,1897,1898,1875,-1,1875,1898,1899,-1,1875,1899,1889,-1,1891,1901,1900,-1,1891,1900,1890,-1,1890,1900,1902,-1,1890,1902,1892,-1,1892,1902,1893,-1,1902,1903,1893,-1,1893,1903,1894,-1,1903,1904,1894,-1,1896,1905,1895,-1,1905,1906,1895,-1,1895,1906,1907,-1,1895,1907,1897,-1,1897,1907,1898,-1,1907,1908,1898,-1,1898,1908,1909,-1,1898,1909,1899,-1,1910,1869,1900,-1,1850,1902,1869,-1,1903,1911,1904,-1,1905,1862,1912,-1,1906,1905,1913,-1,1903,1902,1848,-1,1848,1854,1911,-1,1910,1900,1901,-1,1911,1903,1848,-1,1848,1902,1850,-1,1844,1915,1914,-1,1900,1869,1902,-1,1914,1915,1916,-1,1905,1912,1913,-1,1918,1920,1919,-1,1921,1919,1922,-1,1921,1918,1919,-1,1920,1860,1919,-1,1923,1922,1924,-1,1923,1921,1922,-1,1919,1858,1922,-1,1918,1913,1912,-1,1920,1857,1860,-1,1920,1912,1857,-1,1918,1906,1913,-1,1918,1925,1906,-1,1925,1907,1906,-1,1926,1907,1925,-1,1918,1921,1925,-1,1925,1927,1926,-1,1925,1921,1927,-1,1921,1923,1927,-1,1926,1908,1907,-1,1926,1927,1928,-1,1927,1929,1928,-1,1927,1923,1929,-1,1923,1924,1929,-1,1928,1929,1908,-1,1929,1931,1930,-1,1929,1924,1931,-1,1908,1929,1930,-1,1932,1934,1933,-1,1871,1887,1873,-1,1919,1860,1858,-1,1862,1857,1912,-1,1920,1918,1912,-1,1935,1871,1936,-1,1936,1871,1872,-1,1936,1872,1937,-1,1937,1872,1938,-1,1876,1939,1938,-1,1872,1876,1938,-1,1876,1877,1939,-1,1940,1879,1941,-1,1941,1879,1882,-1,1941,1882,1942,-1,1882,1885,1943,-1,1882,1943,1942,-1,1943,1885,1944,-1,1945,1935,1936,-1,1945,1936,1946,-1,1946,1936,1937,-1,1946,1937,1947,-1,1947,1937,1948,-1,1937,1938,1948,-1,1948,1938,1939,-1,1948,1939,1949,-1,1950,1940,1941,-1,1950,1941,1951,-1,1951,1941,1942,-1,1951,1942,1952,-1,1952,1942,1953,-1,1942,1943,1953,-1,1953,1943,1954,-1,1943,1944,1954,-1,1955,1945,1946,-1,1955,1946,1956,-1,1956,1946,1947,-1,1956,1947,1957,-1,1957,1947,1958,-1,1947,1948,1958,-1,1958,1948,1949,-1,1958,1949,1959,-1,1960,1950,1951,-1,1960,1951,1961,-1,1961,1951,1952,-1,1961,1952,1962,-1,1962,1952,1963,-1,1952,1953,1963,-1,1963,1953,1964,-1,1953,1954,1964,-1,1965,1967,1966,-1,1965,1968,1967,-1,1966,1970,1969,-1,1966,1971,1970,-1,1972,1974,1973,-1,1972,1975,1974,-1,1973,1977,1976,-1,1973,1974,1977,-1,1976,1979,1978,-1,1976,1977,1979,-1,1978,1981,1980,-1,1978,1979,1981,-1,1982,1983,1968,-1,1982,1984,1983,-1,1968,1985,1967,-1,1968,1983,1985,-1,1967,1985,1971,-1,1971,1986,1970,-1,1971,1985,1986,-1,1970,1988,1987,-1,1970,1986,1988,-1,1982,1968,1965,-1,1989,1978,1980,-1,1989,1976,1978,-1,1990,1973,1976,-1,1990,1976,1989,-1,1990,1972,1973,-1,1969,1970,1987,-1,1966,1967,1971,-1,1977,1974,1991,-1,1979,1977,1992,-1,1977,1991,1992,-1,1975,1993,1974,-1,1974,1993,1991,-1,1981,1979,1994,-1,1979,1992,1994,-1,1995,1997,1996,-1,1998,1997,1995,-1,1999,2001,2000,-1,1999,2002,2001,-1,2003,2000,2004,-1,2005,2006,1972,-1,2002,2007,2001,-1,2005,1980,2008,-1,2003,2010,2009,-1,2011,2012,2002,-1,2011,2009,2012,-1,2002,2012,2007,-1,2003,2004,2010,-1,1103,2375,1095,-1,2376,1096,1102,-1,2377,1318,1316,-1,1316,1317,2377,-1,2378,2379,2380,-1,2379,2381,2380,-1,2380,2382,2383,-1,2381,2382,2380,-1,2382,2384,2383,-1,2385,2386,2387,-1,2385,2387,2388,-1,2389,2390,2391,-1,2390,2392,2391,-1,2391,2393,2394,-1,2392,2393,2391,-1,2393,2395,2394,-1,2396,2397,2398,-1,2396,2399,2397,-1],
              texCoord=TextureCoordinate(DEF='Body-TEXCOORD',point=[(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.9296,0.6745),(0.9314,0.7086),(0.9309,0.6716),(0.9316,0.7092),(0.9341,0.7413),(0.05749,0.4563),(0.0593,0.4306),(0.06375,0.4546),(0.06166,0.4149),(0.1207,0.4923),(0.07767,0.3992),(0.1188,0.3911),(0.07163,0.4921),(0.3246,0.198),(0.3195,0.2147),(0.3054,0.1997),(0.2701,0.2251),(0.2689,0.1984),(0.2975,0.2228),(0.2102,0.4535),(0.1961,0.4534),(0.2048,0.4296),(0.1903,0.4146),(0.166,0.3994),(0.1714,0.4906),(0.2233,0.1988),(0.2362,0.2011),(0.2275,0.2165),(0.2394,0.2239),(0.8129,0.7538),(0.8027,0.7967),(0.7702,0.7394),(0.7816,0.7924),(0.7367,0.7894),(0.7362,0.7374),(0.83,0.7792),(0.6366,0.7985),(0.615,0.7993),(0.61,0.7851),(0.6794,0.7847),(0.6795,0.7991),(0.6396,0.785),(0.6199,0.7908),(0.6091,0.7773),(0.2321,0.5721),(0.2268,0.5802),(0.2154,0.6149),(0.2391,0.603),(0.1375,0.5801),(0.188,0.5721),(0.1747,0.5997),(0.1621,0.552),(0.1318,0.6),(0.1184,0.563),(0.2092,0.5603),(0.1945,0.5272),(0.1607,0.5344),(0.1607,0.5144),(0.174,0.5029),(0.3014,0.2618),(0.3005,0.3507),(0.2689,0.3131),(0.321,0.2575),(0.02977,0.5601),(0.04502,0.5112),(0.05098,0.5016),(0.2695,0.2618),(0.07094,0.5533),(0.09999,0.5806),(0.05123,0.5741),(0.0756,0.5956),(0.1159,0.6002),(0.05235,0.6182),(0.03709,0.5628),(0.04677,0.5319),(0.07261,0.5357),(0.07568,0.5156),(0.03577,0.529),(0.04282,0.5102),(0.0653,0.5044),(0.03497,0.5863),(0.05009,0.575),(0.2737,0.38),(0.2965,0.3748),(0.2846,0.3771),(0.3309,0.3146),(0.1413,0.7728),(0.1512,0.7561),(0.1528,0.7698),(0.1418,0.7578),(0.04345,0.6114),(0.3367,0.3446),(0.3196,0.3581),(0.1002,0.6439),(0.1123,0.6256),(0.1277,0.6205),(0.06094,0.6314),(0.1171,0.5764),(0.1412,0.6219),(0.2095,0.6318),(0.2155,0.7482),(0.2248,0.7395),(0.2264,0.7706),(0.207,0.7625),(0.2124,0.7789),(0.2067,0.7829),(0.1013,0.6609),(0.07045,0.6433),(0.2432,0.7488),(0.2443,0.7807),(0.2604,0.7569),(0.2578,0.7839),(0.1621,0.6349),(0.2426,0.2661),(0.2426,0.3508),(0.2265,0.2664),(0.2217,0.554),(0.2044,0.5029),(0.2232,0.5154),(0.2179,0.5263),(0.2054,0.5078),(0.2402,0.5735),(0.2609,0.3767),(0.219,0.3169),(0.133,0.7703),(0.1256,0.7638),(0.1299,0.7558),(0.2105,0.3444),(0.2522,0.3749),(0.2396,0.3664),(0.2021,0.7386),(0.2114,0.6449),(0.1744,0.6536),(0.267,0.7463),(0.2528,0.7323),(0.2337,0.7244),(0.2211,0.7226),(0.2074,0.7257),(0.2028,0.7484),(0.175,0.6707),(0.1895,0.6651),(0.05434,0.5749),(0.748,0.6836),(0.7365,0.6933),(0.6033,0.446),(0.6204,0.4418),(0.6053,0.4914),(0.6231,0.4906),(0.655,0.4905),(0.6504,0.4421),(0.6645,0.4446),(0.6642,0.4912),(0.7566,0.4558),(0.7568,0.5002),(0.7536,0.5057),(0.7828,0.4538),(0.7845,0.5003),(0.8138,0.5014),(0.8158,0.4578),(0.8276,0.5046),(0.5999,0.4924),(0.5934,0.5364),(0.6693,0.5344),(0.7632,0.5535),(0.7526,0.5493),(0.7899,0.5545),(0.8126,0.5527),(0.8327,0.5481),(0.5843,0.6207),(0.5821,0.631),(0.6137,0.5991),(0.6553,0.5964),(0.6803,0.616),(0.7563,0.6321),(0.7482,0.6301),(0.7909,0.6367),(0.8254,0.6409),(0.849,0.6403),(0.5877,0.7295),(0.5783,0.6847),(0.6124,0.6536),(0.6775,0.6816),(0.6828,0.6571),(0.7486,0.6682),(0.8455,0.7399),(0.5926,0.7439),(0.587,0.7167),(0.9344,0.668),(0.9314,0.7002),(0.9469,0.6788),(0.934,0.7474),(0.6007,0.7207),(0.6604,0.7523),(0.6072,0.7396),(0.6548,0.7295),(0.6773,0.7408),(0.6762,0.7191),(0.6856,0.7101),(0.6085,0.702),(0.6291,0.6824),(0.6556,0.6992),(0.6583,0.6785),(0.6747,0.6943),(0.6855,0.683),(0.697,0.6979),(0.9026,0.7003),(0.9036,0.7173),(0.9021,0.6934),(0.2451,0.5731),(0.4293,0.7821),(0.4225,0.7765),(0.4384,0.778),(0.4029,0.7448),(0.3927,0.769),(0.3796,0.7282),(0.4393,0.7324),(0.4636,0.7422),(0.3712,0.7302),(0.4656,0.7817),(0.3887,0.7856),(0.3735,0.7608),(0.4397,0.795),(0.4121,0.6221),(0.379,0.6153),(0.436,0.7234),(0.3921,0.6306),(0.4214,0.6366),(0.4371,0.6324),(0.4316,0.5878),(0.4019,0.5859),(0.4389,0.6127),(0.3644,0.5404),(0.3711,0.438),(0.363,0.4443),(0.3752,0.5355),(0.3969,0.5325),(0.3896,0.4348),(0.4186,0.5324),(0.4231,0.5451),(0.4257,0.5881),(0.4355,0.588),(0.4025,0.5345),(0.3814,0.4347),(0.3647,0.4436),(0.3797,0.5379),(0.4049,0.5869),(0.3848,0.5924),(0.4316,0.2796),(0.4516,0.2642),(0.4269,0.2746),(0.4344,0.2955),(0.4297,0.2979),(0.4434,0.3162),(0.4711,0.3068),(0.4727,0.266),(0.4573,0.3127),(0.4241,0.2321),(0.4256,0.2498),(0.4306,0.2511),(0.4234,0.2217),(0.4289,0.2248),(0.432,0.2269),(0.4292,0.2191),(0.4283,0.2337),(0.4319,0.2128),(0.4378,0.2182),(0.4426,0.2251),(0.439,0.2288),(0.4394,0.213),(0.4422,0.2172),(0.4476,0.2222),(0.4519,0.226),(0.4489,0.2303),(0.4487,0.2172),(0.456,0.245),(0.4525,0.2478),(0.4632,0.2489),(0.4557,0.2373),(0.4544,0.2291),(0.4589,0.2312),(0.4629,0.2365),(0.4611,0.2393),(0.4595,0.2288),(0.4673,0.2512),(0.4271,0.2805),(0.4498,0.3153),(0.4307,0.2686),(0.4445,0.2685),(0.4626,0.3106),(0.4623,0.267),(0.4267,0.2318),(0.4259,0.2252),(0.4275,0.2412),(0.4291,0.2506),(0.4348,0.2452),(0.4383,0.2364),(0.4399,0.2448),(0.4368,0.2263),(0.4356,0.2208),(0.4458,0.244),(0.4492,0.2389),(0.4505,0.2462),(0.4466,0.2233),(0.447,0.2286),(0.4593,0.2374),(0.4582,0.2331),(0.461,0.2452),(0.4627,0.2528),(0.4165,0.2663),(0.4089,0.263),(0.4071,0.2662),(0.4183,0.277),(0.4042,0.269),(0.4119,0.2763),(0.42,0.2841),(0.4136,0.2705),(0.4103,0.2672),(0.4049,0.2655),(0.6019,0.3848),(0.6068,0.3869),(0.6253,0.3793),(0.6538,0.3793),(0.6624,0.3827),(0.7562,0.3959),(0.7617,0.396),(0.7792,0.3957),(0.8088,0.396),(0.8189,0.3966),(0.61,0.3127),(0.6162,0.3117),(0.6269,0.3092),(0.6475,0.3095),(0.6559,0.3109),(0.7563,0.3259),(0.7642,0.3254),(0.7765,0.3268),(0.7967,0.3256),(0.8042,0.3254),(0.6188,0.2739),(0.622,0.2718),(0.6287,0.2718),(0.6382,0.2716),(0.6467,0.2716),(0.7651,0.2755),(0.7709,0.2712),(0.7764,0.2723),(0.7853,0.2759),(0.7917,0.2808),(0.9533,0.4685),(0.947,0.4641),(0.9521,0.4436),(0.9559,0.4595),(0.9387,0.4644),(0.9322,0.462),(0.939,0.4447),(0.934,0.5157),(0.9318,0.535),(0.9337,0.5447),(0.9307,0.539),(0.9447,0.5367),(0.9455,0.5461),(0.9579,0.5345),(0.9558,0.5448),(0.9576,0.515),(0.9629,0.538),(0.9583,0.4758),(0.9608,0.4521),(0.9629,0.4894),(0.9458,0.4391),(0.9336,0.4522),(0.9311,0.4772),(0.9306,0.4881),(0.9479,0.5237),(0.9334,0.5207),(0.9449,0.564),(0.9491,0.5643),(0.9392,0.557),(0.9535,0.5582),(0.878,0.5146),(0.8857,0.497),(0.8954,0.4943),(0.9045,0.5131),(0.8837,0.448),(0.8777,0.451),(0.883,0.4333),(0.8928,0.4437),(0.8908,0.4807),(0.8819,0.4793),(0.9462,0.4957),(0.9414,0.5155),(0.8938,0.4267),(0.9542,0.515),(0.9093,0.4608),(0.9044,0.4832),(0.9036,0.4457),(0.9059,0.4345),(0.09562,0.6679),(0.1058,0.6699),(0.4529,0.7907),(0.2246,0.3566),(0.3073,0.3671),(0.07699,0.6575),(0.2122,0.6544),(0.1242,0.7349),(0.1317,0.7413),(0.14,0.7441),(0.1595,0.7363),(0.1502,0.739),(0.1612,0.7603),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.05235,0.6182),(0.03497,0.5863),(0.05009,0.575),(0.04345,0.6114),(0.05434,0.5749),(0.7548,0.5023),(0.7845,0.5003),(0.8276,0.5046),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.9296,0.6745),(0.9314,0.7086),(0.9309,0.6716),(0.9316,0.7092),(0.9341,0.7413),(0.05749,0.4563),(0.0593,0.4306),(0.06375,0.4546),(0.06166,0.4149),(0.1207,0.4923),(0.07767,0.3992),(0.1188,0.3911),(0.07163,0.4921),(0.3246,0.198),(0.3195,0.2147),(0.3054,0.1997),(0.2701,0.2251),(0.2689,0.1984),(0.2975,0.2228),(0.2102,0.4535),(0.1961,0.4534),(0.2048,0.4296),(0.1903,0.4146),(0.166,0.3994),(0.1714,0.4906),(0.2233,0.1988),(0.2362,0.2011),(0.2275,0.2165),(0.2394,0.2239),(0.8129,0.7538),(0.8027,0.7967),(0.7702,0.7394),(0.7816,0.7924),(0.7367,0.7894),(0.7362,0.7374),(0.83,0.7792),(0.6366,0.7985),(0.615,0.7993),(0.61,0.7851),(0.6794,0.7847),(0.6795,0.7991),(0.6396,0.785),(0.6199,0.7908),(0.6091,0.7773),(0.2321,0.5721),(0.2268,0.5802),(0.2154,0.6149),(0.2391,0.603),(0.1375,0.5801),(0.188,0.5721),(0.1747,0.5997),(0.1621,0.552),(0.1318,0.6),(0.7536,0.5057),(0.7828,0.4538),(0.8276,0.5046),(0.5999,0.4924),(0.5843,0.6207),(0.5821,0.631),(0.6137,0.5991),(0.6553,0.5964),(0.6803,0.616),(0.7563,0.6321),(0.7482,0.6301),(0.7909,0.6367),(0.8254,0.6409),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.02977,0.5601),(0.1159,0.6002),(0.05235,0.6182),(0.03709,0.5628),(0.04677,0.5319),(0.07261,0.5357),(0.07568,0.5156),(0.03577,0.529),(0.04282,0.5102),(0.4293,0.7821),(0.4225,0.7765),(0.4384,0.778),(0.4029,0.7448),(0.3927,0.769),(0.3796,0.7282),(0.4393,0.7324),(0.4636,0.7422),(0.3712,0.7302),(0.4656,0.7817),(0.3887,0.7856),(0.3735,0.7608),(0.4397,0.795),(0.4121,0.6221),(0.379,0.6153),(0.436,0.7234),(0.3921,0.6306),(0.4214,0.6366),(0.4371,0.6324),(0.4316,0.5878),(0.4019,0.5859),(0.4389,0.6127),(0.3644,0.5404),(0.3711,0.438),(0.363,0.4443),(0.3752,0.5355),(0.3969,0.5325),(0.3896,0.4348),(0.4186,0.5324),(0.4231,0.5451),(0.4257,0.5881),(0.4355,0.588),(0.4025,0.5345),(0.3814,0.4347),(0.3647,0.4436),(0.3797,0.5379),(0.4049,0.5869),(0.3848,0.5924),(0.4316,0.2796),(0.4516,0.2642),(0.4269,0.2746),(0.4344,0.2955),(0.4297,0.2979),(0.4434,0.3162),(0.4711,0.3068),(0.4727,0.266),(0.4573,0.3127),(0.4241,0.2321),(0.4256,0.2498),(0.4306,0.2511),(0.4234,0.2217),(0.4289,0.2248),(0.432,0.2269),(0.4292,0.2191),(0.4283,0.2337),(0.4319,0.2128),(0.4378,0.2182),(0.4426,0.2251),(0.439,0.2288),(0.4394,0.213),(0.4422,0.2172),(0.4476,0.2222),(0.4519,0.226),(0.4489,0.2303),(0.4487,0.2172),(0.456,0.245),(0.4525,0.2478),(0.4632,0.2489),(0.4557,0.2373),(0.4544,0.2291),(0.4589,0.2312),(0.4629,0.2365),(0.4611,0.2393),(0.4595,0.2288),(0.4673,0.2512),(0.4271,0.2805),(0.4498,0.3153),(0.4307,0.2686),(0.4445,0.2685),(0.4626,0.3106),(0.4623,0.267),(0.4267,0.2318),(0.4259,0.2252),(0.4275,0.2412),(0.4291,0.2506),(0.4348,0.2452),(0.4383,0.2364),(0.4399,0.2448),(0.4368,0.2263),(0.4356,0.2208),(0.4458,0.244),(0.4492,0.2389),(0.4505,0.2462),(0.4466,0.2233),(0.447,0.2286),(0.4593,0.2374),(0.4582,0.2331),(0.461,0.2452),(0.4627,0.2528),(0.4165,0.2663),(0.4089,0.263),(0.4071,0.2662),(0.4183,0.277),(0.4042,0.269),(0.4119,0.2763),(0.42,0.2841),(0.4136,0.2705),(0.4103,0.2672),(0.4049,0.2655),(0.4549,0.7938),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.02977,0.5601),(0.1159,0.6002),(0.05235,0.6182),(0.03709,0.5628),(0.04677,0.5319),(0.07261,0.5357),(0.07568,0.5156),(0.03577,0.529),(0.04282,0.5102),(0.4293,0.7821),(0.4225,0.7765),(0.4384,0.778),(0.4029,0.7448),(0.3927,0.769),(0.3796,0.7282),(0.4393,0.7324),(0.4636,0.7422),(0.3712,0.7302),(0.4656,0.7817),(0.3887,0.7856),(0.3735,0.7608),(0.4397,0.795),(0.4121,0.6221),(0.379,0.6153),(0.436,0.7234),(0.3921,0.6306),(0.4214,0.6366),(0.4371,0.6324),(0.4316,0.5878),(0.4019,0.5859),(0.4389,0.6127),(0.3644,0.5404),(0.3711,0.438),(0.363,0.4443),(0.3752,0.5355),(0.3969,0.5325),(0.3896,0.4348),(0.4186,0.5324),(0.4231,0.5451),(0.4257,0.5881),(0.4355,0.588),(0.4025,0.5345),(0.3814,0.4347),(0.3647,0.4436),(0.3797,0.5379),(0.4049,0.5869),(0.3848,0.5924),(0.4316,0.2796),(0.4516,0.2642),(0.4269,0.2746),(0.4344,0.2955),(0.4297,0.2979),(0.4434,0.3162),(0.4711,0.3068),(0.4727,0.266),(0.4573,0.3127),(0.4241,0.2321),(0.4256,0.2498),(0.4306,0.2511),(0.4234,0.2217),(0.4289,0.2248),(0.432,0.2269),(0.4292,0.2191),(0.4283,0.2337),(0.4319,0.2128),(0.4378,0.2182),(0.4426,0.2251),(0.439,0.2288),(0.4394,0.213),(0.4422,0.2172),(0.4476,0.2222),(0.4519,0.226),(0.4489,0.2303),(0.4487,0.2172),(0.456,0.245),(0.4525,0.2478),(0.4632,0.2489),(0.4557,0.2373),(0.4544,0.2291),(0.4589,0.2312),(0.4629,0.2365),(0.4611,0.2393),(0.4595,0.2288),(0.4673,0.2512),(0.4271,0.2805),(0.4498,0.3153),(0.4307,0.2686),(0.4445,0.2685),(0.4626,0.3106),(0.4623,0.267),(0.4267,0.2318),(0.4259,0.2252),(0.4275,0.2412),(0.4291,0.2506),(0.4348,0.2452),(0.4383,0.2364),(0.4399,0.2448),(0.4368,0.2263),(0.4356,0.2208),(0.4458,0.244),(0.4492,0.2389),(0.4505,0.2462),(0.4466,0.2233),(0.447,0.2286),(0.4593,0.2374),(0.4582,0.2331),(0.461,0.2452),(0.4627,0.2528),(0.4165,0.2663),(0.4089,0.263),(0.4071,0.2662),(0.4183,0.277),(0.4042,0.269),(0.4119,0.2763),(0.42,0.2841),(0.4136,0.2705),(0.4103,0.2672),(0.4049,0.2655),(0.4549,0.7938),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.9296,0.6745),(0.9314,0.7086),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.6137,0.5991),(0.6553,0.5964),(0.6803,0.616),(0.7563,0.6321),(0.7482,0.6301),(0.7909,0.6367),(0.8254,0.6409),(0.849,0.6403),(0.5877,0.7295),(0.5783,0.6847),(0.6124,0.6536),(0.6775,0.6816),(0.6828,0.6571),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.9296,0.6745),(0.9314,0.7086),(0.9316,0.7092),(0.9341,0.7413),(0.8129,0.7538),(0.8027,0.7967),(0.7702,0.7394),(0.7816,0.7924),(0.7367,0.7894),(0.7362,0.7374),(0.83,0.7792),(0.6366,0.7985),(0.615,0.7993),(0.61,0.7851),(0.6794,0.7847),(0.6795,0.7991),(0.6396,0.785),(0.6199,0.7908),(0.6091,0.7773),(0.05123,0.5741),(0.0756,0.5956),(0.1159,0.6002),(0.05235,0.6182),(0.03709,0.5628),(0.04677,0.5319),(0.748,0.6836),(0.7365,0.6933),(0.6033,0.446),(0.6204,0.4418),(0.6053,0.4914),(0.6231,0.4906),(0.655,0.4905),(0.6504,0.4421),(0.6635,0.4436),(0.6642,0.4912),(0.7566,0.4558),(0.7548,0.5023),(0.7536,0.5057),(0.7828,0.4538),(0.7845,0.5003),(0.8138,0.5014),(0.8158,0.4578),(0.8276,0.5046),(0.5999,0.4924),(0.5934,0.5364),(0.6703,0.5365),(0.7632,0.5535),(0.7526,0.5493),(0.7899,0.5545),(0.8126,0.5527),(0.8327,0.5481),(0.5843,0.6207),(0.5821,0.631),(0.6137,0.5991),(0.6553,0.5964),(0.6803,0.616),(0.7563,0.6321),(0.7482,0.6301),(0.7909,0.6367),(0.8254,0.6409),(0.849,0.6403),(0.5877,0.7295),(0.5783,0.6847),(0.6124,0.6536),(0.6775,0.6816),(0.6828,0.6571),(0.7486,0.6682),(0.8455,0.7399),(0.5926,0.7439),(0.587,0.7167),(0.9344,0.668),(0.9314,0.7002),(0.9469,0.6788),(0.934,0.7474),(0.6007,0.7207),(0.6604,0.7523),(0.6072,0.7396),(0.6548,0.7295),(0.6773,0.7408),(0.6762,0.7191),(0.6856,0.7101),(0.6085,0.702),(0.6291,0.6824),(0.6556,0.6992),(0.6583,0.6785),(0.6747,0.6943),(0.6855,0.683),(0.697,0.6979),(0.9026,0.7003),(0.9036,0.7173),(0.9021,0.6934),(0.6019,0.3848),(0.6068,0.3869),(0.6253,0.3793),(0.6538,0.3793),(0.6624,0.3827),(0.7562,0.3959),(0.7617,0.396),(0.7792,0.3957),(0.8088,0.396),(0.8189,0.3966),(0.61,0.3127),(0.6162,0.3117),(0.6269,0.3092),(0.6475,0.3095),(0.6559,0.3109),(0.7563,0.3259),(0.7642,0.3254),(0.7765,0.3268),(0.7967,0.3256),(0.8042,0.3254),(0.6188,0.2739),(0.622,0.2718),(0.6287,0.2718),(0.6382,0.2716),(0.6467,0.2716),(0.7651,0.2755),(0.7709,0.2712),(0.7764,0.2723),(0.7853,0.2759),(0.7917,0.2808),(0.9533,0.4685),(0.947,0.4641),(0.9521,0.4436),(0.9559,0.4595),(0.9387,0.4644),(0.9322,0.462),(0.939,0.4447),(0.934,0.5157),(0.9318,0.535),(0.9337,0.5447),(0.9307,0.539),(0.9447,0.5367),(0.9455,0.5461),(0.9579,0.5345),(0.9558,0.5448),(0.9576,0.515),(0.9629,0.538),(0.9583,0.4758),(0.9608,0.4521),(0.9629,0.4894),(0.9458,0.4391),(0.9336,0.4522),(0.9311,0.4772),(0.9306,0.4881),(0.9479,0.5237),(0.9334,0.5207),(0.9449,0.564),(0.9491,0.5643),(0.9392,0.557),(0.9535,0.5582),(0.878,0.5146),(0.8857,0.497),(0.8954,0.4943),(0.9045,0.5131),(0.8837,0.448),(0.8777,0.451),(0.883,0.4333),(0.8928,0.4437),(0.8908,0.4807),(0.8819,0.4793),(0.9462,0.4957),(0.9414,0.5155),(0.8938,0.4267),(0.9542,0.515),(0.9093,0.4608),(0.9044,0.4832),(0.9036,0.4457),(0.9059,0.4345),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.9296,0.6745),(0.9314,0.7086),(0.9316,0.7092),(0.9341,0.7413),(0.8129,0.7538),(0.8027,0.7967),(0.7702,0.7394),(0.7816,0.7924),(0.7367,0.7894),(0.7362,0.7374),(0.83,0.7792),(0.6366,0.7985),(0.615,0.7993),(0.61,0.7851),(0.6794,0.7847),(0.6795,0.7991),(0.6396,0.785),(0.6199,0.7908),(0.6091,0.7773),(0.05123,0.5741),(0.0756,0.5956),(0.1159,0.6002),(0.05235,0.6182),(0.03709,0.5628),(0.04677,0.5319),(0.748,0.6836),(0.7365,0.6933),(0.6033,0.446),(0.6204,0.4418),(0.6053,0.4914),(0.6231,0.4906),(0.655,0.4905),(0.6504,0.4421),(0.6635,0.4436),(0.6642,0.4912),(0.7566,0.4558),(0.7548,0.5023),(0.7536,0.5057),(0.7828,0.4538),(0.7845,0.5003),(0.8138,0.5014),(0.8158,0.4578),(0.8276,0.5046),(0.5999,0.4924),(0.5934,0.5364),(0.6703,0.5365),(0.7632,0.5535),(0.7526,0.5493),(0.7899,0.5545),(0.8126,0.5527),(0.8327,0.5481),(0.5843,0.6207),(0.5821,0.631),(0.6137,0.5991),(0.6553,0.5964),(0.6803,0.616),(0.7563,0.6321),(0.7482,0.6301),(0.7909,0.6367),(0.8254,0.6409),(0.849,0.6403),(0.5877,0.7295),(0.5783,0.6847),(0.6124,0.6536),(0.6775,0.6816),(0.6828,0.6571),(0.7486,0.6682),(0.8455,0.7399),(0.5926,0.7439),(0.587,0.7167),(0.9344,0.668),(0.9314,0.7002),(0.9469,0.6788),(0.934,0.7474),(0.6007,0.7207),(0.6604,0.7523),(0.6072,0.7396),(0.6548,0.7295),(0.6773,0.7408),(0.6762,0.7191),(0.6856,0.7101),(0.6085,0.702),(0.6291,0.6824),(0.6556,0.6992),(0.6583,0.6785),(0.6747,0.6943),(0.6855,0.683),(0.697,0.6979),(0.9026,0.7003),(0.9036,0.7173),(0.9021,0.6934),(0.6019,0.3848),(0.6068,0.3869),(0.6253,0.3793),(0.6538,0.3793),(0.6624,0.3827),(0.7562,0.3959),(0.7617,0.396),(0.7792,0.3957),(0.8088,0.396),(0.8189,0.3966),(0.61,0.3127),(0.6162,0.3117),(0.6269,0.3092),(0.6475,0.3095),(0.6559,0.3109),(0.7563,0.3259),(0.7642,0.3254),(0.7765,0.3268),(0.7967,0.3256),(0.8042,0.3254),(0.6188,0.2739),(0.622,0.2718),(0.6287,0.2718),(0.6382,0.2716),(0.6467,0.2716),(0.7651,0.2755),(0.7709,0.2712),(0.7764,0.2723),(0.7853,0.2759),(0.7917,0.2808),(0.9533,0.4685),(0.947,0.4641),(0.9521,0.4436),(0.9559,0.4595),(0.9387,0.4644),(0.9322,0.462),(0.939,0.4447),(0.934,0.5157),(0.9318,0.535),(0.9337,0.5447),(0.9307,0.539),(0.9447,0.5367),(0.9455,0.5461),(0.9579,0.5345),(0.9558,0.5448),(0.9576,0.515),(0.9629,0.538),(0.9583,0.4758),(0.9608,0.4521),(0.9629,0.4894),(0.9458,0.4391),(0.9336,0.4522),(0.9311,0.4772),(0.9306,0.4881),(0.9479,0.5237),(0.9334,0.5207),(0.9449,0.564),(0.9491,0.5643),(0.9392,0.557),(0.9535,0.5582),(0.878,0.5146),(0.8857,0.497),(0.8954,0.4943),(0.9045,0.5131),(0.8837,0.448),(0.8777,0.451),(0.883,0.4333),(0.8928,0.4437),(0.8908,0.4807),(0.8819,0.4793),(0.9462,0.4957),(0.9414,0.5155),(0.8938,0.4267),(0.9542,0.515),(0.9093,0.4608),(0.9044,0.4832),(0.9036,0.4457),(0.9059,0.4345),(0.7643,0.6341),(0.742,0.5452),(0.757,0.4686),(0.7493,0.7107),(0.7115,0.6061),(0.9203,0.6057),(0.3188,0.8471),(0.5892,0.2322),(0.7608,0.6101),(0.8616,0.6461),(0.9045,0.6504),(0.5033,0.7486),(0.4644,0.8045),(0.3678,0.8368),(0.7105,0.5041),(0.7115,0.4157),(0.7117,0.3652),(0.2823,0.5568),(0.3072,0.6266),(0.1452,0.6886),(0.1574,0.7609),(0.2553,0.8396),(0.2388,0.5121),(0.3045,0.5111),(0.7044,0.2298),(0.3601,0.6655),(0.3108,0.7723),(0.3156,0.8102),(0.6403,0.3063),(0.855,0.4262),(0.8886,0.5294),(0.4905,0.7493),(0.4246,0.7163),(0.3728,0.7946),(0.7424,0.5043),(0.7682,0.3905),(0.8538,0.5137),(0.1807,0.7166),(0.2196,0.7746),(0.2678,0.7302),(0.3057,0.5124),(0.9285,0.537),(0.7053,0.3068),(0.4157,0.8238),(0.7114,0.6716),(0.7114,0.5836),(0.7113,0.57),(0.7109,0.5391),(0.7415,0.5365),(0.7352,0.5607),(0.7106,0.5245),(0.7114,0.4937),(0.7116,0.4863),(0.7112,0.4646),(0.748,0.4876),(0.7587,0.4623),(0.7486,0.5534),(0.7702,0.5064),(0.7966,0.4474),(0.8166,0.4224),(0.581,0.2608),(0.7116,0.4412),(0.7119,0.4066),(0.7118,0.3818),(0.5649,0.2347),(0.6549,0.2302),(0.7581,0.4216),(0.7112,0.4556),(0.7114,0.4281),(0.7616,0.4422),(0.7327,0.4684),(0.8021,0.5088),(0.7506,0.5203),(0.731,0.5215),(0.7589,0.4274),(0.8247,0.6334),(0.7522,0.5927),(0.8839,0.5857),(0.8148,0.6622),(0.7979,0.582),(0.7331,0.5818),(0.8471,0.6014),(0.8761,0.6241),(0.7881,0.6158),(0.7937,0.6316),(0.4532,0.7373),(0.4465,0.7799),(0.836,0.4691),(0.7422,0.23),(0.7113,0.6352),(0.7804,0.3806),(0.7326,0.5974),(0.7481,0.6196),(0.7689,0.6444),(0.8449,0.5879),(0.7971,0.5484),(0.8571,0.5587),(0.7707,0.4834),(0.1511,0.587),(0.1696,0.6105),(0.1975,0.814),(0.1997,0.5284),(0.1802,0.5409),(0.1593,0.5518),(0.1474,0.5219),(0.1288,0.5012),(0.1018,0.4655),(0.07201,0.4159),(0.02679,0.3441),(0.05829,0.2186),(0.09219,0.1816),(0.1579,0.1795),(0.1803,0.238),(0.2153,0.3139),(0.2279,0.4148),(0.214,0.4605),(0.2176,0.4777),(0.2285,0.4941),(0.08988,0.3155),(0.1442,0.3629),(0.1972,0.5113),(0.1475,0.2981),(0.1254,0.233),(0.148,0.4101),(0.1465,0.4589),(0.174,0.4945),(0.09557,0.2585),(0.1499,0.4957),(0.1652,0.51),(0.178,0.5238),(0.5109,0.1797),(0.5065,0.1739),(0.4986,0.1703),(0.4931,0.171),(0.4851,0.1719),(0.4798,0.1784),(0.4782,0.1864),(0.5159,0.2007),(0.5077,0.1955),(0.4997,0.1963),(0.495,0.2102),(0.489,0.202),(0.4791,0.198),(0.5299,0.2001),(0.5227,0.2015),(0.5162,0.2231),(0.489,0.2186),(0.4868,0.2069),(0.5367,0.2169),(0.5176,0.2323),(0.5003,0.2388),(0.4898,0.2365),(0.5371,0.2332),(0.5297,0.2341),(0.5176,0.2469),(0.505,0.2559),(0.4989,0.2522),(0.5332,0.2475),(0.5057,0.2626),(0.4954,0.2614),(0.4907,0.2553),(0.4843,0.2549),(0.5261,0.2641),(0.5215,0.2704),(0.5136,0.272),(0.5052,0.2743),(0.4947,0.2717),(0.4862,0.2639),(0.5113,0.1788),(0.5069,0.173),(0.499,0.1694),(0.4855,0.1711),(0.4813,0.177),(0.5164,0.1998),(0.5081,0.1946),(0.5001,0.1955),(0.5303,0.1992),(0.5258,0.2161),(0.518,0.2315),(0.5371,0.216),(0.5375,0.2324),(0.5301,0.2332),(0.518,0.2461),(0.5054,0.2551),(0.5337,0.2467),(0.5164,0.2576),(0.5061,0.2618),(0.4958,0.2605),(0.5266,0.2632),(0.5219,0.2696),(0.514,0.2711),(0.5056,0.2734),(0.4952,0.2709),(0.4866,0.263),(0.5177,0.6098),(0.6649,0.6045),(0.569,0.6744),(0.5305,0.6554),(0.2845,0.5569),(0.3085,0.6276),(0.3617,0.6663),(0.3059,0.7563),(0.3128,0.7974),(0.634,0.1634),(0.5562,0.4303),(0.551,0.53),(0.4822,0.7453),(0.4224,0.7131),(0.3696,0.7805),(0.6794,0.5044),(0.6566,0.3908),(0.5768,0.5143),(0.1807,0.7158),(0.2205,0.7754),(0.262,0.7111),(0.3054,0.5118),(0.5149,0.5288),(0.7042,0.1559),(0.6816,0.5366),(0.6882,0.5608),(0.6758,0.4878),(0.6647,0.4624),(0.6655,0.5582),(0.6521,0.5043),(0.6284,0.4478),(0.6143,0.4101),(0.5797,0.2022),(0.6661,0.4218),(0.662,0.4424),(0.6902,0.4685),(0.612,0.5096),(0.6732,0.5199),(0.6906,0.5216),(0.6648,0.4275),(0.6006,0.6387),(0.6699,0.5917),(0.5465,0.5863),(0.6097,0.6626),(0.6232,0.5834),(0.6905,0.5819),(0.5874,0.6082),(0.557,0.6118),(0.6363,0.6201),(0.6272,0.633),(0.4554,0.7347),(0.4434,0.7663),(0.5927,0.4713),(0.6481,0.3724),(0.691,0.5975),(0.67,0.6224),(0.654,0.6446),(0.5782,0.5894),(0.627,0.5519),(0.5845,0.5609),(0.6527,0.4895),(0.1692,0.6095),(0.1989,0.5257),(0.1794,0.5383),(0.09398,0.3588),(0.1362,0.4032),(0.1964,0.5087),(0.161,0.3162),(0.1281,0.2293),(0.1459,0.4498),(0.1732,0.4907),(0.08025,0.278),(0.1492,0.4933),(0.1644,0.5076),(0.1772,0.5214),(0.4166,0.1802),(0.4206,0.1745),(0.4283,0.1709),(0.4338,0.1716),(0.4418,0.1726),(0.4461,0.1785),(0.4494,0.1874),(0.4124,0.201),(0.4204,0.1959),(0.4283,0.1968),(0.432,0.2108),(0.4376,0.2026),(0.4482,0.1984),(0.3985,0.2004),(0.4058,0.2019),(0.4115,0.2236),(0.4388,0.2186),(0.4417,0.2076),(0.3925,0.2171),(0.4105,0.2328),(0.428,0.2392),(0.3929,0.2334),(0.4002,0.2342),(0.4128,0.247),(0.424,0.2562),(0.4299,0.2525),(0.3973,0.2475),(0.4248,0.2627),(0.4348,0.2615),(0.4396,0.2555),(0.4489,0.256),(0.4051,0.264),(0.41,0.2703),(0.4179,0.2719),(0.4264,0.2742),(0.4366,0.2717),(0.4447,0.2639),(0.416,0.1778),(0.4213,0.1734),(0.4291,0.1699),(0.4425,0.1715),(0.4468,0.1774),(0.4501,0.1864),(0.4131,0.2),(0.4211,0.1949),(0.429,0.1957),(0.3993,0.1994),(0.4045,0.2162),(0.3932,0.2161),(0.4009,0.2332),(0.3936,0.2323),(0.4136,0.2459),(0.4248,0.2552),(0.398,0.2465),(0.4157,0.2574),(0.4255,0.2616),(0.4356,0.2604),(0.4407,0.254),(0.4058,0.2629),(0.4107,0.2693),(0.4186,0.2708),(0.4271,0.2731),(0.4373,0.2706),(0.4455,0.2628),(0.8673,0.4753),(0.5559,0.4701),(0.4896,0.2468),(0.441,0.2417),(0.7161,0.7588),(0.9698,0.5545),(0.9555,0.6365),(0.9299,0.7021),(0.8135,0.3782),(0.7696,0.7689),(0.88,0.7396),(0.9587,0.4934),(0.876,0.416),(0.7507,0.349),(0.7119,0.3507),(0.8256,0.7594),(0.4623,0.5555),(0.4752,0.6494),(0.5031,0.6976),(0.6095,0.3784),(0.6417,0.7671),(0.5467,0.7301),(0.4728,0.4963),(0.548,0.4079),(0.6693,0.3498),(0.5962,0.7535),(0.8035,0.2322),(0.7992,0.2901),(0.8026,0.1751),(0.4252,0.6776),(0.3897,0.6813),(0.3916,0.6763),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5),(0.5,0.5)]),
              coord=Coordinate(DEF='Body-COORD',point=[(-96.11,-43.92,32.81),(-87.26,-38.55,30.81),(-86.66,-46.07,33.16),(-96.73,-40.9,32.45),(-96.53,-43.38,38.03),(-94.57,-42.12,41.45),(-91.49,-42.34,41.0),(-92.28,-40.42,41.53),(-87.38,-45.46,39.64),(-89.51,-39.47,39.46),(-88.18,-38.74,36.43),(-94.66,-40.96,38.74),(-87.36,-46.46,26.83),(-96.53,-44.22,27.24),(-94.53,-43.48,24.0),(-91.5,-43.73,24.02),(-92.84,-41.89,22.62),(-89.97,-40.7,23.41),(-88.47,-39.62,25.9),(-95.05,-42.04,25.84),(-91.47,-53.88,25.21),(-99.21,-52.67,23.71),(-94.29,-52.0,23.51),(-96.53,-51.41,22.7),(-98.88,-56.66,27.83),(-97.73,-59.05,36.77),(-97.79,-47.47,33.93),(-99.15,-52.37,35.15),(-86.99,-50.48,34.74),(-88.95,-53.28,34.26),(-84.64,-50.45,28.34),(-85.49,-51.89,32.19),(-85.92,-51.9,25.69),(-87.81,-53.35,28.35),(-85.7,-47.98,28.17),(-97.56,-61.41,37.54),(-98.01,-47.07,39.92),(-98.78,-55.5,41.54),(-96.59,-46.29,43.96),(-90.04,-48.95,45.9),(-90.85,-45.83,42.84),(-84.65,-49.54,40.05),(-85.93,-50.53,43.26),(-87.85,-52.46,41.09),(-85.49,-51.52,37.01),(-88.91,-53.12,36.28),(-91.45,-52.41,44.64),(-87.43,-49.55,45.27),(-86.64,-47.76,43.31),(-85.7,-47.12,39.08),(-88.51,-47.28,45.5),(-88.04,-46.24,43.8),(-86.3,-46.26,40.38),(-94.3,-50.01,46.15),(-96.39,-49.75,46.11),(-96.31,-57.86,40.53),(-98.39,-51.37,47.75),(-96.09,-56.87,40.59),(-95.68,-60.14,40.2),(-97.73,-54.78,48.33),(-97.66,-55.41,44.87),(-92.97,-56.52,36.24),(-93.39,-56.36,39.78),(-91.03,-54.84,37.84),(-91.69,-54.62,35.89),(-90.61,-55.1,34.07),(-94.8,-57.04,38.09),(-93.12,-58.96,36.68),(-94.97,-59.79,39.2),(-94.81,-57.41,34.58),(-94.82,-60.05,34.97),(-92.11,-56.26,32.6),(-86.28,-47.35,26.42),(-87.41,-51.27,23.15),(-86.24,-49.11,24.18),(-96.36,-58.36,32.21),(-95.55,-60.64,33.7),(-99.16,-56.43,23.91),(-97.99,-48.05,27.3),(-98.47,-56.4,29.97),(-96.52,-47.86,23.92),(-90.05,-50.82,22.13),(-90.83,-47.32,23.68),(-88.51,-49.15,21.77),(-88.01,-47.87,22.91),(-96.52,-51.47,22.16),(-84.82,-49.31,28.27),(-84.83,-48.43,39.59),(-84.95,-51.34,34.62),(-95.45,-57.41,31.3),(-96.39,-49.79,45.56),(-96.52,-51.44,22.14),(-92.77,-54.79,44.05),(-93.25,-56.13,27.25),(-98.83,-57.14,27.73),(-97.77,-55.91,45.17),(-97.35,-57.25,41.02),(-97.3,-57.78,30.88),(-97.0,-60.12,34.88),(-96.75,-61.15,34.05),(-97.52,-58.74,34.65),(-97.01,-59.97,38.87),(-96.58,-60.57,40.28),(-97.48,-58.49,38.5),(-97.5,-60.71,37.33),(-93.88,-53.77,50.47),(-95.36,-52.65,51.56),(-94.77,-50.28,51.41),(-91.74,-51.44,51.83),(-90.56,-50.53,48.35),(-91.78,-53.36,48.96),(-91.24,-41.83,44.48),(-87.83,-41.94,46.34),(-88.78,-42.69,49.67),(-90.9,-42.63,50.66),(-93.92,-45.58,49.21),(-89.4,-39.3,44.09),(-91.24,-38.82,45.82),(-92.44,-40.33,47.98),(-84.88,-38.04,44.5),(-86.44,-37.3,42.6),(-82.58,-30.37,40.41),(-81.25,-31.1,41.63),(-87.51,-36.52,44.09),(-83.38,-29.2,43.02),(-88.59,-35.68,47.19),(-89.65,-36.45,46.3),(-91.37,-38.53,47.42),(-89.95,-38.81,49.39),(-82.3,-29.61,44.39),(-86.96,-36.39,48.43),(-81.32,-30.34,43.92),(-85.61,-37.22,47.87),(-88.35,-39.21,49.67),(-87.34,-40.12,48.77),(-79.12,-28.85,40.17),(-78.48,-28.62,40.81),(-80.21,-27.17,41.78),(-79.83,-29.74,40.11),(-78.95,-30.24,40.94),(-82.03,-26.51,42.81),(-76.96,-26.13,40.29),(-78.07,-27.03,41.23),(-77.36,-27.1,41.52),(-76.79,-25.53,39.22),(-77.49,-25.66,39.11),(-77.64,-25.59,40.31),(-77.33,-25.3,39.2),(-77.55,-26.14,40.0),(-77.42,-24.84,39.08),(-78.09,-25.0,39.03),(-78.52,-25.17,40.3),(-78.34,-25.53,40.08),(-78.05,-24.62,39.28),(-78.42,-24.8,39.21),(-79.05,-24.95,39.19),(-79.36,-24.95,40.36),(-79.25,-25.32,40.12),(-79.03,-24.55,39.29),(-80.05,-25.86,41.8),(-79.89,-26.18,41.26),(-80.85,-25.93,41.37),(-79.95,-25.49,40.82),(-79.75,-25.12,39.77),(-80.24,-25.14,39.53),(-80.63,-25.18,40.81),(-80.52,-25.48,40.55),(-80.24,-24.82,39.68),(-81.3,-25.79,42.02),(-78.5,-28.88,41.88),(-78.28,-27.92,43.17),(-79.44,-27.47,43.55),(-81.01,-26.89,43.23),(-77.23,-25.99,40.86),(-77.07,-25.68,40.2),(-77.73,-26.93,42.51),(-77.44,-26.46,41.75),(-78.21,-26.5,41.69),(-78.52,-26.26,42.48),(-78.24,-25.85,41.83),(-77.97,-25.36,40.84),(-77.79,-25.11,40.27),(-79.13,-26.11,41.72),(-79.5,-26.04,42.45),(-79.25,-25.67,41.95),(-78.8,-24.93,40.45),(-78.92,-25.2,40.95),(-80.19,-25.34,41.35),(-80.03,-25.15,40.92),(-80.44,-25.7,42.14),(-80.72,-26.06,42.68),(-77.62,-28.54,38.56),(-76.75,-28.99,37.55),(-76.67,-28.7,37.99),(-78.01,-29.18,38.53),(-76.54,-29.22,38.04),(-77.33,-29.45,39.13),(-78.1,-29.68,40.0),(-77.35,-28.86,39.7),(-77.04,-28.79,39.22),(-76.45,-28.95,38.4),(-93.83,-52.96,51.59),(-96.18,-55.99,21.0),(-97.54,-55.07,20.42),(-96.96,-52.63,18.72),(-94.42,-54.01,17.78),(-92.52,-52.55,19.85),(-93.92,-55.5,21.91),(-93.76,-43.55,20.28),(-91.08,-43.72,16.69),(-92.64,-45.09,14.61),(-94.84,-45.32,14.91),(-96.62,-47.77,19.06),(-92.66,-40.87,18.54),(-94.88,-40.97,17.94),(-96.07,-42.81,17.29),(-89.15,-39.11,14.94),(-90.31,-38.29,17.28),(-88.73,-30.85,14.3),(-87.59,-31.56,12.69),(-91.89,-37.99,16.33),(-90.48,-30.36,12.06),(-93.9,-37.95,13.96),(-94.37,-38.65,15.67),(-95.49,-41.01,16.5),(-94.62,-41.44,14.02),(-89.71,-30.83,10.34),(-92.52,-38.61,12.13),(-88.47,-31.28,10.43),(-90.9,-39.07,12.11),(-93.14,-41.67,12.96),(-91.72,-42.22,13.49),(-86.12,-28.9,11.96),(-85.75,-28.68,10.95),(-88.01,-27.74,10.62),(-86.45,-29.86,12.67),(-85.69,-30.3,11.58),(-90.11,-27.58,10.5),(-85.08,-25.98,9.91),(-86.0,-27.17,9.923),(-85.41,-27.15,9.294),(-84.89,-25.23,10.63),(-85.45,-25.45,11.15),(-85.88,-25.59,10.12),(-85.45,-25.09,10.88),(-85.55,-26.05,10.51),(-85.65,-24.66,10.9),(-86.19,-24.92,11.36),(-86.81,-25.34,10.5),(-86.48,-25.61,10.7),(-86.33,-24.59,11.01),(-86.6,-24.81,11.33),(-87.11,-25.05,11.73),(-87.65,-25.28,10.84),(-87.38,-25.58,11.1),(-87.25,-24.69,11.52),(-88.3,-26.48,10.15),(-87.94,-26.68,10.66),(-88.91,-26.62,11.0),(-88.11,-25.96,10.9),(-87.82,-25.42,11.64),(-88.2,-25.49,12.13),(-88.83,-25.78,11.19),(-88.57,-26.0,11.45),(-88.34,-25.21,11.9),(-89.51,-26.66,10.62),(-85.93,-29.08,10.09),(-86.34,-28.33,8.517),(-87.62,-28.16,8.672),(-89.16,-27.83,9.671),(-85.5,-25.98,9.51),(-85.31,-25.56,9.933),(-86.02,-27.19,8.544),(-85.74,-26.6,8.944),(-86.4,-26.75,9.431),(-86.95,-26.69,8.821),(-86.68,-26.16,9.139),(-86.37,-25.51,9.752),(-86.17,-25.16,10.1),(-87.38,-26.54,9.799),(-87.89,-26.65,9.317),(-87.68,-26.19,9.537),(-87.18,-25.18,10.45),(-87.31,-25.53,10.13),(-88.5,-25.94,10.51),(-88.32,-25.67,10.76),(-88.79,-26.44,10.02),(-89.05,-26.91,9.781),(-84.5,-28.11,12.53),(-83.33,-28.24,13.1),(-83.46,-28.02,12.58),(-84.62,-28.78,12.95),(-83.18,-28.5,12.61),(-84.06,-29.01,12.11),(-84.88,-29.48,11.81),(-84.4,-28.54,11.44),(-84.04,-28.35,11.68),(-83.27,-28.28,12.15),(-95.74,-55.5,19.58),(-94.29,-52.0,23.48),(-96.53,-51.42,22.67),(-86.62,-34.24,29.76),(-89.12,-31.08,29.49),(-99.32,-35.71,31.71),(-95.91,-30.24,30.51),(-92.66,-29.87,30.31),(-98.46,-38.83,32.3),(-91.6,-39.06,20.35),(-94.57,-40.08,22.63),(-89.25,-36.88,21.75),(-87.9,-35.22,25.63),(-98.61,-39.37,26.92),(-89.78,-9.36,13.45),(-90.57,-13.85,15.25),(-93.55,-9.585,17.21),(-91.64,-13.74,18.16),(-90.58,-13.3,21.76),(-92.22,-9.09,20.49),(-88.79,-8.438,21.58),(-88.64,-13.76,13.49),(-88.65,-12.95,22.99),(-85.81,-12.68,22.01),(-85.99,-8.407,17.13),(-84.52,-12.88,17.97),(-85.79,-13.3,14.75),(-88.49,-17.78,13.83),(-88.48,-16.75,24.57),(-85.75,-17.87,22.92),(-84.31,-18.72,18.86),(-85.73,-18.53,16.35),(-89.91,-26.56,14.62),(-93.4,-25.24,16.12),(-94.42,-22.77,19.56),(-93.78,-22.13,24.48),(-89.84,-24.13,27.15),(-86.63,-25.35,25.31),(-85.36,-26.6,21.16),(-87.05,-27.03,17.38),(-92.57,-35.52,17.81),(-95.92,-31.13,16.57),(-96.04,-27.72,20.71),(-96.35,-29.57,29.63),(-94.14,-27.48,28.53),(-96.13,-37.33,19.54),(-96.25,-34.27,17.69),(-100.3,-34.7,21.95),(-99.46,-36.39,22.87),(-100.5,-36.99,30.11),(-101.0,-35.12,29.0),(-99.45,-33.87,31.32),(-97.96,-33.13,32.19),(-100.6,-32.89,22.65),(-99.44,-29.9,23.82),(-100.9,-32.25,28.51),(-97.44,-29.41,26.98),(-99.03,-31.51,30.76),(-96.42,-31.55,32.75),(-90.92,-3.699,11.62),(-92.87,-3.673,12.88),(-93.79,-3.579,16.24),(-92.9,-3.143,19.46),(-90.96,-2.965,20.64),(-88.96,-2.752,19.32),(-88.21,-2.964,16.36),(-89.02,-3.385,12.96),(-92.65,3.035,11.4),(-94.33,2.882,12.25),(-95.08,2.976,14.97),(-94.34,3.296,17.6),(-92.67,3.613,18.69),(-90.86,3.746,17.47),(-90.22,3.432,15.1),(-90.92,3.231,12.37),(-92.95,8.443,11.73),(-94.44,7.918,11.93),(-95.1,7.877,14.07),(-94.45,8.212,15.37),(-92.75,8.823,15.86),(-91.33,9.237,15.02),(-90.86,9.262,13.26),(-91.32,8.947,11.99),(-89.58,10.19,11.07),(-88.84,10.73,12.71),(-86.27,12.0,11.48),(-88.83,11.73,10.43),(-89.49,10.53,14.47),(-88.61,12.06,14.79),(-86.11,12.19,13.56),(-91.49,10.39,16.05),(-95.64,9.397,16.45),(-95.78,10.36,15.77),(-94.14,10.52,16.56),(-96.29,9.121,13.83),(-96.37,10.11,13.6),(-95.93,8.866,11.45),(-96.01,10.01,11.35),(-91.62,9.509,10.73),(-94.33,10.02,10.6),(-88.87,12.41,10.39),(-85.84,12.95,12.4),(-88.88,12.78,14.37),(-95.55,8.221,12.41),(-95.46,8.519,15.84),(-95.97,12.13,13.65),(-95.99,12.03,12.56),(-95.33,12.18,13.59),(-95.35,12.08,12.49),(-95.2,-29.88,29.08),(-91.91,-30.08,28.61),(-90.27,-37.38,42.06),(-93.44,-38.65,41.08),(-88.19,-35.53,39.19),(-87.36,-34.54,34.44),(-97.95,-38.54,37.7),(-88.82,-7.621,35.38),(-89.8,-12.25,35.34),(-92.98,-8.308,32.84),(-91.21,-12.57,32.8),(-90.6,-12.74,28.92),(-92.06,-8.403,29.18),(-88.83,-8.069,27.02),(-87.69,-11.95,36.49),(-88.85,-12.65,27.12),(-85.94,-12.31,27.23),(-85.54,-7.423,30.54),(-84.19,-11.91,30.84),(-85.05,-11.79,34.4),(-87.45,-15.82,37.94),(-88.76,-16.5,27.29),(-85.82,-17.35,28.67),(-83.89,-17.53,32.53),(-85.0,-16.95,35.19),(-88.5,-24.38,41.5),(-92.18,-23.33,40.36),(-93.71,-21.49,36.25),(-93.7,-21.64,31.14),(-90.01,-23.98,28.85),(-86.62,-25.09,30.25),(-84.78,-25.45,34.16),(-85.98,-25.27,38.37),(-91.27,-33.21,43.28),(-94.41,-29.08,43.21),(-96.69,-26.89,37.76),(-94.23,-27.43,29.87),(-94.68,-35.51,43.21),(-95.14,-32.5,43.52),(-99.11,-33.24,40.78),(-98.39,-35.03,40.45),(-100.2,-36.68,34.07),(-100.7,-34.7,34.45),(-98.11,-33.31,29.79),(-99.53,-31.59,39.4),(-99.66,-29.96,36.44),(-100.6,-31.86,33.64),(-98.07,-29.77,32.81),(-99.01,-31.48,31.05),(-96.7,-31.9,28.18),(-89.76,-1.852,34.74),(-91.84,-1.959,34.0),(-93.14,-2.371,31.0),(-92.65,-2.498,27.53),(-90.88,-2.586,25.86),(-88.75,-2.244,26.53),(-87.66,-2.002,29.26),(-88.05,-1.834,32.86),(-91.48,4.714,32.21),(-93.23,4.492,31.87),(-94.3,4.178,29.44),(-93.88,4.041,26.62),(-92.37,4.111,25.04),(-90.44,4.368,25.7),(-89.52,4.419,27.93),(-89.89,4.687,30.78),(-91.91,9.84,29.43),(-93.34,9.397,29.86),(-94.26,9.026,27.83),(-93.76,9.131,26.46),(-92.07,9.536,25.28),(-90.63,9.962,25.58),(-89.95,10.24,27.23),(-90.25,10.17,28.59),(-88.56,11.62,28.64),(-87.98,11.88,26.68),(-85.35,13.26,26.81),(-87.79,13.19,28.41),(-88.78,11.42,25.22),(-87.97,12.83,24.06),(-85.39,13.11,24.71),(-90.9,11.07,24.15),(-95.03,10.12,24.99),(-95.13,11.15,25.23),(-93.57,11.15,24.1),(-95.44,10.28,27.74),(-95.51,11.26,27.52),(-94.82,10.46,30.01),(-94.95,11.5,29.65),(-90.54,11.05,29.65),(-93.22,11.61,30.05),(-87.85,13.89,28.15),(-85.03,13.99,25.43),(-88.21,13.63,24.17),(-94.56,9.64,29.34),(-94.76,9.382,25.91),(-95.18,13.32,26.46),(-95.1,13.4,27.55),(-94.54,13.36,26.38),(-94.46,13.44,27.47),(-89.49,-64.65,37.0),(-93.81,-63.71,43.6),(-96.58,-69.74,39.13),(-90.8,-58.53,35.81),(-89.87,-64.62,38.26),(-90.74,-65.05,42.59),(-91.88,-64.29,43.09),(-90.13,-67.51,37.75),(-92.11,-69.09,38.36),(-95.07,-69.63,38.9),(-88.3,-62.31,36.3),(-88.96,-60.4,35.97),(-89.11,-59.26,35.74),(-97.04,-62.69,42.13),(-96.35,-64.68,43.62),(-101.8,-66.11,39.05),(-101.1,-67.94,39.37),(-98.21,-69.64,39.34),(-99.35,-61.74,37.73),(-96.86,-60.16,37.03),(-94.4,-59.5,36.53),(-94.24,-64.5,44.0),(-96.66,-68.12,43.71),(-96.62,-69.27,41.89),(-91.62,-59.27,39.74),(-92.19,-60.11,41.33),(-93.2,-62.13,43.06),(-91.09,-67.84,40.43),(-92.29,-65.79,43.25),(-94.78,-68.85,41.95),(-88.59,-62.31,37.18),(-89.95,-59.62,38.01),(-91.07,-62.01,41.71),(-100.7,-66.89,42.45),(-99.48,-68.52,42.83),(-97.96,-66.85,44.53),(-94.81,-62.43,42.74),(-93.66,-59.82,40.35),(-93.51,-69.48,38.64),(-89.56,-66.17,37.34),(-89.29,-64.15,36.86),(-89.17,-63.84,36.77),(-88.75,-63.14,36.56),(-89.5,-62.98,37.42),(-89.7,-63.54,37.4),(-88.29,-62.55,36.36),(-88.69,-62.09,36.31),(-89.06,-61.93,36.33),(-88.57,-61.46,36.15),(-89.36,-61.84,37.52),(-89.02,-61.24,37.92),(-90.02,-63.43,37.78),(-89.71,-62.16,38.05),(-90.07,-60.75,39.34),(-90.8,-60.15,40.02),(-89.85,-58.59,37.12),(-89.0,-60.94,36.1),(-89.37,-60.18,35.98),(-89.27,-59.63,35.84),(-89.41,-58.77,35.67),(-92.99,-58.9,36.2),(-89.64,-60.34,37.77),(-88.56,-61.27,36.11),(-88.79,-60.67,36.01),(-89.17,-60.8,37.94),(-88.79,-61.46,36.98),(-89.56,-62.14,39.8),(-89.16,-62.61,37.5),(-88.5,-62.73,36.97),(-89.25,-60.49,37.78),(-89.82,-65.07,41.13),(-90.27,-64.19,37.87),(-91.44,-63.59,42.74),(-89.71,-65.62,41.07),(-90.08,-63.92,39.21),(-89.83,-64.02,37.47),(-90.26,-64.35,41.41),(-90.6,-64.56,42.47),(-90.28,-64.7,39.12),(-89.49,-65.1,39.35),(-91.67,-67.03,42.35),(-92.44,-68.52,41.37),(-90.4,-61.22,40.59),(-95.36,-60.09,36.8),(-89.32,-65.34,37.13),(-90.09,-59.34,38.42),(-89.87,-64.38,37.54),(-89.29,-64.95,38.14),(-89.32,-65.42,38.67),(-90.93,-63.86,41.57),(-90.07,-63.09,38.97),(-90.86,-63.11,41.56),(-89.34,-61.7,38.24),(-101.8,-62.88,38.33),(-101.1,-64.0,42.09),(-99.9,-68.99,39.43),(-100.3,-61.83,38.69),(-100.9,-62.16,38.82),(-101.5,-61.99,38.08),(-101.8,-61.68,38.06),(-102.8,-61.22,38.1),(-103.6,-60.36,38.01),(-104.2,-58.6,37.7),(-105.9,-56.83,37.55),(-105.6,-55.9,37.3),(-104.8,-53.46,36.63),(-103.7,-52.48,36.23),(-101.6,-52.46,36.0),(-101.4,-54.16,36.31),(-99.81,-56.13,36.54),(-99.33,-58.88,37.08),(-100.6,-60.45,37.62),(-99.93,-60.67,37.57),(-99.63,-60.98,37.6),(-103.7,-55.97,38.12),(-102.0,-57.29,38.19),(-100.4,-61.37,38.55),(-101.9,-55.57,37.49),(-102.6,-53.79,37.2),(-101.9,-58.6,38.16),(-102.0,-59.95,38.29),(-101.1,-60.89,38.65),(-103.6,-54.47,37.42),(-101.9,-60.93,38.62),(-101.4,-61.32,38.65),(-101.0,-61.71,38.69),(-96.8,-62.6,43.14),(-96.67,-62.46,42.95),(-96.44,-62.4,42.73),(-96.29,-62.45,42.62),(-96.06,-62.53,42.46),(-95.92,-62.74,42.44),(-95.86,-62.98,42.62),(-96.99,-63.19,43.54),(-96.75,-63.08,43.29),(-96.53,-63.15,43.13),(-96.54,-63.59,42.9),(-96.35,-63.39,42.65),(-95.94,-63.32,42.72),(-97.39,-63.09,43.83),(-97.19,-63.17,43.7),(-97.16,-63.85,43.54),(-96.33,-63.87,43.06),(-96.19,-63.54,43.0),(-97.62,-63.54,44.22),(-97.22,-64.11,43.71),(-96.74,-64.4,43.43),(-96.35,-64.38,43.44),(-97.66,-64.02,44.47),(-97.45,-64.08,44.32),(-97.13,-64.53,44.25),(-96.91,-64.87,43.78),(-96.73,-64.8,43.6),(-97.58,-64.45,44.59),(-96.87,-65.05,44.1),(-96.58,-65.08,43.87),(-96.48,-64.93,43.54),(-96.19,-64.95,43.69),(-97.41,-64.98,44.68),(-97.29,-65.19,44.68),(-97.07,-65.28,44.53),(-96.83,-65.39,44.38),(-96.53,-65.38,44.12),(-96.28,-65.2,43.83),(-96.73,-62.57,43.37),(-96.6,-62.43,43.18),(-96.37,-62.37,42.96),(-95.99,-62.49,42.7),(-95.89,-62.69,42.68),(-96.92,-63.15,43.77),(-96.68,-63.05,43.52),(-96.45,-63.12,43.36),(-97.32,-63.06,44.06),(-97.22,-63.58,44.21),(-97.15,-64.08,43.94),(-97.54,-63.51,44.45),(-97.59,-63.98,44.7),(-97.38,-64.05,44.56),(-97.06,-64.49,44.48),(-96.84,-64.84,44.01),(-97.5,-64.42,44.82),(-97.04,-64.84,44.61),(-96.79,-65.02,44.33),(-96.5,-65.04,44.1),(-97.34,-64.94,44.91),(-97.22,-65.15,44.91),(-97.0,-65.25,44.76),(-96.76,-65.36,44.61),(-96.46,-65.35,44.36),(-96.2,-65.17,44.06),(-94.63,-64.64,31.51),(-90.03,-64.8,35.89),(-91.43,-65.85,32.21),(-92.65,-65.16,31.72),(-97.43,-63.04,33.31),(-97.05,-65.38,32.61),(-94.88,-65.58,31.6),(-97.3,-68.86,34.08),(-97.01,-69.59,36.02),(-92.08,-59.62,32.75),(-92.84,-60.87,31.65),(-94.0,-63.05,31.16),(-90.97,-68.29,35.14),(-93.32,-66.97,32.23),(-95.2,-69.25,35.56),(-88.7,-62.43,35.55),(-90.22,-59.93,33.96),(-91.73,-62.77,31.8),(-101.2,-67.39,35.89),(-99.95,-69.05,35.89),(-98.74,-67.82,32.95),(-95.53,-63.26,32.04),(-94.17,-60.4,32.85),(-89.6,-63.1,35.87),(-89.78,-63.63,36.19),(-89.51,-62.02,35.24),(-89.25,-61.5,34.51),(-90.15,-63.57,35.87),(-89.91,-62.4,34.97),(-90.48,-61.22,33.24),(-91.29,-60.42,32.62),(-90.05,-58.81,34.12),(-89.87,-60.6,34.43),(-89.41,-61.08,34.33),(-88.9,-61.58,35.43),(-90.01,-62.66,33.2),(-89.29,-62.76,35.54),(-88.57,-62.82,35.92),(-89.48,-60.75,34.37),(-90.35,-65.67,33.36),(-90.39,-64.32,36.18),(-92.19,-64.44,31.62),(-90.22,-66.2,33.63),(-90.38,-64.29,34.8),(-89.9,-64.11,36.37),(-90.82,-65.02,33.02),(-91.29,-65.33,32.19),(-90.54,-65.0,35.22),(-89.78,-65.44,34.96),(-92.37,-67.78,33.72),(-92.85,-68.89,35.32),(-90.94,-61.88,32.56),(-90.41,-59.52,33.58),(-89.94,-64.46,36.47),(-89.44,-65.11,35.99),(-89.52,-65.65,35.7),(-91.63,-64.57,32.86),(-90.36,-63.47,34.75),(-91.48,-63.82,32.38),(-89.59,-62.11,34.52),(-101.5,-64.54,35.04),(-100.4,-61.95,37.12),(-101.0,-62.28,37.31),(-103.7,-57.37,36.63),(-102.4,-58.59,36.73),(-100.5,-61.49,37.08),(-101.6,-56.28,35.82),(-102.6,-53.89,35.63),(-102.1,-59.84,37.12),(-101.2,-60.98,37.08),(-104.1,-55.19,36.0),(-102.0,-61.04,37.22),(-101.5,-61.43,37.24),(-101.1,-61.82,37.26),(-97.54,-63.44,32.28),(-97.39,-63.28,32.36),(-97.13,-63.19,32.48),(-96.96,-63.23,32.56),(-96.72,-63.28,32.68),(-96.61,-63.47,32.76),(-96.55,-63.75,32.81),(-97.76,-64.06,32.21),(-97.49,-63.93,32.33),(-97.24,-63.98,32.45),(-97.21,-64.37,32.86),(-97.0,-64.14,32.96),(-96.63,-64.09,32.69),(-98.18,-64.0,32.0),(-97.97,-64.07,32.11),(-97.91,-64.7,32.54),(-97.03,-64.65,32.79),(-96.88,-64.35,32.63),(-98.45,-64.49,31.89),(-97.97,-64.97,32.52),(-97.46,-65.22,32.77),(-98.5,-64.99,31.88),(-98.28,-65.04,31.98),(-97.95,-65.46,32.16),(-97.66,-65.73,32.69),(-97.46,-65.63,32.78),(-98.43,-65.43,31.93),(-97.65,-65.95,32.45),(-97.33,-65.95,32.61),(-97.17,-65.75,32.92),(-96.86,-65.85,32.57),(-98.26,-65.95,32.02),(-98.14,-66.16,32.09),(-97.9,-66.23,32.2),(-97.65,-66.33,32.33),(-97.32,-66.28,32.48),(-97.03,-66.07,32.62),(-97.53,-63.4,32.02),(-97.35,-63.28,32.11),(-97.09,-63.2,32.23),(-96.68,-63.29,32.43),(-96.57,-63.48,32.5),(-96.51,-63.76,32.55),(-97.72,-64.07,31.95),(-97.45,-63.93,32.08),(-97.2,-63.98,32.2),(-98.14,-64.01,31.75),(-98.06,-64.53,31.8),(-98.4,-64.5,31.63),(-98.24,-65.04,31.73),(-98.46,-64.99,31.62),(-97.9,-65.46,31.9),(-97.62,-65.73,32.44),(-98.39,-65.44,31.67),(-97.89,-65.82,31.92),(-97.61,-65.96,32.2),(-97.29,-65.95,32.35),(-97.12,-65.75,32.62),(-98.22,-65.96,31.77),(-98.1,-66.17,31.83),(-97.86,-66.24,31.95),(-97.6,-66.33,32.07),(-97.28,-66.28,32.23),(-96.99,-66.07,32.36),(-92.7,-61.07,42.39),(-93.36,-61.81,31.16),(-93.17,-45.91,45.24),(-94.14,-47.78,22.17)]))),
          Shape(
            appearance=Appearance(
              material=Material(ambientIntensity=1.0,diffuseColor=(0.5882,0.5882,0.5882),shininess=0.145),
              texture=ImageTexture(url=["LaetitiaHeadTemplateColor.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/LaetitiaHeadTemplateColor.jpg"])),
            geometry=IndexedFaceSet(DEF='Body-FACE',ccw=False,coordIndex=[594,586,511,-1,595,591,546,-1,514,580,546,-1,512,587,535,-1,535,587,529,-1,514,515,534,-1,515,545,588,-1,513,528,508,-1,512,535,513,-1,535,529,528,-1,588,529,587,-1,536,530,529,-1,545,516,530,-1,516,509,530,-1,575,517,552,-1,576,568,518,-1,575,574,537,-1,558,551,578,-1,565,538,519,-1,569,557,571,-1,532,589,539,-1,512,513,584,-1,531,567,562,-1,538,592,519,-1,527,531,544,-1,557,572,556,-1,533,835,539,-1,508,533,579,-1,508,579,513,-1,601,603,520,-1,522,540,523,-1,522,601,540,-1,602,541,524,-1,523,540,541,-1,540,542,541,-1,601,542,540,-1,520,521,601,-1,524,530,509,-1,524,541,530,-1,541,529,530,-1,541,542,529,-1,542,528,529,-1,521,528,542,-1,508,528,521,-1,102,526,544,-1,544,526,590,-1,508,543,533,-1,508,521,543,-1,544,543,102,-1,531,532,544,-1,531,561,532,-1,567,531,527,-1,545,530,536,-1,515,588,534,-1,586,580,577,-1,582,547,593,-1,582,548,547,-1,551,548,582,-1,551,558,550,-1,551,549,548,-1,551,550,549,-1,559,574,550,-1,549,575,552,-1,517,537,553,-1,553,556,554,-1,560,599,573,-1,574,559,537,-1,553,537,556,-1,554,556,572,-1,559,550,558,-1,597,573,559,-1,599,557,559,-1,598,596,579,-1,571,570,563,-1,539,589,573,-1,560,538,568,-1,567,510,562,-1,592,562,519,-1,566,562,510,-1,569,571,563,-1,568,565,564,-1,568,538,565,-1,519,562,566,-1,562,592,531,-1,568,564,518,-1,560,561,538,-1,557,569,572,-1,560,568,571,-1,518,570,576,-1,557,560,571,-1,573,589,560,-1,554,572,555,-1,569,555,572,-1,597,559,558,-1,573,599,559,-1,574,575,550,-1,537,559,556,-1,575,549,550,-1,575,537,517,-1,568,576,571,-1,571,576,570,-1,580,587,512,-1,585,511,586,-1,578,551,582,-1,598,579,539,-1,512,584,577,-1,584,583,577,-1,534,580,514,-1,581,578,585,-1,558,581,597,-1,596,598,581,-1,578,582,593,-1,547,507,593,-1,585,578,511,-1,583,584,596,-1,513,579,584,-1,579,596,584,-1,596,581,583,-1,583,585,577,-1,577,585,586,-1,595,580,586,-1,580,512,577,-1,535,528,513,-1,534,588,587,-1,580,534,587,-1,588,536,529,-1,545,536,588,-1,589,561,560,-1,532,561,589,-1,544,532,543,-1,543,835,533,-1,590,527,544,-1,594,593,507,-1,561,531,592,-1,538,561,592,-1,578,593,511,-1,511,593,594,-1,586,594,595,-1,591,594,507,-1,594,591,595,-1,580,595,546,-1,583,581,585,-1,539,573,598,-1,573,597,598,-1,581,558,578,-1,598,597,581,-1,539,579,533,-1,557,556,559,-1,560,557,599,-1,102,543,520,-1,521,542,601,-1,601,522,600,-1,523,541,602,-1,604,603,601,-1,520,543,521,-1,603,525,526,-1,603,102,520,-1,526,102,603,-1,600,604,601,-1,620,525,603,-1,619,620,623,-1,618,619,623,-1,612,613,629,-1,614,615,625,-1,615,616,624,-1,618,623,628,-1,630,606,607,-1,627,609,626,-1,627,608,609,-1,616,617,622,-1,615,624,625,-1,622,609,621,-1,621,609,610,-1,630,607,608,-1,623,603,604,-1,632,604,605,-1,604,600,605,-1,631,605,606,-1,625,624,629,-1,629,624,621,-1,629,613,625,-1,613,614,625,-1,624,616,622,-1,622,617,626,-1,617,627,626,-1,618,627,617,-1,628,630,627,-1,618,628,627,-1,623,632,628,-1,623,620,603,-1,629,621,610,-1,610,612,629,-1,621,624,622,-1,622,626,609,-1,630,608,627,-1,631,606,630,-1,628,631,630,-1,632,605,631,-1,628,632,631,-1,623,604,632,-1,640,634,633,-1,634,640,641,-1,641,635,634,-1,635,641,642,-1,642,636,635,-1,636,642,643,-1,643,637,636,-1,637,643,644,-1,644,638,637,-1,638,644,645,-1,645,639,638,-1,633,646,647,-1,647,640,633,-1,640,647,648,-1,648,641,640,-1,648,642,641,-1,642,648,653,-1,653,643,642,-1,644,643,649,-1,653,649,643,-1,644,649,650,-1,650,645,644,-1,646,651,647,-1,648,647,652,-1,648,652,653,-1,654,649,653,-1,651,655,656,-1,656,647,651,-1,652,656,657,-1,656,652,647,-1,652,657,658,-1,652,658,659,-1,659,653,652,-1,653,659,663,-1,663,654,653,-1,655,660,656,-1,661,658,657,-1,658,661,662,-1,662,659,658,-1,659,662,663,-1,664,654,663,-1,665,656,660,-1,656,665,666,-1,666,657,656,-1,657,666,667,-1,667,661,657,-1,661,667,668,-1,668,662,661,-1,662,668,669,-1,669,663,662,-1,663,669,670,-1,670,664,663,-1,671,672,677,-1,672,673,677,-1,677,676,671,-1,678,677,673,-1,678,674,645,-1,674,678,673,-1,674,675,645,-1,675,639,645,-1,676,679,671,-1,676,677,680,-1,680,677,681,-1,678,681,677,-1,681,678,645,-1,649,681,645,-1,650,649,645,-1,679,676,680,-1,680,682,679,-1,654,681,649,-1,682,680,684,-1,684,683,682,-1,684,681,685,-1,681,684,680,-1,686,685,681,-1,681,654,521,-1,521,686,681,-1,684,687,683,-1,684,685,688,-1,688,686,689,-1,686,688,685,-1,690,689,686,-1,690,521,664,-1,521,690,686,-1,521,654,664,-1,687,684,691,-1,684,688,692,-1,692,691,684,-1,693,689,694,-1,693,692,688,-1,689,690,695,-1,689,693,688,-1,690,664,696,-1,695,694,689,-1,696,695,690,-1,633,634,672,-1,672,671,633,-1,634,635,673,-1,673,672,634,-1,635,636,673,-1,636,637,674,-1,674,673,636,-1,637,638,675,-1,675,674,637,-1,639,675,638,-1,664,670,696,-1,670,669,695,-1,695,696,670,-1,669,668,694,-1,694,695,669,-1,668,667,693,-1,693,694,668,-1,667,666,692,-1,692,693,667,-1,666,665,691,-1,691,692,666,-1,665,660,691,-1,687,691,660,-1,660,655,683,-1,683,687,660,-1,655,651,682,-1,682,683,655,-1,651,646,679,-1,679,682,651,-1,646,633,671,-1,671,679,646,-1,751,698,745,-1,752,546,591,-1,514,546,739,-1,699,710,746,-1,710,704,746,-1,514,709,515,-1,515,747,545,-1,700,697,703,-1,699,700,710,-1,710,703,704,-1,747,746,704,-1,711,704,705,-1,545,705,516,-1,516,705,509,-1,734,552,517,-1,735,518,729,-1,734,712,733,-1,724,737,721,-1,565,519,713,-1,569,730,723,-1,707,714,748,-1,699,743,700,-1,706,728,567,-1,713,519,749,-1,527,719,706,-1,723,722,731,-1,836,714,707,-1,697,738,708,-1,697,700,738,-1,757,701,758,-1,522,523,715,-1,522,715,757,-1,602,524,716,-1,523,716,715,-1,715,716,717,-1,757,715,717,-1,701,757,702,-1,524,509,705,-1,524,705,716,-1,716,705,704,-1,716,704,717,-1,717,704,703,-1,702,717,703,-1,697,702,703,-1,99,719,526,-1,719,590,526,-1,697,708,718,-1,697,718,702,-1,719,99,718,-1,706,719,707,-1,706,707,727,-1,567,527,706,-1,545,711,705,-1,515,709,747,-1,745,736,739,-1,741,750,547,-1,741,547,548,-1,721,741,548,-1,721,720,724,-1,721,548,549,-1,721,549,720,-1,725,720,733,-1,549,552,734,-1,517,553,712,-1,553,554,722,-1,726,732,756,-1,733,712,725,-1,553,722,712,-1,554,731,722,-1,725,724,720,-1,754,725,732,-1,756,725,723,-1,755,738,753,-1,730,563,570,-1,714,732,748,-1,726,729,713,-1,567,728,510,-1,749,519,728,-1,566,510,728,-1,569,563,730,-1,729,564,565,-1,729,565,713,-1,519,566,728,-1,728,706,749,-1,729,518,564,-1,726,713,727,-1,723,731,569,-1,726,730,729,-1,518,735,570,-1,723,730,726,-1,732,726,748,-1,554,555,731,-1,569,731,555,-1,754,724,725,-1,732,725,756,-1,733,720,734,-1,712,722,725,-1,734,720,549,-1,734,517,712,-1,729,730,735,-1,730,570,735,-1,739,699,746,-1,744,745,698,-1,737,741,721,-1,755,714,738,-1,699,736,743,-1,743,736,742,-1,709,514,739,-1,740,744,737,-1,724,754,740,-1,753,740,755,-1,737,750,741,-1,547,750,507,-1,744,698,737,-1,742,753,743,-1,700,743,738,-1,738,743,753,-1,753,742,740,-1,742,736,744,-1,736,745,744,-1,752,745,739,-1,739,736,699,-1,710,700,703,-1,709,746,747,-1,739,746,709,-1,747,704,711,-1,545,747,711,-1,748,726,727,-1,707,748,727,-1,719,718,707,-1,718,836,707,-1,590,719,527,-1,751,507,750,-1,727,749,706,-1,713,749,727,-1,737,698,750,-1,698,751,750,-1,745,752,751,-1,591,507,751,-1,751,752,591,-1,739,546,752,-1,742,744,740,-1,714,755,732,-1,732,755,754,-1,740,737,724,-1,755,740,754,-1,714,708,738,-1,723,725,722,-1,726,756,723,-1,99,701,718,-1,702,757,717,-1,757,600,522,-1,523,602,716,-1,759,757,758,-1,701,702,718,-1,758,526,525,-1,758,701,99,-1,526,758,99,-1,600,757,759,-1,620,758,525,-1,619,762,620,-1,618,762,619,-1,764,613,612,-1,764,614,613,-1,615,764,763,-1,618,766,762,-1,768,607,606,-1,609,608,761,-1,608,765,761,-1,617,616,763,-1,763,764,767,-1,761,763,760,-1,765,608,768,-1,762,759,758,-1,770,605,759,-1,759,605,600,-1,769,606,605,-1,767,760,763,-1,764,612,767,-1,764,615,614,-1,617,763,761,-1,761,765,617,-1,617,765,618,-1,766,765,768,-1,618,765,766,-1,762,766,770,-1,762,758,620,-1,610,760,767,-1,610,767,612,-1,760,610,609,-1,761,760,609,-1,768,608,607,-1,769,768,606,-1,766,768,769,-1,770,769,605,-1,766,769,770,-1,762,770,759,-1,778,771,772,-1,772,779,778,-1,779,772,773,-1,773,780,779,-1,780,773,774,-1,774,781,780,-1,781,774,775,-1,775,782,781,-1,782,775,776,-1,776,783,782,-1,783,776,777,-1,771,785,784,-1,785,771,778,-1,778,786,785,-1,786,778,779,-1,786,779,780,-1,780,791,786,-1,791,780,781,-1,782,787,781,-1,791,781,787,-1,782,788,787,-1,788,782,783,-1,784,785,789,-1,786,790,785,-1,786,791,790,-1,702,791,787,-1,789,793,792,-1,793,789,785,-1,790,794,793,-1,793,785,790,-1,790,795,794,-1,790,796,795,-1,796,790,791,-1,791,800,796,-1,800,791,702,-1,792,793,797,-1,798,794,795,-1,795,799,798,-1,799,795,796,-1,796,800,799,-1,801,800,702,-1,802,797,793,-1,793,803,802,-1,803,793,794,-1,794,804,803,-1,804,794,798,-1,798,805,804,-1,805,798,799,-1,799,806,805,-1,806,799,800,-1,800,807,806,-1,807,800,801,-1,808,815,809,-1,809,815,810,-1,815,808,814,-1,816,810,815,-1,816,783,811,-1,811,810,816,-1,811,783,812,-1,812,783,813,-1,814,808,817,-1,814,818,815,-1,816,815,818,-1,818,783,816,-1,787,783,818,-1,788,783,787,-1,817,818,814,-1,818,817,819,-1,702,787,818,-1,819,820,818,-1,820,819,821,-1,820,823,818,-1,823,820,822,-1,702,818,823,-1,820,821,824,-1,820,825,822,-1,825,826,823,-1,823,822,825,-1,827,823,826,-1,827,828,702,-1,702,823,827,-1,801,702,828,-1,824,829,820,-1,820,830,825,-1,830,820,829,-1,831,832,826,-1,831,825,830,-1,826,833,827,-1,826,825,831,-1,827,834,828,-1,833,826,832,-1,828,834,801,-1,834,827,833,-1,771,809,772,-1,809,771,808,-1,772,810,773,-1,810,772,809,-1,773,810,774,-1,774,811,775,-1,811,774,810,-1,775,812,776,-1,812,775,811,-1,776,813,777,-1,813,776,812,-1,783,777,813,-1,801,834,807,-1,807,833,806,-1,833,807,834,-1,806,832,805,-1,832,806,833,-1,805,831,804,-1,831,805,832,-1,804,830,803,-1,830,804,831,-1,803,829,802,-1,829,803,830,-1,802,829,797,-1,824,797,829,-1,797,821,792,-1,821,797,824,-1,792,819,789,-1,819,792,821,-1,789,817,784,-1,817,789,819,-1,784,808,771,-1,808,784,817,-1,616,615,763,-1,835,532,539,-1,543,532,835,-1,708,714,836,-1,718,708,836,-1],creaseAngle=10,texCoordIndex=[2105,2097,2021,-1,2106,2102,2057,-1,2350,2091,2057,-1,2022,2361,2356,-1,2045,2098,2039,-1,2024,2025,2044,-1,2025,2056,2099,-1,2023,2353,2018,-1,2022,2356,2023,-1,2045,2039,2038,-1,2099,2039,2098,-1,2046,2040,2039,-1,2056,2026,2040,-1,2026,2019,2040,-1,2086,2027,2063,-1,2087,2079,2028,-1,2086,2085,2047,-1,2069,2062,2089,-1,2076,2048,2029,-1,2080,2068,2082,-1,2042,2100,2049,-1,2022,2023,2095,-1,2041,2078,2073,-1,2048,2103,2029,-1,2037,2041,2055,-1,2068,2083,2067,-1,2043,2346,2049,-1,2018,2043,2090,-1,2018,2090,2023,-1,2112,2114,2030,-1,2032,2050,2033,-1,2032,2112,2050,-1,2113,2051,2034,-1,2033,2050,2051,-1,2050,2052,2051,-1,2112,2052,2050,-1,2030,2031,2112,-1,2034,2040,2019,-1,2034,2051,2040,-1,2051,2039,2040,-1,2051,2052,2039,-1,2052,2038,2039,-1,2031,2038,2052,-1,2018,2353,2352,-1,2373,2372,2055,-1,2055,2372,2101,-1,2018,2054,2043,-1,2018,2352,2054,-1,2358,2054,2357,-1,2354,2042,2358,-1,2354,2072,2042,-1,2078,2041,2037,-1,2056,2040,2046,-1,2025,2099,2044,-1,2097,2091,2088,-1,2093,2058,2104,-1,2093,2059,2058,-1,2062,2059,2093,-1,2062,2069,2061,-1,2062,2060,2059,-1,2062,2061,2060,-1,2070,2085,2061,-1,2060,2086,2063,-1,2027,2047,2064,-1,2064,2067,2065,-1,2071,2110,2084,-1,2085,2070,2047,-1,2064,2047,2067,-1,2065,2067,2083,-1,2070,2061,2069,-1,2108,2084,2070,-1,2110,2068,2070,-1,2109,2107,2090,-1,2082,2081,2074,-1,2049,2100,2084,-1,2071,2048,2079,-1,2078,2020,2073,-1,2103,2359,2029,-1,2077,2073,2020,-1,2080,2082,2074,-1,2079,2076,2075,-1,2079,2048,2076,-1,2029,2359,2360,-1,2359,2103,2354,-1,2079,2075,2028,-1,2071,2072,2048,-1,2068,2080,2083,-1,2071,2079,2082,-1,2028,2081,2087,-1,2068,2071,2082,-1,2084,2100,2071,-1,2065,2083,2066,-1,2080,2066,2083,-1,2108,2070,2069,-1,2084,2110,2070,-1,2085,2086,2061,-1,2047,2070,2067,-1,2086,2060,2061,-1,2086,2047,2027,-1,2079,2087,2082,-1,2082,2087,2081,-1,2091,2361,2022,-1,2096,2021,2097,-1,2089,2062,2093,-1,2109,2090,2049,-1,2022,2095,2088,-1,2095,2094,2088,-1,2355,2091,2350,-1,2092,2089,2096,-1,2069,2092,2108,-1,2107,2109,2092,-1,2089,2093,2104,-1,2058,2017,2104,-1,2096,2089,2021,-1,2094,2095,2107,-1,2023,2090,2095,-1,2090,2107,2095,-1,2107,2092,2094,-1,2094,2096,2088,-1,2088,2096,2097,-1,2106,2091,2097,-1,2091,2022,2088,-1,2356,2353,2023,-1,2044,2099,2098,-1,2091,2355,2361,-1,2099,2046,2039,-1,2056,2046,2099,-1,2100,2072,2071,-1,2042,2072,2100,-1,2358,2042,2054,-1,2054,2346,2043,-1,2101,2037,2055,-1,2105,2104,2017,-1,2072,2354,2103,-1,2048,2072,2103,-1,2089,2104,2021,-1,2021,2104,2105,-1,2097,2105,2106,-1,2102,2105,2017,-1,2105,2102,2106,-1,2091,2106,2057,-1,2094,2092,2096,-1,2049,2084,2109,-1,2084,2108,2109,-1,2092,2069,2089,-1,2109,2108,2092,-1,2049,2090,2043,-1,2068,2067,2070,-1,2071,2068,2110,-1,2357,2054,2351,-1,2031,2052,2112,-1,2112,2032,2111,-1,2033,2051,2113,-1,2115,2114,2112,-1,2351,2054,2352,-1,2114,2035,2036,-1,2114,2053,2030,-1,2036,2053,2114,-1,2111,2115,2112,-1,2130,2035,2114,-1,2129,2130,2133,-1,2128,2129,2133,-1,2122,2123,2139,-1,2124,2125,2135,-1,2125,2126,2134,-1,2128,2133,2138,-1,2140,2117,2118,-1,2137,2120,2136,-1,2137,2119,2120,-1,2126,2127,2132,-1,2125,2134,2135,-1,2132,2120,2131,-1,2131,2120,2121,-1,2140,2118,2119,-1,2133,2114,2115,-1,2142,2115,2116,-1,2115,2111,2116,-1,2141,2116,2117,-1,2135,2134,2139,-1,2139,2134,2131,-1,2139,2123,2135,-1,2123,2124,2135,-1,2134,2126,2132,-1,2132,2127,2136,-1,2127,2137,2136,-1,2128,2137,2127,-1,2138,2140,2137,-1,2128,2138,2137,-1,2133,2142,2138,-1,2133,2130,2114,-1,2139,2131,2121,-1,2121,2122,2139,-1,2131,2134,2132,-1,2132,2136,2120,-1,2140,2119,2137,-1,2141,2117,2140,-1,2138,2141,2140,-1,2142,2116,2141,-1,2138,2142,2141,-1,2133,2115,2142,-1,2150,2144,2143,-1,2144,2150,2151,-1,2151,2145,2144,-1,2145,2151,2152,-1,2152,2146,2145,-1,2146,2152,2153,-1,2153,2147,2146,-1,2147,2153,2154,-1,2154,2148,2147,-1,2148,2154,2155,-1,2155,2149,2148,-1,2143,2156,2157,-1,2157,2150,2143,-1,2150,2157,2158,-1,2158,2151,2150,-1,2158,2152,2151,-1,2152,2158,2163,-1,2163,2153,2152,-1,2154,2153,2159,-1,2163,2159,2153,-1,2154,2159,2160,-1,2160,2155,2154,-1,2156,2161,2157,-1,2158,2157,2162,-1,2158,2162,2163,-1,2164,2159,2163,-1,2161,2165,2166,-1,2166,2157,2161,-1,2162,2166,2167,-1,2166,2162,2157,-1,2162,2167,2168,-1,2162,2168,2169,-1,2169,2163,2162,-1,2163,2169,2173,-1,2173,2164,2163,-1,2165,2170,2166,-1,2171,2168,2167,-1,2168,2171,2172,-1,2172,2169,2168,-1,2169,2172,2173,-1,2174,2164,2173,-1,2175,2166,2170,-1,2166,2175,2176,-1,2176,2167,2166,-1,2167,2176,2177,-1,2177,2171,2167,-1,2171,2177,2178,-1,2178,2172,2171,-1,2172,2178,2179,-1,2179,2173,2172,-1,2173,2179,2180,-1,2180,2174,2173,-1,2181,2182,2187,-1,2182,2183,2187,-1,2187,2186,2181,-1,2188,2187,2183,-1,2188,2184,2155,-1,2184,2188,2183,-1,2184,2185,2155,-1,2185,2149,2155,-1,2186,2189,2181,-1,2186,2187,2190,-1,2190,2187,2191,-1,2188,2191,2187,-1,2191,2188,2155,-1,2159,2191,2155,-1,2160,2159,2155,-1,2189,2186,2190,-1,2190,2192,2189,-1,2164,2191,2159,-1,2192,2190,2194,-1,2194,2193,2192,-1,2194,2191,2195,-1,2191,2194,2190,-1,2196,2195,2191,-1,2191,2164,2348,-1,2348,2196,2191,-1,2194,2197,2193,-1,2194,2195,2198,-1,2198,2196,2199,-1,2196,2198,2195,-1,2200,2199,2196,-1,2200,2348,2174,-1,2348,2200,2196,-1,2348,2164,2174,-1,2197,2194,2201,-1,2194,2198,2202,-1,2202,2201,2194,-1,2203,2199,2204,-1,2203,2202,2198,-1,2199,2200,2205,-1,2199,2203,2198,-1,2200,2174,2206,-1,2205,2204,2199,-1,2206,2205,2200,-1,2143,2144,2182,-1,2182,2181,2143,-1,2144,2145,2183,-1,2183,2182,2144,-1,2145,2146,2183,-1,2146,2147,2184,-1,2184,2183,2146,-1,2147,2148,2185,-1,2185,2184,2147,-1,2149,2185,2148,-1,2174,2180,2206,-1,2180,2179,2205,-1,2205,2206,2180,-1,2179,2178,2204,-1,2204,2205,2179,-1,2178,2177,2203,-1,2203,2204,2178,-1,2177,2176,2202,-1,2202,2203,2177,-1,2176,2175,2201,-1,2201,2202,2176,-1,2175,2170,2201,-1,2197,2201,2170,-1,2170,2165,2193,-1,2193,2197,2170,-1,2165,2161,2192,-1,2192,2193,2165,-1,2161,2156,2189,-1,2189,2192,2161,-1,2156,2143,2181,-1,2181,2189,2156,-1,2262,2208,2256,-1,2263,2057,2102,-1,2350,2057,2250,-1,2209,2367,2371,-1,2220,2214,2257,-1,2024,2219,2025,-1,2025,2258,2056,-1,2210,2207,2364,-1,2209,2210,2367,-1,2220,2213,2214,-1,2258,2257,2214,-1,2221,2214,2215,-1,2056,2215,2026,-1,2026,2215,2019,-1,2245,2063,2027,-1,2246,2028,2240,-1,2245,2222,2244,-1,2235,2248,2232,-1,2076,2029,2223,-1,2080,2241,2234,-1,2217,2224,2259,-1,2209,2254,2210,-1,2216,2239,2078,-1,2223,2029,2260,-1,2037,2230,2216,-1,2234,2233,2242,-1,2347,2224,2217,-1,2207,2249,2218,-1,2207,2210,2249,-1,2268,2211,2269,-1,2032,2033,2225,-1,2032,2225,2268,-1,2113,2034,2226,-1,2033,2226,2225,-1,2225,2226,2227,-1,2268,2225,2227,-1,2211,2268,2212,-1,2034,2019,2215,-1,2034,2215,2226,-1,2226,2215,2214,-1,2226,2214,2227,-1,2227,2214,2213,-1,2212,2227,2213,-1,2207,2363,2364,-1,2374,2230,2372,-1,2230,2101,2372,-1,2207,2218,2229,-1,2207,2229,2363,-1,2369,2368,2229,-1,2365,2369,2217,-1,2365,2217,2238,-1,2078,2037,2216,-1,2056,2221,2215,-1,2025,2219,2258,-1,2256,2247,2250,-1,2252,2261,2058,-1,2252,2058,2059,-1,2232,2252,2059,-1,2232,2231,2235,-1,2232,2059,2060,-1,2232,2060,2231,-1,2236,2231,2244,-1,2060,2063,2245,-1,2027,2064,2222,-1,2064,2065,2233,-1,2237,2243,2267,-1,2244,2222,2236,-1,2064,2233,2222,-1,2065,2242,2233,-1,2236,2235,2231,-1,2265,2236,2243,-1,2267,2236,2234,-1,2266,2249,2264,-1,2241,2074,2081,-1,2224,2243,2259,-1,2237,2240,2223,-1,2078,2239,2020,-1,2260,2029,2370,-1,2077,2020,2239,-1,2080,2074,2241,-1,2240,2075,2076,-1,2240,2076,2223,-1,2029,2360,2370,-1,2370,2365,2260,-1,2240,2028,2075,-1,2237,2223,2238,-1,2234,2242,2080,-1,2237,2241,2240,-1,2028,2246,2081,-1,2234,2241,2237,-1,2243,2237,2259,-1,2065,2066,2242,-1,2080,2242,2066,-1,2265,2235,2236,-1,2243,2236,2267,-1,2244,2231,2245,-1,2222,2233,2236,-1,2245,2231,2060,-1,2245,2027,2222,-1,2240,2241,2246,-1,2241,2081,2246,-1,2250,2209,2371,-1,2255,2256,2208,-1,2248,2252,2232,-1,2266,2224,2249,-1,2209,2247,2254,-1,2254,2247,2253,-1,2366,2350,2250,-1,2251,2255,2248,-1,2235,2265,2251,-1,2264,2251,2266,-1,2248,2261,2252,-1,2058,2261,2017,-1,2255,2208,2248,-1,2253,2264,2254,-1,2210,2254,2249,-1,2249,2254,2264,-1,2264,2253,2251,-1,2253,2247,2255,-1,2247,2256,2255,-1,2263,2256,2250,-1,2250,2247,2209,-1,2367,2210,2364,-1,2219,2257,2258,-1,2250,2371,2366,-1,2258,2214,2221,-1,2056,2258,2221,-1,2259,2237,2238,-1,2217,2259,2238,-1,2369,2229,2217,-1,2229,2347,2217,-1,2101,2230,2037,-1,2262,2017,2261,-1,2238,2260,2365,-1,2223,2260,2238,-1,2248,2208,2261,-1,2208,2262,2261,-1,2256,2263,2262,-1,2102,2017,2262,-1,2262,2263,2102,-1,2250,2057,2263,-1,2253,2255,2251,-1,2224,2266,2243,-1,2243,2266,2265,-1,2251,2248,2235,-1,2266,2251,2265,-1,2224,2218,2249,-1,2234,2236,2233,-1,2237,2267,2234,-1,2368,2362,2229,-1,2212,2268,2227,-1,2268,2111,2032,-1,2033,2113,2226,-1,2270,2268,2269,-1,2362,2363,2229,-1,2269,2036,2035,-1,2269,2211,2228,-1,2036,2269,2228,-1,2111,2268,2270,-1,2130,2269,2035,-1,2129,2273,2130,-1,2128,2273,2129,-1,2275,2123,2122,-1,2275,2124,2123,-1,2125,2275,2274,-1,2128,2277,2273,-1,2279,2118,2117,-1,2120,2119,2272,-1,2119,2276,2272,-1,2127,2126,2274,-1,2274,2275,2278,-1,2272,2274,2271,-1,2276,2119,2279,-1,2273,2270,2269,-1,2281,2116,2270,-1,2270,2116,2111,-1,2280,2117,2116,-1,2278,2271,2274,-1,2275,2122,2278,-1,2275,2125,2124,-1,2127,2274,2272,-1,2272,2276,2127,-1,2127,2276,2128,-1,2277,2276,2279,-1,2128,2276,2277,-1,2273,2277,2281,-1,2273,2269,2130,-1,2121,2271,2278,-1,2121,2278,2122,-1,2271,2121,2120,-1,2272,2271,2120,-1,2279,2119,2118,-1,2280,2279,2117,-1,2277,2279,2280,-1,2281,2280,2116,-1,2277,2280,2281,-1,2273,2281,2270,-1,2289,2282,2283,-1,2283,2290,2289,-1,2290,2283,2284,-1,2284,2291,2290,-1,2291,2284,2285,-1,2285,2292,2291,-1,2292,2285,2286,-1,2286,2293,2292,-1,2293,2286,2287,-1,2287,2294,2293,-1,2294,2287,2288,-1,2282,2296,2295,-1,2296,2282,2289,-1,2289,2297,2296,-1,2297,2289,2290,-1,2297,2290,2291,-1,2291,2302,2297,-1,2302,2291,2292,-1,2293,2298,2292,-1,2302,2292,2298,-1,2293,2299,2298,-1,2299,2293,2294,-1,2295,2296,2300,-1,2297,2301,2296,-1,2297,2302,2301,-1,2349,2302,2298,-1,2300,2304,2303,-1,2304,2300,2296,-1,2301,2305,2304,-1,2304,2296,2301,-1,2301,2306,2305,-1,2301,2307,2306,-1,2307,2301,2302,-1,2302,2311,2307,-1,2311,2302,2349,-1,2303,2304,2308,-1,2309,2305,2306,-1,2306,2310,2309,-1,2310,2306,2307,-1,2307,2311,2310,-1,2312,2311,2349,-1,2313,2308,2304,-1,2304,2314,2313,-1,2314,2304,2305,-1,2305,2315,2314,-1,2315,2305,2309,-1,2309,2316,2315,-1,2316,2309,2310,-1,2310,2317,2316,-1,2317,2310,2311,-1,2311,2318,2317,-1,2318,2311,2312,-1,2319,2326,2320,-1,2320,2326,2321,-1,2326,2319,2325,-1,2327,2321,2326,-1,2327,2294,2322,-1,2322,2321,2327,-1,2322,2294,2323,-1,2323,2294,2324,-1,2325,2319,2328,-1,2325,2329,2326,-1,2327,2326,2329,-1,2329,2294,2327,-1,2298,2294,2329,-1,2299,2294,2298,-1,2328,2329,2325,-1,2329,2328,2330,-1,2349,2298,2329,-1,2330,2331,2329,-1,2331,2330,2332,-1,2331,2334,2329,-1,2334,2331,2333,-1,2349,2329,2334,-1,2331,2332,2335,-1,2331,2336,2333,-1,2336,2337,2334,-1,2334,2333,2336,-1,2338,2334,2337,-1,2338,2339,2349,-1,2349,2334,2338,-1,2312,2349,2339,-1,2335,2340,2331,-1,2331,2341,2336,-1,2341,2331,2340,-1,2342,2343,2337,-1,2342,2336,2341,-1,2337,2344,2338,-1,2337,2336,2342,-1,2338,2345,2339,-1,2344,2337,2343,-1,2339,2345,2312,-1,2345,2338,2344,-1,2282,2320,2283,-1,2320,2282,2319,-1,2283,2321,2284,-1,2321,2283,2320,-1,2284,2321,2285,-1,2285,2322,2286,-1,2322,2285,2321,-1,2286,2323,2287,-1,2323,2286,2322,-1,2287,2324,2288,-1,2324,2287,2323,-1,2294,2288,2324,-1,2312,2345,2318,-1,2318,2344,2317,-1,2344,2318,2345,-1,2317,2343,2316,-1,2343,2317,2344,-1,2316,2342,2315,-1,2342,2316,2343,-1,2315,2341,2314,-1,2341,2315,2342,-1,2314,2340,2313,-1,2340,2314,2341,-1,2313,2340,2308,-1,2335,2308,2340,-1,2308,2332,2303,-1,2332,2308,2335,-1,2303,2330,2300,-1,2330,2303,2332,-1,2300,2328,2295,-1,2328,2300,2330,-1,2295,2319,2282,-1,2319,2295,2328,-1,2126,2125,2274,-1,2346,2042,2049,-1,2054,2042,2346,-1,2218,2224,2347,-1,2229,2218,2347,-1],
              texCoord=TextureCoordinate(USE='Body-TEXCOORD'),
              coord=Coordinate(USE='Body-COORD'))),
          CoordinateInterpolator(DEF='Body-COORD-INTERP',key=[0.0,0.0237,0.04739,0.07109,0.09479,0.1185,0.1422,0.1659,0.1896,0.2133,0.237,0.2607,0.2844,0.3081,0.3318,0.3555,0.3791,0.4028,0.4265,0.4502,0.4739,0.4976,0.5213,0.545,0.5687,0.5924,0.6161,0.6398,0.6635,0.6872,0.7109,0.7346,0.7583,0.782,0.8057,0.8294,0.8531,0.8768,0.9005,0.9242,0.9479,0.9716,0.9953,1.0],keyValue=[(-96.11,-43.92,32.81),(-87.26,-38.55,30.81),(-86.66,-46.07,33.16),(-96.73,-40.9,32.45),(-96.53,-43.38,38.03),(-94.57,-42.12,41.45),(-91.49,-42.34,41.0),(-92.28,-40.42,41.53),(-87.38,-45.46,39.64),(-89.51,-39.47,39.46),(-88.18,-38.74,36.43),(-94.66,-40.96,38.74),(-87.36,-46.46,26.83),(-96.53,-44.22,27.24),(-94.53,-43.48,24.0),(-91.5,-43.73,24.02),(-92.84,-41.89,22.62),(-89.97,-40.7,23.41),(-88.47,-39.62,25.9),(-95.05,-42.04,25.84),(-91.47,-53.88,25.21),(-99.21,-52.67,23.71),(-94.29,-52.0,23.51),(-96.53,-51.41,22.7),(-98.88,-56.66,27.83),(-97.73,-59.05,36.77),(-97.79,-47.47,33.93),(-99.15,-52.37,35.15),(-86.99,-50.48,34.74),(-88.95,-53.28,34.26),(-84.64,-50.45,28.34),(-85.49,-51.89,32.19),(-85.92,-51.9,25.69),(-87.81,-53.35,28.35),(-85.7,-47.98,28.17),(-97.56,-61.41,37.54),(-98.01,-47.07,39.92),(-98.78,-55.5,41.54),(-96.59,-46.29,43.96),(-90.04,-48.95,45.9),(-90.85,-45.83,42.84),(-84.65,-49.54,40.05),(-85.93,-50.53,43.26),(-87.85,-52.46,41.09),(-85.49,-51.52,37.01),(-88.91,-53.12,36.28),(-91.45,-52.41,44.64),(-87.43,-49.55,45.27),(-86.64,-47.76,43.31),(-85.7,-47.12,39.08),(-88.51,-47.28,45.5),(-88.04,-46.24,43.8),(-86.3,-46.26,40.38),(-94.3,-50.01,46.15),(-96.39,-49.75,46.11),(-96.31,-57.86,40.53),(-98.39,-51.37,47.75),(-96.09,-56.87,40.59),(-95.68,-60.14,40.2),(-97.73,-54.78,48.33),(-97.66,-55.41,44.87),(-92.97,-56.52,36.24),(-93.39,-56.36,39.78),(-91.03,-54.84,37.84),(-91.69,-54.62,35.89),(-90.61,-55.1,34.07),(-94.8,-57.04,38.09),(-93.12,-58.96,36.68),(-94.97,-59.79,39.2),(-94.81,-57.41,34.58),(-94.82,-60.05,34.97),(-92.11,-56.26,32.6),(-86.28,-47.35,26.42),(-87.41,-51.27,23.15),(-86.24,-49.11,24.18),(-96.36,-58.36,32.21),(-95.55,-60.64,33.7),(-99.16,-56.43,23.91),(-97.99,-48.05,27.3),(-98.47,-56.4,29.97),(-96.52,-47.86,23.92),(-90.05,-50.82,22.13),(-90.83,-47.32,23.68),(-88.51,-49.15,21.77),(-88.01,-47.87,22.91),(-96.52,-51.47,22.16),(-84.82,-49.31,28.27),(-84.83,-48.43,39.59),(-84.95,-51.34,34.62),(-95.45,-57.41,31.3),(-96.39,-49.79,45.56),(-96.52,-51.44,22.14),(-92.77,-54.79,44.05),(-93.25,-56.13,27.25),(-98.83,-57.14,27.73),(-97.77,-55.91,45.17),(-97.35,-57.25,41.02),(-97.3,-57.78,30.88),(-97.0,-60.12,34.88),(-96.75,-61.15,34.05),(-97.52,-58.74,34.65),(-97.01,-59.97,38.87),(-96.58,-60.57,40.28),(-97.48,-58.49,38.5),(-97.5,-60.71,37.33),(-93.88,-53.77,50.47),(-95.36,-52.65,51.56),(-94.77,-50.28,51.41),(-91.74,-51.44,51.83),(-90.56,-50.53,48.35),(-91.78,-53.36,48.96),(-91.24,-41.83,44.48),(-87.83,-41.94,46.34),(-88.78,-42.69,49.67),(-90.9,-42.63,50.66),(-93.92,-45.58,49.21),(-89.4,-39.3,44.09),(-91.24,-38.82,45.82),(-92.44,-40.33,47.98),(-84.88,-38.04,44.5),(-86.44,-37.3,42.6),(-82.58,-30.37,40.41),(-81.25,-31.1,41.63),(-87.51,-36.52,44.09),(-83.38,-29.2,43.02),(-88.59,-35.68,47.19),(-89.65,-36.45,46.3),(-91.37,-38.53,47.42),(-89.95,-38.81,49.39),(-82.3,-29.61,44.39),(-86.96,-36.39,48.43),(-81.32,-30.34,43.92),(-85.61,-37.22,47.87),(-88.35,-39.21,49.67),(-87.34,-40.12,48.77),(-79.12,-28.85,40.17),(-78.48,-28.62,40.81),(-80.21,-27.17,41.78),(-79.83,-29.74,40.11),(-78.95,-30.24,40.94),(-82.03,-26.51,42.81),(-76.96,-26.13,40.29),(-78.07,-27.03,41.23),(-77.36,-27.1,41.52),(-76.79,-25.53,39.22),(-77.49,-25.66,39.11),(-77.64,-25.59,40.31),(-77.33,-25.3,39.2),(-77.55,-26.14,40.0),(-77.42,-24.84,39.08),(-78.09,-25.0,39.03),(-78.52,-25.17,40.3),(-78.34,-25.53,40.08),(-78.05,-24.62,39.28),(-78.42,-24.8,39.21),(-79.05,-24.95,39.19),(-79.36,-24.95,40.36),(-79.25,-25.32,40.12),(-79.03,-24.55,39.29),(-80.05,-25.86,41.8),(-79.89,-26.18,41.26),(-80.85,-25.93,41.37),(-79.95,-25.49,40.82),(-79.75,-25.12,39.77),(-80.24,-25.14,39.53),(-80.63,-25.18,40.81),(-80.52,-25.48,40.55),(-80.24,-24.82,39.68),(-81.3,-25.79,42.02),(-78.5,-28.88,41.88),(-78.28,-27.92,43.17),(-79.44,-27.47,43.55),(-81.01,-26.89,43.23),(-77.23,-25.99,40.86),(-77.07,-25.68,40.2),(-77.73,-26.93,42.51),(-77.44,-26.46,41.75),(-78.21,-26.5,41.69),(-78.52,-26.26,42.48),(-78.24,-25.85,41.83),(-77.97,-25.36,40.84),(-77.79,-25.11,40.27),(-79.13,-26.11,41.72),(-79.5,-26.04,42.45),(-79.25,-25.67,41.95),(-78.8,-24.93,40.45),(-78.92,-25.2,40.95),(-80.19,-25.34,41.35),(-80.03,-25.15,40.92),(-80.44,-25.7,42.14),(-80.72,-26.06,42.68),(-77.62,-28.54,38.56),(-76.75,-28.99,37.55),(-76.67,-28.7,37.99),(-78.01,-29.18,38.53),(-76.54,-29.22,38.04),(-77.33,-29.45,39.13),(-78.1,-29.68,40.0),(-77.35,-28.86,39.7),(-77.04,-28.79,39.22),(-76.45,-28.95,38.4),(-93.83,-52.96,51.59),(-96.18,-55.99,21.0),(-97.54,-55.07,20.42),(-96.96,-52.63,18.72),(-94.42,-54.01,17.78),(-92.52,-52.55,19.85),(-93.92,-55.5,21.91),(-93.76,-43.55,20.28),(-91.08,-43.72,16.69),(-92.64,-45.09,14.61),(-94.84,-45.32,14.91),(-96.62,-47.77,19.06),(-92.66,-40.87,18.54),(-94.88,-40.97,17.94),(-96.07,-42.81,17.29),(-89.15,-39.11,14.94),(-90.31,-38.29,17.28),(-88.73,-30.85,14.3),(-87.59,-31.56,12.69),(-91.89,-37.99,16.33),(-90.48,-30.36,12.06),(-93.9,-37.95,13.96),(-94.37,-38.65,15.67),(-95.49,-41.01,16.5),(-94.62,-41.44,14.02),(-89.71,-30.83,10.34),(-92.52,-38.61,12.13),(-88.47,-31.28,10.43),(-90.9,-39.07,12.11),(-93.14,-41.67,12.96),(-91.72,-42.22,13.49),(-86.12,-28.9,11.96),(-85.75,-28.68,10.95),(-88.01,-27.74,10.62),(-86.45,-29.86,12.67),(-85.69,-30.3,11.58),(-90.11,-27.58,10.5),(-85.08,-25.98,9.91),(-86.0,-27.17,9.923),(-85.41,-27.15,9.294),(-84.89,-25.23,10.63),(-85.45,-25.45,11.15),(-85.88,-25.59,10.12),(-85.45,-25.09,10.88),(-85.55,-26.05,10.51),(-85.65,-24.66,10.9),(-86.19,-24.92,11.36),(-86.81,-25.34,10.5),(-86.48,-25.61,10.7),(-86.33,-24.59,11.01),(-86.6,-24.81,11.33),(-87.11,-25.05,11.73),(-87.65,-25.28,10.84),(-87.38,-25.58,11.1),(-87.25,-24.69,11.52),(-88.3,-26.48,10.15),(-87.94,-26.68,10.66),(-88.91,-26.62,11.0),(-88.11,-25.96,10.9),(-87.82,-25.42,11.64),(-88.2,-25.49,12.13),(-88.83,-25.78,11.19),(-88.57,-26.0,11.45),(-88.34,-25.21,11.9),(-89.51,-26.66,10.62),(-85.93,-29.08,10.09),(-86.34,-28.33,8.517),(-87.62,-28.16,8.672),(-89.16,-27.83,9.671),(-85.5,-25.98,9.51),(-85.31,-25.56,9.933),(-86.02,-27.19,8.544),(-85.74,-26.6,8.944),(-86.4,-26.75,9.431),(-86.95,-26.69,8.821),(-86.68,-26.16,9.139),(-86.37,-25.51,9.752),(-86.17,-25.16,10.1),(-87.38,-26.54,9.799),(-87.89,-26.65,9.317),(-87.68,-26.19,9.537),(-87.18,-25.18,10.45),(-87.31,-25.53,10.13),(-88.5,-25.94,10.51),(-88.32,-25.67,10.76),(-88.79,-26.44,10.02),(-89.05,-26.91,9.781),(-84.5,-28.11,12.53),(-83.33,-28.24,13.1),(-83.46,-28.02,12.58),(-84.62,-28.78,12.95),(-83.18,-28.5,12.61),(-84.06,-29.01,12.11),(-84.88,-29.48,11.81),(-84.4,-28.54,11.44),(-84.04,-28.35,11.68),(-83.27,-28.28,12.15),(-95.74,-55.5,19.58),(-94.29,-52.0,23.48),(-96.53,-51.42,22.67),(-86.62,-34.24,29.76),(-89.12,-31.08,29.49),(-99.32,-35.71,31.71),(-95.91,-30.24,30.51),(-92.66,-29.87,30.31),(-98.46,-38.83,32.3),(-91.6,-39.06,20.35),(-94.57,-40.08,22.63),(-89.25,-36.88,21.75),(-87.9,-35.22,25.63),(-98.61,-39.37,26.92),(-89.78,-9.36,13.45),(-90.57,-13.85,15.25),(-93.55,-9.585,17.21),(-91.64,-13.74,18.16),(-90.58,-13.3,21.76),(-92.22,-9.09,20.49),(-88.79,-8.438,21.58),(-88.64,-13.76,13.49),(-88.65,-12.95,22.99),(-85.81,-12.68,22.01),(-85.99,-8.407,17.13),(-84.52,-12.88,17.97),(-85.79,-13.3,14.75),(-88.49,-17.78,13.83),(-88.48,-16.75,24.57),(-85.75,-17.87,22.92),(-84.31,-18.72,18.86),(-85.73,-18.53,16.35),(-89.91,-26.56,14.62),(-93.4,-25.24,16.12),(-94.42,-22.77,19.56),(-93.78,-22.13,24.48),(-89.84,-24.13,27.15),(-86.63,-25.35,25.31),(-85.36,-26.6,21.16),(-87.05,-27.03,17.38),(-92.57,-35.52,17.81),(-95.92,-31.13,16.57),(-96.04,-27.72,20.71),(-96.35,-29.57,29.63),(-94.14,-27.48,28.53),(-96.13,-37.33,19.54),(-96.25,-34.27,17.69),(-100.3,-34.7,21.95),(-99.46,-36.39,22.87),(-100.5,-36.99,30.11),(-101.0,-35.12,29.0),(-99.45,-33.87,31.32),(-97.96,-33.13,32.19),(-100.6,-32.89,22.65),(-99.44,-29.9,23.82),(-100.9,-32.25,28.51),(-97.44,-29.41,26.98),(-99.03,-31.51,30.76),(-96.42,-31.55,32.75),(-90.92,-3.699,11.62),(-92.87,-3.673,12.88),(-93.79,-3.579,16.24),(-92.9,-3.143,19.46),(-90.96,-2.965,20.64),(-88.96,-2.752,19.32),(-88.21,-2.964,16.36),(-89.02,-3.385,12.96),(-92.65,3.035,11.4),(-94.33,2.882,12.25),(-95.08,2.976,14.97),(-94.34,3.296,17.6),(-92.67,3.613,18.69),(-90.86,3.746,17.47),(-90.22,3.432,15.1),(-90.92,3.231,12.37),(-92.95,8.443,11.73),(-94.44,7.918,11.93),(-95.1,7.877,14.07),(-94.45,8.212,15.37),(-92.75,8.823,15.86),(-91.33,9.237,15.02),(-90.86,9.262,13.26),(-91.32,8.947,11.99),(-89.58,10.19,11.07),(-88.84,10.73,12.71),(-86.27,12.0,11.48),(-88.83,11.73,10.43),(-89.49,10.53,14.47),(-88.61,12.06,14.79),(-86.11,12.19,13.56),(-91.49,10.39,16.05),(-95.64,9.397,16.45),(-95.78,10.36,15.77),(-94.14,10.52,16.56),(-96.29,9.121,13.83),(-96.37,10.11,13.6),(-95.93,8.866,11.45),(-96.01,10.01,11.35),(-91.62,9.509,10.73),(-94.33,10.02,10.6),(-88.87,12.41,10.39),(-85.84,12.95,12.4),(-88.88,12.78,14.37),(-95.55,8.221,12.41),(-95.46,8.519,15.84),(-95.97,12.13,13.65),(-95.99,12.03,12.56),(-95.33,12.18,13.59),(-95.35,12.08,12.49),(-95.2,-29.88,29.08),(-91.91,-30.08,28.61),(-90.27,-37.38,42.06),(-93.44,-38.65,41.08),(-88.19,-35.53,39.19),(-87.36,-34.54,34.44),(-97.95,-38.54,37.7),(-88.82,-7.621,35.38),(-89.8,-12.25,35.34),(-92.98,-8.308,32.84),(-91.21,-12.57,32.8),(-90.6,-12.74,28.92),(-92.06,-8.403,29.18),(-88.83,-8.069,27.02),(-87.69,-11.95,36.49),(-88.85,-12.65,27.12),(-85.94,-12.31,27.23),(-85.54,-7.423,30.54),(-84.19,-11.91,30.84),(-85.05,-11.79,34.4),(-87.45,-15.82,37.94),(-88.76,-16.5,27.29),(-85.82,-17.35,28.67),(-83.89,-17.53,32.53),(-85.0,-16.95,35.19),(-88.5,-24.38,41.5),(-92.18,-23.33,40.36),(-93.71,-21.49,36.25),(-93.7,-21.64,31.14),(-90.01,-23.98,28.85),(-86.62,-25.09,30.25),(-84.78,-25.45,34.16),(-85.98,-25.27,38.37),(-91.27,-33.21,43.28),(-94.41,-29.08,43.21),(-96.69,-26.89,37.76),(-94.23,-27.43,29.87),(-94.68,-35.51,43.21),(-95.14,-32.5,43.52),(-99.11,-33.24,40.78),(-98.39,-35.03,40.45),(-100.2,-36.68,34.07),(-100.7,-34.7,34.45),(-98.11,-33.31,29.79),(-99.53,-31.59,39.4),(-99.66,-29.96,36.44),(-100.6,-31.86,33.64),(-98.07,-29.77,32.81),(-99.01,-31.48,31.05),(-96.7,-31.9,28.18),(-89.76,-1.852,34.74),(-91.84,-1.959,34.0),(-93.14,-2.371,31.0),(-92.65,-2.498,27.53),(-90.88,-2.586,25.86),(-88.75,-2.244,26.53),(-87.66,-2.002,29.26),(-88.05,-1.834,32.86),(-91.48,4.714,32.21),(-93.23,4.492,31.87),(-94.3,4.178,29.44),(-93.88,4.041,26.62),(-92.37,4.111,25.04),(-90.44,4.368,25.7),(-89.52,4.419,27.93),(-89.89,4.687,30.78),(-91.91,9.84,29.43),(-93.34,9.397,29.86),(-94.26,9.026,27.83),(-93.76,9.131,26.46),(-92.07,9.536,25.28),(-90.63,9.962,25.58),(-89.95,10.24,27.23),(-90.25,10.17,28.59),(-88.56,11.62,28.64),(-87.98,11.88,26.68),(-85.35,13.26,26.81),(-87.79,13.19,28.41),(-88.78,11.42,25.22),(-87.97,12.83,24.06),(-85.39,13.11,24.71),(-90.9,11.07,24.15),(-95.03,10.12,24.99),(-95.13,11.15,25.23),(-93.57,11.15,24.1),(-95.44,10.28,27.74),(-95.51,11.26,27.52),(-94.82,10.46,30.01),(-94.95,11.5,29.65),(-90.54,11.05,29.65),(-93.22,11.61,30.05),(-87.85,13.89,28.15),(-85.03,13.99,25.43),(-88.21,13.63,24.17),(-94.56,9.64,29.34),(-94.76,9.382,25.91),(-95.18,13.32,26.46),(-95.1,13.4,27.55),(-94.54,13.36,26.38),(-94.46,13.44,27.47),(-89.49,-64.65,37.0),(-93.81,-63.71,43.6),(-96.58,-69.74,39.13),(-90.8,-58.53,35.81),(-89.87,-64.62,38.26),(-90.74,-65.05,42.59),(-91.88,-64.29,43.09),(-90.13,-67.51,37.75),(-92.11,-69.09,38.36),(-95.07,-69.63,38.9),(-88.3,-62.31,36.3),(-88.96,-60.4,35.97),(-89.11,-59.26,35.74),(-97.04,-62.69,42.13),(-96.35,-64.68,43.62),(-101.8,-66.11,39.05),(-101.1,-67.94,39.37),(-98.21,-69.64,39.34),(-99.35,-61.74,37.73),(-96.86,-60.16,37.03),(-94.4,-59.5,36.53),(-94.24,-64.5,44.0),(-96.66,-68.12,43.71),(-96.62,-69.27,41.89),(-91.62,-59.27,39.74),(-92.19,-60.11,41.33),(-93.2,-62.13,43.06),(-91.09,-67.84,40.43),(-92.29,-65.79,43.25),(-94.78,-68.85,41.95),(-88.59,-62.31,37.18),(-89.95,-59.62,38.01),(-91.07,-62.01,41.71),(-100.7,-66.89,42.45),(-99.48,-68.52,42.83),(-97.96,-66.85,44.53),(-94.81,-62.43,42.74),(-93.66,-59.82,40.35),(-93.51,-69.48,38.64),(-89.56,-66.17,37.34),(-89.29,-64.15,36.86),(-89.17,-63.84,36.77),(-88.75,-63.14,36.56),(-89.5,-62.98,37.42),(-89.7,-63.54,37.4),(-88.29,-62.55,36.36),(-88.69,-62.09,36.31),(-89.06,-61.93,36.33),(-88.57,-61.46,36.15),(-89.36,-61.84,37.52),(-89.02,-61.24,37.92),(-90.02,-63.43,37.78),(-89.71,-62.16,38.05),(-90.07,-60.75,39.34),(-90.8,-60.15,40.02),(-89.85,-58.59,37.12),(-89.0,-60.94,36.1),(-89.37,-60.18,35.98),(-89.27,-59.63,35.84),(-89.41,-58.77,35.67),(-92.99,-58.9,36.2),(-89.64,-60.34,37.77),(-88.56,-61.27,36.11),(-88.79,-60.67,36.01),(-89.17,-60.8,37.94),(-88.79,-61.46,36.98),(-89.56,-62.14,39.8),(-89.16,-62.61,37.5),(-88.5,-62.73,36.97),(-89.25,-60.49,37.78),(-89.82,-65.07,41.13),(-90.27,-64.19,37.87),(-91.44,-63.59,42.74),(-89.71,-65.62,41.07),(-90.08,-63.92,39.21),(-89.83,-64.02,37.47),(-90.26,-64.35,41.41),(-90.6,-64.56,42.47),(-90.28,-64.7,39.12),(-89.49,-65.1,39.35),(-91.67,-67.03,42.35),(-92.44,-68.52,41.37),(-90.4,-61.22,40.59),(-95.36,-60.09,36.8),(-89.32,-65.34,37.13),(-90.09,-59.34,38.42),(-89.87,-64.38,37.54),(-89.29,-64.95,38.14),(-89.32,-65.42,38.67),(-90.93,-63.86,41.57),(-90.07,-63.09,38.97),(-90.86,-63.11,41.56),(-89.34,-61.7,38.24),(-101.8,-62.88,38.33),(-101.1,-64.0,42.09),(-99.9,-68.99,39.43),(-100.3,-61.83,38.69),(-100.9,-62.16,38.82),(-101.5,-61.99,38.08),(-101.8,-61.68,38.06),(-102.8,-61.22,38.1),(-103.6,-60.36,38.01),(-104.2,-58.6,37.7),(-105.9,-56.83,37.55),(-105.6,-55.9,37.3),(-104.8,-53.46,36.63),(-103.7,-52.48,36.23),(-101.6,-52.46,36.0),(-101.4,-54.16,36.31),(-99.81,-56.13,36.54),(-99.33,-58.88,37.08),(-100.6,-60.45,37.62),(-99.93,-60.67,37.57),(-99.63,-60.98,37.6),(-103.7,-55.97,38.12),(-102.0,-57.29,38.19),(-100.4,-61.37,38.55),(-101.9,-55.57,37.49),(-102.6,-53.79,37.2),(-101.9,-58.6,38.16),(-102.0,-59.95,38.29),(-101.1,-60.89,38.65),(-103.6,-54.47,37.42),(-101.9,-60.93,38.62),(-101.4,-61.32,38.65),(-101.0,-61.71,38.69),(-96.8,-62.6,43.14),(-96.67,-62.46,42.95),(-96.44,-62.4,42.73),(-96.29,-62.45,42.62),(-96.06,-62.53,42.46),(-95.92,-62.74,42.44),(-95.86,-62.98,42.62),(-96.99,-63.19,43.54),(-96.75,-63.08,43.29),(-96.53,-63.15,43.13),(-96.54,-63.59,42.9),(-96.35,-63.39,42.65),(-95.94,-63.32,42.72),(-97.39,-63.09,43.83),(-97.19,-63.17,43.7),(-97.16,-63.85,43.54),(-96.33,-63.87,43.06),(-96.19,-63.54,43.0),(-97.62,-63.54,44.22),(-97.22,-64.11,43.71),(-96.74,-64.4,43.43),(-96.35,-64.38,43.44),(-97.66,-64.02,44.47),(-97.45,-64.08,44.32),(-97.13,-64.53,44.25),(-96.91,-64.87,43.78),(-96.73,-64.8,43.6),(-97.58,-64.45,44.59),(-96.87,-65.05,44.1),(-96.58,-65.08,43.87),(-96.48,-64.93,43.54),(-96.19,-64.95,43.69),(-97.41,-64.98,44.68),(-97.29,-65.19,44.68),(-97.07,-65.28,44.53),(-96.83,-65.39,44.38),(-96.53,-65.38,44.12),(-96.28,-65.2,43.83),(-96.73,-62.57,43.37),(-96.6,-62.43,43.18),(-96.37,-62.37,42.96),(-95.99,-62.49,42.7),(-95.89,-62.69,42.68),(-96.92,-63.15,43.77),(-96.68,-63.05,43.52),(-96.45,-63.12,43.36),(-97.32,-63.06,44.06),(-97.22,-63.58,44.21),(-97.15,-64.08,43.94),(-97.54,-63.51,44.45),(-97.59,-63.98,44.7),(-97.38,-64.05,44.56),(-97.06,-64.49,44.48),(-96.84,-64.84,44.01),(-97.5,-64.42,44.82),(-97.04,-64.84,44.61),(-96.79,-65.02,44.33),(-96.5,-65.04,44.1),(-97.34,-64.94,44.91),(-97.22,-65.15,44.91),(-97.0,-65.25,44.76),(-96.76,-65.36,44.61),(-96.46,-65.35,44.36),(-96.2,-65.17,44.06),(-94.63,-64.64,31.51),(-90.03,-64.8,35.89),(-91.43,-65.85,32.21),(-92.65,-65.16,31.72),(-97.43,-63.04,33.31),(-97.05,-65.38,32.61),(-94.88,-65.58,31.6),(-97.3,-68.86,34.08),(-97.01,-69.59,36.02),(-92.08,-59.62,32.75),(-92.84,-60.87,31.65),(-94.0,-63.05,31.16),(-90.97,-68.29,35.14),(-93.32,-66.97,32.23),(-95.2,-69.25,35.56),(-88.7,-62.43,35.55),(-90.22,-59.93,33.96),(-91.73,-62.77,31.8),(-101.2,-67.39,35.89),(-99.95,-69.05,35.89),(-98.74,-67.82,32.95),(-95.53,-63.26,32.04),(-94.17,-60.4,32.85),(-89.6,-63.1,35.87),(-89.78,-63.63,36.19),(-89.51,-62.02,35.24),(-89.25,-61.5,34.51),(-90.15,-63.57,35.87),(-89.91,-62.4,34.97),(-90.48,-61.22,33.24),(-91.29,-60.42,32.62),(-90.05,-58.81,34.12),(-89.87,-60.6,34.43),(-89.41,-61.08,34.33),(-88.9,-61.58,35.43),(-90.01,-62.66,33.2),(-89.29,-62.76,35.54),(-88.57,-62.82,35.92),(-89.48,-60.75,34.37),(-90.35,-65.67,33.36),(-90.39,-64.32,36.18),(-92.19,-64.44,31.62),(-90.22,-66.2,33.63),(-90.38,-64.29,34.8),(-89.9,-64.11,36.37),(-90.82,-65.02,33.02),(-91.29,-65.33,32.19),(-90.54,-65.0,35.22),(-89.78,-65.44,34.96),(-92.37,-67.78,33.72),(-92.85,-68.89,35.32),(-90.94,-61.88,32.56),(-90.41,-59.52,33.58),(-89.94,-64.46,36.47),(-89.44,-65.11,35.99),(-89.52,-65.65,35.7),(-91.63,-64.57,32.86),(-90.36,-63.47,34.75),(-91.48,-63.82,32.38),(-89.59,-62.11,34.52),(-101.5,-64.54,35.04),(-100.4,-61.95,37.12),(-101.0,-62.28,37.31),(-103.7,-57.37,36.63),(-102.4,-58.59,36.73),(-100.5,-61.49,37.08),(-101.6,-56.28,35.82),(-102.6,-53.89,35.63),(-102.1,-59.84,37.12),(-101.2,-60.98,37.08),(-104.1,-55.19,36.0),(-102.0,-61.04,37.22),(-101.5,-61.43,37.24),(-101.1,-61.82,37.26),(-97.54,-63.44,32.28),(-97.39,-63.28,32.36),(-97.13,-63.19,32.48),(-96.96,-63.23,32.56),(-96.72,-63.28,32.68),(-96.61,-63.47,32.76),(-96.55,-63.75,32.81),(-97.76,-64.06,32.21),(-97.49,-63.93,32.33),(-97.24,-63.98,32.45),(-97.21,-64.37,32.86),(-97.0,-64.14,32.96),(-96.63,-64.09,32.69),(-98.18,-64.0,32.0),(-97.97,-64.07,32.11),(-97.91,-64.7,32.54),(-97.03,-64.65,32.79),(-96.88,-64.35,32.63),(-98.45,-64.49,31.89),(-97.97,-64.97,32.52),(-97.46,-65.22,32.77),(-98.5,-64.99,31.88),(-98.28,-65.04,31.98),(-97.95,-65.46,32.16),(-97.66,-65.73,32.69),(-97.46,-65.63,32.78),(-98.43,-65.43,31.93),(-97.65,-65.95,32.45),(-97.33,-65.95,32.61),(-97.17,-65.75,32.92),(-96.86,-65.85,32.57),(-98.26,-65.95,32.02),(-98.14,-66.16,32.09),(-97.9,-66.23,32.2),(-97.65,-66.33,32.33),(-97.32,-66.28,32.48),(-97.03,-66.07,32.62),(-97.53,-63.4,32.02),(-97.35,-63.28,32.11),(-97.09,-63.2,32.23),(-96.68,-63.29,32.43),(-96.57,-63.48,32.5),(-96.51,-63.76,32.55),(-97.72,-64.07,31.95),(-97.45,-63.93,32.08),(-97.2,-63.98,32.2),(-98.14,-64.01,31.75),(-98.06,-64.53,31.8),(-98.4,-64.5,31.63),(-98.24,-65.04,31.73),(-98.46,-64.99,31.62),(-97.9,-65.46,31.9),(-97.62,-65.73,32.44),(-98.39,-65.44,31.67),(-97.89,-65.82,31.92),(-97.61,-65.96,32.2),(-97.29,-65.95,32.35),(-97.12,-65.75,32.62),(-98.22,-65.96,31.77),(-98.1,-66.17,31.83),(-97.86,-66.24,31.95),(-97.6,-66.33,32.07),(-97.28,-66.28,32.23),(-96.99,-66.07,32.36),(-92.7,-61.07,42.39),(-93.36,-61.81,31.16),(-93.17,-45.91,45.24),(-94.14,-47.78,22.17),(-83.99,-38.71,30.44),(-74.13,-34.77,28.61),(-75.14,-42.24,31.1),(-83.97,-35.65,30.0),(-84.36,-38.07,35.64),(-82.21,-37.1,39.09),(-79.22,-37.78,38.73),(-79.6,-35.77,39.2),(-75.81,-41.48,37.55),(-76.65,-35.26,37.2),(-75.16,-34.77,34.2),(-82.03,-35.96,36.36),(-75.84,-42.57,24.76),(-84.4,-38.98,24.86),(-82.24,-38.59,21.67),(-79.3,-39.28,21.78),(-80.22,-37.28,20.31),(-77.16,-36.53,21.16),(-75.49,-35.68,23.68),(-82.47,-37.07,23.47),(-81.41,-49.27,23.15),(-86.7,-48.38,22.32),(-83.77,-47.01,21.33),(-84.79,-46.61,21.15),(-85.47,-51.99,25.35),(-88.79,-53.33,34.61),(-86.4,-41.94,31.57),(-88.78,-46.55,32.84),(-76.41,-46.52,32.75),(-78.92,-48.98,32.26),(-74.01,-46.89,26.42),(-75.2,-48.15,30.27),(-75.54,-48.15,23.76),(-77.74,-49.27,26.39),(-74.53,-44.3,26.17),(-89.13,-55.66,35.43),(-86.61,-41.46,37.55),(-89.15,-49.64,39.29),(-85.1,-40.88,41.61),(-79.23,-44.46,43.79),(-79.34,-41.29,40.65),(-73.98,-45.9,38.11),(-75.49,-46.66,41.3),(-74.94,-47.04,38.45),(-75.18,-47.74,35.08),(-78.87,-48.81,34.27),(-78.44,-47.1,41.58),(-76.78,-45.44,43.25),(-75.61,-43.83,41.28),(-74.5,-43.37,37.07),(-77.38,-43.05,43.41),(-76.67,-42.11,41.71),(-74.92,-42.42,38.33),(-83.65,-44.87,43.94),(-85.65,-44.3,43.83),(-87.2,-52.34,38.4),(-85.4,-47.1,45.59),(-82.49,-52.15,38.37),(-87.05,-54.68,38.13),(-84.22,-50.41,46.09),(-84.14,-51.01,42.6),(-83.57,-51.55,34.18),(-79.9,-51.4,37.42),(-77.79,-49.74,35.21),(-81.92,-49.87,33.84),(-80.93,-50.53,32.06),(-85.51,-51.77,35.98),(-84.24,-53.92,34.66),(-86.27,-54.44,37.14),(-85.55,-52.16,32.48),(-86.12,-54.76,32.92),(-82.63,-51.45,30.56),(-74.95,-43.61,24.39),(-76.85,-47.32,21.17),(-75.25,-45.37,22.19),(-87.25,-52.89,30.08),(-86.95,-55.24,31.64),(-85.75,-51.68,21.58),(-86.63,-42.54,24.95),(-85.11,-52.22,27.79),(-85.11,-42.59,21.61),(-77.63,-45.88,19.69),(-79.4,-42.92,21.53),(-76.14,-44.24,19.32),(-76.72,-43.89,20.85),(-84.83,-46.68,20.62),(-73.95,-45.75,26.33),(-73.92,-44.78,37.63),(-74.58,-47.67,32.71),(-86.14,-52.09,29.19),(-85.65,-44.35,43.28),(-84.84,-46.65,20.6),(-79.51,-49.56,41.4),(-79.97,-50.82,24.91),(-85.35,-52.45,25.15),(-84.16,-51.51,42.9),(-88.1,-51.57,38.84),(-88.04,-52.19,28.72),(-88.28,-54.5,32.77),(-88.23,-55.56,31.96),(-88.5,-53.07,32.49),(-88.31,-54.32,36.75),(-88.02,-54.97,38.18),(-88.45,-52.8,36.34),(-88.92,-54.99,35.21),(-80.5,-49.02,48.06),(-82.18,-47.19,48.71),(-84.24,-45.02,49.18),(-78.51,-46.21,48.9),(-77.24,-45.34,45.51),(-78.52,-48.38,46.47),(-76.56,-36.65,42.26),(-73.34,-37.29,44.49),(-74.54,-37.83,47.64),(-76.66,-37.53,48.42),(-79.99,-40.13,46.55),(-74.07,-34.72,42.09),(-75.7,-33.71,43.59),(-77.6,-34.98,45.66),(-69.4,-34.92,43.06),(-70.42,-33.81,40.93),(-63.65,-28.86,38.77),(-62.83,-29.91,40.25),(-71.14,-32.7,42.25),(-63.86,-27.35,41.09),(-71.94,-31.49,45.16),(-73.22,-31.91,44.17),(-75.79,-33.36,45.16),(-74.66,-33.96,47.3),(-63.1,-28.0,42.64),(-70.8,-32.62,46.64),(-62.57,-29.04,42.4),(-69.88,-33.82,46.29),(-73.34,-34.79,47.78),(-72.7,-35.95,47.03),(-60.0,-29.17,38.48),(-59.28,-29.16,39.06),(-59.81,-27.05,39.34),(-61.14,-29.62,38.75),(-60.63,-30.28,39.84),(-60.91,-25.57,39.91),(-57.1,-28.01,36.62),(-58.0,-27.97,38.72),(-57.37,-28.27,38.93),(-57.14,-27.9,35.12),(-57.8,-27.72,35.44),(-57.47,-27.3,36.33),(-57.51,-27.49,35.07),(-57.69,-27.83,36.65),(-57.47,-27.14,34.55),(-58.1,-26.98,34.92),(-58.06,-26.6,36.23),(-58.11,-27.0,36.36),(-57.85,-26.65,34.71),(-58.24,-26.64,34.97),(-58.8,-26.48,35.36),(-58.64,-26.06,36.36),(-58.76,-26.44,36.53),(-58.62,-26.17,35.01),(-59.0,-26.08,38.64),(-59.14,-26.51,38.37),(-59.77,-25.86,38.36),(-59.15,-26.09,37.49),(-59.23,-26.16,36.25),(-59.72,-26.02,36.27),(-59.6,-25.56,37.41),(-59.7,-25.9,37.47),(-59.56,-25.74,36.06),(-59.95,-25.43,38.85),(-59.39,-29.21,40.2),(-58.51,-28.3,41.14),(-59.21,-27.38,41.23),(-60.24,-26.27,40.55),(-57.08,-27.65,37.02),(-57.08,-27.64,36.12),(-57.4,-27.78,39.74),(-57.11,-27.69,38.3),(-57.76,-27.4,38.76),(-57.75,-26.92,39.33),(-57.53,-26.86,38.01),(-57.48,-26.86,36.63),(-57.45,-26.89,35.87),(-58.35,-26.68,38.62),(-58.48,-26.33,39.27),(-58.26,-26.26,38.3),(-58.15,-26.27,36.2),(-58.16,-26.29,36.9),(-59.11,-25.75,37.83),(-59.07,-25.78,37.25),(-59.19,-25.72,38.88),(-59.53,-25.79,39.62),(-58.62,-29.78,36.92),(-58.19,-30.68,36.21),(-57.93,-30.41,36.52),(-59.33,-30.16,37.13),(-58.12,-30.89,36.8),(-58.87,-30.58,37.88),(-59.62,-30.32,38.75),(-58.51,-30.0,38.18),(-58.23,-30.15,37.72),(-57.86,-30.65,37.04),(-80.66,-47.56,48.66),(-82.92,-50.73,18.87),(-84.51,-50.19,18.6),(-85.12,-47.96,17.31),(-82.36,-48.51,15.66),(-80.97,-46.49,17.28),(-80.83,-49.82,19.68),(-86.16,-38.59,18.52),(-83.88,-38.03,14.52),(-84.94,-39.72,12.62),(-86.83,-40.63,13.31),(-86.97,-43.39,17.68),(-86.03,-36.06,16.77),(-88.21,-36.55,16.42),(-88.84,-38.63,15.94),(-83.17,-33.87,12.78),(-84.37,-33.21,15.22),(-84.59,-25.66,11.91),(-83.39,-26.18,10.17),(-86.03,-33.17,14.43),(-86.54,-25.51,9.868),(-88.13,-33.48,12.27),(-88.35,-34.21,14.05),(-88.86,-36.71,15.05),(-88.04,-37.03,12.48),(-85.76,-25.86,8.069),(-86.72,-33.94,10.32),(-84.44,-26.08,8.016),(-85.03,-34.15,10.14),(-86.59,-37.01,11.27),(-85.05,-37.3,11.65),(-82.86,-23.0,9.133),(-82.7,-22.68,8.073),(-85.22,-22.51,8.156),(-82.71,-24.03,9.884),(-81.9,-24.2,8.645),(-87.23,-23.02,8.391),(-83.27,-20.14,8.058),(-83.67,-21.35,7.217),(-83.18,-21.12,6.548),(-83.32,-19.7,9.372),(-83.73,-20.19,9.546),(-84.15,-20.1,8.48),(-83.88,-19.82,9.632),(-83.65,-20.51,8.451),(-84.23,-19.53,9.993),(-84.62,-20.02,10.11),(-85.11,-20.27,8.897),(-84.68,-20.46,8.874),(-84.9,-19.68,10.06),(-85.05,-20.03,10.12),(-85.42,-20.48,10.17),(-85.9,-20.54,9.133),(-85.52,-20.79,9.13),(-85.69,-20.16,10.29),(-86.08,-21.45,7.844),(-85.61,-21.52,8.266),(-86.51,-21.76,8.752),(-86.07,-21.22,8.596),(-85.96,-20.94,9.674),(-86.26,-21.24,9.992),(-86.8,-21.34,8.932),(-86.45,-21.51,9.046),(-86.51,-20.99,10.01),(-87.07,-21.99,8.461),(-82.79,-23.14,7.305),(-83.6,-22.54,5.758),(-84.83,-22.8,6.135),(-86.31,-22.97,7.401),(-83.69,-20.14,7.65),(-83.64,-19.87,8.424),(-83.79,-21.32,5.849),(-83.73,-20.58,6.574),(-84.26,-21.07,6.878),(-84.84,-21.14,6.333),(-84.77,-20.52,7.015),(-84.67,-20.07,8.162),(-84.58,-19.83,8.807),(-85.22,-21.21,7.374),(-85.69,-21.45,6.935),(-85.67,-20.94,7.272),(-85.51,-20.22,8.941),(-85.53,-20.44,8.347),(-86.47,-21.17,8.285),(-86.39,-21.01,8.663),(-86.56,-21.56,7.781),(-86.6,-22.07,7.537),(-81.67,-21.79,9.577),(-80.48,-21.56,9.943),(-80.74,-21.39,9.463),(-81.47,-22.46,9.965),(-80.28,-21.75,9.413),(-80.92,-22.5,9.026),(-81.5,-23.19,8.819),(-81.49,-22.16,8.444),(-81.21,-21.88,8.641),(-80.49,-21.58,8.988),(-82.7,-50.15,17.51),(-83.77,-47.01,21.31),(-84.8,-46.62,21.13),(-72.59,-30.62,27.5),(-74.6,-26.62,27.09),(-85.43,-30.16,29.1),(-80.91,-25.29,27.91),(-77.63,-25.41,27.8),(-85.24,-33.35,29.77),(-78.38,-34.7,18.03),(-81.55,-35.24,20.24),(-75.63,-32.9,19.46),(-74.01,-31.43,23.35),(-85.43,-33.9,24.39),(-76.54,-6.28,11.52),(-74.97,-10.53,13.01),(-79.62,-8.024,15.45),(-75.91,-10.84,15.97),(-75.04,-10.13,19.55),(-78.59,-7.106,18.7),(-75.88,-5.194,19.66),(-73.29,-9.771,11.18),(-73.4,-9.171,20.72),(-70.94,-7.962,19.64),(-73.57,-4.007,15.07),(-69.77,-7.674,15.54),(-70.84,-8.439,12.35),(-72.34,-13.36,11.36),(-72.48,-12.34,22.09),(-69.74,-13.47,20.53),(-68.27,-14.38,16.53),(-69.64,-14.16,13.97),(-74.6,-21.99,12.19),(-77.92,-20.36,13.57),(-78.69,-17.81,16.93),(-78.06,-17.21,21.86),(-74.41,-19.5,24.69),(-71.33,-21.0,22.97),(-70.16,-22.39,18.87),(-71.85,-22.7,15.04),(-78.58,-30.71,15.31),(-81.26,-26.01,14.05),(-80.93,-22.58,18.14),(-81.58,-24.43,27.11),(-79.1,-22.49,26.0),(-82.47,-32.33,17.05),(-82.07,-29.11,15.18),(-86.01,-29.1,19.3),(-85.59,-30.87,20.27),(-86.78,-31.26,27.49),(-86.92,-29.35,26.33),(-85.16,-28.33,28.67),(-83.55,-27.82,29.57),(-85.94,-27.27,19.96),(-84.65,-24.45,21.27),(-86.2,-26.55,25.79),(-82.62,-24.15,24.45),(-84.24,-26.07,28.08),(-81.71,-26.49,30.15),(-80.87,-1.673,10.21),(-82.55,-2.464,11.58),(-83.27,-2.804,14.99),(-82.61,-2.102,18.19),(-80.96,-1.172,19.28),(-79.39,-0.151,17.87),(-78.72,0.008978,14.85),(-79.33,-0.6435,11.48),(-86.31,3.595,10.64),(-87.67,2.775,11.57),(-88.28,2.521,14.33),(-87.7,3.066,16.94),(-86.36,4.001,17.96),(-84.9,4.858,16.65),(-84.25,4.875,14.23),(-84.86,4.451,11.52),(-89.11,8.158,11.37),(-90.33,7.269,11.6),(-90.89,7.018,13.77),(-90.37,7.515,15.05),(-88.96,8.537,15.5),(-87.79,9.307,14.63),(-87.38,9.47,12.86),(-87.73,9.062,11.59),(-86.01,10.16,10.67),(-85.3,10.81,12.3),(-83.01,12.42,11.02),(-85.51,11.81,10.04),(-85.93,10.48,14.08),(-85.3,12.14,14.4),(-82.87,12.61,13.11),(-87.88,10.09,15.7),(-91.81,8.501,16.2),(-92.14,9.481,15.54),(-90.52,9.878,16.28),(-92.43,8.106,13.6),(-92.7,9.16,13.37),(-92.1,7.784,11.21),(-92.35,9.139,11.11),(-87.93,9.237,10.37),(-90.69,9.406,10.32),(-85.69,12.54,10.01),(-82.72,13.31,11.98),(-85.7,12.88,14.0),(-91.48,7.263,12.13),(-91.43,7.541,15.57),(-92.69,11.62,13.4),(-92.71,11.53,12.31),(-92.06,11.72,13.32),(-92.08,11.63,12.23),(-80.48,-24.84,26.58),(-77.24,-25.34,26.16),(-77.0,-33.08,39.74),(-80.37,-33.86,38.69),(-74.52,-31.59,36.91),(-73.45,-30.77,32.16),(-84.74,-33.09,35.17),(-80.38,-4.077,33.85),(-78.84,-8.558,33.49),(-83.79,-6.28,31.47),(-80.03,-9.321,30.99),(-79.53,-9.192,27.08),(-83.06,-5.948,27.76),(-80.45,-4.349,25.46),(-77.05,-7.542,34.56),(-78.05,-8.451,25.21),(-75.57,-7.12,25.21),(-77.75,-2.547,28.87),(-74.05,-6.195,28.77),(-74.79,-6.433,32.37),(-75.6,-10.9,35.78),(-76.79,-11.72,25.13),(-73.73,-12.15,26.48),(-71.78,-12.12,30.35),(-72.98,-11.69,33.02),(-75.58,-19.51,39.29),(-79.33,-18.8,37.96),(-80.98,-17.1,33.82),(-80.86,-17.25,28.73),(-76.83,-19.23,26.57),(-73.35,-20.03,28.12),(-71.56,-20.23,32.13),(-72.88,-20.17,36.3),(-77.12,-28.81,40.86),(-81.09,-24.7,40.54),(-81.06,-21.82,35.07),(-80.51,-23.08,27.3),(-80.96,-30.56,40.73),(-80.78,-27.53,40.98),(-84.81,-27.69,38.13),(-84.47,-29.56,37.86),(-86.53,-30.96,31.46),(-86.57,-28.94,31.78),(-83.71,-27.99,27.18),(-84.87,-26.01,36.72),(-84.61,-24.41,33.72),(-85.88,-26.16,30.92),(-82.96,-24.49,30.13),(-84.22,-26.05,28.38),(-82.0,-26.83,25.59),(-84.51,0.7365,33.72),(-86.31,-0.1675,33.09),(-87.35,-1.006,30.13),(-86.98,-0.8724,26.63),(-85.43,-0.2253,24.86),(-83.72,0.9115,25.44),(-82.78,1.519,28.12),(-83.08,1.457,31.76),(-89.75,5.968,31.8),(-91.21,5.109,31.55),(-92.09,4.457,29.15),(-91.75,4.527,26.31),(-90.49,5.182,24.64),(-88.89,6.133,25.22),(-88.01,6.506,27.4),(-88.37,6.566,30.29),(-92.11,10.05,29.4),(-93.51,9.587,29.82),(-94.35,9.053,27.82),(-93.9,9.279,26.43),(-92.26,9.737,25.26),(-90.83,10.12,25.57),(-90.15,10.38,27.22),(-90.47,10.32,28.58),(-88.7,11.73,28.63),(-88.04,12.0,26.66),(-85.37,13.35,26.8),(-87.82,13.32,28.39),(-88.91,11.52,25.21),(-88.0,12.96,24.03),(-85.41,13.2,24.69),(-91.06,11.23,24.12),(-95.24,10.26,24.95),(-95.32,11.36,25.17),(-93.73,11.37,24.04),(-95.67,10.35,27.71),(-95.72,11.46,27.46),(-95.06,10.59,29.97),(-95.15,11.72,29.59),(-90.73,11.21,29.63),(-93.39,11.83,30.0),(-87.86,14.08,28.1),(-85.01,13.97,25.43),(-88.22,13.83,24.12),(-94.75,9.681,29.32),(-94.94,9.412,25.89),(-95.21,13.98,26.29),(-95.13,14.06,27.39),(-94.57,13.98,26.23),(-94.49,14.06,27.32),(-81.86,-60.07,35.18),(-86.0,-58.44,41.64),(-89.93,-64.0,37.2),(-81.86,-53.86,33.85),(-82.25,-59.97,36.43),(-83.24,-60.23,40.75),(-84.22,-59.3,41.2),(-83.09,-62.78,35.96),(-85.38,-64.03,36.54),(-88.41,-64.12,37.0),(-80.19,-57.95,34.48),(-80.44,-55.97,34.1),(-80.35,-54.83,33.84),(-88.95,-56.96,40.06),(-88.7,-59.02,41.6),(-94.29,-59.65,36.9),(-94.01,-61.55,37.27),(-91.51,-63.65,37.36),(-90.96,-55.72,35.57),(-88.18,-54.55,34.91),(-85.61,-54.26,34.48),(-86.59,-59.15,42.04),(-89.72,-62.35,41.74),(-89.9,-63.51,39.95),(-82.87,-54.44,37.77),(-83.62,-55.16,39.35),(-85.06,-56.98,41.09),(-84.15,-62.94,38.62),(-84.93,-60.72,41.37),(-88.0,-63.37,40.05),(-80.49,-57.9,35.35),(-81.27,-55.04,36.09),(-82.92,-57.19,39.8),(-93.47,-60.54,40.34),(-92.57,-62.33,40.78),(-90.75,-60.9,42.5),(-86.7,-57.04,40.73),(-85.0,-54.66,38.32),(-86.84,-64.21,36.79),(-82.25,-61.55,35.55),(-81.56,-59.6,35.04),(-81.37,-59.32,34.95),(-80.81,-58.7,34.73),(-81.52,-58.42,35.57),(-81.84,-58.94,35.56),(-80.23,-58.18,34.54),(-80.53,-57.67,34.47),(-80.86,-57.46,34.47),(-80.28,-57.07,34.31),(-81.15,-57.32,35.66),(-80.7,-56.77,36.06),(-82.13,-58.78,35.92),(-81.57,-57.58,36.19),(-81.64,-56.12,37.43),(-82.25,-55.42,38.09),(-80.95,-54.05,35.19),(-80.59,-56.49,34.23),(-80.8,-55.69,34.09),(-80.58,-55.17,33.94),(-80.53,-54.31,33.75),(-84.1,-53.89,34.18),(-81.12,-55.8,35.87),(-80.22,-56.89,34.26),(-80.32,-56.27,34.14),(-80.75,-56.32,36.07),(-80.51,-57.03,35.13),(-81.44,-57.56,37.93),(-81.11,-58.1,35.66),(-80.49,-58.33,35.14),(-80.77,-56.0,35.9),(-82.33,-60.4,39.31),(-82.55,-59.49,36.02),(-83.63,-58.68,40.85),(-82.34,-60.96,39.26),(-82.31,-59.25,37.36),(-82.07,-59.39,35.63),(-82.61,-59.62,39.57),(-83.0,-59.77,40.62),(-82.67,-59.98,37.28),(-81.98,-60.49,37.54),(-84.57,-62.04,40.51),(-85.63,-63.4,39.54),(-82.09,-56.53,38.68),(-86.68,-54.7,34.73),(-81.84,-60.77,35.33),(-81.36,-54.74,36.49),(-82.19,-59.74,35.71),(-81.74,-60.38,36.33),(-81.87,-60.84,36.87),(-83.17,-59.04,39.69),(-82.13,-58.43,37.11),(-82.95,-58.31,39.67),(-81.11,-57.18,36.37),(-93.62,-56.48,36.12),(-93.17,-57.65,39.93),(-93.04,-62.76,37.39),(-91.95,-55.66,36.51),(-92.64,-55.89,36.63),(-93.11,-55.64,35.87),(-93.39,-55.29,35.83),(-94.26,-54.69,35.83),(-94.84,-53.73,35.71),(-95.06,-51.9,35.35),(-96.39,-49.91,35.12),(-95.88,-49.05,34.86),(-94.55,-46.77,34.17),(-93.28,-45.97,33.79),(-91.21,-46.26,33.62),(-91.36,-47.97,33.97),(-90.23,-50.14,34.27),(-90.34,-52.91,34.88),(-91.95,-54.27,35.4),(-91.31,-54.58,35.38),(-91.07,-54.94,35.42),(-94.08,-49.38,35.73),(-92.68,-50.93,35.87),(-91.93,-55.2,36.35),(-92.2,-49.27,35.15),(-92.5,-47.42,34.81),(-92.86,-52.24,35.87),(-93.21,-53.55,36.02),(-92.55,-54.61,36.43),(-93.59,-47.94,35.02),(-93.31,-54.53,36.38),(-92.92,-54.99,36.43),(-92.61,-55.43,36.48),(-88.71,-56.91,41.07),(-88.55,-56.79,40.88),(-88.3,-56.77,40.67),(-88.16,-56.84,40.57),(-87.95,-56.95,40.42),(-87.86,-57.18,40.41),(-87.85,-57.43,40.58),(-89.02,-57.45,41.48),(-88.76,-57.39,41.23),(-88.55,-57.49,41.08),(-88.65,-57.92,40.86),(-88.42,-57.75,40.61),(-88.0,-57.74,40.69),(-89.39,-57.29,41.75),(-89.21,-57.41,41.63),(-89.33,-58.08,41.49),(-88.5,-58.23,41.02),(-88.29,-57.92,40.96),(-89.72,-57.7,42.14),(-89.44,-58.32,41.65),(-89.03,-58.68,41.4),(-88.63,-58.73,41.41),(-89.86,-58.16,42.4),(-89.67,-58.26,42.26),(-89.45,-58.74,42.2),(-89.29,-59.12,41.75),(-89.1,-59.07,41.57),(-89.87,-58.6,42.53),(-89.29,-59.3,42.08),(-89.01,-59.37,41.85),(-88.88,-59.24,41.52),(-88.6,-59.3,41.68),(-89.82,-59.14,42.64),(-89.74,-59.37,42.64),(-89.54,-59.49,42.5),(-89.34,-59.64,42.36),(-89.03,-59.67,42.11),(-88.74,-59.54,41.82),(-88.63,-56.88,41.3),(-88.47,-56.76,41.12),(-88.23,-56.74,40.9),(-87.88,-56.92,40.65),(-87.82,-57.13,40.64),(-88.94,-57.43,41.71),(-88.68,-57.36,41.46),(-88.47,-57.47,41.31),(-89.32,-57.27,41.99),(-89.33,-57.79,42.15),(-89.36,-58.3,41.88),(-89.64,-57.68,42.38),(-89.78,-58.14,42.63),(-89.59,-58.23,42.5),(-89.37,-58.72,42.44),(-89.22,-59.09,41.98),(-89.8,-58.58,42.77),(-89.42,-59.06,42.58),(-89.22,-59.28,42.31),(-88.93,-59.35,42.08),(-89.74,-59.12,42.87),(-89.67,-59.34,42.87),(-89.47,-59.47,42.73),(-89.26,-59.62,42.6),(-88.96,-59.65,42.34),(-88.66,-59.51,42.05),(-86.84,-59.33,29.54),(-82.41,-60.14,34.06),(-83.96,-61.0,30.35),(-85.01,-60.14,29.82),(-89.29,-57.32,31.23),(-89.4,-59.69,30.58),(-87.29,-60.22,29.65),(-90.39,-63.07,32.11),(-90.27,-63.81,34.07),(-83.31,-54.76,30.77),(-84.3,-55.89,29.68),(-85.89,-57.86,29.19),(-84.05,-63.44,33.34),(-86.05,-61.81,30.35),(-88.42,-63.75,33.66),(-80.6,-58.02,33.72),(-81.56,-55.34,32.04),(-83.61,-57.92,29.89),(-93.93,-61.02,33.78),(-93.05,-62.84,33.85),(-91.57,-61.84,30.92),(-87.45,-57.83,30.02),(-85.52,-55.21,30.83),(-81.63,-58.54,34.02),(-81.92,-59.03,34.34),(-81.31,-57.49,33.38),(-80.94,-57.03,32.64),(-82.27,-58.92,34.01),(-81.78,-57.81,33.1),(-82.07,-56.57,31.33),(-82.69,-55.67,30.68),(-81.16,-54.26,32.19),(-81.35,-56.05,32.53),(-81.01,-56.58,32.46),(-80.62,-57.15,33.58),(-81.91,-58.06,31.34),(-81.25,-58.25,33.69),(-80.56,-58.41,34.1),(-81.01,-56.25,32.49),(-82.87,-60.97,31.53),(-82.66,-59.61,34.33),(-84.41,-59.5,29.72),(-82.85,-61.51,31.82),(-82.63,-59.6,32.95),(-82.14,-59.47,34.53),(-83.2,-60.26,31.17),(-83.71,-60.51,30.33),(-82.94,-60.27,33.38),(-82.28,-60.82,33.15),(-85.31,-62.74,31.87),(-86.03,-63.75,33.48),(-82.66,-57.16,30.66),(-81.65,-54.91,31.64),(-82.26,-59.82,34.63),(-81.89,-60.54,34.19),(-82.08,-61.06,33.9),(-83.89,-59.71,30.98),(-82.44,-58.79,32.89),(-83.59,-58.99,30.49),(-81.4,-57.57,32.66),(-93.66,-58.18,32.87),(-92.06,-55.77,34.94),(-92.74,-56.0,35.12),(-94.33,-50.77,34.27),(-93.28,-52.17,34.43),(-92.03,-55.31,34.89),(-92.0,-50.03,33.51),(-92.49,-47.52,33.24),(-93.24,-53.45,34.85),(-92.65,-54.7,34.86),(-94.28,-48.58,33.59),(-93.41,-54.64,34.98),(-93.02,-55.1,35.01),(-92.71,-55.54,35.05),(-89.47,-57.71,30.21),(-89.29,-57.57,30.29),(-89.02,-57.53,30.42),(-88.86,-57.59,30.5),(-88.64,-57.67,30.63),(-88.57,-57.87,30.71),(-88.57,-58.16,30.77),(-89.81,-58.29,30.14),(-89.52,-58.2,30.27),(-89.29,-58.28,30.4),(-89.35,-58.67,30.82),(-89.09,-58.47,30.91),(-88.72,-58.48,30.65),(-90.22,-58.17,29.92),(-90.02,-58.27,30.03),(-90.09,-58.89,30.48),(-89.22,-58.97,30.75),(-89.01,-58.7,30.59),(-90.58,-58.61,29.81),(-90.22,-59.15,30.46),(-89.77,-59.47,30.73),(-90.74,-59.09,29.8),(-90.53,-59.17,29.92),(-90.29,-59.64,30.11),(-90.07,-59.94,30.65),(-89.85,-59.87,30.75),(-90.76,-59.54,29.86),(-90.11,-60.17,30.42),(-89.79,-60.2,30.58),(-89.6,-60.03,30.9),(-89.31,-60.18,30.56),(-90.7,-60.08,29.97),(-90.62,-60.3,30.05),(-90.4,-60.4,30.17),(-90.18,-60.53,30.3),(-89.85,-60.53,30.47),(-89.52,-60.37,30.6),(-89.45,-57.67,29.95),(-89.24,-57.58,30.04),(-88.98,-57.54,30.16),(-88.59,-57.68,30.38),(-88.53,-57.89,30.46),(-88.53,-58.17,30.52),(-89.77,-58.3,29.89),(-89.48,-58.21,30.02),(-89.25,-58.29,30.14),(-90.17,-58.18,29.67),(-90.2,-58.71,29.73),(-90.53,-58.63,29.56),(-90.48,-59.18,29.66),(-90.69,-59.1,29.55),(-90.25,-59.65,29.86),(-90.03,-59.95,30.4),(-90.71,-59.55,29.61),(-90.31,-60.0,29.88),(-90.06,-60.18,30.17),(-89.75,-60.22,30.33),(-89.54,-60.04,30.6),(-90.66,-60.09,29.72),(-90.58,-60.31,29.79),(-90.36,-60.42,29.92),(-90.13,-60.54,30.05),(-89.8,-60.55,30.21),(-89.48,-60.38,30.35),(-84.34,-56.02,40.42),(-85.0,-56.74,29.18),(-79.13,-40.46,42.63),(-84.4,-42.51,20.26),(-69.73,-42.34,29.87),(-60.58,-37.31,28.14),(-60.41,-44.82,30.67),(-70.19,-39.3,29.41),(-70.24,-41.73,35.06),(-68.28,-40.52,38.54),(-65.21,-40.86,38.21),(-65.91,-38.9,38.67),(-61.23,-44.14,37.1),(-63.05,-38.07,36.7),(-61.63,-37.42,33.71),(-68.26,-39.38,35.79),(-61.01,-45.24,24.31),(-70.06,-42.66,24.29),(-67.96,-42.02,21.12),(-64.94,-42.38,21.27),(-66.16,-40.5,19.78),(-63.25,-39.41,20.67),(-61.74,-38.37,23.2),(-68.44,-40.54,22.91),(-65.46,-52.51,22.68),(-70.61,-51.92,21.33),(-68.14,-50.55,20.82),(-69.28,-49.85,20.73),(-68.99,-55.11,23.3),(-72.21,-57.36,34.07),(-71.62,-45.81,30.99),(-73.25,-50.64,32.25),(-61.0,-49.2,32.32),(-63.1,-51.93,31.81),(-58.53,-49.31,26.03),(-59.53,-50.69,29.87),(-59.82,-50.74,23.35),(-61.84,-52.1,25.96),(-59.45,-46.8,25.76),(-72.17,-59.71,34.9),(-71.94,-45.35,36.96),(-73.17,-53.73,38.72),(-70.56,-44.6,41.04),(-64.2,-47.48,43.32),(-64.78,-44.35,40.16),(-58.72,-48.31,37.72),(-60.12,-49.23,40.89),(-60.02,-49.94,38.21),(-59.61,-50.27,34.68),(-63.09,-51.76,33.83),(-63.77,-50.16,40.36),(-61.61,-48.17,42.81),(-60.69,-46.44,40.84),(-59.63,-45.86,36.65),(-62.58,-45.87,42.95),(-62.02,-44.86,41.25),(-60.21,-44.97,37.9),(-68.51,-48.38,43.41),(-70.58,-48.04,43.27),(-70.81,-56.19,37.87),(-70.77,-51.23,43.99),(-66.86,-55.62,36.86),(-70.29,-58.5,37.62),(-69.21,-54.43,44.33),(-68.84,-54.9,40.83),(-67.31,-55.0,33.7),(-64.32,-54.62,36.3),(-62.3,-52.78,34.35),(-65.93,-53.16,33.36),(-64.84,-53.69,31.6),(-69.21,-55.44,35.47),(-67.6,-57.43,34.18),(-69.54,-58.17,36.64),(-69.17,-55.84,31.97),(-69.32,-58.48,32.42),(-66.38,-54.8,30.09),(-59.97,-46.17,23.97),(-61.23,-50.07,20.74),(-59.97,-47.95,21.77),(-70.71,-56.76,29.56),(-70.06,-59.05,31.13),(-69.05,-54.61,19.69),(-71.71,-46.44,24.37),(-68.7,-55.88,25.91),(-70.17,-46.32,21.05),(-61.89,-48.53,19.2),(-64.46,-46.0,21.04),(-60.69,-46.77,19.01),(-61.65,-46.65,20.41),(-69.32,-49.93,20.21),(-58.65,-48.17,25.93),(-58.84,-47.2,37.22),(-59.01,-50.14,32.31),(-69.74,-55.84,28.67),(-70.57,-48.09,42.72),(-69.35,-49.91,20.19),(-64.53,-52.69,40.19),(-63.7,-53.42,23.95),(-68.8,-55.53,23.0),(-68.82,-55.41,41.08),(-71.83,-55.54,38.3),(-71.6,-56.15,28.18),(-71.5,-58.47,32.24),(-71.28,-59.51,31.44),(-71.95,-57.07,31.95),(-71.58,-58.29,36.22),(-71.21,-58.89,37.66),(-71.97,-56.79,35.8),(-72.08,-59.02,34.68),(-65.83,-52.77,46.91),(-67.8,-50.42,47.14),(-69.1,-48.59,48.65),(-64.16,-49.47,47.5),(-62.78,-48.57,44.26),(-63.86,-51.88,45.63),(-61.26,-39.94,41.73),(-58.3,-40.98,44.23),(-59.64,-41.35,47.22),(-61.75,-40.88,47.81),(-65.21,-43.25,45.5),(-58.45,-38.59,41.86),(-59.73,-37.21,43.2),(-62.17,-38.19,45.09),(-54.19,-40.02,43.3),(-54.63,-38.72,41.07),(-46.26,-36.09,39.4),(-45.97,-37.28,40.97),(-54.94,-37.45,42.31),(-45.8,-34.56,41.61),(-55.36,-36.05,45.13),(-56.71,-36.11,44.02),(-59.77,-36.84,44.76),(-58.99,-37.67,47.0),(-45.4,-35.37,43.23),(-54.79,-37.4,46.72),(-45.38,-36.5,43.08),(-54.36,-38.8,46.47),(-58.04,-38.78,47.61),(-57.78,-40.05,46.91),(-43.5,-37.79,39.09),(-42.8,-38.05,39.59),(-42.02,-35.97,39.48),(-44.72,-37.7,39.58),(-44.54,-38.43,40.76),(-42.09,-34.2,39.79),(-41.36,-37.98,36.38),(-41.12,-37.55,38.77),(-40.7,-38.06,38.82),(-41.97,-37.89,35.13),(-42.21,-37.45,35.78),(-41.42,-37.22,36.04),(-42.07,-37.38,35.14),(-41.69,-37.58,36.75),(-42.08,-37.1,34.51),(-42.3,-36.69,35.18),(-41.55,-36.37,36.02),(-41.71,-36.69,36.38),(-42.06,-36.52,34.64),(-42.22,-36.34,35.13),(-42.38,-35.96,35.79),(-41.66,-35.65,36.27),(-41.85,-35.92,36.7),(-42.26,-35.77,35.21),(-40.97,-35.49,38.38),(-41.38,-35.81,38.35),(-41.53,-34.99,38.28),(-41.57,-35.45,37.57),(-42.16,-35.49,36.66),(-42.43,-35.16,36.96),(-41.67,-34.8,37.56),(-41.88,-35.05,37.85),(-42.28,-34.99,36.53),(-41.31,-34.53,38.6),(-42.83,-37.98,40.74),(-41.39,-37.49,41.41),(-41.49,-36.39,41.36),(-41.84,-35.04,40.53),(-41.02,-37.67,36.51),(-41.39,-37.69,35.76),(-40.27,-37.59,39.39),(-40.53,-37.68,37.63),(-40.61,-37.15,38.48),(-40.21,-36.71,38.82),(-40.56,-36.79,37.25),(-41.09,-36.83,36.06),(-41.41,-36.88,35.42),(-40.76,-36.28,38.33),(-40.52,-35.9,38.85),(-40.68,-35.96,37.7),(-41.48,-36.04,35.89),(-41.2,-36.05,36.48),(-41.24,-35.16,37.64),(-41.46,-35.21,37.16),(-40.89,-35.08,38.54),(-41.04,-34.97,39.37),(-42.76,-38.97,37.56),(-42.94,-39.97,37.03),(-42.54,-39.82,37.24),(-43.57,-39.0,37.93),(-42.94,-40.14,37.65),(-43.34,-39.51,38.72),(-43.77,-38.93,39.6),(-42.67,-39.14,38.84),(-42.55,-39.4,38.39),(-42.57,-40.03,37.81),(-66.27,-50.77,47.11),(-66.25,-53.2,17.71),(-67.92,-53.02,17.48),(-69.35,-51.29,16.97),(-66.71,-51.09,14.85),(-66.03,-48.75,16.23),(-64.48,-52.0,18.84),(-74.08,-42.84,18.46),(-72.3,-41.79,14.24),(-72.86,-43.59,12.4),(-74.22,-44.99,13.31),(-72.93,-47.55,17.63),(-74.51,-40.69,16.8),(-76.58,-41.42,16.56),(-76.73,-43.61,16.19),(-72.04,-38.33,12.65),(-73.3,-37.75,15.1),(-74.56,-30.28,11.49),(-73.33,-30.69,9.716),(-74.96,-37.89,14.37),(-76.55,-30.37,9.525),(-77.03,-38.43,12.29),(-77.13,-39.16,14.11),(-77.23,-41.69,15.23),(-76.41,-41.93,12.64),(-75.76,-30.65,7.704),(-75.59,-38.78,10.32),(-74.42,-30.73,7.601),(-73.9,-38.82,10.08),(-75.01,-41.77,11.36),(-73.42,-41.86,11.68),(-73.55,-27.27,8.504),(-73.55,-26.92,7.424),(-76.03,-27.3,7.714),(-73.07,-28.27,9.261),(-72.3,-28.26,7.949),(-77.8,-28.23,8.114),(-74.66,-24.96,8.194),(-74.91,-25.84,6.71),(-74.53,-25.48,6.064),(-74.65,-24.97,9.744),(-74.96,-25.5,9.504),(-75.49,-25.19,8.673),(-75.16,-25.23,9.92),(-74.94,-25.45,8.259),(-75.51,-25.13,10.51),(-75.8,-25.65,10.22),(-76.36,-25.6,8.978),(-75.92,-25.69,8.755),(-76.13,-25.4,10.5),(-76.22,-25.73,10.26),(-76.5,-26.2,9.932),(-77.07,-26.03,9.009),(-76.66,-26.18,8.765),(-76.81,-26.0,10.35),(-77.18,-26.46,7.518),(-76.69,-26.44,7.892),(-77.46,-26.86,8.434),(-77.17,-26.49,8.039),(-77.0,-26.54,9.145),(-77.22,-26.93,9.193),(-77.83,-26.81,8.304),(-77.44,-26.91,8.299),(-77.51,-26.76,9.447),(-77.96,-27.19,8.18),(-73.53,-27.43,6.729),(-74.54,-26.98,5.18),(-75.64,-27.5,5.659),(-76.97,-27.99,7.049),(-75.12,-24.92,7.867),(-75.03,-24.89,8.785),(-75.11,-25.77,5.367),(-75.19,-25.04,6.508),(-75.57,-25.68,6.491),(-76.15,-25.82,5.974),(-76.17,-25.26,7.06),(-76.04,-25.15,8.468),(-75.93,-25.12,9.239),(-76.44,-26.05,7.016),(-76.85,-26.35,6.58),(-76.95,-25.87,7.048),(-76.76,-25.64,9.088),(-76.8,-25.67,8.378),(-77.59,-26.42,7.902),(-77.52,-26.38,8.265),(-77.61,-26.67,7.483),(-77.52,-27.17,7.217),(-72.73,-25.89,8.945),(-71.64,-25.42,9.218),(-71.95,-25.31,8.766),(-72.33,-26.49,9.293),(-71.41,-25.56,8.665),(-71.83,-26.41,8.308),(-72.2,-27.21,8.127),(-72.5,-26.21,7.786),(-72.31,-25.87,7.969),(-71.68,-25.43,8.265),(-66.17,-52.54,16.5),(-68.14,-50.55,20.79),(-69.28,-49.85,20.71),(-59.7,-33.03,27.02),(-61.36,-31.49,27.48),(-72.5,-34.02,28.46),(-68.79,-28.69,27.29),(-65.52,-28.44,27.22),(-71.81,-37.16,29.15),(-64.73,-37.74,17.5),(-67.8,-38.63,19.68),(-62.3,-35.64,18.96),(-60.95,-34.0,22.86),(-71.88,-37.74,23.77),(-49.25,-13.64,10.46),(-51.45,-17.67,12.3),(-53.12,-13.02,13.86),(-52.57,-17.25,15.08),(-51.57,-17.0,18.77),(-51.82,-12.74,17.25),(-48.36,-12.78,18.63),(-49.49,-18.08,10.75),(-49.66,-17.09,20.19),(-46.8,-17.53,19.5),(-45.46,-13.42,14.46),(-45.46,-18.13,15.61),(-46.67,-18.31,12.28),(-51.13,-21.68,11.2),(-51.19,-20.34,21.84),(-49.36,-22.49,20.68),(-48.37,-24.0,16.92),(-49.33,-23.36,14.18),(-57.64,-28.64,12.16),(-59.88,-25.89,12.71),(-59.49,-23.1,15.82),(-58.93,-22.55,20.81),(-57.08,-25.78,24.38),(-55.0,-28.33,23.36),(-54.39,-30.22,19.66),(-55.77,-30.1,15.6),(-65.35,-35.1,15.65),(-65.61,-29.98,12.66),(-64.06,-26.55,16.54),(-66.59,-27.16,25.0),(-63.09,-26.51,24.72),(-69.15,-35.86,16.46),(-67.84,-32.66,13.9),(-73.19,-33.05,18.64),(-72.49,-34.76,19.63),(-73.66,-35.27,26.84),(-74.09,-33.39,25.67),(-72.53,-32.18,28.02),(-71.02,-31.49,28.94),(-73.41,-31.23,19.29),(-68.72,-26.78,18.29),(-73.82,-30.54,25.12),(-67.07,-26.84,22.08),(-71.97,-29.84,27.43),(-69.4,-29.96,29.53),(-48.74,-7.938,8.338),(-50.68,-7.517,9.426),(-51.67,-7.188,12.69),(-50.81,-6.869,15.97),(-48.92,-7.042,17.32),(-46.87,-7.24,16.17),(-46.08,-7.649,13.28),(-46.86,-7.969,9.839),(-48.68,-1.001,7.728),(-50.38,-0.8282,8.452),(-51.19,-0.5461,11.1),(-50.47,-0.3183,13.77),(-48.8,-0.2926,14.98),(-46.96,-0.516,13.9),(-46.33,-0.989,11.61),(-46.97,-1.108,8.829),(-47.62,4.368,7.812),(-49.21,4.133,7.926),(-49.94,4.255,10.02),(-49.25,4.487,11.35),(-47.45,4.779,11.93),(-45.94,4.908,11.18),(-45.42,4.812,9.456),(-45.91,4.565,8.167),(-43.92,5.548,7.235),(-43.1,5.962,8.904),(-40.26,6.763,7.752),(-42.82,6.919,6.605),(-43.82,5.89,10.63),(-42.61,7.244,10.97),(-40.11,6.937,9.837),(-45.84,6.105,12.13),(-50.15,5.858,12.34),(-50.05,6.802,11.64),(-48.41,6.686,12.51),(-50.79,5.668,9.687),(-50.63,6.641,9.441),(-50.41,5.324,7.31),(-50.26,6.449,7.217),(-46.07,5.218,6.822),(-48.59,6.17,6.558),(-42.69,7.598,6.55),(-39.64,7.629,8.681),(-42.69,7.992,10.53),(-50.23,4.642,8.316),(-50.17,4.981,11.74),(-49.78,8.548,9.526),(-49.8,8.448,8.433),(-49.13,8.49,9.485),(-49.16,8.39,8.392),(-65.74,-27.95,24.91),(-62.97,-29.58,25.6),(-63.75,-35.94,39.23),(-66.97,-37.1,38.14),(-61.52,-34.19,36.41),(-60.55,-33.27,31.67),(-71.4,-36.85,34.56),(-78.84,-7.576,34.47),(-77.71,-12.24,34.18),(-82.49,-9.436,31.98),(-78.92,-12.94,31.65),(-78.36,-12.83,27.75),(-81.65,-9.192,28.29),(-78.81,-7.869,26.08),(-75.88,-11.29,35.29),(-76.82,-12.15,25.92),(-74.29,-10.9,25.98),(-75.95,-6.321,29.57),(-72.78,-10.0,29.56),(-73.56,-10.23,33.15),(-73.46,-14.8,36.45),(-74.5,-15.76,25.8),(-71.43,-15.18,27.0),(-69.55,-14.53,30.78),(-70.77,-14.59,33.53),(-68.84,-22.54,39.35),(-72.55,-23.44,38.1),(-75.04,-22.53,34.18),(-74.99,-22.51,29.1),(-70.37,-22.59,26.68),(-66.81,-21.9,28.1),(-65.04,-21.41,32.07),(-66.15,-21.95,36.28),(-64.56,-31.73,40.31),(-70.8,-29.36,40.04),(-69.54,-25.26,34.43),(-71.19,-27.42,27.07),(-68.09,-33.9,40.14),(-68.39,-30.87,40.38),(-72.34,-31.49,37.48),(-71.7,-33.31,37.22),(-73.48,-34.94,30.8),(-73.84,-32.94,31.12),(-71.13,-31.69,26.54),(-72.65,-29.84,36.05),(-72.63,-28.23,33.05),(-73.59,-30.11,30.25),(-70.96,-28.12,29.48),(-71.95,-29.82,27.73),(-69.61,-30.34,24.97),(-82.1,-2.46,34.17),(-84.02,-3.161,33.48),(-85.12,-3.888,30.48),(-84.67,-3.813,27.0),(-83.0,-3.349,25.28),(-81.14,-2.411,25.92),(-80.17,-1.901,28.63),(-80.54,-1.912,32.26),(-86.41,3.215,32.03),(-87.97,2.491,31.73),(-88.89,1.912,29.31),(-88.5,1.944,26.48),(-87.14,2.479,24.85),(-85.43,3.279,25.47),(-84.55,3.57,27.68),(-84.94,3.676,30.56),(-89.14,7.978,29.51),(-90.21,7.052,29.98),(-90.94,6.428,27.98),(-90.58,6.707,26.6),(-89.3,7.701,25.35),(-88.21,8.618,25.59),(-87.67,9.097,27.21),(-87.85,8.897,28.58),(-87.08,10.83,28.63),(-86.78,11.29,26.66),(-85.11,13.5,26.73),(-87.2,12.52,28.49),(-87.32,10.62,25.22),(-87.37,12.19,24.13),(-85.16,13.38,24.62),(-89.09,9.532,24.26),(-92.27,7.157,25.27),(-92.88,8.033,25.61),(-91.53,8.622,24.39),(-92.61,7.125,28.05),(-93.19,7.971,27.93),(-92.06,7.474,30.3),(-92.72,8.361,30.04),(-88.51,9.573,29.73),(-91.19,9.078,30.34),(-87.69,13.29,28.26),(-85.06,14.05,25.42),(-88.06,13.0,24.29),(-91.45,6.859,29.55),(-91.63,6.593,26.11),(-94.59,11.02,26.88),(-94.5,11.1,27.97),(-93.99,11.22,26.78),(-93.9,11.3,27.87),(-64.28,-63.25,34.77),(-68.68,-62.1,41.16),(-71.66,-68.06,36.71),(-65.25,-57.1,33.4),(-64.68,-63.19,36.02),(-65.65,-63.56,40.32),(-66.77,-62.75,40.75),(-65.07,-66.08,35.55),(-67.15,-67.57,36.11),(-70.14,-68.01,36.53),(-62.95,-60.96,34.08),(-63.51,-59.03,33.68),(-63.6,-57.89,33.41),(-71.82,-60.97,39.54),(-71.26,-62.98,41.09),(-76.67,-64.24,36.32),(-76.09,-66.09,36.71),(-73.29,-67.9,36.84),(-73.99,-59.98,35.02),(-71.41,-58.5,34.39),(-68.9,-57.92,33.98),(-69.15,-62.87,41.56),(-71.74,-66.4,41.24),(-71.73,-67.57,39.45),(-66.18,-57.78,37.31),(-66.83,-58.58,38.88),(-67.97,-60.55,40.62),(-66.11,-66.35,38.2),(-67.26,-64.24,40.93),(-69.87,-67.22,39.58),(-63.26,-60.94,34.94),(-64.5,-58.2,35.66),(-65.81,-60.51,39.36),(-75.74,-65.03,39.78),(-74.57,-66.7,40.25),(-73.0,-65.07,41.98),(-69.59,-60.79,40.24),(-68.26,-58.24,37.84),(-68.57,-67.92,36.34),(-64.43,-64.76,35.14),(-64.05,-62.76,34.63),(-63.91,-62.46,34.54),(-63.45,-61.78,34.33),(-64.21,-61.58,35.16),(-64.43,-62.13,35.14),(-62.96,-61.2,34.14),(-63.33,-60.72,34.06),(-63.69,-60.55,34.06),(-63.17,-60.1,33.9),(-64.01,-60.45,35.24),(-63.65,-59.85,35.64),(-64.75,-62.0,35.5),(-64.38,-60.75,35.76),(-64.7,-59.31,37.0),(-65.41,-58.68,37.64),(-64.33,-57.18,34.75),(-63.58,-59.56,33.81),(-63.91,-58.8,33.66),(-63.78,-58.25,33.52),(-63.86,-57.39,33.32),(-67.46,-57.39,33.7),(-64.22,-58.93,35.44),(-63.15,-59.91,33.85),(-63.35,-59.31,33.73),(-63.78,-59.41,35.65),(-63.42,-60.09,34.71),(-64.28,-60.72,37.51),(-63.85,-61.22,35.25),(-63.19,-61.37,34.74),(-63.84,-59.09,35.48),(-64.71,-63.63,38.89),(-65.05,-62.75,35.6),(-66.29,-62.07,40.4),(-64.63,-64.18,38.85),(-64.87,-62.49,36.94),(-64.59,-62.6,35.21),(-65.12,-62.89,39.14),(-65.48,-63.08,40.19),(-65.11,-63.25,36.86),(-64.34,-63.68,37.13),(-66.68,-65.51,40.08),(-67.51,-66.97,39.1),(-65.08,-59.76,38.25),(-69.9,-58.48,34.22),(-64.15,-63.94,34.92),(-64.63,-57.91,36.06),(-64.65,-62.96,35.29),(-64.11,-63.55,35.92),(-64.18,-64.02,36.47),(-65.76,-62.37,39.26),(-64.81,-61.66,36.69),(-65.66,-61.63,39.24),(-64.0,-60.3,35.95),(-76.5,-61.02,35.53),(-75.9,-62.14,39.35),(-74.94,-67.18,36.85),(-74.98,-60.03,35.94),(-75.63,-60.33,36.05),(-76.13,-60.14,35.28),(-76.46,-59.82,35.24),(-77.42,-59.33,35.23),(-78.14,-58.44,35.09),(-78.64,-56.66,34.72),(-80.28,-54.84,34.45),(-79.91,-53.92,34.19),(-78.95,-51.51,33.52),(-77.81,-50.58,33.14),(-75.72,-50.64,33.0),(-75.59,-52.35,33.36),(-74.13,-54.37,33.69),(-73.81,-57.12,34.31),(-75.19,-58.65,34.83),(-74.51,-58.89,34.81),(-74.22,-59.21,34.86),(-78.08,-54.05,35.09),(-76.44,-55.43,35.27),(-75.03,-59.57,35.78),(-76.23,-53.72,34.54),(-76.82,-51.92,34.18),(-76.41,-56.75,35.27),(-76.56,-58.08,35.43),(-75.74,-59.06,35.85),(-77.81,-52.56,34.38),(-76.51,-59.06,35.78),(-76.05,-59.48,35.84),(-75.67,-59.87,35.9),(-71.6,-60.89,40.55),(-71.46,-60.75,40.36),(-71.22,-60.7,40.15),(-71.06,-60.76,40.05),(-70.84,-60.84,39.91),(-70.71,-61.07,39.9),(-70.67,-61.31,40.08),(-71.83,-61.46,40.96),(-71.57,-61.37,40.71),(-71.35,-61.45,40.57),(-71.38,-61.89,40.34),(-71.17,-61.69,40.1),(-70.76,-61.64,40.19),(-72.22,-61.35,41.23),(-72.02,-61.44,41.1),(-72.03,-62.12,40.96),(-71.18,-62.17,40.52),(-71.02,-61.84,40.45),(-72.48,-61.79,41.62),(-72.1,-62.37,41.13),(-71.63,-62.68,40.88),(-71.24,-62.68,40.91),(-72.55,-62.26,41.87),(-72.34,-62.33,41.74),(-72.05,-62.79,41.69),(-71.83,-63.14,41.24),(-71.65,-63.08,41.06),(-72.49,-62.7,42.01),(-71.81,-63.33,41.56),(-71.51,-63.36,41.34),(-71.4,-63.22,41.01),(-71.12,-63.25,41.18),(-72.35,-63.23,42.12),(-72.25,-63.44,42.12),(-72.03,-63.54,41.99),(-71.8,-63.67,41.85),(-71.49,-63.66,41.61),(-71.22,-63.5,41.32),(-71.53,-60.86,40.78),(-71.39,-60.72,40.6),(-71.15,-60.67,40.39),(-70.77,-60.81,40.14),(-70.68,-61.01,40.13),(-71.75,-61.43,41.19),(-71.5,-61.34,40.95),(-71.28,-61.42,40.8),(-72.15,-61.32,41.46),(-72.09,-61.84,41.63),(-72.03,-62.34,41.36),(-72.41,-61.75,41.85),(-72.48,-62.23,42.1),(-72.27,-62.3,41.97),(-71.98,-62.76,41.92),(-71.76,-63.11,41.47),(-72.42,-62.67,42.24),(-71.97,-63.1,42.06),(-71.74,-63.29,41.8),(-71.44,-63.33,41.57),(-72.28,-63.19,42.35),(-72.18,-63.41,42.35),(-71.96,-63.51,42.22),(-71.73,-63.63,42.09),(-71.42,-63.63,41.84),(-71.15,-63.46,41.55),(-69.29,-63.09,29.06),(-64.8,-63.39,33.64),(-66.18,-64.42,29.92),(-67.35,-63.69,29.37),(-72.04,-61.38,30.71),(-71.77,-63.73,30.07),(-69.59,-64.03,29.17),(-72.23,-67.2,31.61),(-72.01,-67.91,33.57),(-66.52,-58.16,30.31),(-67.32,-59.39,29.21),(-68.58,-61.53,28.71),(-65.9,-66.84,32.93),(-68.12,-65.46,29.89),(-70.19,-67.64,33.18),(-63.35,-61.08,33.31),(-64.7,-58.53,31.61),(-66.31,-61.33,29.44),(-76.07,-65.57,33.21),(-74.92,-67.27,33.31),(-73.59,-66.11,30.39),(-70.13,-61.67,29.52),(-68.64,-58.86,30.34),(-64.28,-61.71,33.61),(-64.5,-62.23,33.93),(-64.12,-60.63,32.96),(-63.83,-60.13,32.23),(-64.85,-62.16,33.59),(-64.54,-61.0,32.68),(-65.01,-59.81,30.9),(-65.77,-58.99,30.23),(-64.48,-57.42,31.75),(-64.39,-59.21,32.1),(-63.96,-59.7,32.03),(-63.49,-60.22,33.17),(-64.61,-61.27,30.91),(-63.95,-61.38,33.28),(-63.24,-61.46,33.7),(-64.02,-59.38,32.06),(-65.11,-64.27,31.11),(-65.14,-62.89,33.91),(-66.85,-62.99,29.28),(-65.01,-64.8,31.4),(-65.1,-62.87,32.53),(-64.65,-62.7,34.11),(-65.55,-63.6,30.74),(-66.01,-63.9,29.9),(-65.31,-63.57,32.96),(-64.56,-64.04,32.74),(-67.25,-66.29,31.43),(-67.81,-67.37,33.04),(-65.49,-60.47,30.22),(-64.86,-58.12,31.2),(-64.71,-63.05,34.22),(-64.22,-63.72,33.78),(-64.33,-64.26,33.49),(-66.32,-63.13,30.54),(-65.03,-62.06,32.47),(-66.13,-62.38,30.05),(-64.2,-60.73,32.24),(-76.26,-62.72,32.3),(-75.06,-60.15,34.37),(-75.7,-60.46,34.54),(-78.09,-55.45,33.64),(-76.83,-56.73,33.82),(-75.11,-59.69,34.31),(-75.9,-54.46,32.9),(-76.78,-52.03,32.62),(-76.6,-57.98,34.25),(-75.81,-59.16,34.28),(-78.39,-53.28,32.95),(-76.58,-59.18,34.38),(-76.12,-59.59,34.43),(-75.74,-59.99,34.47),(-72.15,-61.79,29.69),(-72.0,-61.63,29.77),(-71.74,-61.55,29.9),(-71.58,-61.59,29.99),(-71.34,-61.65,30.12),(-71.24,-61.85,30.2),(-71.2,-62.13,30.26),(-72.4,-62.4,29.61),(-72.13,-62.27,29.75),(-71.89,-62.33,29.88),(-71.89,-62.72,30.3),(-71.67,-62.49,30.4),(-71.29,-62.47,30.14),(-72.82,-62.33,29.39),(-72.61,-62.4,29.51),(-72.59,-63.03,29.96),(-71.72,-63.0,30.24),(-71.55,-62.71,30.08),(-73.11,-62.81,29.28),(-72.67,-63.3,29.93),(-72.18,-63.56,30.21),(-73.19,-63.3,29.27),(-72.97,-63.35,29.39),(-72.66,-63.79,29.59),(-72.4,-64.06,30.14),(-72.2,-63.97,30.24),(-73.14,-63.75,29.33),(-72.4,-64.29,29.91),(-72.09,-64.29,30.07),(-71.92,-64.1,30.39),(-71.61,-64.22,30.05),(-73.0,-64.27,29.45),(-72.89,-64.48,29.52),(-72.66,-64.56,29.65),(-72.41,-64.66,29.79),(-72.08,-64.63,29.96),(-71.79,-64.42,30.1),(-72.14,-61.75,29.43),(-71.95,-61.64,29.52),(-71.69,-61.56,29.64),(-71.29,-61.66,29.86),(-71.2,-61.85,29.95),(-71.15,-62.13,30.01),(-72.36,-62.41,29.36),(-72.08,-62.28,29.5),(-71.85,-62.34,29.63),(-72.78,-62.33,29.14),(-72.72,-62.86,29.21),(-73.06,-62.81,29.02),(-72.93,-63.36,29.13),(-73.15,-63.31,29.02),(-72.62,-63.8,29.33),(-72.35,-64.07,29.88),(-73.09,-63.75,29.08),(-72.62,-64.15,29.36),(-72.35,-64.3,29.65),(-72.04,-64.3,29.82),(-71.86,-64.1,30.09),(-72.95,-64.28,29.19),(-72.84,-64.49,29.27),(-72.61,-64.57,29.4),(-72.36,-64.67,29.53),(-72.04,-64.63,29.7),(-71.74,-64.43,29.84),(-67.4,-59.52,39.95),(-67.88,-60.32,28.71),(-64.21,-43.54,41.63),(-70.74,-45.92,19.84),(-31.72,-44.26,25.35),(-24.69,-37.19,23.66),(-21.94,-44.39,25.67),(-33.2,-41.46,25.11),(-32.29,-43.9,30.59),(-30.75,-42.34,34.08),(-27.7,-41.91,33.64),(-29.02,-40.21,34.25),(-22.81,-44.06,32.17),(-26.61,-38.69,32.25),(-25.53,-37.66,29.26),(-31.17,-41.19,31.42),(-22.52,-44.82,19.32),(-32.05,-44.55,19.76),(-30.33,-43.37,16.57),(-27.31,-42.98,16.6),(-29.15,-41.45,15.28),(-26.71,-39.71,16.14),(-25.56,-38.4,18.7),(-31.25,-42.11,18.47),(-24.36,-52.84,17.34),(-32.07,-53.12,14.9),(-27.63,-51.57,15.69),(-30.33,-51.27,13.38),(-30.25,-56.98,18.99),(-28.92,-59.33,28.6),(-32.33,-48.07,26.29),(-32.24,-53.12,27.27),(-20.98,-48.76,27.05),(-22.09,-51.87,26.42),(-18.72,-48.14,20.67),(-19.13,-49.78,24.45),(-19.54,-49.77,17.94),(-20.96,-51.61,20.52),(-20.46,-45.96,20.6),(-28.08,-61.59,29.27),(-32.65,-47.82,32.29),(-30.96,-56.18,33.53),(-31.5,-46.84,36.38),(-24.38,-48.09,38.25),(-26.06,-45.18,35.33),(-18.98,-47.45,32.42),(-19.94,-48.73,35.57),(-21.43,-51.03,33.51),(-19.24,-49.49,29.28),(-22.09,-51.74,28.45),(-25.83,-51.91,36.69),(-21.67,-48.11,37.61),(-21.43,-46.19,35.74),(-20.71,-45.31,31.55),(-23.38,-46.15,37.94),(-23.22,-45.01,36.29),(-21.53,-44.62,32.88),(-28.2,-50.0,38.42),(-30.3,-50.18,38.37),(-27.89,-57.94,32.43),(-32.19,-52.84,38.75),(-27.89,-57.16,31.11),(-26.62,-60.01,32.0),(-30.5,-55.98,38.97),(-30.03,-56.38,35.46),(-25.04,-55.87,28.23),(-25.43,-56.01,31.01),(-23.5,-53.9,29.81),(-24.35,-53.76,27.98),(-23.16,-53.98,26.14),(-26.67,-56.79,30.03),(-24.48,-58.28,28.55),(-26.04,-59.51,31.02),(-26.57,-57.1,26.51),(-25.82,-59.67,26.78),(-24.29,-55.39,24.61),(-21.21,-45.45,18.88),(-21.18,-49.43,15.43),(-20.66,-47.11,16.56),(-27.8,-58.3,24.08),(-26.36,-60.37,25.48),(-30.66,-56.72,15.09),(-32.36,-48.57,19.64),(-29.31,-56.54,20.13),(-30.99,-48.02,16.28),(-23.18,-49.08,14.44),(-25.64,-46.32,16.11),(-22.29,-47.15,14.34),(-22.74,-46.25,15.34),(-30.23,-51.32,12.85),(-19.23,-47.08,20.65),(-19.48,-46.4,32.01),(-18.76,-49.17,26.91),(-27.19,-57.17,23.23),(-30.29,-50.22,37.82),(-30.24,-51.28,12.83),(-25.83,-54.56,35.52),(-25.04,-55.1,18.31),(-30.04,-57.42,18.82),(-29.98,-56.89,35.68),(-29.08,-57.57,32.94),(-28.88,-57.92,22.78),(-27.91,-60.18,26.67),(-27.37,-61.12,25.79),(-28.82,-58.95,26.49),(-27.96,-60.1,30.67),(-27.37,-60.62,32.05),(-28.84,-58.76,30.36),(-28.22,-60.9,29.09),(-27.27,-54.24,41.78),(-29.91,-54.64,41.69),(-28.58,-50.45,43.66),(-28.48,-51.85,44.05),(-28.21,-49.89,41.34),(-25.32,-53.26,40.65),(-36.71,-44.67,38.09),(-34.53,-42.78,40.79),(-34.61,-44.18,43.72),(-35.99,-45.65,44.12),(-34.96,-49.23,41.33),(-37.6,-41.9,38.48),(-39.4,-42.75,39.81),(-38.98,-44.88,41.41),(-35.28,-38.55,39.78),(-37.03,-38.67,37.81),(-40.27,-31.28,37.81),(-38.47,-31.12,38.01),(-38.44,-38.8,39.28),(-40.85,-31.0,41.22),(-39.91,-39.05,42.34),(-40.13,-40.13,41.08),(-39.8,-42.77,41.39),(-38.65,-42.36,43.63),(-39.39,-30.72,41.73),(-38.13,-38.81,43.68),(-38.38,-30.69,40.47),(-36.47,-38.63,43.17),(-37.16,-41.79,44.23),(-35.66,-41.79,43.47),(-41.15,-28.73,36.76),(-40.74,-28.14,36.44),(-40.88,-27.69,40.02),(-40.92,-29.79,36.73),(-40.04,-29.62,35.58),(-40.95,-28.03,42.98),(-42.85,-26.96,36.64),(-41.22,-26.75,37.51),(-41.15,-26.35,36.7),(-43.7,-27.51,36.68),(-43.26,-27.74,37.41),(-43.11,-27.09,37.92),(-43.71,-27.64,37.53),(-42.6,-27.27,37.31),(-44.16,-27.69,37.97),(-43.71,-27.9,38.66),(-43.16,-27.28,39.34),(-42.89,-27.38,38.79),(-44.09,-27.72,38.97),(-43.75,-27.87,39.28),(-43.31,-28.02,39.92),(-43.01,-27.43,40.56),(-42.7,-27.55,40.09),(-43.73,-27.95,40.24),(-41.59,-26.82,41.01),(-41.6,-27.14,40.39),(-41.69,-27.34,41.76),(-42.12,-27.34,40.96),(-42.73,-27.86,40.78),(-42.52,-28.11,41.31),(-42.16,-27.49,42.05),(-41.94,-27.64,41.61),(-42.84,-28.01,41.61),(-41.5,-27.24,42.58),(-39.95,-28.23,36.59),(-39.37,-27.04,37.71),(-39.5,-27.27,39.57),(-40.27,-27.72,41.71),(-42.78,-26.7,37.22),(-43.29,-27.02,37.12),(-40.76,-26.04,37.57),(-42.02,-26.27,37.31),(-41.42,-26.36,38.25),(-41.2,-26.07,39.06),(-42.32,-26.37,38.8),(-43.13,-26.85,38.63),(-43.56,-27.13,38.48),(-41.58,-26.57,39.69),(-41.23,-26.41,40.39),(-42.04,-26.55,40.22),(-43.27,-27.25,39.91),(-42.87,-27.0,39.95),(-42.1,-27.1,41.5),(-42.42,-27.28,41.36),(-41.49,-26.79,41.71),(-40.92,-26.99,41.9),(-42.09,-27.92,34.8),(-42.41,-27.94,33.07),(-42.24,-27.63,33.39),(-41.89,-28.61,34.65),(-41.97,-27.96,32.8),(-41.3,-28.4,33.85),(-40.76,-28.87,34.8),(-41.18,-27.89,34.59),(-41.47,-27.74,34.14),(-41.84,-27.66,33.05),(-28.61,-54.08,42.56),(-27.98,-55.48,12.19),(-29.58,-54.94,11.6),(-29.71,-52.51,9.471),(-26.68,-53.01,9.226),(-25.82,-51.07,11.63),(-26.0,-54.44,13.15),(-30.28,-43.17,11.22),(-27.07,-43.29,8.808),(-27.98,-44.23,6.075),(-30.05,-44.86,5.671),(-31.5,-47.68,9.372),(-28.79,-42.17,10.74),(-30.24,-41.16,8.981),(-32.0,-42.58,7.473),(-24.45,-43.15,9.889),(-25.2,-41.73,11.67),(-17.2,-37.81,12.67),(-16.71,-39.13,11.57),(-25.68,-40.66,10.06),(-17.05,-36.58,9.9),(-26.24,-39.63,6.844),(-27.59,-39.76,7.91),(-30.31,-40.97,7.33),(-29.3,-41.87,5.394),(-16.53,-37.52,8.605),(-25.37,-41.03,5.711),(-16.28,-38.59,9.188),(-24.71,-42.3,6.397),(-28.13,-42.86,5.146),(-27.62,-43.98,6.224),(-13.78,-38.79,12.76),(-13.16,-39.08,12.18),(-12.78,-37.04,11.24),(-15.16,-38.85,12.73),(-15.02,-39.75,11.96),(-13.24,-35.42,10.15),(-11.28,-38.4,14.18),(-11.45,-38.4,12.08),(-11.0,-38.9,12.03),(-11.93,-38.08,15.31),(-12.2,-37.83,14.44),(-11.41,-37.62,14.03),(-12.07,-37.62,15.0),(-11.64,-38.11,13.6),(-12.12,-37.23,15.43),(-12.36,-37.0,14.55),(-11.62,-36.83,13.54),(-11.75,-37.21,13.4),(-12.15,-36.71,14.94),(-12.32,-36.66,14.37),(-12.49,-36.45,13.52),(-11.79,-36.22,12.87),(-11.95,-36.58,12.64),(-12.4,-36.14,13.95),(-11.49,-36.36,11.42),(-11.75,-36.66,11.92),(-12.03,-35.86,11.73),(-11.76,-36.29,11.63),(-12.3,-36.19,12.41),(-12.59,-35.96,11.94),(-11.94,-35.68,11.28),(-12.16,-35.97,11.29),(-12.46,-35.7,12.23),(-12.11,-35.48,11.06),(-13.41,-39.24,11.25),(-12.24,-38.8,9.938),(-12.51,-37.75,9.501),(-12.95,-36.34,9.766),(-10.96,-38.11,13.86),(-11.35,-37.99,14.58),(-10.89,-38.56,10.99),(-10.48,-38.33,12.71),(-10.97,-37.96,11.85),(-10.75,-37.61,11.11),(-10.59,-37.42,12.58),(-11.12,-37.23,13.77),(-11.45,-37.17,14.4),(-11.21,-37.12,11.63),(-11.22,-36.84,10.87),(-10.89,-36.74,11.67),(-11.58,-36.49,13.46),(-11.29,-36.6,12.9),(-11.52,-35.99,11.51),(-11.65,-35.98,11.81),(-11.52,-36.0,11.07),(-11.97,-36.03,10.43),(-12.81,-39.6,14.7),(-12.76,-40.46,15.73),(-12.41,-40.33,15.35),(-13.63,-39.75,14.61),(-12.81,-40.74,15.24),(-13.42,-40.36,14.05),(-14.04,-40.0,13.07),(-12.85,-39.99,13.56),(-12.63,-40.15,14.07),(-12.48,-40.64,14.92),(-27.69,-54.88,10.81),(-27.63,-51.57,15.67),(-30.32,-51.27,13.35),(-25.32,-32.86,22.81),(-27.66,-31.33,22.83),(-37.21,-36.95,24.59),(-35.48,-30.93,23.67),(-32.44,-29.89,23.51),(-35.48,-39.81,25.05),(-28.76,-38.42,13.14),(-31.35,-40.06,15.35),(-27.12,-35.84,14.66),(-26.29,-34.01,18.63),(-35.47,-40.27,19.64),(-30.63,-11.1,7.269),(-28.93,-15.3,8.673),(-33.6,-12.93,11.25),(-29.82,-15.64,11.65),(-28.94,-14.92,15.22),(-32.56,-12.0,14.49),(-29.9,-10.03,15.4),(-27.3,-14.49,6.815),(-27.32,-13.93,16.36),(-24.92,-12.65,15.23),(-27.69,-8.774,10.77),(-23.81,-12.32,11.11),(-24.88,-13.1,7.934),(-26.12,-18.06,6.903),(-26.21,-17.12,17.66),(-23.41,-18.09,16.01),(-21.93,-18.89,11.96),(-23.34,-18.73,9.432),(-27.59,-26.88,7.677),(-31.06,-25.44,8.97),(-32.07,-22.93,12.38),(-31.5,-22.29,17.33),(-27.7,-24.37,20.16),(-24.51,-25.69,18.49),(-23.2,-27.0,14.44),(-24.83,-27.41,10.6),(-30.58,-35.85,11.09),(-33.8,-31.35,9.216),(-33.94,-27.83,13.34),(-34.84,-29.6,22.12),(-32.33,-27.58,21.29),(-33.66,-37.67,12.37),(-34.23,-34.58,10.36),(-38.42,-36.01,14.88),(-37.16,-37.5,15.72),(-37.94,-38.4,22.93),(-39.01,-36.69,21.9),(-37.87,-35.19,24.28),(-36.64,-34.18,25.2),(-39.23,-34.33,15.65),(-37.64,-29.93,15.97),(-39.73,-33.88,21.54),(-35.77,-29.44,19.37),(-38.14,-32.8,23.83),(-35.59,-32.33,25.84),(-35.07,-6.624,6.112),(-36.7,-7.464,7.512),(-37.37,-7.837,10.93),(-36.7,-7.132,14.13),(-35.08,-6.161,15.19),(-33.56,-5.095,13.76),(-32.93,-4.906,10.72),(-33.56,-5.56,7.353),(-40.72,-1.528,6.747),(-42.02,-2.406,7.703),(-42.58,-2.699,10.48),(-42.0,-2.145,13.07),(-40.7,-1.163,14.08),(-39.3,-0.2431,12.74),(-38.68,-0.1915,10.3),(-39.31,-0.6236,7.61),(-44.09,2.981,7.662),(-45.12,1.939,7.91),(-45.59,1.602,10.09),(-45.13,2.139,11.37),(-43.92,3.331,11.8),(-42.92,4.258,10.91),(-42.59,4.491,9.127),(-42.89,4.055,7.861),(-41.9,5.742,6.932),(-41.4,6.48,8.57),(-39.76,8.573,7.276),(-41.99,7.427,6.382),(-41.82,6.022,10.35),(-41.76,7.73,10.74),(-39.62,8.76,9.36),(-43.5,5.16,12.04),(-46.76,2.763,12.64),(-47.39,3.602,12.06),(-45.94,4.329,12.74),(-47.32,2.311,10.04),(-47.9,3.206,9.904),(-46.98,2.214,7.623),(-47.62,3.283,7.626),(-43.43,4.407,6.668),(-46.14,3.915,6.766),(-42.45,8.166,6.386),(-39.64,9.346,8.286),(-42.46,8.461,10.39),(-46.25,1.773,8.491),(-46.17,2.018,11.94),(-49.06,6.129,9.982),(-49.08,6.048,8.885),(-48.46,6.335,9.887),(-48.48,6.254,8.79),(-33.68,-29.95,21.72),(-30.34,-30.25,21.62),(-27.94,-36.86,34.94),(-30.65,-38.74,33.87),(-26.46,-34.59,32.17),(-25.95,-33.38,27.47),(-35.06,-39.5,30.46),(-22.32,-12.02,28.36),(-21.04,-16.35,28.07),(-25.71,-14.28,26.08),(-22.27,-17.09,25.59),(-21.77,-17.02,21.68),(-25.02,-13.97,22.34),(-22.45,-12.36,19.98),(-19.19,-15.39,29.11),(-20.26,-16.35,19.78),(-17.69,-15.14,19.75),(-19.74,-10.51,23.31),(-16.11,-14.26,23.27),(-16.86,-14.42,26.88),(-18.68,-18.44,30.42),(-19.96,-19.12,19.76),(-17.36,-20.45,21.31),(-15.63,-20.96,25.28),(-16.58,-20.11,27.85),(-22.87,-26.25,34.21),(-25.83,-24.13,33.01),(-26.47,-21.98,28.73),(-26.46,-22.22,23.59),(-24.0,-25.52,21.52),(-21.36,-27.58,23.02),(-19.85,-28.45,26.96),(-20.92,-27.89,31.12),(-30.12,-33.04,36.33),(-30.3,-28.95,36.35),(-37.2,-27.96,31.06),(-29.71,-27.26,22.79),(-32.76,-35.98,36.13),(-34.07,-33.16,36.58),(-37.71,-34.66,33.78),(-36.49,-36.24,33.37),(-37.79,-38.11,26.9),(-38.8,-36.3,27.36),(-36.73,-34.35,22.8),(-38.6,-33.13,32.47),(-39.19,-31.53,29.58),(-39.54,-33.51,26.68),(-37.71,-30.95,25.97),(-38.13,-32.78,24.13),(-35.77,-32.66,21.26),(-26.56,-7.319,28.22),(-28.33,-8.28,27.63),(-29.36,-9.165,24.71),(-29.03,-9.037,21.2),(-27.52,-8.353,19.39),(-25.85,-7.164,19.92),(-24.91,-6.518,22.58),(-25.18,-6.568,26.22),(-32.23,-2.238,26.35),(-33.63,-3.177,26.13),(-34.48,-3.883,23.76),(-34.18,-3.8,20.91),(-32.99,-3.079,19.21),(-31.45,-2.043,19.74),(-30.57,-1.626,21.91),(-30.91,-1.574,24.8),(-35.44,1.972,24.02),(-36.6,1.155,24.5),(-37.36,0.5234,22.51),(-37.0,0.8094,21.12),(-35.61,1.685,19.87),(-34.4,2.463,20.11),(-33.8,2.885,21.74),(-34.02,2.721,23.11),(-32.94,4.552,23.15),(-32.53,4.988,21.17),(-30.54,7.004,21.24),(-32.78,6.27,22.96),(-33.18,4.339,19.73),(-32.96,5.926,18.61),(-30.59,6.878,19.13),(-35.1,3.458,18.76),(-38.64,1.407,19.77),(-39.12,2.378,20.06),(-37.68,2.829,18.85),(-38.99,1.392,22.55),(-39.45,2.35,22.39),(-38.41,1.726,24.79),(-38.94,2.716,24.5),(-34.59,3.473,24.23),(-37.32,3.286,24.8),(-33.1,6.917,22.74),(-30.55,7.802,19.88),(-33.48,6.616,18.77),(-37.85,1.008,24.07),(-38.06,0.7369,20.64),(-39.9,4.426,21.41),(-39.82,4.508,22.5),(-39.31,4.639,21.3),(-39.23,4.721,22.39),(-19.32,-63.05,28.64),(-23.78,-63.14,35.25),(-24.73,-69.49,30.49),(-22.36,-57.37,27.72),(-19.7,-63.12,29.9),(-20.41,-63.78,34.21),(-21.74,-63.29,34.73),(-19.11,-65.97,29.26),(-20.58,-67.91,29.78),(-23.29,-69.07,30.27),(-18.84,-60.52,28.06),(-20.04,-58.8,27.81),(-20.51,-57.73,27.63),(-27.21,-62.79,33.8),(-25.96,-64.61,35.2),(-30.82,-67.05,30.53),(-29.63,-68.68,30.77),(-26.33,-69.73,30.69),(-29.72,-62.29,29.42),(-27.76,-60.23,28.81),(-25.57,-59.06,28.37),(-23.97,-64.0,35.61),(-25.26,-68.0,35.14),(-24.89,-69.09,33.27),(-22.93,-58.32,31.61),(-23.25,-59.28,33.15),(-23.64,-61.47,34.79),(-19.95,-66.53,31.92),(-21.7,-64.83,34.82),(-23.23,-68.3,33.36),(-19.13,-60.6,28.94),(-21.22,-58.28,29.88),(-21.61,-60.89,33.46),(-29.58,-67.64,33.9),(-27.89,-68.96,34.21),(-26.9,-67.05,36.0),(-25.11,-62.09,34.44),(-24.76,-59.28,32.17),(-21.82,-68.59,30.03),(-18.95,-64.54,28.92),(-19.27,-62.52,28.52),(-19.24,-62.2,28.45),(-19.04,-61.43,28.27),(-19.81,-61.44,29.14),(-19.84,-62.02,29.09),(-18.77,-60.75,28.11),(-19.29,-60.39,28.08),(-19.69,-60.31,28.1),(-19.35,-59.75,27.95),(-20.0,-60.31,29.29),(-19.85,-59.66,29.72),(-20.18,-61.99,29.47),(-20.25,-60.7,29.81),(-21.0,-59.42,31.15),(-21.89,-59.0,31.86),(-21.42,-57.25,29.04),(-19.92,-59.33,27.91),(-20.5,-58.67,27.83),(-20.56,-58.12,27.72),(-20.93,-57.32,27.58),(-24.37,-58.19,28.08),(-20.71,-58.92,29.6),(-19.39,-59.56,27.91),(-19.79,-59.03,27.84),(-20.12,-59.26,29.76),(-19.57,-59.81,28.77),(-20.11,-60.68,31.55),(-19.59,-61.01,29.24),(-18.91,-60.99,28.7),(-20.29,-58.98,29.62),(-19.52,-63.59,32.75),(-20.21,-62.78,29.53),(-21.52,-62.51,34.41),(-19.25,-64.1,32.66),(-20.1,-62.5,30.88),(-19.83,-62.52,29.14),(-20.15,-62.99,33.06),(-20.41,-63.28,34.1),(-20.07,-63.29,30.75),(-19.18,-63.52,30.98),(-20.74,-65.89,33.87),(-21.06,-67.48,32.81),(-21.19,-59.97,32.38),(-26.33,-59.84,28.6),(-18.96,-63.69,28.74),(-21.43,-58.05,30.3),(-19.77,-62.87,29.19),(-19.04,-63.32,29.77),(-18.93,-63.79,30.28),(-20.94,-62.65,33.23),(-20.33,-61.69,30.68),(-21.09,-61.91,33.26),(-20.03,-60.18,30.01),(-31.76,-63.91,29.95),(-30.72,-64.9,33.67),(-28.16,-69.45,30.79),(-30.64,-62.59,30.38),(-31.15,-63.04,30.49),(-31.71,-62.97,29.75),(-32.14,-62.74,29.74),(-33.22,-62.5,29.79),(-34.21,-61.83,29.74),(-35.31,-60.24,29.5),(-37.49,-58.89,29.42),(-37.45,-57.91,29.21),(-37.37,-55.36,28.66),(-36.6,-54.19,28.31),(-34.58,-53.73,28.1),(-33.87,-55.34,28.34),(-31.79,-56.93,28.48),(-30.53,-59.49,28.91),(-31.33,-61.3,29.36),(-30.59,-61.36,29.31),(-30.21,-61.6,29.33),(-35.64,-57.61,30.04),(-33.6,-58.53,30.06),(-30.84,-62.16,30.25),(-33.99,-56.83,29.45),(-35.17,-55.25,29.23),(-33.13,-59.79,29.98),(-32.81,-61.1,30.04),(-31.69,-61.85,30.37),(-35.9,-56.11,29.42),(-32.43,-62.04,30.33),(-31.84,-62.32,30.35),(-31.34,-62.61,30.37),(-27.0,-62.68,34.81),(-26.91,-62.51,34.63),(-26.7,-62.4,34.41),(-26.54,-62.42,34.31),(-26.3,-62.44,34.15),(-26.11,-62.62,34.12),(-25.98,-62.85,34.28),(-27.01,-63.29,35.19),(-26.81,-63.14,34.94),(-26.57,-63.15,34.78),(-26.45,-63.58,34.53),(-26.33,-63.34,34.3),(-25.96,-63.19,34.37),(-27.42,-63.28,35.48),(-27.2,-63.32,35.34),(-26.99,-63.97,35.16),(-26.17,-63.8,34.68),(-26.13,-63.45,34.63),(-27.51,-63.77,35.85),(-26.97,-64.23,35.31),(-26.42,-64.41,35.02),(-26.04,-64.31,35.03),(-27.42,-64.25,36.07),(-27.2,-64.27,35.93),(-26.76,-64.63,35.83),(-26.45,-64.91,35.35),(-26.29,-64.8,35.17),(-27.21,-64.66,36.18),(-26.35,-65.08,35.67),(-26.06,-65.04,35.43),(-26.01,-64.87,35.11),(-25.73,-64.83,35.26),(-26.9,-65.13,36.24),(-26.72,-65.31,36.23),(-26.48,-65.35,36.08),(-26.22,-65.41,35.93),(-25.93,-65.33,35.67),(-25.74,-65.1,35.39),(-26.94,-62.64,35.05),(-26.85,-62.47,34.87),(-26.64,-62.36,34.65),(-26.24,-62.39,34.38),(-26.08,-62.56,34.36),(-26.95,-63.25,35.42),(-26.74,-63.09,35.18),(-26.51,-63.11,35.02),(-27.36,-63.24,35.71),(-27.12,-63.73,35.84),(-26.9,-64.19,35.54),(-27.45,-63.73,36.08),(-27.36,-64.2,36.3),(-27.13,-64.22,36.16),(-26.7,-64.58,36.07),(-26.39,-64.86,35.59),(-27.15,-64.61,36.41),(-26.58,-64.92,36.18),(-26.29,-65.04,35.9),(-26.0,-65.0,35.67),(-26.84,-65.09,36.48),(-26.66,-65.27,36.46),(-26.42,-65.31,36.31),(-26.16,-65.37,36.16),(-25.87,-65.29,35.91),(-25.67,-65.05,35.62),(-24.31,-64.02,23.11),(-19.8,-63.29,27.52),(-20.86,-64.54,23.78),(-22.24,-64.12,23.31),(-27.48,-63.07,24.96),(-26.44,-65.25,24.16),(-24.28,-64.98,23.16),(-25.68,-68.7,25.47),(-25.18,-69.38,27.38),(-23.29,-58.64,24.6),(-23.67,-60.0,23.44),(-24.16,-62.34,22.84),(-19.71,-66.85,26.61),(-22.37,-66.01,23.74),(-23.53,-68.67,26.95),(-19.2,-60.71,27.31),(-21.4,-58.58,25.82),(-22.04,-61.61,23.52),(-29.87,-68.11,27.31),(-28.19,-69.47,27.25),(-27.38,-67.98,24.38),(-25.58,-62.87,23.7),(-25.09,-59.83,24.65),(-19.88,-61.56,27.58),(-19.9,-62.11,27.87),(-20.1,-60.47,27.0),(-20.0,-59.91,26.3),(-20.27,-62.12,27.55),(-20.38,-60.92,26.71),(-21.27,-59.87,25.03),(-22.29,-59.25,24.44),(-21.55,-57.46,26.03),(-20.86,-59.16,26.25),(-20.28,-59.53,26.14),(-19.63,-59.93,27.22),(-20.4,-61.17,24.93),(-19.68,-61.15,27.27),(-18.96,-61.06,27.66),(-20.44,-59.23,26.19),(-19.86,-64.16,24.95),(-20.29,-62.9,27.83),(-22.0,-63.32,23.25),(-19.58,-64.64,25.19),(-20.29,-62.85,26.45),(-19.88,-62.6,28.03),(-20.51,-63.62,24.64),(-20.87,-64.0,23.79),(-20.24,-63.58,26.84),(-19.38,-63.84,26.56),(-21.21,-66.63,25.2),(-21.35,-67.82,26.74),(-21.53,-60.6,24.32),(-21.7,-58.21,25.45),(-19.81,-62.95,28.11),(-19.13,-63.47,27.62),(-19.06,-64.01,27.3),(-21.42,-63.35,24.49),(-20.5,-62.05,26.45),(-21.49,-62.58,24.04),(-20.16,-60.57,26.28),(-31.03,-65.41,26.6),(-30.7,-62.7,28.8),(-31.21,-63.15,28.97),(-35.21,-58.93,28.49),(-33.57,-59.84,28.54),(-30.91,-62.27,28.78),(-33.46,-57.43,27.75),(-35.14,-55.31,27.66),(-32.91,-61.0,28.88),(-31.76,-61.93,28.8),(-36.25,-56.9,27.96),(-32.49,-62.14,28.93),(-31.91,-62.43,28.93),(-31.41,-62.71,28.94),(-27.47,-63.47,23.92),(-27.38,-63.28,24.0),(-27.15,-63.15,24.13),(-26.98,-63.15,24.21),(-26.73,-63.15,24.33),(-26.57,-63.32,24.4),(-26.43,-63.57,24.44),(-27.51,-64.12,23.81),(-27.29,-63.93,23.95),(-27.04,-63.93,24.06),(-26.89,-64.31,24.46),(-26.76,-64.04,24.56),(-26.41,-63.92,24.3),(-27.94,-64.15,23.6),(-27.71,-64.16,23.71),(-27.47,-64.77,24.12),(-26.63,-64.54,24.37),(-26.57,-64.22,24.23),(-28.05,-64.67,23.47),(-27.46,-65.05,24.08),(-26.89,-65.19,24.32),(-27.97,-65.16,23.43),(-27.74,-65.17,23.54),(-27.29,-65.51,23.7),(-26.93,-65.72,24.22),(-26.77,-65.58,24.32),(-27.77,-65.58,23.46),(-26.86,-65.93,23.97),(-26.55,-65.86,24.13),(-26.45,-65.64,24.46),(-26.12,-65.67,24.1),(-27.45,-66.05,23.54),(-27.27,-66.23,23.59),(-27.02,-66.25,23.71),(-26.75,-66.29,23.83),(-26.44,-66.18,23.99),(-26.23,-65.91,24.13),(-27.48,-63.42,23.66),(-27.34,-63.27,23.75),(-27.11,-63.14,23.88),(-26.69,-63.14,24.07),(-26.53,-63.31,24.14),(-26.39,-63.57,24.18),(-27.47,-64.11,23.56),(-27.24,-63.93,23.69),(-27.0,-63.92,23.81),(-27.9,-64.14,23.35),(-27.66,-64.63,23.38),(-28.01,-64.66,23.22),(-27.69,-65.16,23.28),(-27.93,-65.16,23.18),(-27.25,-65.5,23.44),(-26.89,-65.71,23.97),(-27.72,-65.57,23.21),(-27.13,-65.84,23.45),(-26.82,-65.92,23.72),(-26.51,-65.85,23.87),(-26.4,-65.62,24.15),(-27.41,-66.04,23.28),(-27.23,-66.22,23.34),(-26.98,-66.24,23.45),(-26.71,-66.28,23.58),(-26.4,-66.17,23.74),(-26.18,-65.9,23.88),(-23.46,-60.33,34.17),(-23.9,-61.01,22.9),(-33.99,-48.39,37.7),(-29.63,-47.05,13.13),(17.29,-41.46,17.06),(24.77,-34.73,15.31),(27.03,-42.12,16.25),(16.04,-38.58,17.29),(17.03,-41.27,22.38),(18.87,-39.93,25.84),(21.92,-39.65,25.09),(20.77,-37.91,26.03),(26.53,-41.99,22.84),(23.19,-36.45,23.91),(24.19,-35.37,20.93),(18.4,-38.66,23.36),(26.09,-42.27,9.944),(16.65,-41.51,11.51),(18.29,-40.3,8.26),(21.32,-40.08,7.985),(19.55,-38.4,7.041),(22.16,-36.84,7.8),(23.54,-35.69,10.34),(17.57,-39.07,10.39),(23.5,-50.08,7.354),(14.88,-52.65,11.19),(20.26,-48.58,6.227),(15.3,-51.19,8.803),(17.34,-54.87,14.59),(19.03,-56.73,18.41),(16.42,-45.25,17.67),(16.16,-50.32,18.12),(27.7,-46.58,17.05),(26.32,-49.59,16.23),(29.66,-45.84,10.51),(29.33,-47.59,14.15),(28.57,-47.31,7.721),(27.15,-49.17,10.26),(28.11,-43.57,10.87),(19.72,-59.05,18.75),(16.44,-45.22,23.71),(17.51,-53.68,23.88),(17.88,-44.46,27.74),(24.96,-46.16,28.66),(23.37,-43.06,26.25),(30.08,-45.59,22.3),(29.19,-46.93,25.41),(28.29,-47.95,24.06),(29.49,-47.49,19.0),(26.43,-49.54,18.26),(24.6,-48.41,28.92),(27.62,-46.31,27.71),(27.92,-44.33,26.01),(28.49,-43.33,21.86),(26.1,-44.27,28.44),(26.26,-43.08,26.9),(27.8,-42.65,23.35),(21.02,-47.87,29.07),(18.9,-47.93,29.24),(20.37,-55.56,22.25),(18.51,-48.51,32.96),(21.34,-53.84,25.62),(21.44,-57.67,21.46),(20.17,-51.64,33.71),(20.05,-52.43,30.34),(23.15,-53.49,17.96),(23.79,-52.84,24.55),(25.59,-50.99,22.19),(23.99,-51.42,17.84),(25.06,-51.62,15.86),(21.55,-54.38,19.85),(23.53,-55.93,17.97),(22.01,-57.16,20.47),(21.44,-54.56,16.3),(21.99,-57.17,16.21),(23.74,-52.9,14.32),(27.31,-42.95,9.289),(26.84,-46.79,5.44),(27.6,-44.55,6.749),(19.99,-55.6,13.9),(21.33,-57.79,14.91),(16.65,-55.3,11.0),(16.01,-45.49,11.01),(18.29,-54.22,15.49),(17.24,-44.89,7.565),(23.96,-47.44,5.792),(22.69,-43.47,6.956),(25.06,-45.47,5.144),(25.54,-43.53,5.863),(15.3,-51.26,8.268),(29.25,-44.75,10.66),(29.64,-44.51,22.06),(29.87,-47.1,16.62),(20.64,-54.47,13.1),(18.89,-47.94,28.69),(15.27,-51.23,8.249),(24.03,-51.03,28.61),(22.34,-53.19,11.93),(17.52,-55.32,14.5),(20.11,-52.92,30.7),(19.24,-55.14,22.93),(18.88,-55.1,12.76),(19.86,-57.56,16.29),(20.28,-58.49,15.26),(19.05,-56.28,16.35),(20.03,-57.64,20.28),(20.65,-58.24,21.53),(19.24,-56.24,20.22),(19.63,-58.36,18.65),(23.81,-49.83,34.8),(21.19,-49.46,36.23),(20.88,-48.49,34.28),(24.26,-47.4,36.23),(24.77,-46.03,32.78),(25.56,-49.12,32.78),(21.24,-37.74,30.57),(24.71,-37.98,31.96),(24.21,-38.32,35.25),(22.21,-38.57,36.56),(19.96,-42.04,35.07),(23.42,-36.52,29.74),(22.63,-34.93,31.14),(20.35,-36.14,34.19),(27.31,-38.53,29.95),(26.75,-37.33,27.63),(35.23,-36.55,22.2),(35.32,-37.75,23.8),(26.98,-35.96,28.57),(36.53,-35.2,24.05),(27.44,-34.35,31.03),(25.91,-34.23,30.49),(22.92,-34.45,32.55),(24.01,-35.2,34.6),(36.84,-36.07,25.62),(28.0,-35.67,32.71),(36.44,-37.16,25.59),(28.04,-37.12,32.69),(24.89,-36.37,35.11),(24.86,-37.7,34.66),(37.16,-38.89,21.32),(37.6,-39.41,21.83),(39.49,-37.91,21.98),(36.11,-38.33,21.75),(35.81,-39.07,22.85),(40.4,-36.32,22.38),(38.62,-39.61,18.8),(39.36,-39.61,21.12),(39.43,-40.23,21.04),(38.01,-39.13,17.81),(38.13,-38.74,18.59),(38.98,-38.89,18.62),(38.22,-38.66,17.93),(38.63,-39.17,19.34),(38.3,-38.34,17.37),(38.43,-37.98,18.16),(39.36,-38.1,18.78),(39.08,-38.35,19.13),(38.68,-37.86,17.59),(38.7,-37.7,18.15),(38.87,-37.39,18.91),(39.73,-37.46,19.18),(39.46,-37.68,19.62),(39.01,-37.2,18.33),(40.65,-37.85,21.0),(40.11,-37.97,20.99),(40.47,-37.2,20.99),(40.07,-37.48,20.44),(39.43,-37.18,19.76),(39.43,-36.82,20.2),(40.36,-36.88,20.57),(40.07,-37.05,20.88),(39.61,-36.68,19.76),(40.95,-36.91,21.3),(37.56,-39.37,22.98),(39.08,-39.52,23.83),(39.62,-38.51,23.86),(40.12,-37.17,23.1),(39.11,-39.49,18.86),(38.7,-39.27,18.25),(40.1,-40.04,21.61),(39.65,-39.83,19.79),(40.02,-39.45,20.83),(40.63,-39.25,21.16),(40.11,-39.0,19.57),(39.49,-38.68,18.58),(39.11,-38.52,18.07),(40.38,-38.62,20.81),(40.83,-38.42,21.34),(40.54,-38.29,20.19),(39.61,-37.82,18.68),(39.91,-38.02,19.16),(40.52,-37.37,20.44),(40.26,-37.27,20.04),(40.97,-37.54,21.2),(40.91,-37.43,22.04),(37.21,-40.19,19.7),(36.52,-40.98,19.05),(36.95,-41.02,19.3),(36.47,-39.89,20.02),(36.39,-41.15,19.65),(36.35,-40.46,20.77),(36.25,-39.79,21.68),(37.14,-40.4,20.96),(37.12,-40.67,20.5),(36.78,-41.2,19.84),(22.76,-49.38,36.06),(18.83,-54.29,7.072),(17.13,-54.22,7.223),(15.67,-52.52,4.978),(18.39,-52.06,3.244),(18.67,-49.68,4.828),(20.52,-52.87,6.913),(10.27,-44.36,6.612),(12.55,-43.17,3.08),(12.07,-44.72,0.7673),(10.65,-46.17,1.138),(11.63,-48.94,5.282),(10.49,-42.51,5.437),(8.375,-42.76,4.418),(7.905,-44.91,3.634),(14.14,-40.77,2.687),(12.74,-39.98,4.777),(14.67,-32.42,2.413),(15.98,-33.09,1.039),(11.27,-39.69,3.506),(13.18,-31.91,-0.1747),(9.519,-39.65,0.7312),(8.897,-40.39,2.32),(7.906,-42.84,2.88),(9.031,-43.15,0.5653),(14.14,-32.34,-1.721),(11.09,-40.27,-0.7951),(15.36,-32.77,-1.378),(12.7,-40.71,-0.488),(10.6,-43.26,-0.2064),(12.03,-43.68,0.5661),(17.32,-29.97,0.7085),(17.71,-29.63,-0.2017),(15.32,-29.08,-0.9442),(17.11,-31.08,1.326),(18.07,-31.3,0.3761),(13.26,-29.28,-1.485),(17.48,-27.52,0.7632),(17.18,-28.14,-1.038),(17.82,-27.92,-1.398),(17.15,-27.62,2.236),(16.69,-27.97,1.699),(16.55,-27.45,0.8385),(16.55,-27.67,2.125),(17.01,-27.85,0.5465),(16.16,-27.5,2.589),(15.74,-27.84,2.025),(15.55,-27.52,0.6672),(15.94,-27.75,0.579),(15.51,-27.5,2.262),(15.33,-27.76,1.885),(14.95,-28.06,1.298),(14.72,-27.65,0.2836),(15.07,-27.92,0.1422),(14.68,-27.8,1.655),(14.75,-27.9,-1.296),(15.11,-28.07,-0.752),(14.13,-28.17,-0.6515),(14.64,-27.97,-0.8372),(14.53,-28.13,0.2465),(14.15,-28.41,0.06629),(13.87,-28.03,-0.9357),(14.16,-28.26,-0.8372),(13.92,-28.17,0.2697),(13.6,-28.29,-1.175),(17.66,-30.06,-0.9848),(17.29,-29.25,-2.712),(15.99,-29.33,-2.818),(14.33,-29.33,-2.126),(17.17,-27.29,0.3095),(17.06,-27.36,1.219),(17.33,-27.96,-2.361),(17.35,-27.3,-1.047),(16.73,-27.74,-1.433),(16.28,-27.64,-2.179),(16.28,-27.17,-0.9539),(16.13,-27.2,0.4648),(16.08,-27.26,1.249),(15.69,-27.78,-1.371),(15.29,-27.89,-2.031),(15.33,-27.43,-1.464),(15.15,-27.42,0.6151),(15.26,-27.38,-0.08012),(14.34,-27.75,-1.082),(14.34,-27.76,-0.7084),(14.29,-27.92,-1.551),(14.2,-28.4,-1.924),(18.59,-29.03,1.881),(19.7,-29.0,2.685),(19.57,-28.78,2.173),(18.58,-29.73,2.177),(19.95,-29.2,2.202),(19.27,-29.81,1.449),(18.62,-30.39,0.9027),(18.88,-29.36,0.7677),(19.17,-29.14,1.115),(19.86,-28.97,1.76),(18.65,-53.85,5.541),(20.26,-48.58,6.205),(15.3,-51.19,8.782),(24.44,-30.35,14.99),(22.83,-29.24,15.9),(12.38,-33.85,17.7),(14.54,-27.91,17.21),(17.64,-27.03,16.81),(13.9,-36.8,17.66),(20.07,-35.32,5.187),(17.48,-36.9,7.512),(21.99,-32.9,6.775),(23.18,-31.28,10.82),(13.58,-37.06,12.23),(27.71,-10.65,-0.9058),(28.56,-14.96,0.6756),(24.42,-12.03,3.074),(27.59,-15.13,3.641),(28.57,-14.51,7.205),(25.58,-11.2,6.301),(28.56,-9.577,7.203),(30.35,-14.44,-1.171),(30.36,-13.74,8.348),(33.0,-12.87,7.235),(31.0,-8.679,2.578),(34.2,-12.77,3.13),(33.01,-13.42,-0.04218),(30.42,-17.99,-0.901),(30.47,-16.8,9.788),(32.78,-18.52,8.367),(33.95,-19.8,4.469),(32.74,-19.32,1.842),(25.54,-25.83,0.3523),(22.84,-23.41,1.152),(22.81,-20.63,4.311),(23.44,-20.03,9.274),(26.03,-22.98,12.59),(28.52,-25.21,11.33),(29.33,-26.97,7.55),(27.79,-27.03,3.605),(19.2,-33.33,4.281),(17.9,-28.27,1.391),(18.97,-24.66,5.243),(16.8,-25.64,13.83),(20.2,-24.52,13.35),(15.22,-34.28,5.062),(16.23,-31.26,2.691),(10.75,-32.47,8.273),(11.93,-34.05,8.814),(11.45,-35.19,15.98),(10.47,-33.38,15.26),(11.85,-32.05,17.65),(13.21,-31.14,18.52),(10.12,-30.78,9.311),(14.41,-25.53,7.25),(9.964,-30.53,15.27),(16.18,-25.38,10.95),(11.76,-29.64,17.48),(14.43,-29.39,19.24),(24.06,-5.639,-2.298),(22.29,-6.25,-0.9034),(21.54,-6.494,2.516),(22.3,-5.84,5.701),(24.07,-5.071,6.764),(25.77,-4.222,5.324),(26.44,-4.15,2.3),(25.74,-4.761,-1.062),(19.32,0.1591,-1.939),(17.87,-0.5267,-0.9856),(17.24,-0.7095,1.783),(17.89,-0.208,4.376),(19.34,0.6038,5.377),(20.9,1.314,4.049),(21.55,1.257,1.62),(20.88,0.8789,-1.073),(17.05,5.004,-1.244),(15.75,4.211,-1.004),(15.16,4.008,1.169),(15.73,4.464,2.449),(17.24,5.377,2.885),(18.5,6.055,2.009),(18.91,6.184,0.2307),(18.52,5.802,-1.032),(20.27,6.887,-1.924),(21.0,7.503,-0.2927),(23.4,8.996,-1.563),(20.87,8.508,-2.56),(20.36,7.213,1.482),(21.09,8.834,1.798),(23.55,9.184,0.5189),(18.39,6.912,3.094),(14.37,5.523,3.586),(14.11,6.507,2.918),(15.74,6.824,3.662),(13.72,5.166,0.9868),(13.52,6.213,0.7569),(14.03,4.856,-1.384),(13.87,6.168,-1.508),(18.3,6.052,-2.236),(15.55,6.348,-2.302),(20.75,9.191,-2.592),(23.72,9.966,-0.6283),(20.74,9.536,1.402),(14.6,4.292,-0.4674),(14.68,4.571,2.97),(13.75,8.3,0.8115),(13.73,8.209,-0.2831),(14.38,8.405,0.7329),(14.36,8.314,-0.3617),(17.78,-26.32,13.67),(20.85,-27.55,14.16),(22.15,-34.66,26.94),(19.25,-36.34,25.99),(23.67,-32.37,24.25),(24.02,-31.01,19.63),(14.62,-36.73,23.03),(24.34,-6.651,20.78),(24.58,-11.28,20.68),(20.45,-8.175,18.41),(23.23,-11.83,18.19),(23.8,-11.88,14.29),(21.28,-8.064,14.7),(24.28,-7.062,12.41),(26.59,-10.63,21.76),(25.46,-11.49,12.43),(28.24,-10.69,12.44),(27.36,-5.773,15.81),(29.93,-10.03,16.0),(29.12,-10.04,19.58),(27.06,-14.14,23.19),(25.74,-14.88,12.55),(28.56,-15.92,14.0),(30.44,-16.22,17.9),(29.39,-15.51,20.52),(24.72,-22.52,27.02),(21.28,-20.99,25.91),(20.07,-19.01,21.7),(20.05,-19.22,16.58),(23.25,-22.01,14.37),(26.39,-23.55,15.78),(28.15,-24.12,19.68),(27.02,-23.76,23.88),(20.37,-30.8,28.97),(18.12,-26.42,29.13),(13.46,-25.14,25.07),(18.28,-24.78,15.65),(17.49,-33.57,28.77),(16.44,-30.71,29.66),(12.55,-31.9,27.13),(13.61,-33.52,26.43),(11.83,-35.07,19.95),(11.0,-33.22,20.71),(12.98,-31.21,16.13),(11.72,-30.27,26.1),(11.11,-28.53,23.46),(10.46,-30.38,20.41),(12.44,-27.9,19.75),(11.78,-29.63,17.78),(13.99,-29.53,14.67),(21.65,-1.206,20.31),(19.66,-1.752,19.66),(18.45,-2.423,16.71),(18.88,-2.427,13.22),(20.58,-2.125,11.46),(22.55,-1.337,12.05),(23.6,-0.8774,14.73),(23.25,-0.8134,18.36),(17.93,4.844,18.01),(16.28,4.267,17.75),(15.28,3.753,15.35),(15.66,3.715,12.52),(17.08,4.1,10.87),(18.88,4.744,11.45),(19.81,4.98,13.64),(19.44,5.151,16.51),(16.45,9.433,15.41),(15.02,9.039,15.82),(14.11,8.6,13.81),(14.6,8.757,12.43),(16.29,9.125,11.26),(17.75,9.462,11.58),(18.43,9.699,13.24),(18.11,9.651,14.59),(19.94,11.0,14.66),(20.59,11.24,12.7),(23.32,12.48,12.86),(20.87,12.55,14.43),(19.73,10.8,11.24),(20.68,12.19,10.07),(23.28,12.33,10.76),(17.58,10.58,10.14),(13.35,9.795,10.94),(13.33,10.87,11.16),(14.91,10.81,10.04),(12.93,9.935,13.7),(12.94,11.0,13.46),(13.55,10.13,15.96),(13.51,11.23,15.59),(17.89,10.55,15.65),(15.26,11.26,16.0),(20.86,13.26,14.15),(23.71,13.17,11.48),(20.5,13.01,10.17),(13.79,9.242,15.32),(13.58,8.979,11.89),(13.51,13.16,12.34),(13.59,13.23,13.43),(14.15,13.16,12.27),(14.23,13.23,13.37),(28.28,-60.96,16.96),(24.19,-61.06,24.04),(22.48,-67.15,18.76),(25.67,-55.11,16.99),(27.96,-61.05,18.25),(27.43,-61.85,22.55),(26.17,-61.3,23.27),(28.28,-63.9,17.25),(26.69,-65.78,17.73),(23.93,-66.8,18.41),(28.94,-58.44,16.59),(27.87,-56.66,16.66),(27.47,-55.55,16.64),(20.73,-60.48,23.04),(21.9,-62.41,24.09),(16.62,-64.39,19.75),(17.68,-66.09,19.68),(20.87,-67.31,19.11),(18.04,-59.67,19.02),(20.12,-57.7,18.4),(22.38,-56.64,17.83),(23.95,-61.92,24.34),(22.31,-65.82,23.6),(22.49,-66.85,21.58),(25.22,-56.17,20.83),(24.92,-57.17,22.29),(24.43,-59.39,23.74),(27.54,-64.52,19.93),(26.09,-62.85,23.2),(24.22,-66.16,21.56),(28.69,-58.54,17.49),(26.84,-56.16,18.91),(26.43,-58.87,22.25),(17.98,-65.18,22.9),(19.57,-66.6,22.88),(20.81,-64.82,24.74),(22.9,-59.92,23.5),(23.36,-57.05,21.5),(25.42,-66.4,18.06),(28.55,-62.47,17.04),(28.37,-60.43,16.9),(28.42,-60.11,16.86),(28.68,-59.35,16.73),(27.95,-59.35,17.68),(27.87,-59.93,17.58),(28.99,-58.68,16.61),(28.5,-58.29,16.67),(28.11,-58.19,16.75),(28.48,-57.65,16.62),(27.86,-58.22,17.97),(28.08,-57.6,18.45),(27.55,-59.88,18.0),(27.61,-58.61,18.47),(27.03,-57.35,20.03),(26.22,-56.92,20.88),(26.68,-55.09,18.2),(27.95,-57.2,16.69),(27.42,-56.51,16.74),(27.4,-55.95,16.7),(27.08,-55.12,16.69),(23.62,-55.83,17.49),(27.28,-56.81,18.51),(28.45,-57.46,16.61),(28.1,-56.9,16.63),(27.85,-57.19,18.56),(28.31,-57.73,17.46),(27.84,-58.67,20.19),(28.21,-58.94,17.8),(28.86,-58.93,17.19),(27.69,-56.89,18.47),(28.25,-61.65,21.02),(27.46,-60.68,17.98),(26.44,-60.53,23.02),(28.47,-62.17,20.85),(27.67,-60.46,19.34),(27.84,-60.42,17.57),(27.69,-61.03,21.46),(27.46,-61.34,22.5),(27.63,-61.24,19.12),(28.5,-61.53,19.22),(26.91,-63.92,22.03),(26.41,-65.44,20.86),(26.86,-57.94,21.22),(21.56,-57.39,18.06),(28.59,-61.62,16.95),(26.67,-55.93,19.38),(27.88,-60.78,17.58),(28.6,-61.28,18.02),(28.7,-61.78,18.47),(26.94,-60.66,21.76),(27.49,-59.63,19.25),(26.85,-59.91,21.88),(27.88,-58.11,18.71),(15.9,-61.2,19.61),(17.05,-62.38,23.09),(19.09,-66.94,19.46),(17.15,-59.96,20.04),(16.61,-60.39,20.16),(16.02,-60.26,19.5),(15.61,-60.01,19.57),(14.55,-59.71,19.76),(13.62,-58.98,19.9),(12.65,-57.33,19.95),(10.58,-55.86,20.26),(10.69,-54.89,20.15),(10.95,-52.33,19.86),(11.79,-51.19,19.55),(13.83,-50.83,19.15),(14.41,-52.48,19.14),(16.37,-54.18,18.88),(17.43,-56.82,18.89),(16.51,-58.6,19.25),(17.24,-58.7,19.1),(17.61,-58.96,19.05),(12.56,-54.72,20.8),(14.51,-55.74,20.49),(16.97,-59.51,19.99),(14.23,-54.01,20.1),(13.18,-52.36,20.18),(14.88,-57.02,20.22),(15.09,-58.35,20.12),(16.17,-59.16,20.24),(12.39,-53.18,20.37),(15.41,-59.31,20.26),(15.97,-59.63,20.18),(16.45,-59.94,20.11),(21.0,-60.42,24.03),(21.09,-60.25,23.85),(21.29,-60.14,23.63),(21.45,-60.16,23.5),(21.67,-60.19,23.31),(21.85,-60.38,23.24),(21.97,-60.62,23.36),(20.95,-61.04,24.34),(21.16,-60.89,24.09),(21.38,-60.91,23.9),(21.45,-61.33,23.59),(21.58,-61.09,23.37),(21.97,-60.96,23.41),(20.56,-61.02,24.67),(20.77,-61.06,24.51),(20.92,-61.71,24.23),(21.72,-61.58,23.68),(21.79,-61.22,23.67),(20.45,-61.52,25.0),(20.93,-61.99,24.35),(21.44,-62.18,23.99),(21.83,-62.1,23.97),(20.52,-62.0,25.16),(20.73,-62.03,24.99),(21.13,-62.41,24.81),(21.39,-62.69,24.27),(21.54,-62.58,24.08),(20.69,-62.43,25.2),(21.49,-62.88,24.55),(21.77,-62.84,24.29),(21.82,-62.66,23.98),(22.11,-62.65,24.11),(20.97,-62.92,25.18),(21.13,-63.11,25.13),(21.36,-63.15,24.95),(21.61,-63.22,24.77),(21.89,-63.15,24.49),(22.09,-62.91,24.2),(21.07,-60.38,24.26),(21.16,-60.21,24.08),(21.37,-60.11,23.86),(21.75,-60.16,23.54),(21.89,-60.33,23.48),(21.03,-61.01,24.57),(21.23,-60.85,24.32),(21.46,-60.88,24.13),(20.64,-60.99,24.9),(20.84,-61.49,24.95),(21.0,-61.95,24.58),(20.53,-61.49,25.23),(20.6,-61.97,25.39),(20.81,-62.0,25.22),(21.21,-62.38,25.04),(21.47,-62.65,24.5),(20.77,-62.39,25.43),(21.31,-62.72,25.11),(21.57,-62.85,24.78),(21.85,-62.81,24.52),(21.05,-62.88,25.41),(21.21,-63.07,25.36),(21.44,-63.12,25.18),(21.68,-63.19,25.0),(21.96,-63.11,24.72),(22.16,-62.88,24.43),(22.95,-61.44,11.94),(27.72,-61.13,15.88),(26.37,-62.17,12.15),(25.01,-61.66,11.89),(19.97,-60.4,14.24),(20.78,-62.59,13.09),(22.91,-62.41,11.88),(21.33,-66.12,13.96),(21.87,-66.89,15.72),(24.48,-56.2,13.86),(23.93,-57.48,12.61),(23.22,-59.76,11.83),(27.48,-64.64,14.59),(24.75,-63.55,12.13),(23.55,-66.26,15.18),(28.52,-58.59,15.86),(26.43,-56.28,14.86),(25.42,-59.18,12.33),(17.31,-65.38,16.33),(18.87,-66.82,15.94),(19.64,-65.27,13.14),(21.81,-60.25,12.78),(22.6,-57.29,13.99),(27.79,-59.4,16.13),(27.74,-59.96,16.36),(27.63,-58.29,15.69),(27.73,-57.71,15.04),(27.36,-59.94,16.09),(27.3,-58.71,15.39),(26.41,-57.54,13.92),(25.41,-56.86,13.52),(26.37,-55.17,15.2),(26.94,-56.91,15.17),(27.48,-57.3,14.95),(28.15,-57.78,15.91),(27.17,-58.88,13.59),(28.01,-59.0,15.83),(28.75,-58.96,16.15),(27.35,-57.0,15.05),(27.46,-61.89,13.23),(27.29,-60.73,16.29),(25.31,-60.88,11.88),(27.71,-62.4,13.4),(27.22,-60.62,14.92),(27.73,-60.45,16.47),(26.84,-61.31,13.06),(26.41,-61.64,12.21),(27.23,-61.36,15.23),(28.05,-61.66,14.82),(25.93,-64.28,13.38),(25.77,-65.53,14.81),(26.05,-58.23,13.17),(26.14,-55.89,14.56),(27.77,-60.81,16.51),(28.38,-61.35,15.88),(28.39,-61.87,15.5),(25.95,-60.99,13.04),(27.07,-59.81,15.02),(25.92,-60.2,12.69),(27.53,-58.35,14.97),(16.34,-62.6,16.03),(16.99,-60.01,18.47),(16.46,-60.43,18.65),(12.8,-55.99,19.07),(14.36,-56.99,18.84),(16.82,-59.56,18.51),(14.62,-54.56,18.29),(13.12,-52.36,18.61),(14.94,-58.19,18.98),(16.0,-59.18,18.67),(11.9,-53.9,18.87),(15.27,-59.36,18.86),(15.83,-59.67,18.77),(16.3,-59.99,18.69),(19.89,-60.76,13.16),(20.01,-60.58,13.25),(20.25,-60.46,13.37),(20.42,-60.47,13.43),(20.68,-60.5,13.52),(20.82,-60.67,13.55),(20.94,-60.94,13.54),(19.8,-61.39,12.99),(20.04,-61.23,13.12),(20.29,-61.25,13.21),(20.43,-61.64,13.54),(20.59,-61.39,13.66),(20.93,-61.28,13.37),(19.35,-61.39,12.83),(19.59,-61.43,12.91),(19.8,-62.06,13.22),(20.66,-61.89,13.41),(20.74,-61.56,13.29),(19.19,-61.9,12.66),(19.79,-62.34,13.15),(20.35,-62.51,13.32),(19.24,-62.4,12.56),(19.47,-62.42,12.64),(19.9,-62.79,12.71),(20.26,-63.03,13.16),(20.44,-62.91,13.26),(19.4,-62.82,12.52),(20.3,-63.24,12.89),(20.62,-63.19,13.01),(20.76,-62.99,13.35),(21.06,-63.03,12.96),(19.68,-63.31,12.51),(19.85,-63.5,12.53),(20.1,-63.54,12.61),(20.38,-63.6,12.7),(20.7,-63.51,12.83),(20.94,-63.26,12.98),(19.87,-60.7,12.91),(20.03,-60.56,13.0),(20.27,-60.44,13.11),(20.7,-60.48,13.26),(20.85,-60.65,13.29),(20.97,-60.92,13.29),(19.82,-61.38,12.73),(20.07,-61.21,12.86),(20.32,-61.23,12.95),(19.38,-61.37,12.57),(19.58,-61.88,12.53),(19.22,-61.89,12.4),(19.5,-62.4,12.38),(19.26,-62.38,12.3),(19.93,-62.77,12.45),(20.29,-63.02,12.91),(19.43,-62.81,12.26),(20.01,-63.12,12.4),(20.33,-63.23,12.63),(20.65,-63.18,12.76),(20.79,-62.96,13.05),(19.71,-63.3,12.25),(19.88,-63.48,12.27),(20.13,-63.52,12.35),(20.41,-63.58,12.44),(20.73,-63.49,12.58),(20.97,-63.25,12.72),(24.67,-58.24,23.22),(23.59,-58.45,11.99),(20.43,-41.99,30.98),(13.51,-47.35,8.102),(80.24,-44.88,10.21),(87.49,-37.95,8.695),(90.02,-45.23,10.43),(78.85,-42.04,10.09),(79.71,-44.57,15.47),(81.32,-43.08,19.0),(84.37,-42.71,18.54),(83.11,-41.0,19.22),(89.19,-44.95,16.95),(85.56,-39.5,17.25),(86.66,-38.46,14.28),(80.91,-41.89,16.38),(89.4,-45.57,4.068),(79.88,-45.09,4.616),(81.62,-43.91,1.45),(84.65,-43.59,1.465),(82.86,-42.0,0.215),(85.35,-40.33,1.113),(86.55,-39.08,3.7),(80.75,-42.65,3.404),(87.29,-53.52,1.833),(79.74,-54.23,0.2203),(84.05,-52.16,0.2654),(81.22,-52.38,-1.322),(81.67,-57.75,4.157),(82.58,-60.03,12.92),(79.52,-48.68,11.03),(79.46,-53.74,11.84),(90.84,-49.63,11.65),(89.64,-52.71,10.93),(93.09,-48.99,5.268),(92.65,-50.66,8.995),(92.21,-50.57,2.496),(90.75,-52.41,5.025),(91.42,-46.77,5.292),(83.36,-62.32,13.5),(79.23,-48.49,17.04),(80.66,-56.9,17.97),(80.44,-47.59,21.15),(87.52,-49.02,22.91),(85.91,-46.04,20.1),(92.91,-48.43,17.05),(91.93,-49.73,20.16),(90.52,-51.63,18.45),(92.58,-50.43,13.84),(89.65,-52.61,12.96),(86.12,-52.49,21.7),(90.22,-49.1,22.24),(90.52,-47.16,20.43),(91.25,-46.25,16.27),(88.58,-47.1,22.65),(88.77,-45.95,21.04),(90.45,-45.55,17.63),(83.64,-50.85,23.05),(81.53,-50.98,23.02),(83.67,-58.72,16.78),(79.77,-53.34,23.85),(84.02,-57.78,16.3),(84.88,-60.81,16.27),(81.46,-56.49,24.17),(81.91,-56.92,20.67),(86.57,-56.67,12.63),(86.48,-56.63,16.17),(88.42,-54.54,14.9),(87.32,-54.57,12.44),(88.49,-54.79,10.59),(84.92,-57.57,14.42),(87.05,-59.09,12.86),(85.47,-60.31,15.31),(84.99,-57.83,10.88),(85.66,-60.42,11.06),(87.31,-56.15,9.016),(90.68,-46.22,3.592),(90.57,-50.16,0.007102),(91.17,-47.87,1.215),(83.71,-58.98,8.428),(85.1,-61.1,9.74),(81.3,-57.6,0.2868),(79.44,-49.1,4.361),(82.56,-57.27,5.347),(80.81,-48.54,1.007),(88.7,-49.86,-0.654),(86.22,-46.96,0.8419),(89.61,-47.93,-0.7905),(89.11,-46.95,0.04372),(81.3,-52.43,-1.852),(92.62,-47.92,5.293),(92.44,-47.37,16.67),(93.05,-50.09,11.47),(84.35,-57.86,7.606),(81.54,-51.01,22.47),(81.28,-52.39,-1.874),(86.08,-55.14,20.62),(86.86,-55.85,3.453),(81.87,-58.19,4.004),(81.96,-57.43,20.91),(82.5,-58.33,17.32),(82.64,-58.56,7.148),(83.55,-60.89,10.95),(84.06,-61.82,10.04),(82.69,-59.63,10.83),(83.53,-60.86,14.95),(84.11,-61.4,16.31),(82.68,-59.49,14.7),(83.23,-61.63,13.34),(84.71,-54.71,26.89),(82.16,-55.03,27.21),(83.27,-51.35,28.27),(83.91,-52.22,29.04),(84.05,-50.34,26.16),(86.66,-53.76,25.7),(76.12,-44.45,24.23),(79.04,-43.12,26.32),(78.76,-44.15,29.39),(77.16,-45.38,30.17),(77.41,-49.11,27.49),(76.81,-42.03,24.22),(74.89,-41.67,25.84),(74.16,-44.02,27.91),(81.2,-40.84,24.9),(79.73,-40.13,22.84),(84.15,-33.37,20.24),(85.39,-34.08,21.68),(78.64,-39.28,24.19),(83.27,-32.07,22.61),(77.48,-38.35,27.14),(76.41,-39.15,26.25),(74.69,-41.38,27.43),(76.09,-41.52,29.47),(84.28,-32.44,24.13),(79.05,-39.05,28.55),(85.26,-33.21,23.86),(80.4,-39.91,28.15),(77.7,-41.82,29.85),(78.83,-42.64,29.02),(87.66,-31.83,20.22),(88.25,-31.54,20.9),(86.48,-30.02,21.53),(87.0,-32.75,20.23),(87.83,-33.15,21.27),(84.58,-29.37,22.19),(88.74,-30.1,18.33),(88.52,-29.97,20.84),(89.25,-29.91,20.89),(88.29,-30.37,17.0),(87.76,-30.42,17.7),(87.91,-29.76,18.17),(87.72,-30.21,17.12),(88.18,-30.19,18.73),(87.4,-30.03,16.57),(86.9,-30.08,17.28),(86.96,-29.46,18.34),(87.23,-29.77,18.58),(86.81,-29.76,16.85),(86.56,-29.85,17.35),(86.13,-29.87,18.06),(86.18,-29.24,18.74),(86.39,-29.55,19.07),(85.96,-29.63,17.55),(86.44,-28.88,20.98),(86.58,-29.32,20.77),(85.66,-29.05,20.83),(86.08,-29.22,20.09),(85.79,-29.58,19.08),(85.34,-29.66,19.41),(85.35,-29.0,20.22),(85.52,-29.29,20.4),(85.21,-29.43,19.05),(85.27,-28.75,21.31),(88.17,-31.72,22.0),(88.36,-30.57,23.28),(87.15,-30.17,23.44),(85.58,-29.69,22.81),(88.59,-29.72,18.6),(88.39,-29.92,17.78),(88.98,-29.46,21.68),(88.88,-29.48,19.8),(88.34,-29.39,20.8),(88.08,-28.94,21.34),(87.93,-29.05,19.63),(87.65,-29.34,18.35),(87.52,-29.53,17.65),(87.36,-29.08,20.81),(87.09,-28.81,21.47),(87.03,-28.81,20.26),(86.65,-29.24,18.3),(86.82,-29.1,18.94),(85.93,-28.86,20.29),(85.86,-28.98,19.77),(86.06,-28.66,21.26),(85.86,-28.88,22.05),(89.25,-31.57,18.77),(90.21,-32.06,17.98),(90.24,-31.74,18.36),(88.9,-32.22,18.81),(90.39,-32.25,18.53),(89.54,-32.43,19.55),(88.72,-32.63,20.34),(89.46,-31.8,19.99),(89.8,-31.76,19.55),(90.44,-31.95,18.85),(83.54,-54.48,27.79),(83.96,-56.34,-2.649),(82.31,-55.91,-3.165),(81.84,-53.58,-5.248),(84.89,-53.82,-5.745),(85.61,-51.78,-3.448),(85.87,-55.2,-1.765),(80.0,-44.36,-3.489),(83.13,-44.1,-6.073),(82.32,-45.18,-8.757),(80.35,-46.04,-9.052),(79.42,-48.98,-5.276),(81.31,-43.09,-4.098),(79.61,-42.33,-5.762),(78.11,-43.98,-7.143),(85.77,-43.38,-5.241),(84.78,-42.08,-3.433),(91.76,-36.95,-3.065),(92.5,-38.18,-4.162),(84.02,-41.12,-5.023),(91.54,-35.75,-5.874),(83.14,-40.24,-8.212),(81.88,-40.57,-7.047),(79.44,-42.17,-7.408),(80.57,-42.92,-9.4),(92.24,-36.61,-7.177),(84.26,-41.49,-9.384),(92.74,-37.61,-6.584),(85.21,-42.63,-8.724),(81.92,-43.73,-9.717),(82.69,-44.74,-8.66),(95.31,-37.32,-3.066),(96.0,-37.5,-3.637),(95.84,-35.44,-4.665),(93.97,-37.62,-3.081),(94.34,-38.49,-3.808),(94.97,-33.96,-5.813),(97.55,-36.45,-1.674),(97.48,-36.51,-3.761),(98.06,-36.9,-3.777),(96.77,-36.27,-0.6243),(96.49,-36.09,-1.531),(97.22,-35.73,-1.875),(96.53,-35.85,-0.9754),(97.16,-36.26,-2.301),(96.35,-35.48,-0.571),(96.1,-35.31,-1.481),(96.82,-35.01,-2.427),(96.81,-35.41,-2.557),(96.21,-34.98,-1.082),(96.06,-34.97,-1.676),(95.87,-34.81,-2.552),(96.53,-34.45,-3.147),(96.48,-34.83,-3.371),(95.86,-34.49,-2.125),(96.92,-34.53,-4.508),(96.74,-34.87,-4.001),(96.26,-34.15,-4.226),(96.63,-34.52,-4.369),(96.04,-34.52,-3.65),(95.72,-34.37,-4.165),(96.3,-33.97,-4.768),(96.17,-34.3,-4.751),(95.76,-34.09,-3.871),(96.08,-33.8,-4.913),(95.79,-37.71,-4.537),(96.83,-37.08,-5.887),(96.3,-36.11,-6.37),(95.49,-34.81,-6.163),(97.8,-36.12,-1.976),(97.35,-36.07,-1.299),(98.09,-36.57,-4.829),(98.38,-36.25,-3.082),(97.84,-35.99,-3.997),(97.97,-35.62,-4.751),(98.03,-35.38,-3.259),(97.41,-35.3,-2.13),(97.04,-35.29,-1.53),(97.39,-35.22,-4.262),(97.31,-34.96,-5.04),(97.6,-34.79,-4.236),(96.78,-34.66,-2.521),(97.11,-34.72,-3.043),(96.79,-34.19,-4.469),(96.65,-34.2,-4.203),(96.79,-34.19,-4.883),(96.37,-34.32,-5.513),(96.46,-37.89,-1.073),(96.73,-38.71,-0.003417),(97.03,-38.52,-0.3979),(95.69,-38.19,-1.159),(96.75,-38.99,-0.4858),(96.06,-38.76,-1.692),(95.36,-38.53,-2.68),(96.52,-38.29,-2.202),(96.77,-38.4,-1.683),(97.05,-38.84,-0.8063),(84.17,-55.74,-4.046),(84.05,-52.16,0.2438),(81.22,-52.39,-1.343),(86.99,-33.59,8.002),(85.41,-33.19,8.325),(74.98,-37.44,9.763),(76.9,-31.44,9.03),(79.97,-30.47,8.877),(76.63,-40.33,10.1),(83.33,-38.96,-1.82),(80.7,-40.56,0.3588),(85.06,-36.44,-0.2308),(85.97,-34.67,3.792),(76.59,-40.74,4.679),(93.99,-13.52,-9.282),(91.82,-17.6,-7.319),(90.22,-12.85,-5.664),(90.78,-17.2,-4.463),(91.89,-16.94,-0.8388),(91.61,-12.6,-2.349),(95.11,-12.68,-1.161),(93.73,-17.99,-8.997),(93.84,-17.02,0.452),(96.68,-17.43,-0.424),(97.88,-13.34,-5.506),(97.91,-17.99,-4.399),(96.6,-18.18,-7.649),(92.47,-21.82,-8.476),(92.64,-20.58,2.198),(94.81,-22.44,0.7832),(95.92,-23.75,-3.121),(94.72,-23.23,-5.742),(87.71,-29.75,-7.212),(84.9,-27.43,-6.351),(84.77,-24.65,-3.167),(85.42,-24.04,1.79),(88.14,-26.93,5.047),(90.72,-29.07,3.737),(91.6,-30.78,-0.07659),(90.04,-30.87,-4.002),(81.82,-37.39,-3.17),(80.29,-32.4,-6.079),(81.16,-28.8,-2.217),(79.2,-29.8,6.375),(82.45,-28.63,5.874),(78.46,-38.09,-2.514),(78.8,-35.38,-4.732),(73.76,-36.35,0.09293),(74.98,-37.88,0.8744),(74.2,-38.85,8.053),(73.18,-37.1,7.095),(74.38,-35.66,9.517),(75.64,-34.68,10.45),(73.0,-34.66,0.9325),(76.76,-29.77,-0.1582),(72.55,-34.27,6.837),(78.53,-29.57,3.514),(74.18,-33.26,9.155),(76.75,-32.87,11.15),(94.59,-7.83,-11.41),(92.69,-7.372,-10.22),(91.78,-7.028,-6.907),(92.73,-6.733,-3.672),(94.65,-6.946,-2.422),(96.66,-7.184,-3.675),(97.36,-7.602,-6.601),(96.5,-7.901,-10.01),(94.87,-0.9302,-11.98),(93.19,-0.7189,-11.18),(92.44,-0.4249,-8.502),(93.22,-0.2213,-5.862),(94.92,-0.2385,-4.718),(96.72,-0.5021,-5.872),(97.29,-0.9825,-8.201),(96.59,-1.079,-10.95),(96.1,4.421,-11.87),(94.51,4.204,-11.71),(93.82,4.326,-9.591),(94.53,4.542,-8.278),(96.34,4.811,-7.745),(97.84,4.925,-8.535),(98.34,4.832,-10.28),(97.83,4.596,-11.56),(99.84,5.551,-12.43),(100.7,5.966,-10.76),(103.5,6.737,-11.93),(101.0,6.91,-13.07),(99.96,5.906,-9.033),(101.2,7.252,-8.717),(103.7,6.919,-9.843),(97.94,6.141,-7.539),(93.64,5.924,-7.276),(93.75,6.87,-7.985),(95.38,6.741,-7.14),(92.98,5.745,-9.913),(93.15,6.716,-10.18),(93.32,5.411,-12.28),(93.51,6.52,-12.41),(97.69,5.242,-12.84),(95.17,6.22,-13.09),(101.1,7.588,-13.14),(104.2,7.602,-11.01),(101.1,7.999,-9.161),(93.51,4.722,-11.28),(93.62,5.044,-7.86),(94.03,8.61,-10.17),(94.0,8.506,-11.26),(94.67,8.546,-10.21),(94.65,8.443,-11.3),(80.21,-30.44,6.193),(83.31,-31.59,6.636),(84.3,-37.68,20.01),(81.52,-39.48,18.91),(85.84,-35.41,17.31),(86.36,-34.16,12.64),(77.07,-40.11,15.52),(79.74,-12.14,14.85),(83.35,-15.18,13.88),(78.16,-15.55,12.62),(82.6,-16.32,11.45),(82.72,-15.98,7.512),(78.28,-14.91,8.883),(79.26,-12.34,6.484),(84.42,-13.58,14.85),(83.48,-14.72,5.561),(84.93,-12.55,5.424),(80.6,-9.608,9.765),(86.0,-11.17,8.887),(85.69,-11.69,12.53),(86.38,-15.92,15.76),(85.01,-16.81,5.179),(88.08,-17.22,6.412),(90.09,-17.21,10.21),(88.95,-16.75,12.92),(85.75,-24.46,19.28),(82.09,-23.35,18.22),(80.53,-21.49,14.11),(80.51,-21.66,8.991),(84.15,-23.99,6.648),(87.53,-25.14,7.982),(89.38,-25.55,11.86),(88.22,-25.38,16.09),(82.25,-33.83,21.56),(79.73,-29.2,21.31),(75.31,-28.52,16.54),(79.72,-27.44,7.863),(79.51,-36.7,21.29),(78.29,-33.86,21.84),(74.6,-35.25,19.03),(75.76,-36.84,18.55),(74.38,-38.61,12.04),(73.42,-36.78,12.57),(75.54,-34.82,8.049),(73.75,-33.68,17.78),(73.2,-32.03,14.96),(72.78,-33.97,11.99),(74.68,-31.44,11.35),(74.2,-33.24,9.452),(76.55,-33.14,6.562),(73.2,-10.15,15.77),(72.3,-11.76,15.23),(71.81,-12.93,12.3),(71.76,-12.61,8.794),(72.45,-11.31,6.936),(73.11,-9.547,7.461),(73.67,-8.616,10.1),(73.73,-8.843,13.74),(64.98,-8.545,15.16),(64.42,-9.984,14.96),(64.02,-10.93,12.58),(64.02,-10.67,9.728),(64.41,-9.476,8.029),(65.03,-7.898,8.551),(65.64,-7.174,10.67),(65.52,-7.343,13.59),(58.98,-6.595,13.74),(58.81,-7.89,14.19),(58.59,-8.738,12.17),(58.6,-8.303,10.8),(58.89,-6.858,9.583),(59.15,-5.581,9.843),(59.31,-4.937,11.47),(59.34,-5.2,12.83),(58.62,-3.249,12.99),(58.48,-2.704,11.04),(58.29,-0.08402,11.21),(57.34,-1.941,12.97),(58.48,-3.517,9.577),(57.3,-2.249,8.593),(58.27,-0.1822,9.095),(57.77,-5.271,8.619),(56.87,-8.794,9.611),(55.79,-8.392,10.03),(56.43,-7.227,8.787),(56.74,-9.027,12.4),(55.67,-8.622,12.37),(57.03,-8.49,14.65),(55.85,-8.089,14.48),(58.37,-4.997,14.06),(56.58,-6.741,14.75),(56.54,-1.643,12.82),(57.64,0.4853,9.926),(56.34,-2.037,8.848),(57.95,-8.676,13.81),(57.82,-8.93,10.37),(53.38,-7.323,11.57),(53.42,-7.227,12.66),(53.65,-6.83,11.46),(53.69,-6.734,12.55),(92.06,-63.97,12.73),(87.63,-64.04,19.38),(86.46,-70.31,14.42),(89.2,-58.22,12.04),(91.68,-64.05,14.0),(90.97,-64.75,18.29),(89.66,-64.23,18.84),(92.18,-66.9,13.25),(90.65,-68.82,13.72),(87.91,-69.91,14.2),(92.62,-61.45,12.24),(91.48,-59.7,12.06),(91.03,-58.61,11.92),(84.21,-63.6,17.99),(85.41,-65.46,19.31),(80.45,-67.73,14.6),(81.58,-69.39,14.77),(84.85,-70.52,14.62),(81.69,-62.98,13.65),(83.71,-60.96,13.09),(85.94,-59.84,12.66),(87.42,-64.9,19.72),(85.99,-68.87,19.12),(86.32,-69.93,17.21),(88.61,-59.2,15.91),(88.27,-60.17,17.41),(87.82,-62.37,18.98),(91.34,-67.48,15.9),(89.65,-65.78,18.88),(88.01,-69.18,17.31),(92.33,-61.53,13.12),(90.32,-59.18,14.16),(89.86,-61.82,17.65),(81.68,-68.39,17.94),(83.33,-69.75,18.19),(84.39,-67.89,20.03),(86.33,-62.95,18.62),(86.76,-60.13,16.45),(89.39,-69.47,13.96),(92.39,-65.47,12.96),(92.12,-63.44,12.64),(92.16,-63.12,12.58),(92.39,-62.35,12.42),(91.63,-62.36,13.29),(91.57,-62.94,13.23),(92.68,-61.68,12.27),(92.17,-61.31,12.26),(91.78,-61.22,12.29),(92.13,-60.67,12.16),(91.47,-61.22,13.48),(91.64,-60.59,13.93),(91.23,-62.9,13.61),(91.21,-61.62,13.99),(90.5,-60.34,15.38),(89.63,-59.91,16.12),(90.15,-58.14,13.35),(91.58,-60.24,12.14),(91.02,-59.56,12.08),(90.97,-59.01,11.99),(90.62,-58.19,11.89),(87.16,-59.0,12.39),(90.8,-59.82,13.85),(92.1,-60.48,12.13),(91.72,-59.94,12.07),(91.38,-60.18,14.0),(91.92,-60.74,12.98),(91.35,-61.62,15.73),(91.86,-61.93,13.41),(92.53,-61.92,12.86),(91.22,-59.89,13.86),(91.86,-64.56,16.83),(91.18,-63.69,13.64),(89.91,-63.46,18.55),(92.11,-65.07,16.72),(91.31,-63.43,15.0),(91.57,-63.43,13.25),(91.25,-63.95,17.16),(90.98,-64.24,18.2),(91.31,-64.22,14.84),(92.19,-64.47,15.05),(90.58,-66.84,17.88),(90.2,-68.41,16.77),(90.3,-60.9,16.6),(85.15,-60.61,12.88),(92.4,-64.62,12.81),(90.11,-58.95,14.59),(91.62,-63.79,13.3),(92.34,-64.26,13.85),(92.44,-64.74,14.34),(90.48,-63.59,17.36),(91.1,-62.61,14.83),(90.35,-62.85,17.41),(91.45,-61.1,14.21),(79.6,-64.57,14.14),(80.63,-65.62,17.82),(83.03,-70.19,14.76),(80.77,-63.28,14.6),(80.25,-63.72,14.7),(79.68,-63.63,13.97),(79.26,-63.39,13.98),(78.18,-63.12,14.04),(77.22,-62.43,14.02),(76.17,-60.81,13.85),(74.03,-59.41,13.84),(74.1,-58.44,13.66),(74.26,-55.88,13.2),(75.07,-54.72,12.89),(77.1,-54.3,12.67),(77.76,-55.93,12.85),(79.79,-57.57,12.92),(80.97,-60.17,13.24),(80.11,-61.96,13.64),(80.85,-62.04,13.58),(81.23,-62.29,13.58),(75.92,-58.18,14.49),(77.93,-59.15,14.46),(80.58,-62.84,14.49),(77.59,-57.44,13.9),(76.47,-55.82,13.75),(78.36,-60.42,14.32),(78.64,-61.74,14.34),(79.74,-62.51,14.64),(75.71,-56.67,13.92),(79.0,-62.69,14.6),(79.57,-62.98,14.6),(80.06,-63.28,14.6),(84.42,-63.5,19.0),(84.51,-63.33,18.82),(84.73,-63.23,18.61),(84.89,-63.24,18.5),(85.13,-63.27,18.33),(85.32,-63.46,18.3),(85.44,-63.69,18.45),(84.39,-64.12,19.35),(84.6,-63.96,19.11),(84.84,-63.99,18.95),(84.94,-64.41,18.68),(85.07,-64.17,18.45),(85.45,-64.03,18.53),(83.98,-64.1,19.64),(84.2,-64.14,19.51),(84.4,-64.79,19.3),(85.22,-64.64,18.81),(85.27,-64.29,18.78),(83.88,-64.6,20.0),(84.41,-65.06,19.44),(84.95,-65.25,19.14),(85.33,-65.16,19.15),(83.96,-65.07,20.2),(84.18,-65.1,20.06),(84.61,-65.47,19.95),(84.91,-65.75,19.45),(85.06,-65.64,19.28),(84.15,-65.49,20.29),(85.0,-65.93,19.76),(85.29,-65.89,19.53),(85.34,-65.72,19.21),(85.63,-65.69,19.36),(84.45,-65.97,20.34),(84.62,-66.15,20.32),(84.86,-66.2,20.17),(85.12,-66.26,20.01),(85.41,-66.19,19.76),(85.61,-65.95,19.48),(84.49,-63.46,19.23),(84.58,-63.29,19.06),(84.79,-63.19,18.84),(85.19,-63.23,18.57),(85.34,-63.4,18.53),(84.46,-64.08,19.59),(84.67,-63.92,19.34),(84.9,-63.95,19.18),(84.05,-64.06,19.88),(84.27,-64.56,19.99),(84.47,-65.02,19.67),(83.94,-64.56,20.23),(84.03,-65.03,20.44),(84.25,-65.06,20.29),(84.67,-65.43,20.18),(84.97,-65.71,19.69),(84.22,-65.45,20.53),(84.78,-65.76,20.29),(85.06,-65.89,20.0),(85.35,-65.85,19.76),(84.52,-65.93,20.58),(84.69,-66.11,20.55),(84.93,-66.16,20.4),(85.18,-66.22,20.25),(85.47,-66.15,19.99),(85.68,-65.91,19.71),(87.02,-64.76,7.225),(91.56,-64.19,11.61),(90.45,-65.37,7.841),(89.08,-64.91,7.402),(83.88,-63.77,9.141),(84.85,-65.96,8.251),(87.02,-65.73,7.242),(85.51,-69.44,9.439),(85.99,-70.15,11.31),(88.21,-59.43,8.89),(87.79,-60.76,7.689),(87.22,-63.08,7.013),(91.54,-67.74,10.58),(88.9,-66.81,7.768),(87.66,-69.47,10.89),(92.25,-61.63,11.48),(90.11,-59.42,10.09),(89.36,-62.41,7.689),(81.35,-68.78,11.34),(82.99,-70.17,11.22),(83.83,-68.66,8.385),(85.79,-63.59,7.862),(86.38,-60.58,8.918),(91.55,-62.45,11.74),(91.51,-63.01,12.01),(91.35,-61.36,11.2),(91.47,-60.79,10.51),(91.14,-63.01,11.69),(91.06,-61.8,10.89),(90.19,-60.7,9.252),(89.19,-60.06,8.699),(89.99,-58.3,10.34),(90.63,-60.02,10.5),(91.2,-60.4,10.36),(91.84,-60.83,11.43),(91.02,-62.02,9.103),(91.76,-62.05,11.43),(92.48,-61.98,11.81),(91.05,-60.1,10.43),(91.47,-65.02,9.01),(91.09,-63.79,11.94),(89.35,-64.12,7.368),(91.73,-65.52,9.237),(91.09,-63.72,10.57),(91.51,-63.5,12.15),(90.83,-64.47,8.724),(90.46,-64.83,7.867),(91.12,-64.46,10.93),(91.97,-64.74,10.63),(90.04,-67.46,9.189),(89.87,-68.68,10.7),(89.91,-61.42,8.524),(89.82,-59.04,9.731),(91.57,-63.86,12.22),(92.23,-64.39,11.69),(92.29,-64.92,11.36),(89.94,-64.18,8.598),(90.9,-62.92,10.59),(89.88,-63.4,8.177),(91.29,-61.45,10.47),(80.27,-66.04,10.73),(80.69,-63.37,13.02),(80.17,-63.81,13.18),(76.3,-59.49,12.89),(77.92,-60.44,12.89),(80.5,-62.93,13.02),(78.09,-58.02,12.18),(76.49,-55.87,12.18),(78.54,-61.62,13.18),(79.66,-62.57,13.06),(75.33,-57.44,12.44),(78.93,-62.77,13.19),(79.5,-63.07,13.17),(79.99,-63.37,13.17),(83.88,-64.15,8.081),(83.98,-63.97,8.175),(84.21,-63.84,8.303),(84.38,-63.85,8.381),(84.63,-63.86,8.496),(84.78,-64.02,8.557),(84.92,-64.29,8.586),(83.82,-64.8,7.955),(84.05,-64.62,8.093),(84.3,-64.63,8.208),(84.43,-65.01,8.589),(84.58,-64.75,8.701),(84.93,-64.63,8.438),(83.39,-64.81,7.751),(83.62,-64.84,7.853),(83.84,-65.45,8.236),(84.69,-65.25,8.493),(84.75,-64.92,8.358),(83.26,-65.34,7.599),(83.84,-65.73,8.188),(84.41,-65.89,8.424),(83.33,-65.83,7.544),(83.56,-65.84,7.647),(84.0,-66.19,7.791),(84.35,-66.41,8.302),(84.52,-66.29,8.403),(83.51,-66.25,7.558),(84.41,-66.63,8.047),(84.72,-66.57,8.202),(84.83,-66.35,8.536),(85.16,-66.39,8.174),(83.81,-66.73,7.613),(83.99,-66.91,7.662),(84.24,-66.94,7.774),(84.51,-66.98,7.892),(84.82,-66.88,8.053),(85.05,-66.63,8.203),(83.87,-64.1,7.825),(84.02,-63.96,7.92),(84.25,-63.83,8.048),(84.67,-63.85,8.242),(84.82,-64.01,8.303),(84.96,-64.28,8.332),(83.86,-64.79,7.7),(84.09,-64.61,7.839),(84.34,-64.62,7.953),(83.43,-64.8,7.496),(83.65,-65.3,7.51),(83.3,-65.33,7.344),(83.6,-65.83,7.393),(83.37,-65.82,7.29),(84.04,-66.18,7.537),(84.39,-66.4,8.048),(83.55,-66.24,7.303),(84.14,-66.52,7.526),(84.45,-66.62,7.793),(84.76,-66.55,7.947),(84.88,-66.33,8.234),(83.85,-66.72,7.358),(84.03,-66.9,7.407),(84.28,-66.93,7.519),(84.55,-66.97,7.637),(84.86,-66.87,7.798),(85.09,-66.61,7.948),(88.03,-61.23,18.4),(87.52,-61.76,7.113),(78.1,-48.43,23.64),(81.31,-48.15,-1.64),(145.3,-48.97,2.892),(152.6,-42.11,1.049),(155.1,-49.4,2.892),(143.9,-46.12,2.735),(144.8,-48.61,8.153),(146.5,-47.11,11.61),(149.6,-46.77,11.07),(148.3,-45.04,11.74),(154.3,-49.06,9.418),(150.8,-43.58,9.677),(151.8,-42.58,6.666),(146.1,-45.94,8.975),(154.4,-49.78,-3.448),(144.9,-49.22,-2.689),(146.6,-48.08,-5.922),(149.6,-47.78,-5.985),(147.8,-46.19,-7.229),(150.4,-44.54,-6.428),(151.6,-43.27,-3.898),(145.8,-46.8,-3.977),(152.2,-57.73,-5.452),(144.2,-58.4,-6.211),(148.9,-56.35,-6.974),(145.7,-56.63,-8.037),(146.1,-61.99,-2.044),(147.5,-64.12,5.892),(144.5,-52.76,3.811),(144.4,-57.81,4.741),(155.9,-53.8,4.19),(154.6,-56.87,3.567),(158.1,-53.23,-2.256),(157.6,-54.86,1.519),(157.1,-54.82,-4.971),(155.7,-56.62,-2.366),(156.4,-50.99,-2.243),(148.3,-66.41,6.507),(144.3,-52.52,9.829),(145.7,-60.93,10.92),(145.6,-51.6,13.88),(152.7,-53.07,15.51),(151.1,-50.1,12.67),(158.0,-52.57,9.511),(157.0,-53.83,12.68),(155.8,-55.65,10.81),(157.6,-54.59,6.357),(154.7,-56.75,5.594),(151.6,-56.26,14.49),(155.4,-53.17,14.78),(155.7,-51.26,12.92),(156.4,-50.38,8.721),(153.8,-51.16,15.19),(153.9,-50.02,13.55),(155.6,-49.66,10.08),(148.8,-54.87,15.78),(146.7,-54.98,15.8),(148.7,-62.79,9.699),(145.3,-57.02,17.34),(149.1,-61.71,9.851),(149.8,-64.89,9.209),(146.9,-60.18,17.78),(147.2,-60.72,14.29),(151.5,-60.79,5.429),(151.6,-60.62,9.316),(153.5,-58.62,7.652),(152.3,-58.7,5.175),(153.4,-58.94,3.3),(149.9,-61.66,7.279),(152.0,-63.21,5.71),(150.4,-64.4,8.218),(149.9,-61.96,3.749),(150.6,-64.55,3.965),(152.2,-60.31,1.79),(155.7,-50.45,-3.939),(155.5,-54.41,-7.43),(156.1,-52.12,-6.289),(148.6,-63.11,1.35),(150.0,-65.23,2.678),(145.6,-61.91,-5.915),(144.4,-53.23,-2.842),(147.1,-61.5,-1.021),(145.7,-52.71,-6.24),(153.2,-54.29,-8.135),(151.1,-51.17,-6.567),(154.2,-52.36,-8.426),(154.0,-51.19,-7.433),(145.8,-56.68,-8.568),(157.6,-52.15,-2.244),(157.5,-51.51,9.124),(158.1,-54.27,3.974),(149.2,-62.0,0.4886),(146.7,-55.01,15.25),(145.8,-56.65,-8.589),(151.5,-58.97,13.65),(151.3,-60.22,-3.464),(146.3,-62.44,-2.177),(147.3,-61.22,14.56),(147.5,-62.38,10.25),(147.5,-62.69,0.08674),(148.4,-65.0,3.92),(148.9,-65.95,3.017),(147.6,-63.74,3.787),(148.5,-64.93,7.918),(149.1,-65.48,9.273),(147.6,-63.57,7.655),(148.1,-65.72,6.338),(150.4,-58.4,20.03),(147.8,-58.91,19.97),(148.5,-55.32,21.03),(149.1,-56.11,22.34),(149.0,-54.08,19.7),(152.3,-57.51,18.57),(139.8,-49.59,17.33),(142.1,-47.72,19.83),(142.1,-48.98,22.77),(140.9,-50.52,23.28),(142.2,-54.0,20.29),(139.5,-46.97,17.67),(137.5,-47.36,19.15),(137.7,-49.77,20.86),(142.9,-44.4,18.93),(141.3,-44.13,16.86),(141.8,-36.31,15.78),(143.3,-36.55,17.15),(139.9,-43.83,18.23),(140.3,-35.69,18.34),(138.3,-43.58,21.2),(137.7,-44.6,20.09),(137.2,-47.26,20.75),(138.5,-47.06,22.9),(141.4,-35.72,19.84),(140.1,-43.76,22.64),(142.7,-35.98,19.47),(141.7,-44.04,22.23),(140.1,-46.83,23.39),(141.5,-47.18,22.56),(143.6,-33.32,16.14),(143.9,-32.84,16.89),(141.5,-32.57,17.95),(143.7,-34.38,15.91),(144.7,-34.36,16.81),(139.6,-33.07,18.78),(143.2,-31.17,14.79),(143.1,-31.45,17.27),(143.6,-31.04,17.35),(142.9,-31.47,13.38),(142.5,-31.84,14.03),(142.2,-31.3,14.73),(142.3,-31.63,13.53),(142.8,-31.56,15.13),(141.9,-31.59,13.05),(141.6,-31.95,13.72),(141.3,-31.55,14.96),(141.7,-31.68,15.1),(141.3,-31.7,13.4),(141.2,-31.94,13.85),(140.9,-32.24,14.52),(140.5,-31.8,15.42),(140.9,-31.97,15.63),(140.5,-32.08,14.11),(140.7,-31.63,17.74),(141.1,-31.89,17.39),(140.1,-32.15,17.54),(140.5,-31.97,16.73),(140.5,-32.29,15.61),(140.2,-32.62,15.88),(139.8,-32.17,16.91),(140.1,-32.34,16.99),(139.9,-32.45,15.61),(139.6,-32.16,18.1),(144.1,-33.11,17.93),(143.5,-32.18,19.5),(142.3,-32.49,19.78),(140.7,-32.86,19.3),(142.8,-30.97,15.18),(142.7,-31.14,14.31),(143.2,-30.89,18.26),(143.0,-30.77,16.44),(142.5,-31.07,17.42),(142.1,-30.89,18.09),(141.9,-30.88,16.4),(141.8,-31.11,15.04),(141.7,-31.25,14.29),(141.5,-31.31,17.51),(141.2,-31.29,18.25),(141.0,-31.2,17.07),(140.9,-31.52,15.0),(141.0,-31.39,15.68),(140.2,-31.78,17.05),(140.2,-31.86,16.49),(140.2,-31.66,18.07),(140.3,-32.02,18.79),(144.6,-32.21,14.77),(145.7,-32.06,13.84),(145.5,-31.82,14.31),(144.8,-32.91,14.63),(146.0,-32.16,14.34),(145.5,-32.81,15.29),(145.0,-33.43,16.03),(145.0,-32.38,15.91),(145.2,-32.15,15.48),(145.8,-31.92,14.73),(149.1,-58.32,20.79),(148.1,-60.78,-9.251),(146.5,-60.27,-9.689),(146.2,-57.86,-11.98),(149.3,-58.29,-12.46),(150.2,-56.32,-10.13),(150.1,-59.72,-8.59),(145.4,-48.52,-10.09),(148.6,-48.51,-12.69),(147.6,-49.5,-15.38),(145.6,-50.19,-15.68),(144.3,-53.07,-11.94),(146.9,-47.36,-10.68),(145.2,-46.45,-12.34),(143.6,-47.97,-13.73),(151.3,-48.02,-11.84),(150.4,-46.65,-10.01),(158.0,-42.15,-9.586),(158.6,-43.44,-10.73),(149.8,-45.62,-11.58),(157.9,-40.92,-12.36),(149.0,-44.65,-14.75),(147.7,-44.88,-13.59),(145.1,-46.27,-13.98),(146.1,-47.1,-15.98),(158.5,-41.83,-13.7),(150.0,-45.98,-15.94),(158.9,-42.87,-13.14),(150.8,-47.2,-15.31),(147.4,-48.02,-16.31),(148.0,-49.09,-15.27),(161.5,-42.91,-9.79),(162.1,-43.17,-10.43),(162.3,-41.1,-11.37),(160.1,-43.05,-9.709),(160.3,-43.94,-10.51),(161.6,-39.51,-12.39),(164.0,-42.38,-8.588),(163.7,-42.38,-10.68),(164.2,-42.85,-10.78),(163.4,-42.11,-7.383),(163.1,-41.87,-8.213),(163.8,-41.61,-8.706),(163.2,-41.65,-7.671),(163.6,-42.12,-9.118),(163.2,-41.27,-7.23),(162.9,-41.05,-8.071),(163.5,-40.83,-9.157),(163.4,-41.22,-9.287),(163.1,-40.75,-7.698),(162.9,-40.7,-8.251),(162.6,-40.51,-9.073),(163.3,-40.23,-9.797),(163.1,-40.59,-10.01),(162.7,-40.19,-8.645),(163.5,-40.35,-11.28),(163.3,-40.66,-10.77),(162.9,-39.88,-10.92),(163.2,-40.29,-11.03),(162.7,-40.22,-10.19),(162.4,-40.01,-10.62),(163.0,-39.7,-11.35),(162.8,-40.0,-11.32),(162.5,-39.75,-10.34),(162.8,-39.5,-11.58),(161.8,-43.34,-11.34),(162.9,-42.82,-12.75),(162.5,-41.79,-13.14),(162.0,-40.41,-12.81),(164.3,-42.08,-8.936),(163.9,-41.98,-8.171),(164.3,-42.51,-11.81),(164.7,-42.27,-10.15),(164.2,-41.92,-10.94),(164.3,-41.55,-11.69),(164.5,-41.36,-10.24),(164.1,-41.21,-8.994),(163.8,-41.16,-8.324),(163.9,-41.09,-11.12),(163.8,-40.81,-11.87),(164.1,-40.7,-11.11),(163.5,-40.49,-9.236),(163.8,-40.59,-9.825),(163.4,-39.98,-11.18),(163.3,-39.98,-10.87),(163.4,-39.99,-11.63),(163.0,-40.05,-12.23),(162.6,-43.68,-7.961),(162.8,-44.54,-6.951),(163.1,-44.38,-7.366),(161.8,-43.87,-7.987),(162.7,-44.81,-7.447),(162.0,-44.47,-8.576),(161.3,-44.14,-9.488),(162.5,-44.06,-9.109),(162.8,-44.21,-8.619),(163.0,-44.69,-7.788),(148.3,-60.21,-10.71),(148.9,-56.36,-6.996),(145.7,-56.63,-8.059),(152.1,-37.76,0.2673),(149.6,-35.61,0.2078),(140.1,-41.49,2.397),(142.1,-35.52,1.482),(145.2,-34.57,1.234),(141.7,-44.4,2.763),(148.3,-43.17,-9.344),(145.7,-44.74,-7.068),(150.1,-40.65,-7.854),(151.1,-38.86,-3.893),(141.6,-44.84,-2.649),(143.0,-17.36,-14.85),(146.5,-20.55,-13.81),(141.4,-20.1,-10.75),(145.9,-21.18,-10.79),(146.6,-20.25,-7.258),(142.0,-18.91,-7.547),(143.5,-16.17,-6.722),(147.5,-19.27,-15.75),(147.7,-18.81,-6.189),(149.3,-16.85,-7.425),(144.7,-14.22,-11.44),(150.0,-16.18,-11.61),(149.2,-17.23,-14.74),(149.6,-22.23,-15.83),(149.5,-21.3,-5.07),(152.4,-21.94,-6.797),(153.9,-22.6,-10.88),(152.5,-22.6,-13.37),(149.0,-31.09,-14.93),(145.5,-29.86,-13.52),(144.3,-27.41,-10.12),(144.9,-26.72,-5.2),(148.9,-28.53,-2.465),(152.2,-29.65,-4.24),(153.5,-30.91,-8.329),(151.9,-31.45,-12.11),(146.7,-40.31,-11.42),(143.1,-35.95,-13.05),(142.8,-32.42,-8.973),(142.3,-34.28,-0.0776),(144.6,-32.06,-1.101),(143.4,-42.27,-9.944),(142.9,-39.21,-11.87),(138.8,-40.47,-7.268),(140.0,-42.0,-6.48),(139.3,-42.91,0.7372),(138.3,-41.16,-0.2369),(139.5,-39.71,2.123),(140.8,-38.74,3.008),(138.1,-38.77,-6.45),(139.4,-34.75,-6.053),(137.7,-38.33,-0.5444),(141.3,-34.16,-2.777),(139.4,-37.31,1.711),(142.0,-36.93,3.64),(136.7,-14.94,-15.35),(135.7,-16.31,-13.88),(135.5,-16.92,-10.44),(135.9,-16.06,-7.255),(136.9,-14.58,-6.261),(137.6,-13.05,-7.744),(137.9,-12.63,-10.81),(137.6,-13.43,-14.16),(128.9,-12.51,-13.89),(128.2,-13.8,-12.9),(128.0,-14.3,-10.11),(128.4,-13.6,-7.528),(129.0,-12.23,-6.557),(129.7,-10.86,-7.929),(130.1,-10.56,-10.41),(129.7,-11.16,-13.08),(123.2,-9.875,-12.37),(123.0,-11.22,-12.12),(122.9,-11.73,-9.938),(123.0,-11.08,-8.653),(123.4,-9.529,-8.227),(123.6,-8.291,-9.116),(123.6,-7.936,-10.9),(123.6,-8.431,-12.18),(122.9,-6.521,-13.0),(122.8,-5.723,-11.34),(122.6,-3.204,-12.56),(121.6,-5.254,-13.43),(122.9,-6.283,-9.575),(121.7,-4.928,-9.063),(122.6,-2.998,-10.48),(122.2,-7.84,-7.858),(121.3,-11.4,-7.265),(120.2,-11.06,-7.752),(120.9,-9.761,-7.092),(121.1,-12.01,-9.861),(120.0,-11.62,-9.902),(121.2,-11.81,-12.25),(120.1,-11.41,-12.19),(122.6,-8.368,-13.28),(120.8,-10.15,-13.08),(120.8,-4.964,-13.35),(121.9,-2.44,-11.51),(120.8,-4.787,-9.323),(122.2,-11.87,-11.47),(122.2,-11.64,-8.023),(118.1,-10.41,-9.546),(118.1,-10.47,-10.65),(118.4,-9.904,-9.658),(118.4,-9.965,-10.76),(143.5,-34.56,-0.55),(146.8,-34.67,-0.8521),(149.5,-41.73,12.43),(146.7,-43.51,11.44),(151.1,-39.49,9.64),(151.6,-38.28,4.933),(142.2,-44.13,8.161),(160.0,-17.61,5.667),(159.4,-22.05,5.509),(155.9,-18.75,3.303),(158.0,-22.43,3.014),(158.5,-22.55,-0.8881),(156.7,-18.7,-0.4081),(159.8,-17.98,-2.707),(161.5,-21.66,6.588),(160.3,-22.37,-2.748),(163.1,-21.93,-2.733),(163.1,-17.02,0.6848),(164.9,-21.5,0.8216),(164.1,-21.41,4.41),(161.1,-24.94,7.992),(159.7,-25.42,-2.663),(162.0,-27.1,-1.125),(163.6,-27.85,2.832),(162.9,-26.87,5.413),(155.7,-32.2,11.81),(153.1,-29.73,10.73),(152.8,-27.5,6.468),(152.7,-27.72,1.325),(154.5,-31.26,-0.8278),(156.8,-33.62,0.5831),(158.2,-34.69,4.469),(157.3,-34.03,8.65),(147.6,-37.85,13.94),(148.0,-34.03,14.16),(140.6,-32.53,8.958),(148.6,-32.27,0.5975),(144.8,-40.7,13.79),(143.6,-37.85,14.32),(139.9,-39.23,11.62),(141.0,-40.84,11.15),(139.5,-42.64,4.712),(138.6,-40.8,5.225),(140.7,-38.9,0.6096),(139.0,-37.66,10.36),(138.5,-36.03,7.505),(138.0,-37.99,4.597),(139.9,-35.48,3.849),(139.4,-37.29,2.008),(141.7,-37.23,-0.9386),(158.0,-12.06,5.305),(156.0,-12.46,4.661),(154.7,-13.02,1.704),(155.1,-13.03,-1.792),(156.8,-12.84,-3.55),(158.9,-12.2,-2.966),(160.0,-11.84,-0.2829),(159.6,-11.77,3.347),(154.6,-5.747,3.182),(153.0,-6.302,2.912),(151.9,-6.78,0.5062),(152.3,-6.788,-2.331),(153.7,-6.399,-3.976),(155.6,-5.79,-3.386),(156.5,-5.61,-1.191),(156.1,-5.455,1.687),(151.8,-0.4059,0.7456),(151.0,-1.529,1.207),(150.3,-2.15,-0.8187),(150.7,-1.882,-2.19),(151.7,-0.6885,-3.413),(152.5,0.4681,-3.149),(152.8,1.06,-1.512),(152.7,0.8116,-0.1524),(152.8,2.867,-0.04504),(152.9,3.312,-1.98),(153.9,5.817,-1.847),(152.1,4.399,-0.1643),(152.7,2.612,-3.466),(152.1,4.062,-4.532),(153.9,5.703,-3.955),(151.3,1.15,-4.475),(148.9,-1.763,-3.514),(148.1,-1.119,-3.181),(149.3,-0.2897,-4.392),(148.6,-1.817,-0.7404),(147.8,-1.226,-0.8584),(149.1,-1.428,1.516),(148.2,-0.7823,1.258),(151.8,1.306,0.9994),(149.4,0.2053,1.571),(151.5,4.895,-0.3798),(153.5,6.563,-3.19),(151.3,4.529,-4.357),(149.8,-1.831,0.7542),(149.6,-2.095,-2.683),(146.4,0.4054,-1.849),(146.4,0.4984,-0.7555),(146.8,0.7939,-1.946),(146.9,0.8869,-0.8526),(156.9,-68.13,5.576),(152.6,-68.11,12.33),(151.3,-74.41,7.534),(154.1,-62.37,4.818),(156.6,-68.2,6.85),(155.9,-68.86,11.17),(154.6,-68.33,11.74),(157.0,-71.06,6.156),(155.5,-72.96,6.703),(152.7,-74.03,7.271),(157.5,-65.62,5.01),(156.4,-63.87,4.816),(156.0,-62.77,4.66),(149.2,-67.66,11.0),(150.3,-69.52,12.34),(145.3,-71.79,7.8),(146.4,-73.46,7.982),(149.7,-74.61,7.783),(146.6,-67.06,6.712),(148.6,-65.06,6.058),(150.9,-63.96,5.553),(152.4,-68.97,12.69),(150.9,-72.93,12.21),(151.2,-74.02,10.32),(153.6,-63.31,8.717),(153.2,-64.26,10.26),(152.8,-66.45,11.88),(156.2,-71.61,8.835),(154.6,-69.87,11.81),(152.9,-73.28,10.37),(157.2,-65.69,5.894),(155.3,-63.32,6.929),(154.8,-65.93,10.49),(146.6,-72.43,11.12),(148.2,-73.8,11.37),(149.3,-71.94,13.14),(151.3,-67.02,11.58),(151.7,-64.22,9.329),(154.2,-73.6,6.992),(157.3,-69.63,5.824),(157.0,-67.61,5.464),(157.0,-67.29,5.396),(157.3,-66.52,5.216),(156.5,-66.52,6.108),(156.5,-67.1,6.057),(157.6,-65.85,5.049),(157.1,-65.48,5.041),(156.7,-65.38,5.074),(157.0,-64.84,4.921),(156.4,-65.38,6.277),(156.6,-64.74,6.708),(156.1,-67.05,6.447),(156.1,-65.76,6.798),(155.5,-64.47,8.179),(154.6,-64.03,8.923),(155.1,-62.28,6.102),(156.5,-64.4,4.907),(155.9,-63.72,4.848),(155.9,-63.17,4.745),(155.6,-62.35,4.63),(152.1,-63.12,5.231),(155.7,-63.97,6.63),(157.0,-64.65,4.888),(156.6,-64.1,4.831),(156.3,-64.33,6.766),(156.8,-64.9,5.749),(156.3,-65.75,8.537),(156.8,-66.09,6.209),(157.4,-66.09,5.647),(156.2,-64.04,6.628),(156.8,-68.69,9.685),(156.1,-67.84,6.495),(154.9,-67.56,11.43),(157.0,-69.21,9.584),(156.2,-67.57,7.849),(156.5,-67.59,6.095),(156.2,-68.07,10.02),(155.9,-68.35,11.07),(156.2,-68.36,7.708),(157.1,-68.62,7.901),(155.5,-70.95,10.82),(155.1,-72.53,9.76),(155.3,-65.02,9.407),(150.1,-64.72,5.804),(157.3,-68.78,5.657),(155.1,-63.08,7.359),(156.5,-67.95,6.147),(157.2,-68.41,6.691),(157.3,-68.89,7.195),(155.4,-67.71,10.23),(156.0,-66.75,7.664),(155.3,-66.97,10.26),(156.4,-65.25,7.003),(144.5,-68.62,7.289),(145.5,-69.65,10.96),(147.9,-74.27,7.952),(145.7,-67.34,7.69),(145.2,-67.77,7.812),(144.6,-67.68,7.095),(144.2,-67.44,7.103),(143.1,-67.17,7.189),(142.1,-66.46,7.177),(141.1,-64.84,6.994),(139.0,-63.42,6.995),(139.1,-62.45,6.795),(139.2,-59.9,6.275),(140.1,-58.75,5.913),(142.1,-58.35,5.638),(142.7,-59.98,5.837),(144.7,-61.63,5.896),(145.9,-64.24,6.254),(145.0,-66.02,6.714),(145.8,-66.11,6.635),(146.1,-66.36,6.636),(140.9,-62.2,7.57),(142.9,-63.19,7.518),(145.5,-66.9,7.577),(142.6,-61.48,6.932),(141.4,-59.86,6.768),(143.3,-64.46,7.402),(143.6,-65.78,7.446),(144.7,-66.56,7.73),(140.7,-60.69,6.974),(143.9,-66.73,7.712),(144.5,-67.03,7.705),(145.0,-67.34,7.707),(149.4,-67.56,12.0),(149.5,-67.39,11.82),(149.7,-67.29,11.6),(149.8,-67.31,11.49),(150.1,-67.33,11.32),(150.3,-67.52,11.28),(150.4,-67.75,11.44),(149.3,-68.17,12.37),(149.6,-68.02,12.12),(149.8,-68.04,11.96),(149.9,-68.47,11.7),(150.0,-68.23,11.46),(150.4,-68.09,11.52),(148.9,-68.15,12.68),(149.2,-68.19,12.53),(149.3,-68.84,12.33),(150.2,-68.71,11.83),(150.2,-68.35,11.79),(148.8,-68.64,13.04),(149.4,-69.11,12.48),(149.9,-69.3,12.18),(150.3,-69.22,12.18),(148.9,-69.11,13.26),(149.1,-69.14,13.11),(149.6,-69.52,13.0),(149.8,-69.8,12.5),(150.0,-69.69,12.32),(149.1,-69.53,13.35),(149.9,-69.98,12.81),(150.2,-69.95,12.57),(150.3,-69.78,12.24),(150.6,-69.75,12.39),(149.4,-70.01,13.4),(149.6,-70.2,13.38),(149.8,-70.25,13.23),(150.1,-70.31,13.07),(150.3,-70.24,12.8),(150.5,-70.01,12.51),(149.4,-67.51,12.24),(149.5,-67.35,12.05),(149.7,-67.24,11.83),(150.1,-67.29,11.55),(150.3,-67.47,11.52),(149.4,-68.13,12.6),(149.6,-67.98,12.35),(149.9,-68.0,12.19),(149.0,-68.11,12.91),(149.2,-68.6,13.02),(149.4,-69.07,12.71),(148.9,-68.6,13.27),(149.0,-69.07,13.49),(149.2,-69.1,13.34),(149.6,-69.47,13.23),(149.9,-69.76,12.73),(149.2,-69.49,13.59),(149.7,-69.81,13.34),(150.0,-69.94,13.04),(150.3,-69.91,12.8),(149.5,-69.97,13.64),(149.6,-70.16,13.61),(149.9,-70.21,13.46),(150.1,-70.27,13.3),(150.4,-70.2,13.03),(150.6,-69.97,12.74),(151.8,-68.93,0.2036),(156.4,-68.36,4.471),(155.3,-69.56,0.7527),(153.9,-69.09,0.3356),(148.7,-67.89,2.169),(149.7,-70.1,1.307),(151.8,-69.9,0.2425),(150.3,-73.58,2.56),(150.8,-74.27,4.439),(153.1,-63.59,1.718),(152.6,-64.93,0.5574),(152.0,-67.25,-0.05187),(156.4,-71.91,3.516),(153.7,-70.98,0.7486),(152.5,-73.61,3.964),(157.1,-65.8,4.262),(155.0,-63.59,2.869),(154.2,-66.59,0.5589),(146.2,-72.87,4.542),(147.8,-74.27,4.415),(148.6,-72.8,1.527),(150.6,-67.74,0.8423),(151.3,-64.72,1.815),(156.4,-66.62,4.554),(156.4,-67.18,4.839),(156.2,-65.53,3.994),(156.4,-64.97,3.29),(156.0,-67.18,4.532),(155.9,-65.97,3.706),(155.1,-64.88,2.062),(154.1,-64.23,1.518),(154.9,-62.47,3.098),(155.5,-64.19,3.283),(156.1,-64.58,3.144),(156.7,-65.0,4.202),(155.9,-66.21,1.925),(156.6,-66.22,4.234),(157.4,-66.16,4.601),(155.9,-64.27,3.206),(156.3,-69.21,1.89),(156.0,-67.95,4.804),(154.2,-68.3,0.2777),(156.6,-69.71,2.122),(155.9,-67.9,3.424),(156.4,-67.66,4.992),(155.7,-68.65,1.606),(155.3,-69.02,0.7664),(156.0,-68.63,3.804),(156.8,-68.92,3.494),(154.8,-71.64,2.158),(154.7,-72.84,3.697),(154.8,-65.6,1.358),(154.7,-63.21,2.513),(156.4,-68.02,5.068),(157.1,-68.56,4.542),(157.1,-69.09,4.216),(154.8,-68.36,1.494),(155.8,-67.09,3.431),(154.7,-67.58,1.057),(156.2,-65.62,3.271),(145.1,-70.13,3.894),(145.6,-67.44,6.114),(145.1,-67.88,6.298),(141.2,-63.53,5.993),(142.8,-64.49,5.981),(145.4,-67.0,6.104),(143.0,-62.08,5.212),(141.5,-59.91,5.199),(143.4,-65.67,6.285),(144.6,-66.64,6.157),(140.3,-61.47,5.518),(143.8,-66.83,6.312),(144.4,-67.13,6.288),(144.9,-67.43,6.277),(148.7,-68.29,1.119),(148.8,-68.1,1.205),(149.0,-67.98,1.325),(149.2,-67.98,1.4),(149.5,-67.99,1.509),(149.6,-68.16,1.57),(149.7,-68.43,1.602),(148.6,-68.93,1.008),(148.9,-68.76,1.137),(149.1,-68.76,1.246),(149.3,-69.15,1.633),(149.4,-68.89,1.736),(149.8,-68.77,1.462),(148.2,-68.95,0.8148),(148.4,-68.97,0.9123),(148.7,-69.59,1.304),(149.5,-69.38,1.537),(149.6,-69.06,1.393),(148.1,-69.47,0.678),(148.7,-69.87,1.263),(149.2,-70.02,1.489),(148.1,-69.96,0.6332),(148.4,-69.97,0.7306),(148.8,-70.33,0.8725),(149.1,-70.55,1.381),(149.3,-70.42,1.475),(148.3,-70.38,0.652),(149.2,-70.77,1.129),(149.5,-70.71,1.275),(149.6,-70.49,1.602),(150.0,-70.53,1.233),(148.6,-70.87,0.7109),(148.8,-71.05,0.7599),(149.0,-71.08,0.8666),(149.3,-71.13,0.9791),(149.6,-71.02,1.131),(149.8,-70.77,1.27),(148.7,-68.24,0.8615),(148.8,-68.09,0.9499),(149.1,-67.97,1.07),(149.5,-67.99,1.254),(149.7,-68.15,1.315),(149.8,-68.42,1.347),(148.7,-68.92,0.7526),(148.9,-68.75,0.8817),(149.2,-68.75,0.9908),(148.2,-68.94,0.5592),(148.5,-69.44,0.5797),(148.1,-69.46,0.4225),(148.4,-69.96,0.475),(148.2,-69.95,0.3776),(148.8,-70.32,0.617),(149.2,-70.54,1.125),(148.3,-70.38,0.3964),(148.9,-70.66,0.6113),(149.2,-70.76,0.8735),(149.6,-70.7,1.019),(149.7,-70.47,1.298),(148.6,-70.86,0.4553),(148.8,-71.04,0.5044),(149.1,-71.07,0.611),(149.3,-71.12,0.7235),(149.7,-71.02,0.8752),(149.9,-70.76,1.014),(153.0,-65.32,11.27),(152.4,-65.93,0.01117),(142.9,-53.06,16.6),(146.3,-52.41,-8.29),(210.0,-48.28,-5.635),(217.4,-41.54,-7.761),(219.7,-48.87,-6.107),(208.7,-45.41,-5.698),(209.6,-47.94,-0.3503),(211.4,-46.47,3.039),(214.5,-46.18,2.357),(213.3,-44.43,3.104),(219.1,-48.55,0.4554),(215.7,-43.01,0.9372),(216.7,-42.01,-2.114),(211.0,-45.28,0.4375),(218.9,-49.22,-12.41),(209.4,-48.5,-11.19),(211.1,-47.38,-14.5),(214.1,-47.13,-14.7),(212.3,-45.51,-15.84),(214.9,-43.9,-15.15),(216.2,-42.66,-12.67),(210.3,-46.09,-12.5),(216.4,-57.12,-14.39),(208.0,-59.57,-11.77),(213.2,-55.69,-15.74),(208.4,-58.02,-13.65),(210.2,-61.56,-9.003),(211.9,-63.48,-2.886),(209.1,-52.06,-4.715),(208.9,-57.11,-3.829),(220.4,-53.29,-4.89),(219.1,-56.34,-5.482),(222.5,-52.73,-11.43),(222.1,-54.37,-7.654),(221.5,-54.29,-14.11),(220.0,-56.08,-11.46),(220.9,-50.46,-11.32),(212.6,-65.78,-2.33),(209.1,-51.84,1.312),(210.2,-60.28,2.254),(210.4,-50.95,5.312),(217.5,-52.55,6.583),(215.9,-49.54,3.853),(222.7,-52.11,0.3373),(221.8,-53.37,3.536),(220.8,-54.87,1.621),(222.2,-54.12,-2.815),(219.2,-56.22,-3.457),(217.0,-55.42,6.235),(220.2,-52.69,5.724),(220.5,-50.77,3.867),(221.1,-49.89,-0.3523),(218.6,-50.65,6.227),(218.8,-49.51,4.59),(220.4,-49.17,1.055),(213.6,-54.28,7.027),(211.5,-54.36,7.147),(213.1,-62.17,0.8767),(210.8,-55.61,9.974),(213.9,-60.79,2.461),(214.3,-64.3,0.31),(212.5,-58.77,10.61),(212.4,-59.48,7.189),(216.0,-60.21,-3.51),(216.3,-59.76,1.583),(218.2,-57.86,-0.5706),(216.8,-58.13,-3.781),(217.9,-58.39,-5.712),(214.4,-61.06,-1.591),(216.4,-62.64,-3.274),(214.8,-63.81,-0.7042),(214.3,-61.34,-5.123),(214.9,-63.95,-4.963),(216.6,-59.73,-7.176),(220.1,-49.9,-12.97),(219.8,-53.85,-16.49),(220.5,-51.57,-15.36),(212.9,-62.47,-7.468),(214.3,-64.61,-6.227),(209.7,-61.95,-12.57),(208.8,-52.5,-11.36),(211.1,-60.97,-7.834),(210.1,-51.99,-14.82),(216.9,-54.12,-16.84),(215.5,-50.54,-15.39),(218.0,-52.19,-17.41),(218.4,-50.61,-16.39),(208.4,-58.1,-14.18),(222.1,-51.64,-11.39),(222.3,-51.05,-0.01716),(222.6,-53.8,-5.215),(213.5,-61.36,-8.349),(211.5,-54.39,6.597),(208.3,-58.09,-14.19),(216.5,-58.02,5.762),(215.3,-59.78,-11.12),(210.4,-62.01,-9.122),(212.5,-59.97,7.524),(212.0,-61.75,1.486),(211.8,-62.02,-8.675),(212.8,-64.36,-4.91),(213.2,-65.31,-5.846),(211.9,-63.08,-4.99),(212.9,-64.31,-0.9153),(213.5,-64.87,0.4058),(212.1,-62.93,-1.125),(212.5,-65.08,-2.486),(216.1,-56.98,12.01),(213.6,-56.55,13.46),(213.4,-54.75,12.28),(216.7,-54.53,13.37),(217.2,-53.16,9.917),(217.9,-56.23,10.13),(214.1,-44.74,7.887),(217.5,-45.22,9.17),(217.1,-45.46,12.45),(215.1,-45.6,13.84),(212.6,-48.98,12.43),(216.3,-43.84,6.98),(215.9,-42.12,8.255),(213.4,-43.05,11.5),(219.7,-46.4,7.337),(219.3,-45.22,4.893),(227.8,-46.15,-0.8364),(227.7,-47.2,1.058),(219.9,-43.88,5.649),(229.3,-44.85,0.5814),(220.7,-42.27,7.878),(219.2,-41.95,7.391),(216.3,-41.65,9.615),(217.3,-42.49,11.68),(229.5,-45.59,2.359),(221.0,-43.59,9.701),(228.9,-46.6,2.645),(220.8,-45.01,9.869),(217.9,-43.75,12.28),(217.6,-45.06,11.95),(229.3,-48.91,-0.5271),(229.7,-49.36,0.1612),(231.7,-48.1,-0.6545),(228.3,-48.2,-0.2795),(228.0,-48.69,1.179),(232.9,-46.62,-1.113),(230.4,-50.15,-2.731),(231.4,-49.85,-0.6107),(231.3,-50.46,-0.3874),(229.8,-49.79,-3.836),(230.0,-49.3,-3.294),(230.8,-49.53,-3.308),(230.1,-49.34,-3.979),(230.5,-49.65,-2.436),(230.1,-49.13,-4.678),(230.4,-48.68,-4.116),(231.3,-48.79,-3.591),(231.0,-48.94,-3.09),(230.6,-48.68,-4.752),(230.7,-48.44,-4.297),(230.9,-48.04,-3.746),(231.8,-48.16,-3.566),(231.5,-48.26,-3.006),(231.0,-47.97,-4.413),(232.8,-48.33,-1.758),(232.3,-48.38,-1.643),(232.7,-47.69,-2.07),(232.2,-48.01,-2.395),(231.6,-47.76,-3.112),(231.7,-47.35,-2.865),(232.6,-47.44,-2.607),(232.3,-47.52,-2.195),(231.8,-47.31,-3.382),(233.2,-47.42,-1.969),(229.7,-49.13,1.243),(231.3,-49.29,1.945),(231.9,-48.38,1.425),(232.5,-47.28,-0.00242),(230.9,-50.08,-2.797),(230.5,-49.92,-3.435),(232.1,-50.26,-0.01897),(231.5,-50.3,-1.81),(232.0,-49.81,-1.055),(232.7,-49.64,-0.9069),(232.0,-49.6,-2.49),(231.4,-49.38,-3.508),(231.0,-49.28,-4.032),(232.4,-49.07,-1.521),(232.9,-48.83,-1.165),(232.6,-48.86,-2.304),(231.6,-48.57,-3.853),(231.9,-48.7,-3.336),(232.7,-47.94,-2.505),(232.4,-47.89,-2.902),(233.2,-48.04,-1.755),(233.2,-47.79,-1.003),(229.0,-50.42,-1.43),(228.2,-51.21,-1.572),(228.7,-51.24,-1.368),(228.4,-50.01,-1.186),(228.1,-51.25,-0.9023),(228.3,-50.41,-0.1779),(228.3,-49.62,0.3715),(229.1,-50.4,-0.1111),(229.0,-50.74,-0.4192),(228.5,-51.31,-0.7368),(215.1,-56.48,13.23),(212.0,-60.81,-16.22),(210.3,-60.87,-15.96),(208.5,-59.41,-17.44),(210.9,-58.77,-19.79),(211.1,-56.32,-18.44),(213.5,-59.29,-16.29),(201.9,-51.97,-14.75),(203.3,-50.4,-18.81),(203.2,-52.19,-20.95),(202.2,-53.83,-20.23),(204.1,-56.35,-16.34),(200.8,-49.79,-16.08),(199.0,-50.93,-16.38),(199.5,-53.05,-17.08),(202.4,-46.8,-19.9),(201.1,-46.62,-17.36),(197.6,-39.55,-19.7),(198.9,-39.59,-21.5),(199.5,-47.07,-18.08),(195.7,-39.89,-21.74),(197.6,-47.93,-20.2),(197.8,-48.74,-18.49),(198.4,-51.25,-17.73),(199.2,-51.2,-20.37),(196.5,-39.89,-23.57),(199.1,-47.87,-22.24),(197.9,-39.69,-23.64),(200.7,-47.54,-22.5),(200.5,-50.69,-21.64),(202.1,-50.46,-21.37),(198.1,-36.47,-21.53),(198.1,-35.97,-22.38),(195.6,-36.55,-22.51),(198.6,-37.53,-21.13),(199.5,-37.24,-22.27),(194.0,-37.62,-22.7),(196.7,-34.31,-20.78),(196.6,-34.92,-22.66),(197.0,-34.43,-23.07),(196.7,-34.59,-19.31),(196.5,-35.08,-19.84),(195.9,-34.68,-20.53),(196.2,-34.91,-19.32),(196.5,-34.8,-20.99),(195.8,-34.95,-18.75),(195.6,-35.41,-19.31),(195.1,-35.18,-20.53),(195.5,-35.2,-20.74),(195.3,-35.24,-18.95),(195.2,-35.53,-19.36),(195.0,-35.93,-19.94),(194.4,-35.65,-20.79),(194.9,-35.72,-21.06),(194.7,-35.84,-19.47),(194.4,-35.79,-22.42),(194.9,-35.8,-22.0),(194.1,-36.34,-21.75),(194.4,-35.92,-21.96),(194.6,-36.15,-20.91),(194.4,-36.54,-21.09),(193.8,-36.32,-21.93),(194.2,-36.39,-21.94),(194.1,-36.45,-20.79),(193.7,-36.65,-22.2),(198.2,-36.32,-23.2),(197.2,-35.73,-24.64),(196.1,-36.38,-24.53),(194.8,-37.16,-23.54),(196.3,-34.25,-21.12),(196.3,-34.38,-20.22),(196.5,-34.63,-23.93),(196.3,-34.12,-22.48),(196.0,-34.76,-22.86),(195.4,-34.85,-23.48),(195.3,-34.5,-22.17),(195.4,-34.64,-20.76),(195.5,-34.74,-19.99),(195.1,-35.27,-22.63),(194.8,-35.51,-23.23),(194.6,-35.14,-22.56),(194.7,-35.27,-20.49),(194.7,-35.17,-21.18),(194.0,-35.86,-22.09),(194.1,-35.88,-21.72),(194.0,-36.01,-22.6),(194.2,-36.44,-23.07),(198.7,-35.15,-20.28),(199.7,-34.65,-19.68),(199.4,-34.5,-20.1),(199.2,-35.75,-20.17),(200.0,-34.68,-20.25),(199.7,-35.48,-21.03),(199.4,-36.24,-21.6),(199.0,-35.25,-21.51),(199.2,-34.94,-21.16),(199.7,-34.52,-20.61),(211.7,-60.35,-17.7),(213.2,-55.69,-15.76),(208.4,-58.02,-13.67),(217.0,-37.17,-8.478),(215.7,-36.72,-7.356),(204.9,-40.72,-5.809),(207.0,-34.77,-6.761),(210.1,-33.87,-7.147),(206.5,-43.65,-5.548),(212.8,-42.48,-17.95),(210.2,-44.02,-15.57),(214.7,-40.0,-16.52),(215.8,-38.24,-12.6),(206.3,-44.07,-10.96),(223.9,-20.99,-24.16),(225.1,-25.05,-22.68),(220.9,-22.73,-20.14),(224.1,-25.3,-19.7),(225.1,-24.62,-16.15),(221.9,-21.81,-16.92),(224.6,-19.89,-16.05),(226.8,-24.41,-24.55),(226.8,-23.75,-15.02),(229.4,-22.72,-16.16),(226.9,-18.72,-20.71),(230.5,-22.55,-20.28),(229.4,-23.25,-23.45),(226.7,-27.66,-24.31),(226.8,-26.39,-13.65),(228.7,-28.42,-14.93),(229.7,-29.91,-18.72),(228.6,-29.29,-21.42),(219.9,-34.46,-22.96),(218.0,-31.56,-22.52),(218.6,-28.74,-19.5),(219.2,-28.17,-14.52),(220.9,-31.44,-10.89),(222.7,-34.11,-11.84),(223.1,-36.09,-15.44),(221.7,-35.96,-19.47),(211.7,-40.57,-18.82),(211.8,-35.47,-22.43),(213.7,-31.94,-18.75),(210.8,-32.18,-10.45),(214.6,-31.75,-10.55),(208.0,-41.5,-18.31),(209.3,-38.14,-21.05),(203.4,-39.64,-15.4),(204.6,-41.19,-14.68),(204.1,-42.11,-7.442),(203.1,-40.34,-8.351),(204.4,-38.92,-6.037),(205.7,-37.98,-5.205),(202.8,-37.93,-14.53),(208.8,-31.94,-17.3),(202.5,-37.5,-8.602),(210.5,-31.93,-13.4),(204.3,-36.52,-6.418),(206.9,-36.19,-4.611),(219.5,-16.49,-25.35),(217.9,-17.33,-23.93),(217.2,-17.7,-20.5),(217.9,-16.98,-17.31),(219.5,-16.0,-16.27),(221.0,-14.93,-17.73),(221.6,-14.75,-20.77),(221.0,-15.41,-24.13),(213.5,-11.39,-24.67),(212.3,-12.34,-23.71),(211.7,-12.66,-20.93),(212.3,-12.09,-18.34),(213.5,-11.04,-17.34),(214.9,-10.05,-18.68),(215.5,-9.98,-21.13),(214.9,-10.43,-23.82),(209.1,-7.009,-23.65),(208.4,-8.255,-23.41),(208.1,-8.689,-21.23),(208.4,-8.091,-19.94),(209.2,-6.663,-19.51),(209.8,-5.531,-20.39),(210.0,-5.217,-22.17),(209.9,-5.697,-23.45),(208.9,-3.529,-24.23),(208.8,-2.792,-22.54),(208.9,-0.2613,-23.74),(207.7,-2.223,-24.7),(208.8,-3.303,-20.81),(207.8,-1.924,-20.32),(208.9,-0.06802,-21.65),(208.0,-4.821,-19.15),(206.7,-8.231,-18.65),(205.7,-7.854,-19.19),(206.5,-6.641,-18.48),(206.3,-8.771,-21.26),(205.4,-8.364,-21.35),(206.6,-8.427,-23.65),(205.6,-8.18,-23.63),(208.5,-5.354,-24.56),(206.5,-7.013,-24.47),(207.0,-1.878,-24.65),(208.3,0.5497,-22.72),(206.9,-1.713,-20.63),(207.4,-8.684,-22.81),(207.5,-8.456,-19.36),(203.6,-7.104,-21.11),(203.6,-7.161,-22.21),(203.9,-6.62,-21.2),(203.9,-6.677,-22.3),(211.6,-33.02,-10.43),(214.3,-34.78,-9.462),(214.6,-41.14,3.766),(211.7,-42.88,2.888),(216.1,-38.93,0.9236),(216.5,-37.7,-3.792),(207.1,-43.41,-0.1754),(204.5,-12.23,-0.916),(205.3,-16.89,-1.192),(200.7,-13.98,-3.242),(204.0,-17.54,-3.665),(204.5,-17.48,-7.586),(201.5,-13.77,-6.965),(204.3,-12.55,-9.296),(207.2,-16.03,-0.1535),(206.0,-16.89,-9.482),(208.7,-15.78,-9.527),(207.3,-11.09,-5.934),(210.3,-14.97,-6.008),(209.6,-15.13,-2.393),(209.0,-19.65,1.038),(207.6,-20.54,-9.561),(210.8,-20.52,-8.414),(212.8,-20.2,-4.683),(211.6,-19.99,-1.921),(211.4,-28.08,4.177),(207.5,-28.14,3.249),(205.3,-26.79,-0.6647),(205.2,-26.87,-5.773),(209.5,-27.98,-8.375),(213.2,-28.07,-7.197),(215.2,-27.93,-3.382),(214.1,-28.16,0.8948),(212.7,-37.24,5.406),(207.7,-34.24,5.772),(205.8,-31.79,0.81),(207.0,-32.46,-7.428),(209.9,-40.04,5.365),(208.8,-37.17,5.971),(205.0,-38.48,3.439),(206.1,-40.1,2.905),(204.4,-41.87,-3.477),(203.5,-40.01,-2.903),(205.5,-38.12,-7.597),(204.1,-36.89,2.235),(203.5,-35.24,-0.5713),(202.9,-37.18,-3.474),(204.9,-34.71,-4.29),(204.3,-36.5,-6.122),(206.5,-36.47,-9.177),(201.4,-7.018,-1.134),(199.4,-7.673,-1.754),(198.2,-8.378,-4.7),(198.6,-8.32,-8.203),(200.3,-7.901,-9.983),(202.2,-7.009,-9.419),(203.2,-6.518,-6.746),(202.9,-6.513,-3.111),(197.2,-1.234,-3.144),(195.6,-1.919,-3.388),(194.6,-2.474,-5.778),(195.0,-2.453,-8.621),(196.3,-1.953,-10.29),(198.1,-1.196,-9.727),(199.0,-0.926,-7.547),(198.6,-0.8103,-4.663),(194.7,3.551,-5.554),(193.5,2.718,-5.079),(192.8,2.138,-7.077),(193.1,2.395,-8.466),(194.5,3.27,-9.707),(195.7,4.08,-9.459),(196.3,4.516,-7.833),(196.1,4.342,-6.467),(197.1,6.199,-6.415),(197.5,6.623,-8.383),(199.4,8.674,-8.311),(197.2,7.898,-6.588),(196.9,5.983,-9.832),(197.0,7.556,-10.95),(199.4,8.55,-10.42),(195.0,5.059,-10.81),(191.5,2.981,-9.81),(191.0,3.914,-9.502),(192.5,4.377,-10.72),(191.2,2.98,-7.031),(190.7,3.887,-7.18),(191.7,3.294,-4.784),(191.2,4.248,-5.069),(195.5,5.081,-5.335),(192.8,4.833,-4.763),(196.9,8.539,-6.811),(199.4,9.474,-9.668),(196.5,8.236,-10.78),(192.3,2.613,-5.518),(192.1,2.357,-8.949),(190.2,5.926,-8.153),(190.2,6.009,-7.062),(190.7,6.15,-8.261),(190.8,6.232,-7.17),(221.2,-67.64,-3.693),(217.0,-67.57,3.266),(215.5,-73.83,-1.525),(218.5,-61.83,-4.261),(220.9,-67.7,-2.403),(220.3,-68.37,1.94),(219.0,-67.82,2.578),(221.2,-70.57,-3.146),(219.7,-72.45,-2.543),(216.9,-73.48,-1.854),(221.8,-65.14,-4.262),(220.7,-63.36,-4.386),(220.3,-62.26,-4.51),(213.6,-67.06,2.108),(214.7,-68.94,3.368),(209.6,-71.11,-0.9472),(210.6,-72.8,-0.835),(213.9,-74.0,-1.201),(210.9,-66.4,-2.051),(213.0,-64.43,-2.783),(215.2,-63.37,-3.385),(216.8,-68.43,3.628),(215.2,-72.36,3.185),(215.4,-73.45,1.269),(218.0,-62.78,-0.3462),(217.7,-63.73,1.198),(217.2,-65.91,2.824),(220.5,-71.12,-0.4339),(219.0,-69.36,2.639),(217.1,-72.74,1.239),(221.6,-65.21,-3.366),(219.7,-62.8,-2.214),(219.3,-65.42,1.345),(210.9,-71.78,2.307),(212.5,-73.19,2.457),(213.7,-71.34,4.196),(215.7,-66.46,2.585),(216.2,-63.66,0.3457),(218.4,-73.07,-2.2),(221.5,-69.15,-3.474),(221.3,-67.11,-3.803),(221.3,-66.8,-3.869),(221.6,-66.04,-4.054),(220.8,-66.02,-3.126),(220.8,-66.6,-3.18),(221.9,-65.37,-4.229),(221.4,-64.99,-4.209),(221.0,-64.88,-4.156),(221.4,-64.34,-4.321),(220.7,-64.88,-2.939),(220.9,-64.25,-2.511),(220.5,-66.55,-2.773),(220.5,-65.26,-2.41),(219.9,-63.96,-0.9851),(219.0,-63.51,-0.196),(219.5,-61.76,-3.023),(220.8,-63.9,-4.304),(220.3,-63.21,-4.331),(220.3,-62.66,-4.426),(219.9,-61.83,-4.517),(216.5,-62.55,-3.757),(220.1,-63.46,-2.543),(221.3,-64.16,-4.35),(221.0,-63.61,-4.384),(220.7,-63.84,-2.438),(221.2,-64.4,-3.484),(220.7,-65.26,-0.6799),(221.1,-65.6,-3.033),(221.8,-65.6,-3.626),(220.5,-63.54,-2.564),(221.1,-68.21,0.4157),(220.4,-67.34,-2.729),(219.3,-67.05,2.26),(221.4,-68.73,0.2987),(220.6,-67.08,-1.382),(220.8,-67.09,-3.146),(220.6,-67.58,0.7877),(220.3,-67.87,1.846),(220.5,-67.87,-1.529),(221.4,-68.14,-1.381),(219.8,-70.46,1.588),(219.3,-72.02,0.5367),(219.7,-64.51,0.2462),(214.4,-64.11,-3.103),(221.5,-68.3,-3.634),(219.5,-62.57,-1.773),(220.8,-67.45,-3.1),(221.5,-67.93,-2.595),(221.6,-68.42,-2.101),(219.8,-67.21,1.031),(220.4,-66.25,-1.549),(219.7,-66.47,1.083),(220.7,-64.75,-2.212),(208.8,-67.93,-1.389),(209.9,-68.99,2.222),(212.1,-73.63,-0.9418),(210.0,-66.67,-1.033),(209.5,-67.09,-0.8894),(208.9,-66.99,-1.578),(208.5,-66.74,-1.547),(207.4,-66.45,-1.407),(206.5,-65.73,-1.367),(205.5,-64.09,-1.484),(203.4,-62.64,-1.368),(203.5,-61.67,-1.562),(203.7,-59.12,-2.067),(204.6,-57.98,-2.456),(206.6,-57.61,-2.826),(207.2,-59.26,-2.672),(209.2,-60.94,-2.726),(210.3,-63.57,-2.448),(209.4,-65.34,-1.964),(210.1,-65.44,-2.079),(210.5,-65.69,-2.099),(205.4,-61.45,-0.8734),(207.3,-62.47,-1.031),(209.8,-66.23,-1.132),(207.0,-60.75,-1.584),(206.0,-59.11,-1.68),(207.7,-63.75,-1.179),(207.9,-65.08,-1.16),(209.0,-65.87,-0.9363),(205.2,-59.94,-1.445),(208.3,-66.03,-0.9205),(208.8,-66.34,-0.957),(209.3,-66.65,-0.9813),(213.8,-66.96,3.099),(213.9,-66.8,2.915),(214.1,-66.7,2.684),(214.3,-66.72,2.562),(214.5,-66.75,2.385),(214.7,-66.94,2.338),(214.8,-67.17,2.485),(213.8,-67.58,3.464),(214.0,-67.43,3.205),(214.2,-67.46,3.027),(214.3,-67.88,2.759),(214.4,-67.65,2.518),(214.8,-67.51,2.564),(213.4,-67.55,3.787),(213.6,-67.6,3.633),(213.8,-68.25,3.42),(214.6,-68.12,2.877),(214.6,-67.77,2.836),(213.3,-68.04,4.153),(213.8,-68.52,3.564),(214.3,-68.72,3.233),(214.7,-68.64,3.214),(213.3,-68.52,4.36),(213.6,-68.55,4.2),(214.0,-68.93,4.064),(214.2,-69.22,3.553),(214.4,-69.11,3.364),(213.5,-68.94,4.443),(214.3,-69.4,3.856),(214.6,-69.37,3.599),(214.7,-69.2,3.276),(215.0,-69.18,3.408),(213.8,-69.42,4.475),(214.0,-69.61,4.443),(214.2,-69.66,4.275),(214.5,-69.73,4.103),(214.7,-69.67,3.825),(214.9,-69.44,3.527),(213.9,-66.92,3.329),(214.0,-66.76,3.145),(214.2,-66.66,2.913),(214.6,-66.71,2.614),(214.7,-66.89,2.571),(213.8,-67.54,3.693),(214.1,-67.39,3.434),(214.3,-67.42,3.256),(213.5,-67.51,4.016),(213.7,-68.01,4.116),(213.8,-68.48,3.793),(213.3,-68.0,4.382),(213.4,-68.48,4.589),(213.6,-68.51,4.429),(214.0,-68.89,4.293),(214.3,-69.18,3.782),(213.6,-68.9,4.672),(214.1,-69.23,4.395),(214.4,-69.36,4.085),(214.7,-69.33,3.828),(213.9,-69.39,4.704),(214.0,-69.57,4.672),(214.3,-69.62,4.504),(214.5,-69.7,4.332),(214.8,-69.63,4.055),(215.0,-69.4,3.756),(216.0,-68.33,-8.825),(220.7,-67.85,-4.775),(219.4,-69.02,-8.446),(218.0,-68.53,-8.793),(212.9,-67.25,-6.702),(213.8,-69.47,-7.629),(215.9,-69.3,-8.795),(214.4,-72.96,-6.441),(214.9,-73.67,-4.593),(217.4,-63.02,-7.321),(216.9,-64.35,-8.472),(216.2,-66.66,-9.074),(220.5,-71.4,-5.76),(217.8,-70.42,-8.389),(216.6,-73.04,-5.142),(221.4,-65.31,-4.993),(219.3,-63.06,-6.263),(218.4,-66.04,-8.561),(210.3,-72.19,-4.255),(211.9,-73.62,-4.473),(212.7,-72.15,-7.385),(214.8,-67.13,-8.117),(215.5,-64.13,-7.146),(220.7,-66.12,-4.675),(220.7,-66.67,-4.394),(220.5,-65.02,-5.216),(220.6,-64.46,-5.919),(220.3,-66.67,-4.683),(220.2,-65.46,-5.493),(219.3,-64.34,-7.084),(218.3,-63.68,-7.573),(219.3,-61.94,-6.017),(219.8,-63.67,-5.879),(220.4,-64.06,-6.048),(221.0,-64.5,-5.026),(220.1,-65.68,-7.273),(220.9,-65.72,-5.002),(221.7,-65.67,-4.669),(220.3,-63.75,-5.977),(220.5,-68.7,-7.356),(220.2,-67.44,-4.417),(218.3,-67.75,-8.857),(220.7,-69.2,-7.142),(220.2,-67.38,-5.794),(220.7,-67.16,-4.245),(219.8,-68.13,-7.604),(219.4,-68.49,-8.428),(220.2,-68.11,-5.422),(221.0,-68.41,-5.776),(219.0,-71.1,-7.042),(218.8,-72.3,-5.508),(219.0,-65.05,-7.78),(219.0,-62.68,-6.601),(220.7,-67.52,-4.175),(221.3,-68.07,-4.738),(221.4,-68.6,-5.071),(218.9,-67.81,-7.67),(220.0,-66.57,-5.77),(218.9,-67.04,-8.097),(220.4,-65.11,-5.935),(209.3,-69.43,-4.826),(209.9,-66.76,-2.604),(209.4,-67.19,-2.4),(205.6,-62.78,-2.479),(207.2,-63.77,-2.577),(209.7,-66.32,-2.601),(207.4,-61.36,-3.332),(205.9,-59.17,-3.248),(207.8,-64.96,-2.314),(208.9,-65.94,-2.504),(204.7,-60.7,-2.888),(208.2,-66.12,-2.317),(208.7,-66.43,-2.37),(209.2,-66.74,-2.408),(212.9,-67.64,-7.754),(213.0,-67.46,-7.671),(213.2,-67.34,-7.561),(213.4,-67.35,-7.494),(213.6,-67.36,-7.397),(213.8,-67.53,-7.345),(213.9,-67.8,-7.322),(212.8,-68.29,-7.868),(213.0,-68.11,-7.748),(213.3,-68.13,-7.651),(213.4,-68.51,-7.275),(213.6,-68.25,-7.177),(213.9,-68.14,-7.466),(212.3,-68.29,-8.04),(212.6,-68.32,-7.954),(212.8,-68.94,-7.579),(213.7,-68.75,-7.385),(213.7,-68.43,-7.529),(212.2,-68.81,-8.175),(212.8,-69.22,-7.623),(213.4,-69.39,-7.426),(212.2,-69.31,-8.228),(212.5,-69.32,-8.142),(212.9,-69.69,-8.024),(213.3,-69.91,-7.535),(213.5,-69.79,-7.448),(212.4,-69.73,-8.222),(213.3,-70.13,-7.792),(213.6,-70.07,-7.66),(213.8,-69.86,-7.337),(214.1,-69.9,-7.722),(212.7,-70.22,-8.182),(212.9,-70.4,-8.143),(213.1,-70.44,-8.049),(213.4,-70.49,-7.95),(213.7,-70.39,-7.812),(214.0,-70.14,-7.682),(212.9,-67.59,-8.01),(213.0,-67.45,-7.928),(213.3,-67.33,-7.818),(213.7,-67.35,-7.654),(213.8,-67.52,-7.602),(214.0,-67.79,-7.579),(212.8,-68.28,-8.125),(213.1,-68.1,-8.005),(213.3,-68.12,-7.908),(212.4,-68.28,-8.297),(212.6,-68.79,-8.292),(212.2,-68.8,-8.432),(212.5,-69.31,-8.399),(212.3,-69.3,-8.485),(212.9,-69.68,-8.281),(213.3,-69.9,-7.793),(212.5,-69.72,-8.479),(213.0,-70.02,-8.295),(213.4,-70.12,-8.049),(213.7,-70.06,-7.918),(213.8,-69.84,-7.643),(212.7,-70.21,-8.439),(212.9,-70.39,-8.4),(213.2,-70.43,-8.306),(213.4,-70.48,-8.207),(213.8,-70.39,-8.069),(214.0,-70.13,-7.939),(217.5,-64.78,2.213),(216.6,-65.34,-9.014),(213.0,-48.93,8.325),(206.0,-54.48,-14.04),(274.2,-44.88,-14.17),(281.4,-37.91,-15.8),(284.0,-45.13,-13.62),(272.8,-42.06,-14.48),(273.6,-44.49,-8.947),(275.2,-42.92,-5.443),(278.2,-42.53,-5.823),(276.9,-40.82,-5.268),(283.1,-44.75,-7.149),(279.4,-39.33,-7.237),(280.5,-38.34,-10.21),(274.8,-41.78,-8.13),(283.5,-45.58,-19.98),(274.0,-45.19,-19.76),(275.7,-44.05,-22.93),(278.8,-43.7,-22.83),(277.0,-42.15,-24.22),(279.4,-40.44,-23.32),(280.6,-39.13,-20.76),(274.8,-42.77,-21.07),(281.5,-53.59,-21.89),(274.5,-53.09,-25.38),(278.3,-52.29,-23.62),(276.8,-51.28,-26.69),(276.0,-57.51,-20.97),(276.7,-59.96,-10.63),(273.6,-48.67,-13.19),(273.6,-53.72,-12.12),(284.9,-49.5,-12.16),(283.7,-52.6,-12.76),(287.2,-48.95,-18.49),(286.7,-50.56,-14.7),(286.4,-50.58,-21.21),(284.9,-52.39,-18.64),(285.5,-46.74,-18.63),(277.5,-62.23,-9.913),(273.2,-48.39,-7.192),(274.7,-56.76,-5.8),(274.3,-47.4,-3.098),(281.4,-48.73,-1.044),(279.8,-45.82,-4.048),(286.8,-48.19,-6.758),(285.8,-49.44,-3.612),(284.4,-51.72,-5.736),(286.6,-50.24,-9.874),(283.7,-52.46,-10.74),(279.8,-52.54,-3.022),(284.1,-48.79,-1.621),(284.4,-46.89,-3.518),(285.2,-46.03,-7.698),(282.4,-46.81,-1.36),(282.6,-45.68,-3.019),(284.3,-45.32,-6.397),(277.5,-50.6,-0.9338),(275.4,-50.75,-1.027),(277.8,-58.57,-6.802),(273.5,-53.74,-1.259),(278.1,-57.87,-8.732),(279.0,-60.66,-7.169),(275.2,-56.87,-1.099),(275.8,-57.2,-4.586),(280.7,-56.56,-10.97),(280.5,-56.69,-8.711),(282.5,-54.56,-9.747),(281.4,-54.46,-11.23),(282.6,-54.7,-13.04),(279.0,-57.44,-9.184),(281.2,-58.97,-10.59),(279.6,-60.17,-8.141),(279.2,-57.77,-12.7),(279.9,-60.35,-12.38),(281.5,-56.1,-14.58),(284.8,-46.23,-20.38),(284.8,-50.23,-23.77),(285.3,-47.91,-22.66),(277.9,-58.97,-15.14),(279.3,-61.05,-13.68),(275.6,-57.08,-24.93),(273.6,-49.21,-19.83),(277.0,-57.11,-19.85),(275.0,-48.7,-23.17),(283.1,-49.58,-24.86),(280.4,-47.06,-23.24),(284.0,-47.67,-24.88),(283.3,-47.04,-23.94),(276.9,-51.33,-27.19),(286.7,-47.88,-18.54),(286.4,-47.14,-7.199),(287.1,-49.94,-12.24),(278.6,-57.86,-15.99),(275.4,-50.79,-1.575),(276.9,-51.29,-27.21),(280.0,-55.23,-4.236),(281.2,-55.62,-21.36),(276.2,-57.95,-21.14),(275.9,-57.72,-4.386),(276.6,-58.18,-6.327),(276.9,-58.58,-16.47),(277.8,-60.84,-12.53),(278.3,-61.78,-13.38),(276.9,-59.59,-12.74),(277.7,-60.74,-8.533),(278.2,-61.26,-7.131),(276.8,-59.39,-8.879),(277.4,-61.54,-10.11),(278.3,-55.15,2.012),(276.2,-55.97,1.339),(277.1,-51.01,4.301),(276.7,-53.24,4.539),(276.0,-51.06,2.368),(280.3,-54.13,1.048),(265.8,-48.58,0.2518),(267.6,-46.49,3.051),(267.9,-47.81,5.821),(267.1,-49.58,6.06),(269.4,-52.49,2.527),(265.1,-46.19,0.8813),(263.2,-46.75,2.277),(263.8,-49.31,3.69),(268.4,-43.53,2.458),(266.7,-43.26,0.3739),(266.7,-35.34,0.04177),(268.2,-35.52,1.421),(265.3,-43.07,1.74),(265.2,-34.95,2.618),(263.7,-42.98,4.696),(263.2,-44.0,3.478),(262.8,-46.73,3.875),(264.1,-46.52,6.066),(266.3,-34.94,4.141),(265.4,-43.13,6.152),(267.6,-35.07,3.777),(267.1,-43.33,5.756),(265.7,-46.21,6.615),(267.1,-46.44,5.782),(267.7,-32.04,0.8378),(267.9,-31.55,1.657),(265.5,-31.86,2.683),(268.1,-33.04,0.4557),(269.1,-32.85,1.384),(263.8,-32.82,3.395),(266.6,-29.94,-0.1643),(266.7,-30.41,2.228),(267.1,-29.91,2.389),(266.4,-30.17,-1.629),(266.2,-30.66,-1.075),(265.8,-30.24,-0.268),(265.9,-30.46,-1.526),(266.4,-30.42,0.07527),(265.5,-30.47,-2.006),(265.3,-30.93,-1.428),(264.9,-30.7,-0.1139),(265.4,-30.74,0.006011),(264.9,-30.73,-1.694),(264.9,-31.02,-1.306),(264.7,-31.42,-0.7092),(264.3,-31.13,0.2651),(264.7,-31.23,0.4444),(264.3,-31.31,-1.091),(264.4,-31.12,2.604),(264.8,-31.26,2.218),(264.0,-31.73,2.309),(264.3,-31.4,1.533),(264.4,-31.64,0.343),(264.2,-32.03,0.5427),(263.7,-31.76,1.653),(264.1,-31.85,1.704),(263.8,-31.91,0.3064),(263.6,-31.89,2.864),(268.1,-31.84,2.655),(267.3,-31.12,4.336),(266.2,-31.7,4.542),(264.8,-32.41,3.966),(266.2,-29.85,0.2584),(266.2,-29.97,-0.6433),(266.6,-29.91,3.314),(266.3,-29.72,1.551),(266.0,-30.17,2.431),(265.5,-30.14,3.117),(265.3,-30.04,1.468),(265.3,-30.18,0.07101),(265.3,-30.27,-0.7048),(265.1,-30.62,2.459),(264.8,-30.72,3.185),(264.6,-30.58,2.045),(264.5,-30.76,-0.08076),(264.6,-30.67,0.6197),(263.9,-31.31,1.887),(263.9,-31.35,1.311),(264.0,-31.26,2.924),(264.1,-31.66,3.581),(268.4,-30.69,-0.349),(269.3,-30.28,-1.223),(269.1,-30.1,-0.7247),(268.7,-31.33,-0.581),(269.7,-30.34,-0.7383),(269.4,-31.11,0.1103),(269.1,-31.85,0.7483),(268.8,-30.83,0.7731),(268.9,-30.53,0.3889),(269.5,-30.15,-0.3127),(277.2,-55.25,2.472),(278.4,-55.84,-27.69),(276.9,-55.11,-28.46),(277.5,-52.52,-30.56),(280.4,-53.47,-30.18),(281.4,-51.75,-27.43),(280.4,-54.98,-26.47),(279.0,-43.31,-28.0),(282.3,-44.07,-29.88),(281.4,-44.67,-32.83),(279.3,-44.88,-33.63),(276.8,-47.43,-30.48),(280.7,-42.86,-28.09),(279.9,-41.44,-29.92),(277.9,-42.31,-31.92),(284.4,-45.01,-28.29),(284.1,-43.5,-26.43),(293.0,-42.35,-23.25),(292.9,-43.7,-24.48),(284.2,-42.31,-27.93),(294.0,-41.2,-25.72),(284.4,-41.1,-31.05),(283.0,-40.86,-30.27),(280.0,-41.2,-31.54),(280.9,-42.28,-33.4),(294.2,-42.2,-27.07),(284.8,-42.63,-32.23),(293.8,-43.28,-26.65),(284.9,-44.04,-31.64),(281.6,-43.54,-33.59),(281.5,-44.76,-32.61),(295.1,-44.48,-22.93),(295.4,-45.0,-23.47),(297.3,-43.54,-23.6),(293.9,-43.83,-23.25),(293.6,-44.59,-24.27),(298.2,-41.97,-24.19),(296.9,-45.43,-20.97),(297.2,-45.34,-22.98),(297.3,-45.98,-23.08),(296.3,-44.84,-20.08),(296.5,-44.52,-20.93),(297.3,-44.74,-20.92),(296.6,-44.4,-20.29),(297.0,-45.04,-21.58),(296.7,-44.05,-19.78),(296.9,-43.76,-20.64),(297.8,-44.0,-21.22),(297.5,-44.25,-21.53),(297.1,-43.62,-20.09),(297.2,-43.5,-20.68),(297.4,-43.26,-21.49),(298.2,-43.42,-21.73),(297.9,-43.64,-22.13),(297.6,-43.05,-20.95),(298.7,-43.69,-22.91),(298.2,-43.81,-22.59),(298.6,-43.03,-22.55),(298.5,-43.51,-22.9),(298.0,-43.15,-22.37),(298.0,-42.83,-22.87),(298.8,-42.93,-23.12),(298.5,-43.05,-23.27),(298.2,-42.68,-22.45),(298.9,-42.66,-23.09),(295.3,-44.99,-24.45),(296.7,-45.15,-25.36),(297.3,-44.17,-25.47),(297.9,-42.83,-24.82),(297.4,-45.36,-21.05),(297.0,-45.06,-20.49),(297.8,-45.72,-23.95),(297.9,-45.79,-22.02),(298.0,-45.24,-22.92),(298.5,-45.05,-23.46),(298.4,-44.99,-21.89),(297.9,-44.57,-20.93),(297.5,-44.35,-20.44),(298.4,-44.44,-22.91),(298.7,-44.19,-23.55),(298.9,-44.3,-22.66),(298.1,-43.74,-21.17),(298.4,-43.98,-21.61),(298.9,-43.38,-22.8),(298.8,-43.31,-22.6),(299.0,-43.38,-23.13),(298.7,-43.14,-23.85),(294.9,-45.73,-21.1),(294.2,-46.49,-20.38),(294.7,-46.54,-20.64),(294.2,-45.42,-21.41),(294.1,-46.66,-20.96),(294.0,-46.0,-22.12),(294.0,-45.35,-23.07),(294.8,-45.97,-22.35),(294.8,-46.23,-21.86),(294.5,-46.74,-21.17),(278.8,-55.24,-29.0),(278.3,-52.29,-23.64),(276.8,-51.28,-26.71),(280.9,-33.57,-16.72),(278.8,-32.49,-16.81),(268.9,-37.51,-15.15),(270.7,-31.51,-16.12),(273.8,-30.51,-16.23),(270.6,-40.38,-14.62),(277.4,-39.14,-26.39),(274.8,-40.73,-24.21),(279.1,-36.57,-24.87),(279.9,-34.73,-20.91),(270.6,-40.88,-20.02),(278.8,-11.61,-33.23),(279.1,-16.09,-31.53),(275.3,-12.59,-29.32),(278.1,-16.18,-28.58),(279.1,-15.59,-25.01),(276.5,-11.87,-26.08),(279.7,-10.57,-25.12),(281.0,-15.69,-33.35),(281.0,-14.95,-23.85),(283.7,-14.23,-24.93),(282.3,-9.983,-29.7),(284.9,-14.22,-29.02),(283.7,-14.82,-32.2),(281.4,-19.53,-33.07),(281.4,-18.46,-22.34),(284.1,-19.68,-23.94),(285.5,-20.63,-27.96),(284.1,-20.38,-30.5),(279.2,-28.25,-32.09),(275.9,-26.62,-30.87),(275.0,-24.03,-27.53),(275.6,-23.39,-22.59),(279.3,-25.64,-19.67),(282.4,-27.13,-21.28),(283.6,-28.54,-25.28),(281.9,-28.9,-29.13),(275.6,-37.0,-28.4),(272.8,-32.37,-30.53),(272.8,-28.82,-26.5),(271.7,-30.4,-17.71),(274.4,-28.56,-18.53),(272.6,-38.33,-27.28),(272.1,-35.54,-29.28),(267.8,-36.6,-24.91),(269.0,-38.1,-24.01),(268.2,-38.95,-16.82),(267.1,-37.23,-17.89),(268.3,-35.74,-15.51),(269.5,-34.73,-14.58),(267.0,-34.9,-24.18),(269.0,-30.67,-23.91),(266.5,-34.41,-18.31),(270.8,-30.24,-20.48),(268.1,-33.35,-15.99),(270.6,-32.9,-13.94),(276.0,-6.279,-34.84),(274.2,-6.655,-33.49),(273.3,-6.771,-30.09),(274.1,-6.188,-26.9),(276.0,-5.631,-25.79),(277.9,-5.012,-27.2),(278.6,-5.049,-30.2),(277.8,-5.6,-33.57),(272.4,-0.03664,-34.76),(270.9,-0.5206,-33.84),(270.2,-0.5935,-31.09),(270.9,-0.155,-28.49),(272.4,0.4727,-27.46),(274.1,0.9637,-28.75),(274.8,0.8034,-31.16),(274.1,0.4876,-33.86),(271.0,5.056,-34.24),(269.6,4.388,-34.02),(268.9,4.26,-31.86),(269.5,4.665,-30.57),(271.2,5.438,-30.12),(272.5,5.993,-30.98),(272.9,6.071,-32.75),(272.5,5.718,-34.01),(274.4,6.719,-34.89),(275.1,7.284,-33.25),(277.7,8.589,-34.49),(275.1,8.284,-35.53),(274.4,7.054,-31.49),(275.3,8.614,-31.18),(277.8,8.776,-32.41),(272.4,6.904,-29.91),(268.3,5.826,-29.48),(268.1,6.816,-30.16),(269.8,7.012,-29.39),(267.6,5.511,-32.09),(267.5,6.558,-32.33),(267.9,5.183,-34.45),(267.9,6.473,-34.59),(272.3,6.028,-35.23),(269.6,6.522,-35.35),(275.1,8.97,-35.58),(278.1,9.542,-33.57),(275.1,9.334,-31.59),(268.4,4.577,-33.51),(268.5,4.869,-30.08),(268.0,8.594,-32.29),(268.0,8.499,-33.39),(268.6,8.654,-32.36),(268.6,8.559,-33.45),(272.9,-30.82,-18.08),(276.2,-31.3,-18.1),(278.1,-37.48,-4.602),(275.3,-39.33,-5.702),(279.6,-35.24,-7.368),(280.2,-34.06,-12.08),(270.9,-40.05,-9.204),(288.2,-20.35,-9.942),(291.6,-23.1,-11.07),(286.9,-23.84,-12.22),(290.8,-24.23,-13.51),(290.9,-23.86,-17.44),(286.9,-23.15,-15.94),(287.6,-20.5,-18.29),(292.6,-21.49,-10.09),(291.6,-22.58,-19.38),(293.1,-20.43,-19.51),(288.7,-17.71,-14.97),(294.2,-19.09,-16.05),(293.9,-19.62,-12.41),(293.4,-23.26,-9.202),(291.9,-23.79,-19.82),(294.1,-25.53,-18.28),(295.6,-26.39,-14.29),(294.9,-25.33,-11.73),(286.4,-29.47,-5.525),(284.6,-26.56,-6.72),(285.0,-24.32,-11.06),(284.9,-24.56,-16.21),(285.8,-28.37,-18.24),(287.4,-31.1,-16.71),(288.4,-32.4,-12.76),(287.5,-31.58,-8.623),(275.9,-33.63,-3.311),(278.1,-29.95,-3.258),(269.0,-28.48,-8.816),(279.5,-28.22,-16.89),(273.2,-36.53,-3.531),(272.0,-33.69,-3.152),(268.3,-35.16,-6.018),(269.5,-36.75,-6.374),(268.3,-38.65,-12.84),(267.3,-36.82,-12.43),(269.4,-34.92,-16.98),(267.5,-33.62,-7.366),(267.0,-32.03,-10.29),(266.6,-34.02,-13.17),(268.5,-31.49,-13.88),(268.1,-33.33,-15.7),(270.5,-33.25,-18.52),(281.4,-18.91,-8.697),(280.7,-20.6,-9.253),(280.3,-21.78,-12.2),(280.1,-21.43,-15.69),(280.6,-20.05,-17.53),(281.0,-18.24,-16.97),(281.5,-17.29,-14.33),(281.7,-17.55,-10.7),(272.6,-18.14,-8.863),(272.2,-19.62,-9.103),(271.9,-20.58,-11.5),(271.8,-20.29,-14.34),(272.0,-19.05,-16.01),(272.4,-17.42,-15.45),(273.0,-16.66,-13.33),(272.9,-16.87,-10.42),(265.8,-16.95,-9.962),(266.0,-18.26,-9.553),(266.0,-19.1,-11.61),(265.9,-18.66,-12.96),(265.7,-17.19,-14.13),(265.5,-15.9,-13.84),(265.5,-15.25,-12.19),(265.6,-15.51,-10.84),(264.3,-13.82,-10.62),(263.9,-13.34,-12.54),(262.9,-10.88,-12.3),(262.6,-12.9,-10.57),(264.2,-14.09,-14.03),(262.6,-13.17,-14.95),(262.9,-10.96,-14.41),(264.1,-15.93,-15.03),(264.4,-19.5,-14.13),(263.2,-19.39,-13.67),(263.5,-18.13,-14.89),(264.3,-19.77,-11.35),(263.2,-19.65,-11.34),(264.5,-19.22,-9.092),(263.3,-19.12,-9.217),(264.6,-15.56,-9.591),(263.5,-17.67,-8.914),(261.8,-12.81,-10.7),(262.0,-10.47,-13.55),(261.7,-13.21,-14.67),(265.4,-19.18,-9.954),(265.3,-19.41,-13.4),(260.8,-19.03,-12.04),(260.9,-18.94,-10.95),(260.9,-18.49,-12.15),(260.9,-18.4,-11.06),(286.3,-63.8,-10.32),(281.7,-63.8,-3.812),(280.7,-70.17,-8.501),(283.3,-58.09,-11.39),(285.9,-63.86,-9.065),(285.1,-64.49,-4.767),(283.8,-63.98,-4.284),(286.4,-66.72,-9.655),(284.9,-68.65,-9.14),(282.2,-69.76,-8.695),(286.8,-61.28,-10.92),(285.6,-59.55,-11.23),(285.2,-58.47,-11.44),(278.3,-63.42,-5.339),(279.5,-65.24,-3.888),(274.7,-67.65,-8.636),(275.8,-69.29,-8.346),(279.1,-70.39,-8.336),(275.9,-62.91,-9.783),(277.9,-60.87,-10.38),(280.1,-59.74,-10.79),(281.5,-64.66,-3.44),(280.2,-68.65,-3.888),(280.5,-69.75,-5.732),(282.7,-59.02,-7.498),(282.4,-59.96,-5.953),(281.9,-62.14,-4.294),(285.5,-67.26,-7.008),(283.8,-65.53,-4.168),(282.2,-68.98,-5.616),(286.5,-61.35,-10.05),(284.4,-59.01,-9.192),(284.0,-61.59,-5.583),(275.9,-68.23,-5.229),(277.5,-69.58,-4.859),(278.6,-67.67,-3.076),(280.4,-62.74,-4.666),(280.9,-59.95,-6.964),(283.7,-69.3,-8.904),(286.6,-65.29,-10.01),(286.3,-63.27,-10.44),(286.4,-62.95,-10.52),(286.6,-62.19,-10.7),(285.8,-62.19,-9.855),(285.8,-62.77,-9.894),(286.9,-61.52,-10.87),(286.4,-61.15,-10.92),(286.0,-61.06,-10.91),(286.3,-60.51,-11.06),(285.6,-61.05,-9.725),(285.8,-60.4,-9.302),(285.4,-62.72,-9.523),(285.4,-61.44,-9.208),(284.6,-60.14,-7.901),(283.7,-59.71,-7.217),(284.3,-57.98,-10.06),(285.8,-60.08,-11.11),(285.2,-59.42,-11.22),(285.1,-58.86,-11.34),(284.8,-58.06,-11.5),(281.3,-58.89,-11.07),(284.9,-59.65,-9.447),(286.3,-60.32,-11.1),(285.9,-59.79,-11.19),(285.5,-60.0,-9.27),(286.1,-60.57,-10.24),(285.5,-61.41,-7.462),(286.0,-61.76,-9.753),(286.7,-61.75,-10.28),(285.4,-59.72,-9.424),(286.0,-64.32,-6.208),(285.4,-63.52,-9.456),(284.0,-63.21,-4.604),(286.3,-64.84,-6.281),(285.5,-63.24,-8.104),(285.8,-63.26,-9.842),(285.4,-63.71,-5.921),(285.1,-63.99,-4.879),(285.5,-64.03,-8.222),(286.4,-64.26,-7.975),(284.7,-66.6,-5.086),(284.4,-68.19,-6.12),(284.4,-60.68,-6.67),(279.3,-60.51,-10.56),(286.6,-64.44,-10.2),(284.2,-58.77,-8.78),(285.8,-63.62,-9.778),(286.5,-64.07,-9.182),(286.6,-64.54,-8.66),(284.6,-63.36,-5.77),(285.3,-62.42,-8.322),(284.5,-62.62,-5.758),(285.6,-60.92,-9.004),(273.8,-64.5,-9.278),(274.8,-65.48,-5.521),(277.3,-70.08,-8.275),(275.0,-63.19,-8.848),(274.4,-63.64,-8.743),(273.9,-63.56,-9.493),(273.5,-63.33,-9.514),(272.4,-63.07,-9.495),(271.4,-62.39,-9.58),(270.3,-60.78,-9.863),(268.2,-59.41,-10.02),(268.2,-58.44,-10.24),(268.4,-55.89,-10.82),(269.2,-54.72,-11.17),(271.2,-54.29,-11.34),(271.9,-55.91,-11.06),(273.9,-57.52,-10.85),(275.1,-60.11,-10.36),(274.3,-61.9,-9.895),(275.0,-61.97,-9.931),(275.4,-62.22,-9.903),(270.0,-58.15,-9.372),(272.1,-59.1,-9.288),(274.8,-62.76,-8.983),(271.7,-57.4,-9.937),(270.6,-55.8,-10.21),(272.5,-60.36,-9.346),(272.8,-61.68,-9.25),(273.9,-62.44,-8.885),(269.8,-56.65,-10.02),(273.2,-62.62,-8.94),(273.7,-62.91,-8.906),(274.2,-63.2,-8.869),(278.5,-63.31,-4.328),(278.6,-63.14,-4.509),(278.8,-63.03,-4.723),(279.0,-63.05,-4.827),(279.2,-63.08,-4.979),(279.4,-63.26,-5.0),(279.6,-63.49,-4.832),(278.5,-63.91,-3.945),(278.7,-63.76,-4.188),(279.0,-63.79,-4.341),(279.1,-64.21,-4.583),(279.2,-63.97,-4.819),(279.6,-63.83,-4.739),(278.1,-63.9,-3.664),(278.3,-63.94,-3.794),(278.5,-64.59,-3.964),(279.3,-64.44,-4.428),(279.4,-64.09,-4.476),(278.0,-64.39,-3.291),(278.5,-64.86,-3.809),(279.1,-65.04,-4.077),(279.5,-64.95,-4.06),(278.1,-64.86,-3.058),(278.3,-64.88,-3.195),(278.7,-65.25,-3.273),(279.0,-65.54,-3.744),(279.2,-65.43,-3.921),(278.3,-65.27,-2.941),(279.1,-65.71,-3.425),(279.4,-65.67,-3.653),(279.5,-65.51,-3.977),(279.8,-65.47,-3.816),(278.6,-65.75,-2.86),(278.8,-65.93,-2.868),(279.0,-65.98,-3.01),(279.3,-66.04,-3.153),(279.5,-65.96,-3.404),(279.8,-65.73,-3.689),(278.6,-63.26,-4.094),(278.7,-63.09,-4.275),(278.9,-62.99,-4.488),(279.3,-63.03,-4.745),(279.5,-63.2,-4.766),(278.6,-63.87,-3.71),(278.8,-63.72,-3.954),(279.0,-63.74,-4.107),(278.2,-63.86,-3.43),(278.4,-64.34,-3.289),(278.6,-64.81,-3.575),(278.1,-64.34,-3.056),(278.1,-64.82,-2.824),(278.4,-64.84,-2.961),(278.8,-65.21,-3.039),(279.1,-65.49,-3.509),(278.3,-65.23,-2.706),(278.9,-65.54,-2.913),(279.2,-65.67,-3.191),(279.5,-65.63,-3.419),(278.6,-65.7,-2.625),(278.8,-65.89,-2.633),(279.1,-65.93,-2.775),(279.3,-66.0,-2.919),(279.6,-65.92,-3.169),(279.8,-65.69,-3.455),(281.3,-64.73,-15.95),(285.8,-64.04,-11.45),(284.8,-65.3,-15.19),(283.4,-64.86,-15.7),(278.2,-63.74,-14.18),(279.2,-65.94,-14.93),(281.3,-65.7,-15.88),(279.8,-69.39,-13.55),(280.3,-70.06,-11.62),(282.4,-59.37,-14.51),(282.0,-60.72,-15.66),(281.5,-63.06,-16.24),(285.8,-67.61,-12.31),(283.2,-66.75,-15.24),(282.0,-69.37,-12.03),(286.5,-61.48,-11.69),(284.3,-59.32,-13.26),(283.6,-62.36,-15.53),(275.7,-68.74,-11.81),(277.3,-70.11,-11.81),(278.2,-68.65,-14.69),(280.1,-63.57,-15.41),(280.6,-60.53,-14.48),(285.8,-62.31,-11.41),(285.7,-62.86,-11.11),(285.6,-61.23,-12.01),(285.7,-60.67,-12.72),(285.4,-62.87,-11.44),(285.3,-61.67,-12.3),(284.4,-60.62,-14.02),(283.4,-59.99,-14.64),(284.2,-58.2,-13.06),(284.8,-59.91,-12.8),(285.4,-60.28,-12.89),(286.0,-60.69,-11.79),(285.3,-61.93,-14.08),(286.0,-61.91,-11.73),(286.7,-61.83,-11.32),(285.2,-59.98,-12.85),(285.8,-64.93,-14.01),(285.3,-63.65,-11.15),(283.6,-64.07,-15.76),(286.0,-65.41,-13.75),(285.3,-63.6,-12.53),(285.7,-63.35,-10.95),(285.1,-64.38,-14.34),(284.8,-64.76,-15.19),(285.4,-64.33,-12.13),(286.2,-64.6,-12.39),(284.4,-67.37,-13.75),(284.2,-68.56,-12.19),(284.2,-61.34,-14.72),(284.0,-58.95,-13.64),(285.8,-63.7,-10.86),(286.5,-64.23,-11.33),(286.5,-64.77,-11.64),(284.2,-64.1,-14.51),(285.1,-62.8,-12.56),(284.2,-63.33,-14.97),(285.5,-61.32,-12.73),(274.5,-66.03,-12.59),(274.9,-63.31,-10.42),(274.4,-63.75,-10.26),(270.5,-59.48,-10.89),(272.1,-60.42,-10.79),(274.7,-62.87,-10.46),(272.2,-58.01,-11.61),(270.6,-55.87,-11.77),(272.7,-61.58,-10.42),(273.9,-62.53,-10.46),(269.5,-57.45,-11.48),(273.1,-62.73,-10.34),(273.7,-63.02,-10.32),(274.2,-63.31,-10.3),(278.2,-64.15,-15.22),(278.3,-63.96,-15.13),(278.5,-63.83,-15.0),(278.7,-63.83,-14.92),(278.9,-63.84,-14.8),(279.1,-64.0,-14.72),(279.2,-64.26,-14.68),(278.1,-64.79,-15.32),(278.3,-64.61,-15.18),(278.6,-64.61,-15.06),(278.7,-64.99,-14.65),(278.9,-64.73,-14.55),(279.2,-64.61,-14.81),(277.7,-64.82,-15.53),(277.9,-64.84,-15.42),(278.1,-65.44,-15.0),(279.0,-65.23,-14.73),(279.1,-64.9,-14.88),(277.6,-65.34,-15.66),(278.2,-65.73,-15.04),(278.7,-65.87,-14.78),(277.6,-65.84,-15.69),(277.9,-65.84,-15.58),(278.3,-66.19,-15.41),(278.7,-66.4,-14.87),(278.8,-66.27,-14.77),(277.8,-66.25,-15.65),(278.7,-66.62,-15.11),(279.0,-66.55,-14.95),(279.1,-66.33,-14.63),(279.5,-66.36,-14.98),(278.1,-66.73,-15.56),(278.3,-66.91,-15.5),(278.6,-66.93,-15.38),(278.8,-66.97,-15.25),(279.1,-66.87,-15.08),(279.4,-66.6,-14.94),(278.2,-64.1,-15.48),(278.3,-63.95,-15.39),(278.5,-63.82,-15.26),(279.0,-63.83,-15.05),(279.1,-63.99,-14.98),(279.2,-64.25,-14.93),(278.2,-64.79,-15.57),(278.4,-64.6,-15.43),(278.6,-64.61,-15.31),(277.7,-64.81,-15.79),(278.0,-65.31,-15.74),(277.6,-65.34,-15.92),(277.9,-65.83,-15.84),(277.7,-65.83,-15.95),(278.4,-66.18,-15.66),(278.7,-66.39,-15.13),(277.9,-66.25,-15.9),(278.5,-66.52,-15.65),(278.8,-66.61,-15.37),(279.1,-66.54,-15.21),(279.2,-66.31,-14.93),(278.2,-66.72,-15.82),(278.4,-66.9,-15.75),(278.6,-66.92,-15.63),(278.9,-66.97,-15.5),(279.2,-66.86,-15.34),(279.4,-66.6,-15.19),(282.1,-61.01,-4.925),(281.8,-61.73,-16.19),(269.8,-51.2,-0.9405),(278.5,-47.21,-26.36),(338.6,-45.15,-22.77),(346.0,-38.4,-24.78),(348.4,-45.75,-23.28),(337.3,-42.27,-22.77),(338.3,-44.84,-17.48),(340.0,-43.4,-14.06),(343.1,-43.11,-14.75),(341.9,-41.37,-13.96),(347.8,-45.47,-16.71),(344.4,-39.93,-16.11),(345.4,-38.91,-19.14),(339.6,-42.19,-16.64),(347.5,-46.05,-29.59),(338.0,-45.33,-28.33),(339.7,-44.19,-31.61),(342.7,-43.94,-31.82),(341.0,-42.31,-32.93),(343.5,-40.71,-32.21),(344.9,-39.49,-29.71),(338.9,-42.91,-29.59),(345.0,-53.93,-31.71),(336.6,-56.29,-29.08),(341.8,-52.49,-33.03),(337.1,-54.73,-31.06),(338.8,-58.44,-26.08),(340.5,-60.36,-20.33),(337.8,-48.93,-21.92),(337.6,-53.99,-21.14),(349.1,-50.17,-22.15),(347.7,-53.22,-22.8),(351.1,-49.57,-28.69),(350.7,-51.24,-24.94),(350.1,-51.12,-31.4),(348.6,-52.93,-28.78),(349.5,-47.31,-28.53),(341.2,-62.67,-19.82),(337.7,-48.76,-15.89),(338.9,-57.2,-15.12),(339.1,-47.89,-11.88),(346.2,-49.51,-10.66),(344.6,-46.48,-13.32),(351.4,-49.04,-16.91),(350.4,-50.32,-13.73),(349.5,-51.72,-15.49),(350.8,-51.02,-20.1),(347.8,-53.12,-20.78),(345.6,-52.15,-11.0),(348.8,-49.65,-11.53),(349.1,-47.72,-13.35),(349.8,-46.81,-17.55),(347.3,-47.62,-10.98),(347.5,-46.46,-12.59),(349.0,-46.1,-16.13),(342.2,-51.24,-10.24),(340.1,-51.32,-10.11),(341.8,-59.09,-16.54),(339.5,-52.47,-7.169),(342.5,-57.63,-14.57),(342.9,-61.21,-17.16),(341.1,-55.63,-6.512),(341.1,-56.34,-9.934),(344.6,-57.1,-20.9),(345.0,-56.62,-15.56),(346.8,-54.74,-17.76),(345.4,-55.02,-21.13),(346.5,-55.26,-23.07),(343.0,-57.96,-18.99),(345.0,-59.53,-20.71),(343.5,-60.72,-18.16),(342.9,-58.22,-22.53),(343.5,-60.83,-22.42),(345.2,-56.59,-24.56),(348.7,-46.73,-30.16),(348.4,-50.66,-33.76),(349.1,-48.39,-32.59),(341.5,-59.33,-24.89),(342.9,-61.48,-23.7),(338.3,-58.8,-29.67),(337.4,-49.33,-28.58),(339.7,-57.85,-24.96),(338.7,-48.8,-32.02),(345.6,-50.99,-33.97),(344.2,-47.35,-32.58),(346.7,-49.04,-34.53),(347.0,-47.41,-33.6),(337.0,-54.81,-31.59),(350.7,-48.48,-28.62),(350.9,-47.97,-17.24),(351.2,-50.69,-22.49),(342.1,-58.22,-25.76),(340.1,-51.34,-10.66),(337.0,-54.79,-31.6),(345.2,-54.83,-11.45),(343.9,-56.68,-28.23),(339.0,-58.89,-26.19),(341.1,-56.83,-9.596),(340.6,-58.67,-15.92),(340.4,-58.87,-26.09),(341.4,-61.24,-22.37),(341.8,-62.18,-23.33),(340.5,-59.96,-22.43),(341.5,-61.21,-18.38),(342.1,-61.78,-17.07),(340.7,-59.83,-18.56),(341.1,-61.97,-19.96),(344.7,-53.83,-5.111),(342.0,-53.88,-4.268),(342.0,-51.74,-4.996),(344.4,-51.32,-3.158),(344.6,-49.56,-6.214),(346.5,-53.07,-6.989),(338.0,-42.61,-7.56),(341.3,-41.92,-5.845),(340.9,-42.64,-2.691),(339.1,-43.55,-1.663),(338.4,-47.32,-4.094),(339.5,-40.78,-7.922),(338.1,-39.64,-6.317),(336.4,-41.66,-3.769),(344.0,-41.48,-7.625),(343.0,-40.38,-9.782),(350.7,-36.59,-14.07),(351.3,-37.68,-12.55),(342.6,-39.11,-8.595),(350.9,-34.97,-11.97),(342.3,-37.65,-5.836),(340.8,-37.97,-6.507),(338.1,-39.22,-4.793),(339.4,-39.74,-2.795),(351.6,-35.68,-10.43),(343.3,-38.82,-4.335),(351.9,-36.79,-10.58),(344.0,-40.14,-4.587),(340.7,-40.6,-2.411),(341.2,-41.8,-3.108),(354.3,-37.35,-14.66),(355.0,-37.46,-14.1),(355.0,-35.29,-13.74),(353.1,-37.62,-14.38),(353.5,-38.35,-13.3),(354.3,-33.66,-13.17),(356.2,-36.84,-17.01),(356.5,-36.49,-14.57),(357.0,-36.88,-14.6),(355.5,-36.85,-18.17),(355.2,-36.53,-17.41),(355.8,-36.12,-17.19),(355.2,-36.39,-18.05),(355.8,-36.56,-16.53),(355.1,-36.1,-18.61),(354.8,-35.8,-17.84),(355.4,-35.34,-17.02),(355.4,-35.71,-16.71),(354.9,-35.55,-18.36),(354.7,-35.44,-17.82),(354.5,-35.16,-17.07),(355.1,-34.7,-16.61),(355.0,-35.03,-16.21),(354.5,-34.92,-17.62),(355.9,-34.48,-14.57),(355.6,-34.89,-14.67),(355.2,-34.15,-14.62),(355.2,-34.56,-15.29),(354.6,-34.7,-16.13),(354.2,-34.48,-15.73),(354.9,-33.97,-15.15),(354.8,-34.27,-14.9),(354.3,-34.25,-16.14),(355.2,-33.68,-14.22),(354.9,-37.49,-12.96),(356.1,-36.71,-11.97),(355.6,-35.7,-11.85),(354.8,-34.45,-12.52),(356.4,-36.47,-16.86),(356.0,-36.54,-17.57),(357.3,-36.36,-13.93),(357.0,-36.41,-15.8),(356.8,-35.97,-14.76),(357.0,-35.47,-14.34),(356.6,-35.55,-16.0),(356.0,-35.66,-17.13),(355.7,-35.76,-17.73),(356.3,-35.18,-14.76),(356.4,-34.79,-14.17),(356.2,-34.82,-15.36),(355.4,-35.0,-17.09),(355.7,-34.97,-16.53),(355.4,-34.2,-15.19),(355.2,-34.28,-15.66),(355.8,-34.09,-14.33),(355.6,-34.09,-13.49),(355.5,-38.16,-16.26),(355.8,-39.11,-16.97),(356.1,-38.88,-16.67),(354.8,-38.42,-16.03),(355.8,-39.32,-16.39),(355.1,-38.91,-15.29),(354.4,-38.54,-14.4),(355.6,-38.39,-15.0),(355.8,-38.58,-15.47),(356.1,-39.13,-16.15),(343.5,-53.52,-4.023),(340.6,-57.69,-33.35),(338.9,-57.68,-33.17),(337.3,-56.09,-34.88),(339.8,-55.55,-36.99),(340.0,-53.13,-35.53),(342.2,-56.22,-33.38),(331.3,-48.26,-32.61),(333.0,-46.83,-36.5),(332.7,-48.55,-38.69),(331.5,-50.11,-38.09),(333.1,-52.77,-34.07),(330.6,-46.11,-33.93),(328.7,-46.96,-34.48),(328.8,-49.12,-35.18),(333.1,-43.42,-37.47),(331.7,-43.05,-35.07),(330.0,-35.5,-37.71),(331.3,-35.76,-39.4),(330.0,-43.24,-35.98),(328.1,-35.58,-39.87),(328.1,-43.79,-38.32),(328.0,-44.61,-36.63),(328.1,-47.19,-35.9),(329.0,-47.24,-38.43),(329.0,-35.73,-41.64),(329.7,-43.95,-40.2),(330.3,-35.73,-41.62),(331.4,-43.88,-40.27),(330.5,-46.93,-39.54),(332.0,-46.93,-39.09),(330.9,-32.35,-40.11),(331.0,-31.94,-41.13),(328.5,-32.37,-41.17),(331.4,-33.38,-39.45),(332.3,-33.29,-40.66),(326.8,-33.34,-41.11),(329.8,-30.11,-40.13),(329.6,-30.85,-41.82),(330.0,-30.44,-42.35),(329.8,-30.25,-38.6),(329.5,-30.76,-39.0),(329.0,-30.39,-39.79),(329.3,-30.53,-38.53),(329.5,-30.59,-40.22),(328.9,-30.49,-37.96),(328.6,-30.98,-38.4),(328.1,-30.83,-39.67),(328.6,-30.89,-39.88),(328.3,-30.76,-38.1),(328.2,-31.07,-38.42),(327.9,-31.5,-38.89),(327.4,-31.26,-39.82),(327.8,-31.38,-40.06),(327.6,-31.35,-38.46),(327.4,-31.55,-41.36),(327.8,-31.53,-40.93),(327.0,-31.99,-40.55),(327.3,-31.63,-40.9),(327.5,-31.77,-39.81),(327.3,-32.17,-39.88),(326.7,-31.97,-40.77),(327.1,-32.07,-40.76),(327.0,-32.02,-39.61),(326.6,-32.31,-40.91),(331.1,-32.41,-41.88),(330.1,-31.9,-43.47),(329.0,-32.45,-43.2),(327.6,-33.03,-42.04),(329.4,-30.04,-40.48),(329.4,-30.1,-39.56),(329.5,-30.7,-43.16),(329.4,-30.04,-41.87),(329.0,-30.68,-42.07),(328.4,-30.8,-42.67),(328.4,-30.31,-41.46),(328.4,-30.33,-40.03),(328.5,-30.37,-39.25),(328.1,-31.1,-41.71),(327.7,-31.38,-42.24),(327.6,-30.93,-41.7),(327.7,-30.88,-39.61),(327.7,-30.84,-40.32),(326.9,-31.55,-41.04),(327.0,-31.55,-40.68),(326.9,-31.76,-41.48),(327.1,-32.24,-41.81),(331.7,-30.98,-39.36),(332.8,-30.51,-38.89),(332.5,-30.38,-39.36),(332.1,-31.6,-39.06),(333.0,-30.62,-39.44),(332.7,-31.46,-39.97),(332.3,-32.24,-40.31),(332.0,-31.23,-40.53),(332.2,-30.91,-40.28),(332.8,-30.47,-39.85),(340.4,-57.22,-34.84),(341.8,-52.49,-33.05),(337.1,-54.73,-31.08),(345.7,-34.03,-25.41),(344.0,-32.55,-24.65),(333.6,-37.58,-22.78),(335.7,-31.63,-23.62),(338.8,-30.73,-23.99),(335.1,-40.51,-22.58),(341.5,-39.27,-34.98),(338.9,-40.82,-32.61),(343.3,-36.8,-33.5),(344.5,-35.07,-29.54),(334.9,-40.9,-28.0),(344.8,-16.66,-40.47),(348.4,-19.39,-39.55),(343.7,-19.6,-36.4),(348.0,-20.07,-36.53),(348.6,-19.11,-33.0),(344.2,-18.36,-33.18),(345.1,-15.48,-32.33),(349.4,-18.03,-41.48),(349.5,-17.59,-31.93),(350.9,-15.53,-33.16),(345.9,-13.37,-37.04),(351.6,-14.8,-37.34),(350.8,-15.89,-40.47),(350.8,-20.72,-41.53),(350.6,-19.63,-30.82),(353.2,-20.99,-32.29),(354.6,-22.11,-36.2),(353.3,-21.78,-38.82),(346.6,-28.85,-40.24),(343.8,-26.54,-39.42),(343.6,-23.75,-36.28),(344.2,-23.11,-31.33),(347.0,-25.93,-28.02),(349.6,-28.04,-29.29),(350.5,-29.79,-33.07),(348.9,-29.94,-37.01),(340.4,-36.78,-36.29),(338.9,-31.7,-39.09),(339.9,-28.0,-35.26),(337.8,-29.19,-26.59),(341.2,-27.82,-27.16),(336.6,-38.28,-35.3),(337.4,-34.8,-37.78),(332.1,-36.43,-32.34),(333.3,-37.99,-31.66),(332.7,-38.96,-24.44),(331.7,-37.18,-25.31),(333.1,-35.78,-22.97),(334.4,-34.84,-22.12),(331.4,-34.73,-31.43),(335.3,-29.14,-33.13),(331.2,-34.34,-25.5),(337.1,-28.92,-29.46),(332.9,-33.38,-23.3),(335.6,-33.06,-21.49),(338.0,-15.12,-40.74),(337.3,-16.62,-39.28),(337.2,-17.28,-35.85),(337.5,-16.4,-32.65),(338.2,-14.81,-31.65),(338.6,-13.18,-33.12),(338.8,-12.7,-36.18),(338.6,-13.52,-39.54),(329.6,-13.86,-38.98),(329.2,-15.24,-38.01),(329.2,-15.78,-35.23),(329.4,-15.07,-32.63),(329.8,-13.62,-31.64),(330.2,-12.16,-32.99),(330.5,-11.78,-35.48),(330.1,-12.43,-38.15),(323.4,-12.12,-37.22),(323.4,-13.48,-37.01),(323.5,-14.01,-34.83),(323.5,-13.36,-33.53),(323.5,-11.79,-33.07),(323.5,-10.53,-33.94),(323.4,-10.16,-35.72),(323.5,-10.64,-37.0),(322.3,-8.874,-37.76),(322.0,-8.122,-36.07),(321.2,-5.674,-37.22),(320.7,-7.837,-38.14),(322.2,-8.672,-34.32),(320.8,-7.538,-33.76),(321.3,-5.482,-35.13),(322.0,-10.32,-32.64),(321.9,-13.95,-32.14),(320.7,-13.8,-32.6),(321.1,-12.42,-31.91),(321.7,-14.57,-34.74),(320.6,-14.36,-34.76),(321.8,-14.31,-37.11),(320.7,-14.12,-37.04),(322.4,-10.73,-38.08),(321.1,-12.77,-37.91),(319.9,-7.671,-38.04),(320.4,-5.047,-36.14),(319.9,-7.541,-34.01),(322.8,-14.24,-36.35),(322.8,-14.04,-32.9),(318.5,-13.49,-34.37),(318.5,-13.54,-35.47),(318.6,-12.95,-34.47),(318.6,-13.0,-35.57),(338.8,-29.82,-26.78),(341.9,-30.91,-26.35),(343.3,-38.09,-13.24),(340.4,-39.81,-14.14),(344.8,-35.85,-16.04),(345.2,-34.59,-20.73),(335.8,-40.31,-17.2),(353.4,-11.82,-19.94),(351.1,-16.07,-19.89),(349.2,-11.71,-22.66),(349.7,-16.13,-22.5),(350.3,-16.47,-26.34),(350.1,-12.04,-26.27),(353.4,-12.38,-28.28),(353.2,-16.2,-18.65),(352.1,-16.78,-28.05),(355.0,-17.08,-27.79),(356.7,-12.36,-24.62),(356.8,-17.0,-24.11),(355.9,-16.64,-20.6),(352.2,-19.86,-17.06),(350.9,-20.38,-27.75),(353.3,-21.95,-26.16),(355.0,-22.58,-22.18),(354.1,-21.66,-19.61),(347.8,-27.67,-13.29),(344.8,-25.58,-14.4),(344.1,-23.42,-18.64),(344.1,-23.63,-23.78),(346.6,-26.9,-25.94),(349.3,-28.94,-24.51),(350.8,-29.81,-20.61),(349.8,-29.26,-16.43),(341.4,-34.19,-11.51),(340.5,-30.42,-11.15),(334.5,-28.69,-15.98),(341.0,-28.7,-24.65),(338.6,-36.99,-11.6),(337.5,-34.12,-10.94),(333.6,-35.41,-13.48),(334.7,-37.03,-14.05),(333.0,-38.74,-20.47),(332.2,-36.89,-19.85),(334.2,-34.97,-24.51),(332.8,-33.81,-14.65),(332.2,-32.14,-17.43),(331.6,-34.06,-20.37),(333.6,-31.58,-21.14),(333.0,-33.36,-23.0),(335.2,-33.31,-26.06),(354.1,-6.048,-20.8),(352.0,-5.765,-21.63),(350.7,-5.96,-24.68),(351.2,-6.229,-28.12),(352.9,-6.678,-29.71),(355.1,-6.742,-28.95),(356.2,-6.677,-26.18),(355.8,-6.386,-22.6),(354.2,0.6596,-23.61),(352.4,0.7602,-24.02),(351.3,0.6158,-26.49),(351.7,0.3668,-29.28),(353.3,0.1351,-30.8),(355.2,0.0404,-30.06),(356.1,-0.05082,-27.79),(355.7,0.3187,-24.96),(355.0,5.823,-26.57),(353.5,5.567,-26.18),(352.6,5.325,-28.23),(353.1,5.332,-29.58),(354.8,5.508,-30.71),(356.3,5.769,-30.39),(357.0,5.979,-28.73),(356.7,5.95,-27.38),(358.6,7.206,-27.3),(359.2,7.367,-29.24),(362.1,8.427,-29.07),(359.6,8.662,-27.53),(358.4,7.001,-30.73),(359.4,8.291,-31.88),(362.0,8.27,-31.17),(356.3,6.886,-31.85),(352.0,6.45,-31.11),(352.1,7.468,-30.89),(353.6,7.277,-31.97),(351.6,6.687,-28.38),(351.7,7.651,-28.61),(352.2,6.801,-26.09),(352.3,7.836,-26.46),(356.6,6.87,-26.34),(354.0,7.73,-26.02),(359.7,9.356,-27.82),(362.5,9.105,-30.46),(359.3,9.109,-31.8),(352.4,5.974,-26.74),(352.2,5.715,-30.17),(352.4,9.636,-29.7),(352.4,9.712,-28.61),(353.0,9.602,-29.76),(353.1,9.678,-28.67),(349.8,-64.54,-21.25),(345.6,-64.51,-14.28),(344.1,-70.74,-19.19),(347.1,-58.71,-21.69),(349.5,-64.61,-19.96),(348.9,-65.3,-15.63),(347.6,-64.75,-14.97),(349.8,-67.47,-20.76),(348.3,-69.35,-20.19),(345.5,-70.38,-19.51),(350.4,-62.03,-21.77),(349.4,-60.25,-21.85),(348.9,-59.15,-21.95),(342.2,-63.98,-15.41),(343.4,-65.88,-14.19),(338.1,-68.01,-18.54),(339.2,-69.7,-18.46),(342.4,-70.9,-18.86),(339.5,-63.29,-19.55),(341.6,-61.32,-20.25),(343.8,-60.26,-20.84),(345.4,-65.37,-13.93),(343.8,-69.3,-14.45),(344.0,-70.37,-16.38),(346.7,-59.69,-17.79),(346.3,-60.65,-16.27),(345.9,-62.85,-14.68),(349.1,-68.03,-18.06),(347.6,-66.3,-14.94),(345.7,-69.66,-16.41),(350.2,-62.1,-20.87),(348.3,-59.71,-19.67),(347.9,-62.35,-16.16),(339.5,-68.71,-15.3),(341.1,-70.11,-15.18),(342.3,-68.28,-13.41),(344.3,-63.39,-14.93),(344.8,-60.57,-17.11),(347.0,-69.97,-19.85),(350.1,-66.05,-21.06),(349.9,-64.01,-21.35),(349.9,-63.69,-21.41),(350.2,-62.93,-21.58),(349.5,-62.92,-20.65),(349.4,-63.5,-20.71),(350.5,-62.26,-21.74),(350.0,-61.88,-21.71),(349.6,-61.78,-21.65),(350.0,-61.24,-21.81),(349.3,-61.78,-20.44),(349.6,-61.15,-20.0),(349.1,-63.45,-20.3),(349.1,-62.17,-19.91),(348.5,-60.88,-18.46),(347.7,-60.43,-17.66),(348.1,-58.66,-20.45),(349.4,-60.79,-21.78),(348.9,-60.1,-21.79),(348.9,-59.55,-21.88),(348.6,-58.72,-21.95),(345.1,-59.44,-21.19),(348.7,-60.36,-20.01),(349.9,-61.05,-21.83),(349.6,-60.5,-21.86),(349.3,-60.74,-19.91),(349.8,-61.3,-20.97),(349.3,-62.18,-18.18),(349.7,-62.5,-20.54),(350.4,-62.5,-21.14),(349.2,-60.44,-20.03),(349.7,-65.13,-17.15),(349.0,-64.24,-20.27),(347.9,-63.99,-15.28),(350.0,-65.65,-17.28),(349.2,-63.99,-18.92),(349.4,-63.99,-20.69),(349.2,-64.51,-16.76),(348.9,-64.8,-15.71),(349.1,-64.78,-19.09),(350.0,-65.05,-18.94),(348.4,-67.39,-16.02),(347.9,-68.94,-17.1),(348.3,-61.43,-17.24),(343.0,-61.0,-20.57),(350.1,-65.19,-21.2),(348.1,-59.47,-19.22),(349.4,-64.35,-20.65),(350.1,-64.83,-20.16),(350.2,-65.32,-19.67),(348.4,-64.14,-16.51),(349.0,-63.16,-19.07),(348.3,-63.39,-16.44),(349.4,-61.66,-19.71),(337.4,-64.82,-18.91),(338.5,-65.91,-15.33),(340.7,-70.54,-18.59),(338.6,-63.57,-18.54),(338.1,-63.99,-18.4),(337.5,-63.89,-19.08),(337.1,-63.64,-19.05),(336.0,-63.34,-18.9),(335.1,-62.62,-18.84),(334.1,-60.98,-18.92),(332.0,-59.53,-18.77),(332.1,-58.55,-18.95),(332.3,-56.01,-19.4),(333.2,-54.86,-19.77),(335.2,-54.5,-20.14),(335.8,-56.14,-20.02),(337.8,-57.83,-20.11),(338.9,-60.46,-19.89),(338.0,-62.23,-19.44),(338.7,-62.33,-19.56),(339.1,-62.59,-19.58),(334.0,-58.35,-18.26),(335.9,-59.37,-18.44),(338.4,-63.12,-18.63),(335.6,-57.64,-18.96),(334.6,-56.0,-19.02),(336.3,-60.64,-18.62),(336.6,-61.97,-18.63),(337.6,-62.77,-18.42),(333.8,-56.83,-18.8),(336.9,-62.93,-18.41),(337.4,-63.24,-18.45),(337.9,-63.55,-18.48),(342.4,-63.9,-14.42),(342.5,-63.73,-14.6),(342.7,-63.63,-14.83),(342.9,-63.65,-14.95),(343.1,-63.68,-15.13),(343.3,-63.87,-15.18),(343.4,-64.1,-15.04),(342.4,-64.51,-14.07),(342.6,-64.36,-14.33),(342.8,-64.39,-14.5),(342.9,-64.81,-14.78),(343.0,-64.58,-15.02),(343.4,-64.45,-14.97),(342.0,-64.49,-13.74),(342.2,-64.53,-13.9),(342.4,-65.19,-14.13),(343.2,-65.06,-14.67),(343.2,-64.71,-14.7),(341.9,-64.98,-13.39),(342.4,-65.46,-13.99),(342.9,-65.65,-14.32),(343.3,-65.58,-14.34),(342.0,-65.46,-13.19),(342.2,-65.49,-13.35),(342.6,-65.87,-13.5),(342.8,-66.15,-14.01),(343.0,-66.05,-14.2),(342.1,-65.88,-13.12),(342.9,-66.34,-13.71),(343.2,-66.31,-13.97),(343.3,-66.14,-14.29),(343.6,-66.11,-14.16),(342.4,-66.37,-13.09),(342.6,-66.56,-13.13),(342.8,-66.61,-13.3),(343.1,-66.68,-13.47),(343.3,-66.6,-13.75),(343.5,-66.38,-14.05),(342.5,-63.86,-14.19),(342.6,-63.69,-14.37),(342.8,-63.59,-14.6),(343.2,-63.64,-14.9),(343.3,-63.82,-14.95),(342.5,-64.47,-13.84),(342.7,-64.32,-14.1),(342.9,-64.35,-14.27),(342.1,-64.45,-13.51),(342.3,-64.95,-13.42),(342.4,-65.42,-13.76),(342.0,-64.94,-13.16),(342.0,-65.42,-12.96),(342.2,-65.45,-13.12),(342.6,-65.83,-13.27),(342.9,-66.12,-13.78),(342.2,-65.84,-12.89),(342.8,-66.17,-13.17),(343.0,-66.3,-13.48),(343.3,-66.27,-13.74),(342.5,-66.33,-12.86),(342.7,-66.52,-12.9),(342.9,-66.57,-13.07),(343.1,-66.64,-13.24),(343.4,-66.57,-13.52),(343.6,-66.34,-13.82),(344.6,-65.18,-26.38),(349.3,-64.74,-22.33),(348.0,-65.88,-26.02),(346.6,-65.39,-26.36),(341.5,-64.12,-24.22),(342.4,-66.33,-25.2),(344.5,-66.15,-26.37),(343.0,-69.83,-24.08),(343.5,-70.55,-22.25),(346.0,-59.89,-24.77),(345.5,-61.21,-25.95),(344.8,-63.51,-26.59),(349.1,-68.28,-23.39),(346.4,-67.28,-25.99),(345.2,-69.92,-22.79),(350.0,-62.19,-22.5),(347.9,-59.93,-23.72),(347.0,-62.9,-26.07),(338.9,-69.07,-21.87),(340.5,-70.5,-22.12),(341.3,-69.01,-25.01),(343.4,-63.99,-25.64),(344.1,-60.99,-24.61),(349.3,-63.01,-22.2),(349.3,-63.56,-21.93),(349.1,-61.91,-22.71),(349.3,-61.34,-23.41),(348.9,-63.55,-22.21),(348.8,-62.34,-23.0),(347.9,-61.21,-24.57),(346.9,-60.55,-25.04),(347.9,-58.81,-23.45),(348.4,-60.55,-23.35),(349.0,-60.94,-23.53),(349.7,-61.39,-22.52),(348.7,-62.55,-24.78),(349.5,-62.61,-22.52),(350.3,-62.56,-22.18),(348.9,-60.63,-23.45),(349.1,-65.56,-24.93),(348.8,-64.33,-21.96),(346.9,-64.6,-26.4),(349.3,-66.07,-24.72),(348.8,-64.26,-23.34),(349.3,-64.05,-21.79),(348.4,-64.99,-25.16),(348.0,-65.35,-25.99),(348.8,-64.99,-22.98),(349.6,-65.29,-23.34),(347.5,-67.97,-24.66),(347.4,-69.18,-23.15),(347.6,-61.92,-25.28),(347.6,-59.55,-24.05),(349.3,-64.41,-21.72),(349.9,-64.95,-22.3),(350.0,-65.49,-22.64),(347.5,-64.68,-25.22),(348.6,-63.45,-23.3),(347.5,-63.9,-25.63),(349.1,-61.99,-23.44),(337.9,-66.31,-22.38),(338.5,-63.65,-20.11),(338.0,-64.08,-19.91),(334.2,-59.67,-19.89),(335.8,-60.66,-20.01),(338.3,-63.21,-20.1),(336.1,-58.24,-20.72),(334.5,-56.05,-20.59),(336.4,-61.84,-19.78),(337.5,-62.83,-19.99),(333.3,-57.58,-20.26),(336.8,-63.01,-19.8),(337.3,-63.32,-19.86),(337.8,-63.63,-19.91),(341.5,-64.5,-25.28),(341.6,-64.32,-25.2),(341.8,-64.2,-25.09),(342.0,-64.21,-25.02),(342.2,-64.22,-24.92),(342.4,-64.39,-24.88),(342.5,-64.66,-24.86),(341.4,-65.14,-25.41),(341.6,-64.97,-25.29),(341.9,-64.98,-25.19),(342.0,-65.37,-24.82),(342.2,-65.12,-24.72),(342.5,-65.0,-25.01),(340.9,-65.15,-25.58),(341.2,-65.18,-25.5),(341.4,-65.8,-25.13),(342.3,-65.61,-24.94),(342.3,-65.29,-25.08),(340.8,-65.66,-25.73),(341.4,-66.08,-25.18),(342.0,-66.25,-24.99),(340.8,-66.16,-25.79),(341.1,-66.17,-25.7),(341.5,-66.54,-25.6),(341.9,-66.77,-25.11),(342.0,-66.65,-25.02),(341.0,-66.58,-25.79),(341.9,-66.99,-25.37),(342.2,-66.93,-25.24),(342.4,-66.72,-24.91),(342.7,-66.76,-25.3),(341.3,-67.07,-25.76),(341.5,-67.26,-25.73),(341.7,-67.29,-25.64),(342.0,-67.35,-25.54),(342.3,-67.25,-25.4),(342.6,-67.0,-25.27),(341.5,-64.45,-25.54),(341.6,-64.31,-25.45),(341.8,-64.19,-25.34),(342.3,-64.21,-25.18),(342.4,-64.38,-25.13),(342.6,-64.65,-25.12),(341.4,-65.13,-25.67),(341.7,-64.96,-25.55),(341.9,-64.97,-25.45),(341.0,-65.13,-25.84),(341.2,-65.64,-25.84),(340.8,-65.65,-25.98),(341.1,-66.16,-25.96),(340.9,-66.15,-26.05),(341.5,-66.53,-25.85),(341.9,-66.76,-25.37),(341.0,-66.57,-26.05),(341.6,-66.87,-25.87),(341.9,-66.98,-25.63),(342.3,-66.92,-25.5),(342.4,-66.7,-25.22),(341.3,-67.06,-26.02),(341.5,-67.24,-25.99),(341.8,-67.28,-25.89),(342.0,-67.33,-25.8),(342.3,-67.24,-25.66),(342.6,-66.99,-25.52),(346.1,-61.71,-15.27),(345.2,-62.19,-26.51),(339.0,-46.81,-8.059),(335.0,-51.03,-31.57),(402.9,-51.1,-29.47),(410.2,-44.23,-31.13),(412.7,-51.53,-29.49),(401.6,-48.25,-29.55),(402.5,-50.8,-24.2),(404.1,-49.32,-20.7),(407.2,-48.98,-21.24),(405.9,-47.26,-20.52),(411.9,-51.26,-22.95),(408.4,-45.78,-22.54),(409.4,-44.75,-25.53),(403.7,-48.13,-23.31),(412.0,-51.86,-35.84),(402.5,-51.3,-35.06),(404.2,-50.14,-38.26),(407.2,-49.84,-38.32),(405.5,-48.23,-39.52),(408.0,-46.59,-38.67),(409.2,-45.34,-36.11),(403.4,-48.87,-36.28),(409.8,-59.78,-38.05),(401.8,-61.18,-38.28),(406.5,-58.4,-39.54),(402.9,-59.4,-39.94),(403.9,-64.13,-34.74),(405.1,-66.28,-26.88),(402.2,-54.9,-28.65),(402.1,-59.96,-27.86),(413.5,-55.94,-28.31),(412.2,-59.01,-29.01),(415.7,-55.31,-34.74),(415.2,-56.98,-31.01),(414.7,-56.88,-37.5),(413.3,-58.71,-34.94),(414.0,-53.08,-34.66),(405.9,-68.57,-26.33),(401.9,-54.72,-22.63),(403.3,-63.14,-21.77),(403.2,-53.83,-18.55),(410.3,-55.32,-16.97),(408.7,-52.32,-19.72),(415.6,-54.76,-22.96),(414.7,-56.06,-19.82),(413.4,-57.8,-21.53),(415.2,-56.76,-26.16),(412.3,-58.91,-26.98),(409.2,-58.59,-17.81),(413.0,-55.42,-17.7),(413.3,-53.48,-19.51),(414.0,-52.57,-23.69),(411.4,-53.41,-17.24),(411.6,-52.25,-18.85),(413.2,-51.87,-22.3),(406.4,-57.12,-16.74),(404.3,-57.24,-16.72),(406.3,-64.98,-23.04),(402.8,-59.21,-15.16),(406.7,-63.9,-22.76),(407.4,-67.08,-23.58),(404.5,-62.37,-14.73),(404.8,-62.9,-18.23),(409.1,-62.94,-27.25),(409.2,-62.78,-23.11),(411.1,-60.74,-24.65),(409.9,-60.85,-27.45),(411.1,-61.08,-29.33),(407.5,-63.83,-25.43),(409.6,-65.37,-27.04),(408.0,-66.58,-24.56),(407.5,-64.1,-28.96),(408.2,-66.69,-28.82),(409.9,-62.43,-30.88),(413.3,-52.52,-36.34),(413.1,-56.45,-39.94),(413.7,-54.17,-38.74),(406.2,-65.23,-31.39),(407.6,-67.36,-30.12),(403.5,-64.17,-38.52),(402.0,-55.31,-35.32),(404.8,-63.62,-33.54),(403.3,-54.76,-38.7),(410.9,-56.36,-40.5),(408.8,-53.22,-38.99),(411.9,-54.43,-40.76),(411.6,-53.23,-39.86),(403.0,-59.45,-40.48),(415.2,-54.23,-34.7),(415.2,-53.7,-23.31),(415.7,-56.42,-28.54),(406.9,-64.11,-32.23),(404.3,-57.26,-17.27),(402.9,-59.42,-40.5),(408.9,-61.23,-18.72),(409.1,-62.27,-35.88),(404.1,-64.58,-34.88),(404.8,-63.4,-17.96),(405.1,-64.58,-22.47),(405.1,-64.79,-32.64),(406.1,-67.14,-28.87),(406.5,-68.08,-29.8),(405.2,-65.88,-28.97),(406.1,-67.11,-24.88),(406.7,-67.67,-23.54),(405.2,-65.74,-25.1),(405.8,-67.88,-26.48),(407.9,-60.59,-12.42),(405.3,-60.61,-11.64),(406.1,-57.62,-11.51),(407.6,-58.0,-10.52),(407.9,-56.31,-13.64),(409.8,-59.69,-13.84),(401.7,-49.18,-15.48),(405.0,-48.48,-13.73),(404.5,-49.24,-10.55),(402.7,-50.08,-9.516),(401.8,-53.86,-11.77),(403.1,-47.17,-15.86),(401.6,-46.17,-14.23),(400.1,-48.19,-11.74),(407.7,-47.43,-15.54),(406.6,-46.41,-17.67),(413.6,-41.84,-21.69),(414.5,-42.86,-20.16),(406.0,-45.21,-16.44),(413.7,-40.22,-19.57),(405.5,-43.82,-13.64),(404.1,-44.27,-14.34),(401.6,-45.77,-12.7),(402.9,-46.2,-10.7),(414.4,-40.84,-18.01),(406.7,-44.89,-12.16),(414.9,-41.91,-18.17),(407.5,-46.13,-12.45),(404.3,-46.95,-10.33),(405.0,-48.1,-11.05),(417.4,-42.22,-22.06),(418.2,-42.23,-21.46),(417.8,-40.08,-21.2),(416.3,-42.62,-21.82),(416.7,-43.29,-20.7),(416.8,-38.55,-20.73),(419.3,-41.53,-24.35),(419.4,-41.12,-21.91),(420.1,-41.43,-21.89),(418.6,-41.63,-25.54),(418.2,-41.35,-24.81),(418.8,-40.85,-24.57),(418.3,-41.2,-25.45),(418.8,-41.29,-23.9),(418.1,-40.94,-26.04),(417.7,-40.68,-25.29),(418.3,-40.13,-24.46),(418.3,-40.49,-24.13),(417.8,-40.41,-25.82),(417.6,-40.33,-25.29),(417.3,-40.06,-24.56),(417.8,-39.53,-24.1),(417.8,-39.86,-23.69),(417.3,-39.83,-25.13),(418.5,-39.2,-22.03),(418.3,-39.64,-22.12),(417.8,-38.95,-22.13),(417.9,-39.36,-22.78),(417.3,-39.59,-23.64),(416.9,-39.4,-23.27),(417.5,-38.81,-22.69),(417.4,-39.12,-22.42),(417.0,-39.18,-23.69),(417.7,-38.47,-21.75),(418.0,-42.26,-20.32),(419.0,-41.34,-19.32),(418.4,-40.4,-19.27),(417.4,-39.26,-20.03),(419.5,-41.13,-24.2),(419.1,-41.25,-24.93),(420.2,-40.88,-21.24),(420.0,-40.99,-23.11),(419.7,-40.56,-22.11),(419.8,-40.04,-21.69),(419.5,-40.19,-23.37),(418.9,-40.38,-24.52),(418.6,-40.52,-25.14),(419.1,-39.83,-22.17),(419.1,-39.42,-21.58),(419.0,-39.5,-22.78),(418.2,-39.8,-24.55),(418.5,-39.73,-23.98),(418.0,-38.98,-22.69),(417.9,-39.09,-23.16),(418.4,-38.81,-21.82),(418.1,-38.82,-20.98),(418.8,-42.9,-23.56),(419.2,-43.82,-24.22),(419.5,-43.55,-23.92),(418.1,-43.25,-23.36),(419.3,-44.02,-23.63),(418.5,-43.68,-22.58),(417.8,-43.38,-21.74),(418.9,-43.11,-22.29),(419.2,-43.27,-22.74),(419.5,-43.79,-23.38),(406.8,-60.22,-11.36),(406.1,-62.94,-41.69),(404.4,-62.69,-41.96),(403.3,-60.63,-43.87),(406.3,-60.5,-45.08),(406.8,-58.29,-43.11),(407.9,-61.66,-41.12),(399.7,-51.8,-42.09),(402.3,-50.95,-45.3),(401.7,-52.35,-47.74),(399.9,-53.54,-47.62),(400.1,-56.5,-43.62),(400.4,-50.0,-43.11),(398.3,-49.9,-44.36),(397.4,-51.91,-45.33),(404.5,-48.84,-45.36),(403.1,-47.88,-43.37),(406.9,-40.8,-45.0),(408.1,-41.68,-46.27),(401.8,-47.33,-44.77),(405.8,-39.97,-47.71),(400.3,-46.97,-47.71),(399.4,-47.61,-46.24),(397.9,-49.88,-45.95),(399.0,-50.33,-48.16),(406.7,-40.56,-49.17),(401.8,-47.81,-49.11),(407.7,-41.22,-48.72),(403.2,-48.51,-48.67),(400.6,-50.67,-48.78),(401.9,-51.32,-47.89),(410.3,-39.27,-46.19),(410.9,-39.09,-47.01),(409.0,-37.76,-48.0),(409.6,-40.23,-45.69),(410.4,-40.76,-46.53),(407.1,-37.24,-48.81),(411.5,-37.23,-45.79),(411.2,-37.56,-47.76),(411.9,-37.56,-47.99),(410.9,-37.36,-44.46),(410.4,-37.48,-45.2),(410.6,-36.88,-45.86),(410.4,-37.21,-44.7),(410.9,-37.37,-46.22),(410.0,-36.97,-44.25),(409.6,-37.09,-45.01),(409.7,-36.6,-46.24),(410.0,-36.93,-46.34),(409.5,-36.73,-44.69),(409.3,-36.87,-45.19),(408.9,-36.96,-45.94),(409.0,-36.42,-46.81),(409.2,-36.76,-46.99),(408.7,-36.67,-45.54),(409.1,-36.48,-48.3),(409.3,-36.77,-47.74),(408.4,-36.52,-47.78),(408.9,-36.58,-48.02),(408.6,-36.79,-47.07),(408.2,-36.91,-47.42),(408.2,-36.38,-48.28),(408.4,-36.69,-48.2),(408.0,-36.63,-47.17),(407.9,-36.43,-48.38),(410.7,-39.47,-47.82),(410.9,-38.58,-49.52),(409.7,-38.2,-49.8),(408.1,-37.64,-49.32),(411.4,-36.89,-46.2),(411.1,-37.0,-45.36),(411.5,-37.41,-49.02),(411.7,-36.82,-47.5),(411.0,-37.02,-48.14),(410.7,-36.75,-48.93),(410.8,-36.37,-47.55),(410.4,-36.48,-46.21),(410.2,-36.6,-45.47),(410.0,-36.71,-48.24),(409.7,-36.65,-48.96),(409.9,-36.27,-48.31),(409.4,-36.38,-46.32),(409.6,-36.32,-46.96),(408.8,-36.26,-48.21),(408.7,-36.3,-47.88),(408.7,-36.34,-48.62),(408.4,-36.73,-49.06),(411.8,-38.87,-44.74),(412.8,-39.23,-43.8),(412.8,-38.97,-44.3),(411.5,-39.51,-44.52),(413.0,-39.49,-44.27),(412.1,-39.81,-45.16),(411.3,-40.12,-45.85),(412.0,-39.26,-45.85),(412.4,-39.16,-45.44),(413.0,-39.24,-44.7),(406.1,-62.37,-43.14),(406.5,-58.4,-39.56),(402.9,-59.4,-39.96),(409.8,-39.87,-31.8),(408.2,-39.42,-31.18),(397.7,-43.62,-29.76),(399.7,-37.64,-30.52),(402.8,-36.69,-30.74),(399.4,-46.53,-29.47),(405.9,-45.19,-41.55),(403.3,-46.78,-39.31),(407.7,-42.68,-39.99),(408.7,-40.93,-35.98),(399.3,-46.93,-34.9),(416.6,-20.94,-48.7),(415.8,-25.23,-46.83),(412.8,-21.25,-44.93),(414.7,-25.07,-43.94),(415.7,-24.63,-40.34),(414.1,-20.7,-41.65),(417.5,-19.94,-40.59),(417.7,-25.21,-48.57),(417.7,-24.32,-39.1),(420.5,-24.15,-40.06),(420.3,-19.86,-45.05),(421.8,-24.44,-44.08),(420.6,-24.85,-47.3),(416.9,-28.89,-48.11),(417.0,-27.59,-37.46),(419.1,-29.51,-38.77),(420.2,-30.91,-42.6),(419.1,-30.37,-45.27),(411.4,-36.45,-46.77),(408.9,-33.89,-46.14),(409.0,-31.07,-43.06),(409.6,-30.45,-38.09),(411.9,-33.48,-34.62),(414.3,-35.85,-35.72),(415.0,-37.69,-39.41),(413.5,-37.72,-43.4),(404.6,-43.55,-42.66),(403.7,-38.49,-45.94),(404.9,-34.88,-42.18),(402.5,-35.57,-33.71),(406.0,-34.67,-34.03),(401.1,-44.28,-42.12),(401.8,-41.38,-44.56),(396.4,-42.51,-39.4),(397.6,-44.05,-38.65),(396.9,-45.02,-31.46),(395.9,-43.26,-32.38),(397.2,-41.83,-29.99),(398.4,-40.87,-29.08),(395.7,-40.82,-38.53),(400.3,-35.48,-40.41),(395.3,-40.43,-32.61),(402.0,-35.34,-36.62),(397.0,-39.44,-30.33),(399.6,-39.07,-28.4),(415.1,-15.36,-50.61),(413.2,-15.44,-49.33),(412.3,-15.39,-45.97),(413.1,-14.88,-42.76),(415.0,-14.59,-41.59),(417.0,-14.27,-42.93),(417.8,-14.45,-45.89),(417.0,-14.93,-49.28),(412.7,-8.664,-50.87),(411.0,-8.971,-50.01),(410.3,-8.946,-47.29),(411.0,-8.556,-44.67),(412.6,-8.083,-43.59),(414.4,-7.787,-44.82),(415.1,-8.054,-47.19),(414.4,-8.315,-49.92),(411.2,-3.092,-50.53),(410.0,-3.925,-50.31),(409.3,-4.111,-48.16),(409.9,-3.666,-46.86),(411.4,-2.706,-46.4),(412.6,-1.991,-47.25),(413.0,-1.852,-49.02),(412.7,-2.249,-50.29),(413.1,-0.0315,-51.2),(413.5,0.6638,-49.53),(415.1,2.788,-50.77),(413.0,1.581,-51.77),(413.1,0.2715,-47.79),(413.0,1.919,-47.41),(415.2,2.993,-48.69),(411.5,-0.6525,-46.17),(408.3,-3.029,-45.7),(407.7,-2.283,-46.32),(409.1,-1.561,-45.58),(407.8,-3.434,-48.32),(407.2,-2.672,-48.49),(408.2,-3.335,-50.73),(407.5,-2.637,-50.75),(411.7,-1.433,-51.53),(409.0,-2.02,-51.55),(412.6,2.18,-51.79),(415.0,3.789,-49.82),(412.4,2.47,-47.79),(408.8,-3.879,-49.8),(408.8,-3.592,-46.36),(406.4,-0.7956,-48.38),(406.4,-0.8786,-49.48),(407.0,-0.5055,-48.46),(407.0,-0.5884,-49.56),(403.4,-36.29,-33.79),(406.4,-37.68,-33.08),(407.2,-43.95,-19.74),(404.4,-45.73,-20.78),(408.7,-41.69,-22.47),(409.2,-40.43,-27.14),(399.9,-46.31,-24.07),(395.8,-18.29,-23.67),(399.7,-21.21,-24.72),(394.4,-21.74,-25.95),(399.0,-22.36,-27.17),(399.1,-21.98,-31.1),(394.5,-21.06,-29.68),(395.4,-18.46,-32.03),(400.7,-19.55,-23.72),(399.8,-20.67,-33.03),(401.1,-18.43,-33.13),(396.6,-15.7,-28.71),(402.0,-17.01,-29.64),(401.8,-17.58,-26.0),(403.2,-21.83,-22.92),(401.9,-22.8,-33.51),(405.1,-22.6,-32.38),(407.1,-22.24,-28.65),(405.9,-22.07,-25.88),(405.3,-30.28,-19.79),(401.4,-30.05,-20.8),(399.3,-28.57,-24.77),(399.2,-28.66,-29.88),(403.5,-30.03,-32.39),(407.1,-30.37,-31.13),(409.1,-30.38,-27.28),(407.9,-30.54,-23.02),(405.2,-40.09,-18.13),(400.9,-36.21,-18.15),(398.2,-34.72,-22.96),(400.5,-34.37,-31.43),(402.4,-42.94,-18.35),(401.2,-40.09,-17.75),(397.5,-41.44,-20.48),(398.6,-43.05,-20.99),(397.1,-44.79,-27.48),(396.2,-42.95,-26.91),(398.3,-41.01,-31.48),(396.6,-39.86,-21.7),(396.1,-38.2,-24.5),(395.6,-40.14,-27.47),(397.5,-37.63,-28.15),(397.0,-39.42,-30.04),(399.3,-39.33,-32.98),(389.3,-16.49,-22.71),(388.4,-18.12,-23.27),(388.0,-19.29,-26.22),(387.9,-18.95,-29.72),(388.6,-17.62,-31.56),(389.2,-15.85,-31.01),(389.7,-14.92,-28.36),(389.8,-15.16,-24.72),(381.1,-15.09,-23.3),(380.6,-16.54,-23.53),(380.2,-17.49,-25.91),(380.2,-17.22,-28.76),(380.5,-16.01,-30.45),(381.1,-14.42,-29.91),(381.7,-13.69,-27.78),(381.6,-13.87,-24.87),(375.0,-13.3,-24.73),(374.9,-14.6,-24.27),(374.8,-15.46,-26.29),(374.7,-15.03,-27.66),(374.9,-13.57,-28.89),(375.1,-12.28,-28.64),(375.2,-11.63,-27.02),(375.3,-11.89,-25.66),(374.4,-9.979,-25.5),(374.2,-9.451,-27.45),(373.8,-6.845,-27.3),(373.0,-8.743,-25.51),(374.2,-10.26,-28.91),(373.0,-9.065,-29.88),(373.8,-6.951,-29.41),(373.7,-12.05,-29.84),(373.0,-15.61,-28.83),(371.9,-15.26,-28.39),(372.5,-14.07,-29.64),(372.9,-15.84,-26.04),(371.8,-15.5,-26.05),(373.2,-15.29,-23.8),(372.0,-14.95,-23.94),(374.3,-11.73,-24.42),(372.6,-13.57,-23.68),(372.2,-8.5,-25.64),(373.1,-6.301,-28.57),(372.0,-8.919,-29.6),(374.1,-15.43,-24.65),(374.0,-15.69,-28.09),(369.7,-14.4,-26.78),(369.7,-14.3,-25.69),(369.9,-13.89,-26.9),(370.0,-13.79,-25.81),(414.6,-70.29,-27.31),(410.2,-70.33,-20.55),(408.9,-76.59,-25.52),(411.7,-64.52,-27.91),(414.2,-70.37,-26.04),(413.5,-71.07,-21.73),(412.2,-70.54,-21.15),(414.6,-73.22,-26.81),(413.1,-75.13,-26.31),(410.4,-76.2,-25.77),(415.1,-67.77,-27.81),(414.0,-66.02,-27.95),(413.6,-64.92,-28.08),(406.8,-69.87,-21.87),(408.0,-71.74,-20.58),(402.9,-73.96,-25.18),(404.0,-75.63,-25.04),(407.3,-76.78,-25.27),(404.2,-69.22,-26.14),(406.2,-67.22,-26.74),(408.5,-66.12,-27.22),(410.0,-71.19,-20.22),(408.5,-75.15,-20.8),(408.8,-76.22,-22.72),(411.2,-65.5,-24.04),(410.9,-66.46,-22.52),(410.4,-68.67,-20.96),(413.8,-73.8,-24.14),(412.2,-72.09,-21.12),(410.5,-75.48,-22.66),(414.9,-67.85,-26.92),(412.9,-65.49,-25.82),(412.4,-68.13,-22.33),(404.2,-74.63,-21.87),(405.8,-76.01,-21.67),(406.9,-74.16,-19.84),(408.9,-69.24,-21.28),(409.3,-66.41,-23.45),(411.8,-75.77,-26.04),(414.9,-71.79,-27.1),(414.6,-69.76,-27.41),(414.7,-69.44,-27.46),(414.9,-68.68,-27.62),(414.1,-68.68,-26.73),(414.1,-69.26,-26.8),(415.2,-68.01,-27.77),(414.7,-67.63,-27.77),(414.3,-67.54,-27.74),(414.7,-66.99,-27.87),(414.0,-67.54,-26.53),(414.2,-66.91,-26.08),(413.7,-69.21,-26.41),(413.7,-67.93,-26.02),(413.1,-66.65,-24.61),(412.2,-66.22,-23.85),(412.7,-64.44,-26.62),(414.1,-66.55,-27.88),(413.6,-65.88,-27.92),(413.5,-65.32,-28.01),(413.2,-64.5,-28.1),(409.7,-65.28,-27.52),(413.4,-66.14,-26.14),(414.6,-66.8,-27.9),(414.2,-66.26,-27.94),(413.9,-66.5,-26.02),(414.4,-67.06,-27.05),(413.9,-67.94,-24.28),(414.4,-68.25,-26.62),(415.0,-68.25,-27.18),(413.8,-66.21,-26.15),(414.4,-70.89,-23.21),(413.7,-70.01,-26.38),(412.5,-69.77,-21.44),(414.6,-71.4,-23.33),(413.8,-69.75,-25.02),(414.1,-69.75,-26.77),(413.8,-70.27,-22.86),(413.5,-70.56,-21.82),(413.8,-70.54,-25.18),(414.7,-70.8,-25.0),(413.1,-73.16,-22.14),(412.7,-74.72,-23.24),(412.9,-67.21,-23.39),(407.7,-66.87,-26.98),(414.9,-70.94,-27.24),(412.7,-65.26,-25.39),(414.1,-70.11,-26.73),(414.8,-70.58,-26.2),(414.9,-71.07,-25.71),(413.0,-69.91,-22.65),(413.6,-68.93,-25.18),(412.9,-69.17,-22.59),(414.0,-67.42,-25.8),(402.1,-70.79,-25.6),(403.2,-71.86,-21.96),(405.5,-76.45,-25.09),(403.3,-69.51,-25.17),(402.8,-69.95,-25.06),(402.2,-69.85,-25.77),(401.8,-69.61,-25.76),(400.7,-69.34,-25.66),(399.7,-68.63,-25.65),(398.7,-67.01,-25.79),(396.6,-65.59,-25.75),(396.7,-64.62,-25.93),(396.9,-62.06,-26.38),(397.7,-60.91,-26.71),(399.7,-60.51,-26.97),(400.3,-62.14,-26.82),(402.4,-63.79,-26.81),(403.5,-66.4,-26.52),(402.6,-68.19,-26.11),(403.4,-68.28,-26.19),(403.8,-68.53,-26.19),(398.5,-64.38,-25.15),(400.5,-65.36,-25.23),(403.1,-69.08,-25.27),(400.2,-63.65,-25.76),(399.1,-62.02,-25.89),(400.9,-66.63,-25.38),(401.2,-67.96,-25.37),(402.3,-68.74,-25.11),(398.3,-62.86,-25.7),(401.5,-68.91,-25.13),(402.1,-69.21,-25.14),(402.6,-69.51,-25.15),(407.0,-69.77,-20.86),(407.1,-69.6,-21.04),(407.3,-69.5,-21.26),(407.5,-69.52,-21.37),(407.7,-69.54,-21.54),(407.9,-69.73,-21.58),(408.0,-69.96,-21.43),(407.0,-70.39,-20.51),(407.2,-70.24,-20.76),(407.4,-70.26,-20.92),(407.5,-70.68,-21.19),(407.6,-70.44,-21.42),(408.0,-70.31,-21.36),(406.6,-70.37,-20.2),(406.8,-70.41,-20.35),(407.0,-71.06,-20.56),(407.8,-70.92,-21.07),(407.8,-70.57,-21.1),(406.5,-70.86,-19.85),(407.0,-71.33,-20.43),(407.5,-71.52,-20.73),(407.9,-71.44,-20.73),(406.5,-71.34,-19.65),(406.7,-71.37,-19.8),(407.2,-71.74,-19.92),(407.5,-72.02,-20.42),(407.6,-71.91,-20.6),(406.7,-71.76,-19.56),(407.6,-72.21,-20.12),(407.8,-72.17,-20.36),(407.9,-72.0,-20.68),(408.2,-71.97,-20.53),(407.0,-72.24,-19.53),(407.2,-72.43,-19.55),(407.4,-72.47,-19.71),(407.7,-72.54,-19.87),(408.0,-72.46,-20.14),(408.2,-72.23,-20.42),(407.1,-69.73,-20.63),(407.2,-69.56,-20.8),(407.4,-69.46,-21.02),(407.8,-69.51,-21.31),(407.9,-69.68,-21.34),(407.0,-70.35,-20.28),(407.2,-70.2,-20.52),(407.5,-70.22,-20.69),(406.6,-70.33,-19.97),(406.8,-70.83,-19.87),(407.0,-71.29,-20.19),(406.5,-70.83,-19.62),(406.6,-71.3,-19.42),(406.8,-71.33,-19.57),(407.2,-71.7,-19.69),(407.5,-71.98,-20.19),(406.8,-71.72,-19.33),(407.3,-72.04,-19.59),(407.6,-72.17,-19.89),(407.9,-72.13,-20.13),(407.1,-72.2,-19.29),(407.2,-72.39,-19.32),(407.5,-72.43,-19.48),(407.7,-72.5,-19.64),(408.0,-72.43,-19.9),(408.2,-72.19,-20.19),(409.4,-71.03,-32.7),(414.0,-70.5,-28.42),(412.9,-71.67,-32.17),(411.5,-71.2,-32.57),(406.3,-70.02,-30.7),(407.3,-72.22,-31.63),(409.4,-72.0,-32.69),(407.9,-75.71,-30.47),(408.4,-76.42,-28.61),(410.7,-65.71,-31.04),(410.3,-67.04,-32.24),(409.7,-69.35,-32.91),(414.0,-74.05,-29.47),(411.3,-73.09,-32.21),(410.1,-75.75,-29.06),(414.8,-67.95,-28.56),(412.6,-65.72,-29.89),(411.8,-68.7,-32.28),(403.8,-75.01,-28.46),(405.4,-76.41,-28.63),(406.2,-74.91,-31.48),(408.2,-69.86,-32.03),(408.9,-66.85,-30.97),(414.0,-68.77,-28.29),(414.0,-69.33,-28.02),(413.9,-67.67,-28.82),(414.0,-67.1,-29.51),(413.6,-69.33,-28.33),(413.6,-68.11,-29.12),(412.7,-67.0,-30.73),(411.7,-66.35,-31.26),(412.5,-64.61,-29.63),(413.1,-66.33,-29.49),(413.7,-66.71,-29.64),(414.4,-67.14,-28.6),(413.5,-68.33,-30.91),(414.3,-68.37,-28.6),(415.0,-68.31,-28.23),(413.6,-66.41,-29.57),(413.9,-71.34,-31.02),(413.6,-70.1,-28.07),(411.8,-70.41,-32.61),(414.2,-71.83,-30.8),(413.6,-70.03,-29.45),(414.0,-69.82,-27.88),(413.3,-70.77,-31.29),(412.9,-71.14,-32.14),(413.6,-70.77,-29.09),(414.4,-71.05,-29.41),(412.5,-73.76,-30.82),(412.3,-74.98,-29.31),(412.4,-67.72,-31.46),(412.3,-65.34,-30.24),(414.1,-70.17,-27.81),(414.7,-70.71,-28.35),(414.8,-71.24,-28.69),(412.4,-70.48,-31.39),(413.4,-69.23,-29.42),(412.3,-69.7,-31.81),(413.8,-67.76,-29.54),(402.7,-72.27,-29.04),(403.2,-69.6,-26.75),(402.7,-70.04,-26.57),(398.9,-65.69,-26.76),(400.5,-66.65,-26.8),(403.0,-69.16,-26.74),(400.6,-64.23,-27.5),(399.1,-62.07,-27.45),(401.1,-67.83,-26.53),(402.2,-68.8,-26.68),(397.9,-63.63,-27.18),(401.4,-68.99,-26.53),(402.0,-69.29,-26.56),(402.5,-69.59,-26.58),(406.3,-70.4,-31.76),(406.4,-70.22,-31.67),(406.7,-70.09,-31.55),(406.8,-70.1,-31.48),(407.1,-70.11,-31.37),(407.2,-70.28,-31.31),(407.4,-70.55,-31.28),(406.2,-71.05,-31.89),(406.5,-70.87,-31.76),(406.7,-70.88,-31.65),(406.9,-71.27,-31.27),(407.0,-71.01,-31.16),(407.4,-70.89,-31.43),(405.8,-71.06,-32.09),(406.0,-71.09,-31.99),(406.3,-71.7,-31.61),(407.1,-71.5,-31.38),(407.2,-71.18,-31.51),(405.7,-71.58,-32.24),(406.3,-71.98,-31.66),(406.8,-72.14,-31.44),(405.7,-72.07,-32.29),(406.0,-72.08,-32.2),(406.4,-72.44,-32.07),(406.8,-72.67,-31.56),(406.9,-72.54,-31.47),(405.9,-72.49,-32.29),(406.8,-72.88,-31.82),(407.1,-72.82,-31.67),(407.2,-72.61,-31.34),(407.6,-72.65,-31.71),(406.2,-72.98,-32.24),(406.4,-73.16,-32.2),(406.6,-73.19,-32.09),(406.9,-73.24,-31.98),(407.2,-73.14,-31.83),(407.5,-72.88,-31.68),(406.3,-70.35,-32.02),(406.5,-70.21,-31.93),(406.7,-70.08,-31.8),(407.1,-70.1,-31.62),(407.3,-70.27,-31.57),(407.4,-70.53,-31.54),(406.3,-71.03,-32.15),(406.5,-70.86,-32.01),(406.8,-70.87,-31.91),(405.8,-71.05,-32.34),(406.1,-71.55,-32.33),(405.7,-71.57,-32.49),(406.0,-72.07,-32.45),(405.8,-72.06,-32.55),(406.4,-72.43,-32.32),(406.8,-72.66,-31.82),(406.0,-72.48,-32.54),(406.5,-72.77,-32.34),(406.9,-72.87,-32.08),(407.2,-72.81,-31.93),(407.3,-72.59,-31.64),(406.3,-72.97,-32.5),(406.4,-73.15,-32.45),(406.7,-73.18,-32.35),(407.0,-73.23,-32.24),(407.3,-73.13,-32.08),(407.5,-72.87,-31.94),(410.6,-67.53,-21.54),(410.0,-68.03,-32.81),(402.5,-53.45,-15.75),(402.1,-55.29,-40.44),(467.2,-51.87,-37.39),(474.5,-44.98,-39.15),(477.0,-52.26,-37.28),(465.8,-49.03,-37.57),(466.7,-51.52,-32.14),(468.3,-50.01,-28.66),(471.4,-49.66,-29.16),(470.2,-47.93,-28.51),(476.2,-51.93,-30.76),(472.6,-46.46,-30.54),(473.7,-45.45,-33.54),(467.9,-48.84,-31.3),(476.3,-52.65,-43.62),(466.8,-52.12,-42.98),(468.6,-50.98,-46.19),(471.6,-50.67,-46.22),(469.8,-49.09,-47.48),(472.3,-47.42,-46.65),(473.5,-46.15,-44.11),(467.7,-49.7,-44.26),(474.2,-60.6,-45.65),(466.5,-60.78,-47.22),(470.9,-59.24,-47.21),(468.4,-59.03,-48.97),(468.2,-64.8,-42.72),(469.5,-67.01,-34.36),(466.5,-55.66,-36.48),(466.4,-60.72,-35.55),(477.8,-56.66,-35.97),(476.6,-59.74,-36.6),(480.0,-56.08,-42.39),(479.6,-57.71,-38.62),(479.1,-57.67,-45.11),(477.7,-59.48,-42.52),(478.4,-53.85,-42.39),(470.3,-69.3,-33.74),(466.2,-55.43,-30.47),(467.6,-63.83,-29.36),(467.5,-54.5,-26.4),(474.5,-55.94,-24.69),(472.9,-52.98,-27.54),(479.9,-55.42,-30.62),(478.9,-56.69,-27.47),(477.6,-58.58,-29.32),(479.5,-57.44,-33.78),(476.6,-59.61,-34.58),(473.3,-59.22,-25.87),(477.2,-56.03,-25.38),(477.5,-54.11,-27.24),(478.2,-53.23,-31.43),(475.6,-54.03,-25.0),(475.8,-52.89,-26.64),(477.5,-52.52,-30.08),(470.7,-57.75,-24.46),(468.5,-57.88,-24.46),(470.6,-65.67,-30.54),(467.0,-60.11,-23.28),(471.0,-64.67,-30.75),(471.8,-67.78,-31.02),(468.7,-63.26,-22.9),(469.0,-63.75,-26.4),(473.5,-63.66,-34.78),(473.5,-63.56,-31.17),(475.4,-61.53,-32.7),(474.3,-61.57,-35.02),(475.4,-61.81,-36.88),(471.9,-64.54,-32.95),(474.0,-66.08,-34.49),(472.4,-67.28,-32.0),(471.9,-64.84,-36.48),(472.6,-67.43,-36.25),(474.2,-63.18,-38.41),(477.6,-53.31,-44.1),(477.5,-57.28,-47.59),(478.1,-54.98,-46.44),(470.6,-66.0,-38.89),(472.0,-68.11,-37.54),(467.6,-64.59,-46.66),(466.4,-56.13,-43.14),(469.3,-64.34,-41.73),(467.7,-55.61,-46.52),(475.4,-57.05,-48.35),(473.1,-54.05,-46.78),(476.3,-55.12,-48.57),(476.0,-54.06,-47.61),(468.5,-59.07,-49.48),(479.6,-55.0,-42.38),(479.4,-54.36,-31.01),(480.0,-57.12,-36.16),(471.2,-64.89,-39.74),(468.6,-57.91,-25.01),(468.5,-59.04,-49.5),(473.3,-61.93,-26.8),(473.5,-63.04,-43.96),(468.4,-65.25,-42.86),(469.1,-64.26,-26.14),(469.4,-65.27,-30.0),(469.5,-65.58,-40.17),(470.4,-67.89,-36.32),(470.9,-68.83,-37.22),(469.6,-66.63,-36.46),(470.4,-67.82,-32.32),(471.0,-68.36,-30.96),(469.6,-66.46,-32.6),(470.1,-68.61,-33.91),(472.0,-61.48,-20.44),(469.5,-62.13,-20.77),(470.3,-58.21,-19.22),(470.5,-59.33,-18.07),(470.3,-57.23,-20.56),(473.9,-60.56,-21.78),(460.6,-53.59,-23.21),(462.5,-51.52,-20.52),(462.7,-52.85,-17.64),(461.7,-54.52,-17.27),(463.5,-57.79,-20.38),(459.7,-51.01,-22.73),(457.9,-51.75,-21.36),(458.4,-54.09,-19.79),(462.5,-47.91,-21.15),(460.8,-47.88,-23.27),(459.3,-40.14,-23.76),(460.8,-40.11,-22.36),(459.3,-47.88,-21.94),(457.7,-39.92,-21.22),(457.7,-47.98,-19.02),(457.4,-49.05,-20.23),(457.5,-51.75,-19.77),(458.7,-51.4,-17.56),(458.7,-39.77,-19.68),(459.4,-47.89,-17.53),(460.1,-39.74,-20.02),(461.1,-47.87,-17.88),(460.2,-50.92,-16.98),(461.7,-51.01,-17.77),(459.9,-36.8,-23.08),(460.1,-36.29,-22.28),(457.7,-36.73,-21.28),(460.4,-37.77,-23.41),(461.4,-37.51,-22.48),(456.1,-37.77,-20.55),(458.7,-34.8,-24.21),(458.7,-35.22,-21.78),(459.1,-34.69,-21.64),(458.5,-35.09,-25.66),(458.3,-35.57,-25.08),(457.9,-35.17,-24.31),(458.1,-35.4,-25.55),(458.5,-35.29,-23.94),(457.6,-35.45,-26.04),(457.5,-35.91,-25.43),(457.1,-35.67,-24.14),(457.5,-35.68,-24.01),(457.1,-35.74,-25.72),(457.1,-36.02,-25.31),(456.9,-36.42,-24.69),(456.4,-36.14,-23.75),(456.9,-36.2,-23.55),(456.5,-36.34,-25.09),(456.5,-36.06,-21.41),(457.0,-36.18,-21.78),(456.2,-36.69,-21.68),(456.5,-36.37,-22.46),(456.6,-36.63,-23.64),(456.4,-37.03,-23.41),(455.9,-36.76,-22.34),(456.3,-36.83,-22.27),(456.1,-36.94,-23.67),(455.8,-36.87,-21.13),(460.3,-36.55,-21.27),(459.4,-35.86,-19.63),(458.4,-36.5,-19.41),(457.0,-37.3,-19.98),(458.3,-34.73,-23.8),(458.3,-34.87,-24.69),(458.6,-34.71,-20.73),(458.4,-34.57,-22.51),(458.1,-35.02,-21.61),(457.6,-35.01,-20.93),(457.4,-34.96,-22.6),(457.3,-35.13,-23.99),(457.4,-35.23,-24.76),(457.2,-35.52,-21.57),(456.9,-35.63,-20.85),(456.7,-35.52,-22.0),(456.7,-35.76,-24.12),(456.7,-35.65,-23.42),(456.1,-36.3,-22.13),(456.1,-36.35,-22.7),(456.1,-36.22,-21.09),(456.3,-36.59,-20.41),(460.5,-35.43,-24.32),(461.4,-34.97,-25.19),(461.2,-34.8,-24.7),(460.9,-36.04,-24.51),(461.7,-35.0,-24.7),(461.5,-35.78,-23.82),(461.3,-36.52,-23.16),(460.9,-35.52,-23.18),(461.0,-35.23,-23.57),(461.5,-34.83,-24.28),(470.7,-61.48,-19.8),(470.3,-63.47,-49.9),(468.7,-62.81,-50.5),(469.0,-60.27,-52.87),(472.0,-61.05,-52.82),(473.0,-59.23,-50.25),(472.4,-62.54,-49.05),(469.8,-50.95,-50.7),(473.1,-51.48,-52.84),(472.1,-52.2,-55.7),(470.0,-52.57,-56.31),(467.9,-55.24,-52.88),(471.4,-50.32,-50.96),(470.4,-49.02,-52.76),(468.4,-50.09,-54.54),(475.4,-52.11,-51.44),(474.9,-50.61,-49.61),(483.7,-48.5,-47.36),(483.9,-49.86,-48.54),(474.9,-49.44,-51.17),(484.4,-47.28,-49.98),(474.8,-48.26,-54.33),(473.4,-48.15,-53.43),(470.4,-48.78,-54.4),(471.3,-49.81,-56.3),(484.7,-48.28,-51.31),(475.3,-49.77,-55.5),(484.6,-49.38,-50.81),(475.6,-51.16,-54.86),(472.2,-51.0,-56.52),(472.3,-52.21,-55.49),(486.5,-50.3,-47.09),(486.9,-50.75,-47.65),(488.3,-48.95,-48.17),(485.2,-49.92,-47.3),(485.0,-50.77,-48.2),(488.6,-47.26,-49.02),(488.8,-50.78,-45.31),(488.8,-50.66,-47.41),(489.0,-51.27,-47.49),(488.2,-50.32,-44.26),(488.1,-49.98,-45.13),(489.0,-50.01,-45.35),(488.3,-49.83,-44.52),(488.6,-50.39,-45.9),(488.4,-49.47,-44.04),(488.3,-49.16,-44.91),(489.2,-49.2,-45.74),(488.9,-49.52,-45.97),(488.6,-48.97,-44.43),(488.5,-48.84,-45.02),(488.6,-48.58,-45.86),(489.4,-48.56,-46.34),(489.1,-48.84,-46.65),(488.7,-48.33,-45.36),(489.7,-48.75,-47.7),(489.3,-48.96,-47.3),(489.4,-48.12,-47.38),(489.5,-48.6,-47.56),(489.0,-48.36,-46.87),(488.8,-48.05,-47.36),(489.6,-47.98,-47.84),(489.3,-48.18,-47.91),(489.0,-47.86,-47.0),(489.6,-47.71,-47.99),(486.7,-50.8,-48.61),(488.1,-50.7,-49.7),(488.4,-49.63,-49.98),(488.5,-48.19,-49.53),(489.2,-50.61,-45.52),(488.8,-50.39,-44.86),(489.4,-50.95,-48.44),(489.7,-50.93,-46.62),(489.5,-50.41,-47.49),(489.9,-50.13,-48.13),(490.0,-50.04,-46.6),(489.5,-49.74,-45.49),(489.1,-49.59,-44.92),(489.7,-49.54,-47.59),(489.8,-49.26,-48.3),(490.1,-49.3,-47.45),(489.4,-48.9,-45.76),(489.7,-49.08,-46.27),(489.9,-48.4,-47.58),(489.7,-48.36,-47.32),(489.9,-48.39,-47.99),(489.5,-48.25,-48.68),(486.9,-51.45,-45.18),(486.4,-52.3,-44.3),(486.8,-52.27,-44.61),(486.0,-51.32,-45.4),(486.3,-52.52,-44.84),(486.0,-51.94,-46.03),(485.7,-51.37,-47.01),(486.7,-51.75,-46.38),(486.8,-51.99,-45.88),(486.7,-52.52,-45.09),(470.6,-62.9,-51.33),(470.9,-59.24,-47.23),(468.4,-59.03,-48.99),(474.0,-40.63,-39.94),(470.5,-37.93,-40.35),(462.0,-44.42,-37.95),(463.9,-38.43,-38.85),(467.0,-37.47,-39.06),(463.6,-47.31,-37.57),(470.3,-46.06,-49.6),(467.6,-47.64,-47.35),(472.0,-43.53,-48.08),(473.0,-41.74,-44.11),(463.6,-47.76,-42.98),(460.8,-17.65,-55.11),(462.3,-22.01,-53.56),(457.7,-19.21,-51.13),(461.4,-22.3,-50.59),(462.3,-21.58,-47.03),(458.8,-18.32,-47.9),(461.6,-16.55,-47.0),(464.0,-21.26,-55.43),(463.9,-20.62,-45.9),(466.4,-19.41,-47.05),(464.0,-15.5,-51.63),(467.5,-19.12,-51.18),(466.4,-19.9,-54.34),(465.8,-24.92,-55.34),(465.7,-24.04,-44.56),(468.7,-24.35,-46.4),(470.2,-24.74,-50.57),(468.7,-24.92,-53.01),(467.5,-33.67,-54.88),(463.8,-33.3,-53.1),(462.1,-31.23,-49.5),(462.6,-30.5,-44.6),(467.2,-31.43,-42.26),(470.6,-31.76,-44.34),(472.1,-32.61,-48.63),(470.5,-33.42,-52.33),(468.1,-42.97,-51.96),(463.4,-39.56,-52.71),(462.3,-36.37,-48.43),(463.1,-38.27,-39.55),(464.4,-35.72,-40.74),(465.4,-45.18,-50.25),(464.2,-42.65,-51.68),(460.7,-43.4,-47.63),(461.9,-44.92,-46.83),(461.2,-45.83,-39.62),(460.2,-44.09,-40.61),(461.4,-42.63,-38.24),(462.7,-41.66,-37.33),(460.0,-41.7,-46.83),(460.0,-39.3,-45.1),(459.6,-41.26,-40.93),(461.8,-38.37,-42.1),(461.2,-40.24,-38.65),(463.8,-39.85,-36.69),(457.0,-12.88,-56.48),(455.2,-13.56,-55.09),(454.5,-13.83,-51.67),(455.2,-13.15,-48.48),(456.9,-12.32,-47.42),(458.6,-11.4,-48.85),(459.3,-11.3,-51.88),(458.6,-11.93,-55.24),(452.0,-7.363,-56.11),(450.6,-8.111,-55.16),(450.0,-8.322,-52.39),(450.6,-7.795,-49.79),(452.0,-6.922,-48.79),(453.6,-6.146,-50.12),(454.2,-6.175,-52.55),(453.6,-6.579,-55.24),(449.1,-2.566,-55.38),(448.0,-3.572,-55.12),(447.5,-3.869,-52.94),(448.0,-3.347,-51.66),(449.3,-2.192,-51.25),(450.3,-1.304,-52.14),(450.7,-1.095,-53.93),(450.3,-1.529,-55.19),(451.2,0.2425,-56.13),(451.7,0.9813,-54.5),(453.4,3.074,-55.81),(451.1,1.912,-56.71),(451.3,0.5445,-52.72),(451.3,2.243,-52.35),(453.5,3.276,-53.72),(449.6,-0.3201,-51.03),(446.4,-2.714,-50.43),(445.7,-1.893,-51.03),(447.2,-1.163,-50.34),(445.8,-3.17,-53.02),(445.2,-2.3,-53.18),(446.2,-3.238,-55.43),(445.5,-2.241,-55.46),(449.7,-1.106,-56.39),(447.0,-1.616,-56.31),(450.7,2.518,-56.7),(453.3,4.076,-54.84),(450.7,2.807,-52.7),(446.9,-3.696,-54.55),(447.0,-3.43,-51.11),(444.6,-0.3385,-53.02),(444.6,-0.4205,-54.12),(445.2,-0.05918,-53.12),(445.1,-0.1411,-54.22),(464.2,-38.28,-40.21),(467.4,-37.66,-40.96),(471.4,-44.61,-27.81),(468.6,-46.41,-28.83),(472.9,-42.37,-30.58),(473.4,-41.16,-35.28),(464.1,-47.05,-32.16),(482.5,-21.22,-34.28),(482.1,-25.64,-34.47),(478.5,-22.5,-36.71),(480.7,-26.06,-36.99),(481.3,-26.15,-40.88),(479.4,-22.42,-40.41),(482.4,-21.58,-42.66),(484.2,-25.19,-33.35),(483.0,-25.93,-42.71),(485.9,-25.42,-42.64),(485.6,-20.51,-39.21),(487.7,-24.94,-39.05),(486.8,-24.87,-35.48),(483.8,-28.38,-31.97),(482.5,-28.85,-42.66),(484.7,-30.59,-41.04),(486.2,-31.38,-37.03),(485.5,-30.37,-34.48),(477.9,-35.39,-28.28),(475.5,-32.81,-29.45),(475.4,-30.58,-33.74),(475.3,-30.81,-38.89),(477.0,-34.43,-40.96),(479.1,-36.89,-39.47),(480.4,-38.01,-35.54),(479.4,-37.3,-31.39),(469.3,-40.74,-26.32),(470.1,-36.9,-26.12),(462.4,-35.45,-31.39),(471.0,-35.16,-39.68),(466.6,-43.6,-26.5),(465.4,-40.76,-25.99),(461.7,-42.15,-28.74),(462.8,-43.75,-29.19),(461.4,-45.57,-35.64),(460.5,-43.73,-35.14),(462.6,-41.82,-39.73),(460.8,-40.59,-30.01),(460.3,-38.96,-32.87),(459.8,-40.92,-35.78),(461.7,-38.41,-36.51),(461.2,-40.22,-38.35),(463.6,-40.15,-41.27),(480.2,-15.74,-34.65),(478.2,-16.23,-35.33),(477.0,-16.85,-38.3),(477.4,-16.83,-41.79),(479.1,-16.56,-43.53),(481.1,-15.84,-42.91),(482.2,-15.44,-40.21),(481.8,-15.39,-36.59),(476.4,-9.566,-36.8),(474.8,-10.2,-37.09),(473.8,-10.73,-39.51),(474.2,-10.71,-42.34),(475.6,-10.25,-43.97),(477.4,-9.555,-43.36),(478.3,-9.333,-41.16),(477.9,-9.199,-38.28),(473.1,-4.339,-39.26),(472.4,-5.543,-38.8),(471.8,-6.21,-40.83),(472.2,-5.917,-42.19),(473.0,-4.619,-43.42),(473.6,-3.379,-43.16),(473.9,-2.751,-41.53),(473.8,-3.015,-40.17),(473.5,-0.9678,-40.05),(473.6,-0.5217,-41.98),(474.1,2.067,-41.85),(472.6,0.4592,-40.15),(473.4,-1.231,-43.47),(472.6,0.1313,-44.52),(474.1,1.959,-43.96),(472.4,-2.834,-44.47),(470.4,-5.986,-43.5),(469.6,-5.451,-43.15),(470.6,-4.502,-44.36),(470.1,-6.071,-40.73),(469.3,-5.589,-40.82),(470.5,-5.646,-38.47),(469.6,-5.119,-38.71),(472.9,-2.629,-39.0),(470.7,-4.004,-38.4),(472.0,0.8833,-40.35),(473.6,2.766,-43.18),(471.8,0.5028,-44.33),(471.3,-5.951,-39.25),(471.2,-6.222,-42.68),(467.6,-4.156,-41.76),(467.6,-4.061,-40.67),(467.9,-3.719,-41.86),(468.0,-3.625,-40.77),(478.9,-70.99,-34.56),(474.6,-70.98,-27.86),(473.3,-77.29,-32.67),(476.1,-65.23,-35.36),(478.6,-71.05,-33.29),(477.9,-71.72,-28.98),(476.6,-71.19,-28.43),(479.1,-73.91,-33.98),(477.5,-75.82,-33.45),(474.8,-76.9,-32.92),(479.5,-68.47,-35.12),(478.4,-66.72,-35.33),(477.9,-65.63,-35.49),(471.1,-70.55,-29.23),(472.3,-72.4,-27.88),(467.3,-74.69,-32.48),(468.5,-76.35,-32.28),(471.7,-77.49,-32.44),(468.6,-69.95,-33.55),(470.6,-67.94,-34.18),(472.9,-66.84,-34.66),(474.3,-71.84,-27.5),(472.9,-75.81,-28.0),(473.2,-76.89,-29.88),(475.5,-66.18,-31.46),(475.2,-67.13,-29.93),(474.7,-69.32,-28.31),(478.2,-74.47,-31.31),(476.6,-72.73,-28.35),(474.9,-76.15,-29.82),(479.2,-68.54,-34.24),(477.2,-66.18,-33.23),(476.8,-68.79,-29.67),(468.6,-75.32,-29.14),(470.2,-76.69,-28.88),(471.3,-74.82,-27.09),(473.3,-69.9,-28.63),(473.7,-67.1,-30.87),(476.3,-76.47,-33.18),(479.3,-72.49,-34.31),(479.0,-70.46,-34.67),(479.1,-70.14,-34.74),(479.3,-69.38,-34.92),(478.5,-69.37,-34.04),(478.5,-69.95,-34.09),(479.6,-68.71,-35.08),(479.1,-68.33,-35.1),(478.7,-68.24,-35.07),(479.0,-67.69,-35.22),(478.4,-68.23,-33.87),(478.6,-67.59,-33.44),(478.1,-69.91,-33.7),(478.1,-68.62,-33.35),(477.4,-67.33,-31.98),(476.6,-66.89,-31.24),(477.1,-65.14,-34.06),(478.5,-67.26,-35.24),(477.9,-66.58,-35.3),(477.9,-66.03,-35.41),(477.5,-65.21,-35.53),(474.1,-66.0,-34.97),(477.7,-66.83,-33.52),(479.0,-67.5,-35.25),(478.6,-66.96,-35.31),(478.3,-67.19,-33.38),(478.8,-67.75,-34.39),(478.3,-68.61,-31.61),(478.8,-68.95,-33.93),(479.4,-68.94,-34.49),(478.1,-66.9,-33.52),(478.8,-71.54,-30.46),(478.1,-70.7,-33.65),(476.8,-70.42,-28.74),(479.0,-72.06,-30.55),(478.2,-70.43,-32.3),(478.5,-70.45,-34.05),(478.2,-70.93,-30.13),(477.9,-71.21,-29.08),(478.2,-71.22,-32.44),(479.1,-71.47,-32.24),(477.5,-73.81,-29.34),(477.1,-75.39,-30.4),(477.2,-67.88,-30.75),(472.1,-67.6,-34.42),(479.3,-71.64,-34.48),(477.0,-65.94,-32.8),(478.5,-70.8,-34.0),(479.2,-71.27,-33.44),(479.3,-71.75,-32.94),(477.4,-70.57,-29.93),(478.0,-69.61,-32.49),(477.3,-69.83,-29.89),(478.4,-68.11,-33.14),(466.5,-71.52,-33.0),(467.5,-72.55,-29.31),(469.9,-77.16,-32.29),(467.7,-70.24,-32.58),(467.1,-70.68,-32.47),(466.6,-70.59,-33.19),(466.2,-70.35,-33.19),(465.1,-70.08,-33.12),(464.1,-69.38,-33.14),(463.1,-67.76,-33.34),(460.9,-66.35,-33.36),(461.0,-65.38,-33.56),(461.2,-62.83,-34.08),(462.0,-61.67,-34.43),(464.0,-61.26,-34.68),(464.7,-62.89,-34.47),(466.7,-64.54,-34.39),(467.9,-67.14,-34.02),(467.0,-68.93,-33.57),(467.8,-69.01,-33.64),(468.1,-69.26,-33.63),(462.9,-65.12,-32.76),(464.9,-66.1,-32.79),(467.5,-69.8,-32.7),(464.5,-64.39,-33.38),(463.4,-62.77,-33.56),(465.3,-67.37,-32.9),(465.6,-68.69,-32.85),(466.7,-69.47,-32.56),(462.6,-63.61,-33.36),(465.9,-69.64,-32.58),(466.5,-69.94,-32.58),(467.0,-70.24,-32.58),(471.3,-70.44,-28.23),(471.4,-70.27,-28.41),(471.6,-70.17,-28.63),(471.8,-70.19,-28.74),(472.0,-70.22,-28.9),(472.2,-70.4,-28.94),(472.4,-70.63,-28.78),(471.3,-71.05,-27.86),(471.5,-70.9,-28.11),(471.8,-70.93,-28.27),(471.9,-71.35,-28.53),(472.0,-71.11,-28.76),(472.4,-70.97,-28.69),(470.9,-71.04,-27.56),(471.1,-71.08,-27.7),(471.3,-71.73,-27.89),(472.1,-71.59,-28.39),(472.2,-71.23,-28.43),(470.8,-71.53,-27.19),(471.3,-72.0,-27.75),(471.9,-72.19,-28.04),(472.2,-72.1,-28.04),(470.9,-72.0,-26.98),(471.1,-72.03,-27.12),(471.5,-72.4,-27.23),(471.8,-72.68,-27.72),(472.0,-72.58,-27.9),(471.1,-72.42,-26.88),(471.9,-72.86,-27.41),(472.2,-72.83,-27.65),(472.3,-72.66,-27.97),(472.5,-72.63,-27.82),(471.4,-72.9,-26.82),(471.5,-73.08,-26.84),(471.8,-73.13,-27.0),(472.0,-73.2,-27.15),(472.3,-73.12,-27.41),(472.5,-72.89,-27.7),(471.4,-70.4,-27.99),(471.5,-70.23,-28.17),(471.7,-70.13,-28.39),(472.1,-70.17,-28.67),(472.3,-70.35,-28.7),(471.4,-71.01,-27.62),(471.6,-70.86,-27.87),(471.8,-70.88,-28.04),(471.0,-70.99,-27.33),(471.2,-71.49,-27.21),(471.4,-71.96,-27.51),(470.9,-71.48,-26.96),(471.0,-71.96,-26.74),(471.2,-71.98,-26.89),(471.6,-72.36,-27.0),(471.9,-72.64,-27.49),(471.1,-72.38,-26.65),(471.7,-72.69,-26.89),(472.0,-72.82,-27.18),(472.3,-72.79,-27.42),(471.4,-72.86,-26.59),(471.6,-73.04,-26.61),(471.8,-73.09,-26.76),(472.1,-73.15,-26.92),(472.4,-73.08,-27.18),(472.6,-72.85,-27.47),(473.9,-71.8,-40.0),(478.4,-71.21,-35.67),(477.3,-72.42,-39.4),(475.9,-71.96,-39.84),(470.8,-70.78,-38.07),(471.7,-72.98,-38.92),(473.9,-72.77,-39.96),(472.4,-76.46,-37.66),(472.8,-77.15,-35.77),(475.1,-66.46,-38.47),(474.7,-67.8,-39.63),(474.1,-70.12,-40.25),(478.4,-74.77,-36.63),(475.7,-73.85,-39.43),(474.5,-76.48,-36.23),(479.1,-68.65,-35.87),(477.0,-66.45,-37.29),(476.2,-69.46,-39.61),(468.2,-75.77,-35.72),(469.8,-77.16,-35.83),(470.7,-75.68,-38.71),(472.6,-70.62,-39.37),(473.3,-67.6,-38.39),(478.4,-69.48,-35.59),(478.4,-70.03,-35.31),(478.2,-68.39,-36.15),(478.4,-67.82,-36.86),(478.0,-70.04,-35.62),(477.9,-68.83,-36.44),(477.1,-67.74,-38.1),(476.1,-67.1,-38.66),(476.9,-65.33,-37.07),(477.5,-67.05,-36.87),(478.1,-67.43,-37.01),(478.7,-67.85,-35.94),(477.9,-69.07,-38.23),(478.6,-69.08,-35.91),(479.4,-69.01,-35.53),(477.9,-67.13,-36.95),(478.3,-72.07,-38.26),(478.0,-70.81,-35.35),(476.2,-71.17,-39.89),(478.6,-72.56,-38.02),(478.0,-70.75,-36.73),(478.4,-70.52,-35.15),(477.7,-71.51,-38.55),(477.3,-71.88,-39.39),(478.0,-71.48,-36.35),(478.8,-71.77,-36.65),(476.9,-74.5,-38.0),(476.7,-75.7,-36.47),(476.8,-68.46,-38.81),(476.7,-66.08,-37.65),(478.5,-70.88,-35.08),(479.1,-71.41,-35.59),(479.2,-71.95,-35.92),(476.8,-71.22,-38.67),(477.8,-69.95,-36.72),(476.7,-70.45,-39.11),(478.2,-68.48,-36.88),(467.1,-73.03,-36.39),(467.6,-70.34,-34.16),(467.1,-70.78,-33.98),(463.2,-66.45,-34.34),(464.8,-67.41,-34.33),(467.4,-69.9,-34.17),(465.0,-64.99,-35.1),(463.4,-62.83,-35.13),(465.4,-68.58,-34.02),(466.6,-69.54,-34.13),(462.2,-64.39,-34.82),(465.8,-69.73,-33.98),(466.4,-70.03,-34.0),(466.9,-70.34,-34.01),(470.7,-71.18,-39.12),(470.8,-70.99,-39.03),(471.1,-70.86,-38.91),(471.2,-70.87,-38.83),(471.5,-70.88,-38.72),(471.6,-71.05,-38.66),(471.8,-71.31,-38.62),(470.7,-71.82,-39.23),(470.9,-71.64,-39.1),(471.2,-71.65,-38.99),(471.3,-72.03,-38.6),(471.4,-71.77,-38.49),(471.8,-71.65,-38.76),(470.2,-71.84,-39.43),(470.5,-71.86,-39.33),(470.7,-72.47,-38.93),(471.5,-72.27,-38.69),(471.6,-71.95,-38.83),(470.1,-72.36,-39.57),(470.7,-72.76,-38.97),(471.3,-72.91,-38.74),(470.2,-72.85,-39.61),(470.4,-72.86,-39.51),(470.8,-73.22,-39.36),(471.2,-73.44,-38.85),(471.4,-73.31,-38.75),(470.4,-73.27,-39.59),(471.3,-73.65,-39.1),(471.6,-73.59,-38.95),(471.7,-73.38,-38.62),(472.0,-73.41,-38.99),(470.7,-73.75,-39.53),(470.8,-73.94,-39.48),(471.1,-73.96,-39.37),(471.4,-74.01,-39.25),(471.7,-73.91,-39.09),(471.9,-73.65,-38.95),(470.7,-71.13,-39.38),(470.9,-70.98,-39.29),(471.1,-70.85,-39.16),(471.5,-70.87,-38.97),(471.7,-71.04,-38.91),(471.8,-71.3,-38.88),(470.7,-71.81,-39.48),(470.9,-71.64,-39.35),(471.2,-71.64,-39.24),(470.3,-71.83,-39.68),(470.5,-72.33,-39.66),(470.1,-72.35,-39.82),(470.4,-72.85,-39.76),(470.2,-72.84,-39.87),(470.9,-73.21,-39.62),(471.2,-73.43,-39.11),(470.4,-73.27,-39.84),(471.0,-73.55,-39.62),(471.3,-73.64,-39.36),(471.6,-73.58,-39.21),(471.7,-73.35,-38.93),(470.7,-73.75,-39.78),(470.9,-73.93,-39.73),(471.1,-73.95,-39.62),(471.4,-74.0,-39.5),(471.7,-73.9,-39.35),(471.9,-73.64,-39.21),(475.0,-68.19,-28.92),(474.4,-68.8,-40.18),(464.1,-56.71,-23.97),(469.7,-54.88,-48.94),(529.8,-48.73,-46.34),(537.2,-42.02,-48.53),(539.5,-49.37,-46.96),(528.5,-45.86,-46.36),(529.5,-48.4,-41.05),(531.3,-46.95,-37.67),(534.4,-46.68,-38.4),(533.2,-44.92,-37.62),(539.0,-49.06,-40.38),(535.6,-43.5,-39.82),(536.6,-42.5,-42.88),(530.8,-45.75,-40.26),(538.7,-49.7,-53.25),(529.2,-48.94,-51.89),(530.9,-47.82,-55.21),(533.9,-47.59,-55.46),(532.1,-45.95,-56.56),(534.7,-44.36,-55.9),(536.1,-43.13,-53.43),(530.1,-46.53,-53.19),(536.1,-57.59,-55.23),(527.6,-60.22,-51.81),(532.9,-56.13,-56.53),(527.9,-58.75,-53.79),(529.8,-62.07,-49.12),(531.6,-63.94,-43.71),(529.0,-52.51,-45.43),(528.7,-57.56,-44.57),(540.2,-53.79,-45.78),(538.9,-56.84,-46.37),(542.3,-53.23,-52.34),(541.9,-54.88,-48.57),(541.2,-54.79,-55.02),(539.8,-56.58,-52.36),(540.7,-50.96,-52.19),(532.3,-66.25,-43.17),(528.9,-52.3,-39.4),(530.1,-60.75,-38.52),(530.3,-51.43,-35.41),(537.4,-53.07,-34.26),(535.8,-50.04,-36.94),(542.6,-52.64,-40.58),(541.7,-53.9,-37.37),(540.8,-55.29,-39.28),(542.0,-54.64,-43.73),(539.0,-56.73,-44.34),(537.1,-55.75,-34.47),(540.1,-53.22,-35.15),(540.4,-51.3,-37.01),(541.0,-50.41,-41.23),(538.5,-51.18,-34.62),(538.7,-50.03,-36.25),(540.3,-49.69,-39.81),(533.5,-54.78,-33.76),(531.4,-54.85,-33.61),(532.9,-62.66,-39.96),(531.0,-55.84,-30.43),(533.8,-61.14,-37.85),(534.0,-64.78,-40.55),(532.6,-59.0,-29.73),(532.5,-59.76,-33.12),(535.7,-60.69,-44.37),(536.2,-60.15,-38.9),(538.0,-58.3,-41.22),(536.6,-58.62,-44.64),(537.6,-58.88,-46.59),(534.1,-61.54,-42.43),(536.1,-63.13,-44.16),(534.6,-64.3,-41.57),(534.0,-61.82,-45.97),(534.6,-64.43,-45.83),(536.3,-60.21,-48.04),(539.9,-50.39,-53.83),(539.5,-54.33,-57.37),(540.2,-52.06,-56.23),(532.6,-62.93,-48.3),(534.0,-65.08,-47.09),(529.3,-62.53,-52.65),(528.6,-52.94,-52.07),(530.7,-61.46,-48.0),(529.8,-52.43,-55.54),(536.5,-54.73,-57.56),(535.3,-51.01,-56.19),(537.6,-52.79,-58.21),(538.1,-51.08,-57.23),(527.8,-58.84,-54.31),(541.8,-52.14,-52.29),(542.1,-51.57,-40.92),(542.4,-54.32,-46.14),(533.3,-61.83,-49.18),(531.4,-54.88,-34.16),(527.8,-58.82,-54.32),(536.5,-58.35,-34.81),(534.9,-60.33,-51.54),(530.0,-62.52,-49.24),(532.5,-60.25,-32.76),(531.8,-62.23,-39.33),(531.5,-62.48,-49.49),(532.5,-64.83,-45.75),(532.9,-65.78,-46.7),(531.7,-63.55,-45.81),(532.6,-64.79,-41.76),(533.2,-65.35,-40.45),(531.8,-63.4,-41.95),(532.2,-65.55,-43.33),(536.2,-57.21,-28.59),(533.7,-56.75,-27.1),(533.3,-55.26,-28.51),(536.8,-54.78,-27.25),(537.4,-53.44,-30.72),(538.0,-56.5,-30.59),(534.4,-45.0,-32.83),(537.8,-45.49,-31.54),(537.4,-45.72,-28.26),(535.4,-45.85,-26.87),(532.8,-49.21,-28.25),(536.6,-44.08,-33.75),(536.1,-42.36,-32.46),(533.7,-43.31,-29.23),(540.0,-46.6,-33.41),(539.7,-45.42,-35.84),(548.1,-46.22,-41.56),(548.0,-47.27,-39.67),(540.2,-44.07,-35.08),(549.6,-44.89,-40.13),(541.0,-42.46,-32.83),(539.5,-42.15,-33.32),(536.5,-41.9,-31.1),(537.5,-42.73,-29.03),(549.9,-45.64,-38.35),(541.3,-43.77,-31.02),(549.3,-46.66,-38.08),(541.1,-45.2,-30.86),(538.2,-43.98,-28.45),(537.9,-45.3,-28.78),(549.6,-48.95,-41.26),(550.0,-49.4,-40.57),(552.1,-48.12,-41.38),(548.7,-48.26,-41.01),(548.4,-48.75,-39.56),(553.2,-46.63,-41.83),(550.8,-50.18,-43.47),(551.7,-49.88,-41.34),(551.7,-50.49,-41.12),(550.2,-49.82,-44.57),(550.4,-49.34,-44.02),(551.2,-49.55,-44.04),(550.4,-49.37,-44.71),(550.9,-49.68,-43.17),(550.5,-49.16,-45.41),(550.7,-48.7,-44.84),(551.7,-48.81,-44.32),(551.4,-48.97,-43.82),(550.9,-48.7,-45.48),(551.0,-48.46,-45.02),(551.3,-48.06,-44.47),(552.1,-48.17,-44.29),(551.9,-48.28,-43.73),(551.4,-47.99,-45.14),(553.2,-48.34,-42.48),(552.6,-48.4,-42.37),(553.1,-47.71,-42.79),(552.6,-48.02,-43.12),(551.9,-47.78,-43.83),(552.0,-47.37,-43.58),(552.9,-47.45,-43.32),(552.7,-47.53,-42.91),(552.1,-47.32,-44.1),(553.6,-47.43,-42.69),(550.1,-49.17,-39.49),(551.6,-49.32,-38.79),(552.3,-48.41,-39.3),(552.9,-47.3,-40.72),(551.3,-50.11,-43.53),(550.9,-49.94,-44.17),(552.5,-50.28,-40.75),(551.9,-50.33,-42.55),(552.4,-49.83,-41.79),(553.0,-49.65,-41.64),(552.4,-49.62,-43.22),(551.7,-49.4,-44.24),(551.3,-49.3,-44.76),(552.8,-49.08,-42.25),(553.3,-48.84,-41.89),(552.9,-48.88,-43.03),(551.9,-48.59,-44.58),(552.3,-48.72,-44.06),(553.0,-47.95,-43.22),(552.8,-47.9,-43.62),(553.5,-48.04,-42.47),(553.5,-47.8,-41.72),(549.4,-50.47,-42.17),(548.6,-51.26,-42.32),(549.1,-51.29,-42.11),(548.8,-50.06,-41.93),(548.5,-51.31,-41.65),(548.6,-50.47,-40.92),(548.7,-49.67,-40.37),(549.4,-50.45,-40.85),(549.4,-50.79,-41.16),(548.9,-51.37,-41.48),(535.3,-56.71,-27.35),(531.5,-61.43,-56.43),(529.8,-61.53,-56.07),(528.0,-60.17,-57.53),(530.3,-59.48,-60.02),(530.3,-57.0,-58.76),(533.0,-59.89,-56.64),(521.1,-52.99,-54.7),(522.2,-51.37,-58.83),(522.2,-53.18,-60.95),(521.3,-54.86,-60.17),(523.5,-57.28,-56.33),(519.7,-50.85,-55.99),(518.0,-52.11,-56.2),(518.6,-54.19,-56.92),(520.9,-47.74,-59.91),(519.6,-47.66,-57.29),(515.3,-40.89,-59.46),(516.6,-40.83,-61.34),(518.0,-48.23,-57.93),(513.4,-41.4,-61.37),(516.2,-49.24,-59.94),(516.5,-50.03,-58.23),(517.4,-52.48,-57.52),(518.1,-52.37,-60.19),(514.2,-41.34,-63.26),(517.6,-49.07,-62.06),(515.5,-41.03,-63.41),(519.2,-48.62,-62.41),(519.3,-51.77,-61.53),(520.9,-51.44,-61.35),(515.3,-37.75,-61.39),(515.2,-37.26,-62.26),(512.8,-38.13,-62.19),(516.0,-38.72,-61.0),(516.7,-38.36,-62.22),(511.4,-39.4,-62.23),(513.6,-35.73,-60.66),(513.5,-36.4,-62.48),(513.8,-35.89,-62.93),(513.6,-35.95,-59.16),(513.4,-36.47,-59.62),(512.8,-36.17,-60.32),(513.2,-36.32,-59.11),(513.4,-36.24,-60.8),(512.8,-36.38,-58.52),(512.7,-36.88,-59.02),(512.1,-36.77,-60.23),(512.5,-36.73,-60.46),(512.3,-36.74,-58.66),(512.3,-37.05,-59.03),(512.1,-37.49,-59.56),(511.5,-37.32,-60.41),(512.0,-37.34,-60.69),(511.8,-37.43,-59.09),(511.5,-37.53,-62.05),(512.0,-37.47,-61.66),(511.3,-38.09,-61.34),(511.5,-37.63,-61.54),(511.7,-37.8,-60.48),(511.6,-38.22,-60.61),(511.0,-38.09,-61.44),(511.4,-38.12,-61.48),(511.3,-38.15,-60.3),(510.9,-38.46,-61.75),(515.3,-37.62,-63.09),(514.1,-37.17,-64.46),(513.2,-37.94,-64.26),(512.1,-38.85,-63.15),(513.1,-35.73,-60.97),(513.2,-35.82,-60.07),(513.3,-36.16,-63.75),(513.0,-35.66,-62.34),(512.8,-36.33,-62.64),(512.3,-36.5,-63.22),(512.1,-36.13,-61.94),(512.3,-36.21,-60.53),(512.4,-36.26,-59.76),(512.1,-36.93,-62.33),(511.8,-37.22,-62.89),(511.6,-36.86,-62.23),(511.7,-36.9,-60.16),(511.7,-36.83,-60.86),(511.1,-37.63,-61.66),(511.2,-37.63,-61.29),(511.1,-37.8,-62.18),(511.3,-38.21,-62.66),(515.7,-36.34,-60.25),(516.7,-35.73,-59.74),(516.3,-35.62,-60.15),(516.3,-36.88,-60.16),(516.9,-35.74,-60.33),(516.7,-36.57,-61.06),(516.6,-37.36,-61.59),(516.0,-36.43,-61.5),(516.1,-36.1,-61.17),(516.6,-35.61,-60.67),(531.2,-61.0,-57.9),(532.9,-56.14,-56.55),(527.9,-58.75,-53.81),(536.9,-37.66,-49.22),(535.8,-37.4,-47.88),(524.8,-41.15,-46.39),(527.0,-35.21,-47.34),(530.1,-34.33,-47.77),(526.4,-44.09,-46.17),(532.6,-42.92,-58.66),(530.0,-44.45,-56.25),(534.5,-40.46,-57.25),(535.7,-38.71,-53.32),(526.1,-44.5,-51.58),(543.4,-25.59,-63.8),(546.8,-28.39,-62.88),(542.3,-28.5,-59.72),(546.3,-29.05,-59.86),(546.9,-28.11,-56.33),(542.8,-27.28,-56.51),(543.9,-24.42,-55.67),(547.8,-27.1,-64.82),(548.0,-26.65,-55.26),(549.6,-24.69,-56.51),(544.7,-22.33,-60.38),(550.3,-24.02,-60.69),(549.5,-25.06,-63.82),(548.4,-29.61,-64.83),(548.4,-28.35,-54.18),(550.3,-30.41,-55.4),(551.2,-31.96,-59.15),(550.2,-31.31,-61.88),(540.9,-35.8,-63.48),(539.3,-32.71,-63.23),(540.3,-29.91,-60.27),(541.0,-29.34,-55.29),(542.1,-32.7,-51.51),(543.6,-35.55,-52.3),(543.7,-37.61,-55.8),(542.4,-37.41,-59.87),(531.5,-41.14,-59.26),(532.4,-36.1,-63.21),(534.8,-32.65,-59.61),(531.7,-32.49,-51.47),(535.7,-32.41,-51.39),(527.8,-41.92,-58.94),(529.5,-38.58,-61.79),(523.3,-40.04,-55.95),(524.4,-41.6,-55.26),(523.9,-42.53,-48.02),(522.9,-40.76,-48.9),(524.3,-39.35,-46.6),(525.6,-38.41,-45.78),(522.6,-38.33,-55.06),(529.8,-32.21,-58.44),(522.4,-37.91,-49.13),(531.4,-32.27,-54.44),(524.2,-36.95,-46.97),(526.8,-36.63,-45.2),(536.6,-23.89,-64.02),(535.9,-25.38,-62.56),(535.9,-26.04,-59.13),(536.1,-25.16,-55.93),(536.9,-23.59,-54.93),(537.4,-21.97,-56.4),(537.6,-21.49,-59.46),(537.3,-22.3,-62.82),(528.1,-22.49,-62.17),(527.7,-23.86,-61.2),(527.7,-24.41,-58.43),(527.9,-23.7,-55.83),(528.3,-22.26,-54.83),(528.7,-20.8,-56.18),(529.1,-20.42,-58.67),(528.7,-21.06,-61.34),(521.8,-20.7,-60.35),(521.8,-22.06,-60.14),(521.9,-22.6,-57.98),(521.9,-21.95,-56.67),(521.9,-20.38,-56.2),(521.8,-19.12,-57.05),(521.8,-18.75,-58.83),(521.8,-19.23,-60.12),(520.4,-17.5,-60.84),(520.1,-16.78,-59.13),(519.2,-14.37,-60.25),(518.8,-16.55,-61.21),(520.3,-17.32,-57.4),(518.8,-16.27,-56.83),(519.2,-14.19,-58.16),(520.2,-18.99,-55.75),(520.3,-22.62,-55.3),(519.2,-22.51,-55.77),(519.4,-21.13,-55.06),(520.2,-23.21,-57.92),(519.1,-23.06,-57.95),(520.2,-22.91,-60.25),(519.1,-22.81,-60.22),(520.7,-19.34,-61.19),(519.5,-21.45,-61.06),(518.0,-16.42,-61.12),(518.3,-13.79,-59.17),(517.9,-16.32,-57.09),(521.2,-22.83,-59.5),(521.2,-22.64,-56.04),(516.9,-22.31,-57.57),(516.9,-22.36,-58.68),(517.0,-21.77,-57.66),(517.0,-21.82,-58.77),(532.3,-33.4,-51.36),(534.8,-35.39,-50.16),(534.5,-41.64,-36.96),(531.7,-43.36,-37.81),(536.1,-39.42,-39.81),(536.4,-38.19,-44.53),(527.1,-43.86,-40.81),(531.2,-12.8,-42.54),(531.6,-17.47,-42.74),(527.3,-14.32,-44.88),(530.2,-18.03,-45.22),(530.7,-18.04,-49.13),(528.1,-14.18,-48.6),(531.1,-13.15,-50.92),(533.6,-16.77,-41.69),(532.4,-17.59,-51.02),(535.1,-16.7,-51.04),(534.2,-11.86,-47.54),(536.8,-16.01,-47.51),(536.0,-16.08,-43.9),(534.6,-20.42,-40.37),(533.2,-21.21,-50.98),(536.2,-21.77,-49.72),(538.2,-21.8,-45.92),(537.1,-21.32,-43.22),(534.5,-29.09,-36.85),(530.8,-28.29,-37.82),(529.0,-26.55,-41.86),(528.9,-26.69,-46.98),(532.8,-28.74,-49.43),(536.3,-29.62,-48.19),(538.2,-29.87,-44.36),(537.1,-29.79,-40.1),(532.7,-37.73,-35.27),(529.2,-34.21,-34.9),(525.8,-32.23,-39.73),(528.8,-32.47,-48.24),(529.9,-40.52,-35.29),(528.8,-37.65,-34.65),(524.9,-38.93,-37.13),(526.0,-40.56,-37.69),(524.3,-42.3,-44.06),(523.4,-40.43,-43.46),(525.4,-38.55,-48.17),(524.1,-37.34,-38.31),(523.5,-35.68,-41.1),(522.9,-37.61,-44.01),(524.8,-35.14,-44.84),(524.2,-36.93,-46.67),(526.4,-36.9,-49.76),(528.5,-7.385,-42.86),(526.5,-7.927,-43.49),(525.3,-8.577,-46.44),(525.7,-8.558,-49.94),(527.4,-8.244,-51.71),(529.4,-7.461,-51.14),(530.4,-7.02,-48.46),(530.1,-6.98,-44.83),(524.8,-1.355,-44.99),(523.2,-1.934,-45.24),(522.2,-2.434,-47.63),(522.5,-2.452,-50.47),(523.9,-2.051,-52.13),(525.7,-1.407,-51.56),(526.7,-1.185,-49.38),(526.3,-1.034,-46.5),(523.1,3.394,-47.48),(521.8,2.836,-47.04),(520.9,2.357,-49.05),(521.3,2.55,-50.43),(523.0,3.1,-51.63),(524.3,3.611,-51.35),(525.0,3.92,-49.7),(524.7,3.823,-48.35),(526.3,5.383,-48.3),(526.9,5.697,-50.26),(529.4,7.253,-50.15),(526.9,7.016,-48.52),(526.1,5.179,-51.72),(526.8,6.662,-52.87),(529.3,7.113,-52.26),(524.0,4.701,-52.76),(519.9,3.446,-51.86),(519.7,4.486,-51.61),(521.3,4.615,-52.77),(519.5,3.533,-49.09),(519.4,4.554,-49.3),(520.2,3.764,-46.84),(519.9,4.832,-47.18),(524.4,4.682,-47.26),(521.7,5.062,-46.82),(526.8,7.706,-48.77),(529.6,8.013,-51.53),(526.4,7.439,-52.75),(520.5,2.942,-47.52),(520.3,2.689,-50.95),(519.5,6.647,-50.36),(519.6,6.724,-49.27),(520.2,6.732,-50.45),(520.3,6.81,-49.36),(540.9,-68.16,-44.68),(536.8,-68.08,-37.66),(535.1,-74.32,-42.46),(538.3,-62.33,-45.17),(540.6,-68.22,-43.38),(540.0,-68.89,-39.03),(538.8,-68.33,-38.37),(540.9,-71.09,-44.15),(539.4,-72.96,-43.53),(536.6,-73.97,-42.81),(541.6,-65.65,-45.24),(540.5,-63.87,-45.34),(540.1,-62.77,-45.45),(533.3,-67.55,-38.76),(534.5,-69.44,-37.53),(529.3,-71.57,-41.78),(530.3,-73.27,-41.69),(533.5,-74.48,-42.11),(530.7,-66.86,-42.88),(532.7,-64.9,-43.63),(535.0,-63.85,-44.25),(536.5,-68.94,-37.29),(534.9,-72.86,-37.74),(535.1,-73.94,-39.66),(537.8,-63.28,-41.25),(537.5,-64.24,-39.71),(537.0,-66.42,-38.09),(540.2,-71.63,-41.43),(538.7,-69.88,-38.32),(536.9,-73.24,-39.71),(541.3,-65.72,-44.34),(539.4,-63.31,-43.15),(539.0,-65.93,-39.6),(530.6,-72.26,-38.55),(532.2,-73.67,-38.43),(533.4,-71.84,-36.7),(535.5,-66.96,-38.31),(535.9,-64.15,-40.54),(538.1,-73.57,-43.17),(541.2,-69.66,-44.47),(541.0,-67.63,-44.78),(541.1,-67.31,-44.85),(541.3,-66.55,-45.03),(540.6,-66.53,-44.09),(540.5,-67.11,-44.15),(541.6,-65.89,-45.21),(541.1,-65.5,-45.18),(540.7,-65.4,-45.12),(541.1,-64.86,-45.29),(540.5,-65.39,-43.9),(540.7,-64.76,-43.47),(540.2,-67.06,-43.74),(540.2,-65.78,-43.37),(539.6,-64.48,-41.93),(538.8,-64.02,-41.12),(539.3,-62.27,-43.95),(540.6,-64.41,-45.26),(540.0,-63.72,-45.27),(540.0,-63.16,-45.37),(539.7,-62.34,-45.45),(536.2,-63.04,-44.64),(539.9,-63.97,-43.48),(541.1,-64.67,-45.31),(540.7,-64.12,-45.34),(540.5,-64.35,-43.39),(540.9,-64.92,-44.45),(540.4,-65.78,-41.64),(540.8,-66.11,-44.0),(541.5,-66.12,-44.6),(540.3,-64.05,-43.51),(540.9,-68.73,-40.57),(540.1,-67.85,-43.7),(539.0,-67.57,-38.69),(541.1,-69.25,-40.69),(540.3,-67.59,-42.35),(540.5,-67.6,-44.12),(540.3,-68.1,-40.19),(540.1,-68.39,-39.13),(540.3,-68.38,-42.5),(541.1,-68.66,-42.37),(539.5,-70.98,-39.39),(539.1,-72.53,-40.44),(539.5,-65.03,-40.7),(534.2,-64.59,-43.97),(541.2,-68.81,-44.63),(539.3,-63.08,-42.7),(540.5,-67.96,-44.08),(541.2,-68.45,-43.58),(541.3,-68.93,-43.09),(539.5,-67.73,-39.93),(540.1,-66.77,-42.51),(539.5,-66.98,-39.87),(540.5,-65.27,-43.17),(528.5,-68.38,-42.19),(529.7,-69.46,-38.6),(531.7,-74.11,-41.83),(529.8,-67.13,-41.85),(529.2,-67.56,-41.7),(528.6,-67.45,-42.38),(528.2,-67.2,-42.34),(527.2,-66.9,-42.18),(526.2,-66.18,-42.12),(525.2,-64.53,-42.22),(523.2,-63.07,-42.06),(523.3,-62.1,-42.25),(523.5,-59.55,-42.74),(524.4,-58.41,-43.14),(526.4,-58.06,-43.53),(527.0,-59.7,-43.4),(528.9,-61.4,-43.49),(530.0,-64.03,-43.25),(529.1,-65.8,-42.76),(529.9,-65.9,-42.89),(530.2,-66.16,-42.91),(525.1,-61.9,-41.59),(527.1,-62.92,-41.78),(529.6,-66.69,-41.94),(526.8,-61.2,-42.32),(525.7,-59.56,-42.39),(527.5,-64.2,-41.94),(527.7,-65.53,-41.93),(528.8,-66.33,-41.73),(525.0,-60.38,-42.15),(528.0,-66.49,-41.7),(528.6,-66.8,-41.75),(529.1,-67.11,-41.78),(533.6,-67.45,-37.77),(533.7,-67.29,-37.96),(533.9,-67.19,-38.19),(534.0,-67.21,-38.31),(534.3,-67.24,-38.49),(534.4,-67.43,-38.55),(534.6,-67.67,-38.4),(533.5,-68.07,-37.41),(533.7,-67.92,-37.67),(534.0,-67.95,-37.85),(534.0,-68.38,-38.12),(534.2,-68.14,-38.37),(534.6,-68.01,-38.32),(533.1,-68.04,-37.08),(533.4,-68.09,-37.24),(533.5,-68.74,-37.46),(534.3,-68.62,-38.01),(534.4,-68.27,-38.05),(533.0,-68.53,-36.72),(533.5,-69.01,-37.32),(534.0,-69.21,-37.65),(534.4,-69.14,-37.68),(533.1,-69.01,-36.51),(533.3,-69.04,-36.68),(533.7,-69.42,-36.82),(534.0,-69.71,-37.34),(534.1,-69.61,-37.53),(533.3,-69.43,-36.44),(534.1,-69.9,-37.04),(534.4,-69.86,-37.3),(534.4,-69.7,-37.62),(534.7,-69.67,-37.49),(533.6,-69.92,-36.41),(533.7,-70.11,-36.45),(534.0,-70.16,-36.62),(534.2,-70.23,-36.79),(534.5,-70.16,-37.07),(534.7,-69.94,-37.37),(533.7,-67.42,-37.54),(533.7,-67.25,-37.73),(534.0,-67.15,-37.96),(534.3,-67.2,-38.27),(534.5,-67.38,-38.31),(533.6,-68.03,-37.18),(533.8,-67.88,-37.44),(534.0,-67.91,-37.62),(533.2,-68.0,-36.85),(533.4,-68.5,-36.76),(533.6,-68.97,-37.09),(533.1,-68.49,-36.49),(533.2,-68.97,-36.28),(533.4,-69.0,-36.45),(533.8,-69.38,-36.59),(534.1,-69.67,-37.11),(533.4,-69.39,-36.21),(533.9,-69.72,-36.49),(534.2,-69.86,-36.81),(534.4,-69.83,-37.07),(533.6,-69.88,-36.18),(533.8,-70.07,-36.22),(534.0,-70.12,-36.39),(534.3,-70.19,-36.57),(534.6,-70.12,-36.85),(534.8,-69.9,-37.15),(535.6,-68.81,-49.73),(540.4,-68.36,-45.75),(539.1,-69.51,-49.41),(537.7,-69.02,-49.73),(532.6,-67.72,-47.56),(533.5,-69.94,-48.51),(535.6,-69.77,-49.71),(534.0,-73.44,-47.35),(534.6,-74.15,-45.52),(537.1,-63.51,-48.22),(536.6,-64.83,-49.37),(535.9,-67.13,-49.98),(540.2,-71.91,-46.75),(537.4,-70.9,-49.34),(536.2,-73.53,-46.09),(541.2,-65.82,-45.97),(539.1,-63.56,-47.19),(538.1,-66.53,-49.49),(530.0,-72.65,-45.1),(531.6,-74.09,-45.35),(532.3,-72.61,-48.27),(534.5,-67.6,-49.0),(535.2,-64.6,-48.02),(540.4,-66.63,-45.64),(540.4,-67.18,-45.36),(540.3,-65.53,-46.17),(540.4,-64.96,-46.87),(540.0,-67.17,-45.65),(539.9,-65.96,-46.45),(539.0,-64.84,-48.02),(538.1,-64.17,-48.49),(539.0,-62.44,-46.94),(539.6,-64.17,-46.82),(540.1,-64.57,-47.0),(540.8,-65.01,-45.99),(539.8,-66.18,-48.23),(540.6,-66.23,-45.97),(541.4,-66.18,-45.65),(540.0,-64.26,-46.92),(540.1,-69.2,-48.33),(539.9,-67.95,-45.38),(538.0,-68.24,-49.8),(540.4,-69.7,-48.13),(539.9,-67.88,-46.76),(540.4,-67.67,-45.22),(539.5,-68.62,-48.57),(539.1,-68.98,-49.39),(539.9,-68.62,-46.39),(540.7,-68.92,-46.76),(538.6,-71.59,-48.01),(538.5,-72.8,-46.48),(538.7,-65.55,-48.71),(538.8,-63.17,-47.52),(540.4,-68.03,-45.15),(541.0,-68.58,-45.72),(541.1,-69.11,-46.06),(538.6,-68.31,-48.62),(539.7,-67.07,-46.73),(538.6,-67.53,-49.04),(540.2,-65.61,-46.89),(529.0,-69.89,-45.64),(529.6,-67.22,-43.41),(529.1,-67.65,-43.21),(525.4,-63.22,-43.2),(527.0,-64.22,-43.33),(529.4,-66.78,-43.41),(527.2,-61.8,-44.08),(525.7,-59.6,-43.96),(527.5,-65.41,-43.08),(528.6,-66.4,-43.3),(524.5,-61.14,-43.59),(527.9,-66.57,-43.1),(528.4,-66.89,-43.16),(528.9,-67.2,-43.21),(532.6,-68.11,-48.61),(532.7,-67.92,-48.53),(532.9,-67.8,-48.42),(533.1,-67.81,-48.36),(533.3,-67.83,-48.27),(533.5,-68.0,-48.22),(533.6,-68.27,-48.2),(532.5,-68.75,-48.73),(532.7,-68.58,-48.61),(533.0,-68.59,-48.52),(533.1,-68.98,-48.15),(533.3,-68.72,-48.05),(533.6,-68.61,-48.34),(532.0,-68.75,-48.9),(532.3,-68.78,-48.81),(532.5,-69.4,-48.45),(533.3,-69.22,-48.26),(533.4,-68.9,-48.41),(531.9,-69.27,-49.03),(532.5,-69.69,-48.49),(533.0,-69.85,-48.3),(531.9,-69.77,-49.09),(532.2,-69.78,-49.01),(532.6,-70.15,-48.9),(532.9,-70.38,-48.41),(533.1,-70.26,-48.33),(532.1,-70.19,-49.09),(533.0,-70.6,-48.67),(533.3,-70.54,-48.55),(533.4,-70.33,-48.22),(533.7,-70.37,-48.61),(532.4,-70.68,-49.05),(532.5,-70.86,-49.02),(532.8,-70.9,-48.93),(533.1,-70.96,-48.83),(533.4,-70.86,-48.7),(533.6,-70.61,-48.57),(532.5,-68.06,-48.87),(532.7,-67.91,-48.79),(532.9,-67.79,-48.68),(533.4,-67.82,-48.52),(533.5,-67.99,-48.48),(533.6,-68.26,-48.46),(532.5,-68.74,-48.99),(532.7,-68.57,-48.87),(533.0,-68.58,-48.78),(532.1,-68.74,-49.15),(532.3,-69.25,-49.15),(531.9,-69.26,-49.29),(532.2,-69.77,-49.26),(531.9,-69.76,-49.35),(532.6,-70.14,-49.15),(533.0,-70.37,-48.67),(532.1,-70.18,-49.35),(532.7,-70.48,-49.17),(533.0,-70.59,-48.93),(533.3,-70.53,-48.8),(533.5,-70.31,-48.53),(532.4,-70.67,-49.31),(532.6,-70.86,-49.28),(532.8,-70.89,-49.19),(533.1,-70.95,-49.09),(533.4,-70.85,-48.96),(533.7,-70.6,-48.83),(537.3,-65.29,-38.7),(536.3,-65.82,-49.91),(533.3,-49.18,-32.36),(525.3,-55.32,-54.14),(590.0,-48.16,-53.71),(597.2,-41.22,-55.41),(599.7,-48.46,-53.29),(588.6,-45.34,-53.99),(589.4,-47.77,-48.48),(590.9,-46.22,-44.99),(594.0,-45.84,-45.41),(592.7,-44.13,-44.83),(598.8,-48.08,-46.81),(595.2,-42.65,-46.83),(596.3,-41.65,-49.82),(590.6,-45.07,-47.67),(599.2,-48.9,-59.65),(589.7,-48.46,-59.3),(591.4,-47.33,-62.48),(594.4,-46.99,-62.43),(592.6,-45.43,-63.78),(595.1,-43.74,-62.92),(596.3,-42.43,-60.37),(590.5,-46.04,-60.61),(597.1,-56.89,-61.56),(589.7,-57.12,-64.13),(593.9,-55.58,-63.24),(591.5,-55.25,-65.5),(591.5,-60.92,-60.14),(592.4,-63.26,-50.26),(589.3,-51.95,-52.73),(589.2,-57.0,-51.69),(600.6,-52.84,-51.86),(599.4,-55.93,-52.46),(602.9,-52.29,-58.23),(602.4,-53.9,-54.43),(602.0,-53.91,-60.94),(600.6,-55.72,-58.35),(601.2,-50.07,-58.33),(593.2,-65.53,-49.56),(588.9,-51.67,-46.73),(590.4,-60.06,-45.39),(590.1,-50.7,-42.65),(597.2,-52.06,-40.7),(595.6,-49.14,-43.67),(602.6,-51.54,-46.48),(601.6,-52.79,-43.33),(600.2,-54.96,-45.41),(602.3,-53.59,-49.6),(599.4,-55.8,-50.44),(595.7,-55.81,-42.39),(599.9,-52.14,-41.31),(600.2,-50.23,-43.2),(600.9,-49.38,-47.39),(598.2,-50.14,-41.02),(598.4,-49.01,-42.68),(600.1,-48.66,-46.08),(593.3,-53.91,-40.54),(591.2,-54.06,-40.6),(593.4,-61.88,-46.44),(589.4,-56.82,-40.37),(593.8,-61.11,-47.94),(594.7,-63.97,-46.83),(591.1,-59.96,-40.15),(591.6,-60.35,-43.65),(596.4,-59.87,-50.63),(596.2,-59.95,-48.01),(598.2,-57.84,-49.17),(597.1,-57.78,-50.91),(598.3,-58.02,-52.73),(594.7,-60.75,-48.83),(596.8,-62.29,-50.28),(595.3,-63.48,-47.81),(594.8,-61.08,-52.35),(595.5,-63.66,-52.05),(597.1,-59.42,-54.25),(600.5,-49.55,-60.07),(600.4,-53.55,-63.48),(601.0,-51.24,-62.36),(593.5,-62.27,-54.78),(594.9,-64.36,-53.34),(591.2,-60.67,-64.03),(589.2,-52.48,-59.37),(592.5,-60.48,-58.96),(590.6,-51.97,-62.73),(598.6,-53.03,-64.51),(596.0,-50.36,-62.87),(599.5,-51.11,-64.6),(598.9,-50.35,-63.61),(591.5,-55.29,-66.03),(602.4,-51.21,-58.26),(602.1,-50.49,-46.91),(602.8,-53.28,-51.97),(594.2,-61.16,-55.64),(591.2,-54.09,-41.15),(591.5,-55.26,-66.05),(595.8,-58.48,-43.54),(596.8,-59.02,-60.69),(591.8,-61.36,-60.3),(591.7,-60.86,-43.43),(592.3,-61.48,-45.95),(592.5,-61.87,-56.1),(593.4,-64.14,-52.17),(593.9,-65.09,-53.03),(592.5,-62.89,-52.37),(593.3,-64.04,-48.18),(593.9,-64.56,-46.78),(592.5,-62.69,-48.5),(593.0,-64.84,-49.75),(594.3,-58.22,-37.26),(591.9,-58.79,-37.35),(592.9,-54.33,-35.3),(593.1,-55.95,-34.86),(592.9,-53.88,-37.39),(596.3,-57.23,-38.35),(583.7,-49.42,-38.93),(586.2,-47.76,-36.58),(586.1,-48.91,-33.65),(584.8,-50.42,-33.09),(586.0,-53.88,-36.31),(583.9,-47.04,-38.65),(582.0,-46.89,-37.06),(581.6,-49.46,-35.26),(588.2,-45.58,-37.74),(586.7,-44.91,-39.77),(590.3,-37.71,-41.64),(591.7,-38.36,-40.3),(585.5,-44.18,-38.38),(589.3,-36.61,-39.1),(584.2,-43.43,-35.38),(583.2,-44.27,-36.37),(581.7,-46.68,-35.46),(583.1,-46.76,-33.39),(590.4,-36.94,-37.64),(585.8,-44.06,-33.99),(591.5,-37.59,-38.02),(587.2,-44.81,-34.43),(584.7,-46.94,-32.98),(586.0,-47.64,-33.85),(593.4,-35.53,-41.65),(593.9,-35.17,-40.96),(591.8,-34.1,-39.87),(593.0,-36.55,-41.77),(593.9,-36.84,-40.89),(589.9,-33.9,-38.93),(593.9,-33.47,-43.22),(593.8,-33.6,-40.71),(594.5,-33.41,-40.7),(593.4,-33.71,-44.58),(593.0,-33.92,-43.87),(593.0,-33.29,-43.24),(592.9,-33.68,-44.39),(593.4,-33.7,-42.82),(592.5,-33.52,-44.87),(592.0,-33.72,-44.15),(592.0,-33.2,-42.95),(592.3,-33.46,-42.8),(591.8,-33.39,-44.49),(591.7,-33.57,-44.01),(591.3,-33.72,-43.28),(591.2,-33.17,-42.45),(591.5,-33.45,-42.22),(591.0,-33.48,-43.71),(591.5,-32.96,-40.16),(591.7,-33.34,-40.49),(590.7,-33.27,-40.28),(591.2,-33.28,-41.11),(590.9,-33.6,-42.19),(590.5,-33.79,-41.86),(590.4,-33.21,-40.88),(590.6,-33.48,-40.79),(590.3,-33.55,-42.14),(590.3,-33.1,-39.71),(593.9,-35.44,-39.9),(593.9,-34.36,-38.41),(592.6,-34.22,-38.07),(590.9,-34.04,-38.46),(593.7,-33.15,-42.85),(593.5,-33.32,-43.7),(594.1,-33.08,-39.79),(593.9,-32.98,-41.63),(593.4,-33.07,-40.59),(593.1,-32.73,-39.94),(592.9,-32.73,-41.62),(592.6,-32.95,-42.95),(592.5,-33.1,-43.68),(592.4,-32.96,-40.44),(592.1,-32.79,-39.71),(592.0,-32.72,-40.89),(591.6,-33.04,-42.91),(591.8,-32.93,-42.25),(590.9,-32.97,-40.8),(590.9,-33.06,-41.35),(591.1,-32.83,-39.81),(591.0,-33.15,-39.05),(594.8,-34.88,-43.16),(595.8,-35.11,-44.13),(595.7,-34.82,-43.68),(594.6,-35.58,-43.23),(596.0,-35.3,-43.63),(595.3,-35.7,-42.6),(594.6,-36.1,-41.78),(595.1,-35.14,-42.02),(595.4,-35.0,-42.47),(596.0,-35.02,-43.26),(593.2,-58.14,-36.53),(593.9,-59.39,-66.89),(592.3,-58.87,-67.47),(592.0,-56.43,-69.46),(595.1,-56.88,-69.8),(595.9,-54.96,-67.35),(595.8,-58.35,-65.88),(591.2,-47.12,-67.33),(594.4,-47.06,-69.85),(593.5,-48.07,-72.57),(591.5,-48.75,-72.94),(590.2,-51.66,-69.32),(592.7,-45.83,-67.91),(591.1,-44.99,-69.57),(589.4,-46.55,-71.01),(597.2,-46.26,-69.02),(596.2,-44.93,-67.19),(603.5,-40.1,-66.67),(604.1,-41.36,-67.79),(595.5,-43.94,-68.77),(603.4,-38.87,-69.45),(594.7,-43.01,-71.95),(593.4,-43.3,-70.8),(590.9,-44.82,-71.21),(592.0,-45.6,-73.21),(604.0,-39.76,-70.77),(595.8,-44.29,-73.13),(604.4,-40.79,-70.2),(596.7,-45.46,-72.49),(593.3,-46.45,-73.53),(594.0,-47.5,-72.49),(606.7,-40.88,-66.73),(607.4,-41.15,-67.31),(607.7,-39.09,-68.17),(605.4,-40.95,-66.77),(605.5,-41.85,-67.57),(607.2,-37.46,-69.19),(609.1,-40.47,-65.28),(609.1,-40.45,-67.35),(609.5,-40.94,-67.38),(608.3,-40.2,-64.29),(608.1,-39.95,-65.2),(608.9,-39.7,-65.44),(608.1,-39.73,-64.62),(608.7,-40.2,-65.92),(608.0,-39.35,-64.2),(607.9,-39.13,-65.11),(608.7,-38.91,-65.95),(608.6,-39.3,-66.12),(608.0,-38.83,-64.67),(607.9,-38.78,-65.28),(607.8,-38.57,-66.15),(608.6,-38.3,-66.64),(608.5,-38.66,-66.91),(607.8,-38.26,-65.7),(609.0,-38.4,-67.92),(608.8,-38.71,-67.45),(608.5,-37.91,-67.61),(608.7,-38.36,-67.85),(608.1,-38.29,-67.2),(607.9,-38.07,-67.73),(608.5,-37.76,-68.23),(608.3,-38.05,-68.25),(607.9,-37.8,-67.41),(608.4,-37.52,-68.27),(607.1,-41.32,-68.22),(608.3,-40.83,-69.52),(608.0,-39.78,-69.92),(607.6,-38.37,-69.61),(609.4,-40.17,-65.52),(608.9,-40.08,-64.88),(609.7,-40.59,-68.41),(610.0,-40.36,-66.58),(609.6,-40.01,-67.52),(609.8,-39.64,-68.24),(609.8,-39.45,-66.7),(609.2,-39.3,-65.63),(608.8,-39.26,-65.07),(609.3,-39.16,-67.73),(609.3,-38.88,-68.49),(609.6,-38.78,-67.66),(608.7,-38.57,-66.02),(609.1,-38.67,-66.51),(608.9,-38.05,-67.9),(608.8,-38.05,-67.66),(609.0,-38.04,-68.27),(608.5,-38.07,-68.91),(607.7,-41.71,-64.77),(607.8,-42.58,-63.77),(608.1,-42.44,-64.15),(606.9,-41.86,-64.89),(607.7,-42.85,-64.28),(607.1,-42.47,-65.47),(606.5,-42.1,-66.44),(607.7,-42.08,-65.93),(607.9,-42.24,-65.42),(608.1,-42.74,-64.58),(594.1,-58.78,-68.25),(593.9,-55.58,-63.27),(591.5,-55.26,-65.52),(596.6,-36.88,-56.31),(595.0,-36.35,-56.05),(584.7,-40.76,-54.59),(586.5,-34.77,-55.57),(589.6,-33.78,-55.71),(586.3,-43.64,-54.09),(593.1,-42.42,-65.95),(590.5,-44.0,-63.75),(594.8,-39.86,-64.45),(595.7,-38.03,-60.49),(586.3,-44.13,-59.49),(602.4,-16.23,-73.42),(600.4,-20.39,-71.5),(598.6,-15.69,-69.8),(599.4,-20.03,-68.64),(600.5,-19.75,-65.01),(600.0,-15.41,-66.48),(603.5,-15.39,-65.29),(602.4,-20.7,-73.18),(602.4,-19.77,-63.72),(605.3,-20.08,-64.6),(606.3,-15.95,-69.64),(606.5,-20.59,-68.58),(605.2,-20.81,-71.83),(601.3,-24.58,-72.7),(601.4,-23.39,-62.01),(603.7,-25.15,-63.45),(604.8,-26.4,-67.37),(603.6,-25.92,-69.98),(597.0,-32.7,-71.53),(594.0,-30.51,-70.61),(593.8,-27.76,-67.39),(594.4,-27.15,-62.43),(597.3,-29.93,-59.23),(600.0,-31.96,-60.58),(600.9,-33.61,-64.43),(599.4,-33.75,-68.35),(591.5,-40.6,-67.61),(589.7,-35.65,-70.36),(590.4,-32.06,-66.45),(588.6,-33.19,-57.83),(591.7,-31.88,-58.37),(588.2,-41.59,-66.77),(588.4,-38.68,-69.05),(583.5,-39.84,-64.33),(584.7,-41.34,-63.46),(583.9,-42.2,-56.25),(582.9,-40.47,-57.31),(584.0,-38.99,-54.93),(585.3,-37.99,-54.02),(582.7,-38.14,-63.58),(586.1,-33.2,-64.32),(582.2,-37.65,-57.71),(587.8,-32.97,-60.68),(583.8,-36.6,-55.41),(586.4,-36.17,-53.38),(602.8,-10.53,-75.49),(600.9,-10.13,-74.3),(599.9,-9.829,-70.98),(600.9,-9.516,-67.74),(602.8,-9.674,-66.49),(604.8,-9.847,-67.75),(605.5,-10.23,-70.68),(604.7,-10.55,-74.09),(602.8,-3.627,-76.0),(601.1,-3.473,-75.2),(600.3,-3.212,-72.51),(601.1,-2.991,-69.87),(602.8,-2.957,-68.73),(604.6,-3.158,-69.89),(605.2,-3.614,-72.22),(604.5,-3.724,-74.97),(603.7,1.788,-75.85),(602.1,1.496,-75.68),(601.4,1.582,-73.56),(602.1,1.824,-72.25),(603.9,2.176,-71.72),(605.4,2.363,-72.52),(605.9,2.298,-74.27),(605.4,2.042,-75.55),(607.3,3.171,-76.45),(608.1,3.627,-74.79),(610.9,4.576,-75.99),(608.3,4.596,-77.1),(607.4,3.519,-73.06),(608.5,4.933,-72.74),(611.1,4.759,-73.9),(605.4,3.621,-71.53),(601.2,3.146,-71.22),(601.2,4.093,-71.92),(602.8,4.059,-71.09),(600.5,2.941,-73.86),(600.6,3.912,-74.11),(600.9,2.648,-76.23),(600.9,3.744,-76.34),(605.2,2.727,-76.84),(602.6,3.547,-77.05),(608.4,5.28,-77.15),(611.5,5.474,-75.07),(608.4,5.676,-73.17),(601.1,1.966,-75.24),(601.2,2.283,-71.82),(601.3,5.853,-74.08),(601.3,5.753,-75.17),(601.9,5.83,-74.13),(601.9,5.729,-75.22),(589.6,-33.79,-58.04),(592.8,-34.81,-57.68),(593.9,-40.79,-44.17),(591.1,-42.62,-45.24),(595.4,-38.56,-46.95),(596.0,-37.37,-51.66),(586.7,-43.33,-48.68),(601.4,-21.27,-49.52),(604.8,-24.06,-50.62),(600.1,-24.75,-51.8),(604.1,-25.2,-53.06),(604.2,-24.83,-56.99),(600.1,-24.07,-55.52),(600.8,-21.42,-57.87),(605.9,-22.45,-49.63),(604.9,-23.54,-58.93),(606.4,-21.38,-59.05),(602.0,-18.65,-54.55),(607.5,-20.03,-55.58),(607.2,-20.57,-51.95),(606.9,-24.38,-48.74),(605.4,-24.98,-59.35),(607.9,-26.46,-57.88),(609.5,-27.16,-53.93),(608.7,-26.22,-51.34),(601.1,-31.41,-45.06),(598.7,-28.79,-46.22),(598.7,-26.53,-50.52),(598.7,-26.75,-55.67),(600.3,-30.4,-57.75),(602.3,-32.89,-56.27),(603.6,-34.04,-52.33),(602.6,-33.34,-48.17),(591.8,-36.93,-42.83),(593.0,-32.92,-42.81),(584.9,-31.74,-48.23),(594.0,-31.13,-56.41),(589.1,-39.82,-43.03),(587.8,-36.98,-42.62),(584.2,-38.43,-45.44),(585.4,-40.02,-45.82),(584.0,-41.9,-52.28),(583.1,-40.07,-51.85),(585.2,-38.17,-56.42),(583.3,-36.88,-46.77),(582.8,-35.28,-49.69),(582.4,-37.27,-52.57),(584.3,-34.75,-53.29),(583.8,-36.58,-55.11),(586.2,-36.51,-57.96),(594.6,-19.77,-48.34),(593.9,-21.44,-48.89),(593.5,-22.62,-51.84),(593.4,-22.27,-55.34),(593.9,-20.9,-57.17),(594.4,-19.1,-56.62),(594.8,-18.15,-53.97),(595.0,-18.41,-50.34),(585.9,-18.9,-48.59),(585.6,-20.38,-48.83),(585.3,-21.34,-51.22),(585.2,-21.05,-54.06),(585.4,-19.81,-55.73),(585.8,-18.19,-55.18),(586.4,-17.43,-53.06),(586.3,-17.63,-50.14),(579.2,-17.66,-49.73),(579.4,-18.97,-49.32),(579.4,-19.81,-51.37),(579.3,-19.37,-52.72),(579.1,-17.91,-53.9),(578.9,-16.62,-53.61),(578.9,-15.97,-51.97),(579.0,-16.22,-50.62),(577.6,-14.54,-50.38),(577.3,-14.08,-52.31),(576.2,-11.62,-52.06),(576.0,-13.64,-50.32),(577.5,-14.82,-53.8),(576.0,-13.92,-54.7),(576.2,-11.71,-54.17),(577.5,-16.66,-54.78),(577.8,-20.23,-53.88),(576.7,-20.13,-53.4),(576.9,-18.86,-54.63),(577.8,-20.5,-51.1),(576.7,-20.39,-51.08),(577.9,-19.94,-48.84),(576.7,-19.85,-48.95),(578.0,-16.28,-49.36),(577.0,-18.4,-48.66),(575.1,-13.56,-50.44),(575.3,-11.23,-53.3),(575.0,-13.96,-54.41),(578.8,-19.89,-49.71),(578.7,-20.13,-53.16),(574.3,-19.79,-51.74),(574.3,-19.69,-50.64),(574.3,-19.25,-51.85),(574.4,-19.15,-50.76),(601.9,-67.14,-50.09),(597.4,-67.13,-43.52),(596.3,-73.49,-48.22),(599.0,-61.42,-51.1),(601.5,-67.2,-48.83),(600.8,-67.84,-44.52),(599.4,-67.32,-44.02),(602.0,-70.06,-49.44),(600.5,-71.98,-48.91),(597.8,-73.09,-48.43),(602.4,-64.63,-50.69),(601.3,-62.89,-50.97),(600.8,-61.81,-51.17),(594.0,-66.73,-45.0),(595.2,-68.56,-43.57),(590.3,-70.94,-48.26),(591.4,-72.59,-47.99),(594.7,-73.7,-48.03),(591.5,-66.2,-49.41),(593.5,-64.18,-50.02),(595.7,-63.05,-50.46),(597.2,-67.99,-43.15),(595.8,-71.97,-43.59),(596.2,-73.07,-45.45),(598.4,-62.35,-47.2),(598.0,-63.29,-45.66),(597.6,-65.47,-44.0),(601.2,-70.6,-46.78),(599.4,-68.87,-43.91),(597.8,-72.31,-45.35),(602.1,-64.7,-49.82),(600.1,-62.34,-48.92),(599.6,-64.93,-45.31),(591.5,-71.53,-44.87),(593.2,-72.89,-44.53),(594.2,-70.99,-42.76),(596.1,-66.06,-44.35),(596.5,-63.27,-46.65),(599.3,-72.64,-48.66),(602.2,-68.64,-49.79),(602.0,-66.62,-50.21),(602.0,-66.3,-50.29),(602.2,-65.53,-50.47),(601.4,-65.53,-49.61),(601.4,-66.11,-49.65),(602.5,-64.86,-50.64),(602.0,-64.49,-50.68),(601.6,-64.4,-50.67),(601.9,-63.85,-50.82),(601.3,-64.39,-49.48),(601.4,-63.75,-49.05),(601.1,-66.06,-49.28),(601.0,-64.78,-48.96),(600.3,-63.48,-47.64),(599.4,-63.05,-46.94),(599.9,-61.31,-49.78),(601.4,-63.42,-50.87),(600.8,-62.76,-50.96),(600.8,-62.2,-51.08),(600.4,-61.39,-51.23),(597.0,-62.2,-50.75),(600.6,-62.99,-49.19),(601.9,-63.66,-50.86),(601.5,-63.13,-50.94),(601.2,-63.34,-49.02),(601.7,-63.91,-50.0),(601.1,-64.75,-47.21),(601.7,-65.1,-49.51),(602.3,-65.09,-50.05),(601.0,-63.06,-49.17),(601.7,-67.67,-45.98),(601.0,-66.86,-49.21),(599.7,-66.55,-44.34),(601.9,-68.19,-46.06),(601.1,-66.58,-47.86),(601.4,-66.6,-49.6),(601.0,-67.06,-45.68),(600.8,-67.34,-44.63),(601.1,-67.37,-47.98),(602.0,-67.61,-47.75),(600.4,-69.94,-44.85),(600.0,-71.53,-45.88),(600.1,-64.02,-46.4),(595.0,-63.82,-50.23),(602.2,-67.79,-49.98),(599.9,-62.11,-48.51),(601.4,-66.96,-49.54),(602.2,-67.41,-48.96),(602.3,-67.89,-48.44),(600.3,-66.7,-45.52),(600.9,-65.76,-48.07),(600.1,-65.96,-45.5),(601.2,-64.26,-48.76),(589.4,-67.78,-48.88),(590.4,-68.78,-45.14),(592.9,-73.38,-47.94),(590.6,-66.48,-48.46),(590.1,-66.93,-48.35),(589.5,-66.85,-49.09),(589.1,-66.62,-49.11),(588.0,-66.35,-49.07),(587.0,-65.66,-49.14),(586.0,-64.05,-49.41),(583.8,-62.67,-49.53),(583.9,-61.69,-49.74),(584.0,-59.15,-50.32),(584.8,-57.99,-50.67),(586.9,-57.56,-50.87),(587.5,-59.19,-50.61),(589.6,-60.81,-50.43),(590.8,-63.4,-49.96),(589.9,-65.19,-49.49),(590.7,-65.26,-49.54),(591.0,-65.51,-49.52),(585.7,-61.42,-48.9),(587.7,-62.38,-48.85),(590.4,-66.05,-48.59),(587.4,-60.67,-49.49),(586.2,-59.07,-49.74),(588.2,-63.64,-48.92),(588.4,-64.96,-48.83),(589.6,-65.72,-48.48),(585.5,-59.92,-49.54),(588.8,-65.9,-48.53),(589.4,-66.2,-48.5),(589.9,-66.49,-48.47),(594.2,-66.62,-43.99),(594.3,-66.45,-44.17),(594.5,-66.35,-44.39),(594.7,-66.37,-44.5),(594.9,-66.39,-44.65),(595.1,-66.58,-44.68),(595.2,-66.81,-44.51),(594.2,-67.23,-43.61),(594.4,-67.08,-43.86),(594.6,-67.1,-44.01),(594.7,-67.53,-44.26),(594.9,-67.29,-44.49),(595.2,-67.15,-44.42),(593.8,-67.21,-43.32),(594.0,-67.25,-43.46),(594.2,-67.9,-43.63),(595.0,-67.76,-44.11),(595.1,-67.41,-44.15),(593.7,-67.7,-42.95),(594.2,-68.17,-43.48),(594.7,-68.36,-43.75),(595.1,-68.27,-43.74),(593.7,-68.17,-42.72),(594.0,-68.2,-42.86),(594.4,-68.57,-42.95),(594.7,-68.85,-43.42),(594.8,-68.75,-43.6),(593.9,-68.59,-42.61),(594.8,-69.03,-43.1),(595.1,-68.99,-43.34),(595.1,-68.83,-43.66),(595.4,-68.79,-43.5),(594.2,-69.06,-42.53),(594.4,-69.25,-42.54),(594.6,-69.29,-42.69),(594.9,-69.36,-42.84),(595.2,-69.28,-43.09),(595.4,-69.06,-43.38),(594.3,-66.58,-43.76),(594.4,-66.41,-43.94),(594.6,-66.3,-44.16),(595.0,-66.35,-44.42),(595.1,-66.52,-44.44),(594.2,-67.18,-43.38),(594.4,-67.03,-43.62),(594.7,-67.06,-43.78),(593.8,-67.17,-43.09),(594.0,-67.66,-42.95),(594.3,-68.13,-43.24),(593.7,-67.66,-42.72),(593.8,-68.13,-42.49),(594.0,-68.15,-42.63),(594.4,-68.52,-42.71),(594.8,-68.81,-43.19),(594.0,-68.54,-42.37),(594.6,-68.86,-42.59),(594.8,-68.99,-42.87),(595.1,-68.95,-43.1),(594.3,-69.02,-42.3),(594.5,-69.2,-42.31),(594.7,-69.25,-42.45),(595.0,-69.31,-42.6),(595.3,-69.24,-42.86),(595.5,-69.01,-43.14),(596.9,-68.05,-55.65),(601.4,-67.38,-51.21),(600.3,-68.63,-54.95),(599.0,-68.19,-55.43),(593.7,-67.04,-53.84),(594.7,-69.24,-54.61),(596.9,-69.02,-55.59),(595.4,-72.7,-53.25),(595.9,-73.38,-51.34),(598.0,-62.69,-54.21),(597.6,-64.04,-55.36),(597.1,-66.37,-55.94),(601.4,-70.95,-52.08),(598.8,-70.07,-54.98),(597.6,-72.7,-51.76),(602.1,-64.82,-51.45),(599.9,-62.65,-52.98),(599.2,-65.68,-55.25),(591.2,-72.03,-51.46),(592.9,-73.41,-51.48),(593.7,-71.95,-54.37),(595.7,-66.88,-55.09),(596.2,-63.84,-54.16),(601.4,-65.65,-51.17),(601.3,-66.2,-50.87),(601.2,-64.56,-51.76),(601.3,-64.01,-52.47),(601.0,-66.21,-51.19),(600.9,-65.01,-52.05),(600.0,-63.94,-53.76),(599.0,-63.32,-54.36),(599.8,-61.53,-52.78),(600.5,-63.24,-52.53),(601.0,-63.62,-52.64),(601.7,-64.03,-51.55),(600.9,-65.26,-53.83),(601.6,-65.25,-51.49),(602.3,-65.17,-51.09),(600.9,-63.32,-52.59),(601.3,-68.26,-53.78),(600.9,-66.98,-50.91),(599.2,-67.39,-55.5),(601.6,-68.75,-53.52),(600.9,-66.94,-52.29),(601.3,-66.69,-50.71),(600.7,-67.71,-54.1),(600.3,-68.09,-54.95),(601.0,-67.66,-51.89),(601.8,-67.94,-52.16),(599.9,-70.7,-53.51),(599.8,-71.89,-51.95),(599.8,-64.67,-54.46),(599.6,-62.28,-53.36),(601.4,-67.04,-50.62),(602.1,-67.58,-51.11),(602.1,-68.11,-51.42),(599.8,-67.43,-54.25),(600.7,-66.13,-52.31),(599.8,-66.66,-54.71),(601.1,-64.66,-52.48),(590.1,-69.31,-52.21),(590.5,-66.6,-50.04),(590.0,-67.04,-49.87),(586.1,-62.75,-50.43),(587.7,-63.69,-50.35),(590.3,-66.16,-50.07),(587.9,-61.28,-51.17),(586.3,-59.14,-51.3),(588.4,-64.86,-50.0),(589.5,-65.81,-50.06),(585.1,-60.71,-50.99),(588.8,-66.01,-49.93),(589.3,-66.3,-49.92),(589.8,-66.6,-49.9),(593.8,-67.45,-54.88),(593.9,-67.26,-54.8),(594.1,-67.13,-54.67),(594.2,-67.13,-54.59),(594.5,-67.14,-54.47),(594.7,-67.3,-54.4),(594.8,-67.57,-54.35),(593.7,-68.09,-54.98),(593.9,-67.91,-54.85),(594.2,-67.91,-54.73),(594.3,-68.29,-54.32),(594.5,-68.03,-54.22),(594.8,-67.91,-54.48),(593.3,-68.11,-55.19),(593.5,-68.14,-55.08),(593.7,-68.74,-54.67),(594.6,-68.53,-54.4),(594.6,-68.2,-54.55),(593.1,-68.64,-55.32),(593.7,-69.02,-54.7),(594.3,-69.17,-54.45),(593.2,-69.13,-55.35),(593.4,-69.14,-55.24),(593.9,-69.49,-55.08),(594.2,-69.7,-54.55),(594.4,-69.57,-54.45),(593.4,-69.55,-55.31),(594.3,-69.92,-54.79),(594.6,-69.85,-54.63),(594.7,-69.63,-54.31),(595.0,-69.67,-54.66),(593.7,-70.03,-55.23),(593.9,-70.21,-55.17),(594.1,-70.23,-55.05),(594.4,-70.28,-54.93),(594.7,-70.17,-54.77),(594.9,-69.91,-54.63),(593.7,-67.4,-55.14),(593.9,-67.25,-55.05),(594.1,-67.12,-54.92),(594.5,-67.13,-54.72),(594.7,-67.3,-54.65),(594.8,-67.56,-54.61),(593.7,-68.08,-55.23),(594.0,-67.9,-55.1),(594.2,-67.91,-54.98),(593.3,-68.11,-55.44),(593.5,-68.6,-55.4),(593.2,-68.63,-55.57),(593.5,-69.13,-55.5),(593.3,-69.12,-55.61),(593.9,-69.48,-55.33),(594.3,-69.69,-54.8),(593.5,-69.54,-55.57),(594.0,-69.82,-55.32),(594.3,-69.91,-55.05),(594.7,-69.84,-54.89),(594.8,-69.61,-54.61),(593.8,-70.02,-55.49),(593.9,-70.2,-55.43),(594.2,-70.22,-55.31),(594.5,-70.27,-55.18),(594.8,-70.16,-55.02),(595.0,-69.9,-54.88),(597.8,-64.34,-44.63),(597.4,-65.05,-55.89),(586.6,-52.88,-40.0),(592.1,-51.04,-65.59),(653.7,-55.79,-60.33),(661.0,-48.96,-62.18),(663.4,-56.27,-60.48),(652.3,-52.93,-60.42),(653.2,-55.46,-55.06),(654.9,-53.98,-51.6),(658.0,-53.66,-52.18),(656.8,-51.92,-51.47),(662.7,-55.97,-53.94),(659.2,-50.47,-53.55),(660.3,-49.45,-56.56),(654.5,-52.79,-54.21),(662.7,-56.62,-66.81),(653.2,-56.01,-65.91),(654.9,-54.87,-69.15),(657.9,-54.58,-69.25),(656.2,-52.98,-70.44),(658.7,-51.34,-69.66),(660.0,-50.09,-67.13),(654.1,-53.59,-67.17),(660.4,-64.54,-68.9),(652.2,-65.87,-68.59),(657.2,-63.15,-70.35),(653.3,-64.14,-70.45),(654.4,-68.9,-64.88),(655.8,-70.97,-57.58),(652.9,-59.58,-59.45),(652.8,-64.64,-58.59),(664.2,-60.68,-59.25),(662.9,-63.75,-59.9),(666.4,-60.09,-65.72),(666.0,-61.74,-61.97),(665.4,-61.66,-68.45),(663.9,-63.48,-65.85),(664.7,-57.85,-65.65),(656.5,-73.26,-57.01),(652.7,-59.37,-53.43),(654.0,-67.8,-52.48),(654.0,-58.47,-49.38),(661.1,-59.99,-47.88),(659.5,-57.0,-50.65),(666.4,-59.49,-53.95),(665.5,-60.77,-50.79),(664.3,-62.44,-52.59),(666.0,-61.5,-57.12),(663.0,-63.64,-57.88),(660.1,-62.97,-48.71),(663.8,-60.11,-48.65),(664.1,-58.18,-50.49),(664.8,-57.29,-54.68),(662.2,-58.09,-48.19),(662.4,-56.94,-49.82),(664.0,-56.58,-53.3),(657.2,-61.77,-47.57),(655.1,-61.88,-47.52),(657.0,-69.66,-53.77),(653.9,-63.65,-45.55),(657.5,-68.46,-53.02),(658.1,-71.77,-54.31),(655.5,-66.81,-45.05),(655.7,-67.4,-48.53),(659.8,-67.65,-58.05),(660.0,-67.4,-53.7),(661.9,-65.43,-55.52),(660.6,-65.57,-58.29),(661.8,-65.81,-60.18),(658.2,-68.53,-56.19),(660.3,-70.08,-57.81),(658.7,-71.28,-55.3),(658.2,-68.8,-59.73),(658.8,-71.4,-59.56),(660.5,-67.16,-61.69),(664.0,-57.29,-67.33),(663.7,-61.24,-70.88),(664.4,-58.95,-69.71),(656.9,-69.94,-62.12),(658.2,-72.07,-60.84),(653.8,-68.98,-68.66),(652.7,-60.02,-66.11),(655.3,-68.38,-63.79),(654.0,-59.49,-69.52),(661.3,-61.25,-71.43),(659.4,-57.98,-69.9),(662.4,-59.31,-71.79),(662.3,-58.01,-70.81),(653.4,-64.18,-70.99),(665.9,-59.01,-65.69),(665.9,-58.43,-54.31),(666.4,-61.17,-59.51),(657.5,-68.83,-62.98),(655.1,-61.9,-48.07),(653.3,-64.16,-71.01),(660.0,-65.69,-49.44),(659.5,-67.12,-66.46),(654.6,-69.35,-65.01),(655.8,-67.9,-48.24),(655.8,-69.25,-53.2),(655.8,-69.51,-63.36),(656.7,-71.84,-59.58),(657.2,-72.79,-60.5),(655.9,-70.57,-59.68),(656.8,-71.8,-55.58),(657.4,-72.35,-54.24),(655.9,-70.42,-55.81),(656.4,-72.57,-57.16),(659.0,-65.02,-43.03),(656.4,-65.52,-42.95),(656.9,-62.25,-42.33),(657.9,-62.73,-40.69),(657.7,-60.69,-43.29),(660.9,-64.17,-44.6),(648.7,-55.95,-44.75),(651.3,-54.37,-42.48),(651.2,-55.47,-39.52),(649.9,-56.93,-38.91),(650.9,-60.45,-42.05),(649.1,-53.61,-44.55),(647.2,-53.34,-42.94),(646.6,-55.88,-41.06),(653.4,-52.37,-43.73),(652.0,-51.64,-45.77),(656.2,-44.69,-47.92),(657.5,-45.41,-46.58),(650.8,-50.84,-44.39),(655.3,-43.5,-45.41),(649.6,-49.98,-41.4),(648.6,-50.78,-42.35),(646.9,-53.09,-41.34),(648.3,-53.23,-39.28),(656.4,-43.88,-43.95),(651.2,-50.69,-40.01),(657.4,-44.6,-44.33),(652.6,-51.52,-40.44),(649.9,-53.49,-38.89),(651.1,-54.26,-39.75),(659.5,-42.81,-48.06),(660.1,-42.5,-47.4),(658.2,-41.21,-46.34),(658.9,-43.78,-48.12),(659.9,-44.15,-47.24),(656.2,-40.8,-45.4),(660.2,-40.86,-49.75),(660.1,-40.92,-47.22),(660.9,-40.79,-47.23),(659.8,-41.09,-51.08),(659.3,-41.23,-50.35),(659.4,-40.59,-49.77),(659.2,-40.99,-50.89),(659.7,-41.03,-49.33),(658.8,-40.81,-51.37),(658.4,-40.95,-50.63),(658.4,-40.4,-49.47),(658.7,-40.69,-49.31),(658.2,-40.62,-50.99),(658.0,-40.76,-50.5),(657.6,-40.86,-49.76),(657.6,-40.28,-48.96),(657.9,-40.59,-48.72),(657.4,-40.61,-50.2),(657.9,-40.05,-46.69),(658.1,-40.46,-47.0),(657.2,-40.29,-46.79),(657.6,-40.36,-47.61),(657.3,-40.68,-48.66),(656.9,-40.82,-48.32),(656.8,-40.22,-47.38),(657.1,-40.5,-47.27),(656.7,-40.58,-48.61),(656.8,-40.06,-46.22),(660.1,-42.75,-46.32),(660.2,-41.65,-44.88),(659.0,-41.38,-44.54),(657.3,-41.04,-44.93),(660.1,-40.51,-49.4),(659.9,-40.68,-50.23),(660.6,-40.42,-46.34),(660.4,-40.33,-48.19),(659.9,-40.35,-47.14),(659.6,-39.97,-46.5),(659.4,-39.99,-48.19),(659.1,-40.21,-49.49),(658.9,-40.37,-50.21),(658.9,-40.15,-46.98),(658.6,-39.94,-46.25),(658.5,-39.88,-47.44),(658.1,-40.21,-49.44),(658.2,-40.1,-48.79),(657.4,-40.03,-47.33),(657.3,-40.13,-47.87),(657.6,-39.88,-46.34),(657.4,-40.17,-45.57),(660.9,-42.33,-49.62),(661.9,-42.67,-50.58),(661.9,-42.37,-50.15),(660.7,-43.01,-49.65),(662.1,-42.87,-50.08),(661.4,-43.18,-49.01),(660.6,-43.5,-48.17),(661.2,-42.6,-48.46),(661.6,-42.5,-48.92),(662.2,-42.59,-49.72),(657.8,-64.94,-42.23),(656.3,-67.84,-72.07),(654.6,-67.52,-72.29),(653.7,-65.38,-74.39),(656.7,-65.38,-75.52),(657.4,-63.21,-73.53),(658.2,-66.6,-71.63),(650.7,-56.36,-72.65),(653.5,-55.7,-75.8),(652.7,-57.03,-78.26),(650.9,-58.11,-78.18),(650.7,-61.07,-74.18),(651.6,-54.67,-73.63),(649.6,-54.39,-74.93),(648.5,-56.32,-75.94),(655.9,-53.9,-75.75),(654.6,-52.82,-73.78),(659.4,-46.14,-75.24),(660.4,-47.13,-76.49),(653.4,-52.16,-75.22),(658.4,-45.2,-77.98),(652.0,-51.65,-78.2),(651.0,-52.22,-76.76),(649.2,-54.33,-76.53),(650.3,-54.87,-78.71),(659.2,-45.87,-79.42),(653.4,-52.61,-79.56),(660.1,-46.63,-78.95),(654.7,-53.44,-79.09),(651.9,-55.35,-79.29),(653.0,-56.11,-78.37),(663.0,-45.02,-76.36),(663.6,-44.92,-77.17),(662.0,-43.36,-78.19),(662.1,-45.87,-75.88),(662.8,-46.5,-76.71),(660.2,-42.6,-79.03),(664.5,-43.1,-75.98),(664.1,-43.44,-77.92),(664.8,-43.54,-78.16),(664.0,-43.1,-74.61),(663.5,-43.18,-75.31),(663.8,-42.63,-76.04),(663.5,-42.88,-74.83),(664.0,-43.17,-76.36),(663.2,-42.58,-74.4),(662.7,-42.66,-75.11),(662.9,-42.24,-76.4),(663.1,-42.61,-76.48),(662.7,-42.28,-74.83),(662.4,-42.41,-75.3),(662.0,-42.46,-76.02),(662.2,-41.98,-76.95),(662.4,-42.35,-77.1),(661.9,-42.14,-75.64),(662.3,-42.11,-78.49),(662.4,-42.42,-77.92),(661.5,-42.06,-77.97),(662.1,-42.17,-78.14),(661.8,-42.3,-77.14),(661.3,-42.36,-77.46),(661.4,-41.88,-78.38),(661.5,-42.21,-78.28),(661.2,-42.06,-77.23),(661.1,-41.91,-78.58),(663.3,-45.27,-77.99),(663.6,-44.42,-79.68),(662.5,-43.89,-79.98),(661.1,-43.13,-79.52),(664.5,-42.75,-76.42),(664.2,-42.8,-75.56),(664.5,-43.35,-79.19),(664.8,-42.79,-77.73),(664.0,-42.89,-78.32),(663.8,-42.59,-79.12),(664.0,-42.2,-77.79),(663.6,-42.23,-76.42),(663.5,-42.28,-75.67),(663.1,-42.45,-78.42),(662.8,-42.35,-79.14),(663.0,-42.0,-78.51),(662.7,-41.98,-76.49),(662.9,-41.97,-77.15),(662.0,-41.84,-78.36),(661.9,-41.86,-78.01),(661.9,-41.92,-78.81),(661.5,-42.27,-79.25),(664.5,-44.82,-74.91),(665.4,-45.29,-73.95),(665.5,-45.04,-74.46),(664.1,-45.41,-74.69),(665.6,-45.57,-74.42),(664.7,-45.78,-75.32),(663.8,-45.98,-76.02),(664.7,-45.23,-76.01),(665.0,-45.17,-75.6),(665.7,-45.34,-74.85),(656.3,-67.28,-73.54),(657.2,-63.15,-70.37),(653.3,-64.14,-70.47),(660.6,-44.6,-62.89),(657.8,-42.05,-63.01),(648.5,-48.28,-60.64),(650.6,-42.32,-61.5),(653.6,-41.38,-61.78),(650.1,-51.2,-60.34),(656.7,-49.94,-72.52),(654.0,-51.51,-70.23),(658.5,-47.44,-71.02),(659.5,-45.68,-67.05),(650.0,-51.62,-65.76),(649.1,-24.23,-77.67),(652.9,-27.19,-76.72),(647.8,-27.08,-73.58),(652.4,-27.86,-73.7),(653.0,-26.9,-70.17),(648.4,-25.86,-70.38),(649.6,-23.04,-69.55),(653.8,-25.84,-78.66),(654.0,-25.39,-69.1),(655.4,-23.34,-70.34),(650.5,-21.0,-74.26),(656.0,-22.6,-74.53),(655.3,-23.69,-77.66),(656.1,-28.65,-78.8),(656.0,-27.76,-68.03),(659.0,-28.19,-69.82),(660.5,-28.72,-73.94),(659.1,-28.82,-76.4),(656.4,-37.51,-77.99),(652.8,-36.54,-76.46),(651.4,-34.2,-73.01),(652.0,-33.49,-68.1),(656.2,-35.01,-65.49),(659.6,-35.89,-67.37),(661.0,-37.04,-71.52),(659.3,-37.68,-75.27),(655.0,-46.87,-74.63),(651.0,-42.76,-75.96),(650.5,-39.29,-71.83),(650.4,-41.22,-62.91),(652.4,-38.84,-64.03),(651.8,-49.01,-73.04),(651.1,-46.0,-74.82),(647.2,-47.21,-70.27),(648.4,-48.74,-69.52),(647.7,-49.68,-62.31),(646.7,-47.93,-63.24),(648.0,-46.49,-60.88),(649.3,-45.54,-60.0),(646.5,-45.51,-69.42),(647.4,-41.86,-68.74),(646.1,-45.09,-63.5),(649.3,-41.16,-65.56),(647.8,-44.1,-61.25),(650.4,-43.74,-59.36),(642.6,-22.23,-78.06),(641.8,-23.67,-76.59),(641.6,-24.3,-73.15),(641.9,-23.42,-69.96),(642.8,-21.89,-68.97),(643.4,-20.31,-70.45),(643.7,-19.86,-73.51),(643.3,-20.67,-76.87),(634.6,-20.33,-76.46),(634.1,-21.66,-75.47),(634.0,-22.18,-72.69),(634.2,-21.47,-70.1),(634.8,-20.06,-69.13),(635.3,-18.65,-70.49),(635.7,-18.31,-72.98),(635.3,-18.93,-75.65),(628.7,-18.1,-74.83),(628.6,-19.46,-74.59),(628.6,-19.97,-72.41),(628.7,-19.32,-71.12),(628.8,-17.76,-70.69),(628.9,-16.5,-71.57),(628.9,-16.14,-73.35),(628.9,-16.63,-74.63),(628.0,-14.79,-75.43),(627.8,-14.01,-73.75),(627.3,-11.51,-74.95),(626.5,-13.63,-75.83),(627.9,-14.56,-72.0),(626.6,-13.31,-71.46),(627.3,-11.31,-72.87),(627.5,-16.17,-70.29),(627.0,-19.78,-69.72),(625.9,-19.54,-70.19),(626.4,-18.19,-69.52),(626.8,-20.4,-72.32),(625.7,-20.1,-72.34),(626.9,-20.17,-74.7),(625.8,-19.88,-74.62),(627.9,-16.64,-75.72),(626.4,-18.57,-75.51),(625.8,-13.4,-75.73),(626.5,-10.81,-73.89),(625.7,-13.24,-71.71),(627.9,-20.16,-73.94),(628.0,-19.94,-70.49),(623.7,-19.06,-71.95),(623.7,-19.12,-73.05),(623.9,-18.54,-72.06),(623.9,-18.59,-73.16),(651.6,-41.43,-63.45),(654.9,-41.3,-63.91),(658.0,-48.62,-50.75),(655.2,-50.39,-51.73),(659.6,-46.38,-53.53),(660.0,-45.15,-58.22),(650.7,-50.96,-54.94),(668.6,-23.05,-57.52),(666.9,-27.39,-57.53),(664.4,-23.34,-60.15),(665.5,-27.55,-60.11),(666.1,-27.82,-63.96),(665.4,-23.55,-63.79),(668.6,-23.55,-65.88),(669.0,-27.35,-56.32),(667.9,-27.98,-65.71),(670.8,-28.05,-65.52),(672.0,-23.22,-62.29),(672.6,-27.86,-61.86),(671.7,-27.58,-58.34),(668.1,-30.89,-54.79),(666.9,-31.39,-65.49),(669.2,-33.02,-63.89),(670.9,-33.7,-59.9),(670.0,-32.76,-57.34),(663.3,-38.47,-51.06),(660.5,-36.21,-52.19),(659.9,-34.02,-56.44),(659.9,-34.23,-61.58),(662.1,-37.63,-63.71),(664.7,-39.81,-62.27),(666.1,-40.77,-58.36),(665.1,-40.17,-54.19),(656.1,-44.74,-49.15),(655.8,-40.83,-48.9),(649.2,-39.36,-53.96),(656.4,-39.09,-62.42),(653.3,-47.57,-49.3),(652.1,-44.72,-48.72),(648.4,-46.06,-51.38),(649.5,-47.67,-51.89),(648.0,-49.44,-58.33),(647.1,-47.6,-57.78),(649.1,-45.68,-62.4),(647.5,-44.49,-52.61),(647.0,-42.84,-55.43),(646.4,-44.78,-58.36),(648.4,-42.28,-59.1),(647.8,-44.08,-60.96),(650.1,-44.02,-63.94),(668.4,-17.28,-58.26),(666.3,-17.23,-59.04),(665.0,-17.55,-62.07),(665.5,-17.73,-65.52),(667.3,-17.96,-67.16),(669.5,-17.79,-66.44),(670.6,-17.62,-63.69),(670.1,-17.4,-60.1),(667.3,-10.57,-60.89),(665.5,-10.72,-61.26),(664.5,-10.99,-63.72),(664.9,-11.15,-66.52),(666.4,-11.15,-68.08),(668.4,-10.97,-67.38),(669.3,-10.97,-65.12),(668.9,-10.67,-62.28),(666.5,-4.949,-63.72),(665.3,-5.764,-63.28),(664.5,-6.216,-65.32),(664.9,-6.072,-66.68),(666.4,-5.251,-67.87),(667.6,-4.392,-67.6),(668.2,-3.924,-65.95),(667.9,-4.105,-64.6),(668.8,-2.205,-64.52),(669.2,-1.841,-66.46),(671.1,0.2403,-66.34),(668.8,-0.5606,-64.7),(668.7,-2.447,-67.94),(668.8,-0.9292,-69.06),(671.1,0.1035,-68.44),(666.9,-3.437,-68.99),(663.4,-5.479,-68.1),(662.9,-4.62,-67.82),(664.3,-4.181,-68.98),(663.0,-5.404,-65.34),(662.5,-4.61,-65.51),(663.5,-5.128,-63.07),(663.0,-4.26,-63.38),(667.3,-3.372,-63.5),(664.6,-3.688,-63.02),(668.5,0.07448,-64.95),(671.1,1.032,-67.71),(668.2,-0.2569,-68.93),(664.1,-5.735,-63.79),(663.9,-6.006,-67.22),(661.9,-2.648,-66.56),(661.9,-2.559,-65.47),(662.4,-2.417,-66.64),(662.5,-2.327,-65.55),(665.2,-75.03,-58.09),(660.9,-75.02,-51.27),(659.5,-81.29,-56.14),(662.4,-69.24,-58.72),(664.8,-75.1,-56.81),(664.2,-75.78,-52.49),(662.9,-75.24,-51.9),(665.3,-77.96,-57.55),(663.7,-79.86,-57.01),(661.0,-80.91,-56.42),(665.8,-72.52,-58.63),(664.7,-70.76,-58.78),(664.2,-69.66,-58.92),(657.4,-74.54,-52.54),(658.6,-76.41,-51.25),(653.5,-78.63,-55.75),(654.7,-80.31,-55.61),(657.9,-81.47,-55.87),(654.9,-73.9,-56.79),(656.9,-71.91,-57.44),(659.1,-70.82,-57.96),(660.7,-75.88,-50.92),(659.2,-79.83,-51.43),(659.4,-80.91,-53.35),(661.9,-70.21,-54.83),(661.6,-71.16,-53.3),(661.1,-73.36,-51.7),(664.5,-78.52,-54.87),(662.9,-76.79,-51.84),(661.1,-80.18,-53.32),(665.5,-72.59,-57.74),(663.6,-70.21,-56.64),(663.1,-72.84,-53.11),(654.8,-79.29,-52.45),(656.5,-80.68,-52.26),(657.6,-78.83,-50.47),(659.6,-73.92,-51.99),(660.0,-71.11,-54.21),(662.4,-80.49,-56.71),(665.5,-76.53,-57.87),(665.3,-74.5,-58.2),(665.3,-74.18,-58.26),(665.5,-73.42,-58.43),(664.8,-73.42,-57.53),(664.7,-73.99,-57.59),(665.8,-72.75,-58.59),(665.3,-72.37,-58.59),(664.9,-72.28,-58.55),(665.3,-71.73,-58.7),(664.7,-72.28,-57.34),(664.9,-71.64,-56.9),(664.4,-73.95,-57.19),(664.4,-72.66,-56.82),(663.7,-71.37,-55.41),(662.9,-70.93,-54.65),(663.4,-69.17,-57.45),(664.8,-71.29,-58.7),(664.2,-70.61,-58.74),(664.2,-70.05,-58.84),(663.8,-69.24,-58.93),(660.4,-69.99,-58.29),(664.0,-70.86,-56.96),(665.3,-71.54,-58.73),(664.9,-71.0,-58.77),(664.6,-71.23,-56.84),(665.1,-71.79,-57.87),(664.6,-72.66,-55.09),(665.0,-72.99,-57.43),(665.7,-72.99,-58.0),(664.4,-70.94,-56.97),(665.1,-75.61,-53.99),(664.3,-74.74,-57.15),(663.2,-74.47,-52.2),(665.3,-76.12,-54.1),(664.5,-74.48,-55.8),(664.7,-74.49,-57.56),(664.5,-74.98,-53.63),(664.2,-75.27,-52.58),(664.5,-75.27,-55.95),(665.4,-75.53,-55.78),(663.7,-77.87,-52.87),(663.3,-79.44,-53.94),(663.6,-71.93,-54.19),(658.3,-71.58,-57.71),(665.5,-75.68,-58.02),(663.4,-69.98,-56.21),(664.8,-74.85,-57.51),(665.5,-75.32,-56.98),(665.6,-75.8,-56.49),(663.7,-74.62,-53.41),(664.3,-73.66,-55.97),(663.6,-73.88,-53.36),(664.7,-72.15,-56.61),(652.8,-75.46,-56.2),(653.8,-76.52,-52.56),(656.1,-81.13,-55.67),(653.9,-74.18,-55.8),(653.4,-74.62,-55.68),(652.8,-74.52,-56.38),(652.4,-74.28,-56.37),(651.4,-74.0,-56.26),(650.4,-73.29,-56.25),(649.4,-71.66,-56.39),(647.3,-70.23,-56.34),(647.4,-69.25,-56.53),(647.6,-66.71,-57.01),(648.4,-65.55,-57.37),(650.4,-65.17,-57.67),(651.0,-66.8,-57.5),(653.0,-68.47,-57.5),(654.2,-71.08,-57.19),(653.3,-72.86,-56.75),(654.0,-72.95,-56.84),(654.4,-73.2,-56.85),(649.2,-69.02,-55.78),(651.2,-70.02,-55.87),(653.8,-73.74,-55.9),(650.9,-68.3,-56.43),(649.8,-66.68,-56.55),(651.6,-71.29,-56.01),(651.8,-72.62,-55.99),(652.9,-73.4,-55.73),(649.0,-67.51,-56.35),(652.2,-73.57,-55.74),(652.8,-73.87,-55.76),(653.2,-74.18,-55.77),(657.7,-74.44,-51.54),(657.8,-74.28,-51.72),(658.0,-74.17,-51.95),(658.1,-74.19,-52.07),(658.4,-74.22,-52.24),(658.6,-74.41,-52.28),(658.7,-74.64,-52.13),(657.6,-75.06,-51.18),(657.8,-74.91,-51.44),(658.1,-74.93,-51.61),(658.2,-75.36,-51.87),(658.3,-75.12,-52.11),(658.7,-74.98,-52.05),(657.2,-75.04,-50.87),(657.5,-75.08,-51.02),(657.6,-75.73,-51.23),(658.4,-75.6,-51.75),(658.5,-75.25,-51.78),(657.1,-75.53,-50.51),(657.6,-76.0,-51.09),(658.2,-76.2,-51.4),(658.6,-76.11,-51.41),(657.2,-76.01,-50.31),(657.4,-76.03,-50.46),(657.8,-76.41,-50.58),(658.1,-76.69,-51.09),(658.3,-76.59,-51.27),(657.4,-76.42,-50.22),(658.2,-76.88,-50.78),(658.5,-76.84,-51.03),(658.6,-76.67,-51.35),(658.9,-76.65,-51.21),(657.7,-76.91,-50.18),(657.9,-77.1,-50.21),(658.1,-77.14,-50.37),(658.3,-77.21,-50.53),(658.6,-77.14,-50.8),(658.8,-76.91,-51.09),(657.7,-74.4,-51.31),(657.8,-74.24,-51.49),(658.0,-74.13,-51.72),(658.4,-74.18,-52.0),(658.6,-74.36,-52.04),(657.7,-75.02,-50.95),(657.9,-74.87,-51.2),(658.2,-74.89,-51.37),(657.3,-75.0,-50.64),(657.5,-75.49,-50.54),(657.7,-75.96,-50.86),(657.2,-75.49,-50.28),(657.3,-75.97,-50.07),(657.5,-75.99,-50.23),(657.9,-76.37,-50.35),(658.2,-76.65,-50.85),(657.5,-76.38,-49.99),(658.0,-76.71,-50.25),(658.3,-76.84,-50.55),(658.6,-76.8,-50.8),(657.8,-76.87,-49.95),(657.9,-77.06,-49.98),(658.2,-77.1,-50.14),(658.4,-77.17,-50.3),(658.7,-77.1,-50.57),(658.9,-76.87,-50.86),(660.0,-75.77,-63.4),(664.7,-75.24,-59.19),(663.5,-76.42,-62.91),(662.1,-75.95,-63.3),(657.0,-74.73,-61.37),(657.9,-76.93,-62.28),(660.0,-76.74,-63.37),(658.5,-80.42,-61.09),(659.0,-81.13,-59.23),(661.4,-70.45,-61.83),(660.9,-71.78,-63.0),(660.3,-74.09,-63.63),(664.6,-78.8,-60.2),(661.9,-77.84,-62.91),(660.7,-80.48,-59.72),(665.4,-72.69,-59.37),(663.3,-70.46,-60.7),(662.4,-73.45,-63.05),(654.4,-79.7,-59.04),(656.0,-81.11,-59.21),(656.8,-79.63,-62.09),(658.8,-74.58,-62.73),(659.5,-71.57,-61.72),(664.7,-73.51,-59.08),(664.6,-74.07,-58.81),(664.5,-72.42,-59.63),(664.6,-71.85,-60.32),(664.3,-74.06,-59.11),(664.2,-72.85,-59.91),(663.3,-71.75,-61.53),(662.3,-71.1,-62.05),(663.2,-69.34,-60.46),(663.8,-71.07,-60.31),(664.4,-71.46,-60.46),(665.0,-71.89,-59.42),(664.1,-73.08,-61.7),(664.9,-73.11,-59.4),(665.6,-73.05,-59.04),(664.2,-71.15,-60.39),(664.5,-76.09,-61.78),(664.2,-74.84,-58.85),(662.4,-75.16,-63.35),(664.8,-76.59,-61.56),(664.2,-74.78,-60.22),(664.6,-74.55,-58.66),(663.9,-75.52,-62.05),(663.5,-75.89,-62.89),(664.2,-75.51,-59.86),(665.0,-75.8,-60.18),(663.0,-78.5,-61.53),(662.9,-79.71,-60.0),(663.0,-72.46,-62.24),(663.0,-70.08,-61.05),(664.7,-74.91,-58.59),(665.3,-75.45,-59.13),(665.4,-75.99,-59.47),(663.0,-75.22,-62.14),(664.0,-73.97,-60.2),(662.9,-74.45,-62.57),(664.4,-72.5,-60.35),(653.3,-76.95,-59.63),(653.8,-74.28,-57.38),(653.3,-74.71,-57.19),(649.5,-70.34,-57.38),(651.1,-71.32,-57.43),(653.7,-73.84,-57.38),(651.3,-68.9,-58.16),(649.8,-66.73,-58.12),(651.7,-72.5,-57.15),(652.8,-73.47,-57.31),(648.6,-68.28,-57.81),(652.1,-73.65,-57.14),(652.7,-73.96,-57.18),(653.1,-74.27,-57.2),(656.9,-75.12,-62.43),(657.0,-74.93,-62.34),(657.3,-74.81,-62.22),(657.4,-74.82,-62.15),(657.7,-74.83,-62.05),(657.8,-75.0,-61.99),(658.0,-75.26,-61.96),(656.8,-75.76,-62.55),(657.1,-75.59,-62.42),(657.3,-75.6,-62.31),(657.5,-75.98,-61.94),(657.6,-75.72,-61.83),(658.0,-75.61,-62.11),(656.4,-75.77,-62.74),(656.6,-75.8,-62.64),(656.9,-76.42,-62.26),(657.7,-76.22,-62.04),(657.8,-75.9,-62.18),(656.3,-76.29,-62.88),(656.9,-76.7,-62.31),(657.4,-76.86,-62.09),(656.3,-76.79,-62.93),(656.6,-76.8,-62.84),(657.0,-77.16,-62.71),(657.4,-77.38,-62.21),(657.5,-77.26,-62.11),(656.5,-77.21,-62.92),(657.4,-77.6,-62.46),(657.7,-77.54,-62.32),(657.8,-77.33,-61.99),(658.2,-77.37,-62.37),(656.8,-77.69,-62.87),(657.0,-77.88,-62.83),(657.2,-77.91,-62.73),(657.5,-77.96,-62.62),(657.8,-77.86,-62.47),(658.0,-77.6,-62.33),(656.9,-75.07,-62.69),(657.1,-74.92,-62.6),(657.3,-74.8,-62.48),(657.7,-74.82,-62.3),(657.9,-74.99,-62.25),(658.0,-75.25,-62.22),(656.9,-75.75,-62.8),(657.1,-75.58,-62.68),(657.4,-75.59,-62.57),(656.4,-75.76,-62.99),(656.7,-76.26,-62.98),(656.3,-76.28,-63.13),(656.6,-76.79,-63.09),(656.4,-76.78,-63.19),(657.0,-77.15,-62.96),(657.4,-77.37,-62.46),(656.5,-77.2,-63.18),(657.1,-77.49,-62.97),(657.4,-77.59,-62.72),(657.8,-77.53,-62.58),(657.9,-77.31,-62.3),(656.8,-77.68,-63.13),(657.0,-77.87,-63.09),(657.3,-77.9,-62.98),(657.5,-77.95,-62.87),(657.8,-77.85,-62.73),(658.1,-77.59,-62.59),(661.3,-72.22,-52.3),(660.6,-72.77,-63.56),(651.4,-59.5,-45.78),(652.8,-59.98,-70.95),(717.2,-56.36,-68.39),(724.6,-49.59,-70.38),(726.9,-56.93,-68.78),(715.9,-53.49,-68.43),(716.8,-56.04,-63.1),(718.5,-54.58,-59.68),(721.6,-54.28,-60.34),(720.4,-52.54,-59.58),(726.3,-56.63,-62.22),(722.8,-51.1,-61.71),(723.9,-50.09,-64.75),(718.1,-53.38,-62.28),(726.1,-57.25,-75.1),(716.6,-56.57,-73.95),(718.3,-55.43,-77.23),(721.3,-55.17,-77.41),(719.6,-53.55,-78.55),(722.1,-51.94,-77.81),(723.4,-50.7,-75.31),(717.5,-54.15,-75.23),(723.7,-65.16,-77.17),(715.3,-67.45,-75.07),(720.4,-63.73,-78.53),(715.9,-65.86,-76.92),(717.5,-69.61,-72.13),(719.1,-71.56,-65.77),(716.3,-60.14,-67.51),(716.2,-65.2,-66.68),(727.6,-61.35,-67.6),(726.3,-64.4,-68.23),(729.7,-60.76,-74.12),(729.3,-62.41,-70.36),(728.7,-62.32,-76.83),(727.3,-64.12,-74.2),(728.1,-58.5,-74.0),(719.8,-73.86,-65.23),(716.2,-59.95,-61.48),(717.4,-68.38,-60.61),(717.6,-59.07,-57.46),(724.7,-60.65,-56.15),(723.1,-57.64,-58.86),(729.9,-60.18,-62.34),(729.0,-61.46,-59.16),(727.9,-62.96,-60.98),(729.4,-62.18,-65.52),(726.4,-64.29,-66.21),(724.0,-63.58,-56.52),(727.4,-60.79,-56.98),(727.7,-58.86,-58.82),(728.3,-57.96,-63.02),(725.8,-58.75,-56.47),(726.0,-57.61,-58.1),(727.6,-57.25,-61.62),(720.8,-62.4,-55.75),(718.6,-62.48,-55.65),(720.4,-70.27,-61.98),(717.8,-63.84,-53.01),(721.0,-68.93,-60.55),(721.5,-72.39,-62.56),(719.5,-67.0,-52.4),(719.5,-67.68,-55.85),(723.2,-68.28,-66.33),(723.5,-67.88,-61.32),(725.4,-65.95,-63.35),(724.0,-66.2,-66.57),(725.1,-66.45,-68.49),(721.6,-69.14,-64.43),(723.6,-70.71,-66.11),(722.1,-71.9,-63.57),(721.5,-69.41,-67.96),(722.1,-72.02,-67.82),(723.8,-67.79,-69.98),(727.3,-57.93,-75.65),(727.0,-61.87,-79.21),(727.7,-59.59,-78.05),(720.1,-70.54,-70.33),(721.5,-72.68,-69.1),(717.1,-69.94,-75.75),(716.1,-60.57,-74.16),(718.4,-69.03,-70.95),(717.3,-60.04,-77.6),(724.3,-62.09,-79.57),(722.8,-58.58,-78.11),(725.4,-60.15,-80.07),(725.6,-58.63,-79.09),(715.8,-65.93,-77.45),(729.3,-59.67,-74.07),(729.5,-59.12,-62.69),(729.8,-61.85,-67.91),(720.8,-69.43,-71.2),(718.6,-62.51,-56.2),(715.8,-65.91,-77.47),(723.5,-66.18,-57.08),(722.6,-67.81,-74.06),(717.7,-70.06,-72.25),(719.6,-68.17,-55.52),(719.2,-69.85,-61.38),(719.0,-70.09,-71.54),(720.0,-72.44,-67.79),(720.5,-73.39,-68.74),(719.2,-71.16,-67.87),(720.1,-72.4,-63.8),(720.7,-72.96,-62.48),(719.3,-71.02,-64.0),(719.7,-73.17,-65.38),(723.0,-65.21,-50.82),(720.5,-64.82,-49.43),(720.5,-62.88,-50.51),(723.5,-62.7,-49.43),(724.0,-61.33,-52.88),(724.9,-64.42,-52.62),(720.6,-53.01,-55.03),(724.0,-53.33,-53.72),(723.6,-53.63,-50.42),(721.6,-53.84,-49.06),(719.3,-57.3,-50.49),(722.7,-51.93,-55.93),(722.1,-50.27,-54.58),(719.8,-51.38,-51.42),(726.4,-54.16,-55.65),(725.9,-52.98,-58.04),(734.4,-52.96,-63.7),(734.5,-54.04,-61.86),(726.3,-51.61,-57.21),(735.8,-51.52,-62.18),(726.9,-49.97,-54.9),(725.4,-49.78,-55.39),(722.4,-49.79,-53.2),(723.5,-50.56,-51.15),(736.1,-52.28,-60.45),(727.4,-51.28,-53.13),(735.7,-53.35,-60.23),(727.3,-52.72,-53.04),(724.3,-51.77,-50.6),(724.2,-53.1,-50.99),(736.5,-55.51,-63.61),(737.0,-55.92,-62.96),(738.7,-54.37,-63.63),(735.4,-54.95,-63.31),(735.2,-55.51,-61.9),(739.6,-52.73,-63.93),(737.9,-56.51,-65.91),(738.7,-56.15,-63.75),(738.8,-56.75,-63.57),(737.2,-56.22,-67.0),(737.3,-55.72,-66.42),(738.2,-55.82,-66.43),(737.4,-55.73,-67.11),(737.9,-56.01,-65.58),(737.4,-55.5,-67.79),(737.5,-55.03,-67.18),(738.5,-55.02,-66.64),(738.2,-55.23,-66.16),(737.7,-54.99,-67.81),(737.8,-54.75,-67.34),(737.9,-54.34,-66.75),(738.8,-54.33,-66.56),(738.6,-54.49,-66.01),(738.0,-54.23,-67.41),(739.8,-54.41,-64.74),(739.3,-54.54,-64.64),(739.6,-53.79,-64.99),(739.2,-54.16,-65.36),(738.5,-53.98,-66.08),(738.5,-53.58,-65.8),(739.5,-53.54,-65.52),(739.2,-53.67,-65.13),(738.7,-53.5,-66.31),(740.1,-53.44,-64.86),(737.0,-55.71,-61.85),(738.5,-55.68,-61.15),(739.0,-54.68,-61.57),(739.3,-53.47,-62.89),(738.3,-56.37,-65.96),(737.9,-56.25,-66.59),(739.5,-56.46,-63.17),(738.9,-56.54,-64.97),(739.3,-56.0,-64.17),(739.9,-55.74,-64.0),(739.3,-55.75,-65.58),(738.6,-55.6,-66.6),(738.2,-55.54,-67.13),(739.6,-55.19,-64.57),(740.1,-54.9,-64.18),(739.7,-54.95,-65.33),(738.7,-54.76,-66.88),(739.0,-54.86,-66.37),(739.7,-54.03,-65.46),(739.4,-54.0,-65.86),(740.1,-54.07,-64.7),(740.1,-53.84,-63.92),(736.5,-57.0,-64.65),(735.9,-57.88,-64.87),(736.3,-57.87,-64.67),(735.8,-56.69,-64.38),(735.8,-57.96,-64.21),(735.7,-57.14,-63.41),(735.6,-56.37,-62.79),(736.5,-57.02,-63.33),(736.5,-57.35,-63.67),(736.2,-57.97,-64.04),(722.1,-64.7,-49.62),(719.4,-68.78,-79.3),(717.7,-68.79,-79.15),(716.0,-67.21,-80.75),(718.6,-66.65,-82.88),(718.8,-64.22,-81.43),(721.0,-67.3,-79.25),(709.9,-59.47,-78.38),(711.6,-57.99,-82.3),(711.3,-59.73,-84.48),(710.2,-61.31,-83.87),(711.8,-63.95,-79.88),(709.2,-57.31,-79.7),(707.3,-58.21,-80.21),(707.4,-60.37,-80.92),(711.5,-54.54,-83.29),(710.1,-54.21,-80.86),(708.0,-46.72,-83.44),(709.3,-46.91,-85.17),(708.5,-54.45,-81.74),(706.1,-46.87,-85.56),(706.5,-55.05,-84.04),(706.5,-55.88,-82.35),(706.7,-58.46,-81.62),(707.6,-58.48,-84.17),(707.0,-46.98,-87.35),(708.1,-55.16,-85.95),(708.3,-46.93,-87.37),(709.8,-55.05,-86.06),(709.0,-58.12,-85.31),(710.6,-58.09,-84.89),(708.6,-43.44,-85.89),(708.6,-43.02,-86.91),(706.2,-43.69,-86.85),(709.3,-44.42,-85.25),(710.0,-44.25,-86.5),(704.6,-44.83,-86.72),(707.2,-41.43,-85.78),(707.1,-42.07,-87.53),(707.4,-41.62,-88.07),(707.3,-41.67,-84.27),(707.0,-42.17,-84.74),(706.5,-41.8,-85.42),(706.8,-41.99,-84.22),(707.0,-41.93,-85.93),(706.5,-42.02,-83.61),(706.2,-42.51,-84.12),(705.7,-42.32,-85.31),(706.1,-42.33,-85.56),(705.9,-42.33,-83.74),(705.8,-42.63,-84.12),(705.6,-43.05,-84.65),(705.0,-42.81,-85.48),(705.4,-42.87,-85.78),(705.3,-42.96,-84.16),(704.9,-42.99,-86.98),(705.4,-42.93,-86.58),(704.7,-43.46,-86.16),(704.9,-43.11,-86.61),(705.1,-43.3,-85.57),(705.0,-43.71,-85.7),(704.3,-43.52,-86.49),(704.7,-43.58,-86.52),(704.7,-43.61,-85.38),(704.3,-43.83,-86.5),(708.7,-43.49,-87.66),(707.7,-43.06,-89.22),(706.7,-43.73,-88.9),(705.4,-44.44,-87.68),(706.8,-41.38,-86.08),(706.9,-41.49,-85.17),(706.9,-41.92,-88.86),(706.7,-41.3,-87.46),(706.4,-41.97,-87.74),(705.9,-42.13,-88.32),(705.8,-41.69,-87.02),(705.9,-41.78,-85.6),(706.0,-41.86,-84.84),(705.6,-42.47,-87.36),(705.3,-42.79,-87.88),(705.1,-42.35,-87.3),(705.3,-42.41,-85.22),(705.2,-42.33,-85.93),(704.5,-43.06,-86.69),(704.6,-43.07,-86.35),(704.5,-43.24,-87.08),(704.7,-43.71,-87.43),(709.2,-42.02,-85.15),(710.2,-41.44,-84.73),(709.9,-41.34,-85.19),(709.7,-42.58,-84.88),(710.5,-41.52,-85.29),(710.2,-42.39,-85.81),(710.0,-43.21,-86.15),(709.5,-42.23,-86.34),(709.7,-41.9,-86.09),(710.2,-41.41,-85.69),(719.2,-68.29,-80.78),(720.4,-63.73,-78.56),(715.9,-65.86,-76.95),(724.2,-45.23,-71.06),(722.8,-44.59,-70.12),(712.1,-48.81,-68.53),(714.2,-42.86,-69.41),(717.3,-41.95,-69.76),(713.7,-51.74,-68.28),(720.1,-50.52,-80.62),(717.4,-52.06,-78.27),(721.9,-48.03,-79.15),(723.0,-46.29,-75.2),(713.5,-52.15,-73.7),(730.1,-27.73,-87.2),(731.0,-31.9,-85.6),(726.9,-29.2,-83.2),(730.0,-32.07,-82.63),(731.0,-31.42,-79.07),(728.1,-28.33,-79.98),(731.0,-26.62,-79.1),(732.8,-31.37,-87.45),(732.8,-30.65,-77.94),(735.4,-29.76,-79.06),(733.4,-25.66,-83.74),(736.6,-29.68,-83.16),(735.4,-30.35,-86.33),(732.7,-34.77,-87.14),(732.7,-33.48,-76.49),(734.8,-35.42,-77.79),(735.8,-36.86,-81.6),(734.7,-36.3,-84.28),(726.5,-41.97,-85.75),(724.3,-39.21,-85.22),(724.7,-36.39,-82.18),(725.3,-35.78,-77.21),(727.3,-38.95,-73.65),(729.4,-41.48,-74.67),(729.9,-43.41,-78.31),(728.5,-43.36,-82.32),(718.9,-48.58,-81.6),(718.5,-43.48,-85.04),(720.1,-39.89,-81.33),(717.5,-40.37,-72.93),(721.1,-39.69,-73.16),(715.2,-49.54,-81.01),(716.3,-46.28,-83.65),(710.6,-47.7,-78.12),(711.8,-49.25,-77.41),(711.2,-50.2,-70.18),(710.2,-48.43,-71.08),(711.6,-47.02,-68.75),(712.9,-46.07,-67.89),(710.0,-46.0,-77.24),(715.3,-40.19,-79.71),(709.7,-45.59,-71.31),(717.0,-40.12,-75.86),(711.4,-44.61,-69.1),(714.1,-44.28,-67.27),(726.3,-22.92,-88.58),(724.6,-23.63,-87.18),(723.9,-23.92,-83.75),(724.6,-23.23,-80.57),(726.3,-22.36,-79.51),(727.9,-21.43,-80.96),(728.6,-21.32,-83.99),(727.9,-21.97,-87.35),(721.0,-17.41,-88.14),(719.6,-18.25,-87.19),(719.0,-18.51,-84.42),(719.6,-17.96,-81.82),(720.9,-17.01,-80.82),(722.4,-16.14,-82.15),(723.0,-16.13,-84.58),(722.4,-16.56,-87.28),(717.0,-12.71,-87.28),(716.2,-13.92,-87.04),(715.8,-14.32,-84.86),(716.2,-13.74,-83.58),(717.1,-12.36,-83.14),(717.8,-11.27,-84.03),(718.1,-10.98,-85.81),(717.9,-11.45,-87.08),(717.0,-9.213,-87.88),(717.0,-8.478,-86.2),(717.2,-5.956,-87.4),(715.9,-7.865,-88.37),(716.9,-8.978,-84.46),(715.9,-7.56,-83.99),(717.2,-5.76,-85.31),(716.0,-10.46,-82.81),(714.4,-13.79,-82.3),(713.5,-13.38,-82.86),(714.3,-12.21,-82.15),(714.1,-14.32,-84.92),(713.2,-13.88,-85.02),(714.3,-13.98,-87.31),(713.4,-13.71,-87.3),(716.5,-11.02,-88.21),(714.4,-12.59,-88.14),(715.2,-7.489,-88.33),(716.6,-5.116,-86.39),(715.1,-7.31,-84.32),(715.2,-14.28,-86.45),(715.2,-14.04,-83.01),(711.5,-12.55,-84.81),(711.5,-12.61,-85.91),(711.8,-12.08,-84.9),(711.8,-12.14,-86.0),(718.3,-41.16,-72.96),(721.2,-42.74,-72.13),(721.7,-49.25,-58.88),(718.9,-50.99,-59.8),(723.2,-47.02,-61.68),(723.7,-45.77,-66.38),(714.3,-51.52,-62.9),(711.4,-21.41,-63.37),(713.6,-25.62,-63.91),(708.3,-24.0,-65.64),(712.5,-26.51,-66.37),(712.9,-26.3,-70.3),(708.9,-23.56,-69.38),(711.1,-21.64,-71.75),(715.2,-24.4,-62.89),(714.2,-25.37,-72.22),(716.4,-23.75,-72.3),(713.6,-19.55,-68.43),(717.8,-22.66,-68.79),(717.2,-23.01,-65.16),(717.3,-27.54,-61.83),(716.0,-28.46,-72.43),(719.2,-28.43,-71.26),(721.2,-28.13,-67.51),(720.0,-27.9,-64.76),(719.4,-36.03,-58.61),(715.5,-35.89,-59.61),(713.3,-34.45,-63.58),(713.3,-34.54,-68.69),(717.6,-35.86,-71.2),(721.2,-36.13,-69.96),(723.2,-36.09,-66.11),(722.0,-36.25,-61.85),(719.8,-45.35,-57.22),(715.2,-41.99,-56.98),(712.9,-39.9,-61.82),(714.7,-40.21,-70.23),(717.0,-48.16,-57.31),(715.9,-45.3,-56.68),(712.1,-46.6,-59.26),(713.2,-48.23,-59.8),(711.5,-49.97,-66.21),(710.7,-48.11,-65.63),(712.7,-46.21,-70.29),(711.2,-45.02,-60.46),(710.7,-43.36,-63.25),(710.1,-45.29,-66.18),(712.0,-42.81,-66.95),(711.4,-44.6,-68.81),(713.7,-44.55,-71.84),(706.5,-17.21,-63.18),(704.9,-18.33,-63.76),(703.9,-19.27,-66.69),(704.2,-19.07,-70.2),(705.6,-18.22,-72.03),(707.1,-16.88,-71.49),(708.0,-16.18,-68.84),(707.8,-16.3,-65.2),(700.3,-12.74,-64.71),(699.1,-13.8,-64.92),(698.3,-14.55,-67.3),(698.5,-14.41,-70.15),(699.6,-13.56,-71.85),(701.0,-12.4,-71.32),(701.8,-11.93,-69.17),(701.5,-11.94,-66.27),(696.5,-8.823,-66.81),(695.5,-9.815,-66.33),(694.9,-10.52,-68.32),(695.2,-10.18,-69.71),(696.3,-9.108,-70.96),(697.4,-8.155,-70.72),(697.9,-7.654,-69.1),(697.7,-7.857,-67.74),(698.4,-5.888,-67.68),(698.6,-5.394,-69.66),(700.2,-3.105,-69.59),(698.1,-4.182,-67.84),(698.1,-6.121,-71.1),(698.0,-4.526,-72.2),(700.1,-3.226,-71.7),(696.4,-7.283,-72.05),(693.4,-9.837,-71.01),(692.7,-8.968,-70.68),(694.0,-8.301,-71.92),(693.1,-9.918,-68.22),(692.4,-9.057,-68.35),(693.6,-9.521,-65.98),(692.9,-8.632,-66.25),(697.0,-7.211,-66.58),(694.3,-7.824,-65.96),(697.7,-3.594,-68.04),(700.0,-2.315,-70.94),(697.3,-3.929,-72.01),(694.3,-10.13,-66.74),(694.1,-10.4,-70.17),(691.5,-7.09,-69.29),(691.6,-7.001,-68.2),(692.1,-6.789,-69.4),(692.1,-6.7,-68.31),(728.5,-75.7,-66.54),(724.2,-75.67,-59.61),(722.7,-81.92,-64.48),(725.8,-69.89,-67.07),(728.1,-75.77,-65.25),(727.5,-76.45,-60.92),(726.2,-75.91,-60.29),(728.5,-78.63,-66.02),(726.9,-80.52,-65.45),(724.2,-81.55,-64.79),(729.1,-73.19,-67.08),(728.0,-71.42,-67.19),(727.6,-70.32,-67.31),(720.8,-75.16,-60.8),(722.0,-77.04,-59.54),(716.8,-79.21,-63.92),(717.9,-80.89,-63.82),(721.1,-82.09,-64.17),(718.2,-74.49,-64.97),(720.2,-72.51,-65.67),(722.5,-71.44,-66.24),(724.0,-76.52,-59.26),(722.4,-80.46,-59.76),(722.7,-81.54,-61.68),(725.3,-70.86,-63.17),(724.9,-71.81,-61.64),(724.5,-74.0,-60.04),(727.7,-79.19,-63.32),(726.2,-77.45,-60.24),(724.4,-80.82,-61.69),(728.8,-73.27,-66.18),(726.9,-70.87,-65.02),(726.5,-73.5,-61.49),(718.1,-79.89,-60.67),(719.7,-81.29,-60.52),(720.9,-79.45,-58.75),(722.9,-74.56,-60.29),(723.4,-71.74,-62.5),(725.7,-81.14,-65.12),(728.7,-77.21,-66.33),(728.5,-75.17,-66.64),(728.6,-74.85,-66.7),(728.8,-74.09,-66.88),(728.1,-74.08,-65.96),(728.0,-74.66,-66.02),(729.1,-73.43,-67.04),(728.6,-73.04,-67.03),(728.2,-72.94,-66.97),(728.6,-72.4,-67.13),(728.0,-72.94,-65.76),(728.2,-72.31,-65.32),(727.7,-74.61,-65.61),(727.7,-73.33,-65.24),(727.1,-72.04,-63.8),(726.3,-71.59,-63.02),(726.7,-69.83,-65.82),(728.1,-71.96,-67.11),(727.5,-71.28,-67.14),(727.5,-70.72,-67.23),(727.2,-69.9,-67.31),(723.7,-70.62,-66.59),(727.4,-71.53,-65.36),(728.6,-72.21,-67.16),(728.2,-71.66,-67.19),(727.9,-71.9,-65.25),(728.4,-72.47,-66.3),(727.9,-73.33,-63.51),(728.3,-73.66,-65.86),(729.0,-73.66,-66.45),(727.8,-71.61,-65.37),(728.4,-76.28,-62.43),(727.6,-75.4,-65.58),(726.5,-75.14,-60.6),(728.6,-76.81,-62.55),(727.8,-75.15,-64.23),(728.0,-75.16,-65.99),(727.8,-75.66,-62.06),(727.5,-75.95,-61.01),(727.8,-75.94,-64.38),(728.6,-76.21,-64.23),(727.0,-78.54,-61.3),(726.6,-80.1,-62.37),(726.9,-72.59,-62.58),(721.7,-72.19,-65.97),(728.8,-76.36,-66.48),(726.7,-70.64,-64.58),(728.0,-75.52,-65.95),(728.8,-75.99,-65.44),(728.9,-76.48,-64.95),(727.0,-75.29,-61.82),(727.6,-74.32,-64.39),(726.9,-74.55,-61.76),(728.0,-72.82,-65.03),(716.0,-76.03,-64.34),(717.1,-77.1,-60.73),(719.3,-81.73,-63.92),(717.3,-74.76,-63.96),(716.7,-75.19,-63.83),(716.1,-75.09,-64.52),(715.7,-74.84,-64.49),(714.7,-74.55,-64.36),(713.7,-73.84,-64.32),(712.7,-72.2,-64.43),(710.6,-70.75,-64.32),(710.7,-69.78,-64.5),(710.9,-67.23,-64.98),(711.8,-66.08,-65.35),(713.8,-65.71,-65.7),(714.4,-67.36,-65.55),(716.4,-69.04,-65.61),(717.5,-71.66,-65.35),(716.6,-73.43,-64.89),(717.3,-73.53,-65.0),(717.7,-73.79,-65.02),(712.6,-69.56,-63.79),(714.5,-70.58,-63.94),(717.1,-74.32,-64.06),(714.2,-68.86,-64.48),(713.2,-67.22,-64.57),(714.9,-71.85,-64.1),(715.2,-73.18,-64.09),(716.3,-73.97,-63.87),(712.4,-68.05,-64.35),(715.5,-74.13,-63.86),(716.1,-74.44,-63.89),(716.6,-74.75,-63.92),(721.0,-75.06,-59.8),(721.1,-74.9,-59.98),(721.3,-74.8,-60.21),(721.5,-74.82,-60.33),(721.7,-74.85,-60.51),(721.9,-75.04,-60.56),(722.0,-75.27,-60.41),(721.0,-75.68,-59.44),(721.2,-75.53,-59.7),(721.4,-75.56,-59.88),(721.5,-75.98,-60.15),(721.6,-75.74,-60.38),(722.0,-75.61,-60.33),(720.6,-75.66,-59.12),(720.8,-75.7,-59.28),(721.0,-76.35,-59.49),(721.8,-76.22,-60.03),(721.8,-75.87,-60.07),(720.5,-76.15,-58.76),(721.0,-76.62,-59.35),(721.5,-76.82,-59.68),(721.9,-76.74,-59.7),(720.6,-76.62,-58.56),(720.8,-76.65,-58.72),(721.2,-77.03,-58.85),(721.5,-77.32,-59.37),(721.6,-77.21,-59.55),(720.7,-77.04,-58.48),(721.6,-77.5,-59.06),(721.8,-77.47,-59.32),(721.9,-77.3,-59.64),(722.2,-77.28,-59.5),(721.0,-77.53,-58.45),(721.2,-77.72,-58.48),(721.4,-77.77,-58.65),(721.7,-77.84,-58.82),(722.0,-77.77,-59.09),(722.2,-77.54,-59.39),(721.1,-75.03,-59.57),(721.2,-74.86,-59.75),(721.4,-74.76,-59.98),(721.8,-74.81,-60.28),(721.9,-74.98,-60.32),(721.1,-75.64,-59.21),(721.3,-75.49,-59.47),(721.5,-75.52,-59.65),(720.7,-75.62,-58.89),(720.9,-76.11,-58.8),(721.1,-76.59,-59.12),(720.6,-76.11,-58.53),(720.6,-76.59,-58.33),(720.8,-76.61,-58.49),(721.3,-76.99,-58.62),(721.5,-77.28,-59.14),(720.8,-77.01,-58.25),(721.4,-77.33,-58.52),(721.6,-77.46,-58.83),(721.9,-77.43,-59.09),(721.1,-77.49,-58.22),(721.3,-77.68,-58.25),(721.5,-77.73,-58.42),(721.7,-77.8,-58.59),(722.0,-77.73,-58.86),(722.2,-77.5,-59.16),(723.2,-76.38,-71.72),(727.9,-75.91,-67.63),(726.7,-77.07,-71.32),(725.3,-76.58,-71.67),(720.2,-75.32,-69.61),(721.1,-77.54,-70.55),(723.2,-77.35,-71.7),(721.6,-81.03,-69.4),(722.2,-81.75,-67.55),(724.6,-71.08,-70.15),(724.1,-72.4,-71.32),(723.5,-74.71,-71.95),(727.8,-79.46,-68.65),(725.1,-78.47,-71.29),(723.8,-81.11,-68.08),(728.7,-73.36,-67.81),(726.6,-71.11,-69.08),(725.7,-74.09,-71.41),(717.6,-80.28,-67.24),(719.2,-81.7,-67.45),(720.0,-80.22,-70.35),(722.1,-75.19,-71.01),(722.8,-72.19,-70.0),(728.0,-74.18,-67.51),(727.9,-74.73,-67.23),(727.8,-73.08,-68.04),(727.9,-72.51,-68.74),(727.5,-74.73,-67.53),(727.5,-73.51,-68.32),(726.6,-72.4,-69.91),(725.6,-71.74,-70.4),(726.5,-69.99,-68.82),(727.1,-71.73,-68.7),(727.6,-72.12,-68.86),(728.3,-72.56,-67.84),(727.4,-73.74,-70.11),(728.2,-73.78,-67.83),(728.9,-73.73,-67.49),(727.5,-71.81,-68.79),(727.7,-76.75,-70.22),(727.5,-75.5,-67.27),(725.6,-75.8,-71.73),(728.0,-77.25,-70.0),(727.4,-75.44,-68.64),(727.9,-75.22,-67.09),(727.1,-76.18,-70.46),(726.7,-76.53,-71.3),(727.4,-76.17,-68.28),(728.3,-76.47,-68.63),(726.2,-79.15,-69.94),(726.1,-80.36,-68.42),(726.3,-73.11,-70.62),(726.3,-70.73,-69.41),(728.0,-75.58,-67.02),(728.6,-76.12,-67.58),(728.6,-76.66,-67.92),(726.2,-75.87,-70.54),(727.3,-74.63,-68.61),(726.2,-75.09,-70.95),(727.7,-73.16,-68.76),(716.6,-77.52,-67.79),(717.1,-74.86,-65.54),(716.6,-75.28,-65.34),(712.9,-70.88,-65.41),(714.4,-71.87,-65.5),(717.0,-74.41,-65.53),(714.7,-69.45,-66.23),(713.1,-67.27,-66.14),(715.0,-73.05,-65.25),(716.1,-74.04,-65.44),(711.9,-68.81,-65.81),(715.4,-74.22,-65.26),(716.0,-74.53,-65.31),(716.4,-74.84,-65.35),(720.1,-75.71,-70.67),(720.2,-75.53,-70.58),(720.5,-75.4,-70.47),(720.7,-75.41,-70.4),(720.9,-75.43,-70.3),(721.1,-75.6,-70.25),(721.2,-75.87,-70.23),(720.1,-76.35,-70.79),(720.3,-76.18,-70.67),(720.5,-76.19,-70.57),(720.7,-76.58,-70.19),(720.8,-76.32,-70.09),(721.2,-76.21,-70.38),(719.6,-76.36,-70.97),(719.8,-76.39,-70.88),(720.1,-77.01,-70.51),(720.9,-76.82,-70.3),(721.0,-76.5,-70.44),(719.5,-76.88,-71.11),(720.1,-77.29,-70.55),(720.6,-77.45,-70.35),(719.5,-77.37,-71.16),(719.8,-77.39,-71.08),(720.2,-77.75,-70.96),(720.5,-77.98,-70.47),(720.7,-77.86,-70.38),(719.7,-77.8,-71.16),(720.6,-78.2,-70.73),(720.9,-78.14,-70.59),(721.0,-77.93,-70.27),(721.4,-77.97,-70.65),(720.0,-78.28,-71.12),(720.2,-78.47,-71.08),(720.4,-78.5,-70.99),(720.7,-78.55,-70.89),(721.0,-78.46,-70.75),(721.2,-78.21,-70.61),(720.1,-75.66,-70.93),(720.3,-75.52,-70.84),(720.5,-75.39,-70.73),(720.9,-75.42,-70.56),(721.1,-75.59,-70.51),(721.2,-75.86,-70.49),(720.1,-76.34,-71.05),(720.3,-76.17,-70.92),(720.6,-76.18,-70.82),(719.6,-76.35,-71.22),(719.9,-76.85,-71.22),(719.5,-76.87,-71.36),(719.8,-77.38,-71.33),(719.6,-77.36,-71.42),(720.2,-77.74,-71.22),(720.6,-77.97,-70.73),(719.7,-77.79,-71.42),(720.3,-78.09,-71.23),(720.6,-78.19,-70.98),(720.9,-78.13,-70.85),(721.1,-77.91,-70.57),(720.0,-78.27,-71.38),(720.2,-78.46,-71.34),(720.4,-78.49,-71.25),(720.7,-78.54,-71.14),(721.0,-78.45,-71.0),(721.3,-78.2,-70.87),(724.7,-72.87,-60.64),(723.8,-73.4,-71.88),(719.7,-57.25,-54.59),(713.7,-62.18,-77.4),(785.5,-52.76,-77.52),(792.6,-45.8,-79.29),(795.2,-53.0,-76.94),(784.0,-49.95,-77.9),(784.8,-52.33,-72.31),(786.4,-50.74,-68.84),(789.4,-50.35,-69.22),(788.1,-48.63,-68.71),(794.3,-52.57,-70.48),(790.6,-47.16,-70.7),(791.7,-46.18,-73.7),(786.0,-49.62,-71.55),(794.7,-53.5,-83.29),(785.2,-53.12,-83.11),(787.0,-52.0,-86.29),(790.0,-51.65,-86.2),(788.2,-50.11,-87.62),(790.7,-48.39,-86.76),(791.8,-47.06,-84.23),(786.1,-50.7,-84.46),(792.8,-61.52,-85.02),(785.8,-60.86,-88.77),(789.6,-60.24,-86.79),(788.1,-59.07,-90.12),(787.2,-65.38,-84.25),(788.0,-67.81,-73.63),(784.8,-56.55,-76.45),(784.8,-61.58,-75.27),(796.1,-57.36,-75.38),(795.0,-60.47,-75.91),(798.5,-56.86,-81.72),(798.0,-58.43,-77.89),(797.6,-58.51,-84.4),(796.2,-60.3,-81.79),(796.8,-54.65,-81.91),(788.8,-70.07,-72.86),(784.4,-56.22,-70.47),(785.9,-64.58,-68.88),(785.5,-55.2,-66.39),(792.6,-56.51,-64.29),(791.0,-53.61,-67.36),(798.1,-56.0,-70.0),(797.1,-57.23,-66.83),(795.6,-59.59,-69.12),(797.8,-58.08,-73.07),(794.9,-60.31,-73.89),(791.1,-60.44,-66.33),(795.3,-56.57,-64.86),(795.6,-54.68,-66.8),(796.4,-53.86,-70.99),(793.6,-54.58,-64.65),(793.8,-53.47,-66.33),(795.6,-53.14,-69.71),(788.7,-58.37,-64.15),(786.6,-58.53,-64.24),(789.0,-66.39,-69.83),(784.8,-61.63,-64.55),(789.4,-65.75,-72.07),(790.2,-68.48,-70.15),(786.5,-64.75,-64.4),(787.1,-65.08,-67.89),(791.9,-64.41,-74.03),(791.8,-64.57,-72.06),(793.7,-62.44,-73.11),(792.7,-62.31,-74.35),(793.9,-62.56,-76.14),(790.3,-65.28,-72.23),(792.4,-66.81,-73.6),(790.8,-67.99,-71.13),(790.4,-65.64,-75.74),(791.1,-68.21,-75.36),(792.7,-63.98,-77.65),(796.0,-54.15,-83.68),(796.0,-58.18,-86.97),(796.6,-55.85,-85.91),(789.2,-66.86,-78.16),(790.6,-68.92,-76.64),(786.8,-64.93,-88.23),(784.8,-57.13,-83.08),(788.2,-64.99,-83.17),(786.2,-56.65,-86.43),(794.3,-57.48,-88.23),(791.6,-55.01,-86.52),(795.2,-55.57,-88.27),(794.5,-54.99,-87.22),(788.2,-59.12,-90.61),(798.0,-55.78,-81.79),(797.6,-54.96,-70.47),(798.3,-57.8,-75.44),(789.8,-65.75,-79.04),(786.7,-58.57,-64.79),(788.2,-59.09,-90.63),(791.3,-63.12,-67.56),(792.4,-63.51,-84.73),(787.4,-65.82,-84.43),(787.2,-65.6,-67.69),(787.8,-66.0,-69.37),(788.1,-66.48,-79.5),(789.0,-68.7,-75.5),(789.5,-69.66,-76.33),(788.1,-67.46,-75.75),(788.9,-68.57,-71.51),(789.5,-69.08,-70.1),(788.0,-67.22,-71.89),(788.7,-69.39,-73.07),(789.7,-63.03,-61.32),(787.4,-63.78,-61.86),(788.3,-58.74,-58.9),(788.0,-60.96,-58.9),(787.6,-58.85,-61.31),(791.6,-62.0,-62.3),(777.5,-56.01,-64.25),(779.1,-53.77,-61.49),(779.5,-55.13,-58.63),(778.6,-56.88,-58.3),(780.9,-59.96,-61.42),(776.2,-53.53,-63.74),(774.5,-54.54,-62.43),(775.4,-56.75,-60.89),(778.3,-50.07,-62.03),(776.6,-50.26,-64.19),(773.4,-42.88,-64.48),(774.9,-42.59,-63.03),(775.2,-50.49,-62.89),(771.7,-43.04,-61.98),(773.6,-50.87,-60.0),(773.5,-51.95,-61.24),(774.1,-54.6,-60.85),(775.2,-54.11,-58.6),(772.7,-42.7,-60.4),(775.2,-50.54,-58.47),(774.0,-42.4,-60.71),(776.9,-50.26,-58.79),(776.6,-53.43,-57.98),(778.1,-53.3,-58.75),(772.6,-39.52,-63.57),(772.5,-39.03,-62.73),(770.5,-40.22,-61.83),(773.5,-40.26,-63.96),(774.3,-39.74,-62.98),(769.5,-41.72,-61.22),(770.6,-38.01,-64.55),(770.8,-38.48,-62.19),(770.9,-37.87,-61.99),(770.5,-38.26,-66.03),(770.6,-38.79,-65.51),(770.0,-38.6,-64.7),(770.2,-38.71,-65.96),(770.6,-38.53,-64.35),(769.8,-38.87,-66.46),(769.9,-39.37,-65.91),(769.4,-39.33,-64.6),(769.9,-39.2,-64.47),(769.4,-39.32,-66.18),(769.6,-39.6,-65.81),(769.6,-40.04,-65.24),(769.0,-39.97,-64.27),(769.5,-39.89,-64.08),(769.2,-40.07,-65.63),(769.1,-39.97,-61.93),(769.6,-39.92,-62.3),(769.1,-40.64,-62.26),(769.2,-40.21,-63.02),(769.4,-40.39,-64.22),(769.4,-40.82,-64.04),(768.8,-40.77,-62.94),(769.2,-40.71,-62.88),(769.1,-40.83,-64.29),(768.8,-40.97,-61.73),(772.9,-39.22,-61.73),(771.7,-38.89,-60.07),(771.1,-39.83,-59.93),(770.1,-41.0,-60.59),(770.2,-38.09,-64.14),(770.2,-38.19,-65.05),(770.5,-38.08,-61.08),(770.2,-37.95,-62.84),(770.1,-38.5,-62.0),(769.6,-38.67,-61.33),(769.4,-38.62,-62.98),(769.5,-38.74,-64.38),(769.5,-38.8,-65.16),(769.5,-39.24,-62.03),(769.3,-39.47,-61.32),(769.1,-39.38,-62.45),(769.1,-39.53,-64.59),(769.1,-39.45,-63.88),(768.8,-40.28,-62.67),(768.9,-40.3,-63.25),(768.8,-40.25,-61.63),(769.2,-40.57,-60.98),(772.5,-38.05,-64.69),(773.2,-37.31,-65.51),(772.9,-37.24,-65.02),(773.2,-38.48,-64.93),(773.5,-37.24,-65.02),(773.7,-38.05,-64.2),(773.8,-38.82,-63.59),(773.0,-38.02,-63.56),(773.0,-37.7,-63.93),(773.2,-37.16,-64.59),(788.5,-63.06,-60.77),(789.6,-63.71,-91.03),(788.1,-62.94,-91.83),(788.9,-60.34,-93.96),(791.7,-61.38,-93.45),(792.7,-59.71,-90.65),(791.6,-62.89,-89.81),(790.8,-51.2,-91.28),(794.1,-52.15,-93.05),(793.2,-52.65,-96.04),(791.1,-52.75,-96.92),(788.5,-55.2,-93.87),(792.4,-50.95,-91.29),(791.9,-49.45,-93.1),(789.8,-50.13,-95.23),(795.8,-53.47,-91.39),(795.6,-51.97,-89.48),(804.6,-51.84,-85.72),(804.4,-53.15,-87.02),(796.0,-50.78,-90.92),(805.8,-50.77,-88.08),(796.5,-49.56,-93.96),(795.1,-49.19,-93.25),(792.2,-49.2,-94.7),(792.9,-50.34,-96.57),(805.9,-51.77,-89.47),(796.7,-51.11,-95.19),(805.4,-52.81,-89.11),(796.5,-52.52,-94.67),(793.4,-51.66,-96.77),(793.2,-52.88,-95.84),(806.3,-54.18,-85.36),(806.7,-54.72,-85.9),(808.7,-53.46,-85.87),(805.3,-53.41,-85.72),(804.9,-54.12,-86.79),(809.8,-51.98,-86.34),(808.0,-55.34,-83.32),(808.4,-55.24,-85.32),(808.3,-55.88,-85.44),(807.5,-54.71,-82.42),(807.7,-54.39,-83.25),(808.5,-54.69,-83.22),(807.8,-54.29,-82.6),(808.1,-54.93,-83.9),(808.0,-53.97,-82.07),(808.2,-53.68,-82.9),(809.1,-53.99,-83.46),(808.8,-54.21,-83.79),(808.5,-53.58,-82.33),(808.5,-53.45,-82.91),(808.8,-53.22,-83.7),(809.6,-53.46,-83.92),(809.3,-53.64,-84.34),(809.0,-53.03,-83.14),(810.1,-53.76,-85.1),(809.6,-53.83,-84.81),(810.0,-53.09,-84.73),(809.9,-53.55,-85.08),(809.4,-53.15,-84.55),(809.5,-52.83,-85.03),(810.3,-53.0,-85.25),(809.9,-53.09,-85.42),(809.7,-52.71,-84.6),(810.4,-52.74,-85.23),(806.5,-54.69,-86.89),(807.9,-54.98,-87.72),(808.7,-54.06,-87.76),(809.4,-52.8,-87.02),(808.5,-55.32,-83.37),(808.2,-54.99,-82.82),(808.9,-55.66,-86.27),(809.0,-55.77,-84.35),(809.1,-55.22,-85.22),(809.7,-55.07,-85.72),(809.6,-55.04,-84.15),(809.1,-54.58,-83.19),(808.7,-54.33,-82.71),(809.6,-54.47,-85.14),(810.0,-54.24,-85.76),(810.1,-54.38,-84.87),(809.4,-53.77,-83.38),(809.7,-54.03,-83.82),(810.3,-53.47,-84.96),(810.2,-53.39,-84.75),(810.4,-53.47,-85.29),(810.2,-53.2,-86.02),(806.0,-55.42,-83.59),(805.2,-56.11,-82.94),(805.6,-56.2,-83.17),(805.3,-55.04,-83.93),(805.0,-56.26,-83.53),(805.1,-55.59,-84.67),(805.1,-54.93,-85.6),(805.9,-55.63,-84.85),(805.8,-55.9,-84.37),(805.4,-56.37,-83.72),(790.0,-63.12,-92.34),(789.6,-60.24,-86.81),(788.1,-59.07,-90.14),(792.1,-41.47,-80.32),(789.2,-39.54,-80.73),(780.1,-45.4,-78.69),(782.0,-39.41,-79.79),(785.0,-38.41,-79.91),(781.8,-48.27,-78.08),(788.7,-47.11,-89.86),(786.0,-48.69,-87.66),(790.3,-44.54,-88.4),(791.2,-42.67,-84.48),(781.9,-48.81,-83.47),(782.2,-18.82,-95.79),(783.7,-23.2,-94.28),(779.1,-20.4,-91.79),(782.8,-23.5,-91.3),(783.7,-22.79,-87.75),(780.2,-19.52,-88.57),(783.0,-17.74,-87.67),(785.4,-22.47,-96.16),(785.4,-21.85,-86.62),(787.9,-20.66,-87.77),(785.4,-16.67,-92.31),(789.0,-20.38,-91.9),(787.9,-21.15,-95.06),(786.9,-26.16,-96.06),(786.8,-25.27,-85.29),(789.8,-25.87,-87.08),(791.3,-26.42,-91.22),(789.8,-26.45,-93.68),(787.4,-35.07,-95.51),(783.7,-34.27,-93.89),(782.2,-32.01,-90.35),(782.8,-31.33,-85.43),(787.1,-32.75,-82.92),(790.5,-33.47,-84.88),(791.9,-34.5,-89.09),(790.3,-35.14,-92.83),(786.5,-44.38,-92.35),(782.3,-40.47,-93.54),(781.6,-37.13,-89.32),(781.7,-39.04,-80.46),(783.5,-36.68,-81.53),(783.8,-46.32,-90.79),(782.6,-43.65,-92.44),(779.0,-44.57,-88.47),(780.3,-46.06,-87.54),(779.4,-46.86,-80.32),(778.4,-45.15,-81.44),(779.5,-43.64,-79.09),(780.7,-42.63,-78.18),(778.2,-42.87,-87.78),(778.7,-39.76,-86.23),(777.7,-42.34,-81.93),(780.6,-39.02,-83.08),(779.3,-41.25,-79.63),(781.8,-40.79,-77.57),(778.3,-14.0,-97.08),(776.5,-14.68,-95.69),(775.8,-14.96,-92.26),(776.5,-14.29,-89.08),(778.3,-13.46,-88.02),(779.9,-12.54,-89.46),(780.6,-12.43,-92.49),(779.9,-13.05,-95.85),(773.4,-8.439,-96.64),(771.9,-9.159,-95.69),(771.3,-9.363,-92.92),(772.0,-8.854,-90.33),(773.4,-8.014,-89.32),(774.9,-7.264,-90.65),(775.6,-7.295,-93.08),(774.9,-7.683,-95.78),(771.1,-3.736,-95.91),(769.8,-4.52,-95.68),(769.2,-4.72,-93.51),(769.8,-4.266,-92.23),(771.3,-3.364,-91.78),(772.6,-2.695,-92.65),(773.0,-2.569,-94.43),(772.6,-2.949,-95.69),(774.6,-2.152,-96.55),(775.4,-1.566,-94.92),(777.9,-0.2392,-96.17),(775.3,-0.5661,-97.2),(774.7,-1.816,-93.15),(775.5,-0.2347,-92.84),(778.0,-0.05169,-94.08),(772.6,-1.973,-91.57),(768.5,-3.123,-91.12),(768.3,-2.105,-91.81),(770.0,-1.881,-91.04),(767.8,-3.471,-93.72),(767.7,-2.378,-93.98),(768.1,-3.863,-96.07),(768.1,-2.448,-96.24),(772.5,-2.851,-96.89),(769.8,-2.371,-97.01),(775.3,0.1196,-97.24),(778.3,0.7173,-95.24),(775.3,0.4826,-93.25),(768.7,-4.431,-95.15),(768.7,-4.153,-91.71),(768.2,-0.317,-93.95),(768.2,-0.4117,-95.04),(768.8,-0.2514,-94.02),(768.8,-0.3462,-95.11),(782.9,-39.18,-81.03),(786.2,-38.93,-81.55),(789.3,-45.28,-68.12),(786.5,-47.14,-69.18),(790.8,-43.07,-70.93),(791.4,-41.92,-75.66),(782.1,-47.9,-72.68),(802.0,-27.38,-73.58),(803.6,-31.31,-74.13),(799.0,-30.01,-75.9),(802.4,-32.12,-76.61),(802.9,-31.96,-80.53),(799.6,-29.55,-79.63),(801.8,-27.59,-81.97),(805.3,-30.25,-73.08),(804.3,-31.16,-82.42),(806.7,-29.79,-82.44),(804.2,-25.49,-78.61),(808.3,-28.88,-78.9),(807.6,-29.13,-75.29),(805.4,-32.65,-71.95),(804.2,-33.06,-82.65),(806.0,-35.03,-80.95),(807.3,-36.0,-76.86),(806.7,-34.88,-74.36),(797.7,-38.32,-68.56),(796.2,-35.29,-69.8),(796.9,-33.1,-74.13),(796.9,-33.34,-79.28),(797.5,-37.21,-81.27),(798.7,-40.03,-79.69),(799.5,-41.38,-75.72),(798.7,-40.5,-71.62),(787.1,-41.42,-66.92),(789.5,-38.22,-66.59),(780.2,-36.32,-72.56),(791.2,-36.54,-80.16),(784.4,-44.33,-67.08),(783.2,-41.49,-66.77),(779.5,-42.99,-69.61),(780.7,-44.58,-69.93),(779.5,-46.53,-76.35),(778.5,-44.69,-75.99),(780.7,-42.83,-80.57),(778.7,-41.46,-71.0),(778.2,-39.89,-73.96),(777.8,-41.91,-76.79),(779.7,-39.38,-77.55),(779.3,-41.23,-79.33),(781.7,-41.17,-82.15),(796.9,-23.37,-73.33),(795.3,-24.58,-73.92),(794.5,-25.55,-76.87),(794.7,-25.31,-80.38),(796.0,-24.36,-82.19),(797.4,-22.95,-81.63),(798.2,-22.22,-78.96),(798.0,-22.38,-75.32),(789.8,-19.26,-74.68),(788.7,-20.46,-74.92),(788.0,-21.27,-77.32),(788.2,-21.06,-80.17),(789.1,-20.08,-81.84),(790.3,-18.77,-81.28),(791.1,-18.25,-79.12),(790.8,-18.32,-76.22),(783.9,-15.78,-76.54),(783.9,-17.1,-76.11),(783.6,-17.9,-78.14),(783.7,-17.49,-79.51),(783.9,-16.01,-80.7),(783.9,-14.69,-80.41),(783.9,-14.04,-78.77),(784.0,-14.31,-77.41),(782.9,-12.49,-77.2),(782.7,-12.02,-79.11),(782.1,-9.452,-78.89),(781.4,-11.42,-77.18),(782.8,-12.74,-80.62),(781.5,-11.69,-81.57),(782.1,-9.533,-81.0),(782.5,-14.55,-81.63),(782.1,-18.09,-80.73),(781.0,-17.86,-80.31),(781.5,-16.65,-81.52),(781.9,-18.31,-77.95),(780.9,-18.09,-77.98),(782.1,-17.8,-75.69),(781.0,-17.58,-75.86),(783.0,-14.25,-76.19),(781.6,-16.2,-75.55),(780.6,-11.22,-77.33),(781.3,-8.942,-80.16),(780.5,-11.6,-81.31),(783.0,-17.85,-76.52),(782.9,-18.1,-79.97),(778.6,-17.26,-78.75),(778.7,-17.17,-77.65),(778.8,-16.73,-78.85),(778.8,-16.64,-77.76),(797.5,-71.64,-73.2),(793.0,-71.59,-66.71),(792.0,-78.0,-71.25),(794.6,-65.95,-74.41),(797.1,-71.69,-71.95),(796.4,-72.29,-67.64),(795.0,-71.78,-67.17),(797.7,-74.55,-72.47),(796.2,-76.48,-71.92),(793.4,-77.59,-71.45),(798.0,-69.13,-73.86),(796.9,-67.4,-74.21),(796.4,-66.32,-74.45),(789.6,-71.23,-68.25),(790.8,-73.04,-66.76),(785.9,-75.48,-71.46),(787.1,-77.13,-71.13),(790.4,-78.22,-71.09),(787.1,-70.75,-72.72),(789.1,-68.72,-73.35),(791.3,-67.59,-73.79),(792.8,-72.45,-66.32),(791.4,-76.44,-66.68),(791.8,-77.55,-68.5),(793.9,-66.84,-70.5),(793.6,-67.77,-68.94),(793.2,-69.93,-67.23),(796.8,-75.07,-69.81),(795.0,-73.32,-67.02),(793.5,-76.78,-68.39),(797.7,-69.19,-72.99),(795.7,-66.84,-72.19),(795.2,-69.39,-68.52),(787.1,-76.04,-68.04),(788.8,-77.38,-67.63),(789.8,-75.46,-65.89),(791.7,-70.54,-67.59),(792.1,-67.77,-69.95),(794.9,-77.14,-71.67),(797.9,-73.13,-72.86),(797.6,-71.12,-73.34),(797.6,-70.8,-73.42),(797.8,-70.03,-73.63),(797.1,-70.03,-72.78),(797.0,-70.61,-72.8),(798.1,-69.36,-73.81),(797.6,-68.99,-73.87),(797.2,-68.91,-73.86),(797.6,-68.36,-74.02),(796.9,-68.89,-72.68),(797.0,-68.24,-72.27),(796.7,-70.56,-72.43),(796.6,-69.27,-72.15),(795.9,-67.97,-70.87),(795.0,-67.53,-70.2),(795.5,-65.82,-73.08),(797.0,-67.93,-74.09),(796.4,-67.27,-74.21),(796.4,-66.71,-74.35),(796.0,-65.91,-74.52),(792.6,-66.74,-74.08),(796.2,-67.49,-72.43),(797.5,-68.17,-74.06),(797.1,-67.63,-74.17),(796.8,-67.84,-72.24),(797.3,-68.41,-73.2),(796.7,-69.23,-70.4),(797.3,-69.59,-72.69),(798.0,-69.59,-73.21),(796.6,-67.55,-72.4),(797.3,-72.13,-69.08),(796.6,-71.35,-72.35),(795.3,-71.01,-67.51),(797.5,-72.65,-69.14),(796.7,-71.06,-71.0),(797.0,-71.1,-72.74),(796.6,-71.52,-68.81),(796.4,-71.79,-67.76),(796.7,-71.85,-71.1),(797.6,-72.09,-70.85),(796.0,-74.4,-67.91),(795.7,-76.0,-68.91),(795.7,-68.5,-69.63),(790.6,-68.36,-73.54),(797.9,-72.28,-73.07),(795.5,-66.6,-71.79),(797.1,-71.46,-72.67),(797.8,-71.9,-72.06),(797.9,-72.37,-71.53),(795.9,-71.17,-68.67),(796.5,-70.25,-71.24),(795.7,-70.43,-68.68),(796.8,-68.75,-71.96),(785.1,-72.34,-72.18),(786.0,-73.29,-68.4),(788.6,-77.91,-71.04),(786.2,-71.03,-71.78),(785.7,-71.48,-71.66),(785.1,-71.41,-72.42),(784.7,-71.18,-72.44),(783.6,-70.92,-72.43),(782.6,-70.24,-72.54),(781.6,-68.63,-72.86),(779.4,-67.26,-73.05),(779.5,-66.29,-73.3),(779.6,-63.75,-73.93),(780.4,-62.59,-74.31),(782.4,-62.15,-74.49),(783.1,-63.77,-74.17),(785.2,-65.38,-73.91),(786.4,-67.96,-73.36),(785.5,-69.75,-72.86),(786.3,-69.82,-72.89),(786.7,-70.06,-72.85),(781.3,-66.0,-72.43),(783.3,-66.94,-72.32),(786.0,-70.6,-71.92),(782.9,-65.25,-73.01),(781.8,-63.65,-73.32),(783.8,-68.2,-72.35),(784.0,-69.53,-72.22),(785.2,-70.28,-71.83),(781.0,-64.5,-73.11),(784.4,-70.46,-71.89),(785.0,-70.75,-71.85),(785.5,-71.04,-71.8),(789.8,-71.1,-67.25),(789.9,-70.94,-67.43),(790.1,-70.84,-67.65),(790.2,-70.85,-67.75),(790.5,-70.88,-67.9),(790.7,-71.07,-67.92),(790.8,-71.29,-67.74),(789.7,-71.71,-66.85),(790.0,-71.56,-67.09),(790.2,-71.58,-67.25),(790.3,-72.01,-67.48),(790.4,-71.78,-67.72),(790.8,-71.63,-67.64),(789.3,-71.69,-66.57),(789.6,-71.74,-66.7),(789.8,-72.39,-66.85),(790.6,-72.24,-67.32),(790.6,-71.89,-67.37),(789.2,-72.18,-66.18),(789.8,-72.65,-66.69),(790.3,-72.84,-66.95),(790.7,-72.75,-66.94),(789.3,-72.65,-65.94),(789.5,-72.67,-66.08),(790.0,-73.04,-66.15),(790.3,-73.33,-66.61),(790.4,-73.22,-66.79),(789.5,-73.06,-65.81),(790.4,-73.5,-66.29),(790.7,-73.47,-66.51),(790.7,-73.31,-66.84),(791.0,-73.27,-66.68),(789.8,-73.54,-65.72),(790.0,-73.72,-65.72),(790.2,-73.76,-65.86),(790.5,-73.83,-66.01),(790.8,-73.76,-66.26),(791.0,-73.53,-66.55),(789.8,-71.06,-67.01),(789.9,-70.89,-67.2),(790.1,-70.79,-67.41),(790.5,-70.83,-67.67),(790.7,-71.01,-67.68),(789.8,-71.66,-66.61),(790.0,-71.51,-66.86),(790.3,-71.54,-67.01),(789.4,-71.65,-66.34),(789.6,-72.13,-66.18),(789.8,-72.61,-66.46),(789.3,-72.13,-65.95),(789.4,-72.6,-65.71),(789.6,-72.63,-65.84),(790.0,-73.0,-65.91),(790.3,-73.28,-66.38),(789.6,-73.01,-65.58),(790.1,-73.33,-65.78),(790.4,-73.46,-66.05),(790.7,-73.42,-66.28),(789.9,-73.49,-65.49),(790.0,-73.67,-65.49),(790.3,-73.72,-65.63),(790.6,-73.78,-65.77),(790.8,-73.71,-66.02),(791.0,-73.48,-66.31),(792.6,-72.62,-78.82),(797.0,-71.89,-74.33),(796.0,-73.18,-78.05),(794.6,-72.75,-78.56),(789.4,-71.62,-77.09),(790.4,-73.82,-77.79),(792.6,-73.59,-78.74),(791.1,-77.27,-76.32),(791.6,-77.92,-74.38),(793.7,-67.24,-77.51),(793.3,-68.61,-78.62),(792.8,-70.95,-79.15),(797.1,-75.47,-75.1),(794.5,-74.63,-78.07),(793.2,-77.23,-74.79),(797.7,-69.33,-74.62),(795.6,-67.19,-76.25),(794.9,-70.24,-78.45),(786.9,-76.6,-74.61),(788.6,-77.97,-74.58),(789.4,-76.53,-77.49),(791.3,-71.46,-78.31),(791.9,-68.41,-77.46),(797.0,-70.16,-74.33),(797.0,-70.71,-74.02),(796.8,-69.08,-74.96),(796.9,-68.53,-75.68),(796.6,-70.72,-74.35),(796.5,-69.53,-75.24),(795.7,-68.49,-76.99),(794.7,-67.87,-77.62),(795.4,-66.06,-76.08),(796.1,-67.77,-75.77),(796.6,-68.15,-75.86),(797.3,-68.54,-74.75),(796.5,-69.8,-77.01),(797.2,-69.76,-74.66),(797.9,-69.68,-74.25),(796.5,-67.84,-75.82),(797.0,-72.79,-76.87),(796.6,-71.5,-74.04),(794.9,-71.96,-78.65),(797.3,-73.28,-76.6),(796.6,-71.46,-75.42),(797.0,-71.19,-73.84),(796.4,-72.25,-77.22),(796.0,-72.64,-78.06),(796.6,-72.18,-75.0),(797.5,-72.46,-75.25),(795.6,-75.24,-76.56),(795.4,-76.42,-74.97),(795.4,-69.22,-77.67),(795.3,-66.82,-76.64),(797.0,-71.55,-73.75),(797.7,-72.08,-74.21),(797.8,-72.62,-74.5),(795.5,-71.98,-77.39),(796.4,-70.66,-75.47),(795.4,-71.21,-77.87),(796.8,-69.18,-75.68),(785.8,-73.9,-75.46),(786.1,-71.17,-73.35),(785.6,-71.6,-73.18),(781.7,-67.34,-73.92),(783.3,-68.27,-73.79),(785.9,-70.73,-73.39),(783.5,-65.87,-74.67),(781.8,-63.74,-74.88),(784.0,-69.43,-73.39),(785.1,-70.38,-73.41),(780.7,-65.31,-74.55),(784.4,-70.58,-73.29),(784.9,-70.87,-73.26),(785.4,-71.17,-73.23),(789.4,-72.03,-78.12),(789.5,-71.84,-78.04),(789.7,-71.71,-77.91),(789.9,-71.71,-77.82),(790.2,-71.72,-77.7),(790.3,-71.88,-77.62),(790.5,-72.14,-77.57),(789.4,-72.68,-78.2),(789.6,-72.5,-78.07),(789.8,-72.5,-77.94),(790.0,-72.87,-77.53),(790.1,-72.61,-77.43),(790.5,-72.49,-77.69),(788.9,-72.71,-78.42),(789.2,-72.73,-78.31),(789.4,-73.33,-77.87),(790.2,-73.11,-77.6),(790.3,-72.78,-77.76),(788.8,-73.23,-78.54),(789.4,-73.61,-77.9),(790.0,-73.75,-77.63),(788.9,-73.73,-78.55),(789.1,-73.73,-78.44),(789.6,-74.08,-78.26),(789.9,-74.28,-77.72),(790.1,-74.15,-77.62),(789.1,-74.14,-78.5),(790.0,-74.5,-77.95),(790.3,-74.43,-77.79),(790.4,-74.21,-77.47),(790.7,-74.25,-77.82),(789.4,-74.62,-78.4),(789.6,-74.79,-78.33),(789.8,-74.82,-78.21),(790.1,-74.86,-78.08),(790.4,-74.75,-77.92),(790.6,-74.49,-77.78),(789.4,-71.99,-78.38),(789.6,-71.84,-78.29),(789.8,-71.71,-78.16),(790.2,-71.71,-77.95),(790.4,-71.88,-77.88),(790.5,-72.14,-77.82),(789.4,-72.67,-78.45),(789.6,-72.49,-78.32),(789.9,-72.49,-78.2),(789.0,-72.7,-78.67),(789.2,-73.2,-78.61),(788.9,-73.23,-78.79),(789.2,-73.72,-78.69),(788.9,-73.72,-78.81),(789.6,-74.07,-78.51),(790.0,-74.27,-77.97),(789.1,-74.14,-78.76),(789.7,-74.41,-78.49),(790.0,-74.49,-78.21),(790.3,-74.43,-78.05),(790.5,-74.19,-77.77),(789.4,-74.61,-78.66),(789.6,-74.79,-78.59),(789.9,-74.81,-78.46),(790.1,-74.85,-78.33),(790.4,-74.74,-78.17),(790.7,-74.48,-78.03),(793.4,-68.81,-67.89),(793.0,-69.62,-79.14),(781.4,-58.81,-64.97),(790.0,-55.06,-89.69),(857.1,-52.12,-87.4),(864.5,-45.34,-89.51),(866.9,-52.68,-88.07),(855.8,-49.25,-87.38),(856.8,-51.82,-82.11),(858.6,-50.38,-78.72),(861.7,-50.07,-79.45),(860.5,-48.34,-78.64),(866.3,-52.41,-81.49),(862.9,-46.88,-80.82),(863.9,-45.86,-83.86),(858.1,-49.17,-81.28),(866.0,-52.98,-94.37),(856.5,-52.3,-92.96),(858.1,-51.15,-96.26),(861.2,-50.89,-96.52),(859.4,-49.26,-97.59),(861.9,-47.65,-96.91),(863.3,-46.42,-94.42),(857.4,-49.88,-94.22),(863.5,-60.87,-96.48),(855.1,-63.44,-93.07),(860.3,-59.44,-97.74),(855.5,-61.9,-95.17),(857.5,-65.48,-90.12),(859.1,-67.33,-85.05),(856.3,-55.91,-86.56),(856.1,-60.97,-85.79),(867.6,-57.1,-86.97),(866.3,-60.15,-87.61),(869.6,-56.48,-93.54),(869.3,-58.15,-89.8),(868.5,-58.03,-96.24),(867.1,-59.85,-93.6),(868.0,-54.22,-93.34),(859.8,-69.63,-84.56),(856.3,-55.74,-80.53),(857.5,-64.18,-79.81),(857.7,-54.88,-76.53),(864.8,-56.46,-75.43),(863.2,-53.44,-78.06),(869.9,-55.96,-81.76),(869.1,-57.25,-78.58),(868.2,-58.48,-80.33),(869.4,-57.94,-84.95),(866.4,-60.05,-85.59),(864.7,-59.02,-75.61),(867.5,-56.59,-76.34),(867.7,-54.66,-78.16),(868.3,-53.74,-82.37),(865.9,-54.56,-75.76),(866.1,-53.41,-77.38),(867.6,-53.03,-80.93),(860.9,-58.21,-74.96),(858.8,-58.3,-74.8),(860.4,-66.06,-81.28),(858.4,-59.23,-71.51),(861.4,-64.43,-78.87),(861.5,-68.17,-81.92),(860.2,-62.35,-70.8),(860.1,-63.12,-74.19),(863.2,-64.05,-85.67),(863.8,-63.41,-79.93),(865.6,-61.55,-82.31),(864.0,-61.97,-85.91),(865.1,-62.2,-87.87),(861.6,-64.92,-83.75),(863.6,-66.47,-85.5),(862.1,-67.68,-82.93),(861.5,-65.17,-87.28),(862.1,-67.78,-87.2),(863.8,-63.53,-89.34),(867.2,-53.65,-94.97),(866.8,-57.58,-98.57),(867.5,-55.3,-97.4),(860.1,-66.28,-89.63),(861.5,-68.43,-88.46),(856.9,-65.91,-93.67),(855.9,-56.3,-93.21),(858.4,-64.87,-89.06),(857.2,-55.76,-96.68),(864.0,-58.02,-98.63),(862.6,-54.29,-97.32),(865.0,-56.06,-99.27),(865.5,-54.33,-98.37),(855.5,-62.0,-95.68),(869.2,-55.39,-93.46),(869.5,-54.89,-82.08),(869.8,-57.6,-87.35),(860.7,-65.17,-90.5),(858.8,-58.32,-75.35),(855.5,-61.98,-95.7),(864.0,-61.58,-75.97),(862.5,-63.69,-92.59),(857.7,-65.93,-90.23),(860.1,-63.6,-73.83),(859.3,-65.64,-80.64),(859.0,-65.83,-90.8),(860.0,-68.2,-87.11),(860.4,-69.14,-88.08),(859.1,-66.92,-87.15),(860.1,-68.18,-83.12),(860.8,-68.74,-81.82),(859.3,-66.8,-83.28),(859.7,-68.94,-84.7),(863.8,-60.49,-69.65),(860.5,-60.06,-69.3),(860.7,-58.72,-69.71),(863.7,-59.0,-67.07),(865.2,-57.23,-68.82),(865.5,-59.74,-71.65),(863.8,-48.63,-65.82),(866.4,-49.97,-62.94),(864.9,-50.87,-60.9),(862.6,-50.89,-61.14),(860.8,-53.04,-66.19),(866.1,-47.88,-64.34),(865.1,-46.58,-62.47),(862.0,-47.79,-62.2),(869.3,-50.56,-63.36),(869.7,-48.88,-64.71),(879.0,-48.65,-63.42),(878.6,-50.09,-62.71),(869.6,-47.88,-62.83),(879.4,-47.82,-60.29),(869.4,-47.02,-59.4),(868.2,-46.5,-60.63),(864.9,-46.51,-60.8),(865.2,-47.86,-59.09),(879.2,-48.96,-59.26),(869.2,-48.68,-58.66),(879.0,-49.95,-60.14),(869.2,-50.0,-59.69),(865.7,-49.2,-59.04),(865.7,-50.29,-60.41),(882.1,-50.66,-63.16),(882.5,-51.13,-62.48),(883.2,-49.38,-60.5),(880.9,-50.48,-63.59),(880.6,-51.43,-63.09),(882.9,-47.83,-59.08),(884.3,-50.5,-64.12),(884.2,-50.78,-61.62),(884.6,-51.31,-61.75),(883.9,-50.02,-65.33),(883.6,-49.79,-64.5),(884.3,-49.73,-63.83),(883.8,-49.57,-64.95),(884.0,-50.21,-63.59),(883.9,-49.15,-65.28),(883.6,-48.95,-64.45),(884.2,-48.96,-63.22),(884.0,-49.33,-63.21),(883.9,-48.67,-64.7),(883.7,-48.63,-64.18),(883.4,-48.46,-63.35),(884.0,-48.38,-62.46),(883.8,-48.72,-62.36),(883.6,-48.14,-63.67),(884.4,-48.86,-60.31),(884.0,-49.09,-60.78),(883.9,-48.31,-60.33),(883.9,-48.56,-61.15),(883.5,-48.3,-62.15),(883.2,-48.07,-61.71),(883.8,-47.97,-60.68),(883.6,-48.25,-60.69),(883.4,-47.81,-61.91),(884.0,-48.0,-59.63),(882.0,-51.31,-61.57),(883.0,-51.29,-59.67),(882.9,-50.27,-59.0),(882.9,-48.8,-58.93),(884.7,-50.29,-63.66),(884.4,-50.07,-64.44),(884.8,-51.09,-60.7),(884.9,-50.65,-62.53),(884.7,-50.42,-61.29),(885.0,-50.17,-60.48),(885.0,-49.75,-62.17),(884.6,-49.41,-63.4),(884.4,-49.26,-64.1),(884.6,-49.59,-60.84),(884.7,-49.4,-60.0),(884.8,-49.12,-61.16),(884.3,-48.63,-63.05),(884.5,-48.83,-62.45),(884.2,-48.35,-60.76),(884.1,-48.25,-61.28),(884.4,-48.55,-59.82),(884.0,-48.62,-59.17),(883.3,-51.53,-64.66),(883.4,-52.28,-65.9),(883.6,-52.26,-65.35),(882.5,-51.49,-64.97),(883.1,-52.58,-65.56),(882.4,-52.17,-64.57),(881.7,-51.76,-63.79),(882.9,-51.97,-63.74),(883.2,-52.14,-64.18),(883.4,-52.58,-65.09),(862.0,-60.32,-68.87),(859.1,-64.82,-97.48),(857.4,-64.86,-97.2),(855.7,-63.39,-98.85),(858.1,-62.84,-101.2),(858.3,-60.37,-99.99),(860.6,-63.32,-97.67),(849.3,-55.73,-96.94),(850.8,-54.33,-101.1),(850.6,-56.17,-103.1),(849.5,-57.76,-102.2),(851.3,-60.2,-98.09),(848.3,-53.6,-98.43),(846.5,-54.66,-98.71),(846.8,-56.81,-99.24),(850.2,-50.78,-102.4),(848.8,-50.47,-99.94),(845.8,-43.28,-103.0),(847.1,-43.42,-104.8),(847.2,-50.87,-100.7),(843.8,-43.67,-104.9),(845.3,-51.69,-102.7),(845.4,-52.47,-101.0),(845.9,-54.99,-100.1),(846.7,-55.03,-102.7),(844.6,-43.77,-106.8),(846.8,-51.75,-104.8),(846.0,-43.61,-106.9),(848.4,-51.5,-105.0),(848.0,-54.61,-103.9),(849.6,-54.45,-103.6),(845.8,-40.04,-105.9),(845.7,-39.69,-107.0),(843.4,-40.62,-106.6),(846.6,-40.9,-105.2),(847.3,-40.72,-106.6),(842.0,-41.91,-106.1),(844.1,-38.06,-106.2),(844.0,-38.96,-107.6),(844.3,-38.53,-108.3),(844.1,-38.04,-104.6),(844.0,-38.62,-104.8),(843.3,-38.45,-105.6),(843.7,-38.4,-104.4),(843.9,-38.59,-106.1),(843.4,-38.38,-103.8),(843.2,-38.94,-104.1),(842.6,-39.03,-105.3),(843.1,-39.02,-105.5),(842.8,-38.76,-103.8),(842.9,-39.11,-104.0),(842.7,-39.62,-104.3),(842.1,-39.6,-105.2),(842.5,-39.66,-105.4),(842.4,-39.5,-103.9),(842.1,-40.07,-106.7),(842.5,-39.93,-106.3),(841.9,-40.52,-105.8),(842.1,-40.07,-106.1),(842.3,-40.07,-105.0),(842.2,-40.5,-105.0),(841.5,-40.52,-105.8),(841.9,-40.54,-105.9),(841.9,-40.39,-104.7),(841.6,-40.95,-106.0),(845.9,-40.17,-107.7),(844.7,-39.96,-109.2),(843.8,-40.71,-108.7),(842.7,-41.49,-107.2),(843.6,-38.12,-106.5),(843.7,-38.06,-105.6),(843.8,-38.93,-108.9),(843.5,-38.26,-107.8),(843.3,-38.95,-107.8),(842.8,-39.22,-108.3),(842.7,-38.68,-107.2),(842.8,-38.53,-105.8),(842.9,-38.47,-105.0),(842.6,-39.5,-107.2),(842.3,-39.89,-107.6),(842.1,-39.43,-107.2),(842.3,-39.15,-105.1),(842.2,-39.19,-105.8),(841.6,-40.1,-106.3),(841.7,-40.04,-105.9),(841.7,-40.37,-106.7),(841.9,-40.83,-107.0),(846.3,-38.51,-105.5),(847.2,-37.85,-105.3),(846.9,-37.8,-105.7),(846.8,-39.03,-105.2),(847.5,-37.95,-105.8),(847.3,-38.86,-106.2),(847.1,-39.69,-106.4),(846.6,-38.78,-106.7),(846.7,-38.42,-106.5),(847.2,-37.87,-106.2),(858.8,-64.39,-98.97),(860.3,-59.44,-97.76),(855.5,-61.9,-95.19),(864.1,-40.97,-90.12),(861.9,-38.82,-89.55),(852.1,-44.58,-87.31),(854.1,-38.62,-88.16),(857.2,-37.71,-88.58),(853.6,-47.5,-87.14),(859.8,-46.22,-99.64),(857.3,-47.78,-97.24),(861.7,-43.74,-98.19),(862.8,-42.01,-94.24),(853.4,-47.89,-92.56),(860.1,-19.74,-105.7),(862.4,-23.62,-104.3),(857.6,-21.93,-101.6),(861.6,-24.05,-101.3),(862.5,-23.24,-97.79),(858.5,-20.87,-98.38),(860.8,-18.58,-97.57),(863.9,-22.66,-106.3),(863.9,-22.08,-96.72),(866.1,-20.57,-97.93),(862.7,-17.06,-102.3),(867.1,-20.15,-102.1),(866.1,-21.04,-105.2),(865.1,-26.02,-106.1),(865.1,-24.93,-95.41),(867.8,-26.06,-97.02),(869.2,-27.01,-101.0),(867.8,-26.81,-103.6),(862.7,-34.61,-104.9),(859.4,-32.85,-103.8),(858.7,-30.22,-100.5),(859.3,-29.55,-95.57),(862.8,-31.89,-92.59),(865.9,-33.5,-94.16),(867.0,-35.0,-98.12),(865.4,-35.34,-102.0),(858.7,-43.25,-101.2),(856.0,-38.54,-103.3),(856.2,-34.92,-99.36),(855.0,-36.53,-90.52),(857.8,-34.67,-91.38),(855.0,-45.25,-99.88),(855.2,-41.74,-102.1),(850.5,-43.42,-96.84),(851.7,-44.97,-96.18),(851.2,-45.96,-88.96),(850.2,-44.19,-89.8),(851.5,-42.78,-87.48),(852.8,-41.84,-86.65),(849.8,-41.72,-95.92),(852.2,-36.73,-96.74),(849.6,-41.34,-89.98),(854.1,-36.32,-93.3),(851.4,-40.38,-87.8),(854.0,-40.05,-86.04),(854.9,-15.93,-106.6),(853.4,-16.99,-105.2),(852.9,-17.45,-101.7),(853.5,-16.65,-98.54),(854.9,-15.47,-97.54),(856.2,-14.2,-99.03),(856.7,-13.93,-102.1),(856.2,-14.66,-105.4),(848.2,-11.7,-105.7),(847.1,-12.76,-104.7),(846.7,-13.14,-101.9),(847.2,-12.51,-99.32),(848.3,-11.35,-98.36),(849.4,-10.22,-99.74),(850.0,-10.08,-102.2),(849.4,-10.59,-104.9),(843.7,-7.781,-104.6),(843.0,-9.004,-104.3),(842.7,-9.426,-102.1),(843.0,-8.818,-100.8),(843.9,-7.415,-100.4),(844.5,-6.31,-101.3),(844.8,-6.013,-103.1),(844.6,-6.494,-104.4),(844.7,-4.525,-105.3),(844.9,-3.717,-103.7),(845.6,-1.287,-105.0),(843.9,-2.976,-105.8),(844.7,-4.241,-101.9),(844.1,-2.633,-101.5),(845.7,-1.074,-102.9),(843.4,-5.518,-100.2),(841.3,-8.646,-99.52),(840.3,-8.038,-100.1),(841.5,-6.971,-99.42),(840.8,-9.199,-102.1),(840.0,-8.539,-102.2),(841.1,-9.116,-104.5),(840.2,-8.398,-104.5),(843.7,-6.208,-105.5),(841.4,-7.412,-105.4),(843.3,-2.502,-105.8),(845.2,-0.3567,-104.0),(843.3,-2.259,-101.8),(842.0,-9.396,-103.7),(842.1,-9.148,-100.2),(838.6,-6.867,-102.0),(838.6,-6.942,-103.1),(839.0,-6.455,-102.1),(839.0,-6.53,-103.2),(856.1,-36.97,-90.88),(859.4,-37.53,-90.88),(861.8,-45.05,-77.92),(858.9,-46.79,-78.79),(863.3,-42.8,-80.74),(863.6,-41.54,-85.44),(854.3,-47.31,-81.78),(874.4,-22.6,-84.09),(873.5,-27.05,-84.15),(870.3,-23.5,-86.59),(872.1,-27.37,-86.69),(872.7,-27.56,-90.57),(871.2,-23.55,-90.26),(874.4,-23.05,-92.45),(875.6,-26.78,-82.99),(874.4,-27.5,-92.36),(877.4,-27.24,-92.22),(877.6,-22.26,-88.95),(879.1,-26.89,-88.6),(878.2,-26.71,-85.05),(874.8,-29.99,-81.52),(873.5,-30.46,-92.22),(875.6,-32.31,-90.53),(877.1,-33.14,-86.48),(876.4,-32.08,-83.96),(868.5,-36.76,-77.76),(866.2,-34.09,-78.97),(866.2,-31.88,-83.29),(866.2,-32.13,-88.44),(867.6,-35.82,-90.45),(869.6,-38.35,-88.92),(870.8,-39.51,-84.97),(869.9,-38.74,-80.84),(859.9,-41.16,-76.16),(860.6,-37.92,-75.64),(852.9,-35.7,-80.49),(861.6,-36.27,-89.21),(857.1,-43.98,-76.21),(856.0,-41.12,-75.52),(852.1,-42.41,-78.01),(853.2,-44.03,-78.6),(851.5,-45.74,-84.99),(850.6,-43.89,-84.36),(852.6,-41.96,-89.04),(851.3,-40.82,-79.16),(850.7,-39.15,-81.91),(850.1,-41.07,-84.85),(852.0,-38.58,-85.64),(851.4,-40.36,-87.51),(853.6,-40.3,-90.6),(872.9,-16.86,-84.7),(870.8,-17.11,-85.41),(869.6,-17.61,-88.4),(870.0,-17.69,-91.88),(871.8,-17.65,-93.57),(873.9,-17.16,-92.93),(875.0,-16.85,-90.22),(874.6,-16.72,-86.6),(870.4,-10.32,-87.19),(868.7,-10.67,-87.49),(867.6,-11.06,-89.91),(868.0,-11.16,-92.74),(869.5,-10.97,-94.35),(871.4,-10.57,-93.71),(872.4,-10.46,-91.49),(872.0,-10.22,-88.64),(869.6,-5.341,-89.91),(868.2,-5.738,-89.49),(867.2,-6.116,-91.52),(867.7,-6.005,-92.89),(869.4,-5.648,-94.06),(870.9,-5.281,-93.75),(871.6,-5.031,-92.09),(871.3,-5.087,-90.74),(873.1,-3.701,-90.68),(873.7,-3.468,-92.64),(876.4,-2.187,-92.49),(873.9,-2.155,-90.91),(872.8,-3.905,-94.1),(873.7,-2.519,-95.26),(876.3,-2.336,-94.59),(870.7,-4.17,-95.19),(866.5,-4.976,-94.38),(866.5,-3.93,-94.15),(868.0,-3.978,-95.27),(866.1,-4.814,-91.63),(866.1,-3.8,-91.86),(866.7,-4.638,-89.36),(866.6,-3.57,-89.72),(871.0,-4.19,-89.68),(868.4,-3.527,-89.32),(873.9,-1.459,-91.18),(876.7,-1.469,-93.88),(873.5,-1.714,-95.16),(867.0,-5.484,-90.02),(866.7,-5.744,-93.45),(866.6,-1.754,-92.94),(866.6,-1.678,-91.84),(867.2,-1.737,-93.01),(867.3,-1.661,-91.92),(868.5,-71.46,-86.13),(864.3,-71.46,-79.09),(862.8,-77.69,-84.0),(865.7,-65.65,-86.51),(868.1,-71.53,-84.84),(867.6,-72.24,-80.5),(866.3,-71.7,-79.82),(868.5,-74.39,-85.65),(866.9,-76.28,-85.07),(864.2,-77.32,-84.35),(869.1,-68.95,-86.65),(868.0,-67.18,-86.71),(867.5,-66.08,-86.81),(860.9,-70.95,-80.17),(862.1,-72.84,-78.98),(856.8,-74.99,-83.25),(857.9,-76.68,-83.2),(861.1,-77.86,-83.65),(858.2,-70.26,-84.27),(860.2,-68.28,-84.99),(862.5,-67.21,-85.61),(864.1,-72.32,-78.75),(862.5,-76.26,-79.25),(862.7,-77.32,-81.2),(865.3,-66.64,-82.61),(865.0,-67.6,-81.08),(864.5,-69.8,-79.5),(867.8,-74.96,-82.94),(866.3,-73.24,-79.8),(864.5,-76.61,-81.24),(868.8,-69.03,-85.75),(866.9,-66.64,-84.51),(866.5,-69.28,-81.01),(858.2,-75.68,-80.04),(859.8,-77.08,-79.95),(861.0,-75.25,-78.19),(863.0,-70.35,-79.72),(863.4,-67.53,-81.91),(865.7,-76.91,-84.71),(868.7,-72.97,-85.95),(868.5,-70.93,-86.23),(868.6,-70.61,-86.29),(868.8,-69.85,-86.46),(868.1,-69.85,-85.52),(868.0,-70.42,-85.59),(869.1,-69.18,-86.63),(868.6,-68.8,-86.59),(868.2,-68.7,-86.53),(868.6,-68.16,-86.68),(868.0,-68.71,-85.3),(868.2,-68.08,-84.86),(867.7,-70.38,-85.17),(867.7,-69.09,-84.78),(867.1,-67.81,-83.31),(866.3,-67.37,-82.5),(866.7,-65.59,-85.29),(868.1,-67.72,-86.65),(867.5,-67.03,-86.65),(867.5,-66.47,-86.73),(867.2,-65.65,-86.79),(863.7,-66.39,-85.99),(867.4,-67.29,-84.86),(868.6,-67.97,-86.71),(868.2,-67.42,-86.72),(867.9,-67.67,-84.78),(868.4,-68.23,-85.85),(867.9,-69.11,-83.05),(868.3,-69.42,-85.42),(869.0,-69.42,-86.03),(867.8,-67.37,-84.89),(868.4,-72.06,-82.04),(867.6,-71.17,-85.15),(866.6,-70.93,-80.13),(868.6,-72.58,-82.17),(867.8,-70.92,-83.8),(868.0,-70.92,-85.56),(867.8,-71.44,-81.64),(867.6,-71.73,-80.58),(867.8,-71.71,-83.96),(868.7,-71.98,-83.84),(867.1,-74.32,-80.89),(866.6,-75.88,-81.97),(867.0,-68.37,-82.09),(861.7,-67.96,-85.33),(868.8,-72.12,-86.09),(866.7,-66.41,-84.06),(868.0,-71.28,-85.53),(868.8,-71.76,-85.05),(868.9,-72.25,-84.57),(867.1,-71.07,-81.37),(867.6,-70.09,-83.94),(867.0,-70.33,-81.3),(868.0,-68.59,-84.57),(856.1,-71.81,-83.6),(857.2,-72.9,-80.04),(859.4,-77.51,-83.35),(857.3,-70.54,-83.24),(856.8,-70.98,-83.1),(856.2,-70.87,-83.77),(855.8,-70.62,-83.73),(854.7,-70.33,-83.56),(853.7,-69.62,-83.48),(852.7,-67.98,-83.55),(850.6,-66.53,-83.36),(850.7,-65.56,-83.53),(851.0,-63.01,-83.98),(851.8,-61.86,-84.35),(853.8,-61.49,-84.75),(854.4,-63.13,-84.65),(856.4,-64.81,-84.78),(857.5,-67.43,-84.59),(856.6,-69.21,-84.13),(857.4,-69.3,-84.26),(857.7,-69.56,-84.29),(852.6,-65.35,-82.87),(854.6,-66.36,-83.09),(857.1,-70.1,-83.32),(854.3,-64.64,-83.59),(853.2,-63.0,-83.63),(855.0,-67.63,-83.27),(855.2,-68.96,-83.29),(856.3,-69.76,-83.11),(852.4,-63.83,-83.4),(855.5,-69.92,-83.08),(856.1,-70.23,-83.13),(856.6,-70.53,-83.17),(861.1,-70.86,-79.19),(861.2,-70.69,-79.37),(861.4,-70.59,-79.6),(861.6,-70.61,-79.73),(861.8,-70.64,-79.91),(862.0,-70.83,-79.96),(862.1,-71.06,-79.82),(861.1,-71.48,-78.84),(861.3,-71.33,-79.09),(861.5,-71.35,-79.28),(861.6,-71.78,-79.56),(861.7,-71.54,-79.79),(862.1,-71.41,-79.75),(860.7,-71.46,-78.5),(860.9,-71.5,-78.66),(861.1,-72.15,-78.89),(861.9,-72.02,-79.45),(861.9,-71.67,-79.48),(860.6,-71.95,-78.15),(861.1,-72.42,-78.76),(861.6,-72.62,-79.1),(862.0,-72.54,-79.13),(860.7,-72.43,-77.95),(860.9,-72.46,-78.12),(861.3,-72.83,-78.27),(861.6,-73.12,-78.79),(861.7,-73.01,-78.98),(860.8,-72.85,-77.88),(861.7,-73.3,-78.5),(861.9,-73.27,-78.76),(862.0,-73.1,-79.08),(862.3,-73.07,-78.95),(861.1,-73.33,-77.87),(861.3,-73.52,-77.91),(861.5,-73.57,-78.08),(861.8,-73.64,-78.26),(862.1,-73.57,-78.54),(862.3,-73.34,-78.84),(861.2,-70.82,-78.96),(861.3,-70.66,-79.14),(861.5,-70.55,-79.37),(861.9,-70.6,-79.68),(862.0,-70.78,-79.73),(861.2,-71.44,-78.61),(861.4,-71.29,-78.87),(861.6,-71.32,-79.05),(860.8,-71.42,-78.28),(861.0,-71.92,-78.19),(861.2,-72.39,-78.53),(860.7,-71.91,-77.92),(860.7,-72.39,-77.72),(861.0,-72.42,-77.89),(861.4,-72.8,-78.04),(861.6,-73.08,-78.57),(860.9,-72.81,-77.66),(861.5,-73.13,-77.95),(861.7,-73.27,-78.27),(862.0,-73.23,-78.53),(861.2,-73.3,-77.64),(861.4,-73.48,-77.68),(861.6,-73.53,-77.85),(861.9,-73.6,-78.03),(862.1,-73.53,-78.31),(862.3,-73.3,-78.61),(863.2,-72.12,-91.18),(867.9,-71.66,-87.21),(866.6,-72.81,-90.88),(865.2,-72.32,-91.19),(860.1,-71.08,-88.98),(861.0,-73.28,-89.97),(863.1,-73.09,-91.17),(861.6,-76.78,-88.88),(862.2,-77.51,-87.06),(864.6,-66.82,-89.58),(864.1,-68.14,-90.75),(863.4,-70.45,-91.39),(867.7,-75.21,-88.27),(865.0,-74.21,-90.83),(863.8,-76.86,-87.62),(868.7,-69.12,-87.38),(866.5,-66.86,-88.56),(865.6,-69.83,-90.91),(857.6,-76.04,-86.6),(859.2,-77.46,-86.88),(859.9,-75.97,-89.77),(862.0,-70.93,-90.42),(862.7,-67.94,-89.39),(867.9,-69.93,-87.07),(867.9,-70.49,-86.8),(867.8,-68.83,-87.58),(867.9,-68.26,-88.27),(867.5,-70.48,-87.08),(867.4,-69.26,-87.86),(866.5,-68.14,-89.41),(865.5,-67.48,-89.86),(866.5,-65.74,-88.28),(867.0,-67.48,-88.2),(867.6,-67.87,-88.39),(868.3,-68.31,-87.39),(867.3,-69.48,-89.64),(868.2,-69.53,-87.39),(868.9,-69.48,-87.07),(867.5,-67.56,-88.31),(867.7,-72.49,-89.81),(867.5,-71.26,-86.83),(865.5,-71.53,-91.24),(867.9,-72.99,-89.61),(867.4,-71.18,-88.21),(867.9,-70.98,-86.66),(867.0,-71.92,-90.03),(866.6,-72.27,-90.85),(867.4,-71.92,-87.85),(868.2,-72.22,-88.23),(866.2,-74.9,-89.52),(866.0,-76.11,-88.01),(866.2,-68.85,-90.12),(866.2,-66.48,-88.88),(867.9,-71.34,-86.6),(868.6,-71.88,-87.19),(868.6,-72.41,-87.53),(866.1,-71.61,-90.07),(867.2,-70.38,-88.16),(866.1,-70.83,-90.48),(867.7,-68.91,-88.3),(856.5,-73.28,-87.08),(857.1,-70.63,-84.81),(856.6,-71.06,-84.61),(852.9,-66.66,-84.51),(854.5,-67.65,-84.66),(857.0,-70.18,-84.79),(854.7,-65.23,-85.36),(853.1,-63.04,-85.2),(855.0,-68.83,-84.44),(856.1,-69.81,-84.67),(851.9,-64.59,-84.85),(855.4,-69.99,-84.47),(856.0,-70.3,-84.55),(856.4,-70.61,-84.6),(860.1,-71.46,-90.04),(860.2,-71.27,-89.95),(860.4,-71.15,-89.84),(860.6,-71.16,-89.78),(860.9,-71.18,-89.69),(861.0,-71.35,-89.64),(861.1,-71.61,-89.63),(860.0,-72.1,-90.16),(860.2,-71.93,-90.04),(860.5,-71.94,-89.95),(860.6,-72.33,-89.59),(860.8,-72.07,-89.49),(861.1,-71.96,-89.78),(859.6,-72.1,-90.33),(859.8,-72.14,-90.25),(860.0,-72.76,-89.89),(860.9,-72.57,-89.71),(860.9,-72.24,-89.85),(859.4,-72.62,-90.47),(860.0,-73.04,-89.94),(860.6,-73.2,-89.76),(859.5,-73.12,-90.54),(859.7,-73.13,-90.46),(860.1,-73.5,-90.35),(860.5,-73.73,-89.88),(860.7,-73.6,-89.79),(859.6,-73.54,-90.54),(860.5,-73.94,-90.14),(860.9,-73.89,-90.01),(861.0,-73.68,-89.69),(861.3,-73.71,-90.08),(859.9,-74.03,-90.52),(860.1,-74.21,-90.49),(860.3,-74.25,-90.4),(860.6,-74.3,-90.31),(860.9,-74.2,-90.17),(861.2,-73.95,-90.04),(860.1,-71.4,-90.29),(860.2,-71.26,-90.21),(860.5,-71.14,-90.1),(860.9,-71.17,-89.94),(861.0,-71.34,-89.9),(861.2,-71.6,-89.88),(860.0,-72.09,-90.42),(860.3,-71.92,-90.3),(860.5,-71.93,-90.21),(859.6,-72.09,-90.58),(859.8,-72.6,-90.6),(859.4,-72.61,-90.73),(859.7,-73.12,-90.71),(859.5,-73.11,-90.79),(860.2,-73.49,-90.61),(860.5,-73.71,-90.14),(859.7,-73.53,-90.8),(860.3,-73.83,-90.64),(860.6,-73.93,-90.4),(860.9,-73.87,-90.27),(861.0,-73.65,-89.99),(860.0,-74.02,-90.78),(860.1,-74.2,-90.75),(860.4,-74.23,-90.66),(860.7,-74.29,-90.57),(861.0,-74.19,-90.43),(861.2,-73.94,-90.3),(864.8,-68.66,-80.09),(863.7,-69.13,-91.31),(862.5,-52.22,-69.24),(853.2,-58.31,-95.9),(908.6,-79.68,-87.29),(917.3,-74.14,-89.39),(918.1,-81.7,-87.55),(908.0,-76.66,-87.43),(908.3,-79.25,-82.02),(910.4,-78.04,-78.62),(913.4,-78.21,-79.25),(912.6,-76.31,-78.56),(917.6,-81.24,-81.01),(915.3,-75.28,-80.7),(916.6,-74.47,-83.75),(910.2,-76.82,-81.25),(917.3,-81.96,-93.87),(908.1,-79.86,-92.85),(910.0,-79.03,-96.14),(913.0,-79.23,-96.29),(911.6,-77.38,-97.5),(914.5,-76.16,-96.78),(916.0,-75.12,-94.3),(909.5,-77.63,-94.19),(913.3,-89.4,-95.74),(903.4,-87.64,-94.93),(910.4,-87.52,-97.19),(905.9,-87.27,-98.45),(903.6,-91.7,-88.75),(907.4,-94.9,-84.21),(907.0,-83.27,-86.31),(905.8,-88.21,-85.34),(917.9,-86.14,-86.24),(916.0,-88.96,-86.8),(920.1,-85.94,-92.75),(919.4,-87.48,-88.95),(918.8,-87.35,-95.42),(917.0,-88.89,-92.76),(919.0,-83.48,-92.71),(907.6,-97.27,-83.6),(907.0,-83.0,-80.29),(906.4,-91.47,-79.17),(908.5,-82.29,-76.28),(915.1,-84.9,-74.84),(914.2,-81.72,-77.66),(920.4,-85.28,-80.99),(919.2,-86.36,-77.79),(916.4,-88.38,-78.9),(919.5,-87.2,-84.11),(916.1,-88.84,-84.78),(912.3,-89.06,-72.43),(917.7,-85.44,-75.64),(918.4,-83.61,-77.53),(919.2,-82.86,-81.75),(916.6,-83.2,-75.21),(917.0,-82.11,-76.86),(918.7,-82.04,-80.37),(910.9,-86.02,-74.44),(908.8,-85.79,-74.36),(908.9,-93.78,-80.45),(906.7,-85.8,-71.04),(907.3,-92.13,-78.39),(909.5,-96.04,-80.96),(906.9,-89.19,-69.94),(906.6,-90.01,-73.27),(912.1,-92.29,-84.82),(910.1,-91.83,-78.69),(912.7,-90.44,-80.32),(913.3,-90.37,-85.11),(914.4,-90.79,-87.02),(910.3,-92.88,-82.92),(912.0,-94.74,-84.53),(910.2,-95.65,-81.97),(910.2,-93.17,-86.44),(910.3,-95.82,-86.22),(912.8,-91.94,-88.48),(918.4,-82.82,-94.39),(917.2,-86.69,-97.84),(918.4,-84.54,-96.74),(908.6,-94.1,-88.79),(909.5,-96.4,-87.49),(902.7,-91.48,-92.48),(906.7,-83.71,-92.96),(905.1,-91.1,-88.47),(908.1,-83.42,-96.39),(913.2,-87.13,-97.66),(913.7,-82.8,-96.89),(914.9,-85.51,-98.36),(916.6,-83.29,-97.83),(905.8,-87.49,-98.84),(919.9,-84.81,-92.73),(920.2,-84.17,-81.37),(920.0,-86.97,-86.51),(909.5,-93.11,-89.68),(908.8,-85.82,-74.91),(905.8,-87.47,-98.89),(910.4,-90.71,-74.11),(909.0,-92.01,-91.29),(903.5,-92.18,-88.79),(906.5,-90.47,-72.87),(907.8,-93.19,-79.87),(907.6,-93.5,-90.03),(908.1,-95.92,-86.2),(908.3,-96.93,-87.11),(907.5,-94.54,-86.33),(908.2,-95.86,-82.21),(908.7,-96.48,-80.87),(907.7,-94.38,-82.46),(907.7,-96.57,-83.77),(911.0,-88.5,-68.56),(907.9,-88.89,-66.16),(910.5,-86.41,-69.19),(910.5,-90.97,-65.74),(912.9,-90.98,-67.5),(913.0,-88.41,-70.42),(922.0,-89.67,-60.82),(920.9,-92.53,-59.62),(919.1,-91.83,-57.52),(918.7,-90.07,-56.68),(916.2,-87.79,-60.88),(923.8,-91.56,-59.73),(924.4,-90.49,-57.2),(922.1,-88.77,-56.4),(922.7,-95.4,-60.45),(924.7,-94.63,-61.18),(929.4,-101.6,-61.17),(927.6,-101.9,-60.79),(925.5,-94.38,-58.99),(930.2,-101.7,-57.89),(925.9,-94.2,-55.29),(925.9,-92.96,-56.06),(924.3,-90.59,-55.54),(922.9,-91.61,-54.46),(928.8,-102.1,-57.12),(924.1,-95.02,-55.19),(927.7,-102.3,-58.21),(922.9,-95.49,-56.66),(921.8,-92.61,-55.05),(920.8,-92.91,-56.79),(927.2,-105.0,-60.02),(926.4,-105.1,-59.45),(928.9,-105.2,-57.27),(927.7,-104.1,-60.68),(926.7,-103.6,-60.45),(930.7,-104.7,-55.96),(926.5,-107.2,-58.42),(927.1,-106.1,-57.57),(926.4,-106.3,-57.35),(926.7,-107.9,-59.38),(927.3,-107.5,-59.4),(927.4,-107.5,-58.18),(927.3,-107.9,-59.27),(927.1,-107.0,-58.62),(927.6,-108.3,-59.28),(928.2,-108.0,-59.26),(928.4,-107.6,-57.96),(928.1,-107.3,-58.28),(928.3,-108.3,-58.94),(928.5,-108.0,-58.99),(929.1,-107.7,-58.93),(929.2,-107.6,-57.72),(929.0,-107.3,-58.03),(929.2,-108.1,-58.76),(929.3,-106.3,-56.31),(929.1,-106.2,-57.01),(930.1,-106.1,-56.71),(929.5,-106.9,-57.25),(929.6,-107.3,-58.27),(930.0,-107.1,-58.42),(930.3,-106.9,-57.07),(930.1,-106.7,-57.41),(930.2,-107.4,-58.21),(930.5,-105.8,-56.01),(926.4,-104.6,-58.62),(926.6,-104.9,-56.58),(927.8,-104.7,-55.97),(929.6,-104.7,-55.87),(926.8,-107.2,-57.8),(926.8,-107.6,-58.4),(926.7,-106.1,-56.31),(926.7,-106.7,-57.02),(927.4,-106.4,-56.83),(927.7,-106.4,-55.94),(927.7,-107.0,-56.64),(927.7,-107.6,-57.55),(927.7,-107.9,-58.1),(928.4,-106.5,-56.55),(928.7,-106.3,-55.82),(928.6,-106.8,-56.3),(928.7,-107.7,-57.72),(928.6,-107.4,-57.25),(929.7,-106.9,-56.64),(929.7,-107.1,-57.07),(929.7,-106.3,-55.89),(929.8,-105.7,-55.61),(925.8,-105.6,-61.8),(925.1,-105.4,-63.26),(924.9,-105.6,-62.71),(926.3,-105.1,-62.04),(924.9,-105.1,-62.99),(925.6,-104.7,-61.85),(926.2,-104.3,-60.96),(925.4,-105.1,-61.0),(925.2,-105.2,-61.51),(924.7,-105.2,-62.54),(908.6,-90.02,-66.88),(905.2,-91.8,-96.15),(904.0,-90.79,-96.86),(904.8,-89.44,-100.6),(907.0,-91.32,-100.4),(909.3,-89.8,-100.1),(907.6,-91.64,-96.14),(910.0,-82.53,-108.2),(911.9,-84.84,-110.4),(909.9,-85.77,-111.4),(907.8,-85.24,-110.9),(906.0,-85.36,-105.1),(911.7,-82.59,-109.9),(910.4,-81.65,-112.1),(907.9,-82.25,-111.6),(914.8,-85.43,-110.5),(915.3,-83.59,-110.3),(924.0,-83.86,-115.4),(923.6,-85.34,-115.4),(914.8,-82.98,-112.5),(923.6,-83.46,-118.8),(913.9,-82.77,-116.0),(913.0,-82.03,-114.7),(910.0,-81.9,-113.6),(910.0,-83.5,-114.5),(923.3,-84.69,-119.2),(913.8,-84.47,-115.8),(923.3,-85.55,-117.9),(914.0,-85.54,-114.2),(910.5,-84.81,-113.9),(910.7,-85.58,-112.0),(927.0,-86.37,-118.3),(926.9,-86.88,-119.2),(926.6,-85.06,-121.0),(926.4,-86.21,-116.8),(925.7,-87.01,-116.8),(925.9,-83.44,-121.8),(928.1,-87.45,-122.3),(927.3,-86.73,-121.8),(927.1,-87.3,-122.0),(929.1,-87.61,-122.4),(929.1,-87.03,-122.0),(928.6,-86.85,-122.9),(929.3,-87.14,-122.6),(928.3,-86.95,-122.0),(929.8,-87.05,-123.0),(929.7,-86.49,-122.7),(928.9,-86.08,-123.3),(928.7,-86.25,-122.7),(929.9,-86.5,-123.4),(929.8,-86.19,-123.0),(929.7,-85.68,-122.8),(929.1,-85.36,-123.5),(928.9,-85.47,-122.9),(929.9,-85.67,-123.3),(927.4,-84.78,-123.0),(927.5,-85.0,-122.3),(927.4,-84.14,-122.4),(928.4,-84.86,-123.2),(929.2,-85.06,-122.9),(929.4,-84.66,-122.6),(928.6,-84.27,-123.5),(928.5,-84.37,-123.0),(929.5,-84.64,-123.1),(927.0,-83.74,-122.7),(926.0,-87.03,-119.3),(925.8,-86.88,-121.4),(925.5,-85.83,-121.7),(925.7,-84.39,-121.8),(928.0,-87.19,-122.8),(928.5,-87.33,-122.8),(926.6,-86.96,-122.7),(927.2,-87.04,-122.7),(927.3,-86.46,-122.7),(927.0,-86.13,-123.3),(927.6,-86.31,-123.5),(928.5,-86.54,-123.5),(929.0,-86.7,-123.5),(927.4,-85.6,-122.9),(927.0,-85.28,-123.3),(927.6,-85.45,-123.7),(929.0,-85.83,-123.7),(928.6,-85.73,-123.7),(928.1,-84.63,-123.7),(928.6,-84.78,-123.7),(927.2,-84.41,-123.2),(926.6,-84.31,-122.9),(928.0,-87.98,-117.2),(928.0,-88.3,-115.5),(928.0,-88.54,-116.0),(927.7,-87.39,-116.8),(927.6,-88.38,-115.4),(927.0,-87.8,-116.4),(926.6,-87.38,-117.1),(927.2,-88.12,-117.4),(927.4,-88.33,-117.0),(927.5,-88.62,-115.9),(905.5,-91.72,-97.74),(910.4,-87.52,-97.21),(905.9,-87.28,-98.46),(917.9,-69.8,-90.2),(916.7,-69.87,-88.72),(905.3,-71.5,-87.7),(908.5,-65.95,-88.72),(911.8,-65.53,-89.07),(906.2,-74.61,-87.36),(912.8,-74.49,-99.65),(909.9,-75.6,-97.29),(915.1,-72.31,-98.23),(916.5,-70.71,-94.32),(905.9,-75.04,-92.76),(928.3,-61.47,-104.5),(930.8,-64.77,-103.3),(926.4,-64.06,-100.3),(930.1,-65.27,-100.3),(930.9,-64.42,-96.74),(927.1,-62.9,-97.15),(928.9,-60.28,-96.35),(932.2,-63.74,-105.2),(932.3,-63.18,-95.68),(934.4,-61.58,-96.91),(930.3,-58.46,-101.1),(935.3,-61.14,-101.1),(934.3,-62.05,-104.2),(932.0,-66.2,-105.1),(932.1,-64.76,-94.54),(933.3,-67.22,-95.54),(933.7,-69.01,-99.16),(933.1,-68.2,-102.0),(922.6,-70.21,-104.0),(922.2,-66.86,-104.1),(924.1,-64.35,-101.2),(924.8,-63.83,-96.21),(924.5,-67.2,-92.16),(924.9,-70.31,-92.67),(924.4,-72.42,-96.01),(923.3,-72.01,-100.2),(911.7,-72.88,-100.0),(914.4,-68.44,-104.4),(917.8,-65.58,-100.9),(914.5,-64.3,-93.16),(918.5,-65.26,-92.64),(908.2,-72.81,-100.1),(910.7,-70.09,-103.0),(904.1,-70.28,-97.34),(904.9,-71.98,-96.57),(904.1,-72.75,-89.33),(903.5,-70.87,-90.29),(905.1,-69.65,-87.98),(906.6,-68.91,-87.14),(903.7,-68.49,-96.52),(913.1,-63.89,-100.3),(903.5,-67.99,-90.6),(914.5,-64.15,-96.16),(905.4,-67.27,-88.4),(908.1,-67.32,-86.55),(922.1,-58.65,-105.0),(921.0,-59.96,-103.6),(920.7,-60.54,-100.1),(921.2,-59.68,-96.94),(922.3,-58.26,-95.96),(923.1,-56.77,-97.46),(923.5,-56.38,-100.5),(923.1,-57.18,-103.9),(913.9,-55.82,-103.6),(913.3,-57.1,-102.6),(913.1,-57.59,-99.82),(913.4,-56.89,-97.23),(914.1,-55.53,-96.27),(914.8,-54.18,-97.65),(915.3,-53.89,-100.1),(914.8,-54.49,-102.8),(907.7,-53.17,-102.0),(907.7,-54.53,-101.8),(907.7,-55.04,-99.62),(907.7,-54.39,-98.33),(907.8,-52.82,-97.89),(907.9,-51.57,-98.78),(907.9,-51.21,-100.6),(907.9,-51.7,-101.8),(906.0,-50.02,-102.5),(905.7,-49.34,-100.8),(904.6,-46.96,-102.0),(904.4,-49.16,-102.9),(905.9,-49.82,-99.11),(904.4,-48.86,-98.54),(904.6,-46.77,-99.9),(905.9,-51.48,-97.44),(906.2,-55.07,-96.94),(905.1,-55.03,-97.4),(905.3,-53.64,-96.71),(906.1,-55.67,-99.55),(905.0,-55.58,-99.57),(906.0,-55.28,-101.9),(905.0,-55.35,-101.8),(906.4,-51.84,-102.9),(905.3,-53.99,-102.7),(903.6,-49.06,-102.8),(903.7,-46.41,-100.9),(903.5,-48.94,-98.79),(907.0,-55.25,-101.1),(907.0,-55.03,-97.7),(902.8,-54.97,-99.16),(902.8,-55.02,-100.3),(902.9,-54.43,-99.26),(902.9,-54.48,-100.4),(914.9,-65.34,-92.9),(916.5,-67.8,-91.28),(914.6,-73.26,-77.93),(911.4,-74.55,-78.83),(916.6,-71.32,-80.78),(917.2,-70.21,-85.51),(906.8,-74.43,-81.98),(919.0,-46.99,-84.01),(920.2,-51.41,-84.32),(915.5,-49.1,-86.31),(918.9,-52.12,-86.8),(919.4,-52.05,-90.72),(916.2,-48.81,-90.04),(918.9,-47.3,-92.39),(922.0,-50.51,-83.28),(920.9,-51.42,-92.61),(923.5,-50.26,-92.64),(921.7,-45.57,-89.04),(925.1,-49.42,-89.11),(924.4,-49.58,-85.5),(922.7,-53.71,-81.99),(921.3,-54.38,-92.63),(924.1,-55.56,-91.16),(925.9,-55.99,-87.24),(924.9,-55.22,-84.63),(919.3,-61.82,-78.19),(916.1,-59.97,-79.42),(915.2,-57.9,-83.67),(915.2,-58.12,-88.78),(918.1,-61.21,-90.88),(920.9,-63.04,-89.37),(922.6,-63.77,-85.41),(921.4,-63.29,-81.25),(913.5,-69.13,-76.4),(912.0,-65.04,-76.29),(907.9,-62.78,-81.24),(912.7,-63.49,-89.76),(910.2,-71.47,-76.44),(909.7,-68.48,-75.91),(905.6,-69.22,-78.5),(906.4,-70.99,-78.98),(904.4,-72.53,-85.36),(904.0,-70.56,-84.84),(906.4,-69.04,-89.53),(905.2,-67.55,-79.75),(904.9,-65.86,-82.6),(904.0,-67.7,-85.48),(906.4,-65.56,-86.3),(905.5,-67.25,-88.11),(907.7,-67.58,-91.12),(915.0,-42.09,-84.12),(913.2,-42.97,-84.72),(912.1,-43.8,-87.66),(912.5,-43.68,-91.16),(914.0,-43.07,-92.97),(915.8,-41.96,-92.42),(916.7,-41.36,-89.76),(916.5,-41.4,-86.12),(909.8,-36.76,-85.98),(908.3,-37.62,-86.2),(907.4,-38.27,-88.58),(907.7,-38.2,-91.43),(909.0,-37.54,-93.12),(910.6,-36.6,-92.58),(911.5,-36.23,-90.41),(911.1,-36.17,-87.52),(907.2,-32.56,-88.25),(905.9,-33.14,-87.8),(905.0,-33.66,-89.78),(905.4,-33.4,-91.18),(907.0,-32.76,-92.41),(908.4,-32.25,-92.13),(909.1,-31.98,-90.49),(908.8,-32.11,-89.13),(910.4,-30.54,-89.01),(910.9,-30.16,-90.97),(913.4,-28.58,-90.83),(911.0,-28.88,-89.13),(910.1,-30.66,-92.43),(910.8,-29.13,-93.5),(913.3,-28.67,-92.94),(908.0,-31.12,-93.45),(904.0,-32.49,-92.52),(903.8,-31.42,-92.2),(905.3,-31.23,-93.4),(903.6,-32.49,-89.73),(903.4,-31.42,-89.87),(904.3,-32.27,-87.48),(904.0,-31.18,-87.76),(908.5,-31.28,-87.97),(905.7,-30.93,-87.43),(910.9,-28.18,-89.34),(913.6,-27.78,-92.16),(910.4,-28.36,-93.31),(904.6,-33.1,-88.22),(904.4,-33.31,-91.65),(903.6,-29.28,-90.77),(903.7,-29.23,-89.68),(904.2,-29.19,-90.87),(904.3,-29.14,-89.78),(915.7,-100.4,-84.76),(911.6,-99.64,-77.88),(908.8,-105.6,-82.59),(914.3,-94.26,-85.49),(915.4,-100.4,-83.47),(914.6,-100.9,-79.13),(913.5,-100.2,-78.53),(915.2,-103.3,-84.15),(913.2,-104.9,-83.55),(910.3,-105.5,-82.89),(916.9,-98.01,-85.36),(916.2,-96.11,-85.54),(916.0,-94.97,-85.69),(908.3,-98.64,-79.12),(909.0,-100.7,-77.8),(903.5,-102.1,-82.18),(904.2,-103.9,-82.01),(907.2,-105.5,-82.29),(905.8,-97.63,-83.34),(908.3,-96.0,-84.07),(910.7,-95.29,-84.65),(911.2,-100.4,-77.51),(908.8,-104.1,-77.91),(908.8,-105.2,-79.8),(913.6,-95.1,-81.57),(913.1,-95.98,-80.01),(912.1,-98.05,-78.35),(914.3,-103.7,-81.45),(913.1,-101.7,-78.44),(910.6,-104.8,-79.81),(916.6,-98.04,-84.47),(915.2,-95.38,-83.4),(914.2,-97.87,-79.8),(904.7,-102.9,-78.89),(906.0,-104.5,-78.68),(907.5,-102.9,-76.95),(910.5,-98.36,-78.61),(911.6,-95.69,-80.89),(911.8,-105.3,-83.22),(915.7,-101.9,-84.5),(915.9,-99.88,-84.88),(916.0,-99.57,-84.95),(916.4,-98.86,-85.14),(915.7,-98.73,-84.23),(915.5,-99.29,-84.27),(916.9,-98.25,-85.32),(916.5,-97.8,-85.32),(916.1,-97.64,-85.28),(916.6,-97.16,-85.44),(915.8,-97.59,-84.06),(916.2,-96.99,-83.64),(915.2,-99.19,-83.87),(915.5,-97.92,-83.53),(915.1,-96.54,-82.15),(914.4,-95.97,-81.38),(915.3,-94.34,-84.23),(916.1,-96.65,-85.45),(915.7,-95.89,-85.5),(915.8,-95.34,-85.6),(915.7,-94.48,-85.71),(912.1,-94.67,-85.01),(915.5,-96.1,-83.71),(916.6,-96.97,-85.48),(916.3,-96.38,-85.53),(916.0,-96.55,-83.58),(916.4,-97.19,-84.61),(915.7,-97.94,-81.8),(916.0,-98.35,-84.14),(916.7,-98.46,-84.72),(915.9,-96.24,-83.72),(915.5,-100.9,-80.64),(915.0,-99.95,-83.82),(913.9,-99.47,-78.85),(915.6,-101.4,-80.74),(915.2,-99.71,-82.47),(915.4,-99.77,-84.23),(915.1,-100.2,-80.29),(914.8,-100.4,-79.23),(915.0,-100.5,-82.6),(915.8,-100.9,-82.43),(913.7,-102.9,-79.45),(913.0,-104.4,-80.48),(914.8,-97.05,-80.91),(909.8,-95.91,-84.37),(915.9,-101.1,-84.68),(915.1,-95.12,-82.97),(915.4,-100.1,-84.18),(916.0,-100.7,-83.65),(916.0,-101.2,-83.14),(914.4,-99.71,-80.07),(915.2,-98.88,-82.66),(914.4,-98.96,-80.03),(915.9,-97.46,-83.34),(903.4,-98.82,-82.7),(904.3,-100.0,-79.04),(905.5,-104.9,-82.08),(904.9,-97.76,-82.34),(904.3,-98.1,-82.2),(903.7,-97.92,-82.9),(903.4,-97.61,-82.88),(902.4,-97.17,-82.77),(901.6,-96.32,-82.76),(901.0,-94.56,-82.93),(899.2,-92.82,-82.88),(899.5,-91.88,-83.09),(900.3,-89.41,-83.64),(901.3,-88.41,-84.03),(903.4,-88.35,-84.37),(903.6,-90.06,-84.17),(905.3,-92.01,-84.16),(905.8,-94.76,-83.81),(904.5,-96.36,-83.31),(905.2,-96.57,-83.41),(905.6,-96.88,-83.41),(901.4,-91.94,-82.37),(903.1,-93.23,-82.47),(904.8,-97.3,-82.45),(903.2,-91.5,-83.06),(902.4,-89.73,-83.21),(903.2,-94.54,-82.59),(903.2,-95.89,-82.54),(904.1,-96.83,-82.28),(901.5,-90.42,-82.98),(903.3,-96.88,-82.27),(903.8,-97.26,-82.29),(904.2,-97.64,-82.3),(908.5,-98.57,-78.13),(908.7,-98.43,-78.31),(908.9,-98.36,-78.54),(909.0,-98.4,-78.66),(909.3,-98.47,-78.83),(909.4,-98.69,-78.87),(909.5,-98.93,-78.72),(908.4,-99.17,-77.75),(908.6,-99.06,-78.01),(908.8,-99.12,-78.18),(908.8,-99.55,-78.44),(909.0,-99.34,-78.68),(909.4,-99.27,-78.63),(908.0,-99.08,-77.44),(908.2,-99.16,-77.59),(908.2,-99.83,-77.78),(909.0,-99.83,-78.31),(909.2,-99.49,-78.36),(907.8,-99.55,-77.06),(908.2,-100.1,-77.63),(908.6,-100.4,-77.95),(909.0,-100.4,-77.96),(907.7,-100.0,-76.85),(907.9,-100.1,-77.0),(908.3,-100.5,-77.12),(908.5,-100.9,-77.62),(908.7,-100.8,-77.81),(907.8,-100.5,-76.75),(908.5,-101.0,-77.31),(908.8,-101.1,-77.57),(908.9,-100.9,-77.89),(909.2,-100.9,-77.75),(908.0,-101.0,-76.7),(908.1,-101.2,-76.73),(908.4,-101.3,-76.89),(908.6,-101.4,-77.06),(908.9,-101.4,-77.33),(909.1,-101.2,-77.63),(908.6,-98.55,-77.9),(908.7,-98.4,-78.08),(909.0,-98.33,-78.31),(909.3,-98.44,-78.6),(909.4,-98.64,-78.64),(908.4,-99.14,-77.52),(908.7,-99.03,-77.78),(908.9,-99.09,-77.95),(908.1,-99.05,-77.21),(908.2,-99.57,-77.09),(908.2,-100.1,-77.4),(907.8,-99.52,-76.83),(907.8,-100.0,-76.62),(908.0,-100.1,-76.77),(908.4,-100.5,-76.89),(908.6,-100.8,-77.39),(907.9,-100.4,-76.52),(908.4,-100.8,-76.78),(908.6,-101.0,-77.08),(908.9,-101.0,-77.34),(908.1,-101.0,-76.47),(908.2,-101.2,-76.5),(908.4,-101.3,-76.66),(908.7,-101.4,-76.83),(909.0,-101.3,-77.1),(909.2,-101.1,-77.4),(910.5,-100.3,-89.98),(915.2,-100.5,-85.85),(913.7,-101.5,-89.52),(912.5,-100.8,-89.9),(907.7,-98.81,-87.94),(908.1,-101.1,-88.81),(910.2,-101.3,-89.93),(907.9,-104.6,-87.54),(908.3,-105.4,-85.67),(912.9,-95.3,-88.55),(912.2,-96.54,-89.68),(911.1,-98.72,-90.26),(914.3,-104.0,-86.77),(911.8,-102.6,-89.47),(910.1,-105.0,-86.2),(916.4,-98.13,-86.1),(914.8,-95.61,-87.45),(913.3,-98.43,-89.71),(904.1,-103.3,-85.45),(905.3,-104.9,-85.61),(906.4,-103.6,-88.53),(909.6,-98.97,-89.32),(910.9,-96.11,-88.39),(915.6,-98.82,-85.78),(915.4,-99.36,-85.49),(915.6,-97.72,-86.34),(915.9,-97.18,-87.05),(915.0,-99.29,-85.78),(915.2,-98.1,-86.62),(914.6,-96.89,-88.25),(913.7,-96.09,-88.77),(915.0,-94.5,-87.23),(915.2,-96.29,-87.04),(915.7,-96.76,-87.2),(916.2,-97.28,-86.15),(915.1,-98.32,-88.39),(915.9,-98.46,-86.11),(916.6,-98.51,-85.76),(915.6,-96.43,-87.13),(914.8,-101.3,-88.41),(914.8,-100.0,-85.5),(912.9,-100.1,-89.98),(915.0,-101.9,-88.19),(914.8,-99.99,-86.88),(915.3,-99.83,-85.33),(914.3,-100.7,-88.69),(913.8,-101.0,-89.51),(914.6,-100.7,-86.5),(915.4,-101.1,-86.83),(912.8,-103.5,-88.09),(912.4,-104.6,-86.53),(914.1,-97.54,-88.94),(914.6,-95.2,-87.8),(915.3,-100.2,-85.25),(915.8,-100.8,-85.79),(915.7,-101.4,-86.11),(913.5,-100.2,-88.78),(914.8,-99.17,-86.88),(913.6,-99.48,-89.22),(915.5,-97.79,-87.06),(903.6,-100.4,-86.09),(904.8,-97.85,-83.91),(904.1,-98.19,-83.71),(901.4,-93.3,-83.95),(902.7,-94.51,-83.99),(904.7,-97.38,-83.92),(903.5,-92.17,-84.79),(902.4,-89.79,-84.78),(903.1,-95.76,-83.7),(903.9,-96.89,-83.85),(900.9,-91.12,-84.41),(903.2,-96.95,-83.67),(903.7,-97.34,-83.71),(904.1,-97.72,-83.73),(907.6,-99.19,-88.98),(907.7,-99.03,-88.9),(908.0,-98.94,-88.79),(908.1,-98.97,-88.72),(908.4,-99.03,-88.62),(908.5,-99.22,-88.56),(908.6,-99.5,-88.53),(907.3,-99.81,-89.09),(907.6,-99.68,-88.97),(907.9,-99.73,-88.86),(907.9,-100.1,-88.48),(908.1,-99.89,-88.38),(908.5,-99.84,-88.67),(906.9,-99.75,-89.27),(907.1,-99.82,-89.18),(907.2,-100.5,-88.79),(908.1,-100.4,-88.58),(908.2,-100.1,-88.73),(906.7,-100.2,-89.4),(907.2,-100.7,-88.82),(907.7,-101.0,-88.61),(906.6,-100.7,-89.44),(906.8,-100.8,-89.35),(907.2,-101.2,-89.21),(907.5,-101.5,-88.71),(907.7,-101.4,-88.63),(906.7,-101.2,-89.42),(907.5,-101.7,-88.97),(907.8,-101.7,-88.83),(908.0,-101.5,-88.51),(908.3,-101.6,-88.88),(906.9,-101.7,-89.37),(907.0,-101.9,-89.32),(907.2,-102.0,-89.22),(907.5,-102.1,-89.12),(907.8,-102.0,-88.97),(908.1,-101.8,-88.84),(907.6,-99.14,-89.24),(907.7,-99.02,-89.16),(908.0,-98.94,-89.05),(908.4,-99.02,-88.87),(908.5,-99.21,-88.82),(908.6,-99.49,-88.78),(907.4,-99.81,-89.34),(907.6,-99.68,-89.22),(907.9,-99.72,-89.12),(906.9,-99.75,-89.52),(907.0,-100.3,-89.51),(906.7,-100.2,-89.65),(906.9,-100.8,-89.6),(906.6,-100.7,-89.7),(907.2,-101.2,-89.47),(907.5,-101.5,-88.97),(906.7,-101.2,-89.68),(907.2,-101.6,-89.48),(907.5,-101.7,-89.22),(907.8,-101.7,-89.09),(908.0,-101.5,-88.81),(906.9,-101.7,-89.62),(907.0,-101.9,-89.58),(907.3,-102.0,-89.48),(907.5,-102.1,-89.37),(907.9,-102.0,-89.23),(908.2,-101.8,-89.1),(912.6,-96.97,-78.98),(911.7,-97.48,-90.21),(917.7,-88.18,-64.34),(908.8,-84.89,-102.7),(963.5,-87.8,-91.4),(973.4,-83.93,-93.19),(972.3,-91.4,-90.78),(963.6,-84.74,-91.8),(963.2,-87.17,-86.2),(965.3,-86.24,-82.73),(968.3,-86.94,-83.1),(967.9,-84.92,-82.6),(971.7,-90.66,-84.33),(970.9,-84.44,-84.6),(972.4,-83.94,-87.6),(965.5,-85.09,-85.45),(971.6,-91.7,-97.13),(963.1,-88.05,-96.98),(965.3,-87.65,-100.2),(968.2,-88.37,-100.1),(967.3,-86.36,-101.5),(970.4,-85.63,-100.7),(972.1,-84.8,-98.12),(965.1,-86.14,-98.36),(966.0,-98.35,-98.81),(956.2,-93.43,-100.7),(963.7,-96.06,-100.6),(958.9,-94.11,-103.8),(953.9,-96.96,-94.32),(958.6,-102.4,-87.4),(961.1,-91.02,-90.31),(958.7,-95.61,-89.1),(971.0,-95.67,-89.19),(968.5,-98.11,-89.71),(973.4,-96.04,-95.52),(972.2,-97.3,-91.68),(971.9,-97.27,-98.2),(969.7,-98.39,-95.58),(972.9,-93.44,-95.74),(958.2,-104.7,-86.61),(960.9,-90.56,-84.33),(958.3,-98.72,-82.68),(962.4,-90.01,-80.26),(968.2,-93.64,-78.12),(968.2,-90.46,-81.22),(973.5,-95.09,-83.81),(971.9,-95.85,-80.64),(966.0,-97.91,-81.57),(972.2,-96.91,-86.87),(968.5,-97.96,-87.69),(960.4,-97.46,-75.5),(970.7,-94.64,-78.68),(971.9,-93.02,-80.63),(973.0,-92.56,-84.83),(970.1,-92.25,-78.48),(970.8,-91.3,-80.18),(972.6,-91.61,-83.55),(963.8,-94.02,-77.98),(961.8,-93.43,-78.08),(960.2,-101.4,-83.61),(957.6,-91.94,-76.07),(955.8,-98.42,-83.8),(960.3,-103.8,-83.91),(956.1,-95.07,-74.97),(955.8,-95.86,-78.33),(963.8,-100.7,-87.81),(958.5,-99.02,-83.06),(961.7,-98.53,-83.46),(965.5,-98.99,-88.14),(966.5,-99.64,-89.93),(961.9,-100.9,-86.02),(963.1,-103.0,-87.37),(961.1,-103.5,-84.89),(961.8,-101.3,-89.52),(961.2,-103.8,-89.12),(964.8,-100.5,-91.43),(972.5,-92.74,-97.51),(970.6,-96.43,-100.8),(972.2,-94.49,-99.73),(960.1,-102.0,-91.93),(960.4,-104.3,-90.4),(953.5,-96.62,-98.22),(960.8,-91.59,-96.94),(955.7,-96.61,-93.79),(962.4,-91.64,-100.3),(965.6,-96.17,-101.0),(968.1,-92.01,-100.4),(967.8,-95.15,-101.4),(970.7,-92.99,-101.1),(958.8,-94.32,-104.2),(973.5,-94.89,-95.6),(973.5,-93.98,-84.29),(972.8,-96.84,-89.24),(961.2,-101.2,-92.82),(961.8,-93.47,-78.63),(958.8,-94.3,-104.2),(958.3,-98.32,-78.21),(958.9,-99.14,-95.55),(953.6,-97.38,-94.38),(955.4,-96.21,-77.97),(959.3,-100.7,-83.15),(959.3,-101.2,-93.28),(959.1,-103.6,-89.27),(959.1,-104.6,-90.08),(958.9,-102.1,-89.52),(959.1,-103.4,-85.28),(959.3,-104.1,-83.86),(958.9,-101.9,-85.67),(958.4,-104.1,-86.83),(960.0,-95.79,-72.63),(955.8,-96.18,-70.24),(963.2,-94.18,-72.74),(957.8,-98.85,-69.88),(959.9,-99.37,-72.13),(962.0,-96.47,-73.99),(969.9,-99.57,-67.65),(968.8,-102.4,-65.93),(967.1,-101.4,-63.72),(967.0,-99.57,-62.88),(964.6,-96.92,-66.51),(972.4,-101.3,-66.02),(972.6,-99.77,-64.11),(970.4,-98.51,-63.43),(973.0,-105.3,-64.66),(974.6,-104.1,-65.87),(982.0,-108.6,-62.16),(980.6,-109.4,-61.44),(975.1,-103.3,-63.97),(982.5,-107.7,-59.14),(975.2,-102.3,-60.58),(974.8,-101.4,-61.95),(972.4,-99.64,-62.45),(971.4,-100.7,-60.88),(981.4,-108.3,-58.09),(973.9,-103.6,-59.94),(980.6,-109.1,-58.86),(973.0,-104.6,-61.02),(970.7,-102.0,-60.91),(969.9,-102.8,-62.39),(981.7,-111.9,-57.78),(980.8,-112.2,-57.19),(983.1,-110.5,-55.77),(981.9,-111.1,-59.08),(980.8,-111.0,-59.27),(984.4,-109.1,-55.48),(981.5,-112.9,-54.05),(981.9,-111.9,-54.82),(981.2,-112.1,-54.43),(981.9,-113.7,-53.79),(982.4,-113.4,-54.25),(982.4,-112.8,-53.5),(982.5,-113.6,-53.64),(982.1,-112.8,-54.41),(982.8,-113.8,-53.11),(983.3,-113.5,-53.57),(983.3,-112.7,-53.19),(983.1,-112.7,-53.74),(983.4,-113.6,-52.89),(983.7,-113.4,-53.29),(984.1,-113.1,-53.68),(984.2,-112.4,-53.08),(983.9,-112.4,-53.69),(984.3,-113.2,-53.09),(984.0,-110.9,-53.84),(983.8,-111.2,-54.5),(984.6,-110.6,-54.59),(984.3,-111.7,-53.7),(984.5,-112.5,-53.77),(985.0,-112.4,-54.06),(985.0,-111.6,-53.46),(984.8,-111.6,-53.98),(985.1,-112.4,-53.55),(984.8,-110.1,-54.39),(980.6,-111.5,-56.83),(980.9,-110.9,-55.0),(981.8,-110.2,-54.89),(983.3,-109.5,-55.19),(981.7,-112.6,-53.63),(981.9,-113.1,-53.52),(981.4,-111.5,-53.84),(981.5,-111.9,-53.84),(982.2,-111.7,-53.93),(982.4,-111.3,-53.32),(982.4,-111.8,-53.16),(982.7,-112.6,-52.98),(982.7,-113.0,-52.92),(983.2,-111.4,-53.8),(983.3,-110.9,-53.49),(983.4,-111.4,-53.12),(983.7,-112.6,-52.85),(983.5,-112.2,-52.95),(984.5,-111.4,-53.25),(984.5,-111.8,-53.2),(984.3,-110.6,-53.63),(984.0,-110.0,-54.12),(980.7,-113.2,-59.17),(980.2,-113.4,-60.81),(980.0,-113.5,-60.22),(981.1,-112.7,-59.64),(979.8,-113.1,-60.82),(980.3,-112.4,-59.87),(980.7,-111.8,-59.14),(980.1,-112.7,-58.84),(980.0,-112.9,-59.28),(979.6,-113.2,-60.31),(956.1,-97.44,-70.97),(956.0,-97.9,-101.2),(955.5,-96.63,-102.3),(957.2,-95.98,-105.9),(958.4,-98.34,-104.9),(961.1,-97.58,-104.1),(958.3,-98.52,-100.6),(965.8,-91.75,-112.7),(966.8,-94.63,-113.9),(964.7,-95.01,-115.4),(962.9,-93.86,-115.7),(960.6,-92.94,-110.5),(967.5,-92.44,-113.8),(967.0,-91.41,-116.4),(964.4,-91.2,-116.7),(969.2,-96.03,-113.0),(970.4,-94.43,-112.9),(978.8,-97.8,-114.8),(977.7,-99.0,-114.7),(970.6,-93.95,-115.2),(979.1,-97.66,-118.3),(970.3,-93.81,-119.0),(969.6,-92.75,-118.1),(966.7,-91.66,-118.0),(966.1,-93.22,-118.7),(978.3,-98.7,-118.6),(969.4,-95.34,-118.5),(977.7,-99.36,-117.3),(968.9,-96.24,-116.7),(966.0,-94.53,-117.8),(965.6,-95.14,-115.8),(980.0,-101.3,-115.6),(979.6,-101.8,-116.4),(981.0,-100.7,-118.8),(979.4,-100.6,-114.7),(978.3,-100.9,-114.8),(981.8,-99.28,-120.3),(980.3,-103.5,-118.6),(980.4,-102.4,-118.6),(979.8,-102.8,-118.8),(980.9,-104.2,-118.3),(981.3,-103.7,-118.1),(981.2,-103.4,-119.2),(981.5,-104.0,-118.5),(980.8,-103.2,-118.4),(981.9,-104.3,-118.8),(982.3,-103.8,-118.6),(982.1,-103.1,-119.6),(981.8,-103.1,-119.1),(982.4,-104.0,-119.2),(982.6,-103.7,-119.0),(982.9,-103.2,-118.9),(982.9,-102.8,-119.9),(982.6,-102.7,-119.4),(983.2,-103.4,-119.3),(982.0,-101.3,-120.3),(981.9,-101.4,-119.5),(982.5,-100.7,-119.9),(982.7,-102.0,-120.0),(983.2,-102.6,-119.3),(983.6,-102.3,-119.1),(983.4,-101.7,-120.4),(983.2,-101.6,-119.9),(983.8,-102.5,-119.5),(982.5,-100.3,-120.5),(978.9,-101.6,-117.0),(979.0,-101.7,-119.0),(979.7,-100.9,-119.8),(980.9,-99.92,-120.2),(980.5,-103.3,-119.2),(980.8,-103.7,-119.0),(979.8,-102.5,-119.7),(980.1,-102.8,-119.4),(980.6,-102.4,-119.6),(980.7,-102.1,-120.4),(981.0,-102.6,-120.2),(981.4,-103.2,-119.9),(981.6,-103.6,-119.6),(981.4,-101.9,-120.0),(981.4,-101.5,-120.6),(981.7,-102.0,-120.7),(982.4,-103.1,-120.0),(982.2,-102.8,-120.2),(982.8,-101.7,-120.7),(983.0,-102.1,-120.3),(982.2,-101.0,-120.7),(981.8,-100.5,-120.7),(979.3,-102.8,-113.6),(978.9,-102.6,-111.9),(978.7,-102.9,-112.3),(979.5,-102.1,-113.6),(978.5,-102.4,-112.1),(978.7,-102.0,-113.5),(978.8,-101.7,-114.5),(978.6,-102.5,-114.2),(978.5,-102.6,-113.6),(978.3,-102.6,-112.4),(956.5,-98.02,-102.7),(963.7,-96.06,-100.6),(958.9,-94.11,-103.8),(975.0,-79.79,-94.25),(973.5,-79.26,-93.04),(962.2,-79.23,-92.64),(966.7,-74.4,-93.77),(970.0,-74.54,-93.89),(962.3,-82.43,-92.01),(969.2,-83.78,-103.8),(966.0,-84.31,-101.6),(971.9,-82.0,-102.3),(973.6,-80.57,-98.4),(962.1,-82.96,-97.39),(990.6,-68.81,-109.1),(989.1,-72.8,-107.3),(986.7,-68.81,-105.5),(988.0,-72.5,-104.5),(989.0,-72.18,-100.8),(988.0,-68.35,-102.2),(991.4,-67.87,-100.9),(991.0,-73.06,-108.9),(990.9,-72.12,-99.46),(993.8,-72.37,-100.2),(994.3,-68.05,-105.3),(995.1,-72.88,-104.1),(993.9,-73.12,-107.5),(989.0,-75.92,-108.6),(989.2,-74.45,-98.02),(989.9,-77.05,-98.95),(990.2,-78.87,-102.6),(989.7,-78.02,-105.4),(979.3,-79.47,-108.0),(979.0,-76.11,-108.0),(980.9,-73.7,-105.0),(981.5,-73.24,-99.96),(981.0,-76.64,-96.0),(981.4,-79.77,-96.58),(980.9,-81.82,-100.0),(979.9,-81.34,-104.2),(968.6,-81.78,-104.8),(971.5,-77.38,-108.7),(974.8,-74.74,-104.9),(971.7,-73.53,-97.13),(975.3,-74.58,-96.62),(965.1,-81.38,-104.7),(967.9,-78.86,-107.5),(961.6,-78.13,-102.4),(962.0,-79.91,-101.5),(960.8,-80.31,-94.26),(960.7,-78.4,-95.4),(962.5,-77.4,-93.05),(964.1,-76.91,-92.14),(961.7,-76.3,-101.8),(970.4,-72.89,-104.3),(961.4,-75.6,-95.9),(971.6,-73.3,-100.1),(963.4,-75.15,-93.61),(965.9,-75.6,-91.55),(989.7,-63.08,-111.1),(987.7,-63.02,-109.9),(986.8,-62.89,-106.6),(987.6,-62.44,-103.4),(989.5,-62.29,-102.1),(991.5,-62.11,-103.3),(992.4,-62.36,-106.3),(991.6,-62.79,-109.7),(987.9,-56.1,-111.5),(986.2,-56.28,-110.7),(985.4,-56.19,-108.1),(986.1,-55.84,-105.4),(987.7,-55.49,-104.3),(989.5,-55.34,-105.4),(990.2,-55.66,-107.7),(989.6,-55.88,-110.5),(987.3,-50.5,-111.3),(985.8,-51.1,-111.2),(985.1,-51.17,-109.0),(985.7,-50.8,-107.7),(987.4,-50.1,-107.2),(988.8,-49.62,-108.0),(989.3,-49.58,-109.7),(988.9,-49.92,-111.0),(990.2,-48.2,-111.9),(990.8,-47.58,-110.2),(993.1,-45.98,-111.4),(990.7,-46.6,-112.5),(990.2,-47.85,-108.5),(990.8,-46.24,-108.2),(993.2,-45.77,-109.3),(988.3,-48.27,-107.0),(984.4,-49.77,-106.7),(984.0,-48.88,-107.4),(985.6,-48.52,-106.5),(983.8,-50.1,-109.3),(983.5,-49.19,-109.5),(984.3,-50.22,-111.7),(983.9,-49.26,-111.8),(988.4,-49.16,-112.3),(985.6,-49.03,-112.5),(990.5,-45.93,-112.6),(993.4,-44.98,-110.5),(990.4,-45.56,-108.6),(984.7,-50.85,-110.7),(984.7,-50.54,-107.3),(983.5,-47.17,-109.5),(983.5,-47.27,-110.6),(984.1,-47.03,-109.6),(984.1,-47.13,-110.7),(972.0,-74.58,-96.94),(973.4,-77.11,-95.45),(970.6,-82.26,-82.03),(967.2,-83.01,-83.09),(973.1,-80.78,-84.85),(974.2,-79.95,-89.59),(962.8,-82.2,-86.6),(987.4,-61.51,-88.52),(986.5,-65.9,-88.6),(983.3,-62.38,-91.03),(985.1,-66.19,-91.16),(985.7,-66.39,-95.03),(984.2,-62.43,-94.71),(987.4,-61.95,-96.89),(988.6,-65.67,-87.43),(987.4,-66.36,-96.8),(990.4,-66.17,-96.65),(990.7,-61.18,-93.38),(992.1,-65.86,-93.02),(991.2,-65.66,-89.48),(987.5,-68.66,-86.0),(986.3,-69.05,-96.72),(988.1,-71.1,-94.96),(989.3,-72.08,-90.86),(988.8,-70.93,-88.37),(980.0,-74.45,-82.35),(978.2,-71.55,-83.81),(978.8,-69.44,-88.18),(978.8,-69.75,-93.3),(979.6,-73.64,-95.12),(981.1,-76.37,-93.38),(982.0,-77.6,-89.31),(981.1,-76.65,-85.25),(970.5,-77.99,-80.87),(971.8,-74.46,-80.74),(966.6,-70.96,-86.57),(973.6,-73.38,-94.26),(966.6,-79.71,-81.02),(966.8,-76.69,-80.73),(962.8,-76.8,-83.58),(963.1,-78.67,-83.88),(961.1,-80.03,-90.3),(961.1,-78.02,-89.95),(963.9,-77.07,-94.54),(962.8,-75.12,-84.98),(963.1,-73.51,-87.95),(961.8,-75.24,-90.77),(964.7,-73.58,-91.54),(963.4,-75.13,-93.31),(965.6,-75.92,-96.12),(986.0,-55.74,-89.13),(983.9,-55.98,-89.83),(982.7,-56.48,-92.82),(983.1,-56.56,-96.3),(984.9,-56.52,-98.0),(987.0,-56.04,-97.36),(988.1,-55.73,-94.64),(987.7,-55.6,-91.03),(983.5,-49.16,-91.58),(981.8,-49.51,-91.87),(980.7,-49.89,-94.29),(981.1,-49.98,-97.12),(982.6,-49.79,-98.73),(984.5,-49.4,-98.11),(985.4,-49.29,-95.9),(985.1,-49.06,-93.04),(982.8,-44.27,-94.19),(981.3,-44.61,-93.75),(980.4,-44.9,-95.74),(980.8,-44.76,-97.14),(982.5,-44.38,-98.36),(984.0,-44.08,-98.07),(984.7,-43.94,-96.41),(984.4,-44.05,-95.06),(986.3,-42.74,-94.87),(986.9,-42.43,-96.81),(989.7,-41.26,-96.62),(987.3,-41.22,-94.92),(986.0,-42.76,-98.3),(987.0,-41.35,-99.3),(989.6,-41.3,-98.73),(983.8,-42.88,-99.33),(979.6,-43.61,-98.45),(979.6,-42.56,-98.08),(981.2,-42.6,-99.27),(979.3,-43.55,-95.67),(979.3,-42.52,-95.76),(980.0,-43.48,-93.41),(979.9,-42.41,-93.63),(984.3,-43.2,-93.87),(981.7,-42.46,-93.29),(987.3,-40.51,-95.09),(990.0,-40.49,-97.92),(986.8,-40.55,-99.07),(980.1,-44.3,-94.18),(979.8,-44.45,-97.61),(979.9,-40.44,-96.51),(980.0,-40.43,-95.41),(980.5,-40.45,-96.61),(980.6,-40.43,-95.52),(965.4,-109.2,-86.92),(961.3,-107.6,-80.44),(957.3,-113.1,-84.95),(965.5,-103.0,-88.17),(965.1,-109.1,-85.66),(964.1,-109.4,-81.35),(963.1,-108.4,-80.89),(964.2,-111.9,-86.16),(961.9,-113.1,-85.6),(958.8,-113.2,-85.14),(967.1,-107.1,-87.59),(966.9,-105.1,-87.95),(967.0,-104.0,-88.2),(958.4,-106.1,-82.0),(958.6,-108.1,-80.49),(953.0,-108.7,-85.19),(953.3,-110.6,-84.85),(955.7,-112.7,-84.78),(956.4,-104.8,-86.47),(959.2,-103.6,-87.12),(961.8,-103.4,-87.55),(960.7,-108.3,-80.04),(957.6,-111.4,-80.38),(957.4,-112.6,-82.19),(964.5,-103.6,-84.26),(963.7,-104.3,-82.69),(962.3,-106.1,-80.97),(963.1,-112.1,-83.51),(962.4,-109.8,-80.73),(959.3,-112.5,-82.09),(966.8,-107.0,-86.72),(966.1,-104.2,-85.94),(964.4,-106.3,-82.26),(953.8,-109.6,-81.76),(954.7,-111.4,-81.34),(956.5,-110.0,-79.61),(960.6,-106.1,-81.33),(962.4,-103.8,-83.71),(960.4,-113.3,-85.35),(965.0,-110.7,-86.56),(965.7,-108.7,-87.05),(965.9,-108.4,-87.14),(966.5,-107.8,-87.35),(965.8,-107.6,-86.5),(965.5,-108.1,-86.52),(967.1,-107.3,-87.53),(966.8,-106.8,-87.59),(966.5,-106.6,-87.59),(967.1,-106.2,-87.75),(966.2,-106.5,-86.41),(966.6,-105.9,-86.0),(965.2,-107.9,-86.16),(965.8,-106.7,-85.88),(965.7,-105.3,-84.62),(965.1,-104.5,-83.95),(966.4,-103.2,-86.84),(966.7,-105.6,-87.82),(966.5,-104.8,-87.96),(966.8,-104.3,-88.09),(966.8,-103.4,-88.28),(963.3,-103.0,-87.84),(966.2,-104.9,-86.18),(967.1,-106.0,-87.8),(967.0,-105.4,-87.91),(966.6,-105.5,-85.98),(966.8,-106.2,-86.93),(965.9,-106.7,-84.13),(966.2,-107.2,-86.41),(966.8,-107.5,-86.93),(966.6,-105.1,-86.15),(965.0,-109.5,-82.79),(964.8,-108.6,-86.07),(963.7,-107.8,-81.23),(965.0,-110.1,-82.85),(965.0,-108.4,-84.72),(965.2,-108.5,-86.46),(964.7,-108.8,-82.53),(964.3,-108.9,-81.48),(964.6,-109.1,-84.82),(965.3,-109.6,-84.56),(962.7,-111.2,-81.61),(961.6,-112.5,-82.6),(965.2,-105.7,-83.37),(960.7,-103.8,-87.3),(965.4,-109.9,-86.78),(966.0,-103.9,-85.54),(965.1,-108.9,-86.38),(965.6,-109.5,-85.77),(965.4,-110.0,-85.23),(964.1,-108.2,-82.39),(965.2,-107.6,-84.97),(964.4,-107.4,-82.4),(966.2,-106.3,-85.69),(953.7,-105.5,-85.94),(954.1,-106.7,-82.14),(954.2,-111.8,-84.74),(955.4,-104.7,-85.54),(954.7,-104.9,-85.42),(954.2,-104.7,-86.18),(954.0,-104.3,-86.21),(953.1,-103.7,-86.2),(952.5,-102.8,-86.31),(952.3,-100.9,-86.65),(951.0,-98.93,-86.86),(951.5,-98.06,-87.11),(952.9,-95.79,-87.77),(954.2,-95.01,-88.14),(956.2,-95.31,-88.32),(956.1,-97.02,-87.99),(957.2,-99.2,-87.71),(957.0,-102.0,-87.13),(955.4,-103.3,-86.63),(956.0,-103.6,-86.65),(956.3,-104.0,-86.62),(953.3,-98.42,-86.24),(954.7,-99.98,-86.12),(955.4,-104.3,-85.69),(955.2,-98.31,-86.82),(954.9,-96.46,-87.14),(954.5,-101.3,-86.13),(954.2,-102.6,-86.0),(954.8,-103.7,-85.6),(953.8,-96.98,-86.94),(954.0,-103.6,-85.66),(954.4,-104.0,-85.61),(954.7,-104.5,-85.56),(958.6,-106.0,-80.99),(958.8,-105.9,-81.18),(959.0,-105.9,-81.39),(959.2,-105.9,-81.49),(959.4,-106.0,-81.64),(959.5,-106.3,-81.66),(959.5,-106.5,-81.48),(958.3,-106.5,-80.59),(958.6,-106.5,-80.84),(958.8,-106.6,-80.99),(958.7,-107.0,-81.21),(958.9,-106.8,-81.46),(959.3,-106.8,-81.38),(957.9,-106.4,-80.31),(958.1,-106.5,-80.44),(958.0,-107.2,-80.59),(958.8,-107.3,-81.05),(959.0,-107.0,-81.11),(957.6,-106.8,-79.92),(957.9,-107.4,-80.43),(958.3,-107.8,-80.68),(958.7,-107.8,-80.67),(957.5,-107.3,-79.68),(957.6,-107.4,-79.81),(957.9,-107.8,-79.88),(958.0,-108.2,-80.34),(958.2,-108.2,-80.52),(957.4,-107.7,-79.55),(958.0,-108.4,-80.01),(958.3,-108.5,-80.24),(958.4,-108.3,-80.57),(958.7,-108.4,-80.41),(957.5,-108.2,-79.45),(957.6,-108.5,-79.45),(957.8,-108.6,-79.59),(958.0,-108.7,-79.73),(958.3,-108.8,-79.98),(958.6,-108.6,-80.27),(958.7,-106.0,-80.76),(958.9,-105.9,-80.94),(959.1,-105.8,-81.16),(959.5,-106.0,-81.41),(959.5,-106.2,-81.42),(958.4,-106.5,-80.36),(958.6,-106.5,-80.6),(958.9,-106.6,-80.75),(958.0,-106.4,-80.08),(958.0,-106.9,-79.92),(958.0,-107.4,-80.19),(957.7,-106.8,-79.69),(957.5,-107.2,-79.44),(957.7,-107.3,-79.58),(957.9,-107.8,-79.64),(958.1,-108.2,-80.1),(957.5,-107.7,-79.31),(957.9,-108.2,-79.51),(958.1,-108.4,-79.78),(958.4,-108.4,-80.01),(957.6,-108.2,-79.22),(957.6,-108.4,-79.22),(957.8,-108.6,-79.36),(958.0,-108.7,-79.5),(958.3,-108.7,-79.75),(958.6,-108.6,-80.04),(960.5,-108.4,-92.55),(964.9,-109.3,-88.04),(963.3,-110.1,-91.75),(962.3,-109.2,-92.28),(958.0,-106.4,-90.83),(957.9,-108.7,-91.51),(960.0,-109.3,-92.45),(956.9,-112.1,-90.02),(957.0,-112.9,-88.07),(964.0,-103.9,-91.26),(963.0,-105.0,-92.37),(961.4,-106.9,-92.88),(963.2,-112.5,-88.79),(961.2,-110.9,-91.77),(958.8,-112.8,-88.48),(966.7,-107.1,-88.35),(965.8,-104.4,-90.0),(963.7,-107.0,-92.18),(953.4,-110.1,-88.33),(954.2,-111.9,-88.28),(955.7,-110.9,-91.2),(959.9,-106.9,-92.05),(961.8,-104.3,-91.21),(965.7,-107.7,-88.05),(965.4,-108.2,-87.74),(966.0,-106.6,-88.69),(966.4,-106.1,-89.42),(965.0,-108.0,-88.07),(965.5,-106.9,-88.97),(965.3,-105.7,-90.72),(964.6,-104.8,-91.37),(966.2,-103.4,-89.84),(966.0,-105.2,-89.52),(966.3,-105.7,-89.6),(966.7,-106.3,-88.48),(965.4,-107.2,-90.74),(966.1,-107.4,-88.38),(966.8,-107.5,-87.98),(966.3,-105.4,-89.56),(964.4,-110.1,-90.57),(964.6,-108.7,-87.76),(962.9,-108.6,-92.37),(964.4,-110.6,-90.3),(964.7,-108.7,-89.14),(965.2,-108.6,-87.56),(964.1,-109.4,-90.93),(963.6,-109.6,-91.77),(964.3,-109.4,-88.72),(965.0,-109.9,-88.96),(962.0,-111.8,-90.26),(961.2,-112.8,-88.66),(964.7,-106.3,-91.41),(965.7,-104.0,-90.39),(965.0,-108.9,-87.46),(965.4,-109.7,-87.92),(965.2,-110.2,-88.21),(963.4,-108.8,-91.11),(964.9,-107.9,-89.19),(963.7,-108.1,-91.59),(965.9,-106.7,-89.41),(953.7,-107.2,-89.2),(955.3,-104.8,-87.11),(954.6,-105.0,-86.93),(953.1,-99.8,-87.72),(954.1,-101.2,-87.58),(955.3,-104.4,-87.16),(955.4,-99.07,-88.47),(954.9,-96.56,-88.7),(954.1,-102.5,-87.17),(954.7,-103.7,-87.17),(953.1,-97.6,-88.37),(953.9,-103.7,-87.05),(954.3,-104.1,-87.03),(954.6,-104.6,-86.99),(957.9,-106.8,-91.86),(958.0,-106.6,-91.78),(958.3,-106.6,-91.65),(958.5,-106.6,-91.56),(958.7,-106.7,-91.44),(958.7,-106.9,-91.36),(958.7,-107.2,-91.3),(957.5,-107.3,-91.94),(957.8,-107.2,-91.8),(958.0,-107.3,-91.68),(958.0,-107.7,-91.26),(958.2,-107.5,-91.17),(958.6,-107.5,-91.42),(957.1,-107.2,-92.16),(957.3,-107.3,-92.04),(957.2,-107.9,-91.6),(958.1,-108.0,-91.33),(958.3,-107.7,-91.49),(956.7,-107.7,-92.27),(957.1,-108.2,-91.63),(957.5,-108.5,-91.36),(956.6,-108.1,-92.28),(956.8,-108.2,-92.17),(957.0,-108.7,-91.98),(957.2,-109.0,-91.44),(957.4,-108.9,-91.34),(956.5,-108.6,-92.23),(957.2,-109.2,-91.68),(957.5,-109.2,-91.52),(957.7,-109.1,-91.19),(958.0,-109.2,-91.54),(956.6,-109.1,-92.12),(956.7,-109.3,-92.06),(956.9,-109.4,-91.93),(957.1,-109.6,-91.8),(957.4,-109.6,-91.64),(957.8,-109.4,-91.5),(957.9,-106.7,-92.12),(958.1,-106.6,-92.03),(958.3,-106.6,-91.9),(958.7,-106.7,-91.69),(958.8,-106.9,-91.61),(958.8,-107.2,-91.56),(957.5,-107.3,-92.19),(957.8,-107.3,-92.06),(958.1,-107.3,-91.93),(957.1,-107.2,-92.41),(957.1,-107.8,-92.35),(956.8,-107.7,-92.52),(956.8,-108.2,-92.42),(956.6,-108.1,-92.54),(957.1,-108.7,-92.24),(957.3,-109.0,-91.69),(956.6,-108.6,-92.48),(957.0,-109.0,-92.22),(957.2,-109.2,-91.93),(957.5,-109.3,-91.77),(957.8,-109.1,-91.5),(956.6,-109.1,-92.38),(956.7,-109.3,-92.31),(956.9,-109.5,-92.18),(957.2,-109.6,-92.05),(957.5,-109.6,-91.89),(957.8,-109.4,-91.75),(963.0,-105.1,-81.63),(962.3,-105.8,-92.88),(965.6,-97.51,-70.28),(963.1,-93.11,-107.4),(1007.0,-49.53,-104.6),(1017.0,-46.19,-106.3),(1015.0,-53.56,-103.7),(1007.0,-46.48,-105.1),(1006.0,-48.83,-99.47),(1009.0,-47.96,-95.98),(1012.0,-48.82,-96.24),(1011.0,-46.78,-95.82),(1015.0,-52.72,-97.26),(1014.0,-46.47,-97.75),(1016.0,-46.09,-100.7),(1009.0,-46.86,-98.73),(1015.0,-53.9,-110.0),(1006.0,-49.82,-110.2),(1009.0,-49.58,-113.4),(1012.0,-50.44,-113.2),(1011.0,-48.4,-114.7),(1014.0,-47.82,-113.8),(1016.0,-47.05,-111.2),(1009.0,-48.03,-111.6),(1009.0,-60.27,-111.7),(998.3,-55.11,-113.5),(1006.0,-57.89,-113.6),(1001.0,-55.05,-115.9),(996.5,-58.21,-108.8),(1001.0,-63.8,-100.3),(1004.0,-52.6,-103.5),(1001.0,-57.05,-102.2),(1014.0,-57.74,-102.0),(1011.0,-60.06,-102.5),(1016.0,-58.31,-108.2),(1015.0,-59.46,-104.4),(1015.0,-59.49,-110.9),(1012.0,-60.46,-108.3),(1016.0,-55.69,-108.5),(1000.0,-66.1,-99.47),(1004.0,-52.07,-97.56),(1001.0,-60.06,-95.73),(1005.0,-51.55,-93.47),(1011.0,-55.45,-91.05),(1011.0,-52.3,-94.25),(1016.0,-57.23,-96.55),(1014.0,-57.87,-93.39),(1008.0,-59.75,-94.71),(1015.0,-59.02,-99.58),(1011.0,-59.88,-100.5),(1003.0,-58.01,-89.99),(1013.0,-56.57,-91.51),(1015.0,-55.04,-93.48),(1016.0,-54.68,-97.66),(1013.0,-54.15,-91.41),(1014.0,-53.27,-93.11),(1015.0,-53.7,-96.42),(1006.0,-55.59,-91.02),(1005.0,-54.9,-91.2),(1002.0,-62.88,-96.52),(999.9,-53.25,-89.97),(997.9,-59.46,-97.33),(1002.0,-65.22,-96.74),(998.0,-56.25,-89.08),(997.8,-57.02,-92.46),(1006.0,-62.33,-100.6),(1001.0,-60.29,-96.83),(1004.0,-60.14,-97.46),(1008.0,-60.76,-101.0),(1009.0,-61.48,-102.7),(1004.0,-62.43,-98.89),(1005.0,-64.66,-100.1),(1003.0,-65.04,-97.7),(1004.0,-62.84,-102.4),(1003.0,-65.4,-101.9),(1007.0,-62.31,-104.2),(1015.0,-54.99,-110.3),(1013.0,-58.61,-113.5),(1015.0,-56.74,-112.5),(1002.0,-63.48,-104.8),(1002.0,-65.84,-103.2),(996.4,-58.15,-112.6),(1004.0,-53.23,-110.1),(998.0,-58.08,-107.8),(1005.0,-53.41,-113.4),(1008.0,-58.01,-114.2),(1011.0,-54.07,-113.3),(1011.0,-57.13,-114.4),(1014.0,-55.19,-113.9),(1001.0,-55.2,-116.3),(1016.0,-57.17,-108.3),(1016.0,-56.13,-97.06),(1015.0,-59.0,-101.9),(1004.0,-62.76,-105.7),(1005.0,-54.96,-91.75),(1001.0,-55.18,-116.4),(1001.0,-59.31,-92.06),(1001.0,-60.56,-109.3),(996.3,-58.63,-108.9),(997.3,-57.34,-92.15),(1002.0,-62.06,-96.11),(1002.0,-62.75,-106.2),(1001.0,-65.01,-102.1),(1001.0,-66.08,-102.9),(1001.0,-63.57,-102.4),(1001.0,-64.8,-98.15),(1001.0,-65.45,-96.7),(1001.0,-63.28,-98.6),(1000.0,-65.45,-99.7),(1002.0,-57.24,-86.36),(998.4,-56.47,-85.09),(1006.0,-55.67,-85.79),(1002.0,-57.55,-83.19),(1004.0,-57.34,-85.6),(1004.0,-58.05,-87.52),(1011.0,-50.46,-84.69),(1013.0,-52.6,-81.92),(1011.0,-52.75,-79.57),(1009.0,-51.53,-79.3),(1005.0,-51.86,-83.18),(1014.0,-49.66,-83.21),(1013.0,-48.34,-81.92),(1010.0,-48.84,-81.06),(1018.0,-51.29,-80.79),(1018.0,-49.8,-82.72),(1026.0,-46.99,-79.78),(1026.0,-48.32,-78.53),(1017.0,-48.66,-81.3),(1026.0,-45.7,-77.15),(1016.0,-47.54,-78.36),(1015.0,-47.48,-79.88),(1012.0,-48.11,-80.32),(1013.0,-49.2,-78.18),(1026.0,-46.66,-75.7),(1017.0,-49.04,-77.01),(1026.0,-47.77,-76.09),(1017.0,-50.39,-77.48),(1014.0,-50.41,-77.62),(1014.0,-51.62,-78.59),(1029.0,-48.89,-75.87),(1029.0,-49.43,-74.89),(1029.0,-47.05,-73.91),(1029.0,-48.51,-77.22),(1028.0,-49.24,-76.86),(1029.0,-45.29,-73.77),(1031.0,-49.39,-72.97),(1030.0,-48.67,-72.91),(1030.0,-49.2,-72.36),(1032.0,-49.48,-73.62),(1032.0,-48.97,-74.05),(1032.0,-48.7,-72.96),(1032.0,-48.99,-73.74),(1031.0,-48.94,-73.47),(1033.0,-48.81,-73.67),(1033.0,-48.32,-74.05),(1032.0,-47.88,-73.11),(1032.0,-48.14,-73.41),(1033.0,-48.22,-73.63),(1033.0,-47.98,-73.92),(1032.0,-47.52,-74.24),(1032.0,-47.14,-73.26),(1032.0,-47.35,-73.6),(1033.0,-47.42,-73.97),(1031.0,-46.65,-72.6),(1030.0,-46.96,-73.21),(1030.0,-46.12,-73.41),(1031.0,-46.76,-73.28),(1032.0,-46.94,-74.03),(1032.0,-46.58,-74.44),(1031.0,-46.13,-73.39),(1031.0,-46.33,-73.73),(1032.0,-46.47,-74.16),(1030.0,-45.63,-73.06),(1028.0,-49.21,-74.48),(1028.0,-48.65,-72.56),(1028.0,-47.55,-72.61),(1029.0,-46.17,-73.24),(1031.0,-49.07,-72.49),(1032.0,-49.19,-72.89),(1030.0,-48.74,-71.62),(1030.0,-48.94,-71.99),(1030.0,-48.32,-72.2),(1030.0,-47.89,-71.55),(1031.0,-48.12,-71.9),(1032.0,-48.31,-72.48),(1032.0,-48.45,-72.83),(1031.0,-47.45,-72.37),(1030.0,-47.06,-71.92),(1031.0,-47.25,-72.07),(1032.0,-47.57,-72.96),(1032.0,-47.5,-72.65),(1031.0,-46.47,-72.8),(1032.0,-46.59,-73.06),(1030.0,-46.25,-72.42),(1030.0,-46.09,-72.51),(1030.0,-50.45,-76.37),(1030.0,-51.26,-77.52),(1030.0,-51.29,-76.85),(1030.0,-50.08,-77.15),(1029.0,-51.36,-77.38),(1029.0,-50.54,-76.93),(1029.0,-49.82,-76.63),(1029.0,-50.51,-75.84),(1029.0,-50.83,-76.09),(1030.0,-51.41,-76.79),(999.3,-57.53,-84.76),(999.1,-59.39,-115.3),(998.3,-58.17,-116.0),(999.5,-56.74,-118.8),(1001.0,-58.85,-119.1),(1004.0,-57.74,-118.1),(1001.0,-59.78,-114.7),(1006.0,-49.44,-122.9),(1008.0,-51.33,-125.7),(1006.0,-52.24,-127.2),(1004.0,-51.72,-126.9),(1002.0,-52.47,-121.6),(1008.0,-48.69,-125.1),(1006.0,-47.74,-126.5),(1004.0,-48.7,-126.4),(1012.0,-50.41,-127.5),(1012.0,-48.68,-126.3),(1019.0,-46.01,-131.9),(1019.0,-47.49,-132.5),(1011.0,-47.84,-128.1),(1019.0,-45.23,-135.0),(1010.0,-47.28,-131.2),(1009.0,-47.04,-129.5),(1006.0,-47.79,-128.0),(1006.0,-49.14,-129.7),(1019.0,-46.39,-135.9),(1010.0,-48.91,-131.9),(1019.0,-47.37,-135.1),(1011.0,-50.11,-130.9),(1007.0,-50.32,-130.0),(1008.0,-51.31,-128.6),(1022.0,-47.79,-134.1),(1022.0,-48.29,-135.0),(1023.0,-46.51,-137.0),(1021.0,-47.55,-133.0),(1021.0,-48.4,-133.3),(1022.0,-44.9,-138.1),(1025.0,-48.74,-136.8),(1023.0,-48.19,-137.1),(1023.0,-48.79,-137.4),(1026.0,-48.63,-136.0),(1025.0,-48.09,-135.9),(1025.0,-48.04,-137.1),(1026.0,-48.13,-136.1),(1024.0,-48.23,-136.6),(1026.0,-47.93,-136.2),(1026.0,-47.42,-136.2),(1025.0,-47.22,-137.4),(1025.0,-47.44,-137.0),(1026.0,-47.37,-136.5),(1026.0,-47.11,-136.4),(1025.0,-46.65,-136.4),(1025.0,-46.49,-137.6),(1025.0,-46.65,-137.2),(1026.0,-46.56,-136.7),(1024.0,-46.28,-138.5),(1024.0,-46.47,-137.7),(1024.0,-45.63,-137.9),(1024.0,-46.19,-137.9),(1025.0,-46.17,-137.0),(1025.0,-45.76,-136.9),(1025.0,-45.56,-138.2),(1024.0,-45.7,-137.8),(1025.0,-45.69,-137.1),(1023.0,-45.25,-138.5),(1022.0,-48.48,-135.5),(1022.0,-48.35,-137.6),(1022.0,-47.31,-138.1),(1022.0,-45.86,-138.2),(1025.0,-48.52,-137.4),(1025.0,-48.52,-136.9),(1023.0,-48.48,-138.3),(1024.0,-48.55,-138.0),(1024.0,-47.95,-138.0),(1024.0,-47.66,-138.9),(1024.0,-47.76,-138.5),(1025.0,-47.76,-137.8),(1026.0,-47.79,-137.3),(1024.0,-47.09,-138.3),(1023.0,-46.8,-138.9),(1024.0,-46.91,-138.9),(1025.0,-46.94,-137.7),(1025.0,-46.96,-138.1),(1024.0,-46.01,-138.6),(1025.0,-46.05,-138.2),(1024.0,-45.93,-138.8),(1023.0,-45.82,-138.8),(1023.0,-49.26,-132.8),(1023.0,-49.8,-131.3),(1023.0,-49.96,-131.9),(1023.0,-48.8,-132.4),(1023.0,-49.95,-131.4),(1022.0,-49.34,-132.4),(1022.0,-48.84,-133.1),(1023.0,-49.5,-133.4),(1023.0,-49.73,-133.0),(1023.0,-50.12,-131.9),(999.6,-59.31,-116.8),(1006.0,-57.89,-113.6),(1001.0,-55.05,-115.9),(1019.0,-42.15,-107.4),(1018.0,-40.18,-107.3),(1006.0,-40.92,-106.2),(1011.0,-36.35,-107.4),(1014.0,-36.66,-107.4),(1006.0,-44.11,-105.5),(1013.0,-45.95,-117.0),(1010.0,-46.29,-114.8),(1016.0,-44.3,-115.5),(1017.0,-42.91,-111.6),(1006.0,-44.69,-110.8),(1029.0,-23.43,-124.0),(1028.0,-27.74,-122.3),(1025.0,-24.02,-120.1),(1027.0,-27.66,-119.4),(1028.0,-27.23,-115.7),(1026.0,-23.43,-116.9),(1030.0,-22.49,-115.8),(1030.0,-27.64,-124.0),(1030.0,-26.87,-114.5),(1033.0,-26.6,-115.5),(1032.0,-22.2,-120.3),(1034.0,-26.82,-119.5),(1033.0,-27.23,-122.8),(1029.0,-31.06,-123.7),(1029.0,-29.81,-113.0),(1031.0,-32.0,-114.3),(1032.0,-33.54,-118.1),(1031.0,-32.84,-120.8),(1022.0,-37.47,-122.6),(1020.0,-34.52,-121.9),(1021.0,-31.82,-118.8),(1021.0,-31.36,-113.8),(1023.0,-34.77,-110.4),(1025.0,-37.5,-111.5),(1025.0,-39.41,-115.3),(1023.0,-39.13,-119.3),(1013.0,-43.13,-119.1),(1014.0,-37.98,-121.8),(1016.0,-34.8,-117.9),(1013.0,-35.28,-109.3),(1017.0,-34.96,-109.8),(1009.0,-43.36,-118.1),(1011.0,-40.38,-120.6),(1006.0,-39.91,-116.0),(1006.0,-41.69,-115.0),(1005.0,-41.95,-107.8),(1005.0,-40.05,-109.0),(1007.0,-39.12,-106.7),(1008.0,-38.69,-105.7),(1006.0,-38.08,-115.4),(1011.0,-34.55,-115.9),(1006.0,-37.3,-109.6),(1013.0,-34.86,-112.2),(1008.0,-36.93,-107.3),(1010.0,-37.47,-105.1),(1027.0,-17.85,-125.6),(1025.0,-18.06,-124.3),(1024.0,-18.09,-120.9),(1025.0,-17.59,-117.7),(1027.0,-17.2,-116.6),(1029.0,-16.75,-118.0),(1029.0,-16.86,-120.9),(1029.0,-17.34,-124.3),(1024.0,-11.24,-125.6),(1022.0,-11.6,-124.7),(1021.0,-11.62,-122.0),(1022.0,-11.23,-119.4),(1024.0,-10.73,-118.3),(1025.0,-10.37,-119.6),(1026.0,-10.59,-122.0),(1025.0,-10.85,-124.7),(1023.0,-5.967,-125.2),(1021.0,-6.555,-125.0),(1021.0,-6.643,-122.8),(1021.0,-6.273,-121.5),(1023.0,-5.591,-121.0),(1024.0,-5.115,-121.9),(1025.0,-5.064,-123.6),(1024.0,-5.395,-124.9),(1026.0,-4.288,-125.8),(1027.0,-3.738,-124.2),(1029.0,-2.466,-125.4),(1027.0,-2.741,-126.5),(1026.0,-3.949,-122.4),(1027.0,-2.408,-122.1),(1030.0,-2.278,-123.3),(1024.0,-4.079,-120.8),(1020.0,-5.089,-120.4),(1020.0,-4.114,-121.1),(1022.0,-3.944,-120.3),(1019.0,-5.382,-123.1),(1019.0,-4.362,-123.3),(1020.0,-5.67,-125.4),(1020.0,-4.461,-125.5),(1024.0,-4.961,-126.2),(1021.0,-4.441,-126.3),(1027.0,-2.055,-126.5),(1030.0,-1.516,-124.5),(1027.0,-1.686,-122.5),(1020.0,-6.301,-124.5),(1020.0,-6.01,-121.0),(1020.0,-2.34,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1014.0,-36.16,-109.5),(1016.0,-38.07,-109.0),(1014.0,-44.25,-95.26),(1011.0,-44.84,-96.39),(1017.0,-42.93,-98.05),(1018.0,-42.22,-102.8),(1006.0,-43.85,-100.0),(1030.0,-21.72,-102.0),(1029.0,-26.16,-102.2),(1025.0,-22.75,-104.5),(1027.0,-26.5,-104.7),(1028.0,-26.65,-108.6),(1026.0,-22.74,-108.2),(1030.0,-22.11,-110.4),(1031.0,-25.84,-101.0),(1030.0,-26.53,-110.4),(1033.0,-26.2,-110.3),(1033.0,-21.22,-106.9),(1034.0,-25.83,-106.7),(1034.0,-25.69,-103.1),(1030.0,-28.93,-99.61),(1029.0,-29.35,-110.3),(1031.0,-31.27,-108.6),(1032.0,-32.17,-104.6),(1032.0,-31.08,-102.0),(1023.0,-35.26,-95.91),(1021.0,-32.53,-97.39),(1021.0,-30.4,-101.7),(1022.0,-30.71,-106.9),(1023.0,-34.51,-108.7),(1025.0,-37.1,-106.9),(1026.0,-38.24,-102.9),(1025.0,-37.37,-98.81),(1014.0,-39.98,-94.23),(1015.0,-35.91,-94.35),(1011.0,-32.82,-100.3),(1017.0,-34.83,-107.8),(1010.0,-41.5,-94.44),(1011.0,-38.48,-94.24),(1007.0,-38.43,-97.2),(1007.0,-40.31,-97.43),(1005.0,-41.64,-103.9),(1005.0,-39.62,-103.6),(1008.0,-38.88,-108.1),(1007.0,-36.76,-98.65),(1007.0,-35.2,-101.7),(1006.0,-36.9,-104.5),(1009.0,-35.4,-105.2),(1008.0,-36.9,-107.0),(1010.0,-37.83,-109.7),(1028.0,-16.02,-102.5),(1026.0,-16.35,-103.2),(1024.0,-16.88,-106.2),(1025.0,-16.92,-109.7),(1027.0,-16.8,-111.4),(1029.0,-16.24,-110.8),(1030.0,-15.9,-108.0),(1029.0,-15.8,-104.4),(1025.0,-9.55,-104.8),(1023.0,-9.974,-105.1),(1022.0,-10.39,-107.6),(1023.0,-10.46,-110.4),(1024.0,-10.2,-112.0),(1026.0,-9.721,-111.4),(1027.0,-9.583,-109.2),(1026.0,-9.382,-106.3),(1024.0,-4.582,-107.5),(1022.0,-5.037,-107.1),(1021.0,-5.444,-109.1),(1022.0,-5.31,-110.5),(1024.0,-4.889,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.194,-109.7),(1025.0,-4.264,-108.3),(1027.0,-2.812,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.171,-110.1),(1028.0,-1.235,-108.5),(1027.0,-3.019,-111.7),(1028.0,-1.599,-112.9),(1030.0,-1.319,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.328,-111.9),(1021.0,-3.286,-111.7),(1022.0,-3.274,-112.8),(1020.0,-4.187,-109.2),(1020.0,-3.175,-109.4),(1021.0,-3.992,-106.9),(1021.0,-2.926,-107.3),(1025.0,-3.378,-107.3),(1022.0,-2.817,-106.9),(1028.0,-0.5391,-108.8),(1031.0,-0.4378,-111.5),(1027.0,-0.8024,-112.8),(1021.0,-4.828,-107.6),(1021.0,-5.086,-111.0),(1021.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.07,-110.5),(1021.0,-0.9919,-109.5),(1007.0,-70.92,-99.43),(1003.0,-69.01,-93.12),(998.7,-74.36,-97.56),(1008.0,-64.74,-100.9),(1007.0,-70.79,-98.19),(1006.0,-70.96,-93.9),(1005.0,-69.98,-93.5),(1006.0,-73.55,-98.62),(1003.0,-74.66,-98.09),(1000.0,-74.57,-97.71),(1009.0,-68.91,-100.1),(1009.0,-66.93,-100.6),(1009.0,-65.8,-100.8),(1000.0,-67.37,-94.81),(1000.0,-69.43,-93.23),(994.7,-69.76,-98.07),(994.9,-71.67,-97.66),(997.2,-73.92,-97.46),(998.4,-66.05,-99.38),(1001.0,-65.05,-99.98),(1004.0,-64.92,-100.3),(1002.0,-69.68,-92.72),(999.0,-72.69,-93.05),(998.8,-73.85,-94.82),(1007.0,-65.23,-96.98),(1006.0,-65.89,-95.41),(1004.0,-67.61,-93.67),(1005.0,-73.63,-95.99),(1004.0,-71.35,-93.31),(1001.0,-73.82,-94.67),(1009.0,-68.84,-99.26),(1008.0,-65.93,-98.6),(1006.0,-67.96,-94.89),(995.4,-70.67,-94.59),(996.2,-72.51,-94.09),(998.1,-71.18,-92.35),(1002.0,-67.58,-94.08),(1004.0,-65.32,-96.48),(1002.0,-74.75,-97.88),(1007.0,-72.37,-99.04),(1007.0,-70.48,-99.57),(1008.0,-70.21,-99.66),(1008.0,-69.62,-99.87),(1008.0,-69.3,-99.06),(1007.0,-69.8,-99.07),(1009.0,-69.14,-100.1),(1009.0,-68.62,-100.1),(1008.0,-68.38,-100.2),(1009.0,-68.03,-100.3),(1008.0,-68.22,-98.98),(1009.0,-67.7,-98.58),(1007.0,-69.62,-98.72),(1008.0,-68.45,-98.46),(1008.0,-66.98,-97.25),(1007.0,-66.24,-96.62),(1009.0,-64.97,-99.51),(1009.0,-67.44,-100.4),(1009.0,-66.63,-100.6),(1009.0,-66.12,-100.7),(1009.0,-65.27,-100.9),(1005.0,-64.64,-100.6),(1008.0,-66.7,-98.8),(1009.0,-67.85,-100.4),(1009.0,-67.23,-100.5),(1009.0,-67.24,-98.58),(1009.0,-67.98,-99.5),(1008.0,-68.43,-96.71),(1008.0,-69.0,-98.96),(1009.0,-69.27,-99.46),(1009.0,-66.92,-98.76),(1007.0,-71.19,-95.31),(1006.0,-70.3,-98.62),(1005.0,-69.39,-93.84),(1007.0,-71.75,-95.34),(1007.0,-70.06,-97.27),(1007.0,-70.23,-99.0),(1006.0,-70.4,-95.07),(1006.0,-70.52,-94.03),(1006.0,-70.77,-97.36),(1007.0,-71.32,-97.06),(1004.0,-72.69,-94.14),(1003.0,-73.99,-95.11),(1007.0,-67.35,-96.0),(1003.0,-65.29,-100.1),(1007.0,-71.62,-99.27),(1008.0,-65.63,-98.2),(1007.0,-70.57,-98.91),(1007.0,-71.23,-98.27),(1007.0,-71.68,-97.72),(1006.0,-69.79,-94.97),(1007.0,-69.26,-97.54),(1006.0,-69.07,-95.0),(1008.0,-68.07,-98.27),(995.7,-66.64,-98.89),(996.0,-67.82,-95.05),(995.7,-72.93,-97.49),(997.4,-65.92,-98.47),(996.7,-66.11,-98.37),(996.2,-65.84,-99.15),(996.0,-65.47,-99.2),(995.2,-64.82,-99.24),(994.7,-63.83,-99.4),(994.6,-62.0,-99.8),(993.5,-59.94,-100.1),(994.0,-59.11,-100.4),(995.6,-56.92,-101.1),(996.9,-56.2,-101.4),(998.9,-56.62,-101.5),(998.7,-58.31,-101.1),(999.6,-60.54,-100.8),(999.2,-63.29,-100.1),(997.5,-64.54,-99.61),(998.1,-64.9,-99.61),(998.3,-65.26,-99.55),(995.8,-59.54,-99.44),(997.1,-61.17,-99.22),(997.5,-65.46,-98.64),(997.7,-59.54,-99.96),(997.5,-57.68,-100.4),(996.8,-62.47,-99.2),(996.3,-63.75,-99.04),(996.9,-64.85,-98.59),(996.4,-58.14,-100.2),(996.1,-64.72,-98.67),(996.5,-65.2,-98.6),(996.8,-65.66,-98.53),(1000.0,-67.32,-93.8),(1001.0,-67.22,-93.98),(1001.0,-67.21,-94.19),(1001.0,-67.29,-94.29),(1001.0,-67.41,-94.43),(1001.0,-67.65,-94.43),(1001.0,-67.9,-94.25),(1000.0,-67.84,-93.39),(1000.0,-67.8,-93.63),(1001.0,-67.92,-93.77),(1000.0,-68.34,-93.99),(1001.0,-68.19,-94.23),(1001.0,-68.2,-94.14),(999.7,-67.66,-93.13),(999.9,-67.79,-93.24),(999.7,-68.45,-93.38),(1001.0,-68.65,-93.81),(1001.0,-68.36,-93.87),(999.4,-68.05,-92.74),(999.6,-68.69,-93.21),(1000.0,-69.07,-93.45),(1000.0,-69.14,-93.42),(999.2,-68.5,-92.48),(999.4,-68.61,-92.6),(999.6,-69.1,-92.65),(999.7,-69.49,-93.09),(999.9,-69.46,-93.27),(999.1,-68.94,-92.33),(999.7,-69.67,-92.76),(1000.0,-69.76,-92.98),(1000.0,-69.64,-93.31),(1000.0,-69.72,-93.14),(999.2,-69.47,-92.22),(999.2,-69.7,-92.21),(999.4,-69.84,-92.34),(999.6,-70.0,-92.47),(999.9,-70.06,-92.71),(1000.0,-69.94,-93.0),(1001.0,-67.3,-93.56),(1001.0,-67.2,-93.75),(1001.0,-67.19,-93.96),(1001.0,-67.39,-94.19),(1001.0,-67.6,-94.2),(1000.0,-67.82,-93.15),(1000.0,-67.78,-93.39),(1001.0,-67.89,-93.54),(999.8,-67.64,-92.89),(999.8,-68.16,-92.72),(999.7,-68.67,-92.97),(999.5,-68.03,-92.5),(999.3,-68.47,-92.24),(999.5,-68.59,-92.37),(999.6,-69.08,-92.41),(999.8,-69.47,-92.86),(999.2,-68.91,-92.1),(999.6,-69.42,-92.27),(999.7,-69.65,-92.53),(1000.0,-69.74,-92.74),(999.2,-69.45,-91.98),(999.3,-69.68,-91.98),(999.5,-69.82,-92.11),(999.7,-69.98,-92.23),(1000.0,-70.03,-92.48),(1000.0,-69.92,-92.76),(1002.0,-69.94,-105.2),(1007.0,-70.97,-100.6),(1005.0,-71.76,-104.3),(1004.0,-70.85,-104.9),(1000.0,-67.78,-103.6),(999.7,-70.13,-104.2),(1002.0,-70.8,-105.1),(998.4,-73.44,-102.7),(998.4,-74.17,-100.7),(1006.0,-65.58,-104.0),(1005.0,-66.65,-105.1),(1003.0,-68.53,-105.6),(1005.0,-74.17,-101.3),(1003.0,-72.45,-104.3),(1000.0,-74.22,-101.1),(1009.0,-68.96,-100.9),(1008.0,-66.24,-102.6),(1006.0,-68.72,-104.8),(995.0,-71.18,-101.2),(995.7,-73.04,-101.0),(997.3,-72.15,-103.9),(1002.0,-68.4,-104.8),(1004.0,-65.9,-104.0),(1007.0,-69.42,-100.6),(1007.0,-69.89,-100.3),(1008.0,-68.4,-101.3),(1008.0,-67.96,-102.0),(1007.0,-69.76,-100.6),(1007.0,-68.69,-101.5),(1007.0,-67.45,-103.4),(1007.0,-66.52,-104.0),(1008.0,-65.19,-102.5),(1008.0,-66.96,-102.1),(1008.0,-67.52,-102.2),(1009.0,-68.1,-101.0),(1007.0,-68.95,-103.3),(1008.0,-69.16,-100.9),(1009.0,-69.35,-100.5),(1008.0,-67.19,-102.2),(1006.0,-71.8,-103.1),(1006.0,-70.43,-100.3),(1005.0,-70.25,-105.0),(1006.0,-72.33,-102.8),(1006.0,-70.43,-101.7),(1007.0,-70.32,-100.1),(1006.0,-71.07,-103.5),(1005.0,-71.29,-104.3),(1006.0,-71.07,-101.3),(1007.0,-71.66,-101.5),(1004.0,-73.41,-102.8),(1003.0,-74.36,-101.2),(1007.0,-68.01,-104.0),(1008.0,-65.81,-103.1),(1007.0,-70.66,-99.99),(1007.0,-71.4,-100.4),(1007.0,-71.91,-100.7),(1005.0,-70.47,-103.7),(1007.0,-69.64,-101.8),(1006.0,-69.78,-104.2),(1008.0,-68.48,-102.0),(995.5,-68.36,-102.1),(997.3,-66.04,-100.0),(996.6,-66.23,-99.88),(995.5,-60.92,-100.9),(996.4,-62.39,-100.7),(997.4,-65.58,-100.1),(997.8,-60.33,-101.6),(997.6,-57.8,-101.9),(996.3,-63.65,-100.2),(996.8,-64.94,-100.2),(995.7,-58.74,-101.6),(996.0,-64.83,-100.1),(996.4,-65.31,-100.0),(996.7,-65.77,-99.95),(999.8,-68.16,-104.7),(1000.0,-68.04,-104.6),(1000.0,-68.0,-104.4),(1000.0,-68.07,-104.4),(1001.0,-68.17,-104.2),(1001.0,-68.38,-104.1),(1001.0,-68.66,-104.1),(999.4,-68.72,-104.7),(999.7,-68.65,-104.6),(999.9,-68.74,-104.5),(999.8,-69.12,-104.0),(1000.0,-68.94,-103.9),(1000.0,-68.97,-104.2),(999.0,-68.58,-105.0),(999.2,-68.69,-104.8),(999.1,-69.3,-104.4),(999.9,-69.43,-104.1),(1000.0,-69.17,-104.2),(998.6,-69.0,-105.1),(998.9,-69.55,-104.4),(999.3,-69.9,-104.1),(998.4,-69.47,-105.1),(998.6,-69.56,-105.0),(998.8,-70.04,-104.7),(999.0,-70.35,-104.2),(999.2,-70.29,-104.1),(998.4,-69.91,-105.0),(998.9,-70.57,-104.4),(999.3,-70.63,-104.2),(999.5,-70.47,-103.9),(999.7,-70.64,-104.3),(998.4,-70.45,-104.9),(998.4,-70.68,-104.8),(998.6,-70.79,-104.7),(998.8,-70.94,-104.5),(999.2,-70.96,-104.4),(999.5,-70.81,-104.2),(999.8,-68.13,-104.9),(1000.0,-68.05,-104.8),(1000.0,-68.02,-104.7),(1001.0,-68.19,-104.5),(1001.0,-68.39,-104.4),(1001.0,-68.67,-104.3),(999.4,-68.74,-105.0),(999.7,-68.66,-104.8),(1000.0,-68.76,-104.7),(999.0,-68.6,-105.2),(999.0,-69.12,-105.1),(998.7,-69.02,-105.3),(998.7,-69.58,-105.2),(998.5,-69.49,-105.3),(998.9,-70.05,-105.0),(999.0,-70.36,-104.4),(998.4,-69.93,-105.3),(998.8,-70.4,-105.0),(999.0,-70.59,-104.7),(999.3,-70.64,-104.5),(999.5,-70.48,-104.2),(998.4,-70.47,-105.1),(998.5,-70.69,-105.1),(998.7,-70.81,-104.9),(998.9,-70.95,-104.8),(999.2,-70.97,-104.6),(999.6,-70.82,-104.5),(1005.0,-66.7,-94.34),(1004.0,-67.46,-105.6),(1006.0,-52.33,-86.78),(1004.0,-52.51,-118.7),(1020.0,-55.28,-104.8),(1029.0,-50.54,-106.7),(1029.0,-58.06,-104.3),(1020.0,-52.23,-105.2),(1020.0,-54.69,-99.58),(1022.0,-53.55,-96.15),(1025.0,-53.98,-96.55),(1024.0,-52.01,-96.06),(1029.0,-57.38,-97.81),(1027.0,-51.26,-98.09),(1028.0,-50.64,-101.1),(1022.0,-52.4,-98.88),(1029.0,-58.43,-110.6),(1020.0,-55.57,-110.4),(1022.0,-54.99,-113.6),(1025.0,-55.44,-113.5),(1024.0,-53.52,-115.0),(1027.0,-52.52,-114.1),(1028.0,-51.54,-111.6),(1021.0,-53.5,-111.8),(1024.0,-65.56,-112.2),(1014.0,-63.83,-112.8),(1021.0,-63.5,-114.0),(1017.0,-62.69,-114.4),(1015.0,-67.3,-109.0),(1017.0,-70.24,-100.7),(1018.0,-58.7,-103.7),(1016.0,-63.49,-102.4),(1028.0,-62.43,-102.6),(1026.0,-65.09,-103.1),(1031.0,-62.59,-109.0),(1030.0,-63.95,-105.2),(1029.0,-63.96,-111.7),(1027.0,-65.26,-109.0),(1030.0,-60.05,-109.2),(1017.0,-72.59,-99.89),(1018.0,-58.26,-97.68),(1016.0,-66.61,-95.98),(1019.0,-57.56,-93.63),(1025.0,-60.65,-91.55),(1025.0,-57.49,-94.66),(1031.0,-61.62,-97.3),(1029.0,-62.51,-94.11),(1026.0,-64.65,-96.06),(1030.0,-63.55,-100.3),(1026.0,-64.92,-101.1),(1022.0,-63.81,-92.24),(1028.0,-61.42,-92.13),(1029.0,-59.71,-94.1),(1030.0,-59.15,-98.32),(1027.0,-59.09,-91.94),(1028.0,-58.09,-93.65),(1030.0,-58.24,-97.04),(1021.0,-61.42,-91.36),(1019.0,-61.02,-91.44),(1018.0,-69.13,-96.92),(1016.0,-61.97,-89.82),(1017.0,-67.81,-97.01),(1019.0,-71.45,-97.21),(1016.0,-65.41,-89.13),(1016.0,-66.09,-92.58),(1022.0,-68.03,-101.2),(1020.0,-67.7,-97.41),(1023.0,-66.57,-99.03),(1023.0,-66.23,-101.5),(1024.0,-66.79,-103.3),(1020.0,-68.42,-99.35),(1022.0,-70.45,-100.7),(1020.0,-71.15,-98.21),(1020.0,-68.81,-102.9),(1020.0,-71.44,-102.4),(1023.0,-67.85,-104.8),(1030.0,-59.39,-111.0),(1028.0,-63.24,-114.2),(1029.0,-61.16,-113.2),(1018.0,-69.66,-105.2),(1019.0,-71.98,-103.7),(1014.0,-67.23,-112.8),(1018.0,-59.3,-110.3),(1016.0,-67.09,-107.8),(1019.0,-59.22,-113.6),(1025.0,-62.82,-115.2),(1025.0,-59.07,-113.8),(1027.0,-61.34,-115.5),(1028.0,-59.81,-114.5),(1017.0,-62.75,-115.0),(1031.0,-61.44,-109.1),(1031.0,-60.51,-97.78),(1030.0,-63.42,-102.7),(1019.0,-68.77,-106.1),(1019.0,-61.06,-91.98),(1017.0,-62.72,-115.0),(1021.0,-66.14,-93.08),(1020.0,-67.53,-110.2),(1015.0,-67.77,-109.1),(1016.0,-66.55,-92.27),(1017.0,-68.45,-96.46),(1018.0,-69.03,-106.6),(1018.0,-71.36,-102.6),(1018.0,-72.41,-103.4),(1017.0,-69.95,-102.8),(1018.0,-71.19,-98.57),(1018.0,-71.82,-97.15),(1017.0,-69.69,-98.96),(1017.0,-71.91,-100.1),(1020.0,-64.96,-86.88),(1017.0,-64.15,-86.72),(1021.0,-61.63,-86.11),(1021.0,-62.56,-84.74),(1022.0,-61.21,-87.57),(1022.0,-64.87,-88.32),(1019.0,-52.74,-91.06),(1022.0,-52.2,-88.28),(1021.0,-53.33,-85.35),(1019.0,-53.82,-84.99),(1017.0,-57.23,-87.65),(1020.0,-49.89,-90.74),(1018.0,-49.97,-89.49),(1017.0,-51.79,-87.83),(1024.0,-47.6,-89.04),(1022.0,-47.16,-91.28),(1024.0,-39.53,-91.69),(1025.0,-40.18,-90.14),(1021.0,-46.75,-90.06),(1023.0,-38.62,-89.29),(1019.0,-46.37,-87.26),(1018.0,-47.33,-88.46),(1017.0,-49.81,-87.93),(1019.0,-49.83,-85.64),(1024.0,-39.04,-87.63),(1021.0,-46.73,-85.64),(1025.0,-39.64,-87.84),(1022.0,-47.16,-85.88),(1020.0,-49.84,-84.97),(1022.0,-50.42,-85.65),(1028.0,-38.7,-89.59),(1028.0,-38.73,-88.58),(1027.0,-36.92,-87.8),(1027.0,-39.32,-90.41),(1027.0,-40.1,-89.43),(1025.0,-35.84,-87.53),(1030.0,-37.11,-89.54),(1029.0,-37.39,-87.51),(1029.0,-37.57,-87.11),(1030.0,-36.95,-91.06),(1029.0,-36.95,-90.78),(1029.0,-36.51,-89.81),(1029.0,-36.65,-91.12),(1029.0,-37.08,-89.56),(1029.0,-36.28,-91.59),(1028.0,-36.3,-91.28),(1028.0,-35.98,-89.91),(1028.0,-36.38,-89.81),(1029.0,-35.91,-91.44),(1028.0,-36.0,-91.21),(1028.0,-36.01,-90.85),(1027.0,-35.61,-89.78),(1028.0,-36.01,-89.65),(1028.0,-35.65,-91.16),(1027.0,-35.81,-87.53),(1027.0,-36.21,-87.96),(1026.0,-35.68,-88.1),(1027.0,-35.81,-88.71),(1027.0,-35.85,-89.96),(1026.0,-35.83,-89.97),(1026.0,-35.41,-88.78),(1026.0,-35.76,-88.77),(1027.0,-35.52,-90.14),(1026.0,-35.36,-87.62),(1028.0,-39.04,-87.75),(1028.0,-38.3,-85.89),(1027.0,-37.57,-85.95),(1026.0,-36.54,-86.81),(1030.0,-36.78,-89.1),(1030.0,-36.73,-90.02),(1029.0,-37.23,-86.23),(1029.0,-36.9,-87.81),(1029.0,-36.81,-87.21),(1028.0,-36.43,-86.55),(1029.0,-36.18,-88.06),(1029.0,-36.1,-89.47),(1029.0,-36.09,-90.25),(1028.0,-36.24,-87.42),(1028.0,-36.03,-86.77),(1028.0,-35.8,-87.8),(1028.0,-35.68,-89.92),(1028.0,-35.74,-89.21),(1027.0,-35.49,-88.33),(1027.0,-35.48,-88.9),(1027.0,-35.54,-87.3),(1026.0,-35.79,-86.83),(1029.0,-38.76,-90.13),(1030.0,-39.38,-90.78),(1030.0,-39.16,-90.22),(1029.0,-39.23,-90.64),(1030.0,-39.69,-90.34),(1029.0,-39.73,-89.87),(1028.0,-39.76,-89.59),(1029.0,-39.22,-89.11),(1030.0,-39.22,-89.34),(1030.0,-39.49,-89.85),(1019.0,-64.32,-85.98),(1017.0,-67.13,-116.0),(1016.0,-66.25,-116.3),(1016.0,-63.98,-118.3),(1019.0,-65.18,-119.5),(1020.0,-63.53,-117.8),(1019.0,-66.69,-115.5),(1018.0,-54.67,-117.2),(1021.0,-54.63,-120.9),(1019.0,-56.15,-122.9),(1017.0,-56.59,-122.5),(1016.0,-59.14,-118.2),(1019.0,-51.9,-119.1),(1017.0,-52.24,-119.6),(1016.0,-54.18,-120.2),(1022.0,-49.83,-122.8),(1021.0,-49.1,-120.5),(1021.0,-41.71,-123.7),(1023.0,-42.43,-125.2),(1019.0,-48.97,-121.4),(1020.0,-41.26,-126.0),(1017.0,-49.15,-123.7),(1017.0,-49.88,-122.0),(1016.0,-52.35,-121.0),(1017.0,-52.72,-123.5),(1021.0,-41.76,-127.7),(1018.0,-49.68,-125.6),(1022.0,-42.21,-127.5),(1020.0,-49.99,-125.6),(1018.0,-52.79,-124.6),(1020.0,-53.2,-124.1),(1024.0,-40.86,-125.7),(1025.0,-40.9,-126.6),(1023.0,-39.14,-127.5),(1023.0,-41.52,-124.9),(1024.0,-42.3,-125.8),(1022.0,-38.13,-128.0),(1026.0,-39.18,-126.1),(1025.0,-39.59,-127.7),(1026.0,-39.81,-128.1),(1026.0,-38.99,-124.6),(1025.0,-39.01,-125.0),(1026.0,-38.6,-126.0),(1026.0,-38.7,-124.7),(1026.0,-39.17,-126.2),(1025.0,-38.32,-124.3),(1025.0,-38.36,-124.7),(1025.0,-38.08,-126.1),(1025.0,-38.48,-126.2),(1025.0,-37.97,-124.6),(1025.0,-38.07,-124.9),(1024.0,-38.1,-125.4),(1024.0,-37.72,-126.5),(1024.0,-38.13,-126.6),(1024.0,-37.73,-125.1),(1024.0,-37.97,-128.1),(1024.0,-38.28,-127.5),(1023.0,-37.77,-127.4),(1024.0,-37.96,-127.5),(1024.0,-37.96,-126.4),(1023.0,-37.96,-126.5),(1023.0,-37.57,-127.6),(1023.0,-37.9,-127.5),(1023.0,-37.64,-126.4),(1023.0,-37.56,-127.9),(1024.0,-41.24,-127.4),(1025.0,-40.51,-129.2),(1024.0,-39.8,-129.3),(1022.0,-38.8,-128.7),(1026.0,-38.87,-126.6),(1026.0,-38.8,-125.7),(1026.0,-39.6,-129.1),(1026.0,-39.05,-127.9),(1025.0,-39.04,-128.2),(1025.0,-38.74,-128.9),(1026.0,-38.33,-127.8),(1026.0,-38.2,-126.4),(1026.0,-38.17,-125.6),(1025.0,-38.46,-128.1),(1024.0,-38.32,-128.8),(1025.0,-38.0,-128.3),(1025.0,-37.78,-126.2),(1025.0,-37.86,-126.9),(1024.0,-37.64,-127.8),(1024.0,-37.63,-127.4),(1024.0,-37.73,-128.3),(1023.0,-38.03,-128.6),(1026.0,-40.92,-124.6),(1027.0,-41.52,-123.8),(1027.0,-41.3,-124.3),(1025.0,-41.4,-124.2),(1027.0,-41.83,-124.2),(1026.0,-41.89,-124.9),(1025.0,-41.96,-125.4),(1026.0,-41.38,-125.7),(1026.0,-41.38,-125.4),(1027.0,-41.63,-124.7),(1017.0,-66.68,-117.5),(1021.0,-63.5,-114.0),(1017.0,-62.69,-114.4),(1030.0,-46.28,-107.8),(1028.0,-43.32,-108.0),(1018.0,-46.89,-106.0),(1022.0,-41.67,-107.2),(1025.0,-41.51,-107.4),(1018.0,-50.05,-105.4),(1025.0,-50.79,-117.2),(1022.0,-51.6,-115.0),(1028.0,-48.78,-115.8),(1029.0,-47.19,-111.9),(1018.0,-50.6,-110.8),(1030.0,-22.51,-124.2),(1030.0,-26.99,-122.5),(1026.0,-23.42,-120.3),(1029.0,-27.05,-119.6),(1030.0,-26.5,-116.0),(1027.0,-22.73,-117.1),(1031.0,-21.51,-116.1),(1032.0,-26.63,-124.4),(1032.0,-25.91,-114.8),(1035.0,-25.27,-115.9),(1033.0,-20.96,-120.6),(1036.0,-25.28,-120.0),(1035.0,-25.84,-123.2),(1032.0,-30.45,-124.1),(1032.0,-29.37,-113.3),(1035.0,-30.75,-114.9),(1036.0,-31.78,-118.9),(1035.0,-31.46,-121.5),(1029.0,-38.94,-123.1),(1026.0,-37.1,-121.8),(1025.0,-34.48,-118.5),(1026.0,-33.88,-113.5),(1029.0,-36.38,-110.7),(1032.0,-38.07,-112.3),(1033.0,-39.55,-116.4),(1032.0,-39.78,-120.2),(1025.0,-47.38,-119.7),(1022.0,-42.56,-121.4),(1023.0,-39.1,-117.3),(1022.0,-40.75,-108.4),(1024.0,-39.02,-109.4),(1021.0,-48.77,-118.1),(1021.0,-45.63,-120.2),(1017.0,-45.85,-115.8),(1017.0,-47.59,-114.9),(1016.0,-48.09,-107.6),(1016.0,-46.2,-108.8),(1018.0,-45.04,-106.5),(1019.0,-44.4,-105.6),(1017.0,-44.03,-115.2),(1019.0,-40.71,-114.4),(1016.0,-43.35,-109.3),(1021.0,-40.47,-111.1),(1018.0,-42.72,-107.0),(1021.0,-42.93,-105.0),(1027.0,-17.11,-125.8),(1025.0,-17.46,-124.5),(1024.0,-17.56,-121.1),(1025.0,-17.0,-117.9),(1027.0,-16.48,-116.8),(1029.0,-15.9,-118.2),(1030.0,-15.94,-121.2),(1029.0,-16.47,-124.5),(1024.0,-10.8,-125.7),(1022.0,-11.25,-124.8),(1021.0,-11.31,-122.1),(1022.0,-10.89,-119.5),(1024.0,-10.3,-118.4),(1025.0,-9.839,-119.7),(1026.0,-10.01,-122.1),(1025.0,-10.31,-124.8),(1022.0,-5.694,-125.2),(1021.0,-6.317,-125.0),(1020.0,-6.424,-122.8),(1021.0,-6.037,-121.6),(1023.0,-5.315,-121.1),(1024.0,-4.805,-121.9),(1024.0,-4.742,-123.7),(1024.0,-5.082,-125.0),(1026.0,-4.196,-125.8),(1027.0,-3.657,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.664,-126.5),(1026.0,-3.855,-122.4),(1027.0,-2.332,-122.1),(1030.0,-2.279,-123.3),(1024.0,-3.915,-120.9),(1020.0,-4.821,-120.5),(1020.0,-3.823,-121.2),(1021.0,-3.693,-120.4),(1019.0,-5.118,-123.1),(1019.0,-4.064,-123.3),(1019.0,-5.471,-125.4),(1020.0,-4.168,-125.6),(1024.0,-4.799,-126.2),(1021.0,-4.191,-126.3),(1027.0,-1.977,-126.5),(1030.0,-1.527,-124.5),(1027.0,-1.603,-122.5),(1020.0,-6.091,-124.5),(1020.0,-5.799,-121.1),(1020.0,-2.045,-123.3),(1020.0,-2.142,-124.4),(1020.0,-2.012,-123.4),(1020.0,-2.109,-124.5),(1023.0,-41.23,-108.9),(1026.0,-41.92,-109.1),(1026.0,-49.12,-95.52),(1023.0,-50.18,-96.54),(1029.0,-47.43,-98.38),(1030.0,-46.51,-103.1),(1019.0,-49.77,-100.0),(1031.0,-20.81,-102.3),(1031.0,-25.44,-102.4),(1027.0,-22.18,-104.7),(1029.0,-25.93,-105.0),(1030.0,-25.98,-108.9),(1028.0,-22.08,-108.4),(1031.0,-21.18,-110.7),(1033.0,-24.86,-101.4),(1032.0,-25.64,-110.7),(1034.0,-24.94,-110.7),(1034.0,-20.02,-107.2),(1036.0,-24.35,-107.1),(1035.0,-24.35,-103.5),(1033.0,-28.41,-99.97),(1032.0,-29.06,-110.6),(1035.0,-30.16,-109.2),(1036.0,-30.52,-105.3),(1035.0,-29.8,-102.6),(1030.0,-36.7,-96.27),(1027.0,-35.13,-97.52),(1026.0,-33.14,-101.7),(1026.0,-33.34,-106.8),(1029.0,-36.18,-109.0),(1032.0,-37.76,-107.5),(1034.0,-38.36,-103.5),(1033.0,-37.97,-99.32),(1026.0,-44.88,-94.37),(1024.0,-40.46,-94.54),(1021.0,-38.25,-100.0),(1024.0,-38.94,-107.9),(1022.0,-46.94,-94.47),(1022.0,-43.92,-94.2),(1018.0,-44.4,-96.99),(1019.0,-46.23,-97.29),(1017.0,-47.78,-103.7),(1016.0,-45.77,-103.3),(1019.0,-44.59,-108.0),(1018.0,-42.73,-98.4),(1018.0,-41.11,-101.4),(1017.0,-42.95,-104.2),(1019.0,-41.04,-105.0),(1018.0,-42.7,-106.7),(1021.0,-43.28,-109.6),(1028.0,-15.28,-102.7),(1026.0,-15.75,-103.4),(1025.0,-16.36,-106.3),(1026.0,-16.37,-109.8),(1027.0,-16.12,-111.6),(1029.0,-15.41,-111.0),(1030.0,-15.0,-108.3),(1030.0,-14.94,-104.6),(1025.0,-9.095,-104.9),(1023.0,-9.616,-105.2),(1022.0,-10.09,-107.6),(1023.0,-10.13,-110.5),(1024.0,-9.781,-112.1),(1026.0,-9.2,-111.5),(1027.0,-9.005,-109.3),(1026.0,-8.833,-106.4),(1024.0,-4.366,-107.5),(1022.0,-4.788,-107.1),(1021.0,-5.218,-109.1),(1022.0,-5.064,-110.5),(1023.0,-4.674,-111.7),(1025.0,-4.304,-111.4),(1026.0,-4.051,-109.7),(1025.0,-4.108,-108.3),(1027.0,-2.716,-108.3),(1028.0,-2.469,-110.2),(1030.0,-1.168,-110.1),(1028.0,-1.155,-108.5),(1027.0,-2.921,-111.7),(1028.0,-1.519,-112.9),(1030.0,-1.317,-112.2),(1025.0,-3.193,-112.8),(1020.0,-4.05,-112.0),(1020.0,-2.987,-111.7),(1022.0,-3.015,-112.9),(1020.0,-3.913,-109.2),(1020.0,-2.868,-109.4),(1021.0,-3.717,-106.9),(1021.0,-2.627,-107.3),(1025.0,-3.212,-107.3),(1022.0,-2.561,-106.9),(1028.0,-0.4582,-108.8),(1031.0,-0.4469,-111.5),(1027.0,-0.7155,-112.8),(1021.0,-4.588,-107.6),(1021.0,-4.846,-111.0),(1020.0,-0.8082,-110.5),(1021.0,-0.7314,-109.4),(1021.0,-0.7862,-110.6),(1021.0,-0.7094,-109.5),(1025.0,-76.37,-100.3),(1020.0,-75.11,-93.75),(1017.0,-80.96,-98.19),(1024.0,-70.19,-101.5),(1024.0,-76.31,-99.01),(1023.0,-76.66,-94.69),(1022.0,-75.82,-94.22),(1024.0,-79.18,-99.5),(1022.0,-80.61,-98.9),(1019.0,-80.95,-98.4),(1026.0,-74.12,-101.0),(1026.0,-72.18,-101.3),(1026.0,-71.03,-101.6),(1017.0,-73.88,-95.28),(1018.0,-75.91,-93.76),(1012.0,-76.99,-98.4),(1013.0,-78.85,-98.05),(1015.0,-80.75,-98.01),(1015.0,-72.8,-99.73),(1018.0,-71.4,-100.4),(1020.0,-70.9,-100.9),(1020.0,-75.87,-93.34),(1017.0,-79.32,-93.63),(1017.0,-80.48,-95.44),(1023.0,-70.86,-97.62),(1022.0,-71.64,-96.04),(1021.0,-73.58,-94.29),(1023.0,-79.43,-96.82),(1022.0,-77.29,-94.05),(1019.0,-80.18,-95.36),(1026.0,-74.1,-100.1),(1025.0,-71.32,-99.32),(1023.0,-73.61,-95.61),(1013.0,-77.82,-94.98),(1014.0,-79.53,-94.56),(1016.0,-77.96,-92.85),(1019.0,-73.77,-94.64),(1021.0,-71.26,-97.04),(1020.0,-80.91,-98.64),(1024.0,-77.88,-99.91),(1025.0,-75.89,-100.4),(1025.0,-75.59,-100.5),(1026.0,-74.92,-100.7),(1025.0,-74.71,-99.86),(1025.0,-75.25,-99.88),(1026.0,-74.36,-100.9),(1026.0,-73.88,-101.0),(1025.0,-73.69,-101.0),(1026.0,-73.26,-101.1),(1025.0,-73.58,-99.78),(1025.0,-73.0,-99.38),(1024.0,-75.11,-99.51),(1025.0,-73.87,-99.25),(1024.0,-72.43,-97.99),(1024.0,-71.78,-97.31),(1025.0,-70.31,-100.2),(1025.0,-72.71,-101.2),(1025.0,-71.93,-101.3),(1025.0,-71.39,-101.5),(1025.0,-70.53,-101.7),(1022.0,-70.41,-101.2),(1025.0,-72.06,-99.55),(1026.0,-73.07,-101.2),(1026.0,-72.46,-101.3),(1025.0,-72.55,-99.36),(1026.0,-73.24,-100.3),(1025.0,-73.85,-97.5),(1025.0,-74.36,-99.78),(1026.0,-74.53,-100.3),(1025.0,-72.24,-99.53),(1024.0,-76.75,-96.14),(1024.0,-75.86,-99.41),(1023.0,-75.15,-94.57),(1024.0,-77.31,-96.19),(1024.0,-75.6,-98.07),(1024.0,-75.72,-99.81),(1024.0,-76.0,-95.87),(1023.0,-76.19,-94.82),(1024.0,-76.36,-98.16),(1025.0,-76.81,-97.91),(1022.0,-78.57,-94.93),(1021.0,-80.01,-95.9),(1024.0,-72.88,-96.73),(1019.0,-71.43,-100.6),(1025.0,-77.07,-100.1),(1025.0,-71.03,-98.91),(1024.0,-76.07,-99.73),(1025.0,-76.68,-99.12),(1025.0,-77.15,-98.58),(1023.0,-75.47,-95.73),(1024.0,-74.77,-98.32),(1023.0,-74.73,-95.75),(1025.0,-73.44,-99.06),(1013.0,-73.77,-99.16),(1013.0,-74.92,-95.37),(1014.0,-79.98,-97.96),(1014.0,-72.82,-98.78),(1013.0,-73.11,-98.66),(1013.0,-72.9,-99.41),(1013.0,-72.57,-99.44),(1012.0,-72.05,-99.42),(1011.0,-71.14,-99.53),(1011.0,-69.34,-99.87),(1009.0,-67.47,-100.1),(1009.0,-66.56,-100.3),(1010.0,-64.19,-101.0),(1012.0,-63.29,-101.4),(1014.0,-63.41,-101.6),(1014.0,-65.12,-101.3),(1015.0,-67.19,-101.0),(1015.0,-69.95,-100.4),(1014.0,-71.43,-99.87),(1015.0,-71.7,-99.91),(1015.0,-72.03,-99.87),(1011.0,-66.75,-99.48),(1013.0,-68.18,-99.37),(1014.0,-72.36,-98.93),(1013.0,-66.48,-100.1),(1013.0,-64.66,-100.4),(1013.0,-69.5,-99.38),(1013.0,-70.83,-99.23),(1013.0,-71.83,-98.84),(1012.0,-65.27,-100.2),(1013.0,-71.82,-98.89),(1013.0,-72.24,-98.85),(1013.0,-72.65,-98.8),(1017.0,-73.81,-94.27),(1018.0,-73.68,-94.46),(1018.0,-73.64,-94.68),(1018.0,-73.7,-94.78),(1018.0,-73.79,-94.93),(1018.0,-74.01,-94.95),(1018.0,-74.26,-94.77),(1017.0,-74.38,-93.86),(1017.0,-74.29,-94.11),(1018.0,-74.38,-94.27),(1018.0,-74.82,-94.49),(1018.0,-74.63,-94.74),(1018.0,-74.58,-94.67),(1017.0,-74.25,-93.58),(1017.0,-74.35,-93.71),(1017.0,-75.03,-93.86),(1018.0,-75.1,-94.33),(1018.0,-74.78,-94.39),(1017.0,-74.69,-93.19),(1017.0,-75.28,-93.69),(1017.0,-75.6,-93.96),(1018.0,-75.61,-93.94),(1016.0,-75.16,-92.94),(1017.0,-75.24,-93.08),(1017.0,-75.7,-93.14),(1017.0,-76.06,-93.6),(1017.0,-76.0,-93.79),(1017.0,-75.6,-92.81),(1017.0,-76.25,-93.28),(1017.0,-76.29,-93.51),(1018.0,-76.15,-93.84),(1018.0,-76.19,-93.68),(1017.0,-76.13,-92.71),(1017.0,-76.35,-92.71),(1017.0,-76.45,-92.85),(1017.0,-76.59,-93.0),(1017.0,-76.59,-93.25),(1018.0,-76.43,-93.54),(1018.0,-73.78,-94.04),(1018.0,-73.65,-94.23),(1018.0,-73.61,-94.44),(1018.0,-73.76,-94.7),(1018.0,-73.96,-94.72),(1017.0,-74.35,-93.63),(1018.0,-74.26,-93.88),(1018.0,-74.35,-94.03),(1017.0,-74.22,-93.35),(1017.0,-74.75,-93.19),(1017.0,-75.25,-93.46),(1017.0,-74.66,-92.96),(1017.0,-75.13,-92.71),(1017.0,-75.21,-92.85),(1017.0,-75.67,-92.91),(1017.0,-76.03,-93.37),(1017.0,-75.57,-92.58),(1017.0,-76.02,-92.77),(1017.0,-76.22,-93.05),(1018.0,-76.26,-93.28),(1017.0,-76.1,-92.48),(1017.0,-76.32,-92.48),(1017.0,-76.42,-92.62),(1017.0,-76.56,-92.76),(1018.0,-76.56,-93.02),(1018.0,-76.4,-93.31),(1020.0,-76.04,-105.8),(1024.0,-76.49,-101.4),(1023.0,-77.46,-105.1),(1021.0,-76.69,-105.6),(1017.0,-74.25,-104.1),(1017.0,-76.61,-104.8),(1019.0,-76.96,-105.7),(1016.0,-80.06,-103.3),(1017.0,-80.79,-101.3),(1023.0,-71.2,-104.6),(1022.0,-72.4,-105.7),(1020.0,-74.49,-106.2),(1023.0,-79.91,-102.1),(1021.0,-78.44,-105.1),(1019.0,-80.58,-101.7),(1026.0,-74.22,-101.7),(1024.0,-71.63,-103.4),(1023.0,-74.37,-105.5),(1013.0,-78.32,-101.5),(1014.0,-80.06,-101.5),(1015.0,-78.93,-104.4),(1019.0,-74.6,-105.3),(1020.0,-71.83,-104.5),(1025.0,-74.83,-101.4),(1024.0,-75.34,-101.1),(1025.0,-73.75,-102.1),(1025.0,-73.26,-102.8),(1024.0,-75.26,-101.4),(1024.0,-74.11,-102.3),(1024.0,-72.9,-104.1),(1023.0,-72.06,-104.7),(1025.0,-70.53,-103.2),(1025.0,-72.32,-102.9),(1025.0,-72.83,-103.0),(1026.0,-73.36,-101.9),(1024.0,-74.37,-104.1),(1025.0,-74.51,-101.7),(1026.0,-74.61,-101.4),(1025.0,-72.5,-102.9),(1024.0,-77.35,-103.9),(1024.0,-75.99,-101.1),(1022.0,-76.01,-105.7),(1024.0,-77.88,-103.6),(1024.0,-75.96,-102.5),(1024.0,-75.8,-100.9),(1023.0,-76.67,-104.3),(1023.0,-76.95,-105.1),(1024.0,-76.66,-102.1),(1024.0,-77.15,-102.3),(1021.0,-79.31,-103.6),(1021.0,-80.38,-102.0),(1023.0,-73.53,-104.8),(1024.0,-71.21,-103.8),(1024.0,-76.16,-100.8),(1025.0,-76.84,-101.3),(1025.0,-77.38,-101.6),(1023.0,-76.17,-104.4),(1024.0,-75.15,-102.5),(1023.0,-75.43,-104.9),(1025.0,-73.84,-102.8),(1013.0,-75.46,-102.4),(1014.0,-72.94,-100.4),(1013.0,-73.23,-100.2),(1011.0,-68.15,-100.9),(1012.0,-69.46,-100.8),(1014.0,-72.48,-100.4),(1013.0,-67.22,-101.7),(1013.0,-64.76,-102.0),(1013.0,-70.72,-100.4),(1013.0,-71.92,-100.4),(1011.0,-65.96,-101.6),(1013.0,-71.92,-100.3),(1013.0,-72.35,-100.3),(1013.0,-72.76,-100.2),(1017.0,-74.65,-105.1),(1017.0,-74.49,-105.0),(1017.0,-74.42,-104.9),(1017.0,-74.47,-104.8),(1018.0,-74.54,-104.7),(1018.0,-74.73,-104.6),(1018.0,-75.02,-104.6),(1016.0,-75.25,-105.2),(1017.0,-75.13,-105.1),(1017.0,-75.2,-104.9),(1017.0,-75.59,-104.5),(1017.0,-75.37,-104.4),(1018.0,-75.35,-104.7),(1016.0,-75.16,-105.4),(1016.0,-75.24,-105.3),(1016.0,-75.87,-104.9),(1017.0,-75.88,-104.6),(1017.0,-75.59,-104.8),(1016.0,-75.63,-105.5),(1016.0,-76.14,-104.9),(1017.0,-76.42,-104.6),(1016.0,-76.12,-105.5),(1016.0,-76.19,-105.4),(1016.0,-76.63,-105.2),(1016.0,-76.91,-104.7),(1017.0,-76.83,-104.6),(1016.0,-76.57,-105.5),(1016.0,-77.14,-104.9),(1017.0,-77.15,-104.8),(1017.0,-76.97,-104.5),(1017.0,-77.09,-104.8),(1016.0,-77.1,-105.4),(1016.0,-77.32,-105.3),(1016.0,-77.4,-105.2),(1016.0,-77.51,-105.1),(1017.0,-77.49,-104.9),(1017.0,-77.29,-104.8),(1017.0,-74.6,-105.4),(1017.0,-74.5,-105.3),(1017.0,-74.43,-105.2),(1018.0,-74.55,-105.0),(1018.0,-74.74,-104.9),(1018.0,-75.02,-104.8),(1017.0,-75.26,-105.5),(1017.0,-75.14,-105.3),(1017.0,-75.21,-105.2),(1016.0,-75.17,-105.7),(1016.0,-75.7,-105.6),(1016.0,-75.64,-105.8),(1016.0,-76.19,-105.7),(1016.0,-76.13,-105.8),(1016.0,-76.64,-105.5),(1016.0,-76.92,-105.0),(1016.0,-76.58,-105.7),(1016.0,-76.99,-105.5),(1016.0,-77.15,-105.2),(1017.0,-77.16,-105.0),(1017.0,-76.97,-104.8),(1016.0,-77.11,-105.6),(1016.0,-77.32,-105.6),(1016.0,-77.41,-105.4),(1016.0,-77.52,-105.3),(1017.0,-77.49,-105.1),(1017.0,-77.3,-105.0),(1022.0,-72.57,-94.97),(1021.0,-73.31,-106.2),(1019.0,-57.11,-91.29),(1018.0,-58.87,-115.3),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1),(1021.0,-55.62,-104.9),(1031.0,-50.77,-106.8),(1031.0,-58.29,-104.4),(1021.0,-52.58,-105.3),(1021.0,-55.03,-99.66),(1023.0,-53.88,-96.23),(1026.0,-54.27,-96.65),(1026.0,-52.31,-96.14),(1030.0,-57.62,-97.92),(1028.0,-51.52,-98.19),(1030.0,-50.89,-101.2),(1023.0,-52.73,-98.96),(1030.0,-58.67,-110.7),(1021.0,-55.91,-110.5),(1023.0,-55.3,-113.7),(1026.0,-55.72,-113.6),(1025.0,-53.81,-115.0),(1028.0,-52.78,-114.2),(1029.0,-51.78,-111.7),(1023.0,-53.82,-111.9),(1025.0,-65.85,-112.3),(1016.0,-64.37,-112.8),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1017.0,-67.84,-109.1),(1019.0,-70.61,-100.8),(1020.0,-59.06,-103.7),(1018.0,-63.87,-102.5),(1030.0,-62.67,-102.8),(1028.0,-65.35,-103.3),(1032.0,-62.79,-109.1),(1031.0,-64.17,-105.3),(1031.0,-64.18,-111.8),(1029.0,-65.51,-109.1),(1032.0,-60.26,-109.3),(1019.0,-72.97,-100.0),(1019.0,-58.63,-97.76),(1018.0,-67.0,-96.07),(1021.0,-57.92,-93.71),(1027.0,-60.93,-91.66),(1027.0,-57.78,-94.76),(1032.0,-61.84,-97.43),(1031.0,-62.75,-94.23),(1028.0,-64.83,-96.27),(1031.0,-63.78,-100.5),(1028.0,-65.19,-101.2),(1024.0,-64.05,-92.55),(1030.0,-61.67,-92.25),(1031.0,-59.95,-94.22),(1032.0,-59.37,-98.44),(1029.0,-59.35,-92.05),(1029.0,-58.34,-93.76),(1031.0,-58.47,-97.16),(1023.0,-61.75,-91.45),(1021.0,-61.37,-91.53),(1020.0,-69.49,-97.03),(1018.0,-62.52,-89.91),(1019.0,-68.26,-97.1),(1021.0,-71.8,-97.32),(1018.0,-65.96,-89.25),(1018.0,-66.62,-92.7),(1024.0,-68.35,-101.3),(1022.0,-68.07,-97.57),(1025.0,-66.87,-99.26),(1025.0,-66.53,-101.6),(1026.0,-67.08,-103.4),(1022.0,-68.76,-99.46),(1023.0,-70.78,-100.8),(1021.0,-71.49,-98.32),(1022.0,-69.15,-103.0),(1021.0,-71.78,-102.5),(1025.0,-68.15,-104.9),(1031.0,-59.61,-111.1),(1030.0,-63.48,-114.4),(1031.0,-61.38,-113.3),(1020.0,-70.02,-105.3),(1021.0,-72.33,-103.8),(1016.0,-67.77,-112.9),(1019.0,-59.66,-110.4),(1018.0,-67.64,-108.0),(1021.0,-59.56,-113.7),(1027.0,-63.03,-115.3),(1027.0,-59.34,-113.9),(1028.0,-61.51,-115.7),(1029.0,-60.05,-114.6),(1018.0,-63.21,-114.9),(1032.0,-61.65,-109.2),(1032.0,-60.73,-97.91),(1032.0,-63.64,-102.8),(1021.0,-69.12,-106.2),(1021.0,-61.42,-92.07),(1018.0,-63.18,-115.0),(1023.0,-66.46,-93.28),(1022.0,-67.88,-110.4),(1017.0,-68.31,-109.2),(1018.0,-67.1,-92.39),(1019.0,-68.82,-96.56),(1019.0,-69.39,-106.7),(1019.0,-71.73,-102.7),(1019.0,-72.77,-103.5),(1019.0,-70.32,-102.9),(1019.0,-71.56,-98.68),(1020.0,-72.18,-97.26),(1019.0,-70.06,-99.06),(1019.0,-72.28,-100.2),(1022.0,-65.38,-87.03),(1019.0,-64.58,-86.97),(1022.0,-61.98,-86.2),(1022.0,-62.78,-85.03),(1024.0,-61.36,-87.92),(1024.0,-65.22,-88.49),(1020.0,-53.19,-91.75),(1023.0,-52.38,-89.04),(1022.0,-53.54,-86.04),(1020.0,-54.18,-85.63),(1018.0,-57.74,-88.13),(1020.0,-50.27,-91.55),(1018.0,-50.49,-90.27),(1018.0,-52.34,-88.52),(1024.0,-47.67,-89.99),(1022.0,-47.38,-92.23),(1023.0,-39.65,-92.97),(1025.0,-40.19,-91.42),(1021.0,-47.06,-91.0),(1022.0,-38.81,-90.58),(1019.0,-46.79,-88.19),(1019.0,-47.8,-89.34),(1018.0,-50.34,-88.71),(1019.0,-50.24,-86.44),(1023.0,-39.14,-88.92),(1021.0,-46.99,-86.58),(1024.0,-39.65,-89.13),(1023.0,-47.29,-86.83),(1021.0,-50.12,-85.79),(1022.0,-50.6,-86.46),(1027.0,-38.59,-91.07),(1027.0,-38.55,-90.07),(1026.0,-36.82,-89.31),(1026.0,-39.29,-91.81),(1027.0,-40.01,-90.79),(1024.0,-35.84,-89.03),(1029.0,-36.86,-91.29),(1028.0,-37.15,-89.12),(1029.0,-37.28,-88.75),(1029.0,-36.76,-92.82),(1028.0,-36.81,-92.46),(1028.0,-36.33,-91.55),(1028.0,-36.5,-92.85),(1028.0,-36.89,-91.24),(1028.0,-36.15,-93.35),(1027.0,-36.21,-92.96),(1027.0,-35.86,-91.61),(1027.0,-36.25,-91.48),(1027.0,-35.82,-93.17),(1027.0,-35.94,-92.89),(1026.0,-35.97,-92.46),(1026.0,-35.54,-91.43),(1027.0,-35.93,-91.27),(1026.0,-35.62,-92.82),(1026.0,-35.69,-89.13),(1026.0,-36.09,-89.54),(1025.0,-35.62,-89.67),(1026.0,-35.75,-90.29),(1026.0,-35.82,-91.53),(1025.0,-35.84,-91.49),(1025.0,-35.39,-90.33),(1025.0,-35.74,-90.29),(1025.0,-35.54,-91.69),(1025.0,-35.3,-89.19),(1027.0,-38.88,-89.2),(1027.0,-38.09,-87.38),(1026.0,-37.43,-87.44),(1025.0,-36.48,-88.3),(1029.0,-36.53,-90.87),(1029.0,-36.52,-91.79),(1028.0,-36.94,-87.88),(1029.0,-36.61,-89.55),(1028.0,-36.57,-88.86),(1028.0,-36.19,-88.21),(1028.0,-35.96,-89.8),(1028.0,-35.92,-91.22),(1028.0,-35.93,-92.01),(1027.0,-36.06,-89.05),(1027.0,-35.86,-88.4),(1027.0,-35.64,-89.47),(1027.0,-35.58,-91.62),(1027.0,-35.61,-90.9),(1026.0,-35.42,-89.93),(1026.0,-35.42,-90.5),(1026.0,-35.44,-88.9),(1025.0,-35.7,-88.39),(1029.0,-38.48,-91.66),(1030.0,-39.03,-92.3),(1030.0,-38.8,-91.76),(1028.0,-39.01,-92.12),(1030.0,-39.33,-91.84),(1029.0,-39.46,-91.33),(1028.0,-39.58,-91.02),(1029.0,-38.93,-90.6),(1029.0,-38.9,-90.85),(1030.0,-39.12,-91.36),(1021.0,-64.65,-86.22),(1019.0,-67.56,-116.2),(1018.0,-66.71,-116.4),(1018.0,-64.4,-118.3),(1020.0,-65.51,-119.6),(1022.0,-63.84,-117.8),(1021.0,-67.05,-115.7),(1019.0,-55.05,-116.8),(1022.0,-54.85,-120.5),(1021.0,-56.39,-122.6),(1019.0,-56.9,-122.2),(1017.0,-59.56,-118.0),(1020.0,-52.15,-118.6),(1018.0,-52.62,-119.1),(1017.0,-54.59,-119.7),(1023.0,-49.81,-122.3),(1022.0,-49.21,-119.8),(1022.0,-41.74,-122.6),(1023.0,-42.36,-124.2),(1020.0,-49.17,-120.7),(1020.0,-41.36,-124.9),(1018.0,-49.44,-123.0),(1018.0,-50.22,-121.3),(1017.0,-52.74,-120.5),(1018.0,-53.01,-123.0),(1021.0,-41.77,-126.6),(1020.0,-49.85,-124.9),(1022.0,-42.15,-126.5),(1021.0,-50.04,-125.0),(1020.0,-52.98,-124.1),(1021.0,-53.3,-123.7),(1024.0,-40.74,-124.5),(1025.0,-40.73,-125.5),(1023.0,-39.01,-126.2),(1023.0,-41.47,-123.8),(1024.0,-42.2,-124.8),(1022.0,-38.06,-126.7),(1026.0,-38.95,-124.6),(1026.0,-39.35,-126.4),(1026.0,-39.52,-126.8),(1026.0,-38.84,-123.1),(1025.0,-38.88,-123.7),(1026.0,-38.41,-124.5),(1026.0,-38.57,-123.2),(1026.0,-38.97,-124.8),(1025.0,-38.22,-122.8),(1025.0,-38.27,-123.3),(1025.0,-37.94,-124.7),(1025.0,-38.33,-124.8),(1025.0,-37.88,-123.1),(1025.0,-38.0,-123.5),(1024.0,-38.04,-124.0),(1024.0,-37.62,-125.1),(1024.0,-38.01,-125.2),(1024.0,-37.68,-123.7),(1024.0,-37.8,-126.7),(1024.0,-38.12,-126.1),(1023.0,-37.65,-126.0),(1024.0,-37.84,-126.2),(1024.0,-37.89,-125.1),(1023.0,-37.91,-125.3),(1023.0,-37.49,-126.3),(1023.0,-37.82,-126.2),(1023.0,-37.6,-125.1),(1023.0,-37.45,-126.5),(1025.0,-41.06,-126.2),(1025.0,-40.27,-128.0),(1024.0,-39.6,-128.1),(1022.0,-38.68,-127.4),(1026.0,-38.62,-125.1),(1026.0,-38.6,-124.2),(1026.0,-39.31,-127.7),(1026.0,-38.74,-126.4),(1026.0,-38.78,-126.8),(1025.0,-38.48,-127.6),(1026.0,-38.08,-126.4),(1026.0,-38.0,-124.9),(1025.0,-38.01,-124.1),(1025.0,-38.25,-126.7),(1024.0,-38.11,-127.4),(1025.0,-37.79,-126.8),(1025.0,-37.65,-124.8),(1025.0,-37.7,-125.5),(1024.0,-37.51,-126.4),(1024.0,-37.51,-126.1),(1024.0,-37.57,-126.9),(1023.0,-37.88,-127.3),(1026.0,-40.7,-123.4),(1027.0,-41.25,-122.6),(1027.0,-41.01,-123.1),(1026.0,-41.24,-123.1),(1027.0,-41.54,-123.1),(1026.0,-41.67,-123.8),(1025.0,-41.8,-124.3),(1026.0,-41.14,-124.5),(1026.0,-41.1,-124.2),(1027.0,-41.32,-123.5),(1019.0,-67.08,-117.6),(1023.0,-63.82,-114.1),(1018.0,-63.15,-114.4),(1032.0,-46.5,-107.9),(1030.0,-43.5,-108.1),(1019.0,-47.25,-106.1),(1023.0,-41.99,-107.3),(1026.0,-41.8,-107.5),(1020.0,-50.41,-105.5),(1026.0,-51.07,-117.3),(1023.0,-51.91,-115.1),(1029.0,-49.02,-115.9),(1030.0,-47.42,-112.0),(1019.0,-50.96,-110.8),(1030.0,-22.62,-124.3),(1031.0,-27.1,-122.6),(1027.0,-23.58,-120.4),(1030.0,-27.18,-119.6),(1031.0,-26.61,-116.1),(1028.0,-22.88,-117.1),(1031.0,-21.61,-116.1),(1032.0,-26.71,-124.4),(1032.0,-25.99,-114.9),(1035.0,-25.3,-115.9),(1034.0,-21.02,-120.7),(1036.0,-25.29,-120.0),(1035.0,-25.87,-123.2),(1033.0,-30.53,-124.1),(1033.0,-29.46,-113.4),(1035.0,-30.78,-115.0),(1037.0,-31.77,-119.0),(1035.0,-31.48,-121.5),(1030.0,-39.08,-123.2),(1027.0,-37.32,-121.9),(1026.0,-34.72,-118.5),(1027.0,-34.12,-113.6),(1030.0,-36.54,-110.7),(1033.0,-38.16,-112.4),(1034.0,-39.6,-116.5),(1033.0,-39.87,-120.3),(1026.0,-47.63,-119.8),(1023.0,-42.86,-121.4),(1024.0,-39.4,-117.3),(1023.0,-41.09,-108.4),(1025.0,-39.3,-109.4),(1022.0,-49.09,-118.2),(1022.0,-45.95,-120.2),(1018.0,-46.22,-115.9),(1019.0,-47.95,-114.9),(1018.0,-48.47,-107.7),(1017.0,-46.58,-108.8),(1019.0,-45.41,-106.5),(1020.0,-44.75,-105.6),(1018.0,-44.4,-115.2),(1020.0,-41.11,-114.4),(1018.0,-43.73,-109.3),(1022.0,-40.82,-111.1),(1020.0,-43.08,-107.1),(1022.0,-43.26,-105.1),(1028.0,-17.26,-125.8),(1026.0,-17.64,-124.5),(1025.0,-17.76,-121.1),(1026.0,-17.19,-117.9),(1028.0,-16.64,-116.8),(1029.0,-16.03,-118.2),(1030.0,-16.06,-121.2),(1029.0,-16.6,-124.6),(1024.0,-11.0,-125.7),(1022.0,-11.48,-124.8),(1022.0,-11.56,-122.1),(1022.0,-11.13,-119.5),(1024.0,-10.51,-118.4),(1026.0,-10.02,-119.7),(1026.0,-10.18,-122.1),(1026.0,-10.49,-124.8),(1023.0,-5.91,-125.2),(1021.0,-6.566,-125.0),(1021.0,-6.69,-122.8),(1021.0,-6.291,-121.5),(1023.0,-5.532,-121.1),(1024.0,-4.99,-121.9),(1025.0,-4.914,-123.7),(1024.0,-5.263,-124.9),(1026.0,-4.296,-125.8),(1027.0,-3.739,-124.2),(1029.0,-2.465,-125.4),(1027.0,-2.74,-126.5),(1026.0,-3.959,-122.4),(1027.0,-2.41,-122.1),(1030.0,-2.279,-123.3),(1024.0,-4.083,-120.8),(1020.0,-5.113,-120.4),(1020.0,-4.12,-121.1),(1021.0,-3.943,-120.3),(1019.0,-5.423,-123.0),(1019.0,-4.373,-123.3),(1020.0,-5.756,-125.4),(1020.0,-4.464,-125.5),(1024.0,-4.962,-126.2),(1021.0,-4.435,-126.3),(1027.0,-2.054,-126.5),(1030.0,-1.517,-124.5),(1027.0,-1.687,-122.5),(1020.0,-6.366,-124.5),(1020.0,-6.077,-121.0),(1020.0,-2.341,-123.2),(1020.0,-2.436,-124.3),(1020.0,-2.288,-123.3),(1020.0,-2.384,-124.4),(1024.0,-41.55,-108.9),(1027.0,-42.16,-109.2),(1028.0,-49.39,-95.61),(1024.0,-50.48,-96.62),(1030.0,-47.67,-98.47),(1031.0,-46.74,-103.2),(1020.0,-50.13,-100.1),(1031.0,-20.93,-102.3),(1031.0,-25.55,-102.5),(1027.0,-22.35,-104.7),(1030.0,-26.07,-105.0),(1031.0,-26.11,-108.9),(1028.0,-22.24,-108.4),(1031.0,-21.29,-110.7),(1033.0,-24.95,-101.4),(1032.0,-25.74,-110.7),(1035.0,-24.99,-110.7),(1034.0,-20.09,-107.3),(1037.0,-24.38,-107.2),(1036.0,-24.4,-103.6),(1034.0,-28.5,-100.0),(1033.0,-29.17,-110.7),(1035.0,-30.21,-109.3),(1037.0,-30.53,-105.4),(1036.0,-29.84,-102.7),(1031.0,-36.85,-96.34),(1028.0,-35.37,-97.58),(1027.0,-33.39,-101.8),(1027.0,-33.59,-106.9),(1030.0,-36.35,-109.0),(1033.0,-37.86,-107.5),(1035.0,-38.42,-103.6),(1034.0,-38.06,-99.41),(1027.0,-45.16,-94.45),(1025.0,-40.78,-94.61),(1022.0,-38.58,-100.1),(1025.0,-39.24,-108.0),(1023.0,-47.27,-94.54),(1023.0,-44.24,-94.26),(1019.0,-44.77,-97.04),(1020.0,-46.59,-97.35),(1018.0,-48.16,-103.7),(1018.0,-46.16,-103.4),(1020.0,-44.94,-108.0),(1019.0,-43.11,-98.44),(1019.0,-41.48,-101.4),(1018.0,-43.33,-104.2),(1021.0,-41.39,-105.0),(1020.0,-43.06,-106.8),(1022.0,-43.61,-109.6),(1029.0,-15.44,-102.7),(1027.0,-15.94,-103.4),(1026.0,-16.57,-106.3),(1026.0,-16.56,-109.8),(1028.0,-16.29,-111.6),(1030.0,-15.55,-111.0),(1031.0,-15.12,-108.3),(1030.0,-15.07,-104.7),(1025.0,-9.307,-104.9),(1024.0,-9.854,-105.2),(1023.0,-10.34,-107.6),(1023.0,-10.37,-110.4),(1024.0,-10.0,-112.1),(1026.0,-9.392,-111.5),(1027.0,-9.184,-109.3),(1027.0,-9.02,-106.4),(1024.0,-4.579,-107.5),(1022.0,-5.044,-107.1),(1021.0,-5.491,-109.1),(1022.0,-5.325,-110.5),(1024.0,-4.884,-111.6),(1025.0,-4.469,-111.3),(1026.0,-4.199,-109.7),(1025.0,-4.268,-108.3),(1027.0,-2.822,-108.3),(1028.0,-2.553,-110.2),(1030.0,-1.172,-110.1),(1028.0,-1.236,-108.5),(1027.0,-3.027,-111.7),(1028.0,-1.598,-112.9),(1030.0,-1.318,-112.2),(1025.0,-3.364,-112.8),(1021.0,-4.347,-111.9),(1020.0,-3.288,-111.7),(1022.0,-3.267,-112.8),(1020.0,-4.224,-109.2),(1020.0,-3.185,-109.4),(1021.0,-4.016,-106.9),(1021.0,-2.931,-107.3),(1025.0,-3.382,-107.3),(1022.0,-2.814,-106.9),(1028.0,-0.5403,-108.8),(1031.0,-0.4376,-111.5),(1027.0,-0.8013,-112.8),(1021.0,-4.873,-107.6),(1021.0,-5.131,-111.0),(1020.0,-1.111,-110.5),(1021.0,-1.034,-109.4),(1021.0,-1.069,-110.5),(1021.0,-0.9922,-109.5),(1026.0,-76.66,-100.4),(1022.0,-75.45,-93.87),(1019.0,-81.34,-98.31),(1026.0,-70.49,-101.7),(1026.0,-76.6,-99.15),(1025.0,-76.97,-94.82),(1024.0,-76.14,-94.35),(1026.0,-79.48,-99.64),(1023.0,-80.93,-99.04),(1020.0,-81.31,-98.53),(1028.0,-74.39,-101.1),(1027.0,-72.45,-101.5),(1027.0,-71.31,-101.7),(1019.0,-74.26,-95.39),(1020.0,-76.28,-93.88),(1014.0,-77.42,-98.5),(1015.0,-79.28,-98.16),(1017.0,-81.14,-98.13),(1017.0,-73.2,-99.83),(1019.0,-71.77,-100.5),(1022.0,-71.24,-101.0),(1022.0,-76.22,-93.47),(1019.0,-79.7,-93.76),(1019.0,-80.86,-95.56),(1025.0,-71.17,-97.74),(1024.0,-71.96,-96.16),(1023.0,-73.91,-94.42),(1025.0,-79.74,-96.96),(1024.0,-77.62,-94.18),(1021.0,-80.54,-95.49),(1028.0,-74.37,-100.2),(1026.0,-71.61,-99.45),(1025.0,-73.92,-95.74),(1015.0,-78.24,-95.08),(1016.0,-79.94,-94.67),(1018.0,-78.35,-92.97),(1021.0,-74.13,-94.75),(1023.0,-71.59,-97.16),(1022.0,-81.25,-98.77),(1026.0,-78.17,-100.0),(1027.0,-76.17,-100.6),(1027.0,-75.87,-100.6),(1027.0,-75.2,-100.9),(1027.0,-75.0,-100.0),(1026.0,-75.54,-100.0),(1028.0,-74.63,-101.1),(1027.0,-74.15,-101.1),(1027.0,-73.97,-101.1),(1028.0,-73.53,-101.3),(1027.0,-73.86,-99.91),(1027.0,-73.28,-99.51),(1026.0,-75.41,-99.65),(1026.0,-74.16,-99.38),(1026.0,-72.72,-98.12),(1025.0,-72.08,-97.44),(1027.0,-70.59,-100.3),(1027.0,-72.98,-101.3),(1027.0,-72.21,-101.5),(1027.0,-71.67,-101.6),(1027.0,-70.81,-101.8),(1023.0,-70.73,-101.3),(1027.0,-72.35,-99.68),(1028.0,-73.34,-101.3),(1027.0,-72.73,-101.4),(1027.0,-72.83,-99.49),(1027.0,-73.52,-100.4),(1027.0,-74.14,-97.64),(1027.0,-74.64,-99.92),(1028.0,-74.8,-100.4),(1027.0,-72.52,-99.66),(1026.0,-77.05,-96.28),(1026.0,-76.15,-99.55),(1025.0,-75.47,-94.7),(1026.0,-77.6,-96.33),(1026.0,-75.89,-98.21),(1026.0,-76.01,-99.95),(1026.0,-76.3,-96.01),(1025.0,-76.49,-94.95),(1026.0,-76.65,-98.3),(1026.0,-77.1,-98.05),(1024.0,-78.89,-95.06),(1023.0,-80.34,-96.03),(1026.0,-73.17,-96.86),(1021.0,-71.78,-100.7),(1027.0,-77.36,-100.3),(1026.0,-71.32,-99.04),(1026.0,-76.36,-99.87),(1027.0,-76.96,-99.26),(1027.0,-77.43,-98.73),(1025.0,-75.77,-95.86),(1026.0,-75.06,-98.46),(1025.0,-75.03,-95.88),(1027.0,-73.72,-99.2),(1014.0,-74.2,-99.25),(1015.0,-75.35,-95.47),(1016.0,-80.4,-98.07),(1016.0,-73.24,-98.88),(1015.0,-73.53,-98.75),(1015.0,-73.33,-99.5),(1014.0,-73.0,-99.53),(1013.0,-72.49,-99.51),(1013.0,-71.59,-99.62),(1012.0,-69.79,-99.95),(1011.0,-67.94,-100.1),(1011.0,-67.03,-100.4),(1012.0,-64.64,-101.1),(1013.0,-63.73,-101.5),(1015.0,-63.82,-101.7),(1015.0,-65.53,-101.3),(1017.0,-67.59,-101.1),(1017.0,-70.35,-100.5),(1016.0,-71.85,-99.97),(1016.0,-72.1,-100.0),(1017.0,-72.43,-99.97),(1013.0,-67.2,-99.55),(1014.0,-68.61,-99.45),(1016.0,-72.78,-99.03),(1015.0,-66.9,-100.2),(1014.0,-65.09,-100.5),(1014.0,-69.93,-99.46),(1014.0,-71.26,-99.32),(1015.0,-72.25,-98.94),(1013.0,-65.72,-100.3),(1014.0,-72.25,-98.98),(1015.0,-72.67,-98.94),(1015.0,-73.07,-98.9),(1019.0,-74.19,-94.38),(1019.0,-74.05,-94.57),(1020.0,-74.01,-94.79),(1020.0,-74.07,-94.89),(1020.0,-74.15,-95.05),(1020.0,-74.38,-95.06),(1020.0,-74.62,-94.89),(1019.0,-74.76,-93.98),(1019.0,-74.67,-94.23),(1020.0,-74.75,-94.38),(1019.0,-75.19,-94.61),(1020.0,-75.0,-94.85),(1020.0,-74.95,-94.78),(1019.0,-74.64,-93.69),(1019.0,-74.73,-93.82),(1019.0,-75.41,-93.97),(1020.0,-75.47,-94.45),(1020.0,-75.15,-94.51),(1018.0,-75.07,-93.3),(1019.0,-75.66,-93.81),(1019.0,-75.98,-94.07),(1020.0,-75.99,-94.06),(1018.0,-75.54,-93.05),(1018.0,-75.62,-93.19),(1019.0,-76.08,-93.26),(1019.0,-76.44,-93.72),(1019.0,-76.38,-93.9),(1018.0,-75.98,-92.92),(1019.0,-76.62,-93.39),(1019.0,-76.66,-93.63),(1019.0,-76.52,-93.96),(1020.0,-76.56,-93.8),(1018.0,-76.51,-92.82),(1019.0,-76.73,-92.83),(1019.0,-76.84,-92.97),(1019.0,-76.96,-93.11),(1019.0,-76.97,-93.37),(1020.0,-76.8,-93.66),(1019.0,-74.16,-94.15),(1019.0,-74.02,-94.34),(1020.0,-73.98,-94.56),(1020.0,-74.12,-94.81),(1020.0,-74.32,-94.83),(1019.0,-74.73,-93.74),(1019.0,-74.64,-93.99),(1020.0,-74.72,-94.15),(1019.0,-74.61,-93.46),(1019.0,-75.13,-93.3),(1019.0,-75.63,-93.57),(1018.0,-75.04,-93.07),(1018.0,-75.51,-92.82),(1019.0,-75.59,-92.96),(1019.0,-76.05,-93.02),(1019.0,-76.41,-93.49),(1018.0,-75.95,-92.69),(1019.0,-76.4,-92.89),(1019.0,-76.59,-93.16),(1019.0,-76.63,-93.39),(1019.0,-76.48,-92.59),(1019.0,-76.7,-92.59),(1019.0,-76.81,-92.74),(1019.0,-76.93,-92.88),(1019.0,-76.94,-93.13),(1020.0,-76.77,-93.43),(1021.0,-76.38,-106.0),(1026.0,-76.78,-101.5),(1024.0,-77.76,-105.2),(1023.0,-77.01,-105.7),(1019.0,-74.62,-104.2),(1019.0,-76.98,-104.9),(1021.0,-77.31,-105.9),(1018.0,-80.44,-103.4),(1019.0,-81.17,-101.4),(1024.0,-71.51,-104.7),(1023.0,-72.72,-105.8),(1022.0,-74.83,-106.3),(1025.0,-80.21,-102.3),(1022.0,-78.77,-105.2),(1020.0,-80.93,-101.9),(1027.0,-74.5,-101.9),(1026.0,-71.92,-103.5),(1024.0,-74.68,-105.6),(1015.0,-78.75,-101.6),(1016.0,-80.47,-101.6),(1017.0,-79.32,-104.5),(1021.0,-74.95,-105.5),(1022.0,-72.17,-104.7),(1026.0,-75.11,-101.6),(1026.0,-75.63,-101.2),(1027.0,-74.04,-102.2),(1027.0,-73.54,-102.9),(1026.0,-75.55,-101.6),(1026.0,-74.4,-102.5),(1026.0,-73.19,-104.2),(1025.0,-72.36,-104.8),(1026.0,-70.81,-103.3),(1026.0,-72.61,-103.0),(1027.0,-73.11,-103.1),(1027.0,-73.64,-102.0),(1026.0,-74.66,-104.2),(1027.0,-74.79,-101.9),(1028.0,-74.88,-101.5),(1027.0,-72.78,-103.1),(1026.0,-77.64,-104.1),(1026.0,-76.28,-101.2),(1024.0,-76.32,-105.8),(1026.0,-78.17,-103.8),(1026.0,-76.26,-102.6),(1026.0,-76.09,-101.0),(1025.0,-76.97,-104.4),(1025.0,-77.26,-105.2),(1025.0,-76.95,-102.2),(1026.0,-77.44,-102.4),(1023.0,-79.63,-103.7),(1023.0,-80.71,-102.1),(1025.0,-73.83,-104.9),(1026.0,-71.5,-103.9),(1026.0,-76.45,-100.9),(1026.0,-77.13,-101.4),(1026.0,-77.66,-101.7),(1024.0,-76.48,-104.6),(1026.0,-75.44,-102.7),(1025.0,-75.74,-105.1),(1027.0,-74.13,-102.9),(1014.0,-75.89,-102.5),(1016.0,-73.36,-100.5),(1015.0,-73.65,-100.3),(1013.0,-68.6,-101.0),(1014.0,-69.89,-100.9),(1016.0,-72.89,-100.5),(1015.0,-67.64,-101.8),(1014.0,-65.19,-102.0),(1014.0,-71.15,-100.5),(1015.0,-72.34,-100.5),(1013.0,-66.41,-101.7),(1014.0,-72.35,-100.4),(1015.0,-72.78,-100.4),(1015.0,-73.18,-100.3),(1019.0,-75.02,-105.2),(1019.0,-74.87,-105.2),(1019.0,-74.79,-105.0),(1019.0,-74.84,-105.0),(1019.0,-74.9,-104.8),(1019.0,-75.1,-104.8),(1019.0,-75.38,-104.7),(1018.0,-75.63,-105.3),(1019.0,-75.51,-105.2),(1019.0,-75.57,-105.1),(1019.0,-75.96,-104.6),(1019.0,-75.74,-104.6),(1019.0,-75.72,-104.8),(1018.0,-75.55,-105.5),(1018.0,-75.62,-105.4),(1018.0,-76.25,-105.0),(1019.0,-76.25,-104.7),(1019.0,-75.96,-104.9),(1018.0,-76.02,-105.6),(1018.0,-76.53,-105.0),(1018.0,-76.8,-104.7),(1017.0,-76.51,-105.6),(1018.0,-76.57,-105.5),(1018.0,-77.01,-105.3),(1018.0,-77.29,-104.8),(1018.0,-77.21,-104.7),(1017.0,-76.96,-105.6),(1018.0,-77.52,-105.0),(1019.0,-77.53,-104.9),(1019.0,-77.34,-104.6),(1019.0,-77.46,-104.9),(1018.0,-77.49,-105.5),(1018.0,-77.7,-105.4),(1018.0,-77.79,-105.3),(1018.0,-77.89,-105.2),(1019.0,-77.86,-105.0),(1019.0,-77.67,-104.9),(1019.0,-74.98,-105.5),(1019.0,-74.87,-105.4),(1019.0,-74.8,-105.3),(1019.0,-74.91,-105.1),(1019.0,-75.11,-105.0),(1020.0,-75.39,-105.0),(1018.0,-75.64,-105.6),(1019.0,-75.52,-105.4),(1019.0,-75.58,-105.3),(1018.0,-75.55,-105.8),(1018.0,-76.08,-105.7),(1018.0,-76.03,-105.9),(1018.0,-76.58,-105.8),(1017.0,-76.52,-105.9),(1018.0,-77.02,-105.6),(1018.0,-77.3,-105.1),(1018.0,-76.97,-105.8),(1018.0,-77.37,-105.6),(1018.0,-77.53,-105.3),(1019.0,-77.54,-105.1),(1019.0,-77.34,-104.9),(1018.0,-77.5,-105.7),(1018.0,-77.71,-105.7),(1018.0,-77.79,-105.5),(1018.0,-77.9,-105.4),(1019.0,-77.87,-105.3),(1019.0,-77.67,-105.1),(1023.0,-72.89,-95.09),(1023.0,-73.63,-106.3),(1020.0,-57.58,-91.78),(1020.0,-59.28,-115.1)])]),
        ROUTE(fromField='fraction_changed',fromNode='Body-TIMER',toField='set_fraction',toNode='Body-COORD-INTERP'),
        ROUTE(fromField='value_changed',fromNode='Body-COORD-INTERP',toField='set_point',toNode='Body-COORD')])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for LaetitiaSprints.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python LaetitiaSprints.py load and self-test diagnostics complete.")
