####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Laetitia.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.0',
  head=head(
    children=[
    meta(content='Laetitia.x3d',name='title'),
    meta(content="Rendered woman's body model, created using 3d Studio Max and then translated into X3D and VRML.",name='description'),
    meta(content='Yilmaz Degirmenci, NPS',name='creator'),
    meta(content='18 April 2002',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Not in H-Anim form.',name='warning'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Laetitia.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='Laetitia.x3d'),
    Transform(DEF='Body',rotation=(1,0,0,3.14),scale=(.092,.1,.06),translation=(0,3,-5),
      children=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=1.0,diffuseColor=(0.01961,0.3529,0.3098),shininess=0.145),
          texture=ImageTexture(url=["LaetitiaBodyTemplateColor.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/LaetitiaBodyTemplateColor.jpg"])),
        geometry=IndexedFaceSet(DEF='Body-FACES',ccw=False,coordIndex=[5,7,6,-1,7,9,6,-1,2,10,1,-1,10,2,8,-1,9,10,8,-1,8,6,9,-1,7,5,11,-1,0,3,4,-1,11,4,3,-1,5,4,11,-1,14,15,16,-1,16,15,17,-1,2,1,18,-1,18,12,2,-1,17,12,18,-1,12,17,15,-1,16,19,14,-1,0,13,3,-1,19,3,13,-1,14,19,13,-1,23,22,20,-1,23,20,21,-1,23,22,20,-1,23,20,21,-1,31,32,33,-1,30,32,31,-1,31,29,28,-1,31,33,29,-1,33,32,20,-1,32,73,20,-1,32,74,73,-1,32,30,74,-1,30,86,74,-1,74,34,72,-1,12,72,2,-1,36,37,27,-1,4,5,38,-1,38,36,4,-1,39,38,40,-1,38,5,40,-1,6,40,5,-1,0,36,26,-1,36,0,4,-1,40,6,8,-1,41,44,42,-1,42,44,43,-1,44,28,45,-1,44,45,43,-1,43,46,42,-1,42,46,47,-1,42,47,48,-1,42,48,41,-1,87,48,49,-1,47,39,50,-1,47,50,48,-1,48,50,51,-1,48,52,49,-1,48,51,52,-1,8,52,51,-1,40,51,50,-1,40,50,39,-1,40,8,51,-1,8,2,52,-1,26,36,27,-1,39,53,38,-1,54,38,53,-1,27,37,25,-1,55,103,37,-1,36,38,56,-1,56,37,36,-1,53,39,46,-1,47,46,39,-1,35,101,102,-1,101,35,104,-1,56,38,54,-1,37,56,59,-1,37,59,95,-1,62,43,63,-1,45,64,63,-1,63,43,45,-1,43,92,46,-1,88,41,30,-1,49,52,72,-1,34,49,72,-1,87,49,34,-1,65,64,29,-1,33,65,29,-1,33,20,93,-1,30,31,88,-1,31,28,88,-1,86,30,41,-1,28,29,45,-1,45,29,64,-1,66,61,67,-1,55,66,68,-1,68,58,55,-1,67,68,66,-1,57,60,92,-1,69,67,61,-1,70,75,76,-1,67,69,70,-1,65,33,71,-1,2,72,52,-1,78,27,79,-1,13,80,14,-1,80,13,78,-1,81,82,80,-1,80,82,14,-1,15,14,82,-1,0,26,78,-1,78,13,0,-1,82,12,15,-1,73,83,81,-1,73,74,83,-1,74,84,83,-1,74,72,84,-1,12,84,72,-1,82,83,84,-1,82,81,83,-1,82,84,12,-1,26,27,78,-1,81,80,22,-1,85,22,80,-1,27,25,79,-1,100,79,25,-1,78,21,80,-1,21,78,79,-1,22,20,81,-1,73,81,20,-1,99,76,98,-1,98,104,35,-1,21,85,80,-1,85,21,22,-1,20,22,21,-1,79,77,21,-1,79,75,97,-1,87,86,41,-1,86,34,74,-1,86,87,34,-1,41,48,87,-1,75,70,69,-1,88,28,44,-1,44,41,88,-1,62,66,55,-1,93,24,89,-1,89,75,71,-1,69,65,71,-1,61,65,69,-1,64,65,61,-1,64,61,63,-1,63,61,66,-1,57,62,55,-1,75,89,97,-1,69,71,75,-1,90,46,53,-1,91,21,22,-1,20,22,21,-1,23,22,20,-1,23,20,21,-1,66,62,63,-1,43,62,92,-1,33,93,71,-1,62,57,92,-1,96,57,55,-1,93,89,71,-1,97,89,24,-1,79,94,77,-1,96,60,57,-1,37,96,55,-1,37,95,96,-1,95,60,96,-1,97,24,94,-1,79,97,94,-1,98,76,75,-1,100,25,98,-1,35,99,98,-1,75,100,98,-1,75,79,100,-1,55,101,103,-1,101,55,58,-1,102,101,58,-1,103,101,25,-1,103,25,37,-1,98,25,104,-1,101,104,25,-1,105,106,201,-1,108,109,110,-1,105,201,110,-1,107,201,106,-1,106,56,107,-1,109,53,110,-1,110,59,105,-1,92,110,46,-1,59,110,60,-1,92,60,110,-1,56,106,59,-1,105,59,106,-1,111,837,112,-1,112,109,113,-1,108,107,114,-1,114,113,108,-1,115,56,111,-1,837,111,56,-1,113,109,108,-1,109,112,53,-1,115,107,56,-1,107,115,114,-1,111,116,117,-1,111,117,118,-1,112,119,116,-1,121,120,122,-1,123,121,124,-1,123,124,125,-1,123,120,121,-1,119,122,120,-1,123,125,126,-1,118,127,128,-1,124,129,130,-1,131,132,129,-1,130,133,128,-1,133,132,134,-1,132,133,130,-1,132,119,134,-1,125,124,130,-1,129,132,130,-1,132,131,122,-1,119,132,122,-1,126,125,130,-1,112,113,134,-1,134,119,112,-1,133,134,113,-1,113,114,133,-1,133,114,128,-1,116,119,120,-1,116,120,123,-1,116,126,117,-1,112,116,111,-1,115,118,114,-1,111,118,115,-1,128,126,130,-1,117,126,127,-1,128,114,118,-1,126,128,127,-1,116,123,126,-1,118,117,127,-1,135,136,137,-1,138,122,139,-1,124,121,140,-1,121,137,140,-1,137,121,135,-1,122,138,121,-1,141,142,143,-1,144,145,141,-1,146,145,147,-1,148,145,146,-1,148,142,141,-1,145,148,141,-1,147,145,144,-1,142,137,136,-1,142,136,143,-1,149,150,146,-1,151,152,150,-1,151,150,153,-1,150,152,146,-1,149,153,150,-1,154,155,151,-1,156,157,155,-1,156,155,158,-1,159,160,156,-1,155,157,151,-1,161,160,159,-1,160,157,156,-1,154,158,155,-1,162,161,159,-1,163,164,162,-1,165,166,164,-1,165,164,167,-1,168,161,165,-1,140,137,161,-1,166,161,162,-1,164,166,162,-1,161,166,165,-1,140,161,168,-1,167,164,163,-1,138,135,121,-1,169,139,131,-1,139,122,131,-1,170,131,171,-1,169,131,170,-1,140,172,129,-1,171,129,172,-1,171,131,129,-1,169,170,143,-1,140,129,124,-1,143,136,169,-1,173,174,141,-1,143,175,176,-1,141,174,144,-1,146,147,174,-1,173,176,146,-1,146,176,177,-1,144,174,147,-1,177,176,175,-1,141,176,173,-1,175,143,170,-1,177,178,179,-1,180,181,146,-1,146,181,149,-1,153,181,151,-1,151,179,182,-1,151,180,179,-1,181,153,149,-1,182,179,178,-1,146,179,180,-1,182,183,184,-1,151,185,154,-1,182,184,151,-1,158,185,156,-1,156,186,184,-1,185,158,154,-1,151,186,185,-1,156,185,186,-1,187,188,162,-1,162,188,163,-1,167,188,165,-1,165,189,168,-1,165,187,189,-1,168,190,140,-1,140,190,172,-1,188,167,163,-1,162,159,187,-1,159,190,189,-1,159,184,183,-1,159,156,184,-1,151,184,186,-1,177,179,146,-1,181,180,151,-1,143,176,141,-1,174,173,146,-1,168,189,190,-1,159,189,187,-1,188,187,165,-1,191,192,193,-1,194,192,191,-1,135,194,191,-1,192,194,195,-1,196,194,197,-1,194,138,197,-1,138,194,135,-1,191,136,135,-1,193,192,195,-1,195,194,196,-1,197,138,139,-1,191,198,136,-1,169,136,198,-1,193,199,191,-1,193,200,199,-1,191,199,198,-1,196,200,195,-1,196,198,199,-1,197,169,196,-1,139,169,197,-1,169,198,196,-1,193,195,200,-1,200,196,199,-1,142,160,137,-1,160,161,137,-1,177,175,178,-1,178,183,182,-1,183,190,159,-1,183,172,190,-1,183,171,172,-1,183,178,171,-1,171,178,175,-1,175,170,171,-1,152,160,142,-1,142,148,152,-1,146,152,148,-1,151,157,152,-1,152,157,160,-1,46,110,53,-1,59,60,95,-1,201,108,110,-1,107,108,201,-1,202,298,203,-1,205,207,206,-1,202,207,298,-1,204,203,298,-1,203,204,21,-1,206,207,299,-1,207,202,77,-1,93,20,207,-1,77,24,207,-1,93,207,24,-1,21,77,203,-1,202,203,77,-1,838,209,299,-1,299,300,838,-1,209,210,206,-1,205,211,204,-1,211,205,210,-1,212,208,21,-1,300,21,208,-1,210,205,206,-1,206,299,209,-1,212,21,204,-1,204,211,212,-1,208,214,213,-1,208,215,214,-1,209,213,216,-1,218,219,217,-1,220,221,218,-1,220,222,221,-1,220,218,217,-1,216,217,219,-1,220,223,222,-1,215,225,224,-1,221,227,226,-1,228,226,229,-1,227,225,230,-1,230,231,229,-1,229,227,230,-1,229,231,216,-1,222,227,221,-1,226,227,229,-1,229,219,228,-1,216,219,229,-1,223,227,222,-1,209,231,210,-1,231,209,216,-1,230,210,231,-1,210,230,211,-1,230,225,211,-1,213,217,216,-1,213,220,217,-1,213,214,223,-1,209,208,213,-1,212,211,215,-1,208,212,215,-1,225,227,223,-1,214,224,223,-1,225,215,211,-1,223,224,225,-1,213,223,220,-1,215,224,214,-1,232,234,233,-1,235,236,219,-1,221,237,218,-1,218,237,234,-1,234,232,218,-1,219,218,235,-1,238,240,239,-1,241,238,242,-1,243,244,242,-1,245,243,242,-1,245,238,239,-1,242,238,245,-1,244,241,242,-1,239,233,234,-1,239,240,233,-1,246,243,247,-1,248,247,249,-1,248,250,247,-1,247,243,249,-1,246,247,250,-1,251,248,252,-1,253,252,254,-1,253,255,252,-1,256,253,257,-1,252,248,254,-1,258,256,257,-1,257,253,254,-1,251,252,255,-1,259,256,258,-1,260,259,261,-1,262,261,263,-1,262,264,261,-1,265,262,258,-1,237,258,234,-1,263,259,258,-1,261,259,263,-1,258,262,263,-1,237,265,258,-1,264,260,261,-1,235,218,232,-1,266,228,236,-1,236,228,219,-1,267,268,228,-1,266,267,228,-1,237,226,269,-1,268,269,226,-1,268,226,228,-1,266,240,267,-1,237,221,226,-1,240,266,233,-1,270,238,271,-1,240,273,272,-1,238,241,271,-1,243,271,244,-1,270,243,273,-1,243,274,273,-1,241,244,271,-1,274,272,273,-1,238,270,273,-1,272,267,240,-1,274,276,275,-1,277,243,278,-1,243,246,278,-1,250,248,278,-1,248,279,276,-1,248,276,277,-1,278,246,250,-1,279,275,276,-1,243,277,276,-1,279,281,280,-1,248,251,282,-1,279,248,281,-1,255,253,282,-1,253,281,283,-1,282,251,255,-1,248,282,283,-1,253,283,282,-1,284,259,285,-1,259,260,285,-1,264,262,285,-1,262,265,286,-1,262,286,284,-1,265,237,287,-1,237,269,287,-1,285,260,264,-1,259,284,256,-1,256,286,287,-1,256,280,281,-1,256,281,253,-1,248,283,281,-1,274,243,276,-1,278,248,277,-1,240,238,273,-1,271,243,270,-1,265,287,286,-1,256,284,286,-1,285,262,284,-1,288,290,289,-1,291,288,289,-1,232,288,291,-1,289,292,291,-1,293,294,291,-1,291,294,235,-1,235,232,291,-1,288,232,233,-1,290,292,289,-1,292,293,291,-1,294,236,235,-1,288,233,295,-1,266,295,233,-1,290,288,296,-1,290,296,297,-1,288,295,296,-1,293,292,297,-1,293,296,295,-1,294,293,266,-1,236,294,266,-1,266,293,295,-1,290,297,292,-1,297,296,293,-1,239,234,257,-1,257,234,258,-1,274,275,272,-1,275,279,280,-1,280,256,287,-1,280,287,269,-1,280,269,268,-1,280,268,275,-1,268,272,275,-1,272,268,267,-1,249,239,257,-1,239,249,245,-1,243,245,249,-1,248,249,254,-1,249,257,254,-1,20,299,207,-1,77,94,24,-1,298,207,205,-1,204,298,205,-1,302,305,304,-1,309,17,310,-1,18,310,17,-1,1,301,310,-1,310,18,1,-1,307,17,309,-1,19,16,308,-1,306,3,311,-1,311,3,19,-1,19,308,311,-1,17,307,16,-1,16,307,308,-1,310,301,302,-1,312,314,313,-1,313,314,315,-1,314,316,315,-1,314,317,316,-1,317,318,320,-1,316,317,320,-1,318,321,320,-1,318,322,321,-1,321,322,323,-1,322,324,323,-1,322,312,324,-1,312,319,324,-1,319,313,325,-1,316,320,326,-1,320,321,326,-1,326,321,327,-1,321,323,327,-1,327,323,328,-1,323,329,328,-1,323,324,329,-1,324,319,329,-1,329,319,325,-1,325,331,330,-1,325,313,331,-1,313,332,331,-1,313,315,332,-1,315,316,332,-1,332,316,333,-1,316,334,333,-1,316,326,334,-1,326,327,335,-1,334,326,335,-1,327,336,335,-1,327,328,336,-1,328,329,336,-1,336,329,337,-1,329,325,337,-1,337,325,330,-1,330,331,338,-1,338,331,339,-1,331,340,339,-1,331,332,340,-1,332,333,340,-1,340,333,341,-1,333,342,341,-1,333,334,342,-1,342,334,302,-1,310,302,336,-1,337,330,338,-1,338,343,307,-1,339,344,338,-1,337,309,336,-1,309,338,307,-1,302,334,335,-1,338,309,337,-1,309,310,336,-1,304,341,302,-1,335,336,302,-1,341,342,302,-1,338,344,343,-1,345,347,346,-1,348,303,347,-1,348,347,345,-1,346,347,311,-1,349,350,303,-1,349,303,348,-1,347,303,306,-1,345,343,344,-1,346,311,308,-1,346,308,343,-1,345,344,339,-1,345,339,351,-1,351,339,340,-1,352,351,340,-1,345,351,348,-1,351,352,353,-1,351,353,348,-1,348,353,349,-1,352,340,341,-1,352,354,353,-1,353,354,355,-1,353,355,349,-1,349,355,350,-1,354,341,355,-1,355,304,356,-1,355,356,350,-1,341,304,355,-1,354,352,341,-1,312,313,319,-1,347,306,311,-1,307,343,308,-1,346,343,345,-1,357,358,312,-1,358,314,312,-1,358,359,314,-1,359,360,314,-1,317,360,361,-1,314,360,317,-1,317,361,318,-1,361,362,318,-1,362,322,318,-1,362,363,322,-1,322,364,312,-1,322,363,364,-1,364,357,312,-1,365,358,357,-1,365,366,358,-1,366,359,358,-1,366,367,359,-1,367,368,359,-1,359,368,360,-1,368,361,360,-1,368,369,361,-1,369,362,361,-1,369,370,362,-1,370,363,362,-1,370,371,363,-1,371,372,363,-1,363,372,364,-1,372,365,364,-1,364,365,357,-1,373,366,365,-1,373,374,366,-1,374,367,366,-1,374,375,367,-1,375,376,367,-1,367,376,368,-1,376,369,368,-1,376,377,369,-1,377,370,369,-1,377,378,370,-1,378,371,370,-1,378,379,371,-1,379,380,371,-1,371,380,372,-1,380,373,372,-1,372,373,365,-1,381,382,383,-1,381,383,384,-1,382,385,386,-1,382,386,387,-1,388,389,390,-1,388,390,391,-1,389,392,393,-1,389,393,390,-1,392,394,395,-1,392,395,393,-1,394,396,397,-1,394,397,395,-1,396,384,398,-1,396,398,397,-1,384,383,399,-1,384,399,398,-1,383,387,399,-1,387,386,400,-1,387,400,399,-1,386,388,391,-1,386,391,400,-1,396,381,384,-1,401,396,394,-1,401,394,392,-1,402,392,389,-1,402,401,392,-1,402,389,388,-1,385,388,386,-1,382,387,383,-1,393,403,390,-1,395,404,393,-1,393,404,403,-1,391,390,405,-1,390,403,405,-1,397,406,395,-1,395,406,404,-1,391,405,406,-1,397,391,406,-1,377,388,385,-1,377,385,379,-1,375,402,388,-1,375,388,377,-1,379,385,382,-1,375,373,396,-1,375,396,401,-1,373,379,381,-1,373,381,396,-1,379,382,381,-1,375,401,402,-1,302,407,408,-1,411,412,9,-1,10,9,412,-1,1,412,301,-1,412,1,10,-1,409,411,9,-1,11,410,7,-1,306,413,3,-1,413,11,3,-1,11,413,410,-1,9,7,409,-1,7,410,409,-1,412,302,301,-1,414,415,416,-1,415,417,416,-1,416,417,418,-1,416,418,419,-1,419,422,420,-1,418,422,419,-1,420,422,423,-1,420,423,424,-1,423,425,424,-1,424,425,426,-1,424,426,414,-1,414,426,421,-1,421,427,415,-1,418,428,422,-1,423,428,429,-1,422,428,423,-1,423,429,425,-1,429,430,425,-1,425,430,431,-1,425,431,426,-1,426,431,421,-1,431,427,421,-1,427,432,433,-1,427,433,415,-1,415,433,434,-1,415,434,417,-1,417,434,418,-1,434,435,418,-1,418,435,436,-1,418,436,428,-1,429,428,437,-1,428,436,437,-1,429,437,438,-1,429,438,430,-1,430,438,431,-1,438,439,431,-1,431,439,427,-1,439,432,427,-1,432,440,433,-1,440,441,433,-1,433,441,442,-1,433,442,434,-1,434,442,435,-1,442,341,435,-1,435,341,443,-1,435,443,436,-1,436,302,437,-1,412,438,302,-1,439,440,432,-1,440,409,444,-1,441,440,445,-1,439,438,411,-1,411,409,440,-1,443,302,436,-1,440,439,411,-1,411,438,412,-1,407,302,341,-1,437,302,438,-1,341,302,443,-1,440,444,445,-1,446,447,448,-1,449,448,303,-1,449,446,448,-1,447,413,448,-1,349,303,450,-1,349,449,303,-1,448,306,303,-1,446,445,444,-1,447,410,413,-1,447,444,410,-1,446,441,445,-1,446,451,441,-1,451,442,441,-1,452,442,451,-1,446,449,451,-1,451,453,452,-1,451,449,453,-1,449,349,453,-1,452,341,442,-1,452,453,454,-1,453,455,454,-1,453,349,455,-1,349,450,455,-1,454,455,341,-1,455,456,407,-1,455,450,456,-1,341,455,407,-1,454,341,452,-1,414,421,415,-1,448,413,306,-1,409,410,444,-1,447,446,444,-1,457,414,458,-1,458,414,416,-1,458,416,459,-1,459,416,460,-1,419,461,460,-1,416,419,460,-1,419,420,461,-1,461,420,462,-1,462,420,424,-1,462,424,463,-1,424,414,464,-1,424,464,463,-1,464,414,457,-1,465,457,458,-1,465,458,466,-1,466,458,459,-1,466,459,467,-1,467,459,468,-1,459,460,468,-1,468,460,461,-1,468,461,469,-1,469,461,462,-1,469,462,470,-1,470,462,463,-1,470,463,471,-1,471,463,472,-1,463,464,472,-1,472,464,465,-1,464,457,465,-1,473,465,466,-1,473,466,474,-1,474,466,467,-1,474,467,475,-1,475,467,476,-1,467,468,476,-1,476,468,469,-1,476,469,477,-1,477,469,470,-1,477,470,478,-1,478,470,471,-1,478,471,479,-1,479,471,480,-1,471,472,480,-1,480,472,473,-1,472,465,473,-1,481,483,482,-1,481,484,483,-1,482,486,485,-1,482,487,486,-1,488,490,489,-1,488,491,490,-1,489,493,492,-1,489,490,493,-1,492,495,494,-1,492,493,495,-1,494,497,496,-1,494,495,497,-1,496,498,484,-1,496,497,498,-1,484,499,483,-1,484,498,499,-1,483,499,487,-1,487,500,486,-1,487,499,500,-1,486,491,488,-1,486,500,491,-1,496,484,481,-1,501,494,496,-1,501,492,494,-1,502,489,492,-1,502,492,501,-1,502,488,489,-1,485,486,488,-1,482,483,487,-1,493,490,503,-1,495,493,504,-1,493,503,504,-1,491,505,490,-1,490,505,503,-1,497,495,506,-1,495,504,506,-1,491,506,505,-1,497,506,491,-1,477,485,488,-1,477,479,485,-1,475,488,502,-1,475,477,488,-1,479,482,485,-1,475,496,473,-1,475,501,496,-1,473,481,479,-1,473,496,481,-1,479,481,482,-1,475,502,501,-1,53,837,56,-1,837,53,112,-1,838,300,208,-1,208,209,838,-1],creaseAngle=5,texCoordIndex=[346,347,348,-1,347,349,348,-1,350,351,352,-1,351,350,353,-1,349,351,353,-1,353,348,349,-1,354,355,356,-1,357,358,359,-1,356,359,358,-1,355,359,356,-1,360,361,362,-1,362,361,363,-1,350,352,364,-1,364,365,350,-1,363,365,364,-1,365,363,361,-1,366,367,368,-1,357,369,358,-1,367,358,369,-1,368,367,369,-1,385,386,387,-1,385,387,388,-1,385,386,387,-1,385,387,388,-1,389,390,391,-1,392,390,389,-1,389,393,394,-1,389,391,393,-1,391,390,387,-1,390,395,387,-1,390,396,395,-1,390,392,396,-1,392,397,396,-1,396,398,399,-1,365,399,350,-1,400,401,402,-1,359,355,403,-1,403,400,359,-1,404,405,406,-1,405,346,406,-1,348,406,346,-1,357,400,407,-1,400,357,359,-1,406,348,353,-1,408,409,410,-1,410,409,411,-1,409,394,412,-1,409,412,411,-1,411,413,410,-1,410,413,414,-1,410,414,415,-1,410,415,408,-1,416,415,417,-1,414,404,418,-1,414,418,415,-1,415,418,419,-1,415,420,417,-1,415,419,420,-1,353,420,419,-1,406,419,418,-1,406,418,404,-1,406,353,419,-1,353,350,420,-1,407,400,402,-1,404,421,405,-1,422,405,421,-1,402,401,423,-1,424,425,401,-1,400,403,426,-1,426,401,400,-1,421,404,413,-1,414,413,404,-1,427,428,429,-1,428,427,430,-1,431,405,422,-1,401,426,432,-1,401,432,433,-1,434,411,435,-1,412,436,435,-1,435,411,412,-1,411,437,413,-1,438,408,392,-1,417,420,399,-1,398,417,399,-1,416,417,398,-1,439,436,393,-1,391,439,393,-1,391,387,440,-1,392,389,438,-1,389,394,438,-1,397,392,408,-1,394,393,412,-1,412,393,436,-1,441,442,443,-1,444,441,445,-1,445,446,444,-1,443,445,441,-1,447,448,437,-1,449,443,442,-1,450,451,452,-1,443,449,450,-1,439,391,453,-1,350,399,420,-1,454,402,455,-1,369,456,368,-1,456,369,454,-1,457,458,459,-1,459,458,360,-1,361,360,458,-1,357,407,454,-1,454,369,357,-1,458,365,361,-1,395,460,457,-1,395,396,460,-1,396,461,460,-1,396,399,461,-1,365,461,399,-1,458,460,461,-1,458,457,460,-1,458,461,365,-1,407,402,454,-1,457,459,386,-1,462,386,459,-1,402,423,455,-1,463,455,423,-1,454,464,456,-1,464,454,455,-1,386,387,457,-1,395,457,387,-1,465,466,467,-1,467,430,427,-1,388,462,459,-1,462,388,386,-1,387,386,388,-1,455,468,464,-1,455,469,470,-1,416,397,408,-1,397,398,396,-1,397,416,398,-1,408,415,416,-1,451,450,449,-1,438,394,409,-1,409,408,438,-1,471,441,444,-1,440,472,473,-1,474,451,475,-1,449,476,475,-1,442,476,449,-1,477,476,442,-1,477,442,478,-1,478,442,441,-1,479,471,444,-1,480,473,481,-1,449,475,451,-1,482,413,421,-1,549,388,386,-1,387,386,388,-1,385,386,387,-1,385,387,388,-1,441,471,478,-1,411,434,437,-1,391,440,453,-1,434,447,437,-1,737,447,738,-1,440,473,453,-1,481,473,472,-1,455,740,468,-1,737,448,447,-1,401,741,424,-1,401,433,741,-1,742,448,737,-1,481,472,743,-1,455,470,740,-1,467,466,744,-1,745,746,467,-1,427,465,467,-1,744,745,467,-1,469,455,463,-1,747,428,748,-1,428,747,749,-1,429,428,749,-1,748,428,746,-1,425,423,401,-1,467,746,430,-1,428,430,746,-1,1088,1090,1089,-1,1091,1093,1092,-1,1088,1089,1092,-1,1094,1089,1090,-1,1090,1095,1094,-1,1093,1096,1092,-1,1092,1097,1088,-1,1098,1092,1099,-1,1097,1092,1100,-1,1098,1100,1092,-1,1095,1090,1097,-1,1088,1097,1090,-1,1101,1096,1102,-1,1102,1093,1104,-1,1091,1094,1105,-1,1105,1104,1091,-1,1106,1095,1101,-1,1103,1101,1095,-1,1104,1093,1091,-1,1093,1102,1096,-1,1106,1094,1095,-1,1094,1106,1105,-1,1101,1108,1107,-1,1101,1107,1109,-1,1102,1110,1108,-1,1111,1113,1112,-1,1114,1111,1115,-1,1114,1115,1116,-1,1114,1113,1111,-1,1110,1112,1113,-1,1114,1116,1117,-1,1109,1119,1118,-1,1115,1121,1120,-1,1122,1123,1121,-1,1120,1124,1118,-1,1124,1123,1125,-1,1123,1124,1120,-1,1123,1110,1125,-1,1116,1115,1120,-1,1121,1123,1120,-1,1123,1122,1112,-1,1110,1123,1112,-1,1117,1116,1120,-1,1102,1104,1125,-1,1125,1110,1102,-1,1124,1125,1104,-1,1104,1105,1124,-1,1124,1105,1118,-1,1108,1110,1113,-1,1108,1113,1114,-1,1108,1117,1107,-1,1102,1108,1101,-1,1106,1109,1105,-1,1101,1109,1106,-1,1118,1117,1120,-1,1107,1117,1119,-1,1118,1105,1109,-1,1117,1118,1119,-1,1108,1114,1117,-1,1109,1107,1119,-1,1126,1128,1127,-1,1129,1131,1130,-1,1132,1134,1133,-1,1134,1127,1133,-1,1127,1134,1126,-1,1131,1129,1134,-1,1135,1137,1136,-1,1138,1139,1135,-1,1140,1139,1141,-1,1142,1139,1140,-1,1142,1137,1135,-1,1139,1142,1135,-1,1141,1139,1138,-1,1137,1127,1128,-1,1137,1128,1136,-1,1143,1144,1140,-1,1145,1146,1144,-1,1145,1144,1147,-1,1144,1146,1140,-1,1143,1147,1144,-1,1148,1149,1145,-1,1150,1151,1149,-1,1150,1149,1152,-1,1153,1154,1150,-1,1149,1151,1145,-1,1155,1154,1153,-1,1154,1151,1150,-1,1148,1152,1149,-1,1156,1155,1153,-1,1157,1158,1156,-1,1159,1160,1158,-1,1159,1158,1161,-1,1162,1155,1159,-1,1133,1127,1155,-1,1160,1155,1156,-1,1158,1160,1156,-1,1155,1160,1159,-1,1133,1155,1162,-1,1161,1158,1157,-1,1129,1126,1134,-1,1163,1130,1164,-1,1130,1131,1164,-1,1165,1164,1166,-1,1163,1164,1165,-1,1133,1168,1167,-1,1166,1167,1168,-1,1166,1164,1167,-1,1163,1165,1136,-1,1133,1167,1132,-1,1136,1128,1163,-1,1169,1170,1135,-1,1136,1172,1171,-1,1135,1170,1138,-1,1140,1141,1170,-1,1169,1171,1140,-1,1140,1171,1173,-1,1138,1170,1141,-1,1173,1171,1172,-1,1135,1171,1169,-1,1172,1136,1165,-1,1173,1175,1174,-1,1176,1177,1140,-1,1140,1177,1143,-1,1147,1177,1145,-1,1145,1174,1178,-1,1145,1176,1174,-1,1177,1147,1143,-1,1178,1174,1175,-1,1140,1174,1176,-1,1178,1180,1179,-1,1145,1181,1148,-1,1178,1179,1145,-1,1152,1181,1150,-1,1150,1182,1179,-1,1181,1152,1148,-1,1145,1182,1181,-1,1150,1181,1182,-1,1183,1184,1156,-1,1156,1184,1157,-1,1161,1184,1159,-1,1159,1185,1162,-1,1159,1183,1185,-1,1162,1186,1133,-1,1133,1186,1168,-1,1184,1161,1157,-1,1156,1153,1183,-1,1153,1186,1185,-1,1153,1179,1180,-1,1153,1150,1179,-1,1145,1179,1182,-1,1173,1174,1140,-1,1177,1176,1145,-1,1136,1171,1135,-1,1170,1169,1140,-1,1162,1185,1186,-1,1153,1185,1183,-1,1184,1183,1159,-1,1187,1189,1188,-1,1190,1189,1187,-1,1126,1190,1187,-1,1189,1190,1191,-1,1192,1190,1193,-1,1190,1129,1193,-1,1129,1190,1126,-1,1187,1128,1126,-1,1188,1189,1191,-1,1191,1190,1192,-1,1193,1129,1130,-1,1187,1194,1128,-1,1163,1128,1194,-1,1188,1195,1187,-1,1188,1196,1195,-1,1187,1195,1194,-1,1192,1196,1191,-1,1192,1194,1195,-1,1193,1163,1192,-1,1130,1163,1193,-1,1163,1194,1192,-1,1188,1191,1196,-1,1196,1192,1195,-1,1137,1154,1127,-1,1154,1155,1127,-1,1173,1172,1175,-1,1175,1180,1178,-1,1180,1186,1153,-1,1180,1168,1186,-1,1180,1166,1168,-1,1180,1175,1166,-1,1166,1175,1172,-1,1172,1165,1166,-1,1146,1154,1137,-1,1137,1142,1146,-1,1140,1146,1142,-1,1145,1151,1146,-1,1146,1151,1154,-1,1099,1092,1096,-1,1097,1100,1197,-1,1089,1091,1092,-1,1094,1091,1089,-1,1303,1304,1305,-1,1306,1307,1308,-1,1303,1307,1304,-1,1309,1305,1304,-1,1305,1309,1310,-1,1308,1307,1311,-1,1307,1303,1312,-1,1313,1314,1307,-1,1312,1315,1307,-1,1313,1307,1315,-1,1310,1312,1305,-1,1303,1305,1312,-1,1316,1317,1311,-1,1311,1318,1316,-1,1317,1319,1308,-1,1306,1320,1309,-1,1320,1306,1319,-1,1321,1316,1310,-1,1318,1310,1316,-1,1319,1306,1308,-1,1308,1311,1317,-1,1321,1310,1309,-1,1309,1320,1321,-1,1316,1322,1323,-1,1316,1324,1322,-1,1317,1323,1325,-1,1326,1327,1328,-1,1329,1330,1326,-1,1329,1331,1330,-1,1329,1326,1328,-1,1325,1328,1327,-1,1329,1332,1331,-1,1324,1333,1334,-1,1330,1335,1336,-1,1337,1336,1338,-1,1335,1333,1339,-1,1339,1340,1338,-1,1338,1335,1339,-1,1338,1340,1325,-1,1331,1335,1330,-1,1336,1335,1338,-1,1338,1327,1337,-1,1325,1327,1338,-1,1332,1335,1331,-1,1317,1340,1319,-1,1340,1317,1325,-1,1339,1319,1340,-1,1319,1339,1320,-1,1339,1333,1320,-1,1323,1328,1325,-1,1323,1329,1328,-1,1323,1322,1332,-1,1317,1316,1323,-1,1321,1320,1324,-1,1316,1321,1324,-1,1333,1335,1332,-1,1322,1334,1332,-1,1333,1324,1320,-1,1332,1334,1333,-1,1323,1332,1329,-1,1324,1334,1322,-1,1341,1342,1343,-1,1344,1345,1346,-1,1347,1348,1349,-1,1349,1348,1342,-1,1342,1341,1349,-1,1346,1349,1344,-1,1350,1351,1352,-1,1353,1350,1354,-1,1355,1356,1354,-1,1357,1355,1354,-1,1357,1350,1352,-1,1354,1350,1357,-1,1356,1353,1354,-1,1352,1343,1342,-1,1352,1351,1343,-1,1358,1355,1359,-1,1360,1359,1361,-1,1360,1362,1359,-1,1359,1355,1361,-1,1358,1359,1362,-1,1363,1360,1364,-1,1365,1364,1366,-1,1365,1367,1364,-1,1368,1365,1369,-1,1364,1360,1366,-1,1370,1368,1369,-1,1369,1365,1366,-1,1363,1364,1367,-1,1371,1368,1370,-1,1372,1371,1373,-1,1374,1373,1375,-1,1374,1376,1373,-1,1377,1374,1370,-1,1348,1370,1342,-1,1375,1371,1370,-1,1373,1371,1375,-1,1370,1374,1375,-1,1348,1377,1370,-1,1376,1372,1373,-1,1344,1349,1341,-1,1378,1379,1345,-1,1345,1379,1346,-1,1380,1381,1379,-1,1378,1380,1379,-1,1348,1382,1383,-1,1381,1383,1382,-1,1381,1382,1379,-1,1378,1351,1380,-1,1348,1347,1382,-1,1351,1378,1343,-1,1384,1350,1385,-1,1351,1386,1387,-1,1350,1353,1385,-1,1355,1385,1356,-1,1384,1355,1386,-1,1355,1388,1386,-1,1353,1356,1385,-1,1388,1387,1386,-1,1350,1384,1386,-1,1387,1380,1351,-1,1388,1389,1390,-1,1391,1355,1392,-1,1355,1358,1392,-1,1362,1360,1392,-1,1360,1393,1389,-1,1360,1389,1391,-1,1392,1358,1362,-1,1393,1390,1389,-1,1355,1391,1389,-1,1393,1394,1395,-1,1360,1363,1396,-1,1393,1360,1394,-1,1367,1365,1396,-1,1365,1394,1397,-1,1396,1363,1367,-1,1360,1396,1397,-1,1365,1397,1396,-1,1398,1371,1399,-1,1371,1372,1399,-1,1376,1374,1399,-1,1374,1377,1400,-1,1374,1400,1398,-1,1377,1348,1401,-1,1348,1383,1401,-1,1399,1372,1376,-1,1371,1398,1368,-1,1368,1400,1401,-1,1368,1395,1394,-1,1368,1394,1365,-1,1360,1397,1394,-1,1388,1355,1389,-1,1392,1360,1391,-1,1351,1350,1386,-1,1385,1355,1384,-1,1377,1401,1400,-1,1368,1398,1400,-1,1399,1374,1398,-1,1402,1403,1404,-1,1405,1402,1404,-1,1341,1402,1405,-1,1404,1406,1405,-1,1407,1408,1405,-1,1405,1408,1344,-1,1344,1341,1405,-1,1402,1341,1343,-1,1403,1406,1404,-1,1406,1407,1405,-1,1408,1345,1344,-1,1402,1343,1409,-1,1378,1409,1343,-1,1403,1402,1410,-1,1403,1410,1411,-1,1402,1409,1410,-1,1407,1406,1411,-1,1407,1410,1409,-1,1408,1407,1378,-1,1345,1408,1378,-1,1378,1407,1409,-1,1403,1411,1406,-1,1411,1410,1407,-1,1352,1342,1369,-1,1369,1342,1370,-1,1388,1390,1387,-1,1390,1393,1395,-1,1395,1368,1401,-1,1395,1401,1383,-1,1395,1383,1381,-1,1395,1381,1390,-1,1381,1387,1390,-1,1387,1381,1380,-1,1361,1352,1369,-1,1352,1361,1357,-1,1355,1357,1361,-1,1360,1361,1366,-1,1361,1369,1366,-1,1314,1311,1307,-1,1312,1412,1315,-1,1304,1307,1306,-1,1309,1304,1306,-1,1568,1567,1566,-1,1570,1571,1572,-1,1573,1572,1571,-1,1574,1575,1572,-1,1572,1573,1574,-1,1576,1571,1570,-1,1577,1578,1579,-1,1580,1581,1582,-1,1582,1581,1577,-1,1577,1579,1582,-1,1583,1584,1578,-1,1578,1584,1579,-1,1572,1575,1591,-1,1593,1594,1595,-1,1595,1594,1596,-1,1594,1597,1596,-1,1594,1598,1597,-1,1598,1599,1600,-1,1597,1598,1600,-1,1601,1602,1603,-1,1601,1604,1602,-1,1602,1604,1605,-1,1604,1606,1605,-1,1604,1607,1606,-1,1607,1608,1606,-1,1609,1595,1610,-1,1597,1600,1611,-1,1603,1612,1613,-1,1603,1602,1612,-1,1602,1605,1612,-1,1612,1605,1614,-1,1605,1615,1614,-1,1605,1606,1615,-1,1606,1608,1615,-1,1615,1608,1616,-1,1610,1617,1618,-1,1610,1595,1617,-1,1595,1619,1617,-1,1595,1596,1619,-1,1596,1597,1619,-1,1619,1597,1620,-1,1597,1621,1620,-1,1597,1611,1621,-1,1613,1622,1623,-1,1613,1612,1622,-1,1612,1624,1622,-1,1612,1614,1624,-1,1614,1615,1624,-1,1624,1615,1625,-1,1615,1616,1625,-1,1625,1616,1626,-1,1618,1617,1627,-1,1627,1617,1628,-1,1617,1629,1628,-1,1617,1619,1629,-1,1619,1620,1629,-1,1629,1620,1630,-1,1620,1631,1630,-1,1620,1621,1631,-1,1632,1622,1591,-1,1572,1591,1624,-1,1625,1626,1633,-1,1627,1634,1584,-1,1628,1635,1627,-1,1625,1570,1624,-1,1570,1633,1576,-1,1632,1623,1622,-1,1633,1570,1625,-1,1570,1572,1624,-1,1566,1636,1637,-1,1622,1624,1591,-1,1636,1638,1637,-1,1627,1635,1634,-1,1640,1641,1642,-1,1643,1644,1641,-1,1643,1641,1640,-1,1642,1641,1582,-1,1645,1646,1644,-1,1645,1644,1643,-1,1641,1644,1580,-1,1640,1634,1635,-1,1642,1582,1579,-1,1642,1579,1634,-1,1640,1635,1628,-1,1640,1628,1647,-1,1647,1628,1629,-1,1648,1647,1629,-1,1640,1647,1643,-1,1647,1648,1649,-1,1647,1649,1643,-1,1643,1649,1645,-1,1648,1629,1630,-1,1648,1650,1649,-1,1649,1650,1651,-1,1649,1651,1645,-1,1645,1651,1646,-1,1650,1630,1651,-1,1651,1652,1653,-1,1651,1653,1646,-1,1630,1652,1651,-1,1654,1655,1656,-1,1593,1595,1609,-1,1641,1580,1582,-1,1584,1634,1579,-1,1642,1634,1640,-1,1657,1658,1593,-1,1658,1594,1593,-1,1658,1659,1594,-1,1659,1660,1594,-1,1598,1660,1661,-1,1594,1660,1598,-1,1598,1661,1599,-1,1662,1663,1601,-1,1663,1604,1601,-1,1663,1664,1604,-1,1604,1665,1607,-1,1604,1664,1665,-1,1665,1666,1607,-1,1667,1658,1657,-1,1667,1668,1658,-1,1668,1659,1658,-1,1668,1669,1659,-1,1669,1670,1659,-1,1659,1670,1660,-1,1670,1661,1660,-1,1670,1671,1661,-1,1672,1663,1662,-1,1672,1673,1663,-1,1673,1664,1663,-1,1673,1674,1664,-1,1674,1675,1664,-1,1664,1675,1665,-1,1675,1676,1665,-1,1665,1676,1666,-1,1677,1668,1667,-1,1677,1678,1668,-1,1678,1669,1668,-1,1678,1679,1669,-1,1679,1680,1669,-1,1669,1680,1670,-1,1680,1671,1670,-1,1680,1681,1671,-1,1682,1673,1672,-1,1682,1683,1673,-1,1683,1674,1673,-1,1683,1684,1674,-1,1684,1685,1674,-1,1674,1685,1675,-1,1685,1686,1675,-1,1675,1686,1676,-1,1687,1688,1689,-1,1687,1689,1690,-1,1688,1691,1692,-1,1688,1692,1693,-1,1694,1695,1696,-1,1694,1696,1697,-1,1695,1698,1699,-1,1695,1699,1696,-1,1698,1700,1701,-1,1698,1701,1699,-1,1700,1702,1703,-1,1700,1703,1701,-1,1704,1690,1705,-1,1704,1705,1706,-1,1690,1689,1707,-1,1690,1707,1705,-1,1689,1693,1707,-1,1693,1692,1708,-1,1693,1708,1707,-1,1692,1709,1710,-1,1692,1710,1708,-1,1704,1687,1690,-1,1711,1702,1700,-1,1711,1700,1698,-1,1712,1698,1695,-1,1712,1711,1698,-1,1712,1695,1694,-1,1691,1709,1692,-1,1688,1693,1689,-1,1699,1713,1696,-1,1701,1714,1699,-1,1699,1714,1713,-1,1697,1696,1715,-1,1696,1713,1715,-1,1703,1716,1701,-1,1701,1716,1714,-1,1717,1718,1719,-1,1720,1717,1719,-1,1721,1722,1723,-1,1721,1723,1724,-1,1725,1726,1722,-1,1727,1694,1728,-1,1724,1723,1729,-1,1727,1730,1702,-1,1725,1731,1732,-1,1733,1724,1734,-1,1733,1734,1731,-1,1724,1729,1734,-1,1725,1732,1726,-1,1846,1844,1845,-1,1848,1850,1849,-1,1851,1849,1850,-1,1852,1850,1853,-1,1850,1852,1851,-1,1854,1848,1849,-1,1855,1857,1856,-1,1858,1860,1859,-1,1860,1855,1859,-1,1855,1860,1857,-1,1861,1856,1862,-1,1856,1857,1862,-1,1850,1869,1853,-1,1871,1873,1872,-1,1873,1874,1872,-1,1872,1874,1875,-1,1872,1875,1876,-1,1876,1878,1877,-1,1875,1878,1876,-1,1879,1881,1880,-1,1879,1880,1882,-1,1880,1883,1882,-1,1882,1883,1884,-1,1882,1884,1885,-1,1885,1884,1886,-1,1887,1888,1873,-1,1875,1889,1878,-1,1881,1891,1890,-1,1881,1890,1880,-1,1880,1890,1883,-1,1890,1892,1883,-1,1883,1892,1893,-1,1883,1893,1884,-1,1884,1893,1886,-1,1893,1894,1886,-1,1888,1896,1895,-1,1888,1895,1873,-1,1873,1895,1897,-1,1873,1897,1874,-1,1874,1897,1875,-1,1897,1898,1875,-1,1875,1898,1899,-1,1875,1899,1889,-1,1891,1901,1900,-1,1891,1900,1890,-1,1890,1900,1902,-1,1890,1902,1892,-1,1892,1902,1893,-1,1902,1903,1893,-1,1893,1903,1894,-1,1903,1904,1894,-1,1896,1905,1895,-1,1905,1906,1895,-1,1895,1906,1907,-1,1895,1907,1897,-1,1897,1907,1898,-1,1907,1908,1898,-1,1898,1908,1909,-1,1898,1909,1899,-1,1910,1869,1900,-1,1850,1902,1869,-1,1903,1911,1904,-1,1905,1862,1912,-1,1906,1905,1913,-1,1903,1902,1848,-1,1848,1854,1911,-1,1910,1900,1901,-1,1911,1903,1848,-1,1848,1902,1850,-1,1844,1915,1914,-1,1900,1869,1902,-1,1914,1915,1916,-1,1905,1912,1913,-1,1918,1920,1919,-1,1921,1919,1922,-1,1921,1918,1919,-1,1920,1860,1919,-1,1923,1922,1924,-1,1923,1921,1922,-1,1919,1858,1922,-1,1918,1913,1912,-1,1920,1857,1860,-1,1920,1912,1857,-1,1918,1906,1913,-1,1918,1925,1906,-1,1925,1907,1906,-1,1926,1907,1925,-1,1918,1921,1925,-1,1925,1927,1926,-1,1925,1921,1927,-1,1921,1923,1927,-1,1926,1908,1907,-1,1926,1927,1928,-1,1927,1929,1928,-1,1927,1923,1929,-1,1923,1924,1929,-1,1928,1929,1908,-1,1929,1931,1930,-1,1929,1924,1931,-1,1908,1929,1930,-1,1932,1934,1933,-1,1871,1887,1873,-1,1919,1860,1858,-1,1862,1857,1912,-1,1920,1918,1912,-1,1935,1871,1936,-1,1936,1871,1872,-1,1936,1872,1937,-1,1937,1872,1938,-1,1876,1939,1938,-1,1872,1876,1938,-1,1876,1877,1939,-1,1940,1879,1941,-1,1941,1879,1882,-1,1941,1882,1942,-1,1882,1885,1943,-1,1882,1943,1942,-1,1943,1885,1944,-1,1945,1935,1936,-1,1945,1936,1946,-1,1946,1936,1937,-1,1946,1937,1947,-1,1947,1937,1948,-1,1937,1938,1948,-1,1948,1938,1939,-1,1948,1939,1949,-1,1950,1940,1941,-1,1950,1941,1951,-1,1951,1941,1942,-1,1951,1942,1952,-1,1952,1942,1953,-1,1942,1943,1953,-1,1953,1943,1954,-1,1943,1944,1954,-1,1955,1945,1946,-1,1955,1946,1956,-1,1956,1946,1947,-1,1956,1947,1957,-1,1957,1947,1958,-1,1947,1948,1958,-1,1958,1948,1949,-1,1958,1949,1959,-1,1960,1950,1951,-1,1960,1951,1961,-1,1961,1951,1952,-1,1961,1952,1962,-1,1962,1952,1963,-1,1952,1953,1963,-1,1963,1953,1964,-1,1953,1954,1964,-1,1965,1967,1966,-1,1965,1968,1967,-1,1966,1970,1969,-1,1966,1971,1970,-1,1972,1974,1973,-1,1972,1975,1974,-1,1973,1977,1976,-1,1973,1974,1977,-1,1976,1979,1978,-1,1976,1977,1979,-1,1978,1981,1980,-1,1978,1979,1981,-1,1982,1983,1968,-1,1982,1984,1983,-1,1968,1985,1967,-1,1968,1983,1985,-1,1967,1985,1971,-1,1971,1986,1970,-1,1971,1985,1986,-1,1970,1988,1987,-1,1970,1986,1988,-1,1982,1968,1965,-1,1989,1978,1980,-1,1989,1976,1978,-1,1990,1973,1976,-1,1990,1976,1989,-1,1990,1972,1973,-1,1969,1970,1987,-1,1966,1967,1971,-1,1977,1974,1991,-1,1979,1977,1992,-1,1977,1991,1992,-1,1975,1993,1974,-1,1974,1993,1991,-1,1981,1979,1994,-1,1979,1992,1994,-1,1995,1997,1996,-1,1998,1997,1995,-1,1999,2001,2000,-1,1999,2002,2001,-1,2003,2000,2004,-1,2005,2006,1972,-1,2002,2007,2001,-1,2005,1980,2008,-1,2003,2010,2009,-1,2011,2012,2002,-1,2011,2009,2012,-1,2002,2012,2007,-1,2003,2004,2010,-1,1103,2375,1095,-1,2376,1096,1102,-1,2377,1318,1316,-1,1316,1317,2377,-1],
          texCoord=TextureCoordinate(DEF='Body-TEXCOORD',point=[(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.9296,0.6745),(0.9314,0.7086),(0.9309,0.6716),(0.9316,0.7092),(0.9341,0.7413),(0.05749,0.4563),(0.0593,0.4306),(0.06375,0.4546),(0.06166,0.4149),(0.1207,0.4923),(0.07767,0.3992),(0.1188,0.3911),(0.07163,0.4921),(0.3246,0.198),(0.3195,0.2147),(0.3054,0.1997),(0.2701,0.2251),(0.2689,0.1984),(0.2975,0.2228),(0.2102,0.4535),(0.1961,0.4534),(0.2048,0.4296),(0.1903,0.4146),(0.166,0.3994),(0.1714,0.4906),(0.2233,0.1988),(0.2362,0.2011),(0.2275,0.2165),(0.2394,0.2239),(0.8129,0.7538),(0.8027,0.7967),(0.7702,0.7394),(0.7816,0.7924),(0.7367,0.7894),(0.7362,0.7374),(0.83,0.7792),(0.6366,0.7985),(0.615,0.7993),(0.61,0.7851),(0.6794,0.7847),(0.6795,0.7991),(0.6396,0.785),(0.6199,0.7908),(0.6091,0.7773),(0.2321,0.5721),(0.2268,0.5802),(0.2154,0.6149),(0.2391,0.603),(0.1375,0.5801),(0.188,0.5721),(0.1747,0.5997),(0.1621,0.552),(0.1318,0.6),(0.1184,0.563),(0.2092,0.5603),(0.1945,0.5272),(0.1607,0.5344),(0.1607,0.5144),(0.174,0.5029),(0.3014,0.2618),(0.3005,0.3507),(0.2689,0.3131),(0.321,0.2575),(0.02977,0.5601),(0.04502,0.5112),(0.05098,0.5016),(0.2695,0.2618),(0.07094,0.5533),(0.09999,0.5806),(0.05123,0.5741),(0.0756,0.5956),(0.1159,0.6002),(0.05235,0.6182),(0.03709,0.5628),(0.04677,0.5319),(0.07261,0.5357),(0.07568,0.5156),(0.03577,0.529),(0.04282,0.5102),(0.0653,0.5044),(0.03497,0.5863),(0.05009,0.575),(0.2737,0.38),(0.2965,0.3748),(0.2846,0.3771),(0.3309,0.3146),(0.1413,0.7728),(0.1512,0.7561),(0.1528,0.7698),(0.1418,0.7578),(0.04345,0.6114),(0.3367,0.3446),(0.3196,0.3581),(0.1002,0.6439),(0.1123,0.6256),(0.1277,0.6205),(0.06094,0.6314),(0.1171,0.5764),(0.1412,0.6219),(0.2095,0.6318),(0.2155,0.7482),(0.2248,0.7395),(0.2264,0.7706),(0.207,0.7625),(0.2124,0.7789),(0.2067,0.7829),(0.1013,0.6609),(0.07045,0.6433),(0.2432,0.7488),(0.2443,0.7807),(0.2604,0.7569),(0.2578,0.7839),(0.1621,0.6349),(0.2426,0.2661),(0.2426,0.3508),(0.2265,0.2664),(0.2217,0.554),(0.2044,0.5029),(0.2232,0.5154),(0.2179,0.5263),(0.2054,0.5078),(0.2402,0.5735),(0.2609,0.3767),(0.219,0.3169),(0.133,0.7703),(0.1256,0.7638),(0.1299,0.7558),(0.2105,0.3444),(0.2522,0.3749),(0.2396,0.3664),(0.2021,0.7386),(0.2114,0.6449),(0.1744,0.6536),(0.267,0.7463),(0.2528,0.7323),(0.2337,0.7244),(0.2211,0.7226),(0.2074,0.7257),(0.2028,0.7484),(0.175,0.6707),(0.1895,0.6651),(0.05434,0.5749),(0.748,0.6836),(0.7365,0.6933),(0.6033,0.446),(0.6204,0.4418),(0.6053,0.4914),(0.6231,0.4906),(0.655,0.4905),(0.6504,0.4421),(0.6645,0.4446),(0.6642,0.4912),(0.7566,0.4558),(0.7568,0.5002),(0.7536,0.5057),(0.7828,0.4538),(0.7845,0.5003),(0.8138,0.5014),(0.8158,0.4578),(0.8276,0.5046),(0.5999,0.4924),(0.5934,0.5364),(0.6693,0.5344),(0.7632,0.5535),(0.7526,0.5493),(0.7899,0.5545),(0.8126,0.5527),(0.8327,0.5481),(0.5843,0.6207),(0.5821,0.631),(0.6137,0.5991),(0.6553,0.5964),(0.6803,0.616),(0.7563,0.6321),(0.7482,0.6301),(0.7909,0.6367),(0.8254,0.6409),(0.849,0.6403),(0.5877,0.7295),(0.5783,0.6847),(0.6124,0.6536),(0.6775,0.6816),(0.6828,0.6571),(0.7486,0.6682),(0.8455,0.7399),(0.5926,0.7439),(0.587,0.7167),(0.9344,0.668),(0.9314,0.7002),(0.9469,0.6788),(0.934,0.7474),(0.6007,0.7207),(0.6604,0.7523),(0.6072,0.7396),(0.6548,0.7295),(0.6773,0.7408),(0.6762,0.7191),(0.6856,0.7101),(0.6085,0.702),(0.6291,0.6824),(0.6556,0.6992),(0.6583,0.6785),(0.6747,0.6943),(0.6855,0.683),(0.697,0.6979),(0.9026,0.7003),(0.9036,0.7173),(0.9021,0.6934),(0.2451,0.5731),(0.4293,0.7821),(0.4225,0.7765),(0.4384,0.778),(0.4029,0.7448),(0.3927,0.769),(0.3796,0.7282),(0.4393,0.7324),(0.4636,0.7422),(0.3712,0.7302),(0.4656,0.7817),(0.3887,0.7856),(0.3735,0.7608),(0.4397,0.795),(0.4121,0.6221),(0.379,0.6153),(0.436,0.7234),(0.3921,0.6306),(0.4214,0.6366),(0.4371,0.6324),(0.4316,0.5878),(0.4019,0.5859),(0.4389,0.6127),(0.3644,0.5404),(0.3711,0.438),(0.363,0.4443),(0.3752,0.5355),(0.3969,0.5325),(0.3896,0.4348),(0.4186,0.5324),(0.4231,0.5451),(0.4257,0.5881),(0.4355,0.588),(0.4025,0.5345),(0.3814,0.4347),(0.3647,0.4436),(0.3797,0.5379),(0.4049,0.5869),(0.3848,0.5924),(0.4316,0.2796),(0.4516,0.2642),(0.4269,0.2746),(0.4344,0.2955),(0.4297,0.2979),(0.4434,0.3162),(0.4711,0.3068),(0.4727,0.266),(0.4573,0.3127),(0.4241,0.2321),(0.4256,0.2498),(0.4306,0.2511),(0.4234,0.2217),(0.4289,0.2248),(0.432,0.2269),(0.4292,0.2191),(0.4283,0.2337),(0.4319,0.2128),(0.4378,0.2182),(0.4426,0.2251),(0.439,0.2288),(0.4394,0.213),(0.4422,0.2172),(0.4476,0.2222),(0.4519,0.226),(0.4489,0.2303),(0.4487,0.2172),(0.456,0.245),(0.4525,0.2478),(0.4632,0.2489),(0.4557,0.2373),(0.4544,0.2291),(0.4589,0.2312),(0.4629,0.2365),(0.4611,0.2393),(0.4595,0.2288),(0.4673,0.2512),(0.4271,0.2805),(0.4498,0.3153),(0.4307,0.2686),(0.4445,0.2685),(0.4626,0.3106),(0.4623,0.267),(0.4267,0.2318),(0.4259,0.2252),(0.4275,0.2412),(0.4291,0.2506),(0.4348,0.2452),(0.4383,0.2364),(0.4399,0.2448),(0.4368,0.2263),(0.4356,0.2208),(0.4458,0.244),(0.4492,0.2389),(0.4505,0.2462),(0.4466,0.2233),(0.447,0.2286),(0.4593,0.2374),(0.4582,0.2331),(0.461,0.2452),(0.4627,0.2528),(0.4165,0.2663),(0.4089,0.263),(0.4071,0.2662),(0.4183,0.277),(0.4042,0.269),(0.4119,0.2763),(0.42,0.2841),(0.4136,0.2705),(0.4103,0.2672),(0.4049,0.2655),(0.6019,0.3848),(0.6068,0.3869),(0.6253,0.3793),(0.6538,0.3793),(0.6624,0.3827),(0.7562,0.3959),(0.7617,0.396),(0.7792,0.3957),(0.8088,0.396),(0.8189,0.3966),(0.61,0.3127),(0.6162,0.3117),(0.6269,0.3092),(0.6475,0.3095),(0.6559,0.3109),(0.7563,0.3259),(0.7642,0.3254),(0.7765,0.3268),(0.7967,0.3256),(0.8042,0.3254),(0.6188,0.2739),(0.622,0.2718),(0.6287,0.2718),(0.6382,0.2716),(0.6467,0.2716),(0.7651,0.2755),(0.7709,0.2712),(0.7764,0.2723),(0.7853,0.2759),(0.7917,0.2808),(0.9533,0.4685),(0.947,0.4641),(0.9521,0.4436),(0.9559,0.4595),(0.9387,0.4644),(0.9322,0.462),(0.939,0.4447),(0.934,0.5157),(0.9318,0.535),(0.9337,0.5447),(0.9307,0.539),(0.9447,0.5367),(0.9455,0.5461),(0.9579,0.5345),(0.9558,0.5448),(0.9576,0.515),(0.9629,0.538),(0.9583,0.4758),(0.9608,0.4521),(0.9629,0.4894),(0.9458,0.4391),(0.9336,0.4522),(0.9311,0.4772),(0.9306,0.4881),(0.9479,0.5237),(0.9334,0.5207),(0.9449,0.564),(0.9491,0.5643),(0.9392,0.557),(0.9535,0.5582),(0.878,0.5146),(0.8857,0.497),(0.8954,0.4943),(0.9045,0.5131),(0.8837,0.448),(0.8777,0.451),(0.883,0.4333),(0.8928,0.4437),(0.8908,0.4807),(0.8819,0.4793),(0.9462,0.4957),(0.9414,0.5155),(0.8938,0.4267),(0.9542,0.515),(0.9093,0.4608),(0.9044,0.4832),(0.9036,0.4457),(0.9059,0.4345),(0.09562,0.6679),(0.1058,0.6699),(0.4529,0.7907),(0.2246,0.3566),(0.3073,0.3671),(0.07699,0.6575),(0.2122,0.6544),(0.1242,0.7349),(0.1317,0.7413),(0.14,0.7441),(0.1595,0.7363),(0.1502,0.739),(0.1612,0.7603),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.05235,0.6182),(0.03497,0.5863),(0.05009,0.575),(0.04345,0.6114),(0.05434,0.5749),(0.7548,0.5023),(0.7845,0.5003),(0.8276,0.5046),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.9296,0.6745),(0.9314,0.7086),(0.9309,0.6716),(0.9316,0.7092),(0.9341,0.7413),(0.05749,0.4563),(0.0593,0.4306),(0.06375,0.4546),(0.06166,0.4149),(0.1207,0.4923),(0.07767,0.3992),(0.1188,0.3911),(0.07163,0.4921),(0.3246,0.198),(0.3195,0.2147),(0.3054,0.1997),(0.2701,0.2251),(0.2689,0.1984),(0.2975,0.2228),(0.2102,0.4535),(0.1961,0.4534),(0.2048,0.4296),(0.1903,0.4146),(0.166,0.3994),(0.1714,0.4906),(0.2233,0.1988),(0.2362,0.2011),(0.2275,0.2165),(0.2394,0.2239),(0.8129,0.7538),(0.8027,0.7967),(0.7702,0.7394),(0.7816,0.7924),(0.7367,0.7894),(0.7362,0.7374),(0.83,0.7792),(0.6366,0.7985),(0.615,0.7993),(0.61,0.7851),(0.6794,0.7847),(0.6795,0.7991),(0.6396,0.785),(0.6199,0.7908),(0.6091,0.7773),(0.2321,0.5721),(0.2268,0.5802),(0.2154,0.6149),(0.2391,0.603),(0.1375,0.5801),(0.188,0.5721),(0.1747,0.5997),(0.1621,0.552),(0.1318,0.6),(0.7536,0.5057),(0.7828,0.4538),(0.8276,0.5046),(0.5999,0.4924),(0.5843,0.6207),(0.5821,0.631),(0.6137,0.5991),(0.6553,0.5964),(0.6803,0.616),(0.7563,0.6321),(0.7482,0.6301),(0.7909,0.6367),(0.8254,0.6409),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.02977,0.5601),(0.1159,0.6002),(0.05235,0.6182),(0.03709,0.5628),(0.04677,0.5319),(0.07261,0.5357),(0.07568,0.5156),(0.03577,0.529),(0.04282,0.5102),(0.4293,0.7821),(0.4225,0.7765),(0.4384,0.778),(0.4029,0.7448),(0.3927,0.769),(0.3796,0.7282),(0.4393,0.7324),(0.4636,0.7422),(0.3712,0.7302),(0.4656,0.7817),(0.3887,0.7856),(0.3735,0.7608),(0.4397,0.795),(0.4121,0.6221),(0.379,0.6153),(0.436,0.7234),(0.3921,0.6306),(0.4214,0.6366),(0.4371,0.6324),(0.4316,0.5878),(0.4019,0.5859),(0.4389,0.6127),(0.3644,0.5404),(0.3711,0.438),(0.363,0.4443),(0.3752,0.5355),(0.3969,0.5325),(0.3896,0.4348),(0.4186,0.5324),(0.4231,0.5451),(0.4257,0.5881),(0.4355,0.588),(0.4025,0.5345),(0.3814,0.4347),(0.3647,0.4436),(0.3797,0.5379),(0.4049,0.5869),(0.3848,0.5924),(0.4316,0.2796),(0.4516,0.2642),(0.4269,0.2746),(0.4344,0.2955),(0.4297,0.2979),(0.4434,0.3162),(0.4711,0.3068),(0.4727,0.266),(0.4573,0.3127),(0.4241,0.2321),(0.4256,0.2498),(0.4306,0.2511),(0.4234,0.2217),(0.4289,0.2248),(0.432,0.2269),(0.4292,0.2191),(0.4283,0.2337),(0.4319,0.2128),(0.4378,0.2182),(0.4426,0.2251),(0.439,0.2288),(0.4394,0.213),(0.4422,0.2172),(0.4476,0.2222),(0.4519,0.226),(0.4489,0.2303),(0.4487,0.2172),(0.456,0.245),(0.4525,0.2478),(0.4632,0.2489),(0.4557,0.2373),(0.4544,0.2291),(0.4589,0.2312),(0.4629,0.2365),(0.4611,0.2393),(0.4595,0.2288),(0.4673,0.2512),(0.4271,0.2805),(0.4498,0.3153),(0.4307,0.2686),(0.4445,0.2685),(0.4626,0.3106),(0.4623,0.267),(0.4267,0.2318),(0.4259,0.2252),(0.4275,0.2412),(0.4291,0.2506),(0.4348,0.2452),(0.4383,0.2364),(0.4399,0.2448),(0.4368,0.2263),(0.4356,0.2208),(0.4458,0.244),(0.4492,0.2389),(0.4505,0.2462),(0.4466,0.2233),(0.447,0.2286),(0.4593,0.2374),(0.4582,0.2331),(0.461,0.2452),(0.4627,0.2528),(0.4165,0.2663),(0.4089,0.263),(0.4071,0.2662),(0.4183,0.277),(0.4042,0.269),(0.4119,0.2763),(0.42,0.2841),(0.4136,0.2705),(0.4103,0.2672),(0.4049,0.2655),(0.4549,0.7938),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.02977,0.5601),(0.1159,0.6002),(0.05235,0.6182),(0.03709,0.5628),(0.04677,0.5319),(0.07261,0.5357),(0.07568,0.5156),(0.03577,0.529),(0.04282,0.5102),(0.4293,0.7821),(0.4225,0.7765),(0.4384,0.778),(0.4029,0.7448),(0.3927,0.769),(0.3796,0.7282),(0.4393,0.7324),(0.4636,0.7422),(0.3712,0.7302),(0.4656,0.7817),(0.3887,0.7856),(0.3735,0.7608),(0.4397,0.795),(0.4121,0.6221),(0.379,0.6153),(0.436,0.7234),(0.3921,0.6306),(0.4214,0.6366),(0.4371,0.6324),(0.4316,0.5878),(0.4019,0.5859),(0.4389,0.6127),(0.3644,0.5404),(0.3711,0.438),(0.363,0.4443),(0.3752,0.5355),(0.3969,0.5325),(0.3896,0.4348),(0.4186,0.5324),(0.4231,0.5451),(0.4257,0.5881),(0.4355,0.588),(0.4025,0.5345),(0.3814,0.4347),(0.3647,0.4436),(0.3797,0.5379),(0.4049,0.5869),(0.3848,0.5924),(0.4316,0.2796),(0.4516,0.2642),(0.4269,0.2746),(0.4344,0.2955),(0.4297,0.2979),(0.4434,0.3162),(0.4711,0.3068),(0.4727,0.266),(0.4573,0.3127),(0.4241,0.2321),(0.4256,0.2498),(0.4306,0.2511),(0.4234,0.2217),(0.4289,0.2248),(0.432,0.2269),(0.4292,0.2191),(0.4283,0.2337),(0.4319,0.2128),(0.4378,0.2182),(0.4426,0.2251),(0.439,0.2288),(0.4394,0.213),(0.4422,0.2172),(0.4476,0.2222),(0.4519,0.226),(0.4489,0.2303),(0.4487,0.2172),(0.456,0.245),(0.4525,0.2478),(0.4632,0.2489),(0.4557,0.2373),(0.4544,0.2291),(0.4589,0.2312),(0.4629,0.2365),(0.4611,0.2393),(0.4595,0.2288),(0.4673,0.2512),(0.4271,0.2805),(0.4498,0.3153),(0.4307,0.2686),(0.4445,0.2685),(0.4626,0.3106),(0.4623,0.267),(0.4267,0.2318),(0.4259,0.2252),(0.4275,0.2412),(0.4291,0.2506),(0.4348,0.2452),(0.4383,0.2364),(0.4399,0.2448),(0.4368,0.2263),(0.4356,0.2208),(0.4458,0.244),(0.4492,0.2389),(0.4505,0.2462),(0.4466,0.2233),(0.447,0.2286),(0.4593,0.2374),(0.4582,0.2331),(0.461,0.2452),(0.4627,0.2528),(0.4165,0.2663),(0.4089,0.263),(0.4071,0.2662),(0.4183,0.277),(0.4042,0.269),(0.4119,0.2763),(0.42,0.2841),(0.4136,0.2705),(0.4103,0.2672),(0.4049,0.2655),(0.4549,0.7938),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.9296,0.6745),(0.9314,0.7086),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.6137,0.5991),(0.6553,0.5964),(0.6803,0.616),(0.7563,0.6321),(0.7482,0.6301),(0.7909,0.6367),(0.8254,0.6409),(0.849,0.6403),(0.5877,0.7295),(0.5783,0.6847),(0.6124,0.6536),(0.6775,0.6816),(0.6828,0.6571),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.9296,0.6745),(0.9314,0.7086),(0.9316,0.7092),(0.9341,0.7413),(0.8129,0.7538),(0.8027,0.7967),(0.7702,0.7394),(0.7816,0.7924),(0.7367,0.7894),(0.7362,0.7374),(0.83,0.7792),(0.6366,0.7985),(0.615,0.7993),(0.61,0.7851),(0.6794,0.7847),(0.6795,0.7991),(0.6396,0.785),(0.6199,0.7908),(0.6091,0.7773),(0.05123,0.5741),(0.0756,0.5956),(0.1159,0.6002),(0.05235,0.6182),(0.03709,0.5628),(0.04677,0.5319),(0.748,0.6836),(0.7365,0.6933),(0.6033,0.446),(0.6204,0.4418),(0.6053,0.4914),(0.6231,0.4906),(0.655,0.4905),(0.6504,0.4421),(0.6635,0.4436),(0.6642,0.4912),(0.7566,0.4558),(0.7548,0.5023),(0.7536,0.5057),(0.7828,0.4538),(0.7845,0.5003),(0.8138,0.5014),(0.8158,0.4578),(0.8276,0.5046),(0.5999,0.4924),(0.5934,0.5364),(0.6703,0.5365),(0.7632,0.5535),(0.7526,0.5493),(0.7899,0.5545),(0.8126,0.5527),(0.8327,0.5481),(0.5843,0.6207),(0.5821,0.631),(0.6137,0.5991),(0.6553,0.5964),(0.6803,0.616),(0.7563,0.6321),(0.7482,0.6301),(0.7909,0.6367),(0.8254,0.6409),(0.849,0.6403),(0.5877,0.7295),(0.5783,0.6847),(0.6124,0.6536),(0.6775,0.6816),(0.6828,0.6571),(0.7486,0.6682),(0.8455,0.7399),(0.5926,0.7439),(0.587,0.7167),(0.9344,0.668),(0.9314,0.7002),(0.9469,0.6788),(0.934,0.7474),(0.6007,0.7207),(0.6604,0.7523),(0.6072,0.7396),(0.6548,0.7295),(0.6773,0.7408),(0.6762,0.7191),(0.6856,0.7101),(0.6085,0.702),(0.6291,0.6824),(0.6556,0.6992),(0.6583,0.6785),(0.6747,0.6943),(0.6855,0.683),(0.697,0.6979),(0.9026,0.7003),(0.9036,0.7173),(0.9021,0.6934),(0.6019,0.3848),(0.6068,0.3869),(0.6253,0.3793),(0.6538,0.3793),(0.6624,0.3827),(0.7562,0.3959),(0.7617,0.396),(0.7792,0.3957),(0.8088,0.396),(0.8189,0.3966),(0.61,0.3127),(0.6162,0.3117),(0.6269,0.3092),(0.6475,0.3095),(0.6559,0.3109),(0.7563,0.3259),(0.7642,0.3254),(0.7765,0.3268),(0.7967,0.3256),(0.8042,0.3254),(0.6188,0.2739),(0.622,0.2718),(0.6287,0.2718),(0.6382,0.2716),(0.6467,0.2716),(0.7651,0.2755),(0.7709,0.2712),(0.7764,0.2723),(0.7853,0.2759),(0.7917,0.2808),(0.9533,0.4685),(0.947,0.4641),(0.9521,0.4436),(0.9559,0.4595),(0.9387,0.4644),(0.9322,0.462),(0.939,0.4447),(0.934,0.5157),(0.9318,0.535),(0.9337,0.5447),(0.9307,0.539),(0.9447,0.5367),(0.9455,0.5461),(0.9579,0.5345),(0.9558,0.5448),(0.9576,0.515),(0.9629,0.538),(0.9583,0.4758),(0.9608,0.4521),(0.9629,0.4894),(0.9458,0.4391),(0.9336,0.4522),(0.9311,0.4772),(0.9306,0.4881),(0.9479,0.5237),(0.9334,0.5207),(0.9449,0.564),(0.9491,0.5643),(0.9392,0.557),(0.9535,0.5582),(0.878,0.5146),(0.8857,0.497),(0.8954,0.4943),(0.9045,0.5131),(0.8837,0.448),(0.8777,0.451),(0.883,0.4333),(0.8928,0.4437),(0.8908,0.4807),(0.8819,0.4793),(0.9462,0.4957),(0.9414,0.5155),(0.8938,0.4267),(0.9542,0.515),(0.9093,0.4608),(0.9044,0.4832),(0.9036,0.4457),(0.9059,0.4345),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.0,0.0),(0.9296,0.6745),(0.9314,0.7086),(0.9316,0.7092),(0.9341,0.7413),(0.8129,0.7538),(0.8027,0.7967),(0.7702,0.7394),(0.7816,0.7924),(0.7367,0.7894),(0.7362,0.7374),(0.83,0.7792),(0.6366,0.7985),(0.615,0.7993),(0.61,0.7851),(0.6794,0.7847),(0.6795,0.7991),(0.6396,0.785),(0.6199,0.7908),(0.6091,0.7773),(0.05123,0.5741),(0.0756,0.5956),(0.1159,0.6002),(0.05235,0.6182),(0.03709,0.5628),(0.04677,0.5319),(0.748,0.6836),(0.7365,0.6933),(0.6033,0.446),(0.6204,0.4418),(0.6053,0.4914),(0.6231,0.4906),(0.655,0.4905),(0.6504,0.4421),(0.6635,0.4436),(0.6642,0.4912),(0.7566,0.4558),(0.7548,0.5023),(0.7536,0.5057),(0.7828,0.4538),(0.7845,0.5003),(0.8138,0.5014),(0.8158,0.4578),(0.8276,0.5046),(0.5999,0.4924),(0.5934,0.5364),(0.6703,0.5365),(0.7632,0.5535),(0.7526,0.5493),(0.7899,0.5545),(0.8126,0.5527),(0.8327,0.5481),(0.5843,0.6207),(0.5821,0.631),(0.6137,0.5991),(0.6553,0.5964),(0.6803,0.616),(0.7563,0.6321),(0.7482,0.6301),(0.7909,0.6367),(0.8254,0.6409),(0.849,0.6403),(0.5877,0.7295),(0.5783,0.6847),(0.6124,0.6536),(0.6775,0.6816),(0.6828,0.6571),(0.7486,0.6682),(0.8455,0.7399),(0.5926,0.7439),(0.587,0.7167),(0.9344,0.668),(0.9314,0.7002),(0.9469,0.6788),(0.934,0.7474),(0.6007,0.7207),(0.6604,0.7523),(0.6072,0.7396),(0.6548,0.7295),(0.6773,0.7408),(0.6762,0.7191),(0.6856,0.7101),(0.6085,0.702),(0.6291,0.6824),(0.6556,0.6992),(0.6583,0.6785),(0.6747,0.6943),(0.6855,0.683),(0.697,0.6979),(0.9026,0.7003),(0.9036,0.7173),(0.9021,0.6934),(0.6019,0.3848),(0.6068,0.3869),(0.6253,0.3793),(0.6538,0.3793),(0.6624,0.3827),(0.7562,0.3959),(0.7617,0.396),(0.7792,0.3957),(0.8088,0.396),(0.8189,0.3966),(0.61,0.3127),(0.6162,0.3117),(0.6269,0.3092),(0.6475,0.3095),(0.6559,0.3109),(0.7563,0.3259),(0.7642,0.3254),(0.7765,0.3268),(0.7967,0.3256),(0.8042,0.3254),(0.6188,0.2739),(0.622,0.2718),(0.6287,0.2718),(0.6382,0.2716),(0.6467,0.2716),(0.7651,0.2755),(0.7709,0.2712),(0.7764,0.2723),(0.7853,0.2759),(0.7917,0.2808),(0.9533,0.4685),(0.947,0.4641),(0.9521,0.4436),(0.9559,0.4595),(0.9387,0.4644),(0.9322,0.462),(0.939,0.4447),(0.934,0.5157),(0.9318,0.535),(0.9337,0.5447),(0.9307,0.539),(0.9447,0.5367),(0.9455,0.5461),(0.9579,0.5345),(0.9558,0.5448),(0.9576,0.515),(0.9629,0.538),(0.9583,0.4758),(0.9608,0.4521),(0.9629,0.4894),(0.9458,0.4391),(0.9336,0.4522),(0.9311,0.4772),(0.9306,0.4881),(0.9479,0.5237),(0.9334,0.5207),(0.9449,0.564),(0.9491,0.5643),(0.9392,0.557),(0.9535,0.5582),(0.878,0.5146),(0.8857,0.497),(0.8954,0.4943),(0.9045,0.5131),(0.8837,0.448),(0.8777,0.451),(0.883,0.4333),(0.8928,0.4437),(0.8908,0.4807),(0.8819,0.4793),(0.9462,0.4957),(0.9414,0.5155),(0.8938,0.4267),(0.9542,0.515),(0.9093,0.4608),(0.9044,0.4832),(0.9036,0.4457),(0.9059,0.4345),(0.7643,0.6341),(0.742,0.5452),(0.757,0.4686),(0.7493,0.7107),(0.7115,0.6061),(0.9203,0.6057),(0.3188,0.8471),(0.5892,0.2322),(0.7608,0.6101),(0.8616,0.6461),(0.9045,0.6504),(0.5033,0.7486),(0.4644,0.8045),(0.3678,0.8368),(0.7105,0.5041),(0.7115,0.4157),(0.7117,0.3652),(0.2823,0.5568),(0.3072,0.6266),(0.1452,0.6886),(0.1574,0.7609),(0.2553,0.8396),(0.2388,0.5121),(0.3045,0.5111),(0.7044,0.2298),(0.3601,0.6655),(0.3108,0.7723),(0.3156,0.8102),(0.6403,0.3063),(0.855,0.4262),(0.8886,0.5294),(0.4905,0.7493),(0.4246,0.7163),(0.3728,0.7946),(0.7424,0.5043),(0.7682,0.3905),(0.8538,0.5137),(0.1807,0.7166),(0.2196,0.7746),(0.2678,0.7302),(0.3057,0.5124),(0.9285,0.537),(0.7053,0.3068),(0.4157,0.8238),(0.7114,0.6716),(0.7114,0.5836),(0.7113,0.57),(0.7109,0.5391),(0.7415,0.5365),(0.7352,0.5607),(0.7106,0.5245),(0.7114,0.4937),(0.7116,0.4863),(0.7112,0.4646),(0.748,0.4876),(0.7587,0.4623),(0.7486,0.5534),(0.7702,0.5064),(0.7966,0.4474),(0.8166,0.4224),(0.581,0.2608),(0.7116,0.4412),(0.7119,0.4066),(0.7118,0.3818),(0.5649,0.2347),(0.6549,0.2302),(0.7581,0.4216),(0.7112,0.4556),(0.7114,0.4281),(0.7616,0.4422),(0.7327,0.4684),(0.8021,0.5088),(0.7506,0.5203),(0.731,0.5215),(0.7589,0.4274),(0.8247,0.6334),(0.7522,0.5927),(0.8839,0.5857),(0.8148,0.6622),(0.7979,0.582),(0.7331,0.5818),(0.8471,0.6014),(0.8761,0.6241),(0.7881,0.6158),(0.7937,0.6316),(0.4532,0.7373),(0.4465,0.7799),(0.836,0.4691),(0.7422,0.23),(0.7113,0.6352),(0.7804,0.3806),(0.7326,0.5974),(0.7481,0.6196),(0.7689,0.6444),(0.8449,0.5879),(0.7971,0.5484),(0.8571,0.5587),(0.7707,0.4834),(0.1511,0.587),(0.1696,0.6105),(0.1975,0.814),(0.1997,0.5284),(0.1802,0.5409),(0.1593,0.5518),(0.1474,0.5219),(0.1288,0.5012),(0.1018,0.4655),(0.07201,0.4159),(0.02679,0.3441),(0.05829,0.2186),(0.09219,0.1816),(0.1579,0.1795),(0.1803,0.238),(0.2153,0.3139),(0.2279,0.4148),(0.214,0.4605),(0.2176,0.4777),(0.2285,0.4941),(0.08988,0.3155),(0.1442,0.3629),(0.1972,0.5113),(0.1475,0.2981),(0.1254,0.233),(0.148,0.4101),(0.1465,0.4589),(0.174,0.4945),(0.09557,0.2585),(0.1499,0.4957),(0.1652,0.51),(0.178,0.5238),(0.5109,0.1797),(0.5065,0.1739),(0.4986,0.1703),(0.4931,0.171),(0.4851,0.1719),(0.4798,0.1784),(0.4782,0.1864),(0.5159,0.2007),(0.5077,0.1955),(0.4997,0.1963),(0.495,0.2102),(0.489,0.202),(0.4791,0.198),(0.5299,0.2001),(0.5227,0.2015),(0.5162,0.2231),(0.489,0.2186),(0.4868,0.2069),(0.5367,0.2169),(0.5176,0.2323),(0.5003,0.2388),(0.4898,0.2365),(0.5371,0.2332),(0.5297,0.2341),(0.5176,0.2469),(0.505,0.2559),(0.4989,0.2522),(0.5332,0.2475),(0.5057,0.2626),(0.4954,0.2614),(0.4907,0.2553),(0.4843,0.2549),(0.5261,0.2641),(0.5215,0.2704),(0.5136,0.272),(0.5052,0.2743),(0.4947,0.2717),(0.4862,0.2639),(0.5113,0.1788),(0.5069,0.173),(0.499,0.1694),(0.4855,0.1711),(0.4813,0.177),(0.5164,0.1998),(0.5081,0.1946),(0.5001,0.1955),(0.5303,0.1992),(0.5258,0.2161),(0.518,0.2315),(0.5371,0.216),(0.5375,0.2324),(0.5301,0.2332),(0.518,0.2461),(0.5054,0.2551),(0.5337,0.2467),(0.5164,0.2576),(0.5061,0.2618),(0.4958,0.2605),(0.5266,0.2632),(0.5219,0.2696),(0.514,0.2711),(0.5056,0.2734),(0.4952,0.2709),(0.4866,0.263),(0.5177,0.6098),(0.6649,0.6045),(0.569,0.6744),(0.5305,0.6554),(0.2845,0.5569),(0.3085,0.6276),(0.3617,0.6663),(0.3059,0.7563),(0.3128,0.7974),(0.634,0.1634),(0.5562,0.4303),(0.551,0.53),(0.4822,0.7453),(0.4224,0.7131),(0.3696,0.7805),(0.6794,0.5044),(0.6566,0.3908),(0.5768,0.5143),(0.1807,0.7158),(0.2205,0.7754),(0.262,0.7111),(0.3054,0.5118),(0.5149,0.5288),(0.7042,0.1559),(0.6816,0.5366),(0.6882,0.5608),(0.6758,0.4878),(0.6647,0.4624),(0.6655,0.5582),(0.6521,0.5043),(0.6284,0.4478),(0.6143,0.4101),(0.5797,0.2022),(0.6661,0.4218),(0.662,0.4424),(0.6902,0.4685),(0.612,0.5096),(0.6732,0.5199),(0.6906,0.5216),(0.6648,0.4275),(0.6006,0.6387),(0.6699,0.5917),(0.5465,0.5863),(0.6097,0.6626),(0.6232,0.5834),(0.6905,0.5819),(0.5874,0.6082),(0.557,0.6118),(0.6363,0.6201),(0.6272,0.633),(0.4554,0.7347),(0.4434,0.7663),(0.5927,0.4713),(0.6481,0.3724),(0.691,0.5975),(0.67,0.6224),(0.654,0.6446),(0.5782,0.5894),(0.627,0.5519),(0.5845,0.5609),(0.6527,0.4895),(0.1692,0.6095),(0.1989,0.5257),(0.1794,0.5383),(0.09398,0.3588),(0.1362,0.4032),(0.1964,0.5087),(0.161,0.3162),(0.1281,0.2293),(0.1459,0.4498),(0.1732,0.4907),(0.08025,0.278),(0.1492,0.4933),(0.1644,0.5076),(0.1772,0.5214),(0.4166,0.1802),(0.4206,0.1745),(0.4283,0.1709),(0.4338,0.1716),(0.4418,0.1726),(0.4461,0.1785),(0.4494,0.1874),(0.4124,0.201),(0.4204,0.1959),(0.4283,0.1968),(0.432,0.2108),(0.4376,0.2026),(0.4482,0.1984),(0.3985,0.2004),(0.4058,0.2019),(0.4115,0.2236),(0.4388,0.2186),(0.4417,0.2076),(0.3925,0.2171),(0.4105,0.2328),(0.428,0.2392),(0.3929,0.2334),(0.4002,0.2342),(0.4128,0.247),(0.424,0.2562),(0.4299,0.2525),(0.3973,0.2475),(0.4248,0.2627),(0.4348,0.2615),(0.4396,0.2555),(0.4489,0.256),(0.4051,0.264),(0.41,0.2703),(0.4179,0.2719),(0.4264,0.2742),(0.4366,0.2717),(0.4447,0.2639),(0.416,0.1778),(0.4213,0.1734),(0.4291,0.1699),(0.4425,0.1715),(0.4468,0.1774),(0.4501,0.1864),(0.4131,0.2),(0.4211,0.1949),(0.429,0.1957),(0.3993,0.1994),(0.4045,0.2162),(0.3932,0.2161),(0.4009,0.2332),(0.3936,0.2323),(0.4136,0.2459),(0.4248,0.2552),(0.398,0.2465),(0.4157,0.2574),(0.4255,0.2616),(0.4356,0.2604),(0.4407,0.254),(0.4058,0.2629),(0.4107,0.2693),(0.4186,0.2708),(0.4271,0.2731),(0.4373,0.2706),(0.4455,0.2628),(0.8673,0.4753),(0.5559,0.4701),(0.4896,0.2468),(0.441,0.2417),(0.7161,0.7588),(0.9698,0.5545),(0.9555,0.6365),(0.9299,0.7021),(0.8135,0.3782),(0.7696,0.7689),(0.88,0.7396),(0.9587,0.4934),(0.876,0.416),(0.7507,0.349),(0.7119,0.3507),(0.8256,0.7594),(0.4623,0.5555),(0.4752,0.6494),(0.5031,0.6976),(0.6095,0.3784),(0.6417,0.7671),(0.5467,0.7301),(0.4728,0.4963),(0.548,0.4079),(0.6693,0.3498),(0.5962,0.7535),(0.8035,0.2322),(0.7992,0.2901),(0.8026,0.1751),(0.4252,0.6776),(0.3897,0.6813),(0.3916,0.6763)]),
          coord=Coordinate(DEF='Body-COORD',point=[(-0.05269,13.2,-1.842),(-0.5906,17.72,-15.67),(-0.1489,10.08,-14.94),(0.1654,16.26,-1.58),(3.616,13.38,-1.26),(6.16,14.15,-4.274),(5.811,13.65,-8.648),(6.473,15.58,-7.906),(4.392,10.25,-13.92),(5.202,16.39,-12.11),(3.234,17.19,-14.21),(4.477,15.51,-4.425),(-4.558,10.25,-13.94),(-3.926,13.38,-1.268),(-6.036,14.14,-4.331),(-6.06,13.59,-8.633),(-6.731,15.65,-7.116),(-6.005,16.46,-11.45),(-4.126,17.17,-13.79),(-4.547,15.48,-3.854),(-6.819,3.504,-6.547),(-7.723,5.261,3.896),(-7.699,5.778,-2.93),(-8.167,6.488,-0.04749),(-5.503,1.214,3.811),(0.3071,-1.822,3.669),(0.1606,9.799,1.325),(0.2359,5.027,4.306),(0.2491,5.654,-13.53),(-0.5187,3.143,-10.14),(-4.141,5.93,-17.0),(-1.72,4.307,-15.42),(-6.186,4.838,-14.91),(-4.586,3.403,-11.86),(-3.874,8.489,-16.0),(0.4709,-4.215,3.926),(4.337,9.757,1.647),(4.137,1.415,4.522),(7.229,10.06,-0.4813),(8.149,6.617,-9.286),(6.534,10.01,-8.825),(4.044,5.931,-16.99),(6.09,4.839,-14.89),(4.293,3.33,-11.86),(1.646,4.307,-15.42),(0.892,3.138,-10.2),(6.71,3.47,-7.397),(7.622,5.811,-12.92),(6.551,7.632,-14.45),(3.753,8.49,-15.99),(8.135,8.132,-11.83),(7.132,9.24,-12.75),(4.777,9.303,-15.3),(8.156,5.995,-2.964),(8.167,6.473,-0.01642),(3.076,-1.088,1.459),(9.042,4.925,3.135),(3.297,-0.2019,0.05315),(2.496,-3.371,1.013),(8.908,1.464,2.871),(6.43,1.102,2.846),(0.3415,0.2209,-3.687),(2.709,0.07128,-3.897),(1.394,1.446,-7.541),(0.3969,1.983,-5.912),(-0.9287,1.536,-7.39),(1.527,-0.2436,-0.9153),(0.2619,-2.198,-2.957),(1.865,-3.018,-0.08607),(-0.9392,-0.3397,-0.8851),(-1.084,-2.97,-0.3168),(-2.117,0.6688,-5.019),(-4.977,9.302,-15.32),(-7.828,5.81,-12.94),(-6.787,7.734,-15.05),(-2.716,-0.934,1.494),(-2.044,-3.376,0.832),(-8.118,1.694,4.133),(-4.478,9.754,1.617),(-3.412,1.507,4.269),(-6.768,10.05,-0.5821),(-8.465,6.616,-9.309),(-6.849,10.01,-8.843),(-8.455,8.131,-11.85),(-7.462,9.238,-12.79),(-8.545,6.472,-0.03934),(-4.01,7.073,-16.98),(3.898,7.073,-16.97),(0.03628,4.607,-16.27),(-3.189,-0.01787,-0.02068),(7.785,6.473,-0.0231),(-8.553,6.505,-0.04437),(5.903,1.244,-5.133),(-5.832,1.281,-4.376),(-5.649,0.7479,3.826),(6.557,0.6031,3.098),(3.506,-0.4116,2.831),(-3.534,-0.1652,2.707),(-1.155,-2.801,2.821),(-1.887,-3.78,2.657),(-1.101,-1.371,3.281),(1.608,-2.961,2.865),(2.479,-3.707,2.394),(1.584,-1.429,3.229),(0.4329,-3.523,3.694),(10.53,1.909,-2.821),(11.01,2.906,-1.044),(11.72,5.376,-2.143),(12.18,4.017,-5.878),(10.3,5.305,-8.318),(9.554,2.227,-5.929),(9.039,14.26,-6.339),(11.04,14.33,-10.76),(12.9,13.1,-8.93),(13.09,12.86,-5.75),(10.9,9.892,-2.5),(9.671,17.07,-8.071),(10.47,16.98,-5.016),(11.36,15.2,-3.537),(11.27,19.13,-13.57),(9.766,19.76,-11.47),(10.56,27.41,-13.72),(11.55,26.82,-15.64),(10.64,20.1,-9.355),(12.31,28.0,-11.55),(12.58,20.28,-6.89),(11.6,19.46,-5.981),(11.56,17.04,-4.401),(13.15,16.8,-6.074),(13.41,27.64,-12.96),(13.67,19.78,-9.205),(13.2,27.21,-14.73),(13.48,19.35,-11.54),(13.65,16.67,-8.376),(13.12,16.1,-10.33),(11.7,29.57,-17.77),(12.35,29.8,-18.4),(12.86,30.7,-15.17),(11.24,28.61,-17.26),(11.91,28.18,-18.49),(13.18,30.82,-12.18),(13.05,32.5,-19.4),(13.13,31.3,-18.12),(13.49,31.32,-19.04),(12.54,33.26,-19.57),(12.24,33.03,-18.72),(13.0,32.88,-18.22),(12.44,33.39,-18.73),(12.69,32.42,-18.66),(12.45,33.82,-18.43),(12.19,33.55,-17.61),(12.85,33.11,-16.83),(12.67,32.85,-17.29),(12.46,33.88,-17.43),(12.26,33.66,-17.02),(12.04,33.4,-16.26),(12.71,33.16,-15.58),(12.5,32.87,-15.95),(12.21,33.76,-16.07),(13.24,31.95,-14.77),(12.85,31.76,-15.25),(12.72,31.81,-13.81),(12.72,32.47,-14.94),(12.18,33.02,-15.26),(11.88,32.95,-14.66),(12.6,32.64,-13.87),(12.39,32.42,-14.22),(12.06,33.23,-14.47),(13.05,31.75,-12.99),(12.98,29.39,-18.26),(14.1,30.12,-17.82),(14.14,30.27,-15.97),(13.64,30.58,-13.64),(13.37,32.49,-18.84),(13.06,32.92,-19.06),(14.08,31.26,-18.25),(13.78,31.87,-18.59),(13.52,31.7,-17.58),(14.0,31.75,-16.87),(13.76,32.29,-17.2),(13.31,32.95,-17.55),(13.05,33.3,-17.8),(13.38,31.9,-16.14),(13.77,31.78,-15.46),(13.6,32.25,-15.73),(12.93,33.26,-16.31),(13.16,32.91,-16.17),(13.03,32.48,-14.43),(12.84,32.76,-14.64),(13.39,31.98,-14.08),(13.57,31.5,-13.76),(11.15,30.39,-20.01),(10.62,30.28,-21.62),(11.0,30.5,-21.49),(10.86,29.73,-19.79),(10.94,30.03,-21.9),(11.37,29.5,-20.7),(11.67,29.01,-19.58),(11.88,29.96,-20.28),(11.68,30.15,-20.77),(11.27,30.24,-21.82),(11.35,2.461,-3.731),(-10.07,2.121,-0.2432),(-10.3,3.125,1.623),(-11.07,5.611,0.7086),(-12.01,4.267,-2.851),(-10.4,5.518,-5.727),(-9.403,2.422,-3.557),(-8.6,14.44,-4.131),(-11.1,14.56,-7.989),(-12.75,13.36,-5.72),(-12.56,13.12,-2.54),(-10.1,10.38,0.06581),(-9.348,17.26,-5.691),(-9.776,17.19,-2.483),(-10.53,15.43,-0.7975),(-11.52,19.37,-10.72),(-9.77,19.96,-9.026),(-10.6,27.63,-11.08),(-11.82,27.06,-12.72),(-10.37,20.32,-6.726),(-12.05,28.25,-8.504),(-11.98,20.53,-3.816),(-10.93,19.69,-3.162),(-10.77,17.27,-1.607),(-12.55,17.06,-2.859),(-13.31,27.92,-9.612),(-13.35,20.06,-5.824),(-13.33,27.49,-11.41),(-13.45,19.63,-8.172),(-13.31,16.95,-5.003),(-13.05,16.37,-7.059),(-12.15,29.82,-14.79),(-12.86,30.06,-15.25),(-12.94,30.97,-11.94),(-11.66,28.85,-14.39),(-12.48,28.43,-15.44),(-12.9,31.09,-8.912),(-13.58,32.78,-16.07),(-13.54,31.57,-14.78),(-14.01,31.6,-15.6),(-13.09,33.52,-16.36),(-12.7,33.28,-15.59),(-13.39,33.15,-14.92),(-12.88,33.65,-15.57),(-13.14,32.69,-15.43),(-12.84,34.08,-15.27),(-12.5,33.8,-14.52),(-13.07,33.38,-13.59),(-12.95,33.11,-14.08),(-12.73,34.14,-14.28),(-12.49,33.91,-13.92),(-12.19,33.65,-13.22),(-12.78,33.42,-12.39),(-12.62,33.13,-12.8),(-12.33,34.01,-13.0),(-13.24,32.23,-11.45),(-12.91,32.03,-12.02),(-12.62,32.07,-10.64),(-12.73,32.73,-11.76),(-12.22,33.27,-12.21),(-11.86,33.2,-11.69),(-12.48,32.9,-10.73),(-12.32,32.68,-11.13),(-12.01,33.47,-11.46),(-12.85,32.02,-9.75),(-13.47,29.66,-14.95),(-14.5,30.41,-14.24),(-14.32,30.56,-12.41),(-13.53,30.86,-10.24),(-13.84,32.77,-15.44),(-13.55,33.19,-15.73),(-14.49,31.55,-14.67),(-14.23,32.15,-15.09),(-13.85,31.98,-14.16),(-14.24,32.04,-13.34),(-14.03,32.57,-13.72),(-13.61,33.22,-14.18),(-13.37,33.57,-14.49),(-13.54,32.17,-12.77),(-13.84,32.07,-12.0),(-13.7,32.53,-12.31),(-13.08,33.53,-13.05),(-13.3,33.19,-12.86),(-12.98,32.75,-11.18),(-12.81,33.02,-11.43),(-13.3,32.25,-10.74),(-13.45,31.78,-10.38),(-11.84,30.63,-17.13),(-11.52,30.51,-18.85),(-11.87,30.74,-18.63),(-11.56,29.96,-16.99),(-11.88,30.26,-19.04),(-12.17,29.74,-17.76),(-12.35,29.26,-16.58),(-12.61,30.21,-17.21),(-12.46,30.4,-17.75),(-12.18,30.48,-18.88),(-10.98,2.691,-0.9363),(-7.714,5.778,-2.928),(-8.182,6.489,-0.04561),(-0.6392,21.98,-17.49),(-0.3312,25.97,-13.79),(0.4694,21.7,1.054),(0.4985,26.82,-4.988),(0.4188,26.86,-9.724),(0.3885,18.5,0.4731),(-7.852,18.47,-9.511),(-6.446,17.6,-5.002),(-6.551,20.27,-13.3),(-3.625,21.47,-15.52),(-3.392,18.39,0.7123),(-6.974,49.27,-13.89),(-6.529,44.92,-10.75),(-4.426,49.63,-8.407),(-4.516,45.0,-9.194),(-1.974,44.92,-10.74),(-2.093,49.51,-10.37),(-1.249,49.23,-15.38),(-7.719,44.77,-13.55),(-1.076,44.77,-13.55),(-1.708,44.56,-17.68),(-4.304,48.98,-19.45),(-4.512,44.47,-19.54),(-6.789,44.56,-17.69),(-8.223,40.63,-12.99),(-0.6866,40.63,-13.01),(-2.03,39.69,-16.97),(-4.966,39.28,-19.06),(-6.65,39.69,-17.0),(-9.441,31.87,-11.56),(-8.105,32.82,-6.428),(-5.267,34.86,-4.789),(-1.793,35.03,-5.724),(-0.3959,32.99,-11.66),(-1.926,32.15,-16.38),(-5.032,31.41,-18.28),(-7.688,31.29,-15.8),(-9.126,22.62,-8.579),(-8.893,26.86,-3.38),(-5.401,29.75,-3.026),(0.3505,27.0,-3.263),(-0.06787,29.3,-6.003),(-8.141,20.7,-3.385),(-8.727,23.7,-3.19),(-6.072,23.54,2.03),(-5.706,21.73,1.245),(-0.8289,20.68,2.908),(-1.3,22.66,3.287),(0.4838,23.55,0.8498),(1.196,24.06,-1.422),(-5.314,25.3,2.093),(-3.534,27.11,1.436),(-1.191,25.51,2.531),(-1.379,27.37,-1.518),(0.4691,25.87,-0.259),(1.829,25.41,-3.956),(-7.246,55.04,-15.12),(-6.368,55.44,-12.38),(-4.048,55.48,-11.03),(-1.769,55.4,-12.35),(-0.9347,54.99,-15.08),(-1.811,54.81,-17.99),(-3.882,54.67,-19.04),(-6.277,54.75,-17.84),(-6.232,61.82,-16.07),(-5.666,62.01,-13.64),(-3.786,62.07,-12.55),(-1.935,61.97,-13.63),(-1.139,61.77,-16.05),(-1.959,61.55,-18.66),(-3.638,61.29,-19.49),(-5.541,61.5,-18.52),(-5.084,67.11,-18.09),(-5.032,66.86,-15.8),(-3.567,66.77,-14.79),(-2.622,66.86,-15.79),(-2.193,67.1,-18.4),(-2.699,67.31,-20.57),(-3.903,67.39,-21.29),(-4.826,67.28,-20.57),(-5.256,68.49,-23.35),(-4.039,68.78,-24.49),(-4.682,69.78,-28.52),(-5.444,69.94,-24.82),(-2.868,68.53,-23.5),(-2.401,69.88,-25.12),(-3.224,69.78,-28.75),(-1.807,68.53,-20.58),(-1.694,68.1,-14.4),(-2.002,69.09,-14.47),(-1.435,68.96,-16.83),(-3.539,68.14,-13.47),(-3.534,69.11,-13.62),(-5.192,68.08,-14.04),(-5.093,69.13,-14.15),(-5.598,68.11,-20.28),(-5.604,68.97,-16.56),(-5.361,70.67,-24.95),(-3.894,70.52,-29.36),(-2.566,70.72,-24.96),(-4.648,67.31,-14.33),(-2.246,67.3,-14.47),(-3.164,71.29,-14.71),(-3.929,71.28,-14.67),(-3.201,71.24,-15.63),(-3.967,71.23,-15.6),(-0.1329,26.82,-4.909),(-0.6173,26.87,-9.595),(7.314,18.32,-11.41),(6.441,17.47,-6.615),(5.633,20.14,-14.83),(2.522,21.4,-16.29),(4.137,18.32,-0.2298),(6.805,49.13,-15.62),(6.617,44.79,-12.4),(4.961,49.54,-9.582),(4.823,44.91,-10.36),(2.133,44.88,-11.25),(2.426,49.47,-10.93),(0.989,49.21,-15.66),(7.451,44.62,-15.45),(0.9096,44.75,-13.8),(1.034,44.53,-18.03),(3.506,48.9,-20.43),(3.572,44.38,-20.55),(6.037,44.43,-19.3),(7.896,40.46,-15.01),(0.4727,40.62,-13.15),(1.298,39.65,-17.38),(3.928,39.18,-20.17),(5.844,39.56,-18.56),(9.017,31.68,-13.87),(8.339,32.65,-8.486),(5.798,34.74,-6.173),(2.271,34.99,-6.233),(0.3727,32.98,-11.76),(1.202,31.91,-16.73),(3.862,31.32,-19.39),(6.769,31.14,-17.61),(8.798,22.43,-10.82),(9.309,26.67,-5.658),(5.995,29.63,-4.452),(0.4375,29.3,-6.066),(8.392,20.53,-5.454),(9.077,23.51,-5.418),(7.08,23.4,0.3837),(6.575,21.6,-0.2915),(1.94,20.65,2.561),(2.505,22.62,2.811),(-0.4742,24.08,-1.213),(6.391,25.18,0.6279),(4.612,27.02,0.4165),(2.389,25.47,2.083),(2.145,27.33,-1.959),(0.6758,25.87,-0.2849),(-1.36,25.44,-3.557),(7.092,54.89,-16.91),(6.564,55.3,-14.0),(4.442,55.39,-12.1),(2.038,55.36,-12.83),(0.8801,54.97,-15.31),(1.391,54.77,-18.39),(3.302,54.59,-19.94),(5.805,54.63,-19.35),(6.173,61.69,-17.63),(5.911,61.89,-15.09),(4.191,61.98,-13.54),(2.237,61.93,-14.15),(1.158,61.75,-16.34),(1.65,61.51,-19.11),(3.197,61.22,-20.34),(5.192,61.38,-19.86),(4.941,67.01,-19.25),(5.168,66.75,-17.07),(3.724,66.69,-15.69),(2.796,66.8,-16.47),(2.045,67.05,-19.02),(2.315,67.26,-21.2),(3.489,67.32,-22.21),(4.408,67.18,-21.72),(4.67,68.39,-24.51),(3.368,68.7,-25.41),(3.666,69.7,-29.53),(4.757,69.84,-26.0),(2.29,68.48,-24.21),(1.712,69.83,-25.73),(2.201,69.72,-29.48),(1.499,68.48,-21.12),(1.93,68.05,-14.97),(2.252,69.04,-15.09),(1.475,68.92,-17.33),(3.844,68.07,-14.39),(3.847,69.04,-14.54),(5.431,67.98,-15.26),(5.346,69.03,-15.36),(5.276,68.01,-21.52),(5.633,68.87,-17.84),(4.679,70.58,-26.11),(2.826,70.45,-30.22),(1.908,70.67,-25.6),(4.849,67.22,-15.44),(2.454,67.24,-15.14),(3.43,71.22,-15.55),(4.192,71.2,-15.66),(3.384,71.17,-16.48),(4.145,71.15,-16.59),(-0.407,-8.198,-6.974),(4.272,-7.33,-0.8678),(0.2667,-12.64,4.28),(-0.2694,-1.954,-6.377),(0.4657,-8.225,-6.412),(3.373,-8.893,-5.017),(3.832,-8.062,-3.52),(-0.3357,-11.01,-5.457),(-0.1641,-12.4,-2.276),(0.1209,-12.67,2.079),(-0.5186,-5.967,-9.182),(-0.4501,-3.993,-8.628),(-0.4332,-2.838,-8.648),(3.425,-5.88,3.528),(4.132,-8.029,2.97),(0.7743,-8.52,10.99),(0.7071,-10.41,10.39),(0.4247,-12.39,6.594),(0.5476,-4.373,6.568),(0.3109,-3.022,2.662),(0.07495,-2.584,-1.014),(4.426,-8.096,-0.08317),(3.661,-11.39,4.122),(2.233,-12.39,4.274),(2.315,-2.901,-4.991),(3.27,-3.785,-3.971),(4.148,-5.799,-2.08),(1.454,-11.44,-3.961),(3.711,-9.511,-2.623),(2.338,-12.17,1.55),(0.08449,-6.003,-8.741),(1.074,-3.278,-7.337),(3.241,-5.798,-5.186),(2.987,-9.652,9.707),(2.992,-11.42,8.239),(4.419,-10.06,5.745),(3.881,-5.905,0.2803),(2.644,-3.27,-1.936),(-0.0305,-12.66,-0.1911),(-0.4055,-9.71,-6.559),(-0.4253,-7.715,-7.367),(-0.4362,-7.422,-7.602),(-0.4763,-6.761,-8.355),(0.1428,-6.593,-7.301),(0.04294,-7.117,-6.899),(-0.5184,-6.206,-9.135),(-0.4789,-5.709,-8.656),(-0.4435,-5.512,-8.167),(-0.4898,-5.091,-8.968),(0.3879,-5.491,-7.736),(0.7558,-4.964,-8.331),(0.3191,-7.002,-6.459),(0.7049,-5.81,-7.161),(1.805,-4.479,-6.918),(2.372,-3.866,-5.977),(0.6208,-2.21,-7.706),(-0.4473,-4.527,-8.458),(-0.4101,-3.735,-8.084),(-0.4185,-3.194,-8.34),(-0.4043,-2.326,-8.332),(-0.05927,-2.122,-3.156),(0.7919,-4.005,-7.631),(-0.4908,-4.902,-9.027),(-0.4675,-4.284,-8.822),(0.842,-4.517,-8.213),(0.0755,-5.134,-8.631),(1.904,-5.939,-7.342),(0.2589,-6.263,-7.862),(-0.131,-6.416,-8.788),(0.7809,-4.19,-8.16),(2.364,-8.897,-6.341),(0.264,-7.732,-5.932),(3.701,-7.391,-4.304),(2.235,-9.446,-6.385),(1.226,-7.595,-6.25),(0.01432,-7.581,-6.612),(2.669,-8.166,-5.859),(3.361,-8.418,-5.319),(1.041,-8.327,-5.8),(1.141,-8.823,-6.851),(2.897,-10.73,-3.276),(1.994,-12.04,-1.873),(2.591,-5.008,-6.317),(0.1669,-3.088,0.4973),(-0.4256,-8.907,-7.067),(1.397,-3.025,-7.188),(0.009189,-7.935,-6.475),(0.3285,-8.601,-7.179),(0.6217,-9.108,-7.034),(2.853,-7.625,-5.005),(1.191,-6.757,-6.435),(2.964,-6.894,-5.251),(0.9026,-5.407,-7.778),(0.781,-5.288,10.32),(3.192,-6.753,9.553),(0.5883,-11.58,8.877),(1.195,-4.435,7.997),(1.233,-4.705,8.963),(0.7519,-4.422,9.672),(0.7862,-4.081,10.11),(0.8817,-3.527,11.42),(0.9569,-2.598,12.34),(1.018,-0.7746,12.83),(1.188,1.149,14.95),(1.159,2.051,14.29),(1.085,4.422,12.61),(0.9607,5.302,10.84),(0.8052,5.126,7.838),(0.7566,3.401,7.881),(0.6023,1.284,6.05),(0.5514,-1.504,5.942),(0.6729,-2.965,8.129),(0.6053,-3.246,7.173),(0.5755,-3.587,6.803),(1.711,1.729,11.67),(1.555,0.2519,9.493),(1.167,-3.965,8.011),(1.345,1.984,8.971),(1.418,3.825,9.58),(1.331,-1.051,9.629),(1.211,-2.374,10.01),(1.315,-3.425,8.955),(1.47,3.239,11.1),(1.287,-3.376,10.07),(1.246,-3.818,9.461),(1.211,-4.238,8.962),(4.126,-5.9,3.185),(4.019,-5.758,2.965),(3.876,-5.707,2.615),(3.795,-5.764,2.404),(3.676,-5.848,2.094),(3.629,-6.075,1.942),(3.71,-6.333,1.906),(4.312,-6.485,3.584),(4.155,-6.389,3.208),(4.036,-6.469,2.899),(3.809,-6.882,3.0),(3.672,-6.681,2.686),(3.729,-6.66,2.09),(4.525,-6.371,4.134),(4.421,-6.464,3.859),(4.21,-7.118,3.965),(3.874,-7.187,2.761),(3.884,-6.87,2.487),(4.723,-6.822,4.56),(4.281,-7.382,4.102),(4.048,-7.694,3.473),(4.055,-7.72,2.905),(4.818,-7.303,4.723),(4.711,-7.38,4.436),(4.59,-7.843,4.07),(4.215,-8.167,3.817),(4.1,-8.099,3.541),(4.836,-7.752,4.7),(4.408,-8.379,3.798),(4.242,-8.412,3.38),(4.039,-8.253,3.207),(4.141,-8.313,2.799),(4.816,-8.29,4.568),(4.779,-8.511,4.441),(4.665,-8.612,4.141),(4.546,-8.738,3.825),(4.371,-8.735,3.387),(4.195,-8.561,2.974),(4.29,-5.892,3.077),(4.184,-5.75,2.856),(4.041,-5.699,2.507),(3.841,-5.84,1.986),(3.797,-6.043,1.881),(4.476,-6.477,3.476),(4.319,-6.381,3.1),(4.2,-6.461,2.79),(4.69,-6.363,4.026),(4.713,-6.895,4.001),(4.446,-7.374,3.994),(4.888,-6.814,4.451),(4.982,-7.295,4.614),(4.875,-7.372,4.328),(4.754,-7.835,3.961),(4.379,-8.159,3.709),(5.001,-7.745,4.591),(4.792,-8.187,4.002),(4.572,-8.371,3.69),(4.406,-8.405,3.272),(4.981,-8.283,4.459),(4.944,-8.503,4.333),(4.829,-8.604,4.032),(4.711,-8.73,3.716),(4.535,-8.727,3.279),(4.359,-8.553,2.866),(-4.174,-7.235,0.2955),(-1.191,-8.206,-6.184),(-3.883,-8.811,-4.017),(-4.112,-7.972,-2.426),(-2.688,-5.508,4.009),(-3.534,-7.794,3.941),(-4.256,-8.146,0.8519),(-3.064,-11.31,5.046),(-1.848,-12.2,4.802),(-2.539,-2.652,-4.366),(-3.486,-3.723,-3.035),(-4.163,-5.705,-0.9352),(-2.248,-11.48,-4.128),(-4.038,-9.715,-1.086),(-2.11,-12.02,2.138),(-1.052,-5.99,-8.584),(-1.755,-3.246,-6.948),(-3.679,-5.72,-4.233),(-1.597,-9.6,10.34),(-1.85,-11.36,8.903),(-3.68,-10.05,6.874),(-3.595,-5.82,1.31),(-2.589,-3.211,-1.215),(-0.9394,-6.581,-7.152),(-0.8051,-7.108,-6.782),(-1.203,-5.473,-7.517),(-1.625,-4.937,-8.004),(-1.015,-6.987,-6.275),(-1.449,-5.786,-6.865),(-2.455,-4.431,-6.331),(-2.753,-3.517,-5.336),(-1.47,-2.176,-7.42),(-1.539,-3.979,-7.31),(-1.68,-4.488,-7.865),(-1.002,-5.122,-8.483),(-2.703,-5.897,-6.705),(-1.117,-6.248,-7.672),(-0.8598,-6.407,-8.688),(-1.603,-4.163,-7.831),(-3.066,-8.836,-5.593),(-0.9146,-7.718,-5.769),(-4.065,-7.304,-3.234),(-2.962,-9.387,-5.67),(-1.859,-7.584,-5.814),(-0.7539,-7.573,-6.506),(-3.195,-8.12,-5.05),(-3.814,-8.314,-4.336),(-1.679,-8.297,-5.426),(-1.929,-8.788,-6.428),(-3.145,-10.73,-2.25),(-2.219,-11.89,-1.316),(-3.02,-4.984,-5.536),(-1.956,-2.793,-6.77),(-0.742,-7.927,-6.372),(-1.168,-8.584,-6.972),(-1.453,-9.084,-6.749),(-3.235,-7.585,-3.996),(-1.763,-6.775,-6.015),(-3.449,-6.822,-4.367),(-1.71,-5.499,-7.391),(-1.732,-6.697,10.23),(0.09739,-4.422,8.148),(0.178,-4.693,9.108),(0.4737,0.4701,11.9),(0.3498,-0.8807,10.24),(0.1411,-3.953,8.153),(0.08874,1.376,8.614),(0.3308,3.853,9.563),(0.4247,-2.17,10.07),(0.2226,-3.382,9.098),(0.382,2.698,12.04),(0.3113,-3.365,10.2),(0.2584,-3.806,9.597),(0.2143,-4.227,9.099),(-3.456,-5.815,4.23),(-3.376,-5.676,3.985),(-3.281,-5.628,3.603),(-3.231,-5.686,3.373),(-3.158,-5.772,3.038),(-3.135,-5.976,2.924),(-3.143,-6.261,2.895),(-3.604,-6.397,4.675),(-3.497,-6.304,4.263),(-3.424,-6.386,3.928),(-3.201,-6.804,3.968),(-3.101,-6.606,3.621),(-3.279,-6.58,3.077),(-3.737,-6.279,5.272),(-3.674,-6.374,4.974),(-3.474,-7.032,5.024),(-3.295,-7.093,3.758),(-3.358,-6.799,3.479),(-3.889,-6.726,5.746),(-3.534,-7.295,5.179),(-3.398,-7.611,4.5),(-3.976,-7.205,5.933),(-3.911,-7.284,5.623),(-3.855,-7.749,5.233),(-3.531,-8.08,4.885),(-3.453,-8.015,4.582),(-4.011,-7.654,5.917),(-3.729,-8.288,4.919),(-3.624,-8.325,4.464),(-3.375,-8.173,4.198),(-3.635,-8.279,3.765),(-4.026,-8.192,5.784),(-4.013,-8.413,5.651),(-3.944,-8.516,5.326),(-3.873,-8.644,4.984),(-3.759,-8.644,4.507),(-3.636,-8.474,4.054),(-3.628,-5.754,4.209),(-3.552,-5.664,3.922),(-3.456,-5.616,3.541),(-3.333,-5.76,2.975),(-3.311,-5.964,2.861),(-3.319,-6.25,2.833),(-3.78,-6.386,4.613),(-3.672,-6.292,4.201),(-3.599,-6.375,3.865),(-3.912,-6.268,5.21),(-3.955,-6.799,5.194),(-4.065,-6.714,5.683),(-4.086,-7.272,5.561),(-4.151,-7.194,5.871),(-4.031,-7.737,5.171),(-3.707,-8.069,4.823),(-4.186,-7.642,5.855),(-4.074,-8.088,5.222),(-3.905,-8.277,4.857),(-3.799,-8.313,4.402),(-3.582,-8.151,4.111),(-4.201,-8.18,5.722),(-4.189,-8.401,5.589),(-4.12,-8.505,5.264),(-4.049,-8.633,4.922),(-3.935,-8.633,4.445),(-3.811,-8.462,3.991),(3.853,-4.762,-3.03),(-3.973,-4.556,-2.108),(8.372,10.02,-4.531),(-7.986,10.1,-3.549)]))),
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=1.0,diffuseColor=(0.5882,0.5882,0.5882),shininess=0.145),
          texture=ImageTexture(url=["LaetitiaHeadTemplateColor.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/LaetitiaHeadTemplateColor.jpg"])),
        geometry=IndexedFaceSet(DEF='Body-FACE',ccw=False,coordIndex=[594,586,511,-1,595,591,546,-1,514,580,546,-1,512,587,535,-1,535,587,529,-1,514,515,534,-1,515,545,588,-1,513,528,508,-1,512,535,513,-1,535,529,528,-1,588,529,587,-1,536,530,529,-1,545,516,530,-1,516,509,530,-1,575,517,552,-1,576,568,518,-1,575,574,537,-1,558,551,578,-1,565,538,519,-1,569,557,571,-1,532,589,539,-1,512,513,584,-1,531,567,562,-1,538,592,519,-1,527,531,544,-1,557,572,556,-1,533,835,539,-1,508,533,579,-1,508,579,513,-1,601,603,520,-1,522,540,523,-1,522,601,540,-1,602,541,524,-1,523,540,541,-1,540,542,541,-1,601,542,540,-1,520,521,601,-1,524,530,509,-1,524,541,530,-1,541,529,530,-1,541,542,529,-1,542,528,529,-1,521,528,542,-1,508,528,521,-1,102,526,544,-1,544,526,590,-1,508,543,533,-1,508,521,543,-1,544,543,102,-1,531,532,544,-1,531,561,532,-1,567,531,527,-1,545,530,536,-1,515,588,534,-1,586,580,577,-1,582,547,593,-1,582,548,547,-1,551,548,582,-1,551,558,550,-1,551,549,548,-1,551,550,549,-1,559,574,550,-1,549,575,552,-1,517,537,553,-1,553,556,554,-1,560,599,573,-1,574,559,537,-1,553,537,556,-1,554,556,572,-1,559,550,558,-1,597,573,559,-1,599,557,559,-1,598,596,579,-1,571,570,563,-1,539,589,573,-1,560,538,568,-1,567,510,562,-1,592,562,519,-1,566,562,510,-1,569,571,563,-1,568,565,564,-1,568,538,565,-1,519,562,566,-1,562,592,531,-1,568,564,518,-1,560,561,538,-1,557,569,572,-1,560,568,571,-1,518,570,576,-1,557,560,571,-1,573,589,560,-1,554,572,555,-1,569,555,572,-1,597,559,558,-1,573,599,559,-1,574,575,550,-1,537,559,556,-1,575,549,550,-1,575,537,517,-1,568,576,571,-1,571,576,570,-1,580,587,512,-1,585,511,586,-1,578,551,582,-1,598,579,539,-1,512,584,577,-1,584,583,577,-1,534,580,514,-1,581,578,585,-1,558,581,597,-1,596,598,581,-1,578,582,593,-1,547,507,593,-1,585,578,511,-1,583,584,596,-1,513,579,584,-1,579,596,584,-1,596,581,583,-1,583,585,577,-1,577,585,586,-1,595,580,586,-1,580,512,577,-1,535,528,513,-1,534,588,587,-1,580,534,587,-1,588,536,529,-1,545,536,588,-1,589,561,560,-1,532,561,589,-1,544,532,543,-1,543,835,533,-1,590,527,544,-1,594,593,507,-1,561,531,592,-1,538,561,592,-1,578,593,511,-1,511,593,594,-1,586,594,595,-1,591,594,507,-1,594,591,595,-1,580,595,546,-1,583,581,585,-1,539,573,598,-1,573,597,598,-1,581,558,578,-1,598,597,581,-1,539,579,533,-1,557,556,559,-1,560,557,599,-1,102,543,520,-1,521,542,601,-1,601,522,600,-1,523,541,602,-1,604,603,601,-1,520,543,521,-1,603,525,526,-1,603,102,520,-1,526,102,603,-1,600,604,601,-1,620,525,603,-1,619,620,623,-1,618,619,623,-1,612,613,629,-1,614,615,625,-1,615,616,624,-1,618,623,628,-1,630,606,607,-1,627,609,626,-1,627,608,609,-1,616,617,622,-1,615,624,625,-1,622,609,621,-1,621,609,610,-1,630,607,608,-1,623,603,604,-1,632,604,605,-1,604,600,605,-1,631,605,606,-1,625,624,629,-1,629,624,621,-1,629,613,625,-1,613,614,625,-1,624,616,622,-1,622,617,626,-1,617,627,626,-1,618,627,617,-1,628,630,627,-1,618,628,627,-1,623,632,628,-1,623,620,603,-1,629,621,610,-1,610,612,629,-1,621,624,622,-1,622,626,609,-1,630,608,627,-1,631,606,630,-1,628,631,630,-1,632,605,631,-1,628,632,631,-1,623,604,632,-1,640,634,633,-1,634,640,641,-1,641,635,634,-1,635,641,642,-1,642,636,635,-1,636,642,643,-1,643,637,636,-1,637,643,644,-1,644,638,637,-1,638,644,645,-1,645,639,638,-1,633,646,647,-1,647,640,633,-1,640,647,648,-1,648,641,640,-1,648,642,641,-1,642,648,653,-1,653,643,642,-1,644,643,649,-1,653,649,643,-1,644,649,650,-1,650,645,644,-1,646,651,647,-1,648,647,652,-1,648,652,653,-1,654,649,653,-1,651,655,656,-1,656,647,651,-1,652,656,657,-1,656,652,647,-1,652,657,658,-1,652,658,659,-1,659,653,652,-1,653,659,663,-1,663,654,653,-1,655,660,656,-1,661,658,657,-1,658,661,662,-1,662,659,658,-1,659,662,663,-1,664,654,663,-1,665,656,660,-1,656,665,666,-1,666,657,656,-1,657,666,667,-1,667,661,657,-1,661,667,668,-1,668,662,661,-1,662,668,669,-1,669,663,662,-1,663,669,670,-1,670,664,663,-1,671,672,677,-1,672,673,677,-1,677,676,671,-1,678,677,673,-1,678,674,645,-1,674,678,673,-1,674,675,645,-1,675,639,645,-1,676,679,671,-1,676,677,680,-1,680,677,681,-1,678,681,677,-1,681,678,645,-1,649,681,645,-1,650,649,645,-1,679,676,680,-1,680,682,679,-1,654,681,649,-1,682,680,684,-1,684,683,682,-1,684,681,685,-1,681,684,680,-1,686,685,681,-1,681,654,521,-1,521,686,681,-1,684,687,683,-1,684,685,688,-1,688,686,689,-1,686,688,685,-1,690,689,686,-1,690,521,664,-1,521,690,686,-1,521,654,664,-1,687,684,691,-1,684,688,692,-1,692,691,684,-1,693,689,694,-1,693,692,688,-1,689,690,695,-1,689,693,688,-1,690,664,696,-1,695,694,689,-1,696,695,690,-1,633,634,672,-1,672,671,633,-1,634,635,673,-1,673,672,634,-1,635,636,673,-1,636,637,674,-1,674,673,636,-1,637,638,675,-1,675,674,637,-1,639,675,638,-1,664,670,696,-1,670,669,695,-1,695,696,670,-1,669,668,694,-1,694,695,669,-1,668,667,693,-1,693,694,668,-1,667,666,692,-1,692,693,667,-1,666,665,691,-1,691,692,666,-1,665,660,691,-1,687,691,660,-1,660,655,683,-1,683,687,660,-1,655,651,682,-1,682,683,655,-1,651,646,679,-1,679,682,651,-1,646,633,671,-1,671,679,646,-1,751,698,745,-1,752,546,591,-1,514,546,739,-1,699,710,746,-1,710,704,746,-1,514,709,515,-1,515,747,545,-1,700,697,703,-1,699,700,710,-1,710,703,704,-1,747,746,704,-1,711,704,705,-1,545,705,516,-1,516,705,509,-1,734,552,517,-1,735,518,729,-1,734,712,733,-1,724,737,721,-1,565,519,713,-1,569,730,723,-1,707,714,748,-1,699,743,700,-1,706,728,567,-1,713,519,749,-1,527,719,706,-1,723,722,731,-1,836,714,707,-1,697,738,708,-1,697,700,738,-1,757,701,758,-1,522,523,715,-1,522,715,757,-1,602,524,716,-1,523,716,715,-1,715,716,717,-1,757,715,717,-1,701,757,702,-1,524,509,705,-1,524,705,716,-1,716,705,704,-1,716,704,717,-1,717,704,703,-1,702,717,703,-1,697,702,703,-1,99,719,526,-1,719,590,526,-1,697,708,718,-1,697,718,702,-1,719,99,718,-1,706,719,707,-1,706,707,727,-1,567,527,706,-1,545,711,705,-1,515,709,747,-1,745,736,739,-1,741,750,547,-1,741,547,548,-1,721,741,548,-1,721,720,724,-1,721,548,549,-1,721,549,720,-1,725,720,733,-1,549,552,734,-1,517,553,712,-1,553,554,722,-1,726,732,756,-1,733,712,725,-1,553,722,712,-1,554,731,722,-1,725,724,720,-1,754,725,732,-1,756,725,723,-1,755,738,753,-1,730,563,570,-1,714,732,748,-1,726,729,713,-1,567,728,510,-1,749,519,728,-1,566,510,728,-1,569,563,730,-1,729,564,565,-1,729,565,713,-1,519,566,728,-1,728,706,749,-1,729,518,564,-1,726,713,727,-1,723,731,569,-1,726,730,729,-1,518,735,570,-1,723,730,726,-1,732,726,748,-1,554,555,731,-1,569,731,555,-1,754,724,725,-1,732,725,756,-1,733,720,734,-1,712,722,725,-1,734,720,549,-1,734,517,712,-1,729,730,735,-1,730,570,735,-1,739,699,746,-1,744,745,698,-1,737,741,721,-1,755,714,738,-1,699,736,743,-1,743,736,742,-1,709,514,739,-1,740,744,737,-1,724,754,740,-1,753,740,755,-1,737,750,741,-1,547,750,507,-1,744,698,737,-1,742,753,743,-1,700,743,738,-1,738,743,753,-1,753,742,740,-1,742,736,744,-1,736,745,744,-1,752,745,739,-1,739,736,699,-1,710,700,703,-1,709,746,747,-1,739,746,709,-1,747,704,711,-1,545,747,711,-1,748,726,727,-1,707,748,727,-1,719,718,707,-1,718,836,707,-1,590,719,527,-1,751,507,750,-1,727,749,706,-1,713,749,727,-1,737,698,750,-1,698,751,750,-1,745,752,751,-1,591,507,751,-1,751,752,591,-1,739,546,752,-1,742,744,740,-1,714,755,732,-1,732,755,754,-1,740,737,724,-1,755,740,754,-1,714,708,738,-1,723,725,722,-1,726,756,723,-1,99,701,718,-1,702,757,717,-1,757,600,522,-1,523,602,716,-1,759,757,758,-1,701,702,718,-1,758,526,525,-1,758,701,99,-1,526,758,99,-1,600,757,759,-1,620,758,525,-1,619,762,620,-1,618,762,619,-1,764,613,612,-1,764,614,613,-1,615,764,763,-1,618,766,762,-1,768,607,606,-1,609,608,761,-1,608,765,761,-1,617,616,763,-1,763,764,767,-1,761,763,760,-1,765,608,768,-1,762,759,758,-1,770,605,759,-1,759,605,600,-1,769,606,605,-1,767,760,763,-1,764,612,767,-1,764,615,614,-1,617,763,761,-1,761,765,617,-1,617,765,618,-1,766,765,768,-1,618,765,766,-1,762,766,770,-1,762,758,620,-1,610,760,767,-1,610,767,612,-1,760,610,609,-1,761,760,609,-1,768,608,607,-1,769,768,606,-1,766,768,769,-1,770,769,605,-1,766,769,770,-1,762,770,759,-1,778,771,772,-1,772,779,778,-1,779,772,773,-1,773,780,779,-1,780,773,774,-1,774,781,780,-1,781,774,775,-1,775,782,781,-1,782,775,776,-1,776,783,782,-1,783,776,777,-1,771,785,784,-1,785,771,778,-1,778,786,785,-1,786,778,779,-1,786,779,780,-1,780,791,786,-1,791,780,781,-1,782,787,781,-1,791,781,787,-1,782,788,787,-1,788,782,783,-1,784,785,789,-1,786,790,785,-1,786,791,790,-1,702,791,787,-1,789,793,792,-1,793,789,785,-1,790,794,793,-1,793,785,790,-1,790,795,794,-1,790,796,795,-1,796,790,791,-1,791,800,796,-1,800,791,702,-1,792,793,797,-1,798,794,795,-1,795,799,798,-1,799,795,796,-1,796,800,799,-1,801,800,702,-1,802,797,793,-1,793,803,802,-1,803,793,794,-1,794,804,803,-1,804,794,798,-1,798,805,804,-1,805,798,799,-1,799,806,805,-1,806,799,800,-1,800,807,806,-1,807,800,801,-1,808,815,809,-1,809,815,810,-1,815,808,814,-1,816,810,815,-1,816,783,811,-1,811,810,816,-1,811,783,812,-1,812,783,813,-1,814,808,817,-1,814,818,815,-1,816,815,818,-1,818,783,816,-1,787,783,818,-1,788,783,787,-1,817,818,814,-1,818,817,819,-1,702,787,818,-1,819,820,818,-1,820,819,821,-1,820,823,818,-1,823,820,822,-1,702,818,823,-1,820,821,824,-1,820,825,822,-1,825,826,823,-1,823,822,825,-1,827,823,826,-1,827,828,702,-1,702,823,827,-1,801,702,828,-1,824,829,820,-1,820,830,825,-1,830,820,829,-1,831,832,826,-1,831,825,830,-1,826,833,827,-1,826,825,831,-1,827,834,828,-1,833,826,832,-1,828,834,801,-1,834,827,833,-1,771,809,772,-1,809,771,808,-1,772,810,773,-1,810,772,809,-1,773,810,774,-1,774,811,775,-1,811,774,810,-1,775,812,776,-1,812,775,811,-1,776,813,777,-1,813,776,812,-1,783,777,813,-1,801,834,807,-1,807,833,806,-1,833,807,834,-1,806,832,805,-1,832,806,833,-1,805,831,804,-1,831,805,832,-1,804,830,803,-1,830,804,831,-1,803,829,802,-1,829,803,830,-1,802,829,797,-1,824,797,829,-1,797,821,792,-1,821,797,824,-1,792,819,789,-1,819,792,821,-1,789,817,784,-1,817,789,819,-1,784,808,771,-1,808,784,817,-1,616,615,763,-1,835,532,539,-1,543,532,835,-1,708,714,836,-1,718,708,836,-1],creaseAngle=5,texCoordIndex=[2105,2097,2021,-1,2106,2102,2057,-1,2350,2091,2057,-1,2022,2361,2356,-1,2045,2098,2039,-1,2024,2025,2044,-1,2025,2056,2099,-1,2023,2353,2018,-1,2022,2356,2023,-1,2045,2039,2038,-1,2099,2039,2098,-1,2046,2040,2039,-1,2056,2026,2040,-1,2026,2019,2040,-1,2086,2027,2063,-1,2087,2079,2028,-1,2086,2085,2047,-1,2069,2062,2089,-1,2076,2048,2029,-1,2080,2068,2082,-1,2042,2100,2049,-1,2022,2023,2095,-1,2041,2078,2073,-1,2048,2103,2029,-1,2037,2041,2055,-1,2068,2083,2067,-1,2043,2346,2049,-1,2018,2043,2090,-1,2018,2090,2023,-1,2112,2114,2030,-1,2032,2050,2033,-1,2032,2112,2050,-1,2113,2051,2034,-1,2033,2050,2051,-1,2050,2052,2051,-1,2112,2052,2050,-1,2030,2031,2112,-1,2034,2040,2019,-1,2034,2051,2040,-1,2051,2039,2040,-1,2051,2052,2039,-1,2052,2038,2039,-1,2031,2038,2052,-1,2018,2353,2352,-1,2373,2372,2055,-1,2055,2372,2101,-1,2018,2054,2043,-1,2018,2352,2054,-1,2358,2054,2357,-1,2354,2042,2358,-1,2354,2072,2042,-1,2078,2041,2037,-1,2056,2040,2046,-1,2025,2099,2044,-1,2097,2091,2088,-1,2093,2058,2104,-1,2093,2059,2058,-1,2062,2059,2093,-1,2062,2069,2061,-1,2062,2060,2059,-1,2062,2061,2060,-1,2070,2085,2061,-1,2060,2086,2063,-1,2027,2047,2064,-1,2064,2067,2065,-1,2071,2110,2084,-1,2085,2070,2047,-1,2064,2047,2067,-1,2065,2067,2083,-1,2070,2061,2069,-1,2108,2084,2070,-1,2110,2068,2070,-1,2109,2107,2090,-1,2082,2081,2074,-1,2049,2100,2084,-1,2071,2048,2079,-1,2078,2020,2073,-1,2103,2359,2029,-1,2077,2073,2020,-1,2080,2082,2074,-1,2079,2076,2075,-1,2079,2048,2076,-1,2029,2359,2360,-1,2359,2103,2354,-1,2079,2075,2028,-1,2071,2072,2048,-1,2068,2080,2083,-1,2071,2079,2082,-1,2028,2081,2087,-1,2068,2071,2082,-1,2084,2100,2071,-1,2065,2083,2066,-1,2080,2066,2083,-1,2108,2070,2069,-1,2084,2110,2070,-1,2085,2086,2061,-1,2047,2070,2067,-1,2086,2060,2061,-1,2086,2047,2027,-1,2079,2087,2082,-1,2082,2087,2081,-1,2091,2361,2022,-1,2096,2021,2097,-1,2089,2062,2093,-1,2109,2090,2049,-1,2022,2095,2088,-1,2095,2094,2088,-1,2355,2091,2350,-1,2092,2089,2096,-1,2069,2092,2108,-1,2107,2109,2092,-1,2089,2093,2104,-1,2058,2017,2104,-1,2096,2089,2021,-1,2094,2095,2107,-1,2023,2090,2095,-1,2090,2107,2095,-1,2107,2092,2094,-1,2094,2096,2088,-1,2088,2096,2097,-1,2106,2091,2097,-1,2091,2022,2088,-1,2356,2353,2023,-1,2044,2099,2098,-1,2091,2355,2361,-1,2099,2046,2039,-1,2056,2046,2099,-1,2100,2072,2071,-1,2042,2072,2100,-1,2358,2042,2054,-1,2054,2346,2043,-1,2101,2037,2055,-1,2105,2104,2017,-1,2072,2354,2103,-1,2048,2072,2103,-1,2089,2104,2021,-1,2021,2104,2105,-1,2097,2105,2106,-1,2102,2105,2017,-1,2105,2102,2106,-1,2091,2106,2057,-1,2094,2092,2096,-1,2049,2084,2109,-1,2084,2108,2109,-1,2092,2069,2089,-1,2109,2108,2092,-1,2049,2090,2043,-1,2068,2067,2070,-1,2071,2068,2110,-1,2357,2054,2351,-1,2031,2052,2112,-1,2112,2032,2111,-1,2033,2051,2113,-1,2115,2114,2112,-1,2351,2054,2352,-1,2114,2035,2036,-1,2114,2053,2030,-1,2036,2053,2114,-1,2111,2115,2112,-1,2130,2035,2114,-1,2129,2130,2133,-1,2128,2129,2133,-1,2122,2123,2139,-1,2124,2125,2135,-1,2125,2126,2134,-1,2128,2133,2138,-1,2140,2117,2118,-1,2137,2120,2136,-1,2137,2119,2120,-1,2126,2127,2132,-1,2125,2134,2135,-1,2132,2120,2131,-1,2131,2120,2121,-1,2140,2118,2119,-1,2133,2114,2115,-1,2142,2115,2116,-1,2115,2111,2116,-1,2141,2116,2117,-1,2135,2134,2139,-1,2139,2134,2131,-1,2139,2123,2135,-1,2123,2124,2135,-1,2134,2126,2132,-1,2132,2127,2136,-1,2127,2137,2136,-1,2128,2137,2127,-1,2138,2140,2137,-1,2128,2138,2137,-1,2133,2142,2138,-1,2133,2130,2114,-1,2139,2131,2121,-1,2121,2122,2139,-1,2131,2134,2132,-1,2132,2136,2120,-1,2140,2119,2137,-1,2141,2117,2140,-1,2138,2141,2140,-1,2142,2116,2141,-1,2138,2142,2141,-1,2133,2115,2142,-1,2150,2144,2143,-1,2144,2150,2151,-1,2151,2145,2144,-1,2145,2151,2152,-1,2152,2146,2145,-1,2146,2152,2153,-1,2153,2147,2146,-1,2147,2153,2154,-1,2154,2148,2147,-1,2148,2154,2155,-1,2155,2149,2148,-1,2143,2156,2157,-1,2157,2150,2143,-1,2150,2157,2158,-1,2158,2151,2150,-1,2158,2152,2151,-1,2152,2158,2163,-1,2163,2153,2152,-1,2154,2153,2159,-1,2163,2159,2153,-1,2154,2159,2160,-1,2160,2155,2154,-1,2156,2161,2157,-1,2158,2157,2162,-1,2158,2162,2163,-1,2164,2159,2163,-1,2161,2165,2166,-1,2166,2157,2161,-1,2162,2166,2167,-1,2166,2162,2157,-1,2162,2167,2168,-1,2162,2168,2169,-1,2169,2163,2162,-1,2163,2169,2173,-1,2173,2164,2163,-1,2165,2170,2166,-1,2171,2168,2167,-1,2168,2171,2172,-1,2172,2169,2168,-1,2169,2172,2173,-1,2174,2164,2173,-1,2175,2166,2170,-1,2166,2175,2176,-1,2176,2167,2166,-1,2167,2176,2177,-1,2177,2171,2167,-1,2171,2177,2178,-1,2178,2172,2171,-1,2172,2178,2179,-1,2179,2173,2172,-1,2173,2179,2180,-1,2180,2174,2173,-1,2181,2182,2187,-1,2182,2183,2187,-1,2187,2186,2181,-1,2188,2187,2183,-1,2188,2184,2155,-1,2184,2188,2183,-1,2184,2185,2155,-1,2185,2149,2155,-1,2186,2189,2181,-1,2186,2187,2190,-1,2190,2187,2191,-1,2188,2191,2187,-1,2191,2188,2155,-1,2159,2191,2155,-1,2160,2159,2155,-1,2189,2186,2190,-1,2190,2192,2189,-1,2164,2191,2159,-1,2192,2190,2194,-1,2194,2193,2192,-1,2194,2191,2195,-1,2191,2194,2190,-1,2196,2195,2191,-1,2191,2164,2348,-1,2348,2196,2191,-1,2194,2197,2193,-1,2194,2195,2198,-1,2198,2196,2199,-1,2196,2198,2195,-1,2200,2199,2196,-1,2200,2348,2174,-1,2348,2200,2196,-1,2348,2164,2174,-1,2197,2194,2201,-1,2194,2198,2202,-1,2202,2201,2194,-1,2203,2199,2204,-1,2203,2202,2198,-1,2199,2200,2205,-1,2199,2203,2198,-1,2200,2174,2206,-1,2205,2204,2199,-1,2206,2205,2200,-1,2143,2144,2182,-1,2182,2181,2143,-1,2144,2145,2183,-1,2183,2182,2144,-1,2145,2146,2183,-1,2146,2147,2184,-1,2184,2183,2146,-1,2147,2148,2185,-1,2185,2184,2147,-1,2149,2185,2148,-1,2174,2180,2206,-1,2180,2179,2205,-1,2205,2206,2180,-1,2179,2178,2204,-1,2204,2205,2179,-1,2178,2177,2203,-1,2203,2204,2178,-1,2177,2176,2202,-1,2202,2203,2177,-1,2176,2175,2201,-1,2201,2202,2176,-1,2175,2170,2201,-1,2197,2201,2170,-1,2170,2165,2193,-1,2193,2197,2170,-1,2165,2161,2192,-1,2192,2193,2165,-1,2161,2156,2189,-1,2189,2192,2161,-1,2156,2143,2181,-1,2181,2189,2156,-1,2262,2208,2256,-1,2263,2057,2102,-1,2350,2057,2250,-1,2209,2367,2371,-1,2220,2214,2257,-1,2024,2219,2025,-1,2025,2258,2056,-1,2210,2207,2364,-1,2209,2210,2367,-1,2220,2213,2214,-1,2258,2257,2214,-1,2221,2214,2215,-1,2056,2215,2026,-1,2026,2215,2019,-1,2245,2063,2027,-1,2246,2028,2240,-1,2245,2222,2244,-1,2235,2248,2232,-1,2076,2029,2223,-1,2080,2241,2234,-1,2217,2224,2259,-1,2209,2254,2210,-1,2216,2239,2078,-1,2223,2029,2260,-1,2037,2230,2216,-1,2234,2233,2242,-1,2347,2224,2217,-1,2207,2249,2218,-1,2207,2210,2249,-1,2268,2211,2269,-1,2032,2033,2225,-1,2032,2225,2268,-1,2113,2034,2226,-1,2033,2226,2225,-1,2225,2226,2227,-1,2268,2225,2227,-1,2211,2268,2212,-1,2034,2019,2215,-1,2034,2215,2226,-1,2226,2215,2214,-1,2226,2214,2227,-1,2227,2214,2213,-1,2212,2227,2213,-1,2207,2363,2364,-1,2374,2230,2372,-1,2230,2101,2372,-1,2207,2218,2229,-1,2207,2229,2363,-1,2369,2368,2229,-1,2365,2369,2217,-1,2365,2217,2238,-1,2078,2037,2216,-1,2056,2221,2215,-1,2025,2219,2258,-1,2256,2247,2250,-1,2252,2261,2058,-1,2252,2058,2059,-1,2232,2252,2059,-1,2232,2231,2235,-1,2232,2059,2060,-1,2232,2060,2231,-1,2236,2231,2244,-1,2060,2063,2245,-1,2027,2064,2222,-1,2064,2065,2233,-1,2237,2243,2267,-1,2244,2222,2236,-1,2064,2233,2222,-1,2065,2242,2233,-1,2236,2235,2231,-1,2265,2236,2243,-1,2267,2236,2234,-1,2266,2249,2264,-1,2241,2074,2081,-1,2224,2243,2259,-1,2237,2240,2223,-1,2078,2239,2020,-1,2260,2029,2370,-1,2077,2020,2239,-1,2080,2074,2241,-1,2240,2075,2076,-1,2240,2076,2223,-1,2029,2360,2370,-1,2370,2365,2260,-1,2240,2028,2075,-1,2237,2223,2238,-1,2234,2242,2080,-1,2237,2241,2240,-1,2028,2246,2081,-1,2234,2241,2237,-1,2243,2237,2259,-1,2065,2066,2242,-1,2080,2242,2066,-1,2265,2235,2236,-1,2243,2236,2267,-1,2244,2231,2245,-1,2222,2233,2236,-1,2245,2231,2060,-1,2245,2027,2222,-1,2240,2241,2246,-1,2241,2081,2246,-1,2250,2209,2371,-1,2255,2256,2208,-1,2248,2252,2232,-1,2266,2224,2249,-1,2209,2247,2254,-1,2254,2247,2253,-1,2366,2350,2250,-1,2251,2255,2248,-1,2235,2265,2251,-1,2264,2251,2266,-1,2248,2261,2252,-1,2058,2261,2017,-1,2255,2208,2248,-1,2253,2264,2254,-1,2210,2254,2249,-1,2249,2254,2264,-1,2264,2253,2251,-1,2253,2247,2255,-1,2247,2256,2255,-1,2263,2256,2250,-1,2250,2247,2209,-1,2367,2210,2364,-1,2219,2257,2258,-1,2250,2371,2366,-1,2258,2214,2221,-1,2056,2258,2221,-1,2259,2237,2238,-1,2217,2259,2238,-1,2369,2229,2217,-1,2229,2347,2217,-1,2101,2230,2037,-1,2262,2017,2261,-1,2238,2260,2365,-1,2223,2260,2238,-1,2248,2208,2261,-1,2208,2262,2261,-1,2256,2263,2262,-1,2102,2017,2262,-1,2262,2263,2102,-1,2250,2057,2263,-1,2253,2255,2251,-1,2224,2266,2243,-1,2243,2266,2265,-1,2251,2248,2235,-1,2266,2251,2265,-1,2224,2218,2249,-1,2234,2236,2233,-1,2237,2267,2234,-1,2368,2362,2229,-1,2212,2268,2227,-1,2268,2111,2032,-1,2033,2113,2226,-1,2270,2268,2269,-1,2362,2363,2229,-1,2269,2036,2035,-1,2269,2211,2228,-1,2036,2269,2228,-1,2111,2268,2270,-1,2130,2269,2035,-1,2129,2273,2130,-1,2128,2273,2129,-1,2275,2123,2122,-1,2275,2124,2123,-1,2125,2275,2274,-1,2128,2277,2273,-1,2279,2118,2117,-1,2120,2119,2272,-1,2119,2276,2272,-1,2127,2126,2274,-1,2274,2275,2278,-1,2272,2274,2271,-1,2276,2119,2279,-1,2273,2270,2269,-1,2281,2116,2270,-1,2270,2116,2111,-1,2280,2117,2116,-1,2278,2271,2274,-1,2275,2122,2278,-1,2275,2125,2124,-1,2127,2274,2272,-1,2272,2276,2127,-1,2127,2276,2128,-1,2277,2276,2279,-1,2128,2276,2277,-1,2273,2277,2281,-1,2273,2269,2130,-1,2121,2271,2278,-1,2121,2278,2122,-1,2271,2121,2120,-1,2272,2271,2120,-1,2279,2119,2118,-1,2280,2279,2117,-1,2277,2279,2280,-1,2281,2280,2116,-1,2277,2280,2281,-1,2273,2281,2270,-1,2289,2282,2283,-1,2283,2290,2289,-1,2290,2283,2284,-1,2284,2291,2290,-1,2291,2284,2285,-1,2285,2292,2291,-1,2292,2285,2286,-1,2286,2293,2292,-1,2293,2286,2287,-1,2287,2294,2293,-1,2294,2287,2288,-1,2282,2296,2295,-1,2296,2282,2289,-1,2289,2297,2296,-1,2297,2289,2290,-1,2297,2290,2291,-1,2291,2302,2297,-1,2302,2291,2292,-1,2293,2298,2292,-1,2302,2292,2298,-1,2293,2299,2298,-1,2299,2293,2294,-1,2295,2296,2300,-1,2297,2301,2296,-1,2297,2302,2301,-1,2349,2302,2298,-1,2300,2304,2303,-1,2304,2300,2296,-1,2301,2305,2304,-1,2304,2296,2301,-1,2301,2306,2305,-1,2301,2307,2306,-1,2307,2301,2302,-1,2302,2311,2307,-1,2311,2302,2349,-1,2303,2304,2308,-1,2309,2305,2306,-1,2306,2310,2309,-1,2310,2306,2307,-1,2307,2311,2310,-1,2312,2311,2349,-1,2313,2308,2304,-1,2304,2314,2313,-1,2314,2304,2305,-1,2305,2315,2314,-1,2315,2305,2309,-1,2309,2316,2315,-1,2316,2309,2310,-1,2310,2317,2316,-1,2317,2310,2311,-1,2311,2318,2317,-1,2318,2311,2312,-1,2319,2326,2320,-1,2320,2326,2321,-1,2326,2319,2325,-1,2327,2321,2326,-1,2327,2294,2322,-1,2322,2321,2327,-1,2322,2294,2323,-1,2323,2294,2324,-1,2325,2319,2328,-1,2325,2329,2326,-1,2327,2326,2329,-1,2329,2294,2327,-1,2298,2294,2329,-1,2299,2294,2298,-1,2328,2329,2325,-1,2329,2328,2330,-1,2349,2298,2329,-1,2330,2331,2329,-1,2331,2330,2332,-1,2331,2334,2329,-1,2334,2331,2333,-1,2349,2329,2334,-1,2331,2332,2335,-1,2331,2336,2333,-1,2336,2337,2334,-1,2334,2333,2336,-1,2338,2334,2337,-1,2338,2339,2349,-1,2349,2334,2338,-1,2312,2349,2339,-1,2335,2340,2331,-1,2331,2341,2336,-1,2341,2331,2340,-1,2342,2343,2337,-1,2342,2336,2341,-1,2337,2344,2338,-1,2337,2336,2342,-1,2338,2345,2339,-1,2344,2337,2343,-1,2339,2345,2312,-1,2345,2338,2344,-1,2282,2320,2283,-1,2320,2282,2319,-1,2283,2321,2284,-1,2321,2283,2320,-1,2284,2321,2285,-1,2285,2322,2286,-1,2322,2285,2321,-1,2286,2323,2287,-1,2323,2286,2322,-1,2287,2324,2288,-1,2324,2287,2323,-1,2294,2288,2324,-1,2312,2345,2318,-1,2318,2344,2317,-1,2344,2318,2345,-1,2317,2343,2316,-1,2343,2317,2344,-1,2316,2342,2315,-1,2342,2316,2343,-1,2315,2341,2314,-1,2341,2315,2342,-1,2314,2340,2313,-1,2340,2314,2341,-1,2313,2340,2308,-1,2335,2308,2340,-1,2308,2332,2303,-1,2332,2308,2335,-1,2303,2330,2300,-1,2330,2303,2332,-1,2300,2328,2295,-1,2328,2300,2330,-1,2295,2319,2282,-1,2319,2295,2328,-1,2126,2125,2274,-1,2346,2042,2049,-1,2054,2042,2346,-1,2218,2224,2347,-1,2229,2218,2347,-1],
          texCoord=TextureCoordinate(USE='Body-TEXCOORD'),
          coord=Coordinate(USE='Body-COORD')))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Laetitia.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Laetitia.py load and self-test diagnostics complete.")
