####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python KeyboardEightyEightKeys.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='KeyboardEightyEightKeys.x3d',name='title'),
    meta(content='Eight-eight key keyboard, extrapolated from VRML Sourcebook Figure 24.4, including animation of key movements coordinated with sounding of key when touched.',name='description'),
    meta(content='Not all tones work (hardware, operating system dependent?) and so may need some higher-frequency sound files.',name='warning'),
    meta(content='X3D Specification Comment: pitch attribute might be better on Sound node, thus avoiding need for AudioClip to reload the same audio file multiple times',name='TODO'),
    meta(content='Scott Gilman',name='creator'),
    meta(content='27 August 2004',name='created'),
    meta(content='14 July 2023',name='modified'),
    meta(content='https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/Figure24.4FourKeyKeyboard.x3d',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/KeyboardEightyEightKeys.x3d',name='identifier'),
    meta(content='Figure 24.4, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland',name='reference'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='KeyboardEightyEightKeys.x3d'),
    DirectionalLight(DEF='LightFromAbove',direction=(0,-1,-0.2)),
    Viewpoint(description='Middle C, C#, D, D#',orientation=(1,0,0,-0.758),position=(0,2,2)),
    Viewpoint(DEF='RightSide',description='From right end of keyboard',orientation=(-.238,.939,.25,1.6349),position=(15.5,8.5,-.2)),
    Viewpoint(DEF='FrontFar',description='Looking down from a distance',orientation=(-1,.007,-.004,.6661),position=(.3,11,13.7)),
    Viewpoint(DEF='LeftSide',description='From left end of keyboard',orientation=(-.252,-.932,-.261,1.636),position=(-15.9,9.6,-.1)),
    Viewpoint(DEF='TopDown',description='Looking down from above middle C',orientation=(-1,-.024,.007,1.5504),position=(-1,15.4,.3)),
    Viewpoint(DEF='TopDownCloser',description='Top-down view, closer',orientation=(-1,-.005,-.008,1.1528),position=(-.6,7.1,3.1)),
    Group(
      children=[
      Transform(DEF='A0TRANS',translation=(-7.5,0,0),
        children=[
        Shape(DEF='WhiteKey',
          geometry=Box(size=(0.23,0.1,1.5)),
          appearance=Appearance(DEF='IvoryWhite',
            #  https://en.wikipedia.org/wiki/Shades_of_white#Ivory 
            material=Material(diffuseColor=(1,1,0.941176)))),
        TouchSensor(DEF='A0',description='play Pitch A0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchA0',description='playing Pitch A0',pitch=0.053,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='As0TRANS',translation=(-7.375,0.1,-.375),
        children=[
        Shape(DEF='BlackKey',
          geometry=Box(size=(0.23,0.1,1.5)),
          appearance=Appearance(
            material=Material(diffuseColor=(0.1,0.1,0.1)))),
        TouchSensor(DEF='As0',description='play Pitch As0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchAs0',description='playing Pitch As0',pitch=.056,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='B0TRANS',translation=(-7.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='B0',description='play Pitch B0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchB0',description='playing Pitch B0',pitch=.059,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='C0TRANS',translation=(-7,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='C0',description='play Pitch C0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchC0',description='playing Pitch C0',pitch=.062,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Cs0TRANS',translation=(-6.875,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Cs0',description='play Pitch Cs1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchCs0',description='playing Pitch Cs0',pitch=.066,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='D0TRANS',translation=(-6.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='D0',description='play Pitch D0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchD0',description='playing Pitch D0',pitch=.070,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Ds0TRANS',translation=(-6.625,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Ds0',description='play Pitch Ds0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchDs0',description='playing Pitch Ds0',pitch=.074,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='E0TRANS',translation=(-6.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='E0',description='play Pitch E0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchE0',description='playing Pitch E0',pitch=.079,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='F0TRANS',translation=(-6.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='F0',description='play Pitch F0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchF0',description='playing Pitch F0',pitch=.083,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Fs0TRANS',translation=(-6.125,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Fs0',description='play Pitch Fs0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchFs0',description='playing Pitch Fs0',pitch=.088,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='G0TRANS',translation=(-6,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='G0',description='play Pitch G0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchG0',description='playing Pitch G0',pitch=.094,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Gs0TRANS',translation=(-5.875,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Gs0',description='play Pitch Gs0'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchGs0',description='playing Pitch Gs0',pitch=.099,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='A1TRANS',translation=(-5.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='A1',description='play Pitch A1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchA1',description='playing Pitch A1',pitch=.105,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='As1TRANS',translation=(-5.625,0.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='As1',description='play Pitch As1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchAs1',description='playing Pitch As1',pitch=.111,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='B1TRANS',translation=(-5.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='B1',description='play Pitch B1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchB1',description='playing Pitch B1',pitch=.118,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='C1TRANS',translation=(-5.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='C1',description='play Pitch C1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchC1',description='playing Pitch C1',pitch=.125,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Cs1TRANS',translation=(-5.125,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Cs1',description='play Pitch Cs1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchCs1',description='playing Pitch Cs1',pitch=.132,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='D1TRANS',translation=(-5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='D1',description='play Pitch D1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchD1',description='playing Pitch D1',pitch=.140,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Ds1TRANS',translation=(-4.875,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Ds1',description='play Pitch Ds1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchDs1',description='playing Pitch Ds1',pitch=.149,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='E1TRANS',translation=(-4.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='E1',description='play Pitch E1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchE1',description='playing Pitch E1',pitch=.157,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='F1TRANS',translation=(-4.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='F1',description='play Pitch F1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchF1',description='playing Pitch F1',pitch=.167,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Fs1TRANS',translation=(-4.375,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Fs1',description='play Pitch Fs1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchFs1',description='playing Pitch Fs1',pitch=.177,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='G1TRANS',translation=(-4.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='G1',description='play Pitch G1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchG1',description='playing Pitch G1',pitch=.187,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Gs1TRANS',translation=(-4.125,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Gs1',description='play Pitch Gs1'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchGs1',description='playing Pitch Gs1',pitch=.198,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='A2TRANS',translation=(-4,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='A2',description='play Pitch A2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchA2',description='playing Pitch A2',pitch=.210,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='As2TRANS',translation=(-3.875,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='As2',description='play Pitch As2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchAs2',description='playing Pitch As2',pitch=.223,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='B2TRANS',translation=(-3.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='B2',description='play Pitch B2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchB2',description='playing Pitch B2',pitch=.236,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='C2TRANS',translation=(-3.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='C2',description='play Pitch C2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchC2',description='playing Pitch C2',pitch=.250,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Cs2TRANS',translation=(-3.375,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Cs2',description='play Pitch Cs2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchCs2',description='playing Pitch Cs2',pitch=.265,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='D2TRANS',translation=(-3.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='D2',description='play Pitch D2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchD2',description='playing Pitch D2',pitch=.281,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Ds2TRANS',translation=(-3.125,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Ds2',description='play Pitch Ds2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchDs2',description='playing Pitch Ds2',pitch=.297,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='E2TRANS',translation=(-3,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='E2',description='play Pitch E2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchE2',description='playing Pitch E2',pitch=.315,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='F2TRANS',translation=(-2.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='F2',description='play pitch F2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchF2',description='playing Pitch F2',pitch=.334,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Fs2TRANS',translation=(-2.625,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Fs2',description='play pitch Fs2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchFs2',description='playing Pitch Fs2',pitch=.354,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='G2TRANS',translation=(-2.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='G2',description='play pitch G2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchG2',description='playing Pitch G2',pitch=.375,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Gs2TRANS',translation=(-2.375,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Gs2',description='play pitch Gs2'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchGs2',description='playing Pitch Gs2',pitch=.397,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='A3TRANS',translation=(-2.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='A3',description='play pitch A3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchA3',description='playing Pitch A3',pitch=.420,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='As3TRANS',translation=(-2.125,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='As3',description='play pitch As3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchAs3',description='playing Pitch As3',pitch=.445,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='B3TRANS',translation=(-2,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='B3',description='play pitch B3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchB3',description='playing Pitch B3',pitch=.472,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='C3TRANS',translation=(-1.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='C3',description='play pitch C3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchC3',description='playing Pitch C3',pitch=.500,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Cs3TRANS',translation=(-1.625,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Cs3',description='play pitch Cs3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchCs3',description='playing Pitch Cs3',pitch=.530,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='D3TRANS',translation=(-1.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='D3',description='play pitch D3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchD3',description='playing Pitch D3',pitch=.561,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Ds3TRANS',translation=(-1.375,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Ds3',description='play pitch Ds3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchDs3',description='playing Pitch Ds3',pitch=.595,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='E3TRANS',translation=(-1.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='E3',description='play pitch E3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchE3',description='playing Pitch E3',pitch=.630,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='F3TRANS',translation=(-1,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='F3',description='play pitch F3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchF3',description='playing Pitch F3',pitch=.667,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Fs3TRANS',translation=(-.875,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Fs3',description='play pitch Fs3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchFs3',description='playing Pitch Fs3',pitch=.707,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='G3TRANS',translation=(-.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='G3',description='play pitch G3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchG3',description='playing Pitch G3',pitch=.749,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Gs3TRANS',translation=(-.625,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Gs3',description='play pitch Gs3'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchGs3',description='playing Pitch Gs3',pitch=.794,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='A4TRANS',translation=(-.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='A4',description='play pitch A4'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchA4',description='playing Pitch A4',pitch=.841,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='As4TRANS',translation=(-.375,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='As4',description='play pitch As4'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchAs4',description='playing Pitch As4',pitch=.891,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='B4TRANS',translation=(-.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='B4',description='play pitch B4'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchB4',description='playing Pitch B4',pitch=.944,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='C4TRANS',
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='C4',description='play pitch C4'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchC4',description='playing Pitch C4',url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Cs4TRANS',translation=(0.125,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Cs4',description='play pitch Csharp4'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchCs4',description='playing Pitch Cs4',pitch=1.059,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='D4TRANS',translation=(0.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='D4',description='play pitch D4'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchD4',description='playing Pitch D4',pitch=1.122,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Ds4TRANS',translation=(0.375,0.1,-0.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Ds4',description='play pitch Dsharp4'),
        Sound(maxBack=110,maxFront=110,minBack=100,minFront=100,
          source=AudioClip(DEF='PitchDs4',description='playing Pitch Ds4',pitch=1.189,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='E4TRANS',translation=(.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='E4',description='play pitch E4'),
        Sound(
          source=AudioClip(DEF='PitchE4',description='playing Pitch E4',pitch=1.260,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='F4TRANS',translation=(.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='F4',description='play pitch F4'),
        Sound(
          source=AudioClip(DEF='PitchF4',description='playing Pitch F4',pitch=1.335,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Fs4TRANS',translation=(.875,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Fs4',description='play pitch Fsharp4'),
        Sound(
          source=AudioClip(DEF='PitchFs4',description='playing Pitch Fs4',pitch=1.414,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='G4TRANS',translation=(1,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='G4',description='play pitch G4'),
        Sound(
          source=AudioClip(DEF='PitchG4',description='playing Pitch G4',pitch=1.498,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Gs4TRANS',translation=(1.125,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Gs4',description='play pitch Gsharp4'),
        Sound(
          source=AudioClip(DEF='PitchGs4',description='playing Pitch Gs4',pitch=1.587,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='A5TRANS',translation=(1.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='A5',description='play pitch A5'),
        Sound(
          source=AudioClip(DEF='PitchA5',description='playing Pitch A5',pitch=1.682,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='As5TRANS',translation=(1.375,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='As5',description='play pitch Asharp5'),
        Sound(
          source=AudioClip(DEF='PitchAs5',description='playing Pitch As5',pitch=1.782,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='B5TRANS',translation=(1.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='B5',description='play pitch B5'),
        Sound(
          source=AudioClip(DEF='PitchB5',description='playing Pitch B5',pitch=1.888,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='C5TRANS',translation=(1.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='C5',description='play pitch C5'),
        Sound(
          source=AudioClip(DEF='PitchC5',description='playing Pitch C5',pitch=2,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Cs5TRANS',translation=(1.875,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Cs5',description='play pitch Csharp5'),
        Sound(
          source=AudioClip(DEF='PitchCs5',description='playing Pitch Cs5',pitch=2.119,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='D5TRANS',translation=(2,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='D5',description='play pitch D5'),
        Sound(
          source=AudioClip(DEF='PitchD5',description='playing Pitch D5',pitch=2.245,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Ds5TRANS',translation=(2.125,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Ds5',description='play pitch Ds5'),
        Sound(
          source=AudioClip(DEF='PitchDs5',description='playing Pitch Ds5',pitch=2.378,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='E5TRANS',translation=(2.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='E5',description='play pitch E5'),
        Sound(
          source=AudioClip(DEF='PitchE5',description='playing Pitch E5',pitch=2.520,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='F5TRANS',translation=(2.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='F5',description='play pitch F5'),
        Sound(
          source=AudioClip(DEF='PitchF5',description='playing Pitch F5',pitch=2.670,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Fs5TRANS',translation=(2.625,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Fs5',description='play pitch Fs5'),
        Sound(
          source=AudioClip(DEF='PitchFs5',description='playing Pitch Fs5',pitch=2.828,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='G5TRANS',translation=(2.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='G5',description='play pitch G5'),
        Sound(
          source=AudioClip(DEF='PitchG5',description='playing Pitch G5',pitch=2.997,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Gs5TRANS',translation=(2.875,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Gs5',description='play pitch Gs5'),
        Sound(
          source=AudioClip(DEF='PitchGs5',description='playing Pitch Gs5',pitch=3.175,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='A6TRANS',translation=(3,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='A6',description='play pitch A6'),
        Sound(
          source=AudioClip(DEF='PitchA6',description='playing Pitch A6',pitch=3.364,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='As6TRANS',translation=(3.125,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='As6',description='play pitch As6'),
        Sound(
          source=AudioClip(DEF='PitchAs6',description='playing Pitch As6',pitch=3.564,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='B6TRANS',translation=(3.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='B6',description='play pitch B6'),
        Sound(
          source=AudioClip(DEF='PitchB6',description='playing Pitch B6',pitch=3.775,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='C6TRANS',translation=(3.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='C6',description='play pitch C6'),
        Sound(
          source=AudioClip(DEF='PitchC6',description='playing Pitch C6',pitch=4,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Cs6TRANS',translation=(3.625,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Cs6',description='play pitch Cs6'),
        Sound(
          source=AudioClip(DEF='PitchCs6',description='playing Pitch Cs6',pitch=4.238,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='D6TRANS',translation=(3.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='D6',description='play pitch D6'),
        Sound(
          source=AudioClip(DEF='PitchD6',description='playing Pitch D6',pitch=4.49,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Ds6TRANS',translation=(3.875,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Ds6',description='play pitch Ds6'),
        Sound(
          source=AudioClip(DEF='PitchDs6',description='playing Pitch Ds6',pitch=4.757,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='E6TRANS',translation=(4,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='E6',description='play pitch E6'),
        Sound(
          source=AudioClip(DEF='PitchE6',description='playing Pitch E6',pitch=5.04,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='F6TRANS',translation=(4.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='F6',description='play pitch F6'),
        Sound(
          source=AudioClip(DEF='PitchF6',description='playing Pitch F6',pitch=5.339,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Fs6TRANS',translation=(4.375,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Fs6',description='play pitch Fs6'),
        Sound(
          source=AudioClip(DEF='PitchFs6',description='playing Pitch Fs6',pitch=5.657,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='G6TRANS',translation=(4.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='G6',description='play pitch G6'),
        Sound(
          source=AudioClip(DEF='PitchG6',description='playing Pitch G6',pitch=5.993,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Gs6TRANS',translation=(4.625,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Gs6',description='play pitch Gs6'),
        Sound(
          source=AudioClip(DEF='PitchGs6',description='playing Pitch Gs6',pitch=6.35,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='A7TRANS',translation=(4.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='A7',description='play pitch A7'),
        Sound(
          source=AudioClip(DEF='PitchA7',description='playing Pitch A7',pitch=6.727,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='As7TRANS',translation=(4.875,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='As7',description='play pitch As7'),
        Sound(
          source=AudioClip(DEF='PitchAs7',description='playing Pitch As7',pitch=7.127,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='B7TRANS',translation=(5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='B7',description='play pitch B7'),
        Sound(
          source=AudioClip(DEF='PitchB7',description='playing Pitch B7',pitch=7.551,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='C7TRANS',translation=(5.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='C7',description='play pitch C7'),
        Sound(
          source=AudioClip(DEF='PitchC7',description='playing Pitch C7',pitch=8,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Cs7TRANS',translation=(5.375,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Cs7',description='play pitch Cs7'),
        Sound(
          source=AudioClip(DEF='PitchCs7',description='playing Pitch Cs7',pitch=8.476,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='D7TRANS',translation=(5.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='D7',description='play pitch D7'),
        Sound(
          source=AudioClip(DEF='PitchD7',description='playing Pitch D7',pitch=8.980,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Ds7TRANS',translation=(5.625,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Ds7',description='play pitch Ds7'),
        Sound(
          source=AudioClip(DEF='PitchDs7',description='playing Pitch Ds7',pitch=9.514,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='E7TRANS',translation=(5.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='E7',description='play pitch E7'),
        Sound(
          source=AudioClip(DEF='PitchE7',description='playing Pitch E7',pitch=10.079,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='F7TRANS',translation=(6,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='F7',description='play pitch F7'),
        Sound(
          source=AudioClip(DEF='PitchF7',description='playing Pitch F7',pitch=10.679,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Fs7TRANS',translation=(6.125,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Fs7',description='play pitch Fs7'),
        Sound(
          source=AudioClip(DEF='PitchFs7',description='playing Pitch Fs7',pitch=11.314,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='G7TRANS',translation=(6.25,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='G7',description='play pitch G7'),
        Sound(
          source=AudioClip(DEF='PitchG7',description='playing Pitch G7',pitch=11.986,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='Gs7TRANS',translation=(6.375,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='Gs7',description='play pitch Gs7'),
        Sound(
          source=AudioClip(DEF='PitchGs7',description='playing Pitch Gs7',pitch=12.699,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='A8TRANS',translation=(6.5,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='A8',description='play pitch A8'),
        Sound(
          source=AudioClip(DEF='PitchA8',description='playing Pitch A8',pitch=13.454,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='As8TRANS',translation=(6.625,.1,-.375),
        children=[
        Shape(USE='BlackKey'),
        TouchSensor(DEF='As8',description='play pitch As8'),
        Sound(
          source=AudioClip(DEF='PitchAs8',description='playing Pitch As8',pitch=14.254,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='B8TRANS',translation=(6.75,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='B8',description='play pitch B8'),
        Sound(
          source=AudioClip(DEF='PitchB8',description='playing Pitch B8',pitch=15.102,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(DEF='C8TRANS',translation=(7,0,0),
        children=[
        Shape(USE='WhiteKey'),
        TouchSensor(DEF='C8',description='play pitch C8'),
        Sound(
          source=AudioClip(DEF='PitchC8',description='playing Pitch C8',pitch=16,url=["tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"]))]),
      Transform(scale=(.25,.25,.25),translation=(0,1,-2),
        children=[
        Shape(
          geometry=Sphere(),
          appearance=Appearance(
            material=Material(diffuseColor=(1,0,0)))),
        TouchSensor(DEF='StartPlaying',description='Touch to Activate Player Piano Script')]),
      TimeSensor(DEF='ClockA0'),
      TimeSensor(DEF='ClockAs0'),
      TimeSensor(DEF='ClockB0'),
      TimeSensor(DEF='ClockC0'),
      TimeSensor(DEF='ClockCs0'),
      TimeSensor(DEF='ClockD0'),
      TimeSensor(DEF='ClockDs0'),
      TimeSensor(DEF='ClockE0'),
      TimeSensor(DEF='ClockF0'),
      TimeSensor(DEF='ClockFs0'),
      TimeSensor(DEF='ClockG0'),
      TimeSensor(DEF='ClockGs0'),
      TimeSensor(DEF='ClockAs1'),
      TimeSensor(DEF='ClockB1'),
      TimeSensor(DEF='ClockC1'),
      TimeSensor(DEF='ClockCs1'),
      TimeSensor(DEF='ClockD1'),
      TimeSensor(DEF='ClockDs1'),
      TimeSensor(DEF='ClockE1'),
      TimeSensor(DEF='ClockF1'),
      TimeSensor(DEF='ClockFs1'),
      TimeSensor(DEF='ClockG1'),
      TimeSensor(DEF='ClockGs1'),
      TimeSensor(DEF='ClockA1'),
      TimeSensor(DEF='ClockA2'),
      TimeSensor(DEF='ClockAs2'),
      TimeSensor(DEF='ClockB2'),
      TimeSensor(DEF='ClockC2'),
      TimeSensor(DEF='ClockCs2'),
      TimeSensor(DEF='ClockD2'),
      TimeSensor(DEF='ClockDs2'),
      TimeSensor(DEF='ClockE2'),
      TimeSensor(DEF='ClockF2'),
      TimeSensor(DEF='ClockFs2'),
      TimeSensor(DEF='ClockG2'),
      TimeSensor(DEF='ClockGs2'),
      TimeSensor(DEF='ClockA3'),
      TimeSensor(DEF='ClockAs3'),
      TimeSensor(DEF='ClockB3'),
      TimeSensor(DEF='ClockC3'),
      TimeSensor(DEF='ClockCs3'),
      TimeSensor(DEF='ClockD3'),
      TimeSensor(DEF='ClockDs3'),
      TimeSensor(DEF='ClockE3'),
      TimeSensor(DEF='ClockF3'),
      TimeSensor(DEF='ClockFs3'),
      TimeSensor(DEF='ClockG3'),
      TimeSensor(DEF='ClockGs3'),
      TimeSensor(DEF='ClockA4'),
      TimeSensor(DEF='ClockAs4'),
      TimeSensor(DEF='ClockB4'),
      TimeSensor(DEF='ClockC4'),
      TimeSensor(DEF='ClockCs4'),
      TimeSensor(DEF='ClockD4'),
      TimeSensor(DEF='ClockDs4'),
      TimeSensor(DEF='ClockE4'),
      TimeSensor(DEF='ClockF4'),
      TimeSensor(DEF='ClockFs4'),
      TimeSensor(DEF='ClockG4'),
      TimeSensor(DEF='ClockGs4'),
      TimeSensor(DEF='ClockA5'),
      TimeSensor(DEF='ClockAs5'),
      TimeSensor(DEF='ClockB5'),
      TimeSensor(DEF='ClockC5'),
      TimeSensor(DEF='ClockCs5'),
      TimeSensor(DEF='ClockD5'),
      TimeSensor(DEF='ClockDs5'),
      TimeSensor(DEF='ClockE5'),
      TimeSensor(DEF='ClockF5'),
      TimeSensor(DEF='ClockFs5'),
      TimeSensor(DEF='ClockG5'),
      TimeSensor(DEF='ClockGs5'),
      TimeSensor(DEF='ClockA6'),
      TimeSensor(DEF='ClockAs6'),
      TimeSensor(DEF='ClockB6'),
      TimeSensor(DEF='ClockC6'),
      TimeSensor(DEF='ClockCs6'),
      TimeSensor(DEF='ClockD6'),
      TimeSensor(DEF='ClockDs6'),
      TimeSensor(DEF='ClockE6'),
      TimeSensor(DEF='ClockF6'),
      TimeSensor(DEF='ClockFs6'),
      TimeSensor(DEF='ClockG6'),
      TimeSensor(DEF='ClockGs6'),
      TimeSensor(DEF='ClockA7'),
      TimeSensor(DEF='ClockAs7'),
      TimeSensor(DEF='ClockB7'),
      TimeSensor(DEF='ClockC7'),
      TimeSensor(DEF='ClockCs7'),
      TimeSensor(DEF='ClockD7'),
      TimeSensor(DEF='ClockDs7'),
      TimeSensor(DEF='ClockE7'),
      TimeSensor(DEF='ClockF7'),
      TimeSensor(DEF='ClockFs7'),
      TimeSensor(DEF='ClockG7'),
      TimeSensor(DEF='ClockGs7'),
      TimeSensor(DEF='ClockA8'),
      TimeSensor(DEF='ClockAs8'),
      TimeSensor(DEF='ClockB8'),
      TimeSensor(DEF='ClockC8'),
      PositionInterpolator(DEF='A0Mover',key=[0.0,.99],keyValue=[(-7.5,-.03,0),(-7.5,0,0)]),
      PositionInterpolator(DEF='As0Mover',key=[0,.99],keyValue=[(-7.375,0,-.375),(-7.375,0.1,-0.375)]),
      PositionInterpolator(DEF='B0Mover',key=[0.0,.99],keyValue=[(-7.25,-.03,0),(-7.25,0,0)]),
      PositionInterpolator(DEF='C0Mover',key=[0.0,.99],keyValue=[(-7,-.03,0),(-7,0,0)]),
      PositionInterpolator(DEF='Cs0Mover',key=[0,.99],keyValue=[(-6.875,0,-.375),(-6.875,0.1,-0.375)]),
      PositionInterpolator(DEF='D0Mover',key=[0.0,.99],keyValue=[(-6.75,-.03,0),(-6.75,0,0)]),
      PositionInterpolator(DEF='Ds0Mover',key=[0,.99],keyValue=[(-6.625,0,-.375),(-6.625,0.1,-0.375)]),
      PositionInterpolator(DEF='E0Mover',key=[0.0,.99],keyValue=[(-6.5,-.03,0),(-6.5,0,0)]),
      PositionInterpolator(DEF='F0Mover',key=[0,.99],keyValue=[(-6.25,-.03,0),(-6.25,0,0)]),
      PositionInterpolator(DEF='Fs0Mover',key=[0.0,.99],keyValue=[(-6.125,0,-.375),(-6.125,0.1,-.375)]),
      PositionInterpolator(DEF='G0Mover',key=[0,.99],keyValue=[(-6,-.03,0),(-6,0,0)]),
      PositionInterpolator(DEF='Gs0Mover',key=[0.0,.99],keyValue=[(-5.875,0,-.375),(-5.875,.1,-.375)]),
      PositionInterpolator(DEF='A1Mover',key=[0.0,.99],keyValue=[(-5.75,-.03,0),(-5.75,0,0)]),
      PositionInterpolator(DEF='As1Mover',key=[0,.99],keyValue=[(-5.65,0,-.375),(-5.625,0.1,-0.375)]),
      PositionInterpolator(DEF='B1Mover',key=[0.0,.99],keyValue=[(-5.5,-.03,0),(-5.5,0,0)]),
      PositionInterpolator(DEF='C1Mover',key=[0.0,.99],keyValue=[(-5.25,-.03,0),(-5.25,0,0)]),
      PositionInterpolator(DEF='Cs1Mover',key=[0,.99],keyValue=[(-5.125,0,-.375),(-5.125,0.1,-0.375)]),
      PositionInterpolator(DEF='D1Mover',key=[0.0,.99],keyValue=[(-5,-.03,0),(-5,0,0)]),
      PositionInterpolator(DEF='Ds1Mover',key=[0,.99],keyValue=[(-4.875,0,-.375),(-4.875,0.1,-0.375)]),
      PositionInterpolator(DEF='E1Mover',key=[0.0,.99],keyValue=[(-4.75,-.03,0),(-4.75,0,0)]),
      PositionInterpolator(DEF='F1Mover',key=[0,.99],keyValue=[(-4.5,-.03,0),(-4.5,0,0)]),
      PositionInterpolator(DEF='Fs1Mover',key=[0.0,.99],keyValue=[(-4.375,0,-.375),(-4.375,0.1,-.375)]),
      PositionInterpolator(DEF='G1Mover',key=[0,.99],keyValue=[(-4.25,-.03,0),(-4.25,0,0)]),
      PositionInterpolator(DEF='Gs1Mover',key=[0.0,.99],keyValue=[(-4.125,0,-.375),(-4.125,.1,-.375)]),
      PositionInterpolator(DEF='A2Mover',key=[0,.99],keyValue=[(-4,-.03,0),(-4,0,0)]),
      PositionInterpolator(DEF='As2Mover',key=[0.0,.99],keyValue=[(-3.875,0,-.3750),(-3.875,.1,-.375)]),
      PositionInterpolator(DEF='B2Mover',key=[0,.99],keyValue=[(-3.75,-.03,0),(-3.75,0,0)]),
      PositionInterpolator(DEF='C2Mover',key=[0,.99],keyValue=[(-3.5,-.03,0),(-3.5,0,0)]),
      PositionInterpolator(DEF='Cs2Mover',key=[0,.99],keyValue=[(-3.375,0,-.375),(-3.375,0.1,-0.375)]),
      PositionInterpolator(DEF='D2Mover',key=[0.0,.99],keyValue=[(-3.25,-.03,0),(-3.25,0,0)]),
      PositionInterpolator(DEF='Ds2Mover',key=[0,.99],keyValue=[(-3.125,0,-.375),(-3.125,0.1,-0.375)]),
      PositionInterpolator(DEF='E2Mover',key=[0.0,.99],keyValue=[(-3,-.03,0),(-3,0,0)]),
      PositionInterpolator(DEF='F2Mover',key=[0,.99],keyValue=[(-2.75,-.03,0),(-2.75,0,0)]),
      PositionInterpolator(DEF='Fs2Mover',key=[0.0,.99],keyValue=[(-2.625,0,-.375),(-2.625,0.1,-.375)]),
      PositionInterpolator(DEF='G2Mover',key=[0,.99],keyValue=[(-2.5,-.03,0),(-2.5,0,0)]),
      PositionInterpolator(DEF='Gs2Mover',key=[0.0,.99],keyValue=[(-2.375,0,-.375),(-2.375,.1,-.375)]),
      PositionInterpolator(DEF='A3Mover',key=[0,.99],keyValue=[(-2.25,-.03,0),(-2.25,0,0)]),
      PositionInterpolator(DEF='As3Mover',key=[0.0,.99],keyValue=[(-2.125,0,-.3750),(-2.125,.1,-.375)]),
      PositionInterpolator(DEF='B3Mover',key=[0,.99],keyValue=[(-2,-.03,0),(-2,0,0)]),
      PositionInterpolator(DEF='C3Mover',key=[0,.99],keyValue=[(-1.75,-.03,0),(-1.75,0,0)]),
      PositionInterpolator(DEF='Cs3Mover',key=[0,.99],keyValue=[(-1.625,0,-.375),(-1.625,0.1,-0.375)]),
      PositionInterpolator(DEF='D3Mover',key=[0.0,.99],keyValue=[(-1.5,-.03,0),(-1.5,0,0)]),
      PositionInterpolator(DEF='Ds3Mover',key=[0,.99],keyValue=[(-1.375,0,-.375),(-1.375,0.1,-0.375)]),
      PositionInterpolator(DEF='E3Mover',key=[0.0,.99],keyValue=[(-1.25,-.03,0),(-1.25,0,0)]),
      PositionInterpolator(DEF='F3Mover',key=[0,.99],keyValue=[(-1,-.03,0),(-1,0,0)]),
      PositionInterpolator(DEF='Fs3Mover',key=[0.0,.99],keyValue=[(-.875,0,-.375),(-.875,0.1,-.375)]),
      PositionInterpolator(DEF='G3Mover',key=[0,.99],keyValue=[(-.75,-.03,0),(-.75,0,0)]),
      PositionInterpolator(DEF='Gs3Mover',key=[0.0,.99],keyValue=[(-.625,0,-.375),(-.625,.1,-.375)]),
      PositionInterpolator(DEF='A4Mover',key=[0,.99],keyValue=[(-.5,-.03,0),(-.5,0,0)]),
      PositionInterpolator(DEF='As4Mover',key=[0.0,.99],keyValue=[(-.375,0,-.3750),(-.375,.1,-.375)]),
      PositionInterpolator(DEF='B4Mover',key=[0,.99],keyValue=[(-.25,-.03,0),(-.25,0,0)]),
      PositionInterpolator(DEF='C4Mover',key=[0.0,.99],keyValue=[(0,-.03,0),(0,0,0)]),
      PositionInterpolator(DEF='Cs4Mover',key=[0,.99],keyValue=[(.125,0,-.375),(0.125,0.1,-0.375)]),
      PositionInterpolator(DEF='D4Mover',key=[0.0,.99],keyValue=[(0.25,-.03,0),(0.25,0,0)]),
      PositionInterpolator(DEF='Ds4Mover',key=[0,.99],keyValue=[(.375,0,-.375),(0.375,0.1,-0.375)]),
      PositionInterpolator(DEF='E4Mover',key=[0.0,.99],keyValue=[(0.5,-.03,0),(0.5,0,0)]),
      PositionInterpolator(DEF='F4Mover',key=[0,.99],keyValue=[(.75,-.03,0),(.75,0,0)]),
      PositionInterpolator(DEF='Fs4Mover',key=[0.0,.99],keyValue=[(0.875,0,-.375),(.875,0.1,-.375)]),
      PositionInterpolator(DEF='G4Mover',key=[0,.99],keyValue=[(1,-.03,0),(1,0,0)]),
      PositionInterpolator(DEF='Gs4Mover',key=[0.0,.99],keyValue=[(1.125,0,-.375),(1.125,.1,-.375)]),
      PositionInterpolator(DEF='A5Mover',key=[0,.99],keyValue=[(1.25,-.03,0),(1.25,0,0)]),
      PositionInterpolator(DEF='As5Mover',key=[0.0,.99],keyValue=[(1.375,0,-.3750),(1.375,.1,-.375)]),
      PositionInterpolator(DEF='B5Mover',key=[0,.99],keyValue=[(1.5,-.03,0),(1.5,0,0)]),
      PositionInterpolator(DEF='C5Mover',key=[0,.99],keyValue=[(1.75,-.03,0),(1.75,0,0)]),
      PositionInterpolator(DEF='Cs5Mover',key=[0,.99],keyValue=[(1.875,0,-.375),(1.875,0.1,-0.375)]),
      PositionInterpolator(DEF='D5Mover',key=[0.0,.99],keyValue=[(2,-.03,0),(2,0,0)]),
      PositionInterpolator(DEF='Ds5Mover',key=[0,.99],keyValue=[(2.125,0,-.375),(2.125,0.1,-0.375)]),
      PositionInterpolator(DEF='E5Mover',key=[0.0,.99],keyValue=[(2.25,-.03,0),(2.25,0,0)]),
      PositionInterpolator(DEF='F5Mover',key=[0,.99],keyValue=[(2.5,-.03,0),(2.5,0,0)]),
      PositionInterpolator(DEF='Fs5Mover',key=[0.0,.99],keyValue=[(2.625,0,-.375),(2.625,0.1,-.375)]),
      PositionInterpolator(DEF='G5Mover',key=[0,.99],keyValue=[(2.75,-.03,0),(2.75,0,0)]),
      PositionInterpolator(DEF='Gs5Mover',key=[0.0,.99],keyValue=[(2.875,0,-.375),(2.875,.1,-.375)]),
      PositionInterpolator(DEF='A6Mover',key=[0,.99],keyValue=[(3,-.03,0),(3,0,0)]),
      PositionInterpolator(DEF='As6Mover',key=[0.0,.99],keyValue=[(3.125,0,-.3750),(3.125,.1,-.375)]),
      PositionInterpolator(DEF='B6Mover',key=[0,.99],keyValue=[(3.25,-.03,0),(3.25,0,0)]),
      PositionInterpolator(DEF='C6Mover',key=[0,.99],keyValue=[(3.5,-.03,0),(3.5,0,0)]),
      PositionInterpolator(DEF='Cs6Mover',key=[0,.99],keyValue=[(3.625,0,-.375),(3.625,0.1,-0.375)]),
      PositionInterpolator(DEF='D6Mover',key=[0.0,.99],keyValue=[(3.75,-.03,0),(3.75,0,0)]),
      PositionInterpolator(DEF='Ds6Mover',key=[0,.99],keyValue=[(3.875,0,-.375),(3.875,0.1,-0.375)]),
      PositionInterpolator(DEF='E6Mover',key=[0.0,.99],keyValue=[(4,-.03,0),(4,0,0)]),
      PositionInterpolator(DEF='F6Mover',key=[0,.99],keyValue=[(4.25,-.03,0),(4.25,0,0)]),
      PositionInterpolator(DEF='Fs6Mover',key=[0.0,.99],keyValue=[(4.375,0,-.375),(4.375,0.1,-.375)]),
      PositionInterpolator(DEF='G6Mover',key=[0,.99],keyValue=[(4.5,-.03,0),(4.5,0,0)]),
      PositionInterpolator(DEF='Gs6Mover',key=[0.0,.99],keyValue=[(4.625,0,-.375),(4.625,.1,-.375)]),
      PositionInterpolator(DEF='A7Mover',key=[0,.99],keyValue=[(4.75,-.03,0),(4.75,0,0)]),
      PositionInterpolator(DEF='As7Mover',key=[0.0,.99],keyValue=[(4.875,0,-.3750),(4.875,.1,-.375)]),
      PositionInterpolator(DEF='B7Mover',key=[0,.99],keyValue=[(5,-.03,0),(5,0,0)]),
      PositionInterpolator(DEF='C7Mover',key=[0,.99],keyValue=[(5.25,-.03,0),(5.25,0,0)]),
      PositionInterpolator(DEF='Cs7Mover',key=[0,.99],keyValue=[(5.375,0,-.375),(5.375,0.1,-0.375)]),
      PositionInterpolator(DEF='D7Mover',key=[0.0,.99],keyValue=[(5.5,-.03,0),(5.5,0,0)]),
      PositionInterpolator(DEF='Ds7Mover',key=[0,.99],keyValue=[(5.625,0,-.375),(5.625,0.1,-0.375)]),
      PositionInterpolator(DEF='E7Mover',key=[0.0,.99],keyValue=[(5.75,-.03,0),(5.75,0,0)]),
      PositionInterpolator(DEF='F7Mover',key=[0,.99],keyValue=[(6,-.03,0),(6,0,0)]),
      PositionInterpolator(DEF='Fs7Mover',key=[0.0,.99],keyValue=[(6.125,0,-.375),(6.125,0.1,-.375)]),
      PositionInterpolator(DEF='G7Mover',key=[0,.99],keyValue=[(6.25,-.03,0),(6.25,0,0)]),
      PositionInterpolator(DEF='Gs7Mover',key=[0.0,.99],keyValue=[(6.375,0,-.375),(6.375,.1,-.375)]),
      PositionInterpolator(DEF='A8Mover',key=[0,.99],keyValue=[(6.5,-.03,0),(6.5,0,0)]),
      PositionInterpolator(DEF='As8Mover',key=[0.0,.99],keyValue=[(6.625,0,-.3750),(6.625,.1,-.375)]),
      PositionInterpolator(DEF='B8Mover',key=[0,.99],keyValue=[(6.75,-.03,0),(6.75,0,0)]),
      PositionInterpolator(DEF='C8Mover',key=[0,.99],keyValue=[(7,-.03,0),(7,0,0)]),
      Script(DEF='PlayerPianoScript',
        field=[
        field(accessType='inputOnly',name='playScriptedNotes',type='SFTime'),
        field(accessType='outputOnly',name='playA0',type='SFTime'),
        field(accessType='outputOnly',name='playAs0',type='SFTime'),
        field(accessType='outputOnly',name='playB0',type='SFTime'),
        field(accessType='outputOnly',name='playC0',type='SFTime'),
        field(accessType='outputOnly',name='playCs0',type='SFTime'),
        field(accessType='outputOnly',name='playD0',type='SFTime'),
        field(accessType='outputOnly',name='playDs0',type='SFTime'),
        field(accessType='outputOnly',name='playE0',type='SFTime'),
        field(accessType='outputOnly',name='playF0',type='SFTime'),
        field(accessType='outputOnly',name='playFs0',type='SFTime'),
        field(accessType='outputOnly',name='playG0',type='SFTime'),
        field(accessType='outputOnly',name='playGs0',type='SFTime'),
        field(accessType='outputOnly',name='playA1',type='SFTime'),
        field(accessType='outputOnly',name='playAs1',type='SFTime'),
        field(accessType='outputOnly',name='playB1',type='SFTime'),
        field(accessType='outputOnly',name='playC1',type='SFTime'),
        field(accessType='outputOnly',name='playCs1',type='SFTime'),
        field(accessType='outputOnly',name='playD1',type='SFTime'),
        field(accessType='outputOnly',name='playDs1',type='SFTime'),
        field(accessType='outputOnly',name='playE1',type='SFTime'),
        field(accessType='outputOnly',name='playF1',type='SFTime'),
        field(accessType='outputOnly',name='playFs1',type='SFTime'),
        field(accessType='outputOnly',name='playG1',type='SFTime'),
        field(accessType='outputOnly',name='playGs1',type='SFTime'),
        field(accessType='outputOnly',name='playA2',type='SFTime'),
        field(accessType='outputOnly',name='playAs2',type='SFTime'),
        field(accessType='outputOnly',name='playB2',type='SFTime'),
        field(accessType='outputOnly',name='playC2',type='SFTime'),
        field(accessType='outputOnly',name='playCs2',type='SFTime'),
        field(accessType='outputOnly',name='playD2',type='SFTime'),
        field(accessType='outputOnly',name='playDs2',type='SFTime'),
        field(accessType='outputOnly',name='playE2',type='SFTime'),
        field(accessType='outputOnly',name='playF2',type='SFTime'),
        field(accessType='outputOnly',name='playFs2',type='SFTime'),
        field(accessType='outputOnly',name='playG2',type='SFTime'),
        field(accessType='outputOnly',name='playGs2',type='SFTime'),
        field(accessType='outputOnly',name='playA3',type='SFTime'),
        field(accessType='outputOnly',name='playAs3',type='SFTime'),
        field(accessType='outputOnly',name='playB3',type='SFTime'),
        field(accessType='outputOnly',name='playC3',type='SFTime'),
        field(accessType='outputOnly',name='playCs3',type='SFTime'),
        field(accessType='outputOnly',name='playD3',type='SFTime'),
        field(accessType='outputOnly',name='playDs3',type='SFTime'),
        field(accessType='outputOnly',name='playE3',type='SFTime'),
        field(accessType='outputOnly',name='playF3',type='SFTime'),
        field(accessType='outputOnly',name='playFs3',type='SFTime'),
        field(accessType='outputOnly',name='playG3',type='SFTime'),
        field(accessType='outputOnly',name='playGs3',type='SFTime'),
        field(accessType='outputOnly',name='playA4',type='SFTime'),
        field(accessType='outputOnly',name='playAs4',type='SFTime'),
        field(accessType='outputOnly',name='playB4',type='SFTime'),
        field(accessType='outputOnly',name='playC4',type='SFTime'),
        field(accessType='outputOnly',name='playCs4',type='SFTime'),
        field(accessType='outputOnly',name='playD4',type='SFTime'),
        field(accessType='outputOnly',name='playDs4',type='SFTime'),
        field(accessType='outputOnly',name='playE4',type='SFTime'),
        field(accessType='outputOnly',name='playF4',type='SFTime'),
        field(accessType='outputOnly',name='playFs4',type='SFTime'),
        field(accessType='outputOnly',name='playG4',type='SFTime'),
        field(accessType='outputOnly',name='playGs4',type='SFTime'),
        field(accessType='outputOnly',name='playA5',type='SFTime'),
        field(accessType='outputOnly',name='playAs5',type='SFTime'),
        field(accessType='outputOnly',name='playB5',type='SFTime'),
        field(accessType='outputOnly',name='playC5',type='SFTime'),
        field(accessType='outputOnly',name='playCs5',type='SFTime'),
        field(accessType='outputOnly',name='playD5',type='SFTime'),
        field(accessType='outputOnly',name='playDs5',type='SFTime'),
        field(accessType='outputOnly',name='playE5',type='SFTime'),
        field(accessType='outputOnly',name='playF5',type='SFTime'),
        field(accessType='outputOnly',name='playFs5',type='SFTime'),
        field(accessType='outputOnly',name='playG5',type='SFTime'),
        field(accessType='outputOnly',name='playGs5',type='SFTime'),
        field(accessType='outputOnly',name='playA6',type='SFTime'),
        field(accessType='outputOnly',name='playAs6',type='SFTime'),
        field(accessType='outputOnly',name='playB6',type='SFTime'),
        field(accessType='outputOnly',name='playC6',type='SFTime'),
        field(accessType='outputOnly',name='playCs6',type='SFTime'),
        field(accessType='outputOnly',name='playD6',type='SFTime'),
        field(accessType='outputOnly',name='playDs6',type='SFTime'),
        field(accessType='outputOnly',name='playE6',type='SFTime'),
        field(accessType='outputOnly',name='playF6',type='SFTime'),
        field(accessType='outputOnly',name='playFs6',type='SFTime'),
        field(accessType='outputOnly',name='playG6',type='SFTime'),
        field(accessType='outputOnly',name='playGs6',type='SFTime'),
        field(accessType='outputOnly',name='playA7',type='SFTime'),
        field(accessType='outputOnly',name='playAs7',type='SFTime'),
        field(accessType='outputOnly',name='playB7',type='SFTime'),
        field(accessType='outputOnly',name='playC7',type='SFTime'),
        field(accessType='outputOnly',name='playCs7',type='SFTime'),
        field(accessType='outputOnly',name='playD7',type='SFTime'),
        field(accessType='outputOnly',name='playDs7',type='SFTime'),
        field(accessType='outputOnly',name='playE7',type='SFTime'),
        field(accessType='outputOnly',name='playF7',type='SFTime'),
        field(accessType='outputOnly',name='playFs7',type='SFTime'),
        field(accessType='outputOnly',name='playG7',type='SFTime'),
        field(accessType='outputOnly',name='playGs7',type='SFTime'),
        field(accessType='outputOnly',name='playA8',type='SFTime'),
        field(accessType='outputOnly',name='playAs8',type='SFTime'),
        field(accessType='outputOnly',name='playB8',type='SFTime'),
        field(accessType='outputOnly',name='playC8',type='SFTime')],

      sourceCode="""
ecmascript:

function playScriptedNotes(time, eventTime){

    playC4=eventTime;
  
    playD4=eventTime+1.1;

    playE4=eventTime+2.2;

    playF4=eventTime+3.3;

    playG4=eventTime+4.4;

    playA5=eventTime+5.5;   
}
function hideUnscriptedKeyWarnings ()
{
	playA0=0;
	playAs0=0;
	playB0=0;
	playC0=0;
	playCs0=0;
	playD0=0;
	playDs0=0;
	playE0=0;
	playF0=0;
	playFs0=0;
	playG0=0;
	playGs0=0;
	playA1=0;
	playAs1=0;
	playB1=0;
	playC1=0;
	playCs1=0;
	playD1=0;
	playDs1=0;
	playE1=0;
	playF1=0;
	playFs1=0;
	playG1=0;
	playGs1=0;
	playA2=0;
	playAs2=0;
	playB2=0;
	playC2=0;
	playCs2=0;
	playD2=0;
	playDs2=0;
	playE2=0;
	playF2=0;
	playFs2=0;
	playG2=0;
	playGs2=0;
	playA3=0;
	playAs3=0;
	playB3=0;
	playC3=0;
	playCs3=0;
	playD3=0;
	playDs3=0;
	playE3=0;
	playF3=0;
	playFs3=0;
	playG3=0;
	playGs3=0;
	playA4=0;
	playAs4=0;
	playB4=0;
	playC4=0;
	playCs4=0;
	playD4=0;
	playDs4=0;
	playE4=0;
	playF4=0;
	playFs4=0;
	playG4=0;
	playGs4=0;
	playA5=0;
	playAs5=0;
	playB5=0;
	playC5=0;
	playCs5=0;
	playD5=0;
	playDs5=0;
	playE5=0;
	playF5=0;
	playFs5=0;
	playG5=0;
	playGs5=0;
	playA6=0;
	playAs6=0;
	playB6=0;
	playC6=0;
	playCs6=0;
	playD6=0;
	playDs6=0;
	playE6=0;
	playF6=0;
	playFs6=0;
	playG6=0;
	playGs6=0;
	playA7=0;
	playAs7=0;
	playB7=0;
	playC7=0;
	playCs7=0;
	playD7=0;
	playDs7=0;
	playE7=0;
	playF7=0;
	playFs7=0;
	playG7=0;
	playGs7=0;
	playA8=0;
	playAs8=0;
	playB8=0;
	playC8=0;
}
""")]),
    ROUTE(fromField='touchTime',fromNode='StartPlaying',toField='playScriptedNotes',toNode='PlayerPianoScript'),
    ROUTE(fromField='touchTime',fromNode='A0',toField='set_startTime',toNode='PitchA1'),
    ROUTE(fromField='touchTime',fromNode='As0',toField='set_startTime',toNode='PitchAs1'),
    ROUTE(fromField='touchTime',fromNode='B0',toField='set_startTime',toNode='PitchB1'),
    ROUTE(fromField='touchTime',fromNode='C0',toField='set_startTime',toNode='PitchC1'),
    ROUTE(fromField='touchTime',fromNode='Cs0',toField='set_startTime',toNode='PitchCs1'),
    ROUTE(fromField='touchTime',fromNode='D0',toField='set_startTime',toNode='PitchD1'),
    ROUTE(fromField='touchTime',fromNode='Ds0',toField='set_startTime',toNode='PitchDs1'),
    ROUTE(fromField='touchTime',fromNode='E0',toField='set_startTime',toNode='PitchE1'),
    ROUTE(fromField='touchTime',fromNode='F0',toField='set_startTime',toNode='PitchF1'),
    ROUTE(fromField='touchTime',fromNode='Fs0',toField='set_startTime',toNode='PitchFs1'),
    ROUTE(fromField='touchTime',fromNode='G0',toField='set_startTime',toNode='PitchG1'),
    ROUTE(fromField='touchTime',fromNode='Gs0',toField='set_startTime',toNode='PitchGs1'),
    ROUTE(fromField='touchTime',fromNode='A1',toField='set_startTime',toNode='PitchA1'),
    ROUTE(fromField='touchTime',fromNode='As1',toField='set_startTime',toNode='PitchAs1'),
    ROUTE(fromField='touchTime',fromNode='B1',toField='set_startTime',toNode='PitchB1'),
    ROUTE(fromField='touchTime',fromNode='C1',toField='set_startTime',toNode='PitchC1'),
    ROUTE(fromField='touchTime',fromNode='Cs1',toField='set_startTime',toNode='PitchCs1'),
    ROUTE(fromField='touchTime',fromNode='D1',toField='set_startTime',toNode='PitchD1'),
    ROUTE(fromField='touchTime',fromNode='Ds1',toField='set_startTime',toNode='PitchDs1'),
    ROUTE(fromField='touchTime',fromNode='E1',toField='set_startTime',toNode='PitchE1'),
    ROUTE(fromField='touchTime',fromNode='F1',toField='set_startTime',toNode='PitchF1'),
    ROUTE(fromField='touchTime',fromNode='Fs1',toField='set_startTime',toNode='PitchFs1'),
    ROUTE(fromField='touchTime',fromNode='G1',toField='set_startTime',toNode='PitchG1'),
    ROUTE(fromField='touchTime',fromNode='Gs1',toField='set_startTime',toNode='PitchGs1'),
    ROUTE(fromField='touchTime',fromNode='A2',toField='set_startTime',toNode='PitchA2'),
    ROUTE(fromField='touchTime',fromNode='As2',toField='set_startTime',toNode='PitchAs2'),
    ROUTE(fromField='touchTime',fromNode='B2',toField='set_startTime',toNode='PitchB2'),
    ROUTE(fromField='touchTime',fromNode='C2',toField='set_startTime',toNode='PitchC2'),
    ROUTE(fromField='touchTime',fromNode='Cs2',toField='set_startTime',toNode='PitchCs2'),
    ROUTE(fromField='touchTime',fromNode='D2',toField='set_startTime',toNode='PitchD2'),
    ROUTE(fromField='touchTime',fromNode='Ds2',toField='set_startTime',toNode='PitchDs2'),
    ROUTE(fromField='touchTime',fromNode='E2',toField='set_startTime',toNode='PitchE2'),
    ROUTE(fromField='touchTime',fromNode='F2',toField='set_startTime',toNode='PitchF2'),
    ROUTE(fromField='touchTime',fromNode='Fs2',toField='set_startTime',toNode='PitchFs2'),
    ROUTE(fromField='touchTime',fromNode='G2',toField='set_startTime',toNode='PitchG2'),
    ROUTE(fromField='touchTime',fromNode='Gs2',toField='set_startTime',toNode='PitchGs2'),
    ROUTE(fromField='touchTime',fromNode='A3',toField='set_startTime',toNode='PitchA3'),
    ROUTE(fromField='touchTime',fromNode='As3',toField='set_startTime',toNode='PitchAs3'),
    ROUTE(fromField='touchTime',fromNode='B3',toField='set_startTime',toNode='PitchB3'),
    ROUTE(fromField='touchTime',fromNode='C3',toField='set_startTime',toNode='PitchC3'),
    ROUTE(fromField='touchTime',fromNode='Cs3',toField='set_startTime',toNode='PitchCs3'),
    ROUTE(fromField='touchTime',fromNode='D3',toField='set_startTime',toNode='PitchD3'),
    ROUTE(fromField='touchTime',fromNode='Ds3',toField='set_startTime',toNode='PitchDs3'),
    ROUTE(fromField='touchTime',fromNode='E3',toField='set_startTime',toNode='PitchE3'),
    ROUTE(fromField='touchTime',fromNode='F3',toField='set_startTime',toNode='PitchF3'),
    ROUTE(fromField='touchTime',fromNode='Fs3',toField='set_startTime',toNode='PitchFs3'),
    ROUTE(fromField='touchTime',fromNode='G3',toField='set_startTime',toNode='PitchG3'),
    ROUTE(fromField='touchTime',fromNode='Gs3',toField='set_startTime',toNode='PitchGs3'),
    ROUTE(fromField='touchTime',fromNode='A4',toField='set_startTime',toNode='PitchA4'),
    ROUTE(fromField='touchTime',fromNode='As4',toField='set_startTime',toNode='PitchAs4'),
    ROUTE(fromField='touchTime',fromNode='B4',toField='set_startTime',toNode='PitchB4'),
    ROUTE(fromField='touchTime',fromNode='C4',toField='set_startTime',toNode='PitchC4'),
    ROUTE(fromField='touchTime',fromNode='Cs4',toField='set_startTime',toNode='PitchCs4'),
    ROUTE(fromField='touchTime',fromNode='D4',toField='set_startTime',toNode='PitchD4'),
    ROUTE(fromField='touchTime',fromNode='Ds4',toField='set_startTime',toNode='PitchDs4'),
    ROUTE(fromField='touchTime',fromNode='E4',toField='set_startTime',toNode='PitchE4'),
    ROUTE(fromField='touchTime',fromNode='F4',toField='set_startTime',toNode='PitchF4'),
    ROUTE(fromField='touchTime',fromNode='Fs4',toField='set_startTime',toNode='PitchFs4'),
    ROUTE(fromField='touchTime',fromNode='G4',toField='set_startTime',toNode='PitchG4'),
    ROUTE(fromField='touchTime',fromNode='Gs4',toField='set_startTime',toNode='PitchGs4'),
    ROUTE(fromField='touchTime',fromNode='A5',toField='set_startTime',toNode='PitchA5'),
    ROUTE(fromField='touchTime',fromNode='As5',toField='set_startTime',toNode='PitchAs5'),
    ROUTE(fromField='touchTime',fromNode='B5',toField='set_startTime',toNode='PitchB5'),
    ROUTE(fromField='touchTime',fromNode='C5',toField='set_startTime',toNode='PitchC5'),
    ROUTE(fromField='touchTime',fromNode='Cs5',toField='set_startTime',toNode='PitchCs5'),
    ROUTE(fromField='touchTime',fromNode='D5',toField='set_startTime',toNode='PitchD5'),
    ROUTE(fromField='touchTime',fromNode='Ds5',toField='set_startTime',toNode='PitchDs5'),
    ROUTE(fromField='touchTime',fromNode='E5',toField='set_startTime',toNode='PitchE5'),
    ROUTE(fromField='touchTime',fromNode='F5',toField='set_startTime',toNode='PitchF5'),
    ROUTE(fromField='touchTime',fromNode='Fs5',toField='set_startTime',toNode='PitchFs5'),
    ROUTE(fromField='touchTime',fromNode='G5',toField='set_startTime',toNode='PitchG5'),
    ROUTE(fromField='touchTime',fromNode='Gs5',toField='set_startTime',toNode='PitchGs5'),
    ROUTE(fromField='touchTime',fromNode='A6',toField='set_startTime',toNode='PitchA6'),
    ROUTE(fromField='touchTime',fromNode='As6',toField='set_startTime',toNode='PitchAs6'),
    ROUTE(fromField='touchTime',fromNode='B6',toField='set_startTime',toNode='PitchB6'),
    ROUTE(fromField='touchTime',fromNode='C6',toField='set_startTime',toNode='PitchC6'),
    ROUTE(fromField='touchTime',fromNode='Cs6',toField='set_startTime',toNode='PitchCs6'),
    ROUTE(fromField='touchTime',fromNode='D6',toField='set_startTime',toNode='PitchD6'),
    ROUTE(fromField='touchTime',fromNode='Ds6',toField='set_startTime',toNode='PitchDs6'),
    ROUTE(fromField='touchTime',fromNode='E6',toField='set_startTime',toNode='PitchE6'),
    ROUTE(fromField='touchTime',fromNode='F6',toField='set_startTime',toNode='PitchF6'),
    ROUTE(fromField='touchTime',fromNode='Fs6',toField='set_startTime',toNode='PitchFs6'),
    ROUTE(fromField='touchTime',fromNode='G6',toField='set_startTime',toNode='PitchG6'),
    ROUTE(fromField='touchTime',fromNode='Gs6',toField='set_startTime',toNode='PitchGs6'),
    ROUTE(fromField='touchTime',fromNode='A7',toField='set_startTime',toNode='PitchA7'),
    ROUTE(fromField='touchTime',fromNode='As7',toField='set_startTime',toNode='PitchAs7'),
    ROUTE(fromField='touchTime',fromNode='B7',toField='set_startTime',toNode='PitchB7'),
    ROUTE(fromField='touchTime',fromNode='C7',toField='set_startTime',toNode='PitchC7'),
    ROUTE(fromField='touchTime',fromNode='Cs7',toField='set_startTime',toNode='PitchCs7'),
    ROUTE(fromField='touchTime',fromNode='D7',toField='set_startTime',toNode='PitchD7'),
    ROUTE(fromField='touchTime',fromNode='Ds7',toField='set_startTime',toNode='PitchDs7'),
    ROUTE(fromField='touchTime',fromNode='E7',toField='set_startTime',toNode='PitchE7'),
    ROUTE(fromField='touchTime',fromNode='F7',toField='set_startTime',toNode='PitchF7'),
    ROUTE(fromField='touchTime',fromNode='Fs7',toField='set_startTime',toNode='PitchFs7'),
    ROUTE(fromField='touchTime',fromNode='G7',toField='set_startTime',toNode='PitchG7'),
    ROUTE(fromField='touchTime',fromNode='Gs7',toField='set_startTime',toNode='PitchGs7'),
    ROUTE(fromField='touchTime',fromNode='A8',toField='set_startTime',toNode='PitchA8'),
    ROUTE(fromField='touchTime',fromNode='As8',toField='set_startTime',toNode='PitchAs8'),
    ROUTE(fromField='touchTime',fromNode='B8',toField='set_startTime',toNode='PitchB8'),
    ROUTE(fromField='touchTime',fromNode='C8',toField='set_startTime',toNode='PitchC8'),
    ROUTE(fromField='touchTime',fromNode='A0',toField='set_startTime',toNode='ClockA0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockA0',toField='set_fraction',toNode='A0Mover'),
    ROUTE(fromField='value_changed',fromNode='A0Mover',toField='set_translation',toNode='A0TRANS'),
    ROUTE(fromField='touchTime',fromNode='As0',toField='set_startTime',toNode='ClockAs0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockAs0',toField='set_fraction',toNode='As0Mover'),
    ROUTE(fromField='value_changed',fromNode='As0Mover',toField='set_translation',toNode='As0TRANS'),
    ROUTE(fromField='touchTime',fromNode='B0',toField='set_startTime',toNode='ClockB0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockB0',toField='set_fraction',toNode='B0Mover'),
    ROUTE(fromField='value_changed',fromNode='B0Mover',toField='set_translation',toNode='B0TRANS'),
    ROUTE(fromField='touchTime',fromNode='C0',toField='set_startTime',toNode='ClockC0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockC0',toField='set_fraction',toNode='C0Mover'),
    ROUTE(fromField='value_changed',fromNode='C0Mover',toField='set_translation',toNode='C0TRANS'),
    ROUTE(fromField='touchTime',fromNode='Cs0',toField='set_startTime',toNode='ClockCs0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockCs0',toField='set_fraction',toNode='Cs0Mover'),
    ROUTE(fromField='value_changed',fromNode='Cs0Mover',toField='set_translation',toNode='Cs0TRANS'),
    ROUTE(fromField='touchTime',fromNode='D0',toField='set_startTime',toNode='ClockD0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockD0',toField='set_fraction',toNode='D0Mover'),
    ROUTE(fromField='value_changed',fromNode='D0Mover',toField='set_translation',toNode='D0TRANS'),
    ROUTE(fromField='touchTime',fromNode='Ds0',toField='set_startTime',toNode='ClockDs0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockDs0',toField='set_fraction',toNode='Ds0Mover'),
    ROUTE(fromField='value_changed',fromNode='Ds0Mover',toField='set_translation',toNode='Ds0TRANS'),
    ROUTE(fromField='touchTime',fromNode='E0',toField='set_startTime',toNode='ClockE0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockE0',toField='set_fraction',toNode='E0Mover'),
    ROUTE(fromField='value_changed',fromNode='E0Mover',toField='set_translation',toNode='E0TRANS'),
    ROUTE(fromField='touchTime',fromNode='F0',toField='set_startTime',toNode='ClockF0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockF0',toField='set_fraction',toNode='F0Mover'),
    ROUTE(fromField='value_changed',fromNode='F0Mover',toField='set_translation',toNode='F0TRANS'),
    ROUTE(fromField='touchTime',fromNode='Fs0',toField='set_startTime',toNode='ClockFs0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockFs0',toField='set_fraction',toNode='Fs0Mover'),
    ROUTE(fromField='value_changed',fromNode='Fs0Mover',toField='set_translation',toNode='Fs0TRANS'),
    ROUTE(fromField='touchTime',fromNode='G0',toField='set_startTime',toNode='ClockG0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockG0',toField='set_fraction',toNode='G0Mover'),
    ROUTE(fromField='value_changed',fromNode='G0Mover',toField='set_translation',toNode='G0TRANS'),
    ROUTE(fromField='touchTime',fromNode='Gs0',toField='set_startTime',toNode='ClockGs0'),
    ROUTE(fromField='fraction_changed',fromNode='ClockGs0',toField='set_fraction',toNode='Gs0Mover'),
    ROUTE(fromField='value_changed',fromNode='Gs0Mover',toField='set_translation',toNode='Gs0TRANS'),
    ROUTE(fromField='touchTime',fromNode='A1',toField='set_startTime',toNode='ClockA1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockA1',toField='set_fraction',toNode='A1Mover'),
    ROUTE(fromField='value_changed',fromNode='A1Mover',toField='set_translation',toNode='A1TRANS'),
    ROUTE(fromField='touchTime',fromNode='As1',toField='set_startTime',toNode='ClockAs1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockAs1',toField='set_fraction',toNode='As1Mover'),
    ROUTE(fromField='value_changed',fromNode='As1Mover',toField='set_translation',toNode='As1TRANS'),
    ROUTE(fromField='touchTime',fromNode='B1',toField='set_startTime',toNode='ClockB1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockB1',toField='set_fraction',toNode='B1Mover'),
    ROUTE(fromField='value_changed',fromNode='B1Mover',toField='set_translation',toNode='B1TRANS'),
    ROUTE(fromField='touchTime',fromNode='C1',toField='set_startTime',toNode='ClockC1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockC1',toField='set_fraction',toNode='C1Mover'),
    ROUTE(fromField='value_changed',fromNode='C1Mover',toField='set_translation',toNode='C1TRANS'),
    ROUTE(fromField='touchTime',fromNode='Cs1',toField='set_startTime',toNode='ClockCs1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockCs1',toField='set_fraction',toNode='Cs1Mover'),
    ROUTE(fromField='value_changed',fromNode='Cs1Mover',toField='set_translation',toNode='Cs1TRANS'),
    ROUTE(fromField='touchTime',fromNode='D1',toField='set_startTime',toNode='ClockD1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockD1',toField='set_fraction',toNode='D1Mover'),
    ROUTE(fromField='value_changed',fromNode='D1Mover',toField='set_translation',toNode='D1TRANS'),
    ROUTE(fromField='touchTime',fromNode='Ds1',toField='set_startTime',toNode='ClockDs1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockDs1',toField='set_fraction',toNode='Ds1Mover'),
    ROUTE(fromField='value_changed',fromNode='Ds1Mover',toField='set_translation',toNode='Ds1TRANS'),
    ROUTE(fromField='touchTime',fromNode='E1',toField='set_startTime',toNode='ClockE1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockE1',toField='set_fraction',toNode='E1Mover'),
    ROUTE(fromField='value_changed',fromNode='E1Mover',toField='set_translation',toNode='E1TRANS'),
    ROUTE(fromField='touchTime',fromNode='F1',toField='set_startTime',toNode='ClockF1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockF1',toField='set_fraction',toNode='F1Mover'),
    ROUTE(fromField='value_changed',fromNode='F1Mover',toField='set_translation',toNode='F1TRANS'),
    ROUTE(fromField='touchTime',fromNode='Fs1',toField='set_startTime',toNode='ClockFs1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockFs1',toField='set_fraction',toNode='Fs1Mover'),
    ROUTE(fromField='value_changed',fromNode='Fs1Mover',toField='set_translation',toNode='Fs1TRANS'),
    ROUTE(fromField='touchTime',fromNode='G1',toField='set_startTime',toNode='ClockG1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockG1',toField='set_fraction',toNode='G1Mover'),
    ROUTE(fromField='value_changed',fromNode='G1Mover',toField='set_translation',toNode='G1TRANS'),
    ROUTE(fromField='touchTime',fromNode='Gs1',toField='set_startTime',toNode='ClockGs1'),
    ROUTE(fromField='fraction_changed',fromNode='ClockGs1',toField='set_fraction',toNode='Gs1Mover'),
    ROUTE(fromField='value_changed',fromNode='Gs1Mover',toField='set_translation',toNode='Gs1TRANS'),
    ROUTE(fromField='touchTime',fromNode='A2',toField='set_startTime',toNode='ClockA2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockA2',toField='set_fraction',toNode='A2Mover'),
    ROUTE(fromField='value_changed',fromNode='A2Mover',toField='set_translation',toNode='A2TRANS'),
    ROUTE(fromField='touchTime',fromNode='As2',toField='set_startTime',toNode='ClockAs2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockAs2',toField='set_fraction',toNode='As2Mover'),
    ROUTE(fromField='value_changed',fromNode='As2Mover',toField='set_translation',toNode='As2TRANS'),
    ROUTE(fromField='touchTime',fromNode='B2',toField='set_startTime',toNode='ClockB2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockB2',toField='set_fraction',toNode='B2Mover'),
    ROUTE(fromField='value_changed',fromNode='B2Mover',toField='set_translation',toNode='B2TRANS'),
    ROUTE(fromField='touchTime',fromNode='C2',toField='set_startTime',toNode='ClockC2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockC2',toField='set_fraction',toNode='C2Mover'),
    ROUTE(fromField='value_changed',fromNode='C2Mover',toField='set_translation',toNode='C2TRANS'),
    ROUTE(fromField='touchTime',fromNode='Cs2',toField='set_startTime',toNode='ClockCs2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockCs2',toField='set_fraction',toNode='Cs2Mover'),
    ROUTE(fromField='value_changed',fromNode='Cs2Mover',toField='set_translation',toNode='Cs2TRANS'),
    ROUTE(fromField='touchTime',fromNode='D2',toField='set_startTime',toNode='ClockD2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockD2',toField='set_fraction',toNode='D2Mover'),
    ROUTE(fromField='value_changed',fromNode='D2Mover',toField='set_translation',toNode='D2TRANS'),
    ROUTE(fromField='touchTime',fromNode='Ds2',toField='set_startTime',toNode='ClockDs2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockDs2',toField='set_fraction',toNode='Ds2Mover'),
    ROUTE(fromField='value_changed',fromNode='Ds2Mover',toField='set_translation',toNode='Ds2TRANS'),
    ROUTE(fromField='touchTime',fromNode='E2',toField='set_startTime',toNode='ClockE2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockE2',toField='set_fraction',toNode='E2Mover'),
    ROUTE(fromField='value_changed',fromNode='E2Mover',toField='set_translation',toNode='E2TRANS'),
    ROUTE(fromField='touchTime',fromNode='F2',toField='set_startTime',toNode='ClockF2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockF2',toField='set_fraction',toNode='F2Mover'),
    ROUTE(fromField='value_changed',fromNode='F2Mover',toField='set_translation',toNode='F2TRANS'),
    ROUTE(fromField='touchTime',fromNode='Fs2',toField='set_startTime',toNode='ClockFs2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockFs2',toField='set_fraction',toNode='Fs2Mover'),
    ROUTE(fromField='value_changed',fromNode='Fs2Mover',toField='set_translation',toNode='Fs2TRANS'),
    ROUTE(fromField='touchTime',fromNode='G2',toField='set_startTime',toNode='ClockG2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockG2',toField='set_fraction',toNode='G2Mover'),
    ROUTE(fromField='value_changed',fromNode='G2Mover',toField='set_translation',toNode='G2TRANS'),
    ROUTE(fromField='touchTime',fromNode='Gs2',toField='set_startTime',toNode='ClockGs2'),
    ROUTE(fromField='fraction_changed',fromNode='ClockGs2',toField='set_fraction',toNode='Gs2Mover'),
    ROUTE(fromField='value_changed',fromNode='Gs2Mover',toField='set_translation',toNode='Gs2TRANS'),
    ROUTE(fromField='touchTime',fromNode='A3',toField='set_startTime',toNode='ClockA3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockA3',toField='set_fraction',toNode='A3Mover'),
    ROUTE(fromField='value_changed',fromNode='A3Mover',toField='set_translation',toNode='A3TRANS'),
    ROUTE(fromField='touchTime',fromNode='As3',toField='set_startTime',toNode='ClockAs3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockAs3',toField='set_fraction',toNode='As3Mover'),
    ROUTE(fromField='value_changed',fromNode='As3Mover',toField='set_translation',toNode='As3TRANS'),
    ROUTE(fromField='touchTime',fromNode='B3',toField='set_startTime',toNode='ClockB3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockB3',toField='set_fraction',toNode='B3Mover'),
    ROUTE(fromField='value_changed',fromNode='B3Mover',toField='set_translation',toNode='B3TRANS'),
    ROUTE(fromField='touchTime',fromNode='C3',toField='set_startTime',toNode='ClockC3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockC3',toField='set_fraction',toNode='C3Mover'),
    ROUTE(fromField='value_changed',fromNode='C3Mover',toField='set_translation',toNode='C3TRANS'),
    ROUTE(fromField='touchTime',fromNode='Cs3',toField='set_startTime',toNode='ClockCs3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockCs3',toField='set_fraction',toNode='Cs3Mover'),
    ROUTE(fromField='value_changed',fromNode='Cs3Mover',toField='set_translation',toNode='Cs3TRANS'),
    ROUTE(fromField='touchTime',fromNode='D3',toField='set_startTime',toNode='ClockD3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockD3',toField='set_fraction',toNode='D3Mover'),
    ROUTE(fromField='value_changed',fromNode='D3Mover',toField='set_translation',toNode='D3TRANS'),
    ROUTE(fromField='touchTime',fromNode='Ds3',toField='set_startTime',toNode='ClockDs3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockDs3',toField='set_fraction',toNode='Ds3Mover'),
    ROUTE(fromField='value_changed',fromNode='Ds3Mover',toField='set_translation',toNode='Ds3TRANS'),
    ROUTE(fromField='touchTime',fromNode='E3',toField='set_startTime',toNode='ClockE3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockE3',toField='set_fraction',toNode='E3Mover'),
    ROUTE(fromField='value_changed',fromNode='E3Mover',toField='set_translation',toNode='E3TRANS'),
    ROUTE(fromField='touchTime',fromNode='F3',toField='set_startTime',toNode='ClockF3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockF3',toField='set_fraction',toNode='F3Mover'),
    ROUTE(fromField='value_changed',fromNode='F3Mover',toField='set_translation',toNode='F3TRANS'),
    ROUTE(fromField='touchTime',fromNode='Fs3',toField='set_startTime',toNode='ClockFs3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockFs3',toField='set_fraction',toNode='Fs3Mover'),
    ROUTE(fromField='value_changed',fromNode='Fs3Mover',toField='set_translation',toNode='Fs3TRANS'),
    ROUTE(fromField='touchTime',fromNode='G3',toField='set_startTime',toNode='ClockG3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockG3',toField='set_fraction',toNode='G3Mover'),
    ROUTE(fromField='value_changed',fromNode='G3Mover',toField='set_translation',toNode='G3TRANS'),
    ROUTE(fromField='touchTime',fromNode='Gs3',toField='set_startTime',toNode='ClockGs3'),
    ROUTE(fromField='fraction_changed',fromNode='ClockGs3',toField='set_fraction',toNode='Gs3Mover'),
    ROUTE(fromField='value_changed',fromNode='Gs3Mover',toField='set_translation',toNode='Gs3TRANS'),
    ROUTE(fromField='touchTime',fromNode='A4',toField='set_startTime',toNode='ClockA4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockA4',toField='set_fraction',toNode='A4Mover'),
    ROUTE(fromField='value_changed',fromNode='A4Mover',toField='set_translation',toNode='A4TRANS'),
    ROUTE(fromField='touchTime',fromNode='As4',toField='set_startTime',toNode='ClockAs4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockAs4',toField='set_fraction',toNode='As4Mover'),
    ROUTE(fromField='value_changed',fromNode='As4Mover',toField='set_translation',toNode='As4TRANS'),
    ROUTE(fromField='touchTime',fromNode='B4',toField='set_startTime',toNode='ClockB4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockB4',toField='set_fraction',toNode='B4Mover'),
    ROUTE(fromField='value_changed',fromNode='B4Mover',toField='set_translation',toNode='B4TRANS'),
    ROUTE(fromField='touchTime',fromNode='C4',toField='set_startTime',toNode='ClockC4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockC4',toField='set_fraction',toNode='C4Mover'),
    ROUTE(fromField='value_changed',fromNode='C4Mover',toField='set_translation',toNode='C4TRANS'),
    ROUTE(fromField='touchTime',fromNode='Cs4',toField='set_startTime',toNode='ClockCs4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockCs4',toField='set_fraction',toNode='Cs4Mover'),
    ROUTE(fromField='value_changed',fromNode='Cs4Mover',toField='set_translation',toNode='Cs4TRANS'),
    ROUTE(fromField='touchTime',fromNode='D4',toField='set_startTime',toNode='ClockD4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockD4',toField='set_fraction',toNode='D4Mover'),
    ROUTE(fromField='value_changed',fromNode='D4Mover',toField='set_translation',toNode='D4TRANS'),
    ROUTE(fromField='touchTime',fromNode='Ds4',toField='set_startTime',toNode='ClockDs4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockDs4',toField='set_fraction',toNode='Ds4Mover'),
    ROUTE(fromField='value_changed',fromNode='Ds4Mover',toField='set_translation',toNode='Ds4TRANS'),
    ROUTE(fromField='touchTime',fromNode='E4',toField='set_startTime',toNode='ClockE4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockE4',toField='set_fraction',toNode='E4Mover'),
    ROUTE(fromField='value_changed',fromNode='E4Mover',toField='set_translation',toNode='E4TRANS'),
    ROUTE(fromField='touchTime',fromNode='F4',toField='set_startTime',toNode='ClockF4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockF4',toField='set_fraction',toNode='F4Mover'),
    ROUTE(fromField='value_changed',fromNode='F4Mover',toField='set_translation',toNode='F4TRANS'),
    ROUTE(fromField='touchTime',fromNode='Fs4',toField='set_startTime',toNode='ClockFs4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockFs4',toField='set_fraction',toNode='Fs4Mover'),
    ROUTE(fromField='value_changed',fromNode='Fs4Mover',toField='set_translation',toNode='Fs4TRANS'),
    ROUTE(fromField='touchTime',fromNode='G4',toField='set_startTime',toNode='ClockG4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockG4',toField='set_fraction',toNode='G4Mover'),
    ROUTE(fromField='value_changed',fromNode='G4Mover',toField='set_translation',toNode='G4TRANS'),
    ROUTE(fromField='touchTime',fromNode='Gs4',toField='set_startTime',toNode='ClockGs4'),
    ROUTE(fromField='fraction_changed',fromNode='ClockGs4',toField='set_fraction',toNode='Gs4Mover'),
    ROUTE(fromField='value_changed',fromNode='Gs4Mover',toField='set_translation',toNode='Gs4TRANS'),
    ROUTE(fromField='touchTime',fromNode='A5',toField='set_startTime',toNode='ClockA5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockA5',toField='set_fraction',toNode='A5Mover'),
    ROUTE(fromField='value_changed',fromNode='A5Mover',toField='set_translation',toNode='A5TRANS'),
    ROUTE(fromField='touchTime',fromNode='As5',toField='set_startTime',toNode='ClockAs5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockAs5',toField='set_fraction',toNode='As5Mover'),
    ROUTE(fromField='value_changed',fromNode='As5Mover',toField='set_translation',toNode='As5TRANS'),
    ROUTE(fromField='touchTime',fromNode='B5',toField='set_startTime',toNode='ClockB5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockB5',toField='set_fraction',toNode='B5Mover'),
    ROUTE(fromField='value_changed',fromNode='B5Mover',toField='set_translation',toNode='B5TRANS'),
    ROUTE(fromField='touchTime',fromNode='C5',toField='set_startTime',toNode='ClockC5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockC5',toField='set_fraction',toNode='C5Mover'),
    ROUTE(fromField='value_changed',fromNode='C5Mover',toField='set_translation',toNode='C5TRANS'),
    ROUTE(fromField='touchTime',fromNode='Cs5',toField='set_startTime',toNode='ClockCs5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockCs5',toField='set_fraction',toNode='Cs5Mover'),
    ROUTE(fromField='value_changed',fromNode='Cs5Mover',toField='set_translation',toNode='Cs5TRANS'),
    ROUTE(fromField='touchTime',fromNode='D5',toField='set_startTime',toNode='ClockD5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockD5',toField='set_fraction',toNode='D5Mover'),
    ROUTE(fromField='value_changed',fromNode='D5Mover',toField='set_translation',toNode='D5TRANS'),
    ROUTE(fromField='touchTime',fromNode='Ds5',toField='set_startTime',toNode='ClockDs5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockDs5',toField='set_fraction',toNode='Ds5Mover'),
    ROUTE(fromField='value_changed',fromNode='Ds5Mover',toField='set_translation',toNode='Ds5TRANS'),
    ROUTE(fromField='touchTime',fromNode='E5',toField='set_startTime',toNode='ClockE5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockE5',toField='set_fraction',toNode='E5Mover'),
    ROUTE(fromField='value_changed',fromNode='E5Mover',toField='set_translation',toNode='E5TRANS'),
    ROUTE(fromField='touchTime',fromNode='F5',toField='set_startTime',toNode='ClockF5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockF5',toField='set_fraction',toNode='F5Mover'),
    ROUTE(fromField='value_changed',fromNode='F5Mover',toField='set_translation',toNode='F5TRANS'),
    ROUTE(fromField='touchTime',fromNode='Fs5',toField='set_startTime',toNode='ClockFs5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockFs5',toField='set_fraction',toNode='Fs5Mover'),
    ROUTE(fromField='value_changed',fromNode='Fs5Mover',toField='set_translation',toNode='Fs5TRANS'),
    ROUTE(fromField='touchTime',fromNode='G5',toField='set_startTime',toNode='ClockG5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockG5',toField='set_fraction',toNode='G5Mover'),
    ROUTE(fromField='value_changed',fromNode='G5Mover',toField='set_translation',toNode='G5TRANS'),
    ROUTE(fromField='touchTime',fromNode='Gs5',toField='set_startTime',toNode='ClockGs5'),
    ROUTE(fromField='fraction_changed',fromNode='ClockGs5',toField='set_fraction',toNode='Gs5Mover'),
    ROUTE(fromField='value_changed',fromNode='Gs5Mover',toField='set_translation',toNode='Gs5TRANS'),
    ROUTE(fromField='touchTime',fromNode='A6',toField='set_startTime',toNode='ClockA6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockA6',toField='set_fraction',toNode='A6Mover'),
    ROUTE(fromField='value_changed',fromNode='A6Mover',toField='set_translation',toNode='A6TRANS'),
    ROUTE(fromField='touchTime',fromNode='As6',toField='set_startTime',toNode='ClockAs6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockAs6',toField='set_fraction',toNode='As6Mover'),
    ROUTE(fromField='value_changed',fromNode='As6Mover',toField='set_translation',toNode='As6TRANS'),
    ROUTE(fromField='touchTime',fromNode='B6',toField='set_startTime',toNode='ClockB6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockB6',toField='set_fraction',toNode='B6Mover'),
    ROUTE(fromField='value_changed',fromNode='B6Mover',toField='set_translation',toNode='B6TRANS'),
    ROUTE(fromField='touchTime',fromNode='C6',toField='set_startTime',toNode='ClockC6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockC6',toField='set_fraction',toNode='C6Mover'),
    ROUTE(fromField='value_changed',fromNode='C6Mover',toField='set_translation',toNode='C6TRANS'),
    ROUTE(fromField='touchTime',fromNode='Cs6',toField='set_startTime',toNode='ClockCs6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockCs6',toField='set_fraction',toNode='Cs6Mover'),
    ROUTE(fromField='value_changed',fromNode='Cs6Mover',toField='set_translation',toNode='Cs6TRANS'),
    ROUTE(fromField='touchTime',fromNode='D6',toField='set_startTime',toNode='ClockD6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockD6',toField='set_fraction',toNode='D6Mover'),
    ROUTE(fromField='value_changed',fromNode='D6Mover',toField='set_translation',toNode='D6TRANS'),
    ROUTE(fromField='touchTime',fromNode='Ds6',toField='set_startTime',toNode='ClockDs6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockDs6',toField='set_fraction',toNode='Ds6Mover'),
    ROUTE(fromField='value_changed',fromNode='Ds6Mover',toField='set_translation',toNode='Ds6TRANS'),
    ROUTE(fromField='touchTime',fromNode='E6',toField='set_startTime',toNode='ClockE6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockE6',toField='set_fraction',toNode='E6Mover'),
    ROUTE(fromField='value_changed',fromNode='E6Mover',toField='set_translation',toNode='E6TRANS'),
    ROUTE(fromField='touchTime',fromNode='F6',toField='set_startTime',toNode='ClockF6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockF6',toField='set_fraction',toNode='F6Mover'),
    ROUTE(fromField='value_changed',fromNode='F6Mover',toField='set_translation',toNode='F6TRANS'),
    ROUTE(fromField='touchTime',fromNode='Fs6',toField='set_startTime',toNode='ClockFs6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockFs6',toField='set_fraction',toNode='Fs6Mover'),
    ROUTE(fromField='value_changed',fromNode='Fs6Mover',toField='set_translation',toNode='Fs6TRANS'),
    ROUTE(fromField='touchTime',fromNode='G6',toField='set_startTime',toNode='ClockG6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockG6',toField='set_fraction',toNode='G6Mover'),
    ROUTE(fromField='value_changed',fromNode='G6Mover',toField='set_translation',toNode='G6TRANS'),
    ROUTE(fromField='touchTime',fromNode='Gs6',toField='set_startTime',toNode='ClockGs6'),
    ROUTE(fromField='fraction_changed',fromNode='ClockGs6',toField='set_fraction',toNode='Gs6Mover'),
    ROUTE(fromField='value_changed',fromNode='Gs6Mover',toField='set_translation',toNode='Gs6TRANS'),
    ROUTE(fromField='touchTime',fromNode='A7',toField='set_startTime',toNode='ClockA7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockA7',toField='set_fraction',toNode='A7Mover'),
    ROUTE(fromField='value_changed',fromNode='A7Mover',toField='set_translation',toNode='A7TRANS'),
    ROUTE(fromField='touchTime',fromNode='As7',toField='set_startTime',toNode='ClockAs7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockAs7',toField='set_fraction',toNode='As7Mover'),
    ROUTE(fromField='value_changed',fromNode='As7Mover',toField='set_translation',toNode='As7TRANS'),
    ROUTE(fromField='touchTime',fromNode='B7',toField='set_startTime',toNode='ClockB7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockB7',toField='set_fraction',toNode='B7Mover'),
    ROUTE(fromField='value_changed',fromNode='B7Mover',toField='set_translation',toNode='B7TRANS'),
    ROUTE(fromField='touchTime',fromNode='C7',toField='set_startTime',toNode='ClockC7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockC7',toField='set_fraction',toNode='C7Mover'),
    ROUTE(fromField='value_changed',fromNode='C7Mover',toField='set_translation',toNode='C7TRANS'),
    ROUTE(fromField='touchTime',fromNode='Cs7',toField='set_startTime',toNode='ClockCs7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockCs7',toField='set_fraction',toNode='Cs7Mover'),
    ROUTE(fromField='value_changed',fromNode='Cs7Mover',toField='set_translation',toNode='Cs7TRANS'),
    ROUTE(fromField='touchTime',fromNode='D7',toField='set_startTime',toNode='ClockD7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockD7',toField='set_fraction',toNode='D7Mover'),
    ROUTE(fromField='value_changed',fromNode='D7Mover',toField='set_translation',toNode='D7TRANS'),
    ROUTE(fromField='touchTime',fromNode='Ds7',toField='set_startTime',toNode='ClockDs7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockDs7',toField='set_fraction',toNode='Ds7Mover'),
    ROUTE(fromField='value_changed',fromNode='Ds7Mover',toField='set_translation',toNode='Ds7TRANS'),
    ROUTE(fromField='touchTime',fromNode='E7',toField='set_startTime',toNode='ClockE7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockE7',toField='set_fraction',toNode='E7Mover'),
    ROUTE(fromField='value_changed',fromNode='E7Mover',toField='set_translation',toNode='E7TRANS'),
    ROUTE(fromField='touchTime',fromNode='F7',toField='set_startTime',toNode='ClockF7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockF7',toField='set_fraction',toNode='F7Mover'),
    ROUTE(fromField='value_changed',fromNode='F7Mover',toField='set_translation',toNode='F7TRANS'),
    ROUTE(fromField='touchTime',fromNode='Fs7',toField='set_startTime',toNode='ClockFs7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockFs7',toField='set_fraction',toNode='Fs7Mover'),
    ROUTE(fromField='value_changed',fromNode='Fs7Mover',toField='set_translation',toNode='Fs7TRANS'),
    ROUTE(fromField='touchTime',fromNode='G7',toField='set_startTime',toNode='ClockG7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockG7',toField='set_fraction',toNode='G7Mover'),
    ROUTE(fromField='value_changed',fromNode='G7Mover',toField='set_translation',toNode='G7TRANS'),
    ROUTE(fromField='touchTime',fromNode='Gs7',toField='set_startTime',toNode='ClockGs7'),
    ROUTE(fromField='fraction_changed',fromNode='ClockGs7',toField='set_fraction',toNode='Gs7Mover'),
    ROUTE(fromField='value_changed',fromNode='Gs7Mover',toField='set_translation',toNode='Gs7TRANS'),
    ROUTE(fromField='touchTime',fromNode='A8',toField='set_startTime',toNode='ClockA8'),
    ROUTE(fromField='fraction_changed',fromNode='ClockA8',toField='set_fraction',toNode='A8Mover'),
    ROUTE(fromField='value_changed',fromNode='A8Mover',toField='set_translation',toNode='A8TRANS'),
    ROUTE(fromField='touchTime',fromNode='As8',toField='set_startTime',toNode='ClockAs8'),
    ROUTE(fromField='fraction_changed',fromNode='ClockAs8',toField='set_fraction',toNode='As8Mover'),
    ROUTE(fromField='value_changed',fromNode='As8Mover',toField='set_translation',toNode='As8TRANS'),
    ROUTE(fromField='touchTime',fromNode='B8',toField='set_startTime',toNode='ClockB8'),
    ROUTE(fromField='fraction_changed',fromNode='ClockB8',toField='set_fraction',toNode='B8Mover'),
    ROUTE(fromField='value_changed',fromNode='B8Mover',toField='set_translation',toNode='B8TRANS'),
    ROUTE(fromField='touchTime',fromNode='C8',toField='set_startTime',toNode='ClockC8'),
    ROUTE(fromField='fraction_changed',fromNode='ClockC8',toField='set_fraction',toNode='C8Mover'),
    ROUTE(fromField='value_changed',fromNode='C8Mover',toField='set_translation',toNode='C8TRANS'),
    ROUTE(fromField='playA0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchA0'),
    ROUTE(fromField='playA0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockA0'),
    ROUTE(fromField='playAs0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchAs0'),
    ROUTE(fromField='playAs0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockAs0'),
    ROUTE(fromField='playB0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchB0'),
    ROUTE(fromField='playB0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockB0'),
    ROUTE(fromField='playC0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchC0'),
    ROUTE(fromField='playC0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockC0'),
    ROUTE(fromField='playCs0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchCs0'),
    ROUTE(fromField='playCs0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockCs0'),
    ROUTE(fromField='playD0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchD0'),
    ROUTE(fromField='playD0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockD0'),
    ROUTE(fromField='playDs0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchDs0'),
    ROUTE(fromField='playDs0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockDs0'),
    ROUTE(fromField='playE0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchE0'),
    ROUTE(fromField='playE0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockE0'),
    ROUTE(fromField='playF0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchF0'),
    ROUTE(fromField='playF0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockF0'),
    ROUTE(fromField='playFs0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchFs0'),
    ROUTE(fromField='playFs0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockFs0'),
    ROUTE(fromField='playG0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchG0'),
    ROUTE(fromField='playG0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockG0'),
    ROUTE(fromField='playGs0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchGs0'),
    ROUTE(fromField='playGs0',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockGs0'),
    ROUTE(fromField='playA1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchA1'),
    ROUTE(fromField='playA1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockA1'),
    ROUTE(fromField='playAs1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchAs1'),
    ROUTE(fromField='playAs1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockAs1'),
    ROUTE(fromField='playB1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchB1'),
    ROUTE(fromField='playB1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockB1'),
    ROUTE(fromField='playC1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchC1'),
    ROUTE(fromField='playC1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockC1'),
    ROUTE(fromField='playCs1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchCs1'),
    ROUTE(fromField='playCs1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockCs1'),
    ROUTE(fromField='playD1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchD1'),
    ROUTE(fromField='playD1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockD1'),
    ROUTE(fromField='playDs1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchDs1'),
    ROUTE(fromField='playDs1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockDs1'),
    ROUTE(fromField='playE1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchE1'),
    ROUTE(fromField='playE1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockE1'),
    ROUTE(fromField='playF1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchF1'),
    ROUTE(fromField='playF1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockF1'),
    ROUTE(fromField='playFs1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchFs1'),
    ROUTE(fromField='playFs1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockFs1'),
    ROUTE(fromField='playG1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchG1'),
    ROUTE(fromField='playG1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockG1'),
    ROUTE(fromField='playGs1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchGs1'),
    ROUTE(fromField='playGs1',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockGs1'),
    ROUTE(fromField='playA2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchA2'),
    ROUTE(fromField='playA2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockA2'),
    ROUTE(fromField='playAs2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchAs2'),
    ROUTE(fromField='playAs2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockAs2'),
    ROUTE(fromField='playB2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchB2'),
    ROUTE(fromField='playB2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockB2'),
    ROUTE(fromField='playC2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchC2'),
    ROUTE(fromField='playC2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockC2'),
    ROUTE(fromField='playCs2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchCs2'),
    ROUTE(fromField='playCs2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockCs2'),
    ROUTE(fromField='playD2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchD2'),
    ROUTE(fromField='playD2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockD2'),
    ROUTE(fromField='playDs2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchDs2'),
    ROUTE(fromField='playDs2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockDs2'),
    ROUTE(fromField='playE2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchE2'),
    ROUTE(fromField='playE2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockE2'),
    ROUTE(fromField='playF2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchF2'),
    ROUTE(fromField='playF2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockF2'),
    ROUTE(fromField='playFs2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchFs2'),
    ROUTE(fromField='playFs2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockFs2'),
    ROUTE(fromField='playG2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchG2'),
    ROUTE(fromField='playG2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockG2'),
    ROUTE(fromField='playGs2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchGs2'),
    ROUTE(fromField='playGs2',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockGs2'),
    ROUTE(fromField='playA3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchA3'),
    ROUTE(fromField='playA3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockA3'),
    ROUTE(fromField='playAs3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchAs3'),
    ROUTE(fromField='playAs3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockAs3'),
    ROUTE(fromField='playB3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchB3'),
    ROUTE(fromField='playB3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockB3'),
    ROUTE(fromField='playC3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchC3'),
    ROUTE(fromField='playC3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockC3'),
    ROUTE(fromField='playCs3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchCs3'),
    ROUTE(fromField='playCs3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockCs3'),
    ROUTE(fromField='playD3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchD3'),
    ROUTE(fromField='playD3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockD3'),
    ROUTE(fromField='playDs3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchDs3'),
    ROUTE(fromField='playDs3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockDs3'),
    ROUTE(fromField='playE3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchE3'),
    ROUTE(fromField='playE3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockE3'),
    ROUTE(fromField='playF3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchF3'),
    ROUTE(fromField='playF3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockF3'),
    ROUTE(fromField='playFs3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchFs3'),
    ROUTE(fromField='playFs3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockFs3'),
    ROUTE(fromField='playG3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchG3'),
    ROUTE(fromField='playG3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockG3'),
    ROUTE(fromField='playGs3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchGs3'),
    ROUTE(fromField='playGs3',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockGs3'),
    ROUTE(fromField='playA4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchA4'),
    ROUTE(fromField='playA4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockA4'),
    ROUTE(fromField='playAs4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchAs4'),
    ROUTE(fromField='playAs4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockAs4'),
    ROUTE(fromField='playB4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchB4'),
    ROUTE(fromField='playB4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockB4'),
    ROUTE(fromField='playC4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchC4'),
    ROUTE(fromField='playC4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockC4'),
    ROUTE(fromField='playCs4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchCs4'),
    ROUTE(fromField='playCs4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockCs4'),
    ROUTE(fromField='playD4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchD4'),
    ROUTE(fromField='playD4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockD4'),
    ROUTE(fromField='playDs4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchDs4'),
    ROUTE(fromField='playDs4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockDs4'),
    ROUTE(fromField='playE4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchE4'),
    ROUTE(fromField='playE4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockE4'),
    ROUTE(fromField='playF4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchF4'),
    ROUTE(fromField='playF4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockF4'),
    ROUTE(fromField='playFs4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchFs4'),
    ROUTE(fromField='playFs4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockFs4'),
    ROUTE(fromField='playG4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchG4'),
    ROUTE(fromField='playG4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockG4'),
    ROUTE(fromField='playGs4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchGs4'),
    ROUTE(fromField='playGs4',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockGs4'),
    ROUTE(fromField='playB5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockB5'),
    ROUTE(fromField='playC5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchC5'),
    ROUTE(fromField='playC5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockC5'),
    ROUTE(fromField='playCs5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchCs5'),
    ROUTE(fromField='playCs5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockCs5'),
    ROUTE(fromField='playD5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchD5'),
    ROUTE(fromField='playD5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockD5'),
    ROUTE(fromField='playDs5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchDs5'),
    ROUTE(fromField='playDs5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockDs5'),
    ROUTE(fromField='playE5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchE5'),
    ROUTE(fromField='playE5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockE5'),
    ROUTE(fromField='playF5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchF5'),
    ROUTE(fromField='playF5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockF5'),
    ROUTE(fromField='playFs5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchFs5'),
    ROUTE(fromField='playFs5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockFs5'),
    ROUTE(fromField='playG5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchG5'),
    ROUTE(fromField='playG5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockG5'),
    ROUTE(fromField='playGs5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchGs5'),
    ROUTE(fromField='playGs5',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockGs5'),
    ROUTE(fromField='playA6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchA6'),
    ROUTE(fromField='playA6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockA6'),
    ROUTE(fromField='playAs6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchAs6'),
    ROUTE(fromField='playAs6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockAs6'),
    ROUTE(fromField='playB6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchB6'),
    ROUTE(fromField='playB6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockB6'),
    ROUTE(fromField='playC6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchC6'),
    ROUTE(fromField='playC6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockC6'),
    ROUTE(fromField='playCs6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchCs6'),
    ROUTE(fromField='playCs6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockCs6'),
    ROUTE(fromField='playD6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchD6'),
    ROUTE(fromField='playD6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockD6'),
    ROUTE(fromField='playDs6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchDs6'),
    ROUTE(fromField='playDs6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockDs6'),
    ROUTE(fromField='playE6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchE6'),
    ROUTE(fromField='playE6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockE6'),
    ROUTE(fromField='playF6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchF6'),
    ROUTE(fromField='playF6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockF6'),
    ROUTE(fromField='playFs6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchFs6'),
    ROUTE(fromField='playFs6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockFs6'),
    ROUTE(fromField='playG6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchG6'),
    ROUTE(fromField='playG6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockG6'),
    ROUTE(fromField='playGs6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchGs6'),
    ROUTE(fromField='playGs6',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockGs6'),
    ROUTE(fromField='playA7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchA7'),
    ROUTE(fromField='playA7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockA7'),
    ROUTE(fromField='playAs7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchAs7'),
    ROUTE(fromField='playAs7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockAs7'),
    ROUTE(fromField='playB7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchB7'),
    ROUTE(fromField='playB7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockB7'),
    ROUTE(fromField='playC7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchC7'),
    ROUTE(fromField='playC7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockC7'),
    ROUTE(fromField='playCs7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchCs7'),
    ROUTE(fromField='playCs7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockCs7'),
    ROUTE(fromField='playD7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchD7'),
    ROUTE(fromField='playD7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockD7'),
    ROUTE(fromField='playDs7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchDs7'),
    ROUTE(fromField='playDs7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockDs7'),
    ROUTE(fromField='playE7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchE7'),
    ROUTE(fromField='playE7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockE7'),
    ROUTE(fromField='playF7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchF7'),
    ROUTE(fromField='playF7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockF7'),
    ROUTE(fromField='playFs7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchFs7'),
    ROUTE(fromField='playFs7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockFs7'),
    ROUTE(fromField='playG7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchG7'),
    ROUTE(fromField='playG7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockG7'),
    ROUTE(fromField='playGs7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchGs7'),
    ROUTE(fromField='playGs7',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockGs7'),
    ROUTE(fromField='playA8',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchA8'),
    ROUTE(fromField='playA8',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockA8'),
    ROUTE(fromField='playAs8',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchAs8'),
    ROUTE(fromField='playAs8',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockAs8'),
    ROUTE(fromField='playB8',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchB8'),
    ROUTE(fromField='playB8',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockB8'),
    ROUTE(fromField='playC8',fromNode='PlayerPianoScript',toField='set_startTime',toNode='PitchC8'),
    ROUTE(fromField='playC8',fromNode='PlayerPianoScript',toField='set_startTime',toNode='ClockC8')])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for KeyboardEightyEightKeys.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python KeyboardEightyEightKeys.py load and self-test diagnostics complete.")
