package Basic.StudentProjects;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Sound.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Eight-eight key keyboard, extrapolated from VRML Sourcebook Figure 24.4, including animation of key movements coordinated with sounding of key when touched. </p>
 <p> Related links: Catalog page <a href="../../../StudentProjects/KeyboardEightyEightKeysIndex.html" target="_blank">KeyboardEightyEightKeys</a>,  source <a href="../../../StudentProjects/KeyboardEightyEightKeys.java">KeyboardEightyEightKeys.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../StudentProjects/KeyboardEightyEightKeys.x3d">KeyboardEightyEightKeys.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Eight-eight key keyboard, extrapolated from VRML Sourcebook Figure 24.4, including animation of key movements coordinated with sounding of key when touched. </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Not all tones work (hardware, operating system dependent?) and so may need some higher-frequency sound files. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> TODO </i> </td>
			<td> X3D Specification Comment: pitch attribute might be better on Sound node, thus avoiding need for AudioClip to reload the same audio file multiple times </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Scott Gilman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 27 August 2004 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 14 July 2023 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/Figure24.4FourKeyKeyboard.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/Figure24.4FourKeyKeyboard.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/KeyboardEightyEightKeys.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/KeyboardEightyEightKeys.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Figure 24.4, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../StudentProjects/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Scott Gilman
 */

public class KeyboardEightyEightKeys
{
	/** Default constructor to create this object. */
	public KeyboardEightyEightKeys ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("KeyboardEightyEightKeys.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Eight-eight key keyboard, extrapolated from VRML Sourcebook Figure 24.4, including animation of key movements coordinated with sounding of key when touched."))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("Not all tones work (hardware, operating system dependent?) and so may need some higher-frequency sound files."))
    .addMeta(new meta().setName(meta.NAME_TODO       ).setContent("X3D Specification Comment: pitch attribute might be better on Sound node, thus avoiding need for AudioClip to reload the same audio file multiple times"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Scott Gilman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("27 August 2004"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("14 July 2023"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/Figure24.4FourKeyKeyboard.x3d"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/KeyboardEightyEightKeys.x3d"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("Figure 24.4, The VRML 2.0 Sourcebook, Copyright [1997] By Andrea L. Ames, David R. Nadeau, and John L. Moreland"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("KeyboardEightyEightKeys.x3d"))
    .addChild(new DirectionalLight("LightFromAbove").setDirection(0.0,-1.0,-0.2))
    .addChild(new Viewpoint().setDescription("Middle C, C#, D, D#").setOrientation(1.0,0.0,0.0,-0.758).setPosition(0.0,2.0,2.0))
    .addChild(new Viewpoint("RightSide").setDescription("From right end of keyboard").setOrientation(-.238,.939,.25,1.6349).setPosition(15.5,8.5,-.2))
    .addChild(new Viewpoint("FrontFar").setDescription("Looking down from a distance").setOrientation(-1.0,.007,-.004,.6661).setPosition(.3,11.0,13.7))
    .addChild(new Viewpoint("LeftSide").setDescription("From left end of keyboard").setOrientation(-.252,-.932,-.261,1.636).setPosition(-15.9,9.6,-.1))
    .addChild(new Viewpoint("TopDown").setDescription("Looking down from above middle C").setOrientation(-1.0,-.024,.007,1.5504).setPosition(-1.0,15.4,.3))
    .addChild(new Viewpoint("TopDownCloser").setDescription("Top-down view, closer").setOrientation(-1.0,-.005,-.008,1.1528).setPosition(-.6,7.1,3.1))
    .addChild(new Group()
      .addChild(new Transform("A0TRANS").setTranslation(-7.5,0.0,0.0)
        .addChild(new Shape("WhiteKey")
          .setGeometry(new Box().setSize(0.23,0.1,1.5))
          .setAppearance(new Appearance("IvoryWhite")
            .addComments(" https://en.wikipedia.org/wiki/Shades_of_white#Ivory ")
            .setMaterial(new Material().setDiffuseColor(1.0,1.0,0.941176))))
        .addChild(new TouchSensor("A0").setDescription("play Pitch A0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchA0").setDescription("playing Pitch A0").setPitch(0.053).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("As0TRANS").setTranslation(-7.375,0.1,-.375)
        .addChild(new Shape("BlackKey")
          .setGeometry(new Box().setSize(0.23,0.1,1.5))
          .setAppearance(new Appearance()
            .setMaterial(new Material().setDiffuseColor(0.1,0.1,0.1))))
        .addChild(new TouchSensor("As0").setDescription("play Pitch As0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchAs0").setDescription("playing Pitch As0").setPitch(.056).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("B0TRANS").setTranslation(-7.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("B0").setDescription("play Pitch B0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchB0").setDescription("playing Pitch B0").setPitch(.059).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("C0TRANS").setTranslation(-7.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("C0").setDescription("play Pitch C0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchC0").setDescription("playing Pitch C0").setPitch(.062).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Cs0TRANS").setTranslation(-6.875,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Cs0").setDescription("play Pitch Cs1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchCs0").setDescription("playing Pitch Cs0").setPitch(.066).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("D0TRANS").setTranslation(-6.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("D0").setDescription("play Pitch D0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchD0").setDescription("playing Pitch D0").setPitch(.070).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Ds0TRANS").setTranslation(-6.625,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Ds0").setDescription("play Pitch Ds0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchDs0").setDescription("playing Pitch Ds0").setPitch(.074).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("E0TRANS").setTranslation(-6.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("E0").setDescription("play Pitch E0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchE0").setDescription("playing Pitch E0").setPitch(.079).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("F0TRANS").setTranslation(-6.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("F0").setDescription("play Pitch F0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchF0").setDescription("playing Pitch F0").setPitch(.083).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Fs0TRANS").setTranslation(-6.125,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Fs0").setDescription("play Pitch Fs0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchFs0").setDescription("playing Pitch Fs0").setPitch(.088).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("G0TRANS").setTranslation(-6.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("G0").setDescription("play Pitch G0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchG0").setDescription("playing Pitch G0").setPitch(.094).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Gs0TRANS").setTranslation(-5.875,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Gs0").setDescription("play Pitch Gs0"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchGs0").setDescription("playing Pitch Gs0").setPitch(.099).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("A1TRANS").setTranslation(-5.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("A1").setDescription("play Pitch A1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchA1").setDescription("playing Pitch A1").setPitch(.105).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("As1TRANS").setTranslation(-5.625,0.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("As1").setDescription("play Pitch As1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchAs1").setDescription("playing Pitch As1").setPitch(.111).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("B1TRANS").setTranslation(-5.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("B1").setDescription("play Pitch B1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchB1").setDescription("playing Pitch B1").setPitch(.118).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("C1TRANS").setTranslation(-5.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("C1").setDescription("play Pitch C1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchC1").setDescription("playing Pitch C1").setPitch(.125).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Cs1TRANS").setTranslation(-5.125,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Cs1").setDescription("play Pitch Cs1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchCs1").setDescription("playing Pitch Cs1").setPitch(.132).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("D1TRANS").setTranslation(-5.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("D1").setDescription("play Pitch D1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchD1").setDescription("playing Pitch D1").setPitch(.140).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Ds1TRANS").setTranslation(-4.875,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Ds1").setDescription("play Pitch Ds1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchDs1").setDescription("playing Pitch Ds1").setPitch(.149).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("E1TRANS").setTranslation(-4.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("E1").setDescription("play Pitch E1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchE1").setDescription("playing Pitch E1").setPitch(.157).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("F1TRANS").setTranslation(-4.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("F1").setDescription("play Pitch F1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchF1").setDescription("playing Pitch F1").setPitch(.167).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Fs1TRANS").setTranslation(-4.375,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Fs1").setDescription("play Pitch Fs1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchFs1").setDescription("playing Pitch Fs1").setPitch(.177).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("G1TRANS").setTranslation(-4.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("G1").setDescription("play Pitch G1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchG1").setDescription("playing Pitch G1").setPitch(.187).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Gs1TRANS").setTranslation(-4.125,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Gs1").setDescription("play Pitch Gs1"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchGs1").setDescription("playing Pitch Gs1").setPitch(.198).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("A2TRANS").setTranslation(-4.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("A2").setDescription("play Pitch A2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchA2").setDescription("playing Pitch A2").setPitch(.210).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("As2TRANS").setTranslation(-3.875,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("As2").setDescription("play Pitch As2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchAs2").setDescription("playing Pitch As2").setPitch(.223).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("B2TRANS").setTranslation(-3.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("B2").setDescription("play Pitch B2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchB2").setDescription("playing Pitch B2").setPitch(.236).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("C2TRANS").setTranslation(-3.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("C2").setDescription("play Pitch C2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchC2").setDescription("playing Pitch C2").setPitch(.250).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Cs2TRANS").setTranslation(-3.375,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Cs2").setDescription("play Pitch Cs2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchCs2").setDescription("playing Pitch Cs2").setPitch(.265).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("D2TRANS").setTranslation(-3.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("D2").setDescription("play Pitch D2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchD2").setDescription("playing Pitch D2").setPitch(.281).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Ds2TRANS").setTranslation(-3.125,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Ds2").setDescription("play Pitch Ds2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchDs2").setDescription("playing Pitch Ds2").setPitch(.297).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("E2TRANS").setTranslation(-3.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("E2").setDescription("play Pitch E2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchE2").setDescription("playing Pitch E2").setPitch(.315).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("F2TRANS").setTranslation(-2.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("F2").setDescription("play pitch F2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchF2").setDescription("playing Pitch F2").setPitch(.334).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Fs2TRANS").setTranslation(-2.625,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Fs2").setDescription("play pitch Fs2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchFs2").setDescription("playing Pitch Fs2").setPitch(.354).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("G2TRANS").setTranslation(-2.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("G2").setDescription("play pitch G2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchG2").setDescription("playing Pitch G2").setPitch(.375).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Gs2TRANS").setTranslation(-2.375,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Gs2").setDescription("play pitch Gs2"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchGs2").setDescription("playing Pitch Gs2").setPitch(.397).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("A3TRANS").setTranslation(-2.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("A3").setDescription("play pitch A3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchA3").setDescription("playing Pitch A3").setPitch(.420).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("As3TRANS").setTranslation(-2.125,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("As3").setDescription("play pitch As3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchAs3").setDescription("playing Pitch As3").setPitch(.445).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("B3TRANS").setTranslation(-2.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("B3").setDescription("play pitch B3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchB3").setDescription("playing Pitch B3").setPitch(.472).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("C3TRANS").setTranslation(-1.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("C3").setDescription("play pitch C3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchC3").setDescription("playing Pitch C3").setPitch(.500).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Cs3TRANS").setTranslation(-1.625,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Cs3").setDescription("play pitch Cs3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchCs3").setDescription("playing Pitch Cs3").setPitch(.530).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("D3TRANS").setTranslation(-1.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("D3").setDescription("play pitch D3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchD3").setDescription("playing Pitch D3").setPitch(.561).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Ds3TRANS").setTranslation(-1.375,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Ds3").setDescription("play pitch Ds3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchDs3").setDescription("playing Pitch Ds3").setPitch(.595).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("E3TRANS").setTranslation(-1.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("E3").setDescription("play pitch E3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchE3").setDescription("playing Pitch E3").setPitch(.630).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("F3TRANS").setTranslation(-1.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("F3").setDescription("play pitch F3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchF3").setDescription("playing Pitch F3").setPitch(.667).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Fs3TRANS").setTranslation(-.875,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Fs3").setDescription("play pitch Fs3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchFs3").setDescription("playing Pitch Fs3").setPitch(.707).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("G3TRANS").setTranslation(-.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("G3").setDescription("play pitch G3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchG3").setDescription("playing Pitch G3").setPitch(.749).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Gs3TRANS").setTranslation(-.625,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Gs3").setDescription("play pitch Gs3"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchGs3").setDescription("playing Pitch Gs3").setPitch(.794).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("A4TRANS").setTranslation(-.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("A4").setDescription("play pitch A4"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchA4").setDescription("playing Pitch A4").setPitch(.841).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("As4TRANS").setTranslation(-.375,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("As4").setDescription("play pitch As4"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchAs4").setDescription("playing Pitch As4").setPitch(.891).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("B4TRANS").setTranslation(-.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("B4").setDescription("play pitch B4"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchB4").setDescription("playing Pitch B4").setPitch(.944).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("C4TRANS")
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("C4").setDescription("play pitch C4"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchC4").setDescription("playing Pitch C4").setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Cs4TRANS").setTranslation(0.125,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Cs4").setDescription("play pitch Csharp4"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchCs4").setDescription("playing Pitch Cs4").setPitch(1.059).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("D4TRANS").setTranslation(0.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("D4").setDescription("play pitch D4"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchD4").setDescription("playing Pitch D4").setPitch(1.122).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Ds4TRANS").setTranslation(0.375,0.1,-0.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Ds4").setDescription("play pitch Dsharp4"))
        .addChild(new Sound().setMaxBack(110).setMaxFront(110).setMinBack(100).setMinFront(100)
          .setSource(new AudioClip("PitchDs4").setDescription("playing Pitch Ds4").setPitch(1.189).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("E4TRANS").setTranslation(.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("E4").setDescription("play pitch E4"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchE4").setDescription("playing Pitch E4").setPitch(1.260).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("F4TRANS").setTranslation(.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("F4").setDescription("play pitch F4"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchF4").setDescription("playing Pitch F4").setPitch(1.335).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Fs4TRANS").setTranslation(.875,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Fs4").setDescription("play pitch Fsharp4"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchFs4").setDescription("playing Pitch Fs4").setPitch(1.414).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("G4TRANS").setTranslation(1.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("G4").setDescription("play pitch G4"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchG4").setDescription("playing Pitch G4").setPitch(1.498).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Gs4TRANS").setTranslation(1.125,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Gs4").setDescription("play pitch Gsharp4"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchGs4").setDescription("playing Pitch Gs4").setPitch(1.587).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("A5TRANS").setTranslation(1.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("A5").setDescription("play pitch A5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchA5").setDescription("playing Pitch A5").setPitch(1.682).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("As5TRANS").setTranslation(1.375,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("As5").setDescription("play pitch Asharp5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchAs5").setDescription("playing Pitch As5").setPitch(1.782).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("B5TRANS").setTranslation(1.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("B5").setDescription("play pitch B5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchB5").setDescription("playing Pitch B5").setPitch(1.888).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("C5TRANS").setTranslation(1.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("C5").setDescription("play pitch C5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchC5").setDescription("playing Pitch C5").setPitch(2).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Cs5TRANS").setTranslation(1.875,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Cs5").setDescription("play pitch Csharp5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchCs5").setDescription("playing Pitch Cs5").setPitch(2.119).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("D5TRANS").setTranslation(2.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("D5").setDescription("play pitch D5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchD5").setDescription("playing Pitch D5").setPitch(2.245).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Ds5TRANS").setTranslation(2.125,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Ds5").setDescription("play pitch Ds5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchDs5").setDescription("playing Pitch Ds5").setPitch(2.378).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("E5TRANS").setTranslation(2.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("E5").setDescription("play pitch E5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchE5").setDescription("playing Pitch E5").setPitch(2.520).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("F5TRANS").setTranslation(2.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("F5").setDescription("play pitch F5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchF5").setDescription("playing Pitch F5").setPitch(2.670).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Fs5TRANS").setTranslation(2.625,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Fs5").setDescription("play pitch Fs5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchFs5").setDescription("playing Pitch Fs5").setPitch(2.828).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("G5TRANS").setTranslation(2.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("G5").setDescription("play pitch G5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchG5").setDescription("playing Pitch G5").setPitch(2.997).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Gs5TRANS").setTranslation(2.875,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Gs5").setDescription("play pitch Gs5"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchGs5").setDescription("playing Pitch Gs5").setPitch(3.175).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("A6TRANS").setTranslation(3.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("A6").setDescription("play pitch A6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchA6").setDescription("playing Pitch A6").setPitch(3.364).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("As6TRANS").setTranslation(3.125,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("As6").setDescription("play pitch As6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchAs6").setDescription("playing Pitch As6").setPitch(3.564).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("B6TRANS").setTranslation(3.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("B6").setDescription("play pitch B6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchB6").setDescription("playing Pitch B6").setPitch(3.775).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("C6TRANS").setTranslation(3.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("C6").setDescription("play pitch C6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchC6").setDescription("playing Pitch C6").setPitch(4).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Cs6TRANS").setTranslation(3.625,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Cs6").setDescription("play pitch Cs6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchCs6").setDescription("playing Pitch Cs6").setPitch(4.238).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("D6TRANS").setTranslation(3.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("D6").setDescription("play pitch D6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchD6").setDescription("playing Pitch D6").setPitch(4.49).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Ds6TRANS").setTranslation(3.875,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Ds6").setDescription("play pitch Ds6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchDs6").setDescription("playing Pitch Ds6").setPitch(4.757).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("E6TRANS").setTranslation(4.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("E6").setDescription("play pitch E6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchE6").setDescription("playing Pitch E6").setPitch(5.04).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("F6TRANS").setTranslation(4.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("F6").setDescription("play pitch F6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchF6").setDescription("playing Pitch F6").setPitch(5.339).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Fs6TRANS").setTranslation(4.375,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Fs6").setDescription("play pitch Fs6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchFs6").setDescription("playing Pitch Fs6").setPitch(5.657).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("G6TRANS").setTranslation(4.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("G6").setDescription("play pitch G6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchG6").setDescription("playing Pitch G6").setPitch(5.993).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Gs6TRANS").setTranslation(4.625,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Gs6").setDescription("play pitch Gs6"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchGs6").setDescription("playing Pitch Gs6").setPitch(6.35).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("A7TRANS").setTranslation(4.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("A7").setDescription("play pitch A7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchA7").setDescription("playing Pitch A7").setPitch(6.727).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("As7TRANS").setTranslation(4.875,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("As7").setDescription("play pitch As7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchAs7").setDescription("playing Pitch As7").setPitch(7.127).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("B7TRANS").setTranslation(5.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("B7").setDescription("play pitch B7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchB7").setDescription("playing Pitch B7").setPitch(7.551).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("C7TRANS").setTranslation(5.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("C7").setDescription("play pitch C7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchC7").setDescription("playing Pitch C7").setPitch(8).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Cs7TRANS").setTranslation(5.375,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Cs7").setDescription("play pitch Cs7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchCs7").setDescription("playing Pitch Cs7").setPitch(8.476).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("D7TRANS").setTranslation(5.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("D7").setDescription("play pitch D7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchD7").setDescription("playing Pitch D7").setPitch(8.980).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Ds7TRANS").setTranslation(5.625,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Ds7").setDescription("play pitch Ds7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchDs7").setDescription("playing Pitch Ds7").setPitch(9.514).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("E7TRANS").setTranslation(5.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("E7").setDescription("play pitch E7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchE7").setDescription("playing Pitch E7").setPitch(10.079).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("F7TRANS").setTranslation(6.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("F7").setDescription("play pitch F7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchF7").setDescription("playing Pitch F7").setPitch(10.679).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Fs7TRANS").setTranslation(6.125,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Fs7").setDescription("play pitch Fs7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchFs7").setDescription("playing Pitch Fs7").setPitch(11.314).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("G7TRANS").setTranslation(6.25,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("G7").setDescription("play pitch G7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchG7").setDescription("playing Pitch G7").setPitch(11.986).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("Gs7TRANS").setTranslation(6.375,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("Gs7").setDescription("play pitch Gs7"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchGs7").setDescription("playing Pitch Gs7").setPitch(12.699).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("A8TRANS").setTranslation(6.5,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("A8").setDescription("play pitch A8"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchA8").setDescription("playing Pitch A8").setPitch(13.454).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("As8TRANS").setTranslation(6.625,.1,-.375)
        .addChild(new Shape().setUSE("BlackKey"))
        .addChild(new TouchSensor("As8").setDescription("play pitch As8"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchAs8").setDescription("playing Pitch As8").setPitch(14.254).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("B8TRANS").setTranslation(6.75,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("B8").setDescription("play pitch B8"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchB8").setDescription("playing Pitch B8").setPitch(15.102).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform("C8TRANS").setTranslation(7.0,0.0,0.0)
        .addChild(new Shape().setUSE("WhiteKey"))
        .addChild(new TouchSensor("C8").setDescription("play pitch C8"))
        .addChild(new Sound()
          .setSource(new AudioClip("PitchC8").setDescription("playing Pitch C8").setPitch(16).setUrl(new String[] {"tone1.wav","../../Vrml2Sourcebook/Chapter24-Sound/tone1.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/tone1.wav","https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook/Chapter24-Sound/tone1.wav"}))))
      .addChild(new Transform().setScale(.25,.25,.25).setTranslation(0.0,1.0,-2.0)
        .addChild(new Shape()
          .setGeometry(new Sphere())
          .setAppearance(new Appearance()
            .setMaterial(new Material().setDiffuseColor(1.0,0.0,0.0))))
        .addChild(new TouchSensor("StartPlaying").setDescription("Touch to Activate Player Piano Script")))
      .addChild(new TimeSensor("ClockA0"))
      .addChild(new TimeSensor("ClockAs0"))
      .addChild(new TimeSensor("ClockB0"))
      .addChild(new TimeSensor("ClockC0"))
      .addChild(new TimeSensor("ClockCs0"))
      .addChild(new TimeSensor("ClockD0"))
      .addChild(new TimeSensor("ClockDs0"))
      .addChild(new TimeSensor("ClockE0"))
      .addChild(new TimeSensor("ClockF0"))
      .addChild(new TimeSensor("ClockFs0"))
      .addChild(new TimeSensor("ClockG0"))
      .addChild(new TimeSensor("ClockGs0"))
      .addChild(new TimeSensor("ClockAs1"))
      .addChild(new TimeSensor("ClockB1"))
      .addChild(new TimeSensor("ClockC1"))
      .addChild(new TimeSensor("ClockCs1"))
      .addChild(new TimeSensor("ClockD1"))
      .addChild(new TimeSensor("ClockDs1"))
      .addChild(new TimeSensor("ClockE1"))
      .addChild(new TimeSensor("ClockF1"))
      .addChild(new TimeSensor("ClockFs1"))
      .addChild(new TimeSensor("ClockG1"))
      .addChild(new TimeSensor("ClockGs1"))
      .addChild(new TimeSensor("ClockA1"))
      .addChild(new TimeSensor("ClockA2"))
      .addChild(new TimeSensor("ClockAs2"))
      .addChild(new TimeSensor("ClockB2"))
      .addChild(new TimeSensor("ClockC2"))
      .addChild(new TimeSensor("ClockCs2"))
      .addChild(new TimeSensor("ClockD2"))
      .addChild(new TimeSensor("ClockDs2"))
      .addChild(new TimeSensor("ClockE2"))
      .addChild(new TimeSensor("ClockF2"))
      .addChild(new TimeSensor("ClockFs2"))
      .addChild(new TimeSensor("ClockG2"))
      .addChild(new TimeSensor("ClockGs2"))
      .addChild(new TimeSensor("ClockA3"))
      .addChild(new TimeSensor("ClockAs3"))
      .addChild(new TimeSensor("ClockB3"))
      .addChild(new TimeSensor("ClockC3"))
      .addChild(new TimeSensor("ClockCs3"))
      .addChild(new TimeSensor("ClockD3"))
      .addChild(new TimeSensor("ClockDs3"))
      .addChild(new TimeSensor("ClockE3"))
      .addChild(new TimeSensor("ClockF3"))
      .addChild(new TimeSensor("ClockFs3"))
      .addChild(new TimeSensor("ClockG3"))
      .addChild(new TimeSensor("ClockGs3"))
      .addChild(new TimeSensor("ClockA4"))
      .addChild(new TimeSensor("ClockAs4"))
      .addChild(new TimeSensor("ClockB4"))
      .addChild(new TimeSensor("ClockC4"))
      .addChild(new TimeSensor("ClockCs4"))
      .addChild(new TimeSensor("ClockD4"))
      .addChild(new TimeSensor("ClockDs4"))
      .addChild(new TimeSensor("ClockE4"))
      .addChild(new TimeSensor("ClockF4"))
      .addChild(new TimeSensor("ClockFs4"))
      .addChild(new TimeSensor("ClockG4"))
      .addChild(new TimeSensor("ClockGs4"))
      .addChild(new TimeSensor("ClockA5"))
      .addChild(new TimeSensor("ClockAs5"))
      .addChild(new TimeSensor("ClockB5"))
      .addChild(new TimeSensor("ClockC5"))
      .addChild(new TimeSensor("ClockCs5"))
      .addChild(new TimeSensor("ClockD5"))
      .addChild(new TimeSensor("ClockDs5"))
      .addChild(new TimeSensor("ClockE5"))
      .addChild(new TimeSensor("ClockF5"))
      .addChild(new TimeSensor("ClockFs5"))
      .addChild(new TimeSensor("ClockG5"))
      .addChild(new TimeSensor("ClockGs5"))
      .addChild(new TimeSensor("ClockA6"))
      .addChild(new TimeSensor("ClockAs6"))
      .addChild(new TimeSensor("ClockB6"))
      .addChild(new TimeSensor("ClockC6"))
      .addChild(new TimeSensor("ClockCs6"))
      .addChild(new TimeSensor("ClockD6"))
      .addChild(new TimeSensor("ClockDs6"))
      .addChild(new TimeSensor("ClockE6"))
      .addChild(new TimeSensor("ClockF6"))
      .addChild(new TimeSensor("ClockFs6"))
      .addChild(new TimeSensor("ClockG6"))
      .addChild(new TimeSensor("ClockGs6"))
      .addChild(new TimeSensor("ClockA7"))
      .addChild(new TimeSensor("ClockAs7"))
      .addChild(new TimeSensor("ClockB7"))
      .addChild(new TimeSensor("ClockC7"))
      .addChild(new TimeSensor("ClockCs7"))
      .addChild(new TimeSensor("ClockD7"))
      .addChild(new TimeSensor("ClockDs7"))
      .addChild(new TimeSensor("ClockE7"))
      .addChild(new TimeSensor("ClockF7"))
      .addChild(new TimeSensor("ClockFs7"))
      .addChild(new TimeSensor("ClockG7"))
      .addChild(new TimeSensor("ClockGs7"))
      .addChild(new TimeSensor("ClockA8"))
      .addChild(new TimeSensor("ClockAs8"))
      .addChild(new TimeSensor("ClockB8"))
      .addChild(new TimeSensor("ClockC8"))
      .addChild(new PositionInterpolator("A0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-7.5,-.03,0.0,-7.5,0.0,0.0})))
      .addChild(new PositionInterpolator("As0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-7.375,0.0,-.375,-7.375,0.1,-0.375})))
      .addChild(new PositionInterpolator("B0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-7.25,-.03,0.0,-7.25,0.0,0.0})))
      .addChild(new PositionInterpolator("C0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-7.0,-.03,0.0,-7.0,0.0,0.0})))
      .addChild(new PositionInterpolator("Cs0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-6.875,0.0,-.375,-6.875,0.1,-0.375})))
      .addChild(new PositionInterpolator("D0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-6.75,-.03,0.0,-6.75,0.0,0.0})))
      .addChild(new PositionInterpolator("Ds0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-6.625,0.0,-.375,-6.625,0.1,-0.375})))
      .addChild(new PositionInterpolator("E0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-6.5,-.03,0.0,-6.5,0.0,0.0})))
      .addChild(new PositionInterpolator("F0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-6.25,-.03,0.0,-6.25,0.0,0.0})))
      .addChild(new PositionInterpolator("Fs0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-6.125,0.0,-.375,-6.125,0.1,-.375})))
      .addChild(new PositionInterpolator("G0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-6.0,-.03,0.0,-6.0,0.0,0.0})))
      .addChild(new PositionInterpolator("Gs0Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-5.875,0.0,-.375,-5.875,.1,-.375})))
      .addChild(new PositionInterpolator("A1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-5.75,-.03,0.0,-5.75,0.0,0.0})))
      .addChild(new PositionInterpolator("As1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-5.65,0.0,-.375,-5.625,0.1,-0.375})))
      .addChild(new PositionInterpolator("B1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-5.5,-.03,0.0,-5.5,0.0,0.0})))
      .addChild(new PositionInterpolator("C1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-5.25,-.03,0.0,-5.25,0.0,0.0})))
      .addChild(new PositionInterpolator("Cs1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-5.125,0.0,-.375,-5.125,0.1,-0.375})))
      .addChild(new PositionInterpolator("D1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-5.0,-.03,0.0,-5.0,0.0,0.0})))
      .addChild(new PositionInterpolator("Ds1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-4.875,0.0,-.375,-4.875,0.1,-0.375})))
      .addChild(new PositionInterpolator("E1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-4.75,-.03,0.0,-4.75,0.0,0.0})))
      .addChild(new PositionInterpolator("F1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-4.5,-.03,0.0,-4.5,0.0,0.0})))
      .addChild(new PositionInterpolator("Fs1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-4.375,0.0,-.375,-4.375,0.1,-.375})))
      .addChild(new PositionInterpolator("G1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-4.25,-.03,0.0,-4.25,0.0,0.0})))
      .addChild(new PositionInterpolator("Gs1Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-4.125,0.0,-.375,-4.125,.1,-.375})))
      .addChild(new PositionInterpolator("A2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-4.0,-.03,0.0,-4.0,0.0,0.0})))
      .addChild(new PositionInterpolator("As2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-3.875,0.0,-.3750,-3.875,.1,-.375})))
      .addChild(new PositionInterpolator("B2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-3.75,-.03,0.0,-3.75,0.0,0.0})))
      .addChild(new PositionInterpolator("C2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-3.5,-.03,0.0,-3.5,0.0,0.0})))
      .addChild(new PositionInterpolator("Cs2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-3.375,0.0,-.375,-3.375,0.1,-0.375})))
      .addChild(new PositionInterpolator("D2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-3.25,-.03,0.0,-3.25,0.0,0.0})))
      .addChild(new PositionInterpolator("Ds2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-3.125,0.0,-.375,-3.125,0.1,-0.375})))
      .addChild(new PositionInterpolator("E2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-3.0,-.03,0.0,-3.0,0.0,0.0})))
      .addChild(new PositionInterpolator("F2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-2.75,-.03,0.0,-2.75,0.0,0.0})))
      .addChild(new PositionInterpolator("Fs2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-2.625,0.0,-.375,-2.625,0.1,-.375})))
      .addChild(new PositionInterpolator("G2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-2.5,-.03,0.0,-2.5,0.0,0.0})))
      .addChild(new PositionInterpolator("Gs2Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-2.375,0.0,-.375,-2.375,.1,-.375})))
      .addChild(new PositionInterpolator("A3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-2.25,-.03,0.0,-2.25,0.0,0.0})))
      .addChild(new PositionInterpolator("As3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-2.125,0.0,-.3750,-2.125,.1,-.375})))
      .addChild(new PositionInterpolator("B3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-2.0,-.03,0.0,-2.0,0.0,0.0})))
      .addChild(new PositionInterpolator("C3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-1.75,-.03,0.0,-1.75,0.0,0.0})))
      .addChild(new PositionInterpolator("Cs3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-1.625,0.0,-.375,-1.625,0.1,-0.375})))
      .addChild(new PositionInterpolator("D3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-1.5,-.03,0.0,-1.5,0.0,0.0})))
      .addChild(new PositionInterpolator("Ds3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-1.375,0.0,-.375,-1.375,0.1,-0.375})))
      .addChild(new PositionInterpolator("E3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-1.25,-.03,0.0,-1.25,0.0,0.0})))
      .addChild(new PositionInterpolator("F3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-1.0,-.03,0.0,-1.0,0.0,0.0})))
      .addChild(new PositionInterpolator("Fs3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-.875,0.0,-.375,-.875,0.1,-.375})))
      .addChild(new PositionInterpolator("G3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-.75,-.03,0.0,-.75,0.0,0.0})))
      .addChild(new PositionInterpolator("Gs3Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-.625,0.0,-.375,-.625,.1,-.375})))
      .addChild(new PositionInterpolator("A4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-.5,-.03,0.0,-.5,0.0,0.0})))
      .addChild(new PositionInterpolator("As4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-.375,0.0,-.3750,-.375,.1,-.375})))
      .addChild(new PositionInterpolator("B4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {-.25,-.03,0.0,-.25,0.0,0.0})))
      .addChild(new PositionInterpolator("C4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {0.0,-.03,0.0,0.0,0.0,0.0})))
      .addChild(new PositionInterpolator("Cs4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {.125,0.0,-.375,0.125,0.1,-0.375})))
      .addChild(new PositionInterpolator("D4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {0.25,-.03,0.0,0.25,0.0,0.0})))
      .addChild(new PositionInterpolator("Ds4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {.375,0.0,-.375,0.375,0.1,-0.375})))
      .addChild(new PositionInterpolator("E4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {0.5,-.03,0.0,0.5,0.0,0.0})))
      .addChild(new PositionInterpolator("F4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {.75,-.03,0.0,.75,0.0,0.0})))
      .addChild(new PositionInterpolator("Fs4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {0.875,0.0,-.375,.875,0.1,-.375})))
      .addChild(new PositionInterpolator("G4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {1.0,-.03,0.0,1.0,0.0,0.0})))
      .addChild(new PositionInterpolator("Gs4Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {1.125,0.0,-.375,1.125,.1,-.375})))
      .addChild(new PositionInterpolator("A5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {1.25,-.03,0.0,1.25,0.0,0.0})))
      .addChild(new PositionInterpolator("As5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {1.375,0.0,-.3750,1.375,.1,-.375})))
      .addChild(new PositionInterpolator("B5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {1.5,-.03,0.0,1.5,0.0,0.0})))
      .addChild(new PositionInterpolator("C5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {1.75,-.03,0.0,1.75,0.0,0.0})))
      .addChild(new PositionInterpolator("Cs5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {1.875,0.0,-.375,1.875,0.1,-0.375})))
      .addChild(new PositionInterpolator("D5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {2.0,-.03,0.0,2.0,0.0,0.0})))
      .addChild(new PositionInterpolator("Ds5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {2.125,0.0,-.375,2.125,0.1,-0.375})))
      .addChild(new PositionInterpolator("E5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {2.25,-.03,0.0,2.25,0.0,0.0})))
      .addChild(new PositionInterpolator("F5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {2.5,-.03,0.0,2.5,0.0,0.0})))
      .addChild(new PositionInterpolator("Fs5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {2.625,0.0,-.375,2.625,0.1,-.375})))
      .addChild(new PositionInterpolator("G5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {2.75,-.03,0.0,2.75,0.0,0.0})))
      .addChild(new PositionInterpolator("Gs5Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {2.875,0.0,-.375,2.875,.1,-.375})))
      .addChild(new PositionInterpolator("A6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {3.0,-.03,0.0,3.0,0.0,0.0})))
      .addChild(new PositionInterpolator("As6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {3.125,0.0,-.3750,3.125,.1,-.375})))
      .addChild(new PositionInterpolator("B6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {3.25,-.03,0.0,3.25,0.0,0.0})))
      .addChild(new PositionInterpolator("C6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {3.5,-.03,0.0,3.5,0.0,0.0})))
      .addChild(new PositionInterpolator("Cs6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {3.625,0.0,-.375,3.625,0.1,-0.375})))
      .addChild(new PositionInterpolator("D6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {3.75,-.03,0.0,3.75,0.0,0.0})))
      .addChild(new PositionInterpolator("Ds6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {3.875,0.0,-.375,3.875,0.1,-0.375})))
      .addChild(new PositionInterpolator("E6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {4.0,-.03,0.0,4.0,0.0,0.0})))
      .addChild(new PositionInterpolator("F6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {4.25,-.03,0.0,4.25,0.0,0.0})))
      .addChild(new PositionInterpolator("Fs6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {4.375,0.0,-.375,4.375,0.1,-.375})))
      .addChild(new PositionInterpolator("G6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {4.5,-.03,0.0,4.5,0.0,0.0})))
      .addChild(new PositionInterpolator("Gs6Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {4.625,0.0,-.375,4.625,.1,-.375})))
      .addChild(new PositionInterpolator("A7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {4.75,-.03,0.0,4.75,0.0,0.0})))
      .addChild(new PositionInterpolator("As7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {4.875,0.0,-.3750,4.875,.1,-.375})))
      .addChild(new PositionInterpolator("B7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {5.0,-.03,0.0,5.0,0.0,0.0})))
      .addChild(new PositionInterpolator("C7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {5.25,-.03,0.0,5.25,0.0,0.0})))
      .addChild(new PositionInterpolator("Cs7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {5.375,0.0,-.375,5.375,0.1,-0.375})))
      .addChild(new PositionInterpolator("D7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {5.5,-.03,0.0,5.5,0.0,0.0})))
      .addChild(new PositionInterpolator("Ds7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {5.625,0.0,-.375,5.625,0.1,-0.375})))
      .addChild(new PositionInterpolator("E7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {5.75,-.03,0.0,5.75,0.0,0.0})))
      .addChild(new PositionInterpolator("F7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {6.0,-.03,0.0,6.0,0.0,0.0})))
      .addChild(new PositionInterpolator("Fs7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {6.125,0.0,-.375,6.125,0.1,-.375})))
      .addChild(new PositionInterpolator("G7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {6.25,-.03,0.0,6.25,0.0,0.0})))
      .addChild(new PositionInterpolator("Gs7Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {6.375,0.0,-.375,6.375,.1,-.375})))
      .addChild(new PositionInterpolator("A8Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {6.5,-.03,0.0,6.5,0.0,0.0})))
      .addChild(new PositionInterpolator("As8Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {6.625,0.0,-.3750,6.625,.1,-.375})))
      .addChild(new PositionInterpolator("B8Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {6.75,-.03,0.0,6.75,0.0,0.0})))
      .addChild(new PositionInterpolator("C8Mover").setKey(new double[] {0.0,.99}).setKeyValue(new MFVec3f(new double[] {7.0,-.03,0.0,7.0,0.0,0.0})))
      .addChild(new Script("PlayerPianoScript").setSourceCode("""
ecmascript:

function playScriptedNotes(time, eventTime){

    playC4=eventTime;
  
    playD4=eventTime+1.1;

    playE4=eventTime+2.2;

    playF4=eventTime+3.3;

    playG4=eventTime+4.4;

    playA5=eventTime+5.5;   
}
function hideUnscriptedKeyWarnings ()
{
	playA0=0;
	playAs0=0;
	playB0=0;
	playC0=0;
	playCs0=0;
	playD0=0;
	playDs0=0;
	playE0=0;
	playF0=0;
	playFs0=0;
	playG0=0;
	playGs0=0;
	playA1=0;
	playAs1=0;
	playB1=0;
	playC1=0;
	playCs1=0;
	playD1=0;
	playDs1=0;
	playE1=0;
	playF1=0;
	playFs1=0;
	playG1=0;
	playGs1=0;
	playA2=0;
	playAs2=0;
	playB2=0;
	playC2=0;
	playCs2=0;
	playD2=0;
	playDs2=0;
	playE2=0;
	playF2=0;
	playFs2=0;
	playG2=0;
	playGs2=0;
	playA3=0;
	playAs3=0;
	playB3=0;
	playC3=0;
	playCs3=0;
	playD3=0;
	playDs3=0;
	playE3=0;
	playF3=0;
	playFs3=0;
	playG3=0;
	playGs3=0;
	playA4=0;
	playAs4=0;
	playB4=0;
	playC4=0;
	playCs4=0;
	playD4=0;
	playDs4=0;
	playE4=0;
	playF4=0;
	playFs4=0;
	playG4=0;
	playGs4=0;
	playA5=0;
	playAs5=0;
	playB5=0;
	playC5=0;
	playCs5=0;
	playD5=0;
	playDs5=0;
	playE5=0;
	playF5=0;
	playFs5=0;
	playG5=0;
	playGs5=0;
	playA6=0;
	playAs6=0;
	playB6=0;
	playC6=0;
	playCs6=0;
	playD6=0;
	playDs6=0;
	playE6=0;
	playF6=0;
	playFs6=0;
	playG6=0;
	playGs6=0;
	playA7=0;
	playAs7=0;
	playB7=0;
	playC7=0;
	playCs7=0;
	playD7=0;
	playDs7=0;
	playE7=0;
	playF7=0;
	playFs7=0;
	playG7=0;
	playGs7=0;
	playA8=0;
	playAs8=0;
	playB8=0;
	playC8=0;
}
""")
        .addField(new field().setName("playScriptedNotes").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("playA0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playAs0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playB0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playC0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playCs0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playD0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playDs0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playE0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playF0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playFs0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playG0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playGs0").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playA1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playAs1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playB1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playC1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playCs1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playD1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playDs1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playE1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playF1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playFs1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playG1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playGs1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playA2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playAs2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playB2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playC2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playCs2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playD2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playDs2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playE2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playF2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playFs2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playG2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playGs2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playA3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playAs3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playB3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playC3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playCs3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playD3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playDs3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playE3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playF3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playFs3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playG3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playGs3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playA4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playAs4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playB4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playC4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playCs4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playD4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playDs4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playE4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playF4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playFs4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playG4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playGs4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playA5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playAs5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playB5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playC5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playCs5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playD5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playDs5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playE5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playF5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playFs5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playG5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playGs5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playA6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playAs6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playB6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playC6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playCs6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playD6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playDs6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playE6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playF6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playFs6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playG6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playGs6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playA7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playAs7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playB7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playC7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playCs7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playD7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playDs7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playE7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playF7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playFs7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playG7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playGs7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playA8").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playAs8").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playB8").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("playC8").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_OUTPUTONLY))))
    .addChild(new ROUTE().setFromNode("StartPlaying").setFromField("touchTime").setToNode("PlayerPianoScript").setToField("playScriptedNotes"))
    .addChild(new ROUTE().setFromNode("A0").setFromField("touchTime").setToNode("PitchA1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("As0").setFromField("touchTime").setToNode("PitchAs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("B0").setFromField("touchTime").setToNode("PitchB1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("C0").setFromField("touchTime").setToNode("PitchC1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Cs0").setFromField("touchTime").setToNode("PitchCs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("D0").setFromField("touchTime").setToNode("PitchD1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Ds0").setFromField("touchTime").setToNode("PitchDs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("E0").setFromField("touchTime").setToNode("PitchE1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("F0").setFromField("touchTime").setToNode("PitchF1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Fs0").setFromField("touchTime").setToNode("PitchFs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("G0").setFromField("touchTime").setToNode("PitchG1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Gs0").setFromField("touchTime").setToNode("PitchGs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("A1").setFromField("touchTime").setToNode("PitchA1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("As1").setFromField("touchTime").setToNode("PitchAs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("B1").setFromField("touchTime").setToNode("PitchB1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("C1").setFromField("touchTime").setToNode("PitchC1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Cs1").setFromField("touchTime").setToNode("PitchCs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("D1").setFromField("touchTime").setToNode("PitchD1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Ds1").setFromField("touchTime").setToNode("PitchDs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("E1").setFromField("touchTime").setToNode("PitchE1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("F1").setFromField("touchTime").setToNode("PitchF1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Fs1").setFromField("touchTime").setToNode("PitchFs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("G1").setFromField("touchTime").setToNode("PitchG1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Gs1").setFromField("touchTime").setToNode("PitchGs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("A2").setFromField("touchTime").setToNode("PitchA2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("As2").setFromField("touchTime").setToNode("PitchAs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("B2").setFromField("touchTime").setToNode("PitchB2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("C2").setFromField("touchTime").setToNode("PitchC2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Cs2").setFromField("touchTime").setToNode("PitchCs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("D2").setFromField("touchTime").setToNode("PitchD2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Ds2").setFromField("touchTime").setToNode("PitchDs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("E2").setFromField("touchTime").setToNode("PitchE2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("F2").setFromField("touchTime").setToNode("PitchF2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Fs2").setFromField("touchTime").setToNode("PitchFs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("G2").setFromField("touchTime").setToNode("PitchG2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Gs2").setFromField("touchTime").setToNode("PitchGs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("A3").setFromField("touchTime").setToNode("PitchA3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("As3").setFromField("touchTime").setToNode("PitchAs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("B3").setFromField("touchTime").setToNode("PitchB3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("C3").setFromField("touchTime").setToNode("PitchC3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Cs3").setFromField("touchTime").setToNode("PitchCs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("D3").setFromField("touchTime").setToNode("PitchD3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Ds3").setFromField("touchTime").setToNode("PitchDs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("E3").setFromField("touchTime").setToNode("PitchE3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("F3").setFromField("touchTime").setToNode("PitchF3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Fs3").setFromField("touchTime").setToNode("PitchFs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("G3").setFromField("touchTime").setToNode("PitchG3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Gs3").setFromField("touchTime").setToNode("PitchGs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("A4").setFromField("touchTime").setToNode("PitchA4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("As4").setFromField("touchTime").setToNode("PitchAs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("B4").setFromField("touchTime").setToNode("PitchB4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("C4").setFromField("touchTime").setToNode("PitchC4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Cs4").setFromField("touchTime").setToNode("PitchCs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("D4").setFromField("touchTime").setToNode("PitchD4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Ds4").setFromField("touchTime").setToNode("PitchDs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("E4").setFromField("touchTime").setToNode("PitchE4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("F4").setFromField("touchTime").setToNode("PitchF4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Fs4").setFromField("touchTime").setToNode("PitchFs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("G4").setFromField("touchTime").setToNode("PitchG4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Gs4").setFromField("touchTime").setToNode("PitchGs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("A5").setFromField("touchTime").setToNode("PitchA5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("As5").setFromField("touchTime").setToNode("PitchAs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("B5").setFromField("touchTime").setToNode("PitchB5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("C5").setFromField("touchTime").setToNode("PitchC5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Cs5").setFromField("touchTime").setToNode("PitchCs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("D5").setFromField("touchTime").setToNode("PitchD5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Ds5").setFromField("touchTime").setToNode("PitchDs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("E5").setFromField("touchTime").setToNode("PitchE5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("F5").setFromField("touchTime").setToNode("PitchF5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Fs5").setFromField("touchTime").setToNode("PitchFs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("G5").setFromField("touchTime").setToNode("PitchG5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Gs5").setFromField("touchTime").setToNode("PitchGs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("A6").setFromField("touchTime").setToNode("PitchA6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("As6").setFromField("touchTime").setToNode("PitchAs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("B6").setFromField("touchTime").setToNode("PitchB6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("C6").setFromField("touchTime").setToNode("PitchC6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Cs6").setFromField("touchTime").setToNode("PitchCs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("D6").setFromField("touchTime").setToNode("PitchD6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Ds6").setFromField("touchTime").setToNode("PitchDs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("E6").setFromField("touchTime").setToNode("PitchE6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("F6").setFromField("touchTime").setToNode("PitchF6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Fs6").setFromField("touchTime").setToNode("PitchFs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("G6").setFromField("touchTime").setToNode("PitchG6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Gs6").setFromField("touchTime").setToNode("PitchGs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("A7").setFromField("touchTime").setToNode("PitchA7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("As7").setFromField("touchTime").setToNode("PitchAs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("B7").setFromField("touchTime").setToNode("PitchB7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("C7").setFromField("touchTime").setToNode("PitchC7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Cs7").setFromField("touchTime").setToNode("PitchCs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("D7").setFromField("touchTime").setToNode("PitchD7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Ds7").setFromField("touchTime").setToNode("PitchDs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("E7").setFromField("touchTime").setToNode("PitchE7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("F7").setFromField("touchTime").setToNode("PitchF7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Fs7").setFromField("touchTime").setToNode("PitchFs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("G7").setFromField("touchTime").setToNode("PitchG7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("Gs7").setFromField("touchTime").setToNode("PitchGs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("A8").setFromField("touchTime").setToNode("PitchA8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("As8").setFromField("touchTime").setToNode("PitchAs8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("B8").setFromField("touchTime").setToNode("PitchB8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("C8").setFromField("touchTime").setToNode("PitchC8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("A0").setFromField("touchTime").setToNode("ClockA0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockA0").setFromField("fraction_changed").setToNode("A0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("A0Mover").setFromField("value_changed").setToNode("A0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("As0").setFromField("touchTime").setToNode("ClockAs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockAs0").setFromField("fraction_changed").setToNode("As0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("As0Mover").setFromField("value_changed").setToNode("As0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("B0").setFromField("touchTime").setToNode("ClockB0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockB0").setFromField("fraction_changed").setToNode("B0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("B0Mover").setFromField("value_changed").setToNode("B0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("C0").setFromField("touchTime").setToNode("ClockC0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockC0").setFromField("fraction_changed").setToNode("C0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("C0Mover").setFromField("value_changed").setToNode("C0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Cs0").setFromField("touchTime").setToNode("ClockCs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockCs0").setFromField("fraction_changed").setToNode("Cs0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Cs0Mover").setFromField("value_changed").setToNode("Cs0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("D0").setFromField("touchTime").setToNode("ClockD0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockD0").setFromField("fraction_changed").setToNode("D0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("D0Mover").setFromField("value_changed").setToNode("D0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Ds0").setFromField("touchTime").setToNode("ClockDs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockDs0").setFromField("fraction_changed").setToNode("Ds0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Ds0Mover").setFromField("value_changed").setToNode("Ds0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("E0").setFromField("touchTime").setToNode("ClockE0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockE0").setFromField("fraction_changed").setToNode("E0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("E0Mover").setFromField("value_changed").setToNode("E0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("F0").setFromField("touchTime").setToNode("ClockF0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockF0").setFromField("fraction_changed").setToNode("F0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("F0Mover").setFromField("value_changed").setToNode("F0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Fs0").setFromField("touchTime").setToNode("ClockFs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockFs0").setFromField("fraction_changed").setToNode("Fs0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Fs0Mover").setFromField("value_changed").setToNode("Fs0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("G0").setFromField("touchTime").setToNode("ClockG0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockG0").setFromField("fraction_changed").setToNode("G0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("G0Mover").setFromField("value_changed").setToNode("G0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Gs0").setFromField("touchTime").setToNode("ClockGs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockGs0").setFromField("fraction_changed").setToNode("Gs0Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Gs0Mover").setFromField("value_changed").setToNode("Gs0TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("A1").setFromField("touchTime").setToNode("ClockA1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockA1").setFromField("fraction_changed").setToNode("A1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("A1Mover").setFromField("value_changed").setToNode("A1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("As1").setFromField("touchTime").setToNode("ClockAs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockAs1").setFromField("fraction_changed").setToNode("As1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("As1Mover").setFromField("value_changed").setToNode("As1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("B1").setFromField("touchTime").setToNode("ClockB1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockB1").setFromField("fraction_changed").setToNode("B1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("B1Mover").setFromField("value_changed").setToNode("B1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("C1").setFromField("touchTime").setToNode("ClockC1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockC1").setFromField("fraction_changed").setToNode("C1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("C1Mover").setFromField("value_changed").setToNode("C1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Cs1").setFromField("touchTime").setToNode("ClockCs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockCs1").setFromField("fraction_changed").setToNode("Cs1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Cs1Mover").setFromField("value_changed").setToNode("Cs1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("D1").setFromField("touchTime").setToNode("ClockD1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockD1").setFromField("fraction_changed").setToNode("D1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("D1Mover").setFromField("value_changed").setToNode("D1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Ds1").setFromField("touchTime").setToNode("ClockDs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockDs1").setFromField("fraction_changed").setToNode("Ds1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Ds1Mover").setFromField("value_changed").setToNode("Ds1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("E1").setFromField("touchTime").setToNode("ClockE1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockE1").setFromField("fraction_changed").setToNode("E1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("E1Mover").setFromField("value_changed").setToNode("E1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("F1").setFromField("touchTime").setToNode("ClockF1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockF1").setFromField("fraction_changed").setToNode("F1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("F1Mover").setFromField("value_changed").setToNode("F1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Fs1").setFromField("touchTime").setToNode("ClockFs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockFs1").setFromField("fraction_changed").setToNode("Fs1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Fs1Mover").setFromField("value_changed").setToNode("Fs1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("G1").setFromField("touchTime").setToNode("ClockG1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockG1").setFromField("fraction_changed").setToNode("G1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("G1Mover").setFromField("value_changed").setToNode("G1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Gs1").setFromField("touchTime").setToNode("ClockGs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockGs1").setFromField("fraction_changed").setToNode("Gs1Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Gs1Mover").setFromField("value_changed").setToNode("Gs1TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("A2").setFromField("touchTime").setToNode("ClockA2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockA2").setFromField("fraction_changed").setToNode("A2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("A2Mover").setFromField("value_changed").setToNode("A2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("As2").setFromField("touchTime").setToNode("ClockAs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockAs2").setFromField("fraction_changed").setToNode("As2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("As2Mover").setFromField("value_changed").setToNode("As2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("B2").setFromField("touchTime").setToNode("ClockB2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockB2").setFromField("fraction_changed").setToNode("B2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("B2Mover").setFromField("value_changed").setToNode("B2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("C2").setFromField("touchTime").setToNode("ClockC2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockC2").setFromField("fraction_changed").setToNode("C2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("C2Mover").setFromField("value_changed").setToNode("C2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Cs2").setFromField("touchTime").setToNode("ClockCs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockCs2").setFromField("fraction_changed").setToNode("Cs2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Cs2Mover").setFromField("value_changed").setToNode("Cs2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("D2").setFromField("touchTime").setToNode("ClockD2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockD2").setFromField("fraction_changed").setToNode("D2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("D2Mover").setFromField("value_changed").setToNode("D2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Ds2").setFromField("touchTime").setToNode("ClockDs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockDs2").setFromField("fraction_changed").setToNode("Ds2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Ds2Mover").setFromField("value_changed").setToNode("Ds2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("E2").setFromField("touchTime").setToNode("ClockE2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockE2").setFromField("fraction_changed").setToNode("E2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("E2Mover").setFromField("value_changed").setToNode("E2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("F2").setFromField("touchTime").setToNode("ClockF2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockF2").setFromField("fraction_changed").setToNode("F2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("F2Mover").setFromField("value_changed").setToNode("F2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Fs2").setFromField("touchTime").setToNode("ClockFs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockFs2").setFromField("fraction_changed").setToNode("Fs2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Fs2Mover").setFromField("value_changed").setToNode("Fs2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("G2").setFromField("touchTime").setToNode("ClockG2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockG2").setFromField("fraction_changed").setToNode("G2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("G2Mover").setFromField("value_changed").setToNode("G2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Gs2").setFromField("touchTime").setToNode("ClockGs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockGs2").setFromField("fraction_changed").setToNode("Gs2Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Gs2Mover").setFromField("value_changed").setToNode("Gs2TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("A3").setFromField("touchTime").setToNode("ClockA3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockA3").setFromField("fraction_changed").setToNode("A3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("A3Mover").setFromField("value_changed").setToNode("A3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("As3").setFromField("touchTime").setToNode("ClockAs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockAs3").setFromField("fraction_changed").setToNode("As3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("As3Mover").setFromField("value_changed").setToNode("As3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("B3").setFromField("touchTime").setToNode("ClockB3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockB3").setFromField("fraction_changed").setToNode("B3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("B3Mover").setFromField("value_changed").setToNode("B3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("C3").setFromField("touchTime").setToNode("ClockC3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockC3").setFromField("fraction_changed").setToNode("C3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("C3Mover").setFromField("value_changed").setToNode("C3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Cs3").setFromField("touchTime").setToNode("ClockCs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockCs3").setFromField("fraction_changed").setToNode("Cs3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Cs3Mover").setFromField("value_changed").setToNode("Cs3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("D3").setFromField("touchTime").setToNode("ClockD3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockD3").setFromField("fraction_changed").setToNode("D3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("D3Mover").setFromField("value_changed").setToNode("D3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Ds3").setFromField("touchTime").setToNode("ClockDs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockDs3").setFromField("fraction_changed").setToNode("Ds3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Ds3Mover").setFromField("value_changed").setToNode("Ds3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("E3").setFromField("touchTime").setToNode("ClockE3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockE3").setFromField("fraction_changed").setToNode("E3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("E3Mover").setFromField("value_changed").setToNode("E3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("F3").setFromField("touchTime").setToNode("ClockF3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockF3").setFromField("fraction_changed").setToNode("F3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("F3Mover").setFromField("value_changed").setToNode("F3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Fs3").setFromField("touchTime").setToNode("ClockFs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockFs3").setFromField("fraction_changed").setToNode("Fs3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Fs3Mover").setFromField("value_changed").setToNode("Fs3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("G3").setFromField("touchTime").setToNode("ClockG3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockG3").setFromField("fraction_changed").setToNode("G3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("G3Mover").setFromField("value_changed").setToNode("G3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Gs3").setFromField("touchTime").setToNode("ClockGs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockGs3").setFromField("fraction_changed").setToNode("Gs3Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Gs3Mover").setFromField("value_changed").setToNode("Gs3TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("A4").setFromField("touchTime").setToNode("ClockA4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockA4").setFromField("fraction_changed").setToNode("A4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("A4Mover").setFromField("value_changed").setToNode("A4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("As4").setFromField("touchTime").setToNode("ClockAs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockAs4").setFromField("fraction_changed").setToNode("As4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("As4Mover").setFromField("value_changed").setToNode("As4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("B4").setFromField("touchTime").setToNode("ClockB4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockB4").setFromField("fraction_changed").setToNode("B4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("B4Mover").setFromField("value_changed").setToNode("B4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("C4").setFromField("touchTime").setToNode("ClockC4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockC4").setFromField("fraction_changed").setToNode("C4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("C4Mover").setFromField("value_changed").setToNode("C4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Cs4").setFromField("touchTime").setToNode("ClockCs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockCs4").setFromField("fraction_changed").setToNode("Cs4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Cs4Mover").setFromField("value_changed").setToNode("Cs4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("D4").setFromField("touchTime").setToNode("ClockD4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockD4").setFromField("fraction_changed").setToNode("D4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("D4Mover").setFromField("value_changed").setToNode("D4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Ds4").setFromField("touchTime").setToNode("ClockDs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockDs4").setFromField("fraction_changed").setToNode("Ds4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Ds4Mover").setFromField("value_changed").setToNode("Ds4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("E4").setFromField("touchTime").setToNode("ClockE4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockE4").setFromField("fraction_changed").setToNode("E4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("E4Mover").setFromField("value_changed").setToNode("E4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("F4").setFromField("touchTime").setToNode("ClockF4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockF4").setFromField("fraction_changed").setToNode("F4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("F4Mover").setFromField("value_changed").setToNode("F4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Fs4").setFromField("touchTime").setToNode("ClockFs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockFs4").setFromField("fraction_changed").setToNode("Fs4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Fs4Mover").setFromField("value_changed").setToNode("Fs4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("G4").setFromField("touchTime").setToNode("ClockG4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockG4").setFromField("fraction_changed").setToNode("G4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("G4Mover").setFromField("value_changed").setToNode("G4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Gs4").setFromField("touchTime").setToNode("ClockGs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockGs4").setFromField("fraction_changed").setToNode("Gs4Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Gs4Mover").setFromField("value_changed").setToNode("Gs4TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("A5").setFromField("touchTime").setToNode("ClockA5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockA5").setFromField("fraction_changed").setToNode("A5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("A5Mover").setFromField("value_changed").setToNode("A5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("As5").setFromField("touchTime").setToNode("ClockAs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockAs5").setFromField("fraction_changed").setToNode("As5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("As5Mover").setFromField("value_changed").setToNode("As5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("B5").setFromField("touchTime").setToNode("ClockB5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockB5").setFromField("fraction_changed").setToNode("B5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("B5Mover").setFromField("value_changed").setToNode("B5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("C5").setFromField("touchTime").setToNode("ClockC5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockC5").setFromField("fraction_changed").setToNode("C5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("C5Mover").setFromField("value_changed").setToNode("C5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Cs5").setFromField("touchTime").setToNode("ClockCs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockCs5").setFromField("fraction_changed").setToNode("Cs5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Cs5Mover").setFromField("value_changed").setToNode("Cs5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("D5").setFromField("touchTime").setToNode("ClockD5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockD5").setFromField("fraction_changed").setToNode("D5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("D5Mover").setFromField("value_changed").setToNode("D5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Ds5").setFromField("touchTime").setToNode("ClockDs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockDs5").setFromField("fraction_changed").setToNode("Ds5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Ds5Mover").setFromField("value_changed").setToNode("Ds5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("E5").setFromField("touchTime").setToNode("ClockE5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockE5").setFromField("fraction_changed").setToNode("E5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("E5Mover").setFromField("value_changed").setToNode("E5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("F5").setFromField("touchTime").setToNode("ClockF5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockF5").setFromField("fraction_changed").setToNode("F5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("F5Mover").setFromField("value_changed").setToNode("F5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Fs5").setFromField("touchTime").setToNode("ClockFs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockFs5").setFromField("fraction_changed").setToNode("Fs5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Fs5Mover").setFromField("value_changed").setToNode("Fs5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("G5").setFromField("touchTime").setToNode("ClockG5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockG5").setFromField("fraction_changed").setToNode("G5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("G5Mover").setFromField("value_changed").setToNode("G5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Gs5").setFromField("touchTime").setToNode("ClockGs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockGs5").setFromField("fraction_changed").setToNode("Gs5Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Gs5Mover").setFromField("value_changed").setToNode("Gs5TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("A6").setFromField("touchTime").setToNode("ClockA6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockA6").setFromField("fraction_changed").setToNode("A6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("A6Mover").setFromField("value_changed").setToNode("A6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("As6").setFromField("touchTime").setToNode("ClockAs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockAs6").setFromField("fraction_changed").setToNode("As6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("As6Mover").setFromField("value_changed").setToNode("As6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("B6").setFromField("touchTime").setToNode("ClockB6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockB6").setFromField("fraction_changed").setToNode("B6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("B6Mover").setFromField("value_changed").setToNode("B6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("C6").setFromField("touchTime").setToNode("ClockC6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockC6").setFromField("fraction_changed").setToNode("C6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("C6Mover").setFromField("value_changed").setToNode("C6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Cs6").setFromField("touchTime").setToNode("ClockCs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockCs6").setFromField("fraction_changed").setToNode("Cs6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Cs6Mover").setFromField("value_changed").setToNode("Cs6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("D6").setFromField("touchTime").setToNode("ClockD6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockD6").setFromField("fraction_changed").setToNode("D6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("D6Mover").setFromField("value_changed").setToNode("D6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Ds6").setFromField("touchTime").setToNode("ClockDs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockDs6").setFromField("fraction_changed").setToNode("Ds6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Ds6Mover").setFromField("value_changed").setToNode("Ds6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("E6").setFromField("touchTime").setToNode("ClockE6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockE6").setFromField("fraction_changed").setToNode("E6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("E6Mover").setFromField("value_changed").setToNode("E6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("F6").setFromField("touchTime").setToNode("ClockF6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockF6").setFromField("fraction_changed").setToNode("F6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("F6Mover").setFromField("value_changed").setToNode("F6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Fs6").setFromField("touchTime").setToNode("ClockFs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockFs6").setFromField("fraction_changed").setToNode("Fs6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Fs6Mover").setFromField("value_changed").setToNode("Fs6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("G6").setFromField("touchTime").setToNode("ClockG6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockG6").setFromField("fraction_changed").setToNode("G6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("G6Mover").setFromField("value_changed").setToNode("G6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Gs6").setFromField("touchTime").setToNode("ClockGs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockGs6").setFromField("fraction_changed").setToNode("Gs6Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Gs6Mover").setFromField("value_changed").setToNode("Gs6TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("A7").setFromField("touchTime").setToNode("ClockA7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockA7").setFromField("fraction_changed").setToNode("A7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("A7Mover").setFromField("value_changed").setToNode("A7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("As7").setFromField("touchTime").setToNode("ClockAs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockAs7").setFromField("fraction_changed").setToNode("As7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("As7Mover").setFromField("value_changed").setToNode("As7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("B7").setFromField("touchTime").setToNode("ClockB7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockB7").setFromField("fraction_changed").setToNode("B7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("B7Mover").setFromField("value_changed").setToNode("B7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("C7").setFromField("touchTime").setToNode("ClockC7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockC7").setFromField("fraction_changed").setToNode("C7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("C7Mover").setFromField("value_changed").setToNode("C7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Cs7").setFromField("touchTime").setToNode("ClockCs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockCs7").setFromField("fraction_changed").setToNode("Cs7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Cs7Mover").setFromField("value_changed").setToNode("Cs7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("D7").setFromField("touchTime").setToNode("ClockD7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockD7").setFromField("fraction_changed").setToNode("D7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("D7Mover").setFromField("value_changed").setToNode("D7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Ds7").setFromField("touchTime").setToNode("ClockDs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockDs7").setFromField("fraction_changed").setToNode("Ds7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Ds7Mover").setFromField("value_changed").setToNode("Ds7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("E7").setFromField("touchTime").setToNode("ClockE7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockE7").setFromField("fraction_changed").setToNode("E7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("E7Mover").setFromField("value_changed").setToNode("E7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("F7").setFromField("touchTime").setToNode("ClockF7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockF7").setFromField("fraction_changed").setToNode("F7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("F7Mover").setFromField("value_changed").setToNode("F7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Fs7").setFromField("touchTime").setToNode("ClockFs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockFs7").setFromField("fraction_changed").setToNode("Fs7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Fs7Mover").setFromField("value_changed").setToNode("Fs7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("G7").setFromField("touchTime").setToNode("ClockG7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockG7").setFromField("fraction_changed").setToNode("G7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("G7Mover").setFromField("value_changed").setToNode("G7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("Gs7").setFromField("touchTime").setToNode("ClockGs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockGs7").setFromField("fraction_changed").setToNode("Gs7Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("Gs7Mover").setFromField("value_changed").setToNode("Gs7TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("A8").setFromField("touchTime").setToNode("ClockA8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockA8").setFromField("fraction_changed").setToNode("A8Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("A8Mover").setFromField("value_changed").setToNode("A8TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("As8").setFromField("touchTime").setToNode("ClockAs8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockAs8").setFromField("fraction_changed").setToNode("As8Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("As8Mover").setFromField("value_changed").setToNode("As8TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("B8").setFromField("touchTime").setToNode("ClockB8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockB8").setFromField("fraction_changed").setToNode("B8Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("B8Mover").setFromField("value_changed").setToNode("B8TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("C8").setFromField("touchTime").setToNode("ClockC8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("ClockC8").setFromField("fraction_changed").setToNode("C8Mover").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("C8Mover").setFromField("value_changed").setToNode("C8TRANS").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA0").setToNode("PitchA0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA0").setToNode("ClockA0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs0").setToNode("PitchAs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs0").setToNode("ClockAs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB0").setToNode("PitchB0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB0").setToNode("ClockB0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC0").setToNode("PitchC0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC0").setToNode("ClockC0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs0").setToNode("PitchCs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs0").setToNode("ClockCs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD0").setToNode("PitchD0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD0").setToNode("ClockD0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs0").setToNode("PitchDs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs0").setToNode("ClockDs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE0").setToNode("PitchE0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE0").setToNode("ClockE0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF0").setToNode("PitchF0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF0").setToNode("ClockF0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs0").setToNode("PitchFs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs0").setToNode("ClockFs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG0").setToNode("PitchG0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG0").setToNode("ClockG0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs0").setToNode("PitchGs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs0").setToNode("ClockGs0").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA1").setToNode("PitchA1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA1").setToNode("ClockA1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs1").setToNode("PitchAs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs1").setToNode("ClockAs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB1").setToNode("PitchB1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB1").setToNode("ClockB1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC1").setToNode("PitchC1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC1").setToNode("ClockC1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs1").setToNode("PitchCs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs1").setToNode("ClockCs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD1").setToNode("PitchD1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD1").setToNode("ClockD1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs1").setToNode("PitchDs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs1").setToNode("ClockDs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE1").setToNode("PitchE1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE1").setToNode("ClockE1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF1").setToNode("PitchF1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF1").setToNode("ClockF1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs1").setToNode("PitchFs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs1").setToNode("ClockFs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG1").setToNode("PitchG1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG1").setToNode("ClockG1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs1").setToNode("PitchGs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs1").setToNode("ClockGs1").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA2").setToNode("PitchA2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA2").setToNode("ClockA2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs2").setToNode("PitchAs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs2").setToNode("ClockAs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB2").setToNode("PitchB2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB2").setToNode("ClockB2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC2").setToNode("PitchC2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC2").setToNode("ClockC2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs2").setToNode("PitchCs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs2").setToNode("ClockCs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD2").setToNode("PitchD2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD2").setToNode("ClockD2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs2").setToNode("PitchDs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs2").setToNode("ClockDs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE2").setToNode("PitchE2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE2").setToNode("ClockE2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF2").setToNode("PitchF2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF2").setToNode("ClockF2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs2").setToNode("PitchFs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs2").setToNode("ClockFs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG2").setToNode("PitchG2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG2").setToNode("ClockG2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs2").setToNode("PitchGs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs2").setToNode("ClockGs2").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA3").setToNode("PitchA3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA3").setToNode("ClockA3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs3").setToNode("PitchAs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs3").setToNode("ClockAs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB3").setToNode("PitchB3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB3").setToNode("ClockB3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC3").setToNode("PitchC3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC3").setToNode("ClockC3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs3").setToNode("PitchCs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs3").setToNode("ClockCs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD3").setToNode("PitchD3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD3").setToNode("ClockD3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs3").setToNode("PitchDs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs3").setToNode("ClockDs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE3").setToNode("PitchE3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE3").setToNode("ClockE3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF3").setToNode("PitchF3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF3").setToNode("ClockF3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs3").setToNode("PitchFs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs3").setToNode("ClockFs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG3").setToNode("PitchG3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG3").setToNode("ClockG3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs3").setToNode("PitchGs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs3").setToNode("ClockGs3").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA4").setToNode("PitchA4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA4").setToNode("ClockA4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs4").setToNode("PitchAs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs4").setToNode("ClockAs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB4").setToNode("PitchB4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB4").setToNode("ClockB4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC4").setToNode("PitchC4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC4").setToNode("ClockC4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs4").setToNode("PitchCs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs4").setToNode("ClockCs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD4").setToNode("PitchD4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD4").setToNode("ClockD4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs4").setToNode("PitchDs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs4").setToNode("ClockDs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE4").setToNode("PitchE4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE4").setToNode("ClockE4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF4").setToNode("PitchF4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF4").setToNode("ClockF4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs4").setToNode("PitchFs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs4").setToNode("ClockFs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG4").setToNode("PitchG4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG4").setToNode("ClockG4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs4").setToNode("PitchGs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs4").setToNode("ClockGs4").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB5").setToNode("ClockB5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC5").setToNode("PitchC5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC5").setToNode("ClockC5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs5").setToNode("PitchCs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs5").setToNode("ClockCs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD5").setToNode("PitchD5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD5").setToNode("ClockD5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs5").setToNode("PitchDs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs5").setToNode("ClockDs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE5").setToNode("PitchE5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE5").setToNode("ClockE5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF5").setToNode("PitchF5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF5").setToNode("ClockF5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs5").setToNode("PitchFs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs5").setToNode("ClockFs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG5").setToNode("PitchG5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG5").setToNode("ClockG5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs5").setToNode("PitchGs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs5").setToNode("ClockGs5").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA6").setToNode("PitchA6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA6").setToNode("ClockA6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs6").setToNode("PitchAs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs6").setToNode("ClockAs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB6").setToNode("PitchB6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB6").setToNode("ClockB6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC6").setToNode("PitchC6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC6").setToNode("ClockC6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs6").setToNode("PitchCs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs6").setToNode("ClockCs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD6").setToNode("PitchD6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD6").setToNode("ClockD6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs6").setToNode("PitchDs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs6").setToNode("ClockDs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE6").setToNode("PitchE6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE6").setToNode("ClockE6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF6").setToNode("PitchF6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF6").setToNode("ClockF6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs6").setToNode("PitchFs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs6").setToNode("ClockFs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG6").setToNode("PitchG6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG6").setToNode("ClockG6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs6").setToNode("PitchGs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs6").setToNode("ClockGs6").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA7").setToNode("PitchA7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA7").setToNode("ClockA7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs7").setToNode("PitchAs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs7").setToNode("ClockAs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB7").setToNode("PitchB7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB7").setToNode("ClockB7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC7").setToNode("PitchC7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC7").setToNode("ClockC7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs7").setToNode("PitchCs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playCs7").setToNode("ClockCs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD7").setToNode("PitchD7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playD7").setToNode("ClockD7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs7").setToNode("PitchDs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playDs7").setToNode("ClockDs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE7").setToNode("PitchE7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playE7").setToNode("ClockE7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF7").setToNode("PitchF7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playF7").setToNode("ClockF7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs7").setToNode("PitchFs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playFs7").setToNode("ClockFs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG7").setToNode("PitchG7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playG7").setToNode("ClockG7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs7").setToNode("PitchGs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playGs7").setToNode("ClockGs7").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA8").setToNode("PitchA8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playA8").setToNode("ClockA8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs8").setToNode("PitchAs8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playAs8").setToNode("ClockAs8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB8").setToNode("PitchB8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playB8").setToNode("ClockB8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC8").setToNode("PitchC8").setToField("set_startTime"))
    .addChild(new ROUTE().setFromNode("PlayerPianoScript").setFromField("playC8").setToNode("ClockC8").setToField("set_startTime")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return KeyboardEightyEightKeys model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new KeyboardEightyEightKeys().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.StudentProjects.KeyboardEightyEightKeys\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.StudentProjects.KeyboardEightyEightKeys self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // StudentProjects/KeyboardEightyEightKeys_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "StudentProjects/KeyboardEightyEightKeys_JavaExport.x3d"; 
                String filenameX3DV = "StudentProjects/KeyboardEightyEightKeys_JavaExport.x3dv"; 
                String filenameJSON = "StudentProjects/KeyboardEightyEightKeys_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
