####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python IkeaBeadToy.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='IkeaBeadToy.x3d',name='title'),
    meta(content='X3D example Model of an ikea bead toy. It has intense extrusions and animation',name='description'),
    meta(content='3 March 2004',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Vaughn Pangelinan',name='creator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/IkeaBeadToy.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='IkeaBeadToy.x3d'),
    Transform(DEF='Toy',
      children=[
      Transform(rotation=(0,1,0,1.57),translation=(0,8,7),
        children=[
        Viewpoint(DEF='ToyView',description='Toy View',orientation=(1,0,0,-.68),position=(3.6,-2.5,6.5))]),
      Group(DEF='ToyGroup',
        children=[
        Transform(DEF='Frame',translation=(0,-1.3,0),
          children=[
          Transform(DEF='CrossBeamTransform',translation=(.5,0,0),
            children=[
            Shape(DEF='CrossBeam',
              appearance=Appearance(
                material=Material(DEF='Wood',diffuseColor=(.6,.5,.2))),
              geometry=Box(size=(5,1,0.75)))]),
          Transform(translation=(.5,0,7),
            children=[
            Shape(USE='CrossBeam')]),
          Transform(rotation=(1,0,0,1.57),translation=(-1.3,0,3.5),
            children=[
            Shape(DEF='LongLog',
              appearance=Appearance(
                material=Material(USE='Wood')),
              geometry=Cylinder(height=7,radius=.4))]),
          Transform(rotation=(1,0,0,1.57),translation=(2.3,0,3.5),
            children=[
            Shape(USE='LongLog')])]),
        Transform(DEF='RedWire',scale=(1,1,.96),translation=(-.5,0,.3),
          children=[
          TimeSensor(DEF='BlueClock',cycleInterval=15,loop=True),
          Transform(rotation=(1,0,0,1.57),translation=(0,1,0),
            children=[
            Transform(rotation=(0,0,1,-.15),
              children=[
              Transform(
                children=[
                Transform(
                  children=[
                  Shape(
                    geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(.100,0.00),(0.092,-0.038),(0.071,-0.071),(0.038,-0.092),(0.00,-.100),(-0.038,-0.092),(-0.071,-0.071),(-0.092,-0.038),(-.100,-0.00),(-0.092,0.038),(-0.071,0.071),(-0.038,0.092),(0.00,.100),(0.038,0.092),(0.071,0.071),(0.092,0.038),(.100,0.00)],spine=[(2.00,0.00,2.10),(2.00,0.00,0.77),(2.00,0.00,-0.00),(1.85,0.12,-0.77),(1.41,0.24,-1.41),(0.77,0.36,-1.85),(0.00,0.48,-2.00),(-0.77,0.61,-1.85),(-1.41,0.73,-1.41),(-1.85,0.85,-0.77),(-2.00,0.97,0.00),(-1.85,1.09,0.77),(-1.41,1.21,1.41),(-0.77,1.33,1.85),(0.00,1.45,2.00),(0.77,1.58,1.85),(1.41,1.70,1.41),(1.85,1.82,0.77),(2.00,1.94,0.00),(1.85,2.06,-0.77),(1.41,2.18,-1.41),(0.77,2.30,-1.85),(0.00,2.42,-2.00),(-0.77,2.55,-1.85),(-1.41,2.67,-1.41),(-1.85,2.79,-0.77),(-2.00,2.91,0.00),(-1.85,3.03,0.77),(-1.41,3.15,1.41),(-0.77,3.27,1.85),(0.00,3.39,2.00),(0.77,3.52,1.85),(1.41,3.64,1.41),(1.85,3.76,0.77),(2.00,3.88,0.00),(1.85,4.00,-0.77),(1.41,4.12,-1.41),(0.77,4.24,-1.85),(0.00,4.36,-2.00),(-0.77,4.49,-1.85),(-1.41,4.61,-1.41),(-1.85,4.73,-0.77),(-2.00,4.85,-0.00),(-1.85,4.97,0.77),(-1.41,5.09,1.41),(-0.77,5.21,1.85),(0.00,5.34,2.00),(0.77,5.46,1.85),(1.41,5.58,1.41),(1.85,5.70,0.77),(2.00,5.82,0.00),(1.85,5.94,-0.77),(1.41,6.07,-1.41),(0.77,6.19,-1.85),(-0.00,6.31,-2.00),(-0.77,6.43,-1.85),(-1.41,6.55,-1.41),(-1.85,6.68,-0.77),(-2.00,6.80,-0.00),(-2.00,6.80,0.77),(-2.00,6.80,2.10)]),
                    appearance=Appearance(DEF='NewRed',
                      material=Material(diffuseColor=(0.75,0,0))))]),
                Transform(DEF='RedwireBlueBall1aTransform',
                  children=[
                  PositionInterpolator(DEF='BlueBallPath1a',key=[0.005,0.01,0.015,0.02,0.025,0.03,0.035,0.04,0.045,0.05,0.055,0.06,0.065,0.07,0.075,0.08,0.085,0.09,0.095,0.1,0.105,0.11,0.115,0.12,0.125,0.13,0.135,0.14,0.145,0.15,0.155,0.16,0.165,0.17,0.175,0.18,0.185,0.19,0.195,0.2,0.205,0.21,0.215,0.22,0.225,0.23,0.235,0.24,0.245,0.25,0.255,0.26,0.265,0.27,0.275,0.28,0.285,0.29,0.295,0.3,0.305,0.31,0.315,0.32,0.325,0.33,0.335,0.34,0.345,0.35,0.355,0.36,0.365,0.37,0.375,0.38,0.385,0.39,0.395,0.4,0.405,0.41,0.415,0.42,0.425,0.43,0.435,0.44,0.445,0.45,0.455,0.46,0.465,0.47,0.475,0.48,0.485,0.49,0.495,0.5,0.505,0.51,0.515,0.52,0.525,0.53,0.535,0.54,0.545,0.55,0.555,0.56,0.565,0.57,0.575,0.58,0.585,0.59,0.595,0.6,0.605,0.61,0.615,0.62,0.625,0.63,0.635,0.64,0.645,0.65,0.655,0.66,0.665,0.67,0.675,0.68,0.685,0.69,0.695,0.7,0.705,0.71,0.715,0.72,0.725,0.73,0.735,0.74,0.745,0.75,0.755,0.76,0.765,0.77,0.775,0.78,0.785,0.79,0.795,0.8,0.805,0.81,0.815,0.82,0.825,0.83,0.835,0.84,0.845,0.85,0.855,0.86,0.865,0.87,0.875,0.88,0.885,0.89,0.895,0.9,0.905,0.91,0.915,0.92,0.925,0.93,0.935,0.94,0.945,0.95,0.955,0.96,0.965,0.97,0.975,0.98,0.985,0.99,0.9951],keyValue=[(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.10),(2.00,0.00,0.90),(2.00,0.00,0.77),(2.00,0.00,-0.00),(1.85,0.12,-0.77),(1.41,0.24,-1.41),(0.77,0.36,-1.85),(0.00,0.48,-2.00),(-0.77,0.61,-1.85),(-1.41,0.73,-1.41),(-1.85,0.85,-0.77),(-2.00,0.97,0.00),(-1.85,1.09,0.77),(-1.41,1.21,1.41),(-0.77,1.33,1.85),(0.00,1.45,2.00),(0.77,1.58,1.85),(1.41,1.70,1.41),(1.85,1.82,0.77),(2.00,1.94,0.00),(1.85,2.06,-0.77),(1.41,2.18,-1.41),(0.77,2.30,-1.85),(0.00,2.42,-2.00),(-0.77,2.55,-1.85),(-1.41,2.67,-1.41),(-1.85,2.79,-0.77),(-2.00,2.91,0.00),(-1.85,3.03,0.77),(-1.41,3.15,1.41),(-0.77,3.27,1.85),(0.00,3.39,2.00),(0.77,3.52,1.85),(1.41,3.64,1.41),(1.85,3.76,0.77),(2.00,3.88,0.00),(1.85,4.00,-0.77),(1.41,4.12,-1.41),(0.77,4.24,-1.85),(0.00,4.36,-2.00),(-0.77,4.49,-1.85),(-1.41,4.61,-1.41),(-1.85,4.73,-0.77),(-2.00,4.85,-0.00),(-1.85,4.97,0.77),(-1.41,5.09,1.41),(-0.77,5.21,1.85),(0.00,5.34,2.00),(0.77,5.46,1.85),(1.41,5.58,1.41),(1.85,5.70,0.77),(2.00,5.82,0.00),(1.85,5.94,-0.77),(1.41,6.07,-1.41),(0.77,6.19,-1.85),(-0.00,6.31,-2.00),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.80,6.50,-1.85),(-0.00,6.31,-2.00),(0.77,6.19,-1.85),(1.41,6.07,-1.41),(1.85,5.94,-0.77),(2.00,5.82,0.00),(1.85,5.70,0.77),(1.41,5.58,1.41),(0.77,5.46,1.85),(0.00,5.34,2.00),(-0.77,5.21,1.85),(-1.41,5.09,1.41),(-1.85,4.97,0.77),(-2.00,4.85,-0.00),(-1.85,4.73,-0.77),(-1.41,4.61,-1.41),(-0.77,4.49,-1.85),(0.00,4.36,-2.00),(0.77,4.24,-1.85),(1.41,4.12,-1.41),(1.85,4.00,-0.77),(2.00,3.88,0.00),(1.85,3.76,0.77),(1.41,3.64,1.41),(0.77,3.52,1.85),(0.00,3.39,2.00),(-0.77,3.27,1.85),(-1.41,3.15,1.41),(-1.85,3.03,0.77),(-2.00,2.91,0.00),(-1.85,2.79,-0.77),(-1.41,2.67,-1.41),(-0.77,2.55,-1.85),(0.00,2.42,-2.00),(0.77,2.30,-1.85),(1.41,2.18,-1.41),(1.85,2.06,-0.77),(2.00,1.94,0.00),(1.85,1.82,0.77),(1.41,1.70,1.41),(0.77,1.58,1.85),(0.00,1.45,2.00),(-0.77,1.33,1.85),(-1.41,1.21,1.41),(-1.85,1.09,0.77),(-2.00,0.97,0.00),(-1.85,0.85,-0.77),(-1.41,0.73,-1.41),(-0.77,0.61,-1.85),(0.00,0.48,-2.00),(0.77,0.36,-1.85),(1.41,0.24,-1.41),(1.85,0.12,-0.77),(2.00,0.00,-0.00),(2.00,0.00,0.77),(2.00,0.00,1.05),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33),(2.00,0.00,1.33)]),
                  ROUTE(fromField='fraction_changed',fromNode='BlueClock',toField='set_fraction',toNode='BlueBallPath1a'),
                  Transform(DEF='BlueBallTransform1a',translation=(2,0,1.33),
                    children=[
                    Shape(
                      geometry=Sphere(radius=.5),
                      appearance=Appearance(DEF='NewBlue',
                        material=Material(diffuseColor=(0,0,.7))))]),
                  ROUTE(fromField='value_changed',fromNode='BlueBallPath1a',toField='set_translation',toNode='BlueBallTransform1a')]),
                Transform(DEF='RedwireGreenBall1aTransform',
                  children=[
                  PositionInterpolator(DEF='GreenBallPath1a',key=[0.005,0.01,0.015,0.02,0.025,0.03,0.035,0.04,0.045,0.05,0.055,0.06,0.065,0.07,0.075,0.08,0.085,0.09,0.095,0.1,0.105,0.11,0.115,0.12,0.125,0.13,0.135,0.14,0.145,0.15,0.155,0.16,0.165,0.17,0.175,0.18,0.185,0.19,0.195,0.2,0.205,0.21,0.215,0.22,0.225,0.23,0.235,0.24,0.245,0.25,0.255,0.26,0.265,0.27,0.275,0.28,0.285,0.29,0.295,0.3,0.305,0.31,0.315,0.32,0.325,0.33,0.335,0.34,0.345,0.35,0.355,0.36,0.365,0.37,0.375,0.38,0.385,0.39,0.395,0.4,0.405,0.41,0.415,0.42,0.425,0.43,0.435,0.44,0.445,0.45,0.455,0.46,0.465,0.47,0.475,0.48,0.485,0.49,0.495,0.5,0.505,0.51,0.515,0.52,0.525,0.53,0.535,0.54,0.545,0.55,0.555,0.56,0.565,0.57,0.575,0.58,0.585,0.59,0.595,0.6,0.605,0.61,0.615,0.62,0.625,0.63,0.635,0.64,0.645,0.65,0.655,0.66,0.665,0.67,0.675,0.68,0.685,0.69,0.695,0.7,0.705,0.71,0.715,0.72,0.725,0.73,0.735,0.74,0.745,0.75,0.755,0.76,0.765,0.77,0.775,0.78,0.785,0.79,0.795,0.8,0.805,0.81,0.815,0.82,0.825,0.83,0.835,0.84,0.845,0.85,0.855,0.86,0.865,0.87,0.875,0.88,0.885,0.89,0.895,0.9,0.905,0.91,0.915,0.92,0.925,0.93,0.935,0.94,0.945,0.95,0.955,0.96,0.965,0.97,0.975,0.98,0.985,0.99,0.9951],keyValue=[(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.33),(2.00,0.00,0.20),(2.00,0.00,0.10),(2.00,0.00,0.05),(2.00,0.00,-0.00),(1.85,0.12,-0.77),(1.41,0.24,-1.41),(0.77,0.36,-1.85),(0.00,0.48,-2.00),(-0.77,0.61,-1.85),(-1.41,0.73,-1.41),(-1.85,0.85,-0.77),(-2.00,0.97,0.00),(-1.85,1.09,0.77),(-1.41,1.21,1.41),(-0.77,1.33,1.85),(0.00,1.45,2.00),(0.77,1.58,1.85),(1.41,1.70,1.41),(1.85,1.82,0.77),(2.00,1.94,0.00),(1.85,2.06,-0.77),(1.41,2.18,-1.41),(0.77,2.30,-1.85),(0.00,2.42,-2.00),(-0.77,2.55,-1.85),(-1.41,2.67,-1.41),(-1.85,2.79,-0.77),(-2.00,2.91,0.00),(-1.85,3.03,0.77),(-1.41,3.15,1.41),(-0.77,3.27,1.85),(0.00,3.39,2.00),(0.77,3.52,1.85),(1.41,3.64,1.41),(1.85,3.76,0.77),(2.00,3.88,0.00),(1.85,4.00,-0.77),(1.41,4.12,-1.41),(0.77,4.24,-1.85),(0.00,4.36,-2.00),(-0.77,4.49,-1.85),(-1.41,4.61,-1.41),(-1.85,4.73,-0.77),(-2.00,4.85,-0.00),(-1.85,4.97,0.77),(-1.41,5.09,1.41),(-0.77,5.21,1.85),(0.00,5.34,2.00),(0.77,5.46,1.85),(1.41,5.58,1.41),(1.85,5.70,0.77),(2.00,5.82,0.00),(1.85,5.94,-0.77),(1.41,6.07,-1.41),(0.77,6.19,-1.85),(-0.00,6.31,-2.00),(-0.77,6.43,-1.85),(-1.41,6.55,-1.41),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.50,6.62,-1.27),(-1.41,6.55,-1.41),(-0.77,6.43,-1.85),(-0.00,6.31,-2.00),(0.77,6.19,-1.85),(1.41,6.07,-1.41),(1.85,5.94,-0.77),(2.00,5.82,0.00),(1.85,5.70,0.77),(1.41,5.58,1.41),(0.77,5.46,1.85),(0.00,5.34,2.00),(-0.77,5.21,1.85),(-1.41,5.09,1.41),(-1.85,4.97,0.77),(-2.00,4.85,-0.00),(-1.85,4.73,-0.77),(-1.41,4.61,-1.41),(-0.77,4.49,-1.85),(0.00,4.36,-2.00),(0.77,4.24,-1.85),(1.41,4.12,-1.41),(1.85,4.00,-0.77),(2.00,3.88,0.00),(1.85,3.76,0.77),(1.41,3.64,1.41),(0.77,3.52,1.85),(0.00,3.39,2.00),(-0.77,3.27,1.85),(-1.41,3.15,1.41),(-1.85,3.03,0.77),(-2.00,2.91,0.00),(-1.85,2.79,-0.77),(-1.41,2.67,-1.41),(-0.77,2.55,-1.85),(0.00,2.42,-2.00),(0.77,2.30,-1.85),(1.41,2.18,-1.41),(1.85,2.06,-0.77),(2.00,1.94,0.00),(1.85,1.82,0.77),(1.41,1.70,1.41),(0.77,1.58,1.85),(0.00,1.45,2.00),(-0.77,1.33,1.85),(-1.41,1.21,1.41),(-1.85,1.09,0.77),(-2.00,0.97,0.00),(-1.85,0.85,-0.77),(-1.41,0.73,-1.41),(-0.77,0.61,-1.85),(0.00,0.48,-2.00),(0.77,0.36,-1.85),(1.41,0.24,-1.41),(1.85,0.12,-0.77),(2.00,0.00,-0.00),(2.00,0.00,0.20),(2.00,0.00,0.33),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43),(2.00,0.00,0.43)]),
                  ROUTE(fromField='fraction_changed',fromNode='BlueClock',toField='set_fraction',toNode='GreenBallPath1a'),
                  Transform(DEF='GreenBallTransform1a',translation=(2.00,0.00,0.43),
                    children=[
                    Shape(
                      geometry=Sphere(radius=.5),
                      appearance=Appearance(DEF='NewGreen',
                        material=Material(diffuseColor=(0,.6,0))))]),
                  ROUTE(fromField='value_changed',fromNode='GreenBallPath1a',toField='set_translation',toNode='GreenBallTransform1a')]),
                Transform(DEF='RedwireYellowBallTransform',
                  children=[
                  PositionInterpolator(DEF='YellowBallPath1',key=[0.005,0.01,0.015,0.02,0.025,0.03,0.035,0.04,0.045,0.05,0.055,0.06,0.065,0.07,0.075,0.08,0.085,0.09,0.095,0.1,0.105,0.11,0.115,0.12,0.125,0.13,0.135,0.14,0.145,0.15,0.155,0.16,0.165,0.17,0.175,0.18,0.185,0.19,0.195,0.2,0.205,0.21,0.215,0.22,0.225,0.23,0.235,0.24,0.245,0.25,0.255,0.26,0.265,0.27,0.275,0.28,0.285,0.29,0.295,0.3,0.305,0.31,0.315,0.32,0.325,0.33,0.335,0.34,0.345,0.35,0.355,0.36,0.365,0.37,0.375,0.38,0.385,0.39,0.395,0.4,0.405,0.41,0.415,0.42,0.425,0.43,0.435,0.44,0.445,0.45,0.455,0.46,0.465,0.47,0.475,0.48,0.485,0.49,0.495,0.5,0.505,0.51,0.515,0.52,0.525,0.53,0.535,0.54,0.545,0.55,0.555,0.56,0.565,0.57,0.575,0.58,0.585,0.59,0.595,0.6,0.605,0.61,0.615,0.62,0.625,0.63,0.635,0.64,0.645,0.65,0.655,0.66,0.665,0.67,0.675,0.68,0.685,0.69,0.695,0.7,0.705,0.71,0.715,0.72,0.725,0.73,0.735,0.74,0.745,0.75,0.755,0.76,0.765,0.77,0.775,0.78,0.785,0.79,0.795,0.8,0.805,0.81,0.815,0.82,0.825,0.83,0.835,0.84,0.845,0.85,0.855,0.86,0.865,0.87,0.875,0.88,0.885,0.89,0.895,0.9,0.905,0.91,0.915,0.92,0.925,0.93,0.935,0.94,0.945,0.95,0.955,0.96,0.965,0.97,0.975,0.98,0.985,0.99,0.9951],keyValue=[(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.18,-.57),(1.93,0.18,-.67),(1.93,0.18,-.77),(1.93,0.18,-0.87),(1.85,0.12,-1.07),(1.41,0.24,-1.41),(0.77,0.36,-1.85),(0.00,0.48,-2.00),(-0.77,0.61,-1.85),(-1.41,0.73,-1.41),(-1.85,0.85,-0.77),(-2.00,0.97,0.00),(-1.85,1.09,0.77),(-1.41,1.21,1.41),(-0.77,1.33,1.85),(0.00,1.45,2.00),(0.77,1.58,1.85),(1.41,1.70,1.41),(1.85,1.82,0.77),(2.00,1.94,0.00),(1.85,2.06,-0.77),(1.41,2.18,-1.41),(0.77,2.30,-1.85),(0.00,2.42,-2.00),(-0.77,2.55,-1.85),(-1.41,2.67,-1.41),(-1.85,2.79,-0.77),(-2.00,2.91,0.00),(-1.85,3.03,0.77),(-1.41,3.15,1.41),(-0.77,3.27,1.85),(0.00,3.39,2.00),(0.77,3.52,1.85),(1.41,3.64,1.41),(1.85,3.76,0.77),(2.00,3.88,0.00),(1.85,4.00,-0.77),(1.41,4.12,-1.41),(0.77,4.24,-1.85),(0.00,4.36,-2.00),(-0.77,4.49,-1.85),(-1.41,4.61,-1.41),(-1.85,4.73,-0.77),(-2.00,4.85,-0.00),(-1.85,4.97,0.77),(-1.41,5.09,1.41),(-0.77,5.21,1.85),(0.00,5.34,2.00),(0.77,5.46,1.85),(1.41,5.58,1.41),(1.85,5.70,0.77),(2.00,5.82,0.00),(1.85,5.94,-0.77),(1.41,6.07,-1.41),(0.77,6.19,-1.85),(-0.00,6.31,-2.00),(-0.77,6.43,-1.85),(-1.41,6.55,-1.41),(-1.85,6.62,-0.77),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.93,6.67,-0.47),(-1.85,6.62,-0.77),(-1.41,6.55,-1.41),(-0.77,6.43,-1.85),(-0.00,6.31,-2.00),(0.77,6.19,-1.85),(1.41,6.07,-1.41),(1.85,5.94,-0.77),(2.00,5.82,0.00),(1.85,5.70,0.77),(1.41,5.58,1.41),(0.77,5.46,1.85),(0.00,5.34,2.00),(-0.77,5.21,1.85),(-1.41,5.09,1.41),(-1.85,4.97,0.77),(-2.00,4.85,-0.00),(-1.85,4.73,-0.77),(-1.41,4.61,-1.41),(-0.77,4.49,-1.85),(0.00,4.36,-2.00),(0.77,4.24,-1.85),(1.41,4.12,-1.41),(1.85,4.00,-0.77),(2.00,3.88,0.00),(1.85,3.76,0.77),(1.41,3.64,1.41),(0.77,3.52,1.85),(0.00,3.39,2.00),(-0.77,3.27,1.85),(-1.41,3.15,1.41),(-1.85,3.03,0.77),(-2.00,2.91,0.00),(-1.85,2.79,-0.77),(-1.41,2.67,-1.41),(-0.77,2.55,-1.85),(0.00,2.42,-2.00),(0.77,2.30,-1.85),(1.41,2.18,-1.41),(1.85,2.06,-0.77),(2.00,1.94,0.00),(1.85,1.82,0.77),(1.41,1.70,1.41),(0.77,1.58,1.85),(0.00,1.45,2.00),(-0.77,1.33,1.85),(-1.41,1.21,1.41),(-1.85,1.09,0.77),(-2.00,0.97,0.00),(-1.85,0.85,-0.77),(-1.41,0.73,-1.41),(-0.77,0.61,-1.85),(0.00,0.48,-2.00),(0.77,0.36,-1.85),(1.41,0.24,-1.41),(1.85,0.18,-1.07),(1.93,0.18,-0.87),(1.93,0.18,-.67),(1.93,0.18,-.57),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47),(1.93,0.14,-.47)]),
                  ROUTE(fromField='fraction_changed',fromNode='BlueClock',toField='set_fraction',toNode='YellowBallPath1'),
                  Transform(DEF='YellowBallTransform1',translation=(1.93,0.14,-.47),
                    children=[
                    Shape(
                      geometry=Sphere(radius=.5),
                      appearance=Appearance(DEF='NewYellow',
                        material=Material(diffuseColor=(.8,.8,0))))]),
                  ROUTE(fromField='value_changed',fromNode='YellowBallPath1',toField='set_translation',toNode='YellowBallTransform1')]),
                Transform(DEF='RedwireBlueBall1bTransform',
                  children=[
                  PositionInterpolator(DEF='BlueBallPath1b',key=[0.005,0.01,0.015,0.02,0.025,0.03,0.035,0.04,0.045,0.05,0.055,0.06,0.065,0.07,0.075,0.08,0.085,0.09,0.095,0.1,0.105,0.11,0.115,0.12,0.125,0.13,0.135,0.14,0.145,0.15,0.155,0.16,0.165,0.17,0.175,0.18,0.185,0.19,0.195,0.2,0.205,0.21,0.215,0.22,0.225,0.23,0.235,0.24,0.245,0.25,0.255,0.26,0.265,0.27,0.275,0.28,0.285,0.29,0.295,0.3,0.305,0.31,0.315,0.32,0.325,0.33,0.335,0.34,0.345,0.35,0.355,0.36,0.365,0.37,0.375,0.38,0.385,0.39,0.395,0.4,0.405,0.41,0.415,0.42,0.425,0.43,0.435,0.44,0.445,0.45,0.455,0.46,0.465,0.47,0.475,0.48,0.485,0.49,0.495,0.5,0.505,0.51,0.515,0.52,0.525,0.53,0.535,0.54,0.545,0.55,0.555,0.56,0.565,0.57,0.575,0.58,0.585,0.59,0.595,0.6,0.605,0.61,0.615,0.62,0.625,0.63,0.635,0.64,0.645,0.65,0.655,0.66,0.665,0.67,0.675,0.68,0.685,0.69,0.695,0.7,0.705,0.71,0.715,0.72,0.725,0.73,0.735,0.74,0.745,0.75,0.755,0.76,0.765,0.77,0.775,0.78,0.785,0.79,0.795,0.8,0.805,0.81,0.815,0.82,0.825,0.83,0.835,0.84,0.845,0.85,0.855,0.86,0.865,0.87,0.875,0.88,0.885,0.89,0.895,0.9,0.905,0.91,0.915,0.92,0.925,0.93,0.935,0.94,0.945,0.95,0.955,0.96,0.965,0.97,0.975,0.98,0.985,0.99,0.9951],keyValue=[(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.37),(1.50,0.18,-1.37),(1.41,0.24,-1.78),(0.77,0.36,-1.85),(0.00,0.48,-2.00),(-0.77,0.61,-1.85),(-1.41,0.73,-1.41),(-1.85,0.85,-0.77),(-2.00,0.97,0.00),(-1.85,1.09,0.77),(-1.41,1.21,1.41),(-0.77,1.33,1.85),(0.00,1.45,2.00),(0.77,1.58,1.85),(1.41,1.70,1.41),(1.85,1.82,0.77),(2.00,1.94,0.00),(1.85,2.06,-0.77),(1.41,2.18,-1.41),(0.77,2.30,-1.85),(0.00,2.42,-2.00),(-0.77,2.55,-1.85),(-1.41,2.67,-1.41),(-1.85,2.79,-0.77),(-2.00,2.91,0.00),(-1.85,3.03,0.77),(-1.41,3.15,1.41),(-0.77,3.27,1.85),(0.00,3.39,2.00),(0.77,3.52,1.85),(1.41,3.64,1.41),(1.85,3.76,0.77),(2.00,3.88,0.00),(1.85,4.00,-0.77),(1.41,4.12,-1.41),(0.77,4.24,-1.85),(0.00,4.36,-2.00),(-0.77,4.49,-1.85),(-1.41,4.61,-1.41),(-1.85,4.73,-0.77),(-2.00,4.85,-0.00),(-1.85,4.97,0.77),(-1.41,5.09,1.41),(-0.77,5.21,1.85),(0.00,5.34,2.00),(0.77,5.46,1.85),(1.41,5.58,1.41),(1.85,5.70,0.77),(2.00,5.82,0.00),(1.85,5.94,-0.77),(1.41,6.07,-1.41),(0.77,6.19,-1.85),(-0.00,6.31,-2.00),(-0.77,6.43,-1.85),(-1.41,6.55,-1.41),(-1.85,6.68,-0.77),(-2.00,6.80,-0.00),(-2.00,6.80,0.27),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.43),(-2.00,6.80,0.27),(-2.00,6.80,-0.00),(-1.85,6.68,-0.77),(-1.41,6.55,-1.41),(-0.77,6.43,-1.85),(-0.00,6.31,-2.00),(0.77,6.19,-1.85),(1.41,6.07,-1.41),(1.85,5.94,-0.77),(2.00,5.82,0.00),(1.85,5.70,0.77),(1.41,5.58,1.41),(0.77,5.46,1.85),(0.00,5.34,2.00),(-0.77,5.21,1.85),(-1.41,5.09,1.41),(-1.85,4.97,0.77),(-2.00,4.85,-0.00),(-1.85,4.73,-0.77),(-1.41,4.61,-1.41),(-0.77,4.49,-1.85),(0.00,4.36,-2.00),(0.77,4.24,-1.85),(1.41,4.12,-1.41),(1.85,4.00,-0.77),(2.00,3.88,0.00),(1.85,3.76,0.77),(1.41,3.64,1.41),(0.77,3.52,1.85),(0.00,3.39,2.00),(-0.77,3.27,1.85),(-1.41,3.15,1.41),(-1.85,3.03,0.77),(-2.00,2.91,0.00),(-1.85,2.79,-0.77),(-1.41,2.67,-1.41),(-0.77,2.55,-1.85),(0.00,2.42,-2.00),(0.77,2.30,-1.85),(1.41,2.18,-1.41),(1.85,2.06,-0.77),(2.00,1.94,0.00),(1.85,1.82,0.77),(1.41,1.70,1.41),(0.77,1.58,1.85),(0.00,1.45,2.00),(-0.77,1.33,1.85),(-1.41,1.21,1.41),(-1.85,1.09,0.77),(-2.00,0.97,0.00),(-1.85,0.85,-0.77),(-1.41,0.73,-1.41),(-0.77,0.61,-1.85),(0.00,0.48,-2.00),(0.77,0.36,-1.85),(1.41,0.24,-1.74),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27),(1.50,0.18,-1.27)]),
                  ROUTE(fromField='fraction_changed',fromNode='BlueClock',toField='set_fraction',toNode='BlueBallPath1b'),
                  Transform(DEF='BlueBallTransform1b',translation=(1.50,0.18,-1.27),
                    children=[
                    Shape(
                      geometry=Sphere(radius=.5),
                      appearance=Appearance(USE='NewBlue'))]),
                  ROUTE(fromField='value_changed',fromNode='BlueBallPath1b',toField='set_translation',toNode='BlueBallTransform1b')]),
                Transform(DEF='RedwireGreenBall1bTransform',
                  children=[
                  PositionInterpolator(DEF='GreenBallPath1b',key=[0.005,0.01,0.015,0.02,0.025,0.03,0.035,0.04,0.045,0.05,0.055,0.06,0.065,0.07,0.075,0.08,0.085,0.09,0.095,0.1,0.105,0.11,0.115,0.12,0.125,0.13,0.135,0.14,0.145,0.15,0.155,0.16,0.165,0.17,0.175,0.18,0.185,0.19,0.195,0.2,0.205,0.21,0.215,0.22,0.225,0.23,0.235,0.24,0.245,0.25,0.255,0.26,0.265,0.27,0.275,0.28,0.285,0.29,0.295,0.3,0.305,0.31,0.315,0.32,0.325,0.33,0.335,0.34,0.345,0.35,0.355,0.36,0.365,0.37,0.375,0.38,0.385,0.39,0.395,0.4,0.405,0.41,0.415,0.42,0.425,0.43,0.435,0.44,0.445,0.45,0.455,0.46,0.465,0.47,0.475,0.48,0.485,0.49,0.495,0.5,0.505,0.51,0.515,0.52,0.525,0.53,0.535,0.54,0.545,0.55,0.555,0.56,0.565,0.57,0.575,0.58,0.585,0.59,0.595,0.6,0.605,0.61,0.615,0.62,0.625,0.63,0.635,0.64,0.645,0.65,0.655,0.66,0.665,0.67,0.675,0.68,0.685,0.69,0.695,0.7,0.705,0.71,0.715,0.72,0.725,0.73,0.735,0.74,0.745,0.75,0.755,0.76,0.765,0.77,0.775,0.78,0.785,0.79,0.795,0.8,0.805,0.81,0.815,0.82,0.825,0.83,0.835,0.84,0.845,0.85,0.855,0.86,0.865,0.87,0.875,0.88,0.885,0.89,0.895,0.9,0.905,0.91,0.915,0.92,0.925,0.93,0.935,0.94,0.945,0.95,0.955,0.96,0.965,0.97,0.975,0.98,0.985,0.99,0.9951],keyValue=[(0.77,0.36,-1.85),(0.00,0.48,-2.00),(-0.77,0.61,-1.85),(-1.41,0.73,-1.41),(-1.85,0.85,-0.77),(-2.00,0.97,0.00),(-1.85,1.09,0.77),(-1.41,1.21,1.41),(-0.77,1.33,1.85),(0.00,1.45,2.00),(0.77,1.58,1.85),(1.41,1.70,1.41),(1.85,1.82,0.77),(2.00,1.94,0.00),(1.85,2.06,-0.77),(1.41,2.18,-1.41),(0.77,2.30,-1.85),(0.00,2.42,-2.00),(-0.77,2.55,-1.85),(-1.41,2.67,-1.41),(-1.85,2.79,-0.77),(-2.00,2.91,0.00),(-1.85,3.03,0.77),(-1.41,3.15,1.41),(-0.77,3.27,1.85),(0.00,3.39,2.00),(0.77,3.52,1.85),(1.41,3.64,1.41),(1.85,3.76,0.77),(2.00,3.88,0.00),(1.85,4.00,-0.77),(1.41,4.12,-1.41),(0.77,4.24,-1.85),(0.00,4.36,-2.00),(-0.77,4.49,-1.85),(-1.41,4.61,-1.41),(-1.85,4.73,-0.77),(-2.00,4.85,-0.00),(-1.85,4.97,0.77),(-1.41,5.09,1.41),(-0.77,5.21,1.85),(0.00,5.34,2.00),(0.77,5.46,1.85),(1.41,5.58,1.41),(1.85,5.70,0.77),(2.00,5.82,0.00),(1.85,5.94,-0.77),(1.41,6.07,-1.41),(0.77,6.19,-1.85),(-0.00,6.31,-2.00),(-0.77,6.43,-1.85),(-1.41,6.55,-1.41),(-1.85,6.68,-0.77),(-2.00,6.80,-0.00),(-2.00,6.80,0.77),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,1.33),(-2.00,6.80,0.77),(-2.00,6.80,-0.00),(-1.85,6.68,-0.77),(-1.41,6.55,-1.41),(-0.77,6.43,-1.85),(-0.00,6.31,-2.00),(0.77,6.19,-1.85),(1.41,6.07,-1.41),(1.85,5.94,-0.77),(2.00,5.82,0.00),(1.85,5.70,0.77),(1.41,5.58,1.41),(0.77,5.46,1.85),(0.00,5.34,2.00),(-0.77,5.21,1.85),(-1.41,5.09,1.41),(-1.85,4.97,0.77),(-2.00,4.85,-0.00),(-1.85,4.73,-0.77),(-1.41,4.61,-1.41),(-0.77,4.49,-1.85),(0.00,4.36,-2.00),(0.77,4.24,-1.85),(1.41,4.12,-1.41),(1.85,4.00,-0.77),(2.00,3.88,0.00),(1.85,3.76,0.77),(1.41,3.64,1.41),(0.77,3.52,1.85),(0.00,3.39,2.00),(-0.77,3.27,1.85),(-1.41,3.15,1.41),(-1.85,3.03,0.77),(-2.00,2.91,0.00),(-1.85,2.79,-0.77),(-1.41,2.67,-1.41),(-0.77,2.55,-1.85),(0.00,2.42,-2.00),(0.77,2.30,-1.85),(1.41,2.18,-1.41),(1.85,2.06,-0.77),(2.00,1.94,0.00),(1.85,1.82,0.77),(1.41,1.70,1.41),(0.77,1.58,1.85),(0.00,1.45,2.00),(-0.77,1.33,1.85),(-1.41,1.21,1.41),(-1.85,1.09,0.77),(-2.00,0.97,0.00),(-1.85,0.85,-0.77),(-1.41,0.73,-1.41),(-0.77,0.61,-1.85),(0.00,0.48,-2.00),(0.77,0.36,-1.85),(0.77,0.36,-1.85),(0.77,0.36,-1.85),(0.77,0.36,-1.85),(0.77,0.36,-1.85)]),
                  ROUTE(fromField='fraction_changed',fromNode='BlueClock',toField='set_fraction',toNode='GreenBallPath1b'),
                  Transform(DEF='GreenBallTransform1b',translation=(0.77,0.36,-1.85),
                    children=[
                    Shape(
                      geometry=Sphere(radius=.5),
                      appearance=Appearance(USE='NewGreen'))]),
                  ROUTE(fromField='value_changed',fromNode='GreenBallPath1b',toField='set_translation',toNode='GreenBallTransform1b')])])])])]),
        Transform(rotation=(0,1,0,0.31),scale=(1,1,1.09),translation=(-1.5,0,0),
          children=[
          Transform(DEF='GreenWire',rotation=(1,0,0,1.57),translation=(0,1,0),
            children=[
            Shape(
              geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(.100,0.00),(0.092,-0.038),(0.071,-0.071),(0.038,-0.092),(0.00,-.100),(-0.038,-0.092),(-0.071,-0.071),(-0.092,-0.038),(-.100,-0.00),(-0.092,0.038),(-0.071,0.071),(-0.038,0.092),(0.00,.100),(0.038,0.092),(0.071,0.071),(0.092,0.038),(.100,0.00)],spine=[(0.00,0.00,2.10),(0.00,0.00,0.40),(0.00,0.10,-0.10),(0.00,0.20,-0.40),(0.00,0.30,-0.60),(0.00,0.40,-0.75),(0.00,0.50,-0.89),(0.00,0.60,-0.98),(0.00,0.70,-1.06),(0.00,0.80,-1.12),(0.00,0.90,-1.17),(0.00,1.00,-1.21),(0.00,1.10,-1.25),(0.00,1.20,-1.29),(0.00,1.30,-1.32),(0.00,1.40,-1.35),(0.00,1.50,-1.37),(0.00,1.60,-1.39),(0.00,1.70,-1.40),(0.00,1.75,-1.40),(0.00,1.80,-1.38),(0.00,1.90,-1.35),(0.00,2.00,-1.31),(0.00,2.10,-1.26),(0.00,2.20,-1.19),(0.00,2.30,-1.05),(0.00,2.40,-0.80),(0.00,2.50,-0.52),(0.00,2.60,-0.20),(0.00,2.70,0.18),(0.00,2.80,0.48),(0.00,2.90,0.68),(0.00,3.00,0.82),(0.00,3.10,0.90),(0.00,3.20,0.95),(0.00,3.30,0.98),(0.00,3.40,1.00),(0.00,3.50,0.99),(0.00,3.60,0.98),(0.00,3.70,0.95),(0.00,3.80,0.90),(0.00,3.90,0.82),(0.00,4.00,0.68),(0.00,4.10,0.48),(0.00,4.20,0.18),(0.00,4.30,-0.20),(0.00,4.40,-0.52),(0.00,4.50,-0.80),(0.00,4.60,-1.05),(0.00,4.70,-1.19),(0.00,4.80,-1.26),(0.00,4.90,-1.31),(0.00,5.00,-1.35),(0.00,5.10,-1.38),(0.00,5.15,-1.40),(0.00,5.20,-1.40),(0.00,5.30,-1.39),(0.00,5.40,-1.37),(0.00,5.50,-1.35),(0.00,5.60,-1.32),(0.00,5.70,-1.29),(0.00,5.80,-1.25),(0.00,5.90,-1.21),(0.00,6.00,-1.17),(0.00,6.10,-1.12),(0.00,6.20,-1.06),(0.00,6.30,-0.98),(0.00,6.40,-0.89),(0.00,6.50,-0.75),(0.00,6.60,-0.40),(0.00,6.70,-0.10),(0.00,6.80,0.40),(0.00,6.80,2.10)]),
              appearance=Appearance(USE='NewGreen')),
            Transform(
              children=[
              TimeSensor(DEF='YellowClock',cycleInterval=6,loop=True),
              PositionInterpolator(DEF='YellowBallPath2',key=[0.005,0.01,0.015,0.02,0.025,0.03,0.035,0.04,0.045,0.05,0.055,0.06,0.065,0.07,0.075,0.08,0.085,0.09,0.095,0.1,0.105,0.11,0.115,0.12,0.125,0.13,0.135,0.14,0.145,0.15,0.155,0.16,0.165,0.17,0.175,0.18,0.185,0.19,0.195,0.2,0.205,0.21,0.215,0.22,0.225,0.23,0.235,0.24,0.245,0.25,0.255,0.26,0.265,0.27,0.275,0.28,0.285,0.29,0.295,0.3,0.305,0.31,0.315,0.32,0.325,0.33,0.335,0.34,0.345,0.35,0.355,0.36,0.365,0.37,0.375,0.38,0.385,0.39,0.395,0.4,0.405,0.41,0.415,0.42,0.425,0.43,0.435,0.44,0.445,0.45,0.455,0.46,0.465,0.47,0.475,0.48,0.485,0.49,0.495,0.5,0.505,0.51,0.515,0.52,0.525,0.53,0.535,0.54,0.545,0.55,0.555,0.56,0.565,0.57,0.575,0.58,0.585,0.59,0.595,0.6,0.605,0.61,0.615,0.62,0.625,0.63,0.635,0.64,0.645,0.65,0.655,0.66,0.665,0.67,0.675,0.68,0.685,0.69,0.695,0.7,0.705,0.71,0.715,0.72,0.725,0.73,0.735,0.74,0.745,0.75,0.755,0.76,0.765,0.77,0.775,0.78,0.785,0.79,0.795,0.8,0.805,0.81,0.815,0.82,0.825,0.83,0.835,0.84,0.845,0.85,0.855,0.86,0.865,0.87,0.875,0.88,0.885,0.89,0.895,0.9,0.905,0.91,0.915,0.92,0.925,0.93,0.935,0.94,0.945,0.95,0.955,0.96,0.965,0.97,0.975,0.98,0.985,0.99,0.995,1],keyValue=[(0.00,0.00,0.47),(0.00,0.00,0.10),(0.00,0.10,-0.17),(0.00,0.20,-0.43),(0.00,0.30,-0.60),(0.00,0.40,-0.75),(0.00,0.50,-0.89),(0.00,0.60,-0.98),(0.00,0.70,-1.06),(0.00,0.80,-1.12),(0.00,0.90,-1.17),(0.00,1.00,-1.21),(0.00,1.10,-1.25),(0.00,1.20,-1.29),(0.00,1.30,-1.32),(0.00,1.40,-1.35),(0.00,1.50,-1.37),(0.00,1.60,-1.39),(0.00,1.70,-1.40),(0.00,1.75,-1.40),(0.00,1.80,-1.38),(0.00,1.90,-1.35),(0.00,2.00,-1.31),(0.00,2.10,-1.26),(0.00,2.20,-1.19),(0.00,2.30,-1.05),(0.00,2.40,-0.80),(0.00,2.50,-0.52),(0.00,2.60,-0.20),(0.00,2.70,0.18),(0.00,2.80,0.48),(0.00,2.90,0.68),(0.00,3.00,0.82),(0.00,3.10,0.90),(0.00,3.20,0.95),(0.00,3.30,0.98),(0.00,3.40,1.00),(0.00,3.50,0.99),(0.00,3.60,0.98),(0.00,3.70,0.95),(0.00,3.80,0.90),(0.00,3.90,0.82),(0.00,4.00,0.68),(0.00,4.05,0.58),(0.00,4.08,0.53),(0.00,4.05,0.58),(0.00,4.00,0.68),(0.00,3.90,0.82),(0.00,3.80,0.90),(0.00,3.70,0.95),(0.00,3.60,0.98),(0.00,3.50,0.99),(0.00,3.40,1.00),(0.00,3.30,0.98),(0.00,3.20,0.95),(0.00,3.10,0.90),(0.00,3.00,0.82),(0.00,2.90,0.68),(0.00,2.84,0.58),(0.00,2.87,0.52),(0.00,2.80,0.48),(0.00,2.90,0.68),(0.00,3.00,0.82),(0.00,3.10,0.90),(0.00,3.20,0.95),(0.00,3.30,0.98),(0.00,3.40,1.00),(0.00,3.50,0.99),(0.00,3.60,0.98),(0.00,3.70,0.95),(0.00,3.80,0.90),(0.00,3.90,0.82),(0.00,4.00,0.68),(0.00,4.10,0.48),(0.00,4.20,0.18),(0.00,4.30,-0.20),(0.00,4.40,-0.52),(0.00,4.50,-0.80),(0.00,4.60,-1.05),(0.00,4.70,-1.19),(0.00,4.80,-1.26),(0.00,4.90,-1.31),(0.00,5.00,-1.35),(0.00,5.10,-1.38),(0.00,5.15,-1.40),(0.00,5.20,-1.40),(0.00,5.30,-1.39),(0.00,5.40,-1.37),(0.00,5.50,-1.35),(0.00,5.60,-1.32),(0.00,5.70,-1.29),(0.00,5.80,-1.25),(0.00,5.90,-1.21),(0.00,6.00,-1.17),(0.00,6.10,-1.12),(0.00,6.20,-1.06),(0.00,6.30,-0.98),(0.00,6.40,-0.89),(0.00,6.50,-0.75),(0.00,6.60,-0.62),(0.00,6.63,-0.55),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.65,-0.47),(0.00,6.63,-0.55),(0.00,6.60,-0.62),(0.00,6.50,-0.75),(0.00,6.40,-0.89),(0.00,6.30,-0.98),(0.00,6.20,-1.06),(0.00,6.10,-1.12),(0.00,6.00,-1.17),(0.00,5.90,-1.21),(0.00,5.80,-1.25),(0.00,5.70,-1.29),(0.00,5.60,-1.32),(0.00,5.50,-1.35),(0.00,5.40,-1.37),(0.00,5.30,-1.39),(0.00,5.20,-1.40),(0.00,5.15,-1.40),(0.00,5.10,-1.38),(0.00,5.00,-1.35),(0.00,4.90,-1.31),(0.00,4.80,-1.26),(0.00,4.70,-1.19),(0.00,4.60,-1.05),(0.00,4.50,-0.80),(0.00,4.40,-0.52),(0.00,4.30,-0.20),(0.00,4.20,0.18),(0.00,4.10,0.48),(0.00,4.00,0.68),(0.00,3.90,0.82),(0.00,3.80,0.90),(0.00,3.70,0.95),(0.00,3.60,0.98),(0.00,3.50,0.99),(0.00,3.40,1.00),(0.00,3.30,0.98),(0.00,3.20,0.95),(0.00,3.10,0.90),(0.00,3.00,0.82),(0.00,2.90,0.68),(0.00,2.80,0.48),(0.00,2.70,0.18),(0.00,2.60,-0.20),(0.00,2.50,-0.52),(0.00,2.40,-0.80),(0.00,2.30,-1.05),(0.00,2.20,-1.19),(0.00,2.10,-1.26),(0.00,2.00,-1.31),(0.00,1.90,-1.35),(0.00,1.80,-1.38),(0.00,1.75,-1.40),(0.00,1.70,-1.40),(0.00,1.60,-1.39),(0.00,1.50,-1.37),(0.00,1.40,-1.35),(0.00,1.30,-1.32),(0.00,1.20,-1.29),(0.00,1.10,-1.25),(0.00,1.00,-1.21),(0.00,0.90,-1.17),(0.00,0.80,-1.12),(0.00,0.70,-1.06),(0.00,0.60,-0.98),(0.00,0.50,-0.89),(0.00,0.40,-0.75),(0.00,0.30,-0.60),(0.00,0.20,-0.43),(0.00,0.10,-0.17),(0.00,0.00,0.10),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47),(0.00,0.00,0.47)]),
              ROUTE(fromField='fraction_changed',fromNode='YellowClock',toField='set_fraction',toNode='YellowBallPath2'),
              Transform(DEF='YellowBallTransform2',translation=(0.00,0.00,0.47),
                children=[
                Shape(
                  geometry=Sphere(radius=.5),
                  appearance=Appearance(USE='NewYellow'))]),
              ROUTE(fromField='value_changed',fromNode='YellowBallPath2',toField='set_translation',toNode='YellowBallTransform2'),
              Transform(DEF='BlueBallTransform2',translation=(0.00,6.80,.43),
                children=[
                Shape(
                  geometry=Sphere(radius=.5),
                  appearance=Appearance(USE='NewBlue'))]),
              Transform(DEF='RedBallTransform2',translation=(0.00,0.00,1.33),
                children=[
                Shape(
                  geometry=Sphere(radius=.5),
                  appearance=Appearance(USE='NewRed'))]),
              Transform(DEF='GreenBallTransform2',translation=(0.00,6.80,1.33),
                children=[
                Shape(
                  geometry=Sphere(radius=.5),
                  appearance=Appearance(USE='NewGreen'))])])])]),
        Transform(scale=(1,1,1.04),translation=(2.5,0,0),
          children=[
          Transform(DEF='BlueWire',rotation=(1,0,0,1.57),translation=(0,1,0),
            children=[
            Shape(
              geometry=Extrusion(convex=False,creaseAngle=0.785,crossSection=[(.100,0.00),(0.092,-0.038),(0.071,-0.071),(0.038,-0.092),(0.00,-.100),(-0.038,-0.092),(-0.071,-0.071),(-0.092,-0.038),(-.100,-0.00),(-0.092,0.038),(-0.071,0.071),(-0.038,0.092),(0.00,.100),(0.038,0.092),(0.071,0.071),(0.092,0.038),(.100,0.00)],spine=[(0.00,0.00,2.10),(0.00,0.00,-0.00),(0.00,0.10,-0.40),(0.00,0.20,-0.70),(0.00,0.30,-0.95),(0.00,0.40,-1.15),(0.00,0.50,-1.35),(0.00,0.60,-1.45),(0.00,0.70,-1.53),(0.00,0.80,-1.63),(0.00,0.90,-1.71),(0.00,1.00,-1.79),(0.00,1.10,-1.87),(0.00,1.20,-1.94),(0.00,1.30,-2.00),(0.00,1.40,-2.04),(0.00,1.50,-2.07),(0.00,1.60,-2.09),(0.00,1.70,-2.10),(0.00,1.75,-2.10),(0.00,1.80,-2.09),(0.00,1.90,-2.06),(0.00,2.00,-2.00),(0.00,2.10,-1.92),(0.00,2.20,-1.81),(0.00,2.30,-1.65),(0.00,2.40,-1.30),(0.00,2.50,-0.85),(0.00,2.60,-0.40),(0.00,2.70,0.10),(0.00,2.80,0.50),(0.00,2.90,0.73),(0.00,3.00,0.87),(0.00,3.10,0.97),(0.00,3.20,1.03),(0.00,3.30,1.06),(0.00,3.40,1.08),(0.00,3.50,1.06),(0.00,3.60,1.02),(0.00,3.70,0.95),(0.00,3.80,0.85),(0.00,3.90,0.70),(0.00,4.00,0.50),(0.00,4.10,0.15),(0.00,4.20,-0.35),(0.00,4.30,-0.80),(0.00,4.40,-1.15),(0.00,4.50,-1.70),(0.00,4.60,-2.05),(0.00,4.70,-2.25),(0.00,4.80,-2.40),(0.00,4.90,-2.50),(0.00,5.00,-2.56),(0.00,5.10,-2.58),(0.00,5.20,-2.56),(0.00,5.30,-2.53),(0.00,5.40,-2.49),(0.00,5.50,-2.44),(0.00,5.60,-2.38),(0.00,5.70,-2.30),(0.00,5.80,-2.18),(0.00,5.90,-2.02),(0.00,6.00,-1.82),(0.00,6.20,-1.54),(0.00,6.30,-1.18),(0.00,6.40,-0.78),(0.00,6.50,-0.35),(0.00,6.60,0.10),(0.00,6.70,0.60),(0.00,6.75,1.15),(0.00,6.80,2.10)]),
              appearance=Appearance(USE='NewBlue')),
            Transform(
              children=[
              TimeSensor(DEF='BlueWireClock',cycleInterval=13,loop=True),
              PositionInterpolator(DEF='RedBallPath3',key=[0.003,0.006,0.009,0.012,0.015,0.018,0.021,0.024,0.027,0.03,0.033,0.036,0.039,0.042,0.045,0.048,0.051,0.054,0.057,0.06,0.063,0.066,0.069,0.072,0.075,0.078,0.081,0.084,0.087,0.09,0.093,0.096,0.099,0.102,0.105,0.108,0.111,0.114,0.117,0.12,0.123,0.126,0.129,0.132,0.135,0.138,0.141,0.144,0.147,0.15,0.153,0.156,0.159,0.162,0.165,0.168,0.171,0.174,0.177,0.18,0.183,0.186,0.189,0.192,0.195,0.198,0.201,0.204,0.207,0.21,0.213,0.216,0.219,0.222,0.225,0.228,0.231,0.234,0.237,0.24,0.243,0.246,0.249,0.252,0.255,0.258,0.261,0.264,0.267,0.27,0.273,0.276,0.279,0.282,0.285,0.288,0.291,0.294,0.297,0.3,0.303,0.306,0.309,0.312,0.315,0.318,0.321,0.324,0.327,0.33,0.333,0.336,0.339,0.342,0.345,0.348,0.351,0.354,0.357,0.36,0.363,0.366,0.369,0.372,0.375,0.378,0.381,0.384,0.387,0.39,0.393,0.396,0.399,0.402,0.405,0.408,0.411,0.414,0.417,0.42,0.423,0.426,0.429,0.432,0.435,0.438,0.441,0.444,0.447,0.45,0.453,0.456,0.459,0.462,0.465,0.468,0.471,0.474,0.477,0.48,0.483,0.486,0.489,0.492,0.495,0.498,0.501,0.504,0.507,0.51,0.513,0.516,0.519,0.522,0.525,0.528,0.531,0.534,0.537,0.54,0.543,0.546,0.549,0.552,0.555,0.558,0.561,0.564,0.567,0.57,0.573,0.576,0.579,0.582,0.585,0.588,0.591,0.594,0.597,0.6,0.603,0.606,0.609,0.612,0.615,0.618,0.621,0.624,0.627,0.63,0.633,0.636,0.639,0.642,0.645,0.648,0.651,0.654,0.657,0.66,0.663,0.667,0.67,0.673,0.676,0.679,0.682,0.685,0.688,0.691,0.694,0.697,0.7,0.703,0.706,0.709,0.712,0.715,0.718,0.721,0.724,0.727,0.73,0.733,0.736,0.739,0.742,0.745,0.748,0.751,0.754,0.757,0.76,0.763,0.766,0.769,0.772,0.775,0.778,0.781,0.784,0.787,0.79,0.793,0.796,0.799,0.802,0.805,0.808,0.811,0.814,0.817,0.82,0.823,0.826,0.829,0.832,0.835,0.838,0.841,0.844,0.847,0.85,0.853,0.856,0.859,0.862,0.865,0.868,0.871,0.874,0.877,0.88,0.883,0.886,0.889,0.892,0.895,0.898,0.901,0.904,0.907,0.91,0.913,0.916,0.919,0.922,0.925,0.928,0.931,0.934,0.937,0.94,0.943,0.946,0.949,0.952,0.955,0.958,0.961,0.964,0.967,0.97,0.973,0.976,0.979,0.982,0.985,0.988,0.991,0.994,0.9971],keyValue=[(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,-0.00),(0.00,0.10,-0.40),(0.00,0.20,-0.70),(0.00,0.30,-0.95),(0.00,0.40,-1.15),(0.00,0.50,-1.35),(0.00,0.60,-1.45),(0.00,0.70,-1.53),(0.00,0.80,-1.63),(0.00,0.90,-1.71),(0.00,1.00,-1.79),(0.00,1.10,-1.87),(0.00,1.20,-1.94),(0.00,1.30,-2.00),(0.00,1.40,-2.04),(0.00,1.50,-2.07),(0.00,1.60,-2.09),(0.00,1.70,-2.10),(0.00,1.75,-2.10),(0.00,1.80,-2.09),(0.00,1.90,-2.06),(0.00,2.00,-2.00),(0.00,2.10,-1.92),(0.00,2.20,-1.81),(0.00,2.30,-1.65),(0.00,2.40,-1.30),(0.00,2.50,-0.85),(0.00,2.60,-0.40),(0.00,2.70,0.10),(0.00,2.80,0.50),(0.00,2.90,0.73),(0.00,3.00,0.87),(0.00,3.10,0.97),(0.00,3.20,1.03),(0.00,3.30,1.06),(0.00,3.40,1.08),(0.00,3.50,1.06),(0.00,3.60,1.02),(0.00,3.70,0.95),(0.00,3.80,0.85),(0.00,3.90,0.70),(0.00,4.00,0.50),(0.00,4.10,0.15),(0.00,4.20,-0.35),(0.00,4.30,-0.80),(0.00,4.40,-1.15),(0.00,4.50,-1.70),(0.00,4.60,-2.05),(0.00,4.70,-2.25),(0.00,4.80,-2.40),(0.00,4.90,-2.50),(0.00,5.00,-2.56),(0.00,5.10,-2.58),(0.00,5.20,-2.56),(0.00,5.30,-2.53),(0.00,5.40,-2.49),(0.00,5.50,-2.44),(0.00,5.60,-2.38),(0.00,5.70,-2.30),(0.00,5.80,-2.18),(0.00,5.90,-2.02),(0.00,6.00,-1.82),(0.00,6.20,-1.54),(0.00,6.30,-1.18),(0.00,6.40,-0.78),(0.00,6.43,-0.70),(0.00,6.47,-0.60),(0.00,6.50,-0.54),(0.00,6.53,-0.50),(0.00,6.55,-0.47),(0.00,6.55,-0.47),(0.00,6.55,-0.47),(0.00,6.55,-0.47),(0.00,6.55,-0.47),(0.00,6.55,-0.47),(0.00,6.55,-0.47),(0.00,6.53,-0.50),(0.00,6.51,-0.54),(0.00,6.47,-0.60),(0.00,6.44,-0.70),(0.00,6.40,-0.78),(0.00,6.30,-1.18),(0.00,6.20,-1.54),(0.00,6.00,-1.82),(0.00,5.90,-2.02),(0.00,5.80,-2.18),(0.00,5.70,-2.30),(0.00,5.60,-2.38),(0.00,5.50,-2.44),(0.00,5.40,-2.49),(0.00,5.30,-2.53),(0.00,5.20,-2.56),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.10,-2.58),(0.00,5.00,-2.56),(0.00,4.90,-2.50),(0.00,4.80,-2.40),(0.00,4.70,-2.25),(0.00,4.60,-2.05),(0.00,4.50,-1.70),(0.00,4.40,-1.15),(0.00,4.30,-0.80),(0.00,4.20,-0.35),(0.00,4.10,0.15),(0.00,4.00,0.50),(0.00,3.90,0.70),(0.00,3.80,0.85),(0.00,3.70,0.95),(0.00,3.60,1.02),(0.00,3.50,1.06),(0.00,3.40,1.08),(0.00,3.30,1.06),(0.00,3.20,1.03),(0.00,3.10,0.97),(0.00,3.00,0.87),(0.00,2.90,0.73),(0.00,2.80,0.50),(0.00,2.70,0.10),(0.00,2.60,-0.40),(0.00,2.50,-0.85),(0.00,2.40,-1.30),(0.00,2.30,-1.65),(0.00,2.20,-1.81),(0.00,2.10,-1.92),(0.00,2.00,-2.00),(0.00,1.90,-2.06),(0.00,1.80,-2.09),(0.00,1.75,-2.10),(0.00,1.70,-2.10),(0.00,1.60,-2.09),(0.00,1.50,-2.07),(0.00,1.40,-2.04),(0.00,1.30,-2.00),(0.00,1.20,-1.94),(0.00,1.10,-1.87),(0.00,1.00,-1.79),(0.00,0.90,-1.71),(0.00,0.80,-1.63),(0.00,0.70,-1.53),(0.00,0.60,-1.45),(0.00,0.50,-1.35),(0.00,0.40,-1.15),(0.00,0.30,-0.95),(0.00,0.20,-0.70),(0.00,0.10,-0.40),(0.00,0.00,-0.00),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33),(0.00,0.00,1.33)]),
              ROUTE(fromField='fraction_changed',fromNode='BlueWireClock',toField='set_fraction',toNode='RedBallPath3'),
              Transform(DEF='RedBallTransform3',translation=(0.00,0.00,1.33),
                children=[
                Shape(
                  geometry=Sphere(radius=.5),
                  appearance=Appearance(USE='NewRed'))]),
              ROUTE(fromField='value_changed',fromNode='RedBallPath3',toField='set_translation',toNode='RedBallTransform3'),
              PositionInterpolator(DEF='GreenBallPath3',key=[0.003,0.006,0.009,0.012,0.015,0.018,0.021,0.024,0.027,0.03,0.033,0.036,0.039,0.042,0.045,0.048,0.051,0.054,0.057,0.06,0.063,0.066,0.069,0.072,0.075,0.078,0.081,0.084,0.087,0.09,0.093,0.096,0.099,0.102,0.105,0.108,0.111,0.114,0.117,0.12,0.123,0.126,0.129,0.132,0.135,0.138,0.141,0.144,0.147,0.15,0.153,0.156,0.159,0.162,0.165,0.168,0.171,0.174,0.177,0.18,0.183,0.186,0.189,0.192,0.195,0.198,0.201,0.204,0.207,0.21,0.213,0.216,0.219,0.222,0.225,0.228,0.231,0.234,0.237,0.24,0.243,0.246,0.249,0.252,0.255,0.258,0.261,0.264,0.267,0.27,0.273,0.276,0.279,0.282,0.285,0.288,0.291,0.294,0.297,0.3,0.303,0.306,0.309,0.312,0.315,0.318,0.321,0.324,0.327,0.33,0.333,0.336,0.339,0.342,0.345,0.348,0.351,0.354,0.357,0.36,0.363,0.366,0.369,0.372,0.375,0.378,0.381,0.384,0.387,0.39,0.393,0.396,0.399,0.402,0.405,0.408,0.411,0.414,0.417,0.42,0.423,0.426,0.429,0.432,0.435,0.438,0.441,0.444,0.447,0.45,0.453,0.456,0.459,0.462,0.465,0.468,0.471,0.474,0.477,0.48,0.483,0.486,0.489,0.492,0.495,0.498,0.501,0.504,0.507,0.51,0.513,0.516,0.519,0.522,0.525,0.528,0.531,0.534,0.537,0.54,0.543,0.546,0.549,0.552,0.555,0.558,0.561,0.564,0.567,0.57,0.573,0.576,0.579,0.582,0.585,0.588,0.591,0.594,0.597,0.6,0.603,0.606,0.609,0.612,0.615,0.618,0.621,0.624,0.627,0.63,0.633,0.636,0.639,0.642,0.645,0.648,0.651,0.654,0.657,0.66,0.663,0.667,0.67,0.673,0.676,0.679,0.682,0.685,0.688,0.691,0.694,0.697,0.7,0.703,0.706,0.709,0.712,0.715,0.718,0.721,0.724,0.727,0.73,0.733,0.736,0.739,0.742,0.745,0.748,0.751,0.754,0.757,0.76,0.763,0.766,0.769,0.772,0.775,0.778,0.781,0.784,0.787,0.79,0.793,0.796,0.799,0.802,0.805,0.808,0.811,0.814,0.817,0.82,0.823,0.826,0.829,0.832,0.835,0.838,0.841,0.844,0.847,0.85,0.853,0.856,0.859,0.862,0.865,0.868,0.871,0.874,0.877,0.88,0.883,0.886,0.889,0.892,0.895,0.898,0.901,0.904,0.907,0.91,0.913,0.916,0.919,0.922,0.925,0.928,0.931,0.934,0.937,0.94,0.943,0.946,0.949,0.952,0.955,0.958,0.961,0.964,0.967,0.97,0.973,0.976,0.979,0.982,0.985,0.988,0.991,0.994,0.9971],keyValue=[(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,-0.00),(0.00,0.10,-0.40),(0.00,0.20,-0.70),(0.00,0.30,-0.95),(0.00,0.40,-1.15),(0.00,0.50,-1.35),(0.00,0.45,-1.39),(0.00,0.45,-1.39),(0.00,0.50,-1.35),(0.00,0.40,-1.15),(0.00,0.30,-0.95),(0.00,0.20,-0.70),(0.00,0.10,-0.40),(0.00,0.00,-0.00),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,-0.00),(0.00,0.10,-0.40),(0.00,0.20,-0.70),(0.00,0.30,-0.95),(0.00,0.40,-1.15),(0.00,0.50,-1.35),(0.00,0.60,-1.45),(0.00,0.70,-1.53),(0.00,0.80,-1.63),(0.00,0.90,-1.71),(0.00,1.00,-1.79),(0.00,1.10,-1.87),(0.00,1.20,-1.94),(0.00,1.30,-2.00),(0.00,1.40,-2.04),(0.00,1.50,-2.07),(0.00,1.60,-2.09),(0.00,1.70,-2.10),(0.00,1.75,-2.10),(0.00,1.80,-2.09),(0.00,1.90,-2.06),(0.00,2.00,-2.00),(0.00,2.10,-1.92),(0.00,2.20,-1.81),(0.00,2.30,-1.65),(0.00,2.40,-1.30),(0.00,2.50,-0.85),(0.00,2.60,-0.40),(0.00,2.70,0.10),(0.00,2.80,0.50),(0.00,2.90,0.73),(0.00,3.00,0.87),(0.00,3.10,0.97),(0.00,3.20,1.03),(0.00,3.30,1.06),(0.00,3.40,1.08),(0.00,3.50,1.06),(0.00,3.60,1.02),(0.00,3.70,0.95),(0.00,3.80,0.85),(0.00,3.90,0.70),(0.00,4.00,0.50),(0.00,4.10,0.15),(0.00,4.20,-0.35),(0.00,4.30,-0.80),(0.00,4.40,-1.15),(0.00,4.50,-1.70),(0.00,4.60,-2.05),(0.00,4.70,-2.25),(0.00,4.80,-2.40),(0.00,4.90,-2.50),(0.00,5.00,-2.56),(0.00,5.10,-2.58),(0.00,5.20,-2.56),(0.00,5.30,-2.53),(0.00,5.40,-2.49),(0.00,5.50,-2.44),(0.00,5.60,-2.38),(0.00,5.70,-2.30),(0.00,5.80,-2.18),(0.00,5.90,-2.02),(0.00,6.00,-1.82),(0.00,6.20,-1.54),(0.00,6.30,-1.18),(0.00,6.40,-0.78),(0.00,6.50,-0.35),(0.00,6.60,0.10),(0.00,6.70,0.15),(0.00,6.70,0.20),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.70,0.25),(0.00,6.70,0.20),(0.00,6.60,0.10),(0.00,6.50,-0.35),(0.00,6.40,-0.78),(0.00,6.30,-1.18),(0.00,6.20,-1.54),(0.00,6.00,-1.82),(0.00,5.90,-2.02),(0.00,5.80,-2.20),(0.00,6.00,-2.02),(0.00,5.90,-1.82),(0.00,6.20,-1.54),(0.00,6.30,-1.18),(0.00,6.40,-0.78),(0.00,6.50,-0.35),(0.00,6.60,0.10),(0.00,6.70,0.20),(0.00,6.75,0.25),(0.00,6.70,0.43),(0.00,6.70,0.43),(0.00,6.75,0.25),(0.00,6.70,0.20),(0.00,6.60,0.10),(0.00,6.50,-0.35),(0.00,6.40,-0.78),(0.00,6.30,-1.18),(0.00,6.20,-1.54),(0.00,6.00,-1.82),(0.00,5.90,-2.02),(0.00,5.80,-2.18),(0.00,5.70,-2.30),(0.00,5.60,-2.38),(0.00,5.50,-2.44),(0.00,5.40,-2.49),(0.00,5.30,-2.53),(0.00,5.20,-2.56),(0.00,5.10,-2.58),(0.00,5.00,-2.56),(0.00,4.90,-2.50),(0.00,4.80,-2.40),(0.00,4.70,-2.25),(0.00,4.60,-2.05),(0.00,4.50,-1.70),(0.00,4.40,-1.15),(0.00,4.30,-0.80),(0.00,4.20,-0.35),(0.00,4.10,0.15),(0.00,4.00,0.50),(0.00,3.90,0.70),(0.00,3.80,0.85),(0.00,3.70,0.95),(0.00,3.60,1.02),(0.00,3.50,1.06),(0.00,3.40,1.08),(0.00,3.30,1.06),(0.00,3.20,1.03),(0.00,3.10,0.97),(0.00,3.00,0.87),(0.00,2.90,0.73),(0.00,2.80,0.50),(0.00,2.70,0.10),(0.00,2.60,-0.40),(0.00,2.50,-0.85),(0.00,2.40,-1.30),(0.00,2.30,-1.65),(0.00,2.20,-1.81),(0.00,2.10,-1.92),(0.00,2.00,-2.00),(0.00,1.90,-2.06),(0.00,1.80,-2.09),(0.00,1.75,-2.10),(0.00,1.70,-2.10),(0.00,1.60,-2.09),(0.00,1.50,-2.07),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.40,-2.04),(0.00,1.30,-2.00),(0.00,1.20,-1.94),(0.00,1.10,-1.87),(0.00,1.00,-1.79),(0.00,0.90,-1.71),(0.00,0.80,-1.63),(0.00,0.70,-1.53),(0.00,0.60,-1.45),(0.00,0.50,-1.35),(0.00,0.40,-1.15),(0.00,0.30,-0.95),(0.00,0.20,-0.70),(0.00,0.10,-0.40),(0.00,0.00,-0.00),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43),(0.00,0.00,0.43)]),
              ROUTE(fromField='fraction_changed',fromNode='BlueWireClock',toField='set_fraction',toNode='GreenBallPath3'),
              Transform(DEF='GreenBallTransform3',translation=(0.00,0.00,0.43),
                children=[
                Shape(
                  geometry=Sphere(radius=.5),
                  appearance=Appearance(USE='NewGreen'))]),
              ROUTE(fromField='value_changed',fromNode='GreenBallPath3',toField='set_translation',toNode='GreenBallTransform3'),
              PositionInterpolator(DEF='YellowBallPath3',key=[0.003,0.006,0.009,0.012,0.015,0.018,0.021,0.024,0.027,0.03,0.033,0.036,0.039,0.042,0.045,0.048,0.051,0.054,0.057,0.06,0.063,0.066,0.069,0.072,0.075,0.078,0.081,0.084,0.087,0.09,0.093,0.096,0.099,0.102,0.105,0.108,0.111,0.114,0.117,0.12,0.123,0.126,0.129,0.132,0.135,0.138,0.141,0.144,0.147,0.15,0.153,0.156,0.159,0.162,0.165,0.168,0.171,0.174,0.177,0.18,0.183,0.186,0.189,0.192,0.195,0.198,0.201,0.204,0.207,0.21,0.213,0.216,0.219,0.222,0.225,0.228,0.231,0.234,0.237,0.24,0.243,0.246,0.249,0.252,0.255,0.258,0.261,0.264,0.267,0.27,0.273,0.276,0.279,0.282,0.285,0.288,0.291,0.294,0.297,0.3,0.303,0.306,0.309,0.312,0.315,0.318,0.321,0.324,0.327,0.33,0.333,0.336,0.339,0.342,0.345,0.348,0.351,0.354,0.357,0.36,0.363,0.366,0.369,0.372,0.375,0.378,0.381,0.384,0.387,0.39,0.393,0.396,0.399,0.402,0.405,0.408,0.411,0.414,0.417,0.42,0.423,0.426,0.429,0.432,0.435,0.438,0.441,0.444,0.447,0.45,0.453,0.456,0.459,0.462,0.465,0.468,0.471,0.474,0.477,0.48,0.483,0.486,0.489,0.492,0.495,0.498,0.501,0.504,0.507,0.51,0.513,0.516,0.519,0.522,0.525,0.528,0.531,0.534,0.537,0.54,0.543,0.546,0.549,0.552,0.555,0.558,0.561,0.564,0.567,0.57,0.573,0.576,0.579,0.582,0.585,0.588,0.591,0.594,0.597,0.6,0.603,0.606,0.609,0.612,0.615,0.618,0.621,0.624,0.627,0.63,0.633,0.636,0.639,0.642,0.645,0.648,0.651,0.654,0.657,0.66,0.663,0.667,0.67,0.673,0.676,0.679,0.682,0.685,0.688,0.691,0.694,0.697,0.7,0.703,0.706,0.709,0.712,0.715,0.718,0.721,0.724,0.727,0.73,0.733,0.736,0.739,0.742,0.745,0.748,0.751,0.754,0.757,0.76,0.763,0.766,0.769,0.772,0.775,0.778,0.781,0.784,0.787,0.79,0.793,0.796,0.799,0.802,0.805,0.808,0.811,0.814,0.817,0.82,0.823,0.826,0.829,0.832,0.835,0.838,0.841,0.844,0.847,0.85,0.853,0.856,0.859,0.862,0.865,0.868,0.871,0.874,0.877,0.88,0.883,0.886,0.889,0.892,0.895,0.898,0.901,0.904,0.907,0.91,0.913,0.916,0.919,0.922,0.925,0.928,0.931,0.934,0.937,0.94,0.943,0.946,0.949,0.952,0.955,0.958,0.961,0.964,0.967,0.97,0.973,0.976,0.979,0.982,0.985,0.988,0.991,0.994,0.9971],keyValue=[(0.00,0.07,-0.47),(0.00,0.07,-0.51),(0.00,0.10,-0.60),(0.00,0.20,-0.70),(0.00,0.30,-0.95),(0.00,0.30,-0.98),(0.00,0.30,-0.98),(0.00,0.30,-0.95),(0.00,0.20,-0.70),(0.00,0.10,-0.60),(0.00,0.07,-0.51),(0.00,0.07,-0.47),(0.00,0.07,-0.47),(0.00,0.07,-0.47),(0.00,0.07,-0.51),(0.00,0.10,-0.60),(0.00,0.20,-0.70),(0.00,0.30,-0.95),(0.00,0.40,-1.15),(0.00,0.50,-1.35),(0.00,0.60,-1.45),(0.00,0.70,-1.53),(0.00,0.80,-1.63),(0.00,0.80,-1.63),(0.00,0.70,-1.53),(0.00,0.60,-1.45),(0.00,0.50,-1.35),(0.00,0.40,-1.15),(0.00,0.30,-0.95),(0.00,0.20,-0.70),(0.00,0.10,-0.60),(0.00,0.07,-0.51),(0.00,0.07,-0.47),(0.00,0.07,-0.47),(0.00,0.07,-0.51),(0.00,0.10,-0.60),(0.00,0.20,-0.70),(0.00,0.30,-0.95),(0.00,0.40,-1.15),(0.00,0.50,-1.35),(0.00,0.60,-1.45),(0.00,0.70,-1.53),(0.00,0.80,-1.63),(0.00,0.90,-1.71),(0.00,1.00,-1.79),(0.00,1.10,-1.87),(0.00,1.20,-1.94),(0.00,1.30,-2.00),(0.00,1.40,-2.04),(0.00,1.50,-2.07),(0.00,1.60,-2.09),(0.00,1.70,-2.10),(0.00,1.75,-2.10),(0.00,1.80,-2.09),(0.00,1.90,-2.06),(0.00,2.00,-2.00),(0.00,2.10,-1.92),(0.00,2.20,-1.81),(0.00,2.30,-1.65),(0.00,2.40,-1.30),(0.00,2.50,-0.85),(0.00,2.60,-0.40),(0.00,2.70,0.10),(0.00,2.80,0.50),(0.00,2.90,0.73),(0.00,3.00,0.87),(0.00,3.10,0.97),(0.00,3.20,1.03),(0.00,3.30,1.06),(0.00,3.40,1.08),(0.00,3.50,1.06),(0.00,3.60,1.02),(0.00,3.70,0.95),(0.00,3.80,0.85),(0.00,3.90,0.70),(0.00,4.00,0.50),(0.00,4.10,0.15),(0.00,4.20,-0.35),(0.00,4.30,-0.80),(0.00,4.30,-0.87),(0.00,4.30,-0.89),(0.00,4.30,-0.87),(0.00,4.30,-0.80),(0.00,4.30,-0.80),(0.00,4.20,-0.35),(0.00,4.10,0.15),(0.00,4.00,0.50),(0.00,3.90,0.70),(0.00,3.80,0.85),(0.00,3.70,0.95),(0.00,3.60,1.02),(0.00,3.50,1.06),(0.00,3.40,1.08),(0.00,3.40,1.08),(0.00,3.30,1.06),(0.00,3.20,1.03),(0.00,3.10,0.97),(0.00,3.00,0.87),(0.00,2.90,0.73),(0.00,2.80,0.50),(0.00,2.70,0.10),(0.00,2.60,-0.40),(0.00,2.50,-0.85),(0.00,2.40,-1.30),(0.00,2.30,-1.65),(0.00,2.20,-1.81),(0.00,2.20,-1.85),(0.00,2.20,-1.85),(0.00,2.20,-1.81),(0.00,2.30,-1.65),(0.00,2.40,-1.30),(0.00,2.50,-0.85),(0.00,2.60,-0.40),(0.00,2.70,0.10),(0.00,2.80,0.50),(0.00,2.90,0.73),(0.00,3.00,0.87),(0.00,3.10,0.97),(0.00,3.20,1.03),(0.00,3.30,1.06),(0.00,3.40,1.08),(0.00,3.50,1.06),(0.00,3.60,1.02),(0.00,3.70,0.95),(0.00,3.80,0.85),(0.00,3.90,0.70),(0.00,4.00,0.50),(0.00,4.10,0.15),(0.00,4.20,-0.35),(0.00,4.30,-0.80),(0.00,4.40,-1.15),(0.00,4.50,-1.70),(0.00,4.60,-2.05),(0.00,4.70,-2.25),(0.00,4.80,-2.40),(0.00,4.90,-2.50),(0.00,5.00,-2.56),(0.00,5.10,-2.58),(0.00,5.20,-2.56),(0.00,5.30,-2.53),(0.00,5.40,-2.49),(0.00,5.50,-2.44),(0.00,5.60,-2.38),(0.00,5.70,-2.30),(0.00,5.80,-2.18),(0.00,5.90,-2.02),(0.00,6.00,-1.82),(0.00,6.20,-1.54),(0.00,6.30,-1.18),(0.00,6.40,-0.78),(0.00,6.50,-0.35),(0.00,6.60,0.10),(0.00,6.70,0.35),(0.00,6.75,0.75),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.80,1.33),(0.00,6.75,0.85),(0.00,6.70,0.55),(0.00,6.60,0.10),(0.00,6.50,-0.35),(0.00,6.40,-0.78),(0.00,6.30,-1.18),(0.00,6.20,-1.54),(0.00,6.00,-1.82),(0.00,5.90,-2.02),(0.00,5.80,-2.18),(0.00,5.70,-2.30),(0.00,5.60,-2.38),(0.00,5.50,-2.44),(0.00,5.40,-2.49),(0.00,5.30,-2.53),(0.00,5.20,-2.56),(0.00,5.10,-2.58),(0.00,5.00,-2.56),(0.00,4.90,-2.50),(0.00,4.80,-2.40),(0.00,4.70,-2.25),(0.00,4.60,-2.05),(0.00,4.50,-1.70),(0.00,4.40,-1.15),(0.00,4.30,-0.80),(0.00,4.20,-0.35),(0.00,4.10,0.15),(0.00,4.00,0.50),(0.00,3.90,0.70),(0.00,3.80,0.85),(0.00,3.70,0.95),(0.00,3.60,1.02),(0.00,3.50,1.06),(0.00,3.40,1.08),(0.00,3.30,1.06),(0.00,3.20,1.03),(0.00,3.10,0.97),(0.00,3.00,0.87),(0.00,2.90,0.73),(0.00,2.80,0.50),(0.00,2.70,0.10),(0.00,2.60,-0.40),(0.00,2.50,-0.85),(0.00,2.40,-1.30),(0.00,2.30,-1.65),(0.00,2.20,-1.81),(0.00,2.10,-1.92),(0.00,2.00,-2.00),(0.00,1.90,-2.06),(0.00,1.80,-2.09),(0.00,1.75,-2.10),(0.00,1.70,-2.10),(0.00,1.60,-2.09),(0.00,1.50,-2.07),(0.00,1.40,-2.04),(0.00,1.30,-2.00),(0.00,1.20,-1.94),(0.00,1.10,-1.87),(0.00,1.00,-1.79),(0.00,0.90,-1.71),(0.00,0.80,-1.63),(0.00,0.70,-1.53),(0.00,0.60,-1.45),(0.00,0.50,-1.35),(0.00,0.40,-1.15),(0.00,0.30,-0.95),(0.00,0.20,-0.70),(0.00,0.10,-0.60),(0.00,0.07,-0.530),(0.00,0.07,-0.47),(0.00,0.07,-0.47),(0.00,0.07,-0.47),(0.00,0.07,-0.47),(0.00,0.07,-0.47)]),
              ROUTE(fromField='fraction_changed',fromNode='BlueWireClock',toField='set_fraction',toNode='YellowBallPath3'),
              Transform(DEF='YellowBallTransform3',translation=(0.00,0.07,-0.47),
                children=[
                Shape(
                  geometry=Sphere(radius=.5),
                  appearance=Appearance(USE='NewYellow'))]),
              ROUTE(fromField='value_changed',fromNode='YellowBallPath3',toField='set_translation',toNode='YellowBallTransform3')])])]),
        TouchSensor(DEF='StartToySensor',description='Starts Toy Motion'),
        ROUTE(fromField='touchTime',fromNode='StartToySensor',toField='set_startTime',toNode='BlueClock'),
        ROUTE(fromField='touchTime',fromNode='StartToySensor',toField='set_startTime',toNode='YellowClock'),
        ROUTE(fromField='touchTime',fromNode='StartToySensor',toField='set_startTime',toNode='BlueWireClock')])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for IkeaBeadToy.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python IkeaBeadToy.py load and self-test diagnostics complete.")
