####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python HomeInCreteGreece.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='HomeInCreteGreece.x3d',name='title'),
    meta(content='Something Special My Home Villa In Crete Greece',name='description'),
    meta(content='Mantzouris Georgios',name='creator'),
    meta(content='27 July 2004',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/HomeInCreteGreece.x3d',name='identifier'),
    meta(content='Copyright (c) Mantzouris Georgios. 2004',name='rights'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    #  This background sky color has been taken from https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/SweetHomeLowDetail.x3d 
    children=[
    WorldInfo(title='HomeInCreteGreece.x3d'),
    Background(backUrl=["urn:web3d:media:textures/panoramas/ocean_3_back.jpg","ocean_3_back.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_3_back.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_3_back.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_3_back.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_3_back.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_3_back.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_3_back.jpg"],bottomUrl=["urn:web3d:media:textures/panoramas/ocean_3_bottom.jpg","ocean_3_bottom.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_3_bottom.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_3_bottom.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_3_bottom.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_3_bottom.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_3_bottom.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_3_bottom.jpg"],frontUrl=["urn:web3d:media:textures/panoramas/ocean_3_front.jpg","ocean_3_front.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_3_front.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_3_front.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_3_front.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_3_front.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_3_front.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_3_front.jpg"],groundAngle=[0.1,1.309,1.570796],groundColor=[(0,0,0),(0,0.1,0.3),(0,0.2,0.5),(0,0.3,0.8)],leftUrl=["urn:web3d:media:textures/panoramas/ocean_3_left.jpg","ocean_3_left.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_3_left.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_3_left.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_3_left.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_3_left.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_3_left.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_3_left.jpg"],rightUrl=["urn:web3d:media:textures/panoramas/ocean_3_right.jpg","ocean_3_right.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_3_right.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_3_right.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_3_right.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_3_right.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_3_right.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_3_right.jpg"],skyAngle=[0.1,0.15,1.309,1.571],skyColor=[(0.4,0.4,0.1),(0.4,0.4,0.1),(0,0.1,0.3),(0,0.2,0.6),(0.8,0.8,0.8)],topUrl=["urn:web3d:media:textures/panoramas/ocean_3_top.jpg","ocean_3_top.jpg","https://www.web3d.org/WorkingGroups/media/textures/panoramas/ocean_3_top.jpg","https://www.web3d.org/x3d/content/examples/Basic/UniversalMediaPanoramas/ocean_3_top.jpg","http://www.web3dmedia.com/UniversalMedia/textures/panoramas/ocean_3_top.jpg","http://www.officetowers.com/UniversalMedia/textures/panoramas/ocean_3_top.jpg","http://geometrek.com/UniversalMedia/textures/panoramas/ocean_3_top.jpg","http://www.sc.ehu.es/ccwgamoa/UniversalMedia/textures/panoramas/ocean_3_top.jpg"]),
    Viewpoint(description='FAR AWAY',position=(0,100,500)),
    Viewpoint(description='FRONT VIEW',position=(0,20,300)),
    Viewpoint(description='RIGHT VIEW',orientation=(0,1,0,1.5),position=(300,20,0)),
    Viewpoint(description='BACK VIEW',orientation=(0,1,0,-3.2),position=(0,20,-300)),
    Viewpoint(description='LEFT VIEW',orientation=(0,1,0,-1.57),position=(-300,80,-50)),
    Viewpoint(description='UP VIEW',orientation=(1,0,0,-1.57),position=(0,400,0)),
    Viewpoint(description='HELLO CRETE VIEW',position=(0,200,200)),
    Group(DEF='BASE',
      children=[
      Transform(DEF='GROUND',translation=(0,0,-75),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,1),shininess=1)),
          geometry=Box(size=(200,0.5,200)))]),
      Transform(DEF='POOL',translation=(0,-14,70),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0,0,1),emissiveColor=(0,0,1),shininess=0.8,specularColor=(0,0,1),transparency=0.8)),
          geometry=Box(size=(100,10,55)))]),
      Transform(DEF='RIGHT_FRONTYARD_WALL',translation=(52.5,-3,25),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.3,0.3,0.3),emissiveColor=(1,0,0),shininess=0.7,specularColor=(1,0,0))),
          geometry=Box(size=(95,15,0.5)))]),
      Transform(DEF='LEFT_FRONTYARD_WALL',translation=(-52.5,-3,25),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.3,0.3,0.3),emissiveColor=(1,0,0),shininess=0.7,specularColor=(1,0,0))),
          geometry=Box(size=(95,15,0.5)))]),
      Transform(DEF='FIRST_STAIR_IN_FRONT_OF_POOL',translation=(0,-8,30),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(1,1,0),shininess=0.8)),
          geometry=Box(size=(10,2,0.5)))]),
      Transform(DEF='SECOND_STAIR_IN_FRONT_OF_POOL',translation=(0,-7,29),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(1,1,0),shininess=0.8)),
          geometry=Box(size=(10,0.2,2)))]),
      Transform(DEF='THIRD_STAIR_IN_FRONT_OF_POOL',translation=(0,-6,28),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(1,1,0),shininess=0.8)),
          geometry=Box(size=(10,2,0.5)))]),
      Transform(DEF='FOURTH_STAIR_IN_FRONT_OF_POOL',translation=(0,-5,27),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(1,1,0),shininess=0.8)),
          geometry=Box(size=(10,0.2,2)))]),
      Transform(DEF='FIFTH_STAIR_IN_FRONT_OF_POOL',translation=(0,-4,26),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(1,1,0),shininess=0.8)),
          geometry=Box(size=(10,2,0.5)))]),
      Transform(DEF='SIXTH_STAIR_IN_FRONT_OF_POOL',translation=(0,-3,25),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(1,1,0),shininess=0.8)),
          geometry=Box(size=(10,0.2,1.5)))]),
      Transform(DEF='SEVENTH_STAIR_IN_FRONT_OF_POOL',translation=(0,-1.5,24.5),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(1,1,0),shininess=0.8)),
          geometry=Box(size=(10,2.5,0.5)))]),
      Transform(DEF='GROUND_IN_FRONT_OF_THE_POOL',translation=(0,-9,25),
        children=[
        Shape(
          geometry=Box(size=(200,0.2,35)),
          appearance=Appearance(
            texture=ImageTexture(DEF='GrassForCretanHouse',url=["grass.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/grass.jpg"])))]),
      Transform(DEF='GROUND_RIGHT_OF_THE_POOL',translation=(75,-9,60),
        children=[
        Shape(
          geometry=Box(size=(50,0.2,80)),
          appearance=Appearance(
            texture=ImageTexture(USE='GrassForCretanHouse')))]),
      Transform(DEF='GROUND_LEFT_OF_THE_POOL',translation=(-75,-9,60),
        children=[
        Shape(
          geometry=Box(size=(50,0.2,80)),
          appearance=Appearance(
            texture=ImageTexture(USE='GrassForCretanHouse')))]),
      Transform(DEF='RIGHT_MARGIN_OF_THE_POOL',translation=(50,-9,68),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0,0.5,0.5),emissiveColor=(0,0.5,0.5),shininess=0.8)),
          geometry=Box(size=(5,0.2,50)))]),
      Transform(DEF='LEFT_MARGIN_OF_THE_POOL',translation=(-50,-9,68),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0,0.5,0.5),emissiveColor=(0,0.5,0.5),shininess=0.8)),
          geometry=Box(size=(5,0.2,50)))]),
      Transform(DEF='MARGIN_IN_FRONT_OF_THE_POOL',translation=(0,-9,45),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0,0.5,0.5),emissiveColor=(0,0.5,0.5),shininess=0.8)),
          geometry=Box(size=(100,0.2,5)))]),
      Transform(DEF='GROUND_AT_THE_END_OF_THE_POOL',translation=(0,-9,120),
        children=[
        Shape(
          geometry=Box(size=(200,0.2,50)),
          appearance=Appearance(
            texture=ImageTexture(USE='GrassForCretanHouse')))]),
      Transform(DEF='MARGIN_AT_THE_END_OF_THE_POOL',translation=(0,-9,95),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0,0.5,0.5),emissiveColor=(0,0.5,0.5),shininess=0.8)),
          geometry=Box(size=(100,0.2,5)))]),
      Transform(DEF='WAVES_IN_POOL',translation=(0,-14,70),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(DEF='WAVES',diffuseColor=(1,0,0),emissiveColor=(1,0,0),shininess=0.7)),
          geometry=Box(size=(100,10,55))),
        TimeSensor(DEF='CLOCK_1',cycleInterval=2,loop=True),
        ColorInterpolator(DEF='COLOR_OF_THE_POOL_WAVES',key=[0.2,0.5,0.5,0.6],keyValue=[(0,0.1,0.6),(0,0.2,0.7),(0,0.3,0.8),(0,0.4,0.9)]),
        ROUTE(fromField='fraction_changed',fromNode='CLOCK_1',toField='set_fraction',toNode='COLOR_OF_THE_POOL_WAVES'),
        ROUTE(fromField='value_changed',fromNode='COLOR_OF_THE_POOL_WAVES',toField='set_emissiveColor',toNode='WAVES')]),
      Transform(DEF='SUN',rotation=(0,1,0,.45),translation=(-150,200,-75),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(DEF='SUNNY',diffuseColor=(0.5,0.5,0),emissiveColor=(0.5,0.5,0),shininess=0.9)),
          geometry=Sphere(radius=10)),
        TimeSensor(DEF='CLOCK_2',cycleInterval=2,loop=True),
        ColorInterpolator(DEF='SUN_OF_CRETE',key=[0.2,0.5,0.5,0.6],keyValue=[(0.5,0.5,0),(0.6,0.6,0),(0.7,0.7,0),(0.8,0.8,0)]),
        ROUTE(fromField='fraction_changed',fromNode='CLOCK_2',toField='set_fraction',toNode='SUN_OF_CRETE'),
        ROUTE(fromField='value_changed',fromNode='SUN_OF_CRETE',toField='set_emissiveColor',toNode='SUNNY'),
        TimeSensor(DEF='CLOCK_3',cycleInterval=100,loop=True),
        PositionInterpolator(DEF='SUN_PATH',key=[0.6,0.7,0.8,0.9,1.0,0.9,0.8,0.7,0.6],keyValue=[(-300.0,200.0,-50.0),(-50.0,210.0,-50.0),(0.0,215.0,-50.0),(50.0,220.0,-50.0),(300.0,225.0,-50.0),(50.0,220.0,-50.0),(0.0,215.0,-50.0),(-50.0,210.0,-50.0),(-300.0,190.0,-50.0)]),
        ROUTE(fromField='fraction_changed',fromNode='CLOCK_3',toField='set_fraction',toNode='SUN_PATH'),
        ROUTE(fromField='value_changed',fromNode='SUN_PATH',toField='set_translation',toNode='SUN')]),
      Transform(DEF='HELLO_CRETE',translation=(-100,200,-50),
        children=[
        Shape(
          geometry=Text(string=["Hello CRETE!"],
            fontStyle=FontStyle(size=40,style_='BOLD')),
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,0)))),
        TouchSensor(DEF='CRETAN_SONG',description='click on the text to hear a traditional cretan song'),
        Sound(minBack=5,minFront=5,
          source=AudioClip(DEF='SONG',description='traditional Cretan song',url=["pano.wav","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/pano.wav"],
            metadata=MetadataString(name='OriginalSite',value=["http://www.olymbos.org/music/pano.wav"]))),
        ROUTE(fromField='touchTime',fromNode='CRETAN_SONG',toField='set_startTime',toNode='SONG')]),
      Transform(DEF='IN_FRONT_HOUSE_WINDOW_LEFT',translation=(-85,15,0),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.3,0.3,0),transparency=0.8)),
          geometry=Box(size=(20,30,1)))]),
      Transform(DEF='IN_FRONT_OF_HOUSE_WINDOW_RIGHT',translation=(-65,15,0),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=0.5,diffuseColor=(0.3,0.3,0),transparency=0.6)),
          geometry=Box(size=(20,30,1))),
        TouchSensor(DEF='TOUCH_WINDOW_RIGHT',description='point at box to spin it'),
        TimeSensor(DEF='CLOCK_4',cycleInterval=30,enabled=False,loop=True),
        OrientationInterpolator(DEF='WINDOW_PATH',key=[0.0,0.25,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,1.57),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
        ROUTE(fromField='isOver',fromNode='TOUCH_WINDOW_RIGHT',toField='set_enabled',toNode='CLOCK_4'),
        ROUTE(fromField='fraction_changed',fromNode='CLOCK_4',toField='set_fraction',toNode='WINDOW_PATH'),
        ROUTE(fromField='value_changed',fromNode='WINDOW_PATH',toField='set_rotation',toNode='IN_FRONT_OF_HOUSE_WINDOW_RIGHT')]),
      Transform(DEF='LEFT_BASE_COLUMN',translation=(-95,15,0),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.2,0.2,0.1))),
          geometry=Box(size=(10,30,5)))]),
      Transform(DEF='SECOND_BASE_COLUMN',translation=(-50,15,0),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.2,0.2,0.1))),
          geometry=Box(size=(10,30,5)))]),
      Transform(DEF='CENTRAL_LEFT_BASE_WINDOW',translation=(-40,15,0),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.2,0.4,0.0),transparency=0.6)),
          geometry=Box(size=(10,30,1))),
        PlaneSensor(DEF='SLIDE_2',description='click and drag to open the window',maxPosition=(-40,15),minPosition=(-48,15)),
        ROUTE(fromField='translation_changed',fromNode='SLIDE_2',toField='set_translation',toNode='CENTRAL_LEFT_BASE_WINDOW')]),
      Transform(DEF='CENTRAL_RIGHT_BASE_WINDOW',translation=(-30,15,0),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.2,0.4,0.0),transparency=0.7)),
          geometry=Box(size=(10,30,1))),
        PlaneSensor(DEF='SLIDE_1',description='click and drag to open the window',maxPosition=(-22,15),minPosition=(-30,15)),
        ROUTE(fromField='translation_changed',fromNode='SLIDE_1',toField='set_translation',toNode='CENTRAL_RIGHT_BASE_WINDOW')]),
      Transform(DEF='THIRD_BASE_COLUMN',translation=(-20,15,1),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.2,0.2,0.1))),
          geometry=Box(size=(10,30,5)))]),
      Transform(DEF='RIGHT_BASE_LEFT_WINDOW',translation=(-10,15,1),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.2,0.2,0.1),transparency=0.7)),
          geometry=Box(size=(30,30,1)))]),
      Transform(DEF='BETWEEN_FRONT_DOORS',translation=(5,15,1),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.3,0.3,0.1))),
          geometry=Box(size=(1,30,1)))]),
      Transform(DEF='RIGHT_BASE_RIGHT_WINDOW',translation=(6,15,1),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.2,0.2,0.1),transparency=0.7)),
          geometry=Box(size=(30,30,1)))]),
      Transform(DEF='FOURTH_BASE_COLUMN',translation=(30,15,1),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.2,0.2,0.1))),
          geometry=Box(size=(28,30,5)))]),
      Transform(DEF='FIRST_FLOOR',translation=(0,30,0),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(1,1,1),shininess=0.9)),
          geometry=Extrusion(crossSection=[(0,0),(45,0),(100,-100),(0,-100),(-100,-100),(-100,0),(0,0)],solid=False,spine=[(0,0,0),(0,5,0)]))]),
      Transform(DEF='KAGELA_ON_ROOF',translation=(-28,40,0),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,1),shininess=1,transparency=0.5)),
          geometry=Box(size=(143,10,2)))]),
      Transform(DEF='KAGELA_RIGHT',center=(70,30,-30),rotation=(0,1,0,1.067),translation=(-7,40,-67),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(shininess=1,transparency=0.5)),
          geometry=Box(size=(50,10,2)))]),
      Transform(DEF='FIRST_FLOOR_LEFT_WALL_1',translation=(-87,50,-40),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(25,30,2)))]),
      Transform(DEF='LEFT_WALL_1',translation=(-98,15,-15),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(2,30,30)))]),
      Transform(DEF='LEFT_WINDOW',translation=(-100,20,-35),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=0.431,diffuseColor=(0.376,0.376,0.525),emissiveColor=(0.4,0.4,0.4),shininess=0.83,specularColor=(0.94,0.54,0),transparency=0.439)),
          geometry=Box(size=(0.5,10,10))),
        TouchSensor(DEF='TOUCH_LEFT_WINDOW',description='point at window to spin it'),
        TimeSensor(DEF='CLOCK_5',cycleInterval=30,enabled=False,loop=True),
        OrientationInterpolator(DEF='LEFT_WINDOW_PATH',key=[0.0,0.25,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,1.57),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
        ROUTE(fromField='isOver',fromNode='TOUCH_LEFT_WINDOW',toField='set_enabled',toNode='CLOCK_5'),
        ROUTE(fromField='fraction_changed',fromNode='CLOCK_5',toField='set_fraction',toNode='LEFT_WINDOW_PATH'),
        ROUTE(fromField='value_changed',fromNode='LEFT_WINDOW_PATH',toField='set_rotation',toNode='LEFT_WINDOW')]),
      Transform(DEF='LEFT_WALL_2',translation=(-98,15,-70),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(2,30,60)))]),
      Transform(DEF='BOTTOM_WALL_OF_LEFT_WINDOW',translation=(-98,7.2,-35),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(2,15.5,10)))]),
      Transform(DEF='UPPER_WALL_OF_LEFT_WINDOW',translation=(-98,30,-35),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(2,10,10)))]),
      Transform(DEF='BACK_WALL_1',translation=(-74,15,-100),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(50,30,2)))]),
      Transform(DEF='BACK_WALL_2',translation=(35,8,-100),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(130,15,2)))]),
      Transform(DEF='BACK_GLASS_WINDOWS',translation=(35,23,-100),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,1),transparency=0.3)),
          geometry=Box(size=(130,15,1)))]),
      Transform(DEF='RIGHT_BASE_WALL',center=(32.5,0,0),rotation=(0,1,0,2.63),translation=(0,15,-50),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(5,30,80)))]),
      Transform(DEF='RIGHT_WINDOWS_FIRST_FLOOR_1',translation=(-70,50,-40),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,1),transparency=0.3)),
          geometry=Box(size=(10,30,1)))]),
      Transform(DEF='RIGHT_WINDOW_FIRST_FLOOR_2',translation=(-60,50,-40),
        children=[
        Transform(DEF='RightWindowFirstFloor2',
          children=[
          Shape(
            geometry=Box(size=(10,30,1)),
            appearance=Appearance(DEF='WINDOW_COLOR',
              material=Material(diffuseColor=(1,1,1),transparency=0.3)))]),
        CylinderSensor(DEF='RIGHT_WINDOW_FIRST_FLOOR_2_SENSOR',description='click and drag to open the window',maxAngle=1.57),
        ROUTE(fromField='rotation_changed',fromNode='RIGHT_WINDOW_FIRST_FLOOR_2_SENSOR',toField='set_rotation',toNode='RightWindowFirstFloor2')]),
      Transform(DEF='FIRST_FLOOR_COLUMN_LEFT',translation=(-52,50,-40),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(5,30,2)))]),
      Transform(DEF='RIGHT_WINDOWS_FIRST_FLOOR_RIGHT_1',translation=(-45,50,-40),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,1),transparency=0.5)),
          geometry=Box(size=(10,30,1)))]),
      Transform(DEF='RIGHT_WINDOWS_FIRST_FLOOR_RIGHT_2',translation=(-35,50,-40),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,1),transparency=0.5)),
          geometry=Box(size=(10,30,1)))]),
      Transform(DEF='LEFT_FIRST_FLOOR_WALL',translation=(-99,50,-69),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(2,30,60)))]),
      Transform(DEF='BACK_FIRST_FLOOR_WALL',translation=(-65,50,-100),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(70,30,2)))]),
      Transform(DEF='LEFT_FIRST_FLOOR_HALF_ROOF',rotation=(0,0,1,-0.17),translation=(-100,65,-70),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,1))),
          geometry=Extrusion(DEF='ROOF',creaseAngle=3.14,crossSection=[(1,0),(1,-30),(-1,-30),(-1,0),(-1,30),(1,30)],solid=False,spine=[(0,0,0),(10,10,0),(20,20,0),(30,30,0),(0,0,0)]))]),
      Transform(DEF='RIGHT_FIRST_FLOOR_HALF_ROOF',rotation=(0,0,1,-1.4),translation=(-65,90,-70),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,1))),
          geometry=Extrusion(creaseAngle=3.14,crossSection=[(1,0),(1,-30),(-1,-30),(-1,0),(-1,30),(1,30)],solid=False,spine=[(30,30,0),(20,20,0),(10,10,0),(0,0,0)]))]),
      Transform(DEF='BACK_DOOR',translation=(-40,15,-100),
        children=[
        Transform(DEF='BackDoor',
          children=[
          Shape(
            geometry=Box(size=(19,30,1)),
            appearance=Appearance(DEF='DOOR_COLOR',
              material=Material(diffuseColor=(0.3,0,0),shininess=1))),
          CylinderSensor(DEF='BACK_DOOR_SENSOR',description='front door',maxAngle=-3.14),
          ROUTE(fromField='rotation_changed',fromNode='BACK_DOOR_SENSOR',toField='set_rotation',toNode='BackDoor')])]),
      Transform(DEF='POOL_CHAIR_1',
        children=[
        Transform(rotation=(0,1,0,-0.8),scale=(5,5,5),translation=(-80,-3,50),
          children=[
          Shape(DEF='body1',
            geometry=Extrusion(crossSection=[(3,0.1),(3,0.2),(0,0.2),(-0.25,0.1),(-0.5,0),(-0.9,-0.5),(-1.2,-1),(-1.1,-1),(-0.8,-0.5),(-0.4,0),(0,0.1),(3,0.1)],spine=[(0,0,0),(0,0,2)]),
            appearance=Appearance(
              material=Material(diffuseColor=(0,0,1),transparency=0.4)))]),
        Transform(rotation=(0,1,0,-0.8),scale=(5,5,5),translation=(-80,-3,50),
          children=[
          Shape(DEF='leg1',
            geometry=Extrusion(crossSection=[(-1.2,0.3),(-1.2,0.45),(-1.1,0.45),(-1.1,0.35),(2.9,0.35),(2.9,0.7),(3,0.7),(3,0.3),(-1.2,0.3)],spine=[(0,0,0),(0,0,0.1)]),
            appearance=Appearance(
              material=Material(diffuseColor=(0,0,1))))]),
        Transform(rotation=(0,1,0,-0.8),scale=(5,5,5),translation=(-87,-3,55),
          children=[
          Shape(DEF='leg2',
            geometry=Extrusion(crossSection=[(-1.2,0.3),(-1.2,0.45),(-1.1,0.45),(-1.1,0.35),(2.9,0.35),(2.9,0.7),(3,0.7),(3,0.3),(-1.2,0.3)],spine=[(0,0,0),(0,0,0.1)]),
            appearance=Appearance(
              material=Material(diffuseColor=(0,0,1))))]),
        #  Part from the project PoolChairUmbrella 
        CylinderSensor(DEF='Chair1Sensor',description='click and drag to move the chair',maxAngle=-3.18,minAngle=-3.14),
        ROUTE(fromField='rotation_changed',fromNode='Chair1Sensor',toField='set_rotation',toNode='POOL_CHAIR_1')]),
      Transform(DEF='POOL_CHAIR_2',
        children=[
        Transform(rotation=(0,1,0,0.8),scale=(7,7,7),translation=(-40,-3,130),
          children=[
          Shape(
            geometry=Extrusion(crossSection=[(3,0.1),(3,0.2),(0,0.2),(-0.25,0.1),(-0.5,0),(-0.9,-0.5),(-1.2,-1),(-1.1,-1),(-0.8,-0.5),(-0.4,0),(0,0.1),(3,0.1)],spine=[(0,0,0),(0,0,2)]),
            appearance=Appearance(
              material=Material(diffuseColor=(0,0,1),transparency=0.4)))]),
        Transform(rotation=(0,1,0,0.8),scale=(7,7,7),translation=(-40,-3,130),
          children=[
          Shape(
            geometry=Extrusion(crossSection=[(-1.2,0.3),(-1.2,0.45),(-1.1,0.45),(-1.1,0.35),(2.9,0.35),(2.9,0.7),(3,0.7),(3,0.3),(-1.2,0.3)],spine=[(0,0,0),(0,0,0.1)]),
            appearance=Appearance(
              material=Material(diffuseColor=(0,0,1))))]),
        Transform(rotation=(0,1,0,0.8),scale=(7,7,7),translation=(-30,-3,137),
          children=[
          Shape(
            geometry=Extrusion(crossSection=[(-1.2,0.3),(-1.2,0.45),(-1.1,0.45),(-1.1,0.35),(2.9,0.35),(2.9,0.7),(3,0.7),(3,0.3),(-1.2,0.3)],spine=[(0,0,0),(0,0,0.1)]),
            appearance=Appearance(
              material=Material(diffuseColor=(0,0,1))))]),
        #  Part from the project PoolChairUmbrella 
        CylinderSensor(DEF='Chair2Sensor',description='click and drag to move the pool chair',maxAngle=-3.14),
        ROUTE(fromField='rotation_changed',fromNode='Chair2Sensor',toField='set_rotation',toNode='POOL_CHAIR_2')]),
      Transform(DEF='FIRST_FLOOR_BALCONY_LEFT_WALL',translation=(-97.5,5,14),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
          geometry=Box(size=(5,10,22.5)))]),
      Transform(DEF='RIGHT_GROUND',translation=(150,-9,-18),
        children=[
        Shape(
          geometry=Box(size=(100,2,325)),
          appearance=Appearance(
            texture=ImageTexture(USE='GrassForCretanHouse')))]),
      Transform(DEF='RIGHT_VERTICAL_WALL',translation=(100,-5,-75),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(),),
          geometry=Box(size=(2,10,200)))]),
      Transform(DEF='MIDDLE_FIRST_FLOOR_HOUSE',
        children=[
        Transform(DEF='LEFT_FRONT_COLUMN',translation=(-28,65,-50),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(0.33,0,0))),
            geometry=Box(size=(5,60,5)))]),
        Transform(DEF='RIGHT_FRONT_COLUMN',translation=(12,65,-50),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(0.33,0,0))),
            geometry=Box(size=(5,60,5)))]),
        Transform(DEF='LEFT_FRONT_GLASS',rotation=(0,1,0,-0.5),translation=(-18,65,-45),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(shininess=1,transparency=0.5)),
            geometry=Box(size=(20,60,1)))]),
        Transform(DEF='RIGHT_FRONT_GLASS',rotation=(0,1,0,-2.7),translation=(0,65,-45),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(shininess=1,transparency=0.5)),
            geometry=Box(size=(20,60,1)))]),
        Transform(DEF='RIGHT_WALL',translation=(12,65,-75),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(0.33,0,0))),
            geometry=Box(size=(5,60,50)))]),
        Transform(DEF='LEFT_WALL',translation=(-28,80,-75),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(0.33,0,0))),
            geometry=Box(size=(5,30,50)))]),
        Transform(DEF='BACK_WALL',translation=(-10,64,-97.5),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(0.33,0,0))),
            geometry=Box(size=(40,62,5)))]),
        Transform(DEF='CEILING',translation=(-7.5,95,-70),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(0.4,0.1,0))),
            geometry=Box(size=(55,0.5,65)))]),
        Transform(DEF='CEILING_PYRAMID',translation=(-7,101,-70),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(0.4,0.1,0))),
            geometry=Cone(bottomRadius=44,height=12))]),
        Transform(DEF='SMALL_COLUMN',translation=(-30,50,-45),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(0.4,0.1,0))),
            geometry=Box(size=(5,30,10)))])]),
      Transform(DEF='RIGHT_FIRST_FLOOR_HOUSE',
        children=[
        Transform(DEF='BACK',translation=(55,55,-97.5),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
            geometry=Box(size=(85,40,5)))]),
        Transform(DEF='RIGHT_WALL_RIGHT_HOUSE',rotation=(0,1,0,2.63),translation=(80,55,-70),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=1)),
            geometry=Box(size=(5,40,60)))]),
        Transform(DEF='RIGHT_WINDOW_RIGHT_HOUSE',translation=(52,55,-43),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(1,1,1),shininess=0.5,transparency=0.2)),
            geometry=Box(size=(30,40,2)))]),
        Transform(DEF='LEFT_COLUMN_RIGHT_HOUSE',rotation=(0,1,0,2.6),translation=(25,55,-50),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(ambientIntensity=1,diffuseColor=(0.8,0.8,0),emissiveColor=(0.5,0.5,0.5),shininess=0.5)),
            geometry=Box(size=(30,40,5)))]),
        Transform(DEF='RIGHT_HOUSE_RIGHT_ROOF',translation=(55,81,-75),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(1,1,1))),
            geometry=Cone(bottomRadius=49,height=12))])]),
      Transform(DEF='FRONT_ROOF_TRIANGLE',translation=(-65,64,-41),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(),),
          geometry=Extrusion(DEF='ROOFTRIANGLE',creaseAngle=1,crossSection=[(-38,0),(38,0),(0,-26)],spine=[(0,0,0),(0,0,2)]))]),
      Transform(DEF='BACK_ROOF_TRIANGLE',translation=(-65,64,-100),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(),),
          geometry=Extrusion(USE='ROOFTRIANGLE'))]),
      Transform(DEF='LEFT_KAGELA',translation=(-100,40,-20),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,1),shininess=1,transparency=0.5)),
          geometry=Box(size=(2,10,42)))]),
      Transform(DEF='LEFT_GROUND',translation=(-150,-9,-18),
        children=[
        Shape(
          geometry=Box(size=(100,2,325)),
          appearance=Appearance(
            texture=ImageTexture(USE='GrassForCretanHouse')))]),
      Transform(DEF='LEFT_VERTICAL_WALL',translation=(-100,-5,-75),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(),),
          geometry=Box(size=(2,10,200)))]),
      Transform(DEF='BACKYARD',translation=(0,-9,-225),
        children=[
        Shape(
          geometry=Box(size=(400,1,100)),
          appearance=Appearance(
            texture=ImageTexture(USE='GrassForCretanHouse')))]),
      Transform(DEF='BACK_VERTICAL_WALL',translation=(0,-5,-175),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(),),
          geometry=Box(size=(200,10,2)))]),
      Transform(DEF='RIGHT_DOOR',rotation=(0,1,0,2.63),translation=(90,15,-83),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(1,1,1),shininess=1,transparency=0.5)),
          geometry=Box(size=(2,30,38)))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for HomeInCreteGreece.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python HomeInCreteGreece.py load and self-test diagnostics complete.")
