####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python HomeAquarium.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.1',
  head=head(
    children=[
    meta(content='HomeAquarium.x3d',name='title'),
    meta(content='Tsardas Nikolaos',name='creator'),
    meta(content='1 June 1998',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Student project showing a small aquarium.',name='description'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/HomeAquarium.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='HomeAquarium.x3d'),
    Viewpoint(description='Water tank on a table',position=(0,0,20)),
    Group(
      children=[
      Transform(
        children=[
        Transform(translation=(0.0,0.25,0.0),
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(1.0,1.0,1.0),transparency=0.5)),
            geometry=Box(size=(12.0,4.5,4.0)))]),
        Transform(
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(0,0,1),transparency=0.5)),
            geometry=Box(size=(12.0,4.0,4.0)))])]),
      Transform(translation=(0.0,-2.5,0.0),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.5,0.4,0.3))),
          geometry=Box(size=(16.0,1.0,8.0)))]),
      Transform(translation=(-7.5,-5.5,-3.5),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.5,0.4,0.3))),
          geometry=Box(size=(1.0,5.0,1.0)))]),
      Transform(translation=(7.5,-5.5,-3.5),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.5,0.4,0.3))),
          geometry=Box(size=(1.0,5.0,1.0)))]),
      Transform(translation=(-7.5,-5.5,3.5),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.5,0.4,0.3))),
          geometry=Box(size=(1.0,5.0,1.0)))]),
      Transform(translation=(7.5,-5.5,3.5),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0.5,0.4,0.3))),
          geometry=Box(size=(1.0,5.0,1.0)))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for HomeAquarium.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python HomeAquarium.py load and self-test diagnostics complete.")
