####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python FishingLure.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='FishingLure.x3d',name='title'),
    meta(content='Tom Flanders',name='creator'),
    meta(content='19 August 2001',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Unique fishing lure ("If it were any more real, I would actually be fishing"). Final project for introductory X3D course.',name='description'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/FishingLure.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    #  First position and rotate viewpoint into positive-X-Y-Z octant using a Transform 
    children=[
    WorldInfo(title='FishingLure.x3d'),
    Transform(rotation=(1,0,0,-1.57),scale=(1.6,1.6,1.6),translation=(-2,0,0),
      children=[
      Group(DEF='groupLure',
        children=[
        Shape(DEF='body',
          appearance=Appearance(
            texture=ImageTexture(repeatS=False,repeatT=False,url=["FishingLure.jpg","https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/FishingLure.jpg"]),
            material=Material(),),
          geometry=Extrusion(DEF='BodyExtrusion',beginCap=False,convex=False,creaseAngle=.76,crossSection=[(0.00,1.00),(-0.43,0.90),(-0.67,0.67),(-0.65,0.33),(-0.55,0.13),(-0.25,-0.20),(0.00,-0.30),(0.25,-0.20),(0.55,0.13),(0.65,0.33),(0.67,0.67),(0.43,0.90),(0.00,1.00)],endCap=False,scale=[(0.06,0.10),(0.12,0.20),(0.18,0.30),(0.24,0.39),(0.28,0.43),(0.32,0.47),(0.34,0.50),(0.35,0.51),(0.36,0.53),(0.36,0.53),(0.34,0.52),(0.32,0.51),(0.30,0.48),(0.28,0.47),(0.27,0.44),(0.25,0.41),(0.23,0.38),(0.21,0.35),(0.19,0.32),(0.18,0.29),(0.16,0.26),(0.14,0.23),(0.12,0.20),(0.10,0.17),(0.08,0.14),(0.07,0.11),(0.05,0.08)],solid=False,spine=[(0.10,0.00,0.00),(0.20,0.00,0.00),(0.30,0.00,0.00),(0.40,0.00,0.00),(0.50,0.00,0.00),(0.60,0.00,0.00),(0.70,0.00,0.00),(0.80,0.00,0.00),(0.90,0.00,0.00),(1.00,0.00,0.00),(1.10,0.00,0.00),(1.20,0.00,0.00),(1.30,0.00,0.00),(1.40,0.00,0.00),(1.50,0.00,0.00),(1.60,0.00,0.00),(1.70,0.00,0.00),(1.80,0.00,0.00),(1.90,0.00,0.00),(2.00,0.00,0.00),(2.10,0.00,0.00),(2.20,0.00,0.00),(2.30,0.00,0.00),(2.40,0.00,0.00),(2.50,0.00,0.00),(2.60,0.00,0.00),(2.65,0.00,0.00)]),
          #  removed final scale value: , 0.04 0.07 
          ),
        Transform(DEF='transTrebleHook1',rotation=(1,0,0,1.57),scale=(.3,.3,.3),translation=(1.00,0.00,-.23),
          children=[
          Group(DEF='groupTrebleHook',
            children=[
            Transform(DEF='transHook1',
              children=[
              Shape(DEF='hook1',
                appearance=Appearance(
                  material=Material(DEF='silverSteel',ambientIntensity=0.9)),
                geometry=Extrusion(crossSection=[(0.00,-0.05),(0.01,-0.05),(0.02,-0.05),(0.03,-0.04),(0.04,-0.04),(0.04,-0.03),(0.05,-0.02),(0.05,-0.01),(0.05,0.00),(0.05,0.01),(0.05,0.02),(0.04,0.03),(0.04,0.04),(0.03,0.04),(0.02,0.05),(0.01,0.05),(0.00,0.05),(-0.01,0.05),(-0.02,0.05),(-0.03,0.04),(-0.04,0.04),(-0.04,0.03),(-0.05,0.02),(-0.05,0.01),(-0.05,0.00),(-0.05,-0.01),(-0.05,-0.02),(-0.04,-0.03),(-0.04,-0.04),(-0.03,-0.04),(-0.02,-0.05),(-0.01,-0.05),(0.00,-0.05)],scale=[(0.60,0.60),(1.00,1.00),(1.00,1.00),(1.00,1.00),(1.00,1.00),(1.00,1.00),(1.00,1.00),(1.00,1.00),(1.00,1.00),(1.00,1.00),(1.00,1.00),(0.00,0.00)],spine=[(0.00,-0.125,0.00),(0.00,-1.25,0.00),(0.02,-1.42,0.00),(0.05,-1.51,0.00),(0.10,-1.60,0.00),(0.23,-1.73,0.00),(0.35,-1.75,0.00),(0.50,-1.73,0.00),(0.63,-1.60,0.00),(0.68,-1.50,0.00),(0.73,-1.25,0.00),(0.74,-1.00,0.00)])),
              Shape(DEF='shaBarb',
                appearance=Appearance(
                  material=Material(USE='silverSteel')),
                geometry=Extrusion(crossSection=[(0.00,-0.05),(0.01,-0.05),(0.02,-0.05),(0.03,-0.04),(0.04,-0.04),(0.04,-0.03),(0.05,-0.02),(0.05,-0.01),(0.05,0.00),(0.05,0.01),(0.05,0.02),(0.04,0.03),(0.04,0.04),(0.03,0.04),(0.02,0.05),(0.01,0.05),(0.00,0.05),(-0.01,0.05),(-0.02,0.05),(-0.03,0.04),(-0.04,0.04),(-0.04,0.03),(-0.05,0.02),(-0.05,0.01),(-0.05,0.00),(-0.05,-0.01),(-0.05,-0.02),(-0.04,-0.03),(-0.04,-0.04),(-0.03,-0.04),(-0.02,-0.05),(-0.01,-0.05),(0.00,-0.05)],scale=[(.50,.50),(0.00,0.00)],spine=[(0.71,-1.20,0.00),(0.60,-1.30,0.00)]))]),
            Transform(DEF='transHook2',rotation=(0,1,0,2.09),
              children=[
              Shape(USE='hook1'),
              Shape(USE='shaBarb')]),
            Transform(DEF='transHook3',rotation=(0,1,0,-2.09),
              children=[
              Shape(USE='hook1'),
              Shape(USE='shaBarb')]),
            Transform(DEF='transHookEye',rotation=(0,1,0,1.57),
              children=[
              Shape(DEF='shapeHookEye',
                appearance=Appearance(
                  material=Material(USE='silverSteel')),
                geometry=Extrusion(crossSection=[(0.00,-0.05),(0.01,-0.05),(0.02,-0.05),(0.03,-0.04),(0.04,-0.04),(0.04,-0.03),(0.05,-0.02),(0.05,-0.01),(0.05,0.00),(0.05,0.01),(0.05,0.02),(0.04,0.03),(0.04,0.04),(0.03,0.04),(0.02,0.05),(0.01,0.05),(0.00,0.05),(-0.01,0.05),(-0.02,0.05),(-0.03,0.04),(-0.04,0.04),(-0.04,0.03),(-0.05,0.02),(-0.05,0.01),(-0.05,0.00),(-0.05,-0.01),(-0.05,-0.02),(-0.04,-0.03),(-0.04,-0.04),(-0.03,-0.04),(-0.02,-0.05),(-0.01,-0.05),(0.00,-0.05)],scale=[(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50)],spine=[(0.00,-0.13,0.00),(0.02,-0.12,0.00),(0.04,-0.10,0.00),(0.05,-0.09,0.00),(0.07,-0.07,0.00),(0.08,-0.05,0.00),(0.09,-0.04,0.00),(0.09,-0.02,0.00),(0.10,0.00,0.00),(0.09,0.02,0.00),(0.09,0.04,0.00),(0.08,0.05,0.00),(0.07,0.07,0.00),(0.05,0.08,0.00),(0.04,0.09,0.00),(0.02,0.09,0.00),(0.00,0.10,0.00),(-0.02,0.09,0.00),(-0.04,0.09,0.00),(-0.05,0.08,0.00),(-0.07,0.07,0.00),(-0.08,0.05,0.00),(-0.09,0.04,0.00),(-0.09,0.02,0.00),(-0.10,0.00,0.00),(-0.09,-0.02,0.00),(-0.09,-0.04,0.00),(-0.08,-0.05,0.00),(-0.07,-0.07,0.00),(-0.05,-0.09,0.00),(-0.04,-0.10,0.00),(-0.02,-0.12,0.00),(0.00,-0.13,0.00)]))])])]),
        Transform(DEF='transTrebleHook2',rotation=(1,0,0,1.57),scale=(.3,.3,.3),translation=(2.70,0.00,-.04),
          children=[
          Group(USE='groupTrebleHook')]),
        Transform(DEF='transMountMiddle',rotation=(1,0,0,1.57),scale=(.7,.7,.7),translation=(1,0.00,-.15),
          children=[
          Shape(DEF='shapeMountMIddle',
            appearance=Appearance(
              material=Material(USE='silverSteel')),
            geometry=Extrusion(crossSection=[(0.00,-0.05),(0.01,-0.05),(0.02,-0.05),(0.03,-0.04),(0.04,-0.04),(0.04,-0.03),(0.05,-0.02),(0.05,-0.01),(0.05,0.00),(0.05,0.01),(0.05,0.02),(0.04,0.03),(0.04,0.04),(0.03,0.04),(0.02,0.05),(0.01,0.05),(0.00,0.05),(-0.01,0.05),(-0.02,0.05),(-0.03,0.04),(-0.04,0.04),(-0.04,0.03),(-0.05,0.02),(-0.05,0.01),(-0.05,0.00),(-0.05,-0.01),(-0.05,-0.02),(-0.04,-0.03),(-0.04,-0.04),(-0.03,-0.04),(-0.02,-0.05),(-0.01,-0.05),(0.00,-0.05)],scale=[(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35),(0.35,0.35)],spine=[(0.10,0.01,0.00),(0.10,0.00,0.00),(0.09,-0.02,0.00),(0.09,-0.04,0.00),(0.08,-0.05,0.00),(0.07,-0.07,0.00),(0.05,-0.08,0.00),(0.04,-0.09,0.00),(0.02,-0.09,0.00),(0.00,-0.10,0.00),(-0.02,-0.09,0.00),(-0.04,-0.09,0.00),(-0.05,-0.08,0.00),(-0.07,-0.07,0.00),(-0.08,-0.05,0.00),(-0.09,-0.04,0.00),(-0.09,-0.02,0.00),(-0.10,0.00,0.00),(-0.10,0.01,0.00)]))]),
        Transform(DEF='transHookMountTail',rotation=(1,0,0,1.57),scale=(.5,.5,.5),translation=(2.7,0.00,0.02),
          children=[
          Shape(DEF='shapeHookMountTail',
            appearance=Appearance(
              material=Material(USE='silverSteel')),
            geometry=Extrusion(crossSection=[(0.00,-0.05),(0.01,-0.05),(0.02,-0.05),(0.03,-0.04),(0.04,-0.04),(0.04,-0.03),(0.05,-0.02),(0.05,-0.01),(0.05,0.00),(0.05,0.01),(0.05,0.02),(0.04,0.03),(0.04,0.04),(0.03,0.04),(0.02,0.05),(0.01,0.05),(0.00,0.05),(-0.01,0.05),(-0.02,0.05),(-0.03,0.04),(-0.04,0.04),(-0.04,0.03),(-0.05,0.02),(-0.05,0.01),(-0.05,0.00),(-0.05,-0.01),(-0.05,-0.02),(-0.04,-0.03),(-0.04,-0.04),(-0.03,-0.04),(-0.02,-0.05),(-0.01,-0.05),(0.00,-0.05)],scale=[(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50)],spine=[(-0.13,0.00,0.00),(-0.12,0.02,0.00),(-0.10,0.04,0.00),(-0.09,0.05,0.00),(-0.07,0.07,0.00),(-0.05,0.08,0.00),(-0.04,0.09,0.00),(-0.02,0.09,0.00),(0.00,0.10,0.00),(0.02,0.09,0.00),(0.04,0.09,0.00),(0.05,0.08,0.00),(0.07,0.07,0.00),(0.08,0.05,0.00),(0.09,0.04,0.00),(0.09,0.02,0.00),(0.10,0.00,0.00),(0.09,-0.02,0.00),(0.09,-0.04,0.00),(0.08,-0.05,0.00),(0.07,-0.07,0.00),(0.05,-0.08,0.00),(0.04,-0.09,0.00),(0.02,-0.09,0.00),(0.00,-0.10,0.00),(-0.02,-0.09,0.00),(-0.04,-0.09,0.00),(-0.05,-0.08,0.00),(-0.07,-0.07,0.00),(-0.09,-0.05,0.00),(-0.10,-0.04,0.00),(-0.12,-0.02,0.00),(-0.13,0.00,0.00)]))]),
        Transform(DEF='transHookNose',rotation=(1,0,0,1.57),scale=(.55,.55,.55),translation=(0.06,0.00,0.04),
          children=[
          Shape(DEF='shapeHookNose',
            appearance=Appearance(
              material=Material(USE='silverSteel')),
            geometry=Extrusion(crossSection=[(0.00,-0.05),(0.01,-0.05),(0.02,-0.05),(0.03,-0.04),(0.04,-0.04),(0.04,-0.03),(0.05,-0.02),(0.05,-0.01),(0.05,0.00),(0.05,0.01),(0.05,0.02),(0.04,0.03),(0.04,0.04),(0.03,0.04),(0.02,0.05),(0.01,0.05),(0.00,0.05),(-0.01,0.05),(-0.02,0.05),(-0.03,0.04),(-0.04,0.04),(-0.04,0.03),(-0.05,0.02),(-0.05,0.01),(-0.05,0.00),(-0.05,-0.01),(-0.05,-0.02),(-0.04,-0.03),(-0.04,-0.04),(-0.03,-0.04),(-0.02,-0.05),(-0.01,-0.05),(0.00,-0.05)],scale=[(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50),(0.50,0.50)],spine=[(0.13,0.00,0.00),(0.12,0.02,0.00),(0.10,0.04,0.00),(0.09,0.05,0.00),(0.07,0.07,0.00),(0.05,0.08,0.00),(0.04,0.09,0.00),(0.02,0.09,0.00),(0.00,0.10,0.00),(-0.02,0.09,0.00),(-0.04,0.09,0.00),(-0.05,0.08,0.00),(-0.07,0.07,0.00),(-0.08,0.05,0.00),(-0.09,0.04,0.00),(-0.09,0.02,0.00),(-0.10,0.00,0.00),(-0.09,-0.02,0.00),(-0.09,-0.04,0.00),(-0.08,-0.05,0.00),(-0.07,-0.07,0.00),(-0.05,-0.08,0.00),(-0.04,-0.09,0.00),(-0.02,-0.09,0.00),(0.00,-0.10,0.00),(0.02,-0.09,0.00),(0.04,-0.09,0.00),(0.05,-0.08,0.00),(0.07,-0.07,0.00),(0.09,-0.05,0.00),(0.10,-0.04,0.00),(0.12,-0.02,0.00),(0.13,0.00,0.00)]))]),
        Transform(DEF='transLip',rotation=(0,1,0,0.785),translation=(0.75,0.2,0.02),
          children=[
          Shape(DEF='shapeLip',
            appearance=Appearance(
              material=Material(diffuseColor=(.5,.5,.5),transparency=.3)),
            geometry=Extrusion(crossSection=[(0.00,0.00),(0.00,-0.30),(0.04,-0.48),(0.08,-0.53),(0.12,-0.56),(0.20,-0.58),(0.28,-0.56),(0.32,-0.53),(0.36,-0.48),(0.40,-0.30),(0.40,0.00)],spine=[(0.00,0.00,0.00),(0.03,0.00,0.00)]))])])]),
    Background(groundAngle=[1.309,1.570796],groundColor=[(.6274,.3215,.1764)],skyAngle=[1.309,1.571],skyColor=[(.1921,.3098,.3098)])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for FishingLure.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python FishingLure.py load and self-test diagnostics complete.")
