####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python DirtBike.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='DirtBike.x3d',name='title'),
    meta(content='Simple dirt bike model.',name='description'),
    meta(content='Future work: why not make wheels rotate, as well as spokes? also need to make handle bars steerable.',name='TODO'),
    meta(content='Matthew Molmer',name='creator'),
    meta(content='25 February 2004',name='created'),
    meta(content='7 April 2024',name='modified'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/DirtBike.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='DirtBike.x3d'),
    Viewpoint(description='Closeup Side View',position=(.5,.2,1.5)),
    Viewpoint(description='sprocket view',position=(.30,.08,.38)),
    Viewpoint(description='far away side view',position=(0,0,5)),
    Group(DEF='frameGroup',
      children=[
      Transform(rotation=(0,0,1,.1),translation=(.64,.34,0),
        children=[
        Transform(rotation=(0,0,1,1.57),
          children=[
          Shape(DEF='piece_1',
            geometry=Cylinder(height=.64,radius=.02),
            appearance=Appearance(
              material=Material(diffuseColor=(1,0,0))))])]),
      Transform(rotation=(0,0,1,.50),translation=(.68,.20,0),
        children=[
        Transform(rotation=(0,0,1,1.57),
          children=[
          Shape(DEF='piece_2',
            geometry=Cylinder(height=.64,radius=.02),
            appearance=Appearance(
              material=Material(diffuseColor=(1,0,0))))])]),
      Transform(translation=(.378,.030,0),
        children=[
        Transform(rotation=(1,0,0,1.57),
          children=[
          Shape(DEF='piece_10',
            geometry=Cylinder(height=.10,radius=.03),
            appearance=Appearance(
              material=Material(diffuseColor=(1,0,0))))])]),
      Transform(rotation=(0,1,0,.087),translation=(.19,.015,.045),
        children=[
        Transform(rotation=(0,0,1,1.65),
          children=[
          Shape(DEF='piece_5',
            geometry=Cylinder(height=.38,radius=.012),
            appearance=Appearance(
              material=Material(diffuseColor=(1,0,0))))])]),
      Transform(rotation=(0,1,0,-.087),translation=(.19,.015,-.045),
        children=[
        Transform(rotation=(0,0,1,1.65),
          children=[
          Shape(DEF='piece_6',
            geometry=Cylinder(height=.38,radius=.012),
            appearance=Appearance(
              material=Material(diffuseColor=(1,0,0))))])]),
      Transform(translation=(.35,.17,0),
        children=[
        Transform(rotation=(0,0,1,.175),
          children=[
          Shape(DEF='piece_9',
            geometry=Cylinder(height=.32,radius=.02),
            appearance=Appearance(
              material=Material(diffuseColor=(1,0,0))))])]),
      Transform(
        children=[
        Transform(rotation=(1,0,0,1.57),
          children=[
          Shape(DEF='backWheelPost',
            geometry=Cylinder(height=.14,radius=.010),
            appearance=Appearance(
              material=Material(),))])]),
      Transform(translation=(1.046,.005,0),
        children=[
        Transform(rotation=(1,0,0,1.57),
          children=[
          Shape(DEF='frontWheelPost',
            geometry=Cylinder(height=.14,radius=.010),
            appearance=Appearance(
              material=Material(),))])]),
      Transform(rotation=(0,1,0,.16),translation=(.16,.16,.035),
        children=[
        Transform(rotation=(0,0,1,-.82),
          children=[
          Shape(DEF='piece_7',
            geometry=Cylinder(height=.45,radius=.010),
            appearance=Appearance(
              material=Material(diffuseColor=(1,0,0))))])]),
      Transform(rotation=(0,1,0,-.16),translation=(.16,.16,-.035),
        children=[
        Transform(rotation=(0,0,1,-.82),
          children=[
          Shape(DEF='piece_8',
            geometry=Cylinder(height=.45,radius=.010),
            appearance=Appearance(
              material=Material(diffuseColor=(1,0,0))))])]),
      Transform(rotation=(0,0,1,.175),translation=(.98,.372,0),
        children=[
        Transform(
          children=[
          Shape(DEF='piece_12',
            geometry=Cylinder(height=.058,radius=.025),
            appearance=Appearance(
              material=Material(diffuseColor=(1,0,0))))])])]),
    Group(DEF='rotatingSpokes',
      children=[
      Transform(DEF='Column',
        children=[
        Group(DEF='spokeGroup',
          children=[
          Transform(
            children=[
            Shape(DEF='spoke',
              geometry=Cylinder(height=.48,radius=0.003),
              appearance=Appearance(
                material=Material(diffuseColor=(.9,.8,.7))))]),
          Transform(rotation=(1,1,0,3.14),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,.78),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,2.35),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,.26),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,.52),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,1.30),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,1.04),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,1.83),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,2.61),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,4.71),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,4.45),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,4.18),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,3.92),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,3.66),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,3.40),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,2.87),
            children=[
            Shape(USE='spoke')]),
          Transform(rotation=(0,0,1,2.09),
            children=[
            Shape(USE='spoke')])])]),
      TimeSensor(DEF='Clock',cycleInterval=4.0,loop=True),
      OrientationInterpolator(DEF='ColumnPath',key=[0.0,0.50,1.0],keyValue=[(0.0,0.0,-1.0,0.0),(0.0,0.0,-1.0,3.14),(0.0,0.0,-1.0,6.28)]),
      ROUTE(fromField='fraction_changed',fromNode='Clock',toField='set_fraction',toNode='ColumnPath'),
      ROUTE(fromField='value_changed',fromNode='ColumnPath',toField='set_rotation',toNode='Column')]),
    Transform(translation=(1.044,0,0),
      children=[
      Group(USE='rotatingSpokes')]),
    Group(DEF='handleBarsAssembly',
      children=[
      Transform(rotation=(0,0,1,.175),scale=(.15,.15,.15),translation=(.86,.395,0),
        children=[
        Shape(DEF='handleBars',
          geometry=Extrusion(creaseAngle=3.14,crossSection=[(1.00,0.00),(0.92,-0.38),(0.71,-0.71),(0.38,-0.92),(0.00,-1.00),(-0.38,-0.92),(-0.71,-0.71),(-0.92,-0.38),(-1.00,-0.00),(-0.92,0.38),(-0.71,0.71),(-0.38,0.92),(0.00,1.00),(0.38,0.92),(0.71,0.71),(0.92,0.38),(1.00,0.00)],scale=[(.08,.08),(.08,.08),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.12,.12),(.12,.12),(.12,.12),(.12,.12),(.10,.10),(.10,.10),(.10,.10),(.08,.08),(.08,.08)],spine=[(.88,1.26,.96),(.88,1.24,.52),(.88,1.22,.50),(.88,1.20,.48),(1,.04,.42),(1,.02,.40),(1,0,.38),(1,0,0),(1,0,-.38),(1,.02,-.40),(1,.04,-.42),(.88,1.20,-.48),(.88,1.22,-.50),(.88,1.24,-.52),(.88,1.26,-.96)]),
          appearance=Appearance(
            material=Material(),))]),
      Transform(rotation=(0,0,1,.175),translation=(.98,.38,0),
        children=[
        Transform(
          children=[
          Shape(DEF='handleBarPost',
            geometry=Cylinder(height=.12,radius=.02),
            appearance=Appearance(
              material=Material(diffuseColor=(0,0,0))))])]),
      Transform(rotation=(0,0,1,.175),translation=(.98,.418,0),
        children=[
        Transform(
          children=[
          Shape(DEF='gooseNeck',
            geometry=Box(size=(.10,.040,.07)),
            appearance=Appearance(
              material=Material(diffuseColor=(0,0,0))))])]),
      Transform(rotation=(0,0,1,.175),scale=(.175,.175,.175),translation=(.818,.30,0),
        children=[
        Shape(DEF='frontForks',
          geometry=Extrusion(creaseAngle=3.14,crossSection=[(1.00,0.00),(0.92,-0.38),(0.71,-0.71),(0.38,-0.92),(0.00,-1.00),(-0.38,-0.92),(-0.71,-0.71),(-0.92,-0.38),(-1.00,-0.00),(-0.92,0.38),(-0.71,0.71),(-0.38,0.92),(0.00,1.00),(0.38,0.92),(0.71,0.71),(0.92,0.38),(1.00,0.00)],scale=[(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.04),(.10,.04),(.10,.04)],spine=[(1,-1.96,.30),(1,-1.86,.30),(1,-1.66,.30),(1,-1.76,.30),(1,-1.56,.30),(1,-1.46,.30),(1,-1.36,.30),(1,-1.22,.30),(1,-1.20,.30),(1,-.12,.30),(1,-.10,.28),(1,-.08,.26),(1,-.08,0),(1,-.08,-.26),(1,-.10,-.28),(1,-.12,-.30),(1,-1.20,-.30),(1,-1.22,-.30),(1,-1.36,-.30),(1,-1.46,-.30),(1,-1.56,-.30),(1,-1.66,-.30),(1,-1.76,-.30),(1,-1.86,-.30),(1,-1.96,-.30)]),
          appearance=Appearance(
            material=Material(diffuseColor=(0,0,0))))]),
      Transform(rotation=(1,0,0,1.58),translation=(.955,.602,.12),
        children=[
        Shape(DEF='handleGrips',
          geometry=Cylinder(height=.08,radius=.018),
          appearance=Appearance(
            material=Material(diffuseColor=(0,0,0))))]),
      Transform(rotation=(1,0,0,1.58),translation=(.955,.602,-.12),
        children=[
        Shape(USE='handleGrips')])]),
    Group(DEF='seatAssembly',
      children=[
      Transform(rotation=(0,0,1,.25),scale=(.15,.15,.15),translation=(.16,.40,0),
        children=[
        Shape(DEF='seat',
          geometry=Extrusion(creaseAngle=3.14,crossSection=[(1.00,0.00),(0.92,-0.38),(0.71,-0.71),(0.38,-0.92),(0.00,-1.00),(-0.38,-0.92),(-0.71,-0.71),(-0.92,-0.38),(-1.00,-0.00),(-0.92,0.38),(-0.71,0.71),(-0.38,0.92),(0.00,1.00),(0.38,0.92),(0.71,0.71),(0.92,0.38),(1.00,0.00)],scale=[(.10,.38),(.10,.40),(.11,.42),(.11,.44),(.10,.42),(.10,.36),(.10,.32),(.10,.26),(.08,.22),(.06,.20),(.04,.18),(.02,.16),(.02,.12)],spine=[(.40,0,0),(.42,0,0),(.44,0,0),(.54,0,0),(.64,0,0),(1,0,0),(1.24,0,0),(1.34,0,0),(1.44,0,0),(1.54,0,0),(1.56,0,0),(1.58,0,0),(1.60,0,0)]),
          appearance=Appearance(
            material=Material(diffuseColor=(0,0,1))))]),
      Transform(translation=(.335,.25,0),
        children=[
        Transform(rotation=(0,0,1,.175),
          children=[
          Shape(DEF='seatPost',
            geometry=Cylinder(height=.34,radius=.015),
            appearance=Appearance(
              material=Material(diffuseColor=(0,0,0))))])]),
      Transform(translation=(.305,.42,0),
        children=[
        Shape(DEF='seatMount',
          geometry=Box(size=(.035,.02,.035)),
          appearance=Appearance(
            material=Material(),))])]),
    Group(DEF='pedalAssembly',
      children=[
      Transform(DEF='pedalArm',scale=(.15,.15,.15),translation=(.228,.030,0),
        children=[
        Shape(
          geometry=Extrusion(creaseAngle=3.14,crossSection=[(1.00,0.00),(0.92,-0.38),(0.71,-0.71),(0.38,-0.92),(0.00,-1.00),(-0.38,-0.92),(-0.71,-0.71),(-0.92,-0.38),(-1.00,-0.00),(-0.92,0.38),(-0.71,0.71),(-0.38,0.92),(0.00,1.00),(0.38,0.92),(0.71,0.71),(0.92,0.38),(1.00,0.00)],scale=[(.08,.08),(.08,.08),(.08,.08),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.10,.10),(.08,.08),(.08,.08),(.08,.08)],spine=[(1.10,-1.12,.52),(1.10,-1.10,.50),(1,-.04,.48),(1,-.02,.46),(1,0,.44),(1,0,0),(1,0,-.44),(1,.02,-.46),(1,.04,-.48),(.88,1.10,-.50),(.88,1.12,-.52)]),
          appearance=Appearance(
            material=Material(),))]),
      Transform(translation=(.39,-.136,.1),
        children=[
        Shape(DEF='pedals',
          geometry=Box(size=(.05,.015,.06)),
          appearance=Appearance(
            material=Material(diffuseColor=(0,0,0))))]),
      Transform(translation=(.36,.20,-.1),
        children=[
        Shape(USE='pedals')])]),
    Group(DEF='rotatingSpokets',
      children=[
      Transform(DEF='Column1',scale=(.06,.06,.06),translation=(.38,.030,.04),
        children=[
        Group(DEF='spoketAssembly',
          children=[
          Transform(DEF='WHEEL',rotation=(1,0,0,1.57),
            children=[
            Transform(scale=(1,.09,1),translation=(0,.20,0),
              children=[
              Shape(DEF='center',
                geometry=Sphere(radius=.28),
                appearance=Appearance(
                  material=Material(diffuseColor=(0,0,0))))]),
            Transform(translation=(0,.1,.3)),
            Transform(
              children=[
              Group(DEF='SPOKE_GROUP',
                children=[
                Transform(DEF='SPOKE',scale=(.9,.09,.5),translation=(.6,.20,0),
                  children=[
                  Shape(DEF='inner',
                    geometry=Sphere(radius=.5),
                    appearance=Appearance(
                      material=Material(diffuseColor=(0,0,0))))]),
                Group(DEF='SURFACE',
                  children=[
                  Transform(scale=(.35,.09,.8),translation=(.95,.2,0),
                    children=[
                    Shape(DEF='outer',
                      geometry=Sphere(radius=.5),
                      appearance=Appearance(
                        material=Material(diffuseColor=(0,0,0))))]),
                  Transform(rotation=(0,1,0,.785),translation=(1.025,.2,0),
                    children=[
                    Shape(DEF='teeth',
                      geometry=Box(size=(.3,.08,.3)),
                      appearance=Appearance(
                        material=Material(diffuseColor=(0,0,0))))])]),
                Transform(rotation=(0,1,0,.53),
                  children=[
                  Group(USE='SURFACE')])]),
              Transform(rotation=(0,1,0,1.05),
                children=[
                Group(USE='SPOKE_GROUP'),
                Transform(rotation=(0,1,0,1.05),
                  children=[
                  Group(USE='SPOKE_GROUP'),
                  Transform(rotation=(0,1,0,1.05),
                    children=[
                    Group(USE='SPOKE_GROUP'),
                    Transform(rotation=(0,1,0,1.05),
                      children=[
                      Group(USE='SPOKE_GROUP'),
                      Transform(rotation=(0,1,0,1.05),
                        children=[
                        Group(USE='SPOKE_GROUP')])])])])])])])])]),
      Transform(scale=(.03,.03,.03),translation=(0,0,.05),
        children=[
        Group(USE='spoketAssembly')])]),
    Group(DEF='tireGroup',
      children=[
      Transform(rotation=(1,0,0,1.57),scale=(.26,.26,.26),
        children=[
        Shape(
          geometry=Extrusion(beginCap=False,creaseAngle=3.14,crossSection=[(1.00,0.00),(0.92,-0.38),(0.71,-0.71),(0.38,-0.92),(0.00,-1.00),(-0.38,-0.92),(-0.71,-0.71),(-0.92,-0.38),(-1.00,-0.00),(-0.92,0.38),(-0.71,0.71),(-0.38,0.92),(0.00,1.00),(0.38,0.92),(0.71,0.71),(0.92,0.38),(1.00,0.00)],endCap=False,scale=[(.96,.96),(1.1,1.1)],solid=False,spine=[(0,.07,0),(0,.07,0)]),
          appearance=Appearance(
            material=Material(diffuseColor=(0,0,0)))),
        Shape(
          geometry=Extrusion(beginCap=False,creaseAngle=3.14,crossSection=[(1.00,0.00),(0.92,-0.38),(0.71,-0.71),(0.38,-0.92),(0.00,-1.00),(-0.38,-0.92),(-0.71,-0.71),(-0.92,-0.38),(-1.00,-0.00),(-0.92,0.38),(-0.71,0.71),(-0.38,0.92),(0.00,1.00),(0.38,0.92),(0.71,0.71),(0.92,0.38),(1.00,0.00)],endCap=False,scale=[(.9,.9),(.9,.9)],solid=False,spine=[(0,.07,0),(0,-.07,0)]),
          appearance=Appearance(
            material=Material(),)),
        Shape(
          geometry=Extrusion(beginCap=False,creaseAngle=3.14,crossSection=[(1.00,0.00),(0.92,-0.38),(0.71,-0.71),(0.38,-0.92),(0.00,-1.00),(-0.38,-0.92),(-0.71,-0.71),(-0.92,-0.38),(-1.00,-0.00),(-0.92,0.38),(-0.71,0.71),(-0.38,0.92),(0.00,1.00),(0.38,0.92),(0.71,0.71),(0.92,0.38),(1.00,0.00)],endCap=False,scale=[(1.1,1.1),(1.1,1.1)],solid=False,spine=[(0,.07,0),(0,-.07,0)]),
          appearance=Appearance(
            material=Material(diffuseColor=(0,0,0)))),
        Shape(
          geometry=Extrusion(beginCap=False,creaseAngle=3.14,crossSection=[(1.00,0.00),(0.92,-0.38),(0.71,-0.71),(0.38,-0.92),(0.00,-1.00),(-0.38,-0.92),(-0.71,-0.71),(-0.92,-0.38),(-1.00,-0.00),(-0.92,0.38),(-0.71,0.71),(-0.38,0.92),(0.00,1.00),(0.38,0.92),(0.71,0.71),(0.92,0.38),(1.00,0.00)],endCap=False,scale=[(.96,.96),(1.1,1.1)],solid=False,spine=[(0,-.07,0),(0,-.07,0)]),
          appearance=Appearance(
            material=Material(diffuseColor=(0,0,0)))),
        Shape(
          geometry=Extrusion(beginCap=False,creaseAngle=3.14,crossSection=[(1.00,0.00),(0.92,-0.38),(0.71,-0.71),(0.38,-0.92),(0.00,-1.00),(-0.38,-0.92),(-0.71,-0.71),(-0.92,-0.38),(-1.00,-0.00),(-0.92,0.38),(-0.71,0.71),(-0.38,0.92),(0.00,1.00),(0.38,0.92),(0.71,0.71),(0.92,0.38),(1.00,0.00)],endCap=False,scale=[(.96,.96),(.9,.9)],solid=False,spine=[(0,.07,0),(0,.07,0)]),
          appearance=Appearance(
            material=Material(),)),
        Shape(
          geometry=Extrusion(beginCap=False,creaseAngle=3.14,crossSection=[(1.00,0.00),(0.92,-0.38),(0.71,-0.71),(0.38,-0.92),(0.00,-1.00),(-0.38,-0.92),(-0.71,-0.71),(-0.92,-0.38),(-1.00,-0.00),(-0.92,0.38),(-0.71,0.71),(-0.38,0.92),(0.00,1.00),(0.38,0.92),(0.71,0.71),(0.92,0.38),(1.00,0.00)],endCap=False,scale=[(.96,.96),(.9,.9)],solid=False,spine=[(0,-.07,0),(0,-.07,0)]),
          appearance=Appearance(
            material=Material(),))])]),
    Transform(translation=(1.044,0,0),
      children=[
      Group(USE='tireGroup')]),
    Transform(
      children=[
      Transform(rotation=(0,0,1,.165),translation=(0,-.004,.046),
        children=[
        Group(DEF='chainAssembly',
          children=[
          Transform(DEF='chainElement',rotation=(1,0,0,1.57),scale=(.04,.025,.04),translation=(.38,.042,.005),
            children=[
            Transform(translation=(0,-.12,0),
              children=[
              Shape(
                geometry=Cylinder(height=.05,radius=.15),
                appearance=Appearance(
                  material=Material(diffuseColor=(0,0,0))))]),
            Transform(translation=(0,.12,0),
              children=[
              Shape(
                geometry=Cylinder(height=.05,radius=.15),
                appearance=Appearance(
                  material=Material(diffuseColor=(0,0,0))))]),
            Transform(translation=(.4,-.12,0),
              children=[
              Shape(
                geometry=Cylinder(height=.05,radius=.15),
                appearance=Appearance(
                  material=Material(diffuseColor=(0,0,0))))]),
            Transform(translation=(.4,.12,0),
              children=[
              Shape(
                geometry=Cylinder(height=.05,radius=.15),
                appearance=Appearance(
                  material=Material(diffuseColor=(0,0,0))))]),
            Shape(
              geometry=Cylinder(height=.3,radius=.1),
              appearance=Appearance(
                material=Material(),)),
            Transform(translation=(.4,0,0),
              children=[
              Shape(
                geometry=Cylinder(height=.3,radius=.1),
                appearance=Appearance(
                  material=Material(),))]),
            Transform(translation=(.25,.12,0),
              children=[
              Shape(
                geometry=Box(size=(.3,.05,.18)),
                appearance=Appearance(
                  material=Material(diffuseColor=(0,0,0))))]),
            Transform(translation=(.25,-.12,0),
              children=[
              Shape(
                geometry=Box(size=(.3,.05,.18)),
                appearance=Appearance(
                  material=Material(diffuseColor=(0,0,0))))])]),
          Transform(
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.016,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.032,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.048,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.064,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.080,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.096,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.112,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.128,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.144,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.160,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.176,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.192,0,0),
            children=[
            Transform(USE='chainElement')]),
          Transform(translation=(-.208,0,0),
            children=[
            Transform(USE='chainElement')])]),
        Transform(translation=(-.192,0,0),
          children=[
          Group(USE='chainAssembly')])]),
      Transform(translation=(0,-.080,-.058),
        children=[
        Transform(translation=(.006,0,-.0310),
          children=[
          Transform(translation=(0,0,.135),
            children=[
            Group(USE='chainAssembly')]),
          Transform(translation=(-.192,0,.135),
            children=[
            Group(USE='chainAssembly')])])]),
      Transform(
        children=[
        Transform(translation=(.032,0,0),
          children=[
          Transform(rotation=(0,0,1,-.175),translation=(-.029,.127,.046),
            children=[
            Transform(USE='chainElement')]),
          Transform(rotation=(0,0,1,-.250),translation=(-.010,.152,.046),
            children=[
            Transform(USE='chainElement')]),
          Transform(rotation=(0,0,1,-.600),translation=(.045,.275,.046),
            children=[
            Transform(USE='chainElement')]),
          Transform(rotation=(0,0,1,.600),translation=(.0815,-.286,.046),
            children=[
            Transform(USE='chainElement')]),
          Transform(rotation=(0,0,1,-.600),translation=(.053,.266,.046),
            children=[
            Transform(USE='chainElement')])]),
        Transform(rotation=(0,0,1,-1),translation=(.145,.34,0),
          children=[
          Transform(translation=(.032,0,0),
            children=[
            Transform(rotation=(0,0,1,-.175),translation=(-.029,.127,.046),
              children=[
              Transform(USE='chainElement')]),
            Transform(rotation=(0,0,1,-.250),translation=(-.010,.152,.046),
              children=[
              Transform(USE='chainElement')]),
            Transform(rotation=(0,0,1,-.600),translation=(.045,.275,.046),
              children=[
              Transform(USE='chainElement')])])]),
        Transform(rotation=(0,0,1,-1.5),translation=(.319,.392,0),
          children=[
          Transform(translation=(.032,0,0),
            children=[
            Transform(rotation=(0,0,1,-.175),translation=(-.029,.127,.046),
              children=[
              Transform(USE='chainElement')]),
            Transform(rotation=(0,0,1,-.600),translation=(.031,.279,.046),
              children=[
              Transform(USE='chainElement')]),
            Transform(rotation=(0,0,1,2.2),translation=(.65,-.21,.046),
              children=[
              Transform(USE='chainElement')])])])]),
      Transform(rotation=(0,0,1,.790),translation=(-.275,-.278,.046),
        children=[
        Transform(USE='chainElement')]),
      Transform(rotation=(0,0,1,1.57),translation=(.004,-.376,.046),
        children=[
        Transform(USE='chainElement')]),
      Transform(rotation=(0,0,1,-.790),translation=(-.324,.215,.046),
        children=[
        Transform(USE='chainElement')]),
      Transform(rotation=(0,0,1,-1.04),translation=(-.267,.300,.046),
        children=[
        Transform(USE='chainElement')])]),
    Background(groundAngle=[1.309,1.570796],groundColor=[(.1,.2,0),(.4,.26,.3),(.6,.7,.7)],skyAngle=[1.309,1.571],skyColor=[(0,.2,.7),(0,.5,1),(1,1,1)]),
    PointLight(location=(0,1,0),radius=25)])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for DirtBike.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python DirtBike.py load and self-test diagnostics complete.")
