####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Chess8Levels.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='Chess8Levels.x3d',name='title'),
    meta(content='Multi-layered Chess Board in 3 dimensions.',name='description'),
    meta(content='John W. Carls',name='creator'),
    meta(content='9 August 2002',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='0.3',name='version'),
    meta(content='functionality incomplete for full game play',name='warning'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Chess8Levels.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    #  Multi-layered chess board construction. 
    children=[
    WorldInfo(title='Chess8Levels.x3d'),
    Group(DEF='board',
      children=[
      Transform(DEF='X_Plane',
        children=[
        Group(DEF='Row1',
          children=[
          Transform(
            children=[
            Shape(DEF='GreenSquare',
              geometry=Box(size=(1,0.01,1)),
              appearance=Appearance(
                material=Material(diffuseColor=(.25,1,.25),transparency=.125)))]),
          Transform(translation=(1,0,0),
            children=[
            Shape(DEF='BlueSquare',
              geometry=Box(size=(1,0.01,1)),
              appearance=Appearance(
                material=Material(diffuseColor=(.25,.25,1),transparency=.125)))]),
          Transform(translation=(2,0,0),
            children=[
            Shape(USE='GreenSquare')]),
          Transform(translation=(3,0,0),
            children=[
            Shape(USE='BlueSquare')]),
          Transform(translation=(-1,0,0),
            children=[
            Shape(USE='BlueSquare')]),
          Transform(translation=(-2,0,0),
            children=[
            Shape(USE='GreenSquare')]),
          Transform(translation=(-3,0,0),
            children=[
            Shape(USE='BlueSquare')]),
          Transform(translation=(-4,0,0),
            children=[
            Shape(USE='GreenSquare')])]),
        Transform(translation=(0,0,-1),
          children=[
          Group(DEF='Row2',
            children=[
            Transform(
              children=[
              Shape(USE='BlueSquare')]),
            Transform(translation=(1,0,0),
              children=[
              Shape(USE='GreenSquare')]),
            Transform(translation=(2,0,0),
              children=[
              Shape(USE='BlueSquare')]),
            Transform(translation=(3,0,0),
              children=[
              Shape(USE='GreenSquare')]),
            Transform(translation=(-1,0,0),
              children=[
              Shape(USE='GreenSquare')]),
            Transform(translation=(-2,0,0),
              children=[
              Shape(USE='BlueSquare')]),
            Transform(translation=(-3,0,0),
              children=[
              Shape(USE='GreenSquare')]),
            Transform(translation=(-4,0,0),
              children=[
              Shape(USE='BlueSquare')])])]),
        Transform(translation=(0,0,-2),
          children=[
          Group(USE='Row1')]),
        Transform(translation=(0,0,-3),
          children=[
          Group(USE='Row2')]),
        Transform(translation=(0,0,-4),
          children=[
          Group(USE='Row1')]),
        Transform(translation=(0,0,1),
          children=[
          Group(USE='Row2')]),
        Transform(translation=(0,0,2),
          children=[
          Group(USE='Row1')]),
        Transform(translation=(0,0,3),
          children=[
          Group(USE='Row2')])]),
      Transform(translation=(0,-4,0),
        children=[
        Transform(USE='X_Plane')]),
      Transform(rotation=(0,1,0,1.57),translation=(0,-3,-1),
        children=[
        Transform(USE='X_Plane')]),
      Transform(translation=(0,-2,0),
        children=[
        Transform(USE='X_Plane')]),
      Transform(rotation=(0,1,0,1.57),translation=(0,-1,-1),
        children=[
        Transform(USE='X_Plane')]),
      Transform(rotation=(0,1,0,1.57),translation=(0,1,-1),
        children=[
        Transform(USE='X_Plane')]),
      Transform(translation=(0,2,0),
        children=[
        Transform(USE='X_Plane')]),
      Transform(rotation=(0,1,0,1.57),translation=(0,3,-1),
        children=[
        Transform(USE='X_Plane')]),
      Transform(translation=(0,4,0),
        children=[
        Transform(USE='X_Plane')])]),
    Transform(DEF='RedPawn1',translation=(-4,0,-3),
      children=[
      Group(DEF='redpawn',
        children=[
        Transform(translation=(0,.415,0),
          children=[
          Transform(
            children=[
            Shape(
              geometry=Sphere(radius=.1875),
              appearance=Appearance(DEF='Red',
                material=Material(diffuseColor=(1,.25,.25))))])]),
        Group(DEF='redpiecebase',
          children=[
          Transform(DEF='chesspiecebase',translation=(0,0.04,0),
            children=[
            Shape(
              geometry=Cylinder(height=.0625,radius=.1875))]),
          Transform(DEF='redpiecepost',translation=(0,.165,0),
            children=[
            Shape(
              geometry=Cylinder(height=.25,radius=.0825),
              appearance=Appearance(USE='Red'))])])]),
      TouchSensor(DEF='RedPawn1TouchSensor'),
      TimeSensor(DEF='REDPAWN1CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedPawn1PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedPawn1PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-4,1,-2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedPawn1TouchSensor',toField='set_enabled',toNode='REDPAWN1CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDPAWN1CLOCK',toField='set_fraction',toNode='RedPawn1PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedPawn1PathInterpolator',toField='set_rotation',toNode='RedPawn1')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedPawn1PlaneSensor',toField='set_translation',toNode='RedPawn1')])]),
    Transform(DEF='RedPawn2',translation=(-3,0,-3),
      children=[
      Group(USE='redpawn'),
      TouchSensor(DEF='RedPawn2TouchSensor'),
      TimeSensor(DEF='REDPAWN2CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedPawn2PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedPawn2PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-3,-1,-2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedPawn2TouchSensor',toField='set_enabled',toNode='REDPAWN2CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDPAWN2CLOCK',toField='set_fraction',toNode='RedPawn2PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedPawn2PathInterpolator',toField='set_rotation',toNode='RedPawn2')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedPawn2PlaneSensor',toField='set_translation',toNode='RedPawn2')])]),
    Transform(DEF='RedPawn3',translation=(-2,0,-3),
      children=[
      Group(USE='redpawn'),
      TouchSensor(DEF='RedPawn3TouchSensor'),
      TimeSensor(DEF='REDPAWN3CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedPawn3PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedPawn3PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-2,1,-2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedPawn3TouchSensor',toField='set_enabled',toNode='REDPAWN3CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDPAWN3CLOCK',toField='set_fraction',toNode='RedPawn3PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedPawn3PathInterpolator',toField='set_rotation',toNode='RedPawn3')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedPawn3PlaneSensor',toField='set_translation',toNode='RedPawn3')])]),
    Transform(DEF='RedPawn4',translation=(-1,0,-3),
      children=[
      Group(USE='redpawn'),
      TouchSensor(DEF='RedPawn4TouchSensor'),
      TimeSensor(DEF='REDPAWN4CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedPawn4PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedPawn4PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-1,2,-2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedPawn4TouchSensor',toField='set_enabled',toNode='REDPAWN4CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDPAWN4CLOCK',toField='set_fraction',toNode='RedPawn4PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedPawn4PathInterpolator',toField='set_rotation',toNode='RedPawn4')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedPawn4PlaneSensor',toField='set_translation',toNode='RedPawn4')])]),
    Transform(DEF='RedPawn5',translation=(0,0,-3),
      children=[
      Group(USE='redpawn'),
      TouchSensor(DEF='RedPawn5TouchSensor'),
      TimeSensor(DEF='REDPAWN5CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedPawn5PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedPawn5PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(0,-2,-2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedPawn5TouchSensor',toField='set_enabled',toNode='REDPAWN5CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDPAWN5CLOCK',toField='set_fraction',toNode='RedPawn5PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedPawn5PathInterpolator',toField='set_rotation',toNode='RedPawn5')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedPawn5PlaneSensor',toField='set_translation',toNode='RedPawn5')])]),
    Transform(DEF='RedPawn6',translation=(1,0,-3),
      children=[
      Group(USE='redpawn'),
      TouchSensor(DEF='RedPawn6TouchSensor'),
      TimeSensor(DEF='REDPAWN6CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedPawn6PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedPawn6PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(1,1,-1)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedPawn6TouchSensor',toField='set_enabled',toNode='REDPAWN6CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDPAWN6CLOCK',toField='set_fraction',toNode='RedPawn6PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedPawn6PathInterpolator',toField='set_rotation',toNode='RedPawn6')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedPawn6PlaneSensor',toField='set_translation',toNode='RedPawn6')])]),
    Transform(DEF='RedPawn7',translation=(2,0,-3),
      children=[
      Group(USE='redpawn'),
      TouchSensor(DEF='RedPawn7TouchSensor'),
      TimeSensor(DEF='REDPAWN7CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedPawn7PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedPawn7PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(2,1,-1)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedPawn7TouchSensor',toField='set_enabled',toNode='REDPAWN7CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDPAWN7CLOCK',toField='set_fraction',toNode='RedPawn7PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedPawn7PathInterpolator',toField='set_rotation',toNode='RedPawn7')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedPawn7PlaneSensor',toField='set_translation',toNode='RedPawn7')])]),
    Transform(DEF='RedPawn8',translation=(3,0,-3),
      children=[
      Group(USE='redpawn'),
      TouchSensor(DEF='RedPawn8TouchSensor'),
      TimeSensor(DEF='REDPAWN8CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedPawn8PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedPawn8PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(3,0,-2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedPawn8TouchSensor',toField='set_enabled',toNode='REDPAWN8CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDPAWN8CLOCK',toField='set_fraction',toNode='RedPawn8PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedPawn8PathInterpolator',toField='set_rotation',toNode='RedPawn8')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedPawn8PlaneSensor',toField='set_translation',toNode='RedPawn8')])]),
    Transform(DEF='RedCastle1',translation=(-4,0,-4),
      children=[
      Group(
        children=[
        Group(USE='redpiecebase'),
        Group(
          children=[
          Transform(translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(USE='Red'))]),
          Transform(rotation=(0,1,0,0.52),translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(USE='Red'))]),
          Transform(rotation=(0,1,0,1.04),translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(USE='Red'))])])]),
      TouchSensor(DEF='RedCastle1TouchSensor'),
      TimeSensor(DEF='REDCASTLE1CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedCastle1PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedCastle1PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-4,3,-4)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedCastle1TouchSensor',toField='set_enabled',toNode='REDCASTLE1CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDCASTLE1CLOCK',toField='set_fraction',toNode='RedCastle1PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedCastle1PathInterpolator',toField='set_rotation',toNode='RedCastle1')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedCastle1PlaneSensor',toField='set_translation',toNode='RedCastle1')])]),
    Transform(DEF='RedKnight1',translation=(-3,0,-4),
      children=[
      Group(
        children=[
        Group(USE='redpiecebase'),
        Transform(translation=(0,0.45,0),
          children=[
          Shape(
            geometry=Cylinder(height=0.45,radius=0.125),
            appearance=Appearance(USE='Red'))]),
        Transform(rotation=(1,0,0,5.27),translation=(0,0.55,0.075),
          children=[
          Shape(
            geometry=Cone(bottomRadius=0.1,height=0.4),
            appearance=Appearance(USE='Red'))])]),
      TouchSensor(DEF='RedKnight1TouchSensor'),
      TimeSensor(DEF='REDKNIGHT1CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedKnight1PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedKnight1PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-2,0,-2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedKnight1TouchSensor',toField='set_enabled',toNode='REDKNIGHT1CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDKNIGHT1CLOCK',toField='set_fraction',toNode='RedKnight1PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedKnight1PathInterpolator',toField='set_rotation',toNode='RedKnight1')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedKnight1PlaneSensor',toField='set_translation',toNode='RedKnight1')])]),
    Transform(DEF='RedBishop1',translation=(-2,0,-4),
      children=[
      Group(
        children=[
        Group(USE='redpiecebase'),
        Transform(translation=(0,0.45,0),
          children=[
          Shape(
            geometry=Cone(bottomRadius=.15,height=.5),
            appearance=Appearance(USE='Red'))])]),
      TouchSensor(DEF='RedBishop1TouchSensor'),
      TimeSensor(DEF='REDBISHOP1CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedBishop1PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedBishop1PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(0,-4,-2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedBishop1TouchSensor',toField='set_enabled',toNode='REDBISHOP1CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDBISHOP1CLOCK',toField='set_fraction',toNode='RedBishop1PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedBishop1PathInterpolator',toField='set_rotation',toNode='RedBishop1')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedBishop1PlaneSensor',toField='set_translation',toNode='RedBishop1')])]),
    Transform(DEF='RedKing',translation=(-1,0,-4),
      children=[
      Group(
        children=[
        Group(USE='redpiecebase'),
        Transform(translation=(0,0.4,0),
          children=[
          Shape(
            geometry=Cone(bottomRadius=.10,height=.25),
            appearance=Appearance(USE='Red'))]),
        Transform(scale=(.035,.035,.035),translation=(0,0.4,0),
          children=[
          Shape(DEF='RedBolt',
            geometry=IndexedFaceSet(convex=False,coordIndex=[0,1,2,3,4,5,6,-1,0,12,11,10,9,8,7,-1,0,7,1,-1,1,7,8,2,-1,2,8,9,3,-1,3,9,10,4,-1,4,10,11,5,-1,5,11,12,6,-1,6,12,0],
              coord=Coordinate(point=[(0.0,0.0,0.0),(5.5,5.0,0.88),(4.0,5.5,0.968),(7.0,8.0,1.408),(4.0,9.0,1.584),(1.0,5.0,0.88),(2.5,4.5,0.792),(5.5,5.0,-0.88),(4.0,5.5,-0.968),(7.0,8.0,-1.408),(4.0,9.0,-1.584),(1.0,5.0,-0.88),(2.5,4.5,-0.792)])),
            appearance=Appearance(USE='Red')),
          Transform(rotation=(0,1,0,45),
            children=[
            Shape(USE='RedBolt')]),
          Transform(rotation=(0,1,0,90),
            children=[
            Shape(USE='RedBolt')]),
          Transform(rotation=(0,1,0,135),
            children=[
            Shape(USE='RedBolt')]),
          Transform(rotation=(0,1,0,180),
            children=[
            Shape(USE='RedBolt')]),
          Transform(rotation=(0,1,0,225),
            children=[
            Shape(USE='RedBolt')])]),
        Transform(translation=(0,.8,0),
          children=[
          Group(
            children=[
            Shape(
              geometry=Box(size=(.25,.02,.02)),
              appearance=Appearance(USE='Red')),
            Shape(
              geometry=Box(size=(.02,.25,.02)),
              appearance=Appearance(USE='Red')),
            Shape(
              geometry=Box(size=(.02,.02,.25)),
              appearance=Appearance(USE='Red'))])])]),
      TouchSensor(DEF='RedKingTouchSensor'),
      TimeSensor(DEF='REDKINGCLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedKingPathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedKingPlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-1,1,-4)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedKingTouchSensor',toField='set_enabled',toNode='REDKINGCLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDKINGCLOCK',toField='set_fraction',toNode='RedKingPathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedKingPathInterpolator',toField='set_rotation',toNode='RedKing')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedKingPlaneSensor',toField='set_translation',toNode='RedKing')])]),
    Transform(DEF='RedQueen',translation=(0,0,-4),
      children=[
      Group(
        children=[
        Group(USE='redpiecebase'),
        Transform(translation=(0,0.4,0),
          children=[
          Shape(
            geometry=Cone(bottomRadius=.10,height=.25),
            appearance=Appearance(USE='Red'))]),
        Transform(scale=(.035,.035,.035),translation=(0,0.4,0),
          children=[
          Shape(USE='RedBolt'),
          Transform(rotation=(0,1,0,45),
            children=[
            Shape(USE='RedBolt')]),
          Transform(rotation=(0,1,0,90),
            children=[
            Shape(USE='RedBolt')]),
          Transform(rotation=(0,1,0,135),
            children=[
            Shape(USE='RedBolt')]),
          Transform(rotation=(0,1,0,180),
            children=[
            Shape(USE='RedBolt')]),
          Transform(rotation=(0,1,0,225),
            children=[
            Shape(USE='RedBolt')])])]),
      TouchSensor(DEF='RedQueenTouchSensor'),
      TimeSensor(DEF='REDQUEENCLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedQueenPathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedQueenPlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(0,3,3)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedQueenTouchSensor',toField='set_enabled',toNode='REDQUEENCLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDQUEENCLOCK',toField='set_fraction',toNode='RedQueenPathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedQueenPathInterpolator',toField='set_rotation',toNode='RedQueen')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedQueenPlaneSensor',toField='set_translation',toNode='RedQueen')])]),
    Transform(DEF='RedBishop2',translation=(1,0,-4),
      children=[
      Group(
        children=[
        Group(USE='redpiecebase'),
        Transform(translation=(0,0.45,0),
          children=[
          Shape(
            geometry=Cone(bottomRadius=.15,height=.5),
            appearance=Appearance(
              material=Material(diffuseColor=(1,.25,.25))))])]),
      TouchSensor(DEF='RedBishop2TouchSensor'),
      TimeSensor(DEF='REDBISHOP2CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedBishop2PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedBishop2PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(0,4,-2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedBishop2TouchSensor',toField='set_enabled',toNode='REDBISHOP2CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDBISHOP2CLOCK',toField='set_fraction',toNode='RedBishop2PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedBishop2PathInterpolator',toField='set_rotation',toNode='RedBishop2')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedBishop2PlaneSensor',toField='set_translation',toNode='RedBishop2')])]),
    Transform(DEF='RedKnight2',translation=(2,0,-4),
      children=[
      Group(
        children=[
        Group(USE='redpiecebase'),
        Transform(translation=(0,0.45,0),
          children=[
          Shape(
            geometry=Cylinder(height=0.45,radius=0.125),
            appearance=Appearance(USE='Red'))]),
        Transform(rotation=(1,0,0,5.27),translation=(0,0.55,0.075),
          children=[
          Shape(
            geometry=Cone(bottomRadius=0.1,height=0.4),
            appearance=Appearance(USE='Red'))])]),
      TouchSensor(DEF='RedKnight2TouchSensor'),
      TimeSensor(DEF='REDKNIGHT2CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedKnight2PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedKnight2PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(0,0,-2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedKnight2TouchSensor',toField='set_enabled',toNode='REDKNIGHT2CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDKNIGHT2CLOCK',toField='set_fraction',toNode='RedKnight2PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedKnight2PathInterpolator',toField='set_rotation',toNode='RedKnight2')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedKnight2PlaneSensor',toField='set_translation',toNode='RedKnight2')])]),
    Transform(DEF='RedCastle2',translation=(3,0,-4),
      children=[
      Group(
        children=[
        Group(USE='redpiecebase'),
        Group(
          children=[
          Transform(translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(
                material=Material(diffuseColor=(1,.25,.25))))]),
          Transform(rotation=(0,1,0,0.52),translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(
                material=Material(diffuseColor=(1,.25,.25))))]),
          Transform(rotation=(0,1,0,1.04),translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(
                material=Material(diffuseColor=(1,.25,.25))))])])]),
      TouchSensor(DEF='RedCastle2TouchSensor'),
      TimeSensor(DEF='REDCASTLE2CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='RedCastle2PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='RedCastle2PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(3,-4,-4)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='RedCastle2TouchSensor',toField='set_enabled',toNode='REDCASTLE2CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='REDCASTLE2CLOCK',toField='set_fraction',toNode='RedCastle2PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='RedCastle2PathInterpolator',toField='set_rotation',toNode='RedCastle2')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='RedCastle2PlaneSensor',toField='set_translation',toNode='RedCastle2')])]),
    Transform(DEF='BluePawn1',translation=(-4,0,2),
      children=[
      Group(DEF='aquapawn',
        children=[
        Transform(translation=(0,.415,0),
          children=[
          Transform(
            children=[
            Shape(
              geometry=Sphere(radius=.1875),
              appearance=Appearance(DEF='Aqua',
                material=Material(diffuseColor=(.25,1,1))))])]),
        Group(DEF='bluepiecebase',
          children=[
          Transform(translation=(0,0.04,0),
            children=[
            Shape(
              geometry=Cylinder(height=.0625,radius=.1875))]),
          Transform(DEF='bluepiecepost',translation=(0,.165,0),
            children=[
            Shape(
              geometry=Cylinder(height=.25,radius=.0825),
              appearance=Appearance(USE='Aqua'))])])]),
      TouchSensor(DEF='BluePawn1TouchSensor'),
      TimeSensor(DEF='BLUEPAWN1CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BluePawn1PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BluePawn1PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-4,1,2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BluePawn1TouchSensor',toField='set_enabled',toNode='BLUEPAWN1CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEPAWN1CLOCK',toField='set_fraction',toNode='BluePawn1PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BluePawn1PathInterpolator',toField='set_rotation',toNode='BluePawn1')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BluePawn1PlaneSensor',toField='set_translation',toNode='BluePawn1')])]),
    Transform(DEF='BluePawn2',translation=(-3,0,2),
      children=[
      Group(USE='aquapawn'),
      TouchSensor(DEF='BluePawn2TouchSensor'),
      TimeSensor(DEF='BLUEPAWN2CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BluePawn2PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BluePawn2PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-3,1,1)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BluePawn2TouchSensor',toField='set_enabled',toNode='BLUEPAWN2CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEPAWN2CLOCK',toField='set_fraction',toNode='BluePawn2PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BluePawn2PathInterpolator',toField='set_rotation',toNode='BluePawn2')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BluePawn2PlaneSensor',toField='set_translation',toNode='BluePawn2')])]),
    Transform(DEF='BluePawn3',translation=(-2,0,2),
      children=[
      Group(USE='aquapawn'),
      TouchSensor(DEF='BluePawn3TouchSensor'),
      TimeSensor(DEF='BLUEPAWN3CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BluePawn3PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BluePawn3PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-2,2,2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BluePawn3TouchSensor',toField='set_enabled',toNode='BLUEPAWN3CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEPAWN3CLOCK',toField='set_fraction',toNode='BluePawn3PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BluePawn3PathInterpolator',toField='set_rotation',toNode='BluePawn3')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BluePawn3PlaneSensor',toField='set_translation',toNode='BluePawn3')])]),
    Transform(DEF='BluePawn4',translation=(-1,0,2),
      children=[
      Group(USE='aquapawn'),
      TouchSensor(DEF='BluePawn4TouchSensor'),
      TimeSensor(DEF='BLUEPAWN4CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BluePawn4PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BluePawn4PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-1,1,2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BluePawn4TouchSensor',toField='set_enabled',toNode='BLUEPAWN4CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEPAWN4CLOCK',toField='set_fraction',toNode='BluePawn4PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BluePawn4PathInterpolator',toField='set_rotation',toNode='BluePawn4')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BluePawn4PlaneSensor',toField='set_translation',toNode='BluePawn4')])]),
    Transform(DEF='BluePawn5',translation=(0,0,2),
      children=[
      Group(USE='aquapawn'),
      TouchSensor(DEF='BluePawn5TouchSensor'),
      TimeSensor(DEF='BLUEPAWN5CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BluePawn5PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BluePawn5PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(0,-1,1)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BluePawn5TouchSensor',toField='set_enabled',toNode='BLUEPAWN5CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEPAWN5CLOCK',toField='set_fraction',toNode='BluePawn5PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BluePawn5PathInterpolator',toField='set_rotation',toNode='BluePawn5')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BluePawn5PlaneSensor',toField='set_translation',toNode='BluePawn5')])]),
    Transform(DEF='BluePawn6',translation=(1,0,2),
      children=[
      Group(USE='aquapawn'),
      TouchSensor(DEF='BluePawn6TouchSensor'),
      TimeSensor(DEF='BLUEPAWN6CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BluePawn6PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BluePawn6PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(1,1,1)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BluePawn6TouchSensor',toField='set_enabled',toNode='BLUEPAWN6CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEPAWN6CLOCK',toField='set_fraction',toNode='BluePawn6PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BluePawn6PathInterpolator',toField='set_rotation',toNode='BluePawn6')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BluePawn6PlaneSensor',toField='set_translation',toNode='BluePawn6')])]),
    Transform(DEF='BluePawn7',translation=(2,0,2),
      children=[
      Group(USE='aquapawn'),
      TouchSensor(DEF='BluePawn7TouchSensor'),
      TimeSensor(DEF='BLUEPAWN7CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BluePawn7PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BluePawn7PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(2,1,2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BluePawn7TouchSensor',toField='set_enabled',toNode='BLUEPAWN7CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEPAWN7CLOCK',toField='set_fraction',toNode='BluePawn7PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BluePawn7PathInterpolator',toField='set_rotation',toNode='BluePawn7')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BluePawn7PlaneSensor',toField='set_translation',toNode='BluePawn7')])]),
    Transform(DEF='BluePawn8',translation=(3,0,2),
      children=[
      Group(USE='aquapawn'),
      TouchSensor(DEF='BluePawn8TouchSensor'),
      TimeSensor(DEF='BLUEPAWN8CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BluePawn8PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BluePawn8PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(3,1,2)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BluePawn8TouchSensor',toField='set_enabled',toNode='BLUEPAWN8CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEPAWN8CLOCK',toField='set_fraction',toNode='BluePawn8PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BluePawn8PathInterpolator',toField='set_rotation',toNode='BluePawn8')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BluePawn8PlaneSensor',toField='set_translation',toNode='BluePawn8')])]),
    Transform(DEF='BlueCastle1',translation=(-4,0,3),
      children=[
      Group(
        children=[
        Group(USE='bluepiecebase'),
        Group(
          children=[
          Transform(translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(USE='Aqua'))]),
          Transform(rotation=(0,1,0,0.52),translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(USE='Aqua'))]),
          Transform(rotation=(0,1,0,1.04),translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(USE='Aqua'))])])]),
      TouchSensor(DEF='BlueCastle1TouchSensor'),
      TimeSensor(DEF='BLUECASTLE1CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BlueCastle1PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BlueCastle1PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-4,4,3)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BlueCastle1TouchSensor',toField='set_enabled',toNode='BLUECASTLE1CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUECASTLE1CLOCK',toField='set_fraction',toNode='BlueCastle1PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BlueCastle1PathInterpolator',toField='set_rotation',toNode='BlueCastle1')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BlueCastle1PlaneSensor',toField='set_translation',toNode='BlueCastle1')])]),
    Transform(DEF='BlueKnight1',translation=(-3,0,3),
      children=[
      Group(
        children=[
        Group(USE='bluepiecebase'),
        Transform(translation=(0,0.45,0),
          children=[
          Shape(
            geometry=Cylinder(height=0.45,radius=0.125),
            appearance=Appearance(USE='Aqua'))]),
        Transform(rotation=(-1,0,0,5.27),translation=(0,0.55,-0.075),
          children=[
          Shape(
            geometry=Cone(bottomRadius=0.1,height=0.4),
            appearance=Appearance(USE='Aqua'))])]),
      TouchSensor(DEF='BlueKnight1TouchSensor'),
      TimeSensor(DEF='BLUEKNIGHT1CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BlueKnight1PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BlueKnight1PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-4,0,1)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BlueKnight1TouchSensor',toField='set_enabled',toNode='BLUEKNIGHT1CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEKNIGHT1CLOCK',toField='set_fraction',toNode='BlueKnight1PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BlueKnight1PathInterpolator',toField='set_rotation',toNode='BlueKnight1')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BlueKnight1PlaneSensor',toField='set_translation',toNode='BlueKnight1')])]),
    Transform(DEF='BlueBishop1',translation=(-2,0,3),
      children=[
      Group(
        children=[
        Group(USE='bluepiecebase'),
        Group(
          children=[
          Transform(translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Cone(bottomRadius=.15,height=.5),
              appearance=Appearance(USE='Aqua'))])])]),
      TouchSensor(DEF='BlueBishop1TouchSensor'),
      TimeSensor(DEF='BLUEBISHOP1CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BlueBishop1PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BlueBishop1PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-2,3,0)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BlueBishop1TouchSensor',toField='set_enabled',toNode='BLUEBISHOP1CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEBISHOP1CLOCK',toField='set_fraction',toNode='BlueBishop1PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BlueBishop1PathInterpolator',toField='set_rotation',toNode='BlueBishop1')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BlueBishop1PlaneSensor',toField='set_translation',toNode='BlueBishop1')])]),
    Transform(DEF='BlueKing',translation=(-1,0,3),
      children=[
      Group(
        children=[
        Group(USE='bluepiecebase'),
        Transform(translation=(0,0.4,0),
          children=[
          Shape(
            geometry=Cone(bottomRadius=.10,height=.25),
            appearance=Appearance(USE='Aqua'))]),
        Transform(scale=(.035,.035,.035),translation=(0,0.4,0),
          children=[
          Shape(DEF='BlueBolt',
            geometry=IndexedFaceSet(convex=False,coordIndex=[0,1,2,3,4,5,6,-1,0,12,11,10,9,8,7,-1,0,7,1,-1,1,7,8,2,-1,2,8,9,3,-1,3,9,10,4,-1,4,10,11,5,-1,5,11,12,6,-1,6,12,0],
              coord=Coordinate(point=[(0.0,0.0,0.0),(5.5,5.0,0.88),(4.0,5.5,0.968),(7.0,8.0,1.408),(4.0,9.0,1.584),(1.0,5.0,0.88),(2.5,4.5,0.792),(5.5,5.0,-0.88),(4.0,5.5,-0.968),(7.0,8.0,-1.408),(4.0,9.0,-1.584),(1.0,5.0,-0.88),(2.5,4.5,-0.792)])),
            appearance=Appearance(USE='Aqua')),
          Transform(rotation=(0,1,0,45),
            children=[
            Shape(USE='BlueBolt')]),
          Transform(rotation=(0,1,0,90),
            children=[
            Shape(USE='BlueBolt')]),
          Transform(rotation=(0,1,0,135),
            children=[
            Shape(USE='BlueBolt')]),
          Transform(rotation=(0,1,0,180),
            children=[
            Shape(USE='BlueBolt')]),
          Transform(rotation=(0,1,0,225),
            children=[
            Shape(USE='BlueBolt')])]),
        Transform(translation=(0,.8,0),
          children=[
          Group(
            children=[
            Shape(
              appearance=Appearance(USE='Aqua'),
              geometry=Box(size=(.25,.02,.02))),
            Shape(
              appearance=Appearance(USE='Aqua'),
              geometry=Box(size=(.02,.25,.02))),
            Shape(
              appearance=Appearance(USE='Aqua'),
              geometry=Box(size=(.02,.02,.25)))])])]),
      TouchSensor(DEF='BlueKingTouchSensor'),
      TimeSensor(DEF='BLUEKINGCLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BlueKingPathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BlueKingPlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(-1,-1,3)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BlueKingTouchSensor',toField='set_enabled',toNode='BLUEKINGCLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEKINGCLOCK',toField='set_fraction',toNode='BlueKingPathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BlueKingPathInterpolator',toField='set_rotation',toNode='BlueKing')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BlueKingPlaneSensor',toField='set_translation',toNode='BlueKing')])]),
    Transform(DEF='BlueQueen',translation=(0,0,3),
      children=[
      Group(
        children=[
        Group(USE='bluepiecebase'),
        Transform(translation=(0,0.4,0),
          children=[
          Shape(
            geometry=Cone(bottomRadius=.10,height=.25),
            appearance=Appearance(USE='Aqua'))]),
        Transform(scale=(.035,.035,.035),translation=(0,0.4,0),
          children=[
          Shape(USE='BlueBolt'),
          Transform(rotation=(0,1,0,45),
            children=[
            Shape(USE='BlueBolt')]),
          Transform(rotation=(0,1,0,90),
            children=[
            Shape(USE='BlueBolt')]),
          Transform(rotation=(0,1,0,135),
            children=[
            Shape(USE='BlueBolt')]),
          Transform(rotation=(0,1,0,180),
            children=[
            Shape(USE='BlueBolt')]),
          Transform(rotation=(0,1,0,225),
            children=[
            Shape(USE='BlueBolt')])])]),
      TouchSensor(DEF='BlueQueenTouchSensor'),
      TimeSensor(DEF='BLUEQUEENCLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BlueQueenPathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BlueQueenPlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(0,-4,-4)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BlueQueenTouchSensor',toField='set_enabled',toNode='BLUEQUEENCLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEQUEENCLOCK',toField='set_fraction',toNode='BlueQueenPathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BlueQueenPathInterpolator',toField='set_rotation',toNode='BlueQueen')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BlueQueenPlaneSensor',toField='set_translation',toNode='BlueQueen')])]),
    Transform(DEF='BlueBishop2',translation=(1,0,3),
      children=[
      Group(
        children=[
        Group(USE='bluepiecebase'),
        Transform(translation=(0,0.45,0),
          children=[
          Shape(
            geometry=Cone(bottomRadius=.15,height=.5),
            appearance=Appearance(USE='Aqua'))])]),
      TouchSensor(DEF='BlueBishop2TouchSensor'),
      TimeSensor(DEF='BLUEBISHOP2CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BlueBishop2PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BlueBishop2PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(1,2,3)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BlueBishop2TouchSensor',toField='set_enabled',toNode='BLUEBISHOP2CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEBISHOP2CLOCK',toField='set_fraction',toNode='BlueBishop2PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BlueBishop2PathInterpolator',toField='set_rotation',toNode='BlueBishop2')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BlueBishop2PlaneSensor',toField='set_translation',toNode='BlueBishop2')])]),
    Transform(DEF='BlueKnight2',translation=(2,0,3),
      children=[
      Group(
        children=[
        Group(USE='bluepiecebase'),
        Transform(translation=(0,0.45,0),
          children=[
          Shape(
            geometry=Cylinder(height=0.45,radius=0.125),
            appearance=Appearance(USE='Aqua'))]),
        Transform(rotation=(-1,0,0,5.27),translation=(0,0.55,-0.075),
          children=[
          Shape(
            geometry=Cone(bottomRadius=0.1,height=0.4),
            appearance=Appearance(USE='Aqua'))])]),
      TouchSensor(DEF='BlueKnight2TouchSensor'),
      TimeSensor(DEF='BLUEKNIGHT2CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BlueKnight2PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BlueKnight2PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(1,0,1)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BlueKnight2TouchSensor',toField='set_enabled',toNode='BLUEKNIGHT2CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUEKNIGHT2CLOCK',toField='set_fraction',toNode='BlueKnight2PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BlueKnight2PathInterpolator',toField='set_rotation',toNode='BlueKnight2')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BlueKnight2PlaneSensor',toField='set_translation',toNode='BlueKnight2')])]),
    Transform(DEF='BlueCastle2',translation=(3,0,3),
      children=[
      Group(
        children=[
        Group(USE='bluepiecebase'),
        Group(
          children=[
          Transform(translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(USE='Aqua'))]),
          Transform(rotation=(0,1,0,0.52),translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(USE='Aqua'))]),
          Transform(rotation=(0,1,0,1.04),translation=(0,0.45,0),
            children=[
            Shape(
              geometry=Box(size=(.3,.45,.3)),
              appearance=Appearance(USE='Aqua'))])])]),
      TouchSensor(DEF='BlueCastle2TouchSensor'),
      TimeSensor(DEF='BLUECASTLE2CLOCK',cycleInterval=4,enabled=False,loop=True),
      OrientationInterpolator(DEF='BlueCastle2PathInterpolator',key=[0.0,0.50,1.0],keyValue=[(0.0,1.0,0.0,0.0),(0.0,1.0,0.0,3.14),(0.0,1.0,0.0,6.28)]),
      PlaneSensor(DEF='BlueCastle2PlaneSensor',maxPosition=(3,4),minPosition=(-4,-4),offset=(3,-4,3)),
      Group(
        children=[
        ROUTE(fromField='isOver',fromNode='BlueCastle2TouchSensor',toField='set_enabled',toNode='BLUECASTLE2CLOCK'),
        ROUTE(fromField='fraction_changed',fromNode='BLUECASTLE2CLOCK',toField='set_fraction',toNode='BlueCastle2PathInterpolator'),
        ROUTE(fromField='value_changed',fromNode='BlueCastle2PathInterpolator',toField='set_rotation',toNode='BlueCastle2')]),
      Group(
        children=[
        ROUTE(fromField='translation_changed',fromNode='BlueCastle2PlaneSensor',toField='set_translation',toNode='BlueCastle2')])]),
    Viewpoint(DEF='RedSide',description='Red Side',orientation=(-0,-1,-0.05,3.14),position=(0,2.5,-20)),
    Viewpoint(DEF='BlueSide',description='Blue Side',position=(0,2.5,20)),
    Viewpoint(DEF='BlueLeft',description='Blue on Left Side',orientation=(-0.08,0.99,0.08,1.58),position=(15,1,0)),
    Viewpoint(DEF='RedLeft',description='Red on Left Side',orientation=(-0.08,-0.99,-0.08,1.58),position=(-15,1,0)),
    Viewpoint(DEF='Corner1',description='Corner Blue Left Side',orientation=(-0.08,-1,-0.04,0.79),position=(-15,2,15)),
    Viewpoint(DEF='Corner2',description='Corner Blue Right Side',orientation=(-0.08,1,0.04,0.79),position=(15,2,15)),
    Viewpoint(DEF='Corner3',description='Corner Red Left Side',orientation=(-0.01,1,0.04,2.36),position=(15,2,-15)),
    Viewpoint(DEF='Corner4',description='Corner Red Right Side',orientation=(-0.02,-1,-0.05,2.36),position=(-15,2,-15)),
    Viewpoint(DEF='TopAngle1',description='Top Angle Blue Side',orientation=(-1,-0,-0,0.46),position=(0,10,20)),
    Viewpoint(DEF='TopAngle2',description='Top Angle Red Side',orientation=(0,-0.97,-0.23,3.14),position=(0,10,-20)),
    Viewpoint(DEF='TopAngle3',description='Top Angle Blue on Left',orientation=(-0.22,0.95,0.22,1.62),position=(20,10,0)),
    Viewpoint(DEF='TopAngle4',description='Top Angle Red on Left',orientation=(-0.22,-0.95,-0.22,1.62),position=(-20,10,0)),
    Viewpoint(DEF='TopCorner1',description='Top Corner Blue Left Side',orientation=(-0.59,-0.77,-0.24,0.99),position=(-20,20,20)),
    Viewpoint(DEF='TopCorner2',description='Top Corner Blue Right Side',orientation=(-0.59,0.77,0.24,0.99),position=(20,20,20)),
    Viewpoint(DEF='TopCorner3',description='Top Corner Red Left Side',orientation=(-0.12,0.95,0.30,2.40),position=(20,20,-20)),
    Viewpoint(DEF='TopCorner4',description='Top Corner Red Right Side',orientation=(-0.12,-0.95,-0.30,2.39),position=(-20,20,-20)),
    Viewpoint(DEF='BottomAngle1',description='Bottom Angle Blue Side',orientation=(1,-0,0,0.79),position=(0,-20,20)),
    Viewpoint(DEF='BottomAngle2',description='Bottom Angle Red Side',orientation=(0,-0.92,0.38,3.14),position=(0,-20,-20)),
    Viewpoint(DEF='BottomAngle3',description='Bottom Angle Blue on Left',orientation=(0.36,0.86,-0.36,1.72),position=(20,-20,0)),
    Viewpoint(DEF='BottomAngle4',description='Bottom Angle Red on Left',orientation=(0.36,-0.86,0.36,1.72),position=(-20,-20,0)),
    Viewpoint(DEF='BottomCorner1',description='Bottom Corner Blue Left Side',orientation=(0.59,-0.77,0.24,0.99),position=(-20,-20,20)),
    Viewpoint(DEF='BottomCorner2',description='Bottom Corner Blue Right Side',orientation=(0.59,0.77,-0.24,0.99),position=(20,-20,20)),
    Viewpoint(DEF='BottomCorner3',description='Bottom Corner Red Left Side',orientation=(0.12,0.95,-0.3,2.4),position=(20,-20,-20)),
    Viewpoint(DEF='BottomCorner4',description='Bottom Corner Red Right Side',orientation=(0.12,-0.95,0.3,2.39),position=(-20,-20,-20)),
    Background(groundAngle=[1.309,1.570796],groundColor=[(0,0,0.1),(0,0.1,0.3),(0.3,0.3,0.6)],skyAngle=[1.309,1.571],skyColor=[(1,0,0.8),(0.5,0,0.8),(0,0,0.8)]),
    Background(DEF='BackgroundCyan-ish',groundAngle=[1.309,1.570796],groundColor=[(0.1,0.1,0),(0.4,0.25,0.2),(0.6,0.6,0.6)],skyAngle=[1.309,1.571],skyColor=[(0,0.2,0.7),(0.0,0.5,1),(1,1,1)])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for Chess8Levels.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python Chess8Levels.py load and self-test diagnostics complete.")
