package Basic.StudentProjects;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Multi-layered Chess Board in 3 dimensions. </p>
 <p> Related links: Catalog page <a href="../../../StudentProjects/Chess8LevelsIndex.html" target="_blank">Chess8Levels</a>,  source <a href="../../../StudentProjects/Chess8Levels.java">Chess8Levels.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../StudentProjects/Chess8Levels.x3d">Chess8Levels.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Multi-layered Chess Board in 3 dimensions. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> John W. Carls </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 9 August 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> version </i> </td>
			<td> 0.3 </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> functionality incomplete for full game play </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Chess8Levels.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Chess8Levels.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../StudentProjects/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author John W. Carls
 */

public class Chess8Levels
{
	/** Default constructor to create this object. */
	public Chess8Levels ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("Chess8Levels.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Multi-layered Chess Board in 3 dimensions."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("John W. Carls"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("9 August 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_VERSION    ).setContent("0.3"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("functionality incomplete for full game play"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/StudentProjects/Chess8Levels.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addComments(" Multi-layered chess board construction. ")
    .addChild(new WorldInfo().setTitle("Chess8Levels.x3d"))
    .addChild(new Group("board")
      .addChild(new Transform("X_Plane")
        .addChild(new Group("Row1")
          .addChild(new Transform()
            .addChild(new Shape("GreenSquare")
              .setGeometry(new Box().setSize(1.0,0.01,1.0))
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(.25,1.0,.25).setTransparency(.125)))))
          .addChild(new Transform().setTranslation(1.0,0.0,0.0)
            .addChild(new Shape("BlueSquare")
              .setGeometry(new Box().setSize(1.0,0.01,1.0))
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(.25,.25,1.0).setTransparency(.125)))))
          .addChild(new Transform().setTranslation(2.0,0.0,0.0)
            .addChild(new Shape().setUSE("GreenSquare")))
          .addChild(new Transform().setTranslation(3.0,0.0,0.0)
            .addChild(new Shape().setUSE("BlueSquare")))
          .addChild(new Transform().setTranslation(-1.0,0.0,0.0)
            .addChild(new Shape().setUSE("BlueSquare")))
          .addChild(new Transform().setTranslation(-2.0,0.0,0.0)
            .addChild(new Shape().setUSE("GreenSquare")))
          .addChild(new Transform().setTranslation(-3.0,0.0,0.0)
            .addChild(new Shape().setUSE("BlueSquare")))
          .addChild(new Transform().setTranslation(-4.0,0.0,0.0)
            .addChild(new Shape().setUSE("GreenSquare"))))
        .addChild(new Transform().setTranslation(0.0,0.0,-1.0)
          .addChild(new Group("Row2")
            .addChild(new Transform()
              .addChild(new Shape().setUSE("BlueSquare")))
            .addChild(new Transform().setTranslation(1.0,0.0,0.0)
              .addChild(new Shape().setUSE("GreenSquare")))
            .addChild(new Transform().setTranslation(2.0,0.0,0.0)
              .addChild(new Shape().setUSE("BlueSquare")))
            .addChild(new Transform().setTranslation(3.0,0.0,0.0)
              .addChild(new Shape().setUSE("GreenSquare")))
            .addChild(new Transform().setTranslation(-1.0,0.0,0.0)
              .addChild(new Shape().setUSE("GreenSquare")))
            .addChild(new Transform().setTranslation(-2.0,0.0,0.0)
              .addChild(new Shape().setUSE("BlueSquare")))
            .addChild(new Transform().setTranslation(-3.0,0.0,0.0)
              .addChild(new Shape().setUSE("GreenSquare")))
            .addChild(new Transform().setTranslation(-4.0,0.0,0.0)
              .addChild(new Shape().setUSE("BlueSquare")))))
        .addChild(new Transform().setTranslation(0.0,0.0,-2.0)
          .addChild(new Group().setUSE("Row1")))
        .addChild(new Transform().setTranslation(0.0,0.0,-3.0)
          .addChild(new Group().setUSE("Row2")))
        .addChild(new Transform().setTranslation(0.0,0.0,-4.0)
          .addChild(new Group().setUSE("Row1")))
        .addChild(new Transform().setTranslation(0.0,0.0,1.0)
          .addChild(new Group().setUSE("Row2")))
        .addChild(new Transform().setTranslation(0.0,0.0,2.0)
          .addChild(new Group().setUSE("Row1")))
        .addChild(new Transform().setTranslation(0.0,0.0,3.0)
          .addChild(new Group().setUSE("Row2"))))
      .addChild(new Transform().setTranslation(0.0,-4.0,0.0)
        .addChild(new Transform().setUSE("X_Plane")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(0.0,-3.0,-1.0)
        .addChild(new Transform().setUSE("X_Plane")))
      .addChild(new Transform().setTranslation(0.0,-2.0,0.0)
        .addChild(new Transform().setUSE("X_Plane")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(0.0,-1.0,-1.0)
        .addChild(new Transform().setUSE("X_Plane")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(0.0,1.0,-1.0)
        .addChild(new Transform().setUSE("X_Plane")))
      .addChild(new Transform().setTranslation(0.0,2.0,0.0)
        .addChild(new Transform().setUSE("X_Plane")))
      .addChild(new Transform().setRotation(0.0,1.0,0.0,1.57).setTranslation(0.0,3.0,-1.0)
        .addChild(new Transform().setUSE("X_Plane")))
      .addChild(new Transform().setTranslation(0.0,4.0,0.0)
        .addChild(new Transform().setUSE("X_Plane"))))
    .addChild(new Transform("RedPawn1").setTranslation(-4.0,0.0,-3.0)
      .addChild(new Group("redpawn")
        .addChild(new Transform().setTranslation(0.0,.415,0.0)
          .addChild(new Transform()
            .addChild(new Shape()
              .setGeometry(new Sphere().setRadius(.1875))
              .setAppearance(new Appearance("Red")
                .setMaterial(new Material().setDiffuseColor(1.0,.25,.25))))))
        .addChild(new Group("redpiecebase")
          .addChild(new Transform("chesspiecebase").setTranslation(0.0,0.04,0.0)
            .addChild(new Shape()
              .setGeometry(new Cylinder().setHeight(.0625).setRadius(.1875))))
          .addChild(new Transform("redpiecepost").setTranslation(0.0,.165,0.0)
            .addChild(new Shape()
              .setGeometry(new Cylinder().setHeight(.25).setRadius(.0825))
              .setAppearance(new Appearance().setUSE("Red"))))))
      .addChild(new TouchSensor("RedPawn1TouchSensor"))
      .addChild(new TimeSensor("REDPAWN1CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedPawn1PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedPawn1PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-4.0,1.0,-2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn1TouchSensor").setFromField("isOver").setToNode("REDPAWN1CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDPAWN1CLOCK").setFromField("fraction_changed").setToNode("RedPawn1PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedPawn1PathInterpolator").setFromField("value_changed").setToNode("RedPawn1").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn1PlaneSensor").setFromField("translation_changed").setToNode("RedPawn1").setToField("set_translation"))))
    .addChild(new Transform("RedPawn2").setTranslation(-3.0,0.0,-3.0)
      .addChild(new Group().setUSE("redpawn"))
      .addChild(new TouchSensor("RedPawn2TouchSensor"))
      .addChild(new TimeSensor("REDPAWN2CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedPawn2PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedPawn2PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-3.0,-1.0,-2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn2TouchSensor").setFromField("isOver").setToNode("REDPAWN2CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDPAWN2CLOCK").setFromField("fraction_changed").setToNode("RedPawn2PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedPawn2PathInterpolator").setFromField("value_changed").setToNode("RedPawn2").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn2PlaneSensor").setFromField("translation_changed").setToNode("RedPawn2").setToField("set_translation"))))
    .addChild(new Transform("RedPawn3").setTranslation(-2.0,0.0,-3.0)
      .addChild(new Group().setUSE("redpawn"))
      .addChild(new TouchSensor("RedPawn3TouchSensor"))
      .addChild(new TimeSensor("REDPAWN3CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedPawn3PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedPawn3PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-2.0,1.0,-2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn3TouchSensor").setFromField("isOver").setToNode("REDPAWN3CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDPAWN3CLOCK").setFromField("fraction_changed").setToNode("RedPawn3PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedPawn3PathInterpolator").setFromField("value_changed").setToNode("RedPawn3").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn3PlaneSensor").setFromField("translation_changed").setToNode("RedPawn3").setToField("set_translation"))))
    .addChild(new Transform("RedPawn4").setTranslation(-1.0,0.0,-3.0)
      .addChild(new Group().setUSE("redpawn"))
      .addChild(new TouchSensor("RedPawn4TouchSensor"))
      .addChild(new TimeSensor("REDPAWN4CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedPawn4PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedPawn4PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-1.0,2.0,-2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn4TouchSensor").setFromField("isOver").setToNode("REDPAWN4CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDPAWN4CLOCK").setFromField("fraction_changed").setToNode("RedPawn4PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedPawn4PathInterpolator").setFromField("value_changed").setToNode("RedPawn4").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn4PlaneSensor").setFromField("translation_changed").setToNode("RedPawn4").setToField("set_translation"))))
    .addChild(new Transform("RedPawn5").setTranslation(0.0,0.0,-3.0)
      .addChild(new Group().setUSE("redpawn"))
      .addChild(new TouchSensor("RedPawn5TouchSensor"))
      .addChild(new TimeSensor("REDPAWN5CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedPawn5PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedPawn5PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(0.0,-2.0,-2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn5TouchSensor").setFromField("isOver").setToNode("REDPAWN5CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDPAWN5CLOCK").setFromField("fraction_changed").setToNode("RedPawn5PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedPawn5PathInterpolator").setFromField("value_changed").setToNode("RedPawn5").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn5PlaneSensor").setFromField("translation_changed").setToNode("RedPawn5").setToField("set_translation"))))
    .addChild(new Transform("RedPawn6").setTranslation(1.0,0.0,-3.0)
      .addChild(new Group().setUSE("redpawn"))
      .addChild(new TouchSensor("RedPawn6TouchSensor"))
      .addChild(new TimeSensor("REDPAWN6CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedPawn6PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedPawn6PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(1.0,1.0,-1.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn6TouchSensor").setFromField("isOver").setToNode("REDPAWN6CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDPAWN6CLOCK").setFromField("fraction_changed").setToNode("RedPawn6PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedPawn6PathInterpolator").setFromField("value_changed").setToNode("RedPawn6").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn6PlaneSensor").setFromField("translation_changed").setToNode("RedPawn6").setToField("set_translation"))))
    .addChild(new Transform("RedPawn7").setTranslation(2.0,0.0,-3.0)
      .addChild(new Group().setUSE("redpawn"))
      .addChild(new TouchSensor("RedPawn7TouchSensor"))
      .addChild(new TimeSensor("REDPAWN7CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedPawn7PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedPawn7PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(2.0,1.0,-1.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn7TouchSensor").setFromField("isOver").setToNode("REDPAWN7CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDPAWN7CLOCK").setFromField("fraction_changed").setToNode("RedPawn7PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedPawn7PathInterpolator").setFromField("value_changed").setToNode("RedPawn7").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn7PlaneSensor").setFromField("translation_changed").setToNode("RedPawn7").setToField("set_translation"))))
    .addChild(new Transform("RedPawn8").setTranslation(3.0,0.0,-3.0)
      .addChild(new Group().setUSE("redpawn"))
      .addChild(new TouchSensor("RedPawn8TouchSensor"))
      .addChild(new TimeSensor("REDPAWN8CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedPawn8PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedPawn8PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(3.0,0.0,-2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn8TouchSensor").setFromField("isOver").setToNode("REDPAWN8CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDPAWN8CLOCK").setFromField("fraction_changed").setToNode("RedPawn8PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedPawn8PathInterpolator").setFromField("value_changed").setToNode("RedPawn8").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedPawn8PlaneSensor").setFromField("translation_changed").setToNode("RedPawn8").setToField("set_translation"))))
    .addChild(new Transform("RedCastle1").setTranslation(-4.0,0.0,-4.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("redpiecebase"))
        .addChild(new Group()
          .addChild(new Transform().setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance().setUSE("Red"))))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.52).setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance().setUSE("Red"))))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.04).setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance().setUSE("Red"))))))
      .addChild(new TouchSensor("RedCastle1TouchSensor"))
      .addChild(new TimeSensor("REDCASTLE1CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedCastle1PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedCastle1PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-4.0,3.0,-4.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedCastle1TouchSensor").setFromField("isOver").setToNode("REDCASTLE1CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDCASTLE1CLOCK").setFromField("fraction_changed").setToNode("RedCastle1PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedCastle1PathInterpolator").setFromField("value_changed").setToNode("RedCastle1").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedCastle1PlaneSensor").setFromField("translation_changed").setToNode("RedCastle1").setToField("set_translation"))))
    .addChild(new Transform("RedKnight1").setTranslation(-3.0,0.0,-4.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("redpiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.45,0.0)
          .addChild(new Shape()
            .setGeometry(new Cylinder().setHeight(0.45).setRadius(0.125))
            .setAppearance(new Appearance().setUSE("Red"))))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,5.27).setTranslation(0.0,0.55,0.075)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(0.1).setHeight(0.4))
            .setAppearance(new Appearance().setUSE("Red")))))
      .addChild(new TouchSensor("RedKnight1TouchSensor"))
      .addChild(new TimeSensor("REDKNIGHT1CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedKnight1PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedKnight1PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-2.0,0.0,-2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedKnight1TouchSensor").setFromField("isOver").setToNode("REDKNIGHT1CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDKNIGHT1CLOCK").setFromField("fraction_changed").setToNode("RedKnight1PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedKnight1PathInterpolator").setFromField("value_changed").setToNode("RedKnight1").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedKnight1PlaneSensor").setFromField("translation_changed").setToNode("RedKnight1").setToField("set_translation"))))
    .addChild(new Transform("RedBishop1").setTranslation(-2.0,0.0,-4.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("redpiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.45,0.0)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(.15).setHeight(.5))
            .setAppearance(new Appearance().setUSE("Red")))))
      .addChild(new TouchSensor("RedBishop1TouchSensor"))
      .addChild(new TimeSensor("REDBISHOP1CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedBishop1PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedBishop1PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(0.0,-4.0,-2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedBishop1TouchSensor").setFromField("isOver").setToNode("REDBISHOP1CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDBISHOP1CLOCK").setFromField("fraction_changed").setToNode("RedBishop1PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedBishop1PathInterpolator").setFromField("value_changed").setToNode("RedBishop1").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedBishop1PlaneSensor").setFromField("translation_changed").setToNode("RedBishop1").setToField("set_translation"))))
    .addChild(new Transform("RedKing").setTranslation(-1.0,0.0,-4.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("redpiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.4,0.0)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(.10).setHeight(.25))
            .setAppearance(new Appearance().setUSE("Red"))))
        .addChild(new Transform().setScale(.035,.035,.035).setTranslation(0.0,0.4,0.0)
          .addChild(new Shape("RedBolt")
            .setGeometry(new IndexedFaceSet().setConvex(false).setCoordIndex(new int[] {0,1,2,3,4,5,6,-1,0,12,11,10,9,8,7,-1,0,7,1,-1,1,7,8,2,-1,2,8,9,3,-1,3,9,10,4,-1,4,10,11,5,-1,5,11,12,6,-1,6,12,0})
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,5.5,5.0,0.88,4.0,5.5,0.968,7.0,8.0,1.408,4.0,9.0,1.584,1.0,5.0,0.88,2.5,4.5,0.792,5.5,5.0,-0.88,4.0,5.5,-0.968,7.0,8.0,-1.408,4.0,9.0,-1.584,1.0,5.0,-0.88,2.5,4.5,-0.792}))))
            .setAppearance(new Appearance().setUSE("Red")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,45.0)
            .addChild(new Shape().setUSE("RedBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,90.0)
            .addChild(new Shape().setUSE("RedBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,135.0)
            .addChild(new Shape().setUSE("RedBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,180.0)
            .addChild(new Shape().setUSE("RedBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,225.0)
            .addChild(new Shape().setUSE("RedBolt"))))
        .addChild(new Transform().setTranslation(0.0,.8,0.0)
          .addChild(new Group()
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.25,.02,.02))
              .setAppearance(new Appearance().setUSE("Red")))
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.02,.25,.02))
              .setAppearance(new Appearance().setUSE("Red")))
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.02,.02,.25))
              .setAppearance(new Appearance().setUSE("Red"))))))
      .addChild(new TouchSensor("RedKingTouchSensor"))
      .addChild(new TimeSensor("REDKINGCLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedKingPathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedKingPlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-1.0,1.0,-4.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedKingTouchSensor").setFromField("isOver").setToNode("REDKINGCLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDKINGCLOCK").setFromField("fraction_changed").setToNode("RedKingPathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedKingPathInterpolator").setFromField("value_changed").setToNode("RedKing").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedKingPlaneSensor").setFromField("translation_changed").setToNode("RedKing").setToField("set_translation"))))
    .addChild(new Transform("RedQueen").setTranslation(0.0,0.0,-4.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("redpiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.4,0.0)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(.10).setHeight(.25))
            .setAppearance(new Appearance().setUSE("Red"))))
        .addChild(new Transform().setScale(.035,.035,.035).setTranslation(0.0,0.4,0.0)
          .addChild(new Shape().setUSE("RedBolt"))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,45.0)
            .addChild(new Shape().setUSE("RedBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,90.0)
            .addChild(new Shape().setUSE("RedBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,135.0)
            .addChild(new Shape().setUSE("RedBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,180.0)
            .addChild(new Shape().setUSE("RedBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,225.0)
            .addChild(new Shape().setUSE("RedBolt")))))
      .addChild(new TouchSensor("RedQueenTouchSensor"))
      .addChild(new TimeSensor("REDQUEENCLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedQueenPathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedQueenPlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(0.0,3.0,3.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedQueenTouchSensor").setFromField("isOver").setToNode("REDQUEENCLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDQUEENCLOCK").setFromField("fraction_changed").setToNode("RedQueenPathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedQueenPathInterpolator").setFromField("value_changed").setToNode("RedQueen").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedQueenPlaneSensor").setFromField("translation_changed").setToNode("RedQueen").setToField("set_translation"))))
    .addChild(new Transform("RedBishop2").setTranslation(1.0,0.0,-4.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("redpiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.45,0.0)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(.15).setHeight(.5))
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(1.0,.25,.25))))))
      .addChild(new TouchSensor("RedBishop2TouchSensor"))
      .addChild(new TimeSensor("REDBISHOP2CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedBishop2PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedBishop2PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(0.0,4.0,-2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedBishop2TouchSensor").setFromField("isOver").setToNode("REDBISHOP2CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDBISHOP2CLOCK").setFromField("fraction_changed").setToNode("RedBishop2PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedBishop2PathInterpolator").setFromField("value_changed").setToNode("RedBishop2").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedBishop2PlaneSensor").setFromField("translation_changed").setToNode("RedBishop2").setToField("set_translation"))))
    .addChild(new Transform("RedKnight2").setTranslation(2.0,0.0,-4.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("redpiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.45,0.0)
          .addChild(new Shape()
            .setGeometry(new Cylinder().setHeight(0.45).setRadius(0.125))
            .setAppearance(new Appearance().setUSE("Red"))))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,5.27).setTranslation(0.0,0.55,0.075)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(0.1).setHeight(0.4))
            .setAppearance(new Appearance().setUSE("Red")))))
      .addChild(new TouchSensor("RedKnight2TouchSensor"))
      .addChild(new TimeSensor("REDKNIGHT2CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedKnight2PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedKnight2PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(0.0,0.0,-2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedKnight2TouchSensor").setFromField("isOver").setToNode("REDKNIGHT2CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDKNIGHT2CLOCK").setFromField("fraction_changed").setToNode("RedKnight2PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedKnight2PathInterpolator").setFromField("value_changed").setToNode("RedKnight2").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedKnight2PlaneSensor").setFromField("translation_changed").setToNode("RedKnight2").setToField("set_translation"))))
    .addChild(new Transform("RedCastle2").setTranslation(3.0,0.0,-4.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("redpiecebase"))
        .addChild(new Group()
          .addChild(new Transform().setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(1.0,.25,.25)))))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.52).setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(1.0,.25,.25)))))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.04).setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance()
                .setMaterial(new Material().setDiffuseColor(1.0,.25,.25)))))))
      .addChild(new TouchSensor("RedCastle2TouchSensor"))
      .addChild(new TimeSensor("REDCASTLE2CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("RedCastle2PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("RedCastle2PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(3.0,-4.0,-4.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedCastle2TouchSensor").setFromField("isOver").setToNode("REDCASTLE2CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("REDCASTLE2CLOCK").setFromField("fraction_changed").setToNode("RedCastle2PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("RedCastle2PathInterpolator").setFromField("value_changed").setToNode("RedCastle2").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("RedCastle2PlaneSensor").setFromField("translation_changed").setToNode("RedCastle2").setToField("set_translation"))))
    .addChild(new Transform("BluePawn1").setTranslation(-4.0,0.0,2.0)
      .addChild(new Group("aquapawn")
        .addChild(new Transform().setTranslation(0.0,.415,0.0)
          .addChild(new Transform()
            .addChild(new Shape()
              .setGeometry(new Sphere().setRadius(.1875))
              .setAppearance(new Appearance("Aqua")
                .setMaterial(new Material().setDiffuseColor(.25,1.0,1.0))))))
        .addChild(new Group("bluepiecebase")
          .addChild(new Transform().setTranslation(0.0,0.04,0.0)
            .addChild(new Shape()
              .setGeometry(new Cylinder().setHeight(.0625).setRadius(.1875))))
          .addChild(new Transform("bluepiecepost").setTranslation(0.0,.165,0.0)
            .addChild(new Shape()
              .setGeometry(new Cylinder().setHeight(.25).setRadius(.0825))
              .setAppearance(new Appearance().setUSE("Aqua"))))))
      .addChild(new TouchSensor("BluePawn1TouchSensor"))
      .addChild(new TimeSensor("BLUEPAWN1CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BluePawn1PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BluePawn1PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-4.0,1.0,2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn1TouchSensor").setFromField("isOver").setToNode("BLUEPAWN1CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEPAWN1CLOCK").setFromField("fraction_changed").setToNode("BluePawn1PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BluePawn1PathInterpolator").setFromField("value_changed").setToNode("BluePawn1").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn1PlaneSensor").setFromField("translation_changed").setToNode("BluePawn1").setToField("set_translation"))))
    .addChild(new Transform("BluePawn2").setTranslation(-3.0,0.0,2.0)
      .addChild(new Group().setUSE("aquapawn"))
      .addChild(new TouchSensor("BluePawn2TouchSensor"))
      .addChild(new TimeSensor("BLUEPAWN2CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BluePawn2PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BluePawn2PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-3.0,1.0,1.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn2TouchSensor").setFromField("isOver").setToNode("BLUEPAWN2CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEPAWN2CLOCK").setFromField("fraction_changed").setToNode("BluePawn2PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BluePawn2PathInterpolator").setFromField("value_changed").setToNode("BluePawn2").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn2PlaneSensor").setFromField("translation_changed").setToNode("BluePawn2").setToField("set_translation"))))
    .addChild(new Transform("BluePawn3").setTranslation(-2.0,0.0,2.0)
      .addChild(new Group().setUSE("aquapawn"))
      .addChild(new TouchSensor("BluePawn3TouchSensor"))
      .addChild(new TimeSensor("BLUEPAWN3CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BluePawn3PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BluePawn3PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-2.0,2.0,2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn3TouchSensor").setFromField("isOver").setToNode("BLUEPAWN3CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEPAWN3CLOCK").setFromField("fraction_changed").setToNode("BluePawn3PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BluePawn3PathInterpolator").setFromField("value_changed").setToNode("BluePawn3").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn3PlaneSensor").setFromField("translation_changed").setToNode("BluePawn3").setToField("set_translation"))))
    .addChild(new Transform("BluePawn4").setTranslation(-1.0,0.0,2.0)
      .addChild(new Group().setUSE("aquapawn"))
      .addChild(new TouchSensor("BluePawn4TouchSensor"))
      .addChild(new TimeSensor("BLUEPAWN4CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BluePawn4PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BluePawn4PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-1.0,1.0,2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn4TouchSensor").setFromField("isOver").setToNode("BLUEPAWN4CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEPAWN4CLOCK").setFromField("fraction_changed").setToNode("BluePawn4PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BluePawn4PathInterpolator").setFromField("value_changed").setToNode("BluePawn4").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn4PlaneSensor").setFromField("translation_changed").setToNode("BluePawn4").setToField("set_translation"))))
    .addChild(new Transform("BluePawn5").setTranslation(0.0,0.0,2.0)
      .addChild(new Group().setUSE("aquapawn"))
      .addChild(new TouchSensor("BluePawn5TouchSensor"))
      .addChild(new TimeSensor("BLUEPAWN5CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BluePawn5PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BluePawn5PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(0.0,-1.0,1.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn5TouchSensor").setFromField("isOver").setToNode("BLUEPAWN5CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEPAWN5CLOCK").setFromField("fraction_changed").setToNode("BluePawn5PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BluePawn5PathInterpolator").setFromField("value_changed").setToNode("BluePawn5").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn5PlaneSensor").setFromField("translation_changed").setToNode("BluePawn5").setToField("set_translation"))))
    .addChild(new Transform("BluePawn6").setTranslation(1.0,0.0,2.0)
      .addChild(new Group().setUSE("aquapawn"))
      .addChild(new TouchSensor("BluePawn6TouchSensor"))
      .addChild(new TimeSensor("BLUEPAWN6CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BluePawn6PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BluePawn6PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(1.0,1.0,1.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn6TouchSensor").setFromField("isOver").setToNode("BLUEPAWN6CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEPAWN6CLOCK").setFromField("fraction_changed").setToNode("BluePawn6PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BluePawn6PathInterpolator").setFromField("value_changed").setToNode("BluePawn6").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn6PlaneSensor").setFromField("translation_changed").setToNode("BluePawn6").setToField("set_translation"))))
    .addChild(new Transform("BluePawn7").setTranslation(2.0,0.0,2.0)
      .addChild(new Group().setUSE("aquapawn"))
      .addChild(new TouchSensor("BluePawn7TouchSensor"))
      .addChild(new TimeSensor("BLUEPAWN7CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BluePawn7PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BluePawn7PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(2.0,1.0,2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn7TouchSensor").setFromField("isOver").setToNode("BLUEPAWN7CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEPAWN7CLOCK").setFromField("fraction_changed").setToNode("BluePawn7PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BluePawn7PathInterpolator").setFromField("value_changed").setToNode("BluePawn7").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn7PlaneSensor").setFromField("translation_changed").setToNode("BluePawn7").setToField("set_translation"))))
    .addChild(new Transform("BluePawn8").setTranslation(3.0,0.0,2.0)
      .addChild(new Group().setUSE("aquapawn"))
      .addChild(new TouchSensor("BluePawn8TouchSensor"))
      .addChild(new TimeSensor("BLUEPAWN8CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BluePawn8PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BluePawn8PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(3.0,1.0,2.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn8TouchSensor").setFromField("isOver").setToNode("BLUEPAWN8CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEPAWN8CLOCK").setFromField("fraction_changed").setToNode("BluePawn8PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BluePawn8PathInterpolator").setFromField("value_changed").setToNode("BluePawn8").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BluePawn8PlaneSensor").setFromField("translation_changed").setToNode("BluePawn8").setToField("set_translation"))))
    .addChild(new Transform("BlueCastle1").setTranslation(-4.0,0.0,3.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("bluepiecebase"))
        .addChild(new Group()
          .addChild(new Transform().setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance().setUSE("Aqua"))))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.52).setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance().setUSE("Aqua"))))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.04).setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance().setUSE("Aqua"))))))
      .addChild(new TouchSensor("BlueCastle1TouchSensor"))
      .addChild(new TimeSensor("BLUECASTLE1CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BlueCastle1PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BlueCastle1PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-4.0,4.0,3.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueCastle1TouchSensor").setFromField("isOver").setToNode("BLUECASTLE1CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUECASTLE1CLOCK").setFromField("fraction_changed").setToNode("BlueCastle1PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BlueCastle1PathInterpolator").setFromField("value_changed").setToNode("BlueCastle1").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueCastle1PlaneSensor").setFromField("translation_changed").setToNode("BlueCastle1").setToField("set_translation"))))
    .addChild(new Transform("BlueKnight1").setTranslation(-3.0,0.0,3.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("bluepiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.45,0.0)
          .addChild(new Shape()
            .setGeometry(new Cylinder().setHeight(0.45).setRadius(0.125))
            .setAppearance(new Appearance().setUSE("Aqua"))))
        .addChild(new Transform().setRotation(-1.0,0.0,0.0,5.27).setTranslation(0.0,0.55,-0.075)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(0.1).setHeight(0.4))
            .setAppearance(new Appearance().setUSE("Aqua")))))
      .addChild(new TouchSensor("BlueKnight1TouchSensor"))
      .addChild(new TimeSensor("BLUEKNIGHT1CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BlueKnight1PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BlueKnight1PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-4.0,0.0,1.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueKnight1TouchSensor").setFromField("isOver").setToNode("BLUEKNIGHT1CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEKNIGHT1CLOCK").setFromField("fraction_changed").setToNode("BlueKnight1PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BlueKnight1PathInterpolator").setFromField("value_changed").setToNode("BlueKnight1").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueKnight1PlaneSensor").setFromField("translation_changed").setToNode("BlueKnight1").setToField("set_translation"))))
    .addChild(new Transform("BlueBishop1").setTranslation(-2.0,0.0,3.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("bluepiecebase"))
        .addChild(new Group()
          .addChild(new Transform().setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Cone().setBottomRadius(.15).setHeight(.5))
              .setAppearance(new Appearance().setUSE("Aqua"))))))
      .addChild(new TouchSensor("BlueBishop1TouchSensor"))
      .addChild(new TimeSensor("BLUEBISHOP1CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BlueBishop1PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BlueBishop1PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-2.0,3.0,0.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueBishop1TouchSensor").setFromField("isOver").setToNode("BLUEBISHOP1CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEBISHOP1CLOCK").setFromField("fraction_changed").setToNode("BlueBishop1PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BlueBishop1PathInterpolator").setFromField("value_changed").setToNode("BlueBishop1").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueBishop1PlaneSensor").setFromField("translation_changed").setToNode("BlueBishop1").setToField("set_translation"))))
    .addChild(new Transform("BlueKing").setTranslation(-1.0,0.0,3.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("bluepiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.4,0.0)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(.10).setHeight(.25))
            .setAppearance(new Appearance().setUSE("Aqua"))))
        .addChild(new Transform().setScale(.035,.035,.035).setTranslation(0.0,0.4,0.0)
          .addChild(new Shape("BlueBolt")
            .setGeometry(new IndexedFaceSet().setConvex(false).setCoordIndex(new int[] {0,1,2,3,4,5,6,-1,0,12,11,10,9,8,7,-1,0,7,1,-1,1,7,8,2,-1,2,8,9,3,-1,3,9,10,4,-1,4,10,11,5,-1,5,11,12,6,-1,6,12,0})
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,5.5,5.0,0.88,4.0,5.5,0.968,7.0,8.0,1.408,4.0,9.0,1.584,1.0,5.0,0.88,2.5,4.5,0.792,5.5,5.0,-0.88,4.0,5.5,-0.968,7.0,8.0,-1.408,4.0,9.0,-1.584,1.0,5.0,-0.88,2.5,4.5,-0.792}))))
            .setAppearance(new Appearance().setUSE("Aqua")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,45.0)
            .addChild(new Shape().setUSE("BlueBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,90.0)
            .addChild(new Shape().setUSE("BlueBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,135.0)
            .addChild(new Shape().setUSE("BlueBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,180.0)
            .addChild(new Shape().setUSE("BlueBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,225.0)
            .addChild(new Shape().setUSE("BlueBolt"))))
        .addChild(new Transform().setTranslation(0.0,.8,0.0)
          .addChild(new Group()
            .addChild(new Shape()
              .setAppearance(new Appearance().setUSE("Aqua"))
              .setGeometry(new Box().setSize(.25,.02,.02)))
            .addChild(new Shape()
              .setAppearance(new Appearance().setUSE("Aqua"))
              .setGeometry(new Box().setSize(.02,.25,.02)))
            .addChild(new Shape()
              .setAppearance(new Appearance().setUSE("Aqua"))
              .setGeometry(new Box().setSize(.02,.02,.25))))))
      .addChild(new TouchSensor("BlueKingTouchSensor"))
      .addChild(new TimeSensor("BLUEKINGCLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BlueKingPathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BlueKingPlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(-1.0,-1.0,3.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueKingTouchSensor").setFromField("isOver").setToNode("BLUEKINGCLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEKINGCLOCK").setFromField("fraction_changed").setToNode("BlueKingPathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BlueKingPathInterpolator").setFromField("value_changed").setToNode("BlueKing").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueKingPlaneSensor").setFromField("translation_changed").setToNode("BlueKing").setToField("set_translation"))))
    .addChild(new Transform("BlueQueen").setTranslation(0.0,0.0,3.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("bluepiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.4,0.0)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(.10).setHeight(.25))
            .setAppearance(new Appearance().setUSE("Aqua"))))
        .addChild(new Transform().setScale(.035,.035,.035).setTranslation(0.0,0.4,0.0)
          .addChild(new Shape().setUSE("BlueBolt"))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,45.0)
            .addChild(new Shape().setUSE("BlueBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,90.0)
            .addChild(new Shape().setUSE("BlueBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,135.0)
            .addChild(new Shape().setUSE("BlueBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,180.0)
            .addChild(new Shape().setUSE("BlueBolt")))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,225.0)
            .addChild(new Shape().setUSE("BlueBolt")))))
      .addChild(new TouchSensor("BlueQueenTouchSensor"))
      .addChild(new TimeSensor("BLUEQUEENCLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BlueQueenPathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BlueQueenPlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(0.0,-4.0,-4.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueQueenTouchSensor").setFromField("isOver").setToNode("BLUEQUEENCLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEQUEENCLOCK").setFromField("fraction_changed").setToNode("BlueQueenPathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BlueQueenPathInterpolator").setFromField("value_changed").setToNode("BlueQueen").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueQueenPlaneSensor").setFromField("translation_changed").setToNode("BlueQueen").setToField("set_translation"))))
    .addChild(new Transform("BlueBishop2").setTranslation(1.0,0.0,3.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("bluepiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.45,0.0)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(.15).setHeight(.5))
            .setAppearance(new Appearance().setUSE("Aqua")))))
      .addChild(new TouchSensor("BlueBishop2TouchSensor"))
      .addChild(new TimeSensor("BLUEBISHOP2CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BlueBishop2PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BlueBishop2PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(1.0,2.0,3.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueBishop2TouchSensor").setFromField("isOver").setToNode("BLUEBISHOP2CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEBISHOP2CLOCK").setFromField("fraction_changed").setToNode("BlueBishop2PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BlueBishop2PathInterpolator").setFromField("value_changed").setToNode("BlueBishop2").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueBishop2PlaneSensor").setFromField("translation_changed").setToNode("BlueBishop2").setToField("set_translation"))))
    .addChild(new Transform("BlueKnight2").setTranslation(2.0,0.0,3.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("bluepiecebase"))
        .addChild(new Transform().setTranslation(0.0,0.45,0.0)
          .addChild(new Shape()
            .setGeometry(new Cylinder().setHeight(0.45).setRadius(0.125))
            .setAppearance(new Appearance().setUSE("Aqua"))))
        .addChild(new Transform().setRotation(-1.0,0.0,0.0,5.27).setTranslation(0.0,0.55,-0.075)
          .addChild(new Shape()
            .setGeometry(new Cone().setBottomRadius(0.1).setHeight(0.4))
            .setAppearance(new Appearance().setUSE("Aqua")))))
      .addChild(new TouchSensor("BlueKnight2TouchSensor"))
      .addChild(new TimeSensor("BLUEKNIGHT2CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BlueKnight2PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BlueKnight2PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(1.0,0.0,1.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueKnight2TouchSensor").setFromField("isOver").setToNode("BLUEKNIGHT2CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUEKNIGHT2CLOCK").setFromField("fraction_changed").setToNode("BlueKnight2PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BlueKnight2PathInterpolator").setFromField("value_changed").setToNode("BlueKnight2").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueKnight2PlaneSensor").setFromField("translation_changed").setToNode("BlueKnight2").setToField("set_translation"))))
    .addChild(new Transform("BlueCastle2").setTranslation(3.0,0.0,3.0)
      .addChild(new Group()
        .addChild(new Group().setUSE("bluepiecebase"))
        .addChild(new Group()
          .addChild(new Transform().setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance().setUSE("Aqua"))))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.52).setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance().setUSE("Aqua"))))
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.04).setTranslation(0.0,0.45,0.0)
            .addChild(new Shape()
              .setGeometry(new Box().setSize(.3,.45,.3))
              .setAppearance(new Appearance().setUSE("Aqua"))))))
      .addChild(new TouchSensor("BlueCastle2TouchSensor"))
      .addChild(new TimeSensor("BLUECASTLE2CLOCK").setCycleInterval(4).setEnabled(false).setLoop(true))
      .addChild(new OrientationInterpolator("BlueCastle2PathInterpolator").setKey(new double[] {0.0,0.50,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,3.14,0.0,1.0,0.0,6.28})))
      .addChild(new PlaneSensor("BlueCastle2PlaneSensor").setMaxPosition(3.0,4.0).setMinPosition(-4.0,-4.0).setOffset(3.0,-4.0,3.0))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueCastle2TouchSensor").setFromField("isOver").setToNode("BLUECASTLE2CLOCK").setToField("set_enabled"))
        .addChild(new ROUTE().setFromNode("BLUECASTLE2CLOCK").setFromField("fraction_changed").setToNode("BlueCastle2PathInterpolator").setToField("set_fraction"))
        .addChild(new ROUTE().setFromNode("BlueCastle2PathInterpolator").setFromField("value_changed").setToNode("BlueCastle2").setToField("set_rotation")))
      .addChild(new Group()
        .addChild(new ROUTE().setFromNode("BlueCastle2PlaneSensor").setFromField("translation_changed").setToNode("BlueCastle2").setToField("set_translation"))))
    .addChild(new Viewpoint("RedSide").setDescription("Red Side").setOrientation(-0.0,-1.0,-0.05,3.14).setPosition(0.0,2.5,-20.0))
    .addChild(new Viewpoint("BlueSide").setDescription("Blue Side").setPosition(0.0,2.5,20.0))
    .addChild(new Viewpoint("BlueLeft").setDescription("Blue on Left Side").setOrientation(-0.08,0.99,0.08,1.58).setPosition(15.0,1.0,0.0))
    .addChild(new Viewpoint("RedLeft").setDescription("Red on Left Side").setOrientation(-0.08,-0.99,-0.08,1.58).setPosition(-15.0,1.0,0.0))
    .addChild(new Viewpoint("Corner1").setDescription("Corner Blue Left Side").setOrientation(-0.08,-1.0,-0.04,0.79).setPosition(-15.0,2.0,15.0))
    .addChild(new Viewpoint("Corner2").setDescription("Corner Blue Right Side").setOrientation(-0.08,1.0,0.04,0.79).setPosition(15.0,2.0,15.0))
    .addChild(new Viewpoint("Corner3").setDescription("Corner Red Left Side").setOrientation(-0.01,1.0,0.04,2.36).setPosition(15.0,2.0,-15.0))
    .addChild(new Viewpoint("Corner4").setDescription("Corner Red Right Side").setOrientation(-0.02,-1.0,-0.05,2.36).setPosition(-15.0,2.0,-15.0))
    .addChild(new Viewpoint("TopAngle1").setDescription("Top Angle Blue Side").setOrientation(-1.0,-0.0,-0.0,0.46).setPosition(0.0,10.0,20.0))
    .addChild(new Viewpoint("TopAngle2").setDescription("Top Angle Red Side").setOrientation(0.0,-0.97,-0.23,3.14).setPosition(0.0,10.0,-20.0))
    .addChild(new Viewpoint("TopAngle3").setDescription("Top Angle Blue on Left").setOrientation(-0.22,0.95,0.22,1.62).setPosition(20.0,10.0,0.0))
    .addChild(new Viewpoint("TopAngle4").setDescription("Top Angle Red on Left").setOrientation(-0.22,-0.95,-0.22,1.62).setPosition(-20.0,10.0,0.0))
    .addChild(new Viewpoint("TopCorner1").setDescription("Top Corner Blue Left Side").setOrientation(-0.59,-0.77,-0.24,0.99).setPosition(-20.0,20.0,20.0))
    .addChild(new Viewpoint("TopCorner2").setDescription("Top Corner Blue Right Side").setOrientation(-0.59,0.77,0.24,0.99).setPosition(20.0,20.0,20.0))
    .addChild(new Viewpoint("TopCorner3").setDescription("Top Corner Red Left Side").setOrientation(-0.12,0.95,0.30,2.40).setPosition(20.0,20.0,-20.0))
    .addChild(new Viewpoint("TopCorner4").setDescription("Top Corner Red Right Side").setOrientation(-0.12,-0.95,-0.30,2.39).setPosition(-20.0,20.0,-20.0))
    .addChild(new Viewpoint("BottomAngle1").setDescription("Bottom Angle Blue Side").setOrientation(1.0,-0.0,0.0,0.79).setPosition(0.0,-20.0,20.0))
    .addChild(new Viewpoint("BottomAngle2").setDescription("Bottom Angle Red Side").setOrientation(0.0,-0.92,0.38,3.14).setPosition(0.0,-20.0,-20.0))
    .addChild(new Viewpoint("BottomAngle3").setDescription("Bottom Angle Blue on Left").setOrientation(0.36,0.86,-0.36,1.72).setPosition(20.0,-20.0,0.0))
    .addChild(new Viewpoint("BottomAngle4").setDescription("Bottom Angle Red on Left").setOrientation(0.36,-0.86,0.36,1.72).setPosition(-20.0,-20.0,0.0))
    .addChild(new Viewpoint("BottomCorner1").setDescription("Bottom Corner Blue Left Side").setOrientation(0.59,-0.77,0.24,0.99).setPosition(-20.0,-20.0,20.0))
    .addChild(new Viewpoint("BottomCorner2").setDescription("Bottom Corner Blue Right Side").setOrientation(0.59,0.77,-0.24,0.99).setPosition(20.0,-20.0,20.0))
    .addChild(new Viewpoint("BottomCorner3").setDescription("Bottom Corner Red Left Side").setOrientation(0.12,0.95,-0.3,2.4).setPosition(20.0,-20.0,-20.0))
    .addChild(new Viewpoint("BottomCorner4").setDescription("Bottom Corner Red Right Side").setOrientation(0.12,-0.95,0.3,2.39).setPosition(-20.0,-20.0,-20.0))
    .addChild(new Background().setGroundAngle(new double[] {1.309,1.570796}).setGroundColor(new MFColor(new double[] {0.0,0.0,0.1,0.0,0.1,0.3,0.3,0.3,0.6})).setSkyAngle(new double[] {1.309,1.571}).setSkyColor(new MFColor(new double[] {1.0,0.0,0.8,0.5,0.0,0.8,0.0,0.0,0.8})))
    .addChild(new Background("BackgroundCyan-ish").setGroundAngle(new double[] {1.309,1.570796}).setGroundColor(new MFColor(new double[] {0.1,0.1,0.0,0.4,0.25,0.2,0.6,0.6,0.6})).setSkyAngle(new double[] {1.309,1.571}).setSkyColor(new MFColor(new double[] {0.0,0.2,0.7,0.0,0.5,1.0,1.0,1.0,1.0}))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return Chess8Levels model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new Chess8Levels().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.StudentProjects.Chess8Levels\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.StudentProjects.Chess8Levels self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // StudentProjects/Chess8Levels_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "StudentProjects/Chess8Levels_JavaExport.x3d"; 
                String filenameX3DV = "StudentProjects/Chess8Levels_JavaExport.x3dv"; 
                String filenameJSON = "StudentProjects/Chess8Levels_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
