/**
 *<p>
 *	Shaders are special programs that interact directly with graphics hardware
 *      for special effects using light, darkness, and color within a model's appearance.
 *</p>
 *<p>
 *	A
 *	<a href="http://en.wikipedia.org/wiki/Shader" target="_blank">programmable shader</a>
 *	allows authors to directly specify how an object is rendered by providing a method of 
 *	programmatically modifying sections of the rendering pipeline. This allows replacement of the traditional
 *	fixed-function graphics API pipeline to support visual effects that typically cannot be implemented using
 *	other node components in this standard.
 *</p>
 *
 *<p>
 *	These example scenes illustrate the
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/components/shaders.html" target="_blank">X3D Programmable Shaders Component</a>.
 *	Unfortunately, unlike X3D, shader languages are typically hardware-specific and not interoperable across different platforms.
 *	Mutually compatible X3D interfaces and syntax are defined for the
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/shaders_glsl.html" target="_blank">OpenGL shading language (GLSL) binding</a>,
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/shaders_hlsl.html" target="_blank">Microsoft high level shading language (HLSL) binding</a>
 *	and the
 *	<a href="https://www.web3d.org/files/specifications/19777-2/V3.0/Part2/X3D_Java.html" target="_blank">nVidia Cg shading language binding</a>.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/Shaders" target="_blank">X3D Basic: Shaders</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.Shaders;

