####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python Flutter.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.1',
  head=head(
    children=[
    component(level=1,name='Shaders'),
    meta(content='Flutter.x3d',name='title'),
    meta(content='Shader test',name='description'),
    meta(content='John Stewart',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='Jeff Malnick',name='translator'),
    meta(content='15 February 2010',name='created'),
    meta(content='1 July 2023',name='modified'),
    meta(content='http://www.opengl.org/wiki/Fragment_Shader',name='reference'),
    meta(content='http://www.opengl.org/wiki/http://www.opengl.org/wiki/Vertex_Shader',name='reference'),
    meta(content='http://freewrl.sourceforge.net/examples.html',name='reference'),
    meta(content='originals/flutter.x3d',name='reference'),
    meta(content='http://freewrl.sourceforge.net/images/flutter.x3d',name='reference'),
    meta(content='X3D Shader example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Shaders/Flutter.x3d',name='identifier'),
    meta(content='under development',name='warning'),
    meta(content='CDATA blocks also saved as file for embedded shader script',name='TODO'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://savage.nps.edu/Savage/license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='Flutter.x3d'),
    Background(groundAngle=[1.57],groundColor=[(0.0,0.0,0.0),(0.0,0.7,0.0)],skyAngle=[1.07,1.45,1.52,1.57],skyColor=[(0.0,0.0,0.39),(0.0,0.0,0.7),(0.45,0.7,0.8),(0.7,0.4,0.0),(1.0,0.0,0.0)]),
    NavigationInfo(),
    Viewpoint(description='Pool of Water'),
    Group(
      children=[
      Group(
        children=[
        Shape(
          geometry=IndexedLineSet(colorIndex=[0,0,0,0,0,0],colorPerVertex=False,coordIndex=[0,1,2,3,0,-1,4,5,6,7,4,-1,0,4,-1,1,5,-1,2,6,-1,3,7,-1],
            coord=Coordinate(point=[(-2,-2,-2),(2,-2,-2),(2,2,-2),(-2,2,-2),(-2,-2,2),(2,-2,2),(2,2,2),(-2,2,2)]),
            color=Color(color=[(0,0,1)]))),
        #  slider on X axis 
        Transform(translation=(0,-2,-2),
          children=[
          Transform(DEF='mySphereX',
            children=[
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(1,1,0))),
              geometry=Sphere(radius=0.2)),
            PlaneSensor(DEF='mySensorX',description='amount of ripples',maxPosition=(2,0),minPosition=(-1.8,0))])]),
        #  slider on Y axis 
        Transform(translation=(-2,0,-2),
          children=[
          Transform(DEF='mySphereY',
            children=[
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(1,1,0))),
              geometry=Sphere(radius=0.2)),
            PlaneSensor(DEF='mySensorY',description='brightness',maxPosition=(0,2),minPosition=(0,-1.8))])]),
        #  slider on Z axis 
        Transform(rotation=(1,0,0,1.57),translation=(-2,-2,0),
          children=[
          Transform(DEF='mySphereZ',
            children=[
            Shape(
              appearance=Appearance(
                material=Material(diffuseColor=(1,1,0))),
              geometry=Sphere(radius=0.2)),
            PlaneSensor(DEF='mySensorZ',description='height/depth of ripples',maxPosition=(0,2),minPosition=(0,-1.8))])])]),
      #  
      Transform(scale=(3,3,3),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(0,0.5,1)),
            shaders=[
            ComposedShader(DEF='Shader',language='GLSL',
              field=[
              field(accessType='inputOnly',name='fraction',type='SFFloat'),
              field(accessType='inputOnly',name='xBall',type='SFVec3f'),
              field(accessType='inputOnly',name='yBall',type='SFVec3f'),
              field(accessType='inputOnly',name='zBall',type='SFVec3f')],
              #  <ShaderPart default type="VERTEX" 
              parts=[
              ShaderPart(),
              ShaderPart(type='FRAGMENT')])]),
          geometry=IndexedFaceSet(DEF='Wave',coordIndex=[0,1,201,200,-1,1,2,202,201,-1,2,3,203,202,-1,3,4,204,203,-1,4,5,205,204,-1,5,6,206,205,-1,6,7,207,206,-1,7,8,208,207,-1,8,9,209,208,-1,9,10,210,209,-1,10,11,211,210,-1,11,12,212,211,-1,12,13,213,212,-1,13,14,214,213,-1,14,15,215,214,-1,15,16,216,215,-1,16,17,217,216,-1,17,18,218,217,-1,18,19,219,218,-1,19,20,220,219,-1,20,21,221,220,-1,21,22,222,221,-1,22,23,223,222,-1,23,24,224,223,-1,24,25,225,224,-1,25,26,226,225,-1,26,27,227,226,-1,27,28,228,227,-1,28,29,229,228,-1,29,30,230,229,-1,30,31,231,230,-1,31,32,232,231,-1,32,33,233,232,-1,33,34,234,233,-1,34,35,235,234,-1,35,36,236,235,-1,36,37,237,236,-1,37,38,238,237,-1,38,39,239,238,-1,39,40,240,239,-1,40,41,241,240,-1,41,42,242,241,-1,42,43,243,242,-1,43,44,244,243,-1,44,45,245,244,-1,45,46,246,245,-1,46,47,247,246,-1,47,48,248,247,-1,48,49,249,248,-1,49,50,250,249,-1,50,51,251,250,-1,51,52,252,251,-1,52,53,253,252,-1,53,54,254,253,-1,54,55,255,254,-1,55,56,256,255,-1,56,57,257,256,-1,57,58,258,257,-1,58,59,259,258,-1,59,60,260,259,-1,60,61,261,260,-1,61,62,262,261,-1,62,63,263,262,-1,63,64,264,263,-1,64,65,265,264,-1,65,66,266,265,-1,66,67,267,266,-1,67,68,268,267,-1,68,69,269,268,-1,69,70,270,269,-1,70,71,271,270,-1,71,72,272,271,-1,72,73,273,272,-1,73,74,274,273,-1,74,75,275,274,-1,75,76,276,275,-1,76,77,277,276,-1,77,78,278,277,-1,78,79,279,278,-1,79,80,280,279,-1,80,81,281,280,-1,81,82,282,281,-1,82,83,283,282,-1,83,84,284,283,-1,84,85,285,284,-1,85,86,286,285,-1,86,87,287,286,-1,87,88,288,287,-1,88,89,289,288,-1,89,90,290,289,-1,90,91,291,290,-1,91,92,292,291,-1,92,93,293,292,-1,93,94,294,293,-1,94,95,295,294,-1,95,96,296,295,-1,96,97,297,296,-1,97,98,298,297,-1,98,99,299,298,-1,99,100,300,299,-1,100,101,301,300,-1,101,102,302,301,-1,102,103,303,302,-1,103,104,304,303,-1,104,105,305,304,-1,105,106,306,305,-1,106,107,307,306,-1,107,108,308,307,-1,108,109,309,308,-1,109,110,310,309,-1,110,111,311,310,-1,111,112,312,311,-1,112,113,313,312,-1,113,114,314,313,-1,114,115,315,314,-1,115,116,316,315,-1,116,117,317,316,-1,117,118,318,317,-1,118,119,319,318,-1,119,120,320,319,-1,120,121,321,320,-1,121,122,322,321,-1,122,123,323,322,-1,123,124,324,323,-1,124,125,325,324,-1,125,126,326,325,-1,126,127,327,326,-1,127,128,328,327,-1,128,129,329,328,-1,129,130,330,329,-1,130,131,331,330,-1,131,132,332,331,-1,132,133,333,332,-1,133,134,334,333,-1,134,135,335,334,-1,135,136,336,335,-1,136,137,337,336,-1,137,138,338,337,-1,138,139,339,338,-1,139,140,340,339,-1,140,141,341,340,-1,141,142,342,341,-1,142,143,343,342,-1,143,144,344,343,-1,144,145,345,344,-1,145,146,346,345,-1,146,147,347,346,-1,147,148,348,347,-1,148,149,349,348,-1,149,150,350,349,-1,150,151,351,350,-1,151,152,352,351,-1,152,153,353,352,-1,153,154,354,353,-1,154,155,355,354,-1,155,156,356,355,-1,156,157,357,356,-1,157,158,358,357,-1,158,159,359,358,-1,159,160,360,359,-1,160,161,361,360,-1,161,162,362,361,-1,162,163,363,362,-1,163,164,364,363,-1,164,165,365,364,-1,165,166,366,365,-1,166,167,367,366,-1,167,168,368,367,-1,168,169,369,368,-1,169,170,370,369,-1,170,171,371,370,-1,171,172,372,371,-1,172,173,373,372,-1,173,174,374,373,-1,174,175,375,374,-1,175,176,376,375,-1,176,177,377,376,-1,177,178,378,377,-1,178,179,379,378,-1,179,180,380,379,-1,180,181,381,380,-1,181,182,382,381,-1,182,183,383,382,-1,183,184,384,383,-1,184,185,385,384,-1,185,186,386,385,-1,186,187,387,386,-1,187,188,388,387,-1,188,189,389,388,-1,189,190,390,389,-1,190,191,391,390,-1,191,192,392,391,-1,192,193,393,392,-1,193,194,394,393,-1,194,195,395,394,-1,195,196,396,395,-1,196,197,397,396,-1,197,198,398,397,-1,198,199,399,398,-1,200,201,401,400,-1,201,202,402,401,-1,202,203,403,402,-1,203,204,404,403,-1,204,205,405,404,-1,205,206,406,405,-1,206,207,407,406,-1,207,208,408,407,-1,208,209,409,408,-1,209,210,410,409,-1,210,211,411,410,-1,211,212,412,411,-1,212,213,413,412,-1,213,214,414,413,-1,214,215,415,414,-1,215,216,416,415,-1,216,217,417,416,-1,217,218,418,417,-1,218,219,419,418,-1,219,220,420,419,-1,220,221,421,420,-1,221,222,422,421,-1,222,223,423,422,-1,223,224,424,423,-1,224,225,425,424,-1,225,226,426,425,-1,226,227,427,426,-1,227,228,428,427,-1,228,229,429,428,-1,229,230,430,429,-1,230,231,431,430,-1,231,232,432,431,-1,232,233,433,432,-1,233,234,434,433,-1,234,235,435,434,-1,235,236,436,435,-1,236,237,437,436,-1,237,238,438,437,-1,238,239,439,438,-1,239,240,440,439,-1,240,241,441,440,-1,241,242,442,441,-1,242,243,443,442,-1,243,244,444,443,-1,244,245,445,444,-1,245,246,446,445,-1,246,247,447,446,-1,247,248,448,447,-1,248,249,449,448,-1,249,250,450,449,-1,250,251,451,450,-1,251,252,452,451,-1,252,253,453,452,-1,253,254,454,453,-1,254,255,455,454,-1,255,256,456,455,-1,256,257,457,456,-1,257,258,458,457,-1,258,259,459,458,-1,259,260,460,459,-1,260,261,461,460,-1,261,262,462,461,-1,262,263,463,462,-1,263,264,464,463,-1,264,265,465,464,-1,265,266,466,465,-1,266,267,467,466,-1,267,268,468,467,-1,268,269,469,468,-1,269,270,470,469,-1,270,271,471,470,-1,271,272,472,471,-1,272,273,473,472,-1,273,274,474,473,-1,274,275,475,474,-1,275,276,476,475,-1,276,277,477,476,-1,277,278,478,477,-1,278,279,479,478,-1,279,280,480,479,-1,280,281,481,480,-1,281,282,482,481,-1,282,283,483,482,-1,283,284,484,483,-1,284,285,485,484,-1,285,286,486,485,-1,286,287,487,486,-1,287,288,488,487,-1,288,289,489,488,-1,289,290,490,489,-1,290,291,491,490,-1,291,292,492,491,-1,292,293,493,492,-1,293,294,494,493,-1,294,295,495,494,-1,295,296,496,495,-1,296,297,497,496,-1,297,298,498,497,-1,298,299,499,498,-1,299,300,500,499,-1,300,301,501,500,-1,301,302,502,501,-1,302,303,503,502,-1,303,304,504,503,-1,304,305,505,504,-1,305,306,506,505,-1,306,307,507,506,-1,307,308,508,507,-1,308,309,509,508,-1,309,310,510,509,-1,310,311,511,510,-1,311,312,512,511,-1,312,313,513,512,-1,313,314,514,513,-1,314,315,515,514,-1,315,316,516,515,-1,316,317,517,516,-1,317,318,518,517,-1,318,319,519,518,-1,319,320,520,519,-1,320,321,521,520,-1,321,322,522,521,-1,322,323,523,522,-1,323,324,524,523,-1,324,325,525,524,-1,325,326,526,525,-1,326,327,527,526,-1,327,328,528,527,-1,328,329,529,528,-1,329,330,530,529,-1,330,331,531,530,-1,331,332,532,531,-1,332,333,533,532,-1,333,334,534,533,-1,334,335,535,534,-1,335,336,536,535,-1,336,337,537,536,-1,337,338,538,537,-1,338,339,539,538,-1,339,340,540,539,-1,340,341,541,540,-1,341,342,542,541,-1,342,343,543,542,-1,343,344,544,543,-1,344,345,545,544,-1,345,346,546,545,-1,346,347,547,546,-1,347,348,548,547,-1,348,349,549,548,-1,349,350,550,549,-1,350,351,551,550,-1,351,352,552,551,-1,352,353,553,552,-1,353,354,554,553,-1,354,355,555,554,-1,355,356,556,555,-1,356,357,557,556,-1,357,358,558,557,-1,358,359,559,558,-1,359,360,560,559,-1,360,361,561,560,-1,361,362,562,561,-1,362,363,563,562,-1,363,364,564,563,-1,364,365,565,564,-1,365,366,566,565,-1,366,367,567,566,-1,367,368,568,567,-1,368,369,569,568,-1,369,370,570,569,-1,370,371,571,570,-1,371,372,572,571,-1,372,373,573,572,-1,373,374,574,573,-1,374,375,575,574,-1,375,376,576,575,-1,376,377,577,576,-1,377,378,578,577,-1,378,379,579,578,-1,379,380,580,579,-1,380,381,581,580,-1,381,382,582,581,-1,382,383,583,582,-1,383,384,584,583,-1,384,385,585,584,-1,385,386,586,585,-1,386,387,587,586,-1,387,388,588,587,-1,388,389,589,588,-1,389,390,590,589,-1,390,391,591,590,-1,391,392,592,591,-1,392,393,593,592,-1,393,394,594,593,-1,394,395,595,594,-1,395,396,596,595,-1,396,397,597,596,-1,397,398,598,597,-1,398,399,599,598,-1,400,401,601,600,-1,401,402,602,601,-1,402,403,603,602,-1,403,404,604,603,-1,404,405,605,604,-1,405,406,606,605,-1,406,407,607,606,-1,407,408,608,607,-1,408,409,609,608,-1,409,410,610,609,-1,410,411,611,610,-1,411,412,612,611,-1,412,413,613,612,-1,413,414,614,613,-1,414,415,615,614,-1,415,416,616,615,-1,416,417,617,616,-1,417,418,618,617,-1,418,419,619,618,-1,419,420,620,619,-1,420,421,621,620,-1,421,422,622,621,-1,422,423,623,622,-1,423,424,624,623,-1,424,425,625,624,-1,425,426,626,625,-1,426,427,627,626,-1,427,428,628,627,-1,428,429,629,628,-1,429,430,630,629,-1,430,431,631,630,-1,431,432,632,631,-1,432,433,633,632,-1,433,434,634,633,-1,434,435,635,634,-1,435,436,636,635,-1,436,437,637,636,-1,437,438,638,637,-1,438,439,639,638,-1,439,440,640,639,-1,440,441,641,640,-1,441,442,642,641,-1,442,443,643,642,-1,443,444,644,643,-1,444,445,645,644,-1,445,446,646,645,-1,446,447,647,646,-1,447,448,648,647,-1,448,449,649,648,-1,449,450,650,649,-1,450,451,651,650,-1,451,452,652,651,-1,452,453,653,652,-1,453,454,654,653,-1,454,455,655,654,-1,455,456,656,655,-1,456,457,657,656,-1,457,458,658,657,-1,458,459,659,658,-1,459,460,660,659,-1,460,461,661,660,-1,461,462,662,661,-1,462,463,663,662,-1,463,464,664,663,-1,464,465,665,664,-1,465,466,666,665,-1,466,467,667,666,-1,467,468,668,667,-1,468,469,669,668,-1,469,470,670,669,-1,470,471,671,670,-1,471,472,672,671,-1,472,473,673,672,-1,473,474,674,673,-1,474,475,675,674,-1,475,476,676,675,-1,476,477,677,676,-1,477,478,678,677,-1,478,479,679,678,-1,479,480,680,679,-1,480,481,681,680,-1,481,482,682,681,-1,482,483,683,682,-1,483,484,684,683,-1,484,485,685,684,-1,485,486,686,685,-1,486,487,687,686,-1,487,488,688,687,-1,488,489,689,688,-1,489,490,690,689,-1,490,491,691,690,-1,491,492,692,691,-1,492,493,693,692,-1,493,494,694,693,-1,494,495,695,694,-1,495,496,696,695,-1,496,497,697,696,-1,497,498,698,697,-1,498,499,699,698,-1,499,500,700,699,-1,500,501,701,700,-1,501,502,702,701,-1,502,503,703,702,-1,503,504,704,703,-1,504,505,705,704,-1,505,506,706,705,-1,506,507,707,706,-1,507,508,708,707,-1,508,509,709,708,-1,509,510,710,709,-1,510,511,711,710,-1,511,512,712,711,-1,512,513,713,712,-1,513,514,714,713,-1,514,515,715,714,-1,515,516,716,715,-1,516,517,717,716,-1,517,518,718,717,-1,518,519,719,718,-1,519,520,720,719,-1,520,521,721,720,-1,521,522,722,721,-1,522,523,723,722,-1,523,524,724,723,-1,524,525,725,724,-1,525,526,726,725,-1,526,527,727,726,-1,527,528,728,727,-1,528,529,729,728,-1,529,530,730,729,-1,530,531,731,730,-1,531,532,732,731,-1,532,533,733,732,-1,533,534,734,733,-1,534,535,735,734,-1,535,536,736,735,-1,536,537,737,736,-1,537,538,738,737,-1,538,539,739,738,-1,539,540,740,739,-1,540,541,741,740,-1,541,542,742,741,-1,542,543,743,742,-1,543,544,744,743,-1,544,545,745,744,-1,545,546,746,745,-1,546,547,747,746,-1,547,548,748,747,-1,548,549,749,748,-1,549,550,750,749,-1,550,551,751,750,-1,551,552,752,751,-1,552,553,753,752,-1,553,554,754,753,-1,554,555,755,754,-1,555,556,756,755,-1,556,557,757,756,-1,557,558,758,757,-1,558,559,759,758,-1,559,560,760,759,-1,560,561,761,760,-1,561,562,762,761,-1,562,563,763,762,-1,563,564,764,763,-1,564,565,765,764,-1,565,566,766,765,-1,566,567,767,766,-1,567,568,768,767,-1,568,569,769,768,-1,569,570,770,769,-1,570,571,771,770,-1,571,572,772,771,-1,572,573,773,772,-1,573,574,774,773,-1,574,575,775,774,-1,575,576,776,775,-1,576,577,777,776,-1,577,578,778,777,-1,578,579,779,778,-1,579,580,780,779,-1,580,581,781,780,-1,581,582,782,781,-1,582,583,783,782,-1,583,584,784,783,-1,584,585,785,784,-1,585,586,786,785,-1,586,587,787,786,-1,587,588,788,787,-1,588,589,789,788,-1,589,590,790,789,-1,590,591,791,790,-1,591,592,792,791,-1,592,593,793,792,-1,593,594,794,793,-1,594,595,795,794,-1,595,596,796,795,-1,596,597,797,796,-1,597,598,798,797,-1,598,599,799,798,-1,600,601,801,800,-1,601,602,802,801,-1,602,603,803,802,-1,603,604,804,803,-1,604,605,805,804,-1,605,606,806,805,-1,606,607,807,806,-1,607,608,808,807,-1,608,609,809,808,-1,609,610,810,809,-1,610,611,811,810,-1,611,612,812,811,-1,612,613,813,812,-1,613,614,814,813,-1,614,615,815,814,-1,615,616,816,815,-1,616,617,817,816,-1,617,618,818,817,-1,618,619,819,818,-1,619,620,820,819,-1,620,621,821,820,-1,621,622,822,821,-1,622,623,823,822,-1,623,624,824,823,-1,624,625,825,824,-1,625,626,826,825,-1,626,627,827,826,-1,627,628,828,827,-1,628,629,829,828,-1,629,630,830,829,-1,630,631,831,830,-1,631,632,832,831,-1,632,633,833,832,-1,633,634,834,833,-1,634,635,835,834,-1,635,636,836,835,-1,636,637,837,836,-1,637,638,838,837,-1,638,639,839,838,-1,639,640,840,839,-1,640,641,841,840,-1,641,642,842,841,-1,642,643,843,842,-1,643,644,844,843,-1,644,645,845,844,-1,645,646,846,845,-1,646,647,847,846,-1,647,648,848,847,-1,648,649,849,848,-1,649,650,850,849,-1,650,651,851,850,-1,651,652,852,851,-1,652,653,853,852,-1,653,654,854,853,-1,654,655,855,854,-1,655,656,856,855,-1,656,657,857,856,-1,657,658,858,857,-1,658,659,859,858,-1,659,660,860,859,-1,660,661,861,860,-1,661,662,862,861,-1,662,663,863,862,-1,663,664,864,863,-1,664,665,865,864,-1,665,666,866,865,-1,666,667,867,866,-1,667,668,868,867,-1,668,669,869,868,-1,669,670,870,869,-1,670,671,871,870,-1,671,672,872,871,-1,672,673,873,872,-1,673,674,874,873,-1,674,675,875,874,-1,675,676,876,875,-1,676,677,877,876,-1,677,678,878,877,-1,678,679,879,878,-1,679,680,880,879,-1,680,681,881,880,-1,681,682,882,881,-1,682,683,883,882,-1,683,684,884,883,-1,684,685,885,884,-1,685,686,886,885,-1,686,687,887,886,-1,687,688,888,887,-1,688,689,889,888,-1,689,690,890,889,-1,690,691,891,890,-1,691,692,892,891,-1,692,693,893,892,-1,693,694,894,893,-1,694,695,895,894,-1,695,696,896,895,-1,696,697,897,896,-1,697,698,898,897,-1,698,699,899,898,-1,699,700,900,899,-1,700,701,901,900,-1,701,702,902,901,-1,702,703,903,902,-1,703,704,904,903,-1,704,705,905,904,-1,705,706,906,905,-1,706,707,907,906,-1,707,708,908,907,-1,708,709,909,908,-1,709,710,910,909,-1,710,711,911,910,-1,711,712,912,911,-1,712,713,913,912,-1,713,714,914,913,-1,714,715,915,914,-1,715,716,916,915,-1,716,717,917,916,-1,717,718,918,917,-1,718,719,919,918,-1,719,720,920,919,-1,720,721,921,920,-1,721,722,922,921,-1,722,723,923,922,-1,723,724,924,923,-1,724,725,925,924,-1,725,726,926,925,-1,726,727,927,926,-1,727,728,928,927,-1,728,729,929,928,-1,729,730,930,929,-1,730,731,931,930,-1,731,732,932,931,-1,732,733,933,932,-1,733,734,934,933,-1,734,735,935,934,-1,735,736,936,935,-1,736,737,937,936,-1,737,738,938,937,-1,738,739,939,938,-1,739,740,940,939,-1,740,741,941,940,-1,741,742,942,941,-1,742,743,943,942,-1,743,744,944,943,-1,744,745,945,944,-1,745,746,946,945,-1,746,747,947,946,-1,747,748,948,947,-1,748,749,949,948,-1,749,750,950,949,-1,750,751,951,950,-1,751,752,952,951,-1,752,753,953,952,-1,753,754,954,953,-1,754,755,955,954,-1,755,756,956,955,-1,756,757,957,956,-1,757,758,958,957,-1,758,759,959,958,-1,759,760,960,959,-1,760,761,961,960,-1,761,762,962,961,-1,762,763,963,962,-1,763,764,964,963,-1,764,765,965,964,-1,765,766,966,965,-1,766,767,967,966,-1,767,768,968,967,-1,768,769,969,968,-1,769,770,970,969,-1,770,771,971,970,-1,771,772,972,971,-1,772,773,973,972,-1,773,774,974,973,-1,774,775,975,974,-1,775,776,976,975,-1,776,777,977,976,-1,777,778,978,977,-1,778,779,979,978,-1,779,780,980,979,-1,780,781,981,980,-1,781,782,982,981,-1,782,783,983,982,-1,783,784,984,983,-1,784,785,985,984,-1,785,786,986,985,-1,786,787,987,986,-1,787,788,988,987,-1,788,789,989,988,-1,789,790,990,989,-1,790,791,991,990,-1,791,792,992,991,-1,792,793,993,992,-1,793,794,994,993,-1,794,795,995,994,-1,795,796,996,995,-1,796,797,997,996,-1,797,798,998,997,-1,798,799,999,998,-1,800,801,1001,1,-1,801,802,1002,1001,-1,802,803,1003,1002,-1,803,804,1004,1003,-1,804,805,1005,1004,-1,805,806,1006,1005,-1,806,807,1007,1006,-1,807,808,1008,1007,-1,808,809,1009,1008,-1,809,810,1010,1009,-1,810,811,1011,1010,-1,811,812,1012,1011,-1,812,813,1013,1012,-1,813,814,1014,1013,-1,814,815,1015,1014,-1,815,816,1016,1015,-1,816,817,1017,1016,-1,817,818,1018,1017,-1,818,819,1019,1018,-1,819,820,1020,1019,-1,820,821,1021,1020,-1,821,822,1022,1021,-1,822,823,1023,1022,-1,823,824,1024,1023,-1,824,825,1025,1024,-1,825,826,1026,1025,-1,826,827,1027,1026,-1,827,828,1028,1027,-1,828,829,1029,1028,-1,829,830,1030,1029,-1,830,831,1031,1030,-1,831,832,1032,1031,-1,832,833,1033,1032,-1,833,834,1034,1033,-1,834,835,1035,1034,-1,835,836,1036,1035,-1,836,837,1037,1036,-1,837,838,1038,1037,-1,838,839,1039,1038,-1,839,840,1040,1039,-1,840,841,1041,1040,-1,841,842,1042,1041,-1,842,843,1043,1042,-1,843,844,1044,1043,-1,844,845,1045,1044,-1,845,846,1046,1045,-1,846,847,1047,1046,-1,847,848,1048,1047,-1,848,849,1049,1048,-1,849,850,1050,1049,-1,850,851,1051,1050,-1,851,852,1052,1051,-1,852,853,1053,1052,-1,853,854,1054,1053,-1,854,855,1055,1054,-1,855,856,1056,1055,-1,856,857,1057,1056,-1,857,858,1058,1057,-1,858,859,1059,1058,-1,859,860,1060,1059,-1,860,861,1061,1060,-1,861,862,1062,1061,-1,862,863,1063,1062,-1,863,864,1064,1063,-1,864,865,1065,1064,-1,865,866,1066,1065,-1,866,867,1067,1066,-1,867,868,1068,1067,-1,868,869,1069,1068,-1,869,870,1070,1069,-1,870,871,1071,1070,-1,871,872,1072,1071,-1,872,873,1073,1072,-1,873,874,1074,1073,-1,874,875,1075,1074,-1,875,876,1076,1075,-1,876,877,1077,1076,-1,877,878,1078,1077,-1,878,879,1079,1078,-1,879,880,1080,1079,-1,880,881,1081,1080,-1,881,882,1082,1081,-1,882,883,1083,1082,-1,883,884,1084,1083,-1,884,885,1085,1084,-1,885,886,1086,1085,-1,886,887,1087,1086,-1,887,888,1088,1087,-1,888,889,1089,1088,-1,889,890,1090,1089,-1,890,891,1091,1090,-1,891,892,1092,1091,-1,892,893,1093,1092,-1,893,894,1094,1093,-1,894,895,1095,1094,-1,895,896,1096,1095,-1,896,897,1097,1096,-1,897,898,1098,1097,-1,898,899,1099,1098,-1,899,900,1100,1099,-1,900,901,1101,1100,-1,901,902,1102,1101,-1,902,903,1103,1102,-1,903,904,1104,1103,-1,904,905,1105,1104,-1,905,906,1106,1105,-1,906,907,1107,1106,-1,907,908,1108,1107,-1,908,909,1109,1108,-1,909,910,1110,1109,-1,910,911,1111,1110,-1,911,912,1112,1111,-1,912,913,1113,1112,-1,913,914,1114,1113,-1,914,915,1115,1114,-1,915,916,1116,1115,-1,916,917,1117,1116,-1,917,918,1118,1117,-1,918,919,1119,1118,-1,919,920,1120,1119,-1,920,921,1121,1120,-1,921,922,1122,1121,-1,922,923,1123,1122,-1,923,924,1124,1123,-1,924,925,1125,1124,-1,925,926,1126,1125,-1,926,927,1127,1126,-1,927,928,1128,1127,-1,928,929,1129,1128,-1,929,930,1130,1129,-1,930,931,1131,1130,-1,931,932,1132,1131,-1,932,933,1133,1132,-1,933,934,1134,1133,-1,934,935,1135,1134,-1,935,936,1136,1135,-1,936,937,1137,1136,-1,937,938,1138,1137,-1,938,939,1139,1138,-1,939,940,1140,1139,-1,940,941,1141,1140,-1,941,942,1142,1141,-1,942,943,1143,1142,-1,943,944,1144,1143,-1,944,945,1145,1144,-1,945,946,1146,1145,-1,946,947,1147,1146,-1,947,948,1148,1147,-1,948,949,1149,1148,-1,949,950,1150,1149,-1,950,951,1151,1150,-1,951,952,1152,1151,-1,952,953,1153,1152,-1,953,954,1154,1153,-1,954,955,1155,1154,-1,955,956,1156,1155,-1,956,957,1157,1156,-1,957,958,1158,1157,-1,958,959,1159,1158,-1,959,960,1160,1159,-1,960,961,1161,1160,-1,961,962,1162,1161,-1,962,963,1163,1162,-1,963,964,1164,1163,-1,964,965,1165,1164,-1,965,966,1166,1165,-1,966,967,1167,1166,-1,967,968,1168,1167,-1,968,969,1169,1168,-1,969,970,1170,1169,-1,970,971,1171,1170,-1,971,972,1172,1171,-1,972,973,1173,1172,-1,973,974,1174,1173,-1,974,975,1175,1174,-1,975,976,1176,1175,-1,976,977,1177,1176,-1,977,978,1178,1177,-1,978,979,1179,1178,-1,979,980,1180,1179,-1,980,981,1181,1180,-1,981,982,1182,1181,-1,982,983,1183,1182,-1,983,984,1184,1183,-1,984,985,1185,1184,-1,985,986,1186,1185,-1,986,987,1187,1186,-1,987,988,1188,1187,-1,988,989,1189,1188,-1,989,990,1190,1189,-1,990,991,1191,1190,-1,991,992,1192,1191,-1,992,993,1193,1192,-1,993,994,1194,1193,-1,994,995,1195,1194,-1,995,996,1196,1195,-1,996,997,1197,1196,-1,997,998,1198,1197,-1,998,999,1199,1198,-1,1,1001,1201,1200,-1,1001,1002,1202,1201,-1,1002,1003,1203,1202,-1,1003,1004,1204,1203,-1,1004,1005,1205,1204,-1,1005,1006,1206,1205,-1,1006,1007,1207,1206,-1,1007,1008,1208,1207,-1,1008,1009,1209,1208,-1,1009,1010,1210,1209,-1,1010,1011,1211,1210,-1,1011,1012,1212,1211,-1,1012,1013,1213,1212,-1,1013,1014,1214,1213,-1,1014,1015,1215,1214,-1,1015,1016,1216,1215,-1,1016,1017,1217,1216,-1,1017,1018,1218,1217,-1,1018,1019,1219,1218,-1,1019,1020,1220,1219,-1,1020,1021,1221,1220,-1,1021,1022,1222,1221,-1,1022,1023,1223,1222,-1,1023,1024,1224,1223,-1,1024,1025,1225,1224,-1,1025,1026,1226,1225,-1,1026,1027,1227,1226,-1,1027,1028,1228,1227,-1,1028,1029,1229,1228,-1,1029,1030,1230,1229,-1,1030,1031,1231,1230,-1,1031,1032,1232,1231,-1,1032,1033,1233,1232,-1,1033,1034,1234,1233,-1,1034,1035,1235,1234,-1,1035,1036,1236,1235,-1,1036,1037,1237,1236,-1,1037,1038,1238,1237,-1,1038,1039,1239,1238,-1,1039,1040,1240,1239,-1,1040,1041,1241,1240,-1,1041,1042,1242,1241,-1,1042,1043,1243,1242,-1,1043,1044,1244,1243,-1,1044,1045,1245,1244,-1,1045,1046,1246,1245,-1,1046,1047,1247,1246,-1,1047,1048,1248,1247,-1,1048,1049,1249,1248,-1,1049,1050,1250,1249,-1,1050,1051,1251,1250,-1,1051,1052,1252,1251,-1,1052,1053,1253,1252,-1,1053,1054,1254,1253,-1,1054,1055,1255,1254,-1,1055,1056,1256,1255,-1,1056,1057,1257,1256,-1,1057,1058,1258,1257,-1,1058,1059,1259,1258,-1,1059,1060,1260,1259,-1,1060,1061,1261,1260,-1,1061,1062,1262,1261,-1,1062,1063,1263,1262,-1,1063,1064,1264,1263,-1,1064,1065,1265,1264,-1,1065,1066,1266,1265,-1,1066,1067,1267,1266,-1,1067,1068,1268,1267,-1,1068,1069,1269,1268,-1,1069,1070,1270,1269,-1,1070,1071,1271,1270,-1,1071,1072,1272,1271,-1,1072,1073,1273,1272,-1,1073,1074,1274,1273,-1,1074,1075,1275,1274,-1,1075,1076,1276,1275,-1,1076,1077,1277,1276,-1,1077,1078,1278,1277,-1,1078,1079,1279,1278,-1,1079,1080,1280,1279,-1,1080,1081,1281,1280,-1,1081,1082,1282,1281,-1,1082,1083,1283,1282,-1,1083,1084,1284,1283,-1,1084,1085,1285,1284,-1,1085,1086,1286,1285,-1,1086,1087,1287,1286,-1,1087,1088,1288,1287,-1,1088,1089,1289,1288,-1,1089,1090,1290,1289,-1,1090,1091,1291,1290,-1,1091,1092,1292,1291,-1,1092,1093,1293,1292,-1,1093,1094,1294,1293,-1,1094,1095,1295,1294,-1,1095,1096,1296,1295,-1,1096,1097,1297,1296,-1,1097,1098,1298,1297,-1,1098,1099,1299,1298,-1,1099,1100,1300,1299,-1,1100,1101,1301,1300,-1,1101,1102,1302,1301,-1,1102,1103,1303,1302,-1,1103,1104,1304,1303,-1,1104,1105,1305,1304,-1,1105,1106,1306,1305,-1,1106,1107,1307,1306,-1,1107,1108,1308,1307,-1,1108,1109,1309,1308,-1,1109,1110,1310,1309,-1,1110,1111,1311,1310,-1,1111,1112,1312,1311,-1,1112,1113,1313,1312,-1,1113,1114,1314,1313,-1,1114,1115,1315,1314,-1,1115,1116,1316,1315,-1,1116,1117,1317,1316,-1,1117,1118,1318,1317,-1,1118,1119,1319,1318,-1,1119,1120,1320,1319,-1,1120,1121,1321,1320,-1,1121,1122,1322,1321,-1,1122,1123,1323,1322,-1,1123,1124,1324,1323,-1,1124,1125,1325,1324,-1,1125,1126,1326,1325,-1,1126,1127,1327,1326,-1,1127,1128,1328,1327,-1,1128,1129,1329,1328,-1,1129,1130,1330,1329,-1,1130,1131,1331,1330,-1,1131,1132,1332,1331,-1,1132,1133,1333,1332,-1,1133,1134,1334,1333,-1,1134,1135,1335,1334,-1,1135,1136,1336,1335,-1,1136,1137,1337,1336,-1,1137,1138,1338,1337,-1,1138,1139,1339,1338,-1,1139,1140,1340,1339,-1,1140,1141,1341,1340,-1,1141,1142,1342,1341,-1,1142,1143,1343,1342,-1,1143,1144,1344,1343,-1,1144,1145,1345,1344,-1,1145,1146,1346,1345,-1,1146,1147,1347,1346,-1,1147,1148,1348,1347,-1,1148,1149,1349,1348,-1,1149,1150,1350,1349,-1,1150,1151,1351,1350,-1,1151,1152,1352,1351,-1,1152,1153,1353,1352,-1,1153,1154,1354,1353,-1,1154,1155,1355,1354,-1,1155,1156,1356,1355,-1,1156,1157,1357,1356,-1,1157,1158,1358,1357,-1,1158,1159,1359,1358,-1,1159,1160,1360,1359,-1,1160,1161,1361,1360,-1,1161,1162,1362,1361,-1,1162,1163,1363,1362,-1,1163,1164,1364,1363,-1,1164,1165,1365,1364,-1,1165,1166,1366,1365,-1,1166,1167,1367,1366,-1,1167,1168,1368,1367,-1,1168,1169,1369,1368,-1,1169,1170,1370,1369,-1,1170,1171,1371,1370,-1,1171,1172,1372,1371,-1,1172,1173,1373,1372,-1,1173,1174,1374,1373,-1,1174,1175,1375,1374,-1,1175,1176,1376,1375,-1,1176,1177,1377,1376,-1,1177,1178,1378,1377,-1,1178,1179,1379,1378,-1,1179,1180,1380,1379,-1,1180,1181,1381,1380,-1,1181,1182,1382,1381,-1,1182,1183,1383,1382,-1,1183,1184,1384,1383,-1,1184,1185,1385,1384,-1,1185,1186,1386,1385,-1,1186,1187,1387,1386,-1,1187,1188,1388,1387,-1,1188,1189,1389,1388,-1,1189,1190,1390,1389,-1,1190,1191,1391,1390,-1,1191,1192,1392,1391,-1,1192,1193,1393,1392,-1,1193,1194,1394,1393,-1,1194,1195,1395,1394,-1,1195,1196,1396,1395,-1,1196,1197,1397,1396,-1,1197,1198,1398,1397,-1,1198,1199,1399,1398,-1,1200,1201,1401,1400,-1,1201,1202,1402,1401,-1,1202,1203,1403,1402,-1,1203,1204,1404,1403,-1,1204,1205,1405,1404,-1,1205,1206,1406,1405,-1,1206,1207,1407,1406,-1,1207,1208,1408,1407,-1,1208,1209,1409,1408,-1,1209,1210,1410,1409,-1,1210,1211,1411,1410,-1,1211,1212,1412,1411,-1,1212,1213,1413,1412,-1,1213,1214,1414,1413,-1,1214,1215,1415,1414,-1,1215,1216,1416,1415,-1,1216,1217,1417,1416,-1,1217,1218,1418,1417,-1,1218,1219,1419,1418,-1,1219,1220,1420,1419,-1,1220,1221,1421,1420,-1,1221,1222,1422,1421,-1,1222,1223,1423,1422,-1,1223,1224,1424,1423,-1,1224,1225,1425,1424,-1,1225,1226,1426,1425,-1,1226,1227,1427,1426,-1,1227,1228,1428,1427,-1,1228,1229,1429,1428,-1,1229,1230,1430,1429,-1,1230,1231,1431,1430,-1,1231,1232,1432,1431,-1,1232,1233,1433,1432,-1,1233,1234,1434,1433,-1,1234,1235,1435,1434,-1,1235,1236,1436,1435,-1,1236,1237,1437,1436,-1,1237,1238,1438,1437,-1,1238,1239,1439,1438,-1,1239,1240,1440,1439,-1,1240,1241,1441,1440,-1,1241,1242,1442,1441,-1,1242,1243,1443,1442,-1,1243,1244,1444,1443,-1,1244,1245,1445,1444,-1,1245,1246,1446,1445,-1,1246,1247,1447,1446,-1,1247,1248,1448,1447,-1,1248,1249,1449,1448,-1,1249,1250,1450,1449,-1,1250,1251,1451,1450,-1,1251,1252,1452,1451,-1,1252,1253,1453,1452,-1,1253,1254,1454,1453,-1,1254,1255,1455,1454,-1,1255,1256,1456,1455,-1,1256,1257,1457,1456,-1,1257,1258,1458,1457,-1,1258,1259,1459,1458,-1,1259,1260,1460,1459,-1,1260,1261,1461,1460,-1,1261,1262,1462,1461,-1,1262,1263,1463,1462,-1,1263,1264,1464,1463,-1,1264,1265,1465,1464,-1,1265,1266,1466,1465,-1,1266,1267,1467,1466,-1,1267,1268,1468,1467,-1,1268,1269,1469,1468,-1,1269,1270,1470,1469,-1,1270,1271,1471,1470,-1,1271,1272,1472,1471,-1,1272,1273,1473,1472,-1,1273,1274,1474,1473,-1,1274,1275,1475,1474,-1,1275,1276,1476,1475,-1,1276,1277,1477,1476,-1,1277,1278,1478,1477,-1,1278,1279,1479,1478,-1,1279,1280,1480,1479,-1,1280,1281,1481,1480,-1,1281,1282,1482,1481,-1,1282,1283,1483,1482,-1,1283,1284,1484,1483,-1,1284,1285,1485,1484,-1,1285,1286,1486,1485,-1,1286,1287,1487,1486,-1,1287,1288,1488,1487,-1,1288,1289,1489,1488,-1,1289,1290,1490,1489,-1,1290,1291,1491,1490,-1,1291,1292,1492,1491,-1,1292,1293,1493,1492,-1,1293,1294,1494,1493,-1,1294,1295,1495,1494,-1,1295,1296,1496,1495,-1,1296,1297,1497,1496,-1,1297,1298,1498,1497,-1,1298,1299,1499,1498,-1,1299,1300,1500,1499,-1,1300,1301,1501,1500,-1,1301,1302,1502,1501,-1,1302,1303,1503,1502,-1,1303,1304,1504,1503,-1,1304,1305,1505,1504,-1,1305,1306,1506,1505,-1,1306,1307,1507,1506,-1,1307,1308,1508,1507,-1,1308,1309,1509,1508,-1,1309,1310,1510,1509,-1,1310,1311,1511,1510,-1,1311,1312,1512,1511,-1,1312,1313,1513,1512,-1,1313,1314,1514,1513,-1,1314,1315,1515,1514,-1,1315,1316,1516,1515,-1,1316,1317,1517,1516,-1,1317,1318,1518,1517,-1,1318,1319,1519,1518,-1,1319,1320,1520,1519,-1,1320,1321,1521,1520,-1,1321,1322,1522,1521,-1,1322,1323,1523,1522,-1,1323,1324,1524,1523,-1,1324,1325,1525,1524,-1,1325,1326,1526,1525,-1,1326,1327,1527,1526,-1,1327,1328,1528,1527,-1,1328,1329,1529,1528,-1,1329,1330,1530,1529,-1,1330,1331,1531,1530,-1,1331,1332,1532,1531,-1,1332,1333,1533,1532,-1,1333,1334,1534,1533,-1,1334,1335,1535,1534,-1,1335,1336,1536,1535,-1,1336,1337,1537,1536,-1,1337,1338,1538,1537,-1,1338,1339,1539,1538,-1,1339,1340,1540,1539,-1,1340,1341,1541,1540,-1,1341,1342,1542,1541,-1,1342,1343,1543,1542,-1,1343,1344,1544,1543,-1,1344,1345,1545,1544,-1,1345,1346,1546,1545,-1,1346,1347,1547,1546,-1,1347,1348,1548,1547,-1,1348,1349,1549,1548,-1,1349,1350,1550,1549,-1,1350,1351,1551,1550,-1,1351,1352,1552,1551,-1,1352,1353,1553,1552,-1,1353,1354,1554,1553,-1,1354,1355,1555,1554,-1,1355,1356,1556,1555,-1,1356,1357,1557,1556,-1,1357,1358,1558,1557,-1,1358,1359,1559,1558,-1,1359,1360,1560,1559,-1,1360,1361,1561,1560,-1,1361,1362,1562,1561,-1,1362,1363,1563,1562,-1,1363,1364,1564,1563,-1,1364,1365,1565,1564,-1,1365,1366,1566,1565,-1,1366,1367,1567,1566,-1,1367,1368,1568,1567,-1,1368,1369,1569,1568,-1,1369,1370,1570,1569,-1,1370,1371,1571,1570,-1,1371,1372,1572,1571,-1,1372,1373,1573,1572,-1,1373,1374,1574,1573,-1,1374,1375,1575,1574,-1,1375,1376,1576,1575,-1,1376,1377,1577,1576,-1,1377,1378,1578,1577,-1,1378,1379,1579,1578,-1,1379,1380,1580,1579,-1,1380,1381,1581,1580,-1,1381,1382,1582,1581,-1,1382,1383,1583,1582,-1,1383,1384,1584,1583,-1,1384,1385,1585,1584,-1,1385,1386,1586,1585,-1,1386,1387,1587,1586,-1,1387,1388,1588,1587,-1,1388,1389,1589,1588,-1,1389,1390,1590,1589,-1,1390,1391,1591,1590,-1,1391,1392,1592,1591,-1,1392,1393,1593,1592,-1,1393,1394,1594,1593,-1,1394,1395,1595,1594,-1,1395,1396,1596,1595,-1,1396,1397,1597,1596,-1,1397,1398,1598,1597,-1,1398,1399,1599,1598,-1,1400,1401,1601,1600,-1,1401,1402,1602,1601,-1,1402,1403,1603,1602,-1,1403,1404,1604,1603,-1,1404,1405,1605,1604,-1,1405,1406,1606,1605,-1,1406,1407,1607,1606,-1,1407,1408,1608,1607,-1,1408,1409,1609,1608,-1,1409,1410,1610,1609,-1,1410,1411,1611,1610,-1,1411,1412,1612,1611,-1,1412,1413,1613,1612,-1,1413,1414,1614,1613,-1,1414,1415,1615,1614,-1,1415,1416,1616,1615,-1,1416,1417,1617,1616,-1,1417,1418,1618,1617,-1,1418,1419,1619,1618,-1,1419,1420,1620,1619,-1,1420,1421,1621,1620,-1,1421,1422,1622,1621,-1,1422,1423,1623,1622,-1,1423,1424,1624,1623,-1,1424,1425,1625,1624,-1,1425,1426,1626,1625,-1,1426,1427,1627,1626,-1,1427,1428,1628,1627,-1,1428,1429,1629,1628,-1,1429,1430,1630,1629,-1,1430,1431,1631,1630,-1,1431,1432,1632,1631,-1,1432,1433,1633,1632,-1,1433,1434,1634,1633,-1,1434,1435,1635,1634,-1,1435,1436,1636,1635,-1,1436,1437,1637,1636,-1,1437,1438,1638,1637,-1,1438,1439,1639,1638,-1,1439,1440,1640,1639,-1,1440,1441,1641,1640,-1,1441,1442,1642,1641,-1,1442,1443,1643,1642,-1,1443,1444,1644,1643,-1,1444,1445,1645,1644,-1,1445,1446,1646,1645,-1,1446,1447,1647,1646,-1,1447,1448,1648,1647,-1,1448,1449,1649,1648,-1,1449,1450,1650,1649,-1,1450,1451,1651,1650,-1,1451,1452,1652,1651,-1,1452,1453,1653,1652,-1,1453,1454,1654,1653,-1,1454,1455,1655,1654,-1,1455,1456,1656,1655,-1,1456,1457,1657,1656,-1,1457,1458,1658,1657,-1,1458,1459,1659,1658,-1,1459,1460,1660,1659,-1,1460,1461,1661,1660,-1,1461,1462,1662,1661,-1,1462,1463,1663,1662,-1,1463,1464,1664,1663,-1,1464,1465,1665,1664,-1,1465,1466,1666,1665,-1,1466,1467,1667,1666,-1,1467,1468,1668,1667,-1,1468,1469,1669,1668,-1,1469,1470,1670,1669,-1,1470,1471,1671,1670,-1,1471,1472,1672,1671,-1,1472,1473,1673,1672,-1,1473,1474,1674,1673,-1,1474,1475,1675,1674,-1,1475,1476,1676,1675,-1,1476,1477,1677,1676,-1,1477,1478,1678,1677,-1,1478,1479,1679,1678,-1,1479,1480,1680,1679,-1,1480,1481,1681,1680,-1,1481,1482,1682,1681,-1,1482,1483,1683,1682,-1,1483,1484,1684,1683,-1,1484,1485,1685,1684,-1,1485,1486,1686,1685,-1,1486,1487,1687,1686,-1,1487,1488,1688,1687,-1,1488,1489,1689,1688,-1,1489,1490,1690,1689,-1,1490,1491,1691,1690,-1,1491,1492,1692,1691,-1,1492,1493,1693,1692,-1,1493,1494,1694,1693,-1,1494,1495,1695,1694,-1,1495,1496,1696,1695,-1,1496,1497,1697,1696,-1,1497,1498,1698,1697,-1,1498,1499,1699,1698,-1,1499,1500,1700,1699,-1,1500,1501,1701,1700,-1,1501,1502,1702,1701,-1,1502,1503,1703,1702,-1,1503,1504,1704,1703,-1,1504,1505,1705,1704,-1,1505,1506,1706,1705,-1,1506,1507,1707,1706,-1,1507,1508,1708,1707,-1,1508,1509,1709,1708,-1,1509,1510,1710,1709,-1,1510,1511,1711,1710,-1,1511,1512,1712,1711,-1,1512,1513,1713,1712,-1,1513,1514,1714,1713,-1,1514,1515,1715,1714,-1,1515,1516,1716,1715,-1,1516,1517,1717,1716,-1,1517,1518,1718,1717,-1,1518,1519,1719,1718,-1,1519,1520,1720,1719,-1,1520,1521,1721,1720,-1,1521,1522,1722,1721,-1,1522,1523,1723,1722,-1,1523,1524,1724,1723,-1,1524,1525,1725,1724,-1,1525,1526,1726,1725,-1,1526,1527,1727,1726,-1,1527,1528,1728,1727,-1,1528,1529,1729,1728,-1,1529,1530,1730,1729,-1,1530,1531,1731,1730,-1,1531,1532,1732,1731,-1,1532,1533,1733,1732,-1,1533,1534,1734,1733,-1,1534,1535,1735,1734,-1,1535,1536,1736,1735,-1,1536,1537,1737,1736,-1,1537,1538,1738,1737,-1,1538,1539,1739,1738,-1,1539,1540,1740,1739,-1,1540,1541,1741,1740,-1,1541,1542,1742,1741,-1,1542,1543,1743,1742,-1,1543,1544,1744,1743,-1,1544,1545,1745,1744,-1,1545,1546,1746,1745,-1,1546,1547,1747,1746,-1,1547,1548,1748,1747,-1,1548,1549,1749,1748,-1,1549,1550,1750,1749,-1,1550,1551,1751,1750,-1,1551,1552,1752,1751,-1,1552,1553,1753,1752,-1,1553,1554,1754,1753,-1,1554,1555,1755,1754,-1,1555,1556,1756,1755,-1,1556,1557,1757,1756,-1,1557,1558,1758,1757,-1,1558,1559,1759,1758,-1,1559,1560,1760,1759,-1,1560,1561,1761,1760,-1,1561,1562,1762,1761,-1,1562,1563,1763,1762,-1,1563,1564,1764,1763,-1,1564,1565,1765,1764,-1,1565,1566,1766,1765,-1,1566,1567,1767,1766,-1,1567,1568,1768,1767,-1,1568,1569,1769,1768,-1,1569,1570,1770,1769,-1,1570,1571,1771,1770,-1,1571,1572,1772,1771,-1,1572,1573,1773,1772,-1,1573,1574,1774,1773,-1,1574,1575,1775,1774,-1,1575,1576,1776,1775,-1,1576,1577,1777,1776,-1,1577,1578,1778,1777,-1,1578,1579,1779,1778,-1,1579,1580,1780,1779,-1,1580,1581,1781,1780,-1,1581,1582,1782,1781,-1,1582,1583,1783,1782,-1,1583,1584,1784,1783,-1,1584,1585,1785,1784,-1,1585,1586,1786,1785,-1,1586,1587,1787,1786,-1,1587,1588,1788,1787,-1,1588,1589,1789,1788,-1,1589,1590,1790,1789,-1,1590,1591,1791,1790,-1,1591,1592,1792,1791,-1,1592,1593,1793,1792,-1,1593,1594,1794,1793,-1,1594,1595,1795,1794,-1,1595,1596,1796,1795,-1,1596,1597,1797,1796,-1,1597,1598,1798,1797,-1,1598,1599,1799,1798,-1,1600,1601,1801,1800,-1,1601,1602,1802,1801,-1,1602,1603,1803,1802,-1,1603,1604,1804,1803,-1,1604,1605,1805,1804,-1,1605,1606,1806,1805,-1,1606,1607,1807,1806,-1,1607,1608,1808,1807,-1,1608,1609,1809,1808,-1,1609,1610,1810,1809,-1,1610,1611,1811,1810,-1,1611,1612,1812,1811,-1,1612,1613,1813,1812,-1,1613,1614,1814,1813,-1,1614,1615,1815,1814,-1,1615,1616,1816,1815,-1,1616,1617,1817,1816,-1,1617,1618,1818,1817,-1,1618,1619,1819,1818,-1,1619,1620,1820,1819,-1,1620,1621,1821,1820,-1,1621,1622,1822,1821,-1,1622,1623,1823,1822,-1,1623,1624,1824,1823,-1,1624,1625,1825,1824,-1,1625,1626,1826,1825,-1,1626,1627,1827,1826,-1,1627,1628,1828,1827,-1,1628,1629,1829,1828,-1,1629,1630,1830,1829,-1,1630,1631,1831,1830,-1,1631,1632,1832,1831,-1,1632,1633,1833,1832,-1,1633,1634,1834,1833,-1,1634,1635,1835,1834,-1,1635,1636,1836,1835,-1,1636,1637,1837,1836,-1,1637,1638,1838,1837,-1,1638,1639,1839,1838,-1,1639,1640,1840,1839,-1,1640,1641,1841,1840,-1,1641,1642,1842,1841,-1,1642,1643,1843,1842,-1,1643,1644,1844,1843,-1,1644,1645,1845,1844,-1,1645,1646,1846,1845,-1,1646,1647,1847,1846,-1,1647,1648,1848,1847,-1,1648,1649,1849,1848,-1,1649,1650,1850,1849,-1,1650,1651,1851,1850,-1,1651,1652,1852,1851,-1,1652,1653,1853,1852,-1,1653,1654,1854,1853,-1,1654,1655,1855,1854,-1,1655,1656,1856,1855,-1,1656,1657,1857,1856,-1,1657,1658,1858,1857,-1,1658,1659,1859,1858,-1,1659,1660,1860,1859,-1,1660,1661,1861,1860,-1,1661,1662,1862,1861,-1,1662,1663,1863,1862,-1,1663,1664,1864,1863,-1,1664,1665,1865,1864,-1,1665,1666,1866,1865,-1,1666,1667,1867,1866,-1,1667,1668,1868,1867,-1,1668,1669,1869,1868,-1,1669,1670,1870,1869,-1,1670,1671,1871,1870,-1,1671,1672,1872,1871,-1,1672,1673,1873,1872,-1,1673,1674,1874,1873,-1,1674,1675,1875,1874,-1,1675,1676,1876,1875,-1,1676,1677,1877,1876,-1,1677,1678,1878,1877,-1,1678,1679,1879,1878,-1,1679,1680,1880,1879,-1,1680,1681,1881,1880,-1,1681,1682,1882,1881,-1,1682,1683,1883,1882,-1,1683,1684,1884,1883,-1,1684,1685,1885,1884,-1,1685,1686,1886,1885,-1,1686,1687,1887,1886,-1,1687,1688,1888,1887,-1,1688,1689,1889,1888,-1,1689,1690,1890,1889,-1,1690,1691,1891,1890,-1,1691,1692,1892,1891,-1,1692,1693,1893,1892,-1,1693,1694,1894,1893,-1,1694,1695,1895,1894,-1,1695,1696,1896,1895,-1,1696,1697,1897,1896,-1,1697,1698,1898,1897,-1,1698,1699,1899,1898,-1,1699,1700,1900,1899,-1,1700,1701,1901,1900,-1,1701,1702,1902,1901,-1,1702,1703,1903,1902,-1,1703,1704,1904,1903,-1,1704,1705,1905,1904,-1,1705,1706,1906,1905,-1,1706,1707,1907,1906,-1,1707,1708,1908,1907,-1,1708,1709,1909,1908,-1,1709,1710,1910,1909,-1,1710,1711,1911,1910,-1,1711,1712,1912,1911,-1,1712,1713,1913,1912,-1,1713,1714,1914,1913,-1,1714,1715,1915,1914,-1,1715,1716,1916,1915,-1,1716,1717,1917,1916,-1,1717,1718,1918,1917,-1,1718,1719,1919,1918,-1,1719,1720,1920,1919,-1,1720,1721,1921,1920,-1,1721,1722,1922,1921,-1,1722,1723,1923,1922,-1,1723,1724,1924,1923,-1,1724,1725,1925,1924,-1,1725,1726,1926,1925,-1,1726,1727,1927,1926,-1,1727,1728,1928,1927,-1,1728,1729,1929,1928,-1,1729,1730,1930,1929,-1,1730,1731,1931,1930,-1,1731,1732,1932,1931,-1,1732,1733,1933,1932,-1,1733,1734,1934,1933,-1,1734,1735,1935,1934,-1,1735,1736,1936,1935,-1,1736,1737,1937,1936,-1,1737,1738,1938,1937,-1,1738,1739,1939,1938,-1,1739,1740,1940,1939,-1,1740,1741,1941,1940,-1,1741,1742,1942,1941,-1,1742,1743,1943,1942,-1,1743,1744,1944,1943,-1,1744,1745,1945,1944,-1,1745,1746,1946,1945,-1,1746,1747,1947,1946,-1,1747,1748,1948,1947,-1,1748,1749,1949,1948,-1,1749,1750,1950,1949,-1,1750,1751,1951,1950,-1,1751,1752,1952,1951,-1,1752,1753,1953,1952,-1,1753,1754,1954,1953,-1,1754,1755,1955,1954,-1,1755,1756,1956,1955,-1,1756,1757,1957,1956,-1,1757,1758,1958,1957,-1,1758,1759,1959,1958,-1,1759,1760,1960,1959,-1,1760,1761,1961,1960,-1,1761,1762,1962,1961,-1,1762,1763,1963,1962,-1,1763,1764,1964,1963,-1,1764,1765,1965,1964,-1,1765,1766,1966,1965,-1,1766,1767,1967,1966,-1,1767,1768,1968,1967,-1,1768,1769,1969,1968,-1,1769,1770,1970,1969,-1,1770,1771,1971,1970,-1,1771,1772,1972,1971,-1,1772,1773,1973,1972,-1,1773,1774,1974,1973,-1,1774,1775,1975,1974,-1,1775,1776,1976,1975,-1,1776,1777,1977,1976,-1,1777,1778,1978,1977,-1,1778,1779,1979,1978,-1,1779,1780,1980,1979,-1,1780,1781,1981,1980,-1,1781,1782,1982,1981,-1,1782,1783,1983,1982,-1,1783,1784,1984,1983,-1,1784,1785,1985,1984,-1,1785,1786,1986,1985,-1,1786,1787,1987,1986,-1,1787,1788,1988,1987,-1,1788,1789,1989,1988,-1,1789,1790,1990,1989,-1,1790,1791,1991,1990,-1,1791,1792,1992,1991,-1,1792,1793,1993,1992,-1,1793,1794,1994,1993,-1,1794,1795,1995,1994,-1,1795,1796,1996,1995,-1,1796,1797,1997,1996,-1,1797,1798,1998,1997,-1,1798,1799,1999,1998,-1,1800,1801,2001,2,-1,1801,1802,2002,2001,-1,1802,1803,2003,2002,-1,1803,1804,2004,2003,-1,1804,1805,2005,2004,-1,1805,1806,2006,2005,-1,1806,1807,2007,2006,-1,1807,1808,2008,2007,-1,1808,1809,2009,2008,-1,1809,1810,2010,2009,-1,1810,1811,2011,2010,-1,1811,1812,2012,2011,-1,1812,1813,2013,2012,-1,1813,1814,2014,2013,-1,1814,1815,2015,2014,-1,1815,1816,2016,2015,-1,1816,1817,2017,2016,-1,1817,1818,2018,2017,-1,1818,1819,2019,2018,-1,1819,1820,2020,2019,-1,1820,1821,2021,2020,-1,1821,1822,2022,2021,-1,1822,1823,2023,2022,-1,1823,1824,2024,2023,-1,1824,1825,2025,2024,-1,1825,1826,2026,2025,-1,1826,1827,2027,2026,-1,1827,1828,2028,2027,-1,1828,1829,2029,2028,-1,1829,1830,2030,2029,-1,1830,1831,2031,2030,-1,1831,1832,2032,2031,-1,1832,1833,2033,2032,-1,1833,1834,2034,2033,-1,1834,1835,2035,2034,-1,1835,1836,2036,2035,-1,1836,1837,2037,2036,-1,1837,1838,2038,2037,-1,1838,1839,2039,2038,-1,1839,1840,2040,2039,-1,1840,1841,2041,2040,-1,1841,1842,2042,2041,-1,1842,1843,2043,2042,-1,1843,1844,2044,2043,-1,1844,1845,2045,2044,-1,1845,1846,2046,2045,-1,1846,1847,2047,2046,-1,1847,1848,2048,2047,-1,1848,1849,2049,2048,-1,1849,1850,2050,2049,-1,1850,1851,2051,2050,-1,1851,1852,2052,2051,-1,1852,1853,2053,2052,-1,1853,1854,2054,2053,-1,1854,1855,2055,2054,-1,1855,1856,2056,2055,-1,1856,1857,2057,2056,-1,1857,1858,2058,2057,-1,1858,1859,2059,2058,-1,1859,1860,2060,2059,-1,1860,1861,2061,2060,-1,1861,1862,2062,2061,-1,1862,1863,2063,2062,-1,1863,1864,2064,2063,-1,1864,1865,2065,2064,-1,1865,1866,2066,2065,-1,1866,1867,2067,2066,-1,1867,1868,2068,2067,-1,1868,1869,2069,2068,-1,1869,1870,2070,2069,-1,1870,1871,2071,2070,-1,1871,1872,2072,2071,-1,1872,1873,2073,2072,-1,1873,1874,2074,2073,-1,1874,1875,2075,2074,-1,1875,1876,2076,2075,-1,1876,1877,2077,2076,-1,1877,1878,2078,2077,-1,1878,1879,2079,2078,-1,1879,1880,2080,2079,-1,1880,1881,2081,2080,-1,1881,1882,2082,2081,-1,1882,1883,2083,2082,-1,1883,1884,2084,2083,-1,1884,1885,2085,2084,-1,1885,1886,2086,2085,-1,1886,1887,2087,2086,-1,1887,1888,2088,2087,-1,1888,1889,2089,2088,-1,1889,1890,2090,2089,-1,1890,1891,2091,2090,-1,1891,1892,2092,2091,-1,1892,1893,2093,2092,-1,1893,1894,2094,2093,-1,1894,1895,2095,2094,-1,1895,1896,2096,2095,-1,1896,1897,2097,2096,-1,1897,1898,2098,2097,-1,1898,1899,2099,2098,-1,1899,1900,2100,2099,-1,1900,1901,2101,2100,-1,1901,1902,2102,2101,-1,1902,1903,2103,2102,-1,1903,1904,2104,2103,-1,1904,1905,2105,2104,-1,1905,1906,2106,2105,-1,1906,1907,2107,2106,-1,1907,1908,2108,2107,-1,1908,1909,2109,2108,-1,1909,1910,2110,2109,-1,1910,1911,2111,2110,-1,1911,1912,2112,2111,-1,1912,1913,2113,2112,-1,1913,1914,2114,2113,-1,1914,1915,2115,2114,-1,1915,1916,2116,2115,-1,1916,1917,2117,2116,-1,1917,1918,2118,2117,-1,1918,1919,2119,2118,-1,1919,1920,2120,2119,-1,1920,1921,2121,2120,-1,1921,1922,2122,2121,-1,1922,1923,2123,2122,-1,1923,1924,2124,2123,-1,1924,1925,2125,2124,-1,1925,1926,2126,2125,-1,1926,1927,2127,2126,-1,1927,1928,2128,2127,-1,1928,1929,2129,2128,-1,1929,1930,2130,2129,-1,1930,1931,2131,2130,-1,1931,1932,2132,2131,-1,1932,1933,2133,2132,-1,1933,1934,2134,2133,-1,1934,1935,2135,2134,-1,1935,1936,2136,2135,-1,1936,1937,2137,2136,-1,1937,1938,2138,2137,-1,1938,1939,2139,2138,-1,1939,1940,2140,2139,-1,1940,1941,2141,2140,-1,1941,1942,2142,2141,-1,1942,1943,2143,2142,-1,1943,1944,2144,2143,-1,1944,1945,2145,2144,-1,1945,1946,2146,2145,-1,1946,1947,2147,2146,-1,1947,1948,2148,2147,-1,1948,1949,2149,2148,-1,1949,1950,2150,2149,-1,1950,1951,2151,2150,-1,1951,1952,2152,2151,-1,1952,1953,2153,2152,-1,1953,1954,2154,2153,-1,1954,1955,2155,2154,-1,1955,1956,2156,2155,-1,1956,1957,2157,2156,-1,1957,1958,2158,2157,-1,1958,1959,2159,2158,-1,1959,1960,2160,2159,-1,1960,1961,2161,2160,-1,1961,1962,2162,2161,-1,1962,1963,2163,2162,-1,1963,1964,2164,2163,-1,1964,1965,2165,2164,-1,1965,1966,2166,2165,-1,1966,1967,2167,2166,-1,1967,1968,2168,2167,-1,1968,1969,2169,2168,-1,1969,1970,2170,2169,-1,1970,1971,2171,2170,-1,1971,1972,2172,2171,-1,1972,1973,2173,2172,-1,1973,1974,2174,2173,-1,1974,1975,2175,2174,-1,1975,1976,2176,2175,-1,1976,1977,2177,2176,-1,1977,1978,2178,2177,-1,1978,1979,2179,2178,-1,1979,1980,2180,2179,-1,1980,1981,2181,2180,-1,1981,1982,2182,2181,-1,1982,1983,2183,2182,-1,1983,1984,2184,2183,-1,1984,1985,2185,2184,-1,1985,1986,2186,2185,-1,1986,1987,2187,2186,-1,1987,1988,2188,2187,-1,1988,1989,2189,2188,-1,1989,1990,2190,2189,-1,1990,1991,2191,2190,-1,1991,1992,2192,2191,-1,1992,1993,2193,2192,-1,1993,1994,2194,2193,-1,1994,1995,2195,2194,-1,1995,1996,2196,2195,-1,1996,1997,2197,2196,-1,1997,1998,2198,2197,-1,1998,1999,2199,2198,-1,2,2001,2201,2200,-1,2001,2002,2202,2201,-1,2002,2003,2203,2202,-1,2003,2004,2204,2203,-1,2004,2005,2205,2204,-1,2005,2006,2206,2205,-1,2006,2007,2207,2206,-1,2007,2008,2208,2207,-1,2008,2009,2209,2208,-1,2009,2010,2210,2209,-1,2010,2011,2211,2210,-1,2011,2012,2212,2211,-1,2012,2013,2213,2212,-1,2013,2014,2214,2213,-1,2014,2015,2215,2214,-1,2015,2016,2216,2215,-1,2016,2017,2217,2216,-1,2017,2018,2218,2217,-1,2018,2019,2219,2218,-1,2019,2020,2220,2219,-1,2020,2021,2221,2220,-1,2021,2022,2222,2221,-1,2022,2023,2223,2222,-1,2023,2024,2224,2223,-1,2024,2025,2225,2224,-1,2025,2026,2226,2225,-1,2026,2027,2227,2226,-1,2027,2028,2228,2227,-1,2028,2029,2229,2228,-1,2029,2030,2230,2229,-1,2030,2031,2231,2230,-1,2031,2032,2232,2231,-1,2032,2033,2233,2232,-1,2033,2034,2234,2233,-1,2034,2035,2235,2234,-1,2035,2036,2236,2235,-1,2036,2037,2237,2236,-1,2037,2038,2238,2237,-1,2038,2039,2239,2238,-1,2039,2040,2240,2239,-1,2040,2041,2241,2240,-1,2041,2042,2242,2241,-1,2042,2043,2243,2242,-1,2043,2044,2244,2243,-1,2044,2045,2245,2244,-1,2045,2046,2246,2245,-1,2046,2047,2247,2246,-1,2047,2048,2248,2247,-1,2048,2049,2249,2248,-1,2049,2050,2250,2249,-1,2050,2051,2251,2250,-1,2051,2052,2252,2251,-1,2052,2053,2253,2252,-1,2053,2054,2254,2253,-1,2054,2055,2255,2254,-1,2055,2056,2256,2255,-1,2056,2057,2257,2256,-1,2057,2058,2258,2257,-1,2058,2059,2259,2258,-1,2059,2060,2260,2259,-1,2060,2061,2261,2260,-1,2061,2062,2262,2261,-1,2062,2063,2263,2262,-1,2063,2064,2264,2263,-1,2064,2065,2265,2264,-1,2065,2066,2266,2265,-1,2066,2067,2267,2266,-1,2067,2068,2268,2267,-1,2068,2069,2269,2268,-1,2069,2070,2270,2269,-1,2070,2071,2271,2270,-1,2071,2072,2272,2271,-1,2072,2073,2273,2272,-1,2073,2074,2274,2273,-1,2074,2075,2275,2274,-1,2075,2076,2276,2275,-1,2076,2077,2277,2276,-1,2077,2078,2278,2277,-1,2078,2079,2279,2278,-1,2079,2080,2280,2279,-1,2080,2081,2281,2280,-1,2081,2082,2282,2281,-1,2082,2083,2283,2282,-1,2083,2084,2284,2283,-1,2084,2085,2285,2284,-1,2085,2086,2286,2285,-1,2086,2087,2287,2286,-1,2087,2088,2288,2287,-1,2088,2089,2289,2288,-1,2089,2090,2290,2289,-1,2090,2091,2291,2290,-1,2091,2092,2292,2291,-1,2092,2093,2293,2292,-1,2093,2094,2294,2293,-1,2094,2095,2295,2294,-1,2095,2096,2296,2295,-1,2096,2097,2297,2296,-1,2097,2098,2298,2297,-1,2098,2099,2299,2298,-1,2099,2100,2300,2299,-1,2100,2101,2301,2300,-1,2101,2102,2302,2301,-1,2102,2103,2303,2302,-1,2103,2104,2304,2303,-1,2104,2105,2305,2304,-1,2105,2106,2306,2305,-1,2106,2107,2307,2306,-1,2107,2108,2308,2307,-1,2108,2109,2309,2308,-1,2109,2110,2310,2309,-1,2110,2111,2311,2310,-1,2111,2112,2312,2311,-1,2112,2113,2313,2312,-1,2113,2114,2314,2313,-1,2114,2115,2315,2314,-1,2115,2116,2316,2315,-1,2116,2117,2317,2316,-1,2117,2118,2318,2317,-1,2118,2119,2319,2318,-1,2119,2120,2320,2319,-1,2120,2121,2321,2320,-1,2121,2122,2322,2321,-1,2122,2123,2323,2322,-1,2123,2124,2324,2323,-1,2124,2125,2325,2324,-1,2125,2126,2326,2325,-1,2126,2127,2327,2326,-1,2127,2128,2328,2327,-1,2128,2129,2329,2328,-1,2129,2130,2330,2329,-1,2130,2131,2331,2330,-1,2131,2132,2332,2331,-1,2132,2133,2333,2332,-1,2133,2134,2334,2333,-1,2134,2135,2335,2334,-1,2135,2136,2336,2335,-1,2136,2137,2337,2336,-1,2137,2138,2338,2337,-1,2138,2139,2339,2338,-1,2139,2140,2340,2339,-1,2140,2141,2341,2340,-1,2141,2142,2342,2341,-1,2142,2143,2343,2342,-1,2143,2144,2344,2343,-1,2144,2145,2345,2344,-1,2145,2146,2346,2345,-1,2146,2147,2347,2346,-1,2147,2148,2348,2347,-1,2148,2149,2349,2348,-1,2149,2150,2350,2349,-1,2150,2151,2351,2350,-1,2151,2152,2352,2351,-1,2152,2153,2353,2352,-1,2153,2154,2354,2353,-1,2154,2155,2355,2354,-1,2155,2156,2356,2355,-1,2156,2157,2357,2356,-1,2157,2158,2358,2357,-1,2158,2159,2359,2358,-1,2159,2160,2360,2359,-1,2160,2161,2361,2360,-1,2161,2162,2362,2361,-1,2162,2163,2363,2362,-1,2163,2164,2364,2363,-1,2164,2165,2365,2364,-1,2165,2166,2366,2365,-1,2166,2167,2367,2366,-1,2167,2168,2368,2367,-1,2168,2169,2369,2368,-1,2169,2170,2370,2369,-1,2170,2171,2371,2370,-1,2171,2172,2372,2371,-1,2172,2173,2373,2372,-1,2173,2174,2374,2373,-1,2174,2175,2375,2374,-1,2175,2176,2376,2375,-1,2176,2177,2377,2376,-1,2177,2178,2378,2377,-1,2178,2179,2379,2378,-1,2179,2180,2380,2379,-1,2180,2181,2381,2380,-1,2181,2182,2382,2381,-1,2182,2183,2383,2382,-1,2183,2184,2384,2383,-1,2184,2185,2385,2384,-1,2185,2186,2386,2385,-1,2186,2187,2387,2386,-1,2187,2188,2388,2387,-1,2188,2189,2389,2388,-1,2189,2190,2390,2389,-1,2190,2191,2391,2390,-1,2191,2192,2392,2391,-1,2192,2193,2393,2392,-1,2193,2194,2394,2393,-1,2194,2195,2395,2394,-1,2195,2196,2396,2395,-1,2196,2197,2397,2396,-1,2197,2198,2398,2397,-1,2198,2199,2399,2398,-1,2200,2201,2401,2400,-1,2201,2202,2402,2401,-1,2202,2203,2403,2402,-1,2203,2204,2404,2403,-1,2204,2205,2405,2404,-1,2205,2206,2406,2405,-1,2206,2207,2407,2406,-1,2207,2208,2408,2407,-1,2208,2209,2409,2408,-1,2209,2210,2410,2409,-1,2210,2211,2411,2410,-1,2211,2212,2412,2411,-1,2212,2213,2413,2412,-1,2213,2214,2414,2413,-1,2214,2215,2415,2414,-1,2215,2216,2416,2415,-1,2216,2217,2417,2416,-1,2217,2218,2418,2417,-1,2218,2219,2419,2418,-1,2219,2220,2420,2419,-1,2220,2221,2421,2420,-1,2221,2222,2422,2421,-1,2222,2223,2423,2422,-1,2223,2224,2424,2423,-1,2224,2225,2425,2424,-1,2225,2226,2426,2425,-1,2226,2227,2427,2426,-1,2227,2228,2428,2427,-1,2228,2229,2429,2428,-1,2229,2230,2430,2429,-1,2230,2231,2431,2430,-1,2231,2232,2432,2431,-1,2232,2233,2433,2432,-1,2233,2234,2434,2433,-1,2234,2235,2435,2434,-1,2235,2236,2436,2435,-1,2236,2237,2437,2436,-1,2237,2238,2438,2437,-1,2238,2239,2439,2438,-1,2239,2240,2440,2439,-1,2240,2241,2441,2440,-1,2241,2242,2442,2441,-1,2242,2243,2443,2442,-1,2243,2244,2444,2443,-1,2244,2245,2445,2444,-1,2245,2246,2446,2445,-1,2246,2247,2447,2446,-1,2247,2248,2448,2447,-1,2248,2249,2449,2448,-1,2249,2250,2450,2449,-1,2250,2251,2451,2450,-1,2251,2252,2452,2451,-1,2252,2253,2453,2452,-1,2253,2254,2454,2453,-1,2254,2255,2455,2454,-1,2255,2256,2456,2455,-1,2256,2257,2457,2456,-1,2257,2258,2458,2457,-1,2258,2259,2459,2458,-1,2259,2260,2460,2459,-1,2260,2261,2461,2460,-1,2261,2262,2462,2461,-1,2262,2263,2463,2462,-1,2263,2264,2464,2463,-1,2264,2265,2465,2464,-1,2265,2266,2466,2465,-1,2266,2267,2467,2466,-1,2267,2268,2468,2467,-1,2268,2269,2469,2468,-1,2269,2270,2470,2469,-1,2270,2271,2471,2470,-1,2271,2272,2472,2471,-1,2272,2273,2473,2472,-1,2273,2274,2474,2473,-1,2274,2275,2475,2474,-1,2275,2276,2476,2475,-1,2276,2277,2477,2476,-1,2277,2278,2478,2477,-1,2278,2279,2479,2478,-1,2279,2280,2480,2479,-1,2280,2281,2481,2480,-1,2281,2282,2482,2481,-1,2282,2283,2483,2482,-1,2283,2284,2484,2483,-1,2284,2285,2485,2484,-1,2285,2286,2486,2485,-1,2286,2287,2487,2486,-1,2287,2288,2488,2487,-1,2288,2289,2489,2488,-1,2289,2290,2490,2489,-1,2290,2291,2491,2490,-1,2291,2292,2492,2491,-1,2292,2293,2493,2492,-1,2293,2294,2494,2493,-1,2294,2295,2495,2494,-1,2295,2296,2496,2495,-1,2296,2297,2497,2496,-1,2297,2298,2498,2497,-1,2298,2299,2499,2498,-1,2299,2300,2500,2499,-1,2300,2301,2501,2500,-1,2301,2302,2502,2501,-1,2302,2303,2503,2502,-1,2303,2304,2504,2503,-1,2304,2305,2505,2504,-1,2305,2306,2506,2505,-1,2306,2307,2507,2506,-1,2307,2308,2508,2507,-1,2308,2309,2509,2508,-1,2309,2310,2510,2509,-1,2310,2311,2511,2510,-1,2311,2312,2512,2511,-1,2312,2313,2513,2512,-1,2313,2314,2514,2513,-1,2314,2315,2515,2514,-1,2315,2316,2516,2515,-1,2316,2317,2517,2516,-1,2317,2318,2518,2517,-1,2318,2319,2519,2518,-1,2319,2320,2520,2519,-1,2320,2321,2521,2520,-1,2321,2322,2522,2521,-1,2322,2323,2523,2522,-1,2323,2324,2524,2523,-1,2324,2325,2525,2524,-1,2325,2326,2526,2525,-1,2326,2327,2527,2526,-1,2327,2328,2528,2527,-1,2328,2329,2529,2528,-1,2329,2330,2530,2529,-1,2330,2331,2531,2530,-1,2331,2332,2532,2531,-1,2332,2333,2533,2532,-1,2333,2334,2534,2533,-1,2334,2335,2535,2534,-1,2335,2336,2536,2535,-1,2336,2337,2537,2536,-1,2337,2338,2538,2537,-1,2338,2339,2539,2538,-1,2339,2340,2540,2539,-1,2340,2341,2541,2540,-1,2341,2342,2542,2541,-1,2342,2343,2543,2542,-1,2343,2344,2544,2543,-1,2344,2345,2545,2544,-1,2345,2346,2546,2545,-1,2346,2347,2547,2546,-1,2347,2348,2548,2547,-1,2348,2349,2549,2548,-1,2349,2350,2550,2549,-1,2350,2351,2551,2550,-1,2351,2352,2552,2551,-1,2352,2353,2553,2552,-1,2353,2354,2554,2553,-1,2354,2355,2555,2554,-1,2355,2356,2556,2555,-1,2356,2357,2557,2556,-1,2357,2358,2558,2557,-1,2358,2359,2559,2558,-1,2359,2360,2560,2559,-1,2360,2361,2561,2560,-1,2361,2362,2562,2561,-1,2362,2363,2563,2562,-1,2363,2364,2564,2563,-1,2364,2365,2565,2564,-1,2365,2366,2566,2565,-1,2366,2367,2567,2566,-1,2367,2368,2568,2567,-1,2368,2369,2569,2568,-1,2369,2370,2570,2569,-1,2370,2371,2571,2570,-1,2371,2372,2572,2571,-1,2372,2373,2573,2572,-1,2373,2374,2574,2573,-1,2374,2375,2575,2574,-1,2375,2376,2576,2575,-1,2376,2377,2577,2576,-1,2377,2378,2578,2577,-1,2378,2379,2579,2578,-1,2379,2380,2580,2579,-1,2380,2381,2581,2580,-1,2381,2382,2582,2581,-1,2382,2383,2583,2582,-1,2383,2384,2584,2583,-1,2384,2385,2585,2584,-1,2385,2386,2586,2585,-1,2386,2387,2587,2586,-1,2387,2388,2588,2587,-1,2388,2389,2589,2588,-1,2389,2390,2590,2589,-1,2390,2391,2591,2590,-1,2391,2392,2592,2591,-1,2392,2393,2593,2592,-1,2393,2394,2594,2593,-1,2394,2395,2595,2594,-1,2395,2396,2596,2595,-1,2396,2397,2597,2596,-1,2397,2398,2598,2597,-1,2398,2399,2599,2598,-1,2400,2401,2601,2600,-1,2401,2402,2602,2601,-1,2402,2403,2603,2602,-1,2403,2404,2604,2603,-1,2404,2405,2605,2604,-1,2405,2406,2606,2605,-1,2406,2407,2607,2606,-1,2407,2408,2608,2607,-1,2408,2409,2609,2608,-1,2409,2410,2610,2609,-1,2410,2411,2611,2610,-1,2411,2412,2612,2611,-1,2412,2413,2613,2612,-1,2413,2414,2614,2613,-1,2414,2415,2615,2614,-1,2415,2416,2616,2615,-1,2416,2417,2617,2616,-1,2417,2418,2618,2617,-1,2418,2419,2619,2618,-1,2419,2420,2620,2619,-1,2420,2421,2621,2620,-1,2421,2422,2622,2621,-1,2422,2423,2623,2622,-1,2423,2424,2624,2623,-1,2424,2425,2625,2624,-1,2425,2426,2626,2625,-1,2426,2427,2627,2626,-1,2427,2428,2628,2627,-1,2428,2429,2629,2628,-1,2429,2430,2630,2629,-1,2430,2431,2631,2630,-1,2431,2432,2632,2631,-1,2432,2433,2633,2632,-1,2433,2434,2634,2633,-1,2434,2435,2635,2634,-1,2435,2436,2636,2635,-1,2436,2437,2637,2636,-1,2437,2438,2638,2637,-1,2438,2439,2639,2638,-1,2439,2440,2640,2639,-1,2440,2441,2641,2640,-1,2441,2442,2642,2641,-1,2442,2443,2643,2642,-1,2443,2444,2644,2643,-1,2444,2445,2645,2644,-1,2445,2446,2646,2645,-1,2446,2447,2647,2646,-1,2447,2448,2648,2647,-1,2448,2449,2649,2648,-1,2449,2450,2650,2649,-1,2450,2451,2651,2650,-1,2451,2452,2652,2651,-1,2452,2453,2653,2652,-1,2453,2454,2654,2653,-1,2454,2455,2655,2654,-1,2455,2456,2656,2655,-1,2456,2457,2657,2656,-1,2457,2458,2658,2657,-1,2458,2459,2659,2658,-1,2459,2460,2660,2659,-1,2460,2461,2661,2660,-1,2461,2462,2662,2661,-1,2462,2463,2663,2662,-1,2463,2464,2664,2663,-1,2464,2465,2665,2664,-1,2465,2466,2666,2665,-1,2466,2467,2667,2666,-1,2467,2468,2668,2667,-1,2468,2469,2669,2668,-1,2469,2470,2670,2669,-1,2470,2471,2671,2670,-1,2471,2472,2672,2671,-1,2472,2473,2673,2672,-1,2473,2474,2674,2673,-1,2474,2475,2675,2674,-1,2475,2476,2676,2675,-1,2476,2477,2677,2676,-1,2477,2478,2678,2677,-1,2478,2479,2679,2678,-1,2479,2480,2680,2679,-1,2480,2481,2681,2680,-1,2481,2482,2682,2681,-1,2482,2483,2683,2682,-1,2483,2484,2684,2683,-1,2484,2485,2685,2684,-1,2485,2486,2686,2685,-1,2486,2487,2687,2686,-1,2487,2488,2688,2687,-1,2488,2489,2689,2688,-1,2489,2490,2690,2689,-1,2490,2491,2691,2690,-1,2491,2492,2692,2691,-1,2492,2493,2693,2692,-1,2493,2494,2694,2693,-1,2494,2495,2695,2694,-1,2495,2496,2696,2695,-1,2496,2497,2697,2696,-1,2497,2498,2698,2697,-1,2498,2499,2699,2698,-1,2499,2500,2700,2699,-1,2500,2501,2701,2700,-1,2501,2502,2702,2701,-1,2502,2503,2703,2702,-1,2503,2504,2704,2703,-1,2504,2505,2705,2704,-1,2505,2506,2706,2705,-1,2506,2507,2707,2706,-1,2507,2508,2708,2707,-1,2508,2509,2709,2708,-1,2509,2510,2710,2709,-1,2510,2511,2711,2710,-1,2511,2512,2712,2711,-1,2512,2513,2713,2712,-1,2513,2514,2714,2713,-1,2514,2515,2715,2714,-1,2515,2516,2716,2715,-1,2516,2517,2717,2716,-1,2517,2518,2718,2717,-1,2518,2519,2719,2718,-1,2519,2520,2720,2719,-1,2520,2521,2721,2720,-1,2521,2522,2722,2721,-1,2522,2523,2723,2722,-1,2523,2524,2724,2723,-1,2524,2525,2725,2724,-1,2525,2526,2726,2725,-1,2526,2527,2727,2726,-1,2527,2528,2728,2727,-1,2528,2529,2729,2728,-1,2529,2530,2730,2729,-1,2530,2531,2731,2730,-1,2531,2532,2732,2731,-1,2532,2533,2733,2732,-1,2533,2534,2734,2733,-1,2534,2535,2735,2734,-1,2535,2536,2736,2735,-1,2536,2537,2737,2736,-1,2537,2538,2738,2737,-1,2538,2539,2739,2738,-1,2539,2540,2740,2739,-1,2540,2541,2741,2740,-1,2541,2542,2742,2741,-1,2542,2543,2743,2742,-1,2543,2544,2744,2743,-1,2544,2545,2745,2744,-1,2545,2546,2746,2745,-1,2546,2547,2747,2746,-1,2547,2548,2748,2747,-1,2548,2549,2749,2748,-1,2549,2550,2750,2749,-1,2550,2551,2751,2750,-1,2551,2552,2752,2751,-1,2552,2553,2753,2752,-1,2553,2554,2754,2753,-1,2554,2555,2755,2754,-1,2555,2556,2756,2755,-1,2556,2557,2757,2756,-1,2557,2558,2758,2757,-1,2558,2559,2759,2758,-1,2559,2560,2760,2759,-1,2560,2561,2761,2760,-1,2561,2562,2762,2761,-1,2562,2563,2763,2762,-1,2563,2564,2764,2763,-1,2564,2565,2765,2764,-1,2565,2566,2766,2765,-1,2566,2567,2767,2766,-1,2567,2568,2768,2767,-1,2568,2569,2769,2768,-1,2569,2570,2770,2769,-1,2570,2571,2771,2770,-1,2571,2572,2772,2771,-1,2572,2573,2773,2772,-1,2573,2574,2774,2773,-1,2574,2575,2775,2774,-1,2575,2576,2776,2775,-1,2576,2577,2777,2776,-1,2577,2578,2778,2777,-1,2578,2579,2779,2778,-1,2579,2580,2780,2779,-1,2580,2581,2781,2780,-1,2581,2582,2782,2781,-1,2582,2583,2783,2782,-1,2583,2584,2784,2783,-1,2584,2585,2785,2784,-1,2585,2586,2786,2785,-1,2586,2587,2787,2786,-1,2587,2588,2788,2787,-1,2588,2589,2789,2788,-1,2589,2590,2790,2789,-1,2590,2591,2791,2790,-1,2591,2592,2792,2791,-1,2592,2593,2793,2792,-1,2593,2594,2794,2793,-1,2594,2595,2795,2794,-1,2595,2596,2796,2795,-1,2596,2597,2797,2796,-1,2597,2598,2798,2797,-1,2598,2599,2799,2798,-1,2600,2601,2801,2800,-1,2601,2602,2802,2801,-1,2602,2603,2803,2802,-1,2603,2604,2804,2803,-1,2604,2605,2805,2804,-1,2605,2606,2806,2805,-1,2606,2607,2807,2806,-1,2607,2608,2808,2807,-1,2608,2609,2809,2808,-1,2609,2610,2810,2809,-1,2610,2611,2811,2810,-1,2611,2612,2812,2811,-1,2612,2613,2813,2812,-1,2613,2614,2814,2813,-1,2614,2615,2815,2814,-1,2615,2616,2816,2815,-1,2616,2617,2817,2816,-1,2617,2618,2818,2817,-1,2618,2619,2819,2818,-1,2619,2620,2820,2819,-1,2620,2621,2821,2820,-1,2621,2622,2822,2821,-1,2622,2623,2823,2822,-1,2623,2624,2824,2823,-1,2624,2625,2825,2824,-1,2625,2626,2826,2825,-1,2626,2627,2827,2826,-1,2627,2628,2828,2827,-1,2628,2629,2829,2828,-1,2629,2630,2830,2829,-1,2630,2631,2831,2830,-1,2631,2632,2832,2831,-1,2632,2633,2833,2832,-1,2633,2634,2834,2833,-1,2634,2635,2835,2834,-1,2635,2636,2836,2835,-1,2636,2637,2837,2836,-1,2637,2638,2838,2837,-1,2638,2639,2839,2838,-1,2639,2640,2840,2839,-1,2640,2641,2841,2840,-1,2641,2642,2842,2841,-1,2642,2643,2843,2842,-1,2643,2644,2844,2843,-1,2644,2645,2845,2844,-1,2645,2646,2846,2845,-1,2646,2647,2847,2846,-1,2647,2648,2848,2847,-1,2648,2649,2849,2848,-1,2649,2650,2850,2849,-1,2650,2651,2851,2850,-1,2651,2652,2852,2851,-1,2652,2653,2853,2852,-1,2653,2654,2854,2853,-1,2654,2655,2855,2854,-1,2655,2656,2856,2855,-1,2656,2657,2857,2856,-1,2657,2658,2858,2857,-1,2658,2659,2859,2858,-1,2659,2660,2860,2859,-1,2660,2661,2861,2860,-1,2661,2662,2862,2861,-1,2662,2663,2863,2862,-1,2663,2664,2864,2863,-1,2664,2665,2865,2864,-1,2665,2666,2866,2865,-1,2666,2667,2867,2866,-1,2667,2668,2868,2867,-1,2668,2669,2869,2868,-1,2669,2670,2870,2869,-1,2670,2671,2871,2870,-1,2671,2672,2872,2871,-1,2672,2673,2873,2872,-1,2673,2674,2874,2873,-1,2674,2675,2875,2874,-1,2675,2676,2876,2875,-1,2676,2677,2877,2876,-1,2677,2678,2878,2877,-1,2678,2679,2879,2878,-1,2679,2680,2880,2879,-1,2680,2681,2881,2880,-1,2681,2682,2882,2881,-1,2682,2683,2883,2882,-1,2683,2684,2884,2883,-1,2684,2685,2885,2884,-1,2685,2686,2886,2885,-1,2686,2687,2887,2886,-1,2687,2688,2888,2887,-1,2688,2689,2889,2888,-1,2689,2690,2890,2889,-1,2690,2691,2891,2890,-1,2691,2692,2892,2891,-1,2692,2693,2893,2892,-1,2693,2694,2894,2893,-1,2694,2695,2895,2894,-1,2695,2696,2896,2895,-1,2696,2697,2897,2896,-1,2697,2698,2898,2897,-1,2698,2699,2899,2898,-1,2699,2700,2900,2899,-1,2700,2701,2901,2900,-1,2701,2702,2902,2901,-1,2702,2703,2903,2902,-1,2703,2704,2904,2903,-1,2704,2705,2905,2904,-1,2705,2706,2906,2905,-1,2706,2707,2907,2906,-1,2707,2708,2908,2907,-1,2708,2709,2909,2908,-1,2709,2710,2910,2909,-1,2710,2711,2911,2910,-1,2711,2712,2912,2911,-1,2712,2713,2913,2912,-1,2713,2714,2914,2913,-1,2714,2715,2915,2914,-1,2715,2716,2916,2915,-1,2716,2717,2917,2916,-1,2717,2718,2918,2917,-1,2718,2719,2919,2918,-1,2719,2720,2920,2919,-1,2720,2721,2921,2920,-1,2721,2722,2922,2921,-1,2722,2723,2923,2922,-1,2723,2724,2924,2923,-1,2724,2725,2925,2924,-1,2725,2726,2926,2925,-1,2726,2727,2927,2926,-1,2727,2728,2928,2927,-1,2728,2729,2929,2928,-1,2729,2730,2930,2929,-1,2730,2731,2931,2930,-1,2731,2732,2932,2931,-1,2732,2733,2933,2932,-1,2733,2734,2934,2933,-1,2734,2735,2935,2934,-1,2735,2736,2936,2935,-1,2736,2737,2937,2936,-1,2737,2738,2938,2937,-1,2738,2739,2939,2938,-1,2739,2740,2940,2939,-1,2740,2741,2941,2940,-1,2741,2742,2942,2941,-1,2742,2743,2943,2942,-1,2743,2744,2944,2943,-1,2744,2745,2945,2944,-1,2745,2746,2946,2945,-1,2746,2747,2947,2946,-1,2747,2748,2948,2947,-1,2748,2749,2949,2948,-1,2749,2750,2950,2949,-1,2750,2751,2951,2950,-1,2751,2752,2952,2951,-1,2752,2753,2953,2952,-1,2753,2754,2954,2953,-1,2754,2755,2955,2954,-1,2755,2756,2956,2955,-1,2756,2757,2957,2956,-1,2757,2758,2958,2957,-1,2758,2759,2959,2958,-1,2759,2760,2960,2959,-1,2760,2761,2961,2960,-1,2761,2762,2962,2961,-1,2762,2763,2963,2962,-1,2763,2764,2964,2963,-1,2764,2765,2965,2964,-1,2765,2766,2966,2965,-1,2766,2767,2967,2966,-1,2767,2768,2968,2967,-1,2768,2769,2969,2968,-1,2769,2770,2970,2969,-1,2770,2771,2971,2970,-1,2771,2772,2972,2971,-1,2772,2773,2973,2972,-1,2773,2774,2974,2973,-1,2774,2775,2975,2974,-1,2775,2776,2976,2975,-1,2776,2777,2977,2976,-1,2777,2778,2978,2977,-1,2778,2779,2979,2978,-1,2779,2780,2980,2979,-1,2780,2781,2981,2980,-1,2781,2782,2982,2981,-1,2782,2783,2983,2982,-1,2783,2784,2984,2983,-1,2784,2785,2985,2984,-1,2785,2786,2986,2985,-1,2786,2787,2987,2986,-1,2787,2788,2988,2987,-1,2788,2789,2989,2988,-1,2789,2790,2990,2989,-1,2790,2791,2991,2990,-1,2791,2792,2992,2991,-1,2792,2793,2993,2992,-1,2793,2794,2994,2993,-1,2794,2795,2995,2994,-1,2795,2796,2996,2995,-1,2796,2797,2997,2996,-1,2797,2798,2998,2997,-1,2798,2799,2999,2998,-1,2800,2801,3001,3,-1,2801,2802,3002,3001,-1,2802,2803,3003,3002,-1,2803,2804,3004,3003,-1,2804,2805,3005,3004,-1,2805,2806,3006,3005,-1,2806,2807,3007,3006,-1,2807,2808,3008,3007,-1,2808,2809,3009,3008,-1,2809,2810,3010,3009,-1,2810,2811,3011,3010,-1,2811,2812,3012,3011,-1,2812,2813,3013,3012,-1,2813,2814,3014,3013,-1,2814,2815,3015,3014,-1,2815,2816,3016,3015,-1,2816,2817,3017,3016,-1,2817,2818,3018,3017,-1,2818,2819,3019,3018,-1,2819,2820,3020,3019,-1,2820,2821,3021,3020,-1,2821,2822,3022,3021,-1,2822,2823,3023,3022,-1,2823,2824,3024,3023,-1,2824,2825,3025,3024,-1,2825,2826,3026,3025,-1,2826,2827,3027,3026,-1,2827,2828,3028,3027,-1,2828,2829,3029,3028,-1,2829,2830,3030,3029,-1,2830,2831,3031,3030,-1,2831,2832,3032,3031,-1,2832,2833,3033,3032,-1,2833,2834,3034,3033,-1,2834,2835,3035,3034,-1,2835,2836,3036,3035,-1,2836,2837,3037,3036,-1,2837,2838,3038,3037,-1,2838,2839,3039,3038,-1,2839,2840,3040,3039,-1,2840,2841,3041,3040,-1,2841,2842,3042,3041,-1,2842,2843,3043,3042,-1,2843,2844,3044,3043,-1,2844,2845,3045,3044,-1,2845,2846,3046,3045,-1,2846,2847,3047,3046,-1,2847,2848,3048,3047,-1,2848,2849,3049,3048,-1,2849,2850,3050,3049,-1,2850,2851,3051,3050,-1,2851,2852,3052,3051,-1,2852,2853,3053,3052,-1,2853,2854,3054,3053,-1,2854,2855,3055,3054,-1,2855,2856,3056,3055,-1,2856,2857,3057,3056,-1,2857,2858,3058,3057,-1,2858,2859,3059,3058,-1,2859,2860,3060,3059,-1,2860,2861,3061,3060,-1,2861,2862,3062,3061,-1,2862,2863,3063,3062,-1,2863,2864,3064,3063,-1,2864,2865,3065,3064,-1,2865,2866,3066,3065,-1,2866,2867,3067,3066,-1,2867,2868,3068,3067,-1,2868,2869,3069,3068,-1,2869,2870,3070,3069,-1,2870,2871,3071,3070,-1,2871,2872,3072,3071,-1,2872,2873,3073,3072,-1,2873,2874,3074,3073,-1,2874,2875,3075,3074,-1,2875,2876,3076,3075,-1,2876,2877,3077,3076,-1,2877,2878,3078,3077,-1,2878,2879,3079,3078,-1,2879,2880,3080,3079,-1,2880,2881,3081,3080,-1,2881,2882,3082,3081,-1,2882,2883,3083,3082,-1,2883,2884,3084,3083,-1,2884,2885,3085,3084,-1,2885,2886,3086,3085,-1,2886,2887,3087,3086,-1,2887,2888,3088,3087,-1,2888,2889,3089,3088,-1,2889,2890,3090,3089,-1,2890,2891,3091,3090,-1,2891,2892,3092,3091,-1,2892,2893,3093,3092,-1,2893,2894,3094,3093,-1,2894,2895,3095,3094,-1,2895,2896,3096,3095,-1,2896,2897,3097,3096,-1,2897,2898,3098,3097,-1,2898,2899,3099,3098,-1,2899,2900,3100,3099,-1,2900,2901,3101,3100,-1,2901,2902,3102,3101,-1,2902,2903,3103,3102,-1,2903,2904,3104,3103,-1,2904,2905,3105,3104,-1,2905,2906,3106,3105,-1,2906,2907,3107,3106,-1,2907,2908,3108,3107,-1,2908,2909,3109,3108,-1,2909,2910,3110,3109,-1,2910,2911,3111,3110,-1,2911,2912,3112,3111,-1,2912,2913,3113,3112,-1,2913,2914,3114,3113,-1,2914,2915,3115,3114,-1,2915,2916,3116,3115,-1,2916,2917,3117,3116,-1,2917,2918,3118,3117,-1,2918,2919,3119,3118,-1,2919,2920,3120,3119,-1,2920,2921,3121,3120,-1,2921,2922,3122,3121,-1,2922,2923,3123,3122,-1,2923,2924,3124,3123,-1,2924,2925,3125,3124,-1,2925,2926,3126,3125,-1,2926,2927,3127,3126,-1,2927,2928,3128,3127,-1,2928,2929,3129,3128,-1,2929,2930,3130,3129,-1,2930,2931,3131,3130,-1,2931,2932,3132,3131,-1,2932,2933,3133,3132,-1,2933,2934,3134,3133,-1,2934,2935,3135,3134,-1,2935,2936,3136,3135,-1,2936,2937,3137,3136,-1,2937,2938,3138,3137,-1,2938,2939,3139,3138,-1,2939,2940,3140,3139,-1,2940,2941,3141,3140,-1,2941,2942,3142,3141,-1,2942,2943,3143,3142,-1,2943,2944,3144,3143,-1,2944,2945,3145,3144,-1,2945,2946,3146,3145,-1,2946,2947,3147,3146,-1,2947,2948,3148,3147,-1,2948,2949,3149,3148,-1,2949,2950,3150,3149,-1,2950,2951,3151,3150,-1,2951,2952,3152,3151,-1,2952,2953,3153,3152,-1,2953,2954,3154,3153,-1,2954,2955,3155,3154,-1,2955,2956,3156,3155,-1,2956,2957,3157,3156,-1,2957,2958,3158,3157,-1,2958,2959,3159,3158,-1,2959,2960,3160,3159,-1,2960,2961,3161,3160,-1,2961,2962,3162,3161,-1,2962,2963,3163,3162,-1,2963,2964,3164,3163,-1,2964,2965,3165,3164,-1,2965,2966,3166,3165,-1,2966,2967,3167,3166,-1,2967,2968,3168,3167,-1,2968,2969,3169,3168,-1,2969,2970,3170,3169,-1,2970,2971,3171,3170,-1,2971,2972,3172,3171,-1,2972,2973,3173,3172,-1,2973,2974,3174,3173,-1,2974,2975,3175,3174,-1,2975,2976,3176,3175,-1,2976,2977,3177,3176,-1,2977,2978,3178,3177,-1,2978,2979,3179,3178,-1,2979,2980,3180,3179,-1,2980,2981,3181,3180,-1,2981,2982,3182,3181,-1,2982,2983,3183,3182,-1,2983,2984,3184,3183,-1,2984,2985,3185,3184,-1,2985,2986,3186,3185,-1,2986,2987,3187,3186,-1,2987,2988,3188,3187,-1,2988,2989,3189,3188,-1,2989,2990,3190,3189,-1,2990,2991,3191,3190,-1,2991,2992,3192,3191,-1,2992,2993,3193,3192,-1,2993,2994,3194,3193,-1,2994,2995,3195,3194,-1,2995,2996,3196,3195,-1,2996,2997,3197,3196,-1,2997,2998,3198,3197,-1,2998,2999,3199,3198,-1,3,3001,3201,3200,-1,3001,3002,3202,3201,-1,3002,3003,3203,3202,-1,3003,3004,3204,3203,-1,3004,3005,3205,3204,-1,3005,3006,3206,3205,-1,3006,3007,3207,3206,-1,3007,3008,3208,3207,-1,3008,3009,3209,3208,-1,3009,3010,3210,3209,-1,3010,3011,3211,3210,-1,3011,3012,3212,3211,-1,3012,3013,3213,3212,-1,3013,3014,3214,3213,-1,3014,3015,3215,3214,-1,3015,3016,3216,3215,-1,3016,3017,3217,3216,-1,3017,3018,3218,3217,-1,3018,3019,3219,3218,-1,3019,3020,3220,3219,-1,3020,3021,3221,3220,-1,3021,3022,3222,3221,-1,3022,3023,3223,3222,-1,3023,3024,3224,3223,-1,3024,3025,3225,3224,-1,3025,3026,3226,3225,-1,3026,3027,3227,3226,-1,3027,3028,3228,3227,-1,3028,3029,3229,3228,-1,3029,3030,3230,3229,-1,3030,3031,3231,3230,-1,3031,3032,3232,3231,-1,3032,3033,3233,3232,-1,3033,3034,3234,3233,-1,3034,3035,3235,3234,-1,3035,3036,3236,3235,-1,3036,3037,3237,3236,-1,3037,3038,3238,3237,-1,3038,3039,3239,3238,-1,3039,3040,3240,3239,-1,3040,3041,3241,3240,-1,3041,3042,3242,3241,-1,3042,3043,3243,3242,-1,3043,3044,3244,3243,-1,3044,3045,3245,3244,-1,3045,3046,3246,3245,-1,3046,3047,3247,3246,-1,3047,3048,3248,3247,-1,3048,3049,3249,3248,-1,3049,3050,3250,3249,-1,3050,3051,3251,3250,-1,3051,3052,3252,3251,-1,3052,3053,3253,3252,-1,3053,3054,3254,3253,-1,3054,3055,3255,3254,-1,3055,3056,3256,3255,-1,3056,3057,3257,3256,-1,3057,3058,3258,3257,-1,3058,3059,3259,3258,-1,3059,3060,3260,3259,-1,3060,3061,3261,3260,-1,3061,3062,3262,3261,-1,3062,3063,3263,3262,-1,3063,3064,3264,3263,-1,3064,3065,3265,3264,-1,3065,3066,3266,3265,-1,3066,3067,3267,3266,-1,3067,3068,3268,3267,-1,3068,3069,3269,3268,-1,3069,3070,3270,3269,-1,3070,3071,3271,3270,-1,3071,3072,3272,3271,-1,3072,3073,3273,3272,-1,3073,3074,3274,3273,-1,3074,3075,3275,3274,-1,3075,3076,3276,3275,-1,3076,3077,3277,3276,-1,3077,3078,3278,3277,-1,3078,3079,3279,3278,-1,3079,3080,3280,3279,-1,3080,3081,3281,3280,-1,3081,3082,3282,3281,-1,3082,3083,3283,3282,-1,3083,3084,3284,3283,-1,3084,3085,3285,3284,-1,3085,3086,3286,3285,-1,3086,3087,3287,3286,-1,3087,3088,3288,3287,-1,3088,3089,3289,3288,-1,3089,3090,3290,3289,-1,3090,3091,3291,3290,-1,3091,3092,3292,3291,-1,3092,3093,3293,3292,-1,3093,3094,3294,3293,-1,3094,3095,3295,3294,-1,3095,3096,3296,3295,-1,3096,3097,3297,3296,-1,3097,3098,3298,3297,-1,3098,3099,3299,3298,-1,3099,3100,3300,3299,-1,3100,3101,3301,3300,-1,3101,3102,3302,3301,-1,3102,3103,3303,3302,-1,3103,3104,3304,3303,-1,3104,3105,3305,3304,-1,3105,3106,3306,3305,-1,3106,3107,3307,3306,-1,3107,3108,3308,3307,-1,3108,3109,3309,3308,-1,3109,3110,3310,3309,-1,3110,3111,3311,3310,-1,3111,3112,3312,3311,-1,3112,3113,3313,3312,-1,3113,3114,3314,3313,-1,3114,3115,3315,3314,-1,3115,3116,3316,3315,-1,3116,3117,3317,3316,-1,3117,3118,3318,3317,-1,3118,3119,3319,3318,-1,3119,3120,3320,3319,-1,3120,3121,3321,3320,-1,3121,3122,3322,3321,-1,3122,3123,3323,3322,-1,3123,3124,3324,3323,-1,3124,3125,3325,3324,-1,3125,3126,3326,3325,-1,3126,3127,3327,3326,-1,3127,3128,3328,3327,-1,3128,3129,3329,3328,-1,3129,3130,3330,3329,-1,3130,3131,3331,3330,-1,3131,3132,3332,3331,-1,3132,3133,3333,3332,-1,3133,3134,3334,3333,-1,3134,3135,3335,3334,-1,3135,3136,3336,3335,-1,3136,3137,3337,3336,-1,3137,3138,3338,3337,-1,3138,3139,3339,3338,-1,3139,3140,3340,3339,-1,3140,3141,3341,3340,-1,3141,3142,3342,3341,-1,3142,3143,3343,3342,-1,3143,3144,3344,3343,-1,3144,3145,3345,3344,-1,3145,3146,3346,3345,-1,3146,3147,3347,3346,-1,3147,3148,3348,3347,-1,3148,3149,3349,3348,-1,3149,3150,3350,3349,-1,3150,3151,3351,3350,-1,3151,3152,3352,3351,-1,3152,3153,3353,3352,-1,3153,3154,3354,3353,-1,3154,3155,3355,3354,-1,3155,3156,3356,3355,-1,3156,3157,3357,3356,-1,3157,3158,3358,3357,-1,3158,3159,3359,3358,-1,3159,3160,3360,3359,-1,3160,3161,3361,3360,-1,3161,3162,3362,3361,-1,3162,3163,3363,3362,-1,3163,3164,3364,3363,-1,3164,3165,3365,3364,-1,3165,3166,3366,3365,-1,3166,3167,3367,3366,-1,3167,3168,3368,3367,-1,3168,3169,3369,3368,-1,3169,3170,3370,3369,-1,3170,3171,3371,3370,-1,3171,3172,3372,3371,-1,3172,3173,3373,3372,-1,3173,3174,3374,3373,-1,3174,3175,3375,3374,-1,3175,3176,3376,3375,-1,3176,3177,3377,3376,-1,3177,3178,3378,3377,-1,3178,3179,3379,3378,-1,3179,3180,3380,3379,-1,3180,3181,3381,3380,-1,3181,3182,3382,3381,-1,3182,3183,3383,3382,-1,3183,3184,3384,3383,-1,3184,3185,3385,3384,-1,3185,3186,3386,3385,-1,3186,3187,3387,3386,-1,3187,3188,3388,3387,-1,3188,3189,3389,3388,-1,3189,3190,3390,3389,-1,3190,3191,3391,3390,-1,3191,3192,3392,3391,-1,3192,3193,3393,3392,-1,3193,3194,3394,3393,-1,3194,3195,3395,3394,-1,3195,3196,3396,3395,-1,3196,3197,3397,3396,-1,3197,3198,3398,3397,-1,3198,3199,3399,3398,-1,3200,3201,3401,3400,-1,3201,3202,3402,3401,-1,3202,3203,3403,3402,-1,3203,3204,3404,3403,-1,3204,3205,3405,3404,-1,3205,3206,3406,3405,-1,3206,3207,3407,3406,-1,3207,3208,3408,3407,-1,3208,3209,3409,3408,-1,3209,3210,3410,3409,-1,3210,3211,3411,3410,-1,3211,3212,3412,3411,-1,3212,3213,3413,3412,-1,3213,3214,3414,3413,-1,3214,3215,3415,3414,-1,3215,3216,3416,3415,-1,3216,3217,3417,3416,-1,3217,3218,3418,3417,-1,3218,3219,3419,3418,-1,3219,3220,3420,3419,-1,3220,3221,3421,3420,-1,3221,3222,3422,3421,-1,3222,3223,3423,3422,-1,3223,3224,3424,3423,-1,3224,3225,3425,3424,-1,3225,3226,3426,3425,-1,3226,3227,3427,3426,-1,3227,3228,3428,3427,-1,3228,3229,3429,3428,-1,3229,3230,3430,3429,-1,3230,3231,3431,3430,-1,3231,3232,3432,3431,-1,3232,3233,3433,3432,-1,3233,3234,3434,3433,-1,3234,3235,3435,3434,-1,3235,3236,3436,3435,-1,3236,3237,3437,3436,-1,3237,3238,3438,3437,-1,3238,3239,3439,3438,-1,3239,3240,3440,3439,-1,3240,3241,3441,3440,-1,3241,3242,3442,3441,-1,3242,3243,3443,3442,-1,3243,3244,3444,3443,-1,3244,3245,3445,3444,-1,3245,3246,3446,3445,-1,3246,3247,3447,3446,-1,3247,3248,3448,3447,-1,3248,3249,3449,3448,-1,3249,3250,3450,3449,-1,3250,3251,3451,3450,-1,3251,3252,3452,3451,-1,3252,3253,3453,3452,-1,3253,3254,3454,3453,-1,3254,3255,3455,3454,-1,3255,3256,3456,3455,-1,3256,3257,3457,3456,-1,3257,3258,3458,3457,-1,3258,3259,3459,3458,-1,3259,3260,3460,3459,-1,3260,3261,3461,3460,-1,3261,3262,3462,3461,-1,3262,3263,3463,3462,-1,3263,3264,3464,3463,-1,3264,3265,3465,3464,-1,3265,3266,3466,3465,-1,3266,3267,3467,3466,-1,3267,3268,3468,3467,-1,3268,3269,3469,3468,-1,3269,3270,3470,3469,-1,3270,3271,3471,3470,-1,3271,3272,3472,3471,-1,3272,3273,3473,3472,-1,3273,3274,3474,3473,-1,3274,3275,3475,3474,-1,3275,3276,3476,3475,-1,3276,3277,3477,3476,-1,3277,3278,3478,3477,-1,3278,3279,3479,3478,-1,3279,3280,3480,3479,-1,3280,3281,3481,3480,-1,3281,3282,3482,3481,-1,3282,3283,3483,3482,-1,3283,3284,3484,3483,-1,3284,3285,3485,3484,-1,3285,3286,3486,3485,-1,3286,3287,3487,3486,-1,3287,3288,3488,3487,-1,3288,3289,3489,3488,-1,3289,3290,3490,3489,-1,3290,3291,3491,3490,-1,3291,3292,3492,3491,-1,3292,3293,3493,3492,-1,3293,3294,3494,3493,-1,3294,3295,3495,3494,-1,3295,3296,3496,3495,-1,3296,3297,3497,3496,-1,3297,3298,3498,3497,-1,3298,3299,3499,3498,-1,3299,3300,3500,3499,-1,3300,3301,3501,3500,-1,3301,3302,3502,3501,-1,3302,3303,3503,3502,-1,3303,3304,3504,3503,-1,3304,3305,3505,3504,-1,3305,3306,3506,3505,-1,3306,3307,3507,3506,-1,3307,3308,3508,3507,-1,3308,3309,3509,3508,-1,3309,3310,3510,3509,-1,3310,3311,3511,3510,-1,3311,3312,3512,3511,-1,3312,3313,3513,3512,-1,3313,3314,3514,3513,-1,3314,3315,3515,3514,-1,3315,3316,3516,3515,-1,3316,3317,3517,3516,-1,3317,3318,3518,3517,-1,3318,3319,3519,3518,-1,3319,3320,3520,3519,-1,3320,3321,3521,3520,-1,3321,3322,3522,3521,-1,3322,3323,3523,3522,-1,3323,3324,3524,3523,-1,3324,3325,3525,3524,-1,3325,3326,3526,3525,-1,3326,3327,3527,3526,-1,3327,3328,3528,3527,-1,3328,3329,3529,3528,-1,3329,3330,3530,3529,-1,3330,3331,3531,3530,-1,3331,3332,3532,3531,-1,3332,3333,3533,3532,-1,3333,3334,3534,3533,-1,3334,3335,3535,3534,-1,3335,3336,3536,3535,-1,3336,3337,3537,3536,-1,3337,3338,3538,3537,-1,3338,3339,3539,3538,-1,3339,3340,3540,3539,-1,3340,3341,3541,3540,-1,3341,3342,3542,3541,-1,3342,3343,3543,3542,-1,3343,3344,3544,3543,-1,3344,3345,3545,3544,-1,3345,3346,3546,3545,-1,3346,3347,3547,3546,-1,3347,3348,3548,3547,-1,3348,3349,3549,3548,-1,3349,3350,3550,3549,-1,3350,3351,3551,3550,-1,3351,3352,3552,3551,-1,3352,3353,3553,3552,-1,3353,3354,3554,3553,-1,3354,3355,3555,3554,-1,3355,3356,3556,3555,-1,3356,3357,3557,3556,-1,3357,3358,3558,3557,-1,3358,3359,3559,3558,-1,3359,3360,3560,3559,-1,3360,3361,3561,3560,-1,3361,3362,3562,3561,-1,3362,3363,3563,3562,-1,3363,3364,3564,3563,-1,3364,3365,3565,3564,-1,3365,3366,3566,3565,-1,3366,3367,3567,3566,-1,3367,3368,3568,3567,-1,3368,3369,3569,3568,-1,3369,3370,3570,3569,-1,3370,3371,3571,3570,-1,3371,3372,3572,3571,-1,3372,3373,3573,3572,-1,3373,3374,3574,3573,-1,3374,3375,3575,3574,-1,3375,3376,3576,3575,-1,3376,3377,3577,3576,-1,3377,3378,3578,3577,-1,3378,3379,3579,3578,-1,3379,3380,3580,3579,-1,3380,3381,3581,3580,-1,3381,3382,3582,3581,-1,3382,3383,3583,3582,-1,3383,3384,3584,3583,-1,3384,3385,3585,3584,-1,3385,3386,3586,3585,-1,3386,3387,3587,3586,-1,3387,3388,3588,3587,-1,3388,3389,3589,3588,-1,3389,3390,3590,3589,-1,3390,3391,3591,3590,-1,3391,3392,3592,3591,-1,3392,3393,3593,3592,-1,3393,3394,3594,3593,-1,3394,3395,3595,3594,-1,3395,3396,3596,3595,-1,3396,3397,3597,3596,-1,3397,3398,3598,3597,-1,3398,3399,3599,3598,-1,3400,3401,3601,3600,-1,3401,3402,3602,3601,-1,3402,3403,3603,3602,-1,3403,3404,3604,3603,-1,3404,3405,3605,3604,-1,3405,3406,3606,3605,-1,3406,3407,3607,3606,-1,3407,3408,3608,3607,-1,3408,3409,3609,3608,-1,3409,3410,3610,3609,-1,3410,3411,3611,3610,-1,3411,3412,3612,3611,-1,3412,3413,3613,3612,-1,3413,3414,3614,3613,-1,3414,3415,3615,3614,-1,3415,3416,3616,3615,-1,3416,3417,3617,3616,-1,3417,3418,3618,3617,-1,3418,3419,3619,3618,-1,3419,3420,3620,3619,-1,3420,3421,3621,3620,-1,3421,3422,3622,3621,-1,3422,3423,3623,3622,-1,3423,3424,3624,3623,-1,3424,3425,3625,3624,-1,3425,3426,3626,3625,-1,3426,3427,3627,3626,-1,3427,3428,3628,3627,-1,3428,3429,3629,3628,-1,3429,3430,3630,3629,-1,3430,3431,3631,3630,-1,3431,3432,3632,3631,-1,3432,3433,3633,3632,-1,3433,3434,3634,3633,-1,3434,3435,3635,3634,-1,3435,3436,3636,3635,-1,3436,3437,3637,3636,-1,3437,3438,3638,3637,-1,3438,3439,3639,3638,-1,3439,3440,3640,3639,-1,3440,3441,3641,3640,-1,3441,3442,3642,3641,-1,3442,3443,3643,3642,-1,3443,3444,3644,3643,-1,3444,3445,3645,3644,-1,3445,3446,3646,3645,-1,3446,3447,3647,3646,-1,3447,3448,3648,3647,-1,3448,3449,3649,3648,-1,3449,3450,3650,3649,-1,3450,3451,3651,3650,-1,3451,3452,3652,3651,-1,3452,3453,3653,3652,-1,3453,3454,3654,3653,-1,3454,3455,3655,3654,-1,3455,3456,3656,3655,-1,3456,3457,3657,3656,-1,3457,3458,3658,3657,-1,3458,3459,3659,3658,-1,3459,3460,3660,3659,-1,3460,3461,3661,3660,-1,3461,3462,3662,3661,-1,3462,3463,3663,3662,-1,3463,3464,3664,3663,-1,3464,3465,3665,3664,-1,3465,3466,3666,3665,-1,3466,3467,3667,3666,-1,3467,3468,3668,3667,-1,3468,3469,3669,3668,-1,3469,3470,3670,3669,-1,3470,3471,3671,3670,-1,3471,3472,3672,3671,-1,3472,3473,3673,3672,-1,3473,3474,3674,3673,-1,3474,3475,3675,3674,-1,3475,3476,3676,3675,-1,3476,3477,3677,3676,-1,3477,3478,3678,3677,-1,3478,3479,3679,3678,-1,3479,3480,3680,3679,-1,3480,3481,3681,3680,-1,3481,3482,3682,3681,-1,3482,3483,3683,3682,-1,3483,3484,3684,3683,-1,3484,3485,3685,3684,-1,3485,3486,3686,3685,-1,3486,3487,3687,3686,-1,3487,3488,3688,3687,-1,3488,3489,3689,3688,-1,3489,3490,3690,3689,-1,3490,3491,3691,3690,-1,3491,3492,3692,3691,-1,3492,3493,3693,3692,-1,3493,3494,3694,3693,-1,3494,3495,3695,3694,-1,3495,3496,3696,3695,-1,3496,3497,3697,3696,-1,3497,3498,3698,3697,-1,3498,3499,3699,3698,-1,3499,3500,3700,3699,-1,3500,3501,3701,3700,-1,3501,3502,3702,3701,-1,3502,3503,3703,3702,-1,3503,3504,3704,3703,-1,3504,3505,3705,3704,-1,3505,3506,3706,3705,-1,3506,3507,3707,3706,-1,3507,3508,3708,3707,-1,3508,3509,3709,3708,-1,3509,3510,3710,3709,-1,3510,3511,3711,3710,-1,3511,3512,3712,3711,-1,3512,3513,3713,3712,-1,3513,3514,3714,3713,-1,3514,3515,3715,3714,-1,3515,3516,3716,3715,-1,3516,3517,3717,3716,-1,3517,3518,3718,3717,-1,3518,3519,3719,3718,-1,3519,3520,3720,3719,-1,3520,3521,3721,3720,-1,3521,3522,3722,3721,-1,3522,3523,3723,3722,-1,3523,3524,3724,3723,-1,3524,3525,3725,3724,-1,3525,3526,3726,3725,-1,3526,3527,3727,3726,-1,3527,3528,3728,3727,-1,3528,3529,3729,3728,-1,3529,3530,3730,3729,-1,3530,3531,3731,3730,-1,3531,3532,3732,3731,-1,3532,3533,3733,3732,-1,3533,3534,3734,3733,-1,3534,3535,3735,3734,-1,3535,3536,3736,3735,-1,3536,3537,3737,3736,-1,3537,3538,3738,3737,-1,3538,3539,3739,3738,-1,3539,3540,3740,3739,-1,3540,3541,3741,3740,-1,3541,3542,3742,3741,-1,3542,3543,3743,3742,-1,3543,3544,3744,3743,-1,3544,3545,3745,3744,-1,3545,3546,3746,3745,-1,3546,3547,3747,3746,-1,3547,3548,3748,3747,-1,3548,3549,3749,3748,-1,3549,3550,3750,3749,-1,3550,3551,3751,3750,-1,3551,3552,3752,3751,-1,3552,3553,3753,3752,-1,3553,3554,3754,3753,-1,3554,3555,3755,3754,-1,3555,3556,3756,3755,-1,3556,3557,3757,3756,-1,3557,3558,3758,3757,-1,3558,3559,3759,3758,-1,3559,3560,3760,3759,-1,3560,3561,3761,3760,-1,3561,3562,3762,3761,-1,3562,3563,3763,3762,-1,3563,3564,3764,3763,-1,3564,3565,3765,3764,-1,3565,3566,3766,3765,-1,3566,3567,3767,3766,-1,3567,3568,3768,3767,-1,3568,3569,3769,3768,-1,3569,3570,3770,3769,-1,3570,3571,3771,3770,-1,3571,3572,3772,3771,-1,3572,3573,3773,3772,-1,3573,3574,3774,3773,-1,3574,3575,3775,3774,-1,3575,3576,3776,3775,-1,3576,3577,3777,3776,-1,3577,3578,3778,3777,-1,3578,3579,3779,3778,-1,3579,3580,3780,3779,-1,3580,3581,3781,3780,-1,3581,3582,3782,3781,-1,3582,3583,3783,3782,-1,3583,3584,3784,3783,-1,3584,3585,3785,3784,-1,3585,3586,3786,3785,-1,3586,3587,3787,3786,-1,3587,3588,3788,3787,-1,3588,3589,3789,3788,-1,3589,3590,3790,3789,-1,3590,3591,3791,3790,-1,3591,3592,3792,3791,-1,3592,3593,3793,3792,-1,3593,3594,3794,3793,-1,3594,3595,3795,3794,-1,3595,3596,3796,3795,-1,3596,3597,3797,3796,-1,3597,3598,3798,3797,-1,3598,3599,3799,3798,-1,3600,3601,3801,3800,-1,3601,3602,3802,3801,-1,3602,3603,3803,3802,-1,3603,3604,3804,3803,-1,3604,3605,3805,3804,-1,3605,3606,3806,3805,-1,3606,3607,3807,3806,-1,3607,3608,3808,3807,-1,3608,3609,3809,3808,-1,3609,3610,3810,3809,-1,3610,3611,3811,3810,-1,3611,3612,3812,3811,-1,3612,3613,3813,3812,-1,3613,3614,3814,3813,-1,3614,3615,3815,3814,-1,3615,3616,3816,3815,-1,3616,3617,3817,3816,-1,3617,3618,3818,3817,-1,3618,3619,3819,3818,-1,3619,3620,3820,3819,-1,3620,3621,3821,3820,-1,3621,3622,3822,3821,-1,3622,3623,3823,3822,-1,3623,3624,3824,3823,-1,3624,3625,3825,3824,-1,3625,3626,3826,3825,-1,3626,3627,3827,3826,-1,3627,3628,3828,3827,-1,3628,3629,3829,3828,-1,3629,3630,3830,3829,-1,3630,3631,3831,3830,-1,3631,3632,3832,3831,-1,3632,3633,3833,3832,-1,3633,3634,3834,3833,-1,3634,3635,3835,3834,-1,3635,3636,3836,3835,-1,3636,3637,3837,3836,-1,3637,3638,3838,3837,-1,3638,3639,3839,3838,-1,3639,3640,3840,3839,-1,3640,3641,3841,3840,-1,3641,3642,3842,3841,-1,3642,3643,3843,3842,-1,3643,3644,3844,3843,-1,3644,3645,3845,3844,-1,3645,3646,3846,3845,-1,3646,3647,3847,3846,-1,3647,3648,3848,3847,-1,3648,3649,3849,3848,-1,3649,3650,3850,3849,-1,3650,3651,3851,3850,-1,3651,3652,3852,3851,-1,3652,3653,3853,3852,-1,3653,3654,3854,3853,-1,3654,3655,3855,3854,-1,3655,3656,3856,3855,-1,3656,3657,3857,3856,-1,3657,3658,3858,3857,-1,3658,3659,3859,3858,-1,3659,3660,3860,3859,-1,3660,3661,3861,3860,-1,3661,3662,3862,3861,-1,3662,3663,3863,3862,-1,3663,3664,3864,3863,-1,3664,3665,3865,3864,-1,3665,3666,3866,3865,-1,3666,3667,3867,3866,-1,3667,3668,3868,3867,-1,3668,3669,3869,3868,-1,3669,3670,3870,3869,-1,3670,3671,3871,3870,-1,3671,3672,3872,3871,-1,3672,3673,3873,3872,-1,3673,3674,3874,3873,-1,3674,3675,3875,3874,-1,3675,3676,3876,3875,-1,3676,3677,3877,3876,-1,3677,3678,3878,3877,-1,3678,3679,3879,3878,-1,3679,3680,3880,3879,-1,3680,3681,3881,3880,-1,3681,3682,3882,3881,-1,3682,3683,3883,3882,-1,3683,3684,3884,3883,-1,3684,3685,3885,3884,-1,3685,3686,3886,3885,-1,3686,3687,3887,3886,-1,3687,3688,3888,3887,-1,3688,3689,3889,3888,-1,3689,3690,3890,3889,-1,3690,3691,3891,3890,-1,3691,3692,3892,3891,-1,3692,3693,3893,3892,-1,3693,3694,3894,3893,-1,3694,3695,3895,3894,-1,3695,3696,3896,3895,-1,3696,3697,3897,3896,-1,3697,3698,3898,3897,-1,3698,3699,3899,3898,-1,3699,3700,3900,3899,-1,3700,3701,3901,3900,-1,3701,3702,3902,3901,-1,3702,3703,3903,3902,-1,3703,3704,3904,3903,-1,3704,3705,3905,3904,-1,3705,3706,3906,3905,-1,3706,3707,3907,3906,-1,3707,3708,3908,3907,-1,3708,3709,3909,3908,-1,3709,3710,3910,3909,-1,3710,3711,3911,3910,-1,3711,3712,3912,3911,-1,3712,3713,3913,3912,-1,3713,3714,3914,3913,-1,3714,3715,3915,3914,-1,3715,3716,3916,3915,-1,3716,3717,3917,3916,-1,3717,3718,3918,3917,-1,3718,3719,3919,3918,-1,3719,3720,3920,3919,-1,3720,3721,3921,3920,-1,3721,3722,3922,3921,-1,3722,3723,3923,3922,-1,3723,3724,3924,3923,-1,3724,3725,3925,3924,-1,3725,3726,3926,3925,-1,3726,3727,3927,3926,-1,3727,3728,3928,3927,-1,3728,3729,3929,3928,-1,3729,3730,3930,3929,-1,3730,3731,3931,3930,-1,3731,3732,3932,3931,-1,3732,3733,3933,3932,-1,3733,3734,3934,3933,-1,3734,3735,3935,3934,-1,3735,3736,3936,3935,-1,3736,3737,3937,3936,-1,3737,3738,3938,3937,-1,3738,3739,3939,3938,-1,3739,3740,3940,3939,-1,3740,3741,3941,3940,-1,3741,3742,3942,3941,-1,3742,3743,3943,3942,-1,3743,3744,3944,3943,-1,3744,3745,3945,3944,-1,3745,3746,3946,3945,-1,3746,3747,3947,3946,-1,3747,3748,3948,3947,-1,3748,3749,3949,3948,-1,3749,3750,3950,3949,-1,3750,3751,3951,3950,-1,3751,3752,3952,3951,-1,3752,3753,3953,3952,-1,3753,3754,3954,3953,-1,3754,3755,3955,3954,-1,3755,3756,3956,3955,-1,3756,3757,3957,3956,-1,3757,3758,3958,3957,-1,3758,3759,3959,3958,-1,3759,3760,3960,3959,-1,3760,3761,3961,3960,-1,3761,3762,3962,3961,-1,3762,3763,3963,3962,-1,3763,3764,3964,3963,-1,3764,3765,3965,3964,-1,3765,3766,3966,3965,-1,3766,3767,3967,3966,-1,3767,3768,3968,3967,-1,3768,3769,3969,3968,-1,3769,3770,3970,3969,-1,3770,3771,3971,3970,-1,3771,3772,3972,3971,-1,3772,3773,3973,3972,-1,3773,3774,3974,3973,-1,3774,3775,3975,3974,-1,3775,3776,3976,3975,-1,3776,3777,3977,3976,-1,3777,3778,3978,3977,-1,3778,3779,3979,3978,-1,3779,3780,3980,3979,-1,3780,3781,3981,3980,-1,3781,3782,3982,3981,-1,3782,3783,3983,3982,-1,3783,3784,3984,3983,-1,3784,3785,3985,3984,-1,3785,3786,3986,3985,-1,3786,3787,3987,3986,-1,3787,3788,3988,3987,-1,3788,3789,3989,3988,-1,3789,3790,3990,3989,-1,3790,3791,3991,3990,-1,3791,3792,3992,3991,-1,3792,3793,3993,3992,-1,3793,3794,3994,3993,-1,3794,3795,3995,3994,-1,3795,3796,3996,3995,-1,3796,3797,3997,3996,-1,3797,3798,3998,3997,-1,3798,3799,3999,3998,-1,3800,3801,4001,4,-1,3801,3802,4002,4001,-1,3802,3803,4003,4002,-1,3803,3804,4004,4003,-1,3804,3805,4005,4004,-1,3805,3806,4006,4005,-1,3806,3807,4007,4006,-1,3807,3808,4008,4007,-1,3808,3809,4009,4008,-1,3809,3810,4010,4009,-1,3810,3811,4011,4010,-1,3811,3812,4012,4011,-1,3812,3813,4013,4012,-1,3813,3814,4014,4013,-1,3814,3815,4015,4014,-1,3815,3816,4016,4015,-1,3816,3817,4017,4016,-1,3817,3818,4018,4017,-1,3818,3819,4019,4018,-1,3819,3820,4020,4019,-1,3820,3821,4021,4020,-1,3821,3822,4022,4021,-1,3822,3823,4023,4022,-1,3823,3824,4024,4023,-1,3824,3825,4025,4024,-1,3825,3826,4026,4025,-1,3826,3827,4027,4026,-1,3827,3828,4028,4027,-1,3828,3829,4029,4028,-1,3829,3830,4030,4029,-1,3830,3831,4031,4030,-1,3831,3832,4032,4031,-1,3832,3833,4033,4032,-1,3833,3834,4034,4033,-1,3834,3835,4035,4034,-1,3835,3836,4036,4035,-1,3836,3837,4037,4036,-1,3837,3838,4038,4037,-1,3838,3839,4039,4038,-1,3839,3840,4040,4039,-1,3840,3841,4041,4040,-1,3841,3842,4042,4041,-1,3842,3843,4043,4042,-1,3843,3844,4044,4043,-1,3844,3845,4045,4044,-1,3845,3846,4046,4045,-1,3846,3847,4047,4046,-1,3847,3848,4048,4047,-1,3848,3849,4049,4048,-1,3849,3850,4050,4049,-1,3850,3851,4051,4050,-1,3851,3852,4052,4051,-1,3852,3853,4053,4052,-1,3853,3854,4054,4053,-1,3854,3855,4055,4054,-1,3855,3856,4056,4055,-1,3856,3857,4057,4056,-1,3857,3858,4058,4057,-1,3858,3859,4059,4058,-1,3859,3860,4060,4059,-1,3860,3861,4061,4060,-1,3861,3862,4062,4061,-1,3862,3863,4063,4062,-1,3863,3864,4064,4063,-1,3864,3865,4065,4064,-1,3865,3866,4066,4065,-1,3866,3867,4067,4066,-1,3867,3868,4068,4067,-1,3868,3869,4069,4068,-1,3869,3870,4070,4069,-1,3870,3871,4071,4070,-1,3871,3872,4072,4071,-1,3872,3873,4073,4072,-1,3873,3874,4074,4073,-1,3874,3875,4075,4074,-1,3875,3876,4076,4075,-1,3876,3877,4077,4076,-1,3877,3878,4078,4077,-1,3878,3879,4079,4078,-1,3879,3880,4080,4079,-1,3880,3881,4081,4080,-1,3881,3882,4082,4081,-1,3882,3883,4083,4082,-1,3883,3884,4084,4083,-1,3884,3885,4085,4084,-1,3885,3886,4086,4085,-1,3886,3887,4087,4086,-1,3887,3888,4088,4087,-1,3888,3889,4089,4088,-1,3889,3890,4090,4089,-1,3890,3891,4091,4090,-1,3891,3892,4092,4091,-1,3892,3893,4093,4092,-1,3893,3894,4094,4093,-1,3894,3895,4095,4094,-1,3895,3896,4096,4095,-1,3896,3897,4097,4096,-1,3897,3898,4098,4097,-1,3898,3899,4099,4098,-1,3899,3900,4100,4099,-1,3900,3901,4101,4100,-1,3901,3902,4102,4101,-1,3902,3903,4103,4102,-1,3903,3904,4104,4103,-1,3904,3905,4105,4104,-1,3905,3906,4106,4105,-1,3906,3907,4107,4106,-1,3907,3908,4108,4107,-1,3908,3909,4109,4108,-1,3909,3910,4110,4109,-1,3910,3911,4111,4110,-1,3911,3912,4112,4111,-1,3912,3913,4113,4112,-1,3913,3914,4114,4113,-1,3914,3915,4115,4114,-1,3915,3916,4116,4115,-1,3916,3917,4117,4116,-1,3917,3918,4118,4117,-1,3918,3919,4119,4118,-1,3919,3920,4120,4119,-1,3920,3921,4121,4120,-1,3921,3922,4122,4121,-1,3922,3923,4123,4122,-1,3923,3924,4124,4123,-1,3924,3925,4125,4124,-1,3925,3926,4126,4125,-1,3926,3927,4127,4126,-1,3927,3928,4128,4127,-1,3928,3929,4129,4128,-1,3929,3930,4130,4129,-1,3930,3931,4131,4130,-1,3931,3932,4132,4131,-1,3932,3933,4133,4132,-1,3933,3934,4134,4133,-1,3934,3935,4135,4134,-1,3935,3936,4136,4135,-1,3936,3937,4137,4136,-1,3937,3938,4138,4137,-1,3938,3939,4139,4138,-1,3939,3940,4140,4139,-1,3940,3941,4141,4140,-1,3941,3942,4142,4141,-1,3942,3943,4143,4142,-1,3943,3944,4144,4143,-1,3944,3945,4145,4144,-1,3945,3946,4146,4145,-1,3946,3947,4147,4146,-1,3947,3948,4148,4147,-1,3948,3949,4149,4148,-1,3949,3950,4150,4149,-1,3950,3951,4151,4150,-1,3951,3952,4152,4151,-1,3952,3953,4153,4152,-1,3953,3954,4154,4153,-1,3954,3955,4155,4154,-1,3955,3956,4156,4155,-1,3956,3957,4157,4156,-1,3957,3958,4158,4157,-1,3958,3959,4159,4158,-1,3959,3960,4160,4159,-1,3960,3961,4161,4160,-1,3961,3962,4162,4161,-1,3962,3963,4163,4162,-1,3963,3964,4164,4163,-1,3964,3965,4165,4164,-1,3965,3966,4166,4165,-1,3966,3967,4167,4166,-1,3967,3968,4168,4167,-1,3968,3969,4169,4168,-1,3969,3970,4170,4169,-1,3970,3971,4171,4170,-1,3971,3972,4172,4171,-1,3972,3973,4173,4172,-1,3973,3974,4174,4173,-1,3974,3975,4175,4174,-1,3975,3976,4176,4175,-1,3976,3977,4177,4176,-1,3977,3978,4178,4177,-1,3978,3979,4179,4178,-1,3979,3980,4180,4179,-1,3980,3981,4181,4180,-1,3981,3982,4182,4181,-1,3982,3983,4183,4182,-1,3983,3984,4184,4183,-1,3984,3985,4185,4184,-1,3985,3986,4186,4185,-1,3986,3987,4187,4186,-1,3987,3988,4188,4187,-1,3988,3989,4189,4188,-1,3989,3990,4190,4189,-1,3990,3991,4191,4190,-1,3991,3992,4192,4191,-1,3992,3993,4193,4192,-1,3993,3994,4194,4193,-1,3994,3995,4195,4194,-1,3995,3996,4196,4195,-1,3996,3997,4197,4196,-1,3997,3998,4198,4197,-1,3998,3999,4199,4198,-1,4,4001,4201,4200,-1,4001,4002,4202,4201,-1,4002,4003,4203,4202,-1,4003,4004,4204,4203,-1,4004,4005,4205,4204,-1,4005,4006,4206,4205,-1,4006,4007,4207,4206,-1,4007,4008,4208,4207,-1,4008,4009,4209,4208,-1,4009,4010,4210,4209,-1,4010,4011,4211,4210,-1,4011,4012,4212,4211,-1,4012,4013,4213,4212,-1,4013,4014,4214,4213,-1,4014,4015,4215,4214,-1,4015,4016,4216,4215,-1,4016,4017,4217,4216,-1,4017,4018,4218,4217,-1,4018,4019,4219,4218,-1,4019,4020,4220,4219,-1,4020,4021,4221,4220,-1,4021,4022,4222,4221,-1,4022,4023,4223,4222,-1,4023,4024,4224,4223,-1,4024,4025,4225,4224,-1,4025,4026,4226,4225,-1,4026,4027,4227,4226,-1,4027,4028,4228,4227,-1,4028,4029,4229,4228,-1,4029,4030,4230,4229,-1,4030,4031,4231,4230,-1,4031,4032,4232,4231,-1,4032,4033,4233,4232,-1,4033,4034,4234,4233,-1,4034,4035,4235,4234,-1,4035,4036,4236,4235,-1,4036,4037,4237,4236,-1,4037,4038,4238,4237,-1,4038,4039,4239,4238,-1,4039,4040,4240,4239,-1,4040,4041,4241,4240,-1,4041,4042,4242,4241,-1,4042,4043,4243,4242,-1,4043,4044,4244,4243,-1,4044,4045,4245,4244,-1,4045,4046,4246,4245,-1,4046,4047,4247,4246,-1,4047,4048,4248,4247,-1,4048,4049,4249,4248,-1,4049,4050,4250,4249,-1,4050,4051,4251,4250,-1,4051,4052,4252,4251,-1,4052,4053,4253,4252,-1,4053,4054,4254,4253,-1,4054,4055,4255,4254,-1,4055,4056,4256,4255,-1,4056,4057,4257,4256,-1,4057,4058,4258,4257,-1,4058,4059,4259,4258,-1,4059,4060,4260,4259,-1,4060,4061,4261,4260,-1,4061,4062,4262,4261,-1,4062,4063,4263,4262,-1,4063,4064,4264,4263,-1,4064,4065,4265,4264,-1,4065,4066,4266,4265,-1,4066,4067,4267,4266,-1,4067,4068,4268,4267,-1,4068,4069,4269,4268,-1,4069,4070,4270,4269,-1,4070,4071,4271,4270,-1,4071,4072,4272,4271,-1,4072,4073,4273,4272,-1,4073,4074,4274,4273,-1,4074,4075,4275,4274,-1,4075,4076,4276,4275,-1,4076,4077,4277,4276,-1,4077,4078,4278,4277,-1,4078,4079,4279,4278,-1,4079,4080,4280,4279,-1,4080,4081,4281,4280,-1,4081,4082,4282,4281,-1,4082,4083,4283,4282,-1,4083,4084,4284,4283,-1,4084,4085,4285,4284,-1,4085,4086,4286,4285,-1,4086,4087,4287,4286,-1,4087,4088,4288,4287,-1,4088,4089,4289,4288,-1,4089,4090,4290,4289,-1,4090,4091,4291,4290,-1,4091,4092,4292,4291,-1,4092,4093,4293,4292,-1,4093,4094,4294,4293,-1,4094,4095,4295,4294,-1,4095,4096,4296,4295,-1,4096,4097,4297,4296,-1,4097,4098,4298,4297,-1,4098,4099,4299,4298,-1,4099,4100,4300,4299,-1,4100,4101,4301,4300,-1,4101,4102,4302,4301,-1,4102,4103,4303,4302,-1,4103,4104,4304,4303,-1,4104,4105,4305,4304,-1,4105,4106,4306,4305,-1,4106,4107,4307,4306,-1,4107,4108,4308,4307,-1,4108,4109,4309,4308,-1,4109,4110,4310,4309,-1,4110,4111,4311,4310,-1,4111,4112,4312,4311,-1,4112,4113,4313,4312,-1,4113,4114,4314,4313,-1,4114,4115,4315,4314,-1,4115,4116,4316,4315,-1,4116,4117,4317,4316,-1,4117,4118,4318,4317,-1,4118,4119,4319,4318,-1,4119,4120,4320,4319,-1,4120,4121,4321,4320,-1,4121,4122,4322,4321,-1,4122,4123,4323,4322,-1,4123,4124,4324,4323,-1,4124,4125,4325,4324,-1,4125,4126,4326,4325,-1,4126,4127,4327,4326,-1,4127,4128,4328,4327,-1,4128,4129,4329,4328,-1,4129,4130,4330,4329,-1,4130,4131,4331,4330,-1,4131,4132,4332,4331,-1,4132,4133,4333,4332,-1,4133,4134,4334,4333,-1,4134,4135,4335,4334,-1,4135,4136,4336,4335,-1,4136,4137,4337,4336,-1,4137,4138,4338,4337,-1,4138,4139,4339,4338,-1,4139,4140,4340,4339,-1,4140,4141,4341,4340,-1,4141,4142,4342,4341,-1,4142,4143,4343,4342,-1,4143,4144,4344,4343,-1,4144,4145,4345,4344,-1,4145,4146,4346,4345,-1,4146,4147,4347,4346,-1,4147,4148,4348,4347,-1,4148,4149,4349,4348,-1,4149,4150,4350,4349,-1,4150,4151,4351,4350,-1,4151,4152,4352,4351,-1,4152,4153,4353,4352,-1,4153,4154,4354,4353,-1,4154,4155,4355,4354,-1,4155,4156,4356,4355,-1,4156,4157,4357,4356,-1,4157,4158,4358,4357,-1,4158,4159,4359,4358,-1,4159,4160,4360,4359,-1,4160,4161,4361,4360,-1,4161,4162,4362,4361,-1,4162,4163,4363,4362,-1,4163,4164,4364,4363,-1,4164,4165,4365,4364,-1,4165,4166,4366,4365,-1,4166,4167,4367,4366,-1,4167,4168,4368,4367,-1,4168,4169,4369,4368,-1,4169,4170,4370,4369,-1,4170,4171,4371,4370,-1,4171,4172,4372,4371,-1,4172,4173,4373,4372,-1,4173,4174,4374,4373,-1,4174,4175,4375,4374,-1,4175,4176,4376,4375,-1,4176,4177,4377,4376,-1,4177,4178,4378,4377,-1,4178,4179,4379,4378,-1,4179,4180,4380,4379,-1,4180,4181,4381,4380,-1,4181,4182,4382,4381,-1,4182,4183,4383,4382,-1,4183,4184,4384,4383,-1,4184,4185,4385,4384,-1,4185,4186,4386,4385,-1,4186,4187,4387,4386,-1,4187,4188,4388,4387,-1,4188,4189,4389,4388,-1,4189,4190,4390,4389,-1,4190,4191,4391,4390,-1,4191,4192,4392,4391,-1,4192,4193,4393,4392,-1,4193,4194,4394,4393,-1,4194,4195,4395,4394,-1,4195,4196,4396,4395,-1,4196,4197,4397,4396,-1,4197,4198,4398,4397,-1,4198,4199,4399,4398,-1,4200,4201,4401,4400,-1,4201,4202,4402,4401,-1,4202,4203,4403,4402,-1,4203,4204,4404,4403,-1,4204,4205,4405,4404,-1,4205,4206,4406,4405,-1,4206,4207,4407,4406,-1,4207,4208,4408,4407,-1,4208,4209,4409,4408,-1,4209,4210,4410,4409,-1,4210,4211,4411,4410,-1,4211,4212,4412,4411,-1,4212,4213,4413,4412,-1,4213,4214,4414,4413,-1,4214,4215,4415,4414,-1,4215,4216,4416,4415,-1,4216,4217,4417,4416,-1,4217,4218,4418,4417,-1,4218,4219,4419,4418,-1,4219,4220,4420,4419,-1,4220,4221,4421,4420,-1,4221,4222,4422,4421,-1,4222,4223,4423,4422,-1,4223,4224,4424,4423,-1,4224,4225,4425,4424,-1,4225,4226,4426,4425,-1,4226,4227,4427,4426,-1,4227,4228,4428,4427,-1,4228,4229,4429,4428,-1,4229,4230,4430,4429,-1,4230,4231,4431,4430,-1,4231,4232,4432,4431,-1,4232,4233,4433,4432,-1,4233,4234,4434,4433,-1,4234,4235,4435,4434,-1,4235,4236,4436,4435,-1,4236,4237,4437,4436,-1,4237,4238,4438,4437,-1,4238,4239,4439,4438,-1,4239,4240,4440,4439,-1,4240,4241,4441,4440,-1,4241,4242,4442,4441,-1,4242,4243,4443,4442,-1,4243,4244,4444,4443,-1,4244,4245,4445,4444,-1,4245,4246,4446,4445,-1,4246,4247,4447,4446,-1,4247,4248,4448,4447,-1,4248,4249,4449,4448,-1,4249,4250,4450,4449,-1,4250,4251,4451,4450,-1,4251,4252,4452,4451,-1,4252,4253,4453,4452,-1,4253,4254,4454,4453,-1,4254,4255,4455,4454,-1,4255,4256,4456,4455,-1,4256,4257,4457,4456,-1,4257,4258,4458,4457,-1,4258,4259,4459,4458,-1,4259,4260,4460,4459,-1,4260,4261,4461,4460,-1,4261,4262,4462,4461,-1,4262,4263,4463,4462,-1,4263,4264,4464,4463,-1,4264,4265,4465,4464,-1,4265,4266,4466,4465,-1,4266,4267,4467,4466,-1,4267,4268,4468,4467,-1,4268,4269,4469,4468,-1,4269,4270,4470,4469,-1,4270,4271,4471,4470,-1,4271,4272,4472,4471,-1,4272,4273,4473,4472,-1,4273,4274,4474,4473,-1,4274,4275,4475,4474,-1,4275,4276,4476,4475,-1,4276,4277,4477,4476,-1,4277,4278,4478,4477,-1,4278,4279,4479,4478,-1,4279,4280,4480,4479,-1,4280,4281,4481,4480,-1,4281,4282,4482,4481,-1,4282,4283,4483,4482,-1,4283,4284,4484,4483,-1,4284,4285,4485,4484,-1,4285,4286,4486,4485,-1,4286,4287,4487,4486,-1,4287,4288,4488,4487,-1,4288,4289,4489,4488,-1,4289,4290,4490,4489,-1,4290,4291,4491,4490,-1,4291,4292,4492,4491,-1,4292,4293,4493,4492,-1,4293,4294,4494,4493,-1,4294,4295,4495,4494,-1,4295,4296,4496,4495,-1,4296,4297,4497,4496,-1,4297,4298,4498,4497,-1,4298,4299,4499,4498,-1,4299,4300,4500,4499,-1,4300,4301,4501,4500,-1,4301,4302,4502,4501,-1,4302,4303,4503,4502,-1,4303,4304,4504,4503,-1,4304,4305,4505,4504,-1,4305,4306,4506,4505,-1,4306,4307,4507,4506,-1,4307,4308,4508,4507,-1,4308,4309,4509,4508,-1,4309,4310,4510,4509,-1,4310,4311,4511,4510,-1,4311,4312,4512,4511,-1,4312,4313,4513,4512,-1,4313,4314,4514,4513,-1,4314,4315,4515,4514,-1,4315,4316,4516,4515,-1,4316,4317,4517,4516,-1,4317,4318,4518,4517,-1,4318,4319,4519,4518,-1,4319,4320,4520,4519,-1,4320,4321,4521,4520,-1,4321,4322,4522,4521,-1,4322,4323,4523,4522,-1,4323,4324,4524,4523,-1,4324,4325,4525,4524,-1,4325,4326,4526,4525,-1,4326,4327,4527,4526,-1,4327,4328,4528,4527,-1,4328,4329,4529,4528,-1,4329,4330,4530,4529,-1,4330,4331,4531,4530,-1,4331,4332,4532,4531,-1,4332,4333,4533,4532,-1,4333,4334,4534,4533,-1,4334,4335,4535,4534,-1,4335,4336,4536,4535,-1,4336,4337,4537,4536,-1,4337,4338,4538,4537,-1,4338,4339,4539,4538,-1,4339,4340,4540,4539,-1,4340,4341,4541,4540,-1,4341,4342,4542,4541,-1,4342,4343,4543,4542,-1,4343,4344,4544,4543,-1,4344,4345,4545,4544,-1,4345,4346,4546,4545,-1,4346,4347,4547,4546,-1,4347,4348,4548,4547,-1,4348,4349,4549,4548,-1,4349,4350,4550,4549,-1,4350,4351,4551,4550,-1,4351,4352,4552,4551,-1,4352,4353,4553,4552,-1,4353,4354,4554,4553,-1,4354,4355,4555,4554,-1,4355,4356,4556,4555,-1,4356,4357,4557,4556,-1,4357,4358,4558,4557,-1,4358,4359,4559,4558,-1,4359,4360,4560,4559,-1,4360,4361,4561,4560,-1,4361,4362,4562,4561,-1,4362,4363,4563,4562,-1,4363,4364,4564,4563,-1,4364,4365,4565,4564,-1,4365,4366,4566,4565,-1,4366,4367,4567,4566,-1,4367,4368,4568,4567,-1,4368,4369,4569,4568,-1,4369,4370,4570,4569,-1,4370,4371,4571,4570,-1,4371,4372,4572,4571,-1,4372,4373,4573,4572,-1,4373,4374,4574,4573,-1,4374,4375,4575,4574,-1,4375,4376,4576,4575,-1,4376,4377,4577,4576,-1,4377,4378,4578,4577,-1,4378,4379,4579,4578,-1,4379,4380,4580,4579,-1,4380,4381,4581,4580,-1,4381,4382,4582,4581,-1,4382,4383,4583,4582,-1,4383,4384,4584,4583,-1,4384,4385,4585,4584,-1,4385,4386,4586,4585,-1,4386,4387,4587,4586,-1,4387,4388,4588,4587,-1,4388,4389,4589,4588,-1,4389,4390,4590,4589,-1,4390,4391,4591,4590,-1,4391,4392,4592,4591,-1,4392,4393,4593,4592,-1,4393,4394,4594,4593,-1,4394,4395,4595,4594,-1,4395,4396,4596,4595,-1,4396,4397,4597,4596,-1,4397,4398,4598,4597,-1,4398,4399,4599,4598,-1,4400,4401,4601,4600,-1,4401,4402,4602,4601,-1,4402,4403,4603,4602,-1,4403,4404,4604,4603,-1,4404,4405,4605,4604,-1,4405,4406,4606,4605,-1,4406,4407,4607,4606,-1,4407,4408,4608,4607,-1,4408,4409,4609,4608,-1,4409,4410,4610,4609,-1,4410,4411,4611,4610,-1,4411,4412,4612,4611,-1,4412,4413,4613,4612,-1,4413,4414,4614,4613,-1,4414,4415,4615,4614,-1,4415,4416,4616,4615,-1,4416,4417,4617,4616,-1,4417,4418,4618,4617,-1,4418,4419,4619,4618,-1,4419,4420,4620,4619,-1,4420,4421,4621,4620,-1,4421,4422,4622,4621,-1,4422,4423,4623,4622,-1,4423,4424,4624,4623,-1,4424,4425,4625,4624,-1,4425,4426,4626,4625,-1,4426,4427,4627,4626,-1,4427,4428,4628,4627,-1,4428,4429,4629,4628,-1,4429,4430,4630,4629,-1,4430,4431,4631,4630,-1,4431,4432,4632,4631,-1,4432,4433,4633,4632,-1,4433,4434,4634,4633,-1,4434,4435,4635,4634,-1,4435,4436,4636,4635,-1,4436,4437,4637,4636,-1,4437,4438,4638,4637,-1,4438,4439,4639,4638,-1,4439,4440,4640,4639,-1,4440,4441,4641,4640,-1,4441,4442,4642,4641,-1,4442,4443,4643,4642,-1,4443,4444,4644,4643,-1,4444,4445,4645,4644,-1,4445,4446,4646,4645,-1,4446,4447,4647,4646,-1,4447,4448,4648,4647,-1,4448,4449,4649,4648,-1,4449,4450,4650,4649,-1,4450,4451,4651,4650,-1,4451,4452,4652,4651,-1,4452,4453,4653,4652,-1,4453,4454,4654,4653,-1,4454,4455,4655,4654,-1,4455,4456,4656,4655,-1,4456,4457,4657,4656,-1,4457,4458,4658,4657,-1,4458,4459,4659,4658,-1,4459,4460,4660,4659,-1,4460,4461,4661,4660,-1,4461,4462,4662,4661,-1,4462,4463,4663,4662,-1,4463,4464,4664,4663,-1,4464,4465,4665,4664,-1,4465,4466,4666,4665,-1,4466,4467,4667,4666,-1,4467,4468,4668,4667,-1,4468,4469,4669,4668,-1,4469,4470,4670,4669,-1,4470,4471,4671,4670,-1,4471,4472,4672,4671,-1,4472,4473,4673,4672,-1,4473,4474,4674,4673,-1,4474,4475,4675,4674,-1,4475,4476,4676,4675,-1,4476,4477,4677,4676,-1,4477,4478,4678,4677,-1,4478,4479,4679,4678,-1,4479,4480,4680,4679,-1,4480,4481,4681,4680,-1,4481,4482,4682,4681,-1,4482,4483,4683,4682,-1,4483,4484,4684,4683,-1,4484,4485,4685,4684,-1,4485,4486,4686,4685,-1,4486,4487,4687,4686,-1,4487,4488,4688,4687,-1,4488,4489,4689,4688,-1,4489,4490,4690,4689,-1,4490,4491,4691,4690,-1,4491,4492,4692,4691,-1,4492,4493,4693,4692,-1,4493,4494,4694,4693,-1,4494,4495,4695,4694,-1,4495,4496,4696,4695,-1,4496,4497,4697,4696,-1,4497,4498,4698,4697,-1,4498,4499,4699,4698,-1,4499,4500,4700,4699,-1,4500,4501,4701,4700,-1,4501,4502,4702,4701,-1,4502,4503,4703,4702,-1,4503,4504,4704,4703,-1,4504,4505,4705,4704,-1,4505,4506,4706,4705,-1,4506,4507,4707,4706,-1,4507,4508,4708,4707,-1,4508,4509,4709,4708,-1,4509,4510,4710,4709,-1,4510,4511,4711,4710,-1,4511,4512,4712,4711,-1,4512,4513,4713,4712,-1,4513,4514,4714,4713,-1,4514,4515,4715,4714,-1,4515,4516,4716,4715,-1,4516,4517,4717,4716,-1,4517,4518,4718,4717,-1,4518,4519,4719,4718,-1,4519,4520,4720,4719,-1,4520,4521,4721,4720,-1,4521,4522,4722,4721,-1,4522,4523,4723,4722,-1,4523,4524,4724,4723,-1,4524,4525,4725,4724,-1,4525,4526,4726,4725,-1,4526,4527,4727,4726,-1,4527,4528,4728,4727,-1,4528,4529,4729,4728,-1,4529,4530,4730,4729,-1,4530,4531,4731,4730,-1,4531,4532,4732,4731,-1,4532,4533,4733,4732,-1,4533,4534,4734,4733,-1,4534,4535,4735,4734,-1,4535,4536,4736,4735,-1,4536,4537,4737,4736,-1,4537,4538,4738,4737,-1,4538,4539,4739,4738,-1,4539,4540,4740,4739,-1,4540,4541,4741,4740,-1,4541,4542,4742,4741,-1,4542,4543,4743,4742,-1,4543,4544,4744,4743,-1,4544,4545,4745,4744,-1,4545,4546,4746,4745,-1,4546,4547,4747,4746,-1,4547,4548,4748,4747,-1,4548,4549,4749,4748,-1,4549,4550,4750,4749,-1,4550,4551,4751,4750,-1,4551,4552,4752,4751,-1,4552,4553,4753,4752,-1,4553,4554,4754,4753,-1,4554,4555,4755,4754,-1,4555,4556,4756,4755,-1,4556,4557,4757,4756,-1,4557,4558,4758,4757,-1,4558,4559,4759,4758,-1,4559,4560,4760,4759,-1,4560,4561,4761,4760,-1,4561,4562,4762,4761,-1,4562,4563,4763,4762,-1,4563,4564,4764,4763,-1,4564,4565,4765,4764,-1,4565,4566,4766,4765,-1,4566,4567,4767,4766,-1,4567,4568,4768,4767,-1,4568,4569,4769,4768,-1,4569,4570,4770,4769,-1,4570,4571,4771,4770,-1,4571,4572,4772,4771,-1,4572,4573,4773,4772,-1,4573,4574,4774,4773,-1,4574,4575,4775,4774,-1,4575,4576,4776,4775,-1,4576,4577,4777,4776,-1,4577,4578,4778,4777,-1,4578,4579,4779,4778,-1,4579,4580,4780,4779,-1,4580,4581,4781,4780,-1,4581,4582,4782,4781,-1,4582,4583,4783,4782,-1,4583,4584,4784,4783,-1,4584,4585,4785,4784,-1,4585,4586,4786,4785,-1,4586,4587,4787,4786,-1,4587,4588,4788,4787,-1,4588,4589,4789,4788,-1,4589,4590,4790,4789,-1,4590,4591,4791,4790,-1,4591,4592,4792,4791,-1,4592,4593,4793,4792,-1,4593,4594,4794,4793,-1,4594,4595,4795,4794,-1,4595,4596,4796,4795,-1,4596,4597,4797,4796,-1,4597,4598,4798,4797,-1,4598,4599,4799,4798,-1,4600,4601,4801,4800,-1,4601,4602,4802,4801,-1,4602,4603,4803,4802,-1,4603,4604,4804,4803,-1,4604,4605,4805,4804,-1,4605,4606,4806,4805,-1,4606,4607,4807,4806,-1,4607,4608,4808,4807,-1,4608,4609,4809,4808,-1,4609,4610,4810,4809,-1,4610,4611,4811,4810,-1,4611,4612,4812,4811,-1,4612,4613,4813,4812,-1,4613,4614,4814,4813,-1,4614,4615,4815,4814,-1,4615,4616,4816,4815,-1,4616,4617,4817,4816,-1,4617,4618,4818,4817,-1,4618,4619,4819,4818,-1,4619,4620,4820,4819,-1,4620,4621,4821,4820,-1,4621,4622,4822,4821,-1,4622,4623,4823,4822,-1,4623,4624,4824,4823,-1,4624,4625,4825,4824,-1,4625,4626,4826,4825,-1,4626,4627,4827,4826,-1,4627,4628,4828,4827,-1,4628,4629,4829,4828,-1,4629,4630,4830,4829,-1,4630,4631,4831,4830,-1,4631,4632,4832,4831,-1,4632,4633,4833,4832,-1,4633,4634,4834,4833,-1,4634,4635,4835,4834,-1,4635,4636,4836,4835,-1,4636,4637,4837,4836,-1,4637,4638,4838,4837,-1,4638,4639,4839,4838,-1,4639,4640,4840,4839,-1,4640,4641,4841,4840,-1,4641,4642,4842,4841,-1,4642,4643,4843,4842,-1,4643,4644,4844,4843,-1,4644,4645,4845,4844,-1,4645,4646,4846,4845,-1,4646,4647,4847,4846,-1,4647,4648,4848,4847,-1,4648,4649,4849,4848,-1,4649,4650,4850,4849,-1,4650,4651,4851,4850,-1,4651,4652,4852,4851,-1,4652,4653,4853,4852,-1,4653,4654,4854,4853,-1,4654,4655,4855,4854,-1,4655,4656,4856,4855,-1,4656,4657,4857,4856,-1,4657,4658,4858,4857,-1,4658,4659,4859,4858,-1,4659,4660,4860,4859,-1,4660,4661,4861,4860,-1,4661,4662,4862,4861,-1,4662,4663,4863,4862,-1,4663,4664,4864,4863,-1,4664,4665,4865,4864,-1,4665,4666,4866,4865,-1,4666,4667,4867,4866,-1,4667,4668,4868,4867,-1,4668,4669,4869,4868,-1,4669,4670,4870,4869,-1,4670,4671,4871,4870,-1,4671,4672,4872,4871,-1,4672,4673,4873,4872,-1,4673,4674,4874,4873,-1,4674,4675,4875,4874,-1,4675,4676,4876,4875,-1,4676,4677,4877,4876,-1,4677,4678,4878,4877,-1,4678,4679,4879,4878,-1,4679,4680,4880,4879,-1,4680,4681,4881,4880,-1,4681,4682,4882,4881,-1,4682,4683,4883,4882,-1,4683,4684,4884,4883,-1,4684,4685,4885,4884,-1,4685,4686,4886,4885,-1,4686,4687,4887,4886,-1,4687,4688,4888,4887,-1,4688,4689,4889,4888,-1,4689,4690,4890,4889,-1,4690,4691,4891,4890,-1,4691,4692,4892,4891,-1,4692,4693,4893,4892,-1,4693,4694,4894,4893,-1,4694,4695,4895,4894,-1,4695,4696,4896,4895,-1,4696,4697,4897,4896,-1,4697,4698,4898,4897,-1,4698,4699,4899,4898,-1,4699,4700,4900,4899,-1,4700,4701,4901,4900,-1,4701,4702,4902,4901,-1,4702,4703,4903,4902,-1,4703,4704,4904,4903,-1,4704,4705,4905,4904,-1,4705,4706,4906,4905,-1,4706,4707,4907,4906,-1,4707,4708,4908,4907,-1,4708,4709,4909,4908,-1,4709,4710,4910,4909,-1,4710,4711,4911,4910,-1,4711,4712,4912,4911,-1,4712,4713,4913,4912,-1,4713,4714,4914,4913,-1,4714,4715,4915,4914,-1,4715,4716,4916,4915,-1,4716,4717,4917,4916,-1,4717,4718,4918,4917,-1,4718,4719,4919,4918,-1,4719,4720,4920,4919,-1,4720,4721,4921,4920,-1,4721,4722,4922,4921,-1,4722,4723,4923,4922,-1,4723,4724,4924,4923,-1,4724,4725,4925,4924,-1,4725,4726,4926,4925,-1,4726,4727,4927,4926,-1,4727,4728,4928,4927,-1,4728,4729,4929,4928,-1,4729,4730,4930,4929,-1,4730,4731,4931,4930,-1,4731,4732,4932,4931,-1,4732,4733,4933,4932,-1,4733,4734,4934,4933,-1,4734,4735,4935,4934,-1,4735,4736,4936,4935,-1,4736,4737,4937,4936,-1,4737,4738,4938,4937,-1,4738,4739,4939,4938,-1,4739,4740,4940,4939,-1,4740,4741,4941,4940,-1,4741,4742,4942,4941,-1,4742,4743,4943,4942,-1,4743,4744,4944,4943,-1,4744,4745,4945,4944,-1,4745,4746,4946,4945,-1,4746,4747,4947,4946,-1,4747,4748,4948,4947,-1,4748,4749,4949,4948,-1,4749,4750,4950,4949,-1,4750,4751,4951,4950,-1,4751,4752,4952,4951,-1,4752,4753,4953,4952,-1,4753,4754,4954,4953,-1,4754,4755,4955,4954,-1,4755,4756,4956,4955,-1,4756,4757,4957,4956,-1,4757,4758,4958,4957,-1,4758,4759,4959,4958,-1,4759,4760,4960,4959,-1,4760,4761,4961,4960,-1,4761,4762,4962,4961,-1,4762,4763,4963,4962,-1,4763,4764,4964,4963,-1,4764,4765,4965,4964,-1,4765,4766,4966,4965,-1,4766,4767,4967,4966,-1,4767,4768,4968,4967,-1,4768,4769,4969,4968,-1,4769,4770,4970,4969,-1,4770,4771,4971,4970,-1,4771,4772,4972,4971,-1,4772,4773,4973,4972,-1,4773,4774,4974,4973,-1,4774,4775,4975,4974,-1,4775,4776,4976,4975,-1,4776,4777,4977,4976,-1,4777,4778,4978,4977,-1,4778,4779,4979,4978,-1,4779,4780,4980,4979,-1,4780,4781,4981,4980,-1,4781,4782,4982,4981,-1,4782,4783,4983,4982,-1,4783,4784,4984,4983,-1,4784,4785,4985,4984,-1,4785,4786,4986,4985,-1,4786,4787,4987,4986,-1,4787,4788,4988,4987,-1,4788,4789,4989,4988,-1,4789,4790,4990,4989,-1,4790,4791,4991,4990,-1,4791,4792,4992,4991,-1,4792,4793,4993,4992,-1,4793,4794,4994,4993,-1,4794,4795,4995,4994,-1,4795,4796,4996,4995,-1,4796,4797,4997,4996,-1,4797,4798,4998,4997,-1,4798,4799,4999,4998,-1,4800,4801,5001,5,-1,4801,4802,5002,5001,-1,4802,4803,5003,5002,-1,4803,4804,5004,5003,-1,4804,4805,5005,5004,-1,4805,4806,5006,5005,-1,4806,4807,5007,5006,-1,4807,4808,5008,5007,-1,4808,4809,5009,5008,-1,4809,4810,5010,5009,-1,4810,4811,5011,5010,-1,4811,4812,5012,5011,-1,4812,4813,5013,5012,-1,4813,4814,5014,5013,-1,4814,4815,5015,5014,-1,4815,4816,5016,5015,-1,4816,4817,5017,5016,-1,4817,4818,5018,5017,-1,4818,4819,5019,5018,-1,4819,4820,5020,5019,-1,4820,4821,5021,5020,-1,4821,4822,5022,5021,-1,4822,4823,5023,5022,-1,4823,4824,5024,5023,-1,4824,4825,5025,5024,-1,4825,4826,5026,5025,-1,4826,4827,5027,5026,-1,4827,4828,5028,5027,-1,4828,4829,5029,5028,-1,4829,4830,5030,5029,-1,4830,4831,5031,5030,-1,4831,4832,5032,5031,-1,4832,4833,5033,5032,-1,4833,4834,5034,5033,-1,4834,4835,5035,5034,-1,4835,4836,5036,5035,-1,4836,4837,5037,5036,-1,4837,4838,5038,5037,-1,4838,4839,5039,5038,-1,4839,4840,5040,5039,-1,4840,4841,5041,5040,-1,4841,4842,5042,5041,-1,4842,4843,5043,5042,-1,4843,4844,5044,5043,-1,4844,4845,5045,5044,-1,4845,4846,5046,5045,-1,4846,4847,5047,5046,-1,4847,4848,5048,5047,-1,4848,4849,5049,5048,-1,4849,4850,5050,5049,-1,4850,4851,5051,5050,-1,4851,4852,5052,5051,-1,4852,4853,5053,5052,-1,4853,4854,5054,5053,-1,4854,4855,5055,5054,-1,4855,4856,5056,5055,-1,4856,4857,5057,5056,-1,4857,4858,5058,5057,-1,4858,4859,5059,5058,-1,4859,4860,5060,5059,-1,4860,4861,5061,5060,-1,4861,4862,5062,5061,-1,4862,4863,5063,5062,-1,4863,4864,5064,5063,-1,4864,4865,5065,5064,-1,4865,4866,5066,5065,-1,4866,4867,5067,5066,-1,4867,4868,5068,5067,-1,4868,4869,5069,5068,-1,4869,4870,5070,5069,-1,4870,4871,5071,5070,-1,4871,4872,5072,5071,-1,4872,4873,5073,5072,-1,4873,4874,5074,5073,-1,4874,4875,5075,5074,-1,4875,4876,5076,5075,-1,4876,4877,5077,5076,-1,4877,4878,5078,5077,-1,4878,4879,5079,5078,-1,4879,4880,5080,5079,-1,4880,4881,5081,5080,-1,4881,4882,5082,5081,-1,4882,4883,5083,5082,-1,4883,4884,5084,5083,-1,4884,4885,5085,5084,-1,4885,4886,5086,5085,-1,4886,4887,5087,5086,-1,4887,4888,5088,5087,-1,4888,4889,5089,5088,-1,4889,4890,5090,5089,-1,4890,4891,5091,5090,-1,4891,4892,5092,5091,-1,4892,4893,5093,5092,-1,4893,4894,5094,5093,-1,4894,4895,5095,5094,-1,4895,4896,5096,5095,-1,4896,4897,5097,5096,-1,4897,4898,5098,5097,-1,4898,4899,5099,5098,-1,4899,4900,5100,5099,-1,4900,4901,5101,5100,-1,4901,4902,5102,5101,-1,4902,4903,5103,5102,-1,4903,4904,5104,5103,-1,4904,4905,5105,5104,-1,4905,4906,5106,5105,-1,4906,4907,5107,5106,-1,4907,4908,5108,5107,-1,4908,4909,5109,5108,-1,4909,4910,5110,5109,-1,4910,4911,5111,5110,-1,4911,4912,5112,5111,-1,4912,4913,5113,5112,-1,4913,4914,5114,5113,-1,4914,4915,5115,5114,-1,4915,4916,5116,5115,-1,4916,4917,5117,5116,-1,4917,4918,5118,5117,-1,4918,4919,5119,5118,-1,4919,4920,5120,5119,-1,4920,4921,5121,5120,-1,4921,4922,5122,5121,-1,4922,4923,5123,5122,-1,4923,4924,5124,5123,-1,4924,4925,5125,5124,-1,4925,4926,5126,5125,-1,4926,4927,5127,5126,-1,4927,4928,5128,5127,-1,4928,4929,5129,5128,-1,4929,4930,5130,5129,-1,4930,4931,5131,5130,-1,4931,4932,5132,5131,-1,4932,4933,5133,5132,-1,4933,4934,5134,5133,-1,4934,4935,5135,5134,-1,4935,4936,5136,5135,-1,4936,4937,5137,5136,-1,4937,4938,5138,5137,-1,4938,4939,5139,5138,-1,4939,4940,5140,5139,-1,4940,4941,5141,5140,-1,4941,4942,5142,5141,-1,4942,4943,5143,5142,-1,4943,4944,5144,5143,-1,4944,4945,5145,5144,-1,4945,4946,5146,5145,-1,4946,4947,5147,5146,-1,4947,4948,5148,5147,-1,4948,4949,5149,5148,-1,4949,4950,5150,5149,-1,4950,4951,5151,5150,-1,4951,4952,5152,5151,-1,4952,4953,5153,5152,-1,4953,4954,5154,5153,-1,4954,4955,5155,5154,-1,4955,4956,5156,5155,-1,4956,4957,5157,5156,-1,4957,4958,5158,5157,-1,4958,4959,5159,5158,-1,4959,4960,5160,5159,-1,4960,4961,5161,5160,-1,4961,4962,5162,5161,-1,4962,4963,5163,5162,-1,4963,4964,5164,5163,-1,4964,4965,5165,5164,-1,4965,4966,5166,5165,-1,4966,4967,5167,5166,-1,4967,4968,5168,5167,-1,4968,4969,5169,5168,-1,4969,4970,5170,5169,-1,4970,4971,5171,5170,-1,4971,4972,5172,5171,-1,4972,4973,5173,5172,-1,4973,4974,5174,5173,-1,4974,4975,5175,5174,-1,4975,4976,5176,5175,-1,4976,4977,5177,5176,-1,4977,4978,5178,5177,-1,4978,4979,5179,5178,-1,4979,4980,5180,5179,-1,4980,4981,5181,5180,-1,4981,4982,5182,5181,-1,4982,4983,5183,5182,-1,4983,4984,5184,5183,-1,4984,4985,5185,5184,-1,4985,4986,5186,5185,-1,4986,4987,5187,5186,-1,4987,4988,5188,5187,-1,4988,4989,5189,5188,-1,4989,4990,5190,5189,-1,4990,4991,5191,5190,-1,4991,4992,5192,5191,-1,4992,4993,5193,5192,-1,4993,4994,5194,5193,-1,4994,4995,5195,5194,-1,4995,4996,5196,5195,-1,4996,4997,5197,5196,-1,4997,4998,5198,5197,-1,4998,4999,5199,5198,-1,5,5001,5201,5200,-1,5001,5002,5202,5201,-1,5002,5003,5203,5202,-1,5003,5004,5204,5203,-1,5004,5005,5205,5204,-1,5005,5006,5206,5205,-1,5006,5007,5207,5206,-1,5007,5008,5208,5207,-1,5008,5009,5209,5208,-1,5009,5010,5210,5209,-1,5010,5011,5211,5210,-1,5011,5012,5212,5211,-1,5012,5013,5213,5212,-1,5013,5014,5214,5213,-1,5014,5015,5215,5214,-1,5015,5016,5216,5215,-1,5016,5017,5217,5216,-1,5017,5018,5218,5217,-1,5018,5019,5219,5218,-1,5019,5020,5220,5219,-1,5020,5021,5221,5220,-1,5021,5022,5222,5221,-1,5022,5023,5223,5222,-1,5023,5024,5224,5223,-1,5024,5025,5225,5224,-1,5025,5026,5226,5225,-1,5026,5027,5227,5226,-1,5027,5028,5228,5227,-1,5028,5029,5229,5228,-1,5029,5030,5230,5229,-1,5030,5031,5231,5230,-1,5031,5032,5232,5231,-1,5032,5033,5233,5232,-1,5033,5034,5234,5233,-1,5034,5035,5235,5234,-1,5035,5036,5236,5235,-1,5036,5037,5237,5236,-1,5037,5038,5238,5237,-1,5038,5039,5239,5238,-1,5039,5040,5240,5239,-1,5040,5041,5241,5240,-1,5041,5042,5242,5241,-1,5042,5043,5243,5242,-1,5043,5044,5244,5243,-1,5044,5045,5245,5244,-1,5045,5046,5246,5245,-1,5046,5047,5247,5246,-1,5047,5048,5248,5247,-1,5048,5049,5249,5248,-1,5049,5050,5250,5249,-1,5050,5051,5251,5250,-1,5051,5052,5252,5251,-1,5052,5053,5253,5252,-1,5053,5054,5254,5253,-1,5054,5055,5255,5254,-1,5055,5056,5256,5255,-1,5056,5057,5257,5256,-1,5057,5058,5258,5257,-1,5058,5059,5259,5258,-1,5059,5060,5260,5259,-1,5060,5061,5261,5260,-1,5061,5062,5262,5261,-1,5062,5063,5263,5262,-1,5063,5064,5264,5263,-1,5064,5065,5265,5264,-1,5065,5066,5266,5265,-1,5066,5067,5267,5266,-1,5067,5068,5268,5267,-1,5068,5069,5269,5268,-1,5069,5070,5270,5269,-1,5070,5071,5271,5270,-1,5071,5072,5272,5271,-1,5072,5073,5273,5272,-1,5073,5074,5274,5273,-1,5074,5075,5275,5274,-1,5075,5076,5276,5275,-1,5076,5077,5277,5276,-1,5077,5078,5278,5277,-1,5078,5079,5279,5278,-1,5079,5080,5280,5279,-1,5080,5081,5281,5280,-1,5081,5082,5282,5281,-1,5082,5083,5283,5282,-1,5083,5084,5284,5283,-1,5084,5085,5285,5284,-1,5085,5086,5286,5285,-1,5086,5087,5287,5286,-1,5087,5088,5288,5287,-1,5088,5089,5289,5288,-1,5089,5090,5290,5289,-1,5090,5091,5291,5290,-1,5091,5092,5292,5291,-1,5092,5093,5293,5292,-1,5093,5094,5294,5293,-1,5094,5095,5295,5294,-1,5095,5096,5296,5295,-1,5096,5097,5297,5296,-1,5097,5098,5298,5297,-1,5098,5099,5299,5298,-1,5099,5100,5300,5299,-1,5100,5101,5301,5300,-1,5101,5102,5302,5301,-1,5102,5103,5303,5302,-1,5103,5104,5304,5303,-1,5104,5105,5305,5304,-1,5105,5106,5306,5305,-1,5106,5107,5307,5306,-1,5107,5108,5308,5307,-1,5108,5109,5309,5308,-1,5109,5110,5310,5309,-1,5110,5111,5311,5310,-1,5111,5112,5312,5311,-1,5112,5113,5313,5312,-1,5113,5114,5314,5313,-1,5114,5115,5315,5314,-1,5115,5116,5316,5315,-1,5116,5117,5317,5316,-1,5117,5118,5318,5317,-1,5118,5119,5319,5318,-1,5119,5120,5320,5319,-1,5120,5121,5321,5320,-1,5121,5122,5322,5321,-1,5122,5123,5323,5322,-1,5123,5124,5324,5323,-1,5124,5125,5325,5324,-1,5125,5126,5326,5325,-1,5126,5127,5327,5326,-1,5127,5128,5328,5327,-1,5128,5129,5329,5328,-1,5129,5130,5330,5329,-1,5130,5131,5331,5330,-1,5131,5132,5332,5331,-1,5132,5133,5333,5332,-1,5133,5134,5334,5333,-1,5134,5135,5335,5334,-1,5135,5136,5336,5335,-1,5136,5137,5337,5336,-1,5137,5138,5338,5337,-1,5138,5139,5339,5338,-1,5139,5140,5340,5339,-1,5140,5141,5341,5340,-1,5141,5142,5342,5341,-1,5142,5143,5343,5342,-1,5143,5144,5344,5343,-1,5144,5145,5345,5344,-1,5145,5146,5346,5345,-1,5146,5147,5347,5346,-1,5147,5148,5348,5347,-1,5148,5149,5349,5348,-1,5149,5150,5350,5349,-1,5150,5151,5351,5350,-1,5151,5152,5352,5351,-1,5152,5153,5353,5352,-1,5153,5154,5354,5353,-1,5154,5155,5355,5354,-1,5155,5156,5356,5355,-1,5156,5157,5357,5356,-1,5157,5158,5358,5357,-1,5158,5159,5359,5358,-1,5159,5160,5360,5359,-1,5160,5161,5361,5360,-1,5161,5162,5362,5361,-1,5162,5163,5363,5362,-1,5163,5164,5364,5363,-1,5164,5165,5365,5364,-1,5165,5166,5366,5365,-1,5166,5167,5367,5366,-1,5167,5168,5368,5367,-1,5168,5169,5369,5368,-1,5169,5170,5370,5369,-1,5170,5171,5371,5370,-1,5171,5172,5372,5371,-1,5172,5173,5373,5372,-1,5173,5174,5374,5373,-1,5174,5175,5375,5374,-1,5175,5176,5376,5375,-1,5176,5177,5377,5376,-1,5177,5178,5378,5377,-1,5178,5179,5379,5378,-1,5179,5180,5380,5379,-1,5180,5181,5381,5380,-1,5181,5182,5382,5381,-1,5182,5183,5383,5382,-1,5183,5184,5384,5383,-1,5184,5185,5385,5384,-1,5185,5186,5386,5385,-1,5186,5187,5387,5386,-1,5187,5188,5388,5387,-1,5188,5189,5389,5388,-1,5189,5190,5390,5389,-1,5190,5191,5391,5390,-1,5191,5192,5392,5391,-1,5192,5193,5393,5392,-1,5193,5194,5394,5393,-1,5194,5195,5395,5394,-1,5195,5196,5396,5395,-1,5196,5197,5397,5396,-1,5197,5198,5398,5397,-1,5198,5199,5399,5398,-1,5200,5201,5401,5400,-1,5201,5202,5402,5401,-1,5202,5203,5403,5402,-1,5203,5204,5404,5403,-1,5204,5205,5405,5404,-1,5205,5206,5406,5405,-1,5206,5207,5407,5406,-1,5207,5208,5408,5407,-1,5208,5209,5409,5408,-1,5209,5210,5410,5409,-1,5210,5211,5411,5410,-1,5211,5212,5412,5411,-1,5212,5213,5413,5412,-1,5213,5214,5414,5413,-1,5214,5215,5415,5414,-1,5215,5216,5416,5415,-1,5216,5217,5417,5416,-1,5217,5218,5418,5417,-1,5218,5219,5419,5418,-1,5219,5220,5420,5419,-1,5220,5221,5421,5420,-1,5221,5222,5422,5421,-1,5222,5223,5423,5422,-1,5223,5224,5424,5423,-1,5224,5225,5425,5424,-1,5225,5226,5426,5425,-1,5226,5227,5427,5426,-1,5227,5228,5428,5427,-1,5228,5229,5429,5428,-1,5229,5230,5430,5429,-1,5230,5231,5431,5430,-1,5231,5232,5432,5431,-1,5232,5233,5433,5432,-1,5233,5234,5434,5433,-1,5234,5235,5435,5434,-1,5235,5236,5436,5435,-1,5236,5237,5437,5436,-1,5237,5238,5438,5437,-1,5238,5239,5439,5438,-1,5239,5240,5440,5439,-1,5240,5241,5441,5440,-1,5241,5242,5442,5441,-1,5242,5243,5443,5442,-1,5243,5244,5444,5443,-1,5244,5245,5445,5444,-1,5245,5246,5446,5445,-1,5246,5247,5447,5446,-1,5247,5248,5448,5447,-1,5248,5249,5449,5448,-1,5249,5250,5450,5449,-1,5250,5251,5451,5450,-1,5251,5252,5452,5451,-1,5252,5253,5453,5452,-1,5253,5254,5454,5453,-1,5254,5255,5455,5454,-1,5255,5256,5456,5455,-1,5256,5257,5457,5456,-1,5257,5258,5458,5457,-1,5258,5259,5459,5458,-1,5259,5260,5460,5459,-1,5260,5261,5461,5460,-1,5261,5262,5462,5461,-1,5262,5263,5463,5462,-1,5263,5264,5464,5463,-1,5264,5265,5465,5464,-1,5265,5266,5466,5465,-1,5266,5267,5467,5466,-1,5267,5268,5468,5467,-1,5268,5269,5469,5468,-1,5269,5270,5470,5469,-1,5270,5271,5471,5470,-1,5271,5272,5472,5471,-1,5272,5273,5473,5472,-1,5273,5274,5474,5473,-1,5274,5275,5475,5474,-1,5275,5276,5476,5475,-1,5276,5277,5477,5476,-1,5277,5278,5478,5477,-1,5278,5279,5479,5478,-1,5279,5280,5480,5479,-1,5280,5281,5481,5480,-1,5281,5282,5482,5481,-1,5282,5283,5483,5482,-1,5283,5284,5484,5483,-1,5284,5285,5485,5484,-1,5285,5286,5486,5485,-1,5286,5287,5487,5486,-1,5287,5288,5488,5487,-1,5288,5289,5489,5488,-1,5289,5290,5490,5489,-1,5290,5291,5491,5490,-1,5291,5292,5492,5491,-1,5292,5293,5493,5492,-1,5293,5294,5494,5493,-1,5294,5295,5495,5494,-1,5295,5296,5496,5495,-1,5296,5297,5497,5496,-1,5297,5298,5498,5497,-1,5298,5299,5499,5498,-1,5299,5300,5500,5499,-1,5300,5301,5501,5500,-1,5301,5302,5502,5501,-1,5302,5303,5503,5502,-1,5303,5304,5504,5503,-1,5304,5305,5505,5504,-1,5305,5306,5506,5505,-1,5306,5307,5507,5506,-1,5307,5308,5508,5507,-1,5308,5309,5509,5508,-1,5309,5310,5510,5509,-1,5310,5311,5511,5510,-1,5311,5312,5512,5511,-1,5312,5313,5513,5512,-1,5313,5314,5514,5513,-1,5314,5315,5515,5514,-1,5315,5316,5516,5515,-1,5316,5317,5517,5516,-1,5317,5318,5518,5517,-1,5318,5319,5519,5518,-1,5319,5320,5520,5519,-1,5320,5321,5521,5520,-1,5321,5322,5522,5521,-1,5322,5323,5523,5522,-1,5323,5324,5524,5523,-1,5324,5325,5525,5524,-1,5325,5326,5526,5525,-1,5326,5327,5527,5526,-1,5327,5328,5528,5527,-1,5328,5329,5529,5528,-1,5329,5330,5530,5529,-1,5330,5331,5531,5530,-1,5331,5332,5532,5531,-1,5332,5333,5533,5532,-1,5333,5334,5534,5533,-1,5334,5335,5535,5534,-1,5335,5336,5536,5535,-1,5336,5337,5537,5536,-1,5337,5338,5538,5537,-1,5338,5339,5539,5538,-1,5339,5340,5540,5539,-1,5340,5341,5541,5540,-1,5341,5342,5542,5541,-1,5342,5343,5543,5542,-1,5343,5344,5544,5543,-1,5344,5345,5545,5544,-1,5345,5346,5546,5545,-1,5346,5347,5547,5546,-1,5347,5348,5548,5547,-1,5348,5349,5549,5548,-1,5349,5350,5550,5549,-1,5350,5351,5551,5550,-1,5351,5352,5552,5551,-1,5352,5353,5553,5552,-1,5353,5354,5554,5553,-1,5354,5355,5555,5554,-1,5355,5356,5556,5555,-1,5356,5357,5557,5556,-1,5357,5358,5558,5557,-1,5358,5359,5559,5558,-1,5359,5360,5560,5559,-1,5360,5361,5561,5560,-1,5361,5362,5562,5561,-1,5362,5363,5563,5562,-1,5363,5364,5564,5563,-1,5364,5365,5565,5564,-1,5365,5366,5566,5565,-1,5366,5367,5567,5566,-1,5367,5368,5568,5567,-1,5368,5369,5569,5568,-1,5369,5370,5570,5569,-1,5370,5371,5571,5570,-1,5371,5372,5572,5571,-1,5372,5373,5573,5572,-1,5373,5374,5574,5573,-1,5374,5375,5575,5574,-1,5375,5376,5576,5575,-1,5376,5377,5577,5576,-1,5377,5378,5578,5577,-1,5378,5379,5579,5578,-1,5379,5380,5580,5579,-1,5380,5381,5581,5580,-1,5381,5382,5582,5581,-1,5382,5383,5583,5582,-1,5383,5384,5584,5583,-1,5384,5385,5585,5584,-1,5385,5386,5586,5585,-1,5386,5387,5587,5586,-1,5387,5388,5588,5587,-1,5388,5389,5589,5588,-1,5389,5390,5590,5589,-1,5390,5391,5591,5590,-1,5391,5392,5592,5591,-1,5392,5393,5593,5592,-1,5393,5394,5594,5593,-1,5394,5395,5595,5594,-1,5395,5396,5596,5595,-1,5396,5397,5597,5596,-1,5397,5398,5598,5597,-1,5398,5399,5599,5598,-1,5400,5401,5601,5600,-1,5401,5402,5602,5601,-1,5402,5403,5603,5602,-1,5403,5404,5604,5603,-1,5404,5405,5605,5604,-1,5405,5406,5606,5605,-1,5406,5407,5607,5606,-1,5407,5408,5608,5607,-1,5408,5409,5609,5608,-1,5409,5410,5610,5609,-1,5410,5411,5611,5610,-1,5411,5412,5612,5611,-1,5412,5413,5613,5612,-1,5413,5414,5614,5613,-1,5414,5415,5615,5614,-1,5415,5416,5616,5615,-1,5416,5417,5617,5616,-1,5417,5418,5618,5617,-1,5418,5419,5619,5618,-1,5419,5420,5620,5619,-1,5420,5421,5621,5620,-1,5421,5422,5622,5621,-1,5422,5423,5623,5622,-1,5423,5424,5624,5623,-1,5424,5425,5625,5624,-1,5425,5426,5626,5625,-1,5426,5427,5627,5626,-1,5427,5428,5628,5627,-1,5428,5429,5629,5628,-1,5429,5430,5630,5629,-1,5430,5431,5631,5630,-1,5431,5432,5632,5631,-1,5432,5433,5633,5632,-1,5433,5434,5634,5633,-1,5434,5435,5635,5634,-1,5435,5436,5636,5635,-1,5436,5437,5637,5636,-1,5437,5438,5638,5637,-1,5438,5439,5639,5638,-1,5439,5440,5640,5639,-1,5440,5441,5641,5640,-1,5441,5442,5642,5641,-1,5442,5443,5643,5642,-1,5443,5444,5644,5643,-1,5444,5445,5645,5644,-1,5445,5446,5646,5645,-1,5446,5447,5647,5646,-1,5447,5448,5648,5647,-1,5448,5449,5649,5648,-1,5449,5450,5650,5649,-1,5450,5451,5651,5650,-1,5451,5452,5652,5651,-1,5452,5453,5653,5652,-1,5453,5454,5654,5653,-1,5454,5455,5655,5654,-1,5455,5456,5656,5655,-1,5456,5457,5657,5656,-1,5457,5458,5658,5657,-1,5458,5459,5659,5658,-1,5459,5460,5660,5659,-1,5460,5461,5661,5660,-1,5461,5462,5662,5661,-1,5462,5463,5663,5662,-1,5463,5464,5664,5663,-1,5464,5465,5665,5664,-1,5465,5466,5666,5665,-1,5466,5467,5667,5666,-1,5467,5468,5668,5667,-1,5468,5469,5669,5668,-1,5469,5470,5670,5669,-1,5470,5471,5671,5670,-1,5471,5472,5672,5671,-1,5472,5473,5673,5672,-1,5473,5474,5674,5673,-1,5474,5475,5675,5674,-1,5475,5476,5676,5675,-1,5476,5477,5677,5676,-1,5477,5478,5678,5677,-1,5478,5479,5679,5678,-1,5479,5480,5680,5679,-1,5480,5481,5681,5680,-1,5481,5482,5682,5681,-1,5482,5483,5683,5682,-1,5483,5484,5684,5683,-1,5484,5485,5685,5684,-1,5485,5486,5686,5685,-1,5486,5487,5687,5686,-1,5487,5488,5688,5687,-1,5488,5489,5689,5688,-1,5489,5490,5690,5689,-1,5490,5491,5691,5690,-1,5491,5492,5692,5691,-1,5492,5493,5693,5692,-1,5493,5494,5694,5693,-1,5494,5495,5695,5694,-1,5495,5496,5696,5695,-1,5496,5497,5697,5696,-1,5497,5498,5698,5697,-1,5498,5499,5699,5698,-1,5499,5500,5700,5699,-1,5500,5501,5701,5700,-1,5501,5502,5702,5701,-1,5502,5503,5703,5702,-1,5503,5504,5704,5703,-1,5504,5505,5705,5704,-1,5505,5506,5706,5705,-1,5506,5507,5707,5706,-1,5507,5508,5708,5707,-1,5508,5509,5709,5708,-1,5509,5510,5710,5709,-1,5510,5511,5711,5710,-1,5511,5512,5712,5711,-1,5512,5513,5713,5712,-1,5513,5514,5714,5713,-1,5514,5515,5715,5714,-1,5515,5516,5716,5715,-1,5516,5517,5717,5716,-1,5517,5518,5718,5717,-1,5518,5519,5719,5718,-1,5519,5520,5720,5719,-1,5520,5521,5721,5720,-1,5521,5522,5722,5721,-1,5522,5523,5723,5722,-1,5523,5524,5724,5723,-1,5524,5525,5725,5724,-1,5525,5526,5726,5725,-1,5526,5527,5727,5726,-1,5527,5528,5728,5727,-1,5528,5529,5729,5728,-1,5529,5530,5730,5729,-1,5530,5531,5731,5730,-1,5531,5532,5732,5731,-1,5532,5533,5733,5732,-1,5533,5534,5734,5733,-1,5534,5535,5735,5734,-1,5535,5536,5736,5735,-1,5536,5537,5737,5736,-1,5537,5538,5738,5737,-1,5538,5539,5739,5738,-1,5539,5540,5740,5739,-1,5540,5541,5741,5740,-1,5541,5542,5742,5741,-1,5542,5543,5743,5742,-1,5543,5544,5744,5743,-1,5544,5545,5745,5744,-1,5545,5546,5746,5745,-1,5546,5547,5747,5746,-1,5547,5548,5748,5747,-1,5548,5549,5749,5748,-1,5549,5550,5750,5749,-1,5550,5551,5751,5750,-1,5551,5552,5752,5751,-1,5552,5553,5753,5752,-1,5553,5554,5754,5753,-1,5554,5555,5755,5754,-1,5555,5556,5756,5755,-1,5556,5557,5757,5756,-1,5557,5558,5758,5757,-1,5558,5559,5759,5758,-1,5559,5560,5760,5759,-1,5560,5561,5761,5760,-1,5561,5562,5762,5761,-1,5562,5563,5763,5762,-1,5563,5564,5764,5763,-1,5564,5565,5765,5764,-1,5565,5566,5766,5765,-1,5566,5567,5767,5766,-1,5567,5568,5768,5767,-1,5568,5569,5769,5768,-1,5569,5570,5770,5769,-1,5570,5571,5771,5770,-1,5571,5572,5772,5771,-1,5572,5573,5773,5772,-1,5573,5574,5774,5773,-1,5574,5575,5775,5774,-1,5575,5576,5776,5775,-1,5576,5577,5777,5776,-1,5577,5578,5778,5777,-1,5578,5579,5779,5778,-1,5579,5580,5780,5779,-1,5580,5581,5781,5780,-1,5581,5582,5782,5781,-1,5582,5583,5783,5782,-1,5583,5584,5784,5783,-1,5584,5585,5785,5784,-1,5585,5586,5786,5785,-1,5586,5587,5787,5786,-1,5587,5588,5788,5787,-1,5588,5589,5789,5788,-1,5589,5590,5790,5789,-1,5590,5591,5791,5790,-1,5591,5592,5792,5791,-1,5592,5593,5793,5792,-1,5593,5594,5794,5793,-1,5594,5595,5795,5794,-1,5595,5596,5796,5795,-1,5596,5597,5797,5796,-1,5597,5598,5798,5797,-1,5598,5599,5799,5798,-1,5600,5601,5801,5800,-1,5601,5602,5802,5801,-1,5602,5603,5803,5802,-1,5603,5604,5804,5803,-1,5604,5605,5805,5804,-1,5605,5606,5806,5805,-1,5606,5607,5807,5806,-1,5607,5608,5808,5807,-1,5608,5609,5809,5808,-1,5609,5610,5810,5809,-1,5610,5611,5811,5810,-1,5611,5612,5812,5811,-1,5612,5613,5813,5812,-1,5613,5614,5814,5813,-1,5614,5615,5815,5814,-1,5615,5616,5816,5815,-1,5616,5617,5817,5816,-1,5617,5618,5818,5817,-1,5618,5619,5819,5818,-1,5619,5620,5820,5819,-1,5620,5621,5821,5820,-1,5621,5622,5822,5821,-1,5622,5623,5823,5822,-1,5623,5624,5824,5823,-1,5624,5625,5825,5824,-1,5625,5626,5826,5825,-1,5626,5627,5827,5826,-1,5627,5628,5828,5827,-1,5628,5629,5829,5828,-1,5629,5630,5830,5829,-1,5630,5631,5831,5830,-1,5631,5632,5832,5831,-1,5632,5633,5833,5832,-1,5633,5634,5834,5833,-1,5634,5635,5835,5834,-1,5635,5636,5836,5835,-1,5636,5637,5837,5836,-1,5637,5638,5838,5837,-1,5638,5639,5839,5838,-1,5639,5640,5840,5839,-1,5640,5641,5841,5840,-1,5641,5642,5842,5841,-1,5642,5643,5843,5842,-1,5643,5644,5844,5843,-1,5644,5645,5845,5844,-1,5645,5646,5846,5845,-1,5646,5647,5847,5846,-1,5647,5648,5848,5847,-1,5648,5649,5849,5848,-1,5649,5650,5850,5849,-1,5650,5651,5851,5850,-1,5651,5652,5852,5851,-1,5652,5653,5853,5852,-1,5653,5654,5854,5853,-1,5654,5655,5855,5854,-1,5655,5656,5856,5855,-1,5656,5657,5857,5856,-1,5657,5658,5858,5857,-1,5658,5659,5859,5858,-1,5659,5660,5860,5859,-1,5660,5661,5861,5860,-1,5661,5662,5862,5861,-1,5662,5663,5863,5862,-1,5663,5664,5864,5863,-1,5664,5665,5865,5864,-1,5665,5666,5866,5865,-1,5666,5667,5867,5866,-1,5667,5668,5868,5867,-1,5668,5669,5869,5868,-1,5669,5670,5870,5869,-1,5670,5671,5871,5870,-1,5671,5672,5872,5871,-1,5672,5673,5873,5872,-1,5673,5674,5874,5873,-1,5674,5675,5875,5874,-1,5675,5676,5876,5875,-1,5676,5677,5877,5876,-1,5677,5678,5878,5877,-1,5678,5679,5879,5878,-1,5679,5680,5880,5879,-1,5680,5681,5881,5880,-1,5681,5682,5882,5881,-1,5682,5683,5883,5882,-1,5683,5684,5884,5883,-1,5684,5685,5885,5884,-1,5685,5686,5886,5885,-1,5686,5687,5887,5886,-1,5687,5688,5888,5887,-1,5688,5689,5889,5888,-1,5689,5690,5890,5889,-1,5690,5691,5891,5890,-1,5691,5692,5892,5891,-1,5692,5693,5893,5892,-1,5693,5694,5894,5893,-1,5694,5695,5895,5894,-1,5695,5696,5896,5895,-1,5696,5697,5897,5896,-1,5697,5698,5898,5897,-1,5698,5699,5899,5898,-1,5699,5700,5900,5899,-1,5700,5701,5901,5900,-1,5701,5702,5902,5901,-1,5702,5703,5903,5902,-1,5703,5704,5904,5903,-1,5704,5705,5905,5904,-1,5705,5706,5906,5905,-1,5706,5707,5907,5906,-1,5707,5708,5908,5907,-1,5708,5709,5909,5908,-1,5709,5710,5910,5909,-1,5710,5711,5911,5910,-1,5711,5712,5912,5911,-1,5712,5713,5913,5912,-1,5713,5714,5914,5913,-1,5714,5715,5915,5914,-1,5715,5716,5916,5915,-1,5716,5717,5917,5916,-1,5717,5718,5918,5917,-1,5718,5719,5919,5918,-1,5719,5720,5920,5919,-1,5720,5721,5921,5920,-1,5721,5722,5922,5921,-1,5722,5723,5923,5922,-1,5723,5724,5924,5923,-1,5724,5725,5925,5924,-1,5725,5726,5926,5925,-1,5726,5727,5927,5926,-1,5727,5728,5928,5927,-1,5728,5729,5929,5928,-1,5729,5730,5930,5929,-1,5730,5731,5931,5930,-1,5731,5732,5932,5931,-1,5732,5733,5933,5932,-1,5733,5734,5934,5933,-1,5734,5735,5935,5934,-1,5735,5736,5936,5935,-1,5736,5737,5937,5936,-1,5737,5738,5938,5937,-1,5738,5739,5939,5938,-1,5739,5740,5940,5939,-1,5740,5741,5941,5940,-1,5741,5742,5942,5941,-1,5742,5743,5943,5942,-1,5743,5744,5944,5943,-1,5744,5745,5945,5944,-1,5745,5746,5946,5945,-1,5746,5747,5947,5946,-1,5747,5748,5948,5947,-1,5748,5749,5949,5948,-1,5749,5750,5950,5949,-1,5750,5751,5951,5950,-1,5751,5752,5952,5951,-1,5752,5753,5953,5952,-1,5753,5754,5954,5953,-1,5754,5755,5955,5954,-1,5755,5756,5956,5955,-1,5756,5757,5957,5956,-1,5757,5758,5958,5957,-1,5758,5759,5959,5958,-1,5759,5760,5960,5959,-1,5760,5761,5961,5960,-1,5761,5762,5962,5961,-1,5762,5763,5963,5962,-1,5763,5764,5964,5963,-1,5764,5765,5965,5964,-1,5765,5766,5966,5965,-1,5766,5767,5967,5966,-1,5767,5768,5968,5967,-1,5768,5769,5969,5968,-1,5769,5770,5970,5969,-1,5770,5771,5971,5970,-1,5771,5772,5972,5971,-1,5772,5773,5973,5972,-1,5773,5774,5974,5973,-1,5774,5775,5975,5974,-1,5775,5776,5976,5975,-1,5776,5777,5977,5976,-1,5777,5778,5978,5977,-1,5778,5779,5979,5978,-1,5779,5780,5980,5979,-1,5780,5781,5981,5980,-1,5781,5782,5982,5981,-1,5782,5783,5983,5982,-1,5783,5784,5984,5983,-1,5784,5785,5985,5984,-1,5785,5786,5986,5985,-1,5786,5787,5987,5986,-1,5787,5788,5988,5987,-1,5788,5789,5989,5988,-1,5789,5790,5990,5989,-1,5790,5791,5991,5990,-1,5791,5792,5992,5991,-1,5792,5793,5993,5992,-1,5793,5794,5994,5993,-1,5794,5795,5995,5994,-1,5795,5796,5996,5995,-1,5796,5797,5997,5996,-1,5797,5798,5998,5997,-1,5798,5799,5999,5998,-1,5800,5801,6001,6,-1,5801,5802,6002,6001,-1,5802,5803,6003,6002,-1,5803,5804,6004,6003,-1,5804,5805,6005,6004,-1,5805,5806,6006,6005,-1,5806,5807,6007,6006,-1,5807,5808,6008,6007,-1,5808,5809,6009,6008,-1,5809,5810,6010,6009,-1,5810,5811,6011,6010,-1,5811,5812,6012,6011,-1,5812,5813,6013,6012,-1,5813,5814,6014,6013,-1,5814,5815,6015,6014,-1,5815,5816,6016,6015,-1,5816,5817,6017,6016,-1,5817,5818,6018,6017,-1,5818,5819,6019,6018,-1,5819,5820,6020,6019,-1,5820,5821,6021,6020,-1,5821,5822,6022,6021,-1,5822,5823,6023,6022,-1,5823,5824,6024,6023,-1,5824,5825,6025,6024,-1,5825,5826,6026,6025,-1,5826,5827,6027,6026,-1,5827,5828,6028,6027,-1,5828,5829,6029,6028,-1,5829,5830,6030,6029,-1,5830,5831,6031,6030,-1,5831,5832,6032,6031,-1,5832,5833,6033,6032,-1,5833,5834,6034,6033,-1,5834,5835,6035,6034,-1,5835,5836,6036,6035,-1,5836,5837,6037,6036,-1,5837,5838,6038,6037,-1,5838,5839,6039,6038,-1,5839,5840,6040,6039,-1,5840,5841,6041,6040,-1,5841,5842,6042,6041,-1,5842,5843,6043,6042,-1,5843,5844,6044,6043,-1,5844,5845,6045,6044,-1,5845,5846,6046,6045,-1,5846,5847,6047,6046,-1,5847,5848,6048,6047,-1,5848,5849,6049,6048,-1,5849,5850,6050,6049,-1,5850,5851,6051,6050,-1,5851,5852,6052,6051,-1,5852,5853,6053,6052,-1,5853,5854,6054,6053,-1,5854,5855,6055,6054,-1,5855,5856,6056,6055,-1,5856,5857,6057,6056,-1,5857,5858,6058,6057,-1,5858,5859,6059,6058,-1,5859,5860,6060,6059,-1,5860,5861,6061,6060,-1,5861,5862,6062,6061,-1,5862,5863,6063,6062,-1,5863,5864,6064,6063,-1,5864,5865,6065,6064,-1,5865,5866,6066,6065,-1,5866,5867,6067,6066,-1,5867,5868,6068,6067,-1,5868,5869,6069,6068,-1,5869,5870,6070,6069,-1,5870,5871,6071,6070,-1,5871,5872,6072,6071,-1,5872,5873,6073,6072,-1,5873,5874,6074,6073,-1,5874,5875,6075,6074,-1,5875,5876,6076,6075,-1,5876,5877,6077,6076,-1,5877,5878,6078,6077,-1,5878,5879,6079,6078,-1,5879,5880,6080,6079,-1,5880,5881,6081,6080,-1,5881,5882,6082,6081,-1,5882,5883,6083,6082,-1,5883,5884,6084,6083,-1,5884,5885,6085,6084,-1,5885,5886,6086,6085,-1,5886,5887,6087,6086,-1,5887,5888,6088,6087,-1,5888,5889,6089,6088,-1,5889,5890,6090,6089,-1,5890,5891,6091,6090,-1,5891,5892,6092,6091,-1,5892,5893,6093,6092,-1,5893,5894,6094,6093,-1,5894,5895,6095,6094,-1,5895,5896,6096,6095,-1,5896,5897,6097,6096,-1,5897,5898,6098,6097,-1,5898,5899,6099,6098,-1,5899,5900,6100,6099,-1,5900,5901,6101,6100,-1,5901,5902,6102,6101,-1,5902,5903,6103,6102,-1,5903,5904,6104,6103,-1,5904,5905,6105,6104,-1,5905,5906,6106,6105,-1,5906,5907,6107,6106,-1,5907,5908,6108,6107,-1,5908,5909,6109,6108,-1,5909,5910,6110,6109,-1,5910,5911,6111,6110,-1,5911,5912,6112,6111,-1,5912,5913,6113,6112,-1,5913,5914,6114,6113,-1,5914,5915,6115,6114,-1,5915,5916,6116,6115,-1,5916,5917,6117,6116,-1,5917,5918,6118,6117,-1,5918,5919,6119,6118,-1,5919,5920,6120,6119,-1,5920,5921,6121,6120,-1,5921,5922,6122,6121,-1,5922,5923,6123,6122,-1,5923,5924,6124,6123,-1,5924,5925,6125,6124,-1,5925,5926,6126,6125,-1,5926,5927,6127,6126,-1,5927,5928,6128,6127,-1,5928,5929,6129,6128,-1,5929,5930,6130,6129,-1,5930,5931,6131,6130,-1,5931,5932,6132,6131,-1,5932,5933,6133,6132,-1,5933,5934,6134,6133,-1,5934,5935,6135,6134,-1,5935,5936,6136,6135,-1,5936,5937,6137,6136,-1,5937,5938,6138,6137,-1,5938,5939,6139,6138,-1,5939,5940,6140,6139,-1,5940,5941,6141,6140,-1,5941,5942,6142,6141,-1,5942,5943,6143,6142,-1,5943,5944,6144,6143,-1,5944,5945,6145,6144,-1,5945,5946,6146,6145,-1,5946,5947,6147,6146,-1,5947,5948,6148,6147,-1,5948,5949,6149,6148,-1,5949,5950,6150,6149,-1,5950,5951,6151,6150,-1,5951,5952,6152,6151,-1,5952,5953,6153,6152,-1,5953,5954,6154,6153,-1,5954,5955,6155,6154,-1,5955,5956,6156,6155,-1,5956,5957,6157,6156,-1,5957,5958,6158,6157,-1,5958,5959,6159,6158,-1,5959,5960,6160,6159,-1,5960,5961,6161,6160,-1,5961,5962,6162,6161,-1,5962,5963,6163,6162,-1,5963,5964,6164,6163,-1,5964,5965,6165,6164,-1,5965,5966,6166,6165,-1,5966,5967,6167,6166,-1,5967,5968,6168,6167,-1,5968,5969,6169,6168,-1,5969,5970,6170,6169,-1,5970,5971,6171,6170,-1,5971,5972,6172,6171,-1,5972,5973,6173,6172,-1,5973,5974,6174,6173,-1,5974,5975,6175,6174,-1,5975,5976,6176,6175,-1,5976,5977,6177,6176,-1,5977,5978,6178,6177,-1,5978,5979,6179,6178,-1,5979,5980,6180,6179,-1,5980,5981,6181,6180,-1,5981,5982,6182,6181,-1,5982,5983,6183,6182,-1,5983,5984,6184,6183,-1,5984,5985,6185,6184,-1,5985,5986,6186,6185,-1,5986,5987,6187,6186,-1,5987,5988,6188,6187,-1,5988,5989,6189,6188,-1,5989,5990,6190,6189,-1,5990,5991,6191,6190,-1,5991,5992,6192,6191,-1,5992,5993,6193,6192,-1,5993,5994,6194,6193,-1,5994,5995,6195,6194,-1,5995,5996,6196,6195,-1,5996,5997,6197,6196,-1,5997,5998,6198,6197,-1,5998,5999,6199,6198,-1,6,6001,6201,6200,-1,6001,6002,6202,6201,-1,6002,6003,6203,6202,-1,6003,6004,6204,6203,-1,6004,6005,6205,6204,-1,6005,6006,6206,6205,-1,6006,6007,6207,6206,-1,6007,6008,6208,6207,-1,6008,6009,6209,6208,-1,6009,6010,6210,6209,-1,6010,6011,6211,6210,-1,6011,6012,6212,6211,-1,6012,6013,6213,6212,-1,6013,6014,6214,6213,-1,6014,6015,6215,6214,-1,6015,6016,6216,6215,-1,6016,6017,6217,6216,-1,6017,6018,6218,6217,-1,6018,6019,6219,6218,-1,6019,6020,6220,6219,-1,6020,6021,6221,6220,-1,6021,6022,6222,6221,-1,6022,6023,6223,6222,-1,6023,6024,6224,6223,-1,6024,6025,6225,6224,-1,6025,6026,6226,6225,-1,6026,6027,6227,6226,-1,6027,6028,6228,6227,-1,6028,6029,6229,6228,-1,6029,6030,6230,6229,-1,6030,6031,6231,6230,-1,6031,6032,6232,6231,-1,6032,6033,6233,6232,-1,6033,6034,6234,6233,-1,6034,6035,6235,6234,-1,6035,6036,6236,6235,-1,6036,6037,6237,6236,-1,6037,6038,6238,6237,-1,6038,6039,6239,6238,-1,6039,6040,6240,6239,-1,6040,6041,6241,6240,-1,6041,6042,6242,6241,-1,6042,6043,6243,6242,-1,6043,6044,6244,6243,-1,6044,6045,6245,6244,-1,6045,6046,6246,6245,-1,6046,6047,6247,6246,-1,6047,6048,6248,6247,-1,6048,6049,6249,6248,-1,6049,6050,6250,6249,-1,6050,6051,6251,6250,-1,6051,6052,6252,6251,-1,6052,6053,6253,6252,-1,6053,6054,6254,6253,-1,6054,6055,6255,6254,-1,6055,6056,6256,6255,-1,6056,6057,6257,6256,-1,6057,6058,6258,6257,-1,6058,6059,6259,6258,-1,6059,6060,6260,6259,-1,6060,6061,6261,6260,-1,6061,6062,6262,6261,-1,6062,6063,6263,6262,-1,6063,6064,6264,6263,-1,6064,6065,6265,6264,-1,6065,6066,6266,6265,-1,6066,6067,6267,6266,-1,6067,6068,6268,6267,-1,6068,6069,6269,6268,-1,6069,6070,6270,6269,-1,6070,6071,6271,6270,-1,6071,6072,6272,6271,-1,6072,6073,6273,6272,-1,6073,6074,6274,6273,-1,6074,6075,6275,6274,-1,6075,6076,6276,6275,-1,6076,6077,6277,6276,-1,6077,6078,6278,6277,-1,6078,6079,6279,6278,-1,6079,6080,6280,6279,-1,6080,6081,6281,6280,-1,6081,6082,6282,6281,-1,6082,6083,6283,6282,-1,6083,6084,6284,6283,-1,6084,6085,6285,6284,-1,6085,6086,6286,6285,-1,6086,6087,6287,6286,-1,6087,6088,6288,6287,-1,6088,6089,6289,6288,-1,6089,6090,6290,6289,-1,6090,6091,6291,6290,-1,6091,6092,6292,6291,-1,6092,6093,6293,6292,-1,6093,6094,6294,6293,-1,6094,6095,6295,6294,-1,6095,6096,6296,6295,-1,6096,6097,6297,6296,-1,6097,6098,6298,6297,-1,6098,6099,6299,6298,-1,6099,6100,6300,6299,-1,6100,6101,6301,6300,-1,6101,6102,6302,6301,-1,6102,6103,6303,6302,-1,6103,6104,6304,6303,-1,6104,6105,6305,6304,-1,6105,6106,6306,6305,-1,6106,6107,6307,6306,-1,6107,6108,6308,6307,-1,6108,6109,6309,6308,-1,6109,6110,6310,6309,-1,6110,6111,6311,6310,-1,6111,6112,6312,6311,-1,6112,6113,6313,6312,-1,6113,6114,6314,6313,-1,6114,6115,6315,6314,-1,6115,6116,6316,6315,-1,6116,6117,6317,6316,-1,6117,6118,6318,6317,-1,6118,6119,6319,6318,-1,6119,6120,6320,6319,-1,6120,6121,6321,6320,-1,6121,6122,6322,6321,-1,6122,6123,6323,6322,-1,6123,6124,6324,6323,-1,6124,6125,6325,6324,-1,6125,6126,6326,6325,-1,6126,6127,6327,6326,-1,6127,6128,6328,6327,-1,6128,6129,6329,6328,-1,6129,6130,6330,6329,-1,6130,6131,6331,6330,-1,6131,6132,6332,6331,-1,6132,6133,6333,6332,-1,6133,6134,6334,6333,-1,6134,6135,6335,6334,-1,6135,6136,6336,6335,-1,6136,6137,6337,6336,-1,6137,6138,6338,6337,-1,6138,6139,6339,6338,-1,6139,6140,6340,6339,-1,6140,6141,6341,6340,-1,6141,6142,6342,6341,-1,6142,6143,6343,6342,-1,6143,6144,6344,6343,-1,6144,6145,6345,6344,-1,6145,6146,6346,6345,-1,6146,6147,6347,6346,-1,6147,6148,6348,6347,-1,6148,6149,6349,6348,-1,6149,6150,6350,6349,-1,6150,6151,6351,6350,-1,6151,6152,6352,6351,-1,6152,6153,6353,6352,-1,6153,6154,6354,6353,-1,6154,6155,6355,6354,-1,6155,6156,6356,6355,-1,6156,6157,6357,6356,-1,6157,6158,6358,6357,-1,6158,6159,6359,6358,-1,6159,6160,6360,6359,-1,6160,6161,6361,6360,-1,6161,6162,6362,6361,-1,6162,6163,6363,6362,-1,6163,6164,6364,6363,-1,6164,6165,6365,6364,-1,6165,6166,6366,6365,-1,6166,6167,6367,6366,-1,6167,6168,6368,6367,-1,6168,6169,6369,6368,-1,6169,6170,6370,6369,-1,6170,6171,6371,6370,-1,6171,6172,6372,6371,-1,6172,6173,6373,6372,-1,6173,6174,6374,6373,-1,6174,6175,6375,6374,-1,6175,6176,6376,6375,-1,6176,6177,6377,6376,-1,6177,6178,6378,6377,-1,6178,6179,6379,6378,-1,6179,6180,6380,6379,-1,6180,6181,6381,6380,-1,6181,6182,6382,6381,-1,6182,6183,6383,6382,-1,6183,6184,6384,6383,-1,6184,6185,6385,6384,-1,6185,6186,6386,6385,-1,6186,6187,6387,6386,-1,6187,6188,6388,6387,-1,6188,6189,6389,6388,-1,6189,6190,6390,6389,-1,6190,6191,6391,6390,-1,6191,6192,6392,6391,-1,6192,6193,6393,6392,-1,6193,6194,6394,6393,-1,6194,6195,6395,6394,-1,6195,6196,6396,6395,-1,6196,6197,6397,6396,-1,6197,6198,6398,6397,-1,6198,6199,6399,6398,-1,6200,6201,6401,6400,-1,6201,6202,6402,6401,-1,6202,6203,6403,6402,-1,6203,6204,6404,6403,-1,6204,6205,6405,6404,-1,6205,6206,6406,6405,-1,6206,6207,6407,6406,-1,6207,6208,6408,6407,-1,6208,6209,6409,6408,-1,6209,6210,6410,6409,-1,6210,6211,6411,6410,-1,6211,6212,6412,6411,-1,6212,6213,6413,6412,-1,6213,6214,6414,6413,-1,6214,6215,6415,6414,-1,6215,6216,6416,6415,-1,6216,6217,6417,6416,-1,6217,6218,6418,6417,-1,6218,6219,6419,6418,-1,6219,6220,6420,6419,-1,6220,6221,6421,6420,-1,6221,6222,6422,6421,-1,6222,6223,6423,6422,-1,6223,6224,6424,6423,-1,6224,6225,6425,6424,-1,6225,6226,6426,6425,-1,6226,6227,6427,6426,-1,6227,6228,6428,6427,-1,6228,6229,6429,6428,-1,6229,6230,6430,6429,-1,6230,6231,6431,6430,-1,6231,6232,6432,6431,-1,6232,6233,6433,6432,-1,6233,6234,6434,6433,-1,6234,6235,6435,6434,-1,6235,6236,6436,6435,-1,6236,6237,6437,6436,-1,6237,6238,6438,6437,-1,6238,6239,6439,6438,-1,6239,6240,6440,6439,-1,6240,6241,6441,6440,-1,6241,6242,6442,6441,-1,6242,6243,6443,6442,-1,6243,6244,6444,6443,-1,6244,6245,6445,6444,-1,6245,6246,6446,6445,-1,6246,6247,6447,6446,-1,6247,6248,6448,6447,-1,6248,6249,6449,6448,-1,6249,6250,6450,6449,-1,6250,6251,6451,6450,-1,6251,6252,6452,6451,-1,6252,6253,6453,6452,-1,6253,6254,6454,6453,-1,6254,6255,6455,6454,-1,6255,6256,6456,6455,-1,6256,6257,6457,6456,-1,6257,6258,6458,6457,-1,6258,6259,6459,6458,-1,6259,6260,6460,6459,-1,6260,6261,6461,6460,-1,6261,6262,6462,6461,-1,6262,6263,6463,6462,-1,6263,6264,6464,6463,-1,6264,6265,6465,6464,-1,6265,6266,6466,6465,-1,6266,6267,6467,6466,-1,6267,6268,6468,6467,-1,6268,6269,6469,6468,-1,6269,6270,6470,6469,-1,6270,6271,6471,6470,-1,6271,6272,6472,6471,-1,6272,6273,6473,6472,-1,6273,6274,6474,6473,-1,6274,6275,6475,6474,-1,6275,6276,6476,6475,-1,6276,6277,6477,6476,-1,6277,6278,6478,6477,-1,6278,6279,6479,6478,-1,6279,6280,6480,6479,-1,6280,6281,6481,6480,-1,6281,6282,6482,6481,-1,6282,6283,6483,6482,-1,6283,6284,6484,6483,-1,6284,6285,6485,6484,-1,6285,6286,6486,6485,-1,6286,6287,6487,6486,-1,6287,6288,6488,6487,-1,6288,6289,6489,6488,-1,6289,6290,6490,6489,-1,6290,6291,6491,6490,-1,6291,6292,6492,6491,-1,6292,6293,6493,6492,-1,6293,6294,6494,6493,-1,6294,6295,6495,6494,-1,6295,6296,6496,6495,-1,6296,6297,6497,6496,-1,6297,6298,6498,6497,-1,6298,6299,6499,6498,-1,6299,6300,6500,6499,-1,6300,6301,6501,6500,-1,6301,6302,6502,6501,-1,6302,6303,6503,6502,-1,6303,6304,6504,6503,-1,6304,6305,6505,6504,-1,6305,6306,6506,6505,-1,6306,6307,6507,6506,-1,6307,6308,6508,6507,-1,6308,6309,6509,6508,-1,6309,6310,6510,6509,-1,6310,6311,6511,6510,-1,6311,6312,6512,6511,-1,6312,6313,6513,6512,-1,6313,6314,6514,6513,-1,6314,6315,6515,6514,-1,6315,6316,6516,6515,-1,6316,6317,6517,6516,-1,6317,6318,6518,6517,-1,6318,6319,6519,6518,-1,6319,6320,6520,6519,-1,6320,6321,6521,6520,-1,6321,6322,6522,6521,-1,6322,6323,6523,6522,-1,6323,6324,6524,6523,-1,6324,6325,6525,6524,-1,6325,6326,6526,6525,-1,6326,6327,6527,6526,-1,6327,6328,6528,6527,-1,6328,6329,6529,6528,-1,6329,6330,6530,6529,-1,6330,6331,6531,6530,-1,6331,6332,6532,6531,-1,6332,6333,6533,6532,-1,6333,6334,6534,6533,-1,6334,6335,6535,6534,-1,6335,6336,6536,6535,-1,6336,6337,6537,6536,-1,6337,6338,6538,6537,-1,6338,6339,6539,6538,-1,6339,6340,6540,6539,-1,6340,6341,6541,6540,-1,6341,6342,6542,6541,-1,6342,6343,6543,6542,-1,6343,6344,6544,6543,-1,6344,6345,6545,6544,-1,6345,6346,6546,6545,-1,6346,6347,6547,6546,-1,6347,6348,6548,6547,-1,6348,6349,6549,6548,-1,6349,6350,6550,6549,-1,6350,6351,6551,6550,-1,6351,6352,6552,6551,-1,6352,6353,6553,6552,-1,6353,6354,6554,6553,-1,6354,6355,6555,6554,-1,6355,6356,6556,6555,-1,6356,6357,6557,6556,-1,6357,6358,6558,6557,-1,6358,6359,6559,6558,-1,6359,6360,6560,6559,-1,6360,6361,6561,6560,-1,6361,6362,6562,6561,-1,6362,6363,6563,6562,-1,6363,6364,6564,6563,-1,6364,6365,6565,6564,-1,6365,6366,6566,6565,-1,6366,6367,6567,6566,-1,6367,6368,6568,6567,-1,6368,6369,6569,6568,-1,6369,6370,6570,6569,-1,6370,6371,6571,6570,-1,6371,6372,6572,6571,-1,6372,6373,6573,6572,-1,6373,6374,6574,6573,-1,6374,6375,6575,6574,-1,6375,6376,6576,6575,-1,6376,6377,6577,6576,-1,6377,6378,6578,6577,-1,6378,6379,6579,6578,-1,6379,6380,6580,6579,-1,6380,6381,6581,6580,-1,6381,6382,6582,6581,-1,6382,6383,6583,6582,-1,6383,6384,6584,6583,-1,6384,6385,6585,6584,-1,6385,6386,6586,6585,-1,6386,6387,6587,6586,-1,6387,6388,6588,6587,-1,6388,6389,6589,6588,-1,6389,6390,6590,6589,-1,6390,6391,6591,6590,-1,6391,6392,6592,6591,-1,6392,6393,6593,6592,-1,6393,6394,6594,6593,-1,6394,6395,6595,6594,-1,6395,6396,6596,6595,-1,6396,6397,6597,6596,-1,6397,6398,6598,6597,-1,6398,6399,6599,6598,-1,6400,6401,6601,6600,-1,6401,6402,6602,6601,-1,6402,6403,6603,6602,-1,6403,6404,6604,6603,-1,6404,6405,6605,6604,-1,6405,6406,6606,6605,-1,6406,6407,6607,6606,-1,6407,6408,6608,6607,-1,6408,6409,6609,6608,-1,6409,6410,6610,6609,-1,6410,6411,6611,6610,-1,6411,6412,6612,6611,-1,6412,6413,6613,6612,-1,6413,6414,6614,6613,-1,6414,6415,6615,6614,-1,6415,6416,6616,6615,-1,6416,6417,6617,6616,-1,6417,6418,6618,6617,-1,6418,6419,6619,6618,-1,6419,6420,6620,6619,-1,6420,6421,6621,6620,-1,6421,6422,6622,6621,-1,6422,6423,6623,6622,-1,6423,6424,6624,6623,-1,6424,6425,6625,6624,-1,6425,6426,6626,6625,-1,6426,6427,6627,6626,-1,6427,6428,6628,6627,-1,6428,6429,6629,6628,-1,6429,6430,6630,6629,-1,6430,6431,6631,6630,-1,6431,6432,6632,6631,-1,6432,6433,6633,6632,-1,6433,6434,6634,6633,-1,6434,6435,6635,6634,-1,6435,6436,6636,6635,-1,6436,6437,6637,6636,-1,6437,6438,6638,6637,-1,6438,6439,6639,6638,-1,6439,6440,6640,6639,-1,6440,6441,6641,6640,-1,6441,6442,6642,6641,-1,6442,6443,6643,6642,-1,6443,6444,6644,6643,-1,6444,6445,6645,6644,-1,6445,6446,6646,6645,-1,6446,6447,6647,6646,-1,6447,6448,6648,6647,-1,6448,6449,6649,6648,-1,6449,6450,6650,6649,-1,6450,6451,6651,6650,-1,6451,6452,6652,6651,-1,6452,6453,6653,6652,-1,6453,6454,6654,6653,-1,6454,6455,6655,6654,-1,6455,6456,6656,6655,-1,6456,6457,6657,6656,-1,6457,6458,6658,6657,-1,6458,6459,6659,6658,-1,6459,6460,6660,6659,-1,6460,6461,6661,6660,-1,6461,6462,6662,6661,-1,6462,6463,6663,6662,-1,6463,6464,6664,6663,-1,6464,6465,6665,6664,-1,6465,6466,6666,6665,-1,6466,6467,6667,6666,-1,6467,6468,6668,6667,-1,6468,6469,6669,6668,-1,6469,6470,6670,6669,-1,6470,6471,6671,6670,-1,6471,6472,6672,6671,-1,6472,6473,6673,6672,-1,6473,6474,6674,6673,-1,6474,6475,6675,6674,-1,6475,6476,6676,6675,-1,6476,6477,6677,6676,-1,6477,6478,6678,6677,-1,6478,6479,6679,6678,-1,6479,6480,6680,6679,-1,6480,6481,6681,6680,-1,6481,6482,6682,6681,-1,6482,6483,6683,6682,-1,6483,6484,6684,6683,-1,6484,6485,6685,6684,-1,6485,6486,6686,6685,-1,6486,6487,6687,6686,-1,6487,6488,6688,6687,-1,6488,6489,6689,6688,-1,6489,6490,6690,6689,-1,6490,6491,6691,6690,-1,6491,6492,6692,6691,-1,6492,6493,6693,6692,-1,6493,6494,6694,6693,-1,6494,6495,6695,6694,-1,6495,6496,6696,6695,-1,6496,6497,6697,6696,-1,6497,6498,6698,6697,-1,6498,6499,6699,6698,-1,6499,6500,6700,6699,-1,6500,6501,6701,6700,-1,6501,6502,6702,6701,-1,6502,6503,6703,6702,-1,6503,6504,6704,6703,-1,6504,6505,6705,6704,-1,6505,6506,6706,6705,-1,6506,6507,6707,6706,-1,6507,6508,6708,6707,-1,6508,6509,6709,6708,-1,6509,6510,6710,6709,-1,6510,6511,6711,6710,-1,6511,6512,6712,6711,-1,6512,6513,6713,6712,-1,6513,6514,6714,6713,-1,6514,6515,6715,6714,-1,6515,6516,6716,6715,-1,6516,6517,6717,6716,-1,6517,6518,6718,6717,-1,6518,6519,6719,6718,-1,6519,6520,6720,6719,-1,6520,6521,6721,6720,-1,6521,6522,6722,6721,-1,6522,6523,6723,6722,-1,6523,6524,6724,6723,-1,6524,6525,6725,6724,-1,6525,6526,6726,6725,-1,6526,6527,6727,6726,-1,6527,6528,6728,6727,-1,6528,6529,6729,6728,-1,6529,6530,6730,6729,-1,6530,6531,6731,6730,-1,6531,6532,6732,6731,-1,6532,6533,6733,6732,-1,6533,6534,6734,6733,-1,6534,6535,6735,6734,-1,6535,6536,6736,6735,-1,6536,6537,6737,6736,-1,6537,6538,6738,6737,-1,6538,6539,6739,6738,-1,6539,6540,6740,6739,-1,6540,6541,6741,6740,-1,6541,6542,6742,6741,-1,6542,6543,6743,6742,-1,6543,6544,6744,6743,-1,6544,6545,6745,6744,-1,6545,6546,6746,6745,-1,6546,6547,6747,6746,-1,6547,6548,6748,6747,-1,6548,6549,6749,6748,-1,6549,6550,6750,6749,-1,6550,6551,6751,6750,-1,6551,6552,6752,6751,-1,6552,6553,6753,6752,-1,6553,6554,6754,6753,-1,6554,6555,6755,6754,-1,6555,6556,6756,6755,-1,6556,6557,6757,6756,-1,6557,6558,6758,6757,-1,6558,6559,6759,6758,-1,6559,6560,6760,6759,-1,6560,6561,6761,6760,-1,6561,6562,6762,6761,-1,6562,6563,6763,6762,-1,6563,6564,6764,6763,-1,6564,6565,6765,6764,-1,6565,6566,6766,6765,-1,6566,6567,6767,6766,-1,6567,6568,6768,6767,-1,6568,6569,6769,6768,-1,6569,6570,6770,6769,-1,6570,6571,6771,6770,-1,6571,6572,6772,6771,-1,6572,6573,6773,6772,-1,6573,6574,6774,6773,-1,6574,6575,6775,6774,-1,6575,6576,6776,6775,-1,6576,6577,6777,6776,-1,6577,6578,6778,6777,-1,6578,6579,6779,6778,-1,6579,6580,6780,6779,-1,6580,6581,6781,6780,-1,6581,6582,6782,6781,-1,6582,6583,6783,6782,-1,6583,6584,6784,6783,-1,6584,6585,6785,6784,-1,6585,6586,6786,6785,-1,6586,6587,6787,6786,-1,6587,6588,6788,6787,-1,6588,6589,6789,6788,-1,6589,6590,6790,6789,-1,6590,6591,6791,6790,-1,6591,6592,6792,6791,-1,6592,6593,6793,6792,-1,6593,6594,6794,6793,-1,6594,6595,6795,6794,-1,6595,6596,6796,6795,-1,6596,6597,6797,6796,-1,6597,6598,6798,6797,-1,6598,6599,6799,6798,-1,6600,6601,6801,6800,-1,6601,6602,6802,6801,-1,6602,6603,6803,6802,-1,6603,6604,6804,6803,-1,6604,6605,6805,6804,-1,6605,6606,6806,6805,-1,6606,6607,6807,6806,-1,6607,6608,6808,6807,-1,6608,6609,6809,6808,-1,6609,6610,6810,6809,-1,6610,6611,6811,6810,-1,6611,6612,6812,6811,-1,6612,6613,6813,6812,-1,6613,6614,6814,6813,-1,6614,6615,6815,6814,-1,6615,6616,6816,6815,-1,6616,6617,6817,6816,-1,6617,6618,6818,6817,-1,6618,6619,6819,6818,-1,6619,6620,6820,6819,-1,6620,6621,6821,6820,-1,6621,6622,6822,6821,-1,6622,6623,6823,6822,-1,6623,6624,6824,6823,-1,6624,6625,6825,6824,-1,6625,6626,6826,6825,-1,6626,6627,6827,6826,-1,6627,6628,6828,6827,-1,6628,6629,6829,6828,-1,6629,6630,6830,6829,-1,6630,6631,6831,6830,-1,6631,6632,6832,6831,-1,6632,6633,6833,6832,-1,6633,6634,6834,6833,-1,6634,6635,6835,6834,-1,6635,6636,6836,6835,-1,6636,6637,6837,6836,-1,6637,6638,6838,6837,-1,6638,6639,6839,6838,-1,6639,6640,6840,6839,-1,6640,6641,6841,6840,-1,6641,6642,6842,6841,-1,6642,6643,6843,6842,-1,6643,6644,6844,6843,-1,6644,6645,6845,6844,-1,6645,6646,6846,6845,-1,6646,6647,6847,6846,-1,6647,6648,6848,6847,-1,6648,6649,6849,6848,-1,6649,6650,6850,6849,-1,6650,6651,6851,6850,-1,6651,6652,6852,6851,-1,6652,6653,6853,6852,-1,6653,6654,6854,6853,-1,6654,6655,6855,6854,-1,6655,6656,6856,6855,-1,6656,6657,6857,6856,-1,6657,6658,6858,6857,-1,6658,6659,6859,6858,-1,6659,6660,6860,6859,-1,6660,6661,6861,6860,-1,6661,6662,6862,6861,-1,6662,6663,6863,6862,-1,6663,6664,6864,6863,-1,6664,6665,6865,6864,-1,6665,6666,6866,6865,-1,6666,6667,6867,6866,-1,6667,6668,6868,6867,-1,6668,6669,6869,6868,-1,6669,6670,6870,6869,-1,6670,6671,6871,6870,-1,6671,6672,6872,6871,-1,6672,6673,6873,6872,-1,6673,6674,6874,6873,-1,6674,6675,6875,6874,-1,6675,6676,6876,6875,-1,6676,6677,6877,6876,-1,6677,6678,6878,6877,-1,6678,6679,6879,6878,-1,6679,6680,6880,6879,-1,6680,6681,6881,6880,-1,6681,6682,6882,6881,-1,6682,6683,6883,6882,-1,6683,6684,6884,6883,-1,6684,6685,6885,6884,-1,6685,6686,6886,6885,-1,6686,6687,6887,6886,-1,6687,6688,6888,6887,-1,6688,6689,6889,6888,-1,6689,6690,6890,6889,-1,6690,6691,6891,6890,-1,6691,6692,6892,6891,-1,6692,6693,6893,6892,-1,6693,6694,6894,6893,-1,6694,6695,6895,6894,-1,6695,6696,6896,6895,-1,6696,6697,6897,6896,-1,6697,6698,6898,6897,-1,6698,6699,6899,6898,-1,6699,6700,6900,6899,-1,6700,6701,6901,6900,-1,6701,6702,6902,6901,-1,6702,6703,6903,6902,-1,6703,6704,6904,6903,-1,6704,6705,6905,6904,-1,6705,6706,6906,6905,-1,6706,6707,6907,6906,-1,6707,6708,6908,6907,-1,6708,6709,6909,6908,-1,6709,6710,6910,6909,-1,6710,6711,6911,6910,-1,6711,6712,6912,6911,-1,6712,6713,6913,6912,-1,6713,6714,6914,6913,-1,6714,6715,6915,6914,-1,6715,6716,6916,6915,-1,6716,6717,6917,6916,-1,6717,6718,6918,6917,-1,6718,6719,6919,6918,-1,6719,6720,6920,6919,-1,6720,6721,6921,6920,-1,6721,6722,6922,6921,-1,6722,6723,6923,6922,-1,6723,6724,6924,6923,-1,6724,6725,6925,6924,-1,6725,6726,6926,6925,-1,6726,6727,6927,6926,-1,6727,6728,6928,6927,-1,6728,6729,6929,6928,-1,6729,6730,6930,6929,-1,6730,6731,6931,6930,-1,6731,6732,6932,6931,-1,6732,6733,6933,6932,-1,6733,6734,6934,6933,-1,6734,6735,6935,6934,-1,6735,6736,6936,6935,-1,6736,6737,6937,6936,-1,6737,6738,6938,6937,-1,6738,6739,6939,6938,-1,6739,6740,6940,6939,-1,6740,6741,6941,6940,-1,6741,6742,6942,6941,-1,6742,6743,6943,6942,-1,6743,6744,6944,6943,-1,6744,6745,6945,6944,-1,6745,6746,6946,6945,-1,6746,6747,6947,6946,-1,6747,6748,6948,6947,-1,6748,6749,6949,6948,-1,6749,6750,6950,6949,-1,6750,6751,6951,6950,-1,6751,6752,6952,6951,-1,6752,6753,6953,6952,-1,6753,6754,6954,6953,-1,6754,6755,6955,6954,-1,6755,6756,6956,6955,-1,6756,6757,6957,6956,-1,6757,6758,6958,6957,-1,6758,6759,6959,6958,-1,6759,6760,6960,6959,-1,6760,6761,6961,6960,-1,6761,6762,6962,6961,-1,6762,6763,6963,6962,-1,6763,6764,6964,6963,-1,6764,6765,6965,6964,-1,6765,6766,6966,6965,-1,6766,6767,6967,6966,-1,6767,6768,6968,6967,-1,6768,6769,6969,6968,-1,6769,6770,6970,6969,-1,6770,6771,6971,6970,-1,6771,6772,6972,6971,-1,6772,6773,6973,6972,-1,6773,6774,6974,6973,-1,6774,6775,6975,6974,-1,6775,6776,6976,6975,-1,6776,6777,6977,6976,-1,6777,6778,6978,6977,-1,6778,6779,6979,6978,-1,6779,6780,6980,6979,-1,6780,6781,6981,6980,-1,6781,6782,6982,6981,-1,6782,6783,6983,6982,-1,6783,6784,6984,6983,-1,6784,6785,6985,6984,-1,6785,6786,6986,6985,-1,6786,6787,6987,6986,-1,6787,6788,6988,6987,-1,6788,6789,6989,6988,-1,6789,6790,6990,6989,-1,6790,6791,6991,6990,-1,6791,6792,6992,6991,-1,6792,6793,6993,6992,-1,6793,6794,6994,6993,-1,6794,6795,6995,6994,-1,6795,6796,6996,6995,-1,6796,6797,6997,6996,-1,6797,6798,6998,6997,-1,6798,6799,6999,6998,-1,6800,6801,7001,7,-1,6801,6802,7002,7001,-1,6802,6803,7003,7002,-1,6803,6804,7004,7003,-1,6804,6805,7005,7004,-1,6805,6806,7006,7005,-1,6806,6807,7007,7006,-1,6807,6808,7008,7007,-1,6808,6809,7009,7008,-1,6809,6810,7010,7009,-1,6810,6811,7011,7010,-1,6811,6812,7012,7011,-1,6812,6813,7013,7012,-1,6813,6814,7014,7013,-1,6814,6815,7015,7014,-1,6815,6816,7016,7015,-1,6816,6817,7017,7016,-1,6817,6818,7018,7017,-1,6818,6819,7019,7018,-1,6819,6820,7020,7019,-1,6820,6821,7021,7020,-1,6821,6822,7022,7021,-1,6822,6823,7023,7022,-1,6823,6824,7024,7023,-1,6824,6825,7025,7024,-1,6825,6826,7026,7025,-1,6826,6827,7027,7026,-1,6827,6828,7028,7027,-1,6828,6829,7029,7028,-1,6829,6830,7030,7029,-1,6830,6831,7031,7030,-1,6831,6832,7032,7031,-1,6832,6833,7033,7032,-1,6833,6834,7034,7033,-1,6834,6835,7035,7034,-1,6835,6836,7036,7035,-1,6836,6837,7037,7036,-1,6837,6838,7038,7037,-1,6838,6839,7039,7038,-1,6839,6840,7040,7039,-1,6840,6841,7041,7040,-1,6841,6842,7042,7041,-1,6842,6843,7043,7042,-1,6843,6844,7044,7043,-1,6844,6845,7045,7044,-1,6845,6846,7046,7045,-1,6846,6847,7047,7046,-1,6847,6848,7048,7047,-1,6848,6849,7049,7048,-1,6849,6850,7050,7049,-1,6850,6851,7051,7050,-1,6851,6852,7052,7051,-1,6852,6853,7053,7052,-1,6853,6854,7054,7053,-1,6854,6855,7055,7054,-1,6855,6856,7056,7055,-1,6856,6857,7057,7056,-1,6857,6858,7058,7057,-1,6858,6859,7059,7058,-1,6859,6860,7060,7059,-1,6860,6861,7061,7060,-1,6861,6862,7062,7061,-1,6862,6863,7063,7062,-1,6863,6864,7064,7063,-1,6864,6865,7065,7064,-1,6865,6866,7066,7065,-1,6866,6867,7067,7066,-1,6867,6868,7068,7067,-1,6868,6869,7069,7068,-1,6869,6870,7070,7069,-1,6870,6871,7071,7070,-1,6871,6872,7072,7071,-1,6872,6873,7073,7072,-1,6873,6874,7074,7073,-1,6874,6875,7075,7074,-1,6875,6876,7076,7075,-1,6876,6877,7077,7076,-1,6877,6878,7078,7077,-1,6878,6879,7079,7078,-1,6879,6880,7080,7079,-1,6880,6881,7081,7080,-1,6881,6882,7082,7081,-1,6882,6883,7083,7082,-1,6883,6884,7084,7083,-1,6884,6885,7085,7084,-1,6885,6886,7086,7085,-1,6886,6887,7087,7086,-1,6887,6888,7088,7087,-1,6888,6889,7089,7088,-1,6889,6890,7090,7089,-1,6890,6891,7091,7090,-1,6891,6892,7092,7091,-1,6892,6893,7093,7092,-1,6893,6894,7094,7093,-1,6894,6895,7095,7094,-1,6895,6896,7096,7095,-1,6896,6897,7097,7096,-1,6897,6898,7098,7097,-1,6898,6899,7099,7098,-1,6899,6900,7100,7099,-1,6900,6901,7101,7100,-1,6901,6902,7102,7101,-1,6902,6903,7103,7102,-1,6903,6904,7104,7103,-1,6904,6905,7105,7104,-1,6905,6906,7106,7105,-1,6906,6907,7107,7106,-1,6907,6908,7108,7107,-1,6908,6909,7109,7108,-1,6909,6910,7110,7109,-1,6910,6911,7111,7110,-1,6911,6912,7112,7111,-1,6912,6913,7113,7112,-1,6913,6914,7114,7113,-1,6914,6915,7115,7114,-1,6915,6916,7116,7115,-1,6916,6917,7117,7116,-1,6917,6918,7118,7117,-1,6918,6919,7119,7118,-1,6919,6920,7120,7119,-1,6920,6921,7121,7120,-1,6921,6922,7122,7121,-1,6922,6923,7123,7122,-1,6923,6924,7124,7123,-1,6924,6925,7125,7124,-1,6925,6926,7126,7125,-1,6926,6927,7127,7126,-1,6927,6928,7128,7127,-1,6928,6929,7129,7128,-1,6929,6930,7130,7129,-1,6930,6931,7131,7130,-1,6931,6932,7132,7131,-1,6932,6933,7133,7132,-1,6933,6934,7134,7133,-1,6934,6935,7135,7134,-1,6935,6936,7136,7135,-1,6936,6937,7137,7136,-1,6937,6938,7138,7137,-1,6938,6939,7139,7138,-1,6939,6940,7140,7139,-1,6940,6941,7141,7140,-1,6941,6942,7142,7141,-1,6942,6943,7143,7142,-1,6943,6944,7144,7143,-1,6944,6945,7145,7144,-1,6945,6946,7146,7145,-1,6946,6947,7147,7146,-1,6947,6948,7148,7147,-1,6948,6949,7149,7148,-1,6949,6950,7150,7149,-1,6950,6951,7151,7150,-1,6951,6952,7152,7151,-1,6952,6953,7153,7152,-1,6953,6954,7154,7153,-1,6954,6955,7155,7154,-1,6955,6956,7156,7155,-1,6956,6957,7157,7156,-1,6957,6958,7158,7157,-1,6958,6959,7159,7158,-1,6959,6960,7160,7159,-1,6960,6961,7161,7160,-1,6961,6962,7162,7161,-1,6962,6963,7163,7162,-1,6963,6964,7164,7163,-1,6964,6965,7165,7164,-1,6965,6966,7166,7165,-1,6966,6967,7167,7166,-1,6967,6968,7168,7167,-1,6968,6969,7169,7168,-1,6969,6970,7170,7169,-1,6970,6971,7171,7170,-1,6971,6972,7172,7171,-1,6972,6973,7173,7172,-1,6973,6974,7174,7173,-1,6974,6975,7175,7174,-1,6975,6976,7176,7175,-1,6976,6977,7177,7176,-1,6977,6978,7178,7177,-1,6978,6979,7179,7178,-1,6979,6980,7180,7179,-1,6980,6981,7181,7180,-1,6981,6982,7182,7181,-1,6982,6983,7183,7182,-1,6983,6984,7184,7183,-1,6984,6985,7185,7184,-1,6985,6986,7186,7185,-1,6986,6987,7187,7186,-1,6987,6988,7188,7187,-1,6988,6989,7189,7188,-1,6989,6990,7190,7189,-1,6990,6991,7191,7190,-1,6991,6992,7192,7191,-1,6992,6993,7193,7192,-1,6993,6994,7194,7193,-1,6994,6995,7195,7194,-1,6995,6996,7196,7195,-1,6996,6997,7197,7196,-1,6997,6998,7198,7197,-1,6998,6999,7199,7198,-1,7,7001,7201,7200,-1,7001,7002,7202,7201,-1,7002,7003,7203,7202,-1,7003,7004,7204,7203,-1,7004,7005,7205,7204,-1,7005,7006,7206,7205,-1,7006,7007,7207,7206,-1,7007,7008,7208,7207,-1,7008,7009,7209,7208,-1,7009,7010,7210,7209,-1,7010,7011,7211,7210,-1,7011,7012,7212,7211,-1,7012,7013,7213,7212,-1,7013,7014,7214,7213,-1,7014,7015,7215,7214,-1,7015,7016,7216,7215,-1,7016,7017,7217,7216,-1,7017,7018,7218,7217,-1,7018,7019,7219,7218,-1,7019,7020,7220,7219,-1,7020,7021,7221,7220,-1,7021,7022,7222,7221,-1,7022,7023,7223,7222,-1,7023,7024,7224,7223,-1,7024,7025,7225,7224,-1,7025,7026,7226,7225,-1,7026,7027,7227,7226,-1,7027,7028,7228,7227,-1,7028,7029,7229,7228,-1,7029,7030,7230,7229,-1,7030,7031,7231,7230,-1,7031,7032,7232,7231,-1,7032,7033,7233,7232,-1,7033,7034,7234,7233,-1,7034,7035,7235,7234,-1,7035,7036,7236,7235,-1,7036,7037,7237,7236,-1,7037,7038,7238,7237,-1,7038,7039,7239,7238,-1,7039,7040,7240,7239,-1,7040,7041,7241,7240,-1,7041,7042,7242,7241,-1,7042,7043,7243,7242,-1,7043,7044,7244,7243,-1,7044,7045,7245,7244,-1,7045,7046,7246,7245,-1,7046,7047,7247,7246,-1,7047,7048,7248,7247,-1,7048,7049,7249,7248,-1,7049,7050,7250,7249,-1,7050,7051,7251,7250,-1,7051,7052,7252,7251,-1,7052,7053,7253,7252,-1,7053,7054,7254,7253,-1,7054,7055,7255,7254,-1,7055,7056,7256,7255,-1,7056,7057,7257,7256,-1,7057,7058,7258,7257,-1,7058,7059,7259,7258,-1,7059,7060,7260,7259,-1,7060,7061,7261,7260,-1,7061,7062,7262,7261,-1,7062,7063,7263,7262,-1,7063,7064,7264,7263,-1,7064,7065,7265,7264,-1,7065,7066,7266,7265,-1,7066,7067,7267,7266,-1,7067,7068,7268,7267,-1,7068,7069,7269,7268,-1,7069,7070,7270,7269,-1,7070,7071,7271,7270,-1,7071,7072,7272,7271,-1,7072,7073,7273,7272,-1,7073,7074,7274,7273,-1,7074,7075,7275,7274,-1,7075,7076,7276,7275,-1,7076,7077,7277,7276,-1,7077,7078,7278,7277,-1,7078,7079,7279,7278,-1,7079,7080,7280,7279,-1,7080,7081,7281,7280,-1,7081,7082,7282,7281,-1,7082,7083,7283,7282,-1,7083,7084,7284,7283,-1,7084,7085,7285,7284,-1,7085,7086,7286,7285,-1,7086,7087,7287,7286,-1,7087,7088,7288,7287,-1,7088,7089,7289,7288,-1,7089,7090,7290,7289,-1,7090,7091,7291,7290,-1,7091,7092,7292,7291,-1,7092,7093,7293,7292,-1,7093,7094,7294,7293,-1,7094,7095,7295,7294,-1,7095,7096,7296,7295,-1,7096,7097,7297,7296,-1,7097,7098,7298,7297,-1,7098,7099,7299,7298,-1,7099,7100,7300,7299,-1,7100,7101,7301,7300,-1,7101,7102,7302,7301,-1,7102,7103,7303,7302,-1,7103,7104,7304,7303,-1,7104,7105,7305,7304,-1,7105,7106,7306,7305,-1,7106,7107,7307,7306,-1,7107,7108,7308,7307,-1,7108,7109,7309,7308,-1,7109,7110,7310,7309,-1,7110,7111,7311,7310,-1,7111,7112,7312,7311,-1,7112,7113,7313,7312,-1,7113,7114,7314,7313,-1,7114,7115,7315,7314,-1,7115,7116,7316,7315,-1,7116,7117,7317,7316,-1,7117,7118,7318,7317,-1,7118,7119,7319,7318,-1,7119,7120,7320,7319,-1,7120,7121,7321,7320,-1,7121,7122,7322,7321,-1,7122,7123,7323,7322,-1,7123,7124,7324,7323,-1,7124,7125,7325,7324,-1,7125,7126,7326,7325,-1,7126,7127,7327,7326,-1,7127,7128,7328,7327,-1,7128,7129,7329,7328,-1,7129,7130,7330,7329,-1,7130,7131,7331,7330,-1,7131,7132,7332,7331,-1,7132,7133,7333,7332,-1,7133,7134,7334,7333,-1,7134,7135,7335,7334,-1,7135,7136,7336,7335,-1,7136,7137,7337,7336,-1,7137,7138,7338,7337,-1,7138,7139,7339,7338,-1,7139,7140,7340,7339,-1,7140,7141,7341,7340,-1,7141,7142,7342,7341,-1,7142,7143,7343,7342,-1,7143,7144,7344,7343,-1,7144,7145,7345,7344,-1,7145,7146,7346,7345,-1,7146,7147,7347,7346,-1,7147,7148,7348,7347,-1,7148,7149,7349,7348,-1,7149,7150,7350,7349,-1,7150,7151,7351,7350,-1,7151,7152,7352,7351,-1,7152,7153,7353,7352,-1,7153,7154,7354,7353,-1,7154,7155,7355,7354,-1,7155,7156,7356,7355,-1,7156,7157,7357,7356,-1,7157,7158,7358,7357,-1,7158,7159,7359,7358,-1,7159,7160,7360,7359,-1,7160,7161,7361,7360,-1,7161,7162,7362,7361,-1,7162,7163,7363,7362,-1,7163,7164,7364,7363,-1,7164,7165,7365,7364,-1,7165,7166,7366,7365,-1,7166,7167,7367,7366,-1,7167,7168,7368,7367,-1,7168,7169,7369,7368,-1,7169,7170,7370,7369,-1,7170,7171,7371,7370,-1,7171,7172,7372,7371,-1,7172,7173,7373,7372,-1,7173,7174,7374,7373,-1,7174,7175,7375,7374,-1,7175,7176,7376,7375,-1,7176,7177,7377,7376,-1,7177,7178,7378,7377,-1,7178,7179,7379,7378,-1,7179,7180,7380,7379,-1,7180,7181,7381,7380,-1,7181,7182,7382,7381,-1,7182,7183,7383,7382,-1,7183,7184,7384,7383,-1,7184,7185,7385,7384,-1,7185,7186,7386,7385,-1,7186,7187,7387,7386,-1,7187,7188,7388,7387,-1,7188,7189,7389,7388,-1,7189,7190,7390,7389,-1,7190,7191,7391,7390,-1,7191,7192,7392,7391,-1,7192,7193,7393,7392,-1,7193,7194,7394,7393,-1,7194,7195,7395,7394,-1,7195,7196,7396,7395,-1,7196,7197,7397,7396,-1,7197,7198,7398,7397,-1,7198,7199,7399,7398,-1,7200,7201,7401,7400,-1,7201,7202,7402,7401,-1,7202,7203,7403,7402,-1,7203,7204,7404,7403,-1,7204,7205,7405,7404,-1,7205,7206,7406,7405,-1,7206,7207,7407,7406,-1,7207,7208,7408,7407,-1,7208,7209,7409,7408,-1,7209,7210,7410,7409,-1,7210,7211,7411,7410,-1,7211,7212,7412,7411,-1,7212,7213,7413,7412,-1,7213,7214,7414,7413,-1,7214,7215,7415,7414,-1,7215,7216,7416,7415,-1,7216,7217,7417,7416,-1,7217,7218,7418,7417,-1,7218,7219,7419,7418,-1,7219,7220,7420,7419,-1,7220,7221,7421,7420,-1,7221,7222,7422,7421,-1,7222,7223,7423,7422,-1,7223,7224,7424,7423,-1,7224,7225,7425,7424,-1,7225,7226,7426,7425,-1,7226,7227,7427,7426,-1,7227,7228,7428,7427,-1,7228,7229,7429,7428,-1,7229,7230,7430,7429,-1,7230,7231,7431,7430,-1,7231,7232,7432,7431,-1,7232,7233,7433,7432,-1,7233,7234,7434,7433,-1,7234,7235,7435,7434,-1,7235,7236,7436,7435,-1,7236,7237,7437,7436,-1,7237,7238,7438,7437,-1,7238,7239,7439,7438,-1,7239,7240,7440,7439,-1,7240,7241,7441,7440,-1,7241,7242,7442,7441,-1,7242,7243,7443,7442,-1,7243,7244,7444,7443,-1,7244,7245,7445,7444,-1,7245,7246,7446,7445,-1,7246,7247,7447,7446,-1,7247,7248,7448,7447,-1,7248,7249,7449,7448,-1,7249,7250,7450,7449,-1,7250,7251,7451,7450,-1,7251,7252,7452,7451,-1,7252,7253,7453,7452,-1,7253,7254,7454,7453,-1,7254,7255,7455,7454,-1,7255,7256,7456,7455,-1,7256,7257,7457,7456,-1,7257,7258,7458,7457,-1,7258,7259,7459,7458,-1,7259,7260,7460,7459,-1,7260,7261,7461,7460,-1,7261,7262,7462,7461,-1,7262,7263,7463,7462,-1,7263,7264,7464,7463,-1,7264,7265,7465,7464,-1,7265,7266,7466,7465,-1,7266,7267,7467,7466,-1,7267,7268,7468,7467,-1,7268,7269,7469,7468,-1,7269,7270,7470,7469,-1,7270,7271,7471,7470,-1,7271,7272,7472,7471,-1,7272,7273,7473,7472,-1,7273,7274,7474,7473,-1,7274,7275,7475,7474,-1,7275,7276,7476,7475,-1,7276,7277,7477,7476,-1,7277,7278,7478,7477,-1,7278,7279,7479,7478,-1,7279,7280,7480,7479,-1,7280,7281,7481,7480,-1,7281,7282,7482,7481,-1,7282,7283,7483,7482,-1,7283,7284,7484,7483,-1,7284,7285,7485,7484,-1,7285,7286,7486,7485,-1,7286,7287,7487,7486,-1,7287,7288,7488,7487,-1,7288,7289,7489,7488,-1,7289,7290,7490,7489,-1,7290,7291,7491,7490,-1,7291,7292,7492,7491,-1,7292,7293,7493,7492,-1,7293,7294,7494,7493,-1,7294,7295,7495,7494,-1,7295,7296,7496,7495,-1,7296,7297,7497,7496,-1,7297,7298,7498,7497,-1,7298,7299,7499,7498,-1,7299,7300,7500,7499,-1,7300,7301,7501,7500,-1,7301,7302,7502,7501,-1,7302,7303,7503,7502,-1,7303,7304,7504,7503,-1,7304,7305,7505,7504,-1,7305,7306,7506,7505,-1,7306,7307,7507,7506,-1,7307,7308,7508,7507,-1,7308,7309,7509,7508,-1,7309,7310,7510,7509,-1,7310,7311,7511,7510,-1,7311,7312,7512,7511,-1,7312,7313,7513,7512,-1,7313,7314,7514,7513,-1,7314,7315,7515,7514,-1,7315,7316,7516,7515,-1,7316,7317,7517,7516,-1,7317,7318,7518,7517,-1,7318,7319,7519,7518,-1,7319,7320,7520,7519,-1,7320,7321,7521,7520,-1,7321,7322,7522,7521,-1,7322,7323,7523,7522,-1,7323,7324,7524,7523,-1,7324,7325,7525,7524,-1,7325,7326,7526,7525,-1,7326,7327,7527,7526,-1,7327,7328,7528,7527,-1,7328,7329,7529,7528,-1,7329,7330,7530,7529,-1,7330,7331,7531,7530,-1,7331,7332,7532,7531,-1,7332,7333,7533,7532,-1,7333,7334,7534,7533,-1,7334,7335,7535,7534,-1,7335,7336,7536,7535,-1,7336,7337,7537,7536,-1,7337,7338,7538,7537,-1,7338,7339,7539,7538,-1,7339,7340,7540,7539,-1,7340,7341,7541,7540,-1,7341,7342,7542,7541,-1,7342,7343,7543,7542,-1,7343,7344,7544,7543,-1,7344,7345,7545,7544,-1,7345,7346,7546,7545,-1,7346,7347,7547,7546,-1,7347,7348,7548,7547,-1,7348,7349,7549,7548,-1,7349,7350,7550,7549,-1,7350,7351,7551,7550,-1,7351,7352,7552,7551,-1,7352,7353,7553,7552,-1,7353,7354,7554,7553,-1,7354,7355,7555,7554,-1,7355,7356,7556,7555,-1,7356,7357,7557,7556,-1,7357,7358,7558,7557,-1,7358,7359,7559,7558,-1,7359,7360,7560,7559,-1,7360,7361,7561,7560,-1,7361,7362,7562,7561,-1,7362,7363,7563,7562,-1,7363,7364,7564,7563,-1,7364,7365,7565,7564,-1,7365,7366,7566,7565,-1,7366,7367,7567,7566,-1,7367,7368,7568,7567,-1,7368,7369,7569,7568,-1,7369,7370,7570,7569,-1,7370,7371,7571,7570,-1,7371,7372,7572,7571,-1,7372,7373,7573,7572,-1,7373,7374,7574,7573,-1,7374,7375,7575,7574,-1,7375,7376,7576,7575,-1,7376,7377,7577,7576,-1,7377,7378,7578,7577,-1,7378,7379,7579,7578,-1,7379,7380,7580,7579,-1,7380,7381,7581,7580,-1,7381,7382,7582,7581,-1,7382,7383,7583,7582,-1,7383,7384,7584,7583,-1,7384,7385,7585,7584,-1,7385,7386,7586,7585,-1,7386,7387,7587,7586,-1,7387,7388,7588,7587,-1,7388,7389,7589,7588,-1,7389,7390,7590,7589,-1,7390,7391,7591,7590,-1,7391,7392,7592,7591,-1,7392,7393,7593,7592,-1,7393,7394,7594,7593,-1,7394,7395,7595,7594,-1,7395,7396,7596,7595,-1,7396,7397,7597,7596,-1,7397,7398,7598,7597,-1,7398,7399,7599,7598,-1,7400,7401,7601,7600,-1,7401,7402,7602,7601,-1,7402,7403,7603,7602,-1,7403,7404,7604,7603,-1,7404,7405,7605,7604,-1,7405,7406,7606,7605,-1,7406,7407,7607,7606,-1,7407,7408,7608,7607,-1,7408,7409,7609,7608,-1,7409,7410,7610,7609,-1,7410,7411,7611,7610,-1,7411,7412,7612,7611,-1,7412,7413,7613,7612,-1,7413,7414,7614,7613,-1,7414,7415,7615,7614,-1,7415,7416,7616,7615,-1,7416,7417,7617,7616,-1,7417,7418,7618,7617,-1,7418,7419,7619,7618,-1,7419,7420,7620,7619,-1,7420,7421,7621,7620,-1,7421,7422,7622,7621,-1,7422,7423,7623,7622,-1,7423,7424,7624,7623,-1,7424,7425,7625,7624,-1,7425,7426,7626,7625,-1,7426,7427,7627,7626,-1,7427,7428,7628,7627,-1,7428,7429,7629,7628,-1,7429,7430,7630,7629,-1,7430,7431,7631,7630,-1,7431,7432,7632,7631,-1,7432,7433,7633,7632,-1,7433,7434,7634,7633,-1,7434,7435,7635,7634,-1,7435,7436,7636,7635,-1,7436,7437,7637,7636,-1,7437,7438,7638,7637,-1,7438,7439,7639,7638,-1,7439,7440,7640,7639,-1,7440,7441,7641,7640,-1,7441,7442,7642,7641,-1,7442,7443,7643,7642,-1,7443,7444,7644,7643,-1,7444,7445,7645,7644,-1,7445,7446,7646,7645,-1,7446,7447,7647,7646,-1,7447,7448,7648,7647,-1,7448,7449,7649,7648,-1,7449,7450,7650,7649,-1,7450,7451,7651,7650,-1,7451,7452,7652,7651,-1,7452,7453,7653,7652,-1,7453,7454,7654,7653,-1,7454,7455,7655,7654,-1,7455,7456,7656,7655,-1,7456,7457,7657,7656,-1,7457,7458,7658,7657,-1,7458,7459,7659,7658,-1,7459,7460,7660,7659,-1,7460,7461,7661,7660,-1,7461,7462,7662,7661,-1,7462,7463,7663,7662,-1,7463,7464,7664,7663,-1,7464,7465,7665,7664,-1,7465,7466,7666,7665,-1,7466,7467,7667,7666,-1,7467,7468,7668,7667,-1,7468,7469,7669,7668,-1,7469,7470,7670,7669,-1,7470,7471,7671,7670,-1,7471,7472,7672,7671,-1,7472,7473,7673,7672,-1,7473,7474,7674,7673,-1,7474,7475,7675,7674,-1,7475,7476,7676,7675,-1,7476,7477,7677,7676,-1,7477,7478,7678,7677,-1,7478,7479,7679,7678,-1,7479,7480,7680,7679,-1,7480,7481,7681,7680,-1,7481,7482,7682,7681,-1,7482,7483,7683,7682,-1,7483,7484,7684,7683,-1,7484,7485,7685,7684,-1,7485,7486,7686,7685,-1,7486,7487,7687,7686,-1,7487,7488,7688,7687,-1,7488,7489,7689,7688,-1,7489,7490,7690,7689,-1,7490,7491,7691,7690,-1,7491,7492,7692,7691,-1,7492,7493,7693,7692,-1,7493,7494,7694,7693,-1,7494,7495,7695,7694,-1,7495,7496,7696,7695,-1,7496,7497,7697,7696,-1,7497,7498,7698,7697,-1,7498,7499,7699,7698,-1,7499,7500,7700,7699,-1,7500,7501,7701,7700,-1,7501,7502,7702,7701,-1,7502,7503,7703,7702,-1,7503,7504,7704,7703,-1,7504,7505,7705,7704,-1,7505,7506,7706,7705,-1,7506,7507,7707,7706,-1,7507,7508,7708,7707,-1,7508,7509,7709,7708,-1,7509,7510,7710,7709,-1,7510,7511,7711,7710,-1,7511,7512,7712,7711,-1,7512,7513,7713,7712,-1,7513,7514,7714,7713,-1,7514,7515,7715,7714,-1,7515,7516,7716,7715,-1,7516,7517,7717,7716,-1,7517,7518,7718,7717,-1,7518,7519,7719,7718,-1,7519,7520,7720,7719,-1,7520,7521,7721,7720,-1,7521,7522,7722,7721,-1,7522,7523,7723,7722,-1,7523,7524,7724,7723,-1,7524,7525,7725,7724,-1,7525,7526,7726,7725,-1,7526,7527,7727,7726,-1,7527,7528,7728,7727,-1,7528,7529,7729,7728,-1,7529,7530,7730,7729,-1,7530,7531,7731,7730,-1,7531,7532,7732,7731,-1,7532,7533,7733,7732,-1,7533,7534,7734,7733,-1,7534,7535,7735,7734,-1,7535,7536,7736,7735,-1,7536,7537,7737,7736,-1,7537,7538,7738,7737,-1,7538,7539,7739,7738,-1,7539,7540,7740,7739,-1,7540,7541,7741,7740,-1,7541,7542,7742,7741,-1,7542,7543,7743,7742,-1,7543,7544,7744,7743,-1,7544,7545,7745,7744,-1,7545,7546,7746,7745,-1,7546,7547,7747,7746,-1,7547,7548,7748,7747,-1,7548,7549,7749,7748,-1,7549,7550,7750,7749,-1,7550,7551,7751,7750,-1,7551,7552,7752,7751,-1,7552,7553,7753,7752,-1,7553,7554,7754,7753,-1,7554,7555,7755,7754,-1,7555,7556,7756,7755,-1,7556,7557,7757,7756,-1,7557,7558,7758,7757,-1,7558,7559,7759,7758,-1,7559,7560,7760,7759,-1,7560,7561,7761,7760,-1,7561,7562,7762,7761,-1,7562,7563,7763,7762,-1,7563,7564,7764,7763,-1,7564,7565,7765,7764,-1,7565,7566,7766,7765,-1,7566,7567,7767,7766,-1,7567,7568,7768,7767,-1,7568,7569,7769,7768,-1,7569,7570,7770,7769,-1,7570,7571,7771,7770,-1,7571,7572,7772,7771,-1,7572,7573,7773,7772,-1,7573,7574,7774,7773,-1,7574,7575,7775,7774,-1,7575,7576,7776,7775,-1,7576,7577,7777,7776,-1,7577,7578,7778,7777,-1,7578,7579,7779,7778,-1,7579,7580,7780,7779,-1,7580,7581,7781,7780,-1,7581,7582,7782,7781,-1,7582,7583,7783,7782,-1,7583,7584,7784,7783,-1,7584,7585,7785,7784,-1,7585,7586,7786,7785,-1,7586,7587,7787,7786,-1,7587,7588,7788,7787,-1,7588,7589,7789,7788,-1,7589,7590,7790,7789,-1,7590,7591,7791,7790,-1,7591,7592,7792,7791,-1,7592,7593,7793,7792,-1,7593,7594,7794,7793,-1,7594,7595,7795,7794,-1,7595,7596,7796,7795,-1,7596,7597,7797,7796,-1,7597,7598,7798,7797,-1,7598,7599,7799,7798,-1,7600,7601,7801,7800,-1,7601,7602,7802,7801,-1,7602,7603,7803,7802,-1,7603,7604,7804,7803,-1,7604,7605,7805,7804,-1,7605,7606,7806,7805,-1,7606,7607,7807,7806,-1,7607,7608,7808,7807,-1,7608,7609,7809,7808,-1,7609,7610,7810,7809,-1,7610,7611,7811,7810,-1,7611,7612,7812,7811,-1,7612,7613,7813,7812,-1,7613,7614,7814,7813,-1,7614,7615,7815,7814,-1,7615,7616,7816,7815,-1,7616,7617,7817,7816,-1,7617,7618,7818,7817,-1,7618,7619,7819,7818,-1,7619,7620,7820,7819,-1,7620,7621,7821,7820,-1,7621,7622,7822,7821,-1,7622,7623,7823,7822,-1,7623,7624,7824,7823,-1,7624,7625,7825,7824,-1,7625,7626,7826,7825,-1,7626,7627,7827,7826,-1,7627,7628,7828,7827,-1,7628,7629,7829,7828,-1,7629,7630,7830,7829,-1,7630,7631,7831,7830,-1,7631,7632,7832,7831,-1,7632,7633,7833,7832,-1,7633,7634,7834,7833,-1,7634,7635,7835,7834,-1,7635,7636,7836,7835,-1,7636,7637,7837,7836,-1,7637,7638,7838,7837,-1,7638,7639,7839,7838,-1,7639,7640,7840,7839,-1,7640,7641,7841,7840,-1,7641,7642,7842,7841,-1,7642,7643,7843,7842,-1,7643,7644,7844,7843,-1,7644,7645,7845,7844,-1,7645,7646,7846,7845,-1,7646,7647,7847,7846,-1,7647,7648,7848,7847,-1,7648,7649,7849,7848,-1,7649,7650,7850,7849,-1,7650,7651,7851,7850,-1,7651,7652,7852,7851,-1,7652,7653,7853,7852,-1,7653,7654,7854,7853,-1,7654,7655,7855,7854,-1,7655,7656,7856,7855,-1,7656,7657,7857,7856,-1,7657,7658,7858,7857,-1,7658,7659,7859,7858,-1,7659,7660,7860,7859,-1,7660,7661,7861,7860,-1,7661,7662,7862,7861,-1,7662,7663,7863,7862,-1,7663,7664,7864,7863,-1,7664,7665,7865,7864,-1,7665,7666,7866,7865,-1,7666,7667,7867,7866,-1,7667,7668,7868,7867,-1,7668,7669,7869,7868,-1,7669,7670,7870,7869,-1,7670,7671,7871,7870,-1,7671,7672,7872,7871,-1,7672,7673,7873,7872,-1,7673,7674,7874,7873,-1,7674,7675,7875,7874,-1,7675,7676,7876,7875,-1,7676,7677,7877,7876,-1,7677,7678,7878,7877,-1,7678,7679,7879,7878,-1,7679,7680,7880,7879,-1,7680,7681,7881,7880,-1,7681,7682,7882,7881,-1,7682,7683,7883,7882,-1,7683,7684,7884,7883,-1,7684,7685,7885,7884,-1,7685,7686,7886,7885,-1,7686,7687,7887,7886,-1,7687,7688,7888,7887,-1,7688,7689,7889,7888,-1,7689,7690,7890,7889,-1,7690,7691,7891,7890,-1,7691,7692,7892,7891,-1,7692,7693,7893,7892,-1,7693,7694,7894,7893,-1,7694,7695,7895,7894,-1,7695,7696,7896,7895,-1,7696,7697,7897,7896,-1,7697,7698,7898,7897,-1,7698,7699,7899,7898,-1,7699,7700,7900,7899,-1,7700,7701,7901,7900,-1,7701,7702,7902,7901,-1,7702,7703,7903,7902,-1,7703,7704,7904,7903,-1,7704,7705,7905,7904,-1,7705,7706,7906,7905,-1,7706,7707,7907,7906,-1,7707,7708,7908,7907,-1,7708,7709,7909,7908,-1,7709,7710,7910,7909,-1,7710,7711,7911,7910,-1,7711,7712,7912,7911,-1,7712,7713,7913,7912,-1,7713,7714,7914,7913,-1,7714,7715,7915,7914,-1,7715,7716,7916,7915,-1,7716,7717,7917,7916,-1,7717,7718,7918,7917,-1,7718,7719,7919,7918,-1,7719,7720,7920,7919,-1,7720,7721,7921,7920,-1,7721,7722,7922,7921,-1,7722,7723,7923,7922,-1,7723,7724,7924,7923,-1,7724,7725,7925,7924,-1,7725,7726,7926,7925,-1,7726,7727,7927,7926,-1,7727,7728,7928,7927,-1,7728,7729,7929,7928,-1,7729,7730,7930,7929,-1,7730,7731,7931,7930,-1,7731,7732,7932,7931,-1,7732,7733,7933,7932,-1,7733,7734,7934,7933,-1,7734,7735,7935,7934,-1,7735,7736,7936,7935,-1,7736,7737,7937,7936,-1,7737,7738,7938,7937,-1,7738,7739,7939,7938,-1,7739,7740,7940,7939,-1,7740,7741,7941,7940,-1,7741,7742,7942,7941,-1,7742,7743,7943,7942,-1,7743,7744,7944,7943,-1,7744,7745,7945,7944,-1,7745,7746,7946,7945,-1,7746,7747,7947,7946,-1,7747,7748,7948,7947,-1,7748,7749,7949,7948,-1,7749,7750,7950,7949,-1,7750,7751,7951,7950,-1,7751,7752,7952,7951,-1,7752,7753,7953,7952,-1,7753,7754,7954,7953,-1,7754,7755,7955,7954,-1,7755,7756,7956,7955,-1,7756,7757,7957,7956,-1,7757,7758,7958,7957,-1,7758,7759,7959,7958,-1,7759,7760,7960,7959,-1,7760,7761,7961,7960,-1,7761,7762,7962,7961,-1,7762,7763,7963,7962,-1,7763,7764,7964,7963,-1,7764,7765,7965,7964,-1,7765,7766,7966,7965,-1,7766,7767,7967,7966,-1,7767,7768,7968,7967,-1,7768,7769,7969,7968,-1,7769,7770,7970,7969,-1,7770,7771,7971,7970,-1,7771,7772,7972,7971,-1,7772,7773,7973,7972,-1,7773,7774,7974,7973,-1,7774,7775,7975,7974,-1,7775,7776,7976,7975,-1,7776,7777,7977,7976,-1,7777,7778,7978,7977,-1,7778,7779,7979,7978,-1,7779,7780,7980,7979,-1,7780,7781,7981,7980,-1,7781,7782,7982,7981,-1,7782,7783,7983,7982,-1,7783,7784,7984,7983,-1,7784,7785,7985,7984,-1,7785,7786,7986,7985,-1,7786,7787,7987,7986,-1,7787,7788,7988,7987,-1,7788,7789,7989,7988,-1,7789,7790,7990,7989,-1,7790,7791,7991,7990,-1,7791,7792,7992,7991,-1,7792,7793,7993,7992,-1,7793,7794,7994,7993,-1,7794,7795,7995,7994,-1,7795,7796,7996,7995,-1,7796,7797,7997,7996,-1,7797,7798,7998,7997,-1,7798,7799,7999,7998,-1,7800,7801,8001,8,-1,7801,7802,8002,8001,-1,7802,7803,8003,8002,-1,7803,7804,8004,8003,-1,7804,7805,8005,8004,-1,7805,7806,8006,8005,-1,7806,7807,8007,8006,-1,7807,7808,8008,8007,-1,7808,7809,8009,8008,-1,7809,7810,8010,8009,-1,7810,7811,8011,8010,-1,7811,7812,8012,8011,-1,7812,7813,8013,8012,-1,7813,7814,8014,8013,-1,7814,7815,8015,8014,-1,7815,7816,8016,8015,-1,7816,7817,8017,8016,-1,7817,7818,8018,8017,-1,7818,7819,8019,8018,-1,7819,7820,8020,8019,-1,7820,7821,8021,8020,-1,7821,7822,8022,8021,-1,7822,7823,8023,8022,-1,7823,7824,8024,8023,-1,7824,7825,8025,8024,-1,7825,7826,8026,8025,-1,7826,7827,8027,8026,-1,7827,7828,8028,8027,-1,7828,7829,8029,8028,-1,7829,7830,8030,8029,-1,7830,7831,8031,8030,-1,7831,7832,8032,8031,-1,7832,7833,8033,8032,-1,7833,7834,8034,8033,-1,7834,7835,8035,8034,-1,7835,7836,8036,8035,-1,7836,7837,8037,8036,-1,7837,7838,8038,8037,-1,7838,7839,8039,8038,-1,7839,7840,8040,8039,-1,7840,7841,8041,8040,-1,7841,7842,8042,8041,-1,7842,7843,8043,8042,-1,7843,7844,8044,8043,-1,7844,7845,8045,8044,-1,7845,7846,8046,8045,-1,7846,7847,8047,8046,-1,7847,7848,8048,8047,-1,7848,7849,8049,8048,-1,7849,7850,8050,8049,-1,7850,7851,8051,8050,-1,7851,7852,8052,8051,-1,7852,7853,8053,8052,-1,7853,7854,8054,8053,-1,7854,7855,8055,8054,-1,7855,7856,8056,8055,-1,7856,7857,8057,8056,-1,7857,7858,8058,8057,-1,7858,7859,8059,8058,-1,7859,7860,8060,8059,-1,7860,7861,8061,8060,-1,7861,7862,8062,8061,-1,7862,7863,8063,8062,-1,7863,7864,8064,8063,-1,7864,7865,8065,8064,-1,7865,7866,8066,8065,-1,7866,7867,8067,8066,-1,7867,7868,8068,8067,-1,7868,7869,8069,8068,-1,7869,7870,8070,8069,-1,7870,7871,8071,8070,-1,7871,7872,8072,8071,-1,7872,7873,8073,8072,-1,7873,7874,8074,8073,-1,7874,7875,8075,8074,-1,7875,7876,8076,8075,-1,7876,7877,8077,8076,-1,7877,7878,8078,8077,-1,7878,7879,8079,8078,-1,7879,7880,8080,8079,-1,7880,7881,8081,8080,-1,7881,7882,8082,8081,-1,7882,7883,8083,8082,-1,7883,7884,8084,8083,-1,7884,7885,8085,8084,-1,7885,7886,8086,8085,-1,7886,7887,8087,8086,-1,7887,7888,8088,8087,-1,7888,7889,8089,8088,-1,7889,7890,8090,8089,-1,7890,7891,8091,8090,-1,7891,7892,8092,8091,-1,7892,7893,8093,8092,-1,7893,7894,8094,8093,-1,7894,7895,8095,8094,-1,7895,7896,8096,8095,-1,7896,7897,8097,8096,-1,7897,7898,8098,8097,-1,7898,7899,8099,8098,-1,7899,7900,8100,8099,-1,7900,7901,8101,8100,-1,7901,7902,8102,8101,-1,7902,7903,8103,8102,-1,7903,7904,8104,8103,-1,7904,7905,8105,8104,-1,7905,7906,8106,8105,-1,7906,7907,8107,8106,-1,7907,7908,8108,8107,-1,7908,7909,8109,8108,-1,7909,7910,8110,8109,-1,7910,7911,8111,8110,-1,7911,7912,8112,8111,-1,7912,7913,8113,8112,-1,7913,7914,8114,8113,-1,7914,7915,8115,8114,-1,7915,7916,8116,8115,-1,7916,7917,8117,8116,-1,7917,7918,8118,8117,-1,7918,7919,8119,8118,-1,7919,7920,8120,8119,-1,7920,7921,8121,8120,-1,7921,7922,8122,8121,-1,7922,7923,8123,8122,-1,7923,7924,8124,8123,-1,7924,7925,8125,8124,-1,7925,7926,8126,8125,-1,7926,7927,8127,8126,-1,7927,7928,8128,8127,-1,7928,7929,8129,8128,-1,7929,7930,8130,8129,-1,7930,7931,8131,8130,-1,7931,7932,8132,8131,-1,7932,7933,8133,8132,-1,7933,7934,8134,8133,-1,7934,7935,8135,8134,-1,7935,7936,8136,8135,-1,7936,7937,8137,8136,-1,7937,7938,8138,8137,-1,7938,7939,8139,8138,-1,7939,7940,8140,8139,-1,7940,7941,8141,8140,-1,7941,7942,8142,8141,-1,7942,7943,8143,8142,-1,7943,7944,8144,8143,-1,7944,7945,8145,8144,-1,7945,7946,8146,8145,-1,7946,7947,8147,8146,-1,7947,7948,8148,8147,-1,7948,7949,8149,8148,-1,7949,7950,8150,8149,-1,7950,7951,8151,8150,-1,7951,7952,8152,8151,-1,7952,7953,8153,8152,-1,7953,7954,8154,8153,-1,7954,7955,8155,8154,-1,7955,7956,8156,8155,-1,7956,7957,8157,8156,-1,7957,7958,8158,8157,-1,7958,7959,8159,8158,-1,7959,7960,8160,8159,-1,7960,7961,8161,8160,-1,7961,7962,8162,8161,-1,7962,7963,8163,8162,-1,7963,7964,8164,8163,-1,7964,7965,8165,8164,-1,7965,7966,8166,8165,-1,7966,7967,8167,8166,-1,7967,7968,8168,8167,-1,7968,7969,8169,8168,-1,7969,7970,8170,8169,-1,7970,7971,8171,8170,-1,7971,7972,8172,8171,-1,7972,7973,8173,8172,-1,7973,7974,8174,8173,-1,7974,7975,8175,8174,-1,7975,7976,8176,8175,-1,7976,7977,8177,8176,-1,7977,7978,8178,8177,-1,7978,7979,8179,8178,-1,7979,7980,8180,8179,-1,7980,7981,8181,8180,-1,7981,7982,8182,8181,-1,7982,7983,8183,8182,-1,7983,7984,8184,8183,-1,7984,7985,8185,8184,-1,7985,7986,8186,8185,-1,7986,7987,8187,8186,-1,7987,7988,8188,8187,-1,7988,7989,8189,8188,-1,7989,7990,8190,8189,-1,7990,7991,8191,8190,-1,7991,7992,8192,8191,-1,7992,7993,8193,8192,-1,7993,7994,8194,8193,-1,7994,7995,8195,8194,-1,7995,7996,8196,8195,-1,7996,7997,8197,8196,-1,7997,7998,8198,8197,-1,7998,7999,8199,8198,-1,8,8001,8201,8200,-1,8001,8002,8202,8201,-1,8002,8003,8203,8202,-1,8003,8004,8204,8203,-1,8004,8005,8205,8204,-1,8005,8006,8206,8205,-1,8006,8007,8207,8206,-1,8007,8008,8208,8207,-1,8008,8009,8209,8208,-1,8009,8010,8210,8209,-1,8010,8011,8211,8210,-1,8011,8012,8212,8211,-1,8012,8013,8213,8212,-1,8013,8014,8214,8213,-1,8014,8015,8215,8214,-1,8015,8016,8216,8215,-1,8016,8017,8217,8216,-1,8017,8018,8218,8217,-1,8018,8019,8219,8218,-1,8019,8020,8220,8219,-1,8020,8021,8221,8220,-1,8021,8022,8222,8221,-1,8022,8023,8223,8222,-1,8023,8024,8224,8223,-1,8024,8025,8225,8224,-1,8025,8026,8226,8225,-1,8026,8027,8227,8226,-1,8027,8028,8228,8227,-1,8028,8029,8229,8228,-1,8029,8030,8230,8229,-1,8030,8031,8231,8230,-1,8031,8032,8232,8231,-1,8032,8033,8233,8232,-1,8033,8034,8234,8233,-1,8034,8035,8235,8234,-1,8035,8036,8236,8235,-1,8036,8037,8237,8236,-1,8037,8038,8238,8237,-1,8038,8039,8239,8238,-1,8039,8040,8240,8239,-1,8040,8041,8241,8240,-1,8041,8042,8242,8241,-1,8042,8043,8243,8242,-1,8043,8044,8244,8243,-1,8044,8045,8245,8244,-1,8045,8046,8246,8245,-1,8046,8047,8247,8246,-1,8047,8048,8248,8247,-1,8048,8049,8249,8248,-1,8049,8050,8250,8249,-1,8050,8051,8251,8250,-1,8051,8052,8252,8251,-1,8052,8053,8253,8252,-1,8053,8054,8254,8253,-1,8054,8055,8255,8254,-1,8055,8056,8256,8255,-1,8056,8057,8257,8256,-1,8057,8058,8258,8257,-1,8058,8059,8259,8258,-1,8059,8060,8260,8259,-1,8060,8061,8261,8260,-1,8061,8062,8262,8261,-1,8062,8063,8263,8262,-1,8063,8064,8264,8263,-1,8064,8065,8265,8264,-1,8065,8066,8266,8265,-1,8066,8067,8267,8266,-1,8067,8068,8268,8267,-1,8068,8069,8269,8268,-1,8069,8070,8270,8269,-1,8070,8071,8271,8270,-1,8071,8072,8272,8271,-1,8072,8073,8273,8272,-1,8073,8074,8274,8273,-1,8074,8075,8275,8274,-1,8075,8076,8276,8275,-1,8076,8077,8277,8276,-1,8077,8078,8278,8277,-1,8078,8079,8279,8278,-1,8079,8080,8280,8279,-1,8080,8081,8281,8280,-1,8081,8082,8282,8281,-1,8082,8083,8283,8282,-1,8083,8084,8284,8283,-1,8084,8085,8285,8284,-1,8085,8086,8286,8285,-1,8086,8087,8287,8286,-1,8087,8088,8288,8287,-1,8088,8089,8289,8288,-1,8089,8090,8290,8289,-1,8090,8091,8291,8290,-1,8091,8092,8292,8291,-1,8092,8093,8293,8292,-1,8093,8094,8294,8293,-1,8094,8095,8295,8294,-1,8095,8096,8296,8295,-1,8096,8097,8297,8296,-1,8097,8098,8298,8297,-1,8098,8099,8299,8298,-1,8099,8100,8300,8299,-1,8100,8101,8301,8300,-1,8101,8102,8302,8301,-1,8102,8103,8303,8302,-1,8103,8104,8304,8303,-1,8104,8105,8305,8304,-1,8105,8106,8306,8305,-1,8106,8107,8307,8306,-1,8107,8108,8308,8307,-1,8108,8109,8309,8308,-1,8109,8110,8310,8309,-1,8110,8111,8311,8310,-1,8111,8112,8312,8311,-1,8112,8113,8313,8312,-1,8113,8114,8314,8313,-1,8114,8115,8315,8314,-1,8115,8116,8316,8315,-1,8116,8117,8317,8316,-1,8117,8118,8318,8317,-1,8118,8119,8319,8318,-1,8119,8120,8320,8319,-1,8120,8121,8321,8320,-1,8121,8122,8322,8321,-1,8122,8123,8323,8322,-1,8123,8124,8324,8323,-1,8124,8125,8325,8324,-1,8125,8126,8326,8325,-1,8126,8127,8327,8326,-1,8127,8128,8328,8327,-1,8128,8129,8329,8328,-1,8129,8130,8330,8329,-1,8130,8131,8331,8330,-1,8131,8132,8332,8331,-1,8132,8133,8333,8332,-1,8133,8134,8334,8333,-1,8134,8135,8335,8334,-1,8135,8136,8336,8335,-1,8136,8137,8337,8336,-1,8137,8138,8338,8337,-1,8138,8139,8339,8338,-1,8139,8140,8340,8339,-1,8140,8141,8341,8340,-1,8141,8142,8342,8341,-1,8142,8143,8343,8342,-1,8143,8144,8344,8343,-1,8144,8145,8345,8344,-1,8145,8146,8346,8345,-1,8146,8147,8347,8346,-1,8147,8148,8348,8347,-1,8148,8149,8349,8348,-1,8149,8150,8350,8349,-1,8150,8151,8351,8350,-1,8151,8152,8352,8351,-1,8152,8153,8353,8352,-1,8153,8154,8354,8353,-1,8154,8155,8355,8354,-1,8155,8156,8356,8355,-1,8156,8157,8357,8356,-1,8157,8158,8358,8357,-1,8158,8159,8359,8358,-1,8159,8160,8360,8359,-1,8160,8161,8361,8360,-1,8161,8162,8362,8361,-1,8162,8163,8363,8362,-1,8163,8164,8364,8363,-1,8164,8165,8365,8364,-1,8165,8166,8366,8365,-1,8166,8167,8367,8366,-1,8167,8168,8368,8367,-1,8168,8169,8369,8368,-1,8169,8170,8370,8369,-1,8170,8171,8371,8370,-1,8171,8172,8372,8371,-1,8172,8173,8373,8372,-1,8173,8174,8374,8373,-1,8174,8175,8375,8374,-1,8175,8176,8376,8375,-1,8176,8177,8377,8376,-1,8177,8178,8378,8377,-1,8178,8179,8379,8378,-1,8179,8180,8380,8379,-1,8180,8181,8381,8380,-1,8181,8182,8382,8381,-1,8182,8183,8383,8382,-1,8183,8184,8384,8383,-1,8184,8185,8385,8384,-1,8185,8186,8386,8385,-1,8186,8187,8387,8386,-1,8187,8188,8388,8387,-1,8188,8189,8389,8388,-1,8189,8190,8390,8389,-1,8190,8191,8391,8390,-1,8191,8192,8392,8391,-1,8192,8193,8393,8392,-1,8193,8194,8394,8393,-1,8194,8195,8395,8394,-1,8195,8196,8396,8395,-1,8196,8197,8397,8396,-1,8197,8198,8398,8397,-1,8198,8199,8399,8398,-1,8200,8201,8401,8400,-1,8201,8202,8402,8401,-1,8202,8203,8403,8402,-1,8203,8204,8404,8403,-1,8204,8205,8405,8404,-1,8205,8206,8406,8405,-1,8206,8207,8407,8406,-1,8207,8208,8408,8407,-1,8208,8209,8409,8408,-1,8209,8210,8410,8409,-1,8210,8211,8411,8410,-1,8211,8212,8412,8411,-1,8212,8213,8413,8412,-1,8213,8214,8414,8413,-1,8214,8215,8415,8414,-1,8215,8216,8416,8415,-1,8216,8217,8417,8416,-1,8217,8218,8418,8417,-1,8218,8219,8419,8418,-1,8219,8220,8420,8419,-1,8220,8221,8421,8420,-1,8221,8222,8422,8421,-1,8222,8223,8423,8422,-1,8223,8224,8424,8423,-1,8224,8225,8425,8424,-1,8225,8226,8426,8425,-1,8226,8227,8427,8426,-1,8227,8228,8428,8427,-1,8228,8229,8429,8428,-1,8229,8230,8430,8429,-1,8230,8231,8431,8430,-1,8231,8232,8432,8431,-1,8232,8233,8433,8432,-1,8233,8234,8434,8433,-1,8234,8235,8435,8434,-1,8235,8236,8436,8435,-1,8236,8237,8437,8436,-1,8237,8238,8438,8437,-1,8238,8239,8439,8438,-1,8239,8240,8440,8439,-1,8240,8241,8441,8440,-1,8241,8242,8442,8441,-1,8242,8243,8443,8442,-1,8243,8244,8444,8443,-1,8244,8245,8445,8444,-1,8245,8246,8446,8445,-1,8246,8247,8447,8446,-1,8247,8248,8448,8447,-1,8248,8249,8449,8448,-1,8249,8250,8450,8449,-1,8250,8251,8451,8450,-1,8251,8252,8452,8451,-1,8252,8253,8453,8452,-1,8253,8254,8454,8453,-1,8254,8255,8455,8454,-1,8255,8256,8456,8455,-1,8256,8257,8457,8456,-1,8257,8258,8458,8457,-1,8258,8259,8459,8458,-1,8259,8260,8460,8459,-1,8260,8261,8461,8460,-1,8261,8262,8462,8461,-1,8262,8263,8463,8462,-1,8263,8264,8464,8463,-1,8264,8265,8465,8464,-1,8265,8266,8466,8465,-1,8266,8267,8467,8466,-1,8267,8268,8468,8467,-1,8268,8269,8469,8468,-1,8269,8270,8470,8469,-1,8270,8271,8471,8470,-1,8271,8272,8472,8471,-1,8272,8273,8473,8472,-1,8273,8274,8474,8473,-1,8274,8275,8475,8474,-1,8275,8276,8476,8475,-1,8276,8277,8477,8476,-1,8277,8278,8478,8477,-1,8278,8279,8479,8478,-1,8279,8280,8480,8479,-1,8280,8281,8481,8480,-1,8281,8282,8482,8481,-1,8282,8283,8483,8482,-1,8283,8284,8484,8483,-1,8284,8285,8485,8484,-1,8285,8286,8486,8485,-1,8286,8287,8487,8486,-1,8287,8288,8488,8487,-1,8288,8289,8489,8488,-1,8289,8290,8490,8489,-1,8290,8291,8491,8490,-1,8291,8292,8492,8491,-1,8292,8293,8493,8492,-1,8293,8294,8494,8493,-1,8294,8295,8495,8494,-1,8295,8296,8496,8495,-1,8296,8297,8497,8496,-1,8297,8298,8498,8497,-1,8298,8299,8499,8498,-1,8299,8300,8500,8499,-1,8300,8301,8501,8500,-1,8301,8302,8502,8501,-1,8302,8303,8503,8502,-1,8303,8304,8504,8503,-1,8304,8305,8505,8504,-1,8305,8306,8506,8505,-1,8306,8307,8507,8506,-1,8307,8308,8508,8507,-1,8308,8309,8509,8508,-1,8309,8310,8510,8509,-1,8310,8311,8511,8510,-1,8311,8312,8512,8511,-1,8312,8313,8513,8512,-1,8313,8314,8514,8513,-1,8314,8315,8515,8514,-1,8315,8316,8516,8515,-1,8316,8317,8517,8516,-1,8317,8318,8518,8517,-1,8318,8319,8519,8518,-1,8319,8320,8520,8519,-1,8320,8321,8521,8520,-1,8321,8322,8522,8521,-1,8322,8323,8523,8522,-1,8323,8324,8524,8523,-1,8324,8325,8525,8524,-1,8325,8326,8526,8525,-1,8326,8327,8527,8526,-1,8327,8328,8528,8527,-1,8328,8329,8529,8528,-1,8329,8330,8530,8529,-1,8330,8331,8531,8530,-1,8331,8332,8532,8531,-1,8332,8333,8533,8532,-1,8333,8334,8534,8533,-1,8334,8335,8535,8534,-1,8335,8336,8536,8535,-1,8336,8337,8537,8536,-1,8337,8338,8538,8537,-1,8338,8339,8539,8538,-1,8339,8340,8540,8539,-1,8340,8341,8541,8540,-1,8341,8342,8542,8541,-1,8342,8343,8543,8542,-1,8343,8344,8544,8543,-1,8344,8345,8545,8544,-1,8345,8346,8546,8545,-1,8346,8347,8547,8546,-1,8347,8348,8548,8547,-1,8348,8349,8549,8548,-1,8349,8350,8550,8549,-1,8350,8351,8551,8550,-1,8351,8352,8552,8551,-1,8352,8353,8553,8552,-1,8353,8354,8554,8553,-1,8354,8355,8555,8554,-1,8355,8356,8556,8555,-1,8356,8357,8557,8556,-1,8357,8358,8558,8557,-1,8358,8359,8559,8558,-1,8359,8360,8560,8559,-1,8360,8361,8561,8560,-1,8361,8362,8562,8561,-1,8362,8363,8563,8562,-1,8363,8364,8564,8563,-1,8364,8365,8565,8564,-1,8365,8366,8566,8565,-1,8366,8367,8567,8566,-1,8367,8368,8568,8567,-1,8368,8369,8569,8568,-1,8369,8370,8570,8569,-1,8370,8371,8571,8570,-1,8371,8372,8572,8571,-1,8372,8373,8573,8572,-1,8373,8374,8574,8573,-1,8374,8375,8575,8574,-1,8375,8376,8576,8575,-1,8376,8377,8577,8576,-1,8377,8378,8578,8577,-1,8378,8379,8579,8578,-1,8379,8380,8580,8579,-1,8380,8381,8581,8580,-1,8381,8382,8582,8581,-1,8382,8383,8583,8582,-1,8383,8384,8584,8583,-1,8384,8385,8585,8584,-1,8385,8386,8586,8585,-1,8386,8387,8587,8586,-1,8387,8388,8588,8587,-1,8388,8389,8589,8588,-1,8389,8390,8590,8589,-1,8390,8391,8591,8590,-1,8391,8392,8592,8591,-1,8392,8393,8593,8592,-1,8393,8394,8594,8593,-1,8394,8395,8595,8594,-1,8395,8396,8596,8595,-1,8396,8397,8597,8596,-1,8397,8398,8598,8597,-1,8398,8399,8599,8598,-1,8400,8401,8601,8600,-1,8401,8402,8602,8601,-1,8402,8403,8603,8602,-1,8403,8404,8604,8603,-1,8404,8405,8605,8604,-1,8405,8406,8606,8605,-1,8406,8407,8607,8606,-1,8407,8408,8608,8607,-1,8408,8409,8609,8608,-1,8409,8410,8610,8609,-1,8410,8411,8611,8610,-1,8411,8412,8612,8611,-1,8412,8413,8613,8612,-1,8413,8414,8614,8613,-1,8414,8415,8615,8614,-1,8415,8416,8616,8615,-1,8416,8417,8617,8616,-1,8417,8418,8618,8617,-1,8418,8419,8619,8618,-1,8419,8420,8620,8619,-1,8420,8421,8621,8620,-1,8421,8422,8622,8621,-1,8422,8423,8623,8622,-1,8423,8424,8624,8623,-1,8424,8425,8625,8624,-1,8425,8426,8626,8625,-1,8426,8427,8627,8626,-1,8427,8428,8628,8627,-1,8428,8429,8629,8628,-1,8429,8430,8630,8629,-1,8430,8431,8631,8630,-1,8431,8432,8632,8631,-1,8432,8433,8633,8632,-1,8433,8434,8634,8633,-1,8434,8435,8635,8634,-1,8435,8436,8636,8635,-1,8436,8437,8637,8636,-1,8437,8438,8638,8637,-1,8438,8439,8639,8638,-1,8439,8440,8640,8639,-1,8440,8441,8641,8640,-1,8441,8442,8642,8641,-1,8442,8443,8643,8642,-1,8443,8444,8644,8643,-1,8444,8445,8645,8644,-1,8445,8446,8646,8645,-1,8446,8447,8647,8646,-1,8447,8448,8648,8647,-1,8448,8449,8649,8648,-1,8449,8450,8650,8649,-1,8450,8451,8651,8650,-1,8451,8452,8652,8651,-1,8452,8453,8653,8652,-1,8453,8454,8654,8653,-1,8454,8455,8655,8654,-1,8455,8456,8656,8655,-1,8456,8457,8657,8656,-1,8457,8458,8658,8657,-1,8458,8459,8659,8658,-1,8459,8460,8660,8659,-1,8460,8461,8661,8660,-1,8461,8462,8662,8661,-1,8462,8463,8663,8662,-1,8463,8464,8664,8663,-1,8464,8465,8665,8664,-1,8465,8466,8666,8665,-1,8466,8467,8667,8666,-1,8467,8468,8668,8667,-1,8468,8469,8669,8668,-1,8469,8470,8670,8669,-1,8470,8471,8671,8670,-1,8471,8472,8672,8671,-1,8472,8473,8673,8672,-1,8473,8474,8674,8673,-1,8474,8475,8675,8674,-1,8475,8476,8676,8675,-1,8476,8477,8677,8676,-1,8477,8478,8678,8677,-1,8478,8479,8679,8678,-1,8479,8480,8680,8679,-1,8480,8481,8681,8680,-1,8481,8482,8682,8681,-1,8482,8483,8683,8682,-1,8483,8484,8684,8683,-1,8484,8485,8685,8684,-1,8485,8486,8686,8685,-1,8486,8487,8687,8686,-1,8487,8488,8688,8687,-1,8488,8489,8689,8688,-1,8489,8490,8690,8689,-1,8490,8491,8691,8690,-1,8491,8492,8692,8691,-1,8492,8493,8693,8692,-1,8493,8494,8694,8693,-1,8494,8495,8695,8694,-1,8495,8496,8696,8695,-1,8496,8497,8697,8696,-1,8497,8498,8698,8697,-1,8498,8499,8699,8698,-1,8499,8500,8700,8699,-1,8500,8501,8701,8700,-1,8501,8502,8702,8701,-1,8502,8503,8703,8702,-1,8503,8504,8704,8703,-1,8504,8505,8705,8704,-1,8505,8506,8706,8705,-1,8506,8507,8707,8706,-1,8507,8508,8708,8707,-1,8508,8509,8709,8708,-1,8509,8510,8710,8709,-1,8510,8511,8711,8710,-1,8511,8512,8712,8711,-1,8512,8513,8713,8712,-1,8513,8514,8714,8713,-1,8514,8515,8715,8714,-1,8515,8516,8716,8715,-1,8516,8517,8717,8716,-1,8517,8518,8718,8717,-1,8518,8519,8719,8718,-1,8519,8520,8720,8719,-1,8520,8521,8721,8720,-1,8521,8522,8722,8721,-1,8522,8523,8723,8722,-1,8523,8524,8724,8723,-1,8524,8525,8725,8724,-1,8525,8526,8726,8725,-1,8526,8527,8727,8726,-1,8527,8528,8728,8727,-1,8528,8529,8729,8728,-1,8529,8530,8730,8729,-1,8530,8531,8731,8730,-1,8531,8532,8732,8731,-1,8532,8533,8733,8732,-1,8533,8534,8734,8733,-1,8534,8535,8735,8734,-1,8535,8536,8736,8735,-1,8536,8537,8737,8736,-1,8537,8538,8738,8737,-1,8538,8539,8739,8738,-1,8539,8540,8740,8739,-1,8540,8541,8741,8740,-1,8541,8542,8742,8741,-1,8542,8543,8743,8742,-1,8543,8544,8744,8743,-1,8544,8545,8745,8744,-1,8545,8546,8746,8745,-1,8546,8547,8747,8746,-1,8547,8548,8748,8747,-1,8548,8549,8749,8748,-1,8549,8550,8750,8749,-1,8550,8551,8751,8750,-1,8551,8552,8752,8751,-1,8552,8553,8753,8752,-1,8553,8554,8754,8753,-1,8554,8555,8755,8754,-1,8555,8556,8756,8755,-1,8556,8557,8757,8756,-1,8557,8558,8758,8757,-1,8558,8559,8759,8758,-1,8559,8560,8760,8759,-1,8560,8561,8761,8760,-1,8561,8562,8762,8761,-1,8562,8563,8763,8762,-1,8563,8564,8764,8763,-1,8564,8565,8765,8764,-1,8565,8566,8766,8765,-1,8566,8567,8767,8766,-1,8567,8568,8768,8767,-1,8568,8569,8769,8768,-1,8569,8570,8770,8769,-1,8570,8571,8771,8770,-1,8571,8572,8772,8771,-1,8572,8573,8773,8772,-1,8573,8574,8774,8773,-1,8574,8575,8775,8774,-1,8575,8576,8776,8775,-1,8576,8577,8777,8776,-1,8577,8578,8778,8777,-1,8578,8579,8779,8778,-1,8579,8580,8780,8779,-1,8580,8581,8781,8780,-1,8581,8582,8782,8781,-1,8582,8583,8783,8782,-1,8583,8584,8784,8783,-1,8584,8585,8785,8784,-1,8585,8586,8786,8785,-1,8586,8587,8787,8786,-1,8587,8588,8788,8787,-1,8588,8589,8789,8788,-1,8589,8590,8790,8789,-1,8590,8591,8791,8790,-1,8591,8592,8792,8791,-1,8592,8593,8793,8792,-1,8593,8594,8794,8793,-1,8594,8595,8795,8794,-1,8595,8596,8796,8795,-1,8596,8597,8797,8796,-1,8597,8598,8798,8797,-1,8598,8599,8799,8798,-1,8600,8601,8801,8800,-1,8601,8602,8802,8801,-1,8602,8603,8803,8802,-1,8603,8604,8804,8803,-1,8604,8605,8805,8804,-1,8605,8606,8806,8805,-1,8606,8607,8807,8806,-1,8607,8608,8808,8807,-1,8608,8609,8809,8808,-1,8609,8610,8810,8809,-1,8610,8611,8811,8810,-1,8611,8612,8812,8811,-1,8612,8613,8813,8812,-1,8613,8614,8814,8813,-1,8614,8615,8815,8814,-1,8615,8616,8816,8815,-1,8616,8617,8817,8816,-1,8617,8618,8818,8817,-1,8618,8619,8819,8818,-1,8619,8620,8820,8819,-1,8620,8621,8821,8820,-1,8621,8622,8822,8821,-1,8622,8623,8823,8822,-1,8623,8624,8824,8823,-1,8624,8625,8825,8824,-1,8625,8626,8826,8825,-1,8626,8627,8827,8826,-1,8627,8628,8828,8827,-1,8628,8629,8829,8828,-1,8629,8630,8830,8829,-1,8630,8631,8831,8830,-1,8631,8632,8832,8831,-1,8632,8633,8833,8832,-1,8633,8634,8834,8833,-1,8634,8635,8835,8834,-1,8635,8636,8836,8835,-1,8636,8637,8837,8836,-1,8637,8638,8838,8837,-1,8638,8639,8839,8838,-1,8639,8640,8840,8839,-1,8640,8641,8841,8840,-1,8641,8642,8842,8841,-1,8642,8643,8843,8842,-1,8643,8644,8844,8843,-1,8644,8645,8845,8844,-1,8645,8646,8846,8845,-1,8646,8647,8847,8846,-1,8647,8648,8848,8847,-1,8648,8649,8849,8848,-1,8649,8650,8850,8849,-1,8650,8651,8851,8850,-1,8651,8652,8852,8851,-1,8652,8653,8853,8852,-1,8653,8654,8854,8853,-1,8654,8655,8855,8854,-1,8655,8656,8856,8855,-1,8656,8657,8857,8856,-1,8657,8658,8858,8857,-1,8658,8659,8859,8858,-1,8659,8660,8860,8859,-1,8660,8661,8861,8860,-1,8661,8662,8862,8861,-1,8662,8663,8863,8862,-1,8663,8664,8864,8863,-1,8664,8665,8865,8864,-1,8665,8666,8866,8865,-1,8666,8667,8867,8866,-1,8667,8668,8868,8867,-1,8668,8669,8869,8868,-1,8669,8670,8870,8869,-1,8670,8671,8871,8870,-1,8671,8672,8872,8871,-1,8672,8673,8873,8872,-1,8673,8674,8874,8873,-1,8674,8675,8875,8874,-1,8675,8676,8876,8875,-1,8676,8677,8877,8876,-1,8677,8678,8878,8877,-1,8678,8679,8879,8878,-1,8679,8680,8880,8879,-1,8680,8681,8881,8880,-1,8681,8682,8882,8881,-1,8682,8683,8883,8882,-1,8683,8684,8884,8883,-1,8684,8685,8885,8884,-1,8685,8686,8886,8885,-1,8686,8687,8887,8886,-1,8687,8688,8888,8887,-1,8688,8689,8889,8888,-1,8689,8690,8890,8889,-1,8690,8691,8891,8890,-1,8691,8692,8892,8891,-1,8692,8693,8893,8892,-1,8693,8694,8894,8893,-1,8694,8695,8895,8894,-1,8695,8696,8896,8895,-1,8696,8697,8897,8896,-1,8697,8698,8898,8897,-1,8698,8699,8899,8898,-1,8699,8700,8900,8899,-1,8700,8701,8901,8900,-1,8701,8702,8902,8901,-1,8702,8703,8903,8902,-1,8703,8704,8904,8903,-1,8704,8705,8905,8904,-1,8705,8706,8906,8905,-1,8706,8707,8907,8906,-1,8707,8708,8908,8907,-1,8708,8709,8909,8908,-1,8709,8710,8910,8909,-1,8710,8711,8911,8910,-1,8711,8712,8912,8911,-1,8712,8713,8913,8912,-1,8713,8714,8914,8913,-1,8714,8715,8915,8914,-1,8715,8716,8916,8915,-1,8716,8717,8917,8916,-1,8717,8718,8918,8917,-1,8718,8719,8919,8918,-1,8719,8720,8920,8919,-1,8720,8721,8921,8920,-1,8721,8722,8922,8921,-1,8722,8723,8923,8922,-1,8723,8724,8924,8923,-1,8724,8725,8925,8924,-1,8725,8726,8926,8925,-1,8726,8727,8927,8926,-1,8727,8728,8928,8927,-1,8728,8729,8929,8928,-1,8729,8730,8930,8929,-1,8730,8731,8931,8930,-1,8731,8732,8932,8931,-1,8732,8733,8933,8932,-1,8733,8734,8934,8933,-1,8734,8735,8935,8934,-1,8735,8736,8936,8935,-1,8736,8737,8937,8936,-1,8737,8738,8938,8937,-1,8738,8739,8939,8938,-1,8739,8740,8940,8939,-1,8740,8741,8941,8940,-1,8741,8742,8942,8941,-1,8742,8743,8943,8942,-1,8743,8744,8944,8943,-1,8744,8745,8945,8944,-1,8745,8746,8946,8945,-1,8746,8747,8947,8946,-1,8747,8748,8948,8947,-1,8748,8749,8949,8948,-1,8749,8750,8950,8949,-1,8750,8751,8951,8950,-1,8751,8752,8952,8951,-1,8752,8753,8953,8952,-1,8753,8754,8954,8953,-1,8754,8755,8955,8954,-1,8755,8756,8956,8955,-1,8756,8757,8957,8956,-1,8757,8758,8958,8957,-1,8758,8759,8959,8958,-1,8759,8760,8960,8959,-1,8760,8761,8961,8960,-1,8761,8762,8962,8961,-1,8762,8763,8963,8962,-1,8763,8764,8964,8963,-1,8764,8765,8965,8964,-1,8765,8766,8966,8965,-1,8766,8767,8967,8966,-1,8767,8768,8968,8967,-1,8768,8769,8969,8968,-1,8769,8770,8970,8969,-1,8770,8771,8971,8970,-1,8771,8772,8972,8971,-1,8772,8773,8973,8972,-1,8773,8774,8974,8973,-1,8774,8775,8975,8974,-1,8775,8776,8976,8975,-1,8776,8777,8977,8976,-1,8777,8778,8978,8977,-1,8778,8779,8979,8978,-1,8779,8780,8980,8979,-1,8780,8781,8981,8980,-1,8781,8782,8982,8981,-1,8782,8783,8983,8982,-1,8783,8784,8984,8983,-1,8784,8785,8985,8984,-1,8785,8786,8986,8985,-1,8786,8787,8987,8986,-1,8787,8788,8988,8987,-1,8788,8789,8989,8988,-1,8789,8790,8990,8989,-1,8790,8791,8991,8990,-1,8791,8792,8992,8991,-1,8792,8793,8993,8992,-1,8793,8794,8994,8993,-1,8794,8795,8995,8994,-1,8795,8796,8996,8995,-1,8796,8797,8997,8996,-1,8797,8798,8998,8997,-1,8798,8799,8999,8998,-1,8800,8801,9001,9,-1,8801,8802,9002,9001,-1,8802,8803,9003,9002,-1,8803,8804,9004,9003,-1,8804,8805,9005,9004,-1,8805,8806,9006,9005,-1,8806,8807,9007,9006,-1,8807,8808,9008,9007,-1,8808,8809,9009,9008,-1,8809,8810,9010,9009,-1,8810,8811,9011,9010,-1,8811,8812,9012,9011,-1,8812,8813,9013,9012,-1,8813,8814,9014,9013,-1,8814,8815,9015,9014,-1,8815,8816,9016,9015,-1,8816,8817,9017,9016,-1,8817,8818,9018,9017,-1,8818,8819,9019,9018,-1,8819,8820,9020,9019,-1,8820,8821,9021,9020,-1,8821,8822,9022,9021,-1,8822,8823,9023,9022,-1,8823,8824,9024,9023,-1,8824,8825,9025,9024,-1,8825,8826,9026,9025,-1,8826,8827,9027,9026,-1,8827,8828,9028,9027,-1,8828,8829,9029,9028,-1,8829,8830,9030,9029,-1,8830,8831,9031,9030,-1,8831,8832,9032,9031,-1,8832,8833,9033,9032,-1,8833,8834,9034,9033,-1,8834,8835,9035,9034,-1,8835,8836,9036,9035,-1,8836,8837,9037,9036,-1,8837,8838,9038,9037,-1,8838,8839,9039,9038,-1,8839,8840,9040,9039,-1,8840,8841,9041,9040,-1,8841,8842,9042,9041,-1,8842,8843,9043,9042,-1,8843,8844,9044,9043,-1,8844,8845,9045,9044,-1,8845,8846,9046,9045,-1,8846,8847,9047,9046,-1,8847,8848,9048,9047,-1,8848,8849,9049,9048,-1,8849,8850,9050,9049,-1,8850,8851,9051,9050,-1,8851,8852,9052,9051,-1,8852,8853,9053,9052,-1,8853,8854,9054,9053,-1,8854,8855,9055,9054,-1,8855,8856,9056,9055,-1,8856,8857,9057,9056,-1,8857,8858,9058,9057,-1,8858,8859,9059,9058,-1,8859,8860,9060,9059,-1,8860,8861,9061,9060,-1,8861,8862,9062,9061,-1,8862,8863,9063,9062,-1,8863,8864,9064,9063,-1,8864,8865,9065,9064,-1,8865,8866,9066,9065,-1,8866,8867,9067,9066,-1,8867,8868,9068,9067,-1,8868,8869,9069,9068,-1,8869,8870,9070,9069,-1,8870,8871,9071,9070,-1,8871,8872,9072,9071,-1,8872,8873,9073,9072,-1,8873,8874,9074,9073,-1,8874,8875,9075,9074,-1,8875,8876,9076,9075,-1,8876,8877,9077,9076,-1,8877,8878,9078,9077,-1,8878,8879,9079,9078,-1,8879,8880,9080,9079,-1,8880,8881,9081,9080,-1,8881,8882,9082,9081,-1,8882,8883,9083,9082,-1,8883,8884,9084,9083,-1,8884,8885,9085,9084,-1,8885,8886,9086,9085,-1,8886,8887,9087,9086,-1,8887,8888,9088,9087,-1,8888,8889,9089,9088,-1,8889,8890,9090,9089,-1,8890,8891,9091,9090,-1,8891,8892,9092,9091,-1,8892,8893,9093,9092,-1,8893,8894,9094,9093,-1,8894,8895,9095,9094,-1,8895,8896,9096,9095,-1,8896,8897,9097,9096,-1,8897,8898,9098,9097,-1,8898,8899,9099,9098,-1,8899,8900,9100,9099,-1,8900,8901,9101,9100,-1,8901,8902,9102,9101,-1,8902,8903,9103,9102,-1,8903,8904,9104,9103,-1,8904,8905,9105,9104,-1,8905,8906,9106,9105,-1,8906,8907,9107,9106,-1,8907,8908,9108,9107,-1,8908,8909,9109,9108,-1,8909,8910,9110,9109,-1,8910,8911,9111,9110,-1,8911,8912,9112,9111,-1,8912,8913,9113,9112,-1,8913,8914,9114,9113,-1,8914,8915,9115,9114,-1,8915,8916,9116,9115,-1,8916,8917,9117,9116,-1,8917,8918,9118,9117,-1,8918,8919,9119,9118,-1,8919,8920,9120,9119,-1,8920,8921,9121,9120,-1,8921,8922,9122,9121,-1,8922,8923,9123,9122,-1,8923,8924,9124,9123,-1,8924,8925,9125,9124,-1,8925,8926,9126,9125,-1,8926,8927,9127,9126,-1,8927,8928,9128,9127,-1,8928,8929,9129,9128,-1,8929,8930,9130,9129,-1,8930,8931,9131,9130,-1,8931,8932,9132,9131,-1,8932,8933,9133,9132,-1,8933,8934,9134,9133,-1,8934,8935,9135,9134,-1,8935,8936,9136,9135,-1,8936,8937,9137,9136,-1,8937,8938,9138,9137,-1,8938,8939,9139,9138,-1,8939,8940,9140,9139,-1,8940,8941,9141,9140,-1,8941,8942,9142,9141,-1,8942,8943,9143,9142,-1,8943,8944,9144,9143,-1,8944,8945,9145,9144,-1,8945,8946,9146,9145,-1,8946,8947,9147,9146,-1,8947,8948,9148,9147,-1,8948,8949,9149,9148,-1,8949,8950,9150,9149,-1,8950,8951,9151,9150,-1,8951,8952,9152,9151,-1,8952,8953,9153,9152,-1,8953,8954,9154,9153,-1,8954,8955,9155,9154,-1,8955,8956,9156,9155,-1,8956,8957,9157,9156,-1,8957,8958,9158,9157,-1,8958,8959,9159,9158,-1,8959,8960,9160,9159,-1,8960,8961,9161,9160,-1,8961,8962,9162,9161,-1,8962,8963,9163,9162,-1,8963,8964,9164,9163,-1,8964,8965,9165,9164,-1,8965,8966,9166,9165,-1,8966,8967,9167,9166,-1,8967,8968,9168,9167,-1,8968,8969,9169,9168,-1,8969,8970,9170,9169,-1,8970,8971,9171,9170,-1,8971,8972,9172,9171,-1,8972,8973,9173,9172,-1,8973,8974,9174,9173,-1,8974,8975,9175,9174,-1,8975,8976,9176,9175,-1,8976,8977,9177,9176,-1,8977,8978,9178,9177,-1,8978,8979,9179,9178,-1,8979,8980,9180,9179,-1,8980,8981,9181,9180,-1,8981,8982,9182,9181,-1,8982,8983,9183,9182,-1,8983,8984,9184,9183,-1,8984,8985,9185,9184,-1,8985,8986,9186,9185,-1,8986,8987,9187,9186,-1,8987,8988,9188,9187,-1,8988,8989,9189,9188,-1,8989,8990,9190,9189,-1,8990,8991,9191,9190,-1,8991,8992,9192,9191,-1,8992,8993,9193,9192,-1,8993,8994,9194,9193,-1,8994,8995,9195,9194,-1,8995,8996,9196,9195,-1,8996,8997,9197,9196,-1,8997,8998,9198,9197,-1,8998,8999,9199,9198,-1,9,9001,9201,9200,-1,9001,9002,9202,9201,-1,9002,9003,9203,9202,-1,9003,9004,9204,9203,-1,9004,9005,9205,9204,-1,9005,9006,9206,9205,-1,9006,9007,9207,9206,-1,9007,9008,9208,9207,-1,9008,9009,9209,9208,-1,9009,9010,9210,9209,-1,9010,9011,9211,9210,-1,9011,9012,9212,9211,-1,9012,9013,9213,9212,-1,9013,9014,9214,9213,-1,9014,9015,9215,9214,-1,9015,9016,9216,9215,-1,9016,9017,9217,9216,-1,9017,9018,9218,9217,-1,9018,9019,9219,9218,-1,9019,9020,9220,9219,-1,9020,9021,9221,9220,-1,9021,9022,9222,9221,-1,9022,9023,9223,9222,-1,9023,9024,9224,9223,-1,9024,9025,9225,9224,-1,9025,9026,9226,9225,-1,9026,9027,9227,9226,-1,9027,9028,9228,9227,-1,9028,9029,9229,9228,-1,9029,9030,9230,9229,-1,9030,9031,9231,9230,-1,9031,9032,9232,9231,-1,9032,9033,9233,9232,-1,9033,9034,9234,9233,-1,9034,9035,9235,9234,-1,9035,9036,9236,9235,-1,9036,9037,9237,9236,-1,9037,9038,9238,9237,-1,9038,9039,9239,9238,-1,9039,9040,9240,9239,-1,9040,9041,9241,9240,-1,9041,9042,9242,9241,-1,9042,9043,9243,9242,-1,9043,9044,9244,9243,-1,9044,9045,9245,9244,-1,9045,9046,9246,9245,-1,9046,9047,9247,9246,-1,9047,9048,9248,9247,-1,9048,9049,9249,9248,-1,9049,9050,9250,9249,-1,9050,9051,9251,9250,-1,9051,9052,9252,9251,-1,9052,9053,9253,9252,-1,9053,9054,9254,9253,-1,9054,9055,9255,9254,-1,9055,9056,9256,9255,-1,9056,9057,9257,9256,-1,9057,9058,9258,9257,-1,9058,9059,9259,9258,-1,9059,9060,9260,9259,-1,9060,9061,9261,9260,-1,9061,9062,9262,9261,-1,9062,9063,9263,9262,-1,9063,9064,9264,9263,-1,9064,9065,9265,9264,-1,9065,9066,9266,9265,-1,9066,9067,9267,9266,-1,9067,9068,9268,9267,-1,9068,9069,9269,9268,-1,9069,9070,9270,9269,-1,9070,9071,9271,9270,-1,9071,9072,9272,9271,-1,9072,9073,9273,9272,-1,9073,9074,9274,9273,-1,9074,9075,9275,9274,-1,9075,9076,9276,9275,-1,9076,9077,9277,9276,-1,9077,9078,9278,9277,-1,9078,9079,9279,9278,-1,9079,9080,9280,9279,-1,9080,9081,9281,9280,-1,9081,9082,9282,9281,-1,9082,9083,9283,9282,-1,9083,9084,9284,9283,-1,9084,9085,9285,9284,-1,9085,9086,9286,9285,-1,9086,9087,9287,9286,-1,9087,9088,9288,9287,-1,9088,9089,9289,9288,-1,9089,9090,9290,9289,-1,9090,9091,9291,9290,-1,9091,9092,9292,9291,-1,9092,9093,9293,9292,-1,9093,9094,9294,9293,-1,9094,9095,9295,9294,-1,9095,9096,9296,9295,-1,9096,9097,9297,9296,-1,9097,9098,9298,9297,-1,9098,9099,9299,9298,-1,9099,9100,9300,9299,-1,9100,9101,9301,9300,-1,9101,9102,9302,9301,-1,9102,9103,9303,9302,-1,9103,9104,9304,9303,-1,9104,9105,9305,9304,-1,9105,9106,9306,9305,-1,9106,9107,9307,9306,-1,9107,9108,9308,9307,-1,9108,9109,9309,9308,-1,9109,9110,9310,9309,-1,9110,9111,9311,9310,-1,9111,9112,9312,9311,-1,9112,9113,9313,9312,-1,9113,9114,9314,9313,-1,9114,9115,9315,9314,-1,9115,9116,9316,9315,-1,9116,9117,9317,9316,-1,9117,9118,9318,9317,-1,9118,9119,9319,9318,-1,9119,9120,9320,9319,-1,9120,9121,9321,9320,-1,9121,9122,9322,9321,-1,9122,9123,9323,9322,-1,9123,9124,9324,9323,-1,9124,9125,9325,9324,-1,9125,9126,9326,9325,-1,9126,9127,9327,9326,-1,9127,9128,9328,9327,-1,9128,9129,9329,9328,-1,9129,9130,9330,9329,-1,9130,9131,9331,9330,-1,9131,9132,9332,9331,-1,9132,9133,9333,9332,-1,9133,9134,9334,9333,-1,9134,9135,9335,9334,-1,9135,9136,9336,9335,-1,9136,9137,9337,9336,-1,9137,9138,9338,9337,-1,9138,9139,9339,9338,-1,9139,9140,9340,9339,-1,9140,9141,9341,9340,-1,9141,9142,9342,9341,-1,9142,9143,9343,9342,-1,9143,9144,9344,9343,-1,9144,9145,9345,9344,-1,9145,9146,9346,9345,-1,9146,9147,9347,9346,-1,9147,9148,9348,9347,-1,9148,9149,9349,9348,-1,9149,9150,9350,9349,-1,9150,9151,9351,9350,-1,9151,9152,9352,9351,-1,9152,9153,9353,9352,-1,9153,9154,9354,9353,-1,9154,9155,9355,9354,-1,9155,9156,9356,9355,-1,9156,9157,9357,9356,-1,9157,9158,9358,9357,-1,9158,9159,9359,9358,-1,9159,9160,9360,9359,-1,9160,9161,9361,9360,-1,9161,9162,9362,9361,-1,9162,9163,9363,9362,-1,9163,9164,9364,9363,-1,9164,9165,9365,9364,-1,9165,9166,9366,9365,-1,9166,9167,9367,9366,-1,9167,9168,9368,9367,-1,9168,9169,9369,9368,-1,9169,9170,9370,9369,-1,9170,9171,9371,9370,-1,9171,9172,9372,9371,-1,9172,9173,9373,9372,-1,9173,9174,9374,9373,-1,9174,9175,9375,9374,-1,9175,9176,9376,9375,-1,9176,9177,9377,9376,-1,9177,9178,9378,9377,-1,9178,9179,9379,9378,-1,9179,9180,9380,9379,-1,9180,9181,9381,9380,-1,9181,9182,9382,9381,-1,9182,9183,9383,9382,-1,9183,9184,9384,9383,-1,9184,9185,9385,9384,-1,9185,9186,9386,9385,-1,9186,9187,9387,9386,-1,9187,9188,9388,9387,-1,9188,9189,9389,9388,-1,9189,9190,9390,9389,-1,9190,9191,9391,9390,-1,9191,9192,9392,9391,-1,9192,9193,9393,9392,-1,9193,9194,9394,9393,-1,9194,9195,9395,9394,-1,9195,9196,9396,9395,-1,9196,9197,9397,9396,-1,9197,9198,9398,9397,-1,9198,9199,9399,9398,-1,9200,9201,9401,9400,-1,9201,9202,9402,9401,-1,9202,9203,9403,9402,-1,9203,9204,9404,9403,-1,9204,9205,9405,9404,-1,9205,9206,9406,9405,-1,9206,9207,9407,9406,-1,9207,9208,9408,9407,-1,9208,9209,9409,9408,-1,9209,9210,9410,9409,-1,9210,9211,9411,9410,-1,9211,9212,9412,9411,-1,9212,9213,9413,9412,-1,9213,9214,9414,9413,-1,9214,9215,9415,9414,-1,9215,9216,9416,9415,-1,9216,9217,9417,9416,-1,9217,9218,9418,9417,-1,9218,9219,9419,9418,-1,9219,9220,9420,9419,-1,9220,9221,9421,9420,-1,9221,9222,9422,9421,-1,9222,9223,9423,9422,-1,9223,9224,9424,9423,-1,9224,9225,9425,9424,-1,9225,9226,9426,9425,-1,9226,9227,9427,9426,-1,9227,9228,9428,9427,-1,9228,9229,9429,9428,-1,9229,9230,9430,9429,-1,9230,9231,9431,9430,-1,9231,9232,9432,9431,-1,9232,9233,9433,9432,-1,9233,9234,9434,9433,-1,9234,9235,9435,9434,-1,9235,9236,9436,9435,-1,9236,9237,9437,9436,-1,9237,9238,9438,9437,-1,9238,9239,9439,9438,-1,9239,9240,9440,9439,-1,9240,9241,9441,9440,-1,9241,9242,9442,9441,-1,9242,9243,9443,9442,-1,9243,9244,9444,9443,-1,9244,9245,9445,9444,-1,9245,9246,9446,9445,-1,9246,9247,9447,9446,-1,9247,9248,9448,9447,-1,9248,9249,9449,9448,-1,9249,9250,9450,9449,-1,9250,9251,9451,9450,-1,9251,9252,9452,9451,-1,9252,9253,9453,9452,-1,9253,9254,9454,9453,-1,9254,9255,9455,9454,-1,9255,9256,9456,9455,-1,9256,9257,9457,9456,-1,9257,9258,9458,9457,-1,9258,9259,9459,9458,-1,9259,9260,9460,9459,-1,9260,9261,9461,9460,-1,9261,9262,9462,9461,-1,9262,9263,9463,9462,-1,9263,9264,9464,9463,-1,9264,9265,9465,9464,-1,9265,9266,9466,9465,-1,9266,9267,9467,9466,-1,9267,9268,9468,9467,-1,9268,9269,9469,9468,-1,9269,9270,9470,9469,-1,9270,9271,9471,9470,-1,9271,9272,9472,9471,-1,9272,9273,9473,9472,-1,9273,9274,9474,9473,-1,9274,9275,9475,9474,-1,9275,9276,9476,9475,-1,9276,9277,9477,9476,-1,9277,9278,9478,9477,-1,9278,9279,9479,9478,-1,9279,9280,9480,9479,-1,9280,9281,9481,9480,-1,9281,9282,9482,9481,-1,9282,9283,9483,9482,-1,9283,9284,9484,9483,-1,9284,9285,9485,9484,-1,9285,9286,9486,9485,-1,9286,9287,9487,9486,-1,9287,9288,9488,9487,-1,9288,9289,9489,9488,-1,9289,9290,9490,9489,-1,9290,9291,9491,9490,-1,9291,9292,9492,9491,-1,9292,9293,9493,9492,-1,9293,9294,9494,9493,-1,9294,9295,9495,9494,-1,9295,9296,9496,9495,-1,9296,9297,9497,9496,-1,9297,9298,9498,9497,-1,9298,9299,9499,9498,-1,9299,9300,9500,9499,-1,9300,9301,9501,9500,-1,9301,9302,9502,9501,-1,9302,9303,9503,9502,-1,9303,9304,9504,9503,-1,9304,9305,9505,9504,-1,9305,9306,9506,9505,-1,9306,9307,9507,9506,-1,9307,9308,9508,9507,-1,9308,9309,9509,9508,-1,9309,9310,9510,9509,-1,9310,9311,9511,9510,-1,9311,9312,9512,9511,-1,9312,9313,9513,9512,-1,9313,9314,9514,9513,-1,9314,9315,9515,9514,-1,9315,9316,9516,9515,-1,9316,9317,9517,9516,-1,9317,9318,9518,9517,-1,9318,9319,9519,9518,-1,9319,9320,9520,9519,-1,9320,9321,9521,9520,-1,9321,9322,9522,9521,-1,9322,9323,9523,9522,-1,9323,9324,9524,9523,-1,9324,9325,9525,9524,-1,9325,9326,9526,9525,-1,9326,9327,9527,9526,-1,9327,9328,9528,9527,-1,9328,9329,9529,9528,-1,9329,9330,9530,9529,-1,9330,9331,9531,9530,-1,9331,9332,9532,9531,-1,9332,9333,9533,9532,-1,9333,9334,9534,9533,-1,9334,9335,9535,9534,-1,9335,9336,9536,9535,-1,9336,9337,9537,9536,-1,9337,9338,9538,9537,-1,9338,9339,9539,9538,-1,9339,9340,9540,9539,-1,9340,9341,9541,9540,-1,9341,9342,9542,9541,-1,9342,9343,9543,9542,-1,9343,9344,9544,9543,-1,9344,9345,9545,9544,-1,9345,9346,9546,9545,-1,9346,9347,9547,9546,-1,9347,9348,9548,9547,-1,9348,9349,9549,9548,-1,9349,9350,9550,9549,-1,9350,9351,9551,9550,-1,9351,9352,9552,9551,-1,9352,9353,9553,9552,-1,9353,9354,9554,9553,-1,9354,9355,9555,9554,-1,9355,9356,9556,9555,-1,9356,9357,9557,9556,-1,9357,9358,9558,9557,-1,9358,9359,9559,9558,-1,9359,9360,9560,9559,-1,9360,9361,9561,9560,-1,9361,9362,9562,9561,-1,9362,9363,9563,9562,-1,9363,9364,9564,9563,-1,9364,9365,9565,9564,-1,9365,9366,9566,9565,-1,9366,9367,9567,9566,-1,9367,9368,9568,9567,-1,9368,9369,9569,9568,-1,9369,9370,9570,9569,-1,9370,9371,9571,9570,-1,9371,9372,9572,9571,-1,9372,9373,9573,9572,-1,9373,9374,9574,9573,-1,9374,9375,9575,9574,-1,9375,9376,9576,9575,-1,9376,9377,9577,9576,-1,9377,9378,9578,9577,-1,9378,9379,9579,9578,-1,9379,9380,9580,9579,-1,9380,9381,9581,9580,-1,9381,9382,9582,9581,-1,9382,9383,9583,9582,-1,9383,9384,9584,9583,-1,9384,9385,9585,9584,-1,9385,9386,9586,9585,-1,9386,9387,9587,9586,-1,9387,9388,9588,9587,-1,9388,9389,9589,9588,-1,9389,9390,9590,9589,-1,9390,9391,9591,9590,-1,9391,9392,9592,9591,-1,9392,9393,9593,9592,-1,9393,9394,9594,9593,-1,9394,9395,9595,9594,-1,9395,9396,9596,9595,-1,9396,9397,9597,9596,-1,9397,9398,9598,9597,-1,9398,9399,9599,9598,-1,9400,9401,9601,9600,-1,9401,9402,9602,9601,-1,9402,9403,9603,9602,-1,9403,9404,9604,9603,-1,9404,9405,9605,9604,-1,9405,9406,9606,9605,-1,9406,9407,9607,9606,-1,9407,9408,9608,9607,-1,9408,9409,9609,9608,-1,9409,9410,9610,9609,-1,9410,9411,9611,9610,-1,9411,9412,9612,9611,-1,9412,9413,9613,9612,-1,9413,9414,9614,9613,-1,9414,9415,9615,9614,-1,9415,9416,9616,9615,-1,9416,9417,9617,9616,-1,9417,9418,9618,9617,-1,9418,9419,9619,9618,-1,9419,9420,9620,9619,-1,9420,9421,9621,9620,-1,9421,9422,9622,9621,-1,9422,9423,9623,9622,-1,9423,9424,9624,9623,-1,9424,9425,9625,9624,-1,9425,9426,9626,9625,-1,9426,9427,9627,9626,-1,9427,9428,9628,9627,-1,9428,9429,9629,9628,-1,9429,9430,9630,9629,-1,9430,9431,9631,9630,-1,9431,9432,9632,9631,-1,9432,9433,9633,9632,-1,9433,9434,9634,9633,-1,9434,9435,9635,9634,-1,9435,9436,9636,9635,-1,9436,9437,9637,9636,-1,9437,9438,9638,9637,-1,9438,9439,9639,9638,-1,9439,9440,9640,9639,-1,9440,9441,9641,9640,-1,9441,9442,9642,9641,-1,9442,9443,9643,9642,-1,9443,9444,9644,9643,-1,9444,9445,9645,9644,-1,9445,9446,9646,9645,-1,9446,9447,9647,9646,-1,9447,9448,9648,9647,-1,9448,9449,9649,9648,-1,9449,9450,9650,9649,-1,9450,9451,9651,9650,-1,9451,9452,9652,9651,-1,9452,9453,9653,9652,-1,9453,9454,9654,9653,-1,9454,9455,9655,9654,-1,9455,9456,9656,9655,-1,9456,9457,9657,9656,-1,9457,9458,9658,9657,-1,9458,9459,9659,9658,-1,9459,9460,9660,9659,-1,9460,9461,9661,9660,-1,9461,9462,9662,9661,-1,9462,9463,9663,9662,-1,9463,9464,9664,9663,-1,9464,9465,9665,9664,-1,9465,9466,9666,9665,-1,9466,9467,9667,9666,-1,9467,9468,9668,9667,-1,9468,9469,9669,9668,-1,9469,9470,9670,9669,-1,9470,9471,9671,9670,-1,9471,9472,9672,9671,-1,9472,9473,9673,9672,-1,9473,9474,9674,9673,-1,9474,9475,9675,9674,-1,9475,9476,9676,9675,-1,9476,9477,9677,9676,-1,9477,9478,9678,9677,-1,9478,9479,9679,9678,-1,9479,9480,9680,9679,-1,9480,9481,9681,9680,-1,9481,9482,9682,9681,-1,9482,9483,9683,9682,-1,9483,9484,9684,9683,-1,9484,9485,9685,9684,-1,9485,9486,9686,9685,-1,9486,9487,9687,9686,-1,9487,9488,9688,9687,-1,9488,9489,9689,9688,-1,9489,9490,9690,9689,-1,9490,9491,9691,9690,-1,9491,9492,9692,9691,-1,9492,9493,9693,9692,-1,9493,9494,9694,9693,-1,9494,9495,9695,9694,-1,9495,9496,9696,9695,-1,9496,9497,9697,9696,-1,9497,9498,9698,9697,-1,9498,9499,9699,9698,-1,9499,9500,9700,9699,-1,9500,9501,9701,9700,-1,9501,9502,9702,9701,-1,9502,9503,9703,9702,-1,9503,9504,9704,9703,-1,9504,9505,9705,9704,-1,9505,9506,9706,9705,-1,9506,9507,9707,9706,-1,9507,9508,9708,9707,-1,9508,9509,9709,9708,-1,9509,9510,9710,9709,-1,9510,9511,9711,9710,-1,9511,9512,9712,9711,-1,9512,9513,9713,9712,-1,9513,9514,9714,9713,-1,9514,9515,9715,9714,-1,9515,9516,9716,9715,-1,9516,9517,9717,9716,-1,9517,9518,9718,9717,-1,9518,9519,9719,9718,-1,9519,9520,9720,9719,-1,9520,9521,9721,9720,-1,9521,9522,9722,9721,-1,9522,9523,9723,9722,-1,9523,9524,9724,9723,-1,9524,9525,9725,9724,-1,9525,9526,9726,9725,-1,9526,9527,9727,9726,-1,9527,9528,9728,9727,-1,9528,9529,9729,9728,-1,9529,9530,9730,9729,-1,9530,9531,9731,9730,-1,9531,9532,9732,9731,-1,9532,9533,9733,9732,-1,9533,9534,9734,9733,-1,9534,9535,9735,9734,-1,9535,9536,9736,9735,-1,9536,9537,9737,9736,-1,9537,9538,9738,9737,-1,9538,9539,9739,9738,-1,9539,9540,9740,9739,-1,9540,9541,9741,9740,-1,9541,9542,9742,9741,-1,9542,9543,9743,9742,-1,9543,9544,9744,9743,-1,9544,9545,9745,9744,-1,9545,9546,9746,9745,-1,9546,9547,9747,9746,-1,9547,9548,9748,9747,-1,9548,9549,9749,9748,-1,9549,9550,9750,9749,-1,9550,9551,9751,9750,-1,9551,9552,9752,9751,-1,9552,9553,9753,9752,-1,9553,9554,9754,9753,-1,9554,9555,9755,9754,-1,9555,9556,9756,9755,-1,9556,9557,9757,9756,-1,9557,9558,9758,9757,-1,9558,9559,9759,9758,-1,9559,9560,9760,9759,-1,9560,9561,9761,9760,-1,9561,9562,9762,9761,-1,9562,9563,9763,9762,-1,9563,9564,9764,9763,-1,9564,9565,9765,9764,-1,9565,9566,9766,9765,-1,9566,9567,9767,9766,-1,9567,9568,9768,9767,-1,9568,9569,9769,9768,-1,9569,9570,9770,9769,-1,9570,9571,9771,9770,-1,9571,9572,9772,9771,-1,9572,9573,9773,9772,-1,9573,9574,9774,9773,-1,9574,9575,9775,9774,-1,9575,9576,9776,9775,-1,9576,9577,9777,9776,-1,9577,9578,9778,9777,-1,9578,9579,9779,9778,-1,9579,9580,9780,9779,-1,9580,9581,9781,9780,-1,9581,9582,9782,9781,-1,9582,9583,9783,9782,-1,9583,9584,9784,9783,-1,9584,9585,9785,9784,-1,9585,9586,9786,9785,-1,9586,9587,9787,9786,-1,9587,9588,9788,9787,-1,9588,9589,9789,9788,-1,9589,9590,9790,9789,-1,9590,9591,9791,9790,-1,9591,9592,9792,9791,-1,9592,9593,9793,9792,-1,9593,9594,9794,9793,-1,9594,9595,9795,9794,-1,9595,9596,9796,9795,-1,9596,9597,9797,9796,-1,9597,9598,9798,9797,-1,9598,9599,9799,9798,-1,9600,9601,9801,9800,-1,9601,9602,9802,9801,-1,9602,9603,9803,9802,-1,9603,9604,9804,9803,-1,9604,9605,9805,9804,-1,9605,9606,9806,9805,-1,9606,9607,9807,9806,-1,9607,9608,9808,9807,-1,9608,9609,9809,9808,-1,9609,9610,9810,9809,-1,9610,9611,9811,9810,-1,9611,9612,9812,9811,-1,9612,9613,9813,9812,-1,9613,9614,9814,9813,-1,9614,9615,9815,9814,-1,9615,9616,9816,9815,-1,9616,9617,9817,9816,-1,9617,9618,9818,9817,-1,9618,9619,9819,9818,-1,9619,9620,9820,9819,-1,9620,9621,9821,9820,-1,9621,9622,9822,9821,-1,9622,9623,9823,9822,-1,9623,9624,9824,9823,-1,9624,9625,9825,9824,-1,9625,9626,9826,9825,-1,9626,9627,9827,9826,-1,9627,9628,9828,9827,-1,9628,9629,9829,9828,-1,9629,9630,9830,9829,-1,9630,9631,9831,9830,-1,9631,9632,9832,9831,-1,9632,9633,9833,9832,-1,9633,9634,9834,9833,-1,9634,9635,9835,9834,-1,9635,9636,9836,9835,-1,9636,9637,9837,9836,-1,9637,9638,9838,9837,-1,9638,9639,9839,9838,-1,9639,9640,9840,9839,-1,9640,9641,9841,9840,-1,9641,9642,9842,9841,-1,9642,9643,9843,9842,-1,9643,9644,9844,9843,-1,9644,9645,9845,9844,-1,9645,9646,9846,9845,-1,9646,9647,9847,9846,-1,9647,9648,9848,9847,-1,9648,9649,9849,9848,-1,9649,9650,9850,9849,-1,9650,9651,9851,9850,-1,9651,9652,9852,9851,-1,9652,9653,9853,9852,-1,9653,9654,9854,9853,-1,9654,9655,9855,9854,-1,9655,9656,9856,9855,-1,9656,9657,9857,9856,-1,9657,9658,9858,9857,-1,9658,9659,9859,9858,-1,9659,9660,9860,9859,-1,9660,9661,9861,9860,-1,9661,9662,9862,9861,-1,9662,9663,9863,9862,-1,9663,9664,9864,9863,-1,9664,9665,9865,9864,-1,9665,9666,9866,9865,-1,9666,9667,9867,9866,-1,9667,9668,9868,9867,-1,9668,9669,9869,9868,-1,9669,9670,9870,9869,-1,9670,9671,9871,9870,-1,9671,9672,9872,9871,-1,9672,9673,9873,9872,-1,9673,9674,9874,9873,-1,9674,9675,9875,9874,-1,9675,9676,9876,9875,-1,9676,9677,9877,9876,-1,9677,9678,9878,9877,-1,9678,9679,9879,9878,-1,9679,9680,9880,9879,-1,9680,9681,9881,9880,-1,9681,9682,9882,9881,-1,9682,9683,9883,9882,-1,9683,9684,9884,9883,-1,9684,9685,9885,9884,-1,9685,9686,9886,9885,-1,9686,9687,9887,9886,-1,9687,9688,9888,9887,-1,9688,9689,9889,9888,-1,9689,9690,9890,9889,-1,9690,9691,9891,9890,-1,9691,9692,9892,9891,-1,9692,9693,9893,9892,-1,9693,9694,9894,9893,-1,9694,9695,9895,9894,-1,9695,9696,9896,9895,-1,9696,9697,9897,9896,-1,9697,9698,9898,9897,-1,9698,9699,9899,9898,-1,9699,9700,9900,9899,-1,9700,9701,9901,9900,-1,9701,9702,9902,9901,-1,9702,9703,9903,9902,-1,9703,9704,9904,9903,-1,9704,9705,9905,9904,-1,9705,9706,9906,9905,-1,9706,9707,9907,9906,-1,9707,9708,9908,9907,-1,9708,9709,9909,9908,-1,9709,9710,9910,9909,-1,9710,9711,9911,9910,-1,9711,9712,9912,9911,-1,9712,9713,9913,9912,-1,9713,9714,9914,9913,-1,9714,9715,9915,9914,-1,9715,9716,9916,9915,-1,9716,9717,9917,9916,-1,9717,9718,9918,9917,-1,9718,9719,9919,9918,-1,9719,9720,9920,9919,-1,9720,9721,9921,9920,-1,9721,9722,9922,9921,-1,9722,9723,9923,9922,-1,9723,9724,9924,9923,-1,9724,9725,9925,9924,-1,9725,9726,9926,9925,-1,9726,9727,9927,9926,-1,9727,9728,9928,9927,-1,9728,9729,9929,9928,-1,9729,9730,9930,9929,-1,9730,9731,9931,9930,-1,9731,9732,9932,9931,-1,9732,9733,9933,9932,-1,9733,9734,9934,9933,-1,9734,9735,9935,9934,-1,9735,9736,9936,9935,-1,9736,9737,9937,9936,-1,9737,9738,9938,9937,-1,9738,9739,9939,9938,-1,9739,9740,9940,9939,-1,9740,9741,9941,9940,-1,9741,9742,9942,9941,-1,9742,9743,9943,9942,-1,9743,9744,9944,9943,-1,9744,9745,9945,9944,-1,9745,9746,9946,9945,-1,9746,9747,9947,9946,-1,9747,9748,9948,9947,-1,9748,9749,9949,9948,-1,9749,9750,9950,9949,-1,9750,9751,9951,9950,-1,9751,9752,9952,9951,-1,9752,9753,9953,9952,-1,9753,9754,9954,9953,-1,9754,9755,9955,9954,-1,9755,9756,9956,9955,-1,9756,9757,9957,9956,-1,9757,9758,9958,9957,-1,9758,9759,9959,9958,-1,9759,9760,9960,9959,-1,9760,9761,9961,9960,-1,9761,9762,9962,9961,-1,9762,9763,9963,9962,-1,9763,9764,9964,9963,-1,9764,9765,9965,9964,-1,9765,9766,9966,9965,-1,9766,9767,9967,9966,-1,9767,9768,9968,9967,-1,9768,9769,9969,9968,-1,9769,9770,9970,9969,-1,9770,9771,9971,9970,-1,9771,9772,9972,9971,-1,9772,9773,9973,9972,-1,9773,9774,9974,9973,-1,9774,9775,9975,9974,-1,9775,9776,9976,9975,-1,9776,9777,9977,9976,-1,9777,9778,9978,9977,-1,9778,9779,9979,9978,-1,9779,9780,9980,9979,-1,9780,9781,9981,9980,-1,9781,9782,9982,9981,-1,9782,9783,9983,9982,-1,9783,9784,9984,9983,-1,9784,9785,9985,9984,-1,9785,9786,9986,9985,-1,9786,9787,9987,9986,-1,9787,9788,9988,9987,-1,9788,9789,9989,9988,-1,9789,9790,9990,9989,-1,9790,9791,9991,9990,-1,9791,9792,9992,9991,-1,9792,9793,9993,9992,-1,9793,9794,9994,9993,-1,9794,9795,9995,9994,-1,9795,9796,9996,9995,-1,9796,9797,9997,9996,-1,9797,9798,9998,9997,-1,9798,9799,9999,9998,-1,9800,9801,10001,1,-1,9801,9802,10002,10001,-1,9802,9803,10003,10002,-1,9803,9804,10004,10003,-1,9804,9805,10005,10004,-1,9805,9806,10006,10005,-1,9806,9807,10007,10006,-1,9807,9808,10008,10007,-1,9808,9809,10009,10008,-1,9809,9810,10010,10009,-1,9810,9811,10011,10010,-1,9811,9812,10012,10011,-1,9812,9813,10013,10012,-1,9813,9814,10014,10013,-1,9814,9815,10015,10014,-1,9815,9816,10016,10015,-1,9816,9817,10017,10016,-1,9817,9818,10018,10017,-1,9818,9819,10019,10018,-1,9819,9820,10020,10019,-1,9820,9821,10021,10020,-1,9821,9822,10022,10021,-1,9822,9823,10023,10022,-1,9823,9824,10024,10023,-1,9824,9825,10025,10024,-1,9825,9826,10026,10025,-1,9826,9827,10027,10026,-1,9827,9828,10028,10027,-1,9828,9829,10029,10028,-1,9829,9830,10030,10029,-1,9830,9831,10031,10030,-1,9831,9832,10032,10031,-1,9832,9833,10033,10032,-1,9833,9834,10034,10033,-1,9834,9835,10035,10034,-1,9835,9836,10036,10035,-1,9836,9837,10037,10036,-1,9837,9838,10038,10037,-1,9838,9839,10039,10038,-1,9839,9840,10040,10039,-1,9840,9841,10041,10040,-1,9841,9842,10042,10041,-1,9842,9843,10043,10042,-1,9843,9844,10044,10043,-1,9844,9845,10045,10044,-1,9845,9846,10046,10045,-1,9846,9847,10047,10046,-1,9847,9848,10048,10047,-1,9848,9849,10049,10048,-1,9849,9850,10050,10049,-1,9850,9851,10051,10050,-1,9851,9852,10052,10051,-1,9852,9853,10053,10052,-1,9853,9854,10054,10053,-1,9854,9855,10055,10054,-1,9855,9856,10056,10055,-1,9856,9857,10057,10056,-1,9857,9858,10058,10057,-1,9858,9859,10059,10058,-1,9859,9860,10060,10059,-1,9860,9861,10061,10060,-1,9861,9862,10062,10061,-1,9862,9863,10063,10062,-1,9863,9864,10064,10063,-1,9864,9865,10065,10064,-1,9865,9866,10066,10065,-1,9866,9867,10067,10066,-1,9867,9868,10068,10067,-1,9868,9869,10069,10068,-1,9869,9870,10070,10069,-1,9870,9871,10071,10070,-1,9871,9872,10072,10071,-1,9872,9873,10073,10072,-1,9873,9874,10074,10073,-1,9874,9875,10075,10074,-1,9875,9876,10076,10075,-1,9876,9877,10077,10076,-1,9877,9878,10078,10077,-1,9878,9879,10079,10078,-1,9879,9880,10080,10079,-1,9880,9881,10081,10080,-1,9881,9882,10082,10081,-1,9882,9883,10083,10082,-1,9883,9884,10084,10083,-1,9884,9885,10085,10084,-1,9885,9886,10086,10085,-1,9886,9887,10087,10086,-1,9887,9888,10088,10087,-1,9888,9889,10089,10088,-1,9889,9890,10090,10089,-1,9890,9891,10091,10090,-1,9891,9892,10092,10091,-1,9892,9893,10093,10092,-1,9893,9894,10094,10093,-1,9894,9895,10095,10094,-1,9895,9896,10096,10095,-1,9896,9897,10097,10096,-1,9897,9898,10098,10097,-1,9898,9899,10099,10098,-1,9899,9900,10100,10099,-1,9900,9901,10101,10100,-1,9901,9902,10102,10101,-1,9902,9903,10103,10102,-1,9903,9904,10104,10103,-1,9904,9905,10105,10104,-1,9905,9906,10106,10105,-1,9906,9907,10107,10106,-1,9907,9908,10108,10107,-1,9908,9909,10109,10108,-1,9909,9910,10110,10109,-1,9910,9911,10111,10110,-1,9911,9912,10112,10111,-1,9912,9913,10113,10112,-1,9913,9914,10114,10113,-1,9914,9915,10115,10114,-1,9915,9916,10116,10115,-1,9916,9917,10117,10116,-1,9917,9918,10118,10117,-1,9918,9919,10119,10118,-1,9919,9920,10120,10119,-1,9920,9921,10121,10120,-1,9921,9922,10122,10121,-1,9922,9923,10123,10122,-1,9923,9924,10124,10123,-1,9924,9925,10125,10124,-1,9925,9926,10126,10125,-1,9926,9927,10127,10126,-1,9927,9928,10128,10127,-1,9928,9929,10129,10128,-1,9929,9930,10130,10129,-1,9930,9931,10131,10130,-1,9931,9932,10132,10131,-1,9932,9933,10133,10132,-1,9933,9934,10134,10133,-1,9934,9935,10135,10134,-1,9935,9936,10136,10135,-1,9936,9937,10137,10136,-1,9937,9938,10138,10137,-1,9938,9939,10139,10138,-1,9939,9940,10140,10139,-1,9940,9941,10141,10140,-1,9941,9942,10142,10141,-1,9942,9943,10143,10142,-1,9943,9944,10144,10143,-1,9944,9945,10145,10144,-1,9945,9946,10146,10145,-1,9946,9947,10147,10146,-1,9947,9948,10148,10147,-1,9948,9949,10149,10148,-1,9949,9950,10150,10149,-1,9950,9951,10151,10150,-1,9951,9952,10152,10151,-1,9952,9953,10153,10152,-1,9953,9954,10154,10153,-1,9954,9955,10155,10154,-1,9955,9956,10156,10155,-1,9956,9957,10157,10156,-1,9957,9958,10158,10157,-1,9958,9959,10159,10158,-1,9959,9960,10160,10159,-1,9960,9961,10161,10160,-1,9961,9962,10162,10161,-1,9962,9963,10163,10162,-1,9963,9964,10164,10163,-1,9964,9965,10165,10164,-1,9965,9966,10166,10165,-1,9966,9967,10167,10166,-1,9967,9968,10168,10167,-1,9968,9969,10169,10168,-1,9969,9970,10170,10169,-1,9970,9971,10171,10170,-1,9971,9972,10172,10171,-1,9972,9973,10173,10172,-1,9973,9974,10174,10173,-1,9974,9975,10175,10174,-1,9975,9976,10176,10175,-1,9976,9977,10177,10176,-1,9977,9978,10178,10177,-1,9978,9979,10179,10178,-1,9979,9980,10180,10179,-1,9980,9981,10181,10180,-1,9981,9982,10182,10181,-1,9982,9983,10183,10182,-1,9983,9984,10184,10183,-1,9984,9985,10185,10184,-1,9985,9986,10186,10185,-1,9986,9987,10187,10186,-1,9987,9988,10188,10187,-1,9988,9989,10189,10188,-1,9989,9990,10190,10189,-1,9990,9991,10191,10190,-1,9991,9992,10192,10191,-1,9992,9993,10193,10192,-1,9993,9994,10194,10193,-1,9994,9995,10195,10194,-1,9995,9996,10196,10195,-1,9996,9997,10197,10196,-1,9997,9998,10198,10197,-1,9998,9999,10199,10198,-1,1,10001,10201,10200,-1,10001,10002,10202,10201,-1,10002,10003,10203,10202,-1,10003,10004,10204,10203,-1,10004,10005,10205,10204,-1,10005,10006,10206,10205,-1,10006,10007,10207,10206,-1,10007,10008,10208,10207,-1,10008,10009,10209,10208,-1,10009,10010,10210,10209,-1,10010,10011,10211,10210,-1,10011,10012,10212,10211,-1,10012,10013,10213,10212,-1,10013,10014,10214,10213,-1,10014,10015,10215,10214,-1,10015,10016,10216,10215,-1,10016,10017,10217,10216,-1,10017,10018,10218,10217,-1,10018,10019,10219,10218,-1,10019,10020,10220,10219,-1,10020,10021,10221,10220,-1,10021,10022,10222,10221,-1,10022,10023,10223,10222,-1,10023,10024,10224,10223,-1,10024,10025,10225,10224,-1,10025,10026,10226,10225,-1,10026,10027,10227,10226,-1,10027,10028,10228,10227,-1,10028,10029,10229,10228,-1,10029,10030,10230,10229,-1,10030,10031,10231,10230,-1,10031,10032,10232,10231,-1,10032,10033,10233,10232,-1,10033,10034,10234,10233,-1,10034,10035,10235,10234,-1,10035,10036,10236,10235,-1,10036,10037,10237,10236,-1,10037,10038,10238,10237,-1,10038,10039,10239,10238,-1,10039,10040,10240,10239,-1,10040,10041,10241,10240,-1,10041,10042,10242,10241,-1,10042,10043,10243,10242,-1,10043,10044,10244,10243,-1,10044,10045,10245,10244,-1,10045,10046,10246,10245,-1,10046,10047,10247,10246,-1,10047,10048,10248,10247,-1,10048,10049,10249,10248,-1,10049,10050,10250,10249,-1,10050,10051,10251,10250,-1,10051,10052,10252,10251,-1,10052,10053,10253,10252,-1,10053,10054,10254,10253,-1,10054,10055,10255,10254,-1,10055,10056,10256,10255,-1,10056,10057,10257,10256,-1,10057,10058,10258,10257,-1,10058,10059,10259,10258,-1,10059,10060,10260,10259,-1,10060,10061,10261,10260,-1,10061,10062,10262,10261,-1,10062,10063,10263,10262,-1,10063,10064,10264,10263,-1,10064,10065,10265,10264,-1,10065,10066,10266,10265,-1,10066,10067,10267,10266,-1,10067,10068,10268,10267,-1,10068,10069,10269,10268,-1,10069,10070,10270,10269,-1,10070,10071,10271,10270,-1,10071,10072,10272,10271,-1,10072,10073,10273,10272,-1,10073,10074,10274,10273,-1,10074,10075,10275,10274,-1,10075,10076,10276,10275,-1,10076,10077,10277,10276,-1,10077,10078,10278,10277,-1,10078,10079,10279,10278,-1,10079,10080,10280,10279,-1,10080,10081,10281,10280,-1,10081,10082,10282,10281,-1,10082,10083,10283,10282,-1,10083,10084,10284,10283,-1,10084,10085,10285,10284,-1,10085,10086,10286,10285,-1,10086,10087,10287,10286,-1,10087,10088,10288,10287,-1,10088,10089,10289,10288,-1,10089,10090,10290,10289,-1,10090,10091,10291,10290,-1,10091,10092,10292,10291,-1,10092,10093,10293,10292,-1,10093,10094,10294,10293,-1,10094,10095,10295,10294,-1,10095,10096,10296,10295,-1,10096,10097,10297,10296,-1,10097,10098,10298,10297,-1,10098,10099,10299,10298,-1,10099,10100,10300,10299,-1,10100,10101,10301,10300,-1,10101,10102,10302,10301,-1,10102,10103,10303,10302,-1,10103,10104,10304,10303,-1,10104,10105,10305,10304,-1,10105,10106,10306,10305,-1,10106,10107,10307,10306,-1,10107,10108,10308,10307,-1,10108,10109,10309,10308,-1,10109,10110,10310,10309,-1,10110,10111,10311,10310,-1,10111,10112,10312,10311,-1,10112,10113,10313,10312,-1,10113,10114,10314,10313,-1,10114,10115,10315,10314,-1,10115,10116,10316,10315,-1,10116,10117,10317,10316,-1,10117,10118,10318,10317,-1,10118,10119,10319,10318,-1,10119,10120,10320,10319,-1,10120,10121,10321,10320,-1,10121,10122,10322,10321,-1,10122,10123,10323,10322,-1,10123,10124,10324,10323,-1,10124,10125,10325,10324,-1,10125,10126,10326,10325,-1,10126,10127,10327,10326,-1,10127,10128,10328,10327,-1,10128,10129,10329,10328,-1,10129,10130,10330,10329,-1,10130,10131,10331,10330,-1,10131,10132,10332,10331,-1,10132,10133,10333,10332,-1,10133,10134,10334,10333,-1,10134,10135,10335,10334,-1,10135,10136,10336,10335,-1,10136,10137,10337,10336,-1,10137,10138,10338,10337,-1,10138,10139,10339,10338,-1,10139,10140,10340,10339,-1,10140,10141,10341,10340,-1,10141,10142,10342,10341,-1,10142,10143,10343,10342,-1,10143,10144,10344,10343,-1,10144,10145,10345,10344,-1,10145,10146,10346,10345,-1,10146,10147,10347,10346,-1,10147,10148,10348,10347,-1,10148,10149,10349,10348,-1,10149,10150,10350,10349,-1,10150,10151,10351,10350,-1,10151,10152,10352,10351,-1,10152,10153,10353,10352,-1,10153,10154,10354,10353,-1,10154,10155,10355,10354,-1,10155,10156,10356,10355,-1,10156,10157,10357,10356,-1,10157,10158,10358,10357,-1,10158,10159,10359,10358,-1,10159,10160,10360,10359,-1,10160,10161,10361,10360,-1,10161,10162,10362,10361,-1,10162,10163,10363,10362,-1,10163,10164,10364,10363,-1,10164,10165,10365,10364,-1,10165,10166,10366,10365,-1,10166,10167,10367,10366,-1,10167,10168,10368,10367,-1,10168,10169,10369,10368,-1,10169,10170,10370,10369,-1,10170,10171,10371,10370,-1,10171,10172,10372,10371,-1,10172,10173,10373,10372,-1,10173,10174,10374,10373,-1,10174,10175,10375,10374,-1,10175,10176,10376,10375,-1,10176,10177,10377,10376,-1,10177,10178,10378,10377,-1,10178,10179,10379,10378,-1,10179,10180,10380,10379,-1,10180,10181,10381,10380,-1,10181,10182,10382,10381,-1,10182,10183,10383,10382,-1,10183,10184,10384,10383,-1,10184,10185,10385,10384,-1,10185,10186,10386,10385,-1,10186,10187,10387,10386,-1,10187,10188,10388,10387,-1,10188,10189,10389,10388,-1,10189,10190,10390,10389,-1,10190,10191,10391,10390,-1,10191,10192,10392,10391,-1,10192,10193,10393,10392,-1,10193,10194,10394,10393,-1,10194,10195,10395,10394,-1,10195,10196,10396,10395,-1,10196,10197,10397,10396,-1,10197,10198,10398,10397,-1,10198,10199,10399,10398,-1,10200,10201,10401,10400,-1,10201,10202,10402,10401,-1,10202,10203,10403,10402,-1,10203,10204,10404,10403,-1,10204,10205,10405,10404,-1,10205,10206,10406,10405,-1,10206,10207,10407,10406,-1,10207,10208,10408,10407,-1,10208,10209,10409,10408,-1,10209,10210,10410,10409,-1,10210,10211,10411,10410,-1,10211,10212,10412,10411,-1,10212,10213,10413,10412,-1,10213,10214,10414,10413,-1,10214,10215,10415,10414,-1,10215,10216,10416,10415,-1,10216,10217,10417,10416,-1,10217,10218,10418,10417,-1,10218,10219,10419,10418,-1,10219,10220,10420,10419,-1,10220,10221,10421,10420,-1,10221,10222,10422,10421,-1,10222,10223,10423,10422,-1,10223,10224,10424,10423,-1,10224,10225,10425,10424,-1,10225,10226,10426,10425,-1,10226,10227,10427,10426,-1,10227,10228,10428,10427,-1,10228,10229,10429,10428,-1,10229,10230,10430,10429,-1,10230,10231,10431,10430,-1,10231,10232,10432,10431,-1,10232,10233,10433,10432,-1,10233,10234,10434,10433,-1,10234,10235,10435,10434,-1,10235,10236,10436,10435,-1,10236,10237,10437,10436,-1,10237,10238,10438,10437,-1,10238,10239,10439,10438,-1,10239,10240,10440,10439,-1,10240,10241,10441,10440,-1,10241,10242,10442,10441,-1,10242,10243,10443,10442,-1,10243,10244,10444,10443,-1,10244,10245,10445,10444,-1,10245,10246,10446,10445,-1,10246,10247,10447,10446,-1,10247,10248,10448,10447,-1,10248,10249,10449,10448,-1,10249,10250,10450,10449,-1,10250,10251,10451,10450,-1,10251,10252,10452,10451,-1,10252,10253,10453,10452,-1,10253,10254,10454,10453,-1,10254,10255,10455,10454,-1,10255,10256,10456,10455,-1,10256,10257,10457,10456,-1,10257,10258,10458,10457,-1,10258,10259,10459,10458,-1,10259,10260,10460,10459,-1,10260,10261,10461,10460,-1,10261,10262,10462,10461,-1,10262,10263,10463,10462,-1,10263,10264,10464,10463,-1,10264,10265,10465,10464,-1,10265,10266,10466,10465,-1,10266,10267,10467,10466,-1,10267,10268,10468,10467,-1,10268,10269,10469,10468,-1,10269,10270,10470,10469,-1,10270,10271,10471,10470,-1,10271,10272,10472,10471,-1,10272,10273,10473,10472,-1,10273,10274,10474,10473,-1,10274,10275,10475,10474,-1,10275,10276,10476,10475,-1,10276,10277,10477,10476,-1,10277,10278,10478,10477,-1,10278,10279,10479,10478,-1,10279,10280,10480,10479,-1,10280,10281,10481,10480,-1,10281,10282,10482,10481,-1,10282,10283,10483,10482,-1,10283,10284,10484,10483,-1,10284,10285,10485,10484,-1,10285,10286,10486,10485,-1,10286,10287,10487,10486,-1,10287,10288,10488,10487,-1,10288,10289,10489,10488,-1,10289,10290,10490,10489,-1,10290,10291,10491,10490,-1,10291,10292,10492,10491,-1,10292,10293,10493,10492,-1,10293,10294,10494,10493,-1,10294,10295,10495,10494,-1,10295,10296,10496,10495,-1,10296,10297,10497,10496,-1,10297,10298,10498,10497,-1,10298,10299,10499,10498,-1,10299,10300,10500,10499,-1,10300,10301,10501,10500,-1,10301,10302,10502,10501,-1,10302,10303,10503,10502,-1,10303,10304,10504,10503,-1,10304,10305,10505,10504,-1,10305,10306,10506,10505,-1,10306,10307,10507,10506,-1,10307,10308,10508,10507,-1,10308,10309,10509,10508,-1,10309,10310,10510,10509,-1,10310,10311,10511,10510,-1,10311,10312,10512,10511,-1,10312,10313,10513,10512,-1,10313,10314,10514,10513,-1,10314,10315,10515,10514,-1,10315,10316,10516,10515,-1,10316,10317,10517,10516,-1,10317,10318,10518,10517,-1,10318,10319,10519,10518,-1,10319,10320,10520,10519,-1,10320,10321,10521,10520,-1,10321,10322,10522,10521,-1,10322,10323,10523,10522,-1,10323,10324,10524,10523,-1,10324,10325,10525,10524,-1,10325,10326,10526,10525,-1,10326,10327,10527,10526,-1,10327,10328,10528,10527,-1,10328,10329,10529,10528,-1,10329,10330,10530,10529,-1,10330,10331,10531,10530,-1,10331,10332,10532,10531,-1,10332,10333,10533,10532,-1,10333,10334,10534,10533,-1,10334,10335,10535,10534,-1,10335,10336,10536,10535,-1,10336,10337,10537,10536,-1,10337,10338,10538,10537,-1,10338,10339,10539,10538,-1,10339,10340,10540,10539,-1,10340,10341,10541,10540,-1,10341,10342,10542,10541,-1,10342,10343,10543,10542,-1,10343,10344,10544,10543,-1,10344,10345,10545,10544,-1,10345,10346,10546,10545,-1,10346,10347,10547,10546,-1,10347,10348,10548,10547,-1,10348,10349,10549,10548,-1,10349,10350,10550,10549,-1,10350,10351,10551,10550,-1,10351,10352,10552,10551,-1,10352,10353,10553,10552,-1,10353,10354,10554,10553,-1,10354,10355,10555,10554,-1,10355,10356,10556,10555,-1,10356,10357,10557,10556,-1,10357,10358,10558,10557,-1,10358,10359,10559,10558,-1,10359,10360,10560,10559,-1,10360,10361,10561,10560,-1,10361,10362,10562,10561,-1,10362,10363,10563,10562,-1,10363,10364,10564,10563,-1,10364,10365,10565,10564,-1,10365,10366,10566,10565,-1,10366,10367,10567,10566,-1,10367,10368,10568,10567,-1,10368,10369,10569,10568,-1,10369,10370,10570,10569,-1,10370,10371,10571,10570,-1,10371,10372,10572,10571,-1,10372,10373,10573,10572,-1,10373,10374,10574,10573,-1,10374,10375,10575,10574,-1,10375,10376,10576,10575,-1,10376,10377,10577,10576,-1,10377,10378,10578,10577,-1,10378,10379,10579,10578,-1,10379,10380,10580,10579,-1,10380,10381,10581,10580,-1,10381,10382,10582,10581,-1,10382,10383,10583,10582,-1,10383,10384,10584,10583,-1,10384,10385,10585,10584,-1,10385,10386,10586,10585,-1,10386,10387,10587,10586,-1,10387,10388,10588,10587,-1,10388,10389,10589,10588,-1,10389,10390,10590,10589,-1,10390,10391,10591,10590,-1,10391,10392,10592,10591,-1,10392,10393,10593,10592,-1,10393,10394,10594,10593,-1,10394,10395,10595,10594,-1,10395,10396,10596,10595,-1,10396,10397,10597,10596,-1,10397,10398,10598,10597,-1,10398,10399,10599,10598,-1,10400,10401,10601,10600,-1,10401,10402,10602,10601,-1,10402,10403,10603,10602,-1,10403,10404,10604,10603,-1,10404,10405,10605,10604,-1,10405,10406,10606,10605,-1,10406,10407,10607,10606,-1,10407,10408,10608,10607,-1,10408,10409,10609,10608,-1,10409,10410,10610,10609,-1,10410,10411,10611,10610,-1,10411,10412,10612,10611,-1,10412,10413,10613,10612,-1,10413,10414,10614,10613,-1,10414,10415,10615,10614,-1,10415,10416,10616,10615,-1,10416,10417,10617,10616,-1,10417,10418,10618,10617,-1,10418,10419,10619,10618,-1,10419,10420,10620,10619,-1,10420,10421,10621,10620,-1,10421,10422,10622,10621,-1,10422,10423,10623,10622,-1,10423,10424,10624,10623,-1,10424,10425,10625,10624,-1,10425,10426,10626,10625,-1,10426,10427,10627,10626,-1,10427,10428,10628,10627,-1,10428,10429,10629,10628,-1,10429,10430,10630,10629,-1,10430,10431,10631,10630,-1,10431,10432,10632,10631,-1,10432,10433,10633,10632,-1,10433,10434,10634,10633,-1,10434,10435,10635,10634,-1,10435,10436,10636,10635,-1,10436,10437,10637,10636,-1,10437,10438,10638,10637,-1,10438,10439,10639,10638,-1,10439,10440,10640,10639,-1,10440,10441,10641,10640,-1,10441,10442,10642,10641,-1,10442,10443,10643,10642,-1,10443,10444,10644,10643,-1,10444,10445,10645,10644,-1,10445,10446,10646,10645,-1,10446,10447,10647,10646,-1,10447,10448,10648,10647,-1,10448,10449,10649,10648,-1,10449,10450,10650,10649,-1,10450,10451,10651,10650,-1,10451,10452,10652,10651,-1,10452,10453,10653,10652,-1,10453,10454,10654,10653,-1,10454,10455,10655,10654,-1,10455,10456,10656,10655,-1,10456,10457,10657,10656,-1,10457,10458,10658,10657,-1,10458,10459,10659,10658,-1,10459,10460,10660,10659,-1,10460,10461,10661,10660,-1,10461,10462,10662,10661,-1,10462,10463,10663,10662,-1,10463,10464,10664,10663,-1,10464,10465,10665,10664,-1,10465,10466,10666,10665,-1,10466,10467,10667,10666,-1,10467,10468,10668,10667,-1,10468,10469,10669,10668,-1,10469,10470,10670,10669,-1,10470,10471,10671,10670,-1,10471,10472,10672,10671,-1,10472,10473,10673,10672,-1,10473,10474,10674,10673,-1,10474,10475,10675,10674,-1,10475,10476,10676,10675,-1,10476,10477,10677,10676,-1,10477,10478,10678,10677,-1,10478,10479,10679,10678,-1,10479,10480,10680,10679,-1,10480,10481,10681,10680,-1,10481,10482,10682,10681,-1,10482,10483,10683,10682,-1,10483,10484,10684,10683,-1,10484,10485,10685,10684,-1,10485,10486,10686,10685,-1,10486,10487,10687,10686,-1,10487,10488,10688,10687,-1,10488,10489,10689,10688,-1,10489,10490,10690,10689,-1,10490,10491,10691,10690,-1,10491,10492,10692,10691,-1,10492,10493,10693,10692,-1,10493,10494,10694,10693,-1,10494,10495,10695,10694,-1,10495,10496,10696,10695,-1,10496,10497,10697,10696,-1,10497,10498,10698,10697,-1,10498,10499,10699,10698,-1,10499,10500,10700,10699,-1,10500,10501,10701,10700,-1,10501,10502,10702,10701,-1,10502,10503,10703,10702,-1,10503,10504,10704,10703,-1,10504,10505,10705,10704,-1,10505,10506,10706,10705,-1,10506,10507,10707,10706,-1,10507,10508,10708,10707,-1,10508,10509,10709,10708,-1,10509,10510,10710,10709,-1,10510,10511,10711,10710,-1,10511,10512,10712,10711,-1,10512,10513,10713,10712,-1,10513,10514,10714,10713,-1,10514,10515,10715,10714,-1,10515,10516,10716,10715,-1,10516,10517,10717,10716,-1,10517,10518,10718,10717,-1,10518,10519,10719,10718,-1,10519,10520,10720,10719,-1,10520,10521,10721,10720,-1,10521,10522,10722,10721,-1,10522,10523,10723,10722,-1,10523,10524,10724,10723,-1,10524,10525,10725,10724,-1,10525,10526,10726,10725,-1,10526,10527,10727,10726,-1,10527,10528,10728,10727,-1,10528,10529,10729,10728,-1,10529,10530,10730,10729,-1,10530,10531,10731,10730,-1,10531,10532,10732,10731,-1,10532,10533,10733,10732,-1,10533,10534,10734,10733,-1,10534,10535,10735,10734,-1,10535,10536,10736,10735,-1,10536,10537,10737,10736,-1,10537,10538,10738,10737,-1,10538,10539,10739,10738,-1,10539,10540,10740,10739,-1,10540,10541,10741,10740,-1,10541,10542,10742,10741,-1,10542,10543,10743,10742,-1,10543,10544,10744,10743,-1,10544,10545,10745,10744,-1,10545,10546,10746,10745,-1,10546,10547,10747,10746,-1,10547,10548,10748,10747,-1,10548,10549,10749,10748,-1,10549,10550,10750,10749,-1,10550,10551,10751,10750,-1,10551,10552,10752,10751,-1,10552,10553,10753,10752,-1,10553,10554,10754,10753,-1,10554,10555,10755,10754,-1,10555,10556,10756,10755,-1,10556,10557,10757,10756,-1,10557,10558,10758,10757,-1,10558,10559,10759,10758,-1,10559,10560,10760,10759,-1,10560,10561,10761,10760,-1,10561,10562,10762,10761,-1,10562,10563,10763,10762,-1,10563,10564,10764,10763,-1,10564,10565,10765,10764,-1,10565,10566,10766,10765,-1,10566,10567,10767,10766,-1,10567,10568,10768,10767,-1,10568,10569,10769,10768,-1,10569,10570,10770,10769,-1,10570,10571,10771,10770,-1,10571,10572,10772,10771,-1,10572,10573,10773,10772,-1,10573,10574,10774,10773,-1,10574,10575,10775,10774,-1,10575,10576,10776,10775,-1,10576,10577,10777,10776,-1,10577,10578,10778,10777,-1,10578,10579,10779,10778,-1,10579,10580,10780,10779,-1,10580,10581,10781,10780,-1,10581,10582,10782,10781,-1,10582,10583,10783,10782,-1,10583,10584,10784,10783,-1,10584,10585,10785,10784,-1,10585,10586,10786,10785,-1,10586,10587,10787,10786,-1,10587,10588,10788,10787,-1,10588,10589,10789,10788,-1,10589,10590,10790,10789,-1,10590,10591,10791,10790,-1,10591,10592,10792,10791,-1,10592,10593,10793,10792,-1,10593,10594,10794,10793,-1,10594,10595,10795,10794,-1,10595,10596,10796,10795,-1,10596,10597,10797,10796,-1,10597,10598,10798,10797,-1,10598,10599,10799,10798,-1,10600,10601,10801,10800,-1,10601,10602,10802,10801,-1,10602,10603,10803,10802,-1,10603,10604,10804,10803,-1,10604,10605,10805,10804,-1,10605,10606,10806,10805,-1,10606,10607,10807,10806,-1,10607,10608,10808,10807,-1,10608,10609,10809,10808,-1,10609,10610,10810,10809,-1,10610,10611,10811,10810,-1,10611,10612,10812,10811,-1,10612,10613,10813,10812,-1,10613,10614,10814,10813,-1,10614,10615,10815,10814,-1,10615,10616,10816,10815,-1,10616,10617,10817,10816,-1,10617,10618,10818,10817,-1,10618,10619,10819,10818,-1,10619,10620,10820,10819,-1,10620,10621,10821,10820,-1,10621,10622,10822,10821,-1,10622,10623,10823,10822,-1,10623,10624,10824,10823,-1,10624,10625,10825,10824,-1,10625,10626,10826,10825,-1,10626,10627,10827,10826,-1,10627,10628,10828,10827,-1,10628,10629,10829,10828,-1,10629,10630,10830,10829,-1,10630,10631,10831,10830,-1,10631,10632,10832,10831,-1,10632,10633,10833,10832,-1,10633,10634,10834,10833,-1,10634,10635,10835,10834,-1,10635,10636,10836,10835,-1,10636,10637,10837,10836,-1,10637,10638,10838,10837,-1,10638,10639,10839,10838,-1,10639,10640,10840,10839,-1,10640,10641,10841,10840,-1,10641,10642,10842,10841,-1,10642,10643,10843,10842,-1,10643,10644,10844,10843,-1,10644,10645,10845,10844,-1,10645,10646,10846,10845,-1,10646,10647,10847,10846,-1,10647,10648,10848,10847,-1,10648,10649,10849,10848,-1,10649,10650,10850,10849,-1,10650,10651,10851,10850,-1,10651,10652,10852,10851,-1,10652,10653,10853,10852,-1,10653,10654,10854,10853,-1,10654,10655,10855,10854,-1,10655,10656,10856,10855,-1,10656,10657,10857,10856,-1,10657,10658,10858,10857,-1,10658,10659,10859,10858,-1,10659,10660,10860,10859,-1,10660,10661,10861,10860,-1,10661,10662,10862,10861,-1,10662,10663,10863,10862,-1,10663,10664,10864,10863,-1,10664,10665,10865,10864,-1,10665,10666,10866,10865,-1,10666,10667,10867,10866,-1,10667,10668,10868,10867,-1,10668,10669,10869,10868,-1,10669,10670,10870,10869,-1,10670,10671,10871,10870,-1,10671,10672,10872,10871,-1,10672,10673,10873,10872,-1,10673,10674,10874,10873,-1,10674,10675,10875,10874,-1,10675,10676,10876,10875,-1,10676,10677,10877,10876,-1,10677,10678,10878,10877,-1,10678,10679,10879,10878,-1,10679,10680,10880,10879,-1,10680,10681,10881,10880,-1,10681,10682,10882,10881,-1,10682,10683,10883,10882,-1,10683,10684,10884,10883,-1,10684,10685,10885,10884,-1,10685,10686,10886,10885,-1,10686,10687,10887,10886,-1,10687,10688,10888,10887,-1,10688,10689,10889,10888,-1,10689,10690,10890,10889,-1,10690,10691,10891,10890,-1,10691,10692,10892,10891,-1,10692,10693,10893,10892,-1,10693,10694,10894,10893,-1,10694,10695,10895,10894,-1,10695,10696,10896,10895,-1,10696,10697,10897,10896,-1,10697,10698,10898,10897,-1,10698,10699,10899,10898,-1,10699,10700,10900,10899,-1,10700,10701,10901,10900,-1,10701,10702,10902,10901,-1,10702,10703,10903,10902,-1,10703,10704,10904,10903,-1,10704,10705,10905,10904,-1,10705,10706,10906,10905,-1,10706,10707,10907,10906,-1,10707,10708,10908,10907,-1,10708,10709,10909,10908,-1,10709,10710,10910,10909,-1,10710,10711,10911,10910,-1,10711,10712,10912,10911,-1,10712,10713,10913,10912,-1,10713,10714,10914,10913,-1,10714,10715,10915,10914,-1,10715,10716,10916,10915,-1,10716,10717,10917,10916,-1,10717,10718,10918,10917,-1,10718,10719,10919,10918,-1,10719,10720,10920,10919,-1,10720,10721,10921,10920,-1,10721,10722,10922,10921,-1,10722,10723,10923,10922,-1,10723,10724,10924,10923,-1,10724,10725,10925,10924,-1,10725,10726,10926,10925,-1,10726,10727,10927,10926,-1,10727,10728,10928,10927,-1,10728,10729,10929,10928,-1,10729,10730,10930,10929,-1,10730,10731,10931,10930,-1,10731,10732,10932,10931,-1,10732,10733,10933,10932,-1,10733,10734,10934,10933,-1,10734,10735,10935,10934,-1,10735,10736,10936,10935,-1,10736,10737,10937,10936,-1,10737,10738,10938,10937,-1,10738,10739,10939,10938,-1,10739,10740,10940,10939,-1,10740,10741,10941,10940,-1,10741,10742,10942,10941,-1,10742,10743,10943,10942,-1,10743,10744,10944,10943,-1,10744,10745,10945,10944,-1,10745,10746,10946,10945,-1,10746,10747,10947,10946,-1,10747,10748,10948,10947,-1,10748,10749,10949,10948,-1,10749,10750,10950,10949,-1,10750,10751,10951,10950,-1,10751,10752,10952,10951,-1,10752,10753,10953,10952,-1,10753,10754,10954,10953,-1,10754,10755,10955,10954,-1,10755,10756,10956,10955,-1,10756,10757,10957,10956,-1,10757,10758,10958,10957,-1,10758,10759,10959,10958,-1,10759,10760,10960,10959,-1,10760,10761,10961,10960,-1,10761,10762,10962,10961,-1,10762,10763,10963,10962,-1,10763,10764,10964,10963,-1,10764,10765,10965,10964,-1,10765,10766,10966,10965,-1,10766,10767,10967,10966,-1,10767,10768,10968,10967,-1,10768,10769,10969,10968,-1,10769,10770,10970,10969,-1,10770,10771,10971,10970,-1,10771,10772,10972,10971,-1,10772,10773,10973,10972,-1,10773,10774,10974,10973,-1,10774,10775,10975,10974,-1,10775,10776,10976,10975,-1,10776,10777,10977,10976,-1,10777,10778,10978,10977,-1,10778,10779,10979,10978,-1,10779,10780,10980,10979,-1,10780,10781,10981,10980,-1,10781,10782,10982,10981,-1,10782,10783,10983,10982,-1,10783,10784,10984,10983,-1,10784,10785,10985,10984,-1,10785,10786,10986,10985,-1,10786,10787,10987,10986,-1,10787,10788,10988,10987,-1,10788,10789,10989,10988,-1,10789,10790,10990,10989,-1,10790,10791,10991,10990,-1,10791,10792,10992,10991,-1,10792,10793,10993,10992,-1,10793,10794,10994,10993,-1,10794,10795,10995,10994,-1,10795,10796,10996,10995,-1,10796,10797,10997,10996,-1,10797,10798,10998,10997,-1,10798,10799,10999,10998,-1,10800,10801,11001,11,-1,10801,10802,11002,11001,-1,10802,10803,11003,11002,-1,10803,10804,11004,11003,-1,10804,10805,11005,11004,-1,10805,10806,11006,11005,-1,10806,10807,11007,11006,-1,10807,10808,11008,11007,-1,10808,10809,11009,11008,-1,10809,10810,11010,11009,-1,10810,10811,11011,11010,-1,10811,10812,11012,11011,-1,10812,10813,11013,11012,-1,10813,10814,11014,11013,-1,10814,10815,11015,11014,-1,10815,10816,11016,11015,-1,10816,10817,11017,11016,-1,10817,10818,11018,11017,-1,10818,10819,11019,11018,-1,10819,10820,11020,11019,-1,10820,10821,11021,11020,-1,10821,10822,11022,11021,-1,10822,10823,11023,11022,-1,10823,10824,11024,11023,-1,10824,10825,11025,11024,-1,10825,10826,11026,11025,-1,10826,10827,11027,11026,-1,10827,10828,11028,11027,-1,10828,10829,11029,11028,-1,10829,10830,11030,11029,-1,10830,10831,11031,11030,-1,10831,10832,11032,11031,-1,10832,10833,11033,11032,-1,10833,10834,11034,11033,-1,10834,10835,11035,11034,-1,10835,10836,11036,11035,-1,10836,10837,11037,11036,-1,10837,10838,11038,11037,-1,10838,10839,11039,11038,-1,10839,10840,11040,11039,-1,10840,10841,11041,11040,-1,10841,10842,11042,11041,-1,10842,10843,11043,11042,-1,10843,10844,11044,11043,-1,10844,10845,11045,11044,-1,10845,10846,11046,11045,-1,10846,10847,11047,11046,-1,10847,10848,11048,11047,-1,10848,10849,11049,11048,-1,10849,10850,11050,11049,-1,10850,10851,11051,11050,-1,10851,10852,11052,11051,-1,10852,10853,11053,11052,-1,10853,10854,11054,11053,-1,10854,10855,11055,11054,-1,10855,10856,11056,11055,-1,10856,10857,11057,11056,-1,10857,10858,11058,11057,-1,10858,10859,11059,11058,-1,10859,10860,11060,11059,-1,10860,10861,11061,11060,-1,10861,10862,11062,11061,-1,10862,10863,11063,11062,-1,10863,10864,11064,11063,-1,10864,10865,11065,11064,-1,10865,10866,11066,11065,-1,10866,10867,11067,11066,-1,10867,10868,11068,11067,-1,10868,10869,11069,11068,-1,10869,10870,11070,11069,-1,10870,10871,11071,11070,-1,10871,10872,11072,11071,-1,10872,10873,11073,11072,-1,10873,10874,11074,11073,-1,10874,10875,11075,11074,-1,10875,10876,11076,11075,-1,10876,10877,11077,11076,-1,10877,10878,11078,11077,-1,10878,10879,11079,11078,-1,10879,10880,11080,11079,-1,10880,10881,11081,11080,-1,10881,10882,11082,11081,-1,10882,10883,11083,11082,-1,10883,10884,11084,11083,-1,10884,10885,11085,11084,-1,10885,10886,11086,11085,-1,10886,10887,11087,11086,-1,10887,10888,11088,11087,-1,10888,10889,11089,11088,-1,10889,10890,11090,11089,-1,10890,10891,11091,11090,-1,10891,10892,11092,11091,-1,10892,10893,11093,11092,-1,10893,10894,11094,11093,-1,10894,10895,11095,11094,-1,10895,10896,11096,11095,-1,10896,10897,11097,11096,-1,10897,10898,11098,11097,-1,10898,10899,11099,11098,-1,10899,10900,11100,11099,-1,10900,10901,11101,11100,-1,10901,10902,11102,11101,-1,10902,10903,11103,11102,-1,10903,10904,11104,11103,-1,10904,10905,11105,11104,-1,10905,10906,11106,11105,-1,10906,10907,11107,11106,-1,10907,10908,11108,11107,-1,10908,10909,11109,11108,-1,10909,10910,11110,11109,-1,10910,10911,11111,11110,-1,10911,10912,11112,11111,-1,10912,10913,11113,11112,-1,10913,10914,11114,11113,-1,10914,10915,11115,11114,-1,10915,10916,11116,11115,-1,10916,10917,11117,11116,-1,10917,10918,11118,11117,-1,10918,10919,11119,11118,-1,10919,10920,11120,11119,-1,10920,10921,11121,11120,-1,10921,10922,11122,11121,-1,10922,10923,11123,11122,-1,10923,10924,11124,11123,-1,10924,10925,11125,11124,-1,10925,10926,11126,11125,-1,10926,10927,11127,11126,-1,10927,10928,11128,11127,-1,10928,10929,11129,11128,-1,10929,10930,11130,11129,-1,10930,10931,11131,11130,-1,10931,10932,11132,11131,-1,10932,10933,11133,11132,-1,10933,10934,11134,11133,-1,10934,10935,11135,11134,-1,10935,10936,11136,11135,-1,10936,10937,11137,11136,-1,10937,10938,11138,11137,-1,10938,10939,11139,11138,-1,10939,10940,11140,11139,-1,10940,10941,11141,11140,-1,10941,10942,11142,11141,-1,10942,10943,11143,11142,-1,10943,10944,11144,11143,-1,10944,10945,11145,11144,-1,10945,10946,11146,11145,-1,10946,10947,11147,11146,-1,10947,10948,11148,11147,-1,10948,10949,11149,11148,-1,10949,10950,11150,11149,-1,10950,10951,11151,11150,-1,10951,10952,11152,11151,-1,10952,10953,11153,11152,-1,10953,10954,11154,11153,-1,10954,10955,11155,11154,-1,10955,10956,11156,11155,-1,10956,10957,11157,11156,-1,10957,10958,11158,11157,-1,10958,10959,11159,11158,-1,10959,10960,11160,11159,-1,10960,10961,11161,11160,-1,10961,10962,11162,11161,-1,10962,10963,11163,11162,-1,10963,10964,11164,11163,-1,10964,10965,11165,11164,-1,10965,10966,11166,11165,-1,10966,10967,11167,11166,-1,10967,10968,11168,11167,-1,10968,10969,11169,11168,-1,10969,10970,11170,11169,-1,10970,10971,11171,11170,-1,10971,10972,11172,11171,-1,10972,10973,11173,11172,-1,10973,10974,11174,11173,-1,10974,10975,11175,11174,-1,10975,10976,11176,11175,-1,10976,10977,11177,11176,-1,10977,10978,11178,11177,-1,10978,10979,11179,11178,-1,10979,10980,11180,11179,-1,10980,10981,11181,11180,-1,10981,10982,11182,11181,-1,10982,10983,11183,11182,-1,10983,10984,11184,11183,-1,10984,10985,11185,11184,-1,10985,10986,11186,11185,-1,10986,10987,11187,11186,-1,10987,10988,11188,11187,-1,10988,10989,11189,11188,-1,10989,10990,11190,11189,-1,10990,10991,11191,11190,-1,10991,10992,11192,11191,-1,10992,10993,11193,11192,-1,10993,10994,11194,11193,-1,10994,10995,11195,11194,-1,10995,10996,11196,11195,-1,10996,10997,11197,11196,-1,10997,10998,11198,11197,-1,10998,10999,11199,11198,-1,11,11001,11201,11200,-1,11001,11002,11202,11201,-1,11002,11003,11203,11202,-1,11003,11004,11204,11203,-1,11004,11005,11205,11204,-1,11005,11006,11206,11205,-1,11006,11007,11207,11206,-1,11007,11008,11208,11207,-1,11008,11009,11209,11208,-1,11009,11010,11210,11209,-1,11010,11011,11211,11210,-1,11011,11012,11212,11211,-1,11012,11013,11213,11212,-1,11013,11014,11214,11213,-1,11014,11015,11215,11214,-1,11015,11016,11216,11215,-1,11016,11017,11217,11216,-1,11017,11018,11218,11217,-1,11018,11019,11219,11218,-1,11019,11020,11220,11219,-1,11020,11021,11221,11220,-1,11021,11022,11222,11221,-1,11022,11023,11223,11222,-1,11023,11024,11224,11223,-1,11024,11025,11225,11224,-1,11025,11026,11226,11225,-1,11026,11027,11227,11226,-1,11027,11028,11228,11227,-1,11028,11029,11229,11228,-1,11029,11030,11230,11229,-1,11030,11031,11231,11230,-1,11031,11032,11232,11231,-1,11032,11033,11233,11232,-1,11033,11034,11234,11233,-1,11034,11035,11235,11234,-1,11035,11036,11236,11235,-1,11036,11037,11237,11236,-1,11037,11038,11238,11237,-1,11038,11039,11239,11238,-1,11039,11040,11240,11239,-1,11040,11041,11241,11240,-1,11041,11042,11242,11241,-1,11042,11043,11243,11242,-1,11043,11044,11244,11243,-1,11044,11045,11245,11244,-1,11045,11046,11246,11245,-1,11046,11047,11247,11246,-1,11047,11048,11248,11247,-1,11048,11049,11249,11248,-1,11049,11050,11250,11249,-1,11050,11051,11251,11250,-1,11051,11052,11252,11251,-1,11052,11053,11253,11252,-1,11053,11054,11254,11253,-1,11054,11055,11255,11254,-1,11055,11056,11256,11255,-1,11056,11057,11257,11256,-1,11057,11058,11258,11257,-1,11058,11059,11259,11258,-1,11059,11060,11260,11259,-1,11060,11061,11261,11260,-1,11061,11062,11262,11261,-1,11062,11063,11263,11262,-1,11063,11064,11264,11263,-1,11064,11065,11265,11264,-1,11065,11066,11266,11265,-1,11066,11067,11267,11266,-1,11067,11068,11268,11267,-1,11068,11069,11269,11268,-1,11069,11070,11270,11269,-1,11070,11071,11271,11270,-1,11071,11072,11272,11271,-1,11072,11073,11273,11272,-1,11073,11074,11274,11273,-1,11074,11075,11275,11274,-1,11075,11076,11276,11275,-1,11076,11077,11277,11276,-1,11077,11078,11278,11277,-1,11078,11079,11279,11278,-1,11079,11080,11280,11279,-1,11080,11081,11281,11280,-1,11081,11082,11282,11281,-1,11082,11083,11283,11282,-1,11083,11084,11284,11283,-1,11084,11085,11285,11284,-1,11085,11086,11286,11285,-1,11086,11087,11287,11286,-1,11087,11088,11288,11287,-1,11088,11089,11289,11288,-1,11089,11090,11290,11289,-1,11090,11091,11291,11290,-1,11091,11092,11292,11291,-1,11092,11093,11293,11292,-1,11093,11094,11294,11293,-1,11094,11095,11295,11294,-1,11095,11096,11296,11295,-1,11096,11097,11297,11296,-1,11097,11098,11298,11297,-1,11098,11099,11299,11298,-1,11099,11100,11300,11299,-1,11100,11101,11301,11300,-1,11101,11102,11302,11301,-1,11102,11103,11303,11302,-1,11103,11104,11304,11303,-1,11104,11105,11305,11304,-1,11105,11106,11306,11305,-1,11106,11107,11307,11306,-1,11107,11108,11308,11307,-1,11108,11109,11309,11308,-1,11109,11110,11310,11309,-1,11110,11111,11311,11310,-1,11111,11112,11312,11311,-1,11112,11113,11313,11312,-1,11113,11114,11314,11313,-1,11114,11115,11315,11314,-1,11115,11116,11316,11315,-1,11116,11117,11317,11316,-1,11117,11118,11318,11317,-1,11118,11119,11319,11318,-1,11119,11120,11320,11319,-1,11120,11121,11321,11320,-1,11121,11122,11322,11321,-1,11122,11123,11323,11322,-1,11123,11124,11324,11323,-1,11124,11125,11325,11324,-1,11125,11126,11326,11325,-1,11126,11127,11327,11326,-1,11127,11128,11328,11327,-1,11128,11129,11329,11328,-1,11129,11130,11330,11329,-1,11130,11131,11331,11330,-1,11131,11132,11332,11331,-1,11132,11133,11333,11332,-1,11133,11134,11334,11333,-1,11134,11135,11335,11334,-1,11135,11136,11336,11335,-1,11136,11137,11337,11336,-1,11137,11138,11338,11337,-1,11138,11139,11339,11338,-1,11139,11140,11340,11339,-1,11140,11141,11341,11340,-1,11141,11142,11342,11341,-1,11142,11143,11343,11342,-1,11143,11144,11344,11343,-1,11144,11145,11345,11344,-1,11145,11146,11346,11345,-1,11146,11147,11347,11346,-1,11147,11148,11348,11347,-1,11148,11149,11349,11348,-1,11149,11150,11350,11349,-1,11150,11151,11351,11350,-1,11151,11152,11352,11351,-1,11152,11153,11353,11352,-1,11153,11154,11354,11353,-1,11154,11155,11355,11354,-1,11155,11156,11356,11355,-1,11156,11157,11357,11356,-1,11157,11158,11358,11357,-1,11158,11159,11359,11358,-1,11159,11160,11360,11359,-1,11160,11161,11361,11360,-1,11161,11162,11362,11361,-1,11162,11163,11363,11362,-1,11163,11164,11364,11363,-1,11164,11165,11365,11364,-1,11165,11166,11366,11365,-1,11166,11167,11367,11366,-1,11167,11168,11368,11367,-1,11168,11169,11369,11368,-1,11169,11170,11370,11369,-1,11170,11171,11371,11370,-1,11171,11172,11372,11371,-1,11172,11173,11373,11372,-1,11173,11174,11374,11373,-1,11174,11175,11375,11374,-1,11175,11176,11376,11375,-1,11176,11177,11377,11376,-1,11177,11178,11378,11377,-1,11178,11179,11379,11378,-1,11179,11180,11380,11379,-1,11180,11181,11381,11380,-1,11181,11182,11382,11381,-1,11182,11183,11383,11382,-1,11183,11184,11384,11383,-1,11184,11185,11385,11384,-1,11185,11186,11386,11385,-1,11186,11187,11387,11386,-1,11187,11188,11388,11387,-1,11188,11189,11389,11388,-1,11189,11190,11390,11389,-1,11190,11191,11391,11390,-1,11191,11192,11392,11391,-1,11192,11193,11393,11392,-1,11193,11194,11394,11393,-1,11194,11195,11395,11394,-1,11195,11196,11396,11395,-1,11196,11197,11397,11396,-1,11197,11198,11398,11397,-1,11198,11199,11399,11398,-1,11200,11201,11401,11400,-1,11201,11202,11402,11401,-1,11202,11203,11403,11402,-1,11203,11204,11404,11403,-1,11204,11205,11405,11404,-1,11205,11206,11406,11405,-1,11206,11207,11407,11406,-1,11207,11208,11408,11407,-1,11208,11209,11409,11408,-1,11209,11210,11410,11409,-1,11210,11211,11411,11410,-1,11211,11212,11412,11411,-1,11212,11213,11413,11412,-1,11213,11214,11414,11413,-1,11214,11215,11415,11414,-1,11215,11216,11416,11415,-1,11216,11217,11417,11416,-1,11217,11218,11418,11417,-1,11218,11219,11419,11418,-1,11219,11220,11420,11419,-1,11220,11221,11421,11420,-1,11221,11222,11422,11421,-1,11222,11223,11423,11422,-1,11223,11224,11424,11423,-1,11224,11225,11425,11424,-1,11225,11226,11426,11425,-1,11226,11227,11427,11426,-1,11227,11228,11428,11427,-1,11228,11229,11429,11428,-1,11229,11230,11430,11429,-1,11230,11231,11431,11430,-1,11231,11232,11432,11431,-1,11232,11233,11433,11432,-1,11233,11234,11434,11433,-1,11234,11235,11435,11434,-1,11235,11236,11436,11435,-1,11236,11237,11437,11436,-1,11237,11238,11438,11437,-1,11238,11239,11439,11438,-1,11239,11240,11440,11439,-1,11240,11241,11441,11440,-1,11241,11242,11442,11441,-1,11242,11243,11443,11442,-1,11243,11244,11444,11443,-1,11244,11245,11445,11444,-1,11245,11246,11446,11445,-1,11246,11247,11447,11446,-1,11247,11248,11448,11447,-1,11248,11249,11449,11448,-1,11249,11250,11450,11449,-1,11250,11251,11451,11450,-1,11251,11252,11452,11451,-1,11252,11253,11453,11452,-1,11253,11254,11454,11453,-1,11254,11255,11455,11454,-1,11255,11256,11456,11455,-1,11256,11257,11457,11456,-1,11257,11258,11458,11457,-1,11258,11259,11459,11458,-1,11259,11260,11460,11459,-1,11260,11261,11461,11460,-1,11261,11262,11462,11461,-1,11262,11263,11463,11462,-1,11263,11264,11464,11463,-1,11264,11265,11465,11464,-1,11265,11266,11466,11465,-1,11266,11267,11467,11466,-1,11267,11268,11468,11467,-1,11268,11269,11469,11468,-1,11269,11270,11470,11469,-1,11270,11271,11471,11470,-1,11271,11272,11472,11471,-1,11272,11273,11473,11472,-1,11273,11274,11474,11473,-1,11274,11275,11475,11474,-1,11275,11276,11476,11475,-1,11276,11277,11477,11476,-1,11277,11278,11478,11477,-1,11278,11279,11479,11478,-1,11279,11280,11480,11479,-1,11280,11281,11481,11480,-1,11281,11282,11482,11481,-1,11282,11283,11483,11482,-1,11283,11284,11484,11483,-1,11284,11285,11485,11484,-1,11285,11286,11486,11485,-1,11286,11287,11487,11486,-1,11287,11288,11488,11487,-1,11288,11289,11489,11488,-1,11289,11290,11490,11489,-1,11290,11291,11491,11490,-1,11291,11292,11492,11491,-1,11292,11293,11493,11492,-1,11293,11294,11494,11493,-1,11294,11295,11495,11494,-1,11295,11296,11496,11495,-1,11296,11297,11497,11496,-1,11297,11298,11498,11497,-1,11298,11299,11499,11498,-1,11299,11300,11500,11499,-1,11300,11301,11501,11500,-1,11301,11302,11502,11501,-1,11302,11303,11503,11502,-1,11303,11304,11504,11503,-1,11304,11305,11505,11504,-1,11305,11306,11506,11505,-1,11306,11307,11507,11506,-1,11307,11308,11508,11507,-1,11308,11309,11509,11508,-1,11309,11310,11510,11509,-1,11310,11311,11511,11510,-1,11311,11312,11512,11511,-1,11312,11313,11513,11512,-1,11313,11314,11514,11513,-1,11314,11315,11515,11514,-1,11315,11316,11516,11515,-1,11316,11317,11517,11516,-1,11317,11318,11518,11517,-1,11318,11319,11519,11518,-1,11319,11320,11520,11519,-1,11320,11321,11521,11520,-1,11321,11322,11522,11521,-1,11322,11323,11523,11522,-1,11323,11324,11524,11523,-1,11324,11325,11525,11524,-1,11325,11326,11526,11525,-1,11326,11327,11527,11526,-1,11327,11328,11528,11527,-1,11328,11329,11529,11528,-1,11329,11330,11530,11529,-1,11330,11331,11531,11530,-1,11331,11332,11532,11531,-1,11332,11333,11533,11532,-1,11333,11334,11534,11533,-1,11334,11335,11535,11534,-1,11335,11336,11536,11535,-1,11336,11337,11537,11536,-1,11337,11338,11538,11537,-1,11338,11339,11539,11538,-1,11339,11340,11540,11539,-1,11340,11341,11541,11540,-1,11341,11342,11542,11541,-1,11342,11343,11543,11542,-1,11343,11344,11544,11543,-1,11344,11345,11545,11544,-1,11345,11346,11546,11545,-1,11346,11347,11547,11546,-1,11347,11348,11548,11547,-1,11348,11349,11549,11548,-1,11349,11350,11550,11549,-1,11350,11351,11551,11550,-1,11351,11352,11552,11551,-1,11352,11353,11553,11552,-1,11353,11354,11554,11553,-1,11354,11355,11555,11554,-1,11355,11356,11556,11555,-1,11356,11357,11557,11556,-1,11357,11358,11558,11557,-1,11358,11359,11559,11558,-1,11359,11360,11560,11559,-1,11360,11361,11561,11560,-1,11361,11362,11562,11561,-1,11362,11363,11563,11562,-1,11363,11364,11564,11563,-1,11364,11365,11565,11564,-1,11365,11366,11566,11565,-1,11366,11367,11567,11566,-1,11367,11368,11568,11567,-1,11368,11369,11569,11568,-1,11369,11370,11570,11569,-1,11370,11371,11571,11570,-1,11371,11372,11572,11571,-1,11372,11373,11573,11572,-1,11373,11374,11574,11573,-1,11374,11375,11575,11574,-1,11375,11376,11576,11575,-1,11376,11377,11577,11576,-1,11377,11378,11578,11577,-1,11378,11379,11579,11578,-1,11379,11380,11580,11579,-1,11380,11381,11581,11580,-1,11381,11382,11582,11581,-1,11382,11383,11583,11582,-1,11383,11384,11584,11583,-1,11384,11385,11585,11584,-1,11385,11386,11586,11585,-1,11386,11387,11587,11586,-1,11387,11388,11588,11587,-1,11388,11389,11589,11588,-1,11389,11390,11590,11589,-1,11390,11391,11591,11590,-1,11391,11392,11592,11591,-1,11392,11393,11593,11592,-1,11393,11394,11594,11593,-1,11394,11395,11595,11594,-1,11395,11396,11596,11595,-1,11396,11397,11597,11596,-1,11397,11398,11598,11597,-1,11398,11399,11599,11598,-1,11400,11401,11601,11600,-1,11401,11402,11602,11601,-1,11402,11403,11603,11602,-1,11403,11404,11604,11603,-1,11404,11405,11605,11604,-1,11405,11406,11606,11605,-1,11406,11407,11607,11606,-1,11407,11408,11608,11607,-1,11408,11409,11609,11608,-1,11409,11410,11610,11609,-1,11410,11411,11611,11610,-1,11411,11412,11612,11611,-1,11412,11413,11613,11612,-1,11413,11414,11614,11613,-1,11414,11415,11615,11614,-1,11415,11416,11616,11615,-1,11416,11417,11617,11616,-1,11417,11418,11618,11617,-1,11418,11419,11619,11618,-1,11419,11420,11620,11619,-1,11420,11421,11621,11620,-1,11421,11422,11622,11621,-1,11422,11423,11623,11622,-1,11423,11424,11624,11623,-1,11424,11425,11625,11624,-1,11425,11426,11626,11625,-1,11426,11427,11627,11626,-1,11427,11428,11628,11627,-1,11428,11429,11629,11628,-1,11429,11430,11630,11629,-1,11430,11431,11631,11630,-1,11431,11432,11632,11631,-1,11432,11433,11633,11632,-1,11433,11434,11634,11633,-1,11434,11435,11635,11634,-1,11435,11436,11636,11635,-1,11436,11437,11637,11636,-1,11437,11438,11638,11637,-1,11438,11439,11639,11638,-1,11439,11440,11640,11639,-1,11440,11441,11641,11640,-1,11441,11442,11642,11641,-1,11442,11443,11643,11642,-1,11443,11444,11644,11643,-1,11444,11445,11645,11644,-1,11445,11446,11646,11645,-1,11446,11447,11647,11646,-1,11447,11448,11648,11647,-1,11448,11449,11649,11648,-1,11449,11450,11650,11649,-1,11450,11451,11651,11650,-1,11451,11452,11652,11651,-1,11452,11453,11653,11652,-1,11453,11454,11654,11653,-1,11454,11455,11655,11654,-1,11455,11456,11656,11655,-1,11456,11457,11657,11656,-1,11457,11458,11658,11657,-1,11458,11459,11659,11658,-1,11459,11460,11660,11659,-1,11460,11461,11661,11660,-1,11461,11462,11662,11661,-1,11462,11463,11663,11662,-1,11463,11464,11664,11663,-1,11464,11465,11665,11664,-1,11465,11466,11666,11665,-1,11466,11467,11667,11666,-1,11467,11468,11668,11667,-1,11468,11469,11669,11668,-1,11469,11470,11670,11669,-1,11470,11471,11671,11670,-1,11471,11472,11672,11671,-1,11472,11473,11673,11672,-1,11473,11474,11674,11673,-1,11474,11475,11675,11674,-1,11475,11476,11676,11675,-1,11476,11477,11677,11676,-1,11477,11478,11678,11677,-1,11478,11479,11679,11678,-1,11479,11480,11680,11679,-1,11480,11481,11681,11680,-1,11481,11482,11682,11681,-1,11482,11483,11683,11682,-1,11483,11484,11684,11683,-1,11484,11485,11685,11684,-1,11485,11486,11686,11685,-1,11486,11487,11687,11686,-1,11487,11488,11688,11687,-1,11488,11489,11689,11688,-1,11489,11490,11690,11689,-1,11490,11491,11691,11690,-1,11491,11492,11692,11691,-1,11492,11493,11693,11692,-1,11493,11494,11694,11693,-1,11494,11495,11695,11694,-1,11495,11496,11696,11695,-1,11496,11497,11697,11696,-1,11497,11498,11698,11697,-1,11498,11499,11699,11698,-1,11499,11500,11700,11699,-1,11500,11501,11701,11700,-1,11501,11502,11702,11701,-1,11502,11503,11703,11702,-1,11503,11504,11704,11703,-1,11504,11505,11705,11704,-1,11505,11506,11706,11705,-1,11506,11507,11707,11706,-1,11507,11508,11708,11707,-1,11508,11509,11709,11708,-1,11509,11510,11710,11709,-1,11510,11511,11711,11710,-1,11511,11512,11712,11711,-1,11512,11513,11713,11712,-1,11513,11514,11714,11713,-1,11514,11515,11715,11714,-1,11515,11516,11716,11715,-1,11516,11517,11717,11716,-1,11517,11518,11718,11717,-1,11518,11519,11719,11718,-1,11519,11520,11720,11719,-1,11520,11521,11721,11720,-1,11521,11522,11722,11721,-1,11522,11523,11723,11722,-1,11523,11524,11724,11723,-1,11524,11525,11725,11724,-1,11525,11526,11726,11725,-1,11526,11527,11727,11726,-1,11527,11528,11728,11727,-1,11528,11529,11729,11728,-1,11529,11530,11730,11729,-1,11530,11531,11731,11730,-1,11531,11532,11732,11731,-1,11532,11533,11733,11732,-1,11533,11534,11734,11733,-1,11534,11535,11735,11734,-1,11535,11536,11736,11735,-1,11536,11537,11737,11736,-1,11537,11538,11738,11737,-1,11538,11539,11739,11738,-1,11539,11540,11740,11739,-1,11540,11541,11741,11740,-1,11541,11542,11742,11741,-1,11542,11543,11743,11742,-1,11543,11544,11744,11743,-1,11544,11545,11745,11744,-1,11545,11546,11746,11745,-1,11546,11547,11747,11746,-1,11547,11548,11748,11747,-1,11548,11549,11749,11748,-1,11549,11550,11750,11749,-1,11550,11551,11751,11750,-1,11551,11552,11752,11751,-1,11552,11553,11753,11752,-1,11553,11554,11754,11753,-1,11554,11555,11755,11754,-1,11555,11556,11756,11755,-1,11556,11557,11757,11756,-1,11557,11558,11758,11757,-1,11558,11559,11759,11758,-1,11559,11560,11760,11759,-1,11560,11561,11761,11760,-1,11561,11562,11762,11761,-1,11562,11563,11763,11762,-1,11563,11564,11764,11763,-1,11564,11565,11765,11764,-1,11565,11566,11766,11765,-1,11566,11567,11767,11766,-1,11567,11568,11768,11767,-1,11568,11569,11769,11768,-1,11569,11570,11770,11769,-1,11570,11571,11771,11770,-1,11571,11572,11772,11771,-1,11572,11573,11773,11772,-1,11573,11574,11774,11773,-1,11574,11575,11775,11774,-1,11575,11576,11776,11775,-1,11576,11577,11777,11776,-1,11577,11578,11778,11777,-1,11578,11579,11779,11778,-1,11579,11580,11780,11779,-1,11580,11581,11781,11780,-1,11581,11582,11782,11781,-1,11582,11583,11783,11782,-1,11583,11584,11784,11783,-1,11584,11585,11785,11784,-1,11585,11586,11786,11785,-1,11586,11587,11787,11786,-1,11587,11588,11788,11787,-1,11588,11589,11789,11788,-1,11589,11590,11790,11789,-1,11590,11591,11791,11790,-1,11591,11592,11792,11791,-1,11592,11593,11793,11792,-1,11593,11594,11794,11793,-1,11594,11595,11795,11794,-1,11595,11596,11796,11795,-1,11596,11597,11797,11796,-1,11597,11598,11798,11797,-1,11598,11599,11799,11798,-1,11600,11601,11801,11800,-1,11601,11602,11802,11801,-1,11602,11603,11803,11802,-1,11603,11604,11804,11803,-1,11604,11605,11805,11804,-1,11605,11606,11806,11805,-1,11606,11607,11807,11806,-1,11607,11608,11808,11807,-1,11608,11609,11809,11808,-1,11609,11610,11810,11809,-1,11610,11611,11811,11810,-1,11611,11612,11812,11811,-1,11612,11613,11813,11812,-1,11613,11614,11814,11813,-1,11614,11615,11815,11814,-1,11615,11616,11816,11815,-1,11616,11617,11817,11816,-1,11617,11618,11818,11817,-1,11618,11619,11819,11818,-1,11619,11620,11820,11819,-1,11620,11621,11821,11820,-1,11621,11622,11822,11821,-1,11622,11623,11823,11822,-1,11623,11624,11824,11823,-1,11624,11625,11825,11824,-1,11625,11626,11826,11825,-1,11626,11627,11827,11826,-1,11627,11628,11828,11827,-1,11628,11629,11829,11828,-1,11629,11630,11830,11829,-1,11630,11631,11831,11830,-1,11631,11632,11832,11831,-1,11632,11633,11833,11832,-1,11633,11634,11834,11833,-1,11634,11635,11835,11834,-1,11635,11636,11836,11835,-1,11636,11637,11837,11836,-1,11637,11638,11838,11837,-1,11638,11639,11839,11838,-1,11639,11640,11840,11839,-1,11640,11641,11841,11840,-1,11641,11642,11842,11841,-1,11642,11643,11843,11842,-1,11643,11644,11844,11843,-1,11644,11645,11845,11844,-1,11645,11646,11846,11845,-1,11646,11647,11847,11846,-1,11647,11648,11848,11847,-1,11648,11649,11849,11848,-1,11649,11650,11850,11849,-1,11650,11651,11851,11850,-1,11651,11652,11852,11851,-1,11652,11653,11853,11852,-1,11653,11654,11854,11853,-1,11654,11655,11855,11854,-1,11655,11656,11856,11855,-1,11656,11657,11857,11856,-1,11657,11658,11858,11857,-1,11658,11659,11859,11858,-1,11659,11660,11860,11859,-1,11660,11661,11861,11860,-1,11661,11662,11862,11861,-1,11662,11663,11863,11862,-1,11663,11664,11864,11863,-1,11664,11665,11865,11864,-1,11665,11666,11866,11865,-1,11666,11667,11867,11866,-1,11667,11668,11868,11867,-1,11668,11669,11869,11868,-1,11669,11670,11870,11869,-1,11670,11671,11871,11870,-1,11671,11672,11872,11871,-1,11672,11673,11873,11872,-1,11673,11674,11874,11873,-1,11674,11675,11875,11874,-1,11675,11676,11876,11875,-1,11676,11677,11877,11876,-1,11677,11678,11878,11877,-1,11678,11679,11879,11878,-1,11679,11680,11880,11879,-1,11680,11681,11881,11880,-1,11681,11682,11882,11881,-1,11682,11683,11883,11882,-1,11683,11684,11884,11883,-1,11684,11685,11885,11884,-1,11685,11686,11886,11885,-1,11686,11687,11887,11886,-1,11687,11688,11888,11887,-1,11688,11689,11889,11888,-1,11689,11690,11890,11889,-1,11690,11691,11891,11890,-1,11691,11692,11892,11891,-1,11692,11693,11893,11892,-1,11693,11694,11894,11893,-1,11694,11695,11895,11894,-1,11695,11696,11896,11895,-1,11696,11697,11897,11896,-1,11697,11698,11898,11897,-1,11698,11699,11899,11898,-1,11699,11700,11900,11899,-1,11700,11701,11901,11900,-1,11701,11702,11902,11901,-1,11702,11703,11903,11902,-1,11703,11704,11904,11903,-1,11704,11705,11905,11904,-1,11705,11706,11906,11905,-1,11706,11707,11907,11906,-1,11707,11708,11908,11907,-1,11708,11709,11909,11908,-1,11709,11710,11910,11909,-1,11710,11711,11911,11910,-1,11711,11712,11912,11911,-1,11712,11713,11913,11912,-1,11713,11714,11914,11913,-1,11714,11715,11915,11914,-1,11715,11716,11916,11915,-1,11716,11717,11917,11916,-1,11717,11718,11918,11917,-1,11718,11719,11919,11918,-1,11719,11720,11920,11919,-1,11720,11721,11921,11920,-1,11721,11722,11922,11921,-1,11722,11723,11923,11922,-1,11723,11724,11924,11923,-1,11724,11725,11925,11924,-1,11725,11726,11926,11925,-1,11726,11727,11927,11926,-1,11727,11728,11928,11927,-1,11728,11729,11929,11928,-1,11729,11730,11930,11929,-1,11730,11731,11931,11930,-1,11731,11732,11932,11931,-1,11732,11733,11933,11932,-1,11733,11734,11934,11933,-1,11734,11735,11935,11934,-1,11735,11736,11936,11935,-1,11736,11737,11937,11936,-1,11737,11738,11938,11937,-1,11738,11739,11939,11938,-1,11739,11740,11940,11939,-1,11740,11741,11941,11940,-1,11741,11742,11942,11941,-1,11742,11743,11943,11942,-1,11743,11744,11944,11943,-1,11744,11745,11945,11944,-1,11745,11746,11946,11945,-1,11746,11747,11947,11946,-1,11747,11748,11948,11947,-1,11748,11749,11949,11948,-1,11749,11750,11950,11949,-1,11750,11751,11951,11950,-1,11751,11752,11952,11951,-1,11752,11753,11953,11952,-1,11753,11754,11954,11953,-1,11754,11755,11955,11954,-1,11755,11756,11956,11955,-1,11756,11757,11957,11956,-1,11757,11758,11958,11957,-1,11758,11759,11959,11958,-1,11759,11760,11960,11959,-1,11760,11761,11961,11960,-1,11761,11762,11962,11961,-1,11762,11763,11963,11962,-1,11763,11764,11964,11963,-1,11764,11765,11965,11964,-1,11765,11766,11966,11965,-1,11766,11767,11967,11966,-1,11767,11768,11968,11967,-1,11768,11769,11969,11968,-1,11769,11770,11970,11969,-1,11770,11771,11971,11970,-1,11771,11772,11972,11971,-1,11772,11773,11973,11972,-1,11773,11774,11974,11973,-1,11774,11775,11975,11974,-1,11775,11776,11976,11975,-1,11776,11777,11977,11976,-1,11777,11778,11978,11977,-1,11778,11779,11979,11978,-1,11779,11780,11980,11979,-1,11780,11781,11981,11980,-1,11781,11782,11982,11981,-1,11782,11783,11983,11982,-1,11783,11784,11984,11983,-1,11784,11785,11985,11984,-1,11785,11786,11986,11985,-1,11786,11787,11987,11986,-1,11787,11788,11988,11987,-1,11788,11789,11989,11988,-1,11789,11790,11990,11989,-1,11790,11791,11991,11990,-1,11791,11792,11992,11991,-1,11792,11793,11993,11992,-1,11793,11794,11994,11993,-1,11794,11795,11995,11994,-1,11795,11796,11996,11995,-1,11796,11797,11997,11996,-1,11797,11798,11998,11997,-1,11798,11799,11999,11998,-1,11800,11801,12001,12,-1,11801,11802,12002,12001,-1,11802,11803,12003,12002,-1,11803,11804,12004,12003,-1,11804,11805,12005,12004,-1,11805,11806,12006,12005,-1,11806,11807,12007,12006,-1,11807,11808,12008,12007,-1,11808,11809,12009,12008,-1,11809,11810,12010,12009,-1,11810,11811,12011,12010,-1,11811,11812,12012,12011,-1,11812,11813,12013,12012,-1,11813,11814,12014,12013,-1,11814,11815,12015,12014,-1,11815,11816,12016,12015,-1,11816,11817,12017,12016,-1,11817,11818,12018,12017,-1,11818,11819,12019,12018,-1,11819,11820,12020,12019,-1,11820,11821,12021,12020,-1,11821,11822,12022,12021,-1,11822,11823,12023,12022,-1,11823,11824,12024,12023,-1,11824,11825,12025,12024,-1,11825,11826,12026,12025,-1,11826,11827,12027,12026,-1,11827,11828,12028,12027,-1,11828,11829,12029,12028,-1,11829,11830,12030,12029,-1,11830,11831,12031,12030,-1,11831,11832,12032,12031,-1,11832,11833,12033,12032,-1,11833,11834,12034,12033,-1,11834,11835,12035,12034,-1,11835,11836,12036,12035,-1,11836,11837,12037,12036,-1,11837,11838,12038,12037,-1,11838,11839,12039,12038,-1,11839,11840,12040,12039,-1,11840,11841,12041,12040,-1,11841,11842,12042,12041,-1,11842,11843,12043,12042,-1,11843,11844,12044,12043,-1,11844,11845,12045,12044,-1,11845,11846,12046,12045,-1,11846,11847,12047,12046,-1,11847,11848,12048,12047,-1,11848,11849,12049,12048,-1,11849,11850,12050,12049,-1,11850,11851,12051,12050,-1,11851,11852,12052,12051,-1,11852,11853,12053,12052,-1,11853,11854,12054,12053,-1,11854,11855,12055,12054,-1,11855,11856,12056,12055,-1,11856,11857,12057,12056,-1,11857,11858,12058,12057,-1,11858,11859,12059,12058,-1,11859,11860,12060,12059,-1,11860,11861,12061,12060,-1,11861,11862,12062,12061,-1,11862,11863,12063,12062,-1,11863,11864,12064,12063,-1,11864,11865,12065,12064,-1,11865,11866,12066,12065,-1,11866,11867,12067,12066,-1,11867,11868,12068,12067,-1,11868,11869,12069,12068,-1,11869,11870,12070,12069,-1,11870,11871,12071,12070,-1,11871,11872,12072,12071,-1,11872,11873,12073,12072,-1,11873,11874,12074,12073,-1,11874,11875,12075,12074,-1,11875,11876,12076,12075,-1,11876,11877,12077,12076,-1,11877,11878,12078,12077,-1,11878,11879,12079,12078,-1,11879,11880,12080,12079,-1,11880,11881,12081,12080,-1,11881,11882,12082,12081,-1,11882,11883,12083,12082,-1,11883,11884,12084,12083,-1,11884,11885,12085,12084,-1,11885,11886,12086,12085,-1,11886,11887,12087,12086,-1,11887,11888,12088,12087,-1,11888,11889,12089,12088,-1,11889,11890,12090,12089,-1,11890,11891,12091,12090,-1,11891,11892,12092,12091,-1,11892,11893,12093,12092,-1,11893,11894,12094,12093,-1,11894,11895,12095,12094,-1,11895,11896,12096,12095,-1,11896,11897,12097,12096,-1,11897,11898,12098,12097,-1,11898,11899,12099,12098,-1,11899,11900,12100,12099,-1,11900,11901,12101,12100,-1,11901,11902,12102,12101,-1,11902,11903,12103,12102,-1,11903,11904,12104,12103,-1,11904,11905,12105,12104,-1,11905,11906,12106,12105,-1,11906,11907,12107,12106,-1,11907,11908,12108,12107,-1,11908,11909,12109,12108,-1,11909,11910,12110,12109,-1,11910,11911,12111,12110,-1,11911,11912,12112,12111,-1,11912,11913,12113,12112,-1,11913,11914,12114,12113,-1,11914,11915,12115,12114,-1,11915,11916,12116,12115,-1,11916,11917,12117,12116,-1,11917,11918,12118,12117,-1,11918,11919,12119,12118,-1,11919,11920,12120,12119,-1,11920,11921,12121,12120,-1,11921,11922,12122,12121,-1,11922,11923,12123,12122,-1,11923,11924,12124,12123,-1,11924,11925,12125,12124,-1,11925,11926,12126,12125,-1,11926,11927,12127,12126,-1,11927,11928,12128,12127,-1,11928,11929,12129,12128,-1,11929,11930,12130,12129,-1,11930,11931,12131,12130,-1,11931,11932,12132,12131,-1,11932,11933,12133,12132,-1,11933,11934,12134,12133,-1,11934,11935,12135,12134,-1,11935,11936,12136,12135,-1,11936,11937,12137,12136,-1,11937,11938,12138,12137,-1,11938,11939,12139,12138,-1,11939,11940,12140,12139,-1,11940,11941,12141,12140,-1,11941,11942,12142,12141,-1,11942,11943,12143,12142,-1,11943,11944,12144,12143,-1,11944,11945,12145,12144,-1,11945,11946,12146,12145,-1,11946,11947,12147,12146,-1,11947,11948,12148,12147,-1,11948,11949,12149,12148,-1,11949,11950,12150,12149,-1,11950,11951,12151,12150,-1,11951,11952,12152,12151,-1,11952,11953,12153,12152,-1,11953,11954,12154,12153,-1,11954,11955,12155,12154,-1,11955,11956,12156,12155,-1,11956,11957,12157,12156,-1,11957,11958,12158,12157,-1,11958,11959,12159,12158,-1,11959,11960,12160,12159,-1,11960,11961,12161,12160,-1,11961,11962,12162,12161,-1,11962,11963,12163,12162,-1,11963,11964,12164,12163,-1,11964,11965,12165,12164,-1,11965,11966,12166,12165,-1,11966,11967,12167,12166,-1,11967,11968,12168,12167,-1,11968,11969,12169,12168,-1,11969,11970,12170,12169,-1,11970,11971,12171,12170,-1,11971,11972,12172,12171,-1,11972,11973,12173,12172,-1,11973,11974,12174,12173,-1,11974,11975,12175,12174,-1,11975,11976,12176,12175,-1,11976,11977,12177,12176,-1,11977,11978,12178,12177,-1,11978,11979,12179,12178,-1,11979,11980,12180,12179,-1,11980,11981,12181,12180,-1,11981,11982,12182,12181,-1,11982,11983,12183,12182,-1,11983,11984,12184,12183,-1,11984,11985,12185,12184,-1,11985,11986,12186,12185,-1,11986,11987,12187,12186,-1,11987,11988,12188,12187,-1,11988,11989,12189,12188,-1,11989,11990,12190,12189,-1,11990,11991,12191,12190,-1,11991,11992,12192,12191,-1,11992,11993,12193,12192,-1,11993,11994,12194,12193,-1,11994,11995,12195,12194,-1,11995,11996,12196,12195,-1,11996,11997,12197,12196,-1,11997,11998,12198,12197,-1,11998,11999,12199,12198,-1,12,12001,12201,12200,-1,12001,12002,12202,12201,-1,12002,12003,12203,12202,-1,12003,12004,12204,12203,-1,12004,12005,12205,12204,-1,12005,12006,12206,12205,-1,12006,12007,12207,12206,-1,12007,12008,12208,12207,-1,12008,12009,12209,12208,-1,12009,12010,12210,12209,-1,12010,12011,12211,12210,-1,12011,12012,12212,12211,-1,12012,12013,12213,12212,-1,12013,12014,12214,12213,-1,12014,12015,12215,12214,-1,12015,12016,12216,12215,-1,12016,12017,12217,12216,-1,12017,12018,12218,12217,-1,12018,12019,12219,12218,-1,12019,12020,12220,12219,-1,12020,12021,12221,12220,-1,12021,12022,12222,12221,-1,12022,12023,12223,12222,-1,12023,12024,12224,12223,-1,12024,12025,12225,12224,-1,12025,12026,12226,12225,-1,12026,12027,12227,12226,-1,12027,12028,12228,12227,-1,12028,12029,12229,12228,-1,12029,12030,12230,12229,-1,12030,12031,12231,12230,-1,12031,12032,12232,12231,-1,12032,12033,12233,12232,-1,12033,12034,12234,12233,-1,12034,12035,12235,12234,-1,12035,12036,12236,12235,-1,12036,12037,12237,12236,-1,12037,12038,12238,12237,-1,12038,12039,12239,12238,-1,12039,12040,12240,12239,-1,12040,12041,12241,12240,-1,12041,12042,12242,12241,-1,12042,12043,12243,12242,-1,12043,12044,12244,12243,-1,12044,12045,12245,12244,-1,12045,12046,12246,12245,-1,12046,12047,12247,12246,-1,12047,12048,12248,12247,-1,12048,12049,12249,12248,-1,12049,12050,12250,12249,-1,12050,12051,12251,12250,-1,12051,12052,12252,12251,-1,12052,12053,12253,12252,-1,12053,12054,12254,12253,-1,12054,12055,12255,12254,-1,12055,12056,12256,12255,-1,12056,12057,12257,12256,-1,12057,12058,12258,12257,-1,12058,12059,12259,12258,-1,12059,12060,12260,12259,-1,12060,12061,12261,12260,-1,12061,12062,12262,12261,-1,12062,12063,12263,12262,-1,12063,12064,12264,12263,-1,12064,12065,12265,12264,-1,12065,12066,12266,12265,-1,12066,12067,12267,12266,-1,12067,12068,12268,12267,-1,12068,12069,12269,12268,-1,12069,12070,12270,12269,-1,12070,12071,12271,12270,-1,12071,12072,12272,12271,-1,12072,12073,12273,12272,-1,12073,12074,12274,12273,-1,12074,12075,12275,12274,-1,12075,12076,12276,12275,-1,12076,12077,12277,12276,-1,12077,12078,12278,12277,-1,12078,12079,12279,12278,-1,12079,12080,12280,12279,-1,12080,12081,12281,12280,-1,12081,12082,12282,12281,-1,12082,12083,12283,12282,-1,12083,12084,12284,12283,-1,12084,12085,12285,12284,-1,12085,12086,12286,12285,-1,12086,12087,12287,12286,-1,12087,12088,12288,12287,-1,12088,12089,12289,12288,-1,12089,12090,12290,12289,-1,12090,12091,12291,12290,-1,12091,12092,12292,12291,-1,12092,12093,12293,12292,-1,12093,12094,12294,12293,-1,12094,12095,12295,12294,-1,12095,12096,12296,12295,-1,12096,12097,12297,12296,-1,12097,12098,12298,12297,-1,12098,12099,12299,12298,-1,12099,12100,12300,12299,-1,12100,12101,12301,12300,-1,12101,12102,12302,12301,-1,12102,12103,12303,12302,-1,12103,12104,12304,12303,-1,12104,12105,12305,12304,-1,12105,12106,12306,12305,-1,12106,12107,12307,12306,-1,12107,12108,12308,12307,-1,12108,12109,12309,12308,-1,12109,12110,12310,12309,-1,12110,12111,12311,12310,-1,12111,12112,12312,12311,-1,12112,12113,12313,12312,-1,12113,12114,12314,12313,-1,12114,12115,12315,12314,-1,12115,12116,12316,12315,-1,12116,12117,12317,12316,-1,12117,12118,12318,12317,-1,12118,12119,12319,12318,-1,12119,12120,12320,12319,-1,12120,12121,12321,12320,-1,12121,12122,12322,12321,-1,12122,12123,12323,12322,-1,12123,12124,12324,12323,-1,12124,12125,12325,12324,-1,12125,12126,12326,12325,-1,12126,12127,12327,12326,-1,12127,12128,12328,12327,-1,12128,12129,12329,12328,-1,12129,12130,12330,12329,-1,12130,12131,12331,12330,-1,12131,12132,12332,12331,-1,12132,12133,12333,12332,-1,12133,12134,12334,12333,-1,12134,12135,12335,12334,-1,12135,12136,12336,12335,-1,12136,12137,12337,12336,-1,12137,12138,12338,12337,-1,12138,12139,12339,12338,-1,12139,12140,12340,12339,-1,12140,12141,12341,12340,-1,12141,12142,12342,12341,-1,12142,12143,12343,12342,-1,12143,12144,12344,12343,-1,12144,12145,12345,12344,-1,12145,12146,12346,12345,-1,12146,12147,12347,12346,-1,12147,12148,12348,12347,-1,12148,12149,12349,12348,-1,12149,12150,12350,12349,-1,12150,12151,12351,12350,-1,12151,12152,12352,12351,-1,12152,12153,12353,12352,-1,12153,12154,12354,12353,-1,12154,12155,12355,12354,-1,12155,12156,12356,12355,-1,12156,12157,12357,12356,-1,12157,12158,12358,12357,-1,12158,12159,12359,12358,-1,12159,12160,12360,12359,-1,12160,12161,12361,12360,-1,12161,12162,12362,12361,-1,12162,12163,12363,12362,-1,12163,12164,12364,12363,-1,12164,12165,12365,12364,-1,12165,12166,12366,12365,-1,12166,12167,12367,12366,-1,12167,12168,12368,12367,-1,12168,12169,12369,12368,-1,12169,12170,12370,12369,-1,12170,12171,12371,12370,-1,12171,12172,12372,12371,-1,12172,12173,12373,12372,-1,12173,12174,12374,12373,-1,12174,12175,12375,12374,-1,12175,12176,12376,12375,-1,12176,12177,12377,12376,-1,12177,12178,12378,12377,-1,12178,12179,12379,12378,-1,12179,12180,12380,12379,-1,12180,12181,12381,12380,-1,12181,12182,12382,12381,-1,12182,12183,12383,12382,-1,12183,12184,12384,12383,-1,12184,12185,12385,12384,-1,12185,12186,12386,12385,-1,12186,12187,12387,12386,-1,12187,12188,12388,12387,-1,12188,12189,12389,12388,-1,12189,12190,12390,12389,-1,12190,12191,12391,12390,-1,12191,12192,12392,12391,-1,12192,12193,12393,12392,-1,12193,12194,12394,12393,-1,12194,12195,12395,12394,-1,12195,12196,12396,12395,-1,12196,12197,12397,12396,-1,12197,12198,12398,12397,-1,12198,12199,12399,12398,-1,12200,12201,12401,12400,-1,12201,12202,12402,12401,-1,12202,12203,12403,12402,-1,12203,12204,12404,12403,-1,12204,12205,12405,12404,-1,12205,12206,12406,12405,-1,12206,12207,12407,12406,-1,12207,12208,12408,12407,-1,12208,12209,12409,12408,-1,12209,12210,12410,12409,-1,12210,12211,12411,12410,-1,12211,12212,12412,12411,-1,12212,12213,12413,12412,-1,12213,12214,12414,12413,-1,12214,12215,12415,12414,-1,12215,12216,12416,12415,-1,12216,12217,12417,12416,-1,12217,12218,12418,12417,-1,12218,12219,12419,12418,-1,12219,12220,12420,12419,-1,12220,12221,12421,12420,-1,12221,12222,12422,12421,-1,12222,12223,12423,12422,-1,12223,12224,12424,12423,-1,12224,12225,12425,12424,-1,12225,12226,12426,12425,-1,12226,12227,12427,12426,-1,12227,12228,12428,12427,-1,12228,12229,12429,12428,-1,12229,12230,12430,12429,-1,12230,12231,12431,12430,-1,12231,12232,12432,12431,-1,12232,12233,12433,12432,-1,12233,12234,12434,12433,-1,12234,12235,12435,12434,-1,12235,12236,12436,12435,-1,12236,12237,12437,12436,-1,12237,12238,12438,12437,-1,12238,12239,12439,12438,-1,12239,12240,12440,12439,-1,12240,12241,12441,12440,-1,12241,12242,12442,12441,-1,12242,12243,12443,12442,-1,12243,12244,12444,12443,-1,12244,12245,12445,12444,-1,12245,12246,12446,12445,-1,12246,12247,12447,12446,-1,12247,12248,12448,12447,-1,12248,12249,12449,12448,-1,12249,12250,12450,12449,-1,12250,12251,12451,12450,-1,12251,12252,12452,12451,-1,12252,12253,12453,12452,-1,12253,12254,12454,12453,-1,12254,12255,12455,12454,-1,12255,12256,12456,12455,-1,12256,12257,12457,12456,-1,12257,12258,12458,12457,-1,12258,12259,12459,12458,-1,12259,12260,12460,12459,-1,12260,12261,12461,12460,-1,12261,12262,12462,12461,-1,12262,12263,12463,12462,-1,12263,12264,12464,12463,-1,12264,12265,12465,12464,-1,12265,12266,12466,12465,-1,12266,12267,12467,12466,-1,12267,12268,12468,12467,-1,12268,12269,12469,12468,-1,12269,12270,12470,12469,-1,12270,12271,12471,12470,-1,12271,12272,12472,12471,-1,12272,12273,12473,12472,-1,12273,12274,12474,12473,-1,12274,12275,12475,12474,-1,12275,12276,12476,12475,-1,12276,12277,12477,12476,-1,12277,12278,12478,12477,-1,12278,12279,12479,12478,-1,12279,12280,12480,12479,-1,12280,12281,12481,12480,-1,12281,12282,12482,12481,-1,12282,12283,12483,12482,-1,12283,12284,12484,12483,-1,12284,12285,12485,12484,-1,12285,12286,12486,12485,-1,12286,12287,12487,12486,-1,12287,12288,12488,12487,-1,12288,12289,12489,12488,-1,12289,12290,12490,12489,-1,12290,12291,12491,12490,-1,12291,12292,12492,12491,-1,12292,12293,12493,12492,-1,12293,12294,12494,12493,-1,12294,12295,12495,12494,-1,12295,12296,12496,12495,-1,12296,12297,12497,12496,-1,12297,12298,12498,12497,-1,12298,12299,12499,12498,-1,12299,12300,12500,12499,-1,12300,12301,12501,12500,-1,12301,12302,12502,12501,-1,12302,12303,12503,12502,-1,12303,12304,12504,12503,-1,12304,12305,12505,12504,-1,12305,12306,12506,12505,-1,12306,12307,12507,12506,-1,12307,12308,12508,12507,-1,12308,12309,12509,12508,-1,12309,12310,12510,12509,-1,12310,12311,12511,12510,-1,12311,12312,12512,12511,-1,12312,12313,12513,12512,-1,12313,12314,12514,12513,-1,12314,12315,12515,12514,-1,12315,12316,12516,12515,-1,12316,12317,12517,12516,-1,12317,12318,12518,12517,-1,12318,12319,12519,12518,-1,12319,12320,12520,12519,-1,12320,12321,12521,12520,-1,12321,12322,12522,12521,-1,12322,12323,12523,12522,-1,12323,12324,12524,12523,-1,12324,12325,12525,12524,-1,12325,12326,12526,12525,-1,12326,12327,12527,12526,-1,12327,12328,12528,12527,-1,12328,12329,12529,12528,-1,12329,12330,12530,12529,-1,12330,12331,12531,12530,-1,12331,12332,12532,12531,-1,12332,12333,12533,12532,-1,12333,12334,12534,12533,-1,12334,12335,12535,12534,-1,12335,12336,12536,12535,-1,12336,12337,12537,12536,-1,12337,12338,12538,12537,-1,12338,12339,12539,12538,-1,12339,12340,12540,12539,-1,12340,12341,12541,12540,-1,12341,12342,12542,12541,-1,12342,12343,12543,12542,-1,12343,12344,12544,12543,-1,12344,12345,12545,12544,-1,12345,12346,12546,12545,-1,12346,12347,12547,12546,-1,12347,12348,12548,12547,-1,12348,12349,12549,12548,-1,12349,12350,12550,12549,-1,12350,12351,12551,12550,-1,12351,12352,12552,12551,-1,12352,12353,12553,12552,-1,12353,12354,12554,12553,-1,12354,12355,12555,12554,-1,12355,12356,12556,12555,-1,12356,12357,12557,12556,-1,12357,12358,12558,12557,-1,12358,12359,12559,12558,-1,12359,12360,12560,12559,-1,12360,12361,12561,12560,-1,12361,12362,12562,12561,-1,12362,12363,12563,12562,-1,12363,12364,12564,12563,-1,12364,12365,12565,12564,-1,12365,12366,12566,12565,-1,12366,12367,12567,12566,-1,12367,12368,12568,12567,-1,12368,12369,12569,12568,-1,12369,12370,12570,12569,-1,12370,12371,12571,12570,-1,12371,12372,12572,12571,-1,12372,12373,12573,12572,-1,12373,12374,12574,12573,-1,12374,12375,12575,12574,-1,12375,12376,12576,12575,-1,12376,12377,12577,12576,-1,12377,12378,12578,12577,-1,12378,12379,12579,12578,-1,12379,12380,12580,12579,-1,12380,12381,12581,12580,-1,12381,12382,12582,12581,-1,12382,12383,12583,12582,-1,12383,12384,12584,12583,-1,12384,12385,12585,12584,-1,12385,12386,12586,12585,-1,12386,12387,12587,12586,-1,12387,12388,12588,12587,-1,12388,12389,12589,12588,-1,12389,12390,12590,12589,-1,12390,12391,12591,12590,-1,12391,12392,12592,12591,-1,12392,12393,12593,12592,-1,12393,12394,12594,12593,-1,12394,12395,12595,12594,-1,12395,12396,12596,12595,-1,12396,12397,12597,12596,-1,12397,12398,12598,12597,-1,12398,12399,12599,12598,-1,12400,12401,12601,12600,-1,12401,12402,12602,12601,-1,12402,12403,12603,12602,-1,12403,12404,12604,12603,-1,12404,12405,12605,12604,-1,12405,12406,12606,12605,-1,12406,12407,12607,12606,-1,12407,12408,12608,12607,-1,12408,12409,12609,12608,-1,12409,12410,12610,12609,-1,12410,12411,12611,12610,-1,12411,12412,12612,12611,-1,12412,12413,12613,12612,-1,12413,12414,12614,12613,-1,12414,12415,12615,12614,-1,12415,12416,12616,12615,-1,12416,12417,12617,12616,-1,12417,12418,12618,12617,-1,12418,12419,12619,12618,-1,12419,12420,12620,12619,-1,12420,12421,12621,12620,-1,12421,12422,12622,12621,-1,12422,12423,12623,12622,-1,12423,12424,12624,12623,-1,12424,12425,12625,12624,-1,12425,12426,12626,12625,-1,12426,12427,12627,12626,-1,12427,12428,12628,12627,-1,12428,12429,12629,12628,-1,12429,12430,12630,12629,-1,12430,12431,12631,12630,-1,12431,12432,12632,12631,-1,12432,12433,12633,12632,-1,12433,12434,12634,12633,-1,12434,12435,12635,12634,-1,12435,12436,12636,12635,-1,12436,12437,12637,12636,-1,12437,12438,12638,12637,-1,12438,12439,12639,12638,-1,12439,12440,12640,12639,-1,12440,12441,12641,12640,-1,12441,12442,12642,12641,-1,12442,12443,12643,12642,-1,12443,12444,12644,12643,-1,12444,12445,12645,12644,-1,12445,12446,12646,12645,-1,12446,12447,12647,12646,-1,12447,12448,12648,12647,-1,12448,12449,12649,12648,-1,12449,12450,12650,12649,-1,12450,12451,12651,12650,-1,12451,12452,12652,12651,-1,12452,12453,12653,12652,-1,12453,12454,12654,12653,-1,12454,12455,12655,12654,-1,12455,12456,12656,12655,-1,12456,12457,12657,12656,-1,12457,12458,12658,12657,-1,12458,12459,12659,12658,-1,12459,12460,12660,12659,-1,12460,12461,12661,12660,-1,12461,12462,12662,12661,-1,12462,12463,12663,12662,-1,12463,12464,12664,12663,-1,12464,12465,12665,12664,-1,12465,12466,12666,12665,-1,12466,12467,12667,12666,-1,12467,12468,12668,12667,-1,12468,12469,12669,12668,-1,12469,12470,12670,12669,-1,12470,12471,12671,12670,-1,12471,12472,12672,12671,-1,12472,12473,12673,12672,-1,12473,12474,12674,12673,-1,12474,12475,12675,12674,-1,12475,12476,12676,12675,-1,12476,12477,12677,12676,-1,12477,12478,12678,12677,-1,12478,12479,12679,12678,-1,12479,12480,12680,12679,-1,12480,12481,12681,12680,-1,12481,12482,12682,12681,-1,12482,12483,12683,12682,-1,12483,12484,12684,12683,-1,12484,12485,12685,12684,-1,12485,12486,12686,12685,-1,12486,12487,12687,12686,-1,12487,12488,12688,12687,-1,12488,12489,12689,12688,-1,12489,12490,12690,12689,-1,12490,12491,12691,12690,-1,12491,12492,12692,12691,-1,12492,12493,12693,12692,-1,12493,12494,12694,12693,-1,12494,12495,12695,12694,-1,12495,12496,12696,12695,-1,12496,12497,12697,12696,-1,12497,12498,12698,12697,-1,12498,12499,12699,12698,-1,12499,12500,12700,12699,-1,12500,12501,12701,12700,-1,12501,12502,12702,12701,-1,12502,12503,12703,12702,-1,12503,12504,12704,12703,-1,12504,12505,12705,12704,-1,12505,12506,12706,12705,-1,12506,12507,12707,12706,-1,12507,12508,12708,12707,-1,12508,12509,12709,12708,-1,12509,12510,12710,12709,-1,12510,12511,12711,12710,-1,12511,12512,12712,12711,-1,12512,12513,12713,12712,-1,12513,12514,12714,12713,-1,12514,12515,12715,12714,-1,12515,12516,12716,12715,-1,12516,12517,12717,12716,-1,12517,12518,12718,12717,-1,12518,12519,12719,12718,-1,12519,12520,12720,12719,-1,12520,12521,12721,12720,-1,12521,12522,12722,12721,-1,12522,12523,12723,12722,-1,12523,12524,12724,12723,-1,12524,12525,12725,12724,-1,12525,12526,12726,12725,-1,12526,12527,12727,12726,-1,12527,12528,12728,12727,-1,12528,12529,12729,12728,-1,12529,12530,12730,12729,-1,12530,12531,12731,12730,-1,12531,12532,12732,12731,-1,12532,12533,12733,12732,-1,12533,12534,12734,12733,-1,12534,12535,12735,12734,-1,12535,12536,12736,12735,-1,12536,12537,12737,12736,-1,12537,12538,12738,12737,-1,12538,12539,12739,12738,-1,12539,12540,12740,12739,-1,12540,12541,12741,12740,-1,12541,12542,12742,12741,-1,12542,12543,12743,12742,-1,12543,12544,12744,12743,-1,12544,12545,12745,12744,-1,12545,12546,12746,12745,-1,12546,12547,12747,12746,-1,12547,12548,12748,12747,-1,12548,12549,12749,12748,-1,12549,12550,12750,12749,-1,12550,12551,12751,12750,-1,12551,12552,12752,12751,-1,12552,12553,12753,12752,-1,12553,12554,12754,12753,-1,12554,12555,12755,12754,-1,12555,12556,12756,12755,-1,12556,12557,12757,12756,-1,12557,12558,12758,12757,-1,12558,12559,12759,12758,-1,12559,12560,12760,12759,-1,12560,12561,12761,12760,-1,12561,12562,12762,12761,-1,12562,12563,12763,12762,-1,12563,12564,12764,12763,-1,12564,12565,12765,12764,-1,12565,12566,12766,12765,-1,12566,12567,12767,12766,-1,12567,12568,12768,12767,-1,12568,12569,12769,12768,-1,12569,12570,12770,12769,-1,12570,12571,12771,12770,-1,12571,12572,12772,12771,-1,12572,12573,12773,12772,-1,12573,12574,12774,12773,-1,12574,12575,12775,12774,-1,12575,12576,12776,12775,-1,12576,12577,12777,12776,-1,12577,12578,12778,12777,-1,12578,12579,12779,12778,-1,12579,12580,12780,12779,-1,12580,12581,12781,12780,-1,12581,12582,12782,12781,-1,12582,12583,12783,12782,-1,12583,12584,12784,12783,-1,12584,12585,12785,12784,-1,12585,12586,12786,12785,-1,12586,12587,12787,12786,-1,12587,12588,12788,12787,-1,12588,12589,12789,12788,-1,12589,12590,12790,12789,-1,12590,12591,12791,12790,-1,12591,12592,12792,12791,-1,12592,12593,12793,12792,-1,12593,12594,12794,12793,-1,12594,12595,12795,12794,-1,12595,12596,12796,12795,-1,12596,12597,12797,12796,-1,12597,12598,12798,12797,-1,12598,12599,12799,12798,-1,12600,12601,12801,12800,-1,12601,12602,12802,12801,-1,12602,12603,12803,12802,-1,12603,12604,12804,12803,-1,12604,12605,12805,12804,-1,12605,12606,12806,12805,-1,12606,12607,12807,12806,-1,12607,12608,12808,12807,-1,12608,12609,12809,12808,-1,12609,12610,12810,12809,-1,12610,12611,12811,12810,-1,12611,12612,12812,12811,-1,12612,12613,12813,12812,-1,12613,12614,12814,12813,-1,12614,12615,12815,12814,-1,12615,12616,12816,12815,-1,12616,12617,12817,12816,-1,12617,12618,12818,12817,-1,12618,12619,12819,12818,-1,12619,12620,12820,12819,-1,12620,12621,12821,12820,-1,12621,12622,12822,12821,-1,12622,12623,12823,12822,-1,12623,12624,12824,12823,-1,12624,12625,12825,12824,-1,12625,12626,12826,12825,-1,12626,12627,12827,12826,-1,12627,12628,12828,12827,-1,12628,12629,12829,12828,-1,12629,12630,12830,12829,-1,12630,12631,12831,12830,-1,12631,12632,12832,12831,-1,12632,12633,12833,12832,-1,12633,12634,12834,12833,-1,12634,12635,12835,12834,-1,12635,12636,12836,12835,-1,12636,12637,12837,12836,-1,12637,12638,12838,12837,-1,12638,12639,12839,12838,-1,12639,12640,12840,12839,-1,12640,12641,12841,12840,-1,12641,12642,12842,12841,-1,12642,12643,12843,12842,-1,12643,12644,12844,12843,-1,12644,12645,12845,12844,-1,12645,12646,12846,12845,-1,12646,12647,12847,12846,-1,12647,12648,12848,12847,-1,12648,12649,12849,12848,-1,12649,12650,12850,12849,-1,12650,12651,12851,12850,-1,12651,12652,12852,12851,-1,12652,12653,12853,12852,-1,12653,12654,12854,12853,-1,12654,12655,12855,12854,-1,12655,12656,12856,12855,-1,12656,12657,12857,12856,-1,12657,12658,12858,12857,-1,12658,12659,12859,12858,-1,12659,12660,12860,12859,-1,12660,12661,12861,12860,-1,12661,12662,12862,12861,-1,12662,12663,12863,12862,-1,12663,12664,12864,12863,-1,12664,12665,12865,12864,-1,12665,12666,12866,12865,-1,12666,12667,12867,12866,-1,12667,12668,12868,12867,-1,12668,12669,12869,12868,-1,12669,12670,12870,12869,-1,12670,12671,12871,12870,-1,12671,12672,12872,12871,-1,12672,12673,12873,12872,-1,12673,12674,12874,12873,-1,12674,12675,12875,12874,-1,12675,12676,12876,12875,-1,12676,12677,12877,12876,-1,12677,12678,12878,12877,-1,12678,12679,12879,12878,-1,12679,12680,12880,12879,-1,12680,12681,12881,12880,-1,12681,12682,12882,12881,-1,12682,12683,12883,12882,-1,12683,12684,12884,12883,-1,12684,12685,12885,12884,-1,12685,12686,12886,12885,-1,12686,12687,12887,12886,-1,12687,12688,12888,12887,-1,12688,12689,12889,12888,-1,12689,12690,12890,12889,-1,12690,12691,12891,12890,-1,12691,12692,12892,12891,-1,12692,12693,12893,12892,-1,12693,12694,12894,12893,-1,12694,12695,12895,12894,-1,12695,12696,12896,12895,-1,12696,12697,12897,12896,-1,12697,12698,12898,12897,-1,12698,12699,12899,12898,-1,12699,12700,12900,12899,-1,12700,12701,12901,12900,-1,12701,12702,12902,12901,-1,12702,12703,12903,12902,-1,12703,12704,12904,12903,-1,12704,12705,12905,12904,-1,12705,12706,12906,12905,-1,12706,12707,12907,12906,-1,12707,12708,12908,12907,-1,12708,12709,12909,12908,-1,12709,12710,12910,12909,-1,12710,12711,12911,12910,-1,12711,12712,12912,12911,-1,12712,12713,12913,12912,-1,12713,12714,12914,12913,-1,12714,12715,12915,12914,-1,12715,12716,12916,12915,-1,12716,12717,12917,12916,-1,12717,12718,12918,12917,-1,12718,12719,12919,12918,-1,12719,12720,12920,12919,-1,12720,12721,12921,12920,-1,12721,12722,12922,12921,-1,12722,12723,12923,12922,-1,12723,12724,12924,12923,-1,12724,12725,12925,12924,-1,12725,12726,12926,12925,-1,12726,12727,12927,12926,-1,12727,12728,12928,12927,-1,12728,12729,12929,12928,-1,12729,12730,12930,12929,-1,12730,12731,12931,12930,-1,12731,12732,12932,12931,-1,12732,12733,12933,12932,-1,12733,12734,12934,12933,-1,12734,12735,12935,12934,-1,12735,12736,12936,12935,-1,12736,12737,12937,12936,-1,12737,12738,12938,12937,-1,12738,12739,12939,12938,-1,12739,12740,12940,12939,-1,12740,12741,12941,12940,-1,12741,12742,12942,12941,-1,12742,12743,12943,12942,-1,12743,12744,12944,12943,-1,12744,12745,12945,12944,-1,12745,12746,12946,12945,-1,12746,12747,12947,12946,-1,12747,12748,12948,12947,-1,12748,12749,12949,12948,-1,12749,12750,12950,12949,-1,12750,12751,12951,12950,-1,12751,12752,12952,12951,-1,12752,12753,12953,12952,-1,12753,12754,12954,12953,-1,12754,12755,12955,12954,-1,12755,12756,12956,12955,-1,12756,12757,12957,12956,-1,12757,12758,12958,12957,-1,12758,12759,12959,12958,-1,12759,12760,12960,12959,-1,12760,12761,12961,12960,-1,12761,12762,12962,12961,-1,12762,12763,12963,12962,-1,12763,12764,12964,12963,-1,12764,12765,12965,12964,-1,12765,12766,12966,12965,-1,12766,12767,12967,12966,-1,12767,12768,12968,12967,-1,12768,12769,12969,12968,-1,12769,12770,12970,12969,-1,12770,12771,12971,12970,-1,12771,12772,12972,12971,-1,12772,12773,12973,12972,-1,12773,12774,12974,12973,-1,12774,12775,12975,12974,-1,12775,12776,12976,12975,-1,12776,12777,12977,12976,-1,12777,12778,12978,12977,-1,12778,12779,12979,12978,-1,12779,12780,12980,12979,-1,12780,12781,12981,12980,-1,12781,12782,12982,12981,-1,12782,12783,12983,12982,-1,12783,12784,12984,12983,-1,12784,12785,12985,12984,-1,12785,12786,12986,12985,-1,12786,12787,12987,12986,-1,12787,12788,12988,12987,-1,12788,12789,12989,12988,-1,12789,12790,12990,12989,-1,12790,12791,12991,12990,-1,12791,12792,12992,12991,-1,12792,12793,12993,12992,-1,12793,12794,12994,12993,-1,12794,12795,12995,12994,-1,12795,12796,12996,12995,-1,12796,12797,12997,12996,-1,12797,12798,12998,12997,-1,12798,12799,12999,12998,-1,12800,12801,13001,13,-1,12801,12802,13002,13001,-1,12802,12803,13003,13002,-1,12803,12804,13004,13003,-1,12804,12805,13005,13004,-1,12805,12806,13006,13005,-1,12806,12807,13007,13006,-1,12807,12808,13008,13007,-1,12808,12809,13009,13008,-1,12809,12810,13010,13009,-1,12810,12811,13011,13010,-1,12811,12812,13012,13011,-1,12812,12813,13013,13012,-1,12813,12814,13014,13013,-1,12814,12815,13015,13014,-1,12815,12816,13016,13015,-1,12816,12817,13017,13016,-1,12817,12818,13018,13017,-1,12818,12819,13019,13018,-1,12819,12820,13020,13019,-1,12820,12821,13021,13020,-1,12821,12822,13022,13021,-1,12822,12823,13023,13022,-1,12823,12824,13024,13023,-1,12824,12825,13025,13024,-1,12825,12826,13026,13025,-1,12826,12827,13027,13026,-1,12827,12828,13028,13027,-1,12828,12829,13029,13028,-1,12829,12830,13030,13029,-1,12830,12831,13031,13030,-1,12831,12832,13032,13031,-1,12832,12833,13033,13032,-1,12833,12834,13034,13033,-1,12834,12835,13035,13034,-1,12835,12836,13036,13035,-1,12836,12837,13037,13036,-1,12837,12838,13038,13037,-1,12838,12839,13039,13038,-1,12839,12840,13040,13039,-1,12840,12841,13041,13040,-1,12841,12842,13042,13041,-1,12842,12843,13043,13042,-1,12843,12844,13044,13043,-1,12844,12845,13045,13044,-1,12845,12846,13046,13045,-1,12846,12847,13047,13046,-1,12847,12848,13048,13047,-1,12848,12849,13049,13048,-1,12849,12850,13050,13049,-1,12850,12851,13051,13050,-1,12851,12852,13052,13051,-1,12852,12853,13053,13052,-1,12853,12854,13054,13053,-1,12854,12855,13055,13054,-1,12855,12856,13056,13055,-1,12856,12857,13057,13056,-1,12857,12858,13058,13057,-1,12858,12859,13059,13058,-1,12859,12860,13060,13059,-1,12860,12861,13061,13060,-1,12861,12862,13062,13061,-1,12862,12863,13063,13062,-1,12863,12864,13064,13063,-1,12864,12865,13065,13064,-1,12865,12866,13066,13065,-1,12866,12867,13067,13066,-1,12867,12868,13068,13067,-1,12868,12869,13069,13068,-1,12869,12870,13070,13069,-1,12870,12871,13071,13070,-1,12871,12872,13072,13071,-1,12872,12873,13073,13072,-1,12873,12874,13074,13073,-1,12874,12875,13075,13074,-1,12875,12876,13076,13075,-1,12876,12877,13077,13076,-1,12877,12878,13078,13077,-1,12878,12879,13079,13078,-1,12879,12880,13080,13079,-1,12880,12881,13081,13080,-1,12881,12882,13082,13081,-1,12882,12883,13083,13082,-1,12883,12884,13084,13083,-1,12884,12885,13085,13084,-1,12885,12886,13086,13085,-1,12886,12887,13087,13086,-1,12887,12888,13088,13087,-1,12888,12889,13089,13088,-1,12889,12890,13090,13089,-1,12890,12891,13091,13090,-1,12891,12892,13092,13091,-1,12892,12893,13093,13092,-1,12893,12894,13094,13093,-1,12894,12895,13095,13094,-1,12895,12896,13096,13095,-1,12896,12897,13097,13096,-1,12897,12898,13098,13097,-1,12898,12899,13099,13098,-1,12899,12900,13100,13099,-1,12900,12901,13101,13100,-1,12901,12902,13102,13101,-1,12902,12903,13103,13102,-1,12903,12904,13104,13103,-1,12904,12905,13105,13104,-1,12905,12906,13106,13105,-1,12906,12907,13107,13106,-1,12907,12908,13108,13107,-1,12908,12909,13109,13108,-1,12909,12910,13110,13109,-1,12910,12911,13111,13110,-1,12911,12912,13112,13111,-1,12912,12913,13113,13112,-1,12913,12914,13114,13113,-1,12914,12915,13115,13114,-1,12915,12916,13116,13115,-1,12916,12917,13117,13116,-1,12917,12918,13118,13117,-1,12918,12919,13119,13118,-1,12919,12920,13120,13119,-1,12920,12921,13121,13120,-1,12921,12922,13122,13121,-1,12922,12923,13123,13122,-1,12923,12924,13124,13123,-1,12924,12925,13125,13124,-1,12925,12926,13126,13125,-1,12926,12927,13127,13126,-1,12927,12928,13128,13127,-1,12928,12929,13129,13128,-1,12929,12930,13130,13129,-1,12930,12931,13131,13130,-1,12931,12932,13132,13131,-1,12932,12933,13133,13132,-1,12933,12934,13134,13133,-1,12934,12935,13135,13134,-1,12935,12936,13136,13135,-1,12936,12937,13137,13136,-1,12937,12938,13138,13137,-1,12938,12939,13139,13138,-1,12939,12940,13140,13139,-1,12940,12941,13141,13140,-1,12941,12942,13142,13141,-1,12942,12943,13143,13142,-1,12943,12944,13144,13143,-1,12944,12945,13145,13144,-1,12945,12946,13146,13145,-1,12946,12947,13147,13146,-1,12947,12948,13148,13147,-1,12948,12949,13149,13148,-1,12949,12950,13150,13149,-1,12950,12951,13151,13150,-1,12951,12952,13152,13151,-1,12952,12953,13153,13152,-1,12953,12954,13154,13153,-1,12954,12955,13155,13154,-1,12955,12956,13156,13155,-1,12956,12957,13157,13156,-1,12957,12958,13158,13157,-1,12958,12959,13159,13158,-1,12959,12960,13160,13159,-1,12960,12961,13161,13160,-1,12961,12962,13162,13161,-1,12962,12963,13163,13162,-1,12963,12964,13164,13163,-1,12964,12965,13165,13164,-1,12965,12966,13166,13165,-1,12966,12967,13167,13166,-1,12967,12968,13168,13167,-1,12968,12969,13169,13168,-1,12969,12970,13170,13169,-1,12970,12971,13171,13170,-1,12971,12972,13172,13171,-1,12972,12973,13173,13172,-1,12973,12974,13174,13173,-1,12974,12975,13175,13174,-1,12975,12976,13176,13175,-1,12976,12977,13177,13176,-1,12977,12978,13178,13177,-1,12978,12979,13179,13178,-1,12979,12980,13180,13179,-1,12980,12981,13181,13180,-1,12981,12982,13182,13181,-1,12982,12983,13183,13182,-1,12983,12984,13184,13183,-1,12984,12985,13185,13184,-1,12985,12986,13186,13185,-1,12986,12987,13187,13186,-1,12987,12988,13188,13187,-1,12988,12989,13189,13188,-1,12989,12990,13190,13189,-1,12990,12991,13191,13190,-1,12991,12992,13192,13191,-1,12992,12993,13193,13192,-1,12993,12994,13194,13193,-1,12994,12995,13195,13194,-1,12995,12996,13196,13195,-1,12996,12997,13197,13196,-1,12997,12998,13198,13197,-1,12998,12999,13199,13198,-1,13,13001,13201,13200,-1,13001,13002,13202,13201,-1,13002,13003,13203,13202,-1,13003,13004,13204,13203,-1,13004,13005,13205,13204,-1,13005,13006,13206,13205,-1,13006,13007,13207,13206,-1,13007,13008,13208,13207,-1,13008,13009,13209,13208,-1,13009,13010,13210,13209,-1,13010,13011,13211,13210,-1,13011,13012,13212,13211,-1,13012,13013,13213,13212,-1,13013,13014,13214,13213,-1,13014,13015,13215,13214,-1,13015,13016,13216,13215,-1,13016,13017,13217,13216,-1,13017,13018,13218,13217,-1,13018,13019,13219,13218,-1,13019,13020,13220,13219,-1,13020,13021,13221,13220,-1,13021,13022,13222,13221,-1,13022,13023,13223,13222,-1,13023,13024,13224,13223,-1,13024,13025,13225,13224,-1,13025,13026,13226,13225,-1,13026,13027,13227,13226,-1,13027,13028,13228,13227,-1,13028,13029,13229,13228,-1,13029,13030,13230,13229,-1,13030,13031,13231,13230,-1,13031,13032,13232,13231,-1,13032,13033,13233,13232,-1,13033,13034,13234,13233,-1,13034,13035,13235,13234,-1,13035,13036,13236,13235,-1,13036,13037,13237,13236,-1,13037,13038,13238,13237,-1,13038,13039,13239,13238,-1,13039,13040,13240,13239,-1,13040,13041,13241,13240,-1,13041,13042,13242,13241,-1,13042,13043,13243,13242,-1,13043,13044,13244,13243,-1,13044,13045,13245,13244,-1,13045,13046,13246,13245,-1,13046,13047,13247,13246,-1,13047,13048,13248,13247,-1,13048,13049,13249,13248,-1,13049,13050,13250,13249,-1,13050,13051,13251,13250,-1,13051,13052,13252,13251,-1,13052,13053,13253,13252,-1,13053,13054,13254,13253,-1,13054,13055,13255,13254,-1,13055,13056,13256,13255,-1,13056,13057,13257,13256,-1,13057,13058,13258,13257,-1,13058,13059,13259,13258,-1,13059,13060,13260,13259,-1,13060,13061,13261,13260,-1,13061,13062,13262,13261,-1,13062,13063,13263,13262,-1,13063,13064,13264,13263,-1,13064,13065,13265,13264,-1,13065,13066,13266,13265,-1,13066,13067,13267,13266,-1,13067,13068,13268,13267,-1,13068,13069,13269,13268,-1,13069,13070,13270,13269,-1,13070,13071,13271,13270,-1,13071,13072,13272,13271,-1,13072,13073,13273,13272,-1,13073,13074,13274,13273,-1,13074,13075,13275,13274,-1,13075,13076,13276,13275,-1,13076,13077,13277,13276,-1,13077,13078,13278,13277,-1,13078,13079,13279,13278,-1,13079,13080,13280,13279,-1,13080,13081,13281,13280,-1,13081,13082,13282,13281,-1,13082,13083,13283,13282,-1,13083,13084,13284,13283,-1,13084,13085,13285,13284,-1,13085,13086,13286,13285,-1,13086,13087,13287,13286,-1,13087,13088,13288,13287,-1,13088,13089,13289,13288,-1,13089,13090,13290,13289,-1,13090,13091,13291,13290,-1,13091,13092,13292,13291,-1,13092,13093,13293,13292,-1,13093,13094,13294,13293,-1,13094,13095,13295,13294,-1,13095,13096,13296,13295,-1,13096,13097,13297,13296,-1,13097,13098,13298,13297,-1,13098,13099,13299,13298,-1,13099,13100,13300,13299,-1,13100,13101,13301,13300,-1,13101,13102,13302,13301,-1,13102,13103,13303,13302,-1,13103,13104,13304,13303,-1,13104,13105,13305,13304,-1,13105,13106,13306,13305,-1,13106,13107,13307,13306,-1,13107,13108,13308,13307,-1,13108,13109,13309,13308,-1,13109,13110,13310,13309,-1,13110,13111,13311,13310,-1,13111,13112,13312,13311,-1,13112,13113,13313,13312,-1,13113,13114,13314,13313,-1,13114,13115,13315,13314,-1,13115,13116,13316,13315,-1,13116,13117,13317,13316,-1,13117,13118,13318,13317,-1,13118,13119,13319,13318,-1,13119,13120,13320,13319,-1,13120,13121,13321,13320,-1,13121,13122,13322,13321,-1,13122,13123,13323,13322,-1,13123,13124,13324,13323,-1,13124,13125,13325,13324,-1,13125,13126,13326,13325,-1,13126,13127,13327,13326,-1,13127,13128,13328,13327,-1,13128,13129,13329,13328,-1,13129,13130,13330,13329,-1,13130,13131,13331,13330,-1,13131,13132,13332,13331,-1,13132,13133,13333,13332,-1,13133,13134,13334,13333,-1,13134,13135,13335,13334,-1,13135,13136,13336,13335,-1,13136,13137,13337,13336,-1,13137,13138,13338,13337,-1,13138,13139,13339,13338,-1,13139,13140,13340,13339,-1,13140,13141,13341,13340,-1,13141,13142,13342,13341,-1,13142,13143,13343,13342,-1,13143,13144,13344,13343,-1,13144,13145,13345,13344,-1,13145,13146,13346,13345,-1,13146,13147,13347,13346,-1,13147,13148,13348,13347,-1,13148,13149,13349,13348,-1,13149,13150,13350,13349,-1,13150,13151,13351,13350,-1,13151,13152,13352,13351,-1,13152,13153,13353,13352,-1,13153,13154,13354,13353,-1,13154,13155,13355,13354,-1,13155,13156,13356,13355,-1,13156,13157,13357,13356,-1,13157,13158,13358,13357,-1,13158,13159,13359,13358,-1,13159,13160,13360,13359,-1,13160,13161,13361,13360,-1,13161,13162,13362,13361,-1,13162,13163,13363,13362,-1,13163,13164,13364,13363,-1,13164,13165,13365,13364,-1,13165,13166,13366,13365,-1,13166,13167,13367,13366,-1,13167,13168,13368,13367,-1,13168,13169,13369,13368,-1,13169,13170,13370,13369,-1,13170,13171,13371,13370,-1,13171,13172,13372,13371,-1,13172,13173,13373,13372,-1,13173,13174,13374,13373,-1,13174,13175,13375,13374,-1,13175,13176,13376,13375,-1,13176,13177,13377,13376,-1,13177,13178,13378,13377,-1,13178,13179,13379,13378,-1,13179,13180,13380,13379,-1,13180,13181,13381,13380,-1,13181,13182,13382,13381,-1,13182,13183,13383,13382,-1,13183,13184,13384,13383,-1,13184,13185,13385,13384,-1,13185,13186,13386,13385,-1,13186,13187,13387,13386,-1,13187,13188,13388,13387,-1,13188,13189,13389,13388,-1,13189,13190,13390,13389,-1,13190,13191,13391,13390,-1,13191,13192,13392,13391,-1,13192,13193,13393,13392,-1,13193,13194,13394,13393,-1,13194,13195,13395,13394,-1,13195,13196,13396,13395,-1,13196,13197,13397,13396,-1,13197,13198,13398,13397,-1,13198,13199,13399,13398,-1,13200,13201,13401,13400,-1,13201,13202,13402,13401,-1,13202,13203,13403,13402,-1,13203,13204,13404,13403,-1,13204,13205,13405,13404,-1,13205,13206,13406,13405,-1,13206,13207,13407,13406,-1,13207,13208,13408,13407,-1,13208,13209,13409,13408,-1,13209,13210,13410,13409,-1,13210,13211,13411,13410,-1,13211,13212,13412,13411,-1,13212,13213,13413,13412,-1,13213,13214,13414,13413,-1,13214,13215,13415,13414,-1,13215,13216,13416,13415,-1,13216,13217,13417,13416,-1,13217,13218,13418,13417,-1,13218,13219,13419,13418,-1,13219,13220,13420,13419,-1,13220,13221,13421,13420,-1,13221,13222,13422,13421,-1,13222,13223,13423,13422,-1,13223,13224,13424,13423,-1,13224,13225,13425,13424,-1,13225,13226,13426,13425,-1,13226,13227,13427,13426,-1,13227,13228,13428,13427,-1,13228,13229,13429,13428,-1,13229,13230,13430,13429,-1,13230,13231,13431,13430,-1,13231,13232,13432,13431,-1,13232,13233,13433,13432,-1,13233,13234,13434,13433,-1,13234,13235,13435,13434,-1,13235,13236,13436,13435,-1,13236,13237,13437,13436,-1,13237,13238,13438,13437,-1,13238,13239,13439,13438,-1,13239,13240,13440,13439,-1,13240,13241,13441,13440,-1,13241,13242,13442,13441,-1,13242,13243,13443,13442,-1,13243,13244,13444,13443,-1,13244,13245,13445,13444,-1,13245,13246,13446,13445,-1,13246,13247,13447,13446,-1,13247,13248,13448,13447,-1,13248,13249,13449,13448,-1,13249,13250,13450,13449,-1,13250,13251,13451,13450,-1,13251,13252,13452,13451,-1,13252,13253,13453,13452,-1,13253,13254,13454,13453,-1,13254,13255,13455,13454,-1,13255,13256,13456,13455,-1,13256,13257,13457,13456,-1,13257,13258,13458,13457,-1,13258,13259,13459,13458,-1,13259,13260,13460,13459,-1,13260,13261,13461,13460,-1,13261,13262,13462,13461,-1,13262,13263,13463,13462,-1,13263,13264,13464,13463,-1,13264,13265,13465,13464,-1,13265,13266,13466,13465,-1,13266,13267,13467,13466,-1,13267,13268,13468,13467,-1,13268,13269,13469,13468,-1,13269,13270,13470,13469,-1,13270,13271,13471,13470,-1,13271,13272,13472,13471,-1,13272,13273,13473,13472,-1,13273,13274,13474,13473,-1,13274,13275,13475,13474,-1,13275,13276,13476,13475,-1,13276,13277,13477,13476,-1,13277,13278,13478,13477,-1,13278,13279,13479,13478,-1,13279,13280,13480,13479,-1,13280,13281,13481,13480,-1,13281,13282,13482,13481,-1,13282,13283,13483,13482,-1,13283,13284,13484,13483,-1,13284,13285,13485,13484,-1,13285,13286,13486,13485,-1,13286,13287,13487,13486,-1,13287,13288,13488,13487,-1,13288,13289,13489,13488,-1,13289,13290,13490,13489,-1,13290,13291,13491,13490,-1,13291,13292,13492,13491,-1,13292,13293,13493,13492,-1,13293,13294,13494,13493,-1,13294,13295,13495,13494,-1,13295,13296,13496,13495,-1,13296,13297,13497,13496,-1,13297,13298,13498,13497,-1,13298,13299,13499,13498,-1,13299,13300,13500,13499,-1,13300,13301,13501,13500,-1,13301,13302,13502,13501,-1,13302,13303,13503,13502,-1,13303,13304,13504,13503,-1,13304,13305,13505,13504,-1,13305,13306,13506,13505,-1,13306,13307,13507,13506,-1,13307,13308,13508,13507,-1,13308,13309,13509,13508,-1,13309,13310,13510,13509,-1,13310,13311,13511,13510,-1,13311,13312,13512,13511,-1,13312,13313,13513,13512,-1,13313,13314,13514,13513,-1,13314,13315,13515,13514,-1,13315,13316,13516,13515,-1,13316,13317,13517,13516,-1,13317,13318,13518,13517,-1,13318,13319,13519,13518,-1,13319,13320,13520,13519,-1,13320,13321,13521,13520,-1,13321,13322,13522,13521,-1,13322,13323,13523,13522,-1,13323,13324,13524,13523,-1,13324,13325,13525,13524,-1,13325,13326,13526,13525,-1,13326,13327,13527,13526,-1,13327,13328,13528,13527,-1,13328,13329,13529,13528,-1,13329,13330,13530,13529,-1,13330,13331,13531,13530,-1,13331,13332,13532,13531,-1,13332,13333,13533,13532,-1,13333,13334,13534,13533,-1,13334,13335,13535,13534,-1,13335,13336,13536,13535,-1,13336,13337,13537,13536,-1,13337,13338,13538,13537,-1,13338,13339,13539,13538,-1,13339,13340,13540,13539,-1,13340,13341,13541,13540,-1,13341,13342,13542,13541,-1,13342,13343,13543,13542,-1,13343,13344,13544,13543,-1,13344,13345,13545,13544,-1,13345,13346,13546,13545,-1,13346,13347,13547,13546,-1,13347,13348,13548,13547,-1,13348,13349,13549,13548,-1,13349,13350,13550,13549,-1,13350,13351,13551,13550,-1,13351,13352,13552,13551,-1,13352,13353,13553,13552,-1,13353,13354,13554,13553,-1,13354,13355,13555,13554,-1,13355,13356,13556,13555,-1,13356,13357,13557,13556,-1,13357,13358,13558,13557,-1,13358,13359,13559,13558,-1,13359,13360,13560,13559,-1,13360,13361,13561,13560,-1,13361,13362,13562,13561,-1,13362,13363,13563,13562,-1,13363,13364,13564,13563,-1,13364,13365,13565,13564,-1,13365,13366,13566,13565,-1,13366,13367,13567,13566,-1,13367,13368,13568,13567,-1,13368,13369,13569,13568,-1,13369,13370,13570,13569,-1,13370,13371,13571,13570,-1,13371,13372,13572,13571,-1,13372,13373,13573,13572,-1,13373,13374,13574,13573,-1,13374,13375,13575,13574,-1,13375,13376,13576,13575,-1,13376,13377,13577,13576,-1,13377,13378,13578,13577,-1,13378,13379,13579,13578,-1,13379,13380,13580,13579,-1,13380,13381,13581,13580,-1,13381,13382,13582,13581,-1,13382,13383,13583,13582,-1,13383,13384,13584,13583,-1,13384,13385,13585,13584,-1,13385,13386,13586,13585,-1,13386,13387,13587,13586,-1,13387,13388,13588,13587,-1,13388,13389,13589,13588,-1,13389,13390,13590,13589,-1,13390,13391,13591,13590,-1,13391,13392,13592,13591,-1,13392,13393,13593,13592,-1,13393,13394,13594,13593,-1,13394,13395,13595,13594,-1,13395,13396,13596,13595,-1,13396,13397,13597,13596,-1,13397,13398,13598,13597,-1,13398,13399,13599,13598,-1,13400,13401,13601,13600,-1,13401,13402,13602,13601,-1,13402,13403,13603,13602,-1,13403,13404,13604,13603,-1,13404,13405,13605,13604,-1,13405,13406,13606,13605,-1,13406,13407,13607,13606,-1,13407,13408,13608,13607,-1,13408,13409,13609,13608,-1,13409,13410,13610,13609,-1,13410,13411,13611,13610,-1,13411,13412,13612,13611,-1,13412,13413,13613,13612,-1,13413,13414,13614,13613,-1,13414,13415,13615,13614,-1,13415,13416,13616,13615,-1,13416,13417,13617,13616,-1,13417,13418,13618,13617,-1,13418,13419,13619,13618,-1,13419,13420,13620,13619,-1,13420,13421,13621,13620,-1,13421,13422,13622,13621,-1,13422,13423,13623,13622,-1,13423,13424,13624,13623,-1,13424,13425,13625,13624,-1,13425,13426,13626,13625,-1,13426,13427,13627,13626,-1,13427,13428,13628,13627,-1,13428,13429,13629,13628,-1,13429,13430,13630,13629,-1,13430,13431,13631,13630,-1,13431,13432,13632,13631,-1,13432,13433,13633,13632,-1,13433,13434,13634,13633,-1,13434,13435,13635,13634,-1,13435,13436,13636,13635,-1,13436,13437,13637,13636,-1,13437,13438,13638,13637,-1,13438,13439,13639,13638,-1,13439,13440,13640,13639,-1,13440,13441,13641,13640,-1,13441,13442,13642,13641,-1,13442,13443,13643,13642,-1,13443,13444,13644,13643,-1,13444,13445,13645,13644,-1,13445,13446,13646,13645,-1,13446,13447,13647,13646,-1,13447,13448,13648,13647,-1,13448,13449,13649,13648,-1,13449,13450,13650,13649,-1,13450,13451,13651,13650,-1,13451,13452,13652,13651,-1,13452,13453,13653,13652,-1,13453,13454,13654,13653,-1,13454,13455,13655,13654,-1,13455,13456,13656,13655,-1,13456,13457,13657,13656,-1,13457,13458,13658,13657,-1,13458,13459,13659,13658,-1,13459,13460,13660,13659,-1,13460,13461,13661,13660,-1,13461,13462,13662,13661,-1,13462,13463,13663,13662,-1,13463,13464,13664,13663,-1,13464,13465,13665,13664,-1,13465,13466,13666,13665,-1,13466,13467,13667,13666,-1,13467,13468,13668,13667,-1,13468,13469,13669,13668,-1,13469,13470,13670,13669,-1,13470,13471,13671,13670,-1,13471,13472,13672,13671,-1,13472,13473,13673,13672,-1,13473,13474,13674,13673,-1,13474,13475,13675,13674,-1,13475,13476,13676,13675,-1,13476,13477,13677,13676,-1,13477,13478,13678,13677,-1,13478,13479,13679,13678,-1,13479,13480,13680,13679,-1,13480,13481,13681,13680,-1,13481,13482,13682,13681,-1,13482,13483,13683,13682,-1,13483,13484,13684,13683,-1,13484,13485,13685,13684,-1,13485,13486,13686,13685,-1,13486,13487,13687,13686,-1,13487,13488,13688,13687,-1,13488,13489,13689,13688,-1,13489,13490,13690,13689,-1,13490,13491,13691,13690,-1,13491,13492,13692,13691,-1,13492,13493,13693,13692,-1,13493,13494,13694,13693,-1,13494,13495,13695,13694,-1,13495,13496,13696,13695,-1,13496,13497,13697,13696,-1,13497,13498,13698,13697,-1,13498,13499,13699,13698,-1,13499,13500,13700,13699,-1,13500,13501,13701,13700,-1,13501,13502,13702,13701,-1,13502,13503,13703,13702,-1,13503,13504,13704,13703,-1,13504,13505,13705,13704,-1,13505,13506,13706,13705,-1,13506,13507,13707,13706,-1,13507,13508,13708,13707,-1,13508,13509,13709,13708,-1,13509,13510,13710,13709,-1,13510,13511,13711,13710,-1,13511,13512,13712,13711,-1,13512,13513,13713,13712,-1,13513,13514,13714,13713,-1,13514,13515,13715,13714,-1,13515,13516,13716,13715,-1,13516,13517,13717,13716,-1,13517,13518,13718,13717,-1,13518,13519,13719,13718,-1,13519,13520,13720,13719,-1,13520,13521,13721,13720,-1,13521,13522,13722,13721,-1,13522,13523,13723,13722,-1,13523,13524,13724,13723,-1,13524,13525,13725,13724,-1,13525,13526,13726,13725,-1,13526,13527,13727,13726,-1,13527,13528,13728,13727,-1,13528,13529,13729,13728,-1,13529,13530,13730,13729,-1,13530,13531,13731,13730,-1,13531,13532,13732,13731,-1,13532,13533,13733,13732,-1,13533,13534,13734,13733,-1,13534,13535,13735,13734,-1,13535,13536,13736,13735,-1,13536,13537,13737,13736,-1,13537,13538,13738,13737,-1,13538,13539,13739,13738,-1,13539,13540,13740,13739,-1,13540,13541,13741,13740,-1,13541,13542,13742,13741,-1,13542,13543,13743,13742,-1,13543,13544,13744,13743,-1,13544,13545,13745,13744,-1,13545,13546,13746,13745,-1,13546,13547,13747,13746,-1,13547,13548,13748,13747,-1,13548,13549,13749,13748,-1,13549,13550,13750,13749,-1,13550,13551,13751,13750,-1,13551,13552,13752,13751,-1,13552,13553,13753,13752,-1,13553,13554,13754,13753,-1,13554,13555,13755,13754,-1,13555,13556,13756,13755,-1,13556,13557,13757,13756,-1,13557,13558,13758,13757,-1,13558,13559,13759,13758,-1,13559,13560,13760,13759,-1,13560,13561,13761,13760,-1,13561,13562,13762,13761,-1,13562,13563,13763,13762,-1,13563,13564,13764,13763,-1,13564,13565,13765,13764,-1,13565,13566,13766,13765,-1,13566,13567,13767,13766,-1,13567,13568,13768,13767,-1,13568,13569,13769,13768,-1,13569,13570,13770,13769,-1,13570,13571,13771,13770,-1,13571,13572,13772,13771,-1,13572,13573,13773,13772,-1,13573,13574,13774,13773,-1,13574,13575,13775,13774,-1,13575,13576,13776,13775,-1,13576,13577,13777,13776,-1,13577,13578,13778,13777,-1,13578,13579,13779,13778,-1,13579,13580,13780,13779,-1,13580,13581,13781,13780,-1,13581,13582,13782,13781,-1,13582,13583,13783,13782,-1,13583,13584,13784,13783,-1,13584,13585,13785,13784,-1,13585,13586,13786,13785,-1,13586,13587,13787,13786,-1,13587,13588,13788,13787,-1,13588,13589,13789,13788,-1,13589,13590,13790,13789,-1,13590,13591,13791,13790,-1,13591,13592,13792,13791,-1,13592,13593,13793,13792,-1,13593,13594,13794,13793,-1,13594,13595,13795,13794,-1,13595,13596,13796,13795,-1,13596,13597,13797,13796,-1,13597,13598,13798,13797,-1,13598,13599,13799,13798,-1,13600,13601,13801,13800,-1,13601,13602,13802,13801,-1,13602,13603,13803,13802,-1,13603,13604,13804,13803,-1,13604,13605,13805,13804,-1,13605,13606,13806,13805,-1,13606,13607,13807,13806,-1,13607,13608,13808,13807,-1,13608,13609,13809,13808,-1,13609,13610,13810,13809,-1,13610,13611,13811,13810,-1,13611,13612,13812,13811,-1,13612,13613,13813,13812,-1,13613,13614,13814,13813,-1,13614,13615,13815,13814,-1,13615,13616,13816,13815,-1,13616,13617,13817,13816,-1,13617,13618,13818,13817,-1,13618,13619,13819,13818,-1,13619,13620,13820,13819,-1,13620,13621,13821,13820,-1,13621,13622,13822,13821,-1,13622,13623,13823,13822,-1,13623,13624,13824,13823,-1,13624,13625,13825,13824,-1,13625,13626,13826,13825,-1,13626,13627,13827,13826,-1,13627,13628,13828,13827,-1,13628,13629,13829,13828,-1,13629,13630,13830,13829,-1,13630,13631,13831,13830,-1,13631,13632,13832,13831,-1,13632,13633,13833,13832,-1,13633,13634,13834,13833,-1,13634,13635,13835,13834,-1,13635,13636,13836,13835,-1,13636,13637,13837,13836,-1,13637,13638,13838,13837,-1,13638,13639,13839,13838,-1,13639,13640,13840,13839,-1,13640,13641,13841,13840,-1,13641,13642,13842,13841,-1,13642,13643,13843,13842,-1,13643,13644,13844,13843,-1,13644,13645,13845,13844,-1,13645,13646,13846,13845,-1,13646,13647,13847,13846,-1,13647,13648,13848,13847,-1,13648,13649,13849,13848,-1,13649,13650,13850,13849,-1,13650,13651,13851,13850,-1,13651,13652,13852,13851,-1,13652,13653,13853,13852,-1,13653,13654,13854,13853,-1,13654,13655,13855,13854,-1,13655,13656,13856,13855,-1,13656,13657,13857,13856,-1,13657,13658,13858,13857,-1,13658,13659,13859,13858,-1,13659,13660,13860,13859,-1,13660,13661,13861,13860,-1,13661,13662,13862,13861,-1,13662,13663,13863,13862,-1,13663,13664,13864,13863,-1,13664,13665,13865,13864,-1,13665,13666,13866,13865,-1,13666,13667,13867,13866,-1,13667,13668,13868,13867,-1,13668,13669,13869,13868,-1,13669,13670,13870,13869,-1,13670,13671,13871,13870,-1,13671,13672,13872,13871,-1,13672,13673,13873,13872,-1,13673,13674,13874,13873,-1,13674,13675,13875,13874,-1,13675,13676,13876,13875,-1,13676,13677,13877,13876,-1,13677,13678,13878,13877,-1,13678,13679,13879,13878,-1,13679,13680,13880,13879,-1,13680,13681,13881,13880,-1,13681,13682,13882,13881,-1,13682,13683,13883,13882,-1,13683,13684,13884,13883,-1,13684,13685,13885,13884,-1,13685,13686,13886,13885,-1,13686,13687,13887,13886,-1,13687,13688,13888,13887,-1,13688,13689,13889,13888,-1,13689,13690,13890,13889,-1,13690,13691,13891,13890,-1,13691,13692,13892,13891,-1,13692,13693,13893,13892,-1,13693,13694,13894,13893,-1,13694,13695,13895,13894,-1,13695,13696,13896,13895,-1,13696,13697,13897,13896,-1,13697,13698,13898,13897,-1,13698,13699,13899,13898,-1,13699,13700,13900,13899,-1,13700,13701,13901,13900,-1,13701,13702,13902,13901,-1,13702,13703,13903,13902,-1,13703,13704,13904,13903,-1,13704,13705,13905,13904,-1,13705,13706,13906,13905,-1,13706,13707,13907,13906,-1,13707,13708,13908,13907,-1,13708,13709,13909,13908,-1,13709,13710,13910,13909,-1,13710,13711,13911,13910,-1,13711,13712,13912,13911,-1,13712,13713,13913,13912,-1,13713,13714,13914,13913,-1,13714,13715,13915,13914,-1,13715,13716,13916,13915,-1,13716,13717,13917,13916,-1,13717,13718,13918,13917,-1,13718,13719,13919,13918,-1,13719,13720,13920,13919,-1,13720,13721,13921,13920,-1,13721,13722,13922,13921,-1,13722,13723,13923,13922,-1,13723,13724,13924,13923,-1,13724,13725,13925,13924,-1,13725,13726,13926,13925,-1,13726,13727,13927,13926,-1,13727,13728,13928,13927,-1,13728,13729,13929,13928,-1,13729,13730,13930,13929,-1,13730,13731,13931,13930,-1,13731,13732,13932,13931,-1,13732,13733,13933,13932,-1,13733,13734,13934,13933,-1,13734,13735,13935,13934,-1,13735,13736,13936,13935,-1,13736,13737,13937,13936,-1,13737,13738,13938,13937,-1,13738,13739,13939,13938,-1,13739,13740,13940,13939,-1,13740,13741,13941,13940,-1,13741,13742,13942,13941,-1,13742,13743,13943,13942,-1,13743,13744,13944,13943,-1,13744,13745,13945,13944,-1,13745,13746,13946,13945,-1,13746,13747,13947,13946,-1,13747,13748,13948,13947,-1,13748,13749,13949,13948,-1,13749,13750,13950,13949,-1,13750,13751,13951,13950,-1,13751,13752,13952,13951,-1,13752,13753,13953,13952,-1,13753,13754,13954,13953,-1,13754,13755,13955,13954,-1,13755,13756,13956,13955,-1,13756,13757,13957,13956,-1,13757,13758,13958,13957,-1,13758,13759,13959,13958,-1,13759,13760,13960,13959,-1,13760,13761,13961,13960,-1,13761,13762,13962,13961,-1,13762,13763,13963,13962,-1,13763,13764,13964,13963,-1,13764,13765,13965,13964,-1,13765,13766,13966,13965,-1,13766,13767,13967,13966,-1,13767,13768,13968,13967,-1,13768,13769,13969,13968,-1,13769,13770,13970,13969,-1,13770,13771,13971,13970,-1,13771,13772,13972,13971,-1,13772,13773,13973,13972,-1,13773,13774,13974,13973,-1,13774,13775,13975,13974,-1,13775,13776,13976,13975,-1,13776,13777,13977,13976,-1,13777,13778,13978,13977,-1,13778,13779,13979,13978,-1,13779,13780,13980,13979,-1,13780,13781,13981,13980,-1,13781,13782,13982,13981,-1,13782,13783,13983,13982,-1,13783,13784,13984,13983,-1,13784,13785,13985,13984,-1,13785,13786,13986,13985,-1,13786,13787,13987,13986,-1,13787,13788,13988,13987,-1,13788,13789,13989,13988,-1,13789,13790,13990,13989,-1,13790,13791,13991,13990,-1,13791,13792,13992,13991,-1,13792,13793,13993,13992,-1,13793,13794,13994,13993,-1,13794,13795,13995,13994,-1,13795,13796,13996,13995,-1,13796,13797,13997,13996,-1,13797,13798,13998,13997,-1,13798,13799,13999,13998,-1,13800,13801,14001,14,-1,13801,13802,14002,14001,-1,13802,13803,14003,14002,-1,13803,13804,14004,14003,-1,13804,13805,14005,14004,-1,13805,13806,14006,14005,-1,13806,13807,14007,14006,-1,13807,13808,14008,14007,-1,13808,13809,14009,14008,-1,13809,13810,14010,14009,-1,13810,13811,14011,14010,-1,13811,13812,14012,14011,-1,13812,13813,14013,14012,-1,13813,13814,14014,14013,-1,13814,13815,14015,14014,-1,13815,13816,14016,14015,-1,13816,13817,14017,14016,-1,13817,13818,14018,14017,-1,13818,13819,14019,14018,-1,13819,13820,14020,14019,-1,13820,13821,14021,14020,-1,13821,13822,14022,14021,-1,13822,13823,14023,14022,-1,13823,13824,14024,14023,-1,13824,13825,14025,14024,-1,13825,13826,14026,14025,-1,13826,13827,14027,14026,-1,13827,13828,14028,14027,-1,13828,13829,14029,14028,-1,13829,13830,14030,14029,-1,13830,13831,14031,14030,-1,13831,13832,14032,14031,-1,13832,13833,14033,14032,-1,13833,13834,14034,14033,-1,13834,13835,14035,14034,-1,13835,13836,14036,14035,-1,13836,13837,14037,14036,-1,13837,13838,14038,14037,-1,13838,13839,14039,14038,-1,13839,13840,14040,14039,-1,13840,13841,14041,14040,-1,13841,13842,14042,14041,-1,13842,13843,14043,14042,-1,13843,13844,14044,14043,-1,13844,13845,14045,14044,-1,13845,13846,14046,14045,-1,13846,13847,14047,14046,-1,13847,13848,14048,14047,-1,13848,13849,14049,14048,-1,13849,13850,14050,14049,-1,13850,13851,14051,14050,-1,13851,13852,14052,14051,-1,13852,13853,14053,14052,-1,13853,13854,14054,14053,-1,13854,13855,14055,14054,-1,13855,13856,14056,14055,-1,13856,13857,14057,14056,-1,13857,13858,14058,14057,-1,13858,13859,14059,14058,-1,13859,13860,14060,14059,-1,13860,13861,14061,14060,-1,13861,13862,14062,14061,-1,13862,13863,14063,14062,-1,13863,13864,14064,14063,-1,13864,13865,14065,14064,-1,13865,13866,14066,14065,-1,13866,13867,14067,14066,-1,13867,13868,14068,14067,-1,13868,13869,14069,14068,-1,13869,13870,14070,14069,-1,13870,13871,14071,14070,-1,13871,13872,14072,14071,-1,13872,13873,14073,14072,-1,13873,13874,14074,14073,-1,13874,13875,14075,14074,-1,13875,13876,14076,14075,-1,13876,13877,14077,14076,-1,13877,13878,14078,14077,-1,13878,13879,14079,14078,-1,13879,13880,14080,14079,-1,13880,13881,14081,14080,-1,13881,13882,14082,14081,-1,13882,13883,14083,14082,-1,13883,13884,14084,14083,-1,13884,13885,14085,14084,-1,13885,13886,14086,14085,-1,13886,13887,14087,14086,-1,13887,13888,14088,14087,-1,13888,13889,14089,14088,-1,13889,13890,14090,14089,-1,13890,13891,14091,14090,-1,13891,13892,14092,14091,-1,13892,13893,14093,14092,-1,13893,13894,14094,14093,-1,13894,13895,14095,14094,-1,13895,13896,14096,14095,-1,13896,13897,14097,14096,-1,13897,13898,14098,14097,-1,13898,13899,14099,14098,-1,13899,13900,14100,14099,-1,13900,13901,14101,14100,-1,13901,13902,14102,14101,-1,13902,13903,14103,14102,-1,13903,13904,14104,14103,-1,13904,13905,14105,14104,-1,13905,13906,14106,14105,-1,13906,13907,14107,14106,-1,13907,13908,14108,14107,-1,13908,13909,14109,14108,-1,13909,13910,14110,14109,-1,13910,13911,14111,14110,-1,13911,13912,14112,14111,-1,13912,13913,14113,14112,-1,13913,13914,14114,14113,-1,13914,13915,14115,14114,-1,13915,13916,14116,14115,-1,13916,13917,14117,14116,-1,13917,13918,14118,14117,-1,13918,13919,14119,14118,-1,13919,13920,14120,14119,-1,13920,13921,14121,14120,-1,13921,13922,14122,14121,-1,13922,13923,14123,14122,-1,13923,13924,14124,14123,-1,13924,13925,14125,14124,-1,13925,13926,14126,14125,-1,13926,13927,14127,14126,-1,13927,13928,14128,14127,-1,13928,13929,14129,14128,-1,13929,13930,14130,14129,-1,13930,13931,14131,14130,-1,13931,13932,14132,14131,-1,13932,13933,14133,14132,-1,13933,13934,14134,14133,-1,13934,13935,14135,14134,-1,13935,13936,14136,14135,-1,13936,13937,14137,14136,-1,13937,13938,14138,14137,-1,13938,13939,14139,14138,-1,13939,13940,14140,14139,-1,13940,13941,14141,14140,-1,13941,13942,14142,14141,-1,13942,13943,14143,14142,-1,13943,13944,14144,14143,-1,13944,13945,14145,14144,-1,13945,13946,14146,14145,-1,13946,13947,14147,14146,-1,13947,13948,14148,14147,-1,13948,13949,14149,14148,-1,13949,13950,14150,14149,-1,13950,13951,14151,14150,-1,13951,13952,14152,14151,-1,13952,13953,14153,14152,-1,13953,13954,14154,14153,-1,13954,13955,14155,14154,-1,13955,13956,14156,14155,-1,13956,13957,14157,14156,-1,13957,13958,14158,14157,-1,13958,13959,14159,14158,-1,13959,13960,14160,14159,-1,13960,13961,14161,14160,-1,13961,13962,14162,14161,-1,13962,13963,14163,14162,-1,13963,13964,14164,14163,-1,13964,13965,14165,14164,-1,13965,13966,14166,14165,-1,13966,13967,14167,14166,-1,13967,13968,14168,14167,-1,13968,13969,14169,14168,-1,13969,13970,14170,14169,-1,13970,13971,14171,14170,-1,13971,13972,14172,14171,-1,13972,13973,14173,14172,-1,13973,13974,14174,14173,-1,13974,13975,14175,14174,-1,13975,13976,14176,14175,-1,13976,13977,14177,14176,-1,13977,13978,14178,14177,-1,13978,13979,14179,14178,-1,13979,13980,14180,14179,-1,13980,13981,14181,14180,-1,13981,13982,14182,14181,-1,13982,13983,14183,14182,-1,13983,13984,14184,14183,-1,13984,13985,14185,14184,-1,13985,13986,14186,14185,-1,13986,13987,14187,14186,-1,13987,13988,14188,14187,-1,13988,13989,14189,14188,-1,13989,13990,14190,14189,-1,13990,13991,14191,14190,-1,13991,13992,14192,14191,-1,13992,13993,14193,14192,-1,13993,13994,14194,14193,-1,13994,13995,14195,14194,-1,13995,13996,14196,14195,-1,13996,13997,14197,14196,-1,13997,13998,14198,14197,-1,13998,13999,14199,14198,-1,14,14001,14201,14200,-1,14001,14002,14202,14201,-1,14002,14003,14203,14202,-1,14003,14004,14204,14203,-1,14004,14005,14205,14204,-1,14005,14006,14206,14205,-1,14006,14007,14207,14206,-1,14007,14008,14208,14207,-1,14008,14009,14209,14208,-1,14009,14010,14210,14209,-1,14010,14011,14211,14210,-1,14011,14012,14212,14211,-1,14012,14013,14213,14212,-1,14013,14014,14214,14213,-1,14014,14015,14215,14214,-1,14015,14016,14216,14215,-1,14016,14017,14217,14216,-1,14017,14018,14218,14217,-1,14018,14019,14219,14218,-1,14019,14020,14220,14219,-1,14020,14021,14221,14220,-1,14021,14022,14222,14221,-1,14022,14023,14223,14222,-1,14023,14024,14224,14223,-1,14024,14025,14225,14224,-1,14025,14026,14226,14225,-1,14026,14027,14227,14226,-1,14027,14028,14228,14227,-1,14028,14029,14229,14228,-1,14029,14030,14230,14229,-1,14030,14031,14231,14230,-1,14031,14032,14232,14231,-1,14032,14033,14233,14232,-1,14033,14034,14234,14233,-1,14034,14035,14235,14234,-1,14035,14036,14236,14235,-1,14036,14037,14237,14236,-1,14037,14038,14238,14237,-1,14038,14039,14239,14238,-1,14039,14040,14240,14239,-1,14040,14041,14241,14240,-1,14041,14042,14242,14241,-1,14042,14043,14243,14242,-1,14043,14044,14244,14243,-1,14044,14045,14245,14244,-1,14045,14046,14246,14245,-1,14046,14047,14247,14246,-1,14047,14048,14248,14247,-1,14048,14049,14249,14248,-1,14049,14050,14250,14249,-1,14050,14051,14251,14250,-1,14051,14052,14252,14251,-1,14052,14053,14253,14252,-1,14053,14054,14254,14253,-1,14054,14055,14255,14254,-1,14055,14056,14256,14255,-1,14056,14057,14257,14256,-1,14057,14058,14258,14257,-1,14058,14059,14259,14258,-1,14059,14060,14260,14259,-1,14060,14061,14261,14260,-1,14061,14062,14262,14261,-1,14062,14063,14263,14262,-1,14063,14064,14264,14263,-1,14064,14065,14265,14264,-1,14065,14066,14266,14265,-1,14066,14067,14267,14266,-1,14067,14068,14268,14267,-1,14068,14069,14269,14268,-1,14069,14070,14270,14269,-1,14070,14071,14271,14270,-1,14071,14072,14272,14271,-1,14072,14073,14273,14272,-1,14073,14074,14274,14273,-1,14074,14075,14275,14274,-1,14075,14076,14276,14275,-1,14076,14077,14277,14276,-1,14077,14078,14278,14277,-1,14078,14079,14279,14278,-1,14079,14080,14280,14279,-1,14080,14081,14281,14280,-1,14081,14082,14282,14281,-1,14082,14083,14283,14282,-1,14083,14084,14284,14283,-1,14084,14085,14285,14284,-1,14085,14086,14286,14285,-1,14086,14087,14287,14286,-1,14087,14088,14288,14287,-1,14088,14089,14289,14288,-1,14089,14090,14290,14289,-1,14090,14091,14291,14290,-1,14091,14092,14292,14291,-1,14092,14093,14293,14292,-1,14093,14094,14294,14293,-1,14094,14095,14295,14294,-1,14095,14096,14296,14295,-1,14096,14097,14297,14296,-1,14097,14098,14298,14297,-1,14098,14099,14299,14298,-1,14099,14100,14300,14299,-1,14100,14101,14301,14300,-1,14101,14102,14302,14301,-1,14102,14103,14303,14302,-1,14103,14104,14304,14303,-1,14104,14105,14305,14304,-1,14105,14106,14306,14305,-1,14106,14107,14307,14306,-1,14107,14108,14308,14307,-1,14108,14109,14309,14308,-1,14109,14110,14310,14309,-1,14110,14111,14311,14310,-1,14111,14112,14312,14311,-1,14112,14113,14313,14312,-1,14113,14114,14314,14313,-1,14114,14115,14315,14314,-1,14115,14116,14316,14315,-1,14116,14117,14317,14316,-1,14117,14118,14318,14317,-1,14118,14119,14319,14318,-1,14119,14120,14320,14319,-1,14120,14121,14321,14320,-1,14121,14122,14322,14321,-1,14122,14123,14323,14322,-1,14123,14124,14324,14323,-1,14124,14125,14325,14324,-1,14125,14126,14326,14325,-1,14126,14127,14327,14326,-1,14127,14128,14328,14327,-1,14128,14129,14329,14328,-1,14129,14130,14330,14329,-1,14130,14131,14331,14330,-1,14131,14132,14332,14331,-1,14132,14133,14333,14332,-1,14133,14134,14334,14333,-1,14134,14135,14335,14334,-1,14135,14136,14336,14335,-1,14136,14137,14337,14336,-1,14137,14138,14338,14337,-1,14138,14139,14339,14338,-1,14139,14140,14340,14339,-1,14140,14141,14341,14340,-1,14141,14142,14342,14341,-1,14142,14143,14343,14342,-1,14143,14144,14344,14343,-1,14144,14145,14345,14344,-1,14145,14146,14346,14345,-1,14146,14147,14347,14346,-1,14147,14148,14348,14347,-1,14148,14149,14349,14348,-1,14149,14150,14350,14349,-1,14150,14151,14351,14350,-1,14151,14152,14352,14351,-1,14152,14153,14353,14352,-1,14153,14154,14354,14353,-1,14154,14155,14355,14354,-1,14155,14156,14356,14355,-1,14156,14157,14357,14356,-1,14157,14158,14358,14357,-1,14158,14159,14359,14358,-1,14159,14160,14360,14359,-1,14160,14161,14361,14360,-1,14161,14162,14362,14361,-1,14162,14163,14363,14362,-1,14163,14164,14364,14363,-1,14164,14165,14365,14364,-1,14165,14166,14366,14365,-1,14166,14167,14367,14366,-1,14167,14168,14368,14367,-1,14168,14169,14369,14368,-1,14169,14170,14370,14369,-1,14170,14171,14371,14370,-1,14171,14172,14372,14371,-1,14172,14173,14373,14372,-1,14173,14174,14374,14373,-1,14174,14175,14375,14374,-1,14175,14176,14376,14375,-1,14176,14177,14377,14376,-1,14177,14178,14378,14377,-1,14178,14179,14379,14378,-1,14179,14180,14380,14379,-1,14180,14181,14381,14380,-1,14181,14182,14382,14381,-1,14182,14183,14383,14382,-1,14183,14184,14384,14383,-1,14184,14185,14385,14384,-1,14185,14186,14386,14385,-1,14186,14187,14387,14386,-1,14187,14188,14388,14387,-1,14188,14189,14389,14388,-1,14189,14190,14390,14389,-1,14190,14191,14391,14390,-1,14191,14192,14392,14391,-1,14192,14193,14393,14392,-1,14193,14194,14394,14393,-1,14194,14195,14395,14394,-1,14195,14196,14396,14395,-1,14196,14197,14397,14396,-1,14197,14198,14398,14397,-1,14198,14199,14399,14398,-1,14200,14201,14401,14400,-1,14201,14202,14402,14401,-1,14202,14203,14403,14402,-1,14203,14204,14404,14403,-1,14204,14205,14405,14404,-1,14205,14206,14406,14405,-1,14206,14207,14407,14406,-1,14207,14208,14408,14407,-1,14208,14209,14409,14408,-1,14209,14210,14410,14409,-1,14210,14211,14411,14410,-1,14211,14212,14412,14411,-1,14212,14213,14413,14412,-1,14213,14214,14414,14413,-1,14214,14215,14415,14414,-1,14215,14216,14416,14415,-1,14216,14217,14417,14416,-1,14217,14218,14418,14417,-1,14218,14219,14419,14418,-1,14219,14220,14420,14419,-1,14220,14221,14421,14420,-1,14221,14222,14422,14421,-1,14222,14223,14423,14422,-1,14223,14224,14424,14423,-1,14224,14225,14425,14424,-1,14225,14226,14426,14425,-1,14226,14227,14427,14426,-1,14227,14228,14428,14427,-1,14228,14229,14429,14428,-1,14229,14230,14430,14429,-1,14230,14231,14431,14430,-1,14231,14232,14432,14431,-1,14232,14233,14433,14432,-1,14233,14234,14434,14433,-1,14234,14235,14435,14434,-1,14235,14236,14436,14435,-1,14236,14237,14437,14436,-1,14237,14238,14438,14437,-1,14238,14239,14439,14438,-1,14239,14240,14440,14439,-1,14240,14241,14441,14440,-1,14241,14242,14442,14441,-1,14242,14243,14443,14442,-1,14243,14244,14444,14443,-1,14244,14245,14445,14444,-1,14245,14246,14446,14445,-1,14246,14247,14447,14446,-1,14247,14248,14448,14447,-1,14248,14249,14449,14448,-1,14249,14250,14450,14449,-1,14250,14251,14451,14450,-1,14251,14252,14452,14451,-1,14252,14253,14453,14452,-1,14253,14254,14454,14453,-1,14254,14255,14455,14454,-1,14255,14256,14456,14455,-1,14256,14257,14457,14456,-1,14257,14258,14458,14457,-1,14258,14259,14459,14458,-1,14259,14260,14460,14459,-1,14260,14261,14461,14460,-1,14261,14262,14462,14461,-1,14262,14263,14463,14462,-1,14263,14264,14464,14463,-1,14264,14265,14465,14464,-1,14265,14266,14466,14465,-1,14266,14267,14467,14466,-1,14267,14268,14468,14467,-1,14268,14269,14469,14468,-1,14269,14270,14470,14469,-1,14270,14271,14471,14470,-1,14271,14272,14472,14471,-1,14272,14273,14473,14472,-1,14273,14274,14474,14473,-1,14274,14275,14475,14474,-1,14275,14276,14476,14475,-1,14276,14277,14477,14476,-1,14277,14278,14478,14477,-1,14278,14279,14479,14478,-1,14279,14280,14480,14479,-1,14280,14281,14481,14480,-1,14281,14282,14482,14481,-1,14282,14283,14483,14482,-1,14283,14284,14484,14483,-1,14284,14285,14485,14484,-1,14285,14286,14486,14485,-1,14286,14287,14487,14486,-1,14287,14288,14488,14487,-1,14288,14289,14489,14488,-1,14289,14290,14490,14489,-1,14290,14291,14491,14490,-1,14291,14292,14492,14491,-1,14292,14293,14493,14492,-1,14293,14294,14494,14493,-1,14294,14295,14495,14494,-1,14295,14296,14496,14495,-1,14296,14297,14497,14496,-1,14297,14298,14498,14497,-1,14298,14299,14499,14498,-1,14299,14300,14500,14499,-1,14300,14301,14501,14500,-1,14301,14302,14502,14501,-1,14302,14303,14503,14502,-1,14303,14304,14504,14503,-1,14304,14305,14505,14504,-1,14305,14306,14506,14505,-1,14306,14307,14507,14506,-1,14307,14308,14508,14507,-1,14308,14309,14509,14508,-1,14309,14310,14510,14509,-1,14310,14311,14511,14510,-1,14311,14312,14512,14511,-1,14312,14313,14513,14512,-1,14313,14314,14514,14513,-1,14314,14315,14515,14514,-1,14315,14316,14516,14515,-1,14316,14317,14517,14516,-1,14317,14318,14518,14517,-1,14318,14319,14519,14518,-1,14319,14320,14520,14519,-1,14320,14321,14521,14520,-1,14321,14322,14522,14521,-1,14322,14323,14523,14522,-1,14323,14324,14524,14523,-1,14324,14325,14525,14524,-1,14325,14326,14526,14525,-1,14326,14327,14527,14526,-1,14327,14328,14528,14527,-1,14328,14329,14529,14528,-1,14329,14330,14530,14529,-1,14330,14331,14531,14530,-1,14331,14332,14532,14531,-1,14332,14333,14533,14532,-1,14333,14334,14534,14533,-1,14334,14335,14535,14534,-1,14335,14336,14536,14535,-1,14336,14337,14537,14536,-1,14337,14338,14538,14537,-1,14338,14339,14539,14538,-1,14339,14340,14540,14539,-1,14340,14341,14541,14540,-1,14341,14342,14542,14541,-1,14342,14343,14543,14542,-1,14343,14344,14544,14543,-1,14344,14345,14545,14544,-1,14345,14346,14546,14545,-1,14346,14347,14547,14546,-1,14347,14348,14548,14547,-1,14348,14349,14549,14548,-1,14349,14350,14550,14549,-1,14350,14351,14551,14550,-1,14351,14352,14552,14551,-1,14352,14353,14553,14552,-1,14353,14354,14554,14553,-1,14354,14355,14555,14554,-1,14355,14356,14556,14555,-1,14356,14357,14557,14556,-1,14357,14358,14558,14557,-1,14358,14359,14559,14558,-1,14359,14360,14560,14559,-1,14360,14361,14561,14560,-1,14361,14362,14562,14561,-1,14362,14363,14563,14562,-1,14363,14364,14564,14563,-1,14364,14365,14565,14564,-1,14365,14366,14566,14565,-1,14366,14367,14567,14566,-1,14367,14368,14568,14567,-1,14368,14369,14569,14568,-1,14369,14370,14570,14569,-1,14370,14371,14571,14570,-1,14371,14372,14572,14571,-1,14372,14373,14573,14572,-1,14373,14374,14574,14573,-1,14374,14375,14575,14574,-1,14375,14376,14576,14575,-1,14376,14377,14577,14576,-1,14377,14378,14578,14577,-1,14378,14379,14579,14578,-1,14379,14380,14580,14579,-1,14380,14381,14581,14580,-1,14381,14382,14582,14581,-1,14382,14383,14583,14582,-1,14383,14384,14584,14583,-1,14384,14385,14585,14584,-1,14385,14386,14586,14585,-1,14386,14387,14587,14586,-1,14387,14388,14588,14587,-1,14388,14389,14589,14588,-1,14389,14390,14590,14589,-1,14390,14391,14591,14590,-1,14391,14392,14592,14591,-1,14392,14393,14593,14592,-1,14393,14394,14594,14593,-1,14394,14395,14595,14594,-1,14395,14396,14596,14595,-1,14396,14397,14597,14596,-1,14397,14398,14598,14597,-1,14398,14399,14599,14598,-1,14400,14401,14601,14600,-1,14401,14402,14602,14601,-1,14402,14403,14603,14602,-1,14403,14404,14604,14603,-1,14404,14405,14605,14604,-1,14405,14406,14606,14605,-1,14406,14407,14607,14606,-1,14407,14408,14608,14607,-1,14408,14409,14609,14608,-1,14409,14410,14610,14609,-1,14410,14411,14611,14610,-1,14411,14412,14612,14611,-1,14412,14413,14613,14612,-1,14413,14414,14614,14613,-1,14414,14415,14615,14614,-1,14415,14416,14616,14615,-1,14416,14417,14617,14616,-1,14417,14418,14618,14617,-1,14418,14419,14619,14618,-1,14419,14420,14620,14619,-1,14420,14421,14621,14620,-1,14421,14422,14622,14621,-1,14422,14423,14623,14622,-1,14423,14424,14624,14623,-1,14424,14425,14625,14624,-1,14425,14426,14626,14625,-1,14426,14427,14627,14626,-1,14427,14428,14628,14627,-1,14428,14429,14629,14628,-1,14429,14430,14630,14629,-1,14430,14431,14631,14630,-1,14431,14432,14632,14631,-1,14432,14433,14633,14632,-1,14433,14434,14634,14633,-1,14434,14435,14635,14634,-1,14435,14436,14636,14635,-1,14436,14437,14637,14636,-1,14437,14438,14638,14637,-1,14438,14439,14639,14638,-1,14439,14440,14640,14639,-1,14440,14441,14641,14640,-1,14441,14442,14642,14641,-1,14442,14443,14643,14642,-1,14443,14444,14644,14643,-1,14444,14445,14645,14644,-1,14445,14446,14646,14645,-1,14446,14447,14647,14646,-1,14447,14448,14648,14647,-1,14448,14449,14649,14648,-1,14449,14450,14650,14649,-1,14450,14451,14651,14650,-1,14451,14452,14652,14651,-1,14452,14453,14653,14652,-1,14453,14454,14654,14653,-1,14454,14455,14655,14654,-1,14455,14456,14656,14655,-1,14456,14457,14657,14656,-1,14457,14458,14658,14657,-1,14458,14459,14659,14658,-1,14459,14460,14660,14659,-1,14460,14461,14661,14660,-1,14461,14462,14662,14661,-1,14462,14463,14663,14662,-1,14463,14464,14664,14663,-1,14464,14465,14665,14664,-1,14465,14466,14666,14665,-1,14466,14467,14667,14666,-1,14467,14468,14668,14667,-1,14468,14469,14669,14668,-1,14469,14470,14670,14669,-1,14470,14471,14671,14670,-1,14471,14472,14672,14671,-1,14472,14473,14673,14672,-1,14473,14474,14674,14673,-1,14474,14475,14675,14674,-1,14475,14476,14676,14675,-1,14476,14477,14677,14676,-1,14477,14478,14678,14677,-1,14478,14479,14679,14678,-1,14479,14480,14680,14679,-1,14480,14481,14681,14680,-1,14481,14482,14682,14681,-1,14482,14483,14683,14682,-1,14483,14484,14684,14683,-1,14484,14485,14685,14684,-1,14485,14486,14686,14685,-1,14486,14487,14687,14686,-1,14487,14488,14688,14687,-1,14488,14489,14689,14688,-1,14489,14490,14690,14689,-1,14490,14491,14691,14690,-1,14491,14492,14692,14691,-1,14492,14493,14693,14692,-1,14493,14494,14694,14693,-1,14494,14495,14695,14694,-1,14495,14496,14696,14695,-1,14496,14497,14697,14696,-1,14497,14498,14698,14697,-1,14498,14499,14699,14698,-1,14499,14500,14700,14699,-1,14500,14501,14701,14700,-1,14501,14502,14702,14701,-1,14502,14503,14703,14702,-1,14503,14504,14704,14703,-1,14504,14505,14705,14704,-1,14505,14506,14706,14705,-1,14506,14507,14707,14706,-1,14507,14508,14708,14707,-1,14508,14509,14709,14708,-1,14509,14510,14710,14709,-1,14510,14511,14711,14710,-1,14511,14512,14712,14711,-1,14512,14513,14713,14712,-1,14513,14514,14714,14713,-1,14514,14515,14715,14714,-1,14515,14516,14716,14715,-1,14516,14517,14717,14716,-1,14517,14518,14718,14717,-1,14518,14519,14719,14718,-1,14519,14520,14720,14719,-1,14520,14521,14721,14720,-1,14521,14522,14722,14721,-1,14522,14523,14723,14722,-1,14523,14524,14724,14723,-1,14524,14525,14725,14724,-1,14525,14526,14726,14725,-1,14526,14527,14727,14726,-1,14527,14528,14728,14727,-1,14528,14529,14729,14728,-1,14529,14530,14730,14729,-1,14530,14531,14731,14730,-1,14531,14532,14732,14731,-1,14532,14533,14733,14732,-1,14533,14534,14734,14733,-1,14534,14535,14735,14734,-1,14535,14536,14736,14735,-1,14536,14537,14737,14736,-1,14537,14538,14738,14737,-1,14538,14539,14739,14738,-1,14539,14540,14740,14739,-1,14540,14541,14741,14740,-1,14541,14542,14742,14741,-1,14542,14543,14743,14742,-1,14543,14544,14744,14743,-1,14544,14545,14745,14744,-1,14545,14546,14746,14745,-1,14546,14547,14747,14746,-1,14547,14548,14748,14747,-1,14548,14549,14749,14748,-1,14549,14550,14750,14749,-1,14550,14551,14751,14750,-1,14551,14552,14752,14751,-1,14552,14553,14753,14752,-1,14553,14554,14754,14753,-1,14554,14555,14755,14754,-1,14555,14556,14756,14755,-1,14556,14557,14757,14756,-1,14557,14558,14758,14757,-1,14558,14559,14759,14758,-1,14559,14560,14760,14759,-1,14560,14561,14761,14760,-1,14561,14562,14762,14761,-1,14562,14563,14763,14762,-1,14563,14564,14764,14763,-1,14564,14565,14765,14764,-1,14565,14566,14766,14765,-1,14566,14567,14767,14766,-1,14567,14568,14768,14767,-1,14568,14569,14769,14768,-1,14569,14570,14770,14769,-1,14570,14571,14771,14770,-1,14571,14572,14772,14771,-1,14572,14573,14773,14772,-1,14573,14574,14774,14773,-1,14574,14575,14775,14774,-1,14575,14576,14776,14775,-1,14576,14577,14777,14776,-1,14577,14578,14778,14777,-1,14578,14579,14779,14778,-1,14579,14580,14780,14779,-1,14580,14581,14781,14780,-1,14581,14582,14782,14781,-1,14582,14583,14783,14782,-1,14583,14584,14784,14783,-1,14584,14585,14785,14784,-1,14585,14586,14786,14785,-1,14586,14587,14787,14786,-1,14587,14588,14788,14787,-1,14588,14589,14789,14788,-1,14589,14590,14790,14789,-1,14590,14591,14791,14790,-1,14591,14592,14792,14791,-1,14592,14593,14793,14792,-1,14593,14594,14794,14793,-1,14594,14595,14795,14794,-1,14595,14596,14796,14795,-1,14596,14597,14797,14796,-1,14597,14598,14798,14797,-1,14598,14599,14799,14798,-1,14600,14601,14801,14800,-1,14601,14602,14802,14801,-1,14602,14603,14803,14802,-1,14603,14604,14804,14803,-1,14604,14605,14805,14804,-1,14605,14606,14806,14805,-1,14606,14607,14807,14806,-1,14607,14608,14808,14807,-1,14608,14609,14809,14808,-1,14609,14610,14810,14809,-1,14610,14611,14811,14810,-1,14611,14612,14812,14811,-1,14612,14613,14813,14812,-1,14613,14614,14814,14813,-1,14614,14615,14815,14814,-1,14615,14616,14816,14815,-1,14616,14617,14817,14816,-1,14617,14618,14818,14817,-1,14618,14619,14819,14818,-1,14619,14620,14820,14819,-1,14620,14621,14821,14820,-1,14621,14622,14822,14821,-1,14622,14623,14823,14822,-1,14623,14624,14824,14823,-1,14624,14625,14825,14824,-1,14625,14626,14826,14825,-1,14626,14627,14827,14826,-1,14627,14628,14828,14827,-1,14628,14629,14829,14828,-1,14629,14630,14830,14829,-1,14630,14631,14831,14830,-1,14631,14632,14832,14831,-1,14632,14633,14833,14832,-1,14633,14634,14834,14833,-1,14634,14635,14835,14834,-1,14635,14636,14836,14835,-1,14636,14637,14837,14836,-1,14637,14638,14838,14837,-1,14638,14639,14839,14838,-1,14639,14640,14840,14839,-1,14640,14641,14841,14840,-1,14641,14642,14842,14841,-1,14642,14643,14843,14842,-1,14643,14644,14844,14843,-1,14644,14645,14845,14844,-1,14645,14646,14846,14845,-1,14646,14647,14847,14846,-1,14647,14648,14848,14847,-1,14648,14649,14849,14848,-1,14649,14650,14850,14849,-1,14650,14651,14851,14850,-1,14651,14652,14852,14851,-1,14652,14653,14853,14852,-1,14653,14654,14854,14853,-1,14654,14655,14855,14854,-1,14655,14656,14856,14855,-1,14656,14657,14857,14856,-1,14657,14658,14858,14857,-1,14658,14659,14859,14858,-1,14659,14660,14860,14859,-1,14660,14661,14861,14860,-1,14661,14662,14862,14861,-1,14662,14663,14863,14862,-1,14663,14664,14864,14863,-1,14664,14665,14865,14864,-1,14665,14666,14866,14865,-1,14666,14667,14867,14866,-1,14667,14668,14868,14867,-1,14668,14669,14869,14868,-1,14669,14670,14870,14869,-1,14670,14671,14871,14870,-1,14671,14672,14872,14871,-1,14672,14673,14873,14872,-1,14673,14674,14874,14873,-1,14674,14675,14875,14874,-1,14675,14676,14876,14875,-1,14676,14677,14877,14876,-1,14677,14678,14878,14877,-1,14678,14679,14879,14878,-1,14679,14680,14880,14879,-1,14680,14681,14881,14880,-1,14681,14682,14882,14881,-1,14682,14683,14883,14882,-1,14683,14684,14884,14883,-1,14684,14685,14885,14884,-1,14685,14686,14886,14885,-1,14686,14687,14887,14886,-1,14687,14688,14888,14887,-1,14688,14689,14889,14888,-1,14689,14690,14890,14889,-1,14690,14691,14891,14890,-1,14691,14692,14892,14891,-1,14692,14693,14893,14892,-1,14693,14694,14894,14893,-1,14694,14695,14895,14894,-1,14695,14696,14896,14895,-1,14696,14697,14897,14896,-1,14697,14698,14898,14897,-1,14698,14699,14899,14898,-1,14699,14700,14900,14899,-1,14700,14701,14901,14900,-1,14701,14702,14902,14901,-1,14702,14703,14903,14902,-1,14703,14704,14904,14903,-1,14704,14705,14905,14904,-1,14705,14706,14906,14905,-1,14706,14707,14907,14906,-1,14707,14708,14908,14907,-1,14708,14709,14909,14908,-1,14709,14710,14910,14909,-1,14710,14711,14911,14910,-1,14711,14712,14912,14911,-1,14712,14713,14913,14912,-1,14713,14714,14914,14913,-1,14714,14715,14915,14914,-1,14715,14716,14916,14915,-1,14716,14717,14917,14916,-1,14717,14718,14918,14917,-1,14718,14719,14919,14918,-1,14719,14720,14920,14919,-1,14720,14721,14921,14920,-1,14721,14722,14922,14921,-1,14722,14723,14923,14922,-1,14723,14724,14924,14923,-1,14724,14725,14925,14924,-1,14725,14726,14926,14925,-1,14726,14727,14927,14926,-1,14727,14728,14928,14927,-1,14728,14729,14929,14928,-1,14729,14730,14930,14929,-1,14730,14731,14931,14930,-1,14731,14732,14932,14931,-1,14732,14733,14933,14932,-1,14733,14734,14934,14933,-1,14734,14735,14935,14934,-1,14735,14736,14936,14935,-1,14736,14737,14937,14936,-1,14737,14738,14938,14937,-1,14738,14739,14939,14938,-1,14739,14740,14940,14939,-1,14740,14741,14941,14940,-1,14741,14742,14942,14941,-1,14742,14743,14943,14942,-1,14743,14744,14944,14943,-1,14744,14745,14945,14944,-1,14745,14746,14946,14945,-1,14746,14747,14947,14946,-1,14747,14748,14948,14947,-1,14748,14749,14949,14948,-1,14749,14750,14950,14949,-1,14750,14751,14951,14950,-1,14751,14752,14952,14951,-1,14752,14753,14953,14952,-1,14753,14754,14954,14953,-1,14754,14755,14955,14954,-1,14755,14756,14956,14955,-1,14756,14757,14957,14956,-1,14757,14758,14958,14957,-1,14758,14759,14959,14958,-1,14759,14760,14960,14959,-1,14760,14761,14961,14960,-1,14761,14762,14962,14961,-1,14762,14763,14963,14962,-1,14763,14764,14964,14963,-1,14764,14765,14965,14964,-1,14765,14766,14966,14965,-1,14766,14767,14967,14966,-1,14767,14768,14968,14967,-1,14768,14769,14969,14968,-1,14769,14770,14970,14969,-1,14770,14771,14971,14970,-1,14771,14772,14972,14971,-1,14772,14773,14973,14972,-1,14773,14774,14974,14973,-1,14774,14775,14975,14974,-1,14775,14776,14976,14975,-1,14776,14777,14977,14976,-1,14777,14778,14978,14977,-1,14778,14779,14979,14978,-1,14779,14780,14980,14979,-1,14780,14781,14981,14980,-1,14781,14782,14982,14981,-1,14782,14783,14983,14982,-1,14783,14784,14984,14983,-1,14784,14785,14985,14984,-1,14785,14786,14986,14985,-1,14786,14787,14987,14986,-1,14787,14788,14988,14987,-1,14788,14789,14989,14988,-1,14789,14790,14990,14989,-1,14790,14791,14991,14990,-1,14791,14792,14992,14991,-1,14792,14793,14993,14992,-1,14793,14794,14994,14993,-1,14794,14795,14995,14994,-1,14795,14796,14996,14995,-1,14796,14797,14997,14996,-1,14797,14798,14998,14997,-1,14798,14799,14999,14998,-1,14800,14801,15001,15,-1,14801,14802,15002,15001,-1,14802,14803,15003,15002,-1,14803,14804,15004,15003,-1,14804,14805,15005,15004,-1,14805,14806,15006,15005,-1,14806,14807,15007,15006,-1,14807,14808,15008,15007,-1,14808,14809,15009,15008,-1,14809,14810,15010,15009,-1,14810,14811,15011,15010,-1,14811,14812,15012,15011,-1,14812,14813,15013,15012,-1,14813,14814,15014,15013,-1,14814,14815,15015,15014,-1,14815,14816,15016,15015,-1,14816,14817,15017,15016,-1,14817,14818,15018,15017,-1,14818,14819,15019,15018,-1,14819,14820,15020,15019,-1,14820,14821,15021,15020,-1,14821,14822,15022,15021,-1,14822,14823,15023,15022,-1,14823,14824,15024,15023,-1,14824,14825,15025,15024,-1,14825,14826,15026,15025,-1,14826,14827,15027,15026,-1,14827,14828,15028,15027,-1,14828,14829,15029,15028,-1,14829,14830,15030,15029,-1,14830,14831,15031,15030,-1,14831,14832,15032,15031,-1,14832,14833,15033,15032,-1,14833,14834,15034,15033,-1,14834,14835,15035,15034,-1,14835,14836,15036,15035,-1,14836,14837,15037,15036,-1,14837,14838,15038,15037,-1,14838,14839,15039,15038,-1,14839,14840,15040,15039,-1,14840,14841,15041,15040,-1,14841,14842,15042,15041,-1,14842,14843,15043,15042,-1,14843,14844,15044,15043,-1,14844,14845,15045,15044,-1,14845,14846,15046,15045,-1,14846,14847,15047,15046,-1,14847,14848,15048,15047,-1,14848,14849,15049,15048,-1,14849,14850,15050,15049,-1,14850,14851,15051,15050,-1,14851,14852,15052,15051,-1,14852,14853,15053,15052,-1,14853,14854,15054,15053,-1,14854,14855,15055,15054,-1,14855,14856,15056,15055,-1,14856,14857,15057,15056,-1,14857,14858,15058,15057,-1,14858,14859,15059,15058,-1,14859,14860,15060,15059,-1,14860,14861,15061,15060,-1,14861,14862,15062,15061,-1,14862,14863,15063,15062,-1,14863,14864,15064,15063,-1,14864,14865,15065,15064,-1,14865,14866,15066,15065,-1,14866,14867,15067,15066,-1,14867,14868,15068,15067,-1,14868,14869,15069,15068,-1,14869,14870,15070,15069,-1,14870,14871,15071,15070,-1,14871,14872,15072,15071,-1,14872,14873,15073,15072,-1,14873,14874,15074,15073,-1,14874,14875,15075,15074,-1,14875,14876,15076,15075,-1,14876,14877,15077,15076,-1,14877,14878,15078,15077,-1,14878,14879,15079,15078,-1,14879,14880,15080,15079,-1,14880,14881,15081,15080,-1,14881,14882,15082,15081,-1,14882,14883,15083,15082,-1,14883,14884,15084,15083,-1,14884,14885,15085,15084,-1,14885,14886,15086,15085,-1,14886,14887,15087,15086,-1,14887,14888,15088,15087,-1,14888,14889,15089,15088,-1,14889,14890,15090,15089,-1,14890,14891,15091,15090,-1,14891,14892,15092,15091,-1,14892,14893,15093,15092,-1,14893,14894,15094,15093,-1,14894,14895,15095,15094,-1,14895,14896,15096,15095,-1,14896,14897,15097,15096,-1,14897,14898,15098,15097,-1,14898,14899,15099,15098,-1,14899,14900,15100,15099,-1,14900,14901,15101,15100,-1,14901,14902,15102,15101,-1,14902,14903,15103,15102,-1,14903,14904,15104,15103,-1,14904,14905,15105,15104,-1,14905,14906,15106,15105,-1,14906,14907,15107,15106,-1,14907,14908,15108,15107,-1,14908,14909,15109,15108,-1,14909,14910,15110,15109,-1,14910,14911,15111,15110,-1,14911,14912,15112,15111,-1,14912,14913,15113,15112,-1,14913,14914,15114,15113,-1,14914,14915,15115,15114,-1,14915,14916,15116,15115,-1,14916,14917,15117,15116,-1,14917,14918,15118,15117,-1,14918,14919,15119,15118,-1,14919,14920,15120,15119,-1,14920,14921,15121,15120,-1,14921,14922,15122,15121,-1,14922,14923,15123,15122,-1,14923,14924,15124,15123,-1,14924,14925,15125,15124,-1,14925,14926,15126,15125,-1,14926,14927,15127,15126,-1,14927,14928,15128,15127,-1,14928,14929,15129,15128,-1,14929,14930,15130,15129,-1,14930,14931,15131,15130,-1,14931,14932,15132,15131,-1,14932,14933,15133,15132,-1,14933,14934,15134,15133,-1,14934,14935,15135,15134,-1,14935,14936,15136,15135,-1,14936,14937,15137,15136,-1,14937,14938,15138,15137,-1,14938,14939,15139,15138,-1,14939,14940,15140,15139,-1,14940,14941,15141,15140,-1,14941,14942,15142,15141,-1,14942,14943,15143,15142,-1,14943,14944,15144,15143,-1,14944,14945,15145,15144,-1,14945,14946,15146,15145,-1,14946,14947,15147,15146,-1,14947,14948,15148,15147,-1,14948,14949,15149,15148,-1,14949,14950,15150,15149,-1,14950,14951,15151,15150,-1,14951,14952,15152,15151,-1,14952,14953,15153,15152,-1,14953,14954,15154,15153,-1,14954,14955,15155,15154,-1,14955,14956,15156,15155,-1,14956,14957,15157,15156,-1,14957,14958,15158,15157,-1,14958,14959,15159,15158,-1,14959,14960,15160,15159,-1,14960,14961,15161,15160,-1,14961,14962,15162,15161,-1,14962,14963,15163,15162,-1,14963,14964,15164,15163,-1,14964,14965,15165,15164,-1,14965,14966,15166,15165,-1,14966,14967,15167,15166,-1,14967,14968,15168,15167,-1,14968,14969,15169,15168,-1,14969,14970,15170,15169,-1,14970,14971,15171,15170,-1,14971,14972,15172,15171,-1,14972,14973,15173,15172,-1,14973,14974,15174,15173,-1,14974,14975,15175,15174,-1,14975,14976,15176,15175,-1,14976,14977,15177,15176,-1,14977,14978,15178,15177,-1,14978,14979,15179,15178,-1,14979,14980,15180,15179,-1,14980,14981,15181,15180,-1,14981,14982,15182,15181,-1,14982,14983,15183,15182,-1,14983,14984,15184,15183,-1,14984,14985,15185,15184,-1,14985,14986,15186,15185,-1,14986,14987,15187,15186,-1,14987,14988,15188,15187,-1,14988,14989,15189,15188,-1,14989,14990,15190,15189,-1,14990,14991,15191,15190,-1,14991,14992,15192,15191,-1,14992,14993,15193,15192,-1,14993,14994,15194,15193,-1,14994,14995,15195,15194,-1,14995,14996,15196,15195,-1,14996,14997,15197,15196,-1,14997,14998,15198,15197,-1,14998,14999,15199,15198,-1,15,15001,15201,15200,-1,15001,15002,15202,15201,-1,15002,15003,15203,15202,-1,15003,15004,15204,15203,-1,15004,15005,15205,15204,-1,15005,15006,15206,15205,-1,15006,15007,15207,15206,-1,15007,15008,15208,15207,-1,15008,15009,15209,15208,-1,15009,15010,15210,15209,-1,15010,15011,15211,15210,-1,15011,15012,15212,15211,-1,15012,15013,15213,15212,-1,15013,15014,15214,15213,-1,15014,15015,15215,15214,-1,15015,15016,15216,15215,-1,15016,15017,15217,15216,-1,15017,15018,15218,15217,-1,15018,15019,15219,15218,-1,15019,15020,15220,15219,-1,15020,15021,15221,15220,-1,15021,15022,15222,15221,-1,15022,15023,15223,15222,-1,15023,15024,15224,15223,-1,15024,15025,15225,15224,-1,15025,15026,15226,15225,-1,15026,15027,15227,15226,-1,15027,15028,15228,15227,-1,15028,15029,15229,15228,-1,15029,15030,15230,15229,-1,15030,15031,15231,15230,-1,15031,15032,15232,15231,-1,15032,15033,15233,15232,-1,15033,15034,15234,15233,-1,15034,15035,15235,15234,-1,15035,15036,15236,15235,-1,15036,15037,15237,15236,-1,15037,15038,15238,15237,-1,15038,15039,15239,15238,-1,15039,15040,15240,15239,-1,15040,15041,15241,15240,-1,15041,15042,15242,15241,-1,15042,15043,15243,15242,-1,15043,15044,15244,15243,-1,15044,15045,15245,15244,-1,15045,15046,15246,15245,-1,15046,15047,15247,15246,-1,15047,15048,15248,15247,-1,15048,15049,15249,15248,-1,15049,15050,15250,15249,-1,15050,15051,15251,15250,-1,15051,15052,15252,15251,-1,15052,15053,15253,15252,-1,15053,15054,15254,15253,-1,15054,15055,15255,15254,-1,15055,15056,15256,15255,-1,15056,15057,15257,15256,-1,15057,15058,15258,15257,-1,15058,15059,15259,15258,-1,15059,15060,15260,15259,-1,15060,15061,15261,15260,-1,15061,15062,15262,15261,-1,15062,15063,15263,15262,-1,15063,15064,15264,15263,-1,15064,15065,15265,15264,-1,15065,15066,15266,15265,-1,15066,15067,15267,15266,-1,15067,15068,15268,15267,-1,15068,15069,15269,15268,-1,15069,15070,15270,15269,-1,15070,15071,15271,15270,-1,15071,15072,15272,15271,-1,15072,15073,15273,15272,-1,15073,15074,15274,15273,-1,15074,15075,15275,15274,-1,15075,15076,15276,15275,-1,15076,15077,15277,15276,-1,15077,15078,15278,15277,-1,15078,15079,15279,15278,-1,15079,15080,15280,15279,-1,15080,15081,15281,15280,-1,15081,15082,15282,15281,-1,15082,15083,15283,15282,-1,15083,15084,15284,15283,-1,15084,15085,15285,15284,-1,15085,15086,15286,15285,-1,15086,15087,15287,15286,-1,15087,15088,15288,15287,-1,15088,15089,15289,15288,-1,15089,15090,15290,15289,-1,15090,15091,15291,15290,-1,15091,15092,15292,15291,-1,15092,15093,15293,15292,-1,15093,15094,15294,15293,-1,15094,15095,15295,15294,-1,15095,15096,15296,15295,-1,15096,15097,15297,15296,-1,15097,15098,15298,15297,-1,15098,15099,15299,15298,-1,15099,15100,15300,15299,-1,15100,15101,15301,15300,-1,15101,15102,15302,15301,-1,15102,15103,15303,15302,-1,15103,15104,15304,15303,-1,15104,15105,15305,15304,-1,15105,15106,15306,15305,-1,15106,15107,15307,15306,-1,15107,15108,15308,15307,-1,15108,15109,15309,15308,-1,15109,15110,15310,15309,-1,15110,15111,15311,15310,-1,15111,15112,15312,15311,-1,15112,15113,15313,15312,-1,15113,15114,15314,15313,-1,15114,15115,15315,15314,-1,15115,15116,15316,15315,-1,15116,15117,15317,15316,-1,15117,15118,15318,15317,-1,15118,15119,15319,15318,-1,15119,15120,15320,15319,-1,15120,15121,15321,15320,-1,15121,15122,15322,15321,-1,15122,15123,15323,15322,-1,15123,15124,15324,15323,-1,15124,15125,15325,15324,-1,15125,15126,15326,15325,-1,15126,15127,15327,15326,-1,15127,15128,15328,15327,-1,15128,15129,15329,15328,-1,15129,15130,15330,15329,-1,15130,15131,15331,15330,-1,15131,15132,15332,15331,-1,15132,15133,15333,15332,-1,15133,15134,15334,15333,-1,15134,15135,15335,15334,-1,15135,15136,15336,15335,-1,15136,15137,15337,15336,-1,15137,15138,15338,15337,-1,15138,15139,15339,15338,-1,15139,15140,15340,15339,-1,15140,15141,15341,15340,-1,15141,15142,15342,15341,-1,15142,15143,15343,15342,-1,15143,15144,15344,15343,-1,15144,15145,15345,15344,-1,15145,15146,15346,15345,-1,15146,15147,15347,15346,-1,15147,15148,15348,15347,-1,15148,15149,15349,15348,-1,15149,15150,15350,15349,-1,15150,15151,15351,15350,-1,15151,15152,15352,15351,-1,15152,15153,15353,15352,-1,15153,15154,15354,15353,-1,15154,15155,15355,15354,-1,15155,15156,15356,15355,-1,15156,15157,15357,15356,-1,15157,15158,15358,15357,-1,15158,15159,15359,15358,-1,15159,15160,15360,15359,-1,15160,15161,15361,15360,-1,15161,15162,15362,15361,-1,15162,15163,15363,15362,-1,15163,15164,15364,15363,-1,15164,15165,15365,15364,-1,15165,15166,15366,15365,-1,15166,15167,15367,15366,-1,15167,15168,15368,15367,-1,15168,15169,15369,15368,-1,15169,15170,15370,15369,-1,15170,15171,15371,15370,-1,15171,15172,15372,15371,-1,15172,15173,15373,15372,-1,15173,15174,15374,15373,-1,15174,15175,15375,15374,-1,15175,15176,15376,15375,-1,15176,15177,15377,15376,-1,15177,15178,15378,15377,-1,15178,15179,15379,15378,-1,15179,15180,15380,15379,-1,15180,15181,15381,15380,-1,15181,15182,15382,15381,-1,15182,15183,15383,15382,-1,15183,15184,15384,15383,-1,15184,15185,15385,15384,-1,15185,15186,15386,15385,-1,15186,15187,15387,15386,-1,15187,15188,15388,15387,-1,15188,15189,15389,15388,-1,15189,15190,15390,15389,-1,15190,15191,15391,15390,-1,15191,15192,15392,15391,-1,15192,15193,15393,15392,-1,15193,15194,15394,15393,-1,15194,15195,15395,15394,-1,15195,15196,15396,15395,-1,15196,15197,15397,15396,-1,15197,15198,15398,15397,-1,15198,15199,15399,15398,-1,15200,15201,15401,15400,-1,15201,15202,15402,15401,-1,15202,15203,15403,15402,-1,15203,15204,15404,15403,-1,15204,15205,15405,15404,-1,15205,15206,15406,15405,-1,15206,15207,15407,15406,-1,15207,15208,15408,15407,-1,15208,15209,15409,15408,-1,15209,15210,15410,15409,-1,15210,15211,15411,15410,-1,15211,15212,15412,15411,-1,15212,15213,15413,15412,-1,15213,15214,15414,15413,-1,15214,15215,15415,15414,-1,15215,15216,15416,15415,-1,15216,15217,15417,15416,-1,15217,15218,15418,15417,-1,15218,15219,15419,15418,-1,15219,15220,15420,15419,-1,15220,15221,15421,15420,-1,15221,15222,15422,15421,-1,15222,15223,15423,15422,-1,15223,15224,15424,15423,-1,15224,15225,15425,15424,-1,15225,15226,15426,15425,-1,15226,15227,15427,15426,-1,15227,15228,15428,15427,-1,15228,15229,15429,15428,-1,15229,15230,15430,15429,-1,15230,15231,15431,15430,-1,15231,15232,15432,15431,-1,15232,15233,15433,15432,-1,15233,15234,15434,15433,-1,15234,15235,15435,15434,-1,15235,15236,15436,15435,-1,15236,15237,15437,15436,-1,15237,15238,15438,15437,-1,15238,15239,15439,15438,-1,15239,15240,15440,15439,-1,15240,15241,15441,15440,-1,15241,15242,15442,15441,-1,15242,15243,15443,15442,-1,15243,15244,15444,15443,-1,15244,15245,15445,15444,-1,15245,15246,15446,15445,-1,15246,15247,15447,15446,-1,15247,15248,15448,15447,-1,15248,15249,15449,15448,-1,15249,15250,15450,15449,-1,15250,15251,15451,15450,-1,15251,15252,15452,15451,-1,15252,15253,15453,15452,-1,15253,15254,15454,15453,-1,15254,15255,15455,15454,-1,15255,15256,15456,15455,-1,15256,15257,15457,15456,-1,15257,15258,15458,15457,-1,15258,15259,15459,15458,-1,15259,15260,15460,15459,-1,15260,15261,15461,15460,-1,15261,15262,15462,15461,-1,15262,15263,15463,15462,-1,15263,15264,15464,15463,-1,15264,15265,15465,15464,-1,15265,15266,15466,15465,-1,15266,15267,15467,15466,-1,15267,15268,15468,15467,-1,15268,15269,15469,15468,-1,15269,15270,15470,15469,-1,15270,15271,15471,15470,-1,15271,15272,15472,15471,-1,15272,15273,15473,15472,-1,15273,15274,15474,15473,-1,15274,15275,15475,15474,-1,15275,15276,15476,15475,-1,15276,15277,15477,15476,-1,15277,15278,15478,15477,-1,15278,15279,15479,15478,-1,15279,15280,15480,15479,-1,15280,15281,15481,15480,-1,15281,15282,15482,15481,-1,15282,15283,15483,15482,-1,15283,15284,15484,15483,-1,15284,15285,15485,15484,-1,15285,15286,15486,15485,-1,15286,15287,15487,15486,-1,15287,15288,15488,15487,-1,15288,15289,15489,15488,-1,15289,15290,15490,15489,-1,15290,15291,15491,15490,-1,15291,15292,15492,15491,-1,15292,15293,15493,15492,-1,15293,15294,15494,15493,-1,15294,15295,15495,15494,-1,15295,15296,15496,15495,-1,15296,15297,15497,15496,-1,15297,15298,15498,15497,-1,15298,15299,15499,15498,-1,15299,15300,15500,15499,-1,15300,15301,15501,15500,-1,15301,15302,15502,15501,-1,15302,15303,15503,15502,-1,15303,15304,15504,15503,-1,15304,15305,15505,15504,-1,15305,15306,15506,15505,-1,15306,15307,15507,15506,-1,15307,15308,15508,15507,-1,15308,15309,15509,15508,-1,15309,15310,15510,15509,-1,15310,15311,15511,15510,-1,15311,15312,15512,15511,-1,15312,15313,15513,15512,-1,15313,15314,15514,15513,-1,15314,15315,15515,15514,-1,15315,15316,15516,15515,-1,15316,15317,15517,15516,-1,15317,15318,15518,15517,-1,15318,15319,15519,15518,-1,15319,15320,15520,15519,-1,15320,15321,15521,15520,-1,15321,15322,15522,15521,-1,15322,15323,15523,15522,-1,15323,15324,15524,15523,-1,15324,15325,15525,15524,-1,15325,15326,15526,15525,-1,15326,15327,15527,15526,-1,15327,15328,15528,15527,-1,15328,15329,15529,15528,-1,15329,15330,15530,15529,-1,15330,15331,15531,15530,-1,15331,15332,15532,15531,-1,15332,15333,15533,15532,-1,15333,15334,15534,15533,-1,15334,15335,15535,15534,-1,15335,15336,15536,15535,-1,15336,15337,15537,15536,-1,15337,15338,15538,15537,-1,15338,15339,15539,15538,-1,15339,15340,15540,15539,-1,15340,15341,15541,15540,-1,15341,15342,15542,15541,-1,15342,15343,15543,15542,-1,15343,15344,15544,15543,-1,15344,15345,15545,15544,-1,15345,15346,15546,15545,-1,15346,15347,15547,15546,-1,15347,15348,15548,15547,-1,15348,15349,15549,15548,-1,15349,15350,15550,15549,-1,15350,15351,15551,15550,-1,15351,15352,15552,15551,-1,15352,15353,15553,15552,-1,15353,15354,15554,15553,-1,15354,15355,15555,15554,-1,15355,15356,15556,15555,-1,15356,15357,15557,15556,-1,15357,15358,15558,15557,-1,15358,15359,15559,15558,-1,15359,15360,15560,15559,-1,15360,15361,15561,15560,-1,15361,15362,15562,15561,-1,15362,15363,15563,15562,-1,15363,15364,15564,15563,-1,15364,15365,15565,15564,-1,15365,15366,15566,15565,-1,15366,15367,15567,15566,-1,15367,15368,15568,15567,-1,15368,15369,15569,15568,-1,15369,15370,15570,15569,-1,15370,15371,15571,15570,-1,15371,15372,15572,15571,-1,15372,15373,15573,15572,-1,15373,15374,15574,15573,-1,15374,15375,15575,15574,-1,15375,15376,15576,15575,-1,15376,15377,15577,15576,-1,15377,15378,15578,15577,-1,15378,15379,15579,15578,-1,15379,15380,15580,15579,-1,15380,15381,15581,15580,-1,15381,15382,15582,15581,-1,15382,15383,15583,15582,-1,15383,15384,15584,15583,-1,15384,15385,15585,15584,-1,15385,15386,15586,15585,-1,15386,15387,15587,15586,-1,15387,15388,15588,15587,-1,15388,15389,15589,15588,-1,15389,15390,15590,15589,-1,15390,15391,15591,15590,-1,15391,15392,15592,15591,-1,15392,15393,15593,15592,-1,15393,15394,15594,15593,-1,15394,15395,15595,15594,-1,15395,15396,15596,15595,-1,15396,15397,15597,15596,-1,15397,15398,15598,15597,-1,15398,15399,15599,15598,-1,15400,15401,15601,15600,-1,15401,15402,15602,15601,-1,15402,15403,15603,15602,-1,15403,15404,15604,15603,-1,15404,15405,15605,15604,-1,15405,15406,15606,15605,-1,15406,15407,15607,15606,-1,15407,15408,15608,15607,-1,15408,15409,15609,15608,-1,15409,15410,15610,15609,-1,15410,15411,15611,15610,-1,15411,15412,15612,15611,-1,15412,15413,15613,15612,-1,15413,15414,15614,15613,-1,15414,15415,15615,15614,-1,15415,15416,15616,15615,-1,15416,15417,15617,15616,-1,15417,15418,15618,15617,-1,15418,15419,15619,15618,-1,15419,15420,15620,15619,-1,15420,15421,15621,15620,-1,15421,15422,15622,15621,-1,15422,15423,15623,15622,-1,15423,15424,15624,15623,-1,15424,15425,15625,15624,-1,15425,15426,15626,15625,-1,15426,15427,15627,15626,-1,15427,15428,15628,15627,-1,15428,15429,15629,15628,-1,15429,15430,15630,15629,-1,15430,15431,15631,15630,-1,15431,15432,15632,15631,-1,15432,15433,15633,15632,-1,15433,15434,15634,15633,-1,15434,15435,15635,15634,-1,15435,15436,15636,15635,-1,15436,15437,15637,15636,-1,15437,15438,15638,15637,-1,15438,15439,15639,15638,-1,15439,15440,15640,15639,-1,15440,15441,15641,15640,-1,15441,15442,15642,15641,-1,15442,15443,15643,15642,-1,15443,15444,15644,15643,-1,15444,15445,15645,15644,-1,15445,15446,15646,15645,-1,15446,15447,15647,15646,-1,15447,15448,15648,15647,-1,15448,15449,15649,15648,-1,15449,15450,15650,15649,-1,15450,15451,15651,15650,-1,15451,15452,15652,15651,-1,15452,15453,15653,15652,-1,15453,15454,15654,15653,-1,15454,15455,15655,15654,-1,15455,15456,15656,15655,-1,15456,15457,15657,15656,-1,15457,15458,15658,15657,-1,15458,15459,15659,15658,-1,15459,15460,15660,15659,-1,15460,15461,15661,15660,-1,15461,15462,15662,15661,-1,15462,15463,15663,15662,-1,15463,15464,15664,15663,-1,15464,15465,15665,15664,-1,15465,15466,15666,15665,-1,15466,15467,15667,15666,-1,15467,15468,15668,15667,-1,15468,15469,15669,15668,-1,15469,15470,15670,15669,-1,15470,15471,15671,15670,-1,15471,15472,15672,15671,-1,15472,15473,15673,15672,-1,15473,15474,15674,15673,-1,15474,15475,15675,15674,-1,15475,15476,15676,15675,-1,15476,15477,15677,15676,-1,15477,15478,15678,15677,-1,15478,15479,15679,15678,-1,15479,15480,15680,15679,-1,15480,15481,15681,15680,-1,15481,15482,15682,15681,-1,15482,15483,15683,15682,-1,15483,15484,15684,15683,-1,15484,15485,15685,15684,-1,15485,15486,15686,15685,-1,15486,15487,15687,15686,-1,15487,15488,15688,15687,-1,15488,15489,15689,15688,-1,15489,15490,15690,15689,-1,15490,15491,15691,15690,-1,15491,15492,15692,15691,-1,15492,15493,15693,15692,-1,15493,15494,15694,15693,-1,15494,15495,15695,15694,-1,15495,15496,15696,15695,-1,15496,15497,15697,15696,-1,15497,15498,15698,15697,-1,15498,15499,15699,15698,-1,15499,15500,15700,15699,-1,15500,15501,15701,15700,-1,15501,15502,15702,15701,-1,15502,15503,15703,15702,-1,15503,15504,15704,15703,-1,15504,15505,15705,15704,-1,15505,15506,15706,15705,-1,15506,15507,15707,15706,-1,15507,15508,15708,15707,-1,15508,15509,15709,15708,-1,15509,15510,15710,15709,-1,15510,15511,15711,15710,-1,15511,15512,15712,15711,-1,15512,15513,15713,15712,-1,15513,15514,15714,15713,-1,15514,15515,15715,15714,-1,15515,15516,15716,15715,-1,15516,15517,15717,15716,-1,15517,15518,15718,15717,-1,15518,15519,15719,15718,-1,15519,15520,15720,15719,-1,15520,15521,15721,15720,-1,15521,15522,15722,15721,-1,15522,15523,15723,15722,-1,15523,15524,15724,15723,-1,15524,15525,15725,15724,-1,15525,15526,15726,15725,-1,15526,15527,15727,15726,-1,15527,15528,15728,15727,-1,15528,15529,15729,15728,-1,15529,15530,15730,15729,-1,15530,15531,15731,15730,-1,15531,15532,15732,15731,-1,15532,15533,15733,15732,-1,15533,15534,15734,15733,-1,15534,15535,15735,15734,-1,15535,15536,15736,15735,-1,15536,15537,15737,15736,-1,15537,15538,15738,15737,-1,15538,15539,15739,15738,-1,15539,15540,15740,15739,-1,15540,15541,15741,15740,-1,15541,15542,15742,15741,-1,15542,15543,15743,15742,-1,15543,15544,15744,15743,-1,15544,15545,15745,15744,-1,15545,15546,15746,15745,-1,15546,15547,15747,15746,-1,15547,15548,15748,15747,-1,15548,15549,15749,15748,-1,15549,15550,15750,15749,-1,15550,15551,15751,15750,-1,15551,15552,15752,15751,-1,15552,15553,15753,15752,-1,15553,15554,15754,15753,-1,15554,15555,15755,15754,-1,15555,15556,15756,15755,-1,15556,15557,15757,15756,-1,15557,15558,15758,15757,-1,15558,15559,15759,15758,-1,15559,15560,15760,15759,-1,15560,15561,15761,15760,-1,15561,15562,15762,15761,-1,15562,15563,15763,15762,-1,15563,15564,15764,15763,-1,15564,15565,15765,15764,-1,15565,15566,15766,15765,-1,15566,15567,15767,15766,-1,15567,15568,15768,15767,-1,15568,15569,15769,15768,-1,15569,15570,15770,15769,-1,15570,15571,15771,15770,-1,15571,15572,15772,15771,-1,15572,15573,15773,15772,-1,15573,15574,15774,15773,-1,15574,15575,15775,15774,-1,15575,15576,15776,15775,-1,15576,15577,15777,15776,-1,15577,15578,15778,15777,-1,15578,15579,15779,15778,-1,15579,15580,15780,15779,-1,15580,15581,15781,15780,-1,15581,15582,15782,15781,-1,15582,15583,15783,15782,-1,15583,15584,15784,15783,-1,15584,15585,15785,15784,-1,15585,15586,15786,15785,-1,15586,15587,15787,15786,-1,15587,15588,15788,15787,-1,15588,15589,15789,15788,-1,15589,15590,15790,15789,-1,15590,15591,15791,15790,-1,15591,15592,15792,15791,-1,15592,15593,15793,15792,-1,15593,15594,15794,15793,-1,15594,15595,15795,15794,-1,15595,15596,15796,15795,-1,15596,15597,15797,15796,-1,15597,15598,15798,15797,-1,15598,15599,15799,15798,-1,15600,15601,15801,15800,-1,15601,15602,15802,15801,-1,15602,15603,15803,15802,-1,15603,15604,15804,15803,-1,15604,15605,15805,15804,-1,15605,15606,15806,15805,-1,15606,15607,15807,15806,-1,15607,15608,15808,15807,-1,15608,15609,15809,15808,-1,15609,15610,15810,15809,-1,15610,15611,15811,15810,-1,15611,15612,15812,15811,-1,15612,15613,15813,15812,-1,15613,15614,15814,15813,-1,15614,15615,15815,15814,-1,15615,15616,15816,15815,-1,15616,15617,15817,15816,-1,15617,15618,15818,15817,-1,15618,15619,15819,15818,-1,15619,15620,15820,15819,-1,15620,15621,15821,15820,-1,15621,15622,15822,15821,-1,15622,15623,15823,15822,-1,15623,15624,15824,15823,-1,15624,15625,15825,15824,-1,15625,15626,15826,15825,-1,15626,15627,15827,15826,-1,15627,15628,15828,15827,-1,15628,15629,15829,15828,-1,15629,15630,15830,15829,-1,15630,15631,15831,15830,-1,15631,15632,15832,15831,-1,15632,15633,15833,15832,-1,15633,15634,15834,15833,-1,15634,15635,15835,15834,-1,15635,15636,15836,15835,-1,15636,15637,15837,15836,-1,15637,15638,15838,15837,-1,15638,15639,15839,15838,-1,15639,15640,15840,15839,-1,15640,15641,15841,15840,-1,15641,15642,15842,15841,-1,15642,15643,15843,15842,-1,15643,15644,15844,15843,-1,15644,15645,15845,15844,-1,15645,15646,15846,15845,-1,15646,15647,15847,15846,-1,15647,15648,15848,15847,-1,15648,15649,15849,15848,-1,15649,15650,15850,15849,-1,15650,15651,15851,15850,-1,15651,15652,15852,15851,-1,15652,15653,15853,15852,-1,15653,15654,15854,15853,-1,15654,15655,15855,15854,-1,15655,15656,15856,15855,-1,15656,15657,15857,15856,-1,15657,15658,15858,15857,-1,15658,15659,15859,15858,-1,15659,15660,15860,15859,-1,15660,15661,15861,15860,-1,15661,15662,15862,15861,-1,15662,15663,15863,15862,-1,15663,15664,15864,15863,-1,15664,15665,15865,15864,-1,15665,15666,15866,15865,-1,15666,15667,15867,15866,-1,15667,15668,15868,15867,-1,15668,15669,15869,15868,-1,15669,15670,15870,15869,-1,15670,15671,15871,15870,-1,15671,15672,15872,15871,-1,15672,15673,15873,15872,-1,15673,15674,15874,15873,-1,15674,15675,15875,15874,-1,15675,15676,15876,15875,-1,15676,15677,15877,15876,-1,15677,15678,15878,15877,-1,15678,15679,15879,15878,-1,15679,15680,15880,15879,-1,15680,15681,15881,15880,-1,15681,15682,15882,15881,-1,15682,15683,15883,15882,-1,15683,15684,15884,15883,-1,15684,15685,15885,15884,-1,15685,15686,15886,15885,-1,15686,15687,15887,15886,-1,15687,15688,15888,15887,-1,15688,15689,15889,15888,-1,15689,15690,15890,15889,-1,15690,15691,15891,15890,-1,15691,15692,15892,15891,-1,15692,15693,15893,15892,-1,15693,15694,15894,15893,-1,15694,15695,15895,15894,-1,15695,15696,15896,15895,-1,15696,15697,15897,15896,-1,15697,15698,15898,15897,-1,15698,15699,15899,15898,-1,15699,15700,15900,15899,-1,15700,15701,15901,15900,-1,15701,15702,15902,15901,-1,15702,15703,15903,15902,-1,15703,15704,15904,15903,-1,15704,15705,15905,15904,-1,15705,15706,15906,15905,-1,15706,15707,15907,15906,-1,15707,15708,15908,15907,-1,15708,15709,15909,15908,-1,15709,15710,15910,15909,-1,15710,15711,15911,15910,-1,15711,15712,15912,15911,-1,15712,15713,15913,15912,-1,15713,15714,15914,15913,-1,15714,15715,15915,15914,-1,15715,15716,15916,15915,-1,15716,15717,15917,15916,-1,15717,15718,15918,15917,-1,15718,15719,15919,15918,-1,15719,15720,15920,15919,-1,15720,15721,15921,15920,-1,15721,15722,15922,15921,-1,15722,15723,15923,15922,-1,15723,15724,15924,15923,-1,15724,15725,15925,15924,-1,15725,15726,15926,15925,-1,15726,15727,15927,15926,-1,15727,15728,15928,15927,-1,15728,15729,15929,15928,-1,15729,15730,15930,15929,-1,15730,15731,15931,15930,-1,15731,15732,15932,15931,-1,15732,15733,15933,15932,-1,15733,15734,15934,15933,-1,15734,15735,15935,15934,-1,15735,15736,15936,15935,-1,15736,15737,15937,15936,-1,15737,15738,15938,15937,-1,15738,15739,15939,15938,-1,15739,15740,15940,15939,-1,15740,15741,15941,15940,-1,15741,15742,15942,15941,-1,15742,15743,15943,15942,-1,15743,15744,15944,15943,-1,15744,15745,15945,15944,-1,15745,15746,15946,15945,-1,15746,15747,15947,15946,-1,15747,15748,15948,15947,-1,15748,15749,15949,15948,-1,15749,15750,15950,15949,-1,15750,15751,15951,15950,-1,15751,15752,15952,15951,-1,15752,15753,15953,15952,-1,15753,15754,15954,15953,-1,15754,15755,15955,15954,-1,15755,15756,15956,15955,-1,15756,15757,15957,15956,-1,15757,15758,15958,15957,-1,15758,15759,15959,15958,-1,15759,15760,15960,15959,-1,15760,15761,15961,15960,-1,15761,15762,15962,15961,-1,15762,15763,15963,15962,-1,15763,15764,15964,15963,-1,15764,15765,15965,15964,-1,15765,15766,15966,15965,-1,15766,15767,15967,15966,-1,15767,15768,15968,15967,-1,15768,15769,15969,15968,-1,15769,15770,15970,15969,-1,15770,15771,15971,15970,-1,15771,15772,15972,15971,-1,15772,15773,15973,15972,-1,15773,15774,15974,15973,-1,15774,15775,15975,15974,-1,15775,15776,15976,15975,-1,15776,15777,15977,15976,-1,15777,15778,15978,15977,-1,15778,15779,15979,15978,-1,15779,15780,15980,15979,-1,15780,15781,15981,15980,-1,15781,15782,15982,15981,-1,15782,15783,15983,15982,-1,15783,15784,15984,15983,-1,15784,15785,15985,15984,-1,15785,15786,15986,15985,-1,15786,15787,15987,15986,-1,15787,15788,15988,15987,-1,15788,15789,15989,15988,-1,15789,15790,15990,15989,-1,15790,15791,15991,15990,-1,15791,15792,15992,15991,-1,15792,15793,15993,15992,-1,15793,15794,15994,15993,-1,15794,15795,15995,15994,-1,15795,15796,15996,15995,-1,15796,15797,15997,15996,-1,15797,15798,15998,15997,-1,15798,15799,15999,15998,-1,15800,15801,16001,16,-1,15801,15802,16002,16001,-1,15802,15803,16003,16002,-1,15803,15804,16004,16003,-1,15804,15805,16005,16004,-1,15805,15806,16006,16005,-1,15806,15807,16007,16006,-1,15807,15808,16008,16007,-1,15808,15809,16009,16008,-1,15809,15810,16010,16009,-1,15810,15811,16011,16010,-1,15811,15812,16012,16011,-1,15812,15813,16013,16012,-1,15813,15814,16014,16013,-1,15814,15815,16015,16014,-1,15815,15816,16016,16015,-1,15816,15817,16017,16016,-1,15817,15818,16018,16017,-1,15818,15819,16019,16018,-1,15819,15820,16020,16019,-1,15820,15821,16021,16020,-1,15821,15822,16022,16021,-1,15822,15823,16023,16022,-1,15823,15824,16024,16023,-1,15824,15825,16025,16024,-1,15825,15826,16026,16025,-1,15826,15827,16027,16026,-1,15827,15828,16028,16027,-1,15828,15829,16029,16028,-1,15829,15830,16030,16029,-1,15830,15831,16031,16030,-1,15831,15832,16032,16031,-1,15832,15833,16033,16032,-1,15833,15834,16034,16033,-1,15834,15835,16035,16034,-1,15835,15836,16036,16035,-1,15836,15837,16037,16036,-1,15837,15838,16038,16037,-1,15838,15839,16039,16038,-1,15839,15840,16040,16039,-1,15840,15841,16041,16040,-1,15841,15842,16042,16041,-1,15842,15843,16043,16042,-1,15843,15844,16044,16043,-1,15844,15845,16045,16044,-1,15845,15846,16046,16045,-1,15846,15847,16047,16046,-1,15847,15848,16048,16047,-1,15848,15849,16049,16048,-1,15849,15850,16050,16049,-1,15850,15851,16051,16050,-1,15851,15852,16052,16051,-1,15852,15853,16053,16052,-1,15853,15854,16054,16053,-1,15854,15855,16055,16054,-1,15855,15856,16056,16055,-1,15856,15857,16057,16056,-1,15857,15858,16058,16057,-1,15858,15859,16059,16058,-1,15859,15860,16060,16059,-1,15860,15861,16061,16060,-1,15861,15862,16062,16061,-1,15862,15863,16063,16062,-1,15863,15864,16064,16063,-1,15864,15865,16065,16064,-1,15865,15866,16066,16065,-1,15866,15867,16067,16066,-1,15867,15868,16068,16067,-1,15868,15869,16069,16068,-1,15869,15870,16070,16069,-1,15870,15871,16071,16070,-1,15871,15872,16072,16071,-1,15872,15873,16073,16072,-1,15873,15874,16074,16073,-1,15874,15875,16075,16074,-1,15875,15876,16076,16075,-1,15876,15877,16077,16076,-1,15877,15878,16078,16077,-1,15878,15879,16079,16078,-1,15879,15880,16080,16079,-1,15880,15881,16081,16080,-1,15881,15882,16082,16081,-1,15882,15883,16083,16082,-1,15883,15884,16084,16083,-1,15884,15885,16085,16084,-1,15885,15886,16086,16085,-1,15886,15887,16087,16086,-1,15887,15888,16088,16087,-1,15888,15889,16089,16088,-1,15889,15890,16090,16089,-1,15890,15891,16091,16090,-1,15891,15892,16092,16091,-1,15892,15893,16093,16092,-1,15893,15894,16094,16093,-1,15894,15895,16095,16094,-1,15895,15896,16096,16095,-1,15896,15897,16097,16096,-1,15897,15898,16098,16097,-1,15898,15899,16099,16098,-1,15899,15900,16100,16099,-1,15900,15901,16101,16100,-1,15901,15902,16102,16101,-1,15902,15903,16103,16102,-1,15903,15904,16104,16103,-1,15904,15905,16105,16104,-1,15905,15906,16106,16105,-1,15906,15907,16107,16106,-1,15907,15908,16108,16107,-1,15908,15909,16109,16108,-1,15909,15910,16110,16109,-1,15910,15911,16111,16110,-1,15911,15912,16112,16111,-1,15912,15913,16113,16112,-1,15913,15914,16114,16113,-1,15914,15915,16115,16114,-1,15915,15916,16116,16115,-1,15916,15917,16117,16116,-1,15917,15918,16118,16117,-1,15918,15919,16119,16118,-1,15919,15920,16120,16119,-1,15920,15921,16121,16120,-1,15921,15922,16122,16121,-1,15922,15923,16123,16122,-1,15923,15924,16124,16123,-1,15924,15925,16125,16124,-1,15925,15926,16126,16125,-1,15926,15927,16127,16126,-1,15927,15928,16128,16127,-1,15928,15929,16129,16128,-1,15929,15930,16130,16129,-1,15930,15931,16131,16130,-1,15931,15932,16132,16131,-1,15932,15933,16133,16132,-1,15933,15934,16134,16133,-1,15934,15935,16135,16134,-1,15935,15936,16136,16135,-1,15936,15937,16137,16136,-1,15937,15938,16138,16137,-1,15938,15939,16139,16138,-1,15939,15940,16140,16139,-1,15940,15941,16141,16140,-1,15941,15942,16142,16141,-1,15942,15943,16143,16142,-1,15943,15944,16144,16143,-1,15944,15945,16145,16144,-1,15945,15946,16146,16145,-1,15946,15947,16147,16146,-1,15947,15948,16148,16147,-1,15948,15949,16149,16148,-1,15949,15950,16150,16149,-1,15950,15951,16151,16150,-1,15951,15952,16152,16151,-1,15952,15953,16153,16152,-1,15953,15954,16154,16153,-1,15954,15955,16155,16154,-1,15955,15956,16156,16155,-1,15956,15957,16157,16156,-1,15957,15958,16158,16157,-1,15958,15959,16159,16158,-1,15959,15960,16160,16159,-1,15960,15961,16161,16160,-1,15961,15962,16162,16161,-1,15962,15963,16163,16162,-1,15963,15964,16164,16163,-1,15964,15965,16165,16164,-1,15965,15966,16166,16165,-1,15966,15967,16167,16166,-1,15967,15968,16168,16167,-1,15968,15969,16169,16168,-1,15969,15970,16170,16169,-1,15970,15971,16171,16170,-1,15971,15972,16172,16171,-1,15972,15973,16173,16172,-1,15973,15974,16174,16173,-1,15974,15975,16175,16174,-1,15975,15976,16176,16175,-1,15976,15977,16177,16176,-1,15977,15978,16178,16177,-1,15978,15979,16179,16178,-1,15979,15980,16180,16179,-1,15980,15981,16181,16180,-1,15981,15982,16182,16181,-1,15982,15983,16183,16182,-1,15983,15984,16184,16183,-1,15984,15985,16185,16184,-1,15985,15986,16186,16185,-1,15986,15987,16187,16186,-1,15987,15988,16188,16187,-1,15988,15989,16189,16188,-1,15989,15990,16190,16189,-1,15990,15991,16191,16190,-1,15991,15992,16192,16191,-1,15992,15993,16193,16192,-1,15993,15994,16194,16193,-1,15994,15995,16195,16194,-1,15995,15996,16196,16195,-1,15996,15997,16197,16196,-1,15997,15998,16198,16197,-1,15998,15999,16199,16198,-1,16,16001,16201,16200,-1,16001,16002,16202,16201,-1,16002,16003,16203,16202,-1,16003,16004,16204,16203,-1,16004,16005,16205,16204,-1,16005,16006,16206,16205,-1,16006,16007,16207,16206,-1,16007,16008,16208,16207,-1,16008,16009,16209,16208,-1,16009,16010,16210,16209,-1,16010,16011,16211,16210,-1,16011,16012,16212,16211,-1,16012,16013,16213,16212,-1,16013,16014,16214,16213,-1,16014,16015,16215,16214,-1,16015,16016,16216,16215,-1,16016,16017,16217,16216,-1,16017,16018,16218,16217,-1,16018,16019,16219,16218,-1,16019,16020,16220,16219,-1,16020,16021,16221,16220,-1,16021,16022,16222,16221,-1,16022,16023,16223,16222,-1,16023,16024,16224,16223,-1,16024,16025,16225,16224,-1,16025,16026,16226,16225,-1,16026,16027,16227,16226,-1,16027,16028,16228,16227,-1,16028,16029,16229,16228,-1,16029,16030,16230,16229,-1,16030,16031,16231,16230,-1,16031,16032,16232,16231,-1,16032,16033,16233,16232,-1,16033,16034,16234,16233,-1,16034,16035,16235,16234,-1,16035,16036,16236,16235,-1,16036,16037,16237,16236,-1,16037,16038,16238,16237,-1,16038,16039,16239,16238,-1,16039,16040,16240,16239,-1,16040,16041,16241,16240,-1,16041,16042,16242,16241,-1,16042,16043,16243,16242,-1,16043,16044,16244,16243,-1,16044,16045,16245,16244,-1,16045,16046,16246,16245,-1,16046,16047,16247,16246,-1,16047,16048,16248,16247,-1,16048,16049,16249,16248,-1,16049,16050,16250,16249,-1,16050,16051,16251,16250,-1,16051,16052,16252,16251,-1,16052,16053,16253,16252,-1,16053,16054,16254,16253,-1,16054,16055,16255,16254,-1,16055,16056,16256,16255,-1,16056,16057,16257,16256,-1,16057,16058,16258,16257,-1,16058,16059,16259,16258,-1,16059,16060,16260,16259,-1,16060,16061,16261,16260,-1,16061,16062,16262,16261,-1,16062,16063,16263,16262,-1,16063,16064,16264,16263,-1,16064,16065,16265,16264,-1,16065,16066,16266,16265,-1,16066,16067,16267,16266,-1,16067,16068,16268,16267,-1,16068,16069,16269,16268,-1,16069,16070,16270,16269,-1,16070,16071,16271,16270,-1,16071,16072,16272,16271,-1,16072,16073,16273,16272,-1,16073,16074,16274,16273,-1,16074,16075,16275,16274,-1,16075,16076,16276,16275,-1,16076,16077,16277,16276,-1,16077,16078,16278,16277,-1,16078,16079,16279,16278,-1,16079,16080,16280,16279,-1,16080,16081,16281,16280,-1,16081,16082,16282,16281,-1,16082,16083,16283,16282,-1,16083,16084,16284,16283,-1,16084,16085,16285,16284,-1,16085,16086,16286,16285,-1,16086,16087,16287,16286,-1,16087,16088,16288,16287,-1,16088,16089,16289,16288,-1,16089,16090,16290,16289,-1,16090,16091,16291,16290,-1,16091,16092,16292,16291,-1,16092,16093,16293,16292,-1,16093,16094,16294,16293,-1,16094,16095,16295,16294,-1,16095,16096,16296,16295,-1,16096,16097,16297,16296,-1,16097,16098,16298,16297,-1,16098,16099,16299,16298,-1,16099,16100,16300,16299,-1,16100,16101,16301,16300,-1,16101,16102,16302,16301,-1,16102,16103,16303,16302,-1,16103,16104,16304,16303,-1,16104,16105,16305,16304,-1,16105,16106,16306,16305,-1,16106,16107,16307,16306,-1,16107,16108,16308,16307,-1,16108,16109,16309,16308,-1,16109,16110,16310,16309,-1,16110,16111,16311,16310,-1,16111,16112,16312,16311,-1,16112,16113,16313,16312,-1,16113,16114,16314,16313,-1,16114,16115,16315,16314,-1,16115,16116,16316,16315,-1,16116,16117,16317,16316,-1,16117,16118,16318,16317,-1,16118,16119,16319,16318,-1,16119,16120,16320,16319,-1,16120,16121,16321,16320,-1,16121,16122,16322,16321,-1,16122,16123,16323,16322,-1,16123,16124,16324,16323,-1,16124,16125,16325,16324,-1,16125,16126,16326,16325,-1,16126,16127,16327,16326,-1,16127,16128,16328,16327,-1,16128,16129,16329,16328,-1,16129,16130,16330,16329,-1,16130,16131,16331,16330,-1,16131,16132,16332,16331,-1,16132,16133,16333,16332,-1,16133,16134,16334,16333,-1,16134,16135,16335,16334,-1,16135,16136,16336,16335,-1,16136,16137,16337,16336,-1,16137,16138,16338,16337,-1,16138,16139,16339,16338,-1,16139,16140,16340,16339,-1,16140,16141,16341,16340,-1,16141,16142,16342,16341,-1,16142,16143,16343,16342,-1,16143,16144,16344,16343,-1,16144,16145,16345,16344,-1,16145,16146,16346,16345,-1,16146,16147,16347,16346,-1,16147,16148,16348,16347,-1,16148,16149,16349,16348,-1,16149,16150,16350,16349,-1,16150,16151,16351,16350,-1,16151,16152,16352,16351,-1,16152,16153,16353,16352,-1,16153,16154,16354,16353,-1,16154,16155,16355,16354,-1,16155,16156,16356,16355,-1,16156,16157,16357,16356,-1,16157,16158,16358,16357,-1,16158,16159,16359,16358,-1,16159,16160,16360,16359,-1,16160,16161,16361,16360,-1,16161,16162,16362,16361,-1,16162,16163,16363,16362,-1,16163,16164,16364,16363,-1,16164,16165,16365,16364,-1,16165,16166,16366,16365,-1,16166,16167,16367,16366,-1,16167,16168,16368,16367,-1,16168,16169,16369,16368,-1,16169,16170,16370,16369,-1,16170,16171,16371,16370,-1,16171,16172,16372,16371,-1,16172,16173,16373,16372,-1,16173,16174,16374,16373,-1,16174,16175,16375,16374,-1,16175,16176,16376,16375,-1,16176,16177,16377,16376,-1,16177,16178,16378,16377,-1,16178,16179,16379,16378,-1,16179,16180,16380,16379,-1,16180,16181,16381,16380,-1,16181,16182,16382,16381,-1,16182,16183,16383,16382,-1,16183,16184,16384,16383,-1,16184,16185,16385,16384,-1,16185,16186,16386,16385,-1,16186,16187,16387,16386,-1,16187,16188,16388,16387,-1,16188,16189,16389,16388,-1,16189,16190,16390,16389,-1,16190,16191,16391,16390,-1,16191,16192,16392,16391,-1,16192,16193,16393,16392,-1,16193,16194,16394,16393,-1,16194,16195,16395,16394,-1,16195,16196,16396,16395,-1,16196,16197,16397,16396,-1,16197,16198,16398,16397,-1,16198,16199,16399,16398,-1,16200,16201,16401,16400,-1,16201,16202,16402,16401,-1,16202,16203,16403,16402,-1,16203,16204,16404,16403,-1,16204,16205,16405,16404,-1,16205,16206,16406,16405,-1,16206,16207,16407,16406,-1,16207,16208,16408,16407,-1,16208,16209,16409,16408,-1,16209,16210,16410,16409,-1,16210,16211,16411,16410,-1,16211,16212,16412,16411,-1,16212,16213,16413,16412,-1,16213,16214,16414,16413,-1,16214,16215,16415,16414,-1,16215,16216,16416,16415,-1,16216,16217,16417,16416,-1,16217,16218,16418,16417,-1,16218,16219,16419,16418,-1,16219,16220,16420,16419,-1,16220,16221,16421,16420,-1,16221,16222,16422,16421,-1,16222,16223,16423,16422,-1,16223,16224,16424,16423,-1,16224,16225,16425,16424,-1,16225,16226,16426,16425,-1,16226,16227,16427,16426,-1,16227,16228,16428,16427,-1,16228,16229,16429,16428,-1,16229,16230,16430,16429,-1,16230,16231,16431,16430,-1,16231,16232,16432,16431,-1,16232,16233,16433,16432,-1,16233,16234,16434,16433,-1,16234,16235,16435,16434,-1,16235,16236,16436,16435,-1,16236,16237,16437,16436,-1,16237,16238,16438,16437,-1,16238,16239,16439,16438,-1,16239,16240,16440,16439,-1,16240,16241,16441,16440,-1,16241,16242,16442,16441,-1,16242,16243,16443,16442,-1,16243,16244,16444,16443,-1,16244,16245,16445,16444,-1,16245,16246,16446,16445,-1,16246,16247,16447,16446,-1,16247,16248,16448,16447,-1,16248,16249,16449,16448,-1,16249,16250,16450,16449,-1,16250,16251,16451,16450,-1,16251,16252,16452,16451,-1,16252,16253,16453,16452,-1,16253,16254,16454,16453,-1,16254,16255,16455,16454,-1,16255,16256,16456,16455,-1,16256,16257,16457,16456,-1,16257,16258,16458,16457,-1,16258,16259,16459,16458,-1,16259,16260,16460,16459,-1,16260,16261,16461,16460,-1,16261,16262,16462,16461,-1,16262,16263,16463,16462,-1,16263,16264,16464,16463,-1,16264,16265,16465,16464,-1,16265,16266,16466,16465,-1,16266,16267,16467,16466,-1,16267,16268,16468,16467,-1,16268,16269,16469,16468,-1,16269,16270,16470,16469,-1,16270,16271,16471,16470,-1,16271,16272,16472,16471,-1,16272,16273,16473,16472,-1,16273,16274,16474,16473,-1,16274,16275,16475,16474,-1,16275,16276,16476,16475,-1,16276,16277,16477,16476,-1,16277,16278,16478,16477,-1,16278,16279,16479,16478,-1,16279,16280,16480,16479,-1,16280,16281,16481,16480,-1,16281,16282,16482,16481,-1,16282,16283,16483,16482,-1,16283,16284,16484,16483,-1,16284,16285,16485,16484,-1,16285,16286,16486,16485,-1,16286,16287,16487,16486,-1,16287,16288,16488,16487,-1,16288,16289,16489,16488,-1,16289,16290,16490,16489,-1,16290,16291,16491,16490,-1,16291,16292,16492,16491,-1,16292,16293,16493,16492,-1,16293,16294,16494,16493,-1,16294,16295,16495,16494,-1,16295,16296,16496,16495,-1,16296,16297,16497,16496,-1,16297,16298,16498,16497,-1,16298,16299,16499,16498,-1,16299,16300,16500,16499,-1,16300,16301,16501,16500,-1,16301,16302,16502,16501,-1,16302,16303,16503,16502,-1,16303,16304,16504,16503,-1,16304,16305,16505,16504,-1,16305,16306,16506,16505,-1,16306,16307,16507,16506,-1,16307,16308,16508,16507,-1,16308,16309,16509,16508,-1,16309,16310,16510,16509,-1,16310,16311,16511,16510,-1,16311,16312,16512,16511,-1,16312,16313,16513,16512,-1,16313,16314,16514,16513,-1,16314,16315,16515,16514,-1,16315,16316,16516,16515,-1,16316,16317,16517,16516,-1,16317,16318,16518,16517,-1,16318,16319,16519,16518,-1,16319,16320,16520,16519,-1,16320,16321,16521,16520,-1,16321,16322,16522,16521,-1,16322,16323,16523,16522,-1,16323,16324,16524,16523,-1,16324,16325,16525,16524,-1,16325,16326,16526,16525,-1,16326,16327,16527,16526,-1,16327,16328,16528,16527,-1,16328,16329,16529,16528,-1,16329,16330,16530,16529,-1,16330,16331,16531,16530,-1,16331,16332,16532,16531,-1,16332,16333,16533,16532,-1,16333,16334,16534,16533,-1,16334,16335,16535,16534,-1,16335,16336,16536,16535,-1,16336,16337,16537,16536,-1,16337,16338,16538,16537,-1,16338,16339,16539,16538,-1,16339,16340,16540,16539,-1,16340,16341,16541,16540,-1,16341,16342,16542,16541,-1,16342,16343,16543,16542,-1,16343,16344,16544,16543,-1,16344,16345,16545,16544,-1,16345,16346,16546,16545,-1,16346,16347,16547,16546,-1,16347,16348,16548,16547,-1,16348,16349,16549,16548,-1,16349,16350,16550,16549,-1,16350,16351,16551,16550,-1,16351,16352,16552,16551,-1,16352,16353,16553,16552,-1,16353,16354,16554,16553,-1,16354,16355,16555,16554,-1,16355,16356,16556,16555,-1,16356,16357,16557,16556,-1,16357,16358,16558,16557,-1,16358,16359,16559,16558,-1,16359,16360,16560,16559,-1,16360,16361,16561,16560,-1,16361,16362,16562,16561,-1,16362,16363,16563,16562,-1,16363,16364,16564,16563,-1,16364,16365,16565,16564,-1,16365,16366,16566,16565,-1,16366,16367,16567,16566,-1,16367,16368,16568,16567,-1,16368,16369,16569,16568,-1,16369,16370,16570,16569,-1,16370,16371,16571,16570,-1,16371,16372,16572,16571,-1,16372,16373,16573,16572,-1,16373,16374,16574,16573,-1,16374,16375,16575,16574,-1,16375,16376,16576,16575,-1,16376,16377,16577,16576,-1,16377,16378,16578,16577,-1,16378,16379,16579,16578,-1,16379,16380,16580,16579,-1,16380,16381,16581,16580,-1,16381,16382,16582,16581,-1,16382,16383,16583,16582,-1,16383,16384,16584,16583,-1,16384,16385,16585,16584,-1,16385,16386,16586,16585,-1,16386,16387,16587,16586,-1,16387,16388,16588,16587,-1,16388,16389,16589,16588,-1,16389,16390,16590,16589,-1,16390,16391,16591,16590,-1,16391,16392,16592,16591,-1,16392,16393,16593,16592,-1,16393,16394,16594,16593,-1,16394,16395,16595,16594,-1,16395,16396,16596,16595,-1,16396,16397,16597,16596,-1,16397,16398,16598,16597,-1,16398,16399,16599,16598,-1,16400,16401,16601,16600,-1,16401,16402,16602,16601,-1,16402,16403,16603,16602,-1,16403,16404,16604,16603,-1,16404,16405,16605,16604,-1,16405,16406,16606,16605,-1,16406,16407,16607,16606,-1,16407,16408,16608,16607,-1,16408,16409,16609,16608,-1,16409,16410,16610,16609,-1,16410,16411,16611,16610,-1,16411,16412,16612,16611,-1,16412,16413,16613,16612,-1,16413,16414,16614,16613,-1,16414,16415,16615,16614,-1,16415,16416,16616,16615,-1,16416,16417,16617,16616,-1,16417,16418,16618,16617,-1,16418,16419,16619,16618,-1,16419,16420,16620,16619,-1,16420,16421,16621,16620,-1,16421,16422,16622,16621,-1,16422,16423,16623,16622,-1,16423,16424,16624,16623,-1,16424,16425,16625,16624,-1,16425,16426,16626,16625,-1,16426,16427,16627,16626,-1,16427,16428,16628,16627,-1,16428,16429,16629,16628,-1,16429,16430,16630,16629,-1,16430,16431,16631,16630,-1,16431,16432,16632,16631,-1,16432,16433,16633,16632,-1,16433,16434,16634,16633,-1,16434,16435,16635,16634,-1,16435,16436,16636,16635,-1,16436,16437,16637,16636,-1,16437,16438,16638,16637,-1,16438,16439,16639,16638,-1,16439,16440,16640,16639,-1,16440,16441,16641,16640,-1,16441,16442,16642,16641,-1,16442,16443,16643,16642,-1,16443,16444,16644,16643,-1,16444,16445,16645,16644,-1,16445,16446,16646,16645,-1,16446,16447,16647,16646,-1,16447,16448,16648,16647,-1,16448,16449,16649,16648,-1,16449,16450,16650,16649,-1,16450,16451,16651,16650,-1,16451,16452,16652,16651,-1,16452,16453,16653,16652,-1,16453,16454,16654,16653,-1,16454,16455,16655,16654,-1,16455,16456,16656,16655,-1,16456,16457,16657,16656,-1,16457,16458,16658,16657,-1,16458,16459,16659,16658,-1,16459,16460,16660,16659,-1,16460,16461,16661,16660,-1,16461,16462,16662,16661,-1,16462,16463,16663,16662,-1,16463,16464,16664,16663,-1,16464,16465,16665,16664,-1,16465,16466,16666,16665,-1,16466,16467,16667,16666,-1,16467,16468,16668,16667,-1,16468,16469,16669,16668,-1,16469,16470,16670,16669,-1,16470,16471,16671,16670,-1,16471,16472,16672,16671,-1,16472,16473,16673,16672,-1,16473,16474,16674,16673,-1,16474,16475,16675,16674,-1,16475,16476,16676,16675,-1,16476,16477,16677,16676,-1,16477,16478,16678,16677,-1,16478,16479,16679,16678,-1,16479,16480,16680,16679,-1,16480,16481,16681,16680,-1,16481,16482,16682,16681,-1,16482,16483,16683,16682,-1,16483,16484,16684,16683,-1,16484,16485,16685,16684,-1,16485,16486,16686,16685,-1,16486,16487,16687,16686,-1,16487,16488,16688,16687,-1,16488,16489,16689,16688,-1,16489,16490,16690,16689,-1,16490,16491,16691,16690,-1,16491,16492,16692,16691,-1,16492,16493,16693,16692,-1,16493,16494,16694,16693,-1,16494,16495,16695,16694,-1,16495,16496,16696,16695,-1,16496,16497,16697,16696,-1,16497,16498,16698,16697,-1,16498,16499,16699,16698,-1,16499,16500,16700,16699,-1,16500,16501,16701,16700,-1,16501,16502,16702,16701,-1,16502,16503,16703,16702,-1,16503,16504,16704,16703,-1,16504,16505,16705,16704,-1,16505,16506,16706,16705,-1,16506,16507,16707,16706,-1,16507,16508,16708,16707,-1,16508,16509,16709,16708,-1,16509,16510,16710,16709,-1,16510,16511,16711,16710,-1,16511,16512,16712,16711,-1,16512,16513,16713,16712,-1,16513,16514,16714,16713,-1,16514,16515,16715,16714,-1,16515,16516,16716,16715,-1,16516,16517,16717,16716,-1,16517,16518,16718,16717,-1,16518,16519,16719,16718,-1,16519,16520,16720,16719,-1,16520,16521,16721,16720,-1,16521,16522,16722,16721,-1,16522,16523,16723,16722,-1,16523,16524,16724,16723,-1,16524,16525,16725,16724,-1,16525,16526,16726,16725,-1,16526,16527,16727,16726,-1,16527,16528,16728,16727,-1,16528,16529,16729,16728,-1,16529,16530,16730,16729,-1,16530,16531,16731,16730,-1,16531,16532,16732,16731,-1,16532,16533,16733,16732,-1,16533,16534,16734,16733,-1,16534,16535,16735,16734,-1,16535,16536,16736,16735,-1,16536,16537,16737,16736,-1,16537,16538,16738,16737,-1,16538,16539,16739,16738,-1,16539,16540,16740,16739,-1,16540,16541,16741,16740,-1,16541,16542,16742,16741,-1,16542,16543,16743,16742,-1,16543,16544,16744,16743,-1,16544,16545,16745,16744,-1,16545,16546,16746,16745,-1,16546,16547,16747,16746,-1,16547,16548,16748,16747,-1,16548,16549,16749,16748,-1,16549,16550,16750,16749,-1,16550,16551,16751,16750,-1,16551,16552,16752,16751,-1,16552,16553,16753,16752,-1,16553,16554,16754,16753,-1,16554,16555,16755,16754,-1,16555,16556,16756,16755,-1,16556,16557,16757,16756,-1,16557,16558,16758,16757,-1,16558,16559,16759,16758,-1,16559,16560,16760,16759,-1,16560,16561,16761,16760,-1,16561,16562,16762,16761,-1,16562,16563,16763,16762,-1,16563,16564,16764,16763,-1,16564,16565,16765,16764,-1,16565,16566,16766,16765,-1,16566,16567,16767,16766,-1,16567,16568,16768,16767,-1,16568,16569,16769,16768,-1,16569,16570,16770,16769,-1,16570,16571,16771,16770,-1,16571,16572,16772,16771,-1,16572,16573,16773,16772,-1,16573,16574,16774,16773,-1,16574,16575,16775,16774,-1,16575,16576,16776,16775,-1,16576,16577,16777,16776,-1,16577,16578,16778,16777,-1,16578,16579,16779,16778,-1,16579,16580,16780,16779,-1,16580,16581,16781,16780,-1,16581,16582,16782,16781,-1,16582,16583,16783,16782,-1,16583,16584,16784,16783,-1,16584,16585,16785,16784,-1,16585,16586,16786,16785,-1,16586,16587,16787,16786,-1,16587,16588,16788,16787,-1,16588,16589,16789,16788,-1,16589,16590,16790,16789,-1,16590,16591,16791,16790,-1,16591,16592,16792,16791,-1,16592,16593,16793,16792,-1,16593,16594,16794,16793,-1,16594,16595,16795,16794,-1,16595,16596,16796,16795,-1,16596,16597,16797,16796,-1,16597,16598,16798,16797,-1,16598,16599,16799,16798,-1,16600,16601,16801,16800,-1,16601,16602,16802,16801,-1,16602,16603,16803,16802,-1,16603,16604,16804,16803,-1,16604,16605,16805,16804,-1,16605,16606,16806,16805,-1,16606,16607,16807,16806,-1,16607,16608,16808,16807,-1,16608,16609,16809,16808,-1,16609,16610,16810,16809,-1,16610,16611,16811,16810,-1,16611,16612,16812,16811,-1,16612,16613,16813,16812,-1,16613,16614,16814,16813,-1,16614,16615,16815,16814,-1,16615,16616,16816,16815,-1,16616,16617,16817,16816,-1,16617,16618,16818,16817,-1,16618,16619,16819,16818,-1,16619,16620,16820,16819,-1,16620,16621,16821,16820,-1,16621,16622,16822,16821,-1,16622,16623,16823,16822,-1,16623,16624,16824,16823,-1,16624,16625,16825,16824,-1,16625,16626,16826,16825,-1,16626,16627,16827,16826,-1,16627,16628,16828,16827,-1,16628,16629,16829,16828,-1,16629,16630,16830,16829,-1,16630,16631,16831,16830,-1,16631,16632,16832,16831,-1,16632,16633,16833,16832,-1,16633,16634,16834,16833,-1,16634,16635,16835,16834,-1,16635,16636,16836,16835,-1,16636,16637,16837,16836,-1,16637,16638,16838,16837,-1,16638,16639,16839,16838,-1,16639,16640,16840,16839,-1,16640,16641,16841,16840,-1,16641,16642,16842,16841,-1,16642,16643,16843,16842,-1,16643,16644,16844,16843,-1,16644,16645,16845,16844,-1,16645,16646,16846,16845,-1,16646,16647,16847,16846,-1,16647,16648,16848,16847,-1,16648,16649,16849,16848,-1,16649,16650,16850,16849,-1,16650,16651,16851,16850,-1,16651,16652,16852,16851,-1,16652,16653,16853,16852,-1,16653,16654,16854,16853,-1,16654,16655,16855,16854,-1,16655,16656,16856,16855,-1,16656,16657,16857,16856,-1,16657,16658,16858,16857,-1,16658,16659,16859,16858,-1,16659,16660,16860,16859,-1,16660,16661,16861,16860,-1,16661,16662,16862,16861,-1,16662,16663,16863,16862,-1,16663,16664,16864,16863,-1,16664,16665,16865,16864,-1,16665,16666,16866,16865,-1,16666,16667,16867,16866,-1,16667,16668,16868,16867,-1,16668,16669,16869,16868,-1,16669,16670,16870,16869,-1,16670,16671,16871,16870,-1,16671,16672,16872,16871,-1,16672,16673,16873,16872,-1,16673,16674,16874,16873,-1,16674,16675,16875,16874,-1,16675,16676,16876,16875,-1,16676,16677,16877,16876,-1,16677,16678,16878,16877,-1,16678,16679,16879,16878,-1,16679,16680,16880,16879,-1,16680,16681,16881,16880,-1,16681,16682,16882,16881,-1,16682,16683,16883,16882,-1,16683,16684,16884,16883,-1,16684,16685,16885,16884,-1,16685,16686,16886,16885,-1,16686,16687,16887,16886,-1,16687,16688,16888,16887,-1,16688,16689,16889,16888,-1,16689,16690,16890,16889,-1,16690,16691,16891,16890,-1,16691,16692,16892,16891,-1,16692,16693,16893,16892,-1,16693,16694,16894,16893,-1,16694,16695,16895,16894,-1,16695,16696,16896,16895,-1,16696,16697,16897,16896,-1,16697,16698,16898,16897,-1,16698,16699,16899,16898,-1,16699,16700,16900,16899,-1,16700,16701,16901,16900,-1,16701,16702,16902,16901,-1,16702,16703,16903,16902,-1,16703,16704,16904,16903,-1,16704,16705,16905,16904,-1,16705,16706,16906,16905,-1,16706,16707,16907,16906,-1,16707,16708,16908,16907,-1,16708,16709,16909,16908,-1,16709,16710,16910,16909,-1,16710,16711,16911,16910,-1,16711,16712,16912,16911,-1,16712,16713,16913,16912,-1,16713,16714,16914,16913,-1,16714,16715,16915,16914,-1,16715,16716,16916,16915,-1,16716,16717,16917,16916,-1,16717,16718,16918,16917,-1,16718,16719,16919,16918,-1,16719,16720,16920,16919,-1,16720,16721,16921,16920,-1,16721,16722,16922,16921,-1,16722,16723,16923,16922,-1,16723,16724,16924,16923,-1,16724,16725,16925,16924,-1,16725,16726,16926,16925,-1,16726,16727,16927,16926,-1,16727,16728,16928,16927,-1,16728,16729,16929,16928,-1,16729,16730,16930,16929,-1,16730,16731,16931,16930,-1,16731,16732,16932,16931,-1,16732,16733,16933,16932,-1,16733,16734,16934,16933,-1,16734,16735,16935,16934,-1,16735,16736,16936,16935,-1,16736,16737,16937,16936,-1,16737,16738,16938,16937,-1,16738,16739,16939,16938,-1,16739,16740,16940,16939,-1,16740,16741,16941,16940,-1,16741,16742,16942,16941,-1,16742,16743,16943,16942,-1,16743,16744,16944,16943,-1,16744,16745,16945,16944,-1,16745,16746,16946,16945,-1,16746,16747,16947,16946,-1,16747,16748,16948,16947,-1,16748,16749,16949,16948,-1,16749,16750,16950,16949,-1,16750,16751,16951,16950,-1,16751,16752,16952,16951,-1,16752,16753,16953,16952,-1,16753,16754,16954,16953,-1,16754,16755,16955,16954,-1,16755,16756,16956,16955,-1,16756,16757,16957,16956,-1,16757,16758,16958,16957,-1,16758,16759,16959,16958,-1,16759,16760,16960,16959,-1,16760,16761,16961,16960,-1,16761,16762,16962,16961,-1,16762,16763,16963,16962,-1,16763,16764,16964,16963,-1,16764,16765,16965,16964,-1,16765,16766,16966,16965,-1,16766,16767,16967,16966,-1,16767,16768,16968,16967,-1,16768,16769,16969,16968,-1,16769,16770,16970,16969,-1,16770,16771,16971,16970,-1,16771,16772,16972,16971,-1,16772,16773,16973,16972,-1,16773,16774,16974,16973,-1,16774,16775,16975,16974,-1,16775,16776,16976,16975,-1,16776,16777,16977,16976,-1,16777,16778,16978,16977,-1,16778,16779,16979,16978,-1,16779,16780,16980,16979,-1,16780,16781,16981,16980,-1,16781,16782,16982,16981,-1,16782,16783,16983,16982,-1,16783,16784,16984,16983,-1,16784,16785,16985,16984,-1,16785,16786,16986,16985,-1,16786,16787,16987,16986,-1,16787,16788,16988,16987,-1,16788,16789,16989,16988,-1,16789,16790,16990,16989,-1,16790,16791,16991,16990,-1,16791,16792,16992,16991,-1,16792,16793,16993,16992,-1,16793,16794,16994,16993,-1,16794,16795,16995,16994,-1,16795,16796,16996,16995,-1,16796,16797,16997,16996,-1,16797,16798,16998,16997,-1,16798,16799,16999,16998,-1,16800,16801,17001,17,-1,16801,16802,17002,17001,-1,16802,16803,17003,17002,-1,16803,16804,17004,17003,-1,16804,16805,17005,17004,-1,16805,16806,17006,17005,-1,16806,16807,17007,17006,-1,16807,16808,17008,17007,-1,16808,16809,17009,17008,-1,16809,16810,17010,17009,-1,16810,16811,17011,17010,-1,16811,16812,17012,17011,-1,16812,16813,17013,17012,-1,16813,16814,17014,17013,-1,16814,16815,17015,17014,-1,16815,16816,17016,17015,-1,16816,16817,17017,17016,-1,16817,16818,17018,17017,-1,16818,16819,17019,17018,-1,16819,16820,17020,17019,-1,16820,16821,17021,17020,-1,16821,16822,17022,17021,-1,16822,16823,17023,17022,-1,16823,16824,17024,17023,-1,16824,16825,17025,17024,-1,16825,16826,17026,17025,-1,16826,16827,17027,17026,-1,16827,16828,17028,17027,-1,16828,16829,17029,17028,-1,16829,16830,17030,17029,-1,16830,16831,17031,17030,-1,16831,16832,17032,17031,-1,16832,16833,17033,17032,-1,16833,16834,17034,17033,-1,16834,16835,17035,17034,-1,16835,16836,17036,17035,-1,16836,16837,17037,17036,-1,16837,16838,17038,17037,-1,16838,16839,17039,17038,-1,16839,16840,17040,17039,-1,16840,16841,17041,17040,-1,16841,16842,17042,17041,-1,16842,16843,17043,17042,-1,16843,16844,17044,17043,-1,16844,16845,17045,17044,-1,16845,16846,17046,17045,-1,16846,16847,17047,17046,-1,16847,16848,17048,17047,-1,16848,16849,17049,17048,-1,16849,16850,17050,17049,-1,16850,16851,17051,17050,-1,16851,16852,17052,17051,-1,16852,16853,17053,17052,-1,16853,16854,17054,17053,-1,16854,16855,17055,17054,-1,16855,16856,17056,17055,-1,16856,16857,17057,17056,-1,16857,16858,17058,17057,-1,16858,16859,17059,17058,-1,16859,16860,17060,17059,-1,16860,16861,17061,17060,-1,16861,16862,17062,17061,-1,16862,16863,17063,17062,-1,16863,16864,17064,17063,-1,16864,16865,17065,17064,-1,16865,16866,17066,17065,-1,16866,16867,17067,17066,-1,16867,16868,17068,17067,-1,16868,16869,17069,17068,-1,16869,16870,17070,17069,-1,16870,16871,17071,17070,-1,16871,16872,17072,17071,-1,16872,16873,17073,17072,-1,16873,16874,17074,17073,-1,16874,16875,17075,17074,-1,16875,16876,17076,17075,-1,16876,16877,17077,17076,-1,16877,16878,17078,17077,-1,16878,16879,17079,17078,-1,16879,16880,17080,17079,-1,16880,16881,17081,17080,-1,16881,16882,17082,17081,-1,16882,16883,17083,17082,-1,16883,16884,17084,17083,-1,16884,16885,17085,17084,-1,16885,16886,17086,17085,-1,16886,16887,17087,17086,-1,16887,16888,17088,17087,-1,16888,16889,17089,17088,-1,16889,16890,17090,17089,-1,16890,16891,17091,17090,-1,16891,16892,17092,17091,-1,16892,16893,17093,17092,-1,16893,16894,17094,17093,-1,16894,16895,17095,17094,-1,16895,16896,17096,17095,-1,16896,16897,17097,17096,-1,16897,16898,17098,17097,-1,16898,16899,17099,17098,-1,16899,16900,17100,17099,-1,16900,16901,17101,17100,-1,16901,16902,17102,17101,-1,16902,16903,17103,17102,-1,16903,16904,17104,17103,-1,16904,16905,17105,17104,-1,16905,16906,17106,17105,-1,16906,16907,17107,17106,-1,16907,16908,17108,17107,-1,16908,16909,17109,17108,-1,16909,16910,17110,17109,-1,16910,16911,17111,17110,-1,16911,16912,17112,17111,-1,16912,16913,17113,17112,-1,16913,16914,17114,17113,-1,16914,16915,17115,17114,-1,16915,16916,17116,17115,-1,16916,16917,17117,17116,-1,16917,16918,17118,17117,-1,16918,16919,17119,17118,-1,16919,16920,17120,17119,-1,16920,16921,17121,17120,-1,16921,16922,17122,17121,-1,16922,16923,17123,17122,-1,16923,16924,17124,17123,-1,16924,16925,17125,17124,-1,16925,16926,17126,17125,-1,16926,16927,17127,17126,-1,16927,16928,17128,17127,-1,16928,16929,17129,17128,-1,16929,16930,17130,17129,-1,16930,16931,17131,17130,-1,16931,16932,17132,17131,-1,16932,16933,17133,17132,-1,16933,16934,17134,17133,-1,16934,16935,17135,17134,-1,16935,16936,17136,17135,-1,16936,16937,17137,17136,-1,16937,16938,17138,17137,-1,16938,16939,17139,17138,-1,16939,16940,17140,17139,-1,16940,16941,17141,17140,-1,16941,16942,17142,17141,-1,16942,16943,17143,17142,-1,16943,16944,17144,17143,-1,16944,16945,17145,17144,-1,16945,16946,17146,17145,-1,16946,16947,17147,17146,-1,16947,16948,17148,17147,-1,16948,16949,17149,17148,-1,16949,16950,17150,17149,-1,16950,16951,17151,17150,-1,16951,16952,17152,17151,-1,16952,16953,17153,17152,-1,16953,16954,17154,17153,-1,16954,16955,17155,17154,-1,16955,16956,17156,17155,-1,16956,16957,17157,17156,-1,16957,16958,17158,17157,-1,16958,16959,17159,17158,-1,16959,16960,17160,17159,-1,16960,16961,17161,17160,-1,16961,16962,17162,17161,-1,16962,16963,17163,17162,-1,16963,16964,17164,17163,-1,16964,16965,17165,17164,-1,16965,16966,17166,17165,-1,16966,16967,17167,17166,-1,16967,16968,17168,17167,-1,16968,16969,17169,17168,-1,16969,16970,17170,17169,-1,16970,16971,17171,17170,-1,16971,16972,17172,17171,-1,16972,16973,17173,17172,-1,16973,16974,17174,17173,-1,16974,16975,17175,17174,-1,16975,16976,17176,17175,-1,16976,16977,17177,17176,-1,16977,16978,17178,17177,-1,16978,16979,17179,17178,-1,16979,16980,17180,17179,-1,16980,16981,17181,17180,-1,16981,16982,17182,17181,-1,16982,16983,17183,17182,-1,16983,16984,17184,17183,-1,16984,16985,17185,17184,-1,16985,16986,17186,17185,-1,16986,16987,17187,17186,-1,16987,16988,17188,17187,-1,16988,16989,17189,17188,-1,16989,16990,17190,17189,-1,16990,16991,17191,17190,-1,16991,16992,17192,17191,-1,16992,16993,17193,17192,-1,16993,16994,17194,17193,-1,16994,16995,17195,17194,-1,16995,16996,17196,17195,-1,16996,16997,17197,17196,-1,16997,16998,17198,17197,-1,16998,16999,17199,17198,-1,17,17001,17201,17200,-1,17001,17002,17202,17201,-1,17002,17003,17203,17202,-1,17003,17004,17204,17203,-1,17004,17005,17205,17204,-1,17005,17006,17206,17205,-1,17006,17007,17207,17206,-1,17007,17008,17208,17207,-1,17008,17009,17209,17208,-1,17009,17010,17210,17209,-1,17010,17011,17211,17210,-1,17011,17012,17212,17211,-1,17012,17013,17213,17212,-1,17013,17014,17214,17213,-1,17014,17015,17215,17214,-1,17015,17016,17216,17215,-1,17016,17017,17217,17216,-1,17017,17018,17218,17217,-1,17018,17019,17219,17218,-1,17019,17020,17220,17219,-1,17020,17021,17221,17220,-1,17021,17022,17222,17221,-1,17022,17023,17223,17222,-1,17023,17024,17224,17223,-1,17024,17025,17225,17224,-1,17025,17026,17226,17225,-1,17026,17027,17227,17226,-1,17027,17028,17228,17227,-1,17028,17029,17229,17228,-1,17029,17030,17230,17229,-1,17030,17031,17231,17230,-1,17031,17032,17232,17231,-1,17032,17033,17233,17232,-1,17033,17034,17234,17233,-1,17034,17035,17235,17234,-1,17035,17036,17236,17235,-1,17036,17037,17237,17236,-1,17037,17038,17238,17237,-1,17038,17039,17239,17238,-1,17039,17040,17240,17239,-1,17040,17041,17241,17240,-1,17041,17042,17242,17241,-1,17042,17043,17243,17242,-1,17043,17044,17244,17243,-1,17044,17045,17245,17244,-1,17045,17046,17246,17245,-1,17046,17047,17247,17246,-1,17047,17048,17248,17247,-1,17048,17049,17249,17248,-1,17049,17050,17250,17249,-1,17050,17051,17251,17250,-1,17051,17052,17252,17251,-1,17052,17053,17253,17252,-1,17053,17054,17254,17253,-1,17054,17055,17255,17254,-1,17055,17056,17256,17255,-1,17056,17057,17257,17256,-1,17057,17058,17258,17257,-1,17058,17059,17259,17258,-1,17059,17060,17260,17259,-1,17060,17061,17261,17260,-1,17061,17062,17262,17261,-1,17062,17063,17263,17262,-1,17063,17064,17264,17263,-1,17064,17065,17265,17264,-1,17065,17066,17266,17265,-1,17066,17067,17267,17266,-1,17067,17068,17268,17267,-1,17068,17069,17269,17268,-1,17069,17070,17270,17269,-1,17070,17071,17271,17270,-1,17071,17072,17272,17271,-1,17072,17073,17273,17272,-1,17073,17074,17274,17273,-1,17074,17075,17275,17274,-1,17075,17076,17276,17275,-1,17076,17077,17277,17276,-1,17077,17078,17278,17277,-1,17078,17079,17279,17278,-1,17079,17080,17280,17279,-1,17080,17081,17281,17280,-1,17081,17082,17282,17281,-1,17082,17083,17283,17282,-1,17083,17084,17284,17283,-1,17084,17085,17285,17284,-1,17085,17086,17286,17285,-1,17086,17087,17287,17286,-1,17087,17088,17288,17287,-1,17088,17089,17289,17288,-1,17089,17090,17290,17289,-1,17090,17091,17291,17290,-1,17091,17092,17292,17291,-1,17092,17093,17293,17292,-1,17093,17094,17294,17293,-1,17094,17095,17295,17294,-1,17095,17096,17296,17295,-1,17096,17097,17297,17296,-1,17097,17098,17298,17297,-1,17098,17099,17299,17298,-1,17099,17100,17300,17299,-1,17100,17101,17301,17300,-1,17101,17102,17302,17301,-1,17102,17103,17303,17302,-1,17103,17104,17304,17303,-1,17104,17105,17305,17304,-1,17105,17106,17306,17305,-1,17106,17107,17307,17306,-1,17107,17108,17308,17307,-1,17108,17109,17309,17308,-1,17109,17110,17310,17309,-1,17110,17111,17311,17310,-1,17111,17112,17312,17311,-1,17112,17113,17313,17312,-1,17113,17114,17314,17313,-1,17114,17115,17315,17314,-1,17115,17116,17316,17315,-1,17116,17117,17317,17316,-1,17117,17118,17318,17317,-1,17118,17119,17319,17318,-1,17119,17120,17320,17319,-1,17120,17121,17321,17320,-1,17121,17122,17322,17321,-1,17122,17123,17323,17322,-1,17123,17124,17324,17323,-1,17124,17125,17325,17324,-1,17125,17126,17326,17325,-1,17126,17127,17327,17326,-1,17127,17128,17328,17327,-1,17128,17129,17329,17328,-1,17129,17130,17330,17329,-1,17130,17131,17331,17330,-1,17131,17132,17332,17331,-1,17132,17133,17333,17332,-1,17133,17134,17334,17333,-1,17134,17135,17335,17334,-1,17135,17136,17336,17335,-1,17136,17137,17337,17336,-1,17137,17138,17338,17337,-1,17138,17139,17339,17338,-1,17139,17140,17340,17339,-1,17140,17141,17341,17340,-1,17141,17142,17342,17341,-1,17142,17143,17343,17342,-1,17143,17144,17344,17343,-1,17144,17145,17345,17344,-1,17145,17146,17346,17345,-1,17146,17147,17347,17346,-1,17147,17148,17348,17347,-1,17148,17149,17349,17348,-1,17149,17150,17350,17349,-1,17150,17151,17351,17350,-1,17151,17152,17352,17351,-1,17152,17153,17353,17352,-1,17153,17154,17354,17353,-1,17154,17155,17355,17354,-1,17155,17156,17356,17355,-1,17156,17157,17357,17356,-1,17157,17158,17358,17357,-1,17158,17159,17359,17358,-1,17159,17160,17360,17359,-1,17160,17161,17361,17360,-1,17161,17162,17362,17361,-1,17162,17163,17363,17362,-1,17163,17164,17364,17363,-1,17164,17165,17365,17364,-1,17165,17166,17366,17365,-1,17166,17167,17367,17366,-1,17167,17168,17368,17367,-1,17168,17169,17369,17368,-1,17169,17170,17370,17369,-1,17170,17171,17371,17370,-1,17171,17172,17372,17371,-1,17172,17173,17373,17372,-1,17173,17174,17374,17373,-1,17174,17175,17375,17374,-1,17175,17176,17376,17375,-1,17176,17177,17377,17376,-1,17177,17178,17378,17377,-1,17178,17179,17379,17378,-1,17179,17180,17380,17379,-1,17180,17181,17381,17380,-1,17181,17182,17382,17381,-1,17182,17183,17383,17382,-1,17183,17184,17384,17383,-1,17184,17185,17385,17384,-1,17185,17186,17386,17385,-1,17186,17187,17387,17386,-1,17187,17188,17388,17387,-1,17188,17189,17389,17388,-1,17189,17190,17390,17389,-1,17190,17191,17391,17390,-1,17191,17192,17392,17391,-1,17192,17193,17393,17392,-1,17193,17194,17394,17393,-1,17194,17195,17395,17394,-1,17195,17196,17396,17395,-1,17196,17197,17397,17396,-1,17197,17198,17398,17397,-1,17198,17199,17399,17398,-1,17200,17201,17401,17400,-1,17201,17202,17402,17401,-1,17202,17203,17403,17402,-1,17203,17204,17404,17403,-1,17204,17205,17405,17404,-1,17205,17206,17406,17405,-1,17206,17207,17407,17406,-1,17207,17208,17408,17407,-1,17208,17209,17409,17408,-1,17209,17210,17410,17409,-1,17210,17211,17411,17410,-1,17211,17212,17412,17411,-1,17212,17213,17413,17412,-1,17213,17214,17414,17413,-1,17214,17215,17415,17414,-1,17215,17216,17416,17415,-1,17216,17217,17417,17416,-1,17217,17218,17418,17417,-1,17218,17219,17419,17418,-1,17219,17220,17420,17419,-1,17220,17221,17421,17420,-1,17221,17222,17422,17421,-1,17222,17223,17423,17422,-1,17223,17224,17424,17423,-1,17224,17225,17425,17424,-1,17225,17226,17426,17425,-1,17226,17227,17427,17426,-1,17227,17228,17428,17427,-1,17228,17229,17429,17428,-1,17229,17230,17430,17429,-1,17230,17231,17431,17430,-1,17231,17232,17432,17431,-1,17232,17233,17433,17432,-1,17233,17234,17434,17433,-1,17234,17235,17435,17434,-1,17235,17236,17436,17435,-1,17236,17237,17437,17436,-1,17237,17238,17438,17437,-1,17238,17239,17439,17438,-1,17239,17240,17440,17439,-1,17240,17241,17441,17440,-1,17241,17242,17442,17441,-1,17242,17243,17443,17442,-1,17243,17244,17444,17443,-1,17244,17245,17445,17444,-1,17245,17246,17446,17445,-1,17246,17247,17447,17446,-1,17247,17248,17448,17447,-1,17248,17249,17449,17448,-1,17249,17250,17450,17449,-1,17250,17251,17451,17450,-1,17251,17252,17452,17451,-1,17252,17253,17453,17452,-1,17253,17254,17454,17453,-1,17254,17255,17455,17454,-1,17255,17256,17456,17455,-1,17256,17257,17457,17456,-1,17257,17258,17458,17457,-1,17258,17259,17459,17458,-1,17259,17260,17460,17459,-1,17260,17261,17461,17460,-1,17261,17262,17462,17461,-1,17262,17263,17463,17462,-1,17263,17264,17464,17463,-1,17264,17265,17465,17464,-1,17265,17266,17466,17465,-1,17266,17267,17467,17466,-1,17267,17268,17468,17467,-1,17268,17269,17469,17468,-1,17269,17270,17470,17469,-1,17270,17271,17471,17470,-1,17271,17272,17472,17471,-1,17272,17273,17473,17472,-1,17273,17274,17474,17473,-1,17274,17275,17475,17474,-1,17275,17276,17476,17475,-1,17276,17277,17477,17476,-1,17277,17278,17478,17477,-1,17278,17279,17479,17478,-1,17279,17280,17480,17479,-1,17280,17281,17481,17480,-1,17281,17282,17482,17481,-1,17282,17283,17483,17482,-1,17283,17284,17484,17483,-1,17284,17285,17485,17484,-1,17285,17286,17486,17485,-1,17286,17287,17487,17486,-1,17287,17288,17488,17487,-1,17288,17289,17489,17488,-1,17289,17290,17490,17489,-1,17290,17291,17491,17490,-1,17291,17292,17492,17491,-1,17292,17293,17493,17492,-1,17293,17294,17494,17493,-1,17294,17295,17495,17494,-1,17295,17296,17496,17495,-1,17296,17297,17497,17496,-1,17297,17298,17498,17497,-1,17298,17299,17499,17498,-1,17299,17300,17500,17499,-1,17300,17301,17501,17500,-1,17301,17302,17502,17501,-1,17302,17303,17503,17502,-1,17303,17304,17504,17503,-1,17304,17305,17505,17504,-1,17305,17306,17506,17505,-1,17306,17307,17507,17506,-1,17307,17308,17508,17507,-1,17308,17309,17509,17508,-1,17309,17310,17510,17509,-1,17310,17311,17511,17510,-1,17311,17312,17512,17511,-1,17312,17313,17513,17512,-1,17313,17314,17514,17513,-1,17314,17315,17515,17514,-1,17315,17316,17516,17515,-1,17316,17317,17517,17516,-1,17317,17318,17518,17517,-1,17318,17319,17519,17518,-1,17319,17320,17520,17519,-1,17320,17321,17521,17520,-1,17321,17322,17522,17521,-1,17322,17323,17523,17522,-1,17323,17324,17524,17523,-1,17324,17325,17525,17524,-1,17325,17326,17526,17525,-1,17326,17327,17527,17526,-1,17327,17328,17528,17527,-1,17328,17329,17529,17528,-1,17329,17330,17530,17529,-1,17330,17331,17531,17530,-1,17331,17332,17532,17531,-1,17332,17333,17533,17532,-1,17333,17334,17534,17533,-1,17334,17335,17535,17534,-1,17335,17336,17536,17535,-1,17336,17337,17537,17536,-1,17337,17338,17538,17537,-1,17338,17339,17539,17538,-1,17339,17340,17540,17539,-1,17340,17341,17541,17540,-1,17341,17342,17542,17541,-1,17342,17343,17543,17542,-1,17343,17344,17544,17543,-1,17344,17345,17545,17544,-1,17345,17346,17546,17545,-1,17346,17347,17547,17546,-1,17347,17348,17548,17547,-1,17348,17349,17549,17548,-1,17349,17350,17550,17549,-1,17350,17351,17551,17550,-1,17351,17352,17552,17551,-1,17352,17353,17553,17552,-1,17353,17354,17554,17553,-1,17354,17355,17555,17554,-1,17355,17356,17556,17555,-1,17356,17357,17557,17556,-1,17357,17358,17558,17557,-1,17358,17359,17559,17558,-1,17359,17360,17560,17559,-1,17360,17361,17561,17560,-1,17361,17362,17562,17561,-1,17362,17363,17563,17562,-1,17363,17364,17564,17563,-1,17364,17365,17565,17564,-1,17365,17366,17566,17565,-1,17366,17367,17567,17566,-1,17367,17368,17568,17567,-1,17368,17369,17569,17568,-1,17369,17370,17570,17569,-1,17370,17371,17571,17570,-1,17371,17372,17572,17571,-1,17372,17373,17573,17572,-1,17373,17374,17574,17573,-1,17374,17375,17575,17574,-1,17375,17376,17576,17575,-1,17376,17377,17577,17576,-1,17377,17378,17578,17577,-1,17378,17379,17579,17578,-1,17379,17380,17580,17579,-1,17380,17381,17581,17580,-1,17381,17382,17582,17581,-1,17382,17383,17583,17582,-1,17383,17384,17584,17583,-1,17384,17385,17585,17584,-1,17385,17386,17586,17585,-1,17386,17387,17587,17586,-1,17387,17388,17588,17587,-1,17388,17389,17589,17588,-1,17389,17390,17590,17589,-1,17390,17391,17591,17590,-1,17391,17392,17592,17591,-1,17392,17393,17593,17592,-1,17393,17394,17594,17593,-1,17394,17395,17595,17594,-1,17395,17396,17596,17595,-1,17396,17397,17597,17596,-1,17397,17398,17598,17597,-1,17398,17399,17599,17598,-1,17400,17401,17601,17600,-1,17401,17402,17602,17601,-1,17402,17403,17603,17602,-1,17403,17404,17604,17603,-1,17404,17405,17605,17604,-1,17405,17406,17606,17605,-1,17406,17407,17607,17606,-1,17407,17408,17608,17607,-1,17408,17409,17609,17608,-1,17409,17410,17610,17609,-1,17410,17411,17611,17610,-1,17411,17412,17612,17611,-1,17412,17413,17613,17612,-1,17413,17414,17614,17613,-1,17414,17415,17615,17614,-1,17415,17416,17616,17615,-1,17416,17417,17617,17616,-1,17417,17418,17618,17617,-1,17418,17419,17619,17618,-1,17419,17420,17620,17619,-1,17420,17421,17621,17620,-1,17421,17422,17622,17621,-1,17422,17423,17623,17622,-1,17423,17424,17624,17623,-1,17424,17425,17625,17624,-1,17425,17426,17626,17625,-1,17426,17427,17627,17626,-1,17427,17428,17628,17627,-1,17428,17429,17629,17628,-1,17429,17430,17630,17629,-1,17430,17431,17631,17630,-1,17431,17432,17632,17631,-1,17432,17433,17633,17632,-1,17433,17434,17634,17633,-1,17434,17435,17635,17634,-1,17435,17436,17636,17635,-1,17436,17437,17637,17636,-1,17437,17438,17638,17637,-1,17438,17439,17639,17638,-1,17439,17440,17640,17639,-1,17440,17441,17641,17640,-1,17441,17442,17642,17641,-1,17442,17443,17643,17642,-1,17443,17444,17644,17643,-1,17444,17445,17645,17644,-1,17445,17446,17646,17645,-1,17446,17447,17647,17646,-1,17447,17448,17648,17647,-1,17448,17449,17649,17648,-1,17449,17450,17650,17649,-1,17450,17451,17651,17650,-1,17451,17452,17652,17651,-1,17452,17453,17653,17652,-1,17453,17454,17654,17653,-1,17454,17455,17655,17654,-1,17455,17456,17656,17655,-1,17456,17457,17657,17656,-1,17457,17458,17658,17657,-1,17458,17459,17659,17658,-1,17459,17460,17660,17659,-1,17460,17461,17661,17660,-1,17461,17462,17662,17661,-1,17462,17463,17663,17662,-1,17463,17464,17664,17663,-1,17464,17465,17665,17664,-1,17465,17466,17666,17665,-1,17466,17467,17667,17666,-1,17467,17468,17668,17667,-1,17468,17469,17669,17668,-1,17469,17470,17670,17669,-1,17470,17471,17671,17670,-1,17471,17472,17672,17671,-1,17472,17473,17673,17672,-1,17473,17474,17674,17673,-1,17474,17475,17675,17674,-1,17475,17476,17676,17675,-1,17476,17477,17677,17676,-1,17477,17478,17678,17677,-1,17478,17479,17679,17678,-1,17479,17480,17680,17679,-1,17480,17481,17681,17680,-1,17481,17482,17682,17681,-1,17482,17483,17683,17682,-1,17483,17484,17684,17683,-1,17484,17485,17685,17684,-1,17485,17486,17686,17685,-1,17486,17487,17687,17686,-1,17487,17488,17688,17687,-1,17488,17489,17689,17688,-1,17489,17490,17690,17689,-1,17490,17491,17691,17690,-1,17491,17492,17692,17691,-1,17492,17493,17693,17692,-1,17493,17494,17694,17693,-1,17494,17495,17695,17694,-1,17495,17496,17696,17695,-1,17496,17497,17697,17696,-1,17497,17498,17698,17697,-1,17498,17499,17699,17698,-1,17499,17500,17700,17699,-1,17500,17501,17701,17700,-1,17501,17502,17702,17701,-1,17502,17503,17703,17702,-1,17503,17504,17704,17703,-1,17504,17505,17705,17704,-1,17505,17506,17706,17705,-1,17506,17507,17707,17706,-1,17507,17508,17708,17707,-1,17508,17509,17709,17708,-1,17509,17510,17710,17709,-1,17510,17511,17711,17710,-1,17511,17512,17712,17711,-1,17512,17513,17713,17712,-1,17513,17514,17714,17713,-1,17514,17515,17715,17714,-1,17515,17516,17716,17715,-1,17516,17517,17717,17716,-1,17517,17518,17718,17717,-1,17518,17519,17719,17718,-1,17519,17520,17720,17719,-1,17520,17521,17721,17720,-1,17521,17522,17722,17721,-1,17522,17523,17723,17722,-1,17523,17524,17724,17723,-1,17524,17525,17725,17724,-1,17525,17526,17726,17725,-1,17526,17527,17727,17726,-1,17527,17528,17728,17727,-1,17528,17529,17729,17728,-1,17529,17530,17730,17729,-1,17530,17531,17731,17730,-1,17531,17532,17732,17731,-1,17532,17533,17733,17732,-1,17533,17534,17734,17733,-1,17534,17535,17735,17734,-1,17535,17536,17736,17735,-1,17536,17537,17737,17736,-1,17537,17538,17738,17737,-1,17538,17539,17739,17738,-1,17539,17540,17740,17739,-1,17540,17541,17741,17740,-1,17541,17542,17742,17741,-1,17542,17543,17743,17742,-1,17543,17544,17744,17743,-1,17544,17545,17745,17744,-1,17545,17546,17746,17745,-1,17546,17547,17747,17746,-1,17547,17548,17748,17747,-1,17548,17549,17749,17748,-1,17549,17550,17750,17749,-1,17550,17551,17751,17750,-1,17551,17552,17752,17751,-1,17552,17553,17753,17752,-1,17553,17554,17754,17753,-1,17554,17555,17755,17754,-1,17555,17556,17756,17755,-1,17556,17557,17757,17756,-1,17557,17558,17758,17757,-1,17558,17559,17759,17758,-1,17559,17560,17760,17759,-1,17560,17561,17761,17760,-1,17561,17562,17762,17761,-1,17562,17563,17763,17762,-1,17563,17564,17764,17763,-1,17564,17565,17765,17764,-1,17565,17566,17766,17765,-1,17566,17567,17767,17766,-1,17567,17568,17768,17767,-1,17568,17569,17769,17768,-1,17569,17570,17770,17769,-1,17570,17571,17771,17770,-1,17571,17572,17772,17771,-1,17572,17573,17773,17772,-1,17573,17574,17774,17773,-1,17574,17575,17775,17774,-1,17575,17576,17776,17775,-1,17576,17577,17777,17776,-1,17577,17578,17778,17777,-1,17578,17579,17779,17778,-1,17579,17580,17780,17779,-1,17580,17581,17781,17780,-1,17581,17582,17782,17781,-1,17582,17583,17783,17782,-1,17583,17584,17784,17783,-1,17584,17585,17785,17784,-1,17585,17586,17786,17785,-1,17586,17587,17787,17786,-1,17587,17588,17788,17787,-1,17588,17589,17789,17788,-1,17589,17590,17790,17789,-1,17590,17591,17791,17790,-1,17591,17592,17792,17791,-1,17592,17593,17793,17792,-1,17593,17594,17794,17793,-1,17594,17595,17795,17794,-1,17595,17596,17796,17795,-1,17596,17597,17797,17796,-1,17597,17598,17798,17797,-1,17598,17599,17799,17798,-1,17600,17601,17801,17800,-1,17601,17602,17802,17801,-1,17602,17603,17803,17802,-1,17603,17604,17804,17803,-1,17604,17605,17805,17804,-1,17605,17606,17806,17805,-1,17606,17607,17807,17806,-1,17607,17608,17808,17807,-1,17608,17609,17809,17808,-1,17609,17610,17810,17809,-1,17610,17611,17811,17810,-1,17611,17612,17812,17811,-1,17612,17613,17813,17812,-1,17613,17614,17814,17813,-1,17614,17615,17815,17814,-1,17615,17616,17816,17815,-1,17616,17617,17817,17816,-1,17617,17618,17818,17817,-1,17618,17619,17819,17818,-1,17619,17620,17820,17819,-1,17620,17621,17821,17820,-1,17621,17622,17822,17821,-1,17622,17623,17823,17822,-1,17623,17624,17824,17823,-1,17624,17625,17825,17824,-1,17625,17626,17826,17825,-1,17626,17627,17827,17826,-1,17627,17628,17828,17827,-1,17628,17629,17829,17828,-1,17629,17630,17830,17829,-1,17630,17631,17831,17830,-1,17631,17632,17832,17831,-1,17632,17633,17833,17832,-1,17633,17634,17834,17833,-1,17634,17635,17835,17834,-1,17635,17636,17836,17835,-1,17636,17637,17837,17836,-1,17637,17638,17838,17837,-1,17638,17639,17839,17838,-1,17639,17640,17840,17839,-1,17640,17641,17841,17840,-1,17641,17642,17842,17841,-1,17642,17643,17843,17842,-1,17643,17644,17844,17843,-1,17644,17645,17845,17844,-1,17645,17646,17846,17845,-1,17646,17647,17847,17846,-1,17647,17648,17848,17847,-1,17648,17649,17849,17848,-1,17649,17650,17850,17849,-1,17650,17651,17851,17850,-1,17651,17652,17852,17851,-1,17652,17653,17853,17852,-1,17653,17654,17854,17853,-1,17654,17655,17855,17854,-1,17655,17656,17856,17855,-1,17656,17657,17857,17856,-1,17657,17658,17858,17857,-1,17658,17659,17859,17858,-1,17659,17660,17860,17859,-1,17660,17661,17861,17860,-1,17661,17662,17862,17861,-1,17662,17663,17863,17862,-1,17663,17664,17864,17863,-1,17664,17665,17865,17864,-1,17665,17666,17866,17865,-1,17666,17667,17867,17866,-1,17667,17668,17868,17867,-1,17668,17669,17869,17868,-1,17669,17670,17870,17869,-1,17670,17671,17871,17870,-1,17671,17672,17872,17871,-1,17672,17673,17873,17872,-1,17673,17674,17874,17873,-1,17674,17675,17875,17874,-1,17675,17676,17876,17875,-1,17676,17677,17877,17876,-1,17677,17678,17878,17877,-1,17678,17679,17879,17878,-1,17679,17680,17880,17879,-1,17680,17681,17881,17880,-1,17681,17682,17882,17881,-1,17682,17683,17883,17882,-1,17683,17684,17884,17883,-1,17684,17685,17885,17884,-1,17685,17686,17886,17885,-1,17686,17687,17887,17886,-1,17687,17688,17888,17887,-1,17688,17689,17889,17888,-1,17689,17690,17890,17889,-1,17690,17691,17891,17890,-1,17691,17692,17892,17891,-1,17692,17693,17893,17892,-1,17693,17694,17894,17893,-1,17694,17695,17895,17894,-1,17695,17696,17896,17895,-1,17696,17697,17897,17896,-1,17697,17698,17898,17897,-1,17698,17699,17899,17898,-1,17699,17700,17900,17899,-1,17700,17701,17901,17900,-1,17701,17702,17902,17901,-1,17702,17703,17903,17902,-1,17703,17704,17904,17903,-1,17704,17705,17905,17904,-1,17705,17706,17906,17905,-1,17706,17707,17907,17906,-1,17707,17708,17908,17907,-1,17708,17709,17909,17908,-1,17709,17710,17910,17909,-1,17710,17711,17911,17910,-1,17711,17712,17912,17911,-1,17712,17713,17913,17912,-1,17713,17714,17914,17913,-1,17714,17715,17915,17914,-1,17715,17716,17916,17915,-1,17716,17717,17917,17916,-1,17717,17718,17918,17917,-1,17718,17719,17919,17918,-1,17719,17720,17920,17919,-1,17720,17721,17921,17920,-1,17721,17722,17922,17921,-1,17722,17723,17923,17922,-1,17723,17724,17924,17923,-1,17724,17725,17925,17924,-1,17725,17726,17926,17925,-1,17726,17727,17927,17926,-1,17727,17728,17928,17927,-1,17728,17729,17929,17928,-1,17729,17730,17930,17929,-1,17730,17731,17931,17930,-1,17731,17732,17932,17931,-1,17732,17733,17933,17932,-1,17733,17734,17934,17933,-1,17734,17735,17935,17934,-1,17735,17736,17936,17935,-1,17736,17737,17937,17936,-1,17737,17738,17938,17937,-1,17738,17739,17939,17938,-1,17739,17740,17940,17939,-1,17740,17741,17941,17940,-1,17741,17742,17942,17941,-1,17742,17743,17943,17942,-1,17743,17744,17944,17943,-1,17744,17745,17945,17944,-1,17745,17746,17946,17945,-1,17746,17747,17947,17946,-1,17747,17748,17948,17947,-1,17748,17749,17949,17948,-1,17749,17750,17950,17949,-1,17750,17751,17951,17950,-1,17751,17752,17952,17951,-1,17752,17753,17953,17952,-1,17753,17754,17954,17953,-1,17754,17755,17955,17954,-1,17755,17756,17956,17955,-1,17756,17757,17957,17956,-1,17757,17758,17958,17957,-1,17758,17759,17959,17958,-1,17759,17760,17960,17959,-1,17760,17761,17961,17960,-1,17761,17762,17962,17961,-1,17762,17763,17963,17962,-1,17763,17764,17964,17963,-1,17764,17765,17965,17964,-1,17765,17766,17966,17965,-1,17766,17767,17967,17966,-1,17767,17768,17968,17967,-1,17768,17769,17969,17968,-1,17769,17770,17970,17969,-1,17770,17771,17971,17970,-1,17771,17772,17972,17971,-1,17772,17773,17973,17972,-1,17773,17774,17974,17973,-1,17774,17775,17975,17974,-1,17775,17776,17976,17975,-1,17776,17777,17977,17976,-1,17777,17778,17978,17977,-1,17778,17779,17979,17978,-1,17779,17780,17980,17979,-1,17780,17781,17981,17980,-1,17781,17782,17982,17981,-1,17782,17783,17983,17982,-1,17783,17784,17984,17983,-1,17784,17785,17985,17984,-1,17785,17786,17986,17985,-1,17786,17787,17987,17986,-1,17787,17788,17988,17987,-1,17788,17789,17989,17988,-1,17789,17790,17990,17989,-1,17790,17791,17991,17990,-1,17791,17792,17992,17991,-1,17792,17793,17993,17992,-1,17793,17794,17994,17993,-1,17794,17795,17995,17994,-1,17795,17796,17996,17995,-1,17796,17797,17997,17996,-1,17797,17798,17998,17997,-1,17798,17799,17999,17998,-1,17800,17801,18001,18,-1,17801,17802,18002,18001,-1,17802,17803,18003,18002,-1,17803,17804,18004,18003,-1,17804,17805,18005,18004,-1,17805,17806,18006,18005,-1,17806,17807,18007,18006,-1,17807,17808,18008,18007,-1,17808,17809,18009,18008,-1,17809,17810,18010,18009,-1,17810,17811,18011,18010,-1,17811,17812,18012,18011,-1,17812,17813,18013,18012,-1,17813,17814,18014,18013,-1,17814,17815,18015,18014,-1,17815,17816,18016,18015,-1,17816,17817,18017,18016,-1,17817,17818,18018,18017,-1,17818,17819,18019,18018,-1,17819,17820,18020,18019,-1,17820,17821,18021,18020,-1,17821,17822,18022,18021,-1,17822,17823,18023,18022,-1,17823,17824,18024,18023,-1,17824,17825,18025,18024,-1,17825,17826,18026,18025,-1,17826,17827,18027,18026,-1,17827,17828,18028,18027,-1,17828,17829,18029,18028,-1,17829,17830,18030,18029,-1,17830,17831,18031,18030,-1,17831,17832,18032,18031,-1,17832,17833,18033,18032,-1,17833,17834,18034,18033,-1,17834,17835,18035,18034,-1,17835,17836,18036,18035,-1,17836,17837,18037,18036,-1,17837,17838,18038,18037,-1,17838,17839,18039,18038,-1,17839,17840,18040,18039,-1,17840,17841,18041,18040,-1,17841,17842,18042,18041,-1,17842,17843,18043,18042,-1,17843,17844,18044,18043,-1,17844,17845,18045,18044,-1,17845,17846,18046,18045,-1,17846,17847,18047,18046,-1,17847,17848,18048,18047,-1,17848,17849,18049,18048,-1,17849,17850,18050,18049,-1,17850,17851,18051,18050,-1,17851,17852,18052,18051,-1,17852,17853,18053,18052,-1,17853,17854,18054,18053,-1,17854,17855,18055,18054,-1,17855,17856,18056,18055,-1,17856,17857,18057,18056,-1,17857,17858,18058,18057,-1,17858,17859,18059,18058,-1,17859,17860,18060,18059,-1,17860,17861,18061,18060,-1,17861,17862,18062,18061,-1,17862,17863,18063,18062,-1,17863,17864,18064,18063,-1,17864,17865,18065,18064,-1,17865,17866,18066,18065,-1,17866,17867,18067,18066,-1,17867,17868,18068,18067,-1,17868,17869,18069,18068,-1,17869,17870,18070,18069,-1,17870,17871,18071,18070,-1,17871,17872,18072,18071,-1,17872,17873,18073,18072,-1,17873,17874,18074,18073,-1,17874,17875,18075,18074,-1,17875,17876,18076,18075,-1,17876,17877,18077,18076,-1,17877,17878,18078,18077,-1,17878,17879,18079,18078,-1,17879,17880,18080,18079,-1,17880,17881,18081,18080,-1,17881,17882,18082,18081,-1,17882,17883,18083,18082,-1,17883,17884,18084,18083,-1,17884,17885,18085,18084,-1,17885,17886,18086,18085,-1,17886,17887,18087,18086,-1,17887,17888,18088,18087,-1,17888,17889,18089,18088,-1,17889,17890,18090,18089,-1,17890,17891,18091,18090,-1,17891,17892,18092,18091,-1,17892,17893,18093,18092,-1,17893,17894,18094,18093,-1,17894,17895,18095,18094,-1,17895,17896,18096,18095,-1,17896,17897,18097,18096,-1,17897,17898,18098,18097,-1,17898,17899,18099,18098,-1,17899,17900,18100,18099,-1,17900,17901,18101,18100,-1,17901,17902,18102,18101,-1,17902,17903,18103,18102,-1,17903,17904,18104,18103,-1,17904,17905,18105,18104,-1,17905,17906,18106,18105,-1,17906,17907,18107,18106,-1,17907,17908,18108,18107,-1,17908,17909,18109,18108,-1,17909,17910,18110,18109,-1,17910,17911,18111,18110,-1,17911,17912,18112,18111,-1,17912,17913,18113,18112,-1,17913,17914,18114,18113,-1,17914,17915,18115,18114,-1,17915,17916,18116,18115,-1,17916,17917,18117,18116,-1,17917,17918,18118,18117,-1,17918,17919,18119,18118,-1,17919,17920,18120,18119,-1,17920,17921,18121,18120,-1,17921,17922,18122,18121,-1,17922,17923,18123,18122,-1,17923,17924,18124,18123,-1,17924,17925,18125,18124,-1,17925,17926,18126,18125,-1,17926,17927,18127,18126,-1,17927,17928,18128,18127,-1,17928,17929,18129,18128,-1,17929,17930,18130,18129,-1,17930,17931,18131,18130,-1,17931,17932,18132,18131,-1,17932,17933,18133,18132,-1,17933,17934,18134,18133,-1,17934,17935,18135,18134,-1,17935,17936,18136,18135,-1,17936,17937,18137,18136,-1,17937,17938,18138,18137,-1,17938,17939,18139,18138,-1,17939,17940,18140,18139,-1,17940,17941,18141,18140,-1,17941,17942,18142,18141,-1,17942,17943,18143,18142,-1,17943,17944,18144,18143,-1,17944,17945,18145,18144,-1,17945,17946,18146,18145,-1,17946,17947,18147,18146,-1,17947,17948,18148,18147,-1,17948,17949,18149,18148,-1,17949,17950,18150,18149,-1,17950,17951,18151,18150,-1,17951,17952,18152,18151,-1,17952,17953,18153,18152,-1,17953,17954,18154,18153,-1,17954,17955,18155,18154,-1,17955,17956,18156,18155,-1,17956,17957,18157,18156,-1,17957,17958,18158,18157,-1,17958,17959,18159,18158,-1,17959,17960,18160,18159,-1,17960,17961,18161,18160,-1,17961,17962,18162,18161,-1,17962,17963,18163,18162,-1,17963,17964,18164,18163,-1,17964,17965,18165,18164,-1,17965,17966,18166,18165,-1,17966,17967,18167,18166,-1,17967,17968,18168,18167,-1,17968,17969,18169,18168,-1,17969,17970,18170,18169,-1,17970,17971,18171,18170,-1,17971,17972,18172,18171,-1,17972,17973,18173,18172,-1,17973,17974,18174,18173,-1,17974,17975,18175,18174,-1,17975,17976,18176,18175,-1,17976,17977,18177,18176,-1,17977,17978,18178,18177,-1,17978,17979,18179,18178,-1,17979,17980,18180,18179,-1,17980,17981,18181,18180,-1,17981,17982,18182,18181,-1,17982,17983,18183,18182,-1,17983,17984,18184,18183,-1,17984,17985,18185,18184,-1,17985,17986,18186,18185,-1,17986,17987,18187,18186,-1,17987,17988,18188,18187,-1,17988,17989,18189,18188,-1,17989,17990,18190,18189,-1,17990,17991,18191,18190,-1,17991,17992,18192,18191,-1,17992,17993,18193,18192,-1,17993,17994,18194,18193,-1,17994,17995,18195,18194,-1,17995,17996,18196,18195,-1,17996,17997,18197,18196,-1,17997,17998,18198,18197,-1,17998,17999,18199,18198,-1,18,18001,18201,18200,-1,18001,18002,18202,18201,-1,18002,18003,18203,18202,-1,18003,18004,18204,18203,-1,18004,18005,18205,18204,-1,18005,18006,18206,18205,-1,18006,18007,18207,18206,-1,18007,18008,18208,18207,-1,18008,18009,18209,18208,-1,18009,18010,18210,18209,-1,18010,18011,18211,18210,-1,18011,18012,18212,18211,-1,18012,18013,18213,18212,-1,18013,18014,18214,18213,-1,18014,18015,18215,18214,-1,18015,18016,18216,18215,-1,18016,18017,18217,18216,-1,18017,18018,18218,18217,-1,18018,18019,18219,18218,-1,18019,18020,18220,18219,-1,18020,18021,18221,18220,-1,18021,18022,18222,18221,-1,18022,18023,18223,18222,-1,18023,18024,18224,18223,-1,18024,18025,18225,18224,-1,18025,18026,18226,18225,-1,18026,18027,18227,18226,-1,18027,18028,18228,18227,-1,18028,18029,18229,18228,-1,18029,18030,18230,18229,-1,18030,18031,18231,18230,-1,18031,18032,18232,18231,-1,18032,18033,18233,18232,-1,18033,18034,18234,18233,-1,18034,18035,18235,18234,-1,18035,18036,18236,18235,-1,18036,18037,18237,18236,-1,18037,18038,18238,18237,-1,18038,18039,18239,18238,-1,18039,18040,18240,18239,-1,18040,18041,18241,18240,-1,18041,18042,18242,18241,-1,18042,18043,18243,18242,-1,18043,18044,18244,18243,-1,18044,18045,18245,18244,-1,18045,18046,18246,18245,-1,18046,18047,18247,18246,-1,18047,18048,18248,18247,-1,18048,18049,18249,18248,-1,18049,18050,18250,18249,-1,18050,18051,18251,18250,-1,18051,18052,18252,18251,-1,18052,18053,18253,18252,-1,18053,18054,18254,18253,-1,18054,18055,18255,18254,-1,18055,18056,18256,18255,-1,18056,18057,18257,18256,-1,18057,18058,18258,18257,-1,18058,18059,18259,18258,-1,18059,18060,18260,18259,-1,18060,18061,18261,18260,-1,18061,18062,18262,18261,-1,18062,18063,18263,18262,-1,18063,18064,18264,18263,-1,18064,18065,18265,18264,-1,18065,18066,18266,18265,-1,18066,18067,18267,18266,-1,18067,18068,18268,18267,-1,18068,18069,18269,18268,-1,18069,18070,18270,18269,-1,18070,18071,18271,18270,-1,18071,18072,18272,18271,-1,18072,18073,18273,18272,-1,18073,18074,18274,18273,-1,18074,18075,18275,18274,-1,18075,18076,18276,18275,-1,18076,18077,18277,18276,-1,18077,18078,18278,18277,-1,18078,18079,18279,18278,-1,18079,18080,18280,18279,-1,18080,18081,18281,18280,-1,18081,18082,18282,18281,-1,18082,18083,18283,18282,-1,18083,18084,18284,18283,-1,18084,18085,18285,18284,-1,18085,18086,18286,18285,-1,18086,18087,18287,18286,-1,18087,18088,18288,18287,-1,18088,18089,18289,18288,-1,18089,18090,18290,18289,-1,18090,18091,18291,18290,-1,18091,18092,18292,18291,-1,18092,18093,18293,18292,-1,18093,18094,18294,18293,-1,18094,18095,18295,18294,-1,18095,18096,18296,18295,-1,18096,18097,18297,18296,-1,18097,18098,18298,18297,-1,18098,18099,18299,18298,-1,18099,18100,18300,18299,-1,18100,18101,18301,18300,-1,18101,18102,18302,18301,-1,18102,18103,18303,18302,-1,18103,18104,18304,18303,-1,18104,18105,18305,18304,-1,18105,18106,18306,18305,-1,18106,18107,18307,18306,-1,18107,18108,18308,18307,-1,18108,18109,18309,18308,-1,18109,18110,18310,18309,-1,18110,18111,18311,18310,-1,18111,18112,18312,18311,-1,18112,18113,18313,18312,-1,18113,18114,18314,18313,-1,18114,18115,18315,18314,-1,18115,18116,18316,18315,-1,18116,18117,18317,18316,-1,18117,18118,18318,18317,-1,18118,18119,18319,18318,-1,18119,18120,18320,18319,-1,18120,18121,18321,18320,-1,18121,18122,18322,18321,-1,18122,18123,18323,18322,-1,18123,18124,18324,18323,-1,18124,18125,18325,18324,-1,18125,18126,18326,18325,-1,18126,18127,18327,18326,-1,18127,18128,18328,18327,-1,18128,18129,18329,18328,-1,18129,18130,18330,18329,-1,18130,18131,18331,18330,-1,18131,18132,18332,18331,-1,18132,18133,18333,18332,-1,18133,18134,18334,18333,-1,18134,18135,18335,18334,-1,18135,18136,18336,18335,-1,18136,18137,18337,18336,-1,18137,18138,18338,18337,-1,18138,18139,18339,18338,-1,18139,18140,18340,18339,-1,18140,18141,18341,18340,-1,18141,18142,18342,18341,-1,18142,18143,18343,18342,-1,18143,18144,18344,18343,-1,18144,18145,18345,18344,-1,18145,18146,18346,18345,-1,18146,18147,18347,18346,-1,18147,18148,18348,18347,-1,18148,18149,18349,18348,-1,18149,18150,18350,18349,-1,18150,18151,18351,18350,-1,18151,18152,18352,18351,-1,18152,18153,18353,18352,-1,18153,18154,18354,18353,-1,18154,18155,18355,18354,-1,18155,18156,18356,18355,-1,18156,18157,18357,18356,-1,18157,18158,18358,18357,-1,18158,18159,18359,18358,-1,18159,18160,18360,18359,-1,18160,18161,18361,18360,-1,18161,18162,18362,18361,-1,18162,18163,18363,18362,-1,18163,18164,18364,18363,-1,18164,18165,18365,18364,-1,18165,18166,18366,18365,-1,18166,18167,18367,18366,-1,18167,18168,18368,18367,-1,18168,18169,18369,18368,-1,18169,18170,18370,18369,-1,18170,18171,18371,18370,-1,18171,18172,18372,18371,-1,18172,18173,18373,18372,-1,18173,18174,18374,18373,-1,18174,18175,18375,18374,-1,18175,18176,18376,18375,-1,18176,18177,18377,18376,-1,18177,18178,18378,18377,-1,18178,18179,18379,18378,-1,18179,18180,18380,18379,-1,18180,18181,18381,18380,-1,18181,18182,18382,18381,-1,18182,18183,18383,18382,-1,18183,18184,18384,18383,-1,18184,18185,18385,18384,-1,18185,18186,18386,18385,-1,18186,18187,18387,18386,-1,18187,18188,18388,18387,-1,18188,18189,18389,18388,-1,18189,18190,18390,18389,-1,18190,18191,18391,18390,-1,18191,18192,18392,18391,-1,18192,18193,18393,18392,-1,18193,18194,18394,18393,-1,18194,18195,18395,18394,-1,18195,18196,18396,18395,-1,18196,18197,18397,18396,-1,18197,18198,18398,18397,-1,18198,18199,18399,18398,-1,18200,18201,18401,18400,-1,18201,18202,18402,18401,-1,18202,18203,18403,18402,-1,18203,18204,18404,18403,-1,18204,18205,18405,18404,-1,18205,18206,18406,18405,-1,18206,18207,18407,18406,-1,18207,18208,18408,18407,-1,18208,18209,18409,18408,-1,18209,18210,18410,18409,-1,18210,18211,18411,18410,-1,18211,18212,18412,18411,-1,18212,18213,18413,18412,-1,18213,18214,18414,18413,-1,18214,18215,18415,18414,-1,18215,18216,18416,18415,-1,18216,18217,18417,18416,-1,18217,18218,18418,18417,-1,18218,18219,18419,18418,-1,18219,18220,18420,18419,-1,18220,18221,18421,18420,-1,18221,18222,18422,18421,-1,18222,18223,18423,18422,-1,18223,18224,18424,18423,-1,18224,18225,18425,18424,-1,18225,18226,18426,18425,-1,18226,18227,18427,18426,-1,18227,18228,18428,18427,-1,18228,18229,18429,18428,-1,18229,18230,18430,18429,-1,18230,18231,18431,18430,-1,18231,18232,18432,18431,-1,18232,18233,18433,18432,-1,18233,18234,18434,18433,-1,18234,18235,18435,18434,-1,18235,18236,18436,18435,-1,18236,18237,18437,18436,-1,18237,18238,18438,18437,-1,18238,18239,18439,18438,-1,18239,18240,18440,18439,-1,18240,18241,18441,18440,-1,18241,18242,18442,18441,-1,18242,18243,18443,18442,-1,18243,18244,18444,18443,-1,18244,18245,18445,18444,-1,18245,18246,18446,18445,-1,18246,18247,18447,18446,-1,18247,18248,18448,18447,-1,18248,18249,18449,18448,-1,18249,18250,18450,18449,-1,18250,18251,18451,18450,-1,18251,18252,18452,18451,-1,18252,18253,18453,18452,-1,18253,18254,18454,18453,-1,18254,18255,18455,18454,-1,18255,18256,18456,18455,-1,18256,18257,18457,18456,-1,18257,18258,18458,18457,-1,18258,18259,18459,18458,-1,18259,18260,18460,18459,-1,18260,18261,18461,18460,-1,18261,18262,18462,18461,-1,18262,18263,18463,18462,-1,18263,18264,18464,18463,-1,18264,18265,18465,18464,-1,18265,18266,18466,18465,-1,18266,18267,18467,18466,-1,18267,18268,18468,18467,-1,18268,18269,18469,18468,-1,18269,18270,18470,18469,-1,18270,18271,18471,18470,-1,18271,18272,18472,18471,-1,18272,18273,18473,18472,-1,18273,18274,18474,18473,-1,18274,18275,18475,18474,-1,18275,18276,18476,18475,-1,18276,18277,18477,18476,-1,18277,18278,18478,18477,-1,18278,18279,18479,18478,-1,18279,18280,18480,18479,-1,18280,18281,18481,18480,-1,18281,18282,18482,18481,-1,18282,18283,18483,18482,-1,18283,18284,18484,18483,-1,18284,18285,18485,18484,-1,18285,18286,18486,18485,-1,18286,18287,18487,18486,-1,18287,18288,18488,18487,-1,18288,18289,18489,18488,-1,18289,18290,18490,18489,-1,18290,18291,18491,18490,-1,18291,18292,18492,18491,-1,18292,18293,18493,18492,-1,18293,18294,18494,18493,-1,18294,18295,18495,18494,-1,18295,18296,18496,18495,-1,18296,18297,18497,18496,-1,18297,18298,18498,18497,-1,18298,18299,18499,18498,-1,18299,18300,18500,18499,-1,18300,18301,18501,18500,-1,18301,18302,18502,18501,-1,18302,18303,18503,18502,-1,18303,18304,18504,18503,-1,18304,18305,18505,18504,-1,18305,18306,18506,18505,-1,18306,18307,18507,18506,-1,18307,18308,18508,18507,-1,18308,18309,18509,18508,-1,18309,18310,18510,18509,-1,18310,18311,18511,18510,-1,18311,18312,18512,18511,-1,18312,18313,18513,18512,-1,18313,18314,18514,18513,-1,18314,18315,18515,18514,-1,18315,18316,18516,18515,-1,18316,18317,18517,18516,-1,18317,18318,18518,18517,-1,18318,18319,18519,18518,-1,18319,18320,18520,18519,-1,18320,18321,18521,18520,-1,18321,18322,18522,18521,-1,18322,18323,18523,18522,-1,18323,18324,18524,18523,-1,18324,18325,18525,18524,-1,18325,18326,18526,18525,-1,18326,18327,18527,18526,-1,18327,18328,18528,18527,-1,18328,18329,18529,18528,-1,18329,18330,18530,18529,-1,18330,18331,18531,18530,-1,18331,18332,18532,18531,-1,18332,18333,18533,18532,-1,18333,18334,18534,18533,-1,18334,18335,18535,18534,-1,18335,18336,18536,18535,-1,18336,18337,18537,18536,-1,18337,18338,18538,18537,-1,18338,18339,18539,18538,-1,18339,18340,18540,18539,-1,18340,18341,18541,18540,-1,18341,18342,18542,18541,-1,18342,18343,18543,18542,-1,18343,18344,18544,18543,-1,18344,18345,18545,18544,-1,18345,18346,18546,18545,-1,18346,18347,18547,18546,-1,18347,18348,18548,18547,-1,18348,18349,18549,18548,-1,18349,18350,18550,18549,-1,18350,18351,18551,18550,-1,18351,18352,18552,18551,-1,18352,18353,18553,18552,-1,18353,18354,18554,18553,-1,18354,18355,18555,18554,-1,18355,18356,18556,18555,-1,18356,18357,18557,18556,-1,18357,18358,18558,18557,-1,18358,18359,18559,18558,-1,18359,18360,18560,18559,-1,18360,18361,18561,18560,-1,18361,18362,18562,18561,-1,18362,18363,18563,18562,-1,18363,18364,18564,18563,-1,18364,18365,18565,18564,-1,18365,18366,18566,18565,-1,18366,18367,18567,18566,-1,18367,18368,18568,18567,-1,18368,18369,18569,18568,-1,18369,18370,18570,18569,-1,18370,18371,18571,18570,-1,18371,18372,18572,18571,-1,18372,18373,18573,18572,-1,18373,18374,18574,18573,-1,18374,18375,18575,18574,-1,18375,18376,18576,18575,-1,18376,18377,18577,18576,-1,18377,18378,18578,18577,-1,18378,18379,18579,18578,-1,18379,18380,18580,18579,-1,18380,18381,18581,18580,-1,18381,18382,18582,18581,-1,18382,18383,18583,18582,-1,18383,18384,18584,18583,-1,18384,18385,18585,18584,-1,18385,18386,18586,18585,-1,18386,18387,18587,18586,-1,18387,18388,18588,18587,-1,18388,18389,18589,18588,-1,18389,18390,18590,18589,-1,18390,18391,18591,18590,-1,18391,18392,18592,18591,-1,18392,18393,18593,18592,-1,18393,18394,18594,18593,-1,18394,18395,18595,18594,-1,18395,18396,18596,18595,-1,18396,18397,18597,18596,-1,18397,18398,18598,18597,-1,18398,18399,18599,18598,-1,18400,18401,18601,18600,-1,18401,18402,18602,18601,-1,18402,18403,18603,18602,-1,18403,18404,18604,18603,-1,18404,18405,18605,18604,-1,18405,18406,18606,18605,-1,18406,18407,18607,18606,-1,18407,18408,18608,18607,-1,18408,18409,18609,18608,-1,18409,18410,18610,18609,-1,18410,18411,18611,18610,-1,18411,18412,18612,18611,-1,18412,18413,18613,18612,-1,18413,18414,18614,18613,-1,18414,18415,18615,18614,-1,18415,18416,18616,18615,-1,18416,18417,18617,18616,-1,18417,18418,18618,18617,-1,18418,18419,18619,18618,-1,18419,18420,18620,18619,-1,18420,18421,18621,18620,-1,18421,18422,18622,18621,-1,18422,18423,18623,18622,-1,18423,18424,18624,18623,-1,18424,18425,18625,18624,-1,18425,18426,18626,18625,-1,18426,18427,18627,18626,-1,18427,18428,18628,18627,-1,18428,18429,18629,18628,-1,18429,18430,18630,18629,-1,18430,18431,18631,18630,-1,18431,18432,18632,18631,-1,18432,18433,18633,18632,-1,18433,18434,18634,18633,-1,18434,18435,18635,18634,-1,18435,18436,18636,18635,-1,18436,18437,18637,18636,-1,18437,18438,18638,18637,-1,18438,18439,18639,18638,-1,18439,18440,18640,18639,-1,18440,18441,18641,18640,-1,18441,18442,18642,18641,-1,18442,18443,18643,18642,-1,18443,18444,18644,18643,-1,18444,18445,18645,18644,-1,18445,18446,18646,18645,-1,18446,18447,18647,18646,-1,18447,18448,18648,18647,-1,18448,18449,18649,18648,-1,18449,18450,18650,18649,-1,18450,18451,18651,18650,-1,18451,18452,18652,18651,-1,18452,18453,18653,18652,-1,18453,18454,18654,18653,-1,18454,18455,18655,18654,-1,18455,18456,18656,18655,-1,18456,18457,18657,18656,-1,18457,18458,18658,18657,-1,18458,18459,18659,18658,-1,18459,18460,18660,18659,-1,18460,18461,18661,18660,-1,18461,18462,18662,18661,-1,18462,18463,18663,18662,-1,18463,18464,18664,18663,-1,18464,18465,18665,18664,-1,18465,18466,18666,18665,-1,18466,18467,18667,18666,-1,18467,18468,18668,18667,-1,18468,18469,18669,18668,-1,18469,18470,18670,18669,-1,18470,18471,18671,18670,-1,18471,18472,18672,18671,-1,18472,18473,18673,18672,-1,18473,18474,18674,18673,-1,18474,18475,18675,18674,-1,18475,18476,18676,18675,-1,18476,18477,18677,18676,-1,18477,18478,18678,18677,-1,18478,18479,18679,18678,-1,18479,18480,18680,18679,-1,18480,18481,18681,18680,-1,18481,18482,18682,18681,-1,18482,18483,18683,18682,-1,18483,18484,18684,18683,-1,18484,18485,18685,18684,-1,18485,18486,18686,18685,-1,18486,18487,18687,18686,-1,18487,18488,18688,18687,-1,18488,18489,18689,18688,-1,18489,18490,18690,18689,-1,18490,18491,18691,18690,-1,18491,18492,18692,18691,-1,18492,18493,18693,18692,-1,18493,18494,18694,18693,-1,18494,18495,18695,18694,-1,18495,18496,18696,18695,-1,18496,18497,18697,18696,-1,18497,18498,18698,18697,-1,18498,18499,18699,18698,-1,18499,18500,18700,18699,-1,18500,18501,18701,18700,-1,18501,18502,18702,18701,-1,18502,18503,18703,18702,-1,18503,18504,18704,18703,-1,18504,18505,18705,18704,-1,18505,18506,18706,18705,-1,18506,18507,18707,18706,-1,18507,18508,18708,18707,-1,18508,18509,18709,18708,-1,18509,18510,18710,18709,-1,18510,18511,18711,18710,-1,18511,18512,18712,18711,-1,18512,18513,18713,18712,-1,18513,18514,18714,18713,-1,18514,18515,18715,18714,-1,18515,18516,18716,18715,-1,18516,18517,18717,18716,-1,18517,18518,18718,18717,-1,18518,18519,18719,18718,-1,18519,18520,18720,18719,-1,18520,18521,18721,18720,-1,18521,18522,18722,18721,-1,18522,18523,18723,18722,-1,18523,18524,18724,18723,-1,18524,18525,18725,18724,-1,18525,18526,18726,18725,-1,18526,18527,18727,18726,-1,18527,18528,18728,18727,-1,18528,18529,18729,18728,-1,18529,18530,18730,18729,-1,18530,18531,18731,18730,-1,18531,18532,18732,18731,-1,18532,18533,18733,18732,-1,18533,18534,18734,18733,-1,18534,18535,18735,18734,-1,18535,18536,18736,18735,-1,18536,18537,18737,18736,-1,18537,18538,18738,18737,-1,18538,18539,18739,18738,-1,18539,18540,18740,18739,-1,18540,18541,18741,18740,-1,18541,18542,18742,18741,-1,18542,18543,18743,18742,-1,18543,18544,18744,18743,-1,18544,18545,18745,18744,-1,18545,18546,18746,18745,-1,18546,18547,18747,18746,-1,18547,18548,18748,18747,-1,18548,18549,18749,18748,-1,18549,18550,18750,18749,-1,18550,18551,18751,18750,-1,18551,18552,18752,18751,-1,18552,18553,18753,18752,-1,18553,18554,18754,18753,-1,18554,18555,18755,18754,-1,18555,18556,18756,18755,-1,18556,18557,18757,18756,-1,18557,18558,18758,18757,-1,18558,18559,18759,18758,-1,18559,18560,18760,18759,-1,18560,18561,18761,18760,-1,18561,18562,18762,18761,-1,18562,18563,18763,18762,-1,18563,18564,18764,18763,-1,18564,18565,18765,18764,-1,18565,18566,18766,18765,-1,18566,18567,18767,18766,-1,18567,18568,18768,18767,-1,18568,18569,18769,18768,-1,18569,18570,18770,18769,-1,18570,18571,18771,18770,-1,18571,18572,18772,18771,-1,18572,18573,18773,18772,-1,18573,18574,18774,18773,-1,18574,18575,18775,18774,-1,18575,18576,18776,18775,-1,18576,18577,18777,18776,-1,18577,18578,18778,18777,-1,18578,18579,18779,18778,-1,18579,18580,18780,18779,-1,18580,18581,18781,18780,-1,18581,18582,18782,18781,-1,18582,18583,18783,18782,-1,18583,18584,18784,18783,-1,18584,18585,18785,18784,-1,18585,18586,18786,18785,-1,18586,18587,18787,18786,-1,18587,18588,18788,18787,-1,18588,18589,18789,18788,-1,18589,18590,18790,18789,-1,18590,18591,18791,18790,-1,18591,18592,18792,18791,-1,18592,18593,18793,18792,-1,18593,18594,18794,18793,-1,18594,18595,18795,18794,-1,18595,18596,18796,18795,-1,18596,18597,18797,18796,-1,18597,18598,18798,18797,-1,18598,18599,18799,18798,-1,18600,18601,18801,18800,-1,18601,18602,18802,18801,-1,18602,18603,18803,18802,-1,18603,18604,18804,18803,-1,18604,18605,18805,18804,-1,18605,18606,18806,18805,-1,18606,18607,18807,18806,-1,18607,18608,18808,18807,-1,18608,18609,18809,18808,-1,18609,18610,18810,18809,-1,18610,18611,18811,18810,-1,18611,18612,18812,18811,-1,18612,18613,18813,18812,-1,18613,18614,18814,18813,-1,18614,18615,18815,18814,-1,18615,18616,18816,18815,-1,18616,18617,18817,18816,-1,18617,18618,18818,18817,-1,18618,18619,18819,18818,-1,18619,18620,18820,18819,-1,18620,18621,18821,18820,-1,18621,18622,18822,18821,-1,18622,18623,18823,18822,-1,18623,18624,18824,18823,-1,18624,18625,18825,18824,-1,18625,18626,18826,18825,-1,18626,18627,18827,18826,-1,18627,18628,18828,18827,-1,18628,18629,18829,18828,-1,18629,18630,18830,18829,-1,18630,18631,18831,18830,-1,18631,18632,18832,18831,-1,18632,18633,18833,18832,-1,18633,18634,18834,18833,-1,18634,18635,18835,18834,-1,18635,18636,18836,18835,-1,18636,18637,18837,18836,-1,18637,18638,18838,18837,-1,18638,18639,18839,18838,-1,18639,18640,18840,18839,-1,18640,18641,18841,18840,-1,18641,18642,18842,18841,-1,18642,18643,18843,18842,-1,18643,18644,18844,18843,-1,18644,18645,18845,18844,-1,18645,18646,18846,18845,-1,18646,18647,18847,18846,-1,18647,18648,18848,18847,-1,18648,18649,18849,18848,-1,18649,18650,18850,18849,-1,18650,18651,18851,18850,-1,18651,18652,18852,18851,-1,18652,18653,18853,18852,-1,18653,18654,18854,18853,-1,18654,18655,18855,18854,-1,18655,18656,18856,18855,-1,18656,18657,18857,18856,-1,18657,18658,18858,18857,-1,18658,18659,18859,18858,-1,18659,18660,18860,18859,-1,18660,18661,18861,18860,-1,18661,18662,18862,18861,-1,18662,18663,18863,18862,-1,18663,18664,18864,18863,-1,18664,18665,18865,18864,-1,18665,18666,18866,18865,-1,18666,18667,18867,18866,-1,18667,18668,18868,18867,-1,18668,18669,18869,18868,-1,18669,18670,18870,18869,-1,18670,18671,18871,18870,-1,18671,18672,18872,18871,-1,18672,18673,18873,18872,-1,18673,18674,18874,18873,-1,18674,18675,18875,18874,-1,18675,18676,18876,18875,-1,18676,18677,18877,18876,-1,18677,18678,18878,18877,-1,18678,18679,18879,18878,-1,18679,18680,18880,18879,-1,18680,18681,18881,18880,-1,18681,18682,18882,18881,-1,18682,18683,18883,18882,-1,18683,18684,18884,18883,-1,18684,18685,18885,18884,-1,18685,18686,18886,18885,-1,18686,18687,18887,18886,-1,18687,18688,18888,18887,-1,18688,18689,18889,18888,-1,18689,18690,18890,18889,-1,18690,18691,18891,18890,-1,18691,18692,18892,18891,-1,18692,18693,18893,18892,-1,18693,18694,18894,18893,-1,18694,18695,18895,18894,-1,18695,18696,18896,18895,-1,18696,18697,18897,18896,-1,18697,18698,18898,18897,-1,18698,18699,18899,18898,-1,18699,18700,18900,18899,-1,18700,18701,18901,18900,-1,18701,18702,18902,18901,-1,18702,18703,18903,18902,-1,18703,18704,18904,18903,-1,18704,18705,18905,18904,-1,18705,18706,18906,18905,-1,18706,18707,18907,18906,-1,18707,18708,18908,18907,-1,18708,18709,18909,18908,-1,18709,18710,18910,18909,-1,18710,18711,18911,18910,-1,18711,18712,18912,18911,-1,18712,18713,18913,18912,-1,18713,18714,18914,18913,-1,18714,18715,18915,18914,-1,18715,18716,18916,18915,-1,18716,18717,18917,18916,-1,18717,18718,18918,18917,-1,18718,18719,18919,18918,-1,18719,18720,18920,18919,-1,18720,18721,18921,18920,-1,18721,18722,18922,18921,-1,18722,18723,18923,18922,-1,18723,18724,18924,18923,-1,18724,18725,18925,18924,-1,18725,18726,18926,18925,-1,18726,18727,18927,18926,-1,18727,18728,18928,18927,-1,18728,18729,18929,18928,-1,18729,18730,18930,18929,-1,18730,18731,18931,18930,-1,18731,18732,18932,18931,-1,18732,18733,18933,18932,-1,18733,18734,18934,18933,-1,18734,18735,18935,18934,-1,18735,18736,18936,18935,-1,18736,18737,18937,18936,-1,18737,18738,18938,18937,-1,18738,18739,18939,18938,-1,18739,18740,18940,18939,-1,18740,18741,18941,18940,-1,18741,18742,18942,18941,-1,18742,18743,18943,18942,-1,18743,18744,18944,18943,-1,18744,18745,18945,18944,-1,18745,18746,18946,18945,-1,18746,18747,18947,18946,-1,18747,18748,18948,18947,-1,18748,18749,18949,18948,-1,18749,18750,18950,18949,-1,18750,18751,18951,18950,-1,18751,18752,18952,18951,-1,18752,18753,18953,18952,-1,18753,18754,18954,18953,-1,18754,18755,18955,18954,-1,18755,18756,18956,18955,-1,18756,18757,18957,18956,-1,18757,18758,18958,18957,-1,18758,18759,18959,18958,-1,18759,18760,18960,18959,-1,18760,18761,18961,18960,-1,18761,18762,18962,18961,-1,18762,18763,18963,18962,-1,18763,18764,18964,18963,-1,18764,18765,18965,18964,-1,18765,18766,18966,18965,-1,18766,18767,18967,18966,-1,18767,18768,18968,18967,-1,18768,18769,18969,18968,-1,18769,18770,18970,18969,-1,18770,18771,18971,18970,-1,18771,18772,18972,18971,-1,18772,18773,18973,18972,-1,18773,18774,18974,18973,-1,18774,18775,18975,18974,-1,18775,18776,18976,18975,-1,18776,18777,18977,18976,-1,18777,18778,18978,18977,-1,18778,18779,18979,18978,-1,18779,18780,18980,18979,-1,18780,18781,18981,18980,-1,18781,18782,18982,18981,-1,18782,18783,18983,18982,-1,18783,18784,18984,18983,-1,18784,18785,18985,18984,-1,18785,18786,18986,18985,-1,18786,18787,18987,18986,-1,18787,18788,18988,18987,-1,18788,18789,18989,18988,-1,18789,18790,18990,18989,-1,18790,18791,18991,18990,-1,18791,18792,18992,18991,-1,18792,18793,18993,18992,-1,18793,18794,18994,18993,-1,18794,18795,18995,18994,-1,18795,18796,18996,18995,-1,18796,18797,18997,18996,-1,18797,18798,18998,18997,-1,18798,18799,18999,18998,-1,18800,18801,19001,19,-1,18801,18802,19002,19001,-1,18802,18803,19003,19002,-1,18803,18804,19004,19003,-1,18804,18805,19005,19004,-1,18805,18806,19006,19005,-1,18806,18807,19007,19006,-1,18807,18808,19008,19007,-1,18808,18809,19009,19008,-1,18809,18810,19010,19009,-1,18810,18811,19011,19010,-1,18811,18812,19012,19011,-1,18812,18813,19013,19012,-1,18813,18814,19014,19013,-1,18814,18815,19015,19014,-1,18815,18816,19016,19015,-1,18816,18817,19017,19016,-1,18817,18818,19018,19017,-1,18818,18819,19019,19018,-1,18819,18820,19020,19019,-1,18820,18821,19021,19020,-1,18821,18822,19022,19021,-1,18822,18823,19023,19022,-1,18823,18824,19024,19023,-1,18824,18825,19025,19024,-1,18825,18826,19026,19025,-1,18826,18827,19027,19026,-1,18827,18828,19028,19027,-1,18828,18829,19029,19028,-1,18829,18830,19030,19029,-1,18830,18831,19031,19030,-1,18831,18832,19032,19031,-1,18832,18833,19033,19032,-1,18833,18834,19034,19033,-1,18834,18835,19035,19034,-1,18835,18836,19036,19035,-1,18836,18837,19037,19036,-1,18837,18838,19038,19037,-1,18838,18839,19039,19038,-1,18839,18840,19040,19039,-1,18840,18841,19041,19040,-1,18841,18842,19042,19041,-1,18842,18843,19043,19042,-1,18843,18844,19044,19043,-1,18844,18845,19045,19044,-1,18845,18846,19046,19045,-1,18846,18847,19047,19046,-1,18847,18848,19048,19047,-1,18848,18849,19049,19048,-1,18849,18850,19050,19049,-1,18850,18851,19051,19050,-1,18851,18852,19052,19051,-1,18852,18853,19053,19052,-1,18853,18854,19054,19053,-1,18854,18855,19055,19054,-1,18855,18856,19056,19055,-1,18856,18857,19057,19056,-1,18857,18858,19058,19057,-1,18858,18859,19059,19058,-1,18859,18860,19060,19059,-1,18860,18861,19061,19060,-1,18861,18862,19062,19061,-1,18862,18863,19063,19062,-1,18863,18864,19064,19063,-1,18864,18865,19065,19064,-1,18865,18866,19066,19065,-1,18866,18867,19067,19066,-1,18867,18868,19068,19067,-1,18868,18869,19069,19068,-1,18869,18870,19070,19069,-1,18870,18871,19071,19070,-1,18871,18872,19072,19071,-1,18872,18873,19073,19072,-1,18873,18874,19074,19073,-1,18874,18875,19075,19074,-1,18875,18876,19076,19075,-1,18876,18877,19077,19076,-1,18877,18878,19078,19077,-1,18878,18879,19079,19078,-1,18879,18880,19080,19079,-1,18880,18881,19081,19080,-1,18881,18882,19082,19081,-1,18882,18883,19083,19082,-1,18883,18884,19084,19083,-1,18884,18885,19085,19084,-1,18885,18886,19086,19085,-1,18886,18887,19087,19086,-1,18887,18888,19088,19087,-1,18888,18889,19089,19088,-1,18889,18890,19090,19089,-1,18890,18891,19091,19090,-1,18891,18892,19092,19091,-1,18892,18893,19093,19092,-1,18893,18894,19094,19093,-1,18894,18895,19095,19094,-1,18895,18896,19096,19095,-1,18896,18897,19097,19096,-1,18897,18898,19098,19097,-1,18898,18899,19099,19098,-1,18899,18900,19100,19099,-1,18900,18901,19101,19100,-1,18901,18902,19102,19101,-1,18902,18903,19103,19102,-1,18903,18904,19104,19103,-1,18904,18905,19105,19104,-1,18905,18906,19106,19105,-1,18906,18907,19107,19106,-1,18907,18908,19108,19107,-1,18908,18909,19109,19108,-1,18909,18910,19110,19109,-1,18910,18911,19111,19110,-1,18911,18912,19112,19111,-1,18912,18913,19113,19112,-1,18913,18914,19114,19113,-1,18914,18915,19115,19114,-1,18915,18916,19116,19115,-1,18916,18917,19117,19116,-1,18917,18918,19118,19117,-1,18918,18919,19119,19118,-1,18919,18920,19120,19119,-1,18920,18921,19121,19120,-1,18921,18922,19122,19121,-1,18922,18923,19123,19122,-1,18923,18924,19124,19123,-1,18924,18925,19125,19124,-1,18925,18926,19126,19125,-1,18926,18927,19127,19126,-1,18927,18928,19128,19127,-1,18928,18929,19129,19128,-1,18929,18930,19130,19129,-1,18930,18931,19131,19130,-1,18931,18932,19132,19131,-1,18932,18933,19133,19132,-1,18933,18934,19134,19133,-1,18934,18935,19135,19134,-1,18935,18936,19136,19135,-1,18936,18937,19137,19136,-1,18937,18938,19138,19137,-1,18938,18939,19139,19138,-1,18939,18940,19140,19139,-1,18940,18941,19141,19140,-1,18941,18942,19142,19141,-1,18942,18943,19143,19142,-1,18943,18944,19144,19143,-1,18944,18945,19145,19144,-1,18945,18946,19146,19145,-1,18946,18947,19147,19146,-1,18947,18948,19148,19147,-1,18948,18949,19149,19148,-1,18949,18950,19150,19149,-1,18950,18951,19151,19150,-1,18951,18952,19152,19151,-1,18952,18953,19153,19152,-1,18953,18954,19154,19153,-1,18954,18955,19155,19154,-1,18955,18956,19156,19155,-1,18956,18957,19157,19156,-1,18957,18958,19158,19157,-1,18958,18959,19159,19158,-1,18959,18960,19160,19159,-1,18960,18961,19161,19160,-1,18961,18962,19162,19161,-1,18962,18963,19163,19162,-1,18963,18964,19164,19163,-1,18964,18965,19165,19164,-1,18965,18966,19166,19165,-1,18966,18967,19167,19166,-1,18967,18968,19168,19167,-1,18968,18969,19169,19168,-1,18969,18970,19170,19169,-1,18970,18971,19171,19170,-1,18971,18972,19172,19171,-1,18972,18973,19173,19172,-1,18973,18974,19174,19173,-1,18974,18975,19175,19174,-1,18975,18976,19176,19175,-1,18976,18977,19177,19176,-1,18977,18978,19178,19177,-1,18978,18979,19179,19178,-1,18979,18980,19180,19179,-1,18980,18981,19181,19180,-1,18981,18982,19182,19181,-1,18982,18983,19183,19182,-1,18983,18984,19184,19183,-1,18984,18985,19185,19184,-1,18985,18986,19186,19185,-1,18986,18987,19187,19186,-1,18987,18988,19188,19187,-1,18988,18989,19189,19188,-1,18989,18990,19190,19189,-1,18990,18991,19191,19190,-1,18991,18992,19192,19191,-1,18992,18993,19193,19192,-1,18993,18994,19194,19193,-1,18994,18995,19195,19194,-1,18995,18996,19196,19195,-1,18996,18997,19197,19196,-1,18997,18998,19198,19197,-1,18998,18999,19199,19198,-1,19,19001,19201,19200,-1,19001,19002,19202,19201,-1,19002,19003,19203,19202,-1,19003,19004,19204,19203,-1,19004,19005,19205,19204,-1,19005,19006,19206,19205,-1,19006,19007,19207,19206,-1,19007,19008,19208,19207,-1,19008,19009,19209,19208,-1,19009,19010,19210,19209,-1,19010,19011,19211,19210,-1,19011,19012,19212,19211,-1,19012,19013,19213,19212,-1,19013,19014,19214,19213,-1,19014,19015,19215,19214,-1,19015,19016,19216,19215,-1,19016,19017,19217,19216,-1,19017,19018,19218,19217,-1,19018,19019,19219,19218,-1,19019,19020,19220,19219,-1,19020,19021,19221,19220,-1,19021,19022,19222,19221,-1,19022,19023,19223,19222,-1,19023,19024,19224,19223,-1,19024,19025,19225,19224,-1,19025,19026,19226,19225,-1,19026,19027,19227,19226,-1,19027,19028,19228,19227,-1,19028,19029,19229,19228,-1,19029,19030,19230,19229,-1,19030,19031,19231,19230,-1,19031,19032,19232,19231,-1,19032,19033,19233,19232,-1,19033,19034,19234,19233,-1,19034,19035,19235,19234,-1,19035,19036,19236,19235,-1,19036,19037,19237,19236,-1,19037,19038,19238,19237,-1,19038,19039,19239,19238,-1,19039,19040,19240,19239,-1,19040,19041,19241,19240,-1,19041,19042,19242,19241,-1,19042,19043,19243,19242,-1,19043,19044,19244,19243,-1,19044,19045,19245,19244,-1,19045,19046,19246,19245,-1,19046,19047,19247,19246,-1,19047,19048,19248,19247,-1,19048,19049,19249,19248,-1,19049,19050,19250,19249,-1,19050,19051,19251,19250,-1,19051,19052,19252,19251,-1,19052,19053,19253,19252,-1,19053,19054,19254,19253,-1,19054,19055,19255,19254,-1,19055,19056,19256,19255,-1,19056,19057,19257,19256,-1,19057,19058,19258,19257,-1,19058,19059,19259,19258,-1,19059,19060,19260,19259,-1,19060,19061,19261,19260,-1,19061,19062,19262,19261,-1,19062,19063,19263,19262,-1,19063,19064,19264,19263,-1,19064,19065,19265,19264,-1,19065,19066,19266,19265,-1,19066,19067,19267,19266,-1,19067,19068,19268,19267,-1,19068,19069,19269,19268,-1,19069,19070,19270,19269,-1,19070,19071,19271,19270,-1,19071,19072,19272,19271,-1,19072,19073,19273,19272,-1,19073,19074,19274,19273,-1,19074,19075,19275,19274,-1,19075,19076,19276,19275,-1,19076,19077,19277,19276,-1,19077,19078,19278,19277,-1,19078,19079,19279,19278,-1,19079,19080,19280,19279,-1,19080,19081,19281,19280,-1,19081,19082,19282,19281,-1,19082,19083,19283,19282,-1,19083,19084,19284,19283,-1,19084,19085,19285,19284,-1,19085,19086,19286,19285,-1,19086,19087,19287,19286,-1,19087,19088,19288,19287,-1,19088,19089,19289,19288,-1,19089,19090,19290,19289,-1,19090,19091,19291,19290,-1,19091,19092,19292,19291,-1,19092,19093,19293,19292,-1,19093,19094,19294,19293,-1,19094,19095,19295,19294,-1,19095,19096,19296,19295,-1,19096,19097,19297,19296,-1,19097,19098,19298,19297,-1,19098,19099,19299,19298,-1,19099,19100,19300,19299,-1,19100,19101,19301,19300,-1,19101,19102,19302,19301,-1,19102,19103,19303,19302,-1,19103,19104,19304,19303,-1,19104,19105,19305,19304,-1,19105,19106,19306,19305,-1,19106,19107,19307,19306,-1,19107,19108,19308,19307,-1,19108,19109,19309,19308,-1,19109,19110,19310,19309,-1,19110,19111,19311,19310,-1,19111,19112,19312,19311,-1,19112,19113,19313,19312,-1,19113,19114,19314,19313,-1,19114,19115,19315,19314,-1,19115,19116,19316,19315,-1,19116,19117,19317,19316,-1,19117,19118,19318,19317,-1,19118,19119,19319,19318,-1,19119,19120,19320,19319,-1,19120,19121,19321,19320,-1,19121,19122,19322,19321,-1,19122,19123,19323,19322,-1,19123,19124,19324,19323,-1,19124,19125,19325,19324,-1,19125,19126,19326,19325,-1,19126,19127,19327,19326,-1,19127,19128,19328,19327,-1,19128,19129,19329,19328,-1,19129,19130,19330,19329,-1,19130,19131,19331,19330,-1,19131,19132,19332,19331,-1,19132,19133,19333,19332,-1,19133,19134,19334,19333,-1,19134,19135,19335,19334,-1,19135,19136,19336,19335,-1,19136,19137,19337,19336,-1,19137,19138,19338,19337,-1,19138,19139,19339,19338,-1,19139,19140,19340,19339,-1,19140,19141,19341,19340,-1,19141,19142,19342,19341,-1,19142,19143,19343,19342,-1,19143,19144,19344,19343,-1,19144,19145,19345,19344,-1,19145,19146,19346,19345,-1,19146,19147,19347,19346,-1,19147,19148,19348,19347,-1,19148,19149,19349,19348,-1,19149,19150,19350,19349,-1,19150,19151,19351,19350,-1,19151,19152,19352,19351,-1,19152,19153,19353,19352,-1,19153,19154,19354,19353,-1,19154,19155,19355,19354,-1,19155,19156,19356,19355,-1,19156,19157,19357,19356,-1,19157,19158,19358,19357,-1,19158,19159,19359,19358,-1,19159,19160,19360,19359,-1,19160,19161,19361,19360,-1,19161,19162,19362,19361,-1,19162,19163,19363,19362,-1,19163,19164,19364,19363,-1,19164,19165,19365,19364,-1,19165,19166,19366,19365,-1,19166,19167,19367,19366,-1,19167,19168,19368,19367,-1,19168,19169,19369,19368,-1,19169,19170,19370,19369,-1,19170,19171,19371,19370,-1,19171,19172,19372,19371,-1,19172,19173,19373,19372,-1,19173,19174,19374,19373,-1,19174,19175,19375,19374,-1,19175,19176,19376,19375,-1,19176,19177,19377,19376,-1,19177,19178,19378,19377,-1,19178,19179,19379,19378,-1,19179,19180,19380,19379,-1,19180,19181,19381,19380,-1,19181,19182,19382,19381,-1,19182,19183,19383,19382,-1,19183,19184,19384,19383,-1,19184,19185,19385,19384,-1,19185,19186,19386,19385,-1,19186,19187,19387,19386,-1,19187,19188,19388,19387,-1,19188,19189,19389,19388,-1,19189,19190,19390,19389,-1,19190,19191,19391,19390,-1,19191,19192,19392,19391,-1,19192,19193,19393,19392,-1,19193,19194,19394,19393,-1,19194,19195,19395,19394,-1,19195,19196,19396,19395,-1,19196,19197,19397,19396,-1,19197,19198,19398,19397,-1,19198,19199,19399,19398,-1,19200,19201,19401,19400,-1,19201,19202,19402,19401,-1,19202,19203,19403,19402,-1,19203,19204,19404,19403,-1,19204,19205,19405,19404,-1,19205,19206,19406,19405,-1,19206,19207,19407,19406,-1,19207,19208,19408,19407,-1,19208,19209,19409,19408,-1,19209,19210,19410,19409,-1,19210,19211,19411,19410,-1,19211,19212,19412,19411,-1,19212,19213,19413,19412,-1,19213,19214,19414,19413,-1,19214,19215,19415,19414,-1,19215,19216,19416,19415,-1,19216,19217,19417,19416,-1,19217,19218,19418,19417,-1,19218,19219,19419,19418,-1,19219,19220,19420,19419,-1,19220,19221,19421,19420,-1,19221,19222,19422,19421,-1,19222,19223,19423,19422,-1,19223,19224,19424,19423,-1,19224,19225,19425,19424,-1,19225,19226,19426,19425,-1,19226,19227,19427,19426,-1,19227,19228,19428,19427,-1,19228,19229,19429,19428,-1,19229,19230,19430,19429,-1,19230,19231,19431,19430,-1,19231,19232,19432,19431,-1,19232,19233,19433,19432,-1,19233,19234,19434,19433,-1,19234,19235,19435,19434,-1,19235,19236,19436,19435,-1,19236,19237,19437,19436,-1,19237,19238,19438,19437,-1,19238,19239,19439,19438,-1,19239,19240,19440,19439,-1,19240,19241,19441,19440,-1,19241,19242,19442,19441,-1,19242,19243,19443,19442,-1,19243,19244,19444,19443,-1,19244,19245,19445,19444,-1,19245,19246,19446,19445,-1,19246,19247,19447,19446,-1,19247,19248,19448,19447,-1,19248,19249,19449,19448,-1,19249,19250,19450,19449,-1,19250,19251,19451,19450,-1,19251,19252,19452,19451,-1,19252,19253,19453,19452,-1,19253,19254,19454,19453,-1,19254,19255,19455,19454,-1,19255,19256,19456,19455,-1,19256,19257,19457,19456,-1,19257,19258,19458,19457,-1,19258,19259,19459,19458,-1,19259,19260,19460,19459,-1,19260,19261,19461,19460,-1,19261,19262,19462,19461,-1,19262,19263,19463,19462,-1,19263,19264,19464,19463,-1,19264,19265,19465,19464,-1,19265,19266,19466,19465,-1,19266,19267,19467,19466,-1,19267,19268,19468,19467,-1,19268,19269,19469,19468,-1,19269,19270,19470,19469,-1,19270,19271,19471,19470,-1,19271,19272,19472,19471,-1,19272,19273,19473,19472,-1,19273,19274,19474,19473,-1,19274,19275,19475,19474,-1,19275,19276,19476,19475,-1,19276,19277,19477,19476,-1,19277,19278,19478,19477,-1,19278,19279,19479,19478,-1,19279,19280,19480,19479,-1,19280,19281,19481,19480,-1,19281,19282,19482,19481,-1,19282,19283,19483,19482,-1,19283,19284,19484,19483,-1,19284,19285,19485,19484,-1,19285,19286,19486,19485,-1,19286,19287,19487,19486,-1,19287,19288,19488,19487,-1,19288,19289,19489,19488,-1,19289,19290,19490,19489,-1,19290,19291,19491,19490,-1,19291,19292,19492,19491,-1,19292,19293,19493,19492,-1,19293,19294,19494,19493,-1,19294,19295,19495,19494,-1,19295,19296,19496,19495,-1,19296,19297,19497,19496,-1,19297,19298,19498,19497,-1,19298,19299,19499,19498,-1,19299,19300,19500,19499,-1,19300,19301,19501,19500,-1,19301,19302,19502,19501,-1,19302,19303,19503,19502,-1,19303,19304,19504,19503,-1,19304,19305,19505,19504,-1,19305,19306,19506,19505,-1,19306,19307,19507,19506,-1,19307,19308,19508,19507,-1,19308,19309,19509,19508,-1,19309,19310,19510,19509,-1,19310,19311,19511,19510,-1,19311,19312,19512,19511,-1,19312,19313,19513,19512,-1,19313,19314,19514,19513,-1,19314,19315,19515,19514,-1,19315,19316,19516,19515,-1,19316,19317,19517,19516,-1,19317,19318,19518,19517,-1,19318,19319,19519,19518,-1,19319,19320,19520,19519,-1,19320,19321,19521,19520,-1,19321,19322,19522,19521,-1,19322,19323,19523,19522,-1,19323,19324,19524,19523,-1,19324,19325,19525,19524,-1,19325,19326,19526,19525,-1,19326,19327,19527,19526,-1,19327,19328,19528,19527,-1,19328,19329,19529,19528,-1,19329,19330,19530,19529,-1,19330,19331,19531,19530,-1,19331,19332,19532,19531,-1,19332,19333,19533,19532,-1,19333,19334,19534,19533,-1,19334,19335,19535,19534,-1,19335,19336,19536,19535,-1,19336,19337,19537,19536,-1,19337,19338,19538,19537,-1,19338,19339,19539,19538,-1,19339,19340,19540,19539,-1,19340,19341,19541,19540,-1,19341,19342,19542,19541,-1,19342,19343,19543,19542,-1,19343,19344,19544,19543,-1,19344,19345,19545,19544,-1,19345,19346,19546,19545,-1,19346,19347,19547,19546,-1,19347,19348,19548,19547,-1,19348,19349,19549,19548,-1,19349,19350,19550,19549,-1,19350,19351,19551,19550,-1,19351,19352,19552,19551,-1,19352,19353,19553,19552,-1,19353,19354,19554,19553,-1,19354,19355,19555,19554,-1,19355,19356,19556,19555,-1,19356,19357,19557,19556,-1,19357,19358,19558,19557,-1,19358,19359,19559,19558,-1,19359,19360,19560,19559,-1,19360,19361,19561,19560,-1,19361,19362,19562,19561,-1,19362,19363,19563,19562,-1,19363,19364,19564,19563,-1,19364,19365,19565,19564,-1,19365,19366,19566,19565,-1,19366,19367,19567,19566,-1,19367,19368,19568,19567,-1,19368,19369,19569,19568,-1,19369,19370,19570,19569,-1,19370,19371,19571,19570,-1,19371,19372,19572,19571,-1,19372,19373,19573,19572,-1,19373,19374,19574,19573,-1,19374,19375,19575,19574,-1,19375,19376,19576,19575,-1,19376,19377,19577,19576,-1,19377,19378,19578,19577,-1,19378,19379,19579,19578,-1,19379,19380,19580,19579,-1,19380,19381,19581,19580,-1,19381,19382,19582,19581,-1,19382,19383,19583,19582,-1,19383,19384,19584,19583,-1,19384,19385,19585,19584,-1,19385,19386,19586,19585,-1,19386,19387,19587,19586,-1,19387,19388,19588,19587,-1,19388,19389,19589,19588,-1,19389,19390,19590,19589,-1,19390,19391,19591,19590,-1,19391,19392,19592,19591,-1,19392,19393,19593,19592,-1,19393,19394,19594,19593,-1,19394,19395,19595,19594,-1,19395,19396,19596,19595,-1,19396,19397,19597,19596,-1,19397,19398,19598,19597,-1,19398,19399,19599,19598,-1,19400,19401,19601,19600,-1,19401,19402,19602,19601,-1,19402,19403,19603,19602,-1,19403,19404,19604,19603,-1,19404,19405,19605,19604,-1,19405,19406,19606,19605,-1,19406,19407,19607,19606,-1,19407,19408,19608,19607,-1,19408,19409,19609,19608,-1,19409,19410,19610,19609,-1,19410,19411,19611,19610,-1,19411,19412,19612,19611,-1,19412,19413,19613,19612,-1,19413,19414,19614,19613,-1,19414,19415,19615,19614,-1,19415,19416,19616,19615,-1,19416,19417,19617,19616,-1,19417,19418,19618,19617,-1,19418,19419,19619,19618,-1,19419,19420,19620,19619,-1,19420,19421,19621,19620,-1,19421,19422,19622,19621,-1,19422,19423,19623,19622,-1,19423,19424,19624,19623,-1,19424,19425,19625,19624,-1,19425,19426,19626,19625,-1,19426,19427,19627,19626,-1,19427,19428,19628,19627,-1,19428,19429,19629,19628,-1,19429,19430,19630,19629,-1,19430,19431,19631,19630,-1,19431,19432,19632,19631,-1,19432,19433,19633,19632,-1,19433,19434,19634,19633,-1,19434,19435,19635,19634,-1,19435,19436,19636,19635,-1,19436,19437,19637,19636,-1,19437,19438,19638,19637,-1,19438,19439,19639,19638,-1,19439,19440,19640,19639,-1,19440,19441,19641,19640,-1,19441,19442,19642,19641,-1,19442,19443,19643,19642,-1,19443,19444,19644,19643,-1,19444,19445,19645,19644,-1,19445,19446,19646,19645,-1,19446,19447,19647,19646,-1,19447,19448,19648,19647,-1,19448,19449,19649,19648,-1,19449,19450,19650,19649,-1,19450,19451,19651,19650,-1,19451,19452,19652,19651,-1,19452,19453,19653,19652,-1,19453,19454,19654,19653,-1,19454,19455,19655,19654,-1,19455,19456,19656,19655,-1,19456,19457,19657,19656,-1,19457,19458,19658,19657,-1,19458,19459,19659,19658,-1,19459,19460,19660,19659,-1,19460,19461,19661,19660,-1,19461,19462,19662,19661,-1,19462,19463,19663,19662,-1,19463,19464,19664,19663,-1,19464,19465,19665,19664,-1,19465,19466,19666,19665,-1,19466,19467,19667,19666,-1,19467,19468,19668,19667,-1,19468,19469,19669,19668,-1,19469,19470,19670,19669,-1,19470,19471,19671,19670,-1,19471,19472,19672,19671,-1,19472,19473,19673,19672,-1,19473,19474,19674,19673,-1,19474,19475,19675,19674,-1,19475,19476,19676,19675,-1,19476,19477,19677,19676,-1,19477,19478,19678,19677,-1,19478,19479,19679,19678,-1,19479,19480,19680,19679,-1,19480,19481,19681,19680,-1,19481,19482,19682,19681,-1,19482,19483,19683,19682,-1,19483,19484,19684,19683,-1,19484,19485,19685,19684,-1,19485,19486,19686,19685,-1,19486,19487,19687,19686,-1,19487,19488,19688,19687,-1,19488,19489,19689,19688,-1,19489,19490,19690,19689,-1,19490,19491,19691,19690,-1,19491,19492,19692,19691,-1,19492,19493,19693,19692,-1,19493,19494,19694,19693,-1,19494,19495,19695,19694,-1,19495,19496,19696,19695,-1,19496,19497,19697,19696,-1,19497,19498,19698,19697,-1,19498,19499,19699,19698,-1,19499,19500,19700,19699,-1,19500,19501,19701,19700,-1,19501,19502,19702,19701,-1,19502,19503,19703,19702,-1,19503,19504,19704,19703,-1,19504,19505,19705,19704,-1,19505,19506,19706,19705,-1,19506,19507,19707,19706,-1,19507,19508,19708,19707,-1,19508,19509,19709,19708,-1,19509,19510,19710,19709,-1,19510,19511,19711,19710,-1,19511,19512,19712,19711,-1,19512,19513,19713,19712,-1,19513,19514,19714,19713,-1,19514,19515,19715,19714,-1,19515,19516,19716,19715,-1,19516,19517,19717,19716,-1,19517,19518,19718,19717,-1,19518,19519,19719,19718,-1,19519,19520,19720,19719,-1,19520,19521,19721,19720,-1,19521,19522,19722,19721,-1,19522,19523,19723,19722,-1,19523,19524,19724,19723,-1,19524,19525,19725,19724,-1,19525,19526,19726,19725,-1,19526,19527,19727,19726,-1,19527,19528,19728,19727,-1,19528,19529,19729,19728,-1,19529,19530,19730,19729,-1,19530,19531,19731,19730,-1,19531,19532,19732,19731,-1,19532,19533,19733,19732,-1,19533,19534,19734,19733,-1,19534,19535,19735,19734,-1,19535,19536,19736,19735,-1,19536,19537,19737,19736,-1,19537,19538,19738,19737,-1,19538,19539,19739,19738,-1,19539,19540,19740,19739,-1,19540,19541,19741,19740,-1,19541,19542,19742,19741,-1,19542,19543,19743,19742,-1,19543,19544,19744,19743,-1,19544,19545,19745,19744,-1,19545,19546,19746,19745,-1,19546,19547,19747,19746,-1,19547,19548,19748,19747,-1,19548,19549,19749,19748,-1,19549,19550,19750,19749,-1,19550,19551,19751,19750,-1,19551,19552,19752,19751,-1,19552,19553,19753,19752,-1,19553,19554,19754,19753,-1,19554,19555,19755,19754,-1,19555,19556,19756,19755,-1,19556,19557,19757,19756,-1,19557,19558,19758,19757,-1,19558,19559,19759,19758,-1,19559,19560,19760,19759,-1,19560,19561,19761,19760,-1,19561,19562,19762,19761,-1,19562,19563,19763,19762,-1,19563,19564,19764,19763,-1,19564,19565,19765,19764,-1,19565,19566,19766,19765,-1,19566,19567,19767,19766,-1,19567,19568,19768,19767,-1,19568,19569,19769,19768,-1,19569,19570,19770,19769,-1,19570,19571,19771,19770,-1,19571,19572,19772,19771,-1,19572,19573,19773,19772,-1,19573,19574,19774,19773,-1,19574,19575,19775,19774,-1,19575,19576,19776,19775,-1,19576,19577,19777,19776,-1,19577,19578,19778,19777,-1,19578,19579,19779,19778,-1,19579,19580,19780,19779,-1,19580,19581,19781,19780,-1,19581,19582,19782,19781,-1,19582,19583,19783,19782,-1,19583,19584,19784,19783,-1,19584,19585,19785,19784,-1,19585,19586,19786,19785,-1,19586,19587,19787,19786,-1,19587,19588,19788,19787,-1,19588,19589,19789,19788,-1,19589,19590,19790,19789,-1,19590,19591,19791,19790,-1,19591,19592,19792,19791,-1,19592,19593,19793,19792,-1,19593,19594,19794,19793,-1,19594,19595,19795,19794,-1,19595,19596,19796,19795,-1,19596,19597,19797,19796,-1,19597,19598,19798,19797,-1,19598,19599,19799,19798,-1,19600,19601,19801,19800,-1,19601,19602,19802,19801,-1,19602,19603,19803,19802,-1,19603,19604,19804,19803,-1,19604,19605,19805,19804,-1,19605,19606,19806,19805,-1,19606,19607,19807,19806,-1,19607,19608,19808,19807,-1,19608,19609,19809,19808,-1,19609,19610,19810,19809,-1,19610,19611,19811,19810,-1,19611,19612,19812,19811,-1,19612,19613,19813,19812,-1,19613,19614,19814,19813,-1,19614,19615,19815,19814,-1,19615,19616,19816,19815,-1,19616,19617,19817,19816,-1,19617,19618,19818,19817,-1,19618,19619,19819,19818,-1,19619,19620,19820,19819,-1,19620,19621,19821,19820,-1,19621,19622,19822,19821,-1,19622,19623,19823,19822,-1,19623,19624,19824,19823,-1,19624,19625,19825,19824,-1,19625,19626,19826,19825,-1,19626,19627,19827,19826,-1,19627,19628,19828,19827,-1,19628,19629,19829,19828,-1,19629,19630,19830,19829,-1,19630,19631,19831,19830,-1,19631,19632,19832,19831,-1,19632,19633,19833,19832,-1,19633,19634,19834,19833,-1,19634,19635,19835,19834,-1,19635,19636,19836,19835,-1,19636,19637,19837,19836,-1,19637,19638,19838,19837,-1,19638,19639,19839,19838,-1,19639,19640,19840,19839,-1,19640,19641,19841,19840,-1,19641,19642,19842,19841,-1,19642,19643,19843,19842,-1,19643,19644,19844,19843,-1,19644,19645,19845,19844,-1,19645,19646,19846,19845,-1,19646,19647,19847,19846,-1,19647,19648,19848,19847,-1,19648,19649,19849,19848,-1,19649,19650,19850,19849,-1,19650,19651,19851,19850,-1,19651,19652,19852,19851,-1,19652,19653,19853,19852,-1,19653,19654,19854,19853,-1,19654,19655,19855,19854,-1,19655,19656,19856,19855,-1,19656,19657,19857,19856,-1,19657,19658,19858,19857,-1,19658,19659,19859,19858,-1,19659,19660,19860,19859,-1,19660,19661,19861,19860,-1,19661,19662,19862,19861,-1,19662,19663,19863,19862,-1,19663,19664,19864,19863,-1,19664,19665,19865,19864,-1,19665,19666,19866,19865,-1,19666,19667,19867,19866,-1,19667,19668,19868,19867,-1,19668,19669,19869,19868,-1,19669,19670,19870,19869,-1,19670,19671,19871,19870,-1,19671,19672,19872,19871,-1,19672,19673,19873,19872,-1,19673,19674,19874,19873,-1,19674,19675,19875,19874,-1,19675,19676,19876,19875,-1,19676,19677,19877,19876,-1,19677,19678,19878,19877,-1,19678,19679,19879,19878,-1,19679,19680,19880,19879,-1,19680,19681,19881,19880,-1,19681,19682,19882,19881,-1,19682,19683,19883,19882,-1,19683,19684,19884,19883,-1,19684,19685,19885,19884,-1,19685,19686,19886,19885,-1,19686,19687,19887,19886,-1,19687,19688,19888,19887,-1,19688,19689,19889,19888,-1,19689,19690,19890,19889,-1,19690,19691,19891,19890,-1,19691,19692,19892,19891,-1,19692,19693,19893,19892,-1,19693,19694,19894,19893,-1,19694,19695,19895,19894,-1,19695,19696,19896,19895,-1,19696,19697,19897,19896,-1,19697,19698,19898,19897,-1,19698,19699,19899,19898,-1,19699,19700,19900,19899,-1,19700,19701,19901,19900,-1,19701,19702,19902,19901,-1,19702,19703,19903,19902,-1,19703,19704,19904,19903,-1,19704,19705,19905,19904,-1,19705,19706,19906,19905,-1,19706,19707,19907,19906,-1,19707,19708,19908,19907,-1,19708,19709,19909,19908,-1,19709,19710,19910,19909,-1,19710,19711,19911,19910,-1,19711,19712,19912,19911,-1,19712,19713,19913,19912,-1,19713,19714,19914,19913,-1,19714,19715,19915,19914,-1,19715,19716,19916,19915,-1,19716,19717,19917,19916,-1,19717,19718,19918,19917,-1,19718,19719,19919,19918,-1,19719,19720,19920,19919,-1,19720,19721,19921,19920,-1,19721,19722,19922,19921,-1,19722,19723,19923,19922,-1,19723,19724,19924,19923,-1,19724,19725,19925,19924,-1,19725,19726,19926,19925,-1,19726,19727,19927,19926,-1,19727,19728,19928,19927,-1,19728,19729,19929,19928,-1,19729,19730,19930,19929,-1,19730,19731,19931,19930,-1,19731,19732,19932,19931,-1,19732,19733,19933,19932,-1,19733,19734,19934,19933,-1,19734,19735,19935,19934,-1,19735,19736,19936,19935,-1,19736,19737,19937,19936,-1,19737,19738,19938,19937,-1,19738,19739,19939,19938,-1,19739,19740,19940,19939,-1,19740,19741,19941,19940,-1,19741,19742,19942,19941,-1,19742,19743,19943,19942,-1,19743,19744,19944,19943,-1,19744,19745,19945,19944,-1,19745,19746,19946,19945,-1,19746,19747,19947,19946,-1,19747,19748,19948,19947,-1,19748,19749,19949,19948,-1,19749,19750,19950,19949,-1,19750,19751,19951,19950,-1,19751,19752,19952,19951,-1,19752,19753,19953,19952,-1,19753,19754,19954,19953,-1,19754,19755,19955,19954,-1,19755,19756,19956,19955,-1,19756,19757,19957,19956,-1,19757,19758,19958,19957,-1,19758,19759,19959,19958,-1,19759,19760,19960,19959,-1,19760,19761,19961,19960,-1,19761,19762,19962,19961,-1,19762,19763,19963,19962,-1,19763,19764,19964,19963,-1,19764,19765,19965,19964,-1,19765,19766,19966,19965,-1,19766,19767,19967,19966,-1,19767,19768,19968,19967,-1,19768,19769,19969,19968,-1,19769,19770,19970,19969,-1,19770,19771,19971,19970,-1,19771,19772,19972,19971,-1,19772,19773,19973,19972,-1,19773,19774,19974,19973,-1,19774,19775,19975,19974,-1,19775,19776,19976,19975,-1,19776,19777,19977,19976,-1,19777,19778,19978,19977,-1,19778,19779,19979,19978,-1,19779,19780,19980,19979,-1,19780,19781,19981,19980,-1,19781,19782,19982,19981,-1,19782,19783,19983,19982,-1,19783,19784,19984,19983,-1,19784,19785,19985,19984,-1,19785,19786,19986,19985,-1,19786,19787,19987,19986,-1,19787,19788,19988,19987,-1,19788,19789,19989,19988,-1,19789,19790,19990,19989,-1,19790,19791,19991,19990,-1,19791,19792,19992,19991,-1,19792,19793,19993,19992,-1,19793,19794,19994,19993,-1,19794,19795,19995,19994,-1,19795,19796,19996,19995,-1,19796,19797,19997,19996,-1,19797,19798,19998,19997,-1,19798,19799,19999,19998,-1,19800,19801,20001,2,-1,19801,19802,20002,20001,-1,19802,19803,20003,20002,-1,19803,19804,20004,20003,-1,19804,19805,20005,20004,-1,19805,19806,20006,20005,-1,19806,19807,20007,20006,-1,19807,19808,20008,20007,-1,19808,19809,20009,20008,-1,19809,19810,20010,20009,-1,19810,19811,20011,20010,-1,19811,19812,20012,20011,-1,19812,19813,20013,20012,-1,19813,19814,20014,20013,-1,19814,19815,20015,20014,-1,19815,19816,20016,20015,-1,19816,19817,20017,20016,-1,19817,19818,20018,20017,-1,19818,19819,20019,20018,-1,19819,19820,20020,20019,-1,19820,19821,20021,20020,-1,19821,19822,20022,20021,-1,19822,19823,20023,20022,-1,19823,19824,20024,20023,-1,19824,19825,20025,20024,-1,19825,19826,20026,20025,-1,19826,19827,20027,20026,-1,19827,19828,20028,20027,-1,19828,19829,20029,20028,-1,19829,19830,20030,20029,-1,19830,19831,20031,20030,-1,19831,19832,20032,20031,-1,19832,19833,20033,20032,-1,19833,19834,20034,20033,-1,19834,19835,20035,20034,-1,19835,19836,20036,20035,-1,19836,19837,20037,20036,-1,19837,19838,20038,20037,-1,19838,19839,20039,20038,-1,19839,19840,20040,20039,-1,19840,19841,20041,20040,-1,19841,19842,20042,20041,-1,19842,19843,20043,20042,-1,19843,19844,20044,20043,-1,19844,19845,20045,20044,-1,19845,19846,20046,20045,-1,19846,19847,20047,20046,-1,19847,19848,20048,20047,-1,19848,19849,20049,20048,-1,19849,19850,20050,20049,-1,19850,19851,20051,20050,-1,19851,19852,20052,20051,-1,19852,19853,20053,20052,-1,19853,19854,20054,20053,-1,19854,19855,20055,20054,-1,19855,19856,20056,20055,-1,19856,19857,20057,20056,-1,19857,19858,20058,20057,-1,19858,19859,20059,20058,-1,19859,19860,20060,20059,-1,19860,19861,20061,20060,-1,19861,19862,20062,20061,-1,19862,19863,20063,20062,-1,19863,19864,20064,20063,-1,19864,19865,20065,20064,-1,19865,19866,20066,20065,-1,19866,19867,20067,20066,-1,19867,19868,20068,20067,-1,19868,19869,20069,20068,-1,19869,19870,20070,20069,-1,19870,19871,20071,20070,-1,19871,19872,20072,20071,-1,19872,19873,20073,20072,-1,19873,19874,20074,20073,-1,19874,19875,20075,20074,-1,19875,19876,20076,20075,-1,19876,19877,20077,20076,-1,19877,19878,20078,20077,-1,19878,19879,20079,20078,-1,19879,19880,20080,20079,-1,19880,19881,20081,20080,-1,19881,19882,20082,20081,-1,19882,19883,20083,20082,-1,19883,19884,20084,20083,-1,19884,19885,20085,20084,-1,19885,19886,20086,20085,-1,19886,19887,20087,20086,-1,19887,19888,20088,20087,-1,19888,19889,20089,20088,-1,19889,19890,20090,20089,-1,19890,19891,20091,20090,-1,19891,19892,20092,20091,-1,19892,19893,20093,20092,-1,19893,19894,20094,20093,-1,19894,19895,20095,20094,-1,19895,19896,20096,20095,-1,19896,19897,20097,20096,-1,19897,19898,20098,20097,-1,19898,19899,20099,20098,-1,19899,19900,20100,20099,-1,19900,19901,20101,20100,-1,19901,19902,20102,20101,-1,19902,19903,20103,20102,-1,19903,19904,20104,20103,-1,19904,19905,20105,20104,-1,19905,19906,20106,20105,-1,19906,19907,20107,20106,-1,19907,19908,20108,20107,-1,19908,19909,20109,20108,-1,19909,19910,20110,20109,-1,19910,19911,20111,20110,-1,19911,19912,20112,20111,-1,19912,19913,20113,20112,-1,19913,19914,20114,20113,-1,19914,19915,20115,20114,-1,19915,19916,20116,20115,-1,19916,19917,20117,20116,-1,19917,19918,20118,20117,-1,19918,19919,20119,20118,-1,19919,19920,20120,20119,-1,19920,19921,20121,20120,-1,19921,19922,20122,20121,-1,19922,19923,20123,20122,-1,19923,19924,20124,20123,-1,19924,19925,20125,20124,-1,19925,19926,20126,20125,-1,19926,19927,20127,20126,-1,19927,19928,20128,20127,-1,19928,19929,20129,20128,-1,19929,19930,20130,20129,-1,19930,19931,20131,20130,-1,19931,19932,20132,20131,-1,19932,19933,20133,20132,-1,19933,19934,20134,20133,-1,19934,19935,20135,20134,-1,19935,19936,20136,20135,-1,19936,19937,20137,20136,-1,19937,19938,20138,20137,-1,19938,19939,20139,20138,-1,19939,19940,20140,20139,-1,19940,19941,20141,20140,-1,19941,19942,20142,20141,-1,19942,19943,20143,20142,-1,19943,19944,20144,20143,-1,19944,19945,20145,20144,-1,19945,19946,20146,20145,-1,19946,19947,20147,20146,-1,19947,19948,20148,20147,-1,19948,19949,20149,20148,-1,19949,19950,20150,20149,-1,19950,19951,20151,20150,-1,19951,19952,20152,20151,-1,19952,19953,20153,20152,-1,19953,19954,20154,20153,-1,19954,19955,20155,20154,-1,19955,19956,20156,20155,-1,19956,19957,20157,20156,-1,19957,19958,20158,20157,-1,19958,19959,20159,20158,-1,19959,19960,20160,20159,-1,19960,19961,20161,20160,-1,19961,19962,20162,20161,-1,19962,19963,20163,20162,-1,19963,19964,20164,20163,-1,19964,19965,20165,20164,-1,19965,19966,20166,20165,-1,19966,19967,20167,20166,-1,19967,19968,20168,20167,-1,19968,19969,20169,20168,-1,19969,19970,20170,20169,-1,19970,19971,20171,20170,-1,19971,19972,20172,20171,-1,19972,19973,20173,20172,-1,19973,19974,20174,20173,-1,19974,19975,20175,20174,-1,19975,19976,20176,20175,-1,19976,19977,20177,20176,-1,19977,19978,20178,20177,-1,19978,19979,20179,20178,-1,19979,19980,20180,20179,-1,19980,19981,20181,20180,-1,19981,19982,20182,20181,-1,19982,19983,20183,20182,-1,19983,19984,20184,20183,-1,19984,19985,20185,20184,-1,19985,19986,20186,20185,-1,19986,19987,20187,20186,-1,19987,19988,20188,20187,-1,19988,19989,20189,20188,-1,19989,19990,20190,20189,-1,19990,19991,20191,20190,-1,19991,19992,20192,20191,-1,19992,19993,20193,20192,-1,19993,19994,20194,20193,-1,19994,19995,20195,20194,-1,19995,19996,20196,20195,-1,19996,19997,20197,20196,-1,19997,19998,20198,20197,-1,19998,19999,20199,20198,-1,2,20001,20201,20200,-1,20001,20002,20202,20201,-1,20002,20003,20203,20202,-1,20003,20004,20204,20203,-1,20004,20005,20205,20204,-1,20005,20006,20206,20205,-1,20006,20007,20207,20206,-1,20007,20008,20208,20207,-1,20008,20009,20209,20208,-1,20009,20010,20210,20209,-1,20010,20011,20211,20210,-1,20011,20012,20212,20211,-1,20012,20013,20213,20212,-1,20013,20014,20214,20213,-1,20014,20015,20215,20214,-1,20015,20016,20216,20215,-1,20016,20017,20217,20216,-1,20017,20018,20218,20217,-1,20018,20019,20219,20218,-1,20019,20020,20220,20219,-1,20020,20021,20221,20220,-1,20021,20022,20222,20221,-1,20022,20023,20223,20222,-1,20023,20024,20224,20223,-1,20024,20025,20225,20224,-1,20025,20026,20226,20225,-1,20026,20027,20227,20226,-1,20027,20028,20228,20227,-1,20028,20029,20229,20228,-1,20029,20030,20230,20229,-1,20030,20031,20231,20230,-1,20031,20032,20232,20231,-1,20032,20033,20233,20232,-1,20033,20034,20234,20233,-1,20034,20035,20235,20234,-1,20035,20036,20236,20235,-1,20036,20037,20237,20236,-1,20037,20038,20238,20237,-1,20038,20039,20239,20238,-1,20039,20040,20240,20239,-1,20040,20041,20241,20240,-1,20041,20042,20242,20241,-1,20042,20043,20243,20242,-1,20043,20044,20244,20243,-1,20044,20045,20245,20244,-1,20045,20046,20246,20245,-1,20046,20047,20247,20246,-1,20047,20048,20248,20247,-1,20048,20049,20249,20248,-1,20049,20050,20250,20249,-1,20050,20051,20251,20250,-1,20051,20052,20252,20251,-1,20052,20053,20253,20252,-1,20053,20054,20254,20253,-1,20054,20055,20255,20254,-1,20055,20056,20256,20255,-1,20056,20057,20257,20256,-1,20057,20058,20258,20257,-1,20058,20059,20259,20258,-1,20059,20060,20260,20259,-1,20060,20061,20261,20260,-1,20061,20062,20262,20261,-1,20062,20063,20263,20262,-1,20063,20064,20264,20263,-1,20064,20065,20265,20264,-1,20065,20066,20266,20265,-1,20066,20067,20267,20266,-1,20067,20068,20268,20267,-1,20068,20069,20269,20268,-1,20069,20070,20270,20269,-1,20070,20071,20271,20270,-1,20071,20072,20272,20271,-1,20072,20073,20273,20272,-1,20073,20074,20274,20273,-1,20074,20075,20275,20274,-1,20075,20076,20276,20275,-1,20076,20077,20277,20276,-1,20077,20078,20278,20277,-1,20078,20079,20279,20278,-1,20079,20080,20280,20279,-1,20080,20081,20281,20280,-1,20081,20082,20282,20281,-1,20082,20083,20283,20282,-1,20083,20084,20284,20283,-1,20084,20085,20285,20284,-1,20085,20086,20286,20285,-1,20086,20087,20287,20286,-1,20087,20088,20288,20287,-1,20088,20089,20289,20288,-1,20089,20090,20290,20289,-1,20090,20091,20291,20290,-1,20091,20092,20292,20291,-1,20092,20093,20293,20292,-1,20093,20094,20294,20293,-1,20094,20095,20295,20294,-1,20095,20096,20296,20295,-1,20096,20097,20297,20296,-1,20097,20098,20298,20297,-1,20098,20099,20299,20298,-1,20099,20100,20300,20299,-1,20100,20101,20301,20300,-1,20101,20102,20302,20301,-1,20102,20103,20303,20302,-1,20103,20104,20304,20303,-1,20104,20105,20305,20304,-1,20105,20106,20306,20305,-1,20106,20107,20307,20306,-1,20107,20108,20308,20307,-1,20108,20109,20309,20308,-1,20109,20110,20310,20309,-1,20110,20111,20311,20310,-1,20111,20112,20312,20311,-1,20112,20113,20313,20312,-1,20113,20114,20314,20313,-1,20114,20115,20315,20314,-1,20115,20116,20316,20315,-1,20116,20117,20317,20316,-1,20117,20118,20318,20317,-1,20118,20119,20319,20318,-1,20119,20120,20320,20319,-1,20120,20121,20321,20320,-1,20121,20122,20322,20321,-1,20122,20123,20323,20322,-1,20123,20124,20324,20323,-1,20124,20125,20325,20324,-1,20125,20126,20326,20325,-1,20126,20127,20327,20326,-1,20127,20128,20328,20327,-1,20128,20129,20329,20328,-1,20129,20130,20330,20329,-1,20130,20131,20331,20330,-1,20131,20132,20332,20331,-1,20132,20133,20333,20332,-1,20133,20134,20334,20333,-1,20134,20135,20335,20334,-1,20135,20136,20336,20335,-1,20136,20137,20337,20336,-1,20137,20138,20338,20337,-1,20138,20139,20339,20338,-1,20139,20140,20340,20339,-1,20140,20141,20341,20340,-1,20141,20142,20342,20341,-1,20142,20143,20343,20342,-1,20143,20144,20344,20343,-1,20144,20145,20345,20344,-1,20145,20146,20346,20345,-1,20146,20147,20347,20346,-1,20147,20148,20348,20347,-1,20148,20149,20349,20348,-1,20149,20150,20350,20349,-1,20150,20151,20351,20350,-1,20151,20152,20352,20351,-1,20152,20153,20353,20352,-1,20153,20154,20354,20353,-1,20154,20155,20355,20354,-1,20155,20156,20356,20355,-1,20156,20157,20357,20356,-1,20157,20158,20358,20357,-1,20158,20159,20359,20358,-1,20159,20160,20360,20359,-1,20160,20161,20361,20360,-1,20161,20162,20362,20361,-1,20162,20163,20363,20362,-1,20163,20164,20364,20363,-1,20164,20165,20365,20364,-1,20165,20166,20366,20365,-1,20166,20167,20367,20366,-1,20167,20168,20368,20367,-1,20168,20169,20369,20368,-1,20169,20170,20370,20369,-1,20170,20171,20371,20370,-1,20171,20172,20372,20371,-1,20172,20173,20373,20372,-1,20173,20174,20374,20373,-1,20174,20175,20375,20374,-1,20175,20176,20376,20375,-1,20176,20177,20377,20376,-1,20177,20178,20378,20377,-1,20178,20179,20379,20378,-1,20179,20180,20380,20379,-1,20180,20181,20381,20380,-1,20181,20182,20382,20381,-1,20182,20183,20383,20382,-1,20183,20184,20384,20383,-1,20184,20185,20385,20384,-1,20185,20186,20386,20385,-1,20186,20187,20387,20386,-1,20187,20188,20388,20387,-1,20188,20189,20389,20388,-1,20189,20190,20390,20389,-1,20190,20191,20391,20390,-1,20191,20192,20392,20391,-1,20192,20193,20393,20392,-1,20193,20194,20394,20393,-1,20194,20195,20395,20394,-1,20195,20196,20396,20395,-1,20196,20197,20397,20396,-1,20197,20198,20398,20397,-1,20198,20199,20399,20398,-1,20200,20201,20401,20400,-1,20201,20202,20402,20401,-1,20202,20203,20403,20402,-1,20203,20204,20404,20403,-1,20204,20205,20405,20404,-1,20205,20206,20406,20405,-1,20206,20207,20407,20406,-1,20207,20208,20408,20407,-1,20208,20209,20409,20408,-1,20209,20210,20410,20409,-1,20210,20211,20411,20410,-1,20211,20212,20412,20411,-1,20212,20213,20413,20412,-1,20213,20214,20414,20413,-1,20214,20215,20415,20414,-1,20215,20216,20416,20415,-1,20216,20217,20417,20416,-1,20217,20218,20418,20417,-1,20218,20219,20419,20418,-1,20219,20220,20420,20419,-1,20220,20221,20421,20420,-1,20221,20222,20422,20421,-1,20222,20223,20423,20422,-1,20223,20224,20424,20423,-1,20224,20225,20425,20424,-1,20225,20226,20426,20425,-1,20226,20227,20427,20426,-1,20227,20228,20428,20427,-1,20228,20229,20429,20428,-1,20229,20230,20430,20429,-1,20230,20231,20431,20430,-1,20231,20232,20432,20431,-1,20232,20233,20433,20432,-1,20233,20234,20434,20433,-1,20234,20235,20435,20434,-1,20235,20236,20436,20435,-1,20236,20237,20437,20436,-1,20237,20238,20438,20437,-1,20238,20239,20439,20438,-1,20239,20240,20440,20439,-1,20240,20241,20441,20440,-1,20241,20242,20442,20441,-1,20242,20243,20443,20442,-1,20243,20244,20444,20443,-1,20244,20245,20445,20444,-1,20245,20246,20446,20445,-1,20246,20247,20447,20446,-1,20247,20248,20448,20447,-1,20248,20249,20449,20448,-1,20249,20250,20450,20449,-1,20250,20251,20451,20450,-1,20251,20252,20452,20451,-1,20252,20253,20453,20452,-1,20253,20254,20454,20453,-1,20254,20255,20455,20454,-1,20255,20256,20456,20455,-1,20256,20257,20457,20456,-1,20257,20258,20458,20457,-1,20258,20259,20459,20458,-1,20259,20260,20460,20459,-1,20260,20261,20461,20460,-1,20261,20262,20462,20461,-1,20262,20263,20463,20462,-1,20263,20264,20464,20463,-1,20264,20265,20465,20464,-1,20265,20266,20466,20465,-1,20266,20267,20467,20466,-1,20267,20268,20468,20467,-1,20268,20269,20469,20468,-1,20269,20270,20470,20469,-1,20270,20271,20471,20470,-1,20271,20272,20472,20471,-1,20272,20273,20473,20472,-1,20273,20274,20474,20473,-1,20274,20275,20475,20474,-1,20275,20276,20476,20475,-1,20276,20277,20477,20476,-1,20277,20278,20478,20477,-1,20278,20279,20479,20478,-1,20279,20280,20480,20479,-1,20280,20281,20481,20480,-1,20281,20282,20482,20481,-1,20282,20283,20483,20482,-1,20283,20284,20484,20483,-1,20284,20285,20485,20484,-1,20285,20286,20486,20485,-1,20286,20287,20487,20486,-1,20287,20288,20488,20487,-1,20288,20289,20489,20488,-1,20289,20290,20490,20489,-1,20290,20291,20491,20490,-1,20291,20292,20492,20491,-1,20292,20293,20493,20492,-1,20293,20294,20494,20493,-1,20294,20295,20495,20494,-1,20295,20296,20496,20495,-1,20296,20297,20497,20496,-1,20297,20298,20498,20497,-1,20298,20299,20499,20498,-1,20299,20300,20500,20499,-1,20300,20301,20501,20500,-1,20301,20302,20502,20501,-1,20302,20303,20503,20502,-1,20303,20304,20504,20503,-1,20304,20305,20505,20504,-1,20305,20306,20506,20505,-1,20306,20307,20507,20506,-1,20307,20308,20508,20507,-1,20308,20309,20509,20508,-1,20309,20310,20510,20509,-1,20310,20311,20511,20510,-1,20311,20312,20512,20511,-1,20312,20313,20513,20512,-1,20313,20314,20514,20513,-1,20314,20315,20515,20514,-1,20315,20316,20516,20515,-1,20316,20317,20517,20516,-1,20317,20318,20518,20517,-1,20318,20319,20519,20518,-1,20319,20320,20520,20519,-1,20320,20321,20521,20520,-1,20321,20322,20522,20521,-1,20322,20323,20523,20522,-1,20323,20324,20524,20523,-1,20324,20325,20525,20524,-1,20325,20326,20526,20525,-1,20326,20327,20527,20526,-1,20327,20328,20528,20527,-1,20328,20329,20529,20528,-1,20329,20330,20530,20529,-1,20330,20331,20531,20530,-1,20331,20332,20532,20531,-1,20332,20333,20533,20532,-1,20333,20334,20534,20533,-1,20334,20335,20535,20534,-1,20335,20336,20536,20535,-1,20336,20337,20537,20536,-1,20337,20338,20538,20537,-1,20338,20339,20539,20538,-1,20339,20340,20540,20539,-1,20340,20341,20541,20540,-1,20341,20342,20542,20541,-1,20342,20343,20543,20542,-1,20343,20344,20544,20543,-1,20344,20345,20545,20544,-1,20345,20346,20546,20545,-1,20346,20347,20547,20546,-1,20347,20348,20548,20547,-1,20348,20349,20549,20548,-1,20349,20350,20550,20549,-1,20350,20351,20551,20550,-1,20351,20352,20552,20551,-1,20352,20353,20553,20552,-1,20353,20354,20554,20553,-1,20354,20355,20555,20554,-1,20355,20356,20556,20555,-1,20356,20357,20557,20556,-1,20357,20358,20558,20557,-1,20358,20359,20559,20558,-1,20359,20360,20560,20559,-1,20360,20361,20561,20560,-1,20361,20362,20562,20561,-1,20362,20363,20563,20562,-1,20363,20364,20564,20563,-1,20364,20365,20565,20564,-1,20365,20366,20566,20565,-1,20366,20367,20567,20566,-1,20367,20368,20568,20567,-1,20368,20369,20569,20568,-1,20369,20370,20570,20569,-1,20370,20371,20571,20570,-1,20371,20372,20572,20571,-1,20372,20373,20573,20572,-1,20373,20374,20574,20573,-1,20374,20375,20575,20574,-1,20375,20376,20576,20575,-1,20376,20377,20577,20576,-1,20377,20378,20578,20577,-1,20378,20379,20579,20578,-1,20379,20380,20580,20579,-1,20380,20381,20581,20580,-1,20381,20382,20582,20581,-1,20382,20383,20583,20582,-1,20383,20384,20584,20583,-1,20384,20385,20585,20584,-1,20385,20386,20586,20585,-1,20386,20387,20587,20586,-1,20387,20388,20588,20587,-1,20388,20389,20589,20588,-1,20389,20390,20590,20589,-1,20390,20391,20591,20590,-1,20391,20392,20592,20591,-1,20392,20393,20593,20592,-1,20393,20394,20594,20593,-1,20394,20395,20595,20594,-1,20395,20396,20596,20595,-1,20396,20397,20597,20596,-1,20397,20398,20598,20597,-1,20398,20399,20599,20598,-1,20400,20401,20601,20600,-1,20401,20402,20602,20601,-1,20402,20403,20603,20602,-1,20403,20404,20604,20603,-1,20404,20405,20605,20604,-1,20405,20406,20606,20605,-1,20406,20407,20607,20606,-1,20407,20408,20608,20607,-1,20408,20409,20609,20608,-1,20409,20410,20610,20609,-1,20410,20411,20611,20610,-1,20411,20412,20612,20611,-1,20412,20413,20613,20612,-1,20413,20414,20614,20613,-1,20414,20415,20615,20614,-1,20415,20416,20616,20615,-1,20416,20417,20617,20616,-1,20417,20418,20618,20617,-1,20418,20419,20619,20618,-1,20419,20420,20620,20619,-1,20420,20421,20621,20620,-1,20421,20422,20622,20621,-1,20422,20423,20623,20622,-1,20423,20424,20624,20623,-1,20424,20425,20625,20624,-1,20425,20426,20626,20625,-1,20426,20427,20627,20626,-1,20427,20428,20628,20627,-1,20428,20429,20629,20628,-1,20429,20430,20630,20629,-1,20430,20431,20631,20630,-1,20431,20432,20632,20631,-1,20432,20433,20633,20632,-1,20433,20434,20634,20633,-1,20434,20435,20635,20634,-1,20435,20436,20636,20635,-1,20436,20437,20637,20636,-1,20437,20438,20638,20637,-1,20438,20439,20639,20638,-1,20439,20440,20640,20639,-1,20440,20441,20641,20640,-1,20441,20442,20642,20641,-1,20442,20443,20643,20642,-1,20443,20444,20644,20643,-1,20444,20445,20645,20644,-1,20445,20446,20646,20645,-1,20446,20447,20647,20646,-1,20447,20448,20648,20647,-1,20448,20449,20649,20648,-1,20449,20450,20650,20649,-1,20450,20451,20651,20650,-1,20451,20452,20652,20651,-1,20452,20453,20653,20652,-1,20453,20454,20654,20653,-1,20454,20455,20655,20654,-1,20455,20456,20656,20655,-1,20456,20457,20657,20656,-1,20457,20458,20658,20657,-1,20458,20459,20659,20658,-1,20459,20460,20660,20659,-1,20460,20461,20661,20660,-1,20461,20462,20662,20661,-1,20462,20463,20663,20662,-1,20463,20464,20664,20663,-1,20464,20465,20665,20664,-1,20465,20466,20666,20665,-1,20466,20467,20667,20666,-1,20467,20468,20668,20667,-1,20468,20469,20669,20668,-1,20469,20470,20670,20669,-1,20470,20471,20671,20670,-1,20471,20472,20672,20671,-1,20472,20473,20673,20672,-1,20473,20474,20674,20673,-1,20474,20475,20675,20674,-1,20475,20476,20676,20675,-1,20476,20477,20677,20676,-1,20477,20478,20678,20677,-1,20478,20479,20679,20678,-1,20479,20480,20680,20679,-1,20480,20481,20681,20680,-1,20481,20482,20682,20681,-1,20482,20483,20683,20682,-1,20483,20484,20684,20683,-1,20484,20485,20685,20684,-1,20485,20486,20686,20685,-1,20486,20487,20687,20686,-1,20487,20488,20688,20687,-1,20488,20489,20689,20688,-1,20489,20490,20690,20689,-1,20490,20491,20691,20690,-1,20491,20492,20692,20691,-1,20492,20493,20693,20692,-1,20493,20494,20694,20693,-1,20494,20495,20695,20694,-1,20495,20496,20696,20695,-1,20496,20497,20697,20696,-1,20497,20498,20698,20697,-1,20498,20499,20699,20698,-1,20499,20500,20700,20699,-1,20500,20501,20701,20700,-1,20501,20502,20702,20701,-1,20502,20503,20703,20702,-1,20503,20504,20704,20703,-1,20504,20505,20705,20704,-1,20505,20506,20706,20705,-1,20506,20507,20707,20706,-1,20507,20508,20708,20707,-1,20508,20509,20709,20708,-1,20509,20510,20710,20709,-1,20510,20511,20711,20710,-1,20511,20512,20712,20711,-1,20512,20513,20713,20712,-1,20513,20514,20714,20713,-1,20514,20515,20715,20714,-1,20515,20516,20716,20715,-1,20516,20517,20717,20716,-1,20517,20518,20718,20717,-1,20518,20519,20719,20718,-1,20519,20520,20720,20719,-1,20520,20521,20721,20720,-1,20521,20522,20722,20721,-1,20522,20523,20723,20722,-1,20523,20524,20724,20723,-1,20524,20525,20725,20724,-1,20525,20526,20726,20725,-1,20526,20527,20727,20726,-1,20527,20528,20728,20727,-1,20528,20529,20729,20728,-1,20529,20530,20730,20729,-1,20530,20531,20731,20730,-1,20531,20532,20732,20731,-1,20532,20533,20733,20732,-1,20533,20534,20734,20733,-1,20534,20535,20735,20734,-1,20535,20536,20736,20735,-1,20536,20537,20737,20736,-1,20537,20538,20738,20737,-1,20538,20539,20739,20738,-1,20539,20540,20740,20739,-1,20540,20541,20741,20740,-1,20541,20542,20742,20741,-1,20542,20543,20743,20742,-1,20543,20544,20744,20743,-1,20544,20545,20745,20744,-1,20545,20546,20746,20745,-1,20546,20547,20747,20746,-1,20547,20548,20748,20747,-1,20548,20549,20749,20748,-1,20549,20550,20750,20749,-1,20550,20551,20751,20750,-1,20551,20552,20752,20751,-1,20552,20553,20753,20752,-1,20553,20554,20754,20753,-1,20554,20555,20755,20754,-1,20555,20556,20756,20755,-1,20556,20557,20757,20756,-1,20557,20558,20758,20757,-1,20558,20559,20759,20758,-1,20559,20560,20760,20759,-1,20560,20561,20761,20760,-1,20561,20562,20762,20761,-1,20562,20563,20763,20762,-1,20563,20564,20764,20763,-1,20564,20565,20765,20764,-1,20565,20566,20766,20765,-1,20566,20567,20767,20766,-1,20567,20568,20768,20767,-1,20568,20569,20769,20768,-1,20569,20570,20770,20769,-1,20570,20571,20771,20770,-1,20571,20572,20772,20771,-1,20572,20573,20773,20772,-1,20573,20574,20774,20773,-1,20574,20575,20775,20774,-1,20575,20576,20776,20775,-1,20576,20577,20777,20776,-1,20577,20578,20778,20777,-1,20578,20579,20779,20778,-1,20579,20580,20780,20779,-1,20580,20581,20781,20780,-1,20581,20582,20782,20781,-1,20582,20583,20783,20782,-1,20583,20584,20784,20783,-1,20584,20585,20785,20784,-1,20585,20586,20786,20785,-1,20586,20587,20787,20786,-1,20587,20588,20788,20787,-1,20588,20589,20789,20788,-1,20589,20590,20790,20789,-1,20590,20591,20791,20790,-1,20591,20592,20792,20791,-1,20592,20593,20793,20792,-1,20593,20594,20794,20793,-1,20594,20595,20795,20794,-1,20595,20596,20796,20795,-1,20596,20597,20797,20796,-1,20597,20598,20798,20797,-1,20598,20599,20799,20798,-1,20600,20601,20801,20800,-1,20601,20602,20802,20801,-1,20602,20603,20803,20802,-1,20603,20604,20804,20803,-1,20604,20605,20805,20804,-1,20605,20606,20806,20805,-1,20606,20607,20807,20806,-1,20607,20608,20808,20807,-1,20608,20609,20809,20808,-1,20609,20610,20810,20809,-1,20610,20611,20811,20810,-1,20611,20612,20812,20811,-1,20612,20613,20813,20812,-1,20613,20614,20814,20813,-1,20614,20615,20815,20814,-1,20615,20616,20816,20815,-1,20616,20617,20817,20816,-1,20617,20618,20818,20817,-1,20618,20619,20819,20818,-1,20619,20620,20820,20819,-1,20620,20621,20821,20820,-1,20621,20622,20822,20821,-1,20622,20623,20823,20822,-1,20623,20624,20824,20823,-1,20624,20625,20825,20824,-1,20625,20626,20826,20825,-1,20626,20627,20827,20826,-1,20627,20628,20828,20827,-1,20628,20629,20829,20828,-1,20629,20630,20830,20829,-1,20630,20631,20831,20830,-1,20631,20632,20832,20831,-1,20632,20633,20833,20832,-1,20633,20634,20834,20833,-1,20634,20635,20835,20834,-1,20635,20636,20836,20835,-1,20636,20637,20837,20836,-1,20637,20638,20838,20837,-1,20638,20639,20839,20838,-1,20639,20640,20840,20839,-1,20640,20641,20841,20840,-1,20641,20642,20842,20841,-1,20642,20643,20843,20842,-1,20643,20644,20844,20843,-1,20644,20645,20845,20844,-1,20645,20646,20846,20845,-1,20646,20647,20847,20846,-1,20647,20648,20848,20847,-1,20648,20649,20849,20848,-1,20649,20650,20850,20849,-1,20650,20651,20851,20850,-1,20651,20652,20852,20851,-1,20652,20653,20853,20852,-1,20653,20654,20854,20853,-1,20654,20655,20855,20854,-1,20655,20656,20856,20855,-1,20656,20657,20857,20856,-1,20657,20658,20858,20857,-1,20658,20659,20859,20858,-1,20659,20660,20860,20859,-1,20660,20661,20861,20860,-1,20661,20662,20862,20861,-1,20662,20663,20863,20862,-1,20663,20664,20864,20863,-1,20664,20665,20865,20864,-1,20665,20666,20866,20865,-1,20666,20667,20867,20866,-1,20667,20668,20868,20867,-1,20668,20669,20869,20868,-1,20669,20670,20870,20869,-1,20670,20671,20871,20870,-1,20671,20672,20872,20871,-1,20672,20673,20873,20872,-1,20673,20674,20874,20873,-1,20674,20675,20875,20874,-1,20675,20676,20876,20875,-1,20676,20677,20877,20876,-1,20677,20678,20878,20877,-1,20678,20679,20879,20878,-1,20679,20680,20880,20879,-1,20680,20681,20881,20880,-1,20681,20682,20882,20881,-1,20682,20683,20883,20882,-1,20683,20684,20884,20883,-1,20684,20685,20885,20884,-1,20685,20686,20886,20885,-1,20686,20687,20887,20886,-1,20687,20688,20888,20887,-1,20688,20689,20889,20888,-1,20689,20690,20890,20889,-1,20690,20691,20891,20890,-1,20691,20692,20892,20891,-1,20692,20693,20893,20892,-1,20693,20694,20894,20893,-1,20694,20695,20895,20894,-1,20695,20696,20896,20895,-1,20696,20697,20897,20896,-1,20697,20698,20898,20897,-1,20698,20699,20899,20898,-1,20699,20700,20900,20899,-1,20700,20701,20901,20900,-1,20701,20702,20902,20901,-1,20702,20703,20903,20902,-1,20703,20704,20904,20903,-1,20704,20705,20905,20904,-1,20705,20706,20906,20905,-1,20706,20707,20907,20906,-1,20707,20708,20908,20907,-1,20708,20709,20909,20908,-1,20709,20710,20910,20909,-1,20710,20711,20911,20910,-1,20711,20712,20912,20911,-1,20712,20713,20913,20912,-1,20713,20714,20914,20913,-1,20714,20715,20915,20914,-1,20715,20716,20916,20915,-1,20716,20717,20917,20916,-1,20717,20718,20918,20917,-1,20718,20719,20919,20918,-1,20719,20720,20920,20919,-1,20720,20721,20921,20920,-1,20721,20722,20922,20921,-1,20722,20723,20923,20922,-1,20723,20724,20924,20923,-1,20724,20725,20925,20924,-1,20725,20726,20926,20925,-1,20726,20727,20927,20926,-1,20727,20728,20928,20927,-1,20728,20729,20929,20928,-1,20729,20730,20930,20929,-1,20730,20731,20931,20930,-1,20731,20732,20932,20931,-1,20732,20733,20933,20932,-1,20733,20734,20934,20933,-1,20734,20735,20935,20934,-1,20735,20736,20936,20935,-1,20736,20737,20937,20936,-1,20737,20738,20938,20937,-1,20738,20739,20939,20938,-1,20739,20740,20940,20939,-1,20740,20741,20941,20940,-1,20741,20742,20942,20941,-1,20742,20743,20943,20942,-1,20743,20744,20944,20943,-1,20744,20745,20945,20944,-1,20745,20746,20946,20945,-1,20746,20747,20947,20946,-1,20747,20748,20948,20947,-1,20748,20749,20949,20948,-1,20749,20750,20950,20949,-1,20750,20751,20951,20950,-1,20751,20752,20952,20951,-1,20752,20753,20953,20952,-1,20753,20754,20954,20953,-1,20754,20755,20955,20954,-1,20755,20756,20956,20955,-1,20756,20757,20957,20956,-1,20757,20758,20958,20957,-1,20758,20759,20959,20958,-1,20759,20760,20960,20959,-1,20760,20761,20961,20960,-1,20761,20762,20962,20961,-1,20762,20763,20963,20962,-1,20763,20764,20964,20963,-1,20764,20765,20965,20964,-1,20765,20766,20966,20965,-1,20766,20767,20967,20966,-1,20767,20768,20968,20967,-1,20768,20769,20969,20968,-1,20769,20770,20970,20969,-1,20770,20771,20971,20970,-1,20771,20772,20972,20971,-1,20772,20773,20973,20972,-1,20773,20774,20974,20973,-1,20774,20775,20975,20974,-1,20775,20776,20976,20975,-1,20776,20777,20977,20976,-1,20777,20778,20978,20977,-1,20778,20779,20979,20978,-1,20779,20780,20980,20979,-1,20780,20781,20981,20980,-1,20781,20782,20982,20981,-1,20782,20783,20983,20982,-1,20783,20784,20984,20983,-1,20784,20785,20985,20984,-1,20785,20786,20986,20985,-1,20786,20787,20987,20986,-1,20787,20788,20988,20987,-1,20788,20789,20989,20988,-1,20789,20790,20990,20989,-1,20790,20791,20991,20990,-1,20791,20792,20992,20991,-1,20792,20793,20993,20992,-1,20793,20794,20994,20993,-1,20794,20795,20995,20994,-1,20795,20796,20996,20995,-1,20796,20797,20997,20996,-1,20797,20798,20998,20997,-1,20798,20799,20999,20998,-1,20800,20801,21001,21,-1,20801,20802,21002,21001,-1,20802,20803,21003,21002,-1,20803,20804,21004,21003,-1,20804,20805,21005,21004,-1,20805,20806,21006,21005,-1,20806,20807,21007,21006,-1,20807,20808,21008,21007,-1,20808,20809,21009,21008,-1,20809,20810,21010,21009,-1,20810,20811,21011,21010,-1,20811,20812,21012,21011,-1,20812,20813,21013,21012,-1,20813,20814,21014,21013,-1,20814,20815,21015,21014,-1,20815,20816,21016,21015,-1,20816,20817,21017,21016,-1,20817,20818,21018,21017,-1,20818,20819,21019,21018,-1,20819,20820,21020,21019,-1,20820,20821,21021,21020,-1,20821,20822,21022,21021,-1,20822,20823,21023,21022,-1,20823,20824,21024,21023,-1,20824,20825,21025,21024,-1,20825,20826,21026,21025,-1,20826,20827,21027,21026,-1,20827,20828,21028,21027,-1,20828,20829,21029,21028,-1,20829,20830,21030,21029,-1,20830,20831,21031,21030,-1,20831,20832,21032,21031,-1,20832,20833,21033,21032,-1,20833,20834,21034,21033,-1,20834,20835,21035,21034,-1,20835,20836,21036,21035,-1,20836,20837,21037,21036,-1,20837,20838,21038,21037,-1,20838,20839,21039,21038,-1,20839,20840,21040,21039,-1,20840,20841,21041,21040,-1,20841,20842,21042,21041,-1,20842,20843,21043,21042,-1,20843,20844,21044,21043,-1,20844,20845,21045,21044,-1,20845,20846,21046,21045,-1,20846,20847,21047,21046,-1,20847,20848,21048,21047,-1,20848,20849,21049,21048,-1,20849,20850,21050,21049,-1,20850,20851,21051,21050,-1,20851,20852,21052,21051,-1,20852,20853,21053,21052,-1,20853,20854,21054,21053,-1,20854,20855,21055,21054,-1,20855,20856,21056,21055,-1,20856,20857,21057,21056,-1,20857,20858,21058,21057,-1,20858,20859,21059,21058,-1,20859,20860,21060,21059,-1,20860,20861,21061,21060,-1,20861,20862,21062,21061,-1,20862,20863,21063,21062,-1,20863,20864,21064,21063,-1,20864,20865,21065,21064,-1,20865,20866,21066,21065,-1,20866,20867,21067,21066,-1,20867,20868,21068,21067,-1,20868,20869,21069,21068,-1,20869,20870,21070,21069,-1,20870,20871,21071,21070,-1,20871,20872,21072,21071,-1,20872,20873,21073,21072,-1,20873,20874,21074,21073,-1,20874,20875,21075,21074,-1,20875,20876,21076,21075,-1,20876,20877,21077,21076,-1,20877,20878,21078,21077,-1,20878,20879,21079,21078,-1,20879,20880,21080,21079,-1,20880,20881,21081,21080,-1,20881,20882,21082,21081,-1,20882,20883,21083,21082,-1,20883,20884,21084,21083,-1,20884,20885,21085,21084,-1,20885,20886,21086,21085,-1,20886,20887,21087,21086,-1,20887,20888,21088,21087,-1,20888,20889,21089,21088,-1,20889,20890,21090,21089,-1,20890,20891,21091,21090,-1,20891,20892,21092,21091,-1,20892,20893,21093,21092,-1,20893,20894,21094,21093,-1,20894,20895,21095,21094,-1,20895,20896,21096,21095,-1,20896,20897,21097,21096,-1,20897,20898,21098,21097,-1,20898,20899,21099,21098,-1,20899,20900,21100,21099,-1,20900,20901,21101,21100,-1,20901,20902,21102,21101,-1,20902,20903,21103,21102,-1,20903,20904,21104,21103,-1,20904,20905,21105,21104,-1,20905,20906,21106,21105,-1,20906,20907,21107,21106,-1,20907,20908,21108,21107,-1,20908,20909,21109,21108,-1,20909,20910,21110,21109,-1,20910,20911,21111,21110,-1,20911,20912,21112,21111,-1,20912,20913,21113,21112,-1,20913,20914,21114,21113,-1,20914,20915,21115,21114,-1,20915,20916,21116,21115,-1,20916,20917,21117,21116,-1,20917,20918,21118,21117,-1,20918,20919,21119,21118,-1,20919,20920,21120,21119,-1,20920,20921,21121,21120,-1,20921,20922,21122,21121,-1,20922,20923,21123,21122,-1,20923,20924,21124,21123,-1,20924,20925,21125,21124,-1,20925,20926,21126,21125,-1,20926,20927,21127,21126,-1,20927,20928,21128,21127,-1,20928,20929,21129,21128,-1,20929,20930,21130,21129,-1,20930,20931,21131,21130,-1,20931,20932,21132,21131,-1,20932,20933,21133,21132,-1,20933,20934,21134,21133,-1,20934,20935,21135,21134,-1,20935,20936,21136,21135,-1,20936,20937,21137,21136,-1,20937,20938,21138,21137,-1,20938,20939,21139,21138,-1,20939,20940,21140,21139,-1,20940,20941,21141,21140,-1,20941,20942,21142,21141,-1,20942,20943,21143,21142,-1,20943,20944,21144,21143,-1,20944,20945,21145,21144,-1,20945,20946,21146,21145,-1,20946,20947,21147,21146,-1,20947,20948,21148,21147,-1,20948,20949,21149,21148,-1,20949,20950,21150,21149,-1,20950,20951,21151,21150,-1,20951,20952,21152,21151,-1,20952,20953,21153,21152,-1,20953,20954,21154,21153,-1,20954,20955,21155,21154,-1,20955,20956,21156,21155,-1,20956,20957,21157,21156,-1,20957,20958,21158,21157,-1,20958,20959,21159,21158,-1,20959,20960,21160,21159,-1,20960,20961,21161,21160,-1,20961,20962,21162,21161,-1,20962,20963,21163,21162,-1,20963,20964,21164,21163,-1,20964,20965,21165,21164,-1,20965,20966,21166,21165,-1,20966,20967,21167,21166,-1,20967,20968,21168,21167,-1,20968,20969,21169,21168,-1,20969,20970,21170,21169,-1,20970,20971,21171,21170,-1,20971,20972,21172,21171,-1,20972,20973,21173,21172,-1,20973,20974,21174,21173,-1,20974,20975,21175,21174,-1,20975,20976,21176,21175,-1,20976,20977,21177,21176,-1,20977,20978,21178,21177,-1,20978,20979,21179,21178,-1,20979,20980,21180,21179,-1,20980,20981,21181,21180,-1,20981,20982,21182,21181,-1,20982,20983,21183,21182,-1,20983,20984,21184,21183,-1,20984,20985,21185,21184,-1,20985,20986,21186,21185,-1,20986,20987,21187,21186,-1,20987,20988,21188,21187,-1,20988,20989,21189,21188,-1,20989,20990,21190,21189,-1,20990,20991,21191,21190,-1,20991,20992,21192,21191,-1,20992,20993,21193,21192,-1,20993,20994,21194,21193,-1,20994,20995,21195,21194,-1,20995,20996,21196,21195,-1,20996,20997,21197,21196,-1,20997,20998,21198,21197,-1,20998,20999,21199,21198,-1,21,21001,21201,21200,-1,21001,21002,21202,21201,-1,21002,21003,21203,21202,-1,21003,21004,21204,21203,-1,21004,21005,21205,21204,-1,21005,21006,21206,21205,-1,21006,21007,21207,21206,-1,21007,21008,21208,21207,-1,21008,21009,21209,21208,-1,21009,21010,21210,21209,-1,21010,21011,21211,21210,-1,21011,21012,21212,21211,-1,21012,21013,21213,21212,-1,21013,21014,21214,21213,-1,21014,21015,21215,21214,-1,21015,21016,21216,21215,-1,21016,21017,21217,21216,-1,21017,21018,21218,21217,-1,21018,21019,21219,21218,-1,21019,21020,21220,21219,-1,21020,21021,21221,21220,-1,21021,21022,21222,21221,-1,21022,21023,21223,21222,-1,21023,21024,21224,21223,-1,21024,21025,21225,21224,-1,21025,21026,21226,21225,-1,21026,21027,21227,21226,-1,21027,21028,21228,21227,-1,21028,21029,21229,21228,-1,21029,21030,21230,21229,-1,21030,21031,21231,21230,-1,21031,21032,21232,21231,-1,21032,21033,21233,21232,-1,21033,21034,21234,21233,-1,21034,21035,21235,21234,-1,21035,21036,21236,21235,-1,21036,21037,21237,21236,-1,21037,21038,21238,21237,-1,21038,21039,21239,21238,-1,21039,21040,21240,21239,-1,21040,21041,21241,21240,-1,21041,21042,21242,21241,-1,21042,21043,21243,21242,-1,21043,21044,21244,21243,-1,21044,21045,21245,21244,-1,21045,21046,21246,21245,-1,21046,21047,21247,21246,-1,21047,21048,21248,21247,-1,21048,21049,21249,21248,-1,21049,21050,21250,21249,-1,21050,21051,21251,21250,-1,21051,21052,21252,21251,-1,21052,21053,21253,21252,-1,21053,21054,21254,21253,-1,21054,21055,21255,21254,-1,21055,21056,21256,21255,-1,21056,21057,21257,21256,-1,21057,21058,21258,21257,-1,21058,21059,21259,21258,-1,21059,21060,21260,21259,-1,21060,21061,21261,21260,-1,21061,21062,21262,21261,-1,21062,21063,21263,21262,-1,21063,21064,21264,21263,-1,21064,21065,21265,21264,-1,21065,21066,21266,21265,-1,21066,21067,21267,21266,-1,21067,21068,21268,21267,-1,21068,21069,21269,21268,-1,21069,21070,21270,21269,-1,21070,21071,21271,21270,-1,21071,21072,21272,21271,-1,21072,21073,21273,21272,-1,21073,21074,21274,21273,-1,21074,21075,21275,21274,-1,21075,21076,21276,21275,-1,21076,21077,21277,21276,-1,21077,21078,21278,21277,-1,21078,21079,21279,21278,-1,21079,21080,21280,21279,-1,21080,21081,21281,21280,-1,21081,21082,21282,21281,-1,21082,21083,21283,21282,-1,21083,21084,21284,21283,-1,21084,21085,21285,21284,-1,21085,21086,21286,21285,-1,21086,21087,21287,21286,-1,21087,21088,21288,21287,-1,21088,21089,21289,21288,-1,21089,21090,21290,21289,-1,21090,21091,21291,21290,-1,21091,21092,21292,21291,-1,21092,21093,21293,21292,-1,21093,21094,21294,21293,-1,21094,21095,21295,21294,-1,21095,21096,21296,21295,-1,21096,21097,21297,21296,-1,21097,21098,21298,21297,-1,21098,21099,21299,21298,-1,21099,21100,21300,21299,-1,21100,21101,21301,21300,-1,21101,21102,21302,21301,-1,21102,21103,21303,21302,-1,21103,21104,21304,21303,-1,21104,21105,21305,21304,-1,21105,21106,21306,21305,-1,21106,21107,21307,21306,-1,21107,21108,21308,21307,-1,21108,21109,21309,21308,-1,21109,21110,21310,21309,-1,21110,21111,21311,21310,-1,21111,21112,21312,21311,-1,21112,21113,21313,21312,-1,21113,21114,21314,21313,-1,21114,21115,21315,21314,-1,21115,21116,21316,21315,-1,21116,21117,21317,21316,-1,21117,21118,21318,21317,-1,21118,21119,21319,21318,-1,21119,21120,21320,21319,-1,21120,21121,21321,21320,-1,21121,21122,21322,21321,-1,21122,21123,21323,21322,-1,21123,21124,21324,21323,-1,21124,21125,21325,21324,-1,21125,21126,21326,21325,-1,21126,21127,21327,21326,-1,21127,21128,21328,21327,-1,21128,21129,21329,21328,-1,21129,21130,21330,21329,-1,21130,21131,21331,21330,-1,21131,21132,21332,21331,-1,21132,21133,21333,21332,-1,21133,21134,21334,21333,-1,21134,21135,21335,21334,-1,21135,21136,21336,21335,-1,21136,21137,21337,21336,-1,21137,21138,21338,21337,-1,21138,21139,21339,21338,-1,21139,21140,21340,21339,-1,21140,21141,21341,21340,-1,21141,21142,21342,21341,-1,21142,21143,21343,21342,-1,21143,21144,21344,21343,-1,21144,21145,21345,21344,-1,21145,21146,21346,21345,-1,21146,21147,21347,21346,-1,21147,21148,21348,21347,-1,21148,21149,21349,21348,-1,21149,21150,21350,21349,-1,21150,21151,21351,21350,-1,21151,21152,21352,21351,-1,21152,21153,21353,21352,-1,21153,21154,21354,21353,-1,21154,21155,21355,21354,-1,21155,21156,21356,21355,-1,21156,21157,21357,21356,-1,21157,21158,21358,21357,-1,21158,21159,21359,21358,-1,21159,21160,21360,21359,-1,21160,21161,21361,21360,-1,21161,21162,21362,21361,-1,21162,21163,21363,21362,-1,21163,21164,21364,21363,-1,21164,21165,21365,21364,-1,21165,21166,21366,21365,-1,21166,21167,21367,21366,-1,21167,21168,21368,21367,-1,21168,21169,21369,21368,-1,21169,21170,21370,21369,-1,21170,21171,21371,21370,-1,21171,21172,21372,21371,-1,21172,21173,21373,21372,-1,21173,21174,21374,21373,-1,21174,21175,21375,21374,-1,21175,21176,21376,21375,-1,21176,21177,21377,21376,-1,21177,21178,21378,21377,-1,21178,21179,21379,21378,-1,21179,21180,21380,21379,-1,21180,21181,21381,21380,-1,21181,21182,21382,21381,-1,21182,21183,21383,21382,-1,21183,21184,21384,21383,-1,21184,21185,21385,21384,-1,21185,21186,21386,21385,-1,21186,21187,21387,21386,-1,21187,21188,21388,21387,-1,21188,21189,21389,21388,-1,21189,21190,21390,21389,-1,21190,21191,21391,21390,-1,21191,21192,21392,21391,-1,21192,21193,21393,21392,-1,21193,21194,21394,21393,-1,21194,21195,21395,21394,-1,21195,21196,21396,21395,-1,21196,21197,21397,21396,-1,21197,21198,21398,21397,-1,21198,21199,21399,21398,-1,21200,21201,21401,21400,-1,21201,21202,21402,21401,-1,21202,21203,21403,21402,-1,21203,21204,21404,21403,-1,21204,21205,21405,21404,-1,21205,21206,21406,21405,-1,21206,21207,21407,21406,-1,21207,21208,21408,21407,-1,21208,21209,21409,21408,-1,21209,21210,21410,21409,-1,21210,21211,21411,21410,-1,21211,21212,21412,21411,-1,21212,21213,21413,21412,-1,21213,21214,21414,21413,-1,21214,21215,21415,21414,-1,21215,21216,21416,21415,-1,21216,21217,21417,21416,-1,21217,21218,21418,21417,-1,21218,21219,21419,21418,-1,21219,21220,21420,21419,-1,21220,21221,21421,21420,-1,21221,21222,21422,21421,-1,21222,21223,21423,21422,-1,21223,21224,21424,21423,-1,21224,21225,21425,21424,-1,21225,21226,21426,21425,-1,21226,21227,21427,21426,-1,21227,21228,21428,21427,-1,21228,21229,21429,21428,-1,21229,21230,21430,21429,-1,21230,21231,21431,21430,-1,21231,21232,21432,21431,-1,21232,21233,21433,21432,-1,21233,21234,21434,21433,-1,21234,21235,21435,21434,-1,21235,21236,21436,21435,-1,21236,21237,21437,21436,-1,21237,21238,21438,21437,-1,21238,21239,21439,21438,-1,21239,21240,21440,21439,-1,21240,21241,21441,21440,-1,21241,21242,21442,21441,-1,21242,21243,21443,21442,-1,21243,21244,21444,21443,-1,21244,21245,21445,21444,-1,21245,21246,21446,21445,-1,21246,21247,21447,21446,-1,21247,21248,21448,21447,-1,21248,21249,21449,21448,-1,21249,21250,21450,21449,-1,21250,21251,21451,21450,-1,21251,21252,21452,21451,-1,21252,21253,21453,21452,-1,21253,21254,21454,21453,-1,21254,21255,21455,21454,-1,21255,21256,21456,21455,-1,21256,21257,21457,21456,-1,21257,21258,21458,21457,-1,21258,21259,21459,21458,-1,21259,21260,21460,21459,-1,21260,21261,21461,21460,-1,21261,21262,21462,21461,-1,21262,21263,21463,21462,-1,21263,21264,21464,21463,-1,21264,21265,21465,21464,-1,21265,21266,21466,21465,-1,21266,21267,21467,21466,-1,21267,21268,21468,21467,-1,21268,21269,21469,21468,-1,21269,21270,21470,21469,-1,21270,21271,21471,21470,-1,21271,21272,21472,21471,-1,21272,21273,21473,21472,-1,21273,21274,21474,21473,-1,21274,21275,21475,21474,-1,21275,21276,21476,21475,-1,21276,21277,21477,21476,-1,21277,21278,21478,21477,-1,21278,21279,21479,21478,-1,21279,21280,21480,21479,-1,21280,21281,21481,21480,-1,21281,21282,21482,21481,-1,21282,21283,21483,21482,-1,21283,21284,21484,21483,-1,21284,21285,21485,21484,-1,21285,21286,21486,21485,-1,21286,21287,21487,21486,-1,21287,21288,21488,21487,-1,21288,21289,21489,21488,-1,21289,21290,21490,21489,-1,21290,21291,21491,21490,-1,21291,21292,21492,21491,-1,21292,21293,21493,21492,-1,21293,21294,21494,21493,-1,21294,21295,21495,21494,-1,21295,21296,21496,21495,-1,21296,21297,21497,21496,-1,21297,21298,21498,21497,-1,21298,21299,21499,21498,-1,21299,21300,21500,21499,-1,21300,21301,21501,21500,-1,21301,21302,21502,21501,-1,21302,21303,21503,21502,-1,21303,21304,21504,21503,-1,21304,21305,21505,21504,-1,21305,21306,21506,21505,-1,21306,21307,21507,21506,-1,21307,21308,21508,21507,-1,21308,21309,21509,21508,-1,21309,21310,21510,21509,-1,21310,21311,21511,21510,-1,21311,21312,21512,21511,-1,21312,21313,21513,21512,-1,21313,21314,21514,21513,-1,21314,21315,21515,21514,-1,21315,21316,21516,21515,-1,21316,21317,21517,21516,-1,21317,21318,21518,21517,-1,21318,21319,21519,21518,-1,21319,21320,21520,21519,-1,21320,21321,21521,21520,-1,21321,21322,21522,21521,-1,21322,21323,21523,21522,-1,21323,21324,21524,21523,-1,21324,21325,21525,21524,-1,21325,21326,21526,21525,-1,21326,21327,21527,21526,-1,21327,21328,21528,21527,-1,21328,21329,21529,21528,-1,21329,21330,21530,21529,-1,21330,21331,21531,21530,-1,21331,21332,21532,21531,-1,21332,21333,21533,21532,-1,21333,21334,21534,21533,-1,21334,21335,21535,21534,-1,21335,21336,21536,21535,-1,21336,21337,21537,21536,-1,21337,21338,21538,21537,-1,21338,21339,21539,21538,-1,21339,21340,21540,21539,-1,21340,21341,21541,21540,-1,21341,21342,21542,21541,-1,21342,21343,21543,21542,-1,21343,21344,21544,21543,-1,21344,21345,21545,21544,-1,21345,21346,21546,21545,-1,21346,21347,21547,21546,-1,21347,21348,21548,21547,-1,21348,21349,21549,21548,-1,21349,21350,21550,21549,-1,21350,21351,21551,21550,-1,21351,21352,21552,21551,-1,21352,21353,21553,21552,-1,21353,21354,21554,21553,-1,21354,21355,21555,21554,-1,21355,21356,21556,21555,-1,21356,21357,21557,21556,-1,21357,21358,21558,21557,-1,21358,21359,21559,21558,-1,21359,21360,21560,21559,-1,21360,21361,21561,21560,-1,21361,21362,21562,21561,-1,21362,21363,21563,21562,-1,21363,21364,21564,21563,-1,21364,21365,21565,21564,-1,21365,21366,21566,21565,-1,21366,21367,21567,21566,-1,21367,21368,21568,21567,-1,21368,21369,21569,21568,-1,21369,21370,21570,21569,-1,21370,21371,21571,21570,-1,21371,21372,21572,21571,-1,21372,21373,21573,21572,-1,21373,21374,21574,21573,-1,21374,21375,21575,21574,-1,21375,21376,21576,21575,-1,21376,21377,21577,21576,-1,21377,21378,21578,21577,-1,21378,21379,21579,21578,-1,21379,21380,21580,21579,-1,21380,21381,21581,21580,-1,21381,21382,21582,21581,-1,21382,21383,21583,21582,-1,21383,21384,21584,21583,-1,21384,21385,21585,21584,-1,21385,21386,21586,21585,-1,21386,21387,21587,21586,-1,21387,21388,21588,21587,-1,21388,21389,21589,21588,-1,21389,21390,21590,21589,-1,21390,21391,21591,21590,-1,21391,21392,21592,21591,-1,21392,21393,21593,21592,-1,21393,21394,21594,21593,-1,21394,21395,21595,21594,-1,21395,21396,21596,21595,-1,21396,21397,21597,21596,-1,21397,21398,21598,21597,-1,21398,21399,21599,21598,-1,21400,21401,21601,21600,-1,21401,21402,21602,21601,-1,21402,21403,21603,21602,-1,21403,21404,21604,21603,-1,21404,21405,21605,21604,-1,21405,21406,21606,21605,-1,21406,21407,21607,21606,-1,21407,21408,21608,21607,-1,21408,21409,21609,21608,-1,21409,21410,21610,21609,-1,21410,21411,21611,21610,-1,21411,21412,21612,21611,-1,21412,21413,21613,21612,-1,21413,21414,21614,21613,-1,21414,21415,21615,21614,-1,21415,21416,21616,21615,-1,21416,21417,21617,21616,-1,21417,21418,21618,21617,-1,21418,21419,21619,21618,-1,21419,21420,21620,21619,-1,21420,21421,21621,21620,-1,21421,21422,21622,21621,-1,21422,21423,21623,21622,-1,21423,21424,21624,21623,-1,21424,21425,21625,21624,-1,21425,21426,21626,21625,-1,21426,21427,21627,21626,-1,21427,21428,21628,21627,-1,21428,21429,21629,21628,-1,21429,21430,21630,21629,-1,21430,21431,21631,21630,-1,21431,21432,21632,21631,-1,21432,21433,21633,21632,-1,21433,21434,21634,21633,-1,21434,21435,21635,21634,-1,21435,21436,21636,21635,-1,21436,21437,21637,21636,-1,21437,21438,21638,21637,-1,21438,21439,21639,21638,-1,21439,21440,21640,21639,-1,21440,21441,21641,21640,-1,21441,21442,21642,21641,-1,21442,21443,21643,21642,-1,21443,21444,21644,21643,-1,21444,21445,21645,21644,-1,21445,21446,21646,21645,-1,21446,21447,21647,21646,-1,21447,21448,21648,21647,-1,21448,21449,21649,21648,-1,21449,21450,21650,21649,-1,21450,21451,21651,21650,-1,21451,21452,21652,21651,-1,21452,21453,21653,21652,-1,21453,21454,21654,21653,-1,21454,21455,21655,21654,-1,21455,21456,21656,21655,-1,21456,21457,21657,21656,-1,21457,21458,21658,21657,-1,21458,21459,21659,21658,-1,21459,21460,21660,21659,-1,21460,21461,21661,21660,-1,21461,21462,21662,21661,-1,21462,21463,21663,21662,-1,21463,21464,21664,21663,-1,21464,21465,21665,21664,-1,21465,21466,21666,21665,-1,21466,21467,21667,21666,-1,21467,21468,21668,21667,-1,21468,21469,21669,21668,-1,21469,21470,21670,21669,-1,21470,21471,21671,21670,-1,21471,21472,21672,21671,-1,21472,21473,21673,21672,-1,21473,21474,21674,21673,-1,21474,21475,21675,21674,-1,21475,21476,21676,21675,-1,21476,21477,21677,21676,-1,21477,21478,21678,21677,-1,21478,21479,21679,21678,-1,21479,21480,21680,21679,-1,21480,21481,21681,21680,-1,21481,21482,21682,21681,-1,21482,21483,21683,21682,-1,21483,21484,21684,21683,-1,21484,21485,21685,21684,-1,21485,21486,21686,21685,-1,21486,21487,21687,21686,-1,21487,21488,21688,21687,-1,21488,21489,21689,21688,-1,21489,21490,21690,21689,-1,21490,21491,21691,21690,-1,21491,21492,21692,21691,-1,21492,21493,21693,21692,-1,21493,21494,21694,21693,-1,21494,21495,21695,21694,-1,21495,21496,21696,21695,-1,21496,21497,21697,21696,-1,21497,21498,21698,21697,-1,21498,21499,21699,21698,-1,21499,21500,21700,21699,-1,21500,21501,21701,21700,-1,21501,21502,21702,21701,-1,21502,21503,21703,21702,-1,21503,21504,21704,21703,-1,21504,21505,21705,21704,-1,21505,21506,21706,21705,-1,21506,21507,21707,21706,-1,21507,21508,21708,21707,-1,21508,21509,21709,21708,-1,21509,21510,21710,21709,-1,21510,21511,21711,21710,-1,21511,21512,21712,21711,-1,21512,21513,21713,21712,-1,21513,21514,21714,21713,-1,21514,21515,21715,21714,-1,21515,21516,21716,21715,-1,21516,21517,21717,21716,-1,21517,21518,21718,21717,-1,21518,21519,21719,21718,-1,21519,21520,21720,21719,-1,21520,21521,21721,21720,-1,21521,21522,21722,21721,-1,21522,21523,21723,21722,-1,21523,21524,21724,21723,-1,21524,21525,21725,21724,-1,21525,21526,21726,21725,-1,21526,21527,21727,21726,-1,21527,21528,21728,21727,-1,21528,21529,21729,21728,-1,21529,21530,21730,21729,-1,21530,21531,21731,21730,-1,21531,21532,21732,21731,-1,21532,21533,21733,21732,-1,21533,21534,21734,21733,-1,21534,21535,21735,21734,-1,21535,21536,21736,21735,-1,21536,21537,21737,21736,-1,21537,21538,21738,21737,-1,21538,21539,21739,21738,-1,21539,21540,21740,21739,-1,21540,21541,21741,21740,-1,21541,21542,21742,21741,-1,21542,21543,21743,21742,-1,21543,21544,21744,21743,-1,21544,21545,21745,21744,-1,21545,21546,21746,21745,-1,21546,21547,21747,21746,-1,21547,21548,21748,21747,-1,21548,21549,21749,21748,-1,21549,21550,21750,21749,-1,21550,21551,21751,21750,-1,21551,21552,21752,21751,-1,21552,21553,21753,21752,-1,21553,21554,21754,21753,-1,21554,21555,21755,21754,-1,21555,21556,21756,21755,-1,21556,21557,21757,21756,-1,21557,21558,21758,21757,-1,21558,21559,21759,21758,-1,21559,21560,21760,21759,-1,21560,21561,21761,21760,-1,21561,21562,21762,21761,-1,21562,21563,21763,21762,-1,21563,21564,21764,21763,-1,21564,21565,21765,21764,-1,21565,21566,21766,21765,-1,21566,21567,21767,21766,-1,21567,21568,21768,21767,-1,21568,21569,21769,21768,-1,21569,21570,21770,21769,-1,21570,21571,21771,21770,-1,21571,21572,21772,21771,-1,21572,21573,21773,21772,-1,21573,21574,21774,21773,-1,21574,21575,21775,21774,-1,21575,21576,21776,21775,-1,21576,21577,21777,21776,-1,21577,21578,21778,21777,-1,21578,21579,21779,21778,-1,21579,21580,21780,21779,-1,21580,21581,21781,21780,-1,21581,21582,21782,21781,-1,21582,21583,21783,21782,-1,21583,21584,21784,21783,-1,21584,21585,21785,21784,-1,21585,21586,21786,21785,-1,21586,21587,21787,21786,-1,21587,21588,21788,21787,-1,21588,21589,21789,21788,-1,21589,21590,21790,21789,-1,21590,21591,21791,21790,-1,21591,21592,21792,21791,-1,21592,21593,21793,21792,-1,21593,21594,21794,21793,-1,21594,21595,21795,21794,-1,21595,21596,21796,21795,-1,21596,21597,21797,21796,-1,21597,21598,21798,21797,-1,21598,21599,21799,21798,-1,21600,21601,21801,21800,-1,21601,21602,21802,21801,-1,21602,21603,21803,21802,-1,21603,21604,21804,21803,-1,21604,21605,21805,21804,-1,21605,21606,21806,21805,-1,21606,21607,21807,21806,-1,21607,21608,21808,21807,-1,21608,21609,21809,21808,-1,21609,21610,21810,21809,-1,21610,21611,21811,21810,-1,21611,21612,21812,21811,-1,21612,21613,21813,21812,-1,21613,21614,21814,21813,-1,21614,21615,21815,21814,-1,21615,21616,21816,21815,-1,21616,21617,21817,21816,-1,21617,21618,21818,21817,-1,21618,21619,21819,21818,-1,21619,21620,21820,21819,-1,21620,21621,21821,21820,-1,21621,21622,21822,21821,-1,21622,21623,21823,21822,-1,21623,21624,21824,21823,-1,21624,21625,21825,21824,-1,21625,21626,21826,21825,-1,21626,21627,21827,21826,-1,21627,21628,21828,21827,-1,21628,21629,21829,21828,-1,21629,21630,21830,21829,-1,21630,21631,21831,21830,-1,21631,21632,21832,21831,-1,21632,21633,21833,21832,-1,21633,21634,21834,21833,-1,21634,21635,21835,21834,-1,21635,21636,21836,21835,-1,21636,21637,21837,21836,-1,21637,21638,21838,21837,-1,21638,21639,21839,21838,-1,21639,21640,21840,21839,-1,21640,21641,21841,21840,-1,21641,21642,21842,21841,-1,21642,21643,21843,21842,-1,21643,21644,21844,21843,-1,21644,21645,21845,21844,-1,21645,21646,21846,21845,-1,21646,21647,21847,21846,-1,21647,21648,21848,21847,-1,21648,21649,21849,21848,-1,21649,21650,21850,21849,-1,21650,21651,21851,21850,-1,21651,21652,21852,21851,-1,21652,21653,21853,21852,-1,21653,21654,21854,21853,-1,21654,21655,21855,21854,-1,21655,21656,21856,21855,-1,21656,21657,21857,21856,-1,21657,21658,21858,21857,-1,21658,21659,21859,21858,-1,21659,21660,21860,21859,-1,21660,21661,21861,21860,-1,21661,21662,21862,21861,-1,21662,21663,21863,21862,-1,21663,21664,21864,21863,-1,21664,21665,21865,21864,-1,21665,21666,21866,21865,-1,21666,21667,21867,21866,-1,21667,21668,21868,21867,-1,21668,21669,21869,21868,-1,21669,21670,21870,21869,-1,21670,21671,21871,21870,-1,21671,21672,21872,21871,-1,21672,21673,21873,21872,-1,21673,21674,21874,21873,-1,21674,21675,21875,21874,-1,21675,21676,21876,21875,-1,21676,21677,21877,21876,-1,21677,21678,21878,21877,-1,21678,21679,21879,21878,-1,21679,21680,21880,21879,-1,21680,21681,21881,21880,-1,21681,21682,21882,21881,-1,21682,21683,21883,21882,-1,21683,21684,21884,21883,-1,21684,21685,21885,21884,-1,21685,21686,21886,21885,-1,21686,21687,21887,21886,-1,21687,21688,21888,21887,-1,21688,21689,21889,21888,-1,21689,21690,21890,21889,-1,21690,21691,21891,21890,-1,21691,21692,21892,21891,-1,21692,21693,21893,21892,-1,21693,21694,21894,21893,-1,21694,21695,21895,21894,-1,21695,21696,21896,21895,-1,21696,21697,21897,21896,-1,21697,21698,21898,21897,-1,21698,21699,21899,21898,-1,21699,21700,21900,21899,-1,21700,21701,21901,21900,-1,21701,21702,21902,21901,-1,21702,21703,21903,21902,-1,21703,21704,21904,21903,-1,21704,21705,21905,21904,-1,21705,21706,21906,21905,-1,21706,21707,21907,21906,-1,21707,21708,21908,21907,-1,21708,21709,21909,21908,-1,21709,21710,21910,21909,-1,21710,21711,21911,21910,-1,21711,21712,21912,21911,-1,21712,21713,21913,21912,-1,21713,21714,21914,21913,-1,21714,21715,21915,21914,-1,21715,21716,21916,21915,-1,21716,21717,21917,21916,-1,21717,21718,21918,21917,-1,21718,21719,21919,21918,-1,21719,21720,21920,21919,-1,21720,21721,21921,21920,-1,21721,21722,21922,21921,-1,21722,21723,21923,21922,-1,21723,21724,21924,21923,-1,21724,21725,21925,21924,-1,21725,21726,21926,21925,-1,21726,21727,21927,21926,-1,21727,21728,21928,21927,-1,21728,21729,21929,21928,-1,21729,21730,21930,21929,-1,21730,21731,21931,21930,-1,21731,21732,21932,21931,-1,21732,21733,21933,21932,-1,21733,21734,21934,21933,-1,21734,21735,21935,21934,-1,21735,21736,21936,21935,-1,21736,21737,21937,21936,-1,21737,21738,21938,21937,-1,21738,21739,21939,21938,-1,21739,21740,21940,21939,-1,21740,21741,21941,21940,-1,21741,21742,21942,21941,-1,21742,21743,21943,21942,-1,21743,21744,21944,21943,-1,21744,21745,21945,21944,-1,21745,21746,21946,21945,-1,21746,21747,21947,21946,-1,21747,21748,21948,21947,-1,21748,21749,21949,21948,-1,21749,21750,21950,21949,-1,21750,21751,21951,21950,-1,21751,21752,21952,21951,-1,21752,21753,21953,21952,-1,21753,21754,21954,21953,-1,21754,21755,21955,21954,-1,21755,21756,21956,21955,-1,21756,21757,21957,21956,-1,21757,21758,21958,21957,-1,21758,21759,21959,21958,-1,21759,21760,21960,21959,-1,21760,21761,21961,21960,-1,21761,21762,21962,21961,-1,21762,21763,21963,21962,-1,21763,21764,21964,21963,-1,21764,21765,21965,21964,-1,21765,21766,21966,21965,-1,21766,21767,21967,21966,-1,21767,21768,21968,21967,-1,21768,21769,21969,21968,-1,21769,21770,21970,21969,-1,21770,21771,21971,21970,-1,21771,21772,21972,21971,-1,21772,21773,21973,21972,-1,21773,21774,21974,21973,-1,21774,21775,21975,21974,-1,21775,21776,21976,21975,-1,21776,21777,21977,21976,-1,21777,21778,21978,21977,-1,21778,21779,21979,21978,-1,21779,21780,21980,21979,-1,21780,21781,21981,21980,-1,21781,21782,21982,21981,-1,21782,21783,21983,21982,-1,21783,21784,21984,21983,-1,21784,21785,21985,21984,-1,21785,21786,21986,21985,-1,21786,21787,21987,21986,-1,21787,21788,21988,21987,-1,21788,21789,21989,21988,-1,21789,21790,21990,21989,-1,21790,21791,21991,21990,-1,21791,21792,21992,21991,-1,21792,21793,21993,21992,-1,21793,21794,21994,21993,-1,21794,21795,21995,21994,-1,21795,21796,21996,21995,-1,21796,21797,21997,21996,-1,21797,21798,21998,21997,-1,21798,21799,21999,21998,-1,21800,21801,22001,22,-1,21801,21802,22002,22001,-1,21802,21803,22003,22002,-1,21803,21804,22004,22003,-1,21804,21805,22005,22004,-1,21805,21806,22006,22005,-1,21806,21807,22007,22006,-1,21807,21808,22008,22007,-1,21808,21809,22009,22008,-1,21809,21810,22010,22009,-1,21810,21811,22011,22010,-1,21811,21812,22012,22011,-1,21812,21813,22013,22012,-1,21813,21814,22014,22013,-1,21814,21815,22015,22014,-1,21815,21816,22016,22015,-1,21816,21817,22017,22016,-1,21817,21818,22018,22017,-1,21818,21819,22019,22018,-1,21819,21820,22020,22019,-1,21820,21821,22021,22020,-1,21821,21822,22022,22021,-1,21822,21823,22023,22022,-1,21823,21824,22024,22023,-1,21824,21825,22025,22024,-1,21825,21826,22026,22025,-1,21826,21827,22027,22026,-1,21827,21828,22028,22027,-1,21828,21829,22029,22028,-1,21829,21830,22030,22029,-1,21830,21831,22031,22030,-1,21831,21832,22032,22031,-1,21832,21833,22033,22032,-1,21833,21834,22034,22033,-1,21834,21835,22035,22034,-1,21835,21836,22036,22035,-1,21836,21837,22037,22036,-1,21837,21838,22038,22037,-1,21838,21839,22039,22038,-1,21839,21840,22040,22039,-1,21840,21841,22041,22040,-1,21841,21842,22042,22041,-1,21842,21843,22043,22042,-1,21843,21844,22044,22043,-1,21844,21845,22045,22044,-1,21845,21846,22046,22045,-1,21846,21847,22047,22046,-1,21847,21848,22048,22047,-1,21848,21849,22049,22048,-1,21849,21850,22050,22049,-1,21850,21851,22051,22050,-1,21851,21852,22052,22051,-1,21852,21853,22053,22052,-1,21853,21854,22054,22053,-1,21854,21855,22055,22054,-1,21855,21856,22056,22055,-1,21856,21857,22057,22056,-1,21857,21858,22058,22057,-1,21858,21859,22059,22058,-1,21859,21860,22060,22059,-1,21860,21861,22061,22060,-1,21861,21862,22062,22061,-1,21862,21863,22063,22062,-1,21863,21864,22064,22063,-1,21864,21865,22065,22064,-1,21865,21866,22066,22065,-1,21866,21867,22067,22066,-1,21867,21868,22068,22067,-1,21868,21869,22069,22068,-1,21869,21870,22070,22069,-1,21870,21871,22071,22070,-1,21871,21872,22072,22071,-1,21872,21873,22073,22072,-1,21873,21874,22074,22073,-1,21874,21875,22075,22074,-1,21875,21876,22076,22075,-1,21876,21877,22077,22076,-1,21877,21878,22078,22077,-1,21878,21879,22079,22078,-1,21879,21880,22080,22079,-1,21880,21881,22081,22080,-1,21881,21882,22082,22081,-1,21882,21883,22083,22082,-1,21883,21884,22084,22083,-1,21884,21885,22085,22084,-1,21885,21886,22086,22085,-1,21886,21887,22087,22086,-1,21887,21888,22088,22087,-1,21888,21889,22089,22088,-1,21889,21890,22090,22089,-1,21890,21891,22091,22090,-1,21891,21892,22092,22091,-1,21892,21893,22093,22092,-1,21893,21894,22094,22093,-1,21894,21895,22095,22094,-1,21895,21896,22096,22095,-1,21896,21897,22097,22096,-1,21897,21898,22098,22097,-1,21898,21899,22099,22098,-1,21899,21900,22100,22099,-1,21900,21901,22101,22100,-1,21901,21902,22102,22101,-1,21902,21903,22103,22102,-1,21903,21904,22104,22103,-1,21904,21905,22105,22104,-1,21905,21906,22106,22105,-1,21906,21907,22107,22106,-1,21907,21908,22108,22107,-1,21908,21909,22109,22108,-1,21909,21910,22110,22109,-1,21910,21911,22111,22110,-1,21911,21912,22112,22111,-1,21912,21913,22113,22112,-1,21913,21914,22114,22113,-1,21914,21915,22115,22114,-1,21915,21916,22116,22115,-1,21916,21917,22117,22116,-1,21917,21918,22118,22117,-1,21918,21919,22119,22118,-1,21919,21920,22120,22119,-1,21920,21921,22121,22120,-1,21921,21922,22122,22121,-1,21922,21923,22123,22122,-1,21923,21924,22124,22123,-1,21924,21925,22125,22124,-1,21925,21926,22126,22125,-1,21926,21927,22127,22126,-1,21927,21928,22128,22127,-1,21928,21929,22129,22128,-1,21929,21930,22130,22129,-1,21930,21931,22131,22130,-1,21931,21932,22132,22131,-1,21932,21933,22133,22132,-1,21933,21934,22134,22133,-1,21934,21935,22135,22134,-1,21935,21936,22136,22135,-1,21936,21937,22137,22136,-1,21937,21938,22138,22137,-1,21938,21939,22139,22138,-1,21939,21940,22140,22139,-1,21940,21941,22141,22140,-1,21941,21942,22142,22141,-1,21942,21943,22143,22142,-1,21943,21944,22144,22143,-1,21944,21945,22145,22144,-1,21945,21946,22146,22145,-1,21946,21947,22147,22146,-1,21947,21948,22148,22147,-1,21948,21949,22149,22148,-1,21949,21950,22150,22149,-1,21950,21951,22151,22150,-1,21951,21952,22152,22151,-1,21952,21953,22153,22152,-1,21953,21954,22154,22153,-1,21954,21955,22155,22154,-1,21955,21956,22156,22155,-1,21956,21957,22157,22156,-1,21957,21958,22158,22157,-1,21958,21959,22159,22158,-1,21959,21960,22160,22159,-1,21960,21961,22161,22160,-1,21961,21962,22162,22161,-1,21962,21963,22163,22162,-1,21963,21964,22164,22163,-1,21964,21965,22165,22164,-1,21965,21966,22166,22165,-1,21966,21967,22167,22166,-1,21967,21968,22168,22167,-1,21968,21969,22169,22168,-1,21969,21970,22170,22169,-1,21970,21971,22171,22170,-1,21971,21972,22172,22171,-1,21972,21973,22173,22172,-1,21973,21974,22174,22173,-1,21974,21975,22175,22174,-1,21975,21976,22176,22175,-1,21976,21977,22177,22176,-1,21977,21978,22178,22177,-1,21978,21979,22179,22178,-1,21979,21980,22180,22179,-1,21980,21981,22181,22180,-1,21981,21982,22182,22181,-1,21982,21983,22183,22182,-1,21983,21984,22184,22183,-1,21984,21985,22185,22184,-1,21985,21986,22186,22185,-1,21986,21987,22187,22186,-1,21987,21988,22188,22187,-1,21988,21989,22189,22188,-1,21989,21990,22190,22189,-1,21990,21991,22191,22190,-1,21991,21992,22192,22191,-1,21992,21993,22193,22192,-1,21993,21994,22194,22193,-1,21994,21995,22195,22194,-1,21995,21996,22196,22195,-1,21996,21997,22197,22196,-1,21997,21998,22198,22197,-1,21998,21999,22199,22198,-1,22,22001,22201,22200,-1,22001,22002,22202,22201,-1,22002,22003,22203,22202,-1,22003,22004,22204,22203,-1,22004,22005,22205,22204,-1,22005,22006,22206,22205,-1,22006,22007,22207,22206,-1,22007,22008,22208,22207,-1,22008,22009,22209,22208,-1,22009,22010,22210,22209,-1,22010,22011,22211,22210,-1,22011,22012,22212,22211,-1,22012,22013,22213,22212,-1,22013,22014,22214,22213,-1,22014,22015,22215,22214,-1,22015,22016,22216,22215,-1,22016,22017,22217,22216,-1,22017,22018,22218,22217,-1,22018,22019,22219,22218,-1,22019,22020,22220,22219,-1,22020,22021,22221,22220,-1,22021,22022,22222,22221,-1,22022,22023,22223,22222,-1,22023,22024,22224,22223,-1,22024,22025,22225,22224,-1,22025,22026,22226,22225,-1,22026,22027,22227,22226,-1,22027,22028,22228,22227,-1,22028,22029,22229,22228,-1,22029,22030,22230,22229,-1,22030,22031,22231,22230,-1,22031,22032,22232,22231,-1,22032,22033,22233,22232,-1,22033,22034,22234,22233,-1,22034,22035,22235,22234,-1,22035,22036,22236,22235,-1,22036,22037,22237,22236,-1,22037,22038,22238,22237,-1,22038,22039,22239,22238,-1,22039,22040,22240,22239,-1,22040,22041,22241,22240,-1,22041,22042,22242,22241,-1,22042,22043,22243,22242,-1,22043,22044,22244,22243,-1,22044,22045,22245,22244,-1,22045,22046,22246,22245,-1,22046,22047,22247,22246,-1,22047,22048,22248,22247,-1,22048,22049,22249,22248,-1,22049,22050,22250,22249,-1,22050,22051,22251,22250,-1,22051,22052,22252,22251,-1,22052,22053,22253,22252,-1,22053,22054,22254,22253,-1,22054,22055,22255,22254,-1,22055,22056,22256,22255,-1,22056,22057,22257,22256,-1,22057,22058,22258,22257,-1,22058,22059,22259,22258,-1,22059,22060,22260,22259,-1,22060,22061,22261,22260,-1,22061,22062,22262,22261,-1,22062,22063,22263,22262,-1,22063,22064,22264,22263,-1,22064,22065,22265,22264,-1,22065,22066,22266,22265,-1,22066,22067,22267,22266,-1,22067,22068,22268,22267,-1,22068,22069,22269,22268,-1,22069,22070,22270,22269,-1,22070,22071,22271,22270,-1,22071,22072,22272,22271,-1,22072,22073,22273,22272,-1,22073,22074,22274,22273,-1,22074,22075,22275,22274,-1,22075,22076,22276,22275,-1,22076,22077,22277,22276,-1,22077,22078,22278,22277,-1,22078,22079,22279,22278,-1,22079,22080,22280,22279,-1,22080,22081,22281,22280,-1,22081,22082,22282,22281,-1,22082,22083,22283,22282,-1,22083,22084,22284,22283,-1,22084,22085,22285,22284,-1,22085,22086,22286,22285,-1,22086,22087,22287,22286,-1,22087,22088,22288,22287,-1,22088,22089,22289,22288,-1,22089,22090,22290,22289,-1,22090,22091,22291,22290,-1,22091,22092,22292,22291,-1,22092,22093,22293,22292,-1,22093,22094,22294,22293,-1,22094,22095,22295,22294,-1,22095,22096,22296,22295,-1,22096,22097,22297,22296,-1,22097,22098,22298,22297,-1,22098,22099,22299,22298,-1,22099,22100,22300,22299,-1,22100,22101,22301,22300,-1,22101,22102,22302,22301,-1,22102,22103,22303,22302,-1,22103,22104,22304,22303,-1,22104,22105,22305,22304,-1,22105,22106,22306,22305,-1,22106,22107,22307,22306,-1,22107,22108,22308,22307,-1,22108,22109,22309,22308,-1,22109,22110,22310,22309,-1,22110,22111,22311,22310,-1,22111,22112,22312,22311,-1,22112,22113,22313,22312,-1,22113,22114,22314,22313,-1,22114,22115,22315,22314,-1,22115,22116,22316,22315,-1,22116,22117,22317,22316,-1,22117,22118,22318,22317,-1,22118,22119,22319,22318,-1,22119,22120,22320,22319,-1,22120,22121,22321,22320,-1,22121,22122,22322,22321,-1,22122,22123,22323,22322,-1,22123,22124,22324,22323,-1,22124,22125,22325,22324,-1,22125,22126,22326,22325,-1,22126,22127,22327,22326,-1,22127,22128,22328,22327,-1,22128,22129,22329,22328,-1,22129,22130,22330,22329,-1,22130,22131,22331,22330,-1,22131,22132,22332,22331,-1,22132,22133,22333,22332,-1,22133,22134,22334,22333,-1,22134,22135,22335,22334,-1,22135,22136,22336,22335,-1,22136,22137,22337,22336,-1,22137,22138,22338,22337,-1,22138,22139,22339,22338,-1,22139,22140,22340,22339,-1,22140,22141,22341,22340,-1,22141,22142,22342,22341,-1,22142,22143,22343,22342,-1,22143,22144,22344,22343,-1,22144,22145,22345,22344,-1,22145,22146,22346,22345,-1,22146,22147,22347,22346,-1,22147,22148,22348,22347,-1,22148,22149,22349,22348,-1,22149,22150,22350,22349,-1,22150,22151,22351,22350,-1,22151,22152,22352,22351,-1,22152,22153,22353,22352,-1,22153,22154,22354,22353,-1,22154,22155,22355,22354,-1,22155,22156,22356,22355,-1,22156,22157,22357,22356,-1,22157,22158,22358,22357,-1,22158,22159,22359,22358,-1,22159,22160,22360,22359,-1,22160,22161,22361,22360,-1,22161,22162,22362,22361,-1,22162,22163,22363,22362,-1,22163,22164,22364,22363,-1,22164,22165,22365,22364,-1,22165,22166,22366,22365,-1,22166,22167,22367,22366,-1,22167,22168,22368,22367,-1,22168,22169,22369,22368,-1,22169,22170,22370,22369,-1,22170,22171,22371,22370,-1,22171,22172,22372,22371,-1,22172,22173,22373,22372,-1,22173,22174,22374,22373,-1,22174,22175,22375,22374,-1,22175,22176,22376,22375,-1,22176,22177,22377,22376,-1,22177,22178,22378,22377,-1,22178,22179,22379,22378,-1,22179,22180,22380,22379,-1,22180,22181,22381,22380,-1,22181,22182,22382,22381,-1,22182,22183,22383,22382,-1,22183,22184,22384,22383,-1,22184,22185,22385,22384,-1,22185,22186,22386,22385,-1,22186,22187,22387,22386,-1,22187,22188,22388,22387,-1,22188,22189,22389,22388,-1,22189,22190,22390,22389,-1,22190,22191,22391,22390,-1,22191,22192,22392,22391,-1,22192,22193,22393,22392,-1,22193,22194,22394,22393,-1,22194,22195,22395,22394,-1,22195,22196,22396,22395,-1,22196,22197,22397,22396,-1,22197,22198,22398,22397,-1,22198,22199,22399,22398,-1,22200,22201,22401,22400,-1,22201,22202,22402,22401,-1,22202,22203,22403,22402,-1,22203,22204,22404,22403,-1,22204,22205,22405,22404,-1,22205,22206,22406,22405,-1,22206,22207,22407,22406,-1,22207,22208,22408,22407,-1,22208,22209,22409,22408,-1,22209,22210,22410,22409,-1,22210,22211,22411,22410,-1,22211,22212,22412,22411,-1,22212,22213,22413,22412,-1,22213,22214,22414,22413,-1,22214,22215,22415,22414,-1,22215,22216,22416,22415,-1,22216,22217,22417,22416,-1,22217,22218,22418,22417,-1,22218,22219,22419,22418,-1,22219,22220,22420,22419,-1,22220,22221,22421,22420,-1,22221,22222,22422,22421,-1,22222,22223,22423,22422,-1,22223,22224,22424,22423,-1,22224,22225,22425,22424,-1,22225,22226,22426,22425,-1,22226,22227,22427,22426,-1,22227,22228,22428,22427,-1,22228,22229,22429,22428,-1,22229,22230,22430,22429,-1,22230,22231,22431,22430,-1,22231,22232,22432,22431,-1,22232,22233,22433,22432,-1,22233,22234,22434,22433,-1,22234,22235,22435,22434,-1,22235,22236,22436,22435,-1,22236,22237,22437,22436,-1,22237,22238,22438,22437,-1,22238,22239,22439,22438,-1,22239,22240,22440,22439,-1,22240,22241,22441,22440,-1,22241,22242,22442,22441,-1,22242,22243,22443,22442,-1,22243,22244,22444,22443,-1,22244,22245,22445,22444,-1,22245,22246,22446,22445,-1,22246,22247,22447,22446,-1,22247,22248,22448,22447,-1,22248,22249,22449,22448,-1,22249,22250,22450,22449,-1,22250,22251,22451,22450,-1,22251,22252,22452,22451,-1,22252,22253,22453,22452,-1,22253,22254,22454,22453,-1,22254,22255,22455,22454,-1,22255,22256,22456,22455,-1,22256,22257,22457,22456,-1,22257,22258,22458,22457,-1,22258,22259,22459,22458,-1,22259,22260,22460,22459,-1,22260,22261,22461,22460,-1,22261,22262,22462,22461,-1,22262,22263,22463,22462,-1,22263,22264,22464,22463,-1,22264,22265,22465,22464,-1,22265,22266,22466,22465,-1,22266,22267,22467,22466,-1,22267,22268,22468,22467,-1,22268,22269,22469,22468,-1,22269,22270,22470,22469,-1,22270,22271,22471,22470,-1,22271,22272,22472,22471,-1,22272,22273,22473,22472,-1,22273,22274,22474,22473,-1,22274,22275,22475,22474,-1,22275,22276,22476,22475,-1,22276,22277,22477,22476,-1,22277,22278,22478,22477,-1,22278,22279,22479,22478,-1,22279,22280,22480,22479,-1,22280,22281,22481,22480,-1,22281,22282,22482,22481,-1,22282,22283,22483,22482,-1,22283,22284,22484,22483,-1,22284,22285,22485,22484,-1,22285,22286,22486,22485,-1,22286,22287,22487,22486,-1,22287,22288,22488,22487,-1,22288,22289,22489,22488,-1,22289,22290,22490,22489,-1,22290,22291,22491,22490,-1,22291,22292,22492,22491,-1,22292,22293,22493,22492,-1,22293,22294,22494,22493,-1,22294,22295,22495,22494,-1,22295,22296,22496,22495,-1,22296,22297,22497,22496,-1,22297,22298,22498,22497,-1,22298,22299,22499,22498,-1,22299,22300,22500,22499,-1,22300,22301,22501,22500,-1,22301,22302,22502,22501,-1,22302,22303,22503,22502,-1,22303,22304,22504,22503,-1,22304,22305,22505,22504,-1,22305,22306,22506,22505,-1,22306,22307,22507,22506,-1,22307,22308,22508,22507,-1,22308,22309,22509,22508,-1,22309,22310,22510,22509,-1,22310,22311,22511,22510,-1,22311,22312,22512,22511,-1,22312,22313,22513,22512,-1,22313,22314,22514,22513,-1,22314,22315,22515,22514,-1,22315,22316,22516,22515,-1,22316,22317,22517,22516,-1,22317,22318,22518,22517,-1,22318,22319,22519,22518,-1,22319,22320,22520,22519,-1,22320,22321,22521,22520,-1,22321,22322,22522,22521,-1,22322,22323,22523,22522,-1,22323,22324,22524,22523,-1,22324,22325,22525,22524,-1,22325,22326,22526,22525,-1,22326,22327,22527,22526,-1,22327,22328,22528,22527,-1,22328,22329,22529,22528,-1,22329,22330,22530,22529,-1,22330,22331,22531,22530,-1,22331,22332,22532,22531,-1,22332,22333,22533,22532,-1,22333,22334,22534,22533,-1,22334,22335,22535,22534,-1,22335,22336,22536,22535,-1,22336,22337,22537,22536,-1,22337,22338,22538,22537,-1,22338,22339,22539,22538,-1,22339,22340,22540,22539,-1,22340,22341,22541,22540,-1,22341,22342,22542,22541,-1,22342,22343,22543,22542,-1,22343,22344,22544,22543,-1,22344,22345,22545,22544,-1,22345,22346,22546,22545,-1,22346,22347,22547,22546,-1,22347,22348,22548,22547,-1,22348,22349,22549,22548,-1,22349,22350,22550,22549,-1,22350,22351,22551,22550,-1,22351,22352,22552,22551,-1,22352,22353,22553,22552,-1,22353,22354,22554,22553,-1,22354,22355,22555,22554,-1,22355,22356,22556,22555,-1,22356,22357,22557,22556,-1,22357,22358,22558,22557,-1,22358,22359,22559,22558,-1,22359,22360,22560,22559,-1,22360,22361,22561,22560,-1,22361,22362,22562,22561,-1,22362,22363,22563,22562,-1,22363,22364,22564,22563,-1,22364,22365,22565,22564,-1,22365,22366,22566,22565,-1,22366,22367,22567,22566,-1,22367,22368,22568,22567,-1,22368,22369,22569,22568,-1,22369,22370,22570,22569,-1,22370,22371,22571,22570,-1,22371,22372,22572,22571,-1,22372,22373,22573,22572,-1,22373,22374,22574,22573,-1,22374,22375,22575,22574,-1,22375,22376,22576,22575,-1,22376,22377,22577,22576,-1,22377,22378,22578,22577,-1,22378,22379,22579,22578,-1,22379,22380,22580,22579,-1,22380,22381,22581,22580,-1,22381,22382,22582,22581,-1,22382,22383,22583,22582,-1,22383,22384,22584,22583,-1,22384,22385,22585,22584,-1,22385,22386,22586,22585,-1,22386,22387,22587,22586,-1,22387,22388,22588,22587,-1,22388,22389,22589,22588,-1,22389,22390,22590,22589,-1,22390,22391,22591,22590,-1,22391,22392,22592,22591,-1,22392,22393,22593,22592,-1,22393,22394,22594,22593,-1,22394,22395,22595,22594,-1,22395,22396,22596,22595,-1,22396,22397,22597,22596,-1,22397,22398,22598,22597,-1,22398,22399,22599,22598,-1,22400,22401,22601,22600,-1,22401,22402,22602,22601,-1,22402,22403,22603,22602,-1,22403,22404,22604,22603,-1,22404,22405,22605,22604,-1,22405,22406,22606,22605,-1,22406,22407,22607,22606,-1,22407,22408,22608,22607,-1,22408,22409,22609,22608,-1,22409,22410,22610,22609,-1,22410,22411,22611,22610,-1,22411,22412,22612,22611,-1,22412,22413,22613,22612,-1,22413,22414,22614,22613,-1,22414,22415,22615,22614,-1,22415,22416,22616,22615,-1,22416,22417,22617,22616,-1,22417,22418,22618,22617,-1,22418,22419,22619,22618,-1,22419,22420,22620,22619,-1,22420,22421,22621,22620,-1,22421,22422,22622,22621,-1,22422,22423,22623,22622,-1,22423,22424,22624,22623,-1,22424,22425,22625,22624,-1,22425,22426,22626,22625,-1,22426,22427,22627,22626,-1,22427,22428,22628,22627,-1,22428,22429,22629,22628,-1,22429,22430,22630,22629,-1,22430,22431,22631,22630,-1,22431,22432,22632,22631,-1,22432,22433,22633,22632,-1,22433,22434,22634,22633,-1,22434,22435,22635,22634,-1,22435,22436,22636,22635,-1,22436,22437,22637,22636,-1,22437,22438,22638,22637,-1,22438,22439,22639,22638,-1,22439,22440,22640,22639,-1,22440,22441,22641,22640,-1,22441,22442,22642,22641,-1,22442,22443,22643,22642,-1,22443,22444,22644,22643,-1,22444,22445,22645,22644,-1,22445,22446,22646,22645,-1,22446,22447,22647,22646,-1,22447,22448,22648,22647,-1,22448,22449,22649,22648,-1,22449,22450,22650,22649,-1,22450,22451,22651,22650,-1,22451,22452,22652,22651,-1,22452,22453,22653,22652,-1,22453,22454,22654,22653,-1,22454,22455,22655,22654,-1,22455,22456,22656,22655,-1,22456,22457,22657,22656,-1,22457,22458,22658,22657,-1,22458,22459,22659,22658,-1,22459,22460,22660,22659,-1,22460,22461,22661,22660,-1,22461,22462,22662,22661,-1,22462,22463,22663,22662,-1,22463,22464,22664,22663,-1,22464,22465,22665,22664,-1,22465,22466,22666,22665,-1,22466,22467,22667,22666,-1,22467,22468,22668,22667,-1,22468,22469,22669,22668,-1,22469,22470,22670,22669,-1,22470,22471,22671,22670,-1,22471,22472,22672,22671,-1,22472,22473,22673,22672,-1,22473,22474,22674,22673,-1,22474,22475,22675,22674,-1,22475,22476,22676,22675,-1,22476,22477,22677,22676,-1,22477,22478,22678,22677,-1,22478,22479,22679,22678,-1,22479,22480,22680,22679,-1,22480,22481,22681,22680,-1,22481,22482,22682,22681,-1,22482,22483,22683,22682,-1,22483,22484,22684,22683,-1,22484,22485,22685,22684,-1,22485,22486,22686,22685,-1,22486,22487,22687,22686,-1,22487,22488,22688,22687,-1,22488,22489,22689,22688,-1,22489,22490,22690,22689,-1,22490,22491,22691,22690,-1,22491,22492,22692,22691,-1,22492,22493,22693,22692,-1,22493,22494,22694,22693,-1,22494,22495,22695,22694,-1,22495,22496,22696,22695,-1,22496,22497,22697,22696,-1,22497,22498,22698,22697,-1,22498,22499,22699,22698,-1,22499,22500,22700,22699,-1,22500,22501,22701,22700,-1,22501,22502,22702,22701,-1,22502,22503,22703,22702,-1,22503,22504,22704,22703,-1,22504,22505,22705,22704,-1,22505,22506,22706,22705,-1,22506,22507,22707,22706,-1,22507,22508,22708,22707,-1,22508,22509,22709,22708,-1,22509,22510,22710,22709,-1,22510,22511,22711,22710,-1,22511,22512,22712,22711,-1,22512,22513,22713,22712,-1,22513,22514,22714,22713,-1,22514,22515,22715,22714,-1,22515,22516,22716,22715,-1,22516,22517,22717,22716,-1,22517,22518,22718,22717,-1,22518,22519,22719,22718,-1,22519,22520,22720,22719,-1,22520,22521,22721,22720,-1,22521,22522,22722,22721,-1,22522,22523,22723,22722,-1,22523,22524,22724,22723,-1,22524,22525,22725,22724,-1,22525,22526,22726,22725,-1,22526,22527,22727,22726,-1,22527,22528,22728,22727,-1,22528,22529,22729,22728,-1,22529,22530,22730,22729,-1,22530,22531,22731,22730,-1,22531,22532,22732,22731,-1,22532,22533,22733,22732,-1,22533,22534,22734,22733,-1,22534,22535,22735,22734,-1,22535,22536,22736,22735,-1,22536,22537,22737,22736,-1,22537,22538,22738,22737,-1,22538,22539,22739,22738,-1,22539,22540,22740,22739,-1,22540,22541,22741,22740,-1,22541,22542,22742,22741,-1,22542,22543,22743,22742,-1,22543,22544,22744,22743,-1,22544,22545,22745,22744,-1,22545,22546,22746,22745,-1,22546,22547,22747,22746,-1,22547,22548,22748,22747,-1,22548,22549,22749,22748,-1,22549,22550,22750,22749,-1,22550,22551,22751,22750,-1,22551,22552,22752,22751,-1,22552,22553,22753,22752,-1,22553,22554,22754,22753,-1,22554,22555,22755,22754,-1,22555,22556,22756,22755,-1,22556,22557,22757,22756,-1,22557,22558,22758,22757,-1,22558,22559,22759,22758,-1,22559,22560,22760,22759,-1,22560,22561,22761,22760,-1,22561,22562,22762,22761,-1,22562,22563,22763,22762,-1,22563,22564,22764,22763,-1,22564,22565,22765,22764,-1,22565,22566,22766,22765,-1,22566,22567,22767,22766,-1,22567,22568,22768,22767,-1,22568,22569,22769,22768,-1,22569,22570,22770,22769,-1,22570,22571,22771,22770,-1,22571,22572,22772,22771,-1,22572,22573,22773,22772,-1,22573,22574,22774,22773,-1,22574,22575,22775,22774,-1,22575,22576,22776,22775,-1,22576,22577,22777,22776,-1,22577,22578,22778,22777,-1,22578,22579,22779,22778,-1,22579,22580,22780,22779,-1,22580,22581,22781,22780,-1,22581,22582,22782,22781,-1,22582,22583,22783,22782,-1,22583,22584,22784,22783,-1,22584,22585,22785,22784,-1,22585,22586,22786,22785,-1,22586,22587,22787,22786,-1,22587,22588,22788,22787,-1,22588,22589,22789,22788,-1,22589,22590,22790,22789,-1,22590,22591,22791,22790,-1,22591,22592,22792,22791,-1,22592,22593,22793,22792,-1,22593,22594,22794,22793,-1,22594,22595,22795,22794,-1,22595,22596,22796,22795,-1,22596,22597,22797,22796,-1,22597,22598,22798,22797,-1,22598,22599,22799,22798,-1,22600,22601,22801,22800,-1,22601,22602,22802,22801,-1,22602,22603,22803,22802,-1,22603,22604,22804,22803,-1,22604,22605,22805,22804,-1,22605,22606,22806,22805,-1,22606,22607,22807,22806,-1,22607,22608,22808,22807,-1,22608,22609,22809,22808,-1,22609,22610,22810,22809,-1,22610,22611,22811,22810,-1,22611,22612,22812,22811,-1,22612,22613,22813,22812,-1,22613,22614,22814,22813,-1,22614,22615,22815,22814,-1,22615,22616,22816,22815,-1,22616,22617,22817,22816,-1,22617,22618,22818,22817,-1,22618,22619,22819,22818,-1,22619,22620,22820,22819,-1,22620,22621,22821,22820,-1,22621,22622,22822,22821,-1,22622,22623,22823,22822,-1,22623,22624,22824,22823,-1,22624,22625,22825,22824,-1,22625,22626,22826,22825,-1,22626,22627,22827,22826,-1,22627,22628,22828,22827,-1,22628,22629,22829,22828,-1,22629,22630,22830,22829,-1,22630,22631,22831,22830,-1,22631,22632,22832,22831,-1,22632,22633,22833,22832,-1,22633,22634,22834,22833,-1,22634,22635,22835,22834,-1,22635,22636,22836,22835,-1,22636,22637,22837,22836,-1,22637,22638,22838,22837,-1,22638,22639,22839,22838,-1,22639,22640,22840,22839,-1,22640,22641,22841,22840,-1,22641,22642,22842,22841,-1,22642,22643,22843,22842,-1,22643,22644,22844,22843,-1,22644,22645,22845,22844,-1,22645,22646,22846,22845,-1,22646,22647,22847,22846,-1,22647,22648,22848,22847,-1,22648,22649,22849,22848,-1,22649,22650,22850,22849,-1,22650,22651,22851,22850,-1,22651,22652,22852,22851,-1,22652,22653,22853,22852,-1,22653,22654,22854,22853,-1,22654,22655,22855,22854,-1,22655,22656,22856,22855,-1,22656,22657,22857,22856,-1,22657,22658,22858,22857,-1,22658,22659,22859,22858,-1,22659,22660,22860,22859,-1,22660,22661,22861,22860,-1,22661,22662,22862,22861,-1,22662,22663,22863,22862,-1,22663,22664,22864,22863,-1,22664,22665,22865,22864,-1,22665,22666,22866,22865,-1,22666,22667,22867,22866,-1,22667,22668,22868,22867,-1,22668,22669,22869,22868,-1,22669,22670,22870,22869,-1,22670,22671,22871,22870,-1,22671,22672,22872,22871,-1,22672,22673,22873,22872,-1,22673,22674,22874,22873,-1,22674,22675,22875,22874,-1,22675,22676,22876,22875,-1,22676,22677,22877,22876,-1,22677,22678,22878,22877,-1,22678,22679,22879,22878,-1,22679,22680,22880,22879,-1,22680,22681,22881,22880,-1,22681,22682,22882,22881,-1,22682,22683,22883,22882,-1,22683,22684,22884,22883,-1,22684,22685,22885,22884,-1,22685,22686,22886,22885,-1,22686,22687,22887,22886,-1,22687,22688,22888,22887,-1,22688,22689,22889,22888,-1,22689,22690,22890,22889,-1,22690,22691,22891,22890,-1,22691,22692,22892,22891,-1,22692,22693,22893,22892,-1,22693,22694,22894,22893,-1,22694,22695,22895,22894,-1,22695,22696,22896,22895,-1,22696,22697,22897,22896,-1,22697,22698,22898,22897,-1,22698,22699,22899,22898,-1,22699,22700,22900,22899,-1,22700,22701,22901,22900,-1,22701,22702,22902,22901,-1,22702,22703,22903,22902,-1,22703,22704,22904,22903,-1,22704,22705,22905,22904,-1,22705,22706,22906,22905,-1,22706,22707,22907,22906,-1,22707,22708,22908,22907,-1,22708,22709,22909,22908,-1,22709,22710,22910,22909,-1,22710,22711,22911,22910,-1,22711,22712,22912,22911,-1,22712,22713,22913,22912,-1,22713,22714,22914,22913,-1,22714,22715,22915,22914,-1,22715,22716,22916,22915,-1,22716,22717,22917,22916,-1,22717,22718,22918,22917,-1,22718,22719,22919,22918,-1,22719,22720,22920,22919,-1,22720,22721,22921,22920,-1,22721,22722,22922,22921,-1,22722,22723,22923,22922,-1,22723,22724,22924,22923,-1,22724,22725,22925,22924,-1,22725,22726,22926,22925,-1,22726,22727,22927,22926,-1,22727,22728,22928,22927,-1,22728,22729,22929,22928,-1,22729,22730,22930,22929,-1,22730,22731,22931,22930,-1,22731,22732,22932,22931,-1,22732,22733,22933,22932,-1,22733,22734,22934,22933,-1,22734,22735,22935,22934,-1,22735,22736,22936,22935,-1,22736,22737,22937,22936,-1,22737,22738,22938,22937,-1,22738,22739,22939,22938,-1,22739,22740,22940,22939,-1,22740,22741,22941,22940,-1,22741,22742,22942,22941,-1,22742,22743,22943,22942,-1,22743,22744,22944,22943,-1,22744,22745,22945,22944,-1,22745,22746,22946,22945,-1,22746,22747,22947,22946,-1,22747,22748,22948,22947,-1,22748,22749,22949,22948,-1,22749,22750,22950,22949,-1,22750,22751,22951,22950,-1,22751,22752,22952,22951,-1,22752,22753,22953,22952,-1,22753,22754,22954,22953,-1,22754,22755,22955,22954,-1,22755,22756,22956,22955,-1,22756,22757,22957,22956,-1,22757,22758,22958,22957,-1,22758,22759,22959,22958,-1,22759,22760,22960,22959,-1,22760,22761,22961,22960,-1,22761,22762,22962,22961,-1,22762,22763,22963,22962,-1,22763,22764,22964,22963,-1,22764,22765,22965,22964,-1,22765,22766,22966,22965,-1,22766,22767,22967,22966,-1,22767,22768,22968,22967,-1,22768,22769,22969,22968,-1,22769,22770,22970,22969,-1,22770,22771,22971,22970,-1,22771,22772,22972,22971,-1,22772,22773,22973,22972,-1,22773,22774,22974,22973,-1,22774,22775,22975,22974,-1,22775,22776,22976,22975,-1,22776,22777,22977,22976,-1,22777,22778,22978,22977,-1,22778,22779,22979,22978,-1,22779,22780,22980,22979,-1,22780,22781,22981,22980,-1,22781,22782,22982,22981,-1,22782,22783,22983,22982,-1,22783,22784,22984,22983,-1,22784,22785,22985,22984,-1,22785,22786,22986,22985,-1,22786,22787,22987,22986,-1,22787,22788,22988,22987,-1,22788,22789,22989,22988,-1,22789,22790,22990,22989,-1,22790,22791,22991,22990,-1,22791,22792,22992,22991,-1,22792,22793,22993,22992,-1,22793,22794,22994,22993,-1,22794,22795,22995,22994,-1,22795,22796,22996,22995,-1,22796,22797,22997,22996,-1,22797,22798,22998,22997,-1,22798,22799,22999,22998,-1,22800,22801,23001,23,-1,22801,22802,23002,23001,-1,22802,22803,23003,23002,-1,22803,22804,23004,23003,-1,22804,22805,23005,23004,-1,22805,22806,23006,23005,-1,22806,22807,23007,23006,-1,22807,22808,23008,23007,-1,22808,22809,23009,23008,-1,22809,22810,23010,23009,-1,22810,22811,23011,23010,-1,22811,22812,23012,23011,-1,22812,22813,23013,23012,-1,22813,22814,23014,23013,-1,22814,22815,23015,23014,-1,22815,22816,23016,23015,-1,22816,22817,23017,23016,-1,22817,22818,23018,23017,-1,22818,22819,23019,23018,-1,22819,22820,23020,23019,-1,22820,22821,23021,23020,-1,22821,22822,23022,23021,-1,22822,22823,23023,23022,-1,22823,22824,23024,23023,-1,22824,22825,23025,23024,-1,22825,22826,23026,23025,-1,22826,22827,23027,23026,-1,22827,22828,23028,23027,-1,22828,22829,23029,23028,-1,22829,22830,23030,23029,-1,22830,22831,23031,23030,-1,22831,22832,23032,23031,-1,22832,22833,23033,23032,-1,22833,22834,23034,23033,-1,22834,22835,23035,23034,-1,22835,22836,23036,23035,-1,22836,22837,23037,23036,-1,22837,22838,23038,23037,-1,22838,22839,23039,23038,-1,22839,22840,23040,23039,-1,22840,22841,23041,23040,-1,22841,22842,23042,23041,-1,22842,22843,23043,23042,-1,22843,22844,23044,23043,-1,22844,22845,23045,23044,-1,22845,22846,23046,23045,-1,22846,22847,23047,23046,-1,22847,22848,23048,23047,-1,22848,22849,23049,23048,-1,22849,22850,23050,23049,-1,22850,22851,23051,23050,-1,22851,22852,23052,23051,-1,22852,22853,23053,23052,-1,22853,22854,23054,23053,-1,22854,22855,23055,23054,-1,22855,22856,23056,23055,-1,22856,22857,23057,23056,-1,22857,22858,23058,23057,-1,22858,22859,23059,23058,-1,22859,22860,23060,23059,-1,22860,22861,23061,23060,-1,22861,22862,23062,23061,-1,22862,22863,23063,23062,-1,22863,22864,23064,23063,-1,22864,22865,23065,23064,-1,22865,22866,23066,23065,-1,22866,22867,23067,23066,-1,22867,22868,23068,23067,-1,22868,22869,23069,23068,-1,22869,22870,23070,23069,-1,22870,22871,23071,23070,-1,22871,22872,23072,23071,-1,22872,22873,23073,23072,-1,22873,22874,23074,23073,-1,22874,22875,23075,23074,-1,22875,22876,23076,23075,-1,22876,22877,23077,23076,-1,22877,22878,23078,23077,-1,22878,22879,23079,23078,-1,22879,22880,23080,23079,-1,22880,22881,23081,23080,-1,22881,22882,23082,23081,-1,22882,22883,23083,23082,-1,22883,22884,23084,23083,-1,22884,22885,23085,23084,-1,22885,22886,23086,23085,-1,22886,22887,23087,23086,-1,22887,22888,23088,23087,-1,22888,22889,23089,23088,-1,22889,22890,23090,23089,-1,22890,22891,23091,23090,-1,22891,22892,23092,23091,-1,22892,22893,23093,23092,-1,22893,22894,23094,23093,-1,22894,22895,23095,23094,-1,22895,22896,23096,23095,-1,22896,22897,23097,23096,-1,22897,22898,23098,23097,-1,22898,22899,23099,23098,-1,22899,22900,23100,23099,-1,22900,22901,23101,23100,-1,22901,22902,23102,23101,-1,22902,22903,23103,23102,-1,22903,22904,23104,23103,-1,22904,22905,23105,23104,-1,22905,22906,23106,23105,-1,22906,22907,23107,23106,-1,22907,22908,23108,23107,-1,22908,22909,23109,23108,-1,22909,22910,23110,23109,-1,22910,22911,23111,23110,-1,22911,22912,23112,23111,-1,22912,22913,23113,23112,-1,22913,22914,23114,23113,-1,22914,22915,23115,23114,-1,22915,22916,23116,23115,-1,22916,22917,23117,23116,-1,22917,22918,23118,23117,-1,22918,22919,23119,23118,-1,22919,22920,23120,23119,-1,22920,22921,23121,23120,-1,22921,22922,23122,23121,-1,22922,22923,23123,23122,-1,22923,22924,23124,23123,-1,22924,22925,23125,23124,-1,22925,22926,23126,23125,-1,22926,22927,23127,23126,-1,22927,22928,23128,23127,-1,22928,22929,23129,23128,-1,22929,22930,23130,23129,-1,22930,22931,23131,23130,-1,22931,22932,23132,23131,-1,22932,22933,23133,23132,-1,22933,22934,23134,23133,-1,22934,22935,23135,23134,-1,22935,22936,23136,23135,-1,22936,22937,23137,23136,-1,22937,22938,23138,23137,-1,22938,22939,23139,23138,-1,22939,22940,23140,23139,-1,22940,22941,23141,23140,-1,22941,22942,23142,23141,-1,22942,22943,23143,23142,-1,22943,22944,23144,23143,-1,22944,22945,23145,23144,-1,22945,22946,23146,23145,-1,22946,22947,23147,23146,-1,22947,22948,23148,23147,-1,22948,22949,23149,23148,-1,22949,22950,23150,23149,-1,22950,22951,23151,23150,-1,22951,22952,23152,23151,-1,22952,22953,23153,23152,-1,22953,22954,23154,23153,-1,22954,22955,23155,23154,-1,22955,22956,23156,23155,-1,22956,22957,23157,23156,-1,22957,22958,23158,23157,-1,22958,22959,23159,23158,-1,22959,22960,23160,23159,-1,22960,22961,23161,23160,-1,22961,22962,23162,23161,-1,22962,22963,23163,23162,-1,22963,22964,23164,23163,-1,22964,22965,23165,23164,-1,22965,22966,23166,23165,-1,22966,22967,23167,23166,-1,22967,22968,23168,23167,-1,22968,22969,23169,23168,-1,22969,22970,23170,23169,-1,22970,22971,23171,23170,-1,22971,22972,23172,23171,-1,22972,22973,23173,23172,-1,22973,22974,23174,23173,-1,22974,22975,23175,23174,-1,22975,22976,23176,23175,-1,22976,22977,23177,23176,-1,22977,22978,23178,23177,-1,22978,22979,23179,23178,-1,22979,22980,23180,23179,-1,22980,22981,23181,23180,-1,22981,22982,23182,23181,-1,22982,22983,23183,23182,-1,22983,22984,23184,23183,-1,22984,22985,23185,23184,-1,22985,22986,23186,23185,-1,22986,22987,23187,23186,-1,22987,22988,23188,23187,-1,22988,22989,23189,23188,-1,22989,22990,23190,23189,-1,22990,22991,23191,23190,-1,22991,22992,23192,23191,-1,22992,22993,23193,23192,-1,22993,22994,23194,23193,-1,22994,22995,23195,23194,-1,22995,22996,23196,23195,-1,22996,22997,23197,23196,-1,22997,22998,23198,23197,-1,22998,22999,23199,23198,-1,23,23001,23201,23200,-1,23001,23002,23202,23201,-1,23002,23003,23203,23202,-1,23003,23004,23204,23203,-1,23004,23005,23205,23204,-1,23005,23006,23206,23205,-1,23006,23007,23207,23206,-1,23007,23008,23208,23207,-1,23008,23009,23209,23208,-1,23009,23010,23210,23209,-1,23010,23011,23211,23210,-1,23011,23012,23212,23211,-1,23012,23013,23213,23212,-1,23013,23014,23214,23213,-1,23014,23015,23215,23214,-1,23015,23016,23216,23215,-1,23016,23017,23217,23216,-1,23017,23018,23218,23217,-1,23018,23019,23219,23218,-1,23019,23020,23220,23219,-1,23020,23021,23221,23220,-1,23021,23022,23222,23221,-1,23022,23023,23223,23222,-1,23023,23024,23224,23223,-1,23024,23025,23225,23224,-1,23025,23026,23226,23225,-1,23026,23027,23227,23226,-1,23027,23028,23228,23227,-1,23028,23029,23229,23228,-1,23029,23030,23230,23229,-1,23030,23031,23231,23230,-1,23031,23032,23232,23231,-1,23032,23033,23233,23232,-1,23033,23034,23234,23233,-1,23034,23035,23235,23234,-1,23035,23036,23236,23235,-1,23036,23037,23237,23236,-1,23037,23038,23238,23237,-1,23038,23039,23239,23238,-1,23039,23040,23240,23239,-1,23040,23041,23241,23240,-1,23041,23042,23242,23241,-1,23042,23043,23243,23242,-1,23043,23044,23244,23243,-1,23044,23045,23245,23244,-1,23045,23046,23246,23245,-1,23046,23047,23247,23246,-1,23047,23048,23248,23247,-1,23048,23049,23249,23248,-1,23049,23050,23250,23249,-1,23050,23051,23251,23250,-1,23051,23052,23252,23251,-1,23052,23053,23253,23252,-1,23053,23054,23254,23253,-1,23054,23055,23255,23254,-1,23055,23056,23256,23255,-1,23056,23057,23257,23256,-1,23057,23058,23258,23257,-1,23058,23059,23259,23258,-1,23059,23060,23260,23259,-1,23060,23061,23261,23260,-1,23061,23062,23262,23261,-1,23062,23063,23263,23262,-1,23063,23064,23264,23263,-1,23064,23065,23265,23264,-1,23065,23066,23266,23265,-1,23066,23067,23267,23266,-1,23067,23068,23268,23267,-1,23068,23069,23269,23268,-1,23069,23070,23270,23269,-1,23070,23071,23271,23270,-1,23071,23072,23272,23271,-1,23072,23073,23273,23272,-1,23073,23074,23274,23273,-1,23074,23075,23275,23274,-1,23075,23076,23276,23275,-1,23076,23077,23277,23276,-1,23077,23078,23278,23277,-1,23078,23079,23279,23278,-1,23079,23080,23280,23279,-1,23080,23081,23281,23280,-1,23081,23082,23282,23281,-1,23082,23083,23283,23282,-1,23083,23084,23284,23283,-1,23084,23085,23285,23284,-1,23085,23086,23286,23285,-1,23086,23087,23287,23286,-1,23087,23088,23288,23287,-1,23088,23089,23289,23288,-1,23089,23090,23290,23289,-1,23090,23091,23291,23290,-1,23091,23092,23292,23291,-1,23092,23093,23293,23292,-1,23093,23094,23294,23293,-1,23094,23095,23295,23294,-1,23095,23096,23296,23295,-1,23096,23097,23297,23296,-1,23097,23098,23298,23297,-1,23098,23099,23299,23298,-1,23099,23100,23300,23299,-1,23100,23101,23301,23300,-1,23101,23102,23302,23301,-1,23102,23103,23303,23302,-1,23103,23104,23304,23303,-1,23104,23105,23305,23304,-1,23105,23106,23306,23305,-1,23106,23107,23307,23306,-1,23107,23108,23308,23307,-1,23108,23109,23309,23308,-1,23109,23110,23310,23309,-1,23110,23111,23311,23310,-1,23111,23112,23312,23311,-1,23112,23113,23313,23312,-1,23113,23114,23314,23313,-1,23114,23115,23315,23314,-1,23115,23116,23316,23315,-1,23116,23117,23317,23316,-1,23117,23118,23318,23317,-1,23118,23119,23319,23318,-1,23119,23120,23320,23319,-1,23120,23121,23321,23320,-1,23121,23122,23322,23321,-1,23122,23123,23323,23322,-1,23123,23124,23324,23323,-1,23124,23125,23325,23324,-1,23125,23126,23326,23325,-1,23126,23127,23327,23326,-1,23127,23128,23328,23327,-1,23128,23129,23329,23328,-1,23129,23130,23330,23329,-1,23130,23131,23331,23330,-1,23131,23132,23332,23331,-1,23132,23133,23333,23332,-1,23133,23134,23334,23333,-1,23134,23135,23335,23334,-1,23135,23136,23336,23335,-1,23136,23137,23337,23336,-1,23137,23138,23338,23337,-1,23138,23139,23339,23338,-1,23139,23140,23340,23339,-1,23140,23141,23341,23340,-1,23141,23142,23342,23341,-1,23142,23143,23343,23342,-1,23143,23144,23344,23343,-1,23144,23145,23345,23344,-1,23145,23146,23346,23345,-1,23146,23147,23347,23346,-1,23147,23148,23348,23347,-1,23148,23149,23349,23348,-1,23149,23150,23350,23349,-1,23150,23151,23351,23350,-1,23151,23152,23352,23351,-1,23152,23153,23353,23352,-1,23153,23154,23354,23353,-1,23154,23155,23355,23354,-1,23155,23156,23356,23355,-1,23156,23157,23357,23356,-1,23157,23158,23358,23357,-1,23158,23159,23359,23358,-1,23159,23160,23360,23359,-1,23160,23161,23361,23360,-1,23161,23162,23362,23361,-1,23162,23163,23363,23362,-1,23163,23164,23364,23363,-1,23164,23165,23365,23364,-1,23165,23166,23366,23365,-1,23166,23167,23367,23366,-1,23167,23168,23368,23367,-1,23168,23169,23369,23368,-1,23169,23170,23370,23369,-1,23170,23171,23371,23370,-1,23171,23172,23372,23371,-1,23172,23173,23373,23372,-1,23173,23174,23374,23373,-1,23174,23175,23375,23374,-1,23175,23176,23376,23375,-1,23176,23177,23377,23376,-1,23177,23178,23378,23377,-1,23178,23179,23379,23378,-1,23179,23180,23380,23379,-1,23180,23181,23381,23380,-1,23181,23182,23382,23381,-1,23182,23183,23383,23382,-1,23183,23184,23384,23383,-1,23184,23185,23385,23384,-1,23185,23186,23386,23385,-1,23186,23187,23387,23386,-1,23187,23188,23388,23387,-1,23188,23189,23389,23388,-1,23189,23190,23390,23389,-1,23190,23191,23391,23390,-1,23191,23192,23392,23391,-1,23192,23193,23393,23392,-1,23193,23194,23394,23393,-1,23194,23195,23395,23394,-1,23195,23196,23396,23395,-1,23196,23197,23397,23396,-1,23197,23198,23398,23397,-1,23198,23199,23399,23398,-1,23200,23201,23401,23400,-1,23201,23202,23402,23401,-1,23202,23203,23403,23402,-1,23203,23204,23404,23403,-1,23204,23205,23405,23404,-1,23205,23206,23406,23405,-1,23206,23207,23407,23406,-1,23207,23208,23408,23407,-1,23208,23209,23409,23408,-1,23209,23210,23410,23409,-1,23210,23211,23411,23410,-1,23211,23212,23412,23411,-1,23212,23213,23413,23412,-1,23213,23214,23414,23413,-1,23214,23215,23415,23414,-1,23215,23216,23416,23415,-1,23216,23217,23417,23416,-1,23217,23218,23418,23417,-1,23218,23219,23419,23418,-1,23219,23220,23420,23419,-1,23220,23221,23421,23420,-1,23221,23222,23422,23421,-1,23222,23223,23423,23422,-1,23223,23224,23424,23423,-1,23224,23225,23425,23424,-1,23225,23226,23426,23425,-1,23226,23227,23427,23426,-1,23227,23228,23428,23427,-1,23228,23229,23429,23428,-1,23229,23230,23430,23429,-1,23230,23231,23431,23430,-1,23231,23232,23432,23431,-1,23232,23233,23433,23432,-1,23233,23234,23434,23433,-1,23234,23235,23435,23434,-1,23235,23236,23436,23435,-1,23236,23237,23437,23436,-1,23237,23238,23438,23437,-1,23238,23239,23439,23438,-1,23239,23240,23440,23439,-1,23240,23241,23441,23440,-1,23241,23242,23442,23441,-1,23242,23243,23443,23442,-1,23243,23244,23444,23443,-1,23244,23245,23445,23444,-1,23245,23246,23446,23445,-1,23246,23247,23447,23446,-1,23247,23248,23448,23447,-1,23248,23249,23449,23448,-1,23249,23250,23450,23449,-1,23250,23251,23451,23450,-1,23251,23252,23452,23451,-1,23252,23253,23453,23452,-1,23253,23254,23454,23453,-1,23254,23255,23455,23454,-1,23255,23256,23456,23455,-1,23256,23257,23457,23456,-1,23257,23258,23458,23457,-1,23258,23259,23459,23458,-1,23259,23260,23460,23459,-1,23260,23261,23461,23460,-1,23261,23262,23462,23461,-1,23262,23263,23463,23462,-1,23263,23264,23464,23463,-1,23264,23265,23465,23464,-1,23265,23266,23466,23465,-1,23266,23267,23467,23466,-1,23267,23268,23468,23467,-1,23268,23269,23469,23468,-1,23269,23270,23470,23469,-1,23270,23271,23471,23470,-1,23271,23272,23472,23471,-1,23272,23273,23473,23472,-1,23273,23274,23474,23473,-1,23274,23275,23475,23474,-1,23275,23276,23476,23475,-1,23276,23277,23477,23476,-1,23277,23278,23478,23477,-1,23278,23279,23479,23478,-1,23279,23280,23480,23479,-1,23280,23281,23481,23480,-1,23281,23282,23482,23481,-1,23282,23283,23483,23482,-1,23283,23284,23484,23483,-1,23284,23285,23485,23484,-1,23285,23286,23486,23485,-1,23286,23287,23487,23486,-1,23287,23288,23488,23487,-1,23288,23289,23489,23488,-1,23289,23290,23490,23489,-1,23290,23291,23491,23490,-1,23291,23292,23492,23491,-1,23292,23293,23493,23492,-1,23293,23294,23494,23493,-1,23294,23295,23495,23494,-1,23295,23296,23496,23495,-1,23296,23297,23497,23496,-1,23297,23298,23498,23497,-1,23298,23299,23499,23498,-1,23299,23300,23500,23499,-1,23300,23301,23501,23500,-1,23301,23302,23502,23501,-1,23302,23303,23503,23502,-1,23303,23304,23504,23503,-1,23304,23305,23505,23504,-1,23305,23306,23506,23505,-1,23306,23307,23507,23506,-1,23307,23308,23508,23507,-1,23308,23309,23509,23508,-1,23309,23310,23510,23509,-1,23310,23311,23511,23510,-1,23311,23312,23512,23511,-1,23312,23313,23513,23512,-1,23313,23314,23514,23513,-1,23314,23315,23515,23514,-1,23315,23316,23516,23515,-1,23316,23317,23517,23516,-1,23317,23318,23518,23517,-1,23318,23319,23519,23518,-1,23319,23320,23520,23519,-1,23320,23321,23521,23520,-1,23321,23322,23522,23521,-1,23322,23323,23523,23522,-1,23323,23324,23524,23523,-1,23324,23325,23525,23524,-1,23325,23326,23526,23525,-1,23326,23327,23527,23526,-1,23327,23328,23528,23527,-1,23328,23329,23529,23528,-1,23329,23330,23530,23529,-1,23330,23331,23531,23530,-1,23331,23332,23532,23531,-1,23332,23333,23533,23532,-1,23333,23334,23534,23533,-1,23334,23335,23535,23534,-1,23335,23336,23536,23535,-1,23336,23337,23537,23536,-1,23337,23338,23538,23537,-1,23338,23339,23539,23538,-1,23339,23340,23540,23539,-1,23340,23341,23541,23540,-1,23341,23342,23542,23541,-1,23342,23343,23543,23542,-1,23343,23344,23544,23543,-1,23344,23345,23545,23544,-1,23345,23346,23546,23545,-1,23346,23347,23547,23546,-1,23347,23348,23548,23547,-1,23348,23349,23549,23548,-1,23349,23350,23550,23549,-1,23350,23351,23551,23550,-1,23351,23352,23552,23551,-1,23352,23353,23553,23552,-1,23353,23354,23554,23553,-1,23354,23355,23555,23554,-1,23355,23356,23556,23555,-1,23356,23357,23557,23556,-1,23357,23358,23558,23557,-1,23358,23359,23559,23558,-1,23359,23360,23560,23559,-1,23360,23361,23561,23560,-1,23361,23362,23562,23561,-1,23362,23363,23563,23562,-1,23363,23364,23564,23563,-1,23364,23365,23565,23564,-1,23365,23366,23566,23565,-1,23366,23367,23567,23566,-1,23367,23368,23568,23567,-1,23368,23369,23569,23568,-1,23369,23370,23570,23569,-1,23370,23371,23571,23570,-1,23371,23372,23572,23571,-1,23372,23373,23573,23572,-1,23373,23374,23574,23573,-1,23374,23375,23575,23574,-1,23375,23376,23576,23575,-1,23376,23377,23577,23576,-1,23377,23378,23578,23577,-1,23378,23379,23579,23578,-1,23379,23380,23580,23579,-1,23380,23381,23581,23580,-1,23381,23382,23582,23581,-1,23382,23383,23583,23582,-1,23383,23384,23584,23583,-1,23384,23385,23585,23584,-1,23385,23386,23586,23585,-1,23386,23387,23587,23586,-1,23387,23388,23588,23587,-1,23388,23389,23589,23588,-1,23389,23390,23590,23589,-1,23390,23391,23591,23590,-1,23391,23392,23592,23591,-1,23392,23393,23593,23592,-1,23393,23394,23594,23593,-1,23394,23395,23595,23594,-1,23395,23396,23596,23595,-1,23396,23397,23597,23596,-1,23397,23398,23598,23597,-1,23398,23399,23599,23598,-1,23400,23401,23601,23600,-1,23401,23402,23602,23601,-1,23402,23403,23603,23602,-1,23403,23404,23604,23603,-1,23404,23405,23605,23604,-1,23405,23406,23606,23605,-1,23406,23407,23607,23606,-1,23407,23408,23608,23607,-1,23408,23409,23609,23608,-1,23409,23410,23610,23609,-1,23410,23411,23611,23610,-1,23411,23412,23612,23611,-1,23412,23413,23613,23612,-1,23413,23414,23614,23613,-1,23414,23415,23615,23614,-1,23415,23416,23616,23615,-1,23416,23417,23617,23616,-1,23417,23418,23618,23617,-1,23418,23419,23619,23618,-1,23419,23420,23620,23619,-1,23420,23421,23621,23620,-1,23421,23422,23622,23621,-1,23422,23423,23623,23622,-1,23423,23424,23624,23623,-1,23424,23425,23625,23624,-1,23425,23426,23626,23625,-1,23426,23427,23627,23626,-1,23427,23428,23628,23627,-1,23428,23429,23629,23628,-1,23429,23430,23630,23629,-1,23430,23431,23631,23630,-1,23431,23432,23632,23631,-1,23432,23433,23633,23632,-1,23433,23434,23634,23633,-1,23434,23435,23635,23634,-1,23435,23436,23636,23635,-1,23436,23437,23637,23636,-1,23437,23438,23638,23637,-1,23438,23439,23639,23638,-1,23439,23440,23640,23639,-1,23440,23441,23641,23640,-1,23441,23442,23642,23641,-1,23442,23443,23643,23642,-1,23443,23444,23644,23643,-1,23444,23445,23645,23644,-1,23445,23446,23646,23645,-1,23446,23447,23647,23646,-1,23447,23448,23648,23647,-1,23448,23449,23649,23648,-1,23449,23450,23650,23649,-1,23450,23451,23651,23650,-1,23451,23452,23652,23651,-1,23452,23453,23653,23652,-1,23453,23454,23654,23653,-1,23454,23455,23655,23654,-1,23455,23456,23656,23655,-1,23456,23457,23657,23656,-1,23457,23458,23658,23657,-1,23458,23459,23659,23658,-1,23459,23460,23660,23659,-1,23460,23461,23661,23660,-1,23461,23462,23662,23661,-1,23462,23463,23663,23662,-1,23463,23464,23664,23663,-1,23464,23465,23665,23664,-1,23465,23466,23666,23665,-1,23466,23467,23667,23666,-1,23467,23468,23668,23667,-1,23468,23469,23669,23668,-1,23469,23470,23670,23669,-1,23470,23471,23671,23670,-1,23471,23472,23672,23671,-1,23472,23473,23673,23672,-1,23473,23474,23674,23673,-1,23474,23475,23675,23674,-1,23475,23476,23676,23675,-1,23476,23477,23677,23676,-1,23477,23478,23678,23677,-1,23478,23479,23679,23678,-1,23479,23480,23680,23679,-1,23480,23481,23681,23680,-1,23481,23482,23682,23681,-1,23482,23483,23683,23682,-1,23483,23484,23684,23683,-1,23484,23485,23685,23684,-1,23485,23486,23686,23685,-1,23486,23487,23687,23686,-1,23487,23488,23688,23687,-1,23488,23489,23689,23688,-1,23489,23490,23690,23689,-1,23490,23491,23691,23690,-1,23491,23492,23692,23691,-1,23492,23493,23693,23692,-1,23493,23494,23694,23693,-1,23494,23495,23695,23694,-1,23495,23496,23696,23695,-1,23496,23497,23697,23696,-1,23497,23498,23698,23697,-1,23498,23499,23699,23698,-1,23499,23500,23700,23699,-1,23500,23501,23701,23700,-1,23501,23502,23702,23701,-1,23502,23503,23703,23702,-1,23503,23504,23704,23703,-1,23504,23505,23705,23704,-1,23505,23506,23706,23705,-1,23506,23507,23707,23706,-1,23507,23508,23708,23707,-1,23508,23509,23709,23708,-1,23509,23510,23710,23709,-1,23510,23511,23711,23710,-1,23511,23512,23712,23711,-1,23512,23513,23713,23712,-1,23513,23514,23714,23713,-1,23514,23515,23715,23714,-1,23515,23516,23716,23715,-1,23516,23517,23717,23716,-1,23517,23518,23718,23717,-1,23518,23519,23719,23718,-1,23519,23520,23720,23719,-1,23520,23521,23721,23720,-1,23521,23522,23722,23721,-1,23522,23523,23723,23722,-1,23523,23524,23724,23723,-1,23524,23525,23725,23724,-1,23525,23526,23726,23725,-1,23526,23527,23727,23726,-1,23527,23528,23728,23727,-1,23528,23529,23729,23728,-1,23529,23530,23730,23729,-1,23530,23531,23731,23730,-1,23531,23532,23732,23731,-1,23532,23533,23733,23732,-1,23533,23534,23734,23733,-1,23534,23535,23735,23734,-1,23535,23536,23736,23735,-1,23536,23537,23737,23736,-1,23537,23538,23738,23737,-1,23538,23539,23739,23738,-1,23539,23540,23740,23739,-1,23540,23541,23741,23740,-1,23541,23542,23742,23741,-1,23542,23543,23743,23742,-1,23543,23544,23744,23743,-1,23544,23545,23745,23744,-1,23545,23546,23746,23745,-1,23546,23547,23747,23746,-1,23547,23548,23748,23747,-1,23548,23549,23749,23748,-1,23549,23550,23750,23749,-1,23550,23551,23751,23750,-1,23551,23552,23752,23751,-1,23552,23553,23753,23752,-1,23553,23554,23754,23753,-1,23554,23555,23755,23754,-1,23555,23556,23756,23755,-1,23556,23557,23757,23756,-1,23557,23558,23758,23757,-1,23558,23559,23759,23758,-1,23559,23560,23760,23759,-1,23560,23561,23761,23760,-1,23561,23562,23762,23761,-1,23562,23563,23763,23762,-1,23563,23564,23764,23763,-1,23564,23565,23765,23764,-1,23565,23566,23766,23765,-1,23566,23567,23767,23766,-1,23567,23568,23768,23767,-1,23568,23569,23769,23768,-1,23569,23570,23770,23769,-1,23570,23571,23771,23770,-1,23571,23572,23772,23771,-1,23572,23573,23773,23772,-1,23573,23574,23774,23773,-1,23574,23575,23775,23774,-1,23575,23576,23776,23775,-1,23576,23577,23777,23776,-1,23577,23578,23778,23777,-1,23578,23579,23779,23778,-1,23579,23580,23780,23779,-1,23580,23581,23781,23780,-1,23581,23582,23782,23781,-1,23582,23583,23783,23782,-1,23583,23584,23784,23783,-1,23584,23585,23785,23784,-1,23585,23586,23786,23785,-1,23586,23587,23787,23786,-1,23587,23588,23788,23787,-1,23588,23589,23789,23788,-1,23589,23590,23790,23789,-1,23590,23591,23791,23790,-1,23591,23592,23792,23791,-1,23592,23593,23793,23792,-1,23593,23594,23794,23793,-1,23594,23595,23795,23794,-1,23595,23596,23796,23795,-1,23596,23597,23797,23796,-1,23597,23598,23798,23797,-1,23598,23599,23799,23798,-1,23600,23601,23801,23800,-1,23601,23602,23802,23801,-1,23602,23603,23803,23802,-1,23603,23604,23804,23803,-1,23604,23605,23805,23804,-1,23605,23606,23806,23805,-1,23606,23607,23807,23806,-1,23607,23608,23808,23807,-1,23608,23609,23809,23808,-1,23609,23610,23810,23809,-1,23610,23611,23811,23810,-1,23611,23612,23812,23811,-1,23612,23613,23813,23812,-1,23613,23614,23814,23813,-1,23614,23615,23815,23814,-1,23615,23616,23816,23815,-1,23616,23617,23817,23816,-1,23617,23618,23818,23817,-1,23618,23619,23819,23818,-1,23619,23620,23820,23819,-1,23620,23621,23821,23820,-1,23621,23622,23822,23821,-1,23622,23623,23823,23822,-1,23623,23624,23824,23823,-1,23624,23625,23825,23824,-1,23625,23626,23826,23825,-1,23626,23627,23827,23826,-1,23627,23628,23828,23827,-1,23628,23629,23829,23828,-1,23629,23630,23830,23829,-1,23630,23631,23831,23830,-1,23631,23632,23832,23831,-1,23632,23633,23833,23832,-1,23633,23634,23834,23833,-1,23634,23635,23835,23834,-1,23635,23636,23836,23835,-1,23636,23637,23837,23836,-1,23637,23638,23838,23837,-1,23638,23639,23839,23838,-1,23639,23640,23840,23839,-1,23640,23641,23841,23840,-1,23641,23642,23842,23841,-1,23642,23643,23843,23842,-1,23643,23644,23844,23843,-1,23644,23645,23845,23844,-1,23645,23646,23846,23845,-1,23646,23647,23847,23846,-1,23647,23648,23848,23847,-1,23648,23649,23849,23848,-1,23649,23650,23850,23849,-1,23650,23651,23851,23850,-1,23651,23652,23852,23851,-1,23652,23653,23853,23852,-1,23653,23654,23854,23853,-1,23654,23655,23855,23854,-1,23655,23656,23856,23855,-1,23656,23657,23857,23856,-1,23657,23658,23858,23857,-1,23658,23659,23859,23858,-1,23659,23660,23860,23859,-1,23660,23661,23861,23860,-1,23661,23662,23862,23861,-1,23662,23663,23863,23862,-1,23663,23664,23864,23863,-1,23664,23665,23865,23864,-1,23665,23666,23866,23865,-1,23666,23667,23867,23866,-1,23667,23668,23868,23867,-1,23668,23669,23869,23868,-1,23669,23670,23870,23869,-1,23670,23671,23871,23870,-1,23671,23672,23872,23871,-1,23672,23673,23873,23872,-1,23673,23674,23874,23873,-1,23674,23675,23875,23874,-1,23675,23676,23876,23875,-1,23676,23677,23877,23876,-1,23677,23678,23878,23877,-1,23678,23679,23879,23878,-1,23679,23680,23880,23879,-1,23680,23681,23881,23880,-1,23681,23682,23882,23881,-1,23682,23683,23883,23882,-1,23683,23684,23884,23883,-1,23684,23685,23885,23884,-1,23685,23686,23886,23885,-1,23686,23687,23887,23886,-1,23687,23688,23888,23887,-1,23688,23689,23889,23888,-1,23689,23690,23890,23889,-1,23690,23691,23891,23890,-1,23691,23692,23892,23891,-1,23692,23693,23893,23892,-1,23693,23694,23894,23893,-1,23694,23695,23895,23894,-1,23695,23696,23896,23895,-1,23696,23697,23897,23896,-1,23697,23698,23898,23897,-1,23698,23699,23899,23898,-1,23699,23700,23900,23899,-1,23700,23701,23901,23900,-1,23701,23702,23902,23901,-1,23702,23703,23903,23902,-1,23703,23704,23904,23903,-1,23704,23705,23905,23904,-1,23705,23706,23906,23905,-1,23706,23707,23907,23906,-1,23707,23708,23908,23907,-1,23708,23709,23909,23908,-1,23709,23710,23910,23909,-1,23710,23711,23911,23910,-1,23711,23712,23912,23911,-1,23712,23713,23913,23912,-1,23713,23714,23914,23913,-1,23714,23715,23915,23914,-1,23715,23716,23916,23915,-1,23716,23717,23917,23916,-1,23717,23718,23918,23917,-1,23718,23719,23919,23918,-1,23719,23720,23920,23919,-1,23720,23721,23921,23920,-1,23721,23722,23922,23921,-1,23722,23723,23923,23922,-1,23723,23724,23924,23923,-1,23724,23725,23925,23924,-1,23725,23726,23926,23925,-1,23726,23727,23927,23926,-1,23727,23728,23928,23927,-1,23728,23729,23929,23928,-1,23729,23730,23930,23929,-1,23730,23731,23931,23930,-1,23731,23732,23932,23931,-1,23732,23733,23933,23932,-1,23733,23734,23934,23933,-1,23734,23735,23935,23934,-1,23735,23736,23936,23935,-1,23736,23737,23937,23936,-1,23737,23738,23938,23937,-1,23738,23739,23939,23938,-1,23739,23740,23940,23939,-1,23740,23741,23941,23940,-1,23741,23742,23942,23941,-1,23742,23743,23943,23942,-1,23743,23744,23944,23943,-1,23744,23745,23945,23944,-1,23745,23746,23946,23945,-1,23746,23747,23947,23946,-1,23747,23748,23948,23947,-1,23748,23749,23949,23948,-1,23749,23750,23950,23949,-1,23750,23751,23951,23950,-1,23751,23752,23952,23951,-1,23752,23753,23953,23952,-1,23753,23754,23954,23953,-1,23754,23755,23955,23954,-1,23755,23756,23956,23955,-1,23756,23757,23957,23956,-1,23757,23758,23958,23957,-1,23758,23759,23959,23958,-1,23759,23760,23960,23959,-1,23760,23761,23961,23960,-1,23761,23762,23962,23961,-1,23762,23763,23963,23962,-1,23763,23764,23964,23963,-1,23764,23765,23965,23964,-1,23765,23766,23966,23965,-1,23766,23767,23967,23966,-1,23767,23768,23968,23967,-1,23768,23769,23969,23968,-1,23769,23770,23970,23969,-1,23770,23771,23971,23970,-1,23771,23772,23972,23971,-1,23772,23773,23973,23972,-1,23773,23774,23974,23973,-1,23774,23775,23975,23974,-1,23775,23776,23976,23975,-1,23776,23777,23977,23976,-1,23777,23778,23978,23977,-1,23778,23779,23979,23978,-1,23779,23780,23980,23979,-1,23780,23781,23981,23980,-1,23781,23782,23982,23981,-1,23782,23783,23983,23982,-1,23783,23784,23984,23983,-1,23784,23785,23985,23984,-1,23785,23786,23986,23985,-1,23786,23787,23987,23986,-1,23787,23788,23988,23987,-1,23788,23789,23989,23988,-1,23789,23790,23990,23989,-1,23790,23791,23991,23990,-1,23791,23792,23992,23991,-1,23792,23793,23993,23992,-1,23793,23794,23994,23993,-1,23794,23795,23995,23994,-1,23795,23796,23996,23995,-1,23796,23797,23997,23996,-1,23797,23798,23998,23997,-1,23798,23799,23999,23998,-1,23800,23801,24001,24,-1,23801,23802,24002,24001,-1,23802,23803,24003,24002,-1,23803,23804,24004,24003,-1,23804,23805,24005,24004,-1,23805,23806,24006,24005,-1,23806,23807,24007,24006,-1,23807,23808,24008,24007,-1,23808,23809,24009,24008,-1,23809,23810,24010,24009,-1,23810,23811,24011,24010,-1,23811,23812,24012,24011,-1,23812,23813,24013,24012,-1,23813,23814,24014,24013,-1,23814,23815,24015,24014,-1,23815,23816,24016,24015,-1,23816,23817,24017,24016,-1,23817,23818,24018,24017,-1,23818,23819,24019,24018,-1,23819,23820,24020,24019,-1,23820,23821,24021,24020,-1,23821,23822,24022,24021,-1,23822,23823,24023,24022,-1,23823,23824,24024,24023,-1,23824,23825,24025,24024,-1,23825,23826,24026,24025,-1,23826,23827,24027,24026,-1,23827,23828,24028,24027,-1,23828,23829,24029,24028,-1,23829,23830,24030,24029,-1,23830,23831,24031,24030,-1,23831,23832,24032,24031,-1,23832,23833,24033,24032,-1,23833,23834,24034,24033,-1,23834,23835,24035,24034,-1,23835,23836,24036,24035,-1,23836,23837,24037,24036,-1,23837,23838,24038,24037,-1,23838,23839,24039,24038,-1,23839,23840,24040,24039,-1,23840,23841,24041,24040,-1,23841,23842,24042,24041,-1,23842,23843,24043,24042,-1,23843,23844,24044,24043,-1,23844,23845,24045,24044,-1,23845,23846,24046,24045,-1,23846,23847,24047,24046,-1,23847,23848,24048,24047,-1,23848,23849,24049,24048,-1,23849,23850,24050,24049,-1,23850,23851,24051,24050,-1,23851,23852,24052,24051,-1,23852,23853,24053,24052,-1,23853,23854,24054,24053,-1,23854,23855,24055,24054,-1,23855,23856,24056,24055,-1,23856,23857,24057,24056,-1,23857,23858,24058,24057,-1,23858,23859,24059,24058,-1,23859,23860,24060,24059,-1,23860,23861,24061,24060,-1,23861,23862,24062,24061,-1,23862,23863,24063,24062,-1,23863,23864,24064,24063,-1,23864,23865,24065,24064,-1,23865,23866,24066,24065,-1,23866,23867,24067,24066,-1,23867,23868,24068,24067,-1,23868,23869,24069,24068,-1,23869,23870,24070,24069,-1,23870,23871,24071,24070,-1,23871,23872,24072,24071,-1,23872,23873,24073,24072,-1,23873,23874,24074,24073,-1,23874,23875,24075,24074,-1,23875,23876,24076,24075,-1,23876,23877,24077,24076,-1,23877,23878,24078,24077,-1,23878,23879,24079,24078,-1,23879,23880,24080,24079,-1,23880,23881,24081,24080,-1,23881,23882,24082,24081,-1,23882,23883,24083,24082,-1,23883,23884,24084,24083,-1,23884,23885,24085,24084,-1,23885,23886,24086,24085,-1,23886,23887,24087,24086,-1,23887,23888,24088,24087,-1,23888,23889,24089,24088,-1,23889,23890,24090,24089,-1,23890,23891,24091,24090,-1,23891,23892,24092,24091,-1,23892,23893,24093,24092,-1,23893,23894,24094,24093,-1,23894,23895,24095,24094,-1,23895,23896,24096,24095,-1,23896,23897,24097,24096,-1,23897,23898,24098,24097,-1,23898,23899,24099,24098,-1,23899,23900,24100,24099,-1,23900,23901,24101,24100,-1,23901,23902,24102,24101,-1,23902,23903,24103,24102,-1,23903,23904,24104,24103,-1,23904,23905,24105,24104,-1,23905,23906,24106,24105,-1,23906,23907,24107,24106,-1,23907,23908,24108,24107,-1,23908,23909,24109,24108,-1,23909,23910,24110,24109,-1,23910,23911,24111,24110,-1,23911,23912,24112,24111,-1,23912,23913,24113,24112,-1,23913,23914,24114,24113,-1,23914,23915,24115,24114,-1,23915,23916,24116,24115,-1,23916,23917,24117,24116,-1,23917,23918,24118,24117,-1,23918,23919,24119,24118,-1,23919,23920,24120,24119,-1,23920,23921,24121,24120,-1,23921,23922,24122,24121,-1,23922,23923,24123,24122,-1,23923,23924,24124,24123,-1,23924,23925,24125,24124,-1,23925,23926,24126,24125,-1,23926,23927,24127,24126,-1,23927,23928,24128,24127,-1,23928,23929,24129,24128,-1,23929,23930,24130,24129,-1,23930,23931,24131,24130,-1,23931,23932,24132,24131,-1,23932,23933,24133,24132,-1,23933,23934,24134,24133,-1,23934,23935,24135,24134,-1,23935,23936,24136,24135,-1,23936,23937,24137,24136,-1,23937,23938,24138,24137,-1,23938,23939,24139,24138,-1,23939,23940,24140,24139,-1,23940,23941,24141,24140,-1,23941,23942,24142,24141,-1,23942,23943,24143,24142,-1,23943,23944,24144,24143,-1,23944,23945,24145,24144,-1,23945,23946,24146,24145,-1,23946,23947,24147,24146,-1,23947,23948,24148,24147,-1,23948,23949,24149,24148,-1,23949,23950,24150,24149,-1,23950,23951,24151,24150,-1,23951,23952,24152,24151,-1,23952,23953,24153,24152,-1,23953,23954,24154,24153,-1,23954,23955,24155,24154,-1,23955,23956,24156,24155,-1,23956,23957,24157,24156,-1,23957,23958,24158,24157,-1,23958,23959,24159,24158,-1,23959,23960,24160,24159,-1,23960,23961,24161,24160,-1,23961,23962,24162,24161,-1,23962,23963,24163,24162,-1,23963,23964,24164,24163,-1,23964,23965,24165,24164,-1,23965,23966,24166,24165,-1,23966,23967,24167,24166,-1,23967,23968,24168,24167,-1,23968,23969,24169,24168,-1,23969,23970,24170,24169,-1,23970,23971,24171,24170,-1,23971,23972,24172,24171,-1,23972,23973,24173,24172,-1,23973,23974,24174,24173,-1,23974,23975,24175,24174,-1,23975,23976,24176,24175,-1,23976,23977,24177,24176,-1,23977,23978,24178,24177,-1,23978,23979,24179,24178,-1,23979,23980,24180,24179,-1,23980,23981,24181,24180,-1,23981,23982,24182,24181,-1,23982,23983,24183,24182,-1,23983,23984,24184,24183,-1,23984,23985,24185,24184,-1,23985,23986,24186,24185,-1,23986,23987,24187,24186,-1,23987,23988,24188,24187,-1,23988,23989,24189,24188,-1,23989,23990,24190,24189,-1,23990,23991,24191,24190,-1,23991,23992,24192,24191,-1,23992,23993,24193,24192,-1,23993,23994,24194,24193,-1,23994,23995,24195,24194,-1,23995,23996,24196,24195,-1,23996,23997,24197,24196,-1,23997,23998,24198,24197,-1,23998,23999,24199,24198,-1,24,24001,24201,24200,-1,24001,24002,24202,24201,-1,24002,24003,24203,24202,-1,24003,24004,24204,24203,-1,24004,24005,24205,24204,-1,24005,24006,24206,24205,-1,24006,24007,24207,24206,-1,24007,24008,24208,24207,-1,24008,24009,24209,24208,-1,24009,24010,24210,24209,-1,24010,24011,24211,24210,-1,24011,24012,24212,24211,-1,24012,24013,24213,24212,-1,24013,24014,24214,24213,-1,24014,24015,24215,24214,-1,24015,24016,24216,24215,-1,24016,24017,24217,24216,-1,24017,24018,24218,24217,-1,24018,24019,24219,24218,-1,24019,24020,24220,24219,-1,24020,24021,24221,24220,-1,24021,24022,24222,24221,-1,24022,24023,24223,24222,-1,24023,24024,24224,24223,-1,24024,24025,24225,24224,-1,24025,24026,24226,24225,-1,24026,24027,24227,24226,-1,24027,24028,24228,24227,-1,24028,24029,24229,24228,-1,24029,24030,24230,24229,-1,24030,24031,24231,24230,-1,24031,24032,24232,24231,-1,24032,24033,24233,24232,-1,24033,24034,24234,24233,-1,24034,24035,24235,24234,-1,24035,24036,24236,24235,-1,24036,24037,24237,24236,-1,24037,24038,24238,24237,-1,24038,24039,24239,24238,-1,24039,24040,24240,24239,-1,24040,24041,24241,24240,-1,24041,24042,24242,24241,-1,24042,24043,24243,24242,-1,24043,24044,24244,24243,-1,24044,24045,24245,24244,-1,24045,24046,24246,24245,-1,24046,24047,24247,24246,-1,24047,24048,24248,24247,-1,24048,24049,24249,24248,-1,24049,24050,24250,24249,-1,24050,24051,24251,24250,-1,24051,24052,24252,24251,-1,24052,24053,24253,24252,-1,24053,24054,24254,24253,-1,24054,24055,24255,24254,-1,24055,24056,24256,24255,-1,24056,24057,24257,24256,-1,24057,24058,24258,24257,-1,24058,24059,24259,24258,-1,24059,24060,24260,24259,-1,24060,24061,24261,24260,-1,24061,24062,24262,24261,-1,24062,24063,24263,24262,-1,24063,24064,24264,24263,-1,24064,24065,24265,24264,-1,24065,24066,24266,24265,-1,24066,24067,24267,24266,-1,24067,24068,24268,24267,-1,24068,24069,24269,24268,-1,24069,24070,24270,24269,-1,24070,24071,24271,24270,-1,24071,24072,24272,24271,-1,24072,24073,24273,24272,-1,24073,24074,24274,24273,-1,24074,24075,24275,24274,-1,24075,24076,24276,24275,-1,24076,24077,24277,24276,-1,24077,24078,24278,24277,-1,24078,24079,24279,24278,-1,24079,24080,24280,24279,-1,24080,24081,24281,24280,-1,24081,24082,24282,24281,-1,24082,24083,24283,24282,-1,24083,24084,24284,24283,-1,24084,24085,24285,24284,-1,24085,24086,24286,24285,-1,24086,24087,24287,24286,-1,24087,24088,24288,24287,-1,24088,24089,24289,24288,-1,24089,24090,24290,24289,-1,24090,24091,24291,24290,-1,24091,24092,24292,24291,-1,24092,24093,24293,24292,-1,24093,24094,24294,24293,-1,24094,24095,24295,24294,-1,24095,24096,24296,24295,-1,24096,24097,24297,24296,-1,24097,24098,24298,24297,-1,24098,24099,24299,24298,-1,24099,24100,24300,24299,-1,24100,24101,24301,24300,-1,24101,24102,24302,24301,-1,24102,24103,24303,24302,-1,24103,24104,24304,24303,-1,24104,24105,24305,24304,-1,24105,24106,24306,24305,-1,24106,24107,24307,24306,-1,24107,24108,24308,24307,-1,24108,24109,24309,24308,-1,24109,24110,24310,24309,-1,24110,24111,24311,24310,-1,24111,24112,24312,24311,-1,24112,24113,24313,24312,-1,24113,24114,24314,24313,-1,24114,24115,24315,24314,-1,24115,24116,24316,24315,-1,24116,24117,24317,24316,-1,24117,24118,24318,24317,-1,24118,24119,24319,24318,-1,24119,24120,24320,24319,-1,24120,24121,24321,24320,-1,24121,24122,24322,24321,-1,24122,24123,24323,24322,-1,24123,24124,24324,24323,-1,24124,24125,24325,24324,-1,24125,24126,24326,24325,-1,24126,24127,24327,24326,-1,24127,24128,24328,24327,-1,24128,24129,24329,24328,-1,24129,24130,24330,24329,-1,24130,24131,24331,24330,-1,24131,24132,24332,24331,-1,24132,24133,24333,24332,-1,24133,24134,24334,24333,-1,24134,24135,24335,24334,-1,24135,24136,24336,24335,-1,24136,24137,24337,24336,-1,24137,24138,24338,24337,-1,24138,24139,24339,24338,-1,24139,24140,24340,24339,-1,24140,24141,24341,24340,-1,24141,24142,24342,24341,-1,24142,24143,24343,24342,-1,24143,24144,24344,24343,-1,24144,24145,24345,24344,-1,24145,24146,24346,24345,-1,24146,24147,24347,24346,-1,24147,24148,24348,24347,-1,24148,24149,24349,24348,-1,24149,24150,24350,24349,-1,24150,24151,24351,24350,-1,24151,24152,24352,24351,-1,24152,24153,24353,24352,-1,24153,24154,24354,24353,-1,24154,24155,24355,24354,-1,24155,24156,24356,24355,-1,24156,24157,24357,24356,-1,24157,24158,24358,24357,-1,24158,24159,24359,24358,-1,24159,24160,24360,24359,-1,24160,24161,24361,24360,-1,24161,24162,24362,24361,-1,24162,24163,24363,24362,-1,24163,24164,24364,24363,-1,24164,24165,24365,24364,-1,24165,24166,24366,24365,-1,24166,24167,24367,24366,-1,24167,24168,24368,24367,-1,24168,24169,24369,24368,-1,24169,24170,24370,24369,-1,24170,24171,24371,24370,-1,24171,24172,24372,24371,-1,24172,24173,24373,24372,-1,24173,24174,24374,24373,-1,24174,24175,24375,24374,-1,24175,24176,24376,24375,-1,24176,24177,24377,24376,-1,24177,24178,24378,24377,-1,24178,24179,24379,24378,-1,24179,24180,24380,24379,-1,24180,24181,24381,24380,-1,24181,24182,24382,24381,-1,24182,24183,24383,24382,-1,24183,24184,24384,24383,-1,24184,24185,24385,24384,-1,24185,24186,24386,24385,-1,24186,24187,24387,24386,-1,24187,24188,24388,24387,-1,24188,24189,24389,24388,-1,24189,24190,24390,24389,-1,24190,24191,24391,24390,-1,24191,24192,24392,24391,-1,24192,24193,24393,24392,-1,24193,24194,24394,24393,-1,24194,24195,24395,24394,-1,24195,24196,24396,24395,-1,24196,24197,24397,24396,-1,24197,24198,24398,24397,-1,24198,24199,24399,24398,-1,24200,24201,24401,24400,-1,24201,24202,24402,24401,-1,24202,24203,24403,24402,-1,24203,24204,24404,24403,-1,24204,24205,24405,24404,-1,24205,24206,24406,24405,-1,24206,24207,24407,24406,-1,24207,24208,24408,24407,-1,24208,24209,24409,24408,-1,24209,24210,24410,24409,-1,24210,24211,24411,24410,-1,24211,24212,24412,24411,-1,24212,24213,24413,24412,-1,24213,24214,24414,24413,-1,24214,24215,24415,24414,-1,24215,24216,24416,24415,-1,24216,24217,24417,24416,-1,24217,24218,24418,24417,-1,24218,24219,24419,24418,-1,24219,24220,24420,24419,-1,24220,24221,24421,24420,-1,24221,24222,24422,24421,-1,24222,24223,24423,24422,-1,24223,24224,24424,24423,-1,24224,24225,24425,24424,-1,24225,24226,24426,24425,-1,24226,24227,24427,24426,-1,24227,24228,24428,24427,-1,24228,24229,24429,24428,-1,24229,24230,24430,24429,-1,24230,24231,24431,24430,-1,24231,24232,24432,24431,-1,24232,24233,24433,24432,-1,24233,24234,24434,24433,-1,24234,24235,24435,24434,-1,24235,24236,24436,24435,-1,24236,24237,24437,24436,-1,24237,24238,24438,24437,-1,24238,24239,24439,24438,-1,24239,24240,24440,24439,-1,24240,24241,24441,24440,-1,24241,24242,24442,24441,-1,24242,24243,24443,24442,-1,24243,24244,24444,24443,-1,24244,24245,24445,24444,-1,24245,24246,24446,24445,-1,24246,24247,24447,24446,-1,24247,24248,24448,24447,-1,24248,24249,24449,24448,-1,24249,24250,24450,24449,-1,24250,24251,24451,24450,-1,24251,24252,24452,24451,-1,24252,24253,24453,24452,-1,24253,24254,24454,24453,-1,24254,24255,24455,24454,-1,24255,24256,24456,24455,-1,24256,24257,24457,24456,-1,24257,24258,24458,24457,-1,24258,24259,24459,24458,-1,24259,24260,24460,24459,-1,24260,24261,24461,24460,-1,24261,24262,24462,24461,-1,24262,24263,24463,24462,-1,24263,24264,24464,24463,-1,24264,24265,24465,24464,-1,24265,24266,24466,24465,-1,24266,24267,24467,24466,-1,24267,24268,24468,24467,-1,24268,24269,24469,24468,-1,24269,24270,24470,24469,-1,24270,24271,24471,24470,-1,24271,24272,24472,24471,-1,24272,24273,24473,24472,-1,24273,24274,24474,24473,-1,24274,24275,24475,24474,-1,24275,24276,24476,24475,-1,24276,24277,24477,24476,-1,24277,24278,24478,24477,-1,24278,24279,24479,24478,-1,24279,24280,24480,24479,-1,24280,24281,24481,24480,-1,24281,24282,24482,24481,-1,24282,24283,24483,24482,-1,24283,24284,24484,24483,-1,24284,24285,24485,24484,-1,24285,24286,24486,24485,-1,24286,24287,24487,24486,-1,24287,24288,24488,24487,-1,24288,24289,24489,24488,-1,24289,24290,24490,24489,-1,24290,24291,24491,24490,-1,24291,24292,24492,24491,-1,24292,24293,24493,24492,-1,24293,24294,24494,24493,-1,24294,24295,24495,24494,-1,24295,24296,24496,24495,-1,24296,24297,24497,24496,-1,24297,24298,24498,24497,-1,24298,24299,24499,24498,-1,24299,24300,24500,24499,-1,24300,24301,24501,24500,-1,24301,24302,24502,24501,-1,24302,24303,24503,24502,-1,24303,24304,24504,24503,-1,24304,24305,24505,24504,-1,24305,24306,24506,24505,-1,24306,24307,24507,24506,-1,24307,24308,24508,24507,-1,24308,24309,24509,24508,-1,24309,24310,24510,24509,-1,24310,24311,24511,24510,-1,24311,24312,24512,24511,-1,24312,24313,24513,24512,-1,24313,24314,24514,24513,-1,24314,24315,24515,24514,-1,24315,24316,24516,24515,-1,24316,24317,24517,24516,-1,24317,24318,24518,24517,-1,24318,24319,24519,24518,-1,24319,24320,24520,24519,-1,24320,24321,24521,24520,-1,24321,24322,24522,24521,-1,24322,24323,24523,24522,-1,24323,24324,24524,24523,-1,24324,24325,24525,24524,-1,24325,24326,24526,24525,-1,24326,24327,24527,24526,-1,24327,24328,24528,24527,-1,24328,24329,24529,24528,-1,24329,24330,24530,24529,-1,24330,24331,24531,24530,-1,24331,24332,24532,24531,-1,24332,24333,24533,24532,-1,24333,24334,24534,24533,-1,24334,24335,24535,24534,-1,24335,24336,24536,24535,-1,24336,24337,24537,24536,-1,24337,24338,24538,24537,-1,24338,24339,24539,24538,-1,24339,24340,24540,24539,-1,24340,24341,24541,24540,-1,24341,24342,24542,24541,-1,24342,24343,24543,24542,-1,24343,24344,24544,24543,-1,24344,24345,24545,24544,-1,24345,24346,24546,24545,-1,24346,24347,24547,24546,-1,24347,24348,24548,24547,-1,24348,24349,24549,24548,-1,24349,24350,24550,24549,-1,24350,24351,24551,24550,-1,24351,24352,24552,24551,-1,24352,24353,24553,24552,-1,24353,24354,24554,24553,-1,24354,24355,24555,24554,-1,24355,24356,24556,24555,-1,24356,24357,24557,24556,-1,24357,24358,24558,24557,-1,24358,24359,24559,24558,-1,24359,24360,24560,24559,-1,24360,24361,24561,24560,-1,24361,24362,24562,24561,-1,24362,24363,24563,24562,-1,24363,24364,24564,24563,-1,24364,24365,24565,24564,-1,24365,24366,24566,24565,-1,24366,24367,24567,24566,-1,24367,24368,24568,24567,-1,24368,24369,24569,24568,-1,24369,24370,24570,24569,-1,24370,24371,24571,24570,-1,24371,24372,24572,24571,-1,24372,24373,24573,24572,-1,24373,24374,24574,24573,-1,24374,24375,24575,24574,-1,24375,24376,24576,24575,-1,24376,24377,24577,24576,-1,24377,24378,24578,24577,-1,24378,24379,24579,24578,-1,24379,24380,24580,24579,-1,24380,24381,24581,24580,-1,24381,24382,24582,24581,-1,24382,24383,24583,24582,-1,24383,24384,24584,24583,-1,24384,24385,24585,24584,-1,24385,24386,24586,24585,-1,24386,24387,24587,24586,-1,24387,24388,24588,24587,-1,24388,24389,24589,24588,-1,24389,24390,24590,24589,-1,24390,24391,24591,24590,-1,24391,24392,24592,24591,-1,24392,24393,24593,24592,-1,24393,24394,24594,24593,-1,24394,24395,24595,24594,-1,24395,24396,24596,24595,-1,24396,24397,24597,24596,-1,24397,24398,24598,24597,-1,24398,24399,24599,24598,-1,24400,24401,24601,24600,-1,24401,24402,24602,24601,-1,24402,24403,24603,24602,-1,24403,24404,24604,24603,-1,24404,24405,24605,24604,-1,24405,24406,24606,24605,-1,24406,24407,24607,24606,-1,24407,24408,24608,24607,-1,24408,24409,24609,24608,-1,24409,24410,24610,24609,-1,24410,24411,24611,24610,-1,24411,24412,24612,24611,-1,24412,24413,24613,24612,-1,24413,24414,24614,24613,-1,24414,24415,24615,24614,-1,24415,24416,24616,24615,-1,24416,24417,24617,24616,-1,24417,24418,24618,24617,-1,24418,24419,24619,24618,-1,24419,24420,24620,24619,-1,24420,24421,24621,24620,-1,24421,24422,24622,24621,-1,24422,24423,24623,24622,-1,24423,24424,24624,24623,-1,24424,24425,24625,24624,-1,24425,24426,24626,24625,-1,24426,24427,24627,24626,-1,24427,24428,24628,24627,-1,24428,24429,24629,24628,-1,24429,24430,24630,24629,-1,24430,24431,24631,24630,-1,24431,24432,24632,24631,-1,24432,24433,24633,24632,-1,24433,24434,24634,24633,-1,24434,24435,24635,24634,-1,24435,24436,24636,24635,-1,24436,24437,24637,24636,-1,24437,24438,24638,24637,-1,24438,24439,24639,24638,-1,24439,24440,24640,24639,-1,24440,24441,24641,24640,-1,24441,24442,24642,24641,-1,24442,24443,24643,24642,-1,24443,24444,24644,24643,-1,24444,24445,24645,24644,-1,24445,24446,24646,24645,-1,24446,24447,24647,24646,-1,24447,24448,24648,24647,-1,24448,24449,24649,24648,-1,24449,24450,24650,24649,-1,24450,24451,24651,24650,-1,24451,24452,24652,24651,-1,24452,24453,24653,24652,-1,24453,24454,24654,24653,-1,24454,24455,24655,24654,-1,24455,24456,24656,24655,-1,24456,24457,24657,24656,-1,24457,24458,24658,24657,-1,24458,24459,24659,24658,-1,24459,24460,24660,24659,-1,24460,24461,24661,24660,-1,24461,24462,24662,24661,-1,24462,24463,24663,24662,-1,24463,24464,24664,24663,-1,24464,24465,24665,24664,-1,24465,24466,24666,24665,-1,24466,24467,24667,24666,-1,24467,24468,24668,24667,-1,24468,24469,24669,24668,-1,24469,24470,24670,24669,-1,24470,24471,24671,24670,-1,24471,24472,24672,24671,-1,24472,24473,24673,24672,-1,24473,24474,24674,24673,-1,24474,24475,24675,24674,-1,24475,24476,24676,24675,-1,24476,24477,24677,24676,-1,24477,24478,24678,24677,-1,24478,24479,24679,24678,-1,24479,24480,24680,24679,-1,24480,24481,24681,24680,-1,24481,24482,24682,24681,-1,24482,24483,24683,24682,-1,24483,24484,24684,24683,-1,24484,24485,24685,24684,-1,24485,24486,24686,24685,-1,24486,24487,24687,24686,-1,24487,24488,24688,24687,-1,24488,24489,24689,24688,-1,24489,24490,24690,24689,-1,24490,24491,24691,24690,-1,24491,24492,24692,24691,-1,24492,24493,24693,24692,-1,24493,24494,24694,24693,-1,24494,24495,24695,24694,-1,24495,24496,24696,24695,-1,24496,24497,24697,24696,-1,24497,24498,24698,24697,-1,24498,24499,24699,24698,-1,24499,24500,24700,24699,-1,24500,24501,24701,24700,-1,24501,24502,24702,24701,-1,24502,24503,24703,24702,-1,24503,24504,24704,24703,-1,24504,24505,24705,24704,-1,24505,24506,24706,24705,-1,24506,24507,24707,24706,-1,24507,24508,24708,24707,-1,24508,24509,24709,24708,-1,24509,24510,24710,24709,-1,24510,24511,24711,24710,-1,24511,24512,24712,24711,-1,24512,24513,24713,24712,-1,24513,24514,24714,24713,-1,24514,24515,24715,24714,-1,24515,24516,24716,24715,-1,24516,24517,24717,24716,-1,24517,24518,24718,24717,-1,24518,24519,24719,24718,-1,24519,24520,24720,24719,-1,24520,24521,24721,24720,-1,24521,24522,24722,24721,-1,24522,24523,24723,24722,-1,24523,24524,24724,24723,-1,24524,24525,24725,24724,-1,24525,24526,24726,24725,-1,24526,24527,24727,24726,-1,24527,24528,24728,24727,-1,24528,24529,24729,24728,-1,24529,24530,24730,24729,-1,24530,24531,24731,24730,-1,24531,24532,24732,24731,-1,24532,24533,24733,24732,-1,24533,24534,24734,24733,-1,24534,24535,24735,24734,-1,24535,24536,24736,24735,-1,24536,24537,24737,24736,-1,24537,24538,24738,24737,-1,24538,24539,24739,24738,-1,24539,24540,24740,24739,-1,24540,24541,24741,24740,-1,24541,24542,24742,24741,-1,24542,24543,24743,24742,-1,24543,24544,24744,24743,-1,24544,24545,24745,24744,-1,24545,24546,24746,24745,-1,24546,24547,24747,24746,-1,24547,24548,24748,24747,-1,24548,24549,24749,24748,-1,24549,24550,24750,24749,-1,24550,24551,24751,24750,-1,24551,24552,24752,24751,-1,24552,24553,24753,24752,-1,24553,24554,24754,24753,-1,24554,24555,24755,24754,-1,24555,24556,24756,24755,-1,24556,24557,24757,24756,-1,24557,24558,24758,24757,-1,24558,24559,24759,24758,-1,24559,24560,24760,24759,-1,24560,24561,24761,24760,-1,24561,24562,24762,24761,-1,24562,24563,24763,24762,-1,24563,24564,24764,24763,-1,24564,24565,24765,24764,-1,24565,24566,24766,24765,-1,24566,24567,24767,24766,-1,24567,24568,24768,24767,-1,24568,24569,24769,24768,-1,24569,24570,24770,24769,-1,24570,24571,24771,24770,-1,24571,24572,24772,24771,-1,24572,24573,24773,24772,-1,24573,24574,24774,24773,-1,24574,24575,24775,24774,-1,24575,24576,24776,24775,-1,24576,24577,24777,24776,-1,24577,24578,24778,24777,-1,24578,24579,24779,24778,-1,24579,24580,24780,24779,-1,24580,24581,24781,24780,-1,24581,24582,24782,24781,-1,24582,24583,24783,24782,-1,24583,24584,24784,24783,-1,24584,24585,24785,24784,-1,24585,24586,24786,24785,-1,24586,24587,24787,24786,-1,24587,24588,24788,24787,-1,24588,24589,24789,24788,-1,24589,24590,24790,24789,-1,24590,24591,24791,24790,-1,24591,24592,24792,24791,-1,24592,24593,24793,24792,-1,24593,24594,24794,24793,-1,24594,24595,24795,24794,-1,24595,24596,24796,24795,-1,24596,24597,24797,24796,-1,24597,24598,24798,24797,-1,24598,24599,24799,24798,-1,24600,24601,24801,24800,-1,24601,24602,24802,24801,-1,24602,24603,24803,24802,-1,24603,24604,24804,24803,-1,24604,24605,24805,24804,-1,24605,24606,24806,24805,-1,24606,24607,24807,24806,-1,24607,24608,24808,24807,-1,24608,24609,24809,24808,-1,24609,24610,24810,24809,-1,24610,24611,24811,24810,-1,24611,24612,24812,24811,-1,24612,24613,24813,24812,-1,24613,24614,24814,24813,-1,24614,24615,24815,24814,-1,24615,24616,24816,24815,-1,24616,24617,24817,24816,-1,24617,24618,24818,24817,-1,24618,24619,24819,24818,-1,24619,24620,24820,24819,-1,24620,24621,24821,24820,-1,24621,24622,24822,24821,-1,24622,24623,24823,24822,-1,24623,24624,24824,24823,-1,24624,24625,24825,24824,-1,24625,24626,24826,24825,-1,24626,24627,24827,24826,-1,24627,24628,24828,24827,-1,24628,24629,24829,24828,-1,24629,24630,24830,24829,-1,24630,24631,24831,24830,-1,24631,24632,24832,24831,-1,24632,24633,24833,24832,-1,24633,24634,24834,24833,-1,24634,24635,24835,24834,-1,24635,24636,24836,24835,-1,24636,24637,24837,24836,-1,24637,24638,24838,24837,-1,24638,24639,24839,24838,-1,24639,24640,24840,24839,-1,24640,24641,24841,24840,-1,24641,24642,24842,24841,-1,24642,24643,24843,24842,-1,24643,24644,24844,24843,-1,24644,24645,24845,24844,-1,24645,24646,24846,24845,-1,24646,24647,24847,24846,-1,24647,24648,24848,24847,-1,24648,24649,24849,24848,-1,24649,24650,24850,24849,-1,24650,24651,24851,24850,-1,24651,24652,24852,24851,-1,24652,24653,24853,24852,-1,24653,24654,24854,24853,-1,24654,24655,24855,24854,-1,24655,24656,24856,24855,-1,24656,24657,24857,24856,-1,24657,24658,24858,24857,-1,24658,24659,24859,24858,-1,24659,24660,24860,24859,-1,24660,24661,24861,24860,-1,24661,24662,24862,24861,-1,24662,24663,24863,24862,-1,24663,24664,24864,24863,-1,24664,24665,24865,24864,-1,24665,24666,24866,24865,-1,24666,24667,24867,24866,-1,24667,24668,24868,24867,-1,24668,24669,24869,24868,-1,24669,24670,24870,24869,-1,24670,24671,24871,24870,-1,24671,24672,24872,24871,-1,24672,24673,24873,24872,-1,24673,24674,24874,24873,-1,24674,24675,24875,24874,-1,24675,24676,24876,24875,-1,24676,24677,24877,24876,-1,24677,24678,24878,24877,-1,24678,24679,24879,24878,-1,24679,24680,24880,24879,-1,24680,24681,24881,24880,-1,24681,24682,24882,24881,-1,24682,24683,24883,24882,-1,24683,24684,24884,24883,-1,24684,24685,24885,24884,-1,24685,24686,24886,24885,-1,24686,24687,24887,24886,-1,24687,24688,24888,24887,-1,24688,24689,24889,24888,-1,24689,24690,24890,24889,-1,24690,24691,24891,24890,-1,24691,24692,24892,24891,-1,24692,24693,24893,24892,-1,24693,24694,24894,24893,-1,24694,24695,24895,24894,-1,24695,24696,24896,24895,-1,24696,24697,24897,24896,-1,24697,24698,24898,24897,-1,24698,24699,24899,24898,-1,24699,24700,24900,24899,-1,24700,24701,24901,24900,-1,24701,24702,24902,24901,-1,24702,24703,24903,24902,-1,24703,24704,24904,24903,-1,24704,24705,24905,24904,-1,24705,24706,24906,24905,-1,24706,24707,24907,24906,-1,24707,24708,24908,24907,-1,24708,24709,24909,24908,-1,24709,24710,24910,24909,-1,24710,24711,24911,24910,-1,24711,24712,24912,24911,-1,24712,24713,24913,24912,-1,24713,24714,24914,24913,-1,24714,24715,24915,24914,-1,24715,24716,24916,24915,-1,24716,24717,24917,24916,-1,24717,24718,24918,24917,-1,24718,24719,24919,24918,-1,24719,24720,24920,24919,-1,24720,24721,24921,24920,-1,24721,24722,24922,24921,-1,24722,24723,24923,24922,-1,24723,24724,24924,24923,-1,24724,24725,24925,24924,-1,24725,24726,24926,24925,-1,24726,24727,24927,24926,-1,24727,24728,24928,24927,-1,24728,24729,24929,24928,-1,24729,24730,24930,24929,-1,24730,24731,24931,24930,-1,24731,24732,24932,24931,-1,24732,24733,24933,24932,-1,24733,24734,24934,24933,-1,24734,24735,24935,24934,-1,24735,24736,24936,24935,-1,24736,24737,24937,24936,-1,24737,24738,24938,24937,-1,24738,24739,24939,24938,-1,24739,24740,24940,24939,-1,24740,24741,24941,24940,-1,24741,24742,24942,24941,-1,24742,24743,24943,24942,-1,24743,24744,24944,24943,-1,24744,24745,24945,24944,-1,24745,24746,24946,24945,-1,24746,24747,24947,24946,-1,24747,24748,24948,24947,-1,24748,24749,24949,24948,-1,24749,24750,24950,24949,-1,24750,24751,24951,24950,-1,24751,24752,24952,24951,-1,24752,24753,24953,24952,-1,24753,24754,24954,24953,-1,24754,24755,24955,24954,-1,24755,24756,24956,24955,-1,24756,24757,24957,24956,-1,24757,24758,24958,24957,-1,24758,24759,24959,24958,-1,24759,24760,24960,24959,-1,24760,24761,24961,24960,-1,24761,24762,24962,24961,-1,24762,24763,24963,24962,-1,24763,24764,24964,24963,-1,24764,24765,24965,24964,-1,24765,24766,24966,24965,-1,24766,24767,24967,24966,-1,24767,24768,24968,24967,-1,24768,24769,24969,24968,-1,24769,24770,24970,24969,-1,24770,24771,24971,24970,-1,24771,24772,24972,24971,-1,24772,24773,24973,24972,-1,24773,24774,24974,24973,-1,24774,24775,24975,24974,-1,24775,24776,24976,24975,-1,24776,24777,24977,24976,-1,24777,24778,24978,24977,-1,24778,24779,24979,24978,-1,24779,24780,24980,24979,-1,24780,24781,24981,24980,-1,24781,24782,24982,24981,-1,24782,24783,24983,24982,-1,24783,24784,24984,24983,-1,24784,24785,24985,24984,-1,24785,24786,24986,24985,-1,24786,24787,24987,24986,-1,24787,24788,24988,24987,-1,24788,24789,24989,24988,-1,24789,24790,24990,24989,-1,24790,24791,24991,24990,-1,24791,24792,24992,24991,-1,24792,24793,24993,24992,-1,24793,24794,24994,24993,-1,24794,24795,24995,24994,-1,24795,24796,24996,24995,-1,24796,24797,24997,24996,-1,24797,24798,24998,24997,-1,24798,24799,24999,24998,-1,24800,24801,25001,25,-1,24801,24802,25002,25001,-1,24802,24803,25003,25002,-1,24803,24804,25004,25003,-1,24804,24805,25005,25004,-1,24805,24806,25006,25005,-1,24806,24807,25007,25006,-1,24807,24808,25008,25007,-1,24808,24809,25009,25008,-1,24809,24810,25010,25009,-1,24810,24811,25011,25010,-1,24811,24812,25012,25011,-1,24812,24813,25013,25012,-1,24813,24814,25014,25013,-1,24814,24815,25015,25014,-1,24815,24816,25016,25015,-1,24816,24817,25017,25016,-1,24817,24818,25018,25017,-1,24818,24819,25019,25018,-1,24819,24820,25020,25019,-1,24820,24821,25021,25020,-1,24821,24822,25022,25021,-1,24822,24823,25023,25022,-1,24823,24824,25024,25023,-1,24824,24825,25025,25024,-1,24825,24826,25026,25025,-1,24826,24827,25027,25026,-1,24827,24828,25028,25027,-1,24828,24829,25029,25028,-1,24829,24830,25030,25029,-1,24830,24831,25031,25030,-1,24831,24832,25032,25031,-1,24832,24833,25033,25032,-1,24833,24834,25034,25033,-1,24834,24835,25035,25034,-1,24835,24836,25036,25035,-1,24836,24837,25037,25036,-1,24837,24838,25038,25037,-1,24838,24839,25039,25038,-1,24839,24840,25040,25039,-1,24840,24841,25041,25040,-1,24841,24842,25042,25041,-1,24842,24843,25043,25042,-1,24843,24844,25044,25043,-1,24844,24845,25045,25044,-1,24845,24846,25046,25045,-1,24846,24847,25047,25046,-1,24847,24848,25048,25047,-1,24848,24849,25049,25048,-1,24849,24850,25050,25049,-1,24850,24851,25051,25050,-1,24851,24852,25052,25051,-1,24852,24853,25053,25052,-1,24853,24854,25054,25053,-1,24854,24855,25055,25054,-1,24855,24856,25056,25055,-1,24856,24857,25057,25056,-1,24857,24858,25058,25057,-1,24858,24859,25059,25058,-1,24859,24860,25060,25059,-1,24860,24861,25061,25060,-1,24861,24862,25062,25061,-1,24862,24863,25063,25062,-1,24863,24864,25064,25063,-1,24864,24865,25065,25064,-1,24865,24866,25066,25065,-1,24866,24867,25067,25066,-1,24867,24868,25068,25067,-1,24868,24869,25069,25068,-1,24869,24870,25070,25069,-1,24870,24871,25071,25070,-1,24871,24872,25072,25071,-1,24872,24873,25073,25072,-1,24873,24874,25074,25073,-1,24874,24875,25075,25074,-1,24875,24876,25076,25075,-1,24876,24877,25077,25076,-1,24877,24878,25078,25077,-1,24878,24879,25079,25078,-1,24879,24880,25080,25079,-1,24880,24881,25081,25080,-1,24881,24882,25082,25081,-1,24882,24883,25083,25082,-1,24883,24884,25084,25083,-1,24884,24885,25085,25084,-1,24885,24886,25086,25085,-1,24886,24887,25087,25086,-1,24887,24888,25088,25087,-1,24888,24889,25089,25088,-1,24889,24890,25090,25089,-1,24890,24891,25091,25090,-1,24891,24892,25092,25091,-1,24892,24893,25093,25092,-1,24893,24894,25094,25093,-1,24894,24895,25095,25094,-1,24895,24896,25096,25095,-1,24896,24897,25097,25096,-1,24897,24898,25098,25097,-1,24898,24899,25099,25098,-1,24899,24900,25100,25099,-1,24900,24901,25101,25100,-1,24901,24902,25102,25101,-1,24902,24903,25103,25102,-1,24903,24904,25104,25103,-1,24904,24905,25105,25104,-1,24905,24906,25106,25105,-1,24906,24907,25107,25106,-1,24907,24908,25108,25107,-1,24908,24909,25109,25108,-1,24909,24910,25110,25109,-1,24910,24911,25111,25110,-1,24911,24912,25112,25111,-1,24912,24913,25113,25112,-1,24913,24914,25114,25113,-1,24914,24915,25115,25114,-1,24915,24916,25116,25115,-1,24916,24917,25117,25116,-1,24917,24918,25118,25117,-1,24918,24919,25119,25118,-1,24919,24920,25120,25119,-1,24920,24921,25121,25120,-1,24921,24922,25122,25121,-1,24922,24923,25123,25122,-1,24923,24924,25124,25123,-1,24924,24925,25125,25124,-1,24925,24926,25126,25125,-1,24926,24927,25127,25126,-1,24927,24928,25128,25127,-1,24928,24929,25129,25128,-1,24929,24930,25130,25129,-1,24930,24931,25131,25130,-1,24931,24932,25132,25131,-1,24932,24933,25133,25132,-1,24933,24934,25134,25133,-1,24934,24935,25135,25134,-1,24935,24936,25136,25135,-1,24936,24937,25137,25136,-1,24937,24938,25138,25137,-1,24938,24939,25139,25138,-1,24939,24940,25140,25139,-1,24940,24941,25141,25140,-1,24941,24942,25142,25141,-1,24942,24943,25143,25142,-1,24943,24944,25144,25143,-1,24944,24945,25145,25144,-1,24945,24946,25146,25145,-1,24946,24947,25147,25146,-1,24947,24948,25148,25147,-1,24948,24949,25149,25148,-1,24949,24950,25150,25149,-1,24950,24951,25151,25150,-1,24951,24952,25152,25151,-1,24952,24953,25153,25152,-1,24953,24954,25154,25153,-1,24954,24955,25155,25154,-1,24955,24956,25156,25155,-1,24956,24957,25157,25156,-1,24957,24958,25158,25157,-1,24958,24959,25159,25158,-1,24959,24960,25160,25159,-1,24960,24961,25161,25160,-1,24961,24962,25162,25161,-1,24962,24963,25163,25162,-1,24963,24964,25164,25163,-1,24964,24965,25165,25164,-1,24965,24966,25166,25165,-1,24966,24967,25167,25166,-1,24967,24968,25168,25167,-1,24968,24969,25169,25168,-1,24969,24970,25170,25169,-1,24970,24971,25171,25170,-1,24971,24972,25172,25171,-1,24972,24973,25173,25172,-1,24973,24974,25174,25173,-1,24974,24975,25175,25174,-1,24975,24976,25176,25175,-1,24976,24977,25177,25176,-1,24977,24978,25178,25177,-1,24978,24979,25179,25178,-1,24979,24980,25180,25179,-1,24980,24981,25181,25180,-1,24981,24982,25182,25181,-1,24982,24983,25183,25182,-1,24983,24984,25184,25183,-1,24984,24985,25185,25184,-1,24985,24986,25186,25185,-1,24986,24987,25187,25186,-1,24987,24988,25188,25187,-1,24988,24989,25189,25188,-1,24989,24990,25190,25189,-1,24990,24991,25191,25190,-1,24991,24992,25192,25191,-1,24992,24993,25193,25192,-1,24993,24994,25194,25193,-1,24994,24995,25195,25194,-1,24995,24996,25196,25195,-1,24996,24997,25197,25196,-1,24997,24998,25198,25197,-1,24998,24999,25199,25198,-1,25,25001,25201,25200,-1,25001,25002,25202,25201,-1,25002,25003,25203,25202,-1,25003,25004,25204,25203,-1,25004,25005,25205,25204,-1,25005,25006,25206,25205,-1,25006,25007,25207,25206,-1,25007,25008,25208,25207,-1,25008,25009,25209,25208,-1,25009,25010,25210,25209,-1,25010,25011,25211,25210,-1,25011,25012,25212,25211,-1,25012,25013,25213,25212,-1,25013,25014,25214,25213,-1,25014,25015,25215,25214,-1,25015,25016,25216,25215,-1,25016,25017,25217,25216,-1,25017,25018,25218,25217,-1,25018,25019,25219,25218,-1,25019,25020,25220,25219,-1,25020,25021,25221,25220,-1,25021,25022,25222,25221,-1,25022,25023,25223,25222,-1,25023,25024,25224,25223,-1,25024,25025,25225,25224,-1,25025,25026,25226,25225,-1,25026,25027,25227,25226,-1,25027,25028,25228,25227,-1,25028,25029,25229,25228,-1,25029,25030,25230,25229,-1,25030,25031,25231,25230,-1,25031,25032,25232,25231,-1,25032,25033,25233,25232,-1,25033,25034,25234,25233,-1,25034,25035,25235,25234,-1,25035,25036,25236,25235,-1,25036,25037,25237,25236,-1,25037,25038,25238,25237,-1,25038,25039,25239,25238,-1,25039,25040,25240,25239,-1,25040,25041,25241,25240,-1,25041,25042,25242,25241,-1,25042,25043,25243,25242,-1,25043,25044,25244,25243,-1,25044,25045,25245,25244,-1,25045,25046,25246,25245,-1,25046,25047,25247,25246,-1,25047,25048,25248,25247,-1,25048,25049,25249,25248,-1,25049,25050,25250,25249,-1,25050,25051,25251,25250,-1,25051,25052,25252,25251,-1,25052,25053,25253,25252,-1,25053,25054,25254,25253,-1,25054,25055,25255,25254,-1,25055,25056,25256,25255,-1,25056,25057,25257,25256,-1,25057,25058,25258,25257,-1,25058,25059,25259,25258,-1,25059,25060,25260,25259,-1,25060,25061,25261,25260,-1,25061,25062,25262,25261,-1,25062,25063,25263,25262,-1,25063,25064,25264,25263,-1,25064,25065,25265,25264,-1,25065,25066,25266,25265,-1,25066,25067,25267,25266,-1,25067,25068,25268,25267,-1,25068,25069,25269,25268,-1,25069,25070,25270,25269,-1,25070,25071,25271,25270,-1,25071,25072,25272,25271,-1,25072,25073,25273,25272,-1,25073,25074,25274,25273,-1,25074,25075,25275,25274,-1,25075,25076,25276,25275,-1,25076,25077,25277,25276,-1,25077,25078,25278,25277,-1,25078,25079,25279,25278,-1,25079,25080,25280,25279,-1,25080,25081,25281,25280,-1,25081,25082,25282,25281,-1,25082,25083,25283,25282,-1,25083,25084,25284,25283,-1,25084,25085,25285,25284,-1,25085,25086,25286,25285,-1,25086,25087,25287,25286,-1,25087,25088,25288,25287,-1,25088,25089,25289,25288,-1,25089,25090,25290,25289,-1,25090,25091,25291,25290,-1,25091,25092,25292,25291,-1,25092,25093,25293,25292,-1,25093,25094,25294,25293,-1,25094,25095,25295,25294,-1,25095,25096,25296,25295,-1,25096,25097,25297,25296,-1,25097,25098,25298,25297,-1,25098,25099,25299,25298,-1,25099,25100,25300,25299,-1,25100,25101,25301,25300,-1,25101,25102,25302,25301,-1,25102,25103,25303,25302,-1,25103,25104,25304,25303,-1,25104,25105,25305,25304,-1,25105,25106,25306,25305,-1,25106,25107,25307,25306,-1,25107,25108,25308,25307,-1,25108,25109,25309,25308,-1,25109,25110,25310,25309,-1,25110,25111,25311,25310,-1,25111,25112,25312,25311,-1,25112,25113,25313,25312,-1,25113,25114,25314,25313,-1,25114,25115,25315,25314,-1,25115,25116,25316,25315,-1,25116,25117,25317,25316,-1,25117,25118,25318,25317,-1,25118,25119,25319,25318,-1,25119,25120,25320,25319,-1,25120,25121,25321,25320,-1,25121,25122,25322,25321,-1,25122,25123,25323,25322,-1,25123,25124,25324,25323,-1,25124,25125,25325,25324,-1,25125,25126,25326,25325,-1,25126,25127,25327,25326,-1,25127,25128,25328,25327,-1,25128,25129,25329,25328,-1,25129,25130,25330,25329,-1,25130,25131,25331,25330,-1,25131,25132,25332,25331,-1,25132,25133,25333,25332,-1,25133,25134,25334,25333,-1,25134,25135,25335,25334,-1,25135,25136,25336,25335,-1,25136,25137,25337,25336,-1,25137,25138,25338,25337,-1,25138,25139,25339,25338,-1,25139,25140,25340,25339,-1,25140,25141,25341,25340,-1,25141,25142,25342,25341,-1,25142,25143,25343,25342,-1,25143,25144,25344,25343,-1,25144,25145,25345,25344,-1,25145,25146,25346,25345,-1,25146,25147,25347,25346,-1,25147,25148,25348,25347,-1,25148,25149,25349,25348,-1,25149,25150,25350,25349,-1,25150,25151,25351,25350,-1,25151,25152,25352,25351,-1,25152,25153,25353,25352,-1,25153,25154,25354,25353,-1,25154,25155,25355,25354,-1,25155,25156,25356,25355,-1,25156,25157,25357,25356,-1,25157,25158,25358,25357,-1,25158,25159,25359,25358,-1,25159,25160,25360,25359,-1,25160,25161,25361,25360,-1,25161,25162,25362,25361,-1,25162,25163,25363,25362,-1,25163,25164,25364,25363,-1,25164,25165,25365,25364,-1,25165,25166,25366,25365,-1,25166,25167,25367,25366,-1,25167,25168,25368,25367,-1,25168,25169,25369,25368,-1,25169,25170,25370,25369,-1,25170,25171,25371,25370,-1,25171,25172,25372,25371,-1,25172,25173,25373,25372,-1,25173,25174,25374,25373,-1,25174,25175,25375,25374,-1,25175,25176,25376,25375,-1,25176,25177,25377,25376,-1,25177,25178,25378,25377,-1,25178,25179,25379,25378,-1,25179,25180,25380,25379,-1,25180,25181,25381,25380,-1,25181,25182,25382,25381,-1,25182,25183,25383,25382,-1,25183,25184,25384,25383,-1,25184,25185,25385,25384,-1,25185,25186,25386,25385,-1,25186,25187,25387,25386,-1,25187,25188,25388,25387,-1,25188,25189,25389,25388,-1,25189,25190,25390,25389,-1,25190,25191,25391,25390,-1,25191,25192,25392,25391,-1,25192,25193,25393,25392,-1,25193,25194,25394,25393,-1,25194,25195,25395,25394,-1,25195,25196,25396,25395,-1,25196,25197,25397,25396,-1,25197,25198,25398,25397,-1,25198,25199,25399,25398,-1,25200,25201,25401,25400,-1,25201,25202,25402,25401,-1,25202,25203,25403,25402,-1,25203,25204,25404,25403,-1,25204,25205,25405,25404,-1,25205,25206,25406,25405,-1,25206,25207,25407,25406,-1,25207,25208,25408,25407,-1,25208,25209,25409,25408,-1,25209,25210,25410,25409,-1,25210,25211,25411,25410,-1,25211,25212,25412,25411,-1,25212,25213,25413,25412,-1,25213,25214,25414,25413,-1,25214,25215,25415,25414,-1,25215,25216,25416,25415,-1,25216,25217,25417,25416,-1,25217,25218,25418,25417,-1,25218,25219,25419,25418,-1,25219,25220,25420,25419,-1,25220,25221,25421,25420,-1,25221,25222,25422,25421,-1,25222,25223,25423,25422,-1,25223,25224,25424,25423,-1,25224,25225,25425,25424,-1,25225,25226,25426,25425,-1,25226,25227,25427,25426,-1,25227,25228,25428,25427,-1,25228,25229,25429,25428,-1,25229,25230,25430,25429,-1,25230,25231,25431,25430,-1,25231,25232,25432,25431,-1,25232,25233,25433,25432,-1,25233,25234,25434,25433,-1,25234,25235,25435,25434,-1,25235,25236,25436,25435,-1,25236,25237,25437,25436,-1,25237,25238,25438,25437,-1,25238,25239,25439,25438,-1,25239,25240,25440,25439,-1,25240,25241,25441,25440,-1,25241,25242,25442,25441,-1,25242,25243,25443,25442,-1,25243,25244,25444,25443,-1,25244,25245,25445,25444,-1,25245,25246,25446,25445,-1,25246,25247,25447,25446,-1,25247,25248,25448,25447,-1,25248,25249,25449,25448,-1,25249,25250,25450,25449,-1,25250,25251,25451,25450,-1,25251,25252,25452,25451,-1,25252,25253,25453,25452,-1,25253,25254,25454,25453,-1,25254,25255,25455,25454,-1,25255,25256,25456,25455,-1,25256,25257,25457,25456,-1,25257,25258,25458,25457,-1,25258,25259,25459,25458,-1,25259,25260,25460,25459,-1,25260,25261,25461,25460,-1,25261,25262,25462,25461,-1,25262,25263,25463,25462,-1,25263,25264,25464,25463,-1,25264,25265,25465,25464,-1,25265,25266,25466,25465,-1,25266,25267,25467,25466,-1,25267,25268,25468,25467,-1,25268,25269,25469,25468,-1,25269,25270,25470,25469,-1,25270,25271,25471,25470,-1,25271,25272,25472,25471,-1,25272,25273,25473,25472,-1,25273,25274,25474,25473,-1,25274,25275,25475,25474,-1,25275,25276,25476,25475,-1,25276,25277,25477,25476,-1,25277,25278,25478,25477,-1,25278,25279,25479,25478,-1,25279,25280,25480,25479,-1,25280,25281,25481,25480,-1,25281,25282,25482,25481,-1,25282,25283,25483,25482,-1,25283,25284,25484,25483,-1,25284,25285,25485,25484,-1,25285,25286,25486,25485,-1,25286,25287,25487,25486,-1,25287,25288,25488,25487,-1,25288,25289,25489,25488,-1,25289,25290,25490,25489,-1,25290,25291,25491,25490,-1,25291,25292,25492,25491,-1,25292,25293,25493,25492,-1,25293,25294,25494,25493,-1,25294,25295,25495,25494,-1,25295,25296,25496,25495,-1,25296,25297,25497,25496,-1,25297,25298,25498,25497,-1,25298,25299,25499,25498,-1,25299,25300,25500,25499,-1,25300,25301,25501,25500,-1,25301,25302,25502,25501,-1,25302,25303,25503,25502,-1,25303,25304,25504,25503,-1,25304,25305,25505,25504,-1,25305,25306,25506,25505,-1,25306,25307,25507,25506,-1,25307,25308,25508,25507,-1,25308,25309,25509,25508,-1,25309,25310,25510,25509,-1,25310,25311,25511,25510,-1,25311,25312,25512,25511,-1,25312,25313,25513,25512,-1,25313,25314,25514,25513,-1,25314,25315,25515,25514,-1,25315,25316,25516,25515,-1,25316,25317,25517,25516,-1,25317,25318,25518,25517,-1,25318,25319,25519,25518,-1,25319,25320,25520,25519,-1,25320,25321,25521,25520,-1,25321,25322,25522,25521,-1,25322,25323,25523,25522,-1,25323,25324,25524,25523,-1,25324,25325,25525,25524,-1,25325,25326,25526,25525,-1,25326,25327,25527,25526,-1,25327,25328,25528,25527,-1,25328,25329,25529,25528,-1,25329,25330,25530,25529,-1,25330,25331,25531,25530,-1,25331,25332,25532,25531,-1,25332,25333,25533,25532,-1,25333,25334,25534,25533,-1,25334,25335,25535,25534,-1,25335,25336,25536,25535,-1,25336,25337,25537,25536,-1,25337,25338,25538,25537,-1,25338,25339,25539,25538,-1,25339,25340,25540,25539,-1,25340,25341,25541,25540,-1,25341,25342,25542,25541,-1,25342,25343,25543,25542,-1,25343,25344,25544,25543,-1,25344,25345,25545,25544,-1,25345,25346,25546,25545,-1,25346,25347,25547,25546,-1,25347,25348,25548,25547,-1,25348,25349,25549,25548,-1,25349,25350,25550,25549,-1,25350,25351,25551,25550,-1,25351,25352,25552,25551,-1,25352,25353,25553,25552,-1,25353,25354,25554,25553,-1,25354,25355,25555,25554,-1,25355,25356,25556,25555,-1,25356,25357,25557,25556,-1,25357,25358,25558,25557,-1,25358,25359,25559,25558,-1,25359,25360,25560,25559,-1,25360,25361,25561,25560,-1,25361,25362,25562,25561,-1,25362,25363,25563,25562,-1,25363,25364,25564,25563,-1,25364,25365,25565,25564,-1,25365,25366,25566,25565,-1,25366,25367,25567,25566,-1,25367,25368,25568,25567,-1,25368,25369,25569,25568,-1,25369,25370,25570,25569,-1,25370,25371,25571,25570,-1,25371,25372,25572,25571,-1,25372,25373,25573,25572,-1,25373,25374,25574,25573,-1,25374,25375,25575,25574,-1,25375,25376,25576,25575,-1,25376,25377,25577,25576,-1,25377,25378,25578,25577,-1,25378,25379,25579,25578,-1,25379,25380,25580,25579,-1,25380,25381,25581,25580,-1,25381,25382,25582,25581,-1,25382,25383,25583,25582,-1,25383,25384,25584,25583,-1,25384,25385,25585,25584,-1,25385,25386,25586,25585,-1,25386,25387,25587,25586,-1,25387,25388,25588,25587,-1,25388,25389,25589,25588,-1,25389,25390,25590,25589,-1,25390,25391,25591,25590,-1,25391,25392,25592,25591,-1,25392,25393,25593,25592,-1,25393,25394,25594,25593,-1,25394,25395,25595,25594,-1,25395,25396,25596,25595,-1,25396,25397,25597,25596,-1,25397,25398,25598,25597,-1,25398,25399,25599,25598,-1,25400,25401,25601,25600,-1,25401,25402,25602,25601,-1,25402,25403,25603,25602,-1,25403,25404,25604,25603,-1,25404,25405,25605,25604,-1,25405,25406,25606,25605,-1,25406,25407,25607,25606,-1,25407,25408,25608,25607,-1,25408,25409,25609,25608,-1,25409,25410,25610,25609,-1,25410,25411,25611,25610,-1,25411,25412,25612,25611,-1,25412,25413,25613,25612,-1,25413,25414,25614,25613,-1,25414,25415,25615,25614,-1,25415,25416,25616,25615,-1,25416,25417,25617,25616,-1,25417,25418,25618,25617,-1,25418,25419,25619,25618,-1,25419,25420,25620,25619,-1,25420,25421,25621,25620,-1,25421,25422,25622,25621,-1,25422,25423,25623,25622,-1,25423,25424,25624,25623,-1,25424,25425,25625,25624,-1,25425,25426,25626,25625,-1,25426,25427,25627,25626,-1,25427,25428,25628,25627,-1,25428,25429,25629,25628,-1,25429,25430,25630,25629,-1,25430,25431,25631,25630,-1,25431,25432,25632,25631,-1,25432,25433,25633,25632,-1,25433,25434,25634,25633,-1,25434,25435,25635,25634,-1,25435,25436,25636,25635,-1,25436,25437,25637,25636,-1,25437,25438,25638,25637,-1,25438,25439,25639,25638,-1,25439,25440,25640,25639,-1,25440,25441,25641,25640,-1,25441,25442,25642,25641,-1,25442,25443,25643,25642,-1,25443,25444,25644,25643,-1,25444,25445,25645,25644,-1,25445,25446,25646,25645,-1,25446,25447,25647,25646,-1,25447,25448,25648,25647,-1,25448,25449,25649,25648,-1,25449,25450,25650,25649,-1,25450,25451,25651,25650,-1,25451,25452,25652,25651,-1,25452,25453,25653,25652,-1,25453,25454,25654,25653,-1,25454,25455,25655,25654,-1,25455,25456,25656,25655,-1,25456,25457,25657,25656,-1,25457,25458,25658,25657,-1,25458,25459,25659,25658,-1,25459,25460,25660,25659,-1,25460,25461,25661,25660,-1,25461,25462,25662,25661,-1,25462,25463,25663,25662,-1,25463,25464,25664,25663,-1,25464,25465,25665,25664,-1,25465,25466,25666,25665,-1,25466,25467,25667,25666,-1,25467,25468,25668,25667,-1,25468,25469,25669,25668,-1,25469,25470,25670,25669,-1,25470,25471,25671,25670,-1,25471,25472,25672,25671,-1,25472,25473,25673,25672,-1,25473,25474,25674,25673,-1,25474,25475,25675,25674,-1,25475,25476,25676,25675,-1,25476,25477,25677,25676,-1,25477,25478,25678,25677,-1,25478,25479,25679,25678,-1,25479,25480,25680,25679,-1,25480,25481,25681,25680,-1,25481,25482,25682,25681,-1,25482,25483,25683,25682,-1,25483,25484,25684,25683,-1,25484,25485,25685,25684,-1,25485,25486,25686,25685,-1,25486,25487,25687,25686,-1,25487,25488,25688,25687,-1,25488,25489,25689,25688,-1,25489,25490,25690,25689,-1,25490,25491,25691,25690,-1,25491,25492,25692,25691,-1,25492,25493,25693,25692,-1,25493,25494,25694,25693,-1,25494,25495,25695,25694,-1,25495,25496,25696,25695,-1,25496,25497,25697,25696,-1,25497,25498,25698,25697,-1,25498,25499,25699,25698,-1,25499,25500,25700,25699,-1,25500,25501,25701,25700,-1,25501,25502,25702,25701,-1,25502,25503,25703,25702,-1,25503,25504,25704,25703,-1,25504,25505,25705,25704,-1,25505,25506,25706,25705,-1,25506,25507,25707,25706,-1,25507,25508,25708,25707,-1,25508,25509,25709,25708,-1,25509,25510,25710,25709,-1,25510,25511,25711,25710,-1,25511,25512,25712,25711,-1,25512,25513,25713,25712,-1,25513,25514,25714,25713,-1,25514,25515,25715,25714,-1,25515,25516,25716,25715,-1,25516,25517,25717,25716,-1,25517,25518,25718,25717,-1,25518,25519,25719,25718,-1,25519,25520,25720,25719,-1,25520,25521,25721,25720,-1,25521,25522,25722,25721,-1,25522,25523,25723,25722,-1,25523,25524,25724,25723,-1,25524,25525,25725,25724,-1,25525,25526,25726,25725,-1,25526,25527,25727,25726,-1,25527,25528,25728,25727,-1,25528,25529,25729,25728,-1,25529,25530,25730,25729,-1,25530,25531,25731,25730,-1,25531,25532,25732,25731,-1,25532,25533,25733,25732,-1,25533,25534,25734,25733,-1,25534,25535,25735,25734,-1,25535,25536,25736,25735,-1,25536,25537,25737,25736,-1,25537,25538,25738,25737,-1,25538,25539,25739,25738,-1,25539,25540,25740,25739,-1,25540,25541,25741,25740,-1,25541,25542,25742,25741,-1,25542,25543,25743,25742,-1,25543,25544,25744,25743,-1,25544,25545,25745,25744,-1,25545,25546,25746,25745,-1,25546,25547,25747,25746,-1,25547,25548,25748,25747,-1,25548,25549,25749,25748,-1,25549,25550,25750,25749,-1,25550,25551,25751,25750,-1,25551,25552,25752,25751,-1,25552,25553,25753,25752,-1,25553,25554,25754,25753,-1,25554,25555,25755,25754,-1,25555,25556,25756,25755,-1,25556,25557,25757,25756,-1,25557,25558,25758,25757,-1,25558,25559,25759,25758,-1,25559,25560,25760,25759,-1,25560,25561,25761,25760,-1,25561,25562,25762,25761,-1,25562,25563,25763,25762,-1,25563,25564,25764,25763,-1,25564,25565,25765,25764,-1,25565,25566,25766,25765,-1,25566,25567,25767,25766,-1,25567,25568,25768,25767,-1,25568,25569,25769,25768,-1,25569,25570,25770,25769,-1,25570,25571,25771,25770,-1,25571,25572,25772,25771,-1,25572,25573,25773,25772,-1,25573,25574,25774,25773,-1,25574,25575,25775,25774,-1,25575,25576,25776,25775,-1,25576,25577,25777,25776,-1,25577,25578,25778,25777,-1,25578,25579,25779,25778,-1,25579,25580,25780,25779,-1,25580,25581,25781,25780,-1,25581,25582,25782,25781,-1,25582,25583,25783,25782,-1,25583,25584,25784,25783,-1,25584,25585,25785,25784,-1,25585,25586,25786,25785,-1,25586,25587,25787,25786,-1,25587,25588,25788,25787,-1,25588,25589,25789,25788,-1,25589,25590,25790,25789,-1,25590,25591,25791,25790,-1,25591,25592,25792,25791,-1,25592,25593,25793,25792,-1,25593,25594,25794,25793,-1,25594,25595,25795,25794,-1,25595,25596,25796,25795,-1,25596,25597,25797,25796,-1,25597,25598,25798,25797,-1,25598,25599,25799,25798,-1,25600,25601,25801,25800,-1,25601,25602,25802,25801,-1,25602,25603,25803,25802,-1,25603,25604,25804,25803,-1,25604,25605,25805,25804,-1,25605,25606,25806,25805,-1,25606,25607,25807,25806,-1,25607,25608,25808,25807,-1,25608,25609,25809,25808,-1,25609,25610,25810,25809,-1,25610,25611,25811,25810,-1,25611,25612,25812,25811,-1,25612,25613,25813,25812,-1,25613,25614,25814,25813,-1,25614,25615,25815,25814,-1,25615,25616,25816,25815,-1,25616,25617,25817,25816,-1,25617,25618,25818,25817,-1,25618,25619,25819,25818,-1,25619,25620,25820,25819,-1,25620,25621,25821,25820,-1,25621,25622,25822,25821,-1,25622,25623,25823,25822,-1,25623,25624,25824,25823,-1,25624,25625,25825,25824,-1,25625,25626,25826,25825,-1,25626,25627,25827,25826,-1,25627,25628,25828,25827,-1,25628,25629,25829,25828,-1,25629,25630,25830,25829,-1,25630,25631,25831,25830,-1,25631,25632,25832,25831,-1,25632,25633,25833,25832,-1,25633,25634,25834,25833,-1,25634,25635,25835,25834,-1,25635,25636,25836,25835,-1,25636,25637,25837,25836,-1,25637,25638,25838,25837,-1,25638,25639,25839,25838,-1,25639,25640,25840,25839,-1,25640,25641,25841,25840,-1,25641,25642,25842,25841,-1,25642,25643,25843,25842,-1,25643,25644,25844,25843,-1,25644,25645,25845,25844,-1,25645,25646,25846,25845,-1,25646,25647,25847,25846,-1,25647,25648,25848,25847,-1,25648,25649,25849,25848,-1,25649,25650,25850,25849,-1,25650,25651,25851,25850,-1,25651,25652,25852,25851,-1,25652,25653,25853,25852,-1,25653,25654,25854,25853,-1,25654,25655,25855,25854,-1,25655,25656,25856,25855,-1,25656,25657,25857,25856,-1,25657,25658,25858,25857,-1,25658,25659,25859,25858,-1,25659,25660,25860,25859,-1,25660,25661,25861,25860,-1,25661,25662,25862,25861,-1,25662,25663,25863,25862,-1,25663,25664,25864,25863,-1,25664,25665,25865,25864,-1,25665,25666,25866,25865,-1,25666,25667,25867,25866,-1,25667,25668,25868,25867,-1,25668,25669,25869,25868,-1,25669,25670,25870,25869,-1,25670,25671,25871,25870,-1,25671,25672,25872,25871,-1,25672,25673,25873,25872,-1,25673,25674,25874,25873,-1,25674,25675,25875,25874,-1,25675,25676,25876,25875,-1,25676,25677,25877,25876,-1,25677,25678,25878,25877,-1,25678,25679,25879,25878,-1,25679,25680,25880,25879,-1,25680,25681,25881,25880,-1,25681,25682,25882,25881,-1,25682,25683,25883,25882,-1,25683,25684,25884,25883,-1,25684,25685,25885,25884,-1,25685,25686,25886,25885,-1,25686,25687,25887,25886,-1,25687,25688,25888,25887,-1,25688,25689,25889,25888,-1,25689,25690,25890,25889,-1,25690,25691,25891,25890,-1,25691,25692,25892,25891,-1,25692,25693,25893,25892,-1,25693,25694,25894,25893,-1,25694,25695,25895,25894,-1,25695,25696,25896,25895,-1,25696,25697,25897,25896,-1,25697,25698,25898,25897,-1,25698,25699,25899,25898,-1,25699,25700,25900,25899,-1,25700,25701,25901,25900,-1,25701,25702,25902,25901,-1,25702,25703,25903,25902,-1,25703,25704,25904,25903,-1,25704,25705,25905,25904,-1,25705,25706,25906,25905,-1,25706,25707,25907,25906,-1,25707,25708,25908,25907,-1,25708,25709,25909,25908,-1,25709,25710,25910,25909,-1,25710,25711,25911,25910,-1,25711,25712,25912,25911,-1,25712,25713,25913,25912,-1,25713,25714,25914,25913,-1,25714,25715,25915,25914,-1,25715,25716,25916,25915,-1,25716,25717,25917,25916,-1,25717,25718,25918,25917,-1,25718,25719,25919,25918,-1,25719,25720,25920,25919,-1,25720,25721,25921,25920,-1,25721,25722,25922,25921,-1,25722,25723,25923,25922,-1,25723,25724,25924,25923,-1,25724,25725,25925,25924,-1,25725,25726,25926,25925,-1,25726,25727,25927,25926,-1,25727,25728,25928,25927,-1,25728,25729,25929,25928,-1,25729,25730,25930,25929,-1,25730,25731,25931,25930,-1,25731,25732,25932,25931,-1,25732,25733,25933,25932,-1,25733,25734,25934,25933,-1,25734,25735,25935,25934,-1,25735,25736,25936,25935,-1,25736,25737,25937,25936,-1,25737,25738,25938,25937,-1,25738,25739,25939,25938,-1,25739,25740,25940,25939,-1,25740,25741,25941,25940,-1,25741,25742,25942,25941,-1,25742,25743,25943,25942,-1,25743,25744,25944,25943,-1,25744,25745,25945,25944,-1,25745,25746,25946,25945,-1,25746,25747,25947,25946,-1,25747,25748,25948,25947,-1,25748,25749,25949,25948,-1,25749,25750,25950,25949,-1,25750,25751,25951,25950,-1,25751,25752,25952,25951,-1,25752,25753,25953,25952,-1,25753,25754,25954,25953,-1,25754,25755,25955,25954,-1,25755,25756,25956,25955,-1,25756,25757,25957,25956,-1,25757,25758,25958,25957,-1,25758,25759,25959,25958,-1,25759,25760,25960,25959,-1,25760,25761,25961,25960,-1,25761,25762,25962,25961,-1,25762,25763,25963,25962,-1,25763,25764,25964,25963,-1,25764,25765,25965,25964,-1,25765,25766,25966,25965,-1,25766,25767,25967,25966,-1,25767,25768,25968,25967,-1,25768,25769,25969,25968,-1,25769,25770,25970,25969,-1,25770,25771,25971,25970,-1,25771,25772,25972,25971,-1,25772,25773,25973,25972,-1,25773,25774,25974,25973,-1,25774,25775,25975,25974,-1,25775,25776,25976,25975,-1,25776,25777,25977,25976,-1,25777,25778,25978,25977,-1,25778,25779,25979,25978,-1,25779,25780,25980,25979,-1,25780,25781,25981,25980,-1,25781,25782,25982,25981,-1,25782,25783,25983,25982,-1,25783,25784,25984,25983,-1,25784,25785,25985,25984,-1,25785,25786,25986,25985,-1,25786,25787,25987,25986,-1,25787,25788,25988,25987,-1,25788,25789,25989,25988,-1,25789,25790,25990,25989,-1,25790,25791,25991,25990,-1,25791,25792,25992,25991,-1,25792,25793,25993,25992,-1,25793,25794,25994,25993,-1,25794,25795,25995,25994,-1,25795,25796,25996,25995,-1,25796,25797,25997,25996,-1,25797,25798,25998,25997,-1,25798,25799,25999,25998,-1,25800,25801,26001,26,-1,25801,25802,26002,26001,-1,25802,25803,26003,26002,-1,25803,25804,26004,26003,-1,25804,25805,26005,26004,-1,25805,25806,26006,26005,-1,25806,25807,26007,26006,-1,25807,25808,26008,26007,-1,25808,25809,26009,26008,-1,25809,25810,26010,26009,-1,25810,25811,26011,26010,-1,25811,25812,26012,26011,-1,25812,25813,26013,26012,-1,25813,25814,26014,26013,-1,25814,25815,26015,26014,-1,25815,25816,26016,26015,-1,25816,25817,26017,26016,-1,25817,25818,26018,26017,-1,25818,25819,26019,26018,-1,25819,25820,26020,26019,-1,25820,25821,26021,26020,-1,25821,25822,26022,26021,-1,25822,25823,26023,26022,-1,25823,25824,26024,26023,-1,25824,25825,26025,26024,-1,25825,25826,26026,26025,-1,25826,25827,26027,26026,-1,25827,25828,26028,26027,-1,25828,25829,26029,26028,-1,25829,25830,26030,26029,-1,25830,25831,26031,26030,-1,25831,25832,26032,26031,-1,25832,25833,26033,26032,-1,25833,25834,26034,26033,-1,25834,25835,26035,26034,-1,25835,25836,26036,26035,-1,25836,25837,26037,26036,-1,25837,25838,26038,26037,-1,25838,25839,26039,26038,-1,25839,25840,26040,26039,-1,25840,25841,26041,26040,-1,25841,25842,26042,26041,-1,25842,25843,26043,26042,-1,25843,25844,26044,26043,-1,25844,25845,26045,26044,-1,25845,25846,26046,26045,-1,25846,25847,26047,26046,-1,25847,25848,26048,26047,-1,25848,25849,26049,26048,-1,25849,25850,26050,26049,-1,25850,25851,26051,26050,-1,25851,25852,26052,26051,-1,25852,25853,26053,26052,-1,25853,25854,26054,26053,-1,25854,25855,26055,26054,-1,25855,25856,26056,26055,-1,25856,25857,26057,26056,-1,25857,25858,26058,26057,-1,25858,25859,26059,26058,-1,25859,25860,26060,26059,-1,25860,25861,26061,26060,-1,25861,25862,26062,26061,-1,25862,25863,26063,26062,-1,25863,25864,26064,26063,-1,25864,25865,26065,26064,-1,25865,25866,26066,26065,-1,25866,25867,26067,26066,-1,25867,25868,26068,26067,-1,25868,25869,26069,26068,-1,25869,25870,26070,26069,-1,25870,25871,26071,26070,-1,25871,25872,26072,26071,-1,25872,25873,26073,26072,-1,25873,25874,26074,26073,-1,25874,25875,26075,26074,-1,25875,25876,26076,26075,-1,25876,25877,26077,26076,-1,25877,25878,26078,26077,-1,25878,25879,26079,26078,-1,25879,25880,26080,26079,-1,25880,25881,26081,26080,-1,25881,25882,26082,26081,-1,25882,25883,26083,26082,-1,25883,25884,26084,26083,-1,25884,25885,26085,26084,-1,25885,25886,26086,26085,-1,25886,25887,26087,26086,-1,25887,25888,26088,26087,-1,25888,25889,26089,26088,-1,25889,25890,26090,26089,-1,25890,25891,26091,26090,-1,25891,25892,26092,26091,-1,25892,25893,26093,26092,-1,25893,25894,26094,26093,-1,25894,25895,26095,26094,-1,25895,25896,26096,26095,-1,25896,25897,26097,26096,-1,25897,25898,26098,26097,-1,25898,25899,26099,26098,-1,25899,25900,26100,26099,-1,25900,25901,26101,26100,-1,25901,25902,26102,26101,-1,25902,25903,26103,26102,-1,25903,25904,26104,26103,-1,25904,25905,26105,26104,-1,25905,25906,26106,26105,-1,25906,25907,26107,26106,-1,25907,25908,26108,26107,-1,25908,25909,26109,26108,-1,25909,25910,26110,26109,-1,25910,25911,26111,26110,-1,25911,25912,26112,26111,-1,25912,25913,26113,26112,-1,25913,25914,26114,26113,-1,25914,25915,26115,26114,-1,25915,25916,26116,26115,-1,25916,25917,26117,26116,-1,25917,25918,26118,26117,-1,25918,25919,26119,26118,-1,25919,25920,26120,26119,-1,25920,25921,26121,26120,-1,25921,25922,26122,26121,-1,25922,25923,26123,26122,-1,25923,25924,26124,26123,-1,25924,25925,26125,26124,-1,25925,25926,26126,26125,-1,25926,25927,26127,26126,-1,25927,25928,26128,26127,-1,25928,25929,26129,26128,-1,25929,25930,26130,26129,-1,25930,25931,26131,26130,-1,25931,25932,26132,26131,-1,25932,25933,26133,26132,-1,25933,25934,26134,26133,-1,25934,25935,26135,26134,-1,25935,25936,26136,26135,-1,25936,25937,26137,26136,-1,25937,25938,26138,26137,-1,25938,25939,26139,26138,-1,25939,25940,26140,26139,-1,25940,25941,26141,26140,-1,25941,25942,26142,26141,-1,25942,25943,26143,26142,-1,25943,25944,26144,26143,-1,25944,25945,26145,26144,-1,25945,25946,26146,26145,-1,25946,25947,26147,26146,-1,25947,25948,26148,26147,-1,25948,25949,26149,26148,-1,25949,25950,26150,26149,-1,25950,25951,26151,26150,-1,25951,25952,26152,26151,-1,25952,25953,26153,26152,-1,25953,25954,26154,26153,-1,25954,25955,26155,26154,-1,25955,25956,26156,26155,-1,25956,25957,26157,26156,-1,25957,25958,26158,26157,-1,25958,25959,26159,26158,-1,25959,25960,26160,26159,-1,25960,25961,26161,26160,-1,25961,25962,26162,26161,-1,25962,25963,26163,26162,-1,25963,25964,26164,26163,-1,25964,25965,26165,26164,-1,25965,25966,26166,26165,-1,25966,25967,26167,26166,-1,25967,25968,26168,26167,-1,25968,25969,26169,26168,-1,25969,25970,26170,26169,-1,25970,25971,26171,26170,-1,25971,25972,26172,26171,-1,25972,25973,26173,26172,-1,25973,25974,26174,26173,-1,25974,25975,26175,26174,-1,25975,25976,26176,26175,-1,25976,25977,26177,26176,-1,25977,25978,26178,26177,-1,25978,25979,26179,26178,-1,25979,25980,26180,26179,-1,25980,25981,26181,26180,-1,25981,25982,26182,26181,-1,25982,25983,26183,26182,-1,25983,25984,26184,26183,-1,25984,25985,26185,26184,-1,25985,25986,26186,26185,-1,25986,25987,26187,26186,-1,25987,25988,26188,26187,-1,25988,25989,26189,26188,-1,25989,25990,26190,26189,-1,25990,25991,26191,26190,-1,25991,25992,26192,26191,-1,25992,25993,26193,26192,-1,25993,25994,26194,26193,-1,25994,25995,26195,26194,-1,25995,25996,26196,26195,-1,25996,25997,26197,26196,-1,25997,25998,26198,26197,-1,25998,25999,26199,26198,-1,26,26001,26201,26200,-1,26001,26002,26202,26201,-1,26002,26003,26203,26202,-1,26003,26004,26204,26203,-1,26004,26005,26205,26204,-1,26005,26006,26206,26205,-1,26006,26007,26207,26206,-1,26007,26008,26208,26207,-1,26008,26009,26209,26208,-1,26009,26010,26210,26209,-1,26010,26011,26211,26210,-1,26011,26012,26212,26211,-1,26012,26013,26213,26212,-1,26013,26014,26214,26213,-1,26014,26015,26215,26214,-1,26015,26016,26216,26215,-1,26016,26017,26217,26216,-1,26017,26018,26218,26217,-1,26018,26019,26219,26218,-1,26019,26020,26220,26219,-1,26020,26021,26221,26220,-1,26021,26022,26222,26221,-1,26022,26023,26223,26222,-1,26023,26024,26224,26223,-1,26024,26025,26225,26224,-1,26025,26026,26226,26225,-1,26026,26027,26227,26226,-1,26027,26028,26228,26227,-1,26028,26029,26229,26228,-1,26029,26030,26230,26229,-1,26030,26031,26231,26230,-1,26031,26032,26232,26231,-1,26032,26033,26233,26232,-1,26033,26034,26234,26233,-1,26034,26035,26235,26234,-1,26035,26036,26236,26235,-1,26036,26037,26237,26236,-1,26037,26038,26238,26237,-1,26038,26039,26239,26238,-1,26039,26040,26240,26239,-1,26040,26041,26241,26240,-1,26041,26042,26242,26241,-1,26042,26043,26243,26242,-1,26043,26044,26244,26243,-1,26044,26045,26245,26244,-1,26045,26046,26246,26245,-1,26046,26047,26247,26246,-1,26047,26048,26248,26247,-1,26048,26049,26249,26248,-1,26049,26050,26250,26249,-1,26050,26051,26251,26250,-1,26051,26052,26252,26251,-1,26052,26053,26253,26252,-1,26053,26054,26254,26253,-1,26054,26055,26255,26254,-1,26055,26056,26256,26255,-1,26056,26057,26257,26256,-1,26057,26058,26258,26257,-1,26058,26059,26259,26258,-1,26059,26060,26260,26259,-1,26060,26061,26261,26260,-1,26061,26062,26262,26261,-1,26062,26063,26263,26262,-1,26063,26064,26264,26263,-1,26064,26065,26265,26264,-1,26065,26066,26266,26265,-1,26066,26067,26267,26266,-1,26067,26068,26268,26267,-1,26068,26069,26269,26268,-1,26069,26070,26270,26269,-1,26070,26071,26271,26270,-1,26071,26072,26272,26271,-1,26072,26073,26273,26272,-1,26073,26074,26274,26273,-1,26074,26075,26275,26274,-1,26075,26076,26276,26275,-1,26076,26077,26277,26276,-1,26077,26078,26278,26277,-1,26078,26079,26279,26278,-1,26079,26080,26280,26279,-1,26080,26081,26281,26280,-1,26081,26082,26282,26281,-1,26082,26083,26283,26282,-1,26083,26084,26284,26283,-1,26084,26085,26285,26284,-1,26085,26086,26286,26285,-1,26086,26087,26287,26286,-1,26087,26088,26288,26287,-1,26088,26089,26289,26288,-1,26089,26090,26290,26289,-1,26090,26091,26291,26290,-1,26091,26092,26292,26291,-1,26092,26093,26293,26292,-1,26093,26094,26294,26293,-1,26094,26095,26295,26294,-1,26095,26096,26296,26295,-1,26096,26097,26297,26296,-1,26097,26098,26298,26297,-1,26098,26099,26299,26298,-1,26099,26100,26300,26299,-1,26100,26101,26301,26300,-1,26101,26102,26302,26301,-1,26102,26103,26303,26302,-1,26103,26104,26304,26303,-1,26104,26105,26305,26304,-1,26105,26106,26306,26305,-1,26106,26107,26307,26306,-1,26107,26108,26308,26307,-1,26108,26109,26309,26308,-1,26109,26110,26310,26309,-1,26110,26111,26311,26310,-1,26111,26112,26312,26311,-1,26112,26113,26313,26312,-1,26113,26114,26314,26313,-1,26114,26115,26315,26314,-1,26115,26116,26316,26315,-1,26116,26117,26317,26316,-1,26117,26118,26318,26317,-1,26118,26119,26319,26318,-1,26119,26120,26320,26319,-1,26120,26121,26321,26320,-1,26121,26122,26322,26321,-1,26122,26123,26323,26322,-1,26123,26124,26324,26323,-1,26124,26125,26325,26324,-1,26125,26126,26326,26325,-1,26126,26127,26327,26326,-1,26127,26128,26328,26327,-1,26128,26129,26329,26328,-1,26129,26130,26330,26329,-1,26130,26131,26331,26330,-1,26131,26132,26332,26331,-1,26132,26133,26333,26332,-1,26133,26134,26334,26333,-1,26134,26135,26335,26334,-1,26135,26136,26336,26335,-1,26136,26137,26337,26336,-1,26137,26138,26338,26337,-1,26138,26139,26339,26338,-1,26139,26140,26340,26339,-1,26140,26141,26341,26340,-1,26141,26142,26342,26341,-1,26142,26143,26343,26342,-1,26143,26144,26344,26343,-1,26144,26145,26345,26344,-1,26145,26146,26346,26345,-1,26146,26147,26347,26346,-1,26147,26148,26348,26347,-1,26148,26149,26349,26348,-1,26149,26150,26350,26349,-1,26150,26151,26351,26350,-1,26151,26152,26352,26351,-1,26152,26153,26353,26352,-1,26153,26154,26354,26353,-1,26154,26155,26355,26354,-1,26155,26156,26356,26355,-1,26156,26157,26357,26356,-1,26157,26158,26358,26357,-1,26158,26159,26359,26358,-1,26159,26160,26360,26359,-1,26160,26161,26361,26360,-1,26161,26162,26362,26361,-1,26162,26163,26363,26362,-1,26163,26164,26364,26363,-1,26164,26165,26365,26364,-1,26165,26166,26366,26365,-1,26166,26167,26367,26366,-1,26167,26168,26368,26367,-1,26168,26169,26369,26368,-1,26169,26170,26370,26369,-1,26170,26171,26371,26370,-1,26171,26172,26372,26371,-1,26172,26173,26373,26372,-1,26173,26174,26374,26373,-1,26174,26175,26375,26374,-1,26175,26176,26376,26375,-1,26176,26177,26377,26376,-1,26177,26178,26378,26377,-1,26178,26179,26379,26378,-1,26179,26180,26380,26379,-1,26180,26181,26381,26380,-1,26181,26182,26382,26381,-1,26182,26183,26383,26382,-1,26183,26184,26384,26383,-1,26184,26185,26385,26384,-1,26185,26186,26386,26385,-1,26186,26187,26387,26386,-1,26187,26188,26388,26387,-1,26188,26189,26389,26388,-1,26189,26190,26390,26389,-1,26190,26191,26391,26390,-1,26191,26192,26392,26391,-1,26192,26193,26393,26392,-1,26193,26194,26394,26393,-1,26194,26195,26395,26394,-1,26195,26196,26396,26395,-1,26196,26197,26397,26396,-1,26197,26198,26398,26397,-1,26198,26199,26399,26398,-1,26200,26201,26401,26400,-1,26201,26202,26402,26401,-1,26202,26203,26403,26402,-1,26203,26204,26404,26403,-1,26204,26205,26405,26404,-1,26205,26206,26406,26405,-1,26206,26207,26407,26406,-1,26207,26208,26408,26407,-1,26208,26209,26409,26408,-1,26209,26210,26410,26409,-1,26210,26211,26411,26410,-1,26211,26212,26412,26411,-1,26212,26213,26413,26412,-1,26213,26214,26414,26413,-1,26214,26215,26415,26414,-1,26215,26216,26416,26415,-1,26216,26217,26417,26416,-1,26217,26218,26418,26417,-1,26218,26219,26419,26418,-1,26219,26220,26420,26419,-1,26220,26221,26421,26420,-1,26221,26222,26422,26421,-1,26222,26223,26423,26422,-1,26223,26224,26424,26423,-1,26224,26225,26425,26424,-1,26225,26226,26426,26425,-1,26226,26227,26427,26426,-1,26227,26228,26428,26427,-1,26228,26229,26429,26428,-1,26229,26230,26430,26429,-1,26230,26231,26431,26430,-1,26231,26232,26432,26431,-1,26232,26233,26433,26432,-1,26233,26234,26434,26433,-1,26234,26235,26435,26434,-1,26235,26236,26436,26435,-1,26236,26237,26437,26436,-1,26237,26238,26438,26437,-1,26238,26239,26439,26438,-1,26239,26240,26440,26439,-1,26240,26241,26441,26440,-1,26241,26242,26442,26441,-1,26242,26243,26443,26442,-1,26243,26244,26444,26443,-1,26244,26245,26445,26444,-1,26245,26246,26446,26445,-1,26246,26247,26447,26446,-1,26247,26248,26448,26447,-1,26248,26249,26449,26448,-1,26249,26250,26450,26449,-1,26250,26251,26451,26450,-1,26251,26252,26452,26451,-1,26252,26253,26453,26452,-1,26253,26254,26454,26453,-1,26254,26255,26455,26454,-1,26255,26256,26456,26455,-1,26256,26257,26457,26456,-1,26257,26258,26458,26457,-1,26258,26259,26459,26458,-1,26259,26260,26460,26459,-1,26260,26261,26461,26460,-1,26261,26262,26462,26461,-1,26262,26263,26463,26462,-1,26263,26264,26464,26463,-1,26264,26265,26465,26464,-1,26265,26266,26466,26465,-1,26266,26267,26467,26466,-1,26267,26268,26468,26467,-1,26268,26269,26469,26468,-1,26269,26270,26470,26469,-1,26270,26271,26471,26470,-1,26271,26272,26472,26471,-1,26272,26273,26473,26472,-1,26273,26274,26474,26473,-1,26274,26275,26475,26474,-1,26275,26276,26476,26475,-1,26276,26277,26477,26476,-1,26277,26278,26478,26477,-1,26278,26279,26479,26478,-1,26279,26280,26480,26479,-1,26280,26281,26481,26480,-1,26281,26282,26482,26481,-1,26282,26283,26483,26482,-1,26283,26284,26484,26483,-1,26284,26285,26485,26484,-1,26285,26286,26486,26485,-1,26286,26287,26487,26486,-1,26287,26288,26488,26487,-1,26288,26289,26489,26488,-1,26289,26290,26490,26489,-1,26290,26291,26491,26490,-1,26291,26292,26492,26491,-1,26292,26293,26493,26492,-1,26293,26294,26494,26493,-1,26294,26295,26495,26494,-1,26295,26296,26496,26495,-1,26296,26297,26497,26496,-1,26297,26298,26498,26497,-1,26298,26299,26499,26498,-1,26299,26300,26500,26499,-1,26300,26301,26501,26500,-1,26301,26302,26502,26501,-1,26302,26303,26503,26502,-1,26303,26304,26504,26503,-1,26304,26305,26505,26504,-1,26305,26306,26506,26505,-1,26306,26307,26507,26506,-1,26307,26308,26508,26507,-1,26308,26309,26509,26508,-1,26309,26310,26510,26509,-1,26310,26311,26511,26510,-1,26311,26312,26512,26511,-1,26312,26313,26513,26512,-1,26313,26314,26514,26513,-1,26314,26315,26515,26514,-1,26315,26316,26516,26515,-1,26316,26317,26517,26516,-1,26317,26318,26518,26517,-1,26318,26319,26519,26518,-1,26319,26320,26520,26519,-1,26320,26321,26521,26520,-1,26321,26322,26522,26521,-1,26322,26323,26523,26522,-1,26323,26324,26524,26523,-1,26324,26325,26525,26524,-1,26325,26326,26526,26525,-1,26326,26327,26527,26526,-1,26327,26328,26528,26527,-1,26328,26329,26529,26528,-1,26329,26330,26530,26529,-1,26330,26331,26531,26530,-1,26331,26332,26532,26531,-1,26332,26333,26533,26532,-1,26333,26334,26534,26533,-1,26334,26335,26535,26534,-1,26335,26336,26536,26535,-1,26336,26337,26537,26536,-1,26337,26338,26538,26537,-1,26338,26339,26539,26538,-1,26339,26340,26540,26539,-1,26340,26341,26541,26540,-1,26341,26342,26542,26541,-1,26342,26343,26543,26542,-1,26343,26344,26544,26543,-1,26344,26345,26545,26544,-1,26345,26346,26546,26545,-1,26346,26347,26547,26546,-1,26347,26348,26548,26547,-1,26348,26349,26549,26548,-1,26349,26350,26550,26549,-1,26350,26351,26551,26550,-1,26351,26352,26552,26551,-1,26352,26353,26553,26552,-1,26353,26354,26554,26553,-1,26354,26355,26555,26554,-1,26355,26356,26556,26555,-1,26356,26357,26557,26556,-1,26357,26358,26558,26557,-1,26358,26359,26559,26558,-1,26359,26360,26560,26559,-1,26360,26361,26561,26560,-1,26361,26362,26562,26561,-1,26362,26363,26563,26562,-1,26363,26364,26564,26563,-1,26364,26365,26565,26564,-1,26365,26366,26566,26565,-1,26366,26367,26567,26566,-1,26367,26368,26568,26567,-1,26368,26369,26569,26568,-1,26369,26370,26570,26569,-1,26370,26371,26571,26570,-1,26371,26372,26572,26571,-1,26372,26373,26573,26572,-1,26373,26374,26574,26573,-1,26374,26375,26575,26574,-1,26375,26376,26576,26575,-1,26376,26377,26577,26576,-1,26377,26378,26578,26577,-1,26378,26379,26579,26578,-1,26379,26380,26580,26579,-1,26380,26381,26581,26580,-1,26381,26382,26582,26581,-1,26382,26383,26583,26582,-1,26383,26384,26584,26583,-1,26384,26385,26585,26584,-1,26385,26386,26586,26585,-1,26386,26387,26587,26586,-1,26387,26388,26588,26587,-1,26388,26389,26589,26588,-1,26389,26390,26590,26589,-1,26390,26391,26591,26590,-1,26391,26392,26592,26591,-1,26392,26393,26593,26592,-1,26393,26394,26594,26593,-1,26394,26395,26595,26594,-1,26395,26396,26596,26595,-1,26396,26397,26597,26596,-1,26397,26398,26598,26597,-1,26398,26399,26599,26598,-1,26400,26401,26601,26600,-1,26401,26402,26602,26601,-1,26402,26403,26603,26602,-1,26403,26404,26604,26603,-1,26404,26405,26605,26604,-1,26405,26406,26606,26605,-1,26406,26407,26607,26606,-1,26407,26408,26608,26607,-1,26408,26409,26609,26608,-1,26409,26410,26610,26609,-1,26410,26411,26611,26610,-1,26411,26412,26612,26611,-1,26412,26413,26613,26612,-1,26413,26414,26614,26613,-1,26414,26415,26615,26614,-1,26415,26416,26616,26615,-1,26416,26417,26617,26616,-1,26417,26418,26618,26617,-1,26418,26419,26619,26618,-1,26419,26420,26620,26619,-1,26420,26421,26621,26620,-1,26421,26422,26622,26621,-1,26422,26423,26623,26622,-1,26423,26424,26624,26623,-1,26424,26425,26625,26624,-1,26425,26426,26626,26625,-1,26426,26427,26627,26626,-1,26427,26428,26628,26627,-1,26428,26429,26629,26628,-1,26429,26430,26630,26629,-1,26430,26431,26631,26630,-1,26431,26432,26632,26631,-1,26432,26433,26633,26632,-1,26433,26434,26634,26633,-1,26434,26435,26635,26634,-1,26435,26436,26636,26635,-1,26436,26437,26637,26636,-1,26437,26438,26638,26637,-1,26438,26439,26639,26638,-1,26439,26440,26640,26639,-1,26440,26441,26641,26640,-1,26441,26442,26642,26641,-1,26442,26443,26643,26642,-1,26443,26444,26644,26643,-1,26444,26445,26645,26644,-1,26445,26446,26646,26645,-1,26446,26447,26647,26646,-1,26447,26448,26648,26647,-1,26448,26449,26649,26648,-1,26449,26450,26650,26649,-1,26450,26451,26651,26650,-1,26451,26452,26652,26651,-1,26452,26453,26653,26652,-1,26453,26454,26654,26653,-1,26454,26455,26655,26654,-1,26455,26456,26656,26655,-1,26456,26457,26657,26656,-1,26457,26458,26658,26657,-1,26458,26459,26659,26658,-1,26459,26460,26660,26659,-1,26460,26461,26661,26660,-1,26461,26462,26662,26661,-1,26462,26463,26663,26662,-1,26463,26464,26664,26663,-1,26464,26465,26665,26664,-1,26465,26466,26666,26665,-1,26466,26467,26667,26666,-1,26467,26468,26668,26667,-1,26468,26469,26669,26668,-1,26469,26470,26670,26669,-1,26470,26471,26671,26670,-1,26471,26472,26672,26671,-1,26472,26473,26673,26672,-1,26473,26474,26674,26673,-1,26474,26475,26675,26674,-1,26475,26476,26676,26675,-1,26476,26477,26677,26676,-1,26477,26478,26678,26677,-1,26478,26479,26679,26678,-1,26479,26480,26680,26679,-1,26480,26481,26681,26680,-1,26481,26482,26682,26681,-1,26482,26483,26683,26682,-1,26483,26484,26684,26683,-1,26484,26485,26685,26684,-1,26485,26486,26686,26685,-1,26486,26487,26687,26686,-1,26487,26488,26688,26687,-1,26488,26489,26689,26688,-1,26489,26490,26690,26689,-1,26490,26491,26691,26690,-1,26491,26492,26692,26691,-1,26492,26493,26693,26692,-1,26493,26494,26694,26693,-1,26494,26495,26695,26694,-1,26495,26496,26696,26695,-1,26496,26497,26697,26696,-1,26497,26498,26698,26697,-1,26498,26499,26699,26698,-1,26499,26500,26700,26699,-1,26500,26501,26701,26700,-1,26501,26502,26702,26701,-1,26502,26503,26703,26702,-1,26503,26504,26704,26703,-1,26504,26505,26705,26704,-1,26505,26506,26706,26705,-1,26506,26507,26707,26706,-1,26507,26508,26708,26707,-1,26508,26509,26709,26708,-1,26509,26510,26710,26709,-1,26510,26511,26711,26710,-1,26511,26512,26712,26711,-1,26512,26513,26713,26712,-1,26513,26514,26714,26713,-1,26514,26515,26715,26714,-1,26515,26516,26716,26715,-1,26516,26517,26717,26716,-1,26517,26518,26718,26717,-1,26518,26519,26719,26718,-1,26519,26520,26720,26719,-1,26520,26521,26721,26720,-1,26521,26522,26722,26721,-1,26522,26523,26723,26722,-1,26523,26524,26724,26723,-1,26524,26525,26725,26724,-1,26525,26526,26726,26725,-1,26526,26527,26727,26726,-1,26527,26528,26728,26727,-1,26528,26529,26729,26728,-1,26529,26530,26730,26729,-1,26530,26531,26731,26730,-1,26531,26532,26732,26731,-1,26532,26533,26733,26732,-1,26533,26534,26734,26733,-1,26534,26535,26735,26734,-1,26535,26536,26736,26735,-1,26536,26537,26737,26736,-1,26537,26538,26738,26737,-1,26538,26539,26739,26738,-1,26539,26540,26740,26739,-1,26540,26541,26741,26740,-1,26541,26542,26742,26741,-1,26542,26543,26743,26742,-1,26543,26544,26744,26743,-1,26544,26545,26745,26744,-1,26545,26546,26746,26745,-1,26546,26547,26747,26746,-1,26547,26548,26748,26747,-1,26548,26549,26749,26748,-1,26549,26550,26750,26749,-1,26550,26551,26751,26750,-1,26551,26552,26752,26751,-1,26552,26553,26753,26752,-1,26553,26554,26754,26753,-1,26554,26555,26755,26754,-1,26555,26556,26756,26755,-1,26556,26557,26757,26756,-1,26557,26558,26758,26757,-1,26558,26559,26759,26758,-1,26559,26560,26760,26759,-1,26560,26561,26761,26760,-1,26561,26562,26762,26761,-1,26562,26563,26763,26762,-1,26563,26564,26764,26763,-1,26564,26565,26765,26764,-1,26565,26566,26766,26765,-1,26566,26567,26767,26766,-1,26567,26568,26768,26767,-1,26568,26569,26769,26768,-1,26569,26570,26770,26769,-1,26570,26571,26771,26770,-1,26571,26572,26772,26771,-1,26572,26573,26773,26772,-1,26573,26574,26774,26773,-1,26574,26575,26775,26774,-1,26575,26576,26776,26775,-1,26576,26577,26777,26776,-1,26577,26578,26778,26777,-1,26578,26579,26779,26778,-1,26579,26580,26780,26779,-1,26580,26581,26781,26780,-1,26581,26582,26782,26781,-1,26582,26583,26783,26782,-1,26583,26584,26784,26783,-1,26584,26585,26785,26784,-1,26585,26586,26786,26785,-1,26586,26587,26787,26786,-1,26587,26588,26788,26787,-1,26588,26589,26789,26788,-1,26589,26590,26790,26789,-1,26590,26591,26791,26790,-1,26591,26592,26792,26791,-1,26592,26593,26793,26792,-1,26593,26594,26794,26793,-1,26594,26595,26795,26794,-1,26595,26596,26796,26795,-1,26596,26597,26797,26796,-1,26597,26598,26798,26797,-1,26598,26599,26799,26798,-1,26600,26601,26801,26800,-1,26601,26602,26802,26801,-1,26602,26603,26803,26802,-1,26603,26604,26804,26803,-1,26604,26605,26805,26804,-1,26605,26606,26806,26805,-1,26606,26607,26807,26806,-1,26607,26608,26808,26807,-1,26608,26609,26809,26808,-1,26609,26610,26810,26809,-1,26610,26611,26811,26810,-1,26611,26612,26812,26811,-1,26612,26613,26813,26812,-1,26613,26614,26814,26813,-1,26614,26615,26815,26814,-1,26615,26616,26816,26815,-1,26616,26617,26817,26816,-1,26617,26618,26818,26817,-1,26618,26619,26819,26818,-1,26619,26620,26820,26819,-1,26620,26621,26821,26820,-1,26621,26622,26822,26821,-1,26622,26623,26823,26822,-1,26623,26624,26824,26823,-1,26624,26625,26825,26824,-1,26625,26626,26826,26825,-1,26626,26627,26827,26826,-1,26627,26628,26828,26827,-1,26628,26629,26829,26828,-1,26629,26630,26830,26829,-1,26630,26631,26831,26830,-1,26631,26632,26832,26831,-1,26632,26633,26833,26832,-1,26633,26634,26834,26833,-1,26634,26635,26835,26834,-1,26635,26636,26836,26835,-1,26636,26637,26837,26836,-1,26637,26638,26838,26837,-1,26638,26639,26839,26838,-1,26639,26640,26840,26839,-1,26640,26641,26841,26840,-1,26641,26642,26842,26841,-1,26642,26643,26843,26842,-1,26643,26644,26844,26843,-1,26644,26645,26845,26844,-1,26645,26646,26846,26845,-1,26646,26647,26847,26846,-1,26647,26648,26848,26847,-1,26648,26649,26849,26848,-1,26649,26650,26850,26849,-1,26650,26651,26851,26850,-1,26651,26652,26852,26851,-1,26652,26653,26853,26852,-1,26653,26654,26854,26853,-1,26654,26655,26855,26854,-1,26655,26656,26856,26855,-1,26656,26657,26857,26856,-1,26657,26658,26858,26857,-1,26658,26659,26859,26858,-1,26659,26660,26860,26859,-1,26660,26661,26861,26860,-1,26661,26662,26862,26861,-1,26662,26663,26863,26862,-1,26663,26664,26864,26863,-1,26664,26665,26865,26864,-1,26665,26666,26866,26865,-1,26666,26667,26867,26866,-1,26667,26668,26868,26867,-1,26668,26669,26869,26868,-1,26669,26670,26870,26869,-1,26670,26671,26871,26870,-1,26671,26672,26872,26871,-1,26672,26673,26873,26872,-1,26673,26674,26874,26873,-1,26674,26675,26875,26874,-1,26675,26676,26876,26875,-1,26676,26677,26877,26876,-1,26677,26678,26878,26877,-1,26678,26679,26879,26878,-1,26679,26680,26880,26879,-1,26680,26681,26881,26880,-1,26681,26682,26882,26881,-1,26682,26683,26883,26882,-1,26683,26684,26884,26883,-1,26684,26685,26885,26884,-1,26685,26686,26886,26885,-1,26686,26687,26887,26886,-1,26687,26688,26888,26887,-1,26688,26689,26889,26888,-1,26689,26690,26890,26889,-1,26690,26691,26891,26890,-1,26691,26692,26892,26891,-1,26692,26693,26893,26892,-1,26693,26694,26894,26893,-1,26694,26695,26895,26894,-1,26695,26696,26896,26895,-1,26696,26697,26897,26896,-1,26697,26698,26898,26897,-1,26698,26699,26899,26898,-1,26699,26700,26900,26899,-1,26700,26701,26901,26900,-1,26701,26702,26902,26901,-1,26702,26703,26903,26902,-1,26703,26704,26904,26903,-1,26704,26705,26905,26904,-1,26705,26706,26906,26905,-1,26706,26707,26907,26906,-1,26707,26708,26908,26907,-1,26708,26709,26909,26908,-1,26709,26710,26910,26909,-1,26710,26711,26911,26910,-1,26711,26712,26912,26911,-1,26712,26713,26913,26912,-1,26713,26714,26914,26913,-1,26714,26715,26915,26914,-1,26715,26716,26916,26915,-1,26716,26717,26917,26916,-1,26717,26718,26918,26917,-1,26718,26719,26919,26918,-1,26719,26720,26920,26919,-1,26720,26721,26921,26920,-1,26721,26722,26922,26921,-1,26722,26723,26923,26922,-1,26723,26724,26924,26923,-1,26724,26725,26925,26924,-1,26725,26726,26926,26925,-1,26726,26727,26927,26926,-1,26727,26728,26928,26927,-1,26728,26729,26929,26928,-1,26729,26730,26930,26929,-1,26730,26731,26931,26930,-1,26731,26732,26932,26931,-1,26732,26733,26933,26932,-1,26733,26734,26934,26933,-1,26734,26735,26935,26934,-1,26735,26736,26936,26935,-1,26736,26737,26937,26936,-1,26737,26738,26938,26937,-1,26738,26739,26939,26938,-1,26739,26740,26940,26939,-1,26740,26741,26941,26940,-1,26741,26742,26942,26941,-1,26742,26743,26943,26942,-1,26743,26744,26944,26943,-1,26744,26745,26945,26944,-1,26745,26746,26946,26945,-1,26746,26747,26947,26946,-1,26747,26748,26948,26947,-1,26748,26749,26949,26948,-1,26749,26750,26950,26949,-1,26750,26751,26951,26950,-1,26751,26752,26952,26951,-1,26752,26753,26953,26952,-1,26753,26754,26954,26953,-1,26754,26755,26955,26954,-1,26755,26756,26956,26955,-1,26756,26757,26957,26956,-1,26757,26758,26958,26957,-1,26758,26759,26959,26958,-1,26759,26760,26960,26959,-1,26760,26761,26961,26960,-1,26761,26762,26962,26961,-1,26762,26763,26963,26962,-1,26763,26764,26964,26963,-1,26764,26765,26965,26964,-1,26765,26766,26966,26965,-1,26766,26767,26967,26966,-1,26767,26768,26968,26967,-1,26768,26769,26969,26968,-1,26769,26770,26970,26969,-1,26770,26771,26971,26970,-1,26771,26772,26972,26971,-1,26772,26773,26973,26972,-1,26773,26774,26974,26973,-1,26774,26775,26975,26974,-1,26775,26776,26976,26975,-1,26776,26777,26977,26976,-1,26777,26778,26978,26977,-1,26778,26779,26979,26978,-1,26779,26780,26980,26979,-1,26780,26781,26981,26980,-1,26781,26782,26982,26981,-1,26782,26783,26983,26982,-1,26783,26784,26984,26983,-1,26784,26785,26985,26984,-1,26785,26786,26986,26985,-1,26786,26787,26987,26986,-1,26787,26788,26988,26987,-1,26788,26789,26989,26988,-1,26789,26790,26990,26989,-1,26790,26791,26991,26990,-1,26791,26792,26992,26991,-1,26792,26793,26993,26992,-1,26793,26794,26994,26993,-1,26794,26795,26995,26994,-1,26795,26796,26996,26995,-1,26796,26797,26997,26996,-1,26797,26798,26998,26997,-1,26798,26799,26999,26998,-1,26800,26801,27001,27,-1,26801,26802,27002,27001,-1,26802,26803,27003,27002,-1,26803,26804,27004,27003,-1,26804,26805,27005,27004,-1,26805,26806,27006,27005,-1,26806,26807,27007,27006,-1,26807,26808,27008,27007,-1,26808,26809,27009,27008,-1,26809,26810,27010,27009,-1,26810,26811,27011,27010,-1,26811,26812,27012,27011,-1,26812,26813,27013,27012,-1,26813,26814,27014,27013,-1,26814,26815,27015,27014,-1,26815,26816,27016,27015,-1,26816,26817,27017,27016,-1,26817,26818,27018,27017,-1,26818,26819,27019,27018,-1,26819,26820,27020,27019,-1,26820,26821,27021,27020,-1,26821,26822,27022,27021,-1,26822,26823,27023,27022,-1,26823,26824,27024,27023,-1,26824,26825,27025,27024,-1,26825,26826,27026,27025,-1,26826,26827,27027,27026,-1,26827,26828,27028,27027,-1,26828,26829,27029,27028,-1,26829,26830,27030,27029,-1,26830,26831,27031,27030,-1,26831,26832,27032,27031,-1,26832,26833,27033,27032,-1,26833,26834,27034,27033,-1,26834,26835,27035,27034,-1,26835,26836,27036,27035,-1,26836,26837,27037,27036,-1,26837,26838,27038,27037,-1,26838,26839,27039,27038,-1,26839,26840,27040,27039,-1,26840,26841,27041,27040,-1,26841,26842,27042,27041,-1,26842,26843,27043,27042,-1,26843,26844,27044,27043,-1,26844,26845,27045,27044,-1,26845,26846,27046,27045,-1,26846,26847,27047,27046,-1,26847,26848,27048,27047,-1,26848,26849,27049,27048,-1,26849,26850,27050,27049,-1,26850,26851,27051,27050,-1,26851,26852,27052,27051,-1,26852,26853,27053,27052,-1,26853,26854,27054,27053,-1,26854,26855,27055,27054,-1,26855,26856,27056,27055,-1,26856,26857,27057,27056,-1,26857,26858,27058,27057,-1,26858,26859,27059,27058,-1,26859,26860,27060,27059,-1,26860,26861,27061,27060,-1,26861,26862,27062,27061,-1,26862,26863,27063,27062,-1,26863,26864,27064,27063,-1,26864,26865,27065,27064,-1,26865,26866,27066,27065,-1,26866,26867,27067,27066,-1,26867,26868,27068,27067,-1,26868,26869,27069,27068,-1,26869,26870,27070,27069,-1,26870,26871,27071,27070,-1,26871,26872,27072,27071,-1,26872,26873,27073,27072,-1,26873,26874,27074,27073,-1,26874,26875,27075,27074,-1,26875,26876,27076,27075,-1,26876,26877,27077,27076,-1,26877,26878,27078,27077,-1,26878,26879,27079,27078,-1,26879,26880,27080,27079,-1,26880,26881,27081,27080,-1,26881,26882,27082,27081,-1,26882,26883,27083,27082,-1,26883,26884,27084,27083,-1,26884,26885,27085,27084,-1,26885,26886,27086,27085,-1,26886,26887,27087,27086,-1,26887,26888,27088,27087,-1,26888,26889,27089,27088,-1,26889,26890,27090,27089,-1,26890,26891,27091,27090,-1,26891,26892,27092,27091,-1,26892,26893,27093,27092,-1,26893,26894,27094,27093,-1,26894,26895,27095,27094,-1,26895,26896,27096,27095,-1,26896,26897,27097,27096,-1,26897,26898,27098,27097,-1,26898,26899,27099,27098,-1,26899,26900,27100,27099,-1,26900,26901,27101,27100,-1,26901,26902,27102,27101,-1,26902,26903,27103,27102,-1,26903,26904,27104,27103,-1,26904,26905,27105,27104,-1,26905,26906,27106,27105,-1,26906,26907,27107,27106,-1,26907,26908,27108,27107,-1,26908,26909,27109,27108,-1,26909,26910,27110,27109,-1,26910,26911,27111,27110,-1,26911,26912,27112,27111,-1,26912,26913,27113,27112,-1,26913,26914,27114,27113,-1,26914,26915,27115,27114,-1,26915,26916,27116,27115,-1,26916,26917,27117,27116,-1,26917,26918,27118,27117,-1,26918,26919,27119,27118,-1,26919,26920,27120,27119,-1,26920,26921,27121,27120,-1,26921,26922,27122,27121,-1,26922,26923,27123,27122,-1,26923,26924,27124,27123,-1,26924,26925,27125,27124,-1,26925,26926,27126,27125,-1,26926,26927,27127,27126,-1,26927,26928,27128,27127,-1,26928,26929,27129,27128,-1,26929,26930,27130,27129,-1,26930,26931,27131,27130,-1,26931,26932,27132,27131,-1,26932,26933,27133,27132,-1,26933,26934,27134,27133,-1,26934,26935,27135,27134,-1,26935,26936,27136,27135,-1,26936,26937,27137,27136,-1,26937,26938,27138,27137,-1,26938,26939,27139,27138,-1,26939,26940,27140,27139,-1,26940,26941,27141,27140,-1,26941,26942,27142,27141,-1,26942,26943,27143,27142,-1,26943,26944,27144,27143,-1,26944,26945,27145,27144,-1,26945,26946,27146,27145,-1,26946,26947,27147,27146,-1,26947,26948,27148,27147,-1,26948,26949,27149,27148,-1,26949,26950,27150,27149,-1,26950,26951,27151,27150,-1,26951,26952,27152,27151,-1,26952,26953,27153,27152,-1,26953,26954,27154,27153,-1,26954,26955,27155,27154,-1,26955,26956,27156,27155,-1,26956,26957,27157,27156,-1,26957,26958,27158,27157,-1,26958,26959,27159,27158,-1,26959,26960,27160,27159,-1,26960,26961,27161,27160,-1,26961,26962,27162,27161,-1,26962,26963,27163,27162,-1,26963,26964,27164,27163,-1,26964,26965,27165,27164,-1,26965,26966,27166,27165,-1,26966,26967,27167,27166,-1,26967,26968,27168,27167,-1,26968,26969,27169,27168,-1,26969,26970,27170,27169,-1,26970,26971,27171,27170,-1,26971,26972,27172,27171,-1,26972,26973,27173,27172,-1,26973,26974,27174,27173,-1,26974,26975,27175,27174,-1,26975,26976,27176,27175,-1,26976,26977,27177,27176,-1,26977,26978,27178,27177,-1,26978,26979,27179,27178,-1,26979,26980,27180,27179,-1,26980,26981,27181,27180,-1,26981,26982,27182,27181,-1,26982,26983,27183,27182,-1,26983,26984,27184,27183,-1,26984,26985,27185,27184,-1,26985,26986,27186,27185,-1,26986,26987,27187,27186,-1,26987,26988,27188,27187,-1,26988,26989,27189,27188,-1,26989,26990,27190,27189,-1,26990,26991,27191,27190,-1,26991,26992,27192,27191,-1,26992,26993,27193,27192,-1,26993,26994,27194,27193,-1,26994,26995,27195,27194,-1,26995,26996,27196,27195,-1,26996,26997,27197,27196,-1,26997,26998,27198,27197,-1,26998,26999,27199,27198,-1,27,27001,27201,27200,-1,27001,27002,27202,27201,-1,27002,27003,27203,27202,-1,27003,27004,27204,27203,-1,27004,27005,27205,27204,-1,27005,27006,27206,27205,-1,27006,27007,27207,27206,-1,27007,27008,27208,27207,-1,27008,27009,27209,27208,-1,27009,27010,27210,27209,-1,27010,27011,27211,27210,-1,27011,27012,27212,27211,-1,27012,27013,27213,27212,-1,27013,27014,27214,27213,-1,27014,27015,27215,27214,-1,27015,27016,27216,27215,-1,27016,27017,27217,27216,-1,27017,27018,27218,27217,-1,27018,27019,27219,27218,-1,27019,27020,27220,27219,-1,27020,27021,27221,27220,-1,27021,27022,27222,27221,-1,27022,27023,27223,27222,-1,27023,27024,27224,27223,-1,27024,27025,27225,27224,-1,27025,27026,27226,27225,-1,27026,27027,27227,27226,-1,27027,27028,27228,27227,-1,27028,27029,27229,27228,-1,27029,27030,27230,27229,-1,27030,27031,27231,27230,-1,27031,27032,27232,27231,-1,27032,27033,27233,27232,-1,27033,27034,27234,27233,-1,27034,27035,27235,27234,-1,27035,27036,27236,27235,-1,27036,27037,27237,27236,-1,27037,27038,27238,27237,-1,27038,27039,27239,27238,-1,27039,27040,27240,27239,-1,27040,27041,27241,27240,-1,27041,27042,27242,27241,-1,27042,27043,27243,27242,-1,27043,27044,27244,27243,-1,27044,27045,27245,27244,-1,27045,27046,27246,27245,-1,27046,27047,27247,27246,-1,27047,27048,27248,27247,-1,27048,27049,27249,27248,-1,27049,27050,27250,27249,-1,27050,27051,27251,27250,-1,27051,27052,27252,27251,-1,27052,27053,27253,27252,-1,27053,27054,27254,27253,-1,27054,27055,27255,27254,-1,27055,27056,27256,27255,-1,27056,27057,27257,27256,-1,27057,27058,27258,27257,-1,27058,27059,27259,27258,-1,27059,27060,27260,27259,-1,27060,27061,27261,27260,-1,27061,27062,27262,27261,-1,27062,27063,27263,27262,-1,27063,27064,27264,27263,-1,27064,27065,27265,27264,-1,27065,27066,27266,27265,-1,27066,27067,27267,27266,-1,27067,27068,27268,27267,-1,27068,27069,27269,27268,-1,27069,27070,27270,27269,-1,27070,27071,27271,27270,-1,27071,27072,27272,27271,-1,27072,27073,27273,27272,-1,27073,27074,27274,27273,-1,27074,27075,27275,27274,-1,27075,27076,27276,27275,-1,27076,27077,27277,27276,-1,27077,27078,27278,27277,-1,27078,27079,27279,27278,-1,27079,27080,27280,27279,-1,27080,27081,27281,27280,-1,27081,27082,27282,27281,-1,27082,27083,27283,27282,-1,27083,27084,27284,27283,-1,27084,27085,27285,27284,-1,27085,27086,27286,27285,-1,27086,27087,27287,27286,-1,27087,27088,27288,27287,-1,27088,27089,27289,27288,-1,27089,27090,27290,27289,-1,27090,27091,27291,27290,-1,27091,27092,27292,27291,-1,27092,27093,27293,27292,-1,27093,27094,27294,27293,-1,27094,27095,27295,27294,-1,27095,27096,27296,27295,-1,27096,27097,27297,27296,-1,27097,27098,27298,27297,-1,27098,27099,27299,27298,-1,27099,27100,27300,27299,-1,27100,27101,27301,27300,-1,27101,27102,27302,27301,-1,27102,27103,27303,27302,-1,27103,27104,27304,27303,-1,27104,27105,27305,27304,-1,27105,27106,27306,27305,-1,27106,27107,27307,27306,-1,27107,27108,27308,27307,-1,27108,27109,27309,27308,-1,27109,27110,27310,27309,-1,27110,27111,27311,27310,-1,27111,27112,27312,27311,-1,27112,27113,27313,27312,-1,27113,27114,27314,27313,-1,27114,27115,27315,27314,-1,27115,27116,27316,27315,-1,27116,27117,27317,27316,-1,27117,27118,27318,27317,-1,27118,27119,27319,27318,-1,27119,27120,27320,27319,-1,27120,27121,27321,27320,-1,27121,27122,27322,27321,-1,27122,27123,27323,27322,-1,27123,27124,27324,27323,-1,27124,27125,27325,27324,-1,27125,27126,27326,27325,-1,27126,27127,27327,27326,-1,27127,27128,27328,27327,-1,27128,27129,27329,27328,-1,27129,27130,27330,27329,-1,27130,27131,27331,27330,-1,27131,27132,27332,27331,-1,27132,27133,27333,27332,-1,27133,27134,27334,27333,-1,27134,27135,27335,27334,-1,27135,27136,27336,27335,-1,27136,27137,27337,27336,-1,27137,27138,27338,27337,-1,27138,27139,27339,27338,-1,27139,27140,27340,27339,-1,27140,27141,27341,27340,-1,27141,27142,27342,27341,-1,27142,27143,27343,27342,-1,27143,27144,27344,27343,-1,27144,27145,27345,27344,-1,27145,27146,27346,27345,-1,27146,27147,27347,27346,-1,27147,27148,27348,27347,-1,27148,27149,27349,27348,-1,27149,27150,27350,27349,-1,27150,27151,27351,27350,-1,27151,27152,27352,27351,-1,27152,27153,27353,27352,-1,27153,27154,27354,27353,-1,27154,27155,27355,27354,-1,27155,27156,27356,27355,-1,27156,27157,27357,27356,-1,27157,27158,27358,27357,-1,27158,27159,27359,27358,-1,27159,27160,27360,27359,-1,27160,27161,27361,27360,-1,27161,27162,27362,27361,-1,27162,27163,27363,27362,-1,27163,27164,27364,27363,-1,27164,27165,27365,27364,-1,27165,27166,27366,27365,-1,27166,27167,27367,27366,-1,27167,27168,27368,27367,-1,27168,27169,27369,27368,-1,27169,27170,27370,27369,-1,27170,27171,27371,27370,-1,27171,27172,27372,27371,-1,27172,27173,27373,27372,-1,27173,27174,27374,27373,-1,27174,27175,27375,27374,-1,27175,27176,27376,27375,-1,27176,27177,27377,27376,-1,27177,27178,27378,27377,-1,27178,27179,27379,27378,-1,27179,27180,27380,27379,-1,27180,27181,27381,27380,-1,27181,27182,27382,27381,-1,27182,27183,27383,27382,-1,27183,27184,27384,27383,-1,27184,27185,27385,27384,-1,27185,27186,27386,27385,-1,27186,27187,27387,27386,-1,27187,27188,27388,27387,-1,27188,27189,27389,27388,-1,27189,27190,27390,27389,-1,27190,27191,27391,27390,-1,27191,27192,27392,27391,-1,27192,27193,27393,27392,-1,27193,27194,27394,27393,-1,27194,27195,27395,27394,-1,27195,27196,27396,27395,-1,27196,27197,27397,27396,-1,27197,27198,27398,27397,-1,27198,27199,27399,27398,-1,27200,27201,27401,27400,-1,27201,27202,27402,27401,-1,27202,27203,27403,27402,-1,27203,27204,27404,27403,-1,27204,27205,27405,27404,-1,27205,27206,27406,27405,-1,27206,27207,27407,27406,-1,27207,27208,27408,27407,-1,27208,27209,27409,27408,-1,27209,27210,27410,27409,-1,27210,27211,27411,27410,-1,27211,27212,27412,27411,-1,27212,27213,27413,27412,-1,27213,27214,27414,27413,-1,27214,27215,27415,27414,-1,27215,27216,27416,27415,-1,27216,27217,27417,27416,-1,27217,27218,27418,27417,-1,27218,27219,27419,27418,-1,27219,27220,27420,27419,-1,27220,27221,27421,27420,-1,27221,27222,27422,27421,-1,27222,27223,27423,27422,-1,27223,27224,27424,27423,-1,27224,27225,27425,27424,-1,27225,27226,27426,27425,-1,27226,27227,27427,27426,-1,27227,27228,27428,27427,-1,27228,27229,27429,27428,-1,27229,27230,27430,27429,-1,27230,27231,27431,27430,-1,27231,27232,27432,27431,-1,27232,27233,27433,27432,-1,27233,27234,27434,27433,-1,27234,27235,27435,27434,-1,27235,27236,27436,27435,-1,27236,27237,27437,27436,-1,27237,27238,27438,27437,-1,27238,27239,27439,27438,-1,27239,27240,27440,27439,-1,27240,27241,27441,27440,-1,27241,27242,27442,27441,-1,27242,27243,27443,27442,-1,27243,27244,27444,27443,-1,27244,27245,27445,27444,-1,27245,27246,27446,27445,-1,27246,27247,27447,27446,-1,27247,27248,27448,27447,-1,27248,27249,27449,27448,-1,27249,27250,27450,27449,-1,27250,27251,27451,27450,-1,27251,27252,27452,27451,-1,27252,27253,27453,27452,-1,27253,27254,27454,27453,-1,27254,27255,27455,27454,-1,27255,27256,27456,27455,-1,27256,27257,27457,27456,-1,27257,27258,27458,27457,-1,27258,27259,27459,27458,-1,27259,27260,27460,27459,-1,27260,27261,27461,27460,-1,27261,27262,27462,27461,-1,27262,27263,27463,27462,-1,27263,27264,27464,27463,-1,27264,27265,27465,27464,-1,27265,27266,27466,27465,-1,27266,27267,27467,27466,-1,27267,27268,27468,27467,-1,27268,27269,27469,27468,-1,27269,27270,27470,27469,-1,27270,27271,27471,27470,-1,27271,27272,27472,27471,-1,27272,27273,27473,27472,-1,27273,27274,27474,27473,-1,27274,27275,27475,27474,-1,27275,27276,27476,27475,-1,27276,27277,27477,27476,-1,27277,27278,27478,27477,-1,27278,27279,27479,27478,-1,27279,27280,27480,27479,-1,27280,27281,27481,27480,-1,27281,27282,27482,27481,-1,27282,27283,27483,27482,-1,27283,27284,27484,27483,-1,27284,27285,27485,27484,-1,27285,27286,27486,27485,-1,27286,27287,27487,27486,-1,27287,27288,27488,27487,-1,27288,27289,27489,27488,-1,27289,27290,27490,27489,-1,27290,27291,27491,27490,-1,27291,27292,27492,27491,-1,27292,27293,27493,27492,-1,27293,27294,27494,27493,-1,27294,27295,27495,27494,-1,27295,27296,27496,27495,-1,27296,27297,27497,27496,-1,27297,27298,27498,27497,-1,27298,27299,27499,27498,-1,27299,27300,27500,27499,-1,27300,27301,27501,27500,-1,27301,27302,27502,27501,-1,27302,27303,27503,27502,-1,27303,27304,27504,27503,-1,27304,27305,27505,27504,-1,27305,27306,27506,27505,-1,27306,27307,27507,27506,-1,27307,27308,27508,27507,-1,27308,27309,27509,27508,-1,27309,27310,27510,27509,-1,27310,27311,27511,27510,-1,27311,27312,27512,27511,-1,27312,27313,27513,27512,-1,27313,27314,27514,27513,-1,27314,27315,27515,27514,-1,27315,27316,27516,27515,-1,27316,27317,27517,27516,-1,27317,27318,27518,27517,-1,27318,27319,27519,27518,-1,27319,27320,27520,27519,-1,27320,27321,27521,27520,-1,27321,27322,27522,27521,-1,27322,27323,27523,27522,-1,27323,27324,27524,27523,-1,27324,27325,27525,27524,-1,27325,27326,27526,27525,-1,27326,27327,27527,27526,-1,27327,27328,27528,27527,-1,27328,27329,27529,27528,-1,27329,27330,27530,27529,-1,27330,27331,27531,27530,-1,27331,27332,27532,27531,-1,27332,27333,27533,27532,-1,27333,27334,27534,27533,-1,27334,27335,27535,27534,-1,27335,27336,27536,27535,-1,27336,27337,27537,27536,-1,27337,27338,27538,27537,-1,27338,27339,27539,27538,-1,27339,27340,27540,27539,-1,27340,27341,27541,27540,-1,27341,27342,27542,27541,-1,27342,27343,27543,27542,-1,27343,27344,27544,27543,-1,27344,27345,27545,27544,-1,27345,27346,27546,27545,-1,27346,27347,27547,27546,-1,27347,27348,27548,27547,-1,27348,27349,27549,27548,-1,27349,27350,27550,27549,-1,27350,27351,27551,27550,-1,27351,27352,27552,27551,-1,27352,27353,27553,27552,-1,27353,27354,27554,27553,-1,27354,27355,27555,27554,-1,27355,27356,27556,27555,-1,27356,27357,27557,27556,-1,27357,27358,27558,27557,-1,27358,27359,27559,27558,-1,27359,27360,27560,27559,-1,27360,27361,27561,27560,-1,27361,27362,27562,27561,-1,27362,27363,27563,27562,-1,27363,27364,27564,27563,-1,27364,27365,27565,27564,-1,27365,27366,27566,27565,-1,27366,27367,27567,27566,-1,27367,27368,27568,27567,-1,27368,27369,27569,27568,-1,27369,27370,27570,27569,-1,27370,27371,27571,27570,-1,27371,27372,27572,27571,-1,27372,27373,27573,27572,-1,27373,27374,27574,27573,-1,27374,27375,27575,27574,-1,27375,27376,27576,27575,-1,27376,27377,27577,27576,-1,27377,27378,27578,27577,-1,27378,27379,27579,27578,-1,27379,27380,27580,27579,-1,27380,27381,27581,27580,-1,27381,27382,27582,27581,-1,27382,27383,27583,27582,-1,27383,27384,27584,27583,-1,27384,27385,27585,27584,-1,27385,27386,27586,27585,-1,27386,27387,27587,27586,-1,27387,27388,27588,27587,-1,27388,27389,27589,27588,-1,27389,27390,27590,27589,-1,27390,27391,27591,27590,-1,27391,27392,27592,27591,-1,27392,27393,27593,27592,-1,27393,27394,27594,27593,-1,27394,27395,27595,27594,-1,27395,27396,27596,27595,-1,27396,27397,27597,27596,-1,27397,27398,27598,27597,-1,27398,27399,27599,27598,-1,27400,27401,27601,27600,-1,27401,27402,27602,27601,-1,27402,27403,27603,27602,-1,27403,27404,27604,27603,-1,27404,27405,27605,27604,-1,27405,27406,27606,27605,-1,27406,27407,27607,27606,-1,27407,27408,27608,27607,-1,27408,27409,27609,27608,-1,27409,27410,27610,27609,-1,27410,27411,27611,27610,-1,27411,27412,27612,27611,-1,27412,27413,27613,27612,-1,27413,27414,27614,27613,-1,27414,27415,27615,27614,-1,27415,27416,27616,27615,-1,27416,27417,27617,27616,-1,27417,27418,27618,27617,-1,27418,27419,27619,27618,-1,27419,27420,27620,27619,-1,27420,27421,27621,27620,-1,27421,27422,27622,27621,-1,27422,27423,27623,27622,-1,27423,27424,27624,27623,-1,27424,27425,27625,27624,-1,27425,27426,27626,27625,-1,27426,27427,27627,27626,-1,27427,27428,27628,27627,-1,27428,27429,27629,27628,-1,27429,27430,27630,27629,-1,27430,27431,27631,27630,-1,27431,27432,27632,27631,-1,27432,27433,27633,27632,-1,27433,27434,27634,27633,-1,27434,27435,27635,27634,-1,27435,27436,27636,27635,-1,27436,27437,27637,27636,-1,27437,27438,27638,27637,-1,27438,27439,27639,27638,-1,27439,27440,27640,27639,-1,27440,27441,27641,27640,-1,27441,27442,27642,27641,-1,27442,27443,27643,27642,-1,27443,27444,27644,27643,-1,27444,27445,27645,27644,-1,27445,27446,27646,27645,-1,27446,27447,27647,27646,-1,27447,27448,27648,27647,-1,27448,27449,27649,27648,-1,27449,27450,27650,27649,-1,27450,27451,27651,27650,-1,27451,27452,27652,27651,-1,27452,27453,27653,27652,-1,27453,27454,27654,27653,-1,27454,27455,27655,27654,-1,27455,27456,27656,27655,-1,27456,27457,27657,27656,-1,27457,27458,27658,27657,-1,27458,27459,27659,27658,-1,27459,27460,27660,27659,-1,27460,27461,27661,27660,-1,27461,27462,27662,27661,-1,27462,27463,27663,27662,-1,27463,27464,27664,27663,-1,27464,27465,27665,27664,-1,27465,27466,27666,27665,-1,27466,27467,27667,27666,-1,27467,27468,27668,27667,-1,27468,27469,27669,27668,-1,27469,27470,27670,27669,-1,27470,27471,27671,27670,-1,27471,27472,27672,27671,-1,27472,27473,27673,27672,-1,27473,27474,27674,27673,-1,27474,27475,27675,27674,-1,27475,27476,27676,27675,-1,27476,27477,27677,27676,-1,27477,27478,27678,27677,-1,27478,27479,27679,27678,-1,27479,27480,27680,27679,-1,27480,27481,27681,27680,-1,27481,27482,27682,27681,-1,27482,27483,27683,27682,-1,27483,27484,27684,27683,-1,27484,27485,27685,27684,-1,27485,27486,27686,27685,-1,27486,27487,27687,27686,-1,27487,27488,27688,27687,-1,27488,27489,27689,27688,-1,27489,27490,27690,27689,-1,27490,27491,27691,27690,-1,27491,27492,27692,27691,-1,27492,27493,27693,27692,-1,27493,27494,27694,27693,-1,27494,27495,27695,27694,-1,27495,27496,27696,27695,-1,27496,27497,27697,27696,-1,27497,27498,27698,27697,-1,27498,27499,27699,27698,-1,27499,27500,27700,27699,-1,27500,27501,27701,27700,-1,27501,27502,27702,27701,-1,27502,27503,27703,27702,-1,27503,27504,27704,27703,-1,27504,27505,27705,27704,-1,27505,27506,27706,27705,-1,27506,27507,27707,27706,-1,27507,27508,27708,27707,-1,27508,27509,27709,27708,-1,27509,27510,27710,27709,-1,27510,27511,27711,27710,-1,27511,27512,27712,27711,-1,27512,27513,27713,27712,-1,27513,27514,27714,27713,-1,27514,27515,27715,27714,-1,27515,27516,27716,27715,-1,27516,27517,27717,27716,-1,27517,27518,27718,27717,-1,27518,27519,27719,27718,-1,27519,27520,27720,27719,-1,27520,27521,27721,27720,-1,27521,27522,27722,27721,-1,27522,27523,27723,27722,-1,27523,27524,27724,27723,-1,27524,27525,27725,27724,-1,27525,27526,27726,27725,-1,27526,27527,27727,27726,-1,27527,27528,27728,27727,-1,27528,27529,27729,27728,-1,27529,27530,27730,27729,-1,27530,27531,27731,27730,-1,27531,27532,27732,27731,-1,27532,27533,27733,27732,-1,27533,27534,27734,27733,-1,27534,27535,27735,27734,-1,27535,27536,27736,27735,-1,27536,27537,27737,27736,-1,27537,27538,27738,27737,-1,27538,27539,27739,27738,-1,27539,27540,27740,27739,-1,27540,27541,27741,27740,-1,27541,27542,27742,27741,-1,27542,27543,27743,27742,-1,27543,27544,27744,27743,-1,27544,27545,27745,27744,-1,27545,27546,27746,27745,-1,27546,27547,27747,27746,-1,27547,27548,27748,27747,-1,27548,27549,27749,27748,-1,27549,27550,27750,27749,-1,27550,27551,27751,27750,-1,27551,27552,27752,27751,-1,27552,27553,27753,27752,-1,27553,27554,27754,27753,-1,27554,27555,27755,27754,-1,27555,27556,27756,27755,-1,27556,27557,27757,27756,-1,27557,27558,27758,27757,-1,27558,27559,27759,27758,-1,27559,27560,27760,27759,-1,27560,27561,27761,27760,-1,27561,27562,27762,27761,-1,27562,27563,27763,27762,-1,27563,27564,27764,27763,-1,27564,27565,27765,27764,-1,27565,27566,27766,27765,-1,27566,27567,27767,27766,-1,27567,27568,27768,27767,-1,27568,27569,27769,27768,-1,27569,27570,27770,27769,-1,27570,27571,27771,27770,-1,27571,27572,27772,27771,-1,27572,27573,27773,27772,-1,27573,27574,27774,27773,-1,27574,27575,27775,27774,-1,27575,27576,27776,27775,-1,27576,27577,27777,27776,-1,27577,27578,27778,27777,-1,27578,27579,27779,27778,-1,27579,27580,27780,27779,-1,27580,27581,27781,27780,-1,27581,27582,27782,27781,-1,27582,27583,27783,27782,-1,27583,27584,27784,27783,-1,27584,27585,27785,27784,-1,27585,27586,27786,27785,-1,27586,27587,27787,27786,-1,27587,27588,27788,27787,-1,27588,27589,27789,27788,-1,27589,27590,27790,27789,-1,27590,27591,27791,27790,-1,27591,27592,27792,27791,-1,27592,27593,27793,27792,-1,27593,27594,27794,27793,-1,27594,27595,27795,27794,-1,27595,27596,27796,27795,-1,27596,27597,27797,27796,-1,27597,27598,27798,27797,-1,27598,27599,27799,27798,-1,27600,27601,27801,27800,-1,27601,27602,27802,27801,-1,27602,27603,27803,27802,-1,27603,27604,27804,27803,-1,27604,27605,27805,27804,-1,27605,27606,27806,27805,-1,27606,27607,27807,27806,-1,27607,27608,27808,27807,-1,27608,27609,27809,27808,-1,27609,27610,27810,27809,-1,27610,27611,27811,27810,-1,27611,27612,27812,27811,-1,27612,27613,27813,27812,-1,27613,27614,27814,27813,-1,27614,27615,27815,27814,-1,27615,27616,27816,27815,-1,27616,27617,27817,27816,-1,27617,27618,27818,27817,-1,27618,27619,27819,27818,-1,27619,27620,27820,27819,-1,27620,27621,27821,27820,-1,27621,27622,27822,27821,-1,27622,27623,27823,27822,-1,27623,27624,27824,27823,-1,27624,27625,27825,27824,-1,27625,27626,27826,27825,-1,27626,27627,27827,27826,-1,27627,27628,27828,27827,-1,27628,27629,27829,27828,-1,27629,27630,27830,27829,-1,27630,27631,27831,27830,-1,27631,27632,27832,27831,-1,27632,27633,27833,27832,-1,27633,27634,27834,27833,-1,27634,27635,27835,27834,-1,27635,27636,27836,27835,-1,27636,27637,27837,27836,-1,27637,27638,27838,27837,-1,27638,27639,27839,27838,-1,27639,27640,27840,27839,-1,27640,27641,27841,27840,-1,27641,27642,27842,27841,-1,27642,27643,27843,27842,-1,27643,27644,27844,27843,-1,27644,27645,27845,27844,-1,27645,27646,27846,27845,-1,27646,27647,27847,27846,-1,27647,27648,27848,27847,-1,27648,27649,27849,27848,-1,27649,27650,27850,27849,-1,27650,27651,27851,27850,-1,27651,27652,27852,27851,-1,27652,27653,27853,27852,-1,27653,27654,27854,27853,-1,27654,27655,27855,27854,-1,27655,27656,27856,27855,-1,27656,27657,27857,27856,-1,27657,27658,27858,27857,-1,27658,27659,27859,27858,-1,27659,27660,27860,27859,-1,27660,27661,27861,27860,-1,27661,27662,27862,27861,-1,27662,27663,27863,27862,-1,27663,27664,27864,27863,-1,27664,27665,27865,27864,-1,27665,27666,27866,27865,-1,27666,27667,27867,27866,-1,27667,27668,27868,27867,-1,27668,27669,27869,27868,-1,27669,27670,27870,27869,-1,27670,27671,27871,27870,-1,27671,27672,27872,27871,-1,27672,27673,27873,27872,-1,27673,27674,27874,27873,-1,27674,27675,27875,27874,-1,27675,27676,27876,27875,-1,27676,27677,27877,27876,-1,27677,27678,27878,27877,-1,27678,27679,27879,27878,-1,27679,27680,27880,27879,-1,27680,27681,27881,27880,-1,27681,27682,27882,27881,-1,27682,27683,27883,27882,-1,27683,27684,27884,27883,-1,27684,27685,27885,27884,-1,27685,27686,27886,27885,-1,27686,27687,27887,27886,-1,27687,27688,27888,27887,-1,27688,27689,27889,27888,-1,27689,27690,27890,27889,-1,27690,27691,27891,27890,-1,27691,27692,27892,27891,-1,27692,27693,27893,27892,-1,27693,27694,27894,27893,-1,27694,27695,27895,27894,-1,27695,27696,27896,27895,-1,27696,27697,27897,27896,-1,27697,27698,27898,27897,-1,27698,27699,27899,27898,-1,27699,27700,27900,27899,-1,27700,27701,27901,27900,-1,27701,27702,27902,27901,-1,27702,27703,27903,27902,-1,27703,27704,27904,27903,-1,27704,27705,27905,27904,-1,27705,27706,27906,27905,-1,27706,27707,27907,27906,-1,27707,27708,27908,27907,-1,27708,27709,27909,27908,-1,27709,27710,27910,27909,-1,27710,27711,27911,27910,-1,27711,27712,27912,27911,-1,27712,27713,27913,27912,-1,27713,27714,27914,27913,-1,27714,27715,27915,27914,-1,27715,27716,27916,27915,-1,27716,27717,27917,27916,-1,27717,27718,27918,27917,-1,27718,27719,27919,27918,-1,27719,27720,27920,27919,-1,27720,27721,27921,27920,-1,27721,27722,27922,27921,-1,27722,27723,27923,27922,-1,27723,27724,27924,27923,-1,27724,27725,27925,27924,-1,27725,27726,27926,27925,-1,27726,27727,27927,27926,-1,27727,27728,27928,27927,-1,27728,27729,27929,27928,-1,27729,27730,27930,27929,-1,27730,27731,27931,27930,-1,27731,27732,27932,27931,-1,27732,27733,27933,27932,-1,27733,27734,27934,27933,-1,27734,27735,27935,27934,-1,27735,27736,27936,27935,-1,27736,27737,27937,27936,-1,27737,27738,27938,27937,-1,27738,27739,27939,27938,-1,27739,27740,27940,27939,-1,27740,27741,27941,27940,-1,27741,27742,27942,27941,-1,27742,27743,27943,27942,-1,27743,27744,27944,27943,-1,27744,27745,27945,27944,-1,27745,27746,27946,27945,-1,27746,27747,27947,27946,-1,27747,27748,27948,27947,-1,27748,27749,27949,27948,-1,27749,27750,27950,27949,-1,27750,27751,27951,27950,-1,27751,27752,27952,27951,-1,27752,27753,27953,27952,-1,27753,27754,27954,27953,-1,27754,27755,27955,27954,-1,27755,27756,27956,27955,-1,27756,27757,27957,27956,-1,27757,27758,27958,27957,-1,27758,27759,27959,27958,-1,27759,27760,27960,27959,-1,27760,27761,27961,27960,-1,27761,27762,27962,27961,-1,27762,27763,27963,27962,-1,27763,27764,27964,27963,-1,27764,27765,27965,27964,-1,27765,27766,27966,27965,-1,27766,27767,27967,27966,-1,27767,27768,27968,27967,-1,27768,27769,27969,27968,-1,27769,27770,27970,27969,-1,27770,27771,27971,27970,-1,27771,27772,27972,27971,-1,27772,27773,27973,27972,-1,27773,27774,27974,27973,-1,27774,27775,27975,27974,-1,27775,27776,27976,27975,-1,27776,27777,27977,27976,-1,27777,27778,27978,27977,-1,27778,27779,27979,27978,-1,27779,27780,27980,27979,-1,27780,27781,27981,27980,-1,27781,27782,27982,27981,-1,27782,27783,27983,27982,-1,27783,27784,27984,27983,-1,27784,27785,27985,27984,-1,27785,27786,27986,27985,-1,27786,27787,27987,27986,-1,27787,27788,27988,27987,-1,27788,27789,27989,27988,-1,27789,27790,27990,27989,-1,27790,27791,27991,27990,-1,27791,27792,27992,27991,-1,27792,27793,27993,27992,-1,27793,27794,27994,27993,-1,27794,27795,27995,27994,-1,27795,27796,27996,27995,-1,27796,27797,27997,27996,-1,27797,27798,27998,27997,-1,27798,27799,27999,27998,-1,27800,27801,28001,28,-1,27801,27802,28002,28001,-1,27802,27803,28003,28002,-1,27803,27804,28004,28003,-1,27804,27805,28005,28004,-1,27805,27806,28006,28005,-1,27806,27807,28007,28006,-1,27807,27808,28008,28007,-1,27808,27809,28009,28008,-1,27809,27810,28010,28009,-1,27810,27811,28011,28010,-1,27811,27812,28012,28011,-1,27812,27813,28013,28012,-1,27813,27814,28014,28013,-1,27814,27815,28015,28014,-1,27815,27816,28016,28015,-1,27816,27817,28017,28016,-1,27817,27818,28018,28017,-1,27818,27819,28019,28018,-1,27819,27820,28020,28019,-1,27820,27821,28021,28020,-1,27821,27822,28022,28021,-1,27822,27823,28023,28022,-1,27823,27824,28024,28023,-1,27824,27825,28025,28024,-1,27825,27826,28026,28025,-1,27826,27827,28027,28026,-1,27827,27828,28028,28027,-1,27828,27829,28029,28028,-1,27829,27830,28030,28029,-1,27830,27831,28031,28030,-1,27831,27832,28032,28031,-1,27832,27833,28033,28032,-1,27833,27834,28034,28033,-1,27834,27835,28035,28034,-1,27835,27836,28036,28035,-1,27836,27837,28037,28036,-1,27837,27838,28038,28037,-1,27838,27839,28039,28038,-1,27839,27840,28040,28039,-1,27840,27841,28041,28040,-1,27841,27842,28042,28041,-1,27842,27843,28043,28042,-1,27843,27844,28044,28043,-1,27844,27845,28045,28044,-1,27845,27846,28046,28045,-1,27846,27847,28047,28046,-1,27847,27848,28048,28047,-1,27848,27849,28049,28048,-1,27849,27850,28050,28049,-1,27850,27851,28051,28050,-1,27851,27852,28052,28051,-1,27852,27853,28053,28052,-1,27853,27854,28054,28053,-1,27854,27855,28055,28054,-1,27855,27856,28056,28055,-1,27856,27857,28057,28056,-1,27857,27858,28058,28057,-1,27858,27859,28059,28058,-1,27859,27860,28060,28059,-1,27860,27861,28061,28060,-1,27861,27862,28062,28061,-1,27862,27863,28063,28062,-1,27863,27864,28064,28063,-1,27864,27865,28065,28064,-1,27865,27866,28066,28065,-1,27866,27867,28067,28066,-1,27867,27868,28068,28067,-1,27868,27869,28069,28068,-1,27869,27870,28070,28069,-1,27870,27871,28071,28070,-1,27871,27872,28072,28071,-1,27872,27873,28073,28072,-1,27873,27874,28074,28073,-1,27874,27875,28075,28074,-1,27875,27876,28076,28075,-1,27876,27877,28077,28076,-1,27877,27878,28078,28077,-1,27878,27879,28079,28078,-1,27879,27880,28080,28079,-1,27880,27881,28081,28080,-1,27881,27882,28082,28081,-1,27882,27883,28083,28082,-1,27883,27884,28084,28083,-1,27884,27885,28085,28084,-1,27885,27886,28086,28085,-1,27886,27887,28087,28086,-1,27887,27888,28088,28087,-1,27888,27889,28089,28088,-1,27889,27890,28090,28089,-1,27890,27891,28091,28090,-1,27891,27892,28092,28091,-1,27892,27893,28093,28092,-1,27893,27894,28094,28093,-1,27894,27895,28095,28094,-1,27895,27896,28096,28095,-1,27896,27897,28097,28096,-1,27897,27898,28098,28097,-1,27898,27899,28099,28098,-1,27899,27900,28100,28099,-1,27900,27901,28101,28100,-1,27901,27902,28102,28101,-1,27902,27903,28103,28102,-1,27903,27904,28104,28103,-1,27904,27905,28105,28104,-1,27905,27906,28106,28105,-1,27906,27907,28107,28106,-1,27907,27908,28108,28107,-1,27908,27909,28109,28108,-1,27909,27910,28110,28109,-1,27910,27911,28111,28110,-1,27911,27912,28112,28111,-1,27912,27913,28113,28112,-1,27913,27914,28114,28113,-1,27914,27915,28115,28114,-1,27915,27916,28116,28115,-1,27916,27917,28117,28116,-1,27917,27918,28118,28117,-1,27918,27919,28119,28118,-1,27919,27920,28120,28119,-1,27920,27921,28121,28120,-1,27921,27922,28122,28121,-1,27922,27923,28123,28122,-1,27923,27924,28124,28123,-1,27924,27925,28125,28124,-1,27925,27926,28126,28125,-1,27926,27927,28127,28126,-1,27927,27928,28128,28127,-1,27928,27929,28129,28128,-1,27929,27930,28130,28129,-1,27930,27931,28131,28130,-1,27931,27932,28132,28131,-1,27932,27933,28133,28132,-1,27933,27934,28134,28133,-1,27934,27935,28135,28134,-1,27935,27936,28136,28135,-1,27936,27937,28137,28136,-1,27937,27938,28138,28137,-1,27938,27939,28139,28138,-1,27939,27940,28140,28139,-1,27940,27941,28141,28140,-1,27941,27942,28142,28141,-1,27942,27943,28143,28142,-1,27943,27944,28144,28143,-1,27944,27945,28145,28144,-1,27945,27946,28146,28145,-1,27946,27947,28147,28146,-1,27947,27948,28148,28147,-1,27948,27949,28149,28148,-1,27949,27950,28150,28149,-1,27950,27951,28151,28150,-1,27951,27952,28152,28151,-1,27952,27953,28153,28152,-1,27953,27954,28154,28153,-1,27954,27955,28155,28154,-1,27955,27956,28156,28155,-1,27956,27957,28157,28156,-1,27957,27958,28158,28157,-1,27958,27959,28159,28158,-1,27959,27960,28160,28159,-1,27960,27961,28161,28160,-1,27961,27962,28162,28161,-1,27962,27963,28163,28162,-1,27963,27964,28164,28163,-1,27964,27965,28165,28164,-1,27965,27966,28166,28165,-1,27966,27967,28167,28166,-1,27967,27968,28168,28167,-1,27968,27969,28169,28168,-1,27969,27970,28170,28169,-1,27970,27971,28171,28170,-1,27971,27972,28172,28171,-1,27972,27973,28173,28172,-1,27973,27974,28174,28173,-1,27974,27975,28175,28174,-1,27975,27976,28176,28175,-1,27976,27977,28177,28176,-1,27977,27978,28178,28177,-1,27978,27979,28179,28178,-1,27979,27980,28180,28179,-1,27980,27981,28181,28180,-1,27981,27982,28182,28181,-1,27982,27983,28183,28182,-1,27983,27984,28184,28183,-1,27984,27985,28185,28184,-1,27985,27986,28186,28185,-1,27986,27987,28187,28186,-1,27987,27988,28188,28187,-1,27988,27989,28189,28188,-1,27989,27990,28190,28189,-1,27990,27991,28191,28190,-1,27991,27992,28192,28191,-1,27992,27993,28193,28192,-1,27993,27994,28194,28193,-1,27994,27995,28195,28194,-1,27995,27996,28196,28195,-1,27996,27997,28197,28196,-1,27997,27998,28198,28197,-1,27998,27999,28199,28198,-1,28,28001,28201,28200,-1,28001,28002,28202,28201,-1,28002,28003,28203,28202,-1,28003,28004,28204,28203,-1,28004,28005,28205,28204,-1,28005,28006,28206,28205,-1,28006,28007,28207,28206,-1,28007,28008,28208,28207,-1,28008,28009,28209,28208,-1,28009,28010,28210,28209,-1,28010,28011,28211,28210,-1,28011,28012,28212,28211,-1,28012,28013,28213,28212,-1,28013,28014,28214,28213,-1,28014,28015,28215,28214,-1,28015,28016,28216,28215,-1,28016,28017,28217,28216,-1,28017,28018,28218,28217,-1,28018,28019,28219,28218,-1,28019,28020,28220,28219,-1,28020,28021,28221,28220,-1,28021,28022,28222,28221,-1,28022,28023,28223,28222,-1,28023,28024,28224,28223,-1,28024,28025,28225,28224,-1,28025,28026,28226,28225,-1,28026,28027,28227,28226,-1,28027,28028,28228,28227,-1,28028,28029,28229,28228,-1,28029,28030,28230,28229,-1,28030,28031,28231,28230,-1,28031,28032,28232,28231,-1,28032,28033,28233,28232,-1,28033,28034,28234,28233,-1,28034,28035,28235,28234,-1,28035,28036,28236,28235,-1,28036,28037,28237,28236,-1,28037,28038,28238,28237,-1,28038,28039,28239,28238,-1,28039,28040,28240,28239,-1,28040,28041,28241,28240,-1,28041,28042,28242,28241,-1,28042,28043,28243,28242,-1,28043,28044,28244,28243,-1,28044,28045,28245,28244,-1,28045,28046,28246,28245,-1,28046,28047,28247,28246,-1,28047,28048,28248,28247,-1,28048,28049,28249,28248,-1,28049,28050,28250,28249,-1,28050,28051,28251,28250,-1,28051,28052,28252,28251,-1,28052,28053,28253,28252,-1,28053,28054,28254,28253,-1,28054,28055,28255,28254,-1,28055,28056,28256,28255,-1,28056,28057,28257,28256,-1,28057,28058,28258,28257,-1,28058,28059,28259,28258,-1,28059,28060,28260,28259,-1,28060,28061,28261,28260,-1,28061,28062,28262,28261,-1,28062,28063,28263,28262,-1,28063,28064,28264,28263,-1,28064,28065,28265,28264,-1,28065,28066,28266,28265,-1,28066,28067,28267,28266,-1,28067,28068,28268,28267,-1,28068,28069,28269,28268,-1,28069,28070,28270,28269,-1,28070,28071,28271,28270,-1,28071,28072,28272,28271,-1,28072,28073,28273,28272,-1,28073,28074,28274,28273,-1,28074,28075,28275,28274,-1,28075,28076,28276,28275,-1,28076,28077,28277,28276,-1,28077,28078,28278,28277,-1,28078,28079,28279,28278,-1,28079,28080,28280,28279,-1,28080,28081,28281,28280,-1,28081,28082,28282,28281,-1,28082,28083,28283,28282,-1,28083,28084,28284,28283,-1,28084,28085,28285,28284,-1,28085,28086,28286,28285,-1,28086,28087,28287,28286,-1,28087,28088,28288,28287,-1,28088,28089,28289,28288,-1,28089,28090,28290,28289,-1,28090,28091,28291,28290,-1,28091,28092,28292,28291,-1,28092,28093,28293,28292,-1,28093,28094,28294,28293,-1,28094,28095,28295,28294,-1,28095,28096,28296,28295,-1,28096,28097,28297,28296,-1,28097,28098,28298,28297,-1,28098,28099,28299,28298,-1,28099,28100,28300,28299,-1,28100,28101,28301,28300,-1,28101,28102,28302,28301,-1,28102,28103,28303,28302,-1,28103,28104,28304,28303,-1,28104,28105,28305,28304,-1,28105,28106,28306,28305,-1,28106,28107,28307,28306,-1,28107,28108,28308,28307,-1,28108,28109,28309,28308,-1,28109,28110,28310,28309,-1,28110,28111,28311,28310,-1,28111,28112,28312,28311,-1,28112,28113,28313,28312,-1,28113,28114,28314,28313,-1,28114,28115,28315,28314,-1,28115,28116,28316,28315,-1,28116,28117,28317,28316,-1,28117,28118,28318,28317,-1,28118,28119,28319,28318,-1,28119,28120,28320,28319,-1,28120,28121,28321,28320,-1,28121,28122,28322,28321,-1,28122,28123,28323,28322,-1,28123,28124,28324,28323,-1,28124,28125,28325,28324,-1,28125,28126,28326,28325,-1,28126,28127,28327,28326,-1,28127,28128,28328,28327,-1,28128,28129,28329,28328,-1,28129,28130,28330,28329,-1,28130,28131,28331,28330,-1,28131,28132,28332,28331,-1,28132,28133,28333,28332,-1,28133,28134,28334,28333,-1,28134,28135,28335,28334,-1,28135,28136,28336,28335,-1,28136,28137,28337,28336,-1,28137,28138,28338,28337,-1,28138,28139,28339,28338,-1,28139,28140,28340,28339,-1,28140,28141,28341,28340,-1,28141,28142,28342,28341,-1,28142,28143,28343,28342,-1,28143,28144,28344,28343,-1,28144,28145,28345,28344,-1,28145,28146,28346,28345,-1,28146,28147,28347,28346,-1,28147,28148,28348,28347,-1,28148,28149,28349,28348,-1,28149,28150,28350,28349,-1,28150,28151,28351,28350,-1,28151,28152,28352,28351,-1,28152,28153,28353,28352,-1,28153,28154,28354,28353,-1,28154,28155,28355,28354,-1,28155,28156,28356,28355,-1,28156,28157,28357,28356,-1,28157,28158,28358,28357,-1,28158,28159,28359,28358,-1,28159,28160,28360,28359,-1,28160,28161,28361,28360,-1,28161,28162,28362,28361,-1,28162,28163,28363,28362,-1,28163,28164,28364,28363,-1,28164,28165,28365,28364,-1,28165,28166,28366,28365,-1,28166,28167,28367,28366,-1,28167,28168,28368,28367,-1,28168,28169,28369,28368,-1,28169,28170,28370,28369,-1,28170,28171,28371,28370,-1,28171,28172,28372,28371,-1,28172,28173,28373,28372,-1,28173,28174,28374,28373,-1,28174,28175,28375,28374,-1,28175,28176,28376,28375,-1,28176,28177,28377,28376,-1,28177,28178,28378,28377,-1,28178,28179,28379,28378,-1,28179,28180,28380,28379,-1,28180,28181,28381,28380,-1,28181,28182,28382,28381,-1,28182,28183,28383,28382,-1,28183,28184,28384,28383,-1,28184,28185,28385,28384,-1,28185,28186,28386,28385,-1,28186,28187,28387,28386,-1,28187,28188,28388,28387,-1,28188,28189,28389,28388,-1,28189,28190,28390,28389,-1,28190,28191,28391,28390,-1,28191,28192,28392,28391,-1,28192,28193,28393,28392,-1,28193,28194,28394,28393,-1,28194,28195,28395,28394,-1,28195,28196,28396,28395,-1,28196,28197,28397,28396,-1,28197,28198,28398,28397,-1,28198,28199,28399,28398,-1,28200,28201,28401,28400,-1,28201,28202,28402,28401,-1,28202,28203,28403,28402,-1,28203,28204,28404,28403,-1,28204,28205,28405,28404,-1,28205,28206,28406,28405,-1,28206,28207,28407,28406,-1,28207,28208,28408,28407,-1,28208,28209,28409,28408,-1,28209,28210,28410,28409,-1,28210,28211,28411,28410,-1,28211,28212,28412,28411,-1,28212,28213,28413,28412,-1,28213,28214,28414,28413,-1,28214,28215,28415,28414,-1,28215,28216,28416,28415,-1,28216,28217,28417,28416,-1,28217,28218,28418,28417,-1,28218,28219,28419,28418,-1,28219,28220,28420,28419,-1,28220,28221,28421,28420,-1,28221,28222,28422,28421,-1,28222,28223,28423,28422,-1,28223,28224,28424,28423,-1,28224,28225,28425,28424,-1,28225,28226,28426,28425,-1,28226,28227,28427,28426,-1,28227,28228,28428,28427,-1,28228,28229,28429,28428,-1,28229,28230,28430,28429,-1,28230,28231,28431,28430,-1,28231,28232,28432,28431,-1,28232,28233,28433,28432,-1,28233,28234,28434,28433,-1,28234,28235,28435,28434,-1,28235,28236,28436,28435,-1,28236,28237,28437,28436,-1,28237,28238,28438,28437,-1,28238,28239,28439,28438,-1,28239,28240,28440,28439,-1,28240,28241,28441,28440,-1,28241,28242,28442,28441,-1,28242,28243,28443,28442,-1,28243,28244,28444,28443,-1,28244,28245,28445,28444,-1,28245,28246,28446,28445,-1,28246,28247,28447,28446,-1,28247,28248,28448,28447,-1,28248,28249,28449,28448,-1,28249,28250,28450,28449,-1,28250,28251,28451,28450,-1,28251,28252,28452,28451,-1,28252,28253,28453,28452,-1,28253,28254,28454,28453,-1,28254,28255,28455,28454,-1,28255,28256,28456,28455,-1,28256,28257,28457,28456,-1,28257,28258,28458,28457,-1,28258,28259,28459,28458,-1,28259,28260,28460,28459,-1,28260,28261,28461,28460,-1,28261,28262,28462,28461,-1,28262,28263,28463,28462,-1,28263,28264,28464,28463,-1,28264,28265,28465,28464,-1,28265,28266,28466,28465,-1,28266,28267,28467,28466,-1,28267,28268,28468,28467,-1,28268,28269,28469,28468,-1,28269,28270,28470,28469,-1,28270,28271,28471,28470,-1,28271,28272,28472,28471,-1,28272,28273,28473,28472,-1,28273,28274,28474,28473,-1,28274,28275,28475,28474,-1,28275,28276,28476,28475,-1,28276,28277,28477,28476,-1,28277,28278,28478,28477,-1,28278,28279,28479,28478,-1,28279,28280,28480,28479,-1,28280,28281,28481,28480,-1,28281,28282,28482,28481,-1,28282,28283,28483,28482,-1,28283,28284,28484,28483,-1,28284,28285,28485,28484,-1,28285,28286,28486,28485,-1,28286,28287,28487,28486,-1,28287,28288,28488,28487,-1,28288,28289,28489,28488,-1,28289,28290,28490,28489,-1,28290,28291,28491,28490,-1,28291,28292,28492,28491,-1,28292,28293,28493,28492,-1,28293,28294,28494,28493,-1,28294,28295,28495,28494,-1,28295,28296,28496,28495,-1,28296,28297,28497,28496,-1,28297,28298,28498,28497,-1,28298,28299,28499,28498,-1,28299,28300,28500,28499,-1,28300,28301,28501,28500,-1,28301,28302,28502,28501,-1,28302,28303,28503,28502,-1,28303,28304,28504,28503,-1,28304,28305,28505,28504,-1,28305,28306,28506,28505,-1,28306,28307,28507,28506,-1,28307,28308,28508,28507,-1,28308,28309,28509,28508,-1,28309,28310,28510,28509,-1,28310,28311,28511,28510,-1,28311,28312,28512,28511,-1,28312,28313,28513,28512,-1,28313,28314,28514,28513,-1,28314,28315,28515,28514,-1,28315,28316,28516,28515,-1,28316,28317,28517,28516,-1,28317,28318,28518,28517,-1,28318,28319,28519,28518,-1,28319,28320,28520,28519,-1,28320,28321,28521,28520,-1,28321,28322,28522,28521,-1,28322,28323,28523,28522,-1,28323,28324,28524,28523,-1,28324,28325,28525,28524,-1,28325,28326,28526,28525,-1,28326,28327,28527,28526,-1,28327,28328,28528,28527,-1,28328,28329,28529,28528,-1,28329,28330,28530,28529,-1,28330,28331,28531,28530,-1,28331,28332,28532,28531,-1,28332,28333,28533,28532,-1,28333,28334,28534,28533,-1,28334,28335,28535,28534,-1,28335,28336,28536,28535,-1,28336,28337,28537,28536,-1,28337,28338,28538,28537,-1,28338,28339,28539,28538,-1,28339,28340,28540,28539,-1,28340,28341,28541,28540,-1,28341,28342,28542,28541,-1,28342,28343,28543,28542,-1,28343,28344,28544,28543,-1,28344,28345,28545,28544,-1,28345,28346,28546,28545,-1,28346,28347,28547,28546,-1,28347,28348,28548,28547,-1,28348,28349,28549,28548,-1,28349,28350,28550,28549,-1,28350,28351,28551,28550,-1,28351,28352,28552,28551,-1,28352,28353,28553,28552,-1,28353,28354,28554,28553,-1,28354,28355,28555,28554,-1,28355,28356,28556,28555,-1,28356,28357,28557,28556,-1,28357,28358,28558,28557,-1,28358,28359,28559,28558,-1,28359,28360,28560,28559,-1,28360,28361,28561,28560,-1,28361,28362,28562,28561,-1,28362,28363,28563,28562,-1,28363,28364,28564,28563,-1,28364,28365,28565,28564,-1,28365,28366,28566,28565,-1,28366,28367,28567,28566,-1,28367,28368,28568,28567,-1,28368,28369,28569,28568,-1,28369,28370,28570,28569,-1,28370,28371,28571,28570,-1,28371,28372,28572,28571,-1,28372,28373,28573,28572,-1,28373,28374,28574,28573,-1,28374,28375,28575,28574,-1,28375,28376,28576,28575,-1,28376,28377,28577,28576,-1,28377,28378,28578,28577,-1,28378,28379,28579,28578,-1,28379,28380,28580,28579,-1,28380,28381,28581,28580,-1,28381,28382,28582,28581,-1,28382,28383,28583,28582,-1,28383,28384,28584,28583,-1,28384,28385,28585,28584,-1,28385,28386,28586,28585,-1,28386,28387,28587,28586,-1,28387,28388,28588,28587,-1,28388,28389,28589,28588,-1,28389,28390,28590,28589,-1,28390,28391,28591,28590,-1,28391,28392,28592,28591,-1,28392,28393,28593,28592,-1,28393,28394,28594,28593,-1,28394,28395,28595,28594,-1,28395,28396,28596,28595,-1,28396,28397,28597,28596,-1,28397,28398,28598,28597,-1,28398,28399,28599,28598,-1,28400,28401,28601,28600,-1,28401,28402,28602,28601,-1,28402,28403,28603,28602,-1,28403,28404,28604,28603,-1,28404,28405,28605,28604,-1,28405,28406,28606,28605,-1,28406,28407,28607,28606,-1,28407,28408,28608,28607,-1,28408,28409,28609,28608,-1,28409,28410,28610,28609,-1,28410,28411,28611,28610,-1,28411,28412,28612,28611,-1,28412,28413,28613,28612,-1,28413,28414,28614,28613,-1,28414,28415,28615,28614,-1,28415,28416,28616,28615,-1,28416,28417,28617,28616,-1,28417,28418,28618,28617,-1,28418,28419,28619,28618,-1,28419,28420,28620,28619,-1,28420,28421,28621,28620,-1,28421,28422,28622,28621,-1,28422,28423,28623,28622,-1,28423,28424,28624,28623,-1,28424,28425,28625,28624,-1,28425,28426,28626,28625,-1,28426,28427,28627,28626,-1,28427,28428,28628,28627,-1,28428,28429,28629,28628,-1,28429,28430,28630,28629,-1,28430,28431,28631,28630,-1,28431,28432,28632,28631,-1,28432,28433,28633,28632,-1,28433,28434,28634,28633,-1,28434,28435,28635,28634,-1,28435,28436,28636,28635,-1,28436,28437,28637,28636,-1,28437,28438,28638,28637,-1,28438,28439,28639,28638,-1,28439,28440,28640,28639,-1,28440,28441,28641,28640,-1,28441,28442,28642,28641,-1,28442,28443,28643,28642,-1,28443,28444,28644,28643,-1,28444,28445,28645,28644,-1,28445,28446,28646,28645,-1,28446,28447,28647,28646,-1,28447,28448,28648,28647,-1,28448,28449,28649,28648,-1,28449,28450,28650,28649,-1,28450,28451,28651,28650,-1,28451,28452,28652,28651,-1,28452,28453,28653,28652,-1,28453,28454,28654,28653,-1,28454,28455,28655,28654,-1,28455,28456,28656,28655,-1,28456,28457,28657,28656,-1,28457,28458,28658,28657,-1,28458,28459,28659,28658,-1,28459,28460,28660,28659,-1,28460,28461,28661,28660,-1,28461,28462,28662,28661,-1,28462,28463,28663,28662,-1,28463,28464,28664,28663,-1,28464,28465,28665,28664,-1,28465,28466,28666,28665,-1,28466,28467,28667,28666,-1,28467,28468,28668,28667,-1,28468,28469,28669,28668,-1,28469,28470,28670,28669,-1,28470,28471,28671,28670,-1,28471,28472,28672,28671,-1,28472,28473,28673,28672,-1,28473,28474,28674,28673,-1,28474,28475,28675,28674,-1,28475,28476,28676,28675,-1,28476,28477,28677,28676,-1,28477,28478,28678,28677,-1,28478,28479,28679,28678,-1,28479,28480,28680,28679,-1,28480,28481,28681,28680,-1,28481,28482,28682,28681,-1,28482,28483,28683,28682,-1,28483,28484,28684,28683,-1,28484,28485,28685,28684,-1,28485,28486,28686,28685,-1,28486,28487,28687,28686,-1,28487,28488,28688,28687,-1,28488,28489,28689,28688,-1,28489,28490,28690,28689,-1,28490,28491,28691,28690,-1,28491,28492,28692,28691,-1,28492,28493,28693,28692,-1,28493,28494,28694,28693,-1,28494,28495,28695,28694,-1,28495,28496,28696,28695,-1,28496,28497,28697,28696,-1,28497,28498,28698,28697,-1,28498,28499,28699,28698,-1,28499,28500,28700,28699,-1,28500,28501,28701,28700,-1,28501,28502,28702,28701,-1,28502,28503,28703,28702,-1,28503,28504,28704,28703,-1,28504,28505,28705,28704,-1,28505,28506,28706,28705,-1,28506,28507,28707,28706,-1,28507,28508,28708,28707,-1,28508,28509,28709,28708,-1,28509,28510,28710,28709,-1,28510,28511,28711,28710,-1,28511,28512,28712,28711,-1,28512,28513,28713,28712,-1,28513,28514,28714,28713,-1,28514,28515,28715,28714,-1,28515,28516,28716,28715,-1,28516,28517,28717,28716,-1,28517,28518,28718,28717,-1,28518,28519,28719,28718,-1,28519,28520,28720,28719,-1,28520,28521,28721,28720,-1,28521,28522,28722,28721,-1,28522,28523,28723,28722,-1,28523,28524,28724,28723,-1,28524,28525,28725,28724,-1,28525,28526,28726,28725,-1,28526,28527,28727,28726,-1,28527,28528,28728,28727,-1,28528,28529,28729,28728,-1,28529,28530,28730,28729,-1,28530,28531,28731,28730,-1,28531,28532,28732,28731,-1,28532,28533,28733,28732,-1,28533,28534,28734,28733,-1,28534,28535,28735,28734,-1,28535,28536,28736,28735,-1,28536,28537,28737,28736,-1,28537,28538,28738,28737,-1,28538,28539,28739,28738,-1,28539,28540,28740,28739,-1,28540,28541,28741,28740,-1,28541,28542,28742,28741,-1,28542,28543,28743,28742,-1,28543,28544,28744,28743,-1,28544,28545,28745,28744,-1,28545,28546,28746,28745,-1,28546,28547,28747,28746,-1,28547,28548,28748,28747,-1,28548,28549,28749,28748,-1,28549,28550,28750,28749,-1,28550,28551,28751,28750,-1,28551,28552,28752,28751,-1,28552,28553,28753,28752,-1,28553,28554,28754,28753,-1,28554,28555,28755,28754,-1,28555,28556,28756,28755,-1,28556,28557,28757,28756,-1,28557,28558,28758,28757,-1,28558,28559,28759,28758,-1,28559,28560,28760,28759,-1,28560,28561,28761,28760,-1,28561,28562,28762,28761,-1,28562,28563,28763,28762,-1,28563,28564,28764,28763,-1,28564,28565,28765,28764,-1,28565,28566,28766,28765,-1,28566,28567,28767,28766,-1,28567,28568,28768,28767,-1,28568,28569,28769,28768,-1,28569,28570,28770,28769,-1,28570,28571,28771,28770,-1,28571,28572,28772,28771,-1,28572,28573,28773,28772,-1,28573,28574,28774,28773,-1,28574,28575,28775,28774,-1,28575,28576,28776,28775,-1,28576,28577,28777,28776,-1,28577,28578,28778,28777,-1,28578,28579,28779,28778,-1,28579,28580,28780,28779,-1,28580,28581,28781,28780,-1,28581,28582,28782,28781,-1,28582,28583,28783,28782,-1,28583,28584,28784,28783,-1,28584,28585,28785,28784,-1,28585,28586,28786,28785,-1,28586,28587,28787,28786,-1,28587,28588,28788,28787,-1,28588,28589,28789,28788,-1,28589,28590,28790,28789,-1,28590,28591,28791,28790,-1,28591,28592,28792,28791,-1,28592,28593,28793,28792,-1,28593,28594,28794,28793,-1,28594,28595,28795,28794,-1,28595,28596,28796,28795,-1,28596,28597,28797,28796,-1,28597,28598,28798,28797,-1,28598,28599,28799,28798,-1,28600,28601,28801,28800,-1,28601,28602,28802,28801,-1,28602,28603,28803,28802,-1,28603,28604,28804,28803,-1,28604,28605,28805,28804,-1,28605,28606,28806,28805,-1,28606,28607,28807,28806,-1,28607,28608,28808,28807,-1,28608,28609,28809,28808,-1,28609,28610,28810,28809,-1,28610,28611,28811,28810,-1,28611,28612,28812,28811,-1,28612,28613,28813,28812,-1,28613,28614,28814,28813,-1,28614,28615,28815,28814,-1,28615,28616,28816,28815,-1,28616,28617,28817,28816,-1,28617,28618,28818,28817,-1,28618,28619,28819,28818,-1,28619,28620,28820,28819,-1,28620,28621,28821,28820,-1,28621,28622,28822,28821,-1,28622,28623,28823,28822,-1,28623,28624,28824,28823,-1,28624,28625,28825,28824,-1,28625,28626,28826,28825,-1,28626,28627,28827,28826,-1,28627,28628,28828,28827,-1,28628,28629,28829,28828,-1,28629,28630,28830,28829,-1,28630,28631,28831,28830,-1,28631,28632,28832,28831,-1,28632,28633,28833,28832,-1,28633,28634,28834,28833,-1,28634,28635,28835,28834,-1,28635,28636,28836,28835,-1,28636,28637,28837,28836,-1,28637,28638,28838,28837,-1,28638,28639,28839,28838,-1,28639,28640,28840,28839,-1,28640,28641,28841,28840,-1,28641,28642,28842,28841,-1,28642,28643,28843,28842,-1,28643,28644,28844,28843,-1,28644,28645,28845,28844,-1,28645,28646,28846,28845,-1,28646,28647,28847,28846,-1,28647,28648,28848,28847,-1,28648,28649,28849,28848,-1,28649,28650,28850,28849,-1,28650,28651,28851,28850,-1,28651,28652,28852,28851,-1,28652,28653,28853,28852,-1,28653,28654,28854,28853,-1,28654,28655,28855,28854,-1,28655,28656,28856,28855,-1,28656,28657,28857,28856,-1,28657,28658,28858,28857,-1,28658,28659,28859,28858,-1,28659,28660,28860,28859,-1,28660,28661,28861,28860,-1,28661,28662,28862,28861,-1,28662,28663,28863,28862,-1,28663,28664,28864,28863,-1,28664,28665,28865,28864,-1,28665,28666,28866,28865,-1,28666,28667,28867,28866,-1,28667,28668,28868,28867,-1,28668,28669,28869,28868,-1,28669,28670,28870,28869,-1,28670,28671,28871,28870,-1,28671,28672,28872,28871,-1,28672,28673,28873,28872,-1,28673,28674,28874,28873,-1,28674,28675,28875,28874,-1,28675,28676,28876,28875,-1,28676,28677,28877,28876,-1,28677,28678,28878,28877,-1,28678,28679,28879,28878,-1,28679,28680,28880,28879,-1,28680,28681,28881,28880,-1,28681,28682,28882,28881,-1,28682,28683,28883,28882,-1,28683,28684,28884,28883,-1,28684,28685,28885,28884,-1,28685,28686,28886,28885,-1,28686,28687,28887,28886,-1,28687,28688,28888,28887,-1,28688,28689,28889,28888,-1,28689,28690,28890,28889,-1,28690,28691,28891,28890,-1,28691,28692,28892,28891,-1,28692,28693,28893,28892,-1,28693,28694,28894,28893,-1,28694,28695,28895,28894,-1,28695,28696,28896,28895,-1,28696,28697,28897,28896,-1,28697,28698,28898,28897,-1,28698,28699,28899,28898,-1,28699,28700,28900,28899,-1,28700,28701,28901,28900,-1,28701,28702,28902,28901,-1,28702,28703,28903,28902,-1,28703,28704,28904,28903,-1,28704,28705,28905,28904,-1,28705,28706,28906,28905,-1,28706,28707,28907,28906,-1,28707,28708,28908,28907,-1,28708,28709,28909,28908,-1,28709,28710,28910,28909,-1,28710,28711,28911,28910,-1,28711,28712,28912,28911,-1,28712,28713,28913,28912,-1,28713,28714,28914,28913,-1,28714,28715,28915,28914,-1,28715,28716,28916,28915,-1,28716,28717,28917,28916,-1,28717,28718,28918,28917,-1,28718,28719,28919,28918,-1,28719,28720,28920,28919,-1,28720,28721,28921,28920,-1,28721,28722,28922,28921,-1,28722,28723,28923,28922,-1,28723,28724,28924,28923,-1,28724,28725,28925,28924,-1,28725,28726,28926,28925,-1,28726,28727,28927,28926,-1,28727,28728,28928,28927,-1,28728,28729,28929,28928,-1,28729,28730,28930,28929,-1,28730,28731,28931,28930,-1,28731,28732,28932,28931,-1,28732,28733,28933,28932,-1,28733,28734,28934,28933,-1,28734,28735,28935,28934,-1,28735,28736,28936,28935,-1,28736,28737,28937,28936,-1,28737,28738,28938,28937,-1,28738,28739,28939,28938,-1,28739,28740,28940,28939,-1,28740,28741,28941,28940,-1,28741,28742,28942,28941,-1,28742,28743,28943,28942,-1,28743,28744,28944,28943,-1,28744,28745,28945,28944,-1,28745,28746,28946,28945,-1,28746,28747,28947,28946,-1,28747,28748,28948,28947,-1,28748,28749,28949,28948,-1,28749,28750,28950,28949,-1,28750,28751,28951,28950,-1,28751,28752,28952,28951,-1,28752,28753,28953,28952,-1,28753,28754,28954,28953,-1,28754,28755,28955,28954,-1,28755,28756,28956,28955,-1,28756,28757,28957,28956,-1,28757,28758,28958,28957,-1,28758,28759,28959,28958,-1,28759,28760,28960,28959,-1,28760,28761,28961,28960,-1,28761,28762,28962,28961,-1,28762,28763,28963,28962,-1,28763,28764,28964,28963,-1,28764,28765,28965,28964,-1,28765,28766,28966,28965,-1,28766,28767,28967,28966,-1,28767,28768,28968,28967,-1,28768,28769,28969,28968,-1,28769,28770,28970,28969,-1,28770,28771,28971,28970,-1,28771,28772,28972,28971,-1,28772,28773,28973,28972,-1,28773,28774,28974,28973,-1,28774,28775,28975,28974,-1,28775,28776,28976,28975,-1,28776,28777,28977,28976,-1,28777,28778,28978,28977,-1,28778,28779,28979,28978,-1,28779,28780,28980,28979,-1,28780,28781,28981,28980,-1,28781,28782,28982,28981,-1,28782,28783,28983,28982,-1,28783,28784,28984,28983,-1,28784,28785,28985,28984,-1,28785,28786,28986,28985,-1,28786,28787,28987,28986,-1,28787,28788,28988,28987,-1,28788,28789,28989,28988,-1,28789,28790,28990,28989,-1,28790,28791,28991,28990,-1,28791,28792,28992,28991,-1,28792,28793,28993,28992,-1,28793,28794,28994,28993,-1,28794,28795,28995,28994,-1,28795,28796,28996,28995,-1,28796,28797,28997,28996,-1,28797,28798,28998,28997,-1,28798,28799,28999,28998,-1,28800,28801,29001,29,-1,28801,28802,29002,29001,-1,28802,28803,29003,29002,-1,28803,28804,29004,29003,-1,28804,28805,29005,29004,-1,28805,28806,29006,29005,-1,28806,28807,29007,29006,-1,28807,28808,29008,29007,-1,28808,28809,29009,29008,-1,28809,28810,29010,29009,-1,28810,28811,29011,29010,-1,28811,28812,29012,29011,-1,28812,28813,29013,29012,-1,28813,28814,29014,29013,-1,28814,28815,29015,29014,-1,28815,28816,29016,29015,-1,28816,28817,29017,29016,-1,28817,28818,29018,29017,-1,28818,28819,29019,29018,-1,28819,28820,29020,29019,-1,28820,28821,29021,29020,-1,28821,28822,29022,29021,-1,28822,28823,29023,29022,-1,28823,28824,29024,29023,-1,28824,28825,29025,29024,-1,28825,28826,29026,29025,-1,28826,28827,29027,29026,-1,28827,28828,29028,29027,-1,28828,28829,29029,29028,-1,28829,28830,29030,29029,-1,28830,28831,29031,29030,-1,28831,28832,29032,29031,-1,28832,28833,29033,29032,-1,28833,28834,29034,29033,-1,28834,28835,29035,29034,-1,28835,28836,29036,29035,-1,28836,28837,29037,29036,-1,28837,28838,29038,29037,-1,28838,28839,29039,29038,-1,28839,28840,29040,29039,-1,28840,28841,29041,29040,-1,28841,28842,29042,29041,-1,28842,28843,29043,29042,-1,28843,28844,29044,29043,-1,28844,28845,29045,29044,-1,28845,28846,29046,29045,-1,28846,28847,29047,29046,-1,28847,28848,29048,29047,-1,28848,28849,29049,29048,-1,28849,28850,29050,29049,-1,28850,28851,29051,29050,-1,28851,28852,29052,29051,-1,28852,28853,29053,29052,-1,28853,28854,29054,29053,-1,28854,28855,29055,29054,-1,28855,28856,29056,29055,-1,28856,28857,29057,29056,-1,28857,28858,29058,29057,-1,28858,28859,29059,29058,-1,28859,28860,29060,29059,-1,28860,28861,29061,29060,-1,28861,28862,29062,29061,-1,28862,28863,29063,29062,-1,28863,28864,29064,29063,-1,28864,28865,29065,29064,-1,28865,28866,29066,29065,-1,28866,28867,29067,29066,-1,28867,28868,29068,29067,-1,28868,28869,29069,29068,-1,28869,28870,29070,29069,-1,28870,28871,29071,29070,-1,28871,28872,29072,29071,-1,28872,28873,29073,29072,-1,28873,28874,29074,29073,-1,28874,28875,29075,29074,-1,28875,28876,29076,29075,-1,28876,28877,29077,29076,-1,28877,28878,29078,29077,-1,28878,28879,29079,29078,-1,28879,28880,29080,29079,-1,28880,28881,29081,29080,-1,28881,28882,29082,29081,-1,28882,28883,29083,29082,-1,28883,28884,29084,29083,-1,28884,28885,29085,29084,-1,28885,28886,29086,29085,-1,28886,28887,29087,29086,-1,28887,28888,29088,29087,-1,28888,28889,29089,29088,-1,28889,28890,29090,29089,-1,28890,28891,29091,29090,-1,28891,28892,29092,29091,-1,28892,28893,29093,29092,-1,28893,28894,29094,29093,-1,28894,28895,29095,29094,-1,28895,28896,29096,29095,-1,28896,28897,29097,29096,-1,28897,28898,29098,29097,-1,28898,28899,29099,29098,-1,28899,28900,29100,29099,-1,28900,28901,29101,29100,-1,28901,28902,29102,29101,-1,28902,28903,29103,29102,-1,28903,28904,29104,29103,-1,28904,28905,29105,29104,-1,28905,28906,29106,29105,-1,28906,28907,29107,29106,-1,28907,28908,29108,29107,-1,28908,28909,29109,29108,-1,28909,28910,29110,29109,-1,28910,28911,29111,29110,-1,28911,28912,29112,29111,-1,28912,28913,29113,29112,-1,28913,28914,29114,29113,-1,28914,28915,29115,29114,-1,28915,28916,29116,29115,-1,28916,28917,29117,29116,-1,28917,28918,29118,29117,-1,28918,28919,29119,29118,-1,28919,28920,29120,29119,-1,28920,28921,29121,29120,-1,28921,28922,29122,29121,-1,28922,28923,29123,29122,-1,28923,28924,29124,29123,-1,28924,28925,29125,29124,-1,28925,28926,29126,29125,-1,28926,28927,29127,29126,-1,28927,28928,29128,29127,-1,28928,28929,29129,29128,-1,28929,28930,29130,29129,-1,28930,28931,29131,29130,-1,28931,28932,29132,29131,-1,28932,28933,29133,29132,-1,28933,28934,29134,29133,-1,28934,28935,29135,29134,-1,28935,28936,29136,29135,-1,28936,28937,29137,29136,-1,28937,28938,29138,29137,-1,28938,28939,29139,29138,-1,28939,28940,29140,29139,-1,28940,28941,29141,29140,-1,28941,28942,29142,29141,-1,28942,28943,29143,29142,-1,28943,28944,29144,29143,-1,28944,28945,29145,29144,-1,28945,28946,29146,29145,-1,28946,28947,29147,29146,-1,28947,28948,29148,29147,-1,28948,28949,29149,29148,-1,28949,28950,29150,29149,-1,28950,28951,29151,29150,-1,28951,28952,29152,29151,-1,28952,28953,29153,29152,-1,28953,28954,29154,29153,-1,28954,28955,29155,29154,-1,28955,28956,29156,29155,-1,28956,28957,29157,29156,-1,28957,28958,29158,29157,-1,28958,28959,29159,29158,-1,28959,28960,29160,29159,-1,28960,28961,29161,29160,-1,28961,28962,29162,29161,-1,28962,28963,29163,29162,-1,28963,28964,29164,29163,-1,28964,28965,29165,29164,-1,28965,28966,29166,29165,-1,28966,28967,29167,29166,-1,28967,28968,29168,29167,-1,28968,28969,29169,29168,-1,28969,28970,29170,29169,-1,28970,28971,29171,29170,-1,28971,28972,29172,29171,-1,28972,28973,29173,29172,-1,28973,28974,29174,29173,-1,28974,28975,29175,29174,-1,28975,28976,29176,29175,-1,28976,28977,29177,29176,-1,28977,28978,29178,29177,-1,28978,28979,29179,29178,-1,28979,28980,29180,29179,-1,28980,28981,29181,29180,-1,28981,28982,29182,29181,-1,28982,28983,29183,29182,-1,28983,28984,29184,29183,-1,28984,28985,29185,29184,-1,28985,28986,29186,29185,-1,28986,28987,29187,29186,-1,28987,28988,29188,29187,-1,28988,28989,29189,29188,-1,28989,28990,29190,29189,-1,28990,28991,29191,29190,-1,28991,28992,29192,29191,-1,28992,28993,29193,29192,-1,28993,28994,29194,29193,-1,28994,28995,29195,29194,-1,28995,28996,29196,29195,-1,28996,28997,29197,29196,-1,28997,28998,29198,29197,-1,28998,28999,29199,29198,-1,29,29001,29201,29200,-1,29001,29002,29202,29201,-1,29002,29003,29203,29202,-1,29003,29004,29204,29203,-1,29004,29005,29205,29204,-1,29005,29006,29206,29205,-1,29006,29007,29207,29206,-1,29007,29008,29208,29207,-1,29008,29009,29209,29208,-1,29009,29010,29210,29209,-1,29010,29011,29211,29210,-1,29011,29012,29212,29211,-1,29012,29013,29213,29212,-1,29013,29014,29214,29213,-1,29014,29015,29215,29214,-1,29015,29016,29216,29215,-1,29016,29017,29217,29216,-1,29017,29018,29218,29217,-1,29018,29019,29219,29218,-1,29019,29020,29220,29219,-1,29020,29021,29221,29220,-1,29021,29022,29222,29221,-1,29022,29023,29223,29222,-1,29023,29024,29224,29223,-1,29024,29025,29225,29224,-1,29025,29026,29226,29225,-1,29026,29027,29227,29226,-1,29027,29028,29228,29227,-1,29028,29029,29229,29228,-1,29029,29030,29230,29229,-1,29030,29031,29231,29230,-1,29031,29032,29232,29231,-1,29032,29033,29233,29232,-1,29033,29034,29234,29233,-1,29034,29035,29235,29234,-1,29035,29036,29236,29235,-1,29036,29037,29237,29236,-1,29037,29038,29238,29237,-1,29038,29039,29239,29238,-1,29039,29040,29240,29239,-1,29040,29041,29241,29240,-1,29041,29042,29242,29241,-1,29042,29043,29243,29242,-1,29043,29044,29244,29243,-1,29044,29045,29245,29244,-1,29045,29046,29246,29245,-1,29046,29047,29247,29246,-1,29047,29048,29248,29247,-1,29048,29049,29249,29248,-1,29049,29050,29250,29249,-1,29050,29051,29251,29250,-1,29051,29052,29252,29251,-1,29052,29053,29253,29252,-1,29053,29054,29254,29253,-1,29054,29055,29255,29254,-1,29055,29056,29256,29255,-1,29056,29057,29257,29256,-1,29057,29058,29258,29257,-1,29058,29059,29259,29258,-1,29059,29060,29260,29259,-1,29060,29061,29261,29260,-1,29061,29062,29262,29261,-1,29062,29063,29263,29262,-1,29063,29064,29264,29263,-1,29064,29065,29265,29264,-1,29065,29066,29266,29265,-1,29066,29067,29267,29266,-1,29067,29068,29268,29267,-1,29068,29069,29269,29268,-1,29069,29070,29270,29269,-1,29070,29071,29271,29270,-1,29071,29072,29272,29271,-1,29072,29073,29273,29272,-1,29073,29074,29274,29273,-1,29074,29075,29275,29274,-1,29075,29076,29276,29275,-1,29076,29077,29277,29276,-1,29077,29078,29278,29277,-1,29078,29079,29279,29278,-1,29079,29080,29280,29279,-1,29080,29081,29281,29280,-1,29081,29082,29282,29281,-1,29082,29083,29283,29282,-1,29083,29084,29284,29283,-1,29084,29085,29285,29284,-1,29085,29086,29286,29285,-1,29086,29087,29287,29286,-1,29087,29088,29288,29287,-1,29088,29089,29289,29288,-1,29089,29090,29290,29289,-1,29090,29091,29291,29290,-1,29091,29092,29292,29291,-1,29092,29093,29293,29292,-1,29093,29094,29294,29293,-1,29094,29095,29295,29294,-1,29095,29096,29296,29295,-1,29096,29097,29297,29296,-1,29097,29098,29298,29297,-1,29098,29099,29299,29298,-1,29099,29100,29300,29299,-1,29100,29101,29301,29300,-1,29101,29102,29302,29301,-1,29102,29103,29303,29302,-1,29103,29104,29304,29303,-1,29104,29105,29305,29304,-1,29105,29106,29306,29305,-1,29106,29107,29307,29306,-1,29107,29108,29308,29307,-1,29108,29109,29309,29308,-1,29109,29110,29310,29309,-1,29110,29111,29311,29310,-1,29111,29112,29312,29311,-1,29112,29113,29313,29312,-1,29113,29114,29314,29313,-1,29114,29115,29315,29314,-1,29115,29116,29316,29315,-1,29116,29117,29317,29316,-1,29117,29118,29318,29317,-1,29118,29119,29319,29318,-1,29119,29120,29320,29319,-1,29120,29121,29321,29320,-1,29121,29122,29322,29321,-1,29122,29123,29323,29322,-1,29123,29124,29324,29323,-1,29124,29125,29325,29324,-1,29125,29126,29326,29325,-1,29126,29127,29327,29326,-1,29127,29128,29328,29327,-1,29128,29129,29329,29328,-1,29129,29130,29330,29329,-1,29130,29131,29331,29330,-1,29131,29132,29332,29331,-1,29132,29133,29333,29332,-1,29133,29134,29334,29333,-1,29134,29135,29335,29334,-1,29135,29136,29336,29335,-1,29136,29137,29337,29336,-1,29137,29138,29338,29337,-1,29138,29139,29339,29338,-1,29139,29140,29340,29339,-1,29140,29141,29341,29340,-1,29141,29142,29342,29341,-1,29142,29143,29343,29342,-1,29143,29144,29344,29343,-1,29144,29145,29345,29344,-1,29145,29146,29346,29345,-1,29146,29147,29347,29346,-1,29147,29148,29348,29347,-1,29148,29149,29349,29348,-1,29149,29150,29350,29349,-1,29150,29151,29351,29350,-1,29151,29152,29352,29351,-1,29152,29153,29353,29352,-1,29153,29154,29354,29353,-1,29154,29155,29355,29354,-1,29155,29156,29356,29355,-1,29156,29157,29357,29356,-1,29157,29158,29358,29357,-1,29158,29159,29359,29358,-1,29159,29160,29360,29359,-1,29160,29161,29361,29360,-1,29161,29162,29362,29361,-1,29162,29163,29363,29362,-1,29163,29164,29364,29363,-1,29164,29165,29365,29364,-1,29165,29166,29366,29365,-1,29166,29167,29367,29366,-1,29167,29168,29368,29367,-1,29168,29169,29369,29368,-1,29169,29170,29370,29369,-1,29170,29171,29371,29370,-1,29171,29172,29372,29371,-1,29172,29173,29373,29372,-1,29173,29174,29374,29373,-1,29174,29175,29375,29374,-1,29175,29176,29376,29375,-1,29176,29177,29377,29376,-1,29177,29178,29378,29377,-1,29178,29179,29379,29378,-1,29179,29180,29380,29379,-1,29180,29181,29381,29380,-1,29181,29182,29382,29381,-1,29182,29183,29383,29382,-1,29183,29184,29384,29383,-1,29184,29185,29385,29384,-1,29185,29186,29386,29385,-1,29186,29187,29387,29386,-1,29187,29188,29388,29387,-1,29188,29189,29389,29388,-1,29189,29190,29390,29389,-1,29190,29191,29391,29390,-1,29191,29192,29392,29391,-1,29192,29193,29393,29392,-1,29193,29194,29394,29393,-1,29194,29195,29395,29394,-1,29195,29196,29396,29395,-1,29196,29197,29397,29396,-1,29197,29198,29398,29397,-1,29198,29199,29399,29398,-1,29200,29201,29401,29400,-1,29201,29202,29402,29401,-1,29202,29203,29403,29402,-1,29203,29204,29404,29403,-1,29204,29205,29405,29404,-1,29205,29206,29406,29405,-1,29206,29207,29407,29406,-1,29207,29208,29408,29407,-1,29208,29209,29409,29408,-1,29209,29210,29410,29409,-1,29210,29211,29411,29410,-1,29211,29212,29412,29411,-1,29212,29213,29413,29412,-1,29213,29214,29414,29413,-1,29214,29215,29415,29414,-1,29215,29216,29416,29415,-1,29216,29217,29417,29416,-1,29217,29218,29418,29417,-1,29218,29219,29419,29418,-1,29219,29220,29420,29419,-1,29220,29221,29421,29420,-1,29221,29222,29422,29421,-1,29222,29223,29423,29422,-1,29223,29224,29424,29423,-1,29224,29225,29425,29424,-1,29225,29226,29426,29425,-1,29226,29227,29427,29426,-1,29227,29228,29428,29427,-1,29228,29229,29429,29428,-1,29229,29230,29430,29429,-1,29230,29231,29431,29430,-1,29231,29232,29432,29431,-1,29232,29233,29433,29432,-1,29233,29234,29434,29433,-1,29234,29235,29435,29434,-1,29235,29236,29436,29435,-1,29236,29237,29437,29436,-1,29237,29238,29438,29437,-1,29238,29239,29439,29438,-1,29239,29240,29440,29439,-1,29240,29241,29441,29440,-1,29241,29242,29442,29441,-1,29242,29243,29443,29442,-1,29243,29244,29444,29443,-1,29244,29245,29445,29444,-1,29245,29246,29446,29445,-1,29246,29247,29447,29446,-1,29247,29248,29448,29447,-1,29248,29249,29449,29448,-1,29249,29250,29450,29449,-1,29250,29251,29451,29450,-1,29251,29252,29452,29451,-1,29252,29253,29453,29452,-1,29253,29254,29454,29453,-1,29254,29255,29455,29454,-1,29255,29256,29456,29455,-1,29256,29257,29457,29456,-1,29257,29258,29458,29457,-1,29258,29259,29459,29458,-1,29259,29260,29460,29459,-1,29260,29261,29461,29460,-1,29261,29262,29462,29461,-1,29262,29263,29463,29462,-1,29263,29264,29464,29463,-1,29264,29265,29465,29464,-1,29265,29266,29466,29465,-1,29266,29267,29467,29466,-1,29267,29268,29468,29467,-1,29268,29269,29469,29468,-1,29269,29270,29470,29469,-1,29270,29271,29471,29470,-1,29271,29272,29472,29471,-1,29272,29273,29473,29472,-1,29273,29274,29474,29473,-1,29274,29275,29475,29474,-1,29275,29276,29476,29475,-1,29276,29277,29477,29476,-1,29277,29278,29478,29477,-1,29278,29279,29479,29478,-1,29279,29280,29480,29479,-1,29280,29281,29481,29480,-1,29281,29282,29482,29481,-1,29282,29283,29483,29482,-1,29283,29284,29484,29483,-1,29284,29285,29485,29484,-1,29285,29286,29486,29485,-1,29286,29287,29487,29486,-1,29287,29288,29488,29487,-1,29288,29289,29489,29488,-1,29289,29290,29490,29489,-1,29290,29291,29491,29490,-1,29291,29292,29492,29491,-1,29292,29293,29493,29492,-1,29293,29294,29494,29493,-1,29294,29295,29495,29494,-1,29295,29296,29496,29495,-1,29296,29297,29497,29496,-1,29297,29298,29498,29497,-1,29298,29299,29499,29498,-1,29299,29300,29500,29499,-1,29300,29301,29501,29500,-1,29301,29302,29502,29501,-1,29302,29303,29503,29502,-1,29303,29304,29504,29503,-1,29304,29305,29505,29504,-1,29305,29306,29506,29505,-1,29306,29307,29507,29506,-1,29307,29308,29508,29507,-1,29308,29309,29509,29508,-1,29309,29310,29510,29509,-1,29310,29311,29511,29510,-1,29311,29312,29512,29511,-1,29312,29313,29513,29512,-1,29313,29314,29514,29513,-1,29314,29315,29515,29514,-1,29315,29316,29516,29515,-1,29316,29317,29517,29516,-1,29317,29318,29518,29517,-1,29318,29319,29519,29518,-1,29319,29320,29520,29519,-1,29320,29321,29521,29520,-1,29321,29322,29522,29521,-1,29322,29323,29523,29522,-1,29323,29324,29524,29523,-1,29324,29325,29525,29524,-1,29325,29326,29526,29525,-1,29326,29327,29527,29526,-1,29327,29328,29528,29527,-1,29328,29329,29529,29528,-1,29329,29330,29530,29529,-1,29330,29331,29531,29530,-1,29331,29332,29532,29531,-1,29332,29333,29533,29532,-1,29333,29334,29534,29533,-1,29334,29335,29535,29534,-1,29335,29336,29536,29535,-1,29336,29337,29537,29536,-1,29337,29338,29538,29537,-1,29338,29339,29539,29538,-1,29339,29340,29540,29539,-1,29340,29341,29541,29540,-1,29341,29342,29542,29541,-1,29342,29343,29543,29542,-1,29343,29344,29544,29543,-1,29344,29345,29545,29544,-1,29345,29346,29546,29545,-1,29346,29347,29547,29546,-1,29347,29348,29548,29547,-1,29348,29349,29549,29548,-1,29349,29350,29550,29549,-1,29350,29351,29551,29550,-1,29351,29352,29552,29551,-1,29352,29353,29553,29552,-1,29353,29354,29554,29553,-1,29354,29355,29555,29554,-1,29355,29356,29556,29555,-1,29356,29357,29557,29556,-1,29357,29358,29558,29557,-1,29358,29359,29559,29558,-1,29359,29360,29560,29559,-1,29360,29361,29561,29560,-1,29361,29362,29562,29561,-1,29362,29363,29563,29562,-1,29363,29364,29564,29563,-1,29364,29365,29565,29564,-1,29365,29366,29566,29565,-1,29366,29367,29567,29566,-1,29367,29368,29568,29567,-1,29368,29369,29569,29568,-1,29369,29370,29570,29569,-1,29370,29371,29571,29570,-1,29371,29372,29572,29571,-1,29372,29373,29573,29572,-1,29373,29374,29574,29573,-1,29374,29375,29575,29574,-1,29375,29376,29576,29575,-1,29376,29377,29577,29576,-1,29377,29378,29578,29577,-1,29378,29379,29579,29578,-1,29379,29380,29580,29579,-1,29380,29381,29581,29580,-1,29381,29382,29582,29581,-1,29382,29383,29583,29582,-1,29383,29384,29584,29583,-1,29384,29385,29585,29584,-1,29385,29386,29586,29585,-1,29386,29387,29587,29586,-1,29387,29388,29588,29587,-1,29388,29389,29589,29588,-1,29389,29390,29590,29589,-1,29390,29391,29591,29590,-1,29391,29392,29592,29591,-1,29392,29393,29593,29592,-1,29393,29394,29594,29593,-1,29394,29395,29595,29594,-1,29395,29396,29596,29595,-1,29396,29397,29597,29596,-1,29397,29398,29598,29597,-1,29398,29399,29599,29598,-1,29400,29401,29601,29600,-1,29401,29402,29602,29601,-1,29402,29403,29603,29602,-1,29403,29404,29604,29603,-1,29404,29405,29605,29604,-1,29405,29406,29606,29605,-1,29406,29407,29607,29606,-1,29407,29408,29608,29607,-1,29408,29409,29609,29608,-1,29409,29410,29610,29609,-1,29410,29411,29611,29610,-1,29411,29412,29612,29611,-1,29412,29413,29613,29612,-1,29413,29414,29614,29613,-1,29414,29415,29615,29614,-1,29415,29416,29616,29615,-1,29416,29417,29617,29616,-1,29417,29418,29618,29617,-1,29418,29419,29619,29618,-1,29419,29420,29620,29619,-1,29420,29421,29621,29620,-1,29421,29422,29622,29621,-1,29422,29423,29623,29622,-1,29423,29424,29624,29623,-1,29424,29425,29625,29624,-1,29425,29426,29626,29625,-1,29426,29427,29627,29626,-1,29427,29428,29628,29627,-1,29428,29429,29629,29628,-1,29429,29430,29630,29629,-1,29430,29431,29631,29630,-1,29431,29432,29632,29631,-1,29432,29433,29633,29632,-1,29433,29434,29634,29633,-1,29434,29435,29635,29634,-1,29435,29436,29636,29635,-1,29436,29437,29637,29636,-1,29437,29438,29638,29637,-1,29438,29439,29639,29638,-1,29439,29440,29640,29639,-1,29440,29441,29641,29640,-1,29441,29442,29642,29641,-1,29442,29443,29643,29642,-1,29443,29444,29644,29643,-1,29444,29445,29645,29644,-1,29445,29446,29646,29645,-1,29446,29447,29647,29646,-1,29447,29448,29648,29647,-1,29448,29449,29649,29648,-1,29449,29450,29650,29649,-1,29450,29451,29651,29650,-1,29451,29452,29652,29651,-1,29452,29453,29653,29652,-1,29453,29454,29654,29653,-1,29454,29455,29655,29654,-1,29455,29456,29656,29655,-1,29456,29457,29657,29656,-1,29457,29458,29658,29657,-1,29458,29459,29659,29658,-1,29459,29460,29660,29659,-1,29460,29461,29661,29660,-1,29461,29462,29662,29661,-1,29462,29463,29663,29662,-1,29463,29464,29664,29663,-1,29464,29465,29665,29664,-1,29465,29466,29666,29665,-1,29466,29467,29667,29666,-1,29467,29468,29668,29667,-1,29468,29469,29669,29668,-1,29469,29470,29670,29669,-1,29470,29471,29671,29670,-1,29471,29472,29672,29671,-1,29472,29473,29673,29672,-1,29473,29474,29674,29673,-1,29474,29475,29675,29674,-1,29475,29476,29676,29675,-1,29476,29477,29677,29676,-1,29477,29478,29678,29677,-1,29478,29479,29679,29678,-1,29479,29480,29680,29679,-1,29480,29481,29681,29680,-1,29481,29482,29682,29681,-1,29482,29483,29683,29682,-1,29483,29484,29684,29683,-1,29484,29485,29685,29684,-1,29485,29486,29686,29685,-1,29486,29487,29687,29686,-1,29487,29488,29688,29687,-1,29488,29489,29689,29688,-1,29489,29490,29690,29689,-1,29490,29491,29691,29690,-1,29491,29492,29692,29691,-1,29492,29493,29693,29692,-1,29493,29494,29694,29693,-1,29494,29495,29695,29694,-1,29495,29496,29696,29695,-1,29496,29497,29697,29696,-1,29497,29498,29698,29697,-1,29498,29499,29699,29698,-1,29499,29500,29700,29699,-1,29500,29501,29701,29700,-1,29501,29502,29702,29701,-1,29502,29503,29703,29702,-1,29503,29504,29704,29703,-1,29504,29505,29705,29704,-1,29505,29506,29706,29705,-1,29506,29507,29707,29706,-1,29507,29508,29708,29707,-1,29508,29509,29709,29708,-1,29509,29510,29710,29709,-1,29510,29511,29711,29710,-1,29511,29512,29712,29711,-1,29512,29513,29713,29712,-1,29513,29514,29714,29713,-1,29514,29515,29715,29714,-1,29515,29516,29716,29715,-1,29516,29517,29717,29716,-1,29517,29518,29718,29717,-1,29518,29519,29719,29718,-1,29519,29520,29720,29719,-1,29520,29521,29721,29720,-1,29521,29522,29722,29721,-1,29522,29523,29723,29722,-1,29523,29524,29724,29723,-1,29524,29525,29725,29724,-1,29525,29526,29726,29725,-1,29526,29527,29727,29726,-1,29527,29528,29728,29727,-1,29528,29529,29729,29728,-1,29529,29530,29730,29729,-1,29530,29531,29731,29730,-1,29531,29532,29732,29731,-1,29532,29533,29733,29732,-1,29533,29534,29734,29733,-1,29534,29535,29735,29734,-1,29535,29536,29736,29735,-1,29536,29537,29737,29736,-1,29537,29538,29738,29737,-1,29538,29539,29739,29738,-1,29539,29540,29740,29739,-1,29540,29541,29741,29740,-1,29541,29542,29742,29741,-1,29542,29543,29743,29742,-1,29543,29544,29744,29743,-1,29544,29545,29745,29744,-1,29545,29546,29746,29745,-1,29546,29547,29747,29746,-1,29547,29548,29748,29747,-1,29548,29549,29749,29748,-1,29549,29550,29750,29749,-1,29550,29551,29751,29750,-1,29551,29552,29752,29751,-1,29552,29553,29753,29752,-1,29553,29554,29754,29753,-1,29554,29555,29755,29754,-1,29555,29556,29756,29755,-1,29556,29557,29757,29756,-1,29557,29558,29758,29757,-1,29558,29559,29759,29758,-1,29559,29560,29760,29759,-1,29560,29561,29761,29760,-1,29561,29562,29762,29761,-1,29562,29563,29763,29762,-1,29563,29564,29764,29763,-1,29564,29565,29765,29764,-1,29565,29566,29766,29765,-1,29566,29567,29767,29766,-1,29567,29568,29768,29767,-1,29568,29569,29769,29768,-1,29569,29570,29770,29769,-1,29570,29571,29771,29770,-1,29571,29572,29772,29771,-1,29572,29573,29773,29772,-1,29573,29574,29774,29773,-1,29574,29575,29775,29774,-1,29575,29576,29776,29775,-1,29576,29577,29777,29776,-1,29577,29578,29778,29777,-1,29578,29579,29779,29778,-1,29579,29580,29780,29779,-1,29580,29581,29781,29780,-1,29581,29582,29782,29781,-1,29582,29583,29783,29782,-1,29583,29584,29784,29783,-1,29584,29585,29785,29784,-1,29585,29586,29786,29785,-1,29586,29587,29787,29786,-1,29587,29588,29788,29787,-1,29588,29589,29789,29788,-1,29589,29590,29790,29789,-1,29590,29591,29791,29790,-1,29591,29592,29792,29791,-1,29592,29593,29793,29792,-1,29593,29594,29794,29793,-1,29594,29595,29795,29794,-1,29595,29596,29796,29795,-1,29596,29597,29797,29796,-1,29597,29598,29798,29797,-1,29598,29599,29799,29798,-1,29600,29601,29801,29800,-1,29601,29602,29802,29801,-1,29602,29603,29803,29802,-1,29603,29604,29804,29803,-1,29604,29605,29805,29804,-1,29605,29606,29806,29805,-1,29606,29607,29807,29806,-1,29607,29608,29808,29807,-1,29608,29609,29809,29808,-1,29609,29610,29810,29809,-1,29610,29611,29811,29810,-1,29611,29612,29812,29811,-1,29612,29613,29813,29812,-1,29613,29614,29814,29813,-1,29614,29615,29815,29814,-1,29615,29616,29816,29815,-1,29616,29617,29817,29816,-1,29617,29618,29818,29817,-1,29618,29619,29819,29818,-1,29619,29620,29820,29819,-1,29620,29621,29821,29820,-1,29621,29622,29822,29821,-1,29622,29623,29823,29822,-1,29623,29624,29824,29823,-1,29624,29625,29825,29824,-1,29625,29626,29826,29825,-1,29626,29627,29827,29826,-1,29627,29628,29828,29827,-1,29628,29629,29829,29828,-1,29629,29630,29830,29829,-1,29630,29631,29831,29830,-1,29631,29632,29832,29831,-1,29632,29633,29833,29832,-1,29633,29634,29834,29833,-1,29634,29635,29835,29834,-1,29635,29636,29836,29835,-1,29636,29637,29837,29836,-1,29637,29638,29838,29837,-1,29638,29639,29839,29838,-1,29639,29640,29840,29839,-1,29640,29641,29841,29840,-1,29641,29642,29842,29841,-1,29642,29643,29843,29842,-1,29643,29644,29844,29843,-1,29644,29645,29845,29844,-1,29645,29646,29846,29845,-1,29646,29647,29847,29846,-1,29647,29648,29848,29847,-1,29648,29649,29849,29848,-1,29649,29650,29850,29849,-1,29650,29651,29851,29850,-1,29651,29652,29852,29851,-1,29652,29653,29853,29852,-1,29653,29654,29854,29853,-1,29654,29655,29855,29854,-1,29655,29656,29856,29855,-1,29656,29657,29857,29856,-1,29657,29658,29858,29857,-1,29658,29659,29859,29858,-1,29659,29660,29860,29859,-1,29660,29661,29861,29860,-1,29661,29662,29862,29861,-1,29662,29663,29863,29862,-1,29663,29664,29864,29863,-1,29664,29665,29865,29864,-1,29665,29666,29866,29865,-1,29666,29667,29867,29866,-1,29667,29668,29868,29867,-1,29668,29669,29869,29868,-1,29669,29670,29870,29869,-1,29670,29671,29871,29870,-1,29671,29672,29872,29871,-1,29672,29673,29873,29872,-1,29673,29674,29874,29873,-1,29674,29675,29875,29874,-1,29675,29676,29876,29875,-1,29676,29677,29877,29876,-1,29677,29678,29878,29877,-1,29678,29679,29879,29878,-1,29679,29680,29880,29879,-1,29680,29681,29881,29880,-1,29681,29682,29882,29881,-1,29682,29683,29883,29882,-1,29683,29684,29884,29883,-1,29684,29685,29885,29884,-1,29685,29686,29886,29885,-1,29686,29687,29887,29886,-1,29687,29688,29888,29887,-1,29688,29689,29889,29888,-1,29689,29690,29890,29889,-1,29690,29691,29891,29890,-1,29691,29692,29892,29891,-1,29692,29693,29893,29892,-1,29693,29694,29894,29893,-1,29694,29695,29895,29894,-1,29695,29696,29896,29895,-1,29696,29697,29897,29896,-1,29697,29698,29898,29897,-1,29698,29699,29899,29898,-1,29699,29700,29900,29899,-1,29700,29701,29901,29900,-1,29701,29702,29902,29901,-1,29702,29703,29903,29902,-1,29703,29704,29904,29903,-1,29704,29705,29905,29904,-1,29705,29706,29906,29905,-1,29706,29707,29907,29906,-1,29707,29708,29908,29907,-1,29708,29709,29909,29908,-1,29709,29710,29910,29909,-1,29710,29711,29911,29910,-1,29711,29712,29912,29911,-1,29712,29713,29913,29912,-1,29713,29714,29914,29913,-1,29714,29715,29915,29914,-1,29715,29716,29916,29915,-1,29716,29717,29917,29916,-1,29717,29718,29918,29917,-1,29718,29719,29919,29918,-1,29719,29720,29920,29919,-1,29720,29721,29921,29920,-1,29721,29722,29922,29921,-1,29722,29723,29923,29922,-1,29723,29724,29924,29923,-1,29724,29725,29925,29924,-1,29725,29726,29926,29925,-1,29726,29727,29927,29926,-1,29727,29728,29928,29927,-1,29728,29729,29929,29928,-1,29729,29730,29930,29929,-1,29730,29731,29931,29930,-1,29731,29732,29932,29931,-1,29732,29733,29933,29932,-1,29733,29734,29934,29933,-1,29734,29735,29935,29934,-1,29735,29736,29936,29935,-1,29736,29737,29937,29936,-1,29737,29738,29938,29937,-1,29738,29739,29939,29938,-1,29739,29740,29940,29939,-1,29740,29741,29941,29940,-1,29741,29742,29942,29941,-1,29742,29743,29943,29942,-1,29743,29744,29944,29943,-1,29744,29745,29945,29944,-1,29745,29746,29946,29945,-1,29746,29747,29947,29946,-1,29747,29748,29948,29947,-1,29748,29749,29949,29948,-1,29749,29750,29950,29949,-1,29750,29751,29951,29950,-1,29751,29752,29952,29951,-1,29752,29753,29953,29952,-1,29753,29754,29954,29953,-1,29754,29755,29955,29954,-1,29755,29756,29956,29955,-1,29756,29757,29957,29956,-1,29757,29758,29958,29957,-1,29758,29759,29959,29958,-1,29759,29760,29960,29959,-1,29760,29761,29961,29960,-1,29761,29762,29962,29961,-1,29762,29763,29963,29962,-1,29763,29764,29964,29963,-1,29764,29765,29965,29964,-1,29765,29766,29966,29965,-1,29766,29767,29967,29966,-1,29767,29768,29968,29967,-1,29768,29769,29969,29968,-1,29769,29770,29970,29969,-1,29770,29771,29971,29970,-1,29771,29772,29972,29971,-1,29772,29773,29973,29972,-1,29773,29774,29974,29973,-1,29774,29775,29975,29974,-1,29775,29776,29976,29975,-1,29776,29777,29977,29976,-1,29777,29778,29978,29977,-1,29778,29779,29979,29978,-1,29779,29780,29980,29979,-1,29780,29781,29981,29980,-1,29781,29782,29982,29981,-1,29782,29783,29983,29982,-1,29783,29784,29984,29983,-1,29784,29785,29985,29984,-1,29785,29786,29986,29985,-1,29786,29787,29987,29986,-1,29787,29788,29988,29987,-1,29788,29789,29989,29988,-1,29789,29790,29990,29989,-1,29790,29791,29991,29990,-1,29791,29792,29992,29991,-1,29792,29793,29993,29992,-1,29793,29794,29994,29993,-1,29794,29795,29995,29994,-1,29795,29796,29996,29995,-1,29796,29797,29997,29996,-1,29797,29798,29998,29997,-1,29798,29799,29999,29998,-1,29800,29801,30001,3,-1,29801,29802,30002,30001,-1,29802,29803,30003,30002,-1,29803,29804,30004,30003,-1,29804,29805,30005,30004,-1,29805,29806,30006,30005,-1,29806,29807,30007,30006,-1,29807,29808,30008,30007,-1,29808,29809,30009,30008,-1,29809,29810,30010,30009,-1,29810,29811,30011,30010,-1,29811,29812,30012,30011,-1,29812,29813,30013,30012,-1,29813,29814,30014,30013,-1,29814,29815,30015,30014,-1,29815,29816,30016,30015,-1,29816,29817,30017,30016,-1,29817,29818,30018,30017,-1,29818,29819,30019,30018,-1,29819,29820,30020,30019,-1,29820,29821,30021,30020,-1,29821,29822,30022,30021,-1,29822,29823,30023,30022,-1,29823,29824,30024,30023,-1,29824,29825,30025,30024,-1,29825,29826,30026,30025,-1,29826,29827,30027,30026,-1,29827,29828,30028,30027,-1,29828,29829,30029,30028,-1,29829,29830,30030,30029,-1,29830,29831,30031,30030,-1,29831,29832,30032,30031,-1,29832,29833,30033,30032,-1,29833,29834,30034,30033,-1,29834,29835,30035,30034,-1,29835,29836,30036,30035,-1,29836,29837,30037,30036,-1,29837,29838,30038,30037,-1,29838,29839,30039,30038,-1,29839,29840,30040,30039,-1,29840,29841,30041,30040,-1,29841,29842,30042,30041,-1,29842,29843,30043,30042,-1,29843,29844,30044,30043,-1,29844,29845,30045,30044,-1,29845,29846,30046,30045,-1,29846,29847,30047,30046,-1,29847,29848,30048,30047,-1,29848,29849,30049,30048,-1,29849,29850,30050,30049,-1,29850,29851,30051,30050,-1,29851,29852,30052,30051,-1,29852,29853,30053,30052,-1,29853,29854,30054,30053,-1,29854,29855,30055,30054,-1,29855,29856,30056,30055,-1,29856,29857,30057,30056,-1,29857,29858,30058,30057,-1,29858,29859,30059,30058,-1,29859,29860,30060,30059,-1,29860,29861,30061,30060,-1,29861,29862,30062,30061,-1,29862,29863,30063,30062,-1,29863,29864,30064,30063,-1,29864,29865,30065,30064,-1,29865,29866,30066,30065,-1,29866,29867,30067,30066,-1,29867,29868,30068,30067,-1,29868,29869,30069,30068,-1,29869,29870,30070,30069,-1,29870,29871,30071,30070,-1,29871,29872,30072,30071,-1,29872,29873,30073,30072,-1,29873,29874,30074,30073,-1,29874,29875,30075,30074,-1,29875,29876,30076,30075,-1,29876,29877,30077,30076,-1,29877,29878,30078,30077,-1,29878,29879,30079,30078,-1,29879,29880,30080,30079,-1,29880,29881,30081,30080,-1,29881,29882,30082,30081,-1,29882,29883,30083,30082,-1,29883,29884,30084,30083,-1,29884,29885,30085,30084,-1,29885,29886,30086,30085,-1,29886,29887,30087,30086,-1,29887,29888,30088,30087,-1,29888,29889,30089,30088,-1,29889,29890,30090,30089,-1,29890,29891,30091,30090,-1,29891,29892,30092,30091,-1,29892,29893,30093,30092,-1,29893,29894,30094,30093,-1,29894,29895,30095,30094,-1,29895,29896,30096,30095,-1,29896,29897,30097,30096,-1,29897,29898,30098,30097,-1,29898,29899,30099,30098,-1,29899,29900,30100,30099,-1,29900,29901,30101,30100,-1,29901,29902,30102,30101,-1,29902,29903,30103,30102,-1,29903,29904,30104,30103,-1,29904,29905,30105,30104,-1,29905,29906,30106,30105,-1,29906,29907,30107,30106,-1,29907,29908,30108,30107,-1,29908,29909,30109,30108,-1,29909,29910,30110,30109,-1,29910,29911,30111,30110,-1,29911,29912,30112,30111,-1,29912,29913,30113,30112,-1,29913,29914,30114,30113,-1,29914,29915,30115,30114,-1,29915,29916,30116,30115,-1,29916,29917,30117,30116,-1,29917,29918,30118,30117,-1,29918,29919,30119,30118,-1,29919,29920,30120,30119,-1,29920,29921,30121,30120,-1,29921,29922,30122,30121,-1,29922,29923,30123,30122,-1,29923,29924,30124,30123,-1,29924,29925,30125,30124,-1,29925,29926,30126,30125,-1,29926,29927,30127,30126,-1,29927,29928,30128,30127,-1,29928,29929,30129,30128,-1,29929,29930,30130,30129,-1,29930,29931,30131,30130,-1,29931,29932,30132,30131,-1,29932,29933,30133,30132,-1,29933,29934,30134,30133,-1,29934,29935,30135,30134,-1,29935,29936,30136,30135,-1,29936,29937,30137,30136,-1,29937,29938,30138,30137,-1,29938,29939,30139,30138,-1,29939,29940,30140,30139,-1,29940,29941,30141,30140,-1,29941,29942,30142,30141,-1,29942,29943,30143,30142,-1,29943,29944,30144,30143,-1,29944,29945,30145,30144,-1,29945,29946,30146,30145,-1,29946,29947,30147,30146,-1,29947,29948,30148,30147,-1,29948,29949,30149,30148,-1,29949,29950,30150,30149,-1,29950,29951,30151,30150,-1,29951,29952,30152,30151,-1,29952,29953,30153,30152,-1,29953,29954,30154,30153,-1,29954,29955,30155,30154,-1,29955,29956,30156,30155,-1,29956,29957,30157,30156,-1,29957,29958,30158,30157,-1,29958,29959,30159,30158,-1,29959,29960,30160,30159,-1,29960,29961,30161,30160,-1,29961,29962,30162,30161,-1,29962,29963,30163,30162,-1,29963,29964,30164,30163,-1,29964,29965,30165,30164,-1,29965,29966,30166,30165,-1,29966,29967,30167,30166,-1,29967,29968,30168,30167,-1,29968,29969,30169,30168,-1,29969,29970,30170,30169,-1,29970,29971,30171,30170,-1,29971,29972,30172,30171,-1,29972,29973,30173,30172,-1,29973,29974,30174,30173,-1,29974,29975,30175,30174,-1,29975,29976,30176,30175,-1,29976,29977,30177,30176,-1,29977,29978,30178,30177,-1,29978,29979,30179,30178,-1,29979,29980,30180,30179,-1,29980,29981,30181,30180,-1,29981,29982,30182,30181,-1,29982,29983,30183,30182,-1,29983,29984,30184,30183,-1,29984,29985,30185,30184,-1,29985,29986,30186,30185,-1,29986,29987,30187,30186,-1,29987,29988,30188,30187,-1,29988,29989,30189,30188,-1,29989,29990,30190,30189,-1,29990,29991,30191,30190,-1,29991,29992,30192,30191,-1,29992,29993,30193,30192,-1,29993,29994,30194,30193,-1,29994,29995,30195,30194,-1,29995,29996,30196,30195,-1,29996,29997,30197,30196,-1,29997,29998,30198,30197,-1,29998,29999,30199,30198,-1,3,30001,30201,30200,-1,30001,30002,30202,30201,-1,30002,30003,30203,30202,-1,30003,30004,30204,30203,-1,30004,30005,30205,30204,-1,30005,30006,30206,30205,-1,30006,30007,30207,30206,-1,30007,30008,30208,30207,-1,30008,30009,30209,30208,-1,30009,30010,30210,30209,-1,30010,30011,30211,30210,-1,30011,30012,30212,30211,-1,30012,30013,30213,30212,-1,30013,30014,30214,30213,-1,30014,30015,30215,30214,-1,30015,30016,30216,30215,-1,30016,30017,30217,30216,-1,30017,30018,30218,30217,-1,30018,30019,30219,30218,-1,30019,30020,30220,30219,-1,30020,30021,30221,30220,-1,30021,30022,30222,30221,-1,30022,30023,30223,30222,-1,30023,30024,30224,30223,-1,30024,30025,30225,30224,-1,30025,30026,30226,30225,-1,30026,30027,30227,30226,-1,30027,30028,30228,30227,-1,30028,30029,30229,30228,-1,30029,30030,30230,30229,-1,30030,30031,30231,30230,-1,30031,30032,30232,30231,-1,30032,30033,30233,30232,-1,30033,30034,30234,30233,-1,30034,30035,30235,30234,-1,30035,30036,30236,30235,-1,30036,30037,30237,30236,-1,30037,30038,30238,30237,-1,30038,30039,30239,30238,-1,30039,30040,30240,30239,-1,30040,30041,30241,30240,-1,30041,30042,30242,30241,-1,30042,30043,30243,30242,-1,30043,30044,30244,30243,-1,30044,30045,30245,30244,-1,30045,30046,30246,30245,-1,30046,30047,30247,30246,-1,30047,30048,30248,30247,-1,30048,30049,30249,30248,-1,30049,30050,30250,30249,-1,30050,30051,30251,30250,-1,30051,30052,30252,30251,-1,30052,30053,30253,30252,-1,30053,30054,30254,30253,-1,30054,30055,30255,30254,-1,30055,30056,30256,30255,-1,30056,30057,30257,30256,-1,30057,30058,30258,30257,-1,30058,30059,30259,30258,-1,30059,30060,30260,30259,-1,30060,30061,30261,30260,-1,30061,30062,30262,30261,-1,30062,30063,30263,30262,-1,30063,30064,30264,30263,-1,30064,30065,30265,30264,-1,30065,30066,30266,30265,-1,30066,30067,30267,30266,-1,30067,30068,30268,30267,-1,30068,30069,30269,30268,-1,30069,30070,30270,30269,-1,30070,30071,30271,30270,-1,30071,30072,30272,30271,-1,30072,30073,30273,30272,-1,30073,30074,30274,30273,-1,30074,30075,30275,30274,-1,30075,30076,30276,30275,-1,30076,30077,30277,30276,-1,30077,30078,30278,30277,-1,30078,30079,30279,30278,-1,30079,30080,30280,30279,-1,30080,30081,30281,30280,-1,30081,30082,30282,30281,-1,30082,30083,30283,30282,-1,30083,30084,30284,30283,-1,30084,30085,30285,30284,-1,30085,30086,30286,30285,-1,30086,30087,30287,30286,-1,30087,30088,30288,30287,-1,30088,30089,30289,30288,-1,30089,30090,30290,30289,-1,30090,30091,30291,30290,-1,30091,30092,30292,30291,-1,30092,30093,30293,30292,-1,30093,30094,30294,30293,-1,30094,30095,30295,30294,-1,30095,30096,30296,30295,-1,30096,30097,30297,30296,-1,30097,30098,30298,30297,-1,30098,30099,30299,30298,-1,30099,30100,30300,30299,-1,30100,30101,30301,30300,-1,30101,30102,30302,30301,-1,30102,30103,30303,30302,-1,30103,30104,30304,30303,-1,30104,30105,30305,30304,-1,30105,30106,30306,30305,-1,30106,30107,30307,30306,-1,30107,30108,30308,30307,-1,30108,30109,30309,30308,-1,30109,30110,30310,30309,-1,30110,30111,30311,30310,-1,30111,30112,30312,30311,-1,30112,30113,30313,30312,-1,30113,30114,30314,30313,-1,30114,30115,30315,30314,-1,30115,30116,30316,30315,-1,30116,30117,30317,30316,-1,30117,30118,30318,30317,-1,30118,30119,30319,30318,-1,30119,30120,30320,30319,-1,30120,30121,30321,30320,-1,30121,30122,30322,30321,-1,30122,30123,30323,30322,-1,30123,30124,30324,30323,-1,30124,30125,30325,30324,-1,30125,30126,30326,30325,-1,30126,30127,30327,30326,-1,30127,30128,30328,30327,-1,30128,30129,30329,30328,-1,30129,30130,30330,30329,-1,30130,30131,30331,30330,-1,30131,30132,30332,30331,-1,30132,30133,30333,30332,-1,30133,30134,30334,30333,-1,30134,30135,30335,30334,-1,30135,30136,30336,30335,-1,30136,30137,30337,30336,-1,30137,30138,30338,30337,-1,30138,30139,30339,30338,-1,30139,30140,30340,30339,-1,30140,30141,30341,30340,-1,30141,30142,30342,30341,-1,30142,30143,30343,30342,-1,30143,30144,30344,30343,-1,30144,30145,30345,30344,-1,30145,30146,30346,30345,-1,30146,30147,30347,30346,-1,30147,30148,30348,30347,-1,30148,30149,30349,30348,-1,30149,30150,30350,30349,-1,30150,30151,30351,30350,-1,30151,30152,30352,30351,-1,30152,30153,30353,30352,-1,30153,30154,30354,30353,-1,30154,30155,30355,30354,-1,30155,30156,30356,30355,-1,30156,30157,30357,30356,-1,30157,30158,30358,30357,-1,30158,30159,30359,30358,-1,30159,30160,30360,30359,-1,30160,30161,30361,30360,-1,30161,30162,30362,30361,-1,30162,30163,30363,30362,-1,30163,30164,30364,30363,-1,30164,30165,30365,30364,-1,30165,30166,30366,30365,-1,30166,30167,30367,30366,-1,30167,30168,30368,30367,-1,30168,30169,30369,30368,-1,30169,30170,30370,30369,-1,30170,30171,30371,30370,-1,30171,30172,30372,30371,-1,30172,30173,30373,30372,-1,30173,30174,30374,30373,-1,30174,30175,30375,30374,-1,30175,30176,30376,30375,-1,30176,30177,30377,30376,-1,30177,30178,30378,30377,-1,30178,30179,30379,30378,-1,30179,30180,30380,30379,-1,30180,30181,30381,30380,-1,30181,30182,30382,30381,-1,30182,30183,30383,30382,-1,30183,30184,30384,30383,-1,30184,30185,30385,30384,-1,30185,30186,30386,30385,-1,30186,30187,30387,30386,-1,30187,30188,30388,30387,-1,30188,30189,30389,30388,-1,30189,30190,30390,30389,-1,30190,30191,30391,30390,-1,30191,30192,30392,30391,-1,30192,30193,30393,30392,-1,30193,30194,30394,30393,-1,30194,30195,30395,30394,-1,30195,30196,30396,30395,-1,30196,30197,30397,30396,-1,30197,30198,30398,30397,-1,30198,30199,30399,30398,-1,30200,30201,30401,30400,-1,30201,30202,30402,30401,-1,30202,30203,30403,30402,-1,30203,30204,30404,30403,-1,30204,30205,30405,30404,-1,30205,30206,30406,30405,-1,30206,30207,30407,30406,-1,30207,30208,30408,30407,-1,30208,30209,30409,30408,-1,30209,30210,30410,30409,-1,30210,30211,30411,30410,-1,30211,30212,30412,30411,-1,30212,30213,30413,30412,-1,30213,30214,30414,30413,-1,30214,30215,30415,30414,-1,30215,30216,30416,30415,-1,30216,30217,30417,30416,-1,30217,30218,30418,30417,-1,30218,30219,30419,30418,-1,30219,30220,30420,30419,-1,30220,30221,30421,30420,-1,30221,30222,30422,30421,-1,30222,30223,30423,30422,-1,30223,30224,30424,30423,-1,30224,30225,30425,30424,-1,30225,30226,30426,30425,-1,30226,30227,30427,30426,-1,30227,30228,30428,30427,-1,30228,30229,30429,30428,-1,30229,30230,30430,30429,-1,30230,30231,30431,30430,-1,30231,30232,30432,30431,-1,30232,30233,30433,30432,-1,30233,30234,30434,30433,-1,30234,30235,30435,30434,-1,30235,30236,30436,30435,-1,30236,30237,30437,30436,-1,30237,30238,30438,30437,-1,30238,30239,30439,30438,-1,30239,30240,30440,30439,-1,30240,30241,30441,30440,-1,30241,30242,30442,30441,-1,30242,30243,30443,30442,-1,30243,30244,30444,30443,-1,30244,30245,30445,30444,-1,30245,30246,30446,30445,-1,30246,30247,30447,30446,-1,30247,30248,30448,30447,-1,30248,30249,30449,30448,-1,30249,30250,30450,30449,-1,30250,30251,30451,30450,-1,30251,30252,30452,30451,-1,30252,30253,30453,30452,-1,30253,30254,30454,30453,-1,30254,30255,30455,30454,-1,30255,30256,30456,30455,-1,30256,30257,30457,30456,-1,30257,30258,30458,30457,-1,30258,30259,30459,30458,-1,30259,30260,30460,30459,-1,30260,30261,30461,30460,-1,30261,30262,30462,30461,-1,30262,30263,30463,30462,-1,30263,30264,30464,30463,-1,30264,30265,30465,30464,-1,30265,30266,30466,30465,-1,30266,30267,30467,30466,-1,30267,30268,30468,30467,-1,30268,30269,30469,30468,-1,30269,30270,30470,30469,-1,30270,30271,30471,30470,-1,30271,30272,30472,30471,-1,30272,30273,30473,30472,-1,30273,30274,30474,30473,-1,30274,30275,30475,30474,-1,30275,30276,30476,30475,-1,30276,30277,30477,30476,-1,30277,30278,30478,30477,-1,30278,30279,30479,30478,-1,30279,30280,30480,30479,-1,30280,30281,30481,30480,-1,30281,30282,30482,30481,-1,30282,30283,30483,30482,-1,30283,30284,30484,30483,-1,30284,30285,30485,30484,-1,30285,30286,30486,30485,-1,30286,30287,30487,30486,-1,30287,30288,30488,30487,-1,30288,30289,30489,30488,-1,30289,30290,30490,30489,-1,30290,30291,30491,30490,-1,30291,30292,30492,30491,-1,30292,30293,30493,30492,-1,30293,30294,30494,30493,-1,30294,30295,30495,30494,-1,30295,30296,30496,30495,-1,30296,30297,30497,30496,-1,30297,30298,30498,30497,-1,30298,30299,30499,30498,-1,30299,30300,30500,30499,-1,30300,30301,30501,30500,-1,30301,30302,30502,30501,-1,30302,30303,30503,30502,-1,30303,30304,30504,30503,-1,30304,30305,30505,30504,-1,30305,30306,30506,30505,-1,30306,30307,30507,30506,-1,30307,30308,30508,30507,-1,30308,30309,30509,30508,-1,30309,30310,30510,30509,-1,30310,30311,30511,30510,-1,30311,30312,30512,30511,-1,30312,30313,30513,30512,-1,30313,30314,30514,30513,-1,30314,30315,30515,30514,-1,30315,30316,30516,30515,-1,30316,30317,30517,30516,-1,30317,30318,30518,30517,-1,30318,30319,30519,30518,-1,30319,30320,30520,30519,-1,30320,30321,30521,30520,-1,30321,30322,30522,30521,-1,30322,30323,30523,30522,-1,30323,30324,30524,30523,-1,30324,30325,30525,30524,-1,30325,30326,30526,30525,-1,30326,30327,30527,30526,-1,30327,30328,30528,30527,-1,30328,30329,30529,30528,-1,30329,30330,30530,30529,-1,30330,30331,30531,30530,-1,30331,30332,30532,30531,-1,30332,30333,30533,30532,-1,30333,30334,30534,30533,-1,30334,30335,30535,30534,-1,30335,30336,30536,30535,-1,30336,30337,30537,30536,-1,30337,30338,30538,30537,-1,30338,30339,30539,30538,-1,30339,30340,30540,30539,-1,30340,30341,30541,30540,-1,30341,30342,30542,30541,-1,30342,30343,30543,30542,-1,30343,30344,30544,30543,-1,30344,30345,30545,30544,-1,30345,30346,30546,30545,-1,30346,30347,30547,30546,-1,30347,30348,30548,30547,-1,30348,30349,30549,30548,-1,30349,30350,30550,30549,-1,30350,30351,30551,30550,-1,30351,30352,30552,30551,-1,30352,30353,30553,30552,-1,30353,30354,30554,30553,-1,30354,30355,30555,30554,-1,30355,30356,30556,30555,-1,30356,30357,30557,30556,-1,30357,30358,30558,30557,-1,30358,30359,30559,30558,-1,30359,30360,30560,30559,-1,30360,30361,30561,30560,-1,30361,30362,30562,30561,-1,30362,30363,30563,30562,-1,30363,30364,30564,30563,-1,30364,30365,30565,30564,-1,30365,30366,30566,30565,-1,30366,30367,30567,30566,-1,30367,30368,30568,30567,-1,30368,30369,30569,30568,-1,30369,30370,30570,30569,-1,30370,30371,30571,30570,-1,30371,30372,30572,30571,-1,30372,30373,30573,30572,-1,30373,30374,30574,30573,-1,30374,30375,30575,30574,-1,30375,30376,30576,30575,-1,30376,30377,30577,30576,-1,30377,30378,30578,30577,-1,30378,30379,30579,30578,-1,30379,30380,30580,30579,-1,30380,30381,30581,30580,-1,30381,30382,30582,30581,-1,30382,30383,30583,30582,-1,30383,30384,30584,30583,-1,30384,30385,30585,30584,-1,30385,30386,30586,30585,-1,30386,30387,30587,30586,-1,30387,30388,30588,30587,-1,30388,30389,30589,30588,-1,30389,30390,30590,30589,-1,30390,30391,30591,30590,-1,30391,30392,30592,30591,-1,30392,30393,30593,30592,-1,30393,30394,30594,30593,-1,30394,30395,30595,30594,-1,30395,30396,30596,30595,-1,30396,30397,30597,30596,-1,30397,30398,30598,30597,-1,30398,30399,30599,30598,-1,30400,30401,30601,30600,-1,30401,30402,30602,30601,-1,30402,30403,30603,30602,-1,30403,30404,30604,30603,-1,30404,30405,30605,30604,-1,30405,30406,30606,30605,-1,30406,30407,30607,30606,-1,30407,30408,30608,30607,-1,30408,30409,30609,30608,-1,30409,30410,30610,30609,-1,30410,30411,30611,30610,-1,30411,30412,30612,30611,-1,30412,30413,30613,30612,-1,30413,30414,30614,30613,-1,30414,30415,30615,30614,-1,30415,30416,30616,30615,-1,30416,30417,30617,30616,-1,30417,30418,30618,30617,-1,30418,30419,30619,30618,-1,30419,30420,30620,30619,-1,30420,30421,30621,30620,-1,30421,30422,30622,30621,-1,30422,30423,30623,30622,-1,30423,30424,30624,30623,-1,30424,30425,30625,30624,-1,30425,30426,30626,30625,-1,30426,30427,30627,30626,-1,30427,30428,30628,30627,-1,30428,30429,30629,30628,-1,30429,30430,30630,30629,-1,30430,30431,30631,30630,-1,30431,30432,30632,30631,-1,30432,30433,30633,30632,-1,30433,30434,30634,30633,-1,30434,30435,30635,30634,-1,30435,30436,30636,30635,-1,30436,30437,30637,30636,-1,30437,30438,30638,30637,-1,30438,30439,30639,30638,-1,30439,30440,30640,30639,-1,30440,30441,30641,30640,-1,30441,30442,30642,30641,-1,30442,30443,30643,30642,-1,30443,30444,30644,30643,-1,30444,30445,30645,30644,-1,30445,30446,30646,30645,-1,30446,30447,30647,30646,-1,30447,30448,30648,30647,-1,30448,30449,30649,30648,-1,30449,30450,30650,30649,-1,30450,30451,30651,30650,-1,30451,30452,30652,30651,-1,30452,30453,30653,30652,-1,30453,30454,30654,30653,-1,30454,30455,30655,30654,-1,30455,30456,30656,30655,-1,30456,30457,30657,30656,-1,30457,30458,30658,30657,-1,30458,30459,30659,30658,-1,30459,30460,30660,30659,-1,30460,30461,30661,30660,-1,30461,30462,30662,30661,-1,30462,30463,30663,30662,-1,30463,30464,30664,30663,-1,30464,30465,30665,30664,-1,30465,30466,30666,30665,-1,30466,30467,30667,30666,-1,30467,30468,30668,30667,-1,30468,30469,30669,30668,-1,30469,30470,30670,30669,-1,30470,30471,30671,30670,-1,30471,30472,30672,30671,-1,30472,30473,30673,30672,-1,30473,30474,30674,30673,-1,30474,30475,30675,30674,-1,30475,30476,30676,30675,-1,30476,30477,30677,30676,-1,30477,30478,30678,30677,-1,30478,30479,30679,30678,-1,30479,30480,30680,30679,-1,30480,30481,30681,30680,-1,30481,30482,30682,30681,-1,30482,30483,30683,30682,-1,30483,30484,30684,30683,-1,30484,30485,30685,30684,-1,30485,30486,30686,30685,-1,30486,30487,30687,30686,-1,30487,30488,30688,30687,-1,30488,30489,30689,30688,-1,30489,30490,30690,30689,-1,30490,30491,30691,30690,-1,30491,30492,30692,30691,-1,30492,30493,30693,30692,-1,30493,30494,30694,30693,-1,30494,30495,30695,30694,-1,30495,30496,30696,30695,-1,30496,30497,30697,30696,-1,30497,30498,30698,30697,-1,30498,30499,30699,30698,-1,30499,30500,30700,30699,-1,30500,30501,30701,30700,-1,30501,30502,30702,30701,-1,30502,30503,30703,30702,-1,30503,30504,30704,30703,-1,30504,30505,30705,30704,-1,30505,30506,30706,30705,-1,30506,30507,30707,30706,-1,30507,30508,30708,30707,-1,30508,30509,30709,30708,-1,30509,30510,30710,30709,-1,30510,30511,30711,30710,-1,30511,30512,30712,30711,-1,30512,30513,30713,30712,-1,30513,30514,30714,30713,-1,30514,30515,30715,30714,-1,30515,30516,30716,30715,-1,30516,30517,30717,30716,-1,30517,30518,30718,30717,-1,30518,30519,30719,30718,-1,30519,30520,30720,30719,-1,30520,30521,30721,30720,-1,30521,30522,30722,30721,-1,30522,30523,30723,30722,-1,30523,30524,30724,30723,-1,30524,30525,30725,30724,-1,30525,30526,30726,30725,-1,30526,30527,30727,30726,-1,30527,30528,30728,30727,-1,30528,30529,30729,30728,-1,30529,30530,30730,30729,-1,30530,30531,30731,30730,-1,30531,30532,30732,30731,-1,30532,30533,30733,30732,-1,30533,30534,30734,30733,-1,30534,30535,30735,30734,-1,30535,30536,30736,30735,-1,30536,30537,30737,30736,-1,30537,30538,30738,30737,-1,30538,30539,30739,30738,-1,30539,30540,30740,30739,-1,30540,30541,30741,30740,-1,30541,30542,30742,30741,-1,30542,30543,30743,30742,-1,30543,30544,30744,30743,-1,30544,30545,30745,30744,-1,30545,30546,30746,30745,-1,30546,30547,30747,30746,-1,30547,30548,30748,30747,-1,30548,30549,30749,30748,-1,30549,30550,30750,30749,-1,30550,30551,30751,30750,-1,30551,30552,30752,30751,-1,30552,30553,30753,30752,-1,30553,30554,30754,30753,-1,30554,30555,30755,30754,-1,30555,30556,30756,30755,-1,30556,30557,30757,30756,-1,30557,30558,30758,30757,-1,30558,30559,30759,30758,-1,30559,30560,30760,30759,-1,30560,30561,30761,30760,-1,30561,30562,30762,30761,-1,30562,30563,30763,30762,-1,30563,30564,30764,30763,-1,30564,30565,30765,30764,-1,30565,30566,30766,30765,-1,30566,30567,30767,30766,-1,30567,30568,30768,30767,-1,30568,30569,30769,30768,-1,30569,30570,30770,30769,-1,30570,30571,30771,30770,-1,30571,30572,30772,30771,-1,30572,30573,30773,30772,-1,30573,30574,30774,30773,-1,30574,30575,30775,30774,-1,30575,30576,30776,30775,-1,30576,30577,30777,30776,-1,30577,30578,30778,30777,-1,30578,30579,30779,30778,-1,30579,30580,30780,30779,-1,30580,30581,30781,30780,-1,30581,30582,30782,30781,-1,30582,30583,30783,30782,-1,30583,30584,30784,30783,-1,30584,30585,30785,30784,-1,30585,30586,30786,30785,-1,30586,30587,30787,30786,-1,30587,30588,30788,30787,-1,30588,30589,30789,30788,-1,30589,30590,30790,30789,-1,30590,30591,30791,30790,-1,30591,30592,30792,30791,-1,30592,30593,30793,30792,-1,30593,30594,30794,30793,-1,30594,30595,30795,30794,-1,30595,30596,30796,30795,-1,30596,30597,30797,30796,-1,30597,30598,30798,30797,-1,30598,30599,30799,30798,-1,30600,30601,30801,30800,-1,30601,30602,30802,30801,-1,30602,30603,30803,30802,-1,30603,30604,30804,30803,-1,30604,30605,30805,30804,-1,30605,30606,30806,30805,-1,30606,30607,30807,30806,-1,30607,30608,30808,30807,-1,30608,30609,30809,30808,-1,30609,30610,30810,30809,-1,30610,30611,30811,30810,-1,30611,30612,30812,30811,-1,30612,30613,30813,30812,-1,30613,30614,30814,30813,-1,30614,30615,30815,30814,-1,30615,30616,30816,30815,-1,30616,30617,30817,30816,-1,30617,30618,30818,30817,-1,30618,30619,30819,30818,-1,30619,30620,30820,30819,-1,30620,30621,30821,30820,-1,30621,30622,30822,30821,-1,30622,30623,30823,30822,-1,30623,30624,30824,30823,-1,30624,30625,30825,30824,-1,30625,30626,30826,30825,-1,30626,30627,30827,30826,-1,30627,30628,30828,30827,-1,30628,30629,30829,30828,-1,30629,30630,30830,30829,-1,30630,30631,30831,30830,-1,30631,30632,30832,30831,-1,30632,30633,30833,30832,-1,30633,30634,30834,30833,-1,30634,30635,30835,30834,-1,30635,30636,30836,30835,-1,30636,30637,30837,30836,-1,30637,30638,30838,30837,-1,30638,30639,30839,30838,-1,30639,30640,30840,30839,-1,30640,30641,30841,30840,-1,30641,30642,30842,30841,-1,30642,30643,30843,30842,-1,30643,30644,30844,30843,-1,30644,30645,30845,30844,-1,30645,30646,30846,30845,-1,30646,30647,30847,30846,-1,30647,30648,30848,30847,-1,30648,30649,30849,30848,-1,30649,30650,30850,30849,-1,30650,30651,30851,30850,-1,30651,30652,30852,30851,-1,30652,30653,30853,30852,-1,30653,30654,30854,30853,-1,30654,30655,30855,30854,-1,30655,30656,30856,30855,-1,30656,30657,30857,30856,-1,30657,30658,30858,30857,-1,30658,30659,30859,30858,-1,30659,30660,30860,30859,-1,30660,30661,30861,30860,-1,30661,30662,30862,30861,-1,30662,30663,30863,30862,-1,30663,30664,30864,30863,-1,30664,30665,30865,30864,-1,30665,30666,30866,30865,-1,30666,30667,30867,30866,-1,30667,30668,30868,30867,-1,30668,30669,30869,30868,-1,30669,30670,30870,30869,-1,30670,30671,30871,30870,-1,30671,30672,30872,30871,-1,30672,30673,30873,30872,-1,30673,30674,30874,30873,-1,30674,30675,30875,30874,-1,30675,30676,30876,30875,-1,30676,30677,30877,30876,-1,30677,30678,30878,30877,-1,30678,30679,30879,30878,-1,30679,30680,30880,30879,-1,30680,30681,30881,30880,-1,30681,30682,30882,30881,-1,30682,30683,30883,30882,-1,30683,30684,30884,30883,-1,30684,30685,30885,30884,-1,30685,30686,30886,30885,-1,30686,30687,30887,30886,-1,30687,30688,30888,30887,-1,30688,30689,30889,30888,-1,30689,30690,30890,30889,-1,30690,30691,30891,30890,-1,30691,30692,30892,30891,-1,30692,30693,30893,30892,-1,30693,30694,30894,30893,-1,30694,30695,30895,30894,-1,30695,30696,30896,30895,-1,30696,30697,30897,30896,-1,30697,30698,30898,30897,-1,30698,30699,30899,30898,-1,30699,30700,30900,30899,-1,30700,30701,30901,30900,-1,30701,30702,30902,30901,-1,30702,30703,30903,30902,-1,30703,30704,30904,30903,-1,30704,30705,30905,30904,-1,30705,30706,30906,30905,-1,30706,30707,30907,30906,-1,30707,30708,30908,30907,-1,30708,30709,30909,30908,-1,30709,30710,30910,30909,-1,30710,30711,30911,30910,-1,30711,30712,30912,30911,-1,30712,30713,30913,30912,-1,30713,30714,30914,30913,-1,30714,30715,30915,30914,-1,30715,30716,30916,30915,-1,30716,30717,30917,30916,-1,30717,30718,30918,30917,-1,30718,30719,30919,30918,-1,30719,30720,30920,30919,-1,30720,30721,30921,30920,-1,30721,30722,30922,30921,-1,30722,30723,30923,30922,-1,30723,30724,30924,30923,-1,30724,30725,30925,30924,-1,30725,30726,30926,30925,-1,30726,30727,30927,30926,-1,30727,30728,30928,30927,-1,30728,30729,30929,30928,-1,30729,30730,30930,30929,-1,30730,30731,30931,30930,-1,30731,30732,30932,30931,-1,30732,30733,30933,30932,-1,30733,30734,30934,30933,-1,30734,30735,30935,30934,-1,30735,30736,30936,30935,-1,30736,30737,30937,30936,-1,30737,30738,30938,30937,-1,30738,30739,30939,30938,-1,30739,30740,30940,30939,-1,30740,30741,30941,30940,-1,30741,30742,30942,30941,-1,30742,30743,30943,30942,-1,30743,30744,30944,30943,-1,30744,30745,30945,30944,-1,30745,30746,30946,30945,-1,30746,30747,30947,30946,-1,30747,30748,30948,30947,-1,30748,30749,30949,30948,-1,30749,30750,30950,30949,-1,30750,30751,30951,30950,-1,30751,30752,30952,30951,-1,30752,30753,30953,30952,-1,30753,30754,30954,30953,-1,30754,30755,30955,30954,-1,30755,30756,30956,30955,-1,30756,30757,30957,30956,-1,30757,30758,30958,30957,-1,30758,30759,30959,30958,-1,30759,30760,30960,30959,-1,30760,30761,30961,30960,-1,30761,30762,30962,30961,-1,30762,30763,30963,30962,-1,30763,30764,30964,30963,-1,30764,30765,30965,30964,-1,30765,30766,30966,30965,-1,30766,30767,30967,30966,-1,30767,30768,30968,30967,-1,30768,30769,30969,30968,-1,30769,30770,30970,30969,-1,30770,30771,30971,30970,-1,30771,30772,30972,30971,-1,30772,30773,30973,30972,-1,30773,30774,30974,30973,-1,30774,30775,30975,30974,-1,30775,30776,30976,30975,-1,30776,30777,30977,30976,-1,30777,30778,30978,30977,-1,30778,30779,30979,30978,-1,30779,30780,30980,30979,-1,30780,30781,30981,30980,-1,30781,30782,30982,30981,-1,30782,30783,30983,30982,-1,30783,30784,30984,30983,-1,30784,30785,30985,30984,-1,30785,30786,30986,30985,-1,30786,30787,30987,30986,-1,30787,30788,30988,30987,-1,30788,30789,30989,30988,-1,30789,30790,30990,30989,-1,30790,30791,30991,30990,-1,30791,30792,30992,30991,-1,30792,30793,30993,30992,-1,30793,30794,30994,30993,-1,30794,30795,30995,30994,-1,30795,30796,30996,30995,-1,30796,30797,30997,30996,-1,30797,30798,30998,30997,-1,30798,30799,30999,30998,-1,30800,30801,31001,31,-1,30801,30802,31002,31001,-1,30802,30803,31003,31002,-1,30803,30804,31004,31003,-1,30804,30805,31005,31004,-1,30805,30806,31006,31005,-1,30806,30807,31007,31006,-1,30807,30808,31008,31007,-1,30808,30809,31009,31008,-1,30809,30810,31010,31009,-1,30810,30811,31011,31010,-1,30811,30812,31012,31011,-1,30812,30813,31013,31012,-1,30813,30814,31014,31013,-1,30814,30815,31015,31014,-1,30815,30816,31016,31015,-1,30816,30817,31017,31016,-1,30817,30818,31018,31017,-1,30818,30819,31019,31018,-1,30819,30820,31020,31019,-1,30820,30821,31021,31020,-1,30821,30822,31022,31021,-1,30822,30823,31023,31022,-1,30823,30824,31024,31023,-1,30824,30825,31025,31024,-1,30825,30826,31026,31025,-1,30826,30827,31027,31026,-1,30827,30828,31028,31027,-1,30828,30829,31029,31028,-1,30829,30830,31030,31029,-1,30830,30831,31031,31030,-1,30831,30832,31032,31031,-1,30832,30833,31033,31032,-1,30833,30834,31034,31033,-1,30834,30835,31035,31034,-1,30835,30836,31036,31035,-1,30836,30837,31037,31036,-1,30837,30838,31038,31037,-1,30838,30839,31039,31038,-1,30839,30840,31040,31039,-1,30840,30841,31041,31040,-1,30841,30842,31042,31041,-1,30842,30843,31043,31042,-1,30843,30844,31044,31043,-1,30844,30845,31045,31044,-1,30845,30846,31046,31045,-1,30846,30847,31047,31046,-1,30847,30848,31048,31047,-1,30848,30849,31049,31048,-1,30849,30850,31050,31049,-1,30850,30851,31051,31050,-1,30851,30852,31052,31051,-1,30852,30853,31053,31052,-1,30853,30854,31054,31053,-1,30854,30855,31055,31054,-1,30855,30856,31056,31055,-1,30856,30857,31057,31056,-1,30857,30858,31058,31057,-1,30858,30859,31059,31058,-1,30859,30860,31060,31059,-1,30860,30861,31061,31060,-1,30861,30862,31062,31061,-1,30862,30863,31063,31062,-1,30863,30864,31064,31063,-1,30864,30865,31065,31064,-1,30865,30866,31066,31065,-1,30866,30867,31067,31066,-1,30867,30868,31068,31067,-1,30868,30869,31069,31068,-1,30869,30870,31070,31069,-1,30870,30871,31071,31070,-1,30871,30872,31072,31071,-1,30872,30873,31073,31072,-1,30873,30874,31074,31073,-1,30874,30875,31075,31074,-1,30875,30876,31076,31075,-1,30876,30877,31077,31076,-1,30877,30878,31078,31077,-1,30878,30879,31079,31078,-1,30879,30880,31080,31079,-1,30880,30881,31081,31080,-1,30881,30882,31082,31081,-1,30882,30883,31083,31082,-1,30883,30884,31084,31083,-1,30884,30885,31085,31084,-1,30885,30886,31086,31085,-1,30886,30887,31087,31086,-1,30887,30888,31088,31087,-1,30888,30889,31089,31088,-1,30889,30890,31090,31089,-1,30890,30891,31091,31090,-1,30891,30892,31092,31091,-1,30892,30893,31093,31092,-1,30893,30894,31094,31093,-1,30894,30895,31095,31094,-1,30895,30896,31096,31095,-1,30896,30897,31097,31096,-1,30897,30898,31098,31097,-1,30898,30899,31099,31098,-1,30899,30900,31100,31099,-1,30900,30901,31101,31100,-1,30901,30902,31102,31101,-1,30902,30903,31103,31102,-1,30903,30904,31104,31103,-1,30904,30905,31105,31104,-1,30905,30906,31106,31105,-1,30906,30907,31107,31106,-1,30907,30908,31108,31107,-1,30908,30909,31109,31108,-1,30909,30910,31110,31109,-1,30910,30911,31111,31110,-1,30911,30912,31112,31111,-1,30912,30913,31113,31112,-1,30913,30914,31114,31113,-1,30914,30915,31115,31114,-1,30915,30916,31116,31115,-1,30916,30917,31117,31116,-1,30917,30918,31118,31117,-1,30918,30919,31119,31118,-1,30919,30920,31120,31119,-1,30920,30921,31121,31120,-1,30921,30922,31122,31121,-1,30922,30923,31123,31122,-1,30923,30924,31124,31123,-1,30924,30925,31125,31124,-1,30925,30926,31126,31125,-1,30926,30927,31127,31126,-1,30927,30928,31128,31127,-1,30928,30929,31129,31128,-1,30929,30930,31130,31129,-1,30930,30931,31131,31130,-1,30931,30932,31132,31131,-1,30932,30933,31133,31132,-1,30933,30934,31134,31133,-1,30934,30935,31135,31134,-1,30935,30936,31136,31135,-1,30936,30937,31137,31136,-1,30937,30938,31138,31137,-1,30938,30939,31139,31138,-1,30939,30940,31140,31139,-1,30940,30941,31141,31140,-1,30941,30942,31142,31141,-1,30942,30943,31143,31142,-1,30943,30944,31144,31143,-1,30944,30945,31145,31144,-1,30945,30946,31146,31145,-1,30946,30947,31147,31146,-1,30947,30948,31148,31147,-1,30948,30949,31149,31148,-1,30949,30950,31150,31149,-1,30950,30951,31151,31150,-1,30951,30952,31152,31151,-1,30952,30953,31153,31152,-1,30953,30954,31154,31153,-1,30954,30955,31155,31154,-1,30955,30956,31156,31155,-1,30956,30957,31157,31156,-1,30957,30958,31158,31157,-1,30958,30959,31159,31158,-1,30959,30960,31160,31159,-1,30960,30961,31161,31160,-1,30961,30962,31162,31161,-1,30962,30963,31163,31162,-1,30963,30964,31164,31163,-1,30964,30965,31165,31164,-1,30965,30966,31166,31165,-1,30966,30967,31167,31166,-1,30967,30968,31168,31167,-1,30968,30969,31169,31168,-1,30969,30970,31170,31169,-1,30970,30971,31171,31170,-1,30971,30972,31172,31171,-1,30972,30973,31173,31172,-1,30973,30974,31174,31173,-1,30974,30975,31175,31174,-1,30975,30976,31176,31175,-1,30976,30977,31177,31176,-1,30977,30978,31178,31177,-1,30978,30979,31179,31178,-1,30979,30980,31180,31179,-1,30980,30981,31181,31180,-1,30981,30982,31182,31181,-1,30982,30983,31183,31182,-1,30983,30984,31184,31183,-1,30984,30985,31185,31184,-1,30985,30986,31186,31185,-1,30986,30987,31187,31186,-1,30987,30988,31188,31187,-1,30988,30989,31189,31188,-1,30989,30990,31190,31189,-1,30990,30991,31191,31190,-1,30991,30992,31192,31191,-1,30992,30993,31193,31192,-1,30993,30994,31194,31193,-1,30994,30995,31195,31194,-1,30995,30996,31196,31195,-1,30996,30997,31197,31196,-1,30997,30998,31198,31197,-1,30998,30999,31199,31198,-1,31,31001,31201,31200,-1,31001,31002,31202,31201,-1,31002,31003,31203,31202,-1,31003,31004,31204,31203,-1,31004,31005,31205,31204,-1,31005,31006,31206,31205,-1,31006,31007,31207,31206,-1,31007,31008,31208,31207,-1,31008,31009,31209,31208,-1,31009,31010,31210,31209,-1,31010,31011,31211,31210,-1,31011,31012,31212,31211,-1,31012,31013,31213,31212,-1,31013,31014,31214,31213,-1,31014,31015,31215,31214,-1,31015,31016,31216,31215,-1,31016,31017,31217,31216,-1,31017,31018,31218,31217,-1,31018,31019,31219,31218,-1,31019,31020,31220,31219,-1,31020,31021,31221,31220,-1,31021,31022,31222,31221,-1,31022,31023,31223,31222,-1,31023,31024,31224,31223,-1,31024,31025,31225,31224,-1,31025,31026,31226,31225,-1,31026,31027,31227,31226,-1,31027,31028,31228,31227,-1,31028,31029,31229,31228,-1,31029,31030,31230,31229,-1,31030,31031,31231,31230,-1,31031,31032,31232,31231,-1,31032,31033,31233,31232,-1,31033,31034,31234,31233,-1,31034,31035,31235,31234,-1,31035,31036,31236,31235,-1,31036,31037,31237,31236,-1,31037,31038,31238,31237,-1,31038,31039,31239,31238,-1,31039,31040,31240,31239,-1,31040,31041,31241,31240,-1,31041,31042,31242,31241,-1,31042,31043,31243,31242,-1,31043,31044,31244,31243,-1,31044,31045,31245,31244,-1,31045,31046,31246,31245,-1,31046,31047,31247,31246,-1,31047,31048,31248,31247,-1,31048,31049,31249,31248,-1,31049,31050,31250,31249,-1,31050,31051,31251,31250,-1,31051,31052,31252,31251,-1,31052,31053,31253,31252,-1,31053,31054,31254,31253,-1,31054,31055,31255,31254,-1,31055,31056,31256,31255,-1,31056,31057,31257,31256,-1,31057,31058,31258,31257,-1,31058,31059,31259,31258,-1,31059,31060,31260,31259,-1,31060,31061,31261,31260,-1,31061,31062,31262,31261,-1,31062,31063,31263,31262,-1,31063,31064,31264,31263,-1,31064,31065,31265,31264,-1,31065,31066,31266,31265,-1,31066,31067,31267,31266,-1,31067,31068,31268,31267,-1,31068,31069,31269,31268,-1,31069,31070,31270,31269,-1,31070,31071,31271,31270,-1,31071,31072,31272,31271,-1,31072,31073,31273,31272,-1,31073,31074,31274,31273,-1,31074,31075,31275,31274,-1,31075,31076,31276,31275,-1,31076,31077,31277,31276,-1,31077,31078,31278,31277,-1,31078,31079,31279,31278,-1,31079,31080,31280,31279,-1,31080,31081,31281,31280,-1,31081,31082,31282,31281,-1,31082,31083,31283,31282,-1,31083,31084,31284,31283,-1,31084,31085,31285,31284,-1,31085,31086,31286,31285,-1,31086,31087,31287,31286,-1,31087,31088,31288,31287,-1,31088,31089,31289,31288,-1,31089,31090,31290,31289,-1,31090,31091,31291,31290,-1,31091,31092,31292,31291,-1,31092,31093,31293,31292,-1,31093,31094,31294,31293,-1,31094,31095,31295,31294,-1,31095,31096,31296,31295,-1,31096,31097,31297,31296,-1,31097,31098,31298,31297,-1,31098,31099,31299,31298,-1,31099,31100,31300,31299,-1,31100,31101,31301,31300,-1,31101,31102,31302,31301,-1,31102,31103,31303,31302,-1,31103,31104,31304,31303,-1,31104,31105,31305,31304,-1,31105,31106,31306,31305,-1,31106,31107,31307,31306,-1,31107,31108,31308,31307,-1,31108,31109,31309,31308,-1,31109,31110,31310,31309,-1,31110,31111,31311,31310,-1,31111,31112,31312,31311,-1,31112,31113,31313,31312,-1,31113,31114,31314,31313,-1,31114,31115,31315,31314,-1,31115,31116,31316,31315,-1,31116,31117,31317,31316,-1,31117,31118,31318,31317,-1,31118,31119,31319,31318,-1,31119,31120,31320,31319,-1,31120,31121,31321,31320,-1,31121,31122,31322,31321,-1,31122,31123,31323,31322,-1,31123,31124,31324,31323,-1,31124,31125,31325,31324,-1,31125,31126,31326,31325,-1,31126,31127,31327,31326,-1,31127,31128,31328,31327,-1,31128,31129,31329,31328,-1,31129,31130,31330,31329,-1,31130,31131,31331,31330,-1,31131,31132,31332,31331,-1,31132,31133,31333,31332,-1,31133,31134,31334,31333,-1,31134,31135,31335,31334,-1,31135,31136,31336,31335,-1,31136,31137,31337,31336,-1,31137,31138,31338,31337,-1,31138,31139,31339,31338,-1,31139,31140,31340,31339,-1,31140,31141,31341,31340,-1,31141,31142,31342,31341,-1,31142,31143,31343,31342,-1,31143,31144,31344,31343,-1,31144,31145,31345,31344,-1,31145,31146,31346,31345,-1,31146,31147,31347,31346,-1,31147,31148,31348,31347,-1,31148,31149,31349,31348,-1,31149,31150,31350,31349,-1,31150,31151,31351,31350,-1,31151,31152,31352,31351,-1,31152,31153,31353,31352,-1,31153,31154,31354,31353,-1,31154,31155,31355,31354,-1,31155,31156,31356,31355,-1,31156,31157,31357,31356,-1,31157,31158,31358,31357,-1,31158,31159,31359,31358,-1,31159,31160,31360,31359,-1,31160,31161,31361,31360,-1,31161,31162,31362,31361,-1,31162,31163,31363,31362,-1,31163,31164,31364,31363,-1,31164,31165,31365,31364,-1,31165,31166,31366,31365,-1,31166,31167,31367,31366,-1,31167,31168,31368,31367,-1,31168,31169,31369,31368,-1,31169,31170,31370,31369,-1,31170,31171,31371,31370,-1,31171,31172,31372,31371,-1,31172,31173,31373,31372,-1,31173,31174,31374,31373,-1,31174,31175,31375,31374,-1,31175,31176,31376,31375,-1,31176,31177,31377,31376,-1,31177,31178,31378,31377,-1,31178,31179,31379,31378,-1,31179,31180,31380,31379,-1,31180,31181,31381,31380,-1,31181,31182,31382,31381,-1,31182,31183,31383,31382,-1,31183,31184,31384,31383,-1,31184,31185,31385,31384,-1,31185,31186,31386,31385,-1,31186,31187,31387,31386,-1,31187,31188,31388,31387,-1,31188,31189,31389,31388,-1,31189,31190,31390,31389,-1,31190,31191,31391,31390,-1,31191,31192,31392,31391,-1,31192,31193,31393,31392,-1,31193,31194,31394,31393,-1,31194,31195,31395,31394,-1,31195,31196,31396,31395,-1,31196,31197,31397,31396,-1,31197,31198,31398,31397,-1,31198,31199,31399,31398,-1,31200,31201,31401,31400,-1,31201,31202,31402,31401,-1,31202,31203,31403,31402,-1,31203,31204,31404,31403,-1,31204,31205,31405,31404,-1,31205,31206,31406,31405,-1,31206,31207,31407,31406,-1,31207,31208,31408,31407,-1,31208,31209,31409,31408,-1,31209,31210,31410,31409,-1,31210,31211,31411,31410,-1,31211,31212,31412,31411,-1,31212,31213,31413,31412,-1,31213,31214,31414,31413,-1,31214,31215,31415,31414,-1,31215,31216,31416,31415,-1,31216,31217,31417,31416,-1,31217,31218,31418,31417,-1,31218,31219,31419,31418,-1,31219,31220,31420,31419,-1,31220,31221,31421,31420,-1,31221,31222,31422,31421,-1,31222,31223,31423,31422,-1,31223,31224,31424,31423,-1,31224,31225,31425,31424,-1,31225,31226,31426,31425,-1,31226,31227,31427,31426,-1,31227,31228,31428,31427,-1,31228,31229,31429,31428,-1,31229,31230,31430,31429,-1,31230,31231,31431,31430,-1,31231,31232,31432,31431,-1,31232,31233,31433,31432,-1,31233,31234,31434,31433,-1,31234,31235,31435,31434,-1,31235,31236,31436,31435,-1,31236,31237,31437,31436,-1,31237,31238,31438,31437,-1,31238,31239,31439,31438,-1,31239,31240,31440,31439,-1,31240,31241,31441,31440,-1,31241,31242,31442,31441,-1,31242,31243,31443,31442,-1,31243,31244,31444,31443,-1,31244,31245,31445,31444,-1,31245,31246,31446,31445,-1,31246,31247,31447,31446,-1,31247,31248,31448,31447,-1,31248,31249,31449,31448,-1,31249,31250,31450,31449,-1,31250,31251,31451,31450,-1,31251,31252,31452,31451,-1,31252,31253,31453,31452,-1,31253,31254,31454,31453,-1,31254,31255,31455,31454,-1,31255,31256,31456,31455,-1,31256,31257,31457,31456,-1,31257,31258,31458,31457,-1,31258,31259,31459,31458,-1,31259,31260,31460,31459,-1,31260,31261,31461,31460,-1,31261,31262,31462,31461,-1,31262,31263,31463,31462,-1,31263,31264,31464,31463,-1,31264,31265,31465,31464,-1,31265,31266,31466,31465,-1,31266,31267,31467,31466,-1,31267,31268,31468,31467,-1,31268,31269,31469,31468,-1,31269,31270,31470,31469,-1,31270,31271,31471,31470,-1,31271,31272,31472,31471,-1,31272,31273,31473,31472,-1,31273,31274,31474,31473,-1,31274,31275,31475,31474,-1,31275,31276,31476,31475,-1,31276,31277,31477,31476,-1,31277,31278,31478,31477,-1,31278,31279,31479,31478,-1,31279,31280,31480,31479,-1,31280,31281,31481,31480,-1,31281,31282,31482,31481,-1,31282,31283,31483,31482,-1,31283,31284,31484,31483,-1,31284,31285,31485,31484,-1,31285,31286,31486,31485,-1,31286,31287,31487,31486,-1,31287,31288,31488,31487,-1,31288,31289,31489,31488,-1,31289,31290,31490,31489,-1,31290,31291,31491,31490,-1,31291,31292,31492,31491,-1,31292,31293,31493,31492,-1,31293,31294,31494,31493,-1,31294,31295,31495,31494,-1,31295,31296,31496,31495,-1,31296,31297,31497,31496,-1,31297,31298,31498,31497,-1,31298,31299,31499,31498,-1,31299,31300,31500,31499,-1,31300,31301,31501,31500,-1,31301,31302,31502,31501,-1,31302,31303,31503,31502,-1,31303,31304,31504,31503,-1,31304,31305,31505,31504,-1,31305,31306,31506,31505,-1,31306,31307,31507,31506,-1,31307,31308,31508,31507,-1,31308,31309,31509,31508,-1,31309,31310,31510,31509,-1,31310,31311,31511,31510,-1,31311,31312,31512,31511,-1,31312,31313,31513,31512,-1,31313,31314,31514,31513,-1,31314,31315,31515,31514,-1,31315,31316,31516,31515,-1,31316,31317,31517,31516,-1,31317,31318,31518,31517,-1,31318,31319,31519,31518,-1,31319,31320,31520,31519,-1,31320,31321,31521,31520,-1,31321,31322,31522,31521,-1,31322,31323,31523,31522,-1,31323,31324,31524,31523,-1,31324,31325,31525,31524,-1,31325,31326,31526,31525,-1,31326,31327,31527,31526,-1,31327,31328,31528,31527,-1,31328,31329,31529,31528,-1,31329,31330,31530,31529,-1,31330,31331,31531,31530,-1,31331,31332,31532,31531,-1,31332,31333,31533,31532,-1,31333,31334,31534,31533,-1,31334,31335,31535,31534,-1,31335,31336,31536,31535,-1,31336,31337,31537,31536,-1,31337,31338,31538,31537,-1,31338,31339,31539,31538,-1,31339,31340,31540,31539,-1,31340,31341,31541,31540,-1,31341,31342,31542,31541,-1,31342,31343,31543,31542,-1,31343,31344,31544,31543,-1,31344,31345,31545,31544,-1,31345,31346,31546,31545,-1,31346,31347,31547,31546,-1,31347,31348,31548,31547,-1,31348,31349,31549,31548,-1,31349,31350,31550,31549,-1,31350,31351,31551,31550,-1,31351,31352,31552,31551,-1,31352,31353,31553,31552,-1,31353,31354,31554,31553,-1,31354,31355,31555,31554,-1,31355,31356,31556,31555,-1,31356,31357,31557,31556,-1,31357,31358,31558,31557,-1,31358,31359,31559,31558,-1,31359,31360,31560,31559,-1,31360,31361,31561,31560,-1,31361,31362,31562,31561,-1,31362,31363,31563,31562,-1,31363,31364,31564,31563,-1,31364,31365,31565,31564,-1,31365,31366,31566,31565,-1,31366,31367,31567,31566,-1,31367,31368,31568,31567,-1,31368,31369,31569,31568,-1,31369,31370,31570,31569,-1,31370,31371,31571,31570,-1,31371,31372,31572,31571,-1,31372,31373,31573,31572,-1,31373,31374,31574,31573,-1,31374,31375,31575,31574,-1,31375,31376,31576,31575,-1,31376,31377,31577,31576,-1,31377,31378,31578,31577,-1,31378,31379,31579,31578,-1,31379,31380,31580,31579,-1,31380,31381,31581,31580,-1,31381,31382,31582,31581,-1,31382,31383,31583,31582,-1,31383,31384,31584,31583,-1,31384,31385,31585,31584,-1,31385,31386,31586,31585,-1,31386,31387,31587,31586,-1,31387,31388,31588,31587,-1,31388,31389,31589,31588,-1,31389,31390,31590,31589,-1,31390,31391,31591,31590,-1,31391,31392,31592,31591,-1,31392,31393,31593,31592,-1,31393,31394,31594,31593,-1,31394,31395,31595,31594,-1,31395,31396,31596,31595,-1,31396,31397,31597,31596,-1,31397,31398,31598,31597,-1,31398,31399,31599,31598,-1,31400,31401,31601,31600,-1,31401,31402,31602,31601,-1,31402,31403,31603,31602,-1,31403,31404,31604,31603,-1,31404,31405,31605,31604,-1,31405,31406,31606,31605,-1,31406,31407,31607,31606,-1,31407,31408,31608,31607,-1,31408,31409,31609,31608,-1,31409,31410,31610,31609,-1,31410,31411,31611,31610,-1,31411,31412,31612,31611,-1,31412,31413,31613,31612,-1,31413,31414,31614,31613,-1,31414,31415,31615,31614,-1,31415,31416,31616,31615,-1,31416,31417,31617,31616,-1,31417,31418,31618,31617,-1,31418,31419,31619,31618,-1,31419,31420,31620,31619,-1,31420,31421,31621,31620,-1,31421,31422,31622,31621,-1,31422,31423,31623,31622,-1,31423,31424,31624,31623,-1,31424,31425,31625,31624,-1,31425,31426,31626,31625,-1,31426,31427,31627,31626,-1,31427,31428,31628,31627,-1,31428,31429,31629,31628,-1,31429,31430,31630,31629,-1,31430,31431,31631,31630,-1,31431,31432,31632,31631,-1,31432,31433,31633,31632,-1,31433,31434,31634,31633,-1,31434,31435,31635,31634,-1,31435,31436,31636,31635,-1,31436,31437,31637,31636,-1,31437,31438,31638,31637,-1,31438,31439,31639,31638,-1,31439,31440,31640,31639,-1,31440,31441,31641,31640,-1,31441,31442,31642,31641,-1,31442,31443,31643,31642,-1,31443,31444,31644,31643,-1,31444,31445,31645,31644,-1,31445,31446,31646,31645,-1,31446,31447,31647,31646,-1,31447,31448,31648,31647,-1,31448,31449,31649,31648,-1,31449,31450,31650,31649,-1,31450,31451,31651,31650,-1,31451,31452,31652,31651,-1,31452,31453,31653,31652,-1,31453,31454,31654,31653,-1,31454,31455,31655,31654,-1,31455,31456,31656,31655,-1,31456,31457,31657,31656,-1,31457,31458,31658,31657,-1,31458,31459,31659,31658,-1,31459,31460,31660,31659,-1,31460,31461,31661,31660,-1,31461,31462,31662,31661,-1,31462,31463,31663,31662,-1,31463,31464,31664,31663,-1,31464,31465,31665,31664,-1,31465,31466,31666,31665,-1,31466,31467,31667,31666,-1,31467,31468,31668,31667,-1,31468,31469,31669,31668,-1,31469,31470,31670,31669,-1,31470,31471,31671,31670,-1,31471,31472,31672,31671,-1,31472,31473,31673,31672,-1,31473,31474,31674,31673,-1,31474,31475,31675,31674,-1,31475,31476,31676,31675,-1,31476,31477,31677,31676,-1,31477,31478,31678,31677,-1,31478,31479,31679,31678,-1,31479,31480,31680,31679,-1,31480,31481,31681,31680,-1,31481,31482,31682,31681,-1,31482,31483,31683,31682,-1,31483,31484,31684,31683,-1,31484,31485,31685,31684,-1,31485,31486,31686,31685,-1,31486,31487,31687,31686,-1,31487,31488,31688,31687,-1,31488,31489,31689,31688,-1,31489,31490,31690,31689,-1,31490,31491,31691,31690,-1,31491,31492,31692,31691,-1,31492,31493,31693,31692,-1,31493,31494,31694,31693,-1,31494,31495,31695,31694,-1,31495,31496,31696,31695,-1,31496,31497,31697,31696,-1,31497,31498,31698,31697,-1,31498,31499,31699,31698,-1,31499,31500,31700,31699,-1,31500,31501,31701,31700,-1,31501,31502,31702,31701,-1,31502,31503,31703,31702,-1,31503,31504,31704,31703,-1,31504,31505,31705,31704,-1,31505,31506,31706,31705,-1,31506,31507,31707,31706,-1,31507,31508,31708,31707,-1,31508,31509,31709,31708,-1,31509,31510,31710,31709,-1,31510,31511,31711,31710,-1,31511,31512,31712,31711,-1,31512,31513,31713,31712,-1,31513,31514,31714,31713,-1,31514,31515,31715,31714,-1,31515,31516,31716,31715,-1,31516,31517,31717,31716,-1,31517,31518,31718,31717,-1,31518,31519,31719,31718,-1,31519,31520,31720,31719,-1,31520,31521,31721,31720,-1,31521,31522,31722,31721,-1,31522,31523,31723,31722,-1,31523,31524,31724,31723,-1,31524,31525,31725,31724,-1,31525,31526,31726,31725,-1,31526,31527,31727,31726,-1,31527,31528,31728,31727,-1,31528,31529,31729,31728,-1,31529,31530,31730,31729,-1,31530,31531,31731,31730,-1,31531,31532,31732,31731,-1,31532,31533,31733,31732,-1,31533,31534,31734,31733,-1,31534,31535,31735,31734,-1,31535,31536,31736,31735,-1,31536,31537,31737,31736,-1,31537,31538,31738,31737,-1,31538,31539,31739,31738,-1,31539,31540,31740,31739,-1,31540,31541,31741,31740,-1,31541,31542,31742,31741,-1,31542,31543,31743,31742,-1,31543,31544,31744,31743,-1,31544,31545,31745,31744,-1,31545,31546,31746,31745,-1,31546,31547,31747,31746,-1,31547,31548,31748,31747,-1,31548,31549,31749,31748,-1,31549,31550,31750,31749,-1,31550,31551,31751,31750,-1,31551,31552,31752,31751,-1,31552,31553,31753,31752,-1,31553,31554,31754,31753,-1,31554,31555,31755,31754,-1,31555,31556,31756,31755,-1,31556,31557,31757,31756,-1,31557,31558,31758,31757,-1,31558,31559,31759,31758,-1,31559,31560,31760,31759,-1,31560,31561,31761,31760,-1,31561,31562,31762,31761,-1,31562,31563,31763,31762,-1,31563,31564,31764,31763,-1,31564,31565,31765,31764,-1,31565,31566,31766,31765,-1,31566,31567,31767,31766,-1,31567,31568,31768,31767,-1,31568,31569,31769,31768,-1,31569,31570,31770,31769,-1,31570,31571,31771,31770,-1,31571,31572,31772,31771,-1,31572,31573,31773,31772,-1,31573,31574,31774,31773,-1,31574,31575,31775,31774,-1,31575,31576,31776,31775,-1,31576,31577,31777,31776,-1,31577,31578,31778,31777,-1,31578,31579,31779,31778,-1,31579,31580,31780,31779,-1,31580,31581,31781,31780,-1,31581,31582,31782,31781,-1,31582,31583,31783,31782,-1,31583,31584,31784,31783,-1,31584,31585,31785,31784,-1,31585,31586,31786,31785,-1,31586,31587,31787,31786,-1,31587,31588,31788,31787,-1,31588,31589,31789,31788,-1,31589,31590,31790,31789,-1,31590,31591,31791,31790,-1,31591,31592,31792,31791,-1,31592,31593,31793,31792,-1,31593,31594,31794,31793,-1,31594,31595,31795,31794,-1,31595,31596,31796,31795,-1,31596,31597,31797,31796,-1,31597,31598,31798,31797,-1,31598,31599,31799,31798,-1,31600,31601,31801,31800,-1,31601,31602,31802,31801,-1,31602,31603,31803,31802,-1,31603,31604,31804,31803,-1,31604,31605,31805,31804,-1,31605,31606,31806,31805,-1,31606,31607,31807,31806,-1,31607,31608,31808,31807,-1,31608,31609,31809,31808,-1,31609,31610,31810,31809,-1,31610,31611,31811,31810,-1,31611,31612,31812,31811,-1,31612,31613,31813,31812,-1,31613,31614,31814,31813,-1,31614,31615,31815,31814,-1,31615,31616,31816,31815,-1,31616,31617,31817,31816,-1,31617,31618,31818,31817,-1,31618,31619,31819,31818,-1,31619,31620,31820,31819,-1,31620,31621,31821,31820,-1,31621,31622,31822,31821,-1,31622,31623,31823,31822,-1,31623,31624,31824,31823,-1,31624,31625,31825,31824,-1,31625,31626,31826,31825,-1,31626,31627,31827,31826,-1,31627,31628,31828,31827,-1,31628,31629,31829,31828,-1,31629,31630,31830,31829,-1,31630,31631,31831,31830,-1,31631,31632,31832,31831,-1,31632,31633,31833,31832,-1,31633,31634,31834,31833,-1,31634,31635,31835,31834,-1,31635,31636,31836,31835,-1,31636,31637,31837,31836,-1,31637,31638,31838,31837,-1,31638,31639,31839,31838,-1,31639,31640,31840,31839,-1,31640,31641,31841,31840,-1,31641,31642,31842,31841,-1,31642,31643,31843,31842,-1,31643,31644,31844,31843,-1,31644,31645,31845,31844,-1,31645,31646,31846,31845,-1,31646,31647,31847,31846,-1,31647,31648,31848,31847,-1,31648,31649,31849,31848,-1,31649,31650,31850,31849,-1,31650,31651,31851,31850,-1,31651,31652,31852,31851,-1,31652,31653,31853,31852,-1,31653,31654,31854,31853,-1,31654,31655,31855,31854,-1,31655,31656,31856,31855,-1,31656,31657,31857,31856,-1,31657,31658,31858,31857,-1,31658,31659,31859,31858,-1,31659,31660,31860,31859,-1,31660,31661,31861,31860,-1,31661,31662,31862,31861,-1,31662,31663,31863,31862,-1,31663,31664,31864,31863,-1,31664,31665,31865,31864,-1,31665,31666,31866,31865,-1,31666,31667,31867,31866,-1,31667,31668,31868,31867,-1,31668,31669,31869,31868,-1,31669,31670,31870,31869,-1,31670,31671,31871,31870,-1,31671,31672,31872,31871,-1,31672,31673,31873,31872,-1,31673,31674,31874,31873,-1,31674,31675,31875,31874,-1,31675,31676,31876,31875,-1,31676,31677,31877,31876,-1,31677,31678,31878,31877,-1,31678,31679,31879,31878,-1,31679,31680,31880,31879,-1,31680,31681,31881,31880,-1,31681,31682,31882,31881,-1,31682,31683,31883,31882,-1,31683,31684,31884,31883,-1,31684,31685,31885,31884,-1,31685,31686,31886,31885,-1,31686,31687,31887,31886,-1,31687,31688,31888,31887,-1,31688,31689,31889,31888,-1,31689,31690,31890,31889,-1,31690,31691,31891,31890,-1,31691,31692,31892,31891,-1,31692,31693,31893,31892,-1,31693,31694,31894,31893,-1,31694,31695,31895,31894,-1,31695,31696,31896,31895,-1,31696,31697,31897,31896,-1,31697,31698,31898,31897,-1,31698,31699,31899,31898,-1,31699,31700,31900,31899,-1,31700,31701,31901,31900,-1,31701,31702,31902,31901,-1,31702,31703,31903,31902,-1,31703,31704,31904,31903,-1,31704,31705,31905,31904,-1,31705,31706,31906,31905,-1,31706,31707,31907,31906,-1,31707,31708,31908,31907,-1,31708,31709,31909,31908,-1,31709,31710,31910,31909,-1,31710,31711,31911,31910,-1,31711,31712,31912,31911,-1,31712,31713,31913,31912,-1,31713,31714,31914,31913,-1,31714,31715,31915,31914,-1,31715,31716,31916,31915,-1,31716,31717,31917,31916,-1,31717,31718,31918,31917,-1,31718,31719,31919,31918,-1,31719,31720,31920,31919,-1,31720,31721,31921,31920,-1,31721,31722,31922,31921,-1,31722,31723,31923,31922,-1,31723,31724,31924,31923,-1,31724,31725,31925,31924,-1,31725,31726,31926,31925,-1,31726,31727,31927,31926,-1,31727,31728,31928,31927,-1,31728,31729,31929,31928,-1,31729,31730,31930,31929,-1,31730,31731,31931,31930,-1,31731,31732,31932,31931,-1,31732,31733,31933,31932,-1,31733,31734,31934,31933,-1,31734,31735,31935,31934,-1,31735,31736,31936,31935,-1,31736,31737,31937,31936,-1,31737,31738,31938,31937,-1,31738,31739,31939,31938,-1,31739,31740,31940,31939,-1,31740,31741,31941,31940,-1,31741,31742,31942,31941,-1,31742,31743,31943,31942,-1,31743,31744,31944,31943,-1,31744,31745,31945,31944,-1,31745,31746,31946,31945,-1,31746,31747,31947,31946,-1,31747,31748,31948,31947,-1,31748,31749,31949,31948,-1,31749,31750,31950,31949,-1,31750,31751,31951,31950,-1,31751,31752,31952,31951,-1,31752,31753,31953,31952,-1,31753,31754,31954,31953,-1,31754,31755,31955,31954,-1,31755,31756,31956,31955,-1,31756,31757,31957,31956,-1,31757,31758,31958,31957,-1,31758,31759,31959,31958,-1,31759,31760,31960,31959,-1,31760,31761,31961,31960,-1,31761,31762,31962,31961,-1,31762,31763,31963,31962,-1,31763,31764,31964,31963,-1,31764,31765,31965,31964,-1,31765,31766,31966,31965,-1,31766,31767,31967,31966,-1,31767,31768,31968,31967,-1,31768,31769,31969,31968,-1,31769,31770,31970,31969,-1,31770,31771,31971,31970,-1,31771,31772,31972,31971,-1,31772,31773,31973,31972,-1,31773,31774,31974,31973,-1,31774,31775,31975,31974,-1,31775,31776,31976,31975,-1,31776,31777,31977,31976,-1,31777,31778,31978,31977,-1,31778,31779,31979,31978,-1,31779,31780,31980,31979,-1,31780,31781,31981,31980,-1,31781,31782,31982,31981,-1,31782,31783,31983,31982,-1,31783,31784,31984,31983,-1,31784,31785,31985,31984,-1,31785,31786,31986,31985,-1,31786,31787,31987,31986,-1,31787,31788,31988,31987,-1,31788,31789,31989,31988,-1,31789,31790,31990,31989,-1,31790,31791,31991,31990,-1,31791,31792,31992,31991,-1,31792,31793,31993,31992,-1,31793,31794,31994,31993,-1,31794,31795,31995,31994,-1,31795,31796,31996,31995,-1,31796,31797,31997,31996,-1,31797,31798,31998,31997,-1,31798,31799,31999,31998,-1,31800,31801,32001,32,-1,31801,31802,32002,32001,-1,31802,31803,32003,32002,-1,31803,31804,32004,32003,-1,31804,31805,32005,32004,-1,31805,31806,32006,32005,-1,31806,31807,32007,32006,-1,31807,31808,32008,32007,-1,31808,31809,32009,32008,-1,31809,31810,32010,32009,-1,31810,31811,32011,32010,-1,31811,31812,32012,32011,-1,31812,31813,32013,32012,-1,31813,31814,32014,32013,-1,31814,31815,32015,32014,-1,31815,31816,32016,32015,-1,31816,31817,32017,32016,-1,31817,31818,32018,32017,-1,31818,31819,32019,32018,-1,31819,31820,32020,32019,-1,31820,31821,32021,32020,-1,31821,31822,32022,32021,-1,31822,31823,32023,32022,-1,31823,31824,32024,32023,-1,31824,31825,32025,32024,-1,31825,31826,32026,32025,-1,31826,31827,32027,32026,-1,31827,31828,32028,32027,-1,31828,31829,32029,32028,-1,31829,31830,32030,32029,-1,31830,31831,32031,32030,-1,31831,31832,32032,32031,-1,31832,31833,32033,32032,-1,31833,31834,32034,32033,-1,31834,31835,32035,32034,-1,31835,31836,32036,32035,-1,31836,31837,32037,32036,-1,31837,31838,32038,32037,-1,31838,31839,32039,32038,-1,31839,31840,32040,32039,-1,31840,31841,32041,32040,-1,31841,31842,32042,32041,-1,31842,31843,32043,32042,-1,31843,31844,32044,32043,-1,31844,31845,32045,32044,-1,31845,31846,32046,32045,-1,31846,31847,32047,32046,-1,31847,31848,32048,32047,-1,31848,31849,32049,32048,-1,31849,31850,32050,32049,-1,31850,31851,32051,32050,-1,31851,31852,32052,32051,-1,31852,31853,32053,32052,-1,31853,31854,32054,32053,-1,31854,31855,32055,32054,-1,31855,31856,32056,32055,-1,31856,31857,32057,32056,-1,31857,31858,32058,32057,-1,31858,31859,32059,32058,-1,31859,31860,32060,32059,-1,31860,31861,32061,32060,-1,31861,31862,32062,32061,-1,31862,31863,32063,32062,-1,31863,31864,32064,32063,-1,31864,31865,32065,32064,-1,31865,31866,32066,32065,-1,31866,31867,32067,32066,-1,31867,31868,32068,32067,-1,31868,31869,32069,32068,-1,31869,31870,32070,32069,-1,31870,31871,32071,32070,-1,31871,31872,32072,32071,-1,31872,31873,32073,32072,-1,31873,31874,32074,32073,-1,31874,31875,32075,32074,-1,31875,31876,32076,32075,-1,31876,31877,32077,32076,-1,31877,31878,32078,32077,-1,31878,31879,32079,32078,-1,31879,31880,32080,32079,-1,31880,31881,32081,32080,-1,31881,31882,32082,32081,-1,31882,31883,32083,32082,-1,31883,31884,32084,32083,-1,31884,31885,32085,32084,-1,31885,31886,32086,32085,-1,31886,31887,32087,32086,-1,31887,31888,32088,32087,-1,31888,31889,32089,32088,-1,31889,31890,32090,32089,-1,31890,31891,32091,32090,-1,31891,31892,32092,32091,-1,31892,31893,32093,32092,-1,31893,31894,32094,32093,-1,31894,31895,32095,32094,-1,31895,31896,32096,32095,-1,31896,31897,32097,32096,-1,31897,31898,32098,32097,-1,31898,31899,32099,32098,-1,31899,31900,32100,32099,-1,31900,31901,32101,32100,-1,31901,31902,32102,32101,-1,31902,31903,32103,32102,-1,31903,31904,32104,32103,-1,31904,31905,32105,32104,-1,31905,31906,32106,32105,-1,31906,31907,32107,32106,-1,31907,31908,32108,32107,-1,31908,31909,32109,32108,-1,31909,31910,32110,32109,-1,31910,31911,32111,32110,-1,31911,31912,32112,32111,-1,31912,31913,32113,32112,-1,31913,31914,32114,32113,-1,31914,31915,32115,32114,-1,31915,31916,32116,32115,-1,31916,31917,32117,32116,-1,31917,31918,32118,32117,-1,31918,31919,32119,32118,-1,31919,31920,32120,32119,-1,31920,31921,32121,32120,-1,31921,31922,32122,32121,-1,31922,31923,32123,32122,-1,31923,31924,32124,32123,-1,31924,31925,32125,32124,-1,31925,31926,32126,32125,-1,31926,31927,32127,32126,-1,31927,31928,32128,32127,-1,31928,31929,32129,32128,-1,31929,31930,32130,32129,-1,31930,31931,32131,32130,-1,31931,31932,32132,32131,-1,31932,31933,32133,32132,-1,31933,31934,32134,32133,-1,31934,31935,32135,32134,-1,31935,31936,32136,32135,-1,31936,31937,32137,32136,-1,31937,31938,32138,32137,-1,31938,31939,32139,32138,-1,31939,31940,32140,32139,-1,31940,31941,32141,32140,-1,31941,31942,32142,32141,-1,31942,31943,32143,32142,-1,31943,31944,32144,32143,-1,31944,31945,32145,32144,-1,31945,31946,32146,32145,-1,31946,31947,32147,32146,-1,31947,31948,32148,32147,-1,31948,31949,32149,32148,-1,31949,31950,32150,32149,-1,31950,31951,32151,32150,-1,31951,31952,32152,32151,-1,31952,31953,32153,32152,-1,31953,31954,32154,32153,-1,31954,31955,32155,32154,-1,31955,31956,32156,32155,-1,31956,31957,32157,32156,-1,31957,31958,32158,32157,-1,31958,31959,32159,32158,-1,31959,31960,32160,32159,-1,31960,31961,32161,32160,-1,31961,31962,32162,32161,-1,31962,31963,32163,32162,-1,31963,31964,32164,32163,-1,31964,31965,32165,32164,-1,31965,31966,32166,32165,-1,31966,31967,32167,32166,-1,31967,31968,32168,32167,-1,31968,31969,32169,32168,-1,31969,31970,32170,32169,-1,31970,31971,32171,32170,-1,31971,31972,32172,32171,-1,31972,31973,32173,32172,-1,31973,31974,32174,32173,-1,31974,31975,32175,32174,-1,31975,31976,32176,32175,-1,31976,31977,32177,32176,-1,31977,31978,32178,32177,-1,31978,31979,32179,32178,-1,31979,31980,32180,32179,-1,31980,31981,32181,32180,-1,31981,31982,32182,32181,-1,31982,31983,32183,32182,-1,31983,31984,32184,32183,-1,31984,31985,32185,32184,-1,31985,31986,32186,32185,-1,31986,31987,32187,32186,-1,31987,31988,32188,32187,-1,31988,31989,32189,32188,-1,31989,31990,32190,32189,-1,31990,31991,32191,32190,-1,31991,31992,32192,32191,-1,31992,31993,32193,32192,-1,31993,31994,32194,32193,-1,31994,31995,32195,32194,-1,31995,31996,32196,32195,-1,31996,31997,32197,32196,-1,31997,31998,32198,32197,-1,31998,31999,32199,32198,-1,32,32001,32201,32200,-1,32001,32002,32202,32201,-1,32002,32003,32203,32202,-1,32003,32004,32204,32203,-1,32004,32005,32205,32204,-1,32005,32006,32206,32205,-1,32006,32007,32207,32206,-1,32007,32008,32208,32207,-1,32008,32009,32209,32208,-1,32009,32010,32210,32209,-1,32010,32011,32211,32210,-1,32011,32012,32212,32211,-1,32012,32013,32213,32212,-1,32013,32014,32214,32213,-1,32014,32015,32215,32214,-1,32015,32016,32216,32215,-1,32016,32017,32217,32216,-1,32017,32018,32218,32217,-1,32018,32019,32219,32218,-1,32019,32020,32220,32219,-1,32020,32021,32221,32220,-1,32021,32022,32222,32221,-1,32022,32023,32223,32222,-1,32023,32024,32224,32223,-1,32024,32025,32225,32224,-1,32025,32026,32226,32225,-1,32026,32027,32227,32226,-1,32027,32028,32228,32227,-1,32028,32029,32229,32228,-1,32029,32030,32230,32229,-1,32030,32031,32231,32230,-1,32031,32032,32232,32231,-1,32032,32033,32233,32232,-1,32033,32034,32234,32233,-1,32034,32035,32235,32234,-1,32035,32036,32236,32235,-1,32036,32037,32237,32236,-1,32037,32038,32238,32237,-1,32038,32039,32239,32238,-1,32039,32040,32240,32239,-1,32040,32041,32241,32240,-1,32041,32042,32242,32241,-1,32042,32043,32243,32242,-1,32043,32044,32244,32243,-1,32044,32045,32245,32244,-1,32045,32046,32246,32245,-1,32046,32047,32247,32246,-1,32047,32048,32248,32247,-1,32048,32049,32249,32248,-1,32049,32050,32250,32249,-1,32050,32051,32251,32250,-1,32051,32052,32252,32251,-1,32052,32053,32253,32252,-1,32053,32054,32254,32253,-1,32054,32055,32255,32254,-1,32055,32056,32256,32255,-1,32056,32057,32257,32256,-1,32057,32058,32258,32257,-1,32058,32059,32259,32258,-1,32059,32060,32260,32259,-1,32060,32061,32261,32260,-1,32061,32062,32262,32261,-1,32062,32063,32263,32262,-1,32063,32064,32264,32263,-1,32064,32065,32265,32264,-1,32065,32066,32266,32265,-1,32066,32067,32267,32266,-1,32067,32068,32268,32267,-1,32068,32069,32269,32268,-1,32069,32070,32270,32269,-1,32070,32071,32271,32270,-1,32071,32072,32272,32271,-1,32072,32073,32273,32272,-1,32073,32074,32274,32273,-1,32074,32075,32275,32274,-1,32075,32076,32276,32275,-1,32076,32077,32277,32276,-1,32077,32078,32278,32277,-1,32078,32079,32279,32278,-1,32079,32080,32280,32279,-1,32080,32081,32281,32280,-1,32081,32082,32282,32281,-1,32082,32083,32283,32282,-1,32083,32084,32284,32283,-1,32084,32085,32285,32284,-1,32085,32086,32286,32285,-1,32086,32087,32287,32286,-1,32087,32088,32288,32287,-1,32088,32089,32289,32288,-1,32089,32090,32290,32289,-1,32090,32091,32291,32290,-1,32091,32092,32292,32291,-1,32092,32093,32293,32292,-1,32093,32094,32294,32293,-1,32094,32095,32295,32294,-1,32095,32096,32296,32295,-1,32096,32097,32297,32296,-1,32097,32098,32298,32297,-1,32098,32099,32299,32298,-1,32099,32100,32300,32299,-1,32100,32101,32301,32300,-1,32101,32102,32302,32301,-1,32102,32103,32303,32302,-1,32103,32104,32304,32303,-1,32104,32105,32305,32304,-1,32105,32106,32306,32305,-1,32106,32107,32307,32306,-1,32107,32108,32308,32307,-1,32108,32109,32309,32308,-1,32109,32110,32310,32309,-1,32110,32111,32311,32310,-1,32111,32112,32312,32311,-1,32112,32113,32313,32312,-1,32113,32114,32314,32313,-1,32114,32115,32315,32314,-1,32115,32116,32316,32315,-1,32116,32117,32317,32316,-1,32117,32118,32318,32317,-1,32118,32119,32319,32318,-1,32119,32120,32320,32319,-1,32120,32121,32321,32320,-1,32121,32122,32322,32321,-1,32122,32123,32323,32322,-1,32123,32124,32324,32323,-1,32124,32125,32325,32324,-1,32125,32126,32326,32325,-1,32126,32127,32327,32326,-1,32127,32128,32328,32327,-1,32128,32129,32329,32328,-1,32129,32130,32330,32329,-1,32130,32131,32331,32330,-1,32131,32132,32332,32331,-1,32132,32133,32333,32332,-1,32133,32134,32334,32333,-1,32134,32135,32335,32334,-1,32135,32136,32336,32335,-1,32136,32137,32337,32336,-1,32137,32138,32338,32337,-1,32138,32139,32339,32338,-1,32139,32140,32340,32339,-1,32140,32141,32341,32340,-1,32141,32142,32342,32341,-1,32142,32143,32343,32342,-1,32143,32144,32344,32343,-1,32144,32145,32345,32344,-1,32145,32146,32346,32345,-1,32146,32147,32347,32346,-1,32147,32148,32348,32347,-1,32148,32149,32349,32348,-1,32149,32150,32350,32349,-1,32150,32151,32351,32350,-1,32151,32152,32352,32351,-1,32152,32153,32353,32352,-1,32153,32154,32354,32353,-1,32154,32155,32355,32354,-1,32155,32156,32356,32355,-1,32156,32157,32357,32356,-1,32157,32158,32358,32357,-1,32158,32159,32359,32358,-1,32159,32160,32360,32359,-1,32160,32161,32361,32360,-1,32161,32162,32362,32361,-1,32162,32163,32363,32362,-1,32163,32164,32364,32363,-1,32164,32165,32365,32364,-1,32165,32166,32366,32365,-1,32166,32167,32367,32366,-1,32167,32168,32368,32367,-1,32168,32169,32369,32368,-1,32169,32170,32370,32369,-1,32170,32171,32371,32370,-1,32171,32172,32372,32371,-1,32172,32173,32373,32372,-1,32173,32174,32374,32373,-1,32174,32175,32375,32374,-1,32175,32176,32376,32375,-1,32176,32177,32377,32376,-1,32177,32178,32378,32377,-1,32178,32179,32379,32378,-1,32179,32180,32380,32379,-1,32180,32181,32381,32380,-1,32181,32182,32382,32381,-1,32182,32183,32383,32382,-1,32183,32184,32384,32383,-1,32184,32185,32385,32384,-1,32185,32186,32386,32385,-1,32186,32187,32387,32386,-1,32187,32188,32388,32387,-1,32188,32189,32389,32388,-1,32189,32190,32390,32389,-1,32190,32191,32391,32390,-1,32191,32192,32392,32391,-1,32192,32193,32393,32392,-1,32193,32194,32394,32393,-1,32194,32195,32395,32394,-1,32195,32196,32396,32395,-1,32196,32197,32397,32396,-1,32197,32198,32398,32397,-1,32198,32199,32399,32398,-1,32200,32201,32401,32400,-1,32201,32202,32402,32401,-1,32202,32203,32403,32402,-1,32203,32204,32404,32403,-1,32204,32205,32405,32404,-1,32205,32206,32406,32405,-1,32206,32207,32407,32406,-1,32207,32208,32408,32407,-1,32208,32209,32409,32408,-1,32209,32210,32410,32409,-1,32210,32211,32411,32410,-1,32211,32212,32412,32411,-1,32212,32213,32413,32412,-1,32213,32214,32414,32413,-1,32214,32215,32415,32414,-1,32215,32216,32416,32415,-1,32216,32217,32417,32416,-1,32217,32218,32418,32417,-1,32218,32219,32419,32418,-1,32219,32220,32420,32419,-1,32220,32221,32421,32420,-1,32221,32222,32422,32421,-1,32222,32223,32423,32422,-1,32223,32224,32424,32423,-1,32224,32225,32425,32424,-1,32225,32226,32426,32425,-1,32226,32227,32427,32426,-1,32227,32228,32428,32427,-1,32228,32229,32429,32428,-1,32229,32230,32430,32429,-1,32230,32231,32431,32430,-1,32231,32232,32432,32431,-1,32232,32233,32433,32432,-1,32233,32234,32434,32433,-1,32234,32235,32435,32434,-1,32235,32236,32436,32435,-1,32236,32237,32437,32436,-1,32237,32238,32438,32437,-1,32238,32239,32439,32438,-1,32239,32240,32440,32439,-1,32240,32241,32441,32440,-1,32241,32242,32442,32441,-1,32242,32243,32443,32442,-1,32243,32244,32444,32443,-1,32244,32245,32445,32444,-1,32245,32246,32446,32445,-1,32246,32247,32447,32446,-1,32247,32248,32448,32447,-1,32248,32249,32449,32448,-1,32249,32250,32450,32449,-1,32250,32251,32451,32450,-1,32251,32252,32452,32451,-1,32252,32253,32453,32452,-1,32253,32254,32454,32453,-1,32254,32255,32455,32454,-1,32255,32256,32456,32455,-1,32256,32257,32457,32456,-1,32257,32258,32458,32457,-1,32258,32259,32459,32458,-1,32259,32260,32460,32459,-1,32260,32261,32461,32460,-1,32261,32262,32462,32461,-1,32262,32263,32463,32462,-1,32263,32264,32464,32463,-1,32264,32265,32465,32464,-1,32265,32266,32466,32465,-1,32266,32267,32467,32466,-1,32267,32268,32468,32467,-1,32268,32269,32469,32468,-1,32269,32270,32470,32469,-1,32270,32271,32471,32470,-1,32271,32272,32472,32471,-1,32272,32273,32473,32472,-1,32273,32274,32474,32473,-1,32274,32275,32475,32474,-1,32275,32276,32476,32475,-1,32276,32277,32477,32476,-1,32277,32278,32478,32477,-1,32278,32279,32479,32478,-1,32279,32280,32480,32479,-1,32280,32281,32481,32480,-1,32281,32282,32482,32481,-1,32282,32283,32483,32482,-1,32283,32284,32484,32483,-1,32284,32285,32485,32484,-1,32285,32286,32486,32485,-1,32286,32287,32487,32486,-1,32287,32288,32488,32487,-1,32288,32289,32489,32488,-1,32289,32290,32490,32489,-1,32290,32291,32491,32490,-1,32291,32292,32492,32491,-1,32292,32293,32493,32492,-1,32293,32294,32494,32493,-1,32294,32295,32495,32494,-1,32295,32296,32496,32495,-1,32296,32297,32497,32496,-1,32297,32298,32498,32497,-1,32298,32299,32499,32498,-1,32299,32300,32500,32499,-1,32300,32301,32501,32500,-1,32301,32302,32502,32501,-1,32302,32303,32503,32502,-1,32303,32304,32504,32503,-1,32304,32305,32505,32504,-1,32305,32306,32506,32505,-1,32306,32307,32507,32506,-1,32307,32308,32508,32507,-1,32308,32309,32509,32508,-1,32309,32310,32510,32509,-1,32310,32311,32511,32510,-1,32311,32312,32512,32511,-1,32312,32313,32513,32512,-1,32313,32314,32514,32513,-1,32314,32315,32515,32514,-1,32315,32316,32516,32515,-1,32316,32317,32517,32516,-1,32317,32318,32518,32517,-1,32318,32319,32519,32518,-1,32319,32320,32520,32519,-1,32320,32321,32521,32520,-1,32321,32322,32522,32521,-1,32322,32323,32523,32522,-1,32323,32324,32524,32523,-1,32324,32325,32525,32524,-1,32325,32326,32526,32525,-1,32326,32327,32527,32526,-1,32327,32328,32528,32527,-1,32328,32329,32529,32528,-1,32329,32330,32530,32529,-1,32330,32331,32531,32530,-1,32331,32332,32532,32531,-1,32332,32333,32533,32532,-1,32333,32334,32534,32533,-1,32334,32335,32535,32534,-1,32335,32336,32536,32535,-1,32336,32337,32537,32536,-1,32337,32338,32538,32537,-1,32338,32339,32539,32538,-1,32339,32340,32540,32539,-1,32340,32341,32541,32540,-1,32341,32342,32542,32541,-1,32342,32343,32543,32542,-1,32343,32344,32544,32543,-1,32344,32345,32545,32544,-1,32345,32346,32546,32545,-1,32346,32347,32547,32546,-1,32347,32348,32548,32547,-1,32348,32349,32549,32548,-1,32349,32350,32550,32549,-1,32350,32351,32551,32550,-1,32351,32352,32552,32551,-1,32352,32353,32553,32552,-1,32353,32354,32554,32553,-1,32354,32355,32555,32554,-1,32355,32356,32556,32555,-1,32356,32357,32557,32556,-1,32357,32358,32558,32557,-1,32358,32359,32559,32558,-1,32359,32360,32560,32559,-1,32360,32361,32561,32560,-1,32361,32362,32562,32561,-1,32362,32363,32563,32562,-1,32363,32364,32564,32563,-1,32364,32365,32565,32564,-1,32365,32366,32566,32565,-1,32366,32367,32567,32566,-1,32367,32368,32568,32567,-1,32368,32369,32569,32568,-1,32369,32370,32570,32569,-1,32370,32371,32571,32570,-1,32371,32372,32572,32571,-1,32372,32373,32573,32572,-1,32373,32374,32574,32573,-1,32374,32375,32575,32574,-1,32375,32376,32576,32575,-1,32376,32377,32577,32576,-1,32377,32378,32578,32577,-1,32378,32379,32579,32578,-1,32379,32380,32580,32579,-1,32380,32381,32581,32580,-1,32381,32382,32582,32581,-1,32382,32383,32583,32582,-1,32383,32384,32584,32583,-1,32384,32385,32585,32584,-1,32385,32386,32586,32585,-1,32386,32387,32587,32586,-1,32387,32388,32588,32587,-1,32388,32389,32589,32588,-1,32389,32390,32590,32589,-1,32390,32391,32591,32590,-1,32391,32392,32592,32591,-1,32392,32393,32593,32592,-1,32393,32394,32594,32593,-1,32394,32395,32595,32594,-1,32395,32396,32596,32595,-1,32396,32397,32597,32596,-1,32397,32398,32598,32597,-1,32398,32399,32599,32598,-1,32400,32401,32601,32600,-1,32401,32402,32602,32601,-1,32402,32403,32603,32602,-1,32403,32404,32604,32603,-1,32404,32405,32605,32604,-1,32405,32406,32606,32605,-1,32406,32407,32607,32606,-1,32407,32408,32608,32607,-1,32408,32409,32609,32608,-1,32409,32410,32610,32609,-1,32410,32411,32611,32610,-1,32411,32412,32612,32611,-1,32412,32413,32613,32612,-1,32413,32414,32614,32613,-1,32414,32415,32615,32614,-1,32415,32416,32616,32615,-1,32416,32417,32617,32616,-1,32417,32418,32618,32617,-1,32418,32419,32619,32618,-1,32419,32420,32620,32619,-1,32420,32421,32621,32620,-1,32421,32422,32622,32621,-1,32422,32423,32623,32622,-1,32423,32424,32624,32623,-1,32424,32425,32625,32624,-1,32425,32426,32626,32625,-1,32426,32427,32627,32626,-1,32427,32428,32628,32627,-1,32428,32429,32629,32628,-1,32429,32430,32630,32629,-1,32430,32431,32631,32630,-1,32431,32432,32632,32631,-1,32432,32433,32633,32632,-1,32433,32434,32634,32633,-1,32434,32435,32635,32634,-1,32435,32436,32636,32635,-1,32436,32437,32637,32636,-1,32437,32438,32638,32637,-1,32438,32439,32639,32638,-1,32439,32440,32640,32639,-1,32440,32441,32641,32640,-1,32441,32442,32642,32641,-1,32442,32443,32643,32642,-1,32443,32444,32644,32643,-1,32444,32445,32645,32644,-1,32445,32446,32646,32645,-1,32446,32447,32647,32646,-1,32447,32448,32648,32647,-1,32448,32449,32649,32648,-1,32449,32450,32650,32649,-1,32450,32451,32651,32650,-1,32451,32452,32652,32651,-1,32452,32453,32653,32652,-1,32453,32454,32654,32653,-1,32454,32455,32655,32654,-1,32455,32456,32656,32655,-1,32456,32457,32657,32656,-1,32457,32458,32658,32657,-1,32458,32459,32659,32658,-1,32459,32460,32660,32659,-1,32460,32461,32661,32660,-1,32461,32462,32662,32661,-1,32462,32463,32663,32662,-1,32463,32464,32664,32663,-1,32464,32465,32665,32664,-1,32465,32466,32666,32665,-1,32466,32467,32667,32666,-1,32467,32468,32668,32667,-1,32468,32469,32669,32668,-1,32469,32470,32670,32669,-1,32470,32471,32671,32670,-1,32471,32472,32672,32671,-1,32472,32473,32673,32672,-1,32473,32474,32674,32673,-1,32474,32475,32675,32674,-1,32475,32476,32676,32675,-1,32476,32477,32677,32676,-1,32477,32478,32678,32677,-1,32478,32479,32679,32678,-1,32479,32480,32680,32679,-1,32480,32481,32681,32680,-1,32481,32482,32682,32681,-1,32482,32483,32683,32682,-1,32483,32484,32684,32683,-1,32484,32485,32685,32684,-1,32485,32486,32686,32685,-1,32486,32487,32687,32686,-1,32487,32488,32688,32687,-1,32488,32489,32689,32688,-1,32489,32490,32690,32689,-1,32490,32491,32691,32690,-1,32491,32492,32692,32691,-1,32492,32493,32693,32692,-1,32493,32494,32694,32693,-1,32494,32495,32695,32694,-1,32495,32496,32696,32695,-1,32496,32497,32697,32696,-1,32497,32498,32698,32697,-1,32498,32499,32699,32698,-1,32499,32500,32700,32699,-1,32500,32501,32701,32700,-1,32501,32502,32702,32701,-1,32502,32503,32703,32702,-1,32503,32504,32704,32703,-1,32504,32505,32705,32704,-1,32505,32506,32706,32705,-1,32506,32507,32707,32706,-1,32507,32508,32708,32707,-1,32508,32509,32709,32708,-1,32509,32510,32710,32709,-1,32510,32511,32711,32710,-1,32511,32512,32712,32711,-1,32512,32513,32713,32712,-1,32513,32514,32714,32713,-1,32514,32515,32715,32714,-1,32515,32516,32716,32715,-1,32516,32517,32717,32716,-1,32517,32518,32718,32717,-1,32518,32519,32719,32718,-1,32519,32520,32720,32719,-1,32520,32521,32721,32720,-1,32521,32522,32722,32721,-1,32522,32523,32723,32722,-1,32523,32524,32724,32723,-1,32524,32525,32725,32724,-1,32525,32526,32726,32725,-1,32526,32527,32727,32726,-1,32527,32528,32728,32727,-1,32528,32529,32729,32728,-1,32529,32530,32730,32729,-1,32530,32531,32731,32730,-1,32531,32532,32732,32731,-1,32532,32533,32733,32732,-1,32533,32534,32734,32733,-1,32534,32535,32735,32734,-1,32535,32536,32736,32735,-1,32536,32537,32737,32736,-1,32537,32538,32738,32737,-1,32538,32539,32739,32738,-1,32539,32540,32740,32739,-1,32540,32541,32741,32740,-1,32541,32542,32742,32741,-1,32542,32543,32743,32742,-1,32543,32544,32744,32743,-1,32544,32545,32745,32744,-1,32545,32546,32746,32745,-1,32546,32547,32747,32746,-1,32547,32548,32748,32747,-1,32548,32549,32749,32748,-1,32549,32550,32750,32749,-1,32550,32551,32751,32750,-1,32551,32552,32752,32751,-1,32552,32553,32753,32752,-1,32553,32554,32754,32753,-1,32554,32555,32755,32754,-1,32555,32556,32756,32755,-1,32556,32557,32757,32756,-1,32557,32558,32758,32757,-1,32558,32559,32759,32758,-1,32559,32560,32760,32759,-1,32560,32561,32761,32760,-1,32561,32562,32762,32761,-1,32562,32563,32763,32762,-1,32563,32564,32764,32763,-1,32564,32565,32765,32764,-1,32565,32566,32766,32765,-1,32566,32567,32767,32766,-1,32567,32568,32768,32767,-1,32568,32569,32769,32768,-1,32569,32570,32770,32769,-1,32570,32571,32771,32770,-1,32571,32572,32772,32771,-1,32572,32573,32773,32772,-1,32573,32574,32774,32773,-1,32574,32575,32775,32774,-1,32575,32576,32776,32775,-1,32576,32577,32777,32776,-1,32577,32578,32778,32777,-1,32578,32579,32779,32778,-1,32579,32580,32780,32779,-1,32580,32581,32781,32780,-1,32581,32582,32782,32781,-1,32582,32583,32783,32782,-1,32583,32584,32784,32783,-1,32584,32585,32785,32784,-1,32585,32586,32786,32785,-1,32586,32587,32787,32786,-1,32587,32588,32788,32787,-1,32588,32589,32789,32788,-1,32589,32590,32790,32789,-1,32590,32591,32791,32790,-1,32591,32592,32792,32791,-1,32592,32593,32793,32792,-1,32593,32594,32794,32793,-1,32594,32595,32795,32794,-1,32595,32596,32796,32795,-1,32596,32597,32797,32796,-1,32597,32598,32798,32797,-1,32598,32599,32799,32798,-1,32600,32601,32801,32800,-1,32601,32602,32802,32801,-1,32602,32603,32803,32802,-1,32603,32604,32804,32803,-1,32604,32605,32805,32804,-1,32605,32606,32806,32805,-1,32606,32607,32807,32806,-1,32607,32608,32808,32807,-1,32608,32609,32809,32808,-1,32609,32610,32810,32809,-1,32610,32611,32811,32810,-1,32611,32612,32812,32811,-1,32612,32613,32813,32812,-1,32613,32614,32814,32813,-1,32614,32615,32815,32814,-1,32615,32616,32816,32815,-1,32616,32617,32817,32816,-1,32617,32618,32818,32817,-1,32618,32619,32819,32818,-1,32619,32620,32820,32819,-1,32620,32621,32821,32820,-1,32621,32622,32822,32821,-1,32622,32623,32823,32822,-1,32623,32624,32824,32823,-1,32624,32625,32825,32824,-1,32625,32626,32826,32825,-1,32626,32627,32827,32826,-1,32627,32628,32828,32827,-1,32628,32629,32829,32828,-1,32629,32630,32830,32829,-1,32630,32631,32831,32830,-1,32631,32632,32832,32831,-1,32632,32633,32833,32832,-1,32633,32634,32834,32833,-1,32634,32635,32835,32834,-1,32635,32636,32836,32835,-1,32636,32637,32837,32836,-1,32637,32638,32838,32837,-1,32638,32639,32839,32838,-1,32639,32640,32840,32839,-1,32640,32641,32841,32840,-1,32641,32642,32842,32841,-1,32642,32643,32843,32842,-1,32643,32644,32844,32843,-1,32644,32645,32845,32844,-1,32645,32646,32846,32845,-1,32646,32647,32847,32846,-1,32647,32648,32848,32847,-1,32648,32649,32849,32848,-1,32649,32650,32850,32849,-1,32650,32651,32851,32850,-1,32651,32652,32852,32851,-1,32652,32653,32853,32852,-1,32653,32654,32854,32853,-1,32654,32655,32855,32854,-1,32655,32656,32856,32855,-1,32656,32657,32857,32856,-1,32657,32658,32858,32857,-1,32658,32659,32859,32858,-1,32659,32660,32860,32859,-1,32660,32661,32861,32860,-1,32661,32662,32862,32861,-1,32662,32663,32863,32862,-1,32663,32664,32864,32863,-1,32664,32665,32865,32864,-1,32665,32666,32866,32865,-1,32666,32667,32867,32866,-1,32667,32668,32868,32867,-1,32668,32669,32869,32868,-1,32669,32670,32870,32869,-1,32670,32671,32871,32870,-1,32671,32672,32872,32871,-1,32672,32673,32873,32872,-1,32673,32674,32874,32873,-1,32674,32675,32875,32874,-1,32675,32676,32876,32875,-1,32676,32677,32877,32876,-1,32677,32678,32878,32877,-1,32678,32679,32879,32878,-1,32679,32680,32880,32879,-1,32680,32681,32881,32880,-1,32681,32682,32882,32881,-1,32682,32683,32883,32882,-1,32683,32684,32884,32883,-1,32684,32685,32885,32884,-1,32685,32686,32886,32885,-1,32686,32687,32887,32886,-1,32687,32688,32888,32887,-1,32688,32689,32889,32888,-1,32689,32690,32890,32889,-1,32690,32691,32891,32890,-1,32691,32692,32892,32891,-1,32692,32693,32893,32892,-1,32693,32694,32894,32893,-1,32694,32695,32895,32894,-1,32695,32696,32896,32895,-1,32696,32697,32897,32896,-1,32697,32698,32898,32897,-1,32698,32699,32899,32898,-1,32699,32700,32900,32899,-1,32700,32701,32901,32900,-1,32701,32702,32902,32901,-1,32702,32703,32903,32902,-1,32703,32704,32904,32903,-1,32704,32705,32905,32904,-1,32705,32706,32906,32905,-1,32706,32707,32907,32906,-1,32707,32708,32908,32907,-1,32708,32709,32909,32908,-1,32709,32710,32910,32909,-1,32710,32711,32911,32910,-1,32711,32712,32912,32911,-1,32712,32713,32913,32912,-1,32713,32714,32914,32913,-1,32714,32715,32915,32914,-1,32715,32716,32916,32915,-1,32716,32717,32917,32916,-1,32717,32718,32918,32917,-1,32718,32719,32919,32918,-1,32719,32720,32920,32919,-1,32720,32721,32921,32920,-1,32721,32722,32922,32921,-1,32722,32723,32923,32922,-1,32723,32724,32924,32923,-1,32724,32725,32925,32924,-1,32725,32726,32926,32925,-1,32726,32727,32927,32926,-1,32727,32728,32928,32927,-1,32728,32729,32929,32928,-1,32729,32730,32930,32929,-1,32730,32731,32931,32930,-1,32731,32732,32932,32931,-1,32732,32733,32933,32932,-1,32733,32734,32934,32933,-1,32734,32735,32935,32934,-1,32735,32736,32936,32935,-1,32736,32737,32937,32936,-1,32737,32738,32938,32937,-1,32738,32739,32939,32938,-1,32739,32740,32940,32939,-1,32740,32741,32941,32940,-1,32741,32742,32942,32941,-1,32742,32743,32943,32942,-1,32743,32744,32944,32943,-1,32744,32745,32945,32944,-1,32745,32746,32946,32945,-1,32746,32747,32947,32946,-1,32747,32748,32948,32947,-1,32748,32749,32949,32948,-1,32749,32750,32950,32949,-1,32750,32751,32951,32950,-1,32751,32752,32952,32951,-1,32752,32753,32953,32952,-1,32753,32754,32954,32953,-1,32754,32755,32955,32954,-1,32755,32756,32956,32955,-1,32756,32757,32957,32956,-1,32757,32758,32958,32957,-1,32758,32759,32959,32958,-1,32759,32760,32960,32959,-1,32760,32761,32961,32960,-1,32761,32762,32962,32961,-1,32762,32763,32963,32962,-1,32763,32764,32964,32963,-1,32764,32765,32965,32964,-1,32765,32766,32966,32965,-1,32766,32767,32967,32966,-1,32767,32768,32968,32967,-1,32768,32769,32969,32968,-1,32769,32770,32970,32969,-1,32770,32771,32971,32970,-1,32771,32772,32972,32971,-1,32772,32773,32973,32972,-1,32773,32774,32974,32973,-1,32774,32775,32975,32974,-1,32775,32776,32976,32975,-1,32776,32777,32977,32976,-1,32777,32778,32978,32977,-1,32778,32779,32979,32978,-1,32779,32780,32980,32979,-1,32780,32781,32981,32980,-1,32781,32782,32982,32981,-1,32782,32783,32983,32982,-1,32783,32784,32984,32983,-1,32784,32785,32985,32984,-1,32785,32786,32986,32985,-1,32786,32787,32987,32986,-1,32787,32788,32988,32987,-1,32788,32789,32989,32988,-1,32789,32790,32990,32989,-1,32790,32791,32991,32990,-1,32791,32792,32992,32991,-1,32792,32793,32993,32992,-1,32793,32794,32994,32993,-1,32794,32795,32995,32994,-1,32795,32796,32996,32995,-1,32796,32797,32997,32996,-1,32797,32798,32998,32997,-1,32798,32799,32999,32998,-1,32800,32801,33001,33,-1,32801,32802,33002,33001,-1,32802,32803,33003,33002,-1,32803,32804,33004,33003,-1,32804,32805,33005,33004,-1,32805,32806,33006,33005,-1,32806,32807,33007,33006,-1,32807,32808,33008,33007,-1,32808,32809,33009,33008,-1,32809,32810,33010,33009,-1,32810,32811,33011,33010,-1,32811,32812,33012,33011,-1,32812,32813,33013,33012,-1,32813,32814,33014,33013,-1,32814,32815,33015,33014,-1,32815,32816,33016,33015,-1,32816,32817,33017,33016,-1,32817,32818,33018,33017,-1,32818,32819,33019,33018,-1,32819,32820,33020,33019,-1,32820,32821,33021,33020,-1,32821,32822,33022,33021,-1,32822,32823,33023,33022,-1,32823,32824,33024,33023,-1,32824,32825,33025,33024,-1,32825,32826,33026,33025,-1,32826,32827,33027,33026,-1,32827,32828,33028,33027,-1,32828,32829,33029,33028,-1,32829,32830,33030,33029,-1,32830,32831,33031,33030,-1,32831,32832,33032,33031,-1,32832,32833,33033,33032,-1,32833,32834,33034,33033,-1,32834,32835,33035,33034,-1,32835,32836,33036,33035,-1,32836,32837,33037,33036,-1,32837,32838,33038,33037,-1,32838,32839,33039,33038,-1,32839,32840,33040,33039,-1,32840,32841,33041,33040,-1,32841,32842,33042,33041,-1,32842,32843,33043,33042,-1,32843,32844,33044,33043,-1,32844,32845,33045,33044,-1,32845,32846,33046,33045,-1,32846,32847,33047,33046,-1,32847,32848,33048,33047,-1,32848,32849,33049,33048,-1,32849,32850,33050,33049,-1,32850,32851,33051,33050,-1,32851,32852,33052,33051,-1,32852,32853,33053,33052,-1,32853,32854,33054,33053,-1,32854,32855,33055,33054,-1,32855,32856,33056,33055,-1,32856,32857,33057,33056,-1,32857,32858,33058,33057,-1,32858,32859,33059,33058,-1,32859,32860,33060,33059,-1,32860,32861,33061,33060,-1,32861,32862,33062,33061,-1,32862,32863,33063,33062,-1,32863,32864,33064,33063,-1,32864,32865,33065,33064,-1,32865,32866,33066,33065,-1,32866,32867,33067,33066,-1,32867,32868,33068,33067,-1,32868,32869,33069,33068,-1,32869,32870,33070,33069,-1,32870,32871,33071,33070,-1,32871,32872,33072,33071,-1,32872,32873,33073,33072,-1,32873,32874,33074,33073,-1,32874,32875,33075,33074,-1,32875,32876,33076,33075,-1,32876,32877,33077,33076,-1,32877,32878,33078,33077,-1,32878,32879,33079,33078,-1,32879,32880,33080,33079,-1,32880,32881,33081,33080,-1,32881,32882,33082,33081,-1,32882,32883,33083,33082,-1,32883,32884,33084,33083,-1,32884,32885,33085,33084,-1,32885,32886,33086,33085,-1,32886,32887,33087,33086,-1,32887,32888,33088,33087,-1,32888,32889,33089,33088,-1,32889,32890,33090,33089,-1,32890,32891,33091,33090,-1,32891,32892,33092,33091,-1,32892,32893,33093,33092,-1,32893,32894,33094,33093,-1,32894,32895,33095,33094,-1,32895,32896,33096,33095,-1,32896,32897,33097,33096,-1,32897,32898,33098,33097,-1,32898,32899,33099,33098,-1,32899,32900,33100,33099,-1,32900,32901,33101,33100,-1,32901,32902,33102,33101,-1,32902,32903,33103,33102,-1,32903,32904,33104,33103,-1,32904,32905,33105,33104,-1,32905,32906,33106,33105,-1,32906,32907,33107,33106,-1,32907,32908,33108,33107,-1,32908,32909,33109,33108,-1,32909,32910,33110,33109,-1,32910,32911,33111,33110,-1,32911,32912,33112,33111,-1,32912,32913,33113,33112,-1,32913,32914,33114,33113,-1,32914,32915,33115,33114,-1,32915,32916,33116,33115,-1,32916,32917,33117,33116,-1,32917,32918,33118,33117,-1,32918,32919,33119,33118,-1,32919,32920,33120,33119,-1,32920,32921,33121,33120,-1,32921,32922,33122,33121,-1,32922,32923,33123,33122,-1,32923,32924,33124,33123,-1,32924,32925,33125,33124,-1,32925,32926,33126,33125,-1,32926,32927,33127,33126,-1,32927,32928,33128,33127,-1,32928,32929,33129,33128,-1,32929,32930,33130,33129,-1,32930,32931,33131,33130,-1,32931,32932,33132,33131,-1,32932,32933,33133,33132,-1,32933,32934,33134,33133,-1,32934,32935,33135,33134,-1,32935,32936,33136,33135,-1,32936,32937,33137,33136,-1,32937,32938,33138,33137,-1,32938,32939,33139,33138,-1,32939,32940,33140,33139,-1,32940,32941,33141,33140,-1,32941,32942,33142,33141,-1,32942,32943,33143,33142,-1,32943,32944,33144,33143,-1,32944,32945,33145,33144,-1,32945,32946,33146,33145,-1,32946,32947,33147,33146,-1,32947,32948,33148,33147,-1,32948,32949,33149,33148,-1,32949,32950,33150,33149,-1,32950,32951,33151,33150,-1,32951,32952,33152,33151,-1,32952,32953,33153,33152,-1,32953,32954,33154,33153,-1,32954,32955,33155,33154,-1,32955,32956,33156,33155,-1,32956,32957,33157,33156,-1,32957,32958,33158,33157,-1,32958,32959,33159,33158,-1,32959,32960,33160,33159,-1,32960,32961,33161,33160,-1,32961,32962,33162,33161,-1,32962,32963,33163,33162,-1,32963,32964,33164,33163,-1,32964,32965,33165,33164,-1,32965,32966,33166,33165,-1,32966,32967,33167,33166,-1,32967,32968,33168,33167,-1,32968,32969,33169,33168,-1,32969,32970,33170,33169,-1,32970,32971,33171,33170,-1,32971,32972,33172,33171,-1,32972,32973,33173,33172,-1,32973,32974,33174,33173,-1,32974,32975,33175,33174,-1,32975,32976,33176,33175,-1,32976,32977,33177,33176,-1,32977,32978,33178,33177,-1,32978,32979,33179,33178,-1,32979,32980,33180,33179,-1,32980,32981,33181,33180,-1,32981,32982,33182,33181,-1,32982,32983,33183,33182,-1,32983,32984,33184,33183,-1,32984,32985,33185,33184,-1,32985,32986,33186,33185,-1,32986,32987,33187,33186,-1,32987,32988,33188,33187,-1,32988,32989,33189,33188,-1,32989,32990,33190,33189,-1,32990,32991,33191,33190,-1,32991,32992,33192,33191,-1,32992,32993,33193,33192,-1,32993,32994,33194,33193,-1,32994,32995,33195,33194,-1,32995,32996,33196,33195,-1,32996,32997,33197,33196,-1,32997,32998,33198,33197,-1,32998,32999,33199,33198,-1,33,33001,33201,33200,-1,33001,33002,33202,33201,-1,33002,33003,33203,33202,-1,33003,33004,33204,33203,-1,33004,33005,33205,33204,-1,33005,33006,33206,33205,-1,33006,33007,33207,33206,-1,33007,33008,33208,33207,-1,33008,33009,33209,33208,-1,33009,33010,33210,33209,-1,33010,33011,33211,33210,-1,33011,33012,33212,33211,-1,33012,33013,33213,33212,-1,33013,33014,33214,33213,-1,33014,33015,33215,33214,-1,33015,33016,33216,33215,-1,33016,33017,33217,33216,-1,33017,33018,33218,33217,-1,33018,33019,33219,33218,-1,33019,33020,33220,33219,-1,33020,33021,33221,33220,-1,33021,33022,33222,33221,-1,33022,33023,33223,33222,-1,33023,33024,33224,33223,-1,33024,33025,33225,33224,-1,33025,33026,33226,33225,-1,33026,33027,33227,33226,-1,33027,33028,33228,33227,-1,33028,33029,33229,33228,-1,33029,33030,33230,33229,-1,33030,33031,33231,33230,-1,33031,33032,33232,33231,-1,33032,33033,33233,33232,-1,33033,33034,33234,33233,-1,33034,33035,33235,33234,-1,33035,33036,33236,33235,-1,33036,33037,33237,33236,-1,33037,33038,33238,33237,-1,33038,33039,33239,33238,-1,33039,33040,33240,33239,-1,33040,33041,33241,33240,-1,33041,33042,33242,33241,-1,33042,33043,33243,33242,-1,33043,33044,33244,33243,-1,33044,33045,33245,33244,-1,33045,33046,33246,33245,-1,33046,33047,33247,33246,-1,33047,33048,33248,33247,-1,33048,33049,33249,33248,-1,33049,33050,33250,33249,-1,33050,33051,33251,33250,-1,33051,33052,33252,33251,-1,33052,33053,33253,33252,-1,33053,33054,33254,33253,-1,33054,33055,33255,33254,-1,33055,33056,33256,33255,-1,33056,33057,33257,33256,-1,33057,33058,33258,33257,-1,33058,33059,33259,33258,-1,33059,33060,33260,33259,-1,33060,33061,33261,33260,-1,33061,33062,33262,33261,-1,33062,33063,33263,33262,-1,33063,33064,33264,33263,-1,33064,33065,33265,33264,-1,33065,33066,33266,33265,-1,33066,33067,33267,33266,-1,33067,33068,33268,33267,-1,33068,33069,33269,33268,-1,33069,33070,33270,33269,-1,33070,33071,33271,33270,-1,33071,33072,33272,33271,-1,33072,33073,33273,33272,-1,33073,33074,33274,33273,-1,33074,33075,33275,33274,-1,33075,33076,33276,33275,-1,33076,33077,33277,33276,-1,33077,33078,33278,33277,-1,33078,33079,33279,33278,-1,33079,33080,33280,33279,-1,33080,33081,33281,33280,-1,33081,33082,33282,33281,-1,33082,33083,33283,33282,-1,33083,33084,33284,33283,-1,33084,33085,33285,33284,-1,33085,33086,33286,33285,-1,33086,33087,33287,33286,-1,33087,33088,33288,33287,-1,33088,33089,33289,33288,-1,33089,33090,33290,33289,-1,33090,33091,33291,33290,-1,33091,33092,33292,33291,-1,33092,33093,33293,33292,-1,33093,33094,33294,33293,-1,33094,33095,33295,33294,-1,33095,33096,33296,33295,-1,33096,33097,33297,33296,-1,33097,33098,33298,33297,-1,33098,33099,33299,33298,-1,33099,33100,33300,33299,-1,33100,33101,33301,33300,-1,33101,33102,33302,33301,-1,33102,33103,33303,33302,-1,33103,33104,33304,33303,-1,33104,33105,33305,33304,-1,33105,33106,33306,33305,-1,33106,33107,33307,33306,-1,33107,33108,33308,33307,-1,33108,33109,33309,33308,-1,33109,33110,33310,33309,-1,33110,33111,33311,33310,-1,33111,33112,33312,33311,-1,33112,33113,33313,33312,-1,33113,33114,33314,33313,-1,33114,33115,33315,33314,-1,33115,33116,33316,33315,-1,33116,33117,33317,33316,-1,33117,33118,33318,33317,-1,33118,33119,33319,33318,-1,33119,33120,33320,33319,-1,33120,33121,33321,33320,-1,33121,33122,33322,33321,-1,33122,33123,33323,33322,-1,33123,33124,33324,33323,-1,33124,33125,33325,33324,-1,33125,33126,33326,33325,-1,33126,33127,33327,33326,-1,33127,33128,33328,33327,-1,33128,33129,33329,33328,-1,33129,33130,33330,33329,-1,33130,33131,33331,33330,-1,33131,33132,33332,33331,-1,33132,33133,33333,33332,-1,33133,33134,33334,33333,-1,33134,33135,33335,33334,-1,33135,33136,33336,33335,-1,33136,33137,33337,33336,-1,33137,33138,33338,33337,-1,33138,33139,33339,33338,-1,33139,33140,33340,33339,-1,33140,33141,33341,33340,-1,33141,33142,33342,33341,-1,33142,33143,33343,33342,-1,33143,33144,33344,33343,-1,33144,33145,33345,33344,-1,33145,33146,33346,33345,-1,33146,33147,33347,33346,-1,33147,33148,33348,33347,-1,33148,33149,33349,33348,-1,33149,33150,33350,33349,-1,33150,33151,33351,33350,-1,33151,33152,33352,33351,-1,33152,33153,33353,33352,-1,33153,33154,33354,33353,-1,33154,33155,33355,33354,-1,33155,33156,33356,33355,-1,33156,33157,33357,33356,-1,33157,33158,33358,33357,-1,33158,33159,33359,33358,-1,33159,33160,33360,33359,-1,33160,33161,33361,33360,-1,33161,33162,33362,33361,-1,33162,33163,33363,33362,-1,33163,33164,33364,33363,-1,33164,33165,33365,33364,-1,33165,33166,33366,33365,-1,33166,33167,33367,33366,-1,33167,33168,33368,33367,-1,33168,33169,33369,33368,-1,33169,33170,33370,33369,-1,33170,33171,33371,33370,-1,33171,33172,33372,33371,-1,33172,33173,33373,33372,-1,33173,33174,33374,33373,-1,33174,33175,33375,33374,-1,33175,33176,33376,33375,-1,33176,33177,33377,33376,-1,33177,33178,33378,33377,-1,33178,33179,33379,33378,-1,33179,33180,33380,33379,-1,33180,33181,33381,33380,-1,33181,33182,33382,33381,-1,33182,33183,33383,33382,-1,33183,33184,33384,33383,-1,33184,33185,33385,33384,-1,33185,33186,33386,33385,-1,33186,33187,33387,33386,-1,33187,33188,33388,33387,-1,33188,33189,33389,33388,-1,33189,33190,33390,33389,-1,33190,33191,33391,33390,-1,33191,33192,33392,33391,-1,33192,33193,33393,33392,-1,33193,33194,33394,33393,-1,33194,33195,33395,33394,-1,33195,33196,33396,33395,-1,33196,33197,33397,33396,-1,33197,33198,33398,33397,-1,33198,33199,33399,33398,-1,33200,33201,33401,33400,-1,33201,33202,33402,33401,-1,33202,33203,33403,33402,-1,33203,33204,33404,33403,-1,33204,33205,33405,33404,-1,33205,33206,33406,33405,-1,33206,33207,33407,33406,-1,33207,33208,33408,33407,-1,33208,33209,33409,33408,-1,33209,33210,33410,33409,-1,33210,33211,33411,33410,-1,33211,33212,33412,33411,-1,33212,33213,33413,33412,-1,33213,33214,33414,33413,-1,33214,33215,33415,33414,-1,33215,33216,33416,33415,-1,33216,33217,33417,33416,-1,33217,33218,33418,33417,-1,33218,33219,33419,33418,-1,33219,33220,33420,33419,-1,33220,33221,33421,33420,-1,33221,33222,33422,33421,-1,33222,33223,33423,33422,-1,33223,33224,33424,33423,-1,33224,33225,33425,33424,-1,33225,33226,33426,33425,-1,33226,33227,33427,33426,-1,33227,33228,33428,33427,-1,33228,33229,33429,33428,-1,33229,33230,33430,33429,-1,33230,33231,33431,33430,-1,33231,33232,33432,33431,-1,33232,33233,33433,33432,-1,33233,33234,33434,33433,-1,33234,33235,33435,33434,-1,33235,33236,33436,33435,-1,33236,33237,33437,33436,-1,33237,33238,33438,33437,-1,33238,33239,33439,33438,-1,33239,33240,33440,33439,-1,33240,33241,33441,33440,-1,33241,33242,33442,33441,-1,33242,33243,33443,33442,-1,33243,33244,33444,33443,-1,33244,33245,33445,33444,-1,33245,33246,33446,33445,-1,33246,33247,33447,33446,-1,33247,33248,33448,33447,-1,33248,33249,33449,33448,-1,33249,33250,33450,33449,-1,33250,33251,33451,33450,-1,33251,33252,33452,33451,-1,33252,33253,33453,33452,-1,33253,33254,33454,33453,-1,33254,33255,33455,33454,-1,33255,33256,33456,33455,-1,33256,33257,33457,33456,-1,33257,33258,33458,33457,-1,33258,33259,33459,33458,-1,33259,33260,33460,33459,-1,33260,33261,33461,33460,-1,33261,33262,33462,33461,-1,33262,33263,33463,33462,-1,33263,33264,33464,33463,-1,33264,33265,33465,33464,-1,33265,33266,33466,33465,-1,33266,33267,33467,33466,-1,33267,33268,33468,33467,-1,33268,33269,33469,33468,-1,33269,33270,33470,33469,-1,33270,33271,33471,33470,-1,33271,33272,33472,33471,-1,33272,33273,33473,33472,-1,33273,33274,33474,33473,-1,33274,33275,33475,33474,-1,33275,33276,33476,33475,-1,33276,33277,33477,33476,-1,33277,33278,33478,33477,-1,33278,33279,33479,33478,-1,33279,33280,33480,33479,-1,33280,33281,33481,33480,-1,33281,33282,33482,33481,-1,33282,33283,33483,33482,-1,33283,33284,33484,33483,-1,33284,33285,33485,33484,-1,33285,33286,33486,33485,-1,33286,33287,33487,33486,-1,33287,33288,33488,33487,-1,33288,33289,33489,33488,-1,33289,33290,33490,33489,-1,33290,33291,33491,33490,-1,33291,33292,33492,33491,-1,33292,33293,33493,33492,-1,33293,33294,33494,33493,-1,33294,33295,33495,33494,-1,33295,33296,33496,33495,-1,33296,33297,33497,33496,-1,33297,33298,33498,33497,-1,33298,33299,33499,33498,-1,33299,33300,33500,33499,-1,33300,33301,33501,33500,-1,33301,33302,33502,33501,-1,33302,33303,33503,33502,-1,33303,33304,33504,33503,-1,33304,33305,33505,33504,-1,33305,33306,33506,33505,-1,33306,33307,33507,33506,-1,33307,33308,33508,33507,-1,33308,33309,33509,33508,-1,33309,33310,33510,33509,-1,33310,33311,33511,33510,-1,33311,33312,33512,33511,-1,33312,33313,33513,33512,-1,33313,33314,33514,33513,-1,33314,33315,33515,33514,-1,33315,33316,33516,33515,-1,33316,33317,33517,33516,-1,33317,33318,33518,33517,-1,33318,33319,33519,33518,-1,33319,33320,33520,33519,-1,33320,33321,33521,33520,-1,33321,33322,33522,33521,-1,33322,33323,33523,33522,-1,33323,33324,33524,33523,-1,33324,33325,33525,33524,-1,33325,33326,33526,33525,-1,33326,33327,33527,33526,-1,33327,33328,33528,33527,-1,33328,33329,33529,33528,-1,33329,33330,33530,33529,-1,33330,33331,33531,33530,-1,33331,33332,33532,33531,-1,33332,33333,33533,33532,-1,33333,33334,33534,33533,-1,33334,33335,33535,33534,-1,33335,33336,33536,33535,-1,33336,33337,33537,33536,-1,33337,33338,33538,33537,-1,33338,33339,33539,33538,-1,33339,33340,33540,33539,-1,33340,33341,33541,33540,-1,33341,33342,33542,33541,-1,33342,33343,33543,33542,-1,33343,33344,33544,33543,-1,33344,33345,33545,33544,-1,33345,33346,33546,33545,-1,33346,33347,33547,33546,-1,33347,33348,33548,33547,-1,33348,33349,33549,33548,-1,33349,33350,33550,33549,-1,33350,33351,33551,33550,-1,33351,33352,33552,33551,-1,33352,33353,33553,33552,-1,33353,33354,33554,33553,-1,33354,33355,33555,33554,-1,33355,33356,33556,33555,-1,33356,33357,33557,33556,-1,33357,33358,33558,33557,-1,33358,33359,33559,33558,-1,33359,33360,33560,33559,-1,33360,33361,33561,33560,-1,33361,33362,33562,33561,-1,33362,33363,33563,33562,-1,33363,33364,33564,33563,-1,33364,33365,33565,33564,-1,33365,33366,33566,33565,-1,33366,33367,33567,33566,-1,33367,33368,33568,33567,-1,33368,33369,33569,33568,-1,33369,33370,33570,33569,-1,33370,33371,33571,33570,-1,33371,33372,33572,33571,-1,33372,33373,33573,33572,-1,33373,33374,33574,33573,-1,33374,33375,33575,33574,-1,33375,33376,33576,33575,-1,33376,33377,33577,33576,-1,33377,33378,33578,33577,-1,33378,33379,33579,33578,-1,33379,33380,33580,33579,-1,33380,33381,33581,33580,-1,33381,33382,33582,33581,-1,33382,33383,33583,33582,-1,33383,33384,33584,33583,-1,33384,33385,33585,33584,-1,33385,33386,33586,33585,-1,33386,33387,33587,33586,-1,33387,33388,33588,33587,-1,33388,33389,33589,33588,-1,33389,33390,33590,33589,-1,33390,33391,33591,33590,-1,33391,33392,33592,33591,-1,33392,33393,33593,33592,-1,33393,33394,33594,33593,-1,33394,33395,33595,33594,-1,33395,33396,33596,33595,-1,33396,33397,33597,33596,-1,33397,33398,33598,33597,-1,33398,33399,33599,33598,-1,33400,33401,33601,33600,-1,33401,33402,33602,33601,-1,33402,33403,33603,33602,-1,33403,33404,33604,33603,-1,33404,33405,33605,33604,-1,33405,33406,33606,33605,-1,33406,33407,33607,33606,-1,33407,33408,33608,33607,-1,33408,33409,33609,33608,-1,33409,33410,33610,33609,-1,33410,33411,33611,33610,-1,33411,33412,33612,33611,-1,33412,33413,33613,33612,-1,33413,33414,33614,33613,-1,33414,33415,33615,33614,-1,33415,33416,33616,33615,-1,33416,33417,33617,33616,-1,33417,33418,33618,33617,-1,33418,33419,33619,33618,-1,33419,33420,33620,33619,-1,33420,33421,33621,33620,-1,33421,33422,33622,33621,-1,33422,33423,33623,33622,-1,33423,33424,33624,33623,-1,33424,33425,33625,33624,-1,33425,33426,33626,33625,-1,33426,33427,33627,33626,-1,33427,33428,33628,33627,-1,33428,33429,33629,33628,-1,33429,33430,33630,33629,-1,33430,33431,33631,33630,-1,33431,33432,33632,33631,-1,33432,33433,33633,33632,-1,33433,33434,33634,33633,-1,33434,33435,33635,33634,-1,33435,33436,33636,33635,-1,33436,33437,33637,33636,-1,33437,33438,33638,33637,-1,33438,33439,33639,33638,-1,33439,33440,33640,33639,-1,33440,33441,33641,33640,-1,33441,33442,33642,33641,-1,33442,33443,33643,33642,-1,33443,33444,33644,33643,-1,33444,33445,33645,33644,-1,33445,33446,33646,33645,-1,33446,33447,33647,33646,-1,33447,33448,33648,33647,-1,33448,33449,33649,33648,-1,33449,33450,33650,33649,-1,33450,33451,33651,33650,-1,33451,33452,33652,33651,-1,33452,33453,33653,33652,-1,33453,33454,33654,33653,-1,33454,33455,33655,33654,-1,33455,33456,33656,33655,-1,33456,33457,33657,33656,-1,33457,33458,33658,33657,-1,33458,33459,33659,33658,-1,33459,33460,33660,33659,-1,33460,33461,33661,33660,-1,33461,33462,33662,33661,-1,33462,33463,33663,33662,-1,33463,33464,33664,33663,-1,33464,33465,33665,33664,-1,33465,33466,33666,33665,-1,33466,33467,33667,33666,-1,33467,33468,33668,33667,-1,33468,33469,33669,33668,-1,33469,33470,33670,33669,-1,33470,33471,33671,33670,-1,33471,33472,33672,33671,-1,33472,33473,33673,33672,-1,33473,33474,33674,33673,-1,33474,33475,33675,33674,-1,33475,33476,33676,33675,-1,33476,33477,33677,33676,-1,33477,33478,33678,33677,-1,33478,33479,33679,33678,-1,33479,33480,33680,33679,-1,33480,33481,33681,33680,-1,33481,33482,33682,33681,-1,33482,33483,33683,33682,-1,33483,33484,33684,33683,-1,33484,33485,33685,33684,-1,33485,33486,33686,33685,-1,33486,33487,33687,33686,-1,33487,33488,33688,33687,-1,33488,33489,33689,33688,-1,33489,33490,33690,33689,-1,33490,33491,33691,33690,-1,33491,33492,33692,33691,-1,33492,33493,33693,33692,-1,33493,33494,33694,33693,-1,33494,33495,33695,33694,-1,33495,33496,33696,33695,-1,33496,33497,33697,33696,-1,33497,33498,33698,33697,-1,33498,33499,33699,33698,-1,33499,33500,33700,33699,-1,33500,33501,33701,33700,-1,33501,33502,33702,33701,-1,33502,33503,33703,33702,-1,33503,33504,33704,33703,-1,33504,33505,33705,33704,-1,33505,33506,33706,33705,-1,33506,33507,33707,33706,-1,33507,33508,33708,33707,-1,33508,33509,33709,33708,-1,33509,33510,33710,33709,-1,33510,33511,33711,33710,-1,33511,33512,33712,33711,-1,33512,33513,33713,33712,-1,33513,33514,33714,33713,-1,33514,33515,33715,33714,-1,33515,33516,33716,33715,-1,33516,33517,33717,33716,-1,33517,33518,33718,33717,-1,33518,33519,33719,33718,-1,33519,33520,33720,33719,-1,33520,33521,33721,33720,-1,33521,33522,33722,33721,-1,33522,33523,33723,33722,-1,33523,33524,33724,33723,-1,33524,33525,33725,33724,-1,33525,33526,33726,33725,-1,33526,33527,33727,33726,-1,33527,33528,33728,33727,-1,33528,33529,33729,33728,-1,33529,33530,33730,33729,-1,33530,33531,33731,33730,-1,33531,33532,33732,33731,-1,33532,33533,33733,33732,-1,33533,33534,33734,33733,-1,33534,33535,33735,33734,-1,33535,33536,33736,33735,-1,33536,33537,33737,33736,-1,33537,33538,33738,33737,-1,33538,33539,33739,33738,-1,33539,33540,33740,33739,-1,33540,33541,33741,33740,-1,33541,33542,33742,33741,-1,33542,33543,33743,33742,-1,33543,33544,33744,33743,-1,33544,33545,33745,33744,-1,33545,33546,33746,33745,-1,33546,33547,33747,33746,-1,33547,33548,33748,33747,-1,33548,33549,33749,33748,-1,33549,33550,33750,33749,-1,33550,33551,33751,33750,-1,33551,33552,33752,33751,-1,33552,33553,33753,33752,-1,33553,33554,33754,33753,-1,33554,33555,33755,33754,-1,33555,33556,33756,33755,-1,33556,33557,33757,33756,-1,33557,33558,33758,33757,-1,33558,33559,33759,33758,-1,33559,33560,33760,33759,-1,33560,33561,33761,33760,-1,33561,33562,33762,33761,-1,33562,33563,33763,33762,-1,33563,33564,33764,33763,-1,33564,33565,33765,33764,-1,33565,33566,33766,33765,-1,33566,33567,33767,33766,-1,33567,33568,33768,33767,-1,33568,33569,33769,33768,-1,33569,33570,33770,33769,-1,33570,33571,33771,33770,-1,33571,33572,33772,33771,-1,33572,33573,33773,33772,-1,33573,33574,33774,33773,-1,33574,33575,33775,33774,-1,33575,33576,33776,33775,-1,33576,33577,33777,33776,-1,33577,33578,33778,33777,-1,33578,33579,33779,33778,-1,33579,33580,33780,33779,-1,33580,33581,33781,33780,-1,33581,33582,33782,33781,-1,33582,33583,33783,33782,-1,33583,33584,33784,33783,-1,33584,33585,33785,33784,-1,33585,33586,33786,33785,-1,33586,33587,33787,33786,-1,33587,33588,33788,33787,-1,33588,33589,33789,33788,-1,33589,33590,33790,33789,-1,33590,33591,33791,33790,-1,33591,33592,33792,33791,-1,33592,33593,33793,33792,-1,33593,33594,33794,33793,-1,33594,33595,33795,33794,-1,33595,33596,33796,33795,-1,33596,33597,33797,33796,-1,33597,33598,33798,33797,-1,33598,33599,33799,33798,-1,33600,33601,33801,33800,-1,33601,33602,33802,33801,-1,33602,33603,33803,33802,-1,33603,33604,33804,33803,-1,33604,33605,33805,33804,-1,33605,33606,33806,33805,-1,33606,33607,33807,33806,-1,33607,33608,33808,33807,-1,33608,33609,33809,33808,-1,33609,33610,33810,33809,-1,33610,33611,33811,33810,-1,33611,33612,33812,33811,-1,33612,33613,33813,33812,-1,33613,33614,33814,33813,-1,33614,33615,33815,33814,-1,33615,33616,33816,33815,-1,33616,33617,33817,33816,-1,33617,33618,33818,33817,-1,33618,33619,33819,33818,-1,33619,33620,33820,33819,-1,33620,33621,33821,33820,-1,33621,33622,33822,33821,-1,33622,33623,33823,33822,-1,33623,33624,33824,33823,-1,33624,33625,33825,33824,-1,33625,33626,33826,33825,-1,33626,33627,33827,33826,-1,33627,33628,33828,33827,-1,33628,33629,33829,33828,-1,33629,33630,33830,33829,-1,33630,33631,33831,33830,-1,33631,33632,33832,33831,-1,33632,33633,33833,33832,-1,33633,33634,33834,33833,-1,33634,33635,33835,33834,-1,33635,33636,33836,33835,-1,33636,33637,33837,33836,-1,33637,33638,33838,33837,-1,33638,33639,33839,33838,-1,33639,33640,33840,33839,-1,33640,33641,33841,33840,-1,33641,33642,33842,33841,-1,33642,33643,33843,33842,-1,33643,33644,33844,33843,-1,33644,33645,33845,33844,-1,33645,33646,33846,33845,-1,33646,33647,33847,33846,-1,33647,33648,33848,33847,-1,33648,33649,33849,33848,-1,33649,33650,33850,33849,-1,33650,33651,33851,33850,-1,33651,33652,33852,33851,-1,33652,33653,33853,33852,-1,33653,33654,33854,33853,-1,33654,33655,33855,33854,-1,33655,33656,33856,33855,-1,33656,33657,33857,33856,-1,33657,33658,33858,33857,-1,33658,33659,33859,33858,-1,33659,33660,33860,33859,-1,33660,33661,33861,33860,-1,33661,33662,33862,33861,-1,33662,33663,33863,33862,-1,33663,33664,33864,33863,-1,33664,33665,33865,33864,-1,33665,33666,33866,33865,-1,33666,33667,33867,33866,-1,33667,33668,33868,33867,-1,33668,33669,33869,33868,-1,33669,33670,33870,33869,-1,33670,33671,33871,33870,-1,33671,33672,33872,33871,-1,33672,33673,33873,33872,-1,33673,33674,33874,33873,-1,33674,33675,33875,33874,-1,33675,33676,33876,33875,-1,33676,33677,33877,33876,-1,33677,33678,33878,33877,-1,33678,33679,33879,33878,-1,33679,33680,33880,33879,-1,33680,33681,33881,33880,-1,33681,33682,33882,33881,-1,33682,33683,33883,33882,-1,33683,33684,33884,33883,-1,33684,33685,33885,33884,-1,33685,33686,33886,33885,-1,33686,33687,33887,33886,-1,33687,33688,33888,33887,-1,33688,33689,33889,33888,-1,33689,33690,33890,33889,-1,33690,33691,33891,33890,-1,33691,33692,33892,33891,-1,33692,33693,33893,33892,-1,33693,33694,33894,33893,-1,33694,33695,33895,33894,-1,33695,33696,33896,33895,-1,33696,33697,33897,33896,-1,33697,33698,33898,33897,-1,33698,33699,33899,33898,-1,33699,33700,33900,33899,-1,33700,33701,33901,33900,-1,33701,33702,33902,33901,-1,33702,33703,33903,33902,-1,33703,33704,33904,33903,-1,33704,33705,33905,33904,-1,33705,33706,33906,33905,-1,33706,33707,33907,33906,-1,33707,33708,33908,33907,-1,33708,33709,33909,33908,-1,33709,33710,33910,33909,-1,33710,33711,33911,33910,-1,33711,33712,33912,33911,-1,33712,33713,33913,33912,-1,33713,33714,33914,33913,-1,33714,33715,33915,33914,-1,33715,33716,33916,33915,-1,33716,33717,33917,33916,-1,33717,33718,33918,33917,-1,33718,33719,33919,33918,-1,33719,33720,33920,33919,-1,33720,33721,33921,33920,-1,33721,33722,33922,33921,-1,33722,33723,33923,33922,-1,33723,33724,33924,33923,-1,33724,33725,33925,33924,-1,33725,33726,33926,33925,-1,33726,33727,33927,33926,-1,33727,33728,33928,33927,-1,33728,33729,33929,33928,-1,33729,33730,33930,33929,-1,33730,33731,33931,33930,-1,33731,33732,33932,33931,-1,33732,33733,33933,33932,-1,33733,33734,33934,33933,-1,33734,33735,33935,33934,-1,33735,33736,33936,33935,-1,33736,33737,33937,33936,-1,33737,33738,33938,33937,-1,33738,33739,33939,33938,-1,33739,33740,33940,33939,-1,33740,33741,33941,33940,-1,33741,33742,33942,33941,-1,33742,33743,33943,33942,-1,33743,33744,33944,33943,-1,33744,33745,33945,33944,-1,33745,33746,33946,33945,-1,33746,33747,33947,33946,-1,33747,33748,33948,33947,-1,33748,33749,33949,33948,-1,33749,33750,33950,33949,-1,33750,33751,33951,33950,-1,33751,33752,33952,33951,-1,33752,33753,33953,33952,-1,33753,33754,33954,33953,-1,33754,33755,33955,33954,-1,33755,33756,33956,33955,-1,33756,33757,33957,33956,-1,33757,33758,33958,33957,-1,33758,33759,33959,33958,-1,33759,33760,33960,33959,-1,33760,33761,33961,33960,-1,33761,33762,33962,33961,-1,33762,33763,33963,33962,-1,33763,33764,33964,33963,-1,33764,33765,33965,33964,-1,33765,33766,33966,33965,-1,33766,33767,33967,33966,-1,33767,33768,33968,33967,-1,33768,33769,33969,33968,-1,33769,33770,33970,33969,-1,33770,33771,33971,33970,-1,33771,33772,33972,33971,-1,33772,33773,33973,33972,-1,33773,33774,33974,33973,-1,33774,33775,33975,33974,-1,33775,33776,33976,33975,-1,33776,33777,33977,33976,-1,33777,33778,33978,33977,-1,33778,33779,33979,33978,-1,33779,33780,33980,33979,-1,33780,33781,33981,33980,-1,33781,33782,33982,33981,-1,33782,33783,33983,33982,-1,33783,33784,33984,33983,-1,33784,33785,33985,33984,-1,33785,33786,33986,33985,-1,33786,33787,33987,33986,-1,33787,33788,33988,33987,-1,33788,33789,33989,33988,-1,33789,33790,33990,33989,-1,33790,33791,33991,33990,-1,33791,33792,33992,33991,-1,33792,33793,33993,33992,-1,33793,33794,33994,33993,-1,33794,33795,33995,33994,-1,33795,33796,33996,33995,-1,33796,33797,33997,33996,-1,33797,33798,33998,33997,-1,33798,33799,33999,33998,-1,33800,33801,34001,34,-1,33801,33802,34002,34001,-1,33802,33803,34003,34002,-1,33803,33804,34004,34003,-1,33804,33805,34005,34004,-1,33805,33806,34006,34005,-1,33806,33807,34007,34006,-1,33807,33808,34008,34007,-1,33808,33809,34009,34008,-1,33809,33810,34010,34009,-1,33810,33811,34011,34010,-1,33811,33812,34012,34011,-1,33812,33813,34013,34012,-1,33813,33814,34014,34013,-1,33814,33815,34015,34014,-1,33815,33816,34016,34015,-1,33816,33817,34017,34016,-1,33817,33818,34018,34017,-1,33818,33819,34019,34018,-1,33819,33820,34020,34019,-1,33820,33821,34021,34020,-1,33821,33822,34022,34021,-1,33822,33823,34023,34022,-1,33823,33824,34024,34023,-1,33824,33825,34025,34024,-1,33825,33826,34026,34025,-1,33826,33827,34027,34026,-1,33827,33828,34028,34027,-1,33828,33829,34029,34028,-1,33829,33830,34030,34029,-1,33830,33831,34031,34030,-1,33831,33832,34032,34031,-1,33832,33833,34033,34032,-1,33833,33834,34034,34033,-1,33834,33835,34035,34034,-1,33835,33836,34036,34035,-1,33836,33837,34037,34036,-1,33837,33838,34038,34037,-1,33838,33839,34039,34038,-1,33839,33840,34040,34039,-1,33840,33841,34041,34040,-1,33841,33842,34042,34041,-1,33842,33843,34043,34042,-1,33843,33844,34044,34043,-1,33844,33845,34045,34044,-1,33845,33846,34046,34045,-1,33846,33847,34047,34046,-1,33847,33848,34048,34047,-1,33848,33849,34049,34048,-1,33849,33850,34050,34049,-1,33850,33851,34051,34050,-1,33851,33852,34052,34051,-1,33852,33853,34053,34052,-1,33853,33854,34054,34053,-1,33854,33855,34055,34054,-1,33855,33856,34056,34055,-1,33856,33857,34057,34056,-1,33857,33858,34058,34057,-1,33858,33859,34059,34058,-1,33859,33860,34060,34059,-1,33860,33861,34061,34060,-1,33861,33862,34062,34061,-1,33862,33863,34063,34062,-1,33863,33864,34064,34063,-1,33864,33865,34065,34064,-1,33865,33866,34066,34065,-1,33866,33867,34067,34066,-1,33867,33868,34068,34067,-1,33868,33869,34069,34068,-1,33869,33870,34070,34069,-1,33870,33871,34071,34070,-1,33871,33872,34072,34071,-1,33872,33873,34073,34072,-1,33873,33874,34074,34073,-1,33874,33875,34075,34074,-1,33875,33876,34076,34075,-1,33876,33877,34077,34076,-1,33877,33878,34078,34077,-1,33878,33879,34079,34078,-1,33879,33880,34080,34079,-1,33880,33881,34081,34080,-1,33881,33882,34082,34081,-1,33882,33883,34083,34082,-1,33883,33884,34084,34083,-1,33884,33885,34085,34084,-1,33885,33886,34086,34085,-1,33886,33887,34087,34086,-1,33887,33888,34088,34087,-1,33888,33889,34089,34088,-1,33889,33890,34090,34089,-1,33890,33891,34091,34090,-1,33891,33892,34092,34091,-1,33892,33893,34093,34092,-1,33893,33894,34094,34093,-1,33894,33895,34095,34094,-1,33895,33896,34096,34095,-1,33896,33897,34097,34096,-1,33897,33898,34098,34097,-1,33898,33899,34099,34098,-1,33899,33900,34100,34099,-1,33900,33901,34101,34100,-1,33901,33902,34102,34101,-1,33902,33903,34103,34102,-1,33903,33904,34104,34103,-1,33904,33905,34105,34104,-1,33905,33906,34106,34105,-1,33906,33907,34107,34106,-1,33907,33908,34108,34107,-1,33908,33909,34109,34108,-1,33909,33910,34110,34109,-1,33910,33911,34111,34110,-1,33911,33912,34112,34111,-1,33912,33913,34113,34112,-1,33913,33914,34114,34113,-1,33914,33915,34115,34114,-1,33915,33916,34116,34115,-1,33916,33917,34117,34116,-1,33917,33918,34118,34117,-1,33918,33919,34119,34118,-1,33919,33920,34120,34119,-1,33920,33921,34121,34120,-1,33921,33922,34122,34121,-1,33922,33923,34123,34122,-1,33923,33924,34124,34123,-1,33924,33925,34125,34124,-1,33925,33926,34126,34125,-1,33926,33927,34127,34126,-1,33927,33928,34128,34127,-1,33928,33929,34129,34128,-1,33929,33930,34130,34129,-1,33930,33931,34131,34130,-1,33931,33932,34132,34131,-1,33932,33933,34133,34132,-1,33933,33934,34134,34133,-1,33934,33935,34135,34134,-1,33935,33936,34136,34135,-1,33936,33937,34137,34136,-1,33937,33938,34138,34137,-1,33938,33939,34139,34138,-1,33939,33940,34140,34139,-1,33940,33941,34141,34140,-1,33941,33942,34142,34141,-1,33942,33943,34143,34142,-1,33943,33944,34144,34143,-1,33944,33945,34145,34144,-1,33945,33946,34146,34145,-1,33946,33947,34147,34146,-1,33947,33948,34148,34147,-1,33948,33949,34149,34148,-1,33949,33950,34150,34149,-1,33950,33951,34151,34150,-1,33951,33952,34152,34151,-1,33952,33953,34153,34152,-1,33953,33954,34154,34153,-1,33954,33955,34155,34154,-1,33955,33956,34156,34155,-1,33956,33957,34157,34156,-1,33957,33958,34158,34157,-1,33958,33959,34159,34158,-1,33959,33960,34160,34159,-1,33960,33961,34161,34160,-1,33961,33962,34162,34161,-1,33962,33963,34163,34162,-1,33963,33964,34164,34163,-1,33964,33965,34165,34164,-1,33965,33966,34166,34165,-1,33966,33967,34167,34166,-1,33967,33968,34168,34167,-1,33968,33969,34169,34168,-1,33969,33970,34170,34169,-1,33970,33971,34171,34170,-1,33971,33972,34172,34171,-1,33972,33973,34173,34172,-1,33973,33974,34174,34173,-1,33974,33975,34175,34174,-1,33975,33976,34176,34175,-1,33976,33977,34177,34176,-1,33977,33978,34178,34177,-1,33978,33979,34179,34178,-1,33979,33980,34180,34179,-1,33980,33981,34181,34180,-1,33981,33982,34182,34181,-1,33982,33983,34183,34182,-1,33983,33984,34184,34183,-1,33984,33985,34185,34184,-1,33985,33986,34186,34185,-1,33986,33987,34187,34186,-1,33987,33988,34188,34187,-1,33988,33989,34189,34188,-1,33989,33990,34190,34189,-1,33990,33991,34191,34190,-1,33991,33992,34192,34191,-1,33992,33993,34193,34192,-1,33993,33994,34194,34193,-1,33994,33995,34195,34194,-1,33995,33996,34196,34195,-1,33996,33997,34197,34196,-1,33997,33998,34198,34197,-1,33998,33999,34199,34198,-1,34,34001,34201,34200,-1,34001,34002,34202,34201,-1,34002,34003,34203,34202,-1,34003,34004,34204,34203,-1,34004,34005,34205,34204,-1,34005,34006,34206,34205,-1,34006,34007,34207,34206,-1,34007,34008,34208,34207,-1,34008,34009,34209,34208,-1,34009,34010,34210,34209,-1,34010,34011,34211,34210,-1,34011,34012,34212,34211,-1,34012,34013,34213,34212,-1,34013,34014,34214,34213,-1,34014,34015,34215,34214,-1,34015,34016,34216,34215,-1,34016,34017,34217,34216,-1,34017,34018,34218,34217,-1,34018,34019,34219,34218,-1,34019,34020,34220,34219,-1,34020,34021,34221,34220,-1,34021,34022,34222,34221,-1,34022,34023,34223,34222,-1,34023,34024,34224,34223,-1,34024,34025,34225,34224,-1,34025,34026,34226,34225,-1,34026,34027,34227,34226,-1,34027,34028,34228,34227,-1,34028,34029,34229,34228,-1,34029,34030,34230,34229,-1,34030,34031,34231,34230,-1,34031,34032,34232,34231,-1,34032,34033,34233,34232,-1,34033,34034,34234,34233,-1,34034,34035,34235,34234,-1,34035,34036,34236,34235,-1,34036,34037,34237,34236,-1,34037,34038,34238,34237,-1,34038,34039,34239,34238,-1,34039,34040,34240,34239,-1,34040,34041,34241,34240,-1,34041,34042,34242,34241,-1,34042,34043,34243,34242,-1,34043,34044,34244,34243,-1,34044,34045,34245,34244,-1,34045,34046,34246,34245,-1,34046,34047,34247,34246,-1,34047,34048,34248,34247,-1,34048,34049,34249,34248,-1,34049,34050,34250,34249,-1,34050,34051,34251,34250,-1,34051,34052,34252,34251,-1,34052,34053,34253,34252,-1,34053,34054,34254,34253,-1,34054,34055,34255,34254,-1,34055,34056,34256,34255,-1,34056,34057,34257,34256,-1,34057,34058,34258,34257,-1,34058,34059,34259,34258,-1,34059,34060,34260,34259,-1,34060,34061,34261,34260,-1,34061,34062,34262,34261,-1,34062,34063,34263,34262,-1,34063,34064,34264,34263,-1,34064,34065,34265,34264,-1,34065,34066,34266,34265,-1,34066,34067,34267,34266,-1,34067,34068,34268,34267,-1,34068,34069,34269,34268,-1,34069,34070,34270,34269,-1,34070,34071,34271,34270,-1,34071,34072,34272,34271,-1,34072,34073,34273,34272,-1,34073,34074,34274,34273,-1,34074,34075,34275,34274,-1,34075,34076,34276,34275,-1,34076,34077,34277,34276,-1,34077,34078,34278,34277,-1,34078,34079,34279,34278,-1,34079,34080,34280,34279,-1,34080,34081,34281,34280,-1,34081,34082,34282,34281,-1,34082,34083,34283,34282,-1,34083,34084,34284,34283,-1,34084,34085,34285,34284,-1,34085,34086,34286,34285,-1,34086,34087,34287,34286,-1,34087,34088,34288,34287,-1,34088,34089,34289,34288,-1,34089,34090,34290,34289,-1,34090,34091,34291,34290,-1,34091,34092,34292,34291,-1,34092,34093,34293,34292,-1,34093,34094,34294,34293,-1,34094,34095,34295,34294,-1,34095,34096,34296,34295,-1,34096,34097,34297,34296,-1,34097,34098,34298,34297,-1,34098,34099,34299,34298,-1,34099,34100,34300,34299,-1,34100,34101,34301,34300,-1,34101,34102,34302,34301,-1,34102,34103,34303,34302,-1,34103,34104,34304,34303,-1,34104,34105,34305,34304,-1,34105,34106,34306,34305,-1,34106,34107,34307,34306,-1,34107,34108,34308,34307,-1,34108,34109,34309,34308,-1,34109,34110,34310,34309,-1,34110,34111,34311,34310,-1,34111,34112,34312,34311,-1,34112,34113,34313,34312,-1,34113,34114,34314,34313,-1,34114,34115,34315,34314,-1,34115,34116,34316,34315,-1,34116,34117,34317,34316,-1,34117,34118,34318,34317,-1,34118,34119,34319,34318,-1,34119,34120,34320,34319,-1,34120,34121,34321,34320,-1,34121,34122,34322,34321,-1,34122,34123,34323,34322,-1,34123,34124,34324,34323,-1,34124,34125,34325,34324,-1,34125,34126,34326,34325,-1,34126,34127,34327,34326,-1,34127,34128,34328,34327,-1,34128,34129,34329,34328,-1,34129,34130,34330,34329,-1,34130,34131,34331,34330,-1,34131,34132,34332,34331,-1,34132,34133,34333,34332,-1,34133,34134,34334,34333,-1,34134,34135,34335,34334,-1,34135,34136,34336,34335,-1,34136,34137,34337,34336,-1,34137,34138,34338,34337,-1,34138,34139,34339,34338,-1,34139,34140,34340,34339,-1,34140,34141,34341,34340,-1,34141,34142,34342,34341,-1,34142,34143,34343,34342,-1,34143,34144,34344,34343,-1,34144,34145,34345,34344,-1,34145,34146,34346,34345,-1,34146,34147,34347,34346,-1,34147,34148,34348,34347,-1,34148,34149,34349,34348,-1,34149,34150,34350,34349,-1,34150,34151,34351,34350,-1,34151,34152,34352,34351,-1,34152,34153,34353,34352,-1,34153,34154,34354,34353,-1,34154,34155,34355,34354,-1,34155,34156,34356,34355,-1,34156,34157,34357,34356,-1,34157,34158,34358,34357,-1,34158,34159,34359,34358,-1,34159,34160,34360,34359,-1,34160,34161,34361,34360,-1,34161,34162,34362,34361,-1,34162,34163,34363,34362,-1,34163,34164,34364,34363,-1,34164,34165,34365,34364,-1,34165,34166,34366,34365,-1,34166,34167,34367,34366,-1,34167,34168,34368,34367,-1,34168,34169,34369,34368,-1,34169,34170,34370,34369,-1,34170,34171,34371,34370,-1,34171,34172,34372,34371,-1,34172,34173,34373,34372,-1,34173,34174,34374,34373,-1,34174,34175,34375,34374,-1,34175,34176,34376,34375,-1,34176,34177,34377,34376,-1,34177,34178,34378,34377,-1,34178,34179,34379,34378,-1,34179,34180,34380,34379,-1,34180,34181,34381,34380,-1,34181,34182,34382,34381,-1,34182,34183,34383,34382,-1,34183,34184,34384,34383,-1,34184,34185,34385,34384,-1,34185,34186,34386,34385,-1,34186,34187,34387,34386,-1,34187,34188,34388,34387,-1,34188,34189,34389,34388,-1,34189,34190,34390,34389,-1,34190,34191,34391,34390,-1,34191,34192,34392,34391,-1,34192,34193,34393,34392,-1,34193,34194,34394,34393,-1,34194,34195,34395,34394,-1,34195,34196,34396,34395,-1,34196,34197,34397,34396,-1,34197,34198,34398,34397,-1,34198,34199,34399,34398,-1,34200,34201,34401,34400,-1,34201,34202,34402,34401,-1,34202,34203,34403,34402,-1,34203,34204,34404,34403,-1,34204,34205,34405,34404,-1,34205,34206,34406,34405,-1,34206,34207,34407,34406,-1,34207,34208,34408,34407,-1,34208,34209,34409,34408,-1,34209,34210,34410,34409,-1,34210,34211,34411,34410,-1,34211,34212,34412,34411,-1,34212,34213,34413,34412,-1,34213,34214,34414,34413,-1,34214,34215,34415,34414,-1,34215,34216,34416,34415,-1,34216,34217,34417,34416,-1,34217,34218,34418,34417,-1,34218,34219,34419,34418,-1,34219,34220,34420,34419,-1,34220,34221,34421,34420,-1,34221,34222,34422,34421,-1,34222,34223,34423,34422,-1,34223,34224,34424,34423,-1,34224,34225,34425,34424,-1,34225,34226,34426,34425,-1,34226,34227,34427,34426,-1,34227,34228,34428,34427,-1,34228,34229,34429,34428,-1,34229,34230,34430,34429,-1,34230,34231,34431,34430,-1,34231,34232,34432,34431,-1,34232,34233,34433,34432,-1,34233,34234,34434,34433,-1,34234,34235,34435,34434,-1,34235,34236,34436,34435,-1,34236,34237,34437,34436,-1,34237,34238,34438,34437,-1,34238,34239,34439,34438,-1,34239,34240,34440,34439,-1,34240,34241,34441,34440,-1,34241,34242,34442,34441,-1,34242,34243,34443,34442,-1,34243,34244,34444,34443,-1,34244,34245,34445,34444,-1,34245,34246,34446,34445,-1,34246,34247,34447,34446,-1,34247,34248,34448,34447,-1,34248,34249,34449,34448,-1,34249,34250,34450,34449,-1,34250,34251,34451,34450,-1,34251,34252,34452,34451,-1,34252,34253,34453,34452,-1,34253,34254,34454,34453,-1,34254,34255,34455,34454,-1,34255,34256,34456,34455,-1,34256,34257,34457,34456,-1,34257,34258,34458,34457,-1,34258,34259,34459,34458,-1,34259,34260,34460,34459,-1,34260,34261,34461,34460,-1,34261,34262,34462,34461,-1,34262,34263,34463,34462,-1,34263,34264,34464,34463,-1,34264,34265,34465,34464,-1,34265,34266,34466,34465,-1,34266,34267,34467,34466,-1,34267,34268,34468,34467,-1,34268,34269,34469,34468,-1,34269,34270,34470,34469,-1,34270,34271,34471,34470,-1,34271,34272,34472,34471,-1,34272,34273,34473,34472,-1,34273,34274,34474,34473,-1,34274,34275,34475,34474,-1,34275,34276,34476,34475,-1,34276,34277,34477,34476,-1,34277,34278,34478,34477,-1,34278,34279,34479,34478,-1,34279,34280,34480,34479,-1,34280,34281,34481,34480,-1,34281,34282,34482,34481,-1,34282,34283,34483,34482,-1,34283,34284,34484,34483,-1,34284,34285,34485,34484,-1,34285,34286,34486,34485,-1,34286,34287,34487,34486,-1,34287,34288,34488,34487,-1,34288,34289,34489,34488,-1,34289,34290,34490,34489,-1,34290,34291,34491,34490,-1,34291,34292,34492,34491,-1,34292,34293,34493,34492,-1,34293,34294,34494,34493,-1,34294,34295,34495,34494,-1,34295,34296,34496,34495,-1,34296,34297,34497,34496,-1,34297,34298,34498,34497,-1,34298,34299,34499,34498,-1,34299,34300,34500,34499,-1,34300,34301,34501,34500,-1,34301,34302,34502,34501,-1,34302,34303,34503,34502,-1,34303,34304,34504,34503,-1,34304,34305,34505,34504,-1,34305,34306,34506,34505,-1,34306,34307,34507,34506,-1,34307,34308,34508,34507,-1,34308,34309,34509,34508,-1,34309,34310,34510,34509,-1,34310,34311,34511,34510,-1,34311,34312,34512,34511,-1,34312,34313,34513,34512,-1,34313,34314,34514,34513,-1,34314,34315,34515,34514,-1,34315,34316,34516,34515,-1,34316,34317,34517,34516,-1,34317,34318,34518,34517,-1,34318,34319,34519,34518,-1,34319,34320,34520,34519,-1,34320,34321,34521,34520,-1,34321,34322,34522,34521,-1,34322,34323,34523,34522,-1,34323,34324,34524,34523,-1,34324,34325,34525,34524,-1,34325,34326,34526,34525,-1,34326,34327,34527,34526,-1,34327,34328,34528,34527,-1,34328,34329,34529,34528,-1,34329,34330,34530,34529,-1,34330,34331,34531,34530,-1,34331,34332,34532,34531,-1,34332,34333,34533,34532,-1,34333,34334,34534,34533,-1,34334,34335,34535,34534,-1,34335,34336,34536,34535,-1,34336,34337,34537,34536,-1,34337,34338,34538,34537,-1,34338,34339,34539,34538,-1,34339,34340,34540,34539,-1,34340,34341,34541,34540,-1,34341,34342,34542,34541,-1,34342,34343,34543,34542,-1,34343,34344,34544,34543,-1,34344,34345,34545,34544,-1,34345,34346,34546,34545,-1,34346,34347,34547,34546,-1,34347,34348,34548,34547,-1,34348,34349,34549,34548,-1,34349,34350,34550,34549,-1,34350,34351,34551,34550,-1,34351,34352,34552,34551,-1,34352,34353,34553,34552,-1,34353,34354,34554,34553,-1,34354,34355,34555,34554,-1,34355,34356,34556,34555,-1,34356,34357,34557,34556,-1,34357,34358,34558,34557,-1,34358,34359,34559,34558,-1,34359,34360,34560,34559,-1,34360,34361,34561,34560,-1,34361,34362,34562,34561,-1,34362,34363,34563,34562,-1,34363,34364,34564,34563,-1,34364,34365,34565,34564,-1,34365,34366,34566,34565,-1,34366,34367,34567,34566,-1,34367,34368,34568,34567,-1,34368,34369,34569,34568,-1,34369,34370,34570,34569,-1,34370,34371,34571,34570,-1,34371,34372,34572,34571,-1,34372,34373,34573,34572,-1,34373,34374,34574,34573,-1,34374,34375,34575,34574,-1,34375,34376,34576,34575,-1,34376,34377,34577,34576,-1,34377,34378,34578,34577,-1,34378,34379,34579,34578,-1,34379,34380,34580,34579,-1,34380,34381,34581,34580,-1,34381,34382,34582,34581,-1,34382,34383,34583,34582,-1,34383,34384,34584,34583,-1,34384,34385,34585,34584,-1,34385,34386,34586,34585,-1,34386,34387,34587,34586,-1,34387,34388,34588,34587,-1,34388,34389,34589,34588,-1,34389,34390,34590,34589,-1,34390,34391,34591,34590,-1,34391,34392,34592,34591,-1,34392,34393,34593,34592,-1,34393,34394,34594,34593,-1,34394,34395,34595,34594,-1,34395,34396,34596,34595,-1,34396,34397,34597,34596,-1,34397,34398,34598,34597,-1,34398,34399,34599,34598,-1,34400,34401,34601,34600,-1,34401,34402,34602,34601,-1,34402,34403,34603,34602,-1,34403,34404,34604,34603,-1,34404,34405,34605,34604,-1,34405,34406,34606,34605,-1,34406,34407,34607,34606,-1,34407,34408,34608,34607,-1,34408,34409,34609,34608,-1,34409,34410,34610,34609,-1,34410,34411,34611,34610,-1,34411,34412,34612,34611,-1,34412,34413,34613,34612,-1,34413,34414,34614,34613,-1,34414,34415,34615,34614,-1,34415,34416,34616,34615,-1,34416,34417,34617,34616,-1,34417,34418,34618,34617,-1,34418,34419,34619,34618,-1,34419,34420,34620,34619,-1,34420,34421,34621,34620,-1,34421,34422,34622,34621,-1,34422,34423,34623,34622,-1,34423,34424,34624,34623,-1,34424,34425,34625,34624,-1,34425,34426,34626,34625,-1,34426,34427,34627,34626,-1,34427,34428,34628,34627,-1,34428,34429,34629,34628,-1,34429,34430,34630,34629,-1,34430,34431,34631,34630,-1,34431,34432,34632,34631,-1,34432,34433,34633,34632,-1,34433,34434,34634,34633,-1,34434,34435,34635,34634,-1,34435,34436,34636,34635,-1,34436,34437,34637,34636,-1,34437,34438,34638,34637,-1,34438,34439,34639,34638,-1,34439,34440,34640,34639,-1,34440,34441,34641,34640,-1,34441,34442,34642,34641,-1,34442,34443,34643,34642,-1,34443,34444,34644,34643,-1,34444,34445,34645,34644,-1,34445,34446,34646,34645,-1,34446,34447,34647,34646,-1,34447,34448,34648,34647,-1,34448,34449,34649,34648,-1,34449,34450,34650,34649,-1,34450,34451,34651,34650,-1,34451,34452,34652,34651,-1,34452,34453,34653,34652,-1,34453,34454,34654,34653,-1,34454,34455,34655,34654,-1,34455,34456,34656,34655,-1,34456,34457,34657,34656,-1,34457,34458,34658,34657,-1,34458,34459,34659,34658,-1,34459,34460,34660,34659,-1,34460,34461,34661,34660,-1,34461,34462,34662,34661,-1,34462,34463,34663,34662,-1,34463,34464,34664,34663,-1,34464,34465,34665,34664,-1,34465,34466,34666,34665,-1,34466,34467,34667,34666,-1,34467,34468,34668,34667,-1,34468,34469,34669,34668,-1,34469,34470,34670,34669,-1,34470,34471,34671,34670,-1,34471,34472,34672,34671,-1,34472,34473,34673,34672,-1,34473,34474,34674,34673,-1,34474,34475,34675,34674,-1,34475,34476,34676,34675,-1,34476,34477,34677,34676,-1,34477,34478,34678,34677,-1,34478,34479,34679,34678,-1,34479,34480,34680,34679,-1,34480,34481,34681,34680,-1,34481,34482,34682,34681,-1,34482,34483,34683,34682,-1,34483,34484,34684,34683,-1,34484,34485,34685,34684,-1,34485,34486,34686,34685,-1,34486,34487,34687,34686,-1,34487,34488,34688,34687,-1,34488,34489,34689,34688,-1,34489,34490,34690,34689,-1,34490,34491,34691,34690,-1,34491,34492,34692,34691,-1,34492,34493,34693,34692,-1,34493,34494,34694,34693,-1,34494,34495,34695,34694,-1,34495,34496,34696,34695,-1,34496,34497,34697,34696,-1,34497,34498,34698,34697,-1,34498,34499,34699,34698,-1,34499,34500,34700,34699,-1,34500,34501,34701,34700,-1,34501,34502,34702,34701,-1,34502,34503,34703,34702,-1,34503,34504,34704,34703,-1,34504,34505,34705,34704,-1,34505,34506,34706,34705,-1,34506,34507,34707,34706,-1,34507,34508,34708,34707,-1,34508,34509,34709,34708,-1,34509,34510,34710,34709,-1,34510,34511,34711,34710,-1,34511,34512,34712,34711,-1,34512,34513,34713,34712,-1,34513,34514,34714,34713,-1,34514,34515,34715,34714,-1,34515,34516,34716,34715,-1,34516,34517,34717,34716,-1,34517,34518,34718,34717,-1,34518,34519,34719,34718,-1,34519,34520,34720,34719,-1,34520,34521,34721,34720,-1,34521,34522,34722,34721,-1,34522,34523,34723,34722,-1,34523,34524,34724,34723,-1,34524,34525,34725,34724,-1,34525,34526,34726,34725,-1,34526,34527,34727,34726,-1,34527,34528,34728,34727,-1,34528,34529,34729,34728,-1,34529,34530,34730,34729,-1,34530,34531,34731,34730,-1,34531,34532,34732,34731,-1,34532,34533,34733,34732,-1,34533,34534,34734,34733,-1,34534,34535,34735,34734,-1,34535,34536,34736,34735,-1,34536,34537,34737,34736,-1,34537,34538,34738,34737,-1,34538,34539,34739,34738,-1,34539,34540,34740,34739,-1,34540,34541,34741,34740,-1,34541,34542,34742,34741,-1,34542,34543,34743,34742,-1,34543,34544,34744,34743,-1,34544,34545,34745,34744,-1,34545,34546,34746,34745,-1,34546,34547,34747,34746,-1,34547,34548,34748,34747,-1,34548,34549,34749,34748,-1,34549,34550,34750,34749,-1,34550,34551,34751,34750,-1,34551,34552,34752,34751,-1,34552,34553,34753,34752,-1,34553,34554,34754,34753,-1,34554,34555,34755,34754,-1,34555,34556,34756,34755,-1,34556,34557,34757,34756,-1,34557,34558,34758,34757,-1,34558,34559,34759,34758,-1,34559,34560,34760,34759,-1,34560,34561,34761,34760,-1,34561,34562,34762,34761,-1,34562,34563,34763,34762,-1,34563,34564,34764,34763,-1,34564,34565,34765,34764,-1,34565,34566,34766,34765,-1,34566,34567,34767,34766,-1,34567,34568,34768,34767,-1,34568,34569,34769,34768,-1,34569,34570,34770,34769,-1,34570,34571,34771,34770,-1,34571,34572,34772,34771,-1,34572,34573,34773,34772,-1,34573,34574,34774,34773,-1,34574,34575,34775,34774,-1,34575,34576,34776,34775,-1,34576,34577,34777,34776,-1,34577,34578,34778,34777,-1,34578,34579,34779,34778,-1,34579,34580,34780,34779,-1,34580,34581,34781,34780,-1,34581,34582,34782,34781,-1,34582,34583,34783,34782,-1,34583,34584,34784,34783,-1,34584,34585,34785,34784,-1,34585,34586,34786,34785,-1,34586,34587,34787,34786,-1,34587,34588,34788,34787,-1,34588,34589,34789,34788,-1,34589,34590,34790,34789,-1,34590,34591,34791,34790,-1,34591,34592,34792,34791,-1,34592,34593,34793,34792,-1,34593,34594,34794,34793,-1,34594,34595,34795,34794,-1,34595,34596,34796,34795,-1,34596,34597,34797,34796,-1,34597,34598,34798,34797,-1,34598,34599,34799,34798,-1,34600,34601,34801,34800,-1,34601,34602,34802,34801,-1,34602,34603,34803,34802,-1,34603,34604,34804,34803,-1,34604,34605,34805,34804,-1,34605,34606,34806,34805,-1,34606,34607,34807,34806,-1,34607,34608,34808,34807,-1,34608,34609,34809,34808,-1,34609,34610,34810,34809,-1,34610,34611,34811,34810,-1,34611,34612,34812,34811,-1,34612,34613,34813,34812,-1,34613,34614,34814,34813,-1,34614,34615,34815,34814,-1,34615,34616,34816,34815,-1,34616,34617,34817,34816,-1,34617,34618,34818,34817,-1,34618,34619,34819,34818,-1,34619,34620,34820,34819,-1,34620,34621,34821,34820,-1,34621,34622,34822,34821,-1,34622,34623,34823,34822,-1,34623,34624,34824,34823,-1,34624,34625,34825,34824,-1,34625,34626,34826,34825,-1,34626,34627,34827,34826,-1,34627,34628,34828,34827,-1,34628,34629,34829,34828,-1,34629,34630,34830,34829,-1,34630,34631,34831,34830,-1,34631,34632,34832,34831,-1,34632,34633,34833,34832,-1,34633,34634,34834,34833,-1,34634,34635,34835,34834,-1,34635,34636,34836,34835,-1,34636,34637,34837,34836,-1,34637,34638,34838,34837,-1,34638,34639,34839,34838,-1,34639,34640,34840,34839,-1,34640,34641,34841,34840,-1,34641,34642,34842,34841,-1,34642,34643,34843,34842,-1,34643,34644,34844,34843,-1,34644,34645,34845,34844,-1,34645,34646,34846,34845,-1,34646,34647,34847,34846,-1,34647,34648,34848,34847,-1,34648,34649,34849,34848,-1,34649,34650,34850,34849,-1,34650,34651,34851,34850,-1,34651,34652,34852,34851,-1,34652,34653,34853,34852,-1,34653,34654,34854,34853,-1,34654,34655,34855,34854,-1,34655,34656,34856,34855,-1,34656,34657,34857,34856,-1,34657,34658,34858,34857,-1,34658,34659,34859,34858,-1,34659,34660,34860,34859,-1,34660,34661,34861,34860,-1,34661,34662,34862,34861,-1,34662,34663,34863,34862,-1,34663,34664,34864,34863,-1,34664,34665,34865,34864,-1,34665,34666,34866,34865,-1,34666,34667,34867,34866,-1,34667,34668,34868,34867,-1,34668,34669,34869,34868,-1,34669,34670,34870,34869,-1,34670,34671,34871,34870,-1,34671,34672,34872,34871,-1,34672,34673,34873,34872,-1,34673,34674,34874,34873,-1,34674,34675,34875,34874,-1,34675,34676,34876,34875,-1,34676,34677,34877,34876,-1,34677,34678,34878,34877,-1,34678,34679,34879,34878,-1,34679,34680,34880,34879,-1,34680,34681,34881,34880,-1,34681,34682,34882,34881,-1,34682,34683,34883,34882,-1,34683,34684,34884,34883,-1,34684,34685,34885,34884,-1,34685,34686,34886,34885,-1,34686,34687,34887,34886,-1,34687,34688,34888,34887,-1,34688,34689,34889,34888,-1,34689,34690,34890,34889,-1,34690,34691,34891,34890,-1,34691,34692,34892,34891,-1,34692,34693,34893,34892,-1,34693,34694,34894,34893,-1,34694,34695,34895,34894,-1,34695,34696,34896,34895,-1,34696,34697,34897,34896,-1,34697,34698,34898,34897,-1,34698,34699,34899,34898,-1,34699,34700,34900,34899,-1,34700,34701,34901,34900,-1,34701,34702,34902,34901,-1,34702,34703,34903,34902,-1,34703,34704,34904,34903,-1,34704,34705,34905,34904,-1,34705,34706,34906,34905,-1,34706,34707,34907,34906,-1,34707,34708,34908,34907,-1,34708,34709,34909,34908,-1,34709,34710,34910,34909,-1,34710,34711,34911,34910,-1,34711,34712,34912,34911,-1,34712,34713,34913,34912,-1,34713,34714,34914,34913,-1,34714,34715,34915,34914,-1,34715,34716,34916,34915,-1,34716,34717,34917,34916,-1,34717,34718,34918,34917,-1,34718,34719,34919,34918,-1,34719,34720,34920,34919,-1,34720,34721,34921,34920,-1,34721,34722,34922,34921,-1,34722,34723,34923,34922,-1,34723,34724,34924,34923,-1,34724,34725,34925,34924,-1,34725,34726,34926,34925,-1,34726,34727,34927,34926,-1,34727,34728,34928,34927,-1,34728,34729,34929,34928,-1,34729,34730,34930,34929,-1,34730,34731,34931,34930,-1,34731,34732,34932,34931,-1,34732,34733,34933,34932,-1,34733,34734,34934,34933,-1,34734,34735,34935,34934,-1,34735,34736,34936,34935,-1,34736,34737,34937,34936,-1,34737,34738,34938,34937,-1,34738,34739,34939,34938,-1,34739,34740,34940,34939,-1,34740,34741,34941,34940,-1,34741,34742,34942,34941,-1,34742,34743,34943,34942,-1,34743,34744,34944,34943,-1,34744,34745,34945,34944,-1,34745,34746,34946,34945,-1,34746,34747,34947,34946,-1,34747,34748,34948,34947,-1,34748,34749,34949,34948,-1,34749,34750,34950,34949,-1,34750,34751,34951,34950,-1,34751,34752,34952,34951,-1,34752,34753,34953,34952,-1,34753,34754,34954,34953,-1,34754,34755,34955,34954,-1,34755,34756,34956,34955,-1,34756,34757,34957,34956,-1,34757,34758,34958,34957,-1,34758,34759,34959,34958,-1,34759,34760,34960,34959,-1,34760,34761,34961,34960,-1,34761,34762,34962,34961,-1,34762,34763,34963,34962,-1,34763,34764,34964,34963,-1,34764,34765,34965,34964,-1,34765,34766,34966,34965,-1,34766,34767,34967,34966,-1,34767,34768,34968,34967,-1,34768,34769,34969,34968,-1,34769,34770,34970,34969,-1,34770,34771,34971,34970,-1,34771,34772,34972,34971,-1,34772,34773,34973,34972,-1,34773,34774,34974,34973,-1,34774,34775,34975,34974,-1,34775,34776,34976,34975,-1,34776,34777,34977,34976,-1,34777,34778,34978,34977,-1,34778,34779,34979,34978,-1,34779,34780,34980,34979,-1,34780,34781,34981,34980,-1,34781,34782,34982,34981,-1,34782,34783,34983,34982,-1,34783,34784,34984,34983,-1,34784,34785,34985,34984,-1,34785,34786,34986,34985,-1,34786,34787,34987,34986,-1,34787,34788,34988,34987,-1,34788,34789,34989,34988,-1,34789,34790,34990,34989,-1,34790,34791,34991,34990,-1,34791,34792,34992,34991,-1,34792,34793,34993,34992,-1,34793,34794,34994,34993,-1,34794,34795,34995,34994,-1,34795,34796,34996,34995,-1,34796,34797,34997,34996,-1,34797,34798,34998,34997,-1,34798,34799,34999,34998,-1,34800,34801,35001,35,-1,34801,34802,35002,35001,-1,34802,34803,35003,35002,-1,34803,34804,35004,35003,-1,34804,34805,35005,35004,-1,34805,34806,35006,35005,-1,34806,34807,35007,35006,-1,34807,34808,35008,35007,-1,34808,34809,35009,35008,-1,34809,34810,35010,35009,-1,34810,34811,35011,35010,-1,34811,34812,35012,35011,-1,34812,34813,35013,35012,-1,34813,34814,35014,35013,-1,34814,34815,35015,35014,-1,34815,34816,35016,35015,-1,34816,34817,35017,35016,-1,34817,34818,35018,35017,-1,34818,34819,35019,35018,-1,34819,34820,35020,35019,-1,34820,34821,35021,35020,-1,34821,34822,35022,35021,-1,34822,34823,35023,35022,-1,34823,34824,35024,35023,-1,34824,34825,35025,35024,-1,34825,34826,35026,35025,-1,34826,34827,35027,35026,-1,34827,34828,35028,35027,-1,34828,34829,35029,35028,-1,34829,34830,35030,35029,-1,34830,34831,35031,35030,-1,34831,34832,35032,35031,-1,34832,34833,35033,35032,-1,34833,34834,35034,35033,-1,34834,34835,35035,35034,-1,34835,34836,35036,35035,-1,34836,34837,35037,35036,-1,34837,34838,35038,35037,-1,34838,34839,35039,35038,-1,34839,34840,35040,35039,-1,34840,34841,35041,35040,-1,34841,34842,35042,35041,-1,34842,34843,35043,35042,-1,34843,34844,35044,35043,-1,34844,34845,35045,35044,-1,34845,34846,35046,35045,-1,34846,34847,35047,35046,-1,34847,34848,35048,35047,-1,34848,34849,35049,35048,-1,34849,34850,35050,35049,-1,34850,34851,35051,35050,-1,34851,34852,35052,35051,-1,34852,34853,35053,35052,-1,34853,34854,35054,35053,-1,34854,34855,35055,35054,-1,34855,34856,35056,35055,-1,34856,34857,35057,35056,-1,34857,34858,35058,35057,-1,34858,34859,35059,35058,-1,34859,34860,35060,35059,-1,34860,34861,35061,35060,-1,34861,34862,35062,35061,-1,34862,34863,35063,35062,-1,34863,34864,35064,35063,-1,34864,34865,35065,35064,-1,34865,34866,35066,35065,-1,34866,34867,35067,35066,-1,34867,34868,35068,35067,-1,34868,34869,35069,35068,-1,34869,34870,35070,35069,-1,34870,34871,35071,35070,-1,34871,34872,35072,35071,-1,34872,34873,35073,35072,-1,34873,34874,35074,35073,-1,34874,34875,35075,35074,-1,34875,34876,35076,35075,-1,34876,34877,35077,35076,-1,34877,34878,35078,35077,-1,34878,34879,35079,35078,-1,34879,34880,35080,35079,-1,34880,34881,35081,35080,-1,34881,34882,35082,35081,-1,34882,34883,35083,35082,-1,34883,34884,35084,35083,-1,34884,34885,35085,35084,-1,34885,34886,35086,35085,-1,34886,34887,35087,35086,-1,34887,34888,35088,35087,-1,34888,34889,35089,35088,-1,34889,34890,35090,35089,-1,34890,34891,35091,35090,-1,34891,34892,35092,35091,-1,34892,34893,35093,35092,-1,34893,34894,35094,35093,-1,34894,34895,35095,35094,-1,34895,34896,35096,35095,-1,34896,34897,35097,35096,-1,34897,34898,35098,35097,-1,34898,34899,35099,35098,-1,34899,34900,35100,35099,-1,34900,34901,35101,35100,-1,34901,34902,35102,35101,-1,34902,34903,35103,35102,-1,34903,34904,35104,35103,-1,34904,34905,35105,35104,-1,34905,34906,35106,35105,-1,34906,34907,35107,35106,-1,34907,34908,35108,35107,-1,34908,34909,35109,35108,-1,34909,34910,35110,35109,-1,34910,34911,35111,35110,-1,34911,34912,35112,35111,-1,34912,34913,35113,35112,-1,34913,34914,35114,35113,-1,34914,34915,35115,35114,-1,34915,34916,35116,35115,-1,34916,34917,35117,35116,-1,34917,34918,35118,35117,-1,34918,34919,35119,35118,-1,34919,34920,35120,35119,-1,34920,34921,35121,35120,-1,34921,34922,35122,35121,-1,34922,34923,35123,35122,-1,34923,34924,35124,35123,-1,34924,34925,35125,35124,-1,34925,34926,35126,35125,-1,34926,34927,35127,35126,-1,34927,34928,35128,35127,-1,34928,34929,35129,35128,-1,34929,34930,35130,35129,-1,34930,34931,35131,35130,-1,34931,34932,35132,35131,-1,34932,34933,35133,35132,-1,34933,34934,35134,35133,-1,34934,34935,35135,35134,-1,34935,34936,35136,35135,-1,34936,34937,35137,35136,-1,34937,34938,35138,35137,-1,34938,34939,35139,35138,-1,34939,34940,35140,35139,-1,34940,34941,35141,35140,-1,34941,34942,35142,35141,-1,34942,34943,35143,35142,-1,34943,34944,35144,35143,-1,34944,34945,35145,35144,-1,34945,34946,35146,35145,-1,34946,34947,35147,35146,-1,34947,34948,35148,35147,-1,34948,34949,35149,35148,-1,34949,34950,35150,35149,-1,34950,34951,35151,35150,-1,34951,34952,35152,35151,-1,34952,34953,35153,35152,-1,34953,34954,35154,35153,-1,34954,34955,35155,35154,-1,34955,34956,35156,35155,-1,34956,34957,35157,35156,-1,34957,34958,35158,35157,-1,34958,34959,35159,35158,-1,34959,34960,35160,35159,-1,34960,34961,35161,35160,-1,34961,34962,35162,35161,-1,34962,34963,35163,35162,-1,34963,34964,35164,35163,-1,34964,34965,35165,35164,-1,34965,34966,35166,35165,-1,34966,34967,35167,35166,-1,34967,34968,35168,35167,-1,34968,34969,35169,35168,-1,34969,34970,35170,35169,-1,34970,34971,35171,35170,-1,34971,34972,35172,35171,-1,34972,34973,35173,35172,-1,34973,34974,35174,35173,-1,34974,34975,35175,35174,-1,34975,34976,35176,35175,-1,34976,34977,35177,35176,-1,34977,34978,35178,35177,-1,34978,34979,35179,35178,-1,34979,34980,35180,35179,-1,34980,34981,35181,35180,-1,34981,34982,35182,35181,-1,34982,34983,35183,35182,-1,34983,34984,35184,35183,-1,34984,34985,35185,35184,-1,34985,34986,35186,35185,-1,34986,34987,35187,35186,-1,34987,34988,35188,35187,-1,34988,34989,35189,35188,-1,34989,34990,35190,35189,-1,34990,34991,35191,35190,-1,34991,34992,35192,35191,-1,34992,34993,35193,35192,-1,34993,34994,35194,35193,-1,34994,34995,35195,35194,-1,34995,34996,35196,35195,-1,34996,34997,35197,35196,-1,34997,34998,35198,35197,-1,34998,34999,35199,35198,-1,35,35001,35201,35200,-1,35001,35002,35202,35201,-1,35002,35003,35203,35202,-1,35003,35004,35204,35203,-1,35004,35005,35205,35204,-1,35005,35006,35206,35205,-1,35006,35007,35207,35206,-1,35007,35008,35208,35207,-1,35008,35009,35209,35208,-1,35009,35010,35210,35209,-1,35010,35011,35211,35210,-1,35011,35012,35212,35211,-1,35012,35013,35213,35212,-1,35013,35014,35214,35213,-1,35014,35015,35215,35214,-1,35015,35016,35216,35215,-1,35016,35017,35217,35216,-1,35017,35018,35218,35217,-1,35018,35019,35219,35218,-1,35019,35020,35220,35219,-1,35020,35021,35221,35220,-1,35021,35022,35222,35221,-1,35022,35023,35223,35222,-1,35023,35024,35224,35223,-1,35024,35025,35225,35224,-1,35025,35026,35226,35225,-1,35026,35027,35227,35226,-1,35027,35028,35228,35227,-1,35028,35029,35229,35228,-1,35029,35030,35230,35229,-1,35030,35031,35231,35230,-1,35031,35032,35232,35231,-1,35032,35033,35233,35232,-1,35033,35034,35234,35233,-1,35034,35035,35235,35234,-1,35035,35036,35236,35235,-1,35036,35037,35237,35236,-1,35037,35038,35238,35237,-1,35038,35039,35239,35238,-1,35039,35040,35240,35239,-1,35040,35041,35241,35240,-1,35041,35042,35242,35241,-1,35042,35043,35243,35242,-1,35043,35044,35244,35243,-1,35044,35045,35245,35244,-1,35045,35046,35246,35245,-1,35046,35047,35247,35246,-1,35047,35048,35248,35247,-1,35048,35049,35249,35248,-1,35049,35050,35250,35249,-1,35050,35051,35251,35250,-1,35051,35052,35252,35251,-1,35052,35053,35253,35252,-1,35053,35054,35254,35253,-1,35054,35055,35255,35254,-1,35055,35056,35256,35255,-1,35056,35057,35257,35256,-1,35057,35058,35258,35257,-1,35058,35059,35259,35258,-1,35059,35060,35260,35259,-1,35060,35061,35261,35260,-1,35061,35062,35262,35261,-1,35062,35063,35263,35262,-1,35063,35064,35264,35263,-1,35064,35065,35265,35264,-1,35065,35066,35266,35265,-1,35066,35067,35267,35266,-1,35067,35068,35268,35267,-1,35068,35069,35269,35268,-1,35069,35070,35270,35269,-1,35070,35071,35271,35270,-1,35071,35072,35272,35271,-1,35072,35073,35273,35272,-1,35073,35074,35274,35273,-1,35074,35075,35275,35274,-1,35075,35076,35276,35275,-1,35076,35077,35277,35276,-1,35077,35078,35278,35277,-1,35078,35079,35279,35278,-1,35079,35080,35280,35279,-1,35080,35081,35281,35280,-1,35081,35082,35282,35281,-1,35082,35083,35283,35282,-1,35083,35084,35284,35283,-1,35084,35085,35285,35284,-1,35085,35086,35286,35285,-1,35086,35087,35287,35286,-1,35087,35088,35288,35287,-1,35088,35089,35289,35288,-1,35089,35090,35290,35289,-1,35090,35091,35291,35290,-1,35091,35092,35292,35291,-1,35092,35093,35293,35292,-1,35093,35094,35294,35293,-1,35094,35095,35295,35294,-1,35095,35096,35296,35295,-1,35096,35097,35297,35296,-1,35097,35098,35298,35297,-1,35098,35099,35299,35298,-1,35099,35100,35300,35299,-1,35100,35101,35301,35300,-1,35101,35102,35302,35301,-1,35102,35103,35303,35302,-1,35103,35104,35304,35303,-1,35104,35105,35305,35304,-1,35105,35106,35306,35305,-1,35106,35107,35307,35306,-1,35107,35108,35308,35307,-1,35108,35109,35309,35308,-1,35109,35110,35310,35309,-1,35110,35111,35311,35310,-1,35111,35112,35312,35311,-1,35112,35113,35313,35312,-1,35113,35114,35314,35313,-1,35114,35115,35315,35314,-1,35115,35116,35316,35315,-1,35116,35117,35317,35316,-1,35117,35118,35318,35317,-1,35118,35119,35319,35318,-1,35119,35120,35320,35319,-1,35120,35121,35321,35320,-1,35121,35122,35322,35321,-1,35122,35123,35323,35322,-1,35123,35124,35324,35323,-1,35124,35125,35325,35324,-1,35125,35126,35326,35325,-1,35126,35127,35327,35326,-1,35127,35128,35328,35327,-1,35128,35129,35329,35328,-1,35129,35130,35330,35329,-1,35130,35131,35331,35330,-1,35131,35132,35332,35331,-1,35132,35133,35333,35332,-1,35133,35134,35334,35333,-1,35134,35135,35335,35334,-1,35135,35136,35336,35335,-1,35136,35137,35337,35336,-1,35137,35138,35338,35337,-1,35138,35139,35339,35338,-1,35139,35140,35340,35339,-1,35140,35141,35341,35340,-1,35141,35142,35342,35341,-1,35142,35143,35343,35342,-1,35143,35144,35344,35343,-1,35144,35145,35345,35344,-1,35145,35146,35346,35345,-1,35146,35147,35347,35346,-1,35147,35148,35348,35347,-1,35148,35149,35349,35348,-1,35149,35150,35350,35349,-1,35150,35151,35351,35350,-1,35151,35152,35352,35351,-1,35152,35153,35353,35352,-1,35153,35154,35354,35353,-1,35154,35155,35355,35354,-1,35155,35156,35356,35355,-1,35156,35157,35357,35356,-1,35157,35158,35358,35357,-1,35158,35159,35359,35358,-1,35159,35160,35360,35359,-1,35160,35161,35361,35360,-1,35161,35162,35362,35361,-1,35162,35163,35363,35362,-1,35163,35164,35364,35363,-1,35164,35165,35365,35364,-1,35165,35166,35366,35365,-1,35166,35167,35367,35366,-1,35167,35168,35368,35367,-1,35168,35169,35369,35368,-1,35169,35170,35370,35369,-1,35170,35171,35371,35370,-1,35171,35172,35372,35371,-1,35172,35173,35373,35372,-1,35173,35174,35374,35373,-1,35174,35175,35375,35374,-1,35175,35176,35376,35375,-1,35176,35177,35377,35376,-1,35177,35178,35378,35377,-1,35178,35179,35379,35378,-1,35179,35180,35380,35379,-1,35180,35181,35381,35380,-1,35181,35182,35382,35381,-1,35182,35183,35383,35382,-1,35183,35184,35384,35383,-1,35184,35185,35385,35384,-1,35185,35186,35386,35385,-1,35186,35187,35387,35386,-1,35187,35188,35388,35387,-1,35188,35189,35389,35388,-1,35189,35190,35390,35389,-1,35190,35191,35391,35390,-1,35191,35192,35392,35391,-1,35192,35193,35393,35392,-1,35193,35194,35394,35393,-1,35194,35195,35395,35394,-1,35195,35196,35396,35395,-1,35196,35197,35397,35396,-1,35197,35198,35398,35397,-1,35198,35199,35399,35398,-1,35200,35201,35401,35400,-1,35201,35202,35402,35401,-1,35202,35203,35403,35402,-1,35203,35204,35404,35403,-1,35204,35205,35405,35404,-1,35205,35206,35406,35405,-1,35206,35207,35407,35406,-1,35207,35208,35408,35407,-1,35208,35209,35409,35408,-1,35209,35210,35410,35409,-1,35210,35211,35411,35410,-1,35211,35212,35412,35411,-1,35212,35213,35413,35412,-1,35213,35214,35414,35413,-1,35214,35215,35415,35414,-1,35215,35216,35416,35415,-1,35216,35217,35417,35416,-1,35217,35218,35418,35417,-1,35218,35219,35419,35418,-1,35219,35220,35420,35419,-1,35220,35221,35421,35420,-1,35221,35222,35422,35421,-1,35222,35223,35423,35422,-1,35223,35224,35424,35423,-1,35224,35225,35425,35424,-1,35225,35226,35426,35425,-1,35226,35227,35427,35426,-1,35227,35228,35428,35427,-1,35228,35229,35429,35428,-1,35229,35230,35430,35429,-1,35230,35231,35431,35430,-1,35231,35232,35432,35431,-1,35232,35233,35433,35432,-1,35233,35234,35434,35433,-1,35234,35235,35435,35434,-1,35235,35236,35436,35435,-1,35236,35237,35437,35436,-1,35237,35238,35438,35437,-1,35238,35239,35439,35438,-1,35239,35240,35440,35439,-1,35240,35241,35441,35440,-1,35241,35242,35442,35441,-1,35242,35243,35443,35442,-1,35243,35244,35444,35443,-1,35244,35245,35445,35444,-1,35245,35246,35446,35445,-1,35246,35247,35447,35446,-1,35247,35248,35448,35447,-1,35248,35249,35449,35448,-1,35249,35250,35450,35449,-1,35250,35251,35451,35450,-1,35251,35252,35452,35451,-1,35252,35253,35453,35452,-1,35253,35254,35454,35453,-1,35254,35255,35455,35454,-1,35255,35256,35456,35455,-1,35256,35257,35457,35456,-1,35257,35258,35458,35457,-1,35258,35259,35459,35458,-1,35259,35260,35460,35459,-1,35260,35261,35461,35460,-1,35261,35262,35462,35461,-1,35262,35263,35463,35462,-1,35263,35264,35464,35463,-1,35264,35265,35465,35464,-1,35265,35266,35466,35465,-1,35266,35267,35467,35466,-1,35267,35268,35468,35467,-1,35268,35269,35469,35468,-1,35269,35270,35470,35469,-1,35270,35271,35471,35470,-1,35271,35272,35472,35471,-1,35272,35273,35473,35472,-1,35273,35274,35474,35473,-1,35274,35275,35475,35474,-1,35275,35276,35476,35475,-1,35276,35277,35477,35476,-1,35277,35278,35478,35477,-1,35278,35279,35479,35478,-1,35279,35280,35480,35479,-1,35280,35281,35481,35480,-1,35281,35282,35482,35481,-1,35282,35283,35483,35482,-1,35283,35284,35484,35483,-1,35284,35285,35485,35484,-1,35285,35286,35486,35485,-1,35286,35287,35487,35486,-1,35287,35288,35488,35487,-1,35288,35289,35489,35488,-1,35289,35290,35490,35489,-1,35290,35291,35491,35490,-1,35291,35292,35492,35491,-1,35292,35293,35493,35492,-1,35293,35294,35494,35493,-1,35294,35295,35495,35494,-1,35295,35296,35496,35495,-1,35296,35297,35497,35496,-1,35297,35298,35498,35497,-1,35298,35299,35499,35498,-1,35299,35300,35500,35499,-1,35300,35301,35501,35500,-1,35301,35302,35502,35501,-1,35302,35303,35503,35502,-1,35303,35304,35504,35503,-1,35304,35305,35505,35504,-1,35305,35306,35506,35505,-1,35306,35307,35507,35506,-1,35307,35308,35508,35507,-1,35308,35309,35509,35508,-1,35309,35310,35510,35509,-1,35310,35311,35511,35510,-1,35311,35312,35512,35511,-1,35312,35313,35513,35512,-1,35313,35314,35514,35513,-1,35314,35315,35515,35514,-1,35315,35316,35516,35515,-1,35316,35317,35517,35516,-1,35317,35318,35518,35517,-1,35318,35319,35519,35518,-1,35319,35320,35520,35519,-1,35320,35321,35521,35520,-1,35321,35322,35522,35521,-1,35322,35323,35523,35522,-1,35323,35324,35524,35523,-1,35324,35325,35525,35524,-1,35325,35326,35526,35525,-1,35326,35327,35527,35526,-1,35327,35328,35528,35527,-1,35328,35329,35529,35528,-1,35329,35330,35530,35529,-1,35330,35331,35531,35530,-1,35331,35332,35532,35531,-1,35332,35333,35533,35532,-1,35333,35334,35534,35533,-1,35334,35335,35535,35534,-1,35335,35336,35536,35535,-1,35336,35337,35537,35536,-1,35337,35338,35538,35537,-1,35338,35339,35539,35538,-1,35339,35340,35540,35539,-1,35340,35341,35541,35540,-1,35341,35342,35542,35541,-1,35342,35343,35543,35542,-1,35343,35344,35544,35543,-1,35344,35345,35545,35544,-1,35345,35346,35546,35545,-1,35346,35347,35547,35546,-1,35347,35348,35548,35547,-1,35348,35349,35549,35548,-1,35349,35350,35550,35549,-1,35350,35351,35551,35550,-1,35351,35352,35552,35551,-1,35352,35353,35553,35552,-1,35353,35354,35554,35553,-1,35354,35355,35555,35554,-1,35355,35356,35556,35555,-1,35356,35357,35557,35556,-1,35357,35358,35558,35557,-1,35358,35359,35559,35558,-1,35359,35360,35560,35559,-1,35360,35361,35561,35560,-1,35361,35362,35562,35561,-1,35362,35363,35563,35562,-1,35363,35364,35564,35563,-1,35364,35365,35565,35564,-1,35365,35366,35566,35565,-1,35366,35367,35567,35566,-1,35367,35368,35568,35567,-1,35368,35369,35569,35568,-1,35369,35370,35570,35569,-1,35370,35371,35571,35570,-1,35371,35372,35572,35571,-1,35372,35373,35573,35572,-1,35373,35374,35574,35573,-1,35374,35375,35575,35574,-1,35375,35376,35576,35575,-1,35376,35377,35577,35576,-1,35377,35378,35578,35577,-1,35378,35379,35579,35578,-1,35379,35380,35580,35579,-1,35380,35381,35581,35580,-1,35381,35382,35582,35581,-1,35382,35383,35583,35582,-1,35383,35384,35584,35583,-1,35384,35385,35585,35584,-1,35385,35386,35586,35585,-1,35386,35387,35587,35586,-1,35387,35388,35588,35587,-1,35388,35389,35589,35588,-1,35389,35390,35590,35589,-1,35390,35391,35591,35590,-1,35391,35392,35592,35591,-1,35392,35393,35593,35592,-1,35393,35394,35594,35593,-1,35394,35395,35595,35594,-1,35395,35396,35596,35595,-1,35396,35397,35597,35596,-1,35397,35398,35598,35597,-1,35398,35399,35599,35598,-1,35400,35401,35601,35600,-1,35401,35402,35602,35601,-1,35402,35403,35603,35602,-1,35403,35404,35604,35603,-1,35404,35405,35605,35604,-1,35405,35406,35606,35605,-1,35406,35407,35607,35606,-1,35407,35408,35608,35607,-1,35408,35409,35609,35608,-1,35409,35410,35610,35609,-1,35410,35411,35611,35610,-1,35411,35412,35612,35611,-1,35412,35413,35613,35612,-1,35413,35414,35614,35613,-1,35414,35415,35615,35614,-1,35415,35416,35616,35615,-1,35416,35417,35617,35616,-1,35417,35418,35618,35617,-1,35418,35419,35619,35618,-1,35419,35420,35620,35619,-1,35420,35421,35621,35620,-1,35421,35422,35622,35621,-1,35422,35423,35623,35622,-1,35423,35424,35624,35623,-1,35424,35425,35625,35624,-1,35425,35426,35626,35625,-1,35426,35427,35627,35626,-1,35427,35428,35628,35627,-1,35428,35429,35629,35628,-1,35429,35430,35630,35629,-1,35430,35431,35631,35630,-1,35431,35432,35632,35631,-1,35432,35433,35633,35632,-1,35433,35434,35634,35633,-1,35434,35435,35635,35634,-1,35435,35436,35636,35635,-1,35436,35437,35637,35636,-1,35437,35438,35638,35637,-1,35438,35439,35639,35638,-1,35439,35440,35640,35639,-1,35440,35441,35641,35640,-1,35441,35442,35642,35641,-1,35442,35443,35643,35642,-1,35443,35444,35644,35643,-1,35444,35445,35645,35644,-1,35445,35446,35646,35645,-1,35446,35447,35647,35646,-1,35447,35448,35648,35647,-1,35448,35449,35649,35648,-1,35449,35450,35650,35649,-1,35450,35451,35651,35650,-1,35451,35452,35652,35651,-1,35452,35453,35653,35652,-1,35453,35454,35654,35653,-1,35454,35455,35655,35654,-1,35455,35456,35656,35655,-1,35456,35457,35657,35656,-1,35457,35458,35658,35657,-1,35458,35459,35659,35658,-1,35459,35460,35660,35659,-1,35460,35461,35661,35660,-1,35461,35462,35662,35661,-1,35462,35463,35663,35662,-1,35463,35464,35664,35663,-1,35464,35465,35665,35664,-1,35465,35466,35666,35665,-1,35466,35467,35667,35666,-1,35467,35468,35668,35667,-1,35468,35469,35669,35668,-1,35469,35470,35670,35669,-1,35470,35471,35671,35670,-1,35471,35472,35672,35671,-1,35472,35473,35673,35672,-1,35473,35474,35674,35673,-1,35474,35475,35675,35674,-1,35475,35476,35676,35675,-1,35476,35477,35677,35676,-1,35477,35478,35678,35677,-1,35478,35479,35679,35678,-1,35479,35480,35680,35679,-1,35480,35481,35681,35680,-1,35481,35482,35682,35681,-1,35482,35483,35683,35682,-1,35483,35484,35684,35683,-1,35484,35485,35685,35684,-1,35485,35486,35686,35685,-1,35486,35487,35687,35686,-1,35487,35488,35688,35687,-1,35488,35489,35689,35688,-1,35489,35490,35690,35689,-1,35490,35491,35691,35690,-1,35491,35492,35692,35691,-1,35492,35493,35693,35692,-1,35493,35494,35694,35693,-1,35494,35495,35695,35694,-1,35495,35496,35696,35695,-1,35496,35497,35697,35696,-1,35497,35498,35698,35697,-1,35498,35499,35699,35698,-1,35499,35500,35700,35699,-1,35500,35501,35701,35700,-1,35501,35502,35702,35701,-1,35502,35503,35703,35702,-1,35503,35504,35704,35703,-1,35504,35505,35705,35704,-1,35505,35506,35706,35705,-1,35506,35507,35707,35706,-1,35507,35508,35708,35707,-1,35508,35509,35709,35708,-1,35509,35510,35710,35709,-1,35510,35511,35711,35710,-1,35511,35512,35712,35711,-1,35512,35513,35713,35712,-1,35513,35514,35714,35713,-1,35514,35515,35715,35714,-1,35515,35516,35716,35715,-1,35516,35517,35717,35716,-1,35517,35518,35718,35717,-1,35518,35519,35719,35718,-1,35519,35520,35720,35719,-1,35520,35521,35721,35720,-1,35521,35522,35722,35721,-1,35522,35523,35723,35722,-1,35523,35524,35724,35723,-1,35524,35525,35725,35724,-1,35525,35526,35726,35725,-1,35526,35527,35727,35726,-1,35527,35528,35728,35727,-1,35528,35529,35729,35728,-1,35529,35530,35730,35729,-1,35530,35531,35731,35730,-1,35531,35532,35732,35731,-1,35532,35533,35733,35732,-1,35533,35534,35734,35733,-1,35534,35535,35735,35734,-1,35535,35536,35736,35735,-1,35536,35537,35737,35736,-1,35537,35538,35738,35737,-1,35538,35539,35739,35738,-1,35539,35540,35740,35739,-1,35540,35541,35741,35740,-1,35541,35542,35742,35741,-1,35542,35543,35743,35742,-1,35543,35544,35744,35743,-1,35544,35545,35745,35744,-1,35545,35546,35746,35745,-1,35546,35547,35747,35746,-1,35547,35548,35748,35747,-1,35548,35549,35749,35748,-1,35549,35550,35750,35749,-1,35550,35551,35751,35750,-1,35551,35552,35752,35751,-1,35552,35553,35753,35752,-1,35553,35554,35754,35753,-1,35554,35555,35755,35754,-1,35555,35556,35756,35755,-1,35556,35557,35757,35756,-1,35557,35558,35758,35757,-1,35558,35559,35759,35758,-1,35559,35560,35760,35759,-1,35560,35561,35761,35760,-1,35561,35562,35762,35761,-1,35562,35563,35763,35762,-1,35563,35564,35764,35763,-1,35564,35565,35765,35764,-1,35565,35566,35766,35765,-1,35566,35567,35767,35766,-1,35567,35568,35768,35767,-1,35568,35569,35769,35768,-1,35569,35570,35770,35769,-1,35570,35571,35771,35770,-1,35571,35572,35772,35771,-1,35572,35573,35773,35772,-1,35573,35574,35774,35773,-1,35574,35575,35775,35774,-1,35575,35576,35776,35775,-1,35576,35577,35777,35776,-1,35577,35578,35778,35777,-1,35578,35579,35779,35778,-1,35579,35580,35780,35779,-1,35580,35581,35781,35780,-1,35581,35582,35782,35781,-1,35582,35583,35783,35782,-1,35583,35584,35784,35783,-1,35584,35585,35785,35784,-1,35585,35586,35786,35785,-1,35586,35587,35787,35786,-1,35587,35588,35788,35787,-1,35588,35589,35789,35788,-1,35589,35590,35790,35789,-1,35590,35591,35791,35790,-1,35591,35592,35792,35791,-1,35592,35593,35793,35792,-1,35593,35594,35794,35793,-1,35594,35595,35795,35794,-1,35595,35596,35796,35795,-1,35596,35597,35797,35796,-1,35597,35598,35798,35797,-1,35598,35599,35799,35798,-1,35600,35601,35801,35800,-1,35601,35602,35802,35801,-1,35602,35603,35803,35802,-1,35603,35604,35804,35803,-1,35604,35605,35805,35804,-1,35605,35606,35806,35805,-1,35606,35607,35807,35806,-1,35607,35608,35808,35807,-1,35608,35609,35809,35808,-1,35609,35610,35810,35809,-1,35610,35611,35811,35810,-1,35611,35612,35812,35811,-1,35612,35613,35813,35812,-1,35613,35614,35814,35813,-1,35614,35615,35815,35814,-1,35615,35616,35816,35815,-1,35616,35617,35817,35816,-1,35617,35618,35818,35817,-1,35618,35619,35819,35818,-1,35619,35620,35820,35819,-1,35620,35621,35821,35820,-1,35621,35622,35822,35821,-1,35622,35623,35823,35822,-1,35623,35624,35824,35823,-1,35624,35625,35825,35824,-1,35625,35626,35826,35825,-1,35626,35627,35827,35826,-1,35627,35628,35828,35827,-1,35628,35629,35829,35828,-1,35629,35630,35830,35829,-1,35630,35631,35831,35830,-1,35631,35632,35832,35831,-1,35632,35633,35833,35832,-1,35633,35634,35834,35833,-1,35634,35635,35835,35834,-1,35635,35636,35836,35835,-1,35636,35637,35837,35836,-1,35637,35638,35838,35837,-1,35638,35639,35839,35838,-1,35639,35640,35840,35839,-1,35640,35641,35841,35840,-1,35641,35642,35842,35841,-1,35642,35643,35843,35842,-1,35643,35644,35844,35843,-1,35644,35645,35845,35844,-1,35645,35646,35846,35845,-1,35646,35647,35847,35846,-1,35647,35648,35848,35847,-1,35648,35649,35849,35848,-1,35649,35650,35850,35849,-1,35650,35651,35851,35850,-1,35651,35652,35852,35851,-1,35652,35653,35853,35852,-1,35653,35654,35854,35853,-1,35654,35655,35855,35854,-1,35655,35656,35856,35855,-1,35656,35657,35857,35856,-1,35657,35658,35858,35857,-1,35658,35659,35859,35858,-1,35659,35660,35860,35859,-1,35660,35661,35861,35860,-1,35661,35662,35862,35861,-1,35662,35663,35863,35862,-1,35663,35664,35864,35863,-1,35664,35665,35865,35864,-1,35665,35666,35866,35865,-1,35666,35667,35867,35866,-1,35667,35668,35868,35867,-1,35668,35669,35869,35868,-1,35669,35670,35870,35869,-1,35670,35671,35871,35870,-1,35671,35672,35872,35871,-1,35672,35673,35873,35872,-1,35673,35674,35874,35873,-1,35674,35675,35875,35874,-1,35675,35676,35876,35875,-1,35676,35677,35877,35876,-1,35677,35678,35878,35877,-1,35678,35679,35879,35878,-1,35679,35680,35880,35879,-1,35680,35681,35881,35880,-1,35681,35682,35882,35881,-1,35682,35683,35883,35882,-1,35683,35684,35884,35883,-1,35684,35685,35885,35884,-1,35685,35686,35886,35885,-1,35686,35687,35887,35886,-1,35687,35688,35888,35887,-1,35688,35689,35889,35888,-1,35689,35690,35890,35889,-1,35690,35691,35891,35890,-1,35691,35692,35892,35891,-1,35692,35693,35893,35892,-1,35693,35694,35894,35893,-1,35694,35695,35895,35894,-1,35695,35696,35896,35895,-1,35696,35697,35897,35896,-1,35697,35698,35898,35897,-1,35698,35699,35899,35898,-1,35699,35700,35900,35899,-1,35700,35701,35901,35900,-1,35701,35702,35902,35901,-1,35702,35703,35903,35902,-1,35703,35704,35904,35903,-1,35704,35705,35905,35904,-1,35705,35706,35906,35905,-1,35706,35707,35907,35906,-1,35707,35708,35908,35907,-1,35708,35709,35909,35908,-1,35709,35710,35910,35909,-1,35710,35711,35911,35910,-1,35711,35712,35912,35911,-1,35712,35713,35913,35912,-1,35713,35714,35914,35913,-1,35714,35715,35915,35914,-1,35715,35716,35916,35915,-1,35716,35717,35917,35916,-1,35717,35718,35918,35917,-1,35718,35719,35919,35918,-1,35719,35720,35920,35919,-1,35720,35721,35921,35920,-1,35721,35722,35922,35921,-1,35722,35723,35923,35922,-1,35723,35724,35924,35923,-1,35724,35725,35925,35924,-1,35725,35726,35926,35925,-1,35726,35727,35927,35926,-1,35727,35728,35928,35927,-1,35728,35729,35929,35928,-1,35729,35730,35930,35929,-1,35730,35731,35931,35930,-1,35731,35732,35932,35931,-1,35732,35733,35933,35932,-1,35733,35734,35934,35933,-1,35734,35735,35935,35934,-1,35735,35736,35936,35935,-1,35736,35737,35937,35936,-1,35737,35738,35938,35937,-1,35738,35739,35939,35938,-1,35739,35740,35940,35939,-1,35740,35741,35941,35940,-1,35741,35742,35942,35941,-1,35742,35743,35943,35942,-1,35743,35744,35944,35943,-1,35744,35745,35945,35944,-1,35745,35746,35946,35945,-1,35746,35747,35947,35946,-1,35747,35748,35948,35947,-1,35748,35749,35949,35948,-1,35749,35750,35950,35949,-1,35750,35751,35951,35950,-1,35751,35752,35952,35951,-1,35752,35753,35953,35952,-1,35753,35754,35954,35953,-1,35754,35755,35955,35954,-1,35755,35756,35956,35955,-1,35756,35757,35957,35956,-1,35757,35758,35958,35957,-1,35758,35759,35959,35958,-1,35759,35760,35960,35959,-1,35760,35761,35961,35960,-1,35761,35762,35962,35961,-1,35762,35763,35963,35962,-1,35763,35764,35964,35963,-1,35764,35765,35965,35964,-1,35765,35766,35966,35965,-1,35766,35767,35967,35966,-1,35767,35768,35968,35967,-1,35768,35769,35969,35968,-1,35769,35770,35970,35969,-1,35770,35771,35971,35970,-1,35771,35772,35972,35971,-1,35772,35773,35973,35972,-1,35773,35774,35974,35973,-1,35774,35775,35975,35974,-1,35775,35776,35976,35975,-1,35776,35777,35977,35976,-1,35777,35778,35978,35977,-1,35778,35779,35979,35978,-1,35779,35780,35980,35979,-1,35780,35781,35981,35980,-1,35781,35782,35982,35981,-1,35782,35783,35983,35982,-1,35783,35784,35984,35983,-1,35784,35785,35985,35984,-1,35785,35786,35986,35985,-1,35786,35787,35987,35986,-1,35787,35788,35988,35987,-1,35788,35789,35989,35988,-1,35789,35790,35990,35989,-1,35790,35791,35991,35990,-1,35791,35792,35992,35991,-1,35792,35793,35993,35992,-1,35793,35794,35994,35993,-1,35794,35795,35995,35994,-1,35795,35796,35996,35995,-1,35796,35797,35997,35996,-1,35797,35798,35998,35997,-1,35798,35799,35999,35998,-1,35800,35801,36001,36,-1,35801,35802,36002,36001,-1,35802,35803,36003,36002,-1,35803,35804,36004,36003,-1,35804,35805,36005,36004,-1,35805,35806,36006,36005,-1,35806,35807,36007,36006,-1,35807,35808,36008,36007,-1,35808,35809,36009,36008,-1,35809,35810,36010,36009,-1,35810,35811,36011,36010,-1,35811,35812,36012,36011,-1,35812,35813,36013,36012,-1,35813,35814,36014,36013,-1,35814,35815,36015,36014,-1,35815,35816,36016,36015,-1,35816,35817,36017,36016,-1,35817,35818,36018,36017,-1,35818,35819,36019,36018,-1,35819,35820,36020,36019,-1,35820,35821,36021,36020,-1,35821,35822,36022,36021,-1,35822,35823,36023,36022,-1,35823,35824,36024,36023,-1,35824,35825,36025,36024,-1,35825,35826,36026,36025,-1,35826,35827,36027,36026,-1,35827,35828,36028,36027,-1,35828,35829,36029,36028,-1,35829,35830,36030,36029,-1,35830,35831,36031,36030,-1,35831,35832,36032,36031,-1,35832,35833,36033,36032,-1,35833,35834,36034,36033,-1,35834,35835,36035,36034,-1,35835,35836,36036,36035,-1,35836,35837,36037,36036,-1,35837,35838,36038,36037,-1,35838,35839,36039,36038,-1,35839,35840,36040,36039,-1,35840,35841,36041,36040,-1,35841,35842,36042,36041,-1,35842,35843,36043,36042,-1,35843,35844,36044,36043,-1,35844,35845,36045,36044,-1,35845,35846,36046,36045,-1,35846,35847,36047,36046,-1,35847,35848,36048,36047,-1,35848,35849,36049,36048,-1,35849,35850,36050,36049,-1,35850,35851,36051,36050,-1,35851,35852,36052,36051,-1,35852,35853,36053,36052,-1,35853,35854,36054,36053,-1,35854,35855,36055,36054,-1,35855,35856,36056,36055,-1,35856,35857,36057,36056,-1,35857,35858,36058,36057,-1,35858,35859,36059,36058,-1,35859,35860,36060,36059,-1,35860,35861,36061,36060,-1,35861,35862,36062,36061,-1,35862,35863,36063,36062,-1,35863,35864,36064,36063,-1,35864,35865,36065,36064,-1,35865,35866,36066,36065,-1,35866,35867,36067,36066,-1,35867,35868,36068,36067,-1,35868,35869,36069,36068,-1,35869,35870,36070,36069,-1,35870,35871,36071,36070,-1,35871,35872,36072,36071,-1,35872,35873,36073,36072,-1,35873,35874,36074,36073,-1,35874,35875,36075,36074,-1,35875,35876,36076,36075,-1,35876,35877,36077,36076,-1,35877,35878,36078,36077,-1,35878,35879,36079,36078,-1,35879,35880,36080,36079,-1,35880,35881,36081,36080,-1,35881,35882,36082,36081,-1,35882,35883,36083,36082,-1,35883,35884,36084,36083,-1,35884,35885,36085,36084,-1,35885,35886,36086,36085,-1,35886,35887,36087,36086,-1,35887,35888,36088,36087,-1,35888,35889,36089,36088,-1,35889,35890,36090,36089,-1,35890,35891,36091,36090,-1,35891,35892,36092,36091,-1,35892,35893,36093,36092,-1,35893,35894,36094,36093,-1,35894,35895,36095,36094,-1,35895,35896,36096,36095,-1,35896,35897,36097,36096,-1,35897,35898,36098,36097,-1,35898,35899,36099,36098,-1,35899,35900,36100,36099,-1,35900,35901,36101,36100,-1,35901,35902,36102,36101,-1,35902,35903,36103,36102,-1,35903,35904,36104,36103,-1,35904,35905,36105,36104,-1,35905,35906,36106,36105,-1,35906,35907,36107,36106,-1,35907,35908,36108,36107,-1,35908,35909,36109,36108,-1,35909,35910,36110,36109,-1,35910,35911,36111,36110,-1,35911,35912,36112,36111,-1,35912,35913,36113,36112,-1,35913,35914,36114,36113,-1,35914,35915,36115,36114,-1,35915,35916,36116,36115,-1,35916,35917,36117,36116,-1,35917,35918,36118,36117,-1,35918,35919,36119,36118,-1,35919,35920,36120,36119,-1,35920,35921,36121,36120,-1,35921,35922,36122,36121,-1,35922,35923,36123,36122,-1,35923,35924,36124,36123,-1,35924,35925,36125,36124,-1,35925,35926,36126,36125,-1,35926,35927,36127,36126,-1,35927,35928,36128,36127,-1,35928,35929,36129,36128,-1,35929,35930,36130,36129,-1,35930,35931,36131,36130,-1,35931,35932,36132,36131,-1,35932,35933,36133,36132,-1,35933,35934,36134,36133,-1,35934,35935,36135,36134,-1,35935,35936,36136,36135,-1,35936,35937,36137,36136,-1,35937,35938,36138,36137,-1,35938,35939,36139,36138,-1,35939,35940,36140,36139,-1,35940,35941,36141,36140,-1,35941,35942,36142,36141,-1,35942,35943,36143,36142,-1,35943,35944,36144,36143,-1,35944,35945,36145,36144,-1,35945,35946,36146,36145,-1,35946,35947,36147,36146,-1,35947,35948,36148,36147,-1,35948,35949,36149,36148,-1,35949,35950,36150,36149,-1,35950,35951,36151,36150,-1,35951,35952,36152,36151,-1,35952,35953,36153,36152,-1,35953,35954,36154,36153,-1,35954,35955,36155,36154,-1,35955,35956,36156,36155,-1,35956,35957,36157,36156,-1,35957,35958,36158,36157,-1,35958,35959,36159,36158,-1,35959,35960,36160,36159,-1,35960,35961,36161,36160,-1,35961,35962,36162,36161,-1,35962,35963,36163,36162,-1,35963,35964,36164,36163,-1,35964,35965,36165,36164,-1,35965,35966,36166,36165,-1,35966,35967,36167,36166,-1,35967,35968,36168,36167,-1,35968,35969,36169,36168,-1,35969,35970,36170,36169,-1,35970,35971,36171,36170,-1,35971,35972,36172,36171,-1,35972,35973,36173,36172,-1,35973,35974,36174,36173,-1,35974,35975,36175,36174,-1,35975,35976,36176,36175,-1,35976,35977,36177,36176,-1,35977,35978,36178,36177,-1,35978,35979,36179,36178,-1,35979,35980,36180,36179,-1,35980,35981,36181,36180,-1,35981,35982,36182,36181,-1,35982,35983,36183,36182,-1,35983,35984,36184,36183,-1,35984,35985,36185,36184,-1,35985,35986,36186,36185,-1,35986,35987,36187,36186,-1,35987,35988,36188,36187,-1,35988,35989,36189,36188,-1,35989,35990,36190,36189,-1,35990,35991,36191,36190,-1,35991,35992,36192,36191,-1,35992,35993,36193,36192,-1,35993,35994,36194,36193,-1,35994,35995,36195,36194,-1,35995,35996,36196,36195,-1,35996,35997,36197,36196,-1,35997,35998,36198,36197,-1,35998,35999,36199,36198,-1,36,36001,36201,36200,-1,36001,36002,36202,36201,-1,36002,36003,36203,36202,-1,36003,36004,36204,36203,-1,36004,36005,36205,36204,-1,36005,36006,36206,36205,-1,36006,36007,36207,36206,-1,36007,36008,36208,36207,-1,36008,36009,36209,36208,-1,36009,36010,36210,36209,-1,36010,36011,36211,36210,-1,36011,36012,36212,36211,-1,36012,36013,36213,36212,-1,36013,36014,36214,36213,-1,36014,36015,36215,36214,-1,36015,36016,36216,36215,-1,36016,36017,36217,36216,-1,36017,36018,36218,36217,-1,36018,36019,36219,36218,-1,36019,36020,36220,36219,-1,36020,36021,36221,36220,-1,36021,36022,36222,36221,-1,36022,36023,36223,36222,-1,36023,36024,36224,36223,-1,36024,36025,36225,36224,-1,36025,36026,36226,36225,-1,36026,36027,36227,36226,-1,36027,36028,36228,36227,-1,36028,36029,36229,36228,-1,36029,36030,36230,36229,-1,36030,36031,36231,36230,-1,36031,36032,36232,36231,-1,36032,36033,36233,36232,-1,36033,36034,36234,36233,-1,36034,36035,36235,36234,-1,36035,36036,36236,36235,-1,36036,36037,36237,36236,-1,36037,36038,36238,36237,-1,36038,36039,36239,36238,-1,36039,36040,36240,36239,-1,36040,36041,36241,36240,-1,36041,36042,36242,36241,-1,36042,36043,36243,36242,-1,36043,36044,36244,36243,-1,36044,36045,36245,36244,-1,36045,36046,36246,36245,-1,36046,36047,36247,36246,-1,36047,36048,36248,36247,-1,36048,36049,36249,36248,-1,36049,36050,36250,36249,-1,36050,36051,36251,36250,-1,36051,36052,36252,36251,-1,36052,36053,36253,36252,-1,36053,36054,36254,36253,-1,36054,36055,36255,36254,-1,36055,36056,36256,36255,-1,36056,36057,36257,36256,-1,36057,36058,36258,36257,-1,36058,36059,36259,36258,-1,36059,36060,36260,36259,-1,36060,36061,36261,36260,-1,36061,36062,36262,36261,-1,36062,36063,36263,36262,-1,36063,36064,36264,36263,-1,36064,36065,36265,36264,-1,36065,36066,36266,36265,-1,36066,36067,36267,36266,-1,36067,36068,36268,36267,-1,36068,36069,36269,36268,-1,36069,36070,36270,36269,-1,36070,36071,36271,36270,-1,36071,36072,36272,36271,-1,36072,36073,36273,36272,-1,36073,36074,36274,36273,-1,36074,36075,36275,36274,-1,36075,36076,36276,36275,-1,36076,36077,36277,36276,-1,36077,36078,36278,36277,-1,36078,36079,36279,36278,-1,36079,36080,36280,36279,-1,36080,36081,36281,36280,-1,36081,36082,36282,36281,-1,36082,36083,36283,36282,-1,36083,36084,36284,36283,-1,36084,36085,36285,36284,-1,36085,36086,36286,36285,-1,36086,36087,36287,36286,-1,36087,36088,36288,36287,-1,36088,36089,36289,36288,-1,36089,36090,36290,36289,-1,36090,36091,36291,36290,-1,36091,36092,36292,36291,-1,36092,36093,36293,36292,-1,36093,36094,36294,36293,-1,36094,36095,36295,36294,-1,36095,36096,36296,36295,-1,36096,36097,36297,36296,-1,36097,36098,36298,36297,-1,36098,36099,36299,36298,-1,36099,36100,36300,36299,-1,36100,36101,36301,36300,-1,36101,36102,36302,36301,-1,36102,36103,36303,36302,-1,36103,36104,36304,36303,-1,36104,36105,36305,36304,-1,36105,36106,36306,36305,-1,36106,36107,36307,36306,-1,36107,36108,36308,36307,-1,36108,36109,36309,36308,-1,36109,36110,36310,36309,-1,36110,36111,36311,36310,-1,36111,36112,36312,36311,-1,36112,36113,36313,36312,-1,36113,36114,36314,36313,-1,36114,36115,36315,36314,-1,36115,36116,36316,36315,-1,36116,36117,36317,36316,-1,36117,36118,36318,36317,-1,36118,36119,36319,36318,-1,36119,36120,36320,36319,-1,36120,36121,36321,36320,-1,36121,36122,36322,36321,-1,36122,36123,36323,36322,-1,36123,36124,36324,36323,-1,36124,36125,36325,36324,-1,36125,36126,36326,36325,-1,36126,36127,36327,36326,-1,36127,36128,36328,36327,-1,36128,36129,36329,36328,-1,36129,36130,36330,36329,-1,36130,36131,36331,36330,-1,36131,36132,36332,36331,-1,36132,36133,36333,36332,-1,36133,36134,36334,36333,-1,36134,36135,36335,36334,-1,36135,36136,36336,36335,-1,36136,36137,36337,36336,-1,36137,36138,36338,36337,-1,36138,36139,36339,36338,-1,36139,36140,36340,36339,-1,36140,36141,36341,36340,-1,36141,36142,36342,36341,-1,36142,36143,36343,36342,-1,36143,36144,36344,36343,-1,36144,36145,36345,36344,-1,36145,36146,36346,36345,-1,36146,36147,36347,36346,-1,36147,36148,36348,36347,-1,36148,36149,36349,36348,-1,36149,36150,36350,36349,-1,36150,36151,36351,36350,-1,36151,36152,36352,36351,-1,36152,36153,36353,36352,-1,36153,36154,36354,36353,-1,36154,36155,36355,36354,-1,36155,36156,36356,36355,-1,36156,36157,36357,36356,-1,36157,36158,36358,36357,-1,36158,36159,36359,36358,-1,36159,36160,36360,36359,-1,36160,36161,36361,36360,-1,36161,36162,36362,36361,-1,36162,36163,36363,36362,-1,36163,36164,36364,36363,-1,36164,36165,36365,36364,-1,36165,36166,36366,36365,-1,36166,36167,36367,36366,-1,36167,36168,36368,36367,-1,36168,36169,36369,36368,-1,36169,36170,36370,36369,-1,36170,36171,36371,36370,-1,36171,36172,36372,36371,-1,36172,36173,36373,36372,-1,36173,36174,36374,36373,-1,36174,36175,36375,36374,-1,36175,36176,36376,36375,-1,36176,36177,36377,36376,-1,36177,36178,36378,36377,-1,36178,36179,36379,36378,-1,36179,36180,36380,36379,-1,36180,36181,36381,36380,-1,36181,36182,36382,36381,-1,36182,36183,36383,36382,-1,36183,36184,36384,36383,-1,36184,36185,36385,36384,-1,36185,36186,36386,36385,-1,36186,36187,36387,36386,-1,36187,36188,36388,36387,-1,36188,36189,36389,36388,-1,36189,36190,36390,36389,-1,36190,36191,36391,36390,-1,36191,36192,36392,36391,-1,36192,36193,36393,36392,-1,36193,36194,36394,36393,-1,36194,36195,36395,36394,-1,36195,36196,36396,36395,-1,36196,36197,36397,36396,-1,36197,36198,36398,36397,-1,36198,36199,36399,36398,-1,36200,36201,36401,36400,-1,36201,36202,36402,36401,-1,36202,36203,36403,36402,-1,36203,36204,36404,36403,-1,36204,36205,36405,36404,-1,36205,36206,36406,36405,-1,36206,36207,36407,36406,-1,36207,36208,36408,36407,-1,36208,36209,36409,36408,-1,36209,36210,36410,36409,-1,36210,36211,36411,36410,-1,36211,36212,36412,36411,-1,36212,36213,36413,36412,-1,36213,36214,36414,36413,-1,36214,36215,36415,36414,-1,36215,36216,36416,36415,-1,36216,36217,36417,36416,-1,36217,36218,36418,36417,-1,36218,36219,36419,36418,-1,36219,36220,36420,36419,-1,36220,36221,36421,36420,-1,36221,36222,36422,36421,-1,36222,36223,36423,36422,-1,36223,36224,36424,36423,-1,36224,36225,36425,36424,-1,36225,36226,36426,36425,-1,36226,36227,36427,36426,-1,36227,36228,36428,36427,-1,36228,36229,36429,36428,-1,36229,36230,36430,36429,-1,36230,36231,36431,36430,-1,36231,36232,36432,36431,-1,36232,36233,36433,36432,-1,36233,36234,36434,36433,-1,36234,36235,36435,36434,-1,36235,36236,36436,36435,-1,36236,36237,36437,36436,-1,36237,36238,36438,36437,-1,36238,36239,36439,36438,-1,36239,36240,36440,36439,-1,36240,36241,36441,36440,-1,36241,36242,36442,36441,-1,36242,36243,36443,36442,-1,36243,36244,36444,36443,-1,36244,36245,36445,36444,-1,36245,36246,36446,36445,-1,36246,36247,36447,36446,-1,36247,36248,36448,36447,-1,36248,36249,36449,36448,-1,36249,36250,36450,36449,-1,36250,36251,36451,36450,-1,36251,36252,36452,36451,-1,36252,36253,36453,36452,-1,36253,36254,36454,36453,-1,36254,36255,36455,36454,-1,36255,36256,36456,36455,-1,36256,36257,36457,36456,-1,36257,36258,36458,36457,-1,36258,36259,36459,36458,-1,36259,36260,36460,36459,-1,36260,36261,36461,36460,-1,36261,36262,36462,36461,-1,36262,36263,36463,36462,-1,36263,36264,36464,36463,-1,36264,36265,36465,36464,-1,36265,36266,36466,36465,-1,36266,36267,36467,36466,-1,36267,36268,36468,36467,-1,36268,36269,36469,36468,-1,36269,36270,36470,36469,-1,36270,36271,36471,36470,-1,36271,36272,36472,36471,-1,36272,36273,36473,36472,-1,36273,36274,36474,36473,-1,36274,36275,36475,36474,-1,36275,36276,36476,36475,-1,36276,36277,36477,36476,-1,36277,36278,36478,36477,-1,36278,36279,36479,36478,-1,36279,36280,36480,36479,-1,36280,36281,36481,36480,-1,36281,36282,36482,36481,-1,36282,36283,36483,36482,-1,36283,36284,36484,36483,-1,36284,36285,36485,36484,-1,36285,36286,36486,36485,-1,36286,36287,36487,36486,-1,36287,36288,36488,36487,-1,36288,36289,36489,36488,-1,36289,36290,36490,36489,-1,36290,36291,36491,36490,-1,36291,36292,36492,36491,-1,36292,36293,36493,36492,-1,36293,36294,36494,36493,-1,36294,36295,36495,36494,-1,36295,36296,36496,36495,-1,36296,36297,36497,36496,-1,36297,36298,36498,36497,-1,36298,36299,36499,36498,-1,36299,36300,36500,36499,-1,36300,36301,36501,36500,-1,36301,36302,36502,36501,-1,36302,36303,36503,36502,-1,36303,36304,36504,36503,-1,36304,36305,36505,36504,-1,36305,36306,36506,36505,-1,36306,36307,36507,36506,-1,36307,36308,36508,36507,-1,36308,36309,36509,36508,-1,36309,36310,36510,36509,-1,36310,36311,36511,36510,-1,36311,36312,36512,36511,-1,36312,36313,36513,36512,-1,36313,36314,36514,36513,-1,36314,36315,36515,36514,-1,36315,36316,36516,36515,-1,36316,36317,36517,36516,-1,36317,36318,36518,36517,-1,36318,36319,36519,36518,-1,36319,36320,36520,36519,-1,36320,36321,36521,36520,-1,36321,36322,36522,36521,-1,36322,36323,36523,36522,-1,36323,36324,36524,36523,-1,36324,36325,36525,36524,-1,36325,36326,36526,36525,-1,36326,36327,36527,36526,-1,36327,36328,36528,36527,-1,36328,36329,36529,36528,-1,36329,36330,36530,36529,-1,36330,36331,36531,36530,-1,36331,36332,36532,36531,-1,36332,36333,36533,36532,-1,36333,36334,36534,36533,-1,36334,36335,36535,36534,-1,36335,36336,36536,36535,-1,36336,36337,36537,36536,-1,36337,36338,36538,36537,-1,36338,36339,36539,36538,-1,36339,36340,36540,36539,-1,36340,36341,36541,36540,-1,36341,36342,36542,36541,-1,36342,36343,36543,36542,-1,36343,36344,36544,36543,-1,36344,36345,36545,36544,-1,36345,36346,36546,36545,-1,36346,36347,36547,36546,-1,36347,36348,36548,36547,-1,36348,36349,36549,36548,-1,36349,36350,36550,36549,-1,36350,36351,36551,36550,-1,36351,36352,36552,36551,-1,36352,36353,36553,36552,-1,36353,36354,36554,36553,-1,36354,36355,36555,36554,-1,36355,36356,36556,36555,-1,36356,36357,36557,36556,-1,36357,36358,36558,36557,-1,36358,36359,36559,36558,-1,36359,36360,36560,36559,-1,36360,36361,36561,36560,-1,36361,36362,36562,36561,-1,36362,36363,36563,36562,-1,36363,36364,36564,36563,-1,36364,36365,36565,36564,-1,36365,36366,36566,36565,-1,36366,36367,36567,36566,-1,36367,36368,36568,36567,-1,36368,36369,36569,36568,-1,36369,36370,36570,36569,-1,36370,36371,36571,36570,-1,36371,36372,36572,36571,-1,36372,36373,36573,36572,-1,36373,36374,36574,36573,-1,36374,36375,36575,36574,-1,36375,36376,36576,36575,-1,36376,36377,36577,36576,-1,36377,36378,36578,36577,-1,36378,36379,36579,36578,-1,36379,36380,36580,36579,-1,36380,36381,36581,36580,-1,36381,36382,36582,36581,-1,36382,36383,36583,36582,-1,36383,36384,36584,36583,-1,36384,36385,36585,36584,-1,36385,36386,36586,36585,-1,36386,36387,36587,36586,-1,36387,36388,36588,36587,-1,36388,36389,36589,36588,-1,36389,36390,36590,36589,-1,36390,36391,36591,36590,-1,36391,36392,36592,36591,-1,36392,36393,36593,36592,-1,36393,36394,36594,36593,-1,36394,36395,36595,36594,-1,36395,36396,36596,36595,-1,36396,36397,36597,36596,-1,36397,36398,36598,36597,-1,36398,36399,36599,36598,-1,36400,36401,36601,36600,-1,36401,36402,36602,36601,-1,36402,36403,36603,36602,-1,36403,36404,36604,36603,-1,36404,36405,36605,36604,-1,36405,36406,36606,36605,-1,36406,36407,36607,36606,-1,36407,36408,36608,36607,-1,36408,36409,36609,36608,-1,36409,36410,36610,36609,-1,36410,36411,36611,36610,-1,36411,36412,36612,36611,-1,36412,36413,36613,36612,-1,36413,36414,36614,36613,-1,36414,36415,36615,36614,-1,36415,36416,36616,36615,-1,36416,36417,36617,36616,-1,36417,36418,36618,36617,-1,36418,36419,36619,36618,-1,36419,36420,36620,36619,-1,36420,36421,36621,36620,-1,36421,36422,36622,36621,-1,36422,36423,36623,36622,-1,36423,36424,36624,36623,-1,36424,36425,36625,36624,-1,36425,36426,36626,36625,-1,36426,36427,36627,36626,-1,36427,36428,36628,36627,-1,36428,36429,36629,36628,-1,36429,36430,36630,36629,-1,36430,36431,36631,36630,-1,36431,36432,36632,36631,-1,36432,36433,36633,36632,-1,36433,36434,36634,36633,-1,36434,36435,36635,36634,-1,36435,36436,36636,36635,-1,36436,36437,36637,36636,-1,36437,36438,36638,36637,-1,36438,36439,36639,36638,-1,36439,36440,36640,36639,-1,36440,36441,36641,36640,-1,36441,36442,36642,36641,-1,36442,36443,36643,36642,-1,36443,36444,36644,36643,-1,36444,36445,36645,36644,-1,36445,36446,36646,36645,-1,36446,36447,36647,36646,-1,36447,36448,36648,36647,-1,36448,36449,36649,36648,-1,36449,36450,36650,36649,-1,36450,36451,36651,36650,-1,36451,36452,36652,36651,-1,36452,36453,36653,36652,-1,36453,36454,36654,36653,-1,36454,36455,36655,36654,-1,36455,36456,36656,36655,-1,36456,36457,36657,36656,-1,36457,36458,36658,36657,-1,36458,36459,36659,36658,-1,36459,36460,36660,36659,-1,36460,36461,36661,36660,-1,36461,36462,36662,36661,-1,36462,36463,36663,36662,-1,36463,36464,36664,36663,-1,36464,36465,36665,36664,-1,36465,36466,36666,36665,-1,36466,36467,36667,36666,-1,36467,36468,36668,36667,-1,36468,36469,36669,36668,-1,36469,36470,36670,36669,-1,36470,36471,36671,36670,-1,36471,36472,36672,36671,-1,36472,36473,36673,36672,-1,36473,36474,36674,36673,-1,36474,36475,36675,36674,-1,36475,36476,36676,36675,-1,36476,36477,36677,36676,-1,36477,36478,36678,36677,-1,36478,36479,36679,36678,-1,36479,36480,36680,36679,-1,36480,36481,36681,36680,-1,36481,36482,36682,36681,-1,36482,36483,36683,36682,-1,36483,36484,36684,36683,-1,36484,36485,36685,36684,-1,36485,36486,36686,36685,-1,36486,36487,36687,36686,-1,36487,36488,36688,36687,-1,36488,36489,36689,36688,-1,36489,36490,36690,36689,-1,36490,36491,36691,36690,-1,36491,36492,36692,36691,-1,36492,36493,36693,36692,-1,36493,36494,36694,36693,-1,36494,36495,36695,36694,-1,36495,36496,36696,36695,-1,36496,36497,36697,36696,-1,36497,36498,36698,36697,-1,36498,36499,36699,36698,-1,36499,36500,36700,36699,-1,36500,36501,36701,36700,-1,36501,36502,36702,36701,-1,36502,36503,36703,36702,-1,36503,36504,36704,36703,-1,36504,36505,36705,36704,-1,36505,36506,36706,36705,-1,36506,36507,36707,36706,-1,36507,36508,36708,36707,-1,36508,36509,36709,36708,-1,36509,36510,36710,36709,-1,36510,36511,36711,36710,-1,36511,36512,36712,36711,-1,36512,36513,36713,36712,-1,36513,36514,36714,36713,-1,36514,36515,36715,36714,-1,36515,36516,36716,36715,-1,36516,36517,36717,36716,-1,36517,36518,36718,36717,-1,36518,36519,36719,36718,-1,36519,36520,36720,36719,-1,36520,36521,36721,36720,-1,36521,36522,36722,36721,-1,36522,36523,36723,36722,-1,36523,36524,36724,36723,-1,36524,36525,36725,36724,-1,36525,36526,36726,36725,-1,36526,36527,36727,36726,-1,36527,36528,36728,36727,-1,36528,36529,36729,36728,-1,36529,36530,36730,36729,-1,36530,36531,36731,36730,-1,36531,36532,36732,36731,-1,36532,36533,36733,36732,-1,36533,36534,36734,36733,-1,36534,36535,36735,36734,-1,36535,36536,36736,36735,-1,36536,36537,36737,36736,-1,36537,36538,36738,36737,-1,36538,36539,36739,36738,-1,36539,36540,36740,36739,-1,36540,36541,36741,36740,-1,36541,36542,36742,36741,-1,36542,36543,36743,36742,-1,36543,36544,36744,36743,-1,36544,36545,36745,36744,-1,36545,36546,36746,36745,-1,36546,36547,36747,36746,-1,36547,36548,36748,36747,-1,36548,36549,36749,36748,-1,36549,36550,36750,36749,-1,36550,36551,36751,36750,-1,36551,36552,36752,36751,-1,36552,36553,36753,36752,-1,36553,36554,36754,36753,-1,36554,36555,36755,36754,-1,36555,36556,36756,36755,-1,36556,36557,36757,36756,-1,36557,36558,36758,36757,-1,36558,36559,36759,36758,-1,36559,36560,36760,36759,-1,36560,36561,36761,36760,-1,36561,36562,36762,36761,-1,36562,36563,36763,36762,-1,36563,36564,36764,36763,-1,36564,36565,36765,36764,-1,36565,36566,36766,36765,-1,36566,36567,36767,36766,-1,36567,36568,36768,36767,-1,36568,36569,36769,36768,-1,36569,36570,36770,36769,-1,36570,36571,36771,36770,-1,36571,36572,36772,36771,-1,36572,36573,36773,36772,-1,36573,36574,36774,36773,-1,36574,36575,36775,36774,-1,36575,36576,36776,36775,-1,36576,36577,36777,36776,-1,36577,36578,36778,36777,-1,36578,36579,36779,36778,-1,36579,36580,36780,36779,-1,36580,36581,36781,36780,-1,36581,36582,36782,36781,-1,36582,36583,36783,36782,-1,36583,36584,36784,36783,-1,36584,36585,36785,36784,-1,36585,36586,36786,36785,-1,36586,36587,36787,36786,-1,36587,36588,36788,36787,-1,36588,36589,36789,36788,-1,36589,36590,36790,36789,-1,36590,36591,36791,36790,-1,36591,36592,36792,36791,-1,36592,36593,36793,36792,-1,36593,36594,36794,36793,-1,36594,36595,36795,36794,-1,36595,36596,36796,36795,-1,36596,36597,36797,36796,-1,36597,36598,36798,36797,-1,36598,36599,36799,36798,-1,36600,36601,36801,36800,-1,36601,36602,36802,36801,-1,36602,36603,36803,36802,-1,36603,36604,36804,36803,-1,36604,36605,36805,36804,-1,36605,36606,36806,36805,-1,36606,36607,36807,36806,-1,36607,36608,36808,36807,-1,36608,36609,36809,36808,-1,36609,36610,36810,36809,-1,36610,36611,36811,36810,-1,36611,36612,36812,36811,-1,36612,36613,36813,36812,-1,36613,36614,36814,36813,-1,36614,36615,36815,36814,-1,36615,36616,36816,36815,-1,36616,36617,36817,36816,-1,36617,36618,36818,36817,-1,36618,36619,36819,36818,-1,36619,36620,36820,36819,-1,36620,36621,36821,36820,-1,36621,36622,36822,36821,-1,36622,36623,36823,36822,-1,36623,36624,36824,36823,-1,36624,36625,36825,36824,-1,36625,36626,36826,36825,-1,36626,36627,36827,36826,-1,36627,36628,36828,36827,-1,36628,36629,36829,36828,-1,36629,36630,36830,36829,-1,36630,36631,36831,36830,-1,36631,36632,36832,36831,-1,36632,36633,36833,36832,-1,36633,36634,36834,36833,-1,36634,36635,36835,36834,-1,36635,36636,36836,36835,-1,36636,36637,36837,36836,-1,36637,36638,36838,36837,-1,36638,36639,36839,36838,-1,36639,36640,36840,36839,-1,36640,36641,36841,36840,-1,36641,36642,36842,36841,-1,36642,36643,36843,36842,-1,36643,36644,36844,36843,-1,36644,36645,36845,36844,-1,36645,36646,36846,36845,-1,36646,36647,36847,36846,-1,36647,36648,36848,36847,-1,36648,36649,36849,36848,-1,36649,36650,36850,36849,-1,36650,36651,36851,36850,-1,36651,36652,36852,36851,-1,36652,36653,36853,36852,-1,36653,36654,36854,36853,-1,36654,36655,36855,36854,-1,36655,36656,36856,36855,-1,36656,36657,36857,36856,-1,36657,36658,36858,36857,-1,36658,36659,36859,36858,-1,36659,36660,36860,36859,-1,36660,36661,36861,36860,-1,36661,36662,36862,36861,-1,36662,36663,36863,36862,-1,36663,36664,36864,36863,-1,36664,36665,36865,36864,-1,36665,36666,36866,36865,-1,36666,36667,36867,36866,-1,36667,36668,36868,36867,-1,36668,36669,36869,36868,-1,36669,36670,36870,36869,-1,36670,36671,36871,36870,-1,36671,36672,36872,36871,-1,36672,36673,36873,36872,-1,36673,36674,36874,36873,-1,36674,36675,36875,36874,-1,36675,36676,36876,36875,-1,36676,36677,36877,36876,-1,36677,36678,36878,36877,-1,36678,36679,36879,36878,-1,36679,36680,36880,36879,-1,36680,36681,36881,36880,-1,36681,36682,36882,36881,-1,36682,36683,36883,36882,-1,36683,36684,36884,36883,-1,36684,36685,36885,36884,-1,36685,36686,36886,36885,-1,36686,36687,36887,36886,-1,36687,36688,36888,36887,-1,36688,36689,36889,36888,-1,36689,36690,36890,36889,-1,36690,36691,36891,36890,-1,36691,36692,36892,36891,-1,36692,36693,36893,36892,-1,36693,36694,36894,36893,-1,36694,36695,36895,36894,-1,36695,36696,36896,36895,-1,36696,36697,36897,36896,-1,36697,36698,36898,36897,-1,36698,36699,36899,36898,-1,36699,36700,36900,36899,-1,36700,36701,36901,36900,-1,36701,36702,36902,36901,-1,36702,36703,36903,36902,-1,36703,36704,36904,36903,-1,36704,36705,36905,36904,-1,36705,36706,36906,36905,-1,36706,36707,36907,36906,-1,36707,36708,36908,36907,-1,36708,36709,36909,36908,-1,36709,36710,36910,36909,-1,36710,36711,36911,36910,-1,36711,36712,36912,36911,-1,36712,36713,36913,36912,-1,36713,36714,36914,36913,-1,36714,36715,36915,36914,-1,36715,36716,36916,36915,-1,36716,36717,36917,36916,-1,36717,36718,36918,36917,-1,36718,36719,36919,36918,-1,36719,36720,36920,36919,-1,36720,36721,36921,36920,-1,36721,36722,36922,36921,-1,36722,36723,36923,36922,-1,36723,36724,36924,36923,-1,36724,36725,36925,36924,-1,36725,36726,36926,36925,-1,36726,36727,36927,36926,-1,36727,36728,36928,36927,-1,36728,36729,36929,36928,-1,36729,36730,36930,36929,-1,36730,36731,36931,36930,-1,36731,36732,36932,36931,-1,36732,36733,36933,36932,-1,36733,36734,36934,36933,-1,36734,36735,36935,36934,-1,36735,36736,36936,36935,-1,36736,36737,36937,36936,-1,36737,36738,36938,36937,-1,36738,36739,36939,36938,-1,36739,36740,36940,36939,-1,36740,36741,36941,36940,-1,36741,36742,36942,36941,-1,36742,36743,36943,36942,-1,36743,36744,36944,36943,-1,36744,36745,36945,36944,-1,36745,36746,36946,36945,-1,36746,36747,36947,36946,-1,36747,36748,36948,36947,-1,36748,36749,36949,36948,-1,36749,36750,36950,36949,-1,36750,36751,36951,36950,-1,36751,36752,36952,36951,-1,36752,36753,36953,36952,-1,36753,36754,36954,36953,-1,36754,36755,36955,36954,-1,36755,36756,36956,36955,-1,36756,36757,36957,36956,-1,36757,36758,36958,36957,-1,36758,36759,36959,36958,-1,36759,36760,36960,36959,-1,36760,36761,36961,36960,-1,36761,36762,36962,36961,-1,36762,36763,36963,36962,-1,36763,36764,36964,36963,-1,36764,36765,36965,36964,-1,36765,36766,36966,36965,-1,36766,36767,36967,36966,-1,36767,36768,36968,36967,-1,36768,36769,36969,36968,-1,36769,36770,36970,36969,-1,36770,36771,36971,36970,-1,36771,36772,36972,36971,-1,36772,36773,36973,36972,-1,36773,36774,36974,36973,-1,36774,36775,36975,36974,-1,36775,36776,36976,36975,-1,36776,36777,36977,36976,-1,36777,36778,36978,36977,-1,36778,36779,36979,36978,-1,36779,36780,36980,36979,-1,36780,36781,36981,36980,-1,36781,36782,36982,36981,-1,36782,36783,36983,36982,-1,36783,36784,36984,36983,-1,36784,36785,36985,36984,-1,36785,36786,36986,36985,-1,36786,36787,36987,36986,-1,36787,36788,36988,36987,-1,36788,36789,36989,36988,-1,36789,36790,36990,36989,-1,36790,36791,36991,36990,-1,36791,36792,36992,36991,-1,36792,36793,36993,36992,-1,36793,36794,36994,36993,-1,36794,36795,36995,36994,-1,36795,36796,36996,36995,-1,36796,36797,36997,36996,-1,36797,36798,36998,36997,-1,36798,36799,36999,36998,-1,36800,36801,37001,37,-1,36801,36802,37002,37001,-1,36802,36803,37003,37002,-1,36803,36804,37004,37003,-1,36804,36805,37005,37004,-1,36805,36806,37006,37005,-1,36806,36807,37007,37006,-1,36807,36808,37008,37007,-1,36808,36809,37009,37008,-1,36809,36810,37010,37009,-1,36810,36811,37011,37010,-1,36811,36812,37012,37011,-1,36812,36813,37013,37012,-1,36813,36814,37014,37013,-1,36814,36815,37015,37014,-1,36815,36816,37016,37015,-1,36816,36817,37017,37016,-1,36817,36818,37018,37017,-1,36818,36819,37019,37018,-1,36819,36820,37020,37019,-1,36820,36821,37021,37020,-1,36821,36822,37022,37021,-1,36822,36823,37023,37022,-1,36823,36824,37024,37023,-1,36824,36825,37025,37024,-1,36825,36826,37026,37025,-1,36826,36827,37027,37026,-1,36827,36828,37028,37027,-1,36828,36829,37029,37028,-1,36829,36830,37030,37029,-1,36830,36831,37031,37030,-1,36831,36832,37032,37031,-1,36832,36833,37033,37032,-1,36833,36834,37034,37033,-1,36834,36835,37035,37034,-1,36835,36836,37036,37035,-1,36836,36837,37037,37036,-1,36837,36838,37038,37037,-1,36838,36839,37039,37038,-1,36839,36840,37040,37039,-1,36840,36841,37041,37040,-1,36841,36842,37042,37041,-1,36842,36843,37043,37042,-1,36843,36844,37044,37043,-1,36844,36845,37045,37044,-1,36845,36846,37046,37045,-1,36846,36847,37047,37046,-1,36847,36848,37048,37047,-1,36848,36849,37049,37048,-1,36849,36850,37050,37049,-1,36850,36851,37051,37050,-1,36851,36852,37052,37051,-1,36852,36853,37053,37052,-1,36853,36854,37054,37053,-1,36854,36855,37055,37054,-1,36855,36856,37056,37055,-1,36856,36857,37057,37056,-1,36857,36858,37058,37057,-1,36858,36859,37059,37058,-1,36859,36860,37060,37059,-1,36860,36861,37061,37060,-1,36861,36862,37062,37061,-1,36862,36863,37063,37062,-1,36863,36864,37064,37063,-1,36864,36865,37065,37064,-1,36865,36866,37066,37065,-1,36866,36867,37067,37066,-1,36867,36868,37068,37067,-1,36868,36869,37069,37068,-1,36869,36870,37070,37069,-1,36870,36871,37071,37070,-1,36871,36872,37072,37071,-1,36872,36873,37073,37072,-1,36873,36874,37074,37073,-1,36874,36875,37075,37074,-1,36875,36876,37076,37075,-1,36876,36877,37077,37076,-1,36877,36878,37078,37077,-1,36878,36879,37079,37078,-1,36879,36880,37080,37079,-1,36880,36881,37081,37080,-1,36881,36882,37082,37081,-1,36882,36883,37083,37082,-1,36883,36884,37084,37083,-1,36884,36885,37085,37084,-1,36885,36886,37086,37085,-1,36886,36887,37087,37086,-1,36887,36888,37088,37087,-1,36888,36889,37089,37088,-1,36889,36890,37090,37089,-1,36890,36891,37091,37090,-1,36891,36892,37092,37091,-1,36892,36893,37093,37092,-1,36893,36894,37094,37093,-1,36894,36895,37095,37094,-1,36895,36896,37096,37095,-1,36896,36897,37097,37096,-1,36897,36898,37098,37097,-1,36898,36899,37099,37098,-1,36899,36900,37100,37099,-1,36900,36901,37101,37100,-1,36901,36902,37102,37101,-1,36902,36903,37103,37102,-1,36903,36904,37104,37103,-1,36904,36905,37105,37104,-1,36905,36906,37106,37105,-1,36906,36907,37107,37106,-1,36907,36908,37108,37107,-1,36908,36909,37109,37108,-1,36909,36910,37110,37109,-1,36910,36911,37111,37110,-1,36911,36912,37112,37111,-1,36912,36913,37113,37112,-1,36913,36914,37114,37113,-1,36914,36915,37115,37114,-1,36915,36916,37116,37115,-1,36916,36917,37117,37116,-1,36917,36918,37118,37117,-1,36918,36919,37119,37118,-1,36919,36920,37120,37119,-1,36920,36921,37121,37120,-1,36921,36922,37122,37121,-1,36922,36923,37123,37122,-1,36923,36924,37124,37123,-1,36924,36925,37125,37124,-1,36925,36926,37126,37125,-1,36926,36927,37127,37126,-1,36927,36928,37128,37127,-1,36928,36929,37129,37128,-1,36929,36930,37130,37129,-1,36930,36931,37131,37130,-1,36931,36932,37132,37131,-1,36932,36933,37133,37132,-1,36933,36934,37134,37133,-1,36934,36935,37135,37134,-1,36935,36936,37136,37135,-1,36936,36937,37137,37136,-1,36937,36938,37138,37137,-1,36938,36939,37139,37138,-1,36939,36940,37140,37139,-1,36940,36941,37141,37140,-1,36941,36942,37142,37141,-1,36942,36943,37143,37142,-1,36943,36944,37144,37143,-1,36944,36945,37145,37144,-1,36945,36946,37146,37145,-1,36946,36947,37147,37146,-1,36947,36948,37148,37147,-1,36948,36949,37149,37148,-1,36949,36950,37150,37149,-1,36950,36951,37151,37150,-1,36951,36952,37152,37151,-1,36952,36953,37153,37152,-1,36953,36954,37154,37153,-1,36954,36955,37155,37154,-1,36955,36956,37156,37155,-1,36956,36957,37157,37156,-1,36957,36958,37158,37157,-1,36958,36959,37159,37158,-1,36959,36960,37160,37159,-1,36960,36961,37161,37160,-1,36961,36962,37162,37161,-1,36962,36963,37163,37162,-1,36963,36964,37164,37163,-1,36964,36965,37165,37164,-1,36965,36966,37166,37165,-1,36966,36967,37167,37166,-1,36967,36968,37168,37167,-1,36968,36969,37169,37168,-1,36969,36970,37170,37169,-1,36970,36971,37171,37170,-1,36971,36972,37172,37171,-1,36972,36973,37173,37172,-1,36973,36974,37174,37173,-1,36974,36975,37175,37174,-1,36975,36976,37176,37175,-1,36976,36977,37177,37176,-1,36977,36978,37178,37177,-1,36978,36979,37179,37178,-1,36979,36980,37180,37179,-1,36980,36981,37181,37180,-1,36981,36982,37182,37181,-1,36982,36983,37183,37182,-1,36983,36984,37184,37183,-1,36984,36985,37185,37184,-1,36985,36986,37186,37185,-1,36986,36987,37187,37186,-1,36987,36988,37188,37187,-1,36988,36989,37189,37188,-1,36989,36990,37190,37189,-1,36990,36991,37191,37190,-1,36991,36992,37192,37191,-1,36992,36993,37193,37192,-1,36993,36994,37194,37193,-1,36994,36995,37195,37194,-1,36995,36996,37196,37195,-1,36996,36997,37197,37196,-1,36997,36998,37198,37197,-1,36998,36999,37199,37198,-1,37,37001,37201,37200,-1,37001,37002,37202,37201,-1,37002,37003,37203,37202,-1,37003,37004,37204,37203,-1,37004,37005,37205,37204,-1,37005,37006,37206,37205,-1,37006,37007,37207,37206,-1,37007,37008,37208,37207,-1,37008,37009,37209,37208,-1,37009,37010,37210,37209,-1,37010,37011,37211,37210,-1,37011,37012,37212,37211,-1,37012,37013,37213,37212,-1,37013,37014,37214,37213,-1,37014,37015,37215,37214,-1,37015,37016,37216,37215,-1,37016,37017,37217,37216,-1,37017,37018,37218,37217,-1,37018,37019,37219,37218,-1,37019,37020,37220,37219,-1,37020,37021,37221,37220,-1,37021,37022,37222,37221,-1,37022,37023,37223,37222,-1,37023,37024,37224,37223,-1,37024,37025,37225,37224,-1,37025,37026,37226,37225,-1,37026,37027,37227,37226,-1,37027,37028,37228,37227,-1,37028,37029,37229,37228,-1,37029,37030,37230,37229,-1,37030,37031,37231,37230,-1,37031,37032,37232,37231,-1,37032,37033,37233,37232,-1,37033,37034,37234,37233,-1,37034,37035,37235,37234,-1,37035,37036,37236,37235,-1,37036,37037,37237,37236,-1,37037,37038,37238,37237,-1,37038,37039,37239,37238,-1,37039,37040,37240,37239,-1,37040,37041,37241,37240,-1,37041,37042,37242,37241,-1,37042,37043,37243,37242,-1,37043,37044,37244,37243,-1,37044,37045,37245,37244,-1,37045,37046,37246,37245,-1,37046,37047,37247,37246,-1,37047,37048,37248,37247,-1,37048,37049,37249,37248,-1,37049,37050,37250,37249,-1,37050,37051,37251,37250,-1,37051,37052,37252,37251,-1,37052,37053,37253,37252,-1,37053,37054,37254,37253,-1,37054,37055,37255,37254,-1,37055,37056,37256,37255,-1,37056,37057,37257,37256,-1,37057,37058,37258,37257,-1,37058,37059,37259,37258,-1,37059,37060,37260,37259,-1,37060,37061,37261,37260,-1,37061,37062,37262,37261,-1,37062,37063,37263,37262,-1,37063,37064,37264,37263,-1,37064,37065,37265,37264,-1,37065,37066,37266,37265,-1,37066,37067,37267,37266,-1,37067,37068,37268,37267,-1,37068,37069,37269,37268,-1,37069,37070,37270,37269,-1,37070,37071,37271,37270,-1,37071,37072,37272,37271,-1,37072,37073,37273,37272,-1,37073,37074,37274,37273,-1,37074,37075,37275,37274,-1,37075,37076,37276,37275,-1,37076,37077,37277,37276,-1,37077,37078,37278,37277,-1,37078,37079,37279,37278,-1,37079,37080,37280,37279,-1,37080,37081,37281,37280,-1,37081,37082,37282,37281,-1,37082,37083,37283,37282,-1,37083,37084,37284,37283,-1,37084,37085,37285,37284,-1,37085,37086,37286,37285,-1,37086,37087,37287,37286,-1,37087,37088,37288,37287,-1,37088,37089,37289,37288,-1,37089,37090,37290,37289,-1,37090,37091,37291,37290,-1,37091,37092,37292,37291,-1,37092,37093,37293,37292,-1,37093,37094,37294,37293,-1,37094,37095,37295,37294,-1,37095,37096,37296,37295,-1,37096,37097,37297,37296,-1,37097,37098,37298,37297,-1,37098,37099,37299,37298,-1,37099,37100,37300,37299,-1,37100,37101,37301,37300,-1,37101,37102,37302,37301,-1,37102,37103,37303,37302,-1,37103,37104,37304,37303,-1,37104,37105,37305,37304,-1,37105,37106,37306,37305,-1,37106,37107,37307,37306,-1,37107,37108,37308,37307,-1,37108,37109,37309,37308,-1,37109,37110,37310,37309,-1,37110,37111,37311,37310,-1,37111,37112,37312,37311,-1,37112,37113,37313,37312,-1,37113,37114,37314,37313,-1,37114,37115,37315,37314,-1,37115,37116,37316,37315,-1,37116,37117,37317,37316,-1,37117,37118,37318,37317,-1,37118,37119,37319,37318,-1,37119,37120,37320,37319,-1,37120,37121,37321,37320,-1,37121,37122,37322,37321,-1,37122,37123,37323,37322,-1,37123,37124,37324,37323,-1,37124,37125,37325,37324,-1,37125,37126,37326,37325,-1,37126,37127,37327,37326,-1,37127,37128,37328,37327,-1,37128,37129,37329,37328,-1,37129,37130,37330,37329,-1,37130,37131,37331,37330,-1,37131,37132,37332,37331,-1,37132,37133,37333,37332,-1,37133,37134,37334,37333,-1,37134,37135,37335,37334,-1,37135,37136,37336,37335,-1,37136,37137,37337,37336,-1,37137,37138,37338,37337,-1,37138,37139,37339,37338,-1,37139,37140,37340,37339,-1,37140,37141,37341,37340,-1,37141,37142,37342,37341,-1,37142,37143,37343,37342,-1,37143,37144,37344,37343,-1,37144,37145,37345,37344,-1,37145,37146,37346,37345,-1,37146,37147,37347,37346,-1,37147,37148,37348,37347,-1,37148,37149,37349,37348,-1,37149,37150,37350,37349,-1,37150,37151,37351,37350,-1,37151,37152,37352,37351,-1,37152,37153,37353,37352,-1,37153,37154,37354,37353,-1,37154,37155,37355,37354,-1,37155,37156,37356,37355,-1,37156,37157,37357,37356,-1,37157,37158,37358,37357,-1,37158,37159,37359,37358,-1,37159,37160,37360,37359,-1,37160,37161,37361,37360,-1,37161,37162,37362,37361,-1,37162,37163,37363,37362,-1,37163,37164,37364,37363,-1,37164,37165,37365,37364,-1,37165,37166,37366,37365,-1,37166,37167,37367,37366,-1,37167,37168,37368,37367,-1,37168,37169,37369,37368,-1,37169,37170,37370,37369,-1,37170,37171,37371,37370,-1,37171,37172,37372,37371,-1,37172,37173,37373,37372,-1,37173,37174,37374,37373,-1,37174,37175,37375,37374,-1,37175,37176,37376,37375,-1,37176,37177,37377,37376,-1,37177,37178,37378,37377,-1,37178,37179,37379,37378,-1,37179,37180,37380,37379,-1,37180,37181,37381,37380,-1,37181,37182,37382,37381,-1,37182,37183,37383,37382,-1,37183,37184,37384,37383,-1,37184,37185,37385,37384,-1,37185,37186,37386,37385,-1,37186,37187,37387,37386,-1,37187,37188,37388,37387,-1,37188,37189,37389,37388,-1,37189,37190,37390,37389,-1,37190,37191,37391,37390,-1,37191,37192,37392,37391,-1,37192,37193,37393,37392,-1,37193,37194,37394,37393,-1,37194,37195,37395,37394,-1,37195,37196,37396,37395,-1,37196,37197,37397,37396,-1,37197,37198,37398,37397,-1,37198,37199,37399,37398,-1,37200,37201,37401,37400,-1,37201,37202,37402,37401,-1,37202,37203,37403,37402,-1,37203,37204,37404,37403,-1,37204,37205,37405,37404,-1,37205,37206,37406,37405,-1,37206,37207,37407,37406,-1,37207,37208,37408,37407,-1,37208,37209,37409,37408,-1,37209,37210,37410,37409,-1,37210,37211,37411,37410,-1,37211,37212,37412,37411,-1,37212,37213,37413,37412,-1,37213,37214,37414,37413,-1,37214,37215,37415,37414,-1,37215,37216,37416,37415,-1,37216,37217,37417,37416,-1,37217,37218,37418,37417,-1,37218,37219,37419,37418,-1,37219,37220,37420,37419,-1,37220,37221,37421,37420,-1,37221,37222,37422,37421,-1,37222,37223,37423,37422,-1,37223,37224,37424,37423,-1,37224,37225,37425,37424,-1,37225,37226,37426,37425,-1,37226,37227,37427,37426,-1,37227,37228,37428,37427,-1,37228,37229,37429,37428,-1,37229,37230,37430,37429,-1,37230,37231,37431,37430,-1,37231,37232,37432,37431,-1,37232,37233,37433,37432,-1,37233,37234,37434,37433,-1,37234,37235,37435,37434,-1,37235,37236,37436,37435,-1,37236,37237,37437,37436,-1,37237,37238,37438,37437,-1,37238,37239,37439,37438,-1,37239,37240,37440,37439,-1,37240,37241,37441,37440,-1,37241,37242,37442,37441,-1,37242,37243,37443,37442,-1,37243,37244,37444,37443,-1,37244,37245,37445,37444,-1,37245,37246,37446,37445,-1,37246,37247,37447,37446,-1,37247,37248,37448,37447,-1,37248,37249,37449,37448,-1,37249,37250,37450,37449,-1,37250,37251,37451,37450,-1,37251,37252,37452,37451,-1,37252,37253,37453,37452,-1,37253,37254,37454,37453,-1,37254,37255,37455,37454,-1,37255,37256,37456,37455,-1,37256,37257,37457,37456,-1,37257,37258,37458,37457,-1,37258,37259,37459,37458,-1,37259,37260,37460,37459,-1,37260,37261,37461,37460,-1,37261,37262,37462,37461,-1,37262,37263,37463,37462,-1,37263,37264,37464,37463,-1,37264,37265,37465,37464,-1,37265,37266,37466,37465,-1,37266,37267,37467,37466,-1,37267,37268,37468,37467,-1,37268,37269,37469,37468,-1,37269,37270,37470,37469,-1,37270,37271,37471,37470,-1,37271,37272,37472,37471,-1,37272,37273,37473,37472,-1,37273,37274,37474,37473,-1,37274,37275,37475,37474,-1,37275,37276,37476,37475,-1,37276,37277,37477,37476,-1,37277,37278,37478,37477,-1,37278,37279,37479,37478,-1,37279,37280,37480,37479,-1,37280,37281,37481,37480,-1,37281,37282,37482,37481,-1,37282,37283,37483,37482,-1,37283,37284,37484,37483,-1,37284,37285,37485,37484,-1,37285,37286,37486,37485,-1,37286,37287,37487,37486,-1,37287,37288,37488,37487,-1,37288,37289,37489,37488,-1,37289,37290,37490,37489,-1,37290,37291,37491,37490,-1,37291,37292,37492,37491,-1,37292,37293,37493,37492,-1,37293,37294,37494,37493,-1,37294,37295,37495,37494,-1,37295,37296,37496,37495,-1,37296,37297,37497,37496,-1,37297,37298,37498,37497,-1,37298,37299,37499,37498,-1,37299,37300,37500,37499,-1,37300,37301,37501,37500,-1,37301,37302,37502,37501,-1,37302,37303,37503,37502,-1,37303,37304,37504,37503,-1,37304,37305,37505,37504,-1,37305,37306,37506,37505,-1,37306,37307,37507,37506,-1,37307,37308,37508,37507,-1,37308,37309,37509,37508,-1,37309,37310,37510,37509,-1,37310,37311,37511,37510,-1,37311,37312,37512,37511,-1,37312,37313,37513,37512,-1,37313,37314,37514,37513,-1,37314,37315,37515,37514,-1,37315,37316,37516,37515,-1,37316,37317,37517,37516,-1,37317,37318,37518,37517,-1,37318,37319,37519,37518,-1,37319,37320,37520,37519,-1,37320,37321,37521,37520,-1,37321,37322,37522,37521,-1,37322,37323,37523,37522,-1,37323,37324,37524,37523,-1,37324,37325,37525,37524,-1,37325,37326,37526,37525,-1,37326,37327,37527,37526,-1,37327,37328,37528,37527,-1,37328,37329,37529,37528,-1,37329,37330,37530,37529,-1,37330,37331,37531,37530,-1,37331,37332,37532,37531,-1,37332,37333,37533,37532,-1,37333,37334,37534,37533,-1,37334,37335,37535,37534,-1,37335,37336,37536,37535,-1,37336,37337,37537,37536,-1,37337,37338,37538,37537,-1,37338,37339,37539,37538,-1,37339,37340,37540,37539,-1,37340,37341,37541,37540,-1,37341,37342,37542,37541,-1,37342,37343,37543,37542,-1,37343,37344,37544,37543,-1,37344,37345,37545,37544,-1,37345,37346,37546,37545,-1,37346,37347,37547,37546,-1,37347,37348,37548,37547,-1,37348,37349,37549,37548,-1,37349,37350,37550,37549,-1,37350,37351,37551,37550,-1,37351,37352,37552,37551,-1,37352,37353,37553,37552,-1,37353,37354,37554,37553,-1,37354,37355,37555,37554,-1,37355,37356,37556,37555,-1,37356,37357,37557,37556,-1,37357,37358,37558,37557,-1,37358,37359,37559,37558,-1,37359,37360,37560,37559,-1,37360,37361,37561,37560,-1,37361,37362,37562,37561,-1,37362,37363,37563,37562,-1,37363,37364,37564,37563,-1,37364,37365,37565,37564,-1,37365,37366,37566,37565,-1,37366,37367,37567,37566,-1,37367,37368,37568,37567,-1,37368,37369,37569,37568,-1,37369,37370,37570,37569,-1,37370,37371,37571,37570,-1,37371,37372,37572,37571,-1,37372,37373,37573,37572,-1,37373,37374,37574,37573,-1,37374,37375,37575,37574,-1,37375,37376,37576,37575,-1,37376,37377,37577,37576,-1,37377,37378,37578,37577,-1,37378,37379,37579,37578,-1,37379,37380,37580,37579,-1,37380,37381,37581,37580,-1,37381,37382,37582,37581,-1,37382,37383,37583,37582,-1,37383,37384,37584,37583,-1,37384,37385,37585,37584,-1,37385,37386,37586,37585,-1,37386,37387,37587,37586,-1,37387,37388,37588,37587,-1,37388,37389,37589,37588,-1,37389,37390,37590,37589,-1,37390,37391,37591,37590,-1,37391,37392,37592,37591,-1,37392,37393,37593,37592,-1,37393,37394,37594,37593,-1,37394,37395,37595,37594,-1,37395,37396,37596,37595,-1,37396,37397,37597,37596,-1,37397,37398,37598,37597,-1,37398,37399,37599,37598,-1,37400,37401,37601,37600,-1,37401,37402,37602,37601,-1,37402,37403,37603,37602,-1,37403,37404,37604,37603,-1,37404,37405,37605,37604,-1,37405,37406,37606,37605,-1,37406,37407,37607,37606,-1,37407,37408,37608,37607,-1,37408,37409,37609,37608,-1,37409,37410,37610,37609,-1,37410,37411,37611,37610,-1,37411,37412,37612,37611,-1,37412,37413,37613,37612,-1,37413,37414,37614,37613,-1,37414,37415,37615,37614,-1,37415,37416,37616,37615,-1,37416,37417,37617,37616,-1,37417,37418,37618,37617,-1,37418,37419,37619,37618,-1,37419,37420,37620,37619,-1,37420,37421,37621,37620,-1,37421,37422,37622,37621,-1,37422,37423,37623,37622,-1,37423,37424,37624,37623,-1,37424,37425,37625,37624,-1,37425,37426,37626,37625,-1,37426,37427,37627,37626,-1,37427,37428,37628,37627,-1,37428,37429,37629,37628,-1,37429,37430,37630,37629,-1,37430,37431,37631,37630,-1,37431,37432,37632,37631,-1,37432,37433,37633,37632,-1,37433,37434,37634,37633,-1,37434,37435,37635,37634,-1,37435,37436,37636,37635,-1,37436,37437,37637,37636,-1,37437,37438,37638,37637,-1,37438,37439,37639,37638,-1,37439,37440,37640,37639,-1,37440,37441,37641,37640,-1,37441,37442,37642,37641,-1,37442,37443,37643,37642,-1,37443,37444,37644,37643,-1,37444,37445,37645,37644,-1,37445,37446,37646,37645,-1,37446,37447,37647,37646,-1,37447,37448,37648,37647,-1,37448,37449,37649,37648,-1,37449,37450,37650,37649,-1,37450,37451,37651,37650,-1,37451,37452,37652,37651,-1,37452,37453,37653,37652,-1,37453,37454,37654,37653,-1,37454,37455,37655,37654,-1,37455,37456,37656,37655,-1,37456,37457,37657,37656,-1,37457,37458,37658,37657,-1,37458,37459,37659,37658,-1,37459,37460,37660,37659,-1,37460,37461,37661,37660,-1,37461,37462,37662,37661,-1,37462,37463,37663,37662,-1,37463,37464,37664,37663,-1,37464,37465,37665,37664,-1,37465,37466,37666,37665,-1,37466,37467,37667,37666,-1,37467,37468,37668,37667,-1,37468,37469,37669,37668,-1,37469,37470,37670,37669,-1,37470,37471,37671,37670,-1,37471,37472,37672,37671,-1,37472,37473,37673,37672,-1,37473,37474,37674,37673,-1,37474,37475,37675,37674,-1,37475,37476,37676,37675,-1,37476,37477,37677,37676,-1,37477,37478,37678,37677,-1,37478,37479,37679,37678,-1,37479,37480,37680,37679,-1,37480,37481,37681,37680,-1,37481,37482,37682,37681,-1,37482,37483,37683,37682,-1,37483,37484,37684,37683,-1,37484,37485,37685,37684,-1,37485,37486,37686,37685,-1,37486,37487,37687,37686,-1,37487,37488,37688,37687,-1,37488,37489,37689,37688,-1,37489,37490,37690,37689,-1,37490,37491,37691,37690,-1,37491,37492,37692,37691,-1,37492,37493,37693,37692,-1,37493,37494,37694,37693,-1,37494,37495,37695,37694,-1,37495,37496,37696,37695,-1,37496,37497,37697,37696,-1,37497,37498,37698,37697,-1,37498,37499,37699,37698,-1,37499,37500,37700,37699,-1,37500,37501,37701,37700,-1,37501,37502,37702,37701,-1,37502,37503,37703,37702,-1,37503,37504,37704,37703,-1,37504,37505,37705,37704,-1,37505,37506,37706,37705,-1,37506,37507,37707,37706,-1,37507,37508,37708,37707,-1,37508,37509,37709,37708,-1,37509,37510,37710,37709,-1,37510,37511,37711,37710,-1,37511,37512,37712,37711,-1,37512,37513,37713,37712,-1,37513,37514,37714,37713,-1,37514,37515,37715,37714,-1,37515,37516,37716,37715,-1,37516,37517,37717,37716,-1,37517,37518,37718,37717,-1,37518,37519,37719,37718,-1,37519,37520,37720,37719,-1,37520,37521,37721,37720,-1,37521,37522,37722,37721,-1,37522,37523,37723,37722,-1,37523,37524,37724,37723,-1,37524,37525,37725,37724,-1,37525,37526,37726,37725,-1,37526,37527,37727,37726,-1,37527,37528,37728,37727,-1,37528,37529,37729,37728,-1,37529,37530,37730,37729,-1,37530,37531,37731,37730,-1,37531,37532,37732,37731,-1,37532,37533,37733,37732,-1,37533,37534,37734,37733,-1,37534,37535,37735,37734,-1,37535,37536,37736,37735,-1,37536,37537,37737,37736,-1,37537,37538,37738,37737,-1,37538,37539,37739,37738,-1,37539,37540,37740,37739,-1,37540,37541,37741,37740,-1,37541,37542,37742,37741,-1,37542,37543,37743,37742,-1,37543,37544,37744,37743,-1,37544,37545,37745,37744,-1,37545,37546,37746,37745,-1,37546,37547,37747,37746,-1,37547,37548,37748,37747,-1,37548,37549,37749,37748,-1,37549,37550,37750,37749,-1,37550,37551,37751,37750,-1,37551,37552,37752,37751,-1,37552,37553,37753,37752,-1,37553,37554,37754,37753,-1,37554,37555,37755,37754,-1,37555,37556,37756,37755,-1,37556,37557,37757,37756,-1,37557,37558,37758,37757,-1,37558,37559,37759,37758,-1,37559,37560,37760,37759,-1,37560,37561,37761,37760,-1,37561,37562,37762,37761,-1,37562,37563,37763,37762,-1,37563,37564,37764,37763,-1,37564,37565,37765,37764,-1,37565,37566,37766,37765,-1,37566,37567,37767,37766,-1,37567,37568,37768,37767,-1,37568,37569,37769,37768,-1,37569,37570,37770,37769,-1,37570,37571,37771,37770,-1,37571,37572,37772,37771,-1,37572,37573,37773,37772,-1,37573,37574,37774,37773,-1,37574,37575,37775,37774,-1,37575,37576,37776,37775,-1,37576,37577,37777,37776,-1,37577,37578,37778,37777,-1,37578,37579,37779,37778,-1,37579,37580,37780,37779,-1,37580,37581,37781,37780,-1,37581,37582,37782,37781,-1,37582,37583,37783,37782,-1,37583,37584,37784,37783,-1,37584,37585,37785,37784,-1,37585,37586,37786,37785,-1,37586,37587,37787,37786,-1,37587,37588,37788,37787,-1,37588,37589,37789,37788,-1,37589,37590,37790,37789,-1,37590,37591,37791,37790,-1,37591,37592,37792,37791,-1,37592,37593,37793,37792,-1,37593,37594,37794,37793,-1,37594,37595,37795,37794,-1,37595,37596,37796,37795,-1,37596,37597,37797,37796,-1,37597,37598,37798,37797,-1,37598,37599,37799,37798,-1,37600,37601,37801,37800,-1,37601,37602,37802,37801,-1,37602,37603,37803,37802,-1,37603,37604,37804,37803,-1,37604,37605,37805,37804,-1,37605,37606,37806,37805,-1,37606,37607,37807,37806,-1,37607,37608,37808,37807,-1,37608,37609,37809,37808,-1,37609,37610,37810,37809,-1,37610,37611,37811,37810,-1,37611,37612,37812,37811,-1,37612,37613,37813,37812,-1,37613,37614,37814,37813,-1,37614,37615,37815,37814,-1,37615,37616,37816,37815,-1,37616,37617,37817,37816,-1,37617,37618,37818,37817,-1,37618,37619,37819,37818,-1,37619,37620,37820,37819,-1,37620,37621,37821,37820,-1,37621,37622,37822,37821,-1,37622,37623,37823,37822,-1,37623,37624,37824,37823,-1,37624,37625,37825,37824,-1,37625,37626,37826,37825,-1,37626,37627,37827,37826,-1,37627,37628,37828,37827,-1,37628,37629,37829,37828,-1,37629,37630,37830,37829,-1,37630,37631,37831,37830,-1,37631,37632,37832,37831,-1,37632,37633,37833,37832,-1,37633,37634,37834,37833,-1,37634,37635,37835,37834,-1,37635,37636,37836,37835,-1,37636,37637,37837,37836,-1,37637,37638,37838,37837,-1,37638,37639,37839,37838,-1,37639,37640,37840,37839,-1,37640,37641,37841,37840,-1,37641,37642,37842,37841,-1,37642,37643,37843,37842,-1,37643,37644,37844,37843,-1,37644,37645,37845,37844,-1,37645,37646,37846,37845,-1,37646,37647,37847,37846,-1,37647,37648,37848,37847,-1,37648,37649,37849,37848,-1,37649,37650,37850,37849,-1,37650,37651,37851,37850,-1,37651,37652,37852,37851,-1,37652,37653,37853,37852,-1,37653,37654,37854,37853,-1,37654,37655,37855,37854,-1,37655,37656,37856,37855,-1,37656,37657,37857,37856,-1,37657,37658,37858,37857,-1,37658,37659,37859,37858,-1,37659,37660,37860,37859,-1,37660,37661,37861,37860,-1,37661,37662,37862,37861,-1,37662,37663,37863,37862,-1,37663,37664,37864,37863,-1,37664,37665,37865,37864,-1,37665,37666,37866,37865,-1,37666,37667,37867,37866,-1,37667,37668,37868,37867,-1,37668,37669,37869,37868,-1,37669,37670,37870,37869,-1,37670,37671,37871,37870,-1,37671,37672,37872,37871,-1,37672,37673,37873,37872,-1,37673,37674,37874,37873,-1,37674,37675,37875,37874,-1,37675,37676,37876,37875,-1,37676,37677,37877,37876,-1,37677,37678,37878,37877,-1,37678,37679,37879,37878,-1,37679,37680,37880,37879,-1,37680,37681,37881,37880,-1,37681,37682,37882,37881,-1,37682,37683,37883,37882,-1,37683,37684,37884,37883,-1,37684,37685,37885,37884,-1,37685,37686,37886,37885,-1,37686,37687,37887,37886,-1,37687,37688,37888,37887,-1,37688,37689,37889,37888,-1,37689,37690,37890,37889,-1,37690,37691,37891,37890,-1,37691,37692,37892,37891,-1,37692,37693,37893,37892,-1,37693,37694,37894,37893,-1,37694,37695,37895,37894,-1,37695,37696,37896,37895,-1,37696,37697,37897,37896,-1,37697,37698,37898,37897,-1,37698,37699,37899,37898,-1,37699,37700,37900,37899,-1,37700,37701,37901,37900,-1,37701,37702,37902,37901,-1,37702,37703,37903,37902,-1,37703,37704,37904,37903,-1,37704,37705,37905,37904,-1,37705,37706,37906,37905,-1,37706,37707,37907,37906,-1,37707,37708,37908,37907,-1,37708,37709,37909,37908,-1,37709,37710,37910,37909,-1,37710,37711,37911,37910,-1,37711,37712,37912,37911,-1,37712,37713,37913,37912,-1,37713,37714,37914,37913,-1,37714,37715,37915,37914,-1,37715,37716,37916,37915,-1,37716,37717,37917,37916,-1,37717,37718,37918,37917,-1,37718,37719,37919,37918,-1,37719,37720,37920,37919,-1,37720,37721,37921,37920,-1,37721,37722,37922,37921,-1,37722,37723,37923,37922,-1,37723,37724,37924,37923,-1,37724,37725,37925,37924,-1,37725,37726,37926,37925,-1,37726,37727,37927,37926,-1,37727,37728,37928,37927,-1,37728,37729,37929,37928,-1,37729,37730,37930,37929,-1,37730,37731,37931,37930,-1,37731,37732,37932,37931,-1,37732,37733,37933,37932,-1,37733,37734,37934,37933,-1,37734,37735,37935,37934,-1,37735,37736,37936,37935,-1,37736,37737,37937,37936,-1,37737,37738,37938,37937,-1,37738,37739,37939,37938,-1,37739,37740,37940,37939,-1,37740,37741,37941,37940,-1,37741,37742,37942,37941,-1,37742,37743,37943,37942,-1,37743,37744,37944,37943,-1,37744,37745,37945,37944,-1,37745,37746,37946,37945,-1,37746,37747,37947,37946,-1,37747,37748,37948,37947,-1,37748,37749,37949,37948,-1,37749,37750,37950,37949,-1,37750,37751,37951,37950,-1,37751,37752,37952,37951,-1,37752,37753,37953,37952,-1,37753,37754,37954,37953,-1,37754,37755,37955,37954,-1,37755,37756,37956,37955,-1,37756,37757,37957,37956,-1,37757,37758,37958,37957,-1,37758,37759,37959,37958,-1,37759,37760,37960,37959,-1,37760,37761,37961,37960,-1,37761,37762,37962,37961,-1,37762,37763,37963,37962,-1,37763,37764,37964,37963,-1,37764,37765,37965,37964,-1,37765,37766,37966,37965,-1,37766,37767,37967,37966,-1,37767,37768,37968,37967,-1,37768,37769,37969,37968,-1,37769,37770,37970,37969,-1,37770,37771,37971,37970,-1,37771,37772,37972,37971,-1,37772,37773,37973,37972,-1,37773,37774,37974,37973,-1,37774,37775,37975,37974,-1,37775,37776,37976,37975,-1,37776,37777,37977,37976,-1,37777,37778,37978,37977,-1,37778,37779,37979,37978,-1,37779,37780,37980,37979,-1,37780,37781,37981,37980,-1,37781,37782,37982,37981,-1,37782,37783,37983,37982,-1,37783,37784,37984,37983,-1,37784,37785,37985,37984,-1,37785,37786,37986,37985,-1,37786,37787,37987,37986,-1,37787,37788,37988,37987,-1,37788,37789,37989,37988,-1,37789,37790,37990,37989,-1,37790,37791,37991,37990,-1,37791,37792,37992,37991,-1,37792,37793,37993,37992,-1,37793,37794,37994,37993,-1,37794,37795,37995,37994,-1,37795,37796,37996,37995,-1,37796,37797,37997,37996,-1,37797,37798,37998,37997,-1,37798,37799,37999,37998,-1,37800,37801,38001,38,-1,37801,37802,38002,38001,-1,37802,37803,38003,38002,-1,37803,37804,38004,38003,-1,37804,37805,38005,38004,-1,37805,37806,38006,38005,-1,37806,37807,38007,38006,-1,37807,37808,38008,38007,-1,37808,37809,38009,38008,-1,37809,37810,38010,38009,-1,37810,37811,38011,38010,-1,37811,37812,38012,38011,-1,37812,37813,38013,38012,-1,37813,37814,38014,38013,-1,37814,37815,38015,38014,-1,37815,37816,38016,38015,-1,37816,37817,38017,38016,-1,37817,37818,38018,38017,-1,37818,37819,38019,38018,-1,37819,37820,38020,38019,-1,37820,37821,38021,38020,-1,37821,37822,38022,38021,-1,37822,37823,38023,38022,-1,37823,37824,38024,38023,-1,37824,37825,38025,38024,-1,37825,37826,38026,38025,-1,37826,37827,38027,38026,-1,37827,37828,38028,38027,-1,37828,37829,38029,38028,-1,37829,37830,38030,38029,-1,37830,37831,38031,38030,-1,37831,37832,38032,38031,-1,37832,37833,38033,38032,-1,37833,37834,38034,38033,-1,37834,37835,38035,38034,-1,37835,37836,38036,38035,-1,37836,37837,38037,38036,-1,37837,37838,38038,38037,-1,37838,37839,38039,38038,-1,37839,37840,38040,38039,-1,37840,37841,38041,38040,-1,37841,37842,38042,38041,-1,37842,37843,38043,38042,-1,37843,37844,38044,38043,-1,37844,37845,38045,38044,-1,37845,37846,38046,38045,-1,37846,37847,38047,38046,-1,37847,37848,38048,38047,-1,37848,37849,38049,38048,-1,37849,37850,38050,38049,-1,37850,37851,38051,38050,-1,37851,37852,38052,38051,-1,37852,37853,38053,38052,-1,37853,37854,38054,38053,-1,37854,37855,38055,38054,-1,37855,37856,38056,38055,-1,37856,37857,38057,38056,-1,37857,37858,38058,38057,-1,37858,37859,38059,38058,-1,37859,37860,38060,38059,-1,37860,37861,38061,38060,-1,37861,37862,38062,38061,-1,37862,37863,38063,38062,-1,37863,37864,38064,38063,-1,37864,37865,38065,38064,-1,37865,37866,38066,38065,-1,37866,37867,38067,38066,-1,37867,37868,38068,38067,-1,37868,37869,38069,38068,-1,37869,37870,38070,38069,-1,37870,37871,38071,38070,-1,37871,37872,38072,38071,-1,37872,37873,38073,38072,-1,37873,37874,38074,38073,-1,37874,37875,38075,38074,-1,37875,37876,38076,38075,-1,37876,37877,38077,38076,-1,37877,37878,38078,38077,-1,37878,37879,38079,38078,-1,37879,37880,38080,38079,-1,37880,37881,38081,38080,-1,37881,37882,38082,38081,-1,37882,37883,38083,38082,-1,37883,37884,38084,38083,-1,37884,37885,38085,38084,-1,37885,37886,38086,38085,-1,37886,37887,38087,38086,-1,37887,37888,38088,38087,-1,37888,37889,38089,38088,-1,37889,37890,38090,38089,-1,37890,37891,38091,38090,-1,37891,37892,38092,38091,-1,37892,37893,38093,38092,-1,37893,37894,38094,38093,-1,37894,37895,38095,38094,-1,37895,37896,38096,38095,-1,37896,37897,38097,38096,-1,37897,37898,38098,38097,-1,37898,37899,38099,38098,-1,37899,37900,38100,38099,-1,37900,37901,38101,38100,-1,37901,37902,38102,38101,-1,37902,37903,38103,38102,-1,37903,37904,38104,38103,-1,37904,37905,38105,38104,-1,37905,37906,38106,38105,-1,37906,37907,38107,38106,-1,37907,37908,38108,38107,-1,37908,37909,38109,38108,-1,37909,37910,38110,38109,-1,37910,37911,38111,38110,-1,37911,37912,38112,38111,-1,37912,37913,38113,38112,-1,37913,37914,38114,38113,-1,37914,37915,38115,38114,-1,37915,37916,38116,38115,-1,37916,37917,38117,38116,-1,37917,37918,38118,38117,-1,37918,37919,38119,38118,-1,37919,37920,38120,38119,-1,37920,37921,38121,38120,-1,37921,37922,38122,38121,-1,37922,37923,38123,38122,-1,37923,37924,38124,38123,-1,37924,37925,38125,38124,-1,37925,37926,38126,38125,-1,37926,37927,38127,38126,-1,37927,37928,38128,38127,-1,37928,37929,38129,38128,-1,37929,37930,38130,38129,-1,37930,37931,38131,38130,-1,37931,37932,38132,38131,-1,37932,37933,38133,38132,-1,37933,37934,38134,38133,-1,37934,37935,38135,38134,-1,37935,37936,38136,38135,-1,37936,37937,38137,38136,-1,37937,37938,38138,38137,-1,37938,37939,38139,38138,-1,37939,37940,38140,38139,-1,37940,37941,38141,38140,-1,37941,37942,38142,38141,-1,37942,37943,38143,38142,-1,37943,37944,38144,38143,-1,37944,37945,38145,38144,-1,37945,37946,38146,38145,-1,37946,37947,38147,38146,-1,37947,37948,38148,38147,-1,37948,37949,38149,38148,-1,37949,37950,38150,38149,-1,37950,37951,38151,38150,-1,37951,37952,38152,38151,-1,37952,37953,38153,38152,-1,37953,37954,38154,38153,-1,37954,37955,38155,38154,-1,37955,37956,38156,38155,-1,37956,37957,38157,38156,-1,37957,37958,38158,38157,-1,37958,37959,38159,38158,-1,37959,37960,38160,38159,-1,37960,37961,38161,38160,-1,37961,37962,38162,38161,-1,37962,37963,38163,38162,-1,37963,37964,38164,38163,-1,37964,37965,38165,38164,-1,37965,37966,38166,38165,-1,37966,37967,38167,38166,-1,37967,37968,38168,38167,-1,37968,37969,38169,38168,-1,37969,37970,38170,38169,-1,37970,37971,38171,38170,-1,37971,37972,38172,38171,-1,37972,37973,38173,38172,-1,37973,37974,38174,38173,-1,37974,37975,38175,38174,-1,37975,37976,38176,38175,-1,37976,37977,38177,38176,-1,37977,37978,38178,38177,-1,37978,37979,38179,38178,-1,37979,37980,38180,38179,-1,37980,37981,38181,38180,-1,37981,37982,38182,38181,-1,37982,37983,38183,38182,-1,37983,37984,38184,38183,-1,37984,37985,38185,38184,-1,37985,37986,38186,38185,-1,37986,37987,38187,38186,-1,37987,37988,38188,38187,-1,37988,37989,38189,38188,-1,37989,37990,38190,38189,-1,37990,37991,38191,38190,-1,37991,37992,38192,38191,-1,37992,37993,38193,38192,-1,37993,37994,38194,38193,-1,37994,37995,38195,38194,-1,37995,37996,38196,38195,-1,37996,37997,38197,38196,-1,37997,37998,38198,38197,-1,37998,37999,38199,38198,-1,38,38001,38201,38200,-1,38001,38002,38202,38201,-1,38002,38003,38203,38202,-1,38003,38004,38204,38203,-1,38004,38005,38205,38204,-1,38005,38006,38206,38205,-1,38006,38007,38207,38206,-1,38007,38008,38208,38207,-1,38008,38009,38209,38208,-1,38009,38010,38210,38209,-1,38010,38011,38211,38210,-1,38011,38012,38212,38211,-1,38012,38013,38213,38212,-1,38013,38014,38214,38213,-1,38014,38015,38215,38214,-1,38015,38016,38216,38215,-1,38016,38017,38217,38216,-1,38017,38018,38218,38217,-1,38018,38019,38219,38218,-1,38019,38020,38220,38219,-1,38020,38021,38221,38220,-1,38021,38022,38222,38221,-1,38022,38023,38223,38222,-1,38023,38024,38224,38223,-1,38024,38025,38225,38224,-1,38025,38026,38226,38225,-1,38026,38027,38227,38226,-1,38027,38028,38228,38227,-1,38028,38029,38229,38228,-1,38029,38030,38230,38229,-1,38030,38031,38231,38230,-1,38031,38032,38232,38231,-1,38032,38033,38233,38232,-1,38033,38034,38234,38233,-1,38034,38035,38235,38234,-1,38035,38036,38236,38235,-1,38036,38037,38237,38236,-1,38037,38038,38238,38237,-1,38038,38039,38239,38238,-1,38039,38040,38240,38239,-1,38040,38041,38241,38240,-1,38041,38042,38242,38241,-1,38042,38043,38243,38242,-1,38043,38044,38244,38243,-1,38044,38045,38245,38244,-1,38045,38046,38246,38245,-1,38046,38047,38247,38246,-1,38047,38048,38248,38247,-1,38048,38049,38249,38248,-1,38049,38050,38250,38249,-1,38050,38051,38251,38250,-1,38051,38052,38252,38251,-1,38052,38053,38253,38252,-1,38053,38054,38254,38253,-1,38054,38055,38255,38254,-1,38055,38056,38256,38255,-1,38056,38057,38257,38256,-1,38057,38058,38258,38257,-1,38058,38059,38259,38258,-1,38059,38060,38260,38259,-1,38060,38061,38261,38260,-1,38061,38062,38262,38261,-1,38062,38063,38263,38262,-1,38063,38064,38264,38263,-1,38064,38065,38265,38264,-1,38065,38066,38266,38265,-1,38066,38067,38267,38266,-1,38067,38068,38268,38267,-1,38068,38069,38269,38268,-1,38069,38070,38270,38269,-1,38070,38071,38271,38270,-1,38071,38072,38272,38271,-1,38072,38073,38273,38272,-1,38073,38074,38274,38273,-1,38074,38075,38275,38274,-1,38075,38076,38276,38275,-1,38076,38077,38277,38276,-1,38077,38078,38278,38277,-1,38078,38079,38279,38278,-1,38079,38080,38280,38279,-1,38080,38081,38281,38280,-1,38081,38082,38282,38281,-1,38082,38083,38283,38282,-1,38083,38084,38284,38283,-1,38084,38085,38285,38284,-1,38085,38086,38286,38285,-1,38086,38087,38287,38286,-1,38087,38088,38288,38287,-1,38088,38089,38289,38288,-1,38089,38090,38290,38289,-1,38090,38091,38291,38290,-1,38091,38092,38292,38291,-1,38092,38093,38293,38292,-1,38093,38094,38294,38293,-1,38094,38095,38295,38294,-1,38095,38096,38296,38295,-1,38096,38097,38297,38296,-1,38097,38098,38298,38297,-1,38098,38099,38299,38298,-1,38099,38100,38300,38299,-1,38100,38101,38301,38300,-1,38101,38102,38302,38301,-1,38102,38103,38303,38302,-1,38103,38104,38304,38303,-1,38104,38105,38305,38304,-1,38105,38106,38306,38305,-1,38106,38107,38307,38306,-1,38107,38108,38308,38307,-1,38108,38109,38309,38308,-1,38109,38110,38310,38309,-1,38110,38111,38311,38310,-1,38111,38112,38312,38311,-1,38112,38113,38313,38312,-1,38113,38114,38314,38313,-1,38114,38115,38315,38314,-1,38115,38116,38316,38315,-1,38116,38117,38317,38316,-1,38117,38118,38318,38317,-1,38118,38119,38319,38318,-1,38119,38120,38320,38319,-1,38120,38121,38321,38320,-1,38121,38122,38322,38321,-1,38122,38123,38323,38322,-1,38123,38124,38324,38323,-1,38124,38125,38325,38324,-1,38125,38126,38326,38325,-1,38126,38127,38327,38326,-1,38127,38128,38328,38327,-1,38128,38129,38329,38328,-1,38129,38130,38330,38329,-1,38130,38131,38331,38330,-1,38131,38132,38332,38331,-1,38132,38133,38333,38332,-1,38133,38134,38334,38333,-1,38134,38135,38335,38334,-1,38135,38136,38336,38335,-1,38136,38137,38337,38336,-1,38137,38138,38338,38337,-1,38138,38139,38339,38338,-1,38139,38140,38340,38339,-1,38140,38141,38341,38340,-1,38141,38142,38342,38341,-1,38142,38143,38343,38342,-1,38143,38144,38344,38343,-1,38144,38145,38345,38344,-1,38145,38146,38346,38345,-1,38146,38147,38347,38346,-1,38147,38148,38348,38347,-1,38148,38149,38349,38348,-1,38149,38150,38350,38349,-1,38150,38151,38351,38350,-1,38151,38152,38352,38351,-1,38152,38153,38353,38352,-1,38153,38154,38354,38353,-1,38154,38155,38355,38354,-1,38155,38156,38356,38355,-1,38156,38157,38357,38356,-1,38157,38158,38358,38357,-1,38158,38159,38359,38358,-1,38159,38160,38360,38359,-1,38160,38161,38361,38360,-1,38161,38162,38362,38361,-1,38162,38163,38363,38362,-1,38163,38164,38364,38363,-1,38164,38165,38365,38364,-1,38165,38166,38366,38365,-1,38166,38167,38367,38366,-1,38167,38168,38368,38367,-1,38168,38169,38369,38368,-1,38169,38170,38370,38369,-1,38170,38171,38371,38370,-1,38171,38172,38372,38371,-1,38172,38173,38373,38372,-1,38173,38174,38374,38373,-1,38174,38175,38375,38374,-1,38175,38176,38376,38375,-1,38176,38177,38377,38376,-1,38177,38178,38378,38377,-1,38178,38179,38379,38378,-1,38179,38180,38380,38379,-1,38180,38181,38381,38380,-1,38181,38182,38382,38381,-1,38182,38183,38383,38382,-1,38183,38184,38384,38383,-1,38184,38185,38385,38384,-1,38185,38186,38386,38385,-1,38186,38187,38387,38386,-1,38187,38188,38388,38387,-1,38188,38189,38389,38388,-1,38189,38190,38390,38389,-1,38190,38191,38391,38390,-1,38191,38192,38392,38391,-1,38192,38193,38393,38392,-1,38193,38194,38394,38393,-1,38194,38195,38395,38394,-1,38195,38196,38396,38395,-1,38196,38197,38397,38396,-1,38197,38198,38398,38397,-1,38198,38199,38399,38398,-1,38200,38201,38401,38400,-1,38201,38202,38402,38401,-1,38202,38203,38403,38402,-1,38203,38204,38404,38403,-1,38204,38205,38405,38404,-1,38205,38206,38406,38405,-1,38206,38207,38407,38406,-1,38207,38208,38408,38407,-1,38208,38209,38409,38408,-1,38209,38210,38410,38409,-1,38210,38211,38411,38410,-1,38211,38212,38412,38411,-1,38212,38213,38413,38412,-1,38213,38214,38414,38413,-1,38214,38215,38415,38414,-1,38215,38216,38416,38415,-1,38216,38217,38417,38416,-1,38217,38218,38418,38417,-1,38218,38219,38419,38418,-1,38219,38220,38420,38419,-1,38220,38221,38421,38420,-1,38221,38222,38422,38421,-1,38222,38223,38423,38422,-1,38223,38224,38424,38423,-1,38224,38225,38425,38424,-1,38225,38226,38426,38425,-1,38226,38227,38427,38426,-1,38227,38228,38428,38427,-1,38228,38229,38429,38428,-1,38229,38230,38430,38429,-1,38230,38231,38431,38430,-1,38231,38232,38432,38431,-1,38232,38233,38433,38432,-1,38233,38234,38434,38433,-1,38234,38235,38435,38434,-1,38235,38236,38436,38435,-1,38236,38237,38437,38436,-1,38237,38238,38438,38437,-1,38238,38239,38439,38438,-1,38239,38240,38440,38439,-1,38240,38241,38441,38440,-1,38241,38242,38442,38441,-1,38242,38243,38443,38442,-1,38243,38244,38444,38443,-1,38244,38245,38445,38444,-1,38245,38246,38446,38445,-1,38246,38247,38447,38446,-1,38247,38248,38448,38447,-1,38248,38249,38449,38448,-1,38249,38250,38450,38449,-1,38250,38251,38451,38450,-1,38251,38252,38452,38451,-1,38252,38253,38453,38452,-1,38253,38254,38454,38453,-1,38254,38255,38455,38454,-1,38255,38256,38456,38455,-1,38256,38257,38457,38456,-1,38257,38258,38458,38457,-1,38258,38259,38459,38458,-1,38259,38260,38460,38459,-1,38260,38261,38461,38460,-1,38261,38262,38462,38461,-1,38262,38263,38463,38462,-1,38263,38264,38464,38463,-1,38264,38265,38465,38464,-1,38265,38266,38466,38465,-1,38266,38267,38467,38466,-1,38267,38268,38468,38467,-1,38268,38269,38469,38468,-1,38269,38270,38470,38469,-1,38270,38271,38471,38470,-1,38271,38272,38472,38471,-1,38272,38273,38473,38472,-1,38273,38274,38474,38473,-1,38274,38275,38475,38474,-1,38275,38276,38476,38475,-1,38276,38277,38477,38476,-1,38277,38278,38478,38477,-1,38278,38279,38479,38478,-1,38279,38280,38480,38479,-1,38280,38281,38481,38480,-1,38281,38282,38482,38481,-1,38282,38283,38483,38482,-1,38283,38284,38484,38483,-1,38284,38285,38485,38484,-1,38285,38286,38486,38485,-1,38286,38287,38487,38486,-1,38287,38288,38488,38487,-1,38288,38289,38489,38488,-1,38289,38290,38490,38489,-1,38290,38291,38491,38490,-1,38291,38292,38492,38491,-1,38292,38293,38493,38492,-1,38293,38294,38494,38493,-1,38294,38295,38495,38494,-1,38295,38296,38496,38495,-1,38296,38297,38497,38496,-1,38297,38298,38498,38497,-1,38298,38299,38499,38498,-1,38299,38300,38500,38499,-1,38300,38301,38501,38500,-1,38301,38302,38502,38501,-1,38302,38303,38503,38502,-1,38303,38304,38504,38503,-1,38304,38305,38505,38504,-1,38305,38306,38506,38505,-1,38306,38307,38507,38506,-1,38307,38308,38508,38507,-1,38308,38309,38509,38508,-1,38309,38310,38510,38509,-1,38310,38311,38511,38510,-1,38311,38312,38512,38511,-1,38312,38313,38513,38512,-1,38313,38314,38514,38513,-1,38314,38315,38515,38514,-1,38315,38316,38516,38515,-1,38316,38317,38517,38516,-1,38317,38318,38518,38517,-1,38318,38319,38519,38518,-1,38319,38320,38520,38519,-1,38320,38321,38521,38520,-1,38321,38322,38522,38521,-1,38322,38323,38523,38522,-1,38323,38324,38524,38523,-1,38324,38325,38525,38524,-1,38325,38326,38526,38525,-1,38326,38327,38527,38526,-1,38327,38328,38528,38527,-1,38328,38329,38529,38528,-1,38329,38330,38530,38529,-1,38330,38331,38531,38530,-1,38331,38332,38532,38531,-1,38332,38333,38533,38532,-1,38333,38334,38534,38533,-1,38334,38335,38535,38534,-1,38335,38336,38536,38535,-1,38336,38337,38537,38536,-1,38337,38338,38538,38537,-1,38338,38339,38539,38538,-1,38339,38340,38540,38539,-1,38340,38341,38541,38540,-1,38341,38342,38542,38541,-1,38342,38343,38543,38542,-1,38343,38344,38544,38543,-1,38344,38345,38545,38544,-1,38345,38346,38546,38545,-1,38346,38347,38547,38546,-1,38347,38348,38548,38547,-1,38348,38349,38549,38548,-1,38349,38350,38550,38549,-1,38350,38351,38551,38550,-1,38351,38352,38552,38551,-1,38352,38353,38553,38552,-1,38353,38354,38554,38553,-1,38354,38355,38555,38554,-1,38355,38356,38556,38555,-1,38356,38357,38557,38556,-1,38357,38358,38558,38557,-1,38358,38359,38559,38558,-1,38359,38360,38560,38559,-1,38360,38361,38561,38560,-1,38361,38362,38562,38561,-1,38362,38363,38563,38562,-1,38363,38364,38564,38563,-1,38364,38365,38565,38564,-1,38365,38366,38566,38565,-1,38366,38367,38567,38566,-1,38367,38368,38568,38567,-1,38368,38369,38569,38568,-1,38369,38370,38570,38569,-1,38370,38371,38571,38570,-1,38371,38372,38572,38571,-1,38372,38373,38573,38572,-1,38373,38374,38574,38573,-1,38374,38375,38575,38574,-1,38375,38376,38576,38575,-1,38376,38377,38577,38576,-1,38377,38378,38578,38577,-1,38378,38379,38579,38578,-1,38379,38380,38580,38579,-1,38380,38381,38581,38580,-1,38381,38382,38582,38581,-1,38382,38383,38583,38582,-1,38383,38384,38584,38583,-1,38384,38385,38585,38584,-1,38385,38386,38586,38585,-1,38386,38387,38587,38586,-1,38387,38388,38588,38587,-1,38388,38389,38589,38588,-1,38389,38390,38590,38589,-1,38390,38391,38591,38590,-1,38391,38392,38592,38591,-1,38392,38393,38593,38592,-1,38393,38394,38594,38593,-1,38394,38395,38595,38594,-1,38395,38396,38596,38595,-1,38396,38397,38597,38596,-1,38397,38398,38598,38597,-1,38398,38399,38599,38598,-1,38400,38401,38601,38600,-1,38401,38402,38602,38601,-1,38402,38403,38603,38602,-1,38403,38404,38604,38603,-1,38404,38405,38605,38604,-1,38405,38406,38606,38605,-1,38406,38407,38607,38606,-1,38407,38408,38608,38607,-1,38408,38409,38609,38608,-1,38409,38410,38610,38609,-1,38410,38411,38611,38610,-1,38411,38412,38612,38611,-1,38412,38413,38613,38612,-1,38413,38414,38614,38613,-1,38414,38415,38615,38614,-1,38415,38416,38616,38615,-1,38416,38417,38617,38616,-1,38417,38418,38618,38617,-1,38418,38419,38619,38618,-1,38419,38420,38620,38619,-1,38420,38421,38621,38620,-1,38421,38422,38622,38621,-1,38422,38423,38623,38622,-1,38423,38424,38624,38623,-1,38424,38425,38625,38624,-1,38425,38426,38626,38625,-1,38426,38427,38627,38626,-1,38427,38428,38628,38627,-1,38428,38429,38629,38628,-1,38429,38430,38630,38629,-1,38430,38431,38631,38630,-1,38431,38432,38632,38631,-1,38432,38433,38633,38632,-1,38433,38434,38634,38633,-1,38434,38435,38635,38634,-1,38435,38436,38636,38635,-1,38436,38437,38637,38636,-1,38437,38438,38638,38637,-1,38438,38439,38639,38638,-1,38439,38440,38640,38639,-1,38440,38441,38641,38640,-1,38441,38442,38642,38641,-1,38442,38443,38643,38642,-1,38443,38444,38644,38643,-1,38444,38445,38645,38644,-1,38445,38446,38646,38645,-1,38446,38447,38647,38646,-1,38447,38448,38648,38647,-1,38448,38449,38649,38648,-1,38449,38450,38650,38649,-1,38450,38451,38651,38650,-1,38451,38452,38652,38651,-1,38452,38453,38653,38652,-1,38453,38454,38654,38653,-1,38454,38455,38655,38654,-1,38455,38456,38656,38655,-1,38456,38457,38657,38656,-1,38457,38458,38658,38657,-1,38458,38459,38659,38658,-1,38459,38460,38660,38659,-1,38460,38461,38661,38660,-1,38461,38462,38662,38661,-1,38462,38463,38663,38662,-1,38463,38464,38664,38663,-1,38464,38465,38665,38664,-1,38465,38466,38666,38665,-1,38466,38467,38667,38666,-1,38467,38468,38668,38667,-1,38468,38469,38669,38668,-1,38469,38470,38670,38669,-1,38470,38471,38671,38670,-1,38471,38472,38672,38671,-1,38472,38473,38673,38672,-1,38473,38474,38674,38673,-1,38474,38475,38675,38674,-1,38475,38476,38676,38675,-1,38476,38477,38677,38676,-1,38477,38478,38678,38677,-1,38478,38479,38679,38678,-1,38479,38480,38680,38679,-1,38480,38481,38681,38680,-1,38481,38482,38682,38681,-1,38482,38483,38683,38682,-1,38483,38484,38684,38683,-1,38484,38485,38685,38684,-1,38485,38486,38686,38685,-1,38486,38487,38687,38686,-1,38487,38488,38688,38687,-1,38488,38489,38689,38688,-1,38489,38490,38690,38689,-1,38490,38491,38691,38690,-1,38491,38492,38692,38691,-1,38492,38493,38693,38692,-1,38493,38494,38694,38693,-1,38494,38495,38695,38694,-1,38495,38496,38696,38695,-1,38496,38497,38697,38696,-1,38497,38498,38698,38697,-1,38498,38499,38699,38698,-1,38499,38500,38700,38699,-1,38500,38501,38701,38700,-1,38501,38502,38702,38701,-1,38502,38503,38703,38702,-1,38503,38504,38704,38703,-1,38504,38505,38705,38704,-1,38505,38506,38706,38705,-1,38506,38507,38707,38706,-1,38507,38508,38708,38707,-1,38508,38509,38709,38708,-1,38509,38510,38710,38709,-1,38510,38511,38711,38710,-1,38511,38512,38712,38711,-1,38512,38513,38713,38712,-1,38513,38514,38714,38713,-1,38514,38515,38715,38714,-1,38515,38516,38716,38715,-1,38516,38517,38717,38716,-1,38517,38518,38718,38717,-1,38518,38519,38719,38718,-1,38519,38520,38720,38719,-1,38520,38521,38721,38720,-1,38521,38522,38722,38721,-1,38522,38523,38723,38722,-1,38523,38524,38724,38723,-1,38524,38525,38725,38724,-1,38525,38526,38726,38725,-1,38526,38527,38727,38726,-1,38527,38528,38728,38727,-1,38528,38529,38729,38728,-1,38529,38530,38730,38729,-1,38530,38531,38731,38730,-1,38531,38532,38732,38731,-1,38532,38533,38733,38732,-1,38533,38534,38734,38733,-1,38534,38535,38735,38734,-1,38535,38536,38736,38735,-1,38536,38537,38737,38736,-1,38537,38538,38738,38737,-1,38538,38539,38739,38738,-1,38539,38540,38740,38739,-1,38540,38541,38741,38740,-1,38541,38542,38742,38741,-1,38542,38543,38743,38742,-1,38543,38544,38744,38743,-1,38544,38545,38745,38744,-1,38545,38546,38746,38745,-1,38546,38547,38747,38746,-1,38547,38548,38748,38747,-1,38548,38549,38749,38748,-1,38549,38550,38750,38749,-1,38550,38551,38751,38750,-1,38551,38552,38752,38751,-1,38552,38553,38753,38752,-1,38553,38554,38754,38753,-1,38554,38555,38755,38754,-1,38555,38556,38756,38755,-1,38556,38557,38757,38756,-1,38557,38558,38758,38757,-1,38558,38559,38759,38758,-1,38559,38560,38760,38759,-1,38560,38561,38761,38760,-1,38561,38562,38762,38761,-1,38562,38563,38763,38762,-1,38563,38564,38764,38763,-1,38564,38565,38765,38764,-1,38565,38566,38766,38765,-1,38566,38567,38767,38766,-1,38567,38568,38768,38767,-1,38568,38569,38769,38768,-1,38569,38570,38770,38769,-1,38570,38571,38771,38770,-1,38571,38572,38772,38771,-1,38572,38573,38773,38772,-1,38573,38574,38774,38773,-1,38574,38575,38775,38774,-1,38575,38576,38776,38775,-1,38576,38577,38777,38776,-1,38577,38578,38778,38777,-1,38578,38579,38779,38778,-1,38579,38580,38780,38779,-1,38580,38581,38781,38780,-1,38581,38582,38782,38781,-1,38582,38583,38783,38782,-1,38583,38584,38784,38783,-1,38584,38585,38785,38784,-1,38585,38586,38786,38785,-1,38586,38587,38787,38786,-1,38587,38588,38788,38787,-1,38588,38589,38789,38788,-1,38589,38590,38790,38789,-1,38590,38591,38791,38790,-1,38591,38592,38792,38791,-1,38592,38593,38793,38792,-1,38593,38594,38794,38793,-1,38594,38595,38795,38794,-1,38595,38596,38796,38795,-1,38596,38597,38797,38796,-1,38597,38598,38798,38797,-1,38598,38599,38799,38798,-1,38600,38601,38801,38800,-1,38601,38602,38802,38801,-1,38602,38603,38803,38802,-1,38603,38604,38804,38803,-1,38604,38605,38805,38804,-1,38605,38606,38806,38805,-1,38606,38607,38807,38806,-1,38607,38608,38808,38807,-1,38608,38609,38809,38808,-1,38609,38610,38810,38809,-1,38610,38611,38811,38810,-1,38611,38612,38812,38811,-1,38612,38613,38813,38812,-1,38613,38614,38814,38813,-1,38614,38615,38815,38814,-1,38615,38616,38816,38815,-1,38616,38617,38817,38816,-1,38617,38618,38818,38817,-1,38618,38619,38819,38818,-1,38619,38620,38820,38819,-1,38620,38621,38821,38820,-1,38621,38622,38822,38821,-1,38622,38623,38823,38822,-1,38623,38624,38824,38823,-1,38624,38625,38825,38824,-1,38625,38626,38826,38825,-1,38626,38627,38827,38826,-1,38627,38628,38828,38827,-1,38628,38629,38829,38828,-1,38629,38630,38830,38829,-1,38630,38631,38831,38830,-1,38631,38632,38832,38831,-1,38632,38633,38833,38832,-1,38633,38634,38834,38833,-1,38634,38635,38835,38834,-1,38635,38636,38836,38835,-1,38636,38637,38837,38836,-1,38637,38638,38838,38837,-1,38638,38639,38839,38838,-1,38639,38640,38840,38839,-1,38640,38641,38841,38840,-1,38641,38642,38842,38841,-1,38642,38643,38843,38842,-1,38643,38644,38844,38843,-1,38644,38645,38845,38844,-1,38645,38646,38846,38845,-1,38646,38647,38847,38846,-1,38647,38648,38848,38847,-1,38648,38649,3884