/**
 *<p>
 *	Security is an essential part of Web activity - this directory documents how to apply
 *      World Wide Web Consortium (W3C) security standards for XML Encryption (privacy) and XML Digital Signature (authentication)
 *      to X3D scenes.
 *</p>
 *<p>
 *	The
 *	<a href="../../../Security/X3dSecurityReadMe.html" target="_blank">X3D Security Examples</a>
 *	show how to use the 
 *	<a href="http://www.w3.org/Security" target="_blank">World Wide Web Consortium (W3C) Security Recommendations</a>
 *	for
 *	<a href="http://www.w3.org/TR/xmldsig-core" target="_blank">XML Signature</a>
 *	and 
 *	<a href="http://www.w3.org/TR/xmlenc-core" target="_blank">XML Encryption</a>
 *	with X3D.
 *</p>
 *<p>
 *        <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html#Security" target="_blank">X3D Resources: Security</a>
 *        provides an additional set of security issues and resources.
 *
 *	<a href="https://www.web3d.org/x3d/content/examples/X3dForAdvancedModeling/Security">Additional security examples</a>
 *	are being prepared as part of the
 *	<a href="https://x3dGraphics.com/slidesets/X3dForAdvancedModeling" target="X3dChapterSlideset">X3D for Advanced Modeling</a>
 *	project.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/Security" target="_blank">X3D Basic: Security</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.Security;

