/**
 *<p>
 *	Script Conformance examples test the ability of Script nodes to receive, process and produce events that
 *      respond to user commands and trigger animation behaviors in the X3D scene graph.
 *</p>
 *<p>
 *	The Script Conformance examples
 *	provide examples for the
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/components/scripting.html" target="_blank">X3D Scripting Component</a>,
 *	as implemented using the
 *	<a href="https://www.web3d.org/files/specifications/19777-1/V3.0/Part1/X3D_ECMAScript.html" target="_blank">X3D language binding for ECMAScript</a>.
 *	and the
 *	<a href="https://www.web3d.org/files/specifications/19777-2/V3.0/Part2/X3D_Java.html" target="_blank">X3D language binding for Java</a>.
 *</p>
 *
 *<p>
 *	Original examples are derived from
 *	"<a href="VrmlJavaPaper.pdf" target="_blank">The Virtual Reality Modeling Language and Java</a>," Communications of the ACM, vol. 41 no. 6, June 1998, pp. 57-64 by Don Brutzman.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/ScriptConformance" target="_blank">X3D Basic: Script Conformance</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.ScriptConformance;

