####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python CreateNodesECMAScript.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.1',
  head=head(
    children=[
    meta(content='CreateNodesECMAScript.x3d',name='title'),
    meta(content='This example shows how to use createX3DFromString to create nodes',name='description'),
    meta(content='X3D Specification',name='creator'),
    meta(content='23 February 2005',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D ECMAScript Script Authoring Interface (SAI)',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/ScriptConformance/CreateNodesECMAScript.x3d',name='identifier'),
    meta(content='https://www.web3d.org/x3d/specifications/ISO-IEC-19777-1-X3DLanguageBindings-ECMAScript/Part1/examples.html#CreateNodes',name='reference'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='CreateNodesECMAScript.x3d'),
    Transform(DEF='HOLDER',translation=(-2.0,0.0,0.0)),
    Script(DEF='SC',
      field=[
      field(accessType='outputOnly',name='children',type='MFNode',
        #  initialization nodes (if any) go here 
        )],

    sourceCode="""
ecmascript:

function initialize() 
{
    // Create nodes directly in the parent scene
    shape = Browser.currentScene.createNode('Shape');
    box = Browser.currentScene.createNode('Box');
    shape.geometry = box;
    Browser.currentScene.RootNodes[0] = shape;

    // Create children using the createX3DFromString service
    vrmlCmd = 'PROFILE Interchange  Shape { geometry Sphere{} }'
    tmpScene = Browser.createX3DFromString(vrmlCmd);
    nodes = tmpScene.rootNodes;

    // Nodes must be removed before adding to another scene
    for(i=0; i < nodes.length; i++) {
        tmpScene.removeRootNode(nodes[i]);
    }

    children = nodes;
}
"""),
    ROUTE(fromField='children',fromNode='SC',toField='children',toNode='HOLDER')])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for CreateNodesECMAScript.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python CreateNodesECMAScript.py load and self-test diagnostics complete.")
