/**
 *<p>
 *	Rigid Body Physics modeling deals with objects as solid, unchangeable sets of mass having a velocity
 *      that can be connected together via various joint types that allow one body's motion to affect another.
 *</p>
 *<p>
 *	These examples support the
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/components/rigid_physics.html" target="_blank">X3D Rigid Body Physics component</a>
 *	for simple kinematics, first implemented by
 *	<a href="http://www.xj3d.org/extensions/rigid_physics_examples.html" target="_blank">Xj3D</a>.
 *</p>
 *
 *<p>
 *	<i>Warning:</i>
 *	the Rigid Body Physics component in not widely supported and these examples are insufficiently tested.
 *	Further work is welcome.
 *</p>
 *
 *<p>
 *	Of related interest:
 *	<a href="../../../DistributedInteractiveSimulation/index.html" target="_blank">Distributed Interactive Simulation (DIS)</a>
 *	examples.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/RigidBodyPhysics" target="_blank">X3D Basic: Rigid Body Physics</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.RigidBodyPhysics;

