####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SingleHingeJoint.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.2',
  head=head(
    children=[
    component(level=2,name='RigidBodyPhysics'),
    meta(content='SingleHingeJoint.x3d',name='title'),
    meta(content='Example scene for RigidBodyPhysics component',name='description'),
    meta(content='Alan Hudson and Justin Couch',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='1 January 2008',name='created'),
    meta(content='26 December 2008',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='http://www.xj3d.org/extensions/index.html#Physics',name='reference'),
    meta(content='originals/single_hinge_joint.x3dv',name='reference'),
    meta(content='https://www.web3d.org/x3d/specifications/ISO-IEC-FDIS-19775-1.2-X3D-AbstractSpecification/Part01/components/rigid_physics.html',name='reference'),
    meta(content='under development',name='warning'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/RigidBodyPhysics/SingleHingeJoint.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='Xj3D converter, http://www.xj3d.org',name='generator'),
    meta(content='../../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SingleHingeJoint.x3d'),
    Viewpoint(position=(0.0,0.0,4.0)),
    Group(
      children=[
      CollidableShape(DEF='BOX-GEOM-1',
        shape=Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(1.0,0.0,0.0))),
          geometry=Box(size=(0.3,0.02,0.02)))),
      CollidableShape(DEF='BOX-GEOM-2',
        shape=Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(0.0,0.0,1.0))),
          geometry=Box(size=(0.3,0.02,0.02)))),
      CollidableShape(DEF='BOX-GEOM-3',
        shape=Shape(
          appearance=Appearance(
            material=Material(emissiveColor=(0.0,1.0,0.0))),
          geometry=Box(size=(0.3,0.02,0.02))))]),
    RigidBodyCollection(
      bodies=[
      RigidBody(DEF='BODY-1',mass=10000.0,position=(-0.3,0.0,0.0),useGlobalGravity=False,
        geometry=[
        CollidableShape(USE='BOX-GEOM-1')]),
      RigidBody(DEF='BODY-2',angularDampingFactor=0,
        geometry=[
        CollidableShape(USE='BOX-GEOM-2')]),
      RigidBody(DEF='BODY-3',angularDampingFactor=0,mass=0.1,position=(0.3,0.0,0.0),
        geometry=[
        CollidableShape(USE='BOX-GEOM-3')])],
      joints=[
      SingleAxisHingeJoint(anchorPoint=(-0.15,0.0,0.0),
        body1=RigidBody(USE='BODY-1'),
        body2=RigidBody(USE='BODY-2')),
      SingleAxisHingeJoint(anchorPoint=(0.15,0.0,0.0),
        body1=RigidBody(USE='BODY-2'),
        body2=RigidBody(USE='BODY-3'))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SingleHingeJoint.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SingleHingeJoint.py load and self-test diagnostics complete.")
