package Basic.RigidBodyPhysics;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.KeyDeviceSensor.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.RigidBodyPhysics.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Example scene for RigidBodyPhysics component, runnable as Xj3D application and invoked using shell script runogl. </p>
 <p> Related links: Catalog page <a href="../../../RigidBodyPhysics/CarDemoMainIndex.html" target="_blank">CarDemoMain</a>,  source <a href="../../../RigidBodyPhysics/CarDemoMain.java">CarDemoMain.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../RigidBodyPhysics/CarDemoMain.x3d">CarDemoMain.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Example scene for RigidBodyPhysics component, runnable as Xj3D application and invoked using shell script runogl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Alan Hudson and Justin Couch </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 January 2008 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 30 December 2008 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.xj3d.org/extensions/index.html#Physics" target="_blank">http://www.xj3d.org/extensions/index.html#Physics</a> </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Test scene includes custom Xj3D components and elements, will not validate </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Test scene under development, runogl fails <a href="http://bugzilla.xj3d.org/show_bug.cgi?id=556" target="_blank">http://bugzilla.xj3d.org/show_bug.cgi?id=556</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> originals/car/runogl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../RigidBodyPhysics/originals/car/main.x3dv">originals/car/main.x3dv</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../RigidBodyPhysics/originals/car/worldModel.x3dv">originals/car/worldModel.x3dv</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../RigidBodyPhysics/originals/car/CameraControl.java">originals/car/CameraControl.java</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../RigidBodyPhysics/originals/car/CarControlScript.java">originals/car/CarControlScript.java</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.xj3d.org/extensions/rigid_physics_examples.html" target="_blank">http://www.xj3d.org/extensions/rigid_physics_examples.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/specifications/ISO-IEC-FDIS-19775-1.2-X3D-AbstractSpecification/Part01/components/rigid_physics.html" target="_blank">https://www.web3d.org/x3d/specifications/ISO-IEC-FDIS-19775-1.2-X3D-AbstractSpecification/Part01/components/rigid_physics.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/RigidBodyPhysics/CarDemoMain.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/RigidBodyPhysics/CarDemoMain.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Xj3D converter, <a href="http://www.xj3d.org" target="_blank">http://www.xj3d.org</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../RigidBodyPhysics/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Alan Hudson and Justin Couch
 */

public class CarDemoMain
{
	/** Default constructor to create this object. */
	public CarDemoMain ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_2)
  .setHead(new head()
    .addComponent(new component().setName("xj3d_RigidBodyPhysics").setLevel(2))
    .addComponent(new component().setName("xj3d_IODevice").setLevel(2))
    .addComments(" TODO: upgrade component <component level='2' name='RigidBodyPhysics'/> ")
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("CarDemoMain.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Example scene for RigidBodyPhysics component, runnable as Xj3D application and invoked using shell script runogl"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Alan Hudson and Justin Couch"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 January 2008"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("30 December 2008"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.xj3d.org/extensions/index.html#Physics"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("Test scene includes custom Xj3D components and elements, will not validate"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("Test scene under development, runogl fails http://bugzilla.xj3d.org/show_bug.cgi?id=556"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/car/runogl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/car/main.x3dv"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/car/worldModel.x3dv"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/car/CameraControl.java"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("originals/car/CarControlScript.java"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.xj3d.org/extensions/rigid_physics_examples.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/specifications/ISO-IEC-FDIS-19775-1.2-X3D-AbstractSpecification/Part01/components/rigid_physics.html"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/RigidBodyPhysics/CarDemoMain.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Xj3D converter, http://www.xj3d.org"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("CarDemoMain.x3d"))
    .addChild(new Group()
      .addChild(new Group("CAR-CONTAINER")
        .addChild(new Switch("DEBUG-GEOM").setWhichChoice(0)
          .addChild(new Group()
            .addChild(new Transform("ACTIVE-SECTOR-INDICATOR")
              .addChild(new Shape()
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setEmissiveColor(1.0,1.0,0.0).setTransparency(0.5)))))
            .addChild(new Transform("FRONT-LEFT-WHEEL-TX-DEBUG-HINGE").setTranslation(-1.1,0.5,-1.5)
              .addChild(new Shape("FRONT-LEFT-DEBUG-POINTER")
                .setAppearance(new Appearance("DEBUG-POINTER-APP")
                  .setMaterial(new Material())
                  .setLineProperties(new LineProperties().setLinetype(2)))
                .setGeometry(new LineSet().setVertexCount(new int[] {2})
                  .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,1.0,0.0,0.0})))
                  .setColor(new Color().setColor(new MFColor(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))))))
            .addChild(new Transform("FRONT-RIGHT-WHEEL-TX-DEBUG-HINGE").setTranslation(-1.1,0.5,-1.5)
              .addChild(new Shape("FRONT-RIGHT-DEBUG-POINTER")
                .setAppearance(new Appearance().setUSE("DEBUG-POINTER-APP"))
                .setGeometry(new LineSet().setVertexCount(new int[] {2})
                  .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,-1.0,0.0,0.0})))
                  .setColor(new Color().setColor(new MFColor(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))))))
            .addChild(new Transform("FRONT-LEFT-WHEEL-TX-DEBUG-MIN").setTranslation(-1.1,0.5,-1.5)
              .addChild(new Shape("FRONT-LEFT-TX-DEBUG-POINTER")
                .setAppearance(new Appearance().setUSE("DEBUG-POINTER-APP"))
                .setGeometry(new LineSet().setVertexCount(new int[] {2})
                  .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,1.0,0.0,0.0})))
                  .setColor(new Color().setColor(new MFColor(new double[] {1.0,1.0,0.0,1.0,1.0,0.0}))))))
            .addChild(new Transform("FRONT-RIGHT-WHEEL-TX-DEBUG-MIN").setTranslation(-1.1,0.5,-1.5)
              .addChild(new Shape("FRONT-RIGHT-TX-DEBUG-POINTER")
                .setAppearance(new Appearance().setUSE("DEBUG-POINTER-APP"))
                .setGeometry(new LineSet().setVertexCount(new int[] {2})
                  .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,-1.0,0.0,0.0})))
                  .setColor(new Color().setColor(new MFColor(new double[] {0.0,0.0,1.0,0.0,0.0,1.0}))))))
            .addChild(new Transform("FRONT-LEFT-WHEEL-TX-DEBUG-MAX").setTranslation(-1.1,0.5,-1.5)
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("DEBUG-POINTER-APP"))
                .setGeometry(new LineSet().setVertexCount(new int[] {2})
                  .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,1.0,0.0,0.0})))
                  .setColor(new Color().setColor(new MFColor(new double[] {0.0,0.0,1.0,0.0,0.0,1.0}))))))
            .addChild(new Transform("FRONT-RIGHT-WHEEL-TX-DEBUG-MAX").setTranslation(-1.1,0.5,-1.5)
              .addChild(new Shape()
                .setAppearance(new Appearance().setUSE("DEBUG-POINTER-APP"))
                .setGeometry(new LineSet().setVertexCount(new int[] {2})
                  .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,-1.0,0.0,0.0})))
                  .setColor(new Color().setColor(new MFColor(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))))))))
        .addChild(new Transform("FRONT-LEFT-WHEEL-TX").setTranslation(-1.1,0.5,-1.5)
          .addChild(new Transform("WHEEL-SHAPE").setRotation(0.0,0.0,1.0,1.572)
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setEmissiveColor(1.0,0.0,1.0)))
              .setGeometry(new Cylinder().setHeight(0.1).setRadius(0.5))))
          .addChild(new Group("JOINT-INDICATOR-LEFT")
            .addChild(new Shape()
              .setGeometry(new LineSet().setVertexCount(new int[] {2,2})
                .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0})))
                .setColor(new Color().setColor(new MFColor(new double[] {1.0,1.0,0.0,1.0,1.0,0.0,1.0,1.0,1.0,1.0,1.0,1.0})))))
            .addChild(new Shape("JOINT-SPHERE")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setEmissiveColor(0.0,1.0,1.0)))
              .setGeometry(new Sphere().setRadius(0.1)))))
        .addChild(new Transform("FRONT-RIGHT-WHEEL-TX").setTranslation(1.1,0.5,-1.5)
          .addChild(new Transform().setUSE("WHEEL-SHAPE"))
          .addChild(new Group("JOINT-INDICATOR-RIGHT")
            .addChild(new Shape()
              .setGeometry(new LineSet().setVertexCount(new int[] {2,2})
                .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0})))
                .setColor(new Color().setColor(new MFColor(new double[] {1.0,1.0,0.0,1.0,1.0,0.0,1.0,1.0,1.0,1.0,1.0,1.0})))))
            .addChild(new Shape().setUSE("JOINT-SPHERE"))))
        .addChild(new Transform("BACK-LEFT-WHEEL-TX").setTranslation(-1.1,0.5,1.5)
          .addChild(new Transform().setUSE("WHEEL-SHAPE"))
          .addChild(new Group().setUSE("JOINT-INDICATOR-LEFT")))
        .addChild(new Transform("BACK-RIGHT-WHEEL-TX").setTranslation(1.1,0.5,1.5)
          .addChild(new Transform().setUSE("WHEEL-SHAPE"))
          .addChild(new Group().setUSE("JOINT-INDICATOR-RIGHT")))
        .addChild(new Transform("CAR-BODY-TX")
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setEmissiveColor(0.8,0.8,0.0)))
            .setGeometry(new Box("CHASSIS-BOX").setSize(2.2,0.05,5.0)))
          .addChild(new Transform("SPEED-INDICATOR").setTranslation(1.2,1.0,0.0)
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material("SPEED-INDICATOR-COLOR")))
              .setGeometry(new Box().setSize(0.1,1.0,0.1))))
          .addChild(new Transform().setTranslation(0.0,0.4,0.0)
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setMaterial(new Material().setEmissiveColor(0.0,0.0,0.8).setTransparency(0.5)))
              .setGeometry(new Box("CHASSIS-PROXY-GEOM").setSize(2.25,0.4,5.1)))
            .addChild(new Transform().setTranslation(1.0,0.1,2.65)
              .addChild(new Shape("BRAKE-LIGHT-GEOM")
                .setAppearance(new Appearance()
                  .setMaterial(new Material("BRAKE-LIGHT-COLOR").setDiffuseColor(0.1,0.0,0.0).setEmissiveColor(0.1,0.0,0.0)))
                .setGeometry(new Box().setSize(0.1,0.2,0.1))))
            .addChild(new Transform().setTranslation(-1.0,0.1,2.65)
              .addChild(new Shape().setUSE("BRAKE-LIGHT-GEOM")))
            .addChild(new Transform().setTranslation(0.9,0.1,2.65)
              .addChild(new Shape("REVERSE-LIGHT-GEOM")
                .setAppearance(new Appearance()
                  .setMaterial(new Material("REVERSE-LIGHT-COLOR").setDiffuseColor(0.1,0.1,0.1).setEmissiveColor(0.1,0.1,0.1)))
                .setGeometry(new Box().setSize(0.1,0.1,0.1))))
            .addChild(new Transform().setTranslation(-0.9,0.1,2.65)
              .addChild(new Shape().setUSE("REVERSE-LIGHT-GEOM")))))
        .addChild(new Transform("CAMERA-TX")
          .addChild(new Transform()
            .addChild(new Viewpoint("Camera03").setDescription("AutoCam").setPosition(0.0,0.0,0.0))))))
    .addChild(new NavigationInfo().setSpeed(10.0).setType("\"NONE\""))
    .addChild(new Inline())
    .addChild(new Shape("ENEMY-GEOM"))
    .addChild(new Transform("carGroup").setRotation(0.006813,-0.9999,0.01227,-4.155).setTranslation(-82.59,6.8,-48.1)
      .addChild(new Transform("carCamTransform").setTranslation(0.0,1.0,5.0)
        .addChild(new Viewpoint("Camera03-OLD").setDescription("Car 3rd Person").setPosition(0.0,0.0,5.0))))
    .addChild(new TimeSensor("cam_car_chase-TIMER").setCycleInterval(120.0).setEnabled(false).setLoop(true))
    .addChild(new PositionInterpolator("cam_car_chase-POS-INTERP").setKey(getcam_car_chase_POS_INTERP_3_140_key()).setKeyValue(getcam_car_chase_POS_INTERP_3_140_keyValue()))
    .addChild(new OrientationInterpolator("cam_car_chase-ROT-INTERP").setKey(getcam_car_chase_ROT_INTERP_3_141_key()).setKeyValue(getcam_car_chase_ROT_INTERP_3_141_keyValue()))
    .addChild(new KeySensor("keysensor"))
    .addChild(new Switch("DEBUG_TERRAIN").setWhichChoice(0)
      .addChild(new Group("TERRAIN-CONTAINER")
        .addChild(new CollidableShape("Road-v-001").setTranslation(124.936,-0.5,-461.607)
          .setShape(new Shape()
            .setAppearance(new Appearance("ROAD-APP")
              .setMaterial(new Material().setEmissiveColor(1.0,0.0,0.0)))
            .setGeometry(new Box().setSize(1250.0,1.0,800.0))))
        .addChild(new CollidableShape("Road-v-002").setTranslation(-417.631,-0.5,24.7947)
          .setShape(new Shape()
            .setAppearance(new Appearance().setUSE("ROAD-APP"))
            .setGeometry(new Box().setSize(200.0,1.0,250.0))))
        .addChild(new CollidableShape("Road-v-003").setTranslation(675.143,-0.5,17.6217)
          .setShape(new Shape()
            .setAppearance(new Appearance().setUSE("ROAD-APP"))
            .setGeometry(new Box().setSize(200.0,1.0,250.0))))
        .addChild(new CollidableShape("Road-v-004").setTranslation(138.008,-0.5,23.1087)
          .setShape(new Shape()
            .setAppearance(new Appearance().setUSE("ROAD-APP"))
            .setGeometry(new Box().setSize(1000.0,1.0,60.0))))
        .addChild(new CollidableShape("Road-v-006").setRotation(0.0,0.0,-1.0,0.135494).setTranslation(347.056,4.87479,-376.17)
          .setShape(new Shape()
            .setAppearance(new Appearance("RAMP_APP")
              .setMaterial(new Material().setDiffuseColor(0.0,0.0,1.0))
              .setTexture(new ImageTexture().setUrl(new String[] {"originals/car/textures/wall-stone-001.jpg","https://www.web3d.org/x3d/content/examples/Basic/RigidBodyPhysics/originals/car/textures/wall-stone-001.jpg"})))
            .setGeometry(new Box().setSize(90.0,1.0,70.0))))
        .addChild(new CollidableShape("Road-v-007").setTranslation(301.193,1.4,-376.315)
          .setShape(new Shape()
            .setAppearance(new Appearance().setUSE("ROAD-APP"))
            .setGeometry(new Box().setSize(3.0,20.0,70.0))))
        .addChild(new CollidableShape("Sand-v-001").setTranslation(101.232,-0.55,-31.8107)
          .setShape(new Shape()
            .setAppearance(new Appearance("SAND-APP")
              .setMaterial(new Material().setAmbientIntensity(0.258621).setDiffuseColor(0.58,0.27,0.01).setShininess(0.07).setSpecularColor(0.43,0.2,0.0))
              .setTexture(new ImageTexture()))
            .setGeometry(new Box().setSize(1000.0,1.0,60.0))))
        .addChild(new CollidableShape("Sand-v-002").setTranslation(108.906,-0.55,93.8712)
          .setShape(new Shape()
            .setAppearance(new Appearance().setUSE("SAND-APP"))
            .setGeometry(new Box().setSize(1000.0,1.0,100.0))))
        .addChild(new CollidableShape("WALL-v-001a").setTranslation(750.0,10.0,-360.0)
          .setShape(new Shape()
            .setAppearance(new Appearance("WALL-APP")
              .setMaterial(new Material().setEmissiveColor(0.5,0.5,0.5).setTransparency(0.2)))
            .setGeometry(new Box().setSize(1.0,20.0,1000.0))))
        .addChild(new CollidableShape("WALL-v-001b").setTranslation(-500.0,10.0,-360.0)
          .setShape(new Shape()
            .setAppearance(new Appearance().setUSE("WALL-APP"))
            .setGeometry(new Box().setSize(1.0,20.0,1000.0))))
        .addChild(new CollidableShape("WALL-v-001c").setTranslation(125.0,10.0,140.99)
          .setShape(new Shape()
            .setAppearance(new Appearance().setUSE("WALL-APP"))
            .setGeometry(new Box().setSize(1250.0,20.0,1.0))))
        .addChild(new CollidableShape("WALL-v-001d").setTranslation(125.0,10.0,-859.733)
          .setShape(new Shape()
            .setAppearance(new Appearance().setUSE("WALL-APP"))
            .setGeometry(new Box().setSize(1250.0,20.0,1.0))))
        .addChild(new CollidableShape("Wall-v-002").setTranslation(-163.362,24.0,-589.528)
          .setShape(new Shape()
            .setAppearance(new Appearance().setUSE("WALL-APP"))
            .setGeometry(new Box().setSize(40.0,48.0,40.0))))
        .addChild(new CollidableShape("Wall-v-003").setTranslation(-100.093,19.0,-587.841)
          .setShape(new Shape("SmallBulding")
            .setAppearance(new Appearance().setUSE("WALL-APP"))
            .setGeometry(new Box().setSize(40.0,38.0,40.0))))
        .addChild(new CollidableShape("Wall-v-004").setTranslation(-314.972,19.0,-656.376)
          .setShape(new Shape().setUSE("SmallBulding")))
        .addChild(new CollidableShape("Wall-v-005").setTranslation(-314.723,19.0,-580.647)
          .setShape(new Shape().setUSE("SmallBulding")))
        .addChild(new CollidableShape("Wall-v-006").setTranslation(-269.737,19.0,-452.626)
          .setShape(new Shape().setUSE("SmallBulding")))
        .addChild(new CollidableShape("Wall-v-007").setTranslation(-217.782,19.0,-450.082)
          .setShape(new Shape().setUSE("SmallBulding")))
        .addChild(new CollidableShape("Wall-v-008").setTranslation(-83.8395,19.0,-351.859)
          .setShape(new Shape().setUSE("SmallBulding")))
        .addChild(new CollidableShape("Wall-v-009").setTranslation(-348.799,19.0,-511.969)
          .setShape(new Shape().setUSE("SmallBulding")))
        .addChild(new CollidableShape("Wall-v-010").setTranslation(-23.9812,19.0,-501.768)
          .setShape(new Shape().setUSE("SmallBulding")))
        .addChild(new CollidableShape("Wall-v-011").setTranslation(-101.759,19.0,-451.126)
          .setShape(new Shape().setUSE("SmallBulding")))))
    .addChild(new Script("physicsSectorScript").setSourceCode("""
ecmascript:
    function sector1(val) {
       if (val) {
Browser.println('Physics Sector1');
        sector1Enabled = true;
        sector2Enabled = true;
        sector3Enabled = false;
        sector4Enabled = false;
        sector5Enabled = false;
        sector6Enabled = false;
        sector7Enabled = false;
        sector8Enabled = false;
        sector9Enabled = false;
       }
    }
    function sector2(val) {
       if (val) {
Browser.println('Physics Sector2');
        sector1Enabled = true;
        sector2Enabled = true;
        sector3Enabled = true;
        sector4Enabled = false;
        sector5Enabled = false;
        sector6Enabled = false;
        sector7Enabled = false;
        sector8Enabled = false;
        sector9Enabled = false;
       }
    }
    function sector3(val) {
       if (val) {
Browser.println('Physics Sector3');
        sector1Enabled = false;
        sector2Enabled = true;
        sector3Enabled = true;
        sector4Enabled = true;
        sector5Enabled = false;
        sector6Enabled = false;
        sector7Enabled = false;
        sector8Enabled = false;
        sector9Enabled = false;
       }
    }
    function sector4(val) {
       if (val) {
Browser.println('Physics Sector4');
        sector1Enabled = false;
        sector2Enabled = false;
        sector3Enabled = true;
        sector4Enabled = true;
        sector5Enabled = true;
        sector6Enabled = false;
        sector7Enabled = false;
        sector8Enabled = false;
        sector9Enabled = false;
       }
    }
    function sector5(val) {
       if (val) {
Browser.println('Physics Sector5');
        sector1Enabled = false;
        sector2Enabled = false;
        sector3Enabled = false;
        sector4Enabled = true;
        sector5Enabled = true;
        sector6Enabled = true;
        sector7Enabled = false;
        sector8Enabled = false;
        sector9Enabled = false;
       }
    }
    function sector6(val) {
       if (val) {
Browser.println('Physics Sector6');
        sector1Enabled = false;
        sector2Enabled = false;
        sector3Enabled = false;
        sector4Enabled = false;
        sector5Enabled = true;
        sector6Enabled = true;
        sector7Enabled = true;
        sector8Enabled = false;
        sector9Enabled = false;
       }
    }
    function sector7(val) {
       if (val) {
Browser.println('Physics Sector7');
        sector1Enabled = false;
        sector2Enabled = false;
        sector3Enabled = false;
        sector4Enabled = false;
        sector5Enabled = false;
        sector6Enabled = true;
        sector7Enabled = true;
        sector8Enabled = true;
        sector9Enabled = false;
       }
    }
    function sector8(val) {
       if (val) {
Browser.println('Physics Sector8');

        sector1Enabled = false;
        sector2Enabled = false;
        sector3Enabled = false;
        sector4Enabled = false;
        sector5Enabled = false;
        sector6Enabled = false;
        sector7Enabled = true;
        sector8Enabled = true;
        sector9Enabled = true;
       }
    }
    function sector9(val) {
       if (val) {
Browser.println('Physics Sector9');

        sector1Enabled = true;
        sector2Enabled = false;
        sector3Enabled = false;
        sector4Enabled = false;
        sector5Enabled = false;
        sector6Enabled = false;
        sector7Enabled = false;
        sector8Enabled = true;
        sector9Enabled = true;
       }
    }

    function sector9(val) {
       if (val) {
Browser.println('Physics Sector9');

        sector1Enabled = true;
        sector2Enabled = false;
        sector3Enabled = false;
        sector4Enabled = false;
        sector5Enabled = false;
        sector6Enabled = false;
        sector7Enabled = false;
        sector8Enabled = true;
        sector9Enabled = true;
       }
    }
""")
      .addField(new field().setName("sector1").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("sector2").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("sector3").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("sector4").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("sector5").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("sector6").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("sector7").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("sector8").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("sector9").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("sector1Enabled").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("sector2Enabled").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("sector3Enabled").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("sector4Enabled").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("sector5Enabled").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("sector6Enabled").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("sector7Enabled").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("sector8Enabled").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("sector9Enabled").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY)))
    .addChild(new RigidBodyCollection("BODY-COLLECTION").setConstantForceMix(0.0050).setContactSurfaceThickness(0.0010).setEnabled(false).setIterations(20)
      .addBodies(new RigidBody("CAR-BODY").setAutoDamp(true).setEnabled(false).setMass(900.0).setPosition(0.0,1.25,0.0)
        .setMassDensityModel(new Box().setUSE("CHASSIS-BOX"))
        .addGeometry(new CollidableShape("CAR-BODY-GEOM")
          .setShape(new Shape()
            .setGeometry(new Box().setUSE("CHASSIS-BOX")))))
      .addBodies(new RigidBody("FRONT-LEFT-WHEEL-BODY").setAngularDampingFactor(0).setAutoDamp(true).setEnabled(false).setMass(20.0).setPosition(-0.9,1.5,-2.5).setUseFiniteRotation(true)
        .setMassDensityModel(new Sphere().setUSE("WHEEL-MASS"))
        .addGeometry(new CollidableShape("FRONT-LEFT-WHEEL-GEOM")
          .setShape(new Shape("WHEEL-GEOM")
            .setGeometry(new Sphere("WHEEL-MASS").setRadius(0.5)))))
      .addBodies(new RigidBody("FRONT-RIGHT-WHEEL-BODY").setAngularDampingFactor(0).setAutoDamp(true).setEnabled(false).setMass(20.0).setPosition(0.9,1.5,-2.5).setUseFiniteRotation(true)
        .setMassDensityModel(new Sphere().setUSE("WHEEL-MASS"))
        .addGeometry(new CollidableShape("FRONT-RIGHT-WHEEL-GEOM")
          .setShape(new Shape().setUSE("WHEEL-GEOM"))))
      .addBodies(new RigidBody("BACK-LEFT-WHEEL-BODY").setAngularDampingFactor(0).setAutoDamp(true).setEnabled(false).setMass(20.0).setPosition(-0.9,1.5,2.5).setUseFiniteRotation(true)
        .setMassDensityModel(new Sphere().setUSE("WHEEL-MASS"))
        .addGeometry(new CollidableShape("BACK-LEFT-WHEEL-GEOM")
          .setShape(new Shape().setUSE("WHEEL-GEOM"))))
      .addBodies(new RigidBody("BACK-RIGHT-WHEEL-BODY").setAngularDampingFactor(0).setAutoDamp(true).setEnabled(false).setMass(20.0).setPosition(0.9,1.5,2.5).setUseFiniteRotation(true)
        .setMassDensityModel(new Sphere().setUSE("WHEEL-MASS"))
        .addGeometry(new CollidableShape("BACK-RIGHT-WHEEL-GEOM")
          .setShape(new Shape().setUSE("WHEEL-GEOM")))))
    .addChild(new CollisionSensor("COLLISION-OUTPUT")
      .setCollider(new CollisionCollection("COLLISION-GROUP").setBounce(0.3).setEnabled(false).setFrictionCoefficients(500.0,500.0).setMinBounceSpeed(0.3).setSoftnessConstantForceMix(0.0010)
        .addCollidables(new CollidableShape().setUSE("FRONT-LEFT-WHEEL-GEOM"))
        .addCollidables(new CollidableShape().setUSE("FRONT-RIGHT-WHEEL-GEOM"))
        .addCollidables(new CollidableShape().setUSE("BACK-LEFT-WHEEL-GEOM"))
        .addCollidables(new CollidableShape().setUSE("BACK-RIGHT-WHEEL-GEOM"))
        .addCollidables(new CollidableShape().setUSE("CAR-BODY-GEOM"))
        .addCollidables(new CollidableShape().setUSE("Road-v-001"))
        .addCollidables(new CollidableShape().setUSE("Road-v-002"))
        .addCollidables(new CollidableShape().setUSE("Road-v-003"))
        .addCollidables(new CollidableShape().setUSE("Road-v-004"))
        .addCollidables(new CollidableShape().setUSE("Road-v-006"))
        .addCollidables(new CollidableShape().setUSE("Road-v-007"))
        .addCollidables(new CollidableShape().setUSE("Sand-v-001"))
        .addCollidables(new CollidableShape().setUSE("Sand-v-002"))
        .addCollidables(new CollidableShape().setUSE("WALL-v-001a"))
        .addCollidables(new CollidableShape().setUSE("WALL-v-001b"))
        .addCollidables(new CollidableShape().setUSE("WALL-v-001c"))
        .addCollidables(new CollidableShape().setUSE("WALL-v-001d"))
        .addCollidables(new CollidableShape().setUSE("Wall-v-002"))
        .addCollidables(new CollidableShape().setUSE("Wall-v-003"))
        .addCollidables(new CollidableShape().setUSE("Wall-v-004"))
        .addCollidables(new CollidableShape().setUSE("Wall-v-005"))
        .addCollidables(new CollidableShape().setUSE("Wall-v-006"))
        .addCollidables(new CollidableShape().setUSE("Wall-v-007"))
        .addCollidables(new CollidableShape().setUSE("Wall-v-008"))
        .addCollidables(new CollidableShape().setUSE("Wall-v-009"))
        .addCollidables(new CollidableShape().setUSE("Wall-v-010"))
        .addCollidables(new CollidableShape().setUSE("Wall-v-011"))))
    .addChild(new Script("CAR-CONTROL-SCRIPT").setDirectOutput(true).setUrl(new String[] {"originals/car/CarControlScript.class","https://www.web3d.org/x3d/content/examples/Basic/RigidBodyPhysics/originals/car/CarControlScript.class"})
      .addField(new field().setName("resetRequest").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("startingPosition").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("startingOrientation").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("wheelBodyRadius").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("chassisBodyDimensions").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("speedLimit").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("steeringLimitAngle").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("steeringDeadspot").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("maxEngineTorque").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("maxBrakingTorque").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("maxEngineRevs").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("roadFrictionCoefficient").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("wallFrictionCoefficient").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("sandFrictionCoefficient").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("grassFrictionCoefficient").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("otherFrictionCoefficient").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("sideSlipCoefficient").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("brakeBias").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("engineFrontPercentage").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("engineRearPercentage").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("dragCoefficient").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("downforceCoefficient").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTOUTPUT))
      .addField(new field().setName("reverseSelected").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("carVelocity").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("carOrientation").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("currentSteeringAngle").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("wheelAcceleratorInput").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("wheelDirectionInput").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("frontWheelOrientation").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("rearWheelOrientation").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("correctedChassisOrientation").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontWheelMinStop").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontWheelMaxStop").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontLeftWheelSpeed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontRightWheelSpeed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("rearLeftWheelSpeed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("rearRightWheelSpeed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontWheelTorque").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("rearWheelTorque").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontLeftAxleAxis").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontRightAxleAxis").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("rearLeftAxleAxis").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("rearRightAxleAxis").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frictionForces").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("chassisPosition_reset").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("chassisOrientation_reset").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontLeftWheelPosition_reset").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontLeftWheelOrientation_reset").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontRightWheelPosition_reset").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("frontRightWheelOrientation_reset").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("backLeftWheelPosition_reset").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("backLeftWheelOrientation_reset").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("backRightWheelPosition_reset").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("backRightWheelOrientation_reset").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("enablePhysics").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("speed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("revs").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("brakesApplied").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("reversing").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("chassis").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new CollidableShape().setUSE("CAR-BODY-GEOM")))
      .addField(new field().setName("frontLeftWheel").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new CollidableShape().setUSE("FRONT-LEFT-WHEEL-GEOM")))
      .addField(new field().setName("frontRightWheel").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new CollidableShape().setUSE("FRONT-RIGHT-WHEEL-GEOM")))
      .addField(new field().setName("backLeftWheel").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new CollidableShape().setUSE("BACK-LEFT-WHEEL-GEOM")))
      .addField(new field().setName("backRightWheel").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new CollidableShape().setUSE("BACK-RIGHT-WHEEL-GEOM")))
      .addField(new field().setName("bigTerrainBox").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("roadTerrain").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new CollidableShape().setUSE("Road-v-001"))
        .addChild(new CollidableShape().setUSE("Road-v-002"))
        .addChild(new CollidableShape().setUSE("Road-v-003"))
        .addChild(new CollidableShape().setUSE("Road-v-004"))
        .addChild(new CollidableShape().setUSE("Road-v-006"))
        .addChild(new CollidableShape().setUSE("Road-v-007")))
      .addField(new field().setName("sandTerrain").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new CollidableShape().setUSE("Sand-v-001"))
        .addChild(new CollidableShape().setUSE("Sand-v-002")))
      .addField(new field().setName("grassTerrain").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("wallTerrain").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new CollidableShape().setUSE("WALL-v-001a"))
        .addChild(new CollidableShape().setUSE("WALL-v-001b"))
        .addChild(new CollidableShape().setUSE("WALL-v-001c"))
        .addChild(new CollidableShape().setUSE("WALL-v-001d"))
        .addChild(new CollidableShape().setUSE("Wall-v-002"))
        .addChild(new CollidableShape().setUSE("Wall-v-003"))
        .addChild(new CollidableShape().setUSE("Wall-v-004"))
        .addChild(new CollidableShape().setUSE("Wall-v-005"))
        .addChild(new CollidableShape().setUSE("Wall-v-006"))
        .addChild(new CollidableShape().setUSE("Wall-v-007"))
        .addChild(new CollidableShape().setUSE("Wall-v-008"))
        .addChild(new CollidableShape().setUSE("Wall-v-009"))
        .addChild(new CollidableShape().setUSE("Wall-v-010"))
        .addChild(new CollidableShape().setUSE("Wall-v-011")))
      .addField(new field().setName("bodies").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new RigidBody().setUSE("CAR-BODY"))
        .addChild(new RigidBody().setUSE("FRONT-LEFT-WHEEL-BODY"))
        .addChild(new RigidBody().setUSE("FRONT-RIGHT-WHEEL-BODY"))
        .addChild(new RigidBody().setUSE("BACK-LEFT-WHEEL-BODY"))
        .addChild(new RigidBody().setUSE("BACK-RIGHT-WHEEL-BODY")))
      .addField(new field().setName("joints").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
        .addChild(new DoubleAxisHingeJoint("FRONT-LEFT-JOINT").setAnchorPoint(-0.9,1.5,-2.5).setAxis1(0.0,1.0,0.0).setAxis2(-1.0,0.0,0.0).setForceOutput(new String[] {"body2Axis","hinge1Angle"}).setMaxAngle1(0.0).setMaxTorque2(100.0).setMinAngle1(0.0).setStop1ErrorCorrection(0.98).setSuspensionErrorCorrection(0.9).setSuspensionForce(0.0030)
          .setBody1(new RigidBody().setUSE("CAR-BODY"))
          .setBody2(new RigidBody().setUSE("FRONT-LEFT-WHEEL-BODY")))
        .addChild(new DoubleAxisHingeJoint("FRONT-RIGHT-JOINT").setAnchorPoint(0.9,1.5,-2.5).setAxis1(0.0,1.0,0.0).setAxis2(1.0,0.0,0.0).setForceOutput(new String[] {"body2Axis","hinge1Angle"}).setMaxAngle1(0.0).setMaxTorque2(100.0).setMinAngle1(0.0).setStop1ErrorCorrection(0.98).setSuspensionErrorCorrection(0.9).setSuspensionForce(0.0030)
          .setBody1(new RigidBody().setUSE("CAR-BODY"))
          .setBody2(new RigidBody().setUSE("FRONT-RIGHT-WHEEL-BODY")))
        .addChild(new DoubleAxisHingeJoint("BACK-LEFT-JOINT").setAnchorPoint(-0.9,1.5,2.5).setAxis1(0.0,1.0,0.0).setAxis2(-1.0,0.0,0.0).setForceOutput(new String[] {"body2Axis"}).setMaxAngle1(0.0).setMaxTorque2(100.0).setMinAngle1(0.0).setStop1ErrorCorrection(0.98).setSuspensionErrorCorrection(0.9).setSuspensionForce(0.0030)
          .setBody1(new RigidBody().setUSE("CAR-BODY"))
          .setBody2(new RigidBody().setUSE("BACK-LEFT-WHEEL-BODY")))
        .addChild(new DoubleAxisHingeJoint("BACK-RIGHT-JOINT").setAnchorPoint(0.9,1.5,2.5).setAxis1(0.0,1.0,0.0).setAxis2(1.0,0.0,0.0).setForceOutput(new String[] {"body2Axis"}).setMaxAngle1(0.0).setMaxTorque2(100.0).setMinAngle1(0.0).setStop1ErrorCorrection(0.98).setSuspensionErrorCorrection(0.9).setSuspensionForce(0.0030)
          .setBody1(new RigidBody().setUSE("CAR-BODY"))
          .setBody2(new RigidBody().setUSE("BACK-RIGHT-WHEEL-BODY"))))
      .addField(new field().setName("collisionContacts").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("correctedContacts").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("connectJoints").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY)))
    .addChild(new WheelSensor("WHEEL").setName("Wheel-0"))
    .addChild(new GamepadSensor("GAMEPAD").setName("Gamepad-0"))
    .addChild(new KeySensor("KEYS"))
    .addChild(new TimeSensor("KEYTIMER").setLoop(true))
    .addChild(new Script("KEYSC").setSourceCode("""
ecmascript:
    var accelVar = 0;
    var dirVar = 0;
    var accelFactor = 0.1;
    var dirFactor = 0.5;
    var decayVar = 0.1;
    var applyDecay = false;
    
    function decay(val) {
       if (!applyDecay)
          return;
          
       if (dir >= decayVar) {
          dir = dir - decayVar;          
          if (dir < -1)
             dir = -1;
       } else if (dir <= -decayVar) {
          dir = dir + decayVar;
          
          if (dir > 1)
             dir = 1;
       } else {
          dir = 0;
          
          applyDecay = false;
       }   
    }
    
    function actionKeyPress(val) {
        applyDecay = true;
        
    	if (val == 17) {
    	   accelVar = accelVar + accelFactor;
    	   
    	   if (accelVar > 1)
    	      accelVar = 1.0;
    	      
    	   accel = accelVar;
    	} else if (val == 18) {
    	   accelVar = accelVar - accelFactor;
    	   
    	   if (accelVar < -1)
    	      accelVar = -1.0;
    	      
    	   accel = accelVar;
    	} else if (val == 19) {
    	   dirVar = dirVar - dirFactor;
    	   
    	   if (dirVar < -1)
    	      dirVar = -1.0;
    	      
    	   dir = dirVar;
    	} else if (val == 20) {
    	   dirVar = dirVar + dirFactor;
    	   
    	   if (dirVar > 1)
    	      dirVar = 1.0;
    	      
    	   dir = dirVar;
    	} else {
    	   dir = 0;
    	   accel = 0;
    	}
    }
""")
      .addField(new field().setName("actionKeyPress").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("decay").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("dir").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("accel").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("reverse").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("reset").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY)))
    .addChild(new Script("UI-CONTROL-SCRIPT").setSourceCode("""
ecmascript:
    function brakesApplied(val) {
      if(val)
        brakeLightColor.r = 1;
      else
        brakeLightColor.r = 0.1;
    }

    function reversing(val) {
      if(val) {
        reverseLightColor.r = 1;
        reverseLightColor.g = 1;
        reverseLightColor.b = 1;
      } else {
        reverseLightColor.r = 0.1;
        reverseLightColor.g = 0.1;
        reverseLightColor.b = 0.1;
      }
    }

    function speed(val) {
      speedScale.x = 1;
      speedScale.y = val / maxSpeed;
      speedScale.z = 1;
      speedFraction = val / maxSpeed;
    }
""")
      .addField(new field().setName("speed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("revs").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("brakesApplied").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("reversing").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("maxSpeed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("brakeLightColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("reverseLightColor").setType(field.TYPE_SFCOLOR).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("speedScale").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("speedFraction").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY)))
    .addChild(new ColorInterpolator("SPEED-COLOR").setKey(new double[] {0.0,0.8,0.9,1.0}).setKeyValue(new MFColor(new double[] {0.0,0.0,0.0,1.0,1.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0})))
    .addChild(new OrientationInterpolator("FRONT-LEFT-HINGE-WHEEL-INTERP").setKey(new double[] {-1.0,0.0,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.5236,0.0,1.0,0.0,0.0,0.0,1.0,0.0,-0.5236})))
    .addChild(new OrientationInterpolator("FRONT-RIGHT-HINGE-WHEEL-INTERP").setKey(new double[] {-1.0,0.0,1.0}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.5236,0.0,1.0,0.0,0.0,0.0,1.0,0.0,-0.5236})))
    .addChild(new OrientationInterpolator("FRONT-LEFT-HINGE-ANGLE-INTERP").setKey(new double[] {-0.5236,0.0,0.5236}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.5236,0.0,1.0,0.0,0.0,0.0,1.0,0.0,-0.5236})))
    .addChild(new OrientationInterpolator("FRONT-RIGHT-HINGE-ANGLE-INTERP").setKey(new double[] {-0.5236,0.0,0.5236}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.5236,0.0,1.0,0.0,0.0,0.0,1.0,0.0,-0.5236})))
    .addChild(new OrientationInterpolator("FRONT-LEFT-MAXSTOP-ANGLE-INTERP").setKey(new double[] {-0.5236,0.0,0.5236}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.5236,0.0,1.0,0.0,0.0,0.0,1.0,0.0,-0.5236})))
    .addChild(new OrientationInterpolator("FRONT-RIGHT-MAXSTOP-ANGLE-INTERP").setKey(new double[] {-0.5236,0.0,0.5236}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.5236,0.0,1.0,0.0,0.0,0.0,1.0,0.0,-0.5236})))
    .addChild(new OrientationInterpolator("FRONT-LEFT-MINSTOP-ANGLE-INTERP").setKey(new double[] {-0.5236,0.0,0.5236}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.5236,0.0,1.0,0.0,0.0,0.0,1.0,0.0,-0.5236})))
    .addChild(new OrientationInterpolator("FRONT-RIGHT-MINSTOP-ANGLE-INTERP").setKey(new double[] {-0.5236,0.0,0.5236}).setKeyValue(new MFRotation(new double[] {0.0,1.0,0.0,0.5236,0.0,1.0,0.0,0.0,0.0,1.0,0.0,-0.5236})))
    .addChild(new Viewpoint().setDescription("Other position").setPosition(0.0,2.0,10.0))
    .addChild(new Viewpoint().setDescription("Top down view of starting position").setOrientation(1.0,0.0,0.0,-1.5712).setPosition(-114.86,20.0,-66.1922))
    .addChild(new Viewpoint("CHASSIS-VIEW").setDescription("Chassis starting position").setPosition(0.0,0.0,0.0))
    .addChild(new Background().setSkyAngle(new double[] {1.5712,3.142}).setSkyColor(new MFColor(new double[] {0.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0})))
    .addChild(new NavigationInfo().setType("\"NONE\""))
    .addChild(new Script("CAMERA-CONTROL-SCRIPT").setUrl(new String[] {"originals/car/CameraControl.class","https://www.web3d.org/x3d/content/examples/Basic/RigidBodyPhysics/originals/car/CameraControl.class"})
      .addField(new field().setName("carPosition").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("resetPosition").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("resetOrientation").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("cameraTranslation").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("cameraRotation").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("height").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
      .addField(new field().setName("chainLength").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)))
    .addChild(new ROUTE().setFromNode("cam_car_chase-TIMER").setFromField("fraction_changed").setToNode("cam_car_chase-POS-INTERP").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("cam_car_chase-POS-INTERP").setFromField("value_changed").setToNode("carGroup").setToField("translation"))
    .addChild(new ROUTE().setFromNode("cam_car_chase-TIMER").setFromField("fraction_changed").setToNode("cam_car_chase-ROT-INTERP").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("cam_car_chase-ROT-INTERP").setFromField("value_changed").setToNode("carGroup").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("cam_car_chase-POS-INTERP").setFromField("value_changed").setToNode("CAR-BODY-TX").setToField("translation"))
    .addChild(new ROUTE().setFromNode("cam_car_chase-ROT-INTERP").setFromField("value_changed").setToNode("CAR-BODY-TX").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-WHEEL-BODY").setFromField("position").setToNode("FRONT-LEFT-WHEEL-TX").setToField("translation"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-WHEEL-BODY").setFromField("orientation").setToNode("FRONT-LEFT-WHEEL-TX").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-WHEEL-BODY").setFromField("position").setToNode("FRONT-RIGHT-WHEEL-TX").setToField("translation"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-WHEEL-BODY").setFromField("orientation").setToNode("FRONT-RIGHT-WHEEL-TX").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("BACK-LEFT-WHEEL-BODY").setFromField("position").setToNode("BACK-LEFT-WHEEL-TX").setToField("translation"))
    .addChild(new ROUTE().setFromNode("BACK-LEFT-WHEEL-BODY").setFromField("orientation").setToNode("BACK-LEFT-WHEEL-TX").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("BACK-RIGHT-WHEEL-BODY").setFromField("position").setToNode("BACK-RIGHT-WHEEL-TX").setToField("translation"))
    .addChild(new ROUTE().setFromNode("BACK-RIGHT-WHEEL-BODY").setFromField("orientation").setToNode("BACK-RIGHT-WHEEL-TX").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("CAR-BODY").setFromField("position").setToNode("CAR-BODY-TX").setToField("translation"))
    .addChild(new ROUTE().setFromNode("CAR-BODY").setFromField("orientation").setToNode("CAR-BODY-TX").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("WHEEL").setFromField("wheelX").setToNode("CAR-CONTROL-SCRIPT").setToField("wheelDirectionInput"))
    .addChild(new ROUTE().setFromNode("WHEEL").setFromField("throttleSlider").setToNode("CAR-CONTROL-SCRIPT").setToField("wheelAcceleratorInput"))
    .addChild(new ROUTE().setFromNode("WHEEL").setFromField("button2").setToNode("CAR-CONTROL-SCRIPT").setToField("reverseSelected"))
    .addChild(new ROUTE().setFromNode("WHEEL").setFromField("button3").setToNode("CAR-CONTROL-SCRIPT").setToField("resetRequest"))
    .addChild(new ROUTE().setFromNode("GAMEPAD").setFromField("leftStickX").setToNode("CAR-CONTROL-SCRIPT").setToField("wheelDirectionInput"))
    .addChild(new ROUTE().setFromNode("GAMEPAD").setFromField("rightStickY").setToNode("CAR-CONTROL-SCRIPT").setToField("wheelAcceleratorInput"))
    .addChild(new ROUTE().setFromNode("GAMEPAD").setFromField("l1Button").setToNode("CAR-CONTROL-SCRIPT").setToField("reverseSelected"))
    .addChild(new ROUTE().setFromNode("GAMEPAD").setFromField("r1Button").setToNode("CAR-CONTROL-SCRIPT").setToField("resetRequest"))
    .addChild(new ROUTE().setFromNode("KEYS").setFromField("actionKeyPress").setToNode("KEYSC").setToField("actionKeyPress"))
    .addChild(new ROUTE().setFromNode("KEYTIMER").setFromField("fraction_changed").setToNode("KEYSC").setToField("decay"))
    .addChild(new ROUTE().setFromNode("KEYSC").setFromField("dir").setToNode("CAR-CONTROL-SCRIPT").setToField("wheelDirectionInput"))
    .addChild(new ROUTE().setFromNode("KEYSC").setFromField("accel").setToNode("CAR-CONTROL-SCRIPT").setToField("wheelAcceleratorInput"))
    .addChild(new ROUTE().setFromNode("KEYSC").setFromField("reverse").setToNode("CAR-CONTROL-SCRIPT").setToField("reverseSelected"))
    .addChild(new ROUTE().setFromNode("KEYSC").setFromField("reset").setToNode("CAR-CONTROL-SCRIPT").setToField("resetRequest"))
    .addChild(new ROUTE().setFromNode("COLLISION-OUTPUT").setFromField("contacts").setToNode("CAR-CONTROL-SCRIPT").setToField("collisionContacts"))
    .addChild(new ROUTE().setFromNode("CAR-BODY").setFromField("linearVelocity").setToNode("CAR-CONTROL-SCRIPT").setToField("carVelocity"))
    .addChild(new ROUTE().setFromNode("CAR-BODY").setFromField("orientation").setToNode("CAR-CONTROL-SCRIPT").setToField("carOrientation"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-JOINT").setFromField("body2Axis").setToNode("CAR-CONTROL-SCRIPT").setToField("frontWheelOrientation"))
    .addChild(new ROUTE().setFromNode("BACK-LEFT-JOINT").setFromField("body2Axis").setToNode("CAR-CONTROL-SCRIPT").setToField("rearWheelOrientation"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-JOINT").setFromField("hinge1Angle").setToNode("CAR-CONTROL-SCRIPT").setToField("currentSteeringAngle"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-JOINT").setFromField("body2Axis").setToNode("FRONT-LEFT-WHEEL-BODY").setToField("finiteRotationAxis"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-JOINT").setFromField("body2Axis").setToNode("FRONT-RIGHT-WHEEL-BODY").setToField("finiteRotationAxis"))
    .addChild(new ROUTE().setFromNode("BACK-LEFT-JOINT").setFromField("body2Axis").setToNode("BACK-LEFT-WHEEL-BODY").setToField("finiteRotationAxis"))
    .addChild(new ROUTE().setFromNode("BACK-RIGHT-JOINT").setFromField("body2Axis").setToNode("BACK-RIGHT-WHEEL-BODY").setToField("finiteRotationAxis"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("enablePhysics").setToNode("BODY-COLLECTION").setToField("enabled"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("enablePhysics").setToNode("COLLISION-GROUP").setToField("enabled"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("enablePhysics").setToNode("CAR-BODY").setToField("enabled"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("enablePhysics").setToNode("FRONT-LEFT-WHEEL-BODY").setToField("enabled"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("enablePhysics").setToNode("FRONT-RIGHT-WHEEL-BODY").setToField("enabled"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("enablePhysics").setToNode("BACK-LEFT-WHEEL-BODY").setToField("enabled"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("enablePhysics").setToNode("BACK-RIGHT-WHEEL-BODY").setToField("enabled"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("chassisPosition_reset").setToNode("CAR-BODY").setToField("position"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("chassisOrientation_reset").setToNode("CAR-BODY").setToField("orientation"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontLeftWheelPosition_reset").setToNode("FRONT-LEFT-WHEEL-BODY").setToField("position"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontLeftWheelPosition_reset").setToNode("FRONT-LEFT-JOINT").setToField("anchorPoint"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontLeftWheelOrientation_reset").setToNode("FRONT-LEFT-WHEEL-BODY").setToField("orientation"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontRightWheelPosition_reset").setToNode("FRONT-RIGHT-WHEEL-BODY").setToField("position"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontRightWheelPosition_reset").setToNode("FRONT-RIGHT-JOINT").setToField("anchorPoint"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontRightWheelOrientation_reset").setToNode("FRONT-RIGHT-WHEEL-BODY").setToField("orientation"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("backLeftWheelPosition_reset").setToNode("BACK-LEFT-WHEEL-BODY").setToField("position"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("backLeftWheelPosition_reset").setToNode("BACK-LEFT-JOINT").setToField("anchorPoint"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("backLeftWheelOrientation_reset").setToNode("BACK-LEFT-WHEEL-BODY").setToField("orientation"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("backRightWheelPosition_reset").setToNode("BACK-RIGHT-WHEEL-BODY").setToField("position"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("backRightWheelPosition_reset").setToNode("BACK-RIGHT-JOINT").setToField("anchorPoint"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("backRightWheelOrientation_reset").setToNode("BACK-RIGHT-WHEEL-BODY").setToField("orientation"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontWheelMinStop").setToNode("FRONT-LEFT-JOINT").setToField("minAngle1"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontWheelMinStop").setToNode("FRONT-RIGHT-JOINT").setToField("minAngle1"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontWheelMaxStop").setToNode("FRONT-LEFT-JOINT").setToField("maxAngle1"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontWheelMaxStop").setToNode("FRONT-RIGHT-JOINT").setToField("maxAngle1"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontLeftWheelSpeed").setToNode("FRONT-LEFT-JOINT").setToField("desiredAngularVelocity2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontRightWheelSpeed").setToNode("FRONT-RIGHT-JOINT").setToField("desiredAngularVelocity2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("rearLeftWheelSpeed").setToNode("BACK-LEFT-JOINT").setToField("desiredAngularVelocity2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("rearRightWheelSpeed").setToNode("BACK-RIGHT-JOINT").setToField("desiredAngularVelocity2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontWheelTorque").setToNode("FRONT-LEFT-JOINT").setToField("maxTorque2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontWheelTorque").setToNode("FRONT-RIGHT-JOINT").setToField("maxTorque2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("rearWheelTorque").setToNode("BACK-LEFT-JOINT").setToField("maxTorque2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("rearWheelTorque").setToNode("BACK-RIGHT-JOINT").setToField("maxTorque2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontLeftAxleAxis").setToNode("FRONT-LEFT-JOINT").setToField("axis2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frontRightAxleAxis").setToNode("FRONT-RIGHT-JOINT").setToField("axis2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("rearLeftAxleAxis").setToNode("BACK-LEFT-JOINT").setToField("axis2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("rearRightAxleAxis").setToNode("BACK-RIGHT-JOINT").setToField("axis2"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("frictionForces").setToNode("CAR-BODY").setToField("forces"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("correctedContacts").setToNode("BODY-COLLECTION").setToField("set_contacts"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("correctedChassisOrientation").setToNode("CAR-BODY").setToField("orientation"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("connectJoints").setToNode("BODY-COLLECTION").setToField("joints"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("speed").setToNode("UI-CONTROL-SCRIPT").setToField("speed"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("revs").setToNode("UI-CONTROL-SCRIPT").setToField("revs"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("brakesApplied").setToNode("UI-CONTROL-SCRIPT").setToField("brakesApplied"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("reversing").setToNode("UI-CONTROL-SCRIPT").setToField("reversing"))
    .addChild(new ROUTE().setFromNode("UI-CONTROL-SCRIPT").setFromField("brakeLightColor").setToNode("BRAKE-LIGHT-COLOR").setToField("emissiveColor"))
    .addChild(new ROUTE().setFromNode("UI-CONTROL-SCRIPT").setFromField("reverseLightColor").setToNode("REVERSE-LIGHT-COLOR").setToField("emissiveColor"))
    .addChild(new ROUTE().setFromNode("UI-CONTROL-SCRIPT").setFromField("speedScale").setToNode("SPEED-INDICATOR").setToField("scale"))
    .addChild(new ROUTE().setFromNode("UI-CONTROL-SCRIPT").setFromField("speedFraction").setToNode("SPEED-COLOR").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("SPEED-COLOR").setFromField("value_changed").setToNode("SPEED-INDICATOR-COLOR").setToField("emissiveColor"))
    .addChild(new ROUTE().setFromNode("WHEEL").setFromField("wheelX").setToNode("FRONT-LEFT-HINGE-WHEEL-INTERP").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-HINGE-WHEEL-INTERP").setFromField("value_changed").setToNode("FRONT-LEFT-WHEEL-TX-DEBUG-HINGE").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("WHEEL").setFromField("wheelX").setToNode("FRONT-RIGHT-HINGE-WHEEL-INTERP").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-HINGE-WHEEL-INTERP").setFromField("value_changed").setToNode("FRONT-RIGHT-WHEEL-TX-DEBUG-HINGE").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-JOINT").setFromField("hinge1Angle").setToNode("FRONT-LEFT-HINGE-ANGLE-INTERP").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-HINGE-ANGLE-INTERP").setFromField("value_changed").setToNode("FRONT-LEFT-WHEEL-TX-DEBUG-HINGE").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-JOINT").setFromField("hinge1Angle").setToNode("FRONT-RIGHT-HINGE-ANGLE-INTERP").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-HINGE-ANGLE-INTERP").setFromField("value_changed").setToNode("FRONT-RIGHT-WHEEL-TX-DEBUG-HINGE").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-JOINT").setFromField("maxAngle1").setToNode("FRONT-LEFT-MAXSTOP-ANGLE-INTERP").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-MAXSTOP-ANGLE-INTERP").setFromField("value_changed").setToNode("FRONT-LEFT-WHEEL-TX-DEBUG-MAX").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-JOINT").setFromField("maxAngle1").setToNode("FRONT-RIGHT-MAXSTOP-ANGLE-INTERP").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-MAXSTOP-ANGLE-INTERP").setFromField("value_changed").setToNode("FRONT-RIGHT-WHEEL-TX-DEBUG-MAX").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-JOINT").setFromField("minAngle1").setToNode("FRONT-LEFT-MINSTOP-ANGLE-INTERP").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-MINSTOP-ANGLE-INTERP").setFromField("value_changed").setToNode("FRONT-LEFT-WHEEL-TX-DEBUG-MIN").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-JOINT").setFromField("minAngle1").setToNode("FRONT-RIGHT-MINSTOP-ANGLE-INTERP").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-MINSTOP-ANGLE-INTERP").setFromField("value_changed").setToNode("FRONT-RIGHT-WHEEL-TX-DEBUG-MIN").setToField("rotation"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-WHEEL-BODY").setFromField("position").setToNode("FRONT-LEFT-WHEEL-TX-DEBUG-HINGE").setToField("translation"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-WHEEL-BODY").setFromField("position").setToNode("FRONT-RIGHT-WHEEL-TX-DEBUG-HINGE").setToField("translation"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-WHEEL-BODY").setFromField("position").setToNode("FRONT-LEFT-WHEEL-TX-DEBUG-MAX").setToField("translation"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-WHEEL-BODY").setFromField("position").setToNode("FRONT-RIGHT-WHEEL-TX-DEBUG-MAX").setToField("translation"))
    .addChild(new ROUTE().setFromNode("FRONT-LEFT-WHEEL-BODY").setFromField("position").setToNode("FRONT-LEFT-WHEEL-TX-DEBUG-MIN").setToField("translation"))
    .addChild(new ROUTE().setFromNode("FRONT-RIGHT-WHEEL-BODY").setFromField("position").setToNode("FRONT-RIGHT-WHEEL-TX-DEBUG-MIN").setToField("translation"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("chassisPosition_reset").setToNode("CHASSIS-VIEW").setToField("position"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("chassisOrientation_reset").setToNode("CHASSIS-VIEW").setToField("orientation"))
    .addChild(new ROUTE().setFromNode("CAR-BODY").setFromField("position").setToNode("CAMERA-CONTROL-SCRIPT").setToField("carPosition"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("chassisPosition_reset").setToNode("CAMERA-CONTROL-SCRIPT").setToField("resetPosition"))
    .addChild(new ROUTE().setFromNode("CAR-CONTROL-SCRIPT").setFromField("chassisOrientation_reset").setToNode("CAMERA-CONTROL-SCRIPT").setToField("resetOrientation"))
    .addChild(new ROUTE().setFromNode("CAMERA-CONTROL-SCRIPT").setFromField("cameraTranslation").setToNode("CAMERA-TX").setToField("translation"))
    .addChild(new ROUTE().setFromNode("CAMERA-CONTROL-SCRIPT").setFromField("cameraRotation").setToNode("CAMERA-TX").setToField("rotation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getcam_car_chase_POS_INTERP_3_140_key_1()
		{
			double[] value = {0.0,0.0050,0.01,0.015,0.02,0.025,0.03,0.035,0.04,0.045,0.05,0.055,0.06,0.065,0.07,0.075,0.08,0.085,0.09,0.095,0.1,0.105,0.11,0.115,0.12,0.125,0.13,0.135,0.14,0.145,0.15,0.155,0.16,0.165,0.17,0.175,0.18,0.185,0.19,0.195,0.2,0.205,0.21,0.215,0.22,0.225,0.23,0.235,0.24,0.245,0.25,0.255,0.26,0.265,0.27,0.275,0.28,0.285,0.29,0.295,0.3,0.305,0.31,0.315,0.32,0.325,0.33,0.335,0.34,0.345,0.35,0.355,0.36,0.365,0.37,0.375,0.38,0.385,0.39,0.395,0.4,0.405,0.41,0.415,0.42,0.425,0.43,0.435,0.44,0.445,0.45,0.455,0.46,0.465,0.47,0.475,0.48,0.485,0.49,0.495,0.5,0.505,0.51,0.515,0.52,0.525,0.53,0.535,0.54,0.545,0.55,0.555,0.56,0.565,0.57,0.575,0.58,0.585,0.59,0.595,0.6,0.605,0.61,0.615,0.62,0.625,0.63,0.635,0.64,0.645,0.65,0.655,0.66,0.665,0.67,0.675,0.68,0.685,0.69,0.695,0.7,0.705,0.71,0.715,0.72,0.725,0.73,0.735,0.74,0.745,0.75,0.755,0.76,0.765,0.77,0.775,0.78,0.785,0.79,0.795,0.8,0.805,0.81,0.815,0.82,0.825,0.83,0.835,0.84,0.845,0.85,0.855,0.86,0.865,0.87,0.875,0.88,0.885,0.89,0.895,0.9,0.905,0.91,0.915,0.92,0.925,0.93,0.935,0.94,0.945,0.95,0.955,0.96,0.965,0.97,0.975,0.98,0.985,0.99,0.995,1.0};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getcam_car_chase_POS_INTERP_3_140_keyValue_1()
		{
			double[] value = {-82.59,6.8,-46.1,-62.37,7.482,-34.12,-45.75,8.077,-24.49,-30.63,8.902,-15.22,-14.28,9.772,-7.022,2.577,10.66,0.2272,19.5,11.58,7.357,36.34,12.33,14.35,53.06,12.96,21.47,69.88,13.31,28.19,86.65,13.45,34.39,103.0,13.08,41.36,120.3,12.53,47.38,137.9,11.52,53.08,156.0,11.13,55.74,174.3,10.82,56.99,192.6,10.72,59.23,210.8,10.17,59.67,229.1,9.332,58.07,247.3,7.655,57.25,265.2,6.045,56.14,283.9,3.88,56.28,305.8,3.112,54.26,324.5,3.111,54.26,340.3,3.338,51.85,353.7,3.376,40.25,367.0,2.986,24.67,368.9,2.698,4.603,367.0,2.426,-16.23,352.9,2.476,-24.65,333.0,2.496,-27.47,313.1,2.5,-26.23,296.2,2.472,-22.66,278.8,2.428,-17.45,260.8,2.399,-12.16,243.0,2.371,-7.717,225.0,2.348,-3.115,206.7,2.312,-2.477,188.5,2.288,-3.483,169.7,2.239,-1.287,149.8,2.275,-3.75,131.7,2.358,-8.071,114.9,2.463,-14.18,100.4,2.562,-25.71,90.72,2.614,-41.85,86.37,2.654,-60.62,85.63,2.678,-79.14,89.62,2.695,-96.48,93.92,2.706,-114.4,98.32,2.705,-132.4,102.4,2.704,-150.0,106.6,2.701,-168.2,109.9,2.699,-186.9,113.2,2.697,-205.0,116.3,2.703,-223.3,119.5,2.677,-242.2,124.6,2.671,-260.7,136.0,2.586,-274.3,147.6,2.655,-286.3,162.2,2.934,-297.0,180.1,3.192,-305.3,198.0,3.424,-311.6,216.3,3.605,-313.4,234.2,3.771,-315.6,252.3,3.92,-317.4,270.7,4.05,-318.9,289.1,4.156,-319.6,307.5,4.109,-319.7,325.9,4.208,-318.6,344.3,4.346,-316.6,362.7,4.906,-314.4,380.4,5.254,-311.4,397.7,5.339,-306.8,415.4,5.254,-302.2,432.7,5.108,-297.5,449.9,4.975,-292.7,467.4,4.904,-287.6,485.2,4.894,-282.0,503.5,4.918,-276.8,521.7,4.979,-272.2,539.2,5.025,-264.4,559.5,5.217,-261.1,577.1,5.521,-259.7,592.7,5.536,-260.0,609.2,5.673,-266.6,625.8,5.681,-275.3,637.2,5.98,-287.9,643.5,6.524,-304.4,647.8,7.731,-322.9,649.2,8.83,-341.2,645.5,9.758,-359.2,641.8,10.57,-377.1,637.5,11.32,-394.9,633.8,12.09,-413.0,630.2,12.87,-431.1,626.9,13.65,-449.2,623.2,14.43,-467.1,619.5,15.2,-484.9,615.9,15.99,-502.7,612.4,16.78,-520.8};
			return value;
		}
		private double[] getcam_car_chase_POS_INTERP_3_140_keyValue_2()
		{
			double[] value = {609.1,17.56,-538.7,606.3,18.33,-556.6,603.1,19.09,-574.6,600.8,19.84,-592.7,596.6,20.53,-610.0,590.4,21.21,-626.5,586.1,21.66,-643.9,578.2,22.27,-660.2,565.8,23.26,-673.1,551.5,23.85,-684.5,537.3,24.29,-693.4,522.5,24.88,-701.2,502.6,26.11,-708.5,483.1,27.4,-715.0,465.6,28.76,-718.8,447.7,30.48,-721.0,429.6,32.79,-721.6,411.5,35.32,-721.8,393.4,38.14,-721.8,375.3,41.01,-721.1,357.2,43.63,-720.4,338.9,45.85,-719.5,320.6,47.65,-720.0,302.5,49.12,-721.8,284.2,49.91,-722.0,266.1,50.75,-721.8,248.0,51.6,-721.1,229.9,52.98,-719.5,211.4,54.62,-717.8,193.6,55.88,-716.9,181.0,56.93,-715.5,170.3,57.06,-717.5,159.7,57.14,-721.0,147.3,57.03,-725.2,134.0,56.99,-730.3,119.9,57.01,-733.3,106.6,57.88,-737.3,93.7,58.32,-738.9,79.87,57.82,-736.2,79.41,56.84,-725.4,77.53,54.88,-714.7,76.89,51.27,-700.9,68.47,48.1,-691.1,59.62,45.34,-683.6,47.72,44.12,-676.4,30.01,41.79,-672.2,11.54,39.43,-669.3,-6.463,36.79,-672.5,-24.68,34.26,-675.1,-42.89,31.75,-677.3,-61.71,29.48,-681.1,-85.61,27.17,-677.3,-108.9,25.76,-662.8,-126.4,24.6,-648.0,-139.1,23.79,-629.3,-144.8,22.49,-606.4,-147.4,21.33,-586.7,-145.9,20.34,-568.9,-142.3,19.44,-553.3,-130.3,18.0,-528.6,-113.8,15.9,-492.6,-104.1,14.73,-472.3,-97.49,13.85,-457.7,-91.04,12.82,-440.9,-86.09,11.67,-422.3,-85.55,10.82,-402.1,-87.88,10.06,-383.9,-95.84,9.198,-368.4,-107.3,8.613,-354.6,-121.1,8.209,-342.7,-137.0,8.053,-333.2,-153.3,7.908,-324.3,-170.0,7.788,-316.4,-186.6,7.674,-308.6,-203.2,7.56,-300.9,-220.1,7.47,-293.7,-236.8,7.35,-285.5,-253.0,7.234,-276.5,-269.2,6.995,-268.4,-284.8,6.757,-259.6,-300.1,6.612,-253.3,-313.8,6.511,-248.3,-327.9,6.508,-238.7,-328.8,6.546,-225.6,-324.0,6.535,-213.0,-314.0,6.51,-201.5,-299.1,6.324,-190.4,-283.3,6.095,-180.7,-267.9,5.805,-170.6,-252.8,5.539,-160.5,-237.7,5.251,-150.2,-222.7,5.056,-139.5,-207.9,4.936,-128.7,-192.7,4.93,-118.5,-177.7,4.997,-108.3,-162.6,5.143,-97.98,-147.5,5.369,-87.61,-132.3,5.653,-77.38,-116.4,6.003,-67.74,-100.5,6.361,-57.64};
			return value;
		}
		private double[] getcam_car_chase_POS_INTERP_3_140_keyValue_3()
		{
			double[] value = {-82.59,6.8,-46.1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getcam_car_chase_ROT_INTERP_3_141_key_1()
		{
			double[] value = {0.0,0.0050,0.01,0.015,0.02,0.025,0.03,0.035,0.04,0.045,0.05,0.055,0.06,0.065,0.07,0.075,0.08,0.085,0.09,0.095,0.1,0.105,0.11,0.115,0.12,0.125,0.13,0.135,0.14,0.145,0.15,0.155,0.16,0.165,0.17,0.175,0.18,0.185,0.19,0.195,0.2,0.205,0.21,0.215,0.22,0.225,0.23,0.235,0.24,0.245,0.25,0.255,0.26,0.265,0.27,0.275,0.28,0.285,0.29,0.295,0.3,0.305,0.31,0.315,0.32,0.325,0.33,0.335,0.34,0.345,0.35,0.355,0.36,0.365,0.37,0.375,0.38,0.385,0.39,0.395,0.4,0.405,0.41,0.415,0.42,0.425,0.43,0.435,0.44,0.445,0.45,0.455,0.46,0.465,0.47,0.475,0.48,0.485,0.49,0.495,0.5,0.505,0.51,0.515,0.52,0.525,0.53,0.535,0.54,0.545,0.55,0.555,0.56,0.565,0.57,0.575,0.58,0.585,0.59,0.595,0.6,0.605,0.61,0.615,0.62,0.625,0.63,0.635,0.64,0.645,0.65,0.655,0.66,0.665,0.67,0.675,0.68,0.685,0.69,0.695,0.7,0.705,0.71,0.715,0.72,0.725,0.73,0.735,0.74,0.745,0.75,0.755,0.76,0.765,0.77,0.775,0.78,0.785,0.79,0.795,0.8,0.805,0.81,0.815,0.82,0.825,0.83,0.835,0.84,0.845,0.85,0.855,0.86,0.865,0.87,0.875,0.88,0.885,0.89,0.895,0.9,0.905,0.91,0.915,0.92,0.925,0.93,0.935,0.94,0.945,0.95,0.955,0.96,0.965,0.97,0.975,0.98,0.985,0.99,0.995,1.0};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getcam_car_chase_ROT_INTERP_3_141_keyValue_1()
		{
			double[] value = {0.006813,-0.9999,0.01227,-4.155,0.008468,-0.9999,0.01499,-4.17,0.0112,-0.9997,0.01951,-4.184,0.012,-0.9997,0.01954,-4.243,0.01241,-0.9997,0.01934,-4.282,0.0113,-0.9998,0.01751,-4.287,0.00833,-0.9999,0.01283,-4.293,0.005032,-1.0,0.007728,-4.296,1.064E-4,-1.0,1.6E-4,-4.315,-0.004939,-1.0,-0.007298,-4.331,-0.01123,-0.9998,-0.01653,-4.335,-0.01465,-0.9997,-0.0202,-4.396,-0.01819,-0.9996,-0.02355,-4.457,-0.01259,-0.9998,-0.01455,-4.568,-0.01216,-0.9998,-0.01333,-4.621,-0.01397,-0.9998,-0.01528,-4.623,0.02539,0.9993,0.02583,-1.589,0.0371,0.9987,0.0355,-1.528,0.04743,0.9978,0.04625,-1.548,0.04668,0.9979,0.04507,-1.538,0.04263,0.9982,0.04123,-1.539,0.01831,0.9997,0.01608,-1.442,0.002981,1.0,0.002377,-1.346,0.003686,1.0,0.002119,-1.044,0.0197,0.9998,0.006598,-0.6466,0.06883,0.9976,0.01236,-0.3561,0.1277,-0.9918,-0.009755,-0.1537,0.0265,-0.9996,-0.007593,-0.5582,0.00428,-1.0,-0.002994,-1.221,0.003623,-1.0,-0.003378,-1.501,0.003552,-1.0,-0.003945,-1.676,0.003677,-1.0,-0.004492,-1.77,0.003642,-1.0,-0.004669,-1.817,0.003532,-1.0,-0.004394,-1.787,0.003678,-1.0,-0.004347,-1.737,0.003838,-1.0,-0.004295,-1.683,0.00444,-1.0,-0.004325,-1.545,0.004366,-1.0,-0.004015,-1.487,0.003943,-1.0,-0.003682,-1.502,0.002829,-1.0,-0.002169,-1.308,0.001765,-1.0,-0.001138,-1.145,0.001966,-1.0,-9.92E-4,-0.9346,0.004464,-1.0,-0.001472,-0.6368,0.01489,-0.9999,-0.002438,-0.3246,0.0684,-0.9977,-0.002774,-0.08126,0.05839,0.9983,0.003113,-0.1067,0.02621,0.9997,0.003279,-0.249,0.02607,0.9997,0.003471,-0.2649,0.02794,0.9996,0.003665,-0.261,0.02929,0.9996,0.003668,-0.2492,0.03071,0.9995,0.003686,-0.239,0.03326,0.9994,0.003678,-0.2204,0.03103,0.9995,0.00367,-0.2355,0.02881,0.9996,0.00366,-0.2528,0.02226,0.9997,0.00383,-0.3409,0.01283,0.9999,0.003359,-0.5122,0.006523,1.0,0.002811,-0.8137,-0.001283,1.0,-6.491E-4,-0.9365,-0.005889,1.0,-0.003555,-1.086,-0.003506,1.0,-0.002509,-1.242,-0.002375,1.0,-0.001917,-1.358,-0.00105,1.0,-9.75E-4,-1.497,-5.828E-4,1.0,-5.423E-4,-1.499,0.0,1.0,0.0,-1.523,6.321E-4,1.0,6.21E-4,-1.553,-0.001247,-1.0,-0.001276,-4.689,-0.002221,-1.0,-0.002371,-4.647,6.834E-4,-1.0,7.693E-4,-4.594,0.002608,-1.0,0.003065,-4.552,0.005679,-1.0,0.00685,-4.526,0.001657,-1.0,0.002102,-4.476,-0.002623,-1.0,-0.003525,-4.421,-0.004588,-1.0,-0.006159,-4.422,-0.005234,-1.0,-0.007088,-4.414,-0.004443,-1.0,-0.006067,-4.406,-0.003333,-1.0,-0.004585,-4.399,-0.002337,-1.0,-0.003232,-4.394,-0.001732,-1.0,-0.002339,-4.417,-0.001067,-1.0,-0.001414,-4.434,-4.932E-4,-1.0,-6.638E-4,-4.42,0.00133,-1.0,0.001463,-4.617,-0.002762,1.0,-0.002598,-1.51,1.712E-4,1.0,1.324E-4,-1.317,-0.003318,1.0,-0.001938,-1.057,-0.008097,1.0,-0.003699,-0.857,-0.04174,0.9991,-0.01169,-0.5467,-0.1274,0.9917,-0.01805,-0.2839,-0.3406,0.9399,-0.0244,-0.1521,-0.9828,-0.1844,0.004405,-0.04859,-0.2223,-0.9748,0.01955,-0.18,-0.1959,-0.9805,0.01769,-0.1837,-0.1755,-0.9843,0.01672,-0.1929,-0.2006,-0.9795,0.01711,-0.1737,-0.2069,-0.9782,0.01709,-0.1686,-0.213,-0.9769,0.01709,-0.1639,-0.2005,-0.9796,0.01736,-0.1764,-0.2025,-0.9791,0.01743,-0.1754,-0.2127,-0.977,0.01741,-0.1671,-0.222,-0.9749,0.01722,-0.1588,-0.2296,-0.9731,0.01704,-0.1522};
			return value;
		}
		private double[] getcam_car_chase_ROT_INTERP_3_141_keyValue_2()
		{
			double[] value = {-0.2331,-0.9723,0.01676,-0.1476,-0.2018,-0.9793,0.01638,-0.1654,-0.1775,-0.984,0.01591,-0.1816,-0.1088,-0.9939,0.01501,-0.2757,-0.07828,-0.9968,0.01412,-0.3581,-0.0632,-0.9979,0.01267,-0.3964,-0.05145,-0.9986,0.01578,-0.5959,-0.04383,-0.9989,0.01929,-0.8299,-0.02789,-0.9995,0.01431,-0.9485,-0.02498,-0.9996,0.01456,-1.056,-0.03264,-0.9993,0.02078,-1.135,-0.04034,-0.9988,0.02832,-1.225,-0.04472,-0.9984,0.03358,-1.29,-0.05088,-0.9978,0.04226,-1.388,-0.05779,-0.997,0.05194,-1.467,-0.06605,-0.9958,0.06289,-1.526,-0.06953,-0.9953,0.06736,-1.544,-0.07211,-0.9949,0.07119,-1.563,-0.0676,-0.9954,0.06765,-1.576,-0.06018,-0.9964,0.05985,-1.569,-0.0499,-0.9976,0.049,-1.555,-0.04129,-0.9984,0.03873,-1.509,-0.03193,-0.9991,0.02935,-1.488,-0.02117,-0.9996,0.02068,-1.548,-0.02214,-0.9995,0.02215,-1.572,-0.02553,-0.9993,0.02612,-1.594,-0.03197,-0.9989,0.03307,-1.606,-0.03325,-0.9989,0.0339,-1.591,-0.0253,-0.9994,0.02416,-1.525,-0.01739,-0.9997,0.0154,-1.45,0.002328,-1.0,-0.001778,-1.304,0.005608,-1.0,-0.00414,-1.272,0.0096,-0.9999,-0.007223,-1.29,0.007995,-0.9999,-0.006446,-1.357,0.008529,-0.9999,-0.007984,-1.505,0.009671,-0.9999,-0.01052,-1.655,0.02633,-0.9989,-0.03954,-1.968,0.02941,-0.9971,-0.0705,-2.353,0.01406,-0.9956,-0.09264,-2.842,0.02508,-0.993,-0.1156,-2.717,0.03637,-0.9909,-0.1293,-2.598,0.05382,-0.993,-0.105,-2.2,0.05445,-0.9947,-0.08679,-2.026,0.04423,-0.9972,-0.06055,-1.882,0.06106,-0.9958,-0.06866,-1.692,0.06938,-0.9952,-0.06964,-1.579,0.08475,-0.9938,-0.07195,-1.414,0.07884,-0.9945,-0.06865,-1.438,0.07166,-0.9953,-0.06499,-1.478,0.05672,-0.9968,-0.05656,-1.571,0.0359,-0.9983,-0.04621,-1.822,0.01567,-0.9994,-0.02997,-2.178,0.01129,-0.9995,-0.02859,-2.39,0.006174,-0.9997,-0.02543,-2.665,0.003213,-0.9995,-0.03158,-2.939,4.052E-4,-0.9995,-0.03242,-3.117,-0.002454,-0.9995,-0.03144,-3.297,-0.004565,-0.9995,-0.03087,-3.435,-0.006414,-0.9995,-0.02982,-3.565,-0.006017,-0.9995,-0.03018,-3.535,-0.005782,-0.9995,-0.03043,-3.517,-0.004953,-0.9995,-0.03145,-3.454,-0.00336,-0.9995,-0.03152,-3.354,-0.001179,-0.9995,-0.03065,-3.218,0.001952,-0.9997,-0.02531,-2.988,0.004557,-0.9997,-0.02433,-2.771,0.007829,-0.9997,-0.02317,-2.49,0.007298,-0.9998,-0.0166,-2.313,0.006208,-0.9999,-0.01167,-2.164,0.004698,-1.0,-0.007807,-2.058,0.00454,-1.0,-0.007213,-2.018,0.004463,-1.0,-0.006813,-1.982,0.00443,-1.0,-0.006738,-1.978,0.004412,-1.0,-0.006705,-1.978,0.004378,-1.0,-0.006671,-1.98,0.004624,-1.0,-0.007342,-2.018,0.004843,-1.0,-0.007982,-2.051,0.005715,-0.9999,-0.00945,-2.054,0.005056,-0.9999,-0.008898,-2.108,0.003634,-1.0,-0.006937,-2.177,0.002201,-1.0,-0.005743,-2.41,6.766E-4,-1.0,-0.00403,-2.809,-6.182E-4,-1.0,-0.004311,-3.426,-0.001735,-1.0,-0.005669,-3.736,-0.002944,-1.0,-0.00691,-3.947,-0.004618,-0.9999,-0.009269,-4.066,-0.005489,-0.9999,-0.01031,-4.12,-0.005622,-0.9999,-0.01089,-4.094,-0.005248,-0.9999,-0.01027,-4.086,-0.004855,-0.9999,-0.00961,-4.077,-0.003567,-1.0,-0.007168,-4.065,-0.002444,-1.0,-0.004901,-4.067,-0.001167,-1.0,-0.002277,-4.089,-1.237E-4,-1.0,-2.417E-4,-4.088,9.202E-4,-1.0,0.001799,-4.087,0.001855,-1.0,0.003596,-4.094,0.002665,-1.0,0.005084,-4.107,0.003413,-1.0,0.006335,-4.13,0.003873,-1.0,0.00724,-4.124,0.004619,-1.0,0.008618,-4.126};
			return value;
		}
		private double[] getcam_car_chase_ROT_INTERP_3_141_keyValue_3()
		{
			double[] value = {0.006813,-0.9999,0.01227,-4.155};
			return value;
		}

		/** Large attribute array: PositionInterpolator DEF='cam_car_chase-POS-INTERP' key field, scene-graph level=3, element #140, 201 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFFloat getcam_car_chase_POS_INTERP_3_140_key()
		{
			MFFloat cam_car_chase_POS_INTERP_3_140_key = new MFFloat()/*2.finalize*/
				.append(new MFFloat(getcam_car_chase_POS_INTERP_3_140_key_1()));
			return cam_car_chase_POS_INTERP_3_140_key;
		}
		/** Large attribute array: PositionInterpolator DEF='cam_car_chase-POS-INTERP' keyValue field, scene-graph level=3, element #140, 603 total numbers made up of 201 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getcam_car_chase_POS_INTERP_3_140_keyValue()
		{
			MFVec3f cam_car_chase_POS_INTERP_3_140_keyValue = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getcam_car_chase_POS_INTERP_3_140_keyValue_1()))
				.append(new MFVec3f(getcam_car_chase_POS_INTERP_3_140_keyValue_2()))
				.append(new MFVec3f(getcam_car_chase_POS_INTERP_3_140_keyValue_3()));
			return cam_car_chase_POS_INTERP_3_140_keyValue;
		}
		/** Large attribute array: OrientationInterpolator DEF='cam_car_chase-ROT-INTERP' key field, scene-graph level=3, element #141, 201 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFFloat getcam_car_chase_ROT_INTERP_3_141_key()
		{
			MFFloat cam_car_chase_ROT_INTERP_3_141_key = new MFFloat()/*2.finalize*/
				.append(new MFFloat(getcam_car_chase_ROT_INTERP_3_141_key_1()));
			return cam_car_chase_ROT_INTERP_3_141_key;
		}
		/** Large attribute array: OrientationInterpolator DEF='cam_car_chase-ROT-INTERP' keyValue field, scene-graph level=3, element #141, 804 total numbers made up of 201 4-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFRotation getcam_car_chase_ROT_INTERP_3_141_keyValue()
		{
			MFRotation cam_car_chase_ROT_INTERP_3_141_keyValue = new MFRotation()/*2.finalize*/
				.append(new MFRotation(getcam_car_chase_ROT_INTERP_3_141_keyValue_1()))
				.append(new MFRotation(getcam_car_chase_ROT_INTERP_3_141_keyValue_2()))
				.append(new MFRotation(getcam_car_chase_ROT_INTERP_3_141_keyValue_3()));
			return cam_car_chase_ROT_INTERP_3_141_keyValue;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return CarDemoMain model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new CarDemoMain().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.RigidBodyPhysics.CarDemoMain\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.RigidBodyPhysics.CarDemoMain self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // RigidBodyPhysics/CarDemoMain_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "RigidBodyPhysics/CarDemoMain_JavaExport.x3d"; 
                String filenameX3DV = "RigidBodyPhysics/CarDemoMain_JavaExport.x3dv"; 
                String filenameJSON = "RigidBodyPhysics/CarDemoMain_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
