####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BasicPointSprites.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='4.0',
  head=head(
    children=[
    meta(content='BasicPointSprites.x3d',name='title'),
    meta(content='PointProperties test case, suitable for X3Dv4 implementation comparisons and conformance.',name='description'),
    meta(content='Vince Marchetti',name='creator'),
    meta(content='1 May 2019',name='created'),
    meta(content='4 September 2024',name='modified'),
    meta(content='https://www.web3d.org/x3dv4-implementations',name='reference'),
    meta(content='X3Dv4.0',name='requires'),
    meta(content='Copyright (c) Web3D Consortium Inc. 2006 to present',name='rights'),
    meta(content='PointProperties test',name='subject'),
    meta(content='under development',name='warning'),
    meta(content='originals/basic_point_sprites.x3d',name='reference'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Points/BasicPointSprites.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BasicPointSprites.x3d'),
    Transform(translation=(-2,0,0),
      children=[
      Viewpoint(DEF='PointProperties1imagespritefar'),
      Viewpoint(DEF='PointProperties1imagespritenear',position=(0,0,5)),
      Shape(
        appearance=Appearance(DEF='PointProperties1',
          pointProperties=PointProperties(attenuation=(1,0.01,0.1),pointSizeMaxValue=100,pointSizeMinValue=5,pointSizeScaleFactor=100),
          #  X3Dv3.3 ImageTexture has no effect on points, X3Dv4.0 each point is replaced by an image sprite 
          texture=ImageTexture(url=["images/sphere.png","https://www.web3d.org/x3d/content/examples/Basic/Points/images/sphere.png"])),
        geometry=PointSet(
          coord=Coordinate(point=[(1,0,0),(0.970142,0.242536,0),(0.970142,0,0.242536),(0.904534,0.301511,0.301511),(0.83205,0,0.5547),(0.666667,0.333333,0.666667),(0.5547,0,0.83205),(0.301511,0.301511,0.904534),(0.242536,0,0.970142),(0,0.242536,0.970142),(0,0,1),(0.83205,0.5547,0),(0.666667,0.666667,0.333333),(0.333333,0.666667,0.666667),(0,0.5547,0.83205),(0.5547,0.83205,0),(0.301511,0.904534,0.301511),(0,0.83205,0.5547),(0.242536,0.970142,0),(0,0.970142,0.242536),(0,1,0),(-0.242536,0,0.970142),(-0.301511,0.301511,0.904534),(-0.5547,0,0.83205),(-0.666667,0.333333,0.666667),(-0.83205,0,0.5547),(-0.904534,0.301511,0.301511),(-0.970142,0,0.242536),(-0.970142,0.242536,0),(-1,0,0),(-0.333333,0.666667,0.666667),(-0.666667,0.666667,0.333333),(-0.83205,0.5547,0),(-0.301511,0.904534,0.301511),(-0.5547,0.83205,0),(-0.242536,0.970142,0),(0,-0.242536,0.970142),(0.301511,-0.301511,0.904534),(0.666667,-0.333333,0.666667),(0.904534,-0.301511,0.301511),(0.970142,-0.242536,0),(0,-0.5547,0.83205),(0.333333,-0.666667,0.666667),(0.666667,-0.666667,0.333333),(0.83205,-0.5547,0),(0,-0.83205,0.5547),(0.301511,-0.904534,0.301511),(0.5547,-0.83205,0),(0,-0.970142,0.242536),(0.242536,-0.970142,0),(0,-1,0),(-0.970142,-0.242536,0),(-0.904534,-0.301511,0.301511),(-0.666667,-0.333333,0.666667),(-0.301511,-0.301511,0.904534),(-0.83205,-0.5547,0),(-0.666667,-0.666667,0.333333),(-0.333333,-0.666667,0.666667),(-0.5547,-0.83205,0),(-0.301511,-0.904534,0.301511),(-0.242536,-0.970142,0),(0,0,-1),(0,0.242536,-0.970142),(0.242536,0,-0.970142),(0.301511,0.301511,-0.904534),(0.5547,0,-0.83205),(0.666667,0.333333,-0.666667),(0.83205,0,-0.5547),(0.904534,0.301511,-0.301511),(0.970142,0,-0.242536),(0,0.5547,-0.83205),(0.333333,0.666667,-0.666667),(0.666667,0.666667,-0.333333),(0,0.83205,-0.5547),(0.301511,0.904534,-0.301511),(0,0.970142,-0.242536),(-0.970142,0,-0.242536),(-0.904534,0.301511,-0.301511),(-0.83205,0,-0.5547),(-0.666667,0.333333,-0.666667),(-0.5547,0,-0.83205),(-0.301511,0.301511,-0.904534),(-0.242536,0,-0.970142),(-0.666667,0.666667,-0.333333),(-0.333333,0.666667,-0.666667),(-0.301511,0.904534,-0.301511),(0.904534,-0.301511,-0.301511),(0.666667,-0.333333,-0.666667),(0.301511,-0.301511,-0.904534),(0,-0.242536,-0.970142),(0.666667,-0.666667,-0.333333),(0.333333,-0.666667,-0.666667),(0,-0.5547,-0.83205),(0.301511,-0.904534,-0.301511),(0,-0.83205,-0.5547),(0,-0.970142,-0.242536),(-0.301511,-0.301511,-0.904534),(-0.666667,-0.333333,-0.666667),(-0.904534,-0.301511,-0.301511),(-0.333333,-0.666667,-0.666667),(-0.666667,-0.666667,-0.333333),(-0.301511,-0.904534,-0.301511)]),
          color=Color(color=[(1,0,0),(0.970142,0.242536,0),(0.970142,0,0.242536),(0.904534,0.301511,0.301511),(0.83205,0,0.5547),(0.666667,0.333333,0.666667),(0.5547,0,0.83205),(0.301511,0.301511,0.904534),(0.242536,0,0.970142),(0,0.242536,0.970142),(0,0,1),(0.83205,0.5547,0),(0.666667,0.666667,0.333333),(0.333333,0.666667,0.666667),(0,0.5547,0.83205),(0.5547,0.83205,0),(0.301511,0.904534,0.301511),(0,0.83205,0.5547),(0.242536,0.970142,0),(0,0.970142,0.242536),(0,1,0),(0.242536,0,0.970142),(0.301511,0.301511,0.904534),(0.5547,0,0.83205),(0.666667,0.333333,0.666667),(0.83205,0,0.5547),(0.904534,0.301511,0.301511),(0.970142,0,0.242536),(0.970142,0.242536,0),(1,0,0),(0.333333,0.666667,0.666667),(0.666667,0.666667,0.333333),(0.83205,0.5547,0),(0.301511,0.904534,0.301511),(0.5547,0.83205,0),(0.242536,0.970142,0),(0,0.242536,0.970142),(0.301511,0.301511,0.904534),(0.666667,0.333333,0.666667),(0.904534,0.301511,0.301511),(0.970142,0.242536,0),(0,0.5547,0.83205),(0.333333,0.666667,0.666667),(0.666667,0.666667,0.333333),(0.83205,0.5547,0),(0,0.83205,0.5547),(0.301511,0.904534,0.301511),(0.5547,0.83205,0),(0,0.970142,0.242536),(0.242536,0.970142,0),(0,1,0),(0.970142,0.242536,0),(0.904534,0.301511,0.301511),(0.666667,0.333333,0.666667),(0.301511,0.301511,0.904534),(0.83205,0.5547,0),(0.666667,0.666667,0.333333),(0.333333,0.666667,0.666667),(0.5547,0.83205,0),(0.301511,0.904534,0.301511),(0.242536,0.970142,0),(0,0,1),(0,0.242536,0.970142),(0.242536,0,0.970142),(0.301511,0.301511,0.904534),(0.5547,0,0.83205),(0.666667,0.333333,0.666667),(0.83205,0,0.5547),(0.904534,0.301511,0.301511),(0.970142,0,0.242536),(0,0.5547,0.83205),(0.333333,0.666667,0.666667),(0.666667,0.666667,0.333333),(0,0.83205,0.5547),(0.301511,0.904534,0.301511),(0,0.970142,0.242536),(0.970142,0,0.242536),(0.904534,0.301511,0.301511),(0.83205,0,0.5547),(0.666667,0.333333,0.666667),(0.5547,0,0.83205),(0.301511,0.301511,0.904534),(0.242536,0,0.970142),(0.666667,0.666667,0.333333),(0.333333,0.666667,0.666667),(0.301511,0.904534,0.301511),(0.904534,0.301511,0.301511),(0.666667,0.333333,0.666667),(0.301511,0.301511,0.904534),(0,0.242536,0.970142),(0.666667,0.666667,0.333333),(0.333333,0.666667,0.666667),(0,0.5547,0.83205),(0.301511,0.904534,0.301511),(0,0.83205,0.5547),(0,0.970142,0.242536),(0.301511,0.301511,0.904534),(0.666667,0.333333,0.666667),(0.904534,0.301511,0.301511),(0.333333,0.666667,0.666667),(0.666667,0.666667,0.333333),(0.301511,0.904534,0.301511)])))]),
    Transform(translation=(2,0,0),
      #  what do we want to show? 
      children=[
      Viewpoint(DEF='PointProperties2far'),
      Viewpoint(DEF='PointProperties2near',position=(0,0,5)),
      Shape(
        geometry=PointSet(
          coord=Coordinate(point=[(1,0,0),(0.970142,0.242536,0),(0.970142,0,0.242536),(0.904534,0.301511,0.301511),(0.83205,0,0.5547),(0.666667,0.333333,0.666667),(0.5547,0,0.83205),(0.301511,0.301511,0.904534),(0.242536,0,0.970142),(0,0.242536,0.970142),(0,0,1),(0.83205,0.5547,0),(0.666667,0.666667,0.333333),(0.333333,0.666667,0.666667),(0,0.5547,0.83205),(0.5547,0.83205,0),(0.301511,0.904534,0.301511),(0,0.83205,0.5547),(0.242536,0.970142,0),(0,0.970142,0.242536),(0,1,0),(-0.242536,0,0.970142),(-0.301511,0.301511,0.904534),(-0.5547,0,0.83205),(-0.666667,0.333333,0.666667),(-0.83205,0,0.5547),(-0.904534,0.301511,0.301511),(-0.970142,0,0.242536),(-0.970142,0.242536,0),(-1,0,0),(-0.333333,0.666667,0.666667),(-0.666667,0.666667,0.333333),(-0.83205,0.5547,0),(-0.301511,0.904534,0.301511),(-0.5547,0.83205,0),(-0.242536,0.970142,0),(0,-0.242536,0.970142),(0.301511,-0.301511,0.904534),(0.666667,-0.333333,0.666667),(0.904534,-0.301511,0.301511),(0.970142,-0.242536,0),(0,-0.5547,0.83205),(0.333333,-0.666667,0.666667),(0.666667,-0.666667,0.333333),(0.83205,-0.5547,0),(0,-0.83205,0.5547),(0.301511,-0.904534,0.301511),(0.5547,-0.83205,0),(0,-0.970142,0.242536),(0.242536,-0.970142,0),(0,-1,0),(-0.970142,-0.242536,0),(-0.904534,-0.301511,0.301511),(-0.666667,-0.333333,0.666667),(-0.301511,-0.301511,0.904534),(-0.83205,-0.5547,0),(-0.666667,-0.666667,0.333333),(-0.333333,-0.666667,0.666667),(-0.5547,-0.83205,0),(-0.301511,-0.904534,0.301511),(-0.242536,-0.970142,0),(0,0,-1),(0,0.242536,-0.970142),(0.242536,0,-0.970142),(0.301511,0.301511,-0.904534),(0.5547,0,-0.83205),(0.666667,0.333333,-0.666667),(0.83205,0,-0.5547),(0.904534,0.301511,-0.301511),(0.970142,0,-0.242536),(0,0.5547,-0.83205),(0.333333,0.666667,-0.666667),(0.666667,0.666667,-0.333333),(0,0.83205,-0.5547),(0.301511,0.904534,-0.301511),(0,0.970142,-0.242536),(-0.970142,0,-0.242536),(-0.904534,0.301511,-0.301511),(-0.83205,0,-0.5547),(-0.666667,0.333333,-0.666667),(-0.5547,0,-0.83205),(-0.301511,0.301511,-0.904534),(-0.242536,0,-0.970142),(-0.666667,0.666667,-0.333333),(-0.333333,0.666667,-0.666667),(-0.301511,0.904534,-0.301511),(0.904534,-0.301511,-0.301511),(0.666667,-0.333333,-0.666667),(0.301511,-0.301511,-0.904534),(0,-0.242536,-0.970142),(0.666667,-0.666667,-0.333333),(0.333333,-0.666667,-0.666667),(0,-0.5547,-0.83205),(0.301511,-0.904534,-0.301511),(0,-0.83205,-0.5547),(0,-0.970142,-0.242536),(-0.301511,-0.301511,-0.904534),(-0.666667,-0.333333,-0.666667),(-0.904534,-0.301511,-0.301511),(-0.333333,-0.666667,-0.666667),(-0.666667,-0.666667,-0.333333),(-0.301511,-0.904534,-0.301511)]),
          color=Color(color=[(1,0,0),(0.970142,0.242536,0),(0.970142,0,0.242536),(0.904534,0.301511,0.301511),(0.83205,0,0.5547),(0.666667,0.333333,0.666667),(0.5547,0,0.83205),(0.301511,0.301511,0.904534),(0.242536,0,0.970142),(0,0.242536,0.970142),(0,0,1),(0.83205,0.5547,0),(0.666667,0.666667,0.333333),(0.333333,0.666667,0.666667),(0,0.5547,0.83205),(0.5547,0.83205,0),(0.301511,0.904534,0.301511),(0,0.83205,0.5547),(0.242536,0.970142,0),(0,0.970142,0.242536),(0,1,0),(0.242536,0,0.970142),(0.301511,0.301511,0.904534),(0.5547,0,0.83205),(0.666667,0.333333,0.666667),(0.83205,0,0.5547),(0.904534,0.301511,0.301511),(0.970142,0,0.242536),(0.970142,0.242536,0),(1,0,0),(0.333333,0.666667,0.666667),(0.666667,0.666667,0.333333),(0.83205,0.5547,0),(0.301511,0.904534,0.301511),(0.5547,0.83205,0),(0.242536,0.970142,0),(0,0.242536,0.970142),(0.301511,0.301511,0.904534),(0.666667,0.333333,0.666667),(0.904534,0.301511,0.301511),(0.970142,0.242536,0),(0,0.5547,0.83205),(0.333333,0.666667,0.666667),(0.666667,0.666667,0.333333),(0.83205,0.5547,0),(0,0.83205,0.5547),(0.301511,0.904534,0.301511),(0.5547,0.83205,0),(0,0.970142,0.242536),(0.242536,0.970142,0),(0,1,0),(0.970142,0.242536,0),(0.904534,0.301511,0.301511),(0.666667,0.333333,0.666667),(0.301511,0.301511,0.904534),(0.83205,0.5547,0),(0.666667,0.666667,0.333333),(0.333333,0.666667,0.666667),(0.5547,0.83205,0),(0.301511,0.904534,0.301511),(0.242536,0.970142,0),(0,0,1),(0,0.242536,0.970142),(0.242536,0,0.970142),(0.301511,0.301511,0.904534),(0.5547,0,0.83205),(0.666667,0.333333,0.666667),(0.83205,0,0.5547),(0.904534,0.301511,0.301511),(0.970142,0,0.242536),(0,0.5547,0.83205),(0.333333,0.666667,0.666667),(0.666667,0.666667,0.333333),(0,0.83205,0.5547),(0.301511,0.904534,0.301511),(0,0.970142,0.242536),(0.970142,0,0.242536),(0.904534,0.301511,0.301511),(0.83205,0,0.5547),(0.666667,0.333333,0.666667),(0.5547,0,0.83205),(0.301511,0.301511,0.904534),(0.242536,0,0.970142),(0.666667,0.666667,0.333333),(0.333333,0.666667,0.666667),(0.301511,0.904534,0.301511),(0.904534,0.301511,0.301511),(0.666667,0.333333,0.666667),(0.301511,0.301511,0.904534),(0,0.242536,0.970142),(0.666667,0.666667,0.333333),(0.333333,0.666667,0.666667),(0,0.5547,0.83205),(0.301511,0.904534,0.301511),(0,0.83205,0.5547),(0,0.970142,0.242536),(0.301511,0.301511,0.904534),(0.666667,0.333333,0.666667),(0.904534,0.301511,0.301511),(0.333333,0.666667,0.666667),(0.666667,0.666667,0.333333),(0.301511,0.904534,0.301511)])),
        appearance=Appearance(USE='PointProperties1'))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BasicPointSprites.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BasicPointSprites.py load and self-test diagnostics complete.")
