package Basic.Points;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> PointSet rendering of 3D scan with color applied per vertex, rendered with proposed PointProperties extension. </p>
 <p> Related links: Catalog page <a href="../../../Points/ArchimedesPointPropertiesIndex.html" target="_blank">ArchimedesPointProperties</a>,  source <a href="../../../Points/ArchimedesPointProperties.java">ArchimedesPointProperties.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Points/ArchimedesPointProperties.x3d">ArchimedesPointProperties.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> PointSet rendering of 3D scan with color applied per vertex, rendered with proposed PointProperties extension </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 16 April 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 21 November 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Vincent Marchetti </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> ArchimedesReadme.txt </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../Points/ArchimedesPointPropertiesScreenshot.png">ArchimedesPointPropertiesScreenshot.png</a> </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Contains non-standard PointProperties node for use with Xj3D </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3dv4-implementations" target="_blank">https://www.web3d.org/x3dv4-implementations</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> requires </i> </td>
			<td> X3Dv4.0 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> rights </i> </td>
			<td> Copyright (c) Web3D Consortium Inc. 2006 to present </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Points/ArchimedesPointProperties.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Points/ArchimedesPointProperties.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="http://creativecommons.org/licenses/by/4.0/" target="_blank">http://creativecommons.org/licenses/by/4.0/</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Vincent Marchetti
 */

public class ArchimedesPointProperties
{
	/** Default constructor to create this object. */
	public ArchimedesPointProperties ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_4_0)
  .setHead(new head()
    .addComments(" component level='1' name='xj3d_Shape'/ ")
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("ArchimedesPointProperties.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("PointSet rendering of 3D scan with color applied per vertex, rendered with proposed PointProperties extension"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("16 April 2019"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("21 November 2020"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Vincent Marchetti"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("ArchimedesReadme.txt"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("ArchimedesPointPropertiesScreenshot.png"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("Contains non-standard PointProperties node for use with Xj3D"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3dv4-implementations"))
    .addMeta(new meta().setName(meta.NAME_REQUIRES   ).setContent("X3Dv4.0"))
    .addMeta(new meta().setName(meta.NAME_RIGHTS     ).setContent("Copyright (c) Web3D Consortium Inc. 2006 to present"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Points/ArchimedesPointProperties.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("http://creativecommons.org/licenses/by/4.0/")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("ArchimedesPointProperties.x3d"))
    .addChild(new Background().setSkyColor(new MFColor(new double[] {1.0,1.0,1.0})))
    .addChild(new Viewpoint().setDescription("Face On view").setPosition(0.0,0.0,16.0))
    .addChild(new Transform().setRotation(0.0,1.0,0.0,3.2)
      .addChild(new Transform().setTranslation(-1.0,0.0,0.0)
        .addChild(new Transform().setScale(0.03,0.03,0.03)
          .addChild(new Transform().setTranslation(35.0,72.0,18.0)
            .addChild(new Shape()
              .setAppearance(new Appearance()
                .setPointProperties(new PointProperties().setPointSizeMaxValue(100).setPointSizeScaleFactor(4)))
              .setGeometry(new PointSet()
                .setCoord(new Coordinate().setPoint(getCoordinate_9_21_point()))
                .setColor(new Color().setColor(getColor_9_22_color())))))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getCoordinate_9_21_point_1()
		{
			double[] value = {-59.141516,-52.654526,-5.697201,-65.419478,-51.531893,3.007445,-65.240669,-54.943547,3.856520,-63.733794,-57.138335,1.906648,-63.425988,-58.588631,3.320952,-63.352906,-58.882960,4.608362,-63.336914,-58.553599,2.633503,-63.279260,-58.430650,2.218679,-63.230491,-56.441338,0.456289,-62.771150,-54.139500,-1.204044,-62.065331,-51.841345,-2.434761,-61.507641,-59.122647,-0.908992,-61.423634,-59.405113,-0.223228,-61.252519,-60.131202,3.188673,-60.544812,-60.018810,0.626302,-60.291881,-59.656074,-1.702269,-59.735422,-58.806240,-3.736145,-59.437144,-60.766839,1.958038,-66.301407,-51.495679,4.823486,-66.137114,-51.459662,4.469696,-65.916181,-50.594689,3.795909,-65.397099,-44.419125,3.980744,-65.164694,-46.085281,2.594454,-64.678737,-42.318909,4.624186,-64.526179,-45.214107,1.840658,-64.215764,-48.526831,0.733130,-63.175387,-49.511880,-0.854074,-63.161266,-43.028413,1.047322,-62.601158,-48.912388,-1.648433,-62.447970,-45.391489,-1.291961,-62.341682,-43.946914,-0.771464,-61.484394,-50.858413,-3.111665,-61.261106,-48.113547,-3.224958,-60.753892,-51.037038,-3.882737,-59.028991,-45.305360,-4.986202,-63.820587,-41.019365,4.482252,-62.422910,-38.377265,5.207346,-61.981419,-38.556690,4.170992,-61.595305,-39.422899,1.988420,-60.875603,-36.401214,5.140576,-60.212154,-38.748791,0.350916,-60.173721,-40.676779,-1.481617,-68.783175,-52.327916,12.858568,-68.361331,-54.045066,13.521916,-68.332267,-53.505549,12.402014,-67.516154,-55.706478,12.698462,-66.894109,-55.120662,8.704776,-66.869239,-56.876459,12.322796,-66.819445,-52.787712,6.585139,-66.782435,-54.336057,7.644840,-66.772498,-57.033226,12.681286,-66.437214,-56.636705,9.671781,-66.016761,-56.564693,7.847338,-65.950667,-57.050452,8.975678,-65.906298,-57.246255,8.732197,-65.367815,-57.459151,6.905900,-65.223070,-57.848184,7.831297,-65.204576,-58.542391,11.947074,-65.058936,-58.572937,13.025688,-65.052945,-58.175881,8.248772,-64.916928,-57.673234,5.862230,-64.599127,-58.700810,8.877792,-64.502353,-58.538923,6.960219,-64.293675,-58.214112,5.532247,-64.081309,-58.785517,7.114415,-64.064976,-59.089164,9.091577,-63.939704,-58.897167,7.178024,-63.866013,-58.919724,6.997257,-63.743640,-58.895470,5.616719,-63.727782,-59.491449,12.471607,-63.496316,-59.196969,6.549430,-62.881567,-59.438025,5.747933,-62.254300,-60.137792,13.562756,-61.042971,-60.541268,9.135891,-60.694411,-60.679540,8.450127,-60.634029,-60.759760,10.584312,-60.354672,-60.809433,9.959519,-59.410760,-61.198921,10.046550,-59.273617,-61.274457,6.218670,-59.028474,-61.404791,9.108004,-69.124656,-50.685602,15.242288,-69.010619,-51.008186,13.071813,-68.975030,-51.040919,12.780142,-68.850656,-49.952335,12.237404,-68.704016,-49.582257,11.312533,-68.398568,-46.986466,14.715084,-68.156303,-46.084840,15.575447,-68.142704,-46.418351,12.729357,-68.118713,-45.966701,15.164518,-67.993652,-50.546079,8.650131,-67.847836,-46.590969,9.710666,-67.702349,-45.312963,11.203333,-67.439013,-46.441554,8.302062,-67.163391,-51.364124,6.633275,-67.069651,-51.398854,6.468227,-67.038468,-43.881326,9.761381,-66.966209,-50.218424,5.802015,-66.926776,-47.573607,5.930662,-66.829462,-42.943077,13.176798,-66.805081,-43.383600,9.939308};
			return value;
		}
		private double[] getCoordinate_9_21_point_2()
		{
			double[] value = {-66.547823,-42.837598,9.881199,-66.495398,-42.534681,11.612298,-65.644932,-42.478453,6.890966,-65.159476,-42.046098,6.209418,-64.871432,-42.147565,5.383638,-65.507272,-40.901927,12.973473,-65.323778,-40.726510,11.307949,-65.080716,-40.435562,10.746916,-64.897838,-39.956668,13.364882,-64.598895,-39.833666,15.445866,-64.035942,-40.395632,5.948173,-63.806004,-40.350539,5.408045,-63.361217,-37.924394,12.420087,-63.121506,-37.562998,11.772442,-62.433297,-36.742126,12.680516,-62.210551,-36.589954,10.291247,-62.129013,-37.708134,5.991741,-62.118093,-36.423948,11.946118,-62.012613,-37.416659,15.337141,-61.875086,-36.730150,7.459286,-61.652922,-36.687708,14.651540,-61.509969,-36.295215,13.669756,-61.414755,-36.472371,6.715197,-61.314380,-35.416238,11.063785,-61.267241,-35.357667,10.678968,-61.224862,-35.385877,11.317178,-61.134228,-35.815972,7.451612,-60.897872,-36.079436,14.527118,-60.264041,-34.923345,13.257555,-60.178359,-35.857104,15.540980,-59.858187,-34.460083,13.781568,-59.658489,-33.625139,12.717193,-59.467950,-33.238019,11.906533,-59.451252,-33.153787,10.270177,-59.355819,-31.214124,12.564793,-58.986947,-32.020701,11.095699,-59.582827,-26.994915,14.117748,-59.472764,-29.180084,12.768536,-58.954495,-26.549561,11.816057,-68.997009,-51.756202,19.195051,-68.966693,-53.099650,17.647915,-68.639326,-53.333766,22.586509,-68.586384,-52.737708,23.189510,-68.236560,-54.090818,24.975251,-68.225559,-53.663719,25.411484,-67.956804,-54.613684,25.266746,-67.914952,-54.681799,25.044831,-67.801101,-55.041484,23.597306,-67.556502,-55.998820,19.673641,-67.161309,-55.388666,25.692381,-66.899811,-57.150283,15.680929,-66.714153,-56.846860,21.250312,-66.672953,-57.180884,18.983283,-66.574764,-57.103558,20.085777,-66.414848,-57.699401,17.815302,-66.166273,-57.503963,21.138231,-65.659361,-57.177534,24.851565,-65.590771,-58.322296,17.990649,-65.526475,-57.588775,24.024141,-65.457025,-57.610992,23.594583,-65.419007,-58.435640,18.048566,-65.176790,-57.796506,24.094145,-65.073840,-58.312036,22.581861,-64.054792,-58.613966,24.524464,-63.806615,-59.368539,18.465051,-63.290416,-58.916919,25.828817,-63.035577,-59.618373,21.644153,-62.395470,-59.853389,22.166450,-61.337784,-60.571331,19.980570,-61.151969,-60.763183,17.334016,-60.392042,-61.096592,18.170717,-60.391131,-60.698659,25.535705,-60.295813,-60.670583,24.848461,-60.023289,-61.058217,17.697890,-60.016496,-61.051686,15.775417,-59.787551,-61.195063,21.388925,-59.733125,-61.232325,15.858310,-59.550377,-61.433882,19.548989,-59.519627,-61.289716,18.648977,-59.199525,-61.571204,20.613277,-67.996869,-48.532742,21.403398,-67.942572,-49.405032,22.808571,-67.939106,-49.173631,22.670026,-67.933903,-48.854352,22.421256,-67.825012,-47.888674,21.506897,-67.386255,-49.551667,25.513878,-67.381836,-45.278625,20.013070,-67.338394,-47.554265,23.497358,-67.224462,-43.756879,15.770222,-67.017053,-43.473263,16.090160,-66.950912,-48.392583,25.892699,-66.404484,-46.117493,25.061702,-66.186469,-43.766132,20.999282,-65.206872,-42.823400,21.696522,-64.617065,-42.053261,21.449990,-64.477087,-41.439202,20.231354,-63.954450,-42.497922,23.466830,-63.953593,-41.487978,21.550194,-63.563357,-41.916373,22.794624,-64.004478,-40.792776,19.723012};
			return value;
		}
		private double[] getCoordinate_9_21_point_3()
		{
			double[] value = {-63.715838,-40.219918,18.765139,-63.566637,-40.036304,18.607149,-63.460130,-38.836220,16.320257,-63.322646,-39.755379,18.482818,-62.996281,-39.528963,18.543425,-62.721533,-38.942681,17.593470,-62.454069,-37.915122,15.951923,-61.456559,-31.697519,25.382386,-61.371841,-32.799035,24.155173,-61.210147,-31.189986,21.997843,-61.013889,-40.797849,23.915413,-60.817572,-33.071722,20.296681,-60.714615,-35.885066,22.229660,-60.546867,-36.986010,21.851537,-60.542163,-40.792581,25.616104,-60.540455,-40.329255,24.376013,-60.520462,-36.580259,16.077917,-60.496002,-40.028226,23.897628,-60.423379,-37.256329,20.663833,-60.398131,-39.761207,24.328216,-60.394663,-39.948996,24.854555,-60.376370,-38.874612,23.388478,-60.367280,-39.183696,23.333946,-60.292598,-36.342469,16.313426,-60.110944,-35.618659,16.472680,-60.096143,-32.257893,16.020632,-61.298220,-30.279532,22.218891,-61.261821,-30.074283,25.498005,-61.047740,-29.247871,21.329867,-60.847574,-30.509255,18.631134,-60.838226,-29.202497,19.139356,-60.415775,-27.474184,22.820903,-60.261008,-26.898780,17.869304,-60.250911,-27.720568,16.450914,-60.220114,-26.596221,19.747830,-60.116950,-26.329432,19.112562,-60.095680,-26.331983,19.691170,-59.870512,-25.885988,18.143969,-59.846314,-25.936298,16.989324,-59.830675,-26.877773,23.373737,-59.804731,-26.885786,23.470443,-59.762562,-27.331467,25.306924,-59.560461,-25.474858,18.820348,-59.344436,-25.297046,19.371780,-59.003695,-26.904716,24.961388,-58.970952,-25.458217,20.899848,-67.426233,-54.691333,27.361609,-67.310093,-54.766856,27.747937,-66.939457,-52.570434,29.704747,-66.749427,-54.600785,29.887007,-66.733179,-54.973184,29.114246,-66.682304,-55.472245,27.498509,-66.641605,-54.468970,30.445978,-66.503074,-55.454661,28.577590,-66.309240,-51.906590,31.123238,-66.113336,-55.868191,29.637999,-65.823245,-56.766535,26.631718,-65.646807,-56.364199,29.744260,-65.626198,-55.963969,30.392409,-65.586135,-56.968373,26.775386,-65.533458,-56.043677,30.685663,-65.505649,-52.636235,33.601525,-65.401836,-56.267414,30.353150,-65.320057,-54.510324,33.978834,-65.311373,-57.152868,27.006313,-65.283029,-57.238580,26.904976,-65.252931,-57.114375,28.234026,-65.198130,-56.486776,30.402837,-65.096832,-56.184765,31.567957,-64.777386,-54.849435,35.278861,-64.699302,-57.778450,26.963707,-64.355722,-52.570434,35.963197,-64.016431,-57.533501,30.891447,-63.468724,-57.745884,31.603640,-63.432255,-56.411595,35.827924,-63.198794,-58.191488,30.907449,-63.180695,-57.846006,32.200475,-63.156500,-58.526468,29.899908,-62.808873,-57.295677,34.984375,-62.731104,-58.956096,29.066653,-62.703571,-59.143513,27.400838,-62.682794,-58.368130,32.222337,-62.633009,-58.202744,32.611897,-62.467527,-58.589608,31.714184,-62.306959,-59.478632,26.449844,-61.919873,-59.698835,26.526852,-61.912236,-57.868192,35.809126,-61.646144,-59.608688,28.387046,-61.570520,-58.870907,34.420075,-61.079096,-58.677225,35.525757,-60.997846,-59.132818,34.641762,-59.207608,-60.656565,30.501052,-59.107549,-60.029717,35.825454,-59.050477,-60.061048,34.903637,-66.840332,-49.932923,27.770219,-66.770684,-48.589620,26.867170,-66.392692,-49.100137,28.734897,-66.294768,-49.756104,29.594860,-66.162794,-48.048093,28.427881,-65.915248,-46.116417,26.382289};
			return value;
		}
		private double[] getCoordinate_9_21_point_4()
		{
			double[] value = {-65.695162,-49.104710,30.922113,-65.286524,-48.586758,31.425992,-65.153037,-46.854806,29.798524,-64.963211,-47.636753,31.301985,-64.665303,-49.255667,33.549962,-63.966278,-46.746274,32.806555,-63.861626,-45.894921,31.716680,-63.707121,-47.968899,34.478614,-63.417260,-44.826952,30.780032,-63.306802,-43.209955,26.087133,-63.019586,-48.212829,36.321490,-62.978607,-43.862288,28.974054,-62.794775,-44.968805,32.782702,-62.693047,-46.541131,35.408540,-62.233415,-44.029181,31.078775,-61.815886,-44.725266,34.646418,-61.811848,-43.750836,31.100570,-61.659244,-42.206807,26.345074,-61.592233,-44.868913,35.431095,-61.379582,-43.324551,30.707802,-61.115764,-41.867576,26.532974,-61.094137,-42.310699,27.957122,-61.056095,-42.087038,27.429976,-61.017455,-41.729890,26.401293,-60.971320,-43.607647,32.662370,-60.801820,-43.539344,33.010414,-60.688782,-42.949733,31.515138,-60.656520,-42.143682,29.149279,-60.553945,-41.774095,28.399560,-60.329719,-43.964094,36.016712,-60.193570,-42.588079,32.671006,-59.677369,-41.801342,34.208971,-59.533156,-41.501547,35.318650,-59.515696,-42.957587,36.053063,-61.394121,-34.644682,28.153580,-61.372024,-32.224749,30.840906,-61.342385,-31.453069,29.193717,-61.157354,-35.629424,29.690403,-61.133639,-31.083070,31.871157,-61.098311,-31.254684,32.756508,-61.076303,-32.183338,33.228703,-61.074146,-36.681660,29.928545,-61.051287,-35.369085,31.515313,-60.921636,-37.255085,30.172856,-60.868195,-31.857283,34.876990,-60.803001,-32.914756,35.500958,-60.741985,-34.240710,35.342804,-60.619679,-38.665298,31.299345,-60.585512,-36.165016,34.795581,-60.544944,-39.533439,30.019407,-60.527396,-38.483130,32.244380,-60.440968,-39.137793,32.022241,-60.326394,-40.089257,26.151368,-60.314940,-40.430556,30.688376,-60.267121,-40.396190,27.578853,-60.152856,-28.889997,32.618772,-60.132512,-28.351121,29.138908,-60.072835,-28.247754,28.728489,-59.686064,-28.785604,34.088366,-59.672978,-28.148452,29.951254,-59.415035,-28.043465,29.884167,-58.997584,-28.648932,35.309210,-63.273565,-56.059383,37.327938,-63.224472,-51.773494,38.019249,-63.155399,-55.004585,39.003624,-62.981101,-51.713230,38.538106,-62.758089,-54.630133,40.045328,-62.684103,-56.685459,37.648522,-61.899002,-52.088984,41.085828,-61.664175,-57.214100,38.753930,-61.474788,-56.576200,41.015050,-61.375695,-56.610477,41.201832,-61.357667,-55.528293,42.695111,-61.223628,-56.118801,41.949632,-60.913568,-51.870749,43.071408,-60.618360,-58.579335,37.277461,-60.391212,-55.796387,44.488571,-59.908365,-57.956560,41.009863,-59.644414,-57.706336,42.311674,-59.372204,-56.471971,45.608629,-59.275729,-57.992521,42.240218,-59.035421,-59.310410,39.091015,-63.474872,-50.323907,36.670391,-63.282834,-50.538603,37.251218,-62.728941,-49.537118,37.836952,-61.856298,-50.611886,40.148835,-61.206666,-45.148235,36.807519,-60.543684,-44.571712,37.491406,-60.522582,-50.430192,43.239507,-60.128088,-44.680737,38.483722,-59.916593,-46.581195,41.886330,-59.789105,-47.219023,42.744423,-59.704868,-43.792843,37.382489,-59.640713,-43.720722,37.381923,-59.522552,-51.360529,45.895822,-59.471030,-43.242443,36.965229,-59.432521,-44.902022,40.897290,-59.102401,-49.660172,45.917892,-60.090019,-33.373629,38.715411,-59.970739,-31.367693,38.571575};
			return value;
		}
		private double[] getCoordinate_9_21_point_5()
		{
			double[] value = {-59.596714,-37.618829,38.231511,-59.388960,-40.469364,36.616055,-59.355540,-33.429763,41.511647,-59.326298,-31.291464,40.878356,-59.706511,-29.404088,36.829291,-59.475120,-29.499856,37.793781,-59.002846,-29.645808,39.424778,-58.895581,-30.106047,40.559169,-59.342547,-55.453221,46.896362,-59.076702,-55.419085,47.447038,-49.310869,-62.699953,-8.406492,-48.723334,-63.003222,-7.937643,-58.784242,-53.554126,-6.049502,-58.634136,-51.851129,-6.100580,-57.634475,-53.107761,-6.980521,-57.327048,-53.429539,-7.333115,-57.176453,-56.303078,-7.149683,-56.829450,-58.737820,-6.780352,-56.815894,-59.092375,-6.639507,-56.705669,-55.499979,-7.607838,-56.251301,-60.690234,-5.306894,-55.403730,-57.162227,-8.305381,-55.179027,-54.709298,-8.718170,-55.015624,-60.834009,-6.843702,-54.666969,-60.579814,-7.553749,-54.652615,-60.988110,-6.666653,-53.820867,-55.810043,-9.596768,-53.236202,-54.538193,-10.134643,-53.223160,-61.241590,-7.904550,-51.753615,-54.981899,-11.106579,-51.676769,-55.085217,-11.145751,-50.814989,-56.036103,-11.586557,-50.675383,-61.822926,-9.549977,-50.361174,-61.801322,-10.000398,-50.142899,-60.418313,-11.098023,-49.446095,-60.403496,-11.606200,-49.317301,-53.387308,-12.821627,-48.638178,-55.619236,-13.006432,-48.441797,-57.009767,-13.012395,-58.291654,-44.141474,-5.439420,-57.806143,-42.851045,-5.426340,-57.660996,-49.286491,-6.956780,-57.581171,-48.146789,-6.844805,-57.286206,-50.951113,-7.332798,-57.048468,-50.596620,-7.547437,-56.691025,-43.938141,-6.865991,-56.277457,-46.664138,-7.709411,-55.694122,-45.198331,-7.930702,-54.943559,-42.500991,-7.914262,-54.328851,-47.166562,-9.360446,-54.108327,-47.195561,-9.545115,-53.830729,-50.850394,-9.910429,-53.453128,-47.201305,-9.951048,-53.440632,-45.599038,-9.733322,-52.889269,-50.462427,-10.524334,-51.932631,-44.194040,-10.557813,-51.846314,-48.524064,-11.234898,-50.014954,-45.072567,-11.858656,-49.748033,-43.662128,-11.726410,-49.562832,-51.289797,-12.796258,-49.386296,-49.830486,-12.903124,-49.368930,-50.936184,-12.925064,-49.077005,-49.164943,-13.025889,-48.868987,-51.386007,-13.132025,-56.275985,-40.715847,-6.042243,-52.819284,-35.053221,-5.603435,-52.405627,-37.877770,-7.906778,-50.025525,-34.590507,-6.926130,-49.623643,-36.345583,-8.429508,-48.798918,-41.050133,-11.294693,-56.713049,-62.009296,5.082142,-53.284555,-62.840794,2.032293,-52.872815,-63.028284,2.469365,-52.613518,-62.956452,1.956634,-52.564737,-62.373559,-3.516719,-52.088700,-62.604602,-3.200541,-50.899149,-63.643028,2.820474,-50.095649,-63.813545,1.314701,-49.734005,-63.803371,1.161827,-49.120307,-63.779786,-0.966597,-48.719636,-64.372711,2.650876,-58.564808,-60.750669,-0.239909,-58.323618,-60.237009,-3.828574,-57.737698,-61.278007,0.818577,-57.471128,-61.511986,2.380616,-55.696360,-61.963346,0.841656,-55.028208,-61.698115,-2.275448,-58.794334,-44.082208,-4.818255,-58.847297,-34.112349,4.707990,-58.493258,-33.501759,4.972815,-57.381171,-35.093935,-0.279624,-57.051113,-36.506226,-2.415998,-56.711630,-35.927504,-2.364748,-56.556353,-32.222165,2.978104,-54.678399,-32.666182,-1.488816,-52.986345,-31.511077,-1.651274,-52.394114,-31.744976,-2.614495,-51.287703,-32.629165,-4.516562,-49.864953,-30.686701,-3.125516,-49.128833,-30.966508,-3.912084};
			return value;
		}
		private double[] getCoordinate_9_21_point_6()
		{
			double[] value = {-54.698652,-29.295556,4.768638,-54.642074,-24.549782,4.962528,-53.982116,-27.124069,3.753829,-53.897733,-29.736172,3.420975,-53.088749,-30.048723,1.824872,-53.033240,-29.688187,2.450959,-52.881001,-23.408433,3.553265,-52.503157,-22.250844,4.395576,-51.957596,-28.020156,1.844486,-51.530996,-29.928963,0.462842,-51.249913,-29.857113,0.360664,-51.158639,-23.167007,1.912060,-51.081481,-29.904177,-0.115521,-50.846904,-24.615165,0.624941,-50.531006,-26.275640,0.157791,-49.998155,-24.006066,0.112185,-49.953510,-21.253799,3.450239,-49.683895,-23.084926,0.712824,-48.711973,-28.848699,-0.725287,-56.776518,-62.305586,13.251128,-55.146236,-62.624003,7.755243,-53.170030,-63.172872,7.132389,-52.864897,-63.557221,13.576766,-52.217299,-63.696943,9.973446,-52.123086,-63.769148,11.715608,-51.822148,-63.675045,9.271522,-51.067845,-63.825519,7.492044,-49.619773,-64.428571,8.539524,-49.549053,-64.335388,6.475855,-58.685316,-61.424259,6.891843,-58.493245,-61.712060,13.880515,-58.024735,-61.793392,13.790992,-58.004091,-61.823433,11.614548,-57.499224,-61.796397,5.223857,-57.428564,-31.126092,7.693008,-57.076611,-31.408124,6.486714,-58.796182,-27.042961,11.037157,-58.592880,-26.513585,10.838425,-57.954486,-23.292106,14.585479,-57.927456,-30.481920,9.042913,-57.631758,-26.226259,8.814514,-57.622410,-25.014843,9.649280,-56.745765,-22.486160,14.850943,-56.211184,-23.890981,7.947086,-56.104590,-22.201113,14.006820,-56.091264,-21.880167,11.872841,-56.026353,-30.242732,6.030676,-56.019494,-21.820542,12.240381,-55.719864,-21.760233,12.666226,-55.263661,-23.180612,7.302847,-54.645726,-21.393577,11.534178,-54.613755,-21.276467,10.809700,-54.456978,-22.920472,6.248904,-54.277440,-22.887865,14.912085,-54.260602,-23.140448,15.348487,-54.038213,-21.347739,8.600404,-53.705073,-21.262471,8.181650,-53.423464,-20.997687,8.788272,-53.103038,-20.958554,8.157889,-52.884474,-21.384796,11.076670,-52.575850,-20.911272,7.448424,-52.511053,-20.900451,7.377555,-52.305282,-21.192432,6.139865,-52.182891,-20.783324,7.846095,-52.165923,-21.228846,5.807540,-52.142018,-22.064529,12.491097,-52.050692,-20.831331,7.010295,-51.755257,-21.797528,13.894672,-51.694089,-21.972715,13.031559,-51.342656,-20.172592,14.430318,-50.911012,-21.717361,11.171481,-50.846316,-21.651366,10.754560,-50.771876,-21.690198,11.337368,-50.663679,-21.642702,11.015092,-50.465870,-21.477858,11.634836,-50.337645,-20.241995,12.351009,-49.455621,-20.887265,6.203757,-48.596716,-21.012543,5.579931,-48.583998,-20.927278,9.857670,-50.123736,-19.244469,14.123859,-48.729117,-18.683966,14.465351,-48.570102,-18.885437,12.122891,-57.647293,-62.017565,23.680802,-57.486584,-62.008925,25.220071,-57.400254,-62.172884,15.809031,-57.298010,-62.149632,21.793133,-57.222414,-62.248648,16.038812,-57.037946,-62.189639,22.761369,-56.759264,-62.354751,23.064973,-56.456331,-62.458870,23.461436,-56.362616,-62.476989,20.302906,-56.315245,-62.499724,22.803227,-56.301991,-62.494453,18.742585,-56.288534,-62.585051,21.027657,-55.991172,-62.649097,18.858212,-55.857924,-62.670154,22.751632,-55.418522,-62.799557,22.011296,-55.245947,-62.847819,24.538156,-54.574890,-63.122581,21.522574,-54.419338,-63.011747,25.367434};
			return value;
		}
		private double[] getCoordinate_9_21_point_7()
		{
			double[] value = {-53.696568,-63.392986,16.843106,-53.218047,-63.539745,18.849931,-53.207914,-63.612055,16.989360,-53.116644,-63.663568,22.920286,-51.947747,-63.871351,25.142628,-51.116403,-64.188375,21.008170,-50.914337,-64.314276,24.887732,-50.703819,-64.305279,19.332288,-50.688546,-64.451139,20.470674,-50.672313,-64.286152,25.737809,-50.188874,-64.692776,22.944104,-49.253754,-64.927574,20.620281,-48.915402,-65.089333,21.133476,-48.634364,-65.129366,19.306659,-48.531883,-65.101792,15.822938,-58.336447,-61.730554,18.823595,-57.808666,-61.927107,19.945277,-58.629396,-26.593627,24.227622,-58.598907,-25.195748,20.750997,-58.524427,-24.643818,19.494882,-58.238039,-24.636235,19.718317,-58.237883,-24.823354,20.164679,-57.962458,-26.115782,23.160553,-57.708351,-26.239493,23.462646,-57.419566,-24.954073,20.424483,-57.416273,-25.842235,22.271854,-57.398883,-22.899688,15.732628,-56.998612,-23.616649,17.657133,-56.954042,-23.540177,17.463316,-56.801313,-23.150729,16.553917,-56.662568,-23.026368,16.191355,-55.439769,-25.818123,21.250117,-55.360089,-25.655654,20.859683,-54.850697,-25.887041,21.469073,-54.736236,-23.345851,16.037101,-54.635059,-25.793169,21.428857,-54.611009,-26.651106,23.734618,-54.179575,-22.616287,24.758285,-54.154835,-23.599096,16.435383,-54.050818,-22.240119,23.371245,-54.003194,-24.022581,17.847132,-53.994734,-25.205620,21.203353,-53.916060,-26.528883,24.955992,-53.895487,-22.238854,21.135385,-53.853174,-23.850291,17.497954,-53.822181,-21.839111,22.137383,-53.701126,-25.985546,25.725250,-53.613033,-23.688513,20.120307,-53.003013,-20.948102,21.040512,-52.986348,-20.958922,21.923838,-52.985164,-22.181043,17.544604,-52.820318,-20.780421,19.602647,-52.741381,-20.785543,18.704687,-52.595869,-20.799040,17.616670,-52.338848,-21.918994,15.716920,-52.234566,-20.847777,23.725393,-51.191524,-20.517940,25.564833,-51.103573,-19.653166,15.843432,-51.078479,-15.107823,25.534402,-51.029599,-20.100249,22.093727,-51.025841,-15.162315,25.045774,-51.023435,-15.269379,24.966147,-50.727260,-17.905537,25.301426,-50.659633,-18.066832,24.734700,-50.637656,-19.681776,21.020258,-50.615974,-14.390472,24.337584,-50.595324,-19.864255,23.563283,-50.386275,-19.548448,21.941129,-50.310902,-19.401154,23.845295,-50.259450,-19.389711,22.000688,-50.203570,-16.216550,20.595603,-49.878519,-19.021288,19.523703,-49.713275,-17.966427,19.861914,-49.620576,-15.373108,19.343311,-49.491113,-18.919902,15.901082,-49.449155,-18.639417,18.157191,-49.417183,-18.444360,18.704205,-49.349756,-13.624976,22.945988,-49.192114,-17.884440,18.166989,-48.935006,-18.376609,16.609445,-48.870690,-17.518514,17.054120,-48.847480,-12.771981,25.233000,-56.532494,-62.222890,25.991244,-56.291632,-62.286637,28.462253,-56.212119,-61.982653,31.509282,-55.963276,-62.079763,31.092390,-55.458473,-62.083269,33.520216,-54.382111,-62.893100,29.248832,-54.288900,-62.365111,34.650769,-54.261845,-63.122482,26.929675,-54.218721,-63.002126,28.110037,-54.061946,-63.112600,28.968348,-54.033297,-62.471243,35.435535,-54.001441,-63.195304,27.207842,-53.908750,-62.632567,34.318592,-53.817504,-63.136324,28.664523,-53.529351,-63.187985,29.461548,-53.084416,-63.383212,30.187099,-53.051106,-63.337491,29.766893,-52.893509,-63.468403,30.287709};
			return value;
		}
		private double[] getCoordinate_9_21_point_8()
		{
			double[] value = {-52.830957,-63.577227,26.569344,-52.625066,-63.561781,30.330706,-52.576282,-63.609029,28.773210,-52.537726,-63.650767,26.755418,-52.136114,-63.693729,30.642439,-52.135249,-63.363573,34.705755,-52.110598,-63.963910,26.127176,-52.091744,-63.632781,29.783517,-52.032130,-63.885602,28.591831,-51.273088,-63.782513,32.862315,-50.960090,-63.927375,32.825186,-50.101282,-64.351312,33.652475,-50.023731,-64.360618,30.924399,-49.913421,-64.331292,34.169904,-49.733844,-64.534576,33.838522,-48.884127,-64.857339,35.993751,-48.539430,-65.072204,30.041842,-48.496953,-65.081130,34.134614,-58.354559,-61.014553,30.785386,-57.892723,-61.700592,26.150732,-57.700480,-61.519028,29.256515,-57.559342,-61.640984,29.617449,-57.406812,-61.422122,31.100901,-57.159164,-61.924904,27.575782,-56.163279,-61.619264,34.140294,-55.763066,-61.951865,33.737356,-58.539532,-27.273107,26.582635,-58.303991,-28.359680,33.547106,-57.431305,-28.392221,31.477555,-57.008684,-28.740304,35.576848,-55.710211,-28.799221,32.272771,-54.209114,-22.726002,26.576448,-54.186935,-22.701154,27.662329,-54.139922,-23.161623,29.314053,-54.120314,-22.601926,28.015891,-54.058756,-27.750690,28.437674,-54.048391,-22.793701,29.733718,-53.907069,-27.999207,29.829052,-53.854540,-27.113519,27.515446,-53.816385,-27.979712,30.200832,-53.722716,-21.931251,26.412663,-53.720520,-26.299022,26.117011,-53.719478,-27.636956,29.528020,-53.689186,-27.382124,29.017532,-53.662263,-22.641944,31.562331,-53.406810,-26.505389,31.516251,-53.328392,-28.424077,33.720606,-53.310877,-23.125891,34.064215,-53.215822,-27.538604,32.419687,-53.153555,-23.251201,35.036326,-52.979681,-27.081626,34.376395,-52.894168,-22.202511,32.967950,-52.891938,-23.211947,35.953875,-52.819364,-27.552377,35.102742,-52.494390,-22.148276,34.088598,-51.877906,-21.215481,29.131775,-51.862528,-21.329133,30.796568,-51.616875,-21.133234,29.869881,-51.202283,-20.936629,31.633984,-51.124344,-20.848446,31.228931,-51.062168,-20.698100,29.454703,-50.990792,-20.621930,30.016901,-50.875694,-20.427062,28.618701,-50.719837,-20.231666,26.829803,-50.615799,-21.036691,34.894711,-50.600960,-20.457293,33.800925,-51.304380,-14.213366,30.446879,-51.235993,-14.157603,29.125269,-51.146409,-14.875379,31.958580,-51.009223,-13.926307,27.856028,-50.994222,-13.725283,32.959701,-50.988379,-17.416674,30.922078,-50.952210,-15.031846,33.699483,-50.842956,-19.135322,28.439484,-50.834684,-19.899832,29.469140,-50.830437,-19.707792,31.625383,-50.818626,-13.281028,33.051206,-50.727105,-13.104634,31.838991,-50.722274,-13.563168,27.964123,-50.719393,-19.948947,28.145177,-50.694363,-18.023459,33.051983,-50.694135,-18.833755,32.478702,-50.670396,-18.238060,32.980174,-50.630142,-13.084940,30.537394,-50.551975,-19.699410,26.242487,-50.537991,-13.085762,29.799618,-50.466766,-13.325182,28.193813,-50.411275,-17.917889,35.250454,-50.215318,-12.747390,30.394153,-50.176407,-12.656271,36.078374,-50.135000,-12.584763,36.030940,-49.540112,-12.047737,34.698812,-48.908142,-11.723344,35.601839,-48.896701,-12.231649,28.951703,-48.834346,-12.368006,28.045054,-49.050634,-136.116089,45.820412,-48.609464,-135.814127,45.091718,-49.571937,-133.704178,46.034900,-49.145105,-132.311420,46.383835,-49.113424,-132.779990,45.811151};
			return value;
		}
		private double[] getCoordinate_9_21_point_9()
		{
			double[] value = {-48.883856,-132.584911,45.803704,-48.751488,-133.117488,45.190450,-49.551293,-117.806523,45.593481,-51.623111,-106.337648,46.124643,-50.713638,-110.623761,45.710354,-50.271393,-111.777833,45.379543,-52.592957,-97.145003,46.080863,-52.388940,-101.553117,46.370900,-52.052360,-103.249937,46.167332,-51.918592,-99.844870,45.526073,-51.892989,-100.927485,45.615782,-51.801123,-100.005005,45.374149,-51.713115,-102.714880,45.621156,-51.148843,-95.125656,43.884659,-50.905946,-101.654305,44.369588,-49.862507,-94.620620,43.004743,-49.807203,-94.229296,43.646071,-49.109613,-97.352276,41.375786,-48.736702,-101.429238,41.367080,-48.469379,-96.013042,40.392779,-48.443751,-97.706414,40.498061,-48.593554,-93.200439,44.661387,-48.571635,-92.553088,45.800160,-52.942950,-61.996435,41.665333,-52.856581,-62.715848,37.867911,-52.347157,-62.771211,39.198654,-51.025104,-62.745584,43.494745,-50.711297,-62.600439,44.066462,-50.469701,-62.962168,43.608096,-50.096223,-63.750791,39.913910,-49.842052,-64.281137,37.336545,-49.715910,-62.509682,46.348925,-49.315985,-62.709372,46.423257,-49.078165,-64.317044,39.684483,-49.029531,-63.994091,42.649256,-49.022815,-63.983796,42.536739,-48.937757,-64.041417,42.509597,-48.767696,-64.343194,42.074186,-48.708600,-64.621066,39.368767,-48.669933,-64.880986,38.770128,-58.853703,-58.812021,40.669627,-58.813509,-58.867173,40.594166,-58.527889,-59.529811,39.395414,-57.888672,-59.812794,40.043107,-57.635394,-59.646450,41.269028,-57.165110,-59.554982,42.308006,-56.903688,-59.255999,43.470525,-55.872940,-61.298934,37.732996,-55.853748,-59.515900,44.885428,-55.810158,-60.299352,42.593734,-55.771188,-61.290681,38.155027,-54.936991,-59.957131,44.988869,-54.595755,-61.746671,38.835855,-54.459781,-60.561779,43.843666,-54.325313,-60.794808,43.514425,-54.076616,-61.303236,42.238835,-53.857506,-61.151093,43.376162,-53.659521,-61.512807,42.517918,-53.219194,-60.910198,45.157217,-52.971284,-61.420500,43.883876,-52.792289,-60.945004,46.135810,-52.438771,-61.168015,46.018766,-51.690398,-61.314755,46.670360,-58.775383,-44.519865,41.949674,-58.298154,-42.717505,40.144925,-58.297743,-42.546088,40.018848,-57.737732,-42.092768,41.787427,-56.949724,-41.629913,44.288032,-58.830093,-38.187514,40.498062,-58.742361,-33.411294,43.131770,-58.671293,-32.869370,43.428146,-58.448150,-31.166242,43.349849,-58.242457,-33.254012,44.364424,-57.790619,-34.541335,45.230410,-57.726398,-38.912175,43.290886,-57.332511,-34.127809,46.237399,-57.310780,-32.174706,46.630714,-56.982138,-38.485057,45.610857,-58.730747,-28.798844,36.467052,-58.094693,-29.429811,41.459446,-58.038811,-29.673284,42.251272,-57.781945,-28.733801,37.353924,-57.569289,-30.577364,44.976221,-57.388643,-28.909161,40.158625,-56.797378,-29.005266,42.226751,-56.636549,-29.285193,44.402137,-56.571009,-29.531145,45.484459,-56.560026,-29.034485,42.677612,-56.077578,-29.009790,44.150159,-55.789280,-29.043639,45.183023,-55.770948,-28.997121,42.519708,-55.629429,-29.124447,46.517060,-54.481415,-28.831576,44.018128,-53.959406,-29.175681,38.977970,-53.904169,-29.211943,37.110116,-53.516433,-29.155761,39.086844,-53.231104,-28.636773,44.633153,-52.853318,-28.875433,42.446412,-52.790202,-28.961399,38.916883,-52.744957,-28.704184,44.357482};
			return value;
		}
		private double[] getCoordinate_9_21_point_10()
		{
			double[] value = {-52.688806,-28.988143,40.472125,-52.560896,-27.859856,36.667142,-52.549538,-23.352280,37.398152,-52.435980,-28.310982,37.662404,-52.397665,-28.784898,43.129006,-52.372041,-27.522659,37.565533,-52.342095,-24.485718,38.886609,-52.338986,-28.616660,38.869757,-51.952367,-23.946743,39.913764,-51.750693,-24.500525,40.817470,-51.635639,-28.602091,42.482498,-51.563896,-28.300412,41.360579,-51.552565,-23.328176,40.013417,-51.450696,-27.994968,41.437401,-51.145496,-23.384441,41.250360,-50.964019,-24.230179,43.158214,-50.757933,-28.469017,46.202729,-50.671709,-24.372007,44.134680,-50.604889,-23.442611,42.953116,-50.490351,-28.451380,46.442654,-50.442035,-28.449997,46.629105,-49.991591,-21.620634,38.424864,-48.897793,-22.304405,43.768832,-48.646426,-21.120472,41.427565,-48.558793,-20.947438,41.613305,-50.289753,-13.024677,36.562661,-50.206800,-14.874211,37.718888,-50.069530,-18.815023,36.488415,-49.997524,-14.226748,38.658072,-49.735994,-13.132777,39.414627,-49.731764,-12.961866,39.287534,-49.731736,-14.477996,39.619418,-49.694589,-16.351131,39.197231,-49.609638,-12.065657,36.628812,-49.597325,-12.894929,39.738066,-49.373480,-11.912496,37.038065,-49.176346,-18.071652,40.413169,-49.013347,-17.240231,41.236913,-48.977535,-13.100566,42.188910,-48.765345,-11.722418,40.383966,-48.464418,-11.492997,36.852040,-51.894768,-135.427350,49.153289,-50.975555,-135.510096,48.830562,-50.829220,-135.617923,47.796351,-56.044935,-133.525280,55.261245,-55.997935,-134.313798,54.608915,-55.994925,-133.659308,54.348222,-55.235466,-134.574892,53.303002,-55.181476,-128.855116,55.262011,-55.077884,-125.470733,54.545031,-55.037614,-129.151143,55.562640,-54.926210,-131.587166,52.481906,-54.659422,-126.030772,55.328498,-54.588307,-126.906669,53.490822,-54.426907,-133.928361,56.897990,-54.214244,-130.402938,52.990669,-54.055848,-131.982226,51.378996,-53.994968,-134.748309,52.533868,-53.694927,-130.619241,52.265131,-53.055611,-131.339041,50.950554,-52.773399,-128.754078,51.395910,-52.257201,-133.933826,49.278498,-52.206670,-134.675596,49.338301,-51.552641,-131.959492,48.898014,-50.640228,-133.744944,47.303928,-50.603163,-132.716621,47.362789,-49.919528,-131.555149,47.911633,-49.793422,-132.431410,46.795331,-49.710290,-125.930064,47.310769,-49.642896,-125.825651,47.206936,-49.497017,-130.512018,47.637293,-49.201717,-131.627844,47.123984,-55.056356,-123.849713,54.229759,-54.558831,-118.342600,51.835023,-54.551002,-119.835938,54.091065,-54.287358,-117.053286,51.219073,-54.023199,-120.275081,54.763019,-53.659967,-115.527463,50.143127,-53.304997,-116.818400,54.705869,-53.046148,-115.759806,54.733206,-52.934472,-122.014438,50.508782,-49.764797,-123.465702,46.934161,-54.909706,-113.306890,51.764059,-54.779722,-108.412241,50.796238,-54.770653,-110.984019,51.694620,-54.660741,-113.118272,51.046773,-54.484354,-111.527264,52.300714,-54.042670,-104.943408,49.061635,-53.925139,-112.171316,53.057744,-53.818026,-104.209491,51.222677,-53.530985,-109.295485,52.862655,-52.199354,-104.443816,53.014121,-51.791396,-104.382884,53.282004,-51.518142,-106.487533,54.181609,-49.678711,-104.099983,55.431642,-49.443248,-107.026286,56.351612,-48.991218,-108.389239,57.122330,-54.305315,-103.021855,50.318720,-54.202517,-100.491613,49.714106,-54.097607,-103.526014,50.731635};
			return value;
		}
		private double[] getCoordinate_9_21_point_11()
		{
			double[] value = {-54.084949,-101.272233,50.129191,-54.046023,-99.176844,49.496816,-53.879920,-96.060723,47.857569,-53.833997,-96.568362,49.102753,-53.807824,-94.922497,48.526869,-53.591868,-94.177284,47.603862,-53.395753,-94.994062,49.176965,-53.174170,-100.818366,51.010054,-52.402469,-98.220471,51.069031,-51.570501,-94.630932,50.982907,-51.008941,-99.645116,52.870610,-50.774714,-95.053169,51.896253,-50.206231,-93.611151,51.936537,-50.152551,-93.428975,51.861855,-49.951398,-93.420099,52.067429,-49.910645,-101.178112,54.398990,-49.886337,-94.310124,52.528494,-51.852986,-93.023838,47.545843,-50.953427,-93.050032,50.348246,-50.143562,-92.358038,49.601908,-49.510405,-92.992133,52.061249,-48.966134,-92.988078,52.687366,-48.770367,-92.250897,51.547917,-48.464880,-92.868073,53.103039,-48.429615,-93.271750,53.513701,-50.173964,-62.092585,47.312949,-48.847174,-62.339125,48.147635,-48.500872,-63.149217,46.991382,-58.204758,-54.708538,49.586967,-58.148388,-56.844813,47.270815,-57.891747,-57.168410,47.095014,-57.753271,-56.615040,48.049411,-57.154705,-54.290458,51.774286,-57.055006,-52.313895,51.732941,-56.999546,-57.174882,48.461118,-56.660288,-52.422415,52.537469,-56.522033,-55.412698,52.068100,-55.871152,-56.942009,50.856248,-55.553336,-58.755130,47.344151,-55.476178,-56.215557,52.496004,-55.078175,-58.930207,47.697435,-54.784253,-58.738038,48.899096,-54.509975,-56.967127,52.725812,-54.495781,-53.581369,56.359777,-54.317776,-58.916753,49.150180,-54.170434,-57.617661,52.069985,-54.069436,-55.076832,56.191954,-53.786945,-56.972207,53.791274,-53.501323,-58.854059,50.687578,-53.326428,-59.619673,48.956118,-52.932815,-57.338490,54.432115,-52.523853,-60.629437,47.113860,-51.905138,-61.023497,47.023427,-51.158172,-61.221073,48.101150,-51.157247,-59.479408,52.368302,-51.005261,-57.423869,56.573623,-50.894093,-59.610089,52.644796,-50.407307,-58.614296,55.134229,-49.978413,-59.628654,53.475192,-49.614164,-59.558077,54.345116,-49.400568,-61.394738,49.895397,-58.567079,-49.095199,46.885217,-58.325815,-48.309765,46.940804,-57.663501,-48.839807,48.774501,-57.485191,-49.815069,49.597078,-57.395397,-49.527767,49.595139,-57.313565,-47.188885,48.431752,-55.811321,-43.082740,47.880564,-55.665292,-44.825084,50.098892,-55.412787,-48.814729,53.455520,-55.337322,-50.608597,54.505735,-55.299156,-45.372311,51.337487,-55.247223,-48.177202,53.322972,-54.868096,-51.516482,55.658028,-54.635925,-44.787341,52.307804,-54.334743,-49.868341,56.061772,-53.972965,-48.861373,56.240551,-56.638871,-32.860352,48.242252,-56.281188,-33.595704,48.853932,-55.765037,-39.577157,48.128323,-55.577298,-35.756588,49.586294,-53.937139,-38.248058,52.003285,-53.885792,-34.431095,52.795558,-53.821955,-34.524429,52.894388,-53.354719,-33.325888,53.813981,-53.244112,-37.944787,53.158006,-53.080763,-35.070895,54.148645,-52.971427,-38.550495,53.681749,-52.741658,-32.750155,54.656976,-52.148686,-39.252551,55.036378,-51.322627,-39.869269,56.675546,-56.233970,-30.435290,47.739797,-54.922892,-29.558792,49.120926,-54.726750,-30.296854,50.589173,-54.672095,-29.121860,48.842113,-54.612883,-28.885172,47.878293,-54.314901,-30.211112,51.346605,-54.058700,-29.048469,49.689046,-53.718740,-28.945474,50.136641,-53.517356,-29.300196,51.654136};
			return value;
		}
		private double[] getCoordinate_9_21_point_12()
		{
			double[] value = {-53.087969,-29.062127,52.006240,-52.984069,-28.854200,51.316645,-52.170175,-28.411189,48.614606,-51.768150,-28.788739,54.480223,-51.511058,-28.555587,54.312143,-51.025430,-28.599809,55.586405,-50.395344,-28.506311,47.515128,-49.777738,-27.996804,56.336539,-49.639002,-27.966645,56.107726,-49.554729,-25.168943,47.285185,-49.097651,-27.683955,48.198636,-48.783956,-28.046264,49.198660,-48.619370,-28.560462,50.921530,-48.449607,-28.551338,51.179802,-48.434073,-27.188682,49.575343,-54.098319,-133.631861,57.586439,-53.888236,-133.298876,57.721839,-52.368925,-132.203568,59.011817,-52.177456,-133.584421,59.054407,-51.697948,-133.422597,59.991402,-51.316122,-133.360878,60.375417,-49.943299,-133.147357,61.710782,-49.622245,-132.752794,62.042037,-49.156481,-133.102177,62.060142,-48.995614,-127.978132,61.554831,-49.289621,-122.337012,59.949129,-50.048479,-113.206110,57.165627,-52.415045,-55.987200,57.368450,-51.323496,-56.670015,57.677782,-51.027520,-56.967608,57.582214,-50.926932,-55.993511,59.174063,-50.615245,-54.253605,61.454629,-50.037143,-56.316080,59.563300,-49.901588,-55.873947,60.409233,-49.649896,-55.219015,61.596148,-48.682924,-53.203040,64.404883,-48.502882,-57.284427,59.693453,-52.215936,-45.241277,57.677411,-52.182816,-45.555392,58.012598,-51.287982,-43.020388,58.175404,-51.201639,-41.857217,57.673908,-51.015277,-49.710620,61.672732,-50.115566,-43.781758,60.855018,-50.101782,-44.511321,61.159146,-49.957477,-43.015009,60.891413,-49.904781,-46.945896,62.683107,-49.805359,-42.648397,60.897381,-49.578230,-42.796314,61.352824,-49.406390,-41.114944,61.048192,-49.285798,-41.734750,61.506812,-48.713131,-48.905399,64.596444,-48.678639,-44.568306,63.664209,-48.585029,-46.783121,64.673847,-49.503452,-32.699715,59.584831,-48.464566,-33.313547,60.989905,-50.156765,-28.572868,57.252167,-49.595286,-28.459895,58.145509,-49.483013,-30.136759,59.320978,-41.913567,-62.964165,-15.663407,-40.523177,-63.314391,-16.249246,-38.894806,-64.626461,-16.202129,-43.306669,-53.072895,-15.582565,-41.607316,-56.661565,-16.208398,-41.339704,-60.936165,-16.223788,-40.138415,-52.082937,-16.326630,-39.506093,-60.307190,-16.889144,-40.918915,-51.427403,-16.141319,-40.486945,-49.425237,-15.839951,-40.399640,-49.044975,-15.770261,-39.325062,-49.793371,-16.073444,-48.092832,-62.272833,-11.573291,-47.018484,-63.063699,-11.221266,-46.583722,-62.956374,-12.139269,-46.419319,-63.497001,-10.393959,-46.135497,-64.189596,-5.191135,-44.934494,-63.450655,-12.974405,-44.822067,-62.952785,-13.700938,-44.521869,-64.751362,-5.660502,-44.143596,-63.328296,-13.924771,-43.769086,-63.290570,-14.238573,-42.918647,-64.389864,-12.539934,-42.773035,-64.638170,-11.404508,-41.358705,-64.115267,-15.259599,-41.102778,-63.995588,-15.535738,-40.603537,-65.852739,-7.581214,-39.772262,-64.672506,-15.281618,-38.403294,-66.828933,-5.609340,-48.346270,-56.735381,-13.094720,-47.670721,-54.332450,-13.733217,-46.000023,-57.471743,-14.359457,-45.741792,-60.753445,-14.044695,-45.473456,-61.517390,-13.960021,-44.556487,-56.386026,-15.116735,-44.125131,-60.059978,-15.122036,-48.413467,-46.775106,-13.050986,-47.051104,-46.747657,-13.625472,-45.687352,-45.784978,-13.863049,-45.616117,-49.867956,-14.572552,-44.857733,-41.205626,-12.508662,-43.221548,-41.481453,-12.926552};
			return value;
		}
		private double[] getCoordinate_9_21_point_13()
		{
			double[] value = {-42.462964,-43.943957,-14.011021,-42.051542,-42.131572,-13.297358,-41.561683,-42.497590,-13.517738,-41.377981,-48.204555,-15.448389,-40.251087,-44.293028,-14.390664,-39.982541,-46.852909,-15.226822,-39.474715,-41.431445,-13.140036,-38.787918,-45.408854,-14.794007,-46.640536,-32.988907,-6.951987,-46.480397,-33.985441,-7.784189,-45.559870,-31.111874,-5.169773,-44.346900,-32.189684,-6.648882,-43.058246,-33.743560,-8.333388,-41.671839,-38.915442,-11.844919,-40.748516,-30.667627,-5.732947,-40.738397,-37.040228,-10.761939,-40.738014,-38.124286,-11.383288,-40.474545,-38.889322,-11.901924,-40.134635,-41.007303,-12.928840,-40.098889,-38.842002,-11.867938,-39.367453,-36.654268,-10.421235,-38.876740,-31.400108,-6.753659,-38.697944,-32.535978,-7.215364,-38.666274,-33.036669,-7.545032,-42.365507,-27.933165,-5.409637,-41.838661,-26.295249,-5.597712,-41.078574,-25.740045,-5.597450,-40.981352,-25.159258,-5.238675,-40.902939,-30.590441,-5.636299,-40.887091,-27.310421,-6.214491,-40.810514,-25.524018,-5.517993,-40.715149,-26.083059,-5.865569,-40.121109,-28.865026,-6.646677,-39.325126,-30.150567,-6.676682,-39.208915,-26.186778,-6.049082,-38.912644,-26.695284,-6.432112,-38.774651,-29.444413,-7.323799,-38.103680,-29.830162,-7.648121,-48.328879,-64.016780,-1.316445,-47.988522,-64.288168,-0.033485,-47.826790,-64.217097,-1.330446,-47.604688,-64.967485,4.722306,-46.113523,-65.461785,4.274906,-45.830019,-65.611934,4.703715,-44.791928,-65.911837,3.347803,-43.509784,-66.161372,1.643894,-41.992750,-65.855352,-3.979128,-40.790796,-66.820209,-0.342731,-40.754506,-66.115144,-4.946326,-39.193220,-67.462909,0.331668,-48.390856,-22.815072,-0.111002,-48.293769,-21.970210,1.074024,-48.054659,-21.095899,4.033646,-48.039356,-28.949430,-1.334944,-47.847504,-29.639403,-2.241617,-47.831255,-29.863313,-2.661576,-47.772021,-21.116971,3.736688,-47.671626,-30.271420,-3.452337,-47.493082,-22.307121,0.018368,-46.832325,-21.382059,4.582877,-46.816814,-26.267185,-2.870315,-46.740414,-21.391529,2.535109,-46.654596,-23.286200,-1.676978,-45.782949,-22.904622,-1.636149,-45.599416,-22.864548,-1.651489,-45.594650,-24.736974,-3.319761,-45.591361,-25.093967,-3.489003,-45.425027,-22.728669,-1.493420,-45.282816,-21.667690,1.576748,-44.993614,-21.969222,0.386221,-44.808652,-22.819379,-1.824549,-44.638813,-27.766759,-3.753813,-44.616938,-27.006416,-4.190678,-44.565481,-22.078282,4.753360,-44.505540,-24.164096,-3.546301,-44.361340,-24.022886,-3.475172,-44.289596,-21.842195,2.225407,-44.281903,-22.053298,0.053978,-44.223175,-21.856394,2.014835,-44.145256,-28.963897,-3.668626,-44.087294,-30.483990,-4.457550,-43.624766,-23.802086,-3.479799,-43.366482,-28.508160,-4.309707,-43.150634,-25.019960,-4.589989,-42.930276,-22.335314,2.805889,-42.926528,-23.883189,-3.731471,-42.806170,-25.700355,-5.018396,-42.801184,-29.960684,-4.520717,-42.717106,-24.259411,-4.177156,-42.627731,-28.642371,-4.792878,-42.583916,-22.322972,0.333995,-42.379178,-21.826508,4.561891,-41.732548,-22.530520,0.991031,-41.654217,-22.490562,0.162946,-41.309634,-24.615946,-4.729425,-41.174968,-20.879859,4.515173,-40.420123,-22.409962,2.840145,-39.786513,-23.072238,1.627005,-39.509182,-23.484064,-2.082673,-39.441342,-22.505573,2.678741};
			return value;
		}
		private double[] getCoordinate_9_21_point_14()
		{
			double[] value = {-39.225002,-23.121274,1.736888,-38.762575,-20.291021,4.764815,-38.628154,-23.574191,-0.709376,-38.503902,-24.551538,-3.783822,-38.209446,-23.768890,-0.803625,-48.295006,-65.178907,14.594918,-47.346605,-65.193620,6.482927,-46.918532,-65.572163,10.707101,-46.856424,-65.731999,15.160678,-46.342628,-65.898656,12.556161,-45.628312,-65.754405,5.386870,-43.471395,-66.951584,10.814455,-41.298563,-67.770257,12.848459,-40.996824,-67.883956,13.119716,-40.664889,-68.072527,15.020411,-40.305033,-68.215777,13.759944,-39.435329,-68.489499,12.106651,-39.177176,-68.569344,13.350715,-38.720971,-68.829686,12.595534,-38.181379,-68.949724,11.059318,-38.087778,-69.118713,13.570049,-48.197884,-21.294794,6.463378,-48.081740,-21.439482,8.237950,-47.919469,-21.457263,8.408450,-47.403741,-20.186288,9.051261,-46.959597,-21.287014,8.358208,-46.720904,-21.654673,7.337473,-46.386826,-21.263381,7.985913,-46.212699,-20.420567,7.956510,-45.412623,-20.962830,7.281516,-44.747071,-21.302980,6.709895,-44.505170,-21.278655,6.533347,-43.109315,-20.285175,5.959150,-47.920868,-18.430415,14.053460,-47.366004,-18.564347,12.099851,-46.901352,-17.654460,13.211735,-46.692011,-17.944773,12.729041,-46.378503,-16.061264,13.584800,-46.271507,-15.414660,14.152796,-45.638277,-18.418836,10.838319,-45.326018,-15.657979,12.959870,-45.072641,-14.053170,15.489331,-44.953249,-16.574048,11.547844,-44.900950,-17.619254,10.815256,-44.824432,-19.786765,7.460555,-44.550536,-19.926921,7.151742,-44.460114,-13.864111,15.381616,-43.725745,-15.129386,12.522192,-43.114129,-16.489954,10.258049,-43.059431,-13.485538,14.300434,-42.660186,-19.571267,6.666444,-42.533425,-18.235356,8.302246,-42.321842,-19.055330,7.468287,-41.992134,-11.168171,14.150354,-41.602118,-12.973872,12.715472,-41.570547,-12.201784,13.132873,-41.560882,-13.145881,12.597783,-41.282946,-17.753901,8.009541,-40.940743,-13.053120,12.073198,-40.890535,-15.210877,11.145023,-40.728249,-12.083668,12.640246,-40.696717,-17.958337,7.457721,-40.505048,-11.935662,12.655694,-40.446028,-19.280834,6.264183,-40.353008,-15.574698,10.499406,-40.097423,-15.792445,10.151892,-40.022164,-19.282288,6.037339,-39.765220,-10.855732,13.171656,-39.279267,-10.179510,14.527059,-39.200629,-13.947495,10.464815,-38.939860,-14.930589,9.790298,-38.769062,-10.986799,13.087331,-38.734010,-10.801087,14.137052,-38.476259,-11.611223,12.316990,-38.255139,-12.398758,11.447168,-38.125779,-16.151908,8.765640,-38.090051,-12.009207,11.968425,-40.365213,-9.390553,15.172400,-40.037256,-9.479259,15.244888,-38.270267,42.503347,15.113670,-38.245913,41.386250,15.277787,-40.458467,50.784248,15.236192,-39.993450,50.484991,14.480446,-39.836492,52.255140,12.003720,-39.614279,48.753480,14.290822,-39.464751,49.564134,11.552404,-39.358484,48.263981,13.993611,-39.294663,49.416091,9.760257,-39.194396,49.602547,11.967727,-39.191491,51.890749,10.345052,-39.136611,46.378739,14.664541,-39.112224,50.924530,13.613189,-39.043879,45.469243,14.249997,-38.932417,45.430605,15.549007,-38.869025,44.800029,15.387449,-38.842302,44.535571,14.287508,-38.839953,46.014276,13.257503,-38.824301,47.154511,10.160187,-38.788840,44.542988,15.531989,-38.660123,49.363873,13.146648};
			return value;
		}
		private double[] getCoordinate_9_21_point_15()
		{
			double[] value = {-38.641102,52.166936,8.665525,-38.583411,46.885261,10.472428,-38.578817,47.467666,13.224420,-38.528027,51.790241,8.211065,-38.499509,48.648685,12.645398,-38.238219,44.987923,12.387774,-38.215896,43.502947,13.107043,-38.205557,47.110074,11.394911,-38.071171,46.822633,8.440315,-40.091115,57.159218,14.641001,-40.021443,54.684660,14.454299,-39.767085,54.270305,11.740440,-39.691983,59.310112,15.301271,-39.584035,58.162943,13.982045,-39.540350,56.481541,12.253946,-39.530231,55.622746,14.000867,-39.385802,57.039056,12.723327,-39.278695,53.936612,10.844591,-39.266323,56.879924,11.499942,-39.223235,56.122248,11.246247,-39.209442,59.173518,13.590388,-38.968372,56.632819,11.154743,-38.909200,54.601030,10.654585,-38.898304,59.923310,13.533508,-38.836822,60.833169,14.430165,-38.699185,54.927255,9.230830,-38.649087,55.116245,9.133358,-38.628889,55.424904,9.694190,-38.517422,56.316233,9.959718,-38.403237,52.997227,8.273465,-38.240995,62.616933,15.516156,-38.116535,57.288164,8.817712,-38.098477,58.969151,10.429296,-38.060767,61.961075,13.454025,-48.304034,-65.291478,25.023792,-48.012008,-65.311438,21.995606,-47.611590,-65.496136,22.632603,-47.393744,-65.500340,20.383589,-47.343937,-65.529438,18.400762,-46.933766,-65.705077,19.038056,-46.758951,-65.886233,19.518392,-46.383719,-66.034362,17.840908,-46.265413,-65.992687,25.361377,-45.503906,-66.386648,19.629179,-45.380531,-66.477050,19.781872,-45.002073,-66.678088,21.618838,-44.538230,-66.764040,18.143178,-44.339007,-66.839715,24.009936,-44.176193,-67.047197,22.895903,-44.081548,-66.983615,18.601097,-43.922159,-67.050339,18.453211,-43.832586,-66.988649,17.672746,-43.227155,-67.444138,23.211877,-42.546613,-67.430823,15.673693,-42.312484,-67.703523,25.785922,-41.162275,-68.273702,22.885821,-40.897983,-68.142176,16.950698,-40.690135,-68.307385,17.292933,-40.566859,-68.536200,24.187428,-40.508589,-68.360049,20.256203,-40.445759,-68.282779,16.702830,-40.406314,-68.475680,21.307903,-40.319616,-68.435400,20.018652,-40.172325,-68.479780,19.194418,-39.719491,-68.831937,23.150679,-39.688391,-68.990749,23.899563,-39.176402,-68.869217,16.476467,-48.386662,-15.606677,16.776627,-47.785579,-14.366915,17.712296,-47.029347,-14.669787,16.311717,-46.895360,-13.736547,17.923106,-46.289665,-11.972767,21.250378,-46.261510,-10.441337,22.400904,-46.240568,-11.917329,21.138193,-46.218107,-11.165237,22.025097,-46.214661,-10.896203,23.833391,-45.920231,-13.417252,17.675149,-45.774293,-14.181672,15.673509,-45.751076,-12.971671,18.262299,-45.312272,-9.751201,18.697267,-45.149373,-12.042727,18.122604,-45.110987,-13.481789,16.605365,-44.160437,-11.562775,16.182935,-43.486083,-10.773810,15.721656,-43.342472,-10.052022,16.167546,-40.387828,-10.156011,23.727490,-39.946759,-9.751220,18.716323,-39.659300,-9.806539,16.473892,-39.533433,-10.658605,19.069501,-39.377266,-10.756197,17.690809,-38.937188,-12.993721,22.929760,-38.533015,-13.703565,22.724687,-38.405641,-13.688714,23.060028,-46.548886,-6.727500,25.289324,-46.458547,-8.966012,25.384535,-46.414737,-9.292877,24.008329,-46.404488,-9.369056,24.229097,-46.302884,-7.447730,23.238855,-45.386800,-5.484659,25.161934,-45.346460,-8.729358,19.502822};
			return value;
		}
		private double[] getCoordinate_9_21_point_16()
		{
			double[] value = {-45.211172,-7.927566,20.265951,-43.874087,-4.805568,25.881810,-43.367781,-7.075594,19.563612,-43.047587,-6.951847,19.529694,-42.688889,-6.229112,20.998309,-42.596985,-6.422849,20.450493,-42.590224,-8.423453,17.289654,-42.589963,-6.321925,20.800065,-42.443818,-6.004700,25.124492,-42.332174,-6.407882,21.246376,-42.019099,-7.091441,19.258385,-41.902061,-6.743009,25.393770,-41.620238,-7.143256,20.925969,-41.412664,-7.656991,18.610723,-40.952556,-8.592700,22.487275,-38.688147,37.127079,25.028158,-38.655870,36.371671,24.535773,-38.592714,39.295929,24.482427,-38.581069,36.176958,25.025772,-38.541995,39.695386,24.567581,-38.534623,39.638304,19.330906,-38.532753,39.995935,19.487883,-38.532018,39.899547,24.656422,-38.498982,40.000541,25.723749,-38.485547,40.038518,24.489362,-38.453766,39.591283,25.761062,-38.446012,37.855997,25.686091,-38.421711,36.683128,25.950336,-38.401477,36.143057,25.731871,-38.388213,37.069924,18.716398,-38.382318,40.872578,15.780789,-38.379840,35.420767,25.632524,-38.369983,39.510588,23.442882,-38.317771,42.491718,20.096172,-38.250464,39.020606,19.598025,-38.230403,35.746608,23.489299,-38.214321,37.461642,17.233952,-38.207109,40.055108,20.318260,-38.173424,41.071690,23.812992,-38.159108,40.361923,23.242946,-38.150015,37.971606,19.332003,-38.143024,37.820646,22.854317,-38.138857,35.785591,18.531451,-38.104018,37.600180,22.484960,-38.093971,35.896972,23.211788,-38.091717,40.155016,20.903936,-38.027239,36.648959,19.069028,-38.009327,36.527853,19.377642,-37.978409,35.953902,22.839646,-41.625887,51.610055,19.215232,-41.325567,49.614376,17.880088,-41.300321,50.066508,19.356242,-40.855890,47.960229,17.973925,-40.832011,51.384375,17.575730,-40.822560,51.913054,15.647624,-40.808684,51.703704,16.182141,-40.794674,51.590537,15.663097,-40.755102,49.988858,20.261333,-40.493564,48.079186,18.922122,-40.446252,51.792460,21.392968,-40.440742,50.632003,20.951385,-40.418024,52.821917,21.977269,-40.413196,52.091349,21.633315,-40.408451,52.740263,22.754565,-40.143402,47.000994,17.887751,-40.099475,52.352785,23.338786,-40.015333,50.573430,22.451332,-39.841589,50.643271,22.957751,-39.788561,47.651778,18.911837,-39.538963,47.819172,19.737394,-39.532232,51.126877,24.009593,-39.519072,52.287599,24.874697,-39.444029,47.106049,15.651507,-39.339122,48.352053,21.617359,-38.870084,50.961442,24.684878,-38.869945,49.446143,23.235592,-38.606448,44.527614,16.818965,-38.605661,49.243690,24.373768,-38.588359,44.689197,16.374750,-38.517794,48.427743,23.244230,-38.510103,48.855616,23.897548,-38.489964,44.365878,16.447666,-38.469949,48.157945,23.119163,-38.445201,43.874416,16.555684,-38.424067,44.135268,19.325252,-38.418953,49.108193,24.585710,-38.400696,48.926418,24.277071,-38.385493,43.069046,17.948978,-38.364324,48.635811,23.878225,-38.353887,47.655290,22.748765,-38.331118,47.567100,22.650992,-38.301103,46.322296,21.827128,-38.035794,44.276206,21.303205,-41.697290,53.411463,19.255526,-41.585985,54.802831,18.725515,-41.182620,55.346153,17.783648,-41.118949,55.615372,19.777303,-41.060249,53.706909,17.757888,-40.975999,56.559047,19.643962,-40.803667,55.907629,17.129806};
			return value;
		}
		private double[] getCoordinate_9_21_point_17()
		{
			double[] value = {-40.770808,57.525961,19.407551,-40.717907,56.293777,16.550656,-40.717855,53.296933,20.472092,-40.549512,53.060839,21.429915,-40.450312,53.889779,22.787057,-40.375595,53.769969,23.338093,-40.319387,54.448008,23.602439,-40.300305,55.639542,22.236383,-40.289431,54.901006,21.501293,-40.214767,55.920412,21.759510,-40.200073,57.284695,23.272500,-40.160080,55.245664,23.898531,-40.120649,54.966349,23.913065,-40.098683,56.176974,21.659939,-40.054144,59.427528,16.909703,-40.001126,55.270734,25.897733,-39.995759,58.024000,22.176671,-39.965364,58.257024,23.528686,-39.950748,60.047634,18.517698,-39.909634,60.261518,18.044158,-39.862231,58.212461,23.993673,-39.819182,55.288429,25.437655,-39.738071,54.026156,24.675648,-39.732244,58.657265,19.709530,-39.431181,60.543822,16.350664,-39.257757,61.010367,21.215257,-39.152826,61.297746,21.834294,-39.112407,61.417865,21.906245,-39.054856,61.550290,20.899097,-39.029474,61.765978,16.603096,-39.019992,59.948119,19.528978,-38.662246,61.805677,23.396745,-38.649943,61.477403,24.360272,-38.590617,62.964099,20.592676,-38.464711,61.639554,18.733812,-38.378885,62.827220,23.572479,-38.337441,61.455445,19.713635,-37.986996,62.528952,18.564105,-40.612296,-135.362499,35.606423,-40.555396,-136.817367,35.571866,-40.442804,-137.856406,35.602275,-39.196468,-138.502184,34.272275,-38.625907,-138.246468,33.526333,-38.588001,-138.645362,33.581645,-38.303675,-135.243862,33.392463,-40.684345,-124.919919,35.844089,-40.332167,-134.483737,36.033471,-39.140339,-128.482740,34.674293,-41.674805,-121.843036,36.355105,-40.145233,-124.531910,35.088052,-39.708193,-123.093760,34.199189,-39.077269,-116.313141,31.816720,-38.533958,-115.014843,30.837335,-43.106683,-103.903970,34.275526,-43.065727,-112.169769,35.955941,-42.435370,-104.433881,33.519158,-39.958855,-110.301850,31.618770,-38.260903,-106.812614,28.759985,-43.713003,-101.554859,34.664572,-42.616567,-97.967996,32.915566,-42.174999,-96.963269,33.292185,-41.227401,-99.523018,31.312317,-40.935308,-99.169337,30.928356,-40.176875,-98.779677,30.019371,-39.256957,-98.418227,29.051007,-38.389994,-96.567098,31.230079,-38.185645,-94.040425,35.319813,-38.137386,-99.313236,27.541608,-48.169842,-65.159543,26.625092,-48.029925,-65.184704,30.670631,-47.778520,-65.431759,34.385128,-47.299655,-65.567027,31.327267,-47.009383,-65.759634,35.538610,-46.935682,-65.807229,34.066557,-46.901463,-65.725181,32.056522,-46.897241,-65.735606,27.757109,-46.478292,-65.880463,30.891427,-46.035689,-66.026602,29.427019,-45.359014,-66.323504,28.054363,-45.230326,-66.390085,29.799561,-44.810838,-66.885135,33.315025,-44.539070,-66.775751,26.350413,-44.536058,-66.766589,30.650373,-43.724362,-67.028455,27.299457,-43.557332,-67.126165,27.061658,-42.614490,-68.729323,35.457086,-42.579245,-67.864174,30.163661,-42.473623,-67.941162,31.306814,-42.438897,-67.706942,28.457866,-42.364777,-67.738673,26.385178,-42.338786,-67.940951,30.138572,-42.203167,-67.948378,28.724676,-41.870151,-69.212105,35.043466,-41.504391,-68.358109,30.330078,-41.432970,-68.135102,27.692710,-41.407680,-68.289427,26.637942,-40.962541,-69.754350,34.484863,-40.826981,-68.571921,27.336637,-40.078454,-70.279700,34.014498,-39.187605,-69.901548,30.232360};
			return value;
		}
		private double[] getCoordinate_9_21_point_18()
		{
			double[] value = {-38.715617,-71.157467,33.334165,-47.500165,-11.874684,26.656642,-47.280878,-11.487590,28.989746,-46.420296,-11.030460,33.384091,-45.946813,-10.744155,35.712877,-45.774592,-10.372770,32.206997,-40.267938,-10.459603,27.396190,-40.135396,-9.975063,28.734896,-40.102343,-9.730942,29.222069,-40.058446,-11.003389,26.263427,-39.934598,-10.058114,28.820535,-39.595938,-10.979665,26.154632,-39.508011,-9.859616,29.342706,-39.402161,-11.049167,26.052782,-39.157212,-10.170330,28.112647,-46.608935,-7.661634,27.582335,-46.589703,-7.856537,27.623768,-46.526434,-5.656432,30.471496,-46.408278,-5.452057,31.827181,-46.345006,-7.108156,31.374344,-46.327530,-6.092868,32.384714,-46.313522,-7.988700,30.185928,-46.280120,-4.941213,31.720009,-45.678678,-9.500082,33.641641,-45.614094,-7.797692,34.758642,-45.556999,-3.851660,34.958000,-45.546667,-3.877588,34.066432,-45.534065,-6.091333,35.946395,-45.529275,-3.815736,34.681143,-45.490846,-8.481543,34.927914,-45.308753,-8.284708,36.043749,-45.051558,-3.986394,30.838180,-44.119475,-3.861602,30.133274,-43.643494,-4.596819,27.068921,-43.566569,-3.902915,30.765807,-42.609852,-2.748917,36.281657,-42.383775,-5.382818,28.552974,-41.913769,-4.560048,33.608622,-41.702085,-6.890368,28.525577,-41.554394,-7.067461,27.920905,-41.553792,-7.010387,26.916497,-41.403426,-5.942006,32.916560,-41.387739,-7.138897,30.872545,-41.384996,-7.158549,27.111767,-41.207158,-8.275239,28.071514,-41.146772,-6.419704,32.780533,-40.943388,-6.203863,33.707026,-40.805418,-9.429515,26.056933,-40.383391,-9.669850,28.637707,-40.043793,-9.327067,30.059694,-39.770867,-7.179000,34.295645,-39.571127,-6.321982,36.270043,-39.464130,-9.079092,30.861863,-39.103657,-6.990948,35.086749,-38.754889,-7.497883,33.635815,-38.604429,-9.302793,30.090633,-38.543804,-6.979470,34.718131,-38.516482,-9.214510,30.235387,-38.452095,36.568331,27.259231,-38.431875,35.921094,26.072470,-38.418414,37.414532,26.089333,-38.314513,39.313503,28.546243,-38.302335,36.921516,27.879996,-38.290602,34.906212,30.577949,-38.281663,32.493052,31.416676,-38.267054,33.101777,30.260885,-38.227041,34.274523,31.635836,-38.164914,35.465815,31.635194,-38.135835,36.473783,28.229320,-38.122357,33.453519,30.068411,-38.105701,38.950517,29.367401,-38.104733,33.147190,32.280920,-38.104384,37.713868,29.703049,-38.044592,32.831239,26.334218,-38.036242,36.609204,31.831294,-38.031490,35.066440,27.366700,-38.244409,51.186208,27.580796,-37.984778,52.961770,29.072325,-39.401338,55.648032,28.546757,-39.379915,58.002422,27.877589,-39.317069,54.015395,27.639772,-39.267961,53.710335,27.669331,-39.260187,53.820412,27.857812,-39.245166,53.774560,26.388940,-39.221121,60.445487,26.173137,-39.193835,54.788693,28.790305,-39.159543,54.657935,28.796105,-39.154841,60.796623,26.433174,-38.877211,53.391970,28.498676,-38.749972,59.070616,29.471556,-38.421521,54.232602,29.342404,-38.286304,61.705720,28.767302,-38.261178,61.390502,29.035854,-38.251122,56.267414,30.124807,-38.180242,58.724289,29.990131,-38.110045,53.200840,29.075991,-48.209496,-136.282081,44.658298,-46.098138,-136.841764,42.232417,-45.144821,-136.373395,40.974226,-44.762941,-135.306115,40.375872};
			return value;
		}
		private double[] getCoordinate_9_21_point_19()
		{
			double[] value = {-44.716928,-136.413028,44.799206,-43.903044,-137.282464,40.219617,-43.637016,-137.394843,39.648942,-42.370430,-137.005708,41.917716,-41.881633,-137.866045,37.343171,-41.622270,-137.229447,40.811512,-41.252101,-137.440407,39.723265,-39.042664,-137.683801,38.706581,-47.873544,-130.171009,45.642504,-47.505785,-131.165645,45.262647,-46.785136,-131.329820,44.382789,-46.023527,-133.101955,42.693756,-45.619657,-133.921367,41.510842,-45.479961,-131.253896,42.802545,-44.128010,-133.101227,40.945411,-43.314665,-125.795264,39.309957,-42.684554,-126.246839,38.620495,-42.335076,-133.252007,38.978254,-42.177061,-127.999605,38.318440,-41.800307,-130.037219,38.189315,-41.665362,-133.529409,38.134447,-41.035497,-128.443353,36.997997,-48.057183,-120.726476,44.280227,-46.386515,-117.524402,41.496001,-45.992630,-119.365780,41.325960,-45.515656,-118.717758,40.583128,-44.922321,-119.333444,39.929105,-44.559069,-118.071618,39.202564,-44.504409,-122.808395,40.166148,-44.159028,-115.910797,38.219730,-43.795984,-120.586592,38.755293,-43.141406,-118.467199,37.460795,-48.314570,-108.653524,42.237746,-47.349760,-107.708463,40.718850,-46.460090,-111.703490,40.361683,-46.406690,-112.500014,40.475043,-45.631008,-104.053640,37.606833,-45.437993,-105.132904,37.564883,-44.070207,-113.458611,37.545539,-47.773083,-95.938404,39.566340,-47.740679,-93.742304,43.027155,-47.637490,-98.979232,39.505130,-47.254991,-95.066682,40.292934,-46.961200,-96.349346,38.447895,-46.924934,-103.358317,39.221200,-46.326300,-96.070373,37.982922,-46.158006,-97.093782,37.353714,-45.997334,-96.747119,37.165181,-45.926453,-98.358910,37.139550,-45.298070,-96.249662,36.863092,-45.230654,-96.120401,37.000365,-43.317059,-94.663036,38.210249,-40.499268,-93.931817,37.341172,-46.200931,-91.910923,44.739608,-45.763103,-90.336662,46.113625,-43.371763,-91.262360,43.073031,-43.264623,-93.053796,40.813358,-43.071859,-83.854390,46.497077,-42.945888,-85.289386,46.069835,-42.045663,-85.613990,44.897799,-40.531595,-87.421396,42.609375,-39.730556,-88.377914,41.368192,-39.015107,-88.074797,40.672097,-38.787180,-89.737732,39.707697,-38.723493,-85.140532,40.982852,-38.200739,-88.652034,39.555461,-43.381232,-73.376523,44.860351,-43.201986,-79.124143,46.362431,-43.182190,-74.220814,44.518252,-43.171292,-77.812304,46.379780,-43.160480,-76.579419,45.636015,-43.157279,-79.359050,46.628480,-43.153633,-74.311560,44.545923,-43.045284,-74.336456,44.274294,-42.786400,-76.123972,44.656948,-42.656867,-74.528701,43.710438,-42.483970,-79.818845,45.492196,-42.278759,-79.731527,45.018420,-41.995973,-74.051150,46.574583,-41.988094,-79.883769,44.726588,-41.323191,-79.892016,43.779222,-41.204937,-79.875110,43.602280,-41.091786,-82.081333,44.561381,-40.894400,-78.371352,42.724600,-40.813458,-82.502686,44.002041,-40.720812,-75.290829,41.342991,-40.537320,-81.665420,44.291669,-40.413313,-72.695476,38.808384,-40.174854,-79.976632,42.362540,-39.935990,-72.953307,38.402848,-39.851607,-73.621482,38.994837,-39.626190,-80.269731,41.861606,-38.442079,-78.404978,39.834426,-38.295211,-82.684634,41.603424,-38.251446,-81.576951,41.595757,-38.105316,-81.495442,41.296575,-48.345921,-64.892573,41.151990,-48.134768,-63.589439,45.758767,-47.928210,-64.815885,43.270294,-47.906682,-65.483832,39.069558};
			return value;
		}
		private double[] getCoordinate_9_21_point_20()
		{
			double[] value = {-47.781847,-65.586927,40.296141,-47.632837,-65.730114,39.191527,-46.662106,-66.419857,38.778584,-46.503444,-65.292472,44.843825,-46.382618,-66.386932,37.733488,-46.274783,-66.121410,44.373098,-46.182498,-65.089151,46.034690,-45.946313,-67.951384,41.942757,-45.855145,-66.695713,37.530384,-45.835508,-67.103979,38.331577,-45.338054,-67.640165,39.469931,-45.240825,-66.352953,45.558532,-45.211090,-69.118315,42.050023,-44.910896,-68.643208,40.208621,-44.907291,-67.429407,44.759009,-44.702107,-68.090969,39.027332,-44.649344,-67.494431,36.401986,-44.487886,-70.929748,43.641358,-44.299282,-68.495780,38.518083,-44.137621,-68.883963,45.011285,-43.463968,-71.718747,42.264040,-43.436071,-68.668765,45.870390,-43.294463,-68.657148,36.884867,-43.253403,-70.302503,45.547742,-43.041950,-69.457879,38.132049,-42.798991,-69.548370,46.384718,-42.544321,-70.330441,46.399543,-42.479063,-70.231081,46.465144,-42.325670,-70.233896,38.279544,-42.073156,-72.000094,46.592653,-42.003380,-71.630261,39.780978,-48.184458,-21.031182,42.700439,-47.773434,-21.691074,44.535650,-47.571055,-21.233033,44.479841,-48.426826,-11.473576,37.430360,-48.076403,-12.166685,44.685535,-47.961555,-11.972618,44.786344,-47.958253,-18.261604,43.989588,-47.611024,-18.344184,44.903368,-47.446132,-11.105033,43.449092,-47.307856,-10.912461,39.768288,-46.290959,-10.613437,41.685218,-46.171591,-10.785556,46.702362,-46.060560,-10.610682,44.978955,-45.713881,-10.571724,38.275414,-45.226523,-10.365858,40.067772,-45.135598,-10.356807,41.228826,-44.634799,-9.776237,39.110310,-43.615855,-9.719135,42.981200,-44.914462,-3.183478,36.718035,-44.858915,-4.877371,38.586917,-44.290465,-9.079116,39.930888,-44.281061,-4.564724,40.172893,-44.200821,-9.548499,40.626916,-43.966233,-3.236046,40.678802,-43.613803,-9.488603,42.359306,-43.188672,-8.994432,42.980396,-42.891474,-2.318941,36.969935,-42.839546,-2.035660,37.952580,-42.774480,-4.910664,43.575499,-42.703875,-1.572492,39.963555,-42.536517,-2.349062,43.749609,-42.473099,-8.393924,44.441780,-42.269380,-4.372030,44.607913,-42.223297,-1.430629,39.991606,-42.179049,-1.219119,43.261506,-42.152548,-1.219705,40.961056,-42.150334,-2.601773,37.179165,-41.965657,-1.468066,44.432109,-41.749812,-8.542735,46.135657,-41.746775,-4.422836,45.648187,-41.566623,-2.900344,37.456922,-41.525249,-0.832017,44.506411,-41.345050,-0.621477,44.176787,-41.329124,-3.069449,37.393396,-41.300680,-1.161562,45.622843,-41.085316,-2.486329,46.536619,-41.042598,-1.918929,40.004219,-40.998169,-3.064175,46.704667,-40.832043,-0.864079,46.322158,-40.718062,-0.228111,44.774110,-40.366875,-1.723507,41.134340,-40.312387,-0.083840,46.144727,-40.123340,-0.750818,43.042325,-40.020398,-5.171977,37.513818,-39.428450,-3.561360,40.461024,-39.366863,-3.553363,40.558614,-38.628958,-5.398042,38.932785,-47.519216,-135.971787,46.803736,-41.558620,-136.031467,47.280457,-43.877717,-135.078248,52.110252,-42.865870,-134.778740,53.861096,-39.537943,-134.927941,53.502416,-39.067917,-134.617165,55.241398,-48.263144,-103.511350,56.576389,-46.688235,-98.494936,56.817959,-45.130790,-93.977735,56.975970,-48.336776,-93.178122,53.546667,-48.238397,-92.529854,52.857759,-47.840392,-92.897495,53.832981};
			return value;
		}
		private double[] getCoordinate_9_21_point_21()
		{
			double[] value = {-47.453606,-91.001939,46.885367,-47.250859,-92.583816,54.143746,-46.675555,-93.026234,55.123969,-46.132026,-88.970539,49.582490,-46.033050,-88.166722,48.214839,-45.735975,-92.169283,55.321144,-44.920316,-91.779277,55.697091,-44.634779,-92.666065,56.975419,-43.829973,-83.637383,47.943348,-43.748899,-83.954642,47.396586,-43.476354,-87.914052,51.477319,-42.656264,-90.204834,55.500535,-42.345235,-84.708179,50.297853,-41.585745,-88.217821,53.765245,-40.714212,-88.104603,54.571472,-39.720894,-84.617166,52.815380,-38.604155,-86.664837,55.401057,-43.175651,-78.687850,46.913324,-43.007824,-79.012629,47.414893,-42.940858,-79.886641,46.797156,-42.370193,-79.563668,48.119974,-42.314404,-80.696679,47.579243,-42.184036,-79.642155,48.187838,-41.221902,-78.470536,49.429280,-40.882484,-72.949363,47.684216,-40.449427,-79.708254,49.371787,-39.994860,-80.283150,49.469426,-39.744560,-77.872475,50.609945,-39.717443,-80.486710,49.913886,-39.517325,-79.413180,50.376557,-39.409340,-79.886347,50.057957,-38.119478,-76.643432,51.558579,-48.264536,-62.310279,49.256758,-48.146638,-62.735245,48.651330,-48.121954,-62.002269,50.379816,-48.075845,-62.699416,48.824961,-47.885808,-62.893170,48.568801,-47.263700,-62.590788,49.981927,-46.983611,-63.444231,48.382404,-46.645801,-62.994151,49.717483,-45.968452,-64.121062,48.174584,-45.676867,-63.586782,49.906691,-45.646063,-64.356308,48.078486,-45.594405,-63.200857,50.813730,-45.486965,-64.282465,48.312052,-44.290736,-66.105392,47.038027,-43.884887,-64.590900,49.974643,-43.752678,-64.466525,50.415584,-43.060927,-65.767556,48.964246,-42.899368,-63.796183,53.198839,-42.555433,-64.151109,52.811241,-42.324139,-67.412355,48.023350,-42.238650,-67.737770,47.822980,-41.925957,-67.682970,48.358164,-41.740373,-64.019772,54.178538,-41.378620,-67.818831,48.710860,-41.229019,-67.109869,49.510746,-40.626468,-65.501310,52.328232,-40.144679,-69.347111,49.374375,-39.603502,-68.689915,50.280154,-39.495458,-64.608217,55.540993,-39.203198,-67.875533,51.413292,-39.197936,-67.728632,51.536543,-38.827116,-70.929662,50.065079,-38.703516,-71.796859,49.936323,-38.588655,-67.356430,52.454981,-38.529679,-67.519750,52.378913,-38.053324,-65.007392,56.355879,-48.126866,-59.285100,56.666802,-47.017404,-59.832632,57.129211,-46.932470,-61.750979,52.747679,-47.829031,-27.037013,50.878734,-47.648195,-24.810124,51.784557,-47.629202,-28.536431,53.482500,-47.396032,-22.081274,47.466154,-47.330863,-28.478618,53.511614,-47.274370,-22.939417,51.187469,-47.175466,-27.578073,52.365002,-47.122074,-21.917946,47.518344,-47.101272,-26.334728,52.561247,-47.060921,-28.378733,55.111807,-47.016522,-21.807553,47.297719,-47.006196,-28.424954,54.423246,-46.879733,-28.221286,56.031081,-46.625837,-21.925515,48.736886,-46.602759,-21.290070,47.230733,-45.972544,-22.331680,53.101495,-45.969846,-25.630923,55.130055,-45.627892,-28.037042,56.647788,-45.542434,-21.181320,49.888422,-45.524381,-21.563082,50.508924,-45.512699,-20.516407,49.733643,-45.446469,-27.621853,55.788558,-45.169217,-27.552413,56.299410,-45.048143,-26.153525,56.349233,-45.025022,-21.967222,54.313716,-44.969316,-22.193518,55.410151,-44.369321,-21.757105,55.448838,-43.810861,-21.344470,54.385041,-43.484997,-20.569090,53.723329};
			return value;
		}
		private double[] getCoordinate_9_21_point_22()
		{
			double[] value = {-43.054425,-20.880665,54.828269,-42.834260,-20.910328,55.492261,-42.720890,-20.920304,55.908192,-47.139849,-11.959227,47.237862,-46.977389,-15.043558,47.774113,-46.153744,-15.286351,49.616186,-45.900780,-17.739148,49.417467,-45.794016,-14.865945,50.512205,-44.957691,-10.333546,47.280583,-44.732564,-12.738003,52.712724,-44.457939,-16.661726,52.571355,-44.382222,-19.656926,52.076515,-44.364721,-16.672119,52.719215,-44.260064,-20.051863,52.203616,-43.783945,-19.970152,53.056412,-43.588041,-10.074762,50.845258,-43.480804,-19.734375,53.535610,-43.474790,-10.021950,50.490364,-43.353609,-10.257675,53.308348,-42.902213,-9.956332,52.879061,-42.894699,-9.790301,47.954864,-42.694602,-9.819644,52.178793,-42.598621,-9.974101,54.380717,-42.236768,-19.270457,55.507652,-42.199469,-9.966715,55.294627,-42.038338,-19.835205,55.840513,-41.825158,-9.820721,55.832099,-41.683099,-15.188219,56.898825,-41.927450,-9.319544,46.811579,-41.127003,-9.487237,56.281629,-40.940275,-9.204245,49.320836,-40.826056,-8.999342,48.806982,-40.720500,-9.332673,56.661642,-40.692188,-4.339715,47.511351,-40.393825,-3.238202,47.854596,-40.385291,-3.434116,47.887933,-40.377685,-9.059260,50.722154,-40.366205,-8.512028,48.960491,-40.294151,-0.599626,47.116656,-40.033586,-8.750520,50.360906,-39.947648,-9.004065,55.423660,-39.452888,-3.569528,49.540076,-39.444471,-8.590398,51.488488,-39.305476,-4.550368,49.942628,-39.005534,-8.163842,51.551833,-38.962755,-4.584374,50.357826,-38.902494,-5.345258,50.557605,-38.594826,-6.971706,51.138294,-38.306430,-3.375761,51.084950,-38.265106,-6.375354,51.433034,-38.400609,0.791561,48.772142,-38.271653,0.901277,48.628444,-48.171872,-131.639439,63.296835,-48.104061,-133.840946,58.216993,-48.020711,-132.825401,63.704857,-46.572324,-132.712436,64.508249,-45.992759,-131.500095,65.430139,-45.889355,-132.534655,65.558307,-45.340395,-133.114097,62.507154,-45.074242,-127.488026,65.457935,-45.004684,-133.933839,58.131262,-44.873451,-132.353424,66.671985,-44.696336,-131.965546,66.768195,-44.546340,-132.389764,66.520000,-44.497617,-132.987394,63.303577,-39.377456,-132.808111,64.956430,-48.399935,-122.963085,61.034629,-48.283459,-117.321840,59.853387,-45.096636,-119.387996,63.595641,-44.209722,-118.888677,64.350457,-43.861243,-117.425615,64.340267,-43.231263,-122.772722,66.242397,-42.489969,-120.297379,66.376942,-42.069469,-118.286748,66.304440,-40.444656,-115.006898,67.128728,-48.058535,-112.623495,59.021895,-47.790109,-111.371480,58.999500,-46.073226,-107.329297,59.746266,-45.792881,-109.659571,60.586131,-45.360497,-111.355199,61.427343,-45.269821,-107.360230,60.553915,-43.634850,-112.261193,63.364761,-41.040055,-106.075734,64.510151,-40.110221,-111.253413,66.627560,-39.176229,-110.958402,67.450750,-44.545017,-103.314288,60.261629,-42.819967,-101.177699,61.378388,-42.618242,-99.765943,61.177866,-41.807468,-103.630968,63.038966,-39.427323,-101.264110,64.679838,-39.050681,-95.832066,63.409472,-38.851331,-102.120651,65.476733,-38.830073,-102.663757,65.692666,-38.601377,-100.972064,65.326080,-38.393452,-101.394727,65.668457,-38.278278,-95.838742,64.136692,-42.329796,-91.432464,58.206211,-42.257585,-91.735718,58.726158,-41.733072,-91.828098,59.400710,-39.694446,-89.480662,57.692771};
			return value;
		}
		private double[] getCoordinate_9_21_point_23()
		{
			double[] value = {-39.204226,-89.588676,58.474686,-40.320181,-62.185025,60.007798,-39.280529,-63.583376,58.199316,-38.954170,-62.519403,61.179173,-38.873629,-62.695430,60.661050,-38.756237,-62.851345,60.387651,-38.741380,-62.126217,61.944685,-38.559476,-62.872092,60.593302,-48.365133,-54.152663,64.344267,-48.001793,-54.031838,64.835674,-47.915653,-59.148539,57.287083,-47.689945,-51.600284,65.233940,-46.979443,-59.201399,57.953080,-46.649209,-53.890734,66.265618,-46.470716,-59.951201,57.371897,-46.427575,-56.351395,63.367852,-45.995647,-54.469272,66.341915,-45.898936,-60.400230,57.154585,-45.821565,-58.446792,60.654450,-45.780558,-52.037362,67.324962,-44.394624,-60.388922,58.891100,-44.294371,-56.926051,64.690632,-43.748064,-57.991387,63.671216,-43.701301,-61.389351,57.817277,-43.681026,-60.202195,59.805133,-43.678677,-61.570851,57.505040,-42.646709,-61.511561,58.489942,-42.343714,-58.715651,63.980750,-41.624288,-58.266881,65.370596,-41.419089,-61.797779,59.673414,-41.159160,-57.949746,66.370704,-40.957397,-61.651695,60.558551,-40.780096,-58.672146,65.814348,-40.702085,-61.767449,60.710443,-40.124731,-59.157871,65.830961,-39.397442,-59.301700,66.277634,-39.361277,-59.691094,65.810445,-39.352824,-59.886491,65.527526,-39.149077,-58.782199,67.357038,-48.400920,-41.400453,63.001625,-48.379531,-45.284135,64.540175,-47.271359,-41.642397,65.138006,-46.937352,-47.287766,66.654315,-46.441727,-44.588974,67.357750,-45.828690,-48.493677,66.772610,-45.814149,-49.294953,66.643517,-47.793083,-38.678040,63.119689,-47.754066,-37.825989,62.967059,-46.936574,-34.948855,63.560064,-46.863229,-38.579159,64.843885,-46.696323,-39.157021,65.323086,-46.486074,-33.940857,64.097480,-45.439314,-31.783373,65.494747,-45.357897,-34.156627,66.030136,-45.026992,-34.577208,66.701307,-44.855544,-34.731978,67.079260,-48.198513,-27.549134,58.148983,-47.982960,-27.626622,59.998629,-47.947432,-27.446332,59.328019,-47.797982,-27.439477,59.852004,-47.231200,-28.745172,62.238628,-47.012811,-27.220290,61.041578,-46.983376,-30.485826,63.132088,-46.476273,-26.943149,60.564706,-46.350554,-26.868349,60.838373,-46.197455,-27.006370,62.236225,-46.044732,-30.033943,64.298794,-45.948977,-26.763807,61.231170,-45.816291,-26.686316,61.775821,-45.748342,-26.729603,61.291713,-45.613760,-30.575950,64.965227,-45.420228,-28.666716,64.810641,-45.220645,-28.560514,65.033611,-44.689605,-27.671070,57.977798,-44.504467,-27.362714,57.426847,-44.472831,-22.887045,57.383675,-44.229277,-22.277373,57.215745,-43.658592,-27.221425,60.252289,-43.458476,-27.167874,60.449669,-43.201228,-27.087721,60.442537,-43.087635,-26.563693,66.749000,-43.024256,-25.816422,65.368544,-42.824249,-21.331553,58.612566,-42.230358,-25.662801,65.448320,-41.597543,-25.440225,67.435071,-41.573829,-20.997998,60.517430,-41.532335,-21.152266,60.886815,-41.351270,-25.430902,61.905965,-41.332545,-20.489210,58.058139,-41.223063,-20.901909,60.956633,-41.133930,-26.103977,64.510613,-41.125422,-26.250317,63.266821,-41.013036,-25.280473,67.081361,-40.881241,-20.726215,61.139061,-40.843824,-21.422952,62.233897,-40.808099,-26.146952,63.070664,-40.802882,-22.565278,62.886967,-40.362907,-25.475284,63.083852,-40.292760,-22.531173,63.540312,-39.901101,-25.878699,65.814906};
			return value;
		}
		private double[] getCoordinate_9_21_point_24()
		{
			double[] value = {-39.705702,-20.378268,62.470219,-39.562980,-22.415256,64.316096,-39.530423,-25.969372,65.432086,-39.287633,-20.311587,63.111880,-39.054723,-20.245780,63.406949,-38.699103,-25.029060,64.989862,-38.305781,-25.238743,65.441169,-41.632593,-13.389964,57.218512,-41.399558,-14.094707,57.583009,-41.187143,-20.041958,57.351563,-41.087777,-19.155483,57.166787,-40.790768,-20.105470,58.159137,-40.435397,-15.158176,58.544304,-40.094409,-13.678067,59.235794,-40.065398,-10.809627,59.292221,-39.978213,-18.853652,58.699840,-39.924617,-19.916658,59.533394,-39.637867,-19.794892,59.772584,-39.369701,-11.334951,60.273438,-38.122906,-19.571203,62.480483,-40.165193,-9.235115,57.813622,-39.923547,-9.249858,58.368381,-39.413779,-9.083533,59.041427,-39.303047,-8.915886,58.531853,-39.014100,-8.781378,58.577445,-40.745609,-131.630679,70.365502,-40.546630,-125.160248,69.320184,-39.317923,-131.575729,71.610732,-38.677443,-132.149008,68.604461,-38.162409,-131.255720,72.706188,-41.392831,-124.552491,68.414395,-40.228358,-120.887761,68.663483,-38.941736,-123.064752,70.331698,-38.578421,-123.259866,70.701279,-45.481570,-51.890906,67.524743,-44.572580,-53.399177,68.673356,-44.534986,-52.156520,68.655318,-44.403555,-53.604326,68.778926,-44.389553,-54.100699,68.437787,-44.230024,-53.333602,69.022342,-43.087829,-55.214005,68.226174,-42.767666,-52.713913,70.408973,-42.556824,-53.175387,70.653754,-40.559092,-56.302427,69.101894,-40.505849,-52.917277,72.573662,-40.433414,-57.329263,68.070904,-40.000180,-56.960982,68.794943,-39.590405,-56.188817,70.071760,-39.551971,-57.159018,69.190395,-38.172127,-57.950208,69.201569,-38.061580,-52.983678,74.793715,-45.352148,-44.676473,68.753706,-44.377939,-43.811589,69.851537,-43.954749,-42.331856,70.230790,-43.916363,-48.050248,68.162397,-43.595041,-44.433922,70.065879,-43.538124,-46.439341,68.679432,-43.241942,-44.682854,69.950340,-42.743211,-42.992346,71.292873,-42.620286,-45.774632,69.243266,-42.608035,-48.083806,69.267464,-42.244034,-45.918320,69.420534,-41.778352,-44.740096,70.010011,-41.772275,-42.192452,72.087383,-41.695860,-45.792477,69.787795,-41.599030,-46.113219,69.843761,-41.258370,-45.262073,70.117210,-41.194983,-44.579745,70.316711,-41.189492,-41.900946,72.442222,-41.135046,-46.376695,70.263128,-40.928951,-42.170556,72.289227,-40.759061,-44.748664,70.529537,-40.613264,-41.930933,72.521873,-39.905603,-49.772387,72.516761,-39.652188,-51.073396,73.284944,-39.105173,-46.910732,72.424065,-38.766615,-46.722069,72.702985,-38.506145,-41.808741,72.885829,-45.093842,-38.100042,67.755650,-44.612173,-40.330277,68.982512,-44.576023,-36.267254,68.028205,-44.267090,-36.702414,68.605490,-43.276390,-38.319138,70.262789,-43.121353,-37.103820,70.149518,-42.875623,-30.923111,68.729766,-42.141582,-36.605897,71.094409,-41.904041,-39.377628,72.036913,-41.699024,-39.435819,72.250712,-41.252202,-33.675832,71.291413,-40.687573,-40.051506,73.219657,-38.961161,-37.180611,74.339396,-42.809930,-29.617993,68.409810,-42.725874,-28.872689,68.281580,-42.688614,-27.676746,67.888514,-41.482637,-25.627294,68.004442,-40.818606,-26.710489,69.665039,-40.656078,-25.199946,68.435036,-40.643223,-25.112192,68.086005,-40.559255,-25.323279,68.827872,-40.386471,-30.014101,71.191508};
			return value;
		}
		private double[] getCoordinate_9_21_point_25()
		{
			double[] value = {-39.724075,-29.190143,71.639764,-39.672250,-27.580333,71.219146,-39.184698,-24.835871,69.984540,-38.872243,-25.075233,70.679738,-38.823771,-27.213575,71.939949,-38.787665,-25.689746,71.334004,-38.073568,-25.049177,71.576885,-36.860222,-63.983095,-17.452775,-36.480973,-64.590949,-17.323096,-36.068167,-64.635464,-17.418626,-35.736748,-62.477053,-17.773077,-34.967026,-64.946931,-17.445965,-34.597137,-64.439953,-17.716284,-34.417255,-64.973480,-17.576755,-34.401981,-64.725773,-17.707971,-34.085285,-63.777690,-17.873025,-33.668227,-64.865964,-17.884018,-33.210674,-65.163507,-17.891121,-33.109139,-64.143997,-18.173511,-33.026430,-65.808925,-16.741844,-32.573671,-62.429574,-18.133249,-30.870270,-63.436856,-19.710046,-30.396520,-63.776059,-20.150033,-30.267622,-64.268868,-20.220630,-30.174378,-64.624931,-20.159111,-30.156840,-64.713452,-20.109643,-29.773428,-66.086697,-18.363290,-27.888697,-65.727067,-19.840930,-35.977315,-53.836028,-17.181148,-35.860485,-54.688294,-17.389882,-35.855299,-54.973411,-17.418690,-35.407937,-53.729112,-17.210531,-35.389258,-54.587372,-17.338064,-34.619828,-54.861705,-17.429320,-34.018437,-56.375549,-17.620315,-33.557915,-51.995654,-16.622079,-32.758186,-56.840364,-17.497153,-31.274540,-52.098244,-16.315697,-31.121689,-58.043843,-17.669788,-31.022127,-61.047593,-18.457358,-30.336486,-51.976537,-16.425369,-30.322949,-54.029179,-16.968712,-30.052546,-59.504087,-18.699728,-29.902669,-58.043552,-18.309530,-29.884056,-58.372306,-18.463524,-29.702372,-59.386086,-19.184921,-29.541992,-61.961712,-20.712949,-29.502018,-59.171972,-19.664817,-29.439339,-52.265186,-17.039788,-29.402399,-59.426095,-19.894888,-29.240989,-54.783857,-18.076638,-29.193265,-56.754821,-18.937777,-35.499527,-50.316065,-16.344358,-34.719155,-51.066372,-16.500996,-31.653685,-51.254604,-16.097618,-30.473074,-50.233069,-15.872514,-30.070232,-49.983686,-15.939927,-29.750160,-49.608511,-15.988529,-29.614094,-50.736413,-16.443669,-29.578074,-48.990579,-15.863336,-29.143949,-50.188993,-16.747863,-28.763314,-50.137877,-17.222573,-28.638664,-46.218766,-16.094508,-28.364390,-46.633133,-16.481155,-28.327990,-49.517294,-17.532907,-27.663701,-47.767329,-17.496377,-27.532674,-48.936169,-17.983429,-37.269166,-65.487905,-14.201184,-37.053466,-65.540446,-14.232002,-36.815783,-65.667372,-13.767363,-36.404468,-67.087153,-7.655995,-35.914188,-67.098163,-9.001626,-35.444603,-67.746068,-5.681319,-35.382391,-67.463669,-7.852970,-33.697661,-68.193206,-6.669723,-32.998050,-68.655675,-5.272486,-32.919358,-67.628959,-10.222195,-32.391523,-67.673336,-11.138216,-32.373918,-67.455437,-11.581942,-32.024065,-67.821703,-10.965494,-31.951498,-66.652315,-15.034382,-30.961404,-68.977838,-7.077042,-29.987413,-69.149382,-7.865131,-29.831028,-68.588875,-10.305746,-29.795058,-68.281715,-11.891314,-29.703471,-68.389925,-11.581229,-37.960125,-47.494179,-15.499463,-37.801275,-46.536226,-15.191761,-37.492689,-41.113568,-12.876580,-36.757198,-46.436895,-15.135531,-35.709560,-46.609405,-15.107999,-35.387546,-42.281858,-13.264449,-35.185015,-45.728947,-14.712025,-34.692679,-41.514098,-12.638186,-32.928153,-41.905121,-12.324592,-32.851889,-42.269477,-12.529292,-31.963819,-43.653312,-13.061871,-31.957922,-44.440156,-13.420006,-31.899367,-47.737008,-14.870129,-31.203864,-43.385174,-13.043078};
			return value;
		}
		private double[] getCoordinate_9_21_point_26()
		{
			double[] value = {-31.146874,-44.134517,-13.382822,-30.769732,-44.142974,-13.513022,-30.578118,-41.130050,-12.594107,-30.510804,-45.560735,-14.167331,-30.377953,-42.191675,-13.036706,-30.237044,-48.198580,-15.213676,-29.895284,-43.816658,-13.966321,-37.176060,-35.892305,-9.529864,-35.681165,-33.881288,-8.478966,-35.638559,-31.198962,-8.708486,-35.521797,-36.982701,-9.795218,-35.458753,-40.169322,-12.139113,-35.365128,-32.334813,-8.855121,-35.168935,-39.884257,-11.852473,-34.987863,-33.922593,-8.870873,-34.888597,-40.133381,-11.939013,-34.543565,-31.959253,-9.211205,-34.217774,-38.569230,-10.542327,-33.506665,-31.202291,-9.054409,-33.023263,-40.829765,-11.717092,-32.793895,-32.050614,-9.500887,-32.686108,-31.099583,-8.811421,-32.468717,-35.794375,-10.603657,-31.737631,-39.541278,-11.379488,-31.659885,-38.943719,-11.306002,-30.960441,-38.564534,-11.905122,-30.425636,-31.621476,-8.186401,-30.254337,-36.205003,-11.546760,-30.206082,-38.688690,-12.467557,-30.096543,-38.591478,-12.499543,-29.278691,-36.493415,-11.679900,-28.590399,-33.968956,-9.594087,-28.021769,-31.440857,-5.416446,-27.800056,-32.337573,-6.856880,-36.590025,-29.990072,-8.224862,-36.579093,-28.961791,-7.822895,-36.576850,-28.382736,-7.482582,-36.482307,-30.465029,-8.329160,-35.998863,-30.458054,-8.480566,-35.854439,-26.681374,-5.447916,-34.797491,-29.751589,-8.244177,-34.373054,-28.879716,-7.364586,-33.907716,-29.245088,-7.551734,-29.740257,-30.555708,-6.241965,-30.036506,60.896955,-6.101480,-29.409751,58.458559,-7.359937,-29.277754,59.215232,-6.299545,-29.261391,56.419454,-6.023468,-29.232050,56.356396,-5.813564,-29.154195,60.303088,-8.979987,-29.126978,59.656686,-9.124648,-29.109824,56.113693,-5.542583,-29.019973,60.996815,-8.493779,-28.874286,61.458724,-9.354424,-28.873636,59.924351,-9.639109,-28.664503,61.239765,-10.072782,-28.613107,56.871142,-8.075116,-28.552327,59.303846,-9.732927,-28.427701,57.282575,-8.746235,-28.411195,60.732521,-10.272842,-28.266566,62.276495,-10.428077,-28.153396,56.717413,-9.123635,-28.083752,57.152921,-9.641716,-27.993482,57.510669,-10.102972,-27.958270,58.136812,-10.422460,-27.943569,57.190441,-9.853073,-27.795317,59.095953,-10.141343,-27.684334,55.866774,-7.934039,-27.541131,54.700369,-5.295667,-30.155026,65.432009,-5.694350,-29.704594,67.264726,-5.759210,-29.703806,66.558385,-5.993840,-29.362906,65.965954,-6.410662,-29.297278,67.214967,-6.164589,-28.985478,67.271680,-6.324852,-28.974784,68.756107,-5.924331,-28.864816,66.402164,-6.953977,-28.829904,70.488279,-5.382388,-28.777568,68.765599,-6.040521,-28.712409,66.956113,-6.772228,-28.039325,69.353378,-7.386026,-28.002585,69.881530,-6.052198,-27.942518,64.964347,-9.946150,-27.661930,70.413949,-6.773623,-37.816000,-67.620548,-1.346850,-37.557627,-68.029691,0.716887,-37.436483,-67.423774,-3.390456,-37.413041,-68.186879,1.083414,-36.994272,-68.881108,5.100481,-36.741327,-68.442405,1.533287,-36.229157,-68.954076,4.813042,-35.160196,-69.221256,4.341820,-34.894263,-69.401300,4.922686,-34.376825,-69.532087,3.738266,-33.932238,-69.720921,4.845100,-33.468202,-69.271463,0.041598,-31.742100,-70.346052,3.748402,-30.892761,-69.627864,-2.841672,-29.877299,-70.096216,-2.112217,-29.699592,-69.913286,-3.103764};
			return value;
		}
		private double[] getCoordinate_9_21_point_27()
		{
			double[] value = {-29.438403,-70.546824,-0.423502,-28.107186,-71.312426,2.610516,-27.822003,-70.622447,-2.778689,-28.568878,-31.165835,-3.785738,-28.510494,-30.809943,-2.634771,-28.089721,-31.480690,-4.677789,-37.668864,-24.134916,-0.305978,-37.623629,-21.157885,3.671067,-37.236854,-24.200931,0.412970,-36.762659,-21.679794,3.096774,-36.507355,-24.729299,-1.678951,-36.393931,-20.776387,3.882003,-36.270499,-24.921613,-0.879120,-33.578760,-25.461320,0.267135,-33.495716,-26.995395,-4.056082,-33.455781,-23.650726,1.558365,-33.290713,-26.941858,-3.267133,-33.191986,-26.746360,-1.224439,-32.822621,-27.345090,-1.923143,-32.321578,-25.758506,0.175122,-31.709937,-21.029250,3.529291,-31.667661,-28.210855,-3.819519,-31.555261,-22.586010,2.324922,-31.531783,-22.858563,2.138193,-31.075436,-28.816729,-4.692715,-31.064908,-28.242164,-1.386386,-29.734917,-30.027764,-3.407300,-29.528946,-30.191190,-3.199954,-29.371926,-21.037909,4.061338,-29.260091,-21.118382,4.052155,-29.085625,-28.694387,-1.150707,-28.895538,-21.644798,3.600171,-28.782976,-28.962222,-1.266265,-28.747428,-30.593302,-2.596325,-28.661568,-29.484478,-1.526722,-28.634743,-21.671939,5.200915,-28.438964,-21.698513,4.261688,-27.993197,-27.981368,-0.710518,-27.824059,-27.706232,-0.538632,-27.730419,-23.404359,2.197329,-27.589297,-22.592921,3.708112,-27.566607,-29.835716,-1.574889,-32.661647,-20.153050,4.231076,-31.616319,-19.267450,5.095592,-27.826865,20.689451,4.960281,-34.244076,29.824682,4.568979,-33.966804,31.341981,3.713037,-33.807766,30.484203,3.908387,-33.286460,31.673222,2.904418,-33.233474,31.389205,3.206335,-33.112231,32.027454,2.231640,-33.087464,27.848273,4.898111,-32.588635,28.877793,3.947679,-32.524258,29.334613,3.727961,-32.433956,30.180030,2.752510,-32.265526,29.175281,3.474810,-32.013783,28.214105,3.986321,-31.887005,26.639898,4.730516,-31.840837,32.042407,1.849262,-31.296646,28.125217,3.193059,-30.946363,29.087462,2.704901,-30.793837,26.464387,4.358369,-30.465970,27.390153,3.250179,-30.405044,25.913474,4.536137,-30.182621,29.499673,3.029492,-29.893667,26.752917,3.503699,-29.455597,29.829662,3.467874,-29.407508,26.109985,4.006391,-28.954262,25.782252,4.226524,-28.535193,26.749935,3.327750,-28.398360,23.734693,4.821825,-27.829596,26.308161,3.457692,-27.598071,30.816233,4.283812,-27.541322,30.021243,4.032076,-36.937678,38.386787,4.953617,-36.897409,36.728692,4.485887,-36.700558,40.699428,4.343488,-36.641866,35.072353,5.018981,-36.624123,35.953563,4.199361,-36.466574,37.933554,3.377981,-36.297230,37.356005,3.428438,-35.730417,41.223255,2.308289,-35.705818,34.304747,3.815158,-35.695161,39.870263,2.513188,-35.509329,38.566223,2.788520,-35.392883,34.318134,3.516191,-34.945719,32.890480,3.693347,-34.797024,36.090629,3.091382,-34.164342,40.337429,2.208106,-34.105506,36.285680,2.164649,-33.938107,34.509730,2.420521,-33.826799,34.351124,1.974388,-33.772706,39.818923,2.020569,-33.698216,36.937098,1.119864,-33.690356,41.050431,1.943442,-33.640886,40.473375,1.941293,-33.406053,42.418668,1.582235,-32.927819,40.575225,0.737694,-32.707846,39.648215,0.290948,-32.460928,39.770462,0.056164};
			return value;
		}
		private double[] getCoordinate_9_21_point_28()
		{
			double[] value = {-32.327961,32.496216,1.642945,-32.292411,42.521614,0.876332,-32.122155,39.820222,-0.137438,-32.018527,42.104883,0.314438,-31.970036,41.343881,-0.016055,-31.831653,40.573262,-0.303042,-31.537853,32.795807,1.608843,-31.502839,34.187203,0.651147,-31.203556,42.306172,-0.354002,-31.176234,36.173095,-0.416340,-31.010200,35.124994,0.048061,-30.894597,42.117055,-0.577249,-30.704945,35.877908,-0.434739,-30.648754,36.580894,-0.742274,-30.409467,42.468269,-0.695203,-30.354574,34.744989,0.600225,-30.292218,32.513160,2.846167,-29.816513,33.178340,2.766222,-29.785855,35.211277,0.275120,-29.498635,40.121723,-1.229645,-29.317040,34.677200,1.627262,-29.299030,39.650003,-1.314051,-28.959179,41.744903,-1.060053,-28.038971,33.427213,3.795002,-27.714411,35.965279,0.987227,-36.133550,42.884532,2.777025,-35.842299,51.599982,4.364322,-35.790230,50.364548,4.721263,-35.689285,50.832768,4.435579,-35.633462,42.775330,4.587336,-35.601909,43.701621,2.133809,-35.261775,44.189970,3.348414,-35.035095,51.423679,3.773350,-35.010911,44.516816,3.168878,-34.913274,50.838893,3.705822,-34.882860,44.826257,2.885552,-34.377390,43.469561,5.152369,-34.224744,45.932700,1.006022,-34.006182,44.459822,4.461089,-33.986503,44.341620,4.843126,-33.773135,51.496296,1.987101,-33.652470,52.508041,1.663299,-33.632807,46.156732,0.124061,-33.520921,43.973831,0.832878,-33.481836,51.221034,1.726600,-33.449647,45.982906,-0.050988,-33.405677,45.853388,-0.055967,-33.280714,44.387126,0.543029,-33.227498,42.588558,1.474885,-33.184062,49.428021,3.458600,-33.163513,46.615564,-0.283535,-33.079189,51.585619,1.204114,-33.012201,47.025202,1.431065,-32.992338,49.311188,3.423270,-32.896760,51.893629,0.711195,-32.883406,52.721468,-0.756812,-32.854082,47.378111,4.241833,-32.629120,47.430589,0.463801,-32.575320,51.746128,-0.256627,-32.483678,46.795360,2.598441,-32.212647,47.296568,1.931936,-32.099289,49.408892,2.338969,-32.021548,47.095413,2.622579,-31.604245,51.730649,-0.922617,-31.424313,45.955311,-1.113531,-31.398477,43.769033,0.338502,-31.334959,49.189000,1.648095,-30.959295,44.831004,-0.111772,-30.715191,48.645512,1.147453,-30.634563,45.981354,-1.302435,-30.383565,48.685964,-0.306466,-30.161480,49.760804,0.519035,-30.125915,50.505264,-0.082437,-29.887546,43.063293,-0.752346,-29.825868,42.842228,-0.824765,-29.765857,45.670779,-0.934007,-29.395480,46.948785,-3.016587,-29.352422,42.833614,-0.907501,-29.300236,49.395941,-0.074544,-29.274689,45.867653,-1.156913,-29.113177,46.398574,-2.587699,-29.051400,47.187735,-3.233072,-28.909799,46.548426,-2.951716,-28.802263,49.237091,-0.874518,-28.652251,46.884644,-3.308515,-28.582656,51.194510,-1.151189,-28.217958,52.630679,-2.114941,-28.178218,47.272429,-3.666087,-27.994756,47.257504,-3.716207,-27.748327,51.295728,-1.632059,-36.604889,59.217056,4.672076,-36.545434,57.394749,3.981569,-36.540656,58.333263,5.188455,-36.440919,55.447347,4.442478,-36.362915,60.056492,2.471127,-36.310935,54.613734,4.615119,-35.406541,60.574708,0.775861,-35.372680,63.100683,1.497122,-35.040068,59.869193,0.579267,-34.931834,62.327506,-0.012251};
			return value;
		}
		private double[] getCoordinate_9_21_point_29()
		{
			double[] value = {-34.912862,56.723532,1.661611,-34.776915,62.021517,-0.245295,-34.670079,60.681544,-0.035460,-34.659033,54.758510,2.042645,-34.283003,56.251677,1.322678,-34.253560,53.703149,1.949762,-34.199419,62.909809,-0.908425,-34.045656,62.989423,-1.038163,-34.034839,63.272850,-1.063373,-33.835156,57.574022,0.565502,-33.822927,57.585142,-1.139734,-33.742901,55.272803,1.066518,-33.516759,59.184703,-0.199637,-33.495766,58.262511,-0.183839,-33.492196,55.483784,-0.078372,-33.439737,55.916796,-1.409762,-33.352717,55.244015,0.467990,-33.252822,53.721785,0.895455,-33.124658,53.523618,-0.185515,-32.863152,53.220203,-1.160939,-32.764741,60.677729,-1.528901,-32.761509,58.072479,-2.277966,-32.739314,60.292312,-2.566507,-32.698363,53.191777,-1.264036,-32.676114,57.020057,-1.968897,-32.445496,61.773215,-1.692271,-32.351798,60.827287,-3.060090,-32.315133,60.791960,-3.154387,-32.309891,60.664246,-3.196257,-32.165730,61.304263,-3.176788,-31.985301,61.535243,-3.595746,-31.914355,57.875703,-3.398767,-31.913018,57.494054,-3.330386,-31.767936,58.620594,-3.641606,-31.654422,62.436050,-3.695085,-30.788583,53.426124,-2.246588,-30.121061,54.527440,-2.525504,-30.078187,58.354664,-4.690206,-29.784917,57.245918,-4.121245,-29.669915,57.725332,-4.495356,-29.002742,54.479408,-2.776992,-28.827989,53.809533,-2.436934,-28.692995,55.331395,-4.808866,-28.488014,55.050971,-4.770014,-28.290639,54.317839,-3.825238,-27.955983,54.766131,-4.996240,-34.530075,64.816247,2.184876,-34.507661,64.456969,0.781519,-34.432180,69.869321,4.525529,-34.389678,68.589899,4.241221,-34.114450,65.002906,1.272607,-34.081139,65.003946,1.179090,-34.076404,73.850098,4.818624,-34.042493,68.528400,3.793499,-33.958043,70.166141,3.554088,-33.750160,69.415203,3.275955,-33.703478,66.398115,1.168084,-33.641257,66.781867,1.815850,-33.593054,66.508425,0.879498,-33.571287,67.153145,2.071741,-33.496032,71.683340,2.967698,-33.490943,64.742741,-1.287988,-33.454981,68.359432,2.802582,-33.334406,72.241394,3.025063,-33.090879,73.057378,3.425729,-32.995768,72.853171,2.538782,-32.986455,69.596081,1.952809,-32.915919,65.159001,-2.000350,-32.896193,73.622832,3.448706,-32.895345,70.095852,2.038448,-32.894099,65.923466,-0.513172,-32.796812,68.925584,0.374335,-32.745395,73.796113,2.831673,-32.497475,72.939683,1.559715,-32.495128,70.763296,0.686488,-32.418227,66.516474,-0.884299,-32.351388,73.625447,1.653966,-32.002175,66.382710,-2.721225,-31.930588,67.256671,-0.935556,-31.783366,71.849815,-0.398824,-31.764360,72.231542,-0.259007,-31.638866,68.286124,-0.859717,-31.622562,71.735410,-0.656342,-31.048355,69.457497,-2.509478,-31.006592,67.298603,-3.306225,-30.946641,70.259473,-1.116839,-30.934895,64.445616,-3.254978,-30.910664,68.327718,-3.301517,-30.863316,73.226694,-0.844557,-30.822986,71.917021,-1.009721,-30.811809,68.924649,-3.289401,-30.518265,70.442278,-1.892006,-30.484928,65.374450,-4.284812,-30.442092,65.776804,-4.676967,-30.358342,70.410548,-3.274133,-30.222889,71.150558,-3.130331,-30.172952,71.752312,-1.719782,-29.769941,72.145846,-3.236451,-29.769879,73.039445,-2.782276,-29.767500,69.472198,-3.748664};
			return value;
		}
		private double[] getCoordinate_9_21_point_30()
		{
			double[] value = {-29.699721,72.112165,-3.310673,-29.655347,69.307668,-3.826793,-29.588035,70.024334,-3.747804,-29.542470,69.242361,-3.964051,-29.341972,70.208972,-4.073395,-29.034127,72.688873,-3.661589,-29.009176,72.887220,-3.667737,-28.982446,71.823118,-4.486516,-28.981514,72.770331,-3.850084,-28.245411,73.540547,-4.355436,-27.574235,72.939802,-4.981174,-33.343652,76.063900,4.428491,-32.975456,76.760282,4.247004,-32.884195,76.833178,4.167656,-32.618207,77.994799,4.699180,-32.606228,77.765637,4.330090,-32.512440,78.281282,4.797114,-31.964768,75.637216,2.456990,-31.819094,80.160862,5.122005,-31.751744,74.804474,1.226686,-31.720379,79.427134,4.090973,-31.685795,76.118113,1.966042,-31.557350,77.161092,2.980508,-31.546202,74.138390,0.660116,-31.388221,80.476199,4.561409,-31.246025,74.195822,0.229828,-31.182957,78.255189,2.944313,-31.159712,80.813827,4.389343,-31.029529,75.131082,0.404236,-30.815815,79.256564,2.923099,-30.727692,74.994755,-0.337286,-30.689459,79.359284,2.232480,-30.333996,80.996366,2.823716,-30.169750,76.850697,0.043626,-30.146677,77.888530,0.521782,-30.044693,79.339600,1.143288,-29.941606,73.892996,-0.919857,-29.840049,75.263374,-0.588489,-29.809360,77.792997,0.102621,-29.743575,77.869344,0.015989,-29.730935,75.303270,-0.960402,-29.633578,75.842790,-1.215421,-29.533643,77.030480,-0.802755,-29.407414,79.638192,0.416738,-28.751025,81.171898,0.417065,-27.963217,76.280793,-2.847022,-27.948324,74.570144,-3.884793,-27.896493,77.455048,-2.345168,-27.553124,75.559451,-3.737194,-27.967560,84.392079,2.149585,-28.299409,-73.111804,14.457067,-28.050366,-72.899177,12.362909,-27.692510,-73.275302,14.027017,-37.717986,-69.190072,11.552536,-37.195174,-69.363560,12.596427,-37.074517,-69.380970,11.582292,-36.924173,-69.480395,13.424094,-36.687314,-69.268700,7.668352,-33.310693,-70.249157,6.054159,-32.795592,-70.254527,5.564011,-32.144021,-71.193430,11.693075,-31.799833,-70.759078,6.456608,-30.956309,-71.840870,13.449117,-30.939340,-71.660526,11.539606,-30.845332,-72.005954,14.372261,-30.202926,-72.093508,12.423120,-30.118705,-72.340703,14.674726,-29.984611,-72.162347,13.184569,-29.790678,-71.440135,5.809449,-29.635085,-71.834911,8.524775,-29.208665,-72.011790,8.772336,-28.622940,-71.738116,5.921533,-33.474679,-20.703959,15.346278,-31.525637,-22.206590,14.651290,-31.027269,-22.780823,14.084601,-30.972320,-22.688827,14.364525,-30.436317,-23.521216,12.143775,-30.310049,-21.502389,8.872388,-30.188147,-23.308341,13.993736,-29.911746,-20.231800,5.962139,-29.664182,-24.311503,12.170311,-29.246918,-24.103056,13.495630,-29.187597,-24.747033,10.631544,-29.112446,-23.864438,14.119560,-28.976210,-23.089538,14.962744,-28.374690,-25.595858,11.829090,-28.135839,-25.324942,12.152032,-37.921019,-14.790529,9.230503,-37.499374,-12.475551,11.746326,-37.451687,-16.383449,8.191407,-37.450061,-13.892886,9.816137,-37.370256,-12.473768,12.877335,-36.998672,-13.252137,10.749328,-36.474305,-13.978844,9.833549,-36.449637,-17.303904,7.053413,-36.440971,-14.337627,9.314966,-36.420607,-17.232167,7.108795,-36.237548,-14.402814,9.284157,-36.076199,-15.185369,13.644274,-35.979470,-17.725164,6.526152};
			return value;
		}
		private double[] getCoordinate_9_21_point_31()
		{
			double[] value = {-35.779241,-14.268695,10.126392,-35.563725,-16.791940,7.065004,-35.120613,-16.232568,12.713503,-34.800133,-16.145731,7.490238,-34.755312,-15.480162,8.482387,-34.359476,-15.672294,8.844213,-34.294037,-19.187615,13.639263,-34.206150,-16.588758,7.076232,-34.127395,-16.067492,9.910078,-33.797802,-18.460980,12.004657,-33.712181,-19.675683,13.086157,-33.428462,-17.676753,6.143697,-33.372087,-18.396314,5.592672,-30.671149,-20.137003,7.807918,-29.068067,21.600110,5.864293,-28.922549,21.377537,5.798915,-35.352809,31.279350,5.795355,-34.768575,31.515548,7.204834,-33.484479,27.270661,5.831023,-33.141059,31.997981,8.569269,-32.778373,25.968637,6.645073,-32.634951,30.460463,13.124278,-32.474801,30.881509,12.435712,-32.145355,29.201864,14.094571,-32.098634,31.225248,11.358657,-32.032129,28.147697,15.501348,-31.844725,28.070206,15.402264,-31.793749,30.298887,9.284776,-31.759484,28.676550,14.486431,-31.512806,30.705179,9.725953,-31.510092,30.923631,9.910936,-31.380312,24.071385,7.438329,-31.317906,30.320377,11.809519,-31.137724,23.665634,7.344084,-30.791834,24.740724,5.395170,-30.554202,28.240701,9.677109,-30.548974,29.936172,10.802219,-30.511431,27.385160,15.578728,-30.407182,23.381784,8.152849,-30.396153,28.741130,9.943005,-30.392274,23.099252,7.898535,-30.306519,23.584162,5.798347,-30.040218,22.380571,7.456274,-29.507522,22.036126,6.126490,-29.348962,23.726642,9.141950,-28.915700,26.459479,10.221386,-28.737159,28.044796,13.158880,-28.076283,26.919040,14.563093,-37.711299,41.831312,13.746434,-37.171768,40.361983,13.469846,-37.098660,38.381614,13.854252,-36.991953,37.436942,14.103575,-36.772917,40.260129,11.846862,-36.670792,36.084823,5.717225,-36.601644,36.313037,13.950474,-36.453777,36.420174,13.602279,-36.443497,36.852160,13.215445,-36.386041,36.441359,6.280143,-36.362370,39.479140,12.406362,-36.338217,41.443380,10.766472,-36.295984,35.550731,15.137182,-36.292733,35.459108,6.406571,-36.194847,35.244285,15.124760,-36.194689,35.046371,13.898243,-36.143436,40.487165,5.267581,-36.117353,33.683499,6.062482,-36.104093,34.915995,14.060990,-36.084861,37.887975,12.573100,-36.071706,35.025187,13.611401,-36.016114,37.677972,12.531153,-35.980329,37.190726,12.529626,-35.905243,38.492543,11.809986,-35.899089,32.607729,5.298966,-35.789386,34.423555,14.803845,-35.762108,34.792043,6.988228,-35.726646,33.936785,13.975672,-35.564330,33.141876,15.604370,-35.502310,33.948367,7.100034,-35.501907,37.728539,6.934653,-35.348773,37.514817,10.786369,-34.982686,39.835727,6.717629,-34.865104,35.389336,12.007817,-34.618039,32.272843,7.629162,-34.573112,42.019648,6.317861,-34.460780,36.468807,7.868719,-34.262154,37.153225,7.990885,-34.182291,35.358386,8.092767,-34.168107,36.242497,8.131849,-34.159390,40.917479,8.196581,-34.133079,39.471717,7.780754,-34.095585,40.148185,7.631000,-34.034936,37.824957,8.274905,-34.009422,33.468760,11.827918,-33.994499,40.628372,7.693858,-33.921799,39.707993,8.119583,-33.727993,34.844763,10.109989,-33.635381,35.796752,9.215745,-33.602007,33.700872,8.372084,-33.098743,32.943938,10.733860,-33.071272,34.062174,9.313855};
			return value;
		}
		private double[] getCoordinate_9_21_point_32()
		{
			double[] value = {-37.915911,48.141518,7.778048,-37.796656,45.200886,11.849897,-37.604812,45.766368,10.951302,-37.601653,43.132793,12.010955,-37.468757,47.709217,7.311422,-37.399279,48.369792,7.316033,-37.327015,43.608592,11.180059,-37.109342,52.484028,6.872863,-36.858652,51.732048,6.250370,-36.613253,50.466136,5.890010,-36.529275,49.024642,5.908113,-36.487318,47.028838,6.482317,-36.367814,49.010745,5.807721,-36.305736,50.332270,5.515436,-35.631157,48.458241,5.459914,-35.048670,45.181041,6.051013,-34.820146,47.226506,5.414175,-37.892548,59.825348,10.672716,-37.881946,62.331726,13.568255,-37.740680,53.818351,8.077356,-37.669634,54.813314,8.172782,-37.553727,60.064658,8.994512,-37.493526,55.624961,6.445871,-37.386659,55.784578,6.734214,-37.354313,58.823757,7.967878,-37.299451,62.848213,11.955437,-37.298006,55.002017,7.533258,-37.296291,58.473034,7.881181,-37.295284,54.053128,5.846796,-37.289871,54.375472,5.843962,-37.267206,53.920711,7.001772,-37.242829,53.787968,7.007050,-37.218010,53.578990,6.815139,-37.210027,63.005761,11.756041,-37.202136,57.275454,6.508504,-37.069824,61.862478,9.428867,-36.913075,58.513385,6.010810,-36.892749,62.780665,9.961158,-36.868476,62.351774,9.248616,-36.812658,59.200901,6.183410,-36.043468,61.810259,5.331435,-35.812951,62.801306,6.050910,-37.333636,63.842821,14.152310,-36.666820,64.744687,11.682303,-36.648104,63.490231,9.732651,-36.371234,66.686138,14.041331,-36.223285,64.527383,9.210511,-36.192893,64.850900,9.585840,-36.139425,66.083739,10.433595,-36.126821,66.951035,15.317979,-36.106899,66.174971,10.431377,-36.053277,66.705699,14.853090,-35.997597,66.982745,11.167555,-35.857074,67.351145,14.465327,-35.828629,67.336313,14.659060,-35.771227,67.940344,15.120634,-35.557700,68.262293,14.456997,-35.509222,65.532161,7.023659,-35.491686,70.426695,15.533338,-35.487679,68.858998,15.016308,-35.401918,69.447616,14.075343,-35.321149,70.171201,10.022750,-35.255666,72.429301,7.517481,-35.123241,73.081222,7.370861,-35.039787,71.737409,13.848693,-34.991675,71.070282,14.352960,-34.973161,73.685483,7.359480,-34.930554,69.958537,6.561153,-34.879259,72.165013,11.801927,-34.759937,70.672309,6.103978,-34.737569,72.878042,14.186525,-34.731154,72.811035,14.506263,-34.442224,72.563286,5.276262,-34.488663,74.051376,6.006359,-34.417484,74.447669,14.982445,-34.355942,73.962945,14.057944,-34.329066,74.931927,15.143856,-34.212580,75.872439,9.981763,-34.082291,75.220904,14.572122,-33.878038,75.573870,13.496256,-33.857558,75.724161,14.164261,-33.827259,76.042072,7.980125,-33.822287,76.767302,10.923629,-33.773191,77.178809,10.254795,-33.515265,76.800664,6.556937,-33.220588,77.346657,5.354656,-33.075797,77.525484,7.300477,-33.062321,78.454520,7.643622,-32.919314,79.369520,9.403314,-32.758595,79.375548,7.714534,-32.756039,78.352063,5.501735,-32.465210,78.521182,6.809209,-32.270806,78.873612,6.246524,-32.237265,80.465694,14.022246,-31.654590,80.594104,5.420992,-31.646909,81.383421,7.507468,-31.473061,82.371048,12.046401,-31.384415,81.128943,5.406548,-31.331253,82.704413,14.944739,-31.215036,81.163446,6.987085};
			return value;
		}
		private double[] getCoordinate_9_21_point_33()
		{
			double[] value = {-31.176449,81.480800,5.302078,-31.125275,81.022591,6.469322,-31.033136,81.198925,6.651109,-30.267438,83.321742,6.078555,-30.141163,83.788112,7.999028,-29.865919,85.294534,14.038217,-29.562150,84.687940,8.385503,-29.266290,85.139317,8.530197,-29.142757,85.337947,7.825552,-28.694777,85.975972,8.203324,-28.151805,87.132069,10.177938,-31.466380,-138.054074,25.149720,-31.355557,-138.955915,25.109002,-31.344843,-140.017668,25.299799,-31.107239,-136.888962,25.266925,-30.904151,-140.445536,24.902918,-30.282675,-137.760595,23.932670,-30.123335,-136.507713,24.831162,-29.974382,-139.964187,23.709838,-29.178529,-140.383965,22.883203,-29.065423,-136.775761,23.688287,-28.991286,-140.885256,22.787823,-28.795830,-136.916155,23.381758,-28.741094,-137.580840,22.598319,-28.709439,-140.949881,22.477066,-28.343366,-137.284080,22.604603,-28.001812,-137.622415,21.957271,-31.715808,-128.227209,25.514666,-29.393853,-134.836442,24.222889,-29.357070,-132.559940,23.761390,-29.218172,-133.712210,23.818887,-29.213204,-126.635070,22.302860,-28.263036,-134.440004,22.877582,-28.000317,-133.491648,22.406042,-34.242618,-114.627399,25.294783,-33.723055,-114.609168,24.680945,-33.001821,-116.982301,24.356601,-32.584778,-122.501452,25.159719,-32.038941,-122.285350,24.484471,-31.961341,-116.649167,23.114777,-30.775565,-118.337233,22.163391,-29.512386,-122.569627,21.706848,-28.096007,-114.657014,18.446649,-27.639305,-123.461343,19.788992,-35.737977,-104.577992,25.224907,-30.400011,-104.032301,19.024169,-28.688749,-104.208268,17.166510,-36.701432,-99.567206,25.844729,-35.994735,-98.651223,25.822776,-35.301774,-101.236517,24.285441,-34.172964,-102.579257,23.104987,-33.737261,-101.242120,22.513134,-33.105029,-99.260987,22.640074,-32.807586,-98.959745,22.857860,-32.752823,-100.303690,21.413352,-32.651890,-99.656407,21.805649,-32.439805,-97.688149,24.861965,-32.088826,-97.086416,25.706957,-31.817757,-103.027058,20.474163,-31.619116,-100.519486,20.168066,-31.203432,-99.732587,20.551945,-30.709027,-100.447248,19.338689,-30.105778,-97.709762,23.244882,-29.922658,-100.025391,19.166989,-29.664599,-100.338670,18.575563,-29.339258,-96.815982,24.057171,-28.038110,-100.957576,16.581410,-33.468129,-72.575269,25.912926,-32.236548,-73.291533,25.940824,-31.445044,-72.599592,19.647914,-30.950949,-73.290542,22.341167,-30.868669,-72.696726,18.810619,-30.843561,-73.517402,23.117887,-29.223493,-75.317906,25.518452,-29.067654,-73.794094,20.411456,-28.133301,-74.892623,22.865411,-27.974698,-74.577122,21.171551,-27.775334,-74.203062,18.917253,-27.663966,-74.504201,20.328437,-27.535099,-75.325501,23.097408,-37.379580,-69.760352,19.913693,-37.062316,-70.071196,23.762060,-36.686124,-70.587243,25.472042,-36.640075,-70.003944,17.943391,-36.597004,-69.983214,17.581713,-36.585839,-69.965464,17.430787,-36.474320,-70.441144,22.985945,-36.149205,-70.771569,24.941427,-35.885607,-70.499078,19.934793,-35.482282,-70.524176,19.133464,-35.413058,-70.590281,19.463938,-35.169179,-70.776117,20.368405,-35.084874,-71.030877,22.046992,-34.975478,-71.141775,22.798318,-34.825007,-70.876696,18.840509,-33.127601,-71.724170,19.169188,-31.477789,-21.091751,16.564576,-30.185012,-21.257773,16.558103,-29.890617,-21.684832,16.311479,-29.745220,-20.920444,17.094925};
			return value;
		}
		private double[] getCoordinate_9_21_point_34()
		{
			double[] value = {-29.474928,-21.379513,16.888995,-29.272970,-22.024247,16.052164,-29.157844,-20.521743,17.499387,-27.860267,-22.561193,16.137241,-27.721523,-22.550866,16.176445,-37.795597,-12.144969,25.345394,-37.668827,-14.016182,22.810669,-37.653997,-12.157191,25.190971,-37.619527,-12.082274,25.329664,-37.451923,-12.928301,24.380296,-37.394616,-11.911960,25.722948,-37.175737,-12.970430,24.093321,-37.012913,-16.009929,19.490395,-36.997766,-16.206045,18.045915,-36.987232,-15.601053,20.302083,-36.820844,-16.235217,17.168220,-36.701716,-16.588477,17.567499,-36.385211,-12.396819,24.361357,-36.197505,-17.473488,18.273333,-36.054771,-11.231437,25.792023,-35.889450,-16.764487,19.676142,-35.812008,-17.472160,18.956790,-35.629522,-10.895593,25.929424,-35.575401,-13.370995,23.813307,-35.526131,-14.060307,22.985029,-35.346280,-17.325725,19.384867,-35.306725,-10.705647,25.850414,-35.228672,-12.483829,24.380346,-35.143763,-17.342583,19.389989,-34.848762,-16.924537,20.237065,-34.799563,-17.023035,20.148968,-34.744653,-19.650375,16.776307,-34.729020,-19.842311,16.299635,-34.728418,-11.905415,24.433358,-34.665647,-12.326138,24.183335,-34.582881,-18.330110,18.206387,-34.503661,-17.505421,19.396766,-34.082062,-16.068693,20.823259,-34.021851,-18.621123,18.351719,-33.847103,-13.814312,22.809836,-33.653859,-16.096169,20.849622,-33.611123,-18.221290,18.591813,-33.565902,-18.638983,17.953319,-33.450095,-17.719175,19.174555,-33.151711,-14.968585,21.639097,-32.736882,-13.766910,22.388983,-32.711721,-14.607546,21.864661,-32.510543,-16.786765,20.491206,-32.155574,-10.618807,23.843161,-31.803103,-16.370502,20.579759,-31.790465,-13.893630,21.683938,-31.742802,-13.996498,21.661107,-31.726865,-16.459493,20.508073,-31.586157,-16.497246,20.540411,-31.520473,-17.981351,19.387003,-31.510330,-19.992175,17.462825,-31.477013,-17.609321,19.783569,-31.432112,-18.107653,19.295838,-31.407950,-18.042859,19.364567,-31.181667,-18.667032,18.772593,-31.077550,-13.443891,22.097685,-30.686918,-12.473581,22.347049,-30.653271,-17.878017,19.569627,-30.443039,-10.803014,22.844737,-30.205914,-13.734161,21.517864,-30.040813,-10.436652,22.749802,-29.909212,-18.594120,18.973191,-29.894293,-19.437431,18.305915,-29.825130,-14.517448,21.092892,-29.779666,-14.207343,21.127073,-29.142741,-19.658430,18.037876,-29.109441,-14.953079,20.677951,-28.908910,-18.387842,18.854920,-28.895131,-16.786485,19.815569,-28.814313,-19.458342,18.304228,-28.684856,-15.125989,20.496447,-28.679303,-15.023070,20.497091,-28.591166,-17.460793,19.446741,-28.577532,-19.998191,17.726533,-28.297956,-19.515476,18.328231,-27.984208,-13.783183,20.724653,-27.860350,-17.699802,19.272935,-27.669972,-11.319298,21.332352,-31.992567,-7.956585,25.275330,-31.091883,-4.612470,25.836685,-29.566160,-3.828655,24.544850,-29.433838,-4.901675,24.044753,-28.613501,-1.634225,24.250135,-28.408329,-0.793442,24.258270,-28.371071,-9.231698,22.186100,-27.946804,-2.570425,23.503573,-27.760588,-6.824444,22.485539,-27.625580,-9.597029,21.821254,-28.568667,6.108228,25.501963,-28.502177,7.946598,25.763085,-28.261320,9.940568,25.712652,-28.125002,1.375582,24.336118,-28.112144,1.469544,24.338445,-28.057867,2.706527,24.403586,-27.683870,10.073978,24.635871};
			return value;
		}
		private double[] getCoordinate_9_21_point_35()
		{
			double[] value = {-37.765810,31.764834,25.724771,-36.656967,29.850203,24.088037,-36.346665,29.610379,25.136122,-36.248442,31.030399,19.065274,-36.109761,28.911344,24.397740,-36.006775,31.460375,17.604422,-35.602671,31.221284,20.942297,-35.457267,30.917424,21.004852,-35.432354,28.691127,23.161614,-35.330992,29.673101,19.840446,-34.969696,27.187915,25.380134,-34.949641,28.412022,23.177292,-34.905098,29.132475,20.046673,-34.599705,28.968344,19.576326,-34.386312,26.572936,25.578805,-34.290911,29.062478,21.854876,-34.241923,28.447761,20.578995,-34.073127,28.381470,19.837720,-34.027351,29.309510,17.489446,-33.853853,29.753163,16.599433,-33.309492,29.042120,16.761735,-33.199278,29.102683,15.745391,-32.353262,27.807024,16.790830,-32.220019,26.136806,22.993937,-32.197448,27.771318,16.423586,-32.115227,27.488859,17.052105,-31.856296,26.171304,21.070318,-31.418678,26.775282,17.440845,-31.239014,24.985100,25.431264,-31.030057,26.657447,17.284408,-30.907020,25.698668,20.557303,-30.384875,26.131382,18.086888,-30.107526,24.997871,22.532265,-29.943039,24.998170,22.277510,-29.672404,26.485327,17.176504,-29.468409,27.185350,15.921349,-29.384896,23.961340,25.245911,-29.103652,26.835467,16.366303,-28.805734,26.334333,17.223203,-28.795091,24.462023,22.860378,-28.242967,25.009680,20.824426,-28.158441,23.476780,24.262001,-27.590670,22.272802,25.169187,-37.950459,41.034889,21.128042,-37.920418,38.854776,20.645345,-37.863419,35.477823,21.815898,-37.848127,34.624758,23.280315,-37.811478,39.404019,21.328410,-37.789259,38.394971,20.867965,-37.771516,39.652149,22.345608,-37.770884,34.128267,21.904238,-37.767513,40.289053,21.746979,-37.731401,34.309842,21.791591,-37.721570,38.994076,21.989351,-37.700942,42.176535,23.092665,-37.686395,36.845411,20.020404,-37.685811,36.974786,21.586984,-37.638652,35.048627,19.303913,-37.554323,32.750266,24.066129,-37.430966,36.072604,20.449662,-37.391828,38.525238,15.871183,-37.269771,35.556026,20.460743,-37.218101,32.973908,18.812633,-37.033115,32.754926,19.016371,-36.977481,32.699841,19.103537,-36.950110,36.555878,15.606918,-36.914128,34.056389,16.484647,-36.836760,34.650245,15.894609,-36.765078,32.867676,17.398226,-36.576924,32.164780,19.635030,-37.894767,43.900203,21.308179,-37.831894,42.531621,20.927460,-37.715403,48.956397,25.561051,-37.613583,43.018243,24.948681,-37.570521,44.255534,21.951132,-37.450941,47.412669,23.897566,-37.336534,44.154474,22.512856,-37.287123,44.050748,24.231280,-37.266547,44.391467,25.682357,-37.252728,47.420119,24.331504,-37.154757,44.726509,24.312371,-37.130819,46.533690,23.480335,-37.051775,48.434814,25.921541,-37.021130,45.295519,23.732936,-36.959662,46.385669,23.798984,-36.778410,46.954961,25.299542,-37.743865,62.784812,18.937832,-37.974761,64.533280,20.274331,-37.836099,64.940304,22.662757,-37.802669,64.675197,16.930836,-37.800513,63.651272,17.907315,-37.748046,65.274434,23.885066,-37.535398,63.814304,19.221009,-37.476230,65.974731,21.807511,-37.422815,65.332385,16.523735,-37.241424,66.642310,20.411054,-37.090512,67.031704,21.533487,-36.576043,68.225467,23.504966,-36.507949,68.748833,19.431131,-36.444353,68.609479,24.042524};
			return value;
		}
		private double[] getCoordinate_9_21_point_36()
		{
			double[] value = {-36.424121,67.914745,15.891208,-36.394904,69.020400,19.431061,-36.360624,68.825982,23.827041,-36.158979,69.379223,23.647515,-36.099367,69.597106,18.933226,-36.080255,70.072556,21.947507,-35.924335,69.770930,15.988379,-35.853369,70.946702,19.318348,-35.808767,70.241924,16.059318,-35.581063,71.572307,22.316344,-35.531827,71.254658,16.000566,-35.487754,71.265031,24.357265,-35.445146,71.366102,25.490178,-35.266188,72.287228,16.140334,-35.070625,73.750165,19.682967,-35.031970,73.780233,17.015695,-34.875669,73.828068,20.872876,-34.666126,73.126192,25.274955,-34.571827,73.243506,25.746666,-34.775422,74.172534,16.537528,-34.627728,74.508136,20.343195,-34.303623,74.442690,16.159006,-34.280077,75.780770,17.082344,-34.275321,74.951673,22.573692,-34.236453,76.210788,18.573737,-34.162116,75.551232,20.934322,-34.144017,76.531115,18.041815,-34.098723,75.388767,22.693070,-34.090820,75.977873,16.400651,-33.969048,76.686318,20.088197,-33.898878,75.809549,23.619732,-33.810825,77.102719,16.529911,-33.636292,76.304328,23.649944,-33.481260,78.037879,19.446538,-33.236779,77.232710,23.334412,-33.228001,78.610148,19.187663,-33.203536,78.691783,18.051678,-33.176704,77.046021,22.337155,-32.970520,77.762823,24.214580,-32.821121,78.672202,22.221628,-32.558307,78.605267,25.277695,-32.441948,78.662340,23.790761,-31.705340,80.113133,25.912041,-31.683861,79.867605,23.863334,-31.612509,80.516575,24.611443,-31.566955,81.596193,21.259009,-31.438988,82.250989,19.330090,-31.163227,83.003097,16.045959,-31.155754,83.007328,17.042079,-31.057769,82.075981,22.637917,-30.651408,81.743217,24.048081,-30.476333,83.953362,19.399574,-30.239833,83.915491,21.332865,-29.837977,83.756112,22.839519,-29.644514,83.643204,23.896925,-29.633282,83.615844,23.303480,-29.505602,83.962692,25.107903,-29.664733,85.442327,18.245072,-29.614402,85.527321,18.217123,-29.541559,85.653629,17.980649,-29.395191,85.190477,21.599833,-29.380080,85.939110,18.092522,-29.290788,84.338579,25.190977,-29.023122,85.026166,22.613637,-29.009167,86.429740,18.411712,-28.728899,86.085267,21.776775,-27.809693,87.150220,22.553318,-37.650419,-135.127053,32.985895,-37.593470,-136.245445,32.098679,-37.552923,-138.852047,32.605502,-37.051443,-136.465374,31.457330,-36.557984,-136.272263,30.973890,-36.508322,-139.074452,31.546101,-35.715216,-136.371329,30.051174,-34.381434,-136.653768,28.571354,-34.347746,-136.021620,29.038648,-34.241924,-135.482066,29.429030,-34.223476,-138.387162,35.559128,-34.066872,-139.710742,28.441867,-33.931641,-139.529549,28.231973,-33.741827,-138.890095,32.911043,-32.821492,-137.242929,26.702434,-32.750841,-140.018925,26.956177,-32.550691,-140.044310,26.725982,-32.254956,-138.853637,33.306997,-32.104602,-139.912843,26.164431,-31.776400,-139.696100,28.827932,-31.270664,-135.513262,26.345855,-29.712277,-138.632447,34.840596,-28.993937,-138.688597,34.634047,-28.945830,-139.464930,30.453554,-28.281791,-138.510552,35.689729,-37.819343,-127.967028,32.921748,-36.886755,-134.737081,32.595816,-36.236473,-129.970629,31.355005,-35.692064,-131.946758,31.018745,-34.620039,-132.579098,29.522401,-34.428343,-125.432445,28.089044,-33.598913,-129.383436,27.973879,-32.325714,-133.571588,27.288226};
			return value;
		}
		private double[] getCoordinate_9_21_point_37()
		{
			double[] value = {-35.901055,-120.448893,28.708000,-35.269398,-124.119454,28.805967,-37.731288,-108.815340,28.485449,-37.048902,-114.180855,28.736555,-36.207753,-110.186816,26.844694,-37.374921,-98.701105,26.990585,-37.248472,-96.418969,30.719036,-36.347838,-95.074725,32.290045,-35.564316,-96.845580,28.712101,-32.523990,-94.951330,29.266856,-32.951803,-92.943363,31.593180,-32.673208,-91.020499,32.488805,-32.525168,-83.066472,35.104470,-31.111976,-87.024537,31.834824,-30.882243,-87.677270,31.507482,-30.650317,-85.771148,31.598974,-30.421502,-86.729573,31.125798,-30.134039,-83.028622,31.865951,-29.896480,-88.549318,30.282756,-29.451427,-85.708156,30.401979,-29.381362,-85.835119,30.246176,-29.311328,-87.733628,29.760373,-28.656033,-90.689221,28.434014,-28.543276,-86.476488,29.129044,-27.863390,-89.224037,27.985824,-27.582560,-88.222793,27.823262,-36.835944,-73.160552,33.840516,-36.480101,-74.749059,35.233751,-36.052874,-74.073221,33.835047,-35.281802,-75.598640,34.513406,-35.183349,-75.150229,33.895846,-35.060153,-73.241115,31.277310,-34.723545,-73.883861,31.825285,-34.708210,-73.231689,30.350816,-34.228054,-77.651088,34.715041,-33.957875,-72.468341,26.848226,-33.793256,-76.982660,33.833141,-33.533461,-75.202220,31.970067,-33.256831,-76.620864,32.856113,-33.187776,-81.952807,35.123614,-33.121066,-82.809631,35.726486,-32.982545,-76.921941,32.675279,-32.866760,-78.089785,33.457296,-32.516223,-82.688619,34.879510,-32.348065,-75.748341,30.841186,-32.237821,-76.156321,31.241400,-32.214317,-78.116655,32.591731,-32.176969,-76.080180,30.989778,-32.119296,-76.234874,31.097837,-31.053218,-75.499324,28.856102,-30.290367,-77.049824,29.462973,-29.882621,-82.242610,31.422811,-29.271719,-76.934627,28.082696,-29.003166,-82.395391,30.444130,-37.936090,-72.383923,34.404477,-37.484592,-71.008933,30.190273,-35.860336,-72.216195,30.052802,-37.674526,-11.320201,26.629581,-37.547460,-10.186926,28.222476,-36.705851,-10.189171,27.562366,-36.538135,-9.877931,27.606313,-35.955004,-10.524881,26.710769,-35.161112,-10.035838,26.577799,-37.625516,-9.101720,29.848186,-36.747079,-6.583811,33.118959,-36.503224,-6.473110,32.894105,-36.360692,-7.523577,31.028042,-36.309416,-7.646395,30.755192,-36.208547,-9.332430,28.310539,-36.168893,-9.261016,28.364419,-35.239562,-5.467728,31.762708,-34.532727,-2.437420,35.006698,-34.424583,-5.964985,29.634315,-34.393285,-2.130931,35.074417,-33.250308,-5.922224,28.001504,-32.864696,0.290489,32.797216,-32.809032,-0.215376,31.900794,-31.266221,-4.304784,26.214542,-32.283184,2.607180,34.805662,-31.762609,3.124285,33.067383,-30.956678,5.338506,32.394652,-30.175984,4.413126,28.512048,-29.988888,9.079789,34.747272,-29.902603,5.130878,28.035029,-29.829697,3.412224,27.340551,-29.459886,8.814377,28.703008,-29.434514,1.574760,26.147173,-29.340492,9.496866,28.881191,-28.491688,10.257058,26.539004,-28.727833,11.537546,28.335189,-28.705779,12.813272,29.574894,-28.595018,13.209870,35.097898,-28.526545,14.182157,31.065301,-28.227355,21.038243,34.819102,-27.941790,20.487063,30.734902,-27.934321,21.319931,28.622366,-27.895393,20.535123,34.013373,-27.815323,20.789384,28.502122,-27.813811,20.337386,35.063263,-27.781892,20.287595,34.284903};
			return value;
		}
		private double[] getCoordinate_9_21_point_38()
		{
			double[] value = {-27.769433,19.374707,31.027134,-27.751548,19.716286,32.626724,-27.746560,19.351131,31.868059,-37.976684,31.519203,32.202946,-37.806369,30.195338,30.409204,-37.782296,30.353958,32.059078,-37.762172,30.024441,30.488362,-37.713090,31.494060,29.764407,-37.710592,29.849407,30.564734,-37.608047,31.429253,26.626618,-37.578552,31.586818,34.474050,-37.547920,30.356449,34.449478,-37.454355,31.187209,35.385606,-37.399721,30.338528,35.179916,-37.257109,31.303631,33.218483,-37.193130,31.615373,29.477798,-37.161564,29.338364,35.707297,-37.105043,28.713671,35.148726,-37.058562,29.767911,26.655546,-37.042862,30.257738,27.246770,-36.912641,28.282950,35.343205,-36.855640,30.270217,29.609096,-36.851932,27.945821,31.843836,-36.762089,27.858642,35.326331,-36.745185,28.678304,32.719466,-36.651061,28.062566,36.229731,-36.630233,31.351658,27.659830,-36.589768,27.887258,35.833906,-36.464214,30.946843,27.774988,-36.437189,31.796921,27.975832,-36.402161,31.225786,27.880292,-36.319399,27.658810,34.164548,-36.240581,28.452964,27.853035,-36.197824,30.436020,28.099128,-36.138026,26.979956,31.539875,-36.037619,28.437111,29.758530,-35.752282,26.572173,36.309160,-35.683088,26.419792,33.294256,-35.582701,26.374671,34.601918,-35.512272,27.989695,26.594346,-35.510259,26.237278,36.277414,-35.368545,27.745499,26.498375,-35.238072,27.433034,26.489289,-35.216867,25.942528,34.967762,-35.179194,27.438711,26.951860,-35.174003,27.197593,29.642356,-35.139034,25.811271,36.079331,-34.865764,25.636958,36.302744,-34.797030,25.478375,33.708511,-34.756681,26.639453,30.147773,-34.626701,26.390079,29.449305,-34.393315,25.140209,33.545273,-34.382256,26.193994,26.808095,-34.324478,25.264707,32.911518,-34.265533,26.031776,27.210530,-33.975132,24.704527,35.874115,-33.851037,25.903309,26.615258,-33.521284,25.403711,31.058500,-33.166556,24.964997,29.212466,-33.067988,25.016047,30.834518,-32.597477,23.401982,35.634762,-32.214727,23.208316,35.060634,-31.985855,24.453295,30.595876,-31.824349,25.459445,26.491771,-31.803519,25.412920,26.609524,-31.765143,24.939211,28.097671,-31.346948,25.006552,26.232556,-30.719102,22.078192,35.884729,-30.460326,24.057173,27.066853,-29.456185,23.263608,31.506375,-29.360866,22.856241,31.633998,-29.356536,23.168549,30.637557,-28.713026,22.190952,31.473392,-28.650509,22.932311,27.250874,-37.948842,38.648776,30.264093,-37.924607,37.536141,31.565430,-37.823629,41.272699,28.099769,-37.755776,41.111564,26.876671,-37.748631,36.700495,28.873777,-37.542562,33.449715,32.863189,-37.518172,32.324472,29.544535,-37.412577,35.627442,33.677037,-37.369888,34.030168,27.716932,-37.342518,34.744814,35.687002,-37.342424,37.846025,32.560931,-37.340386,41.619701,29.735580,-37.333314,37.377623,34.289718,-37.330027,36.675633,33.380766,-37.309279,37.131563,32.907959,-37.276305,42.238129,28.582917,-37.260758,35.458592,28.169898,-37.238921,37.596588,32.980187,-37.218929,38.379750,33.786721,-37.208265,36.131486,28.713678,-37.180517,41.435510,30.817672,-37.157578,39.565635,31.980886,-37.110238,38.910470,32.460492,-36.895739,39.797096,32.376958,-36.838449,40.203538,33.749761,-36.791165,37.535625,35.453712};
			return value;
		}
		private double[] getCoordinate_9_21_point_39()
		{
			double[] value = {-36.783018,40.806870,33.357036,-36.744922,41.108618,33.156479,-36.712784,40.690801,32.163785,-36.703098,39.182538,34.752957,-36.511887,40.460868,34.426588,-36.505111,42.014023,32.039397,-36.238516,38.124572,35.821409,-35.999649,42.525996,33.790764,-35.627225,38.382018,36.015678,-35.433357,37.871270,36.338028,-35.404916,42.220525,34.531215,-35.286927,41.409949,35.023320,-35.209984,41.867242,35.129717,-35.203873,42.086021,35.316464,-37.785625,51.812642,28.501636,-37.752616,52.400396,29.410924,-37.690327,51.399843,29.639005,-37.640366,51.427870,30.559956,-37.560128,51.835454,34.140915,-37.524319,50.166023,28.881667,-37.504820,50.968413,33.508849,-37.487091,51.487033,33.780820,-37.440744,48.659825,35.721806,-37.358627,48.595435,34.224563,-37.343780,49.211598,32.249321,-37.324954,48.779286,32.265177,-37.313474,48.599953,32.282671,-37.170011,48.734775,26.976526,-37.147798,52.340355,33.069976,-37.092184,43.626672,28.882912,-37.089603,48.627947,26.680512,-37.084156,50.762329,32.196612,-36.988527,47.999458,27.768482,-36.979170,48.237442,29.662998,-36.962562,48.393514,26.391822,-36.957267,43.159947,29.805646,-36.860579,46.738906,33.252912,-36.833254,45.932670,26.110698,-36.787555,43.036032,30.702710,-36.746529,45.528517,28.871141,-36.417495,44.022829,32.016784,-36.353346,45.931583,33.481674,-36.074606,42.950987,33.534171,-35.743416,44.563539,34.996634,-35.662441,43.447265,33.831334,-35.658603,44.161459,34.877063,-35.620450,44.115095,34.239038,-35.550966,43.694105,34.968437,-35.422140,43.164758,35.124503,-35.287310,42.705533,35.902853,-37.933340,54.288103,30.035094,-37.917784,56.986412,30.518765,-37.883667,55.336680,30.623370,-37.877772,56.430630,31.184911,-37.873945,52.989497,30.573943,-37.871417,53.032825,31.466067,-37.849146,53.153526,29.990586,-37.842533,56.521733,30.994385,-37.806442,56.706183,33.458932,-37.803677,53.114262,32.337712,-37.794019,53.345833,32.498609,-37.754258,56.507145,33.534647,-37.749351,62.335515,29.498247,-37.729644,59.524450,31.851562,-37.661926,57.786290,33.726729,-37.640383,62.599068,29.650719,-37.635712,53.916601,33.067364,-37.587911,54.137506,33.219082,-37.578529,60.071433,33.753500,-37.574284,59.140341,33.562826,-37.555304,54.252774,35.390800,-37.537098,62.111437,30.725316,-37.338322,62.286766,31.786942,-37.232486,60.106124,36.069055,-37.231673,62.763696,31.588157,-37.213160,62.752959,31.876199,-37.188967,61.361346,34.213982,-37.183896,58.080451,35.094890,-37.154748,58.912920,34.877681,-37.149529,60.915751,34.522514,-36.957113,62.085843,35.450624,-37.509841,63.847244,28.657576,-36.911427,66.262052,26.715377,-36.700919,66.210440,28.451991,-36.343936,66.729342,29.785613,-36.261489,64.863065,33.675944,-35.799180,68.933165,28.012615,-35.641370,67.189957,31.279376,-35.528619,68.338188,30.270865,-35.511216,70.623926,27.182250,-35.453585,71.586093,26.786128,-35.338049,71.935692,26.574080,-35.124390,70.401715,28.581696,-35.097113,65.340182,35.737283,-35.070601,72.562047,27.726250,-35.062400,70.911941,28.328383,-34.988149,65.621719,35.675521,-34.985271,68.160889,31.346685,-34.967119,72.953242,26.902010,-34.857562,72.466681,28.193787};
			return value;
		}
		private double[] getCoordinate_9_21_point_40()
		{
			double[] value = {-34.845717,73.224673,27.024388,-34.603442,73.620905,28.186749,-34.529630,73.431785,28.617466,-34.179947,72.775223,29.117080,-34.106735,72.873166,29.180997,-33.963930,73.281148,29.378957,-33.346909,68.684395,35.976473,-33.219776,70.234676,33.027019,-32.216061,73.023052,31.750197,-31.877481,73.608085,31.745099,-31.671125,72.884396,32.986277,-31.189817,72.836539,34.156684,-30.998212,72.715969,34.739988,-34.193995,74.648000,28.139164,-33.834654,74.713144,26.426621,-33.798334,74.709899,26.640322,-33.394686,74.050969,29.955554,-33.293479,76.027175,28.971874,-33.260832,75.944377,26.805694,-33.174830,77.147106,26.377866,-33.174517,74.950126,30.156722,-33.032679,76.406028,29.139450,-32.831847,76.631895,27.554279,-32.800557,76.756416,27.229205,-32.782119,77.969082,26.438624,-32.758724,75.710946,30.241840,-32.732701,77.901816,26.633196,-32.674036,76.956050,27.361173,-32.630645,77.213278,27.897476,-32.502350,75.176337,30.600547,-32.314774,75.995196,30.609153,-32.007385,74.968577,30.755160,-31.880534,78.904211,27.039135,-31.399392,79.188685,28.857935,-31.341371,79.134856,29.145969,-31.044711,78.305411,30.459429,-30.899120,80.471311,27.426007,-30.861003,80.449526,27.817139,-30.788524,75.857687,31.343508,-30.676837,78.196375,30.929354,-30.567537,78.039715,31.117466,-30.394286,75.691928,32.041263,-30.208173,76.206920,31.801387,-30.197609,77.400453,31.495987,-29.686689,77.603863,31.747599,-29.364204,74.564863,35.485855,-29.336162,76.911088,33.332910,-29.324872,74.994744,35.007995,-29.221907,82.433474,28.456054,-28.785972,80.209873,31.509750,-28.779786,75.225147,35.639095,-28.603873,77.626844,33.853452,-28.411566,74.416153,36.207658,-28.405808,80.596717,31.580781,-28.294516,82.438769,30.037124,-28.214851,75.797277,35.818847,-28.028277,78.099558,34.293410,-36.244304,-137.196783,41.708211,-34.223238,-138.057460,37.337256,-32.018652,-136.533155,45.853024,-31.644747,-137.623752,40.021783,-30.430103,-137.555893,40.550270,-29.527908,-138.352930,36.372803,-29.031001,-137.057462,43.426031,-28.885720,-136.720396,45.263141,-37.458061,-84.713696,39.530903,-37.339397,-92.032039,36.688407,-36.450218,-90.585447,36.776305,-34.110147,-83.270222,36.733234,-33.974754,-82.996384,36.723130,-37.735490,-82.849244,40.909017,-37.729906,-74.164774,36.428763,-37.311751,-75.704677,37.231836,-36.768016,-78.538719,37.961441,-36.692000,-77.062863,37.247252,-36.319894,-81.816567,39.163185,-36.258723,-82.620963,39.311510,-35.974326,-81.809259,38.671520,-35.874558,-82.384653,38.885025,-35.366105,-82.837697,38.235454,-33.695039,-82.837257,36.426286,-37.479901,-4.971295,39.510524,-37.153236,-4.306884,41.032731,-36.694954,-3.359695,42.994536,-36.576163,-3.032868,43.717376,-36.044871,-3.800847,39.242349,-36.001192,-2.275084,45.362726,-35.618607,-3.728672,36.960359,-35.352730,-3.459043,36.611370,-35.326736,-2.936439,43.369968,-34.890517,-2.584463,44.795609,-34.646685,-2.342094,36.879231,-34.465540,-1.954579,37.165703,-34.406261,-1.997210,46.595923,-34.353473,-2.271189,45.326224,-33.976930,-2.007086,46.374491,-33.696149,-1.295270,43.360584,-32.657584,0.639439,41.089990,-32.607321,1.287892,39.257569,-31.965983,3.425133,36.608913};
			return value;
		}
		private double[] getCoordinate_9_21_point_41()
		{
			double[] value = {-31.775864,2.272117,41.053870,-31.102447,5.382084,37.164161,-30.656915,1.541637,45.761638,-30.571228,6.563597,37.593272,-30.017472,7.586246,38.197552,-29.017949,8.549129,40.568416,-28.901927,3.921001,46.152581,-31.005790,21.595817,41.335160,-30.600155,21.421523,39.913350,-29.878398,20.832024,41.593905,-29.809450,21.078432,41.897899,-29.426971,21.077582,42.773491,-29.117851,20.779986,42.301805,-29.031390,20.441959,43.228332,-28.857588,20.234743,41.660446,-28.719941,11.442823,37.537149,-28.678051,11.735758,37.290130,-28.581747,19.864650,40.712458,-28.484084,19.828414,40.615096,-28.467449,19.760506,40.828549,-28.394815,20.639103,44.995033,-28.325993,20.207578,39.273334,-28.289737,20.769022,36.614851,-28.246489,21.438320,45.561707,-28.233048,19.984144,42.416286,-28.166041,19.878484,41.715141,-28.138313,19.543846,40.694994,-28.132489,19.770557,43.975314,-27.882624,19.704598,41.934763,-27.768520,12.375451,39.977489,-27.741575,20.191214,37.294596,-27.697776,19.495087,41.626320,-27.626162,19.449199,41.819128,-27.533021,19.526743,39.128081,-36.038933,30.233742,37.263000,-36.012876,28.694926,37.101723,-35.732956,31.987375,37.304981,-35.466062,31.914814,39.788443,-35.457577,31.809701,38.934025,-35.424756,28.319565,39.450652,-35.382373,28.722257,39.978594,-35.358943,31.096243,38.390612,-35.328072,31.551307,38.194342,-35.320438,31.774607,38.099172,-35.223299,27.782575,39.093497,-35.198676,27.453920,37.254737,-35.185934,27.554391,39.304516,-35.070036,30.589793,41.864286,-35.008403,27.893418,37.787555,-34.888400,27.643105,38.483451,-34.783063,27.396137,38.476675,-34.666830,26.305087,37.112486,-34.423039,31.367553,42.941158,-34.414190,27.095243,40.876712,-34.357614,26.432045,40.548281,-34.275104,28.805448,42.846125,-34.061694,30.052065,43.395868,-34.005265,25.696912,37.458203,-33.932185,29.738879,43.601369,-33.823343,24.686275,37.024948,-33.619979,24.751598,40.838611,-33.596780,26.456003,43.402688,-33.589330,24.357746,40.515012,-33.409609,28.400427,44.564299,-33.013976,23.859109,37.170002,-32.971431,23.807372,37.094186,-32.928568,25.391998,43.623730,-32.907151,26.559963,44.479516,-32.868279,24.336582,38.900278,-32.603002,24.514223,42.672590,-32.110224,25.453671,44.421535,-31.813168,23.499857,42.408541,-31.330447,24.165304,46.195748,-31.141483,21.755254,41.425090,-30.443044,23.310485,46.395535,-30.276725,21.675601,36.787347,-30.153181,21.701423,44.561858,-30.119812,22.152937,44.818456,-36.612283,33.918050,36.635627,-36.240196,34.507486,36.728189,-35.294837,32.578331,38.539354,-35.278864,33.411017,37.641768,-35.256388,33.090968,38.526106,-35.223456,41.845791,36.395492,-35.158997,40.921665,36.683230,-35.135006,35.133983,39.130074,-35.112173,38.090918,36.615229,-35.102532,39.918286,37.190659,-35.075169,39.634518,37.493520,-34.987747,35.646184,37.955712,-34.974138,36.074382,38.888007,-34.959011,32.089794,42.096384,-34.918166,33.545145,40.446669,-34.733621,33.985304,40.537857,-34.697180,38.316677,38.649838,-34.593195,37.629879,38.975371,-34.469880,34.805932,40.627405,-34.401399,41.496558,39.636674,-34.398317,35.087797,40.718684,-34.203925,36.258051,40.883593};
			return value;
		}
		private double[] getCoordinate_9_21_point_42()
		{
			double[] value = {-34.178713,36.825686,40.971985,-34.157409,33.090107,42.827232,-34.112851,42.340366,40.450471,-34.062796,40.022883,40.255571,-34.044068,42.293669,40.646425,-34.000059,37.061391,40.057511,-33.972101,38.389853,39.632308,-33.948145,42.328075,41.034479,-33.939521,32.283437,44.389278,-33.806847,38.226134,41.215652,-33.777652,35.158464,42.509601,-33.712463,33.993725,43.728219,-33.624434,37.491619,41.731121,-33.620294,34.546962,43.714241,-33.500407,41.202289,41.310379,-33.472334,39.469000,41.192109,-33.460819,35.278347,43.383628,-33.425184,39.044977,41.376418,-33.375394,36.779767,42.505882,-33.333267,38.859937,41.578653,-33.274504,32.261404,45.187855,-33.235866,38.810793,42.747084,-33.226329,38.457861,42.151373,-33.085538,40.743918,41.984831,-33.063177,32.490364,45.666534,-32.975061,38.432728,43.541196,-32.806210,36.185375,44.756175,-32.790008,34.144488,45.348984,-32.644789,41.525199,42.336028,-32.615562,36.242994,44.837636,-32.577442,41.531266,42.412742,-32.470046,41.332614,42.514215,-32.431337,42.396437,45.018356,-32.409021,41.677554,42.617219,-32.375746,38.099410,44.218534,-32.315953,35.320760,46.606138,-32.244429,40.468823,42.890243,-32.194474,41.151890,43.057321,-31.993005,41.003064,44.206497,-31.904059,40.753651,43.791375,-31.753685,38.012315,45.028336,-31.546744,38.393922,46.037067,-31.357962,41.473163,45.930301,-31.247822,38.671232,46.180312,-30.693607,39.847891,46.278036,-30.464809,40.530685,46.713586,-37.433686,51.103565,39.033909,-37.431944,49.641478,38.431133,-37.370350,51.667502,37.940455,-37.348995,51.562048,39.608397,-37.313575,48.312447,37.584575,-37.300477,51.133235,40.339941,-37.297466,51.787970,40.621479,-37.287862,48.713754,38.411865,-37.266381,52.669412,41.081759,-37.258670,52.456228,41.031477,-37.201381,52.327101,36.480728,-37.194058,52.113404,36.428539,-37.154544,47.729037,36.825998,-37.029888,47.644966,37.110337,-37.016254,52.760517,37.012778,-36.952683,52.698406,37.395189,-36.917293,48.409623,38.417833,-36.898556,50.352743,40.522413,-36.777595,47.611353,37.398529,-36.727523,49.715953,40.083587,-36.397224,47.605488,38.078157,-36.385221,46.303857,37.371190,-36.268386,46.565160,39.031484,-36.243676,45.749582,36.999910,-36.173302,47.454123,40.063400,-36.167271,49.138768,39.957479,-36.129655,47.788760,39.412363,-35.967839,46.191894,39.425963,-35.958010,48.716936,40.013187,-35.928626,47.984300,40.920568,-35.919419,49.094169,40.313193,-35.786322,50.523921,41.455309,-35.769686,49.080505,40.763493,-35.680082,49.914975,41.282656,-35.652926,49.560032,41.381519,-35.649469,51.740615,42.275901,-35.638090,48.827973,42.014554,-35.319249,52.660900,44.118416,-35.275099,47.817132,41.738616,-35.057251,48.623355,42.996552,-34.953276,42.651848,37.461220,-34.942592,52.150320,45.117132,-34.919381,48.172134,42.934995,-34.720528,45.434717,40.848391,-34.676045,45.817383,41.019246,-34.668593,49.134626,44.588488,-34.608685,46.855250,42.283679,-34.519970,43.265561,40.114751,-34.362835,45.934827,42.176098,-33.842747,44.053968,43.704009,-33.821816,42.671841,41.243539,-33.635446,43.259726,41.481060,-33.523898,43.974818,44.291063,-33.497457,43.314886,41.860573};
			return value;
		}
		private double[] getCoordinate_9_21_point_43()
		{
			double[] value = {-33.483344,51.764737,46.321756,-33.471550,43.582031,44.221661,-33.410309,43.394810,43.160604,-33.115746,43.467725,44.532689,-33.076154,42.540621,42.171945,-33.009258,47.465370,45.384135,-32.950275,42.734426,42.828677,-32.902044,44.524894,44.614785,-32.779631,43.846414,44.745763,-32.475882,49.506579,46.274335,-32.426710,50.681838,46.680723,-31.684119,42.570222,45.434985,-31.436342,42.531549,45.742352,-37.316153,56.788129,37.586420,-37.244130,53.556727,39.543363,-37.158625,56.627087,38.045708,-37.019351,55.026822,40.302224,-37.013302,54.969870,41.751638,-36.893743,57.443121,38.312661,-36.841990,58.512641,38.183150,-36.721713,56.960202,40.822404,-36.614242,55.256318,39.535888,-36.603991,57.326740,40.808610,-36.589875,56.915667,40.571528,-36.552164,62.162244,36.484178,-36.443718,53.225650,42.541902,-36.440557,56.654342,40.157593,-36.388828,55.282913,43.156246,-36.383151,58.407796,41.064490,-36.331296,56.695690,39.973233,-36.328709,58.400739,41.418614,-36.302729,54.955932,43.239831,-36.224233,56.549541,39.444395,-36.187897,55.587911,43.425160,-36.152266,59.245605,41.338197,-36.117359,59.334686,40.767108,-36.009702,60.493319,38.181626,-35.965704,59.679806,41.626416,-35.941049,58.124713,43.013880,-35.871452,56.818989,43.702403,-35.813486,60.343799,41.333753,-35.791630,58.443862,39.681379,-35.737535,56.940615,43.856598,-35.732347,58.897495,39.172764,-35.719523,60.725039,41.224909,-35.696216,63.278959,36.749069,-35.649540,61.117983,40.076039,-35.613467,60.470010,39.817126,-35.520032,61.296568,38.228469,-35.494086,60.034331,38.989593,-35.483175,54.132293,43.517171,-35.470489,61.552383,41.031241,-35.451840,59.313749,43.492185,-35.369500,60.286933,43.023556,-35.314167,61.997469,39.024771,-35.295709,58.142389,44.166757,-35.223947,56.794347,44.227529,-35.183885,55.055947,44.111609,-35.117355,56.685589,44.340220,-35.040035,56.867297,44.444727,-34.961017,56.011997,45.352204,-34.909483,56.329510,44.744955,-34.888572,57.002597,44.739119,-34.863355,60.012135,44.218837,-34.645516,57.387416,45.754611,-34.515592,62.290450,43.078937,-34.513637,61.224058,43.972222,-34.416982,61.256719,44.267229,-34.300408,60.515004,45.037722,-34.286357,62.628579,43.200310,-34.286270,60.613062,45.008305,-34.266539,62.110239,43.880975,-34.060269,57.036054,46.606397,-33.963272,61.924800,44.652874,-34.510765,64.938062,39.531482,-34.020640,66.102863,39.197660,-33.437668,63.564798,44.198056,-32.992324,68.071977,38.391246,-32.504224,64.667470,44.102446,-32.420159,64.873721,43.875335,-32.234356,66.795311,41.191159,-31.917914,64.554310,44.443536,-31.909738,69.248667,37.941850,-31.801143,64.898621,44.045994,-31.785495,68.779006,38.645192,-31.515674,69.850908,37.388151,-31.406568,67.879020,40.033210,-31.406295,65.239245,44.044201,-31.402865,69.165255,38.233941,-31.203285,68.150894,39.818653,-31.089233,67.988146,40.253421,-31.074946,67.691265,40.803827,-31.073767,64.140411,45.738105,-31.010743,67.492202,41.398628,-31.006288,65.599683,44.448013,-30.863930,67.612081,41.900336,-30.855840,71.011021,37.121431,-29.797451,71.314372,37.512583,-29.591960,66.600888,44.521457,-29.517810,71.416050,38.261962};
			return value;
		}
		private double[] getCoordinate_9_21_point_44()
		{
			double[] value = {-29.387000,65.443774,45.609981,-29.217110,69.589875,41.899917,-29.162475,69.679002,41.844408,-29.040868,70.715102,40.744088,-29.012883,66.289875,45.632690,-28.967565,71.219765,40.253892,-28.842517,66.566426,45.881010,-28.612009,68.297983,44.302346,-28.584697,67.941008,44.771051,-28.454584,66.741560,46.531782,-28.344407,73.437460,38.127023,-27.713273,67.741153,45.845458,-27.690128,67.881331,45.644281,-28.328189,74.039373,36.698031,-36.030089,-135.693041,49.846533,-37.701070,-86.413954,56.077031,-36.531610,-84.134536,55.527965,-37.506661,-73.285285,51.182395,-37.182932,-80.865449,52.798613,-37.001458,-78.610407,53.137393,-36.084377,-78.360868,53.985367,-35.339652,-80.005926,53.841460,-35.107750,-79.795837,53.982017,-34.691593,-80.267834,54.590078,-34.605126,-81.199605,55.519749,-34.486871,-73.811977,54.128796,-34.466783,-73.139232,54.023210,-34.117355,-80.980233,55.796205,-33.724902,-73.070529,54.919382,-33.658659,-73.062945,54.986444,-33.145886,-77.945247,56.443425,-32.886739,-72.497782,55.657456,-32.590934,-78.037991,56.820094,-32.342411,-78.671172,56.469610,-32.303403,-78.201916,56.909543,-31.820541,-78.433802,57.057039,-31.442937,-78.951857,57.033186,-37.382929,-66.751770,54.453644,-37.302664,-67.967160,53.330567,-36.952545,-69.632747,52.586672,-36.642953,-69.651304,52.926981,-36.620378,-67.235326,54.901290,-35.678461,-67.152213,55.908884,-35.343573,-72.369169,53.189900,-35.325860,-68.775863,54.931103,-35.290187,-69.863020,54.231267,-35.222676,-67.096636,56.626374,-34.625220,-67.654311,56.604667,-37.922555,-8.072717,53.752870,-37.856861,-0.916389,50.982990,-37.687855,-3.349565,51.810290,-37.585949,-7.461097,53.246142,-37.315120,-7.097461,53.318247,-36.955962,-6.571201,53.428742,-36.506295,-1.232085,52.651281,-36.159190,-7.815099,56.985424,-36.113207,-5.993143,54.366972,-35.950759,-0.314489,47.781470,-35.885553,-7.485610,56.071052,-35.536756,-7.386907,56.511919,-32.847165,-1.404566,48.423000,-32.297146,-1.244651,48.444454,-31.107429,-0.503521,49.266288,-30.247691,0.188389,53.117202,-28.900433,0.092184,52.772458,-28.104573,0.241335,54.156162,-27.947447,0.436302,54.971458,-27.848706,0.324442,54.160883,-37.950369,1.025645,48.842320,-36.659356,1.389230,50.693781,-36.039309,1.502626,51.710343,-36.020115,1.386045,50.281581,-35.900781,1.604258,51.287272,-34.912439,1.471734,53.548729,-34.252297,1.473622,54.360087,-33.219537,2.234217,54.837106,-31.704895,2.558681,56.566890,-31.333404,2.729974,56.588195,-29.955260,1.461203,47.332717,-32.704222,29.783562,46.803338,-32.144989,31.982596,47.352215,-32.044729,31.780589,47.408414,-31.584585,26.820621,48.119349,-30.898939,24.115234,47.134854,-30.714244,28.197513,48.788170,-30.451814,31.943961,50.046127,-30.357363,23.904846,47.846497,-30.196066,31.916717,49.143408,-30.162956,31.562512,49.513562,-30.127367,31.578646,49.368556,-30.017215,23.178686,46.990730,-29.891185,30.422489,50.613298,-29.813013,27.025049,49.635292,-29.120313,30.910806,51.746469,-28.952104,30.144937,51.993504,-28.920484,28.362424,49.859694,-28.815955,28.545054,50.512851,-28.801890,30.257510,52.097110,-28.649939,27.788371,50.007056,-28.340247,25.202728,50.331322};
			return value;
		}
		private double[] getCoordinate_9_21_point_45()
		{
			double[] value = {-28.048882,24.305610,50.314345,-27.841892,27.057603,50.820214,-27.806058,24.246380,50.418389,-27.759106,32.068506,51.627771,-27.572382,26.861475,52.168298,-32.364890,33.504517,47.052435,-31.880156,35.239285,47.365992,-31.752872,36.405519,47.093476,-31.519243,34.711988,47.580908,-31.056047,36.355592,47.507187,-30.906882,32.806620,47.681477,-30.851123,34.943538,47.816295,-30.563441,32.797002,48.027912,-30.442249,33.428688,48.629612,-30.391725,38.189448,47.613399,-30.372550,39.130928,47.259477,-30.357808,41.373753,46.940522,-30.304004,40.813413,46.986829,-30.129118,34.482435,50.428476,-30.123056,32.604125,50.642950,-29.485110,42.175841,47.642595,-29.292554,35.965638,50.717216,-28.454217,38.237849,50.335031,-28.270686,32.636743,51.225598,-28.254334,35.287986,50.927218,-27.949678,35.939765,50.902831,-27.917121,33.196634,51.242978,-27.762597,35.542667,52.016977,-27.658518,38.982648,50.322269,-27.653925,34.491391,52.443008,-27.537073,32.713957,52.527778,-31.357426,52.165310,49.453275,-31.123448,49.536555,49.065407,-31.065764,51.765755,50.325465,-30.956623,51.223460,50.348554,-30.691477,51.919824,50.908939,-30.621266,48.262223,47.977209,-30.519714,48.117227,50.410512,-30.387398,48.753742,51.292724,-30.313937,48.802388,51.493403,-29.917412,45.247516,47.285073,-29.910319,49.041265,51.829508,-29.898360,45.908614,49.411155,-29.835186,43.954891,47.015001,-29.789256,43.216491,47.107279,-29.761634,49.941037,51.913464,-29.621592,46.719754,51.514385,-29.484877,43.060702,47.307617,-29.388034,51.495154,52.963157,-29.377499,51.393831,52.948671,-29.371703,50.105806,52.616070,-29.371264,46.593940,52.226852,-29.359582,47.352578,52.518271,-29.192901,45.068413,48.037130,-29.148479,50.755389,53.096142,-29.015931,45.144609,48.281196,-28.720132,44.558580,48.346996,-28.657163,45.658682,52.683575,-28.574858,49.208610,53.376551,-28.410916,47.692527,52.790652,-28.363119,46.796836,52.973200,-28.342212,46.535035,53.042501,-28.177349,43.861471,50.986053,-27.876677,43.679839,51.633072,-27.767322,43.529288,50.838800,-27.737040,45.848712,53.339625,-27.669148,43.221531,49.372489,-27.641383,43.583415,51.787323,-33.810712,57.087050,46.843723,-31.486672,56.282726,47.937352,-31.413375,57.982058,47.902758,-31.229706,53.990423,47.968054,-31.138390,54.687698,48.082296,-30.928843,54.814317,50.740427,-30.837111,57.667781,48.139614,-30.829019,55.936630,49.800035,-30.701325,56.076266,50.826041,-30.564808,57.373713,48.293999,-30.450430,58.230384,48.196293,-30.177777,57.401316,51.185422,-30.098537,57.821036,49.010110,-30.090310,58.487619,48.313615,-30.084330,56.358281,51.780624,-30.053644,57.774631,51.198567,-29.692945,60.331566,48.202787,-29.614632,59.426158,48.631393,-29.613008,59.702182,48.479241,-29.550363,59.257034,51.182906,-29.116534,63.307488,47.789567,-28.674142,53.679583,53.643397,-28.627506,56.445597,53.638624,-28.313868,54.478635,53.798854,-28.274684,56.059050,53.856289,-28.201778,54.313502,53.815939,-28.093039,55.265211,53.905705,-27.737627,53.077949,53.701685,-29.730460,63.555413,46.923580,-28.465712,65.185322,48.423643,-28.426282,64.283478,49.349129,-28.266671,66.664007,46.909195};
			return value;
		}
		private double[] getCoordinate_9_21_point_46()
		{
			double[] value = {-37.467984,-132.945381,64.471655,-34.035445,-133.635927,61.207851,-33.724277,-134.056706,58.980452,-33.120620,-133.461393,62.271743,-31.652216,-134.212567,58.417325,-29.975410,-133.716831,61.315559,-29.543866,-133.785511,61.002700,-29.402428,-133.629098,61.864983,-29.386982,-134.100004,59.327595,-37.584767,-97.649699,65.340727,-36.668677,-96.462910,65.757633,-36.655023,-100.735985,67.019901,-36.141832,-96.671846,66.347276,-36.050429,-93.983794,65.464205,-35.811112,-97.017995,66.747946,-34.892625,-96.277839,67.320429,-36.911123,-90.587643,63.099414,-36.343576,-89.610143,61.908821,-34.928029,-88.189872,60.782308,-34.714800,-90.557066,65.281184,-34.434273,-84.385592,57.557263,-34.100013,-90.663138,65.965638,-34.056731,-90.075634,65.338421,-34.047433,-88.099743,61.570960,-33.576455,-89.297320,64.381792,-32.924118,-90.268491,66.703177,-32.754064,-87.658792,62.247234,-32.738938,-88.362226,63.426106,-32.562401,-88.065686,63.085914,-32.454962,-86.711304,61.350124,-30.889149,-87.676495,64.185503,-32.522793,-80.895833,57.149640,-31.099879,-75.539060,57.593757,-30.628259,-80.878521,58.745693,-29.828972,-82.099973,60.038954,-29.805733,-77.876515,59.005436,-29.475551,-80.253538,59.360042,-29.266781,-80.565227,59.749837,-29.252127,-79.256397,58.799172,-29.090707,-77.230015,59.783248,-28.206955,-82.271986,61.542624,-28.206118,-81.589435,61.148569,-37.762405,-63.657348,59.759860,-37.224069,-63.704255,60.375731,-37.184934,-65.094613,57.297928,-37.152389,-63.267677,61.437244,-36.976102,-64.478118,58.560632,-36.544880,-62.966136,62.754086,-36.224752,-64.284710,60.049426,-35.382408,-66.279178,57.371172,-34.767575,-66.789740,57.496352,-34.557826,-63.444454,63.803950,-33.622478,-67.272898,58.231583,-33.614777,-68.089950,57.374613,-33.368701,-65.021020,61.467575,-33.193427,-61.975089,67.253860,-32.850141,-66.176037,60.536828,-32.770370,-66.633893,59.889218,-32.512989,-65.340702,62.112404,-32.317133,-66.215647,60.758432,-32.275954,-67.392386,59.511377,-31.792593,-64.367898,64.551205,-31.652233,-66.669914,60.805762,-31.556949,-65.877135,62.048421,-31.062505,-66.383810,61.828032,-31.014910,-68.773374,59.392462,-30.404114,-66.874323,61.702418,-30.031660,-65.714973,63.709674,-29.976756,-69.041799,60.159527,-29.903572,-66.431736,62.980897,-29.350017,-70.700047,59.703568,-29.195053,-67.044988,62.749675,-28.795967,-70.389627,60.235114,-28.263444,-70.431281,60.777425,-28.168341,-66.831129,63.885819,-28.131997,-67.613376,62.975170,-28.120818,-70.959582,60.609532,-28.069142,-65.054794,66.368269,-27.864647,-68.457536,62.376442,-27.820034,-71.107491,60.695752,-27.580000,-65.564157,65.960957,-37.087551,-61.838029,64.381599,-36.500754,-61.239737,66.000351,-35.730745,-61.159674,66.712216,-34.397346,-61.669067,66.912509,-36.657965,-24.611759,67.205561,-37.929051,-19.992655,64.924309,-37.817131,-14.066807,62.002620,-37.774825,-12.359688,62.075582,-37.656725,-18.923112,61.969327,-37.379262,-13.142122,62.481381,-37.220221,-10.170875,62.686104,-37.187046,-19.920714,66.042939,-36.708485,-19.610978,66.339673,-36.530059,-20.078522,67.146406,-36.130474,-19.208159,66.149673,-36.005585,-16.708042,63.732427,-35.238605,-18.414683,64.985423,-35.084238,-18.114171,64.802612,-35.005883,-17.504292,64.683363};
			return value;
		}
		private double[] getCoordinate_9_21_point_47()
		{
			double[] value = {-34.931190,-18.486785,65.871919,-34.694108,-17.939904,65.196928,-33.301631,-17.697627,67.119466,-33.231233,-16.746267,66.527340,-33.191986,-17.307689,66.833828,-32.159939,-16.131887,67.398552,-37.463245,-8.578986,61.450876,-36.748507,-8.077542,61.508143,-36.251909,-7.829747,60.014026,-35.183357,-7.426953,57.481304,-34.138709,-7.144459,59.830199,-33.774583,-6.334462,57.855114,-33.656897,-6.303090,58.001444,-33.437383,-7.151156,64.983229,-33.388896,-6.508246,58.690542,-32.979930,-7.112106,65.466054,-32.713672,-2.518243,57.666924,-32.610036,-6.427172,60.029968,-32.437514,-3.635408,58.259470,-32.189863,-6.068301,59.986236,-31.951646,-3.519379,58.807299,-31.587909,-6.032197,61.108245,-31.355556,-5.161820,60.129506,-31.186497,-5.228502,60.373354,-30.558665,-5.702222,61.933538,-30.445878,-4.504814,60.699660,-29.743189,-5.881804,66.466885,-29.414189,-5.079682,62.358249,-29.373416,-5.234764,62.728067,-29.181803,-1.323308,60.928920,-29.163446,-0.435266,60.646376,-29.140732,-5.099675,62.758328,-29.052074,-3.678549,61.754272,-28.991948,-5.904745,67.468011,-28.947152,-5.705084,66.886082,-28.780127,-5.523591,65.181441,-28.573885,-5.538072,66.125231,-28.542006,-1.149514,61.405332,-28.524764,0.390340,60.880934,-28.025919,-5.013592,64.057647,-27.857141,-3.756407,62.710510,-27.594154,-1.333024,62.226780,-31.559313,2.131946,57.309989,-30.828567,2.668020,57.581647,-30.334074,2.893067,57.188300,-30.167639,2.476950,58.481335,-29.495932,2.868798,57.401028,-29.217945,2.369235,59.519754,-29.103697,2.974825,57.957643,-28.542094,3.091122,58.644491,-28.325222,2.554503,60.239941,-28.040528,3.073116,58.810261,-27.910098,3.159738,59.356846,-27.750094,3.060162,58.921444,-27.741979,1.364943,61.060598,-27.731043,2.675431,60.590721,-27.604242,2.462056,57.881673,-27.598242,2.192208,57.498173,-36.699416,-124.794791,72.837625,-36.185997,-129.542548,74.257129,-35.822250,-132.176772,68.837691,-35.146342,-129.354486,75.159017,-33.687148,-130.447102,76.606708,-33.616080,-131.956598,70.320296,-33.053110,-130.784593,76.716742,-31.219155,-131.922276,70.826836,-30.299595,-131.078783,75.499295,-28.575811,-131.761488,72.048260,-28.382894,-132.090506,70.299494,-37.169485,-116.966711,70.512040,-37.111012,-117.321979,70.643538,-34.013357,-118.419331,73.541036,-30.549328,-121.663541,77.148979,-35.374886,-108.178349,70.136249,-32.456489,-112.465530,73.415046,-31.354564,-113.665693,74.503203,-30.897938,-113.884724,74.903592,-28.376136,-112.536186,76.485677,-27.903577,-107.518681,75.773130,-27.764642,-110.481562,76.505057,-35.323640,-102.310928,68.654719,-35.146042,-101.185530,68.493014,-35.110173,-101.435111,68.587910,-34.743873,-101.601334,69.027202,-34.109411,-102.160692,69.613288,-33.664055,-95.681494,68.236335,-33.117828,-99.752399,69.841386,-32.596149,-102.940243,71.144691,-32.438979,-102.150151,70.997874,-32.339138,-100.986664,70.785206,-31.289742,-101.888983,71.857938,-31.173793,-100.101842,71.505044,-30.739987,-102.130565,72.376578,-29.565545,-101.427736,73.085455,-29.358372,-102.461894,73.530124,-29.033690,-99.780008,73.116605,-28.516468,-100.177308,73.664146,-27.717838,-101.686993,74.716520,-27.561434,-100.263180,74.449130,-31.204245,-89.684085,67.600765};
			return value;
		}
		private double[] getCoordinate_9_21_point_48()
		{
			double[] value = {-30.162622,-90.536659,69.392814,-30.056262,-89.817328,68.893305,-29.181010,-90.351567,70.156172,-28.962861,-92.222859,71.018657,-28.300741,-89.770777,70.480497,-28.213487,-89.115112,69.664607,-27.601523,-89.194301,70.373531,-29.130533,-62.526134,69.537122,-29.085898,-62.412107,69.756305,-27.887881,-64.230930,67.606864,-37.945430,-53.673501,74.482140,-37.751222,-54.138658,74.204765,-37.513092,-51.733231,75.419945,-37.408570,-54.639721,73.865824,-37.349942,-56.509259,71.588104,-36.958388,-54.713745,74.034039,-36.653986,-58.443969,69.640046,-36.073837,-53.502796,75.967424,-35.962384,-52.927179,76.466716,-35.937920,-53.013913,76.436010,-35.757976,-51.777777,76.938592,-35.046789,-52.202737,77.458800,-35.006751,-57.392876,72.377139,-34.976624,-55.948115,74.078382,-34.934889,-55.868903,74.178934,-33.592519,-60.811743,68.748942,-33.512513,-60.246809,69.522249,-32.614632,-54.361719,77.463583,-31.809163,-57.096822,74.945447,-31.136061,-59.528433,72.156930,-30.728773,-59.397534,72.701203,-30.085940,-56.357248,76.745658,-29.769960,-58.448646,74.449618,-29.630545,-59.925840,72.484997,-29.194074,-60.312453,72.401159,-29.104054,-59.851651,73.072308,-29.070663,-59.332243,73.684052,-28.524079,-60.281403,72.659000,-27.550687,-57.953144,76.309485,-37.434422,-43.673304,72.926211,-36.929646,-41.712486,73.566170,-36.798676,-44.321749,73.738422,-36.022041,-43.445635,74.335957,-36.015084,-46.508762,75.394029,-35.948776,-44.942915,75.046167,-35.883037,-41.924054,74.121477,-35.757588,-44.464580,75.053750,-35.360496,-47.548117,76.318814,-35.124167,-41.956715,74.702596,-34.878381,-43.206355,75.319524,-33.376981,-45.256767,77.514146,-33.352366,-42.548768,76.534403,-33.132858,-43.110452,77.094591,-33.084976,-42.313569,76.773873,-33.013776,-42.547659,77.023081,-36.727074,-36.758159,76.030614,-36.491047,-40.341064,74.473716,-36.320734,-36.387744,76.300818,-36.125194,-36.893597,76.350954,-35.890137,-41.018048,74.384573,-35.260822,-39.956776,75.089246,-35.069590,-39.993374,75.111760,-34.911541,-38.778962,75.844885,-33.558571,-40.739240,75.794968,-32.757476,-38.863921,76.221179,-32.326036,-39.678813,76.560866,-31.915769,-37.352041,77.128817,-31.841399,-36.792386,77.481126,-31.321961,-40.817777,77.891456,-30.338852,-36.568316,77.880354,-30.170919,-36.920035,77.814599,-37.945382,-24.853300,69.202626,-37.539935,-25.644566,72.601606,-37.403296,-26.470041,73.005519,-37.201135,-27.856834,73.651845,-37.079817,-24.974076,68.763641,-37.024579,-24.837249,69.409028,-36.461052,-28.974389,74.753707,-36.393579,-29.257735,74.856759,-35.830731,-24.411298,68.652497,-35.773291,-24.237029,68.521940,-35.769945,-24.474093,69.142288,-35.712753,-23.529345,72.434351,-35.646041,-24.363777,69.499655,-35.590758,-28.332948,75.256376,-34.920612,-23.867683,69.932941,-34.889252,-22.119737,69.451068,-34.789955,-25.195123,74.776788,-34.754994,-30.066231,76.573292,-33.887083,-26.084958,75.897082,-33.383500,-22.882846,71.080359,-33.294736,-22.577697,73.753416,-33.104401,-22.474642,74.093892,-32.882968,-28.145127,77.497094,-32.856684,-27.528139,77.233702,-32.790092,-22.455005,71.491012,-32.686484,-22.603889,72.682384,-32.399378,-25.257187,76.676717,-32.288625,-27.842406,77.783947,-32.108706,-22.017554,74.492903};
			return value;
		}
		private double[] getCoordinate_9_21_point_49()
		{
			double[] value = {-31.764276,-22.146812,73.221706,-31.714431,-22.098801,73.890320,-30.120619,-20.984477,74.008357,-29.941595,-21.131020,74.513612,-29.418309,-21.421646,76.899780,-35.112981,-19.257208,68.202666,-34.860258,-19.420127,68.767154,-34.729565,-19.985621,69.248590,-34.459241,-19.271410,69.156360,-34.448257,-18.780505,68.190673,-34.202180,-18.736018,68.476568,-33.698975,-18.394584,68.497616,-33.429139,-18.079564,67.928528,-33.269793,-18.856950,70.074590,-32.688681,-18.397750,70.128778,-32.336580,-18.269446,70.435862,-31.995972,-18.284048,70.902580,-31.916957,-20.095285,71.795145,-31.641746,-11.573578,67.606296,-30.561505,-16.045531,68.747000,-30.411574,-15.301702,68.616249,-30.186993,-9.872967,68.722922,-29.833576,-17.736600,72.861641,-29.606837,-17.245759,72.460183,-29.303758,-16.097469,69.976425,-28.874640,-13.925479,69.572851,-28.758198,-17.309071,73.506409,-28.098589,-16.140310,71.725449,-28.073609,-14.269167,70.139565,-27.922409,-19.506234,75.411411,-27.617759,-13.938457,70.442702,-30.903521,-8.659927,68.093462,-28.778267,-6.971505,69.034687,-27.588245,-6.517535,69.560367,-32.036080,-130.570367,78.008311,-30.135575,-129.993760,79.415831,-29.602958,-130.640787,77.954538,-29.431007,-130.601351,78.190057,-29.043751,-130.663391,77.907708,-28.083585,-126.239288,80.177529,-29.155976,-121.302895,78.118077,-32.356665,-52.314098,79.457893,-30.609250,-54.957344,78.067831,-29.810225,-51.684600,81.625744,-28.458485,-55.951508,78.217494,-28.023941,-54.131762,80.896526,-27.662172,-54.485485,80.770798,-27.557655,-53.836895,81.381249,-32.566439,-51.447925,79.537177,-32.477333,-48.466335,79.241484,-32.375215,-46.052250,78.654129,-32.361555,-48.919227,79.458833,-29.966339,-47.197561,81.280354,-29.672079,-48.377413,81.825425,-29.468344,-51.249337,82.119967,-29.199515,-45.876368,81.682468,-29.112860,-42.870090,80.733624,-28.790507,-45.277259,81.859164,-28.606728,-44.169201,81.638727,-28.549329,-49.673281,83.028007,-28.462733,-45.510937,82.239475,-28.221491,-43.654425,81.857007,-28.007178,-45.908065,82.789567,-27.743471,-50.110348,83.753742,-27.682938,-44.829254,82.857694,-30.941448,-33.715583,79.090338,-30.300796,-34.160150,79.062164,-29.965305,-38.898510,78.240539,-29.890940,-38.891911,78.298237,-29.841298,-32.500974,79.685520,-28.447373,-41.053202,80.653831,-28.126957,-39.513035,80.384237,-28.035850,-40.489325,80.838345,-27.774581,-40.581761,81.131194,-27.566679,-39.926129,81.103970,-30.838870,-27.284499,78.645506,-29.191876,-26.543535,79.539538,-28.197151,-22.288772,78.516096,-27.401323,-67.303136,-16.874454,-26.769972,-62.775329,-21.892000,-26.697188,-65.939314,-19.874194,-26.142083,-67.092589,-18.291156,-26.133808,-66.533147,-19.342288,-25.843630,-62.450435,-21.875390,-25.034162,-67.694865,-17.358927,-24.577067,-65.562084,-20.063549,-24.331822,-65.549655,-19.918853,-24.235452,-67.003246,-18.894650,-24.041740,-67.057922,-18.821163,-23.936845,-64.352202,-20.499730,-23.903417,-66.239712,-19.152005,-23.804136,-68.016964,-17.371134,-23.560908,-64.105123,-20.087178,-22.426990,-69.203659,-15.563086,-22.134620,-68.712631,-16.706469,-21.849839,-68.460592,-17.349246,-20.587550,-69.240766,-16.237287,-20.309156,-64.845267,-19.202330,-19.964780,-68.424803,-17.833916,-19.747658,-63.793355,-19.285986};
			return value;
		}
		private double[] getCoordinate_9_21_point_50()
		{
			double[] value = {-19.169336,-64.070994,-19.370040,-19.048428,-68.444738,-17.949533,-19.014896,-68.504084,-17.884175,-18.326704,-63.014874,-19.379161,-17.948851,-62.725598,-19.381731,-17.542256,-69.030401,-17.450154,-17.168470,-69.432763,-16.727855,-17.157620,-69.632346,-16.297492,-27.522853,-59.301598,-21.629848,-27.253658,-55.493615,-20.774145,-27.023439,-57.489469,-21.549276,-26.875407,-54.828406,-20.817120,-26.282847,-56.770919,-21.651360,-26.182405,-61.517563,-22.133461,-26.082881,-53.960139,-20.782841,-25.927296,-56.808374,-21.652761,-24.906279,-54.957716,-20.787668,-24.893593,-52.137658,-19.898441,-24.249627,-56.769241,-20.812603,-23.983304,-56.340319,-20.558437,-23.750633,-54.822853,-20.070835,-22.757417,-61.403674,-19.620388,-22.584370,-58.412754,-19.467384,-22.196151,-59.976492,-19.047303,-22.119058,-61.161536,-19.079740,-21.934659,-53.507020,-18.430693,-21.668569,-54.143418,-18.340095,-21.386348,-54.774512,-18.324082,-21.305981,-54.570786,-18.272237,-20.977534,-60.927761,-18.990447,-20.637747,-61.905247,-19.099597,-17.759477,-54.001067,-18.158750,-27.137525,-45.862763,-16.769172,-26.888360,-46.929617,-17.455330,-26.475261,-43.526709,-15.608932,-26.439491,-45.907716,-16.965581,-26.243330,-49.252801,-18.705025,-23.655690,-44.905789,-15.969681,-22.566871,-50.686294,-18.464164,-22.344659,-47.319245,-16.925728,-22.145948,-45.704539,-15.972412,-21.846218,-46.819778,-16.552591,-21.582521,-49.253007,-17.280190,-21.180213,-48.895718,-17.058668,-20.380448,-49.385202,-17.130802,-20.970657,58.684177,-16.105302,-20.728901,62.537154,-16.219619,-20.579011,55.809687,-15.774992,-20.574295,57.483742,-16.155434,-20.559868,58.513393,-16.356981,-20.149631,58.811549,-16.403329,-19.878632,56.383743,-15.899134,-19.494143,56.102620,-15.871915,-19.334398,55.230734,-15.804196,-18.967839,56.968995,-16.319782,-18.739237,57.097786,-16.566398,-18.700259,58.152084,-16.696906,-18.534100,61.709466,-16.751888,-18.492996,54.454498,-16.441472,-18.432681,60.551308,-16.927316,-18.367827,62.735025,-17.022433,-18.332008,60.538084,-17.118503,-18.322814,56.376830,-16.994209,-17.575450,59.496000,-17.574106,-17.569432,55.049061,-16.834945,-17.382248,62.609933,-19.694888,-17.358491,56.457402,-17.122939,-17.355474,60.540275,-17.752827,-17.314539,59.372180,-17.670220,-17.088000,55.416546,-16.967018,-20.761932,64.964701,-15.773289,-20.600326,63.765661,-16.098770,-20.474989,64.395875,-16.060222,-20.394711,65.098984,-15.898840,-19.828027,68.819454,-15.713843,-19.732307,70.522170,-16.021439,-19.604055,70.034512,-16.108134,-19.187933,72.180795,-16.339388,-19.049547,73.421054,-15.797423,-18.763336,65.838786,-16.556701,-18.537307,66.289793,-16.810628,-18.502835,69.327924,-17.619769,-18.472576,69.037289,-17.702088,-18.419819,73.536630,-16.601163,-18.156971,73.596171,-17.267798,-17.936807,71.282210,-17.416276,-17.905649,63.603419,-17.468019,-17.894747,64.270401,-17.571872,-17.696175,67.034205,-18.809441,-17.696096,63.822255,-17.834758,-17.638643,63.886115,-19.287386,-17.513759,65.197212,-19.422738,-17.478054,64.970972,-19.503136,-17.228111,63.581061,-19.920348,-17.121563,69.850695,-18.377352,-19.077037,75.215399,-15.940614,-18.963558,75.887122,-15.629457,-17.623874,76.914026,-15.570460,-26.954314,-70.511204,-5.217203,-26.645092,-70.054768,-8.465196};
			return value;
		}
		private double[] getCoordinate_9_21_point_51()
		{
			double[] value = {-26.577455,-69.089674,-12.258748,-26.469904,-69.035016,-12.648526,-26.097965,-70.497528,-6.724170,-24.819855,-70.728233,-6.992612,-24.771396,-70.312337,-9.512219,-23.484355,-70.694669,-9.452802,-22.163298,-71.393310,-7.872439,-21.767995,-71.753023,-6.763744,-21.451771,-71.610377,-7.945129,-21.451335,-71.462242,-8.472524,-20.286517,-71.216837,-10.502397,-19.899668,-71.753064,-8.895304,-19.489789,-72.090302,-7.935179,-19.440625,-70.933548,-11.663753,-18.663473,-71.608802,-10.247311,-17.256692,-70.050737,-15.419204,-17.080995,-71.144442,-12.581321,-25.951013,-42.563785,-15.029064,-24.929088,-41.263500,-13.902242,-22.390054,-42.297931,-12.929907,-22.365773,-43.521774,-14.358950,-22.092284,-43.799557,-14.424758,-21.920097,-43.506945,-13.986975,-21.891422,-43.750471,-14.226738,-21.638419,-41.113962,-11.007414,-21.099231,-43.596204,-12.650721,-20.922779,-43.116804,-11.742935,-20.577327,-44.265502,-13.508399,-20.004739,-44.679559,-11.980120,-19.723044,-44.752586,-11.731721,-19.157993,-44.905075,-11.401454,-19.061503,-45.421448,-11.645208,-18.865032,-41.392520,-9.039473,-18.213154,-41.871616,-5.358552,-17.774994,-42.291794,-5.399962,-17.773700,-42.038541,-8.458077,-17.709262,-47.414976,-14.867170,-17.709174,-46.838741,-11.694313,-17.687906,-46.703655,-11.531042,-17.601563,-46.178805,-11.211080,-17.591482,-42.605885,-9.031464,-17.517436,-43.000526,-9.405425,-17.425066,-42.468882,-8.705355,-17.423729,-42.132401,-8.138979,-17.418423,-42.368091,-6.568917,-17.366601,-42.790525,-9.067881,-17.289748,-43.673217,-9.739330,-17.279062,-42.614579,-8.777350,-17.138060,-42.193079,-7.732676,-26.674239,-34.783132,-8.944918,-26.320529,-38.501678,-12.309756,-26.277043,-37.431352,-11.304305,-25.756394,-35.882519,-9.536158,-24.722281,-34.653199,-6.185892,-24.330900,-35.030434,-6.491534,-24.250023,-36.704858,-8.999252,-23.908187,-36.009537,-7.921055,-23.603489,-35.816954,-7.088523,-23.465055,-37.145639,-8.723233,-23.322409,-36.943067,-8.358994,-23.184258,-38.188317,-9.560221,-22.297625,-37.103229,-6.909986,-22.132464,-39.999087,-10.400594,-21.844741,-39.677834,-9.819534,-21.270869,-38.675944,-8.299366,-21.075820,-39.340689,-8.770573,-21.024020,-39.491302,-8.914267,-20.849147,-38.712728,-6.569247,-20.731500,-38.810258,-6.624084,-20.667002,-38.819522,-6.869092,-17.390770,-0.067623,-5.231565,-17.159955,-4.072477,-5.372174,-18.044645,4.094263,-5.294087,-17.513997,3.761932,-5.434540,-17.162253,29.415338,-5.325946,-19.600181,39.353608,-5.363173,-19.510658,41.821408,-7.024706,-19.242571,38.786594,-5.654769,-18.705812,41.073665,-7.565640,-18.190580,39.461662,-7.284853,-18.043325,41.329347,-8.986397,-17.817476,40.679087,-8.636203,-17.769399,40.909009,-8.859965,-17.606831,36.323279,-5.565204,-17.362886,34.382801,-5.933588,-17.305582,35.807871,-6.081306,-25.739134,52.369160,-5.728495,-25.272180,52.818686,-7.011572,-24.948066,51.062974,-8.541536,-24.062475,49.151150,-6.681175,-23.836654,50.436777,-9.135903,-23.226042,52.147925,-11.832139,-23.095533,49.296244,-8.942284,-22.505295,47.513251,-6.102356,-22.482373,48.863294,-9.694692,-22.361269,50.804725,-11.268922,-22.162323,47.881494,-9.538388,-22.054647,48.785793,-10.805169,-22.050590,47.708307,-9.481920,-21.913481,48.173572,-10.494745};
			return value;
		}
		private double[] getCoordinate_9_21_point_52()
		{
			double[] value = {-21.754275,50.732255,-11.542971,-21.694768,49.114579,-11.627868,-21.629575,51.034974,-11.861888,-21.474794,46.926200,-8.853698,-21.388242,46.969272,-9.158062,-21.286875,46.340688,-7.506642,-21.151154,46.854127,-9.420265,-21.025815,45.168242,-5.170222,-20.798531,44.826737,-5.325586,-20.559961,48.339377,-11.958880,-20.417494,50.133344,-13.563385,-20.288441,45.164392,-7.608294,-20.052816,44.985670,-8.254653,-19.984646,50.358000,-13.827543,-19.625119,45.017511,-9.114126,-19.552638,44.137903,-8.296420,-19.542912,48.375365,-12.875674,-19.537945,44.892481,-9.165012,-19.524566,47.235993,-12.084877,-19.458747,45.699307,-10.000097,-19.446409,48.291888,-12.962977,-19.443072,43.819733,-8.249745,-19.355053,50.214889,-14.012334,-19.149262,47.074621,-12.114276,-18.957478,44.016461,-9.494981,-18.726790,52.011789,-15.312944,-18.024936,45.798961,-11.428271,-17.670537,43.124046,-10.378383,-17.559507,47.185537,-12.437116,-17.397509,43.659144,-10.918302,-17.110130,45.889036,-12.177702,-17.096481,44.406749,-11.412383,-27.505169,60.941086,-10.948166,-27.035372,56.954341,-10.202501,-26.922062,61.861841,-11.545738,-26.623564,60.760179,-12.241722,-26.474744,59.407467,-12.109905,-26.452738,60.922125,-12.374903,-26.141722,57.477813,-10.937189,-25.877929,55.908226,-8.728820,-25.647980,62.879639,-12.833227,-25.603007,61.998231,-12.806201,-25.286432,54.846392,-9.340843,-25.283998,54.373917,-9.086001,-25.212026,55.600640,-9.532337,-24.928443,54.076106,-9.121143,-24.898137,56.839839,-10.553026,-24.644435,55.337661,-10.321450,-24.502694,61.097096,-12.895979,-24.434115,53.406331,-9.461530,-24.417573,60.250744,-12.743872,-24.405026,58.320540,-11.910256,-24.261311,56.153942,-10.793707,-24.223047,53.299740,-10.186898,-24.183727,53.267499,-10.473556,-23.895926,53.663036,-11.870712,-23.891842,57.328252,-11.627336,-23.852216,53.761511,-12.795934,-23.726359,57.391320,-11.750823,-23.677198,54.025419,-11.741174,-23.665026,56.474838,-11.330091,-23.655341,54.986958,-10.756574,-23.616931,54.234597,-13.338811,-23.506290,56.077348,-11.193561,-23.406362,61.865879,-13.070362,-23.283024,62.447846,-13.127163,-23.036524,56.556902,-14.513553,-23.017468,57.442816,-12.253969,-23.014706,56.765472,-12.242826,-22.995051,57.805722,-12.412574,-22.909078,62.378028,-13.438368,-22.807305,54.995307,-14.400899,-22.798355,54.817053,-14.321765,-22.698761,60.772438,-13.431062,-22.615721,59.409187,-13.242792,-22.600983,61.211622,-13.631169,-22.565315,58.898710,-13.447855,-22.558697,58.435392,-15.019992,-22.544138,60.329230,-13.749497,-22.527294,59.265228,-13.594954,-22.522694,59.469497,-14.385589,-22.511429,61.361923,-14.165545,-22.477383,62.822842,-14.406225,-22.454423,62.984898,-14.418029,-22.404839,59.202921,-15.035156,-22.169719,63.137599,-15.059397,-22.045704,60.506774,-15.340875,-21.564629,62.595482,-15.440953,-21.412562,54.284809,-14.536648,-21.340715,55.464232,-14.911796,-21.111515,56.658459,-15.487361,-19.748956,53.265727,-14.936439,-27.444934,71.301597,-6.150755,-27.358319,64.476648,-10.477389,-27.315157,72.393587,-5.610642,-27.274695,72.152120,-7.119393,-27.269470,72.483323,-6.560135,-26.800311,68.439343,-9.909327,-26.387689,66.162271,-11.360767,-26.357077,63.909943,-12.151514};
			return value;
		}
		private double[] getCoordinate_9_21_point_53()
		{
			double[] value = {-26.212317,66.514028,-11.454355,-25.862259,68.237430,-11.064991,-25.810642,72.559399,-9.229456,-25.806501,68.813923,-10.542035,-25.763850,64.298887,-12.562630,-25.738849,71.654718,-9.550112,-25.702549,69.956869,-10.044937,-25.609668,71.863450,-9.684720,-25.569431,65.578014,-12.340551,-25.281822,65.043912,-12.691776,-24.996809,67.239342,-12.216818,-24.804809,66.142728,-12.578253,-24.442049,69.691756,-11.279244,-24.277534,73.145925,-10.835298,-24.245152,72.377966,-11.003911,-24.220172,71.611602,-11.010817,-24.136248,70.747253,-10.911979,-23.904596,70.528640,-11.226888,-23.871455,66.005741,-12.614751,-23.812692,65.331385,-12.721470,-23.691120,64.097391,-12.898334,-23.181122,63.936466,-13.061476,-23.149833,68.313188,-12.455547,-23.131109,69.777178,-12.605871,-22.697792,70.188166,-13.176384,-22.540183,70.936140,-13.226219,-22.407299,69.962460,-13.567738,-22.219857,68.792512,-13.963068,-22.211289,63.813380,-14.878203,-21.751823,65.583080,-14.816076,-21.410123,64.585991,-15.358794,-21.028102,72.589797,-14.147584,-20.993233,66.572916,-15.270899,-20.693965,73.219563,-14.445682,-20.391370,72.799664,-14.964551,-20.305479,71.071691,-15.064774,-26.903730,74.203337,-6.211427,-26.416457,75.130041,-6.489648,-26.149882,75.739907,-6.585578,-24.755147,77.440568,-8.040900,-24.645132,75.983854,-9.039527,-24.551489,77.128633,-8.382182,-24.506733,76.448926,-8.730775,-24.444354,77.305359,-8.590208,-23.621934,84.006540,-5.896202,-23.531255,75.075671,-11.046118,-23.415140,75.937010,-10.301112,-23.090299,75.901028,-10.667150,-23.088700,83.445145,-7.458366,-23.086263,81.865497,-7.781937,-22.784756,82.773592,-8.174248,-22.622984,75.843677,-11.351548,-22.563681,81.008820,-8.531645,-22.464686,75.728587,-11.613059,-21.848960,74.409942,-12.727984,-21.841699,75.845628,-12.426927,-21.310978,79.058600,-11.251692,-20.814333,73.997591,-14.234190,-20.762229,76.487378,-13.511349,-20.739778,83.505464,-10.393121,-20.696892,78.799946,-11.839322,-20.498589,80.797523,-11.155265,-20.242141,75.475468,-13.937038,-20.138370,74.310801,-14.639623,-19.836574,74.662554,-14.580321,-19.499397,78.662353,-13.129070,-19.457226,74.902468,-15.088410,-19.306280,76.261076,-15.164986,-19.082168,81.408606,-12.054665,-18.773590,77.815789,-13.974587,-18.626403,80.775644,-13.005486,-18.527693,81.824124,-12.673089,-18.396500,82.092020,-12.864551,-18.391334,82.187682,-12.873419,-17.317504,79.402601,-15.124588,-22.350756,84.355154,-7.527026,-21.925280,84.573350,-8.070761,-20.837460,85.111132,-9.052459,-19.541204,88.954717,-5.277892,-18.260176,89.092805,-6.213125,-18.053307,84.536233,-12.135632,-17.949607,86.751500,-9.693724,-17.858889,86.128454,-10.646337,-17.692671,85.361272,-11.376033,-24.459884,-72.788903,3.645938,-23.374126,-72.614561,1.479633,-22.904265,-72.560319,-0.548031,-22.869710,-72.950880,2.175281,-22.825594,-73.048074,2.815796,-22.598982,-73.533922,4.897089,-22.332892,-72.452915,-2.321395,-21.936245,-73.562887,3.725893,-21.902145,-72.581451,-2.459610,-21.654165,-73.318212,2.238731,-21.455970,-72.519563,-3.408868,-21.293154,-73.414537,2.031541,-21.162849,-72.592104,-3.500398,-20.035263,-73.172461,-1.831184,-19.893892,-73.706739,1.907535,-19.839040,-74.053016,2.957832};
			return value;
		}
		private double[] getCoordinate_9_21_point_54()
		{
			double[] value = {-19.754591,-73.075103,-2.940042,-17.764906,-74.935143,4.302716,-17.637751,-74.982238,4.297094,-26.706623,-72.180591,4.423745,-26.622252,-71.017489,-2.474906,-26.350887,-72.370553,4.562026,-26.258286,-70.980941,-3.835271,-25.717331,-71.652006,-0.143519,-25.575590,-72.345140,3.332940,-25.355474,-70.996413,-5.053330,-25.121216,-71.328779,-3.404498,-24.730910,-72.402962,2.271143,-23.897432,-71.468602,-4.742881,-21.503764,-72.225829,-5.140351,-18.062138,-41.663730,-4.706183,-17.138963,-42.311997,-4.591728,-26.665933,-32.354033,-2.874922,-25.630513,-33.712841,-3.489569,-25.438758,-33.684494,-3.258757,-24.804239,-32.346907,-2.403524,-24.578032,-34.878411,-3.885665,-24.081119,-35.007050,-3.545546,-23.746955,-34.643856,-3.173692,-21.182839,-34.355363,-2.440793,-20.538040,-30.933081,-0.542988,-20.409524,-32.560009,-1.294967,-20.021889,-38.127906,-3.802391,-19.816723,-30.677866,1.380160,-19.727127,-30.864907,1.703460,-19.189702,-37.953901,-3.578488,-18.891429,-33.544969,-1.257294,-18.504562,-40.265365,-4.166418,-17.894555,-32.777256,-0.252716,-17.859033,-35.879363,5.006766,-17.831637,-35.497454,4.405610,-27.460447,-29.912450,-1.604582,-27.208801,-27.057403,-0.108065,-27.137386,-23.035897,3.092026,-25.868394,-25.143914,1.372326,-25.202351,-28.957304,-0.814287,-25.197001,-30.610109,-1.599613,-25.116722,-25.103088,2.271421,-25.058319,-25.177275,2.436648,-24.438105,-25.830725,2.183907,-24.229418,-26.344499,1.038633,-23.936460,-27.375223,4.345944,-23.732540,-26.633005,2.259368,-22.704272,-27.635129,1.601269,-22.690904,-29.459436,4.862742,-22.622625,-29.277512,4.600922,-21.730954,-29.850070,3.973055,-21.702052,-29.972763,-0.452289,-21.674883,-28.637240,0.820170,-21.201639,-29.112946,0.878806,-20.695178,-20.468374,3.176283,-20.655956,-20.727967,4.063852,-20.623233,-20.391040,4.009629,-20.391620,-29.984509,0.561604,-19.888038,-23.998660,4.477295,-19.885060,-21.320730,5.206464,-19.874548,-22.495742,2.642983,-19.850528,-20.624325,1.143384,-19.829580,-23.728218,3.996531,-19.788313,-20.623933,1.052769,-19.752142,-24.199994,4.360343,-19.708262,-21.113704,1.268515,-19.584557,-22.905152,2.635289,-19.096793,-22.411841,1.553986,-19.092453,-24.378169,3.479335,-18.860365,-21.763619,0.925891,-17.894540,-24.696913,2.747595,-17.514449,-26.503844,4.875707,-17.290263,-21.262669,0.106830,-23.531930,-9.746464,4.662204,-23.095102,-10.907799,4.505885,-23.064799,-10.551536,4.252611,-23.021486,-10.091777,3.992405,-22.836441,-11.821429,4.549464,-22.815173,-10.917210,3.895369,-22.765543,-11.510445,3.803752,-22.683414,-12.261246,4.267798,-22.544943,-13.686038,5.171182,-22.115988,-12.900709,3.663291,-21.964684,-14.195053,4.250877,-21.778044,-11.390858,2.130238,-21.506639,-12.429574,2.601869,-21.229180,-14.646079,0.743291,-21.172396,-15.622967,1.068389,-21.017165,-13.903937,0.830826,-20.948709,-13.828917,-0.696656,-20.853525,-13.307700,-1.118519,-20.579451,-11.800221,-0.147955,-20.575592,-12.748028,1.397644,-20.544377,-13.343338,-1.516631,-20.531506,-14.669080,-0.924186,-20.514802,-17.795440,0.688776,-20.418655,-17.707986,0.458393,-20.363596,-12.036812,-2.157147,-20.314492,-16.572572,3.755478,-20.260803,-11.148286,-2.246685};
			return value;
		}
		private double[] getCoordinate_9_21_point_55()
		{
			double[] value = {-20.255818,-17.643194,0.191271,-20.246982,-11.114467,-0.082554,-20.209779,-11.010964,-0.314754,-20.061129,-12.916731,-2.071158,-20.045702,-10.426532,-0.185311,-20.033382,-17.935125,0.072279,-19.991615,-10.506965,-0.384125,-19.991155,-11.218765,-2.603191,-19.861451,-19.007991,4.803530,-19.784037,-19.581571,5.029673,-19.623949,-17.071193,-0.518630,-19.428423,-10.317499,-2.972037,-19.272177,-14.158757,-1.748153,-19.213284,-15.315786,-1.288269,-18.910286,-13.917822,-1.967748,-18.885855,-17.001440,-0.429206,-18.808096,-11.658356,-3.090069,-18.734121,-14.021820,-1.912272,-18.515499,-13.125172,-2.423071,-18.451726,-11.228053,-3.330897,-17.877719,-11.323743,-3.354674,-17.621085,-18.302624,-0.223206,-17.534536,-19.793548,0.096572,-17.428527,-16.305330,-0.932546,-17.420101,-16.401718,-0.902691,-17.239188,-15.373496,-1.325180,-17.231867,-17.858503,-1.684433,-24.468404,-5.665229,4.651900,-24.303274,-0.485401,4.818218,-24.046787,-5.924990,3.602572,-23.812106,-6.256001,3.427430,-23.605517,-5.282723,2.624053,-23.577931,0.294579,2.684245,-23.506342,-9.551671,4.744925,-23.484881,-9.449387,4.841395,-23.423364,-9.305380,4.429878,-23.404138,-0.515476,2.901686,-23.387967,0.140792,2.338555,-23.379612,-9.611626,4.292695,-23.136302,-0.841033,2.862418,-23.117488,-2.890200,3.501918,-23.081068,-2.958208,3.197405,-22.384656,-6.912861,2.609063,-22.132009,-8.851287,0.919396,-22.059454,-1.174811,1.295126,-22.013534,-2.521985,1.289275,-21.802130,0.542856,-0.319500,-21.789368,-8.107942,0.312577,-21.701572,-5.469554,1.006329,-21.492571,-2.442064,0.464379,-21.090368,-8.614705,-0.508994,-20.944260,-3.853178,-1.431145,-20.872727,-3.766262,-1.507722,-20.858794,-2.881340,-0.984445,-20.780975,-6.864293,-0.421345,-20.587402,-4.334305,-1.504429,-20.518668,0.103311,-2.065014,-20.477903,-8.473198,-0.988470,-20.216785,-9.157418,-0.643505,-20.084308,-3.281019,-2.297508,-19.879642,0.058059,-2.762037,-19.808884,-7.499213,-2.437215,-19.748680,-0.133177,-2.900242,-19.615682,-6.520788,-2.704363,-19.539352,-7.247696,-2.942006,-19.519591,-6.197920,-2.366080,-19.514185,-6.364168,-2.669360,-19.436081,-1.830817,-3.304648,-19.367451,-7.362604,-2.996931,-19.239984,-9.525873,-1.684589,-19.059446,-5.511451,-2.738708,-18.797967,-3.149223,-4.030564,-18.784026,-6.010524,-3.712341,-18.517119,-1.838859,-3.988098,-18.409312,-6.051201,-4.170606,-18.376652,-7.626111,-3.268752,-18.313617,-5.872343,-4.236532,-18.114865,-5.126822,-4.229567,-18.004989,-5.612017,-4.504095,-17.533682,-0.895256,-5.052247,-17.243731,-4.701810,-5.155022,-17.113350,-9.694528,-4.337307,-24.330082,0.773873,4.558380,-24.239152,4.301494,4.784109,-24.189350,2.687428,4.067505,-24.117325,4.872111,4.776690,-24.055428,2.616427,3.642037,-23.881096,3.914038,4.346621,-23.735646,2.355192,2.870012,-23.522087,5.853621,4.310397,-23.521007,0.831651,2.844409,-23.407464,3.911923,3.248282,-22.728172,4.595760,1.094571,-22.725010,4.060633,0.566192,-22.602661,7.606549,1.245311,-22.436439,9.366257,4.702277,-22.388012,4.813855,0.983549,-22.178063,7.799169,4.585570,-22.031887,2.762631,-0.157849,-21.909008,3.991313,-0.506498};
			return value;
		}
		private double[] getCoordinate_9_21_point_56()
		{
			double[] value = {-21.873773,3.109868,-1.021384,-21.857859,8.337941,1.160264,-21.850207,4.069357,-0.494689,-21.599406,5.576431,0.376303,-21.337434,8.417177,2.807764,-21.323182,9.179521,-0.263718,-21.253149,9.453246,2.931368,-21.160071,3.458225,-2.423786,-21.127542,3.545100,-2.461773,-21.027263,10.472313,2.212627,-20.923926,9.232735,0.536173,-20.876590,9.337545,2.418253,-20.802499,8.365291,-1.531071,-20.779193,11.130085,1.812228,-20.732944,2.849960,-2.706993,-20.677851,7.189237,-1.440747,-20.633469,9.757122,2.194776,-20.536089,9.010169,-1.707259,-20.470239,10.213479,-1.000239,-20.285167,9.953020,-1.727750,-20.261419,9.609865,1.546058,-20.131331,8.159130,-2.199117,-20.118754,4.553929,-3.112633,-20.101674,10.041999,0.140319,-19.644632,1.100347,-2.141370,-19.468672,8.015506,-2.519143,-19.101157,6.935457,-2.119434,-19.017064,6.640375,-2.115529,-19.003402,3.185461,-4.294109,-18.903407,1.021578,-2.791365,-18.876822,6.519637,-2.428226,-18.823097,4.497497,-4.682921,-18.147619,4.836958,-4.708864,-18.031889,5.288923,-4.288829,-17.847119,7.744910,-3.482804,-17.520941,1.421821,-3.750089,-17.516450,5.855078,-4.383348,-17.495182,0.923478,-4.107581,-17.463659,6.305694,-4.402410,-17.350157,5.529330,-4.686741,-17.257331,5.971460,-4.531416,-17.230667,6.922428,-4.585224,-17.139336,6.821538,-4.591966,-26.750404,19.821970,4.287166,-26.360923,19.171071,4.086748,-26.354354,18.898634,4.168649,-26.071281,17.920209,4.456540,-25.515923,20.064568,3.380364,-24.959609,16.646368,4.476546,-24.939437,20.055224,2.988123,-23.310723,19.002033,2.045749,-23.134585,15.273143,4.754396,-22.931332,15.938485,3.700817,-22.888693,15.079915,5.172419,-22.708385,17.497626,2.326347,-22.024290,15.969730,3.401552,-21.709438,11.382947,5.036653,-21.563133,11.457831,4.815944,-21.030003,15.156223,4.575694,-20.759911,17.159732,2.351046,-20.498908,12.115810,4.393733,-20.399085,17.510652,2.161373,-20.256370,12.979708,5.203894,-20.228008,12.324927,4.052509,-20.127673,12.834773,4.973285,-19.997324,12.307277,1.691965,-19.914333,11.830244,0.893649,-19.673393,14.932868,4.671784,-19.535295,11.491854,-1.795332,-19.403473,11.408013,0.445526,-19.090818,14.959725,4.340003,-19.062029,13.173050,0.919618,-18.933229,17.154642,2.825953,-18.723945,12.581511,-0.215251,-18.647667,13.031600,-1.801608,-18.610142,18.011124,2.365027,-18.596337,14.725594,3.574179,-18.577423,12.762455,-1.084143,-18.575618,13.935687,1.035952,-18.541418,13.754195,2.336273,-18.541162,13.686515,2.562908,-18.466791,13.692901,-2.123757,-18.466380,13.956829,-0.040733,-18.453907,13.922515,-0.132872,-18.359140,15.643952,3.414139,-18.352584,14.018823,2.370729,-18.341328,13.963443,2.973186,-18.293434,15.158505,3.239835,-18.283523,14.132748,2.685693,-18.272334,20.378927,1.527990,-17.961339,14.938634,2.577498,-17.936373,15.231828,2.642160,-17.846678,14.651140,-3.251630,-17.795453,20.383618,1.035086,-17.705914,21.506146,-1.275197,-17.677804,20.510804,0.544351,-17.647818,20.476797,0.253106,-17.637648,19.988577,0.234263,-17.629158,17.258928,1.093878,-17.574804,18.035656,1.189619};
			return value;
		}
		private double[] getCoordinate_9_21_point_57()
		{
			double[] value = {-17.569055,19.310299,-1.688479,-17.500202,17.467239,-2.276685,-17.191396,14.020776,-3.844116,-17.144634,18.953313,-3.444157,-27.491238,26.814837,3.135779,-27.385410,31.026928,4.321203,-27.127153,31.906847,4.453440,-26.851109,29.021601,4.059190,-26.819833,32.014203,4.461615,-26.771131,26.385918,2.991807,-26.656044,24.739964,4.093837,-26.378466,28.042459,3.632157,-26.277407,30.159778,4.385161,-26.116850,31.308749,4.375905,-26.072203,31.392830,4.368480,-25.625972,23.489172,3.519335,-25.334743,28.955465,4.076735,-25.209841,29.742918,4.234505,-24.780468,22.427100,2.936351,-24.462348,32.027118,3.688704,-24.344616,30.476921,3.809562,-24.206658,30.611686,3.598397,-24.112607,26.140152,2.249052,-23.887929,31.543040,3.270275,-23.715638,31.138670,3.260445,-23.583069,22.093204,2.067864,-23.454071,31.427778,0.664097,-23.439970,25.036312,1.978693,-23.293481,30.777583,-1.011444,-23.282733,31.046213,1.106519,-23.137183,27.185538,2.998525,-22.963653,29.632697,2.911375,-22.959088,27.303523,3.020629,-22.944174,31.647921,-1.990962,-22.849094,27.900057,3.101878,-22.785335,24.352615,2.043331,-22.744567,29.670957,1.842408,-22.502237,29.640850,-1.029556,-22.485517,29.179175,1.654880,-22.471525,23.010608,1.740145,-22.451641,26.191541,2.570409,-21.867244,28.964966,-0.885454,-20.711963,31.652295,-2.897858,-20.441318,24.608161,0.987967,-20.276670,31.140565,-2.653665,-20.098101,29.645213,-2.035793,-19.853545,32.004941,-3.104458,-19.759179,32.002124,-3.120260,-19.415968,23.080783,1.124700,-18.980013,24.322440,-0.032618,-18.750408,28.510090,-2.900682,-18.700302,27.650144,-2.366570,-18.518515,21.985948,1.057835,-18.445551,28.996351,-3.368999,-18.373008,23.752939,-0.250378,-18.345692,24.829126,-1.134740,-18.124184,30.579739,-3.836946,-18.118984,24.920537,-1.970985,-17.971717,27.144556,-3.286065,-17.910628,26.273301,-2.909661,-17.793598,27.599332,-3.715949,-17.543145,27.938239,-4.078816,-17.521467,30.700962,-4.505413,-17.511592,23.049062,-1.969602,-17.449061,31.549254,-4.712956,-17.259055,24.204315,-2.578676,-17.180877,31.997387,-5.080131,-17.104589,21.884422,-3.352738,-27.181500,36.951706,-0.938590,-26.749341,32.602067,4.396421,-26.730668,35.899146,1.905354,-26.367062,35.763591,2.084577,-26.249235,39.658191,-1.397677,-26.191221,33.917436,3.796180,-26.133875,32.388170,4.329930,-26.113186,36.457362,1.110813,-26.087970,33.881073,3.860135,-26.068774,38.162451,-1.424106,-26.002948,40.184386,-1.273491,-25.777238,37.247265,-0.679519,-25.543274,36.840429,0.525875,-25.474521,35.522759,2.528234,-25.352228,33.486926,3.959946,-25.066323,34.636837,3.156993,-24.986976,37.546016,-0.711093,-24.860260,36.981974,0.412493,-24.848825,32.313635,3.994876,-24.482831,38.195400,-1.118663,-24.318824,33.743011,3.434326,-24.168429,36.552559,1.295197,-24.151861,32.616852,3.395066,-24.036751,34.725154,2.629415,-23.660677,35.931912,1.465524,-23.588453,32.866512,2.338074,-23.534888,32.639258,2.086929,-23.426700,35.967516,1.245574,-23.274051,34.974347,1.014811,-23.148123,42.012173,-1.555246,-22.975640,36.667290,0.255768,-22.927470,35.887327,0.510553};
			return value;
		}
		private double[] getCoordinate_9_21_point_58()
		{
			double[] value = {-22.612291,42.334633,-3.409578,-22.606677,40.437325,-2.034188,-22.534307,36.604484,-0.236834,-22.243703,38.280913,-1.314350,-22.154605,41.979354,-3.400905,-22.020562,36.160060,-0.938525,-21.982239,36.438438,-0.936341,-21.801300,41.550515,-3.215805,-21.582977,38.254397,-1.440044,-21.485388,41.862431,-3.487743,-21.460372,39.298059,-1.936330,-21.372034,34.302805,-3.117993,-21.123248,36.351683,-1.485804,-20.983770,35.696931,-2.406205,-20.934333,32.458832,-3.167919,-20.907463,41.707210,-3.344935,-20.686635,35.774550,-2.709193,-20.628665,42.141926,-3.601186,-20.584734,35.864141,-2.722587,-20.498776,42.333157,-3.666048,-20.133543,41.766430,-3.349732,-20.122896,40.311772,-2.657473,-20.112603,35.367355,-3.504162,-20.046357,41.478037,-3.187631,-20.009478,33.615549,-3.675806,-19.947772,37.847391,-2.737128,-19.947340,40.310086,-2.920076,-19.929827,39.371489,-3.610538,-19.831281,38.525853,-3.523084,-19.820319,33.332924,-3.635852,-19.731243,40.818396,-4.679557,-19.699375,37.748116,-3.343699,-19.638837,38.599071,-4.847104,-19.490099,37.865290,-3.697413,-18.962168,34.982022,-4.153601,-18.884288,33.202754,-3.801950,-18.784369,33.761778,-3.932227,-18.630892,36.867042,-4.184537,-18.333720,34.118690,-4.582050,-18.295409,32.490358,-4.595559,-18.249931,35.638151,-4.521120,-18.187110,37.943140,-4.926293,-18.154625,32.382288,-4.717116,-18.045213,35.901277,-4.786301,-27.462233,49.769912,-1.541595,-27.459208,49.417867,-1.933501,-27.416498,47.524022,-3.942501,-27.414940,45.316940,-0.970584,-27.394417,46.348284,-3.587388,-27.349287,50.213905,-1.534420,-27.298163,51.818961,-2.253291,-27.183341,47.007811,-3.937308,-27.111161,51.074848,-1.793564,-27.042590,49.885335,-1.767533,-26.927903,49.722330,-1.979005,-26.833313,49.978654,-1.881628,-26.778000,52.503039,-3.547563,-26.757952,52.431922,-3.476242,-26.423847,51.821835,-3.248552,-26.413429,51.739622,-3.190334,-26.058643,45.700982,-3.204051,-26.034119,45.718933,-2.313337,-25.997168,43.248506,-0.753518,-25.996194,48.260687,-3.793483,-25.890544,45.684881,-1.652278,-25.880397,45.643105,-1.546454,-25.801577,45.668378,-1.720803,-25.568185,45.506556,-3.015959,-25.567359,49.346562,-3.206220,-25.541289,47.504590,-4.313660,-25.507280,48.317335,-3.727412,-25.165063,43.576455,-0.725235,-25.094113,50.074667,-3.923676,-25.016334,45.144299,-3.465083,-24.863525,43.771873,-0.754833,-24.817954,44.796632,-1.085203,-24.749703,45.028609,-3.859661,-24.573444,44.642212,-1.274970,-24.569723,45.968509,-4.587262,-24.372135,46.433188,-4.693534,-24.216154,43.998650,-0.885800,-24.203911,43.101260,-0.714219,-23.961961,44.380070,-3.828205,-23.930205,43.997824,-2.876918,-23.797334,47.543515,-4.377823,-23.774171,43.749338,-2.973179,-23.671072,44.527348,-4.250006,-23.551220,43.469251,-2.256142,-23.540221,47.972238,-4.621123,-23.536075,44.096992,-4.050618,-23.153625,45.833186,-4.802019,-22.282034,43.973672,-4.441792,-20.359245,42.700567,-3.801840,-26.892130,53.035563,-4.094311,-27.338916,75.356506,-4.472596,-25.352408,84.289560,-2.970650,-25.236157,82.994054,-4.066790,-25.084811,83.613849,-4.118884,-24.718942,83.586615,-4.831667,-27.370135,86.372320,4.203827};
			return value;
		}
		private double[] getCoordinate_9_21_point_59()
		{
			double[] value = {-26.273535,86.627765,1.891283,-25.799694,85.104129,-1.371056,-25.796288,87.318651,2.300852,-25.635682,85.020255,-1.717041,-25.258191,84.818392,-2.463777,-25.042804,88.372657,2.590350,-24.998024,87.498810,1.293738,-24.730871,87.971295,1.034560,-24.652548,85.965273,-1.480773,-24.645184,87.402649,-0.177981,-24.639495,84.745159,-3.210049,-24.574037,86.373576,-1.297147,-24.463782,85.159562,-2.919369,-24.388079,86.995542,-1.532580,-24.260378,84.559589,-4.069985,-24.177993,85.956418,-3.249220,-24.103866,88.522313,0.881348,-23.521973,87.786604,-1.586731,-23.516831,90.869532,4.830584,-23.344880,90.142482,2.885057,-23.096469,89.802357,1.484385,-22.986537,90.752862,3.186921,-22.603030,90.474119,1.829070,-22.541926,89.058154,-0.935677,-22.498448,88.618885,-1.588200,-22.421427,88.790334,-1.580771,-22.416406,87.742207,-3.262676,-21.656165,92.389355,4.487776,-21.642931,92.068774,3.868899,-21.507768,88.575545,-3.510236,-20.573778,90.218741,-1.381612,-20.561218,90.633893,-1.114425,-20.510006,89.459569,-2.974571,-20.379833,91.283192,-0.548617,-19.959463,91.083003,-1.458834,-19.873801,89.304985,-4.085121,-19.605835,90.703754,-2.558150,-19.204007,92.418882,-0.096690,-19.067819,90.462183,-3.567510,-17.778757,92.545070,-1.710528,-22.232897,-142.262378,15.486306,-21.768024,-140.104600,14.715596,-21.454305,-142.556027,14.787118,-20.810907,-138.642944,14.980835,-19.725872,-140.021792,12.671152,-18.755325,-142.794919,11.823401,-18.685249,-142.704068,11.729386,-18.409910,-142.468175,11.383406,-17.546235,-140.951592,10.342930,-17.504600,-139.091353,11.623803,-17.402858,-142.793140,10.352477,-17.130276,-137.583374,11.242527,-20.332379,-132.935415,13.882790,-20.269599,-133.076791,13.849126,-19.500647,-133.954681,13.222894,-18.380975,-125.962129,10.166164,-17.314560,-133.856132,10.838408,-23.965303,-118.489757,14.695967,-21.718035,-119.333359,12.419005,-20.264264,-120.360534,11.063913,-19.747602,-116.388582,9.824745,-19.004657,-122.177334,10.086572,-18.518410,-116.495099,8.554248,-17.229512,-115.439926,7.064948,-26.274711,-106.462307,14.912962,-25.794895,-107.428385,14.595653,-22.428531,-109.255137,11.522759,-22.284665,-113.926406,12.129023,-21.666654,-108.303665,10.487437,-21.536681,-112.860249,11.206591,-21.377906,-109.429636,10.461584,-20.431891,-110.418173,9.684749,-20.249139,-104.830856,8.440229,-19.116498,-107.993250,7.919985,-18.673705,-103.949342,6.780592,-17.623123,-110.808385,6.873496,-25.861774,-101.947832,13.943096,-24.977831,-101.522781,13.507804,-24.668101,-100.149805,15.345406,-23.723308,-102.575537,11.682804,-23.369580,-102.345481,11.482535,-22.405127,-101.297913,11.921720,-19.642355,-99.314483,13.374283,-19.174933,-103.506809,7.251132,-18.331629,-103.460219,6.509688,-27.340592,-72.520437,7.776414,-25.159279,-72.900845,5.584208,-24.350501,-74.211364,11.980205,-23.988502,-75.112399,14.733343,-23.475123,-74.977913,13.712539,-23.441311,-75.381466,14.768334,-23.418051,-73.422798,5.563087,-23.256911,-73.888476,7.820773,-23.123938,-73.765762,7.321849,-23.017622,-75.047963,12.663582,-21.449407,-74.859441,9.303824,-21.221170,-74.603760,7.808195,-21.187908,-75.487941,11.439760,-20.530517,-75.845384,11.604785,-19.649910,-75.213298,7.853036};
			return value;
		}
		private double[] getCoordinate_9_21_point_60()
		{
			double[] value = {-18.785402,-75.029077,5.852660,-18.750852,-76.147410,9.644271,-18.580367,-76.708543,11.016646,-18.495335,-77.531890,12.828520,-18.005099,-79.221736,15.139847,-17.783232,-78.120800,12.829409,-23.397173,-30.995437,8.516406,-23.168817,-30.692744,9.114304,-23.067702,-31.370746,8.079530,-22.963112,-31.487124,7.364361,-22.461136,-30.850552,9.469331,-22.277629,-31.953122,7.655430,-21.259878,-33.183676,6.751237,-20.726545,-32.106299,9.118738,-20.572874,-31.006860,10.491017,-20.391729,-31.330796,10.206968,-19.804235,-31.193305,10.394631,-19.589258,-31.496551,10.221349,-19.317408,-34.021393,8.138342,-19.229626,-33.127052,9.127067,-19.155890,-34.672118,6.784093,-18.834891,-34.249836,8.287243,-17.980477,-35.036500,8.244822,-17.555187,-31.181339,8.875009,-17.406730,-35.126131,8.500549,-17.379110,-36.651610,5.635754,-17.350447,-35.256583,8.434620,-17.269954,-30.783876,8.417823,-17.210800,-36.003044,7.860555,-17.110193,-34.348617,9.033937,-27.188067,-25.347991,13.592723,-27.115884,-25.735880,12.781150,-26.873257,-25.461690,13.770922,-26.761628,-26.998915,11.268950,-26.726608,-27.737216,10.333636,-26.481378,-24.542425,14.684151,-26.066666,-26.786486,12.146611,-26.047963,-25.291963,14.064093,-26.045694,-26.920742,11.969638,-25.730247,-29.209452,8.853193,-25.482411,-27.928859,11.065985,-25.477216,-26.837633,12.635598,-25.197674,-26.861309,12.752308,-25.126494,-27.690328,11.874631,-25.107095,-29.431788,9.264636,-24.650042,-30.052151,8.856985,-24.611040,-25.435769,13.968177,-24.580722,-26.258141,13.366446,-24.568976,-25.146331,14.251380,-24.417923,-30.284332,8.653329,-24.072290,-25.381677,13.998907,-24.008955,-25.030010,14.344188,-23.671267,-23.350178,15.590148,-23.148329,-27.150910,12.601594,-22.834062,-22.936084,15.217150,-22.663204,-23.438442,14.846470,-22.449152,-21.320701,13.344135,-22.424644,-25.658226,13.570013,-22.409644,-22.803503,14.885784,-22.276035,-28.538198,11.776919,-22.071181,-29.162593,11.377469,-21.816244,-24.639654,13.447051,-21.745361,-20.537806,11.780277,-21.489664,-26.298971,12.994750,-21.373613,-23.356894,13.262760,-21.307082,-20.410433,8.559418,-21.214243,-22.624727,13.221410,-21.195602,-22.797097,12.921760,-21.151101,-21.225961,10.738644,-21.112150,-22.441963,10.929743,-21.049329,-22.863576,10.998352,-21.049267,-28.682528,11.774558,-21.043854,-27.517033,12.155235,-20.830240,-23.229941,10.572710,-20.657277,-23.971158,10.704448,-20.547080,-22.010330,8.393365,-20.528866,-29.890530,11.031656,-20.522980,-22.494107,8.833100,-20.384777,-21.694532,8.010468,-20.355419,-25.442949,7.830276,-20.309389,-27.751674,11.485037,-20.193673,-23.195600,5.467752,-20.152220,-26.322853,10.828577,-20.007984,-30.528288,10.679967,-19.965219,-23.644493,6.592248,-19.904712,-27.772171,11.007289,-19.838325,-25.554857,10.197002,-19.759232,-23.776665,7.268531,-19.685499,-28.245501,10.514114,-19.593543,-21.017134,6.569552,-19.495809,-23.769858,8.343901,-19.316149,-29.438463,10.121123,-18.932732,-27.434750,8.061437,-18.036103,-26.723161,6.048467,-17.895604,-27.866080,7.167988,-17.774816,-27.692334,6.797294,-17.703934,-29.773663,8.409653,-25.621057,-10.229727,12.111873,-25.574053,-11.577875,10.148113,-25.315968,-11.497416,9.412954};
			return value;
		}
		private double[] getCoordinate_9_21_point_61()
		{
			double[] value = {-25.149771,-13.054575,13.233481,-25.067656,-13.679351,13.142484,-24.964545,-14.257768,12.671630,-24.787828,-9.730380,7.171430,-24.690560,-14.224971,11.434284,-24.618424,-13.380038,13.969451,-24.549297,-11.362987,8.345776,-24.462557,-15.598382,12.773851,-24.435250,-15.444741,12.347431,-24.389906,-14.870762,14.004543,-24.335770,-10.043727,14.057363,-24.332236,-10.260051,14.067749,-24.291995,-12.699959,9.285191,-23.886743,-13.246301,9.009408,-23.868712,-10.083269,6.648638,-23.847648,-11.365182,7.359973,-23.801172,-14.221522,8.067889,-23.785458,-11.675472,6.671370,-23.761604,-14.630606,8.981082,-23.750668,-12.850088,6.499333,-23.748608,-12.558634,6.334306,-23.748330,-15.166530,10.508115,-23.742986,-14.653633,9.810462,-23.740026,-13.899409,8.560194,-23.736854,-14.622189,8.055926,-23.525765,-10.651741,5.330330,-23.523029,-15.914196,9.174311,-23.485567,-16.552106,10.623804,-23.475115,-16.080763,10.558663,-23.433702,-16.921700,11.942641,-23.339359,-17.005647,11.278436,-23.298607,-18.078369,13.749374,-23.270609,-14.342561,7.138181,-23.170144,-15.167492,14.927113,-22.829577,-18.279023,10.241268,-22.683455,-13.681564,6.107990,-22.588010,-19.030334,15.111044,-22.494972,-14.126693,5.579088,-22.442773,-14.415838,5.397557,-22.198858,-16.514854,6.277747,-22.156453,-16.801462,6.443806,-21.920997,-16.051620,5.488565,-21.875969,-17.777839,6.815163,-21.837183,-16.443649,5.684985,-21.244598,-18.758505,6.809427,-20.831444,-18.594539,6.318784,-20.580125,-18.754652,6.131503,-19.783519,-19.694812,5.869808,-25.960330,-7.522474,9.637838,-25.959700,-7.725535,9.866190,-25.880730,-2.004931,10.784154,-25.872937,-1.414107,9.511515,-25.868148,-9.104692,11.111315,-25.831493,-8.882104,9.503495,-25.804704,-9.619481,8.915989,-25.775503,-8.332551,10.740189,-25.650506,-6.189842,8.205744,-25.648982,-1.483998,10.974769,-25.621582,-1.776250,9.254637,-25.607720,-6.070142,8.087462,-25.591502,-3.802824,11.449890,-25.591285,-2.228950,9.647942,-25.546353,0.402062,8.827921,-25.516412,-5.613433,12.907259,-25.511827,-3.349852,12.481197,-25.489097,-0.292601,10.278923,-25.472691,-1.362829,12.606734,-25.458682,-5.595127,7.642840,-25.420290,-9.321773,11.918634,-25.420223,-1.819255,13.106199,-25.403572,-5.453899,13.415649,-25.388831,-7.748325,10.790760,-25.365246,-7.193672,6.733218,-25.351045,-5.042940,13.537721,-25.338268,-2.058467,12.547222,-25.322857,-2.173713,12.361114,-25.302005,-2.512237,13.044136,-25.298251,-6.398437,13.730430,-25.273090,-7.053387,6.335327,-25.247138,-3.806894,13.418446,-25.230874,-5.543951,12.177162,-25.211682,-1.826006,13.698846,-25.208352,-3.697684,10.238332,-25.164954,-0.381414,13.429751,-25.089850,-4.953826,7.473784,-25.058071,-4.173637,10.580532,-25.036441,-6.007136,6.567557,-25.001654,0.059683,6.209871,-24.941999,-5.381333,15.171573,-24.941769,-5.105226,11.188984,-24.822092,-1.186326,14.144845,-24.644638,-9.558588,12.937402,-24.631917,-3.519685,9.093153,-24.561394,-9.319429,14.587752,-24.558240,-8.388799,15.323572,-24.517156,-7.791226,12.530089,-24.507592,-7.945156,12.634550,-24.488043,-7.822182,12.422778,-24.455300,-6.247847,10.764264,-24.198385,-4.307031,8.059724};
			return value;
		}
		private double[] getCoordinate_9_21_point_62()
		{
			double[] value = {-24.098106,-3.825782,6.708526,-24.038332,-3.678138,6.486847,-23.977598,-8.222499,5.354573,-23.779046,-8.712305,5.569523,-23.599730,-9.663030,5.449490,-23.484599,0.361671,14.385720,-23.333776,0.054847,14.789181,-23.220620,-0.323835,15.016424,-25.853305,1.605474,10.760123,-25.741650,1.302010,11.439146,-25.628430,0.926356,9.949385,-25.556123,1.225929,9.306082,-25.447851,0.903916,9.193797,-25.231752,1.625830,8.027966,-25.161169,1.606670,5.925177,-24.857371,3.771253,10.008579,-24.817688,1.559833,12.313558,-24.808426,0.821819,5.270556,-24.786168,0.881974,12.901555,-24.783380,4.599106,7.510697,-24.772950,4.576875,7.310222,-24.742979,6.320996,12.013196,-24.699779,6.576950,11.929043,-24.680048,3.685036,10.298962,-24.671504,5.783052,13.032914,-24.658947,4.821671,6.281576,-24.624754,5.456208,13.476164,-24.587787,6.408628,12.725723,-24.533220,7.271997,11.391403,-24.513844,5.439344,13.751752,-24.513623,3.833869,13.971829,-24.426808,3.296756,14.438429,-24.417630,7.014482,10.243920,-24.378785,6.042681,13.531263,-24.351020,5.915590,13.656778,-24.283632,7.873641,10.314419,-24.270965,3.262191,11.111647,-24.227313,5.750627,8.084234,-24.217880,7.397447,12.022715,-24.135144,4.468134,14.850360,-24.088555,5.488543,5.837964,-24.050235,6.340642,13.519512,-24.040246,5.403855,10.162630,-24.011330,5.114769,10.334116,-24.007261,5.970303,7.287051,-24.002761,4.901478,10.557260,-23.973669,5.623374,9.432194,-23.928920,5.817941,9.142972,-23.893857,3.832275,15.599162,-23.788804,5.621634,5.435582,-23.750909,2.761960,12.985526,-23.660902,6.751684,8.179749,-23.537586,6.798596,7.712005,-23.519524,7.296073,7.658818,-23.489590,6.326267,5.451868,-23.478578,8.278555,10.660934,-23.391472,8.799383,8.916024,-23.310301,8.430156,10.327201,-23.217389,7.986977,11.588963,-23.157438,7.578128,12.406438,-23.142112,6.222831,14.181038,-23.122003,8.832838,6.222661,-23.076012,9.202562,7.236768,-22.961529,7.158524,13.230441,-22.908916,8.052882,12.103785,-22.852673,8.767800,11.226797,-22.836185,8.654877,11.517359,-22.813698,4.922873,15.499783,-22.796260,7.022807,5.495429,-22.793245,9.874658,8.351458,-22.784652,8.405700,13.916114,-22.768191,8.516154,12.194102,-22.732110,10.052800,9.568681,-22.707256,7.049587,13.709696,-22.681009,10.461400,7.009865,-22.673171,7.344430,13.463552,-22.490500,7.006550,15.283673,-22.467031,6.044103,15.424233,-22.410564,5.761635,15.552826,-22.218553,10.701863,12.943878,-22.123191,7.654153,15.479641,-20.587330,9.730864,14.900694,-25.242696,19.430403,8.941176,-25.125029,17.893921,8.117629,-24.482207,15.994102,7.154909,-24.407818,16.090374,7.338265,-23.446612,15.210442,5.342061,-22.816753,21.104692,10.997007,-22.721854,19.404934,14.144116,-22.429942,19.640834,12.863295,-22.312123,16.948002,15.152208,-22.256921,11.496067,7.443816,-22.220685,11.219345,7.522308,-21.972019,19.866907,10.476059,-21.874700,14.984319,15.403666,-21.517345,13.490886,7.437333,-21.506955,13.286775,6.969121,-21.454773,15.831450,7.446061,-21.362207,11.808266,5.898767,-21.294629,12.112407,6.325870};
			return value;
		}
		private double[] getCoordinate_9_21_point_63()
		{
			double[] value = {-21.270987,18.923875,10.590478,-21.256913,14.003658,14.820312,-21.177460,18.325155,9.435019,-21.071776,16.864581,12.507656,-21.016476,14.377134,6.966407,-21.001994,12.749170,10.446243,-20.927900,11.642670,15.350870,-20.843036,14.111135,5.998826,-20.772289,13.127212,14.391520,-20.728283,13.428303,5.755839,-20.703965,18.146680,9.541711,-20.628132,18.106130,9.593082,-20.499662,13.784112,5.522761,-20.156967,14.241697,9.040820,-19.994952,15.110948,11.682846,-19.967134,15.602889,11.067235,-19.950816,15.272827,8.367664,-19.895792,12.967092,10.717645,-19.818565,12.196077,12.474505,-19.669408,15.680104,9.090000,-19.596287,15.626734,10.129397,-19.572770,12.665704,12.315224,-19.389666,14.902949,10.732391,-19.259598,14.540776,10.160685,-19.259296,14.323179,10.368661,-27.347203,26.346793,14.973669,-26.573126,25.967053,11.725788,-26.483316,24.988163,11.035156,-26.469867,25.867003,13.958577,-26.216736,25.077784,11.309206,-25.643937,24.850949,11.811481,-25.598883,24.871558,12.028979,-25.540085,24.870772,14.295830,-24.982253,24.030881,12.616153,-24.812231,23.381493,11.127167,-24.646186,22.870320,10.929377,-27.064350,89.006760,13.190669,-26.635691,88.942547,9.994549,-25.070759,89.785566,6.314780,-24.175449,92.411709,14.264014,-22.202598,93.984402,12.073139,-22.099687,94.384714,13.433759,-22.048203,94.247218,12.465075,-21.814483,94.286502,11.695212,-21.080468,94.119825,7.304590,-20.537018,95.698631,12.859418,-19.417157,96.667167,13.006569,-18.404023,96.951125,9.729799,-17.841766,97.500952,10.416295,-17.802739,97.592997,10.739542,-26.966010,-138.185986,20.541838,-26.639241,-141.422461,20.205841,-26.558350,-140.666321,24.294721,-26.321259,-140.738805,23.935525,-26.210675,-140.666654,24.339314,-26.057941,-141.552101,19.584586,-26.027485,-137.512900,20.419127,-25.530582,-141.147286,18.891029,-25.275896,-141.726454,18.749091,-25.156404,-141.752496,18.624656,-24.934164,-138.490239,18.493222,-24.913110,-136.653355,19.428915,-24.719480,-137.049877,19.228423,-24.682925,-137.354822,19.143248,-24.274290,-141.753504,17.632717,-24.226010,-137.740349,18.567475,-23.438250,-141.183911,16.584017,-23.272221,-138.027097,17.559515,-23.186104,-140.609151,25.054490,-21.343064,-141.834150,18.695405,-20.382405,-141.354723,21.409546,-19.505795,-142.122139,17.388301,-18.719097,-140.916886,23.993571,-17.237779,-142.006307,18.316993,-26.864796,-125.187488,19.288739,-26.444748,-127.385765,19.312424,-24.874764,-131.381089,18.468065,-26.454080,-123.497603,18.470135,-26.186491,-121.605180,17.764577,-24.828353,-123.576001,16.666853,-27.178952,-108.400708,16.279632,-26.857175,-112.176494,16.628349,-27.237866,-98.052976,20.693158,-26.886652,-100.060639,16.985800,-26.558053,-100.041455,16.776732,-24.611137,-97.014047,20.283997,-22.774274,-96.085295,19.791218,-22.663558,-94.410069,20.973933,-22.063800,-95.554765,19.645712,-21.146358,-94.027087,19.811143,-20.745640,-94.570070,19.139068,-26.025993,-92.441749,25.099347,-25.710077,-91.920960,25.030798,-25.025546,-83.753880,25.890400,-25.022557,-91.912968,24.370196,-23.546736,-86.587966,24.775618,-23.454089,-84.013913,24.080136,-23.449535,-85.483358,24.793926,-22.385793,-85.225176,22.991282,-22.200564,-86.836119,23.381664};
			return value;
		}
		private double[] getCoordinate_9_21_point_64()
		{
			double[] value = {-21.898939,-88.327908,21.997153,-21.606856,-86.344048,22.854281,-21.163119,-86.665033,22.429425,-20.920480,-90.267363,20.724623,-20.810870,-90.788531,20.549268,-20.533893,-85.734407,20.833657,-20.497398,-86.878023,21.703334,-20.207012,-85.971367,20.541744,-19.175242,-87.013010,20.215668,-19.044909,-89.024715,19.123739,-18.916863,-87.796783,19.919463,-18.463443,-86.126119,18.459151,-18.380085,-87.843465,19.406510,-18.307909,-86.585764,18.628446,-18.134607,-89.224365,18.103555,-18.064190,-91.152048,17.748040,-18.053680,-84.026646,17.905764,-17.478002,-86.164595,17.390213,-17.361673,-89.598772,17.251532,-17.203723,-92.970224,16.522351,-27.467702,-76.120070,24.305775,-27.035106,-75.555568,22.407336,-26.975333,-74.262404,17.192819,-26.601430,-74.656967,17.892780,-26.520885,-74.665106,17.693269,-26.247461,-74.858845,18.068917,-25.966407,-76.481024,22.743441,-25.625557,-75.703067,20.383852,-25.609917,-75.903995,20.757205,-25.571197,-77.067232,23.381250,-25.561778,-75.951403,20.826986,-25.337063,-75.550632,19.039569,-25.324009,-75.419314,18.570429,-25.030964,-78.686178,24.340927,-24.325253,-77.211119,21.900618,-24.109622,-82.142133,24.746728,-23.807901,-76.094243,18.308640,-23.635949,-75.734820,16.615097,-23.159276,-77.346249,20.327419,-22.829411,-78.243318,21.127389,-22.592948,-77.379510,19.512199,-20.645868,-79.476452,19.433727,-20.075310,-79.727508,18.835339,-18.717666,-80.721674,17.739806,-18.265775,-82.173956,17.790707,-26.981525,-23.362863,15.666715,-26.599636,-21.389470,17.332233,-25.418191,-23.259409,15.803580,-25.048585,-20.339399,17.667256,-22.875934,-20.175272,16.115151,-27.122960,-9.807752,21.465132,-27.096970,-16.216005,19.706060,-27.051475,-19.555041,18.326290,-27.009813,-17.152504,19.224659,-26.327257,-18.634148,18.698280,-26.157508,-17.633413,18.951525,-25.715081,-18.930478,18.486010,-23.988270,-20.057492,17.359791,-23.767422,-19.541089,17.516190,-23.741417,-12.099304,19.885636,-23.692107,-9.872446,20.287983,-23.371059,-12.316678,19.697169,-23.335400,-16.904721,18.535198,-23.322628,-14.461138,19.102886,-23.168192,-17.210914,18.361766,-23.092997,-16.557224,18.407715,-23.059692,-17.037013,18.277203,-22.994771,-13.208158,15.694247,-22.860532,-17.144314,18.023980,-22.826231,-17.050301,18.005641,-22.769160,-11.490320,18.409232,-22.755767,-10.406278,18.971561,-22.731585,-18.490941,17.263644,-22.726580,-10.738636,18.794208,-22.711538,-13.251442,16.223265,-22.604537,-13.079246,18.658160,-22.581526,-12.653798,18.677282,-22.503525,-13.390121,18.209128,-22.457007,-18.868278,16.708915,-22.367546,-13.820259,18.022877,-22.336001,-18.679858,16.450291,-22.189854,-14.196455,16.761144,-22.176534,-17.088311,15.841710,-22.108666,-16.495832,17.141920,-22.074869,-14.718782,17.127399,-22.063465,-16.171945,17.102455,-22.039642,-16.168263,17.008642,-27.189748,-4.541660,22.602411,-26.987522,-5.283480,22.340376,-26.712474,-6.280597,22.044819,-26.663491,-9.616022,21.349347,-26.224308,-6.097844,21.853954,-25.947510,-9.018521,21.191335,-25.221948,-8.000422,21.107974,-24.557473,-5.486532,15.980555,-24.468171,-4.579294,21.207510,-24.379878,-6.827951,16.328238,-24.311972,-6.996566,20.956922,-24.255811,-6.917872,16.510262,-23.692131,-4.075001,20.802277};
			return value;
		}
		private double[] getCoordinate_9_21_point_65()
		{
			double[] value = {-23.618499,-5.413982,20.761438,-23.516834,-8.323010,17.617814,-23.392539,-4.924000,16.786321,-23.356723,-6.275092,18.553351,-23.335957,-8.798873,20.124734,-23.330536,-3.722055,20.540907,-23.301404,-7.499008,18.437136,-23.277018,-0.628588,20.567835,-23.223940,-5.324417,17.071722,-23.164775,-6.493916,20.230193,-23.151723,-0.296992,17.085843,-23.113187,-5.084938,18.804850,-22.909822,-3.351114,20.125056,-22.906701,-8.831644,19.575654,-22.858362,-4.952951,19.685829,-22.851510,-8.357973,18.796233,-22.817085,-7.534418,19.436655,-22.810000,-4.900791,17.592005,-22.804695,-8.383247,19.181803,-22.799308,-9.540509,18.364997,-22.788937,-2.360927,16.178627,-22.751199,-1.346127,17.408526,-22.735790,-9.579781,19.147147,-22.476736,-2.729978,17.863809,-22.367473,-0.673036,17.988826,-22.324185,-0.376123,17.979789,-22.168426,0.708762,17.860008,-27.464692,11.024734,24.481956,-26.052809,3.343234,22.645860,-24.726287,4.357193,21.588922,-24.720159,4.741054,21.534478,-24.335336,8.383505,20.651502,-24.085666,2.060985,16.132110,-23.772886,3.291109,16.086824,-23.390059,1.460214,16.802519,-22.974631,6.992297,19.753981,-22.857633,1.481029,20.082074,-22.700630,3.365319,19.829630,-22.501214,3.079002,19.570634,-22.450984,4.181101,16.317319,-22.328609,6.041750,19.124348,-21.977321,2.195290,18.495290,-21.933119,7.146115,15.903606,-21.805428,6.387162,16.280519,-21.793656,3.479492,17.325048,-21.733333,7.965237,17.864612,-21.554050,6.106696,17.628210,-21.429360,8.478182,17.174731,-21.375253,8.349942,16.994991,-21.145879,7.873256,15.851257,-27.290969,20.635456,25.755332,-26.855488,14.020338,23.873617,-26.782187,14.300743,23.678342,-26.721151,20.005516,24.325540,-26.660826,20.522657,23.748256,-26.460700,20.445863,22.298219,-26.452329,20.627883,22.167658,-26.343785,20.104992,21.987021,-26.202051,14.028021,22.402674,-25.907875,20.311114,20.885553,-25.783225,18.371496,21.146047,-25.125284,13.052772,20.702823,-24.775933,18.917983,18.561424,-24.708339,18.139271,18.611988,-24.611643,18.201073,18.432753,-24.242057,20.730385,16.460395,-23.507678,15.795979,17.601324,-22.324014,13.952606,16.602404,-22.083889,11.450082,17.313414,-26.761413,25.176914,17.959023,-26.608335,22.374180,22.957798,-26.575488,22.235017,22.582267,-25.930996,24.978127,15.652695,-25.859522,23.948987,18.401805,-25.700866,22.274953,19.514220,-25.695242,24.631242,16.181913,-25.627828,23.436067,18.631643,-25.599387,22.793573,19.057211,-25.589475,24.375696,16.737848,-25.305465,24.209935,16.253055,-25.292839,24.290971,16.031429,-24.876735,22.707527,16.465876,-27.488971,88.661741,15.707177,-27.055087,87.663482,24.387374,-26.443193,89.575434,20.305724,-25.816333,90.688096,16.772259,-22.875776,93.274665,21.536698,-22.162284,94.528521,16.931708,-21.993820,94.400381,20.621130,-21.526432,93.507907,25.224902,-20.829469,95.433543,21.035032,-20.646893,95.924533,16.933573,-17.960477,97.959985,19.719695,-17.814037,98.190254,18.563007,-17.695264,98.289871,18.443882,-17.399484,98.298021,20.319847,-17.191366,97.045057,25.833616,-26.282929,-138.809991,34.342443,-25.371326,-139.125746,32.761985,-24.623894,-138.946362,33.829400};
			return value;
		}
		private double[] getCoordinate_9_21_point_66()
		{
			double[] value = {-23.601277,-138.668301,35.466168,-22.954053,-139.775655,29.580933,-21.127877,-138.596693,36.183939,-19.459880,-140.167083,27.938325,-26.421659,-85.874242,27.775644,-25.434202,-85.030100,27.051746,-25.119573,-85.927056,26.631951,-26.641648,-80.873025,27.399161,-27.475498,18.544763,35.085463,-27.334485,18.773242,36.349853,-27.109035,77.080406,36.185487,-26.036447,82.517797,33.331798,-24.655224,81.920669,36.034386,-25.668688,85.796956,30.436176,-25.133728,85.123574,31.984692,-25.082576,86.254634,30.804310,-24.605340,85.119710,32.936233,-23.713093,85.941414,33.593949,-22.974651,85.714293,35.143992,-22.698936,87.076670,34.161662,-22.522194,86.045580,35.450978,-22.204034,87.040013,34.924576,-21.308972,91.996444,29.033158,-20.902666,90.622509,32.220532,-18.846602,92.695446,32.433845,-17.241508,96.780343,26.169620,-25.464035,-138.315834,37.117472,-24.002478,-137.006825,44.372780,-23.915618,-137.089493,43.938924,-22.630859,-138.120086,38.552554,-20.614534,-136.777366,46.064699,-18.868732,-138.039469,39.491818,-25.905573,10.389154,45.419080,-25.044156,10.803186,46.317588,-27.506514,19.282987,41.733634,-27.395048,12.932957,40.362547,-27.385709,15.575832,37.702555,-27.306438,15.647246,37.984491,-27.275703,19.065284,37.848524,-27.230260,18.829973,40.867501,-27.081228,18.740252,41.253006,-27.081212,18.199269,38.091907,-27.010420,20.337032,45.160344,-26.991394,13.255209,41.071382,-26.743590,19.064532,43.836332,-26.726205,17.820550,39.504371,-26.697222,18.374987,42.936600,-26.354502,18.174229,42.964225,-26.285687,17.263248,41.167038,-26.254243,17.185670,41.150732,-26.182440,13.768783,42.390480,-26.165429,15.897800,41.526430,-26.048241,19.622837,44.650673,-26.029661,13.011976,43.168412,-25.873356,20.063342,45.309393,-25.842662,12.872864,43.631121,-25.675063,16.475943,42.575526,-25.526897,19.550719,44.779302,-25.464592,18.238451,43.823895,-25.445190,14.977585,43.198397,-25.441866,18.150404,43.795445,-25.216190,16.443301,43.363818,-24.937423,19.538674,44.835911,-24.933468,17.138574,44.053421,-24.701677,16.507499,44.339024,-24.292506,19.313657,46.093395,-24.002505,17.296676,45.388846,-27.384052,73.841793,39.137965,-27.261971,73.429718,39.801766,-27.140273,69.560345,44.024970,-27.096648,68.373123,46.227835,-26.889396,70.398782,43.414333,-26.863103,71.400510,41.836470,-26.806345,72.557936,40.884038,-26.660523,70.343908,44.434130,-26.506264,71.533731,42.847144,-26.455349,73.677333,40.310176,-26.374980,71.005686,43.990642,-26.227974,71.163759,43.982259,-25.450262,70.931217,45.194687,-23.946105,72.239273,45.279897,-23.910110,71.481771,46.155576,-23.520689,72.366305,45.683557,-26.650977,76.078969,37.837376,-26.515193,73.952092,40.065859,-24.793694,79.207992,38.077402,-24.442860,79.836004,38.089498,-24.211649,81.473730,37.169775,-24.201581,74.599852,42.608116,-22.143293,82.280624,39.429049,-21.323350,83.824566,39.491998,-20.639979,75.860853,45.255060,-19.693192,78.637936,44.077276,-19.306921,83.421626,41.611438,-18.986209,82.639004,42.341344,-18.752000,76.278170,46.500546,-18.458811,80.909854,43.673336,-18.385143,80.616228,43.911858,-18.073553,77.185211,46.451725,-18.014105,79.369585,45.177005};
			return value;
		}
		private double[] getCoordinate_9_21_point_67()
		{
			double[] value = {-17.573129,80.149886,44.802241,-21.463004,84.657499,38.582105,-21.255456,87.034443,36.644629,-21.217221,86.228105,37.617005,-21.013068,85.232950,38.714153,-20.759474,87.685449,36.699138,-20.680593,86.562474,37.968522,-20.617027,85.887554,38.747321,-19.750193,84.761794,40.395331,-19.702520,84.667336,40.493784,-19.424731,86.102851,39.904333,-19.292515,85.310581,40.797396,-19.024876,85.862726,40.858062,-18.720578,86.076634,41.068008,-17.741112,84.842825,42.565076,-26.556987,-136.186312,48.455271,-22.607622,-136.119842,49.343065,-22.413449,-135.437498,53.049239,-21.887018,-136.080772,49.650627,-17.678949,-136.410929,48.433905,-20.718193,-134.858520,56.398959,-27.182311,4.368098,48.499525,-25.394762,4.328677,51.077894,-24.026462,5.028745,52.190181,-23.132582,9.485832,49.875094,-22.911165,2.737229,55.668419,-21.996851,8.076860,52.262847,-21.136953,11.061470,51.269751,-21.093477,7.706015,53.544053,-20.147664,11.104586,52.326534,-19.915738,10.339747,53.004693,-18.879800,9.778565,54.351279,-18.234071,9.918988,54.786977,-17.305056,8.310277,56.367030,-27.519631,21.335255,46.880240,-26.622470,21.581093,48.297914,-24.782878,19.929708,48.627859,-24.261032,20.389728,49.757029,-24.194977,19.228132,47.533725,-23.354979,19.354560,49.163088,-23.320766,18.348410,46.833827,-23.266146,18.330113,46.910211,-23.218105,14.044888,47.005141,-23.010528,18.280855,47.479034,-22.744874,13.629532,47.834211,-22.691617,13.177801,48.089603,-22.583621,20.418790,50.179825,-22.570915,17.866893,47.547255,-22.441136,18.802251,48.986459,-22.320582,20.194144,50.166469,-21.533312,18.447224,49.493286,-21.334708,16.271969,49.036626,-21.154573,20.898565,53.197046,-21.079443,18.412549,50.144725,-20.916537,17.384056,50.135729,-20.537371,15.574730,50.149725,-20.495203,19.937544,53.185933,-20.306801,18.215814,51.283888,-20.212465,16.513818,50.599562,-20.069154,15.984435,50.746878,-19.670506,19.373064,53.467499,-19.623508,17.717215,52.076719,-19.182904,19.808509,53.897459,-19.107148,17.554025,52.336648,-18.852941,17.325942,52.305667,-18.792381,15.213045,52.075109,-18.777399,21.336364,55.092537,-18.695024,20.758460,54.668208,-18.466964,20.038770,54.256180,-18.404042,20.030966,54.326408,-18.344029,21.212397,55.427787,-17.954159,17.268940,52.846079,-17.815425,21.564271,55.843425,-27.458531,24.638963,50.577792,-27.192110,31.751922,53.040879,-26.873608,25.217751,50.800522,-26.862469,25.006670,50.781165,-26.496175,28.475433,53.669473,-26.303921,22.052092,49.937838,-26.026397,22.836051,50.642503,-25.740365,24.717932,52.726751,-25.446264,24.345323,51.496318,-25.441022,28.983486,54.704009,-25.293388,28.153034,54.942475,-25.173020,23.771547,51.286022,-25.101447,29.481334,54.912140,-24.890920,30.955886,55.556270,-24.724025,30.875889,56.077764,-24.660410,21.722945,50.378872,-24.636364,22.541086,50.797796,-24.524917,24.056855,53.442253,-24.438627,27.939902,55.405952,-24.301891,28.948888,55.989694,-24.273254,22.340878,50.822915,-24.236502,28.188160,55.755838,-24.148084,23.052895,51.551975,-24.107356,23.068442,51.790914,-23.957883,27.696907,55.855726,-23.889756,27.424309,55.774782,-23.843533,30.187567,56.941979};
			return value;
		}
		private double[] getCoordinate_9_21_point_68()
		{
			double[] value = {-23.827842,29.733158,56.811558,-23.732359,27.323895,55.881563,-23.572668,26.963955,55.835962,-23.266922,22.993900,53.067836,-23.260462,29.648882,57.077903,-23.255173,30.168060,57.073278,-23.211042,28.939824,57.007330,-22.744616,22.559446,53.039148,-22.708387,22.706906,53.575334,-22.558277,30.660569,57.038687,-22.428121,30.134199,57.043416,-22.350738,26.271790,56.447893,-22.020661,25.687318,56.071571,-21.918267,23.309645,55.036229,-21.647699,27.030913,56.762324,-21.579179,22.592229,54.683850,-21.320920,24.319519,55.540709,-21.068177,26.547151,56.614363,-20.047354,23.387299,55.520118,-19.668495,24.925177,56.146873,-18.025604,26.651821,56.629626,-17.468368,26.964744,56.841789,-17.468058,23.203471,56.218457,-17.202390,25.772869,56.340212,-27.513380,36.534153,51.706052,-27.509966,40.984728,49.865087,-27.509692,36.397344,51.437424,-27.388428,41.322651,50.177219,-27.352171,38.293962,50.987099,-27.325825,39.187736,50.748095,-27.096612,33.254998,53.400436,-26.882169,34.146613,53.736411,-26.869723,35.692589,53.365745,-26.863985,35.472830,53.455958,-26.757279,41.366669,50.991781,-26.746021,35.303227,53.651338,-26.301091,32.742269,54.137959,-26.222634,35.977119,54.081695,-25.848839,37.844540,53.777351,-25.670597,42.425768,52.547600,-25.188416,38.414109,54.155600,-25.039450,36.439952,54.294550,-24.992352,32.533669,54.860833,-24.812638,37.137343,54.353830,-24.717630,33.879916,55.833970,-24.713652,33.806974,55.910712,-24.296512,35.726576,55.131046,-24.125502,33.800028,56.796444,-24.056123,32.686753,56.828603,-23.879300,36.722335,56.176593,-23.877958,36.982598,55.240210,-23.858315,36.650206,56.292401,-23.661543,33.039138,57.002789,-23.522495,38.167541,55.142264,-23.510323,37.808931,55.942015,-23.202047,36.161000,56.923463,-22.996700,35.183051,56.929992,-22.706781,38.373245,56.496542,-22.689813,34.935388,56.929379,-22.350625,35.465257,57.014762,-22.322459,36.551254,56.922067,-22.310324,37.071860,56.892995,-22.223025,35.373834,57.111843,-21.948281,39.437611,56.406003,-21.702296,40.666509,55.634517,-20.825394,41.296987,56.135805,-19.649714,42.149062,56.846200,-27.463481,52.446201,53.596221,-27.360345,51.541387,53.456603,-27.336829,42.628027,49.763308,-27.214786,44.219006,53.172101,-27.189764,46.308787,53.364017,-27.177839,42.837187,50.118088,-26.971082,49.516935,53.141164,-26.379006,51.154120,53.882406,-26.173985,50.183634,53.766651,-25.963217,48.787030,53.468357,-25.855620,48.613844,53.507615,-25.829842,44.948999,53.917207,-25.767283,51.478627,54.913621,-25.188627,46.826632,53.761404,-25.131632,52.039698,55.671358,-24.876449,50.313688,55.309398,-24.688825,43.439464,53.909506,-24.495377,46.565659,54.252731,-24.362612,50.688911,55.886237,-24.344389,48.652778,55.239966,-24.259708,47.180787,54.646286,-23.785454,50.203354,56.224789,-22.354745,43.867911,55.289987,-22.097461,47.944978,56.246995,-21.771036,43.358284,55.536514,-21.690174,47.299759,56.147576,-21.664972,46.836578,56.024375,-21.231001,46.159569,56.148733,-20.218618,47.440096,56.602319,-19.484165,43.122301,56.821634,-27.274748,55.550357,54.227816,-27.095485,62.200593,52.515424,-26.838054,53.748293,54.183127};
			return value;
		}
		private double[] getCoordinate_9_21_point_69()
		{
			double[] value = {-26.626006,60.141660,53.869745,-26.579286,53.716875,54.462288,-25.951875,58.547806,54.624145,-25.940040,58.167779,54.625457,-25.409268,57.320203,55.448311,-25.039603,57.754721,55.816965,-24.906571,54.534238,56.537468,-24.746512,58.771956,55.198622,-24.468329,57.873809,56.502887,-24.455640,56.454166,56.816428,-24.097000,59.028247,56.647733,-23.940962,59.720830,56.365964,-23.677526,62.842317,53.874621,-23.492505,61.062897,55.235889,-23.476152,58.253237,57.037163,-23.436000,59.535263,56.980375,-23.422290,61.458428,54.736303,-23.340713,59.919734,56.961688,-23.270458,53.718209,57.038283,-23.011961,60.660165,56.914126,-22.827157,62.782990,54.174925,-22.392019,61.920752,56.741003,-21.292380,63.357715,56.707368,-21.201627,62.918528,56.955547,-27.486407,66.372663,48.649747,-27.446994,67.047768,47.587504,-27.435306,63.452490,51.671298,-27.419567,66.239586,48.885339,-27.197537,63.601893,51.816684,-26.968803,66.423264,49.368612,-25.899462,68.519649,47.906582,-25.803833,63.452354,52.136103,-25.502296,64.831517,51.398251,-25.326294,63.800518,52.339132,-25.315462,68.217839,48.573120,-25.291319,67.060725,49.624148,-25.215492,66.433268,50.221830,-24.907977,68.269167,48.831811,-24.569688,65.941782,51.642247,-24.291798,66.985162,50.940639,-24.114872,68.414625,49.655973,-23.375728,68.508784,50.239933,-23.300174,69.297191,49.451700,-23.120344,71.220733,47.281386,-23.007212,69.556434,49.324911,-22.738463,69.061753,49.848698,-22.279274,65.163758,52.762178,-22.151117,66.716202,51.706079,-21.857310,66.789018,51.707883,-21.840922,64.165706,54.850290,-21.648141,63.959768,55.844040,-21.622003,67.193601,51.605970,-21.510652,68.728127,50.455225,-21.502866,66.919471,51.984552,-21.419434,67.818071,51.345858,-21.305415,71.197105,48.986982,-21.168540,69.747928,50.517498,-21.157662,69.229357,50.891207,-21.106400,65.272623,55.176629,-21.017567,69.667743,50.967461,-20.974227,70.127451,50.542156,-20.940562,70.353870,50.316703,-20.541876,68.759154,52.469062,-20.210948,65.976880,55.315636,-20.160340,71.583540,49.790802,-19.484703,65.672274,55.970643,-19.465104,64.479105,56.648144,-19.429141,65.204431,56.240116,-19.156682,64.629067,56.700525,-19.094225,65.736175,56.022391,-18.825888,73.135189,49.290866,-18.156241,64.924997,56.963369,-17.728599,72.532120,50.746762,-17.725275,66.175447,56.314716,-17.666683,68.730899,54.373401,-17.590849,70.296342,53.001556,-17.539113,65.068448,57.039825,-26.948729,-133.764553,61.463447,-26.505035,-134.523755,57.428631,-25.730918,-134.406169,58.166456,-24.605331,-134.077540,60.089605,-23.865998,-132.917290,66.446029,-23.729364,-132.977610,66.138856,-23.331239,-132.875515,66.742988,-22.193292,-133.358623,64.290163,-21.962025,-133.830750,61.775104,-21.547875,-133.794754,62.024631,-21.368181,-134.660474,57.379556,-20.382117,-134.280169,59.562611,-19.584646,-134.606779,57.908377,-18.806656,-134.135691,60.553106,-17.913175,-133.473145,64.245856,-26.793199,-82.958725,63.220732,-24.442005,-85.199811,67.155453,-23.437283,-84.392013,67.297911,-27.140570,-80.966782,61.719976,-26.855731,-72.837600,61.175204,-25.756198,-78.073996,61.702280,-25.671373,-78.431463,61.597071,-25.359952,-78.790267,61.807030};
			return value;
		}
		private double[] getCoordinate_9_21_point_70()
		{
			double[] value = {-24.141565,-80.929267,64.221405,-23.226255,-73.182213,63.664939,-23.220963,-75.483481,63.755875,-22.931923,-78.387556,63.602061,-21.908260,-77.991439,64.343400,-21.199681,-79.104754,65.648947,-20.918675,-78.385002,65.203705,-20.434542,-79.097060,66.370233,-20.388668,-72.521248,65.711838,-20.299274,-78.484698,65.815140,-20.201822,-76.223999,66.020537,-19.839129,-79.284430,67.023533,-19.095677,-76.448036,66.802218,-19.022449,-76.341515,66.849235,-18.755388,-76.052317,66.936725,-27.481224,-65.191574,66.431185,-27.271051,-71.405640,61.068913,-26.637862,-71.793325,61.490992,-26.580156,-67.496590,64.520838,-26.556126,-66.705839,65.227989,-26.552742,-65.288727,66.955105,-25.965122,-66.937158,65.275988,-25.690386,-69.225211,63.493394,-25.616861,-66.397435,66.319563,-25.261855,-67.262052,65.624256,-24.626450,-68.557545,64.887299,-24.528670,-66.991777,66.379709,-24.242476,-69.112841,64.728639,-24.213012,-66.764723,66.883786,-24.037841,-69.853123,64.343536,-23.164499,-71.706947,64.029565,-22.939021,-68.890485,65.844613,-22.629109,-70.552543,64.886566,-19.844358,-69.591534,67.363702,-19.532302,-71.378993,66.686589,-18.664680,-71.162802,67.431729,-18.390895,-71.595879,67.402856,-27.227155,-0.567621,62.282226,-26.264254,-4.520304,64.720902,-25.884438,-4.199702,64.591962,-24.516347,-0.604945,64.082296,-24.374686,-3.523647,65.071602,-23.817638,0.126856,64.181139,-23.813676,-4.217601,66.470460,-23.734705,-2.246034,64.985523,-23.563099,0.036185,64.334356,-23.158291,-0.769184,64.842076,-21.879842,-2.684203,66.075563,-20.897069,-3.392156,67.108852,-19.906607,0.503260,65.947318,-19.190814,-0.132221,66.504579,-27.244993,3.172897,60.201754,-26.877395,1.989811,61.611247,-26.780603,1.547473,61.848734,-26.415433,2.860886,59.217193,-25.911732,3.050803,61.572713,-25.636761,3.081457,61.692942,-25.475033,3.171871,60.334220,-24.747915,1.215477,57.543085,-24.520233,3.163980,62.309406,-24.127271,1.737465,58.706758,-23.978493,1.199641,57.688897,-23.650385,3.308502,62.332343,-23.590498,3.164744,62.853894,-23.504824,3.306178,62.457509,-22.684971,1.442320,58.938691,-22.324648,2.672587,63.953629,-22.287500,1.363922,58.102254,-22.166495,3.302034,62.564598,-21.918720,1.293727,58.681185,-21.718795,1.317595,58.746628,-21.694253,1.477823,59.411569,-21.152669,2.309810,57.629516,-21.023591,3.087834,64.266298,-21.014441,3.295526,63.431737,-20.734677,2.352927,57.892261,-20.463346,1.385269,59.789554,-20.405054,3.080931,62.814874,-20.070665,3.246821,63.693136,-19.493608,1.806067,61.202985,-19.149975,1.691313,59.874194,-18.988632,1.764569,61.370111,-18.837273,2.840234,65.448933,-18.833639,1.602267,66.018158,-18.449832,1.552711,60.687025,-17.481689,2.652807,59.815637,-17.120845,5.586114,58.114270,-21.941536,30.101876,57.370585,-21.832179,29.928001,57.410507,-21.206444,29.056508,57.452896,-19.838207,29.041419,57.210003,-18.993084,30.611540,57.482068,-18.182721,31.518552,58.385999,-17.899003,29.521863,57.875304,-17.475227,30.711856,59.277889,-17.076705,27.654214,57.385443,-21.846276,36.781112,57.153241,-21.555916,36.856381,57.457850,-21.514188,37.430808,57.318741,-21.029336,33.665927,58.198522};
			return value;
		}
		private double[] getCoordinate_9_21_point_71()
		{
			double[] value = {-20.931268,32.132282,57.972752,-20.853566,32.198749,57.980590,-20.249112,37.409271,58.442342,-19.759704,38.046433,58.574624,-19.589714,40.949573,57.535404,-19.201042,41.072803,57.796180,-19.144625,33.679555,58.073307,-19.066280,40.368473,58.174700,-18.691109,35.916869,58.467310,-18.570439,32.604361,58.142021,-18.563556,33.634115,58.305958,-18.500482,33.959181,58.388256,-18.248384,32.340349,58.484639,-18.159970,34.705592,58.819388,-17.942879,36.155331,58.971468,-17.365677,36.594067,60.327381,-17.305547,33.070639,60.098349,-22.656778,51.678416,57.148798,-22.578173,51.795784,57.208960,-21.952981,51.391994,57.666137,-21.946309,52.860809,58.095806,-19.470489,48.122622,57.211877,-19.377294,51.054669,58.901982,-19.276075,49.252527,57.594325,-19.222605,49.771811,57.966954,-18.662880,46.502578,57.546519,-18.629802,48.456626,58.110418,-17.270572,46.584417,58.561350,-17.119300,43.029971,58.604402,-23.400638,55.325473,57.797167,-22.341092,59.421839,57.450524,-21.905715,60.636592,57.353581,-21.617954,54.902054,58.083810,-21.230751,57.857028,58.893663,-20.987318,57.675075,58.924957,-20.973605,59.007879,58.757363,-20.684982,62.514135,57.211678,-20.395485,61.299115,58.134910,-20.238939,60.788164,58.450891,-19.855783,56.567811,58.818477,-19.349705,62.259307,58.066359,-19.234256,54.503425,59.323579,-19.063178,56.808349,59.433486,-18.841903,62.218687,58.013131,-18.828070,58.794210,58.822418,-18.754605,57.110206,59.498909,-18.633691,59.513176,58.558978,-18.615987,54.746530,59.521299,-18.400174,54.916453,59.606021,-17.772672,61.145787,58.229167,-17.357106,63.401738,57.524498,-17.300769,54.791246,60.082236,-17.287576,55.283414,60.054710,-17.219991,59.968952,59.047185,-17.161569,58.447666,59.369979,-17.621633,63.946905,57.495618,-17.207318,64.171697,57.364747,-25.624336,-131.117013,75.919251,-23.301551,-131.917962,71.911304,-22.462740,-131.395057,74.843576,-21.339995,-132.245530,70.407198,-17.984348,-132.460068,69.700264,-17.607750,-132.430919,69.907701,-26.241245,-107.344623,76.985989,-24.629755,-105.451631,77.841833,-26.955811,-102.384651,75.409636,-26.745598,-95.101632,73.766619,-25.627953,-94.913274,74.594652,-24.746817,-101.111981,76.821584,-24.325067,-96.461839,76.114867,-22.495667,-93.961783,77.029733,-22.418838,-96.089703,77.585362,-24.477265,-92.871964,75.049048,-23.418581,-92.852981,75.906255,-23.154196,-92.553889,76.014400,-22.940322,-91.259948,75.871843,-22.257431,-92.759197,76.793772,-22.199194,-84.107949,68.154782,-21.425754,-86.903303,72.520748,-21.300408,-88.580756,75.651703,-19.819128,-88.972827,77.633129,-19.164834,-85.780205,73.059704,-18.364669,-84.577784,72.314147,-17.964353,-86.354846,75.404440,-18.431466,-80.939992,69.137953,-17.266895,-77.739322,68.032140,-17.262567,-77.064529,67.941421,-17.112935,-76.086428,68.242447,-21.559908,-65.172609,70.510007,-21.111135,-65.864990,69.995667,-21.080587,-63.562030,72.714246,-20.771550,-64.690470,71.351387,-20.674370,-62.519203,74.411426,-20.585808,-64.321258,72.146301,-20.505960,-64.762321,71.482573,-20.363795,-65.893787,70.449425,-20.019779,-67.188931,69.465181,-19.864003,-65.980491,70.596339,-19.612542,-64.311244,72.486683,-18.965923,-66.265030,71.016021};
			return value;
		}
		private double[] getCoordinate_9_21_point_72()
		{
			double[] value = {-18.333083,-65.283669,72.326751,-17.955541,-66.755956,71.022003,-17.886821,-63.193717,75.142688,-17.517947,-71.327285,68.286276,-17.507475,-63.777574,74.569639,-17.413887,-66.839838,71.414684,-27.482441,-58.013479,76.263848,-27.364305,-57.840730,76.509612,-26.541673,-59.013333,75.456935,-25.793159,-60.536457,73.882634,-25.474132,-60.815107,73.803583,-23.670111,-58.681206,77.524884,-23.333030,-60.533176,75.272430,-23.161073,-58.890828,77.611175,-22.728985,-61.311752,74.589340,-22.108174,-61.879132,74.177972,-20.182776,-61.807483,75.448484,-27.334575,-19.405829,75.897469,-27.219805,-11.697103,70.732462,-26.745021,-17.717046,75.494925,-26.521842,-15.964055,74.258970,-25.966591,-19.089922,77.191569,-25.902635,-15.745891,74.572837,-25.727663,-16.526943,75.688031,-25.712257,-16.926706,75.934627,-24.957135,-10.086263,72.118878,-24.780636,-16.326836,76.369472,-24.669313,-17.717836,77.108919,-24.588603,-15.930589,76.248534,-23.820355,-14.138579,73.764015,-23.404855,-13.967019,74.008214,-22.595230,-15.080786,77.041425,-22.421827,-15.595493,77.599332,-22.264968,-11.660476,73.833285,-21.942075,-14.462761,77.002081,-21.792610,-10.901360,73.906817,-21.551993,-12.832367,74.493165,-21.300178,-10.304170,74.137854,-20.498035,-13.601266,77.125618,-19.688776,-11.183009,74.969515,-19.182017,-12.426916,76.294866,-19.166320,-12.810292,77.233313,-19.016380,-11.114298,75.218463,-18.596892,-12.392549,77.050189,-18.530155,-12.387442,77.117471,-18.245217,-11.223252,75.678049,-27.433431,-9.117143,70.523334,-25.107785,-6.075074,70.829678,-24.876213,-7.132844,71.648941,-24.636016,-4.849431,68.436127,-24.615459,-4.791863,67.645961,-23.621129,-9.371840,72.803034,-23.278254,-4.439324,67.561865,-23.141755,-4.816318,70.176847,-22.389267,-6.557188,72.735464,-22.304280,-8.108040,73.278881,-22.182545,-5.129914,71.546040,-22.056610,-4.505599,69.343193,-21.849761,-4.690442,70.705366,-21.569820,-4.634035,70.803359,-21.235941,-8.304732,73.796761,-20.763771,-5.278663,72.491426,-20.461678,-8.100054,74.177908,-20.201175,-4.978423,72.331823,-19.714317,-4.645946,71.974441,-19.203604,-6.750983,74.264750,-18.938386,-4.048243,70.018457,-18.705543,-4.351717,71.625980,-17.838186,-3.507391,69.003261,-17.524540,-5.672822,74.286643,-17.258882,-3.119348,68.744296,-26.731176,-129.963150,81.993783,-26.640611,-129.992891,81.845590,-26.009528,-129.474345,82.597678,-25.084899,-129.342030,83.315911,-24.867607,-129.716255,83.575162,-24.433580,-130.021232,81.988274,-23.267108,-125.663894,83.773402,-22.429120,-129.532786,84.891506,-21.638227,-125.260949,84.958916,-20.758599,-129.215393,86.826947,-20.591815,-125.879372,85.989236,-20.036351,-128.053899,87.092405,-19.751120,-129.118341,87.485248,-19.025720,-128.568870,88.155162,-27.252171,-119.735119,79.127635,-27.162814,-124.327574,80.404457,-22.647143,-119.044330,82.486864,-21.173579,-124.649937,85.173369,-20.919607,-120.211229,84.180373,-20.733203,-123.094855,85.110143,-18.263003,-114.348578,84.947979,-26.492178,-113.303639,78.069422,-21.965296,-105.685245,79.988233,-20.634201,-107.596294,81.460580,-19.526534,-111.088898,83.127218,-19.358783,-104.019223,81.751014,-17.338852,-108.347502,84.372538,-22.668788,-103.327550,78.932389,-22.359940,-100.537464,78.580216};
			return value;
		}
		private double[] getCoordinate_9_21_point_73()
		{
			double[] value = {-22.288710,-99.873356,78.456141,-21.479297,-97.239961,78.597229,-20.758955,-95.981129,78.916738,-20.111069,-96.638549,79.605035,-19.907066,-97.509927,79.948272,-19.333799,-101.175920,81.189919,-18.369515,-100.632449,81.980789,-18.038770,-96.707218,81.384193,-17.985262,-98.728624,81.803251,-17.968913,-101.039577,82.361737,-17.651797,-94.093121,81.167330,-17.522113,-99.539626,82.364026,-17.458612,-100.263426,82.535014,-17.101226,-98.287778,82.518142,-19.667016,-92.996133,79.125001,-19.187221,-92.026997,79.281351,-27.524352,-52.324890,82.939859,-27.324071,-53.225613,82.413076,-27.034978,-53.577079,82.227199,-26.643915,-52.314262,83.669870,-26.594976,-53.307230,82.737580,-25.790434,-54.999306,81.098317,-25.130877,-53.888483,83.089860,-24.308429,-57.625723,78.689462,-23.607857,-58.283919,78.276837,-22.741845,-53.486077,84.993602,-22.686116,-55.124664,83.052660,-22.534801,-55.111815,83.166605,-22.190429,-58.786639,78.449685,-22.073570,-54.231404,84.523738,-20.000688,-56.115296,83.180411,-19.692041,-57.441117,81.530081,-19.392758,-58.030987,80.902860,-18.630578,-56.633702,83.076789,-18.289383,-53.718434,87.154519,-27.292371,-50.354082,84.140912,-25.793497,-46.262297,84.951079,-25.722284,-46.251792,85.014373,-25.716833,-44.563702,84.640292,-25.099017,-45.774679,85.549501,-24.516672,-43.045982,85.235192,-23.890722,-47.316554,86.978442,-23.745644,-48.654617,87.270746,-23.612385,-43.211329,86.106867,-23.197917,-42.323915,86.241258,-22.698619,-49.688994,88.252623,-22.608926,-51.354507,87.450527,-22.060731,-44.651665,88.015128,-27.454838,-36.070868,79.471898,-27.273707,-39.115668,80.973047,-26.853571,-34.512845,79.631227,-26.223367,-31.801751,80.535178,-26.115675,-34.017027,80.016628,-25.689291,-32.710569,80.289211,-24.837477,-38.244181,82.970251,-24.797578,-32.913969,80.670132,-24.364493,-39.214892,83.980707,-24.066441,-31.645725,80.992355,-23.970365,-36.520538,83.010118,-23.238341,-39.534550,85.174630,-22.922929,-39.469962,85.532887,-22.791019,-33.709120,82.677738,-22.653594,-40.686299,86.268748,-22.611737,-30.817721,81.629576,-21.899326,-35.629307,84.615646,-21.781075,-31.237582,82.294752,-21.248884,-33.854527,84.252419,-20.831518,-36.895928,86.293713,-20.226570,-31.489443,83.772420,-20.105240,-31.579569,83.930480,-19.947495,-39.760055,88.260814,-19.854907,-34.470854,85.942891,-18.625523,-32.358542,85.917018,-18.247548,-33.072566,86.654379,-17.818406,-32.193553,86.460509,-17.757860,-31.088311,85.993945,-17.134775,-31.071281,86.530918,-27.474943,-21.321846,78.489390,-27.007134,-21.235452,78.830434,-25.597060,-29.445237,81.501145,-24.816606,-20.266602,79.930566,-24.177112,-22.275413,81.416869,-22.893029,-29.948990,81.641204,-22.369415,-27.017470,82.723161,-22.352338,-20.949358,82.023933,-21.511414,-21.268349,82.686133,-20.718286,-30.100720,82.584377,-20.409813,-24.474265,83.579228,-19.029072,-30.178427,84.041049,-18.838771,-28.366262,83.430763,-18.820864,-28.181764,83.383548,-18.632385,-26.301695,83.244276,-18.477076,-26.967086,83.262596,-18.263164,-28.832358,84.143713,-18.150557,-27.145182,83.482726,-18.074695,-29.836622,84.799485,-17.871675,-29.583972,84.819373,-17.736296,-22.631814,84.349023,-17.476179,-21.334370,84.537396,-17.362077,-27.192222,84.026643};
			return value;
		}
		private double[] getCoordinate_9_21_point_74()
		{
			double[] value = {-26.915297,-20.083530,78.052832,-26.214115,-19.757108,78.406053,-25.193534,-18.862786,78.004539,-24.067025,-18.375485,78.593465,-23.671662,-18.757541,79.709070,-23.435441,-18.049984,78.878995,-23.121326,-17.738216,78.680450,-22.433194,-19.399396,81.158744,-21.779589,-16.584547,78.723165,-21.020920,-17.520585,80.875948,-19.878147,-17.021477,81.323594,-19.475416,-14.024531,78.582633,-18.918872,-18.859249,83.256177,-18.650030,-17.646546,82.762024,-18.252306,-127.890642,88.638658,-17.344543,-128.414083,89.604305,-19.578791,-51.607430,88.916584,-22.474024,-50.039365,88.334234,-21.970494,-50.197341,88.623174,-20.758687,-50.148320,89.553851,-20.756314,-50.411510,89.400749,-20.734773,-42.379853,88.510613,-20.580307,-41.641116,88.375821,-20.190608,-50.047693,90.058234,-18.395633,-50.795309,90.329299,-18.064802,-50.757456,90.530328,-18.028129,-45.479171,91.776150,-17.704443,-48.873813,92.306883,-17.549025,-50.326892,91.247453,-19.259017,-38.686883,88.482993,-18.201809,-40.291828,89.959562,-17.955266,-40.330929,90.269417,-16.948381,-68.790684,-17.980941,-16.474548,-68.949251,-17.870753,-16.005399,-65.500953,-19.152648,-15.438024,-68.849188,-18.167628,-15.199594,-68.329785,-18.501305,-14.954873,-70.319444,-15.904360,-14.398906,-69.125540,-18.036516,-14.198227,-70.023608,-16.738650,-13.849199,-66.853354,-18.655378,-13.444414,-69.656159,-17.499534,-11.720387,-68.715176,-18.073216,-9.912683,-69.410950,-17.554941,-9.727105,-70.958855,-16.278724,-9.151891,-67.040564,-17.788126,-9.090325,-63.939644,-17.791997,-8.863107,-70.738811,-16.483435,-8.064214,-64.005203,-17.542427,-16.787457,-52.611640,-17.673554,-15.947112,-60.551653,-19.142077,-14.118902,-58.335965,-18.482754,-13.830433,-60.106214,-18.714546,-13.462849,-52.146907,-16.179225,-13.442267,-54.535366,-17.275941,-11.385647,-54.911291,-16.590478,-8.118695,-57.090439,-15.976880,-6.886669,-61.832421,-16.818355,-6.682222,-60.067450,-16.320189,-16.351952,-51.306745,-16.932829,-15.147815,-49.949136,-15.543376,-7.546278,28.496343,-15.903839,-10.810205,41.636409,-16.283217,-9.887518,38.308517,-15.829096,-9.738462,39.497073,-16.518249,-9.351571,41.438410,-17.342213,-9.074183,37.627538,-16.822210,-9.003936,35.975240,-16.348521,-8.711543,40.427224,-17.136455,-8.496173,39.165257,-17.119022,-8.440911,41.824740,-17.654823,-8.416054,39.728159,-17.265428,-8.368175,38.104887,-17.263054,-8.334219,41.338095,-17.583680,-8.169127,38.265712,-17.701473,-7.635373,41.826813,-18.709521,-7.370971,40.173711,-18.894866,-7.232041,35.586392,-18.440842,-6.766730,41.250144,-19.547484,-15.619767,51.509338,-16.062873,-15.570105,50.943292,-15.848616,-15.560726,51.518300,-16.285134,-15.539087,50.070419,-16.339003,-15.491692,50.613171,-17.314640,-14.954024,52.296232,-19.846884,-14.933322,50.769829,-18.941877,-14.918826,48.582483,-16.354781,-14.826691,49.951675,-18.051368,-14.541113,48.136223,-16.419168,-14.539214,49.669726,-18.030197,-13.866120,47.818288,-16.349331,-13.737602,51.987872,-20.865305,-13.415542,46.098002,-17.419262,-13.367289,51.688669,-20.566216,-13.218569,45.308045,-17.667822,-13.177888,45.398052,-17.779390,-13.084301,48.647138,-17.577754,-12.877553,44.290365,-17.281821,-12.617319,44.007716,-17.175838,-12.605149,48.851819,-18.725697};
			return value;
		}
		private double[] getCoordinate_9_21_point_75()
		{
			double[] value = {-12.243230,44.706690,-17.728963,-12.232906,49.714572,-19.513417,-11.978360,50.098681,-20.096048,-11.767868,51.364482,-20.451579,-11.654070,50.447876,-21.231498,-11.443507,48.150038,-20.587383,-11.386960,42.598418,-16.391257,-11.380842,51.741787,-21.060970,-11.361758,49.015002,-21.117323,-11.250855,49.383454,-21.358311,-11.120710,45.916382,-19.066573,-11.034543,50.935002,-22.202072,-10.711232,45.634697,-19.101281,-10.644095,52.328375,-22.873443,-10.591860,45.723084,-19.259677,-10.274313,44.538216,-18.751150,-10.075836,50.333310,-22.347868,-9.719016,44.715207,-19.072539,-9.601724,43.325039,-18.291801,-9.426348,46.660728,-20.464455,-9.335778,50.207850,-22.511487,-9.293169,50.122406,-22.485353,-8.831675,52.281859,-23.467734,-8.600855,43.263369,-18.250035,-8.251057,51.076614,-23.228286,-7.975265,49.366490,-22.381422,-7.278911,45.252918,-19.622988,-7.191965,51.997572,-23.544536,-7.048740,43.897451,-19.520086,-6.978180,45.071350,-19.907695,-16.954625,62.953550,-20.275900,-16.899338,62.433502,-20.325846,-16.856616,59.849615,-19.581496,-16.572877,53.129131,-16.360954,-16.547546,61.385864,-20.533011,-16.510292,59.547940,-20.672581,-16.503788,58.328784,-20.152931,-16.501783,58.804030,-18.214624,-16.486301,58.908146,-19.238428,-16.394277,56.353534,-17.523931,-16.342889,62.213607,-20.747477,-16.331534,54.283153,-16.824677,-16.157723,57.587253,-18.267747,-16.130872,56.385270,-19.832113,-16.108509,54.767856,-17.204805,-15.979373,57.174586,-18.434955,-15.900261,60.134640,-21.075119,-15.887617,54.353119,-17.246638,-15.886214,56.914045,-18.608066,-15.846321,53.421456,-17.798366,-15.819592,55.196242,-17.779147,-15.641185,54.766635,-19.585567,-15.586366,60.157775,-21.345164,-15.430053,56.966062,-20.738383,-15.350373,52.993639,-18.360977,-14.950622,61.969561,-21.662414,-14.925080,57.715287,-21.882561,-14.914452,54.167784,-20.444247,-14.890747,58.682937,-21.985312,-14.816791,55.074992,-21.161009,-14.804916,55.626435,-21.402380,-14.630387,54.382339,-21.099216,-14.485629,61.401239,-21.920683,-14.480481,61.302979,-21.906194,-14.477212,60.410662,-21.956338,-14.435483,53.895940,-21.076315,-14.266692,61.407372,-22.219969,-14.227196,56.154929,-21.828772,-14.133263,55.688308,-21.737553,-13.988974,60.924682,-22.508962,-13.942210,62.684245,-22.352766,-13.925913,60.520304,-22.534090,-13.876799,61.962074,-22.382408,-13.680847,57.593923,-22.357507,-13.594265,63.144290,-22.361319,-13.558737,55.667833,-22.157116,-13.523971,61.091715,-22.651548,-13.323224,56.085657,-22.439274,-13.194393,61.682527,-22.688151,-13.086784,58.437425,-22.879359,-12.958112,56.801288,-22.724092,-12.545194,56.077691,-22.520235,-12.478719,62.835927,-22.555985,-12.434785,61.945620,-22.544715,-12.053711,61.654304,-22.862303,-11.809077,59.197191,-22.780620,-11.587922,57.275030,-22.575927,-11.564576,61.833684,-23.596186,-11.430011,61.314973,-23.676995,-11.102905,58.972046,-23.244917,-11.057442,60.645283,-23.934033,-10.948489,53.640613,-21.776059,-10.924278,59.840244,-23.969638,-10.899281,58.955498,-23.799598,-10.713083,57.105163,-23.529989,-10.676731,61.289237,-24.139411,-10.659046,56.412715,-23.602451,-10.522144,59.763878,-24.251293,-10.344663,62.697230,-24.156869,-10.306102,55.049722,-23.741591};
			return value;
		}
		private double[] getCoordinate_9_21_point_76()
		{
			double[] value = {-10.227551,53.924785,-23.526233,-10.104033,56.725924,-24.124092,-9.773155,55.188585,-23.976255,-9.596181,59.623109,-24.449102,-9.329479,59.607279,-24.534206,-9.304770,56.744823,-24.445112,-8.858378,58.746411,-24.759861,-8.780537,57.335209,-24.497720,-8.659878,53.927328,-23.950120,-8.451177,56.629586,-24.554464,-8.370052,62.087924,-24.630841,-8.282670,55.401886,-24.357446,-7.952566,58.031447,-24.877809,-7.656597,53.120369,-24.054990,-7.634569,59.356230,-24.803569,-7.559906,56.086295,-24.761842,-7.551978,54.264189,-24.402812,-7.192890,62.457779,-25.716520,-6.862950,57.960590,-24.545095,-6.751715,59.176843,-24.803389,-17.045737,70.698307,-18.577678,-16.990622,64.293119,-20.059056,-16.620323,68.932203,-19.039165,-16.496755,72.695143,-18.614214,-16.494748,65.563029,-20.046027,-16.492265,69.869315,-19.344338,-16.461982,68.816689,-19.297755,-16.440005,70.246616,-19.327149,-16.333053,69.946741,-19.465481,-16.216007,67.829791,-19.804696,-16.070446,69.247787,-19.822474,-16.048440,64.165823,-20.886570,-15.952619,70.621041,-19.505693,-15.898392,65.687443,-20.548748,-15.852880,66.445670,-20.603584,-14.970533,71.285468,-19.607348,-14.859070,65.094916,-21.482320,-14.802095,71.412922,-19.638598,-14.741646,70.643286,-19.959374,-14.615256,71.213284,-19.786503,-14.474444,64.344673,-21.830911,-14.273734,64.348996,-21.910583,-13.856542,68.850241,-21.349970,-13.846397,65.756196,-21.781463,-13.506075,68.998241,-21.547127,-13.181383,65.286271,-22.130985,-12.681811,63.861651,-22.561186,-12.445987,66.549918,-22.677635,-12.410727,66.425807,-22.718371,-12.380594,71.043180,-22.495524,-12.368880,66.509603,-22.712378,-12.121600,65.852121,-22.972854,-12.033205,67.758962,-22.820465,-11.917164,63.487987,-23.328994,-11.680777,63.805329,-23.483107,-11.618912,68.953682,-22.908307,-11.563789,67.139854,-23.048674,-11.562074,65.562497,-23.203562,-11.321912,68.927417,-23.141924,-11.302772,73.566640,-21.885388,-11.198904,69.766719,-23.443206,-11.197833,66.226990,-23.134364,-11.087876,68.612013,-23.432463,-10.861696,70.089787,-23.667192,-10.814181,66.860406,-23.952760,-10.041291,71.488889,-23.740507,-9.883344,73.555127,-23.438332,-9.877217,67.861694,-24.262375,-9.773867,73.721926,-23.473985,-9.735659,71.336668,-23.951458,-9.691890,70.894237,-24.161064,-9.651148,73.149305,-23.538425,-9.576878,69.239208,-24.595463,-9.174572,65.580535,-24.984122,-9.068680,63.743221,-24.307011,-8.994572,73.215603,-24.035204,-8.818174,64.638272,-25.104378,-8.720217,71.040017,-24.514330,-8.592346,70.022266,-24.922538,-8.449084,67.902913,-25.160388,-8.324915,70.309132,-24.895225,-7.765288,64.303234,-25.446832,-7.636881,69.003982,-25.516565,-7.027645,64.445535,-25.453176,-17.043860,77.706707,-16.384204,-16.435396,77.952726,-16.786299,-15.995529,75.468212,-18.445535,-15.357945,74.246166,-19.373652,-15.320719,80.657910,-15.905110,-14.493212,74.519824,-20.014814,-14.428891,75.741547,-19.448898,-14.391590,74.366055,-20.156210,-14.258815,78.179807,-17.659084,-13.726601,81.125561,-16.580363,-13.463512,76.105269,-19.398783,-13.414708,76.058914,-19.460892,-13.244676,76.726015,-19.224782,-13.166657,74.901974,-20.349039,-13.009560,83.492349,-15.674710,-12.626835,82.484514,-16.804668};
			return value;
		}
		private double[] getCoordinate_9_21_point_77()
		{
			double[] value = {-12.470600,76.371473,-20.547175,-12.287318,81.309689,-17.706476,-12.012418,75.527833,-21.234059,-12.008569,81.944630,-17.378784,-11.961104,76.358514,-21.109103,-11.810576,76.599623,-21.078855,-11.552125,80.209566,-18.745453,-11.373411,74.248151,-21.810570,-11.196965,75.361642,-22.097205,-10.912049,75.013905,-22.417967,-10.787181,74.525060,-22.611209,-10.679557,82.999406,-17.504669,-10.425717,81.275574,-18.432084,-10.368285,84.085281,-16.836759,-10.086591,80.711904,-19.016730,-9.961024,82.718956,-18.056567,-9.922118,78.774035,-20.335458,-9.895921,75.146255,-22.965046,-9.749931,79.484023,-20.015152,-9.491379,80.963611,-19.387207,-9.336305,75.075600,-23.200151,-8.849766,75.756229,-22.724463,-8.376721,83.408805,-18.324632,-8.265817,83.484868,-18.318876,-8.215682,82.186997,-19.242994,-7.797717,78.250155,-21.667826,-7.045966,83.675234,-18.753979,-10.600281,84.781379,-16.168956,-16.871588,-72.808540,-7.096319,-14.431759,-73.506775,-6.771413,-13.617037,-73.217430,-8.589570,-13.579159,-73.797803,-6.003826,-13.431641,-73.425686,-7.970230,-13.394877,-73.595518,-6.983260,-13.378655,-74.094155,-5.353523,-10.895231,-73.949019,-7.998846,-10.480180,-72.755170,-11.800179,-10.261675,-73.901458,-8.547203,-8.434269,-73.556874,-10.385951,-8.158579,-72.691486,-12.740802,-7.567111,-72.601629,-13.559029,-7.334857,-74.599390,-7.852964,-7.082755,-73.601758,-10.814608,-6.882250,-74.597038,-8.161759,-14.902822,-71.937143,-11.590966,-12.943771,-70.969444,-15.235204,-9.357171,-72.131219,-13.752851,-8.236312,-72.004961,-14.465592,-12.597225,-51.722935,-15.229920,-12.409980,-51.707122,-11.030938,-11.849394,-52.000456,-14.816693,-11.413501,-52.097084,-14.412618,-9.523257,-51.550677,-9.478489,-9.081519,-54.457788,-10.218288,-8.439505,-54.416408,-9.789820,-8.433696,-54.137776,-13.326957,-7.617391,-56.022084,-15.205398,-7.486412,-52.551564,-8.751338,-7.074881,-54.985782,-9.318899,-7.068980,-52.352945,-8.307877,-6.785900,-56.318973,-9.960610,-16.769221,-43.036110,-8.650336,-16.681500,-48.121307,-14.756205,-16.343826,-47.856609,-13.951318,-16.201138,-45.111458,-10.036301,-15.890158,-48.216911,-11.403735,-15.374314,-43.983184,-7.165670,-15.067857,-45.602543,-9.654429,-14.891669,-49.351394,-11.413055,-14.868974,-49.527912,-11.527782,-14.672322,-49.947175,-15.069878,-14.498535,-49.697954,-14.500995,-14.163014,-50.688656,-15.394860,-14.060165,-46.216073,-9.421119,-13.999535,-49.503462,-11.019274,-13.873999,-45.266502,-7.839917,-13.825335,-45.859092,-5.741260,-13.799500,-50.854946,-15.302723,-13.727289,-45.450075,-7.917904,-13.284033,-46.631650,-8.947318,-13.234595,-47.534993,-9.701576,-13.074177,-45.912701,-7.617118,-13.030303,-51.304089,-15.185166,-12.987329,-47.868574,-9.788342,-12.908165,-51.121177,-14.816146,-12.902354,-46.553038,-6.019454,-12.797814,-46.223950,-7.900941,-12.591769,-51.250308,-14.562718,-12.477117,-47.021499,-8.676743,-12.369985,-48.490963,-9.792104,-12.275813,-51.161959,-10.726696,-12.116353,-47.423113,-8.605655,-12.094206,-46.907535,-7.057220,-11.724230,-47.349322,-7.995647,-11.605018,-51.225710,-10.412625,-10.880375,-49.205920,-9.226974,-10.142992,-50.309724,-9.337027,-9.071571,-51.214518,-9.049476,-9.066055,-49.599551,-7.565137,-7.994320,-50.268722,-6.743744};
			return value;
		}
		private double[] getCoordinate_9_21_point_78()
		{
			double[] value = {-7.847739,-51.402257,-8.169979,-7.161285,-51.044056,-6.590179,-6.751468,-51.477018,-6.260813,-7.751187,-20.559201,-5.324087,-12.615973,-12.084524,-5.224869,-12.182826,-10.033064,-6.699644,-11.449176,-10.423424,-6.682254,-11.355449,-11.352303,-6.476003,-11.348670,-13.386402,-5.977682,-10.682341,-10.722040,-7.375045,-10.137237,-16.962049,-5.400957,-9.909243,-12.809151,-6.887677,-9.842174,-18.067456,-5.332595,-9.743496,-9.739014,-8.441063,-9.167279,-12.797349,-6.797624,-8.709422,-17.334010,-5.508559,-8.517752,-11.716777,-7.209864,-8.321067,-13.197977,-6.866091,-8.294954,-16.427558,-6.986469,-8.187743,-15.300315,-7.236629,-8.146933,-17.871064,-6.871282,-8.145173,-11.454009,-7.353024,-8.003313,-19.172377,-6.470770,-7.669105,-12.026697,-7.622234,-7.643715,-15.526497,-7.359926,-7.599700,-20.124625,-6.789919,-7.512523,-14.752525,-7.438262,-7.309897,-17.900056,-7.339239,-7.185963,-19.176747,-7.285664,-7.171286,-18.790531,-7.322124,-7.010916,-14.550649,-7.467503,-6.761190,-14.224080,-7.406987,-6.731945,-12.244215,-7.748670,-6.692700,-11.187739,-7.881269,-16.941278,-3.123725,-5.529324,-16.685112,-0.833046,-5.564448,-15.572220,-2.151355,-5.869411,-15.492899,-1.552962,-5.712630,-14.956571,-7.102959,-5.551844,-14.874472,-2.078827,-6.192169,-14.602728,-0.065279,-6.746085,-14.248306,0.272371,-6.969774,-13.143971,-4.982282,-6.345302,-12.855584,-8.317428,-5.573648,-12.846336,-5.163371,-6.308718,-12.828462,-2.273233,-7.258535,-12.793732,-4.462427,-6.620601,-12.506581,-7.838730,-6.750767,-12.477829,-1.144113,-7.081256,-12.442148,-1.813087,-7.405815,-12.300218,-6.955568,-7.253031,-12.116107,-7.573501,-7.537215,-11.780576,-1.096056,-7.697122,-11.608068,-4.709058,-8.258502,-11.470522,-4.873103,-8.483155,-11.414854,-9.002098,-7.234665,-11.317057,-3.059939,-7.589998,-11.244308,-0.840785,-7.901504,-10.991108,-2.455049,-7.713718,-10.879024,-9.420355,-7.337022,-10.846474,-0.300133,-7.887046,-10.704185,-0.816733,-7.920592,-10.491029,-3.775432,-9.371161,-10.313684,0.274329,-7.838976,-10.294193,-0.924247,-7.900082,-10.211315,-3.602902,-9.475406,-10.127655,-7.780033,-8.198029,-10.104738,-3.191123,-9.503879,-10.055749,-5.772178,-9.102499,-9.979458,-2.909152,-9.489830,-9.651666,-4.462128,-9.719266,-9.607273,0.008004,-7.986237,-9.534396,-0.933479,-8.222837,-9.533614,-6.941195,-8.740754,-9.406050,-2.736474,-9.646294,-9.359813,-6.683342,-8.884448,-9.340807,-4.442256,-9.679231,-9.002678,-9.671162,-8.285596,-8.996712,-4.486863,-9.525432,-8.908459,0.711656,-7.987404,-8.882319,-2.241852,-9.678534,-8.668694,-7.145937,-9.455009,-8.197947,-1.607159,-9.793506,-8.132196,-1.853774,-9.911482,-8.028175,-4.860644,-9.521336,-7.979525,0.318641,-8.693104,-7.729782,-0.320895,-9.500319,-7.321889,-7.225512,-9.025982,-6.865597,0.577655,-9.565200,-16.942760,5.570205,-5.252562,-16.924386,4.046508,-5.855581,-16.485374,4.367052,-6.125646,-16.249688,0.733574,-5.869944,-16.120141,9.736325,-5.207850,-15.943742,9.440290,-5.210968,-15.594978,5.779028,-6.466407,-15.528523,1.420031,-5.466228,-15.521128,6.041604,-6.413029,-15.328159,9.949760,-5.469438,-15.137869,3.519582,-5.746015};
			return value;
		}
		private double[] getCoordinate_9_21_point_79()
		{
			double[] value = {-14.938572,6.389379,-6.763086,-14.934324,1.756501,-5.578863,-14.926156,2.176051,-5.361966,-14.912544,3.088193,-5.553228,-14.867969,5.114863,-6.716035,-14.846201,4.256179,-6.275410,-14.637885,4.826409,-6.702028,-14.502330,1.776055,-6.056310,-14.462915,7.174827,-6.812807,-14.418371,1.378082,-6.808713,-14.272071,3.417507,-5.818039,-14.137043,8.116847,-6.679106,-14.124896,1.137756,-7.088026,-13.975439,2.132907,-6.250944,-13.684736,2.136222,-6.714466,-13.674375,8.796889,-6.951335,-13.278836,5.014327,-6.517201,-13.266637,6.317070,-7.126103,-13.177092,7.234244,-7.380297,-12.755873,10.333279,-7.377865,-12.370248,3.463193,-7.078898,-12.333582,3.018376,-7.768450,-11.903127,5.389152,-6.679802,-11.779018,4.643919,-6.819544,-11.728376,1.460555,-7.484718,-11.710969,1.206196,-7.348905,-11.554826,3.810692,-8.105361,-11.205278,8.746309,-7.142921,-10.993559,5.005065,-8.096641,-10.754134,8.240759,-7.185871,-10.538427,5.897633,-8.206198,-10.447522,9.745125,-7.503921,-10.338796,9.009070,-7.636455,-10.019464,7.729509,-8.249118,-9.984085,7.210649,-8.328753,-9.665946,7.790662,-8.404143,-9.366885,7.890061,-8.418651,-8.266358,9.218956,-8.390492,-8.009402,6.871836,-8.295891,-7.976606,5.222929,-8.456615,-7.949654,5.526249,-8.437062,-7.915985,2.237383,-8.090457,-7.873676,5.321334,-8.465098,-7.666822,2.103509,-8.130979,-7.625016,4.149392,-8.273178,-7.536613,5.644603,-8.410120,-7.304778,11.053762,-9.596512,-6.857548,5.454141,-8.425673,-16.408533,17.126266,-5.229267,-15.870727,20.748274,-5.350995,-15.774126,12.004819,-5.212538,-15.714941,11.900687,-5.263614,-15.626290,17.891752,-5.869999,-15.597893,17.218568,-5.863384,-15.590863,21.198117,-5.516774,-15.536019,12.646151,-5.472881,-15.507384,19.095001,-5.812254,-15.331742,11.970834,-5.760647,-15.217927,14.905833,-6.097303,-15.029616,18.664921,-6.309843,-15.010073,20.349864,-6.361136,-14.779370,16.953287,-6.430903,-14.577120,17.421564,-6.533121,-14.493214,21.111954,-7.144192,-14.251067,19.305643,-6.892672,-14.051989,17.358072,-6.765239,-13.967261,21.334722,-7.427192,-13.932077,13.580191,-6.447444,-13.898563,17.507558,-6.940612,-13.735686,11.410206,-6.162587,-13.682599,20.674990,-7.642661,-13.643422,21.587751,-7.717376,-13.600053,14.171823,-6.806617,-13.468314,19.210435,-7.569171,-13.286333,18.735654,-7.516821,-13.232275,15.154815,-7.502135,-13.012722,15.200011,-7.715159,-12.762133,19.306161,-7.818328,-12.524505,12.955452,-7.909346,-12.438659,12.390284,-7.817136,-12.188160,18.852133,-7.859796,-12.183181,16.067359,-8.166989,-12.171871,21.630970,-8.080642,-11.805944,17.823035,-7.995880,-11.610860,16.894675,-8.118238,-11.151192,15.661556,-8.283666,-10.753132,20.575797,-9.774875,-10.004910,17.949327,-9.637355,-9.957506,12.618003,-8.540722,-9.870138,15.667159,-9.302669,-9.516375,11.277265,-8.404670,-9.354866,21.314359,-10.246998,-9.040839,20.073031,-9.913244,-8.500199,16.691633,-9.622397,-8.240116,16.103934,-9.608170,-8.077777,14.494051,-9.673746,-7.994864,15.409373,-9.618636,-7.878940,15.613074,-9.617627,-7.859955,13.773030,-9.775136,-7.824789,18.592370,-10.876250};
			return value;
		}
		private double[] getCoordinate_9_21_point_80()
		{
			double[] value = {-7.351175,19.204038,-11.647648,-7.112683,11.423701,-9.707354,-7.080391,20.209478,-12.272084,-16.685709,31.111384,-6.566114,-16.595805,25.640024,-5.639875,-16.318040,28.654974,-5.464747,-16.152203,27.106079,-6.736519,-16.062117,27.849969,-5.892818,-15.817457,24.499530,-5.939538,-15.781983,26.105984,-6.683606,-15.743251,23.638233,-5.679334,-15.643195,23.437169,-5.667192,-15.475778,30.664215,-7.839120,-15.354846,25.309316,-6.413323,-15.261537,27.563640,-7.883168,-15.175835,24.812076,-6.406124,-15.074468,23.088997,-6.326963,-15.019849,29.519725,-8.775430,-14.915195,25.539460,-7.000550,-14.890451,21.821790,-6.708901,-14.635834,29.388229,-9.334579,-14.440158,29.651097,-9.604219,-14.130345,29.043637,-9.722774,-14.017167,28.560257,-9.466169,-13.927411,29.877270,-10.255074,-13.719838,27.868063,-9.420610,-13.508880,25.851337,-8.749375,-13.466893,24.800501,-8.333147,-13.112201,25.611896,-9.145314,-13.034048,25.228035,-8.963885,-12.916974,27.102100,-10.329006,-12.890766,26.059465,-9.942739,-12.879153,25.965085,-9.911219,-12.867041,22.273818,-7.860669,-12.786292,23.977385,-8.372296,-12.671737,23.487543,-8.285145,-12.340846,22.124009,-8.072774,-10.744573,22.624198,-10.228224,-10.662302,22.699669,-10.312266,-9.860196,24.599401,-11.334263,-8.884451,24.390750,-12.609165,-8.818651,21.705024,-10.904710,-8.799545,22.243086,-11.560997,-8.632903,22.656663,-12.102928,-7.496876,25.679219,-14.815481,-17.051902,32.169746,-5.256358,-17.020218,39.225391,-6.966984,-16.997569,41.821308,-9.815206,-16.866245,32.242706,-5.506306,-16.673893,35.928254,-6.710464,-16.632126,37.636844,-6.926327,-16.554691,41.230291,-8.868422,-16.543713,39.027481,-7.315959,-16.341048,32.400060,-6.714209,-16.292802,37.027971,-7.182413,-16.234725,42.434942,-9.928177,-16.171086,33.382396,-7.217441,-16.098231,38.338452,-7.628688,-15.998814,36.522437,-7.170546,-15.828710,34.554364,-7.665145,-15.576404,35.724629,-7.628423,-15.312838,37.398139,-8.017699,-14.985151,37.663212,-9.173531,-14.715125,36.362563,-9.383162,-14.666549,39.773328,-9.847847,-14.360939,40.990332,-10.436291,-13.792830,41.865144,-13.444778,-13.628680,37.650176,-10.201690,-13.580506,40.565575,-13.158008,-13.558869,38.977719,-10.555248,-13.521017,39.125035,-10.976497,-13.500085,41.541102,-12.511551,-13.486605,39.376943,-11.313270,-13.308016,41.103400,-14.703530,-13.289846,40.533683,-14.401862,-13.278189,39.992004,-14.071581,-13.167167,38.233743,-11.521530,-13.034718,35.094592,-11.226087,-13.019676,39.092289,-13.768095,-13.011632,38.477896,-12.732790,-12.868742,37.760856,-11.843113,-12.702809,36.490911,-11.676427,-12.565658,38.080367,-13.724031,-12.544893,38.383582,-13.974021,-12.516770,40.296288,-15.031740,-12.276860,37.934647,-14.005389,-11.891548,38.854136,-14.595958,-11.811698,32.205760,-12.739876,-11.323338,40.329661,-15.184647,-11.024991,36.526773,-14.462129,-10.879961,33.911284,-13.948622,-10.246056,38.843596,-15.066472,-10.017916,36.832987,-15.154797,-9.653514,32.440179,-14.973361,-16.587808,45.081622,-11.849625,-16.454200,44.647431,-11.646541,-16.269731,43.715012,-11.141352,-16.013943,44.511204,-11.476268,-15.988295,46.659903,-12.566337,-15.964071,42.991105,-10.290701};
			return value;
		}
		private double[] getCoordinate_9_21_point_81()
		{
			double[] value = {-15.959910,47.790768,-12.861555,-15.597574,50.793910,-15.423052,-15.538161,46.259930,-12.288473,-15.491542,50.004795,-14.801155,-15.353045,47.943816,-12.903125,-15.197088,42.791405,-10.353134,-15.118905,49.217698,-14.806278,-14.891027,48.649976,-13.881624,-14.688268,43.367057,-11.088560,-14.530871,48.081880,-14.815427,-14.513298,43.157064,-11.140079,-14.488462,47.801563,-15.200891,-14.329412,47.761503,-14.149116,-14.320855,46.760765,-13.007096,-13.761398,46.422652,-14.487264,-13.596901,43.577849,-15.230176,-13.517501,45.514862,-15.101194,-13.497872,44.849987,-13.246327,-13.471206,44.977469,-13.559207,-13.417235,43.324608,-15.531578,-16.976663,82.169767,-13.939825,-16.860293,79.795346,-15.021338,-16.437752,83.607090,-13.885328,-16.288230,81.299199,-14.579679,-15.919311,82.081139,-14.735930,-13.747533,83.741642,-15.258939,-16.969642,85.310080,-11.879915,-16.854599,85.072293,-12.321737,-16.448653,89.131159,-7.874582,-16.104455,84.877663,-12.986375,-16.037785,90.936141,-5.863324,-15.443990,85.896736,-12.544873,-15.429855,87.779376,-10.262156,-15.346510,91.772621,-5.306989,-15.256951,86.600330,-11.676681,-15.166252,85.976603,-12.636157,-14.213018,88.307654,-10.651059,-14.157373,85.003955,-14.055664,-13.938702,86.669591,-12.511414,-13.928062,86.432427,-12.697205,-13.834454,88.266267,-10.982829,-13.648264,86.076836,-13.217223,-13.228536,92.791391,-5.852067,-13.112855,92.550200,-6.290842,-13.035142,88.877344,-10.891840,-13.018215,88.537841,-11.301412,-12.874324,86.519714,-13.423278,-12.839870,90.433317,-9.251624,-12.198771,87.079774,-13.378201,-11.465487,86.019554,-14.696406,-11.209539,93.404064,-6.827313,-11.080401,89.021114,-12.205792,-10.059837,91.382627,-10.308268,-8.490751,87.586836,-15.294987,-7.305211,96.584485,-5.316399,-7.267657,95.104631,-7.554890,-7.145579,96.602429,-5.433180,-12.324906,-143.578268,4.986463,-11.916413,-144.648826,4.778864,-11.647105,-141.606814,4.460232,-10.762280,-140.402073,4.620281,-9.847176,-145.089897,2.677441,-9.842238,-144.872607,2.618034,-9.545485,-137.052700,3.047525,-9.313403,-139.390923,3.150979,-8.879365,-136.281601,2.283196,-8.687406,-143.364334,1.480958,-8.443611,-141.349806,2.362330,-8.139409,-141.694480,2.093904,-7.993337,-137.970069,2.032964,-7.987924,-142.889032,1.433554,-7.753633,-140.590846,2.437702,-7.191207,-141.703565,2.481426,-6.841466,-145.063225,3.223933,-6.655538,-145.106438,3.015813,-11.286874,-134.941734,4.514001,-10.730364,-134.794167,3.879316,-8.554165,-133.544106,1.474947,-8.116312,-132.825593,1.055945,-7.766034,-131.909253,0.799639,-14.698975,-114.844801,4.390827,-14.215424,-119.630639,4.569026,-12.656274,-119.614866,2.993269,-11.174806,-118.245661,1.344747,-10.485475,-120.987143,1.061053,-10.133919,-119.617354,0.509908,-7.874822,-118.758919,-1.679872,-7.851065,-117.719621,-1.855904,-7.629248,-119.363156,-1.714486,-7.335859,-120.787884,-1.509685,-7.187913,-121.201539,-1.398500,-6.966870,-122.425720,-1.082966,-6.966237,-114.970832,-2.432223,-6.898313,-124.663852,-0.568638,-15.986936,-108.399796,4.825762,-15.550968,-104.132497,3.790844,-14.166888,-104.001734,2.592284,-10.547425,-104.637446,-0.804052,-10.267568,-114.100920,-0.028925,-10.192253,-104.770616,-1.172999};
			return value;
		}
		private double[] getCoordinate_9_21_point_82()
		{
			double[] value = {-10.068870,-106.659460,-1.233395,-10.013034,-105.018728,-1.437014,-10.007027,-107.022763,-1.237220,-8.934193,-113.276473,-1.517667,-7.851712,-104.841750,-2.996480,-7.799616,-109.154536,-3.290616,-7.182471,-104.736381,-3.146537,-7.159924,-105.934099,-3.848989,-7.119840,-110.824022,-3.260064,-6.870155,-112.337484,-2.864207,-6.641180,-113.228967,-2.546716,-14.666657,-103.589378,3.334482,-10.514791,-102.820785,1.764051,-8.775205,-100.173431,4.668205,-8.607359,-102.727459,0.793640,-8.452335,-103.127690,-0.012125,-8.439920,-101.143876,3.152874,-6.689081,-103.271173,-1.000605,-16.130620,-74.606676,0.516594,-14.445591,-74.427655,-2.442986,-14.037540,-74.394046,-3.320909,-13.747536,-74.231987,-3.927273,-13.377868,-76.620235,3.574304,-13.126281,-75.040115,-1.644223,-12.730442,-77.431402,4.571605,-12.256822,-75.399100,-1.511961,-12.240209,-74.731025,-3.618677,-11.915643,-77.061655,2.619351,-11.066968,-76.808934,0.975104,-10.955247,-79.088952,5.202114,-10.814500,-76.813096,0.672360,-10.649099,-75.293201,-3.499197,-10.618336,-78.982113,4.817306,-10.554206,-78.787469,4.389382,-10.508762,-76.303873,-1.050952,-10.299231,-75.617571,-2.740971,-10.144751,-75.467938,-3.747675,-10.017386,-78.086390,2.432065,-10.015302,-75.050513,-5.002976,-9.235223,-80.370231,5.128138,-8.548720,-79.704728,3.433188,-8.483028,-76.949784,-1.437608,-8.474423,-77.952617,0.916872,-8.183527,-78.452845,1.262407,-8.097010,-75.504469,-4.826154,-7.256540,-80.776783,3.623980,-7.008701,-82.745966,5.184291,-7.004879,-76.343632,-3.393250,-6.732328,-77.919646,-0.094054,-16.685309,-42.184439,-4.393554,-16.580790,-41.322499,-4.156809,-16.560613,-43.286829,-5.022574,-15.421204,-43.772697,-4.649998,-15.192478,-43.773491,-4.588420,-15.026530,-41.165526,-3.730497,-12.596068,-44.299293,-4.199518,-12.338664,-42.020377,4.340877,-11.714715,-42.511915,5.008345,-10.994790,-44.342215,-3.620312,-10.652570,-43.173049,3.238077,-10.394917,-48.385648,-4.986922,-9.707996,-48.746108,-4.753896,-9.598541,-41.768206,-1.513444,-9.556159,-42.845636,-2.290128,-9.483768,-49.303016,-5.100919,-9.480987,-42.531361,-1.978989,-9.419172,-43.454625,2.191569,-9.265479,-43.841304,-2.637065,-9.121953,-42.607709,-1.754107,-8.917421,-44.264303,-2.715307,-8.791393,-43.791344,-2.299748,-8.634700,-42.645475,-1.456113,-8.226344,-42.754832,-0.738403,-7.995149,-48.249679,-4.144772,-7.839137,-46.272082,3.897467,-7.703168,-41.306795,4.499601,-7.694618,-46.417319,3.996692,-7.573185,-41.698809,4.769633,-7.459075,-41.833466,4.524845,-7.172920,-46.620563,5.058813,-6.925686,-51.338851,-4.787200,-6.695633,-44.271756,-0.726767,-16.722327,-33.915590,0.648354,-16.201532,-35.808421,-1.469534,-16.112490,-34.800954,-0.659036,-16.021306,-38.011125,4.921948,-15.918092,-35.014719,-0.711952,-15.112107,-38.683050,-2.502061,-14.177392,-37.302367,1.480540,-14.122017,-37.756804,-1.617523,-13.927457,-37.833700,-1.539578,-13.757809,-39.457452,2.875270,-13.741854,-40.173247,-2.725419,-13.720124,-32.317260,4.909950,-13.436645,-32.718832,5.209312,-12.784920,-31.271363,4.220484,-12.707716,-38.402688,-1.123600,-12.599965,-31.197076,3.966315,-12.350553,-33.119041,4.680839,-12.226554,-38.905795,0.221677};
			return value;
		}
		private double[] getCoordinate_9_21_point_83()
		{
			double[] value = {-12.142673,-31.062218,3.243664,-11.995674,-33.169013,3.646111,-11.994197,-31.176600,2.963808,-11.494703,-39.894650,-1.489703,-11.144819,-33.739812,2.948159,-10.465608,-34.390128,2.347101,-10.363882,-35.866568,3.055893,-10.326545,-35.751883,2.943729,-10.259598,-31.091183,0.880961,-10.208941,-36.402369,3.421998,-10.205570,-33.653688,2.100691,-10.077574,-41.000022,-0.913444,-9.973294,-38.234604,4.609304,-9.862503,-34.446668,2.239694,-9.846460,-34.640792,2.295175,-9.755932,-35.274611,2.505643,-9.712126,-34.369510,2.107201,-9.175691,-37.820418,3.694651,-9.161577,-39.139150,5.115283,-8.988230,-35.588821,1.850702,-8.827113,-31.458833,-1.233817,-8.235217,-37.385919,1.197295,-8.110869,-36.367105,0.165094,-7.998066,-32.244207,-0.938213,-7.746916,-38.662589,1.818482,-7.730922,-36.594763,0.267313,-7.502006,-33.438036,-0.650739,-7.377682,-36.056670,0.199566,-7.336364,-35.689702,0.094637,-7.164617,-40.689732,3.455408,-6.698839,-30.837465,-3.224930,-6.671582,-36.791177,0.361017,-6.668875,-39.548049,1.390208,-16.949771,-20.931942,-0.647540,-16.914088,-22.817366,0.605116,-16.764964,-25.373217,2.676094,-16.597575,-20.391338,-1.250906,-16.566683,-26.251087,2.776820,-16.472708,-27.215410,3.092170,-16.439715,-26.553083,2.676490,-16.157590,-26.963184,2.655723,-16.154121,-27.249224,2.885745,-16.078484,-21.285888,-0.981726,-15.904019,-25.281741,1.531256,-15.670579,-22.565140,0.011955,-15.473224,-21.823045,-0.498639,-14.916513,-26.754390,1.521796,-14.855135,-28.237241,2.607498,-14.754333,-25.580240,1.129324,-14.614407,-27.668397,2.076716,-14.593666,-25.429596,0.962493,-14.139296,-22.132256,-0.945221,-14.131923,-22.918769,-0.693196,-14.076321,-21.332645,-1.258422,-13.837858,-22.221318,-1.252117,-13.816589,-28.671053,2.002747,-13.811096,-29.870504,3.153096,-13.787727,-23.907703,-0.878628,-13.590614,-24.592464,-0.807243,-13.391144,-23.302113,-1.568446,-13.276828,-27.905967,1.288622,-13.225817,-23.031136,-1.661360,-12.790473,-22.248168,-2.046779,-12.760085,-26.748552,0.432203,-12.508665,-22.814137,-1.979937,-12.342493,-27.277227,0.947479,-12.246534,-29.393806,2.769526,-12.224499,-29.562095,2.849414,-12.016051,-30.026141,2.909542,-11.961813,-30.513292,2.909055,-11.957297,-21.550408,-2.428257,-11.899182,-23.159557,-1.526494,-11.590051,-21.842083,-2.116325,-11.537837,-24.003096,-0.963897,-11.494294,-24.691886,-0.684617,-11.425103,-25.200180,-0.449205,-11.240193,-26.965017,0.577894,-11.221912,-30.596194,2.126162,-11.217222,-24.292002,-0.850296,-11.213714,-25.560888,-0.325998,-11.206092,-22.403478,-1.707992,-10.956274,-27.068422,0.550610,-10.302631,-30.219752,0.415493,-9.984714,-23.098661,-2.106901,-9.663602,-27.120347,-1.444575,-9.462022,-24.436345,-1.995601,-9.334864,-20.765909,-4.175237,-9.212713,-28.487126,-1.569563,-8.894901,-22.349920,-3.609906,-8.700845,-23.952623,-3.013609,-8.651552,-21.676905,-4.063467,-8.616590,-21.328202,-4.204343,-8.594297,-20.937697,-4.405351,-8.251391,-26.379554,-3.179303,-8.188487,-27.060323,-2.820935,-7.958254,-21.072913,-4.497878,-7.828389,-23.476062,-3.797447,-7.794386,-23.067026,-4.046201,-7.783769,-29.276825,-1.922676,-7.700170,-26.961823,-3.497022};
			return value;
		}
		private double[] getCoordinate_9_21_point_84()
		{
			double[] value = {-7.646238,-23.050134,-4.064444,-7.623214,-27.355098,-3.483956,-7.517942,-21.260115,-5.120626,-7.444815,-25.149863,-3.756595,-7.265447,-22.094155,-4.657096,-7.173815,-30.303346,-2.746323,-6.953065,-26.626535,-3.755078,-6.846840,-25.131888,-3.761487,-17.046192,-17.303779,-2.275410,-16.908378,-15.525014,-1.727450,-16.816453,-17.822370,-2.376585,-16.144477,-18.025580,-2.635178,-15.990124,-13.231441,-2.917892,-15.803569,-18.676376,-2.491713,-15.799783,-14.828808,-3.576975,-15.436195,-14.388863,-3.788263,-15.428424,-10.760488,-3.967361,-15.263689,-16.220663,-3.124810,-15.181069,-13.029667,-3.923971,-15.166272,-16.143184,-3.186210,-15.150394,-14.949229,-3.691387,-14.922805,-14.363817,-3.748841,-14.710883,-10.638237,-4.261238,-14.703717,-11.872607,-4.409146,-14.619827,-12.224885,-4.568740,-14.194559,-9.869750,-4.707096,-14.113312,-10.438855,-4.626417,-14.090416,-12.555503,-4.711861,-13.707781,-12.931927,-4.667775,-13.688711,-13.747767,-4.413293,-13.403681,-19.678779,-2.387153,-12.986792,-15.174940,-4.232308,-12.819342,-14.217808,-4.387041,-12.773655,-15.169267,-4.242231,-11.580813,-16.839623,-3.947330,-11.105253,-16.673717,-4.730310,-9.818915,-19.093902,-4.865987,-9.432975,-19.103583,-5.035986,-9.267851,-19.925150,-4.570440,-8.205103,-19.426459,-5.111446,-16.896169,-9.156436,-4.576507,-16.203763,-7.971833,-4.879784,-16.077834,-8.511888,-5.006676,-15.802573,-8.249272,-5.144524,-13.840648,-9.625020,-4.908067,-16.961521,9.947645,-3.701747,-16.372450,10.428622,-4.620430,-16.312032,9.178474,-5.059709,-16.298086,7.622345,-4.962419,-16.281731,1.884005,-4.528543,-16.167581,8.392185,-5.044356,-17.045596,20.496087,-2.503994,-16.619673,17.224639,-4.484913,-16.163882,15.742322,-4.871303,-16.107520,15.618336,-5.051571,-16.076631,13.000416,-4.429437,-16.984886,22.004183,-2.824493,-16.867162,24.756516,-3.230957,-16.851765,24.562649,-3.194476,-16.795914,23.970844,-3.175464,-16.747128,25.656138,-3.742428,-16.731833,24.946250,-4.034148,-16.638600,22.686692,-4.976941,-16.383916,27.140555,-4.772120,-14.578899,96.446604,1.524225,-14.346179,95.112063,-1.278969,-11.031543,97.890409,-0.155622,-10.012302,99.750280,4.759487,-9.485462,99.341576,1.697275,-9.344580,98.401677,-1.183631,-9.147316,99.524649,2.015456,-8.774332,100.364478,4.395694,-8.515852,100.480695,4.250511,-8.045282,97.189472,-4.176879,-7.934305,97.051258,-4.395659,-7.741386,99.532860,-0.379171,-6.848638,97.539989,-4.848035,-6.768447,98.073903,-4.230661,-16.958385,-139.905408,10.558580,-16.347821,-138.160103,10.437599,-16.160015,-140.728969,9.140105,-15.840377,-140.927351,8.703315,-14.969955,-141.060839,7.832589,-14.888060,-143.277381,7.705387,-14.703538,-144.005714,7.873708,-14.688621,-142.848782,7.402227,-14.193912,-140.195465,7.949332,-14.028074,-143.572994,10.297781,-13.721129,-143.849753,6.561532,-13.531519,-142.820927,14.420271,-13.349710,-138.521822,7.273031,-13.119215,-141.623743,5.795019,-11.778772,-143.638254,10.247511,-9.076168,-143.097424,13.526170,-6.734132,-144.362439,7.017850,-15.737796,-131.778810,8.642356,-13.339826,-130.320989,5.714162,-17.051723,-115.755554,6.923329,-15.946845,-99.011018,11.261469,-15.511393,-93.925152,14.671718};
			return value;
		}
		private double[] getCoordinate_9_21_point_85()
		{
			double[] value = {-15.255468,-98.912844,10.902400,-14.971876,-101.113344,7.582795,-13.670229,-98.960421,9.725056,-13.189325,-97.831176,10.470358,-12.679020,-95.916225,11.394666,-11.616224,-100.929115,5.664637,-10.382186,-100.035422,6.029828,-8.623006,-95.987156,7.899458,-14.519652,-88.375139,15.470487,-14.268639,-88.595589,15.189615,-14.254522,-87.147172,14.158287,-14.198865,-87.517861,14.481776,-14.131038,-88.609939,15.058203,-13.708642,-87.651008,14.052475,-13.415222,-87.488115,13.454616,-13.278212,-88.302222,14.154100,-12.937517,-87.637719,13.015730,-12.935787,-88.516916,13.874135,-12.886866,-90.963845,12.790212,-12.867349,-90.294403,12.889613,-12.475827,-92.855690,12.244654,-12.192220,-90.563772,12.217460,-11.672280,-88.085933,11.948476,-11.080265,-89.239327,12.141925,-10.937422,-88.782332,11.823812,-10.777942,-92.519494,10.786007,-10.719192,-87.503207,10.508562,-10.664241,-92.353860,10.702987,-10.182743,-92.382865,10.271447,-9.391785,-87.972910,9.224495,-9.228306,-88.650150,9.466899,-9.149816,-83.495158,7.746864,-8.254049,-89.844174,9.408731,-8.208817,-83.451108,6.580304,-7.884237,-88.665506,7.768731,-7.673085,-84.887293,6.832673,-7.376691,-88.772970,7.351453,-7.137949,-83.054087,5.481400,-6.942488,-87.245056,6.773012,-6.938866,-91.605536,7.309618,-6.742047,-89.933768,7.842769,-6.636753,-90.915403,7.500553,-16.924398,-75.806436,6.111675,-16.900839,-79.995955,14.445635,-16.816969,-78.196795,11.470484,-16.815886,-75.881302,6.271463,-16.597226,-79.719176,13.673380,-16.525282,-79.738530,13.614662,-15.966387,-80.103749,13.335794,-15.579601,-76.157734,5.280687,-15.573355,-80.592622,13.342615,-15.307070,-79.468591,11.535466,-15.212638,-80.999590,13.291094,-14.812996,-79.706908,11.142037,-14.713609,-76.592644,5.280049,-14.563079,-81.369120,12.820226,-13.524547,-81.004850,11.248465,-13.494797,-81.406136,11.550787,-13.021217,-81.565004,11.109003,-12.865253,-79.041950,7.716706,-12.502930,-81.661967,10.404381,-12.485075,-78.987524,7.251779,-12.327200,-78.892052,6.812894,-12.300204,-80.184628,8.563663,-12.199890,-81.488343,9.963021,-12.082284,-78.238896,5.273311,-11.713580,-79.306017,6.611359,-10.277596,-80.305569,6.352860,-9.789680,-82.425792,7.850764,-9.109920,-80.866892,5.458638,-10.520872,-43.513523,5.460244,-10.198016,-42.618983,6.562652,-10.085894,-42.481599,6.675652,-9.966749,-43.942541,5.745005,-9.811324,-43.049725,6.513005,-9.523747,-43.634877,6.342129,-8.921229,-44.055338,6.301242,-8.800316,-44.219088,6.260109,-8.629937,-44.914607,5.822314,-8.420481,-43.971636,6.570277,-8.306256,-42.457485,6.598374,-8.210847,-45.393225,5.678707,-6.884708,-44.500025,6.488315,-16.839929,-33.440729,8.712831,-16.822167,-30.867970,7.121427,-16.020556,-37.303802,7.340418,-15.833160,-33.872822,7.483547,-15.559537,-32.630258,6.880804,-15.330352,-38.228508,6.828092,-15.232747,-38.300494,6.824706,-14.679799,-37.980696,7.586611,-14.586317,-36.577798,8.096981,-14.498604,-36.209995,7.985991,-13.050361,-38.224138,7.659272,-12.112260,-40.363161,7.201010,-16.996994,-29.566991,6.199450,-15.723589,99.530786,15.324254,-14.807530,100.045811,15.593217,-13.563757,99.988258,9.670719,-12.642075,100.939053,13.052876};
			return value;
		}
		private double[] getCoordinate_9_21_point_86()
		{
			double[] value = {-12.144027,99.528052,5.893515,-11.786841,100.923622,10.409308,-11.586848,100.837076,9.753454,-11.367742,100.367150,8.274899,-11.358206,101.459806,13.199716,-10.900685,101.026682,9.080427,-10.825512,101.042740,8.996779,-10.806043,99.797914,6.138532,-10.552421,101.673598,12.106987,-10.204462,100.117993,6.040241,-9.959574,100.263624,5.840298,-9.924231,101.458878,9.391586,-9.921687,100.011022,5.456972,-8.668556,102.142892,10.937955,-8.459801,100.859271,5.367313,-16.115090,-140.882227,24.529580,-15.616362,-142.472436,16.020400,-14.169446,-141.899818,19.302404,-16.931854,-86.995748,17.383070,-16.097409,-87.820827,17.079369,-16.019216,-87.021518,16.224965,-16.877112,-82.444959,16.181296,-15.195370,98.182035,25.621658,-15.030007,98.707966,25.022453,-15.001428,98.435527,25.415812,-14.629194,98.484647,25.474557,-14.490298,98.284612,25.886707,-13.810298,98.886601,25.339560,-13.588065,100.368824,22.284098,-13.271074,99.885609,24.095342,-12.059228,101.143556,21.867525,-11.907538,100.418568,24.989916,-11.415450,100.983249,22.977841,-11.396403,100.974169,23.342951,-10.983994,101.306193,23.441697,-10.735983,101.534314,22.188798,-10.254737,101.949569,20.337492,-9.347451,102.215228,22.410703,-9.152649,102.439683,20.579997,-7.107531,103.067091,19.003130,-6.778640,102.471606,25.185807,-14.654167,-139.733243,30.921927,-14.394846,-140.570784,26.439592,-14.391912,-140.643840,26.045936,-10.110357,-139.024570,35.352540,-16.058227,93.427391,35.109288,-14.679695,94.316596,35.408052,-15.891275,97.512670,26.069882,-15.301711,97.646229,27.677579,-13.856931,97.488581,30.466189,-13.801544,95.856068,33.905121,-13.085162,99.408589,26.147359,-12.280067,96.354956,35.106355,-10.040345,98.143459,33.803976,-9.802138,101.131748,26.103600,-9.259439,100.367806,29.037737,-9.182133,100.671151,28.293108,-9.142775,97.635757,35.256185,-9.131625,97.945242,34.947006,-9.086553,101.382190,26.210029,-7.911362,98.099008,35.089972,-7.869632,98.589281,34.649481,-7.465358,97.981962,36.037208,-6.934008,98.620653,34.863200,-6.924017,98.346201,35.770814,-16.631304,-137.132910,44.680550,-16.603313,-137.213664,44.249083,-16.138302,-137.306487,43.810814,-15.960402,-137.774140,41.312413,-10.610695,-137.358956,44.268339,-10.023868,-137.398022,44.136353,-8.785879,-137.529656,43.592435,-17.062214,80.712690,45.282632,-16.889827,82.891714,44.289243,-16.874697,79.293138,45.974052,-16.810720,79.139747,46.198309,-15.216962,83.166697,45.771148,-14.655735,84.027659,46.602315,-17.051137,91.380348,37.077751,-16.997028,89.569659,39.409762,-16.884452,90.168252,38.888353,-16.709119,91.523017,37.399058,-16.550817,84.788824,43.448268,-16.444149,90.901035,38.536202,-16.271604,91.763363,37.581435,-16.264789,87.667767,43.101449,-16.165811,90.036145,40.985580,-15.990448,85.456653,44.638138,-15.569873,84.648346,45.446025,-15.438783,88.325567,43.445041,-15.343729,90.688543,41.203832,-15.075695,88.345444,43.676110,-15.043337,92.730862,38.520771,-14.834541,85.293934,46.049625,-14.684633,86.013052,45.685541,-14.682446,88.010089,44.104891,-14.487803,86.450598,45.464994,-14.479426,88.472790,43.653067,-14.458601,93.395370,38.003205,-14.237986,87.111042,45.007512};
			return value;
		}
		private double[] getCoordinate_9_21_point_87()
		{
			double[] value = {-14.213855,91.907002,40.187533,-14.046909,91.928547,40.092402,-14.004668,94.275420,36.858560,-13.985298,93.034120,39.013557,-13.978893,92.740267,39.323938,-13.859237,93.154250,38.887959,-13.854602,88.874176,43.140146,-13.691953,89.418987,42.645632,-13.411156,88.544734,43.680547,-13.257399,91.209643,40.908444,-13.211586,91.035977,41.149566,-12.670238,90.565099,42.502706,-12.252003,91.810092,41.711139,-12.020203,86.963250,46.023100,-11.830972,88.965034,44.347667,-11.798758,93.375333,40.174250,-11.548466,86.922963,46.084395,-11.399674,94.543772,38.230033,-11.383325,94.222714,39.241025,-11.349972,88.099165,45.113844,-10.886042,91.647742,42.167527,-9.935598,93.951376,40.223979,-9.366124,89.247933,44.996277,-9.104421,90.536081,44.215499,-9.095417,92.112541,42.867637,-8.453065,89.814401,44.983177,-7.547940,89.986811,45.209565,-7.233307,92.711117,43.074119,-7.007351,92.312620,43.565820,-6.829131,91.929979,43.965913,-11.717794,94.949774,37.236031,-11.682640,94.873752,37.349328,-11.514810,95.891560,36.488185,-11.236304,94.799734,37.855473,-10.843016,95.375021,37.180836,-10.482010,94.881245,39.134287,-10.052680,96.174418,36.633127,-9.113404,96.858393,36.608868,-8.468741,96.073658,38.615799,-7.809109,95.514803,39.507184,-7.476645,96.208624,38.748807,-16.903495,-136.318501,49.036052,-15.677879,-135.520808,53.502639,-14.947697,-135.421379,54.136493,-8.612129,-135.189543,56.235985,-7.539673,-136.312127,50.325553,-9.581719,-135.003389,57.110045,-15.714683,11.132603,55.946515,-16.966097,20.198183,55.435970,-16.520548,16.425537,53.867793,-16.471145,21.021507,55.791524,-16.421480,16.118876,53.917630,-16.370913,18.590636,54.699621,-15.700520,20.731338,55.521472,-15.005389,18.076934,54.549630,-14.843228,13.223737,55.653906,-14.785195,18.711292,54.706364,-14.607301,14.887004,55.301505,-14.061297,20.827958,55.251878,-13.274316,12.310125,57.010190,-12.123798,17.829136,56.249603,-12.089517,19.741009,56.141356,-11.487926,16.763074,56.835787,-16.750778,24.698368,56.043598,-16.564826,25.708652,56.434734,-16.188200,24.804697,56.057932,-16.067871,25.655929,56.733843,-14.851361,21.658123,55.315956,-14.453670,24.217999,56.894001,-14.312155,23.552970,56.293512,-14.272829,22.946433,55.951476,-14.228764,22.729862,55.752004,-12.519144,22.542668,57.117409,-12.444279,21.970291,56.737977,-16.851729,66.845208,56.233039,-16.435403,70.871269,53.221873,-16.326359,65.640920,56.851182,-15.205762,66.005829,56.889357,-14.835322,72.620293,52.755370,-14.740636,70.346637,54.621739,-14.695631,68.059735,55.837800,-14.385026,73.597805,52.221102,-14.371503,68.502391,55.666415,-14.294919,73.444823,52.429365,-14.252136,69.445524,55.105488,-14.246009,73.129345,52.717669,-13.697056,69.734114,55.202792,-13.548056,72.405212,53.306612,-13.363023,70.574504,54.856140,-12.969043,71.693349,54.508087,-12.929300,71.866127,54.435995,-12.692240,71.537361,55.099576,-12.534221,72.814522,54.127474,-11.484087,72.627173,54.976686,-11.369312,72.708406,54.973685,-10.583821,71.542462,56.122392,-10.515044,71.946642,55.832081,-10.410209,73.400138,54.748859,-10.295965,71.377181,56.702947,-8.210407,73.698204,55.915697};
			return value;
		}
		private double[] getCoordinate_9_21_point_88()
		{
			double[] value = {-15.537965,76.145251,49.212646,-15.213346,77.523600,48.629000,-14.320800,82.044726,46.885514,-14.239739,84.155992,46.912918,-14.192104,83.995189,46.985682,-14.034096,83.423903,47.164409,-13.900885,82.486187,47.114781,-13.501759,84.198227,47.314886,-12.773400,74.708283,52.349676,-12.463790,76.830819,50.924221,-12.162422,75.782908,51.901925,-11.410066,78.197061,50.649629,-10.979650,75.419929,52.908575,-10.597012,74.041220,54.137357,-10.189434,80.590626,49.881012,-9.981393,76.526175,52.738091,-8.275259,76.482073,53.711074,-7.024472,83.902134,49.086410,-6.987309,74.586343,56.014573,-6.828319,77.942042,53.246920,-8.878354,85.886285,47.304235,-16.864587,-134.609465,58.258336,-15.480800,-134.580639,58.599165,-15.461041,-133.437918,64.764588,-14.184765,-133.960589,62.116637,-12.700163,-133.398283,65.348296,-12.644618,-134.440309,59.736421,-11.554068,-133.208585,66.525319,-10.203338,-133.274069,66.353008,-9.372621,-133.656562,64.401468,-8.939406,-134.682054,58.928725,-8.028023,-133.607657,64.845508,-7.879183,-133.309578,66.472674,-7.331692,-134.895026,57.995849,-16.326255,0.630537,67.405259,-16.859737,3.052268,65.748457,-16.681080,3.397584,59.769857,-16.075569,1.543045,62.348662,-15.981590,1.529466,61.810309,-15.977256,6.654128,58.220163,-15.930551,3.016738,66.014449,-15.912863,2.315175,60.883396,-15.802227,1.716365,61.611003,-15.733210,2.699613,64.734855,-15.707417,1.458640,62.107349,-15.632381,2.871628,65.158888,-15.331496,2.212064,61.309654,-15.302971,2.354711,61.184215,-15.104538,8.800578,57.460888,-14.911402,1.423926,62.521238,-14.807674,2.871104,66.795771,-14.768317,1.465055,63.199378,-14.753168,2.719105,67.041972,-14.547982,1.597908,62.382615,-14.472609,2.243255,61.788044,-12.764435,1.457313,64.136034,-10.397145,4.889577,62.290152,-9.145469,5.469863,62.483601,-8.442232,1.600992,66.765781,-8.406015,10.640422,60.218395,-7.768387,8.446794,61.405361,-7.043985,2.349607,65.364000,-7.029796,7.375669,62.183742,-7.013852,2.088100,65.655865,-6.824095,1.489379,66.702192,-9.348765,12.404796,59.110007,-8.090164,21.185032,58.567633,-17.068486,28.585600,58.199784,-16.695402,30.164288,59.676139,-15.827214,27.069891,58.209145,-15.755168,26.141415,57.392878,-15.578806,28.623833,60.097572,-15.440130,30.122431,60.841223,-15.433303,28.360357,60.069715,-15.124374,27.074574,59.266779,-15.122532,28.799554,60.588763,-15.064927,27.836612,60.071876,-15.050332,26.323650,58.318254,-14.926813,26.282317,58.743368,-14.919328,31.632199,61.338563,-14.140398,30.811656,61.732855,-13.999089,27.685613,60.591466,-13.513904,31.494298,62.249196,-13.483165,25.085660,58.958079,-13.079703,25.787051,59.950749,-13.053917,31.490765,62.365098,-13.022470,24.048954,58.001295,-12.887023,24.836821,59.284791,-12.882979,25.304461,59.718220,-12.775605,25.426724,59.884702,-12.701817,28.099591,61.162760,-12.567462,30.298355,62.161055,-11.182131,28.072582,61.506459,-11.146507,30.857225,62.371623,-10.515621,27.059071,61.206920,-10.463256,31.469965,62.877915,-10.404356,24.141549,59.797433,-10.372998,27.169217,61.272451,-10.273287,22.194069,58.590739,-10.166580,30.769143,62.593119};
			return value;
		}
		private double[] getCoordinate_9_21_point_89()
		{
			double[] value = {-9.889986,29.599061,62.042408,-9.634816,26.213506,60.998546,-9.509029,29.411716,62.078286,-9.368142,26.908683,61.223199,-8.962041,24.881142,60.425212,-8.320809,23.026277,59.446029,-8.241552,28.158585,61.910263,-7.788731,27.317226,61.575405,-7.666528,26.958304,61.371873,-7.461061,30.380132,64.507402,-7.288153,23.181366,59.717683,-7.064361,23.688579,60.032786,-6.881274,25.142458,60.548983,-17.067511,35.477226,60.671417,-16.521273,36.826757,61.095414,-16.136334,38.057628,61.311027,-16.011704,32.899803,61.138122,-15.916931,36.887664,61.467546,-15.863399,41.535597,60.405894,-15.607755,38.765402,61.602101,-15.593260,36.164967,61.382230,-15.500829,33.198531,61.218985,-15.021429,39.977031,61.698760,-14.931641,32.729700,61.526503,-14.829259,37.431085,61.589212,-14.747787,39.746867,61.905206,-14.510846,33.069651,62.024420,-14.509601,34.552981,62.208850,-14.370264,34.656468,62.342281,-14.073327,37.576631,61.891808,-13.736717,36.798137,62.670958,-13.401214,38.946536,62.099934,-12.181353,39.264981,63.470908,-12.127579,39.021499,63.543468,-11.938677,32.410559,62.636928,-11.775070,36.937502,63.726823,-11.693139,40.766606,63.396603,-11.690989,42.510138,62.406545,-11.125314,34.225777,63.409694,-11.016835,39.723900,64.022051,-10.507383,38.848224,64.113839,-10.273635,36.456000,64.239947,-10.234460,41.137607,63.841130,-10.100070,34.689371,64.196733,-10.074592,41.481451,63.766475,-9.925781,38.733388,63.875343,-9.922062,38.830116,63.864527,-9.919855,33.972092,64.142277,-9.543208,33.770225,64.196563,-9.367723,32.407155,64.077623,-9.331744,39.376032,63.766213,-9.055937,40.770306,63.560710,-8.971666,34.409649,64.194458,-8.718886,41.133408,63.588456,-8.589771,42.265759,63.300454,-8.586971,38.496754,64.584273,-8.390655,40.464264,64.175138,-8.362944,37.500224,65.010519,-8.301166,42.387991,63.320394,-8.282255,33.492756,64.636870,-8.282009,32.152439,64.333483,-7.926800,39.562892,64.763043,-7.517419,40.436703,64.722237,-6.634442,34.819536,65.723530,-16.903702,42.957929,58.802487,-16.476819,50.731259,59.431843,-16.115958,42.764749,59.520267,-15.836811,51.733401,59.725551,-15.760629,43.150441,59.638003,-15.673986,43.345363,59.655890,-15.670683,51.416996,60.069272,-15.596279,43.980882,59.478254,-14.885989,43.587279,60.165379,-14.629099,52.511752,60.862863,-14.387083,49.794814,60.854520,-14.249901,52.746896,61.227908,-13.905809,50.164827,61.142307,-13.247398,51.243008,61.775678,-12.956321,48.997123,61.462220,-12.811465,45.449040,61.298743,-12.685693,49.913913,61.844265,-12.519435,44.318216,61.693933,-12.189771,44.987866,61.706079,-12.181484,44.036608,61.909161,-12.123043,44.231229,61.888235,-12.119467,51.265748,62.054631,-12.104113,52.393047,62.529594,-11.986188,48.643356,61.504336,-11.809623,52.182992,62.595605,-11.726864,42.772126,62.267152,-11.547987,43.158918,62.298129,-11.521021,49.291743,61.761693,-11.491764,42.622928,62.554057,-11.043062,52.547752,62.829310,-11.006112,44.153181,62.464795,-10.983426,50.402582,62.332052,-10.908720,51.592315,62.477038,-10.785064,50.322324,62.323161,-10.439659,51.711302,62.643628,-10.166220,48.308205,62.271393};
			return value;
		}
		private double[] getCoordinate_9_21_point_90()
		{
			double[] value = {-9.868023,52.663348,62.906996,-9.692710,50.689885,62.668560,-8.709265,42.814342,63.254453,-8.599026,43.510863,63.276101,-7.898159,46.337211,62.819248,-7.604832,45.094993,63.126080,-7.351235,51.558419,63.372299,-7.245832,42.996620,63.742812,-17.064741,60.612657,58.932300,-16.783065,55.834511,60.031488,-16.769868,58.574326,59.502105,-16.176490,63.222857,58.333637,-16.106775,54.210759,59.702817,-15.957384,53.714420,59.637768,-14.819740,61.584431,59.846775,-14.689275,59.406232,60.638980,-14.481037,54.502476,61.245705,-14.363246,54.800081,61.407636,-14.220613,59.593394,61.286100,-14.086645,53.691013,61.230173,-13.922030,61.847146,60.675904,-13.480665,55.060910,61.860753,-13.429066,62.547412,60.771346,-13.360186,61.321573,61.406045,-13.279335,54.228511,61.894027,-13.262039,56.989573,62.354013,-13.187960,53.073860,62.039045,-13.028237,58.968317,62.481432,-12.588707,54.639351,62.559114,-12.021996,54.437616,62.785524,-11.829358,53.260082,62.809559,-11.309159,55.924653,63.317726,-10.810978,57.961689,63.672974,-10.524831,58.976834,63.674088,-10.470318,62.161445,63.144355,-10.178921,61.460690,63.324525,-10.003480,53.940104,63.525678,-9.966304,53.506636,63.341253,-9.740593,58.007926,64.140314,-9.684432,57.928505,64.145509,-9.413730,58.525050,64.260364,-9.185134,61.756491,63.774676,-8.536225,59.130547,64.452239,-8.172667,62.602813,63.961518,-8.165970,57.501310,64.559901,-8.111096,60.256366,64.512589,-7.996213,62.450462,64.061066,-7.920345,56.092047,64.372317,-7.830644,57.524609,64.629116,-7.740021,61.375838,64.474626,-7.598001,53.219636,64.140181,-7.266039,55.669782,64.236861,-6.659261,54.069703,64.582570,-16.890036,64.858154,57.171155,-15.758889,64.062179,58.137959,-15.670535,64.974468,57.291862,-14.438465,66.749904,57.294021,-13.217990,64.101760,60.097437,-12.337048,63.996768,60.680714,-12.333905,66.699064,59.094541,-12.218088,63.857259,60.995745,-12.058028,66.353452,59.404307,-12.039497,63.517658,61.273711,-12.033357,65.610562,59.925388,-11.413231,68.332673,58.647734,-11.381115,69.686701,57.210321,-11.261919,68.347390,58.762085,-10.448190,66.918206,60.370127,-10.422273,70.764182,57.244256,-10.266698,68.965171,58.961229,-10.079149,69.546910,58.654211,-9.792989,68.850160,59.142382,-9.405729,69.175091,59.075960,-9.237023,71.079388,57.855361,-9.052437,70.929911,58.102749,-8.972551,67.717777,60.795913,-8.821903,69.737242,58.887294,-8.448504,68.362730,60.587535,-8.303178,71.929089,57.484269,-8.216618,67.388808,61.327976,-8.174245,71.677200,57.676807,-7.561003,70.230923,59.600054,-7.556367,69.437735,60.197879,-7.518424,68.896587,60.419585,-7.498810,67.779860,61.430179,-7.429299,69.401313,60.221115,-7.428958,68.404847,60.785580,-7.298934,72.617606,57.291517,-7.110756,71.132164,59.019745,-6.876412,72.599666,57.814180,-6.773244,72.209141,58.254995,-6.766305,70.792524,59.500503,-6.633340,68.553841,61.205931,-13.701726,-131.876735,73.419564,-9.521740,-131.714941,74.852540,-8.747974,-132.647132,69.928773,-16.906896,-84.175369,73.325914,-15.976561,-83.797590,73.865162,-15.186212,-83.048385,73.900820,-17.020037,-77.439968,68.142795};
			return value;
		}
		private double[] getCoordinate_9_21_point_91()
		{
			double[] value = {-16.433787,-73.041907,68.599857,-16.300362,-74.498921,68.552456,-16.126923,-72.572057,68.972274,-15.867299,-82.273601,72.513786,-14.608701,-74.055757,70.101643,-14.335301,-77.521970,70.748263,-14.193730,-77.948438,71.391823,-14.070926,-73.176525,70.634712,-13.776200,-77.298139,71.088747,-13.096213,-78.122696,72.637341,-13.004172,-80.167248,73.850182,-12.744785,-76.319420,71.812807,-12.657459,-77.977211,72.984798,-10.424422,-75.240303,74.118107,-10.333251,-76.834148,74.203905,-9.760703,-76.910400,74.871668,-9.758427,-80.330039,77.417860,-9.719504,-76.207188,74.577130,-9.633185,-76.737347,74.841672,-9.511601,-76.370042,74.795092,-9.357484,-75.103215,75.056132,-8.542993,-76.422006,75.730706,-8.238745,-74.464536,76.019610,-7.329147,-74.727116,76.898474,-16.916082,-64.524011,74.042504,-16.809247,-68.159242,70.710440,-16.730844,-64.643529,73.978355,-16.570008,-62.814182,76.395238,-16.257742,-64.804115,74.016857,-16.022373,-68.476602,71.105734,-15.700239,-67.916727,71.615970,-15.644979,-67.401585,71.992949,-15.260527,-70.606733,70.346822,-14.381889,-66.840830,73.305116,-13.905776,-71.228350,71.241284,-13.876505,-64.719742,75.637031,-13.185536,-64.770152,75.863040,-12.729854,-72.235952,71.965141,-12.236843,-69.427451,73.271719,-11.494739,-72.089231,73.036477,-11.270076,-70.045351,73.742998,-9.710843,-69.674394,75.009575,-9.110373,-66.674640,76.979693,-8.911580,-67.531058,76.593730,-8.719689,-66.073485,77.698254,-8.692135,-69.565712,75.865821,-6.768627,-71.037826,77.097553,-16.042409,-10.254578,76.633576,-16.000117,-10.501803,76.888815,-15.324373,-10.459609,77.561227,-16.874400,-4.248381,72.437080,-16.603149,-4.901229,73.993864,-16.520246,-2.458590,68.465143,-16.519734,-4.567780,73.611278,-16.462632,-3.468174,69.900372,-16.133009,-0.447203,67.908985,-16.109215,-3.015205,69.225217,-15.845602,-4.453354,74.021657,-15.396448,-4.002880,73.427372,-15.186011,-0.191045,68.209935,-14.979775,-1.564167,68.737533,-14.688372,-1.093790,68.767809,-14.589311,-2.900280,70.126214,-14.502766,-2.958736,70.311081,-13.894979,-2.430236,69.951438,-13.798107,-2.020493,69.676603,-13.733849,-1.960322,69.669698,-13.510920,-1.449246,69.478657,-13.483527,-3.540009,74.221285,-13.469889,-4.661464,76.297590,-13.463732,-2.245162,70.054381,-13.197140,-2.348820,70.344007,-12.273891,-3.328409,75.033988,-11.702393,-3.401106,75.816449,-10.802836,-4.041252,77.420088,-10.691141,-2.243037,72.076010,-10.603403,-3.183717,76.219343,-10.497735,-0.923433,70.978040,-10.449945,-2.487614,73.044241,-10.280044,-3.308990,76.715313,-9.972556,-2.430074,73.379657,-9.307557,-1.657748,72.097595,-9.022003,-2.344171,74.185947,-8.418017,-1.472047,72.447827,-12.754290,2.142437,68.611794,-11.449984,2.797251,67.833825,-11.411178,1.744773,69.532128,-11.277738,2.483800,69.169442,-10.699136,2.535808,69.417252,-9.828216,2.448795,69.934564,-8.730232,2.382123,70.516207,-7.557708,2.181226,71.175202,-7.486671,1.610365,71.496623,-7.140743,1.472063,71.701486,-7.086480,2.617665,70.891641,-16.763332,-129.713556,84.675652,-16.639456,-129.503716,85.823840,-15.638402,-130.007554,83.241013,-14.799369,-130.698842,79.625321,-13.231037,-129.928806,83.988118};
			return value;
		}
		private double[] getCoordinate_9_21_point_92()
		{
			double[] value = {-10.487313,-130.391664,81.859841,-6.645163,-129.815519,85.481841,-15.575376,-104.872609,85.184678,-13.480134,-104.619169,86.984398,-13.417180,-109.930583,88.172813,-13.213019,-106.878240,87.690622,-12.975287,-106.653803,87.854168,-12.919479,-107.901978,88.170552,-12.916647,-107.633203,88.114707,-16.797751,-98.917532,82.935831,-16.698985,-101.687883,83.565708,-16.431046,-100.181440,83.480220,-16.148767,-98.483009,83.450421,-13.634038,-102.432536,86.411884,-13.370311,-98.850567,85.972123,-12.649313,-95.572477,85.995440,-11.717704,-96.931845,87.074756,-11.468371,-97.909011,87.476380,-11.404547,-99.777871,87.912180,-10.890479,-99.045785,88.216999,-10.144820,-94.984244,88.082979,-16.618077,-89.826717,80.980526,-15.904607,-88.026522,80.670125,-15.690378,-90.157150,81.946134,-14.203349,-88.011478,82.471186,-13.643787,-87.900730,82.951026,-13.118301,-86.330859,81.116722,-12.187502,-86.469408,82.480801,-12.053894,-88.728409,84.894447,-11.384862,-88.132820,85.302363,-7.738963,-87.308626,88.249675,-7.719696,-87.118353,88.160971,-7.446307,-83.756713,83.229088,-7.214592,-86.257312,87.617111,-6.879565,-86.192686,87.877653,-6.665606,-80.078439,80.607746,-13.489028,-62.747367,77.950192,-10.540542,-63.095948,79.078282,-9.940764,-63.476404,78.972466,-9.728205,-63.065357,79.461356,-8.490589,-65.908246,78.014905,-6.993839,-66.967769,78.455791,-6.746478,-68.000096,78.012293,-16.798860,-53.551517,88.067272,-16.725549,-53.746091,87.837534,-16.495866,-60.245313,79.776259,-16.488269,-61.496944,78.177228,-16.399209,-57.693554,82.986836,-16.376321,-58.896622,81.519320,-15.514273,-61.406660,78.698747,-14.521507,-56.585496,85.485159,-13.135023,-54.989777,88.092432,-12.919871,-61.034063,80.291704,-12.095257,-56.404916,86.706477,-11.537697,-60.913972,81.136169,-10.951996,-59.013140,84.004784,-10.433477,-60.572016,82.167872,-9.869368,-57.157661,86.758584,-8.374982,-57.552998,86.952312,-8.007015,-58.807575,85.430436,-7.927368,-60.080000,83.919668,-6.915566,-57.370087,87.798034,-6.690886,-57.723146,87.416323,-16.515432,-29.709277,86.346135,-16.240710,-29.178855,86.237811,-15.684629,-22.678521,84.440554,-15.268132,-21.719491,84.760398,-14.882347,-27.352390,86.288456,-14.831812,-27.430971,86.388173,-14.618351,-23.592877,84.456002,-14.300317,-22.498339,84.524479,-13.706649,-22.358386,84.629061,-13.088456,-24.893452,86.323005,-12.922348,-27.034441,87.917492,-12.907338,-26.604769,87.691446,-12.784343,-22.627370,85.037114,-12.628905,-21.077920,84.921059,-12.620297,-23.301259,85.531417,-11.067591,-21.627565,85.509268,-10.569471,-20.364262,85.190484,-10.371775,-20.893143,85.438573,-9.348814,-21.119449,86.344769,-9.289436,-20.343961,85.766560,-9.118051,-21.191540,86.525530,-8.634751,-22.545830,88.231470,-8.375904,-20.826890,86.767612,-7.434632,-20.174892,87.032921,-17.046921,-15.676913,82.414009,-16.738229,-14.534170,81.235917,-15.743602,-17.206208,84.259179,-15.376473,-19.883016,85.127050,-15.172987,-14.305976,82.623187,-14.348747,-18.682665,85.313166,-13.540193,-13.881141,83.490084,-13.325890,-15.330413,84.650198,-12.135768,-20.152770,85.127121,-11.943395,-17.267440,85.739307,-11.767985,-11.943596,82.717312,-11.699110,-19.916944,85.173205,-11.569873,-17.470069,85.780098};
			return value;
		}
		private double[] getCoordinate_9_21_point_93()
		{
			double[] value = {-11.001244,-15.590649,85.744460,-10.520263,-13.271897,84.840863,-9.873569,-14.051393,85.632128,-9.686568,-12.516823,84.764258,-9.367913,-13.457823,85.536422,-9.208568,-16.692117,85.906407,-8.715740,-9.965712,82.759578,-7.236131,-17.534226,85.386336,-6.944375,-11.643804,85.471388,-6.878358,-18.934071,86.217475,-6.703159,-13.670225,86.251570,-6.680675,-9.925188,84.188986,-12.530405,-8.470677,78.026727,-11.254111,-6.603788,78.172711,-10.677880,-8.085511,79.167481,-9.463509,-7.348242,79.535910,-9.226936,-7.085487,79.513955,-8.063780,-4.084638,78.834607,-8.006215,-3.362850,78.207161,-7.735261,-3.983933,78.914294,-7.639661,-3.831275,78.853078,-7.460885,-9.001156,82.587999,-6.787642,-4.453128,79.563136,-14.227698,-127.904827,92.252749,-13.899597,-128.379265,92.255278,-13.719201,-128.924977,89.336766,-11.964197,-128.809842,90.192432,-11.049103,-127.966235,94.865011,-9.328320,-128.740820,90.917769,-7.745920,-128.465204,92.616725,-7.522476,-127.554782,97.556552,-7.105067,-128.486147,92.589505,-7.098975,-127.192876,98.257687,-12.468270,-118.785318,91.253594,-12.450690,-122.702726,92.402014,-11.881501,-123.537615,93.152027,-10.940994,-114.615273,91.561390,-10.309092,-115.659742,92.404900,-10.257699,-116.002374,92.538539,-9.471107,-117.225515,93.575813,-8.578711,-118.186917,94.638073,-8.138656,-122.629231,96.232839,-7.410208,-120.748468,96.356453,-12.855204,-109.124690,88.501538,-11.973855,-105.034756,88.419759,-11.562166,-109.676703,89.811489,-9.718122,-108.339678,91.211681,-8.682686,-113.217011,93.270675,-8.273546,-105.797488,91.932447,-6.638500,-111.391122,94.661301,-11.598806,-103.206046,88.389153,-10.146890,-99.933338,89.066036,-10.061874,-103.108345,89.742426,-8.635699,-100.654813,90.489657,-8.454652,-101.420445,90.808786,-8.357788,-100.204909,90.658764,-8.111185,-98.276279,90.411167,-6.831406,-101.203103,92.195529,-7.632847,-88.646136,88.767410,-7.293137,-90.619148,89.563742,-7.003748,-86.627057,88.366339,-15.732165,-51.997867,90.187521,-14.071692,-51.850969,91.054191,-13.938286,-51.898386,91.040392,-12.326762,-54.141965,89.350954,-11.588526,-53.948148,89.813375,-10.055063,-54.356376,90.046011,-9.982829,-55.307704,88.872795,-9.395140,-51.987830,92.973161,-9.019829,-54.405409,90.368992,-7.698491,-51.645460,93.939537,-7.132725,-53.587246,92.135978,-6.835263,-51.827054,94.115548,-16.727442,-50.587361,91.321817,-16.682005,-42.393792,91.990070,-16.566103,-48.162851,93.196093,-16.240361,-41.426950,92.077326,-15.964051,-50.797061,91.467465,-15.324819,-43.630521,93.501918,-15.175784,-50.825327,91.729205,-15.172749,-50.671620,91.875066,-15.091720,-44.728057,93.959877,-14.799494,-50.509375,92.318088,-14.733674,-42.550108,93.694134,-14.254820,-47.086767,94.783912,-14.162588,-41.945986,93.970384,-14.040408,-43.616966,94.489974,-13.769489,-47.902285,94.791766,-13.003657,-42.779974,95.068738,-11.444708,-51.138493,92.980783,-11.201143,-45.223303,96.783471,-10.997558,-50.292471,93.933724,-10.966454,-50.726433,93.461191,-10.790326,-43.706017,96.691998,-9.951983,-49.139423,95.225433,-9.909468,-48.168856,96.049520,-8.790684,-42.568055,97.095638,-8.574916,-46.715992,97.928604,-7.525847,-45.442639,98.462602,-7.222006,-48.556801,97.037536};
			return value;
		}
		private double[] getCoordinate_9_21_point_94()
		{
			double[] value = {-6.689976,-51.259034,94.686560,-16.129920,-34.545375,89.382218,-15.673246,-33.972799,89.502313,-15.619704,-31.523497,88.358903,-15.308183,-36.653788,91.067584,-14.517826,-39.080746,92.677054,-13.441747,-30.788689,89.813698,-13.001597,-39.967396,94.098666,-12.131075,-39.914040,94.679564,-12.057930,-34.665966,92.852511,-11.329502,-30.841831,91.603952,-11.018909,-39.604327,95.230203,-9.355794,-34.889359,94.380124,-8.884530,-41.013678,96.557369,-8.575555,-32.018545,93.642792,-8.081855,-37.769109,95.738277,-7.879200,-39.674086,96.492771,-12.188128,-26.615155,88.319428,-11.821102,-28.672159,89.956780,-11.434625,-27.034395,89.262046,-11.333818,-27.918845,90.014311,-11.204132,-28.527592,90.386984,-10.972119,-25.391712,88.624900,-10.743732,-25.131417,88.610445,-8.727926,-28.533770,92.175705,-6.880409,-29.396994,93.184652,-6.682302,-26.159608,92.055703,-0.002062,41.845849,-25.981425,1.100855,35.459237,-26.115884,3.670414,41.512449,-29.229260,-0.474769,51.680135,-26.953129,0.131900,47.627803,-26.270735,0.436680,46.715256,-26.351320,1.287937,50.662129,-27.789705,3.222235,45.915081,-28.476441,3.392592,44.874515,-28.642666,-3.775524,61.832817,-26.686401,-3.148977,62.396750,-27.035345,-2.967131,63.348341,-27.123792,-2.681124,63.256943,-27.129423,-2.595107,60.806854,-26.904982,-1.159227,56.130583,-27.310272,0.216221,57.442286,-28.320099,1.810941,55.619820,-29.046473,2.312544,53.121568,-28.920265,-6.071889,65.320470,-26.166127,-5.848198,64.933046,-26.173675,-5.308944,65.122918,-26.605649,-5.009154,70.448624,-26.233367,-4.908434,65.610629,-26.811311,-4.907470,64.844020,-26.826021,-4.803841,69.122237,-26.278608,-4.740081,67.720438,-26.583297,-4.582168,71.183791,-26.189256,-4.037846,70.271459,-26.557952,-3.674648,66.942893,-26.845748,-3.656160,70.361441,-26.454483,-3.403981,68.966097,-26.909356,-3.157752,69.366621,-26.781900,-3.036270,67.698904,-27.166966,-3.026532,66.093529,-27.058930,-2.937763,71.154885,-26.181233,-2.776394,63.541921,-27.136120,-2.687669,69.530876,-26.588467,-2.003617,64.025330,-27.560934,-1.808196,68.274315,-27.001139,-1.801044,66.616198,-27.439097,-1.746812,66.887443,-27.349948,-0.848449,64.853604,-27.769742,-0.339869,65.690321,-27.947465,-0.260445,64.145329,-28.214790,0.216044,67.308843,-28.250916,0.251258,69.108884,-27.939481,0.725662,66.471942,-28.525716,1.917723,68.349079,-28.769027,2.301284,77.049676,-26.114552,-6.333390,-63.017996,-16.830454,-6.108390,-67.773822,-16.976916,-5.978099,-68.388087,-16.950246,-5.892412,-70.197050,-16.538740,-5.483004,-68.775237,-16.795435,-4.807771,-66.764494,-16.687087,-4.402024,-69.703772,-16.339104,-3.812827,-62.886619,-15.887473,-3.609094,-66.516529,-16.239665,-3.151601,-69.990628,-15.751770,3.478040,-12.971946,-15.581294,3.648768,-12.105090,-15.749443,3.749625,-10.922803,-15.565156,-3.902713,20.792604,-16.252047,-0.515651,16.371029,-15.707506,0.084036,16.586754,-16.398930,0.149677,21.151208,-19.660950,0.365897,15.144440,-15.719879,1.815297,13.938295,-16.259358,2.480572,17.752676,-18.858712,-3.374939,22.998068,-17.863565,-2.609267,31.688791,-20.688299,-2.596367,25.220248,-19.415365,-2.264338,22.559102,-18.716217};
			return value;
		}
		private double[] getCoordinate_9_21_point_95()
		{
			double[] value = {-1.370177,31.473847,-21.144755,-1.137242,28.910800,-20.758768,0.242940,23.778337,-20.750304,0.771829,21.982013,-20.293259,0.917861,31.115368,-21.842989,0.997727,31.142030,-21.886921,1.491545,31.530415,-22.403610,1.693365,24.933779,-21.536615,2.274805,22.471609,-21.161143,2.722217,30.969110,-22.338750,2.840024,31.110184,-22.450448,3.813511,26.754002,-22.292452,-6.433405,32.648121,-18.294059,-6.161383,42.135778,-20.163382,-5.253886,37.321274,-20.690241,-5.233722,40.490273,-20.982668,-5.001271,42.481255,-21.231358,-3.252198,41.269582,-22.794651,-2.952385,42.292540,-23.041794,-2.392049,32.169081,-21.059297,-2.134284,41.762187,-23.838985,-1.654630,32.598426,-21.958636,-1.335287,42.341974,-24.603255,-1.217342,41.899110,-24.758744,-1.179755,36.086329,-24.248408,-0.284907,33.656359,-23.548152,0.188945,36.175752,-25.654996,0.488044,34.624918,-24.846972,0.912083,34.163539,-24.761461,0.923195,35.017412,-25.585271,1.106408,32.245156,-23.089554,1.238271,34.265259,-25.125691,1.405707,33.291569,-24.374214,2.406101,32.808061,-24.688177,3.369806,32.826932,-25.581168,-6.049708,47.647626,-20.905969,-5.937481,52.257503,-23.110160,-5.936903,46.963306,-21.332269,-5.918293,48.115987,-21.071809,-5.651781,48.364263,-21.471259,-5.584180,51.956985,-22.834328,-5.409383,45.860261,-21.377472,-5.378176,47.850209,-22.196409,-5.354272,52.539681,-23.209949,-5.124951,48.490167,-22.621014,-5.122361,50.007829,-22.860353,-4.758400,50.440484,-23.425165,-4.231009,46.113319,-22.410109,-4.187499,44.491823,-22.072840,-4.161787,50.938814,-24.164810,-3.931848,50.919196,-24.337263,-3.542542,42.841718,-22.508019,-3.271411,46.666601,-23.300151,-2.906944,49.294333,-24.535810,-0.809916,43.296653,-25.082539,-0.762103,47.805201,-25.639081,-6.558739,57.137699,-24.335562,-6.383496,61.840554,-25.866007,-6.326291,60.597428,-25.706937,-6.004663,57.569938,-24.585569,-5.993415,56.379379,-24.255901,-5.656362,62.955292,-25.654419,-5.597380,60.084747,-25.803948,-5.442417,54.397007,-23.949842,-5.199178,57.310544,-25.156628,-5.001779,53.982714,-24.032077,-4.739582,54.226476,-24.547026,-4.684934,60.120292,-25.763294,-4.591131,60.117405,-25.780426,-3.218726,53.717971,-25.647236,-6.429502,68.623469,-25.881829,-6.351043,69.576308,-25.845002,-6.327680,65.286607,-25.813582,-5.733224,70.915121,-25.844010,-5.552002,72.218296,-25.662808,-5.418132,63.552239,-25.803070,-4.812093,71.828797,-25.848425,-6.562196,81.884665,-20.175662,-6.001083,79.141937,-22.042085,-5.766976,73.994556,-24.613584,-5.298987,76.271088,-23.642664,-4.604938,77.289582,-23.466237,-2.763108,81.681677,-21.814644,-2.451165,81.837844,-21.882588,-2.076532,76.603760,-24.670065,-1.029148,80.819103,-23.027792,-0.804990,83.101879,-21.775835,3.801289,78.737972,-25.819025,-4.263356,87.623784,-17.719973,-3.272769,90.970117,-15.669164,-2.756241,89.871672,-17.156914,-2.571486,87.022244,-18.905034,-2.540905,89.850716,-17.346927,-2.105214,87.538113,-18.893691,-2.057391,89.489732,-17.834285,-1.349563,87.358799,-19.118115,-1.071586,90.628604,-17.594238,-0.806031,86.501251,-19.580044,0.077432,88.370789,-18.698740,0.197505,91.213419,-17.643459};
			return value;
		}
		private double[] getCoordinate_9_21_point_96()
		{
			double[] value = {0.524692,88.590552,-18.560261,0.573939,87.528379,-18.957685,0.627863,87.857122,-18.730348,0.658638,91.110099,-17.900921,0.949055,91.603402,-17.538663,1.792677,91.274788,-17.878613,2.005159,92.991992,-16.716952,2.120575,88.014611,-19.264128,2.194212,88.566029,-18.463816,2.216703,92.374717,-17.285808,2.523184,89.387911,-17.843783,2.926616,89.145227,-18.281835,2.985985,88.329284,-19.274650,3.212059,93.338663,-15.906131,3.703642,92.064626,-15.904863,3.796810,89.995877,-18.051379,-6.122906,-74.730990,-7.771515,-5.540815,-73.122187,-12.390880,-5.459894,-74.124375,-9.570754,-5.376619,-75.468554,-6.000346,-5.111718,-75.418875,-6.034701,-4.670100,-73.947687,-10.314946,-4.557887,-75.288160,-6.456241,-3.724574,-74.044231,-10.017584,-3.618123,-75.638359,-5.455885,-3.563609,-74.577911,-8.866147,-1.205615,-72.717961,-13.080104,-0.853991,-73.587276,-11.354840,0.881048,-73.403453,-11.360352,1.933469,-73.193997,-11.573598,-6.557575,-72.014419,-14.979999,-4.635673,-71.866178,-15.012748,-3.897395,-71.457207,-15.184648,-1.112944,-66.773966,-15.347560,-0.759251,-69.961838,-14.880143,-0.006660,-69.205483,-14.743864,0.790895,-65.083689,-14.367603,1.533432,-72.390382,-12.625806,2.242697,-69.485279,-13.689097,2.261633,-69.006383,-13.796447,2.627121,-70.862296,-13.211170,3.218394,-71.857478,-12.480878,3.515085,-62.203417,-6.251223,3.720594,-67.288804,-13.192939,3.821035,-69.944802,-12.975044,-6.202020,-53.094688,-8.195642,-6.172605,-53.881405,-8.636135,-5.844360,-56.051145,-13.685856,-5.199152,-56.795642,-14.106743,-4.679939,-53.316992,-6.978114,-4.649384,-57.417925,-9.072872,-3.980831,-57.299360,-13.548046,-3.585834,-53.807475,-6.312990,-3.452126,-55.070372,-7.471129,-3.373786,-57.786341,-8.460609,-3.333259,-57.672136,-8.388882,-3.122903,-54.554905,-6.707488,-2.796289,-61.270018,-15.009747,-2.793373,-56.285006,-7.822490,-2.666480,-57.929900,-8.154837,-2.560299,-58.666917,-8.875954,-2.359215,-54.730174,-6.191135,-2.298055,-58.406502,-8.135033,-2.297834,-54.876544,-6.347526,-1.602154,-61.824388,-14.665056,-1.591420,-58.683813,-13.075903,-1.369207,-55.623445,-6.252752,-1.080181,-58.843663,-12.730612,-1.060865,-58.977943,-12.972937,-1.005754,-56.215836,-6.586297,-0.867302,-58.894834,-12.522077,-0.739888,-59.765862,-13.487891,-0.559504,-57.416119,-7.013001,-0.404838,-56.809853,-6.491850,-0.264834,-59.986964,-7.705496,-0.025093,-59.210586,-11.012195,0.235653,-57.168561,-6.345264,0.344984,-59.517477,-10.181399,0.637488,-59.852264,-12.504739,0.747049,-60.426601,-13.004017,1.082142,-60.454965,-9.149432,1.240508,-61.429003,-13.246457,1.726915,-61.169192,-12.826631,2.979621,-60.637870,-10.565417,3.007423,-60.671468,-10.075505,3.283818,-60.383731,-5.647836,3.622911,-61.537724,-5.607416,0.257598,-30.904834,-5.507389,0.310094,-32.163750,-5.480041,0.862158,-33.830946,-5.391818,1.864014,-32.561100,-6.139926,2.466970,-30.750401,-6.998318,2.846628,-30.887891,-6.999638,3.111038,-33.056817,-5.335673,3.360298,-32.070501,-5.908452,3.607664,-30.760125,-6.579756,3.625442,-34.154252,-5.405437,-6.582404,-21.382452,-7.066188,-6.517762,-20.205257,-7.124049,-6.276982,-21.367539,-7.038881};
			return value;
		}
		private double[] getCoordinate_9_21_point_97()
		{
			double[] value = {-5.929471,-23.169488,-6.782030,-5.184607,-25.392190,-6.326440,-4.802515,-25.957085,-6.127597,-4.292048,-25.479192,-6.553429,-3.939171,-21.093433,-6.968257,-3.691814,-25.286984,-6.518352,-3.601907,-25.338227,-6.483503,-3.462991,-26.440562,-6.264691,-3.440493,-21.906948,-6.735297,-3.359131,-23.126140,-6.509077,-3.039697,-23.562544,-6.339722,-2.987575,-24.348049,-5.979354,-2.900139,-26.988448,-5.858976,-2.801710,-23.990003,-6.116475,-2.344158,-23.458314,-6.363335,-1.978847,-24.965847,-5.795084,-1.967439,-21.093675,-8.369601,-1.952362,-23.920437,-6.279554,-1.934128,-22.327143,-6.598865,-1.742786,-25.942683,-5.437684,-1.451520,-22.610063,-6.581739,-1.353428,-20.777097,-9.693169,-1.048623,-20.465619,-12.606071,-0.887536,-25.594796,-5.981046,-0.510427,-23.754769,-6.493762,-0.411439,-23.383560,-6.897924,-0.389184,-24.378335,-6.261454,-0.293197,-28.143819,-5.271802,-0.221814,-20.936078,-13.261838,-0.153853,-23.697888,-6.976739,-0.054977,-23.144249,-7.759974,-0.037971,-22.585941,-9.339104,0.025186,-27.890725,-5.525710,0.192386,-29.144855,-5.232274,0.550339,-26.404218,-6.538889,0.654059,-23.862364,-7.880197,0.702813,-25.314644,-7.381969,0.726544,-22.987491,-10.140794,0.854508,-20.374047,-13.312136,0.964008,-26.827191,-7.544732,1.015785,-30.013989,-6.632465,1.017997,-25.543133,-7.729020,1.204072,-28.721009,-7.538918,1.430560,-23.733173,-10.143025,1.624073,-25.537003,-8.211170,1.715087,-29.741861,-7.154447,1.772883,-27.451702,-8.284229,1.775583,-22.558245,-13.067885,2.043785,-20.362242,-14.312952,2.091838,-23.711237,-12.736799,2.346870,-29.585351,-7.554892,2.350191,-20.255262,-14.309679,2.424245,-29.331665,-7.673961,2.446317,-21.723767,-13.981478,2.686960,-28.968493,-8.003441,2.721321,-28.876191,-8.094088,2.963269,-28.615170,-8.526027,2.991000,-29.815043,-7.749809,3.032049,-28.397697,-8.680142,3.147323,-27.387480,-9.307592,3.158877,-30.559111,-7.065986,3.271912,-28.094932,-8.885989,3.371884,-22.662210,-13.893539,3.482870,-28.738615,-8.473670,-6.603402,-11.473313,-7.841823,-6.460709,-18.014730,-7.115926,-6.220205,-19.363758,-6.999947,-5.132741,-15.551620,-8.259752,-5.114279,-13.285080,-8.486520,-5.003476,-12.248248,-8.410898,-4.721975,-12.634738,-8.662485,-4.650066,-15.556718,-8.309383,-4.615952,-14.688020,-8.405091,-4.210211,-13.838455,-8.579178,-3.859648,-14.248760,-8.634971,-3.531697,-11.804497,-8.789586,-3.451690,-15.223045,-9.481281,-3.398109,-14.637112,-9.353044,-3.397959,-16.831247,-8.830577,-3.394126,-15.542547,-9.718107,-3.318418,-14.486244,-9.655322,-3.264579,-16.605435,-9.392286,-3.240012,-10.684080,-8.757166,-3.158499,-15.442737,-10.263589,-3.129244,-14.254507,-9.927891,-3.122946,-15.771956,-10.606415,-3.104247,-12.864957,-8.933415,-3.030896,-13.906815,-10.158324,-2.966430,-12.365472,-8.939228,-2.937901,-12.892200,-9.279009,-2.758537,-12.339156,-9.155944,-2.721761,-16.569019,-11.147954,-2.718757,-10.385241,-8.889075,-2.693757,-13.409941,-11.018981,-2.686584,-17.738035,-10.013640,-2.555751,-11.968732,-10.288481,-2.521485,-15.802903,-12.444463,-2.506018,-19.685000,-8.541775,-2.425463,-11.534409,-10.813419,-2.366782,-16.034546,-12.547183};
			return value;
		}
		private double[] getCoordinate_9_21_point_98()
		{
			double[] value = {-2.334624,-19.356367,-9.102614,-2.314514,-17.276138,-11.811962,-2.313326,-15.044173,-12.571683,-2.105452,-17.239609,-12.619594,-1.956489,-16.650650,-12.972490,-1.947140,-15.165096,-13.005283,-1.838325,-9.907098,-9.147809,-1.545493,-16.631387,-13.249063,-1.467463,-10.039623,-11.419261,-0.714262,-19.643160,-13.406508,-0.677375,-10.628953,-13.231180,-0.560287,-16.343781,-13.688439,-0.513814,-16.252496,-13.990612,-0.339125,-11.668667,-13.647372,-0.322377,-19.733636,-13.404901,-0.105179,-16.569898,-14.361511,0.289740,-19.798979,-13.322801,0.299326,-14.506451,-14.231229,0.327184,-10.375812,-13.514981,0.341586,-18.543812,-13.783880,0.394497,-11.185888,-13.699411,0.552837,-15.703908,-14.434129,0.570326,-9.848587,-13.795894,0.582654,-17.023462,-14.349492,0.759762,-13.133738,-14.026073,1.137097,-16.588193,-14.287024,1.290832,-11.440268,-14.295706,1.478699,-11.801451,-14.272478,1.822811,-13.886645,-14.260341,2.587504,-11.864126,-14.542368,3.189412,-10.359196,-14.874452,3.376529,-17.002444,-13.963152,3.469687,-11.977757,-15.317569,3.470522,-17.604760,-13.875233,3.670846,-17.221374,-14.134152,-6.511745,-1.548435,-9.813405,-6.469886,-4.810417,-9.794636,-6.006112,-4.039982,-9.842145,-5.912602,-3.661596,-9.856848,-5.621693,-9.530950,-7.832474,-5.444730,-4.224581,-9.596459,-5.139640,-7.847592,-8.127462,-5.138981,-0.026841,-9.503445,-4.720002,-3.831506,-9.183242,-4.625492,-4.878479,-8.791780,-4.612280,-1.580355,-9.501067,-3.773881,-8.359067,-8.407898,-3.709393,-7.377997,-8.200302,-3.493564,-7.569351,-8.385234,-2.870207,-5.939521,-8.460425,-2.514750,-2.647438,-8.044833,-2.438770,-3.865271,-8.259904,-2.427536,-6.543722,-9.028237,-1.896241,-3.261727,-8.585738,-1.830503,-3.344479,-8.669812,-1.817373,-2.562149,-8.488545,-1.613721,-7.282662,-9.444849,-1.521586,-6.822769,-9.573615,-1.372178,-9.462435,-9.395238,-1.370152,-9.691693,-9.911433,-1.303021,-8.597075,-9.355751,-1.198713,-5.871638,-10.055026,-0.901347,-8.851253,-10.797379,-0.642952,-5.250158,-10.338102,-0.626746,-6.716857,-9.934561,-0.402343,-8.345590,-10.041851,-0.308992,-9.495987,-12.954336,-0.252242,-7.973121,-11.012772,-0.223005,-4.238121,-10.425523,-0.089913,-2.654107,-9.929021,-0.064502,-2.916067,-10.072917,0.474627,-7.896504,-12.549413,0.500243,-8.616169,-13.159025,0.558739,-1.788407,-10.038580,0.664650,-0.186137,-9.519899,0.931502,-6.929815,-10.359390,1.114664,-6.721786,-10.284636,1.123510,-9.703349,-14.315571,1.146908,-7.451735,-13.277513,1.192251,-8.437353,-14.065028,1.263985,-6.851502,-12.910674,1.327609,0.622108,-9.829702,1.444574,-0.562147,-10.140230,1.625691,-5.255780,-9.917510,1.648731,-5.664041,-10.066209,1.690515,-0.054744,-10.104275,1.718217,-5.992975,-12.107004,1.763633,-1.189480,-10.252230,1.812971,-4.459287,-9.919878,1.842634,-1.952408,-10.157881,2.099034,-1.704134,-10.012844,2.102834,-5.868748,-13.005826,2.377753,-5.069060,-12.159985,2.391620,-5.545754,-13.371094,2.412121,-4.758405,-10.409803,2.791514,-4.495089,-11.586364,3.155167,-2.596220,-10.238563,3.159895,-2.667945,-10.448052,3.183997,-9.595448,-14.834701,3.371733,-1.585966,-10.630897};
			return value;
		}
		private double[] getCoordinate_9_21_point_99()
		{
			double[] value = {3.505059,-3.562247,-12.107891,3.535045,-8.174460,-14.905380,3.612969,-0.718863,-10.983657,-6.606734,2.445638,-9.031443,-6.398231,10.247415,-9.698043,-6.374660,2.929094,-9.036038,-6.315286,9.399400,-9.548460,-6.279893,0.912948,-9.651010,-6.217996,9.676980,-9.624744,-6.144630,6.406018,-8.940632,-5.478408,1.320299,-9.440318,-5.138095,7.925731,-9.250804,-5.118714,4.897166,-9.017326,-4.474729,7.815093,-9.335312,-4.249088,9.231486,-9.916196,-4.052937,7.101272,-9.418054,-3.769443,7.187089,-9.483813,-3.586147,1.962992,-9.021305,-3.011957,2.646053,-8.593187,-2.957898,9.164072,-9.905320,-1.238959,2.736863,-8.613224,-1.050560,10.141392,-10.737925,-0.233036,1.833926,-9.022694,0.078528,4.454069,-9.268144,0.244748,3.405366,-9.129886,0.255425,7.511877,-10.371391,0.450555,2.025742,-9.109627,0.506581,3.010016,-9.147479,0.745509,4.621451,-9.736347,1.189931,2.164309,-9.664036,1.780272,11.020925,-14.413829,2.386601,0.798994,-9.990844,2.388094,9.410902,-13.914169,3.633612,1.065400,-9.859036,3.733903,9.327108,-14.781807,-5.831854,13.286065,-10.525153,-4.857392,19.902216,-14.466663,-4.479642,12.810705,-10.869850,-3.945001,14.196991,-11.327182,-1.903887,14.458359,-12.604085,-1.495797,11.549512,-11.116156,0.509521,13.241186,-14.648771,-6.273350,93.437004,-10.989580,-5.024160,94.704524,-9.868775,-4.904650,94.541227,-10.045933,-4.797998,94.104010,-10.740592,-4.221431,93.030675,-12.995459,-4.119597,92.263762,-13.894637,-3.882071,92.166683,-14.053908,-3.705636,94.399768,-11.671012,-3.470040,94.691167,-11.923064,-3.173262,92.542917,-13.881635,-2.626484,91.410938,-15.456952,-2.415027,93.348903,-13.928503,-2.353117,94.601113,-12.980330,-1.171640,93.530729,-14.723068,-0.691736,94.070319,-14.119916,-0.595398,94.478656,-13.689091,0.538717,94.543781,-14.206403,0.774406,93.892036,-14.781320,1.017615,93.788404,-14.921149,2.448279,94.592318,-15.164125,3.755127,92.813524,-15.453894,-6.452852,96.217240,-6.485011,-6.424988,96.982158,-5.486964,-6.146342,95.319973,-8.138252,-5.970384,96.249425,-7.346922,-5.521316,97.630474,-5.937402,-5.417815,97.031824,-6.322569,-5.268490,97.294029,-6.272820,-5.250098,96.237062,-8.351869,-5.042808,98.204220,-5.598357,-4.789390,94.985935,-10.106836,-4.748575,97.855472,-6.352819,-4.567970,97.739903,-6.650336,-4.368040,96.497474,-8.801837,-4.219923,96.232304,-9.419082,-2.410867,98.225778,-7.691183,-1.257989,97.831461,-9.224246,-1.149277,97.608509,-9.677802,-0.262465,96.090497,-12.109099,0.042482,96.439688,-11.657839,0.309818,96.391179,-11.735220,0.335765,99.709035,-5.316193,0.519100,95.616455,-12.887493,1.005108,97.214280,-10.106738,1.084925,98.747287,-8.057218,1.275276,99.176323,-6.914331,1.560178,96.150550,-12.154900,2.037902,96.549604,-12.325034,2.131679,98.167072,-9.465877,2.233002,99.145412,-5.901686,2.275024,99.105247,-5.638142,2.606312,97.643964,-10.398714,2.698030,94.968196,-14.666972,2.984845,98.438272,-7.462758,3.146672,98.228974,-8.254413,3.155219,98.268060,-5.735784,3.169318,95.485073,-13.809404,3.335007,96.411333,-12.096537};
			return value;
		}
		private double[] getCoordinate_9_21_point_100()
		{
			double[] value = {3.482888,97.773879,-8.762099,3.563602,96.358462,-12.099194,3.609182,96.415786,-11.986033,-6.601321,-144.882313,4.231901,-6.389827,-144.884005,2.623402,-6.147307,-136.081094,2.732214,-5.831000,-142.424345,2.767138,-5.756209,-144.093530,2.961592,-5.731507,-140.699107,3.922704,-5.560895,-142.554601,2.933119,-5.293959,-141.827830,3.597095,-4.921649,-140.704893,4.610908,-4.796220,-135.589334,3.754517,-4.753931,-142.432700,3.606339,-4.724098,-141.365041,4.547187,-4.453620,-144.914184,4.347707,-4.223257,-141.646847,4.537949,-3.218417,-144.160732,5.217050,-4.710636,-132.269191,3.025793,-3.713738,-127.707541,2.807805,-6.539622,-114.894413,-2.193187,-4.842200,-116.137571,-0.826863,-4.819369,-115.048804,-0.902510,-4.337882,-114.237823,-0.706602,-3.969861,-115.774626,-1.319534,-3.663609,-115.333474,-1.349479,-3.566900,-114.874865,-1.268739,-3.172469,-117.340208,-0.625752,-3.076532,-118.390762,0.910322,-3.041852,-116.107309,-0.645935,-2.900739,-116.668762,-0.423770,-2.899351,-115.617810,0.191717,-2.750435,-118.118749,0.176571,-2.555581,-116.106998,0.994041,-2.481258,-114.994242,0.421042,-2.262186,-123.199791,3.014297,-2.152104,-118.270450,1.118060,-1.965825,-115.307259,1.452518,-1.318923,-114.424962,0.402346,-0.969250,-119.317375,3.152362,-0.650124,-115.615000,2.032342,-0.456349,-117.197463,1.726785,-0.365718,-116.773324,1.709118,-0.245294,-116.750964,2.604666,-0.245269,-116.645266,2.456132,0.061012,-115.899481,2.803356,0.420941,-114.843563,3.256470,0.579412,-116.579973,3.639106,0.881759,-117.863902,4.211094,0.915800,-115.486091,3.745745,1.032955,-117.419935,3.910861,1.253780,-115.314297,3.936388,1.307751,-117.272284,3.654582,1.461272,-115.846420,3.957577,1.668610,-115.566602,4.296982,1.852082,-117.525647,3.881643,1.854211,-114.520015,4.232252,2.666702,-116.498316,3.883212,-6.562684,-105.288239,-3.662334,-6.429512,-111.230287,-2.794558,-6.111215,-107.909066,-3.193254,-4.369397,-110.732972,-1.342393,-4.001906,-113.569717,-0.482826,-3.847792,-112.539933,-1.504006,-3.767177,-106.215453,-1.588749,-3.700383,-104.976015,-1.513264,-3.431963,-109.986926,-0.839524,-3.126908,-107.418746,-0.880436,-3.125447,-104.969798,-1.083703,-2.596130,-113.483752,-0.179602,-1.961259,-110.795776,-1.062890,-1.935952,-104.547137,0.097720,-1.924158,-111.394485,0.322324,-1.675009,-111.649138,0.703810,-0.764956,-104.298242,1.073896,-0.644477,-105.021733,0.715122,-0.588749,-109.795687,1.441893,-0.570257,-112.170180,0.534930,0.163367,-112.640688,2.575105,0.724553,-104.278887,1.941453,0.736483,-111.680485,2.788806,0.931965,-110.901072,2.746677,1.099916,-109.294973,2.576332,1.292936,-113.353410,3.563867,1.388506,-112.285930,3.451334,1.440131,-104.535788,2.257156,1.527559,-110.924047,3.051244,1.789676,-109.765189,2.096254,1.825120,-113.316819,3.460417,1.847439,-104.304275,2.628960,2.134423,-113.745459,3.512355,2.605831,-112.945308,3.226417,2.905043,-109.466028,2.601847,2.964971,-107.465159,3.696645,2.991859,-113.949186,4.088780,3.054291,-104.533089,3.403802,3.379472,-112.914982,3.518419,3.790242,-113.802276,4.778409,-6.293256,-102.872593,-0.235424,-6.166692,-102.499205,0.329796};
			return value;
		}
		private double[] getCoordinate_9_21_point_101()
		{
			double[] value = {-6.117936,-102.223715,0.725492,-5.102638,-100.215007,3.611671,-3.878894,-101.421572,3.173651,-3.341439,-102.612910,2.075433,-2.841151,-103.101519,1.736313,-2.160508,-103.456277,1.608712,-1.687224,-103.480619,1.838991,-6.459440,-81.810977,3.859143,-6.377852,-82.563167,4.477516,-6.115685,-82.855484,4.487246,-5.876434,-76.642882,-2.402110,-5.258536,-79.822845,2.373840,-5.115170,-76.386222,-3.255598,-4.852551,-79.200996,2.009251,-4.759710,-79.525296,2.358719,-4.506952,-80.846168,3.379164,-4.467099,-79.524584,2.477294,-3.657706,-75.894091,-4.458628,-3.379552,-77.018579,-1.038628,-3.318020,-77.127182,-0.651981,-3.185173,-75.899550,-4.439471,-3.085136,-80.304136,3.875937,-2.555769,-76.739390,-1.760611,-2.387497,-77.647762,1.369711,-1.300053,-76.104781,-3.866413,-0.903616,-77.593387,1.875365,-0.794219,-77.164863,0.404743,-0.194999,-76.839418,-0.800975,0.187717,-76.838909,-1.261361,0.734759,-78.754589,5.100209,0.901652,-77.621199,2.647536,1.350052,-77.594403,2.637352,2.606434,-75.789839,-4.879535,2.709307,-76.308454,-2.957012,3.323587,-77.782323,4.332018,-4.980583,-52.748564,-4.689599,-3.821146,-53.294375,-4.449059,-3.547599,-52.359961,-4.187820,-2.382305,-51.872629,-3.628095,-2.159537,-52.084454,-3.662769,0.329600,-55.565455,-3.989401,0.347679,-55.853207,-4.467999,0.404255,-53.264610,-3.000357,0.709186,-54.179653,-3.405617,0.917171,-52.391721,4.056521,0.952293,-52.236683,-2.139305,1.386770,-52.460301,3.560730,1.459392,-52.681398,4.138221,1.460789,-52.833980,4.722178,2.040956,-52.992138,3.736537,2.644823,-53.109641,3.032982,2.898884,-53.581442,3.540747,2.928908,-55.721016,-3.191095,2.972873,-53.429722,3.263101,3.376926,-51.815311,-0.092354,3.458960,-58.125746,-4.645436,3.720175,-57.981252,-4.264498,-6.336035,-41.480712,3.042484,-6.200565,-46.034675,-2.279024,-6.018941,-49.622013,-4.006591,-5.988676,-43.082545,4.200877,-5.932849,-47.462345,3.625099,-5.837618,-41.943180,2.908564,-5.806850,-46.612550,2.129539,-5.689038,-47.800041,4.125659,-5.392824,-42.397151,3.210518,-5.320440,-46.392760,-1.823896,-4.854864,-50.987172,-4.145317,-4.686450,-42.218411,2.696201,-4.666420,-46.826878,-1.656625,-4.524994,-42.211676,2.497052,-4.290863,-41.574440,1.691420,-4.141278,-42.537366,2.265135,-4.036743,-48.448369,-2.415002,-3.984088,-42.833997,2.382293,-3.940045,-48.961723,5.162895,-3.542834,-42.128642,1.541123,-3.025000,-48.696587,2.223388,-2.977291,-44.949080,4.011371,-2.786049,-48.290976,-1.393379,-2.248371,-50.272781,5.157899,-2.182130,-41.788832,1.474531,-2.157184,-43.775374,2.561183,-2.144637,-50.416558,3.728268,-1.916214,-44.555026,3.066767,-1.887988,-49.324341,-1.696230,-1.139779,-49.873483,-1.547588,-1.085553,-45.211832,4.177766,-1.044498,-41.290785,0.196306,0.157988,-44.848928,3.356182,0.514662,-46.608279,4.430279,0.761688,-44.260213,0.998469,0.763708,-47.282075,5.207340,1.008365,-44.945771,1.683726,1.255840,-41.386729,-2.354067,1.412577,-50.576859,0.112632,1.630508,-50.744401,-0.060692,1.902152,-51.055284,-0.339489,1.912995,-41.831082,-2.071945,1.964603,-41.394874,-2.321895};
			return value;
		}
		private double[] getCoordinate_9_21_point_102()
		{
			double[] value = {2.002749,-41.583245,-2.229731,2.054369,-42.159695,-1.842030,2.175863,-43.148244,-0.887218,2.340494,-42.762164,-1.629916,2.358585,-46.396059,3.709684,2.401627,-45.923209,2.810653,3.555251,-46.785871,4.622962,3.659648,-44.418551,-0.078594,-6.544232,-35.861955,-0.299250,-6.527406,-34.544818,-1.743281,-6.514234,-34.833207,-1.485679,-6.502904,-34.458768,-1.884135,-6.449838,-32.764135,-2.794904,-6.411373,-33.809026,-2.382664,-6.294417,-35.423625,-1.583658,-5.942073,-38.538113,0.918315,-5.833552,-33.443690,-2.706145,-5.680181,-36.912172,-1.219477,-5.625352,-39.047443,1.032908,-5.412104,-39.855907,1.422510,-5.407323,-35.261156,-2.167836,-5.115449,-34.316392,-2.505685,-4.804769,-39.125306,0.077389,-4.735489,-40.302393,1.318646,-4.022819,-31.344813,-2.486264,-3.510832,-34.401724,-1.341322,-3.256432,-36.350764,-0.721267,-3.247259,-37.733685,-0.370253,-2.746478,-38.647719,-0.462310,-2.664839,-35.793607,-1.213080,-2.503852,-39.896666,0.300277,-2.443210,-33.730343,-1.953410,-2.251015,-36.670575,-1.244685,-1.868658,-39.479492,-1.596928,-1.857395,-34.811296,-2.003097,-1.562216,-34.753098,-2.431197,-1.451842,-34.099556,-2.725289,-1.395120,-31.920029,-3.355969,-1.163163,-32.516209,-3.424050,-1.126256,-31.380633,-3.733517,-0.637823,-40.660022,-2.130158,-0.312130,-30.796837,-4.151885,-0.138077,-35.376495,-3.113054,0.191894,-32.659738,-4.732626,0.226898,-32.590733,-4.935358,0.367107,-40.325170,-2.427920,0.434243,-36.565110,-3.272727,0.599815,-40.561160,-2.338659,0.839354,-38.316089,-3.160980,0.926169,-38.789631,-3.096113,1.092400,-40.283888,-2.839445,1.203435,-38.802990,-3.161190,1.272147,-37.528224,-3.663437,1.427208,-40.264363,-2.756220,1.803447,-38.602474,-3.200072,1.806006,-38.141435,-3.315029,1.815107,-39.243340,-3.026239,2.785905,-39.795041,-2.626447,2.990637,-39.693930,-2.634500,3.696319,-37.771975,-4.331278,-6.444253,-29.019181,-3.477851,-6.235448,-27.336648,-3.838903,-6.107136,-28.234405,-3.535876,-5.960225,-28.061980,-3.685365,-5.778263,-25.233144,-4.154843,-5.576336,-29.489656,-3.131912,-4.897223,-27.080827,-3.755517,-4.537434,-28.405777,-3.558787,-3.566184,-28.009539,-5.087620,-3.320979,-29.703702,-3.191825,-2.950338,-29.471782,-3.607231,-2.771755,-29.876620,-3.298776,-1.085457,-29.666971,-4.021686,-1.003938,-30.147135,-3.969578,-0.826448,-30.070544,-4.057162,-5.996605,99.007209,-3.473562,-5.034555,99.290341,-3.686091,-4.856875,98.788354,-4.712003,-4.577706,100.613074,-0.401795,-4.284932,100.967994,0.678469,-4.071235,99.809451,-2.886517,-2.857232,100.188824,-2.995449,-1.374822,99.397703,-4.816358,-1.166767,99.816006,-4.671083,-1.008460,102.026947,2.333528,-0.963063,100.066985,-4.003171,-0.636481,101.308533,-0.000113,0.022131,100.188542,-3.922305,1.061637,102.249803,2.211487,1.552758,102.328104,2.743478,2.003796,102.198902,2.044934,2.058611,99.431536,-3.677447,2.162459,99.164737,-3.999840,2.343009,99.568972,-3.646890,2.564234,102.206463,2.372905,3.033492,98.861127,-4.324298,3.292466,99.662328,-3.588886,3.375802,103.221062,4.598183,3.591367,100.337339,-2.818976,-4.395714,-144.062746,8.947479};
			return value;
		}
		private double[] getCoordinate_9_21_point_103()
		{
			double[] value = {-4.243399,-143.654624,11.168722,-4.023962,-139.964340,5.334815,-3.609382,-144.138467,8.644568,-3.255838,-138.340906,5.721356,-3.237464,-143.320140,13.107290,-3.172591,-141.132621,5.818154,-2.514577,-144.546789,6.588763,-2.126299,-144.079507,6.158939,-2.007630,-138.068611,6.802505,-1.693099,-135.950003,6.649573,-0.729146,-136.779582,7.697263,-0.692463,-140.466324,8.055387,-0.662245,-144.085520,9.325009,-0.467757,-144.287675,8.260300,-0.319790,-140.517249,8.333875,-0.182814,-135.709795,7.936578,0.226783,-144.295347,8.312411,0.728737,-143.482762,8.558408,0.832508,-140.188304,9.400354,1.107210,-141.211859,8.760608,1.419925,-139.637047,10.042559,1.528238,-143.238829,9.210657,1.662113,-141.499356,9.107881,1.694692,-141.626597,9.109464,2.127285,-137.304680,10.304777,2.314189,-136.577062,10.318817,2.536001,-141.159236,9.929568,2.852402,-143.204232,14.548545,3.169251,-143.832123,11.204739,3.616982,-139.299833,11.915773,3.769123,-135.167089,11.292790,3.783781,-143.795304,11.485827,0.625989,-127.033071,6.458857,2.475669,-135.040404,10.125927,3.589187,-133.423536,10.718731,2.449910,-121.195630,6.358884,2.931264,-124.409783,7.672717,3.543439,-117.419315,5.592651,3.819953,-117.458293,6.247451,-5.911122,-95.264972,6.120642,-5.888160,-96.190606,5.819724,-4.545745,-96.812106,6.301052,-4.177466,-94.874758,7.149713,-3.006124,-95.788917,7.839736,-2.961986,-94.042496,8.229960,-2.882686,-98.667341,6.496331,-1.838843,-94.936253,8.980088,-0.945373,-100.238532,6.560638,-0.460936,-94.247349,10.193649,-0.403518,-100.598903,6.538360,-0.145357,-95.168066,10.273479,0.029757,-99.721892,7.780527,0.071305,-95.135309,10.455705,1.743958,-96.121851,11.462766,1.881822,-101.786712,6.562423,2.532317,-99.908576,9.333299,2.743610,-94.345017,12.789122,3.035181,-94.688040,12.946940,3.248490,-99.459132,10.284070,3.463851,-95.753323,12.948453,-6.464199,-90.611307,7.566415,-5.575364,-92.673813,6.479429,-5.335692,-89.456271,6.823821,-4.927665,-91.999248,6.681609,-4.649591,-92.090946,6.863735,-4.561144,-90.138662,7.518364,-4.478535,-90.317240,7.601365,-4.331745,-91.668091,7.049048,-3.388717,-92.291679,7.823713,-3.246966,-90.329359,8.512677,-3.214048,-91.014224,8.135279,-1.971103,-89.945349,9.603030,-1.797479,-90.402614,9.623156,-1.772236,-87.916569,8.464595,-1.152697,-91.479775,9.625705,-0.936671,-86.808430,8.780406,-0.453266,-90.196668,10.815334,0.387261,-92.680725,10.984694,2.374548,-89.765861,13.326831,2.659258,-91.577440,12.840365,3.080391,-90.936188,13.267528,3.191454,-83.007262,10.746856,3.530021,-89.886928,14.200342,-1.793745,-81.518185,5.561543,-0.496868,-81.575712,6.738806,-0.448634,-79.866240,5.537358,-0.200107,-79.627908,5.464752,-0.021698,-81.890666,7.275820,0.933722,-82.445812,8.524917,1.999606,-79.923511,7.457076,2.688830,-78.974714,6.849654,3.068430,-80.265422,8.635582,1.309843,-51.867315,6.768454,1.325811,-51.630614,7.020283,1.994404,-53.206410,5.252839,2.046615,-52.873554,5.907357,2.316509,-53.258490,5.415161,-6.598630,-44.817054,6.500809,-5.112603,-44.620118,5.654179,-4.946770,-48.056031,5.487573};
			return value;
		}
		private double[] getCoordinate_9_21_point_104()
		{
			double[] value = {-4.878262,-46.591666,6.569844,-4.560201,-47.338358,6.428312,-4.044378,-44.500557,5.495346,-3.326623,-45.663612,5.986082,-3.203067,-46.094033,6.012731,-3.098397,-48.446600,6.253894,-2.923902,-46.849399,6.404081,-2.705171,-48.202056,6.690754,-2.699039,-46.086321,5.549874,-1.972100,-48.677974,6.703710,-1.109911,-49.045825,6.983203,-0.918845,-49.523588,7.030729,-0.024257,-50.921368,6.527717,0.378403,-51.212478,6.470031,0.647888,-47.560316,5.658127,0.858215,-49.642835,7.500761,1.026020,-50.720491,7.428539,1.048362,-49.640150,7.507409,1.470282,-51.267685,7.426369,1.596485,-50.548386,7.766929,1.923261,-48.030488,6.940365,3.298533,-49.739297,8.200399,3.411444,-49.421085,7.978592,3.639576,-49.031222,7.026277,-5.927078,103.188144,14.681582,-3.761396,102.393703,6.613420,-3.158389,103.660996,13.804639,-2.241508,102.584122,7.019714,-2.105550,103.607224,15.430040,-1.382912,103.795537,14.411043,0.117192,103.040293,6.391666,0.800555,103.576340,8.126221,1.299691,103.957994,12.739028,2.240180,104.061819,12.678819,2.901278,103.743481,7.370143,2.961184,104.313193,12.382388,3.560743,104.331389,11.555226,-6.568013,-141.821733,20.742372,-5.339299,-142.605341,16.680839,-5.243294,-142.499875,17.262296,-4.874956,-141.973689,20.149556,-3.749117,-141.170868,24.629935,-2.233889,-141.894048,20.932835,-1.976390,-142.116512,19.767621,-1.592670,-141.614055,22.528760,0.089360,-142.366053,18.699038,0.211061,-141.115069,25.461714,0.491218,-141.525716,23.284718,0.601504,-141.166756,25.235162,2.538886,-142.964583,15.799106,-4.036489,103.789371,17.914254,-2.784092,103.872201,16.712037,-2.618826,103.577497,15.618326,-0.722535,104.187301,16.045493,-0.561052,104.388857,20.124627,0.226178,104.004610,23.799859,0.544710,104.279790,22.130870,1.059575,104.253810,24.183335,1.180138,104.115780,21.812689,1.348314,104.548508,20.698476,1.801575,104.374386,22.870531,2.090479,104.476655,22.906643,3.272241,104.729958,19.650309,3.783501,104.578884,21.237232,-5.801633,-139.603848,32.806007,-5.443436,-140.698557,26.950017,-0.939798,-139.926029,31.720029,0.164156,-140.285179,29.930904,1.148598,-140.902423,26.733984,1.552951,-139.964511,31.846233,2.130973,-140.788813,27.478617,3.340325,-140.347908,30.018554,-6.615315,99.326040,34.102449,-6.271832,98.594882,35.808578,-4.104387,99.301549,35.739796,-3.569242,100.926344,32.269307,-3.463624,101.022453,32.068444,-3.067910,100.219823,34.337266,-3.043937,101.759011,30.628415,-2.078954,102.004063,30.681957,-1.744710,101.058137,33.090435,-1.243701,102.743716,29.249201,-0.066307,101.134045,33.705843,3.282135,100.575931,35.299899,3.655958,101.409721,33.781112,3.672448,102.754583,31.134575,-6.241862,-137.174223,45.849998,-4.628767,-138.617814,38.281147,-3.246647,-138.839112,37.272609,1.012895,-138.245159,41.046518,1.044086,-138.363664,40.411726,2.050328,-138.754722,38.437364,2.475990,-139.126037,36.492161,3.655959,-139.080269,36.896885,3.664972,-137.622830,44.758048,-6.049800,91.101560,44.694749,-5.991854,92.307809,43.424479,-5.915586,92.627460,43.079534,-5.742284,92.576640,43.197564,-5.222137,91.046201,45.022144};
			return value;
		}
		private double[] getCoordinate_9_21_point_105()
		{
			double[] value = {-5.085533,90.209126,45.757563,-4.949876,94.480137,41.592942,-4.821246,92.608934,44.182259,-4.743550,92.809488,44.153753,-4.650835,94.123838,42.415068,-4.419508,93.122965,44.775466,-4.265927,90.594468,46.417243,-4.116109,92.887826,45.548779,-3.816456,93.634565,45.179126,-1.172731,93.271451,46.389861,0.118567,94.080021,44.499466,0.553225,93.656327,44.964572,1.919382,94.222752,44.782567,2.325249,94.720242,44.079631,2.761450,92.784859,46.221022,2.931365,93.931986,44.684618,-4.102533,95.132497,42.361567,-3.923125,96.071258,40.636657,-3.701349,95.363961,42.655753,-2.400131,96.150072,42.361570,-2.370881,99.054016,37.071026,-2.070048,97.074382,40.807150,-1.940977,97.054824,40.842855,-1.700934,97.351553,40.366484,-1.670279,97.505989,40.053549,-0.835983,96.286459,42.100852,0.086581,97.265614,40.464126,0.147440,95.842029,41.611701,0.450861,97.852323,39.726816,0.758900,98.544160,38.693887,0.796132,96.306863,40.716079,1.105422,98.270764,39.060739,1.152866,96.816376,39.915527,1.265442,96.236925,41.463855,1.272912,97.409880,39.355131,1.273787,99.358715,37.480660,1.277898,95.941516,42.039027,1.416171,96.488522,41.007110,1.654697,95.628274,42.919623,1.799975,95.240725,43.476560,1.888170,98.882468,38.064616,1.944365,96.802506,41.186661,2.451578,97.803651,38.874748,2.491982,97.595062,39.793516,2.591361,98.510256,37.962925,2.702220,99.201423,37.208371,2.876908,95.542867,42.710037,3.409176,99.412233,36.758905,3.600841,97.994649,39.644457,-6.326779,-136.847515,47.600560,-1.819478,-136.814488,48.382606,0.524988,-136.618598,49.753257,1.325453,-135.637361,55.152326,1.364118,-136.533423,50.325175,2.653984,-137.148136,47.182793,3.143681,-136.282116,51.919027,-6.248917,77.919216,53.384885,-5.845362,77.120437,54.259784,-5.823015,78.527339,53.042053,-5.691580,78.354753,53.227720,-5.558969,78.178639,53.408230,-5.438501,78.451662,53.136438,-5.056909,84.051518,49.693201,-5.005577,79.987491,52.144605,-4.965849,78.049660,53.454878,-4.130645,75.947837,55.180358,-4.015327,80.061167,52.527118,-3.880259,75.365593,55.696409,-3.510818,82.088000,51.393523,-3.141180,78.084819,54.194055,-3.090857,77.295387,54.755938,-2.969720,78.922538,53.655018,-2.913984,74.657655,56.925542,-2.663434,78.083544,54.279741,-2.525439,81.781279,51.862389,-2.274541,82.235196,51.494611,-2.002350,75.688985,56.163238,-1.957210,80.715044,52.761102,-1.527885,81.400559,52.191693,-1.079163,82.504505,51.950525,-0.951063,75.297061,56.568240,-0.652865,80.595880,52.960246,-0.306922,81.692063,52.612470,-0.062241,75.842439,56.097298,0.373622,77.797087,54.953905,0.895843,77.290767,55.656261,0.919032,75.355880,56.960517,0.930199,80.557917,53.600873,1.096983,81.806101,52.893213,1.222063,75.473862,56.992774,1.326090,77.820232,55.449456,1.336971,79.409304,54.387392,1.774641,83.927777,51.847638,2.109356,83.074021,52.324641,2.585492,81.518886,53.390850,3.374747,77.240950,56.343068,-4.975064,86.018553,48.658360,-4.760537,86.814355,48.233757,-4.322017,86.618551,48.466339,-4.193957,87.623744,47.875776};
			return value;
		}
		private double[] getCoordinate_9_21_point_106()
		{
			double[] value = {-3.711021,86.963663,48.572816,-3.508879,87.587217,48.087336,-3.318352,86.869288,48.753957,-3.317865,91.348405,47.373013,-3.134642,88.207034,47.996430,-3.125563,90.581575,47.835617,-2.708018,90.332314,48.275020,-2.232154,86.168890,49.444755,-1.581230,84.387707,50.760505,-0.390547,90.037866,49.446237,-0.054453,84.759512,50.978279,-0.028987,91.971721,47.876228,0.122953,90.903265,48.978659,0.127280,90.566632,49.253323,0.185973,89.091332,50.144203,0.661993,85.545674,50.603593,1.518133,85.072345,51.108033,2.569154,87.501176,51.197143,3.263065,85.178934,51.296012,1.184037,-135.253315,57.204516,-4.866922,-134.358439,61.219553,-4.444456,-133.596887,65.383733,-3.765675,-134.121684,62.644118,-0.064270,-134.355199,61.880602,-6.549754,1.768096,66.270629,-6.292364,1.838335,66.236121,-5.161817,8.300565,62.166741,-3.967716,7.071205,62.912125,-3.955924,4.176926,64.589428,-3.135377,10.941204,61.437954,-2.513474,1.201107,67.424788,-2.153952,4.780548,64.381238,-1.996227,7.435901,62.957342,-0.935318,4.536984,64.506788,-0.337979,8.623898,62.415884,0.191366,5.741982,63.751748,1.724124,7.317311,62.891117,2.426123,2.822025,65.282136,3.367875,10.311050,61.417173,3.686664,10.791045,61.188777,-6.396677,12.345877,60.239850,-6.057490,11.213987,60.775477,-5.923858,12.562887,60.286988,-5.077942,17.960283,59.012422,-2.064979,12.747302,60.952303,-1.650172,21.456117,59.183969,-1.166838,15.371360,60.262577,-0.892516,17.561406,59.709297,-0.581138,14.556654,60.543063,-0.364976,11.815560,61.298771,0.160083,20.502093,59.081057,0.275349,14.143448,60.542409,1.062955,21.257075,59.261467,1.207218,20.535074,59.047756,3.210161,16.198710,59.643668,3.214702,21.570520,59.424240,3.262844,15.854154,59.732949,3.381007,16.114740,59.637941,3.522116,21.325478,59.433751,-6.568279,24.798756,60.451977,-6.464404,28.483504,63.918911,-6.302970,28.189910,63.732481,-5.862970,28.197823,64.094069,-5.382691,31.946534,65.686369,-4.703953,30.044731,65.389382,-4.311751,23.703062,60.447765,-4.047582,23.022711,59.963437,-4.019632,29.388718,65.277391,-3.539904,29.525826,65.397941,-2.522958,22.679547,60.028752,-1.840022,27.800370,64.900814,-1.478365,23.635342,61.505984,-0.968888,21.847044,59.535849,-0.285693,31.963055,64.970793,0.086856,25.786047,63.716255,0.116696,28.263492,64.766010,0.331087,29.264954,65.008255,0.381416,21.951640,59.774567,0.756443,28.074446,64.590611,0.867883,27.493777,64.294456,0.897626,31.599157,64.756594,1.373766,31.807349,64.780523,1.382256,29.989906,64.733846,1.555573,26.630759,63.676123,1.668437,22.014930,59.949709,1.773553,26.835242,63.733696,1.870854,22.810889,60.610383,2.282005,27.436102,63.783587,2.435802,21.725728,59.670471,3.123247,24.909523,62.139283,3.240310,21.944316,59.573899,3.245736,24.954404,62.052566,3.304226,24.156244,61.359890,3.307873,26.088131,62.556523,3.496957,23.053898,60.185993,3.634381,23.047777,60.181555,-5.976908,35.372476,65.721965,-5.890960,38.921175,65.153666,-4.723340,38.355525,64.675999,-3.906803,37.001214,64.625611};
			return value;
		}
		private double[] getCoordinate_9_21_point_107()
		{
			double[] value = {-3.535039,37.139474,64.466066,-3.526825,32.578729,65.824056,-3.166971,42.494076,63.913653,-3.146072,36.843800,64.491814,-3.140994,36.629933,64.527482,-3.067274,35.427513,64.791829,-3.044251,36.162011,64.613789,-3.016912,34.361098,65.188925,-2.621820,41.648033,64.575291,-2.491762,40.213782,65.200712,-2.484227,32.302321,65.751978,-2.238565,34.499644,64.861719,-2.180693,40.181994,65.580039,-2.149827,39.117324,65.682244,-2.000321,33.429930,65.075694,-1.872422,38.579970,65.945857,-1.626572,39.809882,65.958821,-1.600884,37.531590,65.924822,-1.475882,37.535089,65.932936,-1.218315,41.099525,65.849232,-1.110478,42.090655,65.773265,-0.859496,36.203763,66.134283,-0.832131,35.034617,65.780870,-0.724276,36.815735,66.239585,-0.604435,36.158208,66.203835,-0.253660,38.294705,66.364611,0.056588,41.779499,65.674763,0.278562,36.257952,66.360250,0.366644,37.764758,66.287058,0.379424,35.968765,66.325220,0.454406,40.287821,66.260250,0.629646,40.283871,66.412087,0.770409,39.976910,66.571765,0.902205,40.623817,66.795697,1.275956,40.522335,67.253894,1.571547,37.676471,66.804595,1.762839,35.809416,66.169060,1.813216,39.168791,67.398947,2.529274,37.436619,67.040617,3.214840,34.253119,65.658447,3.630860,38.410702,66.482991,3.685184,35.896664,65.886106,3.795614,36.348056,66.018343,-6.515737,43.913706,63.696157,-6.448773,45.561782,62.950946,-6.244598,45.768342,62.947224,-6.213491,44.218353,63.663011,-6.206538,52.966258,63.861965,-6.039018,52.504594,63.718781,-5.973812,43.166091,64.320383,-5.865333,50.668760,63.987318,-4.937521,45.810682,63.204072,-4.925066,52.330083,64.286386,-4.704658,45.016290,63.739758,-4.600884,43.956770,64.154333,-4.453569,43.033406,64.197320,-4.351831,52.786256,64.497407,-4.313559,44.307841,64.008944,-4.019864,47.724249,63.100097,-3.776047,45.496692,63.694892,-3.726754,50.198369,63.599613,-3.705713,43.698913,63.809751,-3.415143,50.905851,63.953047,-3.286233,50.450783,63.635841,-3.048116,43.266477,63.827081,-2.901584,42.722205,64.023178,-2.556216,49.801612,63.667933,-2.162870,43.524983,64.685005,-2.108283,43.977364,64.554614,-2.025573,44.075068,64.586444,-1.991037,43.813813,64.731110,-1.977665,49.797107,63.859417,-1.725224,52.677785,64.384593,-1.677987,51.721478,63.719953,-1.469931,51.557893,63.580637,-1.325913,47.682548,63.760031,-0.951035,52.573121,63.822740,-0.257828,51.918163,63.320908,-0.103892,49.943763,63.914975,-0.068421,45.701582,64.883824,0.076686,43.095638,65.263888,0.108273,49.734161,63.881435,0.412810,43.617557,65.208828,0.445013,49.782514,63.841993,0.686390,50.297169,63.732105,0.890829,42.869970,66.073354,1.048687,46.278602,64.728311,1.049349,51.427251,63.543141,1.154608,44.714130,65.559561,1.323541,45.444832,65.405101,1.434691,45.285155,65.589557,2.167534,46.747275,65.263042,2.404890,43.239659,66.882619,2.507722,46.298913,65.444308,2.689834,42.884884,67.138283,3.065420,47.026262,65.338895,3.126069,45.895150,65.762774,3.233312,46.555819,65.599328,3.317986,46.076458,65.691172,3.699470,48.955105,64.654898};
			return value;
		}
		private double[] getCoordinate_9_21_point_108()
		{
			double[] value = {-5.553038,58.034056,65.003960,-5.532611,58.174077,65.008820,-4.788210,60.151423,65.006575,-4.775658,59.722380,65.086908,-4.375433,56.654812,65.094674,-3.768758,58.281710,65.232134,-3.410333,55.736576,64.374564,-2.915349,53.506739,64.701933,-2.740541,60.212699,65.029483,-2.603959,54.749794,64.826461,-1.103821,57.722892,64.889457,-0.951804,59.866039,64.403280,-0.944340,58.278617,64.806349,-0.569380,59.996552,64.398882,-0.246658,53.181844,63.683622,0.125778,62.289064,63.990087,0.227652,54.324851,63.944873,0.395322,60.689741,64.314150,0.441340,54.748953,63.973827,0.496669,61.807877,64.067134,0.909053,54.097052,63.287981,1.023808,57.636677,64.244625,1.059382,62.042414,63.874001,1.689841,55.724211,63.186635,1.941554,57.715970,63.420864,2.342643,57.307801,63.046977,3.346199,57.663717,62.852531,3.684770,57.498867,62.793203,-6.525762,69.239290,60.446253,-6.219296,66.677808,62.654592,-5.963121,71.596467,59.023725,-5.768625,68.981652,61.250603,-5.383602,73.119086,57.945144,-5.340152,70.722921,59.474498,-5.207201,69.090658,61.375513,-5.164276,68.839141,61.556799,-4.913900,68.742823,61.635929,-4.878662,71.376143,59.004678,-4.772392,64.111284,64.061074,-4.650530,69.491966,61.209886,-4.373109,69.741354,61.058635,-4.355940,72.591460,58.018824,-4.210900,63.458089,64.127460,-3.608088,72.774863,58.328864,-3.530385,65.099917,63.652857,-3.517567,71.722377,59.483866,-3.347332,71.440174,59.702479,-3.346496,64.990053,63.637445,-3.342979,72.590189,58.694860,-3.162375,68.624777,61.759072,-3.031975,72.968834,58.384073,-2.978364,66.305291,63.073313,-2.933434,67.628993,62.310049,-2.820392,73.266123,58.121119,-2.559574,69.637011,60.980574,-2.370237,67.692214,62.199069,-1.504881,69.098541,61.125511,-1.020935,70.685922,60.013837,-0.752807,68.159476,61.328016,-0.739698,73.291082,57.935122,-0.501419,63.926065,63.706138,0.052432,71.321212,59.302011,0.253603,64.673293,62.805736,0.501204,63.623278,63.463221,0.812276,63.905475,62.928396,0.874764,64.546558,62.500437,0.921570,70.480632,60.161729,0.964338,71.797438,59.387500,0.981193,68.903738,61.052157,1.002468,67.683401,61.600486,1.889411,65.763697,62.372448,2.119950,63.733289,62.724831,2.159536,67.569082,61.057907,2.336074,65.771739,62.143132,2.546192,64.194947,62.797381,2.692321,67.800976,60.804005,2.767557,72.510502,59.096969,3.182146,72.357147,59.615189,3.192940,69.071876,60.836332,3.295032,70.361751,60.677093,3.342783,68.014842,61.043234,3.404226,68.617531,61.087124,-0.591189,73.909363,57.456995,-5.146358,-133.145034,67.726459,-4.067197,-132.065902,73.690781,-2.306708,-131.840365,75.143055,-0.620799,-133.229099,67.879375,3.667305,-133.015861,69.604257,3.676109,-132.247866,73.746971,-6.094705,-75.503562,77.893387,-5.266805,-2.327990,77.853062,-4.902254,-1.343122,74.377797,-4.259262,-0.932625,74.115443,-2.628556,-0.640370,74.614758,-0.704247,-0.668763,75.539088,-0.626202,-0.353153,75.195101,1.738088,-0.387259,69.931647,1.771078,-0.423985,69.388985,1.891989,-0.805215,76.750099,1.994984,0.557427,71.510362};
			return value;
		}
		private double[] getCoordinate_9_21_point_109()
		{
			double[] value = {2.210125,-0.062419,71.027248,3.014580,-0.665425,70.673655,3.283447,-0.207509,76.169961,3.521591,-1.072390,69.721621,-6.118501,1.702779,71.991672,-5.940065,2.590342,71.348192,-4.963048,2.081516,72.213473,-4.652231,1.215191,67.657396,-4.534643,1.230120,68.267707,-4.264327,2.384597,72.186445,-4.115396,2.093680,72.485676,-3.061647,2.537072,71.717148,-2.956976,2.472120,72.407364,-2.425769,0.899778,68.243796,-1.643524,0.863611,69.627836,-0.224940,2.012985,73.758504,1.828116,1.475985,72.130334,2.394572,1.863879,72.664659,2.541263,1.415647,74.897259,-6.031391,-130.387584,82.478557,-5.429157,-129.984959,84.730728,-4.724173,-130.826410,80.287351,-4.149351,-130.878938,80.080768,-3.642758,-130.017627,84.794351,-0.516011,-129.482842,88.097251,-0.098668,-130.787709,81.115747,1.684122,-131.085487,79.748943,2.110917,-131.066246,79.909801,3.635457,-131.405193,78.286238,-6.278736,-83.716566,84.421573,-5.258423,-82.886620,84.523223,-3.566753,-84.017356,87.709142,-3.051567,-83.843020,87.977235,-5.882329,-74.416200,78.255546,-5.337014,-75.201339,78.585877,-5.282550,-79.569079,81.757889,-5.100671,-76.831773,80.255752,-4.324193,-82.470782,85.046176,-3.937299,-75.488787,79.925489,-3.198489,-75.218682,80.493856,-3.176696,-79.945133,84.175586,-3.095322,-80.567336,84.706556,-2.631962,-82.631948,86.954208,-1.916941,-76.230703,83.221467,-1.330961,-72.436306,82.236441,-1.118797,-77.140594,84.572279,-1.058684,-78.614772,85.430971,-1.008216,-75.156587,82.762754,-0.297902,-75.681146,84.514065,-0.128221,-78.501263,86.238067,-0.067029,-80.093792,87.282344,0.358094,-75.611948,85.199747,0.502141,-73.635286,84.068560,0.637842,-76.837170,86.136329,0.710386,-74.996737,84.538120,0.791803,-72.921668,84.626432,1.146742,-76.682894,86.548677,1.162629,-75.392958,85.858098,1.444254,-72.937434,85.394182,1.602727,-74.674189,85.232035,2.226700,-73.507230,85.806285,2.712609,-77.340286,88.177841,2.886310,-73.495108,86.088181,3.138442,-73.806933,85.997925,3.593501,-73.470512,85.896403,-6.467025,-64.738221,80.343161,-6.204537,-66.067511,79.595633,-4.994842,-68.405712,79.181567,-4.910843,-69.368746,78.919153,-4.719755,-69.279896,79.135266,-4.432151,-69.013847,79.532507,-4.093578,-63.359630,83.001904,-4.044276,-68.947488,79.956440,-4.015199,-66.358616,81.133056,-3.626726,-66.026772,81.703656,-3.512220,-69.620104,80.201134,-2.604353,-69.375337,81.064573,-1.031543,-66.166390,83.510624,-0.825007,-63.832951,84.904091,-0.710965,-63.752214,85.063848,-0.298161,-62.157989,86.066309,-0.048963,-65.598566,84.558337,0.255462,-63.332824,85.705848,0.969030,-64.138442,85.886827,0.974897,-62.209108,86.787900,1.602630,-65.214807,85.858989,1.798356,-65.815230,85.769297,1.813183,-62.694017,86.956341,1.934774,-66.079055,85.753353,2.583454,-67.792466,85.719009,2.633066,-67.575166,85.764668,2.660895,-65.420865,86.186215,2.904068,-65.003372,86.357253,2.954589,-62.158392,87.509545,3.369938,-67.948727,85.886412,3.438438,-70.592374,86.123049,3.540529,-69.309161,85.970706,-6.459499,-57.169829,88.108072,-5.272216,-59.616175,85.675518,-2.944577,-60.382068,86.203322};
			return value;
		}
		private double[] getCoordinate_9_21_point_110()
		{
			double[] value = {-2.341948,-59.164046,87.693020,-2.177689,-60.743065,86.200060,-1.658250,-60.004266,87.207446,-1.253006,-60.579189,86.881216,-1.103653,-60.887221,86.711615,-0.398576,-60.925293,86.922396,3.139020,-60.741259,88.263316,3.428925,-61.463510,87.921248,-6.502815,-16.541707,85.549480,-6.123149,-17.095014,85.457415,-6.001253,-20.006027,88.270604,-5.468356,-15.919207,85.484158,-4.763486,-13.329665,86.060009,-4.520316,-10.700405,85.857837,-3.885897,-11.828993,86.235751,-3.804535,-15.478426,85.455829,-2.761296,-10.835045,86.100826,-2.747493,-11.803105,86.016171,-2.587700,-15.601638,86.321778,-2.528977,-9.999116,85.931131,-1.520056,-12.540075,85.530449,-0.469652,-15.115149,87.884377,-0.171051,-13.124634,85.798577,-0.061388,-13.922189,86.757969,-0.060386,-11.505198,85.500904,0.147795,-10.948293,85.549879,0.894071,-12.339021,85.800076,0.907579,-11.031532,85.469881,1.385902,-11.936582,85.745292,1.608194,-10.451945,85.452070,1.775650,-10.776015,85.446848,2.047785,-11.592659,85.803824,3.263039,-9.941458,85.361779,3.451978,-10.393080,85.503241,-5.691483,-5.938971,80.939922,-5.321920,-3.408396,79.446468,-5.094186,-3.839834,79.831141,-4.644174,-5.492516,81.183220,-3.438307,-2.435828,79.085614,-3.053972,-2.646549,79.541238,-2.901087,-2.153278,78.709473,-2.876764,-3.336645,80.259308,-2.251393,-2.262632,79.183480,-1.932825,-4.269316,81.329244,-1.128776,-9.623690,85.897912,-0.700180,-1.842656,79.055108,-0.528822,-7.009734,84.350500,-0.476824,-1.489974,78.200941,-0.380259,-3.174480,80.965189,-0.260182,-7.466603,84.907502,0.257096,-2.500871,80.444338,0.686184,-2.711347,80.838381,0.810804,-9.277873,85.842778,1.294349,-8.528039,85.785766,1.492262,-8.425201,85.771067,1.872447,-4.031241,82.395657,1.978441,-1.048511,78.011323,2.127871,-4.840293,83.411244,2.183022,-3.519363,81.889418,2.241874,-8.517948,85.783071,2.290995,-2.544134,80.972074,2.409353,-4.211045,82.618407,2.599679,-8.451862,85.747158,3.252756,-1.409364,79.438735,3.715111,-9.422381,85.301774,-0.240110,-128.657431,92.585828,0.491761,-128.568981,93.160614,3.774575,-128.385415,94.590469,-6.535213,-119.665670,96.824093,-6.137073,-123.618226,98.226458,-5.443977,-116.290378,96.875772,-6.179327,-110.727618,94.902877,-5.169397,-104.630908,94.424276,-4.828133,-107.568619,95.366486,-3.669818,-112.210768,97.399940,-2.904980,-104.542851,96.398771,-6.306787,-93.718941,91.115155,-5.188450,-97.778677,92.934333,-5.089890,-98.493969,93.193909,-4.938992,-97.664798,93.164183,-4.402839,-98.525106,93.772167,-3.985131,-99.084466,94.273769,-3.300728,-98.460342,94.727337,-3.279003,-98.892450,94.848006,-3.001119,-99.011685,95.084482,-2.985167,-102.836635,95.948350,-2.913928,-98.678535,95.088104,-2.881572,-99.239547,95.272346,-2.871195,-102.578408,95.998558,-2.597171,-98.751096,95.457677,-1.884573,-100.415697,96.408270,-1.708333,-97.418386,95.965685,-6.119196,-89.032068,90.184914,-4.627194,-86.552236,90.626558,-2.989442,-88.006363,92.606173,-2.933334,-85.976045,91.637851,-2.541299,-88.038220,93.005265,-2.536437,-85.957278,91.999338,-1.133814,-85.992108,93.435703,-0.759508,-86.134885,93.908123};
			return value;
		}
		private double[] getCoordinate_9_21_point_111()
		{
			double[] value = {1.124170,-85.484674,95.082425,1.235159,-85.451592,95.142245,1.240524,-83.243968,91.510635,1.655645,-87.914052,96.773281,2.041301,-84.159465,93.467725,3.425435,-84.485924,95.348061,3.751576,-85.379155,97.886428,3.785314,-87.029121,98.497422,2.431495,-80.189338,89.610529,3.067576,-82.335809,92.073746,3.111389,-77.827229,88.605552,3.303974,-78.643101,89.087012,3.637653,-82.290074,92.420361,3.680327,-78.860617,89.096996,-6.552796,-55.930034,89.624487,-5.988165,-54.567283,91.408906,-4.418141,-56.125488,90.243942,-3.905919,-51.803655,95.140750,-3.177647,-56.366670,90.441092,-2.846447,-54.804607,92.470876,-2.441018,-51.659925,95.905418,-2.439692,-55.365181,91.868974,-2.360915,-56.846536,90.112749,-1.025673,-55.732083,92.013468,-0.916360,-53.525377,94.483799,-0.085580,-58.984571,88.758394,0.391018,-55.004623,93.150119,1.085028,-52.684792,95.854345,1.392333,-55.847936,92.270048,1.717874,-53.721481,94.849398,1.812828,-51.610270,97.165715,1.866904,-59.371068,88.839544,1.947198,-57.954865,90.178507,2.078196,-54.307169,94.298327,2.965558,-53.298342,95.532956,3.060500,-57.927106,90.321805,3.289039,-54.767442,93.699658,3.421879,-56.918960,91.407864,-6.414770,-50.078082,95.971757,-5.405503,-48.009380,98.390378,-3.539292,-51.336799,95.882082,-2.376300,-49.624489,98.004249,-2.227897,-51.023646,96.596740,0.541699,-51.208405,97.270241,0.550385,-50.075175,98.517781,-6.468943,-38.749205,96.900673,-6.354120,-31.188896,93.810057,-6.111642,-37.976268,96.967534,-6.039511,-36.850457,96.426735,-5.988961,-36.676345,96.394954,-5.865162,-40.832104,98.242597,-5.848833,-32.824043,94.605420,-5.149788,-34.924536,96.526603,-5.078258,-38.604335,98.346693,-4.884596,-30.927961,94.376930,-4.188819,-31.959145,95.828017,-3.911395,-31.128844,95.711372,-3.401893,-34.583691,98.376080,-3.335914,-32.948578,97.520838,-5.794686,-28.011354,92.847803,-5.684431,-24.229064,91.579243,-5.625555,-26.048577,92.320319,-5.287922,-23.672181,91.507339,-4.807081,-29.268488,93.609177,-4.630970,-23.296922,91.590053,-4.572938,-30.029401,94.173653,-4.127933,-22.805425,91.484370,-4.033892,-30.525864,95.087231,-3.812124,-22.308706,91.344622,-2.895330,-28.143727,94.754860,-2.658943,-29.760253,96.314200,-2.504824,-22.417770,91.531151,-2.349861,-28.616221,95.877846,-2.196284,-23.122901,91.994185,-2.005480,-24.203504,92.810081,-1.853545,-22.679709,91.966004,-1.709657,-26.433014,94.972411,-1.279355,-28.888611,97.399425,-1.147052,-25.512001,95.109976,-1.082302,-25.506097,95.179287,-0.871741,-20.207289,91.335844,-0.842121,-30.204075,98.622845,-0.821398,-27.844724,97.085690,-0.172381,-23.750605,94.881917,-0.017109,-23.131846,94.494840,0.263847,-22.360262,94.318774,1.384554,-25.398842,97.693900,1.687052,-22.692020,96.023481,1.811685,-24.006909,97.173967,1.913724,-25.793865,98.563850,2.702903,-22.570044,96.982166,-1.659263,-16.948546,88.849695,-1.557108,-16.710459,88.690736,-1.499299,-17.962474,89.852516,-0.478514,-16.774706,89.639651,-0.419480,-18.900880,90.906653,0.323865,-15.706532,89.259154,1.385500,-18.003795,91.738459,2.530493,-19.572765,94.326443,-5.113540,-127.190189,99.845575};
			return value;
		}
		private double[] getCoordinate_9_21_point_112()
		{
			double[] value = {-3.532762,-127.367869,99.099102,-3.434645,-127.125066,100.421373,-2.082665,-126.806249,102.322165,-1.686253,-126.336734,102.546615,-1.685926,-127.274468,99.850078,0.163757,-126.981605,101.677739,0.296515,-126.537041,104.092842,2.441968,-127.319945,100.157924,2.504301,-126.548669,104.326194,2.693617,-126.825002,102.861229,3.228831,-125.653521,106.462467,3.391939,-126.491910,104.751114,3.589762,-127.075138,101.632233,-3.988358,-122.027458,99.624524,-1.937373,-122.455123,101.447691,-1.409076,-119.551280,101.178877,-1.274168,-114.225988,99.980357,-0.933327,-123.852588,102.632156,-0.830088,-115.392043,100.641284,-0.773423,-122.135796,102.350260,-0.060299,-117.034216,101.721405,1.963473,-114.423014,102.908243,2.637445,-123.009364,105.339364,-1.044912,-107.644453,98.732835,-0.350405,-110.345716,99.960669,1.935491,-108.812814,101.725790,2.142168,-107.961697,101.730841,2.676871,-113.540442,103.375314,2.710387,-112.986816,103.292939,2.898023,-103.784192,101.522419,2.247919,-103.469264,100.852079,3.226210,-94.538424,99.811243,-6.256312,-47.163301,98.832211,-5.329136,-41.276631,99.002958,-5.203724,-44.347405,99.844864,-4.144613,-47.492990,99.353571,-3.925435,-46.575935,100.389955,-3.535738,-47.968902,99.087446,-2.961044,-47.505528,99.872733,-2.443868,-46.904123,100.456508,-1.972756,-42.119384,102.086820,-1.922181,-43.596938,101.958525,-1.915962,-47.679390,99.988138,-1.266581,-45.956180,101.591272,-1.073075,-49.171511,98.927549,-0.742655,-47.729421,100.413270,-0.521226,-46.752528,101.309444,-0.434420,-44.995698,102.399741,-0.341008,-48.831658,99.340793,0.015206,-47.866270,100.483532,0.739321,-46.638787,101.907382,0.998435,-46.751038,101.896364,1.357088,-44.620862,103.037186,1.513166,-47.448294,101.448626,1.661901,-42.010231,103.950346,2.128956,-41.244192,104.233124,2.238730,-46.849129,102.132651,3.179286,-47.711297,101.690406,-5.238773,-40.065260,98.738214,-4.002460,-36.548295,98.702475,-2.565220,-35.046462,99.624452,-2.422689,-35.274516,99.875644,-2.236828,-36.692727,100.659382,-2.030306,-36.855374,100.879844,-0.482530,-34.073960,101.183936,-0.287279,-38.061393,102.667055,0.092958,-38.899297,103.059955,1.600902,-36.899335,103.302019,1.792555,-33.167093,102.142787,1.982289,-39.722859,104.025039,2.630882,-35.819555,103.033617,2.662030,-32.981432,102.170762,2.671207,-40.062895,104.058524,2.788672,-39.802840,103.962562,2.827146,-32.848850,102.118141,3.168358,-34.390901,102.471847,1.078006,-27.395554,98.785894,2.030362,-30.614950,101.331046,2.246952,-28.171066,100.299962,2.295299,-26.147105,99.175113,2.721441,-29.861418,101.242079,2.857086,-27.810100,100.484479,3.032107,-27.893316,100.577106,10.468422,32.078203,-28.453583,10.547866,32.016816,-27.753497,13.102596,31.722904,-26.291270,13.283410,31.638126,-26.066315,13.480084,31.821524,-26.468349,13.656536,31.750846,-26.235942,4.020003,32.979679,-26.363650,4.676253,42.005226,-29.963144,4.925373,36.371860,-29.642443,4.952207,38.977488,-30.205380,5.006551,39.445531,-30.267529,5.015380,33.099055,-27.338437,5.139400,37.256154,-30.136477,5.222591,41.680228,-30.394646,5.468967,32.439294,-26.293050,5.655501,32.376343,-26.198596,5.752062,37.259509,-30.561195};
			return value;
		}
		private double[] getCoordinate_9_21_point_113()
		{
			double[] value = {6.209839,33.006338,-27.884493,6.497741,32.176867,-26.021809,6.538959,33.289377,-28.553366,7.768730,35.770780,-31.408056,8.700387,33.374016,-30.151372,8.748685,37.600654,-32.241671,9.161520,32.096222,-27.600956,9.425232,32.361803,-28.575014,10.121715,32.243369,-28.761011,10.390124,32.491490,-26.211528,10.523660,32.519732,-26.141616,11.104945,32.307121,-26.983358,11.312103,33.077238,-31.080020,11.780174,33.491896,-31.665127,11.806710,40.226314,-33.612117,11.905631,32.578551,-30.371923,12.565397,32.093141,-28.922436,13.000740,32.507859,-26.966891,13.047596,32.217359,-29.414036,13.504762,32.677429,-30.786233,13.851594,37.244712,-34.405707,14.017861,32.955596,-31.283533,14.158592,32.665026,-28.244744,4.700861,47.407184,-29.538883,5.175682,48.502570,-29.883496,5.550807,44.506696,-30.300728,8.294514,43.687984,-31.949871,8.940493,43.120346,-32.275092,10.137557,48.574037,-32.564875,10.578843,50.022221,-32.760263,10.623191,49.038425,-32.710089,11.697671,44.393292,-33.317838,13.224620,52.163986,-33.735525,6.807094,55.491915,-31.678412,8.525598,59.408047,-32.648793,9.606529,63.319446,-32.575580,10.148489,60.568583,-33.056687,10.624818,60.575941,-33.123052,10.775687,57.054827,-33.332703,10.870271,57.037465,-33.347540,11.721709,58.499286,-33.538873,12.327845,61.833644,-33.242614,12.446038,60.882762,-33.393578,12.670525,62.288311,-33.199021,13.332328,62.901723,-33.167171,13.885014,60.524799,-33.602925,5.276517,71.554204,-29.183366,5.293615,71.227984,-29.301946,6.619060,73.259299,-29.024806,9.208739,67.624726,-31.478731,9.460336,66.218337,-31.887072,9.880134,63.800667,-32.516671,10.102609,70.453439,-30.806703,11.154126,72.747692,-30.015990,11.361572,72.274420,-30.209138,12.740476,71.051583,-30.755764,13.190098,65.858657,-32.500703,13.744907,72.299520,-30.287696,4.403709,78.270601,-26.281810,4.758199,76.656222,-27.115719,5.612918,77.819029,-26.838543,9.254507,78.746715,-26.975503,9.522210,78.698770,-26.982205,10.002039,81.582905,-26.418418,10.316616,80.910531,-26.785885,10.855930,82.633069,-26.098994,11.113192,78.441409,-26.981598,11.169690,79.428321,-27.176744,11.193333,75.579366,-28.733977,11.648916,81.015464,-27.084832,11.853337,79.040638,-27.442428,12.783968,81.465369,-26.857959,13.462322,75.924597,-28.427784,13.978663,79.266661,-27.544660,4.083059,-14.261502,-16.919304,4.283175,-16.047179,-16.476780,4.378971,-10.126282,-16.847645,4.685346,-14.246901,-17.230457,4.799398,-15.910212,-16.955564,5.021992,-10.945600,-17.117189,5.707235,-18.835440,-15.648366,5.726786,-14.980643,-17.263016,5.897819,-15.903289,-17.193145,5.985518,-18.307435,-16.326529,6.197272,-17.639989,-16.769510,6.223106,-15.811660,-17.198099,6.242133,-15.877945,-17.201324,6.296013,-12.820202,-16.891934,6.645037,-13.632095,-16.810895,6.829579,-14.237654,-16.719505,7.037710,-18.358765,-16.260921,7.067856,-14.995826,-16.564066,7.238047,-18.895056,-15.597983,7.362014,-14.799543,-16.740049,7.414753,-15.937419,-16.441345,7.549510,-15.844588,-16.375072,7.807607,-16.092509,-16.253548,8.043074,-15.068189,-16.669676,8.343898,-9.751674,-16.790042,8.357639,-11.572359,-16.584511};
			return value;
		}
		private double[] getCoordinate_9_21_point_114()
		{
			double[] value = {8.562196,-15.091058,-16.186775,8.564204,-17.135353,-15.781450,8.774731,-17.581927,-15.658230,8.905188,-9.753516,-16.847046,9.324698,-13.516564,-16.563514,9.528785,-11.020546,-17.444333,9.547516,-13.492303,-16.753633,9.736684,-13.163336,-17.041485,10.498308,-11.757311,-17.308615,10.960623,-14.509069,-16.584343,11.254519,-10.188802,-17.691121,11.335168,-12.469345,-16.884556,11.818124,-10.752016,-17.442887,11.949411,-12.621094,-16.598442,12.893968,-9.759847,-17.101188,12.945936,-13.153871,-15.978119,13.109236,-10.201418,-16.967187,14.042924,-12.213412,-16.075872,14.172729,-11.169477,-17.241374,4.860976,-9.611272,-17.046819,5.054280,-9.525364,-17.092904,6.355803,-9.487959,-17.113457,6.395166,-8.617130,-17.185147,6.415915,-6.841283,-16.856916,6.653313,-7.421841,-17.150760,6.841415,-4.977658,-16.285750,6.901267,-9.346907,-17.323550,7.061890,-6.830530,-17.014335,7.205833,-2.449841,-15.600701,7.327108,-7.917573,-17.219321,7.370145,-2.687698,-15.654639,7.773970,-4.426071,-16.364599,7.943160,-5.206244,-16.623905,8.165003,-8.389515,-16.862512,9.281726,-3.619701,-16.283286,9.561208,-7.086284,-16.901594,9.627278,-4.678783,-16.214498,9.907989,0.005683,-15.691947,10.302502,-8.422130,-17.472772,10.647880,-4.453856,-16.527136,10.816352,-5.257815,-17.197961,10.879763,-3.863129,-16.378097,10.983033,-8.789822,-17.755926,11.430416,-3.115773,-16.413299,11.512394,-7.831688,-17.907843,11.536283,-1.710563,-16.177376,11.664611,0.561111,-15.585869,11.721270,-8.941315,-17.800645,11.831747,-6.205968,-17.730720,12.168806,-5.859959,-17.560130,12.280444,0.345661,-15.725135,12.389533,-5.593680,-17.502441,12.397752,-0.133265,-16.016135,12.700329,-3.952723,-17.189806,12.807894,-1.626579,-16.603150,13.266332,-5.502364,-17.899261,13.439419,-1.070153,-16.944023,13.629056,-4.552399,-18.089777,13.632520,0.614395,-16.140993,13.686532,-2.596386,-17.557909,13.774720,0.291278,-16.347699,13.794401,-2.197999,-17.528435,13.816925,-2.894231,-17.690705,13.838324,-8.306998,-18.310592,13.875013,-3.786876,-18.134356,13.960685,-3.393368,-18.057101,14.232653,-3.313036,-18.312555,5.137783,9.632005,-15.738617,7.508106,8.635867,-15.707256,9.709110,8.686513,-15.983206,10.043810,9.271520,-16.460733,10.243675,8.613288,-15.878390,13.755510,9.729286,-15.656327,3.965838,18.318230,-19.922512,4.394861,11.495993,-16.604253,4.552709,14.130509,-18.249227,5.263569,15.884352,-19.406079,5.398034,17.888594,-20.235079,5.433515,15.539712,-19.298702,5.852618,17.518725,-20.239395,6.509813,18.030734,-20.589230,7.343365,17.534866,-20.605467,8.959079,16.557087,-20.567017,10.018556,20.038991,-21.354315,10.045933,15.844894,-20.500349,10.238609,19.810173,-21.312255,12.023418,18.381491,-20.925171,12.025620,17.510179,-20.864058,12.366688,11.581062,-18.463995,12.506924,17.136694,-20.819043,12.932687,13.758965,-19.836402,13.494289,21.241916,-20.870034,4.777555,27.116288,-22.484901,5.540394,27.285125,-22.630526,5.727451,31.018517,-23.200749,5.738488,25.802946,-22.611256,5.779206,30.576486,-22.947667,5.920422,31.167835,-23.375238,6.360619,29.551894,-22.750812,7.024485,24.429967,-22.635997};
			return value;
		}
		private double[] getCoordinate_9_21_point_115()
		{
			double[] value = {7.668448,30.713902,-23.136888,9.161784,31.194294,-24.842032,9.288294,28.261101,-22.642147,9.359438,30.684286,-23.710691,9.493617,30.248388,-23.166631,9.649905,27.146698,-22.592639,10.255375,31.482968,-25.346823,10.269143,30.223116,-23.410839,10.273273,32.008348,-25.558843,10.389426,30.890288,-24.925337,10.420171,27.946873,-22.770439,10.475163,30.802015,-24.101049,10.510282,28.126009,-22.842476,10.726754,29.718779,-23.494664,10.783901,27.644060,-22.810465,10.979683,26.319261,-22.585713,11.099127,29.887094,-23.616154,11.398453,31.290956,-25.625541,11.624525,30.204025,-23.595906,12.038164,27.915273,-23.498162,12.555151,31.041196,-23.698888,12.611125,24.537482,-22.086413,12.860420,30.456667,-23.518217,12.962959,29.731940,-23.449172,13.007562,28.401777,-23.941960,13.067948,30.004537,-23.385615,13.392134,31.827965,-24.375843,13.681547,25.230506,-22.605537,13.813554,26.903800,-23.834240,14.265874,25.376358,-22.793132,6.677169,32.131245,-25.727454,13.985706,32.094676,-24.815255,4.836084,84.169009,-22.818897,6.663778,83.530792,-23.714073,6.870448,83.001756,-24.079581,8.441503,80.506675,-25.737966,8.939497,81.591228,-25.457431,9.011579,80.246293,-25.855730,9.229164,80.598313,-25.830417,9.319746,83.387925,-24.853906,12.339499,84.044197,-25.694095,13.376029,83.915244,-24.979251,13.790373,83.920374,-25.094767,3.848289,89.158993,-18.798131,4.376865,91.585753,-16.351005,6.173048,86.485922,-21.505904,6.400180,90.382397,-19.103664,6.570730,89.510004,-19.256623,6.732702,91.729369,-18.648122,6.772579,90.756954,-19.055122,7.279458,94.730046,-16.092194,7.449204,94.086450,-16.844326,7.544882,88.813902,-20.265500,7.718988,84.510927,-23.753411,7.816683,90.403181,-18.880505,7.879917,86.548901,-22.016417,7.935972,89.749324,-19.249171,7.969772,85.858714,-22.922617,8.092457,89.181423,-20.156062,8.106196,94.389797,-16.522715,8.545657,90.048797,-18.993923,8.659772,92.765393,-18.013900,8.867666,89.972880,-19.228498,9.045839,91.852572,-18.190147,9.455863,89.649714,-20.026473,9.617919,93.672221,-17.147246,9.709605,91.071080,-18.120681,9.924194,93.921414,-16.848256,9.927745,93.175800,-17.519651,9.973744,84.838035,-24.797683,10.080269,86.455313,-23.514279,10.101378,92.870703,-17.408757,10.132767,86.204488,-23.819258,10.342790,91.625832,-17.637683,10.634920,87.788699,-22.361466,10.771356,94.564128,-16.192685,10.892473,92.546311,-16.947965,11.059115,88.285191,-21.874375,11.168842,87.127033,-23.140828,11.204829,87.391295,-22.796083,11.575326,88.508948,-21.731201,11.583250,87.668302,-22.441335,11.760129,87.070404,-22.808662,11.764595,93.406020,-15.855806,12.025187,91.716121,-17.982571,12.280789,93.260842,-15.755589,12.380733,91.894386,-17.892164,12.583603,85.802064,-23.687819,12.596327,92.397138,-17.295310,12.677965,87.333822,-22.315718,12.708520,84.839978,-24.494098,12.840654,91.927050,-17.773921,12.890716,89.258392,-20.440887,13.144799,92.966278,-16.416631,13.217220,87.659847,-22.343196,13.425699,88.628020,-21.251789,13.701582,86.490975,-23.609351,14.046811,89.394907,-20.406888,9.240262,94.912860,-15.694467,4.242499,-72.875258,-11.225592};
			return value;
		}
		private double[] getCoordinate_9_21_point_116()
		{
			double[] value = {4.590996,-75.345597,-5.952193,4.612792,-73.303104,-10.458183,4.845752,-74.064851,-8.926617,5.741631,-72.657476,-10.860883,8.401375,-75.071727,-5.492005,8.461487,-73.284028,-8.737793,9.449306,-74.508401,-6.371300,10.198056,-74.442952,-6.262329,11.635010,-73.076557,-7.543714,4.082791,-62.026558,-5.528836,4.203164,-66.265518,-12.919760,4.508889,-63.748739,-12.280784,4.627072,-64.278264,-12.316041,4.935443,-71.308699,-12.082596,5.409660,-68.592791,-12.314887,5.598347,-68.663399,-12.229657,6.093822,-63.099235,-5.709375,6.258402,-72.033815,-11.124067,6.318351,-64.909437,-11.508965,7.750263,-67.894139,-11.087160,7.879297,-67.012026,-10.954500,8.274037,-63.900007,-10.101449,8.500329,-67.412362,-10.739947,8.999128,-68.394368,-10.415758,9.036949,-63.706141,-9.481691,9.147699,-66.359558,-10.213317,9.247388,-64.925600,-9.872561,9.343137,-63.752492,-9.260777,9.670174,-63.330706,-8.117185,9.898045,-63.463845,-8.166862,9.989866,-63.448259,-6.078365,10.420488,-65.798242,-9.360009,10.896952,-63.714899,-5.195201,10.999806,-63.705400,-7.279654,11.103356,-67.145561,-9.149838,11.303393,-63.896356,-7.437683,11.705114,-64.667749,-8.147710,12.155810,-72.135812,-8.025480,4.048762,-61.443203,-5.358099,4.071093,-61.315644,-5.362181,4.126533,-61.491333,-11.175632,4.352434,-61.084454,-5.210220,4.470924,-61.326905,-10.501450,4.479587,-61.771307,-8.271372,6.005749,-61.937149,-9.329988,11.446433,-43.160382,-5.423579,11.751784,-41.235697,-6.139513,11.791185,-42.457472,-5.520434,12.098745,-41.974173,-5.760185,13.229926,-42.350102,-5.596218,13.464910,-41.682324,-5.701998,4.137600,-35.556340,-6.122068,4.173701,-35.940713,-6.187560,4.353348,-38.040321,-5.387963,4.418954,-32.631124,-6.719393,4.729811,-32.191700,-7.182380,4.749671,-32.481260,-7.290528,4.894502,-35.770345,-6.745146,4.945141,-31.194386,-7.427476,5.140084,-30.721528,-7.531849,5.260804,-34.594716,-7.197094,5.716386,-33.795055,-7.535864,5.732314,-31.460555,-8.352654,6.007583,-37.787586,-6.279790,6.192488,-39.134809,-5.567996,6.205498,-31.660537,-8.387737,6.306226,-30.822913,-8.576886,6.538243,-31.347359,-8.362262,7.015882,-34.314787,-6.854824,7.037079,-33.457013,-7.184816,7.468379,-33.227937,-7.442087,7.559588,-32.498512,-7.659386,7.674863,-35.979109,-6.460276,7.708029,-37.772934,-5.328915,7.960454,-37.022738,-5.914137,8.160083,-33.231714,-8.137588,8.192843,-36.801702,-6.182535,8.249792,-36.286456,-6.450265,8.341971,-36.383826,-6.449766,8.405437,-38.259393,-5.543109,8.517001,-34.468764,-7.656866,9.264718,-31.062648,-8.933285,9.276320,-39.904767,-5.942079,9.376468,-35.217980,-7.254128,9.696576,-39.426252,-6.266795,9.879906,-32.180184,-8.953334,9.886261,-30.945656,-9.548699,10.533308,-34.029809,-7.992727,10.786045,-40.566279,-6.256051,11.124791,-35.233701,-8.385756,11.183212,-35.729151,-8.388131,11.393263,-31.090086,-9.346937,11.715089,-34.957071,-9.135025,11.752423,-32.591725,-8.900291,11.850761,-40.611347,-6.955802,12.015652,-35.965829,-8.886571,12.038400,-31.209782,-9.273033,12.438031,-39.672956,-7.586261,12.520024,-36.502618,-8.728576,12.569776,-32.935383,-9.733585};
			return value;
		}
		private double[] getCoordinate_9_21_point_117()
		{
			double[] value = {12.771300,-32.812274,-9.770636,12.783313,-34.676645,-9.275193,12.821291,-36.493202,-8.720493,12.911055,-37.922206,-8.285581,12.980446,-32.597938,-9.821430,13.014715,-37.747026,-8.383725,13.141972,-37.237023,-8.618202,13.434233,-40.465277,-6.707912,13.472064,-34.855474,-9.259396,13.473715,-37.677264,-8.699207,13.655615,-31.530790,-10.204472,13.661057,-38.913203,-7.818575,13.692930,-39.036709,-7.657714,14.033954,-37.595482,-8.882734,14.182707,-34.272383,-9.677589,3.922051,-29.845344,-7.198813,3.976759,-26.586941,-9.965717,4.045994,-28.267359,-8.502224,4.515731,-24.840241,-12.224275,4.538396,-28.613993,-7.934098,4.547565,-28.165278,-8.310188,4.568094,-27.306860,-8.968626,4.714231,-29.590369,-7.359423,4.732316,-28.589729,-7.896584,4.828549,-23.232288,-13.318467,5.114107,-21.527583,-13.816662,5.115817,-23.777423,-12.811480,5.189000,-21.796703,-13.706721,5.201079,-22.117340,-13.509217,5.254305,-25.129425,-10.658200,5.487823,-24.548322,-11.113395,5.624719,-24.441158,-10.807314,5.674378,-22.929356,-12.435999,6.172479,-29.924754,-8.573214,6.278428,-21.179933,-12.257699,6.295112,-29.439287,-8.617667,6.337896,-20.635134,-12.977498,6.391439,-26.203937,-9.730016,6.412525,-30.535973,-8.621074,6.482338,-20.991965,-12.256340,6.554599,-21.551246,-11.199483,6.750731,-26.045548,-9.893153,6.826369,-28.413607,-8.973045,6.853062,-23.450924,-10.677865,6.876531,-20.955020,-11.608043,6.907569,-21.443331,-11.050587,7.104815,-21.001245,-11.250604,7.233658,-30.312355,-8.604947,7.270635,-29.068561,-8.775884,7.633534,-21.421515,-10.974799,8.010426,-30.217231,-8.356014,8.133553,-27.365734,-9.787164,8.204238,-21.371614,-10.930548,8.381676,-21.092713,-10.959052,8.758344,-22.093692,-10.451184,8.759516,-29.505146,-8.679713,8.833163,-28.879756,-8.913871,9.041325,-27.302613,-9.272635,9.176368,-23.849403,-10.906539,9.512027,-30.106803,-9.092967,9.536090,-23.171598,-10.922580,9.541181,-21.165805,-10.708626,9.710395,-26.838297,-9.453095,9.844527,-29.761484,-9.340834,9.988110,-24.178016,-11.471761,10.056721,-30.053820,-9.555061,10.121089,-28.118420,-9.440427,10.122626,-29.316646,-9.515849,10.342935,-24.668370,-11.339738,10.526198,-30.238865,-9.887453,10.545554,-24.800185,-11.083466,10.622820,-24.155654,-11.354926,10.773272,-20.825807,-11.001644,11.029112,-28.752247,-10.247697,11.114317,-22.752937,-11.163251,11.340227,-22.822721,-11.126501,11.390068,-24.963100,-9.943115,11.612398,-22.976253,-10.978742,11.623708,-26.589023,-10.087457,12.189670,-24.203898,-10.110794,12.346653,-27.490107,-10.771012,12.501589,-22.700154,-10.167092,12.698394,-29.935491,-10.024726,12.751565,-21.742081,-10.080599,12.837863,-28.690066,-10.187133,12.991965,-20.779754,-10.206920,13.063142,-29.505874,-10.250712,13.126800,-23.971184,-10.478603,13.259641,-29.467769,-10.356464,13.283497,-25.535756,-10.779634,13.415367,-22.249534,-10.079128,13.540990,-24.744630,-10.739939,13.550187,-28.330561,-10.270807,13.714529,-27.008846,-10.356584,14.197237,-25.170795,-10.579345,14.269847,-25.345077,-10.512676,3.829048,-9.972431,-15.354213,4.995545,-18.589219,-15.206758,5.794693,-19.733664,-13.839435,6.651507,-18.921270,-14.525650};
			return value;
		}
		private double[] getCoordinate_9_21_point_118()
		{
			double[] value = {6.964857,-18.921297,-14.408505,7.441253,-19.781236,-12.323081,7.882639,-18.938879,-13.529224,8.662745,-18.974469,-12.601180,9.066212,-18.193264,-15.227439,9.347633,-16.176038,-15.367279,9.425149,-18.822541,-14.084551,9.607684,-19.978241,-11.058543,9.721681,-19.743425,-11.135866,9.740334,-18.412459,-14.103672,9.786324,-18.458546,-13.985556,10.276843,-17.584176,-13.749857,10.501060,-16.064857,-14.536431,11.200633,-18.329501,-11.355419,11.304343,-16.777969,-13.750477,11.825971,-15.059074,-15.375237,11.925980,-15.595837,-14.217331,11.991679,-16.948255,-11.358758,12.329056,-16.089471,-11.877535,12.461894,-14.230296,-14.863039,12.597696,-15.713751,-12.703533,12.636730,-15.341835,-13.519058,12.721108,-19.676520,-10.532680,12.855876,-15.324895,-13.252326,13.009041,-15.243389,-13.177690,13.125013,-19.430350,-10.320364,13.201295,-18.179836,-10.342826,13.205173,-16.199018,-10.727198,13.376440,-16.159038,-10.479583,13.435092,-16.622128,-10.313623,13.502712,-16.619291,-10.267257,13.549897,-12.782896,-15.338447,13.670727,-19.779160,-9.780911,13.685503,-19.860413,-9.808102,13.962800,-17.181288,-9.986492,14.052566,-14.451545,-10.812476,14.156498,-18.605825,-9.671664,3.837530,-2.298288,-11.275672,3.845065,-8.991842,-15.005952,3.852534,-5.114401,-14.657562,3.960037,-0.332254,-11.630671,3.964268,-1.279514,-11.562565,3.966268,-0.116213,-11.553001,4.006784,-9.194538,-15.163661,4.018191,-3.120984,-12.803018,4.053375,0.555103,-10.712552,4.065889,-3.570362,-13.717411,4.323136,-2.159606,-11.601539,4.345424,-1.798049,-11.612899,4.730457,-2.459527,-13.808629,4.814345,-2.376980,-13.890033,5.080046,-6.189935,-14.735515,5.150050,-2.699061,-14.250814,5.326795,-6.372810,-15.433851,5.413576,0.198137,-12.327749,5.626383,-0.796018,-13.012952,5.884793,0.361880,-12.462761,5.903373,-3.872941,-14.746386,6.102042,-2.761798,-14.425979,6.323487,-2.486565,-14.436614,6.555780,0.373470,-13.162324,6.671642,0.498861,-13.675019,7.524093,-0.153521,-14.457196,7.568196,0.149679,-14.410430,7.858570,-0.587916,-15.066683,7.971440,-0.715855,-15.302639,8.452659,-0.452805,-15.430478,8.540835,-0.457382,-15.467389,4.859871,1.838203,-11.475907,4.886183,5.707211,-12.775598,4.913113,3.415333,-11.611381,5.341319,2.987193,-11.931751,6.088886,0.919607,-12.580407,6.092597,4.787447,-12.765359,6.202303,1.620909,-12.694797,6.469699,2.625296,-12.709063,6.518702,4.571950,-12.873241,6.732186,0.897149,-13.071583,6.777130,1.168036,-12.983570,7.494755,2.198292,-13.433844,7.530884,1.591630,-13.764274,7.663702,2.802320,-13.397246,8.342176,3.040115,-13.797964,8.406597,3.539899,-13.755443,8.662369,5.072603,-13.944876,8.755284,0.945442,-14.673881,9.262654,3.561428,-14.083650,9.635788,7.022788,-14.800967,10.960840,2.719263,-14.630047,11.022145,3.004895,-14.552606,11.160284,6.716762,-14.618648,11.303824,5.184538,-14.429667,11.326800,7.622317,-14.923577,11.712373,2.135378,-15.190371,11.780848,4.897759,-14.437061,13.051135,2.072872,-15.430473,13.328666,3.622834,-14.966877,4.502227,93.506025,-13.920466,12.633972,94.606935,-14.214226,12.826451,93.779357,-15.054027};
			return value;
		}
		private double[] getCoordinate_9_21_point_119()
		{
			double[] value = {13.171290,93.736801,-15.217897,14.065412,93.549840,-15.388063,3.996276,95.184231,-12.961982,4.265213,95.309658,-12.304317,4.435462,96.126876,-10.245404,4.459274,97.035299,-7.139787,4.517446,97.115160,-6.880447,4.714888,97.356028,-6.336770,4.792000,95.722984,-10.175868,5.023845,98.434555,-6.028188,5.323216,94.828427,-11.337905,5.423652,94.897970,-11.139892,5.494794,95.878455,-8.775394,5.498053,95.410162,-9.733832,6.010666,98.395444,-6.899495,6.267467,96.108989,-9.201656,6.344937,95.203899,-11.806624,6.348060,95.297489,-11.252772,6.377396,98.686567,-6.796824,6.387510,95.127366,-12.232967,6.514865,97.449466,-8.308737,6.617911,95.469834,-11.944259,6.625116,95.642493,-11.052741,6.648302,96.603980,-9.397996,6.747794,95.306250,-13.307331,6.867777,98.194386,-7.810950,6.947238,98.204000,-7.868635,7.114568,96.316317,-11.202935,7.313458,95.860876,-14.091826,7.706851,99.112723,-6.820889,7.819724,98.943523,-7.243555,8.049302,96.459643,-13.925625,8.202718,97.470583,-11.625103,8.238254,98.696060,-8.316587,8.275971,95.772333,-15.045922,8.281619,96.680208,-13.633196,8.400361,96.439281,-14.070254,9.239643,96.382855,-14.052185,9.471949,97.172244,-12.805582,9.516558,96.717903,-13.581590,9.626334,97.321202,-12.570473,9.667529,97.751349,-11.709431,9.766647,96.775047,-13.412245,9.769485,97.381261,-12.443452,9.781893,95.371397,-15.155639,9.814811,97.176327,-12.782413,10.138349,99.400320,-7.180898,10.190090,96.431973,-13.623879,10.430010,96.754242,-13.036063,10.618197,100.295625,-5.499784,10.905799,99.121428,-8.305350,11.094396,99.027227,-8.708739,11.122687,98.058722,-10.669103,11.314769,98.745730,-9.410948,11.517673,96.101614,-14.285408,11.645050,97.465275,-12.105488,11.783617,97.671441,-11.507324,11.796868,96.349194,-13.694081,11.910430,98.872270,-8.252364,12.120122,98.590404,-8.592010,12.341018,98.826586,-6.890854,12.355702,96.740259,-12.456298,12.488188,98.065928,-9.050544,12.607559,95.608589,-13.481433,12.790716,99.741198,-5.193360,12.864462,94.920783,-13.710053,12.954191,95.779979,-12.677190,12.993277,97.970109,-8.304191,13.179031,97.985289,-8.233348,13.224306,97.313079,-9.525777,13.283451,97.061486,-10.034960,13.500717,96.046759,-11.804495,13.892334,96.529932,-10.836246,4.062691,-108.983055,4.172630,4.346843,-109.177156,3.812983,4.432309,-110.282662,3.680011,4.668973,-112.687172,4.492467,4.700631,-110.033895,3.761978,4.844685,-112.708113,4.579621,5.134747,-110.477067,4.563861,5.347109,-111.780705,4.836997,4.430243,-76.604757,-1.113931,4.432385,-75.878428,-4.223453,5.197752,-77.570034,4.886754,5.583023,-77.247711,3.220651,6.185116,-75.489715,-5.004133,7.023230,-76.034063,-2.975298,7.130897,-76.668893,0.453215,7.863519,-76.845322,1.655343,9.062411,-76.544491,-0.019210,11.566929,-76.403185,-0.308642,11.751837,-75.913535,-2.469142,13.124016,-75.949898,-2.035344,14.052336,-76.070591,-1.326922,6.536105,-63.007455,-4.665180,7.280119,-63.314113,-4.578176,7.791875,-63.421026,-4.828687,8.313237,-63.015379,-3.511467,9.406688,-63.048298,-2.980356,9.458521,-63.820609,-4.603496};
			return value;
		}
		private double[] getCoordinate_9_21_point_120()
		{
			double[] value = {9.803138,-63.765667,-3.139510,10.580333,-63.742853,-2.580454,10.833914,-63.134443,-2.262699,11.209290,-63.997863,-2.451334,11.968396,-62.850685,-1.523962,12.837086,-64.014940,-1.329961,3.848803,-54.429426,4.525783,3.859399,-56.271312,-3.026242,3.954350,-54.706756,-2.091967,4.037702,-52.395655,-0.312375,4.664726,-56.858102,-2.873456,4.677390,-58.780096,-4.310402,4.679807,-52.572305,1.806346,4.690274,-53.007082,-0.472817,4.759895,-52.363116,0.899832,4.870568,-59.009696,-4.306881,4.984547,-54.499957,4.157653,5.453499,-59.025024,-3.921412,5.473662,-54.273819,3.799261,5.663252,-57.263132,-2.643227,6.052135,-55.856957,-1.702766,6.256468,-55.304695,4.823116,6.421138,-53.286038,0.603280,6.767792,-54.437841,3.767452,7.170914,-54.838181,-0.305576,7.479004,-54.931292,-0.180614,8.011027,-53.796403,1.866482,8.346704,-58.679164,-1.969512,8.357400,-59.538527,-2.405279,8.745635,-54.208317,1.519123,9.020668,-61.904301,-2.921976,9.367260,-54.653503,3.106514,10.136398,-55.997881,0.725073,10.147849,-55.022559,1.570448,10.391212,-55.054272,1.744728,10.512710,-55.183095,1.659200,13.125136,-56.218297,2.723164,13.178988,-56.637161,4.886397,13.706812,-56.453823,4.097502,14.168756,-58.699167,1.572344,4.730977,-41.657180,-2.683526,4.736239,-45.418631,1.542680,4.737959,-47.081089,4.334065,4.764312,-42.359695,-2.054786,4.796629,-44.117296,-0.157919,4.813058,-45.070301,1.054882,4.866493,-42.173856,-2.428595,4.885661,-48.073017,4.875756,4.996283,-47.886105,4.487252,5.144946,-41.805613,-3.109343,5.192195,-44.166833,-0.536060,5.338588,-44.764955,0.079243,5.382396,-41.323546,-3.621784,5.468312,-42.764050,-2.877715,6.008983,-41.246006,-4.476547,6.148158,-43.350700,-2.804827,6.453822,-46.482335,0.568484,6.803915,-47.678589,3.236008,7.023674,-44.547312,-1.625462,7.154662,-48.101902,4.020164,7.161186,-44.984201,-1.250197,7.405506,-43.823372,-1.605257,7.584773,-49.228786,4.878967,7.701406,-47.320536,1.591418,7.965655,-43.407817,-1.440499,8.059766,-41.247526,-3.275319,8.080895,-44.136644,-0.841502,8.862620,-48.216890,3.535276,9.075888,-41.240552,-4.229651,9.193834,-43.306660,-1.964035,9.279670,-48.403674,4.659643,9.594162,-44.703221,-0.658689,9.614094,-46.339528,1.474791,9.802047,-46.379436,1.541757,10.421098,-46.140703,0.459770,10.435221,-46.031905,-0.184396,10.476305,-46.501061,1.531915,10.523675,-43.567641,-4.416875,10.534732,-45.298906,-1.667350,10.568224,-46.006407,-1.088302,10.604770,-47.787718,4.084577,10.628941,-47.851546,4.168947,10.999022,-49.640412,4.983233,11.030869,-48.397365,4.313304,11.262495,-44.348880,-4.438912,11.484482,-45.097965,-3.448132,11.920469,-48.220143,1.910445,12.101063,-46.273488,-0.710937,12.143435,-46.065189,-1.762386,12.224459,-43.066276,-5.131913,12.427055,-47.579763,0.982239,12.639784,-44.069278,-4.416818,12.661612,-43.020783,-5.126034,12.860164,-45.637086,-2.679154,13.176593,-48.506007,2.615006,13.325644,-46.224621,-1.698592,13.459018,-43.036135,-4.976519,13.850417,-43.617847,-3.483181,13.871584,-49.716701,4.363440,13.958889,-43.638211,-3.105429};
			return value;
		}
		private double[] getCoordinate_9_21_point_121()
		{
			double[] value = {14.024943,-46.608896,-0.688357,14.066274,-44.897963,-1.433305,14.087780,-44.167796,-2.108978,14.135137,-49.437674,4.090381,14.173654,-49.387256,4.019080,14.178814,-47.149197,0.403410,14.258437,-49.462011,4.811685,4.054501,-39.804946,-3.302116,4.131700,-39.588997,-3.640480,4.352257,-38.768797,-4.597639,5.279985,-39.967305,-5.034657,7.923213,-39.437289,-4.458920,9.082509,-41.029593,-4.503111,4.017296,98.467432,-4.931544,4.294145,98.926056,-5.103709,4.721901,100.712289,-2.188598,4.962452,100.739019,-2.193123,6.840771,103.156632,3.269377,7.834440,100.209553,-5.081944,8.313911,101.052937,-2.787198,8.380710,101.018959,-2.881908,9.846426,102.878429,2.174345,10.281248,102.270250,0.460125,10.712082,101.030537,-3.516641,10.951863,103.092291,3.631492,11.225737,101.652216,-0.819905,11.729284,100.508949,-4.208731,11.765381,102.100959,0.005190,12.523621,100.212181,-4.069280,12.637820,101.838666,1.192435,12.706015,99.862677,-4.998681,13.445350,101.270219,-0.048593,13.739882,100.714086,-3.187399,14.132200,102.068449,1.085297,14.256608,100.708678,-3.090945,3.870567,-142.687451,11.173083,4.282947,-143.733056,11.888504,5.027078,-136.921157,12.780333,5.786664,-139.438916,13.615548,6.814678,-140.171087,13.840249,6.944267,-143.273988,14.720521,7.984787,-140.653648,14.548321,8.151436,-141.356631,14.706979,5.144669,-132.891330,11.945110,6.859759,-130.646951,12.863656,7.272611,-131.807053,13.548256,7.299202,-130.193102,13.131404,9.346885,-131.301402,15.277185,3.888823,-115.769871,5.674817,4.405292,-117.313711,6.549621,4.533258,-116.605620,5.329067,4.572118,-117.241446,5.889791,4.954155,-117.194136,6.549515,4.973854,-117.155271,6.050180,5.138115,-117.126066,6.970819,5.294108,-116.294271,5.875256,5.487505,-121.709010,8.984344,5.746971,-117.178205,7.873962,7.114887,-120.073492,9.844546,7.959677,-123.921391,11.804866,8.036169,-117.953650,10.004000,8.750394,-115.209433,8.290865,8.868554,-114.688992,8.684853,9.016179,-114.822625,9.345327,9.139463,-117.074924,10.662526,9.784942,-115.509046,9.289285,9.951592,-123.492061,13.420522,10.119995,-120.128800,12.448379,10.848655,-116.292830,10.494966,10.933123,-115.776820,10.299102,11.011452,-115.335981,10.239568,11.171244,-114.935151,10.355527,11.496941,-116.184157,11.076643,11.731555,-114.431247,10.546721,11.827946,-114.464001,12.050995,12.211559,-123.682703,15.580098,13.594412,-118.374803,15.046479,13.753593,-119.019159,15.403123,3.951600,-114.133230,5.660202,5.704498,-105.114018,5.402293,5.769738,-109.052554,5.788797,5.795425,-109.161877,5.633803,5.829662,-108.469124,5.984783,5.873053,-112.199887,6.561868,5.931974,-104.928433,5.549331,5.938315,-114.151754,6.212604,5.963626,-113.627309,5.720261,6.009615,-111.122612,6.524961,6.014053,-112.622821,5.924563,6.020237,-111.179192,5.582761,6.147492,-110.421353,6.553610,6.827663,-110.887682,7.184779,7.497625,-110.340887,7.172237,7.604078,-109.269235,7.443619,7.782373,-107.431713,7.333900,8.299507,-113.291235,7.390793,8.362049,-107.859207,7.867297,8.408680,-112.514843,7.290816,8.474295,-112.977659,8.400231,8.488524,-108.647288,7.760795};
			return value;
		}
		private double[] getCoordinate_9_21_point_122()
		{
			double[] value = {8.492371,-109.659813,7.013374,8.592774,-112.341962,7.495322,8.596679,-113.943574,8.342614,8.833483,-112.207553,9.040795,8.964287,-107.149421,8.230201,8.986755,-108.065064,8.302834,9.207529,-113.642130,9.842366,9.306345,-107.956591,8.523673,9.607255,-106.563624,8.657732,9.680109,-109.835915,7.835525,9.773600,-108.919376,7.566048,9.920757,-109.669942,7.972619,10.097156,-109.194039,7.807999,10.252535,-109.961251,9.529825,10.414700,-111.203424,10.001136,10.651986,-111.584195,10.000855,10.838963,-108.174095,8.871629,10.863559,-112.574256,10.131944,10.964304,-107.825587,9.667025,11.187496,-107.654687,10.017962,11.370584,-107.724018,10.105184,11.652235,-108.195793,9.316150,11.762713,-107.939052,10.026328,11.837353,-109.818466,9.419784,11.868163,-113.805873,11.875522,11.937146,-111.071568,10.978443,12.122683,-111.404577,10.256312,12.168199,-109.245170,9.663902,12.184875,-110.012536,9.932323,12.518045,-107.568898,11.208245,4.117284,-100.557641,9.607517,4.153075,-97.512687,12.565568,4.841655,-98.094026,12.646253,5.157478,-103.680388,5.242091,5.461186,-103.155987,6.277093,5.629946,-103.628540,5.585366,6.567188,-99.659141,12.279412,6.979283,-103.580666,6.445594,7.996766,-103.656210,7.102409,8.630757,-103.667122,7.571624,9.495751,-102.968545,8.714983,9.844780,-102.857146,9.073291,9.955667,-100.522829,13.329669,9.965584,-101.775099,11.256756,10.589025,-100.869048,13.209435,11.120563,-102.891605,9.751876,11.330163,-103.057668,9.752156,11.797342,-103.016770,10.093126,12.504596,-100.940541,14.245994,12.655680,-102.326780,11.504552,12.768561,-102.391318,11.451899,13.963017,-102.368223,12.138415,14.035127,-101.391034,14.156999,4.305411,-86.246373,13.171381,4.332103,-92.567102,14.301461,4.778933,-91.829956,14.679197,5.168971,-87.797230,14.464981,6.167428,-83.882267,13.586579,7.620789,-84.705934,15.141182,4.098465,-79.841044,8.959055,4.264928,-79.452223,8.626436,4.976893,-80.282688,10.153777,5.341971,-80.001165,10.041317,5.850308,-78.305283,7.905212,5.870973,-78.507040,8.354464,5.955285,-81.597770,11.973524,6.322147,-78.639036,8.838109,6.489869,-78.946000,9.594730,6.500131,-80.820269,11.692215,7.208668,-82.118461,13.241668,7.904928,-81.257720,13.092564,7.914342,-79.379037,11.147210,8.163667,-78.036917,8.485972,8.702005,-78.072877,8.920364,9.003271,-79.623881,12.156230,9.762146,-81.705162,14.872583,9.995918,-77.562700,7.348388,10.714908,-78.192114,10.322586,10.746694,-79.808772,13.511152,12.190526,-80.512756,15.442333,12.475579,-78.009472,10.203576,13.784725,-78.326007,11.962812,13.842292,-79.257267,14.574185,13.906304,-78.347715,12.135211,13.929254,-79.347263,14.810229,14.188024,-79.536668,15.327240,4.012162,-53.816015,7.501553,4.077861,-51.653960,8.231462,4.395391,-54.850849,6.924705,4.647217,-55.117147,5.705720,4.763735,-55.250690,5.846980,5.270758,-53.217699,8.854720,6.307830,-54.989344,8.695927,6.381762,-51.853997,9.645225,6.401703,-54.067452,9.033848,7.007617,-55.082304,9.057201,7.669862,-56.419658,6.167626,7.717669,-51.841896,9.494743,7.733808,-54.132453,10.025085,7.896143,-53.365429,10.189781};
			return value;
		}
		private double[] getCoordinate_9_21_point_123()
		{
			double[] value = {8.125844,-56.281108,7.922170,8.214386,-53.429856,10.292546,8.341076,-55.860817,8.854576,8.766410,-54.261995,10.744938,8.869028,-53.959427,10.859812,8.917751,-53.339208,10.577323,8.947282,-56.525942,8.855966,9.544415,-54.641488,10.906686,9.593428,-55.417657,10.573893,9.677645,-55.989635,10.244935,9.682049,-55.418447,10.599789,9.737995,-53.703000,11.256265,9.783460,-56.506968,9.431306,9.891262,-52.993507,11.090714,9.935550,-54.191507,11.435533,9.982513,-52.472681,10.075565,10.109255,-52.945895,11.264418,10.201520,-56.913418,9.000026,10.272248,-54.747523,11.333152,10.460292,-56.441932,10.290371,11.037638,-53.599910,11.899872,11.148631,-57.914234,8.944652,11.311732,-57.937424,7.134541,11.322066,-52.736396,11.741278,11.331926,-57.345717,9.592583,11.510867,-52.734898,11.751067,12.017059,-52.125761,11.398701,12.038820,-58.473372,8.354080,12.422479,-53.948307,12.263331,12.579293,-56.124127,12.080701,12.845942,-55.474291,12.486622,12.851887,-57.848030,10.623243,13.114120,-54.795720,12.476309,13.152543,-52.998764,11.476682,13.231039,-53.329148,11.803271,13.908595,-57.490043,11.957126,13.914412,-53.657577,11.530224,14.003974,-56.636826,12.844356,14.246561,-58.572754,10.003749,14.254487,-57.412651,12.302889,5.012518,-48.734561,6.146924,5.841415,-49.772342,6.906401,6.390975,-51.186146,9.319896,6.434017,-48.232574,5.240983,6.717487,-50.388442,8.212167,7.238215,-51.372019,9.519961,7.364803,-50.605926,8.811025,8.620245,-51.448049,8.630891,9.265645,-50.718258,7.561525,9.329572,-50.424424,7.525908,9.354801,-50.205871,7.458813,10.146434,-49.581100,6.179642,12.003507,-50.733270,5.815023,12.212153,-51.159931,9.390019,12.620844,-50.861533,6.511171,12.743134,-50.682555,6.044472,13.236656,-50.466851,8.863466,13.256714,-51.281038,10.865918,3.961220,103.611306,6.034023,4.726968,104.704416,14.491163,4.904720,104.026937,8.071500,4.927362,103.991905,7.857745,7.748453,104.601736,11.678761,8.283661,104.625285,11.873243,9.759970,104.830811,14.462462,11.628915,104.563924,13.400389,12.103546,104.363881,11.289738,13.727116,104.319633,14.454239,4.277814,-141.407054,24.431901,4.295612,-141.701528,22.845958,4.373971,-142.559504,18.229414,4.711190,-141.282039,25.163941,6.224213,-142.317685,19.782067,9.040301,-142.068376,15.644884,9.339735,-140.390803,15.736281,9.376071,-142.972128,16.674366,10.560156,-140.225564,16.787314,10.567092,-142.546906,19.127249,10.574200,-142.898967,17.229716,10.873259,-139.745985,17.247179,10.876490,-141.756276,23.432783,10.990031,-141.542416,24.601449,11.334904,-142.308978,17.766030,12.196075,-142.378523,18.564232,13.282057,-141.694501,24.088262,13.322504,-141.246454,19.335305,13.344538,-142.184521,19.567818,13.938205,-138.663908,20.458013,12.243019,-132.874680,18.364550,13.743159,-127.953906,18.411572,14.082837,-122.860416,17.057400,6.382538,-93.600299,15.914081,7.016437,-93.796937,16.381289,7.946572,-97.004573,15.654639,9.148401,-94.603198,17.829593,11.071195,-98.530789,16.556521,12.076811,-96.564242,18.975360,14.033679,-97.031807,20.070664,5.764590,-89.256250,16.191569,5.904006,-89.044698,16.283861};
			return value;
		}
		private double[] getCoordinate_9_21_point_124()
		{
			double[] value = {6.583940,-89.324112,16.865014,6.850430,-88.902464,17.064802,7.178623,-90.893526,16.713117,7.634176,-88.379592,17.457639,7.789637,-88.668076,17.838269,8.019432,-87.781135,16.973394,8.308836,-90.626233,17.700793,8.759246,-88.705569,18.777539,8.967412,-87.089983,17.299994,9.037732,-87.144574,17.380902,9.336195,-89.695609,18.848950,9.587938,-90.338396,18.803697,10.075219,-87.203282,18.433049,10.188134,-88.300498,19.979508,10.280715,-88.763098,20.103049,10.783002,-92.459443,19.694636,11.563006,-88.093969,21.131974,11.702971,-86.844706,19.752314,12.503113,-87.872577,21.870580,12.739593,-87.296763,21.409927,12.742006,-88.392884,22.164269,13.185532,-83.068964,18.880919,13.267672,-89.781651,21.912355,13.375773,-89.573796,22.044105,13.444099,-87.266674,22.085257,13.961009,-82.926760,19.328184,14.234642,-83.726552,20.239971,10.175951,-82.612439,16.078588,5.750241,104.548347,23.366230,6.100735,104.381278,24.817885,6.298597,104.636263,21.922081,6.550120,104.705662,20.809216,6.825520,104.825498,19.562531,6.968264,104.281711,25.177009,7.006458,104.576953,22.436925,7.295344,104.610715,21.857947,8.776505,104.905321,17.726000,9.756392,104.145878,24.177797,10.666289,103.968615,24.240925,11.033510,103.621045,24.784421,12.740210,103.753632,23.011990,3.883998,-139.250826,36.007827,5.171946,-141.083618,26.295817,5.412567,-139.319826,35.840595,8.146150,-140.601388,29.295561,10.193901,-141.067109,27.057893,10.750606,-140.271830,31.421322,11.046077,-140.850790,28.338624,11.156638,-140.234027,31.679919,12.309577,-140.593805,29.894410,12.546925,-141.048372,27.474410,12.836626,-141.222221,26.575564,4.246069,101.211752,33.769859,5.060209,102.764927,31.076749,5.394606,100.632972,35.723096,5.659237,101.183019,34.743491,5.837965,103.035664,30.561023,6.206568,101.808629,33.483685,6.725931,103.969423,27.094081,6.906811,103.499644,28.974365,7.146504,103.754333,27.955145,7.381272,103.428909,29.156936,8.658037,103.068173,29.889420,8.662172,102.326825,32.090808,8.743708,102.327494,32.036093,8.752169,102.255167,32.251346,8.980633,102.361519,31.619894,9.281416,101.469409,33.889722,9.521024,102.152925,31.492159,9.620688,103.083951,28.154020,9.625223,101.564395,33.029217,9.731508,102.443258,30.472169,9.860324,103.349775,26.873538,9.861700,101.030690,34.665069,9.912862,103.600346,26.165855,10.039381,101.634097,32.804327,10.071839,100.992615,34.627976,10.171776,100.850403,35.000841,10.483846,101.513461,33.239786,10.722218,103.021314,28.731070,13.185008,100.210074,36.036694,13.429438,103.370027,26.837014,13.621383,102.337555,30.967732,13.665937,103.158761,27.488503,13.810315,102.712374,29.267370,13.973851,103.130934,27.228531,4.116918,-137.618807,44.840094,4.432891,-139.034682,37.246882,4.865063,-137.735861,44.309415,5.528534,-137.658166,44.817483,6.574549,-138.174210,42.174250,6.830704,-139.162397,36.879515,7.933352,-138.943325,38.208787,8.279609,-138.633888,39.923939,8.809095,-138.272790,41.942356,9.588308,-138.518903,40.719344,9.612407,-137.483514,46.306644,10.854986,-137.814640,44.687120,11.007877,-137.564633,46.055975,12.435435,-138.842611,39.355347};
			return value;
		}
		private double[] getCoordinate_9_21_point_125()
		{
			double[] value = {3.832836,94.514769,43.710078,4.008112,92.978676,45.526057,4.586626,92.541167,45.987977,7.354331,94.503311,43.828949,8.155908,93.740513,44.630059,9.593172,93.263987,45.137461,11.634720,92.854321,45.304716,12.392428,92.636186,45.416777,12.886800,92.635740,45.403078,13.167937,93.383640,44.583768,13.246069,94.481811,43.384346,4.725854,99.585891,37.404636,7.718908,99.469837,37.770979,8.484216,95.945986,42.276727,8.704850,98.415129,39.237301,8.950530,99.702137,37.348672,9.331270,96.103284,42.107145,9.597328,95.605877,42.628270,9.649957,96.757508,41.315440,9.892779,99.957113,36.684087,11.172194,96.762699,41.114111,11.836282,95.741602,42.184980,12.434414,96.772358,40.816639,12.574940,96.150739,41.456415,12.904711,95.243238,42.573777,12.994072,99.524452,36.854467,13.469494,97.884800,38.795746,5.379429,-135.521685,56.319588,6.469467,-135.461283,56.791679,6.916236,-136.425301,51.652249,12.091132,-136.770706,50.482661,12.132929,-137.300177,47.632942,12.366301,-137.430788,46.960148,13.057500,9.672778,55.963451,13.114479,4.668414,56.767101,13.487105,10.535142,55.228203,13.676528,2.832881,56.771326,13.683801,4.076086,56.211489,13.070061,17.588284,55.399663,14.139162,18.045672,54.551635,4.520966,80.715184,54.191695,4.756224,83.082676,52.672963,5.176284,79.134132,55.494097,5.523014,78.521320,56.071362,6.315687,79.355813,55.693191,6.910300,81.244139,54.276446,8.367320,80.618025,55.226228,9.073248,79.736274,56.062297,9.089509,81.455599,54.568239,9.181316,79.594891,56.199323,9.569340,78.932026,57.012312,9.914017,80.577759,55.589491,10.091876,79.790458,56.360938,10.735266,81.989068,54.288464,11.308059,78.593456,57.120914,11.721933,81.619509,54.538317,11.804915,78.857423,56.533137,11.870100,80.363782,55.260224,12.194768,80.859700,54.733820,12.389458,81.903812,53.816173,13.126386,82.990805,52.808922,13.813315,82.055243,53.622187,4.458605,87.024803,51.238212,4.823906,89.208669,50.140129,5.549971,87.816444,50.765780,5.959591,90.532706,48.234105,5.973927,90.592960,48.162443,6.607178,85.492902,51.191374,6.749186,86.568916,50.823948,7.225686,90.511177,48.252634,7.796162,86.245911,50.627659,8.741565,89.970390,48.517327,8.835090,87.807818,49.764217,8.932733,87.796178,49.743037,9.818599,84.909445,51.370040,10.067237,85.848924,50.660096,10.780487,85.012917,51.219470,11.589723,85.669480,50.617725,13.549571,87.822204,48.727142,4.149037,-134.615239,61.043018,4.708622,-134.757016,60.353616,7.804884,-134.673093,61.221144,8.125978,-133.520413,67.480330,9.884279,-133.914836,65.588815,12.935782,-133.702293,67.143735,6.281940,-0.451384,65.871142,6.607952,-0.182397,65.423482,7.137987,-1.171648,65.861121,7.193047,0.027865,64.775714,8.019941,-0.764246,64.720139,9.338724,-3.636468,67.020790,9.917416,-3.839373,66.585295,10.489406,-0.189829,62.250067,11.423799,-4.941914,66.275702,13.323154,-2.641170,60.766524,13.390497,-5.199285,62.897360,13.611008,-6.676584,65.560359,13.760070,-6.473047,64.843422,13.792001,-5.530464,62.762582,14.033742,-3.915057,60.896991};
			return value;
		}
		private double[] getCoordinate_9_21_point_126()
		{
			double[] value = {14.110730,-0.471112,58.311037,5.697246,2.276941,64.371880,5.745537,1.678829,64.619012,6.622708,1.981902,63.881327,7.288629,2.773895,63.061918,7.685554,6.366944,61.183684,7.727796,3.554862,62.441027,8.082721,7.157312,60.712876,8.166157,7.203872,60.645019,8.878859,3.973493,61.385927,9.459120,1.611173,62.089224,10.223015,7.091670,59.179386,10.960123,9.426082,58.135495,11.427679,10.067910,57.635982,11.665103,6.594561,57.960212,12.218846,6.726749,57.366042,13.226620,1.273946,58.286918,4.933768,16.226474,59.274556,5.466750,19.954634,58.516978,6.493126,21.250725,58.183271,8.394132,19.585195,57.699801,8.728189,11.714184,59.211315,10.100539,15.052185,57.636719,11.142317,12.641279,57.549810,3.900327,22.184183,59.932183,4.014687,30.785850,64.238630,4.332289,31.177740,64.312605,4.460780,24.361202,61.137455,4.827055,25.558484,61.651709,4.859875,28.974950,63.072504,4.910015,31.532611,64.429761,5.218483,25.346233,61.255124,6.034072,24.719861,60.416252,6.307041,24.919948,60.589487,6.331596,30.995767,65.053620,6.414172,21.821293,58.362321,6.652132,22.692635,58.785413,6.721437,29.385108,63.593345,6.729317,23.834501,59.673120,6.831772,24.808854,60.277052,6.885146,28.921071,63.247821,6.955352,28.105519,62.591674,7.015237,29.188533,63.548550,7.122624,21.683038,58.129981,7.192061,24.958598,59.903778,7.510701,26.653295,61.015411,7.581927,26.599821,60.959992,7.634114,30.556738,66.151697,7.640390,30.716474,66.291446,7.700165,25.223014,59.583955,7.706720,31.609735,66.965560,7.770415,30.194143,65.851639,7.907519,25.804505,60.057133,8.247879,21.662772,57.789029,8.365880,24.716909,59.310186,9.420579,29.833101,65.604021,9.482656,29.335923,65.231053,9.591575,31.596726,65.916383,9.900172,22.735275,57.617735,9.998953,30.339780,65.545367,10.342958,27.092852,62.102430,11.253138,29.620457,64.617966,11.359548,28.447651,64.015101,11.428992,24.307000,58.819886,12.090967,27.402077,62.971328,12.317423,31.218930,65.286468,12.445643,28.509554,63.707068,12.816756,24.510008,59.319129,13.928907,31.859034,63.677243,14.216907,23.295984,57.524167,4.112271,37.791270,66.543620,4.117988,40.671244,66.880172,4.247124,32.770745,64.883416,4.585150,34.522067,65.812326,4.881216,34.682378,66.197354,5.179124,36.322032,67.474153,5.213320,41.968910,67.377870,5.966743,33.246604,67.079170,6.546497,33.094370,67.426786,7.645110,32.332433,67.376993,8.167110,34.089921,67.209743,8.731488,34.870594,67.298833,9.173659,34.504459,67.232434,11.215497,34.717399,67.184658,11.628645,36.293371,67.473094,11.991117,41.930242,67.104987,12.039260,35.600753,66.895696,12.256254,37.330126,66.577965,12.300842,36.777701,67.020760,12.342548,39.854889,66.003605,13.117066,32.463646,64.884185,13.187611,35.718633,65.192407,13.351689,41.705430,65.955203,13.468787,33.078846,64.804618,13.520623,33.065860,64.723369,13.544593,33.594230,64.831893,13.573883,42.128704,66.080907,13.592218,38.839595,65.298182,13.599158,36.425080,63.990462,13.621368,36.871234,64.096993};
			return value;
		}
		private double[] getCoordinate_9_21_point_127()
		{
			double[] value = {14.085934,34.148686,62.854385,14.104047,38.601024,65.239720,14.164849,36.288019,63.483881,14.271575,39.883105,66.004870,4.075763,45.219026,66.182500,4.241742,44.952706,66.391260,4.584960,45.854255,65.836072,5.065198,52.353735,63.570263,5.155399,52.344858,63.545613,5.319318,49.211591,64.460683,5.363463,52.565295,63.347636,5.402442,48.892914,64.454641,6.004849,45.375620,66.540051,6.560526,52.929339,62.925587,6.561291,47.174640,65.661550,6.692929,48.846139,64.223323,7.060503,50.378555,63.515784,7.326536,51.570569,63.254627,7.801258,45.260543,67.356748,7.871180,45.628986,67.020103,8.312604,46.284669,66.711958,8.500320,51.686527,64.001050,8.871519,52.203359,64.235952,8.978175,49.436655,65.470255,9.271417,51.402854,64.758605,9.380594,49.651884,65.466740,9.762853,47.084453,66.914900,10.726117,47.972031,66.467615,10.911720,50.050848,64.680412,10.941926,47.808608,66.601675,11.000422,51.657268,64.074275,11.100845,50.764189,64.403063,11.494259,48.785569,66.064487,12.233557,52.666514,64.166916,12.430662,44.195995,66.882211,12.529891,45.914753,66.974882,12.601578,46.086619,66.894970,12.848092,45.547232,66.568493,12.902729,51.672143,64.479607,13.231197,49.961900,65.294645,13.237758,48.539250,65.838122,13.308419,51.002652,64.825388,13.824974,42.848841,66.210817,13.906019,51.394301,64.093392,13.942576,47.122689,65.583296,14.102772,52.769046,63.372193,14.157252,49.205086,64.750680,4.280943,62.175676,62.948297,4.872579,55.123187,62.930663,4.875685,60.266447,62.831844,5.199542,61.768376,62.820002,5.507510,53.126171,63.110157,5.616494,53.598033,62.965336,5.697553,53.771940,62.914514,5.924505,63.091618,62.378337,6.213111,60.622335,62.854135,6.304493,58.297011,62.859956,6.478527,59.933326,62.941179,6.694649,53.707411,62.765659,6.830267,57.203265,62.904358,6.920172,61.494567,62.561886,6.961537,58.208665,62.964300,7.291296,58.525138,63.070253,7.599679,59.051084,62.886151,7.618888,59.511063,62.763013,8.074747,62.325202,62.758026,8.152156,58.388862,62.840551,8.564589,59.032825,62.757718,8.592235,53.035744,63.868566,8.714168,53.679937,63.866642,8.749206,57.884813,62.779126,9.269766,54.675411,63.541574,9.356485,53.473442,63.927041,9.773567,61.967295,62.824285,9.831046,59.579478,63.242284,9.839561,61.374222,63.093420,10.369792,57.206504,63.197287,11.366424,54.394757,63.631099,11.555483,61.694160,62.734339,11.580506,63.057025,62.725937,11.720887,56.015676,63.492661,12.336168,60.889742,62.808914,12.361145,56.971576,63.091312,12.375656,60.978287,62.766940,12.473999,57.444224,62.971388,12.814639,53.041952,64.049843,12.871861,54.926807,63.329627,12.895101,53.640240,63.755141,12.923791,56.175981,63.008541,13.108173,61.623331,62.568339,13.159653,60.375371,62.758594,13.279252,56.948877,62.803324,13.700287,62.535511,62.645948,14.025226,63.303699,62.292707,14.041279,55.731319,62.552485,4.110590,67.956763,61.593152,4.122230,69.855055,60.889806,4.182249,70.245131,60.647105,4.288344,73.567137,58.999542,4.453561,65.787520,61.805444};
			return value;
		}
		private double[] getCoordinate_9_21_point_128()
		{
			double[] value = {4.499178,66.506879,61.909270,4.499316,65.447597,61.810945,4.651010,73.140433,58.967248,4.837793,73.045463,59.010436,4.862827,69.708079,60.515311,4.934230,63.439222,62.200053,5.158746,65.950845,62.071209,5.334325,69.704150,60.664302,5.615852,69.547560,60.939084,5.764812,70.239812,60.970336,5.774337,72.008312,60.533277,5.815409,68.033174,61.339410,5.960975,67.958897,61.472482,5.975952,70.222109,61.325471,6.035866,69.650302,61.468351,6.155517,65.803478,61.812422,6.749959,67.570495,62.273315,7.098410,64.184585,62.200439,7.618872,71.938416,60.993666,7.646349,64.612957,62.298610,7.939063,70.840345,61.549218,8.270820,65.917283,62.924047,8.324981,66.334050,63.001323,8.411947,70.465964,61.624497,8.511012,73.585032,59.989150,8.620254,73.250760,60.167140,8.676009,65.375786,62.923345,8.836662,67.857798,62.754973,9.069767,71.777472,60.689167,9.098615,66.893484,62.927624,9.103197,67.898451,62.607230,9.132680,66.258442,62.947770,9.206647,67.285325,62.860425,9.438069,65.792555,62.963678,9.961811,64.058321,62.863862,10.303247,69.171315,61.392795,10.524308,66.733919,62.292166,10.758411,67.589303,61.643779,11.099597,68.786535,61.689908,11.283103,65.035859,62.812883,11.492500,67.219141,61.607514,11.531331,70.265951,62.053174,11.970181,65.178980,62.460666,12.208328,63.838517,62.690818,12.257644,65.097177,62.281844,12.274833,66.415796,61.688316,12.319134,72.532278,61.170851,12.433743,68.138943,62.334468,12.484905,70.012779,62.217362,12.777146,68.392027,62.445042,13.087111,71.633942,61.462479,13.093691,71.197858,61.648209,13.216900,73.610341,59.846213,13.412320,73.346635,59.942443,13.860313,70.114011,61.989843,13.918427,64.770258,61.759506,14.046992,65.235768,61.846507,14.067799,63.956136,61.936833,14.098185,72.209508,60.397193,5.293217,74.099510,58.754432,7.455172,73.941249,59.900647,7.511220,76.695134,58.152540,7.986942,76.598001,58.148120,8.170078,74.814651,59.266509,8.188540,74.405072,59.512587,8.440959,77.341809,57.704442,9.620305,74.974202,59.777168,9.851176,74.171005,60.293394,10.717963,78.056558,57.798907,11.797799,77.802468,57.422747,12.484078,77.204679,57.688828,12.954152,75.607141,58.738903,13.202708,74.025938,59.611720,13.731677,77.480188,57.551279,14.265384,76.346896,58.246934,4.393168,-131.927975,75.568019,4.413224,-133.182360,68.806162,5.318211,-131.639452,77.248377,7.320090,-133.455071,67.724926,8.276237,-132.874944,70.981736,8.371816,-133.302088,68.691045,8.597388,-132.768326,71.599544,9.384862,-131.866839,76.566954,10.678833,-132.500708,73.321688,10.794235,-132.120592,75.387276,11.473392,-133.029227,70.578245,12.114312,-132.971249,70.976558,12.021704,-76.030471,77.652604,14.270380,-73.284531,76.103575,13.309224,-71.367617,77.074386,13.327793,-70.191216,77.332554,13.375374,-71.766734,77.127146,13.564111,-71.593969,77.002107,13.711038,-70.773174,77.049427,14.100979,-70.327072,76.791361,4.824936,-0.781575,76.833681,5.164535,-1.676103,68.858997,5.860881,-0.541167,76.440192,6.523759,0.394432,72.409099,6.755921,-2.130437,67.736448};
			return value;
		}
		private double[] getCoordinate_9_21_point_129()
		{
			double[] value = {6.839578,0.279248,72.405537,6.919188,-1.012479,76.930271,7.108314,-2.598871,68.286649,7.649436,-2.752308,70.040453,8.637468,0.317193,75.745071,8.808791,-3.224659,70.428621,8.876009,0.474376,75.550403,8.918338,0.166293,75.802360,9.028220,0.222431,75.747867,9.099905,-0.989084,76.374643,9.453185,-1.225195,76.590952,9.609383,-1.368986,76.868761,9.669234,0.577708,74.843797,9.753385,-3.239263,70.732593,10.012568,-1.077179,76.243109,10.024733,0.434247,75.047279,10.030202,-4.457191,68.348372,10.302875,0.382236,74.322075,10.584323,0.290180,74.259599,10.813336,-3.457264,70.732026,11.002919,0.194406,74.902266,11.340493,-1.581028,76.824769,11.705683,-1.467417,76.208382,11.885598,-0.981745,75.714598,12.087697,-2.970042,70.817818,12.145760,-3.554479,70.613102,12.220764,-0.589210,75.486844,12.424305,-0.187935,74.274349,12.783394,-1.159304,75.627902,13.246848,-0.553022,73.601758,13.515984,-0.929130,72.927248,13.687735,-0.577189,74.921213,13.750541,-1.699884,76.696485,14.026681,-0.625820,73.991584,4.035032,1.639738,74.870600,4.721178,0.762530,72.307924,5.426409,1.661861,73.575110,5.703375,1.640188,74.352337,6.166027,0.991887,75.408702,6.745575,1.089854,75.219521,7.271508,1.201480,73.880990,7.647292,1.062811,74.928201,5.224268,37.229980,67.732085,5.423627,37.078588,67.921397,5.436533,36.889596,67.912902,5.450021,40.094464,67.930362,5.768364,35.075019,67.774756,5.894545,38.546605,68.370379,5.925938,34.604484,67.728653,5.972479,41.840792,67.970862,6.172083,40.470931,68.340015,6.241242,36.041528,68.298759,6.572738,37.300293,68.613292,6.825294,37.388477,68.587606,7.031763,42.463819,68.148375,7.096769,34.403307,68.116342,7.105443,41.054797,68.356755,7.222741,34.741718,68.178182,7.261478,37.068162,68.131247,7.445861,35.818915,68.002655,7.582112,36.912137,67.811115,7.831547,37.213037,67.776147,7.995608,42.522880,67.946410,8.101518,40.991914,67.987385,8.880298,38.117457,68.276609,9.151883,36.859990,68.076932,10.152715,39.043094,68.329804,10.320485,38.961042,68.297854,10.524918,35.952625,67.771126,11.286921,37.661401,67.764039,11.362534,36.021957,67.528056,11.523213,40.786218,67.696476,7.322980,42.850502,68.121643,7.816632,44.223899,67.837118,9.239817,44.874906,67.865167,11.101776,42.595770,67.893992,11.265918,42.726687,67.836635,11.340212,43.536518,67.800705,11.787960,44.587391,67.562840,5.756026,-129.706118,87.733659,6.193892,-130.839361,81.680380,7.044243,-130.104543,85.757510,8.316095,-130.906162,81.604613,8.997990,-130.125806,85.904239,12.186039,-129.960075,87.225506,13.070304,-130.879006,82.388172,14.093383,-131.728424,77.944506,8.649227,-83.096932,87.964508,13.994923,-85.756817,85.484399,4.002346,-75.802717,87.091524,4.187832,-76.185299,87.161157,4.451253,-74.968313,85.482957,4.618656,-74.381096,85.059557,5.289116,-77.513671,86.732198,5.982783,-75.638068,84.646093,6.406013,-76.630913,85.189226,6.707471,-73.378641,83.464523,6.987297,-78.914385,85.754116,7.309924,-76.767024,84.320239,7.581938,-75.304722,82.091532};
			return value;
		}
		private double[] getCoordinate_9_21_point_130()
		{
			double[] value = {7.889410,-73.734658,82.198668,8.011181,-75.496314,81.745532,9.277463,-76.933478,82.285718,9.769743,-75.610755,79.896833,9.843861,-76.624539,81.321455,10.770992,-80.630899,82.658650,10.803679,-80.389960,82.470108,12.042556,-79.831214,80.723862,12.043702,-76.851726,78.773465,12.323558,-77.271621,78.953917,12.650277,-78.162940,79.169835,13.554273,-79.944502,79.052234,3.864772,-72.412161,86.039017,4.721551,-65.148082,86.306921,4.740380,-66.519464,85.913763,4.806911,-67.752754,85.595851,4.923421,-71.639368,85.059886,4.997425,-62.584171,87.354016,5.356142,-62.544343,87.310617,5.629061,-70.161948,84.427915,5.708473,-69.266219,84.437103,5.718183,-70.211117,84.395707,5.726126,-70.088698,84.367834,6.725004,-65.543877,84.900305,6.885137,-64.155426,85.563465,6.928936,-66.505736,84.385802,6.969379,-66.227942,84.499868,7.087110,-64.914548,84.833553,7.307527,-64.985558,84.666114,7.336903,-69.602651,83.008276,7.511364,-70.441048,82.772849,7.696789,-69.893658,82.575049,7.701994,-72.122742,82.233517,8.200930,-65.052959,83.792137,8.225212,-69.808510,82.251609,8.331732,-68.993406,82.386052,8.564965,-68.831283,82.194278,8.578011,-65.447187,83.286043,8.643406,-69.033103,82.064537,9.154882,-63.894876,83.844042,9.931873,-69.736363,80.682003,10.081438,-70.829651,80.295603,10.155812,-71.376689,80.102021,10.765490,-69.263569,80.019366,10.862364,-66.325886,80.757192,11.023133,-69.903626,79.471946,11.042018,-69.543939,79.690862,11.729930,-64.528753,81.397249,11.871642,-70.230689,78.712374,11.934076,-62.610079,83.197179,11.952953,-69.294554,78.882824,12.266285,-62.396741,83.218927,12.746684,-62.458933,82.738607,12.761757,-66.772230,78.913468,13.042564,-66.906889,78.536069,13.422421,-62.176759,82.623138,13.528470,-62.543669,82.234572,13.670971,-62.551830,82.176082,5.716231,-60.497019,88.277006,6.842799,-61.725946,87.155811,7.019831,-61.604860,87.171832,7.887111,-59.899813,88.102911,8.114232,-60.241523,87.830036,8.208165,-61.374806,86.576680,8.289721,-59.616706,88.220597,8.559931,-61.924924,85.961311,9.233151,-60.525901,86.859455,9.753802,-60.966212,86.181708,10.068992,-59.208133,87.638272,10.527308,-59.968153,86.640795,11.678209,-60.278889,85.698655,11.823839,-60.916582,85.015830,12.296594,-61.678067,83.859002,12.836787,-60.668776,84.635392,13.048956,-59.995937,85.284608,13.280799,-58.755231,86.531111,13.534893,-60.506495,84.364657,13.978435,-59.904004,84.856666,4.160231,-10.893746,86.158220,4.578776,-11.361377,87.292461,4.630893,-9.969542,85.467258,4.769068,-10.763882,86.406819,5.526257,-10.802241,87.112585,5.951962,-11.066462,88.139281,6.223692,-9.813826,85.927715,6.624165,-10.538450,87.564835,7.222056,-10.355843,87.783774,8.107529,-9.885900,87.438237,4.214883,-3.619362,82.395208,4.465380,-6.749742,85.374046,4.812166,-3.283172,81.932175,4.946327,-9.201425,85.162473,5.493220,-9.249543,85.173999,5.680021,-6.197523,85.202654,5.681901,-6.366340,85.289264,5.753708,-3.861244,83.074527,5.811651,-9.478691,85.382161,6.319572,-2.624931,81.318119,6.923004,-1.015794,78.423006,7.200042,-3.713242,83.132752};
			return value;
		}
		private double[] getCoordinate_9_21_point_131()
		{
			double[] value = {7.264187,-2.701235,81.470627,7.727587,-1.941345,80.708830,7.741057,-4.128686,83.781203,8.021550,-4.138683,83.832639,8.102360,-1.228121,79.705083,8.116424,-5.340351,84.818100,8.298779,-9.215722,86.132252,8.452882,-3.528210,83.181138,8.499943,-3.709559,83.415821,8.556552,-2.816089,81.796956,8.708666,-4.045845,83.804451,8.740891,-6.499682,85.058268,8.854838,-1.745142,80.494859,9.054718,-3.702234,83.540921,9.701942,-8.964624,86.657929,9.947905,-8.040814,85.092670,10.454799,-9.073809,87.810020,10.842025,-1.391571,80.001480,11.411629,-1.466335,80.053799,11.897316,-3.240064,83.028030,11.929717,-3.856520,83.774812,12.308871,-7.996843,86.276561,12.309384,-5.710893,84.450894,12.539569,-3.339131,83.208873,12.701062,-3.138893,82.910010,12.727282,-7.280264,84.821736,13.071231,-1.221645,79.035918,13.279844,-5.230637,84.408929,13.840260,-1.240501,79.125897,13.951980,-4.874028,84.312912,14.080874,-6.498569,84.192488,14.174556,-6.051165,84.022056,14.177710,-3.474425,83.319152,4.115360,-127.712514,98.265273,4.350014,-128.584117,93.595857,4.676477,-129.165995,90.501786,5.021318,-128.605018,93.573541,5.759398,-128.279409,95.428299,6.085428,-127.846389,97.807295,8.277929,-128.450590,94.842601,9.239066,-129.012178,91.942304,9.240076,-129.306306,90.356842,9.251524,-128.060529,97.076806,10.069123,-127.934931,97.863280,13.376951,-128.140625,97.197622,11.203002,-100.568007,98.639561,11.283281,-97.765913,97.960312,12.988234,-98.154395,96.226024,13.755794,-100.256873,95.888382,4.120583,-85.556858,98.353958,4.914382,-83.692831,94.852362,5.077895,-83.692619,94.741658,5.864037,-82.882840,91.588325,6.202053,-84.423825,96.295902,6.711090,-84.472678,95.485750,8.830832,-86.152471,98.015188,9.943112,-85.523183,93.645053,10.232583,-86.348888,96.577586,10.377792,-85.458910,92.116504,10.542563,-92.698574,97.651850,10.727743,-86.547589,96.133733,10.938285,-85.539009,91.225292,11.134427,-86.879450,95.767652,11.600390,-85.593383,89.786277,11.871059,-86.418750,94.442065,12.193240,-87.563660,94.977322,12.829441,-87.781446,94.315809,12.986673,-86.129974,89.266868,13.111008,-88.912308,94.118871,13.148482,-88.054526,93.944883,14.170161,-86.959059,91.908550,14.241843,-93.170637,93.828865,3.995607,-82.530029,92.817296,3.998635,-82.646419,92.994990,5.789012,-80.642229,88.442669,4.310639,-58.422157,90.073590,4.336275,-55.373659,93.119672,4.433170,-56.060965,92.404622,4.709672,-60.415648,88.561316,4.710732,-60.306331,88.643631,4.790805,-57.297016,90.971434,4.891701,-53.282074,95.564295,4.975733,-57.104753,91.199913,6.417085,-57.479028,90.614445,7.385413,-58.752584,89.147103,7.500161,-58.623770,89.243540,7.578781,-58.660380,89.204757,7.958129,-58.118115,89.635977,7.970127,-57.327629,90.404071,9.250303,-51.687439,97.497284,9.357187,-53.612881,94.581765,9.741807,-56.363577,90.780936,13.296101,-56.789005,88.954341,13.988453,-56.490175,89.106295,4.565609,-50.908240,98.511571,7.725066,-50.967763,98.532661,4.086273,-23.349836,98.607050,5.027813,-22.620650,98.391670,5.618688,-21.541505,97.924248,6.434468,-24.094885,98.106180};
			return value;
		}
		private double[] getCoordinate_9_21_point_132()
		{
			double[] value = {6.844730,-24.053960,97.847349,7.537616,-26.317232,97.981766,7.797814,-24.671711,97.228814,7.948423,-26.350514,98.120193,8.531908,-23.124447,96.469201,8.921754,-23.287256,96.552172,9.197496,-24.531998,97.470249,9.756043,-21.733666,95.802443,10.293833,-22.400737,96.371482,10.491226,-23.770545,97.626250,10.826864,-22.387917,96.595724,13.765185,-22.206635,98.233763,3.949777,-19.806217,95.962839,4.200751,-19.887558,96.263311,4.470854,-14.938099,92.059881,4.647163,-14.354363,91.457713,4.659703,-19.953322,96.695016,4.711479,-12.891526,89.927552,5.570784,-11.356481,88.299367,5.668039,-18.565245,96.448605,6.420194,-18.060083,96.531783,7.085307,-17.880140,96.578337,7.365523,-18.380926,96.716107,7.603415,-11.060743,89.667127,7.898819,-11.162701,90.179230,8.225914,-12.849138,92.795653,8.566045,-10.931611,90.209896,9.239260,-9.745818,88.361040,9.507469,-18.152506,95.650995,9.618171,-17.894218,95.570609,9.776837,-15.328951,95.236131,10.848878,-13.558895,94.234008,11.130522,-12.834227,93.758227,11.441366,-20.111884,94.936156,11.520482,-18.528785,94.282646,12.055951,-11.736264,92.924617,12.264302,-19.427648,94.477142,12.448975,-17.344499,93.640456,12.700498,-17.507842,93.495070,13.148731,-17.400997,93.254631,13.216344,-12.013096,92.906618,13.239751,-17.235413,93.157885,13.811796,-17.688628,93.282318,13.950997,-10.132487,91.450568,4.172728,-127.557417,99.109639,4.456025,-127.215198,100.992987,5.097415,-125.936128,107.976868,5.973209,-125.129314,108.670799,6.229449,-126.664655,104.199621,6.802391,-125.868616,108.569245,6.840910,-127.689189,98.756257,7.433038,-125.963576,108.141858,7.621880,-125.536452,108.298878,7.868124,-125.321341,108.011980,8.701269,-127.213439,101.571030,8.896463,-126.283319,106.613389,10.087575,-126.483925,105.691650,10.133285,-126.019868,105.803682,10.981592,-125.847478,104.953289,13.190416,-127.276078,101.834854,13.909045,-127.255097,102.044455,4.280347,-118.501645,105.888748,4.701974,-117.226533,105.984151,4.929144,-121.653972,107.027999,5.110853,-120.930307,107.044741,5.139024,-117.016626,106.234429,6.137807,-115.811284,106.020872,6.564871,-121.812657,107.615685,6.622581,-122.960233,108.270655,6.848128,-121.641080,107.021512,7.069540,-122.978326,108.109141,8.050827,-122.883165,107.215650,8.240424,-119.272201,104.591274,8.364537,-121.682902,105.137341,8.744364,-121.860578,104.840514,9.058208,-121.453461,104.274500,9.130897,-122.625792,105.776806,10.174315,-123.354783,105.214246,10.238432,-115.987017,102.057062,10.667208,-121.975730,102.835860,10.820786,-122.948735,104.066153,10.839567,-122.824011,103.824859,12.131998,-123.101843,102.526184,12.304571,-123.284598,102.663650,12.609190,-122.169353,100.943692,14.012541,-122.817557,99.654699,6.005657,-108.463096,104.874868,6.241900,-109.737636,104.967862,6.337328,-108.623500,104.725006,6.989567,-108.940886,104.258742,7.985091,-110.910489,103.667831,10.276340,-108.868765,101.135337,11.257005,-113.458391,100.795784,11.324020,-111.299823,100.482221,12.048385,-109.707176,99.505333,5.437860,-102.165265,103.439328,5.629862,-100.884915,103.283404,5.715367,-96.174247,102.295152,5.721322,-96.388404,102.349391,5.758573,-96.089724,102.299774};
			return value;
		}
		private double[] getCoordinate_9_21_point_133()
		{
			double[] value = {5.832877,-95.703623,102.251519,5.847304,-102.258149,103.689746,6.044913,-97.076296,102.601441,6.229904,-100.752959,103.346960,6.236313,-93.921283,101.929909,6.244136,-96.641561,102.479882,6.293789,-98.568287,102.853739,6.330149,-93.832837,101.882010,6.375180,-99.978474,103.121959,6.461392,-98.648535,102.783805,6.467658,-102.029130,103.447434,7.089826,-99.698695,102.536235,7.104096,-101.923869,102.957586,9.201553,-94.304985,99.389058,5.015757,-85.364907,99.065422,5.856914,-84.959088,99.029475,6.045535,-85.996937,99.991572,6.058529,-93.253797,101.788774,6.174695,-85.819868,99.911676,6.480440,-91.177053,101.279716,6.511776,-85.902386,99.891068,6.598881,-85.508758,99.608945,6.633582,-86.199691,99.974176,6.751279,-87.050882,100.194546,4.305270,-48.943009,100.605005,4.370973,-45.393388,103.363550,4.521611,-43.897698,103.570821,5.443102,-49.811573,99.875894,5.445476,-42.047024,103.214640,6.270154,-43.971024,103.412722,6.753045,-50.355646,99.436773,6.904896,-46.775118,103.112894,7.108377,-48.528189,101.482046,7.120050,-48.975766,100.878678,7.323513,-49.496686,100.377770,7.484450,-46.774507,103.177550,7.651981,-44.636227,103.540829,7.662570,-46.872231,103.114490,7.799555,-43.096570,103.335654,8.344756,-48.549116,101.413799,8.863922,-46.556253,103.456505,9.153047,-49.459376,100.224813,9.306441,-46.107633,103.727157,9.499388,-42.944847,103.691837,9.546548,-49.718118,100.107288,9.554264,-48.493148,101.454712,9.829881,-41.627664,103.456019,10.406649,-43.770693,104.043934,10.727670,-42.926966,104.119599,11.336872,-41.427185,104.123876,11.757139,-42.157229,104.354240,11.840183,-42.410157,104.413367,11.879125,-45.540999,104.162440,11.887872,-49.065767,100.635625,12.015953,-47.871908,102.042067,12.288018,-47.891421,102.047779,12.974310,-47.494402,102.381707,13.132693,-49.467814,99.897712,13.162044,-47.955680,101.742677,13.897751,-43.339697,105.148707,14.185089,-43.733100,105.158511,4.424530,-40.283873,103.259749,4.522166,-33.638835,101.475281,4.537450,-40.651868,103.227861,4.561136,-39.205008,102.925113,4.746220,-36.129915,102.007447,5.105993,-31.469329,100.472283,5.165103,-34.923950,101.202241,5.239403,-35.880641,101.395358,5.377842,-32.079129,100.328447,5.660364,-34.865256,100.949540,5.907552,-34.563688,100.888071,6.483350,-40.017670,102.598043,6.735265,-38.559975,102.199847,7.122700,-31.316305,100.092644,7.316905,-40.948800,102.778383,8.351938,-32.373401,100.872378,8.620687,-38.790672,102.485727,8.796615,-33.750721,101.470285,9.548377,-36.353704,102.340639,9.573745,-38.231217,102.746201,10.235705,-31.795278,101.634779,10.633980,-39.721531,103.515316,11.646723,-31.066403,102.069095,11.990582,-38.120626,103.900391,12.543093,-30.878843,102.447058,12.834150,-33.411421,103.167145,14.126176,-31.454480,103.283750,4.077511,-29.130350,100.619725,4.210204,-25.609399,99.557942,4.330194,-25.343877,99.444265,4.400734,-24.954468,99.299888,4.414996,-23.822717,98.908226,6.028391,-27.652421,98.982153,6.148062,-29.401664,99.207715,7.632619,-30.090968,99.825830,7.916290,-29.819434,99.856200,8.340227,-27.966961,99.129591,9.216167,-26.670052,98.905586,10.274816,-29.588369,101.004740};
			return value;
		}
		private double[] getCoordinate_9_21_point_134()
		{
			double[] value = {10.349330,-28.169262,100.428735,10.977131,-28.080744,100.695067,11.177799,-28.773084,101.143344,12.797998,-28.690763,101.852281,14.324840,38.295148,-34.634036,14.424283,32.660119,-30.598297,14.692236,39.440342,-34.666239,14.723790,39.936740,-34.751873,14.851628,35.002762,-33.123560,15.063819,39.328030,-34.801852,15.148684,39.318267,-34.846447,15.314574,32.672232,-29.614770,15.319024,33.193247,-31.581134,15.554381,39.703018,-34.912533,15.615353,36.659896,-34.447243,15.704007,33.688891,-32.180680,15.782542,42.330771,-35.108728,15.945419,35.522787,-33.701823,15.984000,42.432628,-35.123896,16.287305,32.336233,-27.008866,16.292621,39.294145,-35.332851,16.919856,33.326652,-31.161895,16.925774,35.696622,-34.069839,16.965563,38.183747,-35.474788,16.989336,40.885843,-35.380217,17.097428,35.981510,-34.409632,17.545861,38.815157,-35.683234,17.590127,41.551853,-35.530234,17.681843,41.545072,-35.549678,17.692867,34.064085,-28.464324,17.697942,33.461893,-29.910280,17.998620,39.709803,-35.712012,18.093350,35.930287,-34.423995,18.372318,32.751868,-27.380725,18.381269,38.588936,-35.827815,18.434679,34.040521,-31.668014,18.667774,38.676492,-35.884109,18.817006,36.016770,-34.602567,19.175372,34.760406,-27.926584,19.448690,35.964212,-34.667797,19.535600,36.967520,-35.341988,19.781455,34.906982,-27.761255,19.808362,33.522880,-27.585420,19.808637,39.029182,-35.882830,19.851004,32.988401,-27.264714,19.887844,35.969228,-33.637697,19.900192,34.986672,-27.745518,19.900966,38.272663,-35.669580,20.076538,34.811451,-31.670518,20.096432,39.225114,-35.924590,20.120027,34.559996,-29.974513,20.149821,34.640305,-30.876958,20.239592,42.210298,-35.653982,20.378961,35.199933,-32.281262,20.551746,35.299138,-27.553693,20.636013,33.044501,-26.869566,20.789817,35.871867,-33.110338,21.011845,33.833963,-27.318422,21.290054,35.679568,-28.083933,21.495171,33.401547,-26.944753,21.614749,38.234958,-35.915659,21.678674,35.031425,-26.951823,22.316005,36.720519,-35.411923,22.408792,35.959209,-26.538109,22.428152,40.178981,-35.873468,22.920780,36.591927,-34.461695,23.168992,38.566271,-35.729275,23.334964,36.125792,-29.388110,23.712875,37.107306,-35.156426,23.758565,39.039571,-35.761656,23.912171,36.431647,-30.698606,24.000322,37.333846,-35.181295,24.598449,41.032807,-34.862541,15.750059,44.685261,-34.620357,15.759318,51.144857,-33.987474,15.877166,45.471012,-34.450242,16.061875,43.332474,-35.030496,16.495429,44.725623,-34.790462,16.542184,42.748225,-35.257098,17.574647,43.254623,-35.374884,20.684660,47.398813,-34.291358,21.727904,46.613409,-34.231319,23.070664,47.574520,-33.666789,23.706494,43.137801,-34.434564,24.513506,48.814519,-33.150590,24.711265,51.120400,-33.370600,14.595788,58.630562,-33.904929,16.557599,59.362222,-33.950109,18.239802,62.319473,-33.494289,19.330261,54.547308,-34.511402,19.585215,59.512748,-33.925816,20.145375,62.145253,-33.449229,21.834097,57.659942,-34.010120,22.029946,56.142023,-34.188896,22.483302,63.009202,-33.010927,23.686983,62.888625,-32.833760,23.800289,56.257858,-33.836447,24.168093,62.729302,-32.776979,24.242291,61.300933,-33.015984,14.689277,63.571279,-33.125852};
			return value;
		}
		private double[] getCoordinate_9_21_point_135()
		{
			double[] value = {14.870499,64.645791,-32.905386,16.258334,68.248655,-31.788712,16.629561,67.003407,-32.213712,17.419353,72.829167,-29.737755,17.922286,64.401773,-32.983239,19.346724,69.236823,-31.089383,21.129762,72.292164,-29.234708,21.562988,65.275515,-32.393718,22.613460,72.273931,-28.821403,22.692477,71.919304,-29.041371,23.104926,70.714587,-29.653516,23.178065,67.573939,-31.180839,24.137942,73.811970,-29.438224,24.597637,73.530584,-29.477424,24.661257,72.157556,-29.788199,24.663587,72.062762,-29.793722,14.758846,79.131833,-27.418403,14.780507,79.621953,-27.306202,15.401337,81.926452,-26.348734,15.469276,75.012071,-28.787354,15.615803,76.370088,-27.793888,15.671500,82.213739,-26.146613,15.767929,82.305041,-26.148948,15.875023,79.323115,-26.982263,16.075984,81.548212,-26.412492,16.690911,77.027470,-27.597759,17.034237,77.432015,-27.317881,18.424909,79.677711,-26.030271,18.725648,78.715621,-26.222380,19.083952,77.655128,-26.404250,19.228462,77.716448,-26.283187,19.974032,76.697443,-26.772122,20.118287,76.134182,-26.924382,20.589850,75.694152,-27.110524,20.835447,76.769026,-26.971296,21.000480,74.895997,-27.476436,21.249925,80.727504,-26.078427,22.320351,80.005776,-27.231522,23.070107,79.664554,-27.137332,23.288681,80.195163,-26.763716,23.317204,76.226556,-28.797068,23.383739,74.676027,-29.190606,23.630843,79.784765,-26.963557,23.798095,81.176198,-26.295697,23.822184,75.281134,-29.078319,24.425070,79.977339,-27.110607,24.495950,81.164320,-26.458652,24.512841,81.277973,-26.432481,14.518650,-10.144419,-18.057315,14.597919,-11.418533,-17.407975,15.097787,-10.522223,-17.851020,15.493485,-12.557791,-15.936940,15.552890,-12.567752,-15.859157,15.617910,-12.021845,-16.522078,15.676376,-11.753258,-16.706333,16.425065,-11.214544,-16.251778,16.689882,-11.786101,-15.582967,16.914114,-11.067657,-16.577416,17.428207,-10.530131,-16.652286,17.556016,-9.759372,-16.858766,14.583779,-8.848530,-18.363510,14.618835,-8.303566,-18.352130,14.772455,-6.119703,-18.710732,15.250386,0.222561,-17.009933,15.412601,-5.057823,-18.565155,15.599053,-8.782834,-18.003099,15.700754,-3.090239,-18.028231,15.709916,-5.334439,-18.529866,15.731370,-6.713156,-18.589274,15.828654,-1.519089,-17.798895,15.948442,-4.906073,-18.485549,15.986104,-1.804384,-18.029368,16.006875,-3.635460,-18.174342,16.118175,-3.343828,-18.199181,16.153331,-4.147410,-18.222427,16.201886,-9.259923,-17.898110,16.358982,-1.041242,-18.363550,16.368844,-1.541141,-18.478599,16.723364,-9.693277,-17.520096,16.757693,-6.010881,-18.168055,16.803125,-3.616793,-18.806925,16.877091,-6.015836,-18.130689,16.954815,-8.411395,-17.717796,17.214968,-8.782821,-17.430068,17.470412,-4.754507,-18.988144,17.518490,-6.557402,-18.092605,17.904346,-1.463110,-18.991027,17.921550,0.280650,-18.558574,17.931477,-0.202671,-18.702256,18.126906,-0.723748,-18.879670,18.280907,-4.357695,-19.354931,18.438918,-6.430553,-18.803557,18.487420,-3.415348,-19.229443,18.494603,-8.576194,-17.148051,18.539314,-4.852888,-19.376086,18.616399,-8.739829,-17.017139,18.641580,-6.247191,-18.939128,18.840618,-8.017348,-17.983400,19.043202,-3.350086,-19.393408,19.052104,-8.854680,-17.148115};
			return value;
		}
		private double[] getCoordinate_9_21_point_136()
		{
			double[] value = {19.246436,-0.646172,-19.022766,19.322646,-1.597308,-19.189152,19.428508,0.252331,-18.893315,19.479639,-9.672826,-15.743685,20.035177,-7.129600,-18.661974,20.054968,-8.209165,-17.432126,20.271512,-8.425990,-17.122037,20.443459,-1.927553,-19.364827,20.685542,-8.469146,-17.221196,20.701293,-3.624670,-19.426530,20.829649,-5.907569,-18.774719,21.133807,-8.939405,-16.157632,21.142099,-5.151865,-18.926423,21.211081,-8.861024,-16.460137,21.258328,0.309136,-19.198949,21.340751,-5.235715,-18.894931,21.532805,-6.418240,-18.082689,21.906681,-3.407619,-19.018974,21.921397,-7.107248,-17.166194,22.176674,-7.707978,-16.317719,22.206800,0.085031,-18.447078,22.546454,-4.362706,-18.637534,22.644994,-3.408975,-18.563455,22.673459,-1.225032,-18.312167,23.292985,-4.988330,-17.562484,23.769802,-6.636985,-15.784820,23.800493,-0.671361,-19.105394,24.147881,-0.427846,-19.314485,24.164280,-3.469980,-18.348488,24.321839,-4.093819,-18.026639,24.429898,-0.438810,-19.366116,14.828981,0.812248,-16.634087,14.941050,1.689710,-16.263502,15.234931,2.335501,-16.015378,15.723351,3.661663,-15.575800,16.357666,4.083179,-15.664454,16.751970,0.755940,-17.986066,16.983884,1.289973,-17.876909,17.141657,0.917947,-18.074723,17.407128,1.359538,-18.006745,18.040673,0.943738,-18.397227,18.356328,2.992085,-17.722759,18.369871,3.439697,-17.400827,19.344602,4.918952,-16.914786,19.428003,4.233406,-17.601359,19.497985,3.329401,-18.034237,19.763631,3.052835,-18.179495,19.911919,1.707013,-18.669797,20.281212,4.043149,-17.781495,20.809930,2.106662,-18.990036,20.925291,5.346085,-17.307426,21.139198,6.429543,-16.547916,21.516977,6.423795,-16.651284,21.538410,1.093097,-19.015779,21.727353,3.417837,-18.543435,22.265887,1.130231,-18.354993,22.638913,10.599797,-16.074489,23.032492,4.942881,-17.923953,23.119771,10.763809,-18.452853,23.146039,10.508129,-18.322448,23.215545,1.826434,-18.138358,23.280995,9.884059,-17.056121,23.523480,8.630619,-15.547605,23.662357,10.203435,-18.436169,23.675016,3.927493,-17.667700,23.799418,10.018886,-18.093700,23.869442,9.623183,-16.704076,24.181696,1.627875,-19.023008,24.318541,4.111458,-17.787089,24.421778,10.286101,-19.056172,24.511476,4.704636,-17.553627,24.718482,3.557724,-18.536520,15.740240,20.166462,-20.318417,15.988098,13.227379,-18.304515,17.201337,15.540545,-19.250149,17.829784,19.072234,-19.840276,18.060163,20.225047,-19.785914,18.259676,13.840323,-15.679014,18.426038,16.229938,-18.868602,19.116385,14.584369,-15.746700,19.722138,14.964627,-15.858915,19.764858,15.889345,-16.868003,19.938229,15.220603,-15.749183,19.943171,17.173307,-18.446558,20.064785,15.004327,-15.611093,20.369300,20.773929,-19.242376,21.030361,17.627548,-18.046997,21.039523,16.248247,-16.046579,21.985610,11.925632,-16.557122,21.988949,18.312316,-18.094110,22.190685,15.928693,-16.658632,22.250302,11.884960,-17.354053,22.369306,16.374394,-16.686408,22.719604,16.881803,-16.986679,22.799987,19.551340,-18.657592,22.992510,17.608424,-17.224268,22.994842,20.013838,-18.788033,23.116060,12.325206,-18.866042,23.252703,15.269378,-18.461756,23.261795,17.867028,-17.384430};
			return value;
		}
		private double[] getCoordinate_9_21_point_137()
		{
			double[] value = {23.514970,12.333019,-19.189271,23.605160,19.208094,-18.539279,23.665633,20.098049,-18.882594,23.981267,15.115700,-19.187065,24.319624,15.274965,-19.293525,24.579456,17.431551,-18.032312,24.608367,17.312587,-18.100263,14.309711,22.645201,-20.936211,14.480008,27.656991,-24.059934,14.917004,28.774511,-23.379704,15.259210,28.910287,-23.232369,15.531999,26.984119,-24.160011,15.913149,30.932620,-24.010921,15.996156,23.609454,-21.003056,16.141265,26.245689,-23.846812,16.230292,31.526156,-24.310258,16.262167,23.749259,-20.989178,16.462717,24.594498,-21.922204,16.560453,26.185352,-23.755777,16.769598,29.546676,-23.211346,16.970704,29.829208,-23.767719,17.122712,28.859110,-22.715117,17.312823,31.997309,-24.946921,17.315106,26.257693,-23.578490,17.496949,25.695909,-22.986569,17.987216,29.412553,-23.400861,18.002590,22.837097,-19.670344,18.250461,29.093965,-22.847182,18.357661,28.965077,-22.656575,18.480316,28.102964,-22.587597,18.524140,31.319284,-23.622470,19.300276,31.654379,-22.981041,19.425282,23.968569,-19.368489,19.464307,31.770804,-22.925200,19.581961,31.547401,-22.656356,19.628070,30.958373,-22.092307,19.643151,25.514521,-21.244929,19.745969,30.160677,-22.491752,19.863537,30.272291,-22.353426,19.948295,26.612136,-21.995422,19.965464,25.337505,-20.417330,20.102822,30.776796,-21.967142,20.378128,30.777476,-21.859390,20.464579,31.157067,-21.751492,20.468673,31.062906,-21.754531,20.500999,28.600580,-20.839100,20.655147,24.501771,-18.877013,20.707057,21.989997,-19.123530,20.805014,32.029301,-22.362207,20.854907,29.888979,-20.596515,20.955669,25.574222,-19.145009,21.523993,29.439405,-19.661371,21.618799,31.439737,-20.840527,21.858646,28.128745,-19.845532,21.978205,31.683740,-20.291980,22.008620,27.771540,-19.660540,22.072492,27.140591,-19.003521,22.145134,28.557943,-19.518189,22.153792,30.377502,-18.837712,22.192664,29.946307,-18.760238,22.566814,28.819940,-19.021652,22.808821,26.535155,-18.340222,22.894778,31.992888,-18.743134,23.050324,30.052501,-18.411266,23.215590,30.908804,-18.077120,24.119472,31.307262,-18.069263,24.292023,29.246064,-17.994400,24.328315,30.860058,-17.927966,24.483762,31.787069,-18.854093,14.734758,32.312233,-25.160244,17.308357,32.838736,-25.726382,17.784997,32.548388,-25.278610,18.792581,32.259582,-24.103986,19.981372,32.727648,-23.534776,20.074178,33.086157,-24.586865,20.089421,32.744763,-24.250260,20.289922,33.299067,-25.508308,20.450194,32.090027,-22.336834,21.711518,33.610653,-24.300612,22.211045,32.587673,-20.755678,22.290551,33.282683,-21.882287,22.584514,33.425757,-23.586395,22.661644,33.449719,-22.698785,22.875545,33.644141,-25.660901,23.129113,33.161474,-22.095379,23.149839,33.287085,-23.089292,23.150648,32.683215,-19.484079,23.730968,36.482205,-24.700106,24.048315,32.155058,-19.220913,24.158613,32.640195,-19.957707,24.283215,33.215536,-21.544412,24.405003,33.291035,-21.533766,24.459961,33.331812,-21.465756,24.467835,35.644475,-22.739649,24.496720,36.554029,-23.871457,24.545839,35.466978,-22.285027,24.549512,35.193109,-22.309667,24.587044,33.066318,-20.176351,24.705642,36.362710,-23.315946,24.716200,34.682798,-21.297120};
			return value;
		}
		private double[] getCoordinate_9_21_point_138()
		{
			double[] value = {14.278027,83.859785,-25.422437,16.237134,83.312062,-25.676031,17.982389,81.393046,-25.468343,18.142318,82.346324,-24.990889,19.778574,82.151393,-24.196711,19.882538,81.917715,-24.360139,22.109466,84.161159,-24.744629,22.149562,83.987331,-24.858166,22.659378,82.542459,-25.624641,23.219767,83.906576,-24.755864,23.523583,83.972645,-24.945699,24.533584,82.240539,-25.894923,24.726266,84.317535,-24.397344,14.331583,85.843083,-24.420807,14.350405,88.620171,-21.090445,14.686683,86.435453,-23.588905,14.791306,88.832540,-20.934957,14.821776,87.516789,-22.021584,14.849063,88.615046,-21.120655,14.997010,92.547402,-16.751846,15.058115,86.269222,-23.429766,15.324052,91.632211,-18.146747,15.539117,84.402705,-25.325302,15.577250,86.650702,-22.758772,15.661993,87.138510,-22.540850,15.739337,84.430898,-25.269364,15.791727,92.412877,-16.954568,15.823534,93.488903,-15.711745,15.919672,85.865976,-23.353864,16.048168,89.742292,-20.593799,16.068995,84.897528,-24.318157,16.463619,86.796728,-23.238587,16.624535,85.049030,-23.936971,16.897099,92.626101,-16.711417,16.911096,90.521926,-19.167462,17.000945,90.658073,-19.028642,17.137033,86.809724,-23.181651,17.247584,91.974119,-17.546157,17.261267,90.733290,-18.991772,17.299726,89.586426,-20.096679,17.478998,86.404389,-23.393471,17.550173,91.149777,-18.550340,17.643780,88.672096,-20.916259,18.003480,85.061068,-24.067908,18.020448,86.434590,-23.062008,18.145970,89.654634,-19.954421,18.177474,90.738906,-18.723116,18.318089,92.272681,-15.696938,18.401174,90.921286,-18.219272,18.426586,86.089153,-22.999143,18.433883,92.219662,-15.757422,18.472291,91.837301,-16.233315,18.477234,92.094121,-15.909272,18.615206,88.242711,-21.102510,19.345892,85.619735,-22.605037,19.968304,85.624374,-22.646120,19.981623,86.554564,-22.093476,20.255745,88.253575,-20.707130,20.446498,89.764913,-18.874075,20.933458,84.382512,-23.801751,20.942827,85.855269,-23.027592,21.116577,86.743054,-22.494819,21.489038,85.003704,-24.002675,21.575078,86.677276,-22.617837,21.809726,92.618650,-15.575931,22.002332,92.287190,-15.900967,22.026923,85.367678,-23.833599,22.200980,86.954226,-22.440772,22.604061,86.461842,-22.913949,22.673197,90.898753,-17.151997,22.969914,87.505335,-21.991421,23.021017,85.185018,-23.930713,23.198794,89.573207,-19.359270,23.280859,86.863129,-22.580118,23.514928,85.680007,-23.578396,23.707225,87.445786,-21.962223,23.807102,86.248451,-23.154598,23.884287,91.345049,-16.565244,24.076298,85.808216,-23.407427,24.109647,89.977628,-18.009774,24.223121,91.703574,-15.788180,24.371148,90.557861,-17.583532,24.570354,87.105837,-21.785665,24.647564,88.745952,-19.119860,14.431027,-72.877330,-6.279894,14.972113,-72.678199,-6.096542,14.383874,-65.124097,-6.322677,14.576399,-65.004608,-6.002807,15.367032,-65.245937,-5.637264,14.908295,-41.392091,-5.172705,14.383368,-34.829213,-9.874170,14.464056,-39.458204,-6.367350,14.723959,-36.886956,-8.894058,14.906198,-37.135037,-8.060478,15.247408,-34.097820,-10.149005,15.520547,-34.114514,-10.220592,15.521123,-34.207571,-10.200818,15.534426,-34.653786,-9.993791,15.709181,-35.562836,-9.391970,15.758876,-40.008475,-6.331748};
			return value;
		}
		private double[] getCoordinate_9_21_point_139()
		{
			double[] value = {15.957977,-39.715122,-6.589644,15.976164,-38.895496,-7.189754,16.135316,-35.479181,-8.819821,16.150746,-39.907511,-6.122869,16.441339,-34.937107,-9.148985,16.483820,-33.099304,-10.225147,16.613223,-30.640689,-9.996371,16.682331,-39.688873,-5.584295,17.002000,-35.544974,-8.666683,17.042006,-37.867526,-7.276629,17.082148,-36.857540,-8.209014,17.122924,-32.819452,-10.119394,17.273542,-33.471135,-9.828494,17.564190,-33.719424,-9.546253,18.031983,-36.178791,-8.237066,18.066582,-32.425034,-10.097151,18.434199,-36.173156,-6.082904,18.609895,-34.375883,-9.379761,18.905152,-33.460633,-9.512862,19.181889,-34.184655,-9.053459,19.203034,-30.796566,-10.352945,19.360986,-32.030459,-9.456421,19.665219,-34.904220,-5.885931,20.290745,-33.242470,-8.841651,20.363712,-33.196395,-6.876699,20.423339,-34.236686,-6.115825,20.426116,-32.933520,-9.069366,20.513790,-32.810164,-9.034647,20.591695,-32.749852,-8.636681,20.601799,-32.622368,-7.716919,20.884663,-35.502348,-5.252069,21.220125,-32.362856,-6.917268,21.474228,-36.086580,-5.415740,21.669965,-37.224875,-5.251487,21.950314,-35.510424,-5.569798,22.238346,-36.172948,-5.436658,22.320411,-34.365499,-5.630085,22.612882,-34.837907,-5.653598,22.714799,-33.155893,-5.747862,24.599161,-32.529754,-5.957766,14.458525,-28.995557,-10.920036,14.636343,-29.622346,-11.082985,15.093129,-28.360508,-10.979586,15.173514,-27.033924,-10.447491,15.184293,-28.194481,-10.964538,16.145718,-27.199167,-11.010528,16.224392,-21.833068,-9.322435,16.337126,-24.656277,-10.303706,16.914269,-29.022074,-10.653356,17.179628,-29.683774,-10.129781,17.916429,-24.065684,-10.607689,18.533699,-25.080824,-10.644595,18.575315,-27.100369,-10.155208,18.859585,-24.300961,-10.431306,19.089009,-29.563941,-10.271468,19.633160,-25.547348,-9.578453,19.663526,-24.329295,-9.672016,19.834777,-21.205606,-9.244628,19.842542,-26.058543,-9.585594,20.029516,-24.312054,-9.320825,20.047104,-23.038427,-9.265801,20.111763,-30.309019,-9.713427,20.114633,-21.539337,-9.155846,20.375952,-23.560565,-9.156253,20.390348,-23.705164,-9.155369,20.905712,-23.945200,-9.336437,21.218837,-24.982536,-9.756175,21.257639,-27.988604,-9.772059,21.290289,-27.331159,-10.092117,21.342314,-21.680119,-9.390553,21.737698,-29.382973,-9.391443,21.801106,-25.884360,-9.835896,21.859020,-29.532642,-9.484160,21.926584,-21.962149,-9.369502,21.966679,-30.016074,-9.653546,22.209983,-30.373977,-9.544171,22.215517,-23.242872,-9.328435,22.297635,-30.386712,-9.503433,22.321357,-26.671353,-9.202580,22.485441,-24.009155,-9.336328,22.520520,-26.859071,-9.288304,22.749198,-29.928225,-9.544309,22.786219,-21.516165,-9.587624,22.888843,-29.889063,-9.439468,22.970816,-24.098526,-9.466389,23.054177,-23.527190,-9.394040,23.342886,-22.772412,-9.357283,23.451269,-29.511234,-8.947432,23.491218,-26.657007,-9.677249,23.499067,-27.131574,-9.731929,23.563770,-30.152997,-7.006027,23.676276,-29.166093,-7.310923,23.679723,-26.369655,-9.698580,23.835054,-29.149343,-8.746483,24.045250,-21.621828,-9.099112,24.061784,-26.364399,-9.753951,24.126440,-28.726366,-8.535327,24.254155,-25.394279,-9.753825,24.318095,-23.264416,-9.419197,24.656612,-25.599584,-9.594072};
			return value;
		}
		private double[] getCoordinate_9_21_point_140()
		{
			double[] value = {14.395008,-14.135739,-10.492543,14.463318,-14.099832,-11.912613,14.679317,-13.970020,-10.234281,14.713605,-13.882729,-11.043405,15.000288,-13.845663,-11.540834,15.201294,-15.308057,-9.881115,15.367711,-13.571572,-12.188933,15.399502,-13.290805,-13.012839,15.475784,-18.369527,-9.515267,15.497191,-13.674416,-9.971909,15.652100,-17.553284,-9.782235,15.658573,-15.881632,-10.161540,16.052587,-18.932219,-9.445640,16.164605,-16.976076,-10.204157,16.297056,-13.009813,-10.116811,16.466124,-12.594420,-10.258602,16.625688,-19.979557,-9.406902,16.818651,-12.347837,-11.499650,16.925317,-12.979965,-10.191176,17.030698,-17.695524,-10.595555,17.204708,-12.598642,-13.700882,17.432183,-11.839358,-10.268259,17.554723,-12.631729,-10.255703,17.646298,-12.051796,-14.766129,17.650945,-16.676697,-10.947141,17.741609,-11.097916,-10.981988,17.841191,-11.062164,-11.463610,17.852909,-11.902505,-14.677732,17.853510,-11.992278,-14.342411,18.181818,-11.084199,-15.193191,18.251507,-19.343157,-10.101650,18.332657,-10.939024,-14.129692,18.336679,-10.607885,-13.051656,18.416703,-14.288237,-10.632488,18.494507,-18.893429,-10.335681,18.535679,-13.776414,-10.496222,18.647634,-10.426494,-14.161520,18.737409,-20.133283,-9.692913,18.824389,-10.730169,-9.482414,18.877476,-10.275852,-12.361031,18.927191,-10.620510,-9.466684,19.006271,-16.798400,-10.713471,19.121647,-13.326261,-10.116710,19.152160,-10.156312,-11.832551,19.528862,-15.087436,-10.150068,19.860370,-15.072985,-9.612722,20.151369,-12.258836,-9.434223,20.189595,-14.918141,-9.501150,20.827522,-9.758571,-15.030021,20.997704,-9.801670,-14.584908,21.086459,-9.774826,-14.551949,21.214743,-9.853781,-8.631716,21.614298,-15.307844,-9.947475,22.120245,-19.364331,-9.665503,22.276898,-13.413550,-8.615812,22.448030,-16.464146,-9.911453,22.506113,-10.926749,-8.069470,22.629808,-12.237163,-8.415455,22.647290,-10.060513,-8.251725,22.651240,-19.225732,-9.789205,22.682989,-16.086406,-9.798937,22.695327,-15.637999,-9.755202,22.829330,-19.760385,-9.732281,23.072975,-17.085349,-9.857158,23.087523,-14.452077,-8.452255,23.369171,-14.541373,-8.426159,23.995723,-13.769441,-8.244827,23.996514,-14.803590,-8.543313,24.155987,-18.933969,-9.129288,24.186966,-13.871954,-8.209760,24.202599,-14.973877,-8.577122,24.326066,-18.793758,-8.707868,24.391601,-19.022302,-8.684909,24.532863,-18.855266,-8.516765,24.693227,-15.114050,-8.583705,24.722227,-20.057547,-8.571709,20.125179,-9.222809,-9.235983,20.511974,-8.913153,-9.533485,20.565792,-9.025498,-9.042092,20.640715,-8.676690,-9.995236,20.838698,-8.874019,-11.404237,21.034934,-8.341962,-10.528152,21.174016,-8.842977,-11.774597,21.205839,-8.242369,-10.055159,22.004189,-9.264268,-13.941991,22.521669,-8.785882,-13.521519,22.791195,-8.419273,-12.970711,22.834737,-7.908967,-11.619747,23.003288,-8.153313,-13.854522,23.331263,-7.472041,-15.286968,23.347982,-7.943136,-13.203836,23.390925,-9.115864,-8.391298,23.763712,-7.115320,-10.519070,23.848984,-7.431535,-12.993516,23.933089,-8.266216,-8.736694,23.953008,-7.024823,-10.752971,23.957924,-6.834166,-15.187485,24.309605,-7.979168,-8.917518,24.460612,-6.634966,-14.248303,24.493740,-7.690280,-9.363418};
			return value;
		}
		private double[] getCoordinate_9_21_point_141()
		{
			double[] value = {24.531857,-6.910235,-13.813645,24.721350,-8.225069,-8.730003,14.611501,6.482591,-14.662214,15.087777,5.344311,-14.854247,15.402399,9.652211,-14.759861,15.618694,9.764764,-14.735746,16.785905,5.434680,-15.087111,17.826121,6.481952,-14.905600,19.236439,6.697747,-15.008346,19.335896,10.339416,-14.763978,19.594010,6.476416,-15.197928,19.685274,6.323629,-15.397689,20.353503,6.709961,-15.455556,20.689943,9.577459,-14.815001,21.632966,8.848163,-14.810937,21.900109,7.308144,-15.540087,21.923111,10.482752,-15.118062,22.604401,8.560277,-15.140185,23.246964,8.666467,-15.424311,17.175308,12.261809,-15.134712,17.924682,13.001485,-15.156298,18.935266,14.257611,-15.493077,19.143108,12.658854,-14.964602,20.424262,12.582381,-14.983381,14.888987,93.938331,-14.833921,16.397412,93.826129,-14.941640,17.814369,92.891355,-14.983416,18.533671,92.491033,-15.420281,18.569820,92.977606,-14.884776,18.611917,94.583096,-13.008377,21.082163,93.603188,-14.423381,21.385337,94.513692,-12.313676,21.761637,93.979601,-12.795416,21.967370,93.432987,-14.256427,22.536946,93.661507,-12.893477,23.599835,94.174573,-11.873993,23.861963,93.825930,-12.413262,24.382623,91.899048,-14.470478,24.446413,92.403760,-13.675482,14.732113,98.657580,-7.329981,14.841490,98.194461,-8.053094,15.081588,95.820515,-12.036709,15.338417,94.908170,-13.666431,15.492342,95.207714,-13.167751,15.661331,98.976253,-6.414258,15.809433,96.976049,-10.101845,16.231713,99.063333,-5.974361,16.624406,97.992219,-8.090450,16.770504,98.766132,-6.410599,16.807376,96.726181,-10.127819,16.833780,99.051409,-5.911311,17.378414,98.837751,-5.945590,17.477497,94.955759,-12.462142,17.657395,95.328977,-12.080568,17.865113,96.130500,-11.089091,19.319181,96.539776,-9.561308,19.722466,96.653107,-9.244062,20.086247,96.656520,-9.134116,20.301593,96.755170,-8.836865,20.415869,96.694277,-8.893437,20.424343,95.439344,-11.398155,21.167025,95.777134,-10.219455,22.254327,95.347817,-9.428352,22.885545,95.003683,-10.609343,23.078721,94.895566,-10.698855,23.820940,96.026786,-7.009545,24.454702,95.355799,-7.204382,15.517640,-76.780444,1.817226,16.129717,-77.077541,3.208162,16.285987,-76.898688,2.259920,16.986064,-77.054477,3.492385,18.641184,-75.019854,-1.966522,19.213117,-75.412778,-1.177235,19.350958,-76.394839,1.235814,20.764786,-76.707161,2.843715,21.209395,-74.916336,-0.579563,22.321564,-75.289882,0.430917,22.674141,-73.402237,-0.538530,23.163819,-74.055743,0.384942,24.221875,-76.143604,2.973756,24.511928,-74.379337,1.504665,24.528997,-75.991737,2.902039,14.366704,-64.802143,-1.139786,14.382843,-64.458050,-4.124656,16.495162,-65.524411,-4.925033,17.370684,-71.613165,-4.983901,17.460391,-65.470653,-3.996819,17.477593,-64.974629,1.414465,17.496631,-65.128104,-1.272346,17.846910,-65.525694,-3.698662,18.250062,-65.360431,1.693631,18.443539,-67.637140,-4.312726,18.645188,-69.050632,-4.302974,18.798048,-66.000092,-3.373150,18.975533,-66.314007,-3.522649,19.005256,-65.659835,1.546082,19.275718,-65.451972,-1.741021,20.025471,-65.760089,2.572617,20.182939,-65.603679,-1.288992,20.280584,-66.302173,-2.547139};
			return value;
		}
		private double[] getCoordinate_9_21_point_142()
		{
			double[] value = {20.369640,-65.607090,0.763450,20.737584,-68.364570,-2.760141,21.130664,-63.072692,4.706823,21.151211,-70.219446,-2.473614,21.214112,-65.863182,2.425494,21.741627,-65.809024,2.268942,21.860799,-70.307242,-1.967743,22.263783,-66.933373,-1.339407,22.309005,-65.696664,1.916799,22.332483,-65.667564,4.628259,22.696207,-65.645843,4.941217,23.045938,-65.717361,1.542678,24.191733,-70.258160,-0.299104,24.219657,-68.409402,-0.140556,24.246115,-65.843183,4.631615,24.546096,-66.457600,0.669998,14.298629,-56.874409,2.949799,14.605040,-61.206012,0.755619,14.946666,-57.005447,3.421745,15.046383,-57.154403,3.358895,16.644400,-58.076172,3.750589,16.802495,-58.414001,3.620650,16.924716,-59.633908,3.030873,17.344855,-58.702188,3.791997,18.464564,-61.237421,3.385471,19.415213,-59.236334,4.898433,19.432394,-59.320952,4.856622,19.477865,-58.944329,5.201050,14.348356,-45.203635,-0.548914,14.417750,-41.977084,-4.439155,14.430855,-41.809812,-4.600704,14.463539,-42.906317,-3.516163,14.529520,-44.286792,-1.636026,14.898116,-48.750985,4.955436,14.936935,-43.429435,-2.763923,14.942530,-48.529637,3.947261,14.948851,-45.024454,-0.350981,15.065997,-42.525777,-4.151238,15.220569,-44.527427,-1.030677,15.568846,-43.625172,-1.850719,15.959514,-45.356238,1.680752,16.002315,-41.158680,-4.831413,16.007527,-47.359847,4.989750,16.051538,-45.681333,2.124773,16.183998,-44.274380,0.688415,16.258286,-44.279536,0.747329,16.277493,-42.065950,-1.817269,16.344939,-43.563549,-0.091878,16.425106,-42.337790,-1.293484,16.499801,-43.445656,-0.172406,16.519288,-41.907518,-1.685282,16.791926,-45.830133,2.647956,16.797427,-42.279975,-1.176708,16.801646,-41.837263,-1.607908,17.012411,-42.018981,-1.379458,17.356664,-43.872605,0.120066,17.407839,-42.573161,-0.976936,17.479040,-43.009382,-0.698553,17.507082,-42.280828,-1.238529,17.524166,-41.387391,-1.909938,17.684566,-46.670924,3.522448,17.708666,-47.071727,4.094520,18.270826,-46.924436,3.295980,18.310047,-41.406605,-2.334053,18.650945,-47.063698,3.240020,18.674485,-44.746553,0.230583,18.790013,-46.869791,2.930351,18.837088,-48.114445,4.782432,18.845656,-47.034315,3.143274,18.938454,-43.614426,-0.998733,19.001463,-47.795605,4.417731,19.008087,-47.290311,3.523393,19.037268,-44.471525,-0.103842,19.522466,-46.002831,2.095730,19.734178,-43.679236,-0.584535,19.747233,-42.198222,-1.960894,19.827552,-43.688843,-0.590430,19.924083,-44.866514,0.752094,20.014616,-43.049856,-1.301221,20.307270,-45.309913,1.151414,20.476321,-48.478872,4.504526,20.656379,-45.200173,0.630946,20.722575,-43.448585,-1.618542,20.910215,-45.017828,0.047683,20.994597,-43.280779,-1.973908,21.110427,-41.248893,-3.519696,21.173956,-44.614938,-0.717671,21.271512,-44.570585,-0.767810,21.277079,-45.819385,0.624634,21.441379,-42.705666,-2.425313,21.465300,-46.271071,1.112021,21.670155,-41.918007,-2.709721,21.683445,-49.010536,4.724946,21.745186,-46.976948,2.030588,21.793761,-44.913790,-0.343074,21.855000,-49.006368,4.829364,22.331334,-47.568804,2.939551,22.425047,-46.865747,1.974849,22.506056,-46.643500,1.812335,22.618518,-42.501763,-1.077370};
			return value;
		}
		private double[] getCoordinate_9_21_point_143()
		{
			double[] value = {22.623145,-42.738519,-0.872634,22.718848,-47.917759,4.200000,22.890306,-45.472559,1.394092,23.126645,-47.218753,3.803215,23.286325,-47.289794,4.099526,23.332215,-42.053557,-1.537941,23.700675,-42.638793,-1.017884,23.733446,-43.906757,0.214786,23.798960,-47.804279,4.611415,23.982776,-42.437254,-0.958719,24.189063,-41.863553,-1.175223,24.190167,-43.155041,-0.111467,24.378371,-46.320313,3.086751,24.411136,-45.367137,2.175429,24.438240,-45.278108,2.124179,24.705940,-46.480895,3.729405,16.577656,-40.373709,-4.036740,16.691220,-40.080234,-4.561623,16.916011,-39.509813,-4.457596,17.031823,-40.432862,-2.709737,17.164226,-39.011213,-4.663708,17.171253,-39.277349,-3.810989,17.251066,-38.775801,-4.852382,17.388382,-39.066482,-3.646334,17.965426,-39.615312,-3.135313,18.104718,-40.041108,-2.872294,19.082329,-36.559134,-4.906350,19.618442,-36.267562,-4.923979,20.202504,-40.015594,-3.817091,20.704175,-40.021500,-4.132491,20.894779,-40.750149,-3.804503,21.036582,-39.863918,-4.256170,21.496106,-38.833037,-4.618389,21.715195,-38.757544,-4.435862,21.808819,-40.111007,-3.516024,21.936310,-38.773369,-4.060164,22.521529,-40.326696,-2.640882,22.773117,-39.820653,-3.034621,23.016804,-41.000144,-2.275834,23.457375,-39.594461,-3.293868,23.958353,-40.068258,-2.858301,24.006021,-38.467211,-3.747951,24.169587,-40.031235,-2.455769,24.182899,-37.887777,-3.591983,24.290334,-37.682288,-3.445620,24.310468,-38.889141,-2.786049,24.694823,-34.627483,-4.692251,24.725537,-34.643270,-4.554279,14.602318,100.930943,-0.746438,14.939292,102.911629,4.446057,15.013629,101.787581,0.210035,15.186929,100.422933,-1.662085,15.409899,102.004255,2.132078,15.462093,101.520544,-0.348100,15.517297,101.902259,1.797351,15.608079,102.160562,2.702427,15.674266,102.464148,3.335190,15.690819,99.693012,-4.940215,15.692784,100.163462,-2.091498,15.748829,102.679496,3.932770,15.987445,101.577911,1.070652,16.399031,102.243474,2.774791,16.502239,101.577981,1.510161,16.796864,102.063064,2.349342,16.839079,100.971364,-0.064491,17.417522,102.168756,3.659496,17.441382,99.365019,-3.762128,17.655494,102.400048,4.955551,18.154853,102.052858,3.919942,18.206436,99.120570,-4.031983,18.335758,99.955825,-1.379938,18.366359,99.996829,-2.620846,18.479271,99.934084,-2.662971,18.931879,99.541641,-2.184418,18.993830,101.189502,1.898022,19.024502,101.770361,4.811321,19.356763,99.298853,-2.434670,19.408263,101.054199,1.948584,19.462451,99.244282,-2.532416,19.616106,98.941524,-3.877155,19.685790,100.413555,-0.696503,19.705552,100.789861,0.171028,19.980393,100.620958,0.183393,20.146067,101.382430,4.578598,20.243364,101.218292,2.462212,20.969959,101.130358,3.096777,21.145706,100.902523,4.966216,21.312100,100.845964,5.156337,21.462052,100.900769,2.994133,21.518193,98.607481,-2.463147,21.992852,98.023054,-5.028208,23.649318,97.370576,-3.297449,24.218893,97.978708,-2.747116,24.542091,96.961494,-3.814785,24.575256,100.031331,4.059094,16.681981,-114.936450,15.060311,14.419046,-112.481428,13.934614,15.253031,-113.619302,15.002015,15.515278,-108.841890,13.176902,15.586965,-114.201362,14.936393};
			return value;
		}
		private double[] getCoordinate_9_21_point_144()
		{
			double[] value = {15.776791,-108.854867,13.858720,15.804198,-111.044772,13.328251,15.911948,-114.204351,15.078677,15.913682,-107.940333,12.382150,16.050814,-107.252217,13.625589,16.144952,-108.082212,12.537782,16.149048,-110.957824,13.648533,16.209968,-111.216910,13.506904,16.294086,-108.891398,14.314845,16.435375,-109.643113,14.714609,16.617451,-110.522802,14.572947,16.663273,-112.070963,14.962230,17.695644,-109.041915,14.188674,17.980225,-110.824874,14.837050,18.020045,-109.646797,14.542181,18.037711,-112.114507,15.546616,18.082720,-107.676254,14.921655,18.084725,-107.906198,14.991137,18.117261,-110.695893,15.217958,18.130226,-107.946003,14.899176,15.684782,-102.723008,13.114193,17.196451,-102.007772,14.604922,14.397840,-78.039029,10.618619,14.671083,-78.123840,11.384131,16.152719,-78.010636,10.928472,17.119456,-78.444879,13.254532,17.535610,-77.641571,7.223601,17.816204,-78.172590,11.685613,18.317814,-78.758344,15.372957,18.449727,-78.191774,12.293305,18.544747,-78.359763,13.272603,18.742376,-78.003378,10.619611,18.798901,-77.993453,10.007565,19.260583,-78.441755,14.038562,19.431143,-78.155080,11.760565,22.048642,-78.019567,11.233085,22.364769,-78.323509,15.388258,24.123977,-77.873603,10.972021,22.450577,-64.214980,5.360368,22.873395,-65.395261,5.312307,22.983813,-65.403557,5.392166,23.647875,-65.124887,6.144829,24.597119,-64.797775,7.002823,14.329767,-55.385028,12.733112,14.430037,-55.074685,12.874339,14.455534,-58.036842,11.539998,14.590704,-58.811447,9.735552,14.693138,-52.739813,9.869429,14.763411,-58.943048,9.565102,14.854393,-58.790921,7.891238,15.002220,-55.965763,13.047438,15.004273,-55.850386,13.026948,15.039924,-57.707306,12.144737,15.108456,-58.116144,11.870854,15.184581,-58.870165,10.849970,15.228006,-59.198790,9.400728,15.241782,-51.579922,9.229335,15.584450,-56.013984,13.460011,15.977500,-54.438266,12.751455,16.053412,-57.335638,13.413942,16.186593,-56.235177,13.685707,16.216582,-55.705984,13.497711,16.742630,-59.689269,9.980207,16.753388,-56.683655,14.081494,16.977784,-57.877103,6.032785,17.182215,-59.646981,11.186940,17.305860,-56.666392,14.451592,17.623459,-59.104496,12.630815,18.032393,-57.285292,15.252859,18.093361,-52.658906,9.259326,18.130811,-56.539471,15.021232,18.166256,-56.314184,14.666014,18.173263,-59.723204,11.045802,18.248997,-56.130554,14.560103,18.369118,-58.068858,5.632248,18.605923,-59.408897,8.709366,18.695103,-60.222279,10.690742,18.781545,-52.860659,11.364501,19.018726,-60.252769,11.243897,19.087837,-60.304201,10.381860,19.123869,-52.326026,9.506571,19.230053,-60.294236,10.250510,19.289505,-60.381531,11.671149,19.780841,-54.755525,13.790577,19.787730,-60.534017,11.610659,19.808230,-59.164623,15.183259,19.818492,-59.435341,14.808273,20.154997,-54.692928,12.749658,20.161774,-60.166432,13.812788,20.196964,-53.196774,11.318574,20.380897,-51.519559,10.002346,20.533387,-51.573697,10.748721,20.594496,-59.582623,5.644103,20.797408,-51.561115,8.650117,21.028035,-60.822336,11.968098,21.058572,-59.489618,8.720012,21.063972,-60.430629,14.469618,21.236432,-60.892378,12.505076,21.240761,-59.210855,7.863875,21.251873,-52.613904,11.048378};
			return value;
		}
		private double[] getCoordinate_9_21_point_145()
		{
			double[] value = {21.520574,-53.703277,11.320929,21.763842,-60.066796,10.648757,21.984820,-59.549282,7.088035,22.116365,-53.530012,13.026053,22.289781,-60.727571,15.304151,22.551061,-60.787671,15.335703,22.617032,-60.220450,11.339882,22.666903,-59.627538,8.011100,22.793364,-59.637181,8.925461,22.885579,-52.403109,10.748708,23.595976,-53.050549,13.201193,23.663635,-60.168164,11.862496,24.071137,-52.824968,14.346611,24.156474,-52.837676,13.313437,24.256482,-51.550861,10.570736,24.381556,-51.851915,11.457910,24.697216,-60.546432,8.754576,14.325213,-50.992031,10.387315,14.927398,-51.268317,9.721333,14.958430,-50.145610,9.627310,15.626453,-48.448169,7.229939,16.209751,-48.423103,7.169903,16.864043,-49.303236,7.690798,17.080638,-47.431200,5.236139,17.316843,-50.101021,7.541131,18.165618,-50.645329,7.261099,18.299868,-51.131824,7.345051,18.791718,-48.465559,5.268114,19.082351,-50.839828,6.858419,19.094343,-50.454132,6.673765,19.188072,-50.643540,6.694548,20.050490,-50.402869,6.172019,20.574266,-50.158840,5.994144,21.026244,-51.441107,8.270562,21.286082,-49.739755,6.058651,21.500326,-51.141424,8.077145,21.502674,-49.974038,6.651092,21.726128,-50.552676,7.087791,21.774005,-50.965463,7.971061,21.929963,-50.851105,7.883327,21.989110,-50.582928,7.202001,22.389252,-50.477473,7.933759,22.481061,-50.417006,10.449253,22.540638,-50.366515,7.546268,22.813706,-49.608081,6.453012,22.863409,-49.791233,10.108968,23.334685,-48.855148,8.992936,23.696339,-49.237661,9.955228,23.857454,-48.061948,8.509509,23.988179,-48.654625,6.358682,24.013666,-48.000075,7.689599,24.410006,-50.580888,10.253646,24.541253,-48.394818,9.374442,24.543300,-46.859232,6.607516,24.635930,-46.798639,7.081765,24.722763,-46.705882,7.130282,15.220802,103.478793,7.828779,16.602150,103.677892,12.883573,18.044695,103.168390,10.373164,18.070205,102.037686,6.250547,18.147734,102.141124,5.552445,18.552007,102.810315,9.084536,19.928530,102.125777,7.074626,20.446001,101.984563,7.416134,20.794164,101.103303,5.764441,21.117739,102.314929,11.009789,23.019478,100.689551,5.697447,23.060559,101.615229,10.785142,23.724874,100.717102,6.365117,24.120357,101.415011,13.014364,24.632551,100.423679,6.354088,14.403676,-139.172085,20.388732,14.752839,-139.909697,20.458784,14.783002,-139.172509,20.691257,16.633923,-137.153897,23.376914,16.794027,-137.182865,23.542376,17.215461,-137.974543,23.569023,17.388316,-138.699168,23.063991,17.684779,-141.850948,23.834332,17.862899,-136.981762,24.503411,18.202895,-141.754249,24.425535,18.482997,-136.689618,25.059398,18.639361,-141.777433,24.358803,19.492777,-141.101343,24.951001,19.639685,-141.521812,25.871369,19.654667,-139.139987,24.818755,19.684269,-141.636418,25.259460,19.929328,-140.820236,25.299657,17.092761,-131.682657,22.558201,19.587792,-124.968085,22.891405,20.357781,-125.744687,23.855835,20.609780,-131.538763,25.799876,14.714499,-122.296744,17.453380,15.209853,-122.935875,18.152369,16.250188,-115.990630,16.641442,16.747626,-115.490096,16.125755,17.489205,-121.235458,19.629297,17.514958,-115.088353,16.980340,17.579788,-114.686596,15.759952,17.748007,-114.648219,15.952619};
			return value;
		}
		private double[] getCoordinate_9_21_point_146()
		{
			double[] value = {17.772613,-114.593952,16.775003,17.853660,-114.225777,15.950659,19.338372,-116.186736,19.478762,19.343976,-116.863770,19.725129,19.349298,-115.170492,18.547540,19.363304,-115.473768,19.167516,19.434164,-121.499311,21.497982,19.469433,-114.697503,17.983059,19.801526,-115.962119,19.807964,19.903900,-115.325440,19.678842,20.022245,-115.101135,19.056428,20.275212,-114.888056,19.325067,20.377288,-114.864031,18.764456,20.588097,-124.476008,23.650421,20.771414,-114.539090,20.198265,21.446633,-121.011460,23.139999,21.916309,-118.790028,22.721431,24.096291,-114.581305,23.024458,24.514026,-116.970543,24.446029,17.669441,-113.907266,17.003980,17.809420,-112.090832,16.164659,17.914856,-112.792938,15.986084,18.043648,-111.365892,16.768589,18.246640,-112.067424,17.132748,18.960071,-106.914167,16.437542,18.992693,-108.508630,16.727540,19.132694,-110.363751,17.231128,19.293615,-105.325951,16.445400,19.345146,-110.693269,17.239855,19.526144,-111.258735,17.235950,19.753072,-106.854769,16.589330,20.061458,-109.775923,16.621507,20.233996,-109.440648,16.520695,20.238204,-106.952786,16.557638,20.447089,-108.494703,16.339780,20.447494,-104.514562,17.334917,20.534706,-113.040993,18.955991,20.571756,-106.808056,17.088754,20.599602,-111.153763,17.176578,20.608662,-112.581805,18.627821,20.650683,-112.991095,18.056316,20.749997,-106.981324,16.843364,20.805750,-111.261286,17.546046,21.076248,-111.740550,19.123802,21.161832,-107.085273,18.338165,21.557111,-108.766504,17.325715,21.880386,-109.364543,18.367778,21.886686,-109.471575,18.571650,21.978423,-109.963293,19.104819,22.180615,-110.223473,18.947448,22.282936,-110.174848,19.636752,22.286307,-110.368212,19.508768,22.322105,-110.690020,18.599361,22.370363,-104.976444,19.019776,22.469209,-109.143369,19.906083,22.895459,-110.293799,19.460277,22.934257,-112.250515,20.502039,22.955166,-108.985432,19.882998,22.986998,-110.174975,19.468414,23.011985,-108.491663,19.992535,23.075547,-107.759036,20.071702,23.235640,-108.515067,19.908275,23.271152,-108.878977,19.780497,23.336106,-111.249245,20.867866,23.821213,-113.445874,21.874714,23.941448,-113.068659,21.701104,24.021877,-106.626986,20.081960,24.114291,-109.788026,19.853678,24.305275,-109.643201,20.076884,24.487653,-106.482457,20.149962,24.548920,-112.986448,21.532844,14.323371,-99.800306,17.157316,14.986178,-97.833553,20.028572,16.214920,-94.187414,23.534180,17.663821,-100.831104,17.321611,17.913353,-99.921574,19.291568,18.401008,-98.850825,21.201378,18.734551,-97.787588,22.747201,19.208625,-94.548241,25.621861,19.428696,-102.334918,16.187456,19.571048,-102.373769,16.309732,19.702528,-101.359851,17.162797,19.752275,-94.903509,25.821928,19.927570,-99.552714,21.159164,20.141545,-95.998758,25.395681,20.977703,-99.319894,22.206002,21.801071,-103.006843,18.273801,23.309536,-101.178046,19.576646,24.364687,-101.052454,20.416741,14.358434,-87.600292,23.374333,14.685816,-86.641215,22.345566,15.174002,-87.267579,23.828175,15.329669,-87.072777,23.702406,16.538911,-90.438324,24.682611,16.547809,-87.920040,25.281130,16.626867,-87.172679,25.097512,16.882611,-87.581834,25.565164,16.909644,-88.944881,25.013810,17.360757,-90.989215,25.288080,17.450985,-86.777181,25.341541};
			return value;
		}
		private double[] getCoordinate_9_21_point_147()
		{
			double[] value = {17.503869,-89.340366,25.415306,17.782641,-86.452541,25.122196,17.981667,-84.690229,24.035574,18.244334,-92.497755,25.685955,18.451562,-85.948819,25.242622,18.548640,-85.839866,25.253553,14.360534,-79.810048,15.997682,15.050112,-80.903246,18.304612,16.157702,-81.215647,19.615210,18.182562,-79.441352,18.200639,18.202907,-79.973886,19.571905,18.448355,-80.307278,20.438822,19.648408,-79.072046,18.189334,19.676240,-80.396248,21.970485,20.025338,-79.293753,19.664148,20.392080,-78.741515,17.246681,20.626692,-79.116485,19.675990,21.434444,-79.664332,22.387902,21.799131,-78.994918,20.331001,22.375612,-78.522078,17.093657,22.944782,-78.631512,19.502839,23.043389,-78.666494,19.829572,23.697703,-79.918537,25.680739,18.903160,-57.470329,16.064531,19.068644,-56.918413,16.485842,19.335057,-57.646190,16.803927,19.337203,-56.140301,15.729920,19.425555,-57.334536,16.918630,19.435152,-58.663022,15.705963,20.115280,-56.474614,18.076725,20.279610,-58.198778,17.538994,20.476997,-57.336392,18.367349,20.674778,-57.061372,18.680670,20.767289,-59.095894,16.622152,21.008004,-58.298892,18.061024,21.275552,-59.760722,16.164105,21.305119,-58.296637,18.565085,21.491225,-55.983276,19.800246,21.721646,-59.553357,17.132977,21.734106,-54.985339,19.147643,22.005856,-60.072350,15.998475,22.138299,-55.882820,20.349828,22.267065,-59.406003,18.100447,22.291998,-56.051387,20.494976,22.711872,-59.809145,17.607043,22.831047,-60.450146,16.433467,22.909718,-59.495406,18.379915,22.944608,-60.527183,16.422842,23.072015,-60.366211,16.768808,23.290936,-60.399970,17.114571,23.398971,-56.073512,21.411517,23.412249,-58.269750,20.025979,23.643002,-58.110896,20.301462,23.698967,-55.559235,21.554974,23.965877,-59.979551,18.235046,24.014161,-55.409073,21.895648,24.051204,-59.020096,19.654783,24.081028,-57.907428,20.775054,24.182829,-55.855670,22.229589,24.214407,-60.545560,17.437807,24.272740,-57.401819,21.289164,24.378975,-55.341452,22.506296,24.398318,-60.310704,17.886789,24.538285,-60.474205,17.492665,24.602585,-60.286696,17.941153,24.618792,-52.233344,15.616499,24.639554,-60.512737,16.696141,24.655379,-60.205132,18.209532,14.352424,103.400257,25.524211,14.463627,103.451605,25.008921,14.512334,103.341190,25.421184,14.560200,103.346614,25.278633,16.362698,103.059562,24.199273,17.039121,102.687177,25.225297,23.702495,100.016497,25.763196,24.173055,100.915289,19.374201,24.284675,100.520436,22.266110,14.347901,-141.133806,27.255026,17.629644,-139.724255,35.296701,17.745222,-141.184975,27.434605,19.534567,-140.385698,31.984745,20.844325,-140.351100,32.346776,21.730133,-141.351832,27.068395,21.771853,-137.893483,27.085254,22.172239,-136.285346,28.372594,22.394509,-140.344813,27.433814,22.658080,-140.897418,27.791154,23.167850,-138.615389,27.891223,23.400658,-138.785465,28.095269,23.481757,-140.075025,28.367600,23.998655,-136.921154,29.681030,24.220197,-140.989427,29.356409,22.484239,-128.165116,26.551217,22.617114,-127.693708,26.524975,24.404764,-132.412144,29.466455,20.346011,-94.934458,26.237925,21.658989,-94.175955,27.670009,22.903721,-95.966489,27.442545,23.237303,-95.327229,28.182436,24.218785,-94.287687,29.645855};
			return value;
		}
		private double[] getCoordinate_9_21_point_148()
		{
			double[] value = {18.426317,-89.010917,26.191273,18.775925,-87.204513,27.109735,19.079813,-88.620231,26.834393,19.700883,-87.253069,27.953890,19.945286,-87.503457,28.154642,20.212774,-87.366685,28.407053,20.345833,-87.250228,28.525007,20.760748,-86.100495,27.705570,20.795824,-86.041079,27.640420,20.880249,-87.852090,28.732835,21.026820,-87.435536,29.087232,21.073818,-87.330762,29.162817,21.402813,-89.045813,28.601086,22.067394,-92.971812,28.513503,22.245106,-86.959969,30.234078,22.338580,-88.515338,29.479027,22.873183,-86.365140,30.511346,23.076146,-86.387905,30.733401,23.291062,-84.819238,29.083609,23.573091,-87.049048,31.344975,23.952973,-87.085674,31.644045,24.477608,-86.094866,31.878458,24.695517,-85.442171,31.067740,22.291671,-82.599418,26.691734,22.828079,-81.470991,26.425627,23.650175,-82.113461,27.741035,23.882405,-80.456240,26.464367,14.460833,102.623775,28.864283,14.653253,102.057935,30.884266,15.473919,100.545653,34.284149,15.827323,101.394747,31.993164,15.830113,99.935971,35.068838,16.679381,100.940213,32.561900,16.799806,100.900616,31.569702,16.930256,100.648672,33.263747,17.538695,100.336738,33.588623,17.759107,100.553315,31.744672,17.843030,100.301971,32.278286,17.909691,100.474287,31.887715,18.398583,101.380209,28.488248,18.433875,99.590816,34.735871,18.621775,101.718946,26.095096,18.687217,101.300120,27.402884,19.187667,99.892645,32.416166,19.239065,101.667162,26.115174,19.472463,100.033656,31.529873,19.747523,99.572070,32.343375,20.587727,98.214868,35.583154,21.169415,98.189443,34.199049,21.304207,99.353897,31.137217,21.553754,97.189056,35.671097,21.579826,97.139695,35.750203,21.646126,99.236011,31.110573,21.847934,99.672304,29.347474,21.895452,100.420318,27.276830,21.970782,98.139141,33.904661,23.308007,96.543625,35.857679,23.482111,99.029971,29.226416,23.765588,97.930610,31.007793,24.166237,96.050339,35.538560,24.176661,97.488631,32.109666,15.621284,-138.140320,43.569636,16.805440,-138.115317,43.863145,16.838559,-139.170960,38.174487,18.590758,-138.037700,44.521238,22.524882,-139.503450,37.143046,23.705708,-138.578788,42.288286,24.724648,-138.798080,41.242093,21.030716,15.170509,46.751468,21.931708,15.559115,46.207468,22.296500,15.517572,46.100332,22.463402,14.562518,46.288257,22.652626,14.194748,46.388910,23.468133,19.291500,45.559101,23.888897,15.244761,45.899107,24.126353,15.676446,45.457895,14.471671,94.615605,42.791765,16.055458,94.724541,42.074620,16.567866,94.248055,42.675153,16.758216,93.571793,43.536407,17.719546,93.679388,43.214201,18.525546,94.576825,42.338923,19.021445,93.121778,43.161128,19.234249,94.051167,42.199468,19.347820,89.105330,46.216660,19.715083,91.514611,44.084563,20.088460,92.514278,43.191029,21.997052,94.512181,39.353461,22.079514,92.105679,42.326030,22.526711,87.831165,45.975924,22.649144,93.940237,39.966474,24.034462,89.547808,43.657886,24.154865,92.898869,40.021096,24.672977,87.324359,45.538817,14.963205,97.377128,39.165242,15.066024,99.456559,36.634630,15.379024,96.140769,40.504202,15.554685,95.912239,40.753550,15.661940,98.462362,38.054031,16.003512,97.350851,39.549328};
			return value;
		}
		private double[] getCoordinate_9_21_point_149()
		{
			double[] value = {16.404632,96.706811,40.275060,16.733344,95.399133,41.614488,17.511998,95.162553,42.001922,18.500377,97.759662,38.175934,19.323604,97.816817,37.657762,19.656949,97.933966,37.193834,19.682523,95.668652,40.657539,20.791464,96.401098,38.611090,21.279529,96.371901,38.038572,22.104067,95.214940,38.315086,23.200402,95.682357,37.346089,14.462258,-136.228560,53.724257,15.725019,-136.712302,51.284970,16.966719,-135.716125,56.823650,16.980340,-136.525162,52.462219,18.761751,-137.113180,49.529889,18.978551,-136.793914,51.280844,20.195702,-136.857038,51.103293,20.212374,-136.789270,51.471168,21.103813,-136.859559,51.211678,21.240489,-137.578762,47.351079,23.619861,-137.630752,47.389760,24.380865,-136.400616,54.125719,24.300726,-20.169022,53.555654,24.679858,-20.331841,53.743423,17.731564,-10.392281,56.909489,18.776583,-12.003951,55.748935,19.066594,-12.424172,55.421025,19.104113,-11.583445,53.739115,19.455720,-12.313719,53.830932,19.470190,-13.033277,54.719800,19.598542,-11.516658,51.999784,19.869604,-13.357625,54.119765,20.035152,-11.949260,51.883364,20.064885,-13.021906,53.300963,20.082694,-10.739680,51.491340,20.088020,-14.065843,54.785639,20.098633,-9.856193,50.829881,20.454390,-9.951672,50.624291,20.560628,-10.731494,51.295072,20.593948,-14.412505,54.024572,20.727372,-15.136596,55.502314,21.099108,-13.773387,52.901857,21.119378,-14.339595,53.139462,21.137595,-15.583381,54.937221,21.357216,-14.197105,52.788371,21.495172,-12.538203,51.881475,21.496387,-16.062401,54.599990,21.516483,-12.789499,51.925083,21.843268,-16.623059,54.039109,21.865735,-16.770634,54.410104,22.065200,-10.816919,51.055675,22.103286,-17.111263,55.127240,22.301808,-17.305458,54.682952,22.318343,-15.358977,52.769992,22.368030,-16.765999,55.999561,22.442659,-17.358291,53.572105,22.487673,-17.334003,53.474960,22.792721,-17.625047,53.138797,23.108991,-17.422291,56.161084,23.222234,-11.928703,51.377277,23.291832,-17.088345,52.098780,23.459049,-10.388708,50.734259,23.511702,-19.039408,53.997344,23.648645,-17.767187,51.883974,23.883254,-17.503439,56.800952,24.040426,-19.065651,54.880341,24.166504,-19.329392,52.047804,24.349099,-19.473904,51.647806,24.635844,-19.909203,54.539698,24.679637,-15.102067,50.998854,15.508957,-0.422729,56.176405,15.833022,-0.271812,55.438823,16.613548,-1.867852,55.341164,17.075339,-3.179149,55.237057,17.259142,0.127546,51.328721,17.303847,0.099819,51.247977,17.645219,-1.536670,51.436882,17.720750,-3.610972,52.600015,17.857454,-4.897580,52.914626,17.884974,-3.915022,52.103828,17.901228,-1.032649,50.692569,17.914425,-1.306127,50.773028,17.997715,0.210266,50.188793,18.001181,-9.449052,55.219032,18.085449,-2.506942,51.105958,18.265201,-4.178419,51.270199,18.461019,0.501785,49.778166,18.481781,-7.300842,52.094469,18.775905,-6.485543,51.059661,18.802358,-4.525023,50.615534,18.814047,-5.166273,50.791113,18.874469,-9.693939,52.761937,18.937194,-1.885258,50.395373,19.196161,-9.550055,51.798874,19.394951,-6.336605,50.203638,19.401131,-3.126332,50.138619,19.535661,-0.204661,49.597321,19.910276,-0.856867,49.596674,20.006821,-7.554318,50.315645};
			return value;
		}
		private double[] getCoordinate_9_21_point_150()
		{
			double[] value = {20.175618,0.712987,49.495304,20.777654,-3.159747,50.045102,21.376183,-2.066403,50.068616,21.745887,-6.650012,49.760610,21.758759,-1.979898,50.070975,21.805396,-0.399697,49.975723,22.048543,-5.948754,49.779416,22.417158,-2.942248,49.740305,22.485332,-9.065770,50.682436,22.495804,0.606029,50.034660,22.504006,-6.467494,50.071434,22.658881,-0.544963,49.950552,22.791746,-8.694082,50.648011,23.076953,-5.959728,50.150864,23.246763,-6.410389,50.317730,23.698047,-7.093186,50.453026,23.720202,-4.192103,49.797871,23.885066,-4.777705,49.886041,23.933157,-5.884315,50.186786,23.993787,-4.612186,49.799769,24.109521,-1.662450,49.022915,24.156042,0.685070,49.705122,24.545238,-7.623182,50.207570,24.559581,-4.659994,49.734835,24.579815,0.647296,49.377729,14.818331,1.116229,56.008761,14.965134,3.145121,54.200863,15.099016,3.286941,53.908495,15.498297,4.485315,52.576258,15.900635,1.592936,53.426090,16.106503,3.472812,51.773780,17.256365,2.003261,50.565873,17.324412,10.508957,49.522036,17.510866,2.474862,50.133546,17.869566,8.299765,49.127769,18.267639,2.889740,49.439195,18.779083,4.403537,49.143597,18.856576,9.408396,48.428787,19.264034,10.729501,48.097970,19.327592,6.186319,48.904783,19.386066,8.222377,48.557677,19.635050,2.541609,49.170246,19.645676,10.635793,48.098131,19.665420,0.848280,49.337938,19.667158,0.943410,49.314357,19.779215,4.775252,49.242696,20.804595,1.505797,49.593981,20.945029,4.092936,49.531167,21.317901,8.381682,49.034734,21.441619,9.279209,48.950451,21.622581,5.595537,49.585722,21.922616,5.527304,49.626880,21.977735,6.459007,49.600853,21.982624,3.055369,49.722217,22.244750,10.253445,48.750481,22.286748,6.695335,49.641930,22.675863,6.629437,49.632682,22.740580,9.300837,49.159417,22.787830,3.685906,49.691307,22.842489,8.492114,49.437625,23.082664,3.622801,49.777093,23.236176,0.951582,49.883587,23.336870,6.512605,49.666264,23.449835,3.228210,49.826442,23.555264,3.431818,49.802989,23.625526,9.371894,49.219896,23.730584,9.647664,49.158398,23.861803,10.567645,48.921671,24.208728,6.810778,49.483885,24.590077,5.396454,49.464347,24.706235,3.239250,49.767478,14.622377,18.021293,54.151300,14.770045,17.189605,53.890849,14.794728,14.347399,53.496768,15.565875,12.130161,52.176949,16.976352,17.521516,51.513708,17.001175,11.226807,49.912516,17.370977,13.049055,49.872895,17.698492,14.675882,49.829673,17.840593,15.590291,49.829768,17.945657,18.665459,50.851554,17.988415,12.839721,49.121733,19.849573,11.663367,47.818917,20.459202,19.841999,48.471480,21.098292,14.097313,46.927144,21.588097,12.500416,47.526033,22.213604,13.656979,46.831197,23.950872,11.592481,48.635372,17.246243,23.234639,54.826954,17.601273,22.753989,53.967254,18.089351,25.203236,55.732291,18.673969,25.657127,55.001386,19.714001,28.394335,56.543005,20.634337,21.999945,49.875296,21.023672,29.780808,55.112224,21.053026,22.486174,49.708442,21.306172,30.249771,54.421896,21.881646,21.655786,48.111441,22.197907,31.772655,54.370916,22.440238,22.969926,48.394731};
			return value;
		}
		private double[] getCoordinate_9_21_point_151()
		{
			double[] value = {22.528655,28.217535,51.492840,23.023058,24.378319,48.848552,23.194363,29.164232,51.528861,23.285153,30.705497,52.362168,23.731434,27.838529,50.412947,23.832819,22.179578,46.896168,23.893211,27.977542,50.413919,24.204367,31.097714,52.124029,24.488281,29.279356,50.946441,24.499632,23.652997,47.527936,22.032175,32.997695,55.601138,23.100526,35.453350,56.306944,23.284992,33.349229,54.402800,23.483605,34.102690,54.972954,24.403607,36.938046,56.896840,24.583873,37.692369,57.124936,23.718701,72.251487,55.918821,23.854925,73.789003,54.795071,24.708621,73.237066,54.934449,15.028275,80.485805,54.480340,15.427096,78.662393,55.536057,15.445843,78.363606,55.771750,15.619201,77.141715,56.723587,15.738578,79.722232,54.387562,15.774518,78.994315,54.848454,16.565138,79.552972,54.212101,16.628833,81.775498,52.679362,17.097221,79.058570,54.699089,17.333217,76.933969,56.214771,17.921626,84.220816,50.752375,18.315369,79.518712,54.292922,18.389252,77.664113,55.934286,18.846847,77.612483,55.798535,19.125096,77.590821,55.745469,19.808236,80.010945,53.253859,20.005913,77.625252,55.122020,20.174135,77.734397,54.825772,20.601004,82.398275,51.366787,20.923373,75.791499,56.634800,21.027341,79.746761,53.191726,21.913462,74.816232,56.608228,22.886458,74.234038,55.814124,22.897681,78.372563,52.814653,22.935541,79.467645,51.939921,22.962550,77.038394,53.553364,22.967730,75.524046,54.427247,23.106706,81.099520,50.713319,23.198894,81.090776,50.690951,23.231062,76.196608,53.902673,23.557746,81.479197,50.386620,23.822608,76.235778,53.743043,24.472190,75.189727,53.942642,24.544031,81.798251,50.213842,24.686170,74.187021,54.490265,14.297610,87.540622,48.870858,15.774636,89.543328,47.056835,17.730040,87.234930,48.403043,14.316155,-135.185531,59.329971,22.803792,-135.475767,58.901798,16.511823,-134.667001,62.420445,21.135643,-135.024728,61.111091,23.455923,-134.338446,65.122908,24.414156,-134.386077,64.994674,21.961596,-77.908924,67.415736,22.709183,-75.941924,67.329544,23.203667,-77.861478,66.317227,23.530480,-79.610829,66.466917,24.215715,-73.708676,66.487785,24.398967,-74.971255,66.007834,24.496328,-77.557962,65.354567,24.707725,-79.338637,64.687827,17.763178,-10.460906,59.521390,17.863831,-10.426952,61.997239,17.878011,-10.351907,61.439335,17.882315,-10.861754,59.489031,17.926800,-10.884373,59.005022,17.996477,-11.248856,58.582471,18.089551,-11.340792,59.056895,18.154403,-11.147184,60.157078,18.294754,-11.264377,59.434703,18.592571,-11.043784,61.429683,18.811025,-11.444928,60.085856,18.876813,-11.832103,58.049630,19.301977,-11.213238,61.792041,20.157647,-11.105057,62.657891,20.161003,-12.824329,58.428096,20.338978,-13.166650,58.478026,20.453816,-11.865047,60.650449,20.764504,-13.961090,58.205638,20.977257,-12.526656,60.144639,20.991490,-13.314037,59.201329,21.032516,-13.571418,58.846080,21.260766,-13.600102,59.198710,21.285881,-10.319551,63.509708,21.390249,-13.793506,59.206454,21.445110,-13.587221,59.746381,21.522950,-12.384132,61.061971,21.572883,-14.214821,59.047988,21.805977,-14.911825,58.446488,21.883427,-15.080839,58.256245};
			return value;
		}
		private double[] getCoordinate_9_21_point_152()
		{
			double[] value = {22.024994,-15.336538,57.782306,22.091041,-12.805584,60.697376,22.332266,-11.871322,62.195909,22.922545,-16.400940,57.399137,22.991020,-14.681593,59.927449,23.086657,-12.530887,61.603804,23.705963,-16.244352,58.613900,23.924224,-16.491409,58.449727,24.022299,-12.414271,61.115034,24.118283,-10.273524,61.448609,24.135053,-16.000455,59.336767,24.419038,-16.317436,59.206750,24.496620,-10.487187,61.228505,14.294448,-7.017883,66.681839,14.550970,-7.172833,66.557909,14.660855,-7.203562,66.736670,14.962968,-7.722127,65.226649,15.100155,-7.444074,66.987759,15.173224,-5.503886,60.673008,15.287713,-7.492442,66.959621,15.339509,-3.627205,58.902313,15.551373,-7.536793,67.105062,15.598021,-2.689258,57.971973,15.710580,-8.232045,65.143701,15.973838,-8.487980,64.254813,16.041935,-6.111721,60.038485,16.145574,-8.733730,63.953203,16.183166,-6.795178,60.424084,16.387567,-8.368470,65.598649,16.441464,-8.797627,64.209210,16.753725,-7.612650,67.304089,16.831558,-9.196235,63.689168,16.924389,-7.724470,59.820872,16.991427,-8.602253,65.770893,17.010084,-5.101413,57.386692,17.423613,-7.146636,57.164147,17.435527,-8.634372,65.919245,17.451213,-9.113044,65.003144,17.611588,-8.746094,57.454018,19.124434,-7.030346,66.342124,19.413076,-8.689312,65.513486,19.817528,-4.672445,67.246682,19.933499,-7.188877,65.822525,20.987081,-2.731420,66.843215,21.281392,-2.099195,67.383319,21.667702,-8.528840,63.715007,22.147235,-2.029172,67.097567,22.421968,-4.258086,64.546584,22.793541,-4.874517,63.902330,22.920946,-3.411708,64.470622,23.343232,-3.766067,63.908233,23.775629,-2.446014,67.223643,24.045060,-2.644332,64.979814,24.458741,-4.511888,62.879417,24.616353,-2.962459,65.759559,14.433420,29.998597,62.733302,14.883733,31.305325,61.774152,14.904347,27.799379,61.513017,15.114840,31.358385,60.988924,15.117507,25.283350,59.293606,15.310398,23.820541,57.410186,15.312396,24.231824,57.889234,15.332826,27.682018,60.944877,15.545259,29.491027,61.037931,15.740339,26.906251,59.654646,15.770112,27.085005,59.842145,16.439607,29.290309,59.115120,16.657181,30.357179,59.372132,16.810578,30.815255,59.776775,17.059884,30.683578,59.708815,17.217791,29.657877,58.783500,17.751488,29.290923,58.460006,18.367053,31.747392,60.237883,18.905810,29.256728,58.465349,19.537131,28.649022,57.330305,20.517207,30.906035,59.200569,14.317125,34.073179,62.296085,14.537430,42.503734,66.540426,14.597122,36.654403,63.576780,14.652226,33.675711,61.669683,14.829925,32.658946,61.306304,15.449253,40.734766,65.312887,15.514393,36.100011,62.646919,15.628388,35.516327,62.376717,15.669310,35.389858,62.332916,16.297358,39.105924,64.510327,16.340644,39.190180,64.517527,16.399460,40.318466,64.861885,16.547636,33.799551,61.862329,16.599474,39.728841,64.506776,17.023871,32.295175,61.165244,17.071595,37.771364,62.735652,17.130002,33.515304,61.672116,17.325201,33.266099,61.431328,17.392678,40.658530,63.106755,17.483364,37.994382,62.504166,17.623316,42.377964,63.465577,17.646466,37.069218,62.255282,17.762333,32.732693,60.926548,18.068237,34.372500,61.667569};
			return value;
		}
		private double[] getCoordinate_9_21_point_153()
		{
			double[] value = {18.319829,41.998712,61.683899,18.497262,40.960926,61.856041,18.736265,33.252365,61.278728,19.110132,39.491298,61.561588,19.218945,37.019081,61.443959,19.253520,39.494455,61.250949,19.324904,40.342255,61.347130,19.372916,32.209840,60.653807,19.390043,35.751430,61.470230,19.440576,41.239848,61.306772,19.449371,35.717520,61.343488,19.498744,41.202757,61.213244,19.498970,35.601806,61.306951,19.504168,36.179858,61.103417,19.600030,38.923965,60.164580,19.611122,38.694044,60.041174,19.886439,34.950248,60.732403,19.956586,35.144596,60.516508,19.975531,33.837299,61.063320,20.043642,38.115575,59.440475,20.101249,40.940272,60.373445,20.638627,32.778437,60.215985,20.683025,40.867973,60.162173,20.772005,33.080878,60.176283,20.948584,33.385625,59.855628,21.099522,39.220834,59.228715,21.159929,32.714685,59.625549,21.267549,41.851813,60.160489,21.558511,33.164406,58.259681,21.618872,33.003403,58.008897,21.845010,32.356163,57.295451,22.385400,41.411507,59.675545,22.580621,39.199571,58.437671,22.781750,39.630433,58.437863,22.868760,39.799081,58.447687,23.408551,37.631422,57.357807,14.407860,45.209411,65.814970,14.485808,52.176709,63.040445,14.487369,43.056099,66.512006,14.538828,47.232002,65.002785,14.792190,47.552161,64.542832,14.876758,47.693813,64.394563,15.098918,50.431547,63.060458,15.729567,49.799660,63.024680,15.730859,49.441372,63.155446,15.877173,45.635473,65.332629,16.033473,44.625913,65.657051,16.339599,48.167394,63.770105,16.432273,43.291733,65.192176,16.646994,46.598405,64.439502,16.877964,50.879698,62.592786,17.283244,48.989894,62.792068,17.506374,45.902766,64.101104,17.687251,51.102959,62.146053,17.737266,44.305788,63.642199,17.914327,46.972288,63.526660,18.017004,51.364839,62.052203,18.039510,48.395596,63.025641,18.128641,45.137215,63.508029,18.298688,46.751087,63.187061,18.358904,42.785974,61.913299,18.395553,43.980751,62.705940,18.782499,43.655838,62.011959,18.840209,48.110923,62.899001,18.961357,47.947024,62.764219,19.076760,47.362287,62.484686,19.729328,44.506621,61.714995,20.276215,42.546076,60.634966,20.744289,44.327124,60.946052,21.047297,52.000385,61.651156,21.204800,50.550072,61.812370,21.494596,43.750937,60.638710,21.677793,48.733777,61.543896,21.782262,44.771941,60.659908,22.047663,43.794826,60.625929,22.260975,50.986329,61.775536,22.341128,49.256834,61.434641,22.960401,48.318107,60.449047,23.168338,48.533022,60.412214,23.421509,44.182548,59.686907,23.655800,49.352028,60.241511,23.878541,45.756588,59.768065,14.350192,61.884928,62.599695,14.386776,54.759316,62.487679,15.288342,57.236559,62.375642,15.565176,55.200155,62.336298,16.212679,62.550033,61.885231,16.418496,62.770880,61.684681,16.444413,55.933931,62.246740,16.863942,63.231237,61.579721,17.425694,61.922812,61.985248,17.461907,54.592412,61.968512,17.550545,62.684006,61.570274,17.837929,54.514491,61.858836,18.024361,62.345459,61.590139,18.342128,55.325274,61.906542,18.709240,53.668405,61.953184,19.658236,54.052047,62.194815,19.694576,54.562538,62.195494,19.801791,59.062166,61.604484};
			return value;
		}
		private double[] getCoordinate_9_21_point_154()
		{
			double[] value = {20.060973,58.095431,61.765615,20.124151,59.193424,61.193190,20.397083,57.077190,61.815865,21.149788,54.216598,61.772953,21.184928,56.633152,60.891994,21.294351,61.203423,60.686643,21.538609,54.314332,61.109457,21.538938,54.594920,61.045001,21.751212,58.631145,60.628927,22.068995,54.035646,60.822985,22.071767,55.409057,60.492623,22.382511,57.369084,60.418078,22.452437,62.086737,59.280893,22.471154,57.115489,60.407768,23.136291,59.812510,58.920163,23.374821,57.096790,59.756281,23.650250,61.185693,58.567913,23.918617,54.506107,60.175574,24.064562,60.025896,58.190324,24.348436,59.312000,58.096125,24.524523,57.712384,58.393312,14.286705,72.289735,60.336890,14.388348,64.435627,61.722948,14.810484,68.303118,62.486816,15.193106,63.459057,61.755355,15.297865,63.438025,61.708504,15.910778,64.754934,62.035258,16.204506,70.759850,60.796152,16.225464,65.571947,62.469916,16.852472,68.468736,61.805695,17.051437,64.917151,62.333283,17.210222,64.333626,62.135478,17.226768,68.972243,61.186490,17.286818,72.202696,59.499925,17.317885,68.119738,61.745628,17.407865,72.391542,59.237928,17.749443,72.013435,58.916958,17.975870,67.339249,61.851816,18.038700,64.023356,62.053042,18.220134,66.582094,62.062403,18.268187,71.697005,58.432821,18.374569,70.677392,59.227499,18.621619,69.453643,60.145378,19.067536,65.538718,61.792227,19.086799,72.353340,58.455790,19.087178,66.301945,61.673086,19.097054,68.781029,60.185471,19.186753,68.215070,60.560260,19.325499,63.718597,61.593029,19.424609,68.912147,59.377220,19.471402,64.139336,61.282053,19.588046,69.298353,59.072646,19.626840,67.926042,60.431548,20.075626,64.256546,60.834202,20.535755,66.642939,60.433246,20.883838,73.610722,58.386646,21.028809,69.965864,59.689189,21.199418,63.626800,60.140198,21.329000,64.752072,60.493210,21.464307,70.057888,59.813605,21.649889,69.032199,59.821053,21.756443,72.193084,58.905429,21.851145,66.712522,59.325179,21.943103,69.917644,59.767304,22.066489,66.502257,59.318024,22.244161,72.524539,58.501520,22.459638,68.956218,59.797620,22.749151,66.169504,59.278475,22.760566,63.944209,59.727292,23.344217,67.149837,59.426196,23.473539,71.552185,57.954829,23.978395,67.370984,59.271275,24.003325,70.009604,58.475583,24.243523,68.010915,59.040267,24.420288,65.354314,58.695437,15.079856,76.237517,57.915773,15.143660,75.031420,58.759746,15.873448,75.701537,57.971524,16.567774,73.976276,58.828697,16.578827,74.372308,58.518510,18.941599,74.551433,58.011956,19.102766,75.736305,57.394462,19.449280,74.515228,58.138566,19.513207,75.253757,57.695321,19.622953,74.839219,57.923440,20.226130,73.912069,58.381070,21.843997,73.940421,57.677049,21.901591,74.434910,57.186847,15.364033,-131.873754,77.330838,18.801675,-133.542323,68.793185,20.752257,-133.584973,68.824050,21.006682,-132.741147,73.409219,21.658972,-132.738215,73.512140,22.056901,-132.486578,74.922821,22.252590,-133.573989,69.084470,22.278071,-132.352548,75.675213,23.435227,-132.784894,73.498546,17.806457,-83.588287,76.357885,18.439596,-84.789225,76.777510,18.527862,-83.211924,75.110229};
			return value;
		}
		private double[] getCoordinate_9_21_point_155()
		{
			double[] value = {19.242634,-85.515666,76.646765,20.599963,-85.212329,74.367715,22.008480,-87.661376,77.092102,22.686672,-88.022364,77.071286,14.411616,-76.542245,75.115122,14.873858,-75.702150,74.859980,15.128085,-72.914989,75.352112,15.168046,-74.878370,74.958430,15.263343,-77.911806,75.945776,15.859811,-76.882375,73.551481,16.602060,-72.879236,73.631650,16.795651,-78.594009,74.531858,17.046626,-77.329648,72.314170,17.371476,-79.943707,74.617701,17.486124,-75.650407,72.421772,17.948042,-73.170698,71.954898,17.965263,-80.996401,74.430698,18.072361,-72.862742,71.918141,18.207702,-72.483632,71.953559,18.373780,-77.809778,70.954671,18.675893,-75.596420,71.220187,18.677648,-73.175629,71.523376,19.016567,-73.500090,71.278486,19.421547,-78.574823,70.282308,19.531826,-73.823506,70.647588,19.550983,-73.498225,70.716134,20.013067,-72.707263,70.414850,20.219251,-82.013600,72.296763,20.225375,-72.705775,70.357835,20.404032,-81.951746,72.047277,20.658954,-79.803636,70.549311,20.662856,-82.762909,72.210461,20.696055,-75.499072,69.379488,20.794834,-81.920154,71.568192,20.901585,-79.241385,69.193956,21.087142,-72.993141,69.515832,21.172618,-76.780412,68.687372,21.338041,-75.109892,68.553048,21.937343,-77.225372,67.778012,21.990257,-79.875949,68.919576,22.018406,-79.177027,67.732107,23.569796,-82.132437,68.426916,15.222188,-70.990102,75.619449,15.762495,-71.036103,74.920169,16.008558,-72.319608,74.560101,16.494508,-70.580973,74.446249,17.042178,-68.211714,74.662036,17.047921,-66.381319,75.610403,17.171390,-71.789658,73.520518,17.814689,-71.365144,72.949159,17.829541,-64.336777,77.261302,18.191074,-68.463027,73.550945,18.293153,-70.951674,72.639312,18.572619,-71.469459,72.075688,18.705663,-67.899729,73.423390,18.762105,-70.319130,72.396860,18.978532,-69.851037,72.357802,19.069267,-71.733205,71.694341,19.440018,-66.840687,73.475635,19.571172,-68.979293,72.191309,19.849053,-70.759375,71.267466,20.053395,-65.588417,74.122223,20.138526,-65.033164,74.652586,20.351929,-63.441147,76.821918,20.419602,-63.120122,77.406290,20.520287,-68.253489,71.587929,20.710802,-67.032560,72.341369,21.044928,-70.774673,70.133523,21.525087,-63.907837,75.351867,21.713379,-65.387487,73.171467,22.670312,-72.308631,68.327624,22.696000,-63.116944,75.747953,22.710367,-66.666967,71.056876,22.907759,-67.646005,70.236226,22.932397,-65.645962,71.992682,23.268710,-64.990748,72.491934,23.420843,-67.216843,70.149344,23.502299,-69.605231,68.474934,24.061568,-69.612794,67.941058,24.097185,-69.719845,67.866082,24.454812,-69.793414,67.601412,24.143004,-61.530276,77.579682,24.370924,-61.600488,77.422469,24.398183,-61.383144,77.688408,14.584501,-0.734401,74.590325,14.659308,-0.799692,74.778193,14.928784,-1.142619,72.980465,14.943475,-1.299380,77.855256,14.982170,-6.554047,68.337554,15.037935,-1.299255,77.865178,15.226929,-6.675951,68.235631,15.579189,-1.503343,77.376147,15.672817,-1.494816,77.392308,15.866685,-1.768736,75.228082,16.270297,-1.937539,72.266304,16.778493,-2.378884,72.144246,17.523704,-5.169760,68.692046,17.809752,-2.509861,75.025731,17.905894,-2.430581,74.486129,18.256419,-2.395103,74.805554};
			return value;
		}
		private double[] getCoordinate_9_21_point_156()
		{
			double[] value = {18.466924,-2.298134,75.823057,18.838011,-2.509359,71.101602,18.961731,-1.905209,75.367542,19.138447,-4.136713,68.629931,19.231446,-3.895611,68.846597,19.350820,-4.366415,68.119765,19.730070,-3.374214,68.650957,19.951609,-2.520523,68.984361,20.082361,-0.650115,74.822757,20.115233,-0.523544,74.134886,20.243319,-0.549618,74.920498,20.244744,-0.619122,72.530198,20.701558,-1.692677,68.870984,20.885081,-0.414544,72.510063,20.958456,-0.667485,77.093785,21.215693,-1.630238,68.398552,21.348076,-0.398339,72.831472,21.645878,-0.900389,71.257830,21.898415,-1.391539,69.787236,22.177335,-1.644197,69.113345,22.201443,-0.634386,76.248351,22.727714,-1.181412,77.128317,22.754594,-2.091518,67.568408,23.217167,-1.550029,77.309713,23.262769,-1.646140,77.810500,23.432268,-1.446849,76.681353,23.547888,-0.993494,73.455250,23.577198,-1.540904,76.979770,23.717169,-1.047959,74.116173,23.733071,-1.073957,74.543994,23.814373,-1.129043,73.287931,23.879601,-1.249671,75.857906,23.940733,-1.879938,77.866037,24.073583,-1.351702,71.042934,24.180388,-1.558307,71.474605,24.199469,-1.495732,69.166078,24.394280,-1.802761,75.391703,24.596940,-2.008201,75.962984,24.629771,-2.011269,73.205866,14.592162,-130.525794,84.497050,15.353201,-130.805535,83.090627,16.187226,-129.949782,87.817348,17.084154,-130.533227,84.790809,17.676441,-131.432967,80.018133,19.341324,-131.447236,80.164228,19.908455,-130.396919,85.904550,20.983303,-130.682104,84.510638,21.149289,-130.984207,82.903421,24.576261,-119.300330,86.760006,22.678125,-106.208037,87.858852,23.172301,-105.205924,87.075692,23.763620,-106.534877,86.680735,23.878620,-108.730355,86.962881,20.693987,-97.793855,87.994414,20.758510,-94.509146,87.177257,21.584891,-98.582711,87.230377,21.741057,-101.125635,87.705346,22.125676,-99.048765,86.755370,23.634876,-99.864016,85.247257,23.899922,-102.310966,85.545238,24.560833,-98.486885,83.864320,16.287010,-85.458770,80.962765,17.220417,-85.707026,80.037254,19.105425,-88.222500,87.175052,22.298542,-89.209037,84.291336,23.257989,-89.138367,82.717669,23.692427,-89.535045,82.866432,24.087112,-90.391084,82.760178,24.248959,-89.277049,80.821661,14.280309,-80.991448,78.815066,14.883731,-65.594177,78.059686,14.896256,-62.264699,81.786634,17.514274,-63.306318,78.975641,14.336268,-59.137726,85.644636,15.145177,-57.006662,87.987072,15.328165,-59.757005,84.495722,16.703126,-59.070450,84.844398,16.884360,-61.522154,81.673817,17.379169,-61.469429,81.477831,17.801250,-58.667366,84.908815,17.874022,-58.455158,85.279300,18.041572,-58.630183,84.854709,18.093648,-61.216886,81.580709,18.291157,-57.939089,85.651345,18.300439,-61.687954,80.944377,18.353141,-59.333388,83.794241,18.820133,-61.663753,80.560399,18.992973,-58.745574,84.302180,19.111472,-56.376288,87.526182,19.145382,-59.033889,83.910498,19.529600,-58.723272,84.321179,19.704309,-58.764700,84.175778,19.833363,-59.021766,83.765406,20.052787,-59.104013,83.538080,21.069213,-58.744350,83.585757,21.730008,-58.632622,83.627286,22.105880,-60.559397,80.608104,22.129997,-60.650333,80.480961,22.163102,-61.298097,79.368881,23.162260,-57.953870,84.028307};
			return value;
		}
		private double[] getCoordinate_9_21_point_157()
		{
			double[] value = {23.371748,-58.329820,83.474706,23.400136,-61.449116,78.176037,24.622010,-59.981131,80.346105,22.323280,-9.835653,87.185262,23.359675,-11.198805,87.282475,23.799313,-11.293285,87.184707,23.944257,-11.775031,88.220631,14.369963,-4.494910,84.160196,14.710136,-1.240127,78.938864,14.826274,-4.148790,83.904646,14.884291,-3.143967,82.744359,15.773362,-7.682621,87.285948,15.895823,-7.059046,85.438489,16.025909,-6.308688,83.954741,16.048308,-5.704842,83.566004,16.048870,-6.944892,85.187480,16.314178,-1.555216,79.149351,16.593359,-7.196137,86.229642,16.855960,-3.139281,82.662172,17.051707,-2.258999,80.135237,17.073060,-4.861584,83.336203,17.543420,-5.429332,83.184817,17.627828,-7.029122,85.960007,17.627911,-1.846973,78.889415,18.087943,-3.037084,82.382727,18.282513,-3.082357,82.386424,18.573496,-2.688353,80.998833,18.683718,-2.920481,81.644565,19.455073,-6.210211,83.893563,19.491949,-4.017177,82.648437,20.181689,-7.522671,87.636079,20.282906,-2.213430,78.627057,20.378173,-4.177095,82.382776,20.438289,-5.751719,82.976554,20.906918,-1.107812,77.920698,21.197807,-5.836372,83.069913,21.323510,-7.671275,87.568169,21.890385,-6.732882,85.613391,21.928069,-0.968249,78.341402,21.954049,-3.620040,81.250087,21.978158,-1.848713,79.824342,21.994242,-4.519940,81.793051,22.023087,-7.330309,86.785174,22.073470,-9.082403,87.491601,22.089862,-1.176597,78.888710,22.420748,-7.799575,87.137764,22.524380,-1.095075,78.468138,23.037191,-7.929516,86.827445,23.362210,-1.747772,78.616366,23.562441,-1.942084,79.352784,23.732200,-7.651651,86.266272,23.906157,-7.689663,86.178050,23.946580,-8.640456,86.162267,14.420913,-127.923723,98.506956,16.723209,-128.866850,93.729252,17.104071,-128.783450,94.229937,19.364438,-128.766121,94.626660,19.632336,-125.151298,94.803925,19.660078,-129.170544,92.485092,19.891643,-124.793174,93.923693,20.402325,-125.462975,94.110609,21.050407,-128.907589,94.089477,21.268594,-129.915975,88.680310,21.341077,-129.122640,92.968513,21.536475,-124.966064,91.402157,21.552802,-129.025791,93.519334,21.585351,-124.938269,91.297689,22.235415,-125.113335,90.495243,22.373702,-124.915682,90.159790,22.483034,-128.205128,92.413914,22.622572,-125.524047,90.629036,23.091166,-126.204460,90.970957,23.121829,-129.096633,91.644059,23.310603,-126.845725,91.128240,23.413446,-125.308288,88.976558,23.846106,-129.685430,90.269197,24.027609,-126.090867,89.450590,24.391668,-125.926019,88.558211,24.692504,-125.960393,88.296711,15.088131,-119.869757,97.931939,15.938397,-124.043841,98.602172,16.463866,-124.275021,98.209888,16.989382,-124.108294,96.973429,17.107360,-123.475354,96.264048,17.404304,-121.349895,95.566651,17.440681,-124.167645,96.457651,17.907215,-124.631936,96.602673,18.700710,-122.172248,94.131742,19.004563,-117.521716,93.485293,19.250378,-114.807811,93.025921,19.491237,-124.263451,93.873734,20.359655,-119.467701,91.956050,20.489611,-121.782728,91.941682,21.166460,-118.542365,90.960270,22.084681,-114.968429,89.770404,22.310106,-121.052064,89.681919,23.193959,-122.933281,88.761895,15.001393,-112.725838,97.056698,15.827502,-103.975534,94.526987,15.906667,-103.799516,94.408929};
			return value;
		}
		private double[] getCoordinate_9_21_point_158()
		{
			double[] value = {16.075575,-108.075821,95.143901,16.709528,-107.577936,94.404823,17.278991,-107.634375,93.840644,17.467664,-106.259930,93.366294,17.565358,-108.093489,93.651544,19.810104,-111.257262,91.948958,20.008250,-104.641142,90.371750,20.441284,-109.291805,90.934916,21.882034,-106.921143,88.906884,22.171552,-111.517853,89.378984,22.598742,-109.190189,88.539163,22.919626,-113.520649,88.708318,14.469953,-100.756610,95.250864,15.520480,-102.445905,94.530022,16.870078,-100.485783,92.688833,17.671632,-93.645336,90.287837,18.032059,-101.025380,91.594294,14.432615,-87.222307,92.114185,15.489459,-87.316695,90.696768,15.639299,-91.874138,92.083094,16.200609,-87.479895,89.934911,16.202069,-87.356446,89.121486,18.076986,-88.391284,88.661810,18.104515,-90.068663,89.111683,14.692348,-55.011801,90.962728,15.363933,-51.646143,96.103060,15.688949,-54.215525,91.826608,15.822697,-56.381069,88.537221,15.822930,-52.724850,94.204172,15.973036,-54.204207,91.773379,17.750067,-55.065438,90.019024,18.086481,-52.482023,94.042217,18.167512,-53.564957,92.347068,20.852876,-52.195659,93.843283,20.982398,-54.903709,89.403452,21.521813,-52.507233,93.310916,22.170774,-54.649020,89.503189,22.630599,-52.232399,93.517640,22.940357,-52.285299,93.275237,19.040629,-51.190949,95.925445,20.558542,-51.070422,95.622905,21.819850,-50.406301,96.425888,16.478828,-20.306427,97.823734,14.344256,-14.505029,92.453491,14.458211,-10.441465,91.724514,14.564587,-10.955838,91.965257,14.595544,-19.339781,95.440776,15.374618,-10.269344,91.378192,15.776774,-19.122795,95.799363,16.408041,-17.635534,94.085211,16.613221,-13.750212,90.809393,16.669872,-19.274774,96.588685,16.729274,-9.830036,90.684272,16.839371,-16.451897,92.681254,16.900533,-10.147924,90.667684,17.054704,-13.934555,90.621899,17.384469,-12.470466,90.370166,17.752817,-18.098744,95.580576,17.763242,-17.386298,94.625600,17.773173,-15.648200,92.153179,18.193123,-10.595978,89.881170,18.962900,-12.650513,89.470768,19.012789,-13.828492,90.305162,19.013636,-13.980712,90.458790,19.323645,-12.070708,89.124004,19.561614,-13.519087,90.048760,19.951547,-11.989942,88.818911,20.042192,-11.915463,88.749780,20.102878,-13.096548,89.610964,20.326143,-12.282710,88.849107,20.741299,-17.893780,97.055049,21.894019,-16.408391,95.588735,22.024103,-17.698229,97.462592,22.343507,-16.757310,96.355426,22.720114,-14.170422,92.457103,22.768291,-12.121754,88.737153,22.974950,-12.007347,88.550753,23.098310,-15.378609,94.657296,23.744927,-11.963978,88.617301,23.911822,-14.239714,93.177511,24.083930,-11.830562,88.497683,24.242494,-17.674728,98.059276,24.273782,-13.951303,92.872059,24.287504,-13.618916,92.399299,24.326959,-18.026773,98.539051,24.650487,-14.350870,93.761391,14.808980,-9.278170,90.487510,19.123448,-8.168563,88.829677,19.215660,-8.221066,88.854625,19.324966,-9.001110,89.197457,20.297846,-8.108521,88.375977,20.359596,-9.270930,88.568499,14.278152,-126.726883,101.620637,14.667631,-127.469733,100.988525,15.126824,-127.331746,100.709226,15.541253,-127.170379,100.250025,15.845562,-124.745438,99.548117,16.321019,-126.286333,99.344148,14.410963,-48.674981,100.727927,15.174357,-44.749520,104.983972};
			return value;
		}
		private double[] getCoordinate_9_21_point_159()
		{
			double[] value = {15.639515,-42.461746,105.743928,15.928074,-43.576555,105.554801,16.404352,-44.495544,105.238522,16.999867,-46.969348,102.639382,18.098469,-41.850769,106.351490,19.156741,-48.618970,99.656917,19.336641,-42.202517,106.464386,19.397027,-41.657221,106.564476,20.959550,-42.224738,106.626908,20.997293,-41.828815,106.722956,21.825114,-41.755226,106.777753,21.944611,-41.285978,106.873167,22.109006,-47.171830,101.269350,22.397317,-42.247407,106.644756,23.486141,-47.360702,100.709438,24.368097,-41.823723,106.753731,24.569293,-44.510075,104.664699,15.746703,-31.276690,103.974902,16.359002,-35.338888,105.101562,16.362098,-32.047749,104.369463,18.051259,-34.019618,105.520517,18.310956,-39.102365,106.415809,18.675956,-39.492600,106.505580,19.205521,-30.673098,104.985807,19.587207,-37.292243,106.545954,19.640391,-35.749670,106.334025,19.831528,-33.722362,106.040697,20.062915,-37.047684,106.712473,20.289586,-36.114520,106.515493,20.646616,-36.691523,106.649942,20.647251,-39.728156,106.929961,21.866016,-36.861367,106.893275,22.401555,-40.790082,107.022075,22.589435,-37.936311,107.087528,23.586915,-36.376710,107.029921,23.732641,-33.190027,106.443296,24.031307,-31.434566,106.150474,24.636439,-33.104152,106.555211,14.327158,-26.853445,101.691505,14.606706,-26.185542,101.397681,14.874171,-22.284295,98.884266,15.511196,-29.546804,103.293890,15.785056,-21.746589,98.860373,15.947868,-21.938178,99.121703,16.032932,-23.709711,100.668413,16.286998,-27.399383,102.809456,16.589125,-27.760008,103.084611,16.778540,-21.818915,99.527628,17.571095,-20.769147,98.940334,17.998860,-23.572225,101.392803,18.030013,-28.111089,103.607988,18.192039,-29.606666,104.367078,18.603598,-25.464837,102.704280,18.751125,-28.019789,103.915036,19.311206,-29.035388,104.378572,20.238231,-24.943698,102.902329,20.552310,-29.426434,104.969780,20.671160,-21.755409,100.981070,20.928961,-27.180963,104.083847,21.153894,-24.591199,102.851459,21.590876,-20.550899,100.318512,21.757675,-26.322066,103.867590,22.417606,-25.240601,103.345075,22.539801,-27.438540,104.480716,24.490719,-24.608232,103.221012,20.752861,-19.750370,99.288146,22.110207,-18.999276,98.976919,24.889991,36.924694,-34.034400,25.495450,36.999468,-34.049018,25.666561,36.954752,-27.858134,26.073674,37.109769,-29.055225,26.283710,40.823780,-34.207216,26.584678,39.612341,-34.208326,26.875768,37.219584,-29.831990,27.013452,36.786224,-31.352686,27.192525,36.761013,-31.429291,27.213154,38.738335,-33.914205,27.444103,41.578139,-32.840104,27.469217,38.385871,-33.863424,27.616739,38.794408,-33.665396,27.918276,42.024482,-32.430014,28.080615,36.891671,-32.935938,28.225078,37.612035,-27.026278,28.330872,40.210168,-33.356492,28.381531,36.548095,-31.634988,28.564616,38.637034,-33.138020,28.613360,42.527326,-32.010767,28.615999,40.217095,-33.224185,28.832784,37.312534,-29.327236,29.018994,39.067879,-33.177155,29.094890,37.051049,-32.611377,29.336891,37.228411,-32.479946,29.358253,36.579376,-30.743827,29.508606,40.034204,-32.819682,29.565743,40.163530,-32.763658,29.806738,37.735509,-32.259012,29.823701,40.665242,-32.444429,29.844873,39.728086,-32.675491,29.896210,37.927092,-32.272373,29.902511,39.068529,-32.640162};
			return value;
		}
		private double[] getCoordinate_9_21_point_160()
		{
			double[] value = {30.360510,36.654206,-30.674495,30.417471,36.621020,-30.254447,30.422332,36.761863,-30.931072,30.524572,36.831771,-30.983467,30.713379,38.195705,-31.468776,30.802091,37.307442,-26.216560,31.017248,36.741417,-29.646893,31.219161,39.729126,-31.504981,31.429938,36.939501,-29.769631,31.461740,37.014555,-27.909005,31.495606,36.912678,-29.293732,31.498053,38.525219,-30.750876,31.534443,41.070722,-31.321764,31.660709,40.313155,-31.338678,31.661295,42.289087,-30.634353,31.697882,39.983230,-30.983891,31.839342,37.682662,-30.137755,31.986225,39.476202,-30.769509,32.017353,40.693621,-30.862063,32.286506,40.651947,-30.383021,32.398314,37.962876,-29.083117,32.402821,39.417366,-29.668427,32.595943,38.000379,-26.130197,32.682832,39.398949,-29.446159,32.919777,41.717767,-29.760741,32.927828,40.254041,-29.174523,33.206750,38.398741,-27.454917,33.227726,40.586669,-28.972613,33.612245,39.998006,-28.349926,34.686597,42.444797,-26.170869,24.765064,48.272865,-33.064133,25.104387,42.939396,-33.854386,26.137670,46.428990,-32.756331,26.144919,52.723833,-33.167445,26.542575,49.841510,-32.357672,28.700232,46.091723,-31.612891,30.773419,49.070027,-30.170290,31.031582,47.667574,-30.082118,31.606864,45.077506,-30.178142,31.679426,52.597492,-30.441859,33.507655,48.640287,-28.352509,34.281237,42.931311,-27.336122,34.352769,46.856760,-27.126469,34.621927,43.915988,-26.416474,35.073598,46.452941,-26.616284,25.340383,54.485372,-33.485534,25.695417,63.045759,-32.371818,26.023914,62.600332,-32.390548,28.990238,57.784464,-31.941111,29.020404,54.621900,-32.076251,30.640372,54.358664,-31.302297,30.851292,62.247907,-30.894292,30.882763,63.312806,-30.664342,31.524338,53.052138,-30.636368,32.327660,59.860643,-30.152184,32.424405,56.028263,-30.483518,32.426831,54.126630,-30.279257,33.443646,53.316060,-29.565532,34.062819,57.742087,-29.556108,34.098245,60.118045,-29.043724,34.286264,60.120483,-28.902145,34.647878,61.169715,-28.812612,34.992582,57.374680,-28.999634,24.859595,70.737193,-29.601194,24.926282,72.706564,-29.645355,25.433362,71.312173,-29.800842,26.009973,73.524369,-28.928455,26.822934,69.732861,-29.697180,28.275356,69.698937,-28.724939,28.784833,65.444076,-30.852815,28.914369,69.494255,-28.560141,29.003499,65.634101,-30.695682,29.204295,73.642261,-27.941201,29.665677,64.798272,-30.785966,30.130227,66.230221,-29.945277,30.282075,71.946137,-28.099775,30.310869,73.165283,-27.997204,30.548766,69.613515,-27.875897,31.447151,71.200213,-28.338991,31.644252,69.113369,-27.993351,31.645541,70.349500,-28.282265,31.730956,67.038172,-28.672666,31.809985,73.515320,-28.531271,31.852255,68.168282,-28.080533,32.211422,71.401828,-28.438023,32.501939,68.361593,-27.884940,32.798814,70.200035,-28.214897,33.120894,64.526365,-29.222000,33.286305,73.574847,-27.764921,33.463188,71.812254,-28.501758,33.702277,72.753627,-27.820790,33.834015,70.882134,-28.516348,34.267942,73.496854,-27.600917,34.333526,68.344815,-28.064868,34.503687,65.611209,-27.984322,34.618935,73.548672,-27.284586,34.731243,69.808733,-28.185944,34.831093,72.899004,-27.429910,34.894107,70.001918,-28.140058,34.987727,69.804117,-28.117769};
			return value;
		}
		private double[] getCoordinate_9_21_point_161()
		{
			double[] value = {35.065517,67.071885,-27.689755,35.077143,72.545713,-27.366577,25.159523,80.304748,-26.797756,25.202548,74.738543,-28.745146,25.323665,78.794720,-27.468498,25.339212,76.229468,-28.364802,25.420851,74.418363,-28.802422,25.443460,74.544167,-28.754155,25.550825,79.854883,-26.816902,25.584503,77.608065,-27.832720,26.042858,75.628177,-28.349176,26.231714,74.787952,-28.456528,26.349643,79.074458,-26.529618,26.843528,76.107477,-27.394064,26.910957,77.999610,-26.872314,27.381177,74.480657,-27.738561,27.478602,77.991146,-27.025944,28.098600,76.979274,-27.385078,28.132740,74.103131,-27.645974,28.566863,79.702962,-25.941808,29.269121,74.881886,-27.669080,29.341865,75.922256,-27.457771,29.799292,79.674932,-25.960917,30.295168,76.511024,-27.747693,30.431305,76.935570,-27.661454,30.574302,77.358354,-27.194632,31.157568,75.186268,-28.223472,31.476950,76.274331,-27.203555,31.773954,75.817287,-27.337503,32.298989,78.052967,-26.196307,32.536810,78.059820,-26.102332,32.767034,77.115862,-26.525907,32.850283,77.517909,-26.244744,33.609073,76.415517,-26.269920,33.796756,76.068979,-26.318587,34.282453,75.274845,-26.014062,34.462860,74.308178,-27.013039,34.736480,73.964551,-26.586965,24.870547,-4.199830,-18.256673,25.186875,-6.289331,-15.922354,25.302269,-3.954648,-18.156761,25.606265,-5.169693,-17.182348,25.728179,-6.295685,-15.788888,25.847073,-6.120278,-16.006875,26.075790,-5.987162,-15.897480,26.160635,-1.102976,-18.741199,26.810600,-0.562680,-18.767788,26.889195,-0.917859,-18.616368,26.893273,-0.818137,-18.638421,26.941118,-1.298190,-18.461277,27.045182,-1.459889,-18.252245,27.124559,-2.457595,-17.700036,27.167413,-1.354228,-18.114932,27.209297,-3.625161,-16.876160,27.225185,-3.316439,-17.153405,28.543714,-1.489192,-17.413224,28.840078,-3.158514,-16.186133,29.225766,0.193620,-17.689026,29.555668,-1.801942,-16.503083,29.693138,-1.138065,-16.253147,30.135557,-0.344234,-16.047417,30.569615,0.548788,-16.307282,24.881725,5.199702,-17.384398,24.945047,1.258615,-19.376956,24.969823,10.192736,-19.340992,25.055408,3.360651,-18.868582,25.059649,4.421837,-18.093731,25.084355,9.928625,-18.269980,25.259132,2.092094,-19.248995,25.286185,3.244836,-18.936181,25.540824,6.068378,-16.790219,25.678367,5.136560,-17.707596,25.748085,9.944579,-16.159577,25.868881,10.293117,-19.898621,26.041155,2.409168,-19.015411,26.125377,10.135135,-16.322261,26.154979,10.181139,-16.920481,26.511242,7.013915,-15.653457,26.549155,10.399278,-20.238996,26.763210,10.183743,-20.181429,26.972738,5.170153,-17.403001,27.114683,6.491051,-16.071959,27.308608,10.446313,-16.170627,27.372663,10.532838,-16.740427,27.584826,10.589382,-16.536884,27.641247,9.933140,-19.061537,27.737913,4.561160,-17.259775,28.246467,2.777720,-17.855874,28.628536,5.179885,-16.165244,28.982269,2.435341,-17.489968,29.216899,0.894696,-17.693056,29.479736,4.368494,-15.710090,29.545420,10.575453,-17.804418,29.556576,3.201600,-16.425662,29.630343,1.980880,-17.046560,29.681324,9.908046,-21.187492,29.724837,9.730039,-16.124898,29.876106,1.900426,-16.718888,29.977939,2.921511,-16.206020,29.997839,9.555424,-16.132086};
			return value;
		}
		private double[] getCoordinate_9_21_point_162()
		{
			double[] value = {30.252105,2.181222,-16.365922,30.377280,9.440328,-21.024107,30.491222,2.769830,-16.094800,31.281430,0.825137,-16.178415,31.346468,9.512712,-19.736004,31.479520,9.552189,-18.250513,31.744358,0.818560,-15.662267,32.345802,8.376505,-18.410921,32.415882,7.067525,-16.462967,32.722052,7.681924,-18.266358,32.967399,6.796221,-16.467009,33.023392,7.645200,-18.859005,33.402206,6.593702,-17.453399,33.770830,6.424590,-16.852722,34.025762,6.703353,-19.458089,34.167667,6.701010,-15.562461,34.313722,7.828266,-22.180829,34.404308,6.465746,-19.561190,34.782038,6.029079,-17.365764,34.949338,10.486997,-24.023406,35.040963,7.108928,-21.633720,25.332375,17.758480,-18.204145,25.898453,16.051874,-19.448857,26.508994,14.325686,-20.483567,27.999463,14.775533,-20.607724,28.297720,17.174560,-19.972710,28.417991,16.564540,-20.071646,28.752125,16.080098,-20.353171,29.722233,13.036437,-21.517405,30.298655,17.213437,-21.265358,31.006475,18.072909,-21.756122,32.713800,14.300108,-22.792568,32.890704,13.458576,-22.976030,33.654197,15.388648,-23.218687,34.867273,14.034941,-23.822368,25.116025,28.073125,-18.612575,25.196289,32.035021,-19.050495,26.794595,31.438504,-19.445822,29.487731,24.426277,-21.055052,30.252637,30.285167,-21.495878,30.589189,29.581788,-21.753276,31.298176,30.964909,-22.226352,31.619608,32.025617,-22.382172,32.142727,28.926213,-22.890411,33.589560,23.489062,-23.718401,33.750863,28.749264,-23.773249,34.374625,21.731782,-23.989818,34.439032,26.992053,-24.043160,34.452027,24.678324,-24.107050,34.481312,27.495780,-24.019022,34.713776,28.635453,-23.873227,24.879403,36.579360,-22.358504,25.252100,34.770515,-20.428110,25.252336,33.778966,-19.770299,25.516229,34.601523,-20.058715,25.600134,36.666516,-21.870932,25.624916,37.170806,-23.291182,25.800579,37.567843,-24.933708,25.815026,34.057962,-19.613331,25.857374,33.747170,-19.501503,26.006558,37.033133,-22.532173,26.535539,37.772108,-25.438553,26.674219,37.684450,-24.163620,26.696285,37.347069,-23.274250,28.318166,37.674857,-24.335054,28.718670,37.490103,-23.777005,29.647641,37.119037,-23.532339,29.841451,36.867722,-23.324224,31.532695,37.522740,-25.526052,31.560142,35.023064,-22.975994,32.147474,36.037440,-23.728008,32.569882,37.893662,-25.644805,32.585294,37.114352,-24.507678,32.650999,35.501483,-23.427505,32.709167,38.064202,-25.647421,33.610294,39.040906,-25.247635,33.873598,39.751911,-25.427676,33.905983,32.988204,-23.276262,34.146327,40.445497,-25.605870,34.401721,37.743296,-23.952556,34.407167,40.179677,-25.322248,35.056935,73.583168,-25.866995,35.139632,72.314771,-24.388533,35.175089,73.552953,-25.488788,25.050887,82.103736,-25.809852,25.728057,83.963191,-23.824414,25.753220,83.696373,-24.047703,27.376164,83.261440,-23.902749,27.524984,81.562151,-25.326273,28.296649,82.650918,-24.054466,28.300805,83.570299,-23.212788,28.571407,82.345605,-24.025016,28.755136,80.441251,-25.508801,28.784659,82.424124,-23.817744,29.010535,80.304504,-25.620248,29.157235,83.590378,-22.567607,29.358068,81.206133,-24.978719,30.149812,80.274193,-25.219034,30.450604,80.503586,-24.896308,30.564642,82.149609,-23.454896};
			return value;
		}
		private double[] getCoordinate_9_21_point_163()
		{
			double[] value = {30.912589,79.152316,-25.669376,31.836624,79.802172,-25.157995,32.146885,84.143885,-20.558227,32.149322,81.664269,-23.052776,32.309880,80.697387,-23.953477,32.487654,80.646183,-23.569682,32.939299,83.468777,-20.860051,33.058012,79.504222,-23.225991,33.116907,80.218993,-22.593041,33.288926,78.855958,-23.185617,33.392211,84.249613,-19.152296,33.561286,79.782127,-22.583951,33.637724,77.124657,-24.755406,33.788892,82.727978,-21.227172,33.836652,83.683849,-19.559554,34.048537,83.384268,-19.428263,34.071367,83.316574,-20.022150,34.136973,83.299216,-19.613970,34.137905,77.193015,-23.048043,34.201850,81.062869,-22.251378,34.209213,81.521889,-21.967638,34.354048,82.031067,-21.537572,34.393387,82.838398,-20.228876,34.452604,81.389831,-21.947956,34.601377,74.437711,-24.803592,34.644562,74.372698,-24.167007,34.648248,79.034434,-22.683461,34.687720,82.514231,-20.209390,34.712691,74.296207,-23.978705,34.749185,75.687061,-23.534735,34.822607,81.167255,-21.939971,25.962706,90.507120,-16.569847,26.181252,89.727550,-17.820266,26.244475,86.210222,-21.259033,26.306549,85.242461,-22.166835,26.503503,89.942940,-17.090372,26.695266,89.740707,-17.171194,26.714975,87.970451,-19.703606,26.763468,89.668298,-16.978846,26.795662,84.413094,-22.892707,26.876736,87.628258,-20.011012,27.144033,86.634379,-21.158131,27.172127,89.373768,-16.114669,27.291922,86.387073,-21.345142,27.325614,89.169603,-16.301727,27.851755,85.994644,-21.335249,27.979648,86.411503,-20.881464,28.230915,87.696106,-18.082292,28.323147,87.000233,-19.245433,28.517479,88.569648,-17.020458,28.776383,89.764790,-15.918119,29.034054,88.497308,-17.114893,29.173471,86.635453,-19.212093,29.305230,88.242116,-17.364618,29.388606,87.721819,-17.989182,29.565168,88.699956,-16.918614,29.761667,84.503897,-21.493365,30.038683,86.468107,-19.287883,30.142596,86.249310,-19.501430,30.509494,88.750539,-16.041113,30.672258,86.536408,-18.947006,31.620793,87.603456,-15.851667,31.670500,84.945777,-19.981580,32.403977,84.924211,-19.639493,32.593589,85.417778,-18.650552,33.052370,85.095807,-17.956795,34.388899,85.062825,-17.574489,35.081761,85.092593,-16.918369,25.167102,-32.007195,-6.083481,25.541799,-32.135200,-6.017289,25.900141,-31.544620,-6.127277,24.751128,-20.672548,-8.630802,24.940241,-27.248071,-7.915742,24.993406,-27.399799,-7.114672,25.367861,-25.213453,-8.644572,25.370385,-25.658154,-8.201523,25.550211,-20.728640,-8.701620,25.603003,-26.483363,-7.488911,25.651893,-26.899679,-6.598686,25.794600,-20.231163,-8.706314,26.045358,-24.247897,-8.251444,26.091168,-26.296382,-6.657669,26.298564,-26.195315,-6.459123,26.346291,-27.401044,-6.348584,26.589746,-26.547519,-6.230817,26.861613,-26.091413,-6.193204,26.977817,-30.536548,-5.630933,27.071254,-26.371639,-6.217584,27.251993,-24.483433,-6.772763,27.297384,-24.156851,-7.392273,27.335962,-20.842747,-8.323533,27.459979,-24.060242,-6.975845,27.504847,-30.550451,-5.217121,27.638892,-24.713698,-5.972115,27.742242,-21.359275,-7.973728,27.805558,-20.402749,-8.218580,28.171857,-27.734506,-6.346059,28.199513,-21.389651,-7.771661,28.202909,-28.341635,-6.068346,28.285209,-26.996380,-6.344663};
			return value;
		}
		private double[] getCoordinate_9_21_point_164()
		{
			double[] value = {28.513764,-22.407672,-6.880471,28.520404,-27.791223,-6.103395,29.242315,-20.598101,-7.546184,29.392398,-26.437029,-6.020128,30.344158,-20.903717,-5.627130,24.935788,-14.268200,-8.058580,25.063481,-16.731385,-8.715756,25.353757,-11.491424,-7.622933,26.185521,-15.103955,-7.803303,26.204264,-12.963681,-7.623851,26.220992,-18.326504,-8.500205,26.389730,-19.636321,-8.664132,26.457436,-12.888545,-7.624392,26.524866,-13.348953,-7.717849,26.534724,-18.925528,-8.525397,27.033619,-12.938680,-7.405084,27.043541,-16.519792,-8.217294,27.297853,-13.421125,-7.550452,27.298546,-13.031859,-7.350355,27.455441,-12.314532,-6.849783,27.667632,-12.450906,-6.757220,28.119165,-19.987355,-8.232680,28.223766,-12.227685,-6.135707,28.472230,-17.140741,-8.245828,28.837082,-13.939794,-7.058807,28.860070,-14.544116,-7.381395,28.960637,-14.632970,-7.376420,29.105654,-12.429598,-5.727481,29.324506,-17.547290,-7.743797,29.337004,-16.983809,-7.722765,29.400318,-17.500725,-7.691104,29.538551,-15.280219,-7.007573,29.672605,-16.373977,-7.084567,29.689231,-13.477970,-5.685073,29.996910,-13.453450,-5.578691,30.360178,-13.269869,-5.162314,30.643880,-17.910016,-6.809559,30.784247,-14.134783,-5.260209,30.856844,-14.589906,-5.501120,30.916876,-16.137402,-6.193289,30.986018,-15.799924,-6.051654,31.116437,-15.971210,-6.012350,31.239120,-15.268743,-5.320992,31.338203,-18.688589,-5.513594,31.494608,-16.662041,-5.521384,24.742887,-6.664716,-13.559865,24.770885,-6.511050,-13.806713,24.887675,-6.364142,-14.975184,24.991937,-6.351522,-14.947522,25.165400,-6.271438,-13.926963,25.177723,-8.502162,-8.459351,25.278452,-6.976962,-10.321203,25.414789,-6.413203,-15.494829,25.493869,-6.288217,-14.584043,25.733690,-6.414018,-15.414816,25.785924,-5.885536,-11.190583,25.889300,-6.038984,-11.990335,26.221429,-6.525582,-10.233400,26.362896,-5.678849,-10.418210,26.602246,-5.351564,-15.297463,26.741445,-5.507857,-11.453220,26.833241,-6.933387,-9.856261,26.922518,-5.773438,-13.711283,26.982953,-5.089813,-11.215566,27.012446,-5.936936,-9.943499,27.073794,-8.991204,-7.526710,27.171954,-5.602354,-12.216289,27.259032,-4.812949,-11.152507,27.323214,-8.327182,-8.697690,27.329876,-4.719514,-9.580474,27.517318,-8.446946,-8.553153,27.665581,-4.530169,-9.371349,27.708898,-5.112041,-13.671398,27.945492,-4.561137,-13.603998,28.013306,-3.928101,-15.014637,28.160590,-4.199126,-14.245575,28.537358,-7.116326,-9.084278,28.580966,-4.846111,-8.734734,28.757976,-5.792452,-8.938912,29.207384,-3.092602,-14.804075,29.228876,-3.023270,-15.402772,29.284052,-3.735221,-8.739707,29.303771,-3.111245,-13.739788,29.461072,-3.058821,-9.692630,29.470405,-3.006989,-9.774249,29.493506,-2.765510,-14.073607,29.527460,-7.220060,-8.564294,29.637248,-3.471643,-12.749629,29.789747,-5.104300,-8.203468,29.836725,-3.364109,-12.553310,29.954065,-2.876803,-11.169057,30.118482,-3.728877,-8.175869,30.133286,-8.578219,-5.821446,30.167560,-8.470735,-6.065350,30.240066,-4.430592,-7.943670,30.403209,-7.940848,-7.612209,30.524309,-2.335125,-14.733947,30.622230,-5.187386,-7.660260,30.789662,-8.033594,-6.817499,30.806159,-2.728050,-14.077000};
			return value;
		}
		private double[] getCoordinate_9_21_point_165()
		{
			double[] value = {30.843832,-2.498355,-14.580361,31.058314,-5.854624,-7.519268,31.082630,-2.563072,-14.305683,31.121623,-7.319162,-7.389524,31.181131,-3.155775,-8.963941,31.362394,-2.205746,-13.640802,31.402254,-2.017450,-13.532581,31.424290,-1.921928,-13.525819,31.455779,-1.822694,-13.613550,31.456897,-1.900315,-14.192996,31.521655,-1.736783,-12.847567,31.548904,-1.431746,-13.777140,31.863957,-3.650475,-8.276744,31.882178,-2.083540,-11.329082,31.926009,0.204448,-14.798551,32.503940,-1.334783,-12.394250,32.617455,-0.963133,-13.291832,32.627676,-7.103176,-5.570797,32.708935,-5.532514,-6.186309,32.720791,-4.065550,-9.216531,32.795922,-3.827892,-9.623321,32.876408,-5.945320,-5.778439,33.141913,0.254191,-14.172012,33.151157,-3.297530,-9.991391,33.257669,-3.856490,-9.774636,33.275540,-4.185255,-9.192034,33.284350,-0.722194,-12.530762,33.304110,-4.243905,-8.763103,33.312945,-5.869661,-5.541719,33.564900,-0.196314,-13.502616,33.575061,-4.191821,-9.067490,33.581722,-1.496431,-11.798883,33.778114,-0.061802,-13.359208,33.824650,-3.718206,-10.111517,34.299944,-1.319150,-11.777313,34.423473,-4.747742,-7.356700,34.433967,-0.713689,-12.071993,34.622077,-5.110063,-6.922307,34.629837,-5.646907,-6.256425,34.806021,-5.148030,-6.953087,34.908505,-5.628213,-6.366866,35.000233,-5.458531,-6.595708,26.357643,9.536836,-15.338866,26.397565,9.350457,-15.232525,27.920807,9.288820,-14.727865,28.620027,8.519373,-14.553581,28.645263,7.506748,-14.582832,29.075718,6.002052,-15.001429,29.527833,5.444803,-14.942565,29.765789,4.492271,-15.468318,29.799020,7.696534,-14.404253,29.933866,8.289196,-14.759844,30.387860,7.330930,-14.340578,31.828940,5.870809,-14.211619,32.273001,1.671904,-14.810662,33.012971,1.110459,-14.560503,33.082098,3.104705,-14.599082,33.240745,2.854862,-14.574028,33.452297,3.110930,-14.390115,33.931164,8.747997,-11.826611,33.952567,8.490764,-13.075618,34.145741,1.135031,-13.588302,34.156149,9.117411,-12.746061,34.176271,4.690650,-13.215683,34.182554,1.343682,-13.561090,34.194996,1.249213,-13.230190,34.275149,8.794558,-11.230472,34.280481,1.218869,-12.769927,34.305253,3.621145,-13.300503,34.315306,4.547946,-13.094820,34.316245,2.539984,-13.259382,34.318721,7.859553,-11.660544,34.555550,6.546769,-12.280837,34.605345,2.841903,-12.784184,34.631990,10.784332,-11.207167,34.676271,4.172305,-12.818124,34.711019,9.297000,-13.451970,34.762115,10.968382,-12.144633,34.781952,10.044920,-9.907767,34.784153,8.885656,-10.522895,34.839625,8.913985,-10.410902,34.870465,8.495170,-10.639823,34.978719,2.941944,-12.679073,35.023254,9.193817,-10.011951,35.048221,4.843059,-12.714245,35.084091,1.517979,-12.523006,34.577197,11.233350,-10.398725,35.025599,11.422214,-12.007520,25.172741,93.262434,-12.548039,25.332844,91.274788,-14.588019,25.789709,92.505682,-13.495235,25.835576,91.532605,-14.299509,25.844128,93.367267,-10.250383,25.935942,91.547912,-14.298614,26.164388,93.676203,-9.942294,26.176043,92.920439,-10.900933,26.435840,92.725634,-12.600614,26.650590,91.509063,-14.398432,26.932812,92.269319,-13.096612,27.111737,92.845025,-10.604287};
			return value;
		}
		private double[] getCoordinate_9_21_point_166()
		{
			double[] value = {27.265134,92.209074,-12.436809,27.409659,93.409094,-9.471399,27.709598,91.828507,-11.751360,27.713635,93.212618,-8.199627,27.735064,93.173985,-9.547837,27.823492,93.593042,-7.786116,27.861324,91.336266,-14.066367,28.031528,93.017803,-5.270149,28.071031,92.845171,-9.502596,28.122493,93.181759,-8.121432,28.560966,90.547372,-14.813147,28.857019,90.347168,-14.920622,29.056438,92.988822,-7.858149,29.111201,92.051804,-9.819809,29.177864,92.384396,-8.636409,29.258640,91.326309,-11.917603,29.283482,92.612065,-8.382130,29.335908,92.472839,-6.916238,29.341908,91.933519,-9.075100,29.374962,90.429576,-13.093730,29.490003,92.038080,-6.466127,29.676843,91.619633,-10.071626,30.096652,90.986501,-12.189441,30.256542,91.806872,-7.429893,30.307301,90.100175,-12.965836,30.401917,91.141069,-6.402184,30.449893,91.721258,-5.341382,30.558843,89.225851,-14.038157,30.616982,90.965074,-9.631759,30.831905,91.055653,-5.794259,30.923755,91.179461,-5.645491,31.355752,91.198791,-8.657802,31.562713,91.348387,-5.362844,31.743537,90.036653,-6.739689,31.882792,89.754271,-11.216758,32.136471,89.420849,-10.815693,32.474416,89.326288,-11.762229,32.498123,88.337477,-14.521109,32.524047,89.056900,-11.271789,32.752780,89.761898,-8.896359,32.776413,89.154066,-6.994417,32.835029,89.058393,-10.526857,32.905015,89.092822,-8.455198,32.913920,89.262184,-10.326783,32.931552,88.316315,-14.120574,32.986125,88.901054,-8.410949,33.029406,89.057440,-6.942307,33.044668,88.462108,-11.268435,33.069926,88.648280,-7.584107,33.209319,90.415332,-5.522956,33.234251,88.574192,-8.523423,33.252409,89.761373,-6.246374,33.370573,90.115191,-5.721194,33.436814,88.158005,-8.173188,33.469562,89.312456,-6.599863,33.658070,88.282136,-9.267060,33.724155,88.367380,-10.457806,34.127558,87.235396,-8.894328,34.190258,87.462153,-11.455747,34.457855,86.760383,-9.265914,34.571991,89.318962,-6.083357,34.627820,86.302580,-13.459280,34.685891,87.060676,-10.503934,35.100344,85.987513,-12.716450,35.124235,85.779343,-9.687286,24.839244,94.895454,-9.029357,24.941810,94.925491,-8.800583,25.007835,95.049593,-7.208790,25.264785,95.417874,-5.781558,25.538934,94.925972,-6.992776,25.695637,95.488769,-5.233623,24.752202,-76.473968,4.025942,24.769616,-74.621506,1.842880,25.305556,-76.183842,3.752929,25.542803,-73.333851,1.331914,27.417413,-75.796079,4.855117,27.817444,-75.660558,5.024959,28.368354,-73.072873,3.273677,28.825571,-72.529724,3.517441,29.358444,-72.444552,4.062453,25.332529,-65.668798,5.117129,25.818981,-65.581653,4.717318,26.125243,-70.935824,1.083172,26.514412,-65.513461,4.374862,27.197520,-65.793487,3.537394,27.294907,-66.150020,2.978977,27.726821,-66.540617,2.968506,27.831850,-72.114348,2.538098,28.300806,-70.427241,2.707512,28.415270,-66.240916,3.584606,28.578338,-66.032779,3.917909,28.904936,-69.281592,3.271322,29.110511,-70.307405,3.357419,29.542583,-71.950187,4.044315,30.653074,-71.966771,5.111665,24.727741,-46.941606,4.651162,25.069905,-41.422581,-0.159578,25.454117,-45.091384,5.028691,25.743566,-43.477254,2.339516,26.152274,-42.847693,1.206039};
			return value;
		}
		private double[] getCoordinate_9_21_point_167()
		{
			double[] value = {26.235596,-43.498686,2.448662,26.947948,-42.264878,0.923616,27.199878,-42.348907,1.254206,27.591407,-43.087261,2.723946,27.646021,-41.200683,1.124224,27.693986,-43.563711,3.720988,27.701178,-43.751957,4.105194,27.915938,-41.786855,1.851006,28.101935,-42.006868,2.222070,28.189027,-41.181470,1.367645,29.627888,-42.404645,4.811176,29.850636,-41.747458,4.007546,29.980166,-42.669958,5.179561,30.206810,-41.405207,3.548268,30.787026,-42.201844,4.986694,31.034679,-41.628355,4.663547,31.155565,-41.528430,5.012722,24.885751,-35.449344,-3.804358,25.714130,-34.362877,-4.232425,25.856002,-40.647762,-0.945576,26.007382,-32.540297,-4.891931,26.125163,-37.850785,-2.089144,26.336408,-35.357363,-3.471207,26.414581,-39.434010,-1.024846,26.485258,-33.750385,-4.498145,26.553757,-38.684669,-1.225612,26.598101,-34.815526,-3.551698,26.607431,-33.964147,-4.202462,26.732890,-39.440242,-0.697975,26.776188,-35.865397,-2.469950,26.857097,-34.623272,-3.116160,26.957651,-33.049091,-4.649599,27.053163,-32.388840,-4.858744,27.166929,-32.698094,-4.407238,27.201871,-31.690873,-4.877245,27.357050,-35.255858,-2.572020,27.357255,-31.333300,-4.883277,27.373380,-32.922716,-3.808921,27.465711,-31.953881,-4.427460,27.627768,-38.164861,-1.409724,27.652520,-34.572118,-2.776845,27.783776,-32.515448,-3.449920,27.862038,-37.022622,-1.933107,27.943060,-37.262915,-1.675138,28.014888,-38.427179,-0.911486,28.085835,-36.448757,-1.998818,28.264208,-40.502082,0.910893,28.309344,-33.773688,-2.958046,28.326740,-40.995365,1.402817,28.331271,-39.774116,0.742300,28.451029,-37.899746,-0.689786,28.635454,-38.615821,1.013143,28.673679,-36.702949,-0.321877,28.676727,-38.292274,0.931785,28.681371,-34.518597,-2.465784,28.688055,-36.735879,-0.112160,28.725341,-35.243847,-2.103411,29.203878,-33.988228,-2.136405,29.222444,-34.277092,-0.722183,29.431346,-38.800147,1.579824,29.572753,-37.276856,0.798667,29.817951,-36.165960,0.318856,30.507501,-36.304197,0.232791,30.508049,-30.797093,-1.246777,30.596979,-34.189906,-0.407207,30.633048,-38.581118,1.191310,30.705134,-38.313941,1.062492,31.054460,-39.036038,1.838383,31.226391,-36.051323,0.307115,31.289686,-36.508108,0.623986,31.876323,-34.828781,0.597497,32.156084,-33.817304,0.168920,32.384897,-33.561467,0.292250,32.492907,-34.965258,4.307145,32.533236,-32.953018,0.536412,32.630973,-32.627459,0.317764,32.690796,-32.273172,0.826714,32.723649,-32.298510,1.098558,32.926701,-34.733556,3.160045,33.298697,-32.598637,4.447221,33.319346,-33.477289,3.356261,33.439232,-33.668238,2.425192,33.512197,-32.094002,3.840179,33.696330,-32.984221,2.523209,33.957113,-32.118706,2.381406,33.997309,-31.396628,1.939218,34.249443,-30.913053,2.763818,28.101579,-30.024171,-4.538055,28.180950,-29.850471,-4.393284,28.711513,-30.216400,-3.516128,29.777373,-27.328900,-3.804353,30.272395,-30.195234,-2.602018,30.386638,-21.260900,-5.000637,30.565494,-25.970931,-3.971712,31.081231,-25.235440,-4.004103,31.112251,-25.163165,-4.061781,31.297641,-27.349947,-2.236536,31.326353,-27.558056,-1.925401,31.422792,-27.089424,-2.552786,31.601146,-24.479688,-4.023930};
			return value;
		}
		private double[] getCoordinate_9_21_point_168()
		{
			double[] value = {31.750712,-24.304696,-3.927148,31.900985,-26.098334,-2.640909,32.164656,-29.157293,-1.385588,32.290253,-26.005763,-1.738562,32.314009,-21.911173,-4.538775,32.314063,-26.858238,-1.607082,32.339675,-22.955263,-4.573061,32.723707,-22.765677,-3.685556,32.987154,-29.321663,-1.350323,33.057108,-24.447678,-1.480066,33.058979,-29.302152,-1.290288,33.112506,-20.492091,-3.699909,33.149963,-28.102357,-1.506763,33.274210,-30.036414,0.797941,33.505522,-21.738423,-3.108228,33.745857,-29.001613,1.337442,33.750102,-23.968310,-1.000568,33.780234,-24.819766,-1.143434,33.789866,-20.244458,-2.933352,33.804607,-28.765373,0.634060,33.813847,-25.975635,-1.354002,33.817406,-28.888061,1.386656,33.909202,-21.527005,-2.765669,33.934189,-26.860313,-1.347405,34.298853,-30.166100,3.851975,34.309402,-25.674460,-1.083010,34.319933,-25.790657,-1.074217,34.340452,-20.290944,-2.513284,34.357736,-30.613468,2.755413,34.455434,-27.376366,0.182367,34.506844,-27.271623,1.449586,34.518138,-26.729710,-0.386452,34.524306,-29.569476,5.022692,34.638649,-22.228649,-0.290924,34.672053,-21.688273,-1.861154,34.785787,-28.911174,1.769840,34.814470,-24.416096,-0.589998,34.860349,-29.709388,2.671465,34.896920,-24.863599,-0.461316,35.017298,-29.499430,2.568296,29.835798,-12.451455,-5.094053,30.164187,-11.459437,-4.710312,30.296260,-11.343044,-4.590341,30.519730,-12.472890,-4.539759,31.023534,-19.803520,-4.609928,31.060224,-12.930068,-4.304236,31.270780,-14.663307,-4.200007,31.338706,-14.646439,-4.135693,31.478310,-18.303692,-4.123491,31.608840,-17.601677,-4.006945,32.022563,-12.925778,-3.550787,32.296225,-17.668617,-3.646791,32.301154,-10.281342,-3.008685,32.665000,-10.951420,-2.729415,32.818223,-11.143702,-2.575039,33.100110,-11.997024,-2.938070,33.151169,-11.111166,-2.115653,33.274659,-11.896389,-2.600354,33.281192,-11.815505,-2.492353,33.309292,-20.091502,-3.556977,33.315576,-12.378985,-2.806303,33.356146,-18.550722,-3.708462,33.369409,-20.075756,-3.484254,33.691827,-15.657482,-3.228771,33.733718,-11.925028,-1.807725,33.848230,-15.613986,-3.129119,33.964890,-16.532386,-3.189538,33.986450,-17.624035,-3.284217,34.099311,-17.816181,-3.227946,34.129758,-19.418765,-2.479153,34.139408,-14.638374,-2.774678,34.140988,-17.460954,-3.196059,34.373341,-11.550573,-1.452645,34.391061,-16.117771,-2.690919,34.414126,-18.378748,-2.009137,34.421961,-14.740134,-1.738196,34.447107,-18.156088,-1.947218,34.635330,-13.224919,-1.402170,34.650385,-13.452138,-1.378547,34.653641,-16.365747,-1.496562,34.775316,-18.545286,-1.908828,34.995249,-18.987003,-1.904045,35.047356,-12.248767,-0.910179,35.082675,-16.674133,-1.289201,30.482262,-9.130122,-4.779741,31.836001,-8.262895,-3.723985,31.947130,-9.292619,-3.516634,32.414786,-7.535501,-4.849696,32.550718,-7.400289,-3.818424,32.673177,-8.995904,-2.948470,32.752219,-7.186446,-3.997376,33.267052,-8.029601,-2.641495,33.682353,-6.479188,-4.325001,33.745054,-6.154518,-5.053657,33.969485,-6.558895,-4.074366,34.195063,-8.203318,-1.062378,34.240237,-8.908537,-0.772457,34.247193,-6.265193,-5.123681,34.271576,-6.313781,-5.000605,34.294930,-6.595990,-3.936113};
			return value;
		}
		private double[] getCoordinate_9_21_point_169()
		{
			double[] value = {34.562017,-6.999931,-2.527189,34.595841,-6.980881,-2.616558,34.691785,-7.122569,-1.913580,27.063125,94.408754,-4.928791,28.704988,92.852155,-4.929248,30.077298,94.682497,-3.810423,30.792253,94.747623,-3.611230,32.234636,94.490171,-3.167912,33.155024,92.806960,-4.503667,33.312590,94.380818,-1.937005,33.514469,93.827249,-3.257693,33.566456,94.538169,2.844081,33.751407,93.187351,-4.202580,33.782622,94.383037,0.961681,33.903913,94.636664,-0.531451,33.906971,93.472200,-3.711072,33.924424,93.531196,-3.134366,33.929256,93.178718,-4.129237,33.974749,94.356785,-1.471371,34.197755,93.330338,1.690874,34.784322,92.211264,-4.805676,34.853011,92.630695,-3.169357,25.063030,99.305781,2.456606,25.188762,96.527549,-4.558369,25.236939,99.791128,4.400934,25.696936,99.387207,3.213773,25.764940,99.736857,4.595866,25.875141,95.920376,-4.685126,25.947466,95.586388,-4.938477,26.593453,96.877248,-2.821369,26.760402,96.937976,-2.716108,26.882744,97.525762,-1.261630,27.377655,97.674264,-0.354128,27.434408,97.764906,-0.167921,27.650424,99.209705,4.547642,27.808886,97.218140,-1.376256,28.216359,97.963271,1.945361,28.893019,97.208962,1.356113,29.079516,95.943191,-2.881859,29.108658,98.529437,3.798591,29.265356,97.083422,1.838738,29.351681,97.189227,2.101024,29.519643,98.590000,4.358919,29.743775,96.263639,-1.630728,29.764613,96.873920,0.182914,30.417510,98.419774,5.002460,30.625314,96.107927,1.921351,30.646264,96.105737,1.729487,30.762510,96.136206,2.298983,31.116787,95.021023,-3.068852,31.494552,95.458924,1.881773,32.144301,95.485187,1.065151,32.402733,94.797409,2.270061,32.734711,95.284856,2.920675,33.034543,94.909082,2.856693,25.106908,-76.824823,5.444332,26.541079,-77.263568,9.196397,26.606482,-76.650482,6.097950,26.690937,-76.721692,6.509943,27.712138,-77.708596,14.241723,28.175935,-77.556028,13.582533,28.403217,-76.314635,6.683547,28.496188,-77.063274,9.867863,29.254067,-75.303063,6.106363,29.295645,-77.179506,11.807841,30.213497,-76.522534,9.360219,30.259508,-76.894848,11.105104,30.470090,-77.056422,12.461939,30.992180,-73.691072,6.537865,31.450785,-76.743538,11.875856,31.531424,-75.926630,9.232798,31.603036,-76.337057,10.271688,31.786441,-73.392717,7.219505,33.001598,-75.963930,10.670409,33.231383,-76.297400,11.996218,33.498838,-75.216199,10.497814,34.345523,-74.253617,10.748525,35.053438,-76.089265,13.564378,25.684400,-65.548862,7.251369,26.058765,-65.013938,8.081653,26.211294,-64.965043,8.226722,26.352250,-65.567568,6.955730,26.598363,-65.255873,8.137295,27.458850,-64.257045,9.451079,28.074206,-63.582803,10.200450,28.789394,-64.866124,8.007884,30.651817,-63.924377,11.758167,30.708312,-63.154731,12.558704,30.988089,-63.632208,12.332242,31.001346,-64.093709,9.432730,31.233073,-64.878797,6.767687,31.627495,-69.445377,5.564406,31.880527,-62.025745,14.209287,31.882345,-70.076043,5.824869,32.221224,-71.631556,6.457388,32.222135,-71.537147,6.438709,32.896560,-63.457967,10.658466,33.245089,-66.941989,7.107071,33.343177,-65.089688,7.859103,33.821151,-62.702944,13.761885};
			return value;
		}
		private double[] getCoordinate_9_21_point_170()
		{
			double[] value = {33.856006,-69.599899,7.642539,34.437356,-64.689581,8.872408,34.511575,-63.368260,10.444279,34.580521,-68.518893,8.235432,24.771107,-51.867917,11.922846,24.848686,-60.460491,9.051013,25.208833,-51.679674,15.543561,25.226887,-60.168011,12.811129,25.239088,-60.298405,12.113382,25.478762,-60.096116,14.359957,26.128444,-60.808475,10.038425,26.585364,-59.778827,15.465193,26.632229,-61.131671,10.159304,26.860900,-60.468704,14.188666,26.946483,-60.814478,13.446713,27.161991,-60.971295,10.975942,27.186294,-60.726983,11.761882,27.875364,-60.968946,11.899813,27.905370,-61.489887,11.104987,27.987549,-60.308682,15.532975,28.278700,-61.570295,11.417418,28.478553,-61.146702,14.705310,28.765301,-61.166475,14.458381,30.372141,-61.243362,14.169376,30.441937,-61.633277,13.452336,31.030440,-61.233432,14.863784,31.431447,-61.209108,15.271237,25.242013,-47.609872,8.667470,25.392206,-45.299797,5.298984,25.523243,-45.470384,5.701178,25.608048,-50.213944,10.018305,25.620029,-51.375945,13.933294,25.694511,-45.890823,6.714973,25.716329,-51.296460,13.556528,26.022502,-45.998600,7.359100,26.052144,-50.809437,15.010672,26.359740,-49.609373,9.984644,26.457289,-49.051883,9.571285,26.487674,-50.261143,12.750388,26.814965,-49.747962,11.441501,26.829273,-44.826888,5.688300,26.849563,-49.466080,10.536588,26.957450,-48.310583,9.393498,27.034423,-44.690316,5.512796,27.202205,-46.515359,8.223702,27.386038,-50.036747,14.636583,27.582011,-47.024897,8.942779,27.767850,-46.070425,7.967373,27.769480,-46.641825,8.963101,27.816767,-48.340250,11.521175,27.863350,-49.636006,14.154901,27.867860,-50.500806,15.168248,28.215467,-48.364630,12.450628,28.281464,-49.977567,14.519478,28.397408,-49.844670,14.398730,28.616198,-46.261479,8.798802,28.618680,-49.296182,13.771205,28.892904,-44.457474,5.900064,28.916922,-45.173582,7.056101,29.841571,-48.364570,13.753843,29.897810,-47.224975,11.538559,29.930916,-45.651699,8.875247,30.199610,-47.663863,14.510439,30.238282,-46.133914,9.993517,30.595950,-46.124985,10.569904,30.677218,-43.761302,7.235654,30.692127,-44.136634,7.827462,30.890558,-42.788632,6.320263,30.915762,-43.264672,7.242997,30.930972,-42.405111,5.597013,31.025340,-42.275095,5.951017,31.057899,-41.927497,7.026607,31.079240,-41.365390,5.951735,31.189760,-44.127863,9.448494,31.295586,-41.369661,7.130028,31.309891,-45.474878,14.868983,31.659668,-43.428716,8.948766,31.887831,-44.143445,9.941014,31.902969,-45.135035,15.059951,32.179700,-43.232215,8.990564,32.249420,-44.933432,15.009626,32.334993,-43.834948,14.374017,32.503082,-43.612357,14.252461,32.672481,-42.692497,9.587123,32.685280,-42.321116,8.966259,32.986314,-42.680787,9.810045,33.165423,-42.734809,10.477373,33.222285,-42.138097,9.178154,33.250650,-43.057564,14.047393,33.422572,-44.953529,15.080341,33.499164,-41.655055,8.754285,33.534298,-41.633639,8.840115,33.549688,-41.498454,12.594593,33.652877,-45.544746,15.513776,33.795467,-41.250966,9.176492,33.806617,-41.184334,9.055977,35.056462,-44.327142,14.879870,31.605081,-39.342853,6.177725,31.749059,-40.056335,6.752841,32.089555,-36.757552,5.255239};
			return value;
		}
		private double[] getCoordinate_9_21_point_171()
		{
			double[] value = {32.234146,-41.026829,7.532221,32.383417,-36.735134,5.576685,32.625198,-35.375276,5.475422,32.838946,-35.445585,5.523930,33.173810,-35.123031,5.509937,33.182949,-40.155264,6.855831,33.328973,-39.950896,6.693190,33.619367,-40.425390,7.177778,33.628645,-40.961010,7.797516,33.794252,-41.038524,12.083415,33.994154,-39.991981,9.441005,34.052728,-40.370115,7.946930,34.132299,-39.358477,8.916291,34.324467,-39.356534,7.421601,34.409187,-35.692379,5.589485,34.444390,-30.976178,5.279898,34.456375,-39.519719,9.631014,34.521316,-39.281573,9.442354,34.605297,-32.098387,5.438299,34.701013,-38.912788,10.848510,34.747865,-32.741870,5.684611,34.872313,-33.027407,5.863653,34.997881,-38.053078,10.346263,35.009399,-37.571125,8.521904,35.028062,-37.850609,9.516666,35.078187,-37.450768,8.577465,35.132811,-34.830198,7.254462,35.137208,-36.939478,8.302767,35.151314,-37.634257,10.091616,35.137168,-29.177872,5.295679,35.068714,94.680722,14.068840,25.639282,100.633239,14.506687,25.935550,99.772297,5.402237,26.381717,100.235162,14.759118,26.568142,100.181342,13.619522,27.083700,99.852724,15.157260,27.429695,99.688160,13.922020,28.676248,99.150523,5.983461,29.239290,98.557928,13.244003,29.850455,98.740815,7.426810,30.139689,98.026239,13.239371,30.335993,97.868268,13.394478,30.668517,98.261779,8.618140,30.884736,98.119322,8.552021,31.121692,98.109342,7.676212,31.289719,97.538970,11.440104,31.736418,96.775985,14.784079,31.879161,97.927045,7.168520,31.950740,96.475088,14.127396,32.027806,97.426671,7.614048,32.521894,97.700094,5.911045,32.524747,97.364595,9.407887,33.297045,95.877737,14.973998,33.428852,97.078927,7.106900,33.447595,96.924564,7.313631,34.407409,95.187052,14.598754,34.456105,95.779255,7.977484,34.575679,95.076644,10.555592,34.636112,96.420033,6.256294,34.798108,95.758441,9.919578,24.890036,-116.070641,24.463735,25.170329,-118.534469,25.591551,25.795034,-114.349998,24.659025,24.893199,-106.069773,20.962882,25.005966,-113.167677,23.249058,25.055456,-113.306277,23.570957,25.258564,-109.890452,22.574195,25.301430,-108.621319,21.637641,25.316246,-108.345732,22.141226,25.375055,-110.248475,21.188105,25.384270,-106.602230,21.061924,25.401014,-113.270136,23.937196,25.409272,-106.966907,21.119892,25.420147,-109.274275,21.441590,25.479871,-108.399338,20.702322,25.503725,-106.390909,21.925586,25.752202,-107.555553,22.415881,26.291676,-108.404111,23.108103,26.327247,-111.883679,24.048132,26.713551,-110.982152,23.693675,26.731093,-108.723985,23.148949,27.215349,-107.647812,22.615264,27.361830,-113.784935,24.519272,27.413999,-113.995305,25.732061,27.503291,-110.596735,23.278104,27.509957,-113.933154,25.047876,27.517481,-105.653660,23.336817,27.587524,-107.584820,22.515814,27.614505,-113.281445,24.411627,27.621749,-105.506864,23.562096,27.663864,-110.249919,23.247651,27.677240,-105.940415,23.009515,27.989372,-111.029366,25.532008,28.077412,-110.949574,25.589706,28.169089,-108.459750,23.430603,28.197662,-110.035356,25.353395,28.247517,-108.537184,24.840125,28.575356,-109.755369,25.598347,28.855909,-108.931979,25.570042,29.240700,-107.351472,25.264307};
			return value;
		}
		private double[] getCoordinate_9_21_point_172()
		{
			double[] value = {29.589285,-110.437050,25.884211,30.052119,-108.709875,25.279257,30.136466,-107.981637,25.099751,30.673828,-106.951027,25.073377,24.867970,-101.178622,20.672676,24.955073,-100.632502,21.489807,25.880757,-99.948026,23.615036,25.932098,-99.989901,23.531599,26.905964,-100.460976,22.909029,27.226267,-100.265970,23.487346,27.375105,-100.745028,22.853924,28.160351,-100.520566,23.612495,28.502569,-100.736771,23.746800,28.862661,-100.609719,24.092583,30.775831,-100.056850,25.976093,25.827698,-78.106448,17.097928,25.872793,-78.094670,16.874944,26.544787,-78.019096,17.597752,27.873908,-77.923166,18.721950,28.598107,-78.053903,22.933468,29.035132,-77.732450,16.792116,29.338431,-77.748665,19.993128,30.034316,-77.693829,20.186045,31.433750,-77.594777,22.461009,31.511000,-77.610776,21.839727,31.870263,-77.489650,22.185639,32.695350,-77.423101,23.364618,32.845103,-77.381352,23.000612,32.882908,-77.227733,20.763100,33.663758,-77.194538,24.538297,24.886166,-53.019849,17.864136,24.962066,-58.259554,20.860531,25.712053,-55.630342,23.552525,25.785226,-54.454007,23.798810,25.909537,-53.403488,22.589372,25.927139,-59.672160,19.514000,25.971940,-55.408193,23.856020,26.172935,-56.263349,23.339928,26.225034,-54.226012,24.266925,26.382662,-56.643964,23.019161,26.433104,-53.310253,23.514014,26.486635,-52.555560,21.156929,26.523091,-52.034536,17.994206,26.745602,-52.655061,23.361154,26.795885,-52.591784,23.233460,27.069554,-52.069409,19.687988,27.161844,-58.459278,21.181898,27.589080,-51.657567,20.777763,27.757300,-54.437861,25.466703,27.936407,-59.199598,19.655038,28.193508,-52.875371,25.658387,28.244456,-52.517181,25.373995,28.413861,-57.240113,23.202021,28.424893,-51.767247,25.682612,28.585062,-59.181887,16.764326,28.626521,-57.158784,23.413438,28.754664,-58.670357,18.238251,29.081323,-58.673290,17.746826,29.284347,-60.471834,16.591958,29.509753,-57.848105,22.209988,29.566643,-60.557526,16.770640,29.785335,-59.495118,17.488304,30.557082,-57.208810,22.965618,30.573640,-57.719297,19.450426,31.189502,-60.489447,18.089636,31.241634,-61.234982,16.608403,31.735246,-60.923335,17.761519,31.996990,-59.776818,19.241268,32.172962,-60.697271,18.433575,32.419206,-56.474357,21.246857,32.601823,-59.890601,19.563336,32.834931,-56.793714,21.271484,32.940068,-60.896031,17.613782,33.099690,-59.511557,20.238692,33.159107,-58.830136,20.617935,33.458203,-54.323783,25.534231,33.529530,-60.774312,18.423493,33.602770,-60.754737,18.482015,34.367269,-60.301225,19.693133,34.647222,-57.414795,22.460648,27.678618,-51.200178,22.864180,27.717289,-51.176725,21.252076,27.783301,-51.169680,22.943494,28.751826,-50.649762,22.946480,28.799732,-50.759259,24.785371,28.891911,-49.708698,21.775600,29.226537,-49.398127,20.564408,29.243209,-49.160846,16.270480,29.348313,-50.008198,25.984302,29.565027,-49.622557,23.007733,29.573968,-49.504090,23.371077,29.745655,-49.826272,18.924630,29.832876,-49.141747,22.916838,29.951856,-49.431160,24.805999,30.202806,-49.100025,19.105049,30.261564,-48.833458,19.595435,30.425791,-48.980380,16.908495,30.427748,-48.221944,22.339341,30.491626,-48.270853,21.843162,30.569433,-48.631867,24.161678};
			return value;
		}
		private double[] getCoordinate_9_21_point_173()
		{
			double[] value = {30.583823,-48.594002,23.947651,30.777750,-49.086975,17.270187,30.816359,-48.606864,16.894040,31.003202,-48.431019,18.837024,31.077512,-48.744907,17.861714,31.243868,-47.138842,24.092831,31.276619,-46.922415,22.302546,31.389360,-46.641973,21.546637,31.415534,-46.722840,15.865178,31.425542,-48.478988,17.488617,31.442468,-47.423639,25.367629,32.322702,-45.714910,23.191282,32.557569,-47.009909,18.807133,32.687148,-47.066737,17.524483,32.734426,-44.838743,22.446381,32.751766,-46.487286,19.218567,32.755505,-47.291069,16.806094,32.757082,-44.901756,21.635465,32.835654,-46.809909,17.937352,33.407522,-44.826797,19.899710,34.083897,-45.604285,17.163349,34.104792,-43.735737,22.180777,34.117105,-45.578091,18.195500,34.201999,-45.717931,15.927306,34.246328,-43.695040,20.717204,34.353453,-45.313947,16.884765,34.491648,-43.701118,19.456737,34.633261,-44.382569,24.853263,34.788234,-44.383819,18.831962,32.396377,94.598330,22.352102,33.057907,94.190766,22.051435,33.503977,94.292461,21.868965,33.911279,93.516264,23.159864,33.922793,93.356233,22.513141,34.217939,92.855007,25.335466,34.796083,92.688082,23.539700,34.963008,92.675994,21.261244,25.739403,99.760637,20.716090,25.901189,100.307587,17.156137,26.564976,98.920402,21.750781,26.586915,98.927100,23.135560,27.134090,98.477518,22.656359,27.177350,98.538945,23.703638,27.912014,98.938131,21.053802,28.055844,97.468288,25.732019,28.097643,98.038049,23.131652,28.545786,97.515042,24.663125,28.632603,97.235148,25.345474,29.747360,97.151382,22.084710,29.790935,96.931382,22.245596,29.846994,96.371275,25.665600,29.992477,97.756473,21.575839,30.144204,98.292649,17.620058,30.152532,98.094211,17.118224,30.527325,98.318146,18.267127,30.814961,96.978827,21.970895,31.290171,97.615292,16.003079,31.361319,97.904679,18.190746,31.395026,95.200877,25.703642,31.503135,95.995800,22.155542,31.606862,95.298460,22.367761,31.771287,97.142840,17.523430,31.774150,97.512703,18.424761,31.834901,97.488071,19.486053,32.651598,96.826485,18.101790,32.849296,96.627577,17.159631,32.933089,96.730599,15.827141,33.028298,96.925022,19.265238,33.110827,97.036551,18.711941,33.166910,96.428562,17.461244,33.336157,95.270766,21.742769,33.425148,96.278040,17.472252,33.597781,95.111512,21.658311,33.681773,95.562168,21.247214,33.739573,96.139275,17.282461,34.033820,96.024636,17.477736,34.495799,94.848007,21.137676,34.580943,96.192827,18.180477,34.710527,95.631425,19.151836,35.074385,94.813406,20.532977,35.173759,95.761420,17.735957,25.549383,-140.838234,30.350036,26.367626,-140.474586,32.420619,26.387357,-136.467921,31.711575,26.866869,-136.616447,31.955261,26.975175,-137.572742,31.254395,27.079874,-140.196073,34.018177,27.148742,-137.429185,31.458910,27.240317,-135.915818,32.527140,28.298750,-136.134431,33.291004,28.696711,-137.396914,32.644497,29.344916,-140.348817,33.497946,29.922401,-139.361133,33.733124,30.091556,-135.744279,34.838076,30.761487,-139.722119,34.513254,31.203739,-137.318910,34.633076,31.627501,-136.808308,35.195268,32.070828,-136.099454,36.217898,32.100762,-137.277653,35.369430,32.247917,-139.456751,35.734067};
			return value;
		}
		private double[] getCoordinate_9_21_point_174()
		{
			double[] value = {24.876586,-129.306788,29.011262,25.303976,-129.568561,29.449775,25.386844,-131.387075,30.034568,25.858306,-124.727372,28.511335,29.719094,-134.819184,34.501590,30.044882,-126.184815,32.653718,30.190915,-131.571325,34.202889,31.496345,-126.960019,34.138236,31.562555,-126.779453,34.147419,31.786137,-127.027709,34.414828,32.959175,-130.278802,36.308367,27.556905,-123.000588,29.433603,27.695047,-123.640074,29.773817,28.487620,-116.894738,27.996736,28.724210,-114.234895,27.302944,29.072847,-120.716676,29.947985,29.189879,-117.222056,28.744381,32.252986,-121.565780,33.120762,32.315153,-122.268669,33.436995,33.452577,-114.838440,31.893888,33.763412,-120.498106,34.095393,33.826807,-122.755293,34.968841,34.554090,-123.751819,35.906437,34.691243,-114.432387,32.924076,35.154630,-114.847459,33.493656,27.950212,-113.079500,26.159676,28.233094,-113.437102,26.537508,29.610203,-111.973599,26.247417,30.279497,-112.476463,26.541029,30.289428,-111.848476,26.269759,30.696871,-107.760265,26.874232,30.733787,-111.198424,26.799745,30.859962,-110.222773,26.237690,31.071159,-105.033588,26.703316,31.154245,-110.265130,27.806428,31.512189,-109.832332,26.718889,31.800088,-108.426708,27.563457,31.837384,-109.916598,27.546909,31.954077,-112.450632,29.581440,32.287096,-108.950859,27.198691,32.334199,-104.803763,27.787032,32.502679,-106.822605,28.128722,32.656296,-112.024142,29.269080,32.788725,-113.484402,30.810940,32.833980,-110.029960,28.661892,33.076973,-113.138968,30.683513,33.154817,-105.608095,27.685914,33.229197,-105.305964,27.761934,33.241936,-106.366628,27.727243,33.299588,-111.229771,28.952444,33.330542,-108.324346,28.082926,33.418703,-104.778491,28.345753,33.421507,-108.209596,28.098017,33.422342,-111.179638,29.004549,33.424852,-108.088958,28.073801,33.452258,-111.978684,29.344561,33.908657,-108.225910,29.558016,34.002383,-105.355846,28.271023,34.039383,-108.565934,28.850734,34.066041,-104.795521,29.414064,34.094174,-113.080115,31.910588,34.415916,-106.410810,30.132831,35.134332,-107.792787,31.183761,35.158394,-109.176622,31.570405,27.256223,-96.591028,30.141945,27.353285,-96.895213,29.858516,28.092515,-99.347812,26.251258,30.909922,-99.656548,26.858532,31.268638,-98.263600,30.542959,31.722583,-98.160348,31.020430,32.233241,-100.894173,27.052612,32.355688,-99.917898,27.254056,32.376599,-98.143316,31.467181,32.525255,-95.841217,34.841318,32.708378,-94.388512,36.323220,33.131271,-94.816563,36.289325,34.217362,-97.413479,33.926869,24.773358,-85.423932,31.124018,24.789088,-85.239327,30.887815,25.080887,-86.166699,32.547655,25.234077,-85.401072,31.602176,25.355537,-87.761055,32.289895,25.429094,-85.913722,32.680106,25.711329,-86.788682,33.206179,25.883530,-87.597548,32.812075,27.182487,-86.015851,34.608837,28.093392,-87.290249,34.838479,28.277712,-87.285509,34.998357,28.278701,-92.618759,33.956984,28.982256,-85.123219,35.933659,25.330955,-80.103861,27.488715,25.602024,-81.002471,28.774304,25.790994,-79.524692,27.313348,26.207273,-79.656522,28.095548,26.773104,-78.801368,26.374816,27.112882,-82.632602,31.335157,27.182365,-79.799126,29.225353,27.402529,-78.778646,27.274995,28.211223,-81.146043,31.472879,28.336009,-80.824329,31.347693};
			return value;
		}
		private double[] getCoordinate_9_21_point_175()
		{
			double[] value = {29.037919,-78.790261,29.792949,29.067317,-79.190226,30.653383,29.549463,-78.837555,30.713301,30.242107,-78.624014,31.267254,30.323701,-78.221227,29.418764,30.795072,-78.444029,31.717642,30.914820,-77.893903,27.659225,31.090042,-78.966364,32.739523,31.094888,-78.910382,32.659701,31.532335,-78.252783,32.187508,31.561996,-77.788217,28.921687,31.851508,-78.141579,32.626245,32.113038,-78.811921,33.897527,32.952509,-77.371302,27.047842,33.209041,-77.488817,33.225537,33.313890,-77.220214,31.682154,33.410564,-77.448873,33.500842,33.413305,-77.169570,28.532996,33.692177,-77.020074,32.327839,33.726738,-77.100390,29.297503,33.824278,-77.047996,29.096646,35.161849,-77.242261,35.815010,28.274123,-52.872104,26.335285,28.385750,-51.719699,26.685249,28.402084,-54.061661,26.266520,28.420557,-53.566423,26.567053,29.597581,-51.921798,28.798158,29.659203,-53.617749,27.521300,29.750536,-53.985694,27.234559,30.412778,-55.119512,26.275392,30.833631,-54.304968,27.487596,31.204806,-51.807487,30.098863,31.303258,-55.014811,26.921297,31.381814,-52.909731,29.047820,31.475274,-52.585075,29.514655,31.589927,-54.789210,27.269522,31.701925,-52.596096,29.668572,32.075749,-52.953799,29.287003,32.163047,-54.186471,27.998994,32.495310,-52.678382,29.897859,33.924219,-52.891933,29.045916,34.137637,-52.848522,28.751382,28.538671,-50.901189,26.785297,28.863615,-50.517554,28.498645,28.922989,-50.429435,26.287228,28.986365,-50.205652,29.033459,29.138309,-49.422046,29.039166,29.210996,-49.809602,29.496667,29.307028,-51.407943,28.626374,29.369090,-51.315377,28.779889,29.784410,-48.401141,30.469627,30.109530,-50.648651,30.454938,30.164598,-48.702071,31.854047,30.468795,-49.600291,31.679072,30.694223,-49.372467,32.104440,30.730269,-47.651375,32.562917,30.740898,-47.538196,29.331774,30.948145,-47.483070,32.907202,31.037649,-47.794363,27.997220,31.078196,-47.011582,31.140266,31.176994,-50.510828,31.332276,31.294165,-46.625194,33.695306,31.546453,-47.558915,34.516759,31.560516,-47.407148,34.678294,31.667801,-51.002703,31.092626,31.767352,-48.871853,33.199027,31.825713,-46.734821,35.501064,32.003789,-42.746983,35.952464,32.055575,-46.979828,27.655963,32.084439,-45.844437,31.439936,32.093655,-46.742397,28.376806,32.234972,-43.371352,35.530509,32.573761,-41.071320,36.148469,32.733370,-42.234798,34.985125,32.812779,-42.716608,35.032654,33.088360,-47.353315,35.435384,33.239769,-43.776281,32.602036,33.271601,-43.726733,32.479222,33.283364,-44.048564,31.780328,33.360356,-43.692368,31.955155,33.397544,-45.513486,28.107062,33.568581,-43.400485,32.233224,33.635931,-44.167710,31.363495,33.893523,-51.102188,31.807583,33.989564,-41.949918,33.923084,34.100824,-51.149810,31.803630,34.242375,-43.587215,30.695652,34.279725,-49.199735,34.188394,34.407456,-41.112364,33.399665,34.457690,-44.885350,26.857408,34.481085,-42.894356,31.241476,34.489541,-50.532808,32.553865,34.539813,-44.811191,26.818649,34.630880,-41.294125,33.121055,34.701836,-43.888685,28.413162,34.783495,-49.919201,33.068743,34.846996,-41.652464,32.600190,34.927661,-41.940815,31.075501,34.937562,-42.978556,29.999558,34.988941,-41.971506,30.976351};
			return value;
		}
		private double[] getCoordinate_9_21_point_176()
		{
			double[] value = {35.002557,-41.737001,31.103428,35.113484,-50.301683,31.982608,35.124717,-42.838773,29.527859,33.427622,-39.986000,34.468056,33.702221,-39.253554,36.115743,33.730729,-40.380166,33.862761,33.768854,-40.200587,33.791675,34.083686,-38.564954,33.523242,34.360948,-38.778344,33.219851,34.459918,-39.850030,33.283754,34.714408,-37.832141,34.913067,35.176418,-36.663148,33.935166,27.572448,94.738321,33.035570,27.818870,94.196612,33.781899,28.310963,93.936735,33.525787,30.828420,94.442648,28.607309,31.949959,92.297242,31.181898,32.494250,91.931503,31.075483,32.652099,92.931660,28.385287,32.853704,88.930652,35.238883,33.129970,90.608479,32.408053,33.539732,92.157977,28.459485,33.604927,92.802478,26.921945,33.649740,92.676553,27.056885,34.106110,86.734834,35.554887,34.370932,85.617497,36.050347,34.494538,87.723859,34.274647,34.816961,91.191361,27.963193,34.993786,87.372632,33.277869,24.965208,97.958939,29.712281,27.199713,97.798833,26.375394,27.667155,97.435558,26.517747,29.949902,95.218725,28.264763,30.169077,95.790079,26.614252,30.506828,95.479722,26.752376,26.155277,-138.716093,41.876105,29.017490,-139.437745,38.367560,32.464671,-136.086026,36.507344,32.582358,-139.800328,36.890263,33.240720,-135.796953,37.305035,33.726199,-135.667738,37.751909,34.328539,-139.616941,38.113170,32.650990,-134.789291,37.017557,33.355570,-130.937025,36.814833,29.318816,-85.967390,36.677522,29.319138,-85.236059,36.483004,29.675376,-86.208473,36.887835,29.969049,-84.858228,36.866955,30.765694,-88.471500,37.011263,30.840014,-84.371560,37.190489,31.159768,-84.567205,37.986321,31.348502,-87.135877,37.566471,32.491916,-85.473574,39.668014,32.543634,-86.483937,38.871825,33.100525,-84.429534,40.090275,33.404403,-84.756734,40.538714,33.944675,-86.030995,40.245044,33.994418,-86.106601,40.214656,34.573422,-91.478550,39.580086,34.643178,-85.494943,41.197378,35.167291,-83.188153,40.945163,33.139246,-81.908018,37.702430,32.126647,-41.740629,36.411977,32.401285,-45.918044,36.571436,32.680623,-43.021854,39.284013,32.756907,-41.149594,40.293965,32.771098,-41.294094,40.071528,33.140603,-41.879537,40.692497,33.225678,-43.348287,39.493934,33.268039,-41.110036,41.113187,33.557385,-42.197726,40.767376,33.561581,-46.201211,36.807989,33.633804,-43.105163,39.743198,33.863718,-43.258849,39.753626,34.108165,-41.454621,41.655176,34.288130,-41.689803,41.604908,34.648274,-45.858212,37.798762,34.793237,-41.330342,42.143511,35.067185,-44.795230,38.943143,35.171397,-47.125178,36.636177,31.356403,-32.580775,46.035650,31.391524,-32.595595,46.718766,31.542387,-32.737303,46.435843,31.569254,-32.726353,46.632981,31.665605,-33.397186,46.361829,31.678680,-33.657536,45.186565,31.809719,-35.343460,44.354469,31.843736,-33.496624,46.685840,31.979458,-35.829361,43.588366,32.042883,-33.317695,43.882805,32.171768,-34.497160,45.870032,32.191640,-38.576152,40.233085,32.206471,-38.103204,41.079571,32.285765,-36.836327,42.968544,32.288069,-36.735021,42.936652,32.303743,-37.159262,43.251869,32.353784,-37.601614,41.097679,32.403762,-38.411015,42.189075,32.423589,-39.850449,40.302348,32.430617,-32.787548,43.663493};
			return value;
		}
		private double[] getCoordinate_9_21_point_177()
		{
			double[] value = {32.438709,-36.529530,42.249460,32.473652,-38.938747,42.309397,32.515052,-39.991360,41.486770,32.539470,-38.672580,42.377963,32.544149,-35.340011,45.787772,32.557964,-32.437723,43.966627,32.569115,-40.727340,40.281971,32.592175,-34.674536,42.752671,32.596071,-31.147258,44.718987,32.674359,-40.826014,36.558350,32.677078,-40.503712,41.284398,32.780371,-36.733583,40.960911,33.007998,-39.812263,38.502966,33.097656,-31.912549,43.612865,33.110974,-40.154371,36.786058,33.208866,-35.761307,41.499767,33.322812,-35.952562,40.236663,33.390383,-37.329952,44.591023,33.404750,-31.558295,42.337036,33.516854,-37.000989,38.824164,33.529931,-38.830513,38.417544,33.631303,-39.335097,43.176335,33.634256,-39.006258,38.152282,33.913686,-34.882990,40.113725,34.030073,-36.171596,46.096761,34.266832,-36.231254,38.376910,34.364806,-35.746944,46.438515,34.527975,-37.155484,45.324224,34.585223,-32.806655,40.959860,34.608205,-31.008621,41.286897,34.640222,-38.479981,44.311940,34.737815,-33.208910,38.456975,34.803568,-34.855852,37.966638,34.867427,-38.210374,36.524478,34.881942,-32.358391,38.958976,35.090765,-31.700341,40.034450,31.177997,-29.811403,46.494003,31.396140,-29.430996,46.522255,31.433997,-29.060053,46.680842,31.982935,-23.032729,46.667760,32.031489,-28.806087,45.857833,32.314114,-28.650266,45.360048,32.336411,-29.344377,45.078571,32.613396,-22.485796,46.150081,32.931511,-29.624310,44.796673,33.182268,-27.767333,44.662924,33.506278,-20.528355,45.347252,33.749792,-29.305920,44.174699,33.813699,-23.370803,45.489376,33.815957,-30.567191,43.669297,33.897110,-22.018839,45.379335,34.020119,-26.257242,44.526663,34.572401,-24.736595,44.807014,34.617191,-28.268184,43.624189,34.803874,-24.652507,44.602553,34.855054,-21.094153,44.657026,34.917367,-21.005298,44.589565,32.037605,-13.254237,46.717332,32.721572,-12.343495,46.379211,33.232348,-11.826870,46.159583,33.288315,-18.337511,46.545999,33.323013,-15.931604,46.719630,33.459791,-19.586778,46.689660,33.467078,-10.347642,46.357404,33.945012,-16.981706,46.134002,34.012075,-13.728628,46.011550,34.480396,-18.452081,45.306244,35.020727,-16.082818,45.532267,35.104971,-11.631910,45.686027,34.004909,-9.019612,46.186197,34.404102,0.620337,46.413689,34.410532,0.373645,46.554994,34.850929,-6.803621,46.082201,35.133392,-6.024994,46.259936,30.841624,4.371125,46.302725,30.842181,10.198565,46.664975,30.940840,4.554914,46.247665,31.778392,8.978840,46.711444,32.628520,4.318251,46.554507,32.811087,11.062241,44.803295,32.987771,4.457921,46.402130,33.106649,6.087137,45.206490,33.381007,9.737206,44.940794,33.391571,8.667360,45.921355,33.606862,6.985263,45.397907,33.835075,9.171900,45.249922,33.863031,11.077061,43.772762,33.958424,8.811536,45.352824,33.974616,7.074216,44.907964,34.063420,1.003273,46.571309,34.348124,4.537513,45.831578,34.608741,9.741102,43.839626,34.639525,9.073617,44.211972,34.771060,1.483931,46.000523,34.790279,9.264786,43.865704,34.860091,9.165083,43.866794,34.865560,1.705625,45.848268,34.876718,10.204344,43.081311,34.927128,3.920605,46.058161,34.968193,1.054435,46.194338};
			return value;
		}
		private double[] getCoordinate_9_21_point_178()
		{
			double[] value = {35.132135,8.397195,43.916398,35.156181,5.270240,45.015482,25.497431,17.422827,44.631973,25.594615,18.783343,44.882305,25.890946,13.488539,46.393704,26.222878,15.330372,44.841760,26.836703,20.724516,45.825000,26.843523,19.124786,45.120566,27.112798,17.620370,44.502834,27.381327,18.338526,44.816248,27.476176,17.335646,44.160614,27.655694,19.686214,45.254242,27.728743,14.503440,44.356461,27.933500,19.228312,44.893730,28.025313,13.479503,45.286607,28.200441,16.981894,43.544104,28.402493,16.777344,43.303107,28.772831,19.244258,44.730866,28.774905,12.182808,45.625763,28.984044,12.816920,44.953707,29.151356,15.554440,43.002215,29.466452,19.868337,46.480265,29.708135,17.619340,42.738800,29.889530,16.791895,42.133189,30.022365,15.538497,42.580777,30.139464,12.640714,44.976801,30.339282,16.673706,41.940098,30.408650,19.564586,45.652628,30.570127,11.830703,45.867413,30.627708,17.698969,41.974242,30.695212,13.462446,44.000732,30.797959,16.556607,41.770176,31.001784,13.405213,44.105338,31.034322,15.357536,42.431171,31.136408,16.392488,41.702746,31.172609,18.173421,41.921146,31.239801,19.353199,43.574043,31.274653,13.550696,43.956249,32.075349,18.788641,41.544585,32.243466,19.160696,41.750587,32.299915,19.442218,44.611862,32.404794,18.518523,40.796138,32.435235,20.221486,42.278874,32.527698,11.593102,44.942733,32.535265,11.504332,44.975401,32.706707,19.667609,41.420615,32.737590,18.638849,40.620089,32.787681,19.459815,45.056172,32.806939,13.632886,43.481833,32.818477,20.536232,41.333853,32.878695,11.785108,44.557334,32.882042,19.378852,45.466544,33.028737,13.768847,43.258485,33.068372,19.797921,44.314166,33.435127,20.341156,40.067429,33.526615,13.665810,43.166891,33.676310,15.625028,41.516196,34.164069,21.615424,43.528694,34.183188,19.241356,40.129124,34.352685,18.009241,40.385262,34.561450,20.323775,39.647362,34.616784,15.027955,41.349308,34.724187,11.569170,42.690476,34.866404,13.650941,41.699354,35.119957,17.807369,39.686495,33.423456,22.416406,40.051053,33.778922,23.719076,39.665212,33.834133,31.444895,44.974549,33.904971,31.328350,44.926795,33.944207,24.194368,39.596496,34.253823,30.768752,45.329986,34.352527,24.598764,39.132973,34.762268,29.401854,43.038979,34.867456,30.539486,43.459873,34.902650,30.597780,45.842054,34.905581,24.488422,42.247786,35.064132,28.271908,43.403348,35.079674,22.064003,38.893806,32.200962,36.024645,46.132635,32.210084,37.898023,46.683510,32.476052,35.117053,45.896146,32.563303,38.097705,46.254691,32.616865,33.865774,46.704515,32.810286,37.626403,45.823905,32.951358,33.617061,45.766020,33.195637,33.082868,46.301291,33.227406,33.050950,46.220090,33.340444,32.655357,45.910776,33.398982,32.672223,45.510439,33.514849,32.756308,46.466055,33.613731,32.572639,46.343676,33.665419,32.507225,46.374559,33.675572,39.165081,45.578028,33.765739,36.937428,45.302363,33.776215,37.880718,45.105004,34.669381,39.540944,44.487659,34.873550,39.722204,44.430480,34.962892,39.477472,44.097093,34.918727,49.278433,44.580143,34.967975,48.641287,44.604203};
			return value;
		}
		private double[] getCoordinate_9_21_point_179()
		{
			double[] value = {35.009665,49.755719,44.804931,35.061035,48.994885,43.636669,35.095026,49.672210,44.135763,35.152596,49.940374,45.864214,28.299521,84.194701,45.375339,28.631244,82.299578,46.691778,29.932243,82.594752,46.291380,30.403367,82.624034,45.913440,30.434018,82.470683,46.028008,30.890281,81.080888,46.731112,31.885673,79.724602,46.234110,32.040157,82.407818,44.214501,32.575066,83.754302,42.015287,33.054969,82.479083,41.996245,33.677287,78.204238,45.389263,33.795174,77.680529,45.679197,34.005085,79.854685,42.653614,34.060151,83.960947,39.828428,34.117570,74.753816,46.707443,34.291469,83.233696,40.267515,34.467802,83.533188,38.725512,35.042496,82.788367,38.415555,35.110260,79.167945,41.984346,35.151844,75.256699,45.186256,25.014200,94.049546,37.871636,25.073560,88.696112,43.886056,25.435541,86.356372,46.075099,25.636541,91.006734,40.841807,25.965379,86.885967,45.175627,26.163743,90.999990,40.423212,26.312557,89.150701,42.405384,26.571743,85.091603,46.550992,27.152017,85.777456,45.515425,27.250884,90.549644,40.096439,27.564692,85.129648,45.601710,27.792975,86.608968,44.014228,28.435267,86.699141,43.229877,28.456127,85.070220,44.646879,28.529459,85.741644,44.036034,28.540561,85.102730,44.616078,28.548224,84.441038,45.168379,28.681730,86.752086,43.099147,28.917663,85.500290,44.269168,29.506762,84.931400,44.505742,29.784042,90.224737,37.796884,30.065880,89.018316,39.174344,31.141083,85.569862,42.383003,32.290962,84.882003,41.333448,32.416291,84.393346,41.631373,32.453008,86.424736,39.535773,33.233036,84.932949,40.115408,33.706649,85.066042,38.948617,34.054851,85.397877,37.356551,24.795612,-136.300790,54.719280,27.313092,-137.635154,47.860889,27.941069,-137.653941,47.843197,30.216875,-137.379843,49.626811,31.502904,-136.351305,55.345844,33.552926,-136.744379,53.500774,33.936273,-83.260410,55.880502,34.403810,-85.067138,55.998603,34.848162,-83.820662,54.953523,32.593241,-81.527201,56.209066,32.702443,-79.769484,56.831887,33.280548,-75.325834,57.095985,33.873640,-81.478479,54.645922,34.439232,-82.041508,54.064133,34.741581,-81.780273,53.591478,34.801482,-82.177140,53.598804,34.959395,-76.619065,55.004272,30.425070,-31.095855,47.737959,30.521154,-31.178935,47.458142,30.664466,-31.321582,47.199726,30.738997,-31.366683,47.076522,31.489427,-30.664800,49.500194,32.403462,-30.800538,49.635369,32.652071,-33.515537,47.702434,32.878191,-33.812207,47.510343,33.446982,-32.066446,48.800524,33.471469,-30.695431,49.493730,33.923753,-30.903656,49.199719,33.932062,-33.293028,48.178630,34.534533,-35.052320,46.916005,34.943009,-31.641896,48.448863,35.067188,-34.874085,47.012061,24.780169,-20.643772,53.497909,25.134163,-21.218736,53.006208,25.295146,-20.375692,54.373824,25.365965,-21.886997,52.473846,25.402625,-20.823701,51.316189,25.655088,-21.361457,51.103628,25.801683,-22.504670,52.485146,25.961857,-21.782366,53.407502,26.087210,-21.653581,53.673366,26.396805,-23.496856,50.749265,26.476134,-23.198037,50.512067,26.513798,-23.350880,50.451217,26.569112,-22.094279,50.247627,26.579149,-23.705953,51.471720,26.829668,-21.637963,54.611114};
			return value;
		}
		private double[] getCoordinate_9_21_point_180()
		{
			double[] value = {26.993966,-22.458469,50.007149,27.129054,-22.718594,53.759703,27.224127,-22.722710,49.990818,27.598580,-25.421767,51.002440,27.674018,-22.789296,54.156699,27.747400,-24.676224,49.896540,27.926825,-25.608317,51.308752,27.964547,-22.133526,49.437758,28.024322,-25.309682,50.078277,28.122066,-23.011349,49.369532,28.178867,-25.727597,51.648099,28.393363,-20.291471,49.472865,28.405121,-24.582918,52.861868,28.429297,-21.172118,49.317919,28.442356,-20.866488,56.750846,28.502133,-23.136018,54.544878,28.504060,-22.053680,55.634953,28.662090,-25.061031,52.587248,28.732099,-22.012083,55.910381,28.783301,-27.018526,49.746977,28.789987,-26.662412,50.114347,28.792323,-26.751909,49.892052,28.822346,-27.214293,49.875582,28.925475,-21.118237,56.634968,28.933491,-27.450268,49.803351,28.970298,-24.133112,53.844058,28.999042,-24.539711,53.131550,29.101254,-21.580968,48.997945,29.218469,-20.841185,48.734306,29.219158,-24.436496,53.652215,29.571536,-26.602813,48.237700,29.736289,-20.866454,48.521501,29.888892,-20.830527,48.469763,29.989553,-29.495487,48.956861,30.070100,-28.424315,48.113281,30.146512,-24.122238,54.354137,30.149631,-28.692839,48.197151,30.210372,-30.368670,48.476615,30.234785,-27.358540,47.779002,30.432376,-27.757041,51.447323,30.553359,-29.013623,47.331584,30.795203,-24.673875,54.108862,30.817483,-25.889662,47.299739,30.903438,-28.410362,51.182828,30.903475,-22.065887,47.661070,30.958584,-22.880702,55.244709,31.127298,-28.433071,51.225408,31.138153,-20.247350,47.972553,31.375528,-29.940519,50.089290,31.453106,-22.634536,46.811010,31.550401,-22.193212,46.911125,31.657992,-26.259043,53.076677,31.719950,-24.376467,46.764238,31.775524,-21.590470,55.518743,32.190345,-23.279707,54.415794,32.265412,-26.894267,52.586954,32.304728,-29.767746,50.782665,32.492913,-27.813574,52.063656,32.760683,-20.505553,55.824637,32.941485,-23.697698,53.669648,32.950497,-28.709877,51.429296,33.170349,-29.414587,51.021861,33.394347,-21.094163,55.238050,33.655660,-28.514534,51.269435,33.870424,-29.113161,50.850816,33.908087,-25.520850,52.394693,33.915537,-21.555028,54.740374,34.029337,-23.363710,53.359419,34.136583,-30.003582,49.948955,34.245014,-20.609345,55.495447,34.299018,-20.939177,55.208870,34.352699,-27.469062,51.110884,34.485702,-26.965059,51.192229,34.515956,-30.217459,49.740406,34.804327,-28.297481,50.466338,24.804083,-19.430008,50.905881,25.248680,-10.142777,50.340017,25.313423,-19.409476,55.881614,25.695671,-10.622666,50.520699,26.228299,-16.071333,50.113993,26.792520,-19.592707,56.715715,26.812401,-10.124780,50.652170,27.948899,-11.502343,50.467281,27.967404,-18.007075,49.020673,28.318464,-17.938900,48.836441,28.506174,-19.148454,49.196425,28.723553,-10.938208,50.215137,28.836483,-16.874206,48.711722,29.062952,-16.267345,48.983379,29.266384,-13.306596,49.179011,29.330312,-12.394166,49.226253,29.547502,-15.650230,48.425247,29.833751,-15.656061,48.218352,29.903973,-13.012838,48.827976,30.030663,-15.355418,48.134296,30.133876,-18.573124,48.657372,30.211743,-18.009676,48.559157,30.816151,-14.444420,48.146668,30.987302,-16.480416,47.995279,31.195550,-17.102130,48.147799};
			return value;
		}
		private double[] getCoordinate_9_21_point_181()
		{
			double[] value = {31.413978,-19.803081,56.690081,31.466649,-19.678262,56.750639,31.659813,-13.325495,48.642917,31.780774,-11.465485,48.906472,31.894483,-13.228174,47.800508,31.956682,-13.134260,47.160037,32.002573,-16.370739,47.742495,32.133369,-10.021746,48.946106,32.170049,-11.897666,48.735643,32.195818,-12.781757,46.884692,32.310996,-10.124211,48.878517,32.390961,-12.323875,47.690761,32.459818,-11.018213,48.702267,32.755696,-11.897072,48.094259,33.447993,-10.193158,47.820901,25.295767,-5.234639,49.915920,25.414921,-7.340081,50.257282,26.485534,-6.109431,50.435160,27.310321,0.224728,48.572668,27.416179,-1.653598,49.268610,27.427441,-7.558793,50.609105,27.484196,-4.352798,50.244908,27.521394,-3.715137,50.039361,27.523500,-1.360155,49.217286,27.895215,-6.531061,50.576335,28.005006,-0.446293,48.914884,28.603745,0.052723,48.830638,28.623171,-7.751243,50.377327,28.673229,-8.675013,50.322153,28.831294,-4.189950,50.157649,29.099599,0.267202,48.820439,29.196714,-7.289104,49.565488,29.285139,-2.466164,49.800438,29.318349,-5.164514,50.137059,29.464580,-4.575702,50.044195,29.492075,-3.730212,49.878325,29.517409,-4.809145,50.006096,29.753901,-5.835656,49.563967,29.807920,-5.105555,49.642528,30.214228,-2.358737,49.625231,30.377683,-5.443133,48.840434,30.383264,-2.583039,49.580892,30.391950,-3.833629,49.376144,30.586801,-5.624913,48.854660,30.861303,-9.307221,48.913818,31.482414,-5.938821,49.102900,31.508507,-2.405757,48.643915,31.707664,-2.610117,48.144939,31.758297,-6.556669,49.131710,31.903249,-1.159774,48.690441,32.406865,0.345864,48.389835,32.444293,-8.284478,48.656407,32.694537,-1.105755,47.516220,32.724420,-8.574789,48.648435,33.120813,0.284575,47.669860,33.205562,-0.626382,47.169063,33.212326,-5.306503,48.659743,33.638366,-1.867228,47.860494,33.733959,-9.103853,46.851958,33.906135,-7.761719,48.149396,33.994633,-3.520867,48.324124,34.627246,-3.191646,47.865600,34.679100,-1.258646,47.545330,34.766225,-1.001630,47.416525,35.033881,-2.528151,47.606682,35.125543,-2.279106,47.503666,24.756930,3.992288,49.812560,24.809181,10.323977,48.932380,25.010089,1.289566,49.398743,25.210794,8.450325,49.391308,25.428387,10.863924,48.530538,25.429979,5.767325,49.472112,25.520163,4.070871,49.725779,25.627524,9.331743,49.082138,25.768415,10.075750,48.641893,25.800693,8.753276,49.184588,25.933069,4.501913,49.737681,26.079457,5.649536,49.601776,26.094587,5.753169,49.605159,26.886657,10.940283,48.000769,26.906672,5.080848,49.586205,26.986194,10.411596,48.209575,27.137826,1.649570,47.599194,27.250594,9.531938,48.351130,28.502627,1.785942,47.606782,28.548706,5.257201,48.983446,28.868705,6.044862,48.872414,28.961187,6.127180,48.820190,29.490033,7.819826,47.934535,29.831370,2.861306,47.148795,29.868930,8.540829,47.658224,30.412194,1.739129,48.114833,31.025359,0.736259,48.630821,31.094240,1.131863,48.341498,31.361748,2.522941,47.721660,31.739521,2.786631,47.590165,32.680615,1.388183,47.924962,33.063244,3.652200,46.927076,33.151411,3.626127,46.904180,33.153313,1.470158,47.850489};
			return value;
		}
		private double[] getCoordinate_9_21_point_182()
		{
			double[] value = {25.469887,13.614559,46.922240,27.421308,11.916922,47.230415,29.436849,19.805162,48.080787,29.843732,19.643805,48.458352,30.919425,20.636524,50.322155,31.316584,19.055437,48.092872,31.465740,21.018049,50.807852,31.502408,20.890376,50.715133,31.593066,21.055092,50.820898,32.331598,19.281295,48.438542,33.304904,19.850995,48.698696,33.602911,20.337963,48.963492,25.377573,27.688762,50.098378,25.432806,27.389836,49.937977,25.519187,28.125599,50.418864,25.661227,22.664436,46.959781,26.523644,26.957489,50.411695,26.589568,28.507365,51.710062,26.690264,28.563041,51.889538,27.126585,26.899203,51.270831,27.825177,28.719934,53.826571,28.115084,28.011382,53.555793,28.225326,27.412716,53.233001,28.423700,28.635255,54.251736,29.119864,30.784864,55.941266,29.206955,31.301732,56.242734,29.311206,30.577741,55.859599,29.523809,22.067707,50.590897,29.629840,24.016109,51.870846,29.687362,27.060326,53.645667,30.011856,23.299969,51.745637,30.093889,29.933525,55.524232,30.364453,28.103490,54.287867,30.602249,31.062223,56.232165,30.794597,21.748616,51.173217,31.339106,27.843584,53.647932,31.519971,24.580840,52.087694,31.792807,31.732123,55.956192,31.906560,27.043422,52.720968,31.926986,23.747132,51.760021,32.010182,23.073045,51.598996,32.018785,25.817409,52.147572,32.049890,25.061761,51.888732,32.318309,30.086451,53.737526,32.954793,26.614866,51.269874,32.990103,28.777680,51.694303,33.328282,28.971593,51.109034,33.565017,29.606548,50.759477,33.604731,25.923022,50.313798,34.220427,29.364407,49.814905,34.227902,28.755287,49.362818,34.567582,27.572517,48.769037,34.688260,23.204418,48.770324,34.838797,27.577591,48.348376,34.986102,23.166421,48.065697,35.014336,31.503034,47.409756,35.098949,31.914485,51.499814,35.125005,31.193024,47.167444,24.850606,34.384103,54.468891,24.885376,32.416029,52.769569,24.957199,34.760250,54.835061,25.408591,34.640025,54.574023,26.297550,34.332408,54.858653,26.526066,38.118833,56.417106,26.755966,39.803752,56.935133,26.998697,37.574307,56.276389,27.065490,39.229313,56.377591,27.251438,39.666415,56.346436,27.441607,37.569024,56.523342,27.748852,39.742496,56.434392,28.062589,32.258691,56.083501,28.206406,42.477473,56.181361,28.943348,41.697390,56.733828,31.605689,36.938895,47.782515,31.935477,32.683491,56.475867,31.993672,37.364266,49.102567,32.053915,37.833060,46.835503,32.149629,38.524323,47.096996,32.164361,38.488398,48.570605,32.195307,38.433953,49.076804,32.362397,38.522601,46.767210,32.371112,36.865834,49.796146,32.577920,37.581963,50.059150,32.709677,39.257685,47.388482,32.836832,35.779532,56.527709,32.883721,37.990755,50.386610,32.946395,33.318613,47.127239,32.974074,36.174775,56.471982,33.023275,41.670767,56.992720,33.023385,34.201250,49.478845,33.048456,39.315068,46.905596,33.057104,37.299174,56.509728,33.095562,38.309492,56.506744,33.103836,34.688969,50.088710,33.139711,35.722617,56.303548,33.151231,42.294427,57.019675,33.173310,33.110171,47.367833,33.179510,33.719447,48.585420,33.311688,42.409534,56.228166,33.318326,33.580165,48.346303};
			return value;
		}
		private double[] getCoordinate_9_21_point_183()
		{
			double[] value = {33.496473,39.570082,49.389075,33.500131,41.999724,56.072800,33.599087,33.548610,49.360695,33.875334,37.066845,51.707175,33.988498,41.304936,55.870537,33.999495,34.989286,51.181839,34.019035,35.649104,55.918407,34.138336,38.308107,56.003029,34.165778,37.873253,51.965577,34.165994,40.225777,48.655313,34.312741,40.365597,48.566270,34.343952,39.485665,55.866385,34.417299,40.159592,50.089742,34.500683,36.440552,55.771789,34.532938,37.345159,55.781729,34.542941,39.054809,55.747659,34.777659,34.129382,51.653749,34.880490,33.526007,51.444373,35.015483,37.044245,55.370280,35.041175,32.736268,52.031545,29.621154,47.600201,55.937121,29.759335,45.524761,55.787176,30.000000,46.171107,55.702601,30.387989,46.725668,55.521029,30.402677,47.839961,55.573825,30.604998,47.408818,55.412851,30.793830,46.591828,55.669449,31.032434,44.756504,57.123776,31.589365,47.650343,55.434005,31.670063,52.606862,55.314311,31.706039,46.126578,56.661146,31.922044,48.800978,55.007478,32.190101,51.379548,54.285779,32.558949,51.163379,53.707676,32.586193,46.799699,56.494309,32.591970,48.495991,55.405727,32.739874,49.814570,54.634510,32.835221,48.058604,55.811626,33.006372,45.006258,56.904598,33.212913,42.560683,56.472270,33.272412,42.854996,56.433999,33.306441,50.590595,54.258913,33.429904,51.268648,53.670914,33.435352,43.767283,56.414586,33.484630,51.525691,53.324916,33.536469,51.869187,52.776565,33.549431,45.324182,56.242325,33.650321,51.169760,53.891041,33.734103,49.995783,54.756140,34.072959,50.792361,54.203945,34.139687,46.984068,55.402671,34.466222,51.859825,53.317776,34.485362,45.091331,54.575730,34.511151,47.570334,53.725779,34.643693,43.541107,55.013431,34.667908,48.340427,54.557281,34.698499,48.314444,53.863042,34.767644,48.402847,54.127561,34.936210,49.557893,52.424081,34.945662,49.124728,53.568818,34.948694,49.591903,51.908588,35.005555,49.365582,53.382067,35.087045,52.872224,52.083191,35.168210,50.477833,48.689039,35.170577,50.036925,52.339571,26.250658,57.063409,56.803196,27.107159,57.278433,56.899097,27.469447,60.832949,56.722765,27.620498,59.033932,56.677381,27.744635,63.164894,56.617187,27.788388,60.299462,56.480182,27.842528,56.600097,56.956913,27.944187,56.134196,57.075145,28.097082,62.986659,56.322975,28.345099,56.589649,56.763876,28.509620,60.556242,56.094474,28.564637,63.017077,55.446948,28.633146,62.777082,55.614293,29.057156,57.593148,56.262526,29.554353,61.499919,54.525397,29.607742,55.762341,56.126840,29.623517,57.369690,55.792606,29.632077,58.550736,55.538714,29.677847,55.937517,56.023985,29.712225,60.313379,54.900109,29.946991,56.923619,55.384047,30.299911,61.189681,53.233543,30.699891,60.149216,52.435384,30.763343,61.906109,51.508766,30.835839,53.908748,55.644405,30.849477,58.019269,53.739086,31.314241,56.187852,54.087984,31.425875,61.173587,51.296304,31.686325,55.052765,54.222241,32.015065,60.121795,51.050706,32.123791,55.990751,53.116620,32.440223,61.407659,49.445377,32.532926,59.067658,50.189754,32.724144,62.647222,48.889829,32.821379,56.552492,51.969649};
			return value;
		}
		private double[] getCoordinate_9_21_point_184()
		{
			double[] value = {32.914166,56.515684,51.807660,33.029853,56.709858,50.079096,33.373109,55.490804,50.583171,33.543330,55.344830,50.377503,33.614804,55.075488,50.703887,33.796062,58.597239,48.330391,33.837809,54.817793,50.667088,33.880414,53.754185,51.240323,34.052811,56.250257,48.760059,34.350152,54.637691,50.230648,34.965572,54.255766,49.639536,35.001087,58.662322,47.865605,35.019499,53.546675,50.528515,24.742586,70.371856,55.516218,24.751910,71.209040,55.289610,25.639663,67.291425,56.046681,25.753390,67.790201,55.548399,25.973679,73.162858,53.794459,26.137877,69.962443,55.333950,26.463628,71.868510,54.095532,26.485148,65.546650,56.924598,26.508883,70.032635,55.165394,26.668706,65.415914,56.724194,27.194302,65.517453,55.374308,27.246347,72.613427,53.012712,27.310177,64.284178,56.737977,27.315648,64.194678,56.768849,27.593908,72.257923,52.908446,27.687957,68.295311,53.626168,27.706191,68.766072,53.316618,28.320319,67.363421,52.950786,28.602722,73.557369,51.597698,28.685336,73.535875,51.543778,28.711552,66.638370,52.655594,29.111350,65.574249,52.430205,29.444440,72.485689,51.267816,29.494370,64.377663,52.446111,29.512196,64.449703,52.330793,29.562351,70.225181,51.912852,29.794912,70.129642,51.592202,29.827351,67.760959,52.027218,30.165670,69.809523,51.171440,30.413742,65.085771,51.448672,30.584553,72.726745,50.784131,30.593464,69.060398,50.963529,30.629324,68.579967,51.311945,30.823244,66.136665,51.308969,30.823948,70.471424,50.629947,31.158902,65.181592,50.992284,31.528011,73.465860,49.238818,31.759615,73.727852,49.106954,31.785667,71.413056,49.952616,31.834286,64.806859,50.359388,31.921152,72.006578,49.312100,31.923851,65.175403,50.238305,32.072668,67.132627,49.466756,32.295913,71.561684,49.115906,32.317497,72.039129,49.035887,32.320553,63.861075,49.567924,32.430618,63.938055,49.187157,32.549689,67.639061,49.382391,32.594560,71.221392,48.952066,32.741062,68.492842,49.475751,32.849917,65.253426,48.817626,32.899164,69.307517,49.176295,32.929411,64.008991,48.707109,33.220740,68.030971,48.916823,33.350140,71.476159,48.650901,33.357252,67.010587,48.843161,33.391834,72.148841,48.555826,33.396520,63.800940,48.598981,33.629074,65.512452,48.551290,34.109525,65.611047,47.860495,34.521254,64.481587,47.564536,34.604498,66.407404,47.731749,34.888185,65.757988,47.583058,34.991560,70.142925,47.096719,24.858194,82.253253,49.843238,24.922356,76.257659,52.841795,24.933779,75.658607,53.130639,25.224819,83.436705,48.746375,25.655013,74.820398,53.098686,25.776987,80.081585,50.889298,25.841304,80.899224,50.387373,26.620150,82.771490,48.595125,26.922863,82.086476,48.876601,27.406052,78.583540,50.685866,27.821856,83.081949,47.212826,28.033450,77.749510,50.651899,28.101473,74.439352,51.717907,28.452865,74.553795,51.496012,28.491854,79.437709,49.600178,28.690669,79.195692,49.430307,28.750257,81.552394,47.166592,28.951994,79.118154,48.812731,28.993955,80.431652,47.784866,29.002913,81.029870,47.407163,29.161334,79.813877,48.092902,29.225449,80.784232,47.506110,29.233029,79.178650,48.419906};
			return value;
		}
		private double[] getCoordinate_9_21_point_185()
		{
			double[] value = {29.245653,80.604038,47.600628,29.889088,75.248541,50.455158,30.143843,76.022130,49.365935,30.367259,81.018539,47.234294,30.688597,78.645612,48.476220,30.795859,75.031057,49.251162,31.054757,76.375173,49.001007,31.452618,75.169980,49.066809,31.717567,78.078628,47.884082,31.732020,77.410340,48.251404,31.914233,79.016469,46.960412,32.057688,74.023374,49.052648,32.241778,74.000019,49.004293,32.606480,75.483559,48.348012,33.107501,74.688692,48.191375,33.575801,74.879970,46.991721,33.923224,74.311964,46.886959,30.679030,-135.546204,59.577239,25.377416,-134.980566,61.917345,26.390186,-134.803519,63.008079,25.909558,-84.977305,67.219223,25.927768,-84.647651,66.952011,28.173169,-84.925347,64.242776,28.282775,-86.853274,65.733778,28.592197,-84.911909,63.676411,28.712234,-87.270701,65.625779,29.457494,-87.304751,64.586826,29.860883,-87.768005,64.613846,30.386999,-88.903628,65.706502,30.887627,-88.008730,63.438474,30.918188,-87.504000,62.730640,31.280338,-87.469571,62.152532,31.662843,-82.961207,58.654274,31.823836,-85.836111,59.826125,31.963526,-83.399316,58.447706,32.577508,-89.754029,64.005160,32.917134,-89.452314,62.677197,25.178478,-77.174641,64.841364,25.302751,-79.960855,64.525190,26.286719,-78.429391,63.390790,26.476310,-75.033131,64.215545,26.684825,-78.041289,63.290048,27.087210,-80.488255,62.640696,28.150990,-82.568892,63.023826,28.743232,-81.103957,61.110011,28.779976,-79.600145,60.544659,29.658295,-78.729415,60.264658,30.427472,-80.534306,58.633660,30.914732,-72.456083,60.244020,30.980639,-81.422632,58.285305,31.317740,-81.200338,57.698580,31.381824,-80.942183,57.557172,31.407613,-79.549287,58.232833,31.602396,-81.677396,57.721697,32.079204,-79.757296,57.443204,26.086065,-68.865040,66.660235,26.465684,-69.757069,65.762056,28.985949,-70.074035,63.524422,29.048612,-66.693003,66.530448,29.289143,-70.763325,62.756537,29.384105,-66.886430,65.952039,29.640599,-71.232269,62.152476,30.417452,-69.347256,62.783131,30.888971,-66.488704,65.106203,31.240902,-71.597016,60.306080,31.662092,-71.081430,60.183728,32.811100,-63.907815,67.248228,32.839380,-65.443644,65.006019,32.946958,-63.861415,67.248018,33.151639,-71.596165,58.456910,33.499531,-71.533177,58.226505,33.605491,-63.859339,66.522409,33.640221,-71.541251,58.052658,33.664564,-64.331785,65.835179,33.865246,-63.841479,66.373343,34.285150,-70.453545,58.140564,34.697303,-70.061096,58.038904,34.713407,-63.394309,66.642347,25.032878,-14.916033,60.413699,25.938382,-12.417742,60.701278,26.389189,-10.410951,60.974963,26.985507,-18.677090,57.936996,27.420400,-10.313205,60.979486,27.676507,-11.930746,60.683083,28.035026,-12.142194,60.597552,28.799521,-15.361983,59.585050,29.076666,-12.950954,60.162991,30.064644,-19.332209,57.245436,30.141880,-15.008175,59.488771,30.476685,-10.441996,61.018908,30.553774,-12.613866,60.058768,30.672900,-18.359830,57.689939,31.085003,-9.924949,61.540566,31.472231,-18.169364,57.837748,31.572570,-11.348196,60.730407,32.030509,-11.851184,60.504922,32.169312,-15.120585,58.590866,32.339782,-11.407753,61.176762,32.939805,-11.576725,61.459615,33.013228,-9.958870,62.418583};
			return value;
		}
		private double[] getCoordinate_9_21_point_186()
		{
			double[] value = {33.051413,-13.635268,59.203300,33.884173,-14.409967,58.578131,34.055730,-11.096860,62.946742,34.160594,-13.949698,59.033727,34.202489,-13.400725,59.698730,34.411853,-12.195500,62.435346,34.419717,-16.374677,57.254726,34.531694,-11.984984,62.677418,34.546266,-11.128583,63.368333,34.622926,-12.735257,61.323273,34.930732,-12.042680,62.847317,35.013481,-15.599834,57.576602,25.338828,-3.162392,64.244997,25.456793,-3.299320,64.471848,25.484181,-3.293467,64.395513,25.531221,-9.096954,61.274816,25.655019,-3.755987,62.976531,25.741024,-2.779388,66.194833,25.858841,-4.802352,62.221564,26.073546,-3.586209,64.682550,26.111247,-4.147938,62.675875,26.159218,-3.680697,64.473879,26.565673,-3.798691,63.412010,26.746931,-6.186591,61.649234,26.820095,-4.392609,62.576107,27.177362,-3.413333,64.934484,27.317853,-4.384539,63.513934,28.000789,-2.725502,67.364127,28.098240,-4.115833,64.180131,28.189765,-3.063716,65.838092,28.202686,-6.515697,61.393179,28.465361,-3.207616,65.709345,29.535197,-3.632194,66.382444,29.954388,-4.219340,67.080288,30.008039,-6.952748,61.352730,30.251679,-6.941825,61.393507,30.368392,-9.249507,61.308113,30.662597,-4.462158,64.748093,30.821324,-4.203915,65.871203,30.945209,-4.343127,65.372601,31.442345,-5.132967,67.015415,31.715365,-6.761523,63.465010,31.894451,-6.837546,63.554593,31.977299,-4.955631,66.363070,32.089193,-5.557784,67.099026,32.264111,-7.515945,61.894158,32.506355,-7.288752,62.591095,32.627864,-5.346777,65.653762,32.770304,-5.408447,65.915789,33.066078,-5.558543,66.496269,33.291026,-5.653029,66.125457,33.381564,-9.174197,62.107121,33.430447,-7.642646,62.912062,33.456935,-7.721193,64.161746,33.825865,-6.014188,66.349426,33.919904,-7.379858,65.522460,33.977959,-6.128283,66.453054,34.168623,-7.873080,65.558425,34.527251,-8.444064,62.740308,34.556152,-8.251983,64.379409,34.665946,-9.382257,62.684536,24.857469,39.460068,57.691290,25.064530,37.988839,57.330133,25.196947,38.235811,57.439255,25.383450,41.322029,58.102720,26.973644,42.025347,57.860913,28.070221,36.638410,57.187436,28.549723,37.665713,57.718633,28.886634,37.544274,58.003499,29.275654,39.531446,58.049833,29.744933,33.679690,57.443027,30.062237,42.528104,57.570603,31.213713,35.814999,58.240206,31.354368,35.738248,58.207044,31.465740,37.197178,58.472198,31.758252,36.949812,58.363115,31.869514,38.711616,58.498850,32.186245,38.101362,58.300544,32.277086,38.177428,58.236647,32.469688,37.970673,57.953870,32.530937,40.517635,58.092826,32.713962,40.556514,57.828752,32.950801,41.695492,57.476952,24.998840,44.892462,59.211096,25.134323,47.995975,59.292069,25.231431,52.737375,58.726618,25.297450,46.122068,59.420907,25.630368,52.397029,58.483386,25.897465,47.202615,59.082334,26.001985,52.639490,58.310111,26.072057,51.045441,58.711157,26.096667,52.096253,58.482510,26.135817,45.286785,57.967359,26.578101,45.386343,57.662797,26.609404,44.525397,57.928373,26.624249,47.480800,58.591454,26.657063,45.559793,57.609351,26.739996,47.317468,58.447462,26.833143,48.851845,58.269728,26.922349,48.814995,58.217766};
			return value;
		}
		private double[] getCoordinate_9_21_point_187()
		{
			double[] value = {27.242816,52.895693,58.137186,30.934059,42.739419,57.952062,31.117520,43.599826,57.684516,32.742502,43.965594,57.302836,24.946244,56.116400,58.360129,24.973437,59.431497,57.442820,25.332800,62.795504,57.960540,25.389714,58.022310,57.366077,25.575494,55.561758,57.633022,25.731423,53.225765,58.231213,25.905910,55.979547,57.163342,26.448393,60.453180,57.139094,26.687112,53.574914,58.042941,27.632087,55.228249,57.340369,28.238601,53.867244,57.446988,28.600431,54.635401,57.146265,24.833845,66.071546,58.668635,25.744706,65.955202,57.802765,26.408794,65.202142,57.241330,25.234231,-133.138615,71.832081,25.656080,-133.686748,68.932503,29.285395,-132.310532,76.840656,29.532234,-132.727082,74.627524,29.953778,-132.390103,76.501550,30.463802,-133.160050,72.417386,31.529053,-133.380499,71.371100,34.782071,-132.293437,77.669794,34.130720,-115.801628,75.069928,34.920685,-120.542704,74.412312,31.473849,-104.598378,77.063260,31.584633,-108.141598,77.397475,33.669413,-107.286693,74.917087,33.766614,-104.934404,74.522889,30.339032,-98.252916,77.350472,31.430363,-93.929388,75.503444,31.770879,-96.862634,75.600771,33.950062,-99.733791,73.552463,34.173489,-101.079591,73.493302,34.283587,-102.184490,73.548985,24.728377,-87.591547,72.177398,25.154725,-86.758357,70.024055,25.742300,-86.461494,68.844273,28.206985,-90.221809,76.718201,28.449332,-89.290655,70.342929,28.945450,-90.323054,75.279487,29.393428,-91.046080,77.026274,29.921046,-90.974659,76.351664,30.691842,-90.548708,71.750840,31.850862,-92.891020,74.775211,32.281126,-92.084450,74.098148,32.612116,-91.441153,73.269079,32.923971,-92.573021,73.461788,33.400600,-93.143710,73.074566,26.292781,-64.022391,71.724154,27.038071,-64.735384,70.191958,27.170490,-65.669131,68.846104,27.240784,-64.799538,70.058142,27.477556,-65.837316,68.462607,28.133194,-63.829759,70.543651,28.355061,-65.088320,68.684112,28.513345,-63.355932,71.150955,28.604215,-62.809094,71.990582,28.844411,-64.626187,68.884218,28.850522,-62.313429,73.034255,29.468697,-65.102745,67.844502,29.789953,-64.156031,68.847593,30.889562,-63.206019,69.564948,31.259218,-63.219187,69.287486,31.813476,-63.116807,69.129300,31.901173,-63.229009,68.967187,31.938928,-63.536307,68.499386,32.625638,-62.031076,71.116033,33.425246,-63.317084,67.795504,25.630420,-61.120542,77.567571,25.932018,-61.950055,75.620405,29.343280,-61.229190,75.200019,29.871338,-60.955457,75.752257,30.037718,-61.933009,73.074605,30.533559,-61.858437,73.035786,30.762204,-61.062762,74.788168,31.352458,-60.839075,75.024473,32.934265,-59.670685,77.242742,33.560928,-61.820728,71.198193,34.858826,-60.067313,75.254389,35.009123,-61.309837,71.542862,24.792975,-2.205959,75.877539,25.067314,-2.168788,74.045709,25.134586,-2.325941,75.404874,25.437992,-1.870551,68.331450,25.612135,-2.980380,77.831548,25.732727,-1.801706,70.387211,26.455771,-2.281780,75.437190,26.494280,-2.036441,71.035653,26.694116,-2.190639,74.452310,26.891128,-2.069220,69.378460,27.182119,-2.391742,67.781962,27.401530,-2.577061,74.898679,28.069590,-3.177112,74.190463,28.355067,-2.955402,77.076572,28.379393,-3.021003,77.656996};
			return value;
		}
		private double[] getCoordinate_9_21_point_188()
		{
			double[] value = {28.549488,-2.493830,71.759916,28.696197,-3.202858,67.735931,29.093369,-2.513174,71.127276,29.417977,-2.582356,70.940182,30.172820,-4.315239,75.622726,30.251020,-4.079129,75.001725,30.473859,-4.283612,76.195374,30.741989,-3.299859,73.979841,30.763573,-2.983719,71.907021,31.292507,-4.609920,75.631280,31.604076,-4.336201,76.542573,32.034820,-4.147147,73.768718,32.108422,-4.684614,69.024257,32.116443,-5.639320,68.194577,32.267274,-4.488725,77.198470,32.711843,-6.006544,68.959418,32.814614,-6.010810,69.153100,32.827802,-6.175424,68.900180,33.009741,-4.303712,71.430230,33.068855,-5.802086,74.087441,33.212430,-4.905170,72.366447,33.229222,-6.463975,69.064725,33.309429,-6.415873,69.857292,33.643190,-5.181304,76.799696,33.786930,-6.432817,71.594284,33.876647,-5.481866,76.815995,33.904511,-5.698537,76.878918,33.912164,-6.517858,72.049099,33.951859,-5.302649,76.285071,34.251174,-6.318322,76.756523,34.357946,-6.531828,68.289800,34.467751,-6.455225,73.278451,34.880536,-6.016559,74.881569,34.917530,-7.003638,77.329014,34.926790,-6.556316,72.344066,35.031449,-6.204271,74.456082,25.244113,-126.166696,87.928167,25.414687,-131.673449,79.758008,25.591542,-125.791213,86.438261,26.040639,-131.345076,81.612609,26.152956,-130.353363,86.976030,26.194718,-126.341005,86.539405,26.225095,-130.136052,88.157383,26.390210,-126.046814,85.681881,26.514440,-126.073173,85.486173,26.648239,-125.705248,84.981118,26.888476,-130.951409,83.849257,27.412520,-125.707580,84.074783,27.506237,-127.453130,86.197604,28.118628,-126.184927,83.406572,28.401343,-130.605127,85.919655,28.453758,-130.716620,85.325070,28.919443,-131.276384,82.368911,29.075547,-128.327950,84.715636,29.626687,-130.747391,84.537734,29.686807,-127.020478,82.138038,29.965043,-131.030769,83.833745,30.116589,-127.177597,81.722864,30.440923,-131.221178,82.870358,32.113275,-127.655728,79.446804,32.176685,-131.928389,79.289261,32.389503,-131.390502,81.399692,25.436819,-118.508833,85.652186,26.363512,-123.184282,84.842598,26.531547,-120.321818,84.337163,26.917036,-116.814691,83.736562,27.215540,-121.302070,83.565978,27.520618,-116.667222,82.961063,28.371988,-118.366055,81.948970,31.134715,-124.661378,79.384578,27.533009,-107.946888,82.230336,28.790654,-108.438702,80.713357,29.091616,-108.800124,80.389027,30.125160,-113.663595,79.574425,24.891763,-96.818216,83.144718,25.046341,-96.570643,82.939628,25.074140,-98.737277,83.328575,25.922410,-98.846818,82.405270,26.090118,-103.123471,83.105649,26.302347,-94.628979,81.189367,27.690371,-101.060023,80.763251,27.904942,-98.045389,79.980100,29.674158,-102.299260,78.731240,25.187765,-89.878574,81.307385,26.634151,-90.433602,79.937829,26.706965,-90.109216,79.545824,24.766612,-57.927204,83.546085,25.132355,-60.863015,78.249829,26.647440,-56.660648,85.216071,30.825605,-55.848631,85.561535,32.117473,-55.471741,85.765986,32.270997,-55.666001,85.472641,33.974495,-56.339924,83.797139,34.129497,-57.109551,82.303760,25.391640,-10.981405,86.343266,26.484715,-10.524598,85.083047,26.605938,-11.434856,87.653462,26.809072,-11.380605,87.419882,27.048710,-11.132311,86.259035,27.324565,-10.703236,84.941618};
			return value;
		}
		private double[] getCoordinate_9_21_point_189()
		{
			double[] value = {27.374452,-10.928975,85.610843,27.902868,-11.505181,87.713227,28.574662,-11.372624,86.939799,28.860651,-10.742060,83.914961,29.743862,-10.814816,83.299836,30.274567,-11.215185,84.749372,30.414971,-10.736775,82.639720,30.435176,-11.525796,86.629192,30.969462,-11.067873,83.090635,31.300982,-11.034351,82.620374,31.359421,-11.673057,86.902856,32.205720,-11.759766,86.670210,32.617716,-11.871836,86.701141,32.843442,-11.822174,85.577704,32.863022,-11.472036,82.788659,32.948473,-9.983478,81.440858,33.277024,-11.644072,83.626090,33.317487,-12.034887,86.589422,33.698654,-12.069816,86.496881,33.928633,-11.419279,81.374919,33.957407,-11.219896,80.984587,34.362016,-12.144307,85.134427,34.567814,-11.829597,82.245648,34.614937,-11.878996,82.538521,34.651109,-11.885058,82.407001,25.169148,-4.875924,82.478218,25.273454,-4.964728,82.506931,25.508585,-7.121006,84.625180,25.583779,-6.990482,84.444598,25.672469,-7.006139,84.412341,25.761576,-3.756978,82.155609,25.865133,-9.574549,84.733404,26.042875,-6.450259,83.559378,26.741736,-6.915883,83.677559,26.805398,-9.295570,83.936301,26.845683,-4.557096,82.593167,26.860028,-3.649510,80.896638,26.992505,-6.155203,82.798537,27.335106,-4.341266,79.495375,27.418679,-4.267112,82.254442,27.624883,-4.061011,81.016922,27.928911,-4.632887,79.874335,27.955817,-6.569449,82.752707,28.148090,-4.719846,79.430218,28.157988,-3.107960,77.902967,28.169678,-7.852111,82.929743,28.250912,-4.272326,81.761004,28.271202,-7.461201,82.831506,28.508293,-3.327703,78.185272,28.796333,-3.422298,78.193451,29.023287,-5.245248,80.001818,29.528992,-5.663488,82.701902,29.887699,-9.092735,82.679530,29.889011,-5.394399,79.626619,29.940862,-5.455987,80.136728,29.976145,-3.866049,78.447480,30.617468,-4.066368,78.345204,30.681149,-4.141783,78.395045,31.420162,-6.546767,82.453710,31.971950,-5.016163,77.993353,31.994390,-5.710050,78.569139,32.192377,-5.567967,81.309172,32.953332,-7.365538,81.953884,33.134391,-5.931196,77.918018,33.214319,-6.008546,79.078404,33.439669,-8.203416,81.704772,33.484937,-6.218983,81.464226,33.960943,-6.177136,81.094596,34.099808,-5.926736,79.891581,35.025667,-6.648932,78.273396,35.100020,-7.297371,80.892879,35.148002,-9.127554,80.586822,24.917860,-126.216902,88.386353,26.910693,-53.436056,90.573888,28.104640,-54.218122,89.051608,28.188888,-54.337901,88.840030,26.622336,-50.797159,94.697782,26.930341,-50.019333,95.883226,27.524265,-49.602368,96.353897,32.553219,-49.073852,95.996246,33.247040,-50.288867,93.859565,35.145397,-50.273767,93.259459,24.899913,-12.954389,91.457523,25.177675,-15.257344,95.265098,25.310589,-13.240676,92.193830,25.460925,-17.740437,98.281498,25.779044,-12.387998,90.238839,25.906004,-13.035953,91.750594,25.932705,-17.252809,97.920573,25.954320,-12.722981,91.137234,26.966775,-14.993973,95.139447,27.639415,-14.580055,94.759541,28.065892,-13.540756,92.954286,28.273706,-15.685464,96.244218,28.312594,-12.521197,91.089472,28.581794,-12.100515,89.915541,29.653656,-16.822958,97.490807,29.913388,-14.095624,93.712940,29.953927,-12.910791,91.546182,30.050107,-13.111704,91.873195};
			return value;
		}
		private double[] getCoordinate_9_21_point_190()
		{
			double[] value = {30.291857,-12.010225,89.261897,31.361512,-14.824073,94.671065,31.554239,-17.949308,98.231223,32.165812,-12.765271,90.375616,32.277884,-15.175987,94.876717,32.914677,-17.847050,97.781290,33.048694,-13.508738,91.767340,33.591516,-14.110240,92.754842,33.669460,-13.213845,90.635969,34.159532,-16.826114,96.221424,34.346982,-14.384493,92.874707,34.761287,-15.334495,94.146846,25.086172,-41.589531,106.796313,25.946406,-45.162266,103.341982,26.023023,-48.070216,99.030960,27.332763,-43.884273,104.720475,28.693103,-43.906201,104.423030,29.786210,-42.547226,105.524580,30.365089,-45.472256,101.915189,30.977429,-45.219248,102.089672,32.865722,-45.010379,101.974298,33.142745,-43.611842,103.374712,33.417537,-42.900695,104.086205,33.814294,-44.881891,101.707220,34.201692,-44.746436,101.675125,35.006314,-42.541254,103.761784,35.084993,-46.784009,98.729903,25.014308,-32.968390,106.514541,25.083575,-32.371087,106.385089,25.258820,-32.662896,106.422862,25.958442,-36.332808,107.174986,28.081560,-32.935279,106.482101,28.316700,-37.032170,107.209457,28.768676,-32.521106,106.317291,29.259170,-37.499417,107.162778,30.271223,-30.794136,105.685307,30.272959,-33.944200,106.600419,31.321945,-30.888548,105.556201,32.229591,-36.481508,106.724936,33.325045,-37.017222,106.500427,33.372687,-37.356057,106.490474,33.378403,-32.280732,105.603914,33.595817,-31.768384,105.368861,33.862313,-32.000248,105.366945,34.398130,-33.104785,105.498884,26.069492,-28.833774,105.322523,26.714880,-25.302884,103.643453,26.777465,-29.835673,105.660573,27.865161,-29.003916,105.300967,28.127280,-29.569028,105.448370,28.988152,-29.524404,105.400104,29.481739,-25.276653,103.510000,31.567762,-23.820016,102.496276,32.823479,-27.479149,103.991011,33.320211,-21.931736,100.936440,33.331278,-23.345619,101.790284,33.389777,-25.900667,103.115168,34.464508,-20.645711,99.622326,34.563641,-21.996120,100.655857,34.584766,-29.149702,104.069846,34.897322,-26.409540,103.021903,35.009409,-30.437058,104.481635,35.020909,-30.160353,104.404934,35.034517,-21.662146,100.196344,35.114131,-26.031208,102.698420,28.255523,-18.730670,99.345112,30.030998,-19.986494,100.197728,34.640269,-19.581312,98.790429,35.267612,45.070073,-26.145079,35.414204,45.013772,-25.993408,35.277008,63.142410,-28.268769,36.104698,60.619974,-27.607728,38.389582,61.598723,-26.033423,38.445320,53.197383,-25.987277,35.205703,73.266364,-26.153489,35.414387,66.919413,-27.759540,35.600661,70.774229,-27.544704,35.735089,70.117859,-27.594167,35.864504,71.845878,-26.279410,36.089159,65.526174,-26.965738,36.116119,70.067482,-27.448968,36.487741,67.791290,-27.549110,36.503060,66.260981,-27.591353,36.610684,65.066469,-26.749741,36.616461,65.548850,-27.000133,37.026792,67.078480,-27.302432,37.443832,65.480903,-27.080520,37.539367,65.770009,-27.197644,37.545413,64.149318,-26.453179,37.622288,67.834851,-26.937093,37.650764,67.738216,-26.945071,37.736968,67.217643,-26.927918,38.341518,66.940931,-26.390360,38.355921,64.256164,-26.057091,38.408531,67.020354,-26.206246,35.303149,9.897246,-23.962133,35.586507,9.493393,-23.797955,35.711089,6.512982,-16.284393,35.842866,6.810308,-15.935889,35.933273,6.396218,-16.600471};
			return value;
		}
		private double[] getCoordinate_9_21_point_191()
		{
			double[] value = {35.937224,7.247536,-22.045712,36.579455,9.019758,-23.484607,37.089146,6.878048,-16.860047,37.262551,7.781508,-16.347582,37.893995,9.796747,-23.494651,38.380635,7.558664,-21.822001,38.650350,9.806607,-23.063076,38.832236,7.629994,-17.170836,38.877219,6.969718,-20.150211,38.925748,8.412068,-16.109536,39.057253,7.070424,-20.195385,39.209327,7.105092,-19.850576,39.921130,9.826957,-15.920213,40.166329,8.605031,-17.926655,40.343432,10.346296,-21.856527,40.406621,10.133135,-16.731567,40.524069,9.868422,-17.269634,40.532656,9.222997,-21.148819,40.587873,10.582675,-21.574447,40.597649,10.435098,-17.059270,35.284887,21.390755,-24.189927,35.674735,17.771485,-24.011902,35.735339,20.891502,-24.231660,35.834004,20.893348,-24.224323,36.049652,12.835299,-24.233723,36.271143,19.638957,-24.137253,36.646310,19.654568,-24.051683,36.736557,18.016203,-23.981611,36.961101,20.253381,-23.942159,37.779247,11.872378,-23.886176,38.012385,12.190321,-23.798528,38.060438,18.671296,-23.322112,38.308428,16.165093,-23.127038,38.574131,19.313610,-16.814034,38.858808,16.709526,-22.627088,38.948268,17.751983,-22.455187,38.982453,16.359621,-22.553719,39.007451,19.659446,-22.449223,39.015264,18.031241,-18.556150,39.093542,12.547271,-22.988934,39.114799,21.466665,-19.120894,39.279791,17.570490,-19.707266,39.290220,20.416460,-21.968274,39.348906,14.486219,-22.531811,39.423129,20.604463,-21.510530,39.425038,19.539805,-21.238400,39.450392,18.664249,-21.124828,39.507043,17.273189,-20.953760,39.519040,17.033686,-20.380814,39.594526,16.017281,-21.515036,40.494430,13.854544,-20.466353,40.635299,11.976811,-17.212635,40.929316,11.519959,-20.751466,35.345819,26.928535,-24.007183,36.029689,29.358787,-23.356635,36.262018,27.351877,-23.689143,36.357259,23.478709,-24.129705,37.100478,30.631290,-15.742547,37.210002,31.337196,-17.596692,37.273943,30.456629,-21.783483,37.510753,28.592263,-22.331928,37.613775,30.559776,-18.809251,37.831437,30.012709,-20.058690,37.877584,28.703719,-16.929447,38.161697,29.087334,-20.286941,38.326190,21.786791,-15.551260,38.997490,25.539235,-20.674553,39.104764,24.608674,-21.385560,39.380333,22.014257,-20.459211,35.724970,35.245036,-22.206290,36.206188,40.827083,-24.287336,36.303802,34.647047,-15.921422,36.384715,33.809188,-16.059079,36.564820,35.063882,-17.220581,36.597431,34.838955,-17.533537,36.661640,35.246374,-20.948077,36.697982,34.552746,-19.367443,36.709223,35.010510,-17.554343,36.714860,32.141683,-21.819970,36.716509,34.323037,-20.548489,36.744437,34.858512,-20.625442,36.787700,35.563867,-20.848682,36.814942,35.141997,-18.683595,36.824769,35.267531,-19.152051,36.903764,36.320441,-21.164556,36.906516,33.601184,-19.698444,37.044298,36.519622,-16.771074,37.276041,41.694651,-23.612509,37.385801,36.568072,-20.692554,37.494765,36.966435,-15.609056,37.502634,41.620957,-23.403419,37.509838,36.292352,-18.999475,37.513183,36.286964,-18.906375,37.524454,39.456663,-22.715175,37.780793,36.754166,-20.116546,37.907133,42.307844,-23.180540,38.734335,38.258328,-21.016667,38.834529,41.847661,-22.653347,38.896538,37.673192,-17.432789,38.992883,39.568739,-21.572629};
			return value;
		}
		private double[] getCoordinate_9_21_point_192()
		{
			double[] value = {39.107679,37.625593,-20.021698,39.425490,37.877227,-17.536441,39.544343,41.716906,-22.556854,39.854202,40.372002,-21.670536,40.076487,38.029438,-19.831428,40.380004,41.259090,-22.334642,40.397612,40.878748,-22.114055,40.715357,38.431139,-20.159014,41.017840,38.700396,-16.122040,41.038191,38.495991,-20.262297,41.174492,38.361914,-19.157040,41.230224,38.341186,-20.068543,41.359797,38.417824,-19.229734,41.486277,38.787341,-20.669967,41.508098,38.496267,-18.940053,42.103271,38.809139,-20.699630,42.238667,40.056191,-21.717943,42.404081,38.456767,-19.045990,42.985240,40.059228,-21.520133,43.543751,41.720138,-21.811791,43.686026,39.230638,-20.529492,43.941565,39.545805,-20.660107,44.375425,41.916120,-21.357064,44.392280,38.880628,-17.465056,44.447943,38.730179,-18.726968,44.699982,38.674119,-18.435338,44.813517,40.936336,-20.504108,45.613222,42.213241,-20.513101,36.800044,46.616742,-24.640578,37.072377,46.406271,-24.375846,37.354000,47.303538,-24.281790,37.365934,48.709613,-24.872041,37.524554,46.377429,-24.016038,38.345488,47.993637,-24.124274,38.562092,43.075143,-23.154070,38.799588,48.704452,-24.220582,39.747832,44.319253,-23.364022,39.864928,42.740092,-23.002097,40.176603,47.855315,-23.183601,40.236021,48.529674,-23.227469,41.113443,48.524966,-22.775533,41.295321,43.012494,-22.880680,41.962446,46.407824,-22.345950,42.166092,44.731981,-22.541874,42.657105,43.993082,-22.440436,43.745367,51.259981,-20.571377,43.767970,47.325866,-20.529660,44.081195,45.992948,-20.448013,44.103955,52.921135,-20.897298,44.177561,50.719583,-20.087211,44.649564,44.294396,-20.879681,45.256859,48.370723,-19.542996,38.878226,62.433310,-25.777613,39.000810,55.909493,-25.797550,39.179381,53.114330,-25.376097,39.833995,55.979398,-25.137498,40.219069,59.619388,-24.736781,40.281482,61.927292,-24.398795,41.026681,59.112857,-24.208006,41.049529,58.704194,-24.279178,41.270487,59.611371,-23.866557,42.154897,63.255697,-22.549699,42.197893,58.247626,-23.294152,44.527420,61.356005,-20.232854,45.218524,61.988391,-19.338425,35.513773,71.423035,-24.442669,35.969612,71.552816,-23.445555,36.602872,73.817363,-22.276658,36.656138,70.685368,-23.227034,37.425433,73.163344,-21.959470,37.941843,71.038526,-22.209059,38.001776,69.013251,-23.193193,38.059631,70.292428,-22.452098,38.185859,70.988787,-22.035128,38.302864,70.063723,-22.369588,38.366504,71.815815,-21.688532,38.744826,67.288028,-25.056965,38.886983,67.110374,-24.712658,38.953480,73.140601,-21.104347,38.983225,66.990742,-24.787803,39.182913,66.747319,-23.998055,39.384097,72.846437,-20.833805,39.449574,69.042784,-22.085238,39.550979,70.647095,-21.179029,39.634230,65.578624,-25.099010,39.646872,66.903893,-23.319478,39.747861,67.176902,-22.985470,39.887244,65.276461,-24.813050,40.022969,72.262641,-20.277024,40.117370,68.910037,-21.627703,40.147464,65.796476,-23.583383,40.828306,66.232953,-22.515020,41.025621,65.379091,-22.744901,41.032523,73.546407,-18.803490,41.623858,63.999296,-22.841167,41.834274,71.766314,-18.585607,42.448000,72.228619,-17.440344,42.885216,63.798071,-21.652382,43.396651,63.661571,-21.169645,35.195791,81.599700,-20.832305};
			return value;
		}
		private double[] getCoordinate_9_21_point_193()
		{
			double[] value = {35.214442,79.224081,-22.742541,35.266365,82.609391,-18.761697,35.334426,79.428829,-22.604413,35.371334,80.397395,-22.124617,35.421515,77.994926,-22.810117,35.539057,75.826842,-22.299226,35.540909,84.058123,-17.918893,35.572152,78.049764,-22.859783,35.725244,81.050152,-20.355521,35.764334,83.692359,-18.173127,35.925581,80.764201,-20.368903,36.033799,83.849793,-16.018521,36.081364,83.082179,-18.558292,36.082470,77.144658,-22.801160,36.146397,79.052741,-22.340913,36.243742,77.289890,-22.860403,36.328786,80.170284,-21.121649,36.353315,74.473880,-22.080225,36.425029,76.157145,-22.614771,36.603704,76.031487,-22.619501,37.114094,82.252724,-17.058193,37.278701,73.921474,-21.757757,37.363348,78.657927,-20.622400,37.389880,78.707647,-20.415628,37.436157,80.726678,-19.407989,37.581248,81.580158,-18.487984,37.598835,81.796605,-15.802298,37.630109,81.180721,-18.992320,37.710226,81.418802,-18.109019,37.763252,77.631697,-21.789262,38.023768,80.796654,-18.465249,38.068949,74.479433,-22.028816,38.188703,78.928311,-19.694644,38.229980,80.800334,-15.997143,38.431410,78.357351,-19.787459,38.440286,80.191055,-17.127991,38.797552,79.474896,-16.984021,38.813781,76.560677,-20.974666,39.108716,78.073154,-15.831043,39.558850,75.703659,-19.715516,39.915176,74.292148,-20.491278,40.056877,77.106750,-17.026327,40.070569,76.603055,-16.607360,40.692938,75.975860,-17.080989,40.764339,74.991561,-18.606387,40.987601,75.261033,-16.695498,41.027911,76.422151,-15.559056,41.316924,74.859516,-17.128954,41.406549,74.717984,-16.545718,41.514725,74.254474,-17.325752,35.189827,-0.374432,-11.705683,35.278477,-1.339469,-10.571298,35.463934,-5.093397,-7.162907,35.501942,-6.336252,-5.363061,35.522009,-2.687924,-10.766541,35.711743,-3.199725,-10.501020,35.830930,-4.285474,-8.222069,35.844336,-5.068782,-7.191003,36.235382,-4.800123,-7.425643,36.253755,0.223757,-10.904164,36.293900,0.128645,-10.879426,36.370291,-0.484569,-10.788100,36.785390,-2.441353,-10.450687,37.125059,-3.685852,-8.467634,37.173222,-4.617057,-7.119671,37.200887,-4.037929,-8.173825,37.458184,-1.724450,-10.517011,37.484386,-5.198162,-5.712875,37.662837,-3.079036,-8.543986,37.994531,-3.672624,-8.142805,38.057831,-0.409485,-8.994070,38.094118,0.159956,-8.957862,38.155666,-5.590313,-5.361199,38.162025,-3.963784,-7.241613,38.288767,-3.642199,-6.662030,38.315418,-0.103345,-9.933957,38.417456,0.559066,-10.163909,38.611033,-1.056857,-8.439396,38.675970,-3.420396,-7.737841,39.062705,-2.952383,-7.873238,39.222163,-2.734720,-7.222980,39.282317,-4.732087,-5.281666,39.568433,-2.235461,-7.570934,39.658665,-2.605856,-5.295811,39.710389,-1.909098,-7.224430,40.066682,-0.436946,-7.651977,40.075031,-1.013089,-7.262277,40.260249,0.507568,-7.430688,40.276012,0.146903,-6.155940,40.764548,-3.438965,-5.299371,35.182376,9.923390,-9.194022,35.401386,8.920556,-14.163329,35.452833,3.040759,-12.564202,35.457878,2.187531,-12.557651,35.634179,7.760809,-10.507593,35.883476,1.269206,-12.319697,35.890332,8.642883,-9.447442,35.906735,7.990826,-9.927675,35.926683,4.383178,-11.711354,35.950949,2.467233,-12.328605};
			return value;
		}
		private double[] getCoordinate_9_21_point_194()
		{
			double[] value = {36.180705,3.990131,-11.386380,36.381538,6.432094,-9.844986,36.389602,10.734417,-13.995688,36.416279,3.625587,-11.293149,36.428579,7.850358,-9.440488,36.485551,6.060794,-10.020198,36.510174,9.739170,-7.323498,36.771292,5.764891,-9.777253,36.879360,5.500553,-10.552045,36.986328,9.005917,-15.313728,36.998832,5.530490,-10.413673,37.113439,8.813518,-6.885868,37.120473,4.583982,-11.080032,37.205367,4.419258,-11.119266,37.249543,5.312163,-10.229980,37.309189,8.642599,-6.578023,37.487362,7.939866,-7.277855,37.637531,9.849717,-14.486059,37.680154,3.870303,-9.442509,37.709002,7.587270,-6.866876,37.741607,7.305884,-8.112923,37.752949,7.035085,-8.631633,37.916820,6.934313,-8.551210,37.960195,3.320927,-10.730763,37.995857,2.598182,-9.386474,38.017341,7.916664,-6.028500,38.029664,6.804486,-7.943890,38.039799,6.991203,-6.522142,38.171331,6.462673,-8.643517,38.197954,4.690943,-8.739107,38.300289,5.452387,-6.191434,38.366021,6.022669,-8.167751,38.382166,1.390113,-9.989838,38.399388,1.450783,-10.289276,38.446935,10.008802,-14.122766,38.592116,9.126443,-15.064256,38.607326,4.640305,-5.900020,38.834412,4.161838,-5.997474,38.866190,4.115649,-6.082980,39.046832,10.958929,-13.069853,39.494324,2.943072,-5.490047,39.555389,2.862362,-6.168809,39.573495,4.097391,-5.353576,39.774538,2.368495,-6.622826,39.819777,1.372276,-7.922859,35.700547,11.917373,-8.599208,35.951772,12.564661,-10.901268,35.981322,12.687713,-10.116633,36.030561,11.527539,-5.289642,36.090756,11.971372,-8.482562,36.275621,11.192440,-13.578857,36.297053,11.428697,-7.581999,36.876812,11.772246,-12.562622,37.053012,12.160954,-8.482204,37.074658,17.835499,-5.712931,37.150993,12.300575,-10.642989,37.259428,19.045896,-11.018671,37.294215,19.411062,-9.034762,37.322920,18.610921,-6.474386,37.332167,19.577505,-10.402331,37.379397,18.856546,-8.855256,37.456065,19.606709,-8.023224,37.483652,19.882750,-8.507944,37.613604,19.935713,-12.751999,37.616072,18.721478,-12.088439,37.641800,20.519043,-12.456209,37.648482,12.276343,-9.860082,37.687663,12.200581,-6.038262,37.735751,21.596006,-11.115187,38.042073,11.894407,-6.977358,38.091428,19.972356,-7.253787,38.132049,11.900753,-7.146876,38.211002,18.022268,-14.720390,38.239352,12.044437,-7.811388,38.312160,17.148476,-11.282671,38.325067,17.117594,-14.077038,38.362037,18.254666,-15.434992,38.419546,11.975842,-11.050112,38.623196,16.848175,-8.804837,38.641507,16.426210,-13.166235,38.745548,16.434028,-11.687522,38.772443,19.840331,-5.856725,38.953368,16.343588,-10.251792,39.018404,12.565682,-7.827519,39.101391,20.933635,-5.946719,39.170533,13.616281,-7.620281,39.183710,15.712318,-12.452803,39.190214,15.427200,-14.199160,39.346571,21.135737,-5.641875,39.381995,12.051586,-11.404953,39.572412,12.589160,-9.988989,39.756056,14.837000,-11.092688,40.017801,13.371593,-13.802361,40.071289,11.916792,-13.968412,40.269458,12.141963,-15.328507,35.686585,31.399631,-11.369650,35.750240,32.078231,-10.488162,35.770342,31.701742,-11.122638,35.771442,30.294291,-9.213468,35.908529,30.536540,-8.214241};
			return value;
		}
		private double[] getCoordinate_9_21_point_195()
		{
			double[] value = {35.921672,31.525636,-10.038993,36.001883,29.548951,-10.005986,36.070246,30.749947,-8.793610,36.091679,30.723825,-8.190578,36.115748,30.195802,-12.044870,36.211591,28.981193,-8.045325,36.347739,28.797282,-7.701713,36.448729,28.291739,-8.660258,36.699565,28.483432,-7.150151,36.703315,30.913520,-7.837491,36.786203,28.040037,-7.925307,36.804355,28.760713,-6.943812,36.833173,30.412526,-14.532154,36.855589,27.422291,-8.207460,36.898968,30.419089,-14.836384,37.136432,27.326076,-12.974029,37.192172,31.930525,-7.562187,37.307573,27.246180,-6.581193,37.322998,27.606796,-13.603777,37.337449,27.140199,-13.502191,37.413141,25.167845,-9.550467,37.570245,24.709653,-11.649368,37.645232,24.573179,-8.937393,37.646108,24.230009,-11.625809,37.679119,26.073032,-13.981118,37.747968,23.256937,-12.652299,37.782270,28.796062,-6.225924,37.824339,25.601702,-14.347561,37.899427,26.082125,-14.830963,37.953647,29.239062,-6.641295,38.042364,22.666698,-8.835889,38.236766,30.727466,-7.485500,38.268627,22.658057,-15.232399,38.813872,30.830569,-7.610222,39.094073,22.115027,-6.021000,39.249432,22.475624,-5.732721,39.723256,31.259720,-7.409179,40.203207,30.170415,-7.352689,40.950539,30.739305,-7.173656,41.138701,30.089984,-7.138565,41.536450,29.634566,-6.704244,41.695801,30.853244,-6.595205,42.047508,29.628666,-6.403349,42.173553,29.471559,-6.217899,42.730448,30.986258,-5.720911,35.737850,32.373923,-11.699693,35.805319,32.449954,-11.523134,35.921360,32.310599,-9.782707,35.923656,32.309634,-9.154920,35.945511,33.886865,-11.697911,35.986296,33.156882,-13.386853,36.046883,34.448845,-10.420698,36.113259,34.107653,-11.496073,36.218058,34.726693,-11.830367,36.220139,34.650348,-12.505890,36.229950,35.030389,-15.028816,36.270930,34.608941,-14.793617,36.274773,34.213714,-10.019189,36.361473,34.100902,-15.451798,36.469969,35.165819,-14.285592,36.504383,35.853552,-15.279591,36.561130,33.348811,-9.280323,36.594568,33.551319,-8.624521,36.623994,32.584508,-8.252532,36.630710,35.517218,-14.358047,36.678137,35.829997,-12.803386,36.890115,36.214038,-12.010314,36.937155,36.044280,-11.136206,36.962400,33.745549,-8.881478,36.964632,34.480155,-10.067891,37.251247,33.639434,-8.112448,37.409288,36.685583,-13.161962,37.480077,36.824501,-12.983970,37.534967,36.769458,-12.047981,37.741527,36.936040,-11.196891,37.759980,33.997818,-9.104403,37.776224,33.076316,-7.466520,37.947804,37.183889,-11.675900,37.980437,37.219072,-13.751835,38.050895,34.999127,-10.274449,38.057004,34.093581,-9.096501,38.223149,37.076830,-10.806385,38.725848,37.725370,-12.217844,39.008099,34.583064,-9.920535,39.258864,34.844551,-8.808648,39.382536,37.009427,-10.765633,39.433917,33.712902,-7.506944,39.452558,34.843650,-8.449804,39.479951,37.013416,-10.775260,39.501034,33.658647,-7.430280,39.634915,33.173470,-7.201313,40.021343,34.197359,-7.639053,40.244245,38.533892,-12.140433,40.298936,35.467214,-10.439175,40.568026,35.076773,-8.084691,40.745292,38.693389,-15.505157,40.976974,34.486474,-7.786878,41.216797,38.897644,-15.135545,41.356485,38.851337,-11.542581,41.396441,39.135365,-13.361334};
			return value;
		}
		private double[] getCoordinate_9_21_point_196()
		{
			double[] value = {41.480843,39.198841,-12.307407,41.516337,39.038082,-14.542189,41.523268,36.079295,-9.538493,41.754086,34.241181,-6.458282,41.792659,34.406488,-6.807148,41.881406,34.969958,-7.682646,41.913584,39.267342,-11.917198,42.160973,32.804563,-6.628834,42.166379,39.008435,-11.331234,42.266296,35.406544,-6.788287,42.324652,36.942558,-10.550322,42.403885,36.601913,-8.585246,42.425194,36.858823,-10.510241,42.615052,39.383735,-11.554588,42.726163,36.392535,-7.961498,42.925780,34.643566,-5.532066,43.131392,36.730913,-8.462727,43.153540,36.025966,-7.161181,43.308936,35.844629,-6.243087,43.319535,32.732239,-5.495419,43.370864,33.387727,-5.496271,43.526436,35.942464,-6.576389,43.674010,39.217182,-10.906475,43.742872,39.445713,-13.463231,43.841062,35.399381,-5.644655,43.949874,33.625835,-5.312037,44.865989,39.088253,-14.124304,44.872313,36.078160,-6.073757,44.925433,38.548094,-9.702299,45.173364,36.068474,-5.692881,45.200587,38.879569,-9.921760,45.520789,71.898977,-12.515964,35.986516,84.203168,-15.198502,36.363858,84.050908,-12.602603,36.487676,83.991417,-13.662071,36.795571,83.473975,-14.378605,37.138370,82.389410,-13.086151,37.145940,82.914059,-12.284317,37.239179,82.731066,-14.844538,38.221656,82.799405,-11.290355,38.288004,83.896678,-9.763516,38.674236,83.433656,-9.964483,39.164704,82.134184,-10.945028,39.473863,79.564139,-13.788087,39.593343,81.603352,-11.064401,40.756885,80.619693,-10.775029,41.342365,81.991979,-8.550039,41.846918,78.711750,-11.473590,42.372335,74.459393,-15.389942,42.410685,82.156616,-6.328790,42.644214,77.412496,-11.575266,43.227770,80.445769,-6.804793,43.242595,75.834080,-12.338745,43.761606,75.275616,-12.074632,43.925866,75.493442,-11.461555,45.028566,73.994932,-10.978827,45.276388,74.959219,-9.327563,45.496389,76.814054,-6.235002,35.399476,85.539782,-9.367580,35.648329,85.023601,-10.922387,35.713055,84.856676,-10.666214,35.938678,84.560673,-10.540822,36.365748,84.721509,-9.694531,36.387286,84.554400,-9.925802,36.715292,89.555293,-6.415148,36.782117,86.963416,-7.681271,37.206154,87.808767,-7.358050,37.225423,84.480949,-9.586927,37.433269,88.806558,-6.813993,37.501607,85.449848,-8.778078,37.726280,88.729054,-6.784495,37.839309,89.144031,-5.868187,38.231077,88.255226,-5.747367,38.296684,87.691234,-7.154622,38.569207,86.872293,-7.593718,38.816880,87.148966,-6.016039,38.842965,87.024710,-6.189458,39.229841,86.151885,-6.831260,39.370873,85.566084,-7.511598,39.488266,84.871501,-8.234936,39.640246,87.025760,-5.466282,40.060899,86.517465,-5.572412,40.237800,86.111571,-5.358417,35.189096,-25.211521,1.601434,35.224089,-29.009796,2.485528,35.273181,-27.316666,1.984018,35.283612,-23.746933,-0.094207,35.291164,-20.498021,-1.442757,35.325058,-20.228768,-1.498700,35.333275,-26.295084,2.196041,35.660585,-28.395296,3.228719,35.696868,-21.261468,0.657773,35.779131,-22.978879,0.542351,35.908882,-21.394562,0.749814,35.933446,-22.775465,0.991249,36.103394,-22.535047,1.815531,36.124833,-22.181130,1.358352,36.236397,-22.114306,1.868469,36.269331,-23.679913,3.114870,36.467238,-21.029284,1.749115};
			return value;
		}
		private double[] getCoordinate_9_21_point_197()
		{
			double[] value = {36.666757,-23.377917,4.046459,36.931877,-21.084782,2.824146,36.976938,-24.200808,4.022574,37.211433,-25.406957,4.391625,37.235871,-20.692126,4.696553,37.298357,-21.372556,3.497738,37.452173,-20.953921,3.543865,37.465595,-20.528126,3.374436,37.497631,-20.799345,3.656796,37.611193,-20.250512,3.784440,37.635610,-22.972511,5.105565,35.200852,-13.343224,-1.117445,35.209700,-11.105371,0.411208,35.326406,-12.670277,0.102455,35.400235,-12.966110,-0.145484,35.428666,-13.061388,0.056801,35.438342,-19.081357,-1.515276,35.553698,-16.078214,-0.768861,35.573133,-18.329883,-1.264370,35.606436,-17.019524,-0.988182,35.639915,-18.644827,0.966480,35.662958,-17.918855,-0.844018,35.701091,-18.477111,-0.867366,35.734174,-15.608330,1.195445,35.743862,-16.513337,0.958267,35.793477,-15.902251,0.448232,35.832869,-16.691589,1.354311,35.915718,-16.288107,0.022344,36.106801,-16.483976,1.666950,36.352629,-10.561100,1.794119,36.676586,-9.916678,2.488086,36.747504,-18.238465,1.906972,36.834961,-10.575601,2.415376,36.918767,-19.544481,2.735916,36.944660,-10.078873,2.929258,37.026743,-18.617711,2.941710,37.158858,-11.489584,2.494185,37.171860,-14.182878,2.658108,37.206499,-16.391094,3.348652,37.208256,-18.235534,3.236029,37.226580,-10.324539,3.119928,37.278368,-15.034423,3.408902,37.358116,-14.316717,3.212647,37.492115,-18.663145,4.856097,37.537468,-18.077865,3.468800,37.564121,-18.440372,4.392411,37.586895,-19.902841,3.521114,37.649417,-19.415333,4.111151,37.665816,-17.838310,3.640205,37.755421,-16.842436,4.416112,37.766030,-17.924021,5.191625,37.955991,-14.667509,4.241740,38.348337,-9.734919,2.958461,38.541640,-11.641823,3.838317,38.633697,-11.541574,3.772501,38.634687,-11.730885,3.814098,38.636733,-11.825202,3.829896,38.935890,-13.322639,4.372266,39.201678,-13.073870,4.183012,39.369859,-13.745157,4.631271,39.424563,-12.851945,3.898735,39.775844,-12.008259,3.192830,39.813173,-13.589283,4.374106,40.593197,-14.383279,5.113543,40.629836,-14.271018,5.041052,40.687526,-10.554234,2.271917,40.901870,-13.845035,4.843293,41.252721,-10.850529,2.237471,41.372166,-12.858426,3.200255,41.480718,-12.299815,2.788730,41.518884,-14.088330,5.127080,41.564804,-12.941791,3.247946,42.273231,-11.859453,1.915234,42.447008,-12.689245,3.432818,42.696305,-11.630389,1.758319,43.677520,-13.713952,5.015820,43.687211,-14.253001,5.049980,43.758787,-11.605223,2.724531,43.804676,-11.976270,5.119960,44.153508,-10.926376,3.247493,44.270785,-10.640122,3.506170,44.491976,-10.336088,2.290324,44.614078,-10.074655,2.758533,35.712220,-6.868459,-3.509541,36.050257,-7.702899,1.154918,36.510469,-8.189582,1.913022,36.515330,-7.219356,-1.737621,36.668827,-7.085605,-4.017239,36.815133,-7.219512,-1.498476,36.860552,-7.208906,-0.239195,36.884956,-8.056877,1.838463,37.199926,-7.161361,-0.214849,37.394010,-7.946365,1.530740,37.567014,-6.901131,-4.026131,37.844257,-7.181253,-3.562847,38.021997,-7.900240,1.618061,38.055132,-7.073226,0.589730,38.063239,-5.688790,-5.027337,38.124344,-7.793375,1.495345,38.137170,-9.190839,2.484610};
			return value;
		}
		private double[] getCoordinate_9_21_point_198()
		{
			double[] value = {38.272170,-8.276720,1.834757,38.280543,-7.132194,-1.889568,38.343368,-6.136497,-3.966185,38.594698,-7.513556,1.236847,38.670521,-6.923093,-2.398453,38.759745,-7.121897,-1.904916,38.810491,-5.759438,-3.913273,39.010574,-6.891546,-2.369962,39.059848,-7.290424,0.786840,39.106912,-6.934814,-2.186780,39.183938,-7.244030,0.119702,39.483772,-6.939793,-2.105528,39.577720,0.666840,4.573427,39.745853,-4.923558,-4.393971,40.189416,-5.030505,-3.698135,40.317412,0.706490,1.034598,40.487168,-0.386634,4.990873,40.617018,-1.051188,4.193643,40.753392,-6.559424,-1.744712,40.796292,-0.035937,1.685426,40.864081,-1.321165,3.964713,40.950077,-9.285162,2.173881,41.000389,-3.688700,-4.945382,41.011697,-6.355170,0.181779,41.052187,-3.807740,-4.805748,41.081840,-6.420826,-1.607466,41.096659,-6.302482,-1.720398,41.107445,-0.239511,0.624825,41.124345,-4.577501,-1.628279,41.185128,-1.154065,4.982698,41.238293,-5.018085,-1.439191,41.243671,-3.754952,-3.976286,41.391764,0.709445,-1.530577,41.434325,-5.383078,-1.462746,41.445321,-0.063837,-0.105844,41.467246,-3.987076,-1.363285,41.573246,-5.941204,-0.982035,41.585389,-0.100153,-1.142010,41.654870,-3.303138,-3.900733,41.675404,-3.414867,-1.774127,41.680545,-3.208864,-4.068944,41.715536,-1.483329,2.011073,41.731918,-0.640739,-0.495441,41.764528,-2.113602,-4.892068,41.770099,-1.971348,-4.898650,41.808878,-2.881024,-1.360389,41.812215,-0.826292,-0.864507,41.847895,-1.980096,1.804735,41.882771,-1.663030,2.158503,41.917535,-1.111673,-1.028124,41.922871,-1.279157,-0.888419,41.935534,-1.875620,-0.762564,42.006381,-5.111997,1.326281,42.013670,-2.723413,-4.110486,42.032013,-8.618832,1.701384,42.043444,-2.532680,1.643966,42.049695,-3.002230,3.416676,42.121142,-2.913505,-2.435787,42.129704,-1.528441,-4.521895,42.172927,-2.305301,-4.217696,42.205987,-0.313044,-2.186360,42.288544,-0.684603,-3.993104,42.301557,0.030840,-3.480446,42.410361,-1.640882,-2.826304,42.502811,-3.019819,2.539045,42.664610,-3.919094,2.966703,42.698055,-7.500684,1.276561,42.921445,-5.225574,1.897900,42.993097,-4.596445,3.256273,43.218390,-5.443009,2.300862,43.683848,-5.885424,3.025552,43.715342,-4.502815,4.193862,44.060993,-5.667206,3.475351,44.512355,-6.250345,3.743706,44.567357,-9.005999,2.538698,44.578081,-6.451553,3.678412,45.020390,-9.093309,3.628360,45.276375,-7.568729,4.709862,45.293648,-7.690594,4.794559,36.372605,10.055485,-4.995898,36.383204,11.124113,-3.739055,36.522042,10.723991,-3.443331,36.635917,9.758376,-4.323408,36.641952,10.152023,-2.020276,36.727500,9.153692,-2.829230,36.933565,8.970932,-1.771450,36.988959,8.890264,-4.205252,37.033749,8.856795,-3.973644,37.259059,8.696924,-5.095835,37.408373,7.596682,-1.391515,37.414440,9.811669,-0.628399,37.536553,7.397068,-2.237170,37.604356,7.932537,-3.666355,37.719650,5.410328,1.757344,37.770159,9.348933,0.087463,37.833144,9.964702,0.435057,37.925176,4.431829,2.264569,37.952813,7.761366,0.668580,38.071535,3.604701,4.201878,38.099109,7.269461,1.306652};
			return value;
		}
		private double[] getCoordinate_9_21_point_199()
		{
			double[] value = {38.146092,3.910670,3.302256,38.175219,3.748393,3.318910,38.189532,2.993518,4.154660,38.220652,6.327418,2.097894,38.253263,3.927832,2.271752,38.268782,3.108974,5.040022,38.402422,3.601532,4.730107,38.502060,6.419343,-3.114883,38.555346,6.569404,-4.059626,38.590709,9.150269,1.540765,38.725492,5.485112,-1.493151,38.851737,5.525693,-2.815818,38.910244,2.683234,2.468718,39.030475,5.317261,-2.996287,39.125849,10.532315,2.346571,39.152031,4.298361,5.046637,39.152987,2.960666,1.883306,39.204170,5.093075,-2.970056,39.220222,3.881168,-0.346520,39.347657,2.567681,2.145335,39.551858,2.372696,2.054568,39.553061,3.431465,-0.339516,39.588146,1.919065,2.575342,39.647987,5.276192,-4.602046,39.683983,4.349829,-2.192721,39.704520,1.260618,3.085793,39.776224,5.964585,4.733650,39.915591,4.897502,-4.192267,40.140901,8.425147,4.481508,40.175148,4.584421,-4.190778,40.211573,3.113718,-2.042911,40.249067,0.783535,1.122034,40.267396,0.788373,1.021737,40.377124,2.715721,-1.191953,40.409481,2.278580,-5.058326,40.432952,0.910112,1.858597,40.493725,2.266482,-0.800683,40.635385,2.150772,-1.138787,40.833874,2.398018,-4.673844,40.901038,1.344243,-4.815110,40.906776,2.921793,-2.935039,41.022575,0.952269,-0.334217,41.057740,2.682949,-4.438534,41.187296,2.702006,-3.713167,41.353578,10.857030,4.979922,41.418325,1.870934,-4.288314,35.565090,12.196728,-4.157904,35.574426,12.280527,-4.057619,35.898107,11.384922,-4.661522,35.912551,13.238273,-3.512533,36.070998,12.671097,-4.524023,36.116602,13.813510,-4.146104,36.302345,12.147603,-2.814644,36.402800,14.772556,-3.194310,36.453159,14.286253,-2.854378,36.467720,15.111797,-4.015604,36.519300,13.536374,-2.521649,36.740713,15.073944,-2.787762,36.756312,14.364627,-1.913852,36.855803,13.526586,-2.146815,36.862734,15.561543,-4.310957,36.948622,15.764673,-3.084815,37.079481,12.761357,-1.894551,37.082346,14.042711,-1.628996,37.252718,11.636810,-0.461688,37.448296,13.265219,-1.450754,37.476860,13.058720,-1.472573,37.506791,12.575110,-0.636344,37.653218,14.287824,-0.982621,37.677940,17.703884,-4.979018,37.921263,14.107755,-0.573019,38.052353,17.457075,-4.457450,38.188429,13.514376,0.098354,38.554291,13.535460,0.304032,38.650064,12.232932,1.089444,39.107359,12.736148,1.381127,39.357893,17.469770,-3.707189,39.765666,12.344789,2.237347,39.835773,16.622989,-2.655987,40.090834,12.336606,2.314164,40.351993,18.032388,-3.234915,41.035345,13.505221,0.917577,41.647996,12.206363,2.965063,41.733354,13.791462,1.098343,42.085593,12.087717,3.447864,42.641419,18.733547,-0.884133,43.944414,13.163429,4.967474,44.003032,20.319912,0.783251,44.132053,16.756962,2.008364,44.294706,13.637887,5.140067,44.435657,20.675665,1.397052,44.445799,20.487643,1.430350,44.500406,15.260893,3.688516,45.239483,17.382896,3.912898,39.148891,27.033022,-4.160797,39.641881,26.751261,-3.522088,39.783582,26.941844,-3.618210,40.105415,25.873320,-3.021418,40.259949,26.281310,-2.826320,40.807683,23.436140,-3.289098};
			return value;
		}
		private double[] getCoordinate_9_21_point_200()
		{
			double[] value = {40.930761,25.910149,-2.217335,41.335179,26.105338,-1.896730,41.375917,24.508068,-2.200924,41.813060,23.624083,-2.019246,42.080963,26.669997,-2.111272,42.228411,27.792747,-4.163251,42.239752,25.094553,-1.146074,42.248358,21.834685,-1.776639,42.590213,26.086181,-0.955413,43.007268,26.661924,-1.040375,43.993438,27.601399,-1.262590,44.094667,27.415647,-0.260598,44.241765,30.861748,-4.671506,44.269623,31.547830,-3.981887,44.583003,26.124831,1.265075,44.601628,27.960584,0.499862,44.764456,32.041846,-2.854021,45.167730,28.821503,0.984035,45.550072,31.063093,-3.376520,43.644549,32.085968,-4.118921,44.133461,33.300181,-3.770959,44.411119,33.028668,-3.406101,44.519221,33.233874,-3.391258,44.897691,32.920556,-1.801789,44.947241,32.232208,-2.413833,45.006313,33.834421,-3.150428,45.159503,35.249474,-4.658420,45.409894,34.619386,-3.166838,45.580965,34.595485,-1.202309,42.017050,84.037674,-3.664719,44.062592,82.238419,-0.413051,45.455813,80.952414,3.409958,45.546453,80.619227,2.347480,35.181736,92.485297,1.297244,35.455874,93.418379,-0.920150,35.525912,94.406512,3.595865,35.539110,93.467677,2.992978,35.939867,92.531061,-2.213476,36.042692,92.245380,0.527450,36.117148,92.780898,-1.569216,36.347722,91.299903,0.790355,36.351583,91.333647,-4.070103,36.387715,90.973669,-3.155768,36.412841,91.301574,-4.164922,36.573589,91.215244,-4.599849,36.732049,93.434991,3.486692,37.004027,90.941768,0.138501,37.194427,90.052642,-4.503107,37.459973,90.958463,-2.731443,37.474631,90.735052,-0.324993,37.477517,89.525616,-4.195545,37.480298,92.117280,2.709474,37.650027,90.739252,1.731600,37.677220,89.359029,-4.061087,37.799199,89.907371,-3.465127,37.827465,89.482433,0.295736,37.942585,91.846039,2.773262,37.989361,89.314225,-0.176052,38.144459,89.526709,0.745246,38.293993,88.889484,-0.339011,38.577626,89.866203,-2.893931,38.686955,89.634928,-1.618958,38.689662,90.414605,2.203956,38.698633,90.576431,2.468005,38.899291,90.768444,3.676408,38.922315,88.480049,0.026482,38.973371,90.673746,3.462989,38.983447,90.737423,3.871929,38.990670,90.026351,2.059506,39.045483,88.901821,-2.592315,39.054694,90.959047,4.215957,39.054829,90.423946,2.859794,39.099971,88.533621,-2.171213,39.243476,89.486001,2.038731,39.300023,88.182034,-4.226598,39.303524,88.091843,-4.518537,39.472034,90.709220,4.140907,39.477475,87.309098,-1.632962,39.481761,87.246982,-2.578876,39.629721,88.845597,1.265509,39.751673,88.823701,1.260455,39.977440,89.687026,5.167129,40.028444,90.051006,4.854742,40.098106,85.904044,-4.439825,40.182870,89.504376,4.565410,40.403149,88.372406,1.299088,40.749465,85.647293,-3.619368,40.776519,85.322476,-4.214832,41.078513,87.572817,2.938910,41.152634,87.535946,3.345857,41.386850,87.488886,4.116696,41.494040,84.759046,-4.005915,41.495726,87.274245,3.926014,42.095555,86.426548,4.246882,42.391931,86.100255,5.139854,35.788203,95.059576,4.462928,35.230903,-74.832518,11.636146,35.303009,-75.475660,12.330477,36.719138,-73.728113,12.274581,36.767548,-72.647314,12.781236};
			return value;
		}
		private double[] getCoordinate_9_21_point_201()
		{
			double[] value = {36.772658,-75.108471,13.166966,36.970554,-73.788582,12.426480,37.694109,-74.913768,13.831722,38.385220,-75.201402,15.307445,39.265062,-73.266674,14.054150,39.770212,-73.661140,14.671999,40.148867,-73.800699,15.164996,40.691517,-72.772903,15.087457,40.892119,-72.457347,15.237540,35.479831,-63.031306,11.313175,35.921659,-67.613958,9.595068,36.051169,-71.917584,11.538840,36.280167,-64.025878,10.709859,36.405996,-63.186951,11.477691,36.650758,-62.151841,12.864129,37.888984,-71.311994,14.044299,38.089468,-71.932687,14.005765,38.143830,-68.848497,12.621317,38.354707,-62.276630,13.438240,39.519967,-65.627806,13.818039,39.931555,-66.992815,14.671191,40.031546,-66.585023,14.667981,36.672630,-61.266224,14.529437,37.632816,-60.881447,14.835304,35.382513,-41.901449,13.294556,35.541993,-41.622675,13.138552,35.615988,-43.950367,15.224397,36.215344,-42.916060,14.770145,36.309113,-42.670226,14.151791,36.447599,-42.507764,14.164902,36.669931,-42.013259,14.602856,35.180155,-33.204660,6.393603,35.213378,-37.493642,10.879368,35.248492,-37.403172,10.846982,35.290160,-36.036817,7.993263,35.329854,-36.071565,8.197794,35.345303,-36.576902,10.223004,35.407888,-35.687995,8.447843,35.443008,-31.397914,5.908825,35.451703,-36.458131,9.415593,35.459677,-37.424607,11.019436,35.521873,-34.594040,8.043607,35.539343,-31.425132,6.136385,35.550151,-31.175619,6.555533,35.566099,-37.325971,11.012465,35.575238,-36.845069,10.760617,35.576881,-39.102205,11.934416,35.593497,-33.846352,8.532448,35.629478,-33.963628,8.009274,35.654384,-34.200115,8.208145,35.752632,-31.016693,7.589064,35.812984,-34.946074,9.609352,36.289796,-33.007030,8.767928,36.429036,-37.579113,11.272154,36.493555,-39.070358,11.857636,36.532550,-40.277362,12.443987,36.864881,-34.074361,9.373452,36.938035,-38.305931,11.672410,37.034268,-38.424238,11.787015,37.147427,-38.335572,11.819990,37.410248,-38.957023,12.379348,37.684310,-39.004742,12.476952,37.857505,-34.347029,9.387281,38.023614,-35.682948,10.236913,38.169206,-40.075777,13.994060,38.184549,-34.708100,9.675434,38.205387,-32.227853,8.463323,38.289837,-40.049572,15.211362,38.301331,-39.273375,13.149158,38.375379,-34.255547,9.491029,38.720720,-34.868441,10.095314,38.730679,-37.655461,14.888817,38.775711,-34.127985,9.724092,38.801682,-32.212014,9.403342,38.824928,-38.465128,13.186957,38.839171,-33.810611,9.638227,38.840590,-32.881796,9.324653,38.878829,-33.936449,9.755247,38.917873,-31.716105,9.471336,38.948567,-35.432925,10.753813,39.003719,-35.296768,10.806243,39.030295,-36.121259,11.586230,39.075442,-36.882576,14.792181,39.078080,-36.348222,12.709813,39.153304,-31.777581,9.648628,39.159314,-34.926630,10.978558,39.205904,-35.850138,11.665668,39.270630,-34.996918,12.246885,39.417632,-33.939704,11.178517,39.441179,-32.696301,10.349119,39.491311,-35.524134,13.696878,39.631673,-36.048342,15.520691,39.724090,-34.812987,14.039110,39.977155,-30.836037,12.392385,39.992316,-34.331038,14.603256,40.095367,-30.754478,11.055801,40.194783,-32.336362,11.980281,40.229139,-31.904146,13.443086,41.636065,-32.761117,15.059059,41.680190,-31.997160,15.416140};
			return value;
		}
		private double[] getCoordinate_9_21_point_202()
		{
			double[] value = {41.685284,-30.995455,13.746532,41.759194,-31.626117,15.203905,35.390774,-28.954508,5.394055,35.905875,-29.794314,6.761419,35.957928,-29.671629,5.872650,36.043008,-30.430318,7.592616,36.189554,-30.523380,7.725585,36.282518,-30.554062,7.764443,36.482935,-28.419970,6.980983,36.744075,-27.542237,6.737160,36.830491,-28.024112,7.309276,36.841843,-25.390462,6.695749,37.001202,-26.788947,6.922167,37.211659,-26.646278,7.441153,37.398919,-23.275077,7.234730,37.468635,-22.310761,6.796006,37.695368,-28.496007,7.752570,37.755324,-21.338144,7.143809,37.755446,-20.835024,5.650141,37.756712,-21.243873,7.123712,37.779561,-29.607164,7.702185,37.799960,-30.137438,7.673242,37.814275,-25.602652,7.871007,37.922874,-21.315435,7.235316,37.924456,-21.409731,7.251496,38.071748,-28.673869,8.212908,38.395233,-28.315094,8.377253,38.406657,-26.280984,8.327072,38.466451,-28.046222,8.403131,38.641086,-25.640975,8.988592,38.703854,-26.719288,8.607204,38.820341,-26.072305,9.765147,38.830260,-27.941443,8.701827,39.334772,-24.232191,9.078569,39.384170,-28.784623,9.420022,39.581833,-28.636194,11.148950,39.653487,-22.222429,8.300204,39.698217,-28.922668,10.520625,39.804523,-29.722872,11.723691,39.864638,-28.437204,11.830058,40.049460,-30.489419,11.464280,40.408807,-27.609354,11.539785,40.670935,-25.533795,10.586540,40.783642,-20.751835,8.442451,40.980474,-22.234293,9.090538,41.135709,-23.366831,9.654876,41.257888,-28.228204,12.165537,41.309369,-25.235415,10.682505,41.352388,-23.888717,10.078564,41.480776,-23.932908,10.249448,41.489590,-22.144604,10.392485,41.512244,-29.718611,12.936101,41.514207,-23.144404,10.111603,41.640282,-24.594712,10.730871,41.721278,-24.519478,11.380136,41.741298,-22.139985,11.199342,41.750580,-27.782940,12.405132,41.875534,-23.538569,11.601212,42.165054,-26.159000,12.187514,42.243419,-27.106115,12.268505,42.272937,-22.829897,11.579008,42.314286,-26.900744,12.288823,42.853595,-29.924736,14.503820,42.890202,-20.798614,11.590818,42.995313,-20.412552,12.748828,43.294319,-23.746728,12.451344,43.326156,-22.051417,13.579330,43.416221,-20.650806,14.378650,43.536196,-27.460856,14.796060,43.641799,-23.296540,14.033526,43.705996,-28.900590,15.502815,43.714915,-23.432645,14.146852,43.947148,-23.537295,15.536248,44.061786,-24.956734,14.922847,44.078047,-25.396444,15.411685,37.950986,-19.525219,6.535493,38.544479,-15.855723,5.495879,38.826997,-16.802096,6.064473,40.261565,-17.889710,7.114026,41.066178,-18.627564,8.265352,41.383644,-17.055901,6.811956,41.418053,-16.907099,6.552105,41.621876,-18.090900,9.150995,41.739905,-15.281876,5.237617,41.854834,-18.881017,10.976956,41.905839,-15.782592,5.338492,41.914930,-16.320171,5.835792,42.435774,-16.218535,6.068569,42.572846,-18.785136,11.367601,42.758741,-16.446199,15.388035,42.776308,-16.711881,8.168813,42.846117,-19.939459,11.731725,42.975034,-16.018489,6.804151,43.040440,-16.607488,7.824841,43.069176,-17.223892,11.741835,43.179255,-18.868804,13.767588,43.192327,-16.298682,7.381515,43.274687,-15.642762,6.692683,43.457789,-20.029081,14.170398,43.473520,-15.426757,15.409096};
			return value;
		}
		private double[] getCoordinate_9_21_point_203()
		{
			double[] value = {43.476925,-16.876960,14.650180,43.581911,-17.918189,13.606210,43.665498,-17.116363,12.914881,43.670777,-15.248244,11.701825,43.685044,-15.419341,12.151734,43.780174,-15.041163,5.910383,43.784686,-16.728378,12.785833,43.848915,-10.503629,5.246722,44.018605,-14.962650,10.131631,44.039740,-9.910352,5.531932,44.203845,-13.031011,15.431253,44.251491,-14.053478,10.792623,44.354675,-14.103664,7.771253,44.382640,-14.678546,6.654448,44.495820,-12.450136,12.796553,44.559074,-11.182871,15.178805,44.676098,-14.363555,12.811411,44.732566,-10.660269,14.577663,44.734975,-13.144837,8.430662,44.765631,-13.684249,6.396815,44.771281,-14.338226,12.879941,44.880320,-11.537793,14.501917,44.935536,-12.813391,13.142445,44.936104,-13.179506,14.600531,44.958756,-12.912742,10.531168,44.984056,-12.598064,8.557765,44.988554,-13.848246,9.690414,45.008753,-12.968291,10.450584,45.017989,-12.014320,14.229057,45.019221,-12.354189,13.427219,45.026430,-14.238687,13.291761,45.043974,-13.712230,13.868039,45.098416,-11.865082,6.049672,45.098521,-13.801718,13.485383,45.189980,-12.860060,9.649094,45.298996,-12.143980,9.699642,45.339256,-10.510755,9.817765,45.398517,-11.233166,9.676954,45.403094,-10.487809,10.781074,45.462301,-12.270398,8.089801,45.548159,-12.370041,7.734603,45.562291,-11.975828,8.241518,39.750555,0.634358,5.729994,39.905416,-1.242767,14.951530,40.042053,0.055452,5.521662,40.071662,0.613170,10.631618,40.115298,-0.090853,13.551437,40.164912,-1.406535,14.565134,40.293569,0.079329,12.964319,40.422282,-0.639039,11.344746,40.483693,-0.288352,7.229143,40.518062,0.137856,12.235469,40.622661,-0.269836,10.383154,40.633346,-0.753608,11.715427,40.705410,-1.436071,11.144203,40.742328,-3.746701,15.535884,40.749232,-0.746202,12.090240,40.839625,-1.177155,13.030111,40.936692,-1.576885,13.193756,41.061279,-4.692291,15.438197,41.068353,-2.615951,12.789176,41.074904,-4.784033,15.507595,41.143267,-2.670592,12.886789,41.288551,-2.229191,13.570065,41.309589,-2.342293,13.746761,41.328229,-4.724257,15.268324,41.425437,-1.376211,5.369265,41.432067,-1.195419,8.343651,41.435711,-0.156177,8.587165,41.502401,-4.714269,15.265315,41.522973,-3.638762,12.153454,41.604859,-4.195286,12.410997,41.609087,-2.088717,7.330701,41.668568,-1.803054,8.102157,41.668588,-2.176540,7.373780,41.690487,-2.146805,7.167974,41.710952,-4.070723,12.702780,41.737319,-3.907090,12.866215,41.739736,-3.313309,14.029239,41.905903,-0.612479,9.334402,41.981754,-1.114668,10.136492,42.011203,-4.939932,12.639556,42.055611,-2.829748,7.738904,42.113123,-4.746092,12.058094,42.129651,-3.948712,13.835464,42.211658,-5.376787,12.797866,42.222747,-5.278391,12.335236,42.224485,-1.511336,9.333555,42.273326,-2.498081,7.082852,42.382844,-5.934716,13.080149,42.636788,-5.015243,14.055500,42.723993,-3.871994,7.967015,42.751354,-5.398633,14.223744,42.755481,-6.578351,13.450615,42.761296,-3.948983,8.007620,42.856117,-2.981610,9.169955,42.889373,-2.898896,10.475109,42.923372,-7.269914,12.591052,42.977018,-3.165939,10.580338,43.030453,-3.181165,6.211852};
			return value;
		}
		private double[] getCoordinate_9_21_point_204()
		{
			double[] value = {43.069792,-4.499819,7.848113,43.111242,-3.868737,7.523311,43.143409,-5.350691,11.785286,43.143837,-7.075648,12.235806,43.267988,-6.231546,11.988770,43.319084,-4.089500,10.631147,43.428729,-5.259868,8.214553,43.476585,-6.967610,14.672435,43.503383,-4.171540,10.083065,43.503752,-9.242528,12.421353,43.601908,-8.079077,13.648039,43.651286,-9.337483,12.999588,43.694792,-6.130826,11.596167,43.705764,-5.457656,10.568167,43.817874,-4.604613,9.683037,44.010168,-5.025418,9.382512,44.029793,-8.691092,14.895966,44.037281,-6.474982,11.085172,44.041150,-6.928771,11.624573,44.133827,-5.251379,9.773565,44.522406,-6.648386,6.853209,44.538950,-7.838834,11.093022,44.546207,-8.424390,6.391384,44.679179,-5.734303,5.345673,44.681324,-8.963036,11.283721,44.904418,-8.082834,5.825494,44.909293,-7.325301,6.306791,45.304122,-7.850937,9.186260,45.477310,-8.758100,9.245459,45.516009,-9.111837,8.049574,45.524699,-9.373030,7.806235,38.794934,3.086223,5.657560,39.141595,2.108868,5.484622,39.201130,1.278845,6.203100,39.503755,3.681115,14.048612,39.609561,2.693747,6.619952,39.724413,2.319413,9.317336,39.756536,3.276247,12.435324,39.765518,4.966625,5.546517,39.842103,4.499451,13.134518,39.849023,2.863554,7.823307,39.940120,2.984260,9.458110,40.024407,5.738735,6.068699,40.039410,6.193088,5.618389,40.078125,1.503907,10.320531,40.099594,1.489236,12.394508,40.163821,1.817963,10.431991,40.175196,1.895781,11.209274,40.196283,1.055677,9.841252,40.211167,1.537704,11.019555,40.306620,6.836884,6.682564,40.492987,7.879720,6.008343,40.537145,6.984094,9.321277,40.556002,6.924499,9.741105,40.557283,7.926386,6.485001,40.614417,7.510880,7.833021,40.671245,9.441911,5.457827,40.693742,7.141577,10.755738,40.708930,9.296660,5.730777,40.826138,9.896148,5.492372,40.885455,8.791274,7.114683,40.968744,6.759469,12.653883,41.424225,7.542214,14.758006,41.522070,9.865500,6.892377,42.046726,8.596773,12.722247,42.648809,9.894752,10.574390,42.746607,10.220564,9.642715,42.894959,11.147898,6.635811,43.133571,10.722028,10.431985,43.152848,10.929267,8.636609,42.638652,11.506615,5.243381,43.580394,12.017155,11.852781,44.212233,14.357866,12.306361,44.717655,13.954641,6.104842,44.898664,14.699777,9.766094,45.022791,15.947477,10.858104,45.446516,18.719068,12.322092,44.915080,83.069976,14.044901,45.272124,82.150826,8.444885,45.620543,81.846455,12.452484,35.318745,94.675876,14.210487,36.001559,94.762850,9.565338,36.169603,93.889778,12.975298,36.351371,93.218324,10.374348,36.418152,93.757407,11.337823,36.510177,93.091956,10.042505,36.569717,94.707345,14.774536,36.609429,94.055834,5.787834,36.657957,93.588405,11.351971,36.968931,93.285578,9.242047,37.001498,93.744841,6.777940,37.169513,93.461607,12.855484,37.368900,93.810896,8.548205,37.371465,94.013777,14.999887,37.530836,92.903138,5.610834,37.536948,93.098445,6.191472,37.630718,92.493957,8.728285,37.819230,92.551017,8.445274,37.832138,93.045497,8.362574,37.839410,93.632687,13.276680};
			return value;
		}
		private double[] getCoordinate_9_21_point_205()
		{
			double[] value = {37.850117,93.646015,14.902580,37.875339,91.940710,9.921737,37.956594,93.404570,7.041691,38.126849,91.769016,9.837143,38.201039,91.663071,9.734951,38.410890,93.286203,12.846572,38.616013,92.712522,6.621612,38.689746,92.973915,12.857951,38.891701,91.127966,9.302839,38.918886,92.246529,6.128939,39.016318,90.578102,8.131010,39.047331,90.732848,7.322402,39.143712,91.726148,5.451188,39.177525,92.000542,11.401299,39.279859,91.225328,9.946979,39.653360,91.862372,12.026187,39.857223,89.550067,6.138588,40.189059,91.308596,14.690962,40.232351,91.283549,13.007670,40.296966,89.118673,6.246917,40.447194,88.795815,5.503724,40.463834,89.209701,6.691214,40.504525,89.113548,6.511609,40.556985,90.577926,12.203336,40.840477,90.351171,13.350098,40.860546,90.317362,13.479882,41.075925,88.398914,6.213753,41.418401,88.971990,12.722899,41.509552,88.165548,13.171177,41.745925,87.840499,9.836361,41.949369,87.640609,12.640923,42.434467,86.829080,14.241872,42.788444,86.361079,12.221264,43.701368,84.862323,10.502645,43.902471,84.796256,15.363826,44.125212,84.535639,14.840795,35.229462,95.963274,5.569799,35.309354,95.305693,14.854547,35.340331,95.681258,8.779458,35.604245,95.511792,8.671214,36.011186,95.136959,8.982691,36.456516,94.792514,14.959928,36.445126,-76.373865,19.789286,36.626306,-76.338836,19.852018,36.676252,-76.320562,24.171346,37.659887,-76.025539,18.342837,37.982960,-76.036655,21.145987,38.642260,-75.796434,19.731753,38.982859,-75.329959,16.737324,39.673726,-75.398302,24.027072,39.952389,-75.503045,21.118296,40.262424,-75.195954,24.781735,41.827384,-72.794715,15.968226,42.065258,-74.640657,23.875934,42.145255,-73.314537,16.788000,42.169763,-72.922120,16.327113,42.782494,-73.282679,17.567555,42.804912,-74.418971,24.197832,42.904189,-74.256547,20.670969,43.524926,-73.987760,21.414927,43.561242,-73.700818,19.657201,44.756580,-73.561434,23.393022,44.920419,-72.727352,19.871675,45.516467,-72.766845,21.106676,39.647111,-69.368592,16.012580,40.780869,-68.650221,17.362127,40.934746,-64.627339,15.741738,41.695988,-63.201527,16.873868,42.278872,-67.325919,19.178291,42.378604,-67.950680,19.020218,42.629920,-66.998042,19.678247,42.700013,-63.572808,18.690076,43.515491,-66.263352,20.903282,43.677571,-63.336313,20.780788,43.826409,-69.982614,17.942286,44.143059,-63.915093,22.248389,44.450554,-68.843267,18.994267,44.565072,-71.444376,17.957151,45.181854,-65.118737,22.890142,45.219547,-63.330297,24.076536,45.386179,-70.003671,18.618570,35.681472,-58.030870,22.809344,36.394107,-58.707089,22.454406,36.418126,-53.230997,25.927572,36.539807,-53.435579,25.917685,36.557183,-60.922180,16.489921,36.577294,-59.727296,19.205995,36.785019,-60.698984,16.635325,36.794017,-58.239632,23.081792,37.002091,-58.351638,22.583191,37.305752,-58.932563,20.254087,37.707828,-56.112006,25.373677,38.303052,-58.808547,18.583635,38.868294,-57.812545,19.974038,39.451130,-56.406484,22.777601,39.526802,-56.711999,21.078244,40.441886,-59.679322,16.639963,40.571370,-58.196655,17.987158,40.577326,-58.712355,17.500113,40.699147,-55.817872,21.261215};
			return value;
		}
		private double[] getCoordinate_9_21_point_206()
		{
			double[] value = {40.899697,-57.425621,18.914944,41.185472,-56.231429,20.386429,41.342132,-54.240567,23.466494,41.548874,-55.620813,21.170853,42.135220,-53.319107,24.213053,42.318326,-55.914203,20.944735,42.614908,-55.295191,21.651152,42.836109,-61.639066,18.757387,43.051310,-54.918235,22.245025,43.667901,-51.883133,25.597688,43.737056,-60.707081,20.440233,43.987125,-53.138675,24.329465,44.549097,-54.973532,23.550057,44.610591,-52.478275,25.460436,44.834224,-55.530885,23.654507,45.564452,-59.815762,23.993983,35.218375,-42.507224,21.116868,35.451102,-43.609224,22.879354,35.614190,-42.169924,20.879135,35.661671,-42.140041,19.655512,35.693858,-42.070930,20.929149,35.821398,-43.372313,24.224151,35.971787,-41.748997,21.105619,35.992148,-43.359988,23.251211,36.269989,-43.393457,17.145490,36.675873,-41.090110,18.178196,36.680346,-41.296803,17.970429,36.754953,-41.331952,17.862674,37.146279,-42.332400,16.535406,37.184790,-42.053014,16.939040,37.388128,-41.738256,16.735979,37.456295,-41.768832,25.917100,37.801182,-41.107219,16.177571,37.907571,-41.384340,22.688683,37.112094,-40.386974,20.721899,37.226117,-40.393744,17.831447,37.599882,-39.992993,16.863843,37.882713,-39.789866,19.853553,38.072020,-40.591665,15.715651,38.160437,-39.577930,19.198428,38.191642,-39.345771,21.520624,38.196630,-39.051648,17.332381,38.266011,-38.796999,16.326575,38.351931,-40.617421,23.488261,38.373193,-38.978237,18.092771,38.475358,-40.406569,24.024800,38.475874,-40.574352,22.585944,38.506882,-40.450338,25.124764,38.511575,-40.349240,23.470565,38.566932,-40.387710,23.029383,38.690237,-40.224469,25.133154,38.879787,-37.575746,15.617785,38.882799,-38.753695,18.761991,38.931762,-37.827258,17.645183,38.953761,-37.856000,25.703132,38.973143,-40.032759,24.760349,38.992745,-39.478538,23.515272,39.048626,-38.241308,18.093924,39.491216,-32.724550,25.470689,39.503909,-37.872242,18.248947,39.608069,-38.753344,23.878663,39.688449,-36.120750,15.720650,39.728589,-38.427713,23.655432,39.736583,-38.071720,24.442449,39.823679,-38.161926,24.161470,39.852634,-38.103131,24.038707,39.929241,-36.655126,24.796060,39.976289,-36.151082,20.199238,40.041735,-35.885408,21.099256,40.042828,-35.071887,24.717381,40.047256,-30.903935,25.364317,40.059168,-37.256017,23.234028,40.104048,-36.084862,22.054941,40.117542,-36.306940,22.199033,40.150973,-37.018237,23.346280,40.182461,-35.563329,24.671106,40.462776,-34.955757,21.152625,40.475312,-36.254446,19.233512,40.484412,-34.967798,20.934376,40.537956,-36.662885,18.297637,40.565089,-36.204838,19.148549,40.710493,-35.096812,15.709574,40.768498,-34.977810,22.506372,40.799046,-34.931772,15.636553,40.866187,-32.087176,24.232963,40.914402,-34.469897,23.522511,41.024563,-33.969504,21.978441,41.054507,-34.536131,15.972409,41.308035,-33.689521,22.822257,41.366553,-33.225804,23.025226,41.380521,-32.715952,23.205548,41.446040,-31.600109,23.652339,41.515310,-32.482177,21.161735,41.680125,-35.094863,17.919134,41.685727,-35.043423,17.798415,41.738989,-32.258862,15.916052,41.792701,-31.705872,21.205189,41.994869,-31.089008,22.755322,42.001396,-31.745802,22.174105,42.329910,-32.792606,16.582466};
			return value;
		}
		private double[] getCoordinate_9_21_point_207()
		{
			double[] value = {42.524492,-31.560340,19.650670,42.565922,-31.466031,18.713710,42.587873,-31.566187,19.347663,42.726146,-31.702015,17.961537,42.963799,-30.691243,18.611956,42.989142,-32.169104,17.201263,43.171131,-31.584506,17.061378,40.406681,-29.168410,25.328116,40.486387,-28.362556,25.443072,40.544142,-28.114661,25.842797,40.753133,-27.105570,25.305810,41.463046,-23.933742,25.191096,41.790898,-25.910422,24.244752,41.840637,-20.950436,22.940150,42.306697,-30.193011,21.156580,42.345507,-28.934692,23.423762,42.422316,-30.539226,21.965916,42.473874,-20.267289,16.725194,42.496983,-20.691687,16.708791,42.524779,-29.173571,20.898961,42.554151,-28.349801,23.232412,42.612262,-22.198919,16.853894,42.769977,-23.578746,23.003769,42.785134,-29.246927,22.394400,42.795178,-20.795846,19.986837,42.892458,-25.570449,23.051362,42.903530,-22.712608,19.645256,42.929807,-25.931389,20.403809,42.978421,-25.179417,20.255836,43.057096,-25.890435,22.866864,43.070907,-22.142877,21.332595,43.107711,-25.309639,22.764428,43.159469,-22.654803,20.391288,43.168214,-30.301073,18.559050,43.192101,-30.129825,18.803693,43.249239,-25.025258,22.285703,43.262601,-21.353984,18.207357,43.270949,-24.152894,21.953922,43.275157,-25.806815,19.210173,43.386320,-25.659187,22.160596,43.392688,-24.349926,20.990834,43.399257,-23.220358,18.867002,43.427880,-22.705610,18.252919,43.435137,-23.076339,18.315758,43.438545,-28.763650,16.817941,43.448365,-25.985624,21.759264,43.460749,-29.408414,18.529942,43.523188,-29.019273,18.495280,44.083434,-24.153179,15.637436,40.231153,-10.366130,20.008872,40.316284,-11.332762,20.686281,40.604801,-13.142228,20.625719,40.820277,-10.063978,24.946028,40.821021,-10.791383,19.645170,40.821674,-9.876842,19.349651,40.841980,-10.060690,19.393508,40.866664,-10.690059,23.269272,40.889491,-10.707178,19.550468,40.950260,-11.006178,22.635413,40.952977,-9.990729,25.257328,41.045361,-10.519572,24.706132,41.133935,-11.540728,24.068925,41.159433,-11.679304,24.063344,41.160365,-11.637839,19.634665,41.184247,-11.530957,22.821354,41.235505,-17.015190,18.979387,41.261446,-17.062717,18.669015,41.264192,-12.798760,22.766946,41.315646,-17.037263,18.242561,41.362744,-16.988310,18.007599,41.421817,-12.080913,25.752919,41.496120,-19.357989,22.923173,41.505920,-18.682690,22.858288,41.547982,-18.612440,22.913694,41.552528,-17.063645,17.191215,41.565537,-11.410068,18.826350,41.596184,-12.569425,23.434284,41.640562,-17.218267,17.001241,41.641325,-14.711318,22.872178,41.648161,-14.804296,22.578279,41.712062,-17.736628,18.964693,41.766835,-16.183365,17.066040,41.769734,-18.221137,19.717707,41.868510,-20.092984,24.705839,41.980187,-16.354175,23.869766,42.000203,-14.380530,25.002646,42.027867,-18.621758,23.662837,42.092863,-15.694834,25.708994,42.113546,-14.459445,24.620900,42.216409,-15.740980,25.518130,42.265299,-19.043847,18.777808,42.279850,-15.859810,16.229398,42.317628,-19.235267,16.113376,42.363076,-19.417153,16.677764,42.451201,-17.500868,25.908780,42.488026,-19.819487,19.935626,42.509682,-17.009753,15.696748,42.785936,-12.433932,17.148936,43.475391,-13.336186,16.398096,43.520472,-11.902267,16.219972};
			return value;
		}
		private double[] getCoordinate_9_21_point_208()
		{
			double[] value = {43.656652,-13.899875,16.075309,38.670720,-2.354887,18.922891,38.711656,-1.755198,18.927358,38.759352,-1.556726,18.298307,38.790246,-1.617180,19.675397,38.794775,-1.586431,18.212711,38.798484,-1.704359,18.237941,38.804504,-2.063121,19.818368,38.931150,-4.141351,18.924477,38.934321,0.326725,16.905050,38.969678,-0.204155,21.602820,38.988075,-0.358905,17.410995,38.998448,0.658087,18.017698,39.097803,-4.992809,20.170104,39.146351,-0.191794,16.588357,39.152143,-3.764626,22.270586,39.172100,-1.261248,17.030178,39.172886,-2.935278,18.365879,39.211478,-0.131235,15.803431,39.238160,-2.526356,21.877168,39.241772,-2.590059,22.088366,39.270299,-6.244670,20.081829,39.349989,-4.888641,22.012677,39.369726,-2.980595,22.623507,39.573165,-4.768533,23.041937,39.595016,-2.549934,16.858952,39.659303,-5.849337,21.936307,39.808226,-7.623045,19.552376,39.823954,-6.999223,19.222650,39.850452,-7.300298,21.908622,39.873388,-6.577422,18.601771,39.884104,-6.994884,22.771832,39.892160,-7.028331,18.816128,39.940600,-5.866836,18.167715,40.017775,-3.854038,17.032735,40.027514,-8.539380,19.529276,40.127921,-9.555658,21.685336,40.198843,-6.561295,23.790409,40.288565,-7.732847,23.168854,40.399768,-7.199955,18.482553,40.425904,-4.279560,23.882184,40.448219,-8.453613,24.470419,40.732109,-7.562801,17.739649,40.734678,-9.233254,23.118186,40.776930,-9.619846,24.825948,40.779067,-6.535481,17.003904,40.784682,-8.224034,18.122305,40.798919,-8.809310,24.756070,40.914114,-5.600339,25.420921,40.929555,-3.658226,24.305596,40.945008,-8.664017,18.082184,40.979032,-9.172382,25.187135,40.985388,-9.695840,23.943436,41.023744,-3.644535,24.471446,41.118958,-6.561434,16.761127,41.403143,0.167040,23.803733,41.433972,-6.983215,16.586845,41.442622,-7.805003,25.892811,41.568846,-0.036275,24.096178,41.740096,-2.497314,24.884370,41.808850,-1.942796,25.982062,41.863405,0.108899,25.209003,41.891977,-6.714893,15.810306,41.902505,-1.208726,25.318045,43.183900,-8.458113,15.757858,38.931407,0.857906,20.104942,39.026853,1.093591,15.954854,39.256532,1.938875,17.965000,39.277291,2.669405,19.939714,39.325838,3.558526,21.156291,39.455956,3.408367,17.566141,39.523447,3.264583,17.097932,39.579725,3.747443,17.032999,39.658273,4.411632,19.424435,39.966949,5.056783,20.487216,40.263265,3.884562,22.443064,40.290870,7.644904,22.275514,40.302308,7.220352,22.631640,40.302473,10.516593,20.392118,40.312202,5.667352,21.948974,40.368805,10.398833,20.020417,40.370338,6.091705,20.903524,40.384439,10.098211,20.014496,40.386807,5.645463,17.321284,40.400436,6.453710,20.782421,40.450760,5.489377,22.834795,40.518121,11.176404,23.406498,40.518147,7.478643,20.237088,40.526754,6.792439,19.650154,40.604688,10.159603,25.898640,40.637510,7.462941,23.658972,40.663768,7.250421,23.716536,40.679960,6.684383,18.053961,40.772872,5.071341,23.925179,41.211529,4.024596,24.672602,41.255989,9.716703,17.198361,41.596776,2.339600,25.577366,41.666048,1.641317,25.168907,41.698488,1.538654,25.376680,41.878997,0.736526,25.566812};
			return value;
		}
		private double[] getCoordinate_9_21_point_209()
		{
			double[] value = {40.367271,15.497041,24.116340,40.369386,12.122255,21.978587,40.371159,14.875205,25.919224,40.407550,14.676351,24.978562,40.411003,14.434290,25.157291,40.420007,15.037575,23.423677,40.436759,14.274572,25.906160,40.437346,13.563867,24.929736,40.461042,11.898795,20.027363,40.470672,13.330765,21.074150,40.477507,12.938916,24.218383,40.478354,12.644566,23.608330,40.522793,12.482336,24.660435,40.602064,18.717838,24.502214,40.640969,11.466623,24.523149,41.467288,16.532654,20.205152,41.562966,19.850314,22.982707,41.700684,20.692129,23.574279,41.701022,15.282579,18.685306,42.481378,20.888264,22.231316,42.684253,17.649530,18.987991,43.313808,18.573713,18.872021,43.372389,20.911025,20.953360,42.915759,23.469663,24.035683,43.803198,24.737933,23.723225,43.812629,22.057712,21.322361,44.484028,26.520123,23.934971,44.704273,41.982261,25.000577,44.866394,38.024857,25.412885,45.185785,32.680652,24.444496,45.618116,35.546088,24.089161,43.927081,43.651910,25.528531,44.244030,45.066196,24.625279,44.300539,44.102939,24.731453,44.477377,46.240484,23.917489,44.509116,46.599115,24.511859,44.510370,46.391590,23.763756,44.685485,47.653506,23.333468,44.786054,47.615765,23.833717,44.843900,48.467978,22.746407,44.847208,47.131666,24.489255,44.942647,48.888963,22.501461,44.943632,48.197684,22.520047,44.999886,44.944447,23.259624,45.010480,47.970856,23.991754,45.076296,48.377525,22.134687,45.097009,51.416948,21.660039,45.112218,47.479791,24.637511,45.130804,47.570269,24.606360,45.180090,48.602460,23.767140,45.297063,46.543603,22.000646,45.304195,45.304521,22.494202,45.438262,49.279309,24.315715,45.461380,49.012893,20.976290,45.469593,52.504496,20.349279,45.289431,53.468675,20.576281,45.305362,55.559235,20.890941,45.338559,55.810767,20.925691,45.352286,55.661042,20.562378,45.494883,56.888305,20.651342,45.506180,56.795180,20.981456,45.555543,57.151984,21.160640,45.266148,73.543903,23.988645,45.539918,72.837459,23.411129,43.392732,82.853932,25.386163,43.687947,81.269148,25.700653,43.717422,81.696596,25.475904,43.823541,83.859409,23.295329,43.845177,79.664226,25.979725,43.927081,79.470162,25.975439,43.969593,77.877686,25.570483,44.091359,79.628779,25.837471,44.252586,83.029102,22.904308,44.294702,79.761828,25.592411,44.312214,83.768716,22.667244,44.401810,82.662041,22.933280,44.430717,83.895274,15.863221,44.526003,83.745712,19.270292,44.575207,75.982319,24.591711,44.642131,76.158869,25.832755,44.742195,82.056617,22.931774,44.857509,75.055376,23.939437,45.017470,81.079766,23.986296,45.044669,82.375491,22.232019,45.054337,81.579246,22.415120,45.237740,81.349322,22.932148,45.268550,78.732120,24.413124,45.312686,82.916199,21.764527,45.353557,83.381319,20.117047,45.397224,82.641467,18.130976,45.417131,82.720877,21.754865,45.489701,79.157656,23.544341,45.538058,83.075993,20.621253,36.140720,91.129808,25.415039,36.189058,94.631012,18.447526,36.195068,94.771563,18.177857,36.215875,91.328387,20.844147,36.647599,91.272460,20.130767,36.915197,90.844004,21.252851,37.052759,91.147490,19.714595};
			return value;
		}
		private double[] getCoordinate_9_21_point_210()
		{
			double[] value = {37.256679,93.636106,18.269958,37.288643,93.602258,18.361078,37.622380,94.021032,16.753272,37.654626,89.045186,25.819774,37.780474,92.306862,19.191061,37.801438,90.168230,20.465552,38.127614,93.421066,16.507723,38.157944,90.232929,21.371605,38.217868,91.357758,18.680683,38.461514,89.028829,25.025198,38.598050,89.822348,20.475029,38.826456,89.497011,17.936834,38.920041,88.904170,24.643388,39.058645,89.447447,17.409299,39.088727,89.659180,17.273846,39.353394,88.267957,24.853245,39.400739,89.330813,16.851418,39.507518,89.085203,16.967181,39.507752,91.513740,16.958309,39.601910,91.653830,16.650150,39.678230,88.906110,18.712865,39.740557,91.727452,15.809469,39.925877,90.625798,16.368536,39.944627,88.912443,19.227273,39.964978,91.515834,15.647819,40.055543,91.372475,15.735227,40.065920,88.697626,16.371002,41.009795,86.006577,25.503410,41.021434,87.995730,19.060116,41.658711,87.405297,19.421803,41.719214,86.262017,24.279820,42.296781,86.560595,21.973595,42.471965,86.494345,16.333331,42.571186,86.276827,21.990723,42.851661,85.483007,23.211488,43.038339,84.764848,24.155501,43.061475,85.919380,21.115026,43.462019,84.974877,22.823813,43.625864,85.261275,20.191008,43.674258,85.268818,19.464586,43.865130,84.647251,15.743346,43.916035,84.788451,21.882715,44.050405,84.934730,17.481725,44.162268,84.461892,16.632627,44.321002,84.610555,18.973509,44.448735,84.536233,18.725638,35.366081,95.506856,17.380878,35.367628,95.234343,18.851394,35.378803,95.439604,15.756103,36.177344,94.920183,18.059822,36.579065,94.788741,17.648956,35.342267,-122.579163,36.267710,36.066474,-116.361234,34.834080,36.360847,-119.107263,36.017767,36.585208,-118.095108,35.887000,37.084165,-114.493438,35.237964,35.342572,-109.219262,31.669672,35.559901,-109.770248,31.155503,35.649877,-106.821541,30.507480,35.700308,-110.373508,31.090774,36.137670,-104.529986,31.119801,36.223157,-110.053120,32.653918,36.583111,-112.371002,32.868212,36.740783,-112.429784,33.168689,36.754985,-104.183950,31.578927,36.774441,-106.362284,32.285679,36.879668,-111.377460,32.591401,36.917235,-106.220221,30.886183,36.957680,-104.201113,31.644619,37.095569,-112.324689,33.198675,37.228158,-104.200077,31.730997,37.258325,-106.036645,32.714944,37.479498,-104.011867,32.206735,37.794084,-108.926789,34.153219,38.116721,-104.743097,31.659520,38.390606,-111.802966,34.145094,38.683405,-104.418597,33.233204,38.803465,-108.364384,34.109022,39.263391,-109.239417,34.157033,39.520073,-110.092924,34.762140,39.583134,-109.316807,35.635731,39.625858,-109.101494,35.576351,39.625875,-108.874449,35.531061,39.708974,-106.183794,34.450330,39.711370,-109.472727,36.158426,39.848708,-104.516281,34.947768,39.849603,-106.487746,33.884597,39.853201,-107.709088,35.626767,39.864138,-108.039760,35.577777,39.866791,-108.622277,34.852723,40.121443,-106.069712,35.580560,40.395489,-104.544058,35.482954,40.436679,-107.555556,36.281304,41.290254,-105.630247,35.510489,42.214469,-104.931884,35.623780,42.313785,-105.971979,36.218699,35.182533,-99.602442,29.717669,35.317251,-99.566802,29.847806,35.342776,-98.433566,32.395187,35.649290,-99.480709,30.180213};
			return value;
		}
		private double[] getCoordinate_9_21_point_211()
		{
			double[] value = {36.442856,-97.101737,35.882710,37.031537,-99.130864,31.586852,37.131737,-99.281860,31.527983,39.089525,-99.390780,33.277967,39.401399,-98.730421,33.905474,40.507731,-98.274628,35.527864,41.869376,-98.547173,36.012088,35.641970,-76.824969,35.838939,36.575953,-75.792536,32.114647,37.307267,-75.488945,32.945473,37.701521,-75.288688,33.122441,37.711840,-75.530326,35.861650,37.730040,-75.537989,30.410128,38.164834,-75.159393,32.248166,38.400067,-75.069336,33.385649,41.404254,-73.930383,33.384149,41.689171,-74.119678,29.300937,42.082934,-73.927709,30.279718,45.038958,-72.218812,35.963196,35.746243,-51.901605,26.940568,39.593418,-53.041700,28.548501,42.186757,-51.766378,26.667228,35.261826,-41.732088,30.459844,35.338455,-41.522743,30.482036,35.340905,-49.619332,32.485545,35.380338,-42.890030,28.703778,35.385395,-41.396889,30.533062,35.386901,-41.464648,30.358239,35.576043,-41.099832,30.212473,35.901449,-47.804751,35.168640,36.055927,-42.131422,28.507646,36.140043,-48.226292,33.496678,36.304801,-42.918594,26.632092,36.548265,-49.033816,30.751407,36.694189,-41.348530,27.692832,37.193863,-46.379958,34.454356,37.202931,-47.793650,31.952385,37.507407,-48.468825,30.752661,37.884535,-46.866942,32.759432,38.251340,-51.319329,28.736823,38.443415,-44.908166,34.937771,38.759664,-50.259479,30.058051,39.076099,-44.146931,35.544950,39.288819,-49.716529,30.914715,39.637881,-43.801686,35.958154,39.855111,-44.330717,35.603680,39.912213,-45.275418,34.892147,40.052041,-51.265063,30.354437,40.783860,-45.689145,35.878265,41.077680,-48.968058,32.880091,41.295153,-47.220958,34.901012,41.853870,-46.479982,35.597013,43.039913,-51.197318,26.683258,43.070543,-47.279025,32.704050,43.295956,-47.265346,32.291189,43.402669,-51.135808,26.606772,43.570965,-44.635430,35.343887,43.802812,-47.006591,31.991903,44.109033,-44.620555,34.682061,44.169694,-48.534283,29.700065,44.209709,-45.186680,33.960815,44.314651,-51.280169,26.360990,44.717287,-49.920494,27.955500,45.491159,-43.228478,35.717420,45.626231,-50.654774,28.034854,35.357493,-37.551676,36.044628,35.529860,-38.968835,32.487960,35.742217,-40.838801,29.808983,35.777745,-35.253196,33.833412,35.815590,-40.774220,29.673289,35.838553,-36.349497,35.091128,35.912029,-34.886308,33.763448,35.972969,-34.622251,34.163593,36.088632,-40.391655,30.521288,36.092722,-40.272852,29.977904,36.097214,-34.708411,33.286677,36.154017,-34.064994,34.104972,36.185594,-40.057628,29.695546,36.205500,-34.081227,33.910939,36.220215,-34.550997,33.095390,36.313658,-34.168713,35.021810,36.452368,-35.467299,35.627907,36.454416,-35.316436,35.478753,36.620174,-34.871803,35.613470,36.707140,-34.034582,36.031511,36.729340,-33.665709,33.068696,36.753093,-31.739938,35.030351,36.872531,-40.825052,28.207013,36.940449,-31.471861,36.189991,36.963316,-31.299688,34.865456,37.039225,-39.306593,30.225501,37.047500,-31.536710,34.454514,37.487730,-30.689633,34.756700,37.491136,-35.047498,32.338104,37.556750,-35.152498,32.282376,37.558231,-38.705198,29.968806,37.570101,-38.597566,29.882527,37.775171,-35.417095,28.638839,37.785768,-31.999251,33.555714,37.814267,-37.504473,31.099427};
			return value;
		}
		private double[] getCoordinate_9_21_point_212()
		{
			double[] value = {37.816997,-35.873364,28.024580,37.852641,-35.815139,27.904467,37.919375,-37.127624,31.135975,38.000296,-39.527180,26.555726,38.175384,-37.333537,29.661533,38.196116,-36.611753,26.709995,38.238850,-31.057108,34.087078,38.427440,-35.735824,30.917515,38.443821,-33.033358,32.196959,38.459050,-36.156484,26.406926,38.523897,-36.020182,29.649984,38.540807,-32.275324,29.242369,38.627376,-35.392121,26.217591,38.627844,-35.107011,26.154106,38.649064,-32.061394,29.601225,38.773538,-31.951118,28.450026,38.863589,-31.648985,29.940679,39.045168,-31.773610,32.849143,39.091962,-33.052162,30.025314,39.600380,-31.373689,26.575201,39.760885,-30.780592,26.039644,39.777732,-31.531507,31.188574,40.160666,-30.867617,27.450507,40.182956,-30.658992,31.797441,37.214737,-30.598140,35.179916,37.347257,-29.975859,36.154169,37.664230,-30.205424,35.124589,40.171165,-30.028983,30.311969,40.291227,-29.623048,29.440802,40.347996,-30.616886,26.986251,40.408533,-30.104187,32.118242,40.503809,-28.670628,26.043263,40.632189,-29.530351,28.014948,40.680316,-29.411060,28.284646,40.731376,-29.520159,33.338952,40.854794,-28.165340,29.858191,41.097802,-23.398411,26.580861,41.192836,-24.693263,32.519607,41.298516,-25.211998,26.687098,41.310456,-22.085096,26.932588,41.339408,-27.115848,28.056842,41.350693,-28.773752,32.709755,41.492888,-21.992533,27.672415,41.501795,-25.923127,28.646381,41.506825,-26.223103,28.344020,41.557533,-24.185216,27.204062,41.588068,-25.504596,28.701110,41.616514,-21.322378,28.055721,41.681197,-20.796764,32.505164,41.696519,-27.273801,34.796843,41.798096,-26.186658,33.416754,41.799838,-20.495802,32.184277,41.825440,-25.456256,27.087701,41.971301,-27.246614,34.035091,41.986497,-26.735685,34.874845,42.048874,-21.627697,33.629025,42.081655,-25.867083,27.844287,42.087905,-24.490692,28.406407,42.191334,-21.543183,33.883867,42.236739,-23.067476,34.239123,42.261442,-24.850053,27.895567,42.307566,-25.765817,35.173408,42.357890,-23.834184,36.324993,42.384225,-20.194166,33.723681,42.395310,-24.235880,30.282085,42.410013,-24.232513,30.090871,42.449037,-24.188526,35.829012,42.499826,-20.982569,31.248195,42.514358,-21.946832,34.470360,42.516511,-23.374582,30.001629,42.734845,-21.494543,30.875789,42.770774,-21.547353,30.085249,42.845089,-21.009577,30.201556,42.896815,-20.252655,35.685674,41.388802,-9.951297,29.424521,41.458521,-10.642591,29.607076,41.679948,-17.624639,27.759467,41.706203,-14.844335,26.824591,41.726985,-15.635973,27.111763,41.746790,-10.109801,26.456819,41.835467,-9.844475,27.298675,41.876066,-11.339352,29.013590,41.876637,-14.687829,27.556222,41.886157,-14.649377,27.769737,41.930126,-15.739384,28.024953,41.960580,-9.894472,35.879825,41.987865,-10.603156,28.196671,42.034363,-10.495613,35.928103,42.034416,-13.706538,27.727698,42.038972,-10.684910,28.212802,42.063259,-16.588147,28.479063,42.111448,-17.254573,32.013626,42.155352,-14.348172,34.870338,42.161103,-19.885828,26.498897,42.167611,-10.665564,31.487039,42.184832,-11.871807,31.388295,42.221299,-10.742124,27.427890,42.229661,-19.215888,26.486279,42.231801,-17.617862,36.333022,42.305754,-13.507740,36.211980};
			return value;
		}
		private double[] getCoordinate_9_21_point_213()
		{
			double[] value = {42.324566,-11.802786,32.564410,42.365754,-11.551527,32.479446,42.460894,-11.985603,33.184739,42.470695,-16.701072,35.959472,42.488689,-16.422396,28.971173,42.554527,-11.751996,36.265132,42.556537,-15.353030,35.495510,42.565651,-12.183001,28.529202,42.585592,-18.970690,36.292042,42.591659,-18.592603,36.215710,42.598637,-17.173146,35.767544,42.648058,-13.212795,28.284019,42.675913,-9.718048,31.807815,42.689442,-12.440991,36.118682,42.784723,-13.722386,32.056736,42.819637,-14.749208,32.317206,42.821250,-18.307159,33.556173,42.821786,-17.978238,35.720720,42.872415,-14.185926,28.974030,42.896739,-16.480683,35.025080,42.900076,-17.731383,29.843793,42.917635,-18.331490,33.934660,42.920965,-20.008245,35.911210,42.949084,-17.169867,33.201663,42.951493,-14.368337,32.843355,42.954631,-14.758258,33.606733,42.967251,-14.772473,30.087504,42.970854,-11.142053,35.274161,42.982523,-10.245929,34.607512,42.984969,-17.616587,30.197574,43.001742,-11.185251,35.185908,43.024448,-18.683375,34.662680,43.031156,-11.295429,35.000196,43.041359,-17.001564,35.100690,43.051677,-18.986790,34.956801,43.053482,-16.471257,34.724998,40.485078,0.612748,31.995970,40.542134,-4.015480,27.658401,40.575902,-4.830299,27.915712,40.595796,-1.026304,31.636262,40.658599,-1.366873,32.907960,40.700050,-3.029078,33.452705,40.743684,-5.672186,35.457703,40.759126,-4.131035,35.716607,40.759559,-3.592044,34.307246,40.829315,-2.692708,32.391993,40.849483,-0.095844,28.668371,40.856430,-1.103118,30.670265,40.863740,-3.895758,26.988315,40.878525,-1.290657,31.294544,40.907651,-1.349239,30.638841,40.914896,-3.537067,30.070654,40.916129,-2.137473,34.449721,40.931152,-2.656092,35.016430,40.934969,-2.717934,35.136176,40.976882,0.204032,28.399728,40.980113,-1.965317,31.677220,40.980527,-6.889985,28.482458,41.010512,-4.148317,26.299323,41.010684,-1.906960,30.744016,41.061250,-2.877912,29.938619,41.131971,-6.024811,28.873115,41.206977,-2.321069,31.227757,41.279594,0.163589,34.719270,41.290202,-1.023604,27.297811,41.380192,-7.412864,26.433309,41.395536,-5.568253,34.910788,41.396965,-3.056783,26.223973,41.397133,-0.724106,27.283921,41.407691,-5.146858,29.687326,41.417092,-6.226343,30.948164,41.431976,-5.247050,29.702918,41.455165,-3.108565,32.221934,41.470274,-1.044141,35.027411,41.532314,-8.968128,27.727478,41.541194,-4.605364,33.781008,41.568424,-8.622880,26.698408,41.595934,-8.791292,36.318314,41.615372,-5.657992,34.726953,41.632348,-3.440165,32.361815,41.667318,-9.687138,26.350530,41.681199,-9.520395,35.974612,41.681468,-5.828421,34.801595,41.684771,-6.173197,35.099418,41.726732,-8.461119,35.990152,41.734480,-6.286263,30.248048,41.751635,-5.415841,34.342978,41.798696,-9.528352,35.822563,41.808136,-0.068196,26.323628,41.818170,-7.046100,32.559672,41.839902,-7.095929,31.605501,41.892232,-4.470485,32.234364,41.897105,-5.219308,32.269899,41.920165,-6.816220,30.134912,41.969165,-4.633572,32.449969,41.981560,-6.020052,32.439805,42.565214,-8.681909,31.435993,42.831411,-8.927859,32.628552,39.623089,9.930132,35.466759,39.854494,9.407321,30.070612};
			return value;
		}
		private double[] getCoordinate_9_21_point_214()
		{
			double[] value = {39.866454,9.617260,30.101119,39.959969,9.799575,34.371677,39.961196,7.041747,32.024474,40.002488,10.514518,30.093523,40.050082,8.750767,29.250211,40.081934,3.451404,30.145714,40.145261,6.406252,29.084733,40.168721,2.303730,30.604333,40.191025,6.150514,33.589609,40.238557,5.284781,33.058488,40.239697,5.527239,32.574725,40.250217,9.836190,27.530684,40.250814,5.166948,29.255889,40.251874,3.383960,30.545730,40.273921,4.939000,34.167772,40.278870,7.687101,28.393304,40.394402,4.954037,32.826857,40.395295,4.769709,35.816774,40.445946,4.702307,33.415677,40.455455,4.751082,32.002401,40.461488,4.431483,33.501129,40.473618,4.461741,33.593229,40.475582,2.735961,34.751164,40.505672,10.201019,32.944767,40.525882,4.789299,31.479550,40.542753,3.636947,31.082749,40.551362,7.881981,35.818637,40.553803,10.123117,26.554147,40.595762,3.334928,34.742705,40.625504,10.738594,30.956935,40.645740,9.066927,27.012740,40.651330,10.748667,31.810915,40.677109,7.796084,27.069543,40.684637,9.983634,26.324328,40.688672,7.510093,27.864238,40.730384,1.492692,29.276645,40.762338,7.382055,27.713244,40.809456,1.001204,36.290363,40.825352,8.199801,33.941030,40.826853,2.552731,33.676784,40.843491,5.954833,28.269989,40.850642,6.427256,36.296339,40.852442,6.012556,28.162283,40.862364,6.878937,26.498858,40.871576,7.517147,26.716826,40.879664,1.475879,28.967155,40.902781,5.836368,36.312261,40.924174,2.070933,34.199506,41.030770,5.201731,26.811816,41.146242,4.560760,26.572309,41.165126,3.615400,27.497179,41.214616,3.780892,26.963458,41.227567,4.596577,26.285712,41.236045,4.950269,26.113289,41.260819,2.748813,27.921190,41.368042,1.040918,27.790496,41.461594,1.594247,27.196974,41.533532,1.563560,27.023470,41.647695,1.226258,26.826407,41.702378,1.030523,26.783803,37.287427,21.351293,36.054959,37.343547,16.291635,35.237977,37.378350,16.377539,35.507009,37.380599,19.841262,36.297923,37.401040,16.009398,34.913637,37.444611,15.950773,36.184227,37.475714,19.219329,36.152760,37.670098,18.262639,35.769698,37.677664,17.513395,35.603551,37.733619,18.209532,34.969697,37.764874,20.989638,33.365496,37.769925,17.465746,33.827264,37.789502,19.774707,35.432694,37.822185,13.998383,35.556354,37.873275,21.341079,32.658183,37.884738,20.008980,34.971935,38.252449,20.523919,32.347845,38.530885,12.980422,35.873388,38.987123,12.996848,35.589672,38.998752,13.351478,35.299746,39.619890,11.643949,35.816800,39.622732,18.622729,31.455568,39.677821,15.213321,32.955515,39.822975,17.933820,30.845659,39.859116,13.242229,31.927592,39.860254,21.505465,29.866218,39.878338,20.588711,29.786640,39.910236,13.098252,33.501788,39.992350,12.922022,31.880313,40.051143,20.019321,29.239326,40.215822,11.534334,29.836526,40.223003,18.059414,26.529069,40.223942,14.354201,27.419234,40.228591,12.299990,28.481797,40.239531,17.394423,26.942544,40.243570,14.654747,27.420925,40.276032,12.138681,29.535362,40.293179,13.935844,27.041406,40.328424,17.295645,27.564632,40.394759,13.434591,28.900465};
			return value;
		}
		private double[] getCoordinate_9_21_point_215()
		{
			double[] value = {40.439169,15.118992,28.551078,40.458178,11.489576,31.831789,40.489239,13.878003,29.346752,40.546817,12.166324,26.168184,40.547408,12.256240,26.136910,40.630605,11.838397,30.508504,36.733954,29.515822,35.728146,37.193596,22.103475,35.981474,37.513235,24.853638,35.177339,37.531948,22.224850,35.451264,37.552343,29.746882,34.647008,37.632436,29.429070,34.121727,37.715426,25.918814,33.939341,37.738673,29.593218,33.919347,37.829621,30.389899,33.897820,37.838797,21.835060,34.925514,37.926923,22.155942,33.570052,37.961628,24.550974,33.486315,38.008755,24.233710,32.635396,38.129778,27.557105,33.144631,38.271986,25.281317,32.314780,38.322816,23.134314,32.048898,38.435170,31.790774,33.223542,38.456509,26.394811,32.677002,38.482100,24.448580,32.047049,38.485967,27.326917,32.805970,38.683056,26.861715,32.047372,38.761296,22.477400,31.486945,38.992027,22.901116,31.211840,39.003416,30.350990,32.699142,39.079172,29.008690,32.065502,39.097622,25.874519,31.478763,39.429636,22.193716,30.823901,39.672580,24.118123,30.216977,39.706629,25.821919,30.165683,40.040903,26.266794,29.789959,40.180492,21.698931,28.912799,40.250023,22.181373,28.839866,40.419635,26.633074,29.445404,40.704869,29.071480,29.885791,40.793249,30.739553,30.205855,41.593962,30.384581,29.042621,42.037212,24.173042,26.321890,43.275277,27.593523,26.204199,37.186640,33.602052,35.422358,37.539227,35.368184,35.306171,37.854432,32.254882,34.561607,37.924516,36.224662,35.878231,38.001653,36.293591,35.346550,38.164916,36.548331,35.545096,38.368510,37.026429,36.068034,38.614991,36.019366,34.140495,39.394862,40.545518,35.432542,39.860095,40.975070,34.879202,40.018520,35.633856,32.270924,40.076645,35.462994,32.051373,40.689439,40.455192,34.119748,40.810650,41.354033,34.250915,41.373446,36.094219,30.576501,41.403447,38.426585,30.871846,41.426113,35.821808,30.508692,41.489986,37.750592,30.380581,41.762011,36.435519,30.134016,41.780027,41.410448,33.607602,41.805287,39.594162,30.441072,42.461473,40.372025,29.103561,42.542940,40.879080,29.428950,42.638681,34.409655,28.492663,41.207738,42.924384,35.275567,41.310385,50.518768,36.121755,41.695705,45.156113,36.368482,41.790893,43.891318,35.526496,41.914565,52.581607,36.006190,41.920432,52.332694,35.879233,42.086352,46.230105,35.986456,42.150831,45.651752,36.047907,42.289131,46.920225,35.607130,42.294506,49.725594,36.008251,42.934892,46.551361,35.283622,42.961698,48.788584,35.321167,43.086662,45.413772,34.234873,43.132938,52.008520,35.003137,43.163204,46.691564,35.069975,43.169376,49.565698,35.134172,43.182940,45.511874,33.585954,43.306154,45.631367,33.329559,43.405544,52.461723,34.790184,43.457962,49.320073,34.056790,43.469194,42.748064,26.788995,43.495729,46.042684,33.373793,43.547649,50.905448,34.657279,43.591202,42.824698,27.953010,43.770864,46.467227,33.097231,43.922457,49.139389,33.745914,43.968662,46.779949,33.776517,44.140936,44.301801,32.235321,44.146980,52.576447,33.964166,44.163662,49.749948,33.395525,44.197722,44.778809,32.475987,44.294411,47.440747,33.617538};
			return value;
		}
		private double[] getCoordinate_9_21_point_216()
		{
			double[] value = {44.314276,45.250116,32.420533,44.315043,43.818213,29.147241,44.340300,47.332144,32.337175,44.408744,44.321997,29.476419,44.709409,51.380292,32.602162,44.797720,49.586691,33.161071,44.829506,45.092031,26.551999,44.963655,46.568691,31.776987,45.086058,45.707060,27.829781,45.126516,49.910378,32.713662,45.150719,48.335313,31.271501,45.189096,46.898076,28.741558,45.365578,46.280520,26.802961,45.377921,47.598439,31.313023,45.426177,46.479900,30.857272,45.574619,47.034495,26.330405,41.780822,62.501682,35.349058,41.848028,61.751165,35.180260,41.900413,60.690521,35.916355,42.068043,57.855052,35.610066,42.230867,62.632235,36.354167,42.873589,53.673828,34.912808,42.911651,55.841357,35.345143,43.050242,59.758354,34.713609,43.254315,56.381884,34.510016,43.316615,63.253287,33.681836,43.323086,57.850091,34.428421,43.473706,58.779740,34.197120,43.539156,58.268035,34.151573,43.560897,59.921418,34.020623,43.573789,57.698436,33.941714,43.675673,61.218305,33.392099,44.225228,61.319869,31.997839,44.329000,62.075804,31.814503,44.374969,60.864107,31.812633,44.376704,53.207367,33.566511,44.501413,53.628196,33.316877,44.523641,58.987766,32.285942,44.560902,54.380682,33.170184,44.600337,54.950862,33.068165,44.637960,54.410258,32.933318,44.791663,56.487636,32.248841,44.922531,57.887376,31.251265,45.202976,56.923144,31.029207,45.367068,52.992502,31.865357,45.489055,61.046452,30.665471,45.590103,60.380647,30.458437,40.554949,69.796260,35.783329,40.778788,68.831080,35.557480,41.066276,70.885143,35.803617,41.092382,68.042961,34.910766,41.428253,68.154121,34.535530,41.452009,66.799420,36.021914,42.205067,73.018105,33.880004,42.317529,66.152986,33.857744,42.504105,67.623304,33.864529,42.831618,65.555954,33.678560,42.881665,67.654183,33.377905,43.204188,66.560406,33.071660,43.358922,63.868302,33.417044,43.839814,66.836656,32.577493,43.876199,69.496814,31.504215,43.958667,67.939755,31.960702,44.006628,67.503500,32.146711,44.678731,68.655407,29.756757,44.872197,63.455296,31.622799,44.906433,73.017160,28.717762,45.014440,67.633436,29.034589,45.116648,64.732220,30.247474,45.181655,71.962082,28.517976,45.355802,66.184931,28.540762,45.518133,72.345116,26.095126,45.565604,66.102541,27.639126,45.611867,68.780111,27.270757,37.034563,83.998150,34.903987,38.588971,83.213319,33.802629,38.603783,83.169890,33.860676,39.021089,82.539075,33.843973,39.338079,78.604242,35.791081,39.435405,81.236969,34.769936,39.453620,79.086027,35.576286,39.639587,84.314971,29.674688,39.670021,82.582299,32.528141,39.702284,82.863134,30.929589,39.765091,83.755011,29.739945,39.869769,82.647337,30.441645,40.034574,80.208937,34.969118,40.644719,74.183469,36.072125,40.722336,74.844317,35.386326,40.876810,81.006219,31.291111,40.921809,74.137629,35.336878,40.931818,81.862267,29.102341,41.038347,76.496452,35.225774,41.104838,80.145109,33.373694,41.317814,81.381103,28.756982,41.345436,79.306624,33.861275,41.670231,80.916274,29.871964,41.688311,78.949886,33.350442,41.688529,79.369078,33.154118,41.810343,78.536365,33.393661};
			return value;
		}
		private double[] getCoordinate_9_21_point_217()
		{
			double[] value = {41.811137,77.444691,34.528527,41.819333,80.712008,28.406361,41.897190,80.163692,30.506655,41.928239,76.522852,34.743516,42.002208,80.563961,28.779562,42.114060,83.588199,26.604601,42.214762,80.944797,27.388560,42.318567,82.344145,27.043407,42.411636,79.677468,30.014752,42.521012,79.910034,27.638653,42.743681,76.879061,32.709825,42.799087,79.348634,30.895883,43.192226,79.069687,28.723883,43.250093,78.790996,26.378117,43.295634,77.204316,31.972534,43.337810,74.982089,33.220142,43.497398,75.662942,31.783136,43.545135,77.992297,26.263456,43.622861,75.259107,32.394980,43.642018,78.508607,27.716826,43.660073,77.736855,26.157436,43.774425,75.214703,31.290960,43.784499,74.568491,32.398866,43.850912,74.176439,32.417882,44.218716,76.836424,30.099595,44.350159,75.961674,30.166804,44.565357,76.943804,27.911067,44.636576,75.903148,29.337359,45.085359,74.623174,27.845036,35.292185,86.852277,34.159935,35.293654,90.805649,27.244149,35.468169,90.793935,26.632810,36.035787,85.896821,33.608713,36.312325,85.197965,34.743202,36.586263,86.196223,32.904214,36.605413,84.727712,34.775088,36.699761,89.745145,27.601445,36.913229,86.578556,32.096325,37.035192,89.493739,26.476931,37.126009,84.419174,34.064745,37.774587,85.036435,32.802346,38.099907,86.677376,29.851751,38.290099,86.702881,29.550306,38.337452,84.793361,30.732891,38.969329,84.361426,30.235016,39.280666,86.901464,27.584025,39.581037,84.677009,29.577021,35.368335,-138.710862,43.138946,36.420069,-135.507064,39.817656,36.963139,-139.361852,39.841640,37.987623,-138.836904,40.509540,38.865306,-135.665002,41.392533,39.028185,-138.545032,41.330238,39.434524,-135.700663,41.789768,39.878060,-138.465738,45.064961,41.352322,-138.804819,43.433945,42.294790,-138.679955,44.233633,42.524786,-138.448824,44.375732,42.910716,-138.075190,44.620996,43.269384,-138.405935,45.841847,44.175128,-138.427837,45.845285,44.659033,-138.350599,46.326724,45.033554,-135.365265,46.247205,36.613113,-126.222956,38.405610,36.841335,-134.692930,40.455752,36.889358,-128.338940,39.189655,38.444619,-125.245651,39.751118,41.823194,-130.077239,43.883966,43.025764,-134.805195,45.238644,44.017476,-135.073765,45.688107,44.190313,-133.801853,46.598842,44.390392,-124.903032,44.820204,45.038658,-124.858398,45.377007,38.472264,-120.186785,38.340885,39.037815,-116.113390,37.597294,42.468010,-114.693072,40.451383,43.932377,-115.370660,41.972419,44.931402,-121.154174,44.323811,39.961617,-111.745243,36.983918,40.312057,-110.043145,36.869839,40.778951,-107.751763,36.653853,41.221399,-107.712045,36.664502,41.519821,-109.175173,37.017418,41.576788,-108.662995,37.101186,41.767700,-111.407291,38.775696,42.192887,-110.408079,37.556644,42.329647,-107.738328,36.655520,42.381275,-108.500340,37.027767,42.434986,-106.572478,36.852000,42.582557,-107.715413,36.861072,42.617599,-105.586486,37.357596,42.750640,-109.102953,38.425104,42.804681,-109.643755,39.233106,42.908695,-104.927121,36.850840,42.952944,-110.674052,39.652347,43.218240,-104.815272,37.242131,43.253551,-106.228734,38.241562,43.261896,-110.885485,39.898692,43.279915,-108.578540,39.155380,43.310496,-108.284424,38.776493};
			return value;
		}
		private double[] getCoordinate_9_21_point_218()
		{
			double[] value = {43.520381,-106.553098,38.314586,43.796474,-108.481437,39.394880,43.872120,-104.716915,38.202186,43.981754,-106.674450,38.340565,43.990904,-104.658286,37.800471,44.240302,-113.067113,41.663989,44.347413,-108.123090,39.074461,44.391862,-105.872210,38.588072,44.429196,-112.412164,41.647936,44.709495,-109.919253,39.733036,44.754526,-111.137938,40.901680,44.769674,-111.144216,40.585799,44.875716,-108.417363,39.372991,45.079668,-109.894609,41.046706,45.165292,-108.584637,39.803766,45.221874,-109.969547,41.418266,45.305824,-106.766982,39.743634,45.347717,-105.622950,40.118895,45.370538,-105.648584,40.323226,45.370658,-104.592758,40.022735,45.372409,-109.316083,41.430255,45.394922,-103.865771,38.490482,45.401951,-105.771332,39.203545,45.407277,-105.309392,39.507564,45.455394,-104.240065,40.245226,45.501331,-106.816618,40.605263,37.799723,-96.695292,37.426095,39.792189,-94.298586,41.733252,40.277646,-95.845590,40.329613,41.568655,-98.037565,36.722814,41.982302,-102.293729,36.536855,43.015354,-96.178449,41.707835,43.098787,-100.425381,37.284695,43.325672,-103.524313,36.710889,43.746148,-98.289213,37.761404,44.338801,-98.153101,38.365242,45.023699,-102.641388,39.545099,45.039024,-100.791208,39.261397,45.308873,-103.357745,38.677801,45.376096,-103.551874,38.580211,45.405820,-103.693660,39.957875,45.433942,-103.697631,38.645682,45.577078,-103.650466,40.317652,35.331980,-85.663329,41.512354,35.466352,-84.816419,42.273446,35.706803,-83.166558,41.524802,36.573294,-83.611927,43.096018,37.286309,-85.335402,43.182315,37.362769,-83.450509,43.796894,37.415838,-90.798830,42.145578,38.001426,-83.012478,43.976281,38.421151,-85.139273,44.191655,38.563779,-88.725965,43.698445,38.642825,-83.113477,44.773589,38.711737,-87.260747,44.006390,39.332308,-83.977602,45.809014,39.941689,-88.503534,44.947502,41.022739,-87.249882,46.182100,41.070698,-87.316613,46.230469,41.181430,-86.820430,46.560449,35.711915,-82.215867,40.854371,35.784917,-78.695546,38.461674,36.227007,-77.293758,37.627625,36.678051,-76.526747,36.990563,36.817198,-79.479627,40.211331,36.955852,-80.476186,41.073849,37.820961,-76.734037,39.085896,37.884721,-75.618690,37.337663,38.029561,-77.175019,39.691021,38.127966,-78.618132,40.993421,38.145324,-79.402051,41.547185,38.187487,-77.860697,40.474688,38.417962,-75.783273,38.665008,38.622477,-75.921951,39.398024,38.633949,-79.602568,42.358618,38.943560,-76.092678,39.933905,39.157555,-79.302824,42.694174,39.221419,-75.020245,38.540771,39.301563,-82.500362,44.711872,39.352650,-74.671856,36.612088,39.374653,-82.341730,44.655091,39.487827,-82.300370,44.752703,40.298342,-78.347632,43.353164,40.330659,-79.539382,44.169184,40.725951,-74.208299,39.133693,40.938632,-75.572631,41.939009,41.054040,-80.657728,46.446465,41.088682,-74.753221,41.231882,41.106908,-80.425684,45.700940,41.331573,-79.556105,46.546052,41.425130,-79.408014,46.387504,42.129230,-77.796317,45.773976,42.155313,-73.388520,39.461103,42.290066,-73.314279,39.597555,42.494050,-75.331087,44.146328,42.661313,-73.058663,39.883278,42.672018,-75.586592,46.095425,42.772755,-74.853618,46.255118,42.917215,-73.052022,40.993591,42.990544,-74.567643,44.930978};
			return value;
		}
		private double[] getCoordinate_9_21_point_219()
		{
			double[] value = {43.186858,-73.484994,43.065287,43.414174,-72.746685,36.500515,43.460143,-73.448890,45.073727,43.628528,-72.552921,37.744646,44.473796,-71.709339,40.687510,44.762516,-71.486300,43.146571,44.989302,-71.522586,39.687029,45.066640,-70.114546,46.347378,35.352398,-46.075295,37.712592,35.458250,-42.744305,41.094600,35.484940,-42.392620,41.352701,35.486400,-45.600543,38.254450,37.519290,-42.446931,39.143066,38.153422,-42.030966,38.656687,38.959893,-43.184488,36.676339,39.228335,-41.875814,37.964622,39.352660,-43.064035,36.675693,40.219743,-41.339726,38.627499,40.361980,-43.899002,36.662456,41.191585,-45.265395,36.642288,41.318862,-42.481402,39.068253,41.424944,-43.007481,38.741186,41.495110,-41.592781,39.893597,41.598625,-45.389673,36.754457,41.647414,-42.566858,39.176968,42.236704,-44.146843,37.650388,42.403449,-42.139662,39.218533,42.558325,-43.111318,38.246459,35.274158,-38.992581,44.127054,35.661666,-35.110213,37.434815,35.889905,-40.278790,43.081677,35.916406,-36.215512,36.442758,35.923001,-38.387508,44.317405,35.989959,-31.313257,38.527727,36.070633,-40.864804,42.374221,36.099828,-36.434331,45.130705,36.115517,-39.857071,43.212156,36.159160,-38.849526,43.837851,36.740778,-30.702648,37.784975,36.888720,-32.698107,46.307029,37.127029,-35.331867,44.615648,37.323416,-35.899431,43.976861,37.594509,-38.764730,41.721294,37.640469,-36.124648,43.570462,37.820909,-33.691375,45.113047,37.931990,-39.590974,40.940073,38.341476,-39.750826,40.442219,38.565320,-33.162960,45.214366,38.750997,-35.039564,43.750330,38.986121,-33.679715,44.830585,39.016755,-34.598113,44.096826,39.092757,-37.925872,41.443480,39.271348,-33.349245,45.315119,39.351036,-38.308158,41.091927,39.576631,-35.873469,43.272629,40.124894,-39.544395,40.221036,40.213651,-39.241312,40.545848,40.397260,-40.177037,39.884976,40.466507,-38.170503,41.971167,40.520402,-34.501523,45.272351,40.857815,-39.746521,40.949467,40.879229,-37.062804,43.307736,40.982035,-41.008811,39.986543,41.151288,-32.886999,46.183268,41.201319,-33.152981,46.000570,41.321420,-40.842159,40.340591,41.622516,-40.738172,40.556029,41.842131,-38.914493,42.003493,41.871509,-36.309356,43.809812,41.957561,-36.813306,43.390126,42.040674,-39.505841,41.459488,43.300874,-34.717264,43.574157,43.544961,-35.092729,43.205111,43.988393,-32.394828,45.207499,44.265805,-40.243907,38.804953,44.291317,-37.117063,41.305661,44.495578,-36.692137,41.595887,44.626762,-31.163084,46.527326,44.686223,-31.016385,46.672972,45.189835,-40.083313,38.621241,35.350241,-27.751561,42.835226,35.412243,-24.109407,44.219388,35.414754,-20.313996,43.877249,35.938791,-25.701633,43.073552,36.242440,-22.862751,43.975580,36.309404,-29.831911,39.868871,36.338765,-22.514355,43.733746,36.732849,-30.602905,37.986801,36.741826,-29.822925,39.379950,37.269054,-27.906927,40.569204,37.279905,-29.903836,37.636850,37.294047,-21.557186,42.525529,37.472298,-21.098669,42.348578,37.607368,-29.349159,38.051948,37.615393,-29.199663,37.301645,37.811376,-28.332724,37.364444,37.826693,-28.923637,37.983819,37.885688,-27.757087,39.701068,38.113365,-24.156927,41.743361,38.141395,-26.417395,38.555160};
			return value;
		}
		private double[] getCoordinate_9_21_point_220()
		{
			double[] value = {38.310464,-26.594346,38.147146,38.317210,-21.033014,41.510859,38.416011,-20.753626,41.427303,38.654311,-24.748369,40.480611,38.703681,-27.707162,37.010983,38.882880,-20.967421,41.306036,38.896903,-23.260932,40.934601,39.084050,-26.567055,37.581816,39.235963,-21.130431,39.347611,39.726193,-20.840315,38.870065,40.055619,-25.031971,37.976231,40.239146,-23.767155,38.413195,40.676386,-23.205996,38.253609,41.157365,-22.675713,37.641579,41.224011,-22.178173,37.620460,41.308055,-22.002499,37.531749,41.429931,-20.794000,37.568976,35.241780,-13.399169,45.542902,35.333993,-17.260366,43.405727,35.434060,-15.853960,44.301963,35.536354,-13.350336,45.121650,35.595310,-9.737700,45.587488,35.614436,-12.669293,45.245289,35.615588,-14.920076,43.974317,35.679344,-14.799663,45.011221,35.723657,-11.081319,45.200128,35.767007,-17.131214,42.814107,35.887575,-14.680698,43.301745,35.955080,-16.299359,42.555565,35.963093,-13.560662,44.038276,35.985683,-10.633276,44.971082,36.202000,-16.053097,42.348819,36.226033,-16.877320,42.583169,36.248917,-13.962322,43.017892,36.353004,-13.607658,43.192981,36.395222,-10.727528,44.589967,36.516840,-13.066891,43.293595,36.520680,-13.747138,41.808455,36.537801,-13.159045,43.023085,36.562100,-12.063621,44.046354,36.673620,-19.642733,43.229587,36.701760,-12.472298,43.076337,36.957380,-14.184151,41.484687,36.985856,-15.564241,41.854215,36.998441,-16.115899,42.009224,37.124106,-11.846288,42.521431,37.171286,-9.915842,43.965662,37.204994,-16.855294,42.159263,37.579316,-11.776806,41.112092,37.665436,-11.327283,41.719380,37.757217,-9.806653,43.483611,37.884537,-16.924488,41.812180,37.905790,-16.543318,41.751759,37.920339,-11.040534,41.147538,38.296752,-15.398486,41.200747,38.354029,-15.516873,41.139980,38.365555,-14.429108,41.072848,38.440864,-16.833921,41.406079,38.527800,-17.440472,41.054787,38.561889,-13.513676,40.810619,38.894559,-19.525837,40.957374,38.982486,-11.962873,40.283551,39.208274,-14.547585,40.285531,39.419974,-11.760941,40.133452,39.645057,-16.884613,39.502460,40.182486,-14.656678,39.177501,40.185181,-10.005615,39.001297,40.340829,-18.567662,38.043883,40.426915,-17.364203,38.346947,40.496337,-11.651659,38.600623,40.499565,-17.095403,38.216390,40.540654,-10.063430,38.870207,40.783291,-18.415085,37.811768,40.796689,-11.834275,38.364161,40.876001,-17.359577,37.349839,40.919841,-16.498587,37.211074,41.259085,-16.311288,36.809714,41.663752,-11.752922,37.075684,41.679874,-17.416218,37.023791,41.688515,-17.599975,37.076113,41.996302,-13.903590,37.143342,42.058346,-13.546666,37.263035,35.532253,-5.379734,45.586034,35.699460,-6.307034,45.278315,35.757606,-4.575416,45.898557,35.793459,-4.813784,45.468499,35.885236,-5.234442,45.136581,36.091576,-2.517571,46.137281,36.136040,-4.364058,44.974730,36.342219,-6.063287,44.977553,36.428660,-1.045715,46.112313,36.618365,-6.543374,44.999903,36.649938,-0.823173,45.322945,36.715829,-3.845812,44.326251,36.720946,-3.416353,44.406218,36.721675,-6.542281,44.982310,36.768331,-8.915249,44.558018,36.861652,-2.646134,45.050452,36.978813,-0.190280,44.904775,37.059006,-6.997561,44.734723};
			return value;
		}
		private double[] getCoordinate_9_21_point_221()
		{
			double[] value = {37.194182,0.527965,45.255440,37.266442,-6.781858,44.464830,37.415160,-0.588437,44.284884,37.537210,0.441133,43.952660,37.583826,-1.553424,44.278377,38.006430,-0.706646,43.819401,38.124445,-1.902651,42.680882,38.126720,-4.504479,43.778002,38.203302,-8.794774,41.893008,38.204685,-5.207542,43.596220,38.306093,-5.775056,43.369975,38.374976,-5.188329,43.324884,38.576909,-1.667923,42.095474,38.623864,0.616393,42.865739,38.858376,-1.238064,41.557714,38.914938,-0.934124,41.479396,38.937221,-0.691626,41.896778,39.077541,-9.283108,40.623837,39.098084,-9.456304,39.772270,39.110486,-7.372389,41.916027,39.123554,-7.483343,42.332509,39.155676,-9.365734,39.733778,39.304334,-0.132186,41.471535,39.324204,-9.125147,39.531977,39.363239,-3.707860,41.863313,39.378136,0.168812,41.462102,39.388027,-9.094942,39.311820,39.605710,-6.271506,41.596139,39.723624,-5.800014,39.614507,39.727943,-8.434978,38.850483,39.789120,-8.115940,39.847177,39.817045,-5.799137,39.299200,39.861234,0.202981,39.092613,39.883413,0.185808,39.002686,40.030948,-5.265965,40.006877,40.187721,-2.333132,40.270088,40.242995,-6.904184,37.685953,40.243478,-1.714133,40.236229,40.342083,-0.306503,39.010445,40.423856,-3.093131,40.192070,40.438358,-1.915242,39.750486,40.522083,-1.263819,39.191136,40.529375,-6.407819,38.593222,40.556734,-1.617039,39.318369,40.628510,-2.890855,39.709162,40.669832,-4.940286,37.554560,40.739923,-7.500519,37.037983,40.751152,0.603667,37.074710,40.770892,-5.736488,37.927968,40.785191,-4.713918,36.704280,40.806166,-5.136105,36.939298,40.911850,-2.565822,38.814478,40.961350,-2.423921,38.694073,41.042713,-8.088792,37.221670,41.044133,-0.833394,37.481948,41.091256,-3.006609,38.914099,41.101835,-3.323119,39.119295,41.116579,-9.608190,37.647068,41.276139,-9.684568,37.031360,41.498788,-2.053421,36.560117,41.779889,-7.757681,36.381599,35.225259,5.330099,44.920695,35.468074,10.681205,42.301587,35.612966,6.905221,43.593332,35.747380,2.664757,44.992492,35.866492,8.252625,42.779064,36.213010,5.493457,44.334328,36.283197,0.743817,46.062635,36.478270,6.288698,43.672116,36.579063,6.603118,43.399079,36.592897,6.017749,43.734079,36.972403,7.263955,42.612798,37.028754,7.559438,42.276224,37.206739,4.493803,43.286637,37.332531,2.645628,44.495257,37.486328,2.964015,44.188079,37.657659,6.300699,42.308402,37.794015,3.191544,43.766768,37.836667,1.503394,44.059802,37.854169,8.570627,40.515092,37.886154,6.481275,41.911609,37.925048,1.035671,43.360754,37.955307,6.932580,41.744378,38.106986,7.033720,41.423356,38.120664,5.702159,41.940723,38.151537,2.765291,43.500361,38.162802,8.672878,40.118121,38.199044,1.895836,43.082142,38.262285,4.161571,42.701963,38.271762,1.434733,42.787251,38.450556,4.600609,42.180678,38.462239,6.111081,41.304413,38.551585,2.298770,42.514514,38.555642,2.921844,43.010777,38.772293,1.980108,41.938895,38.800408,7.837466,39.825078,39.010630,2.279516,41.480090,39.090727,9.232321,38.303173,39.091499,9.780235,38.099973,39.293082,6.435657,40.041889};
			return value;
		}
		private double[] getCoordinate_9_21_point_222()
		{
			double[] value = {39.294030,7.623604,38.187031,39.319906,6.615685,39.685131,39.389707,4.113191,41.462474,39.429352,10.727382,36.741708,39.549007,0.977026,41.185135,39.579437,10.756312,36.439078,39.608714,6.143568,39.731738,39.646409,4.133411,41.055867,39.699254,4.972904,40.411104,39.764714,2.450177,40.377528,39.798037,4.134053,40.737787,39.833746,5.468451,40.050795,39.919471,1.772069,40.603159,40.022590,2.737624,39.688127,40.079232,2.910570,39.451138,40.132814,2.029325,40.057486,40.146565,4.736387,39.787300,40.160849,1.733571,39.444668,40.263414,1.142610,38.643738,40.344536,2.984153,38.815182,40.457113,5.971485,38.039398,40.514346,3.338269,37.878891,40.562904,6.825526,37.076530,40.714650,5.285151,37.719696,40.735433,3.674076,36.423996,35.209276,13.138283,41.303596,35.310099,19.967592,39.194522,35.317388,15.082807,40.789043,35.490214,17.681657,39.239496,35.631425,19.355362,38.832839,35.656596,15.857963,39.759979,35.705920,11.926484,41.495592,35.776729,17.369852,38.866070,35.844928,12.611279,40.815540,35.866174,16.900098,38.944074,35.885554,15.762089,39.441522,35.956708,12.821644,40.609460,36.070929,21.509834,37.732886,36.239835,14.607191,39.315819,36.641636,11.868264,39.613603,36.810140,17.189864,37.864008,36.940088,17.426374,37.549840,37.030712,15.392669,37.695741,37.105107,18.235044,37.141455,37.183135,13.346940,37.756609,37.230064,13.698864,37.182732,37.300224,14.719956,36.486674,37.418013,17.500310,36.787644,37.420167,16.305875,36.414794,37.426272,14.684967,37.052576,37.607370,12.947148,36.654783,38.920404,11.971823,36.531568,35.189026,25.333272,42.402679,35.338059,28.729389,39.956241,35.400054,21.891905,38.620124,35.574543,25.604778,46.446826,35.576969,25.696373,43.442101,35.631183,29.823816,46.676137,35.666835,29.150243,46.001003,35.676763,25.793385,37.634716,35.734339,26.464821,37.519931,35.787619,28.024093,37.739087,35.792583,27.361178,44.397907,35.933661,23.698045,37.612215,35.935984,22.493448,37.910291,36.116062,23.269218,37.491456,36.225024,30.695688,37.045201,36.245406,30.657699,36.963451,36.383184,22.581587,37.070124,36.491248,24.987363,36.572295,35.280925,39.051160,43.992048,35.310837,35.638244,45.157479,35.594348,35.109754,45.016447,35.886852,37.668932,44.504225,35.907360,39.383244,42.988788,36.000190,34.320948,42.752889,36.008141,35.195527,43.819255,36.021443,35.365367,42.955151,36.083103,35.421151,40.769601,36.126866,39.102216,42.918198,36.155765,36.576346,43.859307,36.195994,40.459789,43.206912,36.200588,37.142972,44.073165,36.256169,33.226008,38.989182,36.281465,36.404630,41.085255,36.364827,33.178263,37.579761,36.367142,38.459637,43.273118,36.427962,39.718539,41.508096,36.433988,32.546497,36.856570,36.479344,33.501021,38.263869,36.592677,32.201611,36.574194,36.694906,39.862536,41.159129,36.896251,41.330141,41.496179,37.239197,35.152512,36.511681,37.398513,38.150997,39.916378,37.439628,38.710235,40.127085,37.578038,38.810489,40.056806,37.612691,39.094156,40.118339,37.790496,36.134629,36.751521,37.872290,37.376504,38.858749};
			return value;
		}
		private double[] getCoordinate_9_21_point_223()
		{
			double[] value = {37.901445,42.201113,42.013776,38.133786,38.963985,39.203495,38.351680,38.547842,37.086542,38.434367,41.523714,39.313686,38.538359,41.802597,38.834032,38.669041,39.691262,36.574582,38.682619,42.262759,37.756480,38.778094,41.632145,37.350207,38.987931,41.354672,36.463708,35.232515,50.409623,46.375586,35.417721,48.533947,45.786314,35.501797,49.270719,42.942819,35.544506,47.453327,44.497082,35.571729,51.315919,46.531300,35.736869,47.774361,45.543253,35.748359,49.208098,42.780670,35.876517,48.376056,42.593405,35.890616,47.801834,42.628254,35.926707,47.181078,45.466597,36.035373,50.576091,44.348023,36.269073,46.430185,43.776689,36.636020,47.867063,42.354169,36.679010,43.207239,43.666207,36.787473,45.241918,43.097975,36.850150,44.906590,43.296461,36.876846,47.303876,42.159253,37.432521,45.943274,42.212649,37.466927,50.631274,44.290109,37.483979,45.034939,42.268750,37.549632,44.154719,42.402543,37.833930,44.273016,39.441747,37.862268,43.453758,40.304198,37.910094,43.703688,42.320801,37.916726,43.799737,42.308859,38.009295,43.886196,42.255874,38.057560,44.380464,42.214133,38.100645,43.973062,42.199729,38.130998,44.042503,38.856010,38.187680,52.568905,41.653207,38.284395,45.665164,38.083060,38.321443,49.117567,42.932602,38.343184,42.735593,39.120165,38.414352,47.098739,38.182060,38.532464,52.347291,42.157631,38.560056,46.076605,42.059798,38.599516,49.110784,42.933580,38.726990,46.363168,37.904201,38.821377,49.254586,42.976594,38.833998,48.029902,42.351055,38.888040,52.087529,42.667201,38.921513,46.053049,39.625274,38.929725,49.604126,39.185491,38.931599,45.152060,41.560893,39.021793,45.679287,41.590422,39.111536,45.420250,37.534349,39.136541,45.470763,40.287783,39.161040,48.952346,40.499988,39.165149,50.591433,43.579877,39.202668,51.223826,43.639713,39.240075,52.082044,43.478632,39.241732,46.131721,40.162354,39.251799,50.779661,43.310351,39.253268,50.668136,43.298948,39.272799,52.014701,43.904948,39.288514,47.685372,41.903264,39.306135,43.217314,36.888396,39.425047,50.263376,42.254360,39.482925,48.547671,40.945843,39.490651,48.347151,41.643620,39.526329,51.993373,39.660590,39.533290,52.918709,39.788545,39.660432,52.685044,39.570152,39.782356,49.022705,37.231829,39.910604,51.669212,39.364461,40.468274,52.171330,39.057311,40.546875,46.350619,37.205010,40.996474,52.399345,38.488067,41.021714,48.218426,37.014347,41.228241,49.399648,36.535605,41.283779,51.723145,36.872840,41.464618,52.921222,37.939676,42.047834,48.681992,36.566677,36.711675,63.376798,46.417565,36.810958,62.946475,46.318900,36.939815,60.385147,46.749915,37.836265,54.650887,44.452424,37.892579,53.908428,43.658522,37.988851,62.989577,45.773359,38.141015,54.160509,45.895159,38.194392,53.582933,43.412944,38.225750,52.999180,42.452954,38.289218,57.589236,46.589885,38.290199,53.297787,46.736825,38.297956,54.842931,41.617388,38.314805,54.967997,41.672807,38.426480,62.358186,45.744003,38.433980,55.416128,44.628457,38.434836,56.212641,46.186551,38.470368,54.279403,41.365479,38.546742,55.429785,43.400127};
			return value;
		}
		private double[] getCoordinate_9_21_point_224()
		{
			double[] value = {38.784394,57.626936,45.580599,38.788118,52.999723,45.458500,38.793813,54.926153,41.065402,38.907742,53.096019,44.809295,38.998050,59.312069,44.903156,39.332310,58.805035,44.628768,39.419703,61.476159,43.848156,39.447852,61.236369,43.720616,39.578097,57.746168,40.903516,39.692956,57.347279,44.338429,39.743203,61.391274,43.277522,39.856415,62.179042,42.912325,39.868176,57.705745,40.078100,39.878733,57.306944,40.058038,39.879214,55.842423,40.153002,39.965358,58.696605,44.170091,39.981800,54.231688,40.002029,40.091456,59.308158,39.830953,40.097105,53.989989,39.787252,40.105644,59.728059,39.891593,40.170852,54.319851,39.850023,40.227986,59.313822,39.577836,40.306622,61.076084,39.731796,40.389916,62.160771,39.372377,40.409885,59.972663,43.412093,40.423188,61.643986,39.935982,40.530404,60.395049,43.149669,40.610913,60.107331,42.922799,40.842841,54.680535,38.097244,41.069715,61.820750,40.855957,41.161249,54.594546,37.688688,41.168166,62.030630,41.720213,41.295868,62.838536,38.058411,41.351585,56.212291,37.231910,41.355045,56.271076,37.111614,41.433706,56.753768,36.745462,41.586472,55.755937,36.578184,41.678995,57.437470,36.992032,41.953740,55.327877,36.569840,42.045523,53.795569,36.811704,42.048420,54.427583,36.909257,42.068276,62.004990,37.803005,42.164197,63.228883,37.286754,42.364615,59.885550,37.115608,42.381012,63.096358,36.571201,42.439119,60.541616,37.601316,42.465345,62.107754,37.194598,42.474316,62.111775,36.889750,35.313988,70.911615,46.345442,35.791964,70.780574,45.878964,35.942013,69.060627,45.817036,36.287339,71.036092,45.347035,36.465124,71.862604,45.092667,36.523748,69.973337,45.438539,36.591216,71.801020,44.709062,36.618961,65.745972,45.711881,36.764429,67.630946,45.309449,36.845892,63.655853,46.031672,36.877179,65.103252,45.553524,36.889037,66.043908,45.349719,37.003902,73.325597,42.059023,37.083635,73.261489,41.892080,37.241885,73.109337,41.680115,37.342386,72.479386,42.438040,37.522404,69.538215,44.488923,37.601799,66.550466,45.107717,37.700496,66.738538,45.058722,37.782425,71.863306,41.237415,37.791807,69.186140,44.273074,37.997045,64.370178,45.356648,38.501705,70.500071,41.618519,38.699114,70.061441,40.478716,38.763685,63.504931,45.042129,38.875046,69.959667,41.090804,38.888316,66.566593,43.588635,39.037861,69.185254,40.211014,39.079670,68.044146,42.255471,39.081652,68.857532,39.808638,39.104333,72.651319,40.134288,39.117090,67.169001,42.342475,39.130361,73.255256,38.889187,39.136494,68.644568,39.767204,39.341688,68.555274,41.872690,39.353006,66.945111,42.233742,39.371047,73.556189,37.953556,39.461414,63.970506,43.847936,39.512446,70.786496,39.615124,39.521372,67.379833,39.216653,39.694032,68.515445,38.841708,39.824910,64.870619,42.293981,39.825826,66.945038,40.020092,39.846034,66.705258,39.893408,39.971590,71.179411,37.028068,40.101961,71.014420,38.067957,40.182925,64.539777,42.247040,40.217600,65.390320,38.535372,40.298559,64.818715,38.580875,40.321960,71.775976,36.602796,40.333233,66.989401,40.741327,40.341048,64.533675,39.619850};
			return value;
		}
		private double[] getCoordinate_9_21_point_225()
		{
			double[] value = {40.447588,69.756564,36.916552,40.570338,64.214751,38.395789,40.696402,68.432819,38.115049,40.931540,64.479850,38.065562,40.939220,66.184549,37.967746,41.102886,66.251743,37.849043,41.109483,64.674563,40.813722,41.420022,67.837493,36.797089,41.871980,66.274502,36.536072,42.017909,63.798840,37.390132,42.236131,64.427934,36.979077,35.207507,82.344893,38.600158,35.382394,80.204611,41.397704,35.505451,82.025123,37.594804,35.539320,82.829542,36.755038,35.545136,81.115760,39.398888,35.599718,80.915888,40.044072,35.629425,77.790270,42.107155,35.693120,79.947120,41.201072,35.723202,79.098465,41.737491,35.781609,76.293090,42.419973,36.252761,79.354381,39.616432,36.297927,78.343973,41.538245,36.429290,81.486225,36.979035,36.433069,78.765680,40.535470,36.437997,77.103556,41.955370,36.519951,81.608335,36.916518,36.892774,79.332038,38.661049,36.918088,77.559582,39.817374,37.008304,77.516458,39.654641,37.040103,79.193598,38.095580,37.208711,74.569037,41.687605,37.290981,76.585786,41.158824,37.429244,76.776299,39.495735,37.530211,81.037109,36.754525,37.856560,79.359692,37.149233,37.872580,78.071179,37.525737,38.281946,77.184109,38.137587,38.328833,75.107199,39.021149,38.456433,75.473539,38.807739,38.459668,79.606573,36.616134,38.566739,75.937139,38.684493,38.808358,76.221746,38.284725,39.039740,78.457410,36.434808,39.654587,75.372942,36.733215,40.404517,74.054863,36.946804,39.615858,-137.628778,49.543669,40.532080,-137.524147,50.230920,41.034644,-137.638355,49.682060,41.269820,-137.252951,51.792329,42.717682,-136.799199,54.433125,44.559948,-138.002986,48.188231,45.436310,-138.196787,47.260271,44.395909,-133.496581,46.754263,44.031950,-93.624692,54.717328,44.047193,-93.651614,54.847879,45.085750,-93.852886,53.381746,45.202665,-93.666440,51.933791,45.320114,-94.226592,55.775669,45.389683,-93.889345,52.745794,45.572393,-93.523818,50.402858,36.867128,-88.869002,55.232304,37.824568,-87.915298,52.924340,38.382590,-90.809755,55.860141,38.483914,-83.618330,49.567990,39.108240,-91.322677,55.804230,39.248373,-85.192230,49.533106,39.362162,-83.381353,48.045014,41.045851,-87.142657,47.519607,41.308158,-87.554793,47.376082,41.398143,-91.102668,51.327248,41.633752,-91.565009,51.787093,41.650338,-90.505072,49.896152,41.983499,-89.071200,47.594719,42.161283,-92.147212,52.775923,42.570185,-90.127585,47.033686,42.726213,-92.887851,53.852948,42.798388,-92.654620,52.711373,42.901994,-90.508230,47.841733,43.898402,-91.846940,47.120482,43.985531,-91.696330,48.057978,45.177099,-93.070158,49.507601,45.230877,-92.830346,47.504319,45.327041,-92.947895,48.899417,35.390182,-75.989557,54.640529,35.879564,-82.756676,52.576297,35.972180,-78.374595,53.661460,36.047549,-72.815854,54.736077,36.225974,-75.265063,53.902702,36.491704,-77.491801,53.256629,36.981904,-77.537340,52.646693,37.152171,-82.342982,50.727795,37.529907,-80.157864,51.402192,37.623487,-82.864418,50.177263,37.705160,-81.748707,50.450490,37.882159,-81.951950,50.116285,38.224575,-74.199041,52.027799,38.584952,-73.189026,52.149126,39.024086,-81.275913,49.314520,39.077952,-81.075533,49.315491};
			return value;
		}
		private double[] getCoordinate_9_21_point_226()
		{
			double[] value = {40.043782,-81.751276,47.808937,41.038373,-78.789455,47.498947,41.059380,-79.324205,47.337486,41.641734,-78.037357,46.926065,36.111756,-69.843431,56.912463,37.065181,-71.034378,55.019794,37.119963,-70.956962,55.009944,37.225977,-71.721613,54.220447,37.451873,-70.749362,54.841026,38.227937,-68.176664,56.905438,38.329759,-72.131185,52.872014,38.650138,-69.658509,54.652588,38.877598,-71.607204,52.671832,39.354038,-67.406753,56.985139,39.492461,-68.751281,54.936821,40.215125,-67.575947,56.123687,40.781863,-67.064738,56.337070,42.275099,-66.957335,55.360905,42.686948,-66.260809,55.934567,43.073897,-71.721331,47.975179,43.400349,-66.903945,54.425646,43.559440,-69.536969,49.762302,44.181669,-70.835541,46.816089,44.893890,-65.972533,54.860351,44.980982,-65.086855,56.346036,45.282829,-69.371878,47.721696,35.774982,-33.204042,47.161749,37.076796,-30.785291,47.305206,39.991280,-30.898422,47.675161,40.184132,-31.193774,47.497930,40.419956,-30.895162,47.622561,35.480625,-24.058936,52.375849,35.515022,-24.332809,52.168350,35.720693,-21.676840,54.083435,35.845878,-23.924092,52.406727,35.998855,-21.510414,54.015073,36.034560,-23.858937,52.427546,36.085953,-21.750173,53.847613,37.039109,-29.885313,47.882506,37.635785,-26.783503,50.138339,37.804917,-25.645784,51.096421,37.905460,-20.465285,53.431496,38.061167,-28.587593,48.689127,38.183872,-30.205848,47.407841,38.231487,-30.279563,47.360995,38.474732,-30.160195,47.503300,38.900863,-29.215620,48.549355,39.200497,-27.087312,50.033084,39.328088,-26.340967,50.285965,39.452613,-27.557312,49.743051,39.629900,-24.788329,50.731373,40.263662,-27.878856,49.206405,40.305671,-30.568324,47.847966,40.564862,-28.752894,48.655634,41.066411,-22.856644,51.562502,41.394028,-22.429724,51.982086,41.574837,-28.878960,48.021049,41.595869,-20.834285,53.905874,41.661254,-23.969319,50.950662,41.857038,-21.607603,53.205859,41.866292,-23.490106,51.356588,41.991708,-24.291418,50.790981,42.212395,-23.441855,51.681174,42.247135,-28.444720,48.076487,42.341952,-24.508118,50.862764,42.494967,-29.299299,47.514201,42.673690,-22.417178,56.529290,42.765828,-23.345690,52.355481,42.838552,-22.326956,56.873952,42.968874,-23.435605,52.623275,43.012083,-26.617403,49.494209,43.515531,-24.015535,54.875822,43.929257,-24.534530,53.800994,43.959718,-24.528800,55.739657,44.336544,-25.366341,53.342302,44.547594,-26.134874,53.937088,44.719180,-26.481915,54.218781,45.017301,-26.939878,52.870438,37.296313,-16.382350,56.666847,37.311786,-16.206475,56.870562,37.535260,-16.134880,57.046105,37.599888,-16.118352,57.113857,37.891926,-16.805421,56.231193,38.913749,-18.423713,54.728173,40.153461,-18.662844,54.792881,41.100618,-19.560649,55.524595,35.310604,-2.260542,47.437597,35.667943,-2.992644,47.062164,35.800472,-2.993779,46.889786,35.344722,31.610644,50.208083,35.395398,24.935959,47.031637,35.443317,30.939692,49.862468,35.266620,35.633807,53.219704,35.402945,36.491205,54.410998,35.466947,38.567452,54.735719,35.983803,40.357707,53.535031,36.001540,41.166102,53.872622,36.061512,40.509163,53.072409,36.092352,42.208934,48.067739,36.600806,42.194663,51.449047};
			return value;
		}
		private double[] getCoordinate_9_21_point_227()
		{
			double[] value = {35.180358,50.275429,49.343867,35.196303,51.598012,53.176378,35.211754,49.887901,53.401886,35.277605,51.910593,52.942232,35.300871,50.674709,48.090339,35.307150,50.290433,53.149122,35.307398,50.140268,47.115637,35.345193,43.274246,54.394314,35.388984,49.864528,47.734073,35.420386,51.081726,49.664036,35.452104,51.207984,49.101363,35.703060,50.949427,51.074281,35.733437,47.994669,47.708438,35.808488,46.597587,51.336334,35.819890,52.876034,51.836107,35.996589,51.662460,49.117970,36.160599,51.834123,48.554094,36.261181,51.582583,51.190180,36.275957,52.030920,51.643301,36.534617,52.033867,51.003870,36.604637,51.911484,50.356357,36.638335,52.300672,50.907247,36.900687,45.734062,47.188706,36.922376,45.191269,49.235744,37.062526,43.820268,50.552608,37.135430,43.656118,48.793287,37.228922,52.269322,47.602353,37.267243,44.286598,48.572874,37.276864,52.513682,48.663207,37.354059,44.326429,47.441306,37.836941,52.716168,47.417321,35.448861,60.801475,47.488662,35.742663,53.826234,50.402698,35.791952,60.359195,47.406340,35.840523,53.701533,50.782636,36.014788,55.842195,48.367047,36.113183,58.932542,47.496567,36.183198,56.009633,48.237432,36.185952,58.162654,47.633969,36.232446,60.083273,47.253105,36.395490,61.652890,47.043547,36.522140,62.415572,46.881891,36.590020,54.674483,48.465662,36.644626,57.261261,47.689072,37.491844,54.573088,47.229241,37.716068,57.927492,47.061243,37.751531,53.506547,48.050536,37.885431,54.234050,47.088543,36.473058,-135.612015,59.998845,45.389324,-136.347015,57.229854,35.873290,-134.740723,64.617459,36.414641,-134.691212,64.956963,36.483234,-134.306625,67.040573,40.468919,-134.921065,64.260887,41.267977,-134.777976,65.139205,42.735280,-135.008283,64.093785,43.987333,-129.553243,65.245629,44.499608,-129.545577,64.652115,44.500849,-131.958728,66.931099,44.557131,-131.619335,66.560281,44.873447,-129.086331,64.116909,45.336575,-129.241152,63.607279,45.570184,-130.524078,63.579943,41.271771,-119.445997,67.199772,43.424025,-118.961462,64.777087,43.554296,-118.149755,64.553555,44.067005,-115.018229,63.632843,39.673028,-104.384509,67.492138,41.316114,-107.359247,65.961144,43.748625,-110.275605,63.451002,43.881349,-109.577554,63.212183,44.271548,-104.997722,62.106553,44.803435,-112.623417,62.456020,45.294314,-109.179534,61.421626,39.623109,-96.198559,66.221099,40.061342,-94.896734,65.451532,40.858721,-102.093177,65.745422,41.240047,-93.432731,63.295720,41.312089,-93.382412,62.877266,42.198477,-96.887603,63.316483,42.388798,-101.042896,63.780637,42.804912,-93.496446,57.452240,42.819696,-93.735762,60.480764,42.869283,-98.262440,62.755405,43.120068,-98.026360,62.412256,43.241789,-93.799835,59.506684,44.313408,-94.100679,58.879454,44.695812,-94.240486,59.038047,44.827861,-94.343214,59.142623,45.200179,-100.268125,60.175025,35.533657,-91.689406,66.045078,35.854926,-89.936954,58.481416,37.975570,-91.924927,60.568305,38.051734,-92.644106,66.816422,39.713486,-93.088369,65.108245,40.061443,-93.094263,64.304994,40.625757,-93.109302,61.467598,40.777204,-92.933282,59.357738,41.014085,-93.004179,59.181153,41.103502,-93.175646,60.415608};
			return value;
		}
		private double[] getCoordinate_9_21_point_228()
		{
			double[] value = {35.541985,-62.720631,67.272501,36.441213,-64.850327,62.975221,37.081199,-64.089213,63.652780,37.993088,-62.841259,65.250604,38.876675,-63.383514,63.595427,39.170561,-62.793345,64.558374,39.888939,-65.375347,59.524303,42.270433,-65.687947,57.224061,42.370967,-63.186873,61.419670,42.605438,-62.891869,61.808170,38.976879,-61.858935,66.767629,41.606750,-20.332172,57.948905,41.941998,-20.653706,57.872359,42.665093,-21.802884,57.272464,43.647449,-20.824653,58.282792,44.000045,-20.891728,58.751013,44.318568,-20.765349,60.139818,44.437243,-21.460448,58.667553,44.953068,-21.438444,60.333622,45.022051,-22.952202,57.436736,45.501060,-21.651474,60.656346,35.634148,-14.675668,58.657886,35.804201,-15.934547,57.214081,35.941244,-11.944475,63.456974,35.970183,-12.735910,62.436528,36.066876,-10.673779,64.395056,36.896277,-12.806606,62.546050,36.913426,-14.595004,61.091114,37.135091,-15.970318,57.231330,37.624758,-13.453948,62.117066,37.658437,-16.108883,57.188080,38.303887,-16.063593,60.049145,38.360536,-12.756950,63.679389,38.390487,-16.092241,60.148442,38.599697,-12.287865,65.072031,38.902910,-16.224833,60.312243,39.351518,-12.459019,66.354202,39.370149,-12.403505,66.729894,39.456826,-13.600049,63.465315,39.478440,-17.104597,57.414147,40.113516,-15.724630,61.061337,40.166056,-13.297599,66.144137,40.230255,-15.579772,61.401031,40.433127,-16.603604,60.302835,40.764349,-14.469115,64.333897,41.200728,-15.922269,62.158230,41.215713,-19.641059,58.287200,41.246567,-14.444925,65.957821,41.924455,-18.468651,59.374744,41.948543,-16.578990,62.320613,42.138866,-15.035440,66.397655,42.254199,-15.323905,66.175746,42.308143,-16.092472,63.977093,42.738512,-18.811233,59.712826,43.138404,-19.274173,59.715122,43.173045,-16.548959,65.626654,43.433401,-16.899699,64.836867,43.599662,-15.980821,66.591565,44.257800,-17.440857,65.909914,44.325479,-19.283613,61.841529,44.399046,-17.573959,65.905090,44.759699,-19.735245,61.765790,44.809549,-16.838431,66.445353,45.206261,-18.767412,64.525465,45.476594,-16.361326,67.177481,35.219630,-8.437102,64.302282,35.241235,-8.871737,63.064961,35.251986,-8.520996,63.542434,35.718030,-8.947132,63.424251,35.902616,-9.087610,63.506853,35.964259,-8.712339,66.094642,36.293711,-8.708807,66.356649,36.449380,-8.910946,64.460605,36.491613,-8.671803,66.870396,36.626375,-8.986425,64.551830,36.683354,-8.658441,67.171945,36.791240,-8.763585,65.825637,37.025254,-9.210577,64.868368,37.992626,-9.588212,66.105867,38.033270,-9.362044,66.298111,35.936478,-126.069261,73.873563,36.521223,-128.869015,74.398880,37.050018,-130.116595,75.448077,37.113595,-132.824891,75.115926,37.421859,-133.949020,69.094386,37.430573,-130.062942,74.878304,37.683342,-129.615103,74.042765,38.254337,-133.228387,73.092423,38.381527,-129.418853,72.515050,39.328617,-133.161130,73.340468,39.664676,-129.883123,71.355422,39.984680,-131.321981,72.285422,40.351314,-133.557993,71.596035,40.405614,-133.470792,72.073649,40.519142,-128.265819,69.015441,40.524017,-125.781237,68.550791,40.776499,-130.135720,70.011371,42.101468,-131.325507,69.628542,42.714469,-130.795098,68.093351,43.461844,-134.265168,68.199188};
			return value;
		}
		private double[] getCoordinate_9_21_point_229()
		{
			double[] value = {44.121769,-134.385070,67.641190,35.835242,-124.581778,73.745031,36.403962,-114.702319,72.324801,36.558061,-120.891360,72.533042,37.496724,-120.930854,71.460436,38.037203,-117.338203,70.628352,38.135517,-114.548310,70.277679,38.766157,-115.478198,69.637428,38.881578,-116.653317,69.605442,39.898535,-118.125332,68.595229,35.963331,-104.026084,71.845269,36.155622,-105.091551,71.767938,37.776173,-106.749233,70.045961,39.858290,-112.956867,68.200629,39.933687,-113.131025,68.126931,36.693101,-97.270083,69.921763,36.852835,-99.211561,70.050742,37.475019,-102.315551,69.790247,37.799542,-101.701037,69.305153,38.316006,-96.956493,67.924028,35.411845,-91.949053,69.790777,35.753270,-92.154883,69.706807,35.926676,-92.399846,69.750012,35.556599,-59.559223,76.153965,36.066584,-61.759509,69.427668,36.406606,-60.388908,73.206926,36.865587,-59.610032,75.000948,37.224791,-59.199947,75.980818,37.335017,-59.112474,76.142956,37.366414,-60.549625,71.920368,38.345301,-59.143707,75.335761,38.427106,-59.661061,73.581786,38.818257,-58.884505,75.769150,38.883493,-58.347054,76.945921,39.447060,-59.929550,72.058006,41.405847,-60.137165,69.522007,43.981972,-58.920964,70.865003,44.875436,-20.231674,74.876728,37.017921,-13.317738,77.685843,37.484590,-13.720574,77.586967,37.746326,-12.817488,75.453452,37.971523,-9.874878,76.996955,38.284858,-14.165963,74.315166,38.351797,-10.702549,75.978065,38.680812,-11.720827,74.551331,38.838259,-13.028764,73.635669,38.929066,-11.520669,67.965932,39.259877,-10.286394,72.509830,39.387776,-10.459820,71.766413,39.424533,-10.362757,71.318496,39.442251,-9.980620,70.587223,39.512321,-11.054886,70.034029,39.517667,-15.431710,73.105211,39.691684,-13.667518,72.961135,39.853276,-11.144629,70.540957,39.924800,-16.303784,74.226720,40.182398,-11.382483,71.436448,40.648882,-16.012595,76.327460,41.052943,-13.428755,72.123613,41.077291,-11.953148,70.206295,41.418789,-17.320944,74.490804,41.425217,-12.902361,68.291526,41.696913,-17.393141,72.593911,42.565182,-17.700135,75.353270,42.776359,-17.198669,72.161104,43.014935,-13.146363,70.860028,43.196297,-19.164937,73.325498,43.647634,-17.580651,77.818426,43.886883,-18.277410,76.572915,44.041630,-18.098546,72.098449,44.061915,-19.829793,74.277224,44.229200,-15.044484,67.924898,44.322388,-19.407826,72.418722,44.629944,-18.858631,76.916386,45.039026,-18.972646,77.299221,45.189639,-19.984241,72.402681,35.226829,-6.814638,67.729470,35.240673,-6.900316,77.889467,35.318122,-7.037508,77.628454,35.321827,-7.234278,75.557889,35.395546,-6.739960,69.182575,35.497759,-7.452510,67.725315,35.648612,-7.583314,75.758355,35.762145,-6.677359,73.108403,35.890782,-6.742692,72.350775,35.913743,-6.760178,71.999161,35.948304,-7.310584,77.129714,36.995550,-8.357700,73.558177,37.378661,-7.562336,76.681875,37.404404,-7.737812,75.662947,37.407777,-7.710228,76.083045,37.664567,-7.658281,76.517146,37.992762,-8.765987,67.870983,38.069510,-7.890425,76.915772,38.104688,-8.683354,77.091534,38.551478,-8.437511,75.735764,38.566705,-9.145395,75.741946,38.714482,-8.515745,72.056455,38.832487,-8.930795,69.101821,38.946598,-8.876161,69.674826};
			return value;
		}
		private double[] getCoordinate_9_21_point_230()
		{
			double[] value = {39.003979,-8.968983,69.491180,39.215001,-8.801129,72.376888,39.283529,-9.599080,69.066512,39.423949,-9.391691,69.881612,39.438474,-9.240537,70.745370,35.414380,-57.560125,80.895261,35.806276,-57.016019,81.826863,35.995362,-56.564347,82.573797,36.717368,-54.873850,85.143226,36.826880,-57.814451,79.783201,37.477895,-52.841964,88.205609,37.813346,-57.478393,79.752930,39.950538,-52.216865,88.242467,39.963103,-57.274751,78.842370,40.078560,-53.688793,85.678776,40.270177,-52.338697,87.757618,40.737777,-55.514068,82.103106,41.313601,-56.640787,79.583795,41.702436,-52.119913,87.437051,41.824604,-56.033602,80.557231,42.563332,-53.396364,84.812194,42.709485,-54.014666,83.712457,43.888890,-52.785577,85.176737,43.963629,-52.032769,86.487576,44.000192,-53.573175,83.780907,44.078766,-54.538025,82.096636,44.906355,-53.230100,83.918937,44.804108,-50.705470,88.134988,35.325605,-12.558037,86.400545,35.354997,-12.261029,81.586783,35.937497,-12.781249,86.573540,35.971903,-11.547038,78.655905,36.470557,-12.649158,83.625224,36.549935,-12.851451,80.179681,36.751178,-12.907884,80.820094,36.883105,-12.868977,84.729483,36.898610,-12.997362,80.693335,37.087085,-12.957963,82.482469,37.649969,-13.637460,78.825289,37.769377,-13.288490,85.252677,38.205660,-14.109692,87.640009,38.280215,-13.470573,84.747262,38.629206,-13.538796,84.071404,38.713584,-13.574663,83.265537,39.544335,-13.994123,84.166897,40.967718,-15.304504,79.040496,41.020652,-15.625655,78.029068,41.341065,-15.083300,83.198616,42.095943,-15.726873,80.481930,42.167858,-15.982604,79.866513,42.938221,-16.638090,85.960623,42.962846,-16.771569,78.638788,43.528968,-16.926223,79.780388,44.249636,-17.291223,83.506334,44.800590,-17.619900,83.297346,45.283473,-18.352544,79.497486,45.464374,-18.427780,79.689231,45.565350,-18.399128,80.354171,36.647240,-8.241841,79.344782,37.402020,-7.577909,78.241181,39.314398,-52.276641,88.362554,40.477761,-51.983294,88.345461,35.363538,-50.313585,93.158783,35.754023,-46.671561,98.551729,35.824758,-50.822876,92.105056,36.250712,-50.611980,92.224473,36.559974,-46.832065,98.058594,36.677358,-49.136626,94.590186,37.276618,-50.889304,91.251047,37.332824,-48.125277,95.801197,37.641269,-50.078067,92.512764,37.679558,-50.260681,92.314852,38.170337,-47.206068,96.915772,38.433130,-48.158053,95.179946,38.883684,-45.862129,98.507229,39.089928,-47.664340,95.737420,39.393687,-47.594082,95.786316,40.061010,-46.358190,97.256139,40.169433,-47.008527,96.377047,40.721455,-45.362208,98.384150,41.431540,-51.396515,88.696954,41.606614,-49.010204,92.532326,41.936908,-50.285439,90.461291,42.147961,-49.680978,91.277732,42.265986,-48.826397,92.509020,42.341993,-49.316771,91.848683,42.767159,-45.463571,97.184638,43.018809,-49.190546,91.712093,43.236789,-48.794123,92.149379,43.630662,-48.077564,92.996560,43.659440,-44.746541,97.572589,43.663122,-48.842240,91.918589,45.014546,-49.378864,90.381773,45.043963,-45.656836,95.737546,45.050007,-46.448410,94.784562,45.431118,-49.350805,89.963708,45.570025,-31.687791,97.420684,42.628781,-21.309799,94.802478,42.728107,-21.851836,95.265490,43.063164,-20.379203,93.349237};
			return value;
		}
		private double[] getCoordinate_9_21_point_231()
		{
			double[] value = {43.442784,-28.668105,98.157378,43.926643,-29.465101,98.060530,44.094530,-23.670327,95.124229,44.183083,-20.216300,91.822048,44.207960,-29.533364,97.810315,45.181925,-20.693488,90.997510,45.237181,-23.946501,94.377497,45.292323,-20.412541,90.428258,45.329291,-23.474871,93.775546,35.784794,-15.657730,93.925459,36.355466,-18.106219,96.512372,36.381221,-17.729009,96.077829,36.503531,-14.378831,90.578615,36.629648,-16.262837,94.236634,36.653884,-14.833124,91.355464,36.982811,-17.755032,95.799789,36.993699,-16.103901,93.447610,37.013404,-19.537244,97.596698,37.281284,-16.640071,94.218229,37.607132,-15.220073,91.065754,37.856869,-15.279632,90.935989,38.548500,-16.663594,93.015631,39.129446,-15.055192,88.641640,39.626537,-17.054660,92.459475,39.952550,-17.025427,91.992435,40.878242,-19.824949,95.091806,41.090936,-17.400126,91.101085,41.725757,-18.996530,93.181226,42.955511,-19.026122,91.652212,43.131175,-17.983986,89.083209,44.732337,-20.070166,90.777371,35.331163,-46.461536,99.083146,36.180180,-43.926208,101.968874,37.767096,-42.899940,102.333001,38.014385,-44.487900,100.445728,38.517922,-42.476444,102.496129,38.647867,-44.290246,100.543301,39.628349,-42.209360,102.228566,39.765223,-44.038350,100.345235,39.985807,-42.784790,101.594473,41.953441,-41.242908,101.579032,43.175469,-42.935943,99.772366,43.723698,-42.577026,99.686485,35.187103,-40.444404,105.276942,35.501505,-32.475195,104.917500,35.584303,-32.516653,104.885650,36.667828,-34.423507,104.895332,37.109609,-30.663253,103.621376,37.547656,-40.406098,104.310798,38.692560,-39.786211,103.976859,39.524309,-33.995751,103.100005,39.883599,-32.973742,102.580149,41.170505,-34.233990,102.064199,41.326610,-40.731845,102.133377,41.524331,-33.591780,101.628803,41.666255,-35.433374,101.946254,43.224102,-33.984467,100.476095,43.234846,-36.993281,101.087320,43.338737,-36.305915,100.898496,44.367187,-35.756676,99.996504,44.402493,-34.297907,99.524577,35.408531,-29.961738,104.168659,36.376387,-24.774724,101.609990,36.895825,-26.715644,102.235247,37.250913,-23.582684,100.435652,37.275674,-29.735073,103.132586,37.648644,-23.154274,100.044760,38.468612,-23.273291,99.552077,38.626235,-24.661794,100.236356,38.757270,-27.456073,101.429395,39.358270,-27.720376,101.061621,39.451518,-30.614564,102.043033,39.791896,-28.108310,100.884791,40.048492,-29.800344,101.288666,45.834060,38.962078,-16.669541,46.160851,39.033196,-17.447532,46.602438,41.924138,-19.667381,46.641378,41.458151,-19.656656,46.652863,39.914395,-19.124830,46.673982,39.211957,-17.815187,47.095761,40.578852,-19.160402,47.119714,40.482625,-19.170251,47.318924,39.294077,-17.517568,47.378822,39.256652,-17.096171,48.020377,40.901498,-18.541225,48.106448,41.504136,-18.183740,49.372763,39.787869,-16.175169,49.877259,40.783189,-16.707856,49.946886,41.808794,-17.032475,50.863518,42.216791,-16.169381,46.789100,48.020104,-18.298251,46.838723,46.820965,-18.389025,47.595551,48.433329,-17.419828,47.698260,49.302957,-17.085361,47.746345,48.354927,-17.283770,48.143175,45.776486,-17.058927,48.910045,42.574077,-17.416414,49.024939,42.789176,-17.173018,49.513121,45.876624,-15.599766,50.226494,42.639069,-16.660441};
			return value;
		}
		private double[] getCoordinate_9_21_point_232()
		{
			double[] value = {46.154360,62.126538,-18.132472,46.703650,58.903667,-18.157909,46.832699,53.749411,-18.303292,47.328468,58.539331,-17.363286,48.283001,55.064970,-16.255606,46.361478,63.726728,-17.388801,45.943881,38.849364,-10.199726,46.259262,37.573073,-8.404343,46.386307,37.497692,-8.236213,46.511354,38.935998,-11.680733,46.597487,36.438550,-7.602483,46.603193,36.218721,-6.113298,46.814564,37.927452,-7.897085,46.975018,36.726526,-7.496976,47.060907,38.165177,-7.957825,47.117898,38.278391,-8.212917,47.158005,37.523345,-7.130474,47.169309,36.158221,-6.207377,47.323777,36.216976,-6.354998,47.418292,36.236826,-6.322801,47.552128,38.334535,-9.468098,47.754920,39.019033,-12.258093,48.292170,39.148525,-15.130583,48.745230,39.264871,-15.490891,49.002524,39.213065,-14.713064,49.089743,38.710634,-10.565409,49.212603,37.745589,-7.687774,49.337420,39.339705,-15.314987,49.935831,39.558716,-15.076701,49.951702,39.116829,-10.704867,50.068647,39.226227,-10.680544,50.229934,39.454589,-12.844491,50.349956,37.788005,-7.598058,50.485528,39.103178,-9.982686,50.503844,37.507096,-6.525680,50.592400,37.770630,-7.334174,50.873965,39.940805,-14.273896,50.981114,39.934057,-10.051347,51.124353,40.035337,-9.975950,51.198032,41.339319,-15.422204,51.250818,41.745072,-15.517409,51.340962,40.569091,-14.530572,51.466878,40.179312,-9.624509,51.624788,39.988017,-12.178456,51.757131,40.126807,-12.326759,52.276089,40.577453,-11.927791,52.380530,38.751152,-5.974011,52.435351,42.024085,-13.549172,52.461393,40.900011,-12.078743,52.669143,40.234344,-7.727425,52.741516,41.664642,-11.864887,52.917264,40.618660,-8.458198,53.036476,41.813845,-11.140408,53.175358,41.043646,-9.823398,53.412092,40.268040,-6.583995,53.481742,40.789566,-8.354320,53.547185,42.173254,-10.023540,53.660560,41.706332,-9.026041,54.021065,39.993730,-5.281346,54.472208,41.703841,-6.762914,48.425587,51.029841,-15.415217,49.955505,52.448684,-12.103983,49.999727,49.828375,-13.414058,50.406632,50.457592,-12.246327,50.934544,51.853161,-9.954849,51.146116,52.052325,-9.161838,51.156813,43.774288,-15.427523,51.228794,48.128933,-12.330529,51.533782,44.083213,-14.860290,51.633971,50.469308,-9.467341,52.206587,42.795231,-14.079025,52.376143,43.158082,-13.792770,52.586852,44.188989,-12.947508,52.706390,45.860782,-10.997901,52.721007,45.676043,-10.968198,52.758472,49.303358,-6.860719,52.935293,49.349470,-5.415321,52.989279,45.603174,-10.425421,53.004691,45.713268,-10.351131,53.147195,45.350130,-10.320136,53.170097,45.230355,-10.503951,53.287372,43.931495,-10.887169,53.316980,48.462382,-6.556016,53.344478,45.694643,-9.538542,53.469223,45.110452,-9.661898,53.611997,43.591924,-9.934352,53.628442,47.777761,-6.506809,53.646636,45.484811,-8.176639,53.737189,44.086190,-9.612405,53.859237,45.859326,-7.749851,53.897048,47.143052,-6.223398,53.899941,43.426400,-9.183484,54.063965,46.178171,-7.029901,54.124808,46.807906,-5.451644,54.199054,44.800654,-6.745575,54.378372,44.369142,-5.518208,54.434566,44.200496,-5.253476,54.645902,43.355601,-5.793278,54.650792,43.851178,-5.713349,54.679861,42.585133,-5.892330};
			return value;
		}
		private double[] getCoordinate_9_21_point_233()
		{
			double[] value = {54.726287,43.518496,-5.311992,48.863134,57.428181,-15.101555,49.197214,62.731844,-12.772626,49.272657,55.803747,-14.499249,49.466364,59.375967,-13.644583,49.793028,63.331246,-10.888368,49.823432,61.475348,-11.942467,50.127091,57.561809,-12.638374,50.787731,54.638361,-10.203469,51.125167,61.333465,-7.761382,51.262783,53.798184,-8.022328,51.263466,53.065538,-8.030947,51.408456,60.649393,-6.946319,51.585260,60.470920,-6.042766,51.607475,60.240065,-6.098702,45.795407,72.429529,-11.190017,46.694284,72.261392,-9.402203,47.188311,69.702234,-11.454042,47.531573,73.132871,-5.691524,47.760695,71.933716,-6.828011,47.872618,71.770920,-6.727838,48.077239,68.856933,-10.234554,48.285696,66.440792,-12.334040,48.484650,66.116235,-12.126718,48.879743,69.607340,-6.691127,45.671551,77.289916,-5.172289,46.565632,75.366195,-5.350995,45.838795,30.181102,-2.092948,45.874687,29.887539,-1.039803,45.996397,29.292329,2.599346,46.353630,24.979546,4.044312,46.369501,31.078896,3.484419,46.377204,31.402459,-1.819150,46.389682,31.162065,-1.878286,46.452146,32.014082,2.969840,46.535541,31.304720,-1.440761,46.640369,31.136358,0.510552,46.795529,31.739625,-0.408464,45.824599,34.755424,0.237570,45.925314,35.464493,-2.805772,45.997919,35.026127,-0.444391,46.040623,32.968626,-0.296129,46.409966,32.658864,-0.296152,46.442425,35.162484,-0.064735,46.503934,34.313383,1.606423,46.616651,32.638721,-0.069758,46.621793,32.807222,4.504078,46.634876,35.121007,0.378247,46.766454,33.813075,4.605912,46.858400,33.060577,1.074999,46.866503,32.244527,-0.077762,46.872565,33.215677,2.742561,46.977268,34.970025,0.614501,47.010540,34.105272,4.809826,47.518074,34.423973,3.864503,47.687041,34.573803,3.049467,48.263572,35.259090,-1.185400,48.317055,35.493638,4.018122,48.350868,35.049456,0.362789,48.438456,35.514387,-2.366413,48.492446,35.700558,2.597622,48.691701,35.456804,-0.360528,48.724852,35.724720,-0.203406,48.777377,36.065979,-0.281405,48.790167,35.972015,-2.826374,48.825808,37.474848,-4.328047,48.846684,36.166032,-1.796187,48.875669,36.500277,-0.504636,48.926796,37.268227,-3.544225,49.052612,37.666837,-5.033150,49.120301,36.575205,0.111325,50.225091,36.745900,1.083506,50.257111,37.235944,-3.922136,50.633743,36.892737,-0.718490,50.696763,37.274044,-5.028866,51.063606,37.204831,-4.239355,51.115507,37.291723,-4.956892,51.127439,37.154268,-3.677787,51.473163,38.044894,4.969555,51.659202,37.410913,-1.065257,51.730059,37.641076,-4.921872,51.775773,37.607989,-4.499958,52.413080,38.594053,3.548827,52.612808,38.286323,-3.920103,52.835613,39.019164,3.470695,52.891295,38.876363,2.593827,52.922509,38.363043,-0.873350,52.934691,39.729755,5.144314,53.359517,38.694736,-1.338825,53.361643,39.317052,-4.435812,53.401217,40.653553,4.278133,53.434224,39.268588,0.997805,53.503575,40.388030,3.742771,53.521507,38.898845,-2.568430,53.694275,39.163146,-3.125337,53.700172,40.927917,3.242604,53.745942,42.249455,3.315038,53.980946,39.324858,-3.027481,54.015556,41.011911,1.544374,54.044372,39.416187,-1.497590};
			return value;
		}
		private double[] getCoordinate_9_21_point_234()
		{
			double[] value = {54.389922,41.907475,0.013886,54.418331,39.826417,-2.363793,54.430801,41.679781,-1.326949,54.534576,40.849437,-2.684219,54.551583,40.429086,-2.751365,54.597952,40.986061,-4.446617,54.613029,40.921078,-4.024932,54.644372,41.970230,-3.864292,54.675493,41.401787,-4.089787,51.740248,50.593733,3.508298,51.787141,52.862953,-2.053738,51.790857,51.323287,1.723181,51.797491,50.187829,3.821147,52.164120,49.343103,3.455834,52.185166,50.815038,-2.556283,52.653243,47.074214,4.123493,53.005186,47.411341,2.657889,53.023327,43.391537,5.062116,53.078130,47.321027,2.373225,53.582963,48.389728,-4.452343,53.646097,46.602404,1.019873,53.772434,47.915491,-2.906280,53.795523,42.941445,2.978084,53.830877,46.396320,0.358754,54.034022,44.033300,1.697215,54.378475,46.243228,-4.983957,54.445276,45.892760,-2.335640,54.456687,44.849685,-4.314810,54.599001,45.298634,-2.340279,51.088109,56.853626,4.672528,51.336062,55.138761,3.668241,51.578710,62.085841,2.028386,51.602965,60.986794,2.365643,51.606612,54.147675,2.005487,51.631589,62.458428,-3.384701,51.742401,62.439062,-2.022425,51.751131,54.116727,-4.062964,51.785880,59.804696,1.537301,51.803100,60.160207,1.368133,51.937208,55.581199,-3.954457,52.096619,57.119185,-2.216388,48.757115,71.544537,-4.018826,48.869699,73.523894,1.383166,49.055864,73.059285,1.321280,49.758347,70.047897,-1.402210,49.761265,70.758937,4.735237,49.788296,70.585828,5.197158,49.909041,70.314160,4.469276,50.066612,67.428341,-4.994461,50.276926,69.316785,2.054298,50.841040,66.848800,-0.465431,51.067098,66.128043,0.742149,45.714024,79.461375,-0.386481,46.225948,79.570641,3.062353,46.651926,76.750447,-2.633777,46.671623,78.017599,0.628780,48.218793,74.461534,-0.119825,45.791255,-10.695425,8.264052,45.793054,-11.061691,8.683880,45.793078,-10.188004,8.893098,45.797657,-10.241144,8.694856,45.706813,20.493937,14.733267,45.870765,17.800423,7.225110,45.961476,18.705001,6.620517,45.975792,18.740582,6.103601,46.061673,19.426856,6.374230,46.068661,19.115702,7.279698,46.071291,19.846624,6.439363,46.474439,22.227275,7.932062,46.707596,22.698934,8.453315,47.076235,23.348981,8.898874,48.004168,28.378730,6.378567,48.235680,25.689469,9.597219,48.583938,26.175356,14.044175,48.998221,27.682055,12.976449,47.142472,33.446626,5.840546,47.269219,32.724730,6.103760,47.335457,32.256862,6.174579,47.350635,33.398449,6.630458,47.585619,32.730711,7.115185,47.991490,35.629657,8.331328,48.263467,35.422632,9.779787,48.433264,33.674630,9.990608,48.667888,35.754063,11.730255,48.769229,34.434473,15.100610,48.934395,33.240990,14.556153,48.986880,36.773422,12.677772,49.019578,36.839615,13.160652,49.110688,32.192380,13.821086,49.171512,36.881052,11.057893,49.728736,39.250171,14.483774,49.936179,40.870024,14.237818,50.256741,38.499053,12.101138,50.619431,39.078951,11.699894,50.751479,38.126201,10.152359,50.839643,38.025107,9.280074,50.884251,37.852827,8.121219,52.726720,39.400025,5.319266,48.293660,51.120306,13.163785,48.661058,46.660455,14.385855};
			return value;
		}
		private double[] getCoordinate_9_21_point_235()
		{
			double[] value = {48.734986,48.663753,13.007646,49.372796,43.459497,14.888206,49.528604,51.802363,9.769268,49.722807,52.920961,8.991940,49.844851,49.629017,9.813628,49.905694,51.731141,8.891539,50.037487,48.903724,9.717597,50.474084,51.473895,7.426226,51.517903,44.894341,8.306647,52.064650,47.279298,5.744520,52.217019,46.709126,5.509590,48.038983,53.927255,13.424029,48.305695,63.108821,13.099046,48.512528,59.403176,12.073025,49.190396,55.143245,10.198719,49.894512,53.585274,8.404723,49.938919,57.868597,8.064047,50.469225,60.104310,6.462982,47.431014,71.706877,15.356469,47.502164,71.854712,15.144045,47.507051,70.969261,15.535990,47.736159,71.262980,14.631961,47.926628,73.784168,14.676205,48.080188,70.881108,14.116409,48.112473,71.632126,13.560974,48.159026,71.780820,13.340402,48.479214,72.045665,12.270948,49.000526,72.738455,8.183113,49.188217,66.693622,10.009215,49.213592,66.184565,9.919297,49.471092,71.606854,5.488411,50.100548,68.386786,5.753438,50.382584,66.008220,5.781916,50.459528,64.833680,5.849267,50.617874,64.169085,5.628823,45.759658,80.894437,5.947238,45.774335,81.524268,11.005779,46.318894,81.834220,15.070047,46.605712,79.893004,9.131870,46.714475,79.776883,14.801769,46.721348,79.279458,6.797521,46.740742,80.435166,13.098043,47.173306,78.644938,10.046297,47.180288,78.593709,8.459928,47.220575,78.497456,10.158677,47.330589,79.057842,15.273963,47.419810,78.578266,14.430829,47.456756,78.366762,13.613509,48.059551,74.360097,13.969658,48.119818,77.282117,14.632386,48.131510,77.302025,13.257468,48.154354,76.689644,10.915534,48.189756,77.205923,13.950908,48.289420,74.857528,12.573194,48.356295,76.602662,12.719965,48.445742,76.379094,13.399803,48.461740,75.996822,14.834308,48.515904,75.235804,15.439034,48.517843,75.845964,13.889198,46.423663,-72.786599,25.914164,45.709408,-69.031645,19.319867,45.822390,-70.070431,18.883328,46.211979,-70.438921,19.307999,46.326637,-70.290501,19.368218,46.879124,-69.271189,19.987390,46.917439,-63.584800,24.984841,47.440119,-64.616585,23.985932,47.469457,-66.905560,21.750278,48.116102,-67.579391,21.804700,48.422985,-70.184288,22.337955,48.478822,-63.886005,24.995022,48.693634,-69.139867,22.463840,48.769390,-71.007922,24.369960,48.929120,-71.231406,25.616643,48.991141,-68.819101,22.820743,49.185038,-70.802435,25.013035,49.399637,-64.194005,25.142883,49.431778,-64.640645,24.816174,49.559007,-69.684074,24.138825,49.573240,-69.264124,23.896465,49.635443,-64.033073,25.420233,49.717945,-65.431184,24.582884,49.739534,-67.093488,23.933861,49.798280,-68.790334,24.114697,49.837236,-68.398524,24.092976,50.264809,-67.266858,24.798867,50.843902,-67.390107,25.648063,45.711960,-61.791754,25.276427,45.772928,-54.443227,25.810699,45.981245,-56.220683,25.193591,45.728225,21.312233,16.982401,45.682386,23.719377,19.958644,45.699885,26.516558,21.994395,45.952850,22.385948,18.028109,46.129575,27.900775,21.952696,46.616900,24.155915,18.627033,46.945777,26.824500,19.972773,47.110773,31.862995,21.001712,47.176992,27.501841,19.846991,47.848408,27.197248,18.301010};
			return value;
		}
		private double[] getCoordinate_9_21_point_236()
		{
			double[] value = {47.849376,26.577191,18.010948,48.163489,29.416728,18.471189,49.016026,30.383879,16.132128,45.748837,38.886078,23.932503,46.125755,34.642838,23.108020,46.475726,42.525371,21.522197,46.710950,37.674424,22.244466,47.218952,39.627157,21.140584,48.184553,34.197510,18.133739,49.111737,39.873699,16.481992,45.959130,46.574154,20.491515,46.009383,52.909856,23.622039,46.032448,50.886779,24.622453,46.049756,50.339919,19.155658,46.146693,52.346222,24.291020,46.306997,48.744787,18.831681,46.358152,50.115878,25.934900,46.491664,50.538550,25.377912,46.545614,43.125877,21.045721,46.584525,50.866722,25.461612,47.047737,43.701182,19.834274,48.798502,43.555043,16.350160,49.179630,42.946370,15.789251,45.641817,57.602779,21.005066,45.989069,59.354797,22.405785,46.110365,60.669209,22.773516,46.155215,58.607349,22.623987,46.185916,60.716727,23.852584,46.198608,60.630452,23.784162,46.243258,57.421746,22.495194,46.250194,56.407953,19.091800,46.264279,61.798306,23.497705,46.324359,55.255081,22.976687,46.369517,59.956147,23.718817,46.393343,56.320451,18.496626,46.479319,58.265183,23.645015,46.654390,57.163395,17.688695,46.682383,62.291604,17.916907,46.762899,60.524120,21.615192,46.771326,56.747264,17.003706,46.812220,60.413419,25.978657,46.823570,62.031959,17.306534,46.894952,60.127221,21.030611,46.985079,53.654328,16.359986,46.991151,58.918649,25.886368,47.111895,62.359597,22.684513,47.124964,54.732899,25.350897,47.174635,61.188417,19.946085,47.188581,61.945217,19.807801,47.191885,56.059728,15.756387,47.245744,55.004375,15.695991,47.300487,63.085601,19.345255,47.303866,62.692833,22.613280,47.330349,60.647001,19.492402,47.332693,62.629141,19.108335,47.452182,62.839343,22.428722,45.845895,71.896222,22.612748,45.945825,71.444856,24.682761,46.001527,71.338145,21.971684,46.081346,70.499792,25.551240,46.089370,71.181979,21.473072,46.164139,72.265776,20.037437,46.195526,63.863668,25.244624,46.211595,71.117810,22.254087,46.227797,69.727853,23.960270,46.284126,68.947015,25.945450,46.298111,70.905803,22.070507,46.298766,70.004151,23.562261,46.498707,68.577841,19.858026,46.523223,68.446506,25.414265,46.590621,68.475176,22.811405,46.594215,70.353189,21.895488,46.665078,70.146355,21.715757,46.674227,68.653451,20.196013,46.697848,64.132003,17.953191,46.701701,68.955388,22.433792,46.714192,63.441201,18.068870,46.844636,68.093591,19.925153,46.845146,72.291126,17.913466,46.855725,64.262685,24.169699,46.861096,69.686468,21.577419,46.947332,66.214855,18.963874,46.959463,68.119903,18.243149,47.047933,69.442785,18.004631,47.096021,64.403396,20.106511,47.162501,70.708183,17.010981,47.180021,65.917019,21.940670,47.212376,67.935862,21.085371,47.218792,68.236386,21.090201,47.228196,71.151272,16.012952,47.237904,66.860269,23.340215,47.249649,67.127538,20.735362,47.282418,65.453572,16.743953,47.287321,63.935934,19.005395,47.289561,65.955973,23.628554,47.298060,64.942761,16.703398,47.317230,67.607060,20.672566,47.344109,67.008564,20.360152,47.442321,65.291112,22.080288,47.496783,64.640812,21.756776};
			return value;
		}
		private double[] getCoordinate_9_21_point_237()
		{
			double[] value = {47.594911,72.889535,16.005310,47.657263,67.709943,15.667763,45.676892,78.371758,23.568746,45.821368,81.814302,17.947253,46.080399,81.825959,16.866581,46.085206,80.013683,20.873609,46.134622,76.410483,23.333724,46.136688,81.976159,16.708845,46.245331,74.289883,21.388453,46.285905,82.007814,15.871766,46.368601,78.489511,22.327795,46.412376,81.714609,19.014203,46.473538,75.874445,22.735214,46.731780,80.841380,18.867397,46.761787,78.306730,21.731341,46.943176,78.248880,19.172639,46.949581,78.586034,17.294788,47.151799,74.492077,20.693282,47.161161,76.021642,20.800297,47.167351,79.435870,15.707975,47.308524,77.716630,16.268153,47.711339,77.254997,19.625891,47.867517,75.935285,18.389352,47.924610,77.254354,16.521124,48.076990,77.113799,17.252072,48.105508,75.921392,17.445123,48.138891,75.181810,18.726977,48.363232,74.604218,17.193361,48.421181,74.995947,17.137075,46.423034,-72.612158,28.884599,45.769900,-71.874296,35.760933,47.562868,-71.177380,35.650210,47.613048,-72.160844,27.841045,47.646678,-71.456566,33.475473,47.927390,-71.935312,29.605254,48.783552,-62.088722,27.062580,49.356727,-70.846426,33.876528,49.480911,-71.220278,29.710740,49.509591,-70.875205,26.346429,50.242881,-70.504214,34.121586,50.323933,-62.219503,27.412214,50.377836,-63.478564,26.454262,50.774330,-69.029320,26.146531,50.777112,-70.195983,29.296840,50.855274,-64.475985,26.429836,51.113589,-65.047302,26.532454,51.241183,-70.224367,32.594515,51.281021,-68.822922,27.101679,51.331176,-69.876773,29.780164,51.407752,-66.838275,26.790233,51.498707,-63.999118,27.623405,51.765131,-65.617679,27.492471,51.922591,-64.223519,28.171078,51.977591,-66.889793,27.737703,52.155748,-65.066778,28.143186,52.157001,-65.559578,28.038874,52.260588,-69.591075,33.422644,52.281070,-64.859245,28.454245,52.454459,-64.305712,28.971676,52.534779,-63.326607,29.389705,52.665435,-62.904864,29.780020,52.765100,-65.569711,29.272938,53.044814,-66.241624,29.697789,53.100747,-68.960875,33.462047,53.186093,-65.675144,29.895686,53.398677,-63.257737,30.925393,53.585162,-64.130704,30.876343,53.621980,-65.273448,30.818111,54.211173,-65.238953,32.137328,55.653118,-66.051872,36.310368,45.831098,-53.765892,26.231562,45.926647,-52.033352,27.383199,46.479505,-59.486791,26.673051,46.840904,-57.598932,27.067619,46.885431,-55.360601,27.306472,46.914230,-55.724477,27.360372,47.160584,-51.692343,29.430295,47.290776,-59.670560,28.427694,48.004161,-59.786107,29.031669,48.122977,-59.786474,29.106527,48.150815,-55.883143,31.059387,48.245342,-56.530391,31.227581,48.286052,-53.575643,31.479195,48.290887,-58.103833,30.527195,48.526710,-58.417551,30.497369,48.819218,-56.551429,32.231469,48.939169,-54.124427,34.189078,48.982363,-56.477771,32.473726,49.059517,-55.066236,33.729734,49.167990,-54.262760,34.582696,49.293726,-52.894216,36.066039,49.342016,-53.791463,35.354102,49.374461,-54.310335,34.860564,49.421949,-54.686898,34.529383,49.594946,-55.599050,33.827255,49.840728,-54.908593,34.727580,50.212387,-53.883151,35.972086,50.712689,-61.456888,28.214509,51.018805,-61.549434,28.344775,52.068433,-61.175035,29.779494};
			return value;
		}
		private double[] getCoordinate_9_21_point_238()
		{
			double[] value = {52.510363,-57.788234,32.367292,52.732374,-58.657322,31.935563,53.495000,-55.714133,34.817918,53.631575,-56.287247,34.676388,53.667877,-54.854095,35.742783,54.503480,-58.178239,35.203687,54.504364,-58.829857,34.760378,54.588113,-57.595795,35.777748,55.007097,-60.687245,34.815444,45.702157,-47.288247,31.262543,45.704291,-48.117614,30.405364,46.523796,-48.056178,31.323665,46.575846,-51.270476,28.820967,47.037089,-49.539940,30.721634,47.654263,-48.304272,32.961282,47.863320,-48.733999,33.115802,47.961771,-50.075284,32.477236,48.245738,-50.976071,32.771914,45.646066,48.890733,26.826383,45.682759,51.312239,30.975692,45.766503,51.941161,31.062888,45.999974,50.768845,27.689404,46.001176,48.546194,30.416015,46.125159,48.811578,30.210455,46.184752,49.386738,30.120511,46.236024,52.903956,26.865284,46.296157,48.845593,29.777012,46.336346,51.497797,29.740827,46.419989,49.625963,29.708025,46.490963,51.767168,29.532121,46.624041,52.101727,28.075843,46.657081,50.467685,29.202572,46.772863,51.372897,28.594814,45.687345,56.609623,30.612608,45.794494,56.496918,30.266668,45.796558,55.580000,30.589459,45.826879,54.855894,30.818595,45.877145,54.470700,30.234107,46.039438,55.494631,29.683112,46.066620,63.403986,26.022660,46.200859,54.951966,29.536600,46.267098,60.435024,29.442104,46.291491,63.056943,26.804721,46.429324,56.502333,27.111561,46.437384,56.610638,27.024240,46.579155,53.280066,29.377032,46.592771,55.578523,26.556575,45.800584,64.709176,28.254508,46.165104,68.567869,26.261120,46.282210,68.297154,26.026876,46.285088,68.666591,26.002843,45.740829,-124.986377,46.020413,47.603697,-119.152910,46.208171,45.720491,-107.878351,41.559976,45.723184,-106.725623,41.252061,45.875326,-108.209444,41.767045,46.033361,-108.435678,41.886890,46.184665,-107.337419,41.850495,46.414495,-107.782948,41.939250,46.506743,-111.478025,43.363830,46.588072,-107.612585,41.939471,46.728374,-105.504357,41.934105,46.735095,-106.309255,41.991482,46.802005,-110.178986,41.875199,46.825322,-104.784096,41.850905,47.076871,-104.268710,41.977001,47.105257,-105.478981,41.992355,47.194051,-110.420928,42.862431,47.365594,-109.582921,42.159906,47.767458,-105.987606,41.699570,47.883453,-110.466476,44.358824,48.251485,-105.838140,41.789354,48.285978,-106.922752,42.959418,48.413821,-110.076616,44.734333,48.473512,-109.387096,44.372734,48.541007,-106.121432,42.828398,48.575206,-106.106046,42.255289,48.714618,-105.967268,43.363557,48.750937,-109.788231,44.883909,48.847722,-105.307162,42.655791,49.061464,-109.125502,43.729541,49.104983,-105.043921,42.652099,49.518571,-109.130822,44.752282,49.688342,-110.286433,45.783547,49.884242,-109.120775,44.579985,49.991356,-105.136194,44.566364,50.073192,-105.630897,44.937493,50.154854,-105.297619,45.159836,50.202375,-110.394260,46.231826,50.486222,-108.149270,44.445171,50.535578,-106.082573,45.839239,50.549496,-109.985295,45.414029,50.718364,-109.625294,45.280146,50.963346,-108.300102,46.724974,50.982367,-108.398554,45.456177,51.021328,-107.926702,46.739502,46.003583,-97.485119,40.530996,46.579297,-95.106968,45.672190,47.391359,-96.405111,43.941380,47.922590,-102.807460,41.948597};
			return value;
		}
		private double[] getCoordinate_9_21_point_239()
		{
			double[] value = {48.528792,-97.619718,42.307201,49.018197,-102.660160,42.143296,49.045019,-101.215390,43.275906,49.301695,-97.314698,43.107259,49.485024,-102.673829,42.831862,49.510108,-103.112665,42.295714,49.664645,-102.979415,44.201379,49.813174,-102.835085,44.362410,49.817541,-103.559668,43.135244,49.873162,-103.742856,44.614904,52.558417,-97.961750,46.022782,45.701650,-71.772616,36.516601,45.774700,-70.143590,45.316254,45.790568,-69.758674,45.929696,46.009282,-70.923420,40.392163,46.058478,-71.062754,39.559530,46.187571,-69.888116,45.252003,46.308074,-69.729933,45.441819,46.941991,-69.704642,44.181296,47.132768,-70.210052,41.141610,47.149557,-70.225561,41.049552,47.172770,-70.262408,40.861372,47.806677,-70.572683,38.357695,47.847229,-70.964483,36.536483,48.588057,-69.042073,43.504486,50.086057,-69.162149,40.322670,50.101070,-69.804846,37.873986,50.388402,-69.739523,37.526869,51.234669,-69.155286,38.621812,51.783555,-69.451410,36.443667,52.121783,-68.021184,41.391466,53.298422,-68.682114,36.792007,53.369028,-68.415664,37.345316,53.382234,-68.648844,36.751247,53.642191,-66.246198,44.467532,53.651080,-67.343576,40.900857,54.238621,-66.865297,41.458199,54.396346,-65.097447,46.683438,55.470739,-66.632639,36.502594,55.589399,-64.432294,46.544934,55.903135,-66.515719,38.658376,55.930069,-66.504415,38.182880,49.346235,-52.154879,36.819539,49.393756,-51.694603,37.298383,51.040807,-52.671863,37.465503,53.450655,-53.757996,36.513630,54.502582,-55.209420,36.904925,55.816089,-54.909601,39.874523,46.279381,-42.389970,36.857754,46.987118,-42.259574,37.775812,49.104554,-45.200152,39.691768,49.135035,-49.982732,38.074066,49.172542,-50.326715,37.943242,49.265271,-44.126045,41.020186,49.344595,-49.469661,38.933508,49.367331,-49.036132,39.302966,49.433079,-47.783307,40.238915,49.511407,-45.757979,41.761990,49.528398,-42.166952,44.865572,49.646118,-49.420614,39.551433,49.755627,-41.163102,46.314320,49.875067,-47.014451,41.737398,49.922564,-44.273740,43.958293,50.182912,-43.402321,45.005838,50.190666,-42.155063,46.008413,50.430083,-45.877357,43.290866,50.529242,-45.061424,44.086658,50.543990,-48.464304,41.217517,50.744350,-45.838400,43.512574,50.784047,-48.297559,41.496643,50.909104,-45.200356,44.179367,51.147742,-51.178659,38.952351,51.188957,-45.222944,44.157849,52.594625,-44.311090,44.749298,53.000656,-42.603777,46.005357,53.255468,-42.184656,46.362189,53.463328,-45.777430,43.604682,53.514531,-42.094090,46.576768,53.522947,-45.559244,43.786959,53.705531,-49.081873,40.767219,53.906368,-50.701188,39.397831,54.325091,-48.340222,41.529928,54.354582,-48.888209,41.075417,54.438219,-43.939980,46.116926,54.551077,-47.933089,42.003729,54.553460,-50.097318,40.234370,54.561922,-48.198978,41.788020,54.671303,-46.063630,44.059310,54.702141,-48.080526,42.025845,54.861483,-48.816180,41.764452,55.151302,-47.133270,44.207752,55.440584,-49.471735,42.325952,55.584287,-48.981081,43.385260,45.672268,-36.238690,42.080931,45.751081,-40.158991,38.669934,45.891802,-37.505316,41.056201,46.139851,-37.057203,41.701544,46.242485,-40.104534,38.974283,46.338403,-33.723547,45.135510,46.983143,-35.915250,43.477818};
			return value;
		}
		private double[] getCoordinate_9_21_point_240()
		{
			double[] value = {48.356329,-37.229463,44.851288,48.605820,-40.272990,42.290975,49.016550,-39.289938,46.268621,46.320083,-135.631322,47.201334,46.876165,-136.674329,55.663680,46.932940,-136.644057,55.834569,48.112599,-137.603503,50.818913,48.272440,-137.814460,49.702336,48.575840,-137.716746,50.270046,49.253163,-136.532809,56.745825,50.245056,-136.702858,50.938537,50.490041,-137.230499,51.326976,51.127743,-137.242846,51.930889,53.263126,-137.110802,54.165914,53.269368,-136.604912,56.894841,53.717504,-136.388495,56.485560,53.891407,-136.258033,54.888616,53.961600,-136.518191,55.173135,54.033790,-136.314970,55.740891,46.072734,-134.397994,47.850880,46.171183,-133.566183,48.262096,46.216315,-134.356658,47.973264,46.861009,-134.096950,48.635540,47.842196,-134.842440,48.789058,47.859373,-133.110989,49.760103,48.690922,-134.305406,49.994697,48.967531,-133.884329,50.573721,49.846100,-133.668842,51.421259,50.118251,-128.856175,51.021824,50.557548,-134.749194,51.106022,50.610103,-131.384509,52.066717,50.771510,-133.292793,52.395829,50.839638,-134.401751,51.564239,50.988355,-130.442626,57.058376,51.169676,-130.311443,52.379749,51.329188,-134.663203,51.813816,51.561905,-134.237262,52.304351,51.824716,-132.692657,56.765801,51.825366,-130.529273,53.090961,51.939103,-126.748479,52.301297,51.950876,-128.950289,55.575024,52.376342,-125.479749,54.537321,52.391675,-134.410234,52.878779,52.439915,-134.215966,53.057679,52.663044,-128.082609,54.330532,52.663601,-128.237885,53.569451,52.883248,-132.780638,55.115208,53.121662,-133.197155,55.170186,53.164005,-133.655256,56.416930,53.308853,-134.321503,53.841512,50.249159,-118.550947,48.488368,50.594867,-119.421918,49.030305,50.857487,-120.401726,49.534948,51.220059,-123.781819,50.772655,51.248898,-122.506144,55.747101,51.434454,-115.022182,48.755190,51.451296,-115.129665,54.571920,51.452351,-117.573696,54.911793,51.736332,-114.691505,54.113008,52.159635,-122.442010,51.366205,52.310501,-123.229736,54.375177,52.516983,-123.659066,52.077406,52.647283,-121.602277,51.666963,52.767363,-120.572702,51.517312,52.886272,-120.495064,53.097755,53.044004,-122.909766,52.767447,53.099573,-119.409028,51.670132,53.190652,-120.712288,52.692612,53.215556,-115.220623,50.525833,53.295992,-117.331308,52.178348,53.299372,-114.392328,50.400731,53.328111,-118.163093,51.491648,53.335024,-118.544072,51.678770,53.401389,-115.723006,51.815082,53.468762,-115.381488,50.885893,53.560856,-115.564929,51.248585,49.870013,-108.534443,55.583274,50.490500,-106.588901,54.452794,51.814877,-106.611981,47.226408,51.972684,-105.839707,47.213409,52.256592,-104.298345,47.143390,53.124326,-107.579736,48.751817,53.627338,-112.624861,50.525327,53.656462,-112.328942,50.738855,53.814544,-107.790341,49.662396,53.815619,-107.130119,49.429070,53.825155,-104.165510,48.713306,53.918115,-104.254023,49.369179,45.836014,-93.325284,47.442291,46.635243,-94.752361,56.721566,46.994035,-94.051557,50.019321,47.310223,-94.876880,55.578666,47.711706,-94.587047,51.776903,47.829327,-94.684770,52.099106,48.242103,-97.815833,55.595967,48.483842,-99.030092,55.526352,48.608138,-95.346122,54.442496,48.712736,-94.739470,48.031569,48.775068,-95.053727,51.981306,48.779873,-95.541316,54.361511};
			return value;
		}
		private double[] getCoordinate_9_21_point_241()
		{
			double[] value = {49.115085,-95.031151,50.273509,49.437543,-101.773659,54.837873,49.820059,-96.696941,53.308542,49.858725,-99.714056,53.881693,49.888576,-95.674866,52.925582,50.087806,-100.876326,53.824141,50.234541,-95.894958,52.619314,51.071225,-102.615470,52.959890,51.228866,-95.865876,47.634842,51.367471,-102.656581,52.588088,51.389183,-95.902802,50.503944,51.612911,-95.835060,49.128968,51.882967,-96.143543,50.409418,51.922957,-95.985488,49.603167,52.494760,-103.485916,51.287838,52.800146,-96.487606,47.141636,53.049524,-96.360315,47.855058,53.206493,-96.354405,48.098183,54.036278,-100.488543,48.806279,54.039592,-102.016737,48.972248,54.040622,-97.972605,48.338969,54.086430,-98.268129,47.721654,54.156941,-98.181788,47.988657,45.997533,-93.278976,47.809796,45.867445,-68.742474,48.007612,45.949442,-68.139008,49.284413,46.267920,-64.434753,56.665572,46.730460,-66.726066,51.630367,46.966043,-68.753939,46.763880,47.205492,-68.315116,47.315279,47.219440,-68.595305,46.783723,47.734938,-65.514554,53.282774,48.130077,-65.622745,52.569750,48.312395,-63.368624,57.068805,48.370763,-67.569107,47.909640,48.823218,-67.061222,48.393224,50.185124,-62.630561,56.998876,52.537123,-64.611060,50.402298,52.581809,-65.901320,46.964025,52.772387,-64.097018,51.506711,53.779590,-65.085404,47.690475,55.016822,-63.164541,51.170713,56.043100,-62.694665,51.195225,51.122693,-41.164588,47.101610,53.899353,-41.901347,47.441156,54.191505,-42.816992,47.000403,54.404260,-42.066004,51.109609,54.428035,-42.244936,50.462127,54.584713,-42.666860,49.943697,54.708301,-43.993880,46.974855,55.084186,-44.245062,49.699440,55.226950,-44.756985,49.359132,55.783794,-42.151958,52.743066,46.386319,-31.759025,47.718096,47.103926,-32.265429,49.006138,47.129497,-32.365160,51.250226,47.301359,-31.379521,52.800929,47.536044,-33.288546,50.993943,47.563459,-32.812206,51.783161,47.644309,-33.053076,51.620557,47.766169,-34.047520,50.239319,47.775026,-33.325501,51.526162,47.966357,-34.707461,49.469949,48.155985,-35.233399,47.706136,48.201324,-33.178694,51.921776,48.276027,-35.398922,49.761755,48.277555,-33.604719,51.659926,48.577456,-36.828656,47.067715,48.693635,-35.021879,50.778443,48.748424,-37.659594,47.635404,48.924565,-32.588834,52.347700,48.951724,-36.256434,49.858515,48.978500,-38.306914,47.677319,49.071003,-37.399054,48.954833,49.342676,-30.828162,53.757906,49.516229,-39.551659,47.460636,49.739008,-36.970267,49.756258,50.050836,-31.072251,54.832015,50.155134,-31.404571,54.400361,50.574193,-33.128338,52.646107,50.650320,-32.163015,56.140781,50.667327,-34.575243,51.472878,50.712654,-32.957244,53.079564,50.731126,-37.096216,49.681974,51.076322,-32.389406,56.525131,51.087067,-38.322906,48.936400,51.099370,-32.641101,56.293940,51.190258,-33.578355,53.830629,51.272585,-34.360773,52.234005,51.358095,-36.106605,50.549951,51.499140,-36.614093,50.194486,51.612461,-34.500943,53.475350,51.800098,-35.640866,51.572278,51.811886,-38.542692,48.753780,51.946001,-35.194957,54.733457,52.190187,-36.436028,51.144682,52.589874,-36.765963,52.442030,52.743159,-37.187857,51.923419,53.379516,-40.939794,47.580214,53.487026,-39.416196,51.874253};
			return value;
		}
		private double[] getCoordinate_9_21_point_242()
		{
			double[] value = {53.548631,-38.545862,53.956323,53.825818,-40.320257,50.069680,53.892989,-40.560081,51.851132,54.374398,-35.080307,56.223423,55.993286,-36.139511,56.381825,45.792552,-26.453354,55.329094,45.799408,-27.984621,54.435388,45.811156,-28.949707,53.383621,45.818688,-29.107663,52.429346,45.826704,-26.102895,55.514100,46.209977,-30.105530,51.895533,46.381334,-30.441614,52.512562,46.607370,-26.511315,55.575889,46.713327,-28.101217,54.595685,46.722203,-25.427570,56.561514,47.272841,-28.077124,54.824337,47.470934,-28.636381,54.415947,47.521917,-26.685786,56.232453,48.379746,-27.878359,56.133683,48.509862,-30.616803,53.459445,48.870965,-29.484394,54.694130,49.353266,-30.489305,54.188442,49.620669,-30.181878,56.064550,48.835426,-135.868645,60.271768,50.552298,-135.881520,60.432209,51.277101,-135.653999,59.565968,52.115575,-135.992353,58.561184,45.659374,-134.270471,66.006466,45.753163,-131.545980,64.679699,46.583675,-130.652422,62.417954,46.720416,-134.669396,64.832493,46.927526,-135.033531,64.519795,47.099020,-135.115349,64.101532,47.114705,-134.614877,64.382200,47.947501,-128.208602,60.376411,48.301107,-134.905819,63.024175,48.509829,-132.538432,62.046554,49.277641,-131.603771,59.510678,49.324934,-132.620434,60.979613,49.674582,-131.417400,58.927012,49.779575,-132.679357,60.365141,50.184649,-132.670340,59.706801,50.657061,-132.285549,58.117783,50.754770,-134.837153,60.100912,50.842411,-132.677192,58.531878,51.761144,-133.172151,57.948800,52.525514,-134.100697,57.692386,52.669664,-133.745412,57.261800,45.852741,-122.794297,62.202735,45.872926,-118.167263,61.802982,46.286430,-118.228679,61.310439,46.426860,-118.545047,61.176824,48.178803,-121.384509,59.380021,48.316541,-117.330510,58.751543,48.906691,-123.534834,58.706668,46.443435,-109.347438,59.989973,46.831473,-108.130592,59.323881,48.048388,-105.526219,57.336176,49.167223,-113.275265,57.191327,45.852955,-94.771012,58.167146,45.968938,-99.866686,59.104471,46.040355,-94.730018,57.822628,46.115189,-101.705202,59.206987,48.317518,-59.734456,64.833938,49.278536,-60.672374,61.903070,50.730236,-60.838682,60.378147,51.494580,-60.306085,61.029307,51.702421,-61.504526,58.270253,52.028590,-60.294722,60.465431,52.119003,-59.579217,62.175952,52.267423,-57.787943,66.247603,52.569515,-58.377303,64.622888,53.379243,-57.547533,65.884611,54.198683,-57.896385,64.381845,54.711893,-58.466823,62.720612,50.408401,-30.649435,57.332551,51.323684,-31.681140,57.211113,53.091839,-31.317762,58.053543,53.134321,-31.411385,58.021740,54.615019,-30.808670,63.718408,54.833748,-31.007397,61.871541,55.037361,-31.550265,63.979779,55.160621,-31.651547,61.481652,55.655520,-32.510033,63.634191,55.743963,-32.711238,63.837033,55.970274,-31.401296,65.694865,46.086089,-23.695998,58.244829,46.385543,-22.888923,60.320588,46.779940,-24.908610,57.538791,46.970954,-23.965327,59.996298,47.084108,-22.743193,60.851341,47.136239,-24.612110,59.580338,47.306989,-22.136599,61.660007,47.502446,-21.228206,65.112006,47.704532,-23.146570,61.052770,47.716090,-24.267610,60.081025,48.362502,-22.372237,64.835714,48.494154,-22.529134,64.837558,48.617191,-23.671153,61.478800,48.702072,-25.120766,60.065552};
			return value;
		}
		private double[] getCoordinate_9_21_point_243()
		{
			double[] value = {48.870986,-25.343280,59.949264,48.915659,-23.490144,62.369308,49.399482,-23.396693,65.150352,49.454489,-20.757050,66.323720,49.518631,-28.131686,58.460059,49.718629,-25.999291,60.107551,49.921938,-26.174587,60.116332,50.146649,-23.906639,65.356805,50.295824,-20.365286,66.927627,50.345822,-21.418553,66.417206,50.367774,-23.915460,65.419768,50.420366,-26.823008,59.810400,50.426991,-24.860196,64.891847,50.545967,-30.613446,57.457893,50.595568,-23.918074,65.481310,50.605490,-27.420323,59.423774,50.669391,-26.348487,60.861188,50.705001,-26.026430,61.581453,50.767400,-28.579425,58.728804,50.898092,-27.565533,59.550021,50.960042,-26.609369,60.849808,50.978155,-28.075026,59.124710,51.180742,-22.796037,66.177982,51.235874,-26.753650,61.114682,51.539217,-29.275829,58.566662,51.815151,-27.187577,61.871390,52.047624,-21.324649,67.333560,52.210670,-26.252860,65.336552,52.234496,-28.979518,59.424456,52.265403,-27.518221,63.479582,52.355364,-27.295211,64.833940,52.371991,-21.978334,67.102142,52.454820,-24.041121,66.280207,52.527940,-30.112912,58.615285,52.537875,-28.317302,61.036581,52.737327,-30.353049,58.567141,52.956358,-28.500965,63.552562,53.017671,-30.564641,58.577041,53.917431,-29.720817,64.302246,54.006996,-29.785602,64.483640,54.064868,-29.849487,64.531492,54.124491,-28.662567,65.583346,54.723955,-24.388200,67.255409,55.224632,-27.052330,66.389032,55.347668,-29.877242,65.859829,55.693161,-26.773261,66.617546,46.162340,-16.951970,67.053810,46.694483,-20.063050,65.560120,46.977351,-17.292769,67.418303,49.487584,-19.596109,66.997752,46.905215,-58.541336,69.324752,48.980922,-57.834052,69.607477,49.875819,-56.376114,73.128574,50.616631,-54.520611,77.404446,50.939036,-54.370591,77.443664,50.941061,-55.327959,75.074098,51.050593,-57.792742,67.520224,51.104233,-54.438573,77.056056,51.425100,-57.099517,69.352053,51.491440,-55.376830,74.249065,53.205812,-55.787325,71.475020,53.224644,-55.616490,71.966105,54.682652,-32.178181,77.237088,45.979528,-21.584526,74.798713,47.277732,-22.817731,73.375310,47.634672,-22.949890,73.267760,48.967511,-23.953427,76.216580,49.026117,-24.027786,76.223393,49.042200,-24.025149,73.677256,49.256908,-24.298364,73.761732,49.516912,-24.690096,73.981112,49.644384,-24.827127,74.075221,49.801854,-25.420084,74.995322,49.825696,-22.873727,73.152664,50.049831,-24.825066,77.053949,50.062523,-25.500173,76.399125,50.097791,-25.569008,74.609359,50.114079,-25.731855,76.146727,50.122811,-25.746167,75.954081,50.307922,-25.951298,76.072400,50.368620,-25.942582,74.787597,50.852002,-20.787526,71.805738,51.012043,-26.618625,75.041502,51.202606,-20.705854,71.638619,51.367999,-27.068242,77.054409,51.597339,-20.976352,71.656439,51.642778,-27.544453,77.407097,51.695258,-27.783547,75.801978,51.773341,-27.509653,77.874565,51.773553,-24.693765,73.794027,51.800868,-28.181633,76.276105,51.987694,-20.414210,68.492029,52.125701,-20.555709,68.488045,52.192948,-21.206698,67.567848,52.212705,-28.583013,77.158086,52.365381,-28.519603,77.714436,52.380045,-21.539091,71.684334,53.052976,-28.506438,75.424156,53.260789,-21.822651,68.291657,53.366068,-22.119513,67.847818};
			return value;
		}
		private double[] getCoordinate_9_21_point_244()
		{
			double[] value = {53.383264,-22.310468,71.765733,53.666772,-24.026380,72.888688,53.731800,-22.174920,68.459696,53.950030,-22.370540,68.450574,55.609869,-24.500230,67.909171,55.644793,-24.333523,68.123650,55.712075,-25.167485,72.849693,45.740969,-19.396204,77.804517,45.813806,-18.716944,71.995144,45.915058,-15.696460,70.912421,45.919555,-18.899389,72.028441,46.802444,-16.691188,71.043393,47.102297,-17.087972,71.112192,47.918451,-20.064268,72.048532,48.395378,-17.733031,70.895903,48.977964,-17.772095,69.302723,49.002258,-18.015355,68.549529,49.174970,-18.113608,68.651814,49.230925,-18.271649,70.794355,49.293448,-18.146933,70.509239,49.625943,-19.017554,71.175381,49.698940,-18.698125,68.421610,49.978527,-19.636314,71.423896,50.301542,-18.978880,68.764726,50.454677,-19.200650,70.671675,51.185995,-19.835715,70.752267,51.195665,-19.589197,69.714981,51.486947,-19.932230,70.337369,46.489372,-54.569532,80.337911,47.474065,-55.158869,78.050135,50.877186,-52.321413,81.250317,51.094872,-52.908730,80.033870,51.469632,-52.232620,81.023085,54.998063,-51.831463,78.534600,48.835728,-51.214582,84.802444,50.629452,-51.161324,83.462114,50.999913,-50.947042,83.530658,51.809707,-48.398164,87.078156,53.423538,-51.351839,80.755661,53.597815,-48.681854,84.958833,54.540414,-49.211066,83.305329,54.902260,-45.547044,87.816727,55.485964,-45.985405,86.757494,53.693453,-33.095816,87.864813,53.737132,-33.788253,88.187412,53.816475,-31.535337,78.503652,53.851912,-32.666351,87.007324,53.899320,-31.114526,84.686754,53.940984,-32.086029,86.004530,53.993177,-30.957415,81.691451,54.151921,-32.930007,86.152147,54.155252,-32.234105,78.281914,54.385423,-32.203396,81.782412,54.423055,-32.887222,79.025117,54.445033,-32.575840,80.325590,54.794379,-33.244635,81.734348,55.040802,-33.863806,78.466944,55.053676,-34.022663,78.618200,55.151705,-34.400336,83.560708,55.236878,-33.820650,78.211232,55.301075,-38.872050,88.100325,55.349466,-34.886237,79.419017,55.382836,-34.033915,78.364876,55.588596,-35.259995,79.186448,55.628831,-36.495145,84.377193,55.762576,-38.022044,85.675685,55.792490,-37.296513,85.020149,47.196929,-20.385982,86.348872,47.812208,-21.178751,86.685456,48.171286,-21.512870,86.599382,48.278042,-20.973005,83.186883,48.521986,-21.298833,83.631291,48.624701,-22.134549,86.931942,48.647533,-21.381725,80.822191,48.952240,-21.561334,81.581109,49.017908,-21.660495,81.777654,49.256212,-22.354616,79.540714,49.317843,-22.299070,80.245465,49.472826,-22.622522,79.881157,49.995582,-23.691273,86.119681,50.421823,-25.029635,87.394407,50.736055,-24.413628,80.000131,50.853403,-25.136651,86.550799,52.081907,-26.591527,83.706889,52.100145,-26.668276,80.635822,52.398041,-27.157987,84.043999,52.455814,-28.652035,78.117734,52.592250,-29.035519,78.077911,52.716293,-27.717987,83.665253,52.998255,-28.367406,81.315152,53.039475,-28.802768,85.176176,53.091516,-29.217142,79.424062,53.102552,-29.976640,78.009925,53.332601,-30.120185,85.650649,53.493643,-29.562139,81.243706,53.505805,-30.509190,85.656555,53.665875,-29.797077,82.103700,45.802599,-18.618237,79.984617,46.136613,-18.992093,79.734347,46.480486,-19.638777,78.877183};
			return value;
		}
		private double[] getCoordinate_9_21_point_245()
		{
			double[] value = {46.825038,-19.411336,81.126854,45.859614,-45.661844,95.348505,45.905912,-49.392157,89.639159,46.112963,-48.220770,91.476230,46.126777,-48.927653,90.207223,46.213777,-49.491266,89.433222,46.358211,-46.158327,94.288117,47.459668,-44.950938,95.156104,47.696098,-49.260315,88.716200,47.755627,-46.835149,92.565560,48.067302,-47.553286,91.212472,48.086004,-46.626994,92.595343,48.416767,-45.608746,93.728378,48.696324,-46.553342,92.218605,48.852438,-48.788240,88.742401,48.919338,-48.247692,89.572072,50.236855,-44.715628,93.234856,50.262729,-45.809891,91.904309,50.678744,-45.546077,92.039581,50.700178,-47.980831,88.622729,50.915008,-47.122848,89.570649,51.018216,-45.075283,92.304416,51.124723,-46.655302,90.004872,51.163756,-47.632861,88.748978,52.751418,-42.131906,93.000179,53.363642,-46.307648,88.440401,53.509275,-46.184481,88.446508,53.842812,-45.440386,89.043473,54.478594,-43.937036,89.932278,54.854505,-44.835597,88.632859,55.370427,-44.279938,88.422191,55.829935,-42.130201,88.475791,45.989578,-31.698611,97.016475,46.521535,-36.686538,98.505270,47.372036,-39.274470,98.139185,47.511367,-32.091088,95.578694,47.681764,-31.698671,95.223870,47.898529,-36.023237,96.947108,48.517339,-40.942939,97.204588,48.703283,-31.884049,94.191943,48.856485,-33.657595,94.859865,48.971277,-37.016592,96.192525,49.954417,-34.135782,93.840965,51.678759,-32.017791,90.883434,51.869865,-34.606707,91.805597,52.346890,-37.917196,92.624216,52.529322,-35.960282,91.547480,52.718123,-37.670009,92.084345,53.035520,-31.595274,88.313136,53.700863,-35.386855,89.571564,54.043050,-38.681867,90.659153,45.837667,-27.336885,95.386871,46.373198,-20.306522,88.504639,46.520064,-21.585521,90.433665,46.777886,-29.351122,95.201461,46.848735,-23.690556,92.163424,47.357367,-21.613112,89.007591,47.408519,-25.891385,93.022380,49.480509,-24.854878,89.500787,49.804850,-24.551184,88.392916,50.666084,-28.913419,90.584094,50.837879,-27.434485,89.381396,56.103222,-62.146814,36.884953,56.221322,-65.895403,37.927155,56.414441,-64.171127,37.529492,56.490972,-63.490162,37.504312,56.541376,-63.359037,38.137435,56.655820,-65.009982,42.617039,57.007980,-64.654456,39.721191,57.019750,-64.988685,39.926097,57.090087,-63.665797,46.162651,57.153475,-64.745928,41.717727,57.297032,-64.291130,43.142721,58.160885,-63.039651,46.525677,59.675487,-62.285612,45.729402,56.468446,-60.619809,38.573995,56.537129,-57.137616,40.488850,56.843004,-60.433445,40.019921,57.261256,-53.527333,45.275940,57.649743,-60.178483,42.885238,57.698611,-59.622666,43.164849,57.746580,-61.220954,42.694837,57.794145,-61.797143,42.691912,57.891387,-60.502155,43.255358,58.302396,-56.866225,45.108653,58.376250,-58.835327,44.209963,58.431231,-57.731733,44.745413,58.433419,-60.754734,43.587841,59.377868,-60.193061,44.193057,59.987887,-60.446382,44.972800,60.037894,-61.841107,45.846454,60.199119,-54.214477,46.570204,60.478628,-58.041202,45.415698,60.648890,-59.016104,45.555793,60.935928,-56.869307,46.092965,56.803222,-50.687123,46.547385,57.316751,-62.910339,48.595915,57.822729,-63.121418,46.791061,57.631235,-60.272639,55.804094,57.654640,-53.034669,46.760570};
			return value;
		}
		private double[] getCoordinate_9_21_point_246()
		{
			double[] value = {57.785566,-61.939487,51.205426,58.067054,-59.677717,56.888572,59.829273,-52.576130,47.321910,60.762220,-60.758668,50.314299,61.198358,-59.900950,52.375570,61.339605,-59.031646,54.457835,61.446608,-60.462418,48.591229,61.609876,-60.352552,49.025487,61.885508,-59.883493,50.917580,62.306379,-58.510821,54.255451,62.485520,-55.680939,48.188261,62.639770,-52.079566,50.068042,62.846786,-56.940422,48.816527,63.067552,-55.703831,49.171416,63.150796,-51.642575,51.397900,63.380604,-57.476678,55.269140,63.642829,-57.542965,51.592491,63.797570,-53.105041,51.835291,64.022968,-53.716617,52.096509,64.446201,-56.363237,56.166993,64.805596,-55.736334,56.100490,56.768117,-49.890793,47.679857,56.882417,-48.701799,49.032274,56.984842,-48.880431,48.980486,57.026788,-50.264681,48.003608,57.236596,-50.127441,48.308959,57.246165,-50.591829,47.988939,57.394783,-45.579309,50.910282,57.448635,-50.167631,48.372013,57.887171,-43.308481,52.318680,58.090961,-47.845744,49.670373,60.034552,-50.486195,48.527662,60.245746,-45.564939,52.146946,61.513473,-46.933471,52.404479,61.864257,-45.102810,54.496674,61.912570,-49.527929,50.812094,61.921549,-48.448067,51.682337,62.343887,-46.614692,53.953150,62.402019,-45.862302,54.781944,62.709367,-46.596608,54.788642,63.018833,-46.521068,55.427228,63.484107,-51.140091,52.348663,63.512254,-46.740547,56.765124,63.537804,-51.346062,52.286330,64.634321,-51.479478,55.291253,56.132568,-36.383896,56.269755,57.325989,-40.075616,54.203975,58.816135,-39.828643,55.682069,59.315504,-40.670963,55.404715,59.684840,-40.882317,55.858963,56.105334,-59.499349,58.978362,56.258352,-59.225596,59.454835,56.731196,-57.902215,62.387377,59.134976,-55.117565,66.856624,60.065970,-57.429351,60.374315,61.024125,-56.639995,61.131715,61.770879,-54.834662,64.273315,61.897559,-55.579446,62.396701,62.016265,-55.060785,63.580891,62.051008,-56.586350,59.939320,62.282394,-56.066628,60.937904,62.772275,-55.676198,61.180193,63.194922,-53.123198,66.129981,63.640241,-52.618331,66.410687,64.995468,-51.821328,65.635364,65.317243,-51.539706,65.265508,65.339353,-53.868407,61.817090,65.362458,-54.540357,58.673767,65.421050,-54.419522,59.889784,65.446930,-52.938901,63.148510,65.493175,-53.312964,62.482128,65.516613,-54.159836,60.219910,65.720167,-51.531799,63.696745,65.812111,-52.390940,62.247653,65.824047,-52.274429,62.611538,60.710464,-41.257124,57.805439,60.974871,-42.258217,65.240099,61.170428,-41.943717,65.946572,61.176792,-41.401222,60.507400,61.461765,-43.394677,65.172697,61.927227,-43.407783,57.248889,62.059907,-43.359195,61.769384,62.078824,-43.062451,60.070054,62.148563,-44.842604,64.793835,62.318274,-43.630087,58.898248,62.358885,-43.504131,60.612970,62.844170,-46.491727,65.649019,62.856240,-46.450521,65.861603,63.169420,-47.019250,65.391144,63.275655,-46.667384,66.319153,63.320244,-45.201078,60.466165,63.732779,-46.136892,59.156663,63.737640,-46.844222,63.344498,63.828576,-47.843904,66.389590,63.923818,-46.493848,59.014643,64.435990,-47.492379,60.514366,64.562172,-49.424777,57.165695,64.605309,-49.336293,66.631473,64.690385,-51.026419,67.221623,64.776725,-49.220921,64.604628};
			return value;
		}
		private double[] getCoordinate_9_21_point_247()
		{
			double[] value = {64.899301,-49.386716,67.339083,65.081457,-51.381437,65.748610,65.197535,-50.064951,58.927929,65.502467,-50.834436,60.308556,65.521050,-51.326679,64.665223,56.180839,-33.770103,59.567618,56.317163,-33.685662,64.158103,56.448288,-33.257548,65.192666,56.898113,-34.359272,64.906587,56.915405,-34.633738,59.675436,57.107490,-34.704788,61.803122,57.340870,-35.449514,64.569166,57.348015,-34.807479,65.308780,57.518396,-35.779332,63.480057,57.535740,-35.760695,64.703835,57.575525,-34.148018,65.766077,57.604312,-35.777226,59.834083,57.640035,-36.089341,63.856973,57.702504,-31.143956,66.364581,57.787473,-35.802290,60.406659,57.891550,-33.407313,66.132015,58.129513,-36.976866,64.401223,58.598413,-37.139158,61.172297,58.652730,-37.576482,65.262755,58.813780,-38.023211,58.608839,58.850554,-38.330863,64.349132,59.162422,-38.883819,63.975904,59.666001,-36.134978,66.432866,59.724484,-39.131077,61.552655,59.801226,-38.241313,66.150229,59.929386,-34.205728,66.704218,59.972639,-39.364235,60.029657,60.000518,-40.400682,57.480844,60.098918,-39.612287,65.988173,60.173288,-40.446293,65.552132,60.235512,-40.929968,64.253474,60.515169,-40.481069,61.354192,60.802696,-40.820004,60.721611,61.182690,-33.907148,67.394252,61.290739,-38.999359,66.721896,56.890533,-29.203616,66.503678,57.718726,-29.053398,66.859358,59.086630,-53.947985,69.596947,59.178361,-52.979140,71.774679,62.215524,-51.854606,69.925980,60.191815,-51.333561,73.835077,60.552261,-49.490851,77.161528,60.554474,-49.354229,77.428287,60.678940,-50.023117,75.915287,61.876460,-49.594484,75.290836,62.205720,-48.569541,76.925601,62.280096,-48.779722,76.392027,62.298537,-49.758214,74.328125,62.916693,-50.108532,72.852699,64.268582,-42.406047,77.858254,64.753526,-44.590601,67.699459,64.870904,-50.675027,67.601992,64.910168,-50.509634,68.397050,64.927115,-50.556542,67.874567,64.928342,-46.496660,67.611392,64.942413,-45.676822,76.265613,65.012301,-49.085938,72.093556,65.026681,-44.948010,67.903567,65.169117,-49.909235,67.876782,65.291536,-48.423378,72.700254,65.464202,-46.580771,74.902993,65.476107,-48.209309,72.591590,65.704083,-46.824514,74.214415,65.709104,-41.286920,70.914547,65.726797,-42.306141,70.140124,65.895389,-41.715674,73.494366,65.945225,-46.380951,73.948233,65.971990,-47.644528,72.069987,66.167653,-43.040139,73.078590,66.191255,-46.497333,70.061323,56.454616,-30.691986,76.429268,56.811612,-31.775468,77.044585,59.395050,-32.043175,76.618524,59.845036,-33.725968,77.848894,59.912437,-31.996246,76.363152,60.787872,-31.179630,68.980630,60.809391,-30.941216,74.270529,60.817076,-32.303719,67.764086,61.237742,-30.858811,71.472213,61.428939,-33.725675,76.938253,61.665955,-34.529827,77.450042,62.012786,-34.604020,67.907398,62.264530,-34.355619,76.203954,62.473947,-34.477664,68.608828,62.474295,-35.423373,68.047295,62.867448,-33.707247,73.122754,63.073003,-34.098269,72.028375,63.434606,-40.429148,67.657272,63.505586,-36.099081,69.327007,63.733510,-35.938654,70.179821,63.868810,-37.543117,68.956085,63.930913,-37.647063,69.042632,63.934639,-36.088164,73.840147,64.541072,-37.493113,72.733160,64.666080,-40.943779,68.571774};
			return value;
		}
		private double[] getCoordinate_9_21_point_248()
		{
			double[] value = {64.924218,-38.818589,70.954797,65.169539,-39.024319,71.862697,56.114359,-29.913368,75.930457,56.414113,-25.192562,72.354391,56.458307,-28.075105,74.586724,57.087666,-26.546225,73.255580,57.238962,-25.803087,71.451287,57.282494,-26.024470,68.538075,57.534479,-26.398106,72.440430,57.657930,-26.737187,72.972530,58.721184,-28.982714,67.607161,58.739426,-27.617575,71.969930,59.000889,-28.545524,73.853794,59.412760,-29.253149,74.265177,59.762862,-30.235731,67.865183,59.912778,-28.941590,71.072792,59.925063,-29.219214,72.801843,59.932222,-30.556173,67.894083,56.120739,-46.741904,85.183448,56.142890,-44.640957,87.183967,56.249582,-46.333909,85.513884,56.455554,-48.409182,82.758630,56.543168,-44.371956,86.713979,56.667749,-49.290461,81.216165,56.792167,-47.399350,83.795963,56.883883,-41.611848,85.347853,57.279607,-45.348629,85.318697,57.473092,-44.883598,85.150766,57.513537,-49.993446,79.279117,57.659205,-43.382864,84.293596,57.824590,-45.613275,84.607080,58.055657,-42.893679,82.648423,58.252732,-45.504875,84.177758,58.812521,-44.291992,83.102929,58.824055,-42.058013,81.573391,59.048684,-49.345060,78.977544,59.076039,-42.240794,81.719480,59.161128,-47.313643,81.621114,59.266326,-47.823015,80.871210,60.498712,-46.486742,81.436678,61.339799,-45.977993,81.104563,61.456990,-41.163835,81.477867,61.641038,-42.834474,81.923284,61.859806,-42.625399,81.781681,61.929354,-43.629282,81.775189,61.956841,-45.122464,81.146571,62.153431,-43.391327,81.540146,62.419057,-44.132698,81.012618,63.899778,-44.664385,78.281125,56.332737,-37.226908,79.908428,56.530698,-39.485410,83.054780,56.551230,-39.069017,81.217562,56.631707,-35.756770,79.026303,56.675810,-39.646522,81.497292,56.904750,-40.261020,81.529651,56.918502,-40.782277,83.578261,57.224359,-40.103556,80.975000,57.833522,-40.293157,80.771199,57.987941,-33.570646,78.071685,58.212847,-40.755023,80.887506,58.505528,-40.836840,80.923598,58.596737,-34.797283,78.814097,58.799481,-39.735435,80.577348,59.328068,-37.088762,79.941760,60.348389,-40.309747,81.000798,60.377215,-39.794295,80.947821,60.714806,-39.079869,80.734965,61.243683,-39.642560,80.866365,61.614846,-40.793463,81.282021,62.406031,-36.402463,78.173780,63.257753,-38.341334,78.156931};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getColor_9_22_color_1()
		{
			double[] value = {0.000,0.494,0.506,0.000,0.482,0.518,0.000,0.470,0.530,0.000,0.466,0.534,0.000,0.464,0.536,0.000,0.466,0.534,0.000,0.463,0.537,0.000,0.463,0.537,0.000,0.468,0.532,0.000,0.477,0.523,0.000,0.489,0.511,0.000,0.463,0.537,0.000,0.464,0.536,0.000,0.471,0.529,0.000,0.469,0.531,0.000,0.466,0.534,0.000,0.468,0.532,0.000,0.476,0.524,0.000,0.480,0.520,0.000,0.481,0.519,0.000,0.484,0.516,0.000,0.513,0.487,0.000,0.505,0.495,0.000,0.527,0.473,0.000,0.510,0.490,0.000,0.497,0.503,0.000,0.496,0.504,0.000,0.526,0.474,0.000,0.500,0.500,0.000,0.516,0.484,0.000,0.523,0.477,0.000,0.495,0.505,0.000,0.507,0.493,0.000,0.496,0.504,0.000,0.528,0.472,0.000,0.538,0.462,0.000,0.559,0.441,0.000,0.559,0.441,0.000,0.553,0.447,0.000,0.577,0.423,0.000,0.561,0.439,0.000,0.549,0.451,0.000,0.474,0.526,0.000,0.471,0.529,0.000,0.471,0.529,0.000,0.468,0.532,0.000,0.468,0.532,0.000,0.467,0.533,0.000,0.475,0.525,0.000,0.470,0.530,0.000,0.467,0.533,0.000,0.466,0.534,0.000,0.466,0.534,0.000,0.467,0.533,0.000,0.465,0.535,0.000,0.465,0.535,0.000,0.466,0.534,0.000,0.470,0.530,0.000,0.472,0.528,0.000,0.466,0.534,0.000,0.464,0.536,0.000,0.468,0.532,0.000,0.465,0.535,0.000,0.465,0.535,0.000,0.467,0.533,0.000,0.470,0.530,0.000,0.468,0.532,0.000,0.468,0.532,0.000,0.466,0.534,0.000,0.476,0.524,0.000,0.468,0.532,0.000,0.469,0.531,0.000,0.485,0.515,0.000,0.483,0.517,0.000,0.484,0.516,0.000,0.488,0.512,0.000,0.488,0.512,0.000,0.492,0.508,0.000,0.485,0.515,0.000,0.492,0.508,0.000,0.482,0.518,0.000,0.478,0.522,0.000,0.478,0.522,0.000,0.482,0.518,0.000,0.484,0.516,0.000,0.501,0.499,0.000,0.508,0.492,0.000,0.503,0.497,0.000,0.508,0.492,0.000,0.480,0.520,0.000,0.499,0.501,0.000,0.508,0.492,0.000,0.500,0.500,0.000,0.478,0.522,0.000,0.479,0.521,0.000,0.515,0.485,0.000,0.483,0.517,0.000,0.494,0.506,0.000,0.526,0.474,0.000,0.519,0.481};
			return value;
		}
		private double[] getColor_9_22_color_2()
		{
			double[] value = {0.000,0.523,0.477,0.000,0.528,0.472,0.000,0.525,0.475,0.000,0.528,0.472,0.000,0.528,0.472,0.000,0.543,0.457,0.000,0.542,0.458,0.000,0.544,0.456,0.000,0.552,0.448,0.000,0.558,0.442,0.000,0.542,0.458,0.000,0.543,0.457,0.000,0.569,0.431,0.000,0.571,0.429,0.000,0.581,0.419,0.000,0.578,0.422,0.000,0.566,0.434,0.000,0.583,0.417,0.000,0.586,0.414,0.000,0.574,0.426,0.000,0.590,0.410,0.000,0.591,0.409,0.000,0.577,0.423,0.000,0.591,0.409,0.000,0.590,0.410,0.000,0.592,0.408,0.000,0.583,0.417,0.000,0.598,0.402,0.000,0.604,0.396,0.000,0.606,0.394,0.000,0.610,0.390,0.000,0.612,0.388,0.000,0.613,0.387,0.000,0.610,0.390,0.000,0.621,0.379,0.000,0.619,0.381,0.000,0.633,0.367,0.000,0.626,0.374,0.000,0.634,0.366,0.000,0.482,0.518,0.000,0.475,0.525,0.000,0.481,0.519,0.000,0.484,0.516,0.000,0.481,0.519,0.000,0.484,0.516,0.000,0.481,0.519,0.000,0.481,0.519,0.000,0.480,0.520,0.000,0.475,0.525,0.000,0.484,0.516,0.000,0.470,0.530,0.000,0.478,0.522,0.000,0.475,0.525,0.000,0.477,0.523,0.000,0.473,0.527,0.000,0.479,0.521,0.000,0.486,0.514,0.000,0.476,0.524,0.000,0.484,0.516,0.000,0.485,0.515,0.000,0.477,0.523,0.000,0.486,0.514,0.000,0.483,0.517,0.000,0.490,0.510,0.000,0.484,0.516,0.000,0.494,0.506,0.000,0.491,0.509,0.000,0.494,0.506,0.000,0.496,0.504,0.000,0.494,0.506,0.000,0.498,0.502,0.000,0.505,0.495,0.000,0.505,0.495,0.000,0.500,0.500,0.000,0.498,0.502,0.000,0.504,0.496,0.000,0.499,0.501,0.000,0.503,0.497,0.000,0.503,0.497,0.000,0.506,0.494,0.000,0.505,0.495,0.000,0.503,0.497,0.000,0.504,0.496,0.000,0.505,0.495,0.000,0.509,0.491,0.000,0.508,0.492,0.000,0.522,0.478,0.000,0.515,0.485,0.000,0.524,0.476,0.000,0.527,0.473,0.000,0.516,0.484,0.000,0.529,0.471,0.000,0.538,0.462,0.000,0.549,0.451,0.000,0.556,0.444,0.000,0.559,0.441,0.000,0.561,0.439,0.000,0.564,0.436,0.000,0.566,0.434,0.000,0.564,0.436};
			return value;
		}
		private double[] getColor_9_22_color_3()
		{
			double[] value = {0.000,0.568,0.432,0.000,0.569,0.431,0.000,0.571,0.429,0.000,0.572,0.428,0.000,0.575,0.425,0.000,0.579,0.421,0.000,0.582,0.418,0.000,0.617,0.383,0.000,0.614,0.386,0.000,0.619,0.381,0.000,0.591,0.409,0.000,0.615,0.385,0.000,0.609,0.391,0.000,0.607,0.393,0.000,0.595,0.405,0.000,0.596,0.404,0.000,0.602,0.398,0.000,0.598,0.402,0.000,0.606,0.394,0.000,0.600,0.400,0.000,0.599,0.401,0.000,0.602,0.398,0.000,0.601,0.399,0.000,0.605,0.395,0.000,0.609,0.391,0.000,0.618,0.382,0.000,0.621,0.379,0.000,0.623,0.377,0.000,0.625,0.375,0.000,0.620,0.380,0.000,0.624,0.376,0.000,0.635,0.365,0.000,0.633,0.367,0.000,0.629,0.371,0.000,0.636,0.364,0.000,0.637,0.363,0.000,0.638,0.362,0.000,0.639,0.361,0.000,0.637,0.363,0.000,0.642,0.358,0.000,0.642,0.358,0.000,0.642,0.358,0.000,0.643,0.357,0.000,0.646,0.354,0.000,0.649,0.351,0.000,0.650,0.350,0.000,0.485,0.515,0.000,0.486,0.514,0.000,0.498,0.502,0.000,0.490,0.510,0.000,0.489,0.511,0.000,0.487,0.513,0.000,0.492,0.508,0.000,0.488,0.512,0.000,0.505,0.495,0.000,0.489,0.511,0.000,0.487,0.513,0.000,0.490,0.510,0.000,0.492,0.508,0.000,0.488,0.512,0.000,0.492,0.508,0.000,0.507,0.493,0.000,0.492,0.508,0.000,0.500,0.500,0.000,0.489,0.511,0.000,0.489,0.511,0.000,0.489,0.511,0.000,0.493,0.507,0.000,0.495,0.505,0.000,0.501,0.499,0.000,0.490,0.510,0.000,0.514,0.486,0.000,0.496,0.504,0.000,0.498,0.502,0.000,0.503,0.497,0.000,0.498,0.502,0.000,0.500,0.500,0.000,0.497,0.503,0.000,0.504,0.496,0.000,0.498,0.502,0.000,0.497,0.503,0.000,0.501,0.499,0.000,0.502,0.498,0.000,0.501,0.499,0.000,0.498,0.502,0.000,0.500,0.500,0.000,0.506,0.494,0.000,0.502,0.498,0.000,0.505,0.495,0.000,0.508,0.492,0.000,0.507,0.493,0.000,0.513,0.487,0.000,0.514,0.486,0.000,0.515,0.485,0.000,0.511,0.489,0.000,0.517,0.483,0.000,0.517,0.483,0.000,0.515,0.485,0.000,0.524,0.476,0.000,0.533,0.467};
			return value;
		}
		private double[] getColor_9_22_color_4()
		{
			double[] value = {0.000,0.522,0.478,0.000,0.527,0.473,0.000,0.536,0.464,0.000,0.534,0.466,0.000,0.528,0.472,0.000,0.544,0.456,0.000,0.549,0.451,0.000,0.540,0.460,0.000,0.557,0.443,0.000,0.565,0.435,0.000,0.543,0.457,0.000,0.565,0.435,0.000,0.561,0.439,0.000,0.553,0.447,0.000,0.569,0.431,0.000,0.568,0.432,0.000,0.574,0.426,0.000,0.581,0.419,0.000,0.568,0.432,0.000,0.579,0.421,0.000,0.587,0.413,0.000,0.585,0.415,0.000,0.587,0.413,0.000,0.588,0.412,0.000,0.580,0.420,0.000,0.581,0.419,0.000,0.585,0.415,0.000,0.589,0.411,0.000,0.592,0.408,0.000,0.581,0.419,0.000,0.590,0.410,0.000,0.596,0.404,0.000,0.598,0.402,0.000,0.591,0.409,0.000,0.610,0.390,0.000,0.616,0.384,0.000,0.619,0.381,0.000,0.608,0.392,0.000,0.621,0.379,0.000,0.621,0.379,0.000,0.618,0.382,0.000,0.606,0.394,0.000,0.609,0.391,0.000,0.605,0.395,0.000,0.619,0.381,0.000,0.616,0.384,0.000,0.613,0.387,0.000,0.602,0.398,0.000,0.609,0.391,0.000,0.600,0.400,0.000,0.603,0.397,0.000,0.601,0.399,0.000,0.600,0.400,0.000,0.598,0.402,0.000,0.599,0.401,0.000,0.635,0.365,0.000,0.637,0.363,0.000,0.638,0.362,0.000,0.638,0.362,0.000,0.641,0.359,0.000,0.644,0.356,0.000,0.643,0.357,0.000,0.504,0.496,0.000,0.524,0.476,0.000,0.509,0.491,0.000,0.526,0.474,0.000,0.512,0.488,0.000,0.505,0.495,0.000,0.529,0.471,0.000,0.509,0.491,0.000,0.510,0.490,0.000,0.511,0.489,0.000,0.514,0.486,0.000,0.513,0.487,0.000,0.534,0.466,0.000,0.510,0.490,0.000,0.516,0.484,0.000,0.514,0.486,0.000,0.515,0.485,0.000,0.518,0.482,0.000,0.517,0.483,0.000,0.516,0.484,0.000,0.530,0.470,0.000,0.530,0.470,0.000,0.538,0.462,0.000,0.537,0.463,0.000,0.569,0.431,0.000,0.576,0.424,0.000,0.543,0.457,0.000,0.577,0.423,0.000,0.566,0.434,0.000,0.563,0.437,0.000,0.585,0.415,0.000,0.586,0.414,0.000,0.541,0.459,0.000,0.590,0.410,0.000,0.578,0.422,0.000,0.552,0.448,0.000,0.617,0.383,0.000,0.624,0.376};
			return value;
		}
		private double[] getColor_9_22_color_5()
		{
			double[] value = {0.000,0.608,0.392,0.000,0.601,0.399,0.000,0.619,0.381,0.000,0.626,0.374,0.000,0.633,0.367,0.000,0.634,0.366,0.000,0.635,0.365,0.000,0.633,0.367,0.000,0.521,0.479,0.000,0.522,0.478,0.000,0.494,0.506,0.000,0.498,0.502,0.000,0.491,0.509,0.000,0.499,0.501,0.000,0.497,0.503,0.000,0.496,0.504,0.000,0.485,0.515,0.000,0.476,0.524,0.000,0.475,0.525,0.000,0.490,0.510,0.000,0.475,0.525,0.000,0.488,0.512,0.000,0.499,0.501,0.000,0.477,0.523,0.000,0.478,0.522,0.000,0.479,0.521,0.000,0.499,0.501,0.000,0.506,0.494,0.000,0.482,0.518,0.000,0.509,0.491,0.000,0.509,0.491,0.000,0.508,0.492,0.000,0.487,0.513,0.000,0.487,0.513,0.000,0.491,0.509,0.000,0.493,0.507,0.000,0.524,0.476,0.000,0.516,0.484,0.000,0.510,0.490,0.000,0.536,0.464,0.000,0.544,0.456,0.000,0.514,0.486,0.000,0.519,0.481,0.000,0.508,0.492,0.000,0.510,0.490,0.000,0.542,0.458,0.000,0.531,0.469,0.000,0.540,0.460,0.000,0.555,0.445,0.000,0.535,0.465,0.000,0.536,0.464,0.000,0.520,0.480,0.000,0.538,0.462,0.000,0.546,0.454,0.000,0.525,0.475,0.000,0.557,0.443,0.000,0.537,0.463,0.000,0.560,0.440,0.000,0.568,0.432,0.000,0.532,0.468,0.000,0.539,0.461,0.000,0.534,0.466,0.000,0.543,0.457,0.000,0.534,0.466,0.000,0.560,0.440,0.000,0.604,0.396,0.000,0.588,0.412,0.000,0.619,0.381,0.000,0.610,0.390,0.000,0.586,0.414,0.000,0.495,0.505,0.000,0.504,0.496,0.000,0.507,0.493,0.000,0.507,0.493,0.000,0.494,0.506,0.000,0.497,0.503,0.000,0.516,0.484,0.000,0.516,0.484,0.000,0.517,0.483,0.000,0.515,0.485,0.000,0.524,0.476,0.000,0.476,0.524,0.000,0.469,0.531,0.000,0.482,0.518,0.000,0.486,0.514,0.000,0.491,0.509,0.000,0.487,0.513,0.000,0.535,0.465,0.000,0.598,0.402,0.000,0.604,0.396,0.000,0.591,0.409,0.000,0.582,0.418,0.000,0.586,0.414,0.000,0.616,0.384,0.000,0.614,0.386,0.000,0.629,0.371,0.000,0.629,0.371,0.000,0.627,0.373,0.000,0.648,0.352,0.000,0.649,0.351};
			return value;
		}
		private double[] getColor_9_22_color_6()
		{
			double[] value = {0.000,0.644,0.356,0.000,0.655,0.345,0.000,0.651,0.349,0.000,0.644,0.356,0.000,0.645,0.355,0.000,0.648,0.352,0.000,0.667,0.333,0.000,0.675,0.325,0.000,0.658,0.342,0.000,0.652,0.348,0.000,0.654,0.346,0.000,0.675,0.325,0.000,0.653,0.347,0.000,0.670,0.330,0.000,0.667,0.333,0.000,0.676,0.324,0.000,0.693,0.307,0.000,0.682,0.318,0.000,0.671,0.329,0.000,0.509,0.491,0.000,0.508,0.492,0.000,0.515,0.485,0.000,0.527,0.473,0.000,0.524,0.476,0.000,0.528,0.472,0.000,0.525,0.475,0.000,0.525,0.475,0.000,0.533,0.467,0.000,0.529,0.471,0.000,0.490,0.510,0.000,0.502,0.498,0.000,0.505,0.495,0.000,0.501,0.499,0.000,0.492,0.508,0.000,0.626,0.374,0.000,0.625,0.375,0.000,0.633,0.367,0.000,0.635,0.365,0.000,0.654,0.346,0.000,0.627,0.373,0.000,0.639,0.361,0.000,0.643,0.357,0.000,0.666,0.334,0.000,0.653,0.347,0.000,0.670,0.330,0.000,0.667,0.333,0.000,0.635,0.365,0.000,0.668,0.332,0.000,0.672,0.328,0.000,0.660,0.340,0.000,0.679,0.321,0.000,0.677,0.323,0.000,0.664,0.336,0.000,0.686,0.314,0.000,0.686,0.314,0.000,0.677,0.323,0.000,0.678,0.322,0.000,0.683,0.317,0.000,0.683,0.317,0.000,0.692,0.308,0.000,0.686,0.314,0.000,0.686,0.314,0.000,0.684,0.316,0.000,0.690,0.310,0.000,0.684,0.316,0.000,0.700,0.300,0.000,0.689,0.311,0.000,0.707,0.293,0.000,0.705,0.295,0.000,0.714,0.286,0.000,0.708,0.292,0.000,0.707,0.293,0.000,0.709,0.291,0.000,0.709,0.291,0.000,0.713,0.287,0.000,0.718,0.282,0.000,0.707,0.293,0.000,0.711,0.289,0.000,0.725,0.275,0.000,0.725,0.275,0.000,0.738,0.262,0.000,0.734,0.266,0.000,0.515,0.485,0.000,0.517,0.483,0.000,0.509,0.491,0.000,0.516,0.484,0.000,0.510,0.490,0.000,0.518,0.482,0.000,0.519,0.481,0.000,0.521,0.479,0.000,0.519,0.481,0.000,0.521,0.479,0.000,0.518,0.482,0.000,0.520,0.480,0.000,0.519,0.481,0.000,0.523,0.477,0.000,0.525,0.475,0.000,0.527,0.473,0.000,0.528,0.472,0.000,0.532,0.468};
			return value;
		}
		private double[] getColor_9_22_color_7()
		{
			double[] value = {0.000,0.528,0.472,0.000,0.532,0.468,0.000,0.530,0.470,0.000,0.535,0.465,0.000,0.542,0.458,0.000,0.543,0.457,0.000,0.546,0.454,0.000,0.544,0.456,0.000,0.544,0.456,0.000,0.548,0.452,0.000,0.547,0.453,0.000,0.550,0.450,0.000,0.551,0.449,0.000,0.551,0.449,0.000,0.548,0.452,0.000,0.509,0.491,0.000,0.512,0.488,0.000,0.653,0.347,0.000,0.654,0.346,0.000,0.654,0.346,0.000,0.657,0.343,0.000,0.657,0.343,0.000,0.659,0.341,0.000,0.661,0.339,0.000,0.664,0.336,0.000,0.663,0.337,0.000,0.662,0.338,0.000,0.667,0.333,0.000,0.667,0.333,0.000,0.667,0.333,0.000,0.668,0.332,0.000,0.679,0.321,0.000,0.680,0.320,0.000,0.684,0.316,0.000,0.683,0.317,0.000,0.686,0.314,0.000,0.686,0.314,0.000,0.699,0.301,0.000,0.688,0.312,0.000,0.700,0.300,0.000,0.691,0.309,0.000,0.692,0.308,0.000,0.693,0.307,0.000,0.699,0.301,0.000,0.692,0.308,0.000,0.701,0.299,0.000,0.696,0.304,0.000,0.698,0.302,0.000,0.709,0.291,0.000,0.710,0.290,0.000,0.702,0.298,0.000,0.709,0.291,0.000,0.709,0.291,0.000,0.708,0.292,0.000,0.705,0.295,0.000,0.718,0.282,0.000,0.728,0.272,0.000,0.720,0.280,0.000,0.736,0.264,0.000,0.728,0.272,0.000,0.736,0.264,0.000,0.736,0.264,0.000,0.736,0.264,0.000,0.736,0.264,0.000,0.731,0.269,0.000,0.740,0.260,0.000,0.733,0.267,0.000,0.734,0.266,0.000,0.737,0.263,0.000,0.736,0.264,0.000,0.739,0.261,0.000,0.737,0.263,0.000,0.740,0.260,0.000,0.743,0.257,0.000,0.734,0.266,0.000,0.739,0.261,0.000,0.740,0.260,0.000,0.751,0.249,0.000,0.742,0.258,0.000,0.741,0.259,0.000,0.743,0.257,0.000,0.757,0.243,0.000,0.523,0.477,0.000,0.524,0.476,0.000,0.526,0.474,0.000,0.527,0.473,0.000,0.529,0.471,0.000,0.533,0.467,0.000,0.534,0.466,0.000,0.532,0.468,0.000,0.533,0.467,0.000,0.534,0.466,0.000,0.535,0.465,0.000,0.534,0.466,0.000,0.535,0.465,0.000,0.535,0.465,0.000,0.537,0.463,0.000,0.538,0.462,0.000,0.539,0.461,0.000,0.539,0.461};
			return value;
		}
		private double[] getColor_9_22_color_8()
		{
			double[] value = {0.000,0.539,0.461,0.000,0.540,0.460,0.000,0.540,0.460,0.000,0.540,0.460,0.000,0.542,0.458,0.000,0.542,0.458,0.000,0.541,0.459,0.000,0.543,0.457,0.000,0.542,0.458,0.000,0.546,0.454,0.000,0.547,0.453,0.000,0.550,0.450,0.000,0.551,0.449,0.000,0.550,0.450,0.000,0.551,0.449,0.000,0.552,0.448,0.000,0.556,0.444,0.000,0.554,0.446,0.000,0.517,0.483,0.000,0.516,0.484,0.000,0.519,0.481,0.000,0.519,0.481,0.000,0.521,0.479,0.000,0.520,0.480,0.000,0.527,0.473,0.000,0.528,0.472,0.000,0.653,0.347,0.000,0.651,0.349,0.000,0.659,0.341,0.000,0.659,0.341,0.000,0.672,0.328,0.000,0.699,0.301,0.000,0.699,0.301,0.000,0.699,0.301,0.000,0.700,0.300,0.000,0.689,0.311,0.000,0.700,0.300,0.000,0.690,0.310,0.000,0.692,0.308,0.000,0.690,0.310,0.000,0.705,0.295,0.000,0.695,0.305,0.000,0.692,0.308,0.000,0.693,0.307,0.000,0.703,0.297,0.000,0.697,0.303,0.000,0.691,0.309,0.000,0.703,0.297,0.000,0.695,0.305,0.000,0.704,0.296,0.000,0.697,0.303,0.000,0.710,0.290,0.000,0.705,0.295,0.000,0.696,0.304,0.000,0.712,0.288,0.000,0.722,0.278,0.000,0.721,0.279,0.000,0.724,0.276,0.000,0.727,0.273,0.000,0.728,0.272,0.000,0.729,0.271,0.000,0.730,0.270,0.000,0.731,0.269,0.000,0.733,0.267,0.000,0.729,0.271,0.000,0.731,0.269,0.000,0.735,0.265,0.000,0.736,0.264,0.000,0.735,0.265,0.000,0.738,0.262,0.000,0.737,0.263,0.000,0.734,0.266,0.000,0.735,0.265,0.000,0.734,0.266,0.000,0.733,0.267,0.000,0.732,0.268,0.000,0.738,0.262,0.000,0.740,0.260,0.000,0.741,0.259,0.000,0.734,0.266,0.000,0.735,0.265,0.000,0.734,0.266,0.000,0.735,0.265,0.000,0.741,0.259,0.000,0.735,0.265,0.000,0.743,0.257,0.000,0.743,0.257,0.000,0.735,0.265,0.000,0.745,0.255,0.000,0.741,0.259,0.000,0.742,0.258,0.000,0.748,0.252,0.000,0.753,0.247,0.000,0.757,0.243,0.000,0.758,0.242,0.000,0.023,0.977,0.000,0.028,0.972,0.000,0.040,0.960,0.000,0.052,0.948,0.000,0.049,0.951};
			return value;
		}
		private double[] getColor_9_22_color_9()
		{
			double[] value = {0.000,0.052,0.948,0.000,0.048,0.952,0.000,0.164,0.836,0.000,0.241,0.759,0.000,0.214,0.786,0.000,0.207,0.793,0.000,0.303,0.697,0.000,0.272,0.728,0.000,0.262,0.738,0.000,0.288,0.712,0.000,0.280,0.720,0.000,0.288,0.712,0.000,0.268,0.732,0.000,0.328,0.672,0.000,0.281,0.719,0.000,0.338,0.662,0.000,0.341,0.659,0.000,0.324,0.676,0.000,0.296,0.704,0.000,0.338,0.662,0.000,0.325,0.675,0.000,0.352,0.648,0.000,0.355,0.645,0.000,0.537,0.463,0.000,0.539,0.461,0.000,0.540,0.460,0.000,0.542,0.458,0.000,0.544,0.456,0.000,0.544,0.456,0.000,0.547,0.453,0.000,0.549,0.451,0.000,0.546,0.454,0.000,0.547,0.453,0.000,0.550,0.450,0.000,0.548,0.452,0.000,0.548,0.452,0.000,0.549,0.451,0.000,0.549,0.451,0.000,0.551,0.449,0.000,0.550,0.450,0.000,0.517,0.483,0.000,0.518,0.482,0.000,0.517,0.483,0.000,0.519,0.481,0.000,0.520,0.480,0.000,0.523,0.477,0.000,0.524,0.476,0.000,0.527,0.473,0.000,0.527,0.473,0.000,0.527,0.473,0.000,0.528,0.472,0.000,0.531,0.469,0.000,0.532,0.468,0.000,0.532,0.468,0.000,0.532,0.468,0.000,0.533,0.467,0.000,0.534,0.466,0.000,0.534,0.466,0.000,0.536,0.464,0.000,0.537,0.463,0.000,0.537,0.463,0.000,0.538,0.462,0.000,0.540,0.460,0.000,0.583,0.417,0.000,0.597,0.403,0.000,0.598,0.402,0.000,0.601,0.399,0.000,0.604,0.396,0.000,0.609,0.391,0.000,0.621,0.379,0.000,0.622,0.378,0.000,0.629,0.371,0.000,0.623,0.377,0.000,0.621,0.379,0.000,0.610,0.390,0.000,0.623,0.377,0.000,0.628,0.372,0.000,0.613,0.387,0.000,0.643,0.357,0.000,0.640,0.360,0.000,0.638,0.362,0.000,0.650,0.350,0.000,0.634,0.366,0.000,0.649,0.351,0.000,0.650,0.350,0.000,0.647,0.353,0.000,0.644,0.356,0.000,0.651,0.349,0.000,0.652,0.348,0.000,0.652,0.348,0.000,0.658,0.342,0.000,0.650,0.350,0.000,0.666,0.334,0.000,0.678,0.322,0.000,0.681,0.319,0.000,0.682,0.318,0.000,0.675,0.325,0.000,0.682,0.318,0.000,0.688,0.312,0.000,0.679,0.321};
			return value;
		}
		private double[] getColor_9_22_color_10()
		{
			double[] value = {0.000,0.686,0.314,0.000,0.696,0.304,0.000,0.706,0.294,0.000,0.695,0.305,0.000,0.684,0.316,0.000,0.697,0.303,0.000,0.703,0.297,0.000,0.693,0.307,0.000,0.706,0.294,0.000,0.704,0.296,0.000,0.692,0.308,0.000,0.696,0.304,0.000,0.710,0.290,0.000,0.697,0.303,0.000,0.711,0.289,0.000,0.707,0.293,0.000,0.691,0.309,0.000,0.707,0.293,0.000,0.712,0.288,0.000,0.693,0.307,0.000,0.692,0.308,0.000,0.729,0.271,0.000,0.726,0.274,0.000,0.735,0.265,0.000,0.736,0.264,0.000,0.739,0.261,0.000,0.737,0.263,0.000,0.736,0.264,0.000,0.738,0.262,0.000,0.740,0.260,0.000,0.740,0.260,0.000,0.738,0.262,0.000,0.738,0.262,0.000,0.746,0.254,0.000,0.740,0.260,0.000,0.747,0.253,0.000,0.738,0.262,0.000,0.739,0.261,0.000,0.741,0.259,0.000,0.747,0.253,0.000,0.755,0.245,0.000,0.015,0.985,0.000,0.018,0.982,0.000,0.019,0.981,0.000,0.005,0.995,0.000,0.000,1.000,0.000,0.006,0.994,0.000,0.003,0.997,0.000,0.044,0.956,0.000,0.071,0.929,0.000,0.042,0.958,0.000,0.029,0.971,0.000,0.067,0.933,0.000,0.064,0.936,0.000,0.005,0.995,0.000,0.040,0.960,0.000,0.030,0.970,0.000,0.008,0.992,0.000,0.041,0.959,0.000,0.040,0.960,0.000,0.060,0.940,0.000,0.025,0.975,0.000,0.019,0.981,0.000,0.043,0.957,0.000,0.035,0.965,0.000,0.043,0.957,0.000,0.053,0.947,0.000,0.048,0.952,0.000,0.099,0.901,0.000,0.100,0.900,0.000,0.063,0.937,0.000,0.056,0.944,0.000,0.084,0.916,0.000,0.131,0.869,0.000,0.116,0.884,0.000,0.143,0.857,0.000,0.114,0.886,0.000,0.158,0.842,0.000,0.143,0.857,0.000,0.151,0.849,0.000,0.112,0.888,0.000,0.118,0.882,0.000,0.167,0.833,0.000,0.205,0.795,0.000,0.185,0.815,0.000,0.171,0.829,0.000,0.181,0.819,0.000,0.236,0.764,0.000,0.177,0.823,0.000,0.239,0.761,0.000,0.200,0.800,0.000,0.241,0.759,0.000,0.243,0.757,0.000,0.227,0.773,0.000,0.250,0.750,0.000,0.227,0.773,0.000,0.218,0.782,0.000,0.247,0.753,0.000,0.266,0.734,0.000,0.243,0.757};
			return value;
		}
		private double[] getColor_9_22_color_11()
		{
			double[] value = {0.000,0.261,0.739,0.000,0.277,0.723,0.000,0.302,0.698,0.000,0.297,0.703,0.000,0.309,0.691,0.000,0.317,0.683,0.000,0.310,0.690,0.000,0.267,0.733,0.000,0.288,0.712,0.000,0.318,0.682,0.000,0.281,0.719,0.000,0.317,0.683,0.000,0.330,0.670,0.000,0.331,0.669,0.000,0.332,0.668,0.000,0.272,0.728,0.000,0.325,0.675,0.000,0.334,0.666,0.000,0.333,0.667,0.000,0.343,0.657,0.000,0.337,0.663,0.000,0.338,0.662,0.000,0.346,0.654,0.000,0.340,0.660,0.000,0.337,0.663,0.000,0.544,0.456,0.000,0.549,0.451,0.000,0.548,0.452,0.000,0.526,0.474,0.000,0.521,0.479,0.000,0.522,0.478,0.000,0.523,0.477,0.000,0.530,0.470,0.000,0.540,0.460,0.000,0.525,0.475,0.000,0.540,0.460,0.000,0.528,0.472,0.000,0.528,0.472,0.000,0.528,0.472,0.000,0.530,0.470,0.000,0.530,0.470,0.000,0.530,0.470,0.000,0.532,0.468,0.000,0.538,0.462,0.000,0.532,0.468,0.000,0.532,0.468,0.000,0.534,0.466,0.000,0.534,0.466,0.000,0.534,0.466,0.000,0.535,0.465,0.000,0.535,0.465,0.000,0.538,0.462,0.000,0.540,0.460,0.000,0.541,0.459,0.000,0.541,0.459,0.000,0.540,0.460,0.000,0.541,0.459,0.000,0.542,0.458,0.000,0.544,0.456,0.000,0.544,0.456,0.000,0.547,0.453,0.000,0.556,0.444,0.000,0.561,0.439,0.000,0.559,0.441,0.000,0.554,0.446,0.000,0.556,0.444,0.000,0.570,0.430,0.000,0.599,0.401,0.000,0.588,0.412,0.000,0.563,0.437,0.000,0.552,0.448,0.000,0.585,0.415,0.000,0.567,0.433,0.000,0.548,0.452,0.000,0.589,0.411,0.000,0.558,0.442,0.000,0.564,0.436,0.000,0.628,0.372,0.000,0.627,0.373,0.000,0.612,0.388,0.000,0.623,0.377,0.000,0.620,0.380,0.000,0.631,0.369,0.000,0.631,0.369,0.000,0.635,0.365,0.000,0.623,0.377,0.000,0.631,0.369,0.000,0.621,0.379,0.000,0.639,0.361,0.000,0.620,0.380,0.000,0.618,0.382,0.000,0.639,0.361,0.000,0.648,0.352,0.000,0.643,0.357,0.000,0.652,0.348,0.000,0.655,0.345,0.000,0.645,0.355,0.000,0.654,0.346,0.000,0.656,0.344,0.000,0.652,0.348};
			return value;
		}
		private double[] getColor_9_22_color_12()
		{
			double[] value = {0.000,0.655,0.345,0.000,0.658,0.342,0.000,0.674,0.326,0.000,0.658,0.342,0.000,0.661,0.339,0.000,0.660,0.340,0.000,0.690,0.310,0.000,0.668,0.332,0.000,0.670,0.330,0.000,0.706,0.294,0.000,0.701,0.299,0.000,0.699,0.301,0.000,0.694,0.306,0.000,0.694,0.306,0.000,0.703,0.297,0.000,0.008,0.992,0.000,0.011,0.989,0.000,0.022,0.978,0.000,0.012,0.988,0.000,0.013,0.987,0.000,0.014,0.986,0.000,0.018,0.982,0.000,0.021,0.979,0.000,0.020,0.980,0.000,0.061,0.939,0.000,0.106,0.894,0.000,0.178,0.822,0.000,0.537,0.463,0.000,0.539,0.461,0.000,0.540,0.460,0.000,0.540,0.460,0.000,0.542,0.458,0.000,0.542,0.458,0.000,0.542,0.458,0.000,0.543,0.457,0.000,0.548,0.452,0.000,0.546,0.454,0.000,0.587,0.413,0.000,0.585,0.415,0.000,0.601,0.399,0.000,0.608,0.392,0.000,0.561,0.439,0.000,0.595,0.405,0.000,0.591,0.409,0.000,0.599,0.401,0.000,0.576,0.424,0.000,0.602,0.398,0.000,0.601,0.399,0.000,0.610,0.390,0.000,0.606,0.394,0.000,0.567,0.433,0.000,0.590,0.410,0.000,0.577,0.423,0.000,0.644,0.356,0.000,0.644,0.356,0.000,0.660,0.340,0.000,0.661,0.339,0.000,0.652,0.348,0.000,0.502,0.498,0.000,0.504,0.496,0.000,0.504,0.496,0.000,0.546,0.454,0.000,0.534,0.466,0.000,0.513,0.487,0.000,0.564,0.436,0.000,0.522,0.478,0.000,0.564,0.436,0.000,0.577,0.423,0.000,0.580,0.420,0.000,0.580,0.420,0.000,0.491,0.509,0.000,0.494,0.506,0.000,0.493,0.507,0.000,0.498,0.502,0.000,0.515,0.485,0.000,0.496,0.504,0.000,0.496,0.504,0.000,0.519,0.481,0.000,0.496,0.504,0.000,0.497,0.503,0.000,0.502,0.498,0.000,0.506,0.494,0.000,0.500,0.500,0.000,0.500,0.500,0.000,0.525,0.475,0.000,0.504,0.496,0.000,0.537,0.463,0.000,0.512,0.488,0.000,0.525,0.475,0.000,0.516,0.484,0.000,0.501,0.499,0.000,0.499,0.501,0.000,0.525,0.475,0.000,0.509,0.491,0.000,0.558,0.442,0.000,0.563,0.437,0.000,0.574,0.426,0.000,0.553,0.447,0.000,0.604,0.396,0.000,0.611,0.389};
			return value;
		}
		private double[] getColor_9_22_color_13()
		{
			double[] value = {0.000,0.600,0.400,0.000,0.613,0.387,0.000,0.613,0.387,0.000,0.580,0.420,0.000,0.609,0.391,0.000,0.595,0.405,0.000,0.631,0.369,0.000,0.610,0.390,0.000,0.647,0.353,0.000,0.641,0.359,0.000,0.668,0.332,0.000,0.666,0.334,0.000,0.662,0.338,0.000,0.635,0.365,0.000,0.699,0.301,0.000,0.653,0.347,0.000,0.646,0.354,0.000,0.642,0.358,0.000,0.630,0.370,0.000,0.644,0.356,0.000,0.664,0.336,0.000,0.704,0.296,0.000,0.699,0.301,0.000,0.696,0.304,0.000,0.698,0.302,0.000,0.704,0.296,0.000,0.711,0.289,0.000,0.715,0.285,0.000,0.699,0.301,0.000,0.705,0.295,0.000,0.714,0.286,0.000,0.711,0.289,0.000,0.704,0.296,0.000,0.705,0.295,0.000,0.720,0.280,0.000,0.719,0.281,0.000,0.707,0.293,0.000,0.709,0.291,0.000,0.517,0.483,0.000,0.521,0.479,0.000,0.518,0.482,0.000,0.532,0.468,0.000,0.537,0.463,0.000,0.538,0.462,0.000,0.539,0.461,0.000,0.539,0.461,0.000,0.531,0.469,0.000,0.543,0.457,0.000,0.532,0.468,0.000,0.549,0.451,0.000,0.689,0.311,0.000,0.696,0.304,0.000,0.710,0.290,0.000,0.673,0.327,0.000,0.669,0.331,0.000,0.667,0.333,0.000,0.711,0.289,0.000,0.663,0.337,0.000,0.697,0.303,0.000,0.721,0.279,0.000,0.682,0.318,0.000,0.714,0.286,0.000,0.695,0.305,0.000,0.702,0.298,0.000,0.703,0.297,0.000,0.692,0.308,0.000,0.691,0.309,0.000,0.706,0.294,0.000,0.721,0.279,0.000,0.718,0.282,0.000,0.709,0.291,0.000,0.690,0.310,0.000,0.690,0.310,0.000,0.738,0.262,0.000,0.700,0.300,0.000,0.702,0.298,0.000,0.731,0.269,0.000,0.722,0.278,0.000,0.731,0.269,0.000,0.691,0.309,0.000,0.683,0.317,0.000,0.708,0.292,0.000,0.694,0.306,0.000,0.703,0.297,0.000,0.742,0.258,0.000,0.711,0.289,0.000,0.702,0.298,0.000,0.693,0.307,0.000,0.710,0.290,0.000,0.697,0.303,0.000,0.735,0.265,0.000,0.754,0.246,0.000,0.743,0.257,0.000,0.741,0.259,0.000,0.716,0.284,0.000,0.765,0.235,0.000,0.761,0.239,0.000,0.759,0.241,0.000,0.744,0.256,0.000,0.767,0.233};
			return value;
		}
		private double[] getColor_9_22_color_14()
		{
			double[] value = {0.000,0.763,0.237,0.000,0.785,0.215,0.000,0.756,0.244,0.000,0.740,0.260,0.000,0.758,0.242,0.000,0.547,0.453,0.000,0.537,0.463,0.000,0.546,0.454,0.000,0.553,0.447,0.000,0.550,0.450,0.000,0.540,0.460,0.000,0.557,0.443,0.000,0.567,0.433,0.000,0.568,0.432,0.000,0.572,0.428,0.000,0.570,0.430,0.000,0.570,0.430,0.000,0.573,0.427,0.000,0.572,0.428,0.000,0.571,0.429,0.000,0.575,0.425,0.000,0.717,0.283,0.000,0.723,0.277,0.000,0.725,0.275,0.000,0.733,0.267,0.000,0.733,0.267,0.000,0.731,0.269,0.000,0.736,0.264,0.000,0.739,0.261,0.000,0.742,0.258,0.000,0.745,0.255,0.000,0.746,0.254,0.000,0.757,0.243,0.000,0.744,0.256,0.000,0.744,0.256,0.000,0.752,0.248,0.000,0.752,0.248,0.000,0.759,0.241,0.000,0.762,0.238,0.000,0.755,0.245,0.000,0.766,0.234,0.000,0.776,0.224,0.000,0.765,0.235,0.000,0.762,0.238,0.000,0.749,0.251,0.000,0.750,0.250,0.000,0.781,0.219,0.000,0.779,0.221,0.000,0.776,0.224,0.000,0.790,0.210,0.000,0.764,0.236,0.000,0.772,0.228,0.000,0.770,0.230,0.000,0.800,0.200,0.000,0.799,0.201,0.000,0.800,0.200,0.000,0.799,0.201,0.000,0.782,0.218,0.000,0.802,0.198,0.000,0.798,0.202,0.000,0.806,0.194,0.000,0.784,0.216,0.000,0.808,0.192,0.000,0.780,0.220,0.000,0.800,0.200,0.000,0.801,0.199,0.000,0.782,0.218,0.000,0.816,0.184,0.000,0.824,0.176,0.000,0.811,0.189,0.000,0.810,0.190,0.000,0.824,0.176,0.000,0.827,0.173,0.000,0.824,0.176,0.000,0.823,0.177,0.000,0.811,0.189,0.000,0.826,0.174,0.000,0.816,0.184,0.000,0.819,0.181,0.000,0.630,0.370,0.000,0.638,0.362,0.000,0.564,0.436,0.000,0.567,0.433,0.000,0.552,0.448,0.000,0.580,0.420,0.000,0.571,0.429,0.000,0.585,0.415,0.000,0.569,0.431,0.000,0.573,0.427,0.000,0.554,0.446,0.000,0.599,0.401,0.000,0.567,0.433,0.000,0.605,0.395,0.000,0.608,0.392,0.000,0.612,0.388,0.000,0.613,0.387,0.000,0.601,0.399,0.000,0.588,0.412,0.000,0.615,0.385,0.000,0.579,0.421};
			return value;
		}
		private double[] getColor_9_22_color_15()
		{
			double[] value = {0.000,0.552,0.448,0.000,0.591,0.409,0.000,0.593,0.407,0.000,0.554,0.446,0.000,0.584,0.416,0.000,0.609,0.391,0.000,0.621,0.379,0.000,0.594,0.406,0.000,0.590,0.410,0.000,0.521,0.479,0.000,0.538,0.462,0.000,0.538,0.462,0.000,0.508,0.492,0.000,0.515,0.485,0.000,0.524,0.476,0.000,0.533,0.467,0.000,0.522,0.478,0.000,0.541,0.459,0.000,0.521,0.479,0.000,0.527,0.473,0.000,0.509,0.491,0.000,0.524,0.476,0.000,0.538,0.462,0.000,0.505,0.495,0.000,0.500,0.500,0.000,0.533,0.467,0.000,0.532,0.468,0.000,0.531,0.469,0.000,0.526,0.474,0.000,0.546,0.454,0.000,0.491,0.509,0.000,0.519,0.481,0.000,0.510,0.490,0.000,0.494,0.506,0.000,0.556,0.444,0.000,0.556,0.444,0.000,0.557,0.443,0.000,0.557,0.443,0.000,0.555,0.445,0.000,0.557,0.443,0.000,0.558,0.442,0.000,0.557,0.443,0.000,0.563,0.437,0.000,0.562,0.438,0.000,0.562,0.438,0.000,0.564,0.436,0.000,0.563,0.437,0.000,0.569,0.431,0.000,0.567,0.433,0.000,0.565,0.435,0.000,0.565,0.435,0.000,0.565,0.435,0.000,0.570,0.430,0.000,0.567,0.433,0.000,0.575,0.425,0.000,0.576,0.424,0.000,0.573,0.427,0.000,0.573,0.427,0.000,0.578,0.422,0.000,0.577,0.423,0.000,0.574,0.426,0.000,0.577,0.423,0.000,0.577,0.423,0.000,0.577,0.423,0.000,0.580,0.420,0.000,0.579,0.421,0.000,0.576,0.424,0.000,0.749,0.251,0.000,0.757,0.243,0.000,0.761,0.239,0.000,0.765,0.235,0.000,0.776,0.224,0.000,0.778,0.222,0.000,0.776,0.224,0.000,0.778,0.222,0.000,0.780,0.220,0.000,0.773,0.227,0.000,0.770,0.230,0.000,0.776,0.224,0.000,0.782,0.218,0.000,0.781,0.219,0.000,0.778,0.222,0.000,0.786,0.214,0.000,0.791,0.209,0.000,0.794,0.206,0.000,0.830,0.170,0.000,0.827,0.173,0.000,0.825,0.175,0.000,0.831,0.169,0.000,0.830,0.170,0.000,0.840,0.160,0.000,0.843,0.157,0.000,0.844,0.156,0.000,0.777,0.223,0.000,0.779,0.221,0.000,0.778,0.222,0.000,0.778,0.222,0.000,0.778,0.222,0.000,0.786,0.214,0.000,0.782,0.218};
			return value;
		}
		private double[] getColor_9_22_color_16()
		{
			double[] value = {0.000,0.785,0.215,0.000,0.799,0.201,0.000,0.799,0.201,0.000,0.802,0.198,0.000,0.806,0.194,0.000,0.807,0.193,0.000,0.802,0.198,0.000,0.807,0.193,0.000,0.812,0.188,0.000,0.810,0.190,0.000,0.810,0.190,0.000,0.817,0.183,0.000,0.816,0.184,0.000,0.814,0.186,0.000,0.824,0.176,0.000,0.673,0.327,0.000,0.677,0.323,0.000,0.659,0.341,0.000,0.679,0.321,0.000,0.657,0.343,0.000,0.653,0.347,0.000,0.651,0.349,0.000,0.656,0.344,0.000,0.656,0.344,0.000,0.655,0.345,0.000,0.659,0.341,0.000,0.670,0.330,0.000,0.677,0.323,0.000,0.681,0.319,0.000,0.670,0.330,0.000,0.641,0.359,0.000,0.685,0.315,0.000,0.659,0.341,0.000,0.637,0.363,0.000,0.659,0.341,0.000,0.683,0.317,0.000,0.666,0.334,0.000,0.653,0.347,0.000,0.650,0.350,0.000,0.654,0.346,0.000,0.666,0.334,0.000,0.670,0.330,0.000,0.679,0.321,0.000,0.672,0.328,0.000,0.683,0.317,0.000,0.654,0.346,0.000,0.675,0.325,0.000,0.676,0.324,0.000,0.683,0.317,0.000,0.557,0.443,0.000,0.571,0.429,0.000,0.569,0.431,0.000,0.584,0.416,0.000,0.561,0.439,0.000,0.555,0.445,0.000,0.557,0.443,0.000,0.557,0.443,0.000,0.574,0.426,0.000,0.586,0.414,0.000,0.564,0.436,0.000,0.571,0.429,0.000,0.557,0.443,0.000,0.562,0.438,0.000,0.558,0.442,0.000,0.594,0.406,0.000,0.563,0.437,0.000,0.575,0.425,0.000,0.576,0.424,0.000,0.593,0.407,0.000,0.594,0.406,0.000,0.575,0.425,0.000,0.567,0.433,0.000,0.594,0.406,0.000,0.593,0.407,0.000,0.579,0.421,0.000,0.589,0.411,0.000,0.618,0.382,0.000,0.593,0.407,0.000,0.616,0.384,0.000,0.598,0.402,0.000,0.596,0.404,0.000,0.619,0.381,0.000,0.600,0.400,0.000,0.623,0.377,0.000,0.624,0.376,0.000,0.595,0.405,0.000,0.596,0.404,0.000,0.630,0.370,0.000,0.598,0.402,0.000,0.604,0.396,0.000,0.605,0.395,0.000,0.613,0.387,0.000,0.628,0.372,0.000,0.544,0.456,0.000,0.535,0.465,0.000,0.532,0.468,0.000,0.532,0.468,0.000,0.544,0.456,0.000,0.526,0.474,0.000,0.529,0.471};
			return value;
		}
		private double[] getColor_9_22_color_17()
		{
			double[] value = {0.000,0.520,0.480,0.000,0.526,0.474,0.000,0.551,0.449,0.000,0.554,0.446,0.000,0.550,0.450,0.000,0.552,0.448,0.000,0.547,0.453,0.000,0.538,0.462,0.000,0.543,0.457,0.000,0.536,0.464,0.000,0.528,0.472,0.000,0.543,0.457,0.000,0.545,0.455,0.000,0.535,0.465,0.000,0.508,0.492,0.000,0.544,0.456,0.000,0.523,0.477,0.000,0.522,0.478,0.000,0.505,0.495,0.000,0.503,0.497,0.000,0.523,0.477,0.000,0.545,0.455,0.000,0.554,0.446,0.000,0.517,0.483,0.000,0.502,0.498,0.000,0.504,0.496,0.000,0.503,0.497,0.000,0.502,0.498,0.000,0.501,0.499,0.000,0.495,0.505,0.000,0.511,0.489,0.000,0.502,0.498,0.000,0.505,0.495,0.000,0.492,0.508,0.000,0.501,0.499,0.000,0.496,0.504,0.000,0.504,0.496,0.000,0.496,0.504,0.000,0.064,0.936,0.000,0.052,0.948,0.000,0.044,0.956,0.000,0.043,0.957,0.000,0.047,0.953,0.000,0.044,0.956,0.000,0.073,0.927,0.000,0.148,0.852,0.000,0.072,0.928,0.000,0.125,0.875,0.000,0.169,0.831,0.000,0.153,0.847,0.000,0.167,0.833,0.000,0.224,0.776,0.000,0.236,0.764,0.000,0.306,0.694,0.000,0.241,0.759,0.000,0.305,0.695,0.000,0.269,0.731,0.000,0.303,0.697,0.000,0.321,0.679,0.000,0.354,0.646,0.000,0.363,0.637,0.000,0.348,0.652,0.000,0.352,0.648,0.000,0.358,0.642,0.000,0.365,0.635,0.000,0.382,0.618,0.000,0.400,0.600,0.000,0.362,0.638,0.000,0.558,0.442,0.000,0.558,0.442,0.000,0.556,0.444,0.000,0.560,0.440,0.000,0.558,0.442,0.000,0.559,0.441,0.000,0.561,0.439,0.000,0.562,0.438,0.000,0.563,0.437,0.000,0.565,0.435,0.000,0.567,0.433,0.000,0.567,0.433,0.000,0.565,0.435,0.000,0.569,0.431,0.000,0.568,0.432,0.000,0.572,0.428,0.000,0.572,0.428,0.000,0.563,0.437,0.000,0.572,0.428,0.000,0.572,0.428,0.000,0.574,0.426,0.000,0.574,0.426,0.000,0.573,0.427,0.000,0.574,0.426,0.000,0.565,0.435,0.000,0.575,0.425,0.000,0.577,0.423,0.000,0.576,0.424,0.000,0.566,0.434,0.000,0.577,0.423,0.000,0.567,0.433,0.000,0.576,0.424};
			return value;
		}
		private double[] getColor_9_22_color_18()
		{
			double[] value = {0.000,0.569,0.431,0.000,0.769,0.231,0.000,0.772,0.228,0.000,0.777,0.223,0.000,0.779,0.221,0.000,0.784,0.216,0.000,0.833,0.167,0.000,0.834,0.166,0.000,0.834,0.166,0.000,0.834,0.166,0.000,0.836,0.164,0.000,0.838,0.162,0.000,0.839,0.161,0.000,0.840,0.160,0.000,0.842,0.158,0.000,0.778,0.222,0.000,0.778,0.222,0.000,0.777,0.223,0.000,0.777,0.223,0.000,0.779,0.221,0.000,0.778,0.222,0.000,0.780,0.220,0.000,0.778,0.222,0.000,0.783,0.217,0.000,0.783,0.217,0.000,0.780,0.220,0.000,0.782,0.218,0.000,0.781,0.219,0.000,0.781,0.219,0.000,0.784,0.216,0.000,0.784,0.216,0.000,0.788,0.212,0.000,0.796,0.204,0.000,0.801,0.199,0.000,0.801,0.199,0.000,0.803,0.197,0.000,0.813,0.187,0.000,0.814,0.186,0.000,0.820,0.180,0.000,0.821,0.179,0.000,0.821,0.179,0.000,0.820,0.180,0.000,0.822,0.178,0.000,0.823,0.177,0.000,0.825,0.175,0.000,0.822,0.178,0.000,0.823,0.177,0.000,0.828,0.172,0.000,0.832,0.168,0.000,0.834,0.166,0.000,0.833,0.167,0.000,0.832,0.168,0.000,0.839,0.161,0.000,0.838,0.162,0.000,0.843,0.157,0.000,0.847,0.153,0.000,0.843,0.157,0.000,0.847,0.153,0.000,0.678,0.322,0.000,0.682,0.318,0.000,0.673,0.327,0.000,0.662,0.338,0.000,0.677,0.323,0.000,0.689,0.311,0.000,0.704,0.296,0.000,0.700,0.300,0.000,0.693,0.307,0.000,0.686,0.314,0.000,0.681,0.319,0.000,0.699,0.301,0.000,0.665,0.335,0.000,0.700,0.300,0.000,0.673,0.327,0.000,0.704,0.296,0.000,0.680,0.320,0.000,0.690,0.310,0.000,0.582,0.418,0.000,0.570,0.430,0.000,0.544,0.456,0.000,0.528,0.472,0.000,0.556,0.444,0.000,0.559,0.441,0.000,0.558,0.442,0.000,0.558,0.442,0.000,0.510,0.490,0.000,0.552,0.448,0.000,0.553,0.447,0.000,0.508,0.492,0.000,0.563,0.437,0.000,0.523,0.477,0.000,0.559,0.441,0.000,0.506,0.494,0.000,0.508,0.492,0.000,0.545,0.455,0.000,0.528,0.472,0.000,0.568,0.432,0.000,0.026,0.974,0.000,0.031,0.969,0.000,0.039,0.961,0.000,0.049,0.951};
			return value;
		}
		private double[] getColor_9_22_color_19()
		{
			double[] value = {0.000,0.036,0.964,0.000,0.036,0.964,0.000,0.036,0.964,0.000,0.041,0.959,0.000,0.039,0.961,0.000,0.043,0.957,0.000,0.043,0.957,0.000,0.048,0.952,0.000,0.074,0.926,0.000,0.068,0.932,0.000,0.070,0.930,0.000,0.060,0.940,0.000,0.056,0.944,0.000,0.077,0.923,0.000,0.068,0.932,0.000,0.130,0.870,0.000,0.129,0.871,0.000,0.074,0.926,0.000,0.117,0.883,0.000,0.102,0.898,0.000,0.074,0.926,0.000,0.118,0.882,0.000,0.149,0.851,0.000,0.183,0.817,0.000,0.170,0.830,0.000,0.177,0.823,0.000,0.175,0.825,0.000,0.187,0.813,0.000,0.149,0.851,0.000,0.206,0.794,0.000,0.170,0.830,0.000,0.190,0.810,0.000,0.242,0.758,0.000,0.255,0.745,0.000,0.228,0.772,0.000,0.222,0.778,0.000,0.292,0.708,0.000,0.285,0.715,0.000,0.226,0.774,0.000,0.342,0.658,0.000,0.354,0.646,0.000,0.320,0.680,0.000,0.350,0.650,0.000,0.344,0.656,0.000,0.291,0.709,0.000,0.349,0.651,0.000,0.343,0.657,0.000,0.346,0.654,0.000,0.335,0.665,0.000,0.353,0.647,0.000,0.354,0.646,0.000,0.372,0.628,0.000,0.390,0.610,0.000,0.372,0.628,0.000,0.384,0.616,0.000,0.392,0.608,0.000,0.382,0.618,0.000,0.442,0.558,0.000,0.433,0.567,0.000,0.436,0.564,0.000,0.433,0.567,0.000,0.431,0.569,0.000,0.437,0.563,0.000,0.427,0.573,0.000,0.460,0.540,0.000,0.438,0.562,0.000,0.516,0.484,0.000,0.475,0.525,0.000,0.512,0.488,0.000,0.484,0.516,0.000,0.494,0.506,0.000,0.473,0.527,0.000,0.511,0.489,0.000,0.512,0.488,0.000,0.500,0.500,0.000,0.514,0.486,0.000,0.475,0.525,0.000,0.477,0.523,0.000,0.515,0.485,0.000,0.478,0.522,0.000,0.483,0.517,0.000,0.483,0.517,0.000,0.467,0.533,0.000,0.497,0.503,0.000,0.466,0.534,0.000,0.522,0.478,0.000,0.473,0.527,0.000,0.544,0.456,0.000,0.489,0.511,0.000,0.545,0.455,0.000,0.541,0.459,0.000,0.491,0.509,0.000,0.512,0.488,0.000,0.479,0.521,0.000,0.488,0.512,0.000,0.489,0.511,0.000,0.549,0.451,0.000,0.550,0.450,0.000,0.549,0.451,0.000,0.551,0.449};
			return value;
		}
		private double[] getColor_9_22_color_20()
		{
			double[] value = {0.000,0.549,0.451,0.000,0.551,0.449,0.000,0.553,0.447,0.000,0.551,0.449,0.000,0.556,0.444,0.000,0.548,0.452,0.000,0.552,0.448,0.000,0.543,0.457,0.000,0.557,0.443,0.000,0.553,0.447,0.000,0.551,0.449,0.000,0.550,0.450,0.000,0.539,0.461,0.000,0.546,0.454,0.000,0.547,0.453,0.000,0.553,0.447,0.000,0.560,0.440,0.000,0.528,0.472,0.000,0.553,0.447,0.000,0.541,0.459,0.000,0.531,0.469,0.000,0.545,0.455,0.000,0.559,0.441,0.000,0.536,0.464,0.000,0.554,0.446,0.000,0.541,0.459,0.000,0.538,0.462,0.000,0.538,0.462,0.000,0.552,0.448,0.000,0.529,0.471,0.000,0.542,0.458,0.000,0.737,0.263,0.000,0.735,0.265,0.000,0.737,0.263,0.000,0.755,0.245,0.000,0.743,0.257,0.000,0.744,0.256,0.000,0.740,0.260,0.000,0.740,0.260,0.000,0.751,0.249,0.000,0.761,0.239,0.000,0.765,0.235,0.000,0.753,0.247,0.000,0.759,0.241,0.000,0.777,0.223,0.000,0.778,0.222,0.000,0.776,0.224,0.000,0.785,0.215,0.000,0.785,0.215,0.000,0.783,0.217,0.000,0.782,0.218,0.000,0.786,0.214,0.000,0.784,0.216,0.000,0.785,0.215,0.000,0.784,0.216,0.000,0.786,0.214,0.000,0.788,0.212,0.000,0.799,0.201,0.000,0.797,0.203,0.000,0.788,0.212,0.000,0.794,0.206,0.000,0.787,0.213,0.000,0.790,0.210,0.000,0.789,0.211,0.000,0.798,0.202,0.000,0.790,0.210,0.000,0.796,0.204,0.000,0.805,0.195,0.000,0.789,0.211,0.000,0.791,0.209,0.000,0.791,0.209,0.000,0.810,0.190,0.000,0.792,0.208,0.000,0.794,0.206,0.000,0.812,0.188,0.000,0.791,0.209,0.000,0.791,0.209,0.000,0.808,0.192,0.000,0.792,0.208,0.000,0.792,0.208,0.000,0.796,0.204,0.000,0.811,0.189,0.000,0.795,0.205,0.000,0.807,0.193,0.000,0.825,0.175,0.000,0.822,0.178,0.000,0.823,0.177,0.000,0.834,0.166,0.000,0.028,0.972,0.000,0.046,0.954,0.000,0.040,0.960,0.000,0.043,0.957,0.000,0.052,0.948,0.000,0.053,0.947,0.000,0.257,0.743,0.000,0.300,0.700,0.000,0.338,0.662,0.000,0.338,0.662,0.000,0.344,0.656,0.000,0.341,0.659};
			return value;
		}
		private double[] getColor_9_22_color_21()
		{
			double[] value = {0.000,0.370,0.630,0.000,0.346,0.654,0.000,0.343,0.657,0.000,0.386,0.614,0.000,0.394,0.606,0.000,0.353,0.647,0.000,0.358,0.642,0.000,0.350,0.650,0.000,0.437,0.563,0.000,0.436,0.564,0.000,0.401,0.599,0.000,0.379,0.621,0.000,0.432,0.568,0.000,0.402,0.598,0.000,0.405,0.595,0.000,0.438,0.562,0.000,0.422,0.578,0.000,0.477,0.523,0.000,0.474,0.526,0.000,0.470,0.530,0.000,0.472,0.528,0.000,0.466,0.534,0.000,0.472,0.528,0.000,0.483,0.517,0.000,0.526,0.474,0.000,0.478,0.522,0.000,0.475,0.525,0.000,0.491,0.509,0.000,0.474,0.526,0.000,0.482,0.518,0.000,0.480,0.520,0.000,0.505,0.495,0.000,0.550,0.450,0.000,0.549,0.451,0.000,0.550,0.450,0.000,0.550,0.450,0.000,0.550,0.450,0.000,0.552,0.448,0.000,0.553,0.447,0.000,0.554,0.446,0.000,0.555,0.445,0.000,0.556,0.444,0.000,0.555,0.445,0.000,0.556,0.444,0.000,0.556,0.444,0.000,0.554,0.446,0.000,0.559,0.441,0.000,0.560,0.440,0.000,0.559,0.441,0.000,0.561,0.439,0.000,0.562,0.438,0.000,0.554,0.446,0.000,0.553,0.447,0.000,0.554,0.446,0.000,0.563,0.437,0.000,0.555,0.445,0.000,0.559,0.441,0.000,0.565,0.435,0.000,0.550,0.450,0.000,0.555,0.445,0.000,0.567,0.433,0.000,0.559,0.441,0.000,0.560,0.440,0.000,0.544,0.456,0.000,0.539,0.461,0.000,0.563,0.437,0.000,0.562,0.438,0.000,0.569,0.431,0.000,0.547,0.453,0.000,0.549,0.451,0.000,0.552,0.448,0.000,0.704,0.296,0.000,0.708,0.292,0.000,0.693,0.307,0.000,0.729,0.271,0.000,0.695,0.305,0.000,0.716,0.284,0.000,0.702,0.298,0.000,0.731,0.269,0.000,0.705,0.295,0.000,0.691,0.309,0.000,0.733,0.267,0.000,0.694,0.306,0.000,0.689,0.311,0.000,0.731,0.269,0.000,0.737,0.263,0.000,0.721,0.279,0.000,0.706,0.294,0.000,0.697,0.303,0.000,0.738,0.262,0.000,0.735,0.265,0.000,0.739,0.261,0.000,0.702,0.298,0.000,0.703,0.297,0.000,0.707,0.293,0.000,0.724,0.276,0.000,0.720,0.280,0.000,0.725,0.275,0.000,0.734,0.266,0.000,0.740,0.260};
			return value;
		}
		private double[] getColor_9_22_color_22()
		{
			double[] value = {0.000,0.739,0.261,0.000,0.737,0.263,0.000,0.737,0.263,0.000,0.743,0.257,0.000,0.741,0.259,0.000,0.742,0.258,0.000,0.742,0.258,0.000,0.742,0.258,0.000,0.762,0.238,0.000,0.744,0.256,0.000,0.743,0.257,0.000,0.741,0.259,0.000,0.743,0.257,0.000,0.741,0.259,0.000,0.742,0.258,0.000,0.760,0.240,0.000,0.743,0.257,0.000,0.763,0.237,0.000,0.753,0.247,0.000,0.758,0.242,0.000,0.776,0.224,0.000,0.762,0.238,0.000,0.754,0.246,0.000,0.745,0.255,0.000,0.753,0.247,0.000,0.744,0.256,0.000,0.754,0.246,0.000,0.748,0.252,0.000,0.788,0.212,0.000,0.757,0.243,0.000,0.787,0.213,0.000,0.790,0.210,0.000,0.758,0.242,0.000,0.793,0.207,0.000,0.793,0.207,0.000,0.793,0.207,0.000,0.786,0.214,0.000,0.793,0.207,0.000,0.793,0.207,0.000,0.790,0.210,0.000,0.770,0.230,0.000,0.795,0.205,0.000,0.790,0.210,0.000,0.795,0.205,0.000,0.793,0.207,0.000,0.796,0.204,0.000,0.797,0.203,0.000,0.798,0.202,0.000,0.797,0.203,0.000,0.799,0.201,0.000,0.800,0.200,0.000,0.801,0.199,0.000,0.032,0.968,0.000,0.026,0.974,0.000,0.023,0.977,0.000,0.026,0.974,0.000,0.035,0.965,0.000,0.028,0.972,0.000,0.032,0.968,0.000,0.069,0.931,0.000,0.035,0.965,0.000,0.029,0.971,0.000,0.033,0.967,0.000,0.031,0.969,0.000,0.034,0.966,0.000,0.046,0.954,0.000,0.102,0.898,0.000,0.148,0.852,0.000,0.135,0.865,0.000,0.140,0.860,0.000,0.152,0.848,0.000,0.109,0.891,0.000,0.130,0.870,0.000,0.147,0.853,0.000,0.175,0.825,0.000,0.186,0.814,0.000,0.196,0.804,0.000,0.231,0.769,0.000,0.213,0.787,0.000,0.200,0.800,0.000,0.232,0.768,0.000,0.194,0.806,0.000,0.247,0.753,0.000,0.205,0.795,0.000,0.208,0.792,0.000,0.265,0.735,0.000,0.284,0.716,0.000,0.296,0.704,0.000,0.266,0.734,0.000,0.287,0.713,0.000,0.332,0.668,0.000,0.281,0.719,0.000,0.276,0.724,0.000,0.290,0.710,0.000,0.287,0.713,0.000,0.332,0.668,0.000,0.365,0.635,0.000,0.362,0.638,0.000,0.362,0.638,0.000,0.391,0.609};
			return value;
		}
		private double[] getColor_9_22_color_23()
		{
			double[] value = {0.000,0.390,0.610,0.000,0.563,0.437,0.000,0.566,0.434,0.000,0.563,0.437,0.000,0.565,0.435,0.000,0.565,0.435,0.000,0.564,0.436,0.000,0.565,0.435,0.000,0.545,0.455,0.000,0.546,0.454,0.000,0.547,0.453,0.000,0.558,0.442,0.000,0.550,0.450,0.000,0.549,0.451,0.000,0.551,0.449,0.000,0.549,0.451,0.000,0.549,0.451,0.000,0.553,0.447,0.000,0.552,0.448,0.000,0.558,0.442,0.000,0.555,0.445,0.000,0.553,0.447,0.000,0.555,0.445,0.000,0.557,0.443,0.000,0.557,0.443,0.000,0.557,0.443,0.000,0.560,0.440,0.000,0.557,0.443,0.000,0.557,0.443,0.000,0.560,0.440,0.000,0.557,0.443,0.000,0.561,0.439,0.000,0.558,0.442,0.000,0.561,0.439,0.000,0.558,0.442,0.000,0.559,0.441,0.000,0.559,0.441,0.000,0.559,0.441,0.000,0.559,0.441,0.000,0.607,0.393,0.000,0.585,0.415,0.000,0.604,0.396,0.000,0.576,0.424,0.000,0.588,0.412,0.000,0.577,0.423,0.000,0.574,0.426,0.000,0.621,0.379,0.000,0.625,0.375,0.000,0.637,0.363,0.000,0.620,0.380,0.000,0.616,0.384,0.000,0.641,0.359,0.000,0.648,0.352,0.000,0.639,0.361,0.000,0.636,0.364,0.000,0.635,0.365,0.000,0.673,0.327,0.000,0.667,0.333,0.000,0.670,0.330,0.000,0.669,0.331,0.000,0.659,0.341,0.000,0.670,0.330,0.000,0.653,0.347,0.000,0.677,0.323,0.000,0.677,0.323,0.000,0.671,0.329,0.000,0.655,0.345,0.000,0.678,0.322,0.000,0.677,0.323,0.000,0.679,0.321,0.000,0.653,0.347,0.000,0.660,0.340,0.000,0.661,0.339,0.000,0.699,0.301,0.000,0.703,0.297,0.000,0.714,0.286,0.000,0.717,0.283,0.000,0.697,0.303,0.000,0.698,0.302,0.000,0.700,0.300,0.000,0.671,0.329,0.000,0.680,0.320,0.000,0.723,0.277,0.000,0.685,0.315,0.000,0.679,0.321,0.000,0.724,0.276,0.000,0.722,0.278,0.000,0.709,0.291,0.000,0.738,0.262,0.000,0.724,0.276,0.000,0.696,0.304,0.000,0.702,0.298,0.000,0.685,0.315,0.000,0.726,0.274,0.000,0.720,0.280,0.000,0.706,0.294,0.000,0.714,0.286,0.000,0.710,0.290,0.000,0.715,0.285,0.000,0.698,0.302};
			return value;
		}
		private double[] getColor_9_22_color_24()
		{
			double[] value = {0.000,0.728,0.272,0.000,0.715,0.285,0.000,0.702,0.298,0.000,0.727,0.273,0.000,0.728,0.272,0.000,0.712,0.288,0.000,0.712,0.288,0.000,0.748,0.252,0.000,0.747,0.253,0.000,0.743,0.257,0.000,0.746,0.254,0.000,0.742,0.258,0.000,0.749,0.251,0.000,0.749,0.251,0.000,0.751,0.249,0.000,0.747,0.253,0.000,0.742,0.258,0.000,0.743,0.257,0.000,0.750,0.250,0.000,0.740,0.260,0.000,0.757,0.243,0.000,0.756,0.244,0.000,0.757,0.243,0.000,0.760,0.240,0.000,0.762,0.238,0.000,0.038,0.962,0.000,0.091,0.909,0.000,0.039,0.961,0.000,0.045,0.955,0.000,0.042,0.958,0.000,0.096,0.904,0.000,0.127,0.873,0.000,0.109,0.891,0.000,0.108,0.892,0.000,0.560,0.440,0.000,0.552,0.448,0.000,0.559,0.441,0.000,0.552,0.448,0.000,0.551,0.449,0.000,0.553,0.447,0.000,0.554,0.446,0.000,0.558,0.442,0.000,0.555,0.445,0.000,0.557,0.443,0.000,0.558,0.442,0.000,0.557,0.443,0.000,0.558,0.442,0.000,0.558,0.442,0.000,0.557,0.443,0.000,0.560,0.440,0.000,0.559,0.441,0.000,0.587,0.413,0.000,0.591,0.409,0.000,0.598,0.402,0.000,0.584,0.416,0.000,0.592,0.408,0.000,0.591,0.409,0.000,0.594,0.406,0.000,0.597,0.403,0.000,0.596,0.404,0.000,0.586,0.414,0.000,0.597,0.403,0.000,0.601,0.399,0.000,0.601,0.399,0.000,0.598,0.402,0.000,0.597,0.403,0.000,0.602,0.398,0.000,0.604,0.396,0.000,0.604,0.396,0.000,0.597,0.403,0.000,0.605,0.395,0.000,0.604,0.396,0.000,0.606,0.394,0.000,0.576,0.424,0.000,0.568,0.432,0.000,0.594,0.406,0.000,0.595,0.405,0.000,0.616,0.384,0.000,0.619,0.381,0.000,0.608,0.392,0.000,0.627,0.373,0.000,0.625,0.375,0.000,0.617,0.383,0.000,0.622,0.378,0.000,0.651,0.349,0.000,0.625,0.375,0.000,0.611,0.389,0.000,0.611,0.389,0.000,0.639,0.361,0.000,0.609,0.391,0.000,0.623,0.377,0.000,0.656,0.344,0.000,0.659,0.341,0.000,0.665,0.335,0.000,0.677,0.323,0.000,0.669,0.331,0.000,0.680,0.320,0.000,0.683,0.317,0.000,0.679,0.321,0.000,0.655,0.345};
			return value;
		}
		private double[] getColor_9_22_color_25()
		{
			double[] value = {0.000,0.659,0.341,0.000,0.665,0.335,0.000,0.682,0.318,0.000,0.679,0.321,0.000,0.667,0.333,0.000,0.674,0.326,0.000,0.679,0.321,0.000,0.511,0.489,0.000,0.510,0.490,0.000,0.511,0.489,0.000,0.523,0.477,0.000,0.514,0.486,0.000,0.517,0.483,0.000,0.515,0.485,0.000,0.516,0.484,0.000,0.522,0.478,0.000,0.517,0.483,0.000,0.518,0.482,0.000,0.523,0.477,0.000,0.520,0.480,0.000,0.535,0.465,0.000,0.528,0.472,0.000,0.525,0.475,0.000,0.523,0.477,0.000,0.521,0.479,0.000,0.521,0.479,0.000,0.523,0.477,0.000,0.525,0.475,0.000,0.571,0.429,0.000,0.567,0.433,0.000,0.565,0.435,0.000,0.574,0.426,0.000,0.570,0.430,0.000,0.571,0.429,0.000,0.565,0.435,0.000,0.595,0.405,0.000,0.569,0.431,0.000,0.606,0.394,0.000,0.568,0.432,0.000,0.547,0.453,0.000,0.611,0.389,0.000,0.597,0.403,0.000,0.559,0.441,0.000,0.570,0.430,0.000,0.567,0.433,0.000,0.558,0.442,0.000,0.536,0.464,0.000,0.558,0.442,0.000,0.610,0.390,0.000,0.555,0.445,0.000,0.591,0.409,0.000,0.576,0.424,0.000,0.596,0.404,0.000,0.595,0.405,0.000,0.610,0.390,0.000,0.622,0.378,0.000,0.625,0.375,0.000,0.628,0.372,0.000,0.620,0.380,0.000,0.632,0.368,0.000,0.623,0.377,0.000,0.622,0.378,0.000,0.648,0.352,0.000,0.645,0.355,0.000,0.625,0.375,0.000,0.637,0.363,0.000,0.629,0.371,0.000,0.516,0.484,0.000,0.516,0.484,0.000,0.518,0.482,0.000,0.537,0.463,0.000,0.534,0.466,0.000,0.545,0.455,0.000,0.538,0.462,0.000,0.546,0.454,0.000,0.551,0.449,0.000,0.538,0.462,0.000,0.536,0.464,0.000,0.536,0.464,0.000,0.538,0.462,0.000,0.527,0.473,0.000,0.550,0.450,0.000,0.550,0.450,0.000,0.544,0.456,0.000,0.540,0.460,0.000,0.541,0.459,0.000,0.601,0.399,0.000,0.608,0.392,0.000,0.645,0.355,0.000,0.614,0.386,0.000,0.619,0.381,0.000,0.649,0.351,0.000,0.627,0.373,0.000,0.660,0.340,0.000,0.669,0.331,0.000,0.667,0.333,0.000,0.662,0.338,0.000,0.656,0.344,0.000,0.633,0.367,0.000,0.667,0.333};
			return value;
		}
		private double[] getColor_9_22_color_26()
		{
			double[] value = {0.000,0.662,0.338,0.000,0.663,0.337,0.000,0.683,0.317,0.000,0.654,0.346,0.000,0.676,0.324,0.000,0.637,0.363,0.000,0.666,0.334,0.000,0.685,0.315,0.000,0.706,0.294,0.000,0.714,0.286,0.000,0.689,0.311,0.000,0.664,0.336,0.000,0.711,0.289,0.000,0.668,0.332,0.000,0.708,0.292,0.000,0.668,0.332,0.000,0.715,0.285,0.000,0.686,0.314,0.000,0.725,0.275,0.000,0.676,0.324,0.000,0.724,0.276,0.000,0.731,0.269,0.000,0.706,0.294,0.000,0.690,0.310,0.000,0.694,0.306,0.000,0.695,0.305,0.000,0.746,0.254,0.000,0.711,0.289,0.000,0.696,0.304,0.000,0.696,0.304,0.000,0.714,0.286,0.000,0.739,0.261,0.000,0.775,0.225,0.000,0.765,0.235,0.000,0.715,0.285,0.000,0.720,0.280,0.000,0.724,0.276,0.000,0.713,0.287,0.000,0.716,0.284,0.000,0.743,0.257,0.000,0.726,0.274,0.000,0.736,0.264,0.000,0.737,0.263,0.000,0.764,0.236,0.000,0.485,0.515,0.000,0.500,0.500,0.000,0.499,0.501,0.000,0.519,0.481,0.000,0.521,0.479,0.000,0.482,0.518,0.000,0.486,0.514,0.000,0.524,0.476,0.000,0.479,0.521,0.000,0.473,0.527,0.000,0.483,0.517,0.000,0.473,0.527,0.000,0.511,0.489,0.000,0.488,0.512,0.000,0.506,0.494,0.000,0.476,0.524,0.000,0.466,0.534,0.000,0.510,0.490,0.000,0.505,0.495,0.000,0.501,0.499,0.000,0.495,0.505,0.000,0.504,0.496,0.000,0.490,0.510,0.000,0.522,0.478,0.000,0.540,0.460,0.000,0.453,0.547,0.000,0.441,0.559,0.000,0.446,0.554,0.000,0.450,0.550,0.000,0.442,0.558,0.000,0.442,0.558,0.000,0.432,0.568,0.000,0.446,0.554,0.000,0.422,0.578,0.000,0.432,0.568,0.000,0.444,0.556,0.000,0.426,0.574,0.000,0.427,0.573,0.000,0.449,0.551,0.000,0.421,0.579,0.000,0.550,0.450,0.000,0.555,0.445,0.000,0.546,0.454,0.000,0.555,0.445,0.000,0.564,0.436,0.000,0.558,0.442,0.000,0.567,0.433,0.000,0.568,0.432,0.000,0.570,0.430,0.000,0.568,0.432,0.000,0.572,0.428,0.000,0.563,0.437,0.000,0.574,0.426,0.000,0.562,0.438,0.000,0.565,0.435,0.000,0.564,0.436};
			return value;
		}
		private double[] getColor_9_22_color_27()
		{
			double[] value = {0.000,0.570,0.430,0.000,0.579,0.421,0.000,0.567,0.433,0.000,0.782,0.218,0.000,0.790,0.210,0.000,0.779,0.221,0.000,0.763,0.237,0.000,0.787,0.213,0.000,0.769,0.231,0.000,0.790,0.210,0.000,0.763,0.237,0.000,0.798,0.202,0.000,0.768,0.232,0.000,0.790,0.210,0.000,0.765,0.235,0.000,0.802,0.198,0.000,0.770,0.230,0.000,0.782,0.218,0.000,0.779,0.221,0.000,0.797,0.203,0.000,0.829,0.171,0.000,0.774,0.226,0.000,0.821,0.179,0.000,0.820,0.180,0.000,0.771,0.229,0.000,0.790,0.210,0.000,0.782,0.218,0.000,0.783,0.217,0.000,0.848,0.152,0.000,0.849,0.151,0.000,0.802,0.198,0.000,0.848,0.152,0.000,0.802,0.198,0.000,0.790,0.210,0.000,0.800,0.200,0.000,0.857,0.143,0.000,0.854,0.146,0.000,0.813,0.187,0.000,0.816,0.184,0.000,0.844,0.156,0.000,0.854,0.146,0.000,0.805,0.195,0.000,0.828,0.172,0.000,0.841,0.159,0.000,0.791,0.209,0.000,0.704,0.296,0.000,0.694,0.306,0.000,0.701,0.299,0.000,0.693,0.307,0.000,0.696,0.304,0.000,0.690,0.310,0.000,0.723,0.277,0.000,0.717,0.283,0.000,0.714,0.286,0.000,0.706,0.294,0.000,0.715,0.285,0.000,0.724,0.276,0.000,0.736,0.264,0.000,0.695,0.305,0.000,0.725,0.275,0.000,0.720,0.280,0.000,0.741,0.259,0.000,0.734,0.266,0.000,0.747,0.253,0.000,0.723,0.277,0.000,0.742,0.258,0.000,0.726,0.274,0.000,0.750,0.250,0.000,0.755,0.245,0.000,0.748,0.252,0.000,0.771,0.229,0.000,0.755,0.245,0.000,0.733,0.267,0.000,0.737,0.263,0.000,0.640,0.360,0.000,0.649,0.351,0.000,0.625,0.375,0.000,0.662,0.338,0.000,0.654,0.346,0.000,0.641,0.359,0.000,0.645,0.355,0.000,0.621,0.379,0.000,0.668,0.332,0.000,0.630,0.370,0.000,0.640,0.360,0.000,0.668,0.332,0.000,0.680,0.320,0.000,0.660,0.340,0.000,0.634,0.366,0.000,0.659,0.341,0.000,0.671,0.329,0.000,0.671,0.329,0.000,0.639,0.361,0.000,0.654,0.346,0.000,0.631,0.369,0.000,0.635,0.365,0.000,0.622,0.378,0.000,0.634,0.366,0.000,0.639,0.361,0.000,0.638,0.362};
			return value;
		}
		private double[] getColor_9_22_color_28()
		{
			double[] value = {0.000,0.689,0.311,0.000,0.625,0.375,0.000,0.639,0.361,0.000,0.627,0.373,0.000,0.631,0.369,0.000,0.635,0.365,0.000,0.691,0.309,0.000,0.679,0.321,0.000,0.627,0.373,0.000,0.665,0.335,0.000,0.674,0.326,0.000,0.629,0.371,0.000,0.669,0.331,0.000,0.664,0.336,0.000,0.628,0.372,0.000,0.682,0.318,0.000,0.704,0.296,0.000,0.702,0.298,0.000,0.680,0.320,0.000,0.645,0.355,0.000,0.691,0.309,0.000,0.649,0.351,0.000,0.638,0.362,0.000,0.713,0.287,0.000,0.688,0.312,0.000,0.610,0.390,0.000,0.558,0.442,0.000,0.568,0.432,0.000,0.564,0.436,0.000,0.618,0.382,0.000,0.605,0.395,0.000,0.608,0.392,0.000,0.562,0.438,0.000,0.606,0.394,0.000,0.566,0.434,0.000,0.604,0.396,0.000,0.622,0.378,0.000,0.594,0.406,0.000,0.615,0.385,0.000,0.617,0.383,0.000,0.562,0.438,0.000,0.554,0.446,0.000,0.592,0.408,0.000,0.609,0.391,0.000,0.564,0.436,0.000,0.594,0.406,0.000,0.595,0.405,0.000,0.607,0.393,0.000,0.622,0.378,0.000,0.583,0.417,0.000,0.590,0.410,0.000,0.562,0.438,0.000,0.594,0.406,0.000,0.584,0.416,0.000,0.559,0.441,0.000,0.549,0.451,0.000,0.600,0.400,0.000,0.590,0.410,0.000,0.558,0.442,0.000,0.601,0.399,0.000,0.597,0.403,0.000,0.584,0.416,0.000,0.601,0.399,0.000,0.560,0.440,0.000,0.599,0.401,0.000,0.619,0.381,0.000,0.587,0.413,0.000,0.612,0.388,0.000,0.592,0.408,0.000,0.602,0.398,0.000,0.588,0.412,0.000,0.585,0.415,0.000,0.578,0.422,0.000,0.626,0.374,0.000,0.628,0.372,0.000,0.609,0.391,0.000,0.595,0.405,0.000,0.630,0.370,0.000,0.589,0.411,0.000,0.609,0.391,0.000,0.601,0.399,0.000,0.594,0.406,0.000,0.599,0.401,0.000,0.589,0.411,0.000,0.597,0.403,0.000,0.575,0.425,0.000,0.564,0.436,0.000,0.595,0.405,0.000,0.595,0.405,0.000,0.576,0.424,0.000,0.503,0.497,0.000,0.514,0.486,0.000,0.510,0.490,0.000,0.529,0.471,0.000,0.492,0.508,0.000,0.536,0.464,0.000,0.488,0.512,0.000,0.472,0.528,0.000,0.494,0.506,0.000,0.475,0.525};
			return value;
		}
		private double[] getColor_9_22_color_29()
		{
			double[] value = {0.000,0.520,0.480,0.000,0.477,0.523,0.000,0.488,0.512,0.000,0.535,0.465,0.000,0.525,0.475,0.000,0.544,0.456,0.000,0.471,0.529,0.000,0.471,0.529,0.000,0.469,0.531,0.000,0.515,0.485,0.000,0.510,0.490,0.000,0.533,0.467,0.000,0.503,0.497,0.000,0.509,0.491,0.000,0.529,0.471,0.000,0.522,0.478,0.000,0.533,0.467,0.000,0.545,0.455,0.000,0.544,0.456,0.000,0.544,0.456,0.000,0.491,0.509,0.000,0.507,0.493,0.000,0.491,0.509,0.000,0.545,0.455,0.000,0.516,0.484,0.000,0.484,0.516,0.000,0.487,0.513,0.000,0.487,0.513,0.000,0.488,0.512,0.000,0.484,0.516,0.000,0.482,0.518,0.000,0.508,0.492,0.000,0.511,0.489,0.000,0.503,0.497,0.000,0.476,0.524,0.000,0.548,0.452,0.000,0.542,0.458,0.000,0.508,0.492,0.000,0.518,0.482,0.000,0.514,0.486,0.000,0.545,0.455,0.000,0.552,0.448,0.000,0.533,0.467,0.000,0.536,0.464,0.000,0.546,0.454,0.000,0.539,0.461,0.000,0.465,0.535,0.000,0.464,0.536,0.000,0.433,0.567,0.000,0.442,0.558,0.000,0.463,0.537,0.000,0.462,0.538,0.000,0.405,0.595,0.000,0.443,0.557,0.000,0.431,0.569,0.000,0.436,0.564,0.000,0.454,0.546,0.000,0.453,0.547,0.000,0.453,0.547,0.000,0.451,0.549,0.000,0.420,0.580,0.000,0.460,0.540,0.000,0.444,0.556,0.000,0.416,0.584,0.000,0.412,0.588,0.000,0.412,0.588,0.000,0.435,0.565,0.000,0.457,0.543,0.000,0.408,0.592,0.000,0.431,0.569,0.000,0.456,0.544,0.000,0.436,0.564,0.000,0.406,0.594,0.000,0.410,0.590,0.000,0.425,0.575,0.000,0.452,0.548,0.000,0.406,0.594,0.000,0.449,0.551,0.000,0.448,0.552,0.000,0.416,0.584,0.000,0.414,0.586,0.000,0.442,0.558,0.000,0.417,0.583,0.000,0.431,0.569,0.000,0.444,0.556,0.000,0.429,0.571,0.000,0.466,0.534,0.000,0.437,0.563,0.000,0.408,0.592,0.000,0.417,0.583,0.000,0.433,0.567,0.000,0.427,0.573,0.000,0.457,0.543,0.000,0.453,0.547,0.000,0.424,0.576,0.000,0.419,0.581,0.000,0.419,0.581,0.000,0.413,0.587,0.000,0.407,0.593,0.000,0.431,0.569};
			return value;
		}
		private double[] getColor_9_22_color_30()
		{
			double[] value = {0.000,0.413,0.587,0.000,0.432,0.568,0.000,0.428,0.572,0.000,0.433,0.567,0.000,0.426,0.574,0.000,0.410,0.590,0.000,0.408,0.592,0.000,0.414,0.586,0.000,0.409,0.591,0.000,0.404,0.596,0.000,0.408,0.592,0.000,0.390,0.610,0.000,0.386,0.614,0.000,0.385,0.615,0.000,0.378,0.622,0.000,0.379,0.621,0.000,0.377,0.623,0.000,0.394,0.606,0.000,0.365,0.635,0.000,0.398,0.602,0.000,0.369,0.631,0.000,0.390,0.610,0.000,0.385,0.615,0.000,0.402,0.598,0.000,0.363,0.637,0.000,0.402,0.598,0.000,0.377,0.623,0.000,0.361,0.639,0.000,0.396,0.604,0.000,0.371,0.629,0.000,0.396,0.604,0.000,0.369,0.631,0.000,0.358,0.642,0.000,0.385,0.615,0.000,0.378,0.622,0.000,0.368,0.632,0.000,0.405,0.595,0.000,0.396,0.604,0.000,0.379,0.621,0.000,0.378,0.622,0.000,0.395,0.605,0.000,0.391,0.609,0.000,0.383,0.617,0.000,0.366,0.634,0.000,0.356,0.644,0.000,0.388,0.612,0.000,0.398,0.602,0.000,0.381,0.619,0.000,0.392,0.608,0.000,0.337,0.663,0.000,0.592,0.408,0.000,0.591,0.409,0.000,0.592,0.408,0.000,0.573,0.427,0.000,0.576,0.424,0.000,0.575,0.425,0.000,0.578,0.422,0.000,0.569,0.431,0.000,0.574,0.426,0.000,0.575,0.425,0.000,0.585,0.415,0.000,0.578,0.422,0.000,0.589,0.411,0.000,0.587,0.413,0.000,0.590,0.410,0.000,0.588,0.412,0.000,0.591,0.409,0.000,0.590,0.410,0.000,0.580,0.420,0.000,0.584,0.416,0.000,0.585,0.415,0.000,0.583,0.417,0.000,0.860,0.140,0.000,0.870,0.130,0.000,0.870,0.130,0.000,0.872,0.128,0.000,0.867,0.133,0.000,0.861,0.139,0.000,0.875,0.125,0.000,0.855,0.145,0.000,0.870,0.130,0.000,0.878,0.122,0.000,0.867,0.133,0.000,0.882,0.118,0.000,0.888,0.112,0.000,0.874,0.126,0.000,0.878,0.122,0.000,0.816,0.184,0.000,0.830,0.170,0.000,0.814,0.186,0.000,0.823,0.177,0.000,0.834,0.166,0.000,0.830,0.170,0.000,0.830,0.170,0.000,0.817,0.183,0.000,0.828,0.172,0.000,0.817,0.183,0.000,0.830,0.170,0.000,0.844,0.156,0.000,0.817,0.183};
			return value;
		}
		private double[] getColor_9_22_color_31()
		{
			double[] value = {0.000,0.837,0.163,0.000,0.824,0.176,0.000,0.848,0.152,0.000,0.832,0.168,0.000,0.837,0.163,0.000,0.842,0.158,0.000,0.852,0.148,0.000,0.835,0.165,0.000,0.847,0.153,0.000,0.853,0.147,0.000,0.854,0.146,0.000,0.835,0.165,0.000,0.832,0.168,0.000,0.858,0.142,0.000,0.783,0.217,0.000,0.785,0.215,0.000,0.694,0.306,0.000,0.700,0.300,0.000,0.727,0.273,0.000,0.710,0.290,0.000,0.741,0.259,0.000,0.734,0.266,0.000,0.731,0.269,0.000,0.746,0.254,0.000,0.728,0.272,0.000,0.756,0.244,0.000,0.758,0.242,0.000,0.730,0.270,0.000,0.753,0.247,0.000,0.730,0.270,0.000,0.729,0.271,0.000,0.762,0.238,0.000,0.739,0.261,0.000,0.765,0.235,0.000,0.755,0.245,0.000,0.750,0.250,0.000,0.743,0.257,0.000,0.770,0.230,0.000,0.774,0.226,0.000,0.749,0.251,0.000,0.774,0.226,0.000,0.765,0.235,0.000,0.779,0.221,0.000,0.779,0.221,0.000,0.781,0.219,0.000,0.771,0.229,0.000,0.771,0.229,0.000,0.785,0.215,0.000,0.635,0.365,0.000,0.647,0.353,0.000,0.661,0.339,0.000,0.668,0.332,0.000,0.647,0.353,0.000,0.658,0.342,0.000,0.677,0.323,0.000,0.676,0.324,0.000,0.673,0.327,0.000,0.659,0.341,0.000,0.655,0.345,0.000,0.639,0.361,0.000,0.686,0.314,0.000,0.666,0.334,0.000,0.688,0.312,0.000,0.687,0.313,0.000,0.632,0.368,0.000,0.676,0.324,0.000,0.689,0.311,0.000,0.667,0.333,0.000,0.687,0.313,0.000,0.669,0.331,0.000,0.672,0.328,0.000,0.663,0.337,0.000,0.681,0.319,0.000,0.695,0.305,0.000,0.674,0.326,0.000,0.697,0.303,0.000,0.706,0.294,0.000,0.681,0.319,0.000,0.658,0.342,0.000,0.670,0.330,0.000,0.647,0.353,0.000,0.688,0.312,0.000,0.697,0.303,0.000,0.634,0.366,0.000,0.674,0.326,0.000,0.671,0.329,0.000,0.683,0.317,0.000,0.677,0.323,0.000,0.648,0.352,0.000,0.656,0.344,0.000,0.652,0.348,0.000,0.669,0.331,0.000,0.705,0.295,0.000,0.649,0.351,0.000,0.657,0.343,0.000,0.694,0.306,0.000,0.686,0.314,0.000,0.697,0.303,0.000,0.710,0.290,0.000,0.700,0.300};
			return value;
		}
		private double[] getColor_9_22_color_32()
		{
			double[] value = {0.000,0.580,0.420,0.000,0.609,0.391,0.000,0.605,0.395,0.000,0.624,0.376,0.000,0.584,0.416,0.000,0.580,0.420,0.000,0.621,0.379,0.000,0.553,0.447,0.000,0.557,0.443,0.000,0.566,0.434,0.000,0.577,0.423,0.000,0.592,0.408,0.000,0.577,0.423,0.000,0.568,0.432,0.000,0.584,0.416,0.000,0.610,0.390,0.000,0.596,0.404,0.000,0.505,0.495,0.000,0.492,0.508,0.000,0.543,0.457,0.000,0.537,0.463,0.000,0.502,0.498,0.000,0.528,0.472,0.000,0.528,0.472,0.000,0.510,0.490,0.000,0.488,0.512,0.000,0.536,0.464,0.000,0.512,0.488,0.000,0.539,0.461,0.000,0.536,0.464,0.000,0.542,0.458,0.000,0.543,0.457,0.000,0.544,0.456,0.000,0.487,0.513,0.000,0.518,0.482,0.000,0.492,0.508,0.000,0.509,0.491,0.000,0.487,0.513,0.000,0.489,0.511,0.000,0.505,0.495,0.000,0.488,0.512,0.000,0.483,0.517,0.000,0.484,0.516,0.000,0.477,0.523,0.000,0.482,0.518,0.000,0.467,0.533,0.000,0.476,0.524,0.000,0.474,0.526,0.000,0.467,0.533,0.000,0.468,0.532,0.000,0.466,0.534,0.000,0.469,0.531,0.000,0.462,0.538,0.000,0.465,0.535,0.000,0.465,0.535,0.000,0.461,0.539,0.000,0.459,0.541,0.000,0.467,0.533,0.000,0.444,0.556,0.000,0.455,0.545,0.000,0.450,0.550,0.000,0.439,0.561,0.000,0.417,0.583,0.000,0.412,0.588,0.000,0.434,0.566,0.000,0.440,0.560,0.000,0.408,0.592,0.000,0.435,0.565,0.000,0.428,0.572,0.000,0.430,0.570,0.000,0.426,0.574,0.000,0.427,0.573,0.000,0.415,0.585,0.000,0.405,0.595,0.000,0.417,0.583,0.000,0.419,0.581,0.000,0.413,0.587,0.000,0.399,0.601,0.000,0.411,0.589,0.000,0.408,0.592,0.000,0.408,0.592,0.000,0.396,0.604,0.000,0.395,0.605,0.000,0.391,0.609,0.000,0.388,0.612,0.000,0.383,0.617,0.000,0.386,0.614,0.000,0.379,0.621,0.000,0.375,0.625,0.000,0.373,0.627,0.000,0.377,0.623,0.000,0.379,0.621,0.000,0.376,0.624,0.000,0.376,0.624,0.000,0.363,0.637,0.000,0.361,0.639,0.000,0.361,0.639,0.000,0.360,0.640,0.000,0.362,0.638,0.000,0.363,0.637};
			return value;
		}
		private double[] getColor_9_22_color_33()
		{
			double[] value = {0.000,0.357,0.643,0.000,0.363,0.637,0.000,0.362,0.638,0.000,0.347,0.653,0.000,0.347,0.653,0.000,0.345,0.655,0.000,0.342,0.658,0.000,0.340,0.660,0.000,0.338,0.662,0.000,0.334,0.666,0.000,0.330,0.670,0.000,0.068,0.932,0.000,0.061,0.939,0.000,0.052,0.948,0.000,0.078,0.922,0.000,0.049,0.951,0.000,0.073,0.927,0.000,0.084,0.916,0.000,0.055,0.945,0.000,0.053,0.947,0.000,0.084,0.916,0.000,0.049,0.951,0.000,0.083,0.917,0.000,0.077,0.923,0.000,0.049,0.951,0.000,0.081,0.919,0.000,0.078,0.922,0.000,0.149,0.851,0.000,0.099,0.901,0.000,0.118,0.882,0.000,0.109,0.891,0.000,0.167,0.833,0.000,0.105,0.895,0.000,0.113,0.887,0.000,0.253,0.747,0.000,0.255,0.745,0.000,0.237,0.763,0.000,0.194,0.806,0.000,0.197,0.803,0.000,0.243,0.757,0.000,0.232,0.768,0.000,0.200,0.800,0.000,0.267,0.733,0.000,0.196,0.804,0.000,0.329,0.671,0.000,0.347,0.653,0.000,0.349,0.651,0.000,0.365,0.635,0.000,0.375,0.625,0.000,0.357,0.643,0.000,0.349,0.651,0.000,0.361,0.639,0.000,0.379,0.621,0.000,0.383,0.617,0.000,0.371,0.629,0.000,0.377,0.623,0.000,0.395,0.605,0.000,0.401,0.599,0.000,0.352,0.648,0.000,0.373,0.627,0.000,0.381,0.619,0.000,0.376,0.624,0.000,0.402,0.598,0.000,0.381,0.619,0.000,0.379,0.621,0.000,0.412,0.588,0.000,0.377,0.623,0.000,0.585,0.415,0.000,0.585,0.415,0.000,0.589,0.411,0.000,0.589,0.411,0.000,0.590,0.410,0.000,0.588,0.412,0.000,0.582,0.418,0.000,0.591,0.409,0.000,0.588,0.412,0.000,0.590,0.410,0.000,0.592,0.408,0.000,0.591,0.409,0.000,0.588,0.412,0.000,0.583,0.417,0.000,0.585,0.415,0.000,0.584,0.416,0.000,0.583,0.417,0.000,0.582,0.418,0.000,0.582,0.418,0.000,0.585,0.415,0.000,0.585,0.415,0.000,0.585,0.415,0.000,0.586,0.414,0.000,0.586,0.414,0.000,0.587,0.413,0.000,0.587,0.413,0.000,0.587,0.413,0.000,0.586,0.414,0.000,0.588,0.412,0.000,0.878,0.122,0.000,0.888,0.112,0.000,0.889,0.111,0.000,0.894,0.106};
			return value;
		}
		private double[] getColor_9_22_color_34()
		{
			double[] value = {0.000,0.894,0.106,0.000,0.892,0.108,0.000,0.900,0.100,0.000,0.901,0.099,0.000,0.902,0.098,0.000,0.853,0.147,0.000,0.850,0.150,0.000,0.854,0.146,0.000,0.854,0.146,0.000,0.854,0.146,0.000,0.856,0.144,0.000,0.857,0.143,0.000,0.849,0.151,0.000,0.846,0.154,0.000,0.851,0.149,0.000,0.846,0.154,0.000,0.847,0.153,0.000,0.864,0.136,0.000,0.851,0.149,0.000,0.868,0.132,0.000,0.858,0.142,0.000,0.856,0.144,0.000,0.872,0.128,0.000,0.870,0.130,0.000,0.869,0.131,0.000,0.861,0.139,0.000,0.875,0.125,0.000,0.874,0.126,0.000,0.862,0.138,0.000,0.867,0.133,0.000,0.867,0.133,0.000,0.856,0.144,0.000,0.855,0.145,0.000,0.879,0.121,0.000,0.879,0.121,0.000,0.863,0.137,0.000,0.867,0.133,0.000,0.876,0.124,0.000,0.867,0.133,0.000,0.883,0.117,0.000,0.879,0.121,0.000,0.872,0.128,0.000,0.870,0.130,0.000,0.875,0.125,0.000,0.886,0.114,0.000,0.892,0.108,0.000,0.891,0.109,0.000,0.887,0.113,0.000,0.901,0.099,0.000,0.894,0.106,0.000,0.899,0.101,0.000,0.899,0.101,0.000,0.894,0.106,0.000,0.895,0.105,0.000,0.891,0.109,0.000,0.883,0.117,0.000,0.893,0.107,0.000,0.891,0.109,0.000,0.892,0.108,0.000,0.891,0.109,0.000,0.906,0.094,0.000,0.911,0.089,0.000,0.899,0.101,0.000,0.914,0.086,0.000,0.912,0.088,0.000,0.918,0.082,0.000,0.902,0.098,0.000,0.899,0.101,0.000,0.914,0.086,0.000,0.915,0.085,0.000,0.904,0.096,0.000,0.919,0.081,0.000,0.911,0.089,0.000,0.916,0.084,0.000,0.908,0.092,0.000,0.922,0.078,0.000,0.922,0.078,0.000,0.916,0.084,0.000,0.907,0.093,0.000,0.912,0.088,0.000,0.930,0.070,0.000,0.921,0.079,0.000,0.935,0.065,0.000,0.903,0.097,0.000,0.909,0.091,0.000,0.920,0.080,0.000,0.922,0.078,0.000,0.924,0.076,0.000,0.924,0.076,0.000,0.931,0.069,0.000,0.931,0.069,0.000,0.936,0.064,0.000,0.937,0.063,0.000,0.904,0.096,0.000,0.898,0.102,0.000,0.892,0.108,0.000,0.922,0.078,0.000,0.921,0.079,0.000,0.919,0.081,0.000,0.895,0.105};
			return value;
		}
		private double[] getColor_9_22_color_35()
		{
			double[] value = {0.000,0.711,0.289,0.000,0.729,0.271,0.000,0.733,0.267,0.000,0.720,0.280,0.000,0.738,0.262,0.000,0.716,0.284,0.000,0.725,0.275,0.000,0.728,0.272,0.000,0.743,0.257,0.000,0.734,0.266,0.000,0.756,0.244,0.000,0.748,0.252,0.000,0.740,0.260,0.000,0.743,0.257,0.000,0.763,0.237,0.000,0.747,0.253,0.000,0.749,0.251,0.000,0.750,0.250,0.000,0.741,0.259,0.000,0.738,0.262,0.000,0.746,0.254,0.000,0.744,0.256,0.000,0.759,0.241,0.000,0.778,0.222,0.000,0.759,0.241,0.000,0.763,0.237,0.000,0.778,0.222,0.000,0.772,0.228,0.000,0.793,0.207,0.000,0.775,0.225,0.000,0.786,0.214,0.000,0.783,0.217,0.000,0.798,0.202,0.000,0.798,0.202,0.000,0.784,0.216,0.000,0.778,0.222,0.000,0.810,0.190,0.000,0.783,0.217,0.000,0.790,0.210,0.000,0.809,0.191,0.000,0.807,0.193,0.000,0.820,0.180,0.000,0.832,0.168,0.000,0.649,0.351,0.000,0.663,0.337,0.000,0.686,0.314,0.000,0.692,0.308,0.000,0.661,0.339,0.000,0.667,0.333,0.000,0.660,0.340,0.000,0.695,0.305,0.000,0.656,0.344,0.000,0.694,0.306,0.000,0.665,0.335,0.000,0.645,0.355,0.000,0.677,0.323,0.000,0.677,0.323,0.000,0.687,0.313,0.000,0.706,0.294,0.000,0.683,0.317,0.000,0.662,0.338,0.000,0.688,0.312,0.000,0.702,0.298,0.000,0.704,0.296,0.000,0.705,0.295,0.000,0.676,0.324,0.000,0.694,0.306,0.000,0.689,0.311,0.000,0.703,0.297,0.000,0.712,0.288,0.000,0.631,0.369,0.000,0.640,0.360,0.000,0.600,0.400,0.000,0.641,0.359,0.000,0.631,0.369,0.000,0.611,0.389,0.000,0.633,0.367,0.000,0.635,0.365,0.000,0.633,0.367,0.000,0.612,0.388,0.000,0.631,0.369,0.000,0.619,0.381,0.000,0.607,0.393,0.000,0.628,0.372,0.000,0.621,0.379,0.000,0.618,0.382,0.000,0.496,0.504,0.000,0.483,0.517,0.000,0.482,0.518,0.000,0.479,0.521,0.000,0.488,0.512,0.000,0.481,0.519,0.000,0.489,0.511,0.000,0.475,0.525,0.000,0.476,0.524,0.000,0.470,0.530,0.000,0.469,0.531,0.000,0.463,0.537,0.000,0.457,0.543,0.000,0.461,0.539};
			return value;
		}
		private double[] getColor_9_22_color_36()
		{
			double[] value = {0.000,0.460,0.540,0.000,0.455,0.545,0.000,0.460,0.540,0.000,0.456,0.544,0.000,0.452,0.548,0.000,0.450,0.550,0.000,0.448,0.552,0.000,0.443,0.557,0.000,0.445,0.555,0.000,0.441,0.559,0.000,0.438,0.562,0.000,0.445,0.555,0.000,0.444,0.556,0.000,0.431,0.569,0.000,0.424,0.576,0.000,0.422,0.578,0.000,0.425,0.575,0.000,0.434,0.566,0.000,0.433,0.567,0.000,0.419,0.581,0.000,0.420,0.580,0.000,0.418,0.582,0.000,0.409,0.591,0.000,0.420,0.580,0.000,0.407,0.593,0.000,0.414,0.586,0.000,0.405,0.595,0.000,0.417,0.583,0.000,0.407,0.593,0.000,0.406,0.594,0.000,0.415,0.585,0.000,0.400,0.600,0.000,0.412,0.588,0.000,0.396,0.604,0.000,0.406,0.594,0.000,0.392,0.608,0.000,0.391,0.609,0.000,0.407,0.593,0.000,0.403,0.597,0.000,0.395,0.605,0.000,0.398,0.602,0.000,0.397,0.603,0.000,0.389,0.611,0.000,0.390,0.610,0.000,0.386,0.614,0.000,0.376,0.624,0.000,0.370,0.630,0.000,0.361,0.639,0.000,0.362,0.638,0.000,0.374,0.626,0.000,0.379,0.621,0.000,0.359,0.641,0.000,0.361,0.639,0.000,0.365,0.635,0.000,0.367,0.633,0.000,0.367,0.633,0.000,0.365,0.635,0.000,0.348,0.652,0.000,0.348,0.652,0.000,0.347,0.653,0.000,0.354,0.646,0.000,0.345,0.655,0.000,0.362,0.638,0.000,0.357,0.643,0.000,0.343,0.657,0.000,0.348,0.652,0.000,0.343,0.657,0.000,0.076,0.924,0.000,0.067,0.933,0.000,0.045,0.955,0.000,0.067,0.933,0.000,0.070,0.930,0.000,0.047,0.953,0.000,0.071,0.929,0.000,0.073,0.927,0.000,0.078,0.922,0.000,0.083,0.917,0.000,0.057,0.943,0.000,0.048,0.952,0.000,0.050,0.950,0.000,0.055,0.945,0.000,0.072,0.928,0.000,0.049,0.951,0.000,0.049,0.951,0.000,0.059,0.941,0.000,0.051,0.949,0.000,0.054,0.946,0.000,0.090,0.910,0.000,0.066,0.934,0.000,0.067,0.933,0.000,0.062,0.938,0.000,0.070,0.930,0.000,0.134,0.866,0.000,0.081,0.919,0.000,0.122,0.878,0.000,0.108,0.892,0.000,0.105,0.895,0.000,0.165,0.835,0.000,0.135,0.865,0.000,0.103,0.897};
			return value;
		}
		private double[] getColor_9_22_color_37()
		{
			double[] value = {0.000,0.201,0.799,0.000,0.173,0.827,0.000,0.289,0.711,0.000,0.248,0.752,0.000,0.283,0.717,0.000,0.370,0.630,0.000,0.388,0.612,0.000,0.401,0.599,0.000,0.391,0.609,0.000,0.417,0.583,0.000,0.431,0.569,0.000,0.446,0.554,0.000,0.507,0.493,0.000,0.484,0.516,0.000,0.479,0.521,0.000,0.495,0.505,0.000,0.489,0.511,0.000,0.518,0.482,0.000,0.476,0.524,0.000,0.500,0.500,0.000,0.500,0.500,0.000,0.485,0.515,0.000,0.464,0.536,0.000,0.498,0.502,0.000,0.478,0.522,0.000,0.487,0.513,0.000,0.563,0.437,0.000,0.552,0.448,0.000,0.560,0.440,0.000,0.552,0.448,0.000,0.556,0.444,0.000,0.572,0.428,0.000,0.569,0.431,0.000,0.574,0.426,0.000,0.541,0.459,0.000,0.583,0.417,0.000,0.549,0.451,0.000,0.564,0.436,0.000,0.554,0.446,0.000,0.513,0.487,0.000,0.506,0.494,0.000,0.553,0.447,0.000,0.545,0.455,0.000,0.510,0.490,0.000,0.566,0.434,0.000,0.563,0.437,0.000,0.548,0.452,0.000,0.564,0.436,0.000,0.563,0.437,0.000,0.574,0.426,0.000,0.565,0.435,0.000,0.526,0.474,0.000,0.570,0.430,0.000,0.528,0.472,0.000,0.563,0.437,0.000,0.577,0.423,0.000,0.576,0.424,0.000,0.855,0.145,0.000,0.856,0.144,0.000,0.863,0.137,0.000,0.865,0.135,0.000,0.870,0.130,0.000,0.877,0.123,0.000,0.855,0.145,0.000,0.860,0.140,0.000,0.862,0.138,0.000,0.865,0.135,0.000,0.866,0.134,0.000,0.868,0.132,0.000,0.868,0.132,0.000,0.873,0.127,0.000,0.872,0.128,0.000,0.882,0.118,0.000,0.873,0.127,0.000,0.892,0.108,0.000,0.884,0.116,0.000,0.886,0.114,0.000,0.907,0.093,0.000,0.881,0.119,0.000,0.886,0.114,0.000,0.887,0.113,0.000,0.898,0.102,0.000,0.878,0.122,0.000,0.898,0.102,0.000,0.904,0.096,0.000,0.888,0.112,0.000,0.912,0.088,0.000,0.886,0.114,0.000,0.889,0.111,0.000,0.882,0.118,0.000,0.876,0.124,0.000,0.870,0.130,0.000,0.870,0.130,0.000,0.831,0.169,0.000,0.840,0.160,0.000,0.836,0.164,0.000,0.837,0.163,0.000,0.840,0.160,0.000,0.838,0.162,0.000,0.839,0.161};
			return value;
		}
		private double[] getColor_9_22_color_38()
		{
			double[] value = {0.000,0.847,0.153,0.000,0.844,0.156,0.000,0.847,0.153,0.000,0.711,0.289,0.000,0.721,0.279,0.000,0.719,0.281,0.000,0.722,0.278,0.000,0.714,0.286,0.000,0.723,0.277,0.000,0.715,0.285,0.000,0.711,0.289,0.000,0.719,0.281,0.000,0.713,0.287,0.000,0.719,0.281,0.000,0.716,0.284,0.000,0.716,0.284,0.000,0.726,0.274,0.000,0.730,0.270,0.000,0.728,0.272,0.000,0.725,0.275,0.000,0.734,0.266,0.000,0.726,0.274,0.000,0.739,0.261,0.000,0.737,0.263,0.000,0.735,0.265,0.000,0.736,0.264,0.000,0.721,0.279,0.000,0.738,0.262,0.000,0.725,0.275,0.000,0.720,0.280,0.000,0.724,0.276,0.000,0.742,0.258,0.000,0.741,0.259,0.000,0.730,0.270,0.000,0.749,0.251,0.000,0.742,0.258,0.000,0.750,0.250,0.000,0.754,0.246,0.000,0.754,0.246,0.000,0.748,0.252,0.000,0.753,0.247,0.000,0.751,0.249,0.000,0.753,0.247,0.000,0.758,0.242,0.000,0.754,0.246,0.000,0.755,0.245,0.000,0.758,0.242,0.000,0.761,0.239,0.000,0.765,0.235,0.000,0.761,0.239,0.000,0.763,0.237,0.000,0.770,0.230,0.000,0.766,0.234,0.000,0.770,0.230,0.000,0.768,0.232,0.000,0.772,0.228,0.000,0.771,0.229,0.000,0.776,0.224,0.000,0.781,0.219,0.000,0.781,0.219,0.000,0.789,0.211,0.000,0.793,0.207,0.000,0.791,0.209,0.000,0.787,0.213,0.000,0.787,0.213,0.000,0.790,0.210,0.000,0.792,0.208,0.000,0.808,0.192,0.000,0.804,0.196,0.000,0.814,0.186,0.000,0.817,0.183,0.000,0.815,0.185,0.000,0.825,0.175,0.000,0.822,0.178,0.000,0.668,0.332,0.000,0.674,0.326,0.000,0.652,0.348,0.000,0.653,0.347,0.000,0.682,0.318,0.000,0.701,0.299,0.000,0.710,0.290,0.000,0.688,0.312,0.000,0.701,0.299,0.000,0.692,0.308,0.000,0.675,0.325,0.000,0.652,0.348,0.000,0.677,0.323,0.000,0.682,0.318,0.000,0.680,0.320,0.000,0.648,0.352,0.000,0.692,0.308,0.000,0.677,0.323,0.000,0.672,0.328,0.000,0.688,0.312,0.000,0.654,0.346,0.000,0.666,0.334,0.000,0.670,0.330,0.000,0.665,0.335,0.000,0.662,0.338,0.000,0.678,0.322};
			return value;
		}
		private double[] getColor_9_22_color_39()
		{
			double[] value = {0.000,0.659,0.341,0.000,0.657,0.343,0.000,0.661,0.339,0.000,0.669,0.331,0.000,0.662,0.338,0.000,0.653,0.347,0.000,0.677,0.323,0.000,0.651,0.349,0.000,0.679,0.321,0.000,0.683,0.317,0.000,0.656,0.344,0.000,0.662,0.338,0.000,0.659,0.341,0.000,0.657,0.343,0.000,0.580,0.420,0.000,0.576,0.424,0.000,0.583,0.417,0.000,0.583,0.417,0.000,0.579,0.421,0.000,0.593,0.407,0.000,0.585,0.415,0.000,0.582,0.418,0.000,0.600,0.400,0.000,0.602,0.398,0.000,0.599,0.401,0.000,0.602,0.398,0.000,0.604,0.396,0.000,0.604,0.396,0.000,0.578,0.422,0.000,0.640,0.360,0.000,0.605,0.395,0.000,0.590,0.410,0.000,0.610,0.390,0.000,0.609,0.391,0.000,0.608,0.392,0.000,0.644,0.356,0.000,0.618,0.382,0.000,0.625,0.375,0.000,0.645,0.355,0.000,0.629,0.371,0.000,0.640,0.360,0.000,0.626,0.374,0.000,0.648,0.352,0.000,0.638,0.362,0.000,0.647,0.353,0.000,0.641,0.359,0.000,0.642,0.358,0.000,0.645,0.355,0.000,0.649,0.351,0.000,0.652,0.348,0.000,0.561,0.439,0.000,0.542,0.458,0.000,0.554,0.446,0.000,0.546,0.454,0.000,0.571,0.429,0.000,0.570,0.430,0.000,0.570,0.430,0.000,0.545,0.455,0.000,0.543,0.457,0.000,0.569,0.431,0.000,0.568,0.432,0.000,0.545,0.455,0.000,0.503,0.497,0.000,0.524,0.476,0.000,0.536,0.464,0.000,0.502,0.498,0.000,0.564,0.436,0.000,0.563,0.437,0.000,0.519,0.481,0.000,0.526,0.474,0.000,0.560,0.440,0.000,0.506,0.494,0.000,0.505,0.495,0.000,0.519,0.481,0.000,0.502,0.498,0.000,0.502,0.498,0.000,0.511,0.489,0.000,0.535,0.465,0.000,0.529,0.471,0.000,0.515,0.485,0.000,0.506,0.494,0.000,0.493,0.507,0.000,0.478,0.522,0.000,0.479,0.521,0.000,0.476,0.524,0.000,0.489,0.511,0.000,0.462,0.538,0.000,0.475,0.525,0.000,0.467,0.533,0.000,0.450,0.550,0.000,0.443,0.557,0.000,0.440,0.560,0.000,0.453,0.547,0.000,0.489,0.511,0.000,0.437,0.563,0.000,0.450,0.550,0.000,0.488,0.512,0.000,0.471,0.529,0.000,0.434,0.566,0.000,0.438,0.562};
			return value;
		}
		private double[] getColor_9_22_color_40()
		{
			double[] value = {0.000,0.432,0.568,0.000,0.430,0.570,0.000,0.432,0.568,0.000,0.438,0.562,0.000,0.438,0.562,0.000,0.435,0.565,0.000,0.470,0.530,0.000,0.461,0.539,0.000,0.443,0.557,0.000,0.440,0.560,0.000,0.446,0.554,0.000,0.447,0.553,0.000,0.448,0.552,0.000,0.424,0.576,0.000,0.424,0.576,0.000,0.425,0.575,0.000,0.431,0.569,0.000,0.416,0.584,0.000,0.417,0.583,0.000,0.408,0.592,0.000,0.425,0.575,0.000,0.414,0.586,0.000,0.413,0.587,0.000,0.412,0.588,0.000,0.403,0.597,0.000,0.420,0.580,0.000,0.403,0.597,0.000,0.411,0.589,0.000,0.409,0.591,0.000,0.425,0.575,0.000,0.420,0.580,0.000,0.429,0.571,0.000,0.398,0.602,0.000,0.398,0.602,0.000,0.398,0.602,0.000,0.406,0.594,0.000,0.389,0.611,0.000,0.389,0.611,0.000,0.426,0.574,0.000,0.408,0.592,0.000,0.409,0.591,0.000,0.428,0.572,0.000,0.425,0.575,0.000,0.415,0.585,0.000,0.415,0.585,0.000,0.439,0.561,0.000,0.421,0.579,0.000,0.436,0.564,0.000,0.378,0.622,0.000,0.397,0.603,0.000,0.435,0.565,0.000,0.418,0.582,0.000,0.443,0.557,0.000,0.395,0.605,0.000,0.381,0.619,0.000,0.432,0.568,0.000,0.415,0.585,0.000,0.057,0.943,0.000,0.059,0.941,0.000,0.069,0.931,0.000,0.067,0.933,0.000,0.070,0.930,0.000,0.068,0.932,0.000,0.074,0.926,0.000,0.076,0.924,0.000,0.470,0.530,0.000,0.418,0.582,0.000,0.433,0.567,0.000,0.498,0.502,0.000,0.501,0.499,0.000,0.481,0.519,0.000,0.550,0.450,0.000,0.540,0.460,0.000,0.521,0.479,0.000,0.533,0.467,0.000,0.497,0.503,0.000,0.491,0.509,0.000,0.499,0.501,0.000,0.495,0.505,0.000,0.495,0.505,0.000,0.503,0.497,0.000,0.842,0.158,0.000,0.841,0.159,0.000,0.838,0.162,0.000,0.837,0.163,0.000,0.854,0.146,0.000,0.835,0.165,0.000,0.862,0.138,0.000,0.864,0.136,0.000,0.848,0.152,0.000,0.846,0.154,0.000,0.868,0.132,0.000,0.868,0.132,0.000,0.843,0.157,0.000,0.848,0.152,0.000,0.847,0.153,0.000,0.858,0.142,0.000,0.869,0.131,0.000,0.873,0.127,0.000,0.878,0.122};
			return value;
		}
		private double[] getColor_9_22_color_41()
		{
			double[] value = {0.000,0.873,0.127,0.000,0.878,0.122,0.000,0.868,0.132,0.000,0.878,0.122,0.000,0.877,0.123,0.000,0.875,0.125,0.000,0.873,0.127,0.000,0.799,0.201,0.000,0.805,0.195,0.000,0.809,0.191,0.000,0.808,0.192,0.000,0.808,0.192,0.000,0.813,0.187,0.000,0.813,0.187,0.000,0.819,0.181,0.000,0.873,0.127,0.000,0.872,0.128,0.000,0.825,0.175,0.000,0.826,0.174,0.000,0.826,0.174,0.000,0.810,0.190,0.000,0.828,0.172,0.000,0.830,0.170,0.000,0.805,0.195,0.000,0.822,0.178,0.000,0.825,0.175,0.000,0.830,0.170,0.000,0.820,0.180,0.000,0.827,0.173,0.000,0.870,0.130,0.000,0.836,0.164,0.000,0.830,0.170,0.000,0.831,0.169,0.000,0.837,0.163,0.000,0.726,0.274,0.000,0.735,0.265,0.000,0.717,0.283,0.000,0.715,0.285,0.000,0.717,0.283,0.000,0.737,0.263,0.000,0.734,0.266,0.000,0.723,0.277,0.000,0.721,0.279,0.000,0.720,0.280,0.000,0.742,0.258,0.000,0.747,0.253,0.000,0.743,0.257,0.000,0.722,0.278,0.000,0.745,0.255,0.000,0.746,0.254,0.000,0.748,0.252,0.000,0.757,0.243,0.000,0.718,0.282,0.000,0.748,0.252,0.000,0.753,0.247,0.000,0.735,0.265,0.000,0.727,0.273,0.000,0.764,0.236,0.000,0.730,0.270,0.000,0.772,0.228,0.000,0.766,0.234,0.000,0.751,0.249,0.000,0.769,0.231,0.000,0.738,0.262,0.000,0.781,0.219,0.000,0.782,0.218,0.000,0.760,0.240,0.000,0.752,0.248,0.000,0.777,0.223,0.000,0.770,0.230,0.000,0.763,0.237,0.000,0.781,0.219,0.000,0.770,0.230,0.000,0.797,0.203,0.000,0.779,0.221,0.000,0.812,0.188,0.000,0.795,0.205,0.000,0.792,0.208,0.000,0.701,0.299,0.000,0.699,0.301,0.000,0.714,0.286,0.000,0.710,0.290,0.000,0.711,0.289,0.000,0.658,0.342,0.000,0.664,0.336,0.000,0.698,0.302,0.000,0.683,0.317,0.000,0.670,0.330,0.000,0.672,0.328,0.000,0.698,0.302,0.000,0.694,0.306,0.000,0.713,0.287,0.000,0.707,0.293,0.000,0.705,0.295,0.000,0.681,0.319,0.000,0.686,0.314,0.000,0.702,0.298,0.000,0.660,0.340,0.000,0.700,0.300,0.000,0.693,0.307};
			return value;
		}
		private double[] getColor_9_22_color_42()
		{
			double[] value = {0.000,0.690,0.310,0.000,0.710,0.290,0.000,0.655,0.345,0.000,0.671,0.329,0.000,0.655,0.345,0.000,0.691,0.309,0.000,0.683,0.317,0.000,0.655,0.345,0.000,0.712,0.288,0.000,0.682,0.318,0.000,0.700,0.300,0.000,0.705,0.295,0.000,0.687,0.313,0.000,0.702,0.298,0.000,0.664,0.336,0.000,0.676,0.324,0.000,0.699,0.301,0.000,0.679,0.321,0.000,0.692,0.308,0.000,0.680,0.320,0.000,0.714,0.286,0.000,0.679,0.321,0.000,0.682,0.318,0.000,0.668,0.332,0.000,0.713,0.287,0.000,0.681,0.319,0.000,0.694,0.306,0.000,0.705,0.295,0.000,0.664,0.336,0.000,0.694,0.306,0.000,0.664,0.336,0.000,0.666,0.334,0.000,0.654,0.346,0.000,0.664,0.336,0.000,0.685,0.315,0.000,0.697,0.303,0.000,0.672,0.328,0.000,0.668,0.332,0.000,0.667,0.333,0.000,0.670,0.330,0.000,0.687,0.313,0.000,0.683,0.317,0.000,0.663,0.337,0.000,0.682,0.318,0.000,0.677,0.323,0.000,0.672,0.328,0.000,0.580,0.420,0.000,0.590,0.410,0.000,0.577,0.423,0.000,0.576,0.424,0.000,0.601,0.399,0.000,0.578,0.422,0.000,0.573,0.427,0.000,0.598,0.402,0.000,0.567,0.433,0.000,0.568,0.432,0.000,0.575,0.425,0.000,0.576,0.424,0.000,0.607,0.393,0.000,0.608,0.392,0.000,0.572,0.428,0.000,0.573,0.427,0.000,0.602,0.398,0.000,0.585,0.415,0.000,0.609,0.391,0.000,0.591,0.409,0.000,0.610,0.390,0.000,0.620,0.380,0.000,0.617,0.383,0.000,0.625,0.375,0.000,0.610,0.390,0.000,0.598,0.402,0.000,0.609,0.391,0.000,0.620,0.380,0.000,0.602,0.398,0.000,0.606,0.394,0.000,0.599,0.401,0.000,0.588,0.412,0.000,0.599,0.401,0.000,0.593,0.407,0.000,0.596,0.404,0.000,0.579,0.421,0.000,0.600,0.400,0.000,0.571,0.429,0.000,0.609,0.391,0.000,0.602,0.398,0.000,0.652,0.348,0.000,0.574,0.426,0.000,0.606,0.394,0.000,0.630,0.370,0.000,0.627,0.373,0.000,0.598,0.402,0.000,0.618,0.382,0.000,0.647,0.353,0.000,0.626,0.374,0.000,0.638,0.362,0.000,0.653,0.347,0.000,0.649,0.351,0.000,0.639,0.361,0.000,0.649,0.351};
			return value;
		}
		private double[] getColor_9_22_color_43()
		{
			double[] value = {0.000,0.581,0.419,0.000,0.642,0.358,0.000,0.646,0.354,0.000,0.644,0.356,0.000,0.656,0.344,0.000,0.616,0.384,0.000,0.654,0.346,0.000,0.638,0.362,0.000,0.643,0.357,0.000,0.602,0.398,0.000,0.593,0.407,0.000,0.656,0.344,0.000,0.656,0.344,0.000,0.541,0.459,0.000,0.563,0.437,0.000,0.543,0.457,0.000,0.552,0.448,0.000,0.550,0.450,0.000,0.538,0.462,0.000,0.530,0.470,0.000,0.539,0.461,0.000,0.553,0.447,0.000,0.537,0.463,0.000,0.540,0.460,0.000,0.506,0.494,0.000,0.564,0.436,0.000,0.543,0.457,0.000,0.549,0.451,0.000,0.530,0.470,0.000,0.544,0.456,0.000,0.529,0.471,0.000,0.552,0.448,0.000,0.546,0.454,0.000,0.547,0.453,0.000,0.524,0.476,0.000,0.524,0.476,0.000,0.519,0.481,0.000,0.521,0.479,0.000,0.531,0.469,0.000,0.539,0.461,0.000,0.518,0.482,0.000,0.534,0.466,0.000,0.539,0.461,0.000,0.531,0.469,0.000,0.515,0.485,0.000,0.501,0.499,0.000,0.514,0.486,0.000,0.520,0.480,0.000,0.516,0.484,0.000,0.524,0.476,0.000,0.561,0.439,0.000,0.511,0.489,0.000,0.523,0.477,0.000,0.517,0.483,0.000,0.510,0.490,0.000,0.532,0.468,0.000,0.541,0.459,0.000,0.554,0.446,0.000,0.543,0.457,0.000,0.541,0.459,0.000,0.546,0.454,0.000,0.545,0.455,0.000,0.541,0.459,0.000,0.520,0.480,0.000,0.537,0.463,0.000,0.506,0.494,0.000,0.513,0.487,0.000,0.512,0.488,0.000,0.517,0.483,0.000,0.504,0.496,0.000,0.516,0.484,0.000,0.507,0.493,0.000,0.540,0.460,0.000,0.509,0.491,0.000,0.491,0.509,0.000,0.485,0.515,0.000,0.499,0.501,0.000,0.474,0.526,0.000,0.495,0.505,0.000,0.494,0.506,0.000,0.484,0.516,0.000,0.497,0.503,0.000,0.470,0.530,0.000,0.496,0.504,0.000,0.473,0.527,0.000,0.467,0.533,0.000,0.480,0.520,0.000,0.495,0.505,0.000,0.472,0.528,0.000,0.479,0.521,0.000,0.480,0.520,0.000,0.482,0.518,0.000,0.501,0.499,0.000,0.483,0.517,0.000,0.493,0.507,0.000,0.482,0.518,0.000,0.461,0.539,0.000,0.461,0.539,0.000,0.490,0.510,0.000,0.461,0.539};
			return value;
		}
		private double[] getColor_9_22_color_44()
		{
			double[] value = {0.000,0.498,0.502,0.000,0.472,0.528,0.000,0.472,0.528,0.000,0.465,0.535,0.000,0.492,0.508,0.000,0.462,0.538,0.000,0.491,0.509,0.000,0.481,0.519,0.000,0.483,0.517,0.000,0.489,0.511,0.000,0.449,0.551,0.000,0.485,0.515,0.000,0.485,0.515,0.000,0.445,0.555,0.000,0.061,0.939,0.000,0.426,0.574,0.000,0.448,0.552,0.000,0.532,0.468,0.000,0.476,0.524,0.000,0.492,0.508,0.000,0.495,0.505,0.000,0.487,0.513,0.000,0.489,0.511,0.000,0.486,0.514,0.000,0.477,0.523,0.000,0.534,0.466,0.000,0.539,0.461,0.000,0.480,0.520,0.000,0.540,0.460,0.000,0.540,0.460,0.000,0.503,0.497,0.000,0.545,0.455,0.000,0.504,0.496,0.000,0.501,0.499,0.000,0.504,0.496,0.000,0.503,0.497,0.000,0.501,0.499,0.000,0.567,0.433,0.000,0.563,0.437,0.000,0.555,0.445,0.000,0.556,0.444,0.000,0.566,0.434,0.000,0.568,0.432,0.000,0.543,0.457,0.000,0.562,0.438,0.000,0.557,0.443,0.000,0.568,0.432,0.000,0.567,0.433,0.000,0.792,0.208,0.000,0.798,0.202,0.000,0.799,0.201,0.000,0.797,0.203,0.000,0.798,0.202,0.000,0.800,0.200,0.000,0.802,0.198,0.000,0.790,0.210,0.000,0.802,0.198,0.000,0.824,0.176,0.000,0.796,0.204,0.000,0.796,0.204,0.000,0.847,0.153,0.000,0.851,0.149,0.000,0.855,0.145,0.000,0.842,0.158,0.000,0.853,0.147,0.000,0.851,0.149,0.000,0.848,0.152,0.000,0.853,0.147,0.000,0.802,0.198,0.000,0.804,0.196,0.000,0.805,0.195,0.000,0.811,0.189,0.000,0.807,0.193,0.000,0.805,0.195,0.000,0.806,0.194,0.000,0.809,0.191,0.000,0.810,0.190,0.000,0.812,0.188,0.000,0.867,0.133,0.000,0.728,0.272,0.000,0.717,0.283,0.000,0.718,0.282,0.000,0.748,0.252,0.000,0.770,0.230,0.000,0.743,0.257,0.000,0.718,0.282,0.000,0.772,0.228,0.000,0.722,0.278,0.000,0.723,0.277,0.000,0.724,0.276,0.000,0.781,0.219,0.000,0.728,0.272,0.000,0.752,0.248,0.000,0.725,0.275,0.000,0.730,0.270,0.000,0.748,0.252,0.000,0.745,0.255,0.000,0.730,0.270,0.000,0.752,0.248,0.000,0.768,0.232};
			return value;
		}
		private double[] getColor_9_22_color_45()
		{
			double[] value = {0.000,0.774,0.226,0.000,0.758,0.242,0.000,0.776,0.224,0.000,0.725,0.275,0.000,0.756,0.244,0.000,0.707,0.293,0.000,0.698,0.302,0.000,0.692,0.308,0.000,0.702,0.298,0.000,0.695,0.305,0.000,0.717,0.283,0.000,0.704,0.296,0.000,0.718,0.282,0.000,0.713,0.287,0.000,0.686,0.314,0.000,0.681,0.319,0.000,0.666,0.334,0.000,0.670,0.330,0.000,0.703,0.297,0.000,0.714,0.286,0.000,0.663,0.337,0.000,0.696,0.304,0.000,0.687,0.313,0.000,0.721,0.279,0.000,0.705,0.295,0.000,0.702,0.298,0.000,0.719,0.281,0.000,0.702,0.298,0.000,0.686,0.314,0.000,0.708,0.292,0.000,0.719,0.281,0.000,0.581,0.419,0.000,0.601,0.399,0.000,0.582,0.418,0.000,0.587,0.413,0.000,0.581,0.419,0.000,0.615,0.385,0.000,0.610,0.390,0.000,0.604,0.396,0.000,0.603,0.397,0.000,0.641,0.359,0.000,0.602,0.398,0.000,0.631,0.369,0.000,0.651,0.349,0.000,0.656,0.344,0.000,0.596,0.404,0.000,0.621,0.379,0.000,0.658,0.342,0.000,0.584,0.416,0.000,0.585,0.415,0.000,0.595,0.405,0.000,0.621,0.379,0.000,0.614,0.386,0.000,0.644,0.356,0.000,0.590,0.410,0.000,0.643,0.357,0.000,0.648,0.352,0.000,0.629,0.371,0.000,0.602,0.398,0.000,0.615,0.385,0.000,0.621,0.379,0.000,0.623,0.377,0.000,0.648,0.352,0.000,0.649,0.351,0.000,0.653,0.347,0.000,0.629,0.371,0.000,0.660,0.340,0.000,0.650,0.350,0.000,0.541,0.459,0.000,0.554,0.446,0.000,0.542,0.458,0.000,0.571,0.429,0.000,0.567,0.433,0.000,0.560,0.440,0.000,0.546,0.454,0.000,0.555,0.445,0.000,0.552,0.448,0.000,0.549,0.451,0.000,0.543,0.457,0.000,0.543,0.457,0.000,0.546,0.454,0.000,0.542,0.458,0.000,0.550,0.450,0.000,0.541,0.459,0.000,0.530,0.470,0.000,0.536,0.464,0.000,0.535,0.465,0.000,0.532,0.468,0.000,0.511,0.489,0.000,0.569,0.431,0.000,0.549,0.451,0.000,0.564,0.436,0.000,0.553,0.447,0.000,0.566,0.434,0.000,0.559,0.441,0.000,0.577,0.423,0.000,0.508,0.492,0.000,0.497,0.503,0.000,0.503,0.497,0.000,0.490,0.510};
			return value;
		}
		private double[] getColor_9_22_color_46()
		{
			double[] value = {0.000,0.052,0.948,0.000,0.063,0.937,0.000,0.065,0.935,0.000,0.064,0.936,0.000,0.070,0.930,0.000,0.072,0.928,0.000,0.073,0.927,0.000,0.072,0.928,0.000,0.074,0.926,0.000,0.318,0.682,0.000,0.329,0.671,0.000,0.294,0.706,0.000,0.327,0.673,0.000,0.350,0.650,0.000,0.325,0.675,0.000,0.331,0.669,0.000,0.379,0.621,0.000,0.391,0.609,0.000,0.410,0.590,0.000,0.380,0.620,0.000,0.449,0.551,0.000,0.379,0.621,0.000,0.385,0.615,0.000,0.412,0.588,0.000,0.396,0.604,0.000,0.383,0.617,0.000,0.417,0.583,0.000,0.409,0.591,0.000,0.412,0.588,0.000,0.428,0.572,0.000,0.417,0.583,0.000,0.483,0.517,0.000,0.525,0.475,0.000,0.485,0.515,0.000,0.475,0.525,0.000,0.509,0.491,0.000,0.492,0.508,0.000,0.489,0.511,0.000,0.502,0.498,0.000,0.513,0.487,0.000,0.474,0.526,0.000,0.481,0.519,0.000,0.567,0.433,0.000,0.568,0.432,0.000,0.570,0.430,0.000,0.567,0.433,0.000,0.570,0.430,0.000,0.566,0.434,0.000,0.570,0.430,0.000,0.570,0.430,0.000,0.570,0.430,0.000,0.568,0.432,0.000,0.569,0.431,0.000,0.567,0.433,0.000,0.573,0.427,0.000,0.569,0.431,0.000,0.571,0.429,0.000,0.571,0.429,0.000,0.572,0.428,0.000,0.573,0.427,0.000,0.570,0.430,0.000,0.572,0.428,0.000,0.572,0.428,0.000,0.573,0.427,0.000,0.573,0.427,0.000,0.566,0.434,0.000,0.573,0.427,0.000,0.574,0.426,0.000,0.566,0.434,0.000,0.573,0.427,0.000,0.559,0.441,0.000,0.572,0.428,0.000,0.561,0.439,0.000,0.561,0.439,0.000,0.573,0.427,0.000,0.572,0.428,0.000,0.558,0.442,0.000,0.575,0.425,0.000,0.570,0.430,0.000,0.558,0.442,0.000,0.575,0.425,0.000,0.564,0.436,0.000,0.564,0.436,0.000,0.565,0.435,0.000,0.567,0.433,0.000,0.713,0.287,0.000,0.727,0.273,0.000,0.751,0.249,0.000,0.752,0.248,0.000,0.747,0.253,0.000,0.752,0.248,0.000,0.753,0.247,0.000,0.726,0.274,0.000,0.728,0.272,0.000,0.723,0.277,0.000,0.733,0.267,0.000,0.751,0.249,0.000,0.746,0.254,0.000,0.749,0.251,0.000,0.751,0.249};
			return value;
		}
		private double[] getColor_9_22_color_47()
		{
			double[] value = {0.000,0.743,0.257,0.000,0.749,0.251,0.000,0.747,0.253,0.000,0.752,0.248,0.000,0.750,0.250,0.000,0.754,0.246,0.000,0.758,0.242,0.000,0.762,0.238,0.000,0.774,0.226,0.000,0.794,0.206,0.000,0.789,0.211,0.000,0.801,0.199,0.000,0.801,0.199,0.000,0.764,0.236,0.000,0.800,0.200,0.000,0.764,0.236,0.000,0.806,0.194,0.000,0.798,0.202,0.000,0.806,0.194,0.000,0.800,0.200,0.000,0.806,0.194,0.000,0.798,0.202,0.000,0.804,0.196,0.000,0.804,0.196,0.000,0.799,0.201,0.000,0.806,0.194,0.000,0.777,0.223,0.000,0.804,0.196,0.000,0.802,0.198,0.000,0.809,0.191,0.000,0.810,0.190,0.000,0.803,0.197,0.000,0.808,0.192,0.000,0.774,0.226,0.000,0.778,0.222,0.000,0.790,0.210,0.000,0.785,0.215,0.000,0.810,0.190,0.000,0.811,0.189,0.000,0.801,0.199,0.000,0.810,0.190,0.000,0.811,0.189,0.000,0.808,0.192,0.000,0.811,0.189,0.000,0.815,0.185,0.000,0.810,0.190,0.000,0.820,0.180,0.000,0.811,0.189,0.000,0.819,0.181,0.000,0.818,0.182,0.000,0.812,0.188,0.000,0.821,0.179,0.000,0.818,0.182,0.000,0.822,0.178,0.000,0.813,0.187,0.000,0.813,0.187,0.000,0.830,0.170,0.000,0.833,0.167,0.000,0.095,0.905,0.000,0.056,0.944,0.000,0.052,0.948,0.000,0.057,0.943,0.000,0.048,0.952,0.000,0.055,0.945,0.000,0.047,0.953,0.000,0.060,0.940,0.000,0.055,0.945,0.000,0.063,0.937,0.000,0.066,0.934,0.000,0.160,0.840,0.000,0.157,0.843,0.000,0.149,0.851,0.000,0.122,0.878,0.000,0.233,0.767,0.000,0.199,0.801,0.000,0.189,0.811,0.000,0.187,0.813,0.000,0.198,0.802,0.000,0.240,0.760,0.000,0.215,0.785,0.000,0.281,0.719,0.000,0.291,0.709,0.000,0.289,0.711,0.000,0.287,0.713,0.000,0.283,0.717,0.000,0.337,0.663,0.000,0.303,0.697,0.000,0.277,0.723,0.000,0.284,0.716,0.000,0.293,0.707,0.000,0.286,0.714,0.000,0.301,0.699,0.000,0.284,0.716,0.000,0.290,0.710,0.000,0.281,0.719,0.000,0.303,0.697,0.000,0.300,0.700,0.000,0.287,0.713,0.000,0.299,0.701,0.000,0.390,0.610};
			return value;
		}
		private double[] getColor_9_22_color_48()
		{
			double[] value = {0.000,0.381,0.619,0.000,0.388,0.612,0.000,0.382,0.618,0.000,0.366,0.634,0.000,0.388,0.612,0.000,0.396,0.604,0.000,0.395,0.605,0.000,0.572,0.428,0.000,0.572,0.428,0.000,0.575,0.425,0.000,0.557,0.443,0.000,0.557,0.443,0.000,0.564,0.436,0.000,0.558,0.442,0.000,0.560,0.440,0.000,0.559,0.441,0.000,0.562,0.438,0.000,0.559,0.441,0.000,0.560,0.440,0.000,0.560,0.440,0.000,0.564,0.436,0.000,0.562,0.438,0.000,0.563,0.437,0.000,0.562,0.438,0.000,0.562,0.438,0.000,0.567,0.433,0.000,0.567,0.433,0.000,0.562,0.438,0.000,0.565,0.435,0.000,0.569,0.431,0.000,0.568,0.432,0.000,0.566,0.434,0.000,0.568,0.432,0.000,0.571,0.429,0.000,0.571,0.429,0.000,0.570,0.430,0.000,0.570,0.430,0.000,0.572,0.428,0.000,0.570,0.430,0.000,0.614,0.386,0.000,0.621,0.379,0.000,0.610,0.390,0.000,0.615,0.385,0.000,0.596,0.404,0.000,0.605,0.395,0.000,0.623,0.377,0.000,0.608,0.392,0.000,0.589,0.411,0.000,0.623,0.377,0.000,0.616,0.384,0.000,0.601,0.399,0.000,0.619,0.381,0.000,0.614,0.386,0.000,0.619,0.381,0.000,0.617,0.383,0.000,0.627,0.373,0.000,0.624,0.376,0.000,0.628,0.372,0.000,0.627,0.373,0.000,0.625,0.375,0.000,0.628,0.372,0.000,0.629,0.371,0.000,0.630,0.370,0.000,0.629,0.371,0.000,0.638,0.362,0.000,0.635,0.365,0.000,0.642,0.358,0.000,0.642,0.358,0.000,0.627,0.373,0.000,0.647,0.353,0.000,0.647,0.353,0.000,0.694,0.306,0.000,0.674,0.326,0.000,0.671,0.329,0.000,0.665,0.335,0.000,0.701,0.299,0.000,0.698,0.302,0.000,0.659,0.341,0.000,0.658,0.342,0.000,0.711,0.289,0.000,0.712,0.288,0.000,0.708,0.292,0.000,0.690,0.310,0.000,0.707,0.293,0.000,0.663,0.337,0.000,0.709,0.291,0.000,0.716,0.284,0.000,0.677,0.323,0.000,0.654,0.346,0.000,0.673,0.327,0.000,0.713,0.287,0.000,0.697,0.303,0.000,0.696,0.304,0.000,0.663,0.337,0.000,0.666,0.334,0.000,0.715,0.285,0.000,0.707,0.293,0.000,0.677,0.323,0.000,0.665,0.335,0.000,0.700,0.300};
			return value;
		}
		private double[] getColor_9_22_color_49()
		{
			double[] value = {0.000,0.710,0.290,0.000,0.706,0.294,0.000,0.715,0.285,0.000,0.713,0.287,0.000,0.698,0.302,0.000,0.727,0.273,0.000,0.725,0.275,0.000,0.722,0.278,0.000,0.725,0.275,0.000,0.732,0.268,0.000,0.732,0.268,0.000,0.735,0.265,0.000,0.740,0.260,0.000,0.727,0.273,0.000,0.731,0.269,0.000,0.731,0.269,0.000,0.730,0.270,0.000,0.722,0.278,0.000,0.759,0.241,0.000,0.755,0.245,0.000,0.757,0.243,0.000,0.760,0.240,0.000,0.729,0.271,0.000,0.734,0.266,0.000,0.753,0.247,0.000,0.760,0.240,0.000,0.731,0.269,0.000,0.748,0.252,0.000,0.761,0.239,0.000,0.719,0.281,0.000,0.761,0.239,0.000,0.760,0.240,0.000,0.766,0.234,0.000,0.769,0.231,0.000,0.047,0.953,0.000,0.051,0.949,0.000,0.052,0.948,0.000,0.052,0.948,0.000,0.053,0.947,0.000,0.082,0.918,0.000,0.124,0.876,0.000,0.562,0.438,0.000,0.564,0.436,0.000,0.563,0.437,0.000,0.567,0.433,0.000,0.562,0.438,0.000,0.562,0.438,0.000,0.562,0.438,0.000,0.565,0.435,0.000,0.581,0.419,0.000,0.596,0.404,0.000,0.578,0.422,0.000,0.585,0.415,0.000,0.577,0.423,0.000,0.563,0.437,0.000,0.591,0.409,0.000,0.610,0.390,0.000,0.594,0.406,0.000,0.601,0.399,0.000,0.569,0.431,0.000,0.592,0.408,0.000,0.604,0.396,0.000,0.589,0.411,0.000,0.565,0.435,0.000,0.594,0.406,0.000,0.646,0.354,0.000,0.648,0.352,0.000,0.638,0.362,0.000,0.638,0.362,0.000,0.651,0.349,0.000,0.621,0.379,0.000,0.630,0.370,0.000,0.624,0.376,0.000,0.622,0.378,0.000,0.626,0.374,0.000,0.667,0.333,0.000,0.671,0.329,0.000,0.691,0.309,0.000,0.532,0.468,0.000,0.535,0.465,0.000,0.527,0.473,0.000,0.530,0.470,0.000,0.528,0.472,0.000,0.540,0.460,0.000,0.535,0.465,0.000,0.536,0.464,0.000,0.537,0.463,0.000,0.534,0.466,0.000,0.535,0.465,0.000,0.543,0.457,0.000,0.539,0.461,0.000,0.537,0.463,0.000,0.548,0.452,0.000,0.542,0.458,0.000,0.541,0.459,0.000,0.540,0.460,0.000,0.544,0.456,0.000,0.558,0.442,0.000,0.543,0.457,0.000,0.565,0.435};
			return value;
		}
		private double[] getColor_9_22_color_50()
		{
			double[] value = {0.000,0.565,0.435,0.000,0.545,0.455,0.000,0.545,0.455,0.000,0.574,0.426,0.000,0.576,0.424,0.000,0.547,0.453,0.000,0.549,0.451,0.000,0.550,0.450,0.000,0.554,0.446,0.000,0.580,0.420,0.000,0.566,0.434,0.000,0.585,0.415,0.000,0.572,0.428,0.000,0.543,0.457,0.000,0.593,0.407,0.000,0.573,0.427,0.000,0.592,0.408,0.000,0.612,0.388,0.000,0.584,0.416,0.000,0.589,0.411,0.000,0.601,0.399,0.000,0.569,0.431,0.000,0.588,0.412,0.000,0.582,0.418,0.000,0.575,0.425,0.000,0.624,0.376,0.000,0.621,0.379,0.000,0.619,0.381,0.000,0.621,0.379,0.000,0.581,0.419,0.000,0.575,0.425,0.000,0.636,0.364,0.000,0.653,0.347,0.000,0.645,0.355,0.000,0.673,0.327,0.000,0.654,0.346,0.000,0.628,0.372,0.000,0.676,0.324,0.000,0.636,0.364,0.000,0.664,0.336,0.000,0.678,0.322,0.000,0.670,0.330,0.000,0.654,0.346,0.000,0.659,0.341,0.000,0.659,0.341,0.000,0.489,0.511,0.000,0.462,0.538,0.000,0.511,0.489,0.000,0.498,0.502,0.000,0.490,0.510,0.000,0.489,0.511,0.000,0.509,0.491,0.000,0.512,0.488,0.000,0.518,0.482,0.000,0.505,0.495,0.000,0.503,0.497,0.000,0.496,0.504,0.000,0.471,0.529,0.000,0.523,0.477,0.000,0.479,0.521,0.000,0.463,0.537,0.000,0.478,0.522,0.000,0.507,0.493,0.000,0.485,0.515,0.000,0.519,0.481,0.000,0.454,0.546,0.000,0.509,0.491,0.000,0.477,0.523,0.000,0.486,0.514,0.000,0.517,0.483,0.000,0.447,0.553,0.000,0.454,0.546,0.000,0.450,0.550,0.000,0.446,0.554,0.000,0.422,0.578,0.000,0.408,0.592,0.000,0.412,0.588,0.000,0.396,0.604,0.000,0.389,0.611,0.000,0.442,0.558,0.000,0.438,0.562,0.000,0.413,0.587,0.000,0.415,0.585,0.000,0.386,0.614,0.000,0.384,0.616,0.000,0.401,0.599,0.000,0.456,0.544,0.000,0.451,0.549,0.000,0.426,0.574,0.000,0.453,0.547,0.000,0.446,0.554,0.000,0.437,0.563,0.000,0.438,0.562,0.000,0.446,0.554,0.000,0.409,0.591,0.000,0.375,0.625,0.000,0.372,0.628,0.000,0.367,0.633,0.000,0.562,0.438,0.000,0.554,0.446};
			return value;
		}
		private double[] getColor_9_22_color_51()
		{
			double[] value = {0.000,0.544,0.456,0.000,0.543,0.457,0.000,0.560,0.440,0.000,0.562,0.438,0.000,0.554,0.446,0.000,0.556,0.444,0.000,0.562,0.438,0.000,0.565,0.435,0.000,0.562,0.438,0.000,0.561,0.439,0.000,0.558,0.442,0.000,0.562,0.438,0.000,0.565,0.435,0.000,0.557,0.443,0.000,0.561,0.439,0.000,0.551,0.449,0.000,0.558,0.442,0.000,0.684,0.316,0.000,0.701,0.299,0.000,0.712,0.288,0.000,0.698,0.302,0.000,0.697,0.303,0.000,0.702,0.298,0.000,0.699,0.301,0.000,0.732,0.268,0.000,0.713,0.287,0.000,0.721,0.279,0.000,0.706,0.294,0.000,0.715,0.285,0.000,0.717,0.283,0.000,0.720,0.280,0.000,0.717,0.283,0.000,0.754,0.246,0.000,0.775,0.225,0.000,0.774,0.226,0.000,0.758,0.242,0.000,0.691,0.309,0.000,0.713,0.287,0.000,0.715,0.285,0.000,0.720,0.280,0.000,0.752,0.248,0.000,0.748,0.252,0.000,0.755,0.245,0.000,0.760,0.240,0.000,0.768,0.232,0.000,0.752,0.248,0.000,0.743,0.257,0.000,0.755,0.245,0.000,0.763,0.237,0.000,0.749,0.251,0.000,0.716,0.284,0.000,0.727,0.273,0.000,0.746,0.254,0.000,0.776,0.224,0.000,0.774,0.226,0.000,0.753,0.247,0.000,0.764,0.236,0.000,0.771,0.229,0.000,0.756,0.244,0.000,0.760,0.240,0.000,0.748,0.252,0.000,0.772,0.228,0.000,0.739,0.261,0.000,0.745,0.255,0.000,0.761,0.239,0.000,0.756,0.244,0.000,0.755,0.245,0.000,0.773,0.227,0.000,0.773,0.227,0.000,0.772,0.228,0.000,0.869,0.131,0.000,0.875,0.125,0.000,0.856,0.144,0.000,0.858,0.142,0.000,0.743,0.257,0.000,0.672,0.328,0.000,0.649,0.351,0.000,0.676,0.324,0.000,0.654,0.346,0.000,0.667,0.333,0.000,0.647,0.353,0.000,0.654,0.346,0.000,0.651,0.349,0.000,0.697,0.303,0.000,0.709,0.291,0.000,0.699,0.301,0.000,0.561,0.439,0.000,0.555,0.445,0.000,0.562,0.438,0.000,0.586,0.414,0.000,0.567,0.433,0.000,0.546,0.454,0.000,0.578,0.422,0.000,0.604,0.396,0.000,0.580,0.420,0.000,0.560,0.440,0.000,0.588,0.412,0.000,0.577,0.423,0.000,0.590,0.410,0.000,0.583,0.417};
			return value;
		}
		private double[] getColor_9_22_color_52()
		{
			double[] value = {0.000,0.561,0.439,0.000,0.572,0.428,0.000,0.558,0.442,0.000,0.600,0.400,0.000,0.599,0.401,0.000,0.610,0.390,0.000,0.599,0.401,0.000,0.629,0.371,0.000,0.632,0.368,0.000,0.579,0.421,0.000,0.560,0.440,0.000,0.621,0.379,0.000,0.620,0.380,0.000,0.559,0.441,0.000,0.617,0.383,0.000,0.627,0.373,0.000,0.578,0.422,0.000,0.618,0.382,0.000,0.589,0.411,0.000,0.609,0.391,0.000,0.578,0.422,0.000,0.630,0.370,0.000,0.561,0.439,0.000,0.591,0.409,0.000,0.624,0.376,0.000,0.544,0.456,0.000,0.606,0.394,0.000,0.630,0.370,0.000,0.593,0.407,0.000,0.624,0.376,0.000,0.604,0.396,0.000,0.618,0.382,0.000,0.475,0.525,0.000,0.508,0.492,0.000,0.468,0.532,0.000,0.474,0.526,0.000,0.485,0.515,0.000,0.473,0.527,0.000,0.504,0.496,0.000,0.525,0.475,0.000,0.460,0.540,0.000,0.467,0.533,0.000,0.531,0.469,0.000,0.536,0.464,0.000,0.526,0.474,0.000,0.539,0.461,0.000,0.514,0.486,0.000,0.526,0.474,0.000,0.476,0.524,0.000,0.544,0.456,0.000,0.483,0.517,0.000,0.500,0.500,0.000,0.520,0.480,0.000,0.542,0.458,0.000,0.541,0.459,0.000,0.534,0.466,0.000,0.509,0.491,0.000,0.529,0.471,0.000,0.509,0.491,0.000,0.532,0.468,0.000,0.517,0.483,0.000,0.530,0.470,0.000,0.524,0.476,0.000,0.521,0.479,0.000,0.473,0.527,0.000,0.469,0.531,0.000,0.505,0.495,0.000,0.509,0.491,0.000,0.513,0.487,0.000,0.505,0.495,0.000,0.469,0.531,0.000,0.517,0.483,0.000,0.518,0.482,0.000,0.481,0.519,0.000,0.492,0.508,0.000,0.478,0.522,0.000,0.495,0.505,0.000,0.491,0.509,0.000,0.483,0.517,0.000,0.492,0.508,0.000,0.487,0.513,0.000,0.474,0.526,0.000,0.463,0.537,0.000,0.462,0.538,0.000,0.486,0.514,0.000,0.459,0.541,0.000,0.477,0.523,0.000,0.463,0.537,0.000,0.525,0.475,0.000,0.515,0.485,0.000,0.505,0.495,0.000,0.535,0.465,0.000,0.417,0.583,0.000,0.453,0.547,0.000,0.411,0.589,0.000,0.409,0.591,0.000,0.408,0.592,0.000,0.428,0.572,0.000,0.440,0.560,0.000,0.453,0.547};
			return value;
		}
		private double[] getColor_9_22_color_53()
		{
			double[] value = {0.000,0.438,0.562,0.000,0.428,0.572,0.000,0.403,0.597,0.000,0.426,0.574,0.000,0.451,0.549,0.000,0.409,0.591,0.000,0.419,0.581,0.000,0.407,0.593,0.000,0.443,0.557,0.000,0.446,0.554,0.000,0.433,0.567,0.000,0.440,0.560,0.000,0.421,0.579,0.000,0.397,0.603,0.000,0.402,0.598,0.000,0.408,0.592,0.000,0.415,0.585,0.000,0.416,0.584,0.000,0.444,0.556,0.000,0.449,0.551,0.000,0.457,0.543,0.000,0.459,0.541,0.000,0.430,0.570,0.000,0.419,0.581,0.000,0.414,0.586,0.000,0.409,0.591,0.000,0.415,0.585,0.000,0.423,0.577,0.000,0.455,0.545,0.000,0.444,0.556,0.000,0.450,0.550,0.000,0.397,0.603,0.000,0.437,0.563,0.000,0.392,0.608,0.000,0.394,0.606,0.000,0.407,0.593,0.000,0.397,0.603,0.000,0.391,0.609,0.000,0.386,0.614,0.000,0.373,0.627,0.000,0.381,0.619,0.000,0.375,0.625,0.000,0.379,0.621,0.000,0.373,0.627,0.000,0.331,0.669,0.000,0.384,0.616,0.000,0.380,0.620,0.000,0.380,0.620,0.000,0.333,0.667,0.000,0.344,0.656,0.000,0.336,0.664,0.000,0.379,0.621,0.000,0.349,0.651,0.000,0.380,0.620,0.000,0.387,0.613,0.000,0.377,0.623,0.000,0.358,0.642,0.000,0.387,0.613,0.000,0.371,0.629,0.000,0.328,0.672,0.000,0.360,0.640,0.000,0.347,0.653,0.000,0.378,0.622,0.000,0.385,0.615,0.000,0.383,0.617,0.000,0.359,0.641,0.000,0.380,0.620,0.000,0.370,0.630,0.000,0.343,0.657,0.000,0.364,0.636,0.000,0.345,0.655,0.000,0.338,0.662,0.000,0.336,0.664,0.000,0.335,0.665,0.000,0.350,0.650,0.000,0.327,0.673,0.000,0.325,0.675,0.000,0.320,0.680,0.000,0.303,0.697,0.000,0.302,0.698,0.000,0.320,0.680,0.000,0.311,0.689,0.000,0.313,0.687,0.000,0.317,0.683,0.000,0.584,0.416,0.000,0.583,0.417,0.000,0.578,0.422,0.000,0.584,0.416,0.000,0.586,0.414,0.000,0.589,0.411,0.000,0.575,0.425,0.000,0.587,0.413,0.000,0.575,0.425,0.000,0.586,0.414,0.000,0.573,0.427,0.000,0.585,0.415,0.000,0.573,0.427,0.000,0.578,0.422,0.000,0.587,0.413,0.000,0.588,0.412};
			return value;
		}
		private double[] getColor_9_22_color_54()
		{
			double[] value = {0.000,0.576,0.424,0.000,0.591,0.409,0.000,0.591,0.409,0.000,0.583,0.417,0.000,0.570,0.430,0.000,0.583,0.417,0.000,0.567,0.433,0.000,0.577,0.423,0.000,0.583,0.417,0.000,0.565,0.435,0.000,0.570,0.430,0.000,0.582,0.418,0.000,0.568,0.432,0.000,0.569,0.431,0.000,0.780,0.220,0.000,0.781,0.219,0.000,0.793,0.207,0.000,0.790,0.210,0.000,0.792,0.208,0.000,0.806,0.194,0.000,0.788,0.212,0.000,0.792,0.208,0.000,0.797,0.203,0.000,0.815,0.185,0.000,0.844,0.156,0.000,0.834,0.166,0.000,0.795,0.205,0.000,0.860,0.140,0.000,0.861,0.139,0.000,0.801,0.199,0.000,0.837,0.163,0.000,0.789,0.211,0.000,0.850,0.150,0.000,0.862,0.138,0.000,0.862,0.138,0.000,0.805,0.195,0.000,0.824,0.176,0.000,0.853,0.147,0.000,0.846,0.154,0.000,0.825,0.175,0.000,0.815,0.185,0.000,0.856,0.144,0.000,0.857,0.143,0.000,0.857,0.143,0.000,0.850,0.150,0.000,0.865,0.135,0.000,0.859,0.141,0.000,0.858,0.142,0.000,0.867,0.133,0.000,0.867,0.133,0.000,0.867,0.133,0.000,0.843,0.157,0.000,0.855,0.145,0.000,0.856,0.144,0.000,0.901,0.099,0.000,0.905,0.095,0.000,0.906,0.094,0.000,0.855,0.145,0.000,0.902,0.098,0.000,0.915,0.085,0.000,0.897,0.103,0.000,0.893,0.107,0.000,0.901,0.099,0.000,0.893,0.107,0.000,0.902,0.098,0.000,0.894,0.106,0.000,0.897,0.103,0.000,0.895,0.105,0.000,0.900,0.100,0.000,0.894,0.106,0.000,0.901,0.099,0.000,0.908,0.092,0.000,0.899,0.101,0.000,0.905,0.095,0.000,0.907,0.093,0.000,0.906,0.094,0.000,0.905,0.095,0.000,0.909,0.091,0.000,0.906,0.094,0.000,0.905,0.095,0.000,0.908,0.092,0.000,0.913,0.087,0.000,0.908,0.092,0.000,0.911,0.089,0.000,0.902,0.098,0.000,0.906,0.094,0.000,0.894,0.106,0.000,0.895,0.105,0.000,0.897,0.103,0.000,0.887,0.113,0.000,0.886,0.114,0.000,0.895,0.105,0.000,0.904,0.096,0.000,0.885,0.115,0.000,0.887,0.113,0.000,0.893,0.107,0.000,0.892,0.108,0.000,0.883,0.117,0.000,0.915,0.085,0.000,0.883,0.117};
			return value;
		}
		private double[] getColor_9_22_color_55()
		{
			double[] value = {0.000,0.892,0.108,0.000,0.897,0.103,0.000,0.896,0.104,0.000,0.884,0.116,0.000,0.898,0.102,0.000,0.892,0.108,0.000,0.897,0.103,0.000,0.882,0.118,0.000,0.919,0.081,0.000,0.919,0.081,0.000,0.892,0.108,0.000,0.883,0.117,0.000,0.890,0.110,0.000,0.892,0.108,0.000,0.890,0.110,0.000,0.896,0.104,0.000,0.885,0.115,0.000,0.892,0.108,0.000,0.890,0.110,0.000,0.886,0.114,0.000,0.888,0.112,0.000,0.902,0.098,0.000,0.901,0.099,0.000,0.902,0.098,0.000,0.902,0.098,0.000,0.902,0.098,0.000,0.895,0.105,0.000,0.897,0.103,0.000,0.892,0.108,0.000,0.895,0.105,0.000,0.896,0.104,0.000,0.892,0.108,0.000,0.884,0.116,0.000,0.906,0.094,0.000,0.907,0.093,0.000,0.905,0.095,0.000,0.888,0.112,0.000,0.883,0.117,0.000,0.904,0.096,0.000,0.890,0.110,0.000,0.897,0.103,0.000,0.896,0.104,0.000,0.901,0.099,0.000,0.893,0.107,0.000,0.888,0.112,0.000,0.891,0.109,0.000,0.876,0.124,0.000,0.891,0.109,0.000,0.894,0.106,0.000,0.889,0.111,0.000,0.890,0.110,0.000,0.882,0.118,0.000,0.882,0.118,0.000,0.884,0.116,0.000,0.892,0.108,0.000,0.884,0.116,0.000,0.874,0.126,0.000,0.890,0.110,0.000,0.894,0.106,0.000,0.880,0.120,0.000,0.873,0.127,0.000,0.884,0.116,0.000,0.873,0.127,0.000,0.883,0.117,0.000,0.882,0.118,0.000,0.886,0.114,0.000,0.884,0.116,0.000,0.875,0.125,0.000,0.883,0.117,0.000,0.893,0.107,0.000,0.885,0.115,0.000,0.875,0.125,0.000,0.880,0.120,0.000,0.875,0.125,0.000,0.879,0.121,0.000,0.886,0.114,0.000,0.879,0.121,0.000,0.880,0.120,0.000,0.879,0.121,0.000,0.871,0.129,0.000,0.877,0.123,0.000,0.886,0.114,0.000,0.888,0.112,0.000,0.881,0.119,0.000,0.882,0.118,0.000,0.880,0.120,0.000,0.881,0.119,0.000,0.882,0.118,0.000,0.879,0.121,0.000,0.878,0.122,0.000,0.884,0.116,0.000,0.879,0.121,0.000,0.869,0.131,0.000,0.868,0.132,0.000,0.861,0.139,0.000,0.874,0.126,0.000,0.870,0.130,0.000,0.881,0.119,0.000,0.871,0.129,0.000,0.866,0.134};
			return value;
		}
		private double[] getColor_9_22_color_56()
		{
			double[] value = {0.000,0.866,0.134,0.000,0.862,0.138,0.000,0.867,0.133,0.000,0.869,0.131,0.000,0.874,0.126,0.000,0.854,0.146,0.000,0.871,0.129,0.000,0.860,0.140,0.000,0.860,0.140,0.000,0.864,0.136,0.000,0.861,0.139,0.000,0.871,0.129,0.000,0.852,0.148,0.000,0.861,0.139,0.000,0.862,0.138,0.000,0.858,0.142,0.000,0.869,0.131,0.000,0.850,0.150,0.000,0.850,0.150,0.000,0.848,0.152,0.000,0.868,0.132,0.000,0.853,0.147,0.000,0.858,0.142,0.000,0.860,0.140,0.000,0.876,0.124,0.000,0.854,0.146,0.000,0.862,0.138,0.000,0.864,0.136,0.000,0.860,0.140,0.000,0.876,0.124,0.000,0.863,0.137,0.000,0.855,0.145,0.000,0.857,0.143,0.000,0.859,0.141,0.000,0.857,0.143,0.000,0.875,0.125,0.000,0.859,0.141,0.000,0.874,0.126,0.000,0.858,0.142,0.000,0.859,0.141,0.000,0.859,0.141,0.000,0.856,0.144,0.000,0.856,0.144,0.000,0.799,0.201,0.000,0.804,0.196,0.000,0.806,0.194,0.000,0.813,0.187,0.000,0.801,0.199,0.000,0.826,0.174,0.000,0.802,0.198,0.000,0.812,0.188,0.000,0.844,0.156,0.000,0.837,0.163,0.000,0.848,0.152,0.000,0.824,0.176,0.000,0.840,0.160,0.000,0.871,0.129,0.000,0.871,0.129,0.000,0.855,0.145,0.000,0.836,0.164,0.000,0.871,0.129,0.000,0.835,0.165,0.000,0.873,0.127,0.000,0.870,0.130,0.000,0.873,0.127,0.000,0.859,0.141,0.000,0.857,0.143,0.000,0.864,0.136,0.000,0.845,0.155,0.000,0.859,0.141,0.000,0.865,0.135,0.000,0.856,0.144,0.000,0.847,0.153,0.000,0.854,0.146,0.000,0.843,0.157,0.000,0.842,0.158,0.000,0.865,0.135,0.000,0.849,0.151,0.000,0.855,0.145,0.000,0.863,0.137,0.000,0.865,0.135,0.000,0.839,0.161,0.000,0.850,0.150,0.000,0.849,0.151,0.000,0.861,0.139,0.000,0.863,0.137,0.000,0.867,0.133,0.000,0.862,0.138,0.000,0.865,0.135,0.000,0.826,0.174,0.000,0.862,0.138,0.000,0.861,0.139,0.000,0.831,0.169,0.000,0.826,0.174,0.000,0.808,0.192,0.000,0.823,0.177,0.000,0.822,0.178,0.000,0.825,0.175,0.000,0.844,0.156,0.000,0.840,0.160};
			return value;
		}
		private double[] getColor_9_22_color_57()
		{
			double[] value = {0.000,0.818,0.182,0.000,0.825,0.175,0.000,0.833,0.167,0.000,0.812,0.188,0.000,0.753,0.247,0.000,0.733,0.267,0.000,0.729,0.271,0.000,0.746,0.254,0.000,0.730,0.270,0.000,0.758,0.242,0.000,0.772,0.228,0.000,0.753,0.247,0.000,0.744,0.256,0.000,0.737,0.263,0.000,0.737,0.263,0.000,0.782,0.218,0.000,0.754,0.246,0.000,0.751,0.249,0.000,0.790,0.210,0.000,0.738,0.262,0.000,0.749,0.251,0.000,0.748,0.252,0.000,0.770,0.230,0.000,0.742,0.258,0.000,0.745,0.255,0.000,0.794,0.206,0.000,0.734,0.266,0.000,0.778,0.222,0.000,0.732,0.268,0.000,0.739,0.261,0.000,0.771,0.229,0.000,0.757,0.243,0.000,0.771,0.229,0.000,0.724,0.276,0.000,0.769,0.231,0.000,0.785,0.215,0.000,0.753,0.247,0.000,0.742,0.258,0.000,0.757,0.243,0.000,0.793,0.207,0.000,0.779,0.221,0.000,0.749,0.251,0.000,0.728,0.272,0.000,0.790,0.210,0.000,0.734,0.266,0.000,0.747,0.253,0.000,0.729,0.271,0.000,0.729,0.271,0.000,0.804,0.196,0.000,0.793,0.207,0.000,0.755,0.245,0.000,0.763,0.237,0.000,0.814,0.186,0.000,0.751,0.249,0.000,0.798,0.202,0.000,0.787,0.213,0.000,0.740,0.260,0.000,0.783,0.217,0.000,0.764,0.236,0.000,0.772,0.228,0.000,0.760,0.240,0.000,0.757,0.243,0.000,0.738,0.262,0.000,0.797,0.203,0.000,0.732,0.268,0.000,0.788,0.212,0.000,0.729,0.271,0.000,0.797,0.203,0.000,0.677,0.323,0.000,0.726,0.274,0.000,0.696,0.304,0.000,0.700,0.300,0.000,0.662,0.338,0.000,0.718,0.282,0.000,0.730,0.270,0.000,0.693,0.307,0.000,0.719,0.281,0.000,0.672,0.328,0.000,0.660,0.340,0.000,0.682,0.318,0.000,0.690,0.310,0.000,0.707,0.293,0.000,0.726,0.274,0.000,0.717,0.283,0.000,0.683,0.317,0.000,0.692,0.308,0.000,0.736,0.264,0.000,0.680,0.320,0.000,0.727,0.273,0.000,0.701,0.299,0.000,0.735,0.265,0.000,0.719,0.281,0.000,0.708,0.292,0.000,0.731,0.269,0.000,0.732,0.268,0.000,0.708,0.292,0.000,0.714,0.286,0.000,0.658,0.342,0.000,0.701,0.299,0.000,0.707,0.293};
			return value;
		}
		private double[] getColor_9_22_color_58()
		{
			double[] value = {0.000,0.650,0.350,0.000,0.668,0.332,0.000,0.701,0.299,0.000,0.687,0.313,0.000,0.654,0.346,0.000,0.703,0.297,0.000,0.702,0.298,0.000,0.659,0.341,0.000,0.689,0.311,0.000,0.657,0.343,0.000,0.681,0.319,0.000,0.708,0.292,0.000,0.703,0.297,0.000,0.704,0.296,0.000,0.721,0.279,0.000,0.661,0.339,0.000,0.703,0.297,0.000,0.658,0.342,0.000,0.703,0.297,0.000,0.657,0.343,0.000,0.663,0.337,0.000,0.676,0.324,0.000,0.705,0.295,0.000,0.666,0.334,0.000,0.715,0.285,0.000,0.692,0.308,0.000,0.675,0.325,0.000,0.679,0.321,0.000,0.685,0.315,0.000,0.718,0.282,0.000,0.665,0.335,0.000,0.691,0.309,0.000,0.679,0.321,0.000,0.690,0.310,0.000,0.708,0.292,0.000,0.721,0.279,0.000,0.718,0.282,0.000,0.697,0.303,0.000,0.714,0.286,0.000,0.724,0.276,0.000,0.705,0.295,0.000,0.688,0.312,0.000,0.725,0.275,0.000,0.702,0.298,0.000,0.588,0.412,0.000,0.589,0.411,0.000,0.595,0.405,0.000,0.621,0.379,0.000,0.604,0.396,0.000,0.586,0.414,0.000,0.572,0.428,0.000,0.599,0.401,0.000,0.580,0.420,0.000,0.588,0.412,0.000,0.589,0.411,0.000,0.588,0.412,0.000,0.565,0.435,0.000,0.566,0.434,0.000,0.572,0.428,0.000,0.573,0.427,0.000,0.615,0.385,0.000,0.619,0.381,0.000,0.641,0.359,0.000,0.596,0.404,0.000,0.622,0.378,0.000,0.623,0.377,0.000,0.622,0.378,0.000,0.619,0.381,0.000,0.592,0.408,0.000,0.601,0.399,0.000,0.598,0.402,0.000,0.643,0.357,0.000,0.586,0.414,0.000,0.622,0.378,0.000,0.642,0.358,0.000,0.634,0.366,0.000,0.622,0.378,0.000,0.636,0.364,0.000,0.614,0.386,0.000,0.611,0.389,0.000,0.643,0.357,0.000,0.650,0.350,0.000,0.630,0.370,0.000,0.636,0.364,0.000,0.607,0.393,0.000,0.638,0.362,0.000,0.628,0.372,0.000,0.644,0.356,0.000,0.604,0.396,0.000,0.632,0.368,0.000,0.619,0.381,0.000,0.636,0.364,0.000,0.654,0.346,0.000,0.559,0.441,0.000,0.392,0.608,0.000,0.333,0.667,0.000,0.340,0.660,0.000,0.336,0.664,0.000,0.335,0.665,0.000,0.328,0.672};
			return value;
		}
		private double[] getColor_9_22_color_59()
		{
			double[] value = {0.000,0.324,0.676,0.000,0.329,0.671,0.000,0.320,0.680,0.000,0.330,0.670,0.000,0.330,0.670,0.000,0.314,0.686,0.000,0.319,0.681,0.000,0.315,0.685,0.000,0.325,0.675,0.000,0.317,0.683,0.000,0.330,0.670,0.000,0.323,0.677,0.000,0.328,0.672,0.000,0.318,0.682,0.000,0.331,0.669,0.000,0.322,0.678,0.000,0.312,0.688,0.000,0.313,0.687,0.000,0.302,0.698,0.000,0.305,0.695,0.000,0.305,0.695,0.000,0.301,0.699,0.000,0.302,0.698,0.000,0.307,0.693,0.000,0.309,0.691,0.000,0.308,0.692,0.000,0.312,0.688,0.000,0.293,0.707,0.000,0.295,0.705,0.000,0.307,0.693,0.000,0.301,0.699,0.000,0.298,0.702,0.000,0.303,0.697,0.000,0.295,0.705,0.000,0.295,0.705,0.000,0.303,0.697,0.000,0.296,0.704,0.000,0.289,0.711,0.000,0.297,0.703,0.000,0.287,0.713,0.000,0.047,0.953,0.000,0.065,0.935,0.000,0.045,0.955,0.000,0.079,0.921,0.000,0.067,0.933,0.000,0.045,0.955,0.000,0.045,0.955,0.000,0.047,0.953,0.000,0.060,0.940,0.000,0.078,0.922,0.000,0.045,0.955,0.000,0.091,0.909,0.000,0.127,0.873,0.000,0.126,0.874,0.000,0.120,0.880,0.000,0.185,0.815,0.000,0.121,0.879,0.000,0.242,0.758,0.000,0.237,0.763,0.000,0.230,0.770,0.000,0.262,0.738,0.000,0.216,0.784,0.000,0.262,0.738,0.000,0.270,0.730,0.000,0.336,0.664,0.000,0.329,0.671,0.000,0.318,0.682,0.000,0.280,0.720,0.000,0.326,0.674,0.000,0.290,0.710,0.000,0.317,0.683,0.000,0.310,0.690,0.000,0.354,0.646,0.000,0.330,0.670,0.000,0.362,0.638,0.000,0.308,0.692,0.000,0.372,0.628,0.000,0.378,0.622,0.000,0.392,0.608,0.000,0.370,0.630,0.000,0.372,0.628,0.000,0.384,0.616,0.000,0.409,0.591,0.000,0.366,0.634,0.000,0.366,0.634,0.000,0.587,0.413,0.000,0.586,0.414,0.000,0.594,0.406,0.000,0.593,0.407,0.000,0.594,0.406,0.000,0.593,0.407,0.000,0.589,0.411,0.000,0.591,0.409,0.000,0.591,0.409,0.000,0.593,0.407,0.000,0.593,0.407,0.000,0.592,0.408,0.000,0.594,0.406,0.000,0.593,0.407,0.000,0.592,0.408};
			return value;
		}
		private double[] getColor_9_22_color_60()
		{
			double[] value = {0.000,0.591,0.409,0.000,0.592,0.408,0.000,0.591,0.409,0.000,0.588,0.412,0.000,0.579,0.421,0.000,0.585,0.415,0.000,0.873,0.127,0.000,0.878,0.122,0.000,0.871,0.129,0.000,0.868,0.132,0.000,0.883,0.117,0.000,0.871,0.129,0.000,0.867,0.133,0.000,0.886,0.114,0.000,0.897,0.103,0.000,0.896,0.104,0.000,0.901,0.099,0.000,0.900,0.100,0.000,0.879,0.121,0.000,0.889,0.111,0.000,0.871,0.129,0.000,0.881,0.119,0.000,0.881,0.119,0.000,0.907,0.093,0.000,0.885,0.115,0.000,0.863,0.137,0.000,0.884,0.116,0.000,0.908,0.092,0.000,0.878,0.122,0.000,0.893,0.107,0.000,0.889,0.111,0.000,0.886,0.114,0.000,0.892,0.108,0.000,0.878,0.122,0.000,0.872,0.128,0.000,0.901,0.099,0.000,0.887,0.113,0.000,0.899,0.101,0.000,0.886,0.114,0.000,0.867,0.133,0.000,0.883,0.117,0.000,0.893,0.107,0.000,0.895,0.105,0.000,0.889,0.111,0.000,0.872,0.128,0.000,0.870,0.130,0.000,0.909,0.091,0.000,0.904,0.096,0.000,0.911,0.089,0.000,0.870,0.130,0.000,0.913,0.087,0.000,0.916,0.084,0.000,0.928,0.072,0.000,0.907,0.093,0.000,0.934,0.066,0.000,0.933,0.067,0.000,0.936,0.064,0.000,0.921,0.079,0.000,0.937,0.063,0.000,0.904,0.096,0.000,0.901,0.099,0.000,0.929,0.071,0.000,0.937,0.063,0.000,0.923,0.077,0.000,0.936,0.064,0.000,0.926,0.074,0.000,0.940,0.060,0.000,0.938,0.062,0.000,0.934,0.066,0.000,0.932,0.068,0.000,0.931,0.069,0.000,0.911,0.089,0.000,0.917,0.083,0.000,0.929,0.071,0.000,0.928,0.072,0.000,0.925,0.075,0.000,0.905,0.095,0.000,0.926,0.074,0.000,0.925,0.075,0.000,0.911,0.089,0.000,0.918,0.082,0.000,0.908,0.092,0.000,0.923,0.077,0.000,0.904,0.096,0.000,0.914,0.086,0.000,0.919,0.081,0.000,0.925,0.075,0.000,0.918,0.082,0.000,0.916,0.084,0.000,0.925,0.075,0.000,0.925,0.075,0.000,0.911,0.089,0.000,0.913,0.087,0.000,0.911,0.089,0.000,0.913,0.087,0.000,0.912,0.088,0.000,0.911,0.089,0.000,0.926,0.074,0.000,0.917,0.083,0.000,0.916,0.084};
			return value;
		}
		private double[] getColor_9_22_color_61()
		{
			double[] value = {0.000,0.932,0.068,0.000,0.932,0.068,0.000,0.930,0.070,0.000,0.910,0.090,0.000,0.927,0.073,0.000,0.939,0.061,0.000,0.917,0.083,0.000,0.932,0.068,0.000,0.931,0.069,0.000,0.939,0.061,0.000,0.943,0.057,0.000,0.943,0.057,0.000,0.922,0.078,0.000,0.923,0.077,0.000,0.914,0.086,0.000,0.917,0.083,0.000,0.918,0.082,0.000,0.914,0.086,0.000,0.922,0.078,0.000,0.912,0.088,0.000,0.912,0.088,0.000,0.929,0.071,0.000,0.926,0.074,0.000,0.921,0.079,0.000,0.918,0.082,0.000,0.909,0.091,0.000,0.923,0.077,0.000,0.929,0.071,0.000,0.930,0.070,0.000,0.934,0.066,0.000,0.932,0.068,0.000,0.940,0.060,0.000,0.917,0.083,0.000,0.951,0.049,0.000,0.928,0.072,0.000,0.917,0.083,0.000,0.948,0.052,0.000,0.915,0.085,0.000,0.914,0.086,0.000,0.917,0.083,0.000,0.917,0.083,0.000,0.915,0.085,0.000,0.919,0.081,0.000,0.916,0.084,0.000,0.921,0.079,0.000,0.922,0.078,0.000,0.922,0.078,0.000,0.923,0.077,0.000,0.912,0.088,0.000,0.914,0.086,0.000,0.912,0.088,0.000,0.906,0.094,0.000,0.920,0.080,0.000,0.913,0.087,0.000,0.911,0.089,0.000,0.919,0.081,0.000,0.907,0.093,0.000,0.913,0.087,0.000,0.907,0.093,0.000,0.907,0.093,0.000,0.920,0.080,0.000,0.910,0.090,0.000,0.901,0.099,0.000,0.928,0.072,0.000,0.924,0.076,0.000,0.909,0.091,0.000,0.921,0.079,0.000,0.906,0.094,0.000,0.927,0.073,0.000,0.924,0.076,0.000,0.931,0.069,0.000,0.922,0.078,0.000,0.903,0.097,0.000,0.931,0.069,0.000,0.923,0.077,0.000,0.923,0.077,0.000,0.926,0.074,0.000,0.933,0.067,0.000,0.902,0.098,0.000,0.930,0.070,0.000,0.927,0.073,0.000,0.928,0.072,0.000,0.917,0.083,0.000,0.924,0.076,0.000,0.907,0.093,0.000,0.920,0.080,0.000,0.904,0.096,0.000,0.893,0.107,0.000,0.940,0.060,0.000,0.925,0.075,0.000,0.931,0.069,0.000,0.937,0.063,0.000,0.916,0.084,0.000,0.943,0.057,0.000,0.946,0.054,0.000,0.936,0.064,0.000,0.936,0.064,0.000,0.935,0.065,0.000,0.928,0.072,0.000,0.915,0.085};
			return value;
		}
		private double[] getColor_9_22_color_62()
		{
			double[] value = {0.000,0.909,0.091,0.000,0.908,0.092,0.000,0.906,0.094,0.000,0.909,0.091,0.000,0.909,0.091,0.000,0.939,0.061,0.000,0.942,0.058,0.000,0.945,0.055,0.000,0.904,0.096,0.000,0.909,0.091,0.000,0.904,0.096,0.000,0.901,0.099,0.000,0.902,0.098,0.000,0.897,0.103,0.000,0.887,0.113,0.000,0.902,0.098,0.000,0.918,0.082,0.000,0.888,0.112,0.000,0.922,0.078,0.000,0.889,0.111,0.000,0.888,0.112,0.000,0.902,0.098,0.000,0.902,0.098,0.000,0.905,0.095,0.000,0.909,0.091,0.000,0.884,0.116,0.000,0.912,0.088,0.000,0.906,0.094,0.000,0.898,0.102,0.000,0.913,0.087,0.000,0.920,0.080,0.000,0.924,0.076,0.000,0.895,0.105,0.000,0.911,0.089,0.000,0.913,0.087,0.000,0.893,0.107,0.000,0.912,0.088,0.000,0.892,0.108,0.000,0.902,0.098,0.000,0.923,0.077,0.000,0.883,0.117,0.000,0.913,0.087,0.000,0.903,0.097,0.000,0.905,0.095,0.000,0.889,0.111,0.000,0.907,0.093,0.000,0.900,0.100,0.000,0.898,0.102,0.000,0.930,0.070,0.000,0.883,0.117,0.000,0.925,0.075,0.000,0.892,0.108,0.000,0.891,0.109,0.000,0.889,0.111,0.000,0.882,0.118,0.000,0.898,0.102,0.000,0.890,0.110,0.000,0.897,0.103,0.000,0.905,0.095,0.000,0.910,0.090,0.000,0.922,0.078,0.000,0.879,0.121,0.000,0.883,0.117,0.000,0.916,0.084,0.000,0.909,0.091,0.000,0.903,0.097,0.000,0.904,0.096,0.000,0.933,0.067,0.000,0.884,0.116,0.000,0.886,0.114,0.000,0.914,0.086,0.000,0.908,0.092,0.000,0.891,0.109,0.000,0.920,0.080,0.000,0.879,0.121,0.000,0.918,0.082,0.000,0.927,0.073,0.000,0.931,0.069,0.000,0.933,0.067,0.000,0.905,0.095,0.000,0.927,0.073,0.000,0.926,0.074,0.000,0.828,0.172,0.000,0.834,0.166,0.000,0.843,0.157,0.000,0.844,0.156,0.000,0.845,0.155,0.000,0.839,0.161,0.000,0.859,0.141,0.000,0.856,0.144,0.000,0.879,0.121,0.000,0.879,0.121,0.000,0.880,0.120,0.000,0.849,0.151,0.000,0.893,0.107,0.000,0.874,0.126,0.000,0.873,0.127,0.000,0.862,0.138,0.000,0.875,0.125,0.000,0.876,0.124};
			return value;
		}
		private double[] getColor_9_22_color_63()
		{
			double[] value = {0.000,0.859,0.141,0.000,0.900,0.100,0.000,0.858,0.142,0.000,0.878,0.122,0.000,0.870,0.130,0.000,0.893,0.107,0.000,0.916,0.084,0.000,0.868,0.132,0.000,0.906,0.094,0.000,0.871,0.129,0.000,0.862,0.138,0.000,0.863,0.137,0.000,0.869,0.131,0.000,0.884,0.116,0.000,0.891,0.109,0.000,0.886,0.114,0.000,0.877,0.123,0.000,0.899,0.101,0.000,0.910,0.090,0.000,0.880,0.120,0.000,0.885,0.115,0.000,0.909,0.091,0.000,0.892,0.108,0.000,0.892,0.108,0.000,0.894,0.106,0.000,0.793,0.207,0.000,0.792,0.208,0.000,0.796,0.204,0.000,0.799,0.201,0.000,0.798,0.202,0.000,0.804,0.196,0.000,0.805,0.195,0.000,0.811,0.189,0.000,0.815,0.185,0.000,0.815,0.185,0.000,0.818,0.182,0.000,0.322,0.678,0.000,0.319,0.681,0.000,0.310,0.690,0.000,0.302,0.698,0.000,0.291,0.709,0.000,0.290,0.710,0.000,0.290,0.710,0.000,0.289,0.711,0.000,0.286,0.714,0.000,0.282,0.718,0.000,0.276,0.724,0.000,0.271,0.729,0.000,0.269,0.731,0.000,0.268,0.732,0.000,0.075,0.925,0.000,0.049,0.951,0.000,0.057,0.943,0.000,0.056,0.944,0.000,0.057,0.943,0.000,0.048,0.952,0.000,0.083,0.917,0.000,0.052,0.948,0.000,0.048,0.952,0.000,0.048,0.952,0.000,0.076,0.924,0.000,0.092,0.908,0.000,0.089,0.911,0.000,0.086,0.914,0.000,0.049,0.951,0.000,0.083,0.917,0.000,0.055,0.945,0.000,0.082,0.918,0.000,0.064,0.936,0.000,0.054,0.946,0.000,0.061,0.939,0.000,0.054,0.946,0.000,0.069,0.931,0.000,0.059,0.941,0.000,0.183,0.817,0.000,0.166,0.834,0.000,0.135,0.865,0.000,0.198,0.802,0.000,0.214,0.786,0.000,0.199,0.801,0.000,0.319,0.681,0.000,0.289,0.711,0.000,0.406,0.594,0.000,0.388,0.612,0.000,0.389,0.611,0.000,0.422,0.578,0.000,0.434,0.566,0.000,0.449,0.551,0.000,0.441,0.559,0.000,0.456,0.544,0.000,0.452,0.548,0.000,0.458,0.542,0.000,0.463,0.537,0.000,0.531,0.469,0.000,0.465,0.535,0.000,0.513,0.487,0.000,0.533,0.467,0.000,0.522,0.478,0.000,0.526,0.474,0.000,0.514,0.486};
			return value;
		}
		private double[] getColor_9_22_color_64()
		{
			double[] value = {0.000,0.502,0.498,0.000,0.519,0.481,0.000,0.518,0.482,0.000,0.488,0.512,0.000,0.484,0.516,0.000,0.526,0.474,0.000,0.517,0.483,0.000,0.525,0.475,0.000,0.519,0.481,0.000,0.502,0.498,0.000,0.513,0.487,0.000,0.526,0.474,0.000,0.513,0.487,0.000,0.523,0.477,0.000,0.501,0.499,0.000,0.485,0.515,0.000,0.544,0.456,0.000,0.527,0.473,0.000,0.499,0.501,0.000,0.471,0.529,0.000,0.582,0.418,0.000,0.587,0.413,0.000,0.592,0.408,0.000,0.592,0.408,0.000,0.592,0.408,0.000,0.592,0.408,0.000,0.584,0.416,0.000,0.590,0.410,0.000,0.589,0.411,0.000,0.581,0.419,0.000,0.588,0.412,0.000,0.591,0.409,0.000,0.591,0.409,0.000,0.571,0.429,0.000,0.584,0.416,0.000,0.547,0.453,0.000,0.591,0.409,0.000,0.592,0.408,0.000,0.585,0.415,0.000,0.580,0.420,0.000,0.586,0.414,0.000,0.575,0.425,0.000,0.574,0.426,0.000,0.569,0.431,0.000,0.558,0.442,0.000,0.904,0.096,0.000,0.918,0.082,0.000,0.916,0.084,0.000,0.933,0.067,0.000,0.946,0.054,0.000,0.941,0.059,0.000,0.931,0.069,0.000,0.921,0.079,0.000,0.929,0.071,0.000,0.930,0.070,0.000,0.935,0.065,0.000,0.934,0.066,0.000,0.942,0.058,0.000,0.945,0.055,0.000,0.965,0.035,0.000,0.967,0.033,0.000,0.967,0.033,0.000,0.958,0.042,0.000,0.964,0.036,0.000,0.958,0.042,0.000,0.960,0.040,0.000,0.959,0.041,0.000,0.958,0.042,0.000,0.960,0.040,0.000,0.960,0.040,0.000,0.969,0.031,0.000,0.972,0.028,0.000,0.955,0.045,0.000,0.971,0.029,0.000,0.962,0.038,0.000,0.970,0.030,0.000,0.971,0.029,0.000,0.969,0.031,0.000,0.955,0.045,0.000,0.969,0.031,0.000,0.955,0.045,0.000,0.966,0.034,0.000,0.958,0.042,0.000,0.964,0.036,0.000,0.968,0.032,0.000,0.965,0.035,0.000,0.965,0.035,0.000,0.939,0.061,0.000,0.941,0.059,0.000,0.944,0.056,0.000,0.944,0.056,0.000,0.948,0.052,0.000,0.950,0.050,0.000,0.956,0.044,0.000,0.946,0.054,0.000,0.959,0.041,0.000,0.950,0.050,0.000,0.963,0.037,0.000,0.952,0.048,0.000,0.964,0.036};
			return value;
		}
		private double[] getColor_9_22_color_65()
		{
			double[] value = {0.000,0.967,0.033,0.000,0.962,0.038,0.000,0.957,0.043,0.000,0.964,0.036,0.000,0.970,0.030,0.000,0.966,0.034,0.000,0.965,0.035,0.000,0.960,0.040,0.000,0.960,0.040,0.000,0.970,0.030,0.000,0.952,0.048,0.000,0.966,0.034,0.000,0.968,0.032,0.000,0.972,0.028,0.000,0.970,0.030,0.000,0.970,0.030,0.000,0.972,0.028,0.000,0.965,0.035,0.000,0.972,0.028,0.000,0.970,0.030,0.000,0.956,0.044,0.000,0.958,0.042,0.000,0.972,0.028,0.000,0.965,0.035,0.000,0.961,0.039,0.000,0.961,0.039,0.000,0.959,0.041,0.000,0.892,0.108,0.000,0.931,0.069,0.000,0.936,0.064,0.000,0.935,0.065,0.000,0.921,0.079,0.000,0.935,0.065,0.000,0.934,0.066,0.000,0.944,0.056,0.000,0.935,0.065,0.000,0.957,0.043,0.000,0.952,0.048,0.000,0.953,0.047,0.000,0.941,0.059,0.000,0.943,0.057,0.000,0.958,0.042,0.000,0.932,0.068,0.000,0.937,0.063,0.000,0.951,0.049,0.000,0.936,0.064,0.000,0.944,0.056,0.000,0.933,0.067,0.000,0.934,0.066,0.000,0.934,0.066,0.000,0.843,0.157,0.000,0.881,0.119,0.000,0.880,0.120,0.000,0.850,0.150,0.000,0.847,0.153,0.000,0.847,0.153,0.000,0.846,0.154,0.000,0.849,0.151,0.000,0.884,0.116,0.000,0.849,0.151,0.000,0.862,0.138,0.000,0.894,0.106,0.000,0.861,0.139,0.000,0.866,0.134,0.000,0.865,0.135,0.000,0.849,0.151,0.000,0.884,0.116,0.000,0.899,0.101,0.000,0.915,0.085,0.000,0.810,0.190,0.000,0.835,0.165,0.000,0.836,0.164,0.000,0.811,0.189,0.000,0.824,0.176,0.000,0.837,0.163,0.000,0.816,0.184,0.000,0.829,0.171,0.000,0.833,0.167,0.000,0.819,0.181,0.000,0.821,0.179,0.000,0.820,0.180,0.000,0.833,0.167,0.000,0.326,0.674,0.000,0.341,0.659,0.000,0.325,0.675,0.000,0.315,0.685,0.000,0.304,0.696,0.000,0.292,0.708,0.000,0.296,0.704,0.000,0.307,0.693,0.000,0.290,0.710,0.000,0.284,0.716,0.000,0.274,0.726,0.000,0.271,0.729,0.000,0.271,0.729,0.000,0.273,0.727,0.000,0.286,0.714,0.000,0.072,0.928,0.000,0.072,0.928,0.000,0.074,0.926};
			return value;
		}
		private double[] getColor_9_22_color_66()
		{
			double[] value = {0.000,0.078,0.922,0.000,0.072,0.928,0.000,0.083,0.917,0.000,0.074,0.926,0.000,0.510,0.490,0.000,0.520,0.480,0.000,0.514,0.486,0.000,0.549,0.451,0.000,0.850,0.150,0.000,0.848,0.152,0.000,0.425,0.575,0.000,0.386,0.614,0.000,0.393,0.607,0.000,0.361,0.639,0.000,0.367,0.633,0.000,0.359,0.641,0.000,0.369,0.631,0.000,0.364,0.636,0.000,0.367,0.633,0.000,0.357,0.643,0.000,0.365,0.635,0.000,0.358,0.642,0.000,0.320,0.680,0.000,0.332,0.668,0.000,0.319,0.681,0.000,0.288,0.712,0.000,0.076,0.924,0.000,0.084,0.916,0.000,0.084,0.916,0.000,0.083,0.917,0.000,0.091,0.909,0.000,0.089,0.911,0.000,0.874,0.126,0.000,0.875,0.125,0.000,0.832,0.168,0.000,0.869,0.131,0.000,0.862,0.138,0.000,0.862,0.138,0.000,0.844,0.156,0.000,0.839,0.161,0.000,0.839,0.161,0.000,0.849,0.151,0.000,0.820,0.180,0.000,0.868,0.132,0.000,0.832,0.168,0.000,0.851,0.149,0.000,0.839,0.161,0.000,0.842,0.158,0.000,0.852,0.148,0.000,0.853,0.147,0.000,0.867,0.133,0.000,0.859,0.141,0.000,0.831,0.169,0.000,0.870,0.130,0.000,0.828,0.172,0.000,0.870,0.130,0.000,0.856,0.144,0.000,0.834,0.166,0.000,0.845,0.155,0.000,0.864,0.136,0.000,0.845,0.155,0.000,0.857,0.143,0.000,0.837,0.163,0.000,0.853,0.147,0.000,0.857,0.143,0.000,0.838,0.162,0.000,0.853,0.147,0.000,0.448,0.552,0.000,0.451,0.549,0.000,0.476,0.524,0.000,0.482,0.518,0.000,0.471,0.529,0.000,0.466,0.534,0.000,0.458,0.542,0.000,0.471,0.529,0.000,0.464,0.536,0.000,0.451,0.549,0.000,0.467,0.533,0.000,0.466,0.534,0.000,0.469,0.531,0.000,0.462,0.538,0.000,0.467,0.533,0.000,0.462,0.538,0.000,0.433,0.567,0.000,0.448,0.552,0.000,0.413,0.587,0.000,0.409,0.591,0.000,0.397,0.603,0.000,0.447,0.553,0.000,0.394,0.606,0.000,0.383,0.617,0.000,0.442,0.558,0.000,0.424,0.576,0.000,0.388,0.612,0.000,0.395,0.605,0.000,0.441,0.559,0.000,0.408,0.592,0.000,0.410,0.590,0.000,0.435,0.565,0.000,0.420,0.580};
			return value;
		}
		private double[] getColor_9_22_color_67()
		{
			double[] value = {0.000,0.415,0.585,0.000,0.376,0.624,0.000,0.359,0.641,0.000,0.365,0.635,0.000,0.373,0.627,0.000,0.354,0.646,0.000,0.363,0.637,0.000,0.368,0.632,0.000,0.378,0.622,0.000,0.378,0.622,0.000,0.368,0.632,0.000,0.374,0.626,0.000,0.369,0.631,0.000,0.368,0.632,0.000,0.379,0.621,0.000,0.081,0.919,0.000,0.088,0.912,0.000,0.089,0.911,0.000,0.089,0.911,0.000,0.095,0.905,0.000,0.091,0.909,0.000,0.875,0.125,0.000,0.875,0.125,0.000,0.876,0.124,0.000,0.877,0.123,0.000,0.870,0.130,0.000,0.878,0.122,0.000,0.876,0.124,0.000,0.877,0.123,0.000,0.875,0.125,0.000,0.876,0.124,0.000,0.877,0.123,0.000,0.877,0.123,0.000,0.879,0.121,0.000,0.806,0.194,0.000,0.805,0.195,0.000,0.823,0.177,0.000,0.819,0.181,0.000,0.834,0.166,0.000,0.832,0.168,0.000,0.846,0.154,0.000,0.846,0.154,0.000,0.869,0.131,0.000,0.846,0.154,0.000,0.870,0.130,0.000,0.871,0.129,0.000,0.826,0.174,0.000,0.850,0.150,0.000,0.840,0.160,0.000,0.829,0.171,0.000,0.845,0.155,0.000,0.860,0.140,0.000,0.817,0.183,0.000,0.845,0.155,0.000,0.851,0.149,0.000,0.863,0.137,0.000,0.826,0.174,0.000,0.845,0.155,0.000,0.857,0.143,0.000,0.860,0.140,0.000,0.831,0.169,0.000,0.847,0.153,0.000,0.829,0.171,0.000,0.849,0.151,0.000,0.852,0.148,0.000,0.864,0.136,0.000,0.817,0.183,0.000,0.822,0.178,0.000,0.830,0.170,0.000,0.829,0.171,0.000,0.818,0.182,0.000,0.854,0.146,0.000,0.816,0.184,0.000,0.775,0.225,0.000,0.725,0.275,0.000,0.774,0.226,0.000,0.775,0.225,0.000,0.746,0.254,0.000,0.798,0.202,0.000,0.792,0.208,0.000,0.775,0.225,0.000,0.784,0.216,0.000,0.744,0.256,0.000,0.748,0.252,0.000,0.789,0.211,0.000,0.741,0.259,0.000,0.731,0.269,0.000,0.730,0.270,0.000,0.807,0.193,0.000,0.801,0.199,0.000,0.782,0.218,0.000,0.752,0.248,0.000,0.744,0.256,0.000,0.804,0.196,0.000,0.750,0.250,0.000,0.797,0.203,0.000,0.797,0.203,0.000,0.753,0.247,0.000,0.756,0.244,0.000,0.734,0.266};
			return value;
		}
		private double[] getColor_9_22_color_68()
		{
			double[] value = {0.000,0.738,0.262,0.000,0.756,0.244,0.000,0.759,0.241,0.000,0.796,0.204,0.000,0.740,0.260,0.000,0.736,0.264,0.000,0.744,0.256,0.000,0.801,0.199,0.000,0.798,0.202,0.000,0.737,0.263,0.000,0.740,0.260,0.000,0.766,0.234,0.000,0.773,0.227,0.000,0.792,0.208,0.000,0.764,0.236,0.000,0.799,0.201,0.000,0.786,0.214,0.000,0.770,0.230,0.000,0.798,0.202,0.000,0.787,0.213,0.000,0.781,0.219,0.000,0.781,0.219,0.000,0.806,0.194,0.000,0.791,0.209,0.000,0.698,0.302,0.000,0.674,0.326,0.000,0.700,0.300,0.000,0.671,0.329,0.000,0.690,0.310,0.000,0.684,0.316,0.000,0.715,0.285,0.000,0.709,0.291,0.000,0.701,0.299,0.000,0.702,0.298,0.000,0.671,0.329,0.000,0.703,0.297,0.000,0.719,0.281,0.000,0.699,0.301,0.000,0.690,0.310,0.000,0.664,0.336,0.000,0.687,0.313,0.000,0.701,0.299,0.000,0.724,0.276,0.000,0.697,0.303,0.000,0.712,0.288,0.000,0.713,0.287,0.000,0.705,0.295,0.000,0.712,0.288,0.000,0.719,0.281,0.000,0.696,0.304,0.000,0.698,0.302,0.000,0.697,0.303,0.000,0.717,0.283,0.000,0.692,0.308,0.000,0.692,0.308,0.000,0.700,0.300,0.000,0.707,0.293,0.000,0.689,0.311,0.000,0.710,0.290,0.000,0.707,0.293,0.000,0.701,0.299,0.000,0.698,0.302,0.000,0.708,0.292,0.000,0.685,0.315,0.000,0.681,0.319,0.000,0.678,0.322,0.000,0.673,0.327,0.000,0.583,0.417,0.000,0.590,0.410,0.000,0.664,0.336,0.000,0.643,0.357,0.000,0.628,0.372,0.000,0.662,0.338,0.000,0.607,0.393,0.000,0.595,0.405,0.000,0.604,0.396,0.000,0.615,0.385,0.000,0.617,0.383,0.000,0.641,0.359,0.000,0.592,0.408,0.000,0.631,0.369,0.000,0.588,0.412,0.000,0.603,0.397,0.000,0.656,0.344,0.000,0.634,0.366,0.000,0.600,0.400,0.000,0.617,0.383,0.000,0.629,0.371,0.000,0.604,0.396,0.000,0.657,0.343,0.000,0.626,0.374,0.000,0.662,0.338,0.000,0.632,0.368,0.000,0.636,0.364,0.000,0.642,0.358,0.000,0.635,0.365,0.000,0.667,0.333,0.000,0.559,0.441,0.000,0.515,0.485,0.000,0.574,0.426};
			return value;
		}
		private double[] getColor_9_22_color_69()
		{
			double[] value = {0.000,0.529,0.471,0.000,0.574,0.426,0.000,0.541,0.459,0.000,0.544,0.456,0.000,0.549,0.451,0.000,0.546,0.454,0.000,0.568,0.432,0.000,0.541,0.459,0.000,0.545,0.455,0.000,0.555,0.445,0.000,0.537,0.463,0.000,0.534,0.466,0.000,0.518,0.482,0.000,0.528,0.472,0.000,0.544,0.456,0.000,0.535,0.465,0.000,0.527,0.473,0.000,0.532,0.468,0.000,0.578,0.422,0.000,0.528,0.472,0.000,0.520,0.480,0.000,0.521,0.479,0.000,0.513,0.487,0.000,0.516,0.484,0.000,0.491,0.509,0.000,0.488,0.512,0.000,0.507,0.493,0.000,0.492,0.508,0.000,0.506,0.494,0.000,0.491,0.509,0.000,0.481,0.519,0.000,0.511,0.489,0.000,0.503,0.497,0.000,0.510,0.490,0.000,0.484,0.516,0.000,0.491,0.509,0.000,0.495,0.505,0.000,0.484,0.516,0.000,0.497,0.503,0.000,0.492,0.508,0.000,0.484,0.516,0.000,0.484,0.516,0.000,0.480,0.520,0.000,0.469,0.531,0.000,0.479,0.521,0.000,0.482,0.518,0.000,0.507,0.493,0.000,0.498,0.502,0.000,0.498,0.502,0.000,0.511,0.489,0.000,0.510,0.490,0.000,0.496,0.504,0.000,0.487,0.513,0.000,0.498,0.502,0.000,0.492,0.508,0.000,0.471,0.529,0.000,0.480,0.520,0.000,0.483,0.517,0.000,0.503,0.497,0.000,0.480,0.520,0.000,0.477,0.523,0.000,0.476,0.524,0.000,0.485,0.515,0.000,0.500,0.500,0.000,0.469,0.531,0.000,0.502,0.498,0.000,0.509,0.491,0.000,0.505,0.495,0.000,0.509,0.491,0.000,0.502,0.498,0.000,0.461,0.539,0.000,0.508,0.492,0.000,0.465,0.535,0.000,0.502,0.498,0.000,0.487,0.513,0.000,0.478,0.522,0.000,0.508,0.492,0.000,0.077,0.923,0.000,0.080,0.920,0.000,0.082,0.918,0.000,0.083,0.917,0.000,0.079,0.921,0.000,0.079,0.921,0.000,0.079,0.921,0.000,0.084,0.916,0.000,0.086,0.914,0.000,0.086,0.914,0.000,0.089,0.911,0.000,0.090,0.910,0.000,0.092,0.908,0.000,0.091,0.909,0.000,0.090,0.910,0.000,0.468,0.532,0.000,0.445,0.555,0.000,0.453,0.547,0.000,0.487,0.513,0.000,0.548,0.452,0.000,0.512,0.488,0.000,0.510,0.490,0.000,0.508,0.492};
			return value;
		}
		private double[] getColor_9_22_color_70()
		{
			double[] value = {0.000,0.488,0.512,0.000,0.548,0.452,0.000,0.531,0.469,0.000,0.512,0.488,0.000,0.515,0.485,0.000,0.504,0.496,0.000,0.512,0.488,0.000,0.503,0.497,0.000,0.553,0.447,0.000,0.510,0.490,0.000,0.526,0.474,0.000,0.501,0.499,0.000,0.524,0.476,0.000,0.525,0.475,0.000,0.527,0.473,0.000,0.576,0.424,0.000,0.557,0.443,0.000,0.555,0.445,0.000,0.572,0.428,0.000,0.574,0.426,0.000,0.576,0.424,0.000,0.575,0.425,0.000,0.568,0.432,0.000,0.575,0.425,0.000,0.574,0.426,0.000,0.570,0.430,0.000,0.575,0.425,0.000,0.569,0.431,0.000,0.575,0.425,0.000,0.566,0.434,0.000,0.557,0.443,0.000,0.570,0.430,0.000,0.563,0.437,0.000,0.568,0.432,0.000,0.559,0.441,0.000,0.560,0.440,0.000,0.558,0.442,0.000,0.812,0.188,0.000,0.807,0.193,0.000,0.809,0.191,0.000,0.816,0.184,0.000,0.814,0.186,0.000,0.818,0.182,0.000,0.808,0.192,0.000,0.816,0.184,0.000,0.818,0.182,0.000,0.818,0.182,0.000,0.819,0.181,0.000,0.817,0.183,0.000,0.825,0.175,0.000,0.825,0.175,0.000,0.817,0.183,0.000,0.813,0.187,0.000,0.813,0.187,0.000,0.828,0.172,0.000,0.817,0.183,0.000,0.818,0.182,0.000,0.827,0.173,0.000,0.852,0.148,0.000,0.820,0.180,0.000,0.848,0.152,0.000,0.856,0.144,0.000,0.824,0.176,0.000,0.821,0.179,0.000,0.824,0.176,0.000,0.855,0.145,0.000,0.822,0.178,0.000,0.863,0.137,0.000,0.830,0.170,0.000,0.861,0.139,0.000,0.862,0.138,0.000,0.857,0.143,0.000,0.870,0.130,0.000,0.825,0.175,0.000,0.831,0.169,0.000,0.870,0.130,0.000,0.862,0.138,0.000,0.838,0.162,0.000,0.834,0.166,0.000,0.857,0.143,0.000,0.867,0.133,0.000,0.858,0.142,0.000,0.828,0.172,0.000,0.827,0.173,0.000,0.866,0.134,0.000,0.874,0.126,0.000,0.878,0.122,0.000,0.741,0.259,0.000,0.742,0.258,0.000,0.750,0.250,0.000,0.757,0.243,0.000,0.749,0.251,0.000,0.742,0.258,0.000,0.758,0.242,0.000,0.746,0.254,0.000,0.775,0.225,0.000,0.700,0.300,0.000,0.700,0.300,0.000,0.697,0.303,0.000,0.719,0.281};
			return value;
		}
		private double[] getColor_9_22_color_71()
		{
			double[] value = {0.000,0.730,0.270,0.000,0.730,0.270,0.000,0.697,0.303,0.000,0.694,0.306,0.000,0.679,0.321,0.000,0.678,0.322,0.000,0.727,0.273,0.000,0.682,0.318,0.000,0.712,0.288,0.000,0.735,0.265,0.000,0.728,0.272,0.000,0.726,0.274,0.000,0.737,0.263,0.000,0.720,0.280,0.000,0.711,0.289,0.000,0.703,0.297,0.000,0.728,0.272,0.000,0.594,0.406,0.000,0.593,0.407,0.000,0.597,0.403,0.000,0.585,0.415,0.000,0.630,0.370,0.000,0.603,0.397,0.000,0.621,0.379,0.000,0.616,0.384,0.000,0.643,0.357,0.000,0.627,0.373,0.000,0.642,0.358,0.000,0.668,0.332,0.000,0.563,0.437,0.000,0.537,0.463,0.000,0.530,0.470,0.000,0.571,0.429,0.000,0.547,0.453,0.000,0.549,0.451,0.000,0.540,0.460,0.000,0.519,0.481,0.000,0.527,0.473,0.000,0.530,0.470,0.000,0.561,0.439,0.000,0.522,0.478,0.000,0.576,0.424,0.000,0.560,0.440,0.000,0.524,0.476,0.000,0.547,0.453,0.000,0.558,0.442,0.000,0.543,0.457,0.000,0.576,0.424,0.000,0.575,0.425,0.000,0.534,0.466,0.000,0.520,0.480,0.000,0.577,0.423,0.000,0.573,0.427,0.000,0.542,0.458,0.000,0.552,0.448,0.000,0.516,0.484,0.000,0.515,0.485,0.000,0.063,0.937,0.000,0.073,0.927,0.000,0.070,0.930,0.000,0.078,0.922,0.000,0.084,0.916,0.000,0.084,0.916,0.000,0.240,0.760,0.000,0.255,0.745,0.000,0.281,0.719,0.000,0.341,0.659,0.000,0.343,0.657,0.000,0.291,0.709,0.000,0.329,0.671,0.000,0.347,0.653,0.000,0.330,0.670,0.000,0.358,0.642,0.000,0.358,0.642,0.000,0.360,0.640,0.000,0.371,0.629,0.000,0.358,0.642,0.000,0.455,0.545,0.000,0.420,0.580,0.000,0.395,0.605,0.000,0.387,0.613,0.000,0.431,0.569,0.000,0.444,0.556,0.000,0.419,0.581,0.000,0.484,0.516,0.000,0.514,0.486,0.000,0.519,0.481,0.000,0.526,0.474,0.000,0.577,0.423,0.000,0.577,0.423,0.000,0.578,0.422,0.000,0.579,0.421,0.000,0.577,0.423,0.000,0.577,0.423,0.000,0.578,0.422,0.000,0.576,0.424,0.000,0.574,0.426,0.000,0.577,0.423,0.000,0.579,0.421,0.000,0.575,0.425};
			return value;
		}
		private double[] getColor_9_22_color_72()
		{
			double[] value = {0.000,0.577,0.423,0.000,0.575,0.425,0.000,0.576,0.424,0.000,0.558,0.442,0.000,0.577,0.423,0.000,0.574,0.426,0.000,0.570,0.430,0.000,0.570,0.430,0.000,0.572,0.428,0.000,0.575,0.425,0.000,0.574,0.426,0.000,0.573,0.427,0.000,0.576,0.424,0.000,0.573,0.427,0.000,0.577,0.423,0.000,0.577,0.423,0.000,0.577,0.423,0.000,0.719,0.281,0.000,0.763,0.237,0.000,0.727,0.273,0.000,0.739,0.261,0.000,0.716,0.284,0.000,0.740,0.260,0.000,0.732,0.268,0.000,0.729,0.271,0.000,0.765,0.235,0.000,0.731,0.269,0.000,0.725,0.275,0.000,0.733,0.267,0.000,0.757,0.243,0.000,0.757,0.243,0.000,0.737,0.263,0.000,0.733,0.267,0.000,0.765,0.235,0.000,0.741,0.259,0.000,0.766,0.234,0.000,0.762,0.238,0.000,0.767,0.233,0.000,0.746,0.254,0.000,0.767,0.233,0.000,0.759,0.241,0.000,0.751,0.249,0.000,0.768,0.232,0.000,0.755,0.245,0.000,0.755,0.245,0.000,0.768,0.232,0.000,0.763,0.237,0.000,0.772,0.228,0.000,0.768,0.232,0.000,0.791,0.209,0.000,0.796,0.204,0.000,0.766,0.234,0.000,0.803,0.197,0.000,0.786,0.214,0.000,0.772,0.228,0.000,0.769,0.231,0.000,0.781,0.219,0.000,0.797,0.203,0.000,0.788,0.212,0.000,0.789,0.211,0.000,0.770,0.230,0.000,0.780,0.220,0.000,0.770,0.230,0.000,0.784,0.216,0.000,0.788,0.212,0.000,0.774,0.226,0.000,0.806,0.194,0.000,0.795,0.205,0.000,0.817,0.183,0.000,0.780,0.220,0.000,0.821,0.179,0.000,0.050,0.950,0.000,0.051,0.949,0.000,0.053,0.947,0.000,0.054,0.946,0.000,0.050,0.950,0.000,0.054,0.946,0.000,0.084,0.916,0.000,0.052,0.948,0.000,0.085,0.915,0.000,0.050,0.950,0.000,0.079,0.921,0.000,0.059,0.941,0.000,0.050,0.950,0.000,0.052,0.948,0.000,0.137,0.863,0.000,0.098,0.902,0.000,0.140,0.860,0.000,0.090,0.910,0.000,0.128,0.872,0.000,0.103,0.897,0.000,0.173,0.827,0.000,0.191,0.809,0.000,0.251,0.749,0.000,0.233,0.767,0.000,0.203,0.797,0.000,0.261,0.739,0.000,0.222,0.778,0.000,0.271,0.729,0.000,0.294,0.706};
			return value;
		}
		private double[] getColor_9_22_color_73()
		{
			double[] value = {0.000,0.299,0.701,0.000,0.319,0.681,0.000,0.329,0.671,0.000,0.323,0.677,0.000,0.315,0.685,0.000,0.284,0.716,0.000,0.287,0.713,0.000,0.318,0.682,0.000,0.302,0.698,0.000,0.283,0.717,0.000,0.339,0.661,0.000,0.295,0.705,0.000,0.289,0.711,0.000,0.304,0.696,0.000,0.352,0.648,0.000,0.359,0.641,0.000,0.560,0.440,0.000,0.560,0.440,0.000,0.560,0.440,0.000,0.559,0.441,0.000,0.560,0.440,0.000,0.565,0.435,0.000,0.560,0.440,0.000,0.570,0.430,0.000,0.571,0.429,0.000,0.558,0.442,0.000,0.562,0.438,0.000,0.562,0.438,0.000,0.572,0.428,0.000,0.560,0.440,0.000,0.564,0.436,0.000,0.568,0.432,0.000,0.570,0.430,0.000,0.566,0.434,0.000,0.556,0.444,0.000,0.563,0.437,0.000,0.582,0.418,0.000,0.582,0.418,0.000,0.591,0.409,0.000,0.582,0.418,0.000,0.598,0.402,0.000,0.570,0.430,0.000,0.563,0.437,0.000,0.594,0.406,0.000,0.598,0.402,0.000,0.555,0.445,0.000,0.553,0.447,0.000,0.580,0.420,0.000,0.651,0.349,0.000,0.631,0.369,0.000,0.658,0.342,0.000,0.663,0.337,0.000,0.660,0.340,0.000,0.664,0.336,0.000,0.630,0.370,0.000,0.665,0.335,0.000,0.622,0.378,0.000,0.669,0.331,0.000,0.639,0.361,0.000,0.616,0.384,0.000,0.615,0.385,0.000,0.656,0.344,0.000,0.606,0.394,0.000,0.673,0.327,0.000,0.639,0.361,0.000,0.670,0.330,0.000,0.649,0.351,0.000,0.626,0.374,0.000,0.663,0.337,0.000,0.662,0.338,0.000,0.604,0.396,0.000,0.640,0.360,0.000,0.650,0.350,0.000,0.644,0.356,0.000,0.649,0.351,0.000,0.656,0.344,0.000,0.654,0.346,0.000,0.697,0.303,0.000,0.697,0.303,0.000,0.666,0.334,0.000,0.700,0.300,0.000,0.688,0.312,0.000,0.674,0.326,0.000,0.676,0.324,0.000,0.693,0.307,0.000,0.691,0.309,0.000,0.675,0.325,0.000,0.682,0.318,0.000,0.669,0.331,0.000,0.679,0.321,0.000,0.680,0.320,0.000,0.687,0.313,0.000,0.685,0.315,0.000,0.675,0.325,0.000,0.684,0.316,0.000,0.668,0.332,0.000,0.669,0.331,0.000,0.689,0.311,0.000,0.690,0.310,0.000,0.683,0.317};
			return value;
		}
		private double[] getColor_9_22_color_74()
		{
			double[] value = {0.000,0.704,0.296,0.000,0.706,0.294,0.000,0.714,0.286,0.000,0.716,0.284,0.000,0.709,0.291,0.000,0.717,0.283,0.000,0.720,0.280,0.000,0.702,0.298,0.000,0.726,0.274,0.000,0.712,0.288,0.000,0.713,0.287,0.000,0.739,0.261,0.000,0.699,0.301,0.000,0.706,0.294,0.000,0.057,0.943,0.000,0.050,0.950,0.000,0.551,0.449,0.000,0.554,0.446,0.000,0.552,0.448,0.000,0.550,0.450,0.000,0.550,0.450,0.000,0.590,0.410,0.000,0.594,0.406,0.000,0.549,0.451,0.000,0.548,0.452,0.000,0.548,0.452,0.000,0.562,0.438,0.000,0.545,0.455,0.000,0.546,0.454,0.000,0.608,0.392,0.000,0.595,0.405,0.000,0.593,0.407,0.000,0.548,0.452,0.000,0.549,0.451,0.000,0.565,0.435,0.000,0.550,0.450,0.000,0.552,0.448,0.000,0.553,0.447,0.000,0.551,0.449,0.000,0.552,0.448,0.000,0.564,0.436,0.000,0.553,0.447,0.000,0.559,0.441,0.000,0.561,0.439,0.000,0.557,0.443,0.000,0.577,0.423,0.000,0.597,0.403,0.000,0.559,0.441,0.000,0.600,0.400,0.000,0.649,0.351,0.000,0.596,0.404,0.000,0.618,0.382,0.000,0.607,0.393,0.000,0.670,0.330,0.000,0.649,0.351,0.000,0.656,0.344,0.000,0.652,0.348,0.000,0.620,0.380,0.000,0.634,0.366,0.000,0.662,0.338,0.000,0.681,0.319,0.000,0.712,0.288,0.000,0.626,0.374,0.000,0.651,0.349,0.000,0.640,0.360,0.000,0.624,0.376,0.000,0.651,0.349,0.000,0.664,0.336,0.000,0.632,0.368,0.000,0.641,0.359,0.000,0.621,0.379,0.000,0.636,0.364,0.000,0.647,0.353,0.000,0.625,0.375,0.000,0.643,0.357,0.000,0.616,0.384,0.000,0.626,0.374,0.000,0.657,0.343,0.000,0.616,0.384,0.000,0.551,0.449,0.000,0.556,0.444,0.000,0.550,0.450,0.000,0.560,0.440,0.000,0.552,0.448,0.000,0.529,0.471,0.000,0.543,0.457,0.000,0.571,0.429,0.000,0.554,0.446,0.000,0.575,0.425,0.000,0.556,0.444,0.000,0.579,0.421,0.000,0.528,0.472,0.000,0.585,0.415,0.000,0.532,0.468,0.000,0.590,0.410,0.000,0.588,0.412,0.000,0.569,0.431,0.000,0.599,0.401,0.000,0.602,0.398,0.000,0.562,0.438};
			return value;
		}
		private double[] getColor_9_22_color_75()
		{
			double[] value = {0.000,0.595,0.405,0.000,0.553,0.447,0.000,0.548,0.452,0.000,0.538,0.462,0.000,0.540,0.460,0.000,0.559,0.441,0.000,0.618,0.382,0.000,0.533,0.467,0.000,0.551,0.449,0.000,0.547,0.453,0.000,0.582,0.418,0.000,0.533,0.467,0.000,0.585,0.415,0.000,0.521,0.479,0.000,0.583,0.417,0.000,0.594,0.406,0.000,0.538,0.462,0.000,0.593,0.407,0.000,0.606,0.394,0.000,0.573,0.427,0.000,0.539,0.461,0.000,0.540,0.460,0.000,0.521,0.479,0.000,0.608,0.392,0.000,0.531,0.469,0.000,0.547,0.453,0.000,0.590,0.410,0.000,0.525,0.475,0.000,0.600,0.400,0.000,0.590,0.410,0.000,0.450,0.550,0.000,0.453,0.547,0.000,0.475,0.525,0.000,0.537,0.463,0.000,0.460,0.540,0.000,0.472,0.528,0.000,0.483,0.517,0.000,0.489,0.511,0.000,0.484,0.516,0.000,0.510,0.490,0.000,0.454,0.546,0.000,0.527,0.473,0.000,0.498,0.502,0.000,0.499,0.501,0.000,0.523,0.477,0.000,0.501,0.499,0.000,0.468,0.532,0.000,0.526,0.474,0.000,0.502,0.498,0.000,0.530,0.470,0.000,0.518,0.482,0.000,0.512,0.488,0.000,0.467,0.533,0.000,0.492,0.508,0.000,0.531,0.469,0.000,0.454,0.546,0.000,0.482,0.518,0.000,0.513,0.487,0.000,0.475,0.525,0.000,0.504,0.496,0.000,0.499,0.501,0.000,0.509,0.491,0.000,0.458,0.542,0.000,0.459,0.541,0.000,0.464,0.536,0.000,0.513,0.487,0.000,0.457,0.543,0.000,0.494,0.506,0.000,0.498,0.502,0.000,0.459,0.541,0.000,0.448,0.552,0.000,0.462,0.538,0.000,0.453,0.547,0.000,0.483,0.517,0.000,0.445,0.555,0.000,0.497,0.503,0.000,0.458,0.542,0.000,0.493,0.507,0.000,0.454,0.546,0.000,0.476,0.524,0.000,0.488,0.512,0.000,0.495,0.505,0.000,0.448,0.552,0.000,0.455,0.545,0.000,0.456,0.544,0.000,0.473,0.527,0.000,0.488,0.512,0.000,0.452,0.548,0.000,0.455,0.545,0.000,0.474,0.526,0.000,0.459,0.541,0.000,0.518,0.482,0.000,0.464,0.536,0.000,0.471,0.529,0.000,0.486,0.514,0.000,0.454,0.546,0.000,0.490,0.510,0.000,0.464,0.536,0.000,0.445,0.555,0.000,0.499,0.501};
			return value;
		}
		private double[] getColor_9_22_color_76()
		{
			double[] value = {0.000,0.508,0.492,0.000,0.486,0.514,0.000,0.497,0.503,0.000,0.466,0.534,0.000,0.466,0.534,0.000,0.485,0.515,0.000,0.471,0.529,0.000,0.482,0.518,0.000,0.508,0.492,0.000,0.487,0.513,0.000,0.449,0.551,0.000,0.496,0.504,0.000,0.476,0.524,0.000,0.514,0.486,0.000,0.468,0.532,0.000,0.490,0.510,0.000,0.504,0.496,0.000,0.443,0.557,0.000,0.480,0.520,0.000,0.470,0.530,0.000,0.402,0.598,0.000,0.441,0.559,0.000,0.414,0.586,0.000,0.388,0.612,0.000,0.434,0.566,0.000,0.406,0.594,0.000,0.414,0.586,0.000,0.403,0.597,0.000,0.405,0.595,0.000,0.419,0.581,0.000,0.409,0.591,0.000,0.440,0.560,0.000,0.401,0.599,0.000,0.432,0.568,0.000,0.426,0.574,0.000,0.397,0.603,0.000,0.433,0.567,0.000,0.397,0.603,0.000,0.401,0.599,0.000,0.398,0.602,0.000,0.438,0.562,0.000,0.438,0.562,0.000,0.409,0.591,0.000,0.429,0.571,0.000,0.408,0.592,0.000,0.432,0.568,0.000,0.441,0.559,0.000,0.422,0.578,0.000,0.423,0.577,0.000,0.391,0.609,0.000,0.422,0.578,0.000,0.426,0.574,0.000,0.413,0.587,0.000,0.441,0.559,0.000,0.438,0.562,0.000,0.405,0.595,0.000,0.417,0.583,0.000,0.428,0.572,0.000,0.405,0.595,0.000,0.377,0.623,0.000,0.397,0.603,0.000,0.424,0.576,0.000,0.406,0.594,0.000,0.394,0.606,0.000,0.416,0.584,0.000,0.385,0.615,0.000,0.372,0.628,0.000,0.409,0.591,0.000,0.371,0.629,0.000,0.386,0.614,0.000,0.388,0.612,0.000,0.375,0.625,0.000,0.398,0.602,0.000,0.422,0.578,0.000,0.439,0.561,0.000,0.373,0.627,0.000,0.429,0.571,0.000,0.387,0.613,0.000,0.392,0.608,0.000,0.406,0.594,0.000,0.391,0.609,0.000,0.431,0.569,0.000,0.398,0.602,0.000,0.431,0.569,0.000,0.359,0.641,0.000,0.357,0.643,0.000,0.370,0.630,0.000,0.376,0.624,0.000,0.342,0.658,0.000,0.373,0.627,0.000,0.366,0.634,0.000,0.373,0.627,0.000,0.356,0.644,0.000,0.338,0.662,0.000,0.365,0.635,0.000,0.366,0.634,0.000,0.362,0.638,0.000,0.371,0.629,0.000,0.325,0.675,0.000,0.329,0.671};
			return value;
		}
		private double[] getColor_9_22_color_77()
		{
			double[] value = {0.000,0.360,0.640,0.000,0.335,0.665,0.000,0.364,0.636,0.000,0.332,0.668,0.000,0.359,0.641,0.000,0.357,0.643,0.000,0.340,0.660,0.000,0.372,0.628,0.000,0.363,0.637,0.000,0.364,0.636,0.000,0.367,0.633,0.000,0.325,0.675,0.000,0.335,0.665,0.000,0.319,0.681,0.000,0.337,0.663,0.000,0.326,0.674,0.000,0.347,0.653,0.000,0.362,0.638,0.000,0.343,0.657,0.000,0.335,0.665,0.000,0.363,0.637,0.000,0.360,0.640,0.000,0.321,0.679,0.000,0.321,0.679,0.000,0.327,0.673,0.000,0.348,0.652,0.000,0.319,0.681,0.000,0.316,0.684,0.000,0.570,0.430,0.000,0.572,0.428,0.000,0.569,0.431,0.000,0.575,0.425,0.000,0.570,0.430,0.000,0.573,0.427,0.000,0.576,0.424,0.000,0.571,0.429,0.000,0.564,0.436,0.000,0.570,0.430,0.000,0.568,0.432,0.000,0.564,0.436,0.000,0.562,0.438,0.000,0.573,0.427,0.000,0.568,0.432,0.000,0.572,0.428,0.000,0.562,0.438,0.000,0.556,0.444,0.000,0.561,0.439,0.000,0.561,0.439,0.000,0.680,0.320,0.000,0.705,0.295,0.000,0.682,0.318,0.000,0.685,0.315,0.000,0.721,0.279,0.000,0.700,0.300,0.000,0.703,0.297,0.000,0.685,0.315,0.000,0.664,0.336,0.000,0.723,0.277,0.000,0.705,0.295,0.000,0.727,0.273,0.000,0.693,0.307,0.000,0.755,0.245,0.000,0.692,0.308,0.000,0.699,0.301,0.000,0.737,0.263,0.000,0.713,0.287,0.000,0.763,0.237,0.000,0.741,0.259,0.000,0.710,0.290,0.000,0.708,0.292,0.000,0.685,0.315,0.000,0.691,0.309,0.000,0.681,0.319,0.000,0.742,0.258,0.000,0.714,0.286,0.000,0.757,0.243,0.000,0.765,0.235,0.000,0.681,0.319,0.000,0.756,0.244,0.000,0.744,0.256,0.000,0.735,0.265,0.000,0.757,0.243,0.000,0.681,0.319,0.000,0.733,0.267,0.000,0.685,0.315,0.000,0.762,0.238,0.000,0.754,0.246,0.000,0.687,0.313,0.000,0.746,0.254,0.000,0.731,0.269,0.000,0.710,0.290,0.000,0.745,0.255,0.000,0.757,0.243,0.000,0.750,0.250,0.000,0.713,0.287,0.000,0.734,0.266,0.000,0.728,0.272,0.000,0.727,0.273,0.000,0.745,0.255,0.000,0.748,0.252};
			return value;
		}
		private double[] getColor_9_22_color_78()
		{
			double[] value = {0.000,0.733,0.267,0.000,0.745,0.255,0.000,0.745,0.255,0.000,0.901,0.099,0.000,0.899,0.101,0.000,0.890,0.110,0.000,0.893,0.107,0.000,0.894,0.106,0.000,0.897,0.103,0.000,0.890,0.110,0.000,0.901,0.099,0.000,0.895,0.105,0.000,0.900,0.100,0.000,0.885,0.115,0.000,0.899,0.101,0.000,0.904,0.096,0.000,0.898,0.102,0.000,0.900,0.100,0.000,0.895,0.105,0.000,0.895,0.105,0.000,0.894,0.106,0.000,0.898,0.102,0.000,0.895,0.105,0.000,0.897,0.103,0.000,0.896,0.104,0.000,0.892,0.108,0.000,0.897,0.103,0.000,0.893,0.107,0.000,0.891,0.109,0.000,0.892,0.108,0.000,0.898,0.102,0.000,0.900,0.100,0.000,0.899,0.101,0.000,0.898,0.102,0.000,0.874,0.126,0.000,0.871,0.129,0.000,0.876,0.124,0.000,0.877,0.123,0.000,0.886,0.114,0.000,0.877,0.123,0.000,0.870,0.130,0.000,0.870,0.130,0.000,0.887,0.113,0.000,0.896,0.104,0.000,0.888,0.112,0.000,0.878,0.122,0.000,0.885,0.115,0.000,0.888,0.112,0.000,0.878,0.122,0.000,0.877,0.123,0.000,0.884,0.116,0.000,0.883,0.117,0.000,0.876,0.124,0.000,0.878,0.122,0.000,0.876,0.124,0.000,0.889,0.111,0.000,0.882,0.118,0.000,0.876,0.124,0.000,0.881,0.119,0.000,0.890,0.110,0.000,0.877,0.123,0.000,0.878,0.122,0.000,0.872,0.128,0.000,0.878,0.122,0.000,0.880,0.120,0.000,0.872,0.128,0.000,0.885,0.115,0.000,0.871,0.129,0.000,0.877,0.123,0.000,0.871,0.129,0.000,0.872,0.128,0.000,0.879,0.121,0.000,0.880,0.120,0.000,0.883,0.117,0.000,0.872,0.128,0.000,0.882,0.118,0.000,0.874,0.126,0.000,0.888,0.112,0.000,0.876,0.124,0.000,0.880,0.120,0.000,0.872,0.128,0.000,0.880,0.120,0.000,0.872,0.128,0.000,0.872,0.128,0.000,0.879,0.121,0.000,0.878,0.122,0.000,0.874,0.126,0.000,0.887,0.113,0.000,0.874,0.126,0.000,0.857,0.143,0.000,0.857,0.143,0.000,0.856,0.144,0.000,0.868,0.132,0.000,0.847,0.153,0.000,0.848,0.152,0.000,0.854,0.146,0.000,0.873,0.127,0.000,0.854,0.146,0.000,0.847,0.153,0.000,0.867,0.133};
			return value;
		}
		private double[] getColor_9_22_color_79()
		{
			double[] value = {0.000,0.852,0.148,0.000,0.874,0.126,0.000,0.874,0.126,0.000,0.871,0.129,0.000,0.857,0.143,0.000,0.863,0.137,0.000,0.859,0.141,0.000,0.872,0.128,0.000,0.851,0.149,0.000,0.868,0.132,0.000,0.870,0.130,0.000,0.850,0.150,0.000,0.867,0.133,0.000,0.872,0.128,0.000,0.870,0.130,0.000,0.848,0.152,0.000,0.865,0.135,0.000,0.857,0.143,0.000,0.852,0.148,0.000,0.843,0.157,0.000,0.869,0.131,0.000,0.865,0.135,0.000,0.868,0.132,0.000,0.869,0.131,0.000,0.873,0.127,0.000,0.875,0.125,0.000,0.863,0.137,0.000,0.856,0.144,0.000,0.862,0.138,0.000,0.859,0.141,0.000,0.860,0.140,0.000,0.852,0.148,0.000,0.854,0.146,0.000,0.855,0.145,0.000,0.856,0.144,0.000,0.855,0.145,0.000,0.855,0.145,0.000,0.854,0.146,0.000,0.863,0.137,0.000,0.867,0.133,0.000,0.867,0.133,0.000,0.879,0.121,0.000,0.867,0.133,0.000,0.879,0.121,0.000,0.873,0.127,0.000,0.868,0.132,0.000,0.840,0.160,0.000,0.870,0.130,0.000,0.813,0.187,0.000,0.797,0.203,0.000,0.839,0.161,0.000,0.839,0.161,0.000,0.809,0.191,0.000,0.812,0.188,0.000,0.794,0.206,0.000,0.836,0.164,0.000,0.804,0.196,0.000,0.837,0.163,0.000,0.823,0.177,0.000,0.805,0.195,0.000,0.796,0.204,0.000,0.813,0.187,0.000,0.811,0.189,0.000,0.789,0.211,0.000,0.801,0.199,0.000,0.812,0.188,0.000,0.788,0.212,0.000,0.831,0.169,0.000,0.810,0.190,0.000,0.843,0.157,0.000,0.791,0.209,0.000,0.786,0.214,0.000,0.828,0.172,0.000,0.799,0.201,0.000,0.803,0.197,0.000,0.820,0.180,0.000,0.819,0.181,0.000,0.800,0.200,0.000,0.829,0.171,0.000,0.833,0.167,0.000,0.804,0.196,0.000,0.815,0.185,0.000,0.788,0.212,0.000,0.809,0.191,0.000,0.813,0.187,0.000,0.819,0.181,0.000,0.787,0.213,0.000,0.803,0.197,0.000,0.834,0.166,0.000,0.816,0.184,0.000,0.842,0.158,0.000,0.784,0.216,0.000,0.793,0.207,0.000,0.813,0.187,0.000,0.816,0.184,0.000,0.823,0.177,0.000,0.820,0.180,0.000,0.819,0.181,0.000,0.826,0.174,0.000,0.797,0.203};
			return value;
		}
		private double[] getColor_9_22_color_80()
		{
			double[] value = {0.000,0.789,0.211,0.000,0.838,0.162,0.000,0.781,0.219,0.000,0.728,0.272,0.000,0.766,0.234,0.000,0.750,0.250,0.000,0.753,0.247,0.000,0.753,0.247,0.000,0.773,0.227,0.000,0.760,0.240,0.000,0.780,0.220,0.000,0.781,0.219,0.000,0.728,0.272,0.000,0.768,0.232,0.000,0.747,0.253,0.000,0.771,0.229,0.000,0.781,0.219,0.000,0.731,0.269,0.000,0.764,0.236,0.000,0.786,0.214,0.000,0.730,0.270,0.000,0.727,0.273,0.000,0.731,0.269,0.000,0.736,0.264,0.000,0.724,0.276,0.000,0.741,0.259,0.000,0.757,0.243,0.000,0.765,0.235,0.000,0.757,0.243,0.000,0.760,0.240,0.000,0.742,0.258,0.000,0.750,0.250,0.000,0.751,0.249,0.000,0.784,0.216,0.000,0.772,0.228,0.000,0.775,0.225,0.000,0.785,0.215,0.000,0.773,0.227,0.000,0.773,0.227,0.000,0.758,0.242,0.000,0.753,0.247,0.000,0.779,0.221,0.000,0.771,0.229,0.000,0.766,0.234,0.000,0.735,0.265,0.000,0.727,0.273,0.000,0.674,0.326,0.000,0.643,0.357,0.000,0.726,0.274,0.000,0.697,0.303,0.000,0.685,0.315,0.000,0.653,0.347,0.000,0.675,0.325,0.000,0.721,0.279,0.000,0.689,0.311,0.000,0.641,0.359,0.000,0.713,0.287,0.000,0.679,0.321,0.000,0.693,0.307,0.000,0.704,0.296,0.000,0.697,0.303,0.000,0.686,0.314,0.000,0.679,0.321,0.000,0.687,0.313,0.000,0.663,0.337,0.000,0.653,0.347,0.000,0.633,0.367,0.000,0.677,0.323,0.000,0.643,0.357,0.000,0.667,0.333,0.000,0.664,0.336,0.000,0.640,0.360,0.000,0.661,0.339,0.000,0.632,0.368,0.000,0.637,0.363,0.000,0.643,0.357,0.000,0.668,0.332,0.000,0.689,0.311,0.000,0.651,0.349,0.000,0.660,0.340,0.000,0.670,0.330,0.000,0.679,0.321,0.000,0.658,0.342,0.000,0.655,0.345,0.000,0.637,0.363,0.000,0.658,0.342,0.000,0.650,0.350,0.000,0.701,0.299,0.000,0.639,0.361,0.000,0.667,0.333,0.000,0.686,0.314,0.000,0.651,0.349,0.000,0.664,0.336,0.000,0.692,0.308,0.000,0.613,0.387,0.000,0.617,0.383,0.000,0.626,0.374,0.000,0.620,0.380,0.000,0.600,0.400,0.000,0.636,0.364};
			return value;
		}
		private double[] getColor_9_22_color_81()
		{
			double[] value = {0.000,0.591,0.409,0.000,0.560,0.440,0.000,0.605,0.395,0.000,0.568,0.432,0.000,0.592,0.408,0.000,0.639,0.361,0.000,0.574,0.426,0.000,0.583,0.417,0.000,0.633,0.367,0.000,0.583,0.417,0.000,0.634,0.366,0.000,0.583,0.417,0.000,0.589,0.411,0.000,0.602,0.398,0.000,0.598,0.402,0.000,0.613,0.387,0.000,0.601,0.399,0.000,0.615,0.385,0.000,0.613,0.387,0.000,0.613,0.387,0.000,0.334,0.666,0.000,0.349,0.651,0.000,0.324,0.676,0.000,0.340,0.660,0.000,0.334,0.666,0.000,0.323,0.677,0.000,0.317,0.683,0.000,0.318,0.682,0.000,0.300,0.700,0.000,0.318,0.682,0.000,0.292,0.708,0.000,0.313,0.687,0.000,0.306,0.694,0.000,0.288,0.712,0.000,0.311,0.689,0.000,0.312,0.688,0.000,0.302,0.698,0.000,0.317,0.683,0.000,0.309,0.691,0.000,0.311,0.689,0.000,0.302,0.698,0.000,0.312,0.688,0.000,0.282,0.718,0.000,0.283,0.717,0.000,0.299,0.701,0.000,0.300,0.700,0.000,0.309,0.691,0.000,0.292,0.708,0.000,0.306,0.694,0.000,0.311,0.689,0.000,0.277,0.723,0.000,0.296,0.704,0.000,0.285,0.715,0.000,0.300,0.700,0.000,0.259,0.741,0.000,0.266,0.734,0.000,0.259,0.741,0.000,0.038,0.962,0.000,0.029,0.971,0.000,0.055,0.945,0.000,0.066,0.934,0.000,0.024,0.976,0.000,0.026,0.974,0.000,0.093,0.907,0.000,0.074,0.926,0.000,0.099,0.901,0.000,0.038,0.962,0.000,0.057,0.943,0.000,0.053,0.947,0.000,0.085,0.915,0.000,0.042,0.958,0.000,0.064,0.936,0.000,0.055,0.945,0.000,0.028,0.972,0.000,0.027,0.973,0.000,0.111,0.889,0.000,0.112,0.888,0.000,0.121,0.879,0.000,0.126,0.874,0.000,0.134,0.866,0.000,0.275,0.725,0.000,0.236,0.764,0.000,0.236,0.764,0.000,0.246,0.754,0.000,0.223,0.777,0.000,0.234,0.766,0.000,0.239,0.761,0.000,0.247,0.753,0.000,0.234,0.766,0.000,0.223,0.777,0.000,0.220,0.780,0.000,0.210,0.790,0.000,0.269,0.731,0.000,0.193,0.807,0.000,0.327,0.673,0.000,0.361,0.639,0.000,0.362,0.638,0.000,0.354,0.646,0.000,0.278,0.722,0.000,0.352,0.648};
			return value;
		}
		private double[] getColor_9_22_color_82()
		{
			double[] value = {0.000,0.337,0.663,0.000,0.350,0.650,0.000,0.334,0.666,0.000,0.283,0.717,0.000,0.350,0.650,0.000,0.314,0.686,0.000,0.351,0.649,0.000,0.340,0.660,0.000,0.301,0.699,0.000,0.290,0.710,0.000,0.284,0.716,0.000,0.366,0.634,0.000,0.375,0.625,0.000,0.406,0.594,0.000,0.376,0.624,0.000,0.371,0.629,0.000,0.395,0.605,0.000,0.369,0.631,0.000,0.586,0.414,0.000,0.581,0.419,0.000,0.579,0.421,0.000,0.579,0.421,0.000,0.586,0.414,0.000,0.583,0.417,0.000,0.584,0.416,0.000,0.582,0.418,0.000,0.580,0.420,0.000,0.583,0.417,0.000,0.582,0.418,0.000,0.576,0.424,0.000,0.581,0.419,0.000,0.579,0.421,0.000,0.576,0.424,0.000,0.577,0.423,0.000,0.580,0.420,0.000,0.580,0.420,0.000,0.578,0.422,0.000,0.578,0.422,0.000,0.576,0.424,0.000,0.569,0.431,0.000,0.570,0.430,0.000,0.577,0.423,0.000,0.577,0.423,0.000,0.575,0.425,0.000,0.577,0.423,0.000,0.564,0.436,0.000,0.553,0.447,0.000,0.577,0.423,0.000,0.577,0.423,0.000,0.784,0.216,0.000,0.790,0.210,0.000,0.775,0.225,0.000,0.778,0.222,0.000,0.779,0.221,0.000,0.799,0.201,0.000,0.787,0.213,0.000,0.845,0.155,0.000,0.847,0.153,0.000,0.794,0.206,0.000,0.838,0.162,0.000,0.763,0.237,0.000,0.764,0.236,0.000,0.825,0.175,0.000,0.815,0.185,0.000,0.759,0.241,0.000,0.819,0.181,0.000,0.835,0.165,0.000,0.807,0.193,0.000,0.820,0.180,0.000,0.805,0.195,0.000,0.811,0.189,0.000,0.823,0.177,0.000,0.827,0.173,0.000,0.775,0.225,0.000,0.828,0.172,0.000,0.865,0.135,0.000,0.828,0.172,0.000,0.864,0.136,0.000,0.862,0.138,0.000,0.832,0.168,0.000,0.753,0.247,0.000,0.821,0.179,0.000,0.855,0.145,0.000,0.836,0.164,0.000,0.846,0.154,0.000,0.858,0.142,0.000,0.846,0.154,0.000,0.820,0.180,0.000,0.853,0.147,0.000,0.833,0.167,0.000,0.834,0.166,0.000,0.849,0.151,0.000,0.815,0.185,0.000,0.900,0.100,0.000,0.901,0.099,0.000,0.906,0.094,0.000,0.838,0.162,0.000,0.905,0.095,0.000,0.900,0.100,0.000,0.844,0.156};
			return value;
		}
		private double[] getColor_9_22_color_83()
		{
			double[] value = {0.000,0.904,0.096,0.000,0.896,0.104,0.000,0.902,0.098,0.000,0.831,0.169,0.000,0.892,0.108,0.000,0.887,0.113,0.000,0.883,0.117,0.000,0.883,0.117,0.000,0.897,0.103,0.000,0.883,0.117,0.000,0.891,0.109,0.000,0.832,0.168,0.000,0.878,0.122,0.000,0.888,0.112,0.000,0.888,0.112,0.000,0.886,0.114,0.000,0.889,0.111,0.000,0.879,0.121,0.000,0.878,0.122,0.000,0.883,0.117,0.000,0.886,0.114,0.000,0.871,0.129,0.000,0.871,0.129,0.000,0.887,0.113,0.000,0.868,0.132,0.000,0.871,0.129,0.000,0.884,0.116,0.000,0.875,0.125,0.000,0.877,0.123,0.000,0.865,0.135,0.000,0.882,0.118,0.000,0.874,0.126,0.000,0.863,0.137,0.000,0.897,0.103,0.000,0.899,0.101,0.000,0.904,0.096,0.000,0.896,0.104,0.000,0.902,0.098,0.000,0.901,0.099,0.000,0.901,0.099,0.000,0.901,0.099,0.000,0.901,0.099,0.000,0.898,0.102,0.000,0.902,0.098,0.000,0.903,0.097,0.000,0.902,0.098,0.000,0.901,0.099,0.000,0.902,0.098,0.000,0.904,0.096,0.000,0.902,0.098,0.000,0.904,0.096,0.000,0.905,0.095,0.000,0.904,0.096,0.000,0.905,0.095,0.000,0.904,0.096,0.000,0.901,0.099,0.000,0.902,0.098,0.000,0.901,0.099,0.000,0.900,0.100,0.000,0.900,0.100,0.000,0.902,0.098,0.000,0.901,0.099,0.000,0.903,0.097,0.000,0.904,0.096,0.000,0.903,0.097,0.000,0.906,0.094,0.000,0.909,0.091,0.000,0.908,0.092,0.000,0.907,0.093,0.000,0.905,0.095,0.000,0.905,0.095,0.000,0.907,0.093,0.000,0.908,0.092,0.000,0.910,0.090,0.000,0.909,0.091,0.000,0.909,0.091,0.000,0.910,0.090,0.000,0.903,0.097,0.000,0.911,0.089,0.000,0.910,0.090,0.000,0.911,0.089,0.000,0.910,0.090,0.000,0.898,0.102,0.000,0.911,0.089,0.000,0.902,0.098,0.000,0.909,0.091,0.000,0.905,0.095,0.000,0.896,0.104,0.000,0.906,0.094,0.000,0.906,0.094,0.000,0.905,0.095,0.000,0.905,0.095,0.000,0.905,0.095,0.000,0.897,0.103,0.000,0.897,0.103,0.000,0.906,0.094,0.000,0.904,0.096,0.000,0.904,0.096,0.000,0.895,0.105,0.000,0.894,0.106};
			return value;
		}
		private double[] getColor_9_22_color_84()
		{
			double[] value = {0.000,0.904,0.096,0.000,0.893,0.107,0.000,0.902,0.098,0.000,0.900,0.100,0.000,0.904,0.096,0.000,0.886,0.114,0.000,0.896,0.104,0.000,0.902,0.098,0.000,0.893,0.107,0.000,0.901,0.099,0.000,0.893,0.107,0.000,0.894,0.106,0.000,0.900,0.100,0.000,0.895,0.105,0.000,0.894,0.106,0.000,0.895,0.105,0.000,0.896,0.104,0.000,0.898,0.102,0.000,0.896,0.104,0.000,0.898,0.102,0.000,0.896,0.104,0.000,0.897,0.103,0.000,0.897,0.103,0.000,0.896,0.104,0.000,0.895,0.105,0.000,0.897,0.103,0.000,0.897,0.103,0.000,0.896,0.104,0.000,0.898,0.102,0.000,0.899,0.101,0.000,0.905,0.095,0.000,0.901,0.099,0.000,0.902,0.098,0.000,0.902,0.098,0.000,0.907,0.093,0.000,0.903,0.097,0.000,0.902,0.098,0.000,0.902,0.098,0.000,0.904,0.096,0.000,0.904,0.096,0.000,0.885,0.115,0.000,0.886,0.114,0.000,0.886,0.114,0.000,0.886,0.114,0.000,0.897,0.103,0.000,0.852,0.148,0.000,0.847,0.153,0.000,0.849,0.151,0.000,0.855,0.145,0.000,0.875,0.125,0.000,0.852,0.148,0.000,0.810,0.190,0.000,0.817,0.183,0.000,0.823,0.177,0.000,0.823,0.177,0.000,0.839,0.161,0.000,0.800,0.200,0.000,0.783,0.217,0.000,0.784,0.216,0.000,0.788,0.212,0.000,0.775,0.225,0.000,0.778,0.222,0.000,0.786,0.214,0.000,0.762,0.238,0.000,0.267,0.733,0.000,0.273,0.727,0.000,0.257,0.743,0.000,0.252,0.748,0.000,0.251,0.749,0.000,0.252,0.748,0.000,0.250,0.750,0.000,0.248,0.752,0.000,0.247,0.753,0.000,0.257,0.743,0.000,0.257,0.743,0.000,0.246,0.754,0.000,0.253,0.747,0.000,0.250,0.750,0.000,0.070,0.930,0.000,0.086,0.914,0.000,0.063,0.937,0.000,0.061,0.939,0.000,0.060,0.940,0.000,0.041,0.959,0.000,0.035,0.965,0.000,0.045,0.955,0.000,0.068,0.932,0.000,0.043,0.957,0.000,0.036,0.964,0.000,0.054,0.946,0.000,0.083,0.917,0.000,0.055,0.945,0.000,0.045,0.955,0.000,0.056,0.944,0.000,0.039,0.961,0.000,0.138,0.862,0.000,0.150,0.850,0.000,0.268,0.732,0.000,0.416,0.584,0.000,0.464,0.536};
			return value;
		}
		private double[] getColor_9_22_color_85()
		{
			double[] value = {0.000,0.418,0.582,0.000,0.394,0.606,0.000,0.418,0.582,0.000,0.430,0.570,0.000,0.448,0.552,0.000,0.398,0.602,0.000,0.408,0.592,0.000,0.447,0.553,0.000,0.513,0.487,0.000,0.511,0.489,0.000,0.522,0.478,0.000,0.520,0.480,0.000,0.511,0.489,0.000,0.519,0.481,0.000,0.520,0.480,0.000,0.514,0.486,0.000,0.519,0.481,0.000,0.513,0.487,0.000,0.491,0.509,0.000,0.497,0.503,0.000,0.475,0.525,0.000,0.495,0.505,0.000,0.516,0.484,0.000,0.508,0.492,0.000,0.511,0.489,0.000,0.478,0.522,0.000,0.520,0.480,0.000,0.480,0.520,0.000,0.480,0.520,0.000,0.515,0.485,0.000,0.511,0.489,0.000,0.550,0.450,0.000,0.502,0.498,0.000,0.549,0.451,0.000,0.509,0.491,0.000,0.538,0.462,0.000,0.508,0.492,0.000,0.551,0.449,0.000,0.520,0.480,0.000,0.485,0.515,0.000,0.500,0.500,0.000,0.491,0.509,0.000,0.591,0.409,0.000,0.575,0.425,0.000,0.585,0.415,0.000,0.591,0.409,0.000,0.577,0.423,0.000,0.577,0.423,0.000,0.575,0.425,0.000,0.590,0.410,0.000,0.572,0.428,0.000,0.578,0.422,0.000,0.569,0.431,0.000,0.577,0.423,0.000,0.588,0.412,0.000,0.567,0.433,0.000,0.569,0.431,0.000,0.566,0.434,0.000,0.565,0.435,0.000,0.579,0.421,0.000,0.564,0.436,0.000,0.579,0.421,0.000,0.579,0.421,0.000,0.573,0.427,0.000,0.565,0.435,0.000,0.581,0.419,0.000,0.576,0.424,0.000,0.570,0.430,0.000,0.558,0.442,0.000,0.566,0.434,0.000,0.847,0.153,0.000,0.858,0.142,0.000,0.860,0.140,0.000,0.847,0.153,0.000,0.857,0.143,0.000,0.853,0.147,0.000,0.851,0.149,0.000,0.850,0.150,0.000,0.844,0.156,0.000,0.854,0.146,0.000,0.865,0.135,0.000,0.841,0.159,0.000,0.854,0.146,0.000,0.898,0.102,0.000,0.904,0.096,0.000,0.873,0.127,0.000,0.895,0.105,0.000,0.900,0.100,0.000,0.869,0.131,0.000,0.869,0.131,0.000,0.876,0.124,0.000,0.888,0.112,0.000,0.890,0.110,0.000,0.882,0.118,0.000,0.870,0.130,0.000,0.905,0.095,0.000,0.261,0.739,0.000,0.258,0.742,0.000,0.254,0.746,0.000,0.251,0.749};
			return value;
		}
		private double[] getColor_9_22_color_86()
		{
			double[] value = {0.000,0.254,0.746,0.000,0.249,0.751,0.000,0.249,0.751,0.000,0.251,0.749,0.000,0.249,0.751,0.000,0.248,0.752,0.000,0.247,0.753,0.000,0.253,0.747,0.000,0.247,0.753,0.000,0.251,0.749,0.000,0.250,0.750,0.000,0.246,0.754,0.000,0.252,0.748,0.000,0.243,0.757,0.000,0.246,0.754,0.000,0.073,0.927,0.000,0.056,0.944,0.000,0.065,0.935,0.000,0.522,0.478,0.000,0.516,0.484,0.000,0.522,0.478,0.000,0.558,0.442,0.000,0.279,0.721,0.000,0.275,0.725,0.000,0.278,0.722,0.000,0.278,0.722,0.000,0.280,0.720,0.000,0.276,0.724,0.000,0.262,0.738,0.000,0.267,0.733,0.000,0.258,0.742,0.000,0.265,0.735,0.000,0.260,0.740,0.000,0.260,0.740,0.000,0.258,0.742,0.000,0.256,0.744,0.000,0.252,0.748,0.000,0.252,0.748,0.000,0.249,0.751,0.000,0.245,0.755,0.000,0.253,0.747,0.000,0.085,0.915,0.000,0.078,0.922,0.000,0.077,0.923,0.000,0.095,0.905,0.000,0.317,0.683,0.000,0.311,0.689,0.000,0.284,0.716,0.000,0.284,0.716,0.000,0.287,0.713,0.000,0.300,0.700,0.000,0.272,0.728,0.000,0.298,0.702,0.000,0.286,0.714,0.000,0.262,0.738,0.000,0.269,0.731,0.000,0.267,0.733,0.000,0.291,0.709,0.000,0.288,0.712,0.000,0.261,0.739,0.000,0.288,0.712,0.000,0.284,0.716,0.000,0.289,0.711,0.000,0.285,0.715,0.000,0.287,0.713,0.000,0.095,0.905,0.000,0.095,0.905,0.000,0.096,0.904,0.000,0.094,0.906,0.000,0.101,0.899,0.000,0.102,0.898,0.000,0.103,0.897,0.000,0.410,0.590,0.000,0.394,0.606,0.000,0.421,0.579,0.000,0.422,0.578,0.000,0.393,0.607,0.000,0.385,0.615,0.000,0.331,0.669,0.000,0.344,0.656,0.000,0.340,0.660,0.000,0.330,0.670,0.000,0.380,0.620,0.000,0.335,0.665,0.000,0.329,0.671,0.000,0.357,0.643,0.000,0.340,0.660,0.000,0.374,0.626,0.000,0.380,0.620,0.000,0.353,0.647,0.000,0.336,0.664,0.000,0.353,0.647,0.000,0.322,0.678,0.000,0.375,0.625,0.000,0.370,0.630,0.000,0.356,0.644,0.000,0.367,0.633,0.000,0.353,0.647,0.000,0.318,0.682,0.000,0.363,0.637};
			return value;
		}
		private double[] getColor_9_22_color_87()
		{
			double[] value = {0.000,0.329,0.671,0.000,0.329,0.671,0.000,0.312,0.688,0.000,0.320,0.680,0.000,0.323,0.677,0.000,0.320,0.680,0.000,0.351,0.649,0.000,0.348,0.652,0.000,0.354,0.646,0.000,0.335,0.665,0.000,0.336,0.664,0.000,0.340,0.660,0.000,0.331,0.669,0.000,0.366,0.634,0.000,0.352,0.648,0.000,0.320,0.680,0.000,0.367,0.633,0.000,0.312,0.688,0.000,0.314,0.686,0.000,0.359,0.641,0.000,0.334,0.666,0.000,0.317,0.683,0.000,0.352,0.648,0.000,0.343,0.657,0.000,0.331,0.669,0.000,0.348,0.652,0.000,0.348,0.652,0.000,0.328,0.672,0.000,0.331,0.669,0.000,0.334,0.666,0.000,0.309,0.691,0.000,0.310,0.690,0.000,0.302,0.698,0.000,0.311,0.689,0.000,0.307,0.693,0.000,0.310,0.690,0.000,0.301,0.699,0.000,0.297,0.703,0.000,0.302,0.698,0.000,0.307,0.693,0.000,0.302,0.698,0.000,0.096,0.904,0.000,0.098,0.902,0.000,0.099,0.901,0.000,0.104,0.896,0.000,0.106,0.894,0.000,0.103,0.897,0.000,0.877,0.123,0.000,0.829,0.171,0.000,0.860,0.140,0.000,0.825,0.175,0.000,0.861,0.139,0.000,0.844,0.156,0.000,0.831,0.169,0.000,0.854,0.146,0.000,0.873,0.127,0.000,0.850,0.150,0.000,0.868,0.132,0.000,0.838,0.162,0.000,0.876,0.124,0.000,0.857,0.143,0.000,0.847,0.153,0.000,0.861,0.139,0.000,0.801,0.199,0.000,0.794,0.206,0.000,0.802,0.198,0.000,0.794,0.206,0.000,0.830,0.170,0.000,0.808,0.192,0.000,0.816,0.184,0.000,0.821,0.179,0.000,0.824,0.176,0.000,0.824,0.176,0.000,0.829,0.171,0.000,0.499,0.501,0.000,0.476,0.524,0.000,0.507,0.493,0.000,0.507,0.493,0.000,0.466,0.534,0.000,0.480,0.520,0.000,0.495,0.505,0.000,0.460,0.540,0.000,0.492,0.508,0.000,0.461,0.539,0.000,0.487,0.513,0.000,0.463,0.537,0.000,0.485,0.515,0.000,0.469,0.531,0.000,0.480,0.520,0.000,0.473,0.527,0.000,0.472,0.528,0.000,0.473,0.527,0.000,0.465,0.535,0.000,0.467,0.533,0.000,0.466,0.534,0.000,0.474,0.526,0.000,0.471,0.529,0.000,0.463,0.537,0.000,0.474,0.526,0.000,0.460,0.540};
			return value;
		}
		private double[] getColor_9_22_color_88()
		{
			double[] value = {0.000,0.444,0.556,0.000,0.434,0.566,0.000,0.402,0.598,0.000,0.385,0.615,0.000,0.386,0.614,0.000,0.391,0.609,0.000,0.399,0.601,0.000,0.385,0.615,0.000,0.454,0.546,0.000,0.440,0.560,0.000,0.447,0.553,0.000,0.431,0.569,0.000,0.450,0.550,0.000,0.459,0.541,0.000,0.415,0.585,0.000,0.443,0.557,0.000,0.443,0.557,0.000,0.393,0.607,0.000,0.454,0.546,0.000,0.434,0.566,0.000,0.377,0.623,0.000,0.095,0.905,0.000,0.097,0.903,0.000,0.093,0.907,0.000,0.096,0.904,0.000,0.095,0.905,0.000,0.099,0.901,0.000,0.095,0.905,0.000,0.096,0.904,0.000,0.099,0.901,0.000,0.103,0.897,0.000,0.099,0.901,0.000,0.098,0.902,0.000,0.104,0.896,0.000,0.830,0.170,0.000,0.834,0.166,0.000,0.876,0.124,0.000,0.865,0.135,0.000,0.870,0.130,0.000,0.879,0.121,0.000,0.836,0.164,0.000,0.875,0.125,0.000,0.871,0.129,0.000,0.847,0.153,0.000,0.869,0.131,0.000,0.844,0.156,0.000,0.874,0.126,0.000,0.875,0.125,0.000,0.880,0.120,0.000,0.869,0.131,0.000,0.835,0.165,0.000,0.865,0.135,0.000,0.834,0.166,0.000,0.872,0.128,0.000,0.875,0.125,0.000,0.866,0.134,0.000,0.879,0.121,0.000,0.880,0.120,0.000,0.860,0.140,0.000,0.879,0.121,0.000,0.881,0.119,0.000,0.873,0.127,0.000,0.882,0.118,0.000,0.871,0.129,0.000,0.865,0.135,0.000,0.876,0.124,0.000,0.836,0.164,0.000,0.766,0.234,0.000,0.750,0.250,0.000,0.779,0.221,0.000,0.789,0.211,0.000,0.761,0.239,0.000,0.749,0.251,0.000,0.763,0.237,0.000,0.776,0.224,0.000,0.759,0.241,0.000,0.768,0.232,0.000,0.786,0.214,0.000,0.785,0.215,0.000,0.738,0.262,0.000,0.744,0.256,0.000,0.769,0.231,0.000,0.739,0.261,0.000,0.795,0.205,0.000,0.787,0.213,0.000,0.739,0.261,0.000,0.808,0.192,0.000,0.797,0.203,0.000,0.792,0.208,0.000,0.791,0.209,0.000,0.768,0.232,0.000,0.749,0.251,0.000,0.770,0.230,0.000,0.748,0.252,0.000,0.780,0.220,0.000,0.744,0.256,0.000,0.806,0.194,0.000,0.779,0.221,0.000,0.824,0.176,0.000,0.750,0.250};
			return value;
		}
		private double[] getColor_9_22_color_89()
		{
			double[] value = {0.000,0.761,0.239,0.000,0.789,0.211,0.000,0.763,0.237,0.000,0.784,0.216,0.000,0.802,0.198,0.000,0.820,0.180,0.000,0.775,0.225,0.000,0.783,0.217,0.000,0.787,0.213,0.000,0.748,0.252,0.000,0.820,0.180,0.000,0.816,0.184,0.000,0.804,0.196,0.000,0.710,0.290,0.000,0.701,0.299,0.000,0.693,0.307,0.000,0.728,0.272,0.000,0.701,0.299,0.000,0.674,0.326,0.000,0.689,0.311,0.000,0.707,0.293,0.000,0.727,0.273,0.000,0.682,0.318,0.000,0.730,0.270,0.000,0.700,0.300,0.000,0.683,0.317,0.000,0.727,0.273,0.000,0.716,0.284,0.000,0.716,0.284,0.000,0.699,0.301,0.000,0.702,0.298,0.000,0.691,0.309,0.000,0.685,0.315,0.000,0.687,0.313,0.000,0.735,0.265,0.000,0.701,0.299,0.000,0.677,0.323,0.000,0.669,0.331,0.000,0.722,0.278,0.000,0.682,0.318,0.000,0.689,0.311,0.000,0.705,0.295,0.000,0.675,0.325,0.000,0.717,0.283,0.000,0.674,0.326,0.000,0.692,0.308,0.000,0.692,0.308,0.000,0.722,0.278,0.000,0.724,0.276,0.000,0.734,0.266,0.000,0.690,0.310,0.000,0.682,0.318,0.000,0.721,0.279,0.000,0.680,0.320,0.000,0.673,0.327,0.000,0.693,0.307,0.000,0.682,0.318,0.000,0.698,0.302,0.000,0.673,0.327,0.000,0.726,0.274,0.000,0.736,0.264,0.000,0.686,0.314,0.000,0.681,0.319,0.000,0.715,0.285,0.000,0.668,0.332,0.000,0.611,0.389,0.000,0.669,0.331,0.000,0.604,0.396,0.000,0.667,0.333,0.000,0.666,0.334,0.000,0.606,0.394,0.000,0.662,0.338,0.000,0.664,0.336,0.000,0.597,0.403,0.000,0.618,0.382,0.000,0.595,0.405,0.000,0.615,0.385,0.000,0.606,0.394,0.000,0.624,0.376,0.000,0.651,0.349,0.000,0.617,0.383,0.000,0.658,0.342,0.000,0.654,0.346,0.000,0.660,0.340,0.000,0.659,0.341,0.000,0.607,0.393,0.000,0.597,0.403,0.000,0.629,0.371,0.000,0.599,0.401,0.000,0.668,0.332,0.000,0.666,0.334,0.000,0.624,0.376,0.000,0.668,0.332,0.000,0.597,0.403,0.000,0.659,0.341,0.000,0.615,0.385,0.000,0.606,0.394,0.000,0.616,0.384,0.000,0.605,0.395,0.000,0.632,0.368};
			return value;
		}
		private double[] getColor_9_22_color_90()
		{
			double[] value = {0.000,0.598,0.402,0.000,0.614,0.386,0.000,0.670,0.330,0.000,0.665,0.335,0.000,0.648,0.352,0.000,0.656,0.344,0.000,0.608,0.392,0.000,0.669,0.331,0.000,0.538,0.462,0.000,0.571,0.429,0.000,0.552,0.448,0.000,0.522,0.478,0.000,0.586,0.414,0.000,0.590,0.410,0.000,0.532,0.468,0.000,0.547,0.453,0.000,0.581,0.419,0.000,0.579,0.421,0.000,0.544,0.456,0.000,0.588,0.412,0.000,0.529,0.471,0.000,0.577,0.423,0.000,0.525,0.475,0.000,0.532,0.468,0.000,0.584,0.416,0.000,0.561,0.439,0.000,0.592,0.408,0.000,0.547,0.453,0.000,0.579,0.421,0.000,0.581,0.419,0.000,0.590,0.410,0.000,0.569,0.431,0.000,0.554,0.446,0.000,0.547,0.453,0.000,0.525,0.475,0.000,0.530,0.470,0.000,0.586,0.414,0.000,0.590,0.410,0.000,0.553,0.447,0.000,0.554,0.446,0.000,0.550,0.450,0.000,0.527,0.473,0.000,0.546,0.454,0.000,0.522,0.478,0.000,0.558,0.442,0.000,0.538,0.462,0.000,0.523,0.477,0.000,0.570,0.430,0.000,0.558,0.442,0.000,0.530,0.470,0.000,0.592,0.408,0.000,0.574,0.426,0.000,0.586,0.414,0.000,0.511,0.489,0.000,0.517,0.483,0.000,0.513,0.487,0.000,0.501,0.499,0.000,0.516,0.484,0.000,0.516,0.484,0.000,0.500,0.500,0.000,0.516,0.484,0.000,0.502,0.498,0.000,0.518,0.482,0.000,0.507,0.493,0.000,0.490,0.510,0.000,0.484,0.516,0.000,0.490,0.510,0.000,0.498,0.502,0.000,0.477,0.523,0.000,0.486,0.514,0.000,0.483,0.517,0.000,0.487,0.513,0.000,0.486,0.514,0.000,0.474,0.526,0.000,0.475,0.525,0.000,0.492,0.508,0.000,0.483,0.517,0.000,0.489,0.511,0.000,0.470,0.530,0.000,0.494,0.506,0.000,0.472,0.528,0.000,0.478,0.522,0.000,0.483,0.517,0.000,0.486,0.514,0.000,0.492,0.508,0.000,0.483,0.517,0.000,0.489,0.511,0.000,0.466,0.534,0.000,0.473,0.527,0.000,0.465,0.535,0.000,0.467,0.533,0.000,0.475,0.525,0.000,0.487,0.513,0.000,0.084,0.916,0.000,0.086,0.914,0.000,0.093,0.907,0.000,0.446,0.554,0.000,0.448,0.552,0.000,0.455,0.545,0.000,0.516,0.484};
			return value;
		}
		private double[] getColor_9_22_color_91()
		{
			double[] value = {0.000,0.547,0.453,0.000,0.537,0.463,0.000,0.549,0.451,0.000,0.466,0.534,0.000,0.537,0.463,0.000,0.510,0.490,0.000,0.505,0.495,0.000,0.542,0.458,0.000,0.512,0.488,0.000,0.500,0.500,0.000,0.480,0.520,0.000,0.517,0.483,0.000,0.500,0.500,0.000,0.518,0.482,0.000,0.507,0.493,0.000,0.504,0.496,0.000,0.468,0.532,0.000,0.510,0.490,0.000,0.505,0.495,0.000,0.508,0.492,0.000,0.516,0.484,0.000,0.505,0.495,0.000,0.517,0.483,0.000,0.512,0.488,0.000,0.576,0.424,0.000,0.570,0.430,0.000,0.577,0.423,0.000,0.575,0.425,0.000,0.577,0.423,0.000,0.568,0.432,0.000,0.570,0.430,0.000,0.571,0.429,0.000,0.559,0.441,0.000,0.571,0.429,0.000,0.553,0.447,0.000,0.574,0.426,0.000,0.574,0.426,0.000,0.545,0.455,0.000,0.559,0.441,0.000,0.543,0.457,0.000,0.554,0.446,0.000,0.553,0.447,0.000,0.563,0.437,0.000,0.560,0.440,0.000,0.564,0.436,0.000,0.551,0.449,0.000,0.537,0.463,0.000,0.768,0.232,0.000,0.766,0.234,0.000,0.763,0.237,0.000,0.796,0.204,0.000,0.785,0.215,0.000,0.826,0.174,0.000,0.788,0.212,0.000,0.816,0.184,0.000,0.828,0.172,0.000,0.822,0.178,0.000,0.788,0.212,0.000,0.794,0.206,0.000,0.830,0.170,0.000,0.828,0.172,0.000,0.829,0.171,0.000,0.821,0.179,0.000,0.820,0.180,0.000,0.824,0.176,0.000,0.826,0.174,0.000,0.826,0.174,0.000,0.828,0.172,0.000,0.793,0.207,0.000,0.778,0.222,0.000,0.825,0.175,0.000,0.824,0.176,0.000,0.790,0.210,0.000,0.786,0.214,0.000,0.776,0.224,0.000,0.818,0.182,0.000,0.785,0.215,0.000,0.825,0.175,0.000,0.811,0.189,0.000,0.782,0.218,0.000,0.809,0.191,0.000,0.821,0.179,0.000,0.805,0.195,0.000,0.820,0.180,0.000,0.831,0.169,0.000,0.840,0.160,0.000,0.829,0.171,0.000,0.831,0.169,0.000,0.830,0.170,0.000,0.829,0.171,0.000,0.828,0.172,0.000,0.826,0.174,0.000,0.824,0.176,0.000,0.824,0.176,0.000,0.828,0.172,0.000,0.060,0.940,0.000,0.058,0.942,0.000,0.064,0.936,0.000,0.073,0.927,0.000,0.065,0.935};
			return value;
		}
		private double[] getColor_9_22_color_92()
		{
			double[] value = {0.000,0.072,0.928,0.000,0.067,0.933,0.000,0.247,0.753,0.000,0.244,0.756,0.000,0.200,0.800,0.000,0.225,0.775,0.000,0.226,0.774,0.000,0.216,0.784,0.000,0.218,0.782,0.000,0.298,0.702,0.000,0.275,0.725,0.000,0.287,0.713,0.000,0.300,0.700,0.000,0.262,0.738,0.000,0.290,0.710,0.000,0.315,0.685,0.000,0.301,0.699,0.000,0.293,0.707,0.000,0.277,0.723,0.000,0.282,0.718,0.000,0.312,0.688,0.000,0.372,0.628,0.000,0.388,0.612,0.000,0.367,0.633,0.000,0.382,0.618,0.000,0.382,0.618,0.000,0.402,0.598,0.000,0.396,0.604,0.000,0.369,0.631,0.000,0.372,0.628,0.000,0.367,0.633,0.000,0.369,0.631,0.000,0.418,0.582,0.000,0.378,0.622,0.000,0.378,0.622,0.000,0.457,0.543,0.000,0.574,0.426,0.000,0.571,0.429,0.000,0.571,0.429,0.000,0.571,0.429,0.000,0.563,0.437,0.000,0.556,0.444,0.000,0.552,0.448,0.000,0.554,0.446,0.000,0.555,0.445,0.000,0.572,0.428,0.000,0.573,0.427,0.000,0.567,0.433,0.000,0.569,0.431,0.000,0.573,0.427,0.000,0.561,0.439,0.000,0.555,0.445,0.000,0.572,0.428,0.000,0.559,0.441,0.000,0.570,0.430,0.000,0.565,0.435,0.000,0.568,0.432,0.000,0.559,0.441,0.000,0.558,0.442,0.000,0.562,0.438,0.000,0.564,0.436,0.000,0.556,0.444,0.000,0.556,0.444,0.000,0.661,0.339,0.000,0.664,0.336,0.000,0.694,0.306,0.000,0.695,0.305,0.000,0.672,0.328,0.000,0.671,0.329,0.000,0.695,0.305,0.000,0.698,0.302,0.000,0.699,0.301,0.000,0.682,0.318,0.000,0.665,0.335,0.000,0.668,0.332,0.000,0.698,0.302,0.000,0.702,0.298,0.000,0.693,0.307,0.000,0.700,0.300,0.000,0.706,0.294,0.000,0.703,0.297,0.000,0.697,0.303,0.000,0.704,0.296,0.000,0.696,0.304,0.000,0.681,0.319,0.000,0.696,0.304,0.000,0.697,0.303,0.000,0.716,0.284,0.000,0.727,0.273,0.000,0.704,0.296,0.000,0.694,0.306,0.000,0.721,0.279,0.000,0.697,0.303,0.000,0.719,0.281,0.000,0.709,0.291,0.000,0.703,0.297,0.000,0.702,0.298,0.000,0.731,0.269,0.000,0.704,0.296,0.000,0.702,0.298};
			return value;
		}
		private double[] getColor_9_22_color_93()
		{
			double[] value = {0.000,0.706,0.294,0.000,0.716,0.284,0.000,0.711,0.289,0.000,0.719,0.281,0.000,0.713,0.287,0.000,0.707,0.293,0.000,0.739,0.261,0.000,0.715,0.285,0.000,0.719,0.281,0.000,0.707,0.293,0.000,0.712,0.288,0.000,0.731,0.269,0.000,0.768,0.232,0.000,0.770,0.230,0.000,0.764,0.236,0.000,0.764,0.236,0.000,0.764,0.236,0.000,0.771,0.229,0.000,0.776,0.224,0.000,0.771,0.229,0.000,0.771,0.229,0.000,0.743,0.257,0.000,0.768,0.232,0.000,0.048,0.952,0.000,0.045,0.955,0.000,0.052,0.948,0.000,0.052,0.948,0.000,0.040,0.960,0.000,0.052,0.948,0.000,0.049,0.951,0.000,0.035,0.965,0.000,0.049,0.951,0.000,0.035,0.965,0.000,0.122,0.878,0.000,0.088,0.912,0.000,0.080,0.920,0.000,0.154,0.846,0.000,0.143,0.857,0.000,0.140,0.860,0.000,0.127,0.873,0.000,0.116,0.884,0.000,0.077,0.923,0.000,0.091,0.909,0.000,0.205,0.795,0.000,0.237,0.763,0.000,0.197,0.803,0.000,0.202,0.798,0.000,0.159,0.841,0.000,0.219,0.781,0.000,0.167,0.833,0.000,0.250,0.750,0.000,0.272,0.728,0.000,0.247,0.753,0.000,0.262,0.738,0.000,0.255,0.745,0.000,0.265,0.735,0.000,0.280,0.720,0.000,0.252,0.748,0.000,0.356,0.644,0.000,0.338,0.662,0.000,0.372,0.628,0.000,0.550,0.450,0.000,0.549,0.451,0.000,0.549,0.451,0.000,0.553,0.447,0.000,0.552,0.448,0.000,0.551,0.449,0.000,0.554,0.446,0.000,0.543,0.457,0.000,0.550,0.450,0.000,0.540,0.460,0.000,0.545,0.455,0.000,0.540,0.460,0.000,0.547,0.453,0.000,0.576,0.424,0.000,0.544,0.456,0.000,0.580,0.420,0.000,0.546,0.454,0.000,0.564,0.436,0.000,0.546,0.454,0.000,0.546,0.454,0.000,0.556,0.444,0.000,0.544,0.456,0.000,0.568,0.432,0.000,0.543,0.457,0.000,0.569,0.431,0.000,0.559,0.441,0.000,0.540,0.460,0.000,0.560,0.440,0.000,0.544,0.456,0.000,0.541,0.459,0.000,0.541,0.459,0.000,0.543,0.457,0.000,0.549,0.451,0.000,0.539,0.461,0.000,0.537,0.463,0.000,0.553,0.447,0.000,0.531,0.469,0.000,0.534,0.466,0.000,0.532,0.468};
			return value;
		}
		private double[] getColor_9_22_color_94()
		{
			double[] value = {0.000,0.538,0.462,0.000,0.624,0.376,0.000,0.626,0.374,0.000,0.643,0.357,0.000,0.607,0.393,0.000,0.588,0.412,0.000,0.639,0.361,0.000,0.578,0.422,0.000,0.575,0.425,0.000,0.607,0.393,0.000,0.629,0.371,0.000,0.574,0.426,0.000,0.599,0.401,0.000,0.563,0.437,0.000,0.615,0.385,0.000,0.582,0.418,0.000,0.570,0.430,0.000,0.664,0.336,0.000,0.647,0.353,0.000,0.657,0.343,0.000,0.649,0.351,0.000,0.645,0.355,0.000,0.667,0.333,0.000,0.668,0.332,0.000,0.636,0.364,0.000,0.628,0.372,0.000,0.645,0.355,0.000,0.581,0.419,0.000,0.617,0.383,0.000,0.563,0.437,0.000,0.514,0.486,0.000,0.544,0.456,0.000,0.549,0.451,0.000,0.516,0.484,0.000,0.542,0.458,0.000,0.547,0.453,0.000,0.446,0.554,0.000,0.440,0.560,0.000,0.434,0.566,0.000,0.434,0.566,0.000,0.452,0.548,0.000,0.482,0.518,0.000,0.469,0.531,0.000,0.477,0.523,0.000,0.494,0.506,0.000,0.422,0.578,0.000,0.425,0.575,0.000,0.422,0.578,0.000,0.387,0.613,0.000,0.418,0.582,0.000,0.423,0.577,0.000,0.396,0.604,0.000,0.404,0.596,0.000,0.382,0.618,0.000,0.387,0.613,0.000,0.410,0.590,0.000,0.387,0.613,0.000,0.395,0.605,0.000,0.393,0.607,0.000,0.403,0.597,0.000,0.415,0.585,0.000,0.384,0.616,0.000,0.432,0.568,0.000,0.393,0.607,0.000,0.427,0.573,0.000,0.401,0.599,0.000,0.410,0.590,0.000,0.409,0.591,0.000,0.421,0.579,0.000,0.415,0.585,0.000,0.424,0.576,0.000,0.402,0.598,0.000,0.391,0.609,0.000,0.407,0.593,0.000,0.393,0.607,0.000,0.344,0.656,0.000,0.613,0.387,0.000,0.580,0.420,0.000,0.577,0.423,0.000,0.566,0.434,0.000,0.575,0.425,0.000,0.590,0.410,0.000,0.573,0.427,0.000,0.622,0.378,0.000,0.596,0.404,0.000,0.575,0.425,0.000,0.847,0.153,0.000,0.846,0.154,0.000,0.848,0.152,0.000,0.756,0.244,0.000,0.784,0.216,0.000,0.779,0.221,0.000,0.734,0.266,0.000,0.790,0.210,0.000,0.792,0.208,0.000,0.757,0.243,0.000,0.735,0.265,0.000,0.671,0.329,0.000,0.714,0.286,0.000,0.732,0.268};
			return value;
		}
		private double[] getColor_9_22_color_95()
		{
			double[] value = {0.000,0.670,0.330,0.000,0.687,0.313,0.000,0.714,0.286,0.000,0.726,0.274,0.000,0.669,0.331,0.000,0.669,0.331,0.000,0.664,0.336,0.000,0.704,0.296,0.000,0.719,0.281,0.000,0.668,0.332,0.000,0.666,0.334,0.000,0.690,0.310,0.000,0.676,0.324,0.000,0.608,0.392,0.000,0.636,0.364,0.000,0.615,0.385,0.000,0.601,0.399,0.000,0.601,0.399,0.000,0.594,0.406,0.000,0.666,0.334,0.000,0.593,0.407,0.000,0.658,0.342,0.000,0.585,0.415,0.000,0.587,0.413,0.000,0.624,0.376,0.000,0.643,0.357,0.000,0.616,0.384,0.000,0.630,0.370,0.000,0.633,0.367,0.000,0.623,0.377,0.000,0.655,0.345,0.000,0.630,0.370,0.000,0.641,0.359,0.000,0.642,0.358,0.000,0.636,0.364,0.000,0.569,0.431,0.000,0.527,0.473,0.000,0.571,0.429,0.000,0.565,0.435,0.000,0.562,0.438,0.000,0.531,0.469,0.000,0.579,0.421,0.000,0.561,0.439,0.000,0.525,0.475,0.000,0.555,0.445,0.000,0.544,0.456,0.000,0.538,0.462,0.000,0.572,0.428,0.000,0.585,0.415,0.000,0.532,0.468,0.000,0.531,0.469,0.000,0.593,0.407,0.000,0.565,0.435,0.000,0.541,0.459,0.000,0.577,0.423,0.000,0.546,0.454,0.000,0.487,0.513,0.000,0.447,0.553,0.000,0.457,0.543,0.000,0.483,0.517,0.000,0.493,0.507,0.000,0.441,0.559,0.000,0.460,0.540,0.000,0.509,0.491,0.000,0.483,0.517,0.000,0.511,0.489,0.000,0.507,0.493,0.000,0.461,0.539,0.000,0.461,0.539,0.000,0.506,0.494,0.000,0.400,0.600,0.000,0.393,0.607,0.000,0.424,0.576,0.000,0.385,0.615,0.000,0.376,0.624,0.000,0.437,0.563,0.000,0.379,0.621,0.000,0.328,0.672,0.000,0.341,0.659,0.000,0.368,0.632,0.000,0.356,0.644,0.000,0.350,0.650,0.000,0.326,0.674,0.000,0.324,0.676,0.000,0.352,0.648,0.000,0.328,0.672,0.000,0.316,0.684,0.000,0.333,0.667,0.000,0.295,0.705,0.000,0.277,0.723,0.000,0.281,0.719,0.000,0.296,0.704,0.000,0.280,0.720,0.000,0.293,0.707,0.000,0.282,0.718,0.000,0.294,0.706,0.000,0.274,0.726,0.000,0.299,0.701,0.000,0.288,0.712,0.000,0.270,0.730};
			return value;
		}
		private double[] getColor_9_22_color_96()
		{
			double[] value = {0.000,0.287,0.713,0.000,0.294,0.706,0.000,0.292,0.708,0.000,0.270,0.730,0.000,0.267,0.733,0.000,0.269,0.731,0.000,0.260,0.740,0.000,0.289,0.711,0.000,0.288,0.712,0.000,0.263,0.737,0.000,0.284,0.716,0.000,0.284,0.716,0.000,0.287,0.713,0.000,0.260,0.740,0.000,0.270,0.730,0.000,0.279,0.721,0.000,0.574,0.426,0.000,0.566,0.434,0.000,0.571,0.429,0.000,0.576,0.424,0.000,0.577,0.423,0.000,0.570,0.430,0.000,0.577,0.423,0.000,0.572,0.428,0.000,0.579,0.421,0.000,0.573,0.427,0.000,0.570,0.430,0.000,0.572,0.428,0.000,0.574,0.426,0.000,0.575,0.425,0.000,0.561,0.439,0.000,0.564,0.436,0.000,0.567,0.433,0.000,0.601,0.399,0.000,0.581,0.419,0.000,0.588,0.412,0.000,0.619,0.381,0.000,0.576,0.424,0.000,0.592,0.408,0.000,0.595,0.405,0.000,0.585,0.415,0.000,0.581,0.419,0.000,0.681,0.319,0.000,0.611,0.389,0.000,0.593,0.407,0.000,0.725,0.275,0.000,0.717,0.283,0.000,0.676,0.324,0.000,0.670,0.330,0.000,0.732,0.268,0.000,0.694,0.306,0.000,0.671,0.329,0.000,0.734,0.266,0.000,0.720,0.280,0.000,0.696,0.304,0.000,0.697,0.303,0.000,0.728,0.272,0.000,0.638,0.362,0.000,0.710,0.290,0.000,0.698,0.302,0.000,0.689,0.311,0.000,0.730,0.270,0.000,0.695,0.305,0.000,0.728,0.272,0.000,0.638,0.362,0.000,0.667,0.333,0.000,0.725,0.275,0.000,0.669,0.331,0.000,0.666,0.334,0.000,0.719,0.281,0.000,0.670,0.330,0.000,0.659,0.341,0.000,0.709,0.291,0.000,0.716,0.284,0.000,0.688,0.312,0.000,0.676,0.324,0.000,0.715,0.285,0.000,0.679,0.321,0.000,0.664,0.336,0.000,0.658,0.342,0.000,0.678,0.322,0.000,0.650,0.350,0.000,0.654,0.346,0.000,0.670,0.330,0.000,0.673,0.327,0.000,0.697,0.303,0.000,0.689,0.311,0.000,0.878,0.122,0.000,0.873,0.127,0.000,0.866,0.134,0.000,0.867,0.133,0.000,0.870,0.130,0.000,0.870,0.130,0.000,0.871,0.129,0.000,0.872,0.128,0.000,0.874,0.126,0.000,0.866,0.134,0.000,0.889,0.111,0.000,0.892,0.108,0.000,0.890,0.110};
			return value;
		}
		private double[] getColor_9_22_color_97()
		{
			double[] value = {0.000,0.888,0.112,0.000,0.886,0.114,0.000,0.886,0.114,0.000,0.886,0.114,0.000,0.897,0.103,0.000,0.888,0.112,0.000,0.888,0.112,0.000,0.886,0.114,0.000,0.897,0.103,0.000,0.896,0.104,0.000,0.896,0.104,0.000,0.897,0.103,0.000,0.888,0.112,0.000,0.897,0.103,0.000,0.898,0.102,0.000,0.898,0.102,0.000,0.889,0.111,0.000,0.898,0.102,0.000,0.900,0.100,0.000,0.897,0.103,0.000,0.900,0.100,0.000,0.880,0.120,0.000,0.857,0.143,0.000,0.896,0.104,0.000,0.899,0.101,0.000,0.897,0.103,0.000,0.898,0.102,0.000,0.892,0.108,0.000,0.852,0.148,0.000,0.895,0.105,0.000,0.891,0.109,0.000,0.880,0.120,0.000,0.891,0.109,0.000,0.888,0.112,0.000,0.890,0.110,0.000,0.889,0.111,0.000,0.888,0.112,0.000,0.873,0.127,0.000,0.854,0.146,0.000,0.881,0.119,0.000,0.875,0.125,0.000,0.884,0.116,0.000,0.874,0.126,0.000,0.872,0.128,0.000,0.881,0.119,0.000,0.873,0.127,0.000,0.874,0.126,0.000,0.851,0.149,0.000,0.846,0.154,0.000,0.851,0.149,0.000,0.871,0.129,0.000,0.847,0.153,0.000,0.871,0.129,0.000,0.846,0.154,0.000,0.870,0.130,0.000,0.870,0.130,0.000,0.868,0.132,0.000,0.869,0.131,0.000,0.868,0.132,0.000,0.867,0.133,0.000,0.871,0.129,0.000,0.867,0.133,0.000,0.845,0.155,0.000,0.868,0.132,0.000,0.899,0.101,0.000,0.897,0.103,0.000,0.896,0.104,0.000,0.895,0.105,0.000,0.896,0.104,0.000,0.898,0.102,0.000,0.896,0.104,0.000,0.896,0.104,0.000,0.896,0.104,0.000,0.897,0.103,0.000,0.896,0.104,0.000,0.898,0.102,0.000,0.889,0.111,0.000,0.891,0.109,0.000,0.892,0.108,0.000,0.887,0.113,0.000,0.889,0.111,0.000,0.888,0.112,0.000,0.899,0.101,0.000,0.883,0.117,0.000,0.887,0.113,0.000,0.879,0.121,0.000,0.897,0.103,0.000,0.886,0.114,0.000,0.897,0.103,0.000,0.894,0.106,0.000,0.896,0.104,0.000,0.875,0.125,0.000,0.899,0.101,0.000,0.879,0.121,0.000,0.882,0.118,0.000,0.887,0.113,0.000,0.865,0.135,0.000,0.890,0.110,0.000,0.883,0.117,0.000,0.864,0.136};
			return value;
		}
		private double[] getColor_9_22_color_98()
		{
			double[] value = {0.000,0.887,0.113,0.000,0.868,0.132,0.000,0.865,0.135,0.000,0.862,0.138,0.000,0.860,0.140,0.000,0.862,0.138,0.000,0.899,0.101,0.000,0.859,0.141,0.000,0.880,0.120,0.000,0.853,0.147,0.000,0.865,0.135,0.000,0.857,0.143,0.000,0.854,0.146,0.000,0.862,0.138,0.000,0.853,0.147,0.000,0.851,0.149,0.000,0.854,0.146,0.000,0.855,0.145,0.000,0.864,0.136,0.000,0.853,0.147,0.000,0.862,0.138,0.000,0.852,0.148,0.000,0.862,0.138,0.000,0.851,0.149,0.000,0.859,0.141,0.000,0.853,0.147,0.000,0.858,0.142,0.000,0.858,0.142,0.000,0.857,0.143,0.000,0.856,0.144,0.000,0.854,0.146,0.000,0.856,0.144,0.000,0.850,0.150,0.000,0.856,0.144,0.000,0.855,0.145,0.000,0.877,0.123,0.000,0.881,0.119,0.000,0.881,0.119,0.000,0.881,0.119,0.000,0.902,0.098,0.000,0.885,0.115,0.000,0.900,0.100,0.000,0.880,0.120,0.000,0.889,0.111,0.000,0.894,0.106,0.000,0.884,0.116,0.000,0.901,0.099,0.000,0.903,0.097,0.000,0.902,0.098,0.000,0.901,0.099,0.000,0.902,0.098,0.000,0.902,0.098,0.000,0.898,0.102,0.000,0.899,0.101,0.000,0.899,0.101,0.000,0.899,0.101,0.000,0.896,0.104,0.000,0.895,0.105,0.000,0.897,0.103,0.000,0.893,0.107,0.000,0.898,0.102,0.000,0.891,0.109,0.000,0.886,0.114,0.000,0.888,0.112,0.000,0.893,0.107,0.000,0.893,0.107,0.000,0.868,0.132,0.000,0.885,0.115,0.000,0.887,0.113,0.000,0.889,0.111,0.000,0.889,0.111,0.000,0.872,0.128,0.000,0.867,0.133,0.000,0.888,0.112,0.000,0.889,0.111,0.000,0.891,0.109,0.000,0.892,0.108,0.000,0.858,0.142,0.000,0.867,0.133,0.000,0.860,0.140,0.000,0.870,0.130,0.000,0.886,0.114,0.000,0.886,0.114,0.000,0.894,0.106,0.000,0.893,0.107,0.000,0.885,0.115,0.000,0.876,0.124,0.000,0.886,0.114,0.000,0.894,0.106,0.000,0.888,0.112,0.000,0.889,0.111,0.000,0.869,0.131,0.000,0.876,0.124,0.000,0.866,0.134,0.000,0.890,0.110,0.000,0.880,0.120,0.000,0.889,0.111,0.000,0.888,0.112,0.000,0.855,0.145,0.000,0.885,0.115};
			return value;
		}
		private double[] getColor_9_22_color_99()
		{
			double[] value = {0.000,0.875,0.125,0.000,0.854,0.146,0.000,0.880,0.120,0.000,0.874,0.126,0.000,0.845,0.155,0.000,0.874,0.126,0.000,0.849,0.151,0.000,0.874,0.126,0.000,0.848,0.152,0.000,0.865,0.135,0.000,0.876,0.124,0.000,0.859,0.141,0.000,0.871,0.129,0.000,0.861,0.139,0.000,0.852,0.148,0.000,0.863,0.137,0.000,0.863,0.137,0.000,0.882,0.118,0.000,0.885,0.115,0.000,0.854,0.146,0.000,0.888,0.112,0.000,0.847,0.153,0.000,0.888,0.112,0.000,0.879,0.121,0.000,0.883,0.117,0.000,0.861,0.139,0.000,0.888,0.112,0.000,0.885,0.115,0.000,0.876,0.124,0.000,0.883,0.117,0.000,0.818,0.182,0.000,0.885,0.115,0.000,0.828,0.172,0.000,0.886,0.114,0.000,0.822,0.178,0.000,0.828,0.172,0.000,0.771,0.229,0.000,0.830,0.170,0.000,0.822,0.178,0.000,0.814,0.186,0.000,0.838,0.162,0.000,0.806,0.194,0.000,0.270,0.730,0.000,0.264,0.736,0.000,0.265,0.735,0.000,0.267,0.733,0.000,0.269,0.731,0.000,0.272,0.728,0.000,0.272,0.728,0.000,0.262,0.738,0.000,0.259,0.741,0.000,0.270,0.730,0.000,0.274,0.726,0.000,0.264,0.736,0.000,0.257,0.743,0.000,0.261,0.739,0.000,0.259,0.741,0.000,0.257,0.743,0.000,0.255,0.745,0.000,0.259,0.741,0.000,0.259,0.741,0.000,0.252,0.748,0.000,0.266,0.734,0.000,0.260,0.740,0.000,0.257,0.743,0.000,0.263,0.737,0.000,0.258,0.742,0.000,0.251,0.749,0.000,0.255,0.745,0.000,0.253,0.747,0.000,0.256,0.744,0.000,0.247,0.753,0.000,0.261,0.739,0.000,0.249,0.751,0.000,0.249,0.751,0.000,0.253,0.747,0.000,0.254,0.746,0.000,0.243,0.757,0.000,0.243,0.757,0.000,0.244,0.756,0.000,0.249,0.751,0.000,0.248,0.752,0.000,0.248,0.752,0.000,0.239,0.761,0.000,0.251,0.749,0.000,0.246,0.754,0.000,0.240,0.760,0.000,0.239,0.761,0.000,0.249,0.751,0.000,0.246,0.754,0.000,0.241,0.759,0.000,0.243,0.757,0.000,0.244,0.756,0.000,0.243,0.757,0.000,0.251,0.749,0.000,0.244,0.756,0.000,0.244,0.756,0.000,0.250,0.750,0.000,0.250,0.750,0.000,0.248,0.752};
			return value;
		}
		private double[] getColor_9_22_color_100()
		{
			double[] value = {0.000,0.246,0.754,0.000,0.248,0.752,0.000,0.248,0.752,0.000,0.031,0.969,0.000,0.029,0.971,0.000,0.104,0.896,0.000,0.050,0.950,0.000,0.036,0.964,0.000,0.067,0.933,0.000,0.050,0.950,0.000,0.057,0.943,0.000,0.068,0.932,0.000,0.110,0.890,0.000,0.052,0.948,0.000,0.063,0.937,0.000,0.032,0.968,0.000,0.061,0.939,0.000,0.041,0.959,0.000,0.137,0.863,0.000,0.176,0.824,0.000,0.271,0.729,0.000,0.265,0.735,0.000,0.274,0.726,0.000,0.282,0.718,0.000,0.268,0.732,0.000,0.271,0.729,0.000,0.275,0.725,0.000,0.257,0.743,0.000,0.251,0.749,0.000,0.267,0.733,0.000,0.263,0.737,0.000,0.273,0.727,0.000,0.252,0.748,0.000,0.271,0.729,0.000,0.279,0.721,0.000,0.215,0.785,0.000,0.253,0.747,0.000,0.279,0.721,0.000,0.284,0.716,0.000,0.249,0.751,0.000,0.278,0.722,0.000,0.264,0.736,0.000,0.268,0.732,0.000,0.270,0.730,0.000,0.271,0.729,0.000,0.278,0.722,0.000,0.288,0.712,0.000,0.274,0.726,0.000,0.264,0.736,0.000,0.283,0.717,0.000,0.267,0.733,0.000,0.285,0.715,0.000,0.268,0.732,0.000,0.281,0.719,0.000,0.284,0.716,0.000,0.267,0.733,0.000,0.293,0.707,0.000,0.276,0.724,0.000,0.346,0.654,0.000,0.300,0.700,0.000,0.326,0.674,0.000,0.309,0.691,0.000,0.288,0.712,0.000,0.294,0.706,0.000,0.346,0.654,0.000,0.357,0.643,0.000,0.317,0.683,0.000,0.339,0.661,0.000,0.358,0.642,0.000,0.290,0.710,0.000,0.311,0.689,0.000,0.366,0.634,0.000,0.309,0.691,0.000,0.308,0.692,0.000,0.371,0.629,0.000,0.364,0.636,0.000,0.326,0.674,0.000,0.304,0.696,0.000,0.305,0.695,0.000,0.373,0.627,0.000,0.313,0.687,0.000,0.320,0.680,0.000,0.333,0.667,0.000,0.301,0.699,0.000,0.310,0.690,0.000,0.372,0.628,0.000,0.321,0.679,0.000,0.328,0.672,0.000,0.301,0.699,0.000,0.375,0.625,0.000,0.298,0.702,0.000,0.304,0.696,0.000,0.332,0.668,0.000,0.351,0.649,0.000,0.298,0.702,0.000,0.375,0.625,0.000,0.305,0.695,0.000,0.300,0.700,0.000,0.375,0.625,0.000,0.380,0.620};
			return value;
		}
		private double[] getColor_9_22_color_101()
		{
			double[] value = {0.000,0.383,0.617,0.000,0.407,0.593,0.000,0.397,0.603,0.000,0.385,0.615,0.000,0.381,0.619,0.000,0.378,0.622,0.000,0.379,0.621,0.000,0.558,0.442,0.000,0.553,0.447,0.000,0.551,0.449,0.000,0.580,0.420,0.000,0.571,0.429,0.000,0.580,0.420,0.000,0.575,0.425,0.000,0.574,0.426,0.000,0.566,0.434,0.000,0.575,0.425,0.000,0.581,0.419,0.000,0.585,0.415,0.000,0.585,0.415,0.000,0.581,0.419,0.000,0.574,0.426,0.000,0.585,0.415,0.000,0.588,0.412,0.000,0.584,0.416,0.000,0.592,0.408,0.000,0.591,0.409,0.000,0.589,0.411,0.000,0.588,0.412,0.000,0.593,0.407,0.000,0.595,0.405,0.000,0.595,0.405,0.000,0.584,0.416,0.000,0.587,0.413,0.000,0.599,0.401,0.000,0.748,0.252,0.000,0.747,0.253,0.000,0.755,0.245,0.000,0.763,0.237,0.000,0.761,0.239,0.000,0.738,0.262,0.000,0.733,0.267,0.000,0.759,0.241,0.000,0.751,0.249,0.000,0.798,0.202,0.000,0.771,0.229,0.000,0.796,0.204,0.000,0.797,0.203,0.000,0.798,0.202,0.000,0.793,0.207,0.000,0.790,0.210,0.000,0.788,0.212,0.000,0.742,0.258,0.000,0.788,0.212,0.000,0.785,0.215,0.000,0.718,0.282,0.000,0.721,0.279,0.000,0.860,0.140,0.000,0.803,0.197,0.000,0.770,0.230,0.000,0.856,0.144,0.000,0.823,0.177,0.000,0.857,0.143,0.000,0.822,0.178,0.000,0.823,0.177,0.000,0.857,0.143,0.000,0.804,0.196,0.000,0.763,0.237,0.000,0.857,0.143,0.000,0.804,0.196,0.000,0.856,0.144,0.000,0.857,0.143,0.000,0.854,0.146,0.000,0.790,0.210,0.000,0.853,0.147,0.000,0.823,0.177,0.000,0.854,0.146,0.000,0.813,0.187,0.000,0.848,0.152,0.000,0.798,0.202,0.000,0.815,0.185,0.000,0.858,0.142,0.000,0.850,0.150,0.000,0.808,0.192,0.000,0.848,0.152,0.000,0.791,0.209,0.000,0.789,0.211,0.000,0.850,0.150,0.000,0.856,0.144,0.000,0.850,0.150,0.000,0.842,0.158,0.000,0.842,0.158,0.000,0.841,0.159,0.000,0.841,0.159,0.000,0.843,0.157,0.000,0.794,0.206,0.000,0.792,0.208,0.000,0.789,0.211,0.000,0.842,0.158,0.000,0.843,0.157};
			return value;
		}
		private double[] getColor_9_22_color_102()
		{
			double[] value = {0.000,0.843,0.157,0.000,0.841,0.159,0.000,0.840,0.160,0.000,0.839,0.161,0.000,0.842,0.158,0.000,0.841,0.159,0.000,0.844,0.156,0.000,0.837,0.163,0.000,0.875,0.125,0.000,0.874,0.126,0.000,0.874,0.126,0.000,0.873,0.127,0.000,0.876,0.124,0.000,0.874,0.126,0.000,0.870,0.130,0.000,0.868,0.132,0.000,0.875,0.125,0.000,0.866,0.134,0.000,0.866,0.134,0.000,0.864,0.136,0.000,0.870,0.130,0.000,0.873,0.127,0.000,0.862,0.138,0.000,0.862,0.138,0.000,0.891,0.109,0.000,0.884,0.116,0.000,0.877,0.123,0.000,0.871,0.129,0.000,0.866,0.134,0.000,0.878,0.122,0.000,0.863,0.137,0.000,0.885,0.115,0.000,0.874,0.126,0.000,0.855,0.145,0.000,0.880,0.120,0.000,0.878,0.122,0.000,0.880,0.120,0.000,0.887,0.113,0.000,0.884,0.116,0.000,0.887,0.113,0.000,0.847,0.153,0.000,0.888,0.112,0.000,0.872,0.128,0.000,0.875,0.125,0.000,0.874,0.126,0.000,0.848,0.152,0.000,0.865,0.135,0.000,0.847,0.153,0.000,0.856,0.144,0.000,0.854,0.146,0.000,0.846,0.154,0.000,0.853,0.147,0.000,0.858,0.142,0.000,0.847,0.153,0.000,0.855,0.145,0.000,0.857,0.143,0.000,0.852,0.148,0.000,0.852,0.148,0.000,0.852,0.148,0.000,0.853,0.147,0.000,0.889,0.111,0.000,0.894,0.106,0.000,0.893,0.107,0.000,0.893,0.107,0.000,0.901,0.099,0.000,0.892,0.108,0.000,0.899,0.101,0.000,0.896,0.104,0.000,0.888,0.112,0.000,0.895,0.105,0.000,0.894,0.106,0.000,0.895,0.105,0.000,0.893,0.107,0.000,0.891,0.109,0.000,0.891,0.109,0.000,0.245,0.755,0.000,0.243,0.757,0.000,0.245,0.755,0.000,0.240,0.760,0.000,0.240,0.760,0.000,0.242,0.758,0.000,0.239,0.761,0.000,0.242,0.758,0.000,0.239,0.761,0.000,0.236,0.764,0.000,0.239,0.761,0.000,0.238,0.762,0.000,0.238,0.762,0.000,0.235,0.765,0.000,0.235,0.765,0.000,0.235,0.765,0.000,0.246,0.754,0.000,0.247,0.753,0.000,0.245,0.755,0.000,0.236,0.764,0.000,0.249,0.751,0.000,0.244,0.756,0.000,0.232,0.768,0.000,0.241,0.759,0.000,0.046,0.954};
			return value;
		}
		private double[] getColor_9_22_color_103()
		{
			double[] value = {0.000,0.052,0.948,0.000,0.076,0.924,0.000,0.045,0.955,0.000,0.091,0.909,0.000,0.058,0.942,0.000,0.068,0.932,0.000,0.040,0.960,0.000,0.043,0.957,0.000,0.096,0.904,0.000,0.114,0.886,0.000,0.108,0.892,0.000,0.077,0.923,0.000,0.048,0.952,0.000,0.045,0.955,0.000,0.077,0.923,0.000,0.118,0.882,0.000,0.045,0.955,0.000,0.053,0.947,0.000,0.082,0.918,0.000,0.073,0.927,0.000,0.088,0.912,0.000,0.056,0.944,0.000,0.071,0.929,0.000,0.070,0.930,0.000,0.108,0.892,0.000,0.114,0.886,0.000,0.075,0.925,0.000,0.062,0.938,0.000,0.053,0.947,0.000,0.093,0.907,0.000,0.128,0.872,0.000,0.054,0.946,0.000,0.190,0.810,0.000,0.127,0.873,0.000,0.142,0.858,0.000,0.240,0.760,0.000,0.215,0.785,0.000,0.271,0.729,0.000,0.272,0.728,0.000,0.453,0.547,0.000,0.445,0.555,0.000,0.442,0.558,0.000,0.460,0.540,0.000,0.455,0.545,0.000,0.470,0.530,0.000,0.428,0.572,0.000,0.465,0.535,0.000,0.416,0.584,0.000,0.474,0.526,0.000,0.414,0.586,0.000,0.467,0.533,0.000,0.424,0.576,0.000,0.467,0.533,0.000,0.461,0.539,0.000,0.405,0.595,0.000,0.426,0.574,0.000,0.479,0.521,0.000,0.476,0.524,0.000,0.431,0.569,0.000,0.467,0.533,0.000,0.494,0.506,0.000,0.476,0.524,0.000,0.503,0.497,0.000,0.482,0.518,0.000,0.482,0.518,0.000,0.500,0.500,0.000,0.499,0.501,0.000,0.487,0.513,0.000,0.484,0.516,0.000,0.502,0.498,0.000,0.495,0.505,0.000,0.508,0.492,0.000,0.505,0.495,0.000,0.523,0.477,0.000,0.496,0.504,0.000,0.534,0.466,0.000,0.509,0.491,0.000,0.489,0.511,0.000,0.519,0.481,0.000,0.503,0.497,0.000,0.509,0.491,0.000,0.571,0.429,0.000,0.519,0.481,0.000,0.569,0.431,0.000,0.573,0.427,0.000,0.584,0.416,0.000,0.586,0.414,0.000,0.572,0.428,0.000,0.571,0.429,0.000,0.590,0.410,0.000,0.596,0.404,0.000,0.590,0.410,0.000,0.814,0.186,0.000,0.816,0.184,0.000,0.798,0.202,0.000,0.803,0.197,0.000,0.798,0.202,0.000,0.853,0.147,0.000,0.854,0.146,0.000,0.829,0.171};
			return value;
		}
		private double[] getColor_9_22_color_104()
		{
			double[] value = {0.000,0.844,0.156,0.000,0.839,0.161,0.000,0.856,0.144,0.000,0.851,0.149,0.000,0.848,0.152,0.000,0.832,0.168,0.000,0.845,0.155,0.000,0.837,0.163,0.000,0.847,0.153,0.000,0.834,0.166,0.000,0.834,0.166,0.000,0.830,0.170,0.000,0.819,0.181,0.000,0.817,0.183,0.000,0.841,0.159,0.000,0.833,0.167,0.000,0.825,0.175,0.000,0.833,0.167,0.000,0.821,0.179,0.000,0.828,0.172,0.000,0.844,0.156,0.000,0.837,0.163,0.000,0.838,0.162,0.000,0.838,0.162,0.000,0.241,0.759,0.000,0.239,0.761,0.000,0.238,0.762,0.000,0.239,0.761,0.000,0.241,0.759,0.000,0.239,0.761,0.000,0.235,0.765,0.000,0.234,0.766,0.000,0.237,0.763,0.000,0.236,0.764,0.000,0.232,0.768,0.000,0.234,0.766,0.000,0.233,0.767,0.000,0.074,0.926,0.000,0.065,0.935,0.000,0.067,0.933,0.000,0.073,0.927,0.000,0.083,0.917,0.000,0.076,0.924,0.000,0.074,0.926,0.000,0.079,0.921,0.000,0.072,0.928,0.000,0.085,0.915,0.000,0.081,0.919,0.000,0.085,0.915,0.000,0.065,0.935,0.000,0.241,0.759,0.000,0.240,0.760,0.000,0.241,0.759,0.000,0.237,0.763,0.000,0.239,0.761,0.000,0.244,0.756,0.000,0.241,0.759,0.000,0.243,0.757,0.000,0.243,0.757,0.000,0.239,0.761,0.000,0.241,0.759,0.000,0.240,0.760,0.000,0.237,0.763,0.000,0.239,0.761,0.000,0.094,0.906,0.000,0.086,0.914,0.000,0.095,0.905,0.000,0.092,0.908,0.000,0.087,0.913,0.000,0.095,0.905,0.000,0.089,0.911,0.000,0.093,0.907,0.000,0.279,0.721,0.000,0.285,0.715,0.000,0.281,0.719,0.000,0.269,0.731,0.000,0.268,0.732,0.000,0.274,0.726,0.000,0.262,0.738,0.000,0.261,0.739,0.000,0.269,0.731,0.000,0.255,0.745,0.000,0.269,0.731,0.000,0.273,0.727,0.000,0.267,0.733,0.000,0.256,0.744,0.000,0.105,0.895,0.000,0.101,0.899,0.000,0.101,0.899,0.000,0.105,0.895,0.000,0.104,0.896,0.000,0.103,0.897,0.000,0.101,0.899,0.000,0.101,0.899,0.000,0.107,0.893,0.000,0.340,0.660,0.000,0.332,0.668,0.000,0.330,0.670,0.000,0.330,0.670,0.000,0.341,0.659};
			return value;
		}
		private double[] getColor_9_22_color_105()
		{
			double[] value = {0.000,0.347,0.653,0.000,0.317,0.683,0.000,0.329,0.671,0.000,0.328,0.672,0.000,0.319,0.681,0.000,0.325,0.675,0.000,0.344,0.656,0.000,0.326,0.674,0.000,0.320,0.680,0.000,0.323,0.677,0.000,0.320,0.680,0.000,0.323,0.677,0.000,0.319,0.681,0.000,0.315,0.685,0.000,0.329,0.671,0.000,0.322,0.678,0.000,0.311,0.689,0.000,0.305,0.695,0.000,0.309,0.691,0.000,0.303,0.697,0.000,0.283,0.717,0.000,0.297,0.703,0.000,0.297,0.703,0.000,0.296,0.704,0.000,0.295,0.705,0.000,0.303,0.697,0.000,0.297,0.703,0.000,0.308,0.692,0.000,0.293,0.707,0.000,0.288,0.712,0.000,0.305,0.695,0.000,0.290,0.710,0.000,0.302,0.698,0.000,0.305,0.695,0.000,0.297,0.703,0.000,0.282,0.718,0.000,0.307,0.693,0.000,0.304,0.696,0.000,0.309,0.691,0.000,0.312,0.688,0.000,0.286,0.714,0.000,0.301,0.699,0.000,0.295,0.705,0.000,0.296,0.704,0.000,0.289,0.711,0.000,0.284,0.716,0.000,0.310,0.690,0.000,0.283,0.717,0.000,0.293,0.707,0.000,0.106,0.894,0.000,0.108,0.892,0.000,0.109,0.891,0.000,0.108,0.892,0.000,0.109,0.891,0.000,0.108,0.892,0.000,0.109,0.891,0.000,0.434,0.566,0.000,0.439,0.561,0.000,0.431,0.569,0.000,0.432,0.568,0.000,0.433,0.567,0.000,0.432,0.568,0.000,0.393,0.607,0.000,0.422,0.578,0.000,0.435,0.565,0.000,0.448,0.552,0.000,0.421,0.579,0.000,0.452,0.548,0.000,0.407,0.593,0.000,0.434,0.566,0.000,0.439,0.561,0.000,0.429,0.571,0.000,0.455,0.545,0.000,0.434,0.566,0.000,0.409,0.591,0.000,0.406,0.594,0.000,0.450,0.550,0.000,0.417,0.583,0.000,0.412,0.588,0.000,0.404,0.596,0.000,0.452,0.548,0.000,0.418,0.582,0.000,0.410,0.590,0.000,0.450,0.550,0.000,0.437,0.563,0.000,0.439,0.561,0.000,0.452,0.548,0.000,0.417,0.583,0.000,0.409,0.591,0.000,0.451,0.549,0.000,0.436,0.564,0.000,0.425,0.575,0.000,0.394,0.606,0.000,0.400,0.600,0.000,0.410,0.590,0.000,0.439,0.561,0.000,0.378,0.622,0.000,0.372,0.628,0.000,0.374,0.626,0.000,0.367,0.633};
			return value;
		}
		private double[] getColor_9_22_color_106()
		{
			double[] value = {0.000,0.371,0.629,0.000,0.367,0.633,0.000,0.372,0.628,0.000,0.337,0.663,0.000,0.362,0.638,0.000,0.343,0.657,0.000,0.344,0.656,0.000,0.378,0.622,0.000,0.390,0.610,0.000,0.346,0.654,0.000,0.388,0.612,0.000,0.332,0.668,0.000,0.340,0.660,0.000,0.342,0.658,0.000,0.353,0.647,0.000,0.382,0.618,0.000,0.385,0.615,0.000,0.365,0.635,0.000,0.385,0.615,0.000,0.108,0.892,0.000,0.104,0.896,0.000,0.101,0.899,0.000,0.103,0.897,0.000,0.105,0.895,0.000,0.868,0.132,0.000,0.869,0.131,0.000,0.883,0.117,0.000,0.885,0.115,0.000,0.881,0.119,0.000,0.882,0.118,0.000,0.868,0.132,0.000,0.884,0.116,0.000,0.887,0.113,0.000,0.886,0.114,0.000,0.889,0.111,0.000,0.889,0.111,0.000,0.892,0.108,0.000,0.888,0.112,0.000,0.892,0.108,0.000,0.892,0.108,0.000,0.877,0.123,0.000,0.879,0.121,0.000,0.877,0.123,0.000,0.859,0.141,0.000,0.879,0.121,0.000,0.844,0.156,0.000,0.872,0.128,0.000,0.864,0.136,0.000,0.875,0.125,0.000,0.883,0.117,0.000,0.852,0.148,0.000,0.878,0.122,0.000,0.848,0.152,0.000,0.853,0.147,0.000,0.876,0.124,0.000,0.846,0.154,0.000,0.877,0.123,0.000,0.876,0.124,0.000,0.848,0.152,0.000,0.807,0.193,0.000,0.765,0.235,0.000,0.768,0.232,0.000,0.767,0.233,0.000,0.735,0.265,0.000,0.750,0.250,0.000,0.819,0.181,0.000,0.826,0.174,0.000,0.756,0.244,0.000,0.755,0.245,0.000,0.830,0.170,0.000,0.771,0.229,0.000,0.817,0.183,0.000,0.840,0.160,0.000,0.746,0.254,0.000,0.792,0.208,0.000,0.770,0.230,0.000,0.763,0.237,0.000,0.840,0.160,0.000,0.773,0.227,0.000,0.779,0.221,0.000,0.750,0.250,0.000,0.749,0.251,0.000,0.761,0.239,0.000,0.788,0.212,0.000,0.839,0.161,0.000,0.787,0.213,0.000,0.830,0.170,0.000,0.783,0.217,0.000,0.843,0.157,0.000,0.809,0.191,0.000,0.843,0.157,0.000,0.809,0.191,0.000,0.818,0.182,0.000,0.799,0.201,0.000,0.832,0.168,0.000,0.832,0.168,0.000,0.712,0.288,0.000,0.692,0.308,0.000,0.700,0.300,0.000,0.710,0.290};
			return value;
		}
		private double[] getColor_9_22_color_107()
		{
			double[] value = {0.000,0.711,0.289,0.000,0.733,0.267,0.000,0.677,0.323,0.000,0.713,0.287,0.000,0.714,0.286,0.000,0.721,0.279,0.000,0.717,0.283,0.000,0.726,0.274,0.000,0.680,0.320,0.000,0.687,0.313,0.000,0.737,0.263,0.000,0.728,0.272,0.000,0.686,0.314,0.000,0.693,0.307,0.000,0.734,0.266,0.000,0.695,0.305,0.000,0.687,0.313,0.000,0.703,0.297,0.000,0.703,0.297,0.000,0.679,0.321,0.000,0.673,0.327,0.000,0.711,0.289,0.000,0.721,0.279,0.000,0.706,0.294,0.000,0.711,0.289,0.000,0.696,0.304,0.000,0.676,0.324,0.000,0.710,0.290,0.000,0.701,0.299,0.000,0.712,0.288,0.000,0.684,0.316,0.000,0.683,0.317,0.000,0.684,0.316,0.000,0.679,0.321,0.000,0.677,0.323,0.000,0.699,0.301,0.000,0.715,0.285,0.000,0.686,0.314,0.000,0.700,0.300,0.000,0.729,0.271,0.000,0.697,0.303,0.000,0.717,0.283,0.000,0.713,0.287,0.000,0.663,0.337,0.000,0.655,0.345,0.000,0.654,0.346,0.000,0.662,0.338,0.000,0.597,0.403,0.000,0.602,0.398,0.000,0.667,0.333,0.000,0.614,0.386,0.000,0.654,0.346,0.000,0.602,0.398,0.000,0.658,0.342,0.000,0.664,0.336,0.000,0.670,0.330,0.000,0.598,0.402,0.000,0.662,0.338,0.000,0.642,0.358,0.000,0.656,0.344,0.000,0.622,0.378,0.000,0.668,0.332,0.000,0.616,0.384,0.000,0.621,0.379,0.000,0.672,0.328,0.000,0.675,0.325,0.000,0.626,0.374,0.000,0.667,0.333,0.000,0.665,0.335,0.000,0.664,0.336,0.000,0.665,0.335,0.000,0.626,0.374,0.000,0.602,0.398,0.000,0.612,0.388,0.000,0.614,0.386,0.000,0.642,0.358,0.000,0.606,0.394,0.000,0.614,0.386,0.000,0.626,0.374,0.000,0.652,0.348,0.000,0.669,0.331,0.000,0.628,0.372,0.000,0.666,0.334,0.000,0.628,0.372,0.000,0.625,0.375,0.000,0.667,0.333,0.000,0.650,0.350,0.000,0.617,0.383,0.000,0.657,0.343,0.000,0.653,0.347,0.000,0.653,0.347,0.000,0.644,0.356,0.000,0.661,0.339,0.000,0.647,0.353,0.000,0.662,0.338,0.000,0.642,0.358,0.000,0.648,0.352,0.000,0.644,0.356,0.000,0.647,0.353,0.000,0.631,0.369};
			return value;
		}
		private double[] getColor_9_22_color_108()
		{
			double[] value = {0.000,0.556,0.444,0.000,0.555,0.445,0.000,0.541,0.459,0.000,0.544,0.456,0.000,0.567,0.433,0.000,0.555,0.445,0.000,0.578,0.422,0.000,0.594,0.406,0.000,0.542,0.458,0.000,0.584,0.416,0.000,0.563,0.437,0.000,0.549,0.451,0.000,0.559,0.441,