/**
 *<p>
 *	This directory includes several experiments with X3D Networking.
 *</p>
 *<p>
 *	Long-running efforts have attempted to define and build a new
 *	<a href="NetworkSensorConnectionNodes.html" target="_blank">NetworkSensor node</a>
 *	for X3D.
 *	Although useful design progress was made by the X3D working group, this work did not reach closure
 *	because author-written implementations did not appear to be possible using X3D prototypes
 *	encapsulating sandbox-restricted JavaScript network access from within an HTML browser.
 *	Further implementation and evaluation work might someday be pursued using an X3D browser implementation.
 *</p>
 *
 *<p>
 *	Examples of additional networking techniques for X3D
 *	can also be added to this archive.
 *	Of related interest: the
 *	<a href="../../../Networking/../DistributedInteractiveSimulation/index.html" target="_blank">Distributed Interactive Simulation (DIS)</a>
 *	examples in this archive, which include native X3D support for the
 *	<a href="http://en.wikipedia.org/wiki/Distributed_Interactive_Simulation" target="_blank">IEEE Distributed Interactive Simulation (DIS)</a>
 *	networking-protocol standard.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/Networking" target="_blank">X3D Basic: Networking</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.Networking;

