####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python NetworkReroutingRoutes.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='NetworkReroutingRoutes.x3d',name='title'),
    meta(content='This file contains a pattern of three routes for a network: a primary, alternate and second-alternate (tertiary). By pushing the buttons, the packets move forward along their predetermined routes for one iteration. Routing and interpolators are pre-wired to move left-to-right only.',name='description'),
    meta(content='Bill Fischer',name='creator'),
    meta(content='22 March 2001',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='NetworkReroutingAlternateRoutes.x3d',name='reference'),
    meta(content='NetworkReroutingAlternateRoutes.png',name='Image'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Networking/NetworkReroutingRoutes.x3d',name='identifier'),
    meta(content='NetworkReroutingAlternateRoutes.x3d',name='reference'),
    meta(content='NetworkReroutingNetwork.x3d',name='reference'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='NetworkReroutingRoutes.x3d'),
    Group(DEF='packets_group',
      children=[
      Transform(DEF='packet1_transmit',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(-6,-.5,0),
          children=[
          Shape(DEF='prim_packet',
            appearance=Appearance(
              material=Material(emissiveColor=(.8,.2,.2))),
            geometry=Cylinder(height=.5,radius=.075))])]),
      Transform(DEF='packet1_2transmit',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(-6,-.5,0),
          children=[
          Shape(USE='prim_packet')])]),
      Transform(DEF='packet2_transmit',
        children=[
        Transform(rotation=(0,1,0,-.785),translation=(-4,-.5,0),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='prim_packet')])])]),
      Transform(DEF='packet2_2transmit',
        children=[
        Transform(rotation=(0,1,0,-.785),translation=(-4,-.5,0),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='prim_packet')])])]),
      Transform(DEF='packet3_transmit',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(-2,-.5,2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='prim_packet')])])]),
      Transform(DEF='packet3_2transmit',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(-2,-.5,2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='prim_packet')])])]),
      Transform(DEF='packet4_transmit',
        children=[
        Transform(rotation=(0,1,0,-.785),translation=(0,-.5,0),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='prim_packet')])])]),
      Transform(DEF='packet4_2transmit',
        children=[
        Transform(rotation=(0,1,0,-.785),translation=(0,-.5,0),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='prim_packet')])])]),
      Transform(DEF='packet5_transmit',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(2,-.5,2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='prim_packet')])])]),
      Transform(DEF='packet5_2transmit',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(2,-.5,2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='prim_packet')])])]),
      Transform(DEF='packet6_transmit',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(4,-.5,0),
          children=[
          Shape(USE='prim_packet')])]),
      Transform(DEF='packet6_2transmit',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(4,-.5,0),
          children=[
          Shape(USE='prim_packet')])]),
      Transform(DEF='packet2_1',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(-6,-.5,0),
          children=[
          Shape(DEF='packet2',
            appearance=Appearance(
              material=Material(emissiveColor=(.2,.2,1))),
            geometry=Cylinder(height=.5,radius=.075))])]),
      Transform(DEF='packet2_1a',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(-6,-.5,0),
          children=[
          Shape(USE='packet2')])]),
      Transform(DEF='packet2_2',
        children=[
        Transform(rotation=(0,1,0,-.785),translation=(-4,-.5,0),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet2')])])]),
      Transform(DEF='packet2_2a',
        children=[
        Transform(rotation=(0,1,0,-.785),translation=(-4,-.5,0),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet2')])])]),
      Transform(DEF='packet2_3',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(-2,-.5,2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet2')])])]),
      Transform(DEF='packet2_3a',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(-2,-.5,2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet2')])])]),
      Transform(DEF='packet2_3b',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(-4,-.5,4),
          children=[
          Shape(USE='packet2')])]),
      Transform(DEF='packet2_3b2',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(-4,-.5,4),
          children=[
          Shape(USE='packet2')])]),
      Transform(DEF='packet2_4',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(0,-.5,4),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet2')])])]),
      Transform(DEF='packet2_4a',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(0,-.5,4),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet2')])])]),
      Transform(DEF='packet2_5',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(2,-.5,2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet2')])])]),
      Transform(DEF='packet2_5a',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(2,-.5,2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet2')])])]),
      Transform(DEF='packet2_6',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(4,-.5,0),
          children=[
          Shape(USE='packet2')])]),
      Transform(DEF='packet2_6a',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(4,-.5,0),
          children=[
          Shape(USE='packet2')])]),
      Transform(DEF='packet3_1',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(-6,-.5,0),
          children=[
          Shape(DEF='packet3',
            appearance=Appearance(
              material=Material(emissiveColor=(.2,1,.2))),
            geometry=Cylinder(height=.5,radius=.075))])]),
      Transform(DEF='packet3_1a',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(-6,-.5,0),
          children=[
          Shape(USE='packet3')])]),
      Transform(DEF='packet3_2',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(-4,-.5,0),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet3')])])]),
      Transform(DEF='packet3_2a',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(-4,-.5,0),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet3')])])]),
      Transform(DEF='packet3_3',
        children=[
        Transform(rotation=(0,1,0,-.785),translation=(-2,-.5,-2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet3')])])]),
      Transform(DEF='packet3_3a',
        children=[
        Transform(rotation=(0,1,0,-.785),translation=(-2,-.5,-2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet3')])])]),
      Transform(DEF='packet3_3b',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(-4,-.5,-4),
          children=[
          Shape(USE='packet3')])]),
      Transform(DEF='packet3_3b2',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(-4,-.5,-4),
          children=[
          Shape(USE='packet3')])]),
      Transform(DEF='packet3_4',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(0,-.5,-4),
          children=[
          Shape(USE='packet3')])]),
      Transform(DEF='packet3_4a',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(0,-.5,-4),
          children=[
          Shape(USE='packet3')])]),
      Transform(DEF='packet3_4b',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(4,-.5,-4),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet3')])])]),
      Transform(DEF='packet3_4b2',
        children=[
        Transform(rotation=(0,1,0,.785),translation=(4,-.5,-4),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet3')])])]),
      Transform(DEF='packet3_5',
        children=[
        Transform(rotation=(0,1,0,-.785),translation=(2,-.5,-2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet3')])])]),
      Transform(DEF='packet3_5a',
        children=[
        Transform(rotation=(0,1,0,-.785),translation=(2,-.5,-2),
          children=[
          Transform(rotation=(0,0,1,1.57),
            children=[
            Shape(USE='packet3')])])]),
      Transform(DEF='packet3_6',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(4,-.5,0),
          children=[
          Shape(USE='packet3')])]),
      Transform(DEF='packet3_6a',
        children=[
        Transform(rotation=(0,0,1,1.57),translation=(4,-.5,0),
          children=[
          Shape(USE='packet3')])]),
      Transform(scale=(.4,.4,.4),translation=(-5,-.5,-6),
        children=[
        Group(
          children=[
          Shape(
            appearance=Appearance(
              material=Material(emissiveColor=(.8,.2,.2))),
            geometry=Cylinder(height=2.5,radius=.75)),
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(.5,.5,.5))),
            geometry=Box(),),
          TouchSensor(DEF='primaryTouch',description='primary TouchSensor'),
          Transform(translation=(0,10.5,0),
            children=[
            Billboard(
              children=[
              Shape(
                geometry=Text(string=["Primary"],
                  fontStyle=FontStyle(horizontal=False,style_='BOLD')),
                appearance=Appearance(
                  material=Material(emissiveColor=(1,.2,.2))))])])])]),
      Transform(scale=(.4,.4,.4),translation=(-4,-.5,-6),
        children=[
        Group(
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(.5,.5,.5))),
            geometry=Box(),),
          Shape(
            appearance=Appearance(
              material=Material(emissiveColor=(.2,.2,.8))),
            geometry=Cylinder(height=2.5,radius=.75)),
          TouchSensor(DEF='secondaryTouch',description='secondary TouchSensor')]),
        Transform(translation=(0,10.5,0),
          children=[
          Billboard(
            children=[
            Shape(
              geometry=Text(string=["Secondary"],
                fontStyle=FontStyle(horizontal=False,style_='BOLD')),
              appearance=Appearance(
                material=Material(emissiveColor=(.2,.2,1))))])])]),
      Transform(scale=(.4,.4,.4),translation=(-3,-.5,-6),
        children=[
        Group(
          children=[
          Shape(
            appearance=Appearance(
              material=Material(diffuseColor=(.5,.5,.5))),
            geometry=Box(),),
          Shape(
            appearance=Appearance(
              material=Material(emissiveColor=(.2,.8,.2))),
            geometry=Cylinder(height=2.5,radius=.75)),
          TouchSensor(DEF='tertiaryTouch',description='tertiary TouchSensor')]),
        Transform(translation=(0,10.5,0),
          children=[
          Billboard(
            children=[
            Shape(
              geometry=Text(string=["Tertiary"],
                fontStyle=FontStyle(horizontal=False,style_='BOLD')),
              appearance=Appearance(
                material=Material(emissiveColor=(.2,1,.2))))])])]),
      Transform(scale=(2,.4,.4),translation=(-4,-.75,-6),
        children=[
        Shape(
          appearance=Appearance(
            material=Material(diffuseColor=(.5,.5,.5))),
          geometry=Box(),)]),
      Transform(scale=(.4,.4,.4),translation=(-.25,2,-6),
        children=[
        Billboard(
          children=[
          Shape(
            geometry=Text(string=["Hop Count:"],
              fontStyle=FontStyle(style_='BOLD')),
            appearance=Appearance(
              material=Material(),))])]),
      Transform(translation=(-.5,1,-6),
        children=[
        Billboard(
          children=[
          Shape(
            geometry=Text(string=["6"],
              fontStyle=FontStyle(style_='BOLD')),
            appearance=Appearance(
              material=Material(DEF='numberSix',diffuseColor=(.4,.2,.2),emissiveColor=(.4,0,0),transparency=1)))])]),
      Transform(translation=(.5,1,-6),
        children=[
        Billboard(
          children=[
          Shape(
            geometry=Text(string=["7"],
              fontStyle=FontStyle(style_='BOLD')),
            appearance=Appearance(
              material=Material(DEF='numberSeven',diffuseColor=(.2,.2,.4),emissiveColor=(0,0,.4),transparency=1)))])]),
      Transform(translation=(1.5,1,-6),
        children=[
        Billboard(
          children=[
          Shape(
            geometry=Text(string=["8"],
              fontStyle=FontStyle(style_='BOLD')),
            appearance=Appearance(
              material=Material(DEF='numberEight',diffuseColor=(.2,.4,.2),emissiveColor=(0,.4,0),transparency=1)))])]),
      TimeSensor(DEF='clock',cycleInterval=2.0),
      TimeSensor(DEF='clock2',cycleInterval=2.0),
      TimeSensor(DEF='clock3',cycleInterval=2.0),
      PositionInterpolator(DEF='node_path',key=[0,.284],keyValue=[(0,0,0),(2,0,0)]),
      PositionInterpolator(DEF='node_patha',key=[0,.284],keyValue=[(0,0,0),(4,0,0)]),
      PositionInterpolator(DEF='node_path2',key=[0,.284],keyValue=[(0,0,0),(2,0,2)]),
      PositionInterpolator(DEF='node_path2a',key=[0,.284],keyValue=[(0,0,0),(-2,0,2)]),
      PositionInterpolator(DEF='node_path3',key=[0,.284],keyValue=[(0,0,0),(2,0,-2)]),
      PositionInterpolator(DEF='node_path3a',key=[0,.284],keyValue=[(0,0,0),(-2,0,-2)]),
      PositionInterpolator(DEF='node_path4',key=[.426,.71],keyValue=[(0,0,0),(2,0,0)]),
      PositionInterpolator(DEF='node_path4a',key=[.426,.71],keyValue=[(0,0,0),(4,0,0)]),
      PositionInterpolator(DEF='node_path5',key=[.426,.71],keyValue=[(0,0,0),(2,0,2)]),
      PositionInterpolator(DEF='node_path5a',key=[.426,.71],keyValue=[(0,0,0),(-2,0,2)]),
      PositionInterpolator(DEF='node_path6',key=[.426,.71],keyValue=[(0,0,0),(2,0,-2)]),
      PositionInterpolator(DEF='node_path6a',key=[.426,.71],keyValue=[(0,0,0),(-2,0,-2)]),
      PositionInterpolator(DEF='path2',key=[.142,.426],keyValue=[(0,0,0),(2,0,0)]),
      PositionInterpolator(DEF='path2a',key=[.142,.426],keyValue=[(0,0,0),(4,0,0)]),
      PositionInterpolator(DEF='path2_2',key=[.142,.426],keyValue=[(0,0,0),(2,0,2)]),
      PositionInterpolator(DEF='path2_2a',key=[.142,.426],keyValue=[(0,0,0),(-2,0,2)]),
      PositionInterpolator(DEF='path2_3',key=[.142,.426],keyValue=[(0,0,0),(2,0,-2)]),
      PositionInterpolator(DEF='path2_3a',key=[.142,.426],keyValue=[(0,0,0),(-2,0,-2)]),
      PositionInterpolator(DEF='path2_4',key=[.568,.852],keyValue=[(0,0,0),(2,0,0)]),
      PositionInterpolator(DEF='path2_4a',key=[.568,.852],keyValue=[(0,0,0),(4,0,0)]),
      PositionInterpolator(DEF='path2_5',key=[.568,.852],keyValue=[(0,0,0),(2,0,2)]),
      PositionInterpolator(DEF='path2_5a',key=[.568,.852],keyValue=[(0,0,0),(-2,0,2)]),
      PositionInterpolator(DEF='path2_6',key=[.568,.852],keyValue=[(0,0,0),(2,0,-2)]),
      PositionInterpolator(DEF='path2_6a',key=[.568,.852],keyValue=[(0,0,0),(-2,0,-2)]),
      PositionInterpolator(DEF='path3',key=[.284,.568],keyValue=[(0,0,0),(2,0,0)]),
      PositionInterpolator(DEF='path3a',key=[.284,.568],keyValue=[(0,0,0),(4,0,0)]),
      PositionInterpolator(DEF='path3_2',key=[.284,.568],keyValue=[(0,0,0),(2,0,2)]),
      PositionInterpolator(DEF='path3_2a',key=[.284,.568],keyValue=[(0,0,0),(-2,0,2)]),
      PositionInterpolator(DEF='path3_3',key=[.284,.568],keyValue=[(0,0,0),(2,0,-2)]),
      PositionInterpolator(DEF='path3_3a',key=[.284,.568],keyValue=[(0,0,0),(-2,0,-2)]),
      PositionInterpolator(DEF='path3_4',key=[.71,1],keyValue=[(0,0,0),(2,0,0)]),
      PositionInterpolator(DEF='path3_4a',key=[.71,1],keyValue=[(0,0,0),(4,0,0)]),
      PositionInterpolator(DEF='path3_5',key=[.71,1],keyValue=[(0,0,0),(2,0,2)]),
      PositionInterpolator(DEF='path3_5a',key=[.71,1],keyValue=[(0,0,0),(-2,0,2)]),
      PositionInterpolator(DEF='path3_6',key=[.71,1],keyValue=[(0,0,0),(2,0,-2)]),
      PositionInterpolator(DEF='path3_6a',key=[.71,1],keyValue=[(0,0,0),(-2,0,-2)]),
      Script(DEF='toggleScript1',
        field=[
        field(accessType='inputOnly',name='toggle',type='SFBool'),
        field(accessType='initializeOnly',name='state',type='SFBool',value=False),
        field(accessType='outputOnly',name='toggleValue',type='SFBool'),
        field(accessType='initializeOnly',name='transState',type='SFFloat',value=1),
        field(accessType='outputOnly',name='transparency',type='SFFloat')],

      sourceCode="""
ecmascript:

function toggle ( value, ts ) {
 if(value == true){
   state = !state;
   toggleValue = state;
   }
   if(state){
      transState = 0;
      transparency = transState;
   }
   else{
      transState = 1;
      transparency = transState;
   }
}
"""),
      Script(DEF='toggleScript2',
        field=[
        field(accessType='inputOnly',name='toggle',type='SFBool'),
        field(accessType='initializeOnly',name='state',type='SFBool',value=False),
        field(accessType='outputOnly',name='toggleValue',type='SFBool'),
        field(accessType='initializeOnly',name='transState',type='SFFloat',value=1),
        field(accessType='outputOnly',name='transparency',type='SFFloat')],

      sourceCode="""
ecmascript:

function toggle ( value, ts ) {
 if(value == true){
   state = !state;
   toggleValue = state;
   }
   if(state){
      transState = 0;
      transparency = transState;
   }
   else{
      transState = 1;
      transparency = transState;
   }
}
"""),
      Script(DEF='toggleScript3',
        field=[
        field(accessType='inputOnly',name='toggle',type='SFBool'),
        field(accessType='initializeOnly',name='state',type='SFBool',value=False),
        field(accessType='outputOnly',name='toggleValue',type='SFBool'),
        field(accessType='initializeOnly',name='transState',type='SFFloat',value=1),
        field(accessType='outputOnly',name='transparency',type='SFFloat')],

      sourceCode="""
ecmascript:

function toggle ( value, ts ) {
 if(value == true){
   state = !state;
   toggleValue = state;
   }
   if(state){
      transState = 0;
      transparency = transState;
   }
   else{
      transState = 1;
      transparency = transState;
   }
}
""")]),
    ROUTE(fromField='isActive',fromNode='primaryTouch',toField='toggle',toNode='toggleScript1'),
    ROUTE(fromField='toggleValue',fromNode='toggleScript1',toField='loop',toNode='clock'),
    ROUTE(fromField='isActive',fromNode='secondaryTouch',toField='toggle',toNode='toggleScript2'),
    ROUTE(fromField='toggleValue',fromNode='toggleScript2',toField='loop',toNode='clock2'),
    ROUTE(fromField='isActive',fromNode='tertiaryTouch',toField='toggle',toNode='toggleScript3'),
    ROUTE(fromField='toggleValue',fromNode='toggleScript3',toField='loop',toNode='clock3'),
    ROUTE(fromField='transparency',fromNode='toggleScript1',toField='transparency',toNode='numberSix'),
    ROUTE(fromField='transparency',fromNode='toggleScript2',toField='transparency',toNode='numberSeven'),
    ROUTE(fromField='transparency',fromNode='toggleScript3',toField='transparency',toNode='numberEight'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_patha'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path2'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path2a'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path3'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path3a'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path4'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path4a'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path5'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path5a'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path6'),
    ROUTE(fromField='fraction_changed',fromNode='clock',toField='set_fraction',toNode='node_path6a'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2a'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2_2'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2_2a'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2_3'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2_3a'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2_4'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2_4a'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2_5'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2_5a'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2_6'),
    ROUTE(fromField='fraction_changed',fromNode='clock2',toField='set_fraction',toNode='path2_6a'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3a'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3_2'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3_2a'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3_3'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3_3a'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3_4'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3_4a'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3_5'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3_5a'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3_6'),
    ROUTE(fromField='fraction_changed',fromNode='clock3',toField='set_fraction',toNode='path3_6a'),
    ROUTE(fromField='value_changed',fromNode='node_path',toField='set_translation',toNode='packet1_transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path4',toField='set_translation',toNode='packet1_2transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path2',toField='set_translation',toNode='packet2_transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path5',toField='set_translation',toNode='packet2_2transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path3',toField='set_translation',toNode='packet3_transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path6',toField='set_translation',toNode='packet3_2transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path2',toField='set_translation',toNode='packet4_transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path5',toField='set_translation',toNode='packet4_2transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path3',toField='set_translation',toNode='packet5_transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path6',toField='set_translation',toNode='packet5_2transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path',toField='set_translation',toNode='packet6_transmit'),
    ROUTE(fromField='value_changed',fromNode='node_path4',toField='set_translation',toNode='packet6_2transmit'),
    ROUTE(fromField='value_changed',fromNode='path2',toField='set_translation',toNode='packet2_1'),
    ROUTE(fromField='value_changed',fromNode='path2_4',toField='set_translation',toNode='packet2_1a'),
    ROUTE(fromField='value_changed',fromNode='path2_2',toField='set_translation',toNode='packet2_2'),
    ROUTE(fromField='value_changed',fromNode='path2_5',toField='set_translation',toNode='packet2_2a'),
    ROUTE(fromField='value_changed',fromNode='path2_3',toField='set_translation',toNode='packet2_2'),
    ROUTE(fromField='value_changed',fromNode='path2_6',toField='set_translation',toNode='packet2_2a'),
    ROUTE(fromField='value_changed',fromNode='path2_2a',toField='set_translation',toNode='packet2_3'),
    ROUTE(fromField='value_changed',fromNode='path2_5a',toField='set_translation',toNode='packet2_3a'),
    ROUTE(fromField='value_changed',fromNode='path2_4a',toField='set_translation',toNode='packet2_3b2'),
    ROUTE(fromField='value_changed',fromNode='path2a',toField='set_translation',toNode='packet2_3b'),
    ROUTE(fromField='value_changed',fromNode='path2_3',toField='set_translation',toNode='packet2_4'),
    ROUTE(fromField='value_changed',fromNode='path2_6',toField='set_translation',toNode='packet2_4a'),
    ROUTE(fromField='value_changed',fromNode='path2_3',toField='set_translation',toNode='packet2_5'),
    ROUTE(fromField='value_changed',fromNode='path2_6',toField='set_translation',toNode='packet2_5a'),
    ROUTE(fromField='value_changed',fromNode='path2',toField='set_translation',toNode='packet2_6'),
    ROUTE(fromField='value_changed',fromNode='path2_4',toField='set_translation',toNode='packet2_6a'),
    ROUTE(fromField='value_changed',fromNode='path3',toField='set_translation',toNode='packet3_1'),
    ROUTE(fromField='value_changed',fromNode='path3_4',toField='set_translation',toNode='packet3_1a'),
    ROUTE(fromField='value_changed',fromNode='path3_3',toField='set_translation',toNode='packet3_2'),
    ROUTE(fromField='value_changed',fromNode='path3_6',toField='set_translation',toNode='packet3_2a'),
    ROUTE(fromField='value_changed',fromNode='path3_3a',toField='set_translation',toNode='packet3_3'),
    ROUTE(fromField='value_changed',fromNode='path3_6a',toField='set_translation',toNode='packet3_3a'),
    ROUTE(fromField='value_changed',fromNode='path3a',toField='set_translation',toNode='packet3_3b'),
    ROUTE(fromField='value_changed',fromNode='path3_4a',toField='set_translation',toNode='packet3_3b2'),
    ROUTE(fromField='value_changed',fromNode='path3a',toField='set_translation',toNode='packet3_4'),
    ROUTE(fromField='value_changed',fromNode='path3_4a',toField='set_translation',toNode='packet3_4a'),
    ROUTE(fromField='value_changed',fromNode='path3_2a',toField='set_translation',toNode='packet3_4b'),
    ROUTE(fromField='value_changed',fromNode='path3_5a',toField='set_translation',toNode='packet3_4b2'),
    ROUTE(fromField='value_changed',fromNode='path3_2',toField='set_translation',toNode='packet3_5'),
    ROUTE(fromField='value_changed',fromNode='path3_5',toField='set_translation',toNode='packet3_5a'),
    ROUTE(fromField='value_changed',fromNode='path3',toField='set_translation',toNode='packet3_6'),
    ROUTE(fromField='value_changed',fromNode='path3_4',toField='set_translation',toNode='packet3_6a')])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for NetworkReroutingRoutes.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python NetworkReroutingRoutes.py load and self-test diagnostics complete.")
