package Basic.Networking;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> This file contains a pattern of three routes for a network: a primary, alternate and second-alternate (tertiary). By pushing the buttons, the packets move forward along their predetermined routes for one iteration. Routing and interpolators are pre-wired to move left-to-right only. </p>
 <p> Related links: Catalog page <a href="../../../Networking/NetworkReroutingRoutesIndex.html" target="_blank">NetworkReroutingRoutes</a>,  source <a href="../../../Networking/NetworkReroutingRoutes.java">NetworkReroutingRoutes.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Networking/NetworkReroutingRoutes.x3d">NetworkReroutingRoutes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> This file contains a pattern of three routes for a network: a primary, alternate and second-alternate (tertiary). By pushing the buttons, the packets move forward along their predetermined routes for one iteration. Routing and interpolators are pre-wired to move left-to-right only. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Bill Fischer </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 22 March 2001 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Networking/NetworkReroutingAlternateRoutes.x3d">NetworkReroutingAlternateRoutes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../Networking/NetworkReroutingAlternateRoutes.png">NetworkReroutingAlternateRoutes.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Networking/NetworkReroutingRoutes.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Networking/NetworkReroutingRoutes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Networking/NetworkReroutingAlternateRoutes.x3d">NetworkReroutingAlternateRoutes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Networking/NetworkReroutingNetwork.x3d">NetworkReroutingNetwork.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Networking/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Bill Fischer
 */

public class NetworkReroutingRoutes
{
	/** Default constructor to create this object. */
	public NetworkReroutingRoutes ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("NetworkReroutingRoutes.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("This file contains a pattern of three routes for a network: a primary, alternate and second-alternate (tertiary). By pushing the buttons, the packets move forward along their predetermined routes for one iteration. Routing and interpolators are pre-wired to move left-to-right only."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Bill Fischer"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("22 March 2001"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("NetworkReroutingAlternateRoutes.x3d"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("NetworkReroutingAlternateRoutes.png"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Networking/NetworkReroutingRoutes.x3d"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("NetworkReroutingAlternateRoutes.x3d"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("NetworkReroutingNetwork.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("NetworkReroutingRoutes.x3d"))
    .addChild(new Group("packets_group")
      .addChild(new Transform("packet1_transmit")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-6.0,-.5,0.0)
          .addChild(new Shape("prim_packet")
            .setAppearance(new Appearance()
              .setMaterial(new Material().setEmissiveColor(.8,.2,.2)))
            .setGeometry(new Cylinder().setHeight(.5).setRadius(.075)))))
      .addChild(new Transform("packet1_2transmit")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-6.0,-.5,0.0)
          .addChild(new Shape().setUSE("prim_packet"))))
      .addChild(new Transform("packet2_transmit")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-.785).setTranslation(-4.0,-.5,0.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("prim_packet")))))
      .addChild(new Transform("packet2_2transmit")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-.785).setTranslation(-4.0,-.5,0.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("prim_packet")))))
      .addChild(new Transform("packet3_transmit")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(-2.0,-.5,2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("prim_packet")))))
      .addChild(new Transform("packet3_2transmit")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(-2.0,-.5,2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("prim_packet")))))
      .addChild(new Transform("packet4_transmit")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-.785).setTranslation(0.0,-.5,0.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("prim_packet")))))
      .addChild(new Transform("packet4_2transmit")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-.785).setTranslation(0.0,-.5,0.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("prim_packet")))))
      .addChild(new Transform("packet5_transmit")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(2.0,-.5,2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("prim_packet")))))
      .addChild(new Transform("packet5_2transmit")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(2.0,-.5,2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("prim_packet")))))
      .addChild(new Transform("packet6_transmit")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(4.0,-.5,0.0)
          .addChild(new Shape().setUSE("prim_packet"))))
      .addChild(new Transform("packet6_2transmit")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(4.0,-.5,0.0)
          .addChild(new Shape().setUSE("prim_packet"))))
      .addChild(new Transform("packet2_1")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-6.0,-.5,0.0)
          .addChild(new Shape("packet2")
            .setAppearance(new Appearance()
              .setMaterial(new Material().setEmissiveColor(.2,.2,1.0)))
            .setGeometry(new Cylinder().setHeight(.5).setRadius(.075)))))
      .addChild(new Transform("packet2_1a")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-6.0,-.5,0.0)
          .addChild(new Shape().setUSE("packet2"))))
      .addChild(new Transform("packet2_2")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-.785).setTranslation(-4.0,-.5,0.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet2")))))
      .addChild(new Transform("packet2_2a")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-.785).setTranslation(-4.0,-.5,0.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet2")))))
      .addChild(new Transform("packet2_3")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(-2.0,-.5,2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet2")))))
      .addChild(new Transform("packet2_3a")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(-2.0,-.5,2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet2")))))
      .addChild(new Transform("packet2_3b")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-4.0,-.5,4.0)
          .addChild(new Shape().setUSE("packet2"))))
      .addChild(new Transform("packet2_3b2")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-4.0,-.5,4.0)
          .addChild(new Shape().setUSE("packet2"))))
      .addChild(new Transform("packet2_4")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(0.0,-.5,4.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet2")))))
      .addChild(new Transform("packet2_4a")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(0.0,-.5,4.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet2")))))
      .addChild(new Transform("packet2_5")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(2.0,-.5,2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet2")))))
      .addChild(new Transform("packet2_5a")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(2.0,-.5,2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet2")))))
      .addChild(new Transform("packet2_6")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(4.0,-.5,0.0)
          .addChild(new Shape().setUSE("packet2"))))
      .addChild(new Transform("packet2_6a")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(4.0,-.5,0.0)
          .addChild(new Shape().setUSE("packet2"))))
      .addChild(new Transform("packet3_1")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-6.0,-.5,0.0)
          .addChild(new Shape("packet3")
            .setAppearance(new Appearance()
              .setMaterial(new Material().setEmissiveColor(.2,1.0,.2)))
            .setGeometry(new Cylinder().setHeight(.5).setRadius(.075)))))
      .addChild(new Transform("packet3_1a")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-6.0,-.5,0.0)
          .addChild(new Shape().setUSE("packet3"))))
      .addChild(new Transform("packet3_2")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(-4.0,-.5,0.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet3")))))
      .addChild(new Transform("packet3_2a")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(-4.0,-.5,0.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet3")))))
      .addChild(new Transform("packet3_3")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-.785).setTranslation(-2.0,-.5,-2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet3")))))
      .addChild(new Transform("packet3_3a")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-.785).setTranslation(-2.0,-.5,-2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet3")))))
      .addChild(new Transform("packet3_3b")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-4.0,-.5,-4.0)
          .addChild(new Shape().setUSE("packet3"))))
      .addChild(new Transform("packet3_3b2")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(-4.0,-.5,-4.0)
          .addChild(new Shape().setUSE("packet3"))))
      .addChild(new Transform("packet3_4")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(0.0,-.5,-4.0)
          .addChild(new Shape().setUSE("packet3"))))
      .addChild(new Transform("packet3_4a")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(0.0,-.5,-4.0)
          .addChild(new Shape().setUSE("packet3"))))
      .addChild(new Transform("packet3_4b")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(4.0,-.5,-4.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet3")))))
      .addChild(new Transform("packet3_4b2")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,.785).setTranslation(4.0,-.5,-4.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet3")))))
      .addChild(new Transform("packet3_5")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-.785).setTranslation(2.0,-.5,-2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet3")))))
      .addChild(new Transform("packet3_5a")
        .addChild(new Transform().setRotation(0.0,1.0,0.0,-.785).setTranslation(2.0,-.5,-2.0)
          .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57)
            .addChild(new Shape().setUSE("packet3")))))
      .addChild(new Transform("packet3_6")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(4.0,-.5,0.0)
          .addChild(new Shape().setUSE("packet3"))))
      .addChild(new Transform("packet3_6a")
        .addChild(new Transform().setRotation(0.0,0.0,1.0,1.57).setTranslation(4.0,-.5,0.0)
          .addChild(new Shape().setUSE("packet3"))))
      .addChild(new Transform().setScale(.4,.4,.4).setTranslation(-5.0,-.5,-6.0)
        .addChild(new Group()
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setEmissiveColor(.8,.2,.2)))
            .setGeometry(new Cylinder().setHeight(2.5).setRadius(.75)))
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(.5,.5,.5)))
            .setGeometry(new Box()))
          .addChild(new TouchSensor("primaryTouch").setDescription("primary TouchSensor"))
          .addChild(new Transform().setTranslation(0.0,10.5,0.0)
            .addChild(new Billboard()
              .addChild(new Shape()
                .setGeometry(new Text().setString(new String[] {"Primary"})
                  .setFontStyle(new FontStyle().setHorizontal(false).setCssStyle("BOLD")))
                .setAppearance(new Appearance()
                  .setMaterial(new Material().setEmissiveColor(1.0,.2,.2))))))))
      .addChild(new Transform().setScale(.4,.4,.4).setTranslation(-4.0,-.5,-6.0)
        .addChild(new Group()
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(.5,.5,.5)))
            .setGeometry(new Box()))
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setEmissiveColor(.2,.2,.8)))
            .setGeometry(new Cylinder().setHeight(2.5).setRadius(.75)))
          .addChild(new TouchSensor("secondaryTouch").setDescription("secondary TouchSensor")))
        .addChild(new Transform().setTranslation(0.0,10.5,0.0)
          .addChild(new Billboard()
            .addChild(new Shape()
              .setGeometry(new Text().setString(new String[] {"Secondary"})
                .setFontStyle(new FontStyle().setHorizontal(false).setCssStyle("BOLD")))
              .setAppearance(new Appearance()
                .setMaterial(new Material().setEmissiveColor(.2,.2,1.0)))))))
      .addChild(new Transform().setScale(.4,.4,.4).setTranslation(-3.0,-.5,-6.0)
        .addChild(new Group()
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(.5,.5,.5)))
            .setGeometry(new Box()))
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setEmissiveColor(.2,.8,.2)))
            .setGeometry(new Cylinder().setHeight(2.5).setRadius(.75)))
          .addChild(new TouchSensor("tertiaryTouch").setDescription("tertiary TouchSensor")))
        .addChild(new Transform().setTranslation(0.0,10.5,0.0)
          .addChild(new Billboard()
            .addChild(new Shape()
              .setGeometry(new Text().setString(new String[] {"Tertiary"})
                .setFontStyle(new FontStyle().setHorizontal(false).setCssStyle("BOLD")))
              .setAppearance(new Appearance()
                .setMaterial(new Material().setEmissiveColor(.2,1.0,.2)))))))
      .addChild(new Transform().setScale(2.0,.4,.4).setTranslation(-4.0,-.75,-6.0)
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material().setDiffuseColor(.5,.5,.5)))
          .setGeometry(new Box())))
      .addChild(new Transform().setScale(.4,.4,.4).setTranslation(-.25,2.0,-6.0)
        .addChild(new Billboard()
          .addChild(new Shape()
            .setGeometry(new Text().setString(new String[] {"Hop Count:"})
              .setFontStyle(new FontStyle().setCssStyle("BOLD")))
            .setAppearance(new Appearance()
              .setMaterial(new Material())))))
      .addChild(new Transform().setTranslation(-.5,1.0,-6.0)
        .addChild(new Billboard()
          .addChild(new Shape()
            .setGeometry(new Text().setString(new String[] {"6"})
              .setFontStyle(new FontStyle().setCssStyle("BOLD")))
            .setAppearance(new Appearance()
              .setMaterial(new Material("numberSix").setDiffuseColor(.4,.2,.2).setEmissiveColor(.4,0.0,0.0).setTransparency(1))))))
      .addChild(new Transform().setTranslation(.5,1.0,-6.0)
        .addChild(new Billboard()
          .addChild(new Shape()
            .setGeometry(new Text().setString(new String[] {"7"})
              .setFontStyle(new FontStyle().setCssStyle("BOLD")))
            .setAppearance(new Appearance()
              .setMaterial(new Material("numberSeven").setDiffuseColor(.2,.2,.4).setEmissiveColor(0.0,0.0,.4).setTransparency(1))))))
      .addChild(new Transform().setTranslation(1.5,1.0,-6.0)
        .addChild(new Billboard()
          .addChild(new Shape()
            .setGeometry(new Text().setString(new String[] {"8"})
              .setFontStyle(new FontStyle().setCssStyle("BOLD")))
            .setAppearance(new Appearance()
              .setMaterial(new Material("numberEight").setDiffuseColor(.2,.4,.2).setEmissiveColor(0.0,.4,0.0).setTransparency(1))))))
      .addChild(new TimeSensor("clock").setCycleInterval(2.0))
      .addChild(new TimeSensor("clock2").setCycleInterval(2.0))
      .addChild(new TimeSensor("clock3").setCycleInterval(2.0))
      .addChild(new PositionInterpolator("node_path").setKey(new double[] {0.0,.284}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,0.0})))
      .addChild(new PositionInterpolator("node_patha").setKey(new double[] {0.0,.284}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,4.0,0.0,0.0})))
      .addChild(new PositionInterpolator("node_path2").setKey(new double[] {0.0,.284}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("node_path2a").setKey(new double[] {0.0,.284}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("node_path3").setKey(new double[] {0.0,.284}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("node_path3a").setKey(new double[] {0.0,.284}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("node_path4").setKey(new double[] {.426,.71}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,0.0})))
      .addChild(new PositionInterpolator("node_path4a").setKey(new double[] {.426,.71}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,4.0,0.0,0.0})))
      .addChild(new PositionInterpolator("node_path5").setKey(new double[] {.426,.71}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("node_path5a").setKey(new double[] {.426,.71}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("node_path6").setKey(new double[] {.426,.71}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("node_path6a").setKey(new double[] {.426,.71}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("path2").setKey(new double[] {.142,.426}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,0.0})))
      .addChild(new PositionInterpolator("path2a").setKey(new double[] {.142,.426}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,4.0,0.0,0.0})))
      .addChild(new PositionInterpolator("path2_2").setKey(new double[] {.142,.426}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("path2_2a").setKey(new double[] {.142,.426}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("path2_3").setKey(new double[] {.142,.426}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("path2_3a").setKey(new double[] {.142,.426}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("path2_4").setKey(new double[] {.568,.852}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,0.0})))
      .addChild(new PositionInterpolator("path2_4a").setKey(new double[] {.568,.852}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,4.0,0.0,0.0})))
      .addChild(new PositionInterpolator("path2_5").setKey(new double[] {.568,.852}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("path2_5a").setKey(new double[] {.568,.852}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("path2_6").setKey(new double[] {.568,.852}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("path2_6a").setKey(new double[] {.568,.852}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("path3").setKey(new double[] {.284,.568}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,0.0})))
      .addChild(new PositionInterpolator("path3a").setKey(new double[] {.284,.568}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,4.0,0.0,0.0})))
      .addChild(new PositionInterpolator("path3_2").setKey(new double[] {.284,.568}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("path3_2a").setKey(new double[] {.284,.568}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("path3_3").setKey(new double[] {.284,.568}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("path3_3a").setKey(new double[] {.284,.568}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("path3_4").setKey(new double[] {.71,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,0.0})))
      .addChild(new PositionInterpolator("path3_4a").setKey(new double[] {.71,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,4.0,0.0,0.0})))
      .addChild(new PositionInterpolator("path3_5").setKey(new double[] {.71,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("path3_5a").setKey(new double[] {.71,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,2.0})))
      .addChild(new PositionInterpolator("path3_6").setKey(new double[] {.71,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,2.0,0.0,-2.0})))
      .addChild(new PositionInterpolator("path3_6a").setKey(new double[] {.71,1.0}).setKeyValue(new MFVec3f(new double[] {0.0,0.0,0.0,-2.0,0.0,-2.0})))
      .addChild(new Script("toggleScript1").setSourceCode("""
ecmascript:

function toggle ( value, ts ) {
 if(value == true){
   state = !state;
   toggleValue = state;
   }
   if(state){
      transState = 0;
      transparency = transState;
   }
   else{
      transState = 1;
      transparency = transState;
   }
}
""")
        .addField(new field().setName("toggle").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("state").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
        .addField(new field().setName("toggleValue").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("transState").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1))
        .addField(new field().setName("transparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY)))
      .addChild(new Script("toggleScript2").setSourceCode("""
ecmascript:

function toggle ( value, ts ) {
 if(value == true){
   state = !state;
   toggleValue = state;
   }
   if(state){
      transState = 0;
      transparency = transState;
   }
   else{
      transState = 1;
      transparency = transState;
   }
}
""")
        .addField(new field().setName("toggle").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("state").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
        .addField(new field().setName("toggleValue").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("transState").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1))
        .addField(new field().setName("transparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY)))
      .addChild(new Script("toggleScript3").setSourceCode("""
ecmascript:

function toggle ( value, ts ) {
 if(value == true){
   state = !state;
   toggleValue = state;
   }
   if(state){
      transState = 0;
      transparency = transState;
   }
   else{
      transState = 1;
      transparency = transState;
   }
}
""")
        .addField(new field().setName("toggle").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("state").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
        .addField(new field().setName("toggleValue").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("transState").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1))
        .addField(new field().setName("transparency").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))))
    .addChild(new ROUTE().setFromNode("primaryTouch").setFromField("isActive").setToNode("toggleScript1").setToField("toggle"))
    .addChild(new ROUTE().setFromNode("toggleScript1").setFromField("toggleValue").setToNode("clock").setToField("loop"))
    .addChild(new ROUTE().setFromNode("secondaryTouch").setFromField("isActive").setToNode("toggleScript2").setToField("toggle"))
    .addChild(new ROUTE().setFromNode("toggleScript2").setFromField("toggleValue").setToNode("clock2").setToField("loop"))
    .addChild(new ROUTE().setFromNode("tertiaryTouch").setFromField("isActive").setToNode("toggleScript3").setToField("toggle"))
    .addChild(new ROUTE().setFromNode("toggleScript3").setFromField("toggleValue").setToNode("clock3").setToField("loop"))
    .addChild(new ROUTE().setFromNode("toggleScript1").setFromField("transparency").setToNode("numberSix").setToField("transparency"))
    .addChild(new ROUTE().setFromNode("toggleScript2").setFromField("transparency").setToNode("numberSeven").setToField("transparency"))
    .addChild(new ROUTE().setFromNode("toggleScript3").setFromField("transparency").setToNode("numberEight").setToField("transparency"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_patha").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path2").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path2a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path3").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path3a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path4").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path4a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path5").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path5a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path6").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock").setFromField("fraction_changed").setToNode("node_path6a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2_2").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2_2a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2_3").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2_3a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2_4").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2_4a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2_5").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2_5a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2_6").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock2").setFromField("fraction_changed").setToNode("path2_6a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3_2").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3_2a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3_3").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3_3a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3_4").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3_4a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3_5").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3_5a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3_6").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("clock3").setFromField("fraction_changed").setToNode("path3_6a").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("node_path").setFromField("value_changed").setToNode("packet1_transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path4").setFromField("value_changed").setToNode("packet1_2transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path2").setFromField("value_changed").setToNode("packet2_transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path5").setFromField("value_changed").setToNode("packet2_2transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path3").setFromField("value_changed").setToNode("packet3_transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path6").setFromField("value_changed").setToNode("packet3_2transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path2").setFromField("value_changed").setToNode("packet4_transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path5").setFromField("value_changed").setToNode("packet4_2transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path3").setFromField("value_changed").setToNode("packet5_transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path6").setFromField("value_changed").setToNode("packet5_2transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path").setFromField("value_changed").setToNode("packet6_transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("node_path4").setFromField("value_changed").setToNode("packet6_2transmit").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2").setFromField("value_changed").setToNode("packet2_1").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_4").setFromField("value_changed").setToNode("packet2_1a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_2").setFromField("value_changed").setToNode("packet2_2").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_5").setFromField("value_changed").setToNode("packet2_2a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_3").setFromField("value_changed").setToNode("packet2_2").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_6").setFromField("value_changed").setToNode("packet2_2a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_2a").setFromField("value_changed").setToNode("packet2_3").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_5a").setFromField("value_changed").setToNode("packet2_3a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_4a").setFromField("value_changed").setToNode("packet2_3b2").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2a").setFromField("value_changed").setToNode("packet2_3b").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_3").setFromField("value_changed").setToNode("packet2_4").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_6").setFromField("value_changed").setToNode("packet2_4a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_3").setFromField("value_changed").setToNode("packet2_5").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_6").setFromField("value_changed").setToNode("packet2_5a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2").setFromField("value_changed").setToNode("packet2_6").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path2_4").setFromField("value_changed").setToNode("packet2_6a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3").setFromField("value_changed").setToNode("packet3_1").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_4").setFromField("value_changed").setToNode("packet3_1a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_3").setFromField("value_changed").setToNode("packet3_2").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_6").setFromField("value_changed").setToNode("packet3_2a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_3a").setFromField("value_changed").setToNode("packet3_3").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_6a").setFromField("value_changed").setToNode("packet3_3a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3a").setFromField("value_changed").setToNode("packet3_3b").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_4a").setFromField("value_changed").setToNode("packet3_3b2").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3a").setFromField("value_changed").setToNode("packet3_4").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_4a").setFromField("value_changed").setToNode("packet3_4a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_2a").setFromField("value_changed").setToNode("packet3_4b").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_5a").setFromField("value_changed").setToNode("packet3_4b2").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_2").setFromField("value_changed").setToNode("packet3_5").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_5").setFromField("value_changed").setToNode("packet3_5a").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3").setFromField("value_changed").setToNode("packet3_6").setToField("set_translation"))
    .addChild(new ROUTE().setFromNode("path3_4").setFromField("value_changed").setToNode("packet3_6a").setToField("set_translation")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return NetworkReroutingRoutes model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new NetworkReroutingRoutes().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Networking.NetworkReroutingRoutes\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Networking.NetworkReroutingRoutes self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Networking/NetworkReroutingRoutes_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Networking/NetworkReroutingRoutes_JavaExport.x3d"; 
                String filenameX3DV = "Networking/NetworkReroutingRoutes_JavaExport.x3dv"; 
                String filenameJSON = "Networking/NetworkReroutingRoutes_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
