/**
 *<p>
 *	Non-Uniform Rational B-Spline (NURBS) provide a parametric mathematical model for generating and representing
 *      smooth curves and surfaces.
 *</p>
 *<p>
 *	<a href="http://en.wikipedia.org/wiki/Nurbs" target="_blank">Non-Uniform Rational B-Spline (NURBS)</a>
 *	provide a convenient and efficient manner to generate curved lines and surfaces which can be smooth at any viewing distance. 
 *	Since these surfaces are generated parametrically, only a small amount of data need be provided for describing complex surfaces.
 *	These examples support the
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/components/nurbs.html" target="_blank">X3D NURBS component</a>.
 *</p>
 *
 *<p>
 *	These capabilities hold significant potential value for use by the
 *	<a href="https://www.web3d.org/working-groups/computer-aided-design-cad" target="_blank">Computer Aided Design (CAD)</a>
 *	and
 *	<a href="https://www.web3d.org/working-groups/medical" target="_blank">Medical</a>
 *	working groups.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS" target="_blank">X3D Basic: NURBS</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.NURBS;

