package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry2D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.NURBS.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Simple example demonstrating NURBS trimming contour content model. </p>
 <p> Related links: Catalog page <a href="../../../NURBS/TrimmingContourExampleIndex.html" target="_blank">TrimmingContourExample</a>,  source <a href="../../../NURBS/TrimmingContourExample.java">TrimmingContourExample.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/TrimmingContourExample.x3d">TrimmingContourExample.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Simple example demonstrating NURBS trimming contour content model. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Andrew Grieve, Vince Marchetti </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> contributor </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 16 October 2005 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/TrimmingContourExample.png">TrimmingContourExample.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/TrimmingContourExampleSideView.png">TrimmingContourExampleSideView.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/TrimmingContourExampleInstantReality.png">images/TrimmingContourExampleInstantReality.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/TrimmingContourExampleXj3d.png">images/TrimmingContourExampleXj3d.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> NURBS trimming contour </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/specifications/ISO-IEC-19775-X3DAbstractSpecification/Part01/components/nurbs.html#NurbsTrimmedSurface" target="_blank">https://www.web3d.org/x3d/specifications/ISO-IEC-19775-X3DAbstractSpecification/Part01/components/nurbs.html#NurbsTrimmedSurface</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/TrimmingContourExample.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/TrimmingContourExample.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Andrew Grieve, Vince Marchetti
 */

public class TrimmingContourExample
{
	/** Default constructor to create this object. */
	public TrimmingContourExample ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addComponent(new component().setName("NURBS").setLevel(4))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("TrimmingContourExample.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Simple example demonstrating NURBS trimming contour content model."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Andrew Grieve, Vince Marchetti"))
    .addMeta(new meta().setName(meta.NAME_CONTRIBUTOR).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("16 October 2005"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("TrimmingContourExample.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("TrimmingContourExampleSideView.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/TrimmingContourExampleInstantReality.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/TrimmingContourExampleXj3d.png"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("NURBS trimming contour"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/specifications/ISO-IEC-19775-X3DAbstractSpecification/Part01/components/nurbs.html#NurbsTrimmedSurface"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/TrimmingContourExample.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("TrimmingContourExample.x3d"))
    .addChild(new NavigationInfo().setType("\"EXAMINE\""))
    .addChild(new Background().setSkyColor(new MFColor(new double[] {1.0,1.0,1.0})))
    .addChild(new Transform().setScale(2.0,2.0,2.0)
      .addChild(new Viewpoint().setDescription("Overhead View").setCenterOfRotation(233.0,0.0,-135.0).setFieldOfView(0.16628).setOrientation(-1.0,-0.0,-0.0,1.57).setPosition(233.0,1500.0,-133.809998))
      .addChild(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(1.0,0.0,0.0).setEmissiveColor(0.0,1.0,0.0)))
        .setGeometry(new NurbsTrimmedSurface().setSolid(false).setUDimension(6).setUKnot(new double[] {0.00980377,0.00980377,0.00980377,0.00980377,0.5,0.5,0.990196,0.990196,0.990196,0.990196}).setUOrder(4).setVDimension(6).setVKnot(new double[] {0.00980377,0.00980377,0.00980377,0.00980377,0.5,0.5,0.990196,0.990196,0.990196,0.990196}).setVOrder(4)
          .setControlPoint(new Coordinate().setPoint(getCoordinate_6_24_point()))
          .addTrimmingContour(new Contour2D()
            .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.9901960784313720,0.0098039215686275,0.9901960784313720,0.9901960784313720,0.0098039215686275,0.9901960784313720,0.0098039215686275,0.0098039215686275,0.9901960784313720,0.0098039215686275})).setKnot(new double[] {0.0,0.0,0.25,0.5,0.75,1.0,1.0}).setOrder(2)))
          .addTrimmingContour(new Contour2D()
            .addChild(new ContourPolyline2D().setControlPoint(new MFVec2d(new double[] {.2,.2,.2,.6})))
            .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {.2,.6,.4,.4,.6,.6})).setKnot(new double[] {2.0,2.0,2.0,3.0,3.0,3.0}))
            .addChild(new ContourPolyline2D().setControlPoint(new MFVec2d(new double[] {.6,.6,.6,.2,.2,.2}))))
          .addTrimmingContour(new Contour2D()
            .addChild(new ContourPolyline2D().setControlPoint(new MFVec2d(new double[] {.75,.75,.85,.85,.95,.75,.75,.75}))))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Large attribute array: Coordinate point field, scene-graph level=6, element #24, 108 total numbers made up of 36 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_6_24_point()
		{
			MFVec3f Coordinate_6_24_point = new MFVec3f(new double[] {123.01589,0.00000,-70.25446,123.01589,0.00000,-91.89685,123.01589,30.00000,-113.53923,123.01589,40.00000,-156.82400,123.01589,20.00000,-178.46638,123.01589,0.00000,-200.10876,159.68731,0.00000,-70.25446,159.68731,0.00000,-91.89685,159.68731,0.00000,-113.53923,159.68731,0.00000,-156.82400,159.68731,0.00000,-178.46638,159.68731,16.00000,-200.10876,196.35873,0.00000,-70.25446,196.35873,0.00000,-91.89685,196.35873,21.00000,-113.53923,196.35873,0.00000,-156.82400,196.35873,24.00000,-178.46638,196.35873,28.00000,-200.10876,269.70158,16.00000,-70.25446,269.70158,0.00000,-91.89685,269.70158,0.00000,-113.53923,269.70158,0.00000,-156.82400,269.70158,0.00000,-178.46638,269.70158,0.00000,-200.10876,306.37300,0.00000,-70.25446,306.37300,0.00000,-91.89685,306.37300,0.00000,-113.53923,306.37300,34.00000,-156.82400,306.37300,0.00000,-178.46638,306.37300,0.00000,-200.10876,343.04443,0.00000,-70.25446,343.04443,0.00000,-91.89685,343.04443,-32.00000,-113.53923,343.04443,0.00000,-156.82400,343.04443,0.00000,-178.46638,343.04443,0.00000,-200.10876});
			return Coordinate_6_24_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return TrimmingContourExample model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new TrimmingContourExample().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.TrimmingContourExample\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.TrimmingContourExample self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/TrimmingContourExample_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/TrimmingContourExample_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/TrimmingContourExample_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/TrimmingContourExample_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
