package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry2D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Lighting.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.NURBS.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> A CAD model of a stamp with raised lettering. Model was created using commercial CAD package: Ashlar-Vellum Argon; exported as STEP AP 203 data, and converted to X3D file using the online STEP browser at http://spri2.kshell.com. Colors were applied using Python-Prolog scripting. </p>
 <p> Related links: Catalog page <a href="../../../NURBS/StampX3dLettersHalloweenIndex.html" target="_blank">StampX3dLettersHalloween</a>,  source <a href="../../../NURBS/StampX3dLettersHalloween.java">StampX3dLettersHalloween.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/StampX3dLettersHalloween.x3d">StampX3dLettersHalloween.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> A CAD model of a stamp with raised lettering. Model was created using commercial CAD package: Ashlar-Vellum Argon; exported as STEP AP 203 data, and converted to X3D file using the online STEP browser at <a href="http://spri2.kshell.com." target="_blank">http://spri2.kshell.com.</a> Colors were applied using Python-Prolog scripting. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/StampX3dLetters.jpg">StampX3dLetters.jpg</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="https://www.web3d.org/x3d/wiki/images/8/84/Halloween_X3D_Stamp.jpg" target="_blank">https://www.web3d.org/x3d/wiki/images/8/84/Halloween_X3D_Stamp.jpg</a> </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Currently only Octaga 2.0 properly implements the X3D NURBS component, see the following page for status. </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> <a href="http://www.kshell.com/pages/nurbs_surface_demo" target="_blank">http://www.kshell.com/pages/nurbs_surface_demo</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Vincent Marchetti </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 23 October 2012 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> purchase </i> </td>
			<td> <a href="http://www.shapeways.com/model/TODO-revision" target="_blank">http://www.shapeways.com/model/TODO-revision</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> purchase </i> </td>
			<td> <a href="http://www.shapeways.com/model/699293" target="_blank">http://www.shapeways.com/model/699293</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> AxesTexture.png </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Ashlar Vellum Argon; and SPRI browser: STEP-to-X3D conversion: at <a href="http://spri2.kshell.com" target="_blank">http://spri2.kshell.com</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://spri2.kshell.com/xt/shape/vbrqzndca5b7/shape_2333383432.x3d" target="_blank">http://spri2.kshell.com/xt/shape/vbrqzndca5b7/shape_2333383432.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/StampX3dLettersHalloween.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/StampX3dLettersHalloween.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Vincent Marchetti
 */

public class StampX3dLettersHalloween
{
	/** Default constructor to create this object. */
	public StampX3dLettersHalloween ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_2)
  .setHead(new head()
    .addComponent(new component().setName("NURBS").setLevel(4))
    .addComponent(new component().setName("Geometry2D").setLevel(2))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("StampX3dLettersHalloween.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("A CAD model of a stamp with raised lettering. Model was created using commercial CAD package: Ashlar-Vellum Argon; exported as STEP AP 203 data, and converted to X3D file using the online STEP browser at http://spri2.kshell.com. Colors were applied using Python-Prolog scripting."))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("StampX3dLetters.jpg"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("https://www.web3d.org/x3d/wiki/images/8/84/Halloween_X3D_Stamp.jpg"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("Currently only Octaga 2.0 properly implements the X3D NURBS component, see the following page for status."))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("http://www.kshell.com/pages/nurbs_surface_demo"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Vincent Marchetti"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("23 October 2012"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName("purchase").setContent("http://www.shapeways.com/model/TODO-revision"))
    .addMeta(new meta().setName("purchase").setContent("http://www.shapeways.com/model/699293"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("AxesTexture.png"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Ashlar Vellum Argon; and SPRI browser: STEP-to-X3D conversion: at http://spri2.kshell.com"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://spri2.kshell.com/xt/shape/vbrqzndca5b7/shape_2333383432.x3d"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/StampX3dLettersHalloween.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("StampX3dLettersHalloween.x3d"))
    .addChild(new Background().setSkyColor(new MFColor(new double[] {0.094100,0.137300,0.498000}))
      .setMetadata(new MetadataString().setName("color").setReference("http://www.colourlovers.com/color/18237F/tienen_miedo").setValue(new String[] {"tienen miedo"})))
    .addChild(new DirectionalLight().setColor(1.000000,1.000000,1.000000).setDirection(-3.5355e-01,-3.5355e-01,-8.6603e-01))
    .addChild(new Viewpoint().setDescription("Top").setCenterOfRotation(1.6129e+01,0.0000e+00,-1.8156e+02).setFieldOfView(1.6628e-01).setOrientation(1.000,0.000,0.000,0.000).setPosition(1.6129e+01,0.0000e+00,2.4267e+04))
    .addChild(new Viewpoint().setDescription("Bottom").setCenterOfRotation(1.6129e+01,0.0000e+00,-1.8156e+02).setFieldOfView(1.6628e-01).setOrientation(1.000,0.000,0.000,3.142).setPosition(1.6129e+01,-2.9939e-12,-2.4630e+04))
    .addChild(new Viewpoint().setDescription("Right side").setCenterOfRotation(1.6129e+01,0.0000e+00,-1.8156e+02).setFieldOfView(1.6628e-01).setOrientation(0.577,0.577,0.577,2.094).setPosition(2.4464e+04,-1.4970e-12,-1.8156e+02))
    .addChild(new Viewpoint().setDescription("Oblique view").setCenterOfRotation(1.6129e+01,0.0000e+00,-1.8156e+02).setFieldOfView(1.6628e-01).setOrientation(0.901,0.241,0.361,1.277).setPosition(1.1310e+04,-1.9561e+04,9.1743e+03))
    .addChild(new Group().setBboxCenter(16.129000,0.000000,-181.559505).setBboxSize(1967.738000,1290.320000,663.455628)
      .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3842'"}))
      .addChild(new Group().setBboxCenter(16.129000,0.000000,-181.559505).setBboxSize(1967.738000,1290.320000,663.455628)
        .setMetadata(new MetadataSet().setName("properties")
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3747'"}))
          .setMetadata(new MetadataString().setName("type").setValue(new String[] {"solid"})))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#117'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.695760990751,0.695760990751}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {7.7957e+02,-2.8629e+02,0.0000e+00,7.7957e+02,9.0415e+01,0.0000e+00,5.1747e+02,-2.8629e+02,0.0000e+00,5.1747e+02,9.0415e+01,0.0000e+00})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.9904e-01,5.5304e-01,9.9904e-01,6.9576e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.9904e-01,6.9576e-01,0.0000e+00,6.9576e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,6.9576e-01,0.0000e+00,4.6384e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,4.6384e-01,0.0000e+00,2.6760e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,2.6760e-01,5.2715e-03,2.4124e-01,1.3770e-02,2.1500e-01,3.7191e-02,1.6660e-01,5.2371e-02,1.4387e-01,7.1360e-02,1.2488e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0470843577,0.0470843577,0.0941071342,0.0941071342,0.0941071342,0.0941071342}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.1360e-02,1.2488e-01,8.1165e-02,1.1017e-01,9.3640e-02,9.7694e-02,1.3859e-01,6.3349e-02,1.7755e-01,4.7856e-02,2.1408e-01,3.5680e-02})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0309628243,0.0309628243,0.0991050899,0.0991050899,0.0991050899,0.0991050899}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.1408e-01,3.5680e-02,2.5690e-01,2.1408e-02,3.0134e-01,1.2511e-02,3.9100e-01,1.8212e-03,4.3649e-01,0.0000e+00,4.8168e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0790559921,0.0790559921,0.15818685,0.15818685,0.15818685,0.15818685}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.8168e-01,0.0000e+00,5.2988e-01,0.0000e+00,5.7838e-01,1.3539e-03,6.7405e-01,1.1578e-02,7.2150e-01,2.0472e-02,7.6712e-01,3.5680e-02})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0844331202,0.0844331202,0.168756009,0.168756009,0.168756009,0.168756009}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.6712e-01,3.5680e-02,7.9497e-01,4.6820e-02,8.2170e-01,6.1749e-02,8.6990e-01,9.7529e-02,8.9185e-01,1.1873e-01,9.0984e-01,1.4272e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0525426465,0.0525426465,0.10506833,0.10506833,0.10506833,0.10506833}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.0984e-01,1.4272e-01,9.2861e-01,1.6149e-01,9.4366e-01,1.8391e-01,9.6723e-01,2.3223e-01,9.7587e-01,2.5878e-01,9.8120e-01,2.8544e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0464937659,0.0464937659,0.09414025,0.09414025,0.09414025,0.09414025}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.8120e-01,2.8544e-01,9.9206e-01,3.2889e-01,9.9651e-01,3.7351e-01,1.0000e+00,4.6308e-01,9.9904e-01,5.0838e-01,9.9904e-01,5.5304e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.078459618,0.078459618,0.157110042,0.157110042,0.157110042,0.157110042}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))))
          .setAppearance(new Appearance("partcolor")
            .setMaterial(new Material().setDiffuseColor(0.410,0.324,0.324)
              .setMetadata(new MetadataString().setName("color").setReference("http://www.colourlovers.com/color/695353/dark_heart").setValue(new String[] {"dark heart"})))))
        .addChild(new Transform().setRotation(0.000,1.000,0.000,1.571).setTranslation(5.1747e+02,9.0054e+01,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#148'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-3.2258e+01,-3.7634e+02,0.0000e+00,-3.2258e+01,0.0000e+00,0.0000e+00,-1.8243e+02,0.0000e+00,0.0000e+00,-3.2258e+01,-3.7634e+02,0.0000e+00,-1.8243e+02,0.0000e+00,0.0000e+00,-1.8243e+02,-3.7634e+02,0.0000e+00}))))
            .setAppearance(new Appearance("D.appearance")
              .setMaterial(new Material().setDiffuseColor(0.785,0.590,0.0)
                .setMetadata(new MetadataString().setName("color").setReference("http://www.colourlovers.com/color/C99700/RubinBest").setValue(new String[] {"RubinBest"}))))))
        .addChild(new Transform().setRotation(-1.000,0.000,0.000,1.571).setTranslation(5.1747e+02,-2.8629e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#172'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {8.7365e+01,-3.2258e+01,0.0000e+00,0.0000e+00,-3.2258e+01,0.0000e+00,0.0000e+00,-1.8243e+02,0.0000e+00,8.7365e+01,-3.2258e+01,0.0000e+00,0.0000e+00,-1.8243e+02,0.0000e+00,8.7365e+01,-1.8243e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("D.appearance"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#201'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.114583373,-0.114583373,-0.114583373,-0.114583373,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {6.7876e+02,-2.8629e+02,-3.2258e+01,6.5412e+02,-2.8629e+02,-3.2258e+01,6.2948e+02,-2.8629e+02,-3.2258e+01,6.0484e+02,-2.8629e+02,-3.2258e+01,6.7876e+02,-2.8629e+02,1.5017e+02,6.5412e+02,-2.8629e+02,1.5017e+02,6.2948e+02,-2.8629e+02,1.5017e+02,6.0484e+02,-2.8629e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.1458e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.1458e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.1458e-01,2.8276e-01,-1.1458e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#230'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0931694235,-0.0931694235,-0.0931694235,-0.0931694235,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {7.3253e+02,-2.5941e+02,-3.2258e+01,7.1836e+02,-2.7358e+02,-3.2258e+01,6.9841e+02,-2.8236e+02,-3.2258e+01,6.7876e+02,-2.8629e+02,-3.2258e+01,7.3253e+02,-2.5941e+02,1.5017e+02,7.1836e+02,-2.7358e+02,1.5017e+02,6.9841e+02,-2.8236e+02,1.5017e+02,6.7876e+02,-2.8629e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.3169e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-9.3169e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.3169e-02,2.8276e-01,-9.3169e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#259'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0982706663,-0.0982706663,-0.0982706663,-0.0982706663,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {7.6613e+02,-2.0564e+02,-3.2258e+01,7.5944e+02,-2.2569e+02,-3.2258e+01,7.5011e+02,-2.4769e+02,-3.2258e+01,7.3253e+02,-2.5941e+02,-3.2258e+01,7.6613e+02,-2.0564e+02,1.5017e+02,7.5944e+02,-2.2569e+02,1.5017e+02,7.5011e+02,-2.4769e+02,1.5017e+02,7.3253e+02,-2.5941e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.8271e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-9.8271e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.8271e-02,2.8276e-01,-9.8271e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#288'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.157632776,-0.157632776,-0.157632776,-0.157632776,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {7.7957e+02,-1.0484e+02,-3.2258e+01,7.7957e+02,-1.3874e+02,-3.2258e+01,7.7685e+02,-1.7348e+02,-3.2258e+01,7.6613e+02,-2.0564e+02,-3.2258e+01,7.7957e+02,-1.0484e+02,1.5017e+02,7.7957e+02,-1.3874e+02,1.5017e+02,7.7685e+02,-1.7348e+02,1.5017e+02,7.6613e+02,-2.0564e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.5763e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.5763e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.5763e-01,2.8276e-01,-1.5763e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#317'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.167963702,-0.167963702,-0.167963702,-0.167963702,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {7.6613e+02,2.6882e+00,-3.2258e+01,7.7755e+02,-3.1579e+01,-3.2258e+01,7.7957e+02,-6.8717e+01,-3.2258e+01,7.7957e+02,-1.0484e+02,-3.2258e+01,7.6613e+02,2.6882e+00,1.5017e+02,7.7755e+02,-3.1579e+01,1.5017e+02,7.7957e+02,-6.8717e+01,1.5017e+02,7.7957e+02,-1.0484e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.6796e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.6796e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.6796e-01,2.8276e-01,-1.6796e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#346'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.104166665,-0.104166665,-0.104166665,-0.104166665,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {7.2580e+02,5.6451e+01,-3.2258e+01,7.4373e+02,4.3011e+01,-3.2258e+01,7.5781e+02,2.3487e+01,-3.2258e+01,7.6613e+02,2.6882e+00,-3.2258e+01,7.2580e+02,5.6451e+01,1.5017e+02,7.4373e+02,4.3011e+01,1.5017e+02,7.5781e+02,2.3487e+01,1.5017e+02,7.6613e+02,2.6882e+00,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.0417e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.0417e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.0417e-01,2.8276e-01,-1.0417e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#375'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0931695335,-0.0931695335,-0.0931695335,-0.0931695335,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {6.7204e+02,8.3333e+01,-3.2258e+01,6.9169e+02,7.9404e+01,-3.2258e+01,7.1164e+02,7.0619e+01,-3.2258e+01,7.2580e+02,5.6451e+01,-3.2258e+01,6.7204e+02,8.3333e+01,1.5017e+02,6.9169e+02,7.9404e+01,1.5017e+02,7.1164e+02,7.0619e+01,1.5017e+02,7.2580e+02,5.6451e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.3170e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-9.3170e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.3170e-02,2.8276e-01,-9.3170e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#404'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.156596778,-0.156596778,-0.156596778,-0.156596778,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {5.7124e+02,9.0054e+01,-3.2258e+01,6.0491e+02,9.0054e+01,-3.2258e+01,6.3937e+02,9.1501e+01,-3.2258e+01,6.7204e+02,8.3333e+01,-3.2258e+01,5.7124e+02,9.0054e+01,1.5017e+02,6.0491e+02,9.0054e+01,1.5017e+02,6.3937e+02,9.1501e+01,1.5017e+02,6.7204e+02,8.3333e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.5660e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.5660e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.5660e-01,2.8276e-01,-1.5660e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,1.571).setTranslation(5.7124e+02,9.0054e+01,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#421'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-5.3763e+01,3.2258e+01,0.0000e+00,0.0000e+00,3.2258e+01,0.0000e+00,0.0000e+00,1.8243e+02,0.0000e+00,-5.3763e+01,3.2258e+01,0.0000e+00,0.0000e+00,1.8243e+02,0.0000e+00,-5.3763e+01,1.8243e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("D.appearance"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#509'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,2.81250000272,2.81250000272}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-4.8387e+02,5.8064e+02,-5.1619e+01,-4.8387e+02,5.8064e+02,-4.6452e+02,-4.8387e+02,-5.8064e+02,-5.1619e+01,-4.8387e+02,-5.8064e+02,-4.6452e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.5172e-01,1.0022e-01,9.8922e-01,1.3658e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.8922e-01,1.3658e+00,9.5783e-01,1.3469e+00,9.8922e-01,1.4467e+00})).setKnot(new double[] {0.0,0.0,0.0,0.582913589,0.582913589,0.582913589}).setWeight(new double[] {1.0,0.957826285,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.8922e-01,1.4467e+00,6.5172e-01,2.7123e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.5172e-01,2.7123e+00,5.0143e-01,2.2564e+00,5.3200e-01,2.8125e+00})).setKnot(new double[] {0.0,0.0,0.0,1.27933953,1.27933953,1.27933953}).setWeight(new double[] {1.0,0.802292928,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.3200e-01,2.8125e+00,1.2500e-01,2.8125e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2500e-01,2.8125e+00,0.0000e+00,1.9887e+00,0.0000e+00,2.6719e+00})).setKnot(new double[] {0.0,0.0,0.0,1.57079633,1.57079633,1.57079633}).setWeight(new double[] {1.0,0.707106781,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,2.6719e+00,0.0000e+00,1.4063e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,1.4063e-01,0.0000e+00,0.0000e+00,1.2500e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,0.0,1.57079633,1.57079633,1.57079633}).setWeight(new double[] {1.0,0.707106781,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2500e-01,0.0000e+00,5.3200e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.3200e-01,0.0000e+00,5.0143e-01,0.0000e+00,6.5172e-01,1.0022e-01})).setKnot(new double[] {0.0,0.0,0.0,1.27933953,1.27933953,1.27933953}).setWeight(new double[] {1.0,0.802292928,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,0.000).setTranslation(-3.7893e+02,-1.0059e+02,1.5017e+02)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#613'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(getCoordinate_8_168_point())))
            .setAppearance(new Appearance("X.appearance")
              .setMaterial(new Material().setDiffuseColor(0.816,0.363,0.039)
                .setMetadata(new MetadataString().setName("color").setReference("http://www.colourlovers.com/color/D15D0A/delightful_pumpkin").setValue(new String[] {"delightful pumpkin"}))))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#870'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,1.52631573726,1.52631573726}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {3.0242e+02,1.9086e+02,1.5017e+02,-8.0645e+01,1.9086e+02,1.5017e+02,3.0242e+02,-3.9382e+02,1.5017e+02,-8.0645e+01,-3.9382e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.0175e-01,1.0351e+00,1.0000e+00,1.0702e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,1.0702e+00,9.8999e-01,1.1903e+00,9.4490e-01,1.3183e+00,8.5965e-01,1.4035e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.214745102,0.214745102,0.214745102,0.214745102}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.5965e-01,1.4035e+00,7.6639e-01,1.4851e+00,6.3269e-01,1.5263e+00,5.0877e-01,1.5263e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.220725202,0.220725202,0.220725202,0.220725202}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.0877e-01,1.5263e+00,3.8486e-01,1.5263e+00,2.5115e-01,1.4851e+00,1.5789e-01,1.4035e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.220725192,0.220725192,0.220725192,0.220725192}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.5789e-01,1.4035e+00,6.6004e-02,1.3218e+00,0.0000e+00,1.1931e+00,0.0000e+00,1.0702e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.218997893,0.218997893,0.218997893,0.218997893}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,1.0702e+00,0.0000e+00,9.8872e-01,3.0124e-02,8.9970e-01,8.7719e-02,8.4211e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.145087386,0.145087386,0.145087386,0.145087386}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.7719e-02,8.4211e-01,1.3973e-01,7.7969e-01,2.1782e-01,7.3079e-01,2.9825e-01,7.1930e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.144712961,0.144712961,0.144712961,0.144712961}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.9825e-01,7.1930e-01,1.8392e-01,6.5774e-01,7.0175e-02,5.3335e-01,7.0175e-02,4.0351e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.23128754,0.23128754,0.23128754,0.23128754}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.0175e-02,4.0351e-01,7.0175e-02,3.0903e-01,1.1395e-01,2.1208e-01,1.7544e-01,1.4035e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.168286407,0.168286407,0.168286407,0.168286407}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.7544e-01,1.4035e-01,2.6451e-01,5.1277e-02,4.0035e-01,0.0000e+00,5.2632e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.224381869,0.224381869,0.224381869,0.224381869}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.2632e-01,0.0000e+00,5.9865e-01,0.0000e+00,6.7214e-01,2.0282e-02,7.3684e-01,5.2632e-02})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.128847051,0.128847051,0.128847051,0.128847051}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.3684e-01,5.2632e-02,7.9983e-01,8.4124e-02,8.5851e-01,1.3260e-01,8.9474e-01,1.9298e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.125433264,0.125433264,0.125433264,0.125433264}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.9474e-01,1.9298e-01,9.3566e-01,2.6119e-01,9.5505e-01,3.4213e-01,9.6491e-01,4.2105e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.141681988,0.141681988,0.141681988,0.141681988}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.6491e-01,4.2105e-01,6.6667e-01,4.5614e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.6667e-01,4.5614e-01,6.6667e-01,4.0618e-01,6.4937e-01,3.5112e-01,6.1404e-01,3.1579e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0890000396,0.0890000396,0.0890000396,0.0890000396}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.1404e-01,3.1579e-01,5.9227e-01,2.8315e-01,5.4800e-01,2.6316e-01,5.0877e-01,2.6316e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.069877131,0.069877131,0.069877131,0.069877131}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.0877e-01,2.6316e-01,4.7467e-01,2.6316e-01,4.3997e-01,2.8742e-01,4.2105e-01,3.1579e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.060739078,0.060739078,0.060739078,0.060739078}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.2105e-01,3.1579e-01,3.8841e-01,3.3755e-01,3.6842e-01,3.8182e-01,3.6842e-01,4.2105e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0698771243,0.0698771243,0.0698771243,0.0698771243}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.6842e-01,4.2105e-01,3.6842e-01,4.7102e-01,3.8572e-01,5.2607e-01,4.2105e-01,5.6140e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0890000413,0.0890000413,0.0890000413,0.0890000413}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.2105e-01,5.6140e-01,4.5918e-01,5.9953e-01,5.2577e-01,6.0535e-01,5.7895e-01,5.9649e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0960369212,0.0960369212,0.0960369212,0.0960369212}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.7895e-01,5.9649e-01,5.9649e-01,8.5965e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.9649e-01,8.5965e-01,5.6572e-01,8.3913e-01,5.2821e-01,8.2456e-01,4.9123e-01,8.2456e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0658807807,0.0658807807,0.0658807807,0.0658807807}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.9123e-01,8.2456e-01,4.3892e-01,8.2456e-01,3.8226e-01,8.5289e-01,3.5088e-01,8.9474e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0931694968,0.0931694968,0.0931694968,0.0931694968}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.5088e-01,8.9474e-01,3.1165e-01,9.3397e-01,2.9825e-01,9.9715e-01,2.9825e-01,1.0526e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.098821191,0.098821191,0.098821191,0.098821191}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.9825e-01,1.0526e+00,2.9825e-01,1.1102e+00,3.2234e-01,1.1760e+00,3.6842e-01,1.2105e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.102592265,0.102592265,0.102592265,0.102592265}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.6842e-01,1.2105e+00,4.0375e-01,1.2459e+00,4.5881e-01,1.2632e+00,5.0877e-01,1.2632e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0890000344,0.0890000344,0.0890000344,0.0890000344}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.0877e-01,1.2632e+00,5.5874e-01,1.2632e+00,6.0915e-01,1.2405e+00,6.4912e-01,1.2105e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0890000413,0.0890000413,0.0890000413,0.0890000413}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.4912e-01,1.2105e+00,6.9229e-01,1.1674e+00,7.0175e-01,1.0961e+00,7.0175e-01,1.0351e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.108753213,0.108753213,0.108753213,0.108753213}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))))
          .setAppearance(new Appearance("three.appearance")
            .setMaterial(new Material().setDiffuseColor(0.875,0.773,0.605)
              .setMetadata(new MetadataString().setName("color").setReference("http://www.colourlovers.com/color/E0C69B/cinnamon").setValue(new String[] {"cinnamon"})))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#987'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,1.17808226497,1.17808226497}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {8.9382e+02,1.9086e+02,1.5017e+02,4.0323e+02,1.9086e+02,1.5017e+02,8.9382e+02,-3.8710e+02,1.5017e+02,4.0323e+02,-3.8710e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,1.1781e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,1.1781e+00,5.4795e-01,1.1781e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.4795e-01,1.1781e+00,4.7930e-01,1.1781e+00,4.1018e-01,1.1757e+00,3.4247e-01,1.1644e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.156596839,0.156596839,0.156596839,0.156596839}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.4247e-01,1.1644e+00,2.7934e-01,1.1407e+00,2.1703e-01,1.1106e+00,1.6438e-01,1.0685e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.153800215,0.153800215,0.153800215,0.153800215}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.6438e-01,1.0685e+00,1.0790e-01,1.0120e+00,6.6355e-02,9.3879e-01,4.1096e-02,8.6301e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.182217221,0.182217221,0.182217221,0.182217221}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.1096e-02,8.6301e-01,1.0256e-02,7.8077e-01,0.0000e+00,6.9057e-01,0.0000e+00,6.0274e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.200368604,0.200368604,0.200368604,0.200368604}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,6.0274e-01,0.0000e+00,5.1039e-01,8.6711e-03,4.1523e-01,4.1096e-02,3.2877e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.210664041,0.210664041,0.210664041,0.210664041}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.1096e-02,3.2877e-01,6.7780e-02,2.5761e-01,1.1065e-01,1.9072e-01,1.6438e-01,1.3699e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.173367881,0.173367881,0.173367881,0.173367881}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.6438e-01,1.3699e-01,2.0900e-01,8.3441e-02,2.7485e-01,4.4302e-02,3.4247e-01,2.7397e-02})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.159003487,0.159003487,0.159003487,0.159003487}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.4247e-01,2.7397e-02,4.1083e-01,5.2547e-05,4.8802e-01,0.0000e+00,5.6164e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.16796372,0.16796372,0.16796372,0.16796372}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.6164e-01,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.6712e-01,2.0548e-01,6.5753e-01,2.0548e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.5753e-01,2.0548e-01,5.8889e-01,2.0548e-01,5.1865e-01,2.0253e-01,4.5205e-01,2.1918e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.156596778,0.156596778,0.156596778,0.156596778}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.5205e-01,2.1918e-01,4.1201e-01,2.2719e-01,3.7134e-01,2.4509e-01,3.4247e-01,2.7397e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0931695335,0.0931695335,0.0931695335,0.0931695335}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.4247e-01,2.7397e-01,3.0594e-01,3.0137e-01,2.7723e-01,3.4117e-01,2.6027e-01,3.8356e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.104166665,0.104166665,0.104166665,0.104166665}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.6027e-01,3.8356e-01,2.3699e-01,4.5341e-01,2.3288e-01,5.2911e-01,2.3288e-01,6.0274e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.167963702,0.167963702,0.167963702,0.167963702}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.3288e-01,6.0274e-01,2.3288e-01,6.7184e-01,2.3842e-01,7.4267e-01,2.6027e-01,8.0822e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.157632776,0.157632776,0.157632776,0.157632776}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.6027e-01,8.0822e-01,2.7390e-01,8.4909e-01,2.9292e-01,8.9391e-01,3.2877e-01,9.1781e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0982706663,0.0982706663,0.0982706663,0.0982706663}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.2877e-01,9.1781e-01,3.5765e-01,9.4669e-01,3.9831e-01,9.6459e-01,4.3836e-01,9.7260e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0931694235,0.0931694235,0.0931694235,0.0931694235}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.3836e-01,9.7260e-01,4.8858e-01,9.7260e-01,5.3881e-01,9.7260e-01,5.8904e-01,9.7260e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.114583373,0.114583373,0.114583373,0.114583373}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.8904e-01,9.7260e-01,7.6712e-01,9.7260e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.6712e-01,9.7260e-01,7.6712e-01,2.0548e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1029'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(7).setUKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.288705871269,0.288705871269}).setVOrder(2).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0,1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-7.6792e+02,3.0886e+02,-4.2347e+02,-6.6504e+02,2.9974e+02,-3.6674e+02,-7.3566e+02,3.6473e+02,-4.2347e+02,-6.0917e+02,3.3200e+02,-3.6674e+02,-6.7115e+02,3.6473e+02,-4.2347e+02,-5.5329e+02,2.9974e+02,-3.6674e+02,-6.3889e+02,3.0886e+02,-4.2347e+02,-7.6792e+02,3.0886e+02,-3.6495e+02,-6.6504e+02,2.9974e+02,-3.1606e+02,-7.3566e+02,3.6473e+02,-3.6495e+02,-6.0917e+02,3.3200e+02,-3.1606e+02,-6.7115e+02,3.6473e+02,-3.6495e+02,-5.5329e+02,2.9974e+02,-3.1606e+02,-6.3889e+02,3.0886e+02,-3.6495e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,2.0382e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,2.0382e-01,8.3333e-01,2.4626e-01,6.6667e-01,2.7733e-01,5.8333e-01,2.8571e-01,5.0000e-01,2.8871e-01,4.1667e-01,2.8571e-01,3.3333e-01,2.7733e-01,1.6667e-01,2.4626e-01,0.0000e+00,2.0382e-01})).setKnot(new double[] {0.0,0.0,0.125,0.25,0.375,0.5,0.625,0.75,0.875,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,2.0382e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.6667e-01,4.7746e-02,2.5000e-01,6.7831e-02,3.3333e-01,8.2699e-02,4.1667e-01,9.2125e-02,5.0000e-01,9.5493e-02,5.8333e-01,9.2125e-02,6.6667e-01,8.2699e-02,7.5000e-01,6.7831e-02,8.3333e-01,4.7746e-02,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1042'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(7).setUKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.299316200863,0.299316200863}).setVOrder(2).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0,1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-6.3889e+02,3.0886e+02,-4.4282e+02,-5.5329e+02,2.3522e+02,-3.8350e+02,-6.7115e+02,2.5299e+02,-4.4282e+02,-6.0917e+02,2.0297e+02,-3.8350e+02,-7.3566e+02,2.5299e+02,-4.4282e+02,-6.6504e+02,2.3522e+02,-3.8350e+02,-7.6792e+02,3.0886e+02,-4.4282e+02,-6.3889e+02,3.0886e+02,-3.8216e+02,-5.5329e+02,2.3522e+02,-3.3096e+02,-6.7115e+02,2.5299e+02,-3.8216e+02,-6.0917e+02,2.0297e+02,-3.3096e+02,-7.3566e+02,2.5299e+02,-3.8216e+02,-6.6504e+02,2.3522e+02,-3.3096e+02,-7.6792e+02,3.0886e+02,-3.8216e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.0000e-01,2.1443e-01,4.3934e-01,2.1603e-01,3.7627e-01,2.2089e-01,2.4856e-01,2.3930e-01,0.0000e+00,2.9932e-01})).setKnot(new double[] {0.0,0.0,0.25,0.5,0.75,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,2.9932e-01,0.0000e+00,9.5493e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,9.5493e-02,1.6667e-01,4.7746e-02,2.5000e-01,2.7662e-02,3.3333e-01,1.2794e-02,4.1667e-01,3.3676e-03,5.0000e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,0.2,0.4,0.6,0.8,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.0000e-01,0.0000e+00,5.8333e-01,3.3676e-03,6.6667e-01,1.2794e-02,7.5000e-01,2.7662e-02,8.3333e-01,4.7746e-02,1.0000e+00,9.5493e-02})).setKnot(new double[] {0.0,0.0,0.2,0.4,0.6,0.8,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,9.5493e-02,1.0000e+00,2.9932e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,2.9932e-01,7.5144e-01,2.3930e-01,6.2373e-01,2.2089e-01,5.6066e-01,2.1603e-01,5.0000e-01,2.1443e-01})).setKnot(new double[] {0.0,0.0,0.25,0.5,0.75,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1130'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,2.81250000272,2.81250000272}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {5.1613e+02,5.8064e+02,-4.6452e+02,5.1613e+02,5.8064e+02,-5.1619e+01,5.1613e+02,-5.8064e+02,-4.6452e+02,5.1613e+02,-5.8064e+02,-5.1619e+01})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.4828e-01,1.0022e-01,3.0086e-01,0.0000e+00,4.6800e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,0.0,1.27933953,1.27933953,1.27933953}).setWeight(new double[] {1.0,0.802292928,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.6800e-01,0.0000e+00,8.7500e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.7500e-01,0.0000e+00,7.0711e-01,0.0000e+00,1.0000e+00,1.4063e-01})).setKnot(new double[] {0.0,0.0,0.0,1.57079633,1.57079633,1.57079633}).setWeight(new double[] {1.0,0.707106781,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,1.4063e-01,1.0000e+00,2.6719e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,2.6719e+00,7.0711e-01,1.9887e+00,8.7500e-01,2.8125e+00})).setKnot(new double[] {0.0,0.0,0.0,1.57079633,1.57079633,1.57079633}).setWeight(new double[] {1.0,0.707106781,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.7500e-01,2.8125e+00,4.6800e-01,2.8125e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.6800e-01,2.8125e+00,3.0086e-01,2.2564e+00,3.4828e-01,2.7123e+00})).setKnot(new double[] {0.0,0.0,0.0,1.27933953,1.27933953,1.27933953}).setWeight(new double[] {1.0,0.802292928,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.4828e-01,2.7123e+00,1.0776e-02,1.4467e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0776e-02,1.4467e+00,0.0000e+00,1.3469e+00,1.0776e-02,1.3658e+00})).setKnot(new double[] {0.0,0.0,0.0,0.582913589,0.582913589,0.582913589}).setWeight(new double[] {1.0,0.957826285,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0776e-02,1.3658e+00,3.4828e-01,1.0022e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1163'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,0.582913589,0.582913589,0.582913589}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.75,0.75}).setVOrder(2).setWeight(new double[] {1.0,0.957826285,1.0,1.0,0.957826285,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-9.6774e+02,1.6685e+01,-4.6007e+02,-9.2693e+02,-1.3721e-13,-4.4493e+02,-9.6774e+02,-1.6685e+01,-4.6007e+02,-4.8387e+02,1.6685e+01,-4.6007e+02,-4.6346e+02,-1.3721e-13,-4.4493e+02,-4.8387e+02,-1.6685e+01,-4.6007e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.8291e-01,7.5000e-01,0.0000e+00,7.5000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,7.5000e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,5.8291e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.8291e-01,0.0000e+00,5.8291e-01,7.5000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(-1.000,0.000,0.000,0.261).setTranslation(-9.6774e+02,-1.6685e+01,-4.6007e+02)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1187'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {4.8387e+02,-5.4084e+02,0.0000e+00,4.8387e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,4.8387e+02,-5.4084e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,-5.4084e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1213'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.27933953,1.27933953,1.27933953}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.75,0.75}).setVOrder(2).setWeight(new double[] {1.0,0.802292928,1.0,1.0,0.802292928,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-9.6774e+02,-5.3926e+02,-3.2072e+02,-7.7641e+02,-4.6585e+02,-2.4846e+02,-9.6774e+02,-5.8064e+02,-2.7128e+02,-4.8387e+02,-5.3926e+02,-3.2072e+02,-3.8821e+02,-4.6585e+02,-2.4846e+02,-4.8387e+02,-5.8064e+02,-2.7128e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2793e+00,7.5000e-01,0.0000e+00,7.5000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,7.5000e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.2793e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2793e+00,0.0000e+00,1.2793e+00,7.5000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(-1.000,0.000,0.000,1.571).setTranslation(-9.6774e+02,-5.8064e+02,-2.7128e+02)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1237'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {4.8387e+02,-1.6805e+02,0.0000e+00,4.8387e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,4.8387e+02,-1.6805e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,-1.6805e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1263'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.57079633,1.57079633,1.57079633}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.75,0.75}).setVOrder(2).setWeight(new double[] {1.0,0.707106781,1.0,1.0,0.707106781,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-9.6774e+02,-5.8064e+02,-1.0323e+02,-6.8430e+02,-4.1058e+02,-3.6500e+01,-9.6774e+02,-5.2258e+02,-5.1619e+01,-4.8387e+02,-5.8064e+02,-1.0323e+02,-3.4215e+02,-4.1058e+02,-3.6500e+01,-4.8387e+02,-5.2258e+02,-5.1619e+01})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.5708e+00,7.5000e-01,0.0000e+00,7.5000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,7.5000e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.5708e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.5708e+00,0.0000e+00,1.5708e+00,7.5000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1302'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.462962962963,0.462962962963}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-4.8387e+02,5.2258e+02,-5.1619e+01,-4.8387e+02,-5.2258e+02,-5.1619e+01,-9.6774e+02,5.2258e+02,-5.1619e+01,-9.6774e+02,-5.2258e+02,-5.1619e+01})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,4.6296e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,4.6296e-01,0.0000e+00,4.6296e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,4.6296e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.0448e-01,1.4832e-01,1.4622e-01,1.2845e-01,1.5103e-01,1.7918e-01,1.1536e-01,1.8191e-01,1.5103e-01,2.4091e-01,1.4622e-01,2.3537e-01,2.0448e-01,2.7178e-01})).setKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.0448e-01,2.7178e-01,2.0795e-01,2.3537e-01,2.5794e-01,2.4091e-01,2.3882e-01,1.8191e-01,2.5794e-01,1.7918e-01,2.0795e-01,1.2845e-01,2.0448e-01,1.4832e-01})).setKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1328'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.57079633,1.57079633,1.57079633}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.75,0.75}).setVOrder(2).setWeight(new double[] {1.0,0.707106781,1.0,1.0,0.707106781,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-9.6774e+02,5.2258e+02,-5.1619e+01,-6.8430e+02,4.1058e+02,-3.6500e+01,-9.6774e+02,5.8064e+02,-1.0323e+02,-4.8387e+02,5.2258e+02,-5.1619e+01,-3.4215e+02,4.1058e+02,-3.6500e+01,-4.8387e+02,5.8064e+02,-1.0323e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.5708e+00,7.5000e-01,0.0000e+00,7.5000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,7.5000e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.5708e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.5708e+00,0.0000e+00,1.5708e+00,7.5000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,1.571).setTranslation(-9.6774e+02,5.8064e+02,-1.0323e+02)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1352'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {4.8387e+02,-1.6805e+02,0.0000e+00,4.8387e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,4.8387e+02,-1.6805e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,-1.6805e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1378'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.27933953,1.27933953,1.27933953}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.75,0.75}).setVOrder(2).setWeight(new double[] {1.0,0.802292928,1.0,1.0,0.802292928,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-9.6774e+02,5.8064e+02,-2.7128e+02,-7.7641e+02,4.6585e+02,-2.4846e+02,-9.6774e+02,5.3926e+02,-3.2072e+02,-4.8387e+02,5.8064e+02,-2.7128e+02,-3.8821e+02,4.6585e+02,-2.4846e+02,-4.8387e+02,5.3926e+02,-3.2072e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2793e+00,7.5000e-01,0.0000e+00,7.5000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,7.5000e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.2793e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2793e+00,0.0000e+00,1.2793e+00,7.5000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1400'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.894661980473,0.894661980473}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-4.8387e+02,1.6685e+01,-4.6007e+02,-4.8387e+02,5.3926e+02,-3.2072e+02,-9.6774e+02,1.6685e+01,-4.6007e+02,-9.6774e+02,5.3926e+02,-3.2072e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.9466e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.9466e-01,0.0000e+00,8.9466e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.9466e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.5910e-01,2.8662e-01,4.6930e-01,2.6481e-01,4.7181e-01,3.2156e-01,4.0248e-01,3.2936e-01,4.3565e-01,4.0591e-01})).setKnot(new double[] {0.0,0.0,0.0,0.5,0.5,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.923879532511,1.0,0.923879532511,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.3565e-01,4.0591e-01,4.0248e-01,4.2066e-01,4.7181e-01,4.9026e-01,4.6930e-01,4.8522e-01,5.5910e-01,5.2520e-01})).setKnot(new double[] {0.0,0.0,0.0,0.5,0.5,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.923879532511,1.0,0.923879532511,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.5910e-01,5.2520e-01,5.4593e-01,4.5484e-01,6.6602e-01,4.6556e-01,6.0765e-01,3.5153e-01,6.6602e-01,3.4627e-01,5.4593e-01,2.4822e-01,5.5910e-01,2.8662e-01})).setKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(0.568,0.823,0.000,1.571).setTranslation(-3.7634e+02,-1.9220e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1431'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.6096e+02,-1.7658e+02,0.0000e+00,-2.6555e+01,1.8314e+01,0.0000e+00,-1.5018e+02,1.0357e+02,0.0000e+00,-1.6096e+02,-1.7658e+02,0.0000e+00,-1.5018e+02,1.0357e+02,0.0000e+00,-2.8458e+02,-9.1323e+01,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(0.548,-0.836,0.000,1.571).setTranslation(-2.4866e+02,-3.8710e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1455'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.0071e+02,2.1257e+02,0.0000e+00,2.6983e+01,1.7678e+01,0.0000e+00,1.5259e+02,9.9974e+01,0.0000e+00,-1.0071e+02,2.1257e+02,0.0000e+00,1.5259e+02,9.9974e+01,0.0000e+00,2.4905e+01,2.9487e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,1.571).setTranslation(-1.1425e+02,-3.8710e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1479'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.3441e+02,3.2258e+01,0.0000e+00,0.0000e+00,3.2258e+01,0.0000e+00,0.0000e+00,1.8243e+02,0.0000e+00,-1.3441e+02,3.2258e+01,0.0000e+00,0.0000e+00,1.8243e+02,0.0000e+00,-1.3441e+02,1.8243e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(-0.542,0.841,0.000,1.571).setTranslation(-3.0914e+02,-8.4677e+01,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1503'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {1.6778e+02,-3.1989e+02,0.0000e+00,-2.7115e+01,-1.7474e+01,0.0000e+00,-1.5334e+02,-9.8821e+01,0.0000e+00,1.6778e+02,-3.1989e+02,0.0000e+00,-1.5334e+02,-9.8821e+01,0.0000e+00,4.1550e+01,-4.0124e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(0.536,0.845,0.000,1.571).setTranslation(-1.3441e+02,1.9086e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1527'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-2.0197e+02,-2.5826e+02,0.0000e+00,-2.7242e+01,1.7276e+01,0.0000e+00,-1.5406e+02,9.7697e+01,0.0000e+00,-2.0197e+02,-2.5826e+02,0.0000e+00,-1.5406e+02,9.7697e+01,0.0000e+00,-3.2879e+02,-1.7784e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(-1.000,0.000,0.000,1.571).setTranslation(-2.6882e+02,1.9086e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1551'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {1.3441e+02,-3.2258e+01,0.0000e+00,0.0000e+00,-3.2258e+01,0.0000e+00,0.0000e+00,-1.8243e+02,0.0000e+00,1.3441e+02,-3.2258e+01,0.0000e+00,0.0000e+00,-1.8243e+02,0.0000e+00,1.3441e+02,-1.8243e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(-0.524,-0.852,0.000,1.571).setTranslation(-3.7634e+02,1.6129e+01,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1575'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {1.3500e+02,1.5782e+02,0.0000e+00,2.7473e+01,-1.6906e+01,0.0000e+00,1.5536e+02,-9.5609e+01,0.0000e+00,1.3500e+02,1.5782e+02,0.0000e+00,1.5536e+02,-9.5609e+01,0.0000e+00,2.6289e+02,7.9122e+01,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(-0.547,0.837,0.000,1.571).setTranslation(-4.9059e+02,1.9086e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1599'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {8.7248e+01,-1.9238e+02,0.0000e+00,-2.6999e+01,-1.7653e+01,0.0000e+00,-1.5269e+02,-9.9833e+01,0.0000e+00,8.7248e+01,-1.9238e+02,0.0000e+00,-1.5269e+02,-9.9833e+01,0.0000e+00,-3.8438e+01,-2.7456e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(-1.000,0.000,0.000,1.571).setTranslation(-6.2500e+02,1.9086e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1623'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {1.3441e+02,-3.2258e+01,0.0000e+00,0.0000e+00,-3.2258e+01,0.0000e+00,0.0000e+00,-1.8243e+02,0.0000e+00,1.3441e+02,-3.2258e+01,0.0000e+00,0.0000e+00,-1.8243e+02,0.0000e+00,1.3441e+02,-1.8243e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(0.550,-0.835,0.000,1.571).setTranslation(-4.4355e+02,-8.4677e+01,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1647'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.5451e+02,2.9328e+02,0.0000e+00,2.6941e+01,1.7742e+01,0.0000e+00,1.5236e+02,1.0033e+02,0.0000e+00,-1.5451e+02,2.9328e+02,0.0000e+00,1.5236e+02,1.0033e+02,0.0000e+00,-2.9094e+01,3.7587e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(-0.555,-0.832,0.000,1.571).setTranslation(-6.4516e+02,-3.8710e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1671'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {2.2845e+02,2.8453e+02,0.0000e+00,2.6840e+01,-1.7894e+01,0.0000e+00,1.5179e+02,-1.0119e+02,0.0000e+00,2.2845e+02,2.8453e+02,0.0000e+00,1.5179e+02,-1.0119e+02,0.0000e+00,3.5340e+02,2.0123e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,1.571).setTranslation(-5.1075e+02,-3.8710e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1688'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.3441e+02,3.2258e+01,0.0000e+00,0.0000e+00,3.2258e+01,0.0000e+00,0.0000e+00,1.8243e+02,0.0000e+00,-1.3441e+02,3.2258e+01,0.0000e+00,0.0000e+00,1.8243e+02,0.0000e+00,-1.3441e+02,1.8243e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("X.appearance"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1726'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.214745102,-0.214745102,-0.214745102,-0.214745102,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-8.0645e+01,-2.1909e+02,-3.2258e+01,-7.6810e+01,-2.6511e+02,-3.2258e+01,-5.9537e+01,-3.1412e+02,-3.2258e+01,-2.6882e+01,-3.4677e+02,-3.2258e+01,-8.0645e+01,-2.1909e+02,1.5017e+02,-7.6810e+01,-2.6511e+02,1.5017e+02,-5.9537e+01,-3.1412e+02,1.5017e+02,-2.6882e+01,-3.4677e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.1475e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-2.1475e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.1475e-01,2.8276e-01,-2.1475e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1757'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.220725202,-0.220725202,-0.220725202,-0.220725202,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-2.6882e+01,-3.4677e+02,-3.2258e+01,8.8414e+00,-3.7803e+02,-3.2258e+01,6.0059e+01,-3.9382e+02,-3.2258e+01,1.0753e+02,-3.9382e+02,-3.2258e+01,-2.6882e+01,-3.4677e+02,1.5017e+02,8.8414e+00,-3.7803e+02,1.5017e+02,6.0059e+01,-3.9382e+02,1.5017e+02,1.0753e+02,-3.9382e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.2073e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-2.2073e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.2073e-01,2.8276e-01,-2.2073e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1788'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.220725192,-0.220725192,-0.220725192,-0.220725192,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.0753e+02,-3.9382e+02,-3.2258e+01,1.5499e+02,-3.9382e+02,-3.2258e+01,2.0621e+02,-3.7803e+02,-3.2258e+01,2.4194e+02,-3.4677e+02,-3.2258e+01,1.0753e+02,-3.9382e+02,1.5017e+02,1.5499e+02,-3.9382e+02,1.5017e+02,2.0621e+02,-3.7803e+02,1.5017e+02,2.4194e+02,-3.4677e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.2073e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-2.2073e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.2073e-01,2.8276e-01,-2.2073e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1821'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.218997893,-0.218997893,-0.218997893,-0.218997893,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {2.4194e+02,-3.4677e+02,-3.2258e+01,2.7714e+02,-3.1548e+02,-3.2258e+01,3.0242e+02,-2.6618e+02,-3.2258e+01,3.0242e+02,-2.1909e+02,-3.2258e+01,2.4194e+02,-3.4677e+02,1.5017e+02,2.7714e+02,-3.1548e+02,1.5017e+02,3.0242e+02,-2.6618e+02,1.5017e+02,3.0242e+02,-2.1909e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.1900e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-2.1900e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.1900e-01,2.8276e-01,-2.1900e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1854'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.145087386,-0.145087386,-0.145087386,-0.145087386,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {3.0242e+02,-2.1909e+02,-3.2258e+01,3.0242e+02,-1.8788e+02,-3.2258e+01,2.9088e+02,-1.5378e+02,-3.2258e+01,2.6882e+02,-1.3172e+02,-3.2258e+01,3.0242e+02,-2.1909e+02,1.5017e+02,3.0242e+02,-1.8788e+02,1.5017e+02,2.9088e+02,-1.5378e+02,1.5017e+02,2.6882e+02,-1.3172e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.4509e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.4509e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.4509e-01,2.8276e-01,-1.4509e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1885'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.144712961,-0.144712961,-0.144712961,-0.144712961,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {2.6882e+02,-1.3172e+02,-3.2258e+01,2.4889e+02,-1.0781e+02,-3.2258e+01,2.1898e+02,-8.9078e+01,-3.2258e+01,1.8817e+02,-8.4677e+01,-3.2258e+01,2.6882e+02,-1.3172e+02,1.5017e+02,2.4889e+02,-1.0781e+02,1.5017e+02,2.1898e+02,-8.9078e+01,1.5017e+02,1.8817e+02,-8.4677e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.4471e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.4471e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.4471e-01,2.8276e-01,-1.4471e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1920'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.23128754,-0.23128754,-0.23128754,-0.23128754,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.8817e+02,-8.4677e+01,-3.2258e+01,2.3197e+02,-6.1096e+01,-3.2258e+01,2.7554e+02,-1.3449e+01,-3.2258e+01,2.7554e+02,3.6290e+01,-3.2258e+01,1.8817e+02,-8.4677e+01,1.5017e+02,2.3197e+02,-6.1096e+01,1.5017e+02,2.7554e+02,-1.3449e+01,1.5017e+02,2.7554e+02,3.6290e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.3129e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-2.3129e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.3129e-01,2.8276e-01,-2.3129e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1951'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.168286407,-0.168286407,-0.168286407,-0.168286407,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {2.7554e+02,3.6290e+01,-3.2258e+01,2.7554e+02,7.2481e+01,-3.2258e+01,2.5877e+02,1.0962e+02,-3.2258e+01,2.3521e+02,1.3710e+02,-3.2258e+01,2.7554e+02,3.6290e+01,1.5017e+02,2.7554e+02,7.2481e+01,1.5017e+02,2.5877e+02,1.0962e+02,1.5017e+02,2.3521e+02,1.3710e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.6829e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.6829e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.6829e-01,2.8276e-01,-1.6829e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#1984'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.224381869,-0.224381869,-0.224381869,-0.224381869,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {2.3521e+02,1.3710e+02,-3.2258e+01,2.0109e+02,1.7122e+02,-3.2258e+01,1.4906e+02,1.9086e+02,-3.2258e+01,1.0081e+02,1.9086e+02,-3.2258e+01,2.3521e+02,1.3710e+02,1.5017e+02,2.0109e+02,1.7122e+02,1.5017e+02,1.4906e+02,1.9086e+02,1.5017e+02,1.0081e+02,1.9086e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.2438e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-2.2438e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.2438e-01,2.8276e-01,-2.2438e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2015'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.128847051,-0.128847051,-0.128847051,-0.128847051,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.0081e+02,1.9086e+02,-3.2258e+01,7.3097e+01,1.9086e+02,-3.2258e+01,4.4945e+01,1.8309e+02,-3.2258e+01,2.0161e+01,1.7070e+02,-3.2258e+01,1.0081e+02,1.9086e+02,1.5017e+02,7.3097e+01,1.9086e+02,1.5017e+02,4.4945e+01,1.8309e+02,1.5017e+02,2.0161e+01,1.7070e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.2885e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.2885e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.2885e-01,2.8276e-01,-1.2885e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2046'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.125433264,-0.125433264,-0.125433264,-0.125433264,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {2.0161e+01,1.7070e+02,-3.2258e+01,-3.9658e+00,1.5864e+02,-3.2258e+01,-2.6444e+01,1.4007e+02,-3.2258e+01,-4.0322e+01,1.1694e+02,-3.2258e+01,2.0161e+01,1.7070e+02,1.5017e+02,-3.9658e+00,1.5864e+02,1.5017e+02,-2.6444e+01,1.4007e+02,1.5017e+02,-4.0322e+01,1.1694e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.2543e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.2543e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.2543e-01,2.8276e-01,-1.2543e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2077'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.141681988,-0.141681988,-0.141681988,-0.141681988,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-4.0322e+01,1.1694e+02,-3.2258e+01,-5.5999e+01,9.0808e+01,-3.2258e+01,-6.3425e+01,5.9804e+01,-3.2258e+01,-6.7204e+01,2.9570e+01,-3.2258e+01,-4.0322e+01,1.1694e+02,1.5017e+02,-5.5999e+01,9.0808e+01,1.5017e+02,-6.3425e+01,5.9804e+01,1.5017e+02,-6.7204e+01,2.9570e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.4168e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.4168e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.4168e-01,2.8276e-01,-1.4168e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Transform().setRotation(0.993,-0.117,0.000,1.571).setTranslation(4.7043e+01,1.6129e+01,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2101'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.1048e+02,4.5478e+01,0.0000e+00,3.7691e+00,3.2037e+01,0.0000e+00,2.1315e+01,1.8118e+02,0.0000e+00,-1.1048e+02,4.5478e+01,0.0000e+00,2.1315e+01,1.8118e+02,0.0000e+00,-9.2932e+01,1.9462e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("three.appearance"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2134'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0890000396,-0.0890000396,-0.0890000396,-0.0890000396,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {4.7043e+01,1.6129e+01,-3.2258e+01,4.7043e+01,3.5269e+01,-3.2258e+01,5.3670e+01,5.6358e+01,-3.2258e+01,6.7204e+01,6.9892e+01,-3.2258e+01,4.7043e+01,1.6129e+01,1.5017e+02,4.7043e+01,3.5269e+01,1.5017e+02,5.3670e+01,5.6358e+01,1.5017e+02,6.7204e+01,6.9892e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-8.9000e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-8.9000e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-8.9000e-02,2.8276e-01,-8.9000e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2167'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.069877131,-0.069877131,-0.069877131,-0.069877131,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {6.7204e+01,6.9892e+01,-3.2258e+01,7.5540e+01,8.2396e+01,-3.2258e+01,9.2499e+01,9.0054e+01,-3.2258e+01,1.0753e+02,9.0054e+01,-3.2258e+01,6.7204e+01,6.9892e+01,1.5017e+02,7.5540e+01,8.2396e+01,1.5017e+02,9.2499e+01,9.0054e+01,1.5017e+02,1.0753e+02,9.0054e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-6.9877e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-6.9877e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-6.9877e-02,2.8276e-01,-6.9877e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2200'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.060739078,-0.060739078,-0.060739078,-0.060739078,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.0753e+02,9.0054e+01,-3.2258e+01,1.2059e+02,9.0054e+01,-3.2258e+01,1.3388e+02,8.0761e+01,-3.2258e+01,1.4113e+02,6.9892e+01,-3.2258e+01,1.0753e+02,9.0054e+01,1.5017e+02,1.2059e+02,9.0054e+01,1.5017e+02,1.3388e+02,8.0761e+01,1.5017e+02,1.4113e+02,6.9892e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-6.0739e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-6.0739e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-6.0739e-02,2.8276e-01,-6.0739e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2233'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0698771243,-0.0698771243,-0.0698771243,-0.0698771243,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.4113e+02,6.9892e+01,-3.2258e+01,1.5363e+02,6.1557e+01,-3.2258e+01,1.6129e+02,4.4597e+01,-3.2258e+01,1.6129e+02,2.9570e+01,-3.2258e+01,1.4113e+02,6.9892e+01,1.5017e+02,1.5363e+02,6.1557e+01,1.5017e+02,1.6129e+02,4.4597e+01,1.5017e+02,1.6129e+02,2.9570e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-6.9877e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-6.9877e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-6.9877e-02,2.8276e-01,-6.9877e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2266'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0890000413,-0.0890000413,-0.0890000413,-0.0890000413,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.6129e+02,2.9570e+01,-3.2258e+01,1.6129e+02,1.0430e+01,-3.2258e+01,1.5466e+02,-1.0660e+01,-3.2258e+01,1.4113e+02,-2.4194e+01,-3.2258e+01,1.6129e+02,2.9570e+01,1.5017e+02,1.6129e+02,1.0430e+01,1.5017e+02,1.5466e+02,-1.0660e+01,1.5017e+02,1.4113e+02,-2.4194e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-8.9000e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-8.9000e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-8.9000e-02,2.8276e-01,-8.9000e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2299'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0960369212,-0.0960369212,-0.0960369212,-0.0960369212,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.4113e+02,-2.4194e+01,-3.2258e+01,1.2652e+02,-3.8797e+01,-3.2258e+01,1.0102e+02,-4.1030e+01,-3.2258e+01,8.0645e+01,-3.7634e+01,-3.2258e+01,1.4113e+02,-2.4194e+01,1.5017e+02,1.2652e+02,-3.8797e+01,1.5017e+02,1.0102e+02,-4.1030e+01,1.5017e+02,8.0645e+01,-3.7634e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.6037e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-9.6037e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.6037e-02,2.8276e-01,-9.6037e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Transform().setRotation(-0.067,-0.998,0.000,1.571).setTranslation(7.3925e+01,-1.3844e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2323'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {3.8907e+01,9.8660e+01,0.0000e+00,3.2187e+01,-2.1458e+00,0.0000e+00,1.8202e+02,-1.2135e+01,0.0000e+00,3.8907e+01,9.8660e+01,0.0000e+00,1.8202e+02,-1.2135e+01,0.0000e+00,1.8874e+02,8.8671e+01,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("three.appearance"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2354'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0658807807,-0.0658807807,-0.0658807807,-0.0658807807,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {7.3925e+01,-1.3844e+02,-3.2258e+01,8.5713e+01,-1.3058e+02,-3.2258e+01,1.0008e+02,-1.2500e+02,-3.2258e+01,1.1425e+02,-1.2500e+02,-3.2258e+01,7.3925e+01,-1.3844e+02,1.5017e+02,8.5713e+01,-1.3058e+02,1.5017e+02,1.0008e+02,-1.2500e+02,1.5017e+02,1.1425e+02,-1.2500e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-6.5881e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-6.5881e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-6.5881e-02,2.8276e-01,-6.5881e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2387'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0931694968,-0.0931694968,-0.0931694968,-0.0931694968,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.1425e+02,-1.2500e+02,-3.2258e+01,1.3428e+02,-1.2500e+02,-3.2258e+01,1.5599e+02,-1.3585e+02,-3.2258e+01,1.6801e+02,-1.5188e+02,-3.2258e+01,1.1425e+02,-1.2500e+02,1.5017e+02,1.3428e+02,-1.2500e+02,1.5017e+02,1.5599e+02,-1.3585e+02,1.5017e+02,1.6801e+02,-1.5188e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.3169e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-9.3169e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.3169e-02,2.8276e-01,-9.3169e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2420'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.098821191,-0.098821191,-0.098821191,-0.098821191,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.6801e+02,-1.5188e+02,-3.2258e+01,1.8304e+02,-1.6691e+02,-3.2258e+01,1.8817e+02,-1.9111e+02,-3.2258e+01,1.8817e+02,-2.1237e+02,-3.2258e+01,1.6801e+02,-1.5188e+02,1.5017e+02,1.8304e+02,-1.6691e+02,1.5017e+02,1.8817e+02,-1.9111e+02,1.5017e+02,1.8817e+02,-2.1237e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.8821e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-9.8821e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-9.8821e-02,2.8276e-01,-9.8821e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2453'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.102592265,-0.102592265,-0.102592265,-0.102592265,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.8817e+02,-2.1237e+02,-3.2258e+01,1.8817e+02,-2.3443e+02,-3.2258e+01,1.7894e+02,-2.5961e+02,-3.2258e+01,1.6129e+02,-2.7285e+02,-3.2258e+01,1.8817e+02,-2.1237e+02,1.5017e+02,1.8817e+02,-2.3443e+02,1.5017e+02,1.7894e+02,-2.5961e+02,1.5017e+02,1.6129e+02,-2.7285e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.0259e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.0259e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.0259e-01,2.8276e-01,-1.0259e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2486'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0890000344,-0.0890000344,-0.0890000344,-0.0890000344,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.6129e+02,-2.7285e+02,-3.2258e+01,1.4776e+02,-2.8638e+02,-3.2258e+01,1.2667e+02,-2.9301e+02,-3.2258e+01,1.0753e+02,-2.9301e+02,-3.2258e+01,1.6129e+02,-2.7285e+02,1.5017e+02,1.4776e+02,-2.8638e+02,1.5017e+02,1.2667e+02,-2.9301e+02,1.5017e+02,1.0753e+02,-2.9301e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-8.9000e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-8.9000e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-8.9000e-02,2.8276e-01,-8.9000e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2517'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.0890000413,-0.0890000413,-0.0890000413,-0.0890000413,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.0753e+02,-2.9301e+02,-3.2258e+01,8.8387e+01,-2.9301e+02,-3.2258e+01,6.9075e+01,-2.8433e+02,-3.2258e+01,5.3763e+01,-2.7285e+02,-3.2258e+01,1.0753e+02,-2.9301e+02,1.5017e+02,8.8387e+01,-2.9301e+02,1.5017e+02,6.9075e+01,-2.8433e+02,1.5017e+02,5.3763e+01,-2.7285e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-8.9000e-02,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-8.9000e-02,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-8.9000e-02,2.8276e-01,-8.9000e-02,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2550'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.108753213,-0.108753213,-0.108753213,-0.108753213,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {5.3763e+01,-2.7285e+02,-3.2258e+01,3.7226e+01,-2.5631e+02,-3.2258e+01,3.3602e+01,-2.2903e+02,-3.2258e+01,3.3602e+01,-2.0564e+02,-3.2258e+01,5.3763e+01,-2.7285e+02,1.5017e+02,3.7226e+01,-2.5631e+02,1.5017e+02,3.3602e+01,-2.2903e+02,1.5017e+02,3.3602e+01,-2.0564e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.0875e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.0875e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.0875e-01,2.8276e-01,-1.0875e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("three.appearance")))
        .addChild(new Transform().setRotation(-0.993,-0.117,0.000,1.571).setTranslation(-8.0645e+01,-2.1909e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2567'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {1.1802e+02,-1.8596e+01,0.0000e+00,3.7691e+00,-3.2037e+01,0.0000e+00,2.1315e+01,-1.8118e+02,0.0000e+00,1.1802e+02,-1.8596e+01,0.0000e+00,2.1315e+01,-1.8118e+02,0.0000e+00,1.3556e+02,-1.6774e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("three.appearance"))))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,1.571).setTranslation(6.2500e+02,-3.8710e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2598'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-2.2177e+02,3.2258e+01,0.0000e+00,0.0000e+00,3.2258e+01,0.0000e+00,0.0000e+00,1.8243e+02,0.0000e+00,-2.2177e+02,3.2258e+01,0.0000e+00,0.0000e+00,1.8243e+02,0.0000e+00,-2.2177e+02,1.8243e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("D.appearance"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2629'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.156596839,-0.156596839,-0.156596839,-0.156596839,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {6.2500e+02,-3.8710e+02,-3.2258e+01,6.5868e+02,-3.8710e+02,-3.2258e+01,6.9259e+02,-3.8591e+02,-3.2258e+01,7.2580e+02,-3.8038e+02,-3.2258e+01,6.2500e+02,-3.8710e+02,1.5017e+02,6.5868e+02,-3.8710e+02,1.5017e+02,6.9259e+02,-3.8591e+02,1.5017e+02,7.2580e+02,-3.8038e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.5660e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.5660e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.5660e-01,2.8276e-01,-1.5660e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2660'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.153800215,-0.153800215,-0.153800215,-0.153800215,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {7.2580e+02,-3.8038e+02,-3.2258e+01,7.5677e+02,-3.6876e+02,-3.2258e+01,7.8734e+02,-3.5399e+02,-3.2258e+01,8.1317e+02,-3.3333e+02,-3.2258e+01,7.2580e+02,-3.8038e+02,1.5017e+02,7.5677e+02,-3.6876e+02,1.5017e+02,7.8734e+02,-3.5399e+02,1.5017e+02,8.1317e+02,-3.3333e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.5380e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.5380e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.5380e-01,2.8276e-01,-1.5380e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2691'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.182217221,-0.182217221,-0.182217221,-0.182217221,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {8.1317e+02,-3.3333e+02,-3.2258e+01,8.4088e+02,-3.0562e+02,-3.2258e+01,8.6126e+02,-2.6970e+02,-3.2258e+01,8.7365e+02,-2.3253e+02,-3.2258e+01,8.1317e+02,-3.3333e+02,1.5017e+02,8.4088e+02,-3.0562e+02,1.5017e+02,8.6126e+02,-2.6970e+02,1.5017e+02,8.7365e+02,-2.3253e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.8222e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.8222e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.8222e-01,2.8276e-01,-1.8222e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2722'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.200368604,-0.200368604,-0.200368604,-0.200368604,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {8.7365e+02,-2.3253e+02,-3.2258e+01,8.8878e+02,-1.9218e+02,-3.2258e+01,8.9382e+02,-1.4793e+02,-3.2258e+01,8.9382e+02,-1.0484e+02,-3.2258e+01,8.7365e+02,-2.3253e+02,1.5017e+02,8.8878e+02,-1.9218e+02,1.5017e+02,8.9382e+02,-1.4793e+02,1.5017e+02,8.9382e+02,-1.0484e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.0037e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-2.0037e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.0037e-01,2.8276e-01,-2.0037e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2753'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.210664041,-0.210664041,-0.210664041,-0.210664041,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {8.9382e+02,-1.0484e+02,-3.2258e+01,8.9382e+02,-5.9534e+01,-3.2258e+01,8.8956e+02,-1.2850e+01,-3.2258e+01,8.7365e+02,2.9570e+01,-3.2258e+01,8.9382e+02,-1.0484e+02,1.5017e+02,8.9382e+02,-5.9534e+01,1.5017e+02,8.8956e+02,-1.2850e+01,1.5017e+02,8.7365e+02,2.9570e+01,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.1066e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-2.1066e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-2.1066e-01,2.8276e-01,-2.1066e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2784'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.173367881,-0.173367881,-0.173367881,-0.173367881,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {8.7365e+02,2.9570e+01,-3.2258e+01,8.6056e+02,6.4479e+01,-3.2258e+01,8.3953e+02,9.7292e+01,-3.2258e+01,8.1317e+02,1.2366e+02,-3.2258e+01,8.7365e+02,2.9570e+01,1.5017e+02,8.6056e+02,6.4479e+01,1.5017e+02,8.3953e+02,9.7292e+01,1.5017e+02,8.1317e+02,1.2366e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.7337e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.7337e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.7337e-01,2.8276e-01,-1.7337e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2815'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.159003487,-0.159003487,-0.159003487,-0.159003487,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {8.1317e+02,1.2366e+02,-3.2258e+01,7.9128e+02,1.4992e+02,-3.2258e+01,7.5898e+02,1.6913e+02,-3.2258e+01,7.2580e+02,1.7742e+02,-3.2258e+01,8.1317e+02,1.2366e+02,1.5017e+02,7.9128e+02,1.4992e+02,1.5017e+02,7.5898e+02,1.6913e+02,1.5017e+02,7.2580e+02,1.7742e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.5900e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.5900e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.5900e-01,2.8276e-01,-1.5900e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2846'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(4).setUKnot(new double[] {-0.16796372,-0.16796372,-0.16796372,-0.16796372,-0.0,-0.0,-0.0,-0.0}).setUOrder(4).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.282761345,0.282761345}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {7.2580e+02,1.7742e+02,-3.2258e+01,6.9227e+02,1.9083e+02,-3.2258e+01,6.5440e+02,1.9086e+02,-3.2258e+01,6.1828e+02,1.9086e+02,-3.2258e+01,7.2580e+02,1.7742e+02,1.5017e+02,6.9227e+02,1.9083e+02,1.5017e+02,6.5440e+02,1.9086e+02,1.5017e+02,6.1828e+02,1.9086e+02,1.5017e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.6796e-01,5.0000e-02,-0.0000e+00,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,5.0000e-02,-0.0000e+00,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-0.0000e+00,2.8276e-01,-1.6796e-01,2.8276e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-1.6796e-01,2.8276e-01,-1.6796e-01,5.0000e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("D.appearance")))
        .addChild(new Transform().setRotation(-1.000,0.000,0.000,1.571).setTranslation(4.0323e+02,1.9086e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2870'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {2.1505e+02,-3.2258e+01,0.0000e+00,0.0000e+00,-3.2258e+01,0.0000e+00,0.0000e+00,-1.8243e+02,0.0000e+00,2.1505e+02,-3.2258e+01,0.0000e+00,0.0000e+00,-1.8243e+02,0.0000e+00,2.1505e+02,-1.8243e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("D.appearance"))))
        .addChild(new Transform().setRotation(0.000,-1.000,0.000,1.571).setTranslation(4.0323e+02,-3.8710e+02,-3.2258e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2887'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {3.2258e+01,5.7796e+02,0.0000e+00,3.2258e+01,0.0000e+00,0.0000e+00,1.8243e+02,0.0000e+00,0.0000e+00,3.2258e+01,5.7796e+02,0.0000e+00,1.8243e+02,0.0000e+00,0.0000e+00,1.8243e+02,5.7796e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("D.appearance"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2914'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(7).setUKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.254677242439,0.254677242439}).setVOrder(2).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0,1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-6.3889e+02,3.0886e+02,-5.1619e+01,-5.5329e+02,2.3522e+02,-4.4703e+01,-6.7115e+02,2.5299e+02,-5.1619e+01,-6.0917e+02,2.0297e+02,-4.4703e+01,-7.3566e+02,2.5299e+02,-5.1619e+01,-6.6504e+02,2.3522e+02,-4.4703e+01,-7.6792e+02,3.0886e+02,-5.1619e+01,-6.3889e+02,3.0886e+02,0.0000e+00,-5.5329e+02,2.3522e+02,-1.4100e-14,-6.7115e+02,2.5299e+02,0.0000e+00,-6.0917e+02,2.0297e+02,-1.4100e-14,-7.3566e+02,2.5299e+02,0.0000e+00,-6.6504e+02,2.3522e+02,-1.4100e-14,-7.6792e+02,3.0886e+02,0.0000e+00})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.0000e-01,2.5468e-01,0.0000e+00,2.5468e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,2.5468e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,5.0000e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.0000e-01,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,2.5468e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,2.5468e-01,5.0000e-01,2.5468e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2922'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(7).setUKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.254677242439,0.254677242439}).setVOrder(2).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0,1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-7.6792e+02,3.0886e+02,-5.1619e+01,-6.6504e+02,2.9974e+02,-4.4703e+01,-7.3566e+02,3.6473e+02,-5.1619e+01,-6.0917e+02,3.3200e+02,-4.4703e+01,-6.7115e+02,3.6473e+02,-5.1619e+01,-5.5329e+02,2.9974e+02,-4.4703e+01,-6.3889e+02,3.0886e+02,-5.1619e+01,-7.6792e+02,3.0886e+02,0.0000e+00,-6.6504e+02,2.9974e+02,-1.4100e-14,-7.3566e+02,3.6473e+02,0.0000e+00,-6.0917e+02,3.3200e+02,-1.4100e-14,-6.7115e+02,3.6473e+02,0.0000e+00,-5.5329e+02,2.9974e+02,-1.4100e-14,-6.3889e+02,3.0886e+02,0.0000e+00})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,2.5468e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,2.5468e-01,0.0000e+00,2.5468e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,2.5468e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2964'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,8.0,8.0}).setVOrder(2).setWeight(new double[] {1.0,0.949287344668,1.0,1.0,0.949287344668,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,6.3240e+02,-3.1309e+02,9.1866e+02,5.8823e+02,-3.1349e+02,9.6774e+02,5.9918e+02,-3.3637e+02,-9.6774e+02,6.3240e+02,-3.1309e+02,-9.1866e+02,5.8823e+02,-3.1349e+02,-9.6774e+02,5.9918e+02,-3.3637e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.0000e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.0000e+00,0.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#2999'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,3.19275428508,3.19275428508}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,5.9918e+02,-3.3637e+02,9.6774e+02,1.8539e+01,-5.1057e+02,-9.6774e+02,5.9918e+02,-3.3637e+02,-9.6774e+02,1.8539e+01,-5.1057e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,3.1928e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,3.1928e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,3.1928e+00,0.0000e+00,3.1928e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.0000e-01,2.8631e+00,4.8857e-01,2.4795e+00,5.9623e-01,2.8099e+00,5.4412e-01,2.3874e+00,5.9623e-01,2.7035e+00,4.8857e-01,2.2952e+00,5.0000e-01,2.6503e+00})).setKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.0000e-01,2.6503e+00,3.7746e-01,2.2952e+00,4.0377e-01,2.7035e+00,3.2190e-01,2.3874e+00,4.0377e-01,2.8099e+00,3.7746e-01,2.4795e+00,5.0000e-01,2.8631e+00})).setKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3032'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,8.0,8.0}).setVOrder(2).setWeight(new double[] {1.0,0.989400395282,1.0,1.0,0.989400395282,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,1.8539e+01,-5.1057e+02,9.5748e+02,9.3686e+00,-5.0785e+02,9.6774e+02,-1.2333e-13,-5.1329e+02,-9.6774e+02,1.8539e+01,-5.1057e+02,-9.5748e+02,9.3686e+00,-5.0785e+02,-9.6774e+02,-1.2333e-13,-5.1329e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.0000e+00,0.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.0000e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3050'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,8.0,8.0}).setVOrder(2).setWeight(new double[] {1.0,0.989400395282,1.0,1.0,0.989400395282,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,-1.2250e-13,-5.1329e+02,9.5748e+02,-9.3686e+00,-5.0785e+02,9.6774e+02,-1.8539e+01,-5.1057e+02,-9.6774e+02,-1.2250e-13,-5.1329e+02,-9.5748e+02,-9.3686e+00,-5.0785e+02,-9.6774e+02,-1.8539e+01,-5.1057e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.0000e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.0000e+00,0.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,2.850).setTranslation(9.6774e+02,-6.4516e+02,-3.2258e+02)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3081'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.9355e+03,-6.5421e+02,0.0000e+00,0.0000e+00,-6.5421e+02,0.0000e+00,0.0000e+00,-4.8002e+01,0.0000e+00,-1.9355e+03,-6.5421e+02,0.0000e+00,0.0000e+00,-4.8002e+01,0.0000e+00,-1.9355e+03,-4.8002e+01,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3114'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,8.0,8.0}).setVOrder(2).setWeight(new double[] {1.0,0.949287344668,1.0,1.0,0.949287344668,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,-5.9918e+02,-3.3637e+02,9.1866e+02,-5.8823e+02,-3.1349e+02,9.6774e+02,-6.3240e+02,-3.1309e+02,-9.6774e+02,-5.9918e+02,-3.3637e+02,-9.1866e+02,-5.8823e+02,-3.1349e+02,-9.6774e+02,-6.3240e+02,-3.1309e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.0000e+00,0.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.0000e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3132'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,8.0,8.0}).setVOrder(2).setWeight(new double[] {1.0,0.94928734614,1.0,1.0,0.94928734614,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,-6.3240e+02,-3.1309e+02,9.1866e+02,-6.1244e+02,-2.8094e+02,9.6774e+02,-6.4516e+02,-2.7458e+02,-9.6774e+02,-6.3240e+02,-3.1309e+02,-9.1866e+02,-6.1244e+02,-2.8094e+02,-9.6774e+02,-6.4516e+02,-2.7458e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.0000e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.0000e+00,0.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3174'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,8.0,8.0}).setVOrder(2).setWeight(new double[] {1.0,0.923879532721,1.0,1.0,0.923879532721,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,5.8064e+02,0.0000e+00,8.9408e+02,5.6113e+02,-1.6584e-14,9.6774e+02,6.2626e+02,-1.8896e+01,-9.6774e+02,5.8064e+02,0.0000e+00,-8.9408e+02,5.6113e+02,-1.6584e-14,-9.6774e+02,6.2626e+02,-1.8896e+01})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.0000e+00,0.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.0000e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3192'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,8.0,8.0}).setVOrder(2).setWeight(new double[] {1.0,0.923879532302,1.0,1.0,0.923879532302,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,6.2626e+02,-1.8896e+01,8.9408e+02,5.9605e+02,-3.4916e+01,9.6774e+02,6.4516e+02,-6.4516e+01,-9.6774e+02,6.2626e+02,-1.8896e+01,-8.9408e+02,5.9605e+02,-3.4916e+01,-9.6774e+02,6.4516e+02,-6.4516e+01})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.0000e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.0000e+00,0.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(-1.000,0.000,0.000,1.571).setTranslation(9.6774e+02,6.4516e+02,-3.2258e+02)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3223'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0000e+00,-4.8002e+01,0.0000e+00,-1.9355e+03,-4.8002e+01,0.0000e+00,-1.9355e+03,-2.5806e+02,0.0000e+00,0.0000e+00,-4.8002e+01,0.0000e+00,-1.9355e+03,-2.5806e+02,0.0000e+00,0.0000e+00,-2.5806e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3232'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,8.0,8.0}).setVOrder(2).setWeight(new double[] {1.0,0.94928734614,1.0,1.0,0.94928734614,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,6.4516e+02,-2.7458e+02,9.1866e+02,6.1244e+02,-2.8094e+02,9.6774e+02,6.3240e+02,-3.1309e+02,-9.6774e+02,6.4516e+02,-2.7458e+02,-9.1866e+02,6.1244e+02,-2.8094e+02,-9.6774e+02,6.3240e+02,-3.1309e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.0000e+00,0.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.0000e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3272'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.27933953,1.27933953,1.27933953}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.75,0.75}).setVOrder(2).setWeight(new double[] {1.0,0.802292928,1.0,1.0,0.802292928,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {5.1613e+02,5.8064e+02,-2.7128e+02,4.1409e+02,4.6585e+02,-2.4846e+02,5.1613e+02,5.3926e+02,-3.2072e+02,1.0000e+03,5.8064e+02,-2.7128e+02,8.0229e+02,4.6585e+02,-2.4846e+02,1.0000e+03,5.3926e+02,-3.2072e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2793e+00,7.0000e-01,0.0000e+00,7.0000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,7.0000e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.2793e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2793e+00,0.0000e+00,1.2793e+00,7.0000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,1.571).setTranslation(5.1613e+02,5.8064e+02,-1.0323e+02)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3296'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {4.5161e+02,-1.6805e+02,0.0000e+00,4.5161e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,4.5161e+02,-1.6805e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,-1.6805e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3329'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.57079633,1.57079633,1.57079633}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.75,0.75}).setVOrder(2).setWeight(new double[] {1.0,0.707106781,1.0,1.0,0.707106781,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {5.1613e+02,5.2258e+02,-5.1619e+01,3.6496e+02,4.1058e+02,-3.6500e+01,5.1613e+02,5.8064e+02,-1.0323e+02,1.0000e+03,5.2258e+02,-5.1619e+01,7.0711e+02,4.1058e+02,-3.6500e+01,1.0000e+03,5.8064e+02,-1.0323e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.5708e+00,7.0000e-01,0.0000e+00,7.0000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,7.0000e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.5708e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.5708e+00,0.0000e+00,1.5708e+00,7.0000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,3.142).setTranslation(5.1613e+02,-5.2258e+02,-5.1619e+01)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3353'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {4.5161e+02,-1.0452e+03,0.0000e+00,4.5161e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,4.5161e+02,-1.0452e+03,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,-1.0452e+03,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3388'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.57079633,1.57079633,1.57079633}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.75,0.75}).setVOrder(2).setWeight(new double[] {1.0,0.707106781,1.0,1.0,0.707106781,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {5.1613e+02,-5.8064e+02,-1.0323e+02,3.6496e+02,-4.1058e+02,-3.6500e+01,5.1613e+02,-5.2258e+02,-5.1619e+01,1.0000e+03,-5.8064e+02,-1.0323e+02,7.0711e+02,-4.1058e+02,-3.6500e+01,1.0000e+03,-5.2258e+02,-5.1619e+01})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.5708e+00,7.0000e-01,0.0000e+00,7.0000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,7.0000e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.5708e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.5708e+00,0.0000e+00,1.5708e+00,7.0000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(-1.000,0.000,0.000,1.571).setTranslation(5.1613e+02,-5.8064e+02,-2.7128e+02)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3412'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {4.5161e+02,-1.6805e+02,0.0000e+00,4.5161e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,4.5161e+02,-1.6805e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,-1.6805e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3445'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.27933953,1.27933953,1.27933953}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.75,0.75}).setVOrder(2).setWeight(new double[] {1.0,0.802292928,1.0,1.0,0.802292928,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {5.1613e+02,-5.3926e+02,-3.2072e+02,4.1409e+02,-4.6585e+02,-2.4846e+02,5.1613e+02,-5.8064e+02,-2.7128e+02,1.0000e+03,-5.3926e+02,-3.2072e+02,8.0229e+02,-4.6585e+02,-2.4846e+02,1.0000e+03,-5.8064e+02,-2.7128e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2793e+00,7.0000e-01,0.0000e+00,7.0000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,7.0000e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.2793e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2793e+00,0.0000e+00,1.2793e+00,7.0000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(-1.000,0.000,0.000,0.261).setTranslation(5.1613e+02,-1.6685e+01,-4.6007e+02)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3469'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {4.5161e+02,-5.4084e+02,0.0000e+00,4.5161e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,4.5161e+02,-5.4084e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,-5.4084e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3498'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,0.582913589,0.582913589,0.582913589}).setVDimension(2).setVKnot(new double[] {0.0,0.0,0.75,0.75}).setVOrder(2).setWeight(new double[] {1.0,0.957826285,1.0,1.0,0.957826285,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {5.1613e+02,1.6685e+01,-4.6007e+02,4.9436e+02,-1.3721e-13,-4.4493e+02,5.1613e+02,-1.6685e+01,-4.6007e+02,1.0000e+03,1.6685e+01,-4.6007e+02,9.5782e+02,-1.3721e-13,-4.4493e+02,1.0000e+03,-1.6685e+01,-4.6007e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.8291e-01,7.0000e-01,0.0000e+00,7.0000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,7.0000e-01,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,5.8291e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.8291e-01,0.0000e+00,5.8291e-01,7.0000e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,0.261).setTranslation(5.1613e+02,5.3926e+02,-3.2072e+02)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3515'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {4.5161e+02,-5.4084e+02,0.0000e+00,4.5161e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,4.5161e+02,-5.4084e+02,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,0.0000e+00,-5.4084e+02,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Transform().setRotation(1.000,0.000,0.000,1.571).setTranslation(9.6774e+02,-6.4516e+02,0.0000e+00)
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3546'"}))
          .addChild(new Shape()
            .setGeometry(new TriangleSet().setCcw(true).setColorPerVertex(true).setNormalPerVertex(true).setSolid(true)
              .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {-1.9355e+03,-2.7458e+02,0.0000e+00,0.0000e+00,-2.7458e+02,0.0000e+00,0.0000e+00,-6.4516e+01,0.0000e+00,-1.9355e+03,-2.7458e+02,0.0000e+00,0.0000e+00,-6.4516e+01,0.0000e+00,-1.9355e+03,-6.4516e+01,0.0000e+00}))))
            .setAppearance(new Appearance().setUSE("partcolor"))))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3597'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,2.51383572623,2.51383572623}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-9.6774e+02,6.4516e+02,0.0000e+00,-9.6774e+02,6.4516e+02,-5.1329e+02,-9.6774e+02,-6.4516e+02,0.0000e+00,-9.6774e+02,-6.4516e+02,-5.1329e+02})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.0997e-01,2.4850e-02,6.1074e-01,4.7180e-02,6.5533e-01,8.9575e-02})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.949287344668,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.5533e-01,8.9575e-02,9.9470e-01,1.2208e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.9470e-01,1.2208e+00,9.8940e-01,1.2253e+00,1.0000e+00,1.2569e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.989400395282,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,1.2569e+00,9.8940e-01,1.2618e+00,9.9470e-01,1.2930e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.989400395282,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.9470e-01,1.2930e+00,6.5533e-01,2.4243e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.5533e-01,2.4243e+00,6.1074e-01,2.3392e+00,6.0997e-01,2.4890e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.949287344668,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.0997e-01,2.4890e+00,5.4733e-01,2.3864e+00,5.3494e-01,2.5138e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.94928734614,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.3494e-01,2.5138e+00,1.2569e-01,2.5138e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2569e-01,2.5138e+00,6.8024e-02,2.3225e+00,3.6814e-02,2.4770e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.923879532302,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.6814e-02,2.4770e+00,1.1463e-10,2.2545e+00,1.2407e-10,2.3881e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.923879532721,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2407e-10,2.3881e+00,0.0000e+00,1.2569e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,1.2569e-01,0.0000e+00,6.8024e-02,3.6814e-02,3.6814e-02})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.923879532721,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.6814e-02,3.6814e-02,6.8024e-02,1.1463e-10,1.2569e-01,1.2407e-10})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.923879532302,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.2569e-01,1.2407e-10,5.3494e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.3494e-01,0.0000e+00,5.4733e-01,0.0000e+00,6.0997e-01,2.4850e-02})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.94928734614,1.0})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.9632e-01,1.2244e+00,6.2483e-01,2.0631e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.2483e-01,2.0631e-01,4.8405e-01,1.0084e-01,5.2852e-01,1.2569e-01})).setKnot(new double[] {0.0,0.0,0.0,1.27933953,1.27933953,1.27933953}).setWeight(new double[] {1.0,0.802292928,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.2852e-01,1.2569e-01,2.0112e-01,1.2569e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.0112e-01,1.2569e-01,7.1110e-02,8.8878e-02,1.0057e-01,2.3881e-01})).setKnot(new double[] {0.0,0.0,0.0,1.57079633,1.57079633,1.57079633}).setWeight(new double[] {1.0,0.707106781,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0057e-01,2.3881e-01,1.0057e-01,2.2750e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0057e-01,2.2750e+00,7.1110e-02,1.6887e+00,2.0112e-01,2.3881e+00})).setKnot(new double[] {0.0,0.0,0.0,1.57079633,1.57079633,1.57079633}).setWeight(new double[] {1.0,0.707106781,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.0112e-01,2.3881e+00,5.2852e-01,2.3881e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.2852e-01,2.3881e+00,4.8405e-01,1.9160e+00,6.2483e-01,2.3075e+00})).setKnot(new double[] {0.0,0.0,0.0,1.27933953,1.27933953,1.27933953}).setWeight(new double[] {1.0,0.802292928,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.2483e-01,2.3075e+00,8.9632e-01,1.2894e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.9632e-01,1.2894e+00,8.6683e-01,1.2039e+00,8.9632e-01,1.2244e+00})).setKnot(new double[] {0.0,0.0,0.0,0.582913589,0.582913589,0.582913589}).setWeight(new double[] {1.0,0.957826285,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3677'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,1.66666666667,1.66666666667}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,-5.8064e+02,0.0000e+00,9.6774e+02,5.8064e+02,0.0000e+00,-9.6774e+02,-5.8064e+02,0.0000e+00,-9.6774e+02,5.8064e+02,0.0000e+00})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,1.6667e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,1.6667e+00,0.0000e+00,1.6667e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,1.6667e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.6596e-01,1.4946e+00,6.9112e-01,1.2944e+00,8.1408e-01,1.4668e+00,7.1890e-01,1.2462e+00,8.1408e-01,1.4113e+00,6.9112e-01,1.1981e+00,7.6596e-01,1.3835e+00})).setKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.6596e-01,1.3835e+00,6.3557e-01,1.1981e+00,7.1785e-01,1.4113e+00,6.0779e-01,1.2462e+00,7.1785e-01,1.4668e+00,6.3557e-01,1.2944e+00,7.6596e-01,1.4946e+00})).setKnot(new double[] {0.0,0.0,0.0,0.333333333333,0.333333333333,0.666666666667,0.666666666667,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.866025403784,1.0,0.866025403784,1.0,0.866025403784,1.0})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.6667e-01,4.8611e-01,6.6435e-01,4.8611e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.6435e-01,4.8611e-01,6.6435e-01,3.0093e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.6435e-01,3.0093e-01,6.6435e-01,2.8538e-01,6.6435e-01,2.6945e-01,6.6146e-01,2.3825e-01,6.5858e-01,2.2284e-01,6.5278e-01,2.0833e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0839604618,0.0839604618,0.167334904,0.167334904,0.167334904,0.167334904}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.5278e-01,2.0833e-01,6.4917e-01,1.9388e-01,6.4320e-01,1.7981e-01,6.2767e-01,1.5435e-01,6.1792e-01,1.4263e-01,6.0648e-01,1.3310e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0804368016,0.0804368016,0.160827755,0.160827755,0.160827755,0.160827755}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.0648e-01,1.3310e-01,5.9507e-01,1.2169e-01,5.8232e-01,1.1150e-01,5.5515e-01,9.4049e-02,5.4058e-01,8.6686e-02,5.2546e-01,8.1019e-02})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0871588252,0.0871588252,0.174320389,0.174320389,0.174320389,0.174320389}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.2546e-01,8.1019e-02,5.0713e-01,7.4144e-02,4.8792e-01,6.9817e-02,4.4910e-01,6.4583e-02,4.2933e-01,6.3657e-02,4.0972e-01,6.3657e-02})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.105728391,0.105728391,0.211574791,0.211574791,0.211574791,0.211574791}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.0972e-01,6.3657e-02,3.9108e-01,6.3657e-02,3.7230e-01,6.4751e-02,3.3543e-01,7.0152e-02,3.1721e-01,7.4480e-02,2.9977e-01,8.1019e-02})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.10064514,0.10064514,0.201210834,0.201210834,0.201210834,0.201210834}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.9977e-01,8.1019e-02,2.8366e-01,8.6389e-02,2.6793e-01,9.3465e-02,2.3869e-01,1.1076e-01,2.2497e-01,1.2110e-01,2.1296e-01,1.3310e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.091713057,0.091713057,0.183382886,0.183382886,0.183382886,0.183382886}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.1296e-01,1.3310e-01,2.0404e-01,1.4425e-01,1.9642e-01,1.5641e-01,1.8315e-01,1.8172e-01,1.7747e-01,1.9495e-01,1.7245e-01,2.0833e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0771251231,0.0771251231,0.154305938,0.154305938,0.154305938,0.154305938}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.7245e-01,2.0833e-01,1.7007e-01,2.2265e-01,1.6862e-01,2.3710e-01,1.6692e-01,2.6608e-01,1.6667e-01,2.8062e-01,1.6667e-01,2.9514e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0783620198,0.0783620198,0.156746765,0.156746765,0.156746765,0.156746765}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.6667e-01,2.9514e-01,1.6667e-01,4.8611e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.1134e-01,9.0278e-01,3.2292e-01,8.0440e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.2292e-01,8.0440e-01,3.1258e-01,8.0440e-01,3.0178e-01,8.0358e-01,2.8678e-01,7.9980e-01,2.8185e-01,7.9809e-01,2.7276e-01,7.9347e-01,2.6862e-01,7.9061e-01,2.6505e-01,7.8704e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0557993018,0.0557993018,0.0836335639,0.0836335639,0.110943379,0.110943379,0.110943379,0.110943379}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.6505e-01,7.8704e-01,2.6004e-01,7.8036e-01,2.5573e-01,7.7290e-01,2.4960e-01,7.5737e-01,2.4769e-01,7.4908e-01,2.4769e-01,7.4074e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0450760871,0.0450760871,0.0900647018,0.0900647018,0.0900647018,0.0900647018}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.4769e-01,7.4074e-01,2.4769e-01,7.3236e-01,2.4916e-01,7.2370e-01,2.5342e-01,7.1179e-01,2.5522e-01,7.0791e-01,2.5957e-01,7.0072e-01,2.6210e-01,6.9739e-01,2.6505e-01,6.9444e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0452706111,0.0452706111,0.068099425,0.068099425,0.0905040325,0.0905040325,0.0905040325,0.0905040325}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.6505e-01,6.9444e-01,2.6845e-01,6.8991e-01,2.7272e-01,6.8608e-01,2.8326e-01,6.7906e-01,2.8985e-01,6.7617e-01,3.0321e-01,6.7233e-01,3.1025e-01,6.7130e-01,3.1713e-01,6.7130e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.030619145,0.030619145,0.0683656767,0.0683656767,0.105582041,0.105582041,0.105582041,0.105582041}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.1713e-01,6.7130e-01,3.2647e-01,6.7130e-01,3.3622e-01,6.7245e-01,3.4968e-01,6.7647e-01,3.5408e-01,6.7822e-01,3.6222e-01,6.8270e-01,3.6596e-01,6.8540e-01,3.6921e-01,6.8866e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0504127395,0.0504127395,0.0756912348,0.0756912348,0.100496916,0.100496916,0.100496916,0.100496916}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.6921e-01,6.8866e-01,3.7428e-01,6.9246e-01,3.7864e-01,6.9730e-01,3.8533e-01,7.0742e-01,3.8789e-01,7.1275e-01,3.9136e-01,7.2364e-01,3.9236e-01,7.2931e-01,3.9236e-01,7.3495e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0342220363,0.0342220363,0.0653750228,0.0653750228,0.0958141118,0.0958141118,0.0958141118,0.0958141118}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.9236e-01,7.3495e-01,3.9236e-01,7.4104e-01,3.9116e-01,7.4712e-01,3.8715e-01,7.5878e-01,3.8425e-01,7.6449e-01,3.8079e-01,7.6968e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0328760613,0.0328760613,0.0665671808,0.0665671808,0.0665671808,0.0665671808}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.8079e-01,7.6968e-01,4.6759e-01,7.6389e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.6759e-01,7.6389e-01,4.6613e-01,7.5512e-01,4.6588e-01,7.4524e-01,4.6839e-01,7.3145e-01,4.6970e-01,7.2696e-01,4.7353e-01,7.1872e-01,4.7600e-01,7.1497e-01,4.7917e-01,7.1181e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0480296265,0.0480296265,0.0715421148,0.0715421148,0.0944275344,0.0944275344,0.0944275344,0.0944275344}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.7917e-01,7.1181e-01,4.8347e-01,7.0750e-01,4.8861e-01,7.0406e-01,4.9899e-01,6.9908e-01,5.0421e-01,6.9734e-01,5.1472e-01,6.9504e-01,5.2013e-01,6.9444e-01,5.2546e-01,6.9444e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0328823443,0.0328823443,0.0621122918,0.0621122918,0.0909342627,0.0909342627,0.0909342627,0.0909342627}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.2546e-01,6.9444e-01,5.3054e-01,6.9444e-01,5.3573e-01,6.9545e-01,5.4447e-01,6.9863e-01,5.4828e-01,7.0062e-01,5.5497e-01,7.0550e-01,5.5792e-01,7.0841e-01,5.6019e-01,7.1181e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0274224374,0.0274224374,0.0500299309,0.0500299309,0.0719939007,0.0719939007,0.0719939007,0.0719939007}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.6019e-01,7.1181e-01,5.6422e-01,7.1449e-01,5.6799e-01,7.1814e-01,5.7294e-01,7.2506e-01,5.7460e-01,7.2806e-01,5.7688e-01,7.3426e-01,5.7755e-01,7.3749e-01,5.7755e-01,7.4074e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0261664008,0.0261664008,0.043238428,0.043238428,0.0598021835,0.0598021835,0.0598021835,0.0598021835}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.7755e-01,7.4074e-01,5.7755e-01,7.4582e-01,5.7654e-01,7.5100e-01,5.7336e-01,7.5975e-01,5.7138e-01,7.6356e-01,5.6649e-01,7.7025e-01,5.6358e-01,7.7320e-01,5.6019e-01,7.7546e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.027422447,0.027422447,0.050029939,0.050029939,0.0719939073,0.0719939073,0.0719939073,0.0719939073}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.6019e-01,7.7546e-01,5.5588e-01,7.7977e-01,5.5074e-01,7.8321e-01,5.4037e-01,7.8819e-01,5.3514e-01,7.8993e-01,5.2463e-01,7.9223e-01,5.1922e-01,7.9282e-01,5.1389e-01,7.9282e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0328823422,0.0328823422,0.0621122899,0.0621122899,0.090934261,0.090934261,0.090934261,0.090934261}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.1389e-01,7.9282e-01,5.2546e-01,8.9120e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.2546e-01,8.9120e-01,5.3857e-01,8.8957e-01,5.5173e-01,8.8715e-01,5.7707e-01,8.7980e-01,5.8939e-01,8.7484e-01,6.0069e-01,8.6806e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0713116858,0.0713116858,0.14252381,0.14252381,0.14252381,0.14252381}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.0069e-01,8.6806e-01,6.1074e-01,8.6203e-01,6.1971e-01,8.5416e-01,6.3513e-01,8.3648e-01,6.4175e-01,8.2646e-01,6.4699e-01,8.1597e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0632919871,0.0632919871,0.126638913,0.126638913,0.126638913,0.126638913}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.4699e-01,8.1597e-01,6.5236e-01,8.0523e-01,6.5669e-01,7.9383e-01,6.6266e-01,7.7056e-01,6.6435e-01,7.5853e-01,6.6435e-01,7.4653e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0648509332,0.0648509332,0.1296713,0.1296713,0.1296713,0.1296713}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.6435e-01,7.4653e-01,6.6435e-01,7.2630e-01,6.6036e-01,7.0570e-01,6.4930e-01,6.7624e-01,6.4435e-01,6.6608e-01,6.3261e-01,6.4729e-01,6.2581e-01,6.3854e-01,6.1806e-01,6.3079e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.10922775,0.10922775,0.169472111,0.169472111,0.228595182,0.228595182,0.228595182,0.228595182}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.1806e-01,6.3079e-01,6.0605e-01,6.2050e-01,5.9210e-01,6.1188e-01,5.6285e-01,5.9977e-01,5.4705e-01,5.9606e-01,5.3125e-01,5.9606e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.085356265,0.085356265,0.170608765,0.170608765,0.170608765,0.170608765}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.3125e-01,5.9606e-01,5.2164e-01,5.9606e-01,5.1220e-01,5.9795e-01,4.9105e-01,6.0559e-01,4.7971e-01,6.1241e-01,4.6077e-01,6.2741e-01,4.5263e-01,6.3551e-01,4.3850e-01,6.5256e-01,4.3223e-01,6.6175e-01,4.2708e-01,6.7130e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0518867712,0.0518867712,0.121451398,0.121451398,0.182142239,0.182142239,0.240794867,0.240794867,0.240794867,0.240794867}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.2708e-01,6.7130e-01,4.2546e-01,6.5991e-01,4.2158e-01,6.4882e-01,4.0894e-01,6.2469e-01,3.9862e-01,6.1189e-01,3.8657e-01,6.0185e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0621229689,0.0621229689,0.14694082,0.14694082,0.14694082,0.14694082}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.8657e-01,6.0185e-01,3.7923e-01,5.9451e-01,3.7045e-01,5.8862e-01,3.5331e-01,5.8043e-01,3.4503e-01,5.7762e-01,3.2836e-01,5.7390e-01,3.1981e-01,5.7292e-01,3.1134e-01,5.7292e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0560699038,0.0560699038,0.102491459,0.102491459,0.148202591,0.148202591,0.148202591,0.148202591}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.1134e-01,5.7292e-01,2.9639e-01,5.7292e-01,2.8141e-01,5.7587e-01,2.5464e-01,5.8536e-01,2.4246e-01,5.9157e-01,2.2035e-01,6.0640e-01,2.1014e-01,6.1515e-01,2.0139e-01,6.2500e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0807707572,0.0807707572,0.153187297,0.153187297,0.224335138,0.224335138,0.224335138,0.224335138}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.0139e-01,6.2500e-01,1.8985e-01,6.3819e-01,1.8090e-01,6.5366e-01,1.6552e-01,6.9220e-01,1.6088e-01,7.1685e-01,1.6088e-01,7.4074e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0946307219,0.0946307219,0.22386939,0.22386939,0.22386939,0.22386939}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.6088e-01,7.4074e-01,1.6088e-01,7.6149e-01,1.6437e-01,7.8270e-01,1.7770e-01,8.2207e-01,1.8774e-01,8.4088e-01,2.0139e-01,8.5648e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.112055228,0.112055228,0.22392241,0.22392241,0.22392241,0.22392241}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.0139e-01,8.5648e-01,2.1279e-01,8.6788e-01,2.2638e-01,8.7698e-01,2.6267e-01,8.9454e-01,2.8730e-01,9.0077e-01,3.1134e-01,9.0278e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0870634854,0.0870634854,0.217552446,0.217552446,0.217552446,0.217552446}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.6667e-01,1.2731e+00,1.6667e-01,1.3889e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.6667e-01,1.3889e+00,4.2708e-01,1.2153e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.2708e-01,1.2153e+00,6.6435e-01,1.3715e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.6435e-01,1.3715e+00,6.6435e-01,1.2558e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.6435e-01,1.2558e+00,5.1389e-01,1.1574e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.1389e-01,1.1574e+00,6.6435e-01,1.0648e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.6435e-01,1.0648e+00,6.6435e-01,9.4907e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {6.6435e-01,9.4907e-01,4.2708e-01,1.0995e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.2708e-01,1.0995e+00,1.6667e-01,9.3171e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.6667e-01,9.3171e-01,1.6667e-01,1.0475e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.6667e-01,1.0475e+00,3.3449e-01,1.1574e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.3449e-01,1.1574e+00,1.6667e-01,1.2731e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3721'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(2).setUKnot(new double[] {0.0,0.0,1.0,1.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {0.0,0.0,2.51383572623,2.51383572623}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,6.4516e+02,-5.1329e+02,9.6774e+02,6.4516e+02,0.0000e+00,9.6774e+02,-6.4516e+02,-5.1329e+02,9.6774e+02,-6.4516e+02,0.0000e+00})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.9003e-01,2.4850e-02,4.0196e-01,0.0000e+00,4.6506e-01,0.0000e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.94928734614,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.6506e-01,0.0000e+00,8.7431e-01,6.2689e-10})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.7431e-01,6.2689e-10,8.5586e-01,5.7917e-10,9.6319e-01,3.6814e-02})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.923879532302,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.6319e-01,3.6814e-02,9.2388e-01,6.8024e-02,1.0000e+00,1.2569e-01})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.923879532721,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,1.2569e-01,1.0000e+00,2.3881e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,2.3881e+00,9.2388e-01,2.2545e+00,9.6319e-01,2.4770e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.923879532721,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {9.6319e-01,2.4770e+00,8.5586e-01,2.3225e+00,8.7431e-01,2.5138e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.923879532302,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.7431e-01,2.5138e+00,4.6506e-01,2.5138e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.6506e-01,2.5138e+00,4.0196e-01,2.3864e+00,3.9003e-01,2.4890e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.94928734614,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.9003e-01,2.4890e+00,3.3855e-01,2.3392e+00,3.4467e-01,2.4243e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.949287344668,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.4467e-01,2.4243e+00,5.3009e-03,1.2930e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.3009e-03,1.2930e+00,1.1316e-09,1.2618e+00,1.1437e-09,1.2569e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.989400395282,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.1437e-09,1.2569e+00,0.0000e+00,1.2253e+00,5.3009e-03,1.2208e+00})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.989400395282,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {5.3009e-03,1.2208e+00,3.4467e-01,8.9575e-02})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.4467e-01,8.9575e-02,3.3855e-01,4.7180e-02,3.9003e-01,2.4850e-02})).setKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.949287344668,1.0})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.7517e-01,2.0631e-01,1.0368e-01,1.2244e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0368e-01,1.2244e+00,1.0085e-01,1.2350e+00,9.9435e-02,1.2460e+00,9.9435e-02,1.2679e+00,1.0085e-01,1.2788e+00,1.0368e-01,1.2894e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.026160702,0.026160702,0.0523214041,0.0523214041,0.0523214041,0.0523214041}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0368e-01,1.2894e+00,3.7517e-01,2.3075e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {3.7517e-01,2.3075e+00,3.7916e-01,2.3225e+00,3.8593e-01,2.3366e+00,4.0365e-01,2.3597e+00,4.1391e-01,2.3690e+00,4.3291e-01,2.3799e+00,4.4055e-01,2.3831e+00,4.5603e-01,2.3871e+00,4.6373e-01,2.3881e+00,4.7148e-01,2.3881e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0369430681,0.0369430681,0.0696467568,0.0696467568,0.0894188447,0.0894188447,0.108002181,0.108002181,0.108002181,0.108002181}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.7148e-01,2.3881e+00,7.9888e-01,2.3881e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.9888e-01,2.3881e+00,8.1092e-01,2.3881e+00,8.2276e-01,2.3857e+00,8.4568e-01,2.3761e+00,8.5632e-01,2.3689e+00,8.7529e-01,2.3500e+00,8.8315e-01,2.3384e+00,8.9244e-01,2.3175e+00,8.9514e-01,2.3089e+00,8.9860e-01,2.2919e+00,8.9943e-01,2.2835e+00,8.9943e-01,2.2750e+00})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0287296871,0.0287296871,0.0592432804,0.0592432804,0.0923821538,0.0923821538,0.113607047,0.113607047,0.133674759,0.133674759,0.133674759,0.133674759}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.9943e-01,2.2750e+00,8.9943e-01,2.3881e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {8.9943e-01,2.3881e-01,8.9943e-01,2.2242e-01,8.9627e-01,2.0608e-01,8.8427e-01,1.7718e-01,8.7602e-01,1.6454e-01,8.5609e-01,1.4472e-01,8.4506e-01,1.3726e-01,8.2200e-01,1.2797e-01,8.1053e-01,1.2569e-01,7.9888e-01,1.2569e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0391192698,0.0391192698,0.0747531001,0.0747531001,0.106410535,0.106410535,0.134352733,0.134352733,0.134352733,0.134352733}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {7.9888e-01,1.2569e-01,4.7148e-01,1.2569e-01})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {4.7148e-01,1.2569e-01,4.5944e-01,1.2569e-01,4.4759e-01,1.2813e-01,4.2483e-01,1.3764e-01,4.1431e-01,1.4479e-01,3.9792e-01,1.6091e-01,3.9163e-01,1.6924e-01,3.8158e-01,1.8709e-01,3.7778e-01,1.9653e-01,3.7517e-01,2.0631e-01})).setKnot(new double[] {0.0,0.0,0.0,0.0,0.0287514233,0.0287514233,0.0588442799,0.0588442799,0.08353193,0.08353193,0.107609479,0.107609479,0.107609479,0.107609479}).setOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3738'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,8.0,8.0}).setVOrder(2).setWeight(new double[] {1.0,0.923879532302,1.0,1.0,0.923879532302,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,-6.4516e+02,-6.4516e+01,8.9408e+02,-5.9605e+02,-3.4916e+01,9.6774e+02,-6.2626e+02,-1.8896e+01,-9.6774e+02,-6.4516e+02,-6.4516e+01,-8.9408e+02,-5.9605e+02,-3.4916e+01,-9.6774e+02,-6.2626e+02,-1.8896e+01})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.0000e+00,0.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.0000e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor")))
        .addChild(new Shape()
          .setMetadata(new MetadataString().setName("instance").setValue(new String[] {"'#3745'"}))
          .setGeometry(new NurbsTrimmedSurface().setUDimension(3).setUKnot(new double[] {0.0,0.0,0.0,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,8.0,8.0}).setVOrder(2).setWeight(new double[] {1.0,0.923879532721,1.0,1.0,0.923879532721,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {9.6774e+02,-6.2626e+02,-1.8896e+01,8.9408e+02,-5.6113e+02,-9.4785e-15,9.6774e+02,-5.8064e+02,1.4211e-14,-9.6774e+02,-6.2626e+02,-1.8896e+01,-8.9408e+02,-5.6113e+02,-9.4785e-15,-9.6774e+02,-5.8064e+02,1.4211e-14})))
            .addTrimmingContour(new Contour2D()
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,8.0000e+00,0.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {0.0000e+00,0.0000e+00,1.0000e+00,0.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,0.0000e+00,1.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))
              .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {1.0000e+00,8.0000e+00,0.0000e+00,8.0000e+00})).setKnot(new double[] {0.0,0.0,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0}))))
          .setAppearance(new Appearance().setUSE("partcolor"))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Large attribute array: Coordinate point field, scene-graph level=8, element #168, 90 total numbers made up of 30 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_8_168_point()
		{
			MFVec3f Coordinate_8_168_point = new MFVec3f(new double[] {-2.6623e+02,-2.8650e+02,0.0000e+00,-1.3182e+02,-2.8650e+02,0.0000e+00,2.5840e+00,-9.1610e+01,0.0000e+00,2.5840e+00,-9.1610e+01,0.0000e+00,1.3027e+02,-2.8650e+02,0.0000e+00,2.6468e+02,-2.8650e+02,0.0000e+00,2.5840e+00,-9.1610e+01,0.0000e+00,2.6468e+02,-2.8650e+02,0.0000e+00,6.9788e+01,1.5917e+01,0.0000e+00,6.9788e+01,1.5917e+01,0.0000e+00,2.4452e+02,2.9145e+02,0.0000e+00,1.1011e+02,2.9145e+02,0.0000e+00,6.9788e+01,1.5917e+01,0.0000e+00,1.1011e+02,2.9145e+02,0.0000e+00,2.5840e+00,1.1672e+02,0.0000e+00,2.5840e+00,1.1672e+02,0.0000e+00,-1.1166e+02,2.9145e+02,0.0000e+00,-2.4607e+02,2.9145e+02,0.0000e+00,2.5840e+00,1.1672e+02,0.0000e+00,-2.4607e+02,2.9145e+02,0.0000e+00,-6.4620e+01,1.5917e+01,0.0000e+00,2.5840e+00,1.1672e+02,0.0000e+00,-6.4620e+01,1.5917e+01,0.0000e+00,-2.6623e+02,-2.8650e+02,0.0000e+00,2.5840e+00,1.1672e+02,0.0000e+00,-2.6623e+02,-2.8650e+02,0.0000e+00,2.5840e+00,-9.1610e+01,0.0000e+00,2.5840e+00,1.1672e+02,0.0000e+00,2.5840e+00,-9.1610e+01,0.0000e+00,6.9788e+01,1.5917e+01,0.0000e+00});
			return Coordinate_8_168_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return StampX3dLettersHalloween model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new StampX3dLettersHalloween().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.StampX3dLettersHalloween\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.StampX3dLettersHalloween self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/StampX3dLettersHalloween_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/StampX3dLettersHalloween_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/StampX3dLettersHalloween_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/StampX3dLettersHalloween_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
