package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry2D.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.NURBS.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Non-Uniform Rational B-Spline (NURBS) prototype definitions. </p>
 <p> Related links: Catalog page <a href="../../../NURBS/NurbsPrototypesIndex.html" target="_blank">NurbsPrototypes</a>,  source <a href="../../../NURBS/NurbsPrototypes.java">NurbsPrototypes.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/NurbsPrototypes.x3d">NurbsPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Non-Uniform Rational B-Spline (NURBS) prototype definitions. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Original blaxxun definitions heavily modified, X3D specification revisions by Don Brutzman, Charles Adams, Jeffrey Weekley and Alan Shaffer NPS. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 January 2000 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 18 March 2002 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Under development for final version of X3D NURBS nodes </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Not all NURBS nodes are prototyped here, and these implementations are not yet fully demonstrated. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/files/specifications/19775-1/V3.3/Part01/components/nurbs.html" target="_blank">https://www.web3d.org/files/specifications/19775-1/V3.3/Part01/components/nurbs.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.blaxxun.com/vrml/protos/nurbs.wrl" target="_blank">http://www.blaxxun.com/vrml/protos/nurbs.wrl</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> NurbsPrototypesOriginal.x3d.txt </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../NURBS/javadoc/index.html">javadoc/index.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> NURBS Prototypes </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../../license.html">../../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Original blaxxun definitions heavily modified, X3D specification revisions by Don Brutzman, Charles Adams, Jeffrey Weekley and Alan Shaffer NPS.
 */

public class NurbsPrototypes
{
	/** Default constructor to create this object. */
	public NurbsPrototypes ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addComponent(new component().setName("NURBS").setLevel(4))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("NurbsPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Non-Uniform Rational B-Spline (NURBS) prototype definitions."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Original blaxxun definitions heavily modified, X3D specification revisions by Don Brutzman, Charles Adams, Jeffrey Weekley and Alan Shaffer NPS."))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 January 2000"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("18 March 2002"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("Under development for final version of X3D NURBS nodes"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("Not all NURBS nodes are prototyped here, and these implementations are not yet fully demonstrated."))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/files/specifications/19775-1/V3.3/Part01/components/nurbs.html"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.blaxxun.com/vrml/protos/nurbs.wrl"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("NurbsPrototypesOriginal.x3d.txt"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("javadoc/index.html"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("NURBS Prototypes"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("NurbsPrototypes.x3d"))
    .addChild(new ProtoDeclare("Contour2D").setName("Contour2D").setAppinfo("Contour2D groups a set of curve segments to a composite contour Children segments form a closed loop with first point of first child repeated as last point of last child and last point of segment repeated as first point of consecutive segment Children segments are type NurbsCurve2D or Polyline2D enumerated in consecutive order of contour topology.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#Contour2D")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("addChildren").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[NurbsCurve|ContourPolyline2D]"))
        .addField(new field().setName("removeChildren").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[NurbsCurve|ContourPolyline2D]"))
        .addField(new field().setName("children").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[NurbsCurve|ContourPolyline2D]")
          .addComments(" default is empty node array "))
        .addField(new field().setName("set_children").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("children_changed").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addChild(new Group("Contour2DGroup")
          .setIS(new IS()
            .addConnect(new connect().setNodeField("addChildren").setProtoField("addChildren"))
            .addConnect(new connect().setNodeField("removeChildren").setProtoField("removeChildren"))
            .addConnect(new connect().setNodeField("children").setProtoField("children"))
            .addConnect(new connect().setNodeField("set_children").setProtoField("set_children"))
            .addConnect(new connect().setNodeField("children_changed").setProtoField("children_changed"))))
        .addComments(" consider adding a Script here to check that the children nodes are solely of type NurbsCurve2D and/or ContourPolyline2D ")))
    .addChild(new ProtoDeclare("ContourPolyline2D").setName("ContourPolyline2D").setAppinfo("ContourPolyline2D defines a linear curve segment as part of a trimming contour in u-v domain of a surface.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#ContourPolyline2D")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("point").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
          .addComments(" Specification definition: MFVec2f [in,out] point [] (-∞,∞) but we cannot match accessType inputOutput since there is no VRML 97 field that is MFVec2f [in,out]. Hence a known limitation. "))
        .addField(new field().setName("set_point").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("point_changed").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addComments(" Typical initial approach: group all body nodes together, since rendering is only affected by first Prototype child. Then, map interface field(s) to dummy-node field(s) so that a Script can USE and then manipulate them. ")
        .addChild(new Group("ContourPolyline2DGroup")
          .addChild(new Switch("HideDummy").setWhichChoice(-1)
            .addChild(new Shape()
              .setGeometry(new Extrusion("PointHolder")
                .setIS(new IS()
                  .addConnect(new connect().setNodeField("crossSection").setProtoField("point"))))))
          .addChild(new Script("ScriptContourPolyline2D-missingBody").setDirectOutput(true)
            .addField(new field().setName("PointHolder").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
              .addChild(new Extrusion().setUSE("PointHolder")))))))
    .addChild(new ProtoDeclare("CoordinateDouble").setName("CoordinateDouble").setAppinfo("CoordinateDouble builds geometry using a set of 3D coordinates. CoordinateDouble is used by IndexedFaceSet IndexedLineSet LineSet and PointSet. CoordinateDouble is also used by NurbsPositionInterpolator and NurbsOrientationInterpolator.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#CoordinateDouble")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("point").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Substitute MFVec3f for MFVec3d to provide VRML 97 support")
          .addComments(" Specification definition: MFVec3d [in,out] point [] (-∞,∞) "))
        .addField(new field().setName("set_point").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("point_changed").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addChild(new Coordinate()
          .setIS(new IS()
            .addConnect(new connect().setNodeField("point").setProtoField("point"))
            .addConnect(new connect().setNodeField("set_point").setProtoField("set_point"))
            .addConnect(new connect().setNodeField("point_changed").setProtoField("point_changed"))))
        .addComments(" no metadata holder, since there is no exposedField SFNode in VRML 97. metadata SFNode simply sits in the ProtoInterface. Run-time instantiation support may vary. ")))
    .addChild(new ProtoDeclare("NurbsCurve").setName("NurbsCurve").setAppinfo("NurbsCurve is a 3D curve analogous to NurbsPatchSurface. The container controlPoint field is a Coordinate or CoordinateDouble node.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsCurve")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode]")
          .addChild(new Coordinate()))
        .addField(new field().setName("tessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0).setAppinfo("range (-∞,∞)"))
        .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (0,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("closed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
        .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3).setAppinfo("range [2,∞)"))
        .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_tessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("tessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addChild(new IndexedLineSet("NurbsCurveLineSet").setDEF("NurbsCurveLineSet")
          .setCoord(new Coordinate("NurbsCurveCoord")))
        .addComments(" only first child of ProtoBody renders ")
        .addChild(new Switch().setWhichChoice(-1)
          .addChild(new Shape()
            .setGeometry(new IndexedFaceSet()
              .setIS(new IS()
                .addConnect(new connect().setNodeField("coord").setProtoField("controlPoint"))))))
        .addComments(" Warning: VRML97-style scripting, not X3D Scene Authoring Interface (SAI) ")
        .addChild(new Script("NurbsCurveScript").setDirectOutput(true).setMustEvaluate(true).setUrl(new String[] {"NurbsCurve.class","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsCurve.class"})
          .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("tessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("closed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_tessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("tessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("point").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("pointIndex").setType(field.TYPE_MFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("controlPoint").setProtoField("controlPoint"))
            .addConnect(new connect().setNodeField("tessellation").setProtoField("tessellation"))
            .addConnect(new connect().setNodeField("weight").setProtoField("weight"))
            .addConnect(new connect().setNodeField("closed").setProtoField("closed"))
            .addConnect(new connect().setNodeField("knot").setProtoField("knot"))
            .addConnect(new connect().setNodeField("order").setProtoField("order"))
            .addConnect(new connect().setNodeField("set_controlPoint").setProtoField("set_controlPoint"))
            .addConnect(new connect().setNodeField("controlPoint_changed").setProtoField("controlPoint_changed"))
            .addConnect(new connect().setNodeField("set_tessellation").setProtoField("set_tessellation"))
            .addConnect(new connect().setNodeField("tessellation_changed").setProtoField("tessellation_changed"))
            .addConnect(new connect().setNodeField("set_weight").setProtoField("set_weight"))
            .addConnect(new connect().setNodeField("weight_changed").setProtoField("weight_changed"))))
        .addChild(new ROUTE().setFromNode("NurbsCurveScript").setFromField("point").setToNode("NurbsCurveCoord").setToField("set_point"))
        .addChild(new ROUTE().setFromNode("NurbsCurveScript").setFromField("pointIndex").setToNode("NurbsCurveLineSet").setToField("set_coordIndex"))))
    .addChild(new ProtoDeclare("NurbsCurve2D").setName("NurbsCurve2D").setAppinfo("NurbsCurve2D defines a trimming segment that is part of trimming contour in u-v domain of surface NurbsCurve2D forming a closed contour may be used as Contour2D node.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsCurve2D")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("controlPoint").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("tessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0).setAppinfo("range (-∞,∞)"))
        .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (0,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3).setAppinfo("range [2,∞)"))
        .addField(new field().setName("closed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
        .addField(new field().setName("set_controlPoint").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("controlPoint_changed").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_tessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("tessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addChild(new Group("NurbsCurve2DGroup"))))
    .addChild(new ProtoDeclare("NurbsOrientationInterpolator").setName("NurbsOrientationInterpolator").setAppinfo("NurbsOrientationInterpolator describes a 3D NURBS Curve and outputs interpolated orientation values. The SFNode controlPoint field can contain a single Coordinate or CoordinateDouble node.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsOrientationInterpolator")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("set_fraction").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("range (-∞,∞)"))
        .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode]")
          .addChild(new Coordinate()))
        .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3).setAppinfo("range (2,∞)"))
        .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("value_changed").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("knot_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("order_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addComments(" Warning: VRML97-style scripting, not X3D Scene Authoring Interface (SAI) ")
        .addChild(new Script("NurbsOrientationInterpolatorScript").setDirectOutput(true).setMustEvaluate(true).setUrl(new String[] {"NurbsOrientationInterpolator.class","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsOrientationInterpolator.class"})
          .addField(new field().setName("set_fraction").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode]"))
          .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("value_changed").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("knot_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("order_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("set_fraction").setProtoField("set_fraction"))
            .addConnect(new connect().setNodeField("controlPoint").setProtoField("controlPoint"))
            .addConnect(new connect().setNodeField("knot").setProtoField("knot"))
            .addConnect(new connect().setNodeField("order").setProtoField("order"))
            .addConnect(new connect().setNodeField("weight").setProtoField("weight"))
            .addConnect(new connect().setNodeField("value_changed").setProtoField("value_changed"))
            .addConnect(new connect().setNodeField("set_controlPoint").setProtoField("set_controlPoint"))
            .addConnect(new connect().setNodeField("controlPoint_changed").setProtoField("controlPoint_changed"))
            .addConnect(new connect().setNodeField("set_knot").setProtoField("set_knot"))
            .addConnect(new connect().setNodeField("knot_changed").setProtoField("knot_changed"))
            .addConnect(new connect().setNodeField("set_order").setProtoField("set_order"))
            .addConnect(new connect().setNodeField("order_changed").setProtoField("order_changed"))
            .addConnect(new connect().setNodeField("set_weight").setProtoField("set_weight"))
            .addConnect(new connect().setNodeField("weight_changed").setProtoField("weight_changed"))))
        .addComments(" Nonrendering holder node for controlPoint Coordinate data ")
        .addChild(new Shape()
          .setGeometry(new PointSet()
            .setIS(new IS()
              .addConnect(new connect().setNodeField("coord").setProtoField("controlPoint")))))))
    .addChild(new ProtoDeclare("NurbsPatchSurface").setName("NurbsPatchSurface").setAppinfo("NurbsPatchSurface defines a contiguous 3D Non- rational Uniform B-Spline (NURBS) Surface.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsPatchSurface")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode]")
          .addChild(new Coordinate()))
        .addField(new field().setName("texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
          .addChild(new TextureCoordinate()))
        .addField(new field().setName("uTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0))
        .addField(new field().setName("vTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0))
        .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
          .addComments(" default is empty array "))
        .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(true))
        .addField(new field().setName("uClosed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
        .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0))
        .addField(new field().setName("uKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
          .addComments(" default is empty array "))
        .addField(new field().setName("uOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3))
        .addField(new field().setName("vClosed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
        .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0))
        .addField(new field().setName("vKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
          .addComments(" default is empty array "))
        .addField(new field().setName("vOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3))
        .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("texCoord_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_uTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("uTessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_vTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("vTessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addChild(new IndexedFaceSet("NurbsPatchSurfaceFaceSet").setDEF("NurbsPatchSurfaceFaceSet").setCreaseAngle(3.14).setSolid(false)
          .setIS(new IS()
            .addConnect(new connect().setNodeField("texCoord").setProtoField("texCoord"))
            .addConnect(new connect().setNodeField("solid").setProtoField("solid")))
          .setCoord(new Coordinate("NurbsPatchSurfaceCoordinate")))
        .addComments(" Warning: VRML97-style scripting, not X3D Scene Authoring Interface (SAI) ")
        .addChild(new Script("NurbsPatchSurfaceScript").setDirectOutput(true).setMustEvaluate(true).setUrl(new String[] {"NurbsPatchSurface.class","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPatchSurface.class"})
          .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode]"))
          .addField(new field().setName("texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("uTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("vTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("uClosed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("uKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("uOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("vClosed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("vKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("vOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("coord").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("coordIndex").setType(field.TYPE_MFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("texCoord_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_uTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("uTessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_vTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("vTessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("controlPoint").setProtoField("controlPoint"))
            .addConnect(new connect().setNodeField("texCoord").setProtoField("texCoord"))
            .addConnect(new connect().setNodeField("uTessellation").setProtoField("uTessellation"))
            .addConnect(new connect().setNodeField("vTessellation").setProtoField("vTessellation"))
            .addConnect(new connect().setNodeField("weight").setProtoField("weight"))
            .addConnect(new connect().setNodeField("solid").setProtoField("solid"))
            .addConnect(new connect().setNodeField("uClosed").setProtoField("uClosed"))
            .addConnect(new connect().setNodeField("uDimension").setProtoField("uDimension"))
            .addConnect(new connect().setNodeField("uKnot").setProtoField("uKnot"))
            .addConnect(new connect().setNodeField("uOrder").setProtoField("uOrder"))
            .addConnect(new connect().setNodeField("vClosed").setProtoField("vClosed"))
            .addConnect(new connect().setNodeField("vDimension").setProtoField("vDimension"))
            .addConnect(new connect().setNodeField("vKnot").setProtoField("vKnot"))
            .addConnect(new connect().setNodeField("vOrder").setProtoField("vOrder"))
            .addConnect(new connect().setNodeField("set_controlPoint").setProtoField("set_controlPoint"))
            .addConnect(new connect().setNodeField("controlPoint_changed").setProtoField("controlPoint_changed"))
            .addConnect(new connect().setNodeField("set_texCoord").setProtoField("set_texCoord"))
            .addConnect(new connect().setNodeField("texCoord_changed").setProtoField("texCoord_changed"))
            .addConnect(new connect().setNodeField("set_uTessellation").setProtoField("set_uTessellation"))
            .addConnect(new connect().setNodeField("uTessellation_changed").setProtoField("uTessellation_changed"))
            .addConnect(new connect().setNodeField("set_vTessellation").setProtoField("set_vTessellation"))
            .addConnect(new connect().setNodeField("vTessellation_changed").setProtoField("vTessellation_changed"))
            .addConnect(new connect().setNodeField("set_weight").setProtoField("set_weight"))
            .addConnect(new connect().setNodeField("weight_changed").setProtoField("weight_changed"))))
        .addChild(new ROUTE().setFromNode("NurbsPatchSurfaceScript").setFromField("coord").setToNode("NurbsPatchSurfaceCoordinate").setToField("set_point"))
        .addChild(new ROUTE().setFromNode("NurbsPatchSurfaceScript").setFromField("coordIndex").setToNode("NurbsPatchSurfaceFaceSet").setToField("set_coordIndex"))))
    .addChild(new ProtoDeclare("NurbsPositionInterpolator").setName("NurbsPositionInterpolator").setAppinfo("NurbsPositionInterpolator describes a 3D NURBS Curve and outputs interpolated position values. The SFNode controlPoint field can contain a single Coordinate or CoordinateDouble node.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsPositionInterpolator")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("set_fraction").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("range (-∞,∞)"))
        .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode]")
          .addChild(new Coordinate()))
        .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3).setAppinfo("range (2,∞)"))
        .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("value_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("knot_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("order_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addComments(" Warning: VRML97-style scripting, not X3D Scene Authoring Interface (SAI) ")
        .addChild(new Script("NurbsPositionInterpolatorScript").setDirectOutput(true).setMustEvaluate(true).setUrl(new String[] {"NurbsPositionInterpolator.class","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPositionInterpolator.class"})
          .addField(new field().setName("set_fraction").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode]"))
          .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("value_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("knot_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("order_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("set_fraction").setProtoField("set_fraction"))
            .addConnect(new connect().setNodeField("controlPoint").setProtoField("controlPoint"))
            .addConnect(new connect().setNodeField("knot").setProtoField("knot"))
            .addConnect(new connect().setNodeField("order").setProtoField("order"))
            .addConnect(new connect().setNodeField("weight").setProtoField("weight"))
            .addConnect(new connect().setNodeField("value_changed").setProtoField("value_changed"))
            .addConnect(new connect().setNodeField("set_controlPoint").setProtoField("set_controlPoint"))
            .addConnect(new connect().setNodeField("controlPoint_changed").setProtoField("controlPoint_changed"))
            .addConnect(new connect().setNodeField("set_knot").setProtoField("set_knot"))
            .addConnect(new connect().setNodeField("knot_changed").setProtoField("knot_changed"))
            .addConnect(new connect().setNodeField("set_order").setProtoField("set_order"))
            .addConnect(new connect().setNodeField("order_changed").setProtoField("order_changed"))
            .addConnect(new connect().setNodeField("set_weight").setProtoField("set_weight"))
            .addConnect(new connect().setNodeField("weight_changed").setProtoField("weight_changed"))))
        .addComments(" Nonrendering holder node for controlPoint Coordinate data ")
        .addChild(new Shape()
          .setGeometry(new PointSet()
            .setIS(new IS()
              .addConnect(new connect().setNodeField("coord").setProtoField("controlPoint")))))))
    .addChild(new ProtoDeclare("NurbsSet").setName("NurbsSet").setAppinfo("NurbsSet collects a set of NurbsPatchSurface nodes into a common group and treats NurbsPatchSurface set as a unit during tessellation thereby enforcing tessellation continuity along borders.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsSet")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("addGeometry").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[NurbsPatchSurface]"))
        .addField(new field().setName("removeGeometry").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[NurbsPatchSurface]"))
        .addField(new field().setName("geometry").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[NurbsPatchSurface]")
          .addComments(" default is empty node array "))
        .addField(new field().setName("tessellationScale").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1.0).setAppinfo("range (0,∞)"))
        .addField(new field().setName("bboxCenter").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(0.0,0.0,0.0)).setAppinfo("range (-∞,∞)"))
        .addField(new field().setName("bboxSize").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(new SFVec3f(-1.0,-1.0,-1.0)).setAppinfo("range [0,∞); [-1 -1 -1]"))
        .addField(new field().setName("set_geometry").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("geometry_changed").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_tessellationScale").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("tessellationScale_changed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addChild(new Group("NurbsSet")
          .setIS(new IS()
            .addConnect(new connect().setNodeField("addGeometry").setProtoField("addGeometry"))
            .addConnect(new connect().setNodeField("removeGeometry").setProtoField("removeGeometry"))
            .addConnect(new connect().setNodeField("geometry").setProtoField("geometry"))
            .addConnect(new connect().setNodeField("bboxCenter").setProtoField("bboxCenter"))
            .addConnect(new connect().setNodeField("bboxSize").setProtoField("bboxSize"))
            .addConnect(new connect().setNodeField("set_geometry").setProtoField("set_geometry"))
            .addConnect(new connect().setNodeField("geometry_changed").setProtoField("geometry_changed"))
            .addConnect(new connect().setNodeField("set_tessellationScale").setProtoField("set_tessellationScale"))
            .addConnect(new connect().setNodeField("tessellationScale_changed").setProtoField("tessellationScale_changed"))))))
    .addChild(new ProtoDeclare("NurbsSurfaceInterpolator").setName("NurbsSurfaceInterpolator").setAppinfo("NurbsSurfaceInterpolator describes a 3D NURBS Curve and outputs interpolated position and normal values. The SFNode controlPoint field can contain a single Coordinate or CoordinateDouble node.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsSurfaceInterpolator")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("set_fraction").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("range (-∞,∞)"))
        .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode]")
          .addChild(new Coordinate()))
        .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("position_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("normal_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0).setAppinfo("range [0,∞)"))
        .addField(new field().setName("uKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("uOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3).setAppinfo("range [2,∞)"))
        .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0).setAppinfo("range [0,∞)"))
        .addField(new field().setName("vKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("vOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3).setAppinfo("range [2,∞)"))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addChild(new IndexedFaceSet("NurbsSurfaceInterpolatorFaceSet").setDEF("NurbsSurfaceInterpolatorFaceSet").setCreaseAngle(3.14).setSolid(false)
          .setCoord(new Coordinate("NurbsSurfaceInterpolatorCoordinate")))
        .addComments(" Warning: VRML97-style scripting, not X3D Scene Authoring Interface (SAI) ")
        .addChild(new Script("NurbsSurfaceInterpolatorScript").setDirectOutput(true).setMustEvaluate(true).setUrl(new String[] {"NurbsSurfaceInterpolator.class","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsSurfaceInterpolator.class"})
          .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("uKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("uOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("vKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("vOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("coord").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("coordIndex").setType(field.TYPE_MFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("controlPoint").setProtoField("controlPoint"))
            .addConnect(new connect().setNodeField("weight").setProtoField("weight"))
            .addConnect(new connect().setNodeField("uDimension").setProtoField("uDimension"))
            .addConnect(new connect().setNodeField("uKnot").setProtoField("uKnot"))
            .addConnect(new connect().setNodeField("uOrder").setProtoField("uOrder"))
            .addConnect(new connect().setNodeField("vDimension").setProtoField("vDimension"))
            .addConnect(new connect().setNodeField("vKnot").setProtoField("vKnot"))
            .addConnect(new connect().setNodeField("vOrder").setProtoField("vOrder"))
            .addConnect(new connect().setNodeField("set_controlPoint").setProtoField("set_controlPoint"))
            .addConnect(new connect().setNodeField("controlPoint_changed").setProtoField("controlPoint_changed"))
            .addConnect(new connect().setNodeField("set_weight").setProtoField("set_weight"))
            .addConnect(new connect().setNodeField("weight_changed").setProtoField("weight_changed"))))
        .addChild(new ROUTE().setFromNode("NurbsSurfaceInterpolatorScript").setFromField("coord").setToNode("NurbsSurfaceInterpolatorCoordinate").setToField("set_point"))
        .addChild(new ROUTE().setFromNode("NurbsSurfaceInterpolatorScript").setFromField("coordIndex").setToNode("NurbsSurfaceInterpolatorFaceSet").setToField("set_coordIndex"))))
    .addChild(new ProtoDeclare("NurbsSweptSurface").setName("NurbsSweptSurface").setAppinfo("NurbsSweptSurface contains a crossSectionCurve [X3DNurbsControlCurveNode] and a trajectoryCurve [NurbsCurve]").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsSweptSurface")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("crossSectionCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DNurbsControlCurveNode]")
          .addComments(" put default node here... "))
        .addField(new field().setName("trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[NurbsCurve]")
          .addComments(" put default node here... "))
        .addField(new field().setName("ccw").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(true))
        .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(true))
        .addField(new field().setName("set_crossSectionCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[X3DNurbsControlCurveNode]"))
        .addField(new field().setName("crossSectionCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY).setAppinfo("[X3DNurbsControlCurveNode]"))
        .addField(new field().setName("set_trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[NurbsCurve]"))
        .addField(new field().setName("trajectoryCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY).setAppinfo("[NurbsCurve]"))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addChild(new IndexedFaceSet("NurbsSweptSurfaceFaceSet").setDEF("NurbsSweptSurfaceFaceSet").setCreaseAngle(3.14).setSolid(false)
          .setIS(new IS()
            .addConnect(new connect().setNodeField("ccw").setProtoField("ccw"))
            .addConnect(new connect().setNodeField("solid").setProtoField("solid")))
          .setCoord(new Coordinate("NurbsSweptSurfaceCoordinate")))
        .addComments(" Warning: VRML97-style scripting, not X3D Scene Authoring Interface (SAI) ")
        .addChild(new Script("NurbsSweptSurfaceScript").setDirectOutput(true).setMustEvaluate(true).setUrl(new String[] {"NurbsSweptSurface.class","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsSweptSurface.class"})
          .addField(new field().setName("crossSectionCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DNurbsControlCurveNode]"))
          .addField(new field().setName("trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[NurbsCurve]"))
          .addField(new field().setName("ccw").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("set_crossSectionCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[X3DNurbsControlCurveNode]"))
          .addField(new field().setName("crossSectionCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY).setAppinfo("[X3DNurbsControlCurveNode]"))
          .addField(new field().setName("set_trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[NurbsCurve]"))
          .addField(new field().setName("trajectoryCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY).setAppinfo("[NurbsCurve]"))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("crossSectionCurve").setProtoField("crossSectionCurve"))
            .addConnect(new connect().setNodeField("trajectoryCurve").setProtoField("trajectoryCurve"))
            .addConnect(new connect().setNodeField("ccw").setProtoField("ccw"))
            .addConnect(new connect().setNodeField("solid").setProtoField("solid"))
            .addConnect(new connect().setNodeField("set_crossSectionCurve").setProtoField("set_crossSectionCurve"))
            .addConnect(new connect().setNodeField("crossSectionCurve_changed").setProtoField("crossSectionCurve_changed"))
            .addConnect(new connect().setNodeField("set_trajectoryCurve").setProtoField("set_trajectoryCurve"))
            .addConnect(new connect().setNodeField("trajectoryCurve_changed").setProtoField("trajectoryCurve_changed"))))
        .addChild(new ROUTE().setFromNode("NurbsSweptSurfaceScript").setFromField("crossSectionCurve_changed").setToNode("NurbsSweptSurfaceFaceSet").setToField("coord"))
        .addChild(new ROUTE().setFromNode("NurbsSweptSurfaceScript").setFromField("coordIndex").setToNode("NurbsSweptSurfaceFaceSet").setToField("set_coordIndex"))))
    .addChild(new ProtoDeclare("NurbsSwungSurface").setName("NurbsSwungSurface").setAppinfo("NurbsSwungSurface contains a profileCurve [X3DNurbsControlCurveNode] and a trajectoryCurve [X3DNurbsControlCurveNode]").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsSwungSurface")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("profileCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[X3DNurbsControlCurveNode]"))
        .addField(new field().setName("trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[X3DNurbsControlCurveNode]"))
        .addField(new field().setName("ccw").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(true))
        .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(true))
        .addField(new field().setName("set_profileCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("profileCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("trajectoryCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addChild(new IndexedFaceSet("NurbsSwungSurfaceFaceSet").setDEF("NurbsSwungSurfaceFaceSet").setCreaseAngle(3.14).setSolid(false)
          .setIS(new IS()
            .addConnect(new connect().setNodeField("ccw").setProtoField("ccw"))
            .addConnect(new connect().setNodeField("solid").setProtoField("solid")))
          .setCoord(new Coordinate("NurbsSwungSurfaceCoordinate")))
        .addComments(" Warning: VRML97-style scripting, not X3D Scene Authoring Interface (SAI) ")
        .addChild(new Script("NurbsSwungSurfaceScript").setDirectOutput(true).setMustEvaluate(true).setUrl(new String[] {"NurbSwungSurface.class","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbSwungSurface.class"})
          .addField(new field().setName("profileCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[X3DNurbsControlCurveNode]"))
          .addField(new field().setName("trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[X3DNurbsControlCurveNode]"))
          .addField(new field().setName("ccw").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("set_profileCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("profileCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .addField(new field().setName("set_trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
          .addField(new field().setName("trajectoryCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("profileCurve").setProtoField("profileCurve"))
            .addConnect(new connect().setNodeField("trajectoryCurve").setProtoField("trajectoryCurve"))
            .addConnect(new connect().setNodeField("ccw").setProtoField("ccw"))
            .addConnect(new connect().setNodeField("solid").setProtoField("solid"))
            .addConnect(new connect().setNodeField("set_profileCurve").setProtoField("set_profileCurve"))
            .addConnect(new connect().setNodeField("profileCurve_changed").setProtoField("profileCurve_changed"))
            .addConnect(new connect().setNodeField("set_trajectoryCurve").setProtoField("set_trajectoryCurve"))
            .addConnect(new connect().setNodeField("trajectoryCurve_changed").setProtoField("trajectoryCurve_changed"))))
        .addChild(new ROUTE().setFromNode("NurbsSwungSurfaceScript").setFromField("coord").setToNode("NurbsSwungSurfaceCoordinate").setToField("set_point"))
        .addChild(new ROUTE().setFromNode("NurbsSwungSurfaceScript").setFromField("coordIndex").setToNode("NurbsSwungSurfaceFaceSet").setToField("set_coordIndex"))))
    .addChild(new ProtoDeclare("NurbsTextureCoordinate").setName("NurbsTextureCoordinate").setAppinfo("NurbsTextureCoordinate describes a 3D NURBS surface in the parametric domain of its surface host specifying mapping of texture onto the surface. The SFNode controlPoint field can contain a single Coordinate or CoordinateDouble node.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsTextureCoordinate")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("controlPoint").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("weight").setType(field.TYPE_MFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (0,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0).setAppinfo("range [0,∞)"))
        .addField(new field().setName("uKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("uOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3).setAppinfo("range [2,∞)"))
        .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0).setAppinfo("range [0,∞)"))
        .addField(new field().setName("vKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("vOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3).setAppinfo("range [2,∞)"))
        .addField(new field().setName("set_controlPoint").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("controlPoint_changed").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_weight").setType(field.TYPE_MFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("weight_changed").setType(field.TYPE_MFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node ")))
      .setProtoBody(new ProtoBody()
        .addChild(new IndexedLineSet("NurbsTextureCoordinateIls").setDEF("NurbsTextureCoordinateIls").setCoordIndex(new int[] {1,2,3,-1,5,6,7,-1})
          .setCoord(new Coordinate("NurbsTextureCoordinateIlsCoordinate")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("point").setProtoField("controlPoint")))))
        .addChild(new Script("NurbsTextureCoordinateScript").setDirectOutput(true).setSourceCode("""
ecmascript:
function initialize() {
        //Browser.println ('Sorry, your browser does not support NURBS nodes');
        counter = 0;
        number = 0;
        localCoordIndex = new MFInt32();
        localCoordIndex.length = 2*vDimension * uDimension + uDimension + vDimension;

        for(v=0; v<vDimension;v++)
        {
                for(u=0; u<uDimension;u++)
                {
                        localCoordIndex[counter] = number;
                        counter++;
                        number++;
                }
                localCoordIndex[counter] = -1; counter++;
        }

        for(u=0; u<uDimension;u++)
        {
                for(v=0; v<vDimension;v++)
                {
                        localCoordIndex[counter] = v*uDimension + u;
                        counter++;
                        number++;
                }
                localCoordIndex[counter] = -1; counter++;
        }
        ils.set_coordIndex = localCoordIndex;
}
""")
          .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("ils").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
            .addChild(new IndexedLineSet().setUSE("NurbsTextureCoordinateIls")))
          .addField(new field().setName("localCoordIndex").setType(field.TYPE_MFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
            .addComments(" local computations array prior to sending completed event "))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("uDimension").setProtoField("uDimension"))
            .addConnect(new connect().setNodeField("vDimension").setProtoField("vDimension"))))))
    .addChild(new ProtoDeclare("NurbsTrimmedCoordinate").setName("NurbsTrimmedCoordinate").setAppinfo("NurbsTrimmedSurface generates texture coordinates from a Non-rational Uniform B-Spline (NURBS) surface.").setDocumentation("https://www.web3d.org/x3d/content/X3dTooltips.html#NurbsTrimmedSurface")
      .setProtoInterface(new ProtoInterface()
        .addField(new field().setName("addTrimmingContour").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("Contour2D"))
        .addField(new field().setName("removeTrimmingContour").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("Contour2D"))
        .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode]")
          .addChild(new Coordinate()))
        .addField(new field().setName("texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("X3DTextureCoordinateNode|NurbsTextureCoordinate")
          .addChild(new TextureCoordinate()))
        .addField(new field().setName("trimmingContour").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("Contour2D")
          .addChild(new Contour2D()))
        .addField(new field().setName("uTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0).setAppinfo("range (-∞,∞)"))
        .addField(new field().setName("vTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0).setAppinfo("range (-∞,∞)"))
        .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (0,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(true))
        .addField(new field().setName("uClosed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
        .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0).setAppinfo("range [0,∞)"))
        .addField(new field().setName("uKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("uOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3).setAppinfo("range [2,∞)"))
        .addField(new field().setName("vClosed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(false))
        .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(0).setAppinfo("range [0,∞)"))
        .addField(new field().setName("vKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞)")
          .addComments(" default is empty array "))
        .addField(new field().setName("vOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(3).setAppinfo("range [2,∞)"))
        .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("texCoord_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_trimmingContour").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("trimmingContour_changed").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_uTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("uTessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_vTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("vTessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
        .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")
          .addComments(" Specification initialization: NULL node "))
        .addField(new field().setName("localCoordIndex").setType(field.TYPE_MFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
          .addComments(" local computations array prior to sending completed event ")))
      .setProtoBody(new ProtoBody()
        .addChild(new IndexedLineSet("NurbsTextureSurfaceIls").setDEF("NurbsTextureSurfaceIls").setCoordIndex(new int[] {1,2,3,-1,5,6,7,-1})
          .setCoord(new Coordinate("NurbsTextureSurfaceIlsCoordinate")
            .setIS(new IS()
              .addConnect(new connect().setNodeField("point").setProtoField("controlPoint")))))
        .addChild(new Script("NurbsTextureSurfaceScript").setDirectOutput(true).setSourceCode("""
ecmascript:
function initialize() {
    //Browser.println ('Sorry, your browser does not support NURBS nodes');
    counter = 0;
    number = 0;
    localCoordIndex = new MFInt32();
    localCoordIndexlength = 2*vDimension * uDimension + uDimension + vDimension;

    for(v=0; v<vDimension;v++)
    {
            for(u=0; u<uDimension;u++)
            {
                    localCoordIndex[counter] = number;
                    counter++;
                    number++;
            }
            localCoordIndex[counter] = -1; counter++;
    }
    for(u=0; u<uDimension;u++)
    {
            for(v=0; v<vDimension;v++)
            {
                    localCoordIndex[counter] = v*uDimension + u;
                    counter++;
                    number++;
            }
            localCoordIndex[counter] = -1; counter++;
    }
    ils.set_coordIndex = localCoordIndex;
}
""")
          .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY))
          .addField(new field().setName("ils").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY)
            .addChild(new IndexedLineSet().setUSE("NurbsTextureSurfaceIls")))
          .setIS(new IS()
            .addConnect(new connect().setNodeField("uDimension").setProtoField("uDimension"))
            .addConnect(new connect().setNodeField("vDimension").setProtoField("vDimension"))))))
    .addChild(new Shape()
      .setAppearance(new Appearance()
        .setMaterial(new Material().setDiffuseColor(0.8,0.6,0.2)))
      .setGeometry(new Text().setString(new String[] {"NurbsPrototypes is a","developmental file for","Nurbs implementations."})
        .setFontStyle(new FontStyle().setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.7)))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return NurbsPrototypes model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new NurbsPrototypes().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.NurbsPrototypes\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.NurbsPrototypes self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/NurbsPrototypes_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/NurbsPrototypes_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/NurbsPrototypes_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/NurbsPrototypes_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
