package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.NURBS.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ImageTexture applied to animated NURBS patch using NurbsPatchSurface. Compare regular animation rendering to wireframe-mode rendering (if supported by X3D/VRML browser) in order to observe dynamic tessellation. </p>
 <p> Related links: Catalog page <a href="../../../NURBS/NurbsPatchSurfaceExampleWithOahuTextureIndex.html" target="_blank">NurbsPatchSurfaceExampleWithOahuTexture</a>,  source <a href="../../../NURBS/NurbsPatchSurfaceExampleWithOahuTexture.java">NurbsPatchSurfaceExampleWithOahuTexture.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/NurbsPatchSurfaceExampleWithOahuTexture.x3d">NurbsPatchSurfaceExampleWithOahuTexture.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ImageTexture applied to animated NURBS patch using NurbsPatchSurface. Compare regular animation rendering to wireframe-mode rendering (if supported by X3D/VRML browser) in order to observe dynamic tessellation. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Jeffrey Weekley, Charles Adams </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 6 February 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> missing default values for knot and weight array fields in NurbsPatchSurface (weight default: all 1 values) ; not required by X3D specification, but some browsers may fail without them. </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> under development, needs to be upgraded to final version of X3D NURBS nodes </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> acknowledgement </i> </td>
			<td> Oahu image prepared by David Colleen and Planet 9 Inc. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.planet9.com" target="_blank">http://www.planet9.com</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> NURBS Surface Example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPatchSurfaceExampleWithOahuTexture.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPatchSurfaceExampleWithOahuTexture.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Jeffrey Weekley, Charles Adams
 */

public class NurbsPatchSurfaceExampleWithOahuTexture
{
	/** Default constructor to create this object. */
	public NurbsPatchSurfaceExampleWithOahuTexture ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addComponent(new component().setName("NURBS").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("NurbsPatchSurfaceExampleWithOahuTexture.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ImageTexture applied to animated NURBS patch using NurbsPatchSurface. Compare regular animation rendering to wireframe-mode rendering (if supported by X3D/VRML browser) in order to observe dynamic tessellation."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Jeffrey Weekley, Charles Adams"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("6 February 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("missing default values for knot and weight array fields in NurbsPatchSurface (weight default: all 1 values) ; not required by X3D specification, but some browsers may fail without them."))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("under development, needs to be upgraded to final version of X3D NURBS nodes"))
    .addMeta(new meta().setName("acknowledgement").setContent("Oahu image prepared by David Colleen and Planet 9 Inc."))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.planet9.com"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("NURBS Surface Example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPatchSurfaceExampleWithOahuTexture.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("NurbsPatchSurfaceExampleWithOahuTexture.x3d"))
    .addChild(new Viewpoint().setDescription("animatedPlane").setPosition(3.0,2.0,40.0))
    .addChild(new Transform().setRotation(1.0,0.0,0.0,-1.5)
      .addChild(new Shape()
        .setGeometry(new NurbsPatchSurface("NS").setSolid(false).setUDimension(5).setUOrder(4).setUTessellation(30).setVDimension(5).setVOrder(4).setVTessellation(30)
          .setControlPoint(new Coordinate("NC").setPoint(new MFVec3f(new double[] {-10.0,-10.0,0.0,-10.0,-5.0,0.0,-10.0,0.0,0.0,-10.0,5.0,0.0,-10.0,10.0,0.0,-5.0,-10.0,0.0,-5.0,-5.0,2.5,-5.0,0.0,5.0,-5.0,5.0,2.5,-5.0,10.0,0.0,0.0,-10.0,0.0,0.0,-5.0,2.5,0.0,0.0,5.0,0.0,5.0,2.5,0.0,10.0,0.0,5.0,-10.0,0.0,5.0,-5.0,2.5,5.0,0.0,15.0,5.0,5.0,2.5,5.0,10.0,0.0,10.0,-10.0,0.0,10.0,-5.0,0.0,10.0,0.0,0.0,10.0,5.0,0.0,10.0,10.0,0.0}))))
        .setAppearance(new Appearance()
          .setTexture(new ImageTexture().setUrl(new String[] {"PearlHarborLowResolution.jpg","https://savage.nps.edu/Savage/Locations/Hawaii/PearlHarborLowResolution.jpg"})))))
    .addChild(new TimeSensor("TS").setCycleInterval(6).setLoop(true))
    .addChild(new CoordinateInterpolator("CI").setKey(new double[] {0.0,.5,1.0}).setKeyValue(new MFVec3f(new double[] {-10.0,-10.0,0.0,-10.0,-5.0,0.0,-10.0,0.0,0.0,-10.0,5.0,0.0,-10.0,10.0,0.0,-5.0,-10.0,0.0,-5.0,-5.0,2.5,-5.0,0.0,5.0,-5.0,5.0,2.5,-5.0,10.0,0.0,0.0,-10.0,0.0,0.0,-5.0,2.5,0.0,0.0,5.0,0.0,5.0,2.5,0.0,10.0,0.0,5.0,-10.0,0.0,5.0,-5.0,2.5,5.0,0.0,15.0,5.0,5.0,2.5,5.0,10.0,0.0,10.0,-10.0,0.0,10.0,-5.0,0.0,10.0,0.0,0.0,10.0,5.0,0.0,10.0,10.0,0.0,-10.0,-10.0,0.0,-10.0,-5.0,0.0,-10.0,0.0,0.0,-10.0,5.0,0.0,-10.0,10.0,0.0,-5.0,-10.0,0.0,-5.0,-5.0,0.0,-5.0,0.0,0.0,-5.0,5.0,0.0,-5.0,10.0,0.0,0.0,-10.0,0.0,0.0,-5.0,0.0,0.0,0.0,0.0,0.0,5.0,0.0,0.0,10.0,0.0,5.0,-10.0,0.0,5.0,-5.0,0.0,5.0,0.0,0.0,5.0,5.0,0.0,5.0,10.0,0.0,10.0,-10.0,0.0,10.0,-5.0,0.0,10.0,0.0,0.0,10.0,5.0,0.0,10.0,10.0,0.0,-10.0,-10.0,0.0,-10.0,-5.0,0.0,-10.0,0.0,0.0,-10.0,5.0,0.0,-10.0,10.0,0.0,-5.0,-10.0,0.0,-5.0,-5.0,2.5,-5.0,0.0,5.0,-5.0,5.0,2.5,-5.0,10.0,0.0,0.0,-10.0,0.0,0.0,-5.0,2.5,0.0,0.0,5.0,0.0,5.0,2.5,0.0,10.0,0.0,5.0,-10.0,0.0,5.0,-5.0,2.5,5.0,0.0,15.0,5.0,5.0,2.5,5.0,10.0,0.0,10.0,-10.0,0.0,10.0,-5.0,0.0,10.0,0.0,0.0,10.0,5.0,0.0,10.0,10.0,0.0})))
    .addChild(new ROUTE().setFromNode("TS").setFromField("fraction_changed").setToNode("CI").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("CI").setFromField("value_changed").setToNode("NC").setToField("set_point")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return NurbsPatchSurfaceExampleWithOahuTexture model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new NurbsPatchSurfaceExampleWithOahuTexture().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.NurbsPatchSurfaceExampleWithOahuTexture\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.NurbsPatchSurfaceExampleWithOahuTexture self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/NurbsPatchSurfaceExampleWithOahuTexture_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/NurbsPatchSurfaceExampleWithOahuTexture_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/NurbsPatchSurfaceExampleWithOahuTexture_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/NurbsPatchSurfaceExampleWithOahuTexture_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
