package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.NURBS.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Animated NURBS patchype. </p>
 <p> Related links: Catalog page <a href="../../../NURBS/NurbsPatchSurfaceExampleLargeIndex.html" target="_blank">NurbsPatchSurfaceExampleLarge</a>,  source <a href="../../../NURBS/NurbsPatchSurfaceExampleLarge.java">NurbsPatchSurfaceExampleLarge.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/NurbsPatchSurfaceExampleLarge.x3d">NurbsPatchSurfaceExampleLarge.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Animated NURBS patchype </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Jeffrey Weekley, Charles Adams </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 6 February 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 2 December 2024 </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> missing default values for knot and weight array fields in NurbsPatchSurface (weight default: all 1 values) ; not required by X3D specification, but some browsers may fail without them. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf" target="_blank">http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf</a> </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> under development, needs to be upgraded to final version of X3D NURBS nodes </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> NURBS Surface Example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPatchSurfaceExampleLarge.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPatchSurfaceExampleLarge.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Jeffrey Weekley, Charles Adams
 */

public class NurbsPatchSurfaceExampleLarge
{
	/** Default constructor to create this object. */
	public NurbsPatchSurfaceExampleLarge ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addComponent(new component().setName("NURBS").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("NurbsPatchSurfaceExampleLarge.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Animated NURBS patchype"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Jeffrey Weekley, Charles Adams"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("6 February 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("2 December 2024"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("missing default values for knot and weight array fields in NurbsPatchSurface (weight default: all 1 values) ; not required by X3D specification, but some browsers may fail without them."))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("under development, needs to be upgraded to final version of X3D NURBS nodes"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("NURBS Surface Example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPatchSurfaceExampleLarge.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("NurbsPatchSurfaceExampleLarge.x3d"))
    .addChild(new Viewpoint().setDescription("animatedPlane").setPosition(3.0,2.0,90.0))
    .addChild(new Transform().setRotation(1.0,0.0,0.0,-1.5)
      .addChild(new Shape()
        .addComments(" ccw=\"true\" ")
        .setGeometry(new NurbsPatchSurface("NS").setSolid(false).setUDimension(6).setUTessellation(16).setVDimension(6).setVTessellation(16)
          .setControlPoint(new Coordinate("NC").setPoint(getNC_6_17_point())))
        .setAppearance(new Appearance()
          .setMaterial(new Material().setDiffuseColor(1.0,1.0,0.0)))))
    .addChild(new CoordinateInterpolator("CI").setKey(new double[] {0.0,0.03,0.06,0.09,0.12,0.15,0.18,0.21,0.24,0.27,0.3,0.33,0.36,0.39,0.42,0.45,0.48,0.51,0.54,0.57,0.6,0.63,0.66,0.69,0.72,0.75,0.78,0.81,0.84,0.87,0.9,0.93,0.96,0.99,1.0}).setKeyValue(getCI_3_23_keyValue()))
    .addChild(new TimeSensor("TS").setCycleInterval(6).setLoop(true))
    .addChild(new ROUTE().setFromNode("TS").setFromField("fraction_changed").setToNode("CI").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("CI").setFromField("value_changed").setToNode("NC").setToField("set_point"))
    .addChild(new Group()
      .addComments(" ======= ROUTE Trace ============================================== ")
      .addChild(new Script("Trace_ROUTE_CI_value_changed_TO_NC_set_point").setMustEvaluate(true).setSourceCode("""
ecmascript:
    function traceValue (eventValue, timeStamp) {
      // input eventValue received for trace field
      if (timeStamp - timeStampPreviousReport >= reportInterval) {
        Browser.println ('Trace_ROUTE_CI_value_changed_TO_NC_set_point type=MFVec3f value=' + eventValue.toString());
        timeStampPreviousReport = timeStamp;
      }
    }
    function timeOfDay (someTime) {
      hh = Math.floor (someTime /(60*60)) % 24;
      mm = Math.floor (someTime / 60)     % 60;
      ss = Math.floor (someTime)          % 60;
      if (hh < 9) hour   = '0' + hh;
      else        hour   =       hh;
      if (mm < 9) minute = '0' + mm;
      else        minute =       mm;
      if (ss < 9) second = '0' + ss;
      else        second =       ss;
      return '(' + hour + ':' + minute + ':' + second + ' GMT)';
    }
""")
        .addComments(" Trace ROUTEd event values on X3D browser console ")
        .addField(new field().setName("reportInterval").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1.0).setAppinfo("Sampling frequency in seconds (0 means all values)"))
        .addField(new field().setName("traceValue").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("timeStampPreviousReport").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(-1)))
      .addChild(new ROUTE().setFromNode("CI").setFromField("value_changed").setToNode("Trace_ROUTE_CI_value_changed_TO_NC_set_point").setToField("traceValue"))
      .addComments(" ======= ROUTE Trace block complete ===================================================== "))
    .addChild(new Group()
      .addComments(" ======= ROUTE Trace ============================================== ")
      .addChild(new Script("Trace_ROUTE_CI.value_changed_TO_NC.controlPoint").setMustEvaluate(true).setSourceCode("""
ecmascript:
    function traceValue (eventValue, timeStamp) {
      // input eventValue received for trace field
      if (timeStamp - timeStampPreviousReport >= reportInterval) {
        Browser.println ('Trace_ROUTE_CI.value_changed_TO_NC.controlPoint type=MFVec3f value=' + eventValue.toString());
        timeStampPreviousReport = timeStamp;
      }
    }
    function timeOfDay (someTime) {
      hh = Math.floor (someTime /(60*60)) % 24;
      mm = Math.floor (someTime / 60)     % 60;
      ss = Math.floor (someTime)          % 60;
      if (hh < 9) hour   = '0' + hh;
      else        hour   =       hh;
      if (mm < 9) minute = '0' + mm;
      else        minute =       mm;
      if (ss < 9) second = '0' + ss;
      else        second =       ss;
      return '(' + hour + ':' + minute + ':' + second + ' GMT)';
    }
""")
        .addComments(" Trace ROUTEd event values on X3D browser console ")
        .addField(new field().setName("reportInterval").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(1.0).setAppinfo("Sampling frequency in seconds (0 means all values)"))
        .addField(new field().setName("traceValue").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
        .addField(new field().setName("timeStampPreviousReport").setType(field.TYPE_SFTIME).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setValue(-1)))
      .addChild(new ROUTE().setFromNode("CI").setFromField("value_changed").setToNode("Trace_ROUTE_CI.value_changed_TO_NC.controlPoint").setToField("traceValue"))
      .addComments(" ======= ROUTE Trace block complete ===================================================== ")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method


		/** Define subarrays using type double[] */
		private double[] getCI_3_23_keyValue_1()
		{
			double[] value = {75.82,17.78,71.43,91.74,25.41,42.86,89.07,24.23,14.29,99.77,29.33,-14.29,75.61,17.64,-42.86,54.14,7.318,-71.43,55.34,50.68,71.43,65.76,63.66,42.86,59.54,56.03,14.29,64.85,62.6,-14.29,49.27,43.0,-42.86,18.77,4.802,-71.43,18.83,63.82,71.43,19.36,65.95,42.86,15.26,48.35,14.29,18.89,64.07,-14.29,13.78,41.55,-42.86,11.13,30.01,-71.43,-17.99,60.05,71.43,-16.47,53.52,42.86,-17.92,59.54,14.29,-17.39,57.4,-14.29,-15.62,49.8,-42.86,-15.98,51.32,-71.43,-46.53,39.6,71.43,-53.82,48.81,42.86,-43.91,36.25,14.29,-56.01,51.49,-14.29,-45.23,38.03,-42.86,-43.38,35.69,-71.43,-48.1,4.427,71.43,-52.09,6.38,42.86,-51.97,6.26,14.29,-66.43,13.26,-14.29,-58.74,9.592,-42.86,-52.93,6.775,-71.43,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-57.37,-18.72,71.43,-49.52,-18.7,42.86,-63.38,-18.75,14.29,-86.03,-18.7,-14.29,-58.33,-18.69,-42.86,-54.72,-18.7,-71.43,-93.95,-18.72,-100.0,-63.05,11.61,-100.0,-51.48,45.78,-100.0,-16.27,52.42,-100.0,12.49,36.1,-100.0,22.24,9.179,-100.0,52.96,6.788,-100.0,69.14,-18.71,-100.0,66.9,-18.76,-71.43,82.85,-18.77,-42.86,82.1,-18.73,-14.29,79.2,-18.69,14.29,114.5,-18.77,42.86,78.93,-18.73,71.43,89.87,23.2,64.87,95.55,31.71,35.89,84.38,27.32,8.123,85.73,32.64,-20.54,89.61,39.77,-49.39,66.53,26.38,-76.29,61.64,54.77,68.86,62.51,60.43,40.26,57.2,55.84,11.9,56.12,58.45,-16.62,36.45,30.89,-44.37,34.91,32.44,-72.88,24.63,87.07,71.09,21.55,74.97,42.57,18.99,64.95,14.03,17.88,63.73,-14.53,14.84,51.7,-43.06,10.99,34.9,-71.58,-22.8,76.69,71.12,-19.85,64.91,42.59,-14.96,43.49,14.08,-15.05,47.7,-14.49,-13.9,45.69,-43.05,-14.72,54.63,-71.63,-67.25,63.63,68.63,-54.35,46.94,40.59,-50.08,44.4,12.2,-37.95,28.86,-15.87,-30.21,20.54,-44.12,-35.1,32.71,-72.89,-77.66,13.88,65.76,-82.48,21.64,36.83,-66.16,13.6,9.461,-64.16,16.16,-18.97,-48.77,8.704,-46.42,-28.03,-2.711,-73.47};
			return value;
		}
		private double[] getCI_3_23_keyValue_2()
		{
			double[] value = {100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-82.81,-21.09,62.24,-77.3,-18.52,34.28,-86.18,-11.74,4.73,-99.91,-3.745,-25.38,-74.43,-6.854,-51.12,-32.32,-14.64,-75.01,-47.4,-6.139,-105.3,-46.18,15.19,-103.4,-34.13,35.37,-101.4,-12.38,46.42,-100.2,7.927,22.63,-100.1,27.34,24.37,-101.1,69.84,33.01,-105.1,74.84,1.648,-108.3,81.44,-0.6089,-80.47,85.66,-3.48,-52.36,95.05,-4.981,-24.83,97.21,-8.634,3.494,120.7,-5.988,29.47,123.6,-9.371,57.72,82.62,15.62,62.27,86.79,28.38,33.23,91.47,41.83,4.131,81.69,39.25,-23.34,67.27,31.1,-50.33,54.3,24.92,-77.45,64.09,59.84,67.31,62.17,63.66,38.85,56.92,60.6,10.61,49.57,53.4,-17.48,36.8,34.09,-45.23,27.54,22.76,-73.2,19.93,58.86,71.01,15.33,35.01,42.53,16.14,48.58,13.94,12.61,33.4,-14.55,12.39,39.48,-43.12,11.0,38.95,-71.66,-20.04,57.58,71.0,-15.91,38.58,42.52,-13.39,29.96,14.0,-8.992,7.89,-14.48,-10.7,28.25,-43.08,-12.95,51.06,-71.7,-64.97,60.96,67.23,-53.79,45.64,39.39,-48.46,42.59,11.17,-37.25,26.68,-16.69,-42.45,46.28,-45.59,-32.63,33.3,-73.53,-86.65,19.75,61.81,-88.77,30.55,33.01,-73.78,22.0,6.107,-79.44,36.44,-23.1,-49.64,11.35,-48.36,-42.28,11.2,-76.12,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-92.64,-19.92,56.27,-109.8,-0.8995,24.91,-97.28,-0.3943,-1.612,-105.5,12.83,-31.54,-80.23,5.499,-55.96,-41.66,-10.35,-78.24,-34.42,-6.591,-105.6,-46.69,24.45,-105.2,-27.54,30.75,-101.8,-10.03,39.85,-100.2,9.458,36.46,-100.2,26.85,29.45,-101.7,59.21,38.61,-106.6,88.44,27.09,-114.5,88.26,18.8,-85.85,97.36,16.07,-58.79,99.18,9.107,-30.49,128.7,19.11,-6.772,112.9,1.066,24.4,99.86,-15.16,55.11,72.55,-2.426,62.55,87.54,34.9,32.16,86.55,45.43,3.696,60.92,15.38,-21.75,52.16,13.32,-49.24,60.6,39.72,-78.84,46.62,14.55,68.07,55.46,53.21,38.87};
			return value;
		}
		private double[] getCI_3_23_keyValue_3()
		{
			double[] value = {50.66,51.2,10.64,45.33,47.74,-17.55,34.59,28.69,-45.35,31.81,33.05,-73.72,18.56,45.91,70.99,17.7,51.61,42.44,16.02,47.91,13.9,15.47,54.75,-14.66,12.57,41.15,-43.16,10.72,37.31,-71.68,-20.15,60.98,70.95,-15.2,27.34,42.5,-14.5,33.92,13.94,-14.31,45.07,-14.62,-11.92,35.39,-43.14,-11.1,39.75,-71.69,-60.23,54.68,67.1,-47.89,30.44,39.41,-47.98,43.3,10.84,-42.28,39.06,-17.32,-40.39,45.76,-45.76,-37.67,49.93,-74.14,-93.86,32.88,59.96,-95.34,47.42,31.19,-79.02,32.98,4.626,-75.92,40.31,-23.56,-68.08,39.65,-51.18,-51.2,24.0,-77.69,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-111.7,-3.977,51.72,-110.6,7.052,23.32,-103.3,11.78,-3.947,-99.06,19.7,-31.76,-81.83,13.76,-57.29,-51.01,-6.559,-80.43,-66.76,22.45,-111.8,-61.36,53.14,-107.5,-34.52,53.08,-102.5,-10.96,51.04,-100.3,8.605,30.24,-100.2,26.54,29.86,-101.9,52.05,37.89,-106.4,79.57,36.08,-114.0,60.53,3.619,-82.11,80.54,12.36,-57.08,92.86,13.0,-30.69,102.6,11.0,-3.827,106.1,2.51,24.13,119.3,3.979,50.35,84.72,20.51,61.78,85.67,39.68,33.11,72.62,23.64,6.013,59.97,8.909,-21.11,52.43,6.749,-48.83,56.32,32.99,-77.84,50.2,23.74,68.03,50.71,42.86,39.43,48.72,50.64,10.99,38.02,21.86,-16.85,36.97,33.97,-45.36,40.31,64.77,-74.15,17.54,37.22,71.03,15.77,31.91,42.5,16.13,52.25,13.92,15.63,62.96,-14.64,12.86,43.64,-43.15,10.55,30.2,-71.66,-18.85,53.65,71.01,-15.46,25.41,42.51,-14.51,30.62,13.96,-13.13,28.86,-14.58,-12.33,35.09,-43.13,-11.25,37.8,-71.68,-57.39,54.15,67.55,-47.96,30.29,39.61,-40.0,13.33,11.58,-40.93,33.67,-17.05,-36.39,30.97,-45.32,-31.36,26.17,-73.55,-93.69,42.69,60.76,-78.41,21.1,33.92,-69.86,16.67,6.333,-71.84,38.04,-22.47,-59.24,23.35,-49.6,-60.86,43.96,-78.36,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0};
			return value;
		}
		private double[] getCI_3_23_keyValue_4()
		{
			double[] value = {-110.4,-2.576,53.55,-109.4,12.28,25.11,-93.93,2.672,-0.9339,-90.51,13.37,-28.96,-85.1,20.77,-56.65,-73.49,17.66,-83.34,-79.65,44.76,-112.9,-61.28,61.68,-107.0,-35.66,61.16,-102.4,-12.14,66.33,-100.3,11.45,58.01,-100.3,33.42,51.88,-102.3,52.98,41.19,-106.0,64.72,19.5,-110.5,61.03,-3.308,-81.32,71.27,-2.483,-54.41,87.09,7.812,-28.4,102.4,17.1,-2.31,109.9,13.5,25.05,118.0,10.46,52.3,89.74,51.54,63.26,79.86,32.73,35.58,78.58,48.26,7.118,67.5,25.26,-20.43,57.57,5.986,-48.11,55.69,19.52,-76.51,53.62,53.85,68.52,47.56,33.62,40.27,45.91,42.89,11.78,43.74,50.03,-16.66,40.69,49.57,-45.08,39.67,63.83,-73.59,17.44,48.61,71.11,15.4,26.99,42.58,15.67,51.7,14.0,14.89,59.14,-14.55,13.22,43.41,-43.1,12.61,52.34,-71.66,-17.54,45.11,71.11,-15.24,20.35,42.58,-14.63,30.71,14.02,-14.95,56.32,-14.56,-13.74,55.34,-43.1,-13.28,66.94,-71.67,-55.7,65.97,68.39,-49.66,46.62,40.15,-44.12,30.91,11.89,-40.02,23.57,-16.47,-41.37,54.64,-45.1,-40.84,72.07,-73.65,-87.73,42.34,63.42,-81.25,37.6,35.45,-71.78,21.03,7.747,-66.99,22.47,-20.4,-61.55,22.18,-48.46,-58.38,30.45,-76.74,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-121.3,33.1,55.82,-106.2,11.75,29.19,-105.5,31.04,0.726,-93.83,18.81,-26.36,-91.86,34.65,-54.66,-82.61,29.54,-82.04,-84.81,56.66,-110.9,-60.6,60.22,-105.5,-39.89,86.33,-102.2,-12.77,76.51,-100.2,13.37,89.96,-100.2,38.9,79.99,-102.1,52.78,29.08,-104.8,76.34,32.89,-109.8,77.17,14.05,-81.36,85.18,15.59,-53.82,93.6,18.69,-26.31,101.5,19.56,1.233,107.7,16.37,29.02,123.4,39.83,55.58,82.76,53.68,66.57,77.39,36.92,38.3,72.09,22.94,10.05,69.74,31.05,-18.38,65.09,20.66,-46.69,62.68,26.66,-75.13,48.43,39.98,69.73,46.32,36.61,41.22,44.4,39.31,12.72,42.65,43.15,-15.79,41.02,47.17,-44.3,40.28,61.26,-72.85,16.13,43.68,71.24,15.84,51.45,42.67,14.78,41.29,14.11,14.61,62.42,-14.46};
			return value;
		}
		private double[] getCI_3_23_keyValue_5()
		{
			double[] value = {14.11,65.95,-43.02,13.62,65.73,-71.59,-16.41,43.87,71.23,-15.16,28.33,42.68,-14.95,41.34,14.11,-15.0,67.44,-14.46,-14.49,76.36,-43.03,-13.39,66.86,-71.58,-50.12,58.09,69.66,-46.65,41.69,41.22,-44.55,39.08,12.71,-43.69,53.31,-15.83,-40.43,38.3,-44.28,-40.31,64.91,-72.84,-84.51,64.95,66.45,-79.56,54.18,38.18,-72.45,24.53,10.02,-69.22,25.19,-18.36,-65.37,22.04,-46.7,-62.81,29.5,-75.11,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-117.8,60.4,61.7,-111.2,51.28,33.68,-101.7,24.29,5.888,-98.09,30.24,-22.39,-92.64,26.67,-50.51,-86.44,19.49,-78.55,-84.49,34.39,-107.0,-62.01,48.78,-103.6,-38.92,72.21,-101.4,-13.19,83.2,-100.2,13.09,73.53,-100.2,39.13,72.99,-101.4,62.07,48.19,-103.7,88.88,57.65,-107.3,87.3,22.92,-78.65,93.47,31.73,-50.57,99.57,39.66,-22.5,102.3,28.26,5.847,109.4,40.82,33.82,118.0,62.82,61.7,74.99,46.88,69.88,73.9,48.2,41.33,71.72,22.76,12.8,71.37,47.1,-15.76,70.47,51.91,-44.32,69.49,53.74,-72.87,44.37,21.11,70.88,44.13,39.88,42.31,43.57,47.67,13.74,42.64,42.13,-14.81,42.19,49.38,-43.38,41.68,51.86,-71.95,14.75,22.33,71.37,14.68,38.99,42.8,14.46,45.23,14.23,14.28,65.14,-14.34,14.01,47.5,-42.92,13.97,55.26,-71.49,-15.01,36.86,71.37,-14.74,38.82,42.8,-14.57,43.03,14.23,-14.57,61.62,-14.35,-14.25,63.09,-42.92,-13.84,58.21,-71.49,-45.0,42.14,70.87,-44.48,52.27,42.31,-43.67,46.54,13.74,-43.17,51.72,-14.82,-42.09,39.54,-43.38,-41.42,47.31,-71.94,-75.58,58.39,69.86,-74.27,56.1,41.32,-72.79,47.75,12.78,-71.05,30.54,-15.76,-69.47,22.76,-44.3,-68.39,28.88,-72.84,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-106.2,66.18,68.35,-104.1,58.09,39.84,-102.4,57.23,11.32,-100.2,44.31,-17.19,-98.03,37.3,-45.7,-95.61,25.42,-74.2,-95.34,49.59,-102.8,-68.18,51.95,-101.4};
			return value;
		}
		private double[] getCI_3_23_keyValue_6()
		{
			double[] value = {-41.22,65.59,-100.5,-13.62,48.39,-100.1,13.66,58.04,-100.1,40.59,39.36,-100.5,68.27,55.14,-101.4,95.17,47.11,-102.8,96.52,39.63,-74.23,98.21,42.71,-45.7,99.87,44.59,-17.18,101.5,42.76,11.34,103.0,39.63,39.87,104.4,34.44,68.4,67.67,52.89,72.8,69.28,41.43,44.26,70.42,39.35,15.71,71.23,51.8,-12.84,72.33,54.29,-41.39,73.38,59.23,-69.94,40.99,31.62,71.93,41.71,34.97,43.37,41.92,56.11,14.8,42.7,53.96,-13.77,43.55,47.04,-42.33,44.25,49.15,-70.89,13.68,24.75,71.48,13.89,41.28,42.91,14.0,48.38,14.34,14.12,73.03,-14.23,14.48,56.43,-42.8,14.83,45.61,-71.37,-13.77,22.59,71.48,-13.77,45.09,42.91,-14.05,51.27,14.34,-14.19,58.61,-14.23,-14.37,62.22,-42.8,-14.63,49.93,-71.37,-41.02,33.82,71.93,-41.37,47.39,43.36,-42.04,53.43,14.8,-42.62,56.79,-13.77,-43.3,55.98,-42.33,-43.88,60.09,-70.9,-68.26,36.72,72.81,-69.1,43.82,44.26,-70.28,45.82,15.71,-71.2,51.88,-12.84,-72.31,52.59,-41.39,-73.36,54.66,-69.95,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-94.18,67.65,74.1,-96.28,55.03,45.59,-98.0,54.55,17.07,-99.54,55.34,-11.46,-101.5,46.82,-39.98,-103.2,43.89,-68.5,-104.6,50.13,-97.04,-74.13,68.14,-98.5,-44.36,73.34,-99.46,-14.91,49.18,-99.94,15.09,35.49,-99.94,45.23,32.03,-99.45,75.19,37.54,-98.47,104.5,55.19,-97.03,103.2,46.92,-68.5,101.3,53.9,-39.98,99.7,52.25,-11.46,98.05,51.74,17.07,97.41,31.64,45.62,95.13,44.52,74.13,61.1,41.36,75.19,63.29,57.92,46.76,66.85,57.29,18.41,69.89,63.79,-9.974,74.28,52.79,-38.28,77.74,52.99,-66.64,36.42,45.93,72.77,37.78,61.79,44.25,39.82,63.12,15.76,42.32,56.56,-12.72,45.35,37.09,-41.18,47.07,44.13,-69.69,12.24,37.57,71.58,12.66,56.43,43.01,13.2,66.25,14.45,13.97,66.0,-14.11,14.97,46.45,-42.67,15.7,42.14,-71.24,-12.42,33.97,71.58,-12.93,43.63,43.02,-13.53,49.74,14.45,-14.14,51.42,-14.11,-14.99,44.84,-42.67,-15.67,48.4,-71.24};
			return value;
		}
		private double[] getCI_3_23_keyValue_7()
		{
			double[] value = {-37.65,23.37,72.82,-38.98,38.47,44.3,-40.59,48.5,15.78,-42.63,48.63,-12.71,-44.64,51.33,-41.21,-46.8,51.06,-69.7,-62.48,26.02,75.28,-65.06,36.96,46.86,-67.48,50.31,18.44,-71.04,48.97,-9.914,-73.79,58.64,-38.31,-77.28,59.42,-66.67,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-84.82,48.68,78.76,-90.91,38.2,50.71,-96.33,33.86,22.61,-99.11,51.84,-5.728,-104.1,51.91,-33.87,-108.9,52.81,-62.02,-112.5,64.15,-90.28,-80.39,64.17,-95.05,-48.42,60.87,-98.21,-16.3,52.42,-99.8,16.32,47.69,-99.8,49.67,34.44,-98.16,82.82,34.04,-94.9,113.6,54.64,-90.18,108.4,56.33,-62.06,103.1,60.15,-33.94,97.69,64.84,-5.837,92.48,66.87,22.28,89.17,52.86,50.56,84.58,49.76,78.74,53.03,53.04,76.81,57.88,61.5,48.74,65.41,46.65,20.93,70.32,54.19,-7.139,77.08,45.2,-35.03,83.85,35.5,-62.93,31.41,59.28,73.33,35.22,55.56,45.0,38.0,65.73,16.6,42.72,48.31,-11.68,47.1,34.53,-39.99,50.8,29.44,-68.35,11.13,30.6,71.65,11.71,58.62,43.1,12.93,57.35,14.55,14.31,49.48,-13.99,15.91,28.84,-42.53,16.55,45.63,-71.09,-11.47,18.94,71.66,-11.91,45.33,43.1,-12.95,48.72,14.54,-14.33,37.12,-14.0,-15.33,45.9,-42.55,-16.65,43.52,-71.09,-33.33,32.87,73.45,-35.74,46.53,45.02,-39.61,40.02,16.68,-42.58,46.49,-11.71,-44.78,65.15,-40.15,-49.43,49.63,-68.43,-56.7,22.13,77.17,-60.98,33.91,49.03,-63.31,63.0,20.69,-68.1,71.04,-7.4,-73.27,76.36,-35.44,-80.44,65.15,-63.28,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-76.81,36.71,82.38,-85.97,29.29,55.1,-91.45,44.75,27.3,-96.41,63.46,-0.5681,-102.4,76.35,-28.28,-112.5,64.16,-55.39,-120.9,63.02,-82.76,-87.44,55.57,-91.13,-52.76,53.24,-96.79,-17.52,61.02,-99.64,17.0,70.42,-99.66,52.92,46.67,-96.8,90.55,26.28,-90.83,121.1,60.02,-82.76,112.5,63.74,-55.38,105.9,55.93,-27.74};
			return value;
		}
		private double[] getCI_3_23_keyValue_8()
		{
			double[] value = {98.7,50.97,-0.191,90.24,53.32,27.17,84.54,38.8,54.92,75.81,42.49,82.24,45.53,59.69,77.72,56.94,34.36,50.74,62.63,49.61,22.96,71.54,42.38,-4.366,81.09,27.82,-31.65,88.68,28.83,-59.18,27.68,56.27,73.71,32.59,55.21,45.55,36.57,63.88,17.31,41.31,64.64,-10.86,47.63,42.28,-38.93,53.62,25.91,-67.01,9.149,58.13,71.68,10.59,67.2,43.15,12.19,66.29,14.62,13.97,62.89,-13.9,16.06,35.74,-42.42,17.84,25.77,-70.94,-9.753,41.27,71.7,-10.72,58.07,43.15,-12.25,59.0,14.62,-14.33,35.99,-13.9,-16.22,33.24,-42.41,-17.57,43.32,-70.95,-30.35,25.93,73.93,-33.71,40.22,45.63,-37.43,51.72,17.36,-41.96,52.25,-10.84,-47.6,43.77,-38.93,-51.22,57.25,-67.2,-48.22,41.17,78.09,-55.27,45.57,50.48,-59.17,73.56,22.45,-67.08,71.9,-5.05,-72.46,90.88,-32.84,-84.05,63.81,-59.81,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-64.69,53.53,84.04,-76.7,46.77,57.79,-87.46,47.08,31.31,-91.97,79.45,3.597,-103.5,76.78,-22.67,-114.1,78.25,-49.17,-127.7,64.16,-75.1,-94.2,46.68,-86.98,-56.72,47.44,-95.32,-18.82,54.13,-99.48,18.66,53.02,-99.49,56.37,49.32,-95.35,94.66,41.99,-86.93,128.0,61.59,-75.06,122.4,34.32,-47.58,111.6,34.61,-21.11,100.2,38.33,5.306,89.05,39.62,31.67,78.67,37.21,58.21,64.66,53.03,84.03,39.99,57.75,78.27,48.98,62.11,51.25,60.27,50.84,24.62,70.4,46.47,-2.236,81.95,33.09,-28.84,89.71,44.55,-56.09,24.55,53.39,73.93,29.64,62.02,45.89,34.74,69.84,17.84,41.03,63.26,-10.1,48.23,47.41,-37.94,54.19,44.63,-65.91,7.771,66.96,71.69,9.701,70.28,43.19,12.01,59.48,14.7,14.73,30.76,-13.79,16.23,44.19,-42.31,18.19,41.2,-70.81,-8.352,50.82,71.71,-10.11,52.99,43.2,-12.43,38.52,14.7,-14.67,31.49,-13.79,-16.38,39.46,-42.3,-17.4,71.18,-70.84,-26.71,30.72,74.15,-32.24,32.06,46.13,-38.17,29.83,18.16,-43.71,33.38,-9.84,-47.83,51.79,-37.99,-51.64,74.0,-66.17,-42.49,41.73,78.69,-50.49,51.34,51.47};
			return value;
		}
		private double[] getCI_3_23_keyValue_9()
		{
			double[] value = {-60.56,47.56,24.62,-71.01,42.21,-2.155,-77.98,59.43,-29.53,-86.82,64.56,-56.58,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-57.59,47.52,85.37,-67.14,64.63,59.09,-78.75,72.19,33.32,-89.6,83.91,7.394,-102.4,85.92,-18.07,-119.2,69.13,-42.57,-132.0,70.83,-68.04,-102.2,25.87,-82.53,-58.35,63.42,-94.06,-18.95,82.89,-99.36,19.46,63.86,-99.34,58.89,56.78,-94.0,98.49,49.83,-83.16,134.5,58.82,-67.44,121.5,57.42,-42.01,112.8,36.24,-15.54,94.93,58.5,8.714,85.54,40.52,35.04,71.24,45.5,60.13,52.56,71.24,84.16,30.6,86.91,77.52,44.46,69.25,51.73,58.04,52.91,25.86,67.58,61.84,-0.8256,78.35,63.12,-27.26,89.22,64.04,-53.67,20.61,65.38,73.87,26.77,71.85,46.04,32.87,77.97,18.19,39.78,74.87,-9.573,47.04,68.36,-37.29,55.01,54.96,-64.92,7.054,60.53,71.71,9.857,46.2,43.25,11.92,51.85,14.76,14.08,52.4,-13.73,16.1,57.78,-42.22,18.59,50.33,-70.7,-7.509,46.98,71.72,-9.53,50.41,43.23,-12.09,40.17,14.75,-14.64,32.22,-13.72,-16.31,51.51,-42.22,-18.22,61.13,-70.72,-20.1,71.05,73.8,-28.48,52.0,46.21,-37.13,31.04,18.66,-44.61,23.18,-9.024,-48.66,51.32,-37.11,-52.72,78.75,-65.2,-36.48,49.52,78.68,-47.14,51.06,52.2,-61.47,29.72,26.48,-71.76,34.64,-0.02973,-78.1,64.74,-27.33,-91.18,51.36,-53.31,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-47.67,61.24,84.89,-62.74,61.12,60.55,-78.18,59.72,36.34,-96.14,46.84,12.86,-102.7,87.05,-13.86,-117.9,86.36,-38.12,-136.3,71.3,-61.52,-105.6,29.34,-79.02,-60.55,66.09,-92.86,-19.87,78.2,-99.23,20.68,56.73,-99.18,59.96,73.6,-92.9,98.73,73.87,-80.34,136.7,69.94,-61.34,119.7,78.31,-37.59,106.0,71.58,-12.89,92.32,64.88,11.83,83.23,37.09,37.85,66.48,44.51,61.69,43.62,79.92,83.77,30.65,61.98,78.23,43.46,58.23,52.51,53.76,69.53,26.21,63.61,83.44,-0.2044};
			return value;
		}
		private double[] getCI_3_23_keyValue_10()
		{
			double[] value = {77.78,70.93,-25.63,91.2,63.0,-51.22,17.03,78.84,73.67,23.32,90.89,45.93,29.57,102.4,18.18,39.91,70.99,-9.047,48.63,57.81,-36.47,55.64,61.87,-64.12,6.241,62.7,71.7,8.724,64.74,43.24,11.41,57.31,14.79,14.17,45.8,-13.67,16.82,42.24,-42.12,19.09,49.1,-70.6,-6.219,63.72,71.7,-9.715,30.12,43.27,-12.5,22.32,14.83,-15.5,9.598,-13.61,-16.71,47.16,-42.13,-18.4,71.18,-70.63,-18.02,68.79,73.79,-28.05,40.79,46.53,-38.12,13.5,19.28,-44.77,22.3,-8.402,-49.73,47.0,-36.33,-56.99,48.16,-63.95,-29.71,68.01,78.0,-45.39,45.33,52.88,-55.66,57.32,26.6,-69.35,48.19,1.078,-82.58,41.02,-24.57,-89.58,73.36,-51.6,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-39.32,74.11,83.83,-59.92,55.49,61.73,-78.92,44.66,39.17,-90.7,67.29,14.35,-106.7,70.0,-9.192,-117.4,96.89,-34.37,-143.5,53.5,-54.7,-105.5,49.8,-76.64,-62.78,65.14,-91.76,-21.18,62.85,-99.08,21.53,49.48,-99.06,64.37,47.78,-91.55,103.2,63.56,-77.14,137.3,81.62,-56.66,120.1,84.52,-33.51,104.5,79.88,-9.871,91.24,64.18,14.51,78.57,46.45,39.11,60.58,52.93,62.02,40.96,66.48,84.37,28.67,54.22,78.35,37.36,81.72,51.88,51.06,77.94,26.6,65.55,69.11,1.514,76.86,79.41,-24.37,93.51,57.24,-48.94,14.74,82.48,73.54,23.38,76.42,46.2,30.28,87.5,18.62,40.17,68.09,-8.551,48.82,60.11,-35.91,58.76,40.18,-63.07,5.01,81.13,71.67,7.859,77.64,43.23,10.88,67.71,14.8,14.17,48.98,-13.61,16.91,42.95,-42.06,20.31,20.95,-70.47,-5.672,60.25,71.69,-8.305,60.7,43.24,-11.79,36.74,14.84,-14.51,36.69,-13.6,-17.63,28.11,-42.02,-20.12,34.7,-70.47,-16.28,66.57,73.74,-26.12,47.36,46.56,-35.13,37.11,19.28,-43.92,29.44,-8.039,-51.87,31.42,-35.46,-58.33,47.23,-63.11,-24.31,81.12,77.27,-42.86,46.93,53.15,-55.83,47.73,27.7,-68.14,52.79,2.098,-79.66,63.3,-23.67,-91.49,71.24,-49.38,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0};
			return value;
		}
		private double[] getCI_3_23_keyValue_11()
		{
			double[] value = {-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-39.65,51.19,85.05,-55.38,60.55,61.88,-69.26,78.49,38.09,-86.74,80.17,15.54,-104.6,80.36,-6.832,-120.3,90.04,-29.99,-141.9,72.68,-51.18,-105.5,64.95,-74.6,-66.17,47.89,-90.57,-22.36,45.69,-98.95,22.64,34.64,-98.93,70.46,3.551,-89.96,110.8,31.94,-73.33,145.2,57.34,-50.04,126.6,60.51,-27.89,105.8,74.31,-6.481,86.96,79.32,15.67,70.12,74.97,38.45,54.91,63.1,61.79,37.42,61.43,84.33,25.61,56.47,78.03,32.88,96.43,51.32,45.77,102.3,26.06,61.58,90.74,1.559,78.94,69.37,-22.57,95.49,53.33,-46.88,13.39,79.32,73.47,20.57,92.33,45.99,29.53,87.72,18.78,38.25,85.84,-8.465,48.49,68.22,-35.49,58.51,53.56,-62.53,4.928,67.58,71.68,7.567,74.08,43.24,10.74,64.69,14.83,13.88,57.46,-13.58,16.61,59.82,-42.02,20.56,29.11,-70.39,-4.137,89.59,71.63,-7.488,75.17,43.23,-10.26,78.26,14.8,-13.14,76.67,-13.63,-16.88,52.63,-42.01,-19.81,49.59,-70.44,-12.64,86.38,73.34,-24.4,54.08,46.55,-32.76,55.69,19.25,-42.03,47.79,-7.92,-50.44,49.25,-35.21,-59.36,44.74,-62.43,-23.91,66.56,77.55,-39.41,56.65,52.97,-56.54,36.98,28.8,-68.24,50.01,3.222,-79.35,67.04,-22.48,-95.54,52.76,-46.9,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-34.14,58.76,83.97,-48.24,79.76,60.6,-67.9,75.93,39.27,-86.97,74.53,17.71,-107.2,68.32,-3.389,-129.2,53.76,-23.87,-147.8,54.41,-45.61,-112.1,36.06,-71.23,-68.09,41.92,-89.68,-22.55,51.43,-98.87,23.26,35.65,-98.83,69.71,27.49,-89.4,110.0,49.67,-71.7,145.1,67.28,-46.53,126.7,65.34,-24.75,103.4,85.1,-4.757,83.39,90.78,16.46,65.9,84.87,38.58,49.42,74.56,61.09,35.4,53.28,84.5,18.28,87.48,76.36,36.57,64.87,52.7,48.44,79.99,27.32,59.59,99.58,1.766,77.36,80.49,-22.01,93.06,72.57,-46.39,10.79,91.63,73.15,21.31,75.68,46.24,30.15,76.17,19.08,39.08,76.15,-8.068,48.37,72.73,-35.15,59.01,54.99,-62.06};
			return value;
		}
		private double[] getCI_3_23_keyValue_12()
		{
			double[] value = {5.326,44.13,71.71,7.201,74.76,43.24,10.68,61.52,14.85,13.38,71.5,-13.58,16.78,61.79,-41.97,20.36,42.1,-70.36,-4.587,64.9,71.67,-7.247,74.98,43.24,-10.81,58.27,14.85,-13.77,57.27,-13.57,-16.92,51.0,-41.98,-19.95,52.97,-70.39,-12.79,72.65,73.45,-22.47,65.17,46.42,-31.17,66.61,19.23,-39.66,69.62,-8.008,-47.9,75.12,-35.28,-55.78,85.49,-62.59,-22.08,65.32,77.35,-37.22,61.38,52.86,-52.58,55.94,28.41,-63.71,74.98,2.82,-78.81,70.76,-21.71,-95.78,56.58,-45.69,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-28.42,71.37,82.39,-45.47,82.07,60.42,-65.37,80.26,39.53,-88.87,62.72,20.01,-108.1,63.83,-1.172,-135.4,30.17,-19.13,-152.8,38.9,-41.01,-111.9,46.07,-69.94,-67.97,53.09,-89.24,-22.84,53.37,-98.81,24.12,22.97,-98.73,69.27,42.52,-88.99,109.9,58.92,-70.4,144.8,74.29,-43.99,126.6,68.39,-22.49,101.1,94.78,-3.736,81.4,95.4,17.2,61.74,95.9,38.15,48.73,67.73,61.69,34.61,44.54,84.82,18.79,76.43,76.61,37.01,57.08,53.06,52.31,54.02,28.7,63.57,74.24,3.273,77.2,80.65,-21.54,93.68,70.66,-45.59,12.91,63.91,73.53,23.99,45.44,46.75,31.45,60.1,19.39,38.4,80.43,-8.028,48.76,68.94,-34.92,61.09,38.56,-61.5,6.23,12.4,71.76,7.718,54.11,43.27,10.47,61.93,14.85,13.62,62.99,-13.55,16.38,71.23,-41.97,19.7,61.88,-70.37,-5.585,32.58,71.73,-8.068,48.99,43.29,-11.32,44.4,14.9,-14.49,38.09,-13.51,-17.54,38.43,-41.92,-19.36,74.31,-70.39,-15.72,39.22,73.99,-25.11,36.8,46.95,-32.59,51.43,19.59,-39.2,72.76,-7.923,-49.9,58.03,-34.75,-57.01,76.74,-62.15,-22.71,55.07,77.69,-38.31,50.6,53.44,-52.42,54.4,28.76,-65.02,65.92,3.631,-80.05,64.48,-20.79,-93.62,71.7,-45.6,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-30.16,56.88,83.4,-50.63,54.7,62.97,-72.45,46.91,43.07,-90.38,54.74,21.56};
			return value;
		}
		private double[] getCI_3_23_keyValue_13()
		{
			double[] value = {-114.2,38.48,2.452,-132.0,47.86,-19.04,-145.3,74.54,-42.43,-107.1,77.72,-70.51,-69.27,45.94,-88.77,-22.44,67.93,-98.81,23.48,48.68,-98.73,72.49,19.64,-88.17,112.8,47.5,-68.82,147.8,65.17,-41.26,126.4,70.41,-21.26,104.6,78.53,-1.312,90.05,56.24,21.49,71.0,52.25,42.45,48.18,64.3,61.97,31.18,52.31,83.81,22.13,56.11,77.57,39.51,42.8,53.81,53.37,48.1,29.09,68.92,44.64,4.837,82.59,50.6,-19.96,95.87,59.46,-44.81,14.05,52.1,73.72,23.95,45.35,46.77,32.5,50.42,19.6,42.25,45.43,-7.375,50.36,53.58,-34.63,59.72,52.61,-61.65,6.118,16.06,71.76,8.753,27.0,43.33,10.96,49.7,14.88,14.45,40.14,-13.5,16.31,69.51,-41.98,19.43,71.46,-70.37,-6.154,17.77,71.76,-8.521,36.08,43.32,-11.28,43.55,14.89,-13.79,57.23,-13.54,-16.88,58.31,-41.95,-19.56,65.4,-70.38,-15.43,41.01,73.95,-23.9,46.75,46.76,-32.44,51.64,19.58,-39.36,70.27,-7.862,-52.05,40.18,-34.35,-59.0,57.82,-61.81,-22.65,53.84,77.71,-37.29,55.02,53.2,-53.25,49.17,29.05,-65.06,65.03,3.742,-81.38,57.56,-20.29,-93.99,68.86,-45.4,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-25.3,74.31,81.53,-51.91,48.73,63.59,-72.67,45.89,43.29,-89.87,56.86,21.58,-110.3,55.6,1.177,-125.4,74.66,-21.43,-140.6,93.16,-43.95,-105.6,85.38,-70.76,-69.11,48.56,-88.74,-22.49,66.76,-98.8,23.78,41.66,-98.71,69.0,52.02,-88.69,110.9,58.86,-69.19,146.3,71.69,-41.51,122.4,86.59,-22.53,107.0,68.06,-0.1531,91.13,51.91,22.11,76.38,31.1,44.78,54.79,37.08,64.73,31.3,50.57,83.93,27.88,31.62,79.04,41.36,37.43,54.14,58.6,24.47,30.26,75.69,12.74,6.362,84.21,42.74,-19.91,95.59,59.27,-45.36,15.4,45.36,73.91,26.59,27.54,47.14,34.22,38.29,19.79,45.47,20.61,-6.966,52.26,37.77,-34.46,59.9,49.21,-61.79,4.974,50.66,71.7,7.908,53.1,43.28,10.73,57.46,14.86,14.38,44.45,-13.52,17.46,41.92,-41.93,20.53,42.7,-70.33,-4.907,51.58,71.69,-7.4,64.05,43.25};
			return value;
		}
		private double[] getCI_3_23_keyValue_14()
		{
			double[] value = {-10.74,56.68,14.85,-13.26,67.12,-13.59,-16.26,68.83,-42.0,-19.61,58.82,-70.4,-13.55,60.05,73.59,-22.28,61.96,46.42,-32.39,52.86,19.47,-40.67,57.85,-7.781,-49.44,59.94,-34.94,-59.69,48.94,-61.88,-21.97,60.75,77.39,-37.21,57.73,52.97,-52.0,57.06,28.43,-64.1,69.31,3.128,-76.81,79.09,-21.97,-93.17,70.2,-46.11,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-35.1,41.18,85.15,-59.14,25.7,65.99,-74.83,40.83,43.58,-88.79,62.03,20.44,-106.1,71.5,-1.346,-125.3,73.44,-22.42,-141.2,88.24,-44.7,-108.2,68.76,-70.53,-68.8,49.16,-88.96,-23.6,39.56,-98.75,23.71,34.93,-98.74,70.18,37.27,-88.74,110.9,55.22,-69.81,151.6,49.83,-40.61,129.0,60.67,-20.84,110.3,56.17,0.3879,96.12,35.74,23.42,75.75,37.53,43.98,53.44,46.68,63.82,28.92,63.83,82.78,27.15,45.47,78.51,35.71,71.4,52.17,58.73,29.65,29.58,71.42,35.99,4.295,80.64,58.4,-21.9,93.76,63.1,-47.04,18.78,28.82,74.32,26.49,35.96,46.94,33.18,50.33,19.39,43.3,38.43,-7.634,52.17,35.94,-34.86,60.14,41.12,-62.2,4.116,78.81,71.64,8.061,56.07,43.27,10.94,55.93,14.85,14.17,47.44,-13.56,17.08,45.73,-41.99,19.91,48.13,-70.42,-3.19,99.52,71.59,-7.133,74.46,43.21,-10.74,58.36,14.83,-14.21,46.03,-13.57,-17.05,48.7,-41.99,-20.72,29.78,-70.38,-12.5,76.51,73.34,-22.38,66.38,46.27,-31.11,65.5,19.04,-38.72,73.31,-8.355,-51.33,43.15,-34.98,-61.97,27.2,-61.93,-21.62,71.12,77.03,-39.89,51.38,53.2,-55.21,45.69,28.61,-63.57,72.57,2.223,-80.03,61.68,-22.05,-97.86,44.0,-46.0,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-33.99,55.51,84.1,-58.81,36.0,64.77,-71.82,57.18,41.07,-82.25,87.26,16.41,-103.2,81.46,-4.335,-121.4,84.44,-26.1,-139.2,89.33,-48.04,-112.9,39.47,-70.65,-73.06,8.271,-88.8,-23.48,33.22,-98.81,23.47,32.5,-98.81,67.54,50.19,-89.64};
			return value;
		}
		private double[] getCI_3_23_keyValue_15()
		{
			double[] value = {104.6,78.08,-72.8,142.8,76.68,-46.65,127.1,65.09,-23.97,111.7,51.98,-1.159,97.29,35.74,22.07,72.55,54.94,41.41,40.78,98.13,58.12,29.5,71.0,82.47,25.18,69.03,77.5,36.39,77.7,51.62,54.84,54.17,27.49,67.62,55.53,1.971,82.17,49.39,-23.1,93.8,56.23,-48.87,16.08,63.41,73.72,23.92,64.64,46.27,31.82,65.39,18.82,39.55,66.84,-8.662,50.81,43.1,-35.63,58.32,46.74,-63.13,4.993,72.48,71.67,8.043,64.8,43.24,10.8,63.46,14.8,13.77,55.61,-13.64,16.76,49.23,-42.07,19.22,54.47,-70.52,-4.285,87.12,71.63,-8.816,46.02,43.27,-11.28,50.62,14.81,-13.48,62.65,-13.65,-16.62,52.25,-42.08,-19.68,43.64,-70.51,-14.59,73.97,73.49,-25.75,50.58,46.5,-32.21,61.79,18.85,-37.49,82.2,-8.965,-49.36,53.6,-35.85,-60.06,33.67,-62.91,-21.47,85.37,76.57,-38.71,67.05,52.14,-51.97,66.55,26.75,-63.45,74.29,0.9526,-80.69,55.98,-23.48,-95.35,49.15,-48.53,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-32.99,73.89,82.76,-59.67,45.72,63.36,-75.7,52.22,40.31,-87.48,72.77,15.82,-101.9,84.42,-7.792,-120.5,82.75,-29.99,-144.1,64.61,-50.42,-115.9,16.16,-72.16,-69.74,21.42,-90.1,-22.87,32.69,-98.93,21.65,59.58,-98.98,64.14,62.56,-90.88,102.5,75.93,-75.35,141.8,71.94,-51.16,128.0,58.47,-27.36,117.0,35.42,-2.567,90.31,63.46,16.81,66.25,83.23,37.12,55.89,58.26,62.13,38.82,55.05,84.82,31.8,59.98,78.21,48.99,36.08,53.29,58.83,44.67,26.81,67.72,56.94,0.1123,84.94,33.53,-24.77,93.61,47.43,-51.49,14.99,90.61,73.33,25.73,64.12,46.1,35.03,48.44,18.71,39.47,67.23,-9.317,47.95,58.06,-36.81,55.98,51.89,-64.36,4.934,92.54,71.64,8.31,69.96,43.2,11.11,61.11,14.75,13.75,53.46,-13.71,16.03,57.46,-42.19,19.26,40.35,-70.62,-5.471,80.29,71.65,-9.238,51.69,43.24,-11.75,48.82,14.78,-14.37,46.0,-13.68,-16.56,48.3,-42.16,-20.22,19.74,-70.59,-13.89,98.39,73.17,-26.3,60.6,46.17,-33.87,57.33,18.56,-40.16,64.12,-9.208};
			return value;
		}
		private double[] getCI_3_23_keyValue_16()
		{
			double[] value = {-50.24,42.19,-36.52,-59.87,23.78,-63.88,-30.28,66.43,77.86,-43.39,60.94,52.09,-53.72,67.33,25.72,-66.19,64.76,-0.1744,-86.45,27.42,-24.45,-95.45,39.41,-51.12,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-37.07,81.7,82.67,-57.34,69.33,60.27,-79.99,49.27,38.58,-94.4,55.61,14.42,-109.3,59.88,-9.659,-123.5,66.26,-33.92,-137.9,72.23,-58.14,-106.9,40.51,-77.26,-65.92,31.1,-91.7,-22.27,25.58,-99.07,21.52,44.36,-99.1,61.39,64.72,-92.24,97.28,83.22,-79.27,136.3,77.59,-58.56,132.2,38.9,-31.26,115.0,41.42,-7.92,92.3,61.45,13.72,77.13,58.11,37.72,59.08,63.58,60.81,43.47,61.56,84.66,39.48,52.27,78.48,51.02,44.77,51.94,63.62,33.41,25.63,72.76,37.42,-1.305,78.72,56.02,-28.8,89.45,52.23,-55.47,19.84,81.42,73.54,29.84,50.71,46.01,37.16,41.54,18.22,42.81,44.48,-9.746,46.17,65.03,-37.95,50.58,76.19,-66.07,6.236,89.86,71.65,9.016,70.01,43.17,11.7,56.11,14.7,13.26,66.78,-13.82,16.23,47.62,-42.28,17.91,52.31,-70.8,-6.544,83.39,71.66,-9.924,55.56,43.21,-12.61,39.03,14.73,-13.68,59.29,-13.8,-16.59,36.93,-42.28,-19.22,25.92,-70.75,-17.87,96.26,73.32,-28.1,65.72,45.85,-35.44,55.43,18.05,-41.76,52.99,-9.858,-46.2,64.02,-37.97,-55.82,38.04,-65.51,-37.72,60.2,78.15,-46.13,67.88,51.1,-59.08,54.43,24.83,-71.5,43.47,-1.53,-80.35,48.24,-28.54,-89.94,50.61,-55.38,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-51.81,62.66,84.55,-66.41,60.96,59.7,-79.77,62.64,34.5,-98.76,46.33,10.74,-111.8,48.95,-14.56,-126.0,48.35,-39.49,-133.7,68.43,-66.14,-100.3,48.84,-82.12,-59.41,55.73,-93.7,-20.87,32.65,-99.27,19.28,67.81,-99.32,54.12,95.07,-94.26,92.99,81.5,-83.4,129.7,81.14,-67.12,117.7,74.76,-41.61,109.7,56.17,-15.05,93.46,63.11,9.394,86.07,41.9,36.09,64.84,65.19,59.26,55.37,51.18,85.47};
			return value;
		}
		private double[] getCI_3_23_keyValue_17()
		{
			double[] value = {44.62,62.48,77.58,52.71,60.42,50.11,63.08,47.45,22.96,71.21,46.05,-4.49,77.1,55.68,-32.25,79.28,83.38,-60.52,26.99,60.65,73.65,33.65,43.24,45.62,38.78,39.12,17.46,43.15,42.01,-10.75,44.72,68.02,-39.19,45.32,101.5,-67.71,9.13,58.05,71.68,11.9,24.88,43.18,12.85,38.87,14.63,14.1,47.74,-13.9,15.18,60.44,-42.44,16.59,63.71,-70.98,-8.54,70.49,71.66,-11.43,40.41,43.17,-12.39,56.19,14.63,-14.28,46.89,-13.9,-16.17,37.84,-42.42,-17.99,31.67,-70.94,-28.57,46.87,73.76,-33.9,42.53,45.64,-35.02,72.11,17.16,-43.08,43.79,-10.75,-47.72,43.79,-38.94,-52.65,41.83,-67.11,-46.1,54.67,77.76,-49.77,75.74,49.71,-58.82,69.72,22.39,-72.88,38.5,-4.254,-80.33,40.04,-31.81,-84.23,59.42,-59.84,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-65.9,50.15,84.23,-67.87,82.25,56.06,-80.03,78.02,29.86,-104.5,30.05,6.039,-114.3,33.71,-20.62,-119.6,53.88,-48.17,-127.3,64.97,-75.28,-89.37,72.04,-87.72,-54.68,62.74,-95.52,-19.17,38.12,-99.48,18.45,59.02,-99.49,50.14,101.1,-95.88,90.65,66.24,-87.51,123.8,77.47,-75.9,117.8,59.81,-48.52,113.4,36.82,-20.81,99.11,48.54,4.983,82.5,68.49,30.32,74.89,56.91,57.41,72.41,27.51,85.53,57.66,34.14,76.74,61.83,40.45,48.55,64.79,54.15,20.24,73.22,34.52,-7.548,75.84,51.22,-35.88,77.23,75.02,-64.32,33.45,45.61,73.28,37.68,33.61,44.93,40.45,36.4,16.51,44.17,30.91,-11.86,43.52,70.94,-40.46,45.95,77.84,-68.9,11.44,37.0,71.64,12.53,33.77,43.09,13.89,20.63,14.54,15.31,10.44,-14.01,15.31,44.36,-42.58,15.78,60.99,-71.14,-12.24,9.017,71.65,-13.16,15.19,43.1,-14.12,21.35,14.55,-15.31,15.15,-14.0,-15.88,29.14,-42.57,-15.98,60.37,-71.14,-36.48,12.98,73.43,-39.05,19.71,45.01,-40.66,36.84,16.53,-44.66,27.35,-11.83,-46.35,42.13,-40.31,-48.15,56.7,-68.78,-57.44,34.92,76.71,-61.48,42.91,48.51,-65.48,51.35,20.32,-70.64,51.58,-7.781,-78.14,37.3,-35.66,-82.38,43.94,-63.84};
			return value;
		}
		private double[] getCI_3_23_keyValue_18()
		{
			double[] value = {100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-75.75,56.8,81.22,-82.8,58.5,53.57,-92.0,50.8,26.21,-103.1,34.15,-0.9379,-111.6,28.58,-28.4,-115.3,45.2,-56.49,-116.2,74.0,-84.96,-82.23,77.27,-92.43,-51.26,56.39,-97.18,-16.7,68.48,-99.69,16.46,74.53,-99.7,49.04,79.07,-97.3,82.23,76.99,-92.43,120.8,53.06,-84.35,115.4,44.12,-56.49,107.1,48.48,-28.99,96.71,61.8,-1.767,89.78,59.61,25.9,84.53,50.62,53.81,81.54,31.42,82.0,64.6,37.78,74.27,65.54,54.26,45.74,67.76,57.57,17.27,71.31,47.62,-11.14,73.62,49.11,-39.61,73.54,76.5,-68.19,38.69,38.07,72.45,40.27,35.58,43.92,40.7,55.23,15.36,43.36,36.69,-13.14,43.92,52.53,-41.7,44.71,64.08,-70.25,13.11,25.02,71.54,13.2,43.63,42.97,14.1,21.61,14.41,14.69,24.21,-14.16,15.02,29.6,-42.73,15.23,40.46,-71.3,-13.36,15.0,71.55,-13.91,16.22,42.98,-14.11,33.12,14.41,-14.88,11.22,-14.16,-15.42,13.45,-42.72,-15.53,39.56,-71.29,-39.5,24.58,72.47,-39.99,44.55,43.91,-42.17,32.34,15.4,-44.89,7.753,-13.1,-44.85,37.49,-41.67,-44.99,64.07,-70.24,-65.26,31.34,74.3,-65.88,52.9,45.76,-69.63,39.37,17.36,-72.29,36.46,-11.1,-72.74,59.85,-39.65,-74.76,66.17,-68.13,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-87.67,61.08,76.84,-91.68,57.89,48.52,-96.14,50.64,20.23,-99.87,48.05,-8.123,-106.2,26.88,-36.3,-108.8,34.59,-64.7,-108.4,65.17,-93.31,-76.89,69.81,-96.61,-46.53,62.32,-98.77,-15.71,54.13,-99.86,15.48,57.65,-99.86,45.73,74.01,-98.79,74.81,90.77,-96.71,108.1,65.8,-93.32,104.3,67.83,-64.99,101.3,64.42,-36.6,98.77,56.96,-8.182,95.67,52.61,20.19,94.89,31.15,48.71,93.23,17.16,77.19,71.89,31.55,71.2,71.56,33.24,42.63,71.59,55.9,14.06,71.5,63.01,-14.51,71.1,38.8,-43.08,71.01,49.5,-71.65,43.27,57.83,71.35,43.02,61.4,42.78};
			return value;
		}
		private double[] getCI_3_23_keyValue_19()
		{
			double[] value = {43.02,78.87,14.2,42.87,64.28,-14.37,42.69,53.59,-42.94,42.54,42.33,-71.51,14.45,65.5,71.42,14.27,74.28,42.85,14.21,42.2,14.28,14.19,33.25,-14.29,14.11,21.47,-42.87,14.11,37.1,-71.44,-14.33,14.37,71.42,-14.48,34.73,42.85,-14.41,33.91,14.28,-14.31,11.47,-14.29,-14.32,24.33,-42.87,-14.3,43.46,-71.44,-43.05,21.66,71.35,-43.24,49.67,42.77,-42.97,24.24,14.2,-42.74,5.422,-14.37,-42.73,20.91,-42.94,-42.78,54.56,-71.51,-72.02,52.26,71.2,-72.06,61.23,42.63,-71.68,39.8,14.06,-71.46,38.54,-14.51,-71.21,27.53,-43.08,-71.22,52.63,-71.66,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-100.9,57.78,70.98,-101.1,80.28,42.41,-100.3,40.69,13.84,-99.86,24.92,-14.73,-99.57,19.68,-43.3,-99.23,14.01,-71.87,-99.36,46.8,-100.4,-71.22,74.33,-100.2,-42.84,88.79,-100.1,-14.3,57.36,-100.0,14.05,30.54,-100.0,42.48,55.17,-100.1,70.88,57.39,-100.2,99.23,53.11,-100.4,99.72,72.95,-71.87,99.71,50.8,-43.3,100.0,54.72,-14.73,100.1,39.72,13.84,100.2,25.57,42.41,100.4,11.57,70.98,82.59,64.55,67.67,74.54,28.07,39.47,76.28,58.69,10.83,74.46,63.63,-17.67,72.61,68.64,-46.16,65.86,39.75,-74.42,49.38,64.08,70.08,47.15,58.28,41.57,47.64,82.91,12.99,45.81,78.89,-15.53,43.18,66.06,-44.03,39.83,45.06,-72.51,16.22,54.14,71.28,15.9,66.95,42.71,15.43,71.5,14.15,14.62,58.72,-14.42,13.84,48.39,-42.98,13.13,40.71,-71.55,-15.37,32.21,71.29,-15.18,37.99,42.72,-14.84,41.36,14.15,-13.66,21.0,-14.41,-13.9,48.31,-42.98,-13.95,68.92,-71.55,-46.97,38.8,70.15,-46.53,49.8,41.59,-44.15,39.36,13.08,-41.13,23.18,-15.41,-41.0,40.14,-43.97,-42.25,72.94,-72.58,-82.11,62.89,67.71,-80.53,68.8,39.2,-74.98,47.82,10.88,-70.46,35.01,-17.49,-66.6,26.57,-45.88,-68.91,60.8,-74.56,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0};
			return value;
		}
		private double[] getCI_3_23_keyValue_20()
		{
			double[] value = {-117.4,71.73,63.96,-111.1,57.81,35.78,-107.6,58.05,7.425,-95.73,18.19,-20.39,-89.15,4.028,-48.54,-90.14,27.07,-77.17,-89.48,41.85,-105.7,-70.0,86.39,-103.2,-42.63,95.33,-101.2,-13.97,87.84,-100.1,13.23,62.25,-100.1,39.2,55.72,-101.1,65.2,53.23,-103.0,86.78,28.6,-105.5,96.99,60.85,-77.61,103.3,74.22,-49.45,103.1,55.03,-20.85,105.6,49.55,7.563,105.7,31.61,36.12,111.1,39.65,64.34,92.98,62.51,64.23,84.56,50.78,36.32,76.44,39.86,8.375,78.65,60.17,-20.37,72.71,55.74,-48.48,62.41,38.0,-76.26,48.45,30.12,69.19,49.14,47.67,40.59,50.97,71.05,11.94,45.52,56.26,-16.39,39.24,37.4,-44.67,33.86,23.13,-72.99,16.08,31.11,71.18,17.16,62.68,42.59,16.85,71.85,14.03,15.39,61.87,-14.52,14.09,54.99,-43.07,12.43,42.28,-71.62,-15.44,22.07,71.19,-15.42,34.61,42.62,-16.75,68.94,14.03,-14.7,51.16,-14.51,-14.82,67.05,-43.08,-14.81,81.45,-71.65,-49.28,34.75,69.16,-45.38,27.98,40.77,-42.93,28.94,12.31,-41.07,33.26,-16.18,-41.96,51.69,-44.79,-47.56,94.71,-73.61,-85.95,41.34,64.79,-76.93,27.39,36.91,-73.46,30.5,8.607,-61.18,6.953,-19.01,-67.62,40.35,-48.08,-66.65,51.28,-76.57,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-120.4,33.57,58.27,-108.8,22.61,30.97,-108.6,35.94,2.411,-92.09,14.91,-24.35,-87.28,18.52,-52.39,-81.71,20.56,-80.35,-79.66,29.89,-108.7,-67.33,66.94,-105.2,-42.24,80.6,-101.9,-13.83,78.93,-100.2,12.34,55.21,-100.2,32.99,32.53,-101.5,57.85,37.95,-104.5,81.25,33.18,-108.9,90.0,37.82,-81.28,97.37,39.72,-53.51,94.92,20.85,-24.67,100.8,19.7,3.26,116.6,39.23,30.1,124.2,41.29,57.84,85.93,28.89,63.55,77.84,24.52,35.71,72.51,24.84,7.625,68.08,26.75,-20.55,66.2,33.17,-48.94,61.66,35.11,-77.09,50.15,34.15,68.72,43.55,23.52,40.5,44.59,36.04,11.87,44.58,45.39,-16.71,39.1,38.45,-44.98,31.02,23.73,-73.11,14.3,16.4,71.17,15.99,41.26,42.57,19.1,79.08,13.94,17.19,70.13,-14.6};
			return value;
		}
		private double[] getCI_3_23_keyValue_21()
		{
			double[] value = {15.39,63.21,-43.14,11.27,34.93,-71.63,-12.85,1.681,71.2,-13.77,20.33,42.61,-18.18,72.19,13.96,-16.18,63.68,-14.57,-15.6,67.62,-43.13,-14.77,68.81,-71.69,-42.22,9.661,69.14,-35.1,-2.196,40.96,-46.2,41.38,11.79,-42.1,38.71,-16.55,-50.71,74.5,-45.59,-53.35,91.94,-74.31,-71.82,4.485,64.84,-68.38,8.302,36.59,-66.41,14.69,8.205,-69.26,29.3,-20.62,-84.14,64.39,-50.56,-72.81,54.46,-78.1,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-104.5,-3.357,57.64,-107.7,9.821,28.66,-101.5,12.69,0.9221,-87.58,7.084,-25.81,-98.96,29.21,-55.88,-81.38,19.35,-82.14,-66.26,12.29,-108.7,-65.2,50.98,-106.0,-43.16,70.5,-102.3,-14.04,71.45,-100.2,12.02,51.63,-100.2,26.63,20.07,-101.4,42.23,11.54,-103.9,76.01,22.9,-110.0,93.33,32.3,-83.75,85.16,13.65,-54.11,86.8,5.836,-25.75,92.16,2.215,2.119,109.7,12.0,28.39,124.2,18.46,55.06,72.0,10.14,65.74,63.09,6.328,37.86,64.19,12.95,9.199,76.7,31.32,-20.36,63.49,23.3,-47.89,67.96,33.42,-76.81,44.84,25.84,69.38,39.93,21.28,41.02,47.28,41.38,12.11,45.91,44.21,-16.4,39.31,36.57,-44.66,33.5,30.55,-72.97,11.92,12.83,71.25,11.52,15.14,42.68,15.77,47.53,14.05,15.91,54.0,-14.53,13.47,43.99,-43.06,9.925,27.02,-71.58,-9.562,-3.011,71.28,-13.25,26.83,42.66,-15.84,49.26,14.05,-17.13,63.12,-14.54,-17.54,71.27,-43.12,-15.4,62.96,-71.66,-29.95,-4.192,70.06,-37.36,16.39,41.15,-46.05,39.4,12.18,-36.97,26.72,-15.97,-51.83,62.04,-45.23,-59.69,83.3,-74.16,-64.8,2.552,66.3,-66.56,10.08,37.6,-80.8,30.32,7.909,-69.14,23.84,-19.74,-80.01,40.56,-49.17,-76.58,42.55,-77.47,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-75.36,-23.6,62.6,-82.57,-14.06,33.2,-95.4,-1.606,3.137,-95.43,3.935,-25.44,-102.7,13.39,-54.86,-80.36,6.894,-80.82,-62.72,2.867,-107.3,-67.36,38.45,-105.3};
			return value;
		}
		private double[] getCI_3_23_keyValue_22()
		{
			double[] value = {-42.85,54.85,-102.0,-14.96,65.02,-100.2,12.67,50.55,-100.2,26.23,21.72,-101.2,45.38,15.9,-103.6,61.56,2.257,-107.2,98.09,16.17,-82.93,96.99,10.04,-54.23,85.92,-1.399,-24.36,93.65,-2.808,3.306,111.3,1.119,29.82,117.9,-0.6569,57.63,61.05,7.9,69.71,62.81,10.26,41.09,74.51,18.7,12.19,73.72,19.62,-16.36,61.99,14.06,-44.6,69.26,19.88,-73.37,36.98,23.29,70.84,27.87,11.88,42.41,44.41,36.46,13.58,42.16,34.71,-14.95,32.96,23.27,-43.38,36.62,29.89,-72.01,13.33,34.92,71.36,9.342,17.16,42.81,7.331,9.242,14.25,9.59,21.31,-14.34,11.94,33.87,-42.92,8.807,20.62,-71.47,-9.49,16.98,71.38,-12.96,35.41,42.79,-15.93,50.79,14.2,-14.52,45.46,-14.36,-15.99,53.95,-42.94,-13.33,42.26,-71.5,-34.57,20.09,70.88,-44.76,35.95,42.15,-41.4,32.52,13.63,-46.95,41.75,-15.03,-56.99,57.27,-43.76,-60.98,64.12,-72.39,-58.13,6.313,69.8,-60.97,9.513,41.15,-62.97,12.04,12.52,-68.74,16.92,-16.21,-85.05,28.09,-45.24,-120.5,50.56,-74.81,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-44.05,-22.86,69.51,-82.91,-16.45,39.25,-97.77,-13.24,10.03,-91.45,-12.61,-18.27,-94.02,-10.88,-46.95,-104.2,-8.28,-75.97,-87.71,-9.025,-103.8,-108.1,44.42,-103.0,-62.38,67.32,-101.0,-17.56,63.54,-100.1,11.74,36.22,-100.1,36.69,31.5,-100.6,36.4,1.773,-101.0,43.32,-14.52,-101.9,88.14,-10.4,-75.28,66.6,-14.55,-45.77,80.43,-14.25,-17.8,69.18,-17.04,11.26,98.61,-14.9,38.55,92.7,-16.93,67.38,48.21,4.405,71.43,51.16,5.773,42.86,62.59,11.28,14.29,69.57,14.61,-14.29,59.85,9.984,-42.86,63.33,11.73,-71.43,44.24,36.6,71.43,23.1,10.1,42.86,34.11,23.89,14.29,41.05,32.54,-14.29,32.8,22.27,-42.86,37.74,28.54,-71.43,18.44,61.61,71.43,8.762,19.33,42.86,9.513,22.64,14.29,10.18,25.52,-14.29,13.03,38.02,-42.86,12.07,34.05,-71.43,-12.94,38.25,71.43,-10.85,29.2,42.86,-20.43,71.56,14.29,-16.06,52.24,-14.29,-16.84,55.55,-42.86,-11.91,33.5,-71.43};
			return value;
		}
		private double[] getCI_3_23_keyValue_23()
		{
			double[] value = {-30.63,19.75,71.43,-42.06,34.24,42.86,-38.77,30.05,14.29,-53.73,48.94,-14.29,-60.23,57.05,-42.86,-58.44,54.66,-71.43,-45.84,3.416,71.43,-60.9,10.77,42.86,-46.31,3.67,14.29,-64.33,12.43,-14.29,-96.3,27.89,-42.86,-134.3,46.14,-71.43,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-33.63,-18.69,71.43,-67.23,-18.55,42.86,-99.87,-18.46,14.29,-83.48,-18.5,-14.29,-103.2,-18.48,-42.86,-107.6,-18.57,-71.43,-102.3,-18.67,-100.0,-115.2,36.81,-100.0,-66.03,64.05,-100.0,-19.56,66.81,-100.0,13.7,41.42,-100.0,36.52,27.1,-100.0,29.16,-4.697,-100.0,42.16,-18.73,-100.0,71.39,-18.75,-71.43,57.1,-18.81,-42.86,81.83,-18.87,-14.29,74.96,-18.85,14.29,88.71,-18.88,42.86,63.74,-18.81,71.43};
			return value;
		}

		/** Large attribute array: Coordinate DEF='NC' point field, scene-graph level=6, element #17, 192 total numbers made up of 64 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getNC_6_17_point()
		{
			MFVec3f NC_6_17_point = new MFVec3f(new double[] {71.37,79.8,71.43,71.38,85.35,42.86,71.4,85.63,14.29,71.44,82.63,-14.29,71.45,83.58,-42.86,71.48,85.29,-71.43,42.79,69.7,71.43,42.81,76.91,42.86,42.83,80.3,14.29,42.87,86.29,-14.29,42.87,81.34,-42.86,42.9,84.51,-71.43,14.22,68.44,71.43,14.24,68.8,42.86,14.26,75.32,14.29,14.3,82.32,-14.29,14.3,77.77,-42.86,14.33,76.74,-71.43,-14.35,60.63,71.43,-14.33,62.32,42.86,-14.31,64.46,14.29,-14.28,65.89,-14.29,-14.27,64.37,-42.86,-14.24,60.55,-71.43,-42.92,52.8,71.43,-42.9,61.7,42.86,-42.88,58.17,14.29,-42.85,52.29,-14.29,-42.84,55.34,-42.86,-42.81,50.97,-71.43,-71.49,54.85,71.43,-71.48,56.05,42.86,-71.46,51.12,14.29,-71.42,50.29,-14.29,-71.41,53.25,-42.86,-71.38,46.34,-71.43,100.0,50.0,100.0,71.43,50.0,100.0,42.86,50.0,100.0,14.29,50.0,100.0,-14.29,50.0,100.0,-42.86,50.0,100.0,-71.43,50.0,100.0,-100.0,50.0,100.0,-100.1,51.8,71.43,-100.0,51.62,42.86,-100.0,47.08,14.29,-99.99,46.26,-14.29,-99.98,41.67,-42.86,-99.95,44.94,-71.43,-99.91,44.88,-100.0,-71.34,46.19,-100.0,-42.77,54.69,-100.0,-14.19,61.88,-100.0,14.38,74.08,-100.0,42.95,87.84,-100.0,71.52,84.48,-100.0,100.1,77.23,-100.0,100.0,73.53,-71.43,100.0,73.46,-42.86,100.0,72.08,-14.29,99.97,82.06,14.29,99.95,87.63,42.86,99.94,83.88,71.43});
			return NC_6_17_point;
		}
		/** Large attribute array: CoordinateInterpolator DEF='CI' keyValue field, scene-graph level=3, element #23, 6720 total numbers made up of 2240 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCI_3_23_keyValue()
		{
			MFVec3f CI_3_23_keyValue = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCI_3_23_keyValue_1()))
				.append(new MFVec3f(getCI_3_23_keyValue_2()))
				.append(new MFVec3f(getCI_3_23_keyValue_3()))
				.append(new MFVec3f(getCI_3_23_keyValue_4()))
				.append(new MFVec3f(getCI_3_23_keyValue_5()))
				.append(new MFVec3f(getCI_3_23_keyValue_6()))
				.append(new MFVec3f(getCI_3_23_keyValue_7()))
				.append(new MFVec3f(getCI_3_23_keyValue_8()))
				.append(new MFVec3f(getCI_3_23_keyValue_9()))
				.append(new MFVec3f(getCI_3_23_keyValue_10()))
				.append(new MFVec3f(getCI_3_23_keyValue_11()))
				.append(new MFVec3f(getCI_3_23_keyValue_12()))
				.append(new MFVec3f(getCI_3_23_keyValue_13()))
				.append(new MFVec3f(getCI_3_23_keyValue_14()))
				.append(new MFVec3f(getCI_3_23_keyValue_15()))
				.append(new MFVec3f(getCI_3_23_keyValue_16()))
				.append(new MFVec3f(getCI_3_23_keyValue_17()))
				.append(new MFVec3f(getCI_3_23_keyValue_18()))
				.append(new MFVec3f(getCI_3_23_keyValue_19()))
				.append(new MFVec3f(getCI_3_23_keyValue_20()))
				.append(new MFVec3f(getCI_3_23_keyValue_21()))
				.append(new MFVec3f(getCI_3_23_keyValue_22()))
				.append(new MFVec3f(getCI_3_23_keyValue_23()));
			return CI_3_23_keyValue;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return NurbsPatchSurfaceExampleLarge model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new NurbsPatchSurfaceExampleLarge().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.NurbsPatchSurfaceExampleLarge\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.NurbsPatchSurfaceExampleLarge self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/NurbsPatchSurfaceExampleLarge_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/NurbsPatchSurfaceExampleLarge_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/NurbsPatchSurfaceExampleLarge_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/NurbsPatchSurfaceExampleLarge_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
