package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.NURBS.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> A NURBS patch representing a segment of a cylinder. An applied image texture depicts the u-v axes of the parametric coordinate system. Defined Viewpoints show the inner and outer sides of the cylindrical surface. </p>
 <p> Related links: Catalog page <a href="../../../NURBS/NurbsPatchImageTextureIndex.html" target="_blank">NurbsPatchImageTexture</a>,  source <a href="../../../NURBS/NurbsPatchImageTexture.java">NurbsPatchImageTexture.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/NurbsPatchImageTexture.x3d">NurbsPatchImageTexture.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> A NURBS patch representing a segment of a cylinder. An applied image texture depicts the u-v axes of the parametric coordinate system. Defined Viewpoints show the inner and outer sides of the cylindrical surface </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Vincent Marchetti </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 31 August 2011 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/NurbsPatchImageTexture1.jpg">NurbsPatchImageTexture1.jpg</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/NurbsPatchImageTexture2.jpg">NurbsPatchImageTexture2.jpg</a> </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Currently only Octaga 2.0 properly implements the X3D NURBS component, see the following page for status. </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> <a href="http://www.kshell.com/pages/nurbs_surface_demo" target="_blank">http://www.kshell.com/pages/nurbs_surface_demo</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/NurbsPatchImageTextureBSContact.png">images/NurbsPatchImageTextureBSContact.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/NurbsPatchImageTextureH3dViewer.png">images/NurbsPatchImageTextureH3dViewer.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/NurbsPatchImageTextureInstantReality.png">images/NurbsPatchImageTextureInstantReality.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/NurbsPatchImageTextureOctagaVS.png">images/NurbsPatchImageTextureOctagaVS.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/NurbsPatchImageTextureView3dscene.png">images/NurbsPatchImageTextureView3dscene.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/NurbsPatchImageTextureXj3d.png">images/NurbsPatchImageTextureXj3d.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.kshell.com/pages/nurbs_surface_demo" target="_blank">http://www.kshell.com/pages/nurbs_surface_demo</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> AxesTexture.png </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPatchImageTexture.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPatchImageTexture.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Python language scripting </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Vincent Marchetti
 */

public class NurbsPatchImageTexture
{
	/** Default constructor to create this object. */
	public NurbsPatchImageTexture ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_2)
  .setHead(new head()
    .addComponent(new component().setName("NURBS").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("NurbsPatchImageTexture.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("A NURBS patch representing a segment of a cylinder. An applied image texture depicts the u-v axes of the parametric coordinate system. Defined Viewpoints show the inner and outer sides of the cylindrical surface"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Vincent Marchetti"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("31 August 2011"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("NurbsPatchImageTexture1.jpg"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("NurbsPatchImageTexture2.jpg"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("Currently only Octaga 2.0 properly implements the X3D NURBS component, see the following page for status."))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("http://www.kshell.com/pages/nurbs_surface_demo"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/NurbsPatchImageTextureBSContact.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/NurbsPatchImageTextureH3dViewer.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/NurbsPatchImageTextureInstantReality.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/NurbsPatchImageTextureOctagaVS.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/NurbsPatchImageTextureView3dscene.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/NurbsPatchImageTextureXj3d.png"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.kshell.com/pages/nurbs_surface_demo"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("AxesTexture.png"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPatchImageTexture.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Python language scripting"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("NurbsPatchImageTexture.x3d"))
    .addChild(new Background().setSkyColor(new MFColor(new double[] {0.5,0.5,0.5})))
    .addChild(new Viewpoint().setDescription("view outer surface").setFieldOfView(0.16628).setOrientation(0.166,0.465,0.87,2.538).setPosition(10.55,12.855,11.111))
    .addChild(new Viewpoint().setDescription("view inner surface").setFieldOfView(0.16628).setOrientation(0.797,-0.285,-0.533,1.182).setPosition(-10.55,-12.855,11.111))
    .addChild(new Shape()
      .setGeometry(new NurbsPatchSurface().setSolid(false).setUDimension(5).setUKnot(new double[] {0.0,0.0,0.0,0.5,0.5,1.0,1.0,1.0}).setVDimension(2).setVKnot(new double[] {0.0,0.0,1.0,1.0}).setVOrder(2).setWeight(new double[] {1.0,0.92388,1.0,0.92388,1.0,1.0,0.92388,1.0,0.92388,1.0})
        .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {1.0,0.0,0.0,0.92388,0.38268,0.0,0.70711,0.70711,0.0,0.38268,0.92388,0.0,-0.000004,1.0,0.0,1.0,0.0,1.0,0.92388,0.38268,0.92388,0.70711,0.70711,1.0,0.38268,0.92388,0.92388,-0.000004,1.0,1.0}))))
      .setAppearance(new Appearance()
        .setTexture(new ImageTexture().setUrl(new String[] {"AxesTexture.png","https://www.web3d.org/x3d/content/examples/Basic/NURBS/AxesTexture.png"}))))
    .addChild(new Group()
      .addChild(new Shape()
        .setGeometry(new LineSet().setVertexCount(new int[] {2})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,1.0,0.0,0.0}))))
        .setAppearance(new Appearance()
          .setMaterial(new Material().setEmissiveColor(1.0,0.0,0.0))
          .setLineProperties(new LineProperties().setLinewidthScaleFactor(2))))
      .addChild(new Shape()
        .setGeometry(new LineSet().setVertexCount(new int[] {2})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,0.0,1.0,0.0}))))
        .setAppearance(new Appearance()
          .setMaterial(new Material().setEmissiveColor(0.0,1.0,0.0))
          .setLineProperties(new LineProperties().setLinewidthScaleFactor(2))))
      .addChild(new Shape()
        .setGeometry(new LineSet().setVertexCount(new int[] {2})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,0.0,0.0,1.0}))))
        .setAppearance(new Appearance()
          .setMaterial(new Material().setEmissiveColor(0.0,0.0,1.0))
          .setLineProperties(new LineProperties().setLinewidthScaleFactor(2))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return NurbsPatchImageTexture model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new NurbsPatchImageTexture().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.NurbsPatchImageTexture\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.NurbsPatchImageTexture self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/NurbsPatchImageTexture_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/NurbsPatchImageTexture_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/NurbsPatchImageTexture_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/NurbsPatchImageTexture_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
