package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Non-Uniform Rational B-Spline (NURBS) external prototype definitions, used for building VRML 97 signatures for inclusion in X3dToVrml97 conversion stylesheet. </p>
 <p> Related links: Catalog page <a href="../../../NURBS/NurbsExternPrototypesIndex.html" target="_blank">NurbsExternPrototypes</a>,  source <a href="../../../NURBS/NurbsExternPrototypes.java">NurbsExternPrototypes.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/NurbsExternPrototypes.x3d">NurbsExternPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Non-Uniform Rational B-Spline (NURBS) external prototype definitions, used for building VRML 97 signatures for inclusion in X3dToVrml97 conversion stylesheet. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> revisor </i> </td>
			<td> Alan Shaffer </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 28 February 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> under development, needs to be upgraded to final version of X3D NURBS nodes </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> info </i> </td>
			<td> .wrl url links intentionally precede .x3d links, X3D-Edit stylesheet X3dToVrml97.xslt automatically inserts VRML97 translations of these external prototype declarations upon encountering any DIS nodes. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../NURBS/NurbsPrototypes.x3d">NurbsPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/files/specifications/19775-1/V3.3/Part01/components/nurbs.html" target="_blank">https://www.web3d.org/files/specifications/19775-1/V3.3/Part01/components/nurbs.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> NURBS Prototypes </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsExternPrototypes.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsExternPrototypes.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Don Brutzman
 */

public class NurbsExternPrototypes
{
	/** Default constructor to create this object. */
	public NurbsExternPrototypes ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("NurbsExternPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Non-Uniform Rational B-Spline (NURBS) external prototype definitions, used for building VRML 97 signatures for inclusion in X3dToVrml97 conversion stylesheet."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Don Brutzman"))
    .addMeta(new meta().setName("revisor").setContent("Alan Shaffer"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("28 February 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("under development, needs to be upgraded to final version of X3D NURBS nodes"))
    .addMeta(new meta().setName(meta.NAME_INFO       ).setContent(".wrl url links intentionally precede .x3d links, X3D-Edit stylesheet X3dToVrml97.xslt automatically inserts VRML97 translations of these external prototype declarations upon encountering any DIS nodes."))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("NurbsPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/files/specifications/19775-1/V3.3/Part01/components/nurbs.html"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("NURBS Prototypes"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsExternPrototypes.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("NurbsExternPrototypes.x3d"))
    .addChild(new ExternProtoDeclare("Contour2D").setName("Contour2D").setAppinfo("Contour2D node groups a set of curve segments (either NurbsCurve2D or ContourPolyline2D nodes) to a composite contour in consecutive order according to the topology of the contour. The children shall form a closed loop with the first point of the first child repeated as the last point of the last child and the last point of a segment repeated as the first point of the consecutive one.").setDocumentation("https://www.web3d.org/technicalinfo/specifications/ISO_IEC_19775/Part01/components/nurbs.html#Contour2D").setUrl(new String[] {"NurbsPrototypes.x3d#Contour2D","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#Contour2D","NurbsPrototypes.wrl#Contour2D","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#Contour2D"})
      .addField(new field().setName("addChildren").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[NurbsCurve|ContourPolyline2D]"))
      .addField(new field().setName("removeChildren").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[NurbsCurve|ContourPolyline2D]"))
      .addField(new field().setName("children").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[NurbsCurve|ContourPolyline2D] default []"))
      .addField(new field().setName("set_children").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("children_changed").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("ContourPolyline2D").setName("ContourPolyline2D").setUrl(new String[] {"NurbsPrototypes.x3d#ContourPolyline2D","../NURBS/NurbsPrototypes.x3d#ContourPolyline2D","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#ContourPolyline2D","NurbsPrototypes.wrl#ContourPolyline2D","../NURBS/NurbsPrototypes.wrl#ContourPolyline2D","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#ContourPolyline2D"})
      .addField(new field().setName("point").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("set_point").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("point_changed").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("CoordinateDouble").setName("CoordinateDouble").setUrl(new String[] {"NurbsPrototypes.x3d#CoordinateDouble","../NURBS/NurbsPrototypes.x3d#CoordinateDouble","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#CoordinateDouble","NurbsPrototypes.wrl#CoordinateDouble","../NURBS/NurbsPrototypes.wrl#CoordinateDouble","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#CoordinateDouble"})
      .addField(new field().setName("point").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("set_point").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("point_changed").setType(field.TYPE_MFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsCurve").setName("NurbsCurve").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsCurve","../NURBS/NurbsPrototypes.x3d#NurbsCurve","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsCurve","NurbsPrototypes.wrl#NurbsCurve","../NURBS/NurbsPrototypes.wrl#NurbsCurve","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsCurve"})
      .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode] default []"))
      .addField(new field().setName("tessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default 0"))
      .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (0,∞) default []"))
      .addField(new field().setName("closed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default false"))
      .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [2,∞) default 3"))
      .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_tessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("tessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsCurve2D").setName("NurbsCurve2D").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsCurve2D","../NURBS/NurbsPrototypes.x3d#NurbsCurve2D","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsCurve2D","NurbsPrototypes.wrl#NurbsCurve2D","../NURBS/NurbsPrototypes.wrl#NurbsCurve2D","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsCurve2D"})
      .addField(new field().setName("controlPoint").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("tessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default 0"))
      .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (0,∞) default []"))
      .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [2,∞) default 3"))
      .addField(new field().setName("closed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default false"))
      .addField(new field().setName("set_controlPoint").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("controlPoint_changed").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_tessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("tessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsOrientationInterpolator").setName("NurbsOrientationInterpolator").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsOrientationInterpolator","../NURBS/NurbsPrototypes.x3d#NurbsOrientationInterpolator","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsOrientationInterpolator","NurbsPrototypes.wrl#NurbsOrientationInterpolator","../NURBS/NurbsPrototypes.wrl#NurbsOrientationInterpolator","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsOrientationInterpolator"})
      .addField(new field().setName("set_fraction").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("range (-∞,∞)"))
      .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode] default []"))
      .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (2,∞) default 3"))
      .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("value_changed").setType(field.TYPE_SFROTATION).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("knot_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("order_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsPatchSurface").setName("NurbsPatchSurface").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsPatchSurface","../NURBS/NurbsPrototypes.x3d#NurbsPatchSurface","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsPatchSurface","NurbsPrototypes.wrl#NurbsPatchSurface","../NURBS/NurbsPrototypes.wrl#NurbsPatchSurface","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsPatchSurface"})
      .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode] default []"))
      .addField(new field().setName("texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DTextureCoordinateNode|NurbsTextureCoordinate] default []"))
      .addField(new field().setName("uTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default 0"))
      .addField(new field().setName("vTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default 0"))
      .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (0,∞) default []"))
      .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default true"))
      .addField(new field().setName("uClosed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default false"))
      .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [0,∞) default 0"))
      .addField(new field().setName("uKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("uOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [2,∞) default 3"))
      .addField(new field().setName("vClosed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default false"))
      .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [0,∞) default 0"))
      .addField(new field().setName("vKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("vOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [2,∞) default 3"))
      .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("texCoord_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_uTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("uTessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_vTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("vTessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsPositionInterpolator").setName("NurbsPositionInterpolator").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsPositionInterpolator","../NURBS/NurbsPrototypes.x3d#NurbsPositionInterpolator","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsPositionInterpolator","NurbsPrototypes.wrl#NurbsPositionInterpolator","../NURBS/NurbsPrototypes.wrl#NurbsPositionInterpolator","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsPositionInterpolator"})
      .addField(new field().setName("set_fraction").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("range (-∞,∞)"))
      .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode] default []"))
      .addField(new field().setName("knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (2,∞) default 3"))
      .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("value_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_knot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("knot_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_order").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("order_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsSet").setName("NurbsSet").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsSet","../NURBS/NurbsPrototypes.x3d#NurbsSet","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsSet","NurbsPrototypes.wrl#NurbsSet","../NURBS/NurbsPrototypes.wrl#NurbsSet","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsSet"})
      .addField(new field().setName("addGeometry").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[NurbsPatchSurface]"))
      .addField(new field().setName("removeGeometry").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[NurbsPatchSurface]"))
      .addField(new field().setName("geometry").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[NurbsPatchSurface] default []"))
      .addField(new field().setName("tessellationScale").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (0,∞) default 1.0"))
      .addField(new field().setName("bboxCenter").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default [0 0 0]"))
      .addField(new field().setName("bboxSize").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [0,∞); [-1 -1 -1] default [-1 -1 -1]"))
      .addField(new field().setName("set_geometry").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("geometry_changed").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_tessellationScale").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("tessellationScale_changed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsSurfaceInterpolator").setName("NurbsSurfaceInterpolator").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsSurfaceInterpolator","../NURBS/NurbsPrototypes.x3d#NurbsSurfaceInterpolator","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsSurfaceInterpolator","NurbsPrototypes.wrl#NurbsSurfaceInterpolator","../NURBS/NurbsPrototypes.wrl#NurbsSurfaceInterpolator","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsSurfaceInterpolator"})
      .addField(new field().setName("set_fraction").setType(field.TYPE_SFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("range (-∞,∞)"))
      .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode] default []"))
      .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("position_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("normal_changed").setType(field.TYPE_SFVEC3F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [0,∞) default 0"))
      .addField(new field().setName("uKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("uOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [2,∞) default 3"))
      .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [0,∞) default 0"))
      .addField(new field().setName("vKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("vOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [2∞) default 3"))
      .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsSweptSurface").setName("NurbsSweptSurface").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsSweptSurface","../NURBS/NurbsPrototypes.x3d#NurbsSweptSurface","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsSweptSurface","NurbsPrototypes.wrl#NurbsSweptSurface","../NURBS/NurbsPrototypes.wrl#NurbsSweptSurface","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsSweptSurface"})
      .addField(new field().setName("crossSectionCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DNurbsControlCurveNode] default []"))
      .addField(new field().setName("trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[NurbsCurve] default []"))
      .addField(new field().setName("ccw").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default true"))
      .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default true"))
      .addField(new field().setName("set_crossSectionCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("crossSectionCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("trajectoryCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsSwungSurface").setName("NurbsSwungSurface").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsSwungSurface","../NURBS/NurbsPrototypes.x3d#NurbsSwungSurface","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsSwungSurface","NurbsPrototypes.wrl#NurbsSwungSurface","../NURBS/NurbsPrototypes.wrl#NurbsSwungSurface","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsSwungSurface"})
      .addField(new field().setName("profileCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DNurbsControlCurveNode] default []"))
      .addField(new field().setName("trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DNurbsControlCurveNode] default []"))
      .addField(new field().setName("ccw").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default true"))
      .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default true"))
      .addField(new field().setName("set_profileCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("profileCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_trajectoryCurve").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("trajectoryCurve_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsTextureCoordinate").setName("NurbsTextureCoordinate").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsTextureCoordinate","../NURBS/NurbsPrototypes.x3d#NurbsTextureSurface","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsTextureCoordinate","NurbsPrototypes.wrl#NurbsTextureCoordinate","../NURBS/NurbsPrototypes.wrl#NurbsTextureCoordinate","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsTextureCoordinate"})
      .addField(new field().setName("controlPoint").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("weight").setType(field.TYPE_MFFLOAT).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (0,∞) default []"))
      .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [0,∞) default 0"))
      .addField(new field().setName("uKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("uOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [2∞) default 3"))
      .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [0,∞) default 0"))
      .addField(new field().setName("vKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("vOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [2,∞) default 3"))
      .addField(new field().setName("set_controlPoint").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("controlPoint_changed").setType(field.TYPE_MFVEC2F).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_weight").setType(field.TYPE_MFFLOAT).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("weight_changed").setType(field.TYPE_MFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new ExternProtoDeclare("NurbsTrimmedSurface").setName("NurbsTrimmedSurface").setUrl(new String[] {"NurbsPrototypes.x3d#NurbsTrimmedSurface","../NURBS/NurbsPrototypes.x3d#NurbsTrimmedSurface","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.x3d#NurbsTrimmedSurface","NurbsPrototypes.wrl#NurbsTrimmedSurface","../NURBS/NurbsPrototypes.wrl#NurbsTrimmedSurface","https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsPrototypes.wrl#NurbsTrimmedSurface"})
      .addComments(" No attributes, node-type children and events only. ")
      .addField(new field().setName("addTrimmingContour").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[Contour2D]"))
      .addField(new field().setName("removeTrimmingContour").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY).setAppinfo("[Contour2D]"))
      .addField(new field().setName("controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DCoordinateNode] default []"))
      .addField(new field().setName("texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[X3DTextureCoordinateNode|NurbsTextureCoordinate] default []"))
      .addField(new field().setName("trimmingContour").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("[Contour2D] default []"))
      .addField(new field().setName("uTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default 0"))
      .addField(new field().setName("vTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default 0"))
      .addField(new field().setName("weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (0,∞) default []"))
      .addField(new field().setName("solid").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default true"))
      .addField(new field().setName("uClosed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default false"))
      .addField(new field().setName("uDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [0,∞) default 0"))
      .addField(new field().setName("uKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("uOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [2,∞) default 3"))
      .addField(new field().setName("vClosed").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("default false"))
      .addField(new field().setName("vDimension").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [0,∞) default 0"))
      .addField(new field().setName("vKnot").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range (-∞,∞) default []"))
      .addField(new field().setName("vOrder").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INITIALIZEONLY).setAppinfo("range [2,∞) default 3"))
      .addField(new field().setName("set_controlPoint").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("controlPoint_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_texCoord").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("texCoord_changed").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_trimmingContour").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("trimmingContour_changed").setType(field.TYPE_MFNODE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_uTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("uTessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_vTessellation").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("vTessellation_changed").setType(field.TYPE_SFINT32).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_weight").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_INPUTONLY))
      .addField(new field().setName("weight_changed").setType(field.TYPE_MFDOUBLE).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("metadata").setType(field.TYPE_SFNODE).setAccessType(field.ACCESSTYPE_INPUTOUTPUT).setAppinfo("Metadata node only")))
    .addChild(new Shape()
      .setAppearance(new Appearance()
        .setMaterial(new Material().setDiffuseColor(0.8,0.6,0.2)))
      .setGeometry(new Text().setString(new String[] {"NurbsExternPrototypes is a","developmental file for producing","EXTERNPROTO signatures","in VRML 97 syntax."})
        .setFontStyle(new FontStyle().setJustify(FontStyle.JUSTIFY_MIDDLE_MIDDLE).setSize(0.7)))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return NurbsExternPrototypes model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new NurbsExternPrototypes().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.NurbsExternPrototypes\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.NurbsExternPrototypes self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/NurbsExternPrototypes_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/NurbsExternPrototypes_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/NurbsExternPrototypes_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/NurbsExternPrototypes_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
