package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.NURBS.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Text.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> NurbsCurve exemplar showing controlPoint animation. Upper example has knot values explicitly defined, lower example has implicit knot values. </p>
 <p> Related links: Catalog page <a href="../../../NURBS/NurbsCurveExampleIndex.html" target="_blank">NurbsCurveExample</a>,  source <a href="../../../NURBS/NurbsCurveExample.java">NurbsCurveExample.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/NurbsCurveExample.x3d">NurbsCurveExample.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> NurbsCurve exemplar showing controlPoint animation. Upper example has knot values explicitly defined, lower example has implicit knot values. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Charles Adams, Vincent Marchetti, Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 4 February 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> MovingImage </i> </td>
			<td> <a href="../../../NURBS/videos/NurbsCurveExample.mov">videos/NurbsCurveExample.mov</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> TODO </i> </td>
			<td> check NurbsCurve containerField handling and weight defaults </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf" target="_blank">http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> NURBS Curve Example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsCurveExample.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsCurveExample.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Charles Adams, Vincent Marchetti, Don Brutzman
 */

public class NurbsCurveExample
{
	/** Default constructor to create this object. */
	public NurbsCurveExample ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addComponent(new component().setName("NURBS").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("NurbsCurveExample.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("NurbsCurve exemplar showing controlPoint animation. Upper example has knot values explicitly defined, lower example has implicit knot values."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Charles Adams, Vincent Marchetti, Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("4 February 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_MOVINGIMAGE).setContent("videos/NurbsCurveExample.mov"))
    .addMeta(new meta().setName(meta.NAME_TODO       ).setContent("check NurbsCurve containerField handling and weight defaults"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("NURBS Curve Example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/NurbsCurveExample.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("NurbsCurveExample.x3d"))
    .addChild(new Viewpoint().setDescription("NurbsCurve").setPosition(12.0,7.0,18.0))
    .addChild(new Transform().setTranslation(0.0,5.0,0.0)
      .addChild(new Shape()
        .setGeometry(new NurbsCurve("NurbsCurveKnotted").setKnot(new double[] {0.0,0.0,0.0,0.0,0.5,1.0,1.0,1.0,1.0}).setOrder(4).setTessellation(30).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0})
          .setControlPoint(new Coordinate("np").setPoint(new MFVec3f(new double[] {4.0,6.0,0.0,7.0,12.0,0.0,11.0,6.0,0.0,15.0,2.0,0.0,20.0,6.0,0.0}))))
        .setAppearance(new Appearance("LightGreenAppearance")
          .setMaterial(new Material().setDiffuseColor(0.8,1.0,0.8).setEmissiveColor(0.8,1.0,0.8))))
      .addChild(new Transform().setTranslation(0.0,7.0,0.0)
        .addChild(new Shape()
          .setGeometry(new Text().setString(new String[] {"NurbsCurve with knots"}))
          .setAppearance(new Appearance().setUSE("LightGreenAppearance")))))
    .addChild(new Shape()
      .setGeometry(new NurbsCurve("NurbsCurveUnknotted").setOrder(4).setTessellation(30)
        .setControlPoint(new Coordinate().setUSE("np")))
      .setAppearance(new Appearance("LightBlueAppearance")
        .setMaterial(new Material().setDiffuseColor(0.8,0.8,1.0).setEmissiveColor(0.8,0.8,1.0))))
    .addChild(new Transform().setTranslation(0.0,7.0,0.0)
      .addChild(new Shape()
        .setGeometry(new Text().setString(new String[] {"NurbsCurve without knots"}))
        .setAppearance(new Appearance().setUSE("LightBlueAppearance"))))
    .addChild(new CoordinateInterpolator("ci").setKey(new double[] {0.0,.5,1.0}).setKeyValue(new MFVec3f(new double[] {4.0,6.0,0.0,7.0,12.0,0.0,11.0,6.0,0.0,15.0,2.0,0.0,20.0,6.0,0.0,4.0,6.0,0.0,7.0,0.0,0.0,11.0,6.0,0.0,15.0,10.0,0.0,20.0,6.0,0.0,4.0,6.0,0.0,7.0,12.0,0.0,11.0,6.0,0.0,15.0,2.0,0.0,20.0,6.0,0.0})))
    .addChild(new TimeSensor("ts").setCycleInterval(6).setLoop(true))
    .addChild(new ROUTE().setFromNode("ts").setFromField("fraction_changed").setToNode("ci").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("ci").setFromField("value_changed").setToNode("np").setToField("set_point"))
    .addComments(" Authoring hint ")
    .addChild(new Transform("GridXY_20x20Fixed_AdjustScale").setTranslation(12.0,7.0,0.0)
      .addChild(new Inline("GridXY_20x20Fixed").setUrl(new String[] {"GridXY_20x20Fixed.x3d","../../Savage/Tools/Authoring/GridXY_20x20Fixed.x3d","https://savage.nps.edu/Savage/Tools/Authoring/GridXY_20x20Fixed.x3d","GridXY_20x20Fixed.wrl","../../Savage/Tools/Authoring/GridXY_20x20Fixed.wrl","https://savage.nps.edu/Savage/Tools/Authoring/GridXY_20x20Fixed.wrl"}))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return NurbsCurveExample model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new NurbsCurveExample().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.NurbsCurveExample\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.NurbsCurveExample self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/NurbsCurveExample_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/NurbsCurveExample_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/NurbsCurveExample_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/NurbsCurveExample_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
