####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python MobiusNurbs.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.2',
  head=head(
    children=[
    component(level=1,name='NURBS'),
    meta(content='MobiusNurbs.x3d',name='title'),
    meta(content='Demonstrates 3 NurbsSurfacePatch nodes defining the outer boundary of a toroidal solid.',name='description'),
    meta(content='Vincent Marchetti',name='creator'),
    meta(content='10 February 2012',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='MobiusNurbs.jpg',name='Image'),
    meta(content='MobiusNurbsBrowserPalooza.jpg',name='Image'),
    meta(content='images/MobiusBSContact.png',name='Image'),
    meta(content='images/MobiusH3dViewer.png',name='Image'),
    meta(content='images/MobiusInstantReality.png',name='Image'),
    meta(content='images/MobiusOctagaVS.png',name='Image'),
    meta(content='images/MobiusView3dscene.png',name='Image'),
    meta(content='images/MobiusXj3d.png',name='Image'),
    meta(content='originals/mobius.x3d',name='reference'),
    meta(content='http://en.wikipedia.org/wiki/M%C3%B6bius_strip',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/X3dForAdvancedModeling/GeometricShapes/MobiusExtrusion.x3d',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/NURBS/MobiusNurbs.x3d',name='identifier'),
    meta(content='Python language scripts using Numpy, SciPy libraries http://numpy.scipy.org',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='MobiusNurbs.x3d'),
    Viewpoint(description='Mobius strip made from three NurbsPatchSurface nodes',orientation=(1,0,0,-0.54042),position=(0,60,100)),
    Background(skyColor=[(1,1,1)]),
    NavigationInfo(),
    Shape(
      geometry=NurbsPatchSurface(solid=False,uDimension=3,uKnot=[0,0,0,1,1,1],vDimension=136,vKnot=[0,0,0,0,0.0222222222222,0.0222222222222,0.0222222222222,0.0444444444444,0.0444444444444,0.0444444444444,0.0666666666667,0.0666666666667,0.0666666666667,0.0888888888889,0.0888888888889,0.0888888888889,0.111111111111,0.111111111111,0.111111111111,0.133333333333,0.133333333333,0.133333333333,0.155555555556,0.155555555556,0.155555555556,0.177777777778,0.177777777778,0.177777777778,0.2,0.2,0.2,0.222222222222,0.222222222222,0.222222222222,0.244444444444,0.244444444444,0.244444444444,0.266666666667,0.266666666667,0.266666666667,0.288888888889,0.288888888889,0.288888888889,0.311111111111,0.311111111111,0.311111111111,0.333333333333,0.333333333333,0.333333333333,0.355555555556,0.355555555556,0.355555555556,0.377777777778,0.377777777778,0.377777777778,0.4,0.4,0.4,0.422222222222,0.422222222222,0.422222222222,0.444444444444,0.444444444444,0.444444444444,0.466666666667,0.466666666667,0.466666666667,0.488888888889,0.488888888889,0.488888888889,0.511111111111,0.511111111111,0.511111111111,0.533333333333,0.533333333333,0.533333333333,0.555555555556,0.555555555556,0.555555555556,0.577777777778,0.577777777778,0.577777777778,0.6,0.6,0.6,0.622222222222,0.622222222222,0.622222222222,0.644444444444,0.644444444444,0.644444444444,0.666666666667,0.666666666667,0.666666666667,0.688888888889,0.688888888889,0.688888888889,0.711111111111,0.711111111111,0.711111111111,0.733333333333,0.733333333333,0.733333333333,0.755555555556,0.755555555556,0.755555555556,0.777777777778,0.777777777778,0.777777777778,0.8,0.8,0.8,0.822222222222,0.822222222222,0.822222222222,0.844444444444,0.844444444444,0.844444444444,0.866666666667,0.866666666667,0.866666666667,0.888888888889,0.888888888889,0.888888888889,0.911111111111,0.911111111111,0.911111111111,0.933333333333,0.933333333333,0.933333333333,0.955555555556,0.955555555556,0.955555555556,0.977777777778,0.977777777778,0.977777777778,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        controlPoint=Coordinate(point=[(2.6000e+01,3.4641e+00,0.0000e+00),(2.0000e+01,3.4641e+00,0.0000e+00),(1.4000e+01,3.4641e+00,0.0000e+00),(2.5946e+01,3.5572e+00,9.3084e-01),(1.9973e+01,3.3943e+00,4.6542e-01),(1.3946e+01,3.3710e+00,9.3084e-01),(2.5768e+01,3.6490e+00,2.6815e+00),(1.9835e+01,3.1835e+00,1.8476e+00),(1.3889e+01,3.2767e+00,1.0120e+00),(2.5581e+01,3.7395e+00,3.5952e+00),(1.9665e+01,3.0421e+00,2.7637e+00),(1.3711e+01,3.1812e+00,1.9269e+00),(2.5394e+01,3.8300e+00,4.5089e+00),(1.9495e+01,2.9006e+00,3.6799e+00),(1.3532e+01,3.0857e+00,2.8418e+00),(2.4975e+01,3.9191e+00,6.1930e+00),(1.9274e+01,2.7583e+00,4.5583e+00),(1.3473e+01,2.9891e+00,2.8949e+00),(2.4658e+01,4.0068e+00,7.0707e+00),(1.8990e+01,2.6162e+00,5.4454e+00),(1.3173e+01,2.8914e+00,3.7773e+00),(2.4342e+01,4.0945e+00,7.9483e+00),(1.8707e+01,2.4740e+00,6.3326e+00),(1.2873e+01,2.7937e+00,4.6597e+00),(2.3697e+01,4.1807e+00,9.5319e+00),(1.8382e+01,2.3317e+00,7.1652e+00),(1.2818e+01,2.6950e+00,4.6880e+00),(2.3258e+01,4.2654e+00,1.0355e+01),(1.7990e+01,2.1900e+00,8.0095e+00),(1.2403e+01,2.5954e+00,5.5220e+00),(2.2819e+01,4.3501e+00,1.1179e+01),(1.7598e+01,2.0484e+00,8.8539e+00),(1.1987e+01,2.4957e+00,6.3560e+00),(2.1970e+01,4.4333e+00,1.2631e+01),(1.7174e+01,1.9071e+00,9.6337e+00),(1.1940e+01,2.3951e+00,6.3635e+00),(2.1418e+01,4.5148e+00,1.3383e+01),(1.6679e+01,1.7672e+00,1.0422e+01),(1.1417e+01,2.2937e+00,7.1340e+00),(2.0865e+01,4.5963e+00,1.4135e+01),(1.6184e+01,1.6272e+00,1.1210e+01),(1.0893e+01,2.1923e+00,7.9046e+00),(1.9836e+01,4.6762e+00,1.5429e+01),(1.5666e+01,1.4883e+00,1.1930e+01),(1.0858e+01,2.0900e+00,7.8962e+00),(1.9181e+01,4.7544e+00,1.6095e+01),(1.5076e+01,1.3511e+00,1.2650e+01),(1.0237e+01,1.9870e+00,8.5895e+00),(1.8526e+01,4.8326e+00,1.6761e+01),(1.4485e+01,1.2140e+00,1.3370e+01),(9.6146e+00,1.8841e+00,9.2827e+00),(1.7346e+01,4.9091e+00,1.7874e+01),(1.3878e+01,1.0784e+00,1.4022e+01),(9.5936e+00,1.7804e+00,9.2636e+00),(1.6603e+01,4.9837e+00,1.8439e+01),(1.3201e+01,9.4527e-01,1.4661e+01),(8.8844e+00,1.6761e+00,9.8672e+00),(1.5859e+01,5.0584e+00,1.9005e+01),(1.2524e+01,8.1209e-01,1.5301e+01),(8.1753e+00,1.5718e+00,1.0471e+01),(1.4559e+01,5.1313e+00,1.9921e+01),(1.1832e+01,6.8102e-01,1.5877e+01),(8.1687e+00,1.4669e+00,1.0446e+01),(1.3743e+01,5.2022e+00,2.0374e+01),(1.1079e+01,5.5285e-01,1.6426e+01),(7.3852e+00,1.3615e+00,1.0949e+01),(1.2926e+01,5.2732e+00,2.0828e+01),(1.0327e+01,4.2467e-01,1.6974e+01),(6.6017e+00,1.2561e+00,1.1452e+01),(1.1538e+01,5.3423e+00,2.1534e+01),(9.5542e+00,2.9912e-01,1.7466e+01),(6.6087e+00,1.1502e+00,1.1426e+01),(1.0665e+01,5.4095e+00,2.1866e+01),(8.7371e+00,1.7695e-01,1.7914e+01),(5.7650e+00,1.0440e+00,1.1820e+01),(9.7916e+00,5.4767e+00,2.2199e+01),(7.9200e+00,5.4771e-02,1.8362e+01),(4.9212e+00,9.3772e-01,1.2213e+01),(8.3509e+00,5.5419e+00,2.2689e+01),(7.0734e+00,-6.4292e-02,1.8758e+01),(4.9399e+00,8.3109e-01,1.2191e+01),(7.4387e+00,5.6050e+00,2.2894e+01),(6.2050e+00,-1.7954e-01,1.9097e+01),(4.0511e+00,7.2419e-01,1.2468e+01),(6.5266e+00,5.6682e+00,2.3099e+01),(5.3366e+00,-2.9478e-01,1.9437e+01),(3.1624e+00,6.1730e-01,1.2745e+01),(5.0664e+00,5.7294e+00,2.3372e+01),(4.4234e+00,-4.0646e-01,1.9726e+01),(3.1897e+00,5.1014e-01,1.2729e+01),(4.1341e+00,5.7884e+00,2.3445e+01),(3.5178e+00,-5.1392e-01,1.9950e+01),(2.2719e+00,4.0284e-01,1.2885e+01),(3.2018e+00,5.8475e+00,2.3519e+01),(2.6122e+00,-6.2138e-01,2.0175e+01),(1.3541e+00,2.9554e-01,1.3040e+01),(1.7548e+00,5.9045e+00,2.3579e+01),(1.6419e+00,-7.2486e-01,2.0346e+01),(1.3865e+00,1.8809e-01,1.3033e+01),(8.2131e-01,5.9593e+00,2.3519e+01),(7.1414e-01,-8.2375e-01,2.0450e+01),(4.5622e-01,8.0611e-02,1.3064e+01),(-1.1219e-01,6.0141e+00,2.3459e+01),(-2.1360e-01,-9.2265e-01,2.0555e+01),(-4.7410e-01,-2.6866e-02,1.3096e+01),(-1.5147e+00,6.0668e+00,2.3317e+01),(-1.2288e+00,-1.0172e+00,2.0596e+01),(-4.4068e-01,-1.3437e-01,1.3098e+01),(-2.4306e+00,6.1172e+00,2.3125e+01),(-2.1629e+00,-1.1068e+00,2.0578e+01),(-1.3668e+00,-2.4179e-01,1.3004e+01),(-3.3464e+00,6.1677e+00,2.2934e+01),(-3.0970e+00,-1.1965e+00,2.0560e+01),(-2.2930e+00,-3.4921e-01,1.2911e+01),(-4.6759e+00,6.2160e+00,2.2602e+01),(-4.1421e+00,-1.2815e+00,2.0461e+01),(-2.2626e+00,-4.5654e-01,1.2923e+01),(-5.5556e+00,6.2619e+00,2.2282e+01),(-5.0662e+00,-1.3613e+00,2.0319e+01),(-3.1679e+00,-5.6367e-01,1.2706e+01),(-6.4353e+00,6.3079e+00,2.1963e+01),(-5.9903e+00,-1.4411e+00,2.0178e+01),(-4.0732e+00,-6.7080e-01,1.2489e+01),(-7.6664e+00,6.3517e+00,2.1460e+01),(-7.0476e+00,-1.5160e+00,1.9928e+01),(-4.0498e+00,-7.7772e-01,1.2508e+01),(-8.4923e+00,6.3931e+00,2.1019e+01),(-7.9451e+00,-1.5854e+00,1.9665e+01),(-4.9180e+00,-8.8433e-01,1.2173e+01),(-9.3182e+00,6.4345e+00,2.0579e+01),(-8.8426e+00,-1.6549e+00,1.9401e+01),(-5.7862e+00,-9.9093e-01,1.1837e+01),(-1.0429e+01,6.4736e+00,1.9926e+01),(-9.8917e+00,-1.7192e+00,1.8995e+01),(-5.7731e+00,-1.0972e+00,1.1861e+01),(-1.1185e+01,6.5104e+00,1.9373e+01),(-1.0746e+01,-1.7780e+00,1.8613e+01),(-6.5885e+00,-1.2031e+00,1.1412e+01),(-1.1940e+01,6.5471e+00,1.8820e+01),(-1.1600e+01,-1.8367e+00,1.8231e+01),(-7.4040e+00,-1.3089e+00,1.0962e+01),(-1.2914e+01,6.5816e+00,1.8041e+01),(-1.2618e+01,-1.8901e+00,1.7662e+01),(-7.4036e+00,-1.4143e+00,1.0988e+01),(-1.3584e+01,6.6136e+00,1.7387e+01),(-1.3413e+01,-1.9379e+00,1.7168e+01),(-8.1516e+00,-1.5192e+00,1.0434e+01),(-1.4254e+01,6.6456e+00,1.6733e+01),(-1.4208e+01,-1.9857e+00,1.6673e+01),(-8.8996e+00,-1.6241e+00,9.8791e+00),(-1.5077e+01,6.6752e+00,1.5854e+01),(-1.5169e+01,-2.0279e+00,1.5943e+01),(-8.9134e+00,-1.7284e+00,9.9016e+00),(-1.5649e+01,6.7024e+00,1.5112e+01),(-1.5889e+01,-2.0645e+00,1.5344e+01),(-9.5805e+00,-1.8321e+00,9.2517e+00),(-1.6220e+01,6.7297e+00,1.4370e+01),(-1.6609e+01,-2.1011e+00,1.4745e+01),(-1.0248e+01,-1.9357e+00,8.6019e+00),(-1.6884e+01,6.7545e+00,1.3417e+01),(-1.7488e+01,-2.1321e+00,1.3857e+01),(-1.0276e+01,-2.0387e+00,8.6163e+00),(-1.7346e+01,6.7768e+00,1.2602e+01),(-1.8119e+01,-2.1574e+00,1.3164e+01),(-1.0850e+01,-2.1409e+00,7.8827e+00),(-1.7808e+01,6.7992e+00,1.1788e+01),(-1.8749e+01,-2.1827e+00,1.2471e+01),(-1.1424e+01,-2.2432e+00,7.1492e+00),(-1.8308e+01,6.8191e+00,1.0789e+01),(-1.9519e+01,-2.2025e+00,1.1433e+01),(-1.1465e+01,-2.3446e+00,7.1502e+00),(-1.8651e+01,6.8365e+00,9.9169e+00),(-2.0047e+01,-2.2166e+00,1.0659e+01),(-1.1935e+01,-2.4452e+00,6.3461e+00),(-1.8994e+01,6.8539e+00,9.0453e+00),(-2.0575e+01,-2.2307e+00,9.8857e+00),(-1.2406e+01,-2.5457e+00,5.5421e+00),(-1.9332e+01,6.8689e+00,8.0267e+00),(-2.1210e+01,-2.2393e+00,8.7105e+00),(-1.2458e+01,-2.6454e+00,5.5248e+00),(-1.9550e+01,6.8814e+00,7.1155e+00),(-2.1624e+01,-2.2423e+00,7.8706e+00),(-1.2816e+01,-2.7441e+00,4.6646e+00),(-1.9768e+01,6.8938e+00,6.2043e+00),(-2.2038e+01,-2.2454e+00,7.0306e+00),(-1.3174e+01,-2.8428e+00,3.8045e+00),(-1.9947e+01,6.9038e+00,5.1915e+00),(-2.2514e+01,-2.2430e+00,5.7371e+00),(-1.3232e+01,-2.9405e+00,3.7643e+00),(-2.0036e+01,6.9113e+00,4.2587e+00),(-2.2804e+01,-2.2352e+00,4.8472e+00),(-1.3472e+01,-3.0371e+00,2.8636e+00),(-2.0124e+01,6.9188e+00,3.3259e+00),(-2.3095e+01,-2.2275e+00,3.9574e+00),(-1.3712e+01,-3.1337e+00,1.9629e+00),(-2.0154e+01,6.9238e+00,2.3424e+00),(-2.3389e+01,-2.2144e+00,2.5686e+00),(-1.3771e+01,-3.2292e+00,1.8961e+00),(-2.0112e+01,6.9263e+00,1.4064e+00),(-2.3550e+01,-2.1962e+00,1.6468e+00),(-1.3887e+01,-3.3235e+00,9.7108e-01),(-2.0070e+01,6.9288e+00,4.7030e-01),(-2.3711e+01,-2.1780e+00,7.2489e-01),(-1.4003e+01,-3.4179e+00,4.6103e-02),(-1.9963e+01,6.9288e+00,-4.6280e-01),(-2.3805e+01,-2.1547e+00,-7.3147e-01),(-1.4057e+01,-3.5110e+00,-4.9853e-02),(-1.9790e+01,6.9263e+00,-1.3839e+00),(-2.3831e+01,-2.1264e+00,-1.6664e+00),(-1.4048e+01,-3.6028e+00,-9.8233e-01),(-1.9618e+01,6.9238e+00,-2.3050e+00),(-2.3858e+01,-2.0982e+00,-2.6014e+00),(-1.4039e+01,-3.6946e+00,-1.9148e+00),(-1.9389e+01,6.9188e+00,-3.1695e+00),(-2.3738e+01,-2.0652e+00,-4.0940e+00),(-1.4079e+01,-3.7851e+00,-2.0410e+00),(-1.9090e+01,6.9113e+00,-4.0578e+00),(-2.3629e+01,-2.0275e+00,-5.0225e+00),(-1.3945e+01,-3.8742e+00,-2.9640e+00),(-1.8792e+01,6.9038e+00,-4.9460e+00),(-2.3520e+01,-1.9898e+00,-5.9510e+00),(-1.3810e+01,-3.9633e+00,-3.8870e+00),(-1.8457e+01,6.8938e+00,-5.7271e+00),(-2.3178e+01,-1.9476e+00,-7.4456e+00),(-1.3830e+01,-4.0510e+00,-4.0430e+00),(-1.8038e+01,6.8814e+00,-6.5653e+00),(-2.2935e+01,-1.9011e+00,-8.3478e+00),(-1.3572e+01,-4.1372e+00,-4.9397e+00),(-1.7619e+01,6.8689e+00,-7.4035e+00),(-2.2692e+01,-1.8546e+00,-9.2499e+00),(-1.3314e+01,-4.2235e+00,-5.8364e+00),(-1.7198e+01,6.8539e+00,-8.0898e+00),(-2.2126e+01,-1.8040e+00,-1.0710e+01),(-1.3304e+01,-4.3082e+00,-6.0198e+00),(-1.6667e+01,6.8365e+00,-8.8619e+00),(-2.1754e+01,-1.7494e+00,-1.1567e+01),(-1.2927e+01,-4.3913e+00,-6.8736e+00),(-1.6136e+01,6.8191e+00,-9.6340e+00),(-2.1382e+01,-1.6948e+00,-1.2423e+01),(-1.2551e+01,-4.4744e+00,-7.7275e+00),(-1.5647e+01,6.7992e+00,-1.0218e+01),(-2.0595e+01,-1.6364e+00,-1.3813e+01),(-1.2504e+01,-4.5560e+00,-7.9341e+00),(-1.5015e+01,6.7768e+00,-1.0909e+01),(-2.0101e+01,-1.5746e+00,-1.4604e+01),(-1.2015e+01,-4.6359e+00,-8.7294e+00),(-1.4383e+01,6.7545e+00,-1.1600e+01),(-1.9607e+01,-1.5127e+00,-1.5396e+01),(-1.1526e+01,-4.7157e+00,-9.5247e+00),(-1.3846e+01,6.7297e+00,-1.2077e+01),(-1.8611e+01,-1.4474e+00,-1.6678e+01),(-1.1435e+01,-4.7940e+00,-9.7482e+00),(-1.3125e+01,6.7024e+00,-1.2675e+01),(-1.8005e+01,-1.3792e+00,-1.7387e+01),(-1.0842e+01,-4.8704e+00,-1.0470e+01),(-1.2404e+01,6.6752e+00,-1.3272e+01),(-1.7399e+01,-1.3109e+00,-1.8096e+01),(-1.0250e+01,-4.9468e+00,-1.1192e+01),(-1.1839e+01,6.6456e+00,-1.3641e+01),(-1.6211e+01,-1.2396e+00,-1.9237e+01),(-1.0107e+01,-5.0215e+00,-1.1425e+01),(-1.1042e+01,6.6136e+00,-1.4134e+01),(-1.5507e+01,-1.1659e+00,-1.9848e+01),(-9.4224e+00,-5.0944e+00,-1.2060e+01),(-1.0246e+01,6.5816e+00,-1.4626e+01),(-1.4803e+01,-1.0921e+00,-2.0459e+01),(-8.7376e+00,-5.1672e+00,-1.2696e+01),(-9.6718e+00,6.5471e+00,-1.4890e+01),(-1.3445e+01,-1.0158e+00,-2.1427e+01),(-8.5383e+00,-5.2382e+00,-1.2927e+01),(-8.8152e+00,6.5104e+00,-1.5268e+01),(-1.2659e+01,-9.3756e-01,-2.1925e+01),(-7.7733e+00,-5.3073e+00,-1.3464e+01),(-7.9586e+00,6.4736e+00,-1.5646e+01),(-1.1872e+01,-8.5927e-01,-2.2424e+01),(-7.0084e+00,-5.3764e+00,-1.4001e+01),(-7.3922e+00,6.4345e+00,-1.5811e+01),(-1.0374e+01,-7.7899e-01,-2.3192e+01),(-6.7492e+00,-5.4436e+00,-1.4220e+01),(-6.4920e+00,6.3931e+00,-1.6068e+01),(-9.5216e+00,-6.9721e-01,-2.3567e+01),(-5.9182e+00,-5.5088e+00,-1.4648e+01),(-5.5917e+00,6.3517e+00,-1.6325e+01),(-8.6692e+00,-6.1544e-01,-2.3942e+01),(-5.0871e+00,-5.5739e+00,-1.5076e+01),(-5.0480e+00,6.3079e+00,-1.6399e+01),(-7.0648e+00,-5.3218e-01,-2.4488e+01),(-4.7669e+00,-5.6371e+00,-1.5271e+01),(-4.1213e+00,6.2619e+00,-1.6530e+01),(-6.1661e+00,-4.4797e-01,-2.4731e+01),(-3.8851e+00,-5.6983e+00,-1.5582e+01),(-3.1946e+00,6.2160e+00,-1.6660e+01),(-5.2673e+00,-3.6375e-01,-2.4974e+01),(-3.0033e+00,-5.7594e+00,-1.5893e+01),(-2.6862e+00,6.1677e+00,-1.6653e+01),(-3.5932e+00,-2.7859e-01,-2.5282e+01),(-2.6230e+00,-5.8185e+00,-1.6051e+01),(-1.7506e+00,6.1172e+00,-1.6656e+01),(-2.6683e+00,-1.9301e-01,-2.5387e+01),(-1.7068e+00,-5.8754e+00,-1.6239e+01),(-8.1492e-01,6.0668e+00,-1.6659e+01),(-1.7434e+00,-1.0743e-01,-2.5492e+01),(-7.9059e-01,-5.9324e+00,-1.6427e+01),(-3.5238e-01,6.0141e+00,-1.6581e+01),(-3.9028e-02,-2.1445e-02,-2.5554e+01),(-3.5401e-01,-5.9872e+00,-1.6535e+01),(5.7467e-01,5.9593e+00,-1.6456e+01),(8.9116e-01,6.4405e-02,-2.5519e+01),(5.7954e-01,-6.0399e+00,-1.6596e+01),(1.5017e+00,5.9045e+00,-1.6331e+01),(1.8213e+00,1.5025e-01,-2.5484e+01),(1.5131e+00,-6.0926e+00,-1.6657e+01),(1.9108e+00,5.8475e+00,-1.6197e+01),(3.5156e+00,2.3597e-01,-2.5298e+01),(1.9996e+00,-6.1430e+00,-1.6701e+01),(2.8119e+00,5.7884e+00,-1.5947e+01),(4.4300e+00,3.2100e-01,-2.5124e+01),(2.9330e+00,-6.1913e+00,-1.6634e+01),(3.7130e+00,5.7294e+00,-1.5697e+01),(5.3444e+00,4.0603e-01,-2.4949e+01),(3.8664e+00,-6.2395e+00,-1.6567e+01),(4.0635e+00,5.6682e+00,-1.5518e+01),(6.9885e+00,4.9038e-01,-2.4521e+01),(4.3939e+00,-6.2855e+00,-1.6535e+01),(4.9219e+00,5.6050e+00,-1.5148e+01),(7.8665e+00,5.7351e-01,-2.4211e+01),(5.3095e+00,-6.3292e+00,-1.6341e+01),(5.7803e+00,5.5419e+00,-1.4778e+01),(8.7446e+00,6.5663e-01,-2.3901e+01),(6.2252e+00,-6.3729e+00,-1.6147e+01),(6.0700e+00,5.4767e+00,-1.4569e+01),(1.0300e+01,7.3854e-01,-2.3242e+01),(6.7820e+00,-6.4144e+00,-1.6029e+01),(6.8699e+00,5.4095e+00,-1.4085e+01),(1.1122e+01,8.1870e-01,-2.2803e+01),(7.6625e+00,-6.4535e+00,-1.5711e+01),(7.6697e+00,5.3423e+00,-1.3602e+01),(1.1944e+01,8.9885e-01,-2.2365e+01),(8.5431e+00,-6.4926e+00,-1.5392e+01),(7.8986e+00,5.2732e+00,-1.3375e+01),(1.3375e+01,9.7726e-01,-2.1494e+01),(9.1152e+00,-6.5294e+00,-1.5178e+01),(8.6252e+00,5.2022e+00,-1.2787e+01),(1.4123e+01,1.0534e+00,-2.0938e+01),(9.9439e+00,-6.5638e+00,-1.4742e+01),(9.3518e+00,5.1313e+00,-1.2200e+01),(1.4870e+01,1.1296e+00,-2.0382e+01),(1.0773e+01,-6.5982e+00,-1.4306e+01),(9.5222e+00,5.0584e+00,-1.1967e+01),(1.6147e+01,1.2034e+00,-1.9324e+01),(1.1344e+01,-6.6302e+00,-1.3990e+01),(1.0162e+01,4.9837e+00,-1.1286e+01),(1.6803e+01,1.2746e+00,-1.8662e+01),(1.2105e+01,-6.6598e+00,-1.3444e+01),(1.0802e+01,4.9091e+00,-1.0606e+01),(1.7460e+01,1.3457e+00,-1.8000e+01),(1.2866e+01,-6.6894e+00,-1.2898e+01),(1.0919e+01,4.8326e+00,-1.0377e+01),(1.8555e+01,1.4141e+00,-1.6784e+01),(1.3418e+01,-6.7167e+00,-1.2475e+01),(1.1460e+01,4.7544e+00,-9.6165e+00),(1.9106e+01,1.4793e+00,-1.6032e+01),(1.4097e+01,-6.7415e+00,-1.1829e+01),(1.2002e+01,4.6762e+00,-8.8560e+00),(1.9657e+01,1.5445e+00,-1.5279e+01),(1.4775e+01,-6.7662e+00,-1.1183e+01),(1.2070e+01,4.5963e+00,-8.6401e+00),(2.0550e+01,1.6064e+00,-1.3939e+01),(1.5291e+01,-6.7886e+00,-1.0652e+01),(1.2504e+01,4.5148e+00,-7.8136e+00),(2.0985e+01,1.6647e+00,-1.3113e+01),(1.5873e+01,-6.8085e+00,-9.9188e+00),(1.2938e+01,4.4333e+00,-6.9871e+00),(2.1419e+01,1.7230e+00,-1.2287e+01),(1.6456e+01,-6.8284e+00,-9.1854e+00),(1.2965e+01,4.3501e+00,-6.7914e+00),(2.2096e+01,1.7777e+00,-1.0857e+01),(1.6914e+01,-6.8458e+00,-8.5496e+00),(1.3283e+01,4.2654e+00,-5.9142e+00),(2.2405e+01,1.8283e+00,-9.9753e+00),(1.7390e+01,-6.8608e+00,-7.7425e+00),(1.3602e+01,4.1807e+00,-5.0369e+00),(2.2713e+01,1.8789e+00,-9.0937e+00),(1.7866e+01,-6.8757e+00,-6.9355e+00),(1.3595e+01,4.0945e+00,-4.8668e+00),(2.3167e+01,1.9254e+00,-7.6115e+00),(1.8247e+01,-6.8882e+00,-6.2005e+00),(1.3792e+01,4.0068e+00,-3.9548e+00),(2.3344e+01,1.9676e+00,-6.6937e+00),(1.8606e+01,-6.8982e+00,-5.3352e+00),(1.3989e+01,3.9191e+00,-3.0429e+00),(2.3520e+01,2.0098e+00,-5.7759e+00),(1.8966e+01,-6.9082e+00,-4.4700e+00),(1.3958e+01,3.8300e+00,-2.9016e+00),(2.3750e+01,2.0475e+00,-4.2779e+00),(1.9250e+01,-6.9157e+00,-3.6454e+00),(1.4030e+01,3.7395e+00,-1.9718e+00),(2.3791e+01,2.0805e+00,-3.3437e+00),(1.9486e+01,-6.9207e+00,-2.7386e+00),(1.4102e+01,3.6490e+00,-1.0419e+00),(2.3833e+01,2.1135e+00,-2.4095e+00),(1.9722e+01,-6.9257e+00,-1.8318e+00),(1.4054e+01,3.5572e+00,-9.3084e-01),(2.3844e+01,2.1418e+00,-9.3084e-01),(1.9893e+01,-6.9282e+00,-9.3084e-01),(1.4000e+01,3.4641e+00,-3.4290e-15),(2.3750e+01,2.1651e+00,-5.8171e-15),(2.0000e+01,-6.9282e+00,-4.8986e-15)])),
      appearance=Appearance(
        material=Material(diffuseColor=(0,0,1)))),
    Shape(
      geometry=NurbsPatchSurface(solid=False,uDimension=3,uKnot=[0,0,0,1,1,1],vDimension=136,vKnot=[0,0,0,0,0.0222222222222,0.0222222222222,0.0222222222222,0.0444444444444,0.0444444444444,0.0444444444444,0.0666666666667,0.0666666666667,0.0666666666667,0.0888888888889,0.0888888888889,0.0888888888889,0.111111111111,0.111111111111,0.111111111111,0.133333333333,0.133333333333,0.133333333333,0.155555555556,0.155555555556,0.155555555556,0.177777777778,0.177777777778,0.177777777778,0.2,0.2,0.2,0.222222222222,0.222222222222,0.222222222222,0.244444444444,0.244444444444,0.244444444444,0.266666666667,0.266666666667,0.266666666667,0.288888888889,0.288888888889,0.288888888889,0.311111111111,0.311111111111,0.311111111111,0.333333333333,0.333333333333,0.333333333333,0.355555555556,0.355555555556,0.355555555556,0.377777777778,0.377777777778,0.377777777778,0.4,0.4,0.4,0.422222222222,0.422222222222,0.422222222222,0.444444444444,0.444444444444,0.444444444444,0.466666666667,0.466666666667,0.466666666667,0.488888888889,0.488888888889,0.488888888889,0.511111111111,0.511111111111,0.511111111111,0.533333333333,0.533333333333,0.533333333333,0.555555555556,0.555555555556,0.555555555556,0.577777777778,0.577777777778,0.577777777778,0.6,0.6,0.6,0.622222222222,0.622222222222,0.622222222222,0.644444444444,0.644444444444,0.644444444444,0.666666666667,0.666666666667,0.666666666667,0.688888888889,0.688888888889,0.688888888889,0.711111111111,0.711111111111,0.711111111111,0.733333333333,0.733333333333,0.733333333333,0.755555555556,0.755555555556,0.755555555556,0.777777777778,0.777777777778,0.777777777778,0.8,0.8,0.8,0.822222222222,0.822222222222,0.822222222222,0.844444444444,0.844444444444,0.844444444444,0.866666666667,0.866666666667,0.866666666667,0.888888888889,0.888888888889,0.888888888889,0.911111111111,0.911111111111,0.911111111111,0.933333333333,0.933333333333,0.933333333333,0.955555555556,0.955555555556,0.955555555556,0.977777777778,0.977777777778,0.977777777778,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        controlPoint=Coordinate(point=[(1.4000e+01,3.4641e+00,0.0000e+00),(2.3750e+01,2.1651e+00,0.0000e+00),(2.0000e+01,-6.9282e+00,0.0000e+00),(1.3946e+01,3.3710e+00,9.3084e-01),(2.3656e+01,2.1883e+00,9.3084e-01),(2.0107e+01,-6.9282e+00,9.3084e-01),(1.3889e+01,3.2767e+00,1.0120e+00),(2.3460e+01,2.2066e+00,2.3571e+00),(2.0148e+01,-6.9257e+00,1.8916e+00),(1.3711e+01,3.1812e+00,1.9269e+00),(2.3234e+01,2.2196e+00,3.2653e+00),(2.0125e+01,-6.9207e+00,2.8283e+00),(1.3532e+01,3.0857e+00,2.8418e+00),(2.3007e+01,2.2327e+00,4.1734e+00),(2.0101e+01,-6.9157e+00,3.7650e+00),(1.3473e+01,2.9891e+00,2.8949e+00),(2.2620e+01,2.2404e+00,5.5178e+00),(1.9998e+01,-6.9082e+00,4.7660e+00),(1.3173e+01,2.8914e+00,3.7773e+00),(2.2266e+01,2.2428e+00,6.3848e+00),(1.9844e+01,-6.8982e+00,5.6903e+00),(1.2873e+01,2.7937e+00,4.6597e+00),(2.1913e+01,2.2452e+00,7.2518e+00),(1.9691e+01,-6.8882e+00,6.6145e+00),(1.2818e+01,2.6950e+00,4.6880e+00),(2.1355e+01,2.2422e+00,8.4888e+00),(1.9433e+01,-6.8757e+00,7.6333e+00),(1.2403e+01,2.5954e+00,5.5220e+00),(2.0883e+01,2.2336e+00,9.2976e+00),(1.9152e+01,-6.8608e+00,8.5269e+00),(1.1987e+01,2.4957e+00,6.3560e+00),(2.0411e+01,2.2251e+00,1.0106e+01),(1.8870e+01,-6.8458e+00,9.4206e+00),(1.1940e+01,2.3951e+00,6.3635e+00),(1.9705e+01,2.2109e+00,1.1215e+01),(1.8452e+01,-6.8284e+00,1.0433e+01),(1.1417e+01,2.2937e+00,7.1340e+00),(1.9124e+01,2.1912e+00,1.1950e+01),(1.8048e+01,-6.8085e+00,1.1278e+01),(1.0893e+01,2.1923e+00,7.9046e+00),(1.8543e+01,2.1715e+00,1.2685e+01),(1.7645e+01,-6.7886e+00,1.2123e+01),(1.0858e+01,2.0900e+00,7.8962e+00),(1.7715e+01,2.1461e+00,1.3650e+01),(1.7063e+01,-6.7662e+00,1.3102e+01),(1.0237e+01,1.9870e+00,8.5895e+00),(1.7038e+01,2.1152e+00,1.4297e+01),(1.6545e+01,-6.7415e+00,1.3883e+01),(9.6146e+00,1.8841e+00,9.2827e+00),(1.6361e+01,2.0842e+00,1.4944e+01),(1.6027e+01,-6.7167e+00,1.4663e+01),(9.5936e+00,1.7804e+00,9.2636e+00),(1.5438e+01,2.0476e+00,1.5754e+01),(1.5283e+01,-6.6894e+00,1.5582e+01),(8.8844e+00,1.6761e+00,9.8672e+00),(1.4678e+01,2.0054e+00,1.6302e+01),(1.4660e+01,-6.6598e+00,1.6282e+01),(8.1753e+00,1.5718e+00,1.0471e+01),(1.3919e+01,1.9632e+00,1.6850e+01),(1.4038e+01,-6.6302e+00,1.6982e+01),(8.1687e+00,1.4669e+00,1.0446e+01),(1.2926e+01,1.9154e+00,1.7499e+01),(1.3139e+01,-6.5982e+00,1.7814e+01),(7.3852e+00,1.3615e+00,1.0949e+01),(1.2100e+01,1.8621e+00,1.7939e+01),(1.2424e+01,-6.5638e+00,1.8419e+01),(6.6017e+00,1.2561e+00,1.1452e+01),(1.1273e+01,1.8088e+00,1.8378e+01),(1.1709e+01,-6.5294e+00,1.9024e+01),(6.6087e+00,1.1502e+00,1.1426e+01),(1.0237e+01,1.7499e+00,1.8865e+01),(1.0665e+01,-6.4926e+00,1.9743e+01),(5.7650e+00,1.0440e+00,1.1820e+01),(9.3587e+00,1.6857e+00,1.9188e+01),(9.8723e+00,-6.4535e+00,2.0241e+01),(4.9212e+00,9.3772e-01,1.2213e+01),(8.4808e+00,1.6216e+00,1.9512e+01),(9.0796e+00,-6.4144e+00,2.0739e+01),(4.9399e+00,8.3109e-01,1.2191e+01),(7.4249e+00,1.5519e+00,1.9839e+01),(7.9061e+00,-6.3729e+00,2.1320e+01),(4.0511e+00,7.2419e-01,1.2468e+01),(6.5120e+00,1.4772e+00,2.0042e+01),(7.0511e+00,-6.3292e+00,2.1701e+01),(3.1624e+00,6.1730e-01,1.2745e+01),(5.5991e+00,1.4025e+00,2.0245e+01),(6.1962e+00,-6.2855e+00,2.2082e+01),(3.1897e+00,5.1014e-01,1.2729e+01),(4.5455e+00,1.3226e+00,2.0418e+01),(4.9129e+00,-6.2395e+00,2.2502e+01),(2.2719e+00,4.0284e-01,1.2885e+01),(3.6143e+00,1.2378e+00,2.0498e+01),(4.0129e+00,-6.1913e+00,2.2758e+01),(1.3541e+00,2.9554e-01,1.3040e+01),(2.6832e+00,1.1530e+00,2.0577e+01),(3.1129e+00,-6.1430e+00,2.3015e+01),(1.3865e+00,1.8809e-01,1.3033e+01),(1.6510e+00,1.0631e+00,2.0606e+01),(1.7434e+00,-6.0926e+00,2.3254e+01),(4.5622e-01,8.0611e-02,1.3064e+01),(7.1804e-01,9.6877e-01,2.0562e+01),(8.1644e-01,-6.0399e+00,2.3380e+01),(-4.7410e-01,-2.6866e-02,1.3096e+01),(-2.1490e-01,8.7442e-01,2.0518e+01),(-1.1056e-01,-5.9872e+00,2.3506e+01),(-4.4068e-01,-1.3437e-01,1.3098e+01),(-1.2093e+00,7.7532e-01,2.0411e+01),(-1.5391e+00,-5.9324e+00,2.3548e+01),(-1.3668e+00,-2.4179e-01,1.3004e+01),(-2.1279e+00,6.7205e-01,2.0246e+01),(-2.4743e+00,-5.8754e+00,2.3542e+01),(-2.2930e+00,-3.4921e-01,1.2911e+01),(-3.0465e+00,5.6878e-01,2.0081e+01),(-3.4096e+00,-5.8185e+00,2.3535e+01),(-2.2626e+00,-4.5654e-01,1.2923e+01),(-3.9897e+00,4.6110e-01,1.9849e+01),(-4.8672e+00,-5.7594e+00,2.3369e+01),(-3.1679e+00,-5.6367e-01,1.2706e+01),(-4.8785e+00,3.4965e-01,1.9567e+01),(-5.7918e+00,-5.6983e+00,2.3230e+01),(-4.0732e+00,-6.7080e-01,1.2489e+01),(-5.7673e+00,2.3820e-01,1.9284e+01),(-6.7164e+00,-5.6371e+00,2.3090e+01),(-4.0498e+00,-7.7772e-01,1.2508e+01),(-6.6483e+00,1.2272e-01,1.8940e+01),(-8.1710e+00,-5.5739e+00,2.2709e+01),(-4.9180e+00,-8.8433e-01,1.2173e+01),(-7.4927e+00,3.8957e-03,1.8545e+01),(-9.0661e+00,-5.5088e+00,2.2439e+01),(-5.7862e+00,-9.9093e-01,1.1837e+01),(-8.3372e+00,-1.1493e-01,1.8150e+01),(-9.9612e+00,-5.4436e+00,2.2170e+01),(-5.7731e+00,-1.0972e+00,1.1861e+01),(-9.1475e+00,-2.3735e-01,1.7706e+01),(-1.1379e+01,-5.3764e+00,2.1571e+01),(-6.5885e+00,-1.2031e+00,1.1412e+01),(-9.9340e+00,-3.6265e-01,1.7206e+01),(-1.2227e+01,-5.3073e+00,2.1177e+01),(-7.4040e+00,-1.3089e+00,1.0962e+01),(-1.0721e+01,-4.8794e-01,1.6707e+01),(-1.3074e+01,-5.2382e+00,2.0783e+01),(-7.4036e+00,-1.4143e+00,1.0988e+01),(-1.1453e+01,-6.1638e-01,1.6172e+01),(-1.4422e+01,-5.1672e+00,1.9971e+01),(-8.1516e+00,-1.5192e+00,1.0434e+01),(-1.2170e+01,-7.4718e-01,1.5576e+01),(-1.5204e+01,-5.0944e+00,1.9460e+01),(-8.8996e+00,-1.6241e+00,9.8791e+00),(-1.2886e+01,-8.7799e-01,1.4981e+01),(-1.5986e+01,-5.0215e+00,1.8949e+01),(-8.9134e+00,-1.7284e+00,9.9016e+00),(-1.3536e+01,-1.0114e+00,1.4366e+01),(-1.7230e+01,-4.9468e+00,1.7933e+01),(-9.5805e+00,-1.8321e+00,9.2517e+00),(-1.4171e+01,-1.1467e+00,1.3685e+01),(-1.7931e+01,-4.8704e+00,1.7316e+01),(-1.0248e+01,-1.9357e+00,8.6019e+00),(-1.4806e+01,-1.2820e+00,1.3004e+01),(-1.8632e+01,-4.7940e+00,1.6699e+01),(-1.0276e+01,-2.0387e+00,8.6163e+00),(-1.5369e+01,-1.4194e+00,1.2317e+01),(-1.9740e+01,-4.7157e+00,1.5493e+01),(-1.0850e+01,-2.1409e+00,7.8827e+00),(-1.5912e+01,-1.5581e+00,1.1561e+01),(-2.0346e+01,-4.6359e+00,1.4782e+01),(-1.1424e+01,-2.2432e+00,7.1492e+00),(-1.6456e+01,-1.6968e+00,1.0805e+01),(-2.0951e+01,-4.5560e+00,1.4071e+01),(-1.1465e+01,-2.3446e+00,7.1502e+00),(-1.6928e+01,-1.8370e+00,1.0055e+01),(-2.1893e+01,-4.4744e+00,1.2695e+01),(-1.1935e+01,-2.4452e+00,6.3461e+00),(-1.7372e+01,-1.9780e+00,9.2368e+00),(-2.2390e+01,-4.3913e+00,1.1905e+01),(-1.2406e+01,-2.5457e+00,5.5421e+00),(-1.7816e+01,-2.1189e+00,8.4188e+00),(-2.2888e+01,-4.3082e+00,1.1115e+01),(-1.2458e+01,-2.6454e+00,5.5248e+00),(-1.8192e+01,-2.2609e+00,7.6118e+00),(-2.3637e+01,-4.2235e+00,9.5939e+00),(-1.2816e+01,-2.7441e+00,4.6646e+00),(-1.8530e+01,-2.4029e+00,6.7443e+00),(-2.4016e+01,-4.1372e+00,8.7411e+00),(-1.3174e+01,-2.8428e+00,3.8045e+00),(-1.8868e+01,-2.5450e+00,5.8769e+00),(-2.4395e+01,-4.0510e+00,7.8883e+00),(-1.3232e+01,-2.9405e+00,3.7643e+00),(-1.9142e+01,-2.6874e+00,5.0205e+00),(-2.4929e+01,-3.9633e+00,6.2504e+00),(-1.3472e+01,-3.0371e+00,2.8636e+00),(-1.9369e+01,-2.8294e+00,4.1171e+00),(-2.5181e+01,-3.8742e+00,5.3524e+00),(-1.3712e+01,-3.1337e+00,1.9629e+00),(-1.9596e+01,-2.9714e+00,3.2137e+00),(-2.5434e+01,-3.7851e+00,4.4544e+00),(-1.3771e+01,-3.2292e+00,1.8961e+00),(-1.9764e+01,-3.1131e+00,2.3151e+00),(-2.5734e+01,-3.6946e+00,2.7326e+00),(-1.3887e+01,-3.3235e+00,9.7108e-01),(-1.9876e+01,-3.2538e+00,1.3898e+00),(-2.5855e+01,-3.6028e+00,1.8079e+00),(-1.4003e+01,-3.4179e+00,4.6103e-02),(-1.9988e+01,-3.3945e+00,4.6457e-01),(-2.5975e+01,-3.5110e+00,8.8326e-01),(-1.4057e+01,-3.5110e+00,-4.9853e-02),(-2.0041e+01,-3.5344e+00,-4.6832e-01),(-2.6029e+01,-3.4179e+00,-8.8701e-01),(-1.4048e+01,-3.6028e+00,-9.8233e-01),(-2.0037e+01,-3.6725e+00,-1.4011e+00),(-2.6015e+01,-3.3235e+00,-1.8192e+00),(-1.4039e+01,-3.6946e+00,-1.9148e+00),(-2.0032e+01,-3.8107e+00,-2.3339e+00),(-2.6002e+01,-3.2292e+00,-2.7513e+00),(-1.4079e+01,-3.7851e+00,-2.0410e+00),(-1.9964e+01,-3.9475e+00,-3.2919e+00),(-2.5801e+01,-3.1337e+00,-4.5326e+00),(-1.3945e+01,-3.8742e+00,-2.9640e+00),(-1.9842e+01,-4.0819e+00,-4.2176e+00),(-2.5654e+01,-3.0371e+00,-5.4529e+00),(-1.3810e+01,-3.9633e+00,-3.8870e+00),(-1.9720e+01,-4.2164e+00,-5.1433e+00),(-2.5506e+01,-2.9405e+00,-6.3732e+00),(-1.3830e+01,-4.0510e+00,-4.0430e+00),(-1.9524e+01,-4.3489e+00,-6.1155e+00),(-2.5050e+01,-2.8428e+00,-8.1269e+00),(-1.3572e+01,-4.1372e+00,-4.9397e+00),(-1.9286e+01,-4.4785e+00,-7.0194e+00),(-2.4772e+01,-2.7441e+00,-9.0162e+00),(-1.3314e+01,-4.2235e+00,-5.8364e+00),(-1.9048e+01,-4.6080e+00,-7.9234e+00),(-2.4493e+01,-2.6454e+00,-9.9055e+00),(-1.3304e+01,-4.3082e+00,-6.0198e+00),(-1.8715e+01,-4.7350e+00,-8.8966e+00),(-2.3786e+01,-2.5457e+00,-1.1593e+01),(-1.2927e+01,-4.3913e+00,-6.8736e+00),(-1.8364e+01,-4.8585e+00,-9.7643e+00),(-2.3383e+01,-2.4452e+00,-1.2433e+01),(-1.2551e+01,-4.4744e+00,-7.7275e+00),(-1.8013e+01,-4.9820e+00,-1.0632e+01),(-2.2979e+01,-2.3446e+00,-1.3272e+01),(-1.2504e+01,-4.5560e+00,-7.9341e+00),(-1.7536e+01,-5.1024e+00,-1.1590e+01),(-2.2031e+01,-2.2432e+00,-1.4856e+01),(-1.2015e+01,-4.6359e+00,-8.7294e+00),(-1.7078e+01,-5.2187e+00,-1.2408e+01),(-2.1511e+01,-2.1409e+00,-1.5629e+01),(-1.1526e+01,-4.7157e+00,-9.5247e+00),(-1.6619e+01,-5.3351e+00,-1.3225e+01),(-2.0991e+01,-2.0387e+00,-1.6401e+01),(-1.1435e+01,-4.7940e+00,-9.7482e+00),(-1.5993e+01,-5.4477e+00,-1.4150e+01),(-1.9819e+01,-1.9357e+00,-1.7845e+01),(-1.0842e+01,-4.8704e+00,-1.0470e+01),(-1.5433e+01,-5.5557e+00,-1.4903e+01),(-1.9193e+01,-1.8321e+00,-1.8535e+01),(-1.0250e+01,-4.9468e+00,-1.1192e+01),(-1.4873e+01,-5.6638e+00,-1.5656e+01),(-1.8567e+01,-1.7284e+00,-1.9224e+01),(-1.0107e+01,-5.0215e+00,-1.1425e+01),(-1.4094e+01,-5.7676e+00,-1.6527e+01),(-1.7194e+01,-1.6241e+00,-2.0495e+01),(-9.4224e+00,-5.0944e+00,-1.2060e+01),(-1.3440e+01,-5.8664e+00,-1.7203e+01),(-1.6475e+01,-1.5192e+00,-2.1087e+01),(-8.7376e+00,-5.1672e+00,-1.2696e+01),(-1.2787e+01,-5.9652e+00,-1.7879e+01),(-1.5756e+01,-1.4143e+00,-2.1678e+01),(-8.5383e+00,-5.2382e+00,-1.2927e+01),(-1.1855e+01,-6.0592e+00,-1.8671e+01),(-1.4208e+01,-1.3089e+00,-2.2748e+01),(-7.7733e+00,-5.3073e+00,-1.3464e+01),(-1.1119e+01,-6.1477e+00,-1.9258e+01),(-1.3411e+01,-1.2031e+00,-2.3229e+01),(-7.0084e+00,-5.3764e+00,-1.4001e+01),(-1.0383e+01,-6.2363e+00,-1.9845e+01),(-1.2615e+01,-1.0972e+00,-2.3711e+01),(-6.7492e+00,-5.4436e+00,-1.4220e+01),(-9.3002e+00,-6.3196e+00,-2.0534e+01),(-1.0924e+01,-9.9093e-01,-2.4553e+01),(-5.9182e+00,-5.5088e+00,-1.4648e+01),(-8.4929e+00,-6.3970e+00,-2.1021e+01),(-1.0066e+01,-8.8433e-01,-2.4915e+01),(-5.0871e+00,-5.5739e+00,-1.5076e+01),(-7.6856e+00,-6.4744e+00,-2.1507e+01),(-9.2083e+00,-7.7772e-01,-2.5276e+01),(-4.7669e+00,-5.6371e+00,-1.5271e+01),(-6.4610e+00,-6.5461e+00,-2.2066e+01),(-7.4100e+00,-6.7080e-01,-2.5872e+01),(-3.8851e+00,-5.6983e+00,-1.5582e+01),(-5.5957e+00,-6.6116e+00,-2.2443e+01),(-6.5090e+00,-5.6367e-01,-2.6106e+01),(-3.0033e+00,-5.7594e+00,-1.5893e+01),(-4.7303e+00,-6.6771e+00,-2.2820e+01),(-5.6079e+00,-4.5654e-01,-2.6340e+01),(-2.6230e+00,-5.8185e+00,-1.6051e+01),(-3.3766e+00,-6.7365e+00,-2.3221e+01),(-3.7397e+00,-3.4921e-01,-2.6675e+01),(-1.7068e+00,-5.8754e+00,-1.6239e+01),(-2.4679e+00,-6.7893e+00,-2.3481e+01),(-2.8143e+00,-2.4179e-01,-2.6776e+01),(-7.9059e-01,-5.9324e+00,-1.6427e+01),(-1.5592e+00,-6.8421e+00,-2.3740e+01),(-1.8890e+00,-1.3437e-01,-2.6878e+01),(-3.5401e-01,-5.9872e+00,-1.6535e+01),(-9.4802e-02,-6.8885e+00,-2.3957e+01),(9.5328e-03,-2.6866e-02,-2.6945e+01),(5.7954e-01,-6.0399e+00,-1.6596e+01),(8.4136e-01,-6.9281e+00,-2.4093e+01),(9.3976e-01,8.0611e-02,-2.6911e+01),(1.5131e+00,-6.0926e+00,-1.6657e+01),(1.7775e+00,-6.9676e+00,-2.4230e+01),(1.8700e+00,1.8809e-01,-2.6878e+01),(1.9996e+00,-6.1430e+00,-1.6701e+01),(3.3287e+00,-7.0005e+00,-2.4238e+01),(3.7584e+00,2.9554e-01,-2.6675e+01),(2.9330e+00,-6.1913e+00,-1.6634e+01),(4.2754e+00,-7.0262e+00,-2.4247e+01),(4.6740e+00,4.0284e-01,-2.6508e+01),(3.8664e+00,-6.2395e+00,-1.6567e+01),(5.2222e+00,-7.0519e+00,-2.4256e+01),(5.5896e+00,5.1014e-01,-2.6340e+01),(4.3939e+00,-6.2855e+00,-1.6535e+01),(6.8307e+00,-7.0707e+00,-2.4035e+01),(7.4277e+00,6.1730e-01,-2.5872e+01),(5.3095e+00,-6.3292e+00,-1.6341e+01),(7.7704e+00,-7.0823e+00,-2.3915e+01),(8.3095e+00,7.2419e-01,-2.5574e+01),(6.2252e+00,-6.3729e+00,-1.6147e+01),(8.7102e+00,-7.0938e+00,-2.3795e+01),(9.1914e+00,8.3109e-01,-2.5276e+01),(6.7820e+00,-6.4144e+00,-1.6029e+01),(1.0342e+01,-7.0982e+00,-2.3327e+01),(1.0940e+01,9.3772e-01,-2.4554e+01),(7.6625e+00,-6.4535e+00,-1.5711e+01),(1.1256e+01,-7.0952e+00,-2.3079e+01),(1.1770e+01,1.0440e+00,-2.4132e+01),(8.5431e+00,-6.4926e+00,-1.5392e+01),(1.2171e+01,-7.0922e+00,-2.2831e+01),(1.2599e+01,1.1502e+00,-2.3709e+01),(9.1152e+00,-6.5294e+00,-1.5178e+01),(1.3787e+01,-7.0820e+00,-2.2104e+01),(1.4223e+01,1.2561e+00,-2.2751e+01),(9.9439e+00,-6.5638e+00,-1.4742e+01),(1.4658e+01,-7.0643e+00,-2.1732e+01),(1.4983e+01,1.3615e+00,-2.2212e+01),(1.0773e+01,-6.5982e+00,-1.4306e+01),(1.5530e+01,-7.0466e+00,-2.1360e+01),(1.5742e+01,1.4669e+00,-2.1674e+01),(1.1344e+01,-6.6302e+00,-1.3990e+01),(1.7088e+01,-7.0216e+00,-2.0369e+01),(1.7206e+01,1.5718e+00,-2.0501e+01),(1.2105e+01,-6.6598e+00,-1.3444e+01),(1.7899e+01,-6.9891e+00,-1.9879e+01),(1.7881e+01,1.6761e+00,-1.9859e+01),(1.2866e+01,-6.6894e+00,-1.2898e+01),(1.8710e+01,-6.9566e+00,-1.9388e+01),(1.8555e+01,1.7804e+00,-1.9216e+01),(1.3418e+01,-6.7167e+00,-1.2475e+01),(2.0165e+01,-6.9168e+00,-1.8136e+01),(1.9831e+01,1.8841e+00,-1.7855e+01),(1.4097e+01,-6.7415e+00,-1.1829e+01),(2.0899e+01,-6.8696e+00,-1.7536e+01),(2.0405e+01,1.9870e+00,-1.7122e+01),(1.4775e+01,-6.7662e+00,-1.1183e+01),(2.1632e+01,-6.8224e+00,-1.6936e+01),(2.0980e+01,2.0900e+00,-1.6389e+01),(1.5291e+01,-6.7886e+00,-1.0652e+01),(2.2941e+01,-6.7678e+00,-1.5432e+01),(2.2042e+01,2.1923e+00,-1.4871e+01),(1.5873e+01,-6.8085e+00,-9.9188e+00),(2.3581e+01,-6.7060e+00,-1.4735e+01),(2.2505e+01,2.2937e+00,-1.4063e+01),(1.6456e+01,-6.8284e+00,-9.1854e+00),(2.4221e+01,-6.6442e+00,-1.4037e+01),(2.2968e+01,2.3951e+00,-1.3254e+01),(1.6914e+01,-6.8458e+00,-8.5496e+00),(2.5338e+01,-6.5752e+00,-1.2300e+01),(2.3797e+01,2.4957e+00,-1.1614e+01),(1.7390e+01,-6.8608e+00,-7.7425e+00),(2.5870e+01,-6.4990e+00,-1.1518e+01),(2.4139e+01,2.5954e+00,-1.0747e+01),(1.7866e+01,-6.8757e+00,-6.9355e+00),(2.6403e+01,-6.4229e+00,-1.0736e+01),(2.4481e+01,2.6950e+00,-9.8808e+00),(1.8247e+01,-6.8882e+00,-6.2005e+00),(2.7286e+01,-6.3397e+00,-8.7926e+00),(2.5064e+01,2.7937e+00,-8.1553e+00),(1.8606e+01,-6.8982e+00,-5.3352e+00),(2.7700e+01,-6.2496e+00,-7.9427e+00),(2.5277e+01,2.8914e+00,-7.2482e+00),(1.8966e+01,-6.9082e+00,-4.4700e+00),(2.8113e+01,-6.1596e+00,-7.0928e+00),(2.5491e+01,2.9891e+00,-6.3410e+00),(1.9250e+01,-6.9157e+00,-3.6454e+00),(2.8725e+01,-6.0627e+00,-4.9771e+00),(2.5819e+01,3.0857e+00,-4.5687e+00),(1.9486e+01,-6.9207e+00,-2.7386e+00),(2.9009e+01,-5.9591e+00,-4.0770e+00),(2.5900e+01,3.1812e+00,-3.6400e+00),(1.9722e+01,-6.9257e+00,-1.8318e+00),(2.9293e+01,-5.8556e+00,-3.1769e+00),(2.5981e+01,3.2767e+00,-2.7114e+00),(1.9893e+01,-6.9282e+00,-9.3084e-01),(2.9602e+01,-5.7455e+00,-9.3084e-01),(2.6054e+01,3.3710e+00,-9.3084e-01),(2.0000e+01,-6.9282e+00,-4.8986e-15),(2.9750e+01,-5.6292e+00,-7.2866e-15),(2.6000e+01,3.4641e+00,-6.3682e-15)])),
      appearance=Appearance(
        material=Material(diffuseColor=(0,0,1)))),
    Shape(
      geometry=NurbsPatchSurface(solid=False,uDimension=3,uKnot=[0,0,0,1,1,1],vDimension=136,vKnot=[0,0,0,0,0.0222222222222,0.0222222222222,0.0222222222222,0.0444444444444,0.0444444444444,0.0444444444444,0.0666666666667,0.0666666666667,0.0666666666667,0.0888888888889,0.0888888888889,0.0888888888889,0.111111111111,0.111111111111,0.111111111111,0.133333333333,0.133333333333,0.133333333333,0.155555555556,0.155555555556,0.155555555556,0.177777777778,0.177777777778,0.177777777778,0.2,0.2,0.2,0.222222222222,0.222222222222,0.222222222222,0.244444444444,0.244444444444,0.244444444444,0.266666666667,0.266666666667,0.266666666667,0.288888888889,0.288888888889,0.288888888889,0.311111111111,0.311111111111,0.311111111111,0.333333333333,0.333333333333,0.333333333333,0.355555555556,0.355555555556,0.355555555556,0.377777777778,0.377777777778,0.377777777778,0.4,0.4,0.4,0.422222222222,0.422222222222,0.422222222222,0.444444444444,0.444444444444,0.444444444444,0.466666666667,0.466666666667,0.466666666667,0.488888888889,0.488888888889,0.488888888889,0.511111111111,0.511111111111,0.511111111111,0.533333333333,0.533333333333,0.533333333333,0.555555555556,0.555555555556,0.555555555556,0.577777777778,0.577777777778,0.577777777778,0.6,0.6,0.6,0.622222222222,0.622222222222,0.622222222222,0.644444444444,0.644444444444,0.644444444444,0.666666666667,0.666666666667,0.666666666667,0.688888888889,0.688888888889,0.688888888889,0.711111111111,0.711111111111,0.711111111111,0.733333333333,0.733333333333,0.733333333333,0.755555555556,0.755555555556,0.755555555556,0.777777777778,0.777777777778,0.777777777778,0.8,0.8,0.8,0.822222222222,0.822222222222,0.822222222222,0.844444444444,0.844444444444,0.844444444444,0.866666666667,0.866666666667,0.866666666667,0.888888888889,0.888888888889,0.888888888889,0.911111111111,0.911111111111,0.911111111111,0.933333333333,0.933333333333,0.933333333333,0.955555555556,0.955555555556,0.955555555556,0.977777777778,0.977777777778,0.977777777778,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        controlPoint=Coordinate(point=[(2.0000e+01,-6.9282e+00,0.0000e+00),(2.9750e+01,-5.6292e+00,0.0000e+00),(2.6000e+01,3.4641e+00,0.0000e+00),(2.0107e+01,-6.9282e+00,9.3084e-01),(2.9898e+01,-5.5128e+00,9.3084e-01),(2.5946e+01,3.5572e+00,9.3084e-01),(2.0148e+01,-6.9257e+00,1.8916e+00),(2.9878e+01,-5.3902e+00,3.2592e+00),(2.5768e+01,3.6490e+00,2.6815e+00),(2.0125e+01,-6.9207e+00,2.8283e+00),(2.9886e+01,-5.2617e+00,4.2002e+00),(2.5581e+01,3.7395e+00,3.5952e+00),(2.0101e+01,-6.9157e+00,3.7650e+00),(2.9894e+01,-5.1332e+00,5.1413e+00),(2.5394e+01,3.8300e+00,4.5089e+00),(1.9998e+01,-6.9082e+00,4.7660e+00),(2.9529e+01,-4.9988e+00,7.4990e+00),(2.4975e+01,3.9191e+00,6.1930e+00),(1.9844e+01,-6.8982e+00,5.6903e+00),(2.9396e+01,-4.8590e+00,8.4291e+00),(2.4658e+01,4.0068e+00,7.0707e+00),(1.9691e+01,-6.8882e+00,6.6145e+00),(2.9263e+01,-4.7192e+00,9.3593e+00),(2.4342e+01,4.0945e+00,7.9483e+00),(1.9433e+01,-6.8757e+00,7.6333e+00),(2.8545e+01,-4.5739e+00,1.1690e+01),(2.3697e+01,4.1807e+00,9.5319e+00),(1.9152e+01,-6.8608e+00,8.5269e+00),(2.8273e+01,-4.4236e+00,1.2588e+01),(2.3258e+01,4.2654e+00,1.0355e+01),(1.8870e+01,-6.8458e+00,9.4206e+00),(2.8002e+01,-4.2734e+00,1.3486e+01),(2.2819e+01,4.3501e+00,1.1179e+01),(1.8452e+01,-6.8284e+00,1.0433e+01),(2.6933e+01,-4.1181e+00,1.5732e+01),(2.1970e+01,4.4333e+00,1.2631e+01),(1.8048e+01,-6.8085e+00,1.1278e+01),(2.6529e+01,-3.9584e+00,1.6577e+01),(2.1418e+01,4.5148e+00,1.3383e+01),(1.7645e+01,-6.7886e+00,1.2123e+01),(2.6125e+01,-3.7986e+00,1.7422e+01),(2.0865e+01,4.5963e+00,1.4135e+01),(1.7063e+01,-6.7662e+00,1.3102e+01),(2.4718e+01,-3.6345e+00,1.9526e+01),(1.9836e+01,4.6762e+00,1.5429e+01),(1.6545e+01,-6.7415e+00,1.3883e+01),(2.4190e+01,-3.4663e+00,2.0298e+01),(1.9181e+01,4.7544e+00,1.6095e+01),(1.6027e+01,-6.7167e+00,1.4663e+01),(2.3663e+01,-3.2982e+00,2.1070e+01),(1.8526e+01,4.8326e+00,1.6761e+01),(1.5283e+01,-6.6894e+00,1.5582e+01),(2.1941e+01,-3.1261e+00,2.2976e+01),(1.7346e+01,4.9091e+00,1.7874e+01),(1.4660e+01,-6.6598e+00,1.6282e+01),(2.1301e+01,-2.9507e+00,2.3658e+01),(1.6603e+01,4.9837e+00,1.8439e+01),(1.4038e+01,-6.6302e+00,1.6982e+01),(2.0662e+01,-2.7752e+00,2.4339e+01),(1.5859e+01,5.0584e+00,1.9005e+01),(1.3139e+01,-6.5982e+00,1.7814e+01),(1.8657e+01,-2.5965e+00,2.5996e+01),(1.4559e+01,5.1313e+00,1.9921e+01),(1.2424e+01,-6.5638e+00,1.8419e+01),(1.7922e+01,-2.4149e+00,2.6570e+01),(1.3743e+01,5.2022e+00,2.0374e+01),(1.1709e+01,-6.5294e+00,1.9024e+01),(1.7186e+01,-2.2334e+00,2.7144e+01),(1.2926e+01,5.2732e+00,2.0828e+01),(1.0665e+01,-6.4926e+00,1.9743e+01),(1.4939e+01,-2.0491e+00,2.8507e+01),(1.1538e+01,5.3423e+00,2.1534e+01),(9.8723e+00,-6.4535e+00,2.0241e+01),(1.4124e+01,-1.8627e+00,2.8959e+01),(1.0665e+01,5.4095e+00,2.1866e+01),(9.0796e+00,-6.4144e+00,2.0739e+01),(1.3310e+01,-1.6763e+00,2.9412e+01),(9.7916e+00,5.4767e+00,2.2199e+01),(7.9061e+00,-6.3729e+00,2.1320e+01),(1.0870e+01,-1.4877e+00,3.0443e+01),(8.3509e+00,5.5419e+00,2.2689e+01),(7.0511e+00,-6.3292e+00,2.1701e+01),(9.9957e+00,-1.2977e+00,3.0764e+01),(7.4387e+00,5.6050e+00,2.2894e+01),(6.1962e+00,-6.2855e+00,2.2082e+01),(9.1211e+00,-1.1077e+00,3.1084e+01),(6.5266e+00,5.6682e+00,2.3099e+01),(4.9129e+00,-6.2395e+00,2.2502e+01),(6.5444e+00,-9.1617e-01,3.1754e+01),(5.0664e+00,5.7294e+00,2.3372e+01),(4.0129e+00,-6.1913e+00,2.2758e+01),(5.6310e+00,-7.2384e-01,3.1935e+01),(4.1341e+00,5.7884e+00,2.3445e+01),(3.1129e+00,-6.1430e+00,2.3015e+01),(4.7177e+00,-5.3150e-01,3.2116e+01),(3.2018e+00,5.8475e+00,2.3519e+01),(1.7434e+00,-6.0926e+00,2.3254e+01),(2.0631e+00,-3.3834e-01,3.2407e+01),(1.7548e+00,5.9045e+00,2.3579e+01),(8.1644e-01,-6.0399e+00,2.3380e+01),(1.1329e+00,-1.4502e-01,3.2443e+01),(8.2131e-01,5.9593e+00,2.3519e+01),(-1.1056e-01,-5.9872e+00,2.3506e+01),(2.0279e-01,4.8311e-02,3.2479e+01),(-1.1219e-01,6.0141e+00,2.3459e+01),(-1.5391e+00,-5.9324e+00,2.3548e+01),(-2.4675e+00,2.4180e-01,3.2382e+01),(-1.5147e+00,6.0668e+00,2.3317e+01),(-2.4743e+00,-5.8754e+00,2.3542e+01),(-3.3921e+00,4.3480e-01,3.2273e+01),(-2.4306e+00,6.1172e+00,2.3125e+01),(-3.4096e+00,-5.8185e+00,2.3535e+01),(-4.3166e+00,6.2780e-01,3.2164e+01),(-3.3464e+00,6.1677e+00,2.2934e+01),(-4.8672e+00,-5.7594e+00,2.3369e+01),(-6.9399e+00,8.2029e-01,3.1682e+01),(-4.6759e+00,6.2160e+00,2.2602e+01),(-5.7918e+00,-5.6983e+00,2.3230e+01),(-7.8366e+00,1.0116e+00,3.1431e+01),(-5.5556e+00,6.2619e+00,2.2282e+01),(-6.7164e+00,-5.6371e+00,2.3090e+01),(-8.7332e+00,1.2030e+00,3.1179e+01),(-6.4353e+00,6.3079e+00,2.1963e+01),(-8.1710e+00,-5.5739e+00,2.2709e+01),(-1.1248e+01,1.3932e+00,3.0326e+01),(-7.6664e+00,6.3517e+00,2.1460e+01),(-9.0661e+00,-5.5088e+00,2.2439e+01),(-1.2096e+01,1.5815e+00,2.9938e+01),(-8.4923e+00,6.3931e+00,2.1019e+01),(-9.9612e+00,-5.4436e+00,2.2170e+01),(-1.2943e+01,1.7699e+00,2.9550e+01),(-9.3182e+00,6.4345e+00,2.0579e+01),(-1.1379e+01,-5.3764e+00,2.1571e+01),(-1.5292e+01,1.9565e+00,2.8349e+01),(-1.0429e+01,6.4736e+00,1.9926e+01),(-1.2227e+01,-5.3073e+00,2.1177e+01),(-1.6070e+01,2.1406e+00,2.7834e+01),(-1.1185e+01,6.5104e+00,1.9373e+01),(-1.3074e+01,-5.2382e+00,2.0783e+01),(-1.6848e+01,2.3248e+00,2.7319e+01),(-1.1940e+01,6.5471e+00,1.8820e+01),(-1.4422e+01,-5.1672e+00,1.9971e+01),(-1.8979e+01,2.5064e+00,2.5804e+01),(-1.2914e+01,6.5816e+00,1.8041e+01),(-1.5204e+01,-5.0944e+00,1.9460e+01),(-1.9669e+01,2.6851e+00,2.5175e+01),(-1.3584e+01,6.6136e+00,1.7387e+01),(-1.5986e+01,-5.0215e+00,1.8949e+01),(-2.0358e+01,2.8637e+00,2.4545e+01),(-1.4254e+01,6.6456e+00,1.6733e+01),(-1.7230e+01,-4.9468e+00,1.7933e+01),(-2.2226e+01,3.0393e+00,2.2758e+01),(-1.5077e+01,6.6752e+00,1.5854e+01),(-1.7931e+01,-4.8704e+00,1.7316e+01),(-2.2811e+01,3.2112e+00,2.2029e+01),(-1.5649e+01,6.7024e+00,1.5112e+01),(-1.8632e+01,-4.7940e+00,1.6699e+01),(-2.3396e+01,3.3832e+00,2.1300e+01),(-1.6220e+01,6.7297e+00,1.4370e+01),(-1.9740e+01,-4.7157e+00,1.5493e+01),(-2.4964e+01,3.5514e+00,1.9288e+01),(-1.6884e+01,6.7545e+00,1.3417e+01),(-2.0346e+01,-4.6359e+00,1.4782e+01),(-2.5432e+01,3.7155e+00,1.8477e+01),(-1.7346e+01,6.7768e+00,1.2602e+01),(-2.0951e+01,-4.5560e+00,1.4071e+01),(-2.5899e+01,3.8796e+00,1.7666e+01),(-1.7808e+01,6.7992e+00,1.1788e+01),(-2.1893e+01,-4.4744e+00,1.2695e+01),(-2.7139e+01,4.0394e+00,1.5484e+01),(-1.8308e+01,6.8191e+00,1.0789e+01),(-2.2390e+01,-4.3913e+00,1.1905e+01),(-2.7477e+01,4.1946e+00,1.4610e+01),(-1.8651e+01,6.8365e+00,9.9169e+00),(-2.2888e+01,-4.3082e+00,1.1115e+01),(-2.7816e+01,4.3497e+00,1.3736e+01),(-1.8994e+01,6.8539e+00,9.0453e+00),(-2.3637e+01,-4.2235e+00,9.5939e+00),(-2.8710e+01,4.5001e+00,1.1440e+01),(-1.9332e+01,6.8689e+00,8.0267e+00),(-2.4016e+01,-4.1372e+00,8.7411e+00),(-2.8913e+01,4.6452e+00,1.0524e+01),(-1.9550e+01,6.8814e+00,7.1155e+00),(-2.4395e+01,-4.0510e+00,7.8883e+00),(-2.9116e+01,4.7904e+00,9.6069e+00),(-1.9768e+01,6.8938e+00,6.2043e+00),(-2.4929e+01,-3.9633e+00,6.2504e+00),(-2.9657e+01,4.9303e+00,7.2555e+00),(-1.9947e+01,6.9038e+00,5.1915e+00),(-2.5181e+01,-3.8742e+00,5.3524e+00),(-2.9720e+01,5.0646e+00,6.3172e+00),(-2.0036e+01,6.9113e+00,4.2587e+00),(-2.5434e+01,-3.7851e+00,4.4544e+00),(-2.9783e+01,5.1989e+00,5.3789e+00),(-2.0124e+01,6.9188e+00,3.3259e+00),(-2.5734e+01,-3.6946e+00,2.7326e+00),(-2.9973e+01,5.3275e+00,3.0291e+00),(-2.0154e+01,6.9238e+00,2.3424e+00),(-2.5855e+01,-3.6028e+00,1.8079e+00),(-2.9895e+01,5.4500e+00,2.0905e+00),(-2.0112e+01,6.9263e+00,1.4064e+00),(-2.5975e+01,-3.5110e+00,8.8326e-01),(-2.9817e+01,5.5725e+00,1.1519e+00),(-2.0070e+01,6.9288e+00,4.7030e-01),(-2.6029e+01,-3.4179e+00,-8.8701e-01),(-2.9670e+01,5.6889e+00,-1.1416e+00),(-1.9963e+01,6.9288e+00,-4.6280e-01),(-2.6015e+01,-3.3235e+00,-1.8192e+00),(-2.9453e+01,5.7990e+00,-2.0596e+00),(-1.9790e+01,6.9263e+00,-1.3839e+00),(-2.6002e+01,-3.2292e+00,-2.7513e+00),(-2.9237e+01,5.9090e+00,-2.9775e+00),(-1.9618e+01,6.9238e+00,-2.3050e+00),(-2.5801e+01,-3.1337e+00,-4.5326e+00),(-2.8772e+01,6.0126e+00,-5.1641e+00),(-1.9389e+01,6.9188e+00,-3.1695e+00),(-2.5654e+01,-3.0371e+00,-5.4529e+00),(-2.8423e+01,6.1094e+00,-6.0414e+00),(-1.9090e+01,6.9113e+00,-4.0578e+00),(-2.5506e+01,-2.9405e+00,-6.3732e+00),(-2.8073e+01,6.2063e+00,-6.9188e+00),(-1.8792e+01,6.9038e+00,-4.9460e+00),(-2.5050e+01,-2.8428e+00,-8.1269e+00),(-2.7321e+01,6.2964e+00,-8.9533e+00),(-1.8457e+01,6.8938e+00,-5.7271e+00),(-2.4772e+01,-2.7441e+00,-9.0162e+00),(-2.6846e+01,6.3796e+00,-9.7713e+00),(-1.8038e+01,6.8814e+00,-6.5653e+00),(-2.4493e+01,-2.6454e+00,-9.9055e+00),(-2.6372e+01,6.4627e+00,-1.0589e+01),(-1.7619e+01,6.8689e+00,-7.4035e+00),(-2.3786e+01,-2.5457e+00,-1.1593e+01),(-2.5367e+01,6.5389e+00,-1.2433e+01),(-1.7198e+01,6.8539e+00,-8.0898e+00),(-2.3383e+01,-2.4452e+00,-1.2433e+01),(-2.4779e+01,6.6079e+00,-1.3175e+01),(-1.6667e+01,6.8365e+00,-8.8619e+00),(-2.2979e+01,-2.3446e+00,-1.3272e+01),(-2.4191e+01,6.6769e+00,-1.3917e+01),(-1.6136e+01,6.8191e+00,-9.6340e+00),(-2.2031e+01,-2.2432e+00,-1.4856e+01),(-2.2973e+01,6.7387e+00,-1.5540e+01),(-1.5647e+01,6.7992e+00,-1.0218e+01),(-2.1511e+01,-2.1409e+00,-1.5629e+01),(-2.2284e+01,6.7933e+00,-1.6190e+01),(-1.5015e+01,6.7768e+00,-1.0909e+01),(-2.0991e+01,-2.0387e+00,-1.6401e+01),(-2.1596e+01,6.8478e+00,-1.6841e+01),(-1.4383e+01,6.7545e+00,-1.1600e+01),(-1.9819e+01,-1.9357e+00,-1.7845e+01),(-2.0208e+01,6.8950e+00,-1.8221e+01),(-1.3846e+01,6.7297e+00,-1.2077e+01),(-1.9193e+01,-1.8321e+00,-1.8535e+01),(-1.9434e+01,6.9349e+00,-1.8767e+01),(-1.3125e+01,6.7024e+00,-1.2675e+01),(-1.8567e+01,-1.7284e+00,-1.9224e+01),(-1.8660e+01,6.9748e+00,-1.9313e+01),(-1.2404e+01,6.6752e+00,-1.3272e+01),(-1.7194e+01,-1.6241e+00,-2.0495e+01),(-1.7147e+01,7.0072e+00,-2.0435e+01),(-1.1839e+01,6.6456e+00,-1.3641e+01),(-1.6475e+01,-1.5192e+00,-2.1087e+01),(-1.6304e+01,7.0323e+00,-2.0868e+01),(-1.1042e+01,6.6136e+00,-1.4134e+01),(-1.5756e+01,-1.4143e+00,-2.1678e+01),(-1.5460e+01,7.0574e+00,-2.1300e+01),(-1.0246e+01,6.5816e+00,-1.4626e+01),(-1.4208e+01,-1.3089e+00,-2.2748e+01),(-1.3868e+01,7.0750e+00,-2.2159e+01),(-9.6718e+00,6.5471e+00,-1.4890e+01),(-1.3411e+01,-1.2031e+00,-2.3229e+01),(-1.2973e+01,7.0853e+00,-2.2469e+01),(-8.8152e+00,6.5104e+00,-1.5268e+01),(-1.2615e+01,-1.0972e+00,-2.3711e+01),(-1.2077e+01,7.0956e+00,-2.2780e+01),(-7.9586e+00,6.4736e+00,-1.5646e+01),(-1.0924e+01,-9.9093e-01,-2.4553e+01),(-1.0449e+01,7.0985e+00,-2.3376e+01),(-7.3922e+00,6.4345e+00,-1.5811e+01),(-1.0066e+01,-8.8433e-01,-2.4915e+01),(-9.5191e+00,7.0942e+00,-2.3561e+01),(-6.4920e+00,6.3931e+00,-1.6068e+01),(-9.2083e+00,-7.7772e-01,-2.5276e+01),(-8.5896e+00,7.0899e+00,-2.3745e+01),(-5.5917e+00,6.3517e+00,-1.6325e+01),(-7.4100e+00,-6.7080e-01,-2.5872e+01),(-6.9650e+00,7.0782e+00,-2.4088e+01),(-5.0480e+00,6.3079e+00,-1.6399e+01),(-6.5090e+00,-5.6367e-01,-2.6106e+01),(-6.0195e+00,7.0596e+00,-2.4143e+01),(-4.1213e+00,6.2619e+00,-1.6530e+01),(-5.6079e+00,-4.5654e-01,-2.6340e+01),(-5.0741e+00,7.0409e+00,-2.4199e+01),(-3.1946e+00,6.2160e+00,-1.6660e+01),(-3.7397e+00,-3.4921e-01,-2.6675e+01),(-3.4903e+00,7.0150e+00,-2.4302e+01),(-2.6862e+00,6.1677e+00,-1.6653e+01),(-2.8143e+00,-2.4179e-01,-2.6776e+01),(-2.5466e+00,6.9823e+00,-2.4230e+01),(-1.7506e+00,6.1172e+00,-1.6656e+01),(-1.8890e+00,-1.3437e-01,-2.6878e+01),(-1.6030e+00,6.9496e+00,-2.4157e+01),(-8.1492e-01,6.0668e+00,-1.6659e+01),(9.5328e-03,-2.6866e-02,-2.6945e+01),(-9.1883e-02,6.9099e+00,-2.4041e+01),(-3.5238e-01,6.0141e+00,-1.6581e+01),(9.3976e-01,8.0611e-02,-2.6911e+01),(8.3260e-01,6.8637e+00,-2.3842e+01),(5.7467e-01,5.9593e+00,-1.6456e+01),(1.8700e+00,1.8809e-01,-2.6878e+01),(1.7571e+00,6.8174e+00,-2.3644e+01),(1.5017e+00,5.9045e+00,-1.6331e+01),(3.7584e+00,2.9554e-01,-2.6675e+01),(3.1688e+00,6.7644e+00,-2.3332e+01),(1.9108e+00,5.8475e+00,-1.6197e+01),(4.6740e+00,4.0284e-01,-2.6508e+01),(4.0577e+00,6.7052e+00,-2.3012e+01),(2.8119e+00,5.7884e+00,-1.5947e+01),(5.5896e+00,5.1014e-01,-2.6340e+01),(4.9466e+00,6.6460e+00,-2.2693e+01),(3.7130e+00,5.7294e+00,-1.5697e+01),(7.4277e+00,6.1730e-01,-2.5872e+01),(6.2378e+00,6.5803e+00,-2.2210e+01),(4.0635e+00,5.6682e+00,-1.5518e+01),(8.3095e+00,7.2419e-01,-2.5574e+01),(7.0758e+00,6.5088e+00,-2.1777e+01),(4.9219e+00,5.6050e+00,-1.5148e+01),(9.1914e+00,8.3109e-01,-2.5276e+01),(7.9139e+00,6.4372e+00,-2.1344e+01),(5.7803e+00,5.5419e+00,-1.4778e+01),(1.0940e+01,9.3772e-01,-2.4554e+01),(9.0688e+00,6.3596e+00,-2.0717e+01),(6.0700e+00,5.4767e+00,-1.4569e+01),(1.1770e+01,1.0440e+00,-2.4132e+01),(9.8420e+00,6.2765e+00,-2.0179e+01),(6.8699e+00,5.4095e+00,-1.4085e+01),(1.2599e+01,1.1502e+00,-2.3709e+01),(1.0615e+01,6.1935e+00,-1.9641e+01),(7.6697e+00,5.3423e+00,-1.3602e+01),(1.4223e+01,1.2561e+00,-2.2751e+01),(1.1624e+01,6.1047e+00,-1.8897e+01),(7.8986e+00,5.2732e+00,-1.3375e+01),(1.4983e+01,1.3615e+00,-2.2212e+01),(1.2319e+01,6.0109e+00,-1.8264e+01),(8.6252e+00,5.2022e+00,-1.2787e+01),(1.5742e+01,1.4669e+00,-2.1674e+01),(1.3015e+01,5.9171e+00,-1.7631e+01),(9.3518e+00,5.1313e+00,-1.2200e+01),(1.7206e+01,1.5718e+00,-2.0501e+01),(1.3871e+01,5.8181e+00,-1.6797e+01),(9.5222e+00,5.0584e+00,-1.1967e+01),(1.7881e+01,1.6761e+00,-1.9859e+01),(1.4479e+01,5.7145e+00,-1.6081e+01),(1.0162e+01,4.9837e+00,-1.1286e+01),(1.8555e+01,1.7804e+00,-1.9216e+01),(1.5087e+01,5.6110e+00,-1.5364e+01),(1.0802e+01,4.9091e+00,-1.0606e+01),(1.9831e+01,1.8841e+00,-1.7855e+01),(1.5789e+01,5.5027e+00,-1.4464e+01),(1.0919e+01,4.8326e+00,-1.0377e+01),(2.0405e+01,1.9870e+00,-1.7122e+01),(1.6300e+01,5.3903e+00,-1.3677e+01),(1.1460e+01,4.7544e+00,-9.6165e+00),(2.0980e+01,2.0900e+00,-1.6389e+01),(1.6810e+01,5.2780e+00,-1.2890e+01),(1.2002e+01,4.6762e+00,-8.8560e+00),(2.2042e+01,2.1923e+00,-1.4871e+01),(1.7361e+01,5.1614e+00,-1.1946e+01),(1.2070e+01,4.5963e+00,-8.6401e+00),(2.2505e+01,2.2937e+00,-1.4063e+01),(1.7766e+01,5.0413e+00,-1.1102e+01),(1.2504e+01,4.5148e+00,-7.8136e+00),(2.2968e+01,2.3951e+00,-1.3254e+01),(1.8172e+01,4.9213e+00,-1.0257e+01),(1.2938e+01,4.4333e+00,-6.9871e+00),(2.3797e+01,2.4957e+00,-1.1614e+01),(1.8576e+01,4.7974e+00,-9.2894e+00),(1.2965e+01,4.3501e+00,-6.7914e+00),(2.4139e+01,2.5954e+00,-1.0747e+01),(1.8871e+01,4.6708e+00,-8.4017e+00),(1.3283e+01,4.2654e+00,-5.9142e+00),(2.4481e+01,2.6950e+00,-9.8808e+00),(1.9165e+01,4.5441e+00,-7.5141e+00),(1.3602e+01,4.1807e+00,-5.0369e+00),(2.5064e+01,2.7937e+00,-8.1553e+00),(1.9429e+01,4.4142e+00,-6.5396e+00),(1.3595e+01,4.0945e+00,-4.8668e+00),(2.5277e+01,2.8914e+00,-7.2482e+00),(1.9609e+01,4.2820e+00,-5.6229e+00),(1.3792e+01,4.0068e+00,-3.9548e+00),(2.5491e+01,2.9891e+00,-6.3410e+00),(1.9790e+01,4.1499e+00,-4.7063e+00),(1.3989e+01,3.9191e+00,-3.0429e+00),(2.5819e+01,3.0857e+00,-4.5687e+00),(1.9921e+01,4.0151e+00,-3.7397e+00),(1.3958e+01,3.8300e+00,-2.9016e+00),(2.5900e+01,3.1812e+00,-3.6400e+00),(1.9984e+01,3.8786e+00,-2.8086e+00),(1.4030e+01,3.7395e+00,-1.9718e+00),(2.5981e+01,3.2767e+00,-2.7114e+00),(2.0048e+01,3.7422e+00,-1.8775e+00),(1.4102e+01,3.6490e+00,-1.0419e+00),(2.6054e+01,3.3710e+00,-9.3084e-01),(2.0027e+01,3.5339e+00,-4.6542e-01),(1.4054e+01,3.5572e+00,-9.3084e-01),(2.6000e+01,3.4641e+00,-6.3682e-15),(2.0000e+01,3.4641e+00,-4.8986e-15),(1.4000e+01,3.4641e+00,-3.4290e-15)])),
      appearance=Appearance(
        material=Material(diffuseColor=(0,0,1))))])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for MobiusNurbs.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python MobiusNurbs.py load and self-test diagnostics complete.")
