####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python HurricaneLantern.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    component(level=1,name='NURBS'),
    meta(content='HurricaneLantern.x3d',name='title'),
    meta(content='NURBS model created using X3D NURBS Export Plugin for Maya.',name='description'),
    meta(content='Exported from Maya 4.0 using X3DNurbsExport Plug-in',name='translator'),
    meta(content='Charles Adams',name='creator'),
    meta(content='6 February 2003',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='images/HurricaneLanternBSContact.png',name='Image'),
    meta(content='images/HurricaneLanternH3dViewer.png',name='Image'),
    meta(content='images/HurricaneLanternInstantReality.png',name='Image'),
    meta(content='images/HurricaneLanternOctagaVS.png',name='Image'),
    meta(content='images/HurricaneLanternView3dscene.png',name='Image'),
    meta(content='images/HurricaneLanternXj3d.png',name='Image'),
    meta(content='http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf',name='reference'),
    meta(content='NURBS Hurricane Lantern',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/NURBS/HurricaneLantern.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='HurricaneLantern.x3d'),
    Viewpoint(description='Hurricane Lantern',position=(0,1,4)),
    Background(skyColor=[(1,0.9882353,0.7411765)]),
    Transform(translation=(-51.5865,-10.2621,3.3253),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='LampConeShape',solid=False,uClosed=True,uDimension=17,uKnot=[0,0,0,0,0.0938,0.1875,0.2500,0.2813,0.3750,0.4375,0.5000,0.5625,0.6875,0.7188,0.8125,0.8438,0.9375,1,1,1,1],uOrder=4,vClosed=True,vDimension=27,vKnot=[0,0,0,0,0.0473,0.0946,0.1418,0.1891,0.2364,0.2837,0.3310,0.3783,0.4255,0.4728,0.5201,0.5674,0.6147,0.6619,0.7092,0.7565,0.8038,0.8511,0.8983,0.9456,0.9929,0.9953,0.9976,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(51.4068,11.4904,-3.3777),(51.4195,11.4904,-3.4127),(51.4657,11.4904,-3.4751),(51.5645,11.4904,-3.5090),(51.6386,11.4904,-3.4976),(51.7064,11.4904,-3.4651),(51.7582,11.4904,-3.4078),(51.7791,11.4904,-3.3210),(51.7677,11.4904,-3.2468),(51.7150,11.4904,-3.1593),(51.6313,11.4904,-3.1203),(51.5307,11.4904,-3.1258),(51.4728,11.4904,-3.1533),(51.4144,11.4904,-3.2188),(51.3883,11.4904,-3.2914),(51.3984,11.4904,-3.3545),(51.4069,11.4904,-3.3778),(51.4005,11.4373,-3.3800),(51.4137,11.4373,-3.4162),(51.4614,11.4373,-3.4808),(51.5638,11.4373,-3.5159),(51.6405,11.4373,-3.5041),(51.7107,11.4373,-3.4705),(51.7644,11.4373,-3.4112),(51.7860,11.4373,-3.3213),(51.7742,11.4373,-3.2444),(51.7196,11.4373,-3.1538),(51.6329,11.4373,-3.1135),(51.5288,11.4373,-3.1191),(51.4689,11.4373,-3.1476),(51.4083,11.4373,-3.2155),(51.3813,11.4373,-3.2906),(51.3918,11.4373,-3.3560),(51.4006,11.4373,-3.3802),(51.4280,11.3636,-3.3700),(51.4392,11.3636,-3.4008),(51.4799,11.3636,-3.4558),(51.5669,11.3636,-3.4856),(51.6322,11.3636,-3.4756),(51.6920,11.3636,-3.4470),(51.7376,11.3636,-3.3965),(51.7559,11.3636,-3.3200),(51.7459,11.3636,-3.2546),(51.6995,11.3636,-3.1776),(51.6257,11.3636,-3.1433),(51.5372,11.3636,-3.1480),(51.4862,11.3636,-3.1723),(51.4347,11.3636,-3.2300),(51.4117,11.3636,-3.2939),(51.4206,11.3636,-3.3496),(51.4281,11.3636,-3.3701),(51.3781,11.0774,-3.3881),(51.3929,11.0774,-3.4287),(51.4465,11.0774,-3.5012),(51.5612,11.0774,-3.5406),(51.6472,11.0774,-3.5273),(51.7260,11.0774,-3.4896),(51.7861,11.0774,-3.4231),(51.8104,11.0774,-3.3223),(51.7971,11.0774,-3.2361),(51.7360,11.0774,-3.1345),(51.6387,11.0774,-3.0893),(51.5220,11.0774,-3.0956),(51.4548,11.0774,-3.1276),(51.3869,11.0774,-3.2037),(51.3566,11.0774,-3.2879),(51.3684,11.0774,-3.3612),(51.3782,11.0774,-3.3883),(51.3279,10.8962,-3.4064),(51.3463,10.8962,-3.4569),(51.4128,10.8962,-3.5469),(51.5555,10.8962,-3.5959),(51.6624,10.8962,-3.5794),(51.7603,10.8962,-3.5326),(51.8350,10.8962,-3.4499),(51.8651,10.8962,-3.3246),(51.8487,10.8962,-3.2174),(51.7726,10.8962,-3.0912),(51.6518,10.8962,-3.0350),(51.5068,10.8962,-3.0428),(51.4232,10.8962,-3.0826),(51.3388,10.8962,-3.1772),(51.3012,10.8962,-3.2818),(51.3158,10.8962,-3.3730),(51.3280,10.8962,-3.4066),(51.3113,10.8077,-3.4125),(51.3308,10.8077,-3.4662),(51.4017,10.8077,-3.5621),(51.5536,10.8077,-3.6142),(51.6674,10.8077,-3.5967),(51.7717,10.8077,-3.5468),(51.8512,10.8077,-3.4588),(51.8832,10.8077,-3.3254),(51.8658,10.8077,-3.2113),(51.7848,10.8077,-3.0769),(51.6561,10.8077,-3.0170),(51.5017,10.8077,-3.0254),(51.4127,10.8077,-3.0677),(51.3229,10.8077,-3.1684),(51.2828,10.8077,-3.2798),(51.2984,10.8077,-3.3769),(51.3114,10.8077,-3.4127),(51.3393,10.6999,-3.4023),(51.3569,10.6999,-3.4505),(51.4205,10.6999,-3.5365),(51.5568,10.6999,-3.5833),(51.6589,10.6999,-3.5676),(51.7525,10.6999,-3.5228),(51.8239,10.6999,-3.4438),(51.8527,10.6999,-3.3241),(51.8370,10.6999,-3.2217),(51.7643,10.6999,-3.1011),(51.6488,10.6999,-3.0474),(51.5102,10.6999,-3.0548),(51.4304,10.6999,-3.0928),(51.3498,10.6999,-3.1832),(51.3138,10.6999,-3.2832),(51.3277,10.6999,-3.3703),(51.3394,10.6999,-3.4025),(51.3393,10.6999,-3.4023),(51.3569,10.6999,-3.4505),(51.4205,10.6999,-3.5365),(51.5568,10.6999,-3.5833),(51.6589,10.6999,-3.5676),(51.7525,10.6999,-3.5228),(51.8239,10.6999,-3.4438),(51.8527,10.6999,-3.3241),(51.8370,10.6999,-3.2217),(51.7643,10.6999,-3.1011),(51.6488,10.6999,-3.0474),(51.5102,10.6999,-3.0548),(51.4304,10.6999,-3.0928),(51.3498,10.6999,-3.1832),(51.3138,10.6999,-3.2832),(51.3277,10.6999,-3.3703),(51.3394,10.6999,-3.4025),(51.3643,10.6615,-3.3932),(51.3800,10.6615,-3.4365),(51.4372,10.6615,-3.5138),(51.5596,10.6615,-3.5558),(51.6514,10.6615,-3.5417),(51.7355,10.6615,-3.5015),(51.7996,10.6615,-3.4305),(51.8255,10.6615,-3.3229),(51.8114,10.6615,-3.2310),(51.7461,10.6615,-3.1226),(51.6423,10.6615,-3.0743),(51.5178,10.6615,-3.0810),(51.4461,10.6615,-3.1152),(51.3736,10.6615,-3.1964),(51.3413,10.6615,-3.2862),(51.3539,10.6615,-3.3645),(51.3644,10.6615,-3.3934),(51.4059,10.6148,-3.3781),(51.4186,10.6148,-3.4132),(51.4650,10.6148,-3.4759),(51.5644,10.6148,-3.5101),(51.6389,10.6148,-3.4986),(51.7071,10.6148,-3.4659),(51.7592,10.6148,-3.4084),(51.7801,10.6148,-3.3210),(51.7687,10.6148,-3.2464),(51.7157,10.6148,-3.1585),(51.6315,10.6148,-3.1193),(51.5305,10.6148,-3.1247),(51.4722,10.6148,-3.1524),(51.4135,10.6148,-3.2183),(51.3872,10.6148,-3.2912),(51.3974,10.6148,-3.3548),(51.4059,10.6148,-3.3782),(51.4918,10.5966,-3.3468),(51.4984,10.5966,-3.3651),(51.5225,10.5966,-3.3977),(51.5742,10.5966,-3.4154),(51.6130,10.5966,-3.4095),(51.6484,10.5966,-3.3925),(51.6755,10.5966,-3.3625),(51.6864,10.5966,-3.3171),(51.6805,10.5966,-3.2783),(51.6529,10.5966,-3.2326),(51.6091,10.5966,-3.2122),(51.5566,10.5966,-3.2150),(51.5263,10.5966,-3.2295),(51.4957,10.5966,-3.2637),(51.4821,10.5966,-3.3016),(51.4874,10.5966,-3.3347),(51.4918,10.5966,-3.3469),(51.5916,10.5966,-3.3105),(51.5911,10.5966,-3.3091),(51.5894,10.5966,-3.3068),(51.5856,10.5966,-3.3055),(51.5829,10.5966,-3.3060),(51.5803,10.5966,-3.3072),(51.5784,10.5966,-3.3093),(51.5776,10.5966,-3.3126),(51.5780,10.5966,-3.3154),(51.5800,10.5966,-3.3187),(51.5831,10.5966,-3.3201),(51.5869,10.5966,-3.3199),(51.5891,10.5966,-3.3189),(51.5913,10.5966,-3.3164),(51.5923,10.5966,-3.3137),(51.5919,10.5966,-3.3113),(51.5916,10.5966,-3.3105),(51.5888,10.6025,-3.3115),(51.5885,10.6025,-3.3107),(51.5875,10.6025,-3.3093),(51.5853,10.6025,-3.3086),(51.5837,10.6025,-3.3088),(51.5822,10.6025,-3.3095),(51.5811,10.6025,-3.3108),(51.5806,10.6025,-3.3127),(51.5809,10.6025,-3.3143),(51.5820,10.6025,-3.3163),(51.5839,10.6025,-3.3171),(51.5861,10.6025,-3.3170),(51.5873,10.6025,-3.3164),(51.5886,10.6025,-3.3150),(51.5892,10.6025,-3.3134),(51.5890,10.6025,-3.3120),(51.5888,10.6025,-3.3115),(51.4918,10.6114,-3.3468),(51.4984,10.6114,-3.3651),(51.5225,10.6114,-3.3977),(51.5742,10.6114,-3.4154),(51.6130,10.6114,-3.4095),(51.6484,10.6114,-3.3925),(51.6755,10.6114,-3.3625),(51.6864,10.6114,-3.3171),(51.6805,10.6114,-3.2783),(51.6529,10.6114,-3.2326),(51.6091,10.6114,-3.2122),(51.5566,10.6114,-3.2150),(51.5263,10.6114,-3.2295),(51.4957,10.6114,-3.2637),(51.4821,10.6114,-3.3016),(51.4874,10.6114,-3.3347),(51.4918,10.6114,-3.3469),(51.4114,10.6325,-3.3760),(51.4238,10.6325,-3.4101),(51.4687,10.6325,-3.4709),(51.5650,10.6325,-3.5039),(51.6372,10.6325,-3.4928),(51.7033,10.6325,-3.4612),(51.7538,10.6325,-3.4054),(51.7741,10.6325,-3.3208),(51.7630,10.6325,-3.2485),(51.7117,10.6325,-3.1632),(51.6301,10.6325,-3.1253),(51.5321,10.6325,-3.1306),(51.4757,10.6325,-3.1574),(51.4188,10.6325,-3.2213),(51.3934,10.6325,-3.2919),(51.4032,10.6325,-3.3535),(51.4115,10.6325,-3.3762),(51.3754,10.6674,-3.3892),(51.3903,10.6674,-3.4303),(51.4446,10.6674,-3.5037),(51.5609,10.6674,-3.5436),(51.6481,10.6674,-3.5302),(51.7279,10.6674,-3.4920),(51.7888,10.6674,-3.4246),(51.8134,10.6674,-3.3224),(51.8000,10.6674,-3.2351),(51.7380,10.6674,-3.1322),(51.6394,10.6674,-3.0863),(51.5212,10.6674,-3.0927),(51.4531,10.6674,-3.1251),(51.3843,10.6674,-3.2022),(51.3536,10.6674,-3.2876),(51.3655,10.6674,-3.3619),(51.3755,10.6674,-3.3893),(51.3532,10.7087,-3.3972),(51.3697,10.7087,-3.4427),(51.4297,10.7087,-3.5239),(51.5584,10.7087,-3.5681),(51.6548,10.7087,-3.5532),(51.7430,10.7087,-3.5110),(51.8104,10.7087,-3.4364),(51.8376,10.7087,-3.3234),(51.8227,10.7087,-3.2268),(51.7542,10.7087,-3.1130),(51.6452,10.7087,-3.0623),(51.5144,10.7087,-3.0694),(51.4391,10.7087,-3.1052),(51.3630,10.7087,-3.1905),(51.3291,10.7087,-3.2849),(51.3422,10.7087,-3.3671),(51.3533,10.7087,-3.3974),(51.3279,10.7900,-3.4064),(51.3463,10.7900,-3.4569),(51.4128,10.7900,-3.5469),(51.5555,10.7900,-3.5959),(51.6624,10.7900,-3.5794),(51.7603,10.7900,-3.5326),(51.8350,10.7900,-3.4499),(51.8651,10.7900,-3.3246),(51.8487,10.7900,-3.2174),(51.7726,10.7900,-3.0912),(51.6518,10.7900,-3.0350),(51.5068,10.7900,-3.0428),(51.4232,10.7900,-3.0826),(51.3388,10.7900,-3.1772),(51.3012,10.7900,-3.2818),(51.3158,10.7900,-3.3730),(51.3280,10.7900,-3.4066),(51.3390,10.8874,-3.4024),(51.3566,10.8874,-3.4507),(51.4203,10.8874,-3.5368),(51.5568,10.8874,-3.5837),(51.6590,10.8874,-3.5679),(51.7527,10.8874,-3.5231),(51.8242,10.8874,-3.4440),(51.8530,10.8874,-3.3241),(51.8373,10.8874,-3.2216),(51.7645,10.8874,-3.1008),(51.6489,10.8874,-3.0470),(51.5101,10.8874,-3.0545),(51.4302,10.8874,-3.0925),(51.3494,10.8874,-3.1830),(51.3134,10.8874,-3.2832),(51.3274,10.8874,-3.3704),(51.3391,10.8874,-3.4026),(51.3948,11.0715,-3.3821),(51.4084,11.0715,-3.4194),(51.4576,11.0715,-3.4860),(51.5631,11.0715,-3.5223),(51.6422,11.0715,-3.5101),(51.7147,11.0715,-3.4754),(51.7699,11.0715,-3.4143),(51.7922,11.0715,-3.3216),(51.7801,11.0715,-3.2423),(51.7238,11.0715,-3.1489),(51.6344,11.0715,-3.1073),(51.5271,11.0715,-3.1131),(51.4653,11.0715,-3.1425),(51.4028,11.0715,-3.2125),(51.3750,11.0715,-3.2899),(51.3858,11.0715,-3.3574),(51.3948,11.0715,-3.3822),(51.4363,11.3459,-3.3670),(51.4470,11.3459,-3.3961),(51.4854,11.3459,-3.4482),(51.5679,11.3459,-3.4765),(51.6297,11.3459,-3.4670),(51.6863,11.3459,-3.4399),(51.7295,11.3459,-3.3921),(51.7469,11.3459,-3.3197),(51.7374,11.3459,-3.2577),(51.6934,11.3459,-3.1848),(51.6236,11.3459,-3.1523),(51.5397,11.3459,-3.1568),(51.4914,11.3459,-3.1798),(51.4427,11.3459,-3.2344),(51.4209,11.3459,-3.2949),(51.4293,11.3459,-3.3476),(51.4364,11.3459,-3.3671),(51.4195,11.4344,-3.3731),(51.4313,11.4344,-3.4056),(51.4741,11.4344,-3.4635),(51.5660,11.4344,-3.4950),(51.6348,11.4344,-3.4844),(51.6978,11.4344,-3.4543),(51.7459,11.4344,-3.4011),(51.7652,11.4344,-3.3204),(51.7547,11.4344,-3.2515),(51.7057,11.4344,-3.1702),(51.6280,11.4344,-3.1340),(51.5346,11.4344,-3.1391),(51.4808,11.4344,-3.1647),(51.4265,11.4344,-3.2255),(51.4023,11.4344,-3.2929),(51.4117,11.4344,-3.3516),(51.4196,11.4344,-3.3732),(51.4266,11.5009,-3.3705),(51.4379,11.5009,-3.4016),(51.4789,11.5009,-3.4571),(51.5668,11.5009,-3.4872),(51.6326,11.5009,-3.4771),(51.6930,11.5009,-3.4482),(51.7390,11.5009,-3.3973),(51.7575,11.5009,-3.3201),(51.7474,11.5009,-3.2541),(51.7006,11.5009,-3.1763),(51.6261,11.5009,-3.1417),(51.5367,11.5009,-3.1465),(51.4853,11.5009,-3.1710),(51.4333,11.5009,-3.2293),(51.4101,11.5009,-3.2937),(51.4191,11.5009,-3.3499),(51.4266,11.5009,-3.3706),(51.3983,11.4991,-3.3808),(51.4116,11.4991,-3.4174),(51.4599,11.4991,-3.4828),(51.5635,11.4991,-3.5184),(51.6412,11.4991,-3.5064),(51.7123,11.4991,-3.4724),(51.7665,11.4991,-3.4124),(51.7884,11.4991,-3.3214),(51.7765,11.4991,-3.2436),(51.7212,11.4991,-3.1519),(51.6335,11.4991,-3.1111),(51.5282,11.4991,-3.1168),(51.4675,11.4991,-3.1457),(51.4062,11.4991,-3.2143),(51.3789,11.4991,-3.2903),(51.3895,11.4991,-3.3565),(51.3984,11.4991,-3.3810),(51.4079,11.4984,-3.3773),(51.4205,11.4984,-3.4121),(51.4664,11.4984,-3.4741),(51.5646,11.4984,-3.5078),(51.6383,11.4984,-3.4965),(51.7057,11.4984,-3.4642),(51.7572,11.4984,-3.4073),(51.7779,11.4984,-3.3210),(51.7666,11.4984,-3.2471),(51.7142,11.4984,-3.1602),(51.6310,11.4984,-3.1215),(51.5311,11.4984,-3.1269),(51.4735,11.4984,-3.1542),(51.4154,11.4984,-3.2194),(51.3895,11.4984,-3.2915),(51.3995,11.4984,-3.3543),(51.4079,11.4984,-3.3775),(51.4071,11.4931,-3.3776),(51.4198,11.4931,-3.4125),(51.4659,11.4931,-3.4748),(51.5645,11.4931,-3.5086),(51.6385,11.4931,-3.4973),(51.7062,11.4931,-3.4648),(51.7579,11.4931,-3.4077),(51.7787,11.4931,-3.3210),(51.7674,11.4931,-3.2469),(51.7148,11.4931,-3.1596),(51.6312,11.4931,-3.1207),(51.5308,11.4931,-3.1261),(51.4730,11.4931,-3.1536),(51.4147,11.4931,-3.2190),(51.3887,11.4931,-3.2914),(51.3987,11.4931,-3.3545),(51.4072,11.4931,-3.3777),(51.4068,11.4904,-3.3777),(51.4195,11.4904,-3.4127),(51.4657,11.4904,-3.4751),(51.5645,11.4904,-3.5090),(51.6386,11.4904,-3.4976),(51.7064,11.4904,-3.4651),(51.7582,11.4904,-3.4078),(51.7791,11.4904,-3.3210),(51.7677,11.4904,-3.2468),(51.7150,11.4904,-3.1593),(51.6313,11.4904,-3.1203),(51.5307,11.4904,-3.1258),(51.4728,11.4904,-3.1533),(51.4144,11.4904,-3.2188),(51.3883,11.4904,-3.2914),(51.3984,11.4904,-3.3545),(51.4069,11.4904,-3.3778)])),
            appearance=Appearance(
              material=Material(diffuseColor=(.7,.596,.535),transparency=.75),
              texture=ImageTexture(url=["glass.jpg","https://www.web3d.org/x3d/content/examples/Basic/NURBS/glass.jpg"])))])])]),
    Transform(translation=(-51.5865,-10.2621,3.3253),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='LampFrameShape2',solid=False,uClosed=True,uDimension=2,uKnot=[0,0,1,1],uOrder=2,vClosed=True,vDimension=17,vKnot=[0,0,0,0,0.1875,0.2188,0.3125,0.3750,0.4375,0.5000,0.5625,0.6250,0.6875,0.7500,0.8125,0.8750,0.9375,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(51.5404,11.7648,-3.3291),(51.5404,11.6024,-3.3291),(51.5344,11.7648,-3.3126),(51.5344,11.6024,-3.3126),(51.5388,11.7648,-3.2892),(51.5388,11.6024,-3.2892),(51.5642,11.7648,-3.2719),(51.5642,11.6024,-3.2719),(51.5807,11.7648,-3.2671),(51.5807,11.6024,-3.2671),(51.6023,11.7648,-3.2725),(51.6023,11.6024,-3.2725),(51.6156,11.7648,-3.2827),(51.6156,11.6024,-3.2827),(51.6260,11.7648,-3.2983),(51.6260,11.6024,-3.2983),(51.6276,11.7648,-3.3156),(51.6276,11.6024,-3.3156),(51.6245,11.7648,-3.3333),(51.6245,11.6024,-3.3333),(51.6128,11.7648,-3.3474),(51.6128,11.6024,-3.3474),(51.5987,11.7648,-3.3570),(51.5987,11.6024,-3.3570),(51.5798,11.7648,-3.3594),(51.5798,11.6024,-3.3594),(51.5636,11.7648,-3.3555),(51.5636,11.6024,-3.3555),(51.5480,11.7648,-3.3446),(51.5480,11.6024,-3.3446),(51.5426,11.7648,-3.3346),(51.5426,11.6024,-3.3346),(51.5406,11.7648,-3.3291),(51.5406,11.6024,-3.3291)])),
            appearance=Appearance(DEF='metal',
              material=Material(diffuseColor=(.621,.470,.396)),
              texture=ImageTexture(url=["steel.jpg","https://www.web3d.org/x3d/content/examples/Basic/NURBS/steel.jpg"])))])])]),
    Transform(translation=(-51.5865,-10.2621,3.3253),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='LampCoverShape',solid=False,uClosed=True,uDimension=15,uKnot=[0,0,0,0,0.0938,0.2188,0.4063,0.4375,0.5000,0.5938,0.6563,0.6875,0.8438,0.8750,0.9375,1,1,1,1],uOrder=4,vClosed=True,vDimension=6,vKnot=[0,0,0,0,0.3333,0.6667,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(51.5865,11.6414,-3.3123),(51.5862,11.6414,-3.3117),(51.5853,11.6414,-3.3105),(51.5824,11.6414,-3.3098),(51.5804,11.6414,-3.3116),(51.5801,11.6414,-3.3135),(51.5803,11.6414,-3.3148),(51.5812,11.6414,-3.3160),(51.5824,11.6414,-3.3166),(51.5841,11.6414,-3.3168),(51.5856,11.6414,-3.3161),(51.5865,11.6414,-3.3146),(51.5867,11.6414,-3.3136),(51.5866,11.6414,-3.3127),(51.5865,11.6414,-3.3123),(51.5539,11.6392,-3.3242),(51.5560,11.6392,-3.3300),(51.5649,11.6392,-3.3420),(51.5932,11.6392,-3.3490),(51.6128,11.6392,-3.3315),(51.6153,11.6392,-3.3127),(51.6134,11.6392,-3.3004),(51.6043,11.6392,-3.2881),(51.5930,11.6392,-3.2831),(51.5766,11.6392,-3.2806),(51.5620,11.6392,-3.2873),(51.5537,11.6392,-3.3019),(51.5512,11.6392,-3.3120),(51.5525,11.6392,-3.3203),(51.5539,11.6392,-3.3242),(51.4928,11.6197,-3.3464),(51.4993,11.6197,-3.3642),(51.5267,11.6197,-3.4012),(51.6135,11.6197,-3.4225),(51.6737,11.6197,-3.3689),(51.6812,11.6197,-3.3113),(51.6756,11.6197,-3.2735),(51.6476,11.6197,-3.2358),(51.6128,11.6197,-3.2203),(51.5625,11.6197,-3.2127),(51.5177,11.6197,-3.2334),(51.4923,11.6197,-3.2780),(51.4845,11.6197,-3.3089),(51.4885,11.6197,-3.3346),(51.4929,11.6197,-3.3465),(51.4399,11.6067,-3.3657),(51.4502,11.6067,-3.3938),(51.4935,11.6067,-3.4525),(51.6311,11.6067,-3.4862),(51.7265,11.6067,-3.4013),(51.7383,11.6067,-3.3100),(51.7294,11.6067,-3.2502),(51.6851,11.6067,-3.1905),(51.6300,11.6067,-3.1660),(51.5502,11.6067,-3.1538),(51.4793,11.6067,-3.1866),(51.4391,11.6067,-3.2573),(51.4267,11.6067,-3.3063),(51.4331,11.6067,-3.3470),(51.4399,11.6067,-3.3658),(51.4216,11.5655,-3.3723),(51.4331,11.5655,-3.4041),(51.4820,11.5655,-3.4703),(51.6372,11.5655,-3.5082),(51.7448,11.5655,-3.4125),(51.7580,11.5655,-3.3095),(51.7481,11.5655,-3.2421),(51.6981,11.5655,-3.1748),(51.6360,11.5655,-3.1471),(51.5460,11.5655,-3.1334),(51.4660,11.5655,-3.1704),(51.4207,11.5655,-3.2501),(51.4066,11.5655,-3.3054),(51.4139,11.5655,-3.3513),(51.4216,11.5655,-3.3725),(51.3931,11.5417,-3.3827),(51.4067,11.5417,-3.4201),(51.4642,11.5417,-3.4979),(51.6467,11.5417,-3.5425),(51.7732,11.5417,-3.4300),(51.7888,11.5417,-3.3089),(51.7771,11.5417,-3.2295),(51.7183,11.5417,-3.1504),(51.6452,11.5417,-3.1178),(51.5394,11.5417,-3.1017),(51.4453,11.5417,-3.1452),(51.3920,11.5417,-3.2390),(51.3755,11.5417,-3.3039),(51.3841,11.5417,-3.3579),(51.3931,11.5417,-3.3829)])),
            appearance=Appearance(USE='metal'))])])]),
    Transform(translation=(-51.5865,-10.2621,3.3253),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='LampCircleShape1',solid=False,uClosed=True,uDimension=18,uKnot=[0,0,0,0,0.0625,0.1563,0.2500,0.3438,0.3750,0.4375,0.5000,0.5625,0.6250,0.7188,0.7813,0.8438,0.8750,0.9375,1,1,1,1],uOrder=4,vClosed=True,vDimension=13,vKnot=[0,0,0,0,0.3125,0.3438,0.4063,0.5000,0.5313,0.6875,0.7188,0.8125,0.8438,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(51.3317,11.2181,-3.4044),(51.3185,11.2180,-3.3677),(51.3051,11.1971,-3.2689),(51.3680,11.0860,-3.1118),(51.5306,10.8968,-2.9970),(51.6840,10.7508,-2.9848),(51.8029,10.6532,-3.0218),(51.8876,10.5939,-3.0786),(51.9513,10.5693,-3.1805),(51.9671,10.5944,-3.2986),(51.9271,10.6779,-3.4368),(51.8214,10.8126,-3.5461),(51.6778,10.9630,-3.5979),(51.5712,11.0610,-3.5961),(51.4721,11.1425,-3.5658),(51.3874,11.2017,-3.5087),(51.3449,11.2182,-3.4410),(51.3317,11.2181,-3.4043),(51.3406,11.2181,-3.4016),(51.3275,11.2181,-3.3654),(51.3141,11.1977,-3.2681),(51.3759,11.0883,-3.1132),(51.5360,10.9020,-2.9999),(51.6872,10.7580,-2.9877),(51.8044,10.6617,-3.0240),(51.8880,10.6031,-3.0798),(51.9509,10.5787,-3.1802),(51.9667,10.6033,-3.2966),(51.9275,10.6854,-3.4327),(51.8235,10.8180,-3.5406),(51.6820,10.9663,-3.5919),(51.5769,11.0630,-3.5902),(51.4792,11.1434,-3.5605),(51.3956,11.2018,-3.5044),(51.3537,11.2182,-3.4377),(51.3406,11.2182,-3.4015),(51.3505,11.2081,-3.3990),(51.3377,11.2082,-3.3640),(51.3244,11.1888,-3.2698),(51.3837,11.0833,-3.1197),(51.5384,10.9030,-3.0095),(51.6847,10.7635,-2.9973),(51.7984,10.6700,-3.0321),(51.8795,10.6130,-3.0859),(51.9408,10.5889,-3.1828),(51.9565,10.6124,-3.2955),(51.9189,10.6916,-3.4274),(51.8186,10.8197,-3.5321),(51.6818,10.9632,-3.5822),(51.5800,11.0570,-3.5809),(51.4853,11.1351,-3.5524),(51.4041,11.1920,-3.4983),(51.3633,11.2080,-3.4339),(51.3504,11.2081,-3.3989),(51.3427,11.1950,-3.4020),(51.3300,11.1951,-3.3673),(51.3167,11.1759,-3.2739),(51.3755,11.0713,-3.1248),(51.5289,10.8924,-3.0154),(51.6741,10.7539,-3.0031),(51.7870,10.6610,-3.0376),(51.8676,10.6044,-3.0909),(51.9284,10.5805,-3.1871),(51.9441,10.6036,-3.2989),(51.9070,10.6821,-3.4298),(51.8074,10.8093,-3.5339),(51.6717,10.9517,-3.5836),(51.5706,11.0448,-3.5824),(51.4766,11.1223,-3.5542),(51.3960,11.1789,-3.5006),(51.3554,11.1949,-3.4366),(51.3427,11.1950,-3.4020),(51.3395,11.1915,-3.4032),(51.3267,11.1916,-3.3685),(51.3135,11.1724,-3.2750),(51.3722,11.0678,-3.1260),(51.5257,10.8889,-3.0166),(51.6709,10.7504,-3.0043),(51.7837,10.6575,-3.0387),(51.8643,10.6009,-3.0921),(51.9252,10.5770,-3.1883),(51.9408,10.6001,-3.3001),(51.9037,10.6786,-3.4310),(51.8042,10.8058,-3.5350),(51.6684,10.9482,-3.5848),(51.5674,11.0413,-3.5836),(51.4734,11.1188,-3.5554),(51.3928,11.1754,-3.5018),(51.3522,11.1914,-3.4378),(51.3394,11.1915,-3.4032),(51.3333,11.1889,-3.4052),(51.3205,11.1890,-3.3703),(51.3073,11.1696,-3.2762),(51.3665,11.0642,-3.1263),(51.5210,10.8842,-3.0162),(51.6672,10.7448,-3.0039),(51.7807,10.6513,-3.0387),(51.8618,10.5944,-3.0924),(51.9230,10.5704,-3.1893),(51.9387,10.5938,-3.3018),(51.9012,10.6729,-3.4336),(51.8010,10.8009,-3.5382),(51.6643,10.9443,-3.5883),(51.5626,11.0379,-3.5870),(51.4680,11.1159,-3.5585),(51.3869,11.1728,-3.5045),(51.3461,11.1888,-3.4401),(51.3333,11.1889,-3.4052),(51.3262,11.1906,-3.4074),(51.3132,11.1906,-3.3720),(51.2999,11.1707,-3.2764),(51.3603,11.0636,-3.1243),(51.5172,10.8808,-3.0128),(51.6656,10.7394,-3.0006),(51.7808,10.6447,-3.0360),(51.8629,10.5870,-3.0907),(51.9249,10.5628,-3.1890),(51.9406,10.5868,-3.3033),(51.9024,10.6672,-3.4370),(51.8005,10.7972,-3.5430),(51.6617,10.9427,-3.5936),(51.5585,11.0377,-3.5922),(51.4626,11.1168,-3.5631),(51.3804,11.1743,-3.5082),(51.3391,11.1905,-3.4428),(51.3261,11.1906,-3.4074),(51.3193,11.1936,-3.4094),(51.3062,11.1936,-3.3734),(51.2929,11.1732,-3.2762),(51.3545,11.0641,-3.1217),(51.5142,10.8783,-3.0086),(51.6650,10.7346,-2.9964),(51.7819,10.6385,-3.0326),(51.8654,10.5800,-3.0883),(51.9282,10.5556,-3.1884),(51.9439,10.5802,-3.3045),(51.9048,10.6621,-3.4404),(51.8011,10.7944,-3.5480),(51.6600,10.9422,-3.5992),(51.5551,11.0387,-3.5976),(51.4576,11.1190,-3.5679),(51.3742,11.1773,-3.5119),(51.3324,11.1937,-3.4454),(51.3193,11.1936,-3.4094),(51.3183,11.2031,-3.4093),(51.3050,11.2030,-3.3726),(51.2916,11.1822,-3.2739),(51.3545,11.0711,-3.1169),(51.5170,10.8821,-3.0022),(51.6702,10.7361,-2.9900),(51.7891,10.6386,-3.0269),(51.8738,10.5793,-3.0837),(51.9374,10.5547,-3.1855),(51.9532,10.5798,-3.3036),(51.9133,10.6633,-3.4416),(51.8077,10.7978,-3.5509),(51.6642,10.9482,-3.6027),(51.5576,11.0462,-3.6009),(51.4586,11.1276,-3.5706),(51.3739,11.1868,-3.5136),(51.3315,11.2032,-3.4459),(51.3182,11.2032,-3.4092),(51.3179,11.2071,-3.4092),(51.3046,11.2070,-3.3723),(51.2911,11.1860,-3.2729),(51.3546,11.0740,-3.1149),(51.5182,10.8837,-2.9995),(51.6725,10.7368,-2.9873),(51.7921,10.6387,-3.0246),(51.8773,10.5791,-3.0818),(51.9413,10.5544,-3.1843),(51.9571,10.5797,-3.3032),(51.9168,10.6639,-3.4421),(51.8105,10.7993,-3.5521),(51.6659,10.9507,-3.6042),(51.5587,11.0493,-3.6023),(51.4590,11.1312,-3.5717),(51.3738,11.1907,-3.5143),(51.3312,11.2073,-3.4461),(51.3178,11.2072,-3.4092),(51.3225,11.2154,-3.4074),(51.3091,11.2153,-3.3703),(51.2957,11.1941,-3.2703),(51.3595,11.0815,-3.1116),(51.5240,10.8902,-2.9957),(51.6791,10.7426,-2.9835),(51.7993,10.6440,-3.0210),(51.8849,10.5841,-3.0785),(51.9491,10.5594,-3.1816),(51.9650,10.5850,-3.3011),(51.9244,10.6696,-3.4407),(51.8175,10.8058,-3.5512),(51.6722,10.9578,-3.6035),(51.5644,11.0570,-3.6015),(51.4642,11.1393,-3.5707),(51.3786,11.1991,-3.5130),(51.3358,11.2156,-3.4444),(51.3224,11.2155,-3.4073),(51.3264,11.2174,-3.4060),(51.3131,11.2173,-3.3691),(51.2997,11.1962,-3.2695),(51.3632,11.0841,-3.1113),(51.5271,10.8934,-2.9957),(51.6817,10.7463,-2.9835),(51.8014,10.6480,-3.0209),(51.8868,10.5883,-3.0782),(51.9509,10.5636,-3.1809),(51.9667,10.5890,-3.3000),(51.9263,10.6733,-3.4391),(51.8198,10.8090,-3.5492),(51.6750,10.9606,-3.6014),(51.5676,11.0594,-3.5995),(51.4677,11.1414,-3.5688),(51.3824,11.2010,-3.5113),(51.3397,11.2176,-3.4430),(51.3264,11.2174,-3.4060),(51.3313,11.2178,-3.4045),(51.3181,11.2177,-3.3678),(51.3047,11.1968,-3.2690),(51.3676,11.0856,-3.1119),(51.5302,10.8964,-2.9971),(51.6836,10.7503,-2.9849),(51.8026,10.6527,-3.0219),(51.8873,10.5934,-3.0787),(51.9510,10.5688,-3.1806),(51.9668,10.5940,-3.2988),(51.9268,10.6775,-3.4369),(51.8211,10.8122,-3.5463),(51.6775,10.9626,-3.5981),(51.5709,11.0607,-3.5963),(51.4717,11.1422,-3.5660),(51.3870,11.2014,-3.5089),(51.3445,11.2179,-3.4412),(51.3313,11.2178,-3.4045)])),
            appearance=Appearance(USE='metal'))])])]),
    Transform(translation=(-51.5865,-10.2621,3.3253),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='LampCircleShape2',solid=False,uClosed=True,uDimension=18,uKnot=[0,0,0,0,0.0625,0.1563,0.2500,0.3438,0.3750,0.4375,0.5000,0.5625,0.6250,0.7188,0.7813,0.8438,0.8750,0.9375,1,1,1,1],uOrder=4,vClosed=True,vDimension=13,vKnot=[0,0,0,0,0.3125,0.3438,0.4063,0.5000,0.5313,0.6875,0.7188,0.8125,0.8438,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(51.2312,10.5812,-3.4410),(51.2187,10.5813,-3.4065),(51.2070,10.6025,-3.3131),(51.2708,10.7154,-3.1636),(51.4318,10.9074,-3.0527),(51.5822,11.0557,-3.0390),(51.6982,11.1548,-3.0723),(51.7804,11.2150,-3.1249),(51.8414,11.2400,-3.2204),(51.8553,11.2144,-3.3320),(51.8142,11.1296,-3.4633),(51.7091,10.9929,-3.5683),(51.5676,10.8402,-3.6194),(51.4632,10.7407,-3.6192),(51.3665,10.6579,-3.5918),(51.2843,10.5978,-3.5390),(51.2436,10.5811,-3.4755),(51.2312,10.5812,-3.4410),(51.2313,10.5905,-3.4414),(51.2190,10.5906,-3.4074),(51.2072,10.6113,-3.3154),(51.2699,10.7223,-3.1679),(51.4284,10.9115,-3.0585),(51.5767,11.0577,-3.0448),(51.6910,11.1555,-3.0775),(51.7722,11.2149,-3.1292),(51.8324,11.2398,-3.2233),(51.8462,11.2148,-3.3332),(51.8059,11.1314,-3.4627),(51.7025,10.9967,-3.5662),(51.5632,10.8463,-3.6168),(51.4602,10.7481,-3.6167),(51.3649,10.6664,-3.5898),(51.2838,10.6071,-3.5379),(51.2436,10.5905,-3.4754),(51.2313,10.5905,-3.4413),(51.2410,10.6007,-3.4388),(51.2289,10.6006,-3.4059),(51.2172,10.6204,-3.3169),(51.2775,10.7275,-3.1740),(51.4306,10.9104,-3.0675),(51.5741,11.0522,-3.0539),(51.6850,11.1471,-3.0852),(51.7638,11.2049,-3.1350),(51.8225,11.2293,-3.2259),(51.8362,11.2055,-3.3323),(51.7976,11.1251,-3.4577),(51.6978,10.9950,-3.5583),(51.5630,10.8493,-3.6076),(51.4633,10.7541,-3.6078),(51.3709,10.6749,-3.5821),(51.2922,10.6171,-3.5321),(51.2530,10.6008,-3.4716),(51.2410,10.6007,-3.4387),(51.2534,10.5924,-3.4345),(51.2414,10.5922,-3.4018),(51.2297,10.6117,-3.3135),(51.2894,10.7179,-3.1716),(51.4413,10.8995,-3.0659),(51.5837,11.0402,-3.0522),(51.6938,11.1345,-3.0833),(51.7720,11.1919,-3.1327),(51.8304,11.2163,-3.2228),(51.8441,11.1927,-3.3284),(51.8059,11.1130,-3.4529),(51.7069,10.9840,-3.5528),(51.5732,10.8393,-3.6018),(51.4742,10.7448,-3.6021),(51.3825,10.6661,-3.5766),(51.3043,10.6087,-3.5270),(51.2654,10.5925,-3.4671),(51.2534,10.5923,-3.4344),(51.2567,10.5889,-3.4333),(51.2447,10.5888,-3.4006),(51.2330,10.6083,-3.3123),(51.2927,10.7145,-3.1704),(51.4445,10.8961,-3.0647),(51.5870,11.0368,-3.0510),(51.6971,11.1310,-3.0821),(51.7753,11.1885,-3.1315),(51.8336,11.2128,-3.2216),(51.8474,11.1893,-3.3272),(51.8092,11.1096,-3.4517),(51.7102,10.9805,-3.5516),(51.5765,10.8359,-3.6006),(51.4775,10.7414,-3.6009),(51.3858,10.6627,-3.5754),(51.3076,10.6053,-3.5258),(51.2687,10.5890,-3.4659),(51.2567,10.5889,-3.4332),(51.2591,10.5824,-3.4322),(51.2470,10.5823,-3.3994),(51.2353,10.6020,-3.3105),(51.2955,10.7090,-3.1677),(51.4484,10.8918,-3.0614),(51.5918,11.0334,-3.0477),(51.7026,11.1282,-3.0790),(51.7812,11.1860,-3.1288),(51.8399,11.2104,-3.2196),(51.8536,11.1866,-3.3259),(51.8151,11.1064,-3.4511),(51.7154,10.9764,-3.5516),(51.5808,10.8308,-3.6008),(51.4812,10.7357,-3.6010),(51.3888,10.6565,-3.5754),(51.3102,10.5988,-3.5254),(51.2711,10.5825,-3.4650),(51.2590,10.5824,-3.4322),(51.2574,10.5750,-3.4324),(51.2452,10.5749,-3.3990),(51.2335,10.5951,-3.3088),(51.2948,10.7038,-3.1640),(51.4501,10.8894,-3.0563),(51.5957,11.0331,-3.0426),(51.7080,11.1292,-3.0745),(51.7878,11.1877,-3.1251),(51.8471,11.2123,-3.2174),(51.8609,11.1880,-3.3253),(51.8216,11.1063,-3.4524),(51.7203,10.9743,-3.5542),(51.5836,10.8266,-3.6040),(51.4825,10.7301,-3.6041),(51.3888,10.6499,-3.5779),(51.3091,10.5914,-3.5271),(51.2695,10.5750,-3.4657),(51.2573,10.5749,-3.4324),(51.2544,10.5678,-3.4330),(51.2421,10.5679,-3.3991),(51.2303,10.5885,-3.3074),(51.2929,10.6993,-3.1602),(51.4509,10.8880,-3.0510),(51.5988,11.0339,-3.0373),(51.7130,11.1314,-3.0699),(51.7939,11.1908,-3.1215),(51.8540,11.2156,-3.2153),(51.8679,11.1906,-3.3250),(51.8277,11.1075,-3.4542),(51.7245,10.9732,-3.5575),(51.5855,10.8230,-3.6079),(51.4828,10.7251,-3.6079),(51.3877,10.6436,-3.5811),(51.3068,10.5844,-3.5293),(51.2667,10.5678,-3.4669),(51.2543,10.5678,-3.4330),(51.2453,10.5669,-3.4359),(51.2328,10.5670,-3.4014),(51.2211,10.5882,-3.3081),(51.2849,10.7009,-3.1586),(51.4457,10.8928,-3.0478),(51.5960,11.0410,-3.0341),(51.7120,11.1401,-3.0674),(51.7941,11.2002,-3.1199),(51.8551,11.2252,-3.2154),(51.8689,11.1997,-3.3270),(51.8279,11.1150,-3.4582),(51.7229,10.9784,-3.5631),(51.5815,10.8258,-3.6141),(51.4771,10.7263,-3.6139),(51.3805,10.6436,-3.5866),(51.2983,10.5835,-3.5338),(51.2577,10.5668,-3.4704),(51.2452,10.5669,-3.4359),(51.2415,10.5666,-3.4371),(51.2289,10.5667,-3.4023),(51.2172,10.5881,-3.3084),(51.2815,10.7017,-3.1580),(51.4435,10.8949,-3.0465),(51.5948,11.0441,-3.0328),(51.7115,11.1437,-3.0664),(51.7942,11.2042,-3.1193),(51.8555,11.2293,-3.2155),(51.8693,11.2035,-3.3278),(51.8279,11.1181,-3.4599),(51.7221,10.9806,-3.5654),(51.5798,10.8269,-3.6167),(51.4747,10.7268,-3.6165),(51.3775,10.6436,-3.5889),(51.2948,10.5832,-3.5357),(51.2539,10.5664,-3.4718),(51.2414,10.5665,-3.4371),(51.2336,10.5715,-3.4398),(51.2210,10.5716,-3.4049),(51.2092,10.5932,-3.3105),(51.2740,10.7075,-3.1593),(51.4368,10.9017,-3.0473),(51.5889,11.0516,-3.0336),(51.7062,11.1517,-3.0674),(51.7892,11.2124,-3.1207),(51.8508,11.2376,-3.2174),(51.8647,11.2116,-3.3302),(51.8229,11.1257,-3.4630),(51.7166,10.9874,-3.5690),(51.5735,10.8330,-3.6205),(51.4679,10.7324,-3.6202),(51.3702,10.6488,-3.5924),(51.2871,10.5882,-3.5390),(51.2461,10.5713,-3.4747),(51.2335,10.5715,-3.4398),(51.2318,10.5757,-3.4405),(51.2192,10.5758,-3.4057),(51.2075,10.5972,-3.3117),(51.2719,10.7110,-3.1610),(51.4342,10.9046,-3.0494),(51.5858,11.0540,-3.0356),(51.7026,11.1538,-3.0693),(51.7854,11.2144,-3.1224),(51.8468,11.2394,-3.2187),(51.8607,11.2136,-3.3312),(51.8191,11.1281,-3.4635),(51.7132,10.9903,-3.5692),(51.5706,10.8364,-3.6206),(51.4654,10.7361,-3.6203),(51.3680,10.6528,-3.5926),(51.2852,10.5923,-3.5394),(51.2443,10.5755,-3.4753),(51.2317,10.5756,-3.4405),(51.2315,10.5808,-3.4409),(51.2190,10.5809,-3.4063),(51.2072,10.6021,-3.3130),(51.2711,10.7150,-3.1634),(51.4321,10.9071,-3.0525),(51.5826,11.0554,-3.0388),(51.6986,11.1545,-3.0721),(51.7808,11.2147,-3.1247),(51.8418,11.2397,-3.2203),(51.8557,11.2141,-3.3319),(51.8146,11.1293,-3.4632),(51.7095,10.9926,-3.5682),(51.5680,10.8399,-3.6193),(51.4635,10.7403,-3.6191),(51.3668,10.6575,-3.5917),(51.2846,10.5974,-3.5389),(51.2439,10.5807,-3.4754),(51.2314,10.5808,-3.4409)])),
            appearance=Appearance(USE='metal'))])])]),
    Transform(translation=(-51.5865,-10.2621,3.3253),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='LampBaseShape',solid=False,uClosed=True,uDimension=17,uKnot=[0,0,0,0,0.0625,0.1563,0.2500,0.3438,0.3750,0.4375,0.5000,0.5625,0.6250,0.7188,0.7813,0.8438,0.9063,1,1,1,1],uOrder=4,vClosed=True,vDimension=9,vKnot=[0,0,0,0,0.1667,0.3333,0.5000,0.6667,0.8333,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.5844,10.4651,-3.3131),(51.4114,10.4651,-3.3760),(51.4196,10.4651,-3.3987),(51.4514,10.4651,-3.4512),(51.5380,10.4651,-3.5028),(51.6513,10.4651,-3.4962),(51.7216,10.4651,-3.4438),(51.7585,10.4651,-3.3809),(51.7733,10.4651,-3.3214),(51.7619,10.4651,-3.2483),(51.7238,10.4651,-3.1855),(51.6543,10.4651,-3.1344),(51.5675,10.4651,-3.1220),(51.4862,10.4651,-3.1516),(51.4322,10.4651,-3.2012),(51.3955,10.4651,-3.2794),(51.3991,10.4651,-3.3420),(51.4114,10.4651,-3.3760),(51.3117,10.4629,-3.4123),(51.3247,10.4629,-3.4480),(51.3747,10.4629,-3.5309),(51.5113,10.4629,-3.6122),(51.6898,10.4629,-3.6017),(51.8007,10.4629,-3.5192),(51.8589,10.4629,-3.4200),(51.8822,10.4629,-3.3263),(51.8642,10.4629,-3.2110),(51.8042,10.4629,-3.1120),(51.6945,10.4629,-3.0314),(51.5577,10.4629,-3.0118),(51.4296,10.4629,-3.0585),(51.3445,10.4629,-3.1368),(51.2865,10.4629,-3.2600),(51.2922,10.4629,-3.3587),(51.3116,10.4629,-3.4123),(51.2465,10.4304,-3.4360),(51.2626,10.4304,-3.4803),(51.3247,10.4304,-3.5829),(51.4938,10.4304,-3.6836),(51.7149,10.4304,-3.6707),(51.8523,10.4304,-3.5684),(51.9244,10.4304,-3.4455),(51.9532,10.4304,-3.3294),(51.9310,10.4304,-3.1866),(51.8567,10.4304,-3.0640),(51.7208,10.4304,-2.9641),(51.5513,10.4304,-2.9399),(51.3927,10.4304,-2.9978),(51.2872,10.4304,-3.0947),(51.2154,10.4304,-3.2473),(51.2224,10.4304,-3.3695),(51.2465,10.4304,-3.4359),(51.2465,10.3330,-3.4360),(51.2626,10.3330,-3.4803),(51.3247,10.3330,-3.5829),(51.4938,10.3330,-3.6836),(51.7149,10.3330,-3.6707),(51.8523,10.3330,-3.5684),(51.9244,10.3330,-3.4455),(51.9532,10.3330,-3.3294),(51.9310,10.3330,-3.1866),(51.8567,10.3330,-3.0640),(51.7208,10.3330,-2.9641),(51.5513,10.3330,-2.9399),(51.3927,10.3330,-2.9978),(51.2872,10.3330,-3.0947),(51.2154,10.3330,-3.2473),(51.2224,10.3330,-3.3695),(51.2465,10.3330,-3.4359),(51.2486,10.2506,-3.4353),(51.2646,10.2506,-3.4793),(51.3262,10.2506,-3.5813),(51.4943,10.2506,-3.6814),(51.7141,10.2506,-3.6685),(51.8507,10.2506,-3.5669),(51.9224,10.2506,-3.4447),(51.9510,10.2506,-3.3293),(51.9289,10.2506,-3.1874),(51.8550,10.2506,-3.0655),(51.7200,10.2506,-2.9662),(51.5515,10.2506,-2.9422),(51.3938,10.2506,-2.9997),(51.2890,10.2506,-3.0960),(51.2176,10.2506,-3.2477),(51.2246,10.2506,-3.3692),(51.2485,10.2506,-3.4352),(51.2262,10.2052,-3.4435),(51.2432,10.2052,-3.4904),(51.3090,10.2052,-3.5992),(51.4883,10.2052,-3.7059),(51.7228,10.2052,-3.6922),(51.8685,10.2052,-3.5838),(51.9449,10.2052,-3.4535),(51.9755,10.2052,-3.3304),(51.9519,10.2052,-3.1790),(51.8731,10.2052,-3.0490),(51.7290,10.2052,-2.9431),(51.5493,10.2052,-2.9174),(51.3811,10.2052,-2.9788),(51.2693,10.2052,-3.0815),(51.1932,10.2052,-3.2434),(51.2006,10.2052,-3.3729),(51.2261,10.2052,-3.4433),(51.1468,10.1770,-3.4723),(51.1676,10.1770,-3.5296),(51.2480,10.1770,-3.6626),(51.4670,10.1770,-3.7930),(51.7535,10.1770,-3.7762),(51.9314,10.1770,-3.6438),(52.0248,10.1770,-3.4846),(52.0621,10.1770,-3.3342),(52.0333,10.1770,-3.1493),(51.9370,10.1770,-2.9905),(51.7611,10.1770,-2.8611),(51.5415,10.1770,-2.8298),(51.3360,10.1770,-2.9047),(51.1995,10.1770,-3.0302),(51.1065,10.1770,-3.2279),(51.1155,10.1770,-3.3862),(51.1468,10.1770,-3.4722),(51.1447,10.1575,-3.4731),(51.1657,10.1575,-3.5306),(51.2464,10.1575,-3.6642),(51.4665,10.1575,-3.7952),(51.7542,10.1575,-3.7784),(51.9330,10.1575,-3.6453),(52.0269,10.1575,-3.4854),(52.0643,10.1575,-3.3343),(52.0354,10.1575,-3.1485),(51.9387,10.1575,-2.9890),(51.7619,10.1575,-2.8590),(51.5413,10.1575,-2.8275),(51.3349,10.1575,-2.9028),(51.1977,10.1575,-3.0289),(51.1042,10.1575,-3.2275),(51.1134,10.1575,-3.3866),(51.1447,10.1575,-3.4730)])),
            appearance=Appearance(USE='metal'))])])]),
    Transform(translation=(-51.5865,-10.2621,3.3253),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='LampFrameShape3',solid=False,uClosed=True,uDimension=2,uKnot=[0,0,1,1],uOrder=2,vClosed=True,vDimension=16,vKnot=[0,0,0,0,0.1250,0.2500,0.2813,0.3438,0.5313,0.5625,0.6875,0.7188,0.8125,0.8750,0.9375,0.9688,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(51.6999,10.6008,-3.2710),(51.6999,10.4565,-3.2710),(51.6887,10.6008,-3.2403),(51.6887,10.4565,-3.2403),(51.6421,10.6008,-3.1876),(51.6421,10.4565,-3.1876),(51.5602,10.6008,-3.1853),(51.5602,10.4565,-3.1853),(51.5100,10.6008,-3.2097),(51.5100,10.4565,-3.2097),(51.4535,10.6008,-3.2606),(51.4535,10.4565,-3.2606),(51.4489,10.6008,-3.3454),(51.4489,10.4565,-3.3454),(51.5050,10.6008,-3.4188),(51.5050,10.4565,-3.4188),(51.5509,10.6008,-3.4411),(51.5509,10.4565,-3.4411),(51.6185,10.6008,-3.4371),(51.6185,10.4565,-3.4371),(51.6634,10.6008,-3.4156),(51.6634,10.4565,-3.4156),(51.6993,10.6008,-3.3676),(51.6993,10.4565,-3.3676),(51.7082,10.6008,-3.3277),(51.7082,10.4565,-3.3277),(51.7068,10.6008,-3.2946),(51.7068,10.4565,-3.2946),(51.7027,10.6008,-3.2787),(51.7027,10.4565,-3.2787),(51.6999,10.6008,-3.2710),(51.6999,10.4565,-3.2710)])),
            appearance=Appearance(USE='metal'))])])]),
    Transform(translation=(-51.5865,-10.2621,3.3253),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='LampHandleShape',solid=False,uClosed=True,uDimension=24,uKnot=[0,0,0,0,0.0476,0.0952,0.1429,0.1905,0.2381,0.2857,0.3333,0.3810,0.4286,0.4762,0.5238,0.5714,0.6190,0.6667,0.7143,0.7619,0.8095,0.8571,0.9048,0.9524,1,1,1,1],uOrder=4,vClosed=True,vDimension=9,vKnot=[0,0,0,0,0.2813,0.3125,0.4063,0.4375,0.9688,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(51.1791,11.6617,-3.4606),(51.1776,11.7001,-3.4611),(51.1930,11.7508,-3.4555),(51.2248,11.7606,-3.4440),(51.2564,11.7729,-3.4325),(51.2587,11.7955,-3.4316),(51.1761,11.9499,-3.4617),(51.1414,12.0203,-3.4743),(51.1349,12.1922,-3.4767),(51.1571,12.3660,-3.4686),(51.3097,12.5466,-3.4130),(51.5016,12.6188,-3.3432),(51.6604,12.6188,-3.2854),(51.8644,12.5483,-3.2111),(51.9979,12.3675,-3.1626),(52.0298,12.1924,-3.1509),(52.0101,12.0177,-3.1581),(51.9599,11.9489,-3.1764),(51.8992,11.8016,-3.1985),(51.8996,11.7796,-3.1984),(51.9270,11.7681,-3.1884),(51.9714,11.7482,-3.1722),(51.9805,11.7209,-3.1689),(51.9844,11.6802,-3.1675),(51.1762,11.6617,-3.4527),(51.1747,11.7001,-3.4532),(51.1901,11.7508,-3.4476),(51.2219,11.7606,-3.4361),(51.2535,11.7729,-3.4246),(51.2558,11.7955,-3.4237),(51.1732,11.9499,-3.4538),(51.1385,12.0203,-3.4664),(51.1320,12.1922,-3.4688),(51.1543,12.3660,-3.4607),(51.3069,12.5466,-3.4051),(51.4987,12.6188,-3.3353),(51.6575,12.6188,-3.2775),(51.8616,12.5483,-3.2032),(51.9950,12.3675,-3.1547),(52.0269,12.1924,-3.1430),(52.0072,12.0177,-3.1502),(51.9571,11.9489,-3.1685),(51.8964,11.8016,-3.1906),(51.8967,11.7796,-3.1904),(51.9241,11.7681,-3.1805),(51.9686,11.7482,-3.1643),(51.9776,11.7209,-3.1610),(51.9815,11.6802,-3.1596),(51.1652,11.6614,-3.4467),(51.1638,11.7014,-3.4473),(51.1815,11.7567,-3.4408),(51.2164,11.7685,-3.4281),(51.2441,11.7779,-3.4180),(51.2451,11.7934,-3.4177),(51.1631,11.9460,-3.4475),(51.1278,12.0182,-3.4604),(51.1211,12.1926,-3.4628),(51.1440,12.3695,-3.4545),(51.2993,12.5535,-3.3979),(51.4942,12.6270,-3.3270),(51.6555,12.6270,-3.2683),(51.8628,12.5551,-3.1928),(51.9989,12.3710,-3.1433),(52.0315,12.1927,-3.1314),(52.0112,12.0145,-3.1388),(51.9606,11.9447,-3.1572),(51.9007,11.7994,-3.1791),(51.9000,11.7841,-3.1793),(51.9235,11.7759,-3.1707),(51.9710,11.7539,-3.1535),(51.9820,11.7229,-3.1494),(51.9860,11.6811,-3.1480),(51.1543,11.6609,-3.4564),(51.1530,11.7034,-3.4568),(51.1743,11.7664,-3.4491),(51.2145,11.7815,-3.4344),(51.2357,11.7862,-3.4267),(51.2345,11.7899,-3.4271),(51.1537,11.9394,-3.4565),(51.1172,12.0147,-3.4698),(51.1101,12.1933,-3.4724),(51.1342,12.3752,-3.4636),(51.2940,12.5648,-3.4055),(51.4938,12.6404,-3.3328),(51.6594,12.6404,-3.2725),(51.8720,12.5662,-3.1951),(52.0123,12.3767,-3.1440),(52.0461,12.1932,-3.1318),(52.0249,12.0094,-3.1395),(51.9734,11.9377,-3.1582),(51.9148,11.7956,-3.1796),(51.9125,11.7916,-3.1804),(51.9296,11.7887,-3.1742),(51.9820,11.7633,-3.1551),(51.9962,11.7261,-3.1499),(52.0005,11.6825,-3.1483),(51.1522,11.6608,-3.4596),(51.1509,11.7039,-3.4601),(51.1731,11.7686,-3.4520),(51.2145,11.7844,-3.4370),(51.2343,11.7880,-3.4298),(51.2326,11.7891,-3.4304),(51.1520,11.9380,-3.4597),(51.1153,12.0139,-3.4731),(51.1081,12.1934,-3.4757),(51.1324,12.3765,-3.4668),(51.2932,12.5674,-3.4083),(51.4941,12.6434,-3.3352),(51.6606,12.6434,-3.2746),(51.8744,12.5687,-3.1968),(52.0158,12.3779,-3.1453),(52.0498,12.1933,-3.1330),(52.0284,12.0082,-3.1408),(51.9767,11.9362,-3.1596),(51.9183,11.7948,-3.1808),(51.9157,11.7933,-3.1818),(51.9314,11.7916,-3.1761),(51.9849,11.7654,-3.1566),(51.9998,11.7268,-3.1511),(52.0042,11.6828,-3.1495),(51.1484,11.6604,-3.4815),(51.1472,11.7055,-3.4819),(51.1724,11.7765,-3.4727),(51.2180,11.7950,-3.4561),(51.2326,11.7947,-3.4508),(51.2291,11.7863,-3.4521),(51.1495,11.9327,-3.4811),(51.1118,12.0111,-3.4948),(51.1043,12.1939,-3.4976),(51.1296,12.3812,-3.4883),(51.2940,12.5766,-3.4285),(51.4990,12.6543,-3.3539),(51.6688,12.6544,-3.2921),(51.8869,12.5778,-3.2127),(52.0318,12.3825,-3.1600),(52.0667,12.1937,-3.1472),(52.0445,12.0040,-3.1553),(51.9922,11.9306,-3.1744),(51.9349,11.7918,-3.1952),(51.9309,11.7994,-3.1967),(51.9414,11.8020,-3.1929),(51.9990,11.7731,-3.1719),(52.0165,11.7294,-3.1655),(52.0211,11.6839,-3.1638),(51.1848,11.6616,-3.4839),(51.1833,11.7005,-3.4844),(51.1994,11.7527,-3.4785),(51.2322,11.7631,-3.4666),(51.2626,11.7745,-3.4555),(51.2644,11.7948,-3.4549),(51.1820,11.9487,-3.4849),(51.1471,12.0197,-3.4976),(51.1406,12.1923,-3.4999),(51.1630,12.3671,-3.4918),(51.3165,12.5488,-3.4359),(51.5093,12.6214,-3.3657),(51.6689,12.6214,-3.3076),(51.8740,12.5504,-3.2330),(52.0083,12.3686,-3.1841),(52.0404,12.1925,-3.1724),(52.0205,12.0167,-3.1797),(51.9702,11.9476,-3.1980),(51.9098,11.8009,-3.2200),(51.9098,11.7810,-3.2200),(51.9360,11.7706,-3.2104),(51.9814,11.7500,-3.1939),(51.9911,11.7215,-3.1904),(51.9949,11.6805,-3.1890),(51.1795,11.6617,-3.4618),(51.1779,11.7001,-3.4623),(51.1934,11.7509,-3.4567),(51.2252,11.7606,-3.4451),(51.2568,11.7729,-3.4336),(51.2590,11.7955,-3.4328),(51.1764,11.9499,-3.4629),(51.1418,12.0203,-3.4755),(51.1353,12.1922,-3.4779),(51.1575,12.3660,-3.4698),(51.3101,12.5467,-3.4142),(51.5020,12.6189,-3.3444),(51.6608,12.6189,-3.2866),(51.8649,12.5483,-3.2123),(51.9984,12.3676,-3.1637),(52.0303,12.1924,-3.1521),(52.0106,12.0177,-3.1593),(51.9604,11.9489,-3.1775),(51.8997,11.8016,-3.1996),(51.9000,11.7796,-3.1995),(51.9274,11.7681,-3.1895),(51.9719,11.7482,-3.1734),(51.9810,11.7209,-3.1701),(51.9848,11.6802,-3.1687),(51.1791,11.6617,-3.4608),(51.1776,11.7001,-3.4613),(51.1931,11.7508,-3.4557),(51.2248,11.7606,-3.4441),(51.2564,11.7729,-3.4326),(51.2587,11.7955,-3.4318),(51.1761,11.9499,-3.4618),(51.1414,12.0203,-3.4745),(51.1349,12.1922,-3.4768),(51.1572,12.3660,-3.4687),(51.3098,12.5467,-3.4132),(51.5016,12.6189,-3.3434),(51.6605,12.6188,-3.2856),(51.8645,12.5483,-3.2113),(51.9980,12.3676,-3.1627),(52.0299,12.1924,-3.1511),(52.0102,12.0177,-3.1583),(51.9600,11.9489,-3.1765),(51.8993,11.8016,-3.1986),(51.8996,11.7796,-3.1985),(51.9271,11.7681,-3.1885),(51.9715,11.7482,-3.1723),(51.9806,11.7209,-3.1690),(51.9844,11.6802,-3.1676)])),
            appearance=Appearance(USE='metal'))])])]),
    Transform(translation=(-51.5865,-10.2621,3.3253),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='LampFrameShape',solid=False,uClosed=True,uDimension=30,uKnot=[0,0,0,0,0.0273,0.0588,0.0933,0.1176,0.1495,0.1765,0.2101,0.2353,0.2630,0.2941,0.3529,0.3825,0.4118,0.4706,0.5027,0.5294,0.5512,0.5882,0.6133,0.6471,0.6720,0.7059,0.7647,0.8235,0.8824,0.9412,1,1,1,1],uOrder=4,vClosed=True,vDimension=12,vKnot=[0,0,0,0,0.1875,0.2188,0.3125,0.3438,0.5625,0.5938,0.6875,0.7188,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(51.4075,10.5573,-3.3775),(51.3780,10.5567,-3.3882),(51.3112,10.5550,-3.4125),(51.2439,10.5562,-3.4370),(51.2285,10.6086,-3.4426),(51.2214,10.7259,-3.4452),(51.2174,10.8761,-3.4466),(51.2172,11.0626,-3.4467),(51.2211,11.2362,-3.4453),(51.2255,11.4114,-3.4437),(51.2273,11.5762,-3.4430),(51.2486,11.7271,-3.4353),(51.3772,11.7189,-3.3885),(51.5830,11.7193,-3.3136),(51.7891,11.7192,-3.2386),(51.9198,11.7291,-3.1910),(51.9398,11.5745,-3.1837),(51.9396,11.4158,-3.1838),(51.9396,11.2439,-3.1838),(51.9396,11.0754,-3.1838),(51.9396,10.8808,-3.1838),(51.9391,10.7301,-3.1840),(51.9376,10.6197,-3.1845),(51.9315,10.5584,-3.1867),(51.8566,10.5531,-3.2140),(51.7519,10.5584,-3.2521),(51.5832,10.5584,-3.3135),(51.5832,10.5584,-3.3135),(51.4709,10.5584,-3.3544),(51.4075,10.5573,-3.3775),(51.4015,10.5573,-3.3610),(51.3720,10.5567,-3.3717),(51.3052,10.5550,-3.3960),(51.2379,10.5562,-3.4205),(51.2225,10.6086,-3.4261),(51.2154,10.7259,-3.4287),(51.2114,10.8761,-3.4302),(51.2112,11.0626,-3.4303),(51.2151,11.2362,-3.4288),(51.2195,11.4114,-3.4272),(51.2213,11.5762,-3.4266),(51.2426,11.7271,-3.4188),(51.3712,11.7189,-3.3720),(51.5770,11.7193,-3.2971),(51.7831,11.7192,-3.2221),(51.9138,11.7291,-3.1745),(51.9338,11.5745,-3.1672),(51.9336,11.4158,-3.1673),(51.9336,11.2439,-3.1673),(51.9336,11.0754,-3.1673),(51.9336,10.8808,-3.1673),(51.9331,10.7301,-3.1675),(51.9316,10.6197,-3.1680),(51.9255,10.5584,-3.1703),(51.8506,10.5531,-3.1975),(51.7460,10.5584,-3.2356),(51.5772,10.5584,-3.2970),(51.5772,10.5584,-3.2970),(51.4649,10.5584,-3.3379),(51.4015,10.5573,-3.3610),(51.3943,10.5452,-3.3418),(51.3648,10.5446,-3.3526),(51.2977,10.5429,-3.3770),(51.2241,10.5465,-3.4038),(51.2044,10.6058,-3.4109),(51.1971,10.7254,-3.4136),(51.1931,10.8760,-3.4151),(51.1928,11.0628,-3.4152),(51.1968,11.2366,-3.4137),(51.2012,11.4117,-3.4121),(51.2030,11.5776,-3.4115),(51.2285,11.7366,-3.4022),(51.3642,11.7310,-3.3528),(51.5700,11.7314,-3.2779),(51.7762,11.7313,-3.2028),(51.9141,11.7384,-3.1526),(51.9381,11.5756,-3.1439),(51.9380,11.4158,-3.1439),(51.9380,11.2438,-3.1439),(51.9380,11.0754,-3.1439),(51.9380,10.8807,-3.1439),(51.9375,10.7299,-3.1441),(51.9359,10.6181,-3.1447),(51.9262,10.5494,-3.1482),(51.8441,10.5411,-3.1781),(51.7386,10.5463,-3.2165),(51.5701,10.5464,-3.2778),(51.5701,10.5464,-3.2778),(51.4579,10.5464,-3.3187),(51.3943,10.5452,-3.3418),(51.3914,10.5155,-3.3348),(51.3616,10.5149,-3.3456),(51.2938,10.5132,-3.3703),(51.2048,10.5227,-3.4027),(51.1746,10.5991,-3.4137),(51.1665,10.7242,-3.4166),(51.1625,10.8757,-3.4181),(51.1623,11.0634,-3.4182),(51.1662,11.2376,-3.4167),(51.1706,11.4125,-3.4152),(51.1727,11.5812,-3.4144),(51.2084,11.7598,-3.4014),(51.3616,11.7607,-3.3456),(51.5676,11.7611,-3.2707),(51.7738,11.7610,-3.1956),(51.9294,11.7613,-3.1390),(51.9634,11.5783,-3.1266),(51.9633,11.4156,-3.1266),(51.9633,11.2436,-3.1266),(51.9633,11.0752,-3.1266),(51.9633,10.8805,-3.1266),(51.9628,10.7294,-3.1268),(51.9610,10.6143,-3.1275),(51.9425,10.5275,-3.1342),(51.8429,10.5113,-3.1705),(51.7352,10.5166,-3.2097),(51.5673,10.5166,-3.2708),(51.5673,10.5166,-3.2708),(51.4554,10.5166,-3.3115),(51.3914,10.5155,-3.3348),(51.3915,10.5011,-3.3357),(51.3616,10.5006,-3.3466),(51.2935,10.4989,-3.3714),(51.1970,10.5112,-3.4065),(51.1618,10.5958,-3.4194),(51.1534,10.7236,-3.4224),(51.1494,10.8756,-3.4239),(51.1491,11.0636,-3.4240),(51.1531,11.2380,-3.4225),(51.1574,11.4129,-3.4209),(51.1596,11.5829,-3.4201),(51.2003,11.7709,-3.4053),(51.3619,11.7751,-3.3465),(51.5680,11.7754,-3.2715),(51.7742,11.7754,-3.1964),(51.9383,11.7723,-3.1367),(51.9771,11.5796,-3.1226),(51.9772,11.4155,-3.1226),(51.9772,11.2435,-3.1226),(51.9772,11.0751,-3.1226),(51.9772,10.8804,-3.1226),(51.9766,10.7291,-3.1228),(51.9747,10.6124,-3.1235),(51.9519,10.5170,-3.1318),(51.8439,10.4970,-3.1711),(51.7351,10.5023,-3.2107),(51.5675,10.5023,-3.2717),(51.5675,10.5023,-3.2717),(51.4558,10.5023,-3.3124),(51.3915,10.5011,-3.3357),(51.3966,10.4716,-3.3510),(51.3666,10.4710,-3.3619),(51.2977,10.4693,-3.3870),(51.1859,10.4876,-3.4277),(51.1402,10.5891,-3.4443),(51.1311,10.7224,-3.4476),(51.1271,10.8753,-3.4491),(51.1268,11.0642,-3.4492),(51.1308,11.2390,-3.4477),(51.1352,11.4137,-3.4461),(51.1375,11.5864,-3.4453),(51.1884,11.7940,-3.4268),(51.3674,11.8046,-3.3616),(51.5737,11.8050,-3.2865),(51.7799,11.8049,-3.2115),(51.9616,11.7950,-3.1454),(52.0103,11.5824,-3.1276),(52.0104,11.4153,-3.1276),(52.0104,11.2433,-3.1276),(52.0104,11.0749,-3.1276),(52.0104,10.8801,-3.1276),(52.0099,10.7286,-3.1278),(52.0077,10.6086,-3.1286),(51.9762,10.4952,-3.1400),(51.8507,10.4675,-3.1857),(51.7398,10.4727,-3.2261),(51.5729,10.4727,-3.2868),(51.5729,10.4727,-3.2868),(51.4614,10.4727,-3.3274),(51.3966,10.4716,-3.3510),(51.4059,10.4624,-3.3770),(51.3758,10.4619,-3.3879),(51.3067,10.4602,-3.4131),(51.1901,10.4802,-3.4555),(51.1413,10.5870,-3.4733),(51.1320,10.7220,-3.4767),(51.1279,10.8753,-3.4782),(51.1277,11.0643,-3.4783),(51.1316,11.2392,-3.4768),(51.1360,11.4139,-3.4752),(51.1384,11.5875,-3.4743),(51.1924,11.8011,-3.4547),(51.3769,11.8138,-3.3875),(51.5831,11.8142,-3.3125),(51.7894,11.8141,-3.2374),(51.9765,11.8021,-3.1693),(52.0283,11.5832,-3.1505),(52.0285,11.4152,-3.1504),(52.0285,11.2433,-3.1504),(52.0285,11.0748,-3.1504),(52.0285,10.8801,-3.1504),(52.0280,10.7285,-3.1506),(52.0257,10.6074,-3.1514),(51.9915,10.4884,-3.1639),(51.8606,10.4583,-3.2115),(51.7490,10.4636,-3.2521),(51.5822,10.4635,-3.3128),(51.5822,10.4635,-3.3128),(51.4708,10.4635,-3.3534),(51.4059,10.4624,-3.3770),(51.4170,10.4782,-3.4067),(51.3870,10.4776,-3.4176),(51.3182,10.4759,-3.4426),(51.2099,10.4929,-3.4821),(51.1665,10.5906,-3.4979),(51.1576,10.7226,-3.5011),(51.1536,10.8754,-3.5026),(51.1533,11.0640,-3.5027),(51.1573,11.2387,-3.5012),(51.1617,11.4135,-3.4996),(51.1640,11.5856,-3.4988),(51.2125,11.7888,-3.4811),(51.3877,11.7980,-3.4174),(51.5939,11.7984,-3.3423),(51.8002,11.7983,-3.2672),(51.9779,11.7900,-3.2025),(52.0244,11.5818,-3.1856),(52.0245,11.4153,-3.1856),(52.0245,11.2434,-3.1856),(52.0245,11.0749,-3.1856),(52.0245,10.8802,-3.1856),(52.0240,10.7287,-3.1858),(52.0218,10.6095,-3.1866),(51.9923,10.5000,-3.1973),(51.8707,10.4741,-3.2416),(51.7603,10.4793,-3.2818),(51.5932,10.4793,-3.3426),(51.5932,10.4793,-3.3426),(51.4816,10.4793,-3.3832),(51.4170,10.4782,-3.4067),(51.4200,10.4896,-3.4144),(51.3900,10.4891,-3.4253),(51.3216,10.4874,-3.4502),(51.2192,10.5020,-3.4875),(51.1799,10.5932,-3.5018),(51.1712,10.7231,-3.5050),(51.1672,10.8755,-3.5064),(51.1669,11.0638,-3.5065),(51.1709,11.2384,-3.5051),(51.1753,11.4132,-3.5035),(51.1775,11.5843,-3.5027),(51.2221,11.7799,-3.4864),(51.3906,11.7866,-3.4251),(51.5967,11.7869,-3.3501),(51.8029,11.7869,-3.2750),(51.9739,11.7812,-3.2128),(52.0165,11.5807,-3.1973),(52.0166,11.4154,-3.1973),(52.0166,11.2434,-3.1973),(52.0166,11.0750,-3.1973),(52.0166,10.8803,-3.1973),(52.0161,10.7289,-3.1975),(52.0140,10.6110,-3.1982),(51.9878,10.5085,-3.2077),(51.8730,10.4855,-3.2495),(51.7634,10.4908,-3.2894),(51.5961,10.4908,-3.3503),(51.5961,10.4908,-3.3503),(51.4844,10.4908,-3.3910),(51.4200,10.4896,-3.4144),(51.4249,10.5267,-3.4266),(51.3953,10.5261,-3.4374),(51.3277,10.5244,-3.4620),(51.2446,10.5317,-3.4923),(51.2183,10.6016,-3.5018),(51.2105,10.7247,-3.5047),(51.2065,10.8758,-3.5061),(51.2063,11.0632,-3.5062),(51.2102,11.2372,-3.5048),(51.2146,11.4122,-3.5032),(51.2166,11.5798,-3.5025),(51.2485,11.7510,-3.4909),(51.3950,11.7495,-3.4375),(51.6010,11.7499,-3.3626),(51.8071,11.7498,-3.2875),(51.9561,11.7526,-3.2333),(51.9863,11.5773,-3.2223),(51.9862,11.4156,-3.2223),(51.9862,11.2437,-3.2223),(51.9862,11.0752,-3.2223),(51.9862,10.8806,-3.2223),(51.9857,10.7296,-3.2225),(51.9839,10.6157,-3.2232),(51.9688,10.5358,-3.2287),(51.8758,10.5226,-3.2625),(51.7689,10.5279,-3.3014),(51.6008,10.5279,-3.3626),(51.6008,10.5279,-3.3626),(51.4888,10.5279,-3.4034),(51.4249,10.5267,-3.4266),(51.4164,10.5586,-3.4020),(51.3870,10.5581,-3.4127),(51.3202,10.5564,-3.4370),(51.2536,10.5573,-3.4612),(51.2386,10.6089,-3.4667),(51.2316,10.7260,-3.4692),(51.2276,10.8761,-3.4707),(51.2274,11.0626,-3.4708),(51.2313,11.2362,-3.4693),(51.2357,11.4114,-3.4677),(51.2375,11.5760,-3.4671),(51.2583,11.7261,-3.4595),(51.3861,11.7175,-3.4130),(51.5919,11.7179,-3.3381),(51.7980,11.7178,-3.2631),(51.9279,11.7281,-3.2158),(51.9474,11.5743,-3.2087),(51.9473,11.4158,-3.2087),(51.9473,11.2439,-3.2087),(51.9473,11.0754,-3.2087),(51.9473,10.8809,-3.2087),(51.9468,10.7301,-3.2089),(51.9452,10.6199,-3.2095),(51.9395,10.5594,-3.2116),(51.8654,10.5545,-3.2385),(51.7609,10.5598,-3.2766),(51.5921,10.5598,-3.3380),(51.5921,10.5598,-3.3380),(51.4798,10.5598,-3.3789),(51.4164,10.5586,-3.4020),(51.4075,10.5577,-3.3775),(51.3780,10.5572,-3.3882),(51.3112,10.5554,-3.4125),(51.2442,10.5566,-3.4369),(51.2289,10.6087,-3.4425),(51.2218,10.7260,-3.4450),(51.2179,10.8761,-3.4465),(51.2176,11.0626,-3.4466),(51.2216,11.2362,-3.4451),(51.2259,11.4114,-3.4435),(51.2277,11.5761,-3.4429),(51.2489,11.7268,-3.4352),(51.3772,11.7184,-3.3885),(51.5830,11.7188,-3.3136),(51.7891,11.7187,-3.2386),(51.9196,11.7288,-3.1911),(51.9394,11.5744,-3.1839),(51.9392,11.4158,-3.1839),(51.9392,11.2439,-3.1839),(51.9392,11.0754,-3.1839),(51.9392,10.8809,-3.1839),(51.9387,10.7301,-3.1841),(51.9372,10.6198,-3.1847),(51.9312,10.5587,-3.1868),(51.8566,10.5536,-3.2140),(51.7520,10.5589,-3.2521),(51.5832,10.5589,-3.3135),(51.5832,10.5589,-3.3135),(51.4709,10.5589,-3.3544),(51.4075,10.5577,-3.3775)])),
            appearance=Appearance(USE='metal'))])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for HurricaneLantern.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python HurricaneLantern.py load and self-test diagnostics complete.")
