package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry2D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.NURBS.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> A NurbsTrimmedSurface node rendering a square centered on the origin in the x-y plane; with sides 8 units length. A trimming curve is used to cut out a circle of radius 1 unit centered at the point (x,y)=(1,1) . Red (x), Green (y) and Blue (z) line segments represent the x-y-z unit axes. </p>
 <p> Related links: Catalog page <a href="../../../NURBS/HoleSmallOffsetIndex.html" target="_blank">HoleSmallOffset</a>,  source <a href="../../../NURBS/HoleSmallOffset.java">HoleSmallOffset.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/HoleSmallOffset.x3d">HoleSmallOffset.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> A NurbsTrimmedSurface node rendering a square centered on the origin in the x-y plane; with sides 8 units length. A trimming curve is used to cut out a circle of radius 1 unit centered at the point (x,y)=(1,1) . Red (x), Green (y) and Blue (z) line segments represent the x-y-z unit axes. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/HoleSmallOffset.jpg">HoleSmallOffset.jpg</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Vincent Marchetti </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 10 February 2012 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/HoleSmallOffsetInstantReality.png">images/HoleSmallOffsetInstantReality.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/HoleSmallOffsetXj3D.png">images/HoleSmallOffsetXj3D.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.kshell.com/pages/trimmed_nurbs_demo" target="_blank">http://www.kshell.com/pages/trimmed_nurbs_demo</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/HoleSmallOffset.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/HoleSmallOffset.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Python language scripting </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Vincent Marchetti
 */

public class HoleSmallOffset
{
	/** Default constructor to create this object. */
	public HoleSmallOffset ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_2)
  .setHead(new head()
    .addComponent(new component().setName("NURBS").setLevel(4))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("HoleSmallOffset.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("A NurbsTrimmedSurface node rendering a square centered on the origin in the x-y plane; with sides 8 units length. A trimming curve is used to cut out a circle of radius 1 unit centered at the point (x,y)=(1,1) . Red (x), Green (y) and Blue (z) line segments represent the x-y-z unit axes."))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("HoleSmallOffset.jpg"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Vincent Marchetti"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("10 February 2012"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/HoleSmallOffsetInstantReality.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/HoleSmallOffsetXj3D.png"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.kshell.com/pages/trimmed_nurbs_demo"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/HoleSmallOffset.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Python language scripting"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("HoleSmallOffset.x3d"))
    .addChild(new Viewpoint().setDescription("Hole Small Offset NurbsTrimmedSurface").setPosition(0.0,0.0,12.0))
    .addChild(new Background().setSkyColor(new MFColor(new double[] {1.0,1.0,1.0})))
    .addChild(new Group()
      .addChild(new Shape()
        .setGeometry(new LineSet().setVertexCount(new int[] {2})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.01,1.0,0.0,0.01}))))
        .setAppearance(new Appearance()
          .setMaterial(new Material().setEmissiveColor(1.0,0.0,0.0))
          .setLineProperties(new LineProperties().setLinewidthScaleFactor(2))))
      .addChild(new Shape()
        .setGeometry(new LineSet().setVertexCount(new int[] {2})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.01,0.0,1.0,0.01}))))
        .setAppearance(new Appearance()
          .setMaterial(new Material().setEmissiveColor(0.0,1.0,0.0))
          .setLineProperties(new LineProperties().setLinewidthScaleFactor(2))))
      .addChild(new Shape()
        .setGeometry(new LineSet().setVertexCount(new int[] {2})
          .setCoord(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.01,0.0,0.0,1.0}))))
        .setAppearance(new Appearance()
          .setMaterial(new Material().setEmissiveColor(0.0,0.0,1.0))
          .setLineProperties(new LineProperties().setLinewidthScaleFactor(2)))))
    .addChild(new Shape()
      .setGeometry(new NurbsTrimmedSurface().setSolid(false).setUDimension(2).setUKnot(new double[] {-4.0,-4.0,4.0,4.0}).setUOrder(2).setVDimension(2).setVKnot(new double[] {-4.0,-4.0,4.0,4.0}).setVOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0})
        .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-4.0,-4.0,0.0,4.0,-4.0,0.0,-4.0,4.0,0.0,4.0,4.0,0.0})))
        .addTrimmingContour(new Contour2D()
          .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {-4.0,-4.0,4.0,-4.0,4.0,4.0,-4.0,4.0,-4.0,-4.0})).setKnot(new double[] {0.0,0.0,0.25,0.5,0.75,1.0,1.0}).setOrder(2).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0})))
        .addTrimmingContour(new Contour2D()
          .addChild(new NurbsCurve2D().setControlPoint(new MFVec2f(new double[] {2.0,1.0,1.414,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,1.414,1.0,2.0,1.414,1.414,2.0,1.0})).setKnot(new double[] {0.0,0.0,0.0,0.25,0.25,0.5,0.5,0.75,0.75,1.0,1.0,1.0}).setWeight(new double[] {1.0,0.7071,1.0,0.7071,1.0,0.7071,1.0,0.7071,1.0}))))
      .setAppearance(new Appearance("ksh_appearance_1")
        .setMaterial(new Material().setDiffuseColor(0.0,0.0,1.0)))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return HoleSmallOffset model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new HoleSmallOffset().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.HoleSmallOffset\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.HoleSmallOffset self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/HoleSmallOffset_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/HoleSmallOffset_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/HoleSmallOffset_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/HoleSmallOffset_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
