####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python FredTheBunny.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    component(level=1,name='NURBS'),
    meta(content='FredTheBunny.x3d',name='title'),
    meta(content='NURBS exemplar created using X3D NURBS Export Plugin for Maya.',name='description'),
    meta(content='Charles Adams',name='creator'),
    meta(content='6 February 2003',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='FredTheBunny.png',name='Image'),
    meta(content='images/FredTheBunnyBSContact.png',name='Image'),
    meta(content='images/FredTheBunnyH3dViewer.png',name='Image'),
    meta(content='images/FredTheBunnyInstantReality.png',name='Image'),
    meta(content='images/FredTheBunnyOctagaVS.png',name='Image'),
    meta(content='images/FredTheBunnyView3dscene.png',name='Image'),
    meta(content='images/FredTheBunnyXj3D.png',name='Image'),
    meta(content='images/FredTheBunnyXj3DfromBehind.png',name='Image'),
    meta(content='Exported from Maya 4.0 using X3DNurbsExport Plug-in',name='translator'),
    meta(content='http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/NURBS/FredTheBunny.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='FredTheBunny.x3d'),
    Viewpoint(description='Fred the Bunny',orientation=(0,1,0,3.14),position=(0,0,-17)),
    Viewpoint(description='Fred the Bunny, from behind',position=(0,0,17)),
    Background(skyColor=[(0,0.6156863,0.7019608)]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='WhiskerShape6',solid=False,uDimension=4,uKnot=[0,0,0,0,1,1,1,1],uOrder=4,vDimension=7,vKnot=[-2,-2,-1,0,1,2,3,4,5,6,6],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0.2111,2.8144,-0.8276),(-0.3619,2.8873,-0.8350),(-0.5594,3.0555,-0.8524),(-0.7231,2.8790,-0.8656),(-0.2133,2.8095,-0.8327),(-0.3646,2.8826,-0.8402),(-0.5587,3.0499,-0.8573),(-0.7185,2.8752,-0.8702),(-0.2157,2.8049,-0.8273),(-0.3677,2.8785,-0.8348),(-0.5589,3.0449,-0.8517),(-0.7154,2.8719,-0.8643),(-0.2136,2.8099,-0.8221),(-0.3650,2.8831,-0.8296),(-0.5596,3.0505,-0.8468),(-0.7199,2.8757,-0.8597),(-0.2111,2.8144,-0.8276),(-0.3619,2.8873,-0.8350),(-0.5594,3.0555,-0.8524),(-0.7231,2.8790,-0.8656),(-0.2133,2.8095,-0.8327),(-0.3646,2.8826,-0.8402),(-0.5587,3.0499,-0.8573),(-0.7185,2.8752,-0.8702),(-0.2157,2.8049,-0.8273),(-0.3677,2.8785,-0.8348),(-0.5589,3.0449,-0.8517),(-0.7154,2.8719,-0.8643)])),
            appearance=Appearance(DEF='whiskers',
              material=Material(diffuseColor=(.22,.22,.22))))])])]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='WhskerShape5',solid=False,uDimension=4,uKnot=[0,0,0,0,1,1,1,1],uOrder=4,vDimension=7,vKnot=[-2,-2,-1,0,1,2,3,4,5,6,6],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0.2077,2.8154,-0.8147),(-0.3505,2.9030,-0.8191),(-0.5305,3.0903,-0.8305),(-0.7109,2.9314,-0.8470),(-0.2104,2.8107,-0.8199),(-0.3537,2.8987,-0.8243),(-0.5304,3.0848,-0.8355),(-0.7068,2.9272,-0.8517),(-0.2132,2.8064,-0.8146),(-0.3572,2.8947,-0.8189),(-0.5310,3.0798,-0.8300),(-0.7040,2.9235,-0.8459),(-0.2106,2.8110,-0.8094),(-0.3540,2.8990,-0.8137),(-0.5312,3.0853,-0.8249),(-0.7081,2.9276,-0.8412),(-0.2077,2.8154,-0.8147),(-0.3505,2.9030,-0.8191),(-0.5305,3.0903,-0.8305),(-0.7109,2.9314,-0.8470),(-0.2104,2.8107,-0.8199),(-0.3537,2.8987,-0.8243),(-0.5304,3.0848,-0.8355),(-0.7068,2.9272,-0.8517),(-0.2132,2.8064,-0.8146),(-0.3572,2.8947,-0.8189),(-0.5310,3.0798,-0.8300),(-0.7040,2.9235,-0.8459)])),
            appearance=Appearance(USE='whiskers'))])])]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='WhiskerShape4',solid=False,uDimension=4,uKnot=[0,0,0,0,1,1,1,1],uOrder=4,vDimension=7,vKnot=[-2,-2,-1,0,1,2,3,4,5,6,6],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0.2097,2.8181,-0.7996),(-0.3432,2.9194,-0.8004),(-0.5037,3.1239,-0.8055),(-0.6991,2.9841,-0.8248),(-0.2129,2.8138,-0.8048),(-0.3468,2.9156,-0.8057),(-0.5042,3.1185,-0.8106),(-0.6954,2.9797,-0.8296),(-0.2161,2.8096,-0.7995),(-0.3506,2.9119,-0.8004),(-0.5053,3.1135,-0.8052),(-0.6930,2.9756,-0.8238),(-0.2129,2.8139,-0.7943),(-0.3469,2.9157,-0.7951),(-0.5048,3.1189,-0.8001),(-0.6966,2.9800,-0.8191),(-0.2097,2.8181,-0.7996),(-0.3432,2.9194,-0.8004),(-0.5037,3.1239,-0.8055),(-0.6991,2.9841,-0.8248),(-0.2129,2.8138,-0.8048),(-0.3468,2.9156,-0.8057),(-0.5042,3.1185,-0.8106),(-0.6954,2.9797,-0.8296),(-0.2161,2.8096,-0.7995),(-0.3506,2.9119,-0.8004),(-0.5053,3.1135,-0.8052),(-0.6930,2.9756,-0.8238)])),
            appearance=Appearance(USE='whiskers'))])])]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='WhiskerShape3',solid=False,uDimension=4,uKnot=[-1,-1,-1,-1,0,0,0,0],uOrder=4,vDimension=7,vKnot=[-2,-2,-1,0,1,2,3,4,5,6,6],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(0.1313,2.8144,-0.8268),(0.2821,2.8873,-0.8342),(0.4797,3.0555,-0.8516),(0.6433,2.8790,-0.8648),(0.1331,2.8101,-0.8327),(0.2843,2.8833,-0.8401),(0.4789,3.0506,-0.8573),(0.6393,2.8758,-0.8702),(0.1359,2.8050,-0.8280),(0.2878,2.8785,-0.8355),(0.4790,3.0449,-0.8525),(0.6355,2.8719,-0.8651),(0.1341,2.8092,-0.8222),(0.2855,2.8825,-0.8297),(0.4797,3.0498,-0.8468),(0.6395,2.8752,-0.8597),(0.1313,2.8144,-0.8268),(0.2821,2.8873,-0.8342),(0.4797,3.0555,-0.8516),(0.6433,2.8790,-0.8648),(0.1331,2.8101,-0.8327),(0.2843,2.8833,-0.8401),(0.4789,3.0506,-0.8573),(0.6393,2.8758,-0.8702),(0.1359,2.8050,-0.8280),(0.2878,2.8785,-0.8355),(0.4790,3.0449,-0.8525),(0.6355,2.8719,-0.8651)])),
            appearance=Appearance(USE='whiskers'))])])]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='WhiskerShape2',solid=False,uDimension=4,uKnot=[-1,-1,-1,-1,0,0,0,0],uOrder=4,vDimension=7,vKnot=[-2,-2,-1,0,1,2,3,4,5,6,6],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(0.1279,2.8154,-0.8140),(0.2707,2.9029,-0.8183),(0.4507,3.0903,-0.8297),(0.6311,2.9313,-0.8463),(0.1302,2.8114,-0.8199),(0.2734,2.8993,-0.8242),(0.4505,3.0855,-0.8355),(0.6274,2.9278,-0.8517),(0.1334,2.8064,-0.8153),(0.2773,2.8948,-0.8197),(0.4511,3.0798,-0.8307),(0.6241,2.9235,-0.8466),(0.1311,2.8104,-0.8094),(0.2746,2.8984,-0.8138),(0.4513,3.0846,-0.8250),(0.6278,2.9271,-0.8412),(0.1279,2.8154,-0.8140),(0.2707,2.9029,-0.8183),(0.4507,3.0903,-0.8297),(0.6311,2.9313,-0.8463),(0.1302,2.8114,-0.8199),(0.2734,2.8993,-0.8242),(0.4505,3.0855,-0.8355),(0.6274,2.9278,-0.8517),(0.1334,2.8064,-0.8153),(0.2773,2.8948,-0.8197),(0.4511,3.0798,-0.8307),(0.6241,2.9235,-0.8466)])),
            appearance=Appearance(USE='whiskers'))])])]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='WhiskerShape1',solid=False,uDimension=4,uKnot=[-1,-1,-1,-1,0,0,0,0],uOrder=4,vDimension=7,vKnot=[-2,-2,-1,0,1,2,3,4,5,6,6],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(0.1299,2.8180,-0.7989),(0.2634,2.9194,-0.7997),(0.4240,3.1239,-0.8048),(0.6193,2.9841,-0.8241),(0.1327,2.8144,-0.8048),(0.2665,2.9161,-0.8057),(0.4242,3.1192,-0.8106),(0.6160,2.9803,-0.8296),(0.1363,2.8097,-0.8002),(0.2707,2.9119,-0.8011),(0.4254,3.1135,-0.8059),(0.6131,2.9756,-0.8245),(0.1335,2.8133,-0.7943),(0.2676,2.9152,-0.7952),(0.4251,3.1182,-0.8001),(0.6164,2.9794,-0.8191),(0.1299,2.8180,-0.7989),(0.2634,2.9194,-0.7997),(0.4240,3.1239,-0.8048),(0.6193,2.9841,-0.8241),(0.1327,2.8144,-0.8048),(0.2665,2.9161,-0.8057),(0.4242,3.1192,-0.8106),(0.6160,2.9803,-0.8296),(0.1363,2.8097,-0.8002),(0.2707,2.9119,-0.8011),(0.4254,3.1135,-0.8059),(0.6131,2.9756,-0.8245)])),
            appearance=Appearance(USE='whiskers'))])])]),
    Transform(translation=(-0.0434,2.7513,-0.8060),
      children=[
      Transform(
        children=[
        Transform(scale=(0.2483,0.2483,0.2483),
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='NoseShape',solid=False,uClosed=True,uDimension=7,uKnot=[0,0,0,0,1,2,3,4,4,4,4],uOrder=4,vClosed=True,vDimension=6,vKnot=[0,0,0,0,1,2,3,3,3,3],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(0.1667,-0.5000,0.0034),(0.1667,-0.5000,0.0833),(0,-0.5000,0.2500),(-0.2500,-0.5000,0.0000),(-0,-0.5000,-0.2296),(0.1667,-0.5000,-0.0765),(0.1667,-0.5000,0.0034),(0.2303,-0.3000,0.0269),(0.2303,-0.3000,0.2609),(0,-0.3000,0.7827),(-0.3600,-0.3000,0.0000),(-0,-0.3000,-0.6212),(0.2303,-0.3000,-0.2071),(0.2303,-0.3000,0.0269),(0.5218,0.3000,0.0972),(0.5218,0.3000,0.2609),(-0,0.3000,0.7827),(-0.7827,0.3000,0.0000),(-0,0.3000,-0.1997),(0.5218,0.3000,-0.0666),(0.5218,0.3000,0.0972),(0.1667,0.5000,0.0300),(0.1667,0.5000,0.0833),(-0,0.5000,0.2500),(-0.2500,0.5000,-0.0000),(0,0.5000,-0.0699),(0.1667,0.5000,-0.0233),(0.1667,0.5000,0.0300),(0,0.5000,-0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000)])),
            appearance=Appearance(DEF='nosecolor',
              material=Material(diffuseColor=(.8,.6,.6))))])])]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='Nose_CurveShape',solid=False,uDimension=4,uKnot=[0,0,0,0,1,1,1,1],uOrder=4,vDimension=7,vKnot=[-2,-2,-1,0,1,2,3,4,5,6,6],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0.0250,2.5760,-0.9367),(-0.0279,2.6668,-0.8927),(-0.0306,2.7539,-0.8322),(-0.0332,2.8402,-0.7811),(-0.0373,2.5809,-0.9477),(-0.0402,2.6726,-0.9033),(-0.0429,2.7602,-0.8425),(-0.0455,2.8461,-0.7917),(-0.0493,2.5753,-0.9368),(-0.0522,2.6661,-0.8928),(-0.0549,2.7533,-0.8324),(-0.0575,2.8396,-0.7813),(-0.0371,2.5703,-0.9258),(-0.0399,2.6604,-0.8823),(-0.0426,2.7470,-0.8221),(-0.0453,2.8337,-0.7707),(-0.0250,2.5760,-0.9367),(-0.0279,2.6668,-0.8927),(-0.0306,2.7539,-0.8322),(-0.0332,2.8402,-0.7811),(-0.0373,2.5809,-0.9477),(-0.0402,2.6726,-0.9033),(-0.0429,2.7602,-0.8425),(-0.0455,2.8461,-0.7917),(-0.0493,2.5753,-0.9368),(-0.0522,2.6661,-0.8928),(-0.0549,2.7533,-0.8324),(-0.0575,2.8396,-0.7813)])),
            appearance=Appearance(USE='nosecolor'))])])]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='MouthShape',solid=False,uDimension=6,uKnot=[1,1,1,1,2.0874,2.0874,3,3,3,3],uOrder=4,vDimension=7,vKnot=[-2,-2,-1,0,1,2,3,4,5,6,6],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(0.2077,2.5319,-0.9429),(0.1100,2.5720,-0.9442),(0.0229,2.5929,-0.9369),(-0.1755,2.5806,-0.9363),(-0.2494,2.5595,-0.9397),(-0.3313,2.5234,-0.9342),(0.2032,2.5205,-0.9550),(0.1058,2.5605,-0.9562),(0.0213,2.5808,-0.9490),(-0.1732,2.5686,-0.9486),(-0.2454,2.5480,-0.9519),(-0.3271,2.5120,-0.9464),(0.1985,2.5094,-0.9427),(0.1025,2.5488,-0.9440),(0.0208,2.5686,-0.9369),(-0.1714,2.5564,-0.9364),(-0.2412,2.5366,-0.9398),(-0.3215,2.5011,-0.9343),(0.2030,2.5208,-0.9306),(0.1067,2.5604,-0.9319),(0.0223,2.5807,-0.9247),(-0.1737,2.5684,-0.9241),(-0.2452,2.5480,-0.9276),(-0.3257,2.5125,-0.9221),(0.2077,2.5319,-0.9429),(0.1100,2.5720,-0.9442),(0.0229,2.5929,-0.9369),(-0.1755,2.5806,-0.9363),(-0.2494,2.5595,-0.9397),(-0.3313,2.5234,-0.9342),(0.2032,2.5205,-0.9550),(0.1058,2.5605,-0.9562),(0.0213,2.5808,-0.9490),(-0.1732,2.5686,-0.9486),(-0.2454,2.5480,-0.9519),(-0.3271,2.5120,-0.9464),(0.1985,2.5094,-0.9427),(0.1025,2.5488,-0.9440),(0.0208,2.5686,-0.9369),(-0.1714,2.5564,-0.9364),(-0.2412,2.5366,-0.9398),(-0.3215,2.5011,-0.9343)])),
            appearance=Appearance(USE='nosecolor'))])])]),
    Transform(translation=(0.0305,-1.2548,0.8211),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='TailShape',solid=False,uClosed=True,uDimension=7,uKnot=[0,0,0,0,1,2,3,4,4,4,4],uOrder=4,vClosed=True,vDimension=6,vKnot=[0,0,0,0,1,2,3,3,3,3],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(-0,-0.5000,-0.0000),(0.1667,-0.5000,-0.0000),(0.1667,-0.5000,0.0833),(0,-0.5000,0.2500),(-0.2500,-0.5000,0.0000),(-0,-0.5000,-0.2500),(0.1667,-0.5000,-0.0833),(0.1667,-0.5000,-0.0000),(0.5218,-0.3000,0.0000),(0.5218,-0.3000,0.2609),(0,-0.3000,0.7827),(-0.7827,-0.3000,0.0000),(-0,-0.3000,-0.7827),(0.5218,-0.3000,-0.2609),(0.5218,-0.3000,-0.0000),(0.5218,0.3000,0.0000),(0.5218,0.3000,0.2609),(-0,0.3000,0.7827),(-0.7827,0.3000,0.0000),(-0,0.3000,-0.7827),(0.5218,0.3000,-0.2609),(0.5218,0.3000,0.0000),(0.1667,0.5000,0.0000),(0.1667,0.5000,0.0833),(-0,0.5000,0.2500),(-0.2500,0.5000,-0.0000),(0,0.5000,-0.2500),(0.1667,0.5000,-0.0833),(0.1667,0.5000,0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000),(0,0.5000,-0.0000)])),
            appearance=Appearance(DEF='fur',
              material=Material(diffuseColor=(.86,.82,.82))))])])]),
    Transform(translation=(-0,0,0),
      children=[
      Transform(rotation=(0,1,0,3.1416),
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='Left_earShape',solid=False,uClosed=True,uDimension=11,uKnot=[0,0,0,0,0.2500,0.5000,0.7500,1,1.2500,1.5000,1.7500,2,2,2,2],uOrder=4,vClosed=True,vDimension=7,vKnot=[0,0,0,0,0.2500,0.5000,0.7500,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(0.5625,3.8438,0.0474),(0.5640,3.8270,0.0136),(0.5657,3.8018,-0.0483),(0.5641,3.7890,-0.1198),(0.5594,3.8013,-0.1859),(0.5558,3.8491,-0.2636),(0.5599,3.8975,-0.1859),(0.5626,3.9104,-0.1198),(0.5662,3.8980,-0.0483),(0.5685,3.8728,0.0136),(0.5697,3.8560,0.0474),(1.0852,3.8847,0.3433),(1.0994,3.8345,0.2354),(1.1112,3.8901,0.0432),(1.1221,3.8799,-0.1528),(1.1373,3.7607,-0.3319),(1.1420,3.8962,-0.5756),(1.1239,4.0299,-0.3319),(1.1152,4.0678,-0.1528),(1.1083,4.0287,0.0432),(1.0982,3.9509,0.2354),(1.0923,3.8992,0.3433),(1.4237,3.8212,0.4200),(1.3807,3.7640,0.3139),(1.3856,3.8258,0.1213),(1.3763,3.8136,-0.0844),(1.3026,3.6844,-0.2942),(1.3264,3.8722,-0.6068),(1.4643,4.0058,-0.2942),(1.4968,4.0483,-0.0844),(1.4772,3.9995,0.1213),(1.4520,3.8950,0.3139),(1.4348,3.8254,0.4200),(1.9005,3.1834,0.8772),(1.8142,3.1421,0.6794),(1.8856,3.1400,0.3165),(1.8687,3.1255,-0.0879),(1.6882,3.0696,-0.5028),(1.9269,3.1245,-1.0990),(2.1586,3.2028,-0.5028),(2.2265,3.2248,-0.0879),(2.1558,3.2129,0.3165),(2.0135,3.1936,0.6794),(1.9188,3.1804,0.8772),(1.8662,2.3012,0.6062),(1.8438,2.3054,0.4434),(1.8802,2.2833,0.1442),(1.8747,2.2823,-0.2111),(1.8123,2.3173,-0.5243),(1.8739,2.3174,-0.8458),(1.9145,2.2663,-0.5243),(1.9259,2.2523,-0.2111),(1.9121,2.2613,0.1442),(1.8837,2.2800,0.4434),(1.8649,2.2928,0.6062),(1.6824,1.8936,0.1823),(1.6780,1.9160,0.1067),(1.6702,1.9468,-0.0128),(1.6589,1.9483,-0.0583),(1.6575,1.9162,-0.1072),(1.6818,1.8508,-0.3143),(1.7419,1.8725,-0.1072),(1.7636,1.8964,-0.0583),(1.7545,1.9032,-0.0128),(1.7273,1.8868,0.1067),(1.7084,1.8741,0.1823),(1.6906,1.8990,-0.0460),(1.6906,1.9017,-0.0488),(1.6911,1.9065,-0.0589),(1.6931,1.9129,-0.0926),(1.6956,1.9143,-0.1270),(1.7018,1.8993,-0.1424),(1.7136,1.8980,-0.1270),(1.7144,1.8952,-0.0926),(1.7113,1.8893,-0.0589),(1.7082,1.8856,-0.0488),(1.7063,1.8836,-0.0460)])),
            appearance=Appearance(USE='fur'))])])]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='Right_earShape',solid=False,uClosed=True,uDimension=11,uKnot=[0,0,0,0,0.2500,0.5000,0.7500,1,1.2500,1.5000,1.7500,2,2,2,2],uOrder=4,vClosed=True,vDimension=7,vKnot=[0,0,0,0,0.2500,0.5000,0.7500,1,1,1,1],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(0.5625,3.8438,-0.0474),(0.5640,3.8270,-0.0136),(0.5657,3.8018,0.0483),(0.5641,3.7890,0.1198),(0.5594,3.8013,0.1859),(0.5558,3.8491,0.2636),(0.5599,3.8975,0.1859),(0.5626,3.9104,0.1198),(0.5662,3.8980,0.0483),(0.5685,3.8728,-0.0136),(0.5697,3.8560,-0.0474),(1.0852,3.8847,-0.3433),(1.0994,3.8345,-0.2354),(1.1112,3.8901,-0.0432),(1.1221,3.8799,0.1528),(1.1373,3.7607,0.3319),(1.1420,3.8962,0.5756),(1.1239,4.0299,0.3319),(1.1152,4.0678,0.1528),(1.1083,4.0287,-0.0432),(1.0982,3.9509,-0.2354),(1.0923,3.8992,-0.3433),(1.4156,3.8175,-0.4200),(1.3782,3.7564,-0.3139),(1.3772,3.8185,-0.1213),(1.3691,3.8054,0.0844),(1.3079,3.6699,0.2942),(1.3139,3.8591,0.6068),(1.4386,4.0051,0.2942),(1.4670,4.0504,0.0844),(1.4520,4,-0.1213),(1.4368,3.8936,-0.3139),(1.4263,3.8227,-0.4200),(1.9502,3.2274,-0.8772),(1.8683,3.1782,-0.6794),(1.9395,3.1828,-0.3165),(1.9241,3.1667,0.0879),(1.7496,3.0941,0.5028),(1.9821,3.1712,1.0990),(2.2054,3.2709,0.5028),(2.2709,3.2992,0.0879),(2.2017,3.2807,-0.3165),(2.0618,3.2482,-0.6794),(1.9688,3.2261,-0.8772),(1.9991,2.3458,-0.6062),(1.9764,2.3479,-0.4434),(2.0147,2.3294,-0.1442),(2.0094,2.3278,0.2111),(1.9439,2.3568,0.5243),(2.0053,2.3627,0.8458),(2.0505,2.3157,0.5243),(2.0631,2.3028,0.2111),(2.0486,2.3104,-0.1442),(2.0185,2.3264,-0.4434),(1.9986,2.3374,-0.6062),(1.8545,1.9228,-0.1823),(1.8480,1.9446,-0.1067),(1.8373,1.9746,0.0128),(1.8260,1.9750,0.0583),(1.8276,1.9429,0.1072),(1.8579,1.8801,0.3143),(1.9157,1.9074,0.1072),(1.9350,1.9332,0.0583),(1.9254,1.9391,0.0128),(1.8998,1.9202,-0.1067),(1.8822,1.9057,-0.1823),(1.8621,1.9289,0.0460),(1.8619,1.9316,0.0488),(1.8619,1.9365,0.0589),(1.8633,1.9430,0.0926),(1.8657,1.9446,0.1270),(1.8732,1.9303,0.1424),(1.8851,1.9301,0.1270),(1.8862,1.9274,0.0926),(1.8837,1.9212,0.0589),(1.8810,1.9172,0.0488),(1.8793,1.9151,0.0460)])),
            appearance=Appearance(USE='fur'))])])]),
    Transform(translation=(-0.3938,3.2755,-0.5584),
      children=[
      Transform(rotation=(0,1,0,3.1416),
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='Left_eyeShape',solid=False,uClosed=True,uDimension=7,uKnot=[0,0,0,0,1,2,3,4,4,4,4],uOrder=4,vClosed=True,vDimension=6,vKnot=[0,0,0,0,1,2,3,3,3,3],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0,-0.1182,0.0000),(-0,-0.1182,0.0000),(-0,-0.1182,0.0000),(-0,-0.1182,0.0000),(-0,-0.1182,0.0000),(-0,-0.1182,0.0000),(-0,-0.1182,0.0000),(0.0394,-0.1182,0.0000),(0.0394,-0.1182,-0.0197),(-0,-0.1182,-0.0591),(-0.0591,-0.1182,0.0000),(-0,-0.1182,0.0591),(0.0394,-0.1182,0.0197),(0.0394,-0.1182,0.0000),(0.1233,-0.0709,-0.0000),(0.1233,-0.0709,-0.0617),(-0,-0.0709,-0.1850),(-0.1850,-0.0709,0.0000),(-0,-0.0709,0.1850),(0.1233,-0.0709,0.0617),(0.1233,-0.0709,-0.0000),(0.1233,0.0709,-0.0000),(0.1233,0.0709,-0.0617),(-0,0.0709,-0.1850),(-0.1850,0.0709,0.0000),(-0,0.0709,0.1850),(0.1233,0.0709,0.0617),(0.1233,0.0709,-0.0000),(0.0394,0.1182,-0.0000),(0.0394,0.1182,-0.0197),(-0,0.1182,-0.0591),(-0.0591,0.1182,0.0000),(-0,0.1182,0.0591),(0.0394,0.1182,0.0197),(0.0394,0.1182,-0.0000),(-0,0.1182,0.0000),(-0,0.1182,0.0000),(-0,0.1182,0.0000),(-0,0.1182,0.0000),(-0,0.1182,0.0000),(-0,0.1182,0.0000),(-0,0.1182,0.0000)])),
            appearance=Appearance(DEF='eyecolor',
              material=Material(diffuseColor=(.429,.367,.367),shininess=0.8)))])])]),
    Transform(translation=(0.3450,3.2755,-0.5584),
      children=[
      Transform(
        children=[
        Transform(scale=(1.1819,1.1819,1.1819),
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='Right_eyeShape',solid=False,uClosed=True,uDimension=7,uKnot=[0,0,0,0,1,2,3,4,4,4,4],uOrder=4,vClosed=True,vDimension=6,vKnot=[0,0,0,0,1,2,3,3,3,3],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0,-0.1000,-0.0000),(-0,-0.1000,-0.0000),(-0,-0.1000,-0.0000),(-0,-0.1000,-0.0000),(-0,-0.1000,-0.0000),(-0,-0.1000,-0.0000),(-0,-0.1000,-0.0000),(0.0333,-0.1000,-0.0000),(0.0333,-0.1000,0.0167),(0,-0.1000,0.0500),(-0.0500,-0.1000,0.0000),(-0,-0.1000,-0.0500),(0.0333,-0.1000,-0.0167),(0.0333,-0.1000,-0.0000),(0.1044,-0.0600,0.0000),(0.1044,-0.0600,0.0522),(0,-0.0600,0.1565),(-0.1565,-0.0600,0.0000),(-0,-0.0600,-0.1565),(0.1044,-0.0600,-0.0522),(0.1044,-0.0600,-0.0000),(0.1044,0.0600,0.0000),(0.1044,0.0600,0.0522),(-0,0.0600,0.1565),(-0.1565,0.0600,0.0000),(-0,0.0600,-0.1565),(0.1044,0.0600,-0.0522),(0.1044,0.0600,0.0000),(0.0333,0.1000,0.0000),(0.0333,0.1000,0.0167),(-0,0.1000,0.0500),(-0.0500,0.1000,-0.0000),(0,0.1000,-0.0500),(0.0333,0.1000,-0.0167),(0.0333,0.1000,0.0000),(0,0.1000,-0.0000),(0,0.1000,-0.0000),(0,0.1000,-0.0000),(0,0.1000,-0.0000),(0,0.1000,-0.0000),(0,0.1000,-0.0000),(0,0.1000,-0.0000)])),
            appearance=Appearance(USE='eyecolor'))])])]),
    Transform(translation=(0,2.9132,0),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='HeadShape',solid=False,uClosed=True,uDimension=13,uKnot=[0,0,0,0,1,2,3,4,5,6,7,8,9,10,10,10,10],uOrder=4,vClosed=True,vDimension=11,vKnot=[0,0,0,0,1,2,3,4,5,6,7,8,8,8,8],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(-0.2526,-1.2107,-0.0000),(0.4701,-1.2107,0.0113),(0.4755,-1.2107,0.0787),(0.4447,-1.2107,0.2361),(0.3237,-1.3350,0.3490),(-0.3268,-1.3350,0.3490),(-0.4470,-1.2107,0.2361),(-0.4928,-1.2107,0.0000),(-0.4148,-1.2107,-0.1682),(-0.3145,-1.2107,-0.2659),(0.3113,-1.2107,-0.2659),(0.4123,-1.2107,-0.1682),(0.4647,-1.2107,-0.0561),(0.4701,-1.2107,0.0113),(0.7266,-1.0203,-0.0429),(0.7383,-1.0203,0.1241),(0.6717,-1.0203,0.3724),(0.4104,-1.0203,0.8563),(-0.4129,-1.0203,0.8563),(-0.6723,-1.0203,0.3724),(-0.7714,-1.0203,0.0000),(-0.4863,-1.0203,-0.5549),(-0.3864,-1.0203,-0.9418),(0.3837,-1.0203,-0.9418),(0.6019,-1.0203,-0.6296),(0.7150,-1.0203,-0.2099),(0.7266,-1.0203,-0.0429),(0.9179,-0.7455,-0.0117),(0.9522,-0.7455,0.1711),(0.8967,-0.7455,0.5132),(0.4964,-0.7455,0.9692),(-0.4979,-0.7455,0.9692),(-0.8952,-0.7455,0.5132),(-0.9826,-0.7455,-0.0000),(-0.6723,-0.7455,-0.6644),(-0.4573,-0.7455,-1.0041),(0.4556,-0.7455,-1.0041),(0.6908,-0.7455,-0.5832),(0.8836,-0.7455,-0.1944),(0.9179,-0.7455,-0.0117),(1.0269,-0.3926,0.0152),(1.0712,-0.3926,0.2112),(1.0015,-0.3926,0.6337),(0.5366,-0.3926,1.0820),(-0.5375,-0.3926,1.0820),(-0.9991,-0.3926,0.6337),(-1.1078,-0.3926,-0.0000),(-0.8173,-0.3926,-0.6590),(-0.4904,-0.3926,-1.0366),(0.4891,-0.3926,-1.0366),(0.7357,-0.3926,-0.5424),(0.9826,-0.3926,-0.1808),(1.0269,-0.3926,0.0152),(1.0748,0.0497,0.0423),(1.1111,0.0497,0.2116),(1.0354,0.0497,0.6247),(0.5495,0.0497,1.0931),(-0.5504,0.0497,1.0931),(-1.0328,0.0497,0.6247),(-1.1504,0.0497,0.0050),(-0.9403,0.0497,-0.4597),(-0.5011,0.0497,-0.6755),(0.4999,0.0497,-0.6755),(0.8174,0.0497,-0.3909),(1.0385,0.0497,-0.1269),(1.0748,0.0497,0.0423),(1.0336,0.4792,0.0268),(1.0660,0.4792,0.1848),(0.9938,0.4792,0.5539),(0.5335,0.4792,0.9460),(-0.5348,0.4792,0.9460),(-0.9918,0.4792,0.5539),(-1.1038,0.4792,0.0002),(-0.8946,0.4792,-0.4709),(-0.4882,0.4792,-0.6289),(0.4865,0.4792,-0.6289),(0.7996,0.4792,-0.3939),(1.0013,0.4792,-0.1312),(1.0336,0.4792,0.0268),(0.8889,0.7921,0.0195),(0.9080,0.7921,0.1497),(0.8544,0.7921,0.4486),(0.4802,0.7921,0.6608),(-0.4822,0.7921,0.6608),(-0.8537,0.7921,0.4486),(-0.9377,0.7921,0.0002),(-0.6822,0.7921,-0.2910),(-0.4442,0.7921,-0.5072),(0.4420,0.7921,-0.5072),(0.7399,0.7921,-0.3323),(0.8698,0.7921,-0.1106),(0.8889,0.7921,0.0195),(0.7227,0.9879,0.0178),(0.7213,0.9879,0.0943),(0.6571,0.9879,0.2823),(0.4048,1.0439,0.4063),(-0.4074,1.0439,0.4063),(-0.6578,0.9879,0.2823),(-0.7535,0.9879,0.0002),(-0.6196,0.9879,-0.1500),(-0.3818,1.0439,-0.2375),(0.3790,1.0439,-0.2375),(0.6652,0.9879,-0.1764),(0.7240,0.9879,-0.0586),(0.7227,0.9879,0.0178),(0.4015,1.0812,0.0041),(0.4052,1.0812,0.0240),(0.3840,1.0812,0.0716),(0.3005,1.0900,0.1157),(-0.3038,1.0966,0.1157),(-0.3867,1.0812,0.0716),(-0.4183,1.0812,0.0002),(-0.3645,1.0966,-0.0478),(-0.2953,1.0966,-0.0815),(0.2919,1.0900,-0.0815),(0.3616,1.0812,-0.0478),(0.3978,1.0812,-0.0158),(0.4015,1.0812,0.0041),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002),(0.2489,1.0900,0.0002)])),
            appearance=Appearance(USE='fur'))])])]),
    Transform(translation=(0,0.2316,0),
      children=[
      Transform(rotation=(0,1,0,3.1416),
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='Right_legShape',solid=False,uClosed=True,uDimension=11,uKnot=[0,0,0,0,1,2,3,4,5,6,7,8,8,8,8],uOrder=4,vClosed=True,vDimension=18,vKnot=[0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,15,15,15],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0.4103,-1.5447,0.0161),(-0.4074,-1.5465,0.0161),(-0.4016,-1.5502,0.0127),(-0.3980,-1.5525,0.0000),(-0.4016,-1.5502,-0.0127),(-0.4103,-1.5447,-0.0179),(-0.4190,-1.5391,-0.0127),(-0.4226,-1.5368,0.0000),(-0.4190,-1.5391,0.0127),(-0.4132,-1.5428,0.0161),(-0.4103,-1.5447,0.0161),(-0.4209,-1.5668,0.2905),(-0.3687,-1.6001,0.2905),(-0.2643,-1.6666,0.2276),(-0.1994,-1.7079,0.0000),(-0.2643,-1.6666,-0.2276),(-0.4209,-1.5668,-0.3219),(-0.5774,-1.4671,-0.2276),(-0.6423,-1.4257,0.0000),(-0.5774,-1.4671,0.2276),(-0.4731,-1.5336,0.2905),(-0.4209,-1.5668,0.2905),(-0.5109,-1.7554,0.5149),(-0.4184,-1.8143,0.5149),(-0.2334,-1.9322,0.4035),(-0.1184,-2.0055,0.0000),(-0.2334,-1.9322,-0.4035),(-0.5109,-1.7554,-0.5706),(-0.7884,-1.5785,-0.4035),(-0.9034,-1.5052,0.0000),(-0.7884,-1.5785,0.4035),(-0.6034,-1.6964,0.5149),(-0.5109,-1.7554,0.5149),(-0.6463,-2.0990,0.6147),(-0.5383,-2.1743,0.6147),(-0.3223,-2.3248,0.4816),(-0.1880,-2.4183,0.0000),(-0.3223,-2.3248,-0.4816),(-0.6463,-2.0990,-0.6812),(-0.9704,-1.8732,-0.4816),(-1.1046,-1.7797,0.0000),(-0.9704,-1.8732,0.4816),(-0.7544,-2.0238,0.6147),(-0.6463,-2.0990,0.6147),(-0.7672,-2.5309,0.6645),(-0.6349,-2.5726,0.6645),(-0.3703,-2.6559,0.5207),(-0.2059,-2.7076,0.0000),(-0.3703,-2.6559,-0.5207),(-0.7672,-2.5309,-0.7364),(-1.1642,-2.4059,-0.5207),(-1.3286,-2.3541,0.0000),(-1.1642,-2.4059,0.5207),(-0.8996,-2.4892,0.6645),(-0.7672,-2.5309,0.6645),(-0.8267,-3.2419,0.8516),(-0.6778,-3.2419,0.8516),(-0.3799,-3.2419,0.6970),(-0.1949,-3.2419,0.1372),(-0.3799,-3.2419,-0.3853),(-0.8267,-3.2419,-0.6171),(-1.2734,-3.2419,-0.3853),(-1.4584,-3.2419,0.1372),(-1.2734,-3.2419,0.6970),(-0.9756,-3.2419,0.8516),(-0.8267,-3.2419,0.8516),(-0.8267,-3.8778,0.8890),(-0.6700,-3.8778,0.8890),(-0.3565,-3.8778,0.7263),(-0.1618,-3.8778,0.1372),(-0.3565,-3.8778,-0.3647),(-0.8267,-3.8778,-0.6087),(-1.2968,-3.8778,-0.3647),(-1.4915,-3.8778,0.1372),(-1.2968,-3.8778,0.7263),(-0.9834,-3.8778,0.8890),(-0.8267,-3.8778,0.8890),(-0.8267,-4.4389,0.8727),(-0.6778,-4.4389,0.8727),(-0.3799,-4.4389,0.7181),(-0.2620,-4.4389,0.0000),(-0.4038,-4.4389,-0.4635),(-0.8267,-4.4389,-0.6795),(-1.2734,-4.4389,-0.4476),(-1.4584,-4.4389,0.0000),(-1.2734,-4.4389,0.7181),(-0.9756,-4.4389,0.8727),(-0.8267,-4.4389,0.8727),(-0.8287,-4.6634,0.8910),(-0.6629,-4.6634,0.8910),(-0.3314,-4.6634,0.6282),(-0.2472,-4.6634,0.0000),(-0.4007,-4.6634,-0.4576),(-0.8287,-4.6634,-0.7351),(-1.3260,-4.6634,-0.4255),(-1.4377,-4.6634,0.0000),(-1.3260,-4.6634,0.6282),(-0.9944,-4.6634,0.8910),(-0.8287,-4.6634,0.8910),(-0.8280,-4.7844,1.1858),(-0.6370,-4.7844,1.1857),(-0.2571,-4.7844,0.9698),(-0.2543,-4.7844,-0.0006),(-0.3979,-4.7844,-0.4732),(-0.8279,-4.7844,-0.7255),(-1.3649,-4.7844,-0.4474),(-1.4341,-4.7844,0.0006),(-1.4030,-4.7844,0.9706),(-1.0190,-4.7844,1.1859),(-0.8280,-4.7844,1.1858),(-0.8370,-4.9167,1.5417),(-0.6494,-4.9167,1.5414),(-0.3066,-4.9167,1.2532),(-0.2023,-4.9167,-0.0014),(-0.3864,-4.9313,-0.5023),(-0.8233,-4.9167,-0.7068),(-1.3872,-4.9123,-0.4712),(-1.4744,-4.9167,0.0014),(-1.4319,-4.9167,1.2551),(-1.0245,-4.9167,1.5420),(-0.8370,-4.9167,1.5417),(-0.8307,-5.0470,1.8458),(-0.6315,-5.0470,1.8448),(-0.2681,-5.0470,1.6206),(-0.2084,-5.0470,-0.0042),(-0.3910,-5.0470,-0.5250),(-0.8209,-5.0470,-0.6885),(-1.3988,-5.0470,-0.4952),(-1.5223,-5.0470,0.0042),(-1.4631,-5.0470,1.6265),(-1.0298,-5.0470,1.8468),(-0.8307,-5.0470,1.8458),(-0.8379,-5.4281,1.9794),(-0.6353,-5.4281,1.9794),(-0.2579,-5.3367,1.6698),(-0.1904,-5.3367,0.0000),(-0.3984,-5.3367,-0.5293),(-0.8240,-5.3367,-0.7010),(-1.3989,-5.3367,-0.5101),(-1.5225,-5.3367,-0.0000),(-1.4737,-5.3367,1.6698),(-1.0406,-5.4281,1.9794),(-0.8379,-5.4281,1.9794),(-0.8332,-5.8709,1.8393),(-0.6514,-5.8709,1.8393),(-0.3035,-5.8355,1.6159),(-0.2931,-5.8604,0.0000),(-0.3987,-5.7606,-0.5182),(-0.8253,-5.8753,-0.6594),(-1.3606,-5.7606,-0.4978),(-1.4441,-5.8604,-0.0000),(-1.3946,-5.8355,1.6159),(-1.0151,-5.8709,1.8393),(-0.8332,-5.8709,1.8393),(-0.8347,-5.8834,1.6636),(-0.6597,-5.8834,1.6636),(-0.3284,-5.8479,1.4235),(-0.3099,-5.8729,0.0000),(-0.4000,-5.7731,-0.5175),(-0.8253,-5.8878,-0.6024),(-1.3526,-5.7731,-0.4970),(-1.4209,-5.8729,-0.0000),(-1.3782,-5.8479,1.4235),(-1.0096,-5.8834,1.6636),(-0.8347,-5.8834,1.6636),(-0.8302,-5.9416,1.1858),(-0.6708,-5.9416,1.1858),(-0.3616,-5.8729,0.9702),(-0.3307,-5.8729,0.0000),(-0.4024,-5.7731,-0.5160),(-0.8253,-5.8878,-0.5941),(-1.3234,-5.7731,-0.4953),(-1.3672,-5.8729,-0.0000),(-1.3179,-5.8729,0.9702),(-0.9895,-5.9416,1.1858),(-0.8302,-5.9416,1.1858),(-0.8253,-5.9759,0.5024),(-0.7515,-5.9759,0.5024),(-0.6037,-5.9759,0.3937),(-0.5119,-5.9759,0.0000),(-0.6037,-5.9510,-0.2166),(-0.8253,-5.9510,-0.3619),(-1.0470,-5.9510,-0.2166),(-1.1388,-5.9759,0.0000),(-1.0470,-5.9759,0.3937),(-0.8992,-5.9759,0.5024),(-0.8253,-5.9759,0.5024),(-0.8253,-5.9884,-0.0088),(-0.8266,-5.9884,-0.0088),(-0.8292,-5.9884,-0.0069),(-0.8308,-5.9884,0.0000),(-0.8292,-5.9884,0.0069),(-0.8253,-5.9884,0.0097),(-0.8215,-5.9884,0.0069),(-0.8199,-5.9884,0.0000),(-0.8215,-5.9884,-0.0069),(-0.8241,-5.9884,-0.0088),(-0.8253,-5.9884,-0.0088)])),
            appearance=Appearance(USE='fur'))])])]),
    Transform(translation=(0,0.2316,0),
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='Left_legShape',solid=False,uClosed=True,uDimension=11,uKnot=[0,0,0,0,1,2,3,4,5,6,7,8,8,8,8],uOrder=4,vClosed=True,vDimension=18,vKnot=[0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,15,15,15],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-0.4697,-1.5427,-0.0161),(-0.4668,-1.5444,-0.0161),(-0.4608,-1.5479,-0.0127),(-0.4572,-1.5501,-0.0000),(-0.4608,-1.5479,0.0127),(-0.4697,-1.5427,0.0179),(-0.4786,-1.5375,0.0127),(-0.4823,-1.5353,0.0000),(-0.4786,-1.5375,-0.0127),(-0.4727,-1.5409,-0.0161),(-0.4697,-1.5427,-0.0161),(-0.4795,-1.5652,-0.2905),(-0.4262,-1.5966,-0.2905),(-0.3195,-1.6594,-0.2276),(-0.2533,-1.6984,-0.0000),(-0.3195,-1.6594,0.2276),(-0.4795,-1.5652,0.3219),(-0.6395,-1.4711,0.2276),(-0.7058,-1.4321,0.0000),(-0.6395,-1.4711,-0.2276),(-0.5329,-1.5338,-0.2905),(-0.4795,-1.5652,-0.2905),(-0.5628,-1.7568,-0.5149),(-0.4683,-1.8125,-0.5149),(-0.2792,-1.9238,-0.4035),(-0.1617,-1.9929,-0.0000),(-0.2792,-1.9238,0.4035),(-0.5628,-1.7568,0.5706),(-0.8465,-1.5899,0.4035),(-0.9640,-1.5208,0.0000),(-0.8465,-1.5899,-0.4035),(-0.6574,-1.7012,-0.5149),(-0.5628,-1.7568,-0.5149),(-0.6860,-2.1051,-0.6147),(-0.5754,-2.1765,-0.6147),(-0.3541,-2.3192,-0.4816),(-0.2166,-2.4079,-0.0000),(-0.3541,-2.3192,0.4816),(-0.6860,-2.1051,0.6812),(-1.0179,-1.8909,0.4816),(-1.1553,-1.8022,0.0000),(-1.0179,-1.8909,-0.4816),(-0.7966,-2.0337,-0.6147),(-0.6860,-2.1051,-0.6147),(-0.7915,-2.5410,-0.6645),(-0.6578,-2.5779,-0.6645),(-0.3904,-2.6518,-0.5207),(-0.2243,-2.6977,-0.0000),(-0.3904,-2.6518,0.5207),(-0.7915,-2.5410,0.7364),(-1.1926,-2.4301,0.5207),(-1.3587,-2.3842,0.0000),(-1.1926,-2.4301,-0.5207),(-0.9252,-2.5040,-0.6645),(-0.7915,-2.5410,-0.6645),(-0.8267,-3.2419,-0.8516),(-0.6778,-3.2419,-0.8516),(-0.3799,-3.2419,-0.6970),(-0.1949,-3.2419,-0.1372),(-0.3799,-3.2419,0.3853),(-0.8267,-3.2419,0.6171),(-1.2734,-3.2419,0.3853),(-1.4584,-3.2419,-0.1372),(-1.2734,-3.2419,-0.6970),(-0.9756,-3.2419,-0.8516),(-0.8267,-3.2419,-0.8516),(-0.8267,-3.8778,-0.8890),(-0.6700,-3.8778,-0.8890),(-0.3565,-3.8778,-0.7263),(-0.1618,-3.8778,-0.1372),(-0.3565,-3.8778,0.3647),(-0.8267,-3.8778,0.6087),(-1.2968,-3.8778,0.3647),(-1.4915,-3.8778,-0.1372),(-1.2968,-3.8778,-0.7263),(-0.9834,-3.8778,-0.8890),(-0.8267,-3.8778,-0.8890),(-0.8267,-4.4389,-0.8727),(-0.6778,-4.4389,-0.8727),(-0.3799,-4.4389,-0.7181),(-0.2620,-4.4389,-0.0000),(-0.4038,-4.4389,0.4635),(-0.8267,-4.4389,0.6795),(-1.2734,-4.4389,0.4476),(-1.4584,-4.4389,0.0000),(-1.2734,-4.4389,-0.7181),(-0.9756,-4.4389,-0.8727),(-0.8267,-4.4389,-0.8727),(-0.8287,-4.6634,-0.8910),(-0.6629,-4.6634,-0.8910),(-0.3314,-4.6634,-0.6282),(-0.2472,-4.6634,-0.0000),(-0.4007,-4.6634,0.4576),(-0.8287,-4.6634,0.7351),(-1.3260,-4.6634,0.4255),(-1.4377,-4.6634,0.0000),(-1.3260,-4.6634,-0.6282),(-0.9944,-4.6634,-0.8910),(-0.8287,-4.6634,-0.8910),(-0.8280,-4.7844,-1.1858),(-0.6370,-4.7844,-1.1857),(-0.2571,-4.7844,-0.9698),(-0.2543,-4.7844,0.0006),(-0.3979,-4.7844,0.4732),(-0.8279,-4.7844,0.7255),(-1.3649,-4.7844,0.4474),(-1.4341,-4.7844,-0.0006),(-1.4030,-4.7844,-0.9706),(-1.0190,-4.7844,-1.1859),(-0.8280,-4.7844,-1.1858),(-0.8370,-4.9167,-1.5417),(-0.6494,-4.9167,-1.5414),(-0.3066,-4.9167,-1.2532),(-0.2023,-4.9167,0.0014),(-0.3864,-4.9313,0.5023),(-0.8233,-4.9167,0.7068),(-1.3872,-4.9123,0.4712),(-1.4744,-4.9167,-0.0014),(-1.4319,-4.9167,-1.2551),(-1.0245,-4.9167,-1.5420),(-0.8370,-4.9167,-1.5417),(-0.8307,-5.0470,-1.8458),(-0.6315,-5.0470,-1.8448),(-0.2681,-5.0470,-1.6206),(-0.2084,-5.0470,0.0042),(-0.3910,-5.0470,0.5250),(-0.8209,-5.0470,0.6885),(-1.3988,-5.0470,0.4952),(-1.5223,-5.0470,-0.0042),(-1.4631,-5.0470,-1.6265),(-1.0298,-5.0470,-1.8468),(-0.8307,-5.0470,-1.8458),(-0.8379,-5.4281,-1.9794),(-0.6353,-5.4281,-1.9794),(-0.2579,-5.3367,-1.6698),(-0.1904,-5.3367,-0.0000),(-0.3984,-5.3367,0.5293),(-0.8240,-5.3367,0.7010),(-1.3989,-5.3367,0.5101),(-1.5225,-5.3367,0.0000),(-1.4737,-5.3367,-1.6698),(-1.0406,-5.4281,-1.9794),(-0.8379,-5.4281,-1.9794),(-0.8332,-5.8709,-1.8393),(-0.6514,-5.8709,-1.8393),(-0.3035,-5.8355,-1.6159),(-0.2931,-5.8604,-0.0000),(-0.3987,-5.7606,0.5182),(-0.8253,-5.8753,0.6594),(-1.3606,-5.7606,0.4978),(-1.4441,-5.8604,0.0000),(-1.3946,-5.8355,-1.6159),(-1.0151,-5.8709,-1.8393),(-0.8332,-5.8709,-1.8393),(-0.8347,-5.8834,-1.6636),(-0.6597,-5.8834,-1.6636),(-0.3284,-5.8479,-1.4235),(-0.3099,-5.8729,-0.0000),(-0.4000,-5.7731,0.5175),(-0.8253,-5.8878,0.6024),(-1.3526,-5.7731,0.4970),(-1.4209,-5.8729,0.0000),(-1.3782,-5.8479,-1.4235),(-1.0096,-5.8834,-1.6636),(-0.8347,-5.8834,-1.6636),(-0.8302,-5.9416,-1.1858),(-0.6708,-5.9416,-1.1858),(-0.3616,-5.8729,-0.9702),(-0.3307,-5.8729,-0.0000),(-0.4024,-5.7731,0.5160),(-0.8253,-5.8878,0.5941),(-1.3234,-5.7731,0.4953),(-1.3672,-5.8729,0.0000),(-1.3179,-5.8729,-0.9702),(-0.9895,-5.9416,-1.1858),(-0.8302,-5.9416,-1.1858),(-0.8253,-5.9759,-0.5024),(-0.7515,-5.9759,-0.5024),(-0.6037,-5.9759,-0.3937),(-0.5119,-5.9759,-0.0000),(-0.6037,-5.9510,0.2166),(-0.8253,-5.9510,0.3619),(-1.0470,-5.9510,0.2166),(-1.1388,-5.9759,0.0000),(-1.0470,-5.9759,-0.3937),(-0.8992,-5.9759,-0.5024),(-0.8253,-5.9759,-0.5024),(-0.8253,-5.9884,0.0088),(-0.8266,-5.9884,0.0088),(-0.8292,-5.9884,0.0069),(-0.8308,-5.9884,0.0000),(-0.8292,-5.9884,-0.0069),(-0.8253,-5.9884,-0.0097),(-0.8215,-5.9884,-0.0069),(-0.8199,-5.9884,-0.0000),(-0.8215,-5.9884,0.0069),(-0.8241,-5.9884,0.0088),(-0.8253,-5.9884,0.0088)])),
            appearance=Appearance(USE='fur'))])])]),
    Transform(translation=(-0,0,0),
      children=[
      Transform(rotation=(0,1,0,3.1416),
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='Right_armShape',solid=False,uClosed=True,uDimension=13,uKnot=[0,0,0,0,1,2,3,4,5,6,7,8,9,10,10,10,10],uOrder=4,vClosed=True,vDimension=11,vKnot=[0,0,0,0,1,2,3,4,5,6,7,8,8,8,8],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.3233,-1.4103,2.2564),(-1.2827,-1.4144,2.2564),(-1.2839,-1.4264,2.2545),(-1.2919,-1.4498,2.2507),(-1.3158,-1.4699,2.2472),(-1.3906,-1.4624,2.2522),(-1.5630,-1.4344,2.2549),(-1.5811,-1.3962,2.2594),(-1.5558,-1.3624,2.2639),(-1.3612,-1.3476,2.2666),(-1.3041,-1.3534,2.2657),(-1.2846,-1.3778,2.2621),(-1.2815,-1.4024,2.2583),(-1.2827,-1.4144,2.2564),(-1.2355,-1.3973,2.1961),(-1.2391,-1.4336,2.1903),(-1.2546,-1.5053,2.1788),(-1.2984,-1.5688,2.1681),(-1.5891,-1.5514,2.1903),(-1.7539,-1.4669,2.1986),(-1.8084,-1.3515,2.2121),(-1.7319,-1.2493,2.2257),(-1.5536,-1.1993,2.2340),(-1.2629,-1.2167,2.2240),(-1.2327,-1.2877,2.2133),(-1.2318,-1.3611,2.2018),(-1.2355,-1.3973,2.1961),(-1.1873,-1.3263,1.5013),(-1.2032,-1.3923,1.4770),(-1.2903,-1.5188,1.4285),(-1.4079,-1.6323,1.3835),(-1.6776,-1.6051,1.3835),(-1.8833,-1.4590,1.4285),(-1.9464,-1.2498,1.5013),(-1.8428,-1.0574,1.5741),(-1.6121,-0.9552,1.6190),(-1.3247,-0.9842,1.6190),(-1.1948,-1.1227,1.5741),(-1.1713,-1.2603,1.5255),(-1.1873,-1.3263,1.5013),(-1.1720,-1.1883,0.6198),(-1.1808,-1.2758,0.5881),(-1.2334,-1.4473,0.5247),(-1.3657,-1.5978,0.4659),(-1.7120,-1.5629,0.4659),(-1.9758,-1.3724,0.5247),(-2.0564,-1.0992,0.6198),(-1.9230,-0.8476,0.7149),(-1.6265,-0.7136,0.7737),(-1.2802,-0.7485,0.7737),(-1.1805,-0.9224,0.7149),(-1.1632,-1.1008,0.6515),(-1.1720,-1.1883,0.6198),(-1.0853,-0.5402,-0.1250),(-1.0912,-0.5982,-0.2240),(-1.1431,-0.7340,-0.4847),(-1.2761,-0.8513,-0.7265),(-1.6509,-0.8135,-0.7265),(-1.9411,-0.6536,-0.4847),(-2.0358,-0.4326,-0.0936),(-1.9060,-0.3053,0.1089),(-1.5898,-0.2064,0.3506),(-1.2149,-0.2442,0.3506),(-1.1080,-0.3857,0.1089),(-1.0795,-0.4821,-0.0261),(-1.0853,-0.5402,-0.1250),(-0.8739,0.3137,-0.2157),(-0.8739,0.3137,-0.3296),(-0.9046,0.3308,-0.5575),(-1.0065,0.3874,-0.7688),(-1.3107,0.5565,-0.7688),(-1.5568,0.6933,-0.5575),(-1.6508,0.7456,-0.2157),(-1.5568,0.6933,0.1261),(-1.3107,0.5565,0.3374),(-1.0065,0.3874,0.3374),(-0.9046,0.3308,0.1261),(-0.8739,0.3137,-0.1018),(-0.8739,0.3137,-0.2157),(-0.4867,1.1352,-0.0936),(-0.4867,1.1352,-0.1983),(-0.5102,1.1483,-0.4076),(-0.6019,1.1993,-0.6017),(-0.8347,1.3287,-0.6017),(-1.0231,1.4333,-0.4076),(-1.0950,1.4733,-0.0936),(-1.0231,1.4333,0.2204),(-0.8347,1.3287,0.4145),(-0.6019,1.1993,0.4145),(-0.5102,1.1483,0.2204),(-0.4867,1.1352,0.0111),(-0.4867,1.1352,-0.0936),(-0.1939,1.4970,-0.0936),(-0.1939,1.4970,-0.2020),(-0.2121,1.5205,-0.4187),(-0.2836,1.6128,-0.6196),(-0.3720,1.7268,-0.6196),(-0.4435,1.8191,-0.4187),(-0.4708,1.8544,-0.0936),(-0.4435,1.8191,0.2315),(-0.3720,1.7268,0.4324),(-0.2836,1.6128,0.4324),(-0.2121,1.5205,0.2315),(-0.1939,1.4970,0.0148),(-0.1939,1.4970,-0.0936),(-0.1715,1.6994,-0.0936),(-0.1715,1.6994,-0.1295),(-0.1775,1.7072,-0.2012),(-0.2011,1.7377,-0.2677),(-0.2304,1.7755,-0.2677),(-0.2540,1.8060,-0.2012),(-0.2631,1.8177,-0.0936),(-0.2540,1.8060,0.0140),(-0.2304,1.7755,0.0805),(-0.2011,1.7377,0.0805),(-0.1775,1.7072,0.0140),(-0.1715,1.6994,-0.0577),(-0.1715,1.6994,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936),(-0.2158,1.7566,-0.0936)])),
            appearance=Appearance(USE='fur'))])])]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='Left_armShape',solid=False,uClosed=True,uDimension=13,uKnot=[0,0,0,0,1,2,3,4,5,6,7,8,9,10,10,10,10],uOrder=4,vClosed=True,vDimension=11,vKnot=[0,0,0,0,1,2,3,4,5,6,7,8,8,8,8],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.3233,-1.4103,-2.2564),(-1.2827,-1.4144,-2.2564),(-1.2839,-1.4264,-2.2545),(-1.2919,-1.4498,-2.2507),(-1.3158,-1.4699,-2.2472),(-1.3906,-1.4624,-2.2522),(-1.5630,-1.4344,-2.2549),(-1.5811,-1.3962,-2.2594),(-1.5558,-1.3624,-2.2639),(-1.3612,-1.3476,-2.2666),(-1.3041,-1.3534,-2.2657),(-1.2846,-1.3778,-2.2621),(-1.2815,-1.4024,-2.2583),(-1.2827,-1.4144,-2.2564),(-1.2355,-1.3973,-2.1961),(-1.2391,-1.4336,-2.1903),(-1.2546,-1.5053,-2.1788),(-1.2984,-1.5688,-2.1681),(-1.5891,-1.5514,-2.1903),(-1.7539,-1.4669,-2.1986),(-1.8084,-1.3515,-2.2121),(-1.7319,-1.2493,-2.2257),(-1.5536,-1.1993,-2.2340),(-1.2629,-1.2167,-2.2240),(-1.2327,-1.2877,-2.2133),(-1.2318,-1.3611,-2.2018),(-1.2355,-1.3973,-2.1961),(-1.1873,-1.3263,-1.5013),(-1.2032,-1.3923,-1.4770),(-1.2903,-1.5188,-1.4285),(-1.4079,-1.6323,-1.3835),(-1.6776,-1.6051,-1.3835),(-1.8833,-1.4590,-1.4285),(-1.9464,-1.2498,-1.5013),(-1.8428,-1.0574,-1.5741),(-1.6121,-0.9552,-1.6190),(-1.3247,-0.9842,-1.6190),(-1.1948,-1.1227,-1.5741),(-1.1713,-1.2603,-1.5255),(-1.1873,-1.3263,-1.5013),(-1.1720,-1.1883,-0.6198),(-1.1808,-1.2758,-0.5881),(-1.2334,-1.4473,-0.5247),(-1.3657,-1.5978,-0.4659),(-1.7120,-1.5629,-0.4659),(-1.9758,-1.3724,-0.5247),(-2.0564,-1.0992,-0.6198),(-1.9230,-0.8476,-0.7149),(-1.6265,-0.7136,-0.7737),(-1.2802,-0.7485,-0.7737),(-1.1805,-0.9224,-0.7149),(-1.1632,-1.1008,-0.6515),(-1.1720,-1.1883,-0.6198),(-1.0853,-0.5402,0.1250),(-1.0912,-0.5982,0.2240),(-1.1431,-0.7340,0.4847),(-1.2761,-0.8513,0.7265),(-1.6509,-0.8135,0.7265),(-1.9411,-0.6536,0.4847),(-2.0358,-0.4326,0.0936),(-1.9060,-0.3053,-0.1089),(-1.5898,-0.2064,-0.3506),(-1.2149,-0.2442,-0.3506),(-1.1080,-0.3857,-0.1089),(-1.0795,-0.4821,0.0261),(-1.0853,-0.5402,0.1250),(-0.8739,0.3137,0.2157),(-0.8739,0.3137,0.3296),(-0.9046,0.3308,0.5575),(-1.0065,0.3874,0.7688),(-1.3107,0.5565,0.7688),(-1.5568,0.6933,0.5575),(-1.6508,0.7456,0.2157),(-1.5568,0.6933,-0.1261),(-1.3107,0.5565,-0.3374),(-1.0065,0.3874,-0.3374),(-0.9046,0.3308,-0.1261),(-0.8739,0.3137,0.1018),(-0.8739,0.3137,0.2157),(-0.4867,1.1352,0.0936),(-0.4867,1.1352,0.1983),(-0.5102,1.1483,0.4076),(-0.6019,1.1993,0.6017),(-0.8347,1.3287,0.6017),(-1.0231,1.4333,0.4076),(-1.0950,1.4733,0.0936),(-1.0231,1.4333,-0.2204),(-0.8347,1.3287,-0.4145),(-0.6019,1.1993,-0.4145),(-0.5102,1.1483,-0.2204),(-0.4867,1.1352,-0.0111),(-0.4867,1.1352,0.0936),(-0.1939,1.4970,0.0936),(-0.1939,1.4970,0.2020),(-0.2121,1.5205,0.4187),(-0.2836,1.6128,0.6196),(-0.3720,1.7268,0.6196),(-0.4435,1.8191,0.4187),(-0.4708,1.8544,0.0936),(-0.4435,1.8191,-0.2315),(-0.3720,1.7268,-0.4324),(-0.2836,1.6128,-0.4324),(-0.2121,1.5205,-0.2315),(-0.1939,1.4970,-0.0148),(-0.1939,1.4970,0.0936),(-0.1715,1.6994,0.0936),(-0.1715,1.6994,0.1295),(-0.1775,1.7072,0.2012),(-0.2011,1.7377,0.2677),(-0.2304,1.7755,0.2677),(-0.2540,1.8060,0.2012),(-0.2631,1.8177,0.0936),(-0.2540,1.8060,-0.0140),(-0.2304,1.7755,-0.0805),(-0.2011,1.7377,-0.0805),(-0.1775,1.7072,-0.0140),(-0.1715,1.6994,0.0577),(-0.1715,1.6994,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936),(-0.2158,1.7566,0.0936)])),
            appearance=Appearance(USE='fur'))])])]),
    Transform(
      children=[
      Transform(
        children=[
        Transform(
          children=[
          Shape(
            #  ccw ="false" 
            geometry=NurbsPatchSurface(DEF='BodyShape',solid=False,uClosed=True,uDimension=13,uKnot=[0,0,0,0,1,2,3,4,5,6,7,8,9,10,10,10,10],uOrder=4,vClosed=True,vDimension=11,vKnot=[0,0,0,0,1,2,3,4,5,6,7,8,8,8,8],vOrder=4,weight=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
              controlPoint=Coordinate(point=[(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0,-2.0387,0.0508),(0.1286,-2.0387,0.0541),(0.1286,-2.0387,0.1024),(0.1111,-2.0387,0.2055),(0.0424,-2.0387,0.3011),(-0.0424,-2.0387,0.3011),(-0.1111,-2.0387,0.2055),(-0.1374,-2.0387,0.0508),(-0.1111,-2.0387,-0.0839),(-0.0424,-2.0387,-0.1356),(0.0424,-2.0387,-0.1356),(0.1111,-2.0387,-0.0839),(0.1286,-2.0387,0.0059),(0.1286,-2.0387,0.0541),(0.3887,-2.0455,0.0679),(0.3887,-2.0455,0.1862),(0.3358,-2.0455,0.4571),(0.1283,-2.0455,0.6294),(-0.1283,-2.0455,0.6294),(-0.3358,-2.0455,0.4571),(-0.4151,-2.0455,0.0508),(-0.3358,-2.0455,-0.2529),(-0.1283,-2.0455,-0.4091),(0.1283,-2.0455,-0.4091),(0.3358,-2.0455,-0.2529),(0.3887,-2.0455,-0.0504),(0.3887,-2.0455,0.0679),(0.7851,-2.0056,0.0716),(0.7851,-2.0056,0.2648),(0.6783,-2.0056,0.6928),(0.2367,-1.7408,1.1029),(-0.2367,-1.7408,1.1029),(-0.6783,-2.0056,0.6928),(-0.8385,-2.0056,0.0508),(-0.6783,-2.0056,-0.4666),(-0.2367,-1.7408,-0.7549),(0.2367,-1.7408,-0.7549),(0.6783,-2.0056,-0.4666),(0.7851,-2.0056,-0.1217),(0.7851,-2.0056,0.0716),(0.9374,-0.9383,0.0222),(0.9374,-0.9383,0.2429),(0.8100,-0.9383,0.7137),(0.3094,-0.9383,1.0301),(-0.3094,-0.9383,1.0301),(-0.8100,-0.9383,0.7137),(-1.0012,-0.9383,0.0075),(-0.8100,-0.9383,-0.6107),(-0.3094,-0.9383,-0.9881),(0.3094,-0.9383,-0.9881),(0.8100,-0.9383,-0.6107),(0.9374,-0.9383,-0.1985),(0.9374,-0.9383,0.0222),(1.0146,0.0085,-0.0049),(1.0146,0.0085,0.2040),(0.8767,0.0085,0.5925),(0.3349,0.0085,0.8593),(-0.3349,0.0085,0.8593),(-0.8767,0.0085,0.5925),(-1.0836,0.0085,0.0097),(-0.8767,0.0085,-0.6610),(-0.3349,0.0085,-1.0695),(0.3349,0.0085,-1.0695),(0.8767,0.0085,-0.6610),(1.0146,0.0085,-0.2139),(1.0146,0.0085,-0.0049),(0.9374,0.9552,-0.0029),(0.9374,0.9552,0.1933),(0.8100,0.9552,0.5660),(0.3094,0.9552,0.8166),(-0.3094,0.9552,0.8166),(-0.8100,0.9552,0.5660),(-1.0012,0.9552,0.0069),(-0.8100,0.9552,-0.6107),(-0.3094,0.9552,-0.9881),(0.3094,0.9552,-0.9881),(0.8100,0.9552,-0.6107),(0.9374,0.9552,-0.1990),(0.9374,0.9552,-0.0029),(0.5460,1.7578,-0.0199),(0.5460,1.7578,0.1159),(0.4717,1.7578,0.3478),(0.2367,1.7578,0.5004),(-0.2367,1.7578,0.5004),(-0.4717,1.7578,0.3478),(-0.5831,1.7578,-0.0000),(-0.4717,1.7578,-0.4673),(-0.2367,1.7578,-0.7561),(0.2367,1.7578,-0.7561),(0.4717,1.7578,-0.4673),(0.5460,1.7578,-0.1558),(0.5460,1.7578,-0.0199),(0.3887,1.7945,-0.0055),(0.3887,1.7945,0.0733),(0.3358,1.7945,0.2200),(0.1283,1.7945,0.3134),(-0.1283,1.7945,0.3134),(-0.3358,1.7945,0.2200),(-0.4151,1.7945,-0.0000),(-0.3358,1.7945,-0.2532),(-0.1283,1.7945,-0.4097),(0.1283,1.7945,-0.4097),(0.3358,1.7945,-0.2532),(0.3887,1.7945,-0.0844),(0.3887,1.7945,-0.0055),(0.1286,1.8243,0.0000),(0.1286,1.8243,0.0279),(0.1111,1.8243,0.0838),(0.0424,1.8243,0.1356),(-0.0424,1.8243,0.1356),(-0.1111,1.8243,0.0838),(-0.1374,1.8243,-0.0000),(-0.1111,1.8243,-0.0838),(-0.0424,1.8243,-0.1356),(0.0424,1.8243,-0.1356),(0.1111,1.8243,-0.0838),(0.1286,1.8243,-0.0279),(0.1286,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000),(-0,1.8243,0.0000)])),
            appearance=Appearance(USE='fur'))])])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for FredTheBunny.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python FredTheBunny.py load and self-test diagnostics complete.")
