package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.NURBS.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Nurbs exemplar using NurbsPatchSurface that shows four duck models. </p>
 <p> Related links: Catalog page <a href="../../../NURBS/FourDucksIndex.html" target="_blank">FourDucks</a>,  source <a href="../../../NURBS/FourDucks.java">FourDucks.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/FourDucks.x3d">FourDucks.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Nurbs exemplar using NurbsPatchSurface that shows four duck models </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Blaxxun Example, modified by Jeffrey Weekley and Charles Adams. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Xeena VRML importer, X3D-Edit 3.1, <a href="https://www.web3d.org/x3d/content/README.X3D-Edit.html" target="_blank">https://www.web3d.org/x3d/content/README.X3D-Edit.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 3 February 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> possible error in definition of head, see FourDucksView3dscene.png, H3DViewer crashes </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/FourDucksBSContact.png">images/FourDucksBSContact.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/FourDucksInstantReality.png">images/FourDucksInstantReality.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/FourDucksOctagaVS.png">images/FourDucksOctagaVS.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/FourDucksView3dscene.png">images/FourDucksView3dscene.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/FourDucksXj3D.png">images/FourDucksXj3D.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> NURBS ducks </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/FourDucks.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/FourDucks.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Blaxxun Example, modified by Jeffrey Weekley and Charles Adams.
 */

public class FourDucks
{
	/** Default constructor to create this object. */
	public FourDucks ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addComponent(new component().setName("NURBS").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("FourDucks.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Nurbs exemplar using NurbsPatchSurface that shows four duck models"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Blaxxun Example, modified by Jeffrey Weekley and Charles Adams."))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Xeena VRML importer, X3D-Edit 3.1, https://www.web3d.org/x3d/content/README.X3D-Edit.html"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("3 February 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("possible error in definition of head, see FourDucksView3dscene.png, H3DViewer crashes"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/FourDucksBSContact.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/FourDucksInstantReality.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/FourDucksOctagaVS.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/FourDucksView3dscene.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/FourDucksXj3D.png"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("NURBS ducks"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/FourDucks.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("FourDucks.x3d"))
    .addChild(new Viewpoint().setDescription("Four NURBS Ducks").setOrientation(1.0,0.0,0.0,-0.2783).setPosition(0.0,4.0,14.0))
    .addChild(new Background().setSkyColor(new MFColor(new double[] {0.1,0.1,0.3})))
    .addChild(new Transform("Base").setRotation(1.0,0.0,0.0,-1.57).setScale(10.0,10.0,10.0).setTranslation(-15.0,0.0,15.0)
      .addChild(new Collision().setEnabled(false)
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material().setDiffuseColor(0.0,0.0,1.0).setSpecularColor(1.0,1.0,1.0).setTransparency(0.5)))
          .addComments(" ccw =\"false\" ")
          .setGeometry(new NurbsPatchSurface("nurb").setSolid(false).setUDimension(4).setUKnot(new double[] {0.0,0.0,0.0,0.0,3.0,3.0,3.0,3.0}).setUOrder(4).setUTessellation(16).setVDimension(4).setVKnot(new double[] {0.0,0.0,0.0,0.0,3.0,3.0,3.0,3.0}).setVOrder(4).setVTessellation(16).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,2.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {0.0,0.0,0.0,1.0,0.0,0.0,2.0,0.0,0.0,3.0,0.0,0.0,0.0,1.0,0.0,1.0,1.0,0.0,2.0,1.0,0.0,3.0,1.0,0.0,0.0,2.0,0.0,1.0,2.0,0.0,2.0,2.0,0.0,3.0,2.0,0.0,0.0,3.0,0.0,1.0,3.0,0.0,2.0,3.0,0.0,3.0,3.0,0.0})))))))
    .addChild(new Transform().setTranslation(4.0,0.0,4.0)
      .addChild(new Transform("ns").setRotation(1.0,0.0,0.0,-1.57).setScale(0.01,0.01,0.01)
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material().setDiffuseColor(0.760784,0.843137,0.196078).setShininess(0.25).setSpecularColor(0.9,0.9,0.9)))
          .addComments(" ccw =\"false\" ")
          .setGeometry(new NurbsPatchSurface().setSolid(false).setUClosed(true).setUDimension(13).setUKnot(new double[] {-3.14159,-3.14159,-3.14159,-3.14159,-2.61799,-2.0944,-1.0472,-0.523599,6.66134E-16,0.523599,1.0472,2.0944,2.61799,3.14159,3.14159,3.14159,3.14159}).setUOrder(4).setVClosed(true).setVDimension(14).setVKnot(new double[] {-1.57079,-1.57079,-1.57079,-1.57079,-1.0472,-0.523599,0.0,0.523599,0.808217,1.04015,1.0472,1.24824,1.29714,1.46148,1.57079,1.57079,1.57079,1.57079}).setVOrder(4).setWeight(new double[] {1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.5,1.0,1.0,1.0,1.0,1.0,0.5,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0})
            .setControlPoint(new Coordinate().setPoint(getCoordinate_7_32_point()))))
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material().setDiffuseColor(0.760784,0.843137,0.196078).setShininess(0.25).setSpecularColor(0.9,0.9,0.9)))
          .addComments(" ccw =\"false\" ")
          .setGeometry(new NurbsPatchSurface().setSolid(false).setUClosed(true).setUDimension(10).setUKnot(new double[] {0.0,0.0,0.0,0.0,0.179541,0.317924,0.485586,0.507528,0.709398,0.813231,1.0,1.0,1.0,1.0}).setUOrder(4).setVClosed(true).setVDimension(9).setVKnot(new double[] {0.0,0.0,0.0,0.0,0.145456,0.265731,0.436096,0.583258,0.847704,1.0,1.0,1.0,1.0}).setVOrder(4)
            .setControlPoint(new Coordinate().setPoint(getCoordinate_7_37_point()))))
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material().setDiffuseColor(0.760784,0.843137,0.196078).setShininess(0.25).setSpecularColor(0.9,0.9,0.9)))
          .addComments(" ccw =\"false\" ")
          .setGeometry(new NurbsPatchSurface().setSolid(false).setUClosed(true).setUDimension(6).setUKnot(new double[] {0.0,0.0,0.0,0.0,0.333333,0.666667,1.0,1.0,1.0,1.0}).setUOrder(4).setVClosed(true).setVDimension(6).setVKnot(new double[] {0.0,0.0,0.0,0.0,0.333333,0.666667,1.0,1.0,1.0,1.0}).setVOrder(4)
            .setControlPoint(new Coordinate().setPoint(new MFVec3f(new double[] {-35.3328,-20.5164,67.8082,-35.3328,-23.2596,67.9643,-43.2073,-15.6121,55.1513,-43.2073,15.377,55.1513,-35.3328,23.0245,67.9643,-35.3328,20.2813,67.8082,-51.9601,-13.7617,66.5659,-51.9601,-15.3116,65.6251,-52.7067,-10.2906,58.4783,-52.7067,10.0555,58.4783,-51.9601,15.0765,65.6251,-51.9601,13.5266,66.5659,-57.0517,-10.8816,67.0224,-58.0458,-12.0294,65.6305,-62.0569,-12.152,62.2675,-62.0569,11.9169,62.2675,-58.0458,11.7943,65.6305,-57.0517,10.6465,67.0224,-66.231,-10.3114,66.3236,-67.4437,-11.5404,65.503,-75.229,-10.4872,66.7651,-75.229,10.2521,66.7651,-67.4437,11.3053,65.503,-66.231,10.0763,66.3236,-71.9368,-8.82168,68.5583,-73.8306,-10.7604,68.1572,-77.8003,-2.58117,69.0532,-77.8003,2.34607,69.0532,-73.8306,10.5253,68.1572,-71.9368,8.58657,68.5583,-73.6181,-5.58309,69.3868,-74.607,-4.38067,69.8462,-74.9182,-1.53859,69.9011,-74.9182,1.30349,69.9011,-74.607,4.14557,69.8462,-73.6181,5.34799,69.3868})))))))
    .addChild(new Transform().setTranslation(4.0,0.0,-4.0)
      .addChild(new Transform().setUSE("ns")))
    .addChild(new Transform().setTranslation(-4.0,0.0,-4.0)
      .addChild(new Transform().setUSE("ns")))
    .addChild(new Transform().setTranslation(-4.0,0.0,4.0)
      .addChild(new Transform().setUSE("ns"))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getCoordinate_7_32_point_1()
		{
			double[] value = {-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,-3.88113,-1.00949,-21.0906,12.9366,-1.00949,-21.0906,12.9366,0.303242,-21.0906,12.2939,3.24194,-21.0906,-0.851124,7.79166,-21.0906,-6.91113,7.8195,-21.0906,-11.5925,3.20018,-21.0906,-12.5565,-1.00949,-21.0906,-11.5925,-5.21916,-21.0906,-6.91113,-9.83849,-21.0906,-0.851124,-9.81065,-21.0906,12.2939,-5.26093,-21.0906,12.9366,-2.32223,-21.0906,12.9366,-1.00949,-21.0906,44.8852,-1.00949,-20.3281,44.8852,3.14136,-20.3281,40.6928,12.4338,-20.3281,8.24173,26.8202,-20.3281,-23.1085,43.1006,-20.3281,-44.8761,12.3017,-20.3281,-51.1647,-1.00949,-20.3281,-44.8761,-14.3207,-20.3281,-23.1085,-45.1195,-20.3281,8.24173,-28.8392,-20.3281,40.6928,-14.4528,-20.3281,44.8852,-5.16034,-20.3281,44.8852,-1.00949,-20.3281,72.3409,-1.00949,17.7258,72.3409,6.12223,17.7258,57.8004,43.7553,17.7258,36.0866,35.6169,-3.60675,-15.035,55.95,-2.58924,-64.1096,28.2646,-2.58924,-71.6869,-1.00949,-2.58924,-64.1096,-30.2836,-2.58924,-15.035,-57.969,-2.58924,36.0866,-37.6359,-3.60675,57.8004,-45.7743,17.7258,72.3409,-8.14122,17.7258,72.3409,-1.00949,17.7258,67.574,-1.0095,79.0407,67.574,7.23905,79.0407,62.7688,8.92462,79.0406,41.9426,48.6277,16.1266,-15.0519,60.0161,22.3107,-65.2185,32.8489,20.8749,-72.4263,-1.00949,20.8749,-65.2185,-34.8679,20.8749,-15.0519,-62.0351,22.3107,41.9426,-50.6467,16.1266,62.7688,-10.9436,79.0407,67.574,-9.25803,79.0406,67.574,-1.0095,79.0407,48.5835,-1.00949,56.6611,48.5835,0.968175,56.6611,50.6656,3.36527,54.8281,12.7023,24.1247,13.105,-15.7584,48.0996,33.5159,-59.0226,22.4058,33.7453,-64.5593,-1.00949,33.7453,-59.0226,-24.4248,33.7453,-15.7584,-50.1186,33.5159,12.7023,-25.1342,13.105,50.6656,-5.38426,54.8281,48.5835,-2.98716,56.6611,48.5835,-1.00949,56.6611,37.0145,-1.00949,43.6649,37.0145,6.1256,43.6649,32.6921,22.8937,41.2455,16.3923,30.0326,35.7553,-17.3625,36.7184,38.6827,-49.0038,16.9792,40.6447,-53.124,-1.00949,40.6447,-49.0038,-18.9982,40.6447,-17.3625,-38.7374,38.6827,16.3923,-32.0516,35.7553,32.6921,-24.9127,41.2455,37.0145,-8.14459,43.6649,37.0145,-1.00949,43.6649,7.33509,-1.00949,37.0327,7.33509,1.94944,37.0327,7.02457,8.72519,37.3348,-3.00386,25.8853,43.3824,-18.4431,29.2811,42.8002,-41.4856,13.4331,44.501,-44.7927,-1.00949,44.501,-41.4856,-15.4521,44.501,-18.4431,-31.3001,42.8002};
			return value;
		}
		private double[] getCoordinate_7_32_point_2()
		{
			double[] value = {-3.00386,-27.9043,43.3824,7.02457,-10.7442,37.3349,7.33509,-3.96842,37.0327,7.33509,-1.00949,37.0327,0.0718746,-1.00949,49.8154,0.0718746,1.8294,49.8154,-0.836516,8.24889,49.9432,-8.7426,21.0087,47.583,-21.5965,22.4788,46.3929,-38.4159,10.1897,50.0795,-40.9803,-1.00949,50.0795,-38.4159,-12.2087,50.0795,-21.5965,-24.4978,46.3929,-8.7426,-23.0277,47.5831,-0.836517,-10.2679,49.9432,0.0718756,-3.84838,49.8154,0.0718746,-1.00949,49.8154,-2.96944,-1.00949,54.02,-2.96944,2.84522,54.02,-4.60821,11.5077,54.0859,-8.8192,26.3737,52.999,-25.2736,27.1826,53.7335,-41.6394,12.4325,54.1045,-44.7174,-1.00949,54.1045,-41.6394,-14.4515,54.1045,-25.2736,-29.2016,53.7335,-8.8192,-28.3927,52.999,-4.60821,-13.5266,54.0859,-2.96944,-4.86421,54.02,-2.96944,-1.00949,54.02,12.3157,-1.0095,70.7309,12.3157,3.50519,70.7309,10.1575,13.6188,70.7446,-9.3821,29.5805,71.998,-28.6548,29.828,72.1513,-52.9782,14.2958,72.2288,-56.3449,-1.0095,72.2288,-52.9782,-16.3147,72.2288,-28.6548,-31.847,72.1513,-9.3821,-31.5995,71.998,10.1575,-15.6378,70.7446,12.3157,-5.52418,70.7309,12.3157,-1.0095,70.7309,4.42304,-1.0095,95.3549,4.42304,2.87192,95.3549,2.52297,11.561,95.3549,-11.775,25.0134,95.3549,-28.61,25.0957,95.3549,-40.9005,15.4255,95.3549,-51.2533,-1.0095,95.3549,-40.9005,-17.4445,95.3549,-28.61,-27.1147,95.3549,-11.775,-27.0323,95.3549,2.52297,-13.58,95.3549,4.42304,-4.89091,95.3549,4.42304,-1.0095,95.3549,-19.6734,-1.00949,98.8627,-19.6734,-0.735432,98.8627,-19.8075,-0.121915,98.8627,-20.7849,0.827938,98.8627,-22.05,0.833751,98.8627,-23.0274,-0.130634,98.8627,-23.2286,-1.00949,98.8627,-23.0274,-1.88836,98.8627,-22.05,-2.85274,98.8627,-20.7849,-2.84693,98.8627,-19.8075,-1.89707,98.8627,-19.6734,-1.28356,98.8627,-19.6734,-1.00949,98.8627,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922,-21.4175,-1.00949,98.4922};
			return value;
		}


		/** Large attribute array: Coordinate point field, scene-graph level=7, element #32, 546 total numbers made up of 182 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_7_32_point()
		{
			MFVec3f Coordinate_7_32_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_7_32_point_1()))
				.append(new MFVec3f(getCoordinate_7_32_point_2()));
			return Coordinate_7_32_point;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=7, element #37, 270 total numbers made up of 90 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_7_37_point()
		{
			MFVec3f Coordinate_7_37_point = new MFVec3f(new double[] {-73.8131,6.63633,69.133,-74.2708,6.18088,69.2564,-74.8413,4.65081,69.5024,-75.5274,2.31383,69.8221,-75.591,0.735333,69.8782,-75.5937,-1.14871,69.8805,-75.5235,-2.72556,69.8187,-74.8307,-5.09567,69.4896,-74.2868,-6.49425,69.2557,-73.8131,-6.98448,69.133,-73.3982,7.2493,68.8449,-73.1918,8.66427,69.9436,-75.3859,7.60687,71.3516,-78.4811,4.8366,72.5403,-79.0814,1.6832,72.6798,-79.0898,-2.14555,72.6835,-78.4967,-5.29666,72.5385,-75.3876,-8.08808,71.3125,-73.1231,-9.11955,70.0438,-73.3982,-7.59737,68.8449,-72.3476,8.23845,68.5049,-72.6538,10.8314,70.309,-70.9149,10.2409,72.0977,-74.1459,5.70077,76.3284,-75.017,1.94713,76.4023,-75.0197,-2.46093,76.407,-74.1589,-6.23648,76.3122,-70.933,-10.7342,72.0367,-72.509,-11.4062,70.4805,-72.3476,-8.58602,68.5049,-69.87,9.57595,67.782,-69.7634,11.3206,69.2882,-67.1525,10.7796,70.8139,-72.8038,5.6492,71.8181,-72.6959,1.73868,71.7112,-72.6943,-2.23037,71.7199,-72.8529,-6.22392,71.7639,-67.1896,-11.225,70.748,-69.6218,-11.8899,69.449,-69.87,-9.92062,67.782,-64.6195,10.3711,65.9883,-64.022,12.1095,67.7215,-63.4494,11.2597,69.7278,-65.1228,5.3948,71.0988,-64.8963,1.49956,71.3281,-64.8942,-1.96022,71.3425,-65.1788,-5.99976,70.9981,-63.5003,-11.6697,69.6472,-63.9396,-12.6492,67.9264,-64.6195,-10.7107,65.9882,-54.023,12.4802,66.1499,-54.1269,14.0867,68.0532,-55.7988,12.1895,70.163,-58.4175,4.89281,72.0038,-58.2862,1.32699,73.3102,-58.2868,-1.74911,73.3324,-58.4314,-5.51405,71.8365,-55.8484,-12.5612,70.0329,-54.1419,-14.5759,68.2838,-54.023,-12.8138,66.1499,-44.0057,17.8681,66.8406,-43.9838,19.143,68.7561,-47.4608,14.9976,70.8278,-53.2817,4.65394,73.5584,-53.0358,1.72659,76.6927,-53.0358,-2.1249,76.721,-53.2297,-5.26371,73.3178,-47.5241,-15.3207,70.6279,-43.9832,-19.592,68.9802,-44.0057,-18.1891,66.8406,-38.1682,21.5524,68.8148,-38.2198,22.3863,70.547,-43.696,16.3947,71.9024,-52.6608,4.21184,74.7897,-52.1085,2.61508,80.0012,-52.1085,-3.04062,80.0312,-52.5036,-4.76715,74.4613,-43.7414,-16.6922,71.6008,-38.2211,-22.8438,70.7289,-38.1682,-21.8854,68.8148,-36.9344,21.5524,68.8148,-37.3517,21.1355,70.5472,-43.0003,14.8802,71.8351,-51.6435,4.07751,74.5683,-50.8454,2.82102,79.7092,-50.8454,-3.26925,79.7394,-51.5228,-4.5846,74.2506,-43.0269,-15.2949,71.5389,-37.3625,-21.5608,70.7293,-36.9344,-21.8854,68.8148});
			return Coordinate_7_37_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return FourDucks model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new FourDucks().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.FourDucks\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.FourDucks self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/FourDucks_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/FourDucks_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/FourDucks_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/FourDucks_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
