package Basic.NURBS;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Interpolation.*;
import org.web3d.x3d.jsail.NURBS.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Time.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Example of animating controlPoint to simulate facial expressions - read my lips (pretty creepy!). </p>
 <p> Related links: Catalog page <a href="../../../NURBS/AnimatedNurbsPatchSurfaceHeadIndex.html" target="_blank">AnimatedNurbsPatchSurfaceHead</a>,  source <a href="../../../NURBS/AnimatedNurbsPatchSurfaceHead.java">AnimatedNurbsPatchSurfaceHead.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../NURBS/AnimatedNurbsPatchSurfaceHead.x3d">AnimatedNurbsPatchSurfaceHead.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Example of animating controlPoint to simulate facial expressions - read my lips (pretty creepy!) </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Charles Adams, Vince Marchetti </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Exported from Maya 4 by X3D MayaExport Plug-in </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 26 February 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> info </i> </td>
			<td> Animation only working in H3DViewer, InstantReality, OctagaVS </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/AnimatedNurbsPatchSurfaceHeadH3DViewer.png">images/AnimatedNurbsPatchSurfaceHeadH3DViewer.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/AnimatedNurbsPatchSurfaceHeadInstantReality.png">images/AnimatedNurbsPatchSurfaceHeadInstantReality.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../NURBS/images/AnimatedNurbsPatchSurfaceHeadOctagaVS.png">images/AnimatedNurbsPatchSurfaceHeadOctagaVS.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf" target="_blank">http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/NURBS/AnimatedNurbsPatchSurfaceHead.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/NURBS/AnimatedNurbsPatchSurfaceHead.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../NURBS/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Charles Adams, Vince Marchetti
 */

public class AnimatedNurbsPatchSurfaceHead
{
	/** Default constructor to create this object. */
	public AnimatedNurbsPatchSurfaceHead ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_0)
  .setHead(new head()
    .addComponent(new component().setName("NURBS").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("AnimatedNurbsPatchSurfaceHead.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Example of animating controlPoint to simulate facial expressions - read my lips (pretty creepy!)"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Charles Adams, Vince Marchetti"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Exported from Maya 4 by X3D MayaExport Plug-in"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("26 February 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_INFO       ).setContent("Animation only working in H3DViewer, InstantReality, OctagaVS"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/AnimatedNurbsPatchSurfaceHeadH3DViewer.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/AnimatedNurbsPatchSurfaceHeadInstantReality.png"))
    .addMeta(new meta().setName(meta.NAME_IMAGE      ).setContent("images/AnimatedNurbsPatchSurfaceHeadOctagaVS.png"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://edocs.nps.edu/npspubs/scholarly/theses/2003/Jun/03Jun_Adams.pdf"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/NURBS/AnimatedNurbsPatchSurfaceHead.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("AnimatedNurbsPatchSurfaceHead.x3d"))
    .addChild(new Transform().setTranslation(-2.5,0.0,0.0)
      .addChild(new Transform().setRotation(0.0,1.0,0.0,3.14)
        .addChild(new Transform().setScale(0.249,0.249,0.249)
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setMaterial(new Material().setDiffuseColor(.996,.871,.706)))
            .addComments(" ccw=\"false\" ")
            .setGeometry(new NurbsPatchSurface("NS").setSolid(false).setUClosed(true).setUDimension(24).setUKnot(new double[] {2.0,2.0,2.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0,10.5776,11.0,11.4830,12.0,13.0,14.0,15.0,16.0,17.0,18.0,19.0,20.0,21.0,21.0,21.0,21.0}).setUOrder(4).setVClosed(true).setVDimension(30).setVKnot(new double[] {0.0,0.0,0.0,0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0,16.0,17.0,18.0,19.0,20.0,21.0,22.0,23.0,24.0,25.0,26.0,27.0,27.0,27.0,27.0}).setVOrder(4)
              .setControlPoint(new Coordinate("NC").setPoint(getNC_8_20_point())))))))
    .addChild(new CoordinateInterpolator("CI").setKey(new double[] {0.0,.5,1.0}).setKeyValue(getCI_3_26_keyValue()))
    .addChild(new TimeSensor("TS").setCycleInterval(6).setLoop(true))
    .addChild(new ROUTE().setFromNode("TS").setFromField("fraction_changed").setToNode("CI").setToField("set_fraction"))
    .addChild(new ROUTE().setFromNode("CI").setFromField("value_changed").setToNode("NC").setToField("set_point")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getNC_8_20_point_1()
		{
			double[] value = {-11.7578,-6.7464,-6.3137,-12.1236,-6.7185,-6.3208,-12.2527,-6.6067,-6.3488,-12.9135,-6.5388,-6.1805,-13.2555,-6.5671,-6.2433,-13.3467,-6.0869,-6.2392,-13.0345,-6.1151,-6.2725,-12.6849,-6.0054,-6.3250,-12.4115,-6.0347,-6.3110,-11.8663,-6.0277,-6.3143,-11.3996,-6.0279,-6.3142,-11.0448,-6.0284,-6.3139,-10.7044,-6.0278,-6.3142,-10.2390,-6.0278,-6.3142,-9.7061,-6.0346,-6.3109,-9.4321,-6.0053,-6.3249,-9.0820,-6.1149,-6.2724,-8.7692,-6.0867,-6.2390,-8.8599,-6.5668,-6.2433,-9.2032,-6.5386,-6.1805,-9.8642,-6.6066,-6.3488,-10.0582,-6.7742,-6.3067,-11.3921,-6.7743,-6.3067,-11.7578,-6.7464,-6.3137,-11.6030,-7.9766,-6.1488,-11.9363,-7.9616,-6.1558,-12.4259,-7.9017,-6.1838,-13.2492,-8.2633,-6.0153,-14.0886,-7.6470,-6.0782,-15.0765,-5.7190,-6.0746,-13.8819,-4.4841,-6.1083,-13.3069,-4.6315,-6.1608,-11.3438,-4.5916,-6.1468,-11.9470,-4.6009,-6.1501,-11.5278,-4.6005,-6.1500,-11.0407,-4.5997,-6.1497,-10.5734,-4.6006,-6.1499,-10.1880,-4.6007,-6.1499,-10.7773,-4.5916,-6.1468,-8.8119,-4.6316,-6.1606,-8.2360,-4.4843,-6.1081,-7.0343,-5.7192,-6.0740,-8.0234,-7.6462,-6.0783,-8.8659,-8.2624,-6.0155,-9.6905,-7.9012,-6.1839,-10.4261,-7.9914,-6.1419,-11.2697,-7.9915,-6.1419,-11.6030,-7.9766,-6.1488,-11.6080,-7.8431,-7.9041,-11.9028,-7.8274,-7.9111,-12.0410,-7.7644,-7.9391,-13.2615,-8.1429,-7.7706,-13.9667,-7.5727,-7.8337,-14.9137,-5.8044,-7.8305,-13.8868,-4.6161,-7.8642,-13.0560,-4.7729,-7.9165,-12.3076,-4.7307,-7.9025,-11.8700,-4.7405,-7.9057,-11.4079,-4.7401,-7.9056,-11.0408,-4.7393,-7.9053,-10.6886,-4.7402,-7.9056,-10.2308,-4.7404,-7.9055,-9.8031,-4.7308,-7.9023,-9.0533,-4.7731,-7.9162,-8.2211,-4.6166,-7.8636,-7.1868,-5.8050,-7.8296,-8.1341,-7.5721,-7.8336,-8.8419,-8.1421,-7.7707,-10.0646,-7.7641,-7.9391,-10.2724,-7.8585,-7.8971,-11.3133,-7.8587,-7.8971,-11.6080,-7.8431,-7.9041,-11.7411,-6.5034,-8.3343,-12.1120,-6.4742,-8.3414,-12.3235,-6.3574,-8.3696,-12.7601,-6.3194,-8.2009,-13.0094,-6.4316,-8.2655,-13.0988,-6.2393,-8.2545,-12.9193,-6.3550,-8.3128,-12.7061,-6.2490,-8.2718,-12.3951,-6.3225,-8.6066,-11.8592,-6.1624,-8.5282,-11.3932,-6.1688,-8.5314,-11.0376,-6.1818,-8.5377,-10.6966,-6.1675,-8.5307,-10.2322,-6.1662,-8.5300,-9.7073,-6.3225,-8.6064,-9.3982,-6.2490,-8.2716,-9.1840,-6.3550,-8.3126,-9.0047,-6.2393,-8.2542,-9.0939,-6.4315,-8.2652,-9.3445,-6.3194,-8.2007,-9.7806,-6.3573,-8.3694,-10.0983,-6.5325,-8.3272,-11.3703,-6.5325,-8.3273,-11.7411,-6.5034,-8.3343,-11.7252,-6.6688,-8.9651,-12.0870,-6.6401,-8.9914,-12.2801,-6.5253,-9.0965,-12.8529,-6.4751,-8.4661};
			return value;
		}
		private double[] getNC_8_20_point_2()
		{
			double[] value = {-13.1680,-6.4987,-8.4925,-13.2565,-6.2361,-8.7108,-12.9884,-6.1741,-8.9398,-12.6839,-6.0900,-9.0936,-12.3981,-6.1574,-9.1862,-11.8566,-5.9987,-9.1646,-11.3904,-6.0051,-9.1654,-11.0356,-6.0180,-9.1671,-10.6952,-6.0039,-9.1651,-10.2305,-6.0025,-9.1649,-9.7004,-6.1575,-9.1859,-9.4150,-6.0902,-9.0933,-9.1107,-6.1743,-8.9394,-8.8433,-6.2362,-8.7104,-8.9331,-6.4987,-8.4922,-9.2492,-6.4751,-8.4659,-9.8185,-6.5253,-9.0963,-10.1094,-6.6974,-8.9387,-11.3634,-6.6975,-8.9388,-11.7252,-6.6688,-8.9651,-11.7052,-6.9152,-8.9148,-12.0527,-6.8878,-8.9765,-12.2119,-6.7783,-9.2234,-13.0192,-6.6980,-8.6275,-13.3102,-6.6375,-8.4724,-13.5219,-6.0859,-8.7726,-13.0882,-5.9402,-9.1005,-12.6560,-5.8397,-9.4460,-12.4046,-5.9114,-9.4397,-11.8553,-5.7518,-9.4412,-11.3888,-5.7582,-9.4411,-11.0349,-5.7711,-9.4409,-10.6954,-5.7570,-9.4410,-10.2301,-5.7557,-9.4409,-9.6926,-5.9116,-9.4393,-9.4409,-5.8400,-9.4456,-9.0100,-5.9404,-9.1000,-8.5770,-6.0861,-8.7720,-8.7904,-6.6374,-8.4720,-9.0809,-6.6979,-8.6272,-9.8854,-6.7783,-9.2232,-10.1270,-6.9425,-8.8530,-11.3577,-6.9425,-8.8530,-11.7052,-6.9152,-8.9148,-11.6502,-7.2713,-8.6786,-11.9655,-7.2442,-8.6874,-12.0888,-7.1353,-8.7225,-13.2240,-7.3040,-8.6894,-13.6243,-6.8649,-8.4265,-13.9721,-5.6859,-8.6914,-13.2974,-5.7401,-8.8112,-12.6597,-5.3683,-9.2812,-12.1895,-5.3573,-9.3395,-11.8717,-5.4363,-9.4519,-11.4149,-5.4332,-9.4473,-11.0342,-5.4268,-9.4381,-10.6690,-5.4338,-9.4481,-10.2199,-5.4346,-9.4490,-9.9102,-5.3575,-9.3392,-9.4397,-5.3687,-9.2808,-8.8028,-5.7405,-8.8107,-8.1270,-5.6864,-8.6907,-8.4751,-6.8648,-8.4261,-8.8739,-7.3038,-8.6892,-10.0118,-7.1352,-8.7224,-10.1972,-7.2984,-8.6698,-11.3349,-7.2985,-8.6699,-11.6502,-7.2713,-8.6786,-11.6067,-7.5584,-8.5898,-11.8991,-7.5984,-8.5615,-12.0140,-7.7580,-8.4484,-13.3542,-7.6863,-8.5690,-13.8224,-7.2778,-8.3965,-14.4606,-5.6560,-8.4649,-13.5315,-5.3637,-8.5927,-12.8937,-4.8990,-8.8226,-12.1626,-5.2998,-9.2282,-11.8748,-5.0172,-9.3425,-11.4191,-5.0285,-9.3353,-11.0350,-5.0515,-9.3249,-10.6664,-5.0264,-9.3362,-10.2193,-5.0240,-9.3396,-9.9381,-5.3001,-9.2279,-9.2097,-4.8994,-8.8221,-8.5705,-5.3641,-8.5922,-7.6382,-5.6567,-8.4640,-8.2756,-7.2775,-8.3961,-8.7436,-7.6858,-8.5688,-10.0879,-7.7577,-8.4484,-10.2595,-7.5184,-8.6181,-11.3143,-7.5185,-8.6181,-11.6067,-7.5584,-8.5898,-11.5903,-8.0358,-8.4426,-11.8895,-8.0546,-8.4297,-12.1261,-8.1296,-8.3779,-13.3419,-8.1023,-8.4911,-14.0591,-7.6287,-8.3228,-15.0008,-5.5996,-8.0218,-13.8058,-4.8398,-8.4008,-13.2667,-4.6826,-8.7134};
			return value;
		}
		private double[] getNC_8_20_point_3()
		{
			double[] value = {-11.5262,-4.7356,-9.2539,-11.9241,-4.4749,-8.9891,-11.4953,-4.6412,-9.3098,-11.0317,-4.7243,-9.4544,-10.5883,-4.6333,-9.2957,-10.1900,-4.4812,-8.9951,-10.5763,-4.7357,-9.2538,-8.8372,-4.6831,-8.7128,-8.2982,-4.8404,-8.4001,-7.0987,-5.6005,-8.0207,-8.0377,-7.6282,-8.3225,-8.7558,-8.1016,-8.4910,-9.9758,-8.1291,-8.3779,-10.3306,-8.0169,-8.4556,-11.2910,-8.0170,-8.4556,-11.5903,-8.0358,-8.4426,-11.5701,-8.2823,-8.4684,-11.8689,-8.3492,-8.4729,-12.1829,-8.6162,-8.4909,-13.4186,-8.4335,-8.3360,-14.2852,-7.8442,-8.1850,-15.3916,-5.5471,-7.6866,-14.0573,-4.3973,-8.2159,-13.0274,-4.2775,-8.6720,-12.5707,-4.2994,-9.1457,-11.3955,-4.6512,-9.4821,-11.1227,-4.6214,-9.5618,-11.0474,-4.5866,-9.5715,-10.9750,-4.6247,-9.5608,-10.6782,-4.6430,-9.4741,-9.5328,-4.2998,-9.1453,-9.0785,-4.2780,-8.6715,-8.0485,-4.3981,-8.2152,-6.7082,-5.5481,-7.6855,-7.8111,-7.8435,-8.1847,-8.6796,-8.4325,-8.3360,-9.9175,-8.6156,-8.4910,-10.3897,-8.2153,-8.4639,-11.2712,-8.2155,-8.4639,-11.5701,-8.2823,-8.4684,-11.6073,-8.9557,-8.4527,-11.9269,-8.9640,-8.4467,-12.2560,-8.9969,-8.4229,-13.5339,-8.6234,-8.1919,-14.5228,-8.2634,-7.9854,-15.7945,-5.1717,-7.2880,-14.2361,-3.8287,-8.1139,-13.0801,-3.9757,-8.5670,-12.5771,-3.4023,-9.3208,-11.8440,-3.8678,-9.9532,-11.3695,-4.3205,-9.8694,-11.0362,-4.4701,-9.7949,-10.7164,-4.3062,-9.8765,-10.2389,-3.8571,-9.9381,-9.5279,-3.4028,-9.3204,-9.0272,-3.9762,-8.5665,-7.8714,-3.8295,-8.1131,-6.3069,-5.1730,-7.2866,-7.5728,-8.2623,-7.9852,-8.5648,-8.6222,-8.1920,-9.8446,-8.9961,-8.4230,-10.3388,-8.9472,-8.4587,-11.2878,-8.9475,-8.4586,-11.6073,-8.9557,-8.4527,-11.6501,-9.4792,-8.3946,-11.9952,-9.4894,-8.4116,-12.3582,-9.5298,-8.4798,-13.8094,-8.7578,-8.0328,-14.9991,-8.5041,-7.4886,-16.0184,-4.1680,-7.0990,-14.5141,-3.5446,-7.9691,-13.3300,-3.2493,-8.4873,-11.9088,-3.3299,-9.4786,-11.8938,-3.3122,-10.1406,-11.4481,-3.3135,-10.4998,-11.0318,-3.3153,-10.5993,-10.6332,-3.3136,-10.4900,-10.2065,-3.3130,-10.1247,-10.1961,-3.3302,-9.4784,-8.7793,-3.2499,-8.4867,-7.5943,-3.5456,-7.9683,-6.0865,-4.1697,-7.0976,-7.0966,-8.5027,-7.4885,-8.2890,-8.7564,-8.0329,-9.7414,-9.5287,-8.4801,-10.2877,-9.4686,-8.3777,-11.3050,-9.4690,-8.3776,-11.6501,-9.4792,-8.3946,-11.8707,-10.3091,-8.1867,-12.3102,-10.2410,-8.1993,-12.5476,-9.9675,-8.2500,-14.2860,-8.9569,-7.7726,-15.4467,-7.9858,-7.0059,-16.1989,-3.0285,-6.9754,-14.8646,-2.9778,-7.6712,-13.5360,-2.7742,-8.5187,-11.7357,-2.8299,-9.2699,-11.9086,-2.8178,-9.8495,-11.4709,-2.8188,-10.1543,-11.0330,-2.8200,-10.2376};
			return value;
		}
		private double[] getNC_8_20_point_4()
		{
			double[] value = {-10.6136,-2.8189,-10.1461,-10.1996,-2.8184,-9.8356,-10.3722,-2.8302,-9.2697,-8.5741,-2.7749,-8.5181,-7.2460,-2.9789,-7.6703,-5.9099,-3.0302,-6.9741,-6.6502,-7.9849,-7.0055,-7.8115,-8.9551,-7.7728,-9.5531,-9.9661,-8.2504,-9.9105,-10.3764,-8.1744,-11.4312,-10.3773,-8.1741,-11.8707,-10.3091,-8.1867,-11.9751,-10.3770,-7.7866,-12.5400,-10.3081,-7.8378,-13.3704,-10.0314,-8.0429,-14.3440,-9.0799,-7.4323,-15.9211,-7.5411,-6.4816,-16.3224,-2.6222,-6.7773,-15.1119,-2.0978,-7.7311,-14.0632,-1.4525,-7.6491,-11.6049,-0.9886,-8.6732,-11.4903,-1.0976,-8.8265,-11.2539,-1.0933,-8.8204,-11.0493,-1.0845,-8.8079,-10.8529,-1.0942,-8.8215,-10.6222,-1.0952,-8.8228,-10.5112,-0.9887,-8.6731,-8.0538,-1.4532,-7.6486,-7.0003,-2.0991,-7.7302,-5.7882,-2.6239,-6.7760,-6.1767,-7.5407,-6.4809,-7.7555,-9.0779,-7.4326,-8.7288,-10.0291,-8.0435,-9.9806,-10.4452,-7.7357,-11.4101,-10.4460,-7.7354,-11.9751,-10.3770,-7.7866,-12.0730,-10.4184,-7.5381,-12.6754,-10.3542,-7.5987,-13.4174,-10.0964,-7.8413,-14.4295,-9.0750,-7.0069,-16.0651,-7.4989,-6.2942,-16.4745,-1.6221,-6.5524,-15.5363,-1.5100,-7.6004,-13.8214,-1.3976,-7.4182,-12.3745,-0.6932,-8.4252,-11.8685,-0.9139,-8.5976,-11.4033,-0.7811,-8.6261,-11.0438,-0.7140,-8.6261,-10.6988,-0.7877,-8.6260,-10.2362,-0.9089,-8.5934,-9.7430,-0.6935,-8.4250,-8.2972,-1.3982,-7.4178,-6.5769,-1.5114,-7.5994,-5.6396,-1.6237,-6.5512,-6.0328,-7.4985,-6.2935,-7.6725,-9.0729,-7.0074,-8.6830,-10.0941,-7.8420,-9.8026,-10.4816,-7.4779,-11.4705,-10.4826,-7.4776,-12.0730,-10.4184,-7.5381,-12.1274,-10.4374,-7.3332,-12.7570,-10.3716,-7.3648,-13.4999,-10.1072,-7.4913,-14.4427,-9.0602,-6.8042,-16.3154,-7.5496,-5.8965,-16.5603,-0.8174,-6.3235,-16.0214,-0.7488,-7.3505,-14.0773,-0.5457,-7.7128,-12.4676,0.5435,-8.8213,-11.8624,0.4118,-8.7568,-11.3929,0.3260,-8.7890,-11.0448,0.3004,-8.8060,-10.7111,0.3284,-8.7873,-10.2417,0.4147,-8.7582,-9.6502,0.5431,-8.8210,-8.0413,-0.5463,-7.7124,-6.0933,-0.7503,-7.3494,-5.5565,-0.8189,-6.3225,-5.7826,-7.5492,-5.8957,-7.6606,-9.0581,-6.8046,-8.6028,-10.1047,-7.4920,-9.7226,-10.5022,-7.3021,-11.4979,-10.5033,-7.3017,-12.1274,-10.4374,-7.3332,-12.1785,-10.4244,-7.1139,-12.8270,-10.3576,-7.1222,-13.5199,-10.0891,-7.1559,-14.4702,-9.0868,-6.5777,-16.4676,-7.4580,-5.6456,-16.7230,-0.6472,-5.9103,-16.4438,1.4278,-7.3677,-14.9219,1.0252,-7.7020,-12.6499,1.6446,-8.7568,-12.0965,1.2955,-8.8380,-11.5085,1.4412,-8.8332,-11.0408,1.5218,-8.8260,-10.5920,1.4333,-8.8339,-10.0097,1.3035,-8.8360,-9.4697,1.6442,-8.7566,-7.1978,1.0243,-7.7015};
			return value;
		}
		private double[] getNC_8_20_point_5()
		{
			double[] value = {-5.6740,1.4263,-7.3667,-5.3952,-0.6486,-5.9093,-5.6307,-7.4578,-5.6447,-7.6345,-9.0846,-6.5782,-8.5853,-10.0866,-7.1567,-9.6287,-10.4902,-7.1060,-11.5300,-10.4913,-7.1056,-12.1785,-10.4244,-7.1139,-12.1971,-10.4333,-6.7686,-12.8596,-10.3713,-6.7769,-13.5951,-10.1223,-6.8105,-14.5049,-9.0613,-6.2809,-16.6282,-7.5008,-5.2973,-16.9186,-0.0995,-5.5469,-16.6968,2.7218,-6.6630,-15.6381,2.2935,-7.3765,-13.1618,2.9928,-8.2005,-12.4111,3.3870,-8.1033,-11.6428,3.1039,-8.3600,-11.0364,2.9657,-8.4682,-10.4552,3.1171,-8.3494,-9.6946,3.3776,-8.1055,-8.9605,2.9924,-8.2003,-6.4828,2.2926,-7.3759,-5.4241,2.7206,-6.6622,-5.2012,-0.1009,-5.5460,-5.4705,-7.5006,-5.2964,-7.6017,-9.0591,-6.2814,-8.5121,-10.1197,-6.8113,-9.6198,-10.4942,-6.7607,-11.5345,-10.4953,-6.7603,-12.1971,-10.4333,-6.7686,-12.1952,-10.4132,-6.2411,-12.8708,-10.3476,-6.2517,-13.7261,-10.0845,-6.2941,-14.5375,-9.0601,-6.0380,-16.7921,-7.5280,-4.8135,-17.2088,0.5789,-5.0618,-17.0402,3.4954,-5.0082,-15.7686,4.3832,-6.2667,-13.8196,4.9297,-6.7465,-12.6884,5.6870,-6.6340,-11.7459,5.9043,-6.6385,-11.0341,5.9413,-6.6476,-10.3514,5.9007,-6.6376,-9.4112,5.6691,-6.6366,-8.3060,4.9294,-6.7463,-6.3557,4.3825,-6.2663,-5.0842,3.4946,-5.0076,-4.9125,0.5777,-5.0609,-5.3074,-7.5278,-4.8126,-7.5705,-9.0579,-6.0386,-8.3840,-10.0820,-6.2950,-9.6722,-10.4778,-6.2310,-11.5195,-10.4787,-6.2306,-12.1952,-10.4132,-6.2411,-12.1964,-10.4141,-5.5570,-12.8872,-10.3471,-5.5537,-13.8665,-10.0784,-5.5409,-14.5517,-9.0468,-5.6155,-16.8882,-7.6099,-4.7480,-17.3519,1.4013,-2.9604,-17.2800,3.7621,-3.8426,-15.3929,5.5397,-3.4755,-15.0941,6.0754,-4.4240,-12.5955,7.0764,-3.7975,-11.5962,7.0577,-4.0457,-11.0417,6.9851,-4.1850,-10.5099,7.0647,-4.0322,-9.4744,7.0528,-3.8121,-7.0333,6.0751,-4.4238,-6.7353,5.5394,-3.4753,-4.8457,3.7613,-3.8421,-4.7738,1.4005,-2.9599,-5.2104,-7.6097,-4.7470,-7.5589,-9.0447,-5.6161,-8.2477,-10.0760,-5.5417,-9.7220,-10.4803,-5.5605,-11.5057,-10.4811,-5.5602,-12.1964,-10.4141,-5.5570,-12.2022,-10.5011,-5.1846,-12.8945,-10.4346,-5.1204,-13.8657,-10.1682,-4.8637,-14.5959,-9.0339,-5.1626,-16.8440,-7.6897,-4.1612,-17.5753,1.4839,-2.1512,-16.5025,3.7693,-1.3418,-15.6024,5.6542,-0.6076,-15.0396,6.0579,-0.7828,-12.6002,7.4644,-0.6486,-11.6032,7.5852,-0.6540,-11.0419,7.5416,-0.6649,-10.5035,7.5894,-0.6529,-9.4721,7.4313,-0.6518,-7.0898,6.0578,-0.7827,-6.5269,5.6540,-0.6075,-5.6263,3.7691,-1.3416,-4.5507,1.4832,-2.1507,-5.2578,-7.6892,-4.1605,-7.5171,-9.0320,-5.1632};
			return value;
		}
		private double[] getNC_8_20_point_6()
		{
			double[] value = {-8.2524,-10.1661,-4.8645,-9.7123,-10.5668,-5.2491,-11.5100,-10.5675,-5.2488,-12.2022,-10.5011,-5.1846,-12.1554,-10.6541,-4.8816,-12.8228,-10.6299,-4.7893,-13.7853,-10.5323,-4.4205,-14.5941,-9.1434,-4.8518,-16.8658,-7.7204,-3.5573,-17.2249,0.8681,-0.5763,-17.1903,3.5627,0.2760,-15.4181,4.7291,2.3249,-15.0888,5.2702,2.5954,-12.5967,6.3641,2.4240,-11.5976,6.2385,2.4308,-11.0424,6.1175,2.4447,-10.5098,6.2502,2.4295,-9.4747,6.3383,2.4280,-7.0406,5.2701,2.5955,-6.7113,4.7289,2.3250,-4.9379,3.5623,0.2762,-4.9023,0.8676,-0.5759,-5.2385,-7.7198,-3.5568,-7.5206,-9.1414,-4.8524,-8.3353,-10.5303,-4.4213,-9.7811,-10.6778,-4.9741,-11.4880,-10.6784,-4.9739,-12.1554,-10.6541,-4.8816,-12.1060,-10.9330,-4.6566,-12.7567,-10.9282,-4.5755,-13.7861,-10.9082,-4.2514,-14.5248,-9.3676,-4.6029,-16.7072,-7.9939,-3.0695,-17.0226,-0.9850,0.5426,-16.9565,2.9546,1.8872,-16.1912,2.5166,4.5379,-15.5456,3.4371,5.0361,-13.2758,3.5056,5.3825,-11.9367,3.9793,5.3686,-11.0276,4.1629,5.3406,-10.1555,3.9615,5.3714,-8.7999,3.5039,5.3744,-6.5822,3.4367,5.0364,-5.9363,2.5161,4.5382,-5.1717,2.9542,1.8874,-5.1036,-0.9856,0.5430,-5.4001,-7.9928,-3.0692,-7.5915,-9.3656,-4.6035,-8.3352,-10.9060,-4.2523,-9.8819,-10.9373,-4.7379,-11.4553,-10.9379,-4.7377,-12.1060,-10.9330,-4.6566,-12.0732,-11.1528,-4.5757,-12.7135,-11.1481,-4.5052,-13.7918,-11.1287,-4.2236,-14.5627,-9.8955,-4.4443,-16.6615,-8.0917,-2.9090,-16.6587,-3.0363,0.6342,-16.8846,1.8437,3.1275,-16.6978,0.7696,4.9108,-13.6273,0.3333,5.7719,-12.7315,0.6974,6.1051,-11.7850,0.2351,6.2334,-11.0332,0.0278,6.2627,-10.3122,0.2551,6.2306,-9.3754,0.6887,6.0973,-8.5005,0.3331,5.7721,-5.4274,0.7686,4.9113,-5.2428,1.8431,3.1278,-5.4661,-3.0369,0.6346,-5.4466,-8.0905,-2.9088,-7.5537,-9.8930,-4.4451,-8.3295,-11.1263,-4.2246,-9.9501,-11.1570,-4.6463,-11.4329,-11.1575,-4.6461,-12.0732,-11.1528,-4.5757,-12.0351,-11.3996,-4.4765,-12.6585,-11.4059,-4.4162,-13.7547,-11.4304,-4.1756,-14.6064,-10.1352,-4.3637,-16.5974,-8.6171,-2.9881,-16.3120,-4.9811,0.8818,-16.8553,-2.2190,2.4587,-15.7416,-1.2005,4.9483,-13.8543,-2.2669,5.2052,-12.4460,-2.3691,5.9513,-11.6095,-2.1277,6.1529,-11.0401,-2.0251,6.1844,-10.4938,-2.1376,6.1499,-9.6474,-2.3668,5.9339,-8.2724,-2.2672,5.2054,-6.3836,-1.2012,4.9488,-5.2690,-2.2199,2.4592,-5.8115,-4.9814,0.8822,-5.5094,-8.6153,-2.9883,-7.5100,-10.1324,-4.3647,-8.3669,-11.4279,-4.1766,-10.0146,-11.3928,-4.5369,-11.4118,-11.3933,-4.5367,-12.0351,-11.3996,-4.4765};
			return value;
		}
		private double[] getNC_8_20_point_7()
		{
			double[] value = {-12.1051,-11.5751,-4.4670,-12.7427,-11.5859,-4.4168,-13.6718,-11.6281,-4.2160,-14.7164,-10.6749,-4.1591,-16.3313,-9.2758,-3.4638,-16.3977,-5.9130,0.6407,-16.3480,-5.0769,1.0773,-15.8217,-2.5700,4.1197,-13.4344,-5.2508,4.3582,-12.2289,-5.2278,4.6354,-11.5226,-5.2287,4.6242,-11.0444,-5.2305,4.6017,-10.5856,-5.2285,4.6264,-9.8703,-5.2284,4.6289,-8.6924,-5.2509,4.3582,-6.3031,-2.5706,4.1201,-5.7752,-5.0773,1.0777,-5.7242,-5.9132,0.6410,-5.7744,-9.2729,-3.4644,-7.3996,-10.6714,-4.1604,-8.4499,-11.6255,-4.2171,-9.8467,-11.5638,-4.5175,-11.4676,-11.5644,-4.5173,-12.1051,-11.5751,-4.4670,-12.1066,-11.8205,-4.4340,-12.7431,-11.8201,-4.3941,-13.6580,-11.8182,-4.2345,-14.7716,-11.1754,-4.1132,-16.1658,-10.0111,-3.3628,-16.4367,-6.3544,0.0620,-16.3342,-7.1869,0.7602,-15.8248,-3.6435,3.4027,-13.4324,-6.4688,3.4082,-12.2361,-6.2574,3.5520,-11.5271,-6.5955,3.5462,-11.0449,-6.7436,3.5346,-10.5824,-6.5812,3.5474,-9.8647,-6.2624,3.5487,-8.6957,-6.4687,3.4083,-6.2998,-3.6440,3.4031,-5.7860,-7.1866,0.7603,-5.6841,-6.3545,0.0623,-5.9401,-10.0069,-3.3640,-7.3436,-11.1711,-4.1149,-8.4637,-11.8155,-4.2357,-9.8393,-11.8201,-4.4743,-11.4702,-11.8208,-4.4740,-12.1066,-11.8205,-4.4340,-12.1144,-12.0745,-4.4602,-12.7513,-12.0932,-4.4102,-13.6375,-12.1671,-4.2107,-14.8761,-11.5438,-4.2174,-16.0284,-10.7719,-2.7507,-16.2833,-8.3526,-0.8624,-16.3741,-8.1695,0.5461,-15.8057,-7.0390,1.9889,-13.4586,-8.2137,3.5256,-12.1629,-8.3527,3.2670,-11.4847,-8.3469,3.2773,-11.0468,-8.3356,3.2982,-10.6269,-8.3480,3.2752,-9.9358,-8.3493,3.2730,-8.6689,-8.2134,3.5255,-6.3172,-7.0387,1.9889,-5.7440,-8.1684,0.5460,-5.8340,-8.3513,-0.8626,-6.0797,-10.7663,-2.7527,-7.2369,-11.5384,-4.2196,-8.4841,-12.1640,-4.2120,-9.8166,-12.0551,-4.5105,-11.4776,-12.0559,-4.5101,-12.1144,-12.0745,-4.4602,-12.1032,-12.3162,-4.4667,-12.7359,-12.3394,-4.4177,-13.6349,-12.4314,-4.2221,-14.8416,-11.9554,-4.2901,-16.0250,-11.5554,-2.5280,-16.2599,-10.0355,-0.5854,-16.3748,-10.4023,0.7665,-15.7993,-9.1232,2.5708,-13.4665,-10.3377,4.0146,-12.1382,-10.5782,3.8834,-11.4704,-10.5682,3.8885,-11.0472,-10.5486,3.8990,-10.6414,-10.5700,3.8874,-9.9594,-10.5722,3.8863,-8.6606,-10.3365,4.0141,-6.3209,-9.1214,2.5702,-5.7384,-10.3979,0.7648,-5.8542,-10.0319,-0.5866,-6.0808,-11.5474,-2.5312,-7.2706,-11.9491,-4.2927,-8.4875,-12.4283,-4.2235,-9.8382,-12.2923,-4.5160,-11.4704,-12.2931,-4.5157,-12.1032,-12.3162,-4.4667,-12.1093,-12.7048,-4.6697,-12.7327,-12.7124,-4.6365,-13.5318,-12.7420,-4.5042,-15.2397,-12.5001,-4.1466};
			return value;
		}
		private double[] getNC_8_20_point_8()
		{
			double[] value = {-16.2359,-12.5979,-2.0875,-16.7586,-12.4391,-0.2510,-16.2385,-12.7907,1.6013,-15.8320,-12.1995,2.7774,-13.4566,-12.3041,5.0461,-12.1390,-12.7705,4.8987,-11.4716,-12.7511,4.9043,-11.0473,-12.7128,4.9160,-10.6403,-12.7543,4.9029,-9.9590,-12.7583,4.9016,-8.6705,-12.3009,5.0445,-6.2850,-12.1901,2.7732,-5.8756,-12.7795,1.5963,-5.3444,-12.4277,-0.2556,-5.8681,-12.5863,-2.0923,-6.8699,-12.4918,-4.1501,-8.5898,-12.7385,-4.5057,-9.7913,-12.6962,-4.7033,-11.4859,-12.6971,-4.7029,-12.1093,-12.7048,-4.6697};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCI_3_26_keyValue_1()
		{
			double[] value = {-11.7578,-6.7464,-6.3137,-12.1236,-6.7185,-6.3208,-12.2527,-6.6067,-6.3488,-12.9135,-6.5388,-6.1805,-13.2555,-6.5671,-6.2433,-13.3467,-6.0869,-6.2392,-13.0345,-6.1151,-6.2725,-12.6849,-6.0054,-6.3250,-12.4115,-6.0347,-6.3110,-11.8663,-6.0277,-6.3143,-11.3996,-6.0279,-6.3142,-11.0448,-6.0284,-6.3139,-10.7044,-6.0278,-6.3142,-10.2390,-6.0278,-6.3142,-9.7061,-6.0346,-6.3109,-9.4321,-6.0053,-6.3249,-9.0820,-6.1149,-6.2724,-8.7692,-6.0867,-6.2390,-8.8599,-6.5668,-6.2433,-9.2032,-6.5386,-6.1805,-9.8642,-6.6066,-6.3488,-10.0582,-6.7742,-6.3067,-11.3921,-6.7743,-6.3067,-11.7578,-6.7464,-6.3137,-11.6030,-7.9766,-6.1488,-11.9363,-7.9616,-6.1558,-12.4259,-7.9017,-6.1838,-13.2492,-8.2633,-6.0153,-14.0886,-7.6470,-6.0782,-15.0765,-5.7190,-6.0746,-13.8819,-4.4841,-6.1083,-13.3069,-4.6315,-6.1608,-11.3438,-4.5916,-6.1468,-11.9470,-4.6009,-6.1501,-11.5278,-4.6005,-6.1500,-11.0407,-4.5997,-6.1497,-10.5734,-4.6006,-6.1499,-10.1880,-4.6007,-6.1499,-10.7773,-4.5916,-6.1468,-8.8119,-4.6316,-6.1606,-8.2360,-4.4843,-6.1081,-7.0343,-5.7192,-6.0740,-8.0234,-7.6462,-6.0783,-8.8659,-8.2624,-6.0155,-9.6905,-7.9012,-6.1839,-10.4261,-7.9914,-6.1419,-11.2697,-7.9915,-6.1419,-11.6030,-7.9766,-6.1488,-11.6080,-7.8431,-7.9041,-11.9028,-7.8274,-7.9111,-12.0410,-7.7644,-7.9391,-13.2615,-8.1429,-7.7706,-13.9667,-7.5727,-7.8337,-14.9137,-5.8044,-7.8305,-13.8868,-4.6161,-7.8642,-13.0560,-4.7729,-7.9165,-12.3076,-4.7307,-7.9025,-11.8700,-4.7405,-7.9057,-11.4079,-4.7401,-7.9056,-11.0408,-4.7393,-7.9053,-10.6886,-4.7402,-7.9056,-10.2308,-4.7404,-7.9055,-9.8031,-4.7308,-7.9023,-9.0533,-4.7731,-7.9162,-8.2211,-4.6166,-7.8636,-7.1868,-5.8050,-7.8296,-8.1341,-7.5721,-7.8336,-8.8419,-8.1421,-7.7707,-10.0646,-7.7641,-7.9391,-10.2724,-7.8585,-7.8971,-11.3133,-7.8587,-7.8971,-11.6080,-7.8431,-7.9041,-11.7411,-6.5034,-8.3343,-12.1120,-6.4742,-8.3414,-12.3235,-6.3574,-8.3696,-12.7601,-6.3194,-8.2009,-13.0094,-6.4316,-8.2655,-13.0988,-6.2393,-8.2545,-12.9193,-6.3550,-8.3128,-12.7061,-6.2490,-8.2718,-12.3951,-6.3225,-8.6066,-11.8592,-6.1624,-8.5282,-11.3932,-6.1688,-8.5314,-11.0376,-6.1818,-8.5377,-10.6966,-6.1675,-8.5307,-10.2322,-6.1662,-8.5300,-9.7073,-6.3225,-8.6064,-9.3982,-6.2490,-8.2716,-9.1840,-6.3550,-8.3126,-9.0047,-6.2393,-8.2542,-9.0939,-6.4315,-8.2652,-9.3445,-6.3194,-8.2007,-9.7806,-6.3573,-8.3694,-10.0983,-6.5325,-8.3272,-11.3703,-6.5325,-8.3273,-11.7411,-6.5034,-8.3343,-11.7252,-6.6688,-8.9651,-12.0870,-6.6401,-8.9914,-12.2801,-6.5253,-9.0965,-12.8529,-6.4751,-8.4661};
			return value;
		}
		private double[] getCI_3_26_keyValue_2()
		{
			double[] value = {-13.1680,-6.4987,-8.4925,-13.2565,-6.2361,-8.7108,-12.9884,-6.1741,-8.9398,-12.6839,-6.0900,-9.0936,-12.3981,-6.1574,-9.1862,-11.8566,-5.9987,-9.1646,-11.3904,-6.0051,-9.1654,-11.0356,-6.0180,-9.1671,-10.6952,-6.0039,-9.1651,-10.2305,-6.0025,-9.1649,-9.7004,-6.1575,-9.1859,-9.4150,-6.0902,-9.0933,-9.1107,-6.1743,-8.9394,-8.8433,-6.2362,-8.7104,-8.9331,-6.4987,-8.4922,-9.2492,-6.4751,-8.4659,-9.8185,-6.5253,-9.0963,-10.1094,-6.6974,-8.9387,-11.3634,-6.6975,-8.9388,-11.7252,-6.6688,-8.9651,-11.7052,-6.9152,-8.9148,-12.0527,-6.8878,-8.9765,-12.2119,-6.7783,-9.2234,-13.0192,-6.6980,-8.6275,-13.3102,-6.6375,-8.4724,-13.5219,-6.0859,-8.7726,-13.0882,-5.9402,-9.1005,-12.6560,-5.8397,-9.4460,-12.4046,-5.9114,-9.4397,-11.8553,-5.7518,-9.4412,-11.3888,-5.7582,-9.4411,-11.0349,-5.7711,-9.4409,-10.6954,-5.7570,-9.4410,-10.2301,-5.7557,-9.4409,-9.6926,-5.9116,-9.4393,-9.4409,-5.8400,-9.4456,-9.0100,-5.9404,-9.1000,-8.5770,-6.0861,-8.7720,-8.7904,-6.6374,-8.4720,-9.0809,-6.6979,-8.6272,-9.8854,-6.7783,-9.2232,-10.1270,-6.9425,-8.8530,-11.3577,-6.9425,-8.8530,-11.7052,-6.9152,-8.9148,-11.6502,-7.2713,-8.6786,-11.9655,-7.2442,-8.6874,-12.0888,-7.1353,-8.7225,-13.2240,-7.3040,-8.6894,-13.6243,-6.8649,-8.4265,-13.9721,-5.6859,-8.6914,-13.2974,-5.7401,-8.8112,-12.6597,-5.3683,-9.2812,-12.1895,-5.3573,-9.3395,-11.8717,-5.4363,-9.4519,-11.4149,-5.4332,-9.4473,-11.0342,-5.4268,-9.4381,-10.6690,-5.4338,-9.4481,-10.2199,-5.4346,-9.4490,-9.9102,-5.3575,-9.3392,-9.4397,-5.3687,-9.2808,-8.8028,-5.7405,-8.8107,-8.1270,-5.6864,-8.6907,-8.4751,-6.8648,-8.4261,-8.8739,-7.3038,-8.6892,-10.0118,-7.1352,-8.7224,-10.1972,-7.2984,-8.6698,-11.3349,-7.2985,-8.6699,-11.6502,-7.2713,-8.6786,-11.6067,-7.5584,-8.5898,-11.8991,-7.5984,-8.5615,-12.0140,-7.7580,-8.4484,-13.3542,-7.6863,-8.5690,-13.8224,-7.2778,-8.3965,-14.4606,-5.6560,-8.4649,-13.5315,-5.3637,-8.5927,-12.8937,-4.8990,-8.8226,-12.1626,-5.2998,-9.2282,-11.8748,-5.0172,-9.3425,-11.4191,-5.0285,-9.3353,-11.0350,-5.0515,-9.3249,-10.6664,-5.0264,-9.3362,-10.2193,-5.0240,-9.3396,-9.9381,-5.3001,-9.2279,-9.2097,-4.8994,-8.8221,-8.5705,-5.3641,-8.5922,-7.6382,-5.6567,-8.4640,-8.2756,-7.2775,-8.3961,-8.7436,-7.6858,-8.5688,-10.0879,-7.7577,-8.4484,-10.2595,-7.5184,-8.6181,-11.3143,-7.5185,-8.6181,-11.6067,-7.5584,-8.5898,-11.5903,-8.0358,-8.4426,-11.8895,-8.0546,-8.4297,-12.1261,-8.1296,-8.3779,-13.3419,-8.1023,-8.4911,-14.0591,-7.6287,-8.3228,-15.0008,-5.5996,-8.0218,-13.8058,-4.8398,-8.4008,-13.2667,-4.6826,-8.7134};
			return value;
		}
		private double[] getCI_3_26_keyValue_3()
		{
			double[] value = {-11.5262,-4.7356,-9.2539,-11.9241,-4.4749,-8.9891,-11.4953,-4.6412,-9.3098,-11.0317,-4.7243,-9.4544,-10.5883,-4.6333,-9.2957,-10.1900,-4.4812,-8.9951,-10.5763,-4.7357,-9.2538,-8.8372,-4.6831,-8.7128,-8.2982,-4.8404,-8.4001,-7.0987,-5.6005,-8.0207,-8.0377,-7.6282,-8.3225,-8.7558,-8.1016,-8.4910,-9.9758,-8.1291,-8.3779,-10.3306,-8.0169,-8.4556,-11.2910,-8.0170,-8.4556,-11.5903,-8.0358,-8.4426,-11.5701,-8.2823,-8.4684,-11.8689,-8.3492,-8.4729,-12.1829,-8.6162,-8.4909,-13.4186,-8.4335,-8.3360,-14.2852,-7.8442,-8.1850,-15.3916,-5.5471,-7.6866,-14.0573,-4.3973,-8.2159,-13.0274,-4.2775,-8.6720,-12.5707,-4.2994,-9.1457,-11.3955,-4.6512,-9.4821,-11.1227,-4.6214,-9.5618,-11.0474,-4.5866,-9.5715,-10.9750,-4.6247,-9.5608,-10.6782,-4.6430,-9.4741,-9.5328,-4.2998,-9.1453,-9.0785,-4.2780,-8.6715,-8.0485,-4.3981,-8.2152,-6.7082,-5.5481,-7.6855,-7.8111,-7.8435,-8.1847,-8.6796,-8.4325,-8.3360,-9.9175,-8.6156,-8.4910,-10.3897,-8.2153,-8.4639,-11.2712,-8.2155,-8.4639,-11.5701,-8.2823,-8.4684,-11.6073,-8.9557,-8.4527,-11.9269,-8.9640,-8.4467,-12.2560,-8.9969,-8.4229,-13.5339,-8.6234,-8.1919,-14.5228,-8.2634,-7.9854,-15.7945,-5.1717,-7.2880,-14.2361,-3.8287,-8.1139,-13.0801,-3.9757,-8.5670,-12.5771,-3.4023,-9.3208,-11.8440,-3.8678,-9.9532,-11.3695,-4.3205,-9.8694,-11.0362,-4.4701,-9.7949,-10.7164,-4.3062,-9.8765,-10.2389,-3.8571,-9.9381,-9.5279,-3.4028,-9.3204,-9.0272,-3.9762,-8.5665,-7.8714,-3.8295,-8.1131,-6.3069,-5.1730,-7.2866,-7.5728,-8.2623,-7.9852,-8.5648,-8.6222,-8.1920,-9.8446,-8.9961,-8.4230,-10.3388,-8.9472,-8.4587,-11.2878,-8.9475,-8.4586,-11.6073,-8.9557,-8.4527,-11.6501,-9.4792,-8.3946,-11.9952,-9.4894,-8.4116,-12.3582,-9.5298,-8.4798,-13.8094,-8.7578,-8.0328,-14.9991,-8.5041,-7.4886,-16.0184,-4.1680,-7.0990,-14.5141,-3.5446,-7.9691,-13.3300,-3.2493,-8.4873,-11.9088,-3.3299,-9.4786,-11.8938,-3.3122,-10.1406,-11.4481,-3.3135,-10.4998,-11.0318,-3.3153,-10.5993,-10.6332,-3.3136,-10.4900,-10.2065,-3.3130,-10.1247,-10.1961,-3.3302,-9.4784,-8.7793,-3.2499,-8.4867,-7.5943,-3.5456,-7.9683,-6.0865,-4.1697,-7.0976,-7.0966,-8.5027,-7.4885,-8.2890,-8.7564,-8.0329,-9.7414,-9.5287,-8.4801,-10.2877,-9.4686,-8.3777,-11.3050,-9.4690,-8.3776,-11.6501,-9.4792,-8.3946,-11.8707,-10.3091,-8.1867,-12.3102,-10.2410,-8.1993,-12.5476,-9.9675,-8.2500,-14.2860,-8.9569,-7.7726,-15.4467,-7.9858,-7.0059,-16.1989,-3.0285,-6.9754,-14.8646,-2.9778,-7.6712,-13.5360,-2.7742,-8.5187,-11.7357,-2.8299,-9.2699,-11.9086,-2.8178,-9.8495,-11.4709,-2.8188,-10.1543,-11.0330,-2.8200,-10.2376};
			return value;
		}
		private double[] getCI_3_26_keyValue_4()
		{
			double[] value = {-10.6136,-2.8189,-10.1461,-10.1996,-2.8184,-9.8356,-10.3722,-2.8302,-9.2697,-8.5741,-2.7749,-8.5181,-7.2460,-2.9789,-7.6703,-5.9099,-3.0302,-6.9741,-6.6502,-7.9849,-7.0055,-7.8115,-8.9551,-7.7728,-9.5531,-9.9661,-8.2504,-9.9105,-10.3764,-8.1744,-11.4312,-10.3773,-8.1741,-11.8707,-10.3091,-8.1867,-11.9751,-10.3770,-7.7866,-12.5400,-10.3081,-7.8378,-13.3704,-10.0314,-8.0429,-14.3440,-9.0799,-7.4323,-15.9211,-7.5411,-6.4816,-16.3224,-2.6222,-6.7773,-15.1119,-2.0978,-7.7311,-14.0632,-1.4525,-7.6491,-11.6049,-0.9886,-8.6732,-11.4903,-1.0976,-8.8265,-11.2539,-1.0933,-8.8204,-11.0493,-1.0845,-8.8079,-10.8529,-1.0942,-8.8215,-10.6222,-1.0952,-8.8228,-10.5112,-0.9887,-8.6731,-8.0538,-1.4532,-7.6486,-7.0003,-2.0991,-7.7302,-5.7882,-2.6239,-6.7760,-6.1767,-7.5407,-6.4809,-7.7555,-9.0779,-7.4326,-8.7288,-10.0291,-8.0435,-9.9806,-10.4452,-7.7357,-11.4101,-10.4460,-7.7354,-11.9751,-10.3770,-7.7866,-12.0730,-10.4184,-7.5381,-12.6754,-10.3542,-7.5987,-13.4174,-10.0964,-7.8413,-14.4295,-9.0750,-7.0069,-16.0651,-7.4989,-6.2942,-16.4745,-1.6221,-6.5524,-15.5363,-1.5100,-7.6004,-13.8214,-1.3976,-7.4182,-12.3745,-0.6932,-8.4252,-11.8685,-0.9139,-8.5976,-11.4033,-0.7811,-8.6261,-11.0438,-0.7140,-8.6261,-10.6988,-0.7877,-8.6260,-10.2362,-0.9089,-8.5934,-9.7430,-0.6935,-8.4250,-8.2972,-1.3982,-7.4178,-6.5769,-1.5114,-7.5994,-5.6396,-1.6237,-6.5512,-6.0328,-7.4985,-6.2935,-7.6725,-9.0729,-7.0074,-8.6830,-10.0941,-7.8420,-9.8026,-10.4816,-7.4779,-11.4705,-10.4826,-7.4776,-12.0730,-10.4184,-7.5381,-12.1274,-10.4374,-7.3332,-12.7570,-10.3716,-7.3648,-13.4999,-10.1072,-7.4913,-14.4427,-9.0602,-6.8042,-16.3154,-7.5496,-5.8965,-16.5603,-0.8174,-6.3235,-16.0214,-0.7488,-7.3505,-14.0773,-0.5457,-7.7128,-12.4676,0.5435,-8.8213,-11.8624,0.4118,-8.7568,-11.3929,0.3260,-8.7890,-11.0448,0.3004,-8.8060,-10.7111,0.3284,-8.7873,-10.2417,0.4147,-8.7582,-9.6502,0.5431,-8.8210,-8.0413,-0.5463,-7.7124,-6.0933,-0.7503,-7.3494,-5.5565,-0.8189,-6.3225,-5.7826,-7.5492,-5.8957,-7.6606,-9.0581,-6.8046,-8.6028,-10.1047,-7.4920,-9.7226,-10.5022,-7.3021,-11.4979,-10.5033,-7.3017,-12.1274,-10.4374,-7.3332,-12.1785,-10.4244,-7.1139,-12.8270,-10.3576,-7.1222,-13.5199,-10.0891,-7.1559,-14.4702,-9.0868,-6.5777,-16.4676,-7.4580,-5.6456,-16.7230,-0.6472,-5.9103,-16.4438,1.4278,-7.3677,-14.9219,1.0252,-7.7020,-12.6499,1.6446,-8.7568,-12.0965,1.2955,-8.8380,-11.5085,1.4412,-8.8332,-11.0408,1.5218,-8.8260,-10.5920,1.4333,-8.8339,-10.0097,1.3035,-8.8360,-9.4697,1.6442,-8.7566,-7.1978,1.0243,-7.7015};
			return value;
		}
		private double[] getCI_3_26_keyValue_5()
		{
			double[] value = {-5.6740,1.4263,-7.3667,-5.3952,-0.6486,-5.9093,-5.6307,-7.4578,-5.6447,-7.6345,-9.0846,-6.5782,-8.5853,-10.0866,-7.1567,-9.6287,-10.4902,-7.1060,-11.5300,-10.4913,-7.1056,-12.1785,-10.4244,-7.1139,-12.1971,-10.4333,-6.7686,-12.8596,-10.3713,-6.7769,-13.5951,-10.1223,-6.8105,-14.5049,-9.0613,-6.2809,-16.6282,-7.5008,-5.2973,-16.9186,-0.0995,-5.5469,-16.6968,2.7218,-6.6630,-15.6381,2.2935,-7.3765,-13.1618,2.9928,-8.2005,-12.4111,3.3870,-8.1033,-11.6428,3.1039,-8.3600,-11.0364,2.9657,-8.4682,-10.4552,3.1171,-8.3494,-9.6946,3.3776,-8.1055,-8.9605,2.9924,-8.2003,-6.4828,2.2926,-7.3759,-5.4241,2.7206,-6.6622,-5.2012,-0.1009,-5.5460,-5.4705,-7.5006,-5.2964,-7.6017,-9.0591,-6.2814,-8.5121,-10.1197,-6.8113,-9.6198,-10.4942,-6.7607,-11.5345,-10.4953,-6.7603,-12.1971,-10.4333,-6.7686,-12.1952,-10.4132,-6.2411,-12.8708,-10.3476,-6.2517,-13.7261,-10.0845,-6.2941,-14.5375,-9.0601,-6.0380,-16.7921,-7.5280,-4.8135,-17.2088,0.5789,-5.0618,-17.0402,3.4954,-5.0082,-15.7686,4.3832,-6.2667,-13.8196,4.9297,-6.7465,-12.6884,5.6870,-6.6340,-11.7459,5.9043,-6.6385,-11.0341,5.9413,-6.6476,-10.3514,5.9007,-6.6376,-9.4112,5.6691,-6.6366,-8.3060,4.9294,-6.7463,-6.3557,4.3825,-6.2663,-5.0842,3.4946,-5.0076,-4.9125,0.5777,-5.0609,-5.3074,-7.5278,-4.8126,-7.5705,-9.0579,-6.0386,-8.3840,-10.0820,-6.2950,-9.6722,-10.4778,-6.2310,-11.5195,-10.4787,-6.2306,-12.1952,-10.4132,-6.2411,-12.1964,-10.4141,-5.5570,-12.8872,-10.3471,-5.5537,-13.8665,-10.0784,-5.5409,-14.5517,-9.0468,-5.6155,-16.8882,-7.6099,-4.7480,-17.3519,1.4013,-2.9604,-17.2800,3.7621,-3.8426,-15.3929,5.5397,-3.4755,-15.0941,6.0754,-4.4240,-12.5955,7.0764,-3.7975,-11.5962,7.0577,-4.0457,-11.0417,6.9851,-4.1850,-10.5099,7.0647,-4.0322,-9.4744,7.0528,-3.8121,-7.0333,6.0751,-4.4238,-6.7353,5.5394,-3.4753,-4.8457,3.7613,-3.8421,-4.7738,1.4005,-2.9599,-5.2104,-7.6097,-4.7470,-7.5589,-9.0447,-5.6161,-8.2477,-10.0760,-5.5417,-9.7220,-10.4803,-5.5605,-11.5057,-10.4811,-5.5602,-12.1964,-10.4141,-5.5570,-12.2022,-10.5011,-5.1846,-12.8945,-10.4346,-5.1204,-13.8657,-10.1682,-4.8637,-14.5959,-9.0339,-5.1626,-16.8440,-7.6897,-4.1612,-17.5753,1.4839,-2.1512,-16.5025,3.7693,-1.3418,-15.6024,5.6542,-0.6076,-15.0396,6.0579,-0.7828,-12.6002,7.4644,-0.6486,-11.6032,7.5852,-0.6540,-11.0419,7.5416,-0.6649,-10.5035,7.5894,-0.6529,-9.4721,7.4313,-0.6518,-7.0898,6.0578,-0.7827,-6.5269,5.6540,-0.6075,-5.6263,3.7691,-1.3416,-4.5507,1.4832,-2.1507,-5.2578,-7.6892,-4.1605,-7.5171,-9.0320,-5.1632};
			return value;
		}
		private double[] getCI_3_26_keyValue_6()
		{
			double[] value = {-8.2524,-10.1661,-4.8645,-9.7123,-10.5668,-5.2491,-11.5100,-10.5675,-5.2488,-12.2022,-10.5011,-5.1846,-12.1554,-10.6541,-4.8816,-12.8228,-10.6299,-4.7893,-13.7853,-10.5323,-4.4205,-14.5941,-9.1434,-4.8518,-16.8658,-7.7204,-3.5573,-17.2249,0.8681,-0.5763,-17.1903,3.5627,0.2760,-15.4181,4.7291,2.3249,-15.0888,5.2702,2.5954,-12.5967,6.3641,2.4240,-11.5976,6.2385,2.4308,-11.0424,6.1175,2.4447,-10.5098,6.2502,2.4295,-9.4747,6.3383,2.4280,-7.0406,5.2701,2.5955,-6.7113,4.7289,2.3250,-4.9379,3.5623,0.2762,-4.9023,0.8676,-0.5759,-5.2385,-7.7198,-3.5568,-7.5206,-9.1414,-4.8524,-8.3353,-10.5303,-4.4213,-9.7811,-10.6778,-4.9741,-11.4880,-10.6784,-4.9739,-12.1554,-10.6541,-4.8816,-12.1060,-10.9330,-4.6566,-12.7567,-10.9282,-4.5755,-13.7861,-10.9082,-4.2514,-14.5248,-9.3676,-4.6029,-16.7072,-7.9939,-3.0695,-17.0226,-0.9850,0.5426,-16.9565,2.9546,1.8872,-16.1912,2.5166,4.5379,-15.5456,3.4371,5.0361,-13.2758,3.5056,5.3825,-11.9367,3.9793,5.3686,-11.0276,4.1629,5.3406,-10.1555,3.9615,5.3714,-8.7999,3.5039,5.3744,-6.5822,3.4367,5.0364,-5.9363,2.5161,4.5382,-5.1717,2.9542,1.8874,-5.1036,-0.9856,0.5430,-5.4001,-7.9928,-3.0692,-7.5915,-9.3656,-4.6035,-8.3352,-10.9060,-4.2523,-9.8819,-10.9373,-4.7379,-11.4553,-10.9379,-4.7377,-12.1060,-10.9330,-4.6566,-12.0732,-11.1528,-4.5757,-12.7135,-11.1481,-4.5052,-13.7918,-11.1287,-4.2236,-14.5627,-9.8955,-4.4443,-16.6615,-8.0917,-2.9090,-16.6587,-3.0363,0.6342,-16.8846,1.8437,3.1275,-16.6978,0.7696,4.9108,-13.6273,0.3333,5.7719,-12.7315,0.6974,6.1051,-11.7850,0.2351,6.2334,-11.0332,0.0278,6.2627,-10.3122,0.2551,6.2306,-9.3754,0.6887,6.0973,-8.5005,0.3331,5.7721,-5.4274,0.7686,4.9113,-5.2428,1.8431,3.1278,-5.4661,-3.0369,0.6346,-5.4466,-8.0905,-2.9088,-7.5537,-9.8930,-4.4451,-8.3295,-11.1263,-4.2246,-9.9501,-11.1570,-4.6463,-11.4329,-11.1575,-4.6461,-12.0732,-11.1528,-4.5757,-12.0351,-11.3996,-4.4765,-12.6585,-11.4059,-4.4162,-13.7547,-11.4304,-4.1756,-14.6064,-10.1352,-4.3637,-16.5974,-8.6171,-2.9881,-16.3120,-4.9811,0.8818,-16.8553,-2.2190,2.4587,-15.7416,-1.2005,4.9483,-13.8543,-2.2669,5.2052,-12.4460,-2.3691,5.9513,-11.6095,-2.1277,6.1529,-11.0401,-2.0251,6.1844,-10.4938,-2.1376,6.1499,-9.6474,-2.3668,5.9339,-8.2724,-2.2672,5.2054,-6.3836,-1.2012,4.9488,-5.2690,-2.2199,2.4592,-5.8115,-4.9814,0.8822,-5.5094,-8.6153,-2.9883,-7.5100,-10.1324,-4.3647,-8.3669,-11.4279,-4.1766,-10.0146,-11.3928,-4.5369,-11.4118,-11.3933,-4.5367,-12.0351,-11.3996,-4.4765};
			return value;
		}
		private double[] getCI_3_26_keyValue_7()
		{
			double[] value = {-12.1051,-11.5751,-4.4670,-12.7427,-11.5859,-4.4168,-13.6718,-11.6281,-4.2160,-14.7164,-10.6749,-4.1591,-16.3313,-9.2758,-3.4638,-16.3977,-5.9130,0.6407,-16.3480,-5.0769,1.0773,-15.8217,-2.5700,4.1197,-13.4344,-5.2508,4.3582,-12.2289,-5.2278,4.6354,-11.5226,-5.2287,4.6242,-11.0444,-5.2305,4.6017,-10.5856,-5.2285,4.6264,-9.8703,-5.2284,4.6289,-8.6924,-5.2509,4.3582,-6.3031,-2.5706,4.1201,-5.7752,-5.0773,1.0777,-5.7242,-5.9132,0.6410,-5.7744,-9.2729,-3.4644,-7.3996,-10.6714,-4.1604,-8.4499,-11.6255,-4.2171,-9.8467,-11.5638,-4.5175,-11.4676,-11.5644,-4.5173,-12.1051,-11.5751,-4.4670,-12.1066,-11.8205,-4.4340,-12.7431,-11.8201,-4.3941,-13.6580,-11.8182,-4.2345,-14.7716,-11.1754,-4.1132,-16.1658,-10.0111,-3.3628,-16.4367,-6.3544,0.0620,-16.3342,-7.1869,0.7602,-15.8248,-3.6435,3.4027,-13.4324,-6.4688,3.4082,-12.2361,-6.2574,3.5520,-11.5271,-6.5955,3.5462,-11.0449,-6.7436,3.5346,-10.5824,-6.5812,3.5474,-9.8647,-6.2624,3.5487,-8.6957,-6.4687,3.4083,-6.2998,-3.6440,3.4031,-5.7860,-7.1866,0.7603,-5.6841,-6.3545,0.0623,-5.9401,-10.0069,-3.3640,-7.3436,-11.1711,-4.1149,-8.4637,-11.8155,-4.2357,-9.8393,-11.8201,-4.4743,-11.4702,-11.8208,-4.4740,-12.1066,-11.8205,-4.4340,-12.1144,-12.0745,-4.4602,-12.7513,-12.0932,-4.4102,-13.6375,-12.1671,-4.2107,-14.8761,-11.5438,-4.2174,-16.0284,-10.7719,-2.7507,-16.2833,-8.3526,-0.8624,-16.3741,-8.1695,0.5461,-15.8057,-7.0390,1.9889,-13.4586,-8.2137,3.5256,-12.1629,-8.3527,3.2670,-11.4847,-8.3469,3.2773,-11.0468,-8.3356,3.2982,-10.6269,-8.3480,3.2752,-9.9358,-8.3493,3.2730,-8.6689,-8.2134,3.5255,-6.3172,-7.0387,1.9889,-5.7440,-8.1684,0.5460,-5.8340,-8.3513,-0.8626,-6.0797,-10.7663,-2.7527,-7.2369,-11.5384,-4.2196,-8.4841,-12.1640,-4.2120,-9.8166,-12.0551,-4.5105,-11.4776,-12.0559,-4.5101,-12.1144,-12.0745,-4.4602,-12.1032,-12.3162,-4.4667,-12.7359,-12.3394,-4.4177,-13.6349,-12.4314,-4.2221,-14.8416,-11.9554,-4.2901,-16.0250,-11.5554,-2.5280,-16.2599,-10.0355,-0.5854,-16.3748,-10.4023,0.7665,-15.7993,-9.1232,2.5708,-13.4665,-10.3377,4.0146,-12.1382,-10.5782,3.8834,-11.4704,-10.5682,3.8885,-11.0472,-10.5486,3.8990,-10.6414,-10.5700,3.8874,-9.9594,-10.5722,3.8863,-8.6606,-10.3365,4.0141,-6.3209,-9.1214,2.5702,-5.7384,-10.3979,0.7648,-5.8542,-10.0319,-0.5866,-6.0808,-11.5474,-2.5312,-7.2706,-11.9491,-4.2927,-8.4875,-12.4283,-4.2235,-9.8382,-12.2923,-4.5160,-11.4704,-12.2931,-4.5157,-12.1032,-12.3162,-4.4667,-12.1093,-12.7048,-4.6697,-12.7327,-12.7124,-4.6365,-13.5318,-12.7420,-4.5042,-15.2397,-12.5001,-4.1466};
			return value;
		}
		private double[] getCI_3_26_keyValue_8()
		{
			double[] value = {-16.2359,-12.5979,-2.0875,-16.7586,-12.4391,-0.2510,-16.2385,-12.7907,1.6013,-15.8320,-12.1995,2.7774,-13.4566,-12.3041,5.0461,-12.1390,-12.7705,4.8987,-11.4716,-12.7511,4.9043,-11.0473,-12.7128,4.9160,-10.6403,-12.7543,4.9029,-9.9590,-12.7583,4.9016,-8.6705,-12.3009,5.0445,-6.2850,-12.1901,2.7732,-5.8756,-12.7795,1.5963,-5.3444,-12.4277,-0.2556,-5.8681,-12.5863,-2.0923,-6.8699,-12.4918,-4.1501,-8.5898,-12.7385,-4.5057,-9.7913,-12.6962,-4.7033,-11.4859,-12.6971,-4.7029,-12.1093,-12.7048,-4.6697,-11.7578,-6.7464,-6.3137,-12.1236,-6.7185,-6.3208,-12.2527,-6.6067,-6.3488,-12.9135,-6.5388,-6.1805,-13.2555,-6.5671,-6.2433,-13.3467,-6.0869,-6.2392,-13.0345,-6.1151,-6.2725,-12.6849,-6.0054,-6.3250,-12.4115,-6.0347,-6.3110,-11.8663,-6.0277,-6.3143,-11.3996,-6.0279,-6.3142,-11.0448,-6.0284,-6.3139,-10.7044,-6.0278,-6.3142,-10.2390,-6.0278,-6.3142,-9.7061,-6.0346,-6.3109,-9.4321,-6.0053,-6.3249,-9.0820,-6.1149,-6.2724,-8.7692,-6.0867,-6.2390,-8.8599,-6.5668,-6.2433,-9.2032,-6.5386,-6.1805,-9.8642,-6.6066,-6.3488,-10.0582,-6.7742,-6.3067,-11.3921,-6.7743,-6.3067,-11.7578,-6.7464,-6.3137,-11.6030,-7.9766,-6.1488,-11.9363,-7.9616,-6.1558,-12.4259,-7.9017,-6.1838,-13.2492,-8.2633,-6.0153,-14.0886,-7.6470,-6.0782,-15.0765,-5.7190,-6.0746,-13.8819,-4.4841,-6.1083,-13.3069,-4.6315,-6.1608,-11.3438,-4.5916,-6.1468,-11.9470,-4.6009,-6.1501,-11.5278,-4.6005,-6.1500,-11.0407,-4.5997,-6.1497,-10.5734,-4.6006,-6.1499,-10.1880,-4.6007,-6.1499,-10.7773,-4.5916,-6.1468,-8.8119,-4.6316,-6.1606,-8.2360,-4.4843,-6.1081,-7.0343,-5.7192,-6.0740,-8.0234,-7.6462,-6.0783,-8.8659,-8.2624,-6.0155,-9.6905,-7.9012,-6.1839,-10.4261,-7.9914,-6.1419,-11.2697,-7.9915,-6.1419,-11.6030,-7.9766,-6.1488,-11.6080,-7.8431,-7.9041,-11.9028,-7.8274,-7.9111,-12.0410,-7.7644,-7.9391,-13.2615,-8.1429,-7.7706,-13.9667,-7.5727,-7.8337,-14.9137,-5.8044,-7.8305,-13.8868,-4.6161,-7.8642,-13.0560,-5.0258,-7.9165,-12.3076,-4.9836,-7.9025,-11.8700,-4.7405,-7.9057,-11.4079,-4.7401,-7.9056,-11.0408,-4.7393,-7.9053,-10.6886,-4.7402,-7.9056,-10.2308,-4.7404,-7.9055,-9.8031,-4.9838,-7.9023,-9.0533,-5.0261,-7.9162,-8.2211,-4.6166,-7.8636,-7.1868,-5.8050,-7.8296,-8.1341,-7.5721,-7.8336,-8.8419,-8.1421,-7.7707,-10.0646,-7.7641,-7.9391,-10.2724,-7.8585,-7.8971,-11.3133,-7.8587,-7.8971,-11.6080,-7.8431,-7.9041,-11.7411,-6.5034,-8.3343,-12.1120,-6.3055,-8.3414,-12.3235,-6.1887,-8.3696,-12.7601,-5.8641,-8.2009,-13.0094,-5.7908,-8.2655,-13.0988,-5.5986,-8.2545,-12.9193,-5.8997,-8.3128,-12.7061,-5.7938,-8.2718};
			return value;
		}
		private double[] getCI_3_26_keyValue_9()
		{
			double[] value = {-12.3951,-6.1539,-8.6066,-11.8592,-6.1624,-8.5282,-11.3932,-6.1688,-8.5314,-11.0376,-6.1818,-8.5377,-10.6966,-6.1675,-8.5307,-10.2322,-6.1662,-8.5300,-9.7073,-6.1539,-8.6064,-9.3982,-5.7938,-8.2716,-9.1840,-5.8997,-8.3126,-9.0047,-5.5986,-8.2542,-9.0939,-5.7908,-8.2652,-9.3445,-5.8641,-8.2007,-9.7806,-6.1887,-8.3694,-10.0983,-6.5325,-8.3272,-11.3703,-6.5325,-8.3273,-11.7411,-6.5034,-8.3343,-11.7252,-6.6688,-8.9651,-12.0870,-6.4715,-8.9914,-12.2801,-6.3567,-9.0965,-12.8529,-6.0199,-8.4661,-13.1680,-5.8579,-8.4925,-13.2565,-5.5953,-8.7108,-12.9884,-5.5333,-8.9398,-12.6839,-5.6348,-9.0936,-12.3981,-5.7021,-9.1862,-11.8566,-5.8807,-9.1646,-11.3904,-5.8871,-9.1654,-11.0356,-5.8999,-9.1671,-10.6952,-5.8858,-9.1651,-10.2305,-5.8845,-9.1649,-9.7004,-5.7022,-9.1859,-9.4150,-5.6349,-9.0933,-9.1107,-5.5335,-8.9394,-8.8433,-5.5955,-8.7104,-8.9331,-5.8579,-8.4922,-9.2492,-6.0198,-8.4659,-9.8185,-6.3567,-9.0963,-10.1094,-6.6974,-8.9387,-11.3634,-6.6975,-8.9388,-11.7252,-6.6688,-8.9651,-11.7052,-6.9152,-8.9148,-12.0527,-6.7192,-8.9765,-12.2119,-6.6097,-9.2234,-13.0192,-6.0572,-8.6275,-13.3102,-5.9967,-8.4724,-13.5219,-5.4451,-8.7726,-13.0882,-5.2994,-9.1005,-12.6560,-5.3845,-9.4460,-12.4046,-5.4561,-9.4397,-11.8553,-5.6337,-9.4412,-11.3888,-5.6402,-9.4411,-11.0349,-5.6531,-9.4409,-10.6954,-5.6390,-9.4410,-10.2301,-5.6376,-9.4409,-9.6926,-5.4564,-9.4393,-9.4409,-5.3848,-9.4456,-9.0100,-5.2997,-9.1000,-8.5770,-5.4454,-8.7720,-8.7904,-5.9967,-8.4720,-9.0809,-6.0572,-8.6272,-9.8854,-6.6097,-9.2232,-10.1270,-6.9425,-8.8530,-11.3577,-6.9425,-8.8530,-11.7052,-6.9152,-8.9148,-11.6502,-7.2713,-8.6786,-11.9655,-7.2442,-8.6874,-12.0888,-7.1353,-8.7225,-13.2240,-7.3040,-8.6894,-13.6243,-6.2241,-8.4265,-13.9721,-5.6859,-8.6914,-13.2974,-5.3523,-8.8112,-12.6597,-5.1660,-9.2812,-12.1895,-5.4416,-9.3395,-11.8717,-5.4363,-9.4519,-11.4149,-5.4332,-9.4473,-11.0342,-5.4268,-9.4381,-10.6690,-5.4338,-9.4481,-10.2199,-5.4346,-9.4490,-9.9102,-5.4418,-9.3392,-9.4397,-5.1663,-9.2808,-8.8028,-5.3526,-8.8107,-8.1270,-5.6864,-8.6907,-8.4751,-6.2240,-8.4261,-8.8739,-7.3038,-8.6892,-10.0118,-7.1352,-8.7224,-10.1972,-7.2984,-8.6698,-11.3349,-7.2985,-8.6699,-11.6502,-7.2713,-8.6786,-11.6067,-7.5584,-8.5898,-11.8991,-7.5984,-8.5615,-12.0140,-7.7580,-8.4484,-13.3542,-7.6863,-8.5690,-13.8224,-7.2778,-8.3965,-14.4606,-5.6560,-8.4649,-13.5315,-4.9759,-8.5927,-12.8937,-5.1519,-8.8226,-12.1626,-5.3842,-9.2282,-11.8748,-5.2701,-9.3425,-11.4191,-5.2814,-9.3353,-11.0350,-5.3044,-9.3249};
			return value;
		}
		private double[] getCI_3_26_keyValue_10()
		{
			double[] value = {-10.6664,-5.2793,-9.3362,-10.2193,-5.2769,-9.3396,-9.9381,-5.3844,-9.2279,-9.2097,-5.1523,-8.8221,-8.5705,-4.9763,-8.5922,-7.6382,-5.6567,-8.4640,-8.2756,-7.2775,-8.3961,-8.7436,-7.6858,-8.5688,-10.0879,-7.7577,-8.4484,-10.2595,-7.5184,-8.6181,-11.3143,-7.5185,-8.6181,-11.6067,-7.5584,-8.5898,-11.5903,-8.0358,-8.4426,-11.8895,-8.0546,-8.4297,-12.1261,-8.1296,-8.3779,-13.3419,-8.1023,-8.4911,-14.0591,-7.6287,-8.3228,-15.0008,-5.5996,-8.0218,-13.8058,-5.0928,-8.4008,-13.2667,-4.9356,-8.7134,-11.5262,-4.7356,-9.2539,-11.9241,-4.4749,-8.9891,-11.4953,-4.6412,-9.3098,-11.0317,-4.7243,-9.4544,-10.5883,-4.6333,-9.2957,-10.1900,-4.7342,-8.9951,-10.5763,-4.7357,-9.2538,-8.8372,-4.9361,-8.7128,-8.2982,-5.0934,-8.4001,-7.0987,-5.6005,-8.0207,-8.0377,-7.6282,-8.3225,-8.7558,-8.1016,-8.4910,-9.9758,-8.1291,-8.3779,-10.3306,-8.0169,-8.4556,-11.2910,-8.0170,-8.4556,-11.5903,-8.0358,-8.4426,-11.5701,-8.2823,-8.4684,-11.8689,-8.3492,-8.4729,-12.1829,-8.6162,-8.4909,-13.4186,-8.4335,-8.3360,-14.2852,-7.8442,-8.1850,-15.3916,-5.5471,-7.6866,-14.0573,-4.3973,-8.2159,-13.0274,-4.2775,-8.6720,-12.5707,-4.2994,-9.1457,-11.3955,-4.6512,-9.4821,-11.1227,-4.6214,-9.5618,-11.0474,-4.5866,-9.5715,-10.9750,-4.6247,-9.5608,-10.6782,-4.6430,-9.4741,-9.5328,-4.2998,-9.1453,-9.0785,-4.2780,-8.6715,-8.0485,-4.3981,-8.2152,-6.7082,-5.5481,-7.6855,-7.8111,-7.8435,-8.1847,-8.6796,-8.4325,-8.3360,-9.9175,-8.6156,-8.4910,-10.3897,-8.2153,-8.4639,-11.2712,-8.2155,-8.4639,-11.5701,-8.2823,-8.4684,-11.6073,-8.9557,-8.4527,-11.9269,-8.9640,-8.4467,-12.2560,-8.9969,-8.4229,-13.5339,-8.6234,-8.1919,-14.5228,-8.2634,-7.9854,-15.7945,-5.1717,-7.2880,-14.2361,-3.8287,-8.1139,-13.0801,-3.9757,-8.5670,-12.5771,-3.4023,-9.3208,-11.8440,-3.8678,-9.9532,-11.3695,-4.3205,-9.8694,-11.0362,-4.4701,-9.7949,-10.7164,-4.3062,-9.8765,-10.2389,-3.8571,-9.9381,-9.5279,-3.4028,-9.3204,-9.0272,-3.9762,-8.5665,-7.8714,-3.8295,-8.1131,-6.3069,-5.1730,-7.2866,-7.5728,-8.2623,-7.9852,-8.5648,-8.6222,-8.1920,-9.8446,-8.9961,-8.4230,-10.3388,-8.9472,-8.4587,-11.2878,-8.9475,-8.4586,-11.6073,-8.9557,-8.4527,-11.6501,-9.4792,-8.3946,-11.9952,-9.4894,-8.4116,-12.3582,-9.5298,-8.4798,-13.8094,-8.7578,-8.0328,-14.9991,-8.5041,-7.4886,-16.0184,-4.1680,-7.0990,-14.5141,-3.5446,-7.9691,-13.3300,-3.2493,-8.4873,-11.9088,-3.3299,-9.4786,-11.8938,-3.3122,-10.1406,-11.4481,-3.3135,-10.4998,-11.0318,-3.3153,-10.5993,-10.6332,-3.3136,-10.4900,-10.2065,-3.3130,-10.1247,-10.1961,-3.3302,-9.4784,-8.7793,-3.2499,-8.4867};
			return value;
		}
		private double[] getCI_3_26_keyValue_11()
		{
			double[] value = {-7.5943,-3.5456,-7.9683,-6.0865,-4.1697,-7.0976,-7.0966,-8.5027,-7.4885,-8.2890,-8.7564,-8.0329,-9.7414,-9.5287,-8.4801,-10.2877,-9.4686,-8.3777,-11.3050,-9.4690,-8.3776,-11.6501,-9.4792,-8.3946,-11.8707,-10.3091,-8.1867,-12.3102,-10.2410,-8.1993,-12.5476,-9.9675,-8.2500,-14.2860,-8.9569,-7.7726,-15.4467,-7.9858,-7.0059,-16.1989,-3.0285,-6.9754,-14.8646,-2.9778,-7.6712,-13.5360,-2.7742,-8.5187,-11.7357,-2.8299,-9.2699,-11.9086,-2.8178,-9.8495,-11.4709,-2.8188,-10.1543,-11.0330,-2.8200,-10.2376,-10.6136,-2.8189,-10.1461,-10.1996,-2.8184,-9.8356,-10.3722,-2.8302,-9.2697,-8.5741,-2.7749,-8.5181,-7.2460,-2.9789,-7.6703,-5.9099,-3.0302,-6.9741,-6.6502,-7.9849,-7.0055,-7.8115,-8.9551,-7.7728,-9.5531,-9.9661,-8.2504,-9.9105,-10.3764,-8.1744,-11.4312,-10.3773,-8.1741,-11.8707,-10.3091,-8.1867,-11.9751,-10.3770,-7.7866,-12.5400,-10.3081,-7.8378,-13.3704,-10.0314,-8.0429,-14.3440,-9.0799,-7.4323,-15.9211,-7.5411,-6.4816,-16.3224,-2.6222,-6.7773,-15.1119,-2.0978,-7.7311,-14.0632,-1.4525,-7.6491,-11.6049,-0.9886,-8.6732,-11.4903,-1.0976,-8.8265,-11.2539,-1.0933,-8.8204,-11.0493,-1.0845,-8.8079,-10.8529,-1.0942,-8.8215,-10.6222,-1.0952,-8.8228,-10.5112,-0.9887,-8.6731,-8.0538,-1.4532,-7.6486,-7.0003,-2.0991,-7.7302,-5.7882,-2.6239,-6.7760,-6.1767,-7.5407,-6.4809,-7.7555,-9.0779,-7.4326,-8.7288,-10.0291,-8.0435,-9.9806,-10.4452,-7.7357,-11.4101,-10.4460,-7.7354,-11.9751,-10.3770,-7.7866,-12.0730,-10.4184,-7.5381,-12.6754,-10.3542,-7.5987,-13.4174,-10.0964,-7.8413,-14.4295,-9.0750,-7.0069,-16.0651,-7.4989,-6.2942,-16.4745,-1.6221,-6.5524,-15.5363,-1.5100,-7.6004,-13.8214,-1.3976,-7.4182,-12.3745,-0.6932,-8.4252,-11.8685,-0.9139,-8.5976,-11.4033,-0.7811,-8.6261,-11.0438,-0.7140,-8.6261,-10.6988,-0.7877,-8.6260,-10.2362,-0.9089,-8.5934,-9.7430,-0.6935,-8.4250,-8.2972,-1.3982,-7.4178,-6.5769,-1.5114,-7.5994,-5.6396,-1.6237,-6.5512,-6.0328,-7.4985,-6.2935,-7.6725,-9.0729,-7.0074,-8.6830,-10.0941,-7.8420,-9.8026,-10.4816,-7.4779,-11.4705,-10.4826,-7.4776,-12.0730,-10.4184,-7.5381,-12.1274,-10.4374,-7.3332,-12.7570,-10.3716,-7.3648,-13.4999,-10.1072,-7.4913,-14.4427,-9.0602,-6.8042,-16.3154,-7.5496,-5.8965,-16.5603,-0.8174,-6.3235,-16.0214,-0.7488,-7.3505,-14.0773,-0.5457,-7.7128,-12.4676,0.5435,-8.8213,-11.8624,0.4118,-8.7568,-11.3929,0.3260,-8.7890,-11.0448,0.3004,-8.8060,-10.7111,0.3284,-8.7873,-10.2417,0.4147,-8.7582,-9.6502,0.5431,-8.8210,-8.0413,-0.5463,-7.7124,-6.0933,-0.7503,-7.3494,-5.5565,-0.8189,-6.3225,-5.7826,-7.5492,-5.8957,-7.6606,-9.0581,-6.8046};
			return value;
		}
		private double[] getCI_3_26_keyValue_12()
		{
			double[] value = {-8.6028,-10.1047,-7.4920,-9.7226,-10.5022,-7.3021,-11.4979,-10.5033,-7.3017,-12.1274,-10.4374,-7.3332,-12.1785,-10.4244,-7.1139,-12.8270,-10.3576,-7.1222,-13.5199,-10.0891,-7.1559,-14.4702,-9.0868,-6.5777,-16.4676,-7.4580,-5.6456,-16.7230,-0.6472,-5.9103,-16.4438,1.4278,-7.3677,-14.9219,1.0252,-7.7020,-12.6499,1.6446,-8.7568,-12.0965,1.2955,-8.8380,-11.5085,1.4412,-8.8332,-11.0408,1.5218,-8.8260,-10.5920,1.4333,-8.8339,-10.0097,1.3035,-8.8360,-9.4697,1.6442,-8.7566,-7.1978,1.0243,-7.7015,-5.6740,1.4263,-7.3667,-5.3952,-0.6486,-5.9093,-5.6307,-7.4578,-5.6447,-7.6345,-9.0846,-6.5782,-8.5853,-10.0866,-7.1567,-9.6287,-10.4902,-7.1060,-11.5300,-10.4913,-7.1056,-12.1785,-10.4244,-7.1139,-12.1971,-10.4333,-6.7686,-12.8596,-10.3713,-6.7769,-13.5951,-10.1223,-6.8105,-14.5049,-9.0613,-6.2809,-16.6282,-7.5008,-5.2973,-16.9186,-0.0995,-5.5469,-16.6968,2.7218,-6.6630,-15.6381,2.2935,-7.3765,-13.1618,2.9928,-8.2005,-12.4111,3.3870,-8.1033,-11.6428,3.1039,-8.3600,-11.0364,2.9657,-8.4682,-10.4552,3.1171,-8.3494,-9.6946,3.3776,-8.1055,-8.9605,2.9924,-8.2003,-6.4828,2.2926,-7.3759,-5.4241,2.7206,-6.6622,-5.2012,-0.1009,-5.5460,-5.4705,-7.5006,-5.2964,-7.6017,-9.0591,-6.2814,-8.5121,-10.1197,-6.8113,-9.6198,-10.4942,-6.7607,-11.5345,-10.4953,-6.7603,-12.1971,-10.4333,-6.7686,-12.1952,-10.4132,-6.2411,-12.8708,-10.3476,-6.2517,-13.7261,-10.0845,-6.2941,-14.5375,-9.0601,-6.0380,-16.7921,-7.5280,-4.8135,-17.2088,0.5789,-5.0618,-17.0402,3.4954,-5.0082,-15.7686,4.3832,-6.2667,-13.8196,4.9297,-6.7465,-12.6884,5.6870,-6.6340,-11.7459,5.9043,-6.6385,-11.0341,5.9413,-6.6476,-10.3514,5.9007,-6.6376,-9.4112,5.6691,-6.6366,-8.3060,4.9294,-6.7463,-6.3557,4.3825,-6.2663,-5.0842,3.4946,-5.0076,-4.9125,0.5777,-5.0609,-5.3074,-7.5278,-4.8126,-7.5705,-9.0579,-6.0386,-8.3840,-10.0820,-6.2950,-9.6722,-10.4778,-6.2310,-11.5195,-10.4787,-6.2306,-12.1952,-10.4132,-6.2411,-12.1964,-10.4141,-5.5570,-12.8872,-10.3471,-5.5537,-13.8665,-10.0784,-5.5409,-14.5517,-9.0468,-5.6155,-16.8882,-7.6099,-4.7480,-17.3519,1.4013,-2.9604,-17.2800,3.7621,-3.8426,-15.3929,5.5397,-3.4755,-15.0941,6.0754,-4.4240,-12.5955,7.0764,-3.7975,-11.5962,7.0577,-4.0457,-11.0417,6.9851,-4.1850,-10.5099,7.0647,-4.0322,-9.4744,7.0528,-3.8121,-7.0333,6.0751,-4.4238,-6.7353,5.5394,-3.4753,-4.8457,3.7613,-3.8421,-4.7738,1.4005,-2.9599,-5.2104,-7.6097,-4.7470,-7.5589,-9.0447,-5.6161,-8.2477,-10.0760,-5.5417,-9.7220,-10.4803,-5.5605,-11.5057,-10.4811,-5.5602,-12.1964,-10.4141,-5.5570};
			return value;
		}
		private double[] getCI_3_26_keyValue_13()
		{
			double[] value = {-12.2022,-10.5011,-5.1846,-12.8945,-10.4346,-5.1204,-13.8657,-10.1682,-4.8637,-14.5959,-9.0339,-5.1626,-16.8440,-7.6897,-4.1612,-17.5753,1.4839,-2.1512,-16.5025,3.7693,-1.3418,-15.6024,5.6542,-0.6076,-15.0396,6.0579,-0.7828,-12.6002,7.4644,-0.6486,-11.6032,7.5852,-0.6540,-11.0419,7.5416,-0.6649,-10.5035,7.5894,-0.6529,-9.4721,7.4313,-0.6518,-7.0898,6.0578,-0.7827,-6.5269,5.6540,-0.6075,-5.6263,3.7691,-1.3416,-4.5507,1.4832,-2.1507,-5.2578,-7.6892,-4.1605,-7.5171,-9.0320,-5.1632,-8.2524,-10.1661,-4.8645,-9.7123,-10.5668,-5.2491,-11.5100,-10.5675,-5.2488,-12.2022,-10.5011,-5.1846,-12.1554,-10.6541,-4.8816,-12.8228,-10.6299,-4.7893,-13.7853,-10.5323,-4.4205,-14.5941,-9.1434,-4.8518,-16.8658,-7.7204,-3.5573,-17.2249,0.8681,-0.5763,-17.1903,3.5627,0.2760,-15.4181,4.7291,2.3249,-15.0888,5.2702,2.5954,-12.5967,6.3641,2.4240,-11.5976,6.2385,2.4308,-11.0424,6.1175,2.4447,-10.5098,6.2502,2.4295,-9.4747,6.3383,2.4280,-7.0406,5.2701,2.5955,-6.7113,4.7289,2.3250,-4.9379,3.5623,0.2762,-4.9023,0.8676,-0.5759,-5.2385,-7.7198,-3.5568,-7.5206,-9.1414,-4.8524,-8.3353,-10.5303,-4.4213,-9.7811,-10.6778,-4.9741,-11.4880,-10.6784,-4.9739,-12.1554,-10.6541,-4.8816,-12.1060,-10.9330,-4.6566,-12.7567,-10.9282,-4.5755,-13.7861,-10.9082,-4.2514,-14.5248,-9.3676,-4.6029,-16.7072,-7.9939,-3.0695,-17.0226,-0.9850,0.5426,-16.9565,2.9546,1.8872,-16.1912,2.5166,4.5379,-15.5456,3.4371,5.0361,-13.2758,3.5056,5.3825,-11.9367,3.9793,5.3686,-11.0276,4.1629,5.3406,-10.1555,3.9615,5.3714,-8.7999,3.5039,5.3744,-6.5822,3.4367,5.0364,-5.9363,2.5161,4.5382,-5.1717,2.9542,1.8874,-5.1036,-0.9856,0.5430,-5.4001,-7.9928,-3.0692,-7.5915,-9.3656,-4.6035,-8.3352,-10.9060,-4.2523,-9.8819,-10.9373,-4.7379,-11.4553,-10.9379,-4.7377,-12.1060,-10.9330,-4.6566,-12.0732,-11.1528,-4.5757,-12.7135,-11.1481,-4.5052,-13.7918,-11.1287,-4.2236,-14.5627,-9.8955,-4.4443,-16.6615,-8.0917,-2.9090,-16.6587,-3.0363,0.6342,-16.8846,1.8437,3.1275,-16.6978,0.7696,4.9108,-13.6273,0.3333,5.7719,-12.7315,0.6974,6.1051,-11.7850,0.2351,6.2334,-11.0332,0.0278,6.2627,-10.3122,0.2551,6.2306,-9.3754,0.6887,6.0973,-8.5005,0.3331,5.7721,-5.4274,0.7686,4.9113,-5.2428,1.8431,3.1278,-5.4661,-3.0369,0.6346,-5.4466,-8.0905,-2.9088,-7.5537,-9.8930,-4.4451,-8.3295,-11.1263,-4.2246,-9.9501,-11.1570,-4.6463,-11.4329,-11.1575,-4.6461,-12.0732,-11.1528,-4.5757,-12.0351,-11.3996,-4.4765,-12.6585,-11.4059,-4.4162,-13.7547,-11.4304,-4.1756,-14.6064,-10.1352,-4.3637};
			return value;
		}
		private double[] getCI_3_26_keyValue_14()
		{
			double[] value = {-16.5974,-8.6171,-2.9881,-16.3120,-4.9811,0.8818,-16.8553,-2.2190,2.4587,-15.7416,-1.2005,4.9483,-13.8543,-2.2669,5.2052,-12.4460,-2.3691,5.9513,-11.6095,-2.1277,6.1529,-11.0401,-2.0251,6.1844,-10.4938,-2.1376,6.1499,-9.6474,-2.3668,5.9339,-8.2724,-2.2672,5.2054,-6.3836,-1.2012,4.9488,-5.2690,-2.2199,2.4592,-5.8115,-4.9814,0.8822,-5.5094,-8.6153,-2.9883,-7.5100,-10.1324,-4.3647,-8.3669,-11.4279,-4.1766,-10.0146,-11.3928,-4.5369,-11.4118,-11.3933,-4.5367,-12.0351,-11.3996,-4.4765,-12.1051,-11.5751,-4.4670,-12.7427,-11.5859,-4.4168,-13.6718,-11.6281,-4.2160,-14.7164,-10.6749,-4.1591,-16.3313,-9.2758,-3.4638,-16.3977,-5.9130,0.6407,-16.3480,-5.0769,1.0773,-15.8217,-2.5700,4.1197,-13.4344,-5.2508,4.3582,-12.2289,-5.2278,4.6354,-11.5226,-5.2287,4.6242,-11.0444,-5.2305,4.6017,-10.5856,-5.2285,4.6264,-9.8703,-5.2284,4.6289,-8.6924,-5.2509,4.3582,-6.3031,-2.5706,4.1201,-5.7752,-5.0773,1.0777,-5.7242,-5.9132,0.6410,-5.7744,-9.2729,-3.4644,-7.3996,-10.6714,-4.1604,-8.4499,-11.6255,-4.2171,-9.8467,-11.5638,-4.5175,-11.4676,-11.5644,-4.5173,-12.1051,-11.5751,-4.4670,-12.1066,-11.8205,-4.4340,-12.7431,-11.8201,-4.3941,-13.6580,-11.8182,-4.2345,-14.7716,-11.1754,-4.1132,-16.1658,-10.0111,-3.3628,-16.4367,-6.3544,0.0620,-16.3342,-7.1869,0.7602,-15.8248,-3.6435,3.4027,-13.4324,-6.4688,3.4082,-12.2361,-6.2574,3.5520,-11.5271,-6.5955,3.5462,-11.0449,-6.7436,3.5346,-10.5824,-6.5812,3.5474,-9.8647,-6.2624,3.5487,-8.6957,-6.4687,3.4083,-6.2998,-3.6440,3.4031,-5.7860,-7.1866,0.7603,-5.6841,-6.3545,0.0623,-5.9401,-10.0069,-3.3640,-7.3436,-11.1711,-4.1149,-8.4637,-11.8155,-4.2357,-9.8393,-11.8201,-4.4743,-11.4702,-11.8208,-4.4740,-12.1066,-11.8205,-4.4340,-12.1144,-12.0745,-4.4602,-12.7513,-12.0932,-4.4102,-13.6375,-12.1671,-4.2107,-14.8761,-11.5438,-4.2174,-16.0284,-10.7719,-2.7507,-16.2833,-8.3526,-0.8624,-16.3741,-8.1695,0.5461,-15.8057,-7.0390,1.9889,-13.4586,-8.2137,3.5256,-12.1629,-8.3527,3.2670,-11.4847,-8.3469,3.2773,-11.0468,-8.3356,3.2982,-10.6269,-8.3480,3.2752,-9.9358,-8.3493,3.2730,-8.6689,-8.2134,3.5255,-6.3172,-7.0387,1.9889,-5.7440,-8.1684,0.5460,-5.8340,-8.3513,-0.8626,-6.0797,-10.7663,-2.7527,-7.2369,-11.5384,-4.2196,-8.4841,-12.1640,-4.2120,-9.8166,-12.0551,-4.5105,-11.4776,-12.0559,-4.5101,-12.1144,-12.0745,-4.4602,-12.1032,-12.3162,-4.4667,-12.7359,-12.3394,-4.4177,-13.6349,-12.4314,-4.2221,-14.8416,-11.9554,-4.2901,-16.0250,-11.5554,-2.5280,-16.2599,-10.0355,-0.5854,-16.3748,-10.4023,0.7665,-15.7993,-9.1232,2.5708};
			return value;
		}
		private double[] getCI_3_26_keyValue_15()
		{
			double[] value = {-13.4665,-10.3377,4.0146,-12.1382,-10.5782,3.8834,-11.4704,-10.5682,3.8885,-11.0472,-10.5486,3.8990,-10.6414,-10.5700,3.8874,-9.9594,-10.5722,3.8863,-8.6606,-10.3365,4.0141,-6.3209,-9.1214,2.5702,-5.7384,-10.3979,0.7648,-5.8542,-10.0319,-0.5866,-6.0808,-11.5474,-2.5312,-7.2706,-11.9491,-4.2927,-8.4875,-12.4283,-4.2235,-9.8382,-12.2923,-4.5160,-11.4704,-12.2931,-4.5157,-12.1032,-12.3162,-4.4667,-12.1093,-12.7048,-4.6697,-12.7327,-12.7124,-4.6365,-13.5318,-12.7420,-4.5042,-15.2397,-12.5001,-4.1466,-16.2359,-12.5979,-2.0875,-16.7586,-12.4391,-0.2510,-16.2385,-12.7907,1.6013,-15.8320,-12.1995,2.7774,-13.4566,-12.3041,5.0461,-12.1390,-12.7705,4.8987,-11.4716,-12.7511,4.9043,-11.0473,-12.7128,4.9160,-10.6403,-12.7543,4.9029,-9.9590,-12.7583,4.9016,-8.6705,-12.3009,5.0445,-6.2850,-12.1901,2.7732,-5.8756,-12.7795,1.5963,-5.3444,-12.4277,-0.2556,-5.8681,-12.5863,-2.0923,-6.8699,-12.4918,-4.1501,-8.5898,-12.7385,-4.5057,-9.7913,-12.6962,-4.7033,-11.4859,-12.6971,-4.7029,-12.1093,-12.7048,-4.6697,-11.7578,-6.7464,-6.3137,-12.1236,-6.7185,-6.3208,-12.2527,-6.6067,-6.3488,-12.9135,-6.5388,-6.1805,-13.2555,-6.5671,-6.2433,-13.3467,-6.0869,-6.2392,-13.0345,-6.1151,-6.2725,-12.6849,-6.0054,-6.3250,-12.4115,-6.0347,-6.3110,-11.8663,-6.0277,-6.3143,-11.3996,-6.0279,-6.3142,-11.0448,-6.0284,-6.3139,-10.7044,-6.0278,-6.3142,-10.2390,-6.0278,-6.3142,-9.7061,-6.0346,-6.3109,-9.4321,-6.0053,-6.3249,-9.0820,-6.1149,-6.2724,-8.7692,-6.0867,-6.2390,-8.8599,-6.5668,-6.2433,-9.2032,-6.5386,-6.1805,-9.8642,-6.6066,-6.3488,-10.0582,-6.7742,-6.3067,-11.3921,-6.7743,-6.3067,-11.7578,-6.7464,-6.3137,-11.6030,-7.9766,-6.1488,-11.9363,-7.9616,-6.1558,-12.4259,-7.9017,-6.1838,-13.2492,-8.2633,-6.0153,-14.0886,-7.6470,-6.0782,-15.0765,-5.7190,-6.0746,-13.8819,-4.4841,-6.1083,-13.3069,-4.6315,-6.1608,-11.3438,-4.5916,-6.1468,-11.9470,-4.6009,-6.1501,-11.5278,-4.6005,-6.1500,-11.0407,-4.5997,-6.1497,-10.5734,-4.6006,-6.1499,-10.1880,-4.6007,-6.1499,-10.7773,-4.5916,-6.1468,-8.8119,-4.6316,-6.1606,-8.2360,-4.4843,-6.1081,-7.0343,-5.7192,-6.0740,-8.0234,-7.6462,-6.0783,-8.8659,-8.2624,-6.0155,-9.6905,-7.9012,-6.1839,-10.4261,-7.9914,-6.1419,-11.2697,-7.9915,-6.1419,-11.6030,-7.9766,-6.1488,-11.6080,-7.8431,-7.9041,-11.9028,-7.8274,-7.9111,-12.0410,-7.7644,-7.9391,-13.2615,-8.1429,-7.7706,-13.9667,-7.5727,-7.8337,-14.9137,-5.8044,-7.8305,-13.8868,-4.6161,-7.8642,-13.0560,-4.7729,-7.9165,-12.3076,-4.7307,-7.9025,-11.8700,-4.7405,-7.9057,-11.4079,-4.7401,-7.9056,-11.0408,-4.7393,-7.9053};
			return value;
		}
		private double[] getCI_3_26_keyValue_16()
		{
			double[] value = {-10.6886,-4.7402,-7.9056,-10.2308,-4.7404,-7.9055,-9.8031,-4.7308,-7.9023,-9.0533,-4.7731,-7.9162,-8.2211,-4.6166,-7.8636,-7.1868,-5.8050,-7.8296,-8.1341,-7.5721,-7.8336,-8.8419,-8.1421,-7.7707,-10.0646,-7.7641,-7.9391,-10.2724,-7.8585,-7.8971,-11.3133,-7.8587,-7.8971,-11.6080,-7.8431,-7.9041,-11.7411,-6.5034,-8.3343,-12.1120,-6.4742,-8.3414,-12.3235,-6.3574,-8.3696,-12.7601,-6.3194,-8.2009,-13.0094,-6.4316,-8.2655,-13.0988,-6.2393,-8.2545,-12.9193,-6.3550,-8.3128,-12.7061,-6.2490,-8.2718,-12.3951,-6.3225,-8.6066,-11.8592,-6.1624,-8.5282,-11.3932,-6.1688,-8.5314,-11.0376,-6.1818,-8.5377,-10.6966,-6.1675,-8.5307,-10.2322,-6.1662,-8.5300,-9.7073,-6.3225,-8.6064,-9.3982,-6.2490,-8.2716,-9.1840,-6.3550,-8.3126,-9.0047,-6.2393,-8.2542,-9.0939,-6.4315,-8.2652,-9.3445,-6.3194,-8.2007,-9.7806,-6.3573,-8.3694,-10.0983,-6.5325,-8.3272,-11.3703,-6.5325,-8.3273,-11.7411,-6.5034,-8.3343,-11.7252,-6.6688,-8.9651,-12.0870,-6.6401,-8.9914,-12.2801,-6.5253,-9.0965,-12.8529,-6.4751,-8.4661,-13.1680,-6.4987,-8.4925,-13.2565,-6.2361,-8.7108,-12.9884,-6.1741,-8.9398,-12.6839,-6.0900,-9.0936,-12.3981,-6.1574,-9.1862,-11.8566,-5.9987,-9.1646,-11.3904,-6.0051,-9.1654,-11.0356,-6.0180,-9.1671,-10.6952,-6.0039,-9.1651,-10.2305,-6.0025,-9.1649,-9.7004,-6.1575,-9.1859,-9.4150,-6.0902,-9.0933,-9.1107,-6.1743,-8.9394,-8.8433,-6.2362,-8.7104,-8.9331,-6.4987,-8.4922,-9.2492,-6.4751,-8.4659,-9.8185,-6.5253,-9.0963,-10.1094,-6.6974,-8.9387,-11.3634,-6.6975,-8.9388,-11.7252,-6.6688,-8.9651,-11.7052,-6.9152,-8.9148,-12.0527,-6.8878,-8.9765,-12.2119,-6.7783,-9.2234,-13.0192,-6.6980,-8.6275,-13.3102,-6.6375,-8.4724,-13.5219,-6.0859,-8.7726,-13.0882,-5.9402,-9.1005,-12.6560,-5.8397,-9.4460,-12.4046,-5.9114,-9.4397,-11.8553,-5.7518,-9.4412,-11.3888,-5.7582,-9.4411,-11.0349,-5.7711,-9.4409,-10.6954,-5.7570,-9.4410,-10.2301,-5.7557,-9.4409,-9.6926,-5.9116,-9.4393,-9.4409,-5.8400,-9.4456,-9.0100,-5.9404,-9.1000,-8.5770,-6.0861,-8.7720,-8.7904,-6.6374,-8.4720,-9.0809,-6.6979,-8.6272,-9.8854,-6.7783,-9.2232,-10.1270,-6.9425,-8.8530,-11.3577,-6.9425,-8.8530,-11.7052,-6.9152,-8.9148,-11.6502,-7.2713,-8.6786,-11.9655,-7.2442,-8.6874,-12.0888,-7.1353,-8.7225,-13.2240,-7.3040,-8.6894,-13.6243,-6.8649,-8.4265,-13.9721,-5.6859,-8.6914,-13.2974,-5.7401,-8.8112,-12.6597,-5.3683,-9.2812,-12.1895,-5.3573,-9.3395,-11.8717,-5.4363,-9.4519,-11.4149,-5.4332,-9.4473,-11.0342,-5.4268,-9.4381,-10.6690,-5.4338,-9.4481,-10.2199,-5.4346,-9.4490,-9.9102,-5.3575,-9.3392,-9.4397,-5.3687,-9.2808};
			return value;
		}
		private double[] getCI_3_26_keyValue_17()
		{
			double[] value = {-8.8028,-5.7405,-8.8107,-8.1270,-5.6864,-8.6907,-8.4751,-6.8648,-8.4261,-8.8739,-7.3038,-8.6892,-10.0118,-7.1352,-8.7224,-10.1972,-7.2984,-8.6698,-11.3349,-7.2985,-8.6699,-11.6502,-7.2713,-8.6786,-11.6067,-7.5584,-8.5898,-11.8991,-7.5984,-8.5615,-12.0140,-7.7580,-8.4484,-13.3542,-7.6863,-8.5690,-13.8224,-7.2778,-8.3965,-14.4606,-5.6560,-8.4649,-13.5315,-5.3637,-8.5927,-12.8937,-4.8990,-8.8226,-12.1626,-5.2998,-9.2282,-11.8748,-5.0172,-9.3425,-11.4191,-5.0285,-9.3353,-11.0350,-5.0515,-9.3249,-10.6664,-5.0264,-9.3362,-10.2193,-5.0240,-9.3396,-9.9381,-5.3001,-9.2279,-9.2097,-4.8994,-8.8221,-8.5705,-5.3641,-8.5922,-7.6382,-5.6567,-8.4640,-8.2756,-7.2775,-8.3961,-8.7436,-7.6858,-8.5688,-10.0879,-7.7577,-8.4484,-10.2595,-7.5184,-8.6181,-11.3143,-7.5185,-8.6181,-11.6067,-7.5584,-8.5898,-11.5903,-8.0358,-8.4426,-11.8895,-8.0546,-8.4297,-12.1261,-8.1296,-8.3779,-13.3419,-8.1023,-8.4911,-14.0591,-7.6287,-8.3228,-15.0008,-5.5996,-8.0218,-13.8058,-4.8398,-8.4008,-13.2667,-4.6826,-8.7134,-11.5262,-4.7356,-9.2539,-11.9241,-4.4749,-8.9891,-11.4953,-4.6412,-9.3098,-11.0317,-4.7243,-9.4544,-10.5883,-4.6333,-9.2957,-10.1900,-4.4812,-8.9951,-10.5763,-4.7357,-9.2538,-8.8372,-4.6831,-8.7128,-8.2982,-4.8404,-8.4001,-7.0987,-5.6005,-8.0207,-8.0377,-7.6282,-8.3225,-8.7558,-8.1016,-8.4910,-9.9758,-8.1291,-8.3779,-10.3306,-8.0169,-8.4556,-11.2910,-8.0170,-8.4556,-11.5903,-8.0358,-8.4426,-11.5701,-8.2823,-8.4684,-11.8689,-8.3492,-8.4729,-12.1829,-8.6162,-8.4909,-13.4186,-8.4335,-8.3360,-14.2852,-7.8442,-8.1850,-15.3916,-5.5471,-7.6866,-14.0573,-4.3973,-8.2159,-13.0274,-4.2775,-8.6720,-12.5707,-4.2994,-9.1457,-11.3955,-4.6512,-9.4821,-11.1227,-4.6214,-9.5618,-11.0474,-4.5866,-9.5715,-10.9750,-4.6247,-9.5608,-10.6782,-4.6430,-9.4741,-9.5328,-4.2998,-9.1453,-9.0785,-4.2780,-8.6715,-8.0485,-4.3981,-8.2152,-6.7082,-5.5481,-7.6855,-7.8111,-7.8435,-8.1847,-8.6796,-8.4325,-8.3360,-9.9175,-8.6156,-8.4910,-10.3897,-8.2153,-8.4639,-11.2712,-8.2155,-8.4639,-11.5701,-8.2823,-8.4684,-11.6073,-8.9557,-8.4527,-11.9269,-8.9640,-8.4467,-12.2560,-8.9969,-8.4229,-13.5339,-8.6234,-8.1919,-14.5228,-8.2634,-7.9854,-15.7945,-5.1717,-7.2880,-14.2361,-3.8287,-8.1139,-13.0801,-3.9757,-8.5670,-12.5771,-3.4023,-9.3208,-11.8440,-3.8678,-9.9532,-11.3695,-4.3205,-9.8694,-11.0362,-4.4701,-9.7949,-10.7164,-4.3062,-9.8765,-10.2389,-3.8571,-9.9381,-9.5279,-3.4028,-9.3204,-9.0272,-3.9762,-8.5665,-7.8714,-3.8295,-8.1131,-6.3069,-5.1730,-7.2866,-7.5728,-8.2623,-7.9852,-8.5648,-8.6222,-8.1920};
			return value;
		}
		private double[] getCI_3_26_keyValue_18()
		{
			double[] value = {-9.8446,-8.9961,-8.4230,-10.3388,-8.9472,-8.4587,-11.2878,-8.9475,-8.4586,-11.6073,-8.9557,-8.4527,-11.6501,-9.4792,-8.3946,-11.9952,-9.4894,-8.4116,-12.3582,-9.5298,-8.4798,-13.8094,-8.7578,-8.0328,-14.9991,-8.5041,-7.4886,-16.0184,-4.1680,-7.0990,-14.5141,-3.5446,-7.9691,-13.3300,-3.2493,-8.4873,-11.9088,-3.3299,-9.4786,-11.8938,-3.3122,-10.1406,-11.4481,-3.3135,-10.4998,-11.0318,-3.3153,-10.5993,-10.6332,-3.3136,-10.4900,-10.2065,-3.3130,-10.1247,-10.1961,-3.3302,-9.4784,-8.7793,-3.2499,-8.4867,-7.5943,-3.5456,-7.9683,-6.0865,-4.1697,-7.0976,-7.0966,-8.5027,-7.4885,-8.2890,-8.7564,-8.0329,-9.7414,-9.5287,-8.4801,-10.2877,-9.4686,-8.3777,-11.3050,-9.4690,-8.3776,-11.6501,-9.4792,-8.3946,-11.8707,-10.3091,-8.1867,-12.3102,-10.2410,-8.1993,-12.5476,-9.9675,-8.2500,-14.2860,-8.9569,-7.7726,-15.4467,-7.9858,-7.0059,-16.1989,-3.0285,-6.9754,-14.8646,-2.9778,-7.6712,-13.5360,-2.7742,-8.5187,-11.7357,-2.8299,-9.2699,-11.9086,-2.8178,-9.8495,-11.4709,-2.8188,-10.1543,-11.0330,-2.8200,-10.2376,-10.6136,-2.8189,-10.1461,-10.1996,-2.8184,-9.8356,-10.3722,-2.8302,-9.2697,-8.5741,-2.7749,-8.5181,-7.2460,-2.9789,-7.6703,-5.9099,-3.0302,-6.9741,-6.6502,-7.9849,-7.0055,-7.8115,-8.9551,-7.7728,-9.5531,-9.9661,-8.2504,-9.9105,-10.3764,-8.1744,-11.4312,-10.3773,-8.1741,-11.8707,-10.3091,-8.1867,-11.9751,-10.3770,-7.7866,-12.5400,-10.3081,-7.8378,-13.3704,-10.0314,-8.0429,-14.3440,-9.0799,-7.4323,-15.9211,-7.5411,-6.4816,-16.3224,-2.6222,-6.7773,-15.1119,-2.0978,-7.7311,-14.0632,-1.4525,-7.6491,-11.6049,-0.9886,-8.6732,-11.4903,-1.0976,-8.8265,-11.2539,-1.0933,-8.8204,-11.0493,-1.0845,-8.8079,-10.8529,-1.0942,-8.8215,-10.6222,-1.0952,-8.8228,-10.5112,-0.9887,-8.6731,-8.0538,-1.4532,-7.6486,-7.0003,-2.0991,-7.7302,-5.7882,-2.6239,-6.7760,-6.1767,-7.5407,-6.4809,-7.7555,-9.0779,-7.4326,-8.7288,-10.0291,-8.0435,-9.9806,-10.4452,-7.7357,-11.4101,-10.4460,-7.7354,-11.9751,-10.3770,-7.7866,-12.0730,-10.4184,-7.5381,-12.6754,-10.3542,-7.5987,-13.4174,-10.0964,-7.8413,-14.4295,-9.0750,-7.0069,-16.0651,-7.4989,-6.2942,-16.4745,-1.6221,-6.5524,-15.5363,-1.5100,-7.6004,-13.8214,-1.3976,-7.4182,-12.3745,-0.6932,-8.4252,-11.8685,-0.9139,-8.5976,-11.4033,-0.7811,-8.6261,-11.0438,-0.7140,-8.6261,-10.6988,-0.7877,-8.6260,-10.2362,-0.9089,-8.5934,-9.7430,-0.6935,-8.4250,-8.2972,-1.3982,-7.4178,-6.5769,-1.5114,-7.5994,-5.6396,-1.6237,-6.5512,-6.0328,-7.4985,-6.2935,-7.6725,-9.0729,-7.0074,-8.6830,-10.0941,-7.8420,-9.8026,-10.4816,-7.4779,-11.4705,-10.4826,-7.4776,-12.0730,-10.4184,-7.5381};
			return value;
		}
		private double[] getCI_3_26_keyValue_19()
		{
			double[] value = {-12.1274,-10.4374,-7.3332,-12.7570,-10.3716,-7.3648,-13.4999,-10.1072,-7.4913,-14.4427,-9.0602,-6.8042,-16.3154,-7.5496,-5.8965,-16.5603,-0.8174,-6.3235,-16.0214,-0.7488,-7.3505,-14.0773,-0.5457,-7.7128,-12.4676,0.5435,-8.8213,-11.8624,0.4118,-8.7568,-11.3929,0.3260,-8.7890,-11.0448,0.3004,-8.8060,-10.7111,0.3284,-8.7873,-10.2417,0.4147,-8.7582,-9.6502,0.5431,-8.8210,-8.0413,-0.5463,-7.7124,-6.0933,-0.7503,-7.3494,-5.5565,-0.8189,-6.3225,-5.7826,-7.5492,-5.8957,-7.6606,-9.0581,-6.8046,-8.6028,-10.1047,-7.4920,-9.7226,-10.5022,-7.3021,-11.4979,-10.5033,-7.3017,-12.1274,-10.4374,-7.3332,-12.1785,-10.4244,-7.1139,-12.8270,-10.3576,-7.1222,-13.5199,-10.0891,-7.1559,-14.4702,-9.0868,-6.5777,-16.4676,-7.4580,-5.6456,-16.7230,-0.6472,-5.9103,-16.4438,1.4278,-7.3677,-14.9219,1.0252,-7.7020,-12.6499,1.6446,-8.7568,-12.0965,1.2955,-8.8380,-11.5085,1.4412,-8.8332,-11.0408,1.5218,-8.8260,-10.5920,1.4333,-8.8339,-10.0097,1.3035,-8.8360,-9.4697,1.6442,-8.7566,-7.1978,1.0243,-7.7015,-5.6740,1.4263,-7.3667,-5.3952,-0.6486,-5.9093,-5.6307,-7.4578,-5.6447,-7.6345,-9.0846,-6.5782,-8.5853,-10.0866,-7.1567,-9.6287,-10.4902,-7.1060,-11.5300,-10.4913,-7.1056,-12.1785,-10.4244,-7.1139,-12.1971,-10.4333,-6.7686,-12.8596,-10.3713,-6.7769,-13.5951,-10.1223,-6.8105,-14.5049,-9.0613,-6.2809,-16.6282,-7.5008,-5.2973,-16.9186,-0.0995,-5.5469,-16.6968,2.7218,-6.6630,-15.6381,2.2935,-7.3765,-13.1618,2.9928,-8.2005,-12.4111,3.3870,-8.1033,-11.6428,3.1039,-8.3600,-11.0364,2.9657,-8.4682,-10.4552,3.1171,-8.3494,-9.6946,3.3776,-8.1055,-8.9605,2.9924,-8.2003,-6.4828,2.2926,-7.3759,-5.4241,2.7206,-6.6622,-5.2012,-0.1009,-5.5460,-5.4705,-7.5006,-5.2964,-7.6017,-9.0591,-6.2814,-8.5121,-10.1197,-6.8113,-9.6198,-10.4942,-6.7607,-11.5345,-10.4953,-6.7603,-12.1971,-10.4333,-6.7686,-12.1952,-10.4132,-6.2411,-12.8708,-10.3476,-6.2517,-13.7261,-10.0845,-6.2941,-14.5375,-9.0601,-6.0380,-16.7921,-7.5280,-4.8135,-17.2088,0.5789,-5.0618,-17.0402,3.4954,-5.0082,-15.7686,4.3832,-6.2667,-13.8196,4.9297,-6.7465,-12.6884,5.6870,-6.6340,-11.7459,5.9043,-6.6385,-11.0341,5.9413,-6.6476,-10.3514,5.9007,-6.6376,-9.4112,5.6691,-6.6366,-8.3060,4.9294,-6.7463,-6.3557,4.3825,-6.2663,-5.0842,3.4946,-5.0076,-4.9125,0.5777,-5.0609,-5.3074,-7.5278,-4.8126,-7.5705,-9.0579,-6.0386,-8.3840,-10.0820,-6.2950,-9.6722,-10.4778,-6.2310,-11.5195,-10.4787,-6.2306,-12.1952,-10.4132,-6.2411,-12.1964,-10.4141,-5.5570,-12.8872,-10.3471,-5.5537,-13.8665,-10.0784,-5.5409,-14.5517,-9.0468,-5.6155};
			return value;
		}
		private double[] getCI_3_26_keyValue_20()
		{
			double[] value = {-16.8882,-7.6099,-4.7480,-17.3519,1.4013,-2.9604,-17.2800,3.7621,-3.8426,-15.3929,5.5397,-3.4755,-15.0941,6.0754,-4.4240,-12.5955,7.0764,-3.7975,-11.5962,7.0577,-4.0457,-11.0417,6.9851,-4.1850,-10.5099,7.0647,-4.0322,-9.4744,7.0528,-3.8121,-7.0333,6.0751,-4.4238,-6.7353,5.5394,-3.4753,-4.8457,3.7613,-3.8421,-4.7738,1.4005,-2.9599,-5.2104,-7.6097,-4.7470,-7.5589,-9.0447,-5.6161,-8.2477,-10.0760,-5.5417,-9.7220,-10.4803,-5.5605,-11.5057,-10.4811,-5.5602,-12.1964,-10.4141,-5.5570,-12.2022,-10.5011,-5.1846,-12.8945,-10.4346,-5.1204,-13.8657,-10.1682,-4.8637,-14.5959,-9.0339,-5.1626,-16.8440,-7.6897,-4.1612,-17.5753,1.4839,-2.1512,-16.5025,3.7693,-1.3418,-15.6024,5.6542,-0.6076,-15.0396,6.0579,-0.7828,-12.6002,7.4644,-0.6486,-11.6032,7.5852,-0.6540,-11.0419,7.5416,-0.6649,-10.5035,7.5894,-0.6529,-9.4721,7.4313,-0.6518,-7.0898,6.0578,-0.7827,-6.5269,5.6540,-0.6075,-5.6263,3.7691,-1.3416,-4.5507,1.4832,-2.1507,-5.2578,-7.6892,-4.1605,-7.5171,-9.0320,-5.1632,-8.2524,-10.1661,-4.8645,-9.7123,-10.5668,-5.2491,-11.5100,-10.5675,-5.2488,-12.2022,-10.5011,-5.1846,-12.1554,-10.6541,-4.8816,-12.8228,-10.6299,-4.7893,-13.7853,-10.5323,-4.4205,-14.5941,-9.1434,-4.8518,-16.8658,-7.7204,-3.5573,-17.2249,0.8681,-0.5763,-17.1903,3.5627,0.2760,-15.4181,4.7291,2.3249,-15.0888,5.2702,2.5954,-12.5967,6.3641,2.4240,-11.5976,6.2385,2.4308,-11.0424,6.1175,2.4447,-10.5098,6.2502,2.4295,-9.4747,6.3383,2.4280,-7.0406,5.2701,2.5955,-6.7113,4.7289,2.3250,-4.9379,3.5623,0.2762,-4.9023,0.8676,-0.5759,-5.2385,-7.7198,-3.5568,-7.5206,-9.1414,-4.8524,-8.3353,-10.5303,-4.4213,-9.7811,-10.6778,-4.9741,-11.4880,-10.6784,-4.9739,-12.1554,-10.6541,-4.8816,-12.1060,-10.9330,-4.6566,-12.7567,-10.9282,-4.5755,-13.7861,-10.9082,-4.2514,-14.5248,-9.3676,-4.6029,-16.7072,-7.9939,-3.0695,-17.0226,-0.9850,0.5426,-16.9565,2.9546,1.8872,-16.1912,2.5166,4.5379,-15.5456,3.4371,5.0361,-13.2758,3.5056,5.3825,-11.9367,3.9793,5.3686,-11.0276,4.1629,5.3406,-10.1555,3.9615,5.3714,-8.7999,3.5039,5.3744,-6.5822,3.4367,5.0364,-5.9363,2.5161,4.5382,-5.1717,2.9542,1.8874,-5.1036,-0.9856,0.5430,-5.4001,-7.9928,-3.0692,-7.5915,-9.3656,-4.6035,-8.3352,-10.9060,-4.2523,-9.8819,-10.9373,-4.7379,-11.4553,-10.9379,-4.7377,-12.1060,-10.9330,-4.6566,-12.0732,-11.1528,-4.5757,-12.7135,-11.1481,-4.5052,-13.7918,-11.1287,-4.2236,-14.5627,-9.8955,-4.4443,-16.6615,-8.0917,-2.9090,-16.6587,-3.0363,0.6342,-16.8846,1.8437,3.1275,-16.6978,0.7696,4.9108};
			return value;
		}
		private double[] getCI_3_26_keyValue_21()
		{
			double[] value = {-13.6273,0.3333,5.7719,-12.7315,0.6974,6.1051,-11.7850,0.2351,6.2334,-11.0332,0.0278,6.2627,-10.3122,0.2551,6.2306,-9.3754,0.6887,6.0973,-8.5005,0.3331,5.7721,-5.4274,0.7686,4.9113,-5.2428,1.8431,3.1278,-5.4661,-3.0369,0.6346,-5.4466,-8.0905,-2.9088,-7.5537,-9.8930,-4.4451,-8.3295,-11.1263,-4.2246,-9.9501,-11.1570,-4.6463,-11.4329,-11.1575,-4.6461,-12.0732,-11.1528,-4.5757,-12.0351,-11.3996,-4.4765,-12.6585,-11.4059,-4.4162,-13.7547,-11.4304,-4.1756,-14.6064,-10.1352,-4.3637,-16.5974,-8.6171,-2.9881,-16.3120,-4.9811,0.8818,-16.8553,-2.2190,2.4587,-15.7416,-1.2005,4.9483,-13.8543,-2.2669,5.2052,-12.4460,-2.3691,5.9513,-11.6095,-2.1277,6.1529,-11.0401,-2.0251,6.1844,-10.4938,-2.1376,6.1499,-9.6474,-2.3668,5.9339,-8.2724,-2.2672,5.2054,-6.3836,-1.2012,4.9488,-5.2690,-2.2199,2.4592,-5.8115,-4.9814,0.8822,-5.5094,-8.6153,-2.9883,-7.5100,-10.1324,-4.3647,-8.3669,-11.4279,-4.1766,-10.0146,-11.3928,-4.5369,-11.4118,-11.3933,-4.5367,-12.0351,-11.3996,-4.4765,-12.1051,-11.5751,-4.4670,-12.7427,-11.5859,-4.4168,-13.6718,-11.6281,-4.2160,-14.7164,-10.6749,-4.1591,-16.3313,-9.2758,-3.4638,-16.3977,-5.9130,0.6407,-16.3480,-5.0769,1.0773,-15.8217,-2.5700,4.1197,-13.4344,-5.2508,4.3582,-12.2289,-5.2278,4.6354,-11.5226,-5.2287,4.6242,-11.0444,-5.2305,4.6017,-10.5856,-5.2285,4.6264,-9.8703,-5.2284,4.6289,-8.6924,-5.2509,4.3582,-6.3031,-2.5706,4.1201,-5.7752,-5.0773,1.0777,-5.7242,-5.9132,0.6410,-5.7744,-9.2729,-3.4644,-7.3996,-10.6714,-4.1604,-8.4499,-11.6255,-4.2171,-9.8467,-11.5638,-4.5175,-11.4676,-11.5644,-4.5173,-12.1051,-11.5751,-4.4670,-12.1066,-11.8205,-4.4340,-12.7431,-11.8201,-4.3941,-13.6580,-11.8182,-4.2345,-14.7716,-11.1754,-4.1132,-16.1658,-10.0111,-3.3628,-16.4367,-6.3544,0.0620,-16.3342,-7.1869,0.7602,-15.8248,-3.6435,3.4027,-13.4324,-6.4688,3.4082,-12.2361,-6.2574,3.5520,-11.5271,-6.5955,3.5462,-11.0449,-6.7436,3.5346,-10.5824,-6.5812,3.5474,-9.8647,-6.2624,3.5487,-8.6957,-6.4687,3.4083,-6.2998,-3.6440,3.4031,-5.7860,-7.1866,0.7603,-5.6841,-6.3545,0.0623,-5.9401,-10.0069,-3.3640,-7.3436,-11.1711,-4.1149,-8.4637,-11.8155,-4.2357,-9.8393,-11.8201,-4.4743,-11.4702,-11.8208,-4.4740,-12.1066,-11.8205,-4.4340,-12.1144,-12.0745,-4.4602,-12.7513,-12.0932,-4.4102,-13.6375,-12.1671,-4.2107,-14.8761,-11.5438,-4.2174,-16.0284,-10.7719,-2.7507,-16.2833,-8.3526,-0.8624,-16.3741,-8.1695,0.5461,-15.8057,-7.0390,1.9889,-13.4586,-8.2137,3.5256,-12.1629,-8.3527,3.2670,-11.4847,-8.3469,3.2773,-11.0468,-8.3356,3.2982};
			return value;
		}
		private double[] getCI_3_26_keyValue_22()
		{
			double[] value = {-10.6269,-8.3480,3.2752,-9.9358,-8.3493,3.2730,-8.6689,-8.2134,3.5255,-6.3172,-7.0387,1.9889,-5.7440,-8.1684,0.5460,-5.8340,-8.3513,-0.8626,-6.0797,-10.7663,-2.7527,-7.2369,-11.5384,-4.2196,-8.4841,-12.1640,-4.2120,-9.8166,-12.0551,-4.5105,-11.4776,-12.0559,-4.5101,-12.1144,-12.0745,-4.4602,-12.1032,-12.3162,-4.4667,-12.7359,-12.3394,-4.4177,-13.6349,-12.4314,-4.2221,-14.8416,-11.9554,-4.2901,-16.0250,-11.5554,-2.5280,-16.2599,-10.0355,-0.5854,-16.3748,-10.4023,0.7665,-15.7993,-9.1232,2.5708,-13.4665,-10.3377,4.0146,-12.1382,-10.5782,3.8834,-11.4704,-10.5682,3.8885,-11.0472,-10.5486,3.8990,-10.6414,-10.5700,3.8874,-9.9594,-10.5722,3.8863,-8.6606,-10.3365,4.0141,-6.3209,-9.1214,2.5702,-5.7384,-10.3979,0.7648,-5.8542,-10.0319,-0.5866,-6.0808,-11.5474,-2.5312,-7.2706,-11.9491,-4.2927,-8.4875,-12.4283,-4.2235,-9.8382,-12.2923,-4.5160,-11.4704,-12.2931,-4.5157,-12.1032,-12.3162,-4.4667,-12.1093,-12.7048,-4.6697,-12.7327,-12.7124,-4.6365,-13.5318,-12.7420,-4.5042,-15.2397,-12.5001,-4.1466,-16.2359,-12.5979,-2.0875,-16.7586,-12.4391,-0.2510,-16.2385,-12.7907,1.6013,-15.8320,-12.1995,2.7774,-13.4566,-12.3041,5.0461,-12.1390,-12.7705,4.8987,-11.4716,-12.7511,4.9043,-11.0473,-12.7128,4.9160,-10.6403,-12.7543,4.9029,-9.9590,-12.7583,4.9016,-8.6705,-12.3009,5.0445,-6.2850,-12.1901,2.7732,-5.8756,-12.7795,1.5963,-5.3444,-12.4277,-0.2556,-5.8681,-12.5863,-2.0923,-6.8699,-12.4918,-4.1501,-8.5898,-12.7385,-4.5057,-9.7913,-12.6962,-4.7033,-11.4859,-12.6971,-4.7029,-12.1093,-12.7048,-4.6697};
			return value;
		}

		/** Large attribute array: Coordinate DEF='NC' point field, scene-graph level=8, element #20, 2160 total numbers made up of 720 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getNC_8_20_point()
		{
			MFVec3f NC_8_20_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getNC_8_20_point_1()))
				.append(new MFVec3f(getNC_8_20_point_2()))
				.append(new MFVec3f(getNC_8_20_point_3()))
				.append(new MFVec3f(getNC_8_20_point_4()))
				.append(new MFVec3f(getNC_8_20_point_5()))
				.append(new MFVec3f(getNC_8_20_point_6()))
				.append(new MFVec3f(getNC_8_20_point_7()))
				.append(new MFVec3f(getNC_8_20_point_8()));
			return NC_8_20_point;
		}
		/** Large attribute array: CoordinateInterpolator DEF='CI' keyValue field, scene-graph level=3, element #26, 6480 total numbers made up of 2160 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCI_3_26_keyValue()
		{
			MFVec3f CI_3_26_keyValue = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCI_3_26_keyValue_1()))
				.append(new MFVec3f(getCI_3_26_keyValue_2()))
				.append(new MFVec3f(getCI_3_26_keyValue_3()))
				.append(new MFVec3f(getCI_3_26_keyValue_4()))
				.append(new MFVec3f(getCI_3_26_keyValue_5()))
				.append(new MFVec3f(getCI_3_26_keyValue_6()))
				.append(new MFVec3f(getCI_3_26_keyValue_7()))
				.append(new MFVec3f(getCI_3_26_keyValue_8()))
				.append(new MFVec3f(getCI_3_26_keyValue_9()))
				.append(new MFVec3f(getCI_3_26_keyValue_10()))
				.append(new MFVec3f(getCI_3_26_keyValue_11()))
				.append(new MFVec3f(getCI_3_26_keyValue_12()))
				.append(new MFVec3f(getCI_3_26_keyValue_13()))
				.append(new MFVec3f(getCI_3_26_keyValue_14()))
				.append(new MFVec3f(getCI_3_26_keyValue_15()))
				.append(new MFVec3f(getCI_3_26_keyValue_16()))
				.append(new MFVec3f(getCI_3_26_keyValue_17()))
				.append(new MFVec3f(getCI_3_26_keyValue_18()))
				.append(new MFVec3f(getCI_3_26_keyValue_19()))
				.append(new MFVec3f(getCI_3_26_keyValue_20()))
				.append(new MFVec3f(getCI_3_26_keyValue_21()))
				.append(new MFVec3f(getCI_3_26_keyValue_22()));
			return CI_3_26_keyValue;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return AnimatedNurbsPatchSurfaceHead model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new AnimatedNurbsPatchSurfaceHead().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.NURBS.AnimatedNurbsPatchSurfaceHead\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.NURBS.AnimatedNurbsPatchSurfaceHead self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // NURBS/AnimatedNurbsPatchSurfaceHead_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "NURBS/AnimatedNurbsPatchSurfaceHead_JavaExport.x3d"; 
                String filenameX3DV = "NURBS/AnimatedNurbsPatchSurfaceHead_JavaExport.x3dv"; 
                String filenameJSON = "NURBS/AnimatedNurbsPatchSurfaceHead_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
