/**
 *<p>
 *	The X3D MedicalInterchange profile is designed for Exchange of polygonal geometry, volumetric data and accompanying documentation between medical imaging systems.
 *      Potential implementation includes industry-specific applications that use X3D as an interchange format, but link to proprietary databases and hardware.
 *</p>
 *<p>
 *	These examples
 *	support the work of the
 *	<a href="https://www.web3d.org/working-groups/medical" target="_blank">Web3D Medical (MedX3D) Working Group</a>.
 *	Ongoing work is documented on the 
 *	<a href="https://www.web3d.org/wiki/index.php/X3D_Medical" target="_blank">Medical Working Group Wiki</a>.
 *</p>
 *<p>
 *	Related work appears in the
 *	<a href="../../../HumanoidAnimation/index.html">Humanoid Animation</a>
 *	examples and the
 *	<a href="https://3dprint.nih.gov" target="_blank">National Institutes of Health (NIH) 3D Print Exchange</a>.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/Medical" target="_blank">X3D Basic: Medical</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.Medical;

