####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SkeletonCompleteNormals.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    meta(content='SkeletonCompleteNormals.x3d',name='title'),
    meta(content='Human skeleton reference example providing all bones, with polygonal normals precomputed and embedded. Scaled to normal size.',name='description'),
    meta(content='TODO',name='created'),
    meta(content='18 December 2023',name='modified'),
    meta(content='Damon Hernandez, Joe D. Williams, Don Brutzman',name='creator'),
    meta(content='SkeletonCompleteNoNormals.x3d',name='reference'),
    meta(content='UltraEdit, http://www.ultraedit.com',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/SkeletonCompleteNormals.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SkeletonCompleteNormals.x3d'),
    NavigationInfo(avatarSize=[.25,1.6,.75]),
    Background(DEF='Background1',groundColor=[(0,0,0)],skyColor=[(.64314,.64314,.64314)]),
    #  rotations and scale to std hanim 0 0 0 origin, facing +z, and humanoid size 
    Transform(scale=(0.029,0.029,0.029),
      children=[
      Viewpoint(DEF='Intro',description='Intro',fieldOfView=0.785,position=(.35784,30.17213,74.93772)),
      Viewpoint(DEF='Right',description='Right',fieldOfView=0.785,orientation=(0,1,0,1.571),position=(77.90892,29.85694,-2.52271)),
      Viewpoint(DEF='Left',description='Left',fieldOfView=0.785,orientation=(-0,-1,0,1.571),position=(-75.97132,30.7287,-.47994)),
      Viewpoint(DEF='Skull',description='Skull',fieldOfView=0.785,position=(.08991,54.9537,19.04078)),
      Viewpoint(DEF='Chest',description='Chest',fieldOfView=0.785,position=(-.19509,43.5537,19.0408)),
      Viewpoint(DEF='Hips',description='Hips',fieldOfView=0.785,position=(.22486,32.4387,13.51968)),
      Viewpoint(DEF='Feet',description='Feet',fieldOfView=0.785,orientation=(-1,-0,0,.408),position=(-.28544,6.11975,11.78506)),
      Shape(DEF='atlas',
        appearance=Appearance(
          material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),shininess=0.050,specularColor=(.349,.349,.349))),
        geometry=IndexedFaceSet(DEF='atlas_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,3,7,-1,8,9,10,-1,11,12,13,-1,14,6,15,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,22,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,32,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,52,51,53,-1,48,54,55,-1,36,52,54,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,58,-1,40,39,73,-1,74,75,76,-1,77,78,79,-1,80,81,79,-1,39,82,73,-1,43,42,83,-1,84,85,77,-1,86,87,88,-1,72,89,90,-1,91,59,92,-1,11,65,93,-1,94,95,96,-1,97,98,96,-1,99,100,101,-1,102,103,100,-1,103,104,105,-1,72,71,106,-1,107,108,109,-1,30,110,111,-1,112,113,114,-1,115,116,117,-1,117,118,119,-1,120,121,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,89,135,136,-1,137,138,139,-1,140,141,142,-1,143,144,145,-1,146,147,148,-1,149,150,151,-1,152,153,154,-1,155,156,157,-1,158,159,160,-1,149,9,161,-1,162,163,164,-1,165,166,167,-1,168,169,170,-1,171,172,173,-1,174,175,176,-1,170,177,178,-1,173,168,179,-1,180,181,182,-1,172,183,184,-1,184,185,186,-1,187,188,189,-1,190,191,192,-1,193,194,156,-1,195,196,197,-1,198,181,180,-1,199,200,201,-1,202,203,204,-1,205,206,207,-1,208,200,209,-1,116,210,211,-1,212,109,213,-1,214,215,213,-1,216,217,218,-1,219,64,59,-1,220,221,222,-1,223,224,225,-1,226,224,189,-1,227,131,130,-1,228,229,230,-1,229,219,231,-1,232,233,234,-1,235,236,237,-1,238,239,240,-1,17,240,18,-1,241,242,148,-1,243,17,244,-1,245,246,27,-1,247,248,249,-1,145,250,251,-1,252,253,254,-1,255,256,257,-1,203,258,235,-1,259,21,260,-1,261,234,262,-1,263,5,262,-1,264,265,266,-1,267,268,269,-1,270,271,272,-1,273,274,252,-1,275,143,141,-1,276,246,277,-1,278,279,247,-1,280,147,146,-1,76,281,282,-1,283,284,285,-1,286,287,288,-1,289,187,290,-1,83,291,292,-1,293,294,295,-1,296,88,268,-1,297,254,132,-1,298,86,88,-1,299,300,301,-1,154,302,303,-1,128,189,224,-1,304,305,306,-1,307,164,308,-1,0,10,220,-1,309,301,310,-1,134,311,301,-1,164,166,0,-1,135,312,313,-1,314,312,106,-1,159,196,195,-1,226,225,224,-1,157,152,190,-1,179,315,171,-1,66,65,316,-1,94,317,165,-1,318,319,320,-1,321,322,323,-1,324,325,326,-1,327,328,329,-1,330,327,331,-1,332,333,334,-1,335,336,337,-1,338,331,339,-1,340,341,342,-1,343,344,345,-1,346,347,348,-1,346,349,338,-1,350,348,347,-1,351,352,353,-1,354,355,356,-1,354,357,358,-1,359,360,361,-1,362,363,364,-1,365,366,367,-1,368,369,370,-1,357,371,358,-1,359,372,373,-1,374,372,375,-1,376,374,371,-1,371,375,377,-1,378,379,380,-1,381,382,383,-1,382,384,385,-1,383,386,387,-1,388,389,364,-1,390,391,392,-1,393,394,395,-1,396,393,397,-1,398,367,366,-1,397,399,400,-1,401,402,403,-1,404,405,386,-1,406,407,408,-1,409,410,337,-1,411,412,413,-1,414,415,416,-1,417,418,419,-1,420,421,422,-1,416,415,422,-1,405,423,387,-1,424,425,108,-1,426,427,356,-1,428,429,430,-1,431,432,433,-1,434,435,436,-1,436,437,438,-1,439,440,441,-1,442,443,444,-1,445,446,447,-1,448,449,450,-1,451,452,405,-1,453,454,455,-1,456,455,457,-1,458,459,460,-1,461,462,463,-1,464,465,466,-1,467,468,469,-1,470,471,472,-1,473,474,475,-1,476,477,466,-1,478,479,480,-1,481,482,483,-1,484,485,486,-1,487,488,489,-1,490,491,492,-1,493,494,484,-1,495,493,496,-1,497,498,487,-1,499,500,485,-1,500,497,485,-1,500,498,497,-1,501,502,503,-1,504,505,506,-1,507,508,509,-1,510,505,504,-1,511,512,513,-1,495,514,510,-1,515,516,517,-1,518,519,520,-1,521,522,523,-1,524,525,520,-1,431,526,527,-1,528,425,424,-1,528,529,530,-1,531,532,533,-1,534,535,492,-1,502,536,537,-1,538,445,539,-1,359,377,375,-1,528,424,540,-1,541,349,542,-1,543,544,545,-1,546,547,548,-1,549,550,551,-1,550,461,552,-1,553,439,554,-1,555,556,557,-1,558,559,560,-1,561,562,563,-1,564,458,565,-1,546,566,567,-1,543,568,519,-1,517,345,569,-1,340,570,571,-1,329,572,340,-1,573,574,575,-1,576,577,578,-1,579,580,581,-1,582,583,584,-1,457,460,585,-1,586,558,587,-1,563,437,588,-1,463,462,589,-1,590,591,592,-1,593,594,595,-1,596,394,597,-1,598,503,599,-1,600,601,398,-1,602,603,604,-1,605,449,448,-1,606,607,608,-1,609,502,610,-1,501,611,612,-1,480,613,324,-1,608,607,614,-1,324,481,478,-1,423,452,615,-1,616,387,423,-1,513,474,477,-1,484,617,618,-1,619,469,470,-1,489,620,621,-1,622,621,620,-1,483,623,412,-1,624,625,626,-1,627,628,629,-1,627,624,628,-1,630,413,625,-1,631,632,381,-1,633,335,337,-1,469,475,506,-1,634,488,498,-1,485,484,618,-1,450,607,635,-1,636,635,615,-1,490,492,637,-1,638,639,478,-1,332,334,325,-1,637,479,640,-1,641,450,449,-1,604,449,602,-1,642,611,643,-1,609,610,644,-1,645,611,642,-1,646,448,647,-1,648,649,402,-1,603,650,651,-1,601,600,403,-1,652,403,653,-1,595,654,655,-1,656,592,391,-1,657,597,658,-1,659,395,660,-1,391,395,656,-1,388,363,591,-1,562,561,589,-1,661,662,559,-1,663,577,664,-1,665,666,343,-1,667,572,326,-1,668,329,669,-1,670,426,671,-1,672,673,674,-1,675,676,677,-1,678,651,679,-1,664,662,661,-1,460,581,680,-1,681,380,379,-1,366,365,682,-1,551,550,341,-1,550,683,341,-1,461,550,549,-1,684,463,561,-1,566,342,341,-1,685,670,518,-1,543,355,544,-1,686,343,346,-1,687,532,531,-1,540,531,529,-1,573,350,347,-1,688,689,690,-1,691,332,613,-1,536,692,617,-1,503,537,490,-1,482,330,623,-1,693,567,554,-1,690,694,695,-1,355,696,544,-1,696,530,544,-1,432,672,697,-1,698,516,699,-1,513,691,535,-1,700,701,702,-1,485,497,487,-1,703,622,704,-1,704,620,489,-1,493,484,486,-1,486,485,487,-1,705,617,484,-1,482,481,324,-1,353,526,431,-1,587,353,438,-1,559,706,560,-1,636,647,448,-1,707,445,447,-1,399,539,445,-1,503,598,611,-1,464,444,465,-1,642,589,462,-1,708,642,462,-1,709,706,454,-1,588,437,436,-1,434,677,710,-1,353,711,526,-1,712,430,713,-1,543,519,518,-1,429,427,430,-1,419,714,715,-1,716,411,417,-1,715,717,718,-1,411,719,412,-1,694,409,336,-1,615,720,721,-1,398,601,722,-1,402,723,722,-1,400,679,651,-1,539,724,538,-1,654,658,396,-1,725,364,600,-1,394,393,396,-1,726,727,728,-1,595,594,657,-1,729,590,656,-1,381,632,384,-1,730,731,732,-1,385,733,379,-1,734,681,735,-1,362,725,366,-1,736,370,357,-1,555,362,682,-1,354,737,696,-1,427,736,356,-1,711,353,352,-1,362,555,557,-1,738,739,350,-1,338,349,541,-1,350,568,545,-1,338,541,740,-1,738,741,739,-1,336,741,695,-1,629,742,335,-1,623,330,331,-1,482,743,328,-1,743,326,572,-1,321,744,322,-1,318,317,319,-1,70,66,745,-1,746,747,748,-1,158,153,152,-1,311,134,133,-1,749,133,313,-1,222,221,176,-1,164,750,167,-1,751,8,10,-1,752,134,309,-1,753,297,752,-1,754,74,755,-1,756,305,757,-1,758,759,223,-1,132,254,253,-1,760,87,761,-1,296,267,295,-1,762,253,763,-1,764,298,765,-1,764,766,298,-1,283,764,767,-1,768,287,286,-1,769,81,80,-1,767,768,770,-1,284,771,285,-1,76,282,772,-1,275,280,248,-1,247,773,278,-1,142,774,251,-1,775,776,777,-1,250,145,778,-1,30,779,31,-1,2,780,263,-1,780,781,5,-1,259,262,5,-1,779,111,204,-1,782,783,784,-1,785,786,777,-1,787,144,143,-1,788,41,43,-1,238,241,148,-1,249,146,773,-1,17,256,244,-1,202,204,789,-1,790,31,235,-1,22,19,25,-1,791,792,218,-1,215,792,791,-1,793,794,795,-1,266,796,24,-1,220,797,221,-1,220,10,797,-1,798,225,226,-1,176,188,187,-1,317,7,799,-1,800,255,801,-1,64,802,62,-1,228,803,219,-1,804,805,806,-1,790,214,31,-1,807,210,116,-1,205,808,206,-1,809,221,797,-1,158,810,159,-1,702,701,811,-1,811,812,702,-1,172,813,169,-1,704,315,703,-1,704,814,171,-1,182,168,170,-1,173,172,169,-1,170,798,177,-1,799,1,0,-1,120,211,28,-1,121,28,276,-1,140,280,275,-1,245,815,816,-1,90,817,42,-1,132,762,313,-1,129,818,819,-1,818,131,227,-1,305,290,187,-1,150,126,151,-1,754,138,137,-1,137,816,754,-1,118,117,278,-1,783,782,115,-1,820,821,113,-1,204,235,779,-1,822,71,823,-1,824,101,100,-1,825,102,99,-1,96,826,827,-1,748,323,828,-1,95,829,826,-1,830,831,832,-1,833,93,62,-1,834,822,835,-1,834,836,312,-1,83,42,291,-1,291,761,87,-1,294,84,296,-1,837,78,227,-1,768,767,764,-1,82,285,73,-1,38,83,292,-1,768,765,79,-1,770,284,283,-1,772,282,771,-1,66,70,69,-1,93,838,839,-1,58,57,840,-1,839,51,63,-1,841,842,50,-1,843,844,46,-1,43,38,845,-1,846,47,33,-1,847,845,848,-1,849,33,32,-1,850,29,28,-1,851,848,845,-1,852,853,23,-1,852,854,237,-1,855,856,26,-1,237,266,853,-1,15,855,26,-1,13,12,854,-1,746,13,857,-1,317,318,6,-1,781,2,1,-1,781,780,2,-1,781,1,799,-1,6,7,317,-1,746,857,747,-1,854,852,13,-1,858,4,14,-1,237,236,266,-1,19,858,25,-1,237,853,852,-1,852,23,859,-1,845,40,851,-1,850,860,29,-1,32,31,849,-1,29,847,848,-1,846,861,47,-1,847,43,845,-1,841,50,35,-1,839,53,51,-1,58,840,862,-1,90,56,72,-1,93,839,62,-1,69,67,66,-1,771,288,772,-1,74,769,863,-1,79,287,768,-1,292,39,38,-1,765,768,764,-1,864,837,227,-1,294,865,84,-1,291,817,761,-1,42,817,291,-1,312,314,834,-1,833,62,802,-1,830,832,866,-1,748,828,867,-1,96,827,868,-1,825,97,102,-1,114,110,869,-1,204,203,235,-1,821,114,113,-1,211,850,28,-1,783,115,119,-1,117,122,278,-1,816,815,754,-1,757,304,870,-1,871,872,870,-1,302,151,758,-1,187,306,305,-1,818,227,85,-1,873,129,819,-1,129,131,818,-1,313,133,132,-1,90,136,817,-1,245,816,775,-1,141,140,275,-1,140,757,280,-1,121,120,28,-1,125,124,874,-1,799,0,166,-1,875,876,877,-1,173,169,168,-1,182,170,178,-1,704,171,315,-1,315,878,703,-1,186,185,192,-1,809,797,195,-1,807,879,210,-1,214,849,31,-1,804,806,230,-1,228,219,229,-1,803,802,219,-1,64,219,802,-1,165,317,799,-1,876,875,176,-1,187,876,176,-1,219,880,231,-1,24,853,266,-1,793,881,794,-1,880,91,882,-1,883,791,218,-1,215,791,213,-1,22,884,19,-1,202,789,885,-1,17,16,256,-1,148,872,238,-1,43,847,788,-1,886,787,143,-1,777,776,785,-1,760,887,268,-1,783,888,784,-1,111,789,204,-1,5,4,259,-1,2,263,18,-1,19,884,20,-1,785,269,889,-1,778,890,250,-1,137,251,816,-1,246,775,777,-1,137,142,251,-1,280,249,248,-1,281,40,891,-1,772,81,769,-1,863,769,80,-1,768,286,770,-1,769,76,772,-1,283,766,764,-1,766,86,298,-1,86,292,291,-1,294,296,295,-1,761,892,760,-1,762,132,253,-1,757,305,304,-1,759,224,223,-1,756,757,140,-1,753,752,293,-1,752,309,893,-1,875,163,222,-1,10,0,751,-1,164,167,166,-1,222,176,875,-1,312,749,313,-1,749,311,133,-1,894,170,169,-1,184,183,895,-1,896,158,152,-1,11,746,748,-1,747,323,748,-1,66,316,745,-1,317,94,319,-1,744,320,322,-1,743,572,328,-1,331,625,623,-1,629,542,742,-1,695,694,336,-1,741,742,739,-1,339,668,344,-1,350,573,568,-1,686,344,343,-1,350,545,738,-1,362,557,363,-1,352,897,711,-1,427,898,736,-1,696,355,354,-1,555,682,352,-1,736,357,354,-1,362,366,682,-1,385,379,378,-1,386,380,404,-1,730,732,409,-1,384,382,381,-1,656,596,729,-1,660,391,390,-1,728,899,726,-1,394,396,658,-1,600,398,725,-1,389,593,900,-1,396,655,654,-1,539,901,724,-1,902,400,651,-1,402,722,601,-1,722,367,398,-1,615,721,616,-1,903,904,721,-1,694,730,409,-1,715,718,633,-1,905,716,417,-1,714,717,715,-1,383,387,904,-1,671,543,518,-1,712,713,906,-1,434,433,677,-1,588,436,435,-1,709,454,453,-1,709,907,706,-1,708,645,642,-1,708,908,612,-1,644,464,909,-1,611,501,503,-1,399,445,707,-1,707,447,910,-1,910,911,707,-1,448,912,636,-1,706,907,560,-1,589,642,913,-1,353,431,438,-1,553,440,439,-1,324,743,482,-1,914,915,640,-1,486,487,916,-1,493,486,496,-1,489,814,704,-1,622,620,704,-1,917,918,500,-1,702,919,700,-1,474,504,475,-1,691,492,535,-1,522,548,523,-1,516,515,699,-1,432,527,672,-1,482,623,483,-1,490,640,915,-1,490,915,503,-1,613,492,691,-1,347,574,573,-1,920,408,689,-1,531,540,687,-1,528,540,529,-1,343,666,346,-1,685,518,520,-1,341,921,566,-1,549,908,461,-1,365,922,682,-1,681,923,380,-1,460,459,581,-1,661,924,664,-1,678,604,651,-1,578,925,648,-1,676,710,677,-1,674,697,672,-1,518,670,671,-1,669,569,668,-1,329,328,572,-1,667,340,572,-1,355,671,356,-1,706,564,454,-1,661,559,558,-1,588,684,563,-1,562,589,585,-1,656,590,592,-1,593,729,594,-1,657,658,654,-1,395,391,660,-1,597,394,658,-1,655,653,595,-1,652,653,655,-1,396,652,655,-1,926,646,647,-1,650,902,651,-1,649,723,402,-1,646,927,448,-1,928,609,644,-1,643,913,642,-1,899,390,709,-1,449,605,602,-1,641,614,450,-1,332,325,324,-1,478,481,638,-1,637,640,490,-1,636,912,635,-1,635,912,450,-1,469,468,475,-1,631,929,632,-1,413,623,625,-1,624,626,628,-1,629,718,627,-1,624,630,625,-1,623,413,412,-1,929,410,632,-1,489,621,916,-1,930,619,470,-1,609,692,536,-1,513,512,474,-1,423,615,616,-1,636,615,452,-1,324,478,480,-1,607,450,614,-1,931,608,614,-1,613,332,324,-1,932,478,933,-1,611,645,612,-1,502,442,610,-1,934,909,467,-1,608,935,606,-1,401,403,652,-1,448,927,605,-1,603,651,604,-1,403,600,653,-1,654,595,657,-1,936,910,447,-1,595,900,593,-1,937,503,915,-1,561,463,589,-1,680,938,562,-1,563,939,437,-1,586,661,558,-1,438,586,587,-1,582,940,583,-1,581,941,579,-1,576,578,650,-1,671,355,543,-1,574,942,575,-1,943,542,349,-1,340,669,329,-1,571,669,340,-1,569,944,517,-1,568,945,519,-1,564,946,458,-1,561,563,684,-1,351,558,560,-1,921,341,683,-1,552,683,550,-1,667,551,341,-1,551,947,549,-1,545,568,543,-1,570,948,949,-1,688,690,950,-1,951,950,952,-1,538,446,445,-1,502,609,536,-1,692,609,928,-1,637,492,613,-1,531,533,953,-1,540,424,687,-1,530,696,528,-1,431,527,432,-1,524,520,954,-1,515,517,944,-1,510,955,495,-1,513,535,511,-1,955,510,504,-1,956,507,509,-1,504,506,475,-1,471,509,957,-1,917,619,930,-1,502,537,503,-1,500,918,498,-1,498,488,487,-1,496,514,495,-1,494,705,484,-1,491,534,492,-1,489,916,487,-1,503,937,599,-1,483,638,481,-1,478,932,479,-1,476,333,477,-1,475,468,473,-1,471,957,472,-1,464,466,473,-1,463,552,461,-1,460,565,458,-1,456,457,913,-1,453,455,456,-1,404,451,405,-1,452,423,405,-1,450,912,448,-1,612,645,708,-1,610,442,444,-1,438,431,436,-1,436,433,434,-1,433,436,431,-1,428,430,712,-1,356,671,426,-1,424,108,107,-1,405,387,386,-1,422,958,416,-1,420,422,959,-1,421,420,715,-1,413,417,411,-1,960,961,962,-1,337,336,409,-1,406,92,407,-1,641,678,963,-1,402,601,403,-1,399,679,400,-1,594,597,657,-1,366,725,398,-1,393,395,659,-1,393,901,397,-1,391,592,392,-1,364,363,388,-1,383,378,386,-1,381,383,964,-1,384,632,410,-1,378,380,386,-1,371,374,375,-1,371,965,376,-1,374,966,372,-1,359,375,372,-1,357,965,371,-1,368,734,369,-1,367,404,365,-1,364,725,362,-1,361,377,359,-1,354,358,737,-1,356,736,354,-1,351,555,352,-1,338,686,346,-1,346,666,347,-1,345,665,343,-1,340,667,341,-1,338,740,331,-1,332,691,333,-1,329,668,327,-1,324,326,743,-1,747,321,323,-1,744,318,320,-1,95,94,165,-1,315,179,878,-1,171,173,179,-1,152,191,190,-1,894,798,170,-1,967,159,195,-1,106,71,314,-1,312,135,106,-1,0,162,164,-1,309,134,301,-1,0,220,162,-1,871,304,306,-1,759,128,224,-1,301,311,299,-1,132,752,297,-1,268,267,296,-1,295,753,293,-1,766,292,86,-1,770,283,767,-1,129,873,968,-1,285,82,283,-1,876,187,969,-1,280,146,249,-1,248,970,886,-1,278,122,279,-1,246,777,277,-1,276,277,121,-1,273,971,274,-1,272,787,270,-1,267,269,890,-1,235,31,779,-1,265,796,266,-1,856,857,859,-1,263,780,5,-1,234,263,262,-1,21,199,260,-1,258,236,235,-1,254,271,252,-1,774,145,251,-1,249,773,247,-1,245,775,246,-1,851,972,848,-1,800,125,874,-1,241,243,242,-1,240,241,238,-1,808,973,257,-1,237,790,235,-1,857,856,855,-1,791,212,213,-1,52,36,35,-1,227,130,864,-1,188,226,189,-1,221,809,174,-1,216,218,792,-1,883,212,791,-1,213,849,214,-1,116,211,120,-1,200,974,209,-1,260,199,201,-1,180,975,198,-1,197,809,195,-1,187,189,306,-1,813,184,186,-1,172,184,813,-1,182,178,180,-1,168,182,179,-1,177,976,178,-1,176,221,174,-1,171,183,172,-1,289,969,187,-1,165,799,166,-1,163,308,164,-1,149,967,9,-1,160,153,158,-1,155,193,156,-1,160,149,151,-1,148,242,146,-1,145,774,143,-1,140,142,139,-1,139,142,137,-1,89,136,90,-1,89,106,135,-1,132,134,752,-1,870,304,871,-1,126,128,759,-1,117,120,122,-1,119,115,117,-1,116,120,117,-1,114,869,112,-1,111,779,30,-1,107,109,212,-1,72,106,89,-1,105,977,103,-1,102,100,99,-1,105,104,978,-1,95,826,96,-1,979,980,981,-1,93,833,11,-1,92,406,91,-1,982,983,893,-1,86,291,87,-1,84,865,85,-1,770,286,284,-1,83,38,43,-1,39,292,82,-1,77,79,765,-1,81,287,79,-1,76,769,74,-1,40,73,891,-1,71,58,823,-1,862,67,69,-1,68,823,69,-1,62,839,63,-1,61,92,59,-1,58,72,56,-1,36,54,48,-1,48,55,49,-1,52,53,54,-1,50,52,35,-1,47,49,34,-1,44,46,984,-1,41,90,42,-1,40,845,38,-1,36,861,37,-1,33,47,34,-1,30,32,985,-1,29,848,27,-1,24,23,853,-1,26,856,22,-1,24,884,22,-1,21,858,19,-1,16,18,263,-1,14,15,26,-1,11,13,746,-1,11,833,12,-1,9,797,10,-1,3,5,781,-1,2,751,0,-1,855,747,857,-1,747,855,321,-1,854,803,986,-1,854,12,803,-1,858,259,4,-1,21,259,858,-1,859,22,856,-1,859,23,22,-1,972,815,245,-1,972,75,815,-1,987,850,112,-1,987,860,850,-1,849,846,33,-1,213,846,849,-1,788,29,860,-1,788,847,29,-1,44,988,985,-1,44,984,988,-1,843,57,844,-1,843,840,57,-1,60,51,50,-1,63,51,60,-1,840,67,862,-1,840,989,67,-1,771,73,285,-1,73,771,891,-1,74,990,755,-1,990,74,863,-1,77,227,78,-1,227,77,85,-1,314,822,834,-1,71,822,314,-1,991,992,993,-1,991,994,992,-1,311,995,299,-1,311,749,995,-1,996,997,998,-1,997,996,999,-1,978,1000,1001,-1,1000,978,827,-1,825,323,322,-1,323,825,828,-1,1002,1003,1004,-1,1002,1005,1003,-1,105,981,866,-1,105,978,981,-1,821,110,114,-1,821,111,110,-1,210,850,211,-1,210,1006,850,-1,247,970,248,-1,247,279,970,-1,758,126,759,-1,758,151,126,-1,968,1007,1008,-1,968,756,1007,-1,136,762,763,-1,136,313,762,-1,135,313,136,-1,1009,279,277,-1,970,279,1009,-1,1010,301,300,-1,1010,1011,301,-1,1012,894,169,-1,894,1012,1013,-1,190,812,811,-1,192,812,190,-1,508,1014,194,-1,508,507,1014,-1,507,878,1014,-1,507,703,878,-1,1015,1016,1017,-1,1015,1018,1016,-1,1016,794,1019,-1,209,794,1016,-1,1020,790,237,-1,1020,214,790,-1,805,216,806,-1,805,217,216,-1,1021,803,228,-1,986,803,1021,-1,782,116,115,-1,782,807,116,-1,201,206,1022,-1,206,201,1023,-1,793,265,264,-1,793,795,265,-1,861,1024,37,-1,846,1024,861,-1,228,806,1021,-1,230,806,228,-1,1025,883,218,-1,1026,883,1025,-1,1027,200,199,-1,1027,974,200,-1,773,874,124,-1,874,773,146,-1,41,56,90,-1,56,41,1028,-1,890,295,267,-1,890,778,295,-1,784,807,782,-1,784,1029,807,-1,1030,821,820,-1,821,1030,1031,-1,1031,111,821,-1,111,1031,789,-1,1027,796,265,-1,1027,20,796,-1,273,970,1009,-1,970,273,270,-1,785,971,786,-1,785,889,971,-1,145,1032,778,-1,145,144,1032,-1,141,774,142,-1,141,143,774,-1,983,819,818,-1,983,982,819,-1,864,1008,1033,-1,1008,864,130,-1,81,288,287,-1,772,288,81,-1,87,268,88,-1,87,760,268,-1,139,756,140,-1,1007,756,139,-1,1034,239,238,-1,1034,161,239,-1,184,1035,185,-1,184,895,1035,-1,191,154,303,-1,191,152,154,-1,70,1036,68,-1,70,745,1036,-1,1037,1005,1002,-1,1037,831,1005,-1,979,1038,991,-1,979,1001,1038,-1,629,541,542,-1,628,541,629,-1,542,739,742,-1,739,542,943,-1,519,954,520,-1,519,945,954,-1,592,363,557,-1,363,592,591,-1,898,429,1039,-1,429,898,427,-1,1040,425,1041,-1,425,1040,108,-1,1042,1043,1044,-1,1043,1042,1039,-1,1044,681,1042,-1,1044,923,681,-1,1045,1046,376,-1,1045,1047,1046,-1,1046,731,966,-1,731,1046,732,-1,92,1048,407,-1,92,61,1048,-1,410,732,384,-1,410,409,732,-1,596,594,729,-1,594,596,597,-1,364,900,600,-1,389,900,364,-1,539,397,901,-1,399,397,539,-1,904,616,721,-1,616,904,387,-1,1049,1050,1051,-1,1049,1052,1050,-1,1053,607,606,-1,1053,635,607,-1,1054,1055,1056,-1,1057,1055,1054,-1,1058,414,1059,-1,716,414,1058,-1,718,714,627,-1,717,714,718,-1,1060,1061,1062,-1,1060,1063,1061,-1,1064,421,715,-1,1064,1065,421,-1,427,713,430,-1,427,426,713,-1,711,527,526,-1,711,1066,527,-1,938,563,562,-1,938,939,563,-1,444,644,610,-1,444,464,644,-1,1067,936,1068,-1,1067,643,936,-1,647,451,926,-1,636,451,647,-1,451,636,452,-1,939,1069,586,-1,1069,939,938,-1,608,1070,935,-1,608,1071,1070,-1,494,535,534,-1,535,494,511,-1,1072,702,1073,-1,702,1072,919,-1,1074,444,443,-1,1074,465,444,-1,622,507,956,-1,622,703,507,-1,1075,673,1076,-1,1075,1077,673,-1,1078,1075,1079,-1,1075,1078,1080,-1,544,1081,545,-1,544,530,1081,-1,953,1082,1083,-1,953,533,1082,-1,690,407,1084,-1,689,407,690,-1,689,408,407,-1,1085,545,1081,-1,1085,738,545,-1,326,551,667,-1,326,325,551,-1,684,435,440,-1,588,435,684,-1,567,921,554,-1,921,567,566,-1,574,666,665,-1,666,574,347,-1,920,406,408,-1,920,1086,406,-1,531,1087,529,-1,1087,531,953,-1,1088,1089,942,-1,1089,1088,1090,-1,552,553,554,-1,552,463,553,-1,927,941,605,-1,579,941,927,-1,603,576,650,-1,603,1091,576,-1,697,675,677,-1,697,674,675,-1,713,1092,906,-1,1093,1092,713,-1,426,1093,713,-1,670,1093,426,-1,574,1088,942,-1,574,665,1088,-1,938,584,1069,-1,580,584,938,-1,583,664,924,-1,583,663,664,-1,1094,458,1091,-1,1094,459,458,-1,565,457,455,-1,565,460,457,-1,911,678,707,-1,911,963,678,-1,1068,538,727,-1,446,538,1068,-1,596,395,394,-1,395,596,656,-1,578,402,401,-1,578,648,402,-1,649,926,723,-1,649,646,926,-1,1095,1051,1096,-1,1049,1051,1095,-1,644,934,928,-1,934,644,909,-1,709,726,899,-1,709,453,726,-1,641,604,678,-1,641,449,604,-1,1071,640,479,-1,1071,914,640,-1,411,1058,719,-1,411,716,1058,-1,700,1097,701,-1,700,472,1097,-1,410,633,337,-1,929,633,410,-1,1056,1098,1099,-1,1056,1055,1098,-1,1051,1100,1096,-1,961,1100,1051,-1,719,639,638,-1,719,1058,639,-1,639,1059,1101,-1,639,1058,1059,-1,1102,1096,1100,-1,1102,1063,1096,-1,1055,964,1098,-1,1055,1103,964,-1,500,619,917,-1,619,500,499,-1,691,477,333,-1,691,513,477,-1,608,914,1071,-1,608,931,914,-1,453,1067,726,-1,453,456,1067,-1,606,1049,1095,-1,935,1049,606,-1,577,925,578,-1,925,577,663,-1,447,1068,936,-1,447,446,1068,-1,963,937,915,-1,911,937,963,-1,680,585,460,-1,680,562,585,-1,586,437,939,-1,586,438,437,-1,663,940,925,-1,940,663,583,-1,941,459,1094,-1,941,581,459,-1,646,940,582,-1,646,649,940,-1,602,1091,603,-1,1094,1091,602,-1,1104,693,1105,-1,1104,547,693,-1,665,517,1088,-1,517,665,345,-1,906,1076,1106,-1,1092,1076,906,-1,342,570,340,-1,570,342,948,-1,605,1094,602,-1,605,941,1094,-1,555,560,556,-1,555,351,560,-1,1090,1078,1089,-1,1078,1090,1080,-1,1107,950,951,-1,1107,688,950,-1,1108,953,1083,-1,1108,1087,953,-1,360,1040,1041,-1,360,1109,1040,-1,617,491,536,-1,617,705,491,-1,1087,1085,1081,-1,1087,1108,1085,-1,1082,951,1083,-1,951,1082,1110,-1,1082,1111,1112,-1,1082,533,1111,-1,533,1025,1111,-1,532,1025,533,-1,525,685,520,-1,1113,685,525,-1,521,699,522,-1,521,1114,699,-1,674,1077,1115,-1,674,673,1077,-1,670,1113,1093,-1,670,685,1113,-1,547,523,548,-1,1104,523,547,-1,622,510,514,-1,622,956,510,-1,510,509,505,-1,510,956,509,-1,471,505,509,-1,505,471,506,-1,928,1116,692,-1,928,934,1116,-1,499,934,619,-1,499,1116,934,-1,1073,634,1072,-1,1073,1117,634,-1,705,534,491,-1,534,705,494,-1,935,1052,1049,-1,935,1070,1052,-1,639,933,478,-1,1101,933,639,-1,957,1097,472,-1,957,1118,1097,-1,467,473,468,-1,473,909,464,-1,473,467,909,-1,439,693,554,-1,439,1105,693,-1,913,585,589,-1,585,913,457,-1,404,722,451,-1,367,722,404,-1,614,963,931,-1,614,641,963,-1,1068,726,1067,-1,727,726,1068,-1,708,461,908,-1,708,462,461,-1,440,434,441,-1,435,434,440,-1,929,715,633,-1,1064,715,929,-1,422,1119,958,-1,422,421,1119,-1,715,959,419,-1,715,420,959,-1,958,1120,416,-1,1121,1120,958,-1,1122,1120,1121,-1,714,624,627,-1,714,419,624,-1,1122,1100,1120,-1,1122,1102,1100,-1,631,1064,929,-1,1065,1064,631,-1,1053,615,635,-1,1053,720,615,-1,606,1060,1053,-1,1095,1060,606,-1,400,401,652,-1,400,902,401,-1,900,653,600,-1,900,595,653,-1,392,709,390,-1,392,907,709,-1,382,378,383,-1,382,385,378,-1,1123,407,1048,-1,407,1123,1084,-1,732,1047,384,-1,1047,732,1046,-1,61,373,1048,-1,842,373,61,-1,734,1045,369,-1,734,735,1045,-1,1047,735,733,-1,735,1047,1045,-1,358,377,361,-1,358,371,377,-1,359,1109,360,-1,1109,359,841,-1,368,1039,1042,-1,1039,368,898,-1,1041,528,1124,-1,528,1041,425,-1,557,392,592,-1,556,392,557,-1,339,686,338,-1,339,344,686,-1,571,949,1125,-1,571,570,949,-1,353,558,351,-1,587,558,353,-1,1001,750,1038,-1,1001,1000,750,-1,1126,831,830,-1,1126,1005,831,-1,68,996,1127,-1,68,1036,996,-1,181,179,182,-1,181,878,179,-1,157,811,155,-1,157,190,811,-1,812,185,1035,-1,192,185,812,-1,128,872,871,-1,128,127,872,-1,161,8,239,-1,161,9,8,-1,162,222,163,-1,220,222,162,-1,128,306,189,-1,128,871,306,-1,980,866,981,-1,830,866,980,-1,308,1011,1010,-1,163,1011,308,-1,990,864,1033,-1,990,837,864,-1,122,277,279,-1,122,121,277,-1,274,889,887,-1,971,889,274,-1,144,272,1032,-1,144,787,272,-1,786,273,1009,-1,786,971,273,-1,270,886,970,-1,886,270,787,-1,233,256,16,-1,233,257,256,-1,264,236,258,-1,266,236,264,-1,1029,879,807,-1,1029,1015,879,-1,234,16,263,-1,233,16,234,-1,1032,297,753,-1,1032,272,297,-1,777,1009,277,-1,777,786,1009,-1,57,1028,844,-1,57,56,1028,-1,17,241,240,-1,17,243,241,-1,794,974,795,-1,209,974,794,-1,229,1128,230,-1,229,231,1128,-1,216,1021,806,-1,216,1129,1021,-1,1040,37,1024,-1,1040,1109,37,-1,175,798,226,-1,175,177,798,-1,986,1129,1020,-1,986,1021,1129,-1,1086,804,882,-1,1086,1130,804,-1,214,1129,215,-1,1020,1129,214,-1,1026,212,883,-1,1026,107,212,-1,885,881,202,-1,881,885,1131,-1,1023,207,206,-1,1023,1132,207,-1,1019,1017,1016,-1,1017,1019,1030,-1,264,1133,793,-1,258,1133,264,-1,197,975,180,-1,196,975,197,-1,810,196,159,-1,810,975,196,-1,193,508,194,-1,193,1118,508,-1,303,1012,191,-1,303,1013,1012,-1,895,1073,1035,-1,895,1117,1073,-1,174,177,175,-1,976,177,174,-1,994,300,992,-1,994,1010,300,-1,307,750,164,-1,750,307,1038,-1,1097,193,155,-1,1097,1118,193,-1,160,154,153,-1,302,160,151,-1,302,154,160,-1,801,125,800,-1,801,1134,125,-1,785,251,250,-1,785,776,251,-1,982,309,310,-1,982,893,309,-1,1135,1008,1007,-1,1008,1135,1033,-1,148,870,872,-1,148,147,870,-1,870,280,757,-1,870,147,280,-1,879,1006,210,-1,879,1136,1006,-1,113,1136,820,-1,113,1006,1136,-1,868,103,102,-1,868,104,103,-1,867,825,99,-1,867,828,825,-1,866,977,105,-1,866,1137,977,-1,1137,866,832,-1,320,825,322,-1,320,97,825,-1,1036,999,996,-1,999,1036,824,-1,1127,835,822,-1,1127,1138,835,-1,1139,1005,1126,-1,1005,1139,1003,-1,837,79,78,-1,837,80,79,-1,754,75,74,-1,754,815,75,-1,58,69,823,-1,58,862,69,-1,59,63,60,-1,64,63,59,-1,989,838,67,-1,1140,838,989,-1,45,55,1141,-1,49,55,45,-1,55,53,1140,-1,54,53,55,-1,36,47,861,-1,36,48,47,-1,1109,35,37,-1,841,35,1109,-1,1142,984,1143,-1,988,984,1142,-1,213,1024,846,-1,109,1024,213,-1,112,1142,987,-1,869,1142,112,-1,25,14,26,-1,25,858,14,-1,232,261,1022,-1,232,234,261,-1,321,15,744,-1,321,855,15,-1,7,781,799,-1,7,3,781,-1,246,28,27,-1,28,246,276,-1,12,802,803,-1,802,12,833,-1,3,14,4,-1,3,6,14,-1,75,851,76,-1,851,75,972,-1,985,110,30,-1,985,988,110,-1,1144,860,987,-1,1144,788,860,-1,985,34,44,-1,32,34,985,-1,788,1028,41,-1,788,1144,1028,-1,44,49,45,-1,34,49,44,-1,843,989,840,-1,1141,989,843,-1,1141,46,45,-1,1141,843,46,-1,50,61,60,-1,61,50,842,-1,822,68,1127,-1,822,823,68,-1,282,891,771,-1,282,281,891,-1,755,1033,1135,-1,755,990,1033,-1,766,82,292,-1,766,283,82,-1,88,84,298,-1,88,296,84,-1,1003,299,995,-1,299,1003,1139,-1,312,995,749,-1,312,836,995,-1,1145,745,316,-1,745,1145,101,-1,981,1001,979,-1,1001,981,978,-1,94,98,319,-1,94,96,98,-1,832,1037,1137,-1,1037,832,831,-1,104,827,978,-1,827,104,868,-1,824,1146,999,-1,100,1146,824,-1,1146,103,977,-1,1146,100,103,-1,867,316,748,-1,316,867,1145,-1,119,124,123,-1,124,119,118,-1,310,876,982,-1,877,876,310,-1,136,761,817,-1,136,763,761,-1,150,161,1034,-1,150,149,161,-1,896,157,156,-1,157,896,152,-1,967,160,159,-1,160,967,149,-1,994,1038,307,-1,1038,994,991,-1,171,1147,183,-1,814,1147,171,-1,197,178,976,-1,180,178,197,-1,1013,798,894,-1,798,1013,225,-1,1147,895,183,-1,1147,1117,895,-1,1013,223,225,-1,1013,303,223,-1,1148,156,194,-1,896,156,1148,-1,194,198,1148,-1,194,1014,198,-1,198,878,181,-1,198,1014,878,-1,205,973,808,-1,973,205,1149,-1,1131,789,1031,-1,1131,885,789,-1,1018,1029,1150,-1,1018,1015,1029,-1,1023,200,208,-1,1023,201,200,-1,1018,209,1016,-1,1150,209,1018,-1,1150,208,209,-1,794,1131,1019,-1,794,881,1131,-1,1025,217,1111,-1,217,1025,218,-1,1111,805,1112,-1,1111,217,805,-1,1029,1132,1150,-1,1132,1029,784,-1,1022,260,201,-1,1022,261,260,-1,226,176,175,-1,176,226,188,-1,1128,880,882,-1,1128,231,880,-1,1143,46,844,-1,1143,984,46,-1,808,1022,206,-1,808,232,1022,-1,257,232,808,-1,257,233,232,-1,239,751,240,-1,239,8,751,-1,242,244,800,-1,242,243,244,-1,245,848,972,-1,245,27,848,-1,294,983,865,-1,294,293,983,-1,1134,1151,1152,-1,1134,1149,1151,-1,1017,820,1136,-1,820,1017,1030,-1,199,20,1027,-1,21,20,199,-1,801,1149,1134,-1,801,973,1149,-1,778,753,295,-1,753,778,1032,-1,274,253,252,-1,274,892,253,-1,273,271,270,-1,273,252,271,-1,275,886,143,-1,275,248,886,-1,969,982,876,-1,982,969,819,-1,1008,129,968,-1,1008,130,129,-1,887,269,268,-1,889,269,887,-1,992,299,1139,-1,299,992,300,-1,1007,138,1135,-1,1007,139,138,-1,877,301,1011,-1,877,310,301,-1,967,797,9,-1,967,195,797,-1,191,186,192,-1,1012,186,191,-1,1138,1037,1002,-1,1138,998,1037,-1,980,991,993,-1,991,980,979,-1,167,95,165,-1,829,95,167,-1,328,330,482,-1,328,327,330,-1,740,628,626,-1,740,541,628,-1,339,327,668,-1,339,331,327,-1,348,739,943,-1,348,350,739,-1,1039,428,1043,-1,428,1039,429,-1,897,1044,1043,-1,897,922,1044,-1,358,1124,737,-1,358,361,1124,-1,923,922,365,-1,923,1044,922,-1,965,370,369,-1,370,965,357,-1,841,373,842,-1,359,373,841,-1,966,376,1046,-1,376,966,374,-1,376,369,1045,-1,369,376,965,-1,1123,966,731,-1,1123,372,966,-1,964,904,1098,-1,964,383,904,-1,388,590,729,-1,388,591,590,-1,393,724,901,-1,393,659,724,-1,1063,1095,1096,-1,1060,1095,1063,-1,903,1098,904,-1,903,1099,1098,-1,1057,1103,1055,-1,1153,1103,1057,-1,1059,960,962,-1,414,960,1059,-1,418,413,630,-1,418,417,413,-1,1154,1122,1121,-1,1102,1122,1154,-1,716,415,414,-1,905,415,716,-1,1119,1153,1057,-1,1153,421,1065,-1,1153,1119,421,-1,422,905,959,-1,422,415,905,-1,1106,712,906,-1,1106,1066,712,-1,1066,672,527,-1,1066,1106,672,-1,915,931,963,-1,931,915,914,-1,723,451,722,-1,723,926,451,-1,564,664,946,-1,564,662,664,-1,476,465,1074,-1,476,466,465,-1,470,506,471,-1,469,506,470,-1,473,477,474,-1,466,477,473,-1,1101,1052,933,-1,1050,1052,1101,-1,1147,489,488,-1,489,1147,814,-1,493,511,494,-1,511,493,495,-1,617,1116,618,-1,692,1116,617,-1,634,1147,488,-1,634,1117,1147,-1,508,957,509,-1,508,1118,957,-1,512,504,474,-1,512,955,504,-1,955,511,495,-1,511,955,512,-1,954,575,524,-1,575,954,945,-1,1076,1079,1075,-1,1092,1079,1076,-1,1080,1077,1075,-1,1080,1115,1077,-1,1080,698,1115,-1,1113,1078,1079,-1,1113,525,1078,-1,424,1026,687,-1,424,107,1026,-1,1087,530,529,-1,530,1087,1081,-1,1110,1086,920,-1,1110,1130,1086,-1,695,950,690,-1,950,695,952,-1,694,1084,730,-1,694,690,1084,-1,1114,674,1115,-1,675,674,1114,-1,944,1125,515,-1,944,571,1125,-1,490,536,491,-1,537,536,490,-1,524,1078,525,-1,1089,1078,524,-1,689,1107,920,-1,689,688,1107,-1,734,1042,681,-1,734,368,1042,-1,1125,548,522,-1,1125,949,548,-1,949,546,548,-1,949,948,546,-1,325,947,551,-1,325,334,947,-1,921,552,554,-1,921,683,552,-1,1069,661,586,-1,1069,924,661,-1,1155,1105,1156,-1,1155,1104,1105,-1,568,575,945,-1,575,568,573,-1,566,948,342,-1,566,546,948,-1,680,580,938,-1,581,580,680,-1,584,924,1069,-1,584,583,924,-1,576,458,946,-1,576,1091,458,-1,579,584,580,-1,579,582,584,-1,455,564,565,-1,564,455,454,-1,538,728,727,-1,538,724,728,-1,1071,932,1070,-1,932,1071,479,-1,1120,961,960,-1,961,1120,1100,-1,501,442,502,-1,501,612,442,-1,637,480,479,-1,480,637,613,-1,334,476,947,-1,334,333,476,-1,908,442,612,-1,908,443,442,-1,918,919,1072,-1,919,918,917,-1,700,470,472,-1,700,930,470,-1,621,514,496,-1,621,622,514,-1,335,718,629,-1,633,718,335,-1,1154,1099,1061,-1,1154,1056,1099,-1,1050,961,1051,-1,962,961,1050,-1,412,638,483,-1,638,412,719,-1,1101,962,1050,-1,1101,1059,962,-1,1063,1154,1061,-1,1063,1102,1154,-1,1103,381,964,-1,1103,631,381,-1,467,619,934,-1,467,469,619,-1,1072,498,918,-1,1072,634,498,-1,947,1074,549,-1,947,476,1074,-1,643,456,913,-1,456,643,1067,-1,902,578,401,-1,650,578,902,-1,397,652,396,-1,400,652,397,-1,728,659,660,-1,724,659,728,-1,910,598,599,-1,936,598,910,-1,706,662,564,-1,706,559,662,-1,577,946,664,-1,577,576,946,-1,649,925,940,-1,649,648,925,-1,546,693,547,-1,546,567,693,-1,1106,673,672,-1,1076,673,1106,-1,676,1156,710,-1,676,1155,1156,-1,571,569,669,-1,944,569,571,-1,927,582,579,-1,582,927,646,-1,380,365,404,-1,923,365,380,-1,553,684,440,-1,463,684,553,-1,516,1088,517,-1,516,1090,1088,-1,687,1025,532,-1,1025,687,1026,-1,1083,952,1108,-1,952,1083,951,-1,1041,361,360,-1,361,1041,1124,-1,942,524,575,-1,942,1089,524,-1,522,515,1125,-1,699,515,522,-1,432,677,433,-1,432,697,677,-1,695,1108,952,-1,1108,695,1085,-1,1107,1110,920,-1,1107,951,1110,-1,1082,1130,1110,-1,1082,1112,1130,-1,1090,698,1080,-1,1090,516,698,-1,1115,699,1114,-1,1115,698,699,-1,521,675,1114,-1,676,675,521,-1,1079,1093,1113,-1,1093,1079,1092,-1,1104,521,523,-1,521,1155,676,-1,1155,521,1104,-1,919,930,700,-1,930,919,917,-1,618,499,485,-1,1116,499,618,-1,496,916,621,-1,496,486,916,-1,1070,933,1052,-1,1070,932,933,-1,1156,439,441,-1,439,1156,1105,-1,679,707,678,-1,399,707,679,-1,611,936,643,-1,936,611,598,-1,908,1074,443,-1,908,549,1074,-1,911,599,937,-1,911,910,599,-1,710,441,434,-1,441,710,1156,-1,428,1066,711,-1,428,712,1066,-1,1057,958,1119,-1,958,1054,1121,-1,958,1057,1054,-1,959,417,419,-1,959,905,417,-1,960,416,1120,-1,416,960,414,-1,1121,1056,1154,-1,1056,1121,1054,-1,630,419,418,-1,419,630,624,-1,1153,631,1103,-1,1153,1065,631,-1,1062,1099,903,-1,1062,1061,1099,-1,1062,1053,1060,-1,1062,720,1053,-1,903,720,1062,-1,903,721,720,-1,728,390,899,-1,660,390,728,-1,389,729,593,-1,388,729,389,-1,731,1084,1123,-1,1084,731,730,-1,384,733,385,-1,384,1047,733,-1,372,1048,373,-1,1048,372,1123,-1,379,735,681,-1,379,733,735,-1,898,370,736,-1,898,368,370,-1,352,922,897,-1,352,682,922,-1,1124,696,737,-1,696,1124,528,-1,711,1043,428,-1,711,897,1043,-1,907,556,560,-1,907,392,556,-1,346,943,349,-1,346,348,943,-1,569,344,668,-1,344,569,345,-1,695,738,1085,-1,695,741,738,-1,742,336,335,-1,742,741,336,-1,331,626,625,-1,331,740,626,-1,750,829,167,-1,750,1000,829,-1,830,993,1126,-1,993,830,980,-1,1127,998,1138,-1,1127,996,998,-1,748,65,11,-1,65,748,316,-1,1097,811,701,-1,1097,155,811,-1,1000,826,829,-1,1000,827,826,-1,875,1011,163,-1,875,877,1011,-1,293,893,983,-1,293,752,893,-1,1135,754,755,-1,1135,138,754,-1,303,758,223,-1,302,758,303,-1,993,1139,1126,-1,1139,993,992,-1,763,892,761,-1,763,253,892,-1,298,77,765,-1,77,298,84,-1,80,990,863,-1,990,80,837,-1,290,873,289,-1,873,290,968,-1,776,816,251,-1,776,775,816,-1,250,269,785,-1,250,890,269,-1,887,892,274,-1,887,760,892,-1,801,257,973,-1,801,255,257,-1,1015,1136,879,-1,1136,1015,1017,-1,1152,888,783,-1,1152,1151,888,-1,259,261,262,-1,261,259,260,-1,272,254,297,-1,254,272,271,-1,874,242,800,-1,874,146,242,-1,795,1027,265,-1,974,1027,795,-1,1129,792,215,-1,216,792,1129,-1,406,882,91,-1,406,1086,882,-1,884,796,20,-1,24,796,884,-1,244,255,800,-1,256,255,244,-1,118,773,124,-1,773,118,278,-1,240,2,18,-1,240,751,2,-1,237,986,1020,-1,237,854,986,-1,59,880,219,-1,59,91,880,-1,804,1128,882,-1,804,230,1128,-1,1130,805,804,-1,1130,1112,805,-1,793,202,881,-1,1133,202,793,-1,1023,1150,1132,-1,1023,208,1150,-1,784,207,1132,-1,207,784,888,-1,1031,1019,1131,-1,1030,1019,1031,-1,207,1149,205,-1,1151,207,888,-1,1149,207,1151,-1,975,1148,198,-1,810,1148,975,-1,810,896,1148,-1,158,896,810,-1,126,1034,127,-1,126,150,1034,-1,702,1035,1073,-1,812,1035,702,-1,813,1012,169,-1,813,186,1012,-1,809,976,174,-1,197,976,809,-1,307,1010,994,-1,307,308,1010,-1,125,1152,123,-1,1134,1152,125,-1,818,865,983,-1,865,818,85,-1,968,305,756,-1,290,305,968,-1,1034,872,127,-1,1034,238,872,-1,289,819,969,-1,289,873,819,-1,123,783,119,-1,1152,783,123,-1,1006,112,850,-1,1006,113,112,-1,99,1145,867,-1,1145,99,101,-1,977,999,1146,-1,997,977,1137,-1,997,999,977,-1,96,102,97,-1,96,868,102,-1,998,1137,1037,-1,997,1137,998,-1,97,319,98,-1,320,319,97,-1,745,824,1036,-1,745,101,824,-1,1138,1004,835,-1,1138,1002,1004,-1,995,1004,1003,-1,995,836,1004,-1,836,835,1004,-1,836,834,835,-1,284,288,771,-1,286,288,284,-1,838,65,67,-1,838,93,65,-1,839,1140,53,-1,838,1140,839,-1,1140,1141,55,-1,1140,989,1141,-1,844,1144,1143,-1,844,1028,1144,-1,987,1143,1144,-1,1142,1143,987,-1,109,1040,1024,-1,108,1040,109,-1,869,988,1142,-1,110,988,869,-1,40,76,851,-1,281,76,40,-1,1133,203,202,-1,1133,258,203,-1,852,857,13,-1,859,857,852,-1,744,6,318,-1,744,15,6,-1],creaseAngle=1.571,normalIndex=[90,51,29,-1,45,114,54,-1,23,45,57,-1,43,88,188,-1,192,170,30,-1,98,23,24,-1,35,113,74,-1,124,65,72,-1,128,61,163,-1,128,139,87,-1,835,1048,1004,-1,470,171,506,-1,546,674,506,-1,746,875,686,-1,663,536,726,-1,917,732,786,-1,736,798,784,-1,724,863,756,-1,809,967,942,-1,942,967,938,-1,863,913,840,-1,875,942,913,-1,895,780,846,-1,733,826,555,-1,695,929,762,-1,383,387,720,-1,676,725,638,-1,1053,963,846,-1,726,536,787,-1,910,753,811,-1,804,887,800,-1,958,984,800,-1,536,561,787,-1,786,732,521,-1,517,906,804,-1,346,290,228,-1,963,987,918,-1,645,733,556,-1,192,383,533,-1,226,140,270,-1,310,422,270,-1,352,350,377,-1,285,326,350,-1,326,357,249,-1,963,1053,1091,-1,547,563,550,-1,470,745,544,-1,1013,954,903,-1,1099,1044,1136,-1,1136,1156,1082,-1,1026,1101,1145,-1,891,1069,597,-1,680,660,831,-1,888,901,949,-1,1135,1139,1081,-1,987,1075,896,-1,322,551,648,-1,760,673,508,-1,710,565,198,-1,747,828,601,-1,425,637,644,-1,761,640,715,-1,490,534,691,-1,525,293,480,-1,425,88,298,-1,426,612,309,-1,111,115,149,-1,595,766,730,-1,594,781,554,-1,592,793,740,-1,730,768,558,-1,554,595,454,-1,371,401,482,-1,781,716,878,-1,878,808,916,-1,1058,1010,1065,-1,707,823,749,-1,451,478,534,-1,92,153,340,-1,348,401,371,-1,66,148,160,-1,257,155,195,-1,194,230,211,-1,199,148,167,-1,1044,1017,1040,-1,629,550,486,-1,324,530,486,-1,641,499,614,-1,635,762,733,-1,432,483,523,-1,882,995,921,-1,1015,995,1065,-1,879,949,901,-1,649,682,599,-1,682,635,681,-1,138,69,70,-1,101,52,84,-1,488,291,190,-1,113,190,74,-1,374,465,601,-1,339,113,297,-1,650,670,835,-1,1154,1115,1103,-1,198,36,71,-1,924,936,1137,-1,94,83,73,-1,155,110,101,-1,109,72,122,-1,135,70,89,-1,33,54,89,-1,120,132,58,-1,59,75,31,-1,1128,1116,1043,-1,933,365,924,-1,881,710,673,-1,980,670,1014,-1,1151,1147,1154,-1,1027,828,747,-1,811,859,1042,-1,664,1076,1025,-1,1038,848,1124,-1,988,1058,951,-1,521,430,416,-1,462,261,181,-1,225,228,75,-1,1079,1137,1135,-1,466,346,228,-1,1120,977,1041,-1,715,717,836,-1,831,1065,995,-1,861,943,1049,-1,529,309,605,-1,90,188,432,-1,950,1041,847,-1,1081,1134,1041,-1,309,115,90,-1,1075,1142,1102,-1,1105,1142,1091,-1,293,153,92,-1,1015,921,995,-1,691,761,707,-1,454,467,594,-1,387,383,303,-1,226,85,111,-1,46,288,165,-1,39,205,260,-1,1066,1150,1133,-1,1110,1071,1104,-1,1098,1110,1132,-1,970,1068,1114,-1,992,772,697,-1,1070,1132,1063,-1,1126,1059,1122,-1,1034,1003,1087,-1,1030,993,1096,-1,1030,1107,1070,-1,1130,1096,993,-1,321,151,112,-1,643,975,683,-1,643,468,442,-1,409,497,433,-1,382,443,636,-1,187,393,429,-1,323,381,427,-1,468,308,442,-1,409,202,333,-1,238,202,221,-1,316,238,308,-1,308,221,258,-1,313,375,254,-1,528,392,311,-1,392,450,368,-1,311,184,91,-1,247,362,636,-1,242,95,388,-1,358,295,173,-1,438,358,354,-1,573,429,393,-1,354,253,634,-1,932,850,807,-1,241,146,184,-1,609,420,502,-1,607,773,697,-1,904,1008,941,-1,877,801,908,-1,883,734,873,-1,792,824,827,-1,908,801,827,-1,146,63,91,-1,538,631,563,-1,610,411,683,-1,143,227,255,-1,99,172,56,-1,68,0,15,-1,15,12,49,-1,569,86,268,-1,330,494,475,-1,217,299,251,-1,21,137,80,-1,264,81,146,-1,603,834,678,-1,515,678,479,-1,953,600,446,-1,562,347,410,-1,509,513,729,-1,439,512,402,-1,461,619,665,-1,675,862,626,-1,841,1060,729,-1,849,542,728,-1,1046,1054,1047,-1,434,349,540,-1,395,437,571,-1,423,366,662,-1,627,572,434,-1,788,627,667,-1,191,281,395,-1,279,229,349,-1,229,191,349,-1,229,281,191,-1,108,93,97,-1,813,743,495,-1,568,566,685,-1,791,743,813,-1,817,1001,1064,-1,788,758,791,-1,996,994,1092,-1,968,1002,905,-1,944,931,964,-1,937,1005,905,-1,99,103,175,-1,669,631,538,-1,669,622,838,-1,520,539,646,-1,549,735,662,-1,93,141,145,-1,397,217,275,-1,409,258,221,-1,669,538,500,-1,1146,1107,1155,-1,1052,978,1080,-1,1085,1029,998,-1,666,782,966,-1,782,562,689,-1,418,569,822,-1,317,369,372,-1,485,935,505,-1,50,41,2,-1,1086,953,857,-1,1085,1073,1061,-1,1052,1109,1002,-1,1092,1087,1045,-1,1126,1089,1023,-1,1104,1123,1126,-1,1084,1039,1037,-1,1112,1119,1088,-1,38,27,82,-1,246,816,237,-1,479,446,277,-1,142,485,176,-1,2,12,5,-1,410,347,126,-1,116,294,343,-1,133,79,491,-1,32,295,118,-1,206,97,166,-1,741,690,573,-1,700,981,694,-1,77,137,21,-1,37,22,121,-1,162,93,356,-1,108,207,342,-1,728,721,1066,-1,121,22,213,-1,1066,1046,849,-1,63,81,14,-1,48,91,63,-1,1064,862,1060,-1,434,244,314,-1,337,402,461,-1,571,696,692,-1,699,692,696,-1,1047,1072,1008,-1,989,1108,1141,-1,947,1118,1077,-1,947,989,1118,-1,868,941,1108,-1,709,806,528,-1,930,992,697,-1,402,626,495,-1,444,437,281,-1,349,434,314,-1,80,22,13,-1,53,13,14,-1,423,662,630,-1,1006,870,849,-1,970,1114,1150,-1,630,542,527,-1,484,80,137,-1,694,137,700,-1,266,207,305,-1,162,356,400,-1,296,207,266,-1,223,21,78,-1,983,748,850,-1,981,1095,902,-1,690,741,807,-1,687,807,751,-1,491,514,639,-1,44,343,95,-1,341,118,489,-1,204,173,123,-1,95,173,44,-1,247,443,294,-1,41,50,126,-1,701,1028,935,-1,1036,1119,1129,-1,1093,946,1034,-1,1097,1123,1133,-1,1050,1104,1062,-1,860,610,914,-1,428,825,803,-1,737,774,234,-1,504,902,553,-1,1129,1028,701,-1,446,82,55,-1,345,254,375,-1,393,187,262,-1,966,782,1059,-1,782,818,1059,-1,562,782,666,-1,76,410,50,-1,1073,1122,1059,-1,962,860,968,-1,1052,975,978,-1,1016,1034,1030,-1,493,539,520,-1,500,520,622,-1,1084,1130,993,-1,474,453,516,-1,1000,970,721,-1,141,235,244,-1,97,145,423,-1,1054,1098,1072,-1,982,1061,822,-1,516,738,770,-1,975,869,978,-1,869,838,978,-1,172,428,214,-1,961,994,945,-1,1064,1000,735,-1,621,583,585,-1,349,191,395,-1,564,699,560,-1,560,696,571,-1,627,434,540,-1,540,349,395,-1,373,244,434,-1,1054,1046,1066,-1,112,103,99,-1,176,112,49,-1,935,897,505,-1,53,78,21,-1,252,217,251,-1,253,275,217,-1,97,206,207,-1,509,475,513,-1,266,126,347,-1,435,266,347,-1,452,897,834,-1,5,12,15,-1,68,234,414,-1,112,100,103,-1,203,255,441,-1,1052,1002,968,-1,227,411,255,-1,873,1011,900,-1,889,904,883,-1,900,948,912,-1,904,973,1008,-1,738,607,772,-1,14,8,40,-1,573,690,548,-1,850,722,548,-1,634,553,902,-1,275,306,397,-1,514,489,438,-1,455,636,741,-1,295,358,438,-1,447,394,256,-1,491,79,341,-1,19,116,44,-1,528,806,450,-1,481,280,370,-1,368,399,375,-1,359,345,406,-1,382,455,393,-1,496,427,468,-1,317,382,262,-1,643,616,869,-1,411,496,683,-1,100,112,151,-1,382,317,372,-1,1106,1153,1130,-1,1070,1107,1146,-1,1130,1109,1080,-1,1070,1146,1127,-1,1106,1019,1153,-1,772,1019,770,-1,1077,1125,992,-1,1072,1098,1132,-1,1054,1113,1071,-1,1113,1133,1123,-1,39,17,205,-1,46,85,288,-1,638,387,448,-1,96,67,240,-1,525,640,761,-1,1134,1081,1139,-1,1143,1139,1102,-1,523,483,740,-1,309,289,149,-1,6,43,188,-1,1009,1081,950,-1,459,1079,1009,-1,705,910,837,-1,853,943,876,-1,757,799,882,-1,1135,1137,936,-1,177,290,460,-1,225,59,181,-1,1078,936,874,-1,511,466,731,-1,511,407,466,-1,664,511,652,-1,688,848,1038,-1,1067,984,958,-1,652,688,814,-1,1076,1138,1025,-1,811,1042,1111,-1,881,1027,1115,-1,1154,1083,1151,-1,508,301,71,-1,224,130,458,-1,36,198,215,-1,470,245,171,-1,29,28,33,-1,28,60,54,-1,109,89,54,-1,245,544,195,-1,956,775,419,-1,26,307,458,-1,1074,565,710,-1,1020,917,786,-1,488,374,601,-1,1103,747,1083,-1,113,83,297,-1,257,195,283,-1,168,171,101,-1,128,124,139,-1,651,658,614,-1,530,658,651,-1,222,157,180,-1,58,117,163,-1,432,156,483,-1,432,188,156,-1,915,921,1015,-1,740,1010,1058,-1,85,57,105,-1,334,94,174,-1,762,424,695,-1,649,376,635,-1,431,464,617,-1,168,324,171,-1,898,1017,1044,-1,194,158,230,-1,421,483,156,-1,525,363,293,-1,585,583,531,-1,531,632,585,-1,781,955,766,-1,560,467,564,-1,560,579,594,-1,482,595,730,-1,554,781,766,-1,730,915,768,-1,105,51,90,-1,1026,1040,1048,-1,1101,1048,980,-1,760,1027,881,-1,650,642,263,-1,918,672,732,-1,1135,1078,1102,-1,888,890,842,-1,890,949,879,-1,943,951,1058,-1,637,680,644,-1,705,551,322,-1,322,263,705,-1,1156,1136,1151,-1,775,956,1099,-1,702,713,954,-1,195,101,245,-1,986,1053,843,-1,327,377,350,-1,259,285,352,-1,270,231,271,-1,240,260,196,-1,140,183,231,-1,449,535,233,-1,403,533,695,-1,1117,986,1094,-1,1117,1148,1142,-1,521,732,430,-1,430,460,290,-1,261,517,225,-1,852,887,879,-1,688,652,511,-1,561,1025,787,-1,663,521,416,-1,688,731,800,-1,814,1076,664,-1,1111,1042,1138,-1,387,638,725,-1,533,764,867,-1,846,780,777,-1,867,967,929,-1,575,574,809,-1,752,810,784,-1,786,663,754,-1,570,724,546,-1,922,754,839,-1,300,546,506,-1,1057,1004,1048,-1,783,839,754,-1,1,34,61,-1,1,64,84,-1,10,47,87,-1,84,58,34,-1,24,10,87,-1,30,170,64,-1,96,30,3,-1,85,46,23,-1,60,29,51,-1,60,28,29,-1,60,51,105,-1,23,57,85,-1,96,3,67,-1,64,1,30,-1,152,114,98,-1,84,52,58,-1,124,152,139,-1,84,34,1,-1,1,61,7,-1,754,726,783,-1,1057,1032,1004,-1,506,171,300,-1,1004,922,839,-1,570,719,724,-1,922,786,754,-1,575,809,746,-1,867,938,967,-1,846,777,802,-1,918,895,963,-1,533,867,695,-1,725,720,387,-1,1138,1124,1111,-1,910,1067,1035,-1,800,848,688,-1,416,536,663,-1,731,688,511,-1,750,852,879,-1,261,606,517,-1,430,672,460,-1,732,672,430,-1,1142,1105,1117,-1,403,695,424,-1,449,233,201,-1,240,196,243,-1,270,271,287,-1,259,310,285,-1,903,745,934,-1,195,155,101,-1,713,903,954,-1,1040,1057,1048,-1,775,1099,1082,-1,1136,1145,1151,-1,263,642,705,-1,876,861,723,-1,815,633,723,-1,717,644,757,-1,1058,1049,943,-1,890,879,906,-1,909,888,842,-1,888,949,890,-1,1102,1139,1135,-1,918,896,672,-1,650,263,224,-1,673,760,881,-1,760,876,1027,-1,1101,1026,1048,-1,597,1069,739,-1,105,90,115,-1,625,795,679,-1,554,766,595,-1,482,730,558,-1,560,594,467,-1,467,463,564,-1,916,808,749,-1,421,156,92,-1,898,718,1017,-1,324,300,171,-1,431,617,599,-1,649,635,682,-1,376,424,635,-1,762,635,424,-1,111,85,105,-1,795,625,740,-1,1058,795,740,-1,635,704,681,-1,163,34,58,-1,222,150,157,-1,704,645,498,-1,671,651,614,-1,530,651,486,-1,128,209,124,-1,257,283,154,-1,113,35,83,-1,601,633,488,-1,786,922,1020,-1,1100,1074,710,-1,458,130,26,-1,177,134,75,-1,775,380,419,-1,544,283,195,-1,54,114,109,-1,29,33,74,-1,124,209,65,-1,26,31,119,-1,215,42,36,-1,322,71,263,-1,670,224,458,-1,322,508,71,-1,1027,1103,1115,-1,859,726,893,-1,1111,984,1067,-1,1035,1067,958,-1,688,1038,814,-1,1067,811,1111,-1,664,407,511,-1,407,346,466,-1,346,416,430,-1,261,225,181,-1,460,405,177,-1,1078,1135,936,-1,876,943,861,-1,799,995,882,-1,853,876,760,-1,459,1009,462,-1,1009,950,647,-1,625,612,523,-1,188,90,6,-1,309,149,115,-1,523,740,625,-1,1142,1143,1102,-1,1143,1134,1139,-1,845,730,766,-1,878,716,711,-1,659,525,761,-1,192,96,240,-1,67,260,240,-1,387,303,448,-1,85,226,288,-1,17,165,205,-1,1113,1123,1071,-1,1132,1108,1072,-1,1077,1155,1125,-1,770,738,772,-1,1019,1125,1153,-1,1063,1050,1003,-1,1130,1084,1109,-1,1016,1003,1034,-1,1130,1080,1106,-1,382,372,443,-1,151,125,100,-1,411,329,496,-1,869,975,643,-1,317,262,151,-1,496,468,643,-1,382,393,262,-1,368,375,313,-1,184,254,241,-1,481,370,607,-1,450,392,528,-1,44,32,19,-1,123,95,242,-1,256,319,447,-1,295,438,489,-1,741,573,455,-1,362,133,602,-1,438,639,514,-1,275,272,306,-1,925,634,902,-1,850,548,690,-1,548,429,573,-1,14,40,48,-1,62,169,40,-1,738,481,607,-1,900,912,930,-1,871,889,883,-1,1011,948,900,-1,311,91,169,-1,914,1052,968,-1,203,441,457,-1,68,56,234,-1,5,15,0,-1,452,834,603,-1,452,510,897,-1,435,296,266,-1,435,518,342,-1,400,509,436,-1,207,108,97,-1,253,217,252,-1,252,251,269,-1,269,318,252,-1,21,18,53,-1,897,510,505,-1,126,266,391,-1,112,99,49,-1,418,86,569,-1,1066,1113,1054,-1,476,364,527,-1,540,395,624,-1,627,540,667,-1,571,579,560,-1,699,696,560,-1,408,344,229,-1,585,519,621,-1,862,813,626,-1,1000,662,735,-1,931,998,964,-1,994,996,945,-1,172,175,428,-1,1054,1072,1047,-1,423,527,364,-1,423,364,97,-1,721,662,1000,-1,993,1039,1084,-1,656,502,453,-1,520,500,493,-1,669,500,622,-1,1034,946,1030,-1,962,968,905,-1,1059,858,1073,-1,666,518,562,-1,187,131,262,-1,345,219,254,-1,446,600,82,-1,701,851,1129,-1,504,694,902,-1,1088,1022,983,-1,774,414,234,-1,803,214,428,-1,968,860,914,-1,1062,1045,1050,-1,1104,1071,1123,-1,1097,1126,1123,-1,975,914,683,-1,897,1086,834,-1,701,935,485,-1,5,76,2,-1,41,126,277,-1,44,116,343,-1,133,19,79,-1,341,489,514,-1,173,95,123,-1,118,295,489,-1,639,751,491,-1,687,751,639,-1,438,687,639,-1,284,223,78,-1,1095,925,902,-1,748,722,850,-1,223,20,21,-1,276,162,400,-1,305,391,266,-1,319,242,452,-1,137,77,700,-1,484,213,80,-1,970,1150,1066,-1,849,1046,1006,-1,630,527,423,-1,53,18,13,-1,13,18,80,-1,402,512,626,-1,709,855,806,-1,941,1072,1108,-1,989,1141,1118,-1,1077,912,947,-1,989,868,1108,-1,1072,941,1008,-1,855,773,806,-1,571,692,624,-1,445,337,461,-1,162,235,141,-1,1064,1001,862,-1,63,14,48,-1,53,14,81,-1,1066,849,728,-1,22,80,213,-1,312,121,213,-1,721,970,1066,-1,557,849,623,-1,207,296,342,-1,93,330,356,-1,320,436,439,-1,121,179,37,-1,932,807,687,-1,21,20,77,-1,981,902,694,-1,807,741,751,-1,514,491,341,-1,239,269,251,-1,491,602,133,-1,197,97,364,-1,50,410,126,-1,55,11,41,-1,2,9,12,-1,142,701,485,-1,49,142,176,-1,246,776,816,-1,82,102,38,-1,1112,1088,1095,-1,914,975,1052,-1,1039,1024,1037,-1,1149,1155,1107,-1,1126,1062,1104,-1,1023,1062,1126,-1,1045,1033,1092,-1,1109,1055,1002,-1,1086,1121,953,-1,50,2,76,-1,321,485,505,-1,858,1059,818,-1,689,818,782,-1,1097,966,1059,-1,966,866,666,-1,1080,1109,1052,-1,1089,1090,1018,-1,474,516,471,-1,543,471,507,-1,397,299,217,-1,93,162,141,-1,235,162,276,-1,630,662,721,-1,520,646,522,-1,500,538,493,-1,838,869,669,-1,99,175,172,-1,937,905,844,-1,996,1092,1033,-1,791,952,788,-1,1064,735,817,-1,952,791,813,-1,693,568,685,-1,813,495,626,-1,619,685,706,-1,408,337,445,-1,93,145,97,-1,229,344,281,-1,281,437,395,-1,667,758,788,-1,572,373,434,-1,366,549,662,-1,571,624,395,-1,97,197,166,-1,1047,1006,1046,-1,849,557,542,-1,841,1068,1060,-1,626,512,675,-1,619,706,665,-1,509,729,675,-1,410,689,562,-1,446,857,953,-1,515,479,391,-1,603,678,515,-1,241,264,146,-1,81,63,146,-1,80,18,21,-1,342,296,435,-1,356,330,475,-1,49,99,15,-1,15,56,68,-1,56,15,99,-1,143,255,203,-1,683,914,610,-1,538,563,547,-1,146,91,184,-1,827,940,908,-1,792,827,864,-1,824,792,900,-1,941,883,904,-1,928,767,821,-1,697,772,607,-1,609,556,420,-1,484,504,404,-1,850,690,807,-1,253,553,634,-1,79,118,341,-1,393,455,573,-1,358,173,204,-1,358,272,354,-1,95,343,388,-1,636,443,247,-1,311,313,184,-1,528,311,473,-1,450,806,773,-1,313,254,184,-1,308,238,221,-1,308,386,316,-1,238,220,202,-1,409,221,202,-1,468,386,308,-1,323,359,381,-1,429,241,187,-1,636,455,382,-1,433,258,409,-1,643,442,616,-1,683,496,643,-1,321,317,151,-1,1070,1016,1030,-1,1030,946,993,-1,1087,1093,1034,-1,1126,1097,1059,-1,1070,1127,1132,-1,970,1000,1068,-1,1104,1050,1110,-1,1066,1133,1113,-1,67,39,260,-1,17,46,165,-1,140,226,111,-1,467,454,463,-1,594,554,454,-1,761,823,707,-1,845,915,730,-1,107,293,92,-1,1091,1053,1105,-1,1142,1075,1091,-1,90,426,309,-1,950,1081,1041,-1,90,432,426,-1,815,861,1049,-1,799,831,995,-1,1041,1134,1120,-1,1135,1009,1079,-1,75,59,225,-1,181,459,462,-1,407,416,346,-1,814,664,652,-1,888,909,919,-1,1025,561,664,-1,795,1058,960,-1,1027,747,1103,-1,1115,1144,1100,-1,1151,1145,1147,-1,670,458,1014,-1,980,1014,1101,-1,933,328,365,-1,1043,1074,1128,-1,59,31,42,-1,101,171,245,-1,132,117,58,-1,47,3,7,-1,33,28,54,-1,70,33,89,-1,72,66,122,-1,110,52,101,-1,1137,1116,924,-1,301,198,71,-1,1103,1083,1154,-1,650,224,670,-1,783,789,839,-1,334,597,739,-1,374,339,465,-1,190,374,488,-1,158,129,73,-1,84,168,101,-1,3,47,10,-1,651,629,486,-1,942,875,746,-1,879,901,750,-1,1010,1015,1065,-1,483,421,592,-1,641,614,658,-1,671,629,651,-1,486,300,324,-1,1044,1040,1026,-1,148,161,167,-1,122,66,160,-1,371,208,348,-1,340,421,92,-1,1058,1065,1049,-1,955,878,916,-1,781,878,955,-1,482,558,371,-1,595,482,454,-1,768,593,558,-1,740,483,592,-1,594,716,781,-1,988,960,1058,-1,111,105,115,-1,612,605,309,-1,425,107,88,-1,480,640,525,-1,490,451,534,-1,480,425,644,-1,601,465,747,-1,198,301,710,-1,760,508,648,-1,648,508,322,-1,987,896,918,-1,987,1091,1075,-1,1135,1081,1009,-1,723,861,815,-1,680,831,799,-1,1136,1026,1145,-1,1082,1099,1136,-1,1044,1026,1136,-1,903,934,1013,-1,544,245,470,-1,547,550,629,-1,963,1091,987,-1,249,212,326,-1,285,350,352,-1,249,357,282,-1,140,231,270,-1,335,389,232,-1,533,403,192,-1,556,609,645,-1,755,653,647,-1,346,430,290,-1,517,606,906,-1,814,1038,1076,-1,521,663,786,-1,536,416,561,-1,804,800,731,-1,984,848,800,-1,811,1067,910,-1,726,787,893,-1,1053,846,843,-1,802,720,725,-1,676,843,725,-1,695,867,929,-1,555,556,733,-1,846,963,895,-1,875,913,863,-1,863,840,756,-1,942,938,913,-1,809,942,746,-1,724,756,674,-1,736,784,812,-1,917,918,732,-1,726,754,663,-1,875,719,686,-1,546,724,674,-1,470,506,657,-1,1004,839,835,-1,163,61,34,-1,87,47,128,-1,163,209,128,-1,72,152,124,-1,35,74,33,-1,98,24,87,-1,192,30,96,-1,192,403,170,-1,88,156,188,-1,45,54,60,-1,29,6,90,-1,10,67,3,-1,67,10,39,-1,64,376,385,-1,64,170,376,-1,152,109,114,-1,72,109,152,-1,7,128,47,-1,7,61,128,-1,789,642,650,-1,789,753,642,-1,997,1057,1013,-1,997,1032,1057,-1,300,570,546,-1,486,570,300,-1,1020,1004,1032,-1,1020,922,1004,-1,736,830,657,-1,736,812,830,-1,752,780,810,-1,752,777,780,-1,826,967,809,-1,929,967,826,-1,777,720,802,-1,777,796,720,-1,1138,787,1025,-1,787,1138,893,-1,910,899,837,-1,899,910,1035,-1,804,879,887,-1,879,804,906,-1,1105,986,1117,-1,1053,986,1105,-1,545,885,677,-1,545,714,885,-1,1134,1152,1120,-1,1134,1143,1152,-1,501,274,567,-1,274,501,304,-1,282,250,302,-1,250,282,271,-1,259,260,205,-1,260,259,196,-1,1031,1131,1140,-1,1031,974,1131,-1,249,232,201,-1,249,282,232,-1,713,745,903,-1,713,544,745,-1,1017,1057,1040,-1,1017,1007,1057,-1,1154,1144,1115,-1,1154,1147,1144,-1,757,680,799,-1,757,644,680,-1,919,744,820,-1,919,853,744,-1,896,1078,874,-1,896,1102,1078,-1,1075,1102,896,-1,911,1147,1014,-1,1144,1147,911,-1,759,1041,977,-1,759,763,1041,-1,886,845,766,-1,845,886,872,-1,707,632,531,-1,749,632,707,-1,566,472,478,-1,566,568,472,-1,568,463,472,-1,568,564,463,-1,332,144,378,-1,332,136,144,-1,144,157,178,-1,167,157,144,-1,379,168,84,-1,379,324,168,-1,464,641,617,-1,464,499,641,-1,654,376,649,-1,385,376,654,-1,956,1044,1099,-1,956,898,1044,-1,160,230,200,-1,230,160,210,-1,222,132,120,-1,222,180,132,-1,719,613,686,-1,570,613,719,-1,649,617,654,-1,599,617,649,-1,591,671,614,-1,584,671,591,-1,106,148,66,-1,106,161,148,-1,1083,739,1069,-1,739,1083,747,-1,917,895,918,-1,895,917,927,-1,42,181,59,-1,42,215,181,-1,419,898,956,-1,419,355,898,-1,325,713,702,-1,713,325,384,-1,384,544,713,-1,544,384,283,-1,106,117,132,-1,106,65,117,-1,933,1144,911,-1,1144,933,1128,-1,26,328,307,-1,26,119,328,-1,198,537,215,-1,198,565,537,-1,673,301,508,-1,673,710,301,-1,653,842,890,-1,653,755,842,-1,750,820,785,-1,820,750,901,-1,984,1124,848,-1,1111,1124,984,-1,290,75,228,-1,290,177,75,-1,648,853,760,-1,744,853,648,-1,524,291,488,-1,524,298,291,-1,878,668,808,-1,878,711,668,-1,823,715,836,-1,823,761,715,-1,638,469,676,-1,638,448,469,-1,608,974,1031,-1,608,535,974,-1,335,456,545,-1,335,302,456,-1,1077,1146,1155,-1,1118,1146,1077,-1,1155,1153,1125,-1,1153,1155,1149,-1,1002,844,905,-1,1002,1055,844,-1,343,443,372,-1,443,343,294,-1,329,227,236,-1,227,329,411,-1,578,631,541,-1,631,578,563,-1,278,159,185,-1,159,278,236,-1,185,345,278,-1,185,219,345,-1,360,292,316,-1,360,361,292,-1,292,280,220,-1,280,292,370,-1,556,351,420,-1,556,555,351,-1,773,370,450,-1,773,607,370,-1,32,79,19,-1,79,32,118,-1,636,602,741,-1,362,602,636,-1,275,354,272,-1,253,354,275,-1,169,48,40,-1,48,169,91,-1,273,611,477,-1,273,440,611,-1,4,22,37,-1,4,13,22,-1,884,655,598,-1,854,655,884,-1,907,877,856,-1,889,877,907,-1,912,1011,947,-1,948,1011,912,-1,25,127,16,-1,25,182,127,-1,819,824,900,-1,819,794,824,-1,411,441,255,-1,411,610,441,-1,100,175,103,-1,100,147,175,-1,11,2,41,-1,11,9,2,-1,475,400,356,-1,475,509,400,-1,413,239,338,-1,413,305,239,-1,78,264,284,-1,53,264,78,-1,264,53,81,-1,9,248,142,-1,248,9,11,-1,121,398,179,-1,121,396,398,-1,572,735,549,-1,735,572,817,-1,487,585,590,-1,585,487,519,-1,628,475,494,-1,628,513,475,-1,699,568,693,-1,699,564,568,-1,1012,825,779,-1,1012,1021,825,-1,999,1012,979,-1,1012,999,990,-1,978,778,1080,-1,978,838,778,-1,522,698,526,-1,522,646,698,-1,516,420,417,-1,453,420,516,-1,453,502,420,-1,769,1080,778,-1,769,1106,1080,-1,1133,966,1097,-1,1133,1150,966,-1,76,0,86,-1,5,0,76,-1,1061,858,822,-1,858,1061,1073,-1,1039,946,1093,-1,946,1039,993,-1,656,609,502,-1,656,582,609,-1,520,532,622,-1,532,520,522,-1,1051,976,1024,-1,976,1051,985,-1,689,418,822,-1,689,410,418,-1,20,102,77,-1,38,102,20,-1,981,1112,1095,-1,981,926,1112,-1,214,737,234,-1,214,803,737,-1,441,833,457,-1,771,833,441,-1,610,771,441,-1,860,771,610,-1,1039,1051,1024,-1,1039,1093,1051,-1,11,237,248,-1,27,237,11,-1,816,1129,851,-1,816,1036,1129,-1,615,953,926,-1,615,600,953,-1,857,479,678,-1,857,446,479,-1,318,504,252,-1,318,404,504,-1,338,397,394,-1,299,397,338,-1,32,173,295,-1,173,32,44,-1,1088,850,932,-1,1088,983,850,-1,748,284,722,-1,748,223,284,-1,104,477,331,-1,273,477,104,-1,400,320,276,-1,320,400,436,-1,452,447,319,-1,452,603,447,-1,484,694,504,-1,484,137,694,-1,396,527,542,-1,396,476,527,-1,904,907,973,-1,904,889,907,-1,621,580,583,-1,621,665,580,-1,773,930,697,-1,855,930,773,-1,598,353,189,-1,598,655,353,-1,477,708,331,-1,767,708,477,-1,973,870,1006,-1,973,907,870,-1,870,856,703,-1,870,907,856,-1,618,331,708,-1,618,182,331,-1,655,473,353,-1,655,684,473,-1,229,337,408,-1,337,229,279,-1,1000,1060,1068,-1,1000,1064,1060,-1,121,476,396,-1,121,312,476,-1,603,413,447,-1,603,515,413,-1,37,273,104,-1,179,273,37,-1,1119,1022,1088,-1,1022,1119,1036,-1,251,338,239,-1,251,299,338,-1,404,197,364,-1,318,197,404,-1,55,277,446,-1,55,41,277,-1,142,12,9,-1,142,49,12,-1,1036,776,1022,-1,776,1036,816,-1,102,600,615,-1,102,82,600,-1,223,776,246,-1,223,748,776,-1,700,926,981,-1,615,926,700,-1,939,982,765,-1,939,1029,982,-1,1093,1092,1051,-1,1092,1093,1087,-1,457,779,415,-1,833,779,457,-1,1122,1089,1126,-1,1089,1122,1090,-1,77,615,700,-1,77,102,615,-1,317,505,369,-1,317,321,505,-1,985,999,976,-1,999,985,990,-1,604,471,543,-1,604,474,471,-1,503,522,526,-1,503,532,522,-1,497,578,541,-1,497,576,578,-1,244,366,141,-1,244,373,366,-1,532,769,778,-1,532,503,769,-1,698,543,526,-1,543,698,727,-1,698,587,588,-1,698,646,587,-1,646,591,587,-1,539,591,646,-1,1005,962,905,-1,971,962,1005,-1,944,945,931,-1,944,965,945,-1,803,1021,991,-1,803,825,1021,-1,860,971,771,-1,860,962,971,-1,1029,964,998,-1,939,964,1029,-1,699,791,758,-1,699,693,791,-1,791,685,743,-1,791,693,685,-1,619,743,685,-1,743,619,495,-1,276,286,235,-1,276,320,286,-1,279,320,337,-1,279,286,320,-1,590,444,487,-1,590,586,444,-1,373,549,366,-1,549,373,572,-1,179,440,273,-1,179,398,440,-1,870,623,849,-1,703,623,870,-1,706,580,665,-1,706,577,580,-1,439,675,512,-1,675,436,509,-1,675,439,436,-1,569,982,822,-1,569,765,982,-1,391,277,126,-1,277,391,479,-1,241,548,264,-1,429,548,241,-1,213,404,312,-1,213,484,404,-1,338,447,413,-1,394,447,338,-1,435,562,518,-1,435,347,562,-1,86,68,268,-1,0,68,86,-1,855,900,930,-1,819,900,855,-1,827,894,940,-1,827,824,894,-1,900,864,873,-1,900,792,864,-1,940,957,908,-1,892,957,940,-1,923,957,892,-1,1011,989,947,-1,1011,873,989,-1,923,708,957,-1,923,618,708,-1,709,819,855,-1,794,819,709,-1,4,14,13,-1,4,8,14,-1,37,25,4,-1,104,25,37,-1,634,932,687,-1,634,925,932,-1,602,751,741,-1,602,491,751,-1,388,452,242,-1,388,510,452,-1,392,313,311,-1,392,368,313,-1,218,420,351,-1,420,218,417,-1,370,361,450,-1,361,370,292,-1,555,333,351,-1,574,333,555,-1,359,360,381,-1,359,406,360,-1,361,406,399,-1,406,361,360,-1,442,258,433,-1,442,308,258,-1,409,576,497,-1,576,409,575,-1,323,236,278,-1,236,323,329,-1,541,669,596,-1,669,541,631,-1,372,388,343,-1,369,388,372,-1,1063,1016,1070,-1,1063,1003,1016,-1,1023,1018,959,-1,1023,1089,1018,-1,112,485,321,-1,176,485,112,-1,302,289,456,-1,302,250,289,-1,829,535,449,-1,829,974,535,-1,676,501,805,-1,676,469,501,-1,401,454,482,-1,401,463,454,-1,691,531,490,-1,691,707,531,-1,632,808,668,-1,749,808,632,-1,831,633,815,-1,831,660,633,-1,298,43,291,-1,298,88,43,-1,426,523,612,-1,432,523,426,-1,831,1049,1065,-1,831,815,1049,-1,389,201,232,-1,449,201,389,-1,605,763,759,-1,612,763,605,-1,899,750,785,-1,899,852,750,-1,1145,1014,1147,-1,1145,1101,1014,-1,365,119,134,-1,328,119,365,-1,565,1043,537,-1,565,1074,1043,-1,307,933,911,-1,307,328,933,-1,1128,1100,1144,-1,1100,1128,1074,-1,69,83,35,-1,69,73,83,-1,120,52,110,-1,58,52,120,-1,355,718,898,-1,355,332,718,-1,70,35,33,-1,69,35,70,-1,537,1079,459,-1,537,1043,1079,-1,458,911,1014,-1,458,307,911,-1,780,927,810,-1,780,895,927,-1,113,374,190,-1,113,339,374,-1,157,161,180,-1,167,161,157,-1,682,559,599,-1,682,681,559,-1,641,654,617,-1,641,620,654,-1,578,686,613,-1,578,576,686,-1,793,915,1015,-1,793,768,915,-1,385,620,379,-1,385,654,620,-1,582,431,498,-1,582,589,431,-1,324,620,530,-1,379,620,324,-1,584,629,671,-1,584,547,629,-1,154,150,257,-1,150,154,186,-1,210,211,230,-1,210,193,211,-1,178,378,144,-1,378,178,325,-1,120,315,222,-1,110,315,120,-1,340,208,371,-1,153,208,340,-1,363,153,293,-1,363,208,153,-1,451,566,478,-1,451,577,566,-1,836,886,823,-1,836,872,886,-1,711,590,668,-1,711,586,590,-1,592,768,793,-1,593,768,592,-1,714,977,885,-1,714,759,977,-1,529,289,309,-1,289,529,456,-1,580,451,490,-1,580,577,451,-1,480,715,640,-1,717,480,644,-1,717,715,480,-1,174,597,334,-1,174,390,597,-1,26,71,36,-1,26,130,71,-1,755,950,847,-1,755,647,950,-1,712,820,744,-1,820,712,785,-1,601,723,633,-1,601,828,723,-1,723,1027,876,-1,723,828,1027,-1,718,1007,1017,-1,718,742,1007,-1,954,742,702,-1,954,1007,742,-1,287,326,285,-1,287,357,326,-1,243,259,352,-1,243,196,259,-1,201,212,249,-1,201,267,212,-1,267,201,233,-1,165,259,205,-1,165,310,259,-1,469,304,501,-1,304,469,327,-1,805,1094,986,-1,805,969,1094,-1,1056,974,829,-1,974,1056,1131,-1,852,800,887,-1,852,958,800,-1,705,753,910,-1,705,642,753,-1,846,725,843,-1,846,802,725,-1,733,929,826,-1,762,929,733,-1,796,764,720,-1,865,764,796,-1,798,840,797,-1,756,840,798,-1,840,938,865,-1,913,938,840,-1,875,724,719,-1,875,863,724,-1,576,746,686,-1,575,746,576,-1,920,812,880,-1,830,812,920,-1,486,613,570,-1,550,613,486,-1,1013,920,997,-1,934,920,1013,-1,139,98,87,-1,139,152,98,-1,138,135,200,-1,138,70,135,-1,39,24,17,-1,39,10,24,-1,57,60,105,-1,57,45,60,-1,670,1048,835,-1,1048,670,980,-1,170,424,376,-1,424,170,403,-1,45,98,114,-1,45,23,98,-1,753,783,811,-1,783,753,789,-1,657,745,470,-1,657,830,745,-1,972,1032,997,-1,972,1020,1032,-1,657,674,736,-1,506,674,657,-1,1020,927,917,-1,1020,972,927,-1,736,756,798,-1,674,756,736,-1,752,796,777,-1,797,796,752,-1,797,784,798,-1,797,752,784,-1,809,555,826,-1,555,809,574,-1,986,676,805,-1,986,843,676,-1,1042,893,1138,-1,1042,859,893,-1,837,785,712,-1,837,899,785,-1,407,561,416,-1,407,664,561,-1,228,517,466,-1,228,225,517,-1,1131,1120,1152,-1,1120,1131,1056,-1,1142,1152,1143,-1,1142,1148,1152,-1,336,448,303,-1,448,336,377,-1,232,302,335,-1,302,232,282,-1,226,422,288,-1,226,270,422,-1,233,608,267,-1,608,233,535,-1,357,271,282,-1,271,357,287,-1,327,265,304,-1,350,265,327,-1,265,326,212,-1,265,350,326,-1,243,303,240,-1,303,243,336,-1,1082,1069,891,-1,1069,1082,1156,-1,847,795,755,-1,679,795,847,-1,896,460,672,-1,896,874,460,-1,637,298,524,-1,637,425,298,-1,659,691,534,-1,691,659,761,-1,107,480,293,-1,480,107,425,-1,714,456,529,-1,456,714,545,-1,594,581,716,-1,579,581,594,-1,340,558,593,-1,371,558,340,-1,872,915,845,-1,915,872,921,-1,581,711,716,-1,581,586,711,-1,872,882,921,-1,872,836,882,-1,412,534,478,-1,659,534,412,-1,478,348,412,-1,478,472,348,-1,348,463,401,-1,348,472,463,-1,194,129,158,-1,129,194,216,-1,186,283,384,-1,186,154,283,-1,136,355,164,-1,136,332,355,-1,210,148,199,-1,210,160,148,-1,136,167,144,-1,164,167,136,-1,164,199,167,-1,157,186,178,-1,157,150,186,-1,591,499,587,-1,499,591,614,-1,587,464,588,-1,587,499,464,-1,355,193,164,-1,193,355,419,-1,200,122,160,-1,200,135,122,-1,1015,740,793,-1,740,1015,1010,-1,559,704,498,-1,559,681,704,-1,880,784,810,-1,880,812,784,-1,158,200,230,-1,158,138,200,-1,73,138,158,-1,73,69,138,-1,291,6,190,-1,291,43,6,-1,465,297,334,-1,465,339,297,-1,650,839,789,-1,650,835,839,-1,261,653,606,-1,261,462,653,-1,390,367,661,-1,390,216,367,-1,378,702,742,-1,702,378,325,-1,66,65,106,-1,72,65,66,-1,174,216,390,-1,174,129,216,-1,215,459,181,-1,459,215,537,-1,365,936,924,-1,365,405,936,-1,933,1116,1128,-1,933,924,1116,-1,881,1100,710,-1,881,1115,1100,-1,960,755,795,-1,755,960,842,-1,820,888,919,-1,820,901,888,-1,134,31,75,-1,119,31,134,-1,885,1120,1056,-1,1120,885,977,-1,744,551,712,-1,744,648,551,-1,679,1041,763,-1,679,847,1041,-1,107,156,88,-1,107,92,156,-1,823,916,749,-1,886,916,823,-1,969,608,1031,-1,969,567,608,-1,389,545,677,-1,545,389,335,-1,149,140,111,-1,183,140,149,-1,1071,1098,1054,-1,1071,1110,1098,-1,1127,1118,1141,-1,1127,1146,1118,-1,1063,1110,1050,-1,1063,1132,1110,-1,1096,1153,1149,-1,1096,1130,1153,-1,236,143,159,-1,143,236,227,-1,125,185,159,-1,125,131,185,-1,442,596,616,-1,442,433,596,-1,219,131,187,-1,219,185,131,-1,386,427,381,-1,427,386,468,-1,575,333,574,-1,409,333,575,-1,220,316,292,-1,316,220,238,-1,316,381,360,-1,381,316,386,-1,218,220,280,-1,218,202,220,-1,473,169,353,-1,473,311,169,-1,247,116,19,-1,247,294,116,-1,358,306,272,-1,358,204,306,-1,182,104,331,-1,25,104,182,-1,62,353,169,-1,62,189,353,-1,854,684,655,-1,832,684,854,-1,856,928,821,-1,877,928,856,-1,734,941,868,-1,734,883,941,-1,552,923,892,-1,618,923,552,-1,889,801,877,-1,871,801,889,-1,894,832,854,-1,832,824,794,-1,832,894,824,-1,827,871,864,-1,827,801,871,-1,415,203,457,-1,415,147,203,-1,147,428,175,-1,147,415,428,-1,364,312,404,-1,312,364,476,-1,722,264,548,-1,722,284,264,-1,1086,1129,1121,-1,1086,1028,1129,-1,841,513,628,-1,841,729,513,-1,461,495,619,-1,402,495,461,-1,675,1060,862,-1,729,1060,675,-1,703,440,623,-1,611,440,703,-1,581,571,437,-1,571,581,579,-1,627,817,572,-1,817,627,788,-1,244,286,314,-1,235,286,244,-1,444,581,437,-1,444,586,581,-1,566,706,685,-1,566,577,706,-1,1001,813,862,-1,1001,952,813,-1,952,817,788,-1,817,952,1001,-1,844,1037,937,-1,1037,844,1055,-1,779,979,1012,-1,833,979,779,-1,990,1021,1012,-1,990,991,1021,-1,990,961,991,-1,971,999,979,-1,971,1005,999,-1,538,584,493,-1,538,547,584,-1,532,838,622,-1,838,532,778,-1,727,582,656,-1,727,589,582,-1,770,471,516,-1,471,770,507,-1,738,417,481,-1,738,516,417,-1,965,803,991,-1,737,803,965,-1,1033,959,996,-1,1033,1023,959,-1,423,141,366,-1,145,141,423,-1,937,999,1005,-1,976,999,937,-1,453,604,656,-1,453,474,604,-1,359,278,345,-1,359,323,278,-1,959,998,931,-1,959,1018,998,-1,1018,1085,998,-1,1018,1090,1085,-1,1150,866,966,-1,1150,1114,866,-1,858,689,822,-1,858,818,689,-1,248,701,142,-1,248,851,701,-1,790,765,492,-1,790,939,765,-1,1109,1037,1055,-1,1037,1109,1084,-1,1073,1090,1122,-1,1073,1085,1090,-1,55,27,11,-1,82,27,55,-1,237,851,248,-1,237,816,851,-1,1112,953,1121,-1,1112,926,953,-1,38,237,27,-1,38,246,237,-1,678,1086,857,-1,1086,678,834,-1,397,256,394,-1,397,306,256,-1,396,557,398,-1,557,396,542,-1,957,767,928,-1,767,957,708,-1,108,330,93,-1,108,342,330,-1,630,728,542,-1,728,630,721,-1,1114,841,866,-1,1114,1068,841,-1,518,330,342,-1,518,494,330,-1,344,519,487,-1,519,344,408,-1,621,461,665,-1,621,445,461,-1,692,758,667,-1,692,699,758,-1,992,912,1077,-1,930,912,992,-1,552,189,127,-1,552,598,189,-1,611,767,477,-1,821,767,611,-1,1008,1006,1047,-1,1006,1008,973,-1,703,821,611,-1,703,856,821,-1,182,552,127,-1,182,618,552,-1,684,528,473,-1,684,709,528,-1,439,337,320,-1,439,402,337,-1,487,281,344,-1,487,444,281,-1,866,628,666,-1,866,841,628,-1,305,515,391,-1,515,305,413,-1,925,1088,932,-1,1095,1088,925,-1,354,687,438,-1,634,687,354,-1,256,204,123,-1,306,204,256,-1,269,206,166,-1,239,206,269,-1,897,1028,1086,-1,897,935,1028,-1,1119,1121,1129,-1,1119,1112,1121,-1,748,1022,776,-1,748,983,1022,-1,1085,982,1029,-1,1085,1061,982,-1,415,825,428,-1,779,825,415,-1,774,492,414,-1,774,790,492,-1,1023,1045,1062,-1,1033,1045,1023,-1,20,246,38,-1,246,20,223,-1,254,187,241,-1,219,187,254,-1,418,76,86,-1,410,76,418,-1,994,1051,1092,-1,994,985,1051,-1,493,591,539,-1,591,493,584,-1,526,507,503,-1,507,526,543,-1,541,433,497,-1,433,541,596,-1,1024,937,1037,-1,1024,976,937,-1,931,996,959,-1,945,996,931,-1,172,234,56,-1,172,214,234,-1,770,503,507,-1,503,770,769,-1,604,727,656,-1,604,543,727,-1,698,589,727,-1,698,588,589,-1,985,961,990,-1,985,994,961,-1,991,945,965,-1,991,961,945,-1,944,737,965,-1,774,737,944,-1,979,771,971,-1,771,979,833,-1,939,944,964,-1,944,790,774,-1,790,944,939,-1,519,445,621,-1,445,519,408,-1,314,279,349,-1,286,279,314,-1,667,624,692,-1,667,540,624,-1,398,623,440,-1,398,557,623,-1,492,569,268,-1,569,492,765,-1,553,252,504,-1,253,252,553,-1,207,239,305,-1,239,207,206,-1,518,628,494,-1,518,666,628,-1,318,166,197,-1,318,269,166,-1,414,268,68,-1,268,414,492,-1,143,147,100,-1,143,203,147,-1,854,940,894,-1,940,884,892,-1,940,854,884,-1,864,883,873,-1,864,871,883,-1,928,908,957,-1,908,928,877,-1,892,598,552,-1,598,892,884,-1,868,873,734,-1,873,868,989,-1,832,709,684,-1,832,794,709,-1,16,189,62,-1,16,127,189,-1,16,4,25,-1,16,8,4,-1,62,8,16,-1,62,40,8,-1,256,242,319,-1,123,242,256,-1,362,19,133,-1,247,19,362,-1,280,417,218,-1,417,280,481,-1,450,399,368,-1,450,361,399,-1,202,351,333,-1,351,202,218,-1,375,406,345,-1,375,399,406,-1,329,427,496,-1,329,323,427,-1,151,131,125,-1,151,262,131,-1,596,869,616,-1,869,596,669,-1,100,159,143,-1,100,125,159,-1,510,369,505,-1,510,388,369,-1,1030,1149,1107,-1,1030,1096,1149,-1,1045,1003,1050,-1,1003,1045,1087,-1,770,1106,769,-1,770,1019,1106,-1,1125,772,992,-1,1125,1019,772,-1,1132,1141,1108,-1,1132,1127,1141,-1,289,183,149,-1,289,250,183,-1,449,677,829,-1,677,449,389,-1,805,567,969,-1,805,501,567,-1,240,383,192,-1,383,240,303,-1,580,531,583,-1,580,490,531,-1,250,231,183,-1,250,271,231,-1,625,763,612,-1,625,679,763,-1,462,647,653,-1,462,1009,647,-1,712,705,837,-1,712,551,705,-1,836,757,882,-1,717,757,836,-1,677,1056,829,-1,1056,677,885,-1,874,405,460,-1,874,936,405,-1,466,804,731,-1,804,466,517,-1,958,899,1035,-1,899,958,852,-1,951,909,988,-1,909,951,919,-1,130,263,71,-1,130,224,263,-1,36,31,26,-1,36,42,31,-1,134,405,365,-1,134,177,405,-1,174,73,129,-1,174,94,73,-1,332,742,718,-1,742,332,378,-1,661,380,775,-1,661,367,380,-1,109,135,89,-1,135,109,122,-1,1043,1137,1079,-1,1137,1043,1116,-1,739,465,334,-1,739,747,465,-1,180,106,132,-1,161,106,180,-1,620,658,530,-1,641,658,620,-1,609,498,645,-1,609,582,498,-1,209,117,65,-1,163,117,209,-1,297,94,334,-1,83,94,297,-1,1156,1083,1069,-1,1083,1156,1151,-1,190,29,74,-1,190,6,29,-1,84,385,379,-1,84,64,385,-1,733,704,635,-1,733,645,704,-1,431,559,498,-1,431,599,559,-1,589,464,431,-1,589,588,464,-1,222,257,150,-1,315,257,222,-1,210,164,193,-1,210,199,164,-1,419,211,193,-1,211,419,380,-1,384,178,186,-1,325,178,384,-1,211,216,194,-1,367,211,380,-1,216,211,367,-1,208,412,348,-1,363,412,208,-1,363,659,412,-1,525,659,363,-1,680,524,660,-1,680,637,524,-1,585,668,590,-1,632,668,585,-1,955,886,766,-1,955,916,886,-1,421,593,592,-1,340,593,421,-1,529,759,714,-1,529,605,759,-1,597,661,891,-1,390,661,597,-1,890,606,653,-1,606,890,906,-1,919,943,853,-1,951,943,919,-1,524,633,660,-1,524,488,633,-1,988,842,960,-1,988,909,842,-1,891,775,1082,-1,661,775,891,-1,1007,1013,1057,-1,1007,954,1013,-1,352,336,243,-1,336,352,377,-1,212,304,265,-1,274,212,267,-1,274,304,212,-1,270,285,310,-1,270,287,285,-1,567,267,608,-1,274,267,567,-1,310,288,422,-1,165,288,310,-1,448,327,469,-1,448,377,327,-1,969,1140,1094,-1,969,1031,1140,-1,1152,1140,1131,-1,1152,1148,1140,-1,1148,1094,1140,-1,1148,1117,1094,-1,1076,1124,1138,-1,1038,1124,1076,-1,764,383,720,-1,764,533,383,-1,867,865,938,-1,764,865,867,-1,865,797,840,-1,865,796,797,-1,810,972,880,-1,810,927,972,-1,997,880,972,-1,920,880,997,-1,550,578,613,-1,563,578,550,-1,934,830,920,-1,745,830,934,-1,726,811,783,-1,859,811,726,-1,315,155,257,-1,315,110,155,-1,1,3,30,-1,7,3,1,-1,17,23,46,-1,17,24,23,-1],
          coord=Coordinate(DEF='atlas_Coord',point=[(.56424,55.72501,-1.53774),(.53378,55.77236,-1.50028),(.51967,55.84565,-1.56414),(.42326,55.8298,-1.36641),(.47295,55.91718,-1.36086),(.48194,55.91447,-1.42629),(.3868,55.81091,-1.26749),(.4254,55.77234,-1.36063),(.52062,55.79399,-1.62962),(.4955,55.76616,-1.67308),(.55755,55.71889,-1.57094),(.40127,55.79779,-.93734),(.34503,55.84444,-.909),(.37026,55.84602,-.95989),(.4317,55.88227,-1.27315),(.37901,55.82806,-1.19167),(.57388,55.9868,-1.63273),(.59351,55.90835,-1.63887),(.57778,55.89226,-1.60742),(.51884,55.96802,-1.24456),(.55178,56.02781,-1.25962),(.54789,55.99084,-1.29907),(.41172,55.9517,-1.18413),(.387,55.97293,-1.11271),(.44867,56.01799,-1.15767),(.47332,55.92614,-1.2315),(.4211,55.87501,-1.19577),(1.05856,55.98032,-1.30286),(.97791,56.06065,-1.26473),(1.01314,55.9955,-1.20366),(.42188,56.26435,-.94432),(.34298,56.22393,-.95351),(.37161,56.18575,-.88212),(.28073,56.16775,-.85901),(.40257,56.1578,-.85938),(.08761,56.04019,-.60755),(.21286,56.04273,-.69091),(.08993,56.08444,-.6737),(1.14871,55.82152,-1.12853),(1.22446,55.76608,-1.14296),(1.23945,55.85009,-1.16106),(.98364,55.89581,-1.07612),(1.05299,55.80155,-1.12318),(1.07241,55.85687,-1.10987),(.50484,56.16532,-.88896),(.52951,56.06764,-.85926),(.64912,56.04163,-.91003),(.28464,56.12378,-.80568),(.30852,56.06556,-.77499),(.42731,56.06951,-.82705),(.10085,55.99328,-.58226),(.23507,55.95018,-.67947),(.22298,56.00349,-.6929),(.34194,55.91864,-.76501),(.3293,55.99507,-.76214),(.44776,55.98221,-.83431),(.89667,55.88439,-1.00288),(.791,55.88635,-.96007),(.78381,55.79577,-.9549),(.14568,55.80452,-.65059),(.12134,55.90625,-.58906),(0,55.89948,-.56295),(.34203,55.7913,-.79718),(.23669,55.88113,-.67906),(.25393,55.80277,-.73699),(.5074,55.75074,-.90003),(.51542,55.74591,-.89887),(.54532,55.79967,-.85677),(.75338,55.62169,-.9512),(.66682,55.74108,-.89692),(.66096,55.68113,-.90097),(.84831,55.68967,-1.00187),(.87414,55.78066,-1.00905),(1.3292,55.7291,-1.15553),(1.28973,55.90312,-1.4135),(1.23455,55.91877,-1.37006),(1.32557,55.87034,-1.27539),(1.17972,55.71111,-1.36968),(1.20527,55.78957,-1.40299),(1.2781,55.80311,-1.34756),(1.314,55.85817,-1.41239),(1.3781,55.83794,-1.33992),(1.29527,55.68712,-1.18724),(1.12666,55.77159,-1.16001),(1.14568,55.69681,-1.35247),(1.11631,55.73101,-1.43904),(1.18147,55.70558,-1.25838),(1.08825,55.75483,-1.23068),(1.13082,55.72497,-1.28902),(.91652,55.74558,-1.0935),(.99034,55.81983,-1.0811),(.12386,55.75362,-.77838),(0,55.8274,-.6244),(.42205,55.78321,-.85451),(.43934,55.71582,-1.35835),(.49577,55.6776,-1.42476),(.51868,55.69031,-1.31206),(.46519,55.72393,-1.18332),(.48847,55.70773,-1.24849),(.59033,55.65305,-1.09384),(.66087,55.6396,-1.06424),(.64531,55.65727,-.94804),(.57107,55.65719,-1.18273),(.66321,55.62269,-1.17383),(.6651,55.60422,-1.25997),(.72021,55.58799,-1.23481),(.90597,55.70579,-1.10347),(0,56.14372,-.89811),(0,56.1356,-.8092),(.08912,56.14381,-.83725),(.58867,56.27792,-.97626),(.54081,56.34356,-1.0286),(.81889,56.20578,-1.11423),(.76691,56.27716,-1.1481),(.68636,56.28658,-1.04457),(.83303,56.12463,-1.49516),(.81548,56.14424,-1.38811),(.86305,56.06524,-1.49528),(.89139,56.05235,-1.59188),(.86981,56.13325,-1.59648),(.88365,56.10415,-1.38718),(.91573,56.02119,-1.35799),(.87602,55.98575,-1.46387),(.8278,56.14744,-1.717),(.8576,56.06025,-1.72491),(.76551,56.1037,-1.77192),(.60251,55.69416,-1.85848),(.69515,55.72401,-1.79095),(.7664,55.70073,-1.80429),(.97869,55.77723,-1.5865),(1.07116,55.8144,-1.52571),(1.06531,55.78057,-1.51747),(.94567,55.75628,-1.29986),(.93953,55.7201,-1.29441),(.90077,55.70323,-1.41343),(.94874,55.70421,-1.17621),(.98444,55.74091,-1.15235),(1.06833,55.89201,-1.4507),(1.14131,55.89016,-1.50247),(1.03403,55.85453,-1.53245),(.94134,55.84589,-1.58332),(.9311,55.85187,-1.55745),(1.01252,55.8618,-1.52324),(.92726,55.84881,-1.5483),(.93514,55.8224,-1.52478),(1.00983,55.83218,-1.48331),(.78353,55.94108,-1.71599),(.78207,55.87883,-1.67787),(.71533,55.87343,-1.69114),(.49445,55.73365,-1.78526),(.54675,55.71768,-1.83531),(.49943,55.70307,-1.92374),(.30442,55.72474,-2.08846),(.37551,55.70994,-1.98265),(.43529,55.70555,-2.03189),(.09561,55.76231,-2.12072),(.14951,55.76938,-2.04416),(.17864,55.76089,-2.11241),(.33096,55.71197,-1.93894),(.39415,55.68941,-1.83598),(.43844,55.70717,-1.86584),(.52954,55.78316,-1.71542),(.61497,55.70554,-1.55038),(.71831,55.68663,-1.54442),(.58984,55.65516,-1.5125),(.49408,55.68336,-1.43017),(.55117,55.68764,-1.47814),(.53853,55.64532,-1.45669),(.28193,55.43622,-1.9538),(.31798,55.49296,-2.05171),(.41961,55.44485,-1.91736),(.10608,55.45452,-1.97831),(.18707,55.47152,-2.11212),(.16413,55.4533,-1.9755),(.56058,55.58116,-1.73612),(.64151,55.55645,-1.7919),(.72637,55.63618,-1.68472),(.54409,55.51332,-1.85029),(.35666,55.47252,-1.87261),(.14563,55.45817,-1.91621),(.31075,55.52381,-1.84316),(.23087,55.52323,-1.87376),(.25975,55.45708,-1.88584),(.13643,55.45978,-2.13979),(.18749,55.51323,-2.19019),(.19324,55.60605,-2.20475),(.25562,55.61297,-2.16018),(.85091,55.72144,-1.68018),(.76941,55.6529,-1.74925),(.77066,55.69347,-1.80369),(.17925,55.75398,-2.12394),(.31005,55.71577,-2.09621),(.19588,55.67422,-2.16592),(.07124,55.75329,-2.04524),(.13106,55.66947,-1.97058),(.44586,55.68651,-1.71331),(.36259,55.63728,-1.78977),(.4039,55.57209,-1.77051),(.21589,55.62077,-1.90461),(.55101,55.99739,-1.30206),(.60463,56.05743,-1.31861),(.61606,56.03897,-1.39486),(.48601,56.20198,-1.05559),(.36255,56.1662,-1.0121),(.41724,56.28862,-.98453),(.70546,56.10943,-1.61414),(.65917,56.07352,-1.5194),(.73301,56.11721,-1.53556),(.6594,56.09131,-1.33535),(.63772,56.13023,-1.26238),(.84659,56.20401,-1.32848),(.91133,56.12998,-1.30355),(.0816,56.13431,-.90881),(.17135,56.15342,-.87374),(.26972,56.1137,-.94591),(.1905,56.10367,-.92792),(.20836,56.03424,-.92016),(.09889,56.03152,-.89995),(.0882,56.11914,-.9388),(.23506,55.78742,-.80473),(.61782,55.70882,-1.56506),(.62558,55.6647,-1.65074),(.71276,55.69115,-1.55521),(.55022,55.68411,-1.9836),(.68452,55.66825,-1.89239),(.58128,55.6144,-1.97295),(.69203,55.59157,-1.84777),(1.14124,55.79719,-1.46327),(.21194,55.86278,-.86047),(.20952,55.8588,-.85719),(.20361,55.86295,-.86394),(.18562,55.79764,-.82141),(.59344,56.01712,-1.59831),(.57518,55.99298,-1.63073),(.55241,55.98234,-1.56321),(.35793,56.16337,-1.00674),(.392,56.10006,-1.05048),(.36782,56.0055,-.97675),(.61646,55.81051,-1.71299),(.56135,55.81678,-1.68167),(.57615,55.84468,-1.65398),(.64559,55.862,-1.6818),(.72524,55.93362,-1.7052),(.65934,55.91987,-1.67625),(.63344,55.95135,-1.69024),(1.11566,55.95981,-1.35492),(1.01501,55.97401,-1.33698),(.87544,55.95536,-1.55734),(.8806,55.88768,-1.54259),(.85283,55.9197,-1.63645),(1.06109,55.86632,-1.43571),(1.06329,55.88711,-1.44503),(.96916,55.81089,-1.24221),(.97917,55.7742,-1.21461),(.94683,55.77041,-1.30219),(.6087,56.01691,-1.69426),(.60661,56.01354,-1.691),(.6066,56.01895,-1.68819),(.39285,56.10674,-1.05641),(.54941,55.98186,-1.37253),(.55374,55.98799,-1.37428),(.54544,55.99011,-1.45139),(.54096,55.98379,-1.45114),(.54923,55.97503,-1.5604),(.43497,56.06417,-1.11226),(.49368,56.0506,-1.18677),(.43351,56.05687,-1.10757),(1.10439,55.72743,-1.34086),(1.12144,55.7356,-1.29242),(1.09045,55.81344,-1.3323),(.89296,55.8522,-1.37845),(.92485,55.80811,-1.34183),(.91257,55.7831,-1.46157),(.93879,55.85684,-1.26139),(1.03288,55.81464,-1.24353),(.9245,55.85464,-1.55699),(.9208,56.01848,-1.35146),(.91807,56.0112,-1.35362),(.87687,55.96447,-1.56194),(.87686,55.97506,-1.46031),(.86386,55.87252,-1.61925),(1.33732,55.83257,-1.1764),(1.37675,55.83922,-1.24186),(1.30284,55.66284,-1.25394),(1.37832,55.71176,-1.23538),(1.36673,55.71227,-1.19873),(1.37821,55.73909,-1.31025),(1.37399,55.74683,-1.31755),(1.37982,55.74918,-1.31115),(.8983,55.75664,-1.64253),(.89989,55.76606,-1.64523),(1.11258,55.7542,-1.20325),(1.18197,55.73866,-1.18577),(.9857,55.71219,-1.43383),(1.06416,55.71863,-1.38898),(1.06239,55.73049,-1.38689),(1.10938,55.71537,-1.34336),(.9341,55.74139,-1.42185),(1.19692,55.68702,-1.28981),(.91468,55.58013,-1.38858),(.87395,55.58518,-1.44964),(.87648,55.6722,-1.47377),(.44379,55.70512,-2.0275),(.44071,55.69957,-2.03621),(.87323,55.81981,-1.65027),(.88324,55.8149,-1.64569),(.82613,55.76167,-1.73142),(.7021,55.59017,-1.50319),(.70887,55.6283,-1.521),(.88433,55.68242,-1.47575),(.88016,55.68161,-1.48207),(.89626,55.69008,-1.41142),(.94276,55.69193,-1.17912),(.94764,55.70618,-1.18245),(.90438,55.69125,-1.10419),(.11461,55.46316,-1.91971),(.51362,55.74191,-.907),(.43365,55.72241,-1.36109),(.3879,55.7441,-1.27357),(.39972,55.73569,-1.27297),(.38447,55.76124,-1.18174),(.37863,55.79896,-1.08999),(.38475,55.79272,-1.08983),(.39028,55.79198,-1.00695),(-.56424,55.72501,-1.53774),(-.52962,55.80836,-1.60481),(-.51967,55.84565,-1.56414),(-.42326,55.8298,-1.36641),(-.48179,55.83016,-1.43975),(-.48194,55.91447,-1.42629),(-.4254,55.77234,-1.36063),(-.3868,55.81091,-1.26749),(-.55755,55.71889,-1.57094),(-.4955,55.76616,-1.67308),(-.52062,55.79399,-1.62962),(-.39907,55.79679,-.9481),(-.36835,55.79288,-.88548),(-.40127,55.79779,-.93734),(-.4211,55.87501,-1.19577),(-.4317,55.88227,-1.27315),(-.54923,55.97503,-1.5604),(-.59351,55.90835,-1.63887),(-.57388,55.9868,-1.63273),(-.51884,55.96802,-1.24456),(-.48605,55.93063,-1.28027),(-.54789,55.99084,-1.29907),(-.41172,55.9517,-1.18413),(-.44867,56.01799,-1.15767),(-.387,55.97293,-1.11271),(-.38439,55.88374,-1.15156),(-.38542,55.99434,-1.05262),(-1.05856,55.98032,-1.30286),(-1.01314,55.9955,-1.20366),(-.97791,56.06065,-1.26473),(-.37161,56.18575,-.88212),(-.34298,56.22393,-.95351),(-.42188,56.26435,-.94432),(-.40257,56.1578,-.85938),(-.28464,56.12378,-.80568),(-.08761,56.04019,-.60755),(-.08993,56.08444,-.6737),(-.18693,56.10599,-.73954),(-1.15209,55.87172,-1.15176),(-1.23945,55.85009,-1.16106),(-1.22446,55.76608,-1.14296),(-.98364,55.89581,-1.07612),(-1.07241,55.85687,-1.10987),(-1.05299,55.80155,-1.12318),(-.64172,56.1313,-.92257),(-.52951,56.06764,-.85926),(-.50484,56.16532,-.88896),(-.30852,56.06556,-.77499),(-.23507,55.95018,-.67947),(-.10085,55.99328,-.58226),(-.3293,55.99507,-.76214),(-.22298,56.00349,-.6929),(-.44776,55.98221,-.83431),(-.21286,56.04273,-.69091),(-.78381,55.79577,-.9549),(-.791,55.88635,-.96007),(-.89667,55.88439,-1.00288),(-.66096,55.68113,-.90097),(-.66682,55.74108,-.89692),(-.77896,55.68201,-.93652),(-.54532,55.79967,-.85677),(-.66507,55.79208,-.90238),(-.87414,55.78066,-1.00905),(-.84831,55.68967,-1.00187),(-1.34236,55.79495,-1.15962),(-1.3292,55.7291,-1.15553),(-1.28973,55.90312,-1.4135),(-1.37545,55.84506,-1.3436),(-1.23455,55.91877,-1.37006),(-1.2781,55.80311,-1.34756),(-1.37399,55.74683,-1.31755),(-1.3781,55.83794,-1.33992),(-1.24006,55.70953,-1.33166),(-1.17972,55.71111,-1.36968),(-1.12666,55.77159,-1.16001),(-1.11631,55.73101,-1.43904),(-1.14568,55.69681,-1.35247),(-1.13082,55.72497,-1.28902),(-1.08825,55.75483,-1.23068),(-1.18147,55.70558,-1.25838),(-.99034,55.81983,-1.0811),(-.91652,55.74558,-1.0935),(0,55.75655,-.7487),(-.14568,55.80452,-.65059),(-.12386,55.75362,-.77838),(-.42205,55.78321,-.85451),(-.5074,55.75074,-.90003),(-.5519,55.64688,-1.36205),(-.49577,55.6776,-1.42476),(-.43934,55.71582,-1.35835),(-.67256,55.57675,-1.3653),(-.6651,55.60422,-1.25997),(-.72021,55.58799,-1.23481),(-.51868,55.69031,-1.31206),(-.48847,55.70773,-1.24849),(-.46519,55.72393,-1.18332),(-.59033,55.65305,-1.09384),(-.66087,55.6396,-1.06424),(-.66321,55.62269,-1.17383),(-.90597,55.70579,-1.10347),(-.0816,56.13431,-.90881),(-.08912,56.14381,-.83725),(-.54081,56.34356,-1.0286),(-.58867,56.27792,-.97626),(-.81889,56.20578,-1.11423),(-.70715,56.24514,-1.03899),(-.68636,56.28658,-1.04457),(-.88365,56.10415,-1.38718),(-.81548,56.14424,-1.38811),(-.83303,56.12463,-1.49516),(-.86981,56.13325,-1.59648),(-.89139,56.05235,-1.59188),(-.86305,56.06524,-1.49528),(-.87602,55.98575,-1.46387),(-.91573,56.02119,-1.35799),(-.76551,56.1037,-1.77192),(-.8576,56.06025,-1.72491),(-.8278,56.14744,-1.717),(-.7664,55.70073,-1.80429),(-.69515,55.72401,-1.79095),(-.60251,55.69416,-1.85848),(-1.06531,55.78057,-1.51747),(-1.07116,55.8144,-1.52571),(-.97869,55.77723,-1.5865),(-.94567,55.75628,-1.29986),(-.93154,55.73071,-1.41662),(-.90077,55.70323,-1.41343),(-.98444,55.74091,-1.15235),(-.94874,55.70421,-1.17621),(-1.14131,55.89016,-1.50247),(-1.06833,55.89201,-1.4507),(-1.01252,55.8618,-1.52324),(-1.03403,55.85453,-1.53245),(-.9311,55.85187,-1.55745),(-1.00983,55.83218,-1.48331),(-.93514,55.8224,-1.52478),(-.92726,55.84881,-1.5483),(-.71533,55.87343,-1.69114),(-.78207,55.87883,-1.67787),(-.78353,55.94108,-1.71599),(-.49943,55.70307,-1.92374),(-.54675,55.71768,-1.83531),(-.49445,55.73365,-1.78526),(-.43529,55.70555,-2.03189),(-.37551,55.70994,-1.98265),(-.30442,55.72474,-2.08846),(-.17864,55.76089,-2.11241),(-.14951,55.76938,-2.04416),(-.09561,55.76231,-2.12072),(-.43844,55.70717,-1.86584),(-.39415,55.68941,-1.83598),(-.33096,55.71197,-1.93894),(-.52954,55.78316,-1.71542),(-.44625,55.72364,-1.73142),(-.58984,55.65516,-1.5125),(-.71831,55.68663,-1.54442),(-.61497,55.70554,-1.55038),(-.55117,55.68764,-1.47814),(-.51249,55.72644,-1.444),(-.49408,55.68336,-1.43017),(-.41961,55.44485,-1.91736),(-.31798,55.49296,-2.05171),(-.28193,55.43622,-1.9538),(-.18707,55.47152,-2.11212),(-.13643,55.45978,-2.13979),(-.10608,55.45452,-1.97831),(-.72637,55.63618,-1.68472),(-.64151,55.55645,-1.7919),(-.62558,55.6647,-1.65074),(-.35666,55.47252,-1.87261),(-.4699,55.52774,-1.79051),(-.31075,55.52381,-1.84316),(-.25975,55.45708,-1.88584),(-.24032,55.53798,-2.13951),(-.18749,55.51323,-2.19019),(-.3377,55.61769,-2.10829),(-.25562,55.61297,-2.16018),(-.82613,55.76167,-1.73142),(-.77066,55.69347,-1.80369),(-.85091,55.72144,-1.68018),(-.30026,55.68048,-1.90729),(-.229,55.68238,-1.94837),(-.25968,55.74704,-2.00348),(0,55.60202,-1.93842),(0,55.66299,-1.97913),(-.13106,55.66947,-1.97058),(-.21589,55.62077,-1.90461),(-.4039,55.57209,-1.77051),(-.36259,55.63728,-1.78977),(-.44586,55.68651,-1.71331),(-.23087,55.52323,-1.87376),(-.61606,56.03897,-1.39486),(-.60463,56.05743,-1.31861),(-.55101,55.99739,-1.30206),(-.41724,56.28862,-.98453),(-.36255,56.1662,-1.0121),(-.48601,56.20198,-1.05559),(-.73301,56.11721,-1.53556),(-.65917,56.07352,-1.5194),(-.70546,56.10943,-1.61414),(-.50944,56.11206,-1.1231),(-.547,56.19824,-1.11339),(-.91133,56.12998,-1.30355),(-.84659,56.20401,-1.32848),(-.17135,56.15342,-.87374),(-.1905,56.10367,-.92792),(-.26972,56.1137,-.94591),(-.18355,56.09862,-.93016),(-.0882,56.11914,-.9388),(-.09889,56.03152,-.89995),(-.56058,55.58116,-1.73612),(-.47477,55.60918,-1.72823),(-.69203,55.59157,-1.84777),(-.76941,55.6529,-1.74925),(-1.17334,55.85241,-1.49629),(-1.14124,55.79719,-1.46327),(-.17577,56.10647,-.92516),(-.37058,55.8491,-1.12931),(-.36406,55.8579,-1.03052),(-.35793,56.16337,-1.00674),(-.34408,56.15676,-.99383),(-.36782,56.0055,-.97675),(-.6066,56.01895,-1.68819),(-.65674,56.07674,-1.70954),(-.63558,56.05618,-1.63297),(-.61646,55.81051,-1.71299),(-.64559,55.862,-1.6818),(-.57615,55.84468,-1.65398),(-.72524,55.93362,-1.7052),(-.78666,56.01413,-1.76971),(-.68215,56.0143,-1.76013),(-1.11516,55.9399,-1.23095),(-1.18278,55.92873,-1.30432),(-1.20854,55.90775,-1.26046),(-1.01501,55.97401,-1.33698),(-1.07278,55.91595,-1.37394),(-1.11566,55.95981,-1.35492),(-.85283,55.9197,-1.63645),(-.8806,55.88768,-1.54259),(-.87544,55.95536,-1.55734),(-1.06329,55.88711,-1.44503),(-1.00772,55.85847,-1.51572),(-.60661,56.01354,-1.691),(-.6087,56.01691,-1.69426),(-.392,56.10006,-1.05048),(-.54941,55.98186,-1.37253),(-.55241,55.98234,-1.56321),(-.54544,55.99011,-1.45139),(-.50329,55.90792,-1.48851),(-.43351,56.05687,-1.10757),(-.49305,56.04208,-1.18579),(-.43497,56.06417,-1.11226),(-1.08967,55.7939,-1.39112),(-1.09045,55.81344,-1.3323),(-1.12144,55.7356,-1.29242),(-.92485,55.80811,-1.34183),(-.89296,55.8522,-1.37845),(-.89089,55.83109,-1.50294),(-.96916,55.81089,-1.24221),(-1.02251,55.85052,-1.26886),(-.93879,55.85684,-1.26139),(-.9245,55.85464,-1.55699),(-.91807,56.0112,-1.35362),(-.9208,56.01848,-1.35146),(-.87687,55.96447,-1.56194),(-.86386,55.87252,-1.61925),(-1.37675,55.83922,-1.24186),(-1.33732,55.83257,-1.1764),(-1.32557,55.87034,-1.27539),(-1.36673,55.71227,-1.19873),(-1.37832,55.71176,-1.23538),(-1.30284,55.66284,-1.25394),(-1.37982,55.74918,-1.31115),(-1.37821,55.73909,-1.31025),(-.89989,55.76606,-1.64523),(-.8983,55.75664,-1.64253),(-1.18197,55.73866,-1.18577),(-1.11258,55.7542,-1.20325),(-.98709,55.72245,-1.43216),(-1.06239,55.73049,-1.38689),(-.9857,55.71219,-1.43383),(-.9341,55.74139,-1.42185),(-.91468,55.58013,-1.38858),(-.89626,55.69008,-1.41142),(-.87648,55.6722,-1.47377),(-.68452,55.66825,-1.89239),(-.68167,55.67555,-1.88951),(-.88324,55.8149,-1.64569),(-.82034,55.769,-1.73302),(-.61782,55.70882,-1.56506),(-.88433,55.68242,-1.47575),(-.94276,55.69193,-1.17912),(-.90438,55.69125,-1.10419),(-.58309,55.54246,-1.92331),(-.44754,55.51718,-1.99978),(-.31005,55.71577,-2.09621),(-.11461,55.46316,-1.91971),(-.14563,55.45817,-1.91621),(-.1216,55.52428,-1.91073),(-.43365,55.72241,-1.36109),(-.38447,55.76124,-1.18174),(-.3879,55.7441,-1.27357),(-.37879,55.77099,-1.18178),(-.38475,55.79272,-1.08983),(-.37863,55.79896,-1.08999),(-.37568,55.80077,-1.00931),(-.39972,55.73569,-1.27297),(-.65677,55.67412,-.90714),(-.51542,55.74591,-.89887),(-.40788,55.7903,-.94437),(-.11372,55.50461,-2.21214),(-.93679,55.7057,-1.29266),(-.94764,55.70618,-1.18245),(-.71276,55.69115,-1.55521),(-.53853,55.64532,-1.45669),(-.5901,55.61036,-1.4768),(-.72964,55.69282,-1.55213),(-.9213,55.6969,-1.47563),(-.87974,55.82526,-1.64319),(-.94617,55.8377,-1.58789),(-.54802,55.69062,-1.97822),(-.87323,55.81981,-1.65027),(-.97917,55.7742,-1.21461),(-.97744,55.76211,-1.20742),(-1.08274,55.76148,-1.24235),(-1.04152,55.78473,-1.22241),(-1.10439,55.72743,-1.34086),(-1.06416,55.71863,-1.38898),(-1.19692,55.68702,-1.28981),(-1.23303,55.69178,-1.24278),(-1.29982,55.6912,-1.29976),(-1.24307,55.68755,-1.29079),(-1.383,55.83975,-1.33372),(-1.30985,55.69277,-1.29781),(-1.2996,55.69309,-1.3055),(-1.314,55.85817,-1.41239),(-1.31578,55.86681,-1.41382),(-1.0096,55.96665,-1.33799),(-1.0658,55.90848,-1.37176),(-1.07046,55.82726,-1.30633),(-1.0636,55.89363,-1.37181),(-.55178,56.02781,-1.25962),(-.48425,55.99587,-1.20261),(-.57778,55.89226,-1.60742),(-.47295,55.91718,-1.36086),(-.54096,55.98379,-1.45114),(-.53852,56.34273,-1.03219),(-.41571,56.28924,-.97892),(-.78257,56.24068,-1.34558),(-.77658,56.23953,-1.3457),(-.78236,56.18691,-1.39967),(-.8003,56.18177,-1.49521),(-.79995,56.17764,-1.58509),(-.80471,56.18102,-1.49495),(-1.00879,55.68141,-1.47045),(-1.09299,55.69012,-1.39809),(-.88264,55.88331,-1.53397),(-.7799,55.98298,-.95164),(-1.04746,55.91772,-1.14988),(-.65934,55.91987,-1.67625),(-.8571,55.96376,-1.6626),(-.52668,56.25055,-1.07471),(-.47332,55.92614,-1.2315),(-.08707,56.12523,-.93773),(-.18562,55.79764,-.82141),(-.12905,55.75406,-.78301),(-.23506,55.78742,-.80473),(-.49013,55.70674,-1.65283),(-.58128,55.6144,-1.97295),(-.65811,56.0742,-1.71576),(-.29822,55.78899,-.84174),(-.27448,55.8642,-.86722),(-.26347,56.17497,-.91824),(-.78812,56.18626,-1.39915),(-.6594,56.09131,-1.33535),(-.66048,56.07515,-1.41956),(-.09693,55.75603,-2.13238),(0,55.72951,-2.12864),(0,55.65372,-2.19451),(0,55.52726,-1.91881),(0,55.48161,-1.93265),(-.54409,55.51332,-1.85029),(-1.0693,55.89458,-1.4453),(-1.05562,55.73632,-1.50575),(-.78966,55.81564,-1.69648),(-1.22476,55.91783,-1.45601),(-.80582,56.17799,-1.58595),(-.89443,56.14707,-1.18749),(-.76691,56.27716,-1.1481),(-.63424,56.35669,-1.09892),(-.46448,55.75047,-1.09964),(-.49592,55.71565,-.9804),(-.59903,55.61129,-1.37451),(-.472,55.73901,-1.02732),(-.39028,55.79198,-1.00695),(-.53919,55.63983,-1.44914),(-.94061,55.59868,-1.17299),(-.91568,55.60708,-1.08833),(-1.05259,55.75722,-1.17406),(-1.045,55.77664,-1.21072),(-1.2512,55.84493,-1.46788),(-1.14871,55.82152,-1.12853),(-1.14567,55.88319,-1.50746),(-1.17323,55.86241,-1.49985),(-1.25246,55.85359,-1.47135),(-1.39041,55.78316,-1.22971),(-.34203,55.7913,-.79718),(-.35502,55.83837,-.7591),(-.45288,55.81151,-.82311),(-.66143,55.87566,-.91846),(-.64912,56.04163,-.91003),(-.64994,55.96298,-.91485),(-.46301,56.22049,-.90826),(-.28073,56.16775,-.85901),(-.36098,55.91591,-.94303),(-.36488,55.92082,-.99799),(-.37901,55.82806,-1.19167),(-.34503,55.84444,-.909),(-.37026,55.84602,-.95989),(-.53378,55.77236,-1.50028),(.37879,55.77099,-1.18178),(.65677,55.67412,-.90714),(.39907,55.79679,-.9481),(.37568,55.80077,-1.00931),(.40788,55.7903,-.94437),(.93679,55.7057,-1.29266),(.5901,55.61036,-1.4768),(.52962,55.80836,-1.60481),(.93154,55.73071,-1.41662),(.98709,55.72245,-1.43216),(1.22476,55.91783,-1.45601),(1.23072,55.91099,-1.46074),(.94617,55.8377,-1.58789),(.87974,55.82526,-1.64319),(.54802,55.69062,-1.97822),(.68167,55.67555,-1.88951),(1.08274,55.76148,-1.24235),(1.045,55.77664,-1.21072),(.97744,55.76211,-1.20742),(.9812,55.76511,-1.20338),(1.24307,55.68755,-1.29079),(1.24006,55.70953,-1.33166),(1.23303,55.69178,-1.24278),(1.29982,55.6912,-1.29976),(1.2996,55.69309,-1.3055),(1.37545,55.84506,-1.3436),(1.30985,55.69277,-1.29781),(1.39041,55.78316,-1.22971),(1.383,55.83975,-1.33372),(.8571,55.96376,-1.6626),(1.00772,55.85847,-1.51572),(1.07278,55.91595,-1.37394),(1.0658,55.90848,-1.37176),(1.0096,55.96665,-1.33799),(1.03521,55.77786,-1.43386),(.41571,56.28924,-.97892),(.50329,55.90792,-1.48851),(.48179,55.83016,-1.43975),(.80471,56.18102,-1.49495),(.80582,56.17799,-1.58595),(.8003,56.18177,-1.49521),(1.0636,55.89363,-1.37181),(1.00948,55.9241,-1.31665),(.89089,55.83109,-1.50294),(.96714,55.96978,-1.0861),(.53852,56.34273,-1.03219),(.34408,56.15676,-.99383),(.17577,56.10647,-.92516),(.18355,56.09862,-.93016),(.50944,56.11206,-1.1231),(.58879,56.16625,-1.17691),(.55027,56.09636,-1.19194),(.49305,56.04208,-1.18579),(.49013,55.70674,-1.65283),(.58309,55.54246,-1.92331),(.51249,55.72644,-1.444),(.68215,56.0143,-1.76013),(.65811,56.0742,-1.71576),(.29822,55.78899,-.84174),(.27448,55.8642,-.86722),(.10817,55.85844,-.82269),(.10082,55.94762,-.8595),(.21716,55.94392,-.89004),(.78812,56.18626,-1.39915),(.63558,56.05618,-1.63297),(.47477,55.60918,-1.72823),(.30026,55.68048,-1.90729),(.09693,55.75603,-2.13238),(.11264,55.66782,-2.19013),(.24032,55.53798,-2.13951),(0,55.43722,-1.98567),(1.17275,55.9393,-1.40699),(1.0693,55.89458,-1.4453),(1.05259,55.75722,-1.17406),(1.05562,55.73632,-1.50575),(.93444,55.73949,-1.57024),(.6972,56.31437,-1.19003),(.63424,56.35669,-1.09892),(.85096,55.61809,-.99249),(.77896,55.68201,-.93652),(.72686,55.60842,-.9908),(.46448,55.75047,-1.09964),(.5519,55.64688,-1.36205),(.59903,55.61129,-1.37451),(.472,55.73901,-1.02732),(.53919,55.63983,-1.44914),(.87252,55.45028,-1.33983),(.90473,55.44676,-1.2643),(.82771,55.48836,-1.23512),(.36835,55.79288,-.88548),(.91568,55.60708,-1.08833),(.91144,55.55369,-1.07984),(.94061,55.59868,-1.17299),(1.2512,55.84493,-1.46788),(.45288,55.81151,-.82311),(.35502,55.83837,-.7591),(.66143,55.87566,-.91846),(0,56.04077,-.58744),(0,55.968,-.56094),(.64994,55.96298,-.91485),(.7799,55.98298,-.95164),(1.15209,55.87172,-1.15176),(.17976,56.14235,-.79826),(1.04746,55.91772,-1.14988),(1.11516,55.9399,-1.23095),(.26347,56.17497,-.91824),(.89443,56.14707,-1.18749),(1.20854,55.90775,-1.26046),(.36488,55.92082,-.99799),(.38542,55.99434,-1.05262),(.36098,55.91591,-.94303),(.37058,55.8491,-1.12931),(.38439,55.88374,-1.15156),(.36406,55.8579,-1.03052),(.48605,55.93063,-1.28027),(.36042,55.90977,-1.07717),(.93096,56.05386,-1.1379),(.18693,56.10599,-.73954),(.66507,55.79208,-.90238),(1.31578,55.86681,-1.41382),(1.17334,55.85241,-1.49629),(1.09299,55.69012,-1.39809),(.79316,55.51216,-1.28444),(.49592,55.71565,-.9804),(.59769,55.63618,-1.2422),(.70715,56.24514,-1.03899),(.78966,55.81564,-1.69648),(.82034,55.769,-1.73302),(.70253,55.79767,-1.71585),(.96102,55.77274,-1.59514),(.78666,56.01413,-1.76971),(.72964,55.69282,-1.55213),(.84161,55.68891,-1.59851),(.82572,55.67569,-1.51774),(.1216,55.52428,-1.91073),(.78257,56.24068,-1.34558),(.12905,55.75406,-.78301),(.547,56.19824,-1.11339),(.12114,55.7547,-.78522),(.08707,56.12523,-.93773),(.48425,55.99587,-1.20261),(.52668,56.25055,-1.07471),(.88264,55.88331,-1.53397),(1.07731,55.7807,-1.2628),(.79995,56.17764,-1.58509),(1.07046,55.82726,-1.30633),(1.08967,55.7939,-1.39112),(1.34236,55.79495,-1.15962),(1.04152,55.78473,-1.22241),(.9213,55.6969,-1.47563),(.44754,55.51718,-1.99978),(.11372,55.50461,-2.21214),(.25968,55.74704,-2.00348),(-.93096,56.05386,-1.1379),(-.62611,56.19759,-.94529),(-1.23072,55.91099,-1.46074),(-1.29527,55.68712,-1.18724),(-1.20527,55.78957,-1.40299),(-1.10938,55.71537,-1.34336),(-.91144,55.55369,-1.07984),(-.85096,55.61809,-.99249),(-.59769,55.63618,-1.2422),(-.6972,56.31437,-1.19003),(-1.17275,55.9393,-1.40699),(-.70253,55.79767,-1.71585),(-.44379,55.70512,-2.0275),(-.96102,55.77274,-1.59514),(-.93444,55.73949,-1.57024),(-.93953,55.7201,-1.29441),(-.94134,55.84589,-1.58332),(-.82572,55.67569,-1.51774),(-.84161,55.68891,-1.59851),(-.16413,55.4533,-1.9755),(-.19588,55.67422,-2.16592),(-.19324,55.60605,-2.20475),(-.11264,55.66782,-2.19013),(-.12114,55.7547,-.78522),(-.63344,55.95135,-1.69024),(-.96714,55.96978,-1.0861),(-.89925,55.94922,-1.00993),(-1.00948,55.9241,-1.31665),(-1.07731,55.7807,-1.2628),(-.9812,55.76511,-1.20338),(-.94683,55.77041,-1.30219),(-.55022,55.68411,-1.9836),(-.51362,55.74191,-.907),(-.17925,55.75398,-2.12394),(-.88016,55.68161,-1.48207),(-.70887,55.6283,-1.521),(-.7021,55.59017,-1.50319),(-.44071,55.69957,-2.03621),(-.87395,55.58518,-1.44964),(-.96259,55.78199,-1.59719),(-.87166,55.72481,-1.62184),(-.87891,55.90504,-1.41179),(-.87686,55.97506,-1.46031),(-1.03288,55.81464,-1.24353),(-.91257,55.7831,-1.46157),(-.49368,56.0506,-1.18677),(-.36042,55.90977,-1.07717),(-.55374,55.98799,-1.37428),(-.39285,56.10674,-1.05641),(-1.06109,55.86632,-1.43571),(-.56135,55.81678,-1.68167),(-.57518,55.99298,-1.63073),(-.59344,56.01712,-1.59831),(-.20952,55.8588,-.85719),(-.20361,55.86295,-.86394),(-.21194,55.86278,-.86047),(-.20836,56.03424,-.92016),(-.46549,56.14015,-1.0804),(-.28865,55.62528,-1.85171),(-.12734,55.61746,-1.92519),(-.07124,55.75329,-2.04524),(-.7369,55.5793,-1.16942),(-.57107,55.65719,-1.18273),(-.75,55.53312,-1.32338),(-.83591,55.46755,-1.38644),(-.78571,55.49516,-1.42322),(-.911,55.70106,-1.53805),(-.75338,55.62169,-.9512),(-.42731,56.06951,-.82705),(-.34194,55.91864,-.76501),(.44625,55.72364,-1.73142),(.96259,55.78199,-1.59719),(.87166,55.72481,-1.62184),(.87891,55.90504,-1.41179),(1.02251,55.85052,-1.26886),(1.18278,55.92873,-1.30432),(.65674,56.07674,-1.70954),(.59111,56.08067,-1.26077),(.28865,55.62528,-1.85171),(.4699,55.52774,-1.79051),(.7369,55.5793,-1.16942),(.67256,55.57675,-1.3653),(.78571,55.49516,-1.42322),(.83591,55.46755,-1.38644),(.75,55.53312,-1.32338),(.911,55.70106,-1.53805),(1.00879,55.68141,-1.47045),(.64172,56.1313,-.92257),(.46301,56.22049,-.90826),(.27913,55.95052,-.89328),(.85955,56.10587,-1.07555),(.62611,56.19759,-.94529),(.54788,55.88007,-.8748),(1.25246,55.85359,-1.47135),(.79099,55.49711,-1.43042),(.86402,55.5136,-1.42393),(.84256,55.46896,-1.39232),(.81228,55.54067,-1.4577),(.94511,55.59831,-1.27763),(.83723,55.55357,-1.01361),(.81241,55.53039,-1.10244),(.89586,55.49819,-1.09453),(.78963,55.5628,-1.04097),(.589,55.60637,-1.46764),(.69435,55.54726,-1.4674),(.92363,55.46559,-1.17555),(.92991,55.48649,-1.26732),(.93424,55.49939,-1.17346),(.91253,55.44892,-1.26651),(.81971,56.25088,-1.23913),(1.03776,55.84728,-1.53765),(1.0687,55.82447,-1.52874),(.92453,55.93149,-1.31195),(.81612,55.6004,-1.48946),(.82173,55.66713,-1.50896),(.3377,55.61769,-2.10829),(.45986,55.61824,-2.04256),(.12734,55.61746,-1.92519),(.77658,56.23953,-1.3457),(.68342,56.1916,-1.26997),(.75542,56.28719,-1.27074),(.70003,56.16914,-1.31604),(.64389,56.24599,-1.18081),(.27991,56.03978,-.92936),(.22541,55.94551,-.88755),(.60288,56.03114,-1.49006),(.66048,56.07515,-1.41956),(.09225,56.11626,-.73459),(0,56.12448,-.94023),(0,56.13021,-.93924),(.55471,56.03552,-1.26197),(.89925,55.94922,-1.00993),(.78236,56.18691,-1.39967),(.69269,56.31297,-1.19218),(.6305,56.35554,-1.102),(.96018,55.76944,-1.47582),(1.17323,55.86241,-1.49985),(.58327,55.7738,-1.75437),(.11659,55.59129,-2.22177),(.74733,55.61604,-.95621),(.91598,55.46261,-1.17484),(.69839,55.5496,-1.47578),(-.74121,56.15706,-1.00766),(0,56.1118,-.7164),(-.09225,56.11626,-.73459),(-.76918,56.07612,-.97168),(-.85955,56.10587,-1.07555),(-.89603,56.01276,-1.02632),(-.54849,55.97382,-.87798),(-.45477,55.88927,-.83538),(-.54788,55.88007,-.8748),(-.12134,55.90625,-.58906),(-.86402,55.5136,-1.42393),(-.79099,55.49711,-1.43042),(-.84256,55.46896,-1.39232),(-.81228,55.54067,-1.4577),(-.94511,55.59831,-1.27763),(-.81241,55.53039,-1.10244),(-.83723,55.55357,-1.01361),(-.89586,55.49819,-1.09453),(-.78963,55.5628,-1.04097),(-.589,55.60637,-1.46764),(-.69435,55.54726,-1.4674),(-.92991,55.48649,-1.26732),(-.92363,55.46559,-1.17555),(-.93424,55.49939,-1.17346),(-.91253,55.44892,-1.26651),(-.55836,55.69457,-.94402),(-.64531,55.65727,-.94804),(-.81971,56.25088,-1.23913),(-1.03776,55.84728,-1.53765),(-1.0687,55.82447,-1.52874),(-.92453,55.93149,-1.31195),(-.81612,55.6004,-1.48946),(-.82173,55.66713,-1.50896),(-.11659,55.59129,-2.22177),(0,55.57864,-2.23472),(-.58327,55.7738,-1.75437),(-.68342,56.1916,-1.26997),(-.75542,56.28719,-1.27074),(-.70003,56.16914,-1.31604),(-.58879,56.16625,-1.17691),(-.64389,56.24599,-1.18081),(-.63772,56.13023,-1.26238),(-.27991,56.03978,-.92936),(-.10082,55.94762,-.8595),(-.21716,55.94392,-.89004),(-.25393,55.80277,-.73699),(-.27913,55.95052,-.89328),(0,55.75697,-.7561),(-.21625,56.03577,-.918),(-.55471,56.03552,-1.26197),(-.55027,56.09636,-1.19194),(-.59111,56.08067,-1.26077),(-1.03521,55.77786,-1.43386),(-.69269,56.31297,-1.19218),(-.6305,56.35554,-1.102),(-.96018,55.76944,-1.47582),(-.89926,55.49586,-1.37091),(-.87981,55.45171,-1.34366),(0,55.73479,-2.11615),(-.84446,55.55823,-1.0099),(-.90336,55.50198,-1.09318),(-.87252,55.45028,-1.33983),(-.69839,55.5496,-1.47578),(-.90473,55.44676,-1.2643),(-.74733,55.61604,-.95621),(-.72731,56.14652,-1.71169),(-.7306,56.14609,-1.71771),(-.76038,56.28875,-1.26845),(-.17871,55.80003,-.82589),(-.22541,55.94551,-.88755),(0,56.0774,-.64636),(-.10817,55.85844,-.82269),(0,56.02528,-.88496),(0,55.94099,-.84156),(-.56502,56.25607,-1.109),(-.73216,56.1146,-1.45665),(-.70375,56.11846,-1.36258),(-.45986,55.61824,-2.04256),(0,55.49811,-2.23002),(0,55.7302,-2.044),(-.70584,55.60898,-1.09796),(-.79316,55.51216,-1.28444),(-.82593,55.50678,-1.16039),(-.82771,55.48836,-1.23512),(-.23669,55.88113,-.67906),(-.17976,56.14235,-.79826),(-.60288,56.03114,-1.49006),(.87981,55.45171,-1.34366),(.84446,55.55823,-1.0099),(.17871,55.80003,-.82589),(.21625,56.03577,-.918),(0,55.86764,-.8067),(.56502,56.25607,-1.109),(.73216,56.1146,-1.45665),(.46549,56.14015,-1.0804),(.7306,56.14609,-1.71771),(1.14567,55.88319,-1.50746),(.76038,56.28875,-1.26845),(.82593,55.50678,-1.16039),(.90336,55.50198,-1.09318),(.89926,55.49586,-1.37091),(.45477,55.88927,-.83538),(.54849,55.97382,-.87798),(.74121,56.15706,-1.00766),(.76918,56.07612,-.97168),(.89603,56.01276,-1.02632),(.55836,55.69457,-.94402),(.70584,55.60898,-1.09796),(0,55.44468,-2.15472),(.229,55.68238,-1.94837),(.72731,56.14652,-1.71169),(.70375,56.11846,-1.36258),(.78241,56.17966,-1.6608),(.78827,56.18033,-1.66427),(-.72686,55.60842,-.9908),(-.91598,55.46261,-1.17484),(-.78241,56.17966,-1.6608),(-.78827,56.18033,-1.66427)]),
          normal=Normal(vector=[(-.999,.0447,-.0004),(-.9974,.0531,-.0486),(-.992,-.0771,-.0995),(-.9911,-.132,.0195),(-.9903,-.036,-.1343),(-.9884,-.1436,-.0492),(-.9873,.1408,-.0729),(-.9864,.0794,-.1438),(-.9857,-.0359,.1645),(-.9845,-.0242,-.1738),(-.9826,.0848,-.1652),(-.9804,.0151,-.1963),(-.9799,.0439,-.1946),(-.9767,-.0958,-.1922),(-.9691,-.1793,.1696),(-.9688,.2466,-.0236),(-.9648,-.203,.1672),(-.9639,-.2635,.0379),(-.9626,-.1976,-.1852),(-.961,.0503,.2721),(-.9597,.0312,-.2794),(-.9553,-.2202,-.197),(-.9544,-.1549,-.2551),(-.9476,.2148,-.2365),(-.9459,.2909,-.144),(-.945,-.2904,-.1502),(-.9423,-.1837,-.2799),(-.9362,.2743,-.2197),(-.9269,.1749,-.3321),(-.9266,.0181,-.3757),(-.9237,-.3405,-.1757),(-.9235,-.3641,-.1204),(-.9232,-.1556,-.3513),(-.9203,.2564,-.2955),(-.9148,.3303,-.2324),(-.9121,.0538,-.4064),(-.9098,.1254,.3956),(-.9083,-.1159,-.402),(-.901,.3459,-.262),(-.8997,-.4348,.0383),(-.8967,.0736,.4364),(-.8965,.4352,-.0835),(-.8954,.0206,.4447),(-.8951,.4149,.1634),(-.89,.3802,-.2516),(-.8896,.1814,-.4192),(-.8829,-.4371,-.1713),(-.8815,.0432,-.4703),(-.8783,.034,.477),(-.8764,.081,-.4747),(-.8758,-.1348,-.4636),(-.8715,-.3109,-.3794),(-.871,-.1967,-.4502),(-.8702,-.4399,-.222),(-.8653,.4387,-.2426),(-.8615,.4812,.1617),(-.8577,.5004,.1181),(-.8577,-.1266,-.4983),(-.8557,.0484,-.5152),(-.8553,-.2445,.4568),(-.855,-.0894,-.5109),(-.8547,.4356,-.2825),(-.854,-.1464,.4993),(-.8533,-.2417,.4621),(-.853,-.1447,-.5015),(-.8528,.2605,-.4526),(-.8522,.4756,-.2183),(-.85,-.5047,.151),(-.8462,.5329,.0011),(-.845,.4844,-.2264),(-.8413,.5158,-.1618),(-.8397,.5302,.117),(-.8396,.5188,-.161),(-.8385,.4664,-.2817),(-.8378,.1984,-.5086),(-.8327,-.5513,.0514),(-.8326,-.3338,-.442),(-.8218,.43,.374),(-.8212,-.4691,-.3249),(-.8205,-.5712,.0215),(-.8202,-.5718,-.0158),(-.82,-.5658,.0858),(-.8199,.4808,.3109),(-.8175,-.0549,-.5733),(-.8159,-.083,-.5723),(-.8155,-.389,-.4286),(-.811,.013,-.5849),(-.8084,.4263,-.4058),(-.8001,.5696,.1883),(-.7926,.6096,-.0083),(-.7861,-.5588,-.2644),(-.784,-.0381,.6196),(-.7831,.0139,.6218),(-.7819,-.1108,-.6135),(-.7791,.1164,-.616),(-.7761,.5082,-.3734),(-.7734,-.6012,.201),(-.7721,-.4974,-.3955),(-.772,.624,-.1211),(-.7717,.4915,-.4036),(-.7709,.5951,.2272),(-.7684,.1632,-.6188),(-.7678,.5933,.2416),(-.767,.6046,-.2148),(-.767,-.4316,-.4748),(-.7663,-.122,-.6308),(-.7637,.4381,-.4742),(-.7619,.6195,.189),(-.761,.1207,-.6374),(-.76,.6498,-.0129),(-.7591,.0703,-.6471),(-.7575,-.2653,-.5965),(-.7571,.6358,-.1503),(-.7511,-.0042,-.6602),(-.7491,.6541,-.105),(-.7489,-.2757,-.6026),(-.7426,.6186,.2565),(-.7409,.1969,-.6421),(-.7385,-.4919,-.4612),(-.7353,-.5143,-.4414),(-.7332,.1568,-.6617),(-.7313,-.4389,-.522),(-.731,.6822,-.0146),(-.7306,.1694,-.6614),(-.73,.5055,-.46),(-.7293,.5341,.4276),(-.7291,.3879,-.5638),(-.7218,-.653,.2294),(-.7215,.3068,-.6207),(-.7213,.6641,-.1968),(-.721,.2749,-.636),(-.7181,.4164,.5576),(-.7136,.3383,-.6134),(-.711,-.4989,.4956),(-.7086,-.5631,-.4251),(-.7078,.7062,.0181),(-.7,.4817,-.5273),(-.6989,-.5709,.4308),(-.6971,.7127,-.078),(-.6916,.5388,-.481),(-.6915,-.7105,-.1308),(-.6903,-.6395,-.3385),(-.6898,-.0642,-.7211),(-.6897,.5676,.4496),(-.6879,.4831,-.5417),(-.6875,-.7194,-.0995),(-.6851,-.4925,.5367),(-.6837,.7297,-.0085),(-.6821,.6428,-.3487),(-.6813,-.4558,-.5728),(-.6812,.3104,-.663),(-.6799,.6479,.3436),(-.6793,.7305,-.0709),(-.6776,.2636,.6865),(-.6775,.3343,-.6552),(-.6749,.3248,-.6626),(-.6748,-.2096,.7076),(-.6721,.4319,-.6015),(-.6721,.7402,-.02),(-.6715,.514,.5337),(-.6713,.7316,-.1188),(-.6711,.57,-.4739),(-.6709,.0919,-.7358),(-.6687,.4928,-.5567),(-.6648,.6498,-.3685),(-.6644,-.725,.1818),(-.6615,-.5185,-.5418),(-.6602,.5267,-.5355),(-.6591,.1027,-.7451),(-.6565,-.1005,.7476),(-.6557,-.3871,-.6482),(-.6527,.7498,-.1086),(-.6519,.666,-.3625),(-.6511,-.2412,-.7196),(-.6485,.4774,-.5928),(-.6465,.648,-.4026),(-.644,.197,-.7393),(-.643,-.7145,-.2759),(-.6427,.4174,-.6424),(-.6414,-.2936,-.7088),(-.6407,.5578,-.5276),(-.6387,.0864,.7646),(-.6371,-.7636,-.105),(-.637,-.7583,-.1384),(-.6359,-.2017,.7449),(-.6327,.3937,.6669),(-.6315,.3634,-.685),(-.6284,.1554,.7622),(-.6283,-.6837,.3711),(-.6282,-.5512,.5491),(-.6271,.5491,-.5525),(-.627,-.4591,-.6293),(-.6214,-.7834,-.0087),(-.6201,.7792,-.0915),(-.6179,.7807,.0927),(-.6152,.6032,-.5076),(-.6127,-.7893,-.04),(-.6113,-.7206,-.3272),(-.611,.4658,.6401),(-.6056,.7136,-.3523),(-.605,.7962,-.0029),(-.6039,-.7854,.1359),(-.6031,.1621,.7811),(-.6016,.7666,.2245),(-.6011,-.5218,-.6053),(-.601,-.7872,.138),(-.6003,-.0379,-.7989),(-.5915,.2889,-.7527),(-.5909,.3029,.7477),(-.5904,.4183,-.6903),(-.5904,.8007,-.1014),(-.5902,.8054,.0538),(-.5847,-.8044,.1052),(-.5818,-.8067,-.1038),(-.5817,.7641,-.279),(-.5816,.3569,.731),(-.5813,.7997,-.1502),(-.5801,-.3578,-.7318),(-.5781,-.1844,.7949),(-.5772,.1572,.8013),(-.5766,.0948,.8115),(-.5716,.2402,.7846),(-.5713,.5206,-.6345),(-.5704,-.5355,-.6228),(-.5703,.593,-.5684),(-.5696,-.7138,.4076),(-.5692,-.8204,-.0554),(-.568,.4298,.7019),(-.5666,-.8016,.1909),(-.5656,.0148,-.8245),(-.5652,.8249,.0126),(-.5647,-.7887,.2428),(-.5643,-.8019,.196),(-.5603,-.8147,.1495),(-.5586,.8272,.0612),(-.5571,-.2156,-.8019),(-.5564,.4711,.6845),(-.5561,-.1643,-.8147),(-.5556,.2031,.8063),(-.5552,.0107,-.8316),(-.5546,-.7926,.2534),(-.5525,-.3136,.7723),(-.5485,.7836,-.2917),(-.548,-.8212,.1591),(-.5479,-.6962,-.4638),(-.5458,.8239,.1528),(-.5446,-.2676,-.7948),(-.5406,.1635,.8253),(-.5392,-.3793,-.7519),(-.5373,-.8298,.1509),(-.5363,-.8286,-.1606),(-.536,-.2755,-.798),(-.5348,-.5488,-.6425),(-.5298,-.6151,-.5839),(-.5277,-.0288,.849),(-.5275,.5895,.6117),(-.526,-.0482,-.8491),(-.5239,.3703,-.7671),(-.5234,.3769,.7642),(-.5234,-.8455,.1059),(-.5221,-.8504,.0655),(-.522,-.4918,.6969),(-.5214,.6135,.593),(-.5194,.7956,-.3118),(-.5173,-.8146,.2624),(-.5159,-.8491,.1136),(-.5125,.4358,-.7399),(-.5113,-.8338,.2083),(-.5109,.6705,-.5379),(-.5108,-.5079,-.6936),(-.5088,-.8519,.1242),(-.5078,-.85,.1402),(-.5074,-.649,-.5668),(-.5041,-.4859,-.714),(-.5009,-.8312,.2414),(-.4993,-.5944,-.6304),(-.4977,.3991,-.7701),(-.4953,.8642,.0892),(-.4949,.3707,.7859),(-.494,-.0978,-.864),(-.4912,-.2656,.8296),(-.4888,-.5018,-.7136),(-.4885,-.8557,.1708),(-.4839,.7874,-.3819),(-.4826,-.7265,-.4892),(-.4815,-.8714,.0942),(-.4811,-.1275,-.8673),(-.4796,-.868,.1282),(-.4788,-.8765,.0492),(-.4768,-.6618,-.5785),(-.4752,-.8764,.0776),(-.4723,.7772,-.4158),(-.4714,.0809,.8782),(-.4652,.8376,.2865),(-.4644,.6415,.6105),(-.4642,-.3286,-.8225),(-.464,.5126,-.7225),(-.4631,-.4558,-.7601),(-.461,.8139,-.3536),(-.4608,-.2197,-.8599),(-.4571,.8012,-.3862),(-.455,.8176,.353),(-.4549,-.8725,-.1784),(-.4545,-.7666,.4536),(-.4545,-.8535,.255),(-.4542,.4667,-.7589),(-.4538,-.5981,-.6606),(-.4514,-.476,-.7548),(-.451,.3945,.8006),(-.4481,-.4805,-.7538),(-.4476,-.8757,.1812),(-.4464,-.1089,.8882),(-.4426,-.8432,-.3052),(-.4404,.046,.8966),(-.4398,-.5871,-.6796),(-.4396,.4608,-.771),(-.4299,.0222,.9026),(-.4299,.8342,.3454),(-.4287,-.7248,-.5394),(-.4281,.5554,-.7129),(-.4251,.4813,-.7666),(-.4229,.8976,-.1244),(-.4225,.8817,-.2098),(-.4216,.3108,.8519),(-.4202,.0565,-.9057),(-.4201,.6899,-.5895),(-.4192,-.8978,.135),(-.4188,-.873,.2498),(-.418,-.5854,-.6947),(-.4162,.4395,.796),(-.416,.5423,-.73),(-.4157,-.8321,-.3671),(-.4059,.6777,-.6132),(-.4051,.2869,.8681),(-.403,-.1587,-.9013),(-.4024,-.9002,-.1664),(-.4021,-.8427,.358),(-.402,.5177,-.7552),(-.3988,-.037,-.9163),(-.3986,-.2024,-.8945),(-.3982,-.4141,.8185),(-.3952,-.7899,-.4688),(-.3927,.5448,-.741),(-.3925,.9032,.1737),(-.3873,.144,-.9106),(-.3871,.0964,.917),(-.3866,-.8665,.3157),(-.3865,-.108,-.916),(-.3857,.3968,.8329),(-.3853,-.6817,-.6219),(-.3842,-.918,.098),(-.3837,-.2169,.8976),(-.3833,-.922,.0551),(-.3807,-.5132,.7692),(-.3807,-.7431,-.5503),(-.3781,.8154,-.4383),(-.3779,.7478,-.5459),(-.3779,-.9059,.1911),(-.3743,-.5532,-.7442),(-.3725,.0615,.926),(-.3709,-.035,.928),(-.3698,.1044,.9232),(-.3684,-.348,.8621),(-.3672,.7415,.5615),(-.3666,-.9157,-.1645),(-.3658,-.5954,-.7153),(-.364,-.8952,.2572),(-.3637,.9314,-.0146),(-.3635,.1353,.9217),(-.3624,.9195,.1523),(-.3621,-.3857,.8486),(-.3619,-.3116,.8786),(-.355,.8833,.3061),(-.3541,-.9127,.2041),(-.354,.4001,-.8453),(-.352,.007,.936),(-.3508,-.3844,-.8539),(-.3506,-.8859,.3037),(-.3486,.7591,-.5497),(-.3473,-.2794,-.8952),(-.3461,.9372,.0432),(-.3448,.1269,.9301),(-.3447,.6146,.7095),(-.3438,-.7461,.5702),(-.3399,.809,-.4795),(-.3378,-.2919,-.8948),(-.3371,.2048,.9189),(-.3371,-.6353,.6948),(-.3368,.9387,.074),(-.336,-.9308,-.1436),(-.3357,.7702,-.5423),(-.3342,.8166,-.4705),(-.3333,.0135,.9427),(-.3332,.1295,.9339),(-.3318,-.0866,-.9394),(-.3312,-.8865,-.3231),(-.3311,-.5432,-.7716),(-.3298,-.439,-.8358),(-.3277,-.369,-.8697),(-.3275,.1023,.9393),(-.3266,.8629,-.3857),(-.3262,-.0204,.9451),(-.3242,.8794,-.3486),(-.324,-.8755,-.3584),(-.323,-.8778,-.3539),(-.3209,-.726,-.6083),(-.318,-.0254,.9477),(-.317,-.9137,.2545),(-.3146,.4478,-.837),(-.3092,.6447,.6991),(-.3068,-.5007,-.8094),(-.304,.5989,.7409),(-.3004,.6478,.7001),(-.2996,.4195,-.8569),(-.2916,.956,-.0307),(-.29,.9155,-.279),(-.2883,-.7739,.5639),(-.2882,-.8139,.5045),(-.2858,-.3034,-.909),(-.2818,.9579,-.0544),(-.2801,-.7041,.6525),(-.2733,-.5119,.8144),(-.2725,-.9533,.1301),(-.2693,-.9144,.3022),(-.2683,-.8722,-.409),(-.268,.9223,-.2786),(-.2652,-.777,-.571),(-.2642,.4163,.87),(-.2615,.7762,-.5737),(-.2575,-.5243,.8117),(-.2564,-.9078,.3319),(-.2522,-.3682,-.8949),(-.2466,-.9616,.1206),(-.2455,.7761,.5809),(-.2417,-.9704,.0011),(-.2407,.5011,-.8312),(-.2354,.9175,-.3206),(-.2352,-.9257,-.2963),(-.235,-.6771,-.6974),(-.2349,.9206,-.3119),(-.2308,-.5021,-.8334),(-.2289,.967,.1115),(-.2281,.681,.6959),(-.2231,.6033,.7657),(-.2189,-.4944,-.8412),(-.2185,.7045,-.6752),(-.218,.8168,.5341),(-.2177,.3589,-.9076),(-.2159,-.731,.6473),(-.2157,-.9737,-.0737),(-.2152,-.1844,.959),(-.2136,.8763,.4318),(-.2112,.877,-.4316),(-.2106,-.9578,-.1955),(-.2102,-.7472,.6305),(-.2065,-.0852,.9747),(-.2046,-.7141,-.6695),(-.2022,.9519,-.2302),(-.1969,-.1101,-.9742),(-.1961,.2401,.9507),(-.1944,-.8903,-.4117),(-.1861,.9369,-.2958),(-.1843,-.6152,.7665),(-.1843,.0204,.9827),(-.1773,-.4065,-.8963),(-.177,-.392,-.9028),(-.1759,-.9842,.0212),(-.1753,-.6871,.7051),(-.1738,.5361,.8261),(-.1729,-.7884,.5903),(-.1706,.7172,.6757),(-.1699,-.6252,-.7618),(-.1698,.425,.8891),(-.1676,-.5132,.8418),(-.1672,-.6574,-.7348),(-.1672,.9205,-.3531),(-.1655,-.9058,-.3901),(-.1645,-.8212,-.5464),(-.1616,.6295,.76),(-.1606,.9848,.0654),(-.1594,.9868,-.0267),(-.1482,-.9003,.4093),(-.1475,-.7236,.6743),(-.1434,-.8098,.5689),(-.1427,-.9762,.1631),(-.1423,.5466,-.8252),(-.1418,.9609,-.2377),(-.1409,.1347,-.9808),(-.1396,.6915,-.7088),(-.1393,-.8057,-.5757),(-.1389,.9568,-.2554),(-.1377,-.9875,-.0762),(-.134,.963,-.2337),(-.1334,.6748,-.7259),(-.1288,.7599,-.6372),(-.126,.9393,.3191),(-.1251,.5753,.8083),(-.123,.8507,.511),(-.1213,-.79,-.6009),(-.1207,-.4339,-.8928),(-.1191,.7148,-.6891),(-.1188,-.8189,.5615),(-.1132,-.9846,.133),(-.112,-.3112,-.9437),(-.1074,-.991,-.0801),(-.1051,.9592,-.2626),(-.1048,.7365,.6683),(-.1047,-.5173,-.8494),(-.1038,.9788,-.1767),(-.0963,.9893,-.1098),(-.0938,.9577,-.272),(-.0885,-.9566,-.2778),(-.0861,.9959,.0286),(-.0826,.9132,-.399),(-.0818,-.8974,-.4336),(-.0808,.7187,-.6906),(-.0779,-.9446,-.3189),(-.0771,-.9958,-.0494),(-.0762,.5362,-.8407),(-.0732,.4724,-.8783),(-.0717,.1021,-.9922),(-.0703,-.7294,.6805),(-.0695,-.2308,-.9705),(-.069,-.9971,.0327),(-.0665,.8065,-.5875),(-.0656,.9527,.2967),(-.0642,-.3161,-.9465),(-.0622,-.9897,-.1291),(-.0614,-.4003,.9143),(-.0605,-.497,-.8656),(-.0587,.3717,-.9265),(-.0576,.749,-.66),(-.0565,-.238,-.9696),(-.0539,-.9561,.288),(-.0524,.9345,.352),(-.0509,-.9952,.0836),(-.0487,-.298,.9533),(-.0456,.6683,.7425),(-.0449,.9702,-.2379),(-.0445,-.1001,-.994),(-.044,-.9985,-.0321),(-.044,.9242,.3793),(-.0427,-.7034,-.7095),(-.0388,-.4484,-.893),(-.0386,.9274,.3721),(-.0365,-.7661,-.6417),(-.0337,.916,.3998),(-.0334,.992,-.1219),(-.0321,-.9837,.1767),(-.031,-.7522,.6582),(-.0297,.994,.1051),(-.0282,.8176,-.5751),(-.0266,-.956,.2921),(-.0244,-.9946,.1004),(-.023,-.996,-.0859),(-.0221,-.3348,.942),(-.02,-.7477,.6638),(-.02,-.3897,-.9207),(-.0195,-.7407,.6716),(-.0192,-.5682,-.8226),(-.018,-.597,.802),(-.0174,-.831,.556),(-.0156,.0228,-.9996),(-.0146,.9858,.167),(-.0145,-.0025,.9999),(-.0135,.6676,.7444),(-.0123,.6146,.7887),(-.0119,-.8815,.472),(-.0116,.3938,.9191),(-.0111,.4055,-.914),(-.0057,.9361,.3517),(-.0047,-.9959,.0903),(-.0042,-.7606,.6493),(-.001,-.7161,.698),(0,.1282,.9917),(0,.6327,.7744),(0,.8652,.5014),(0,.8916,.4529),(0,.9304,.3666),(0,-.9551,.2963),(0,.9833,-.1822),(0,-.9466,-.3225),(0,-.8535,-.5211),(0,.7984,-.6022),(0,.663,-.7486),(0,.5135,-.8581),(0,-.4788,-.8779),(0,-.4658,-.8849),(0,-.4423,-.8969),(0,-.414,-.9103),(0,.1819,-.9833),(0,-.134,-.991),(.0019,-.7581,.6521),(.002,-.7799,.6259),(.0047,-.9959,.0903),(.0054,-.9911,-.1328),(.0057,.9361,.3517),(.0111,.4055,-.914),(.0119,-.8815,.472),(.0123,-.4263,-.9045),(.0135,.6676,.7444),(.0156,.0228,-.9996),(.0174,-.831,.556),(.0182,.818,-.5749),(.0192,-.5682,-.8226),(.02,-.3897,-.9207),(.0244,-.9946,.1004),(.026,-.9674,.2519),(.0266,-.956,.2921),(.027,-.9684,.2478),(.0362,.9275,.372),(.0365,-.7661,-.6417),(.0427,-.7034,-.7095),(.044,.9242,.3793),(.0445,-.0743,-.9962),(.0456,.6683,.7425),(.0501,.9184,.3924),(.0504,-.3288,-.9431),(.0509,-.9952,.0836),(.0524,.9345,.352),(.0565,-.238,-.9696),(.0576,.749,-.66),(.0587,.3717,-.9265),(.0605,-.497,-.8656),(.0609,-.9979,-.0239),(.0622,-.9897,-.1291),(.0656,.9527,.2967),(.0662,-.7829,.6186),(.0665,.8065,-.5875),(.069,.9611,-.2673),(.069,-.9971,.0327),(.0705,.9944,.0789),(.0732,.4724,-.8783),(.0762,.5362,-.8407),(.0771,-.9958,-.0494),(.0779,-.9446,-.3189),(.0812,-.2878,.9542),(.0826,.9132,-.399),(.0845,-.3507,.9327),(.085,-.956,-.2808),(.0861,.9959,.0286),(.0931,-.2459,-.9648),(.0938,.9577,-.272),(.0946,.754,.6501),(.0963,.9893,-.1098),(.0993,-.9831,.1536),(.0997,-.4134,-.9051),(.1012,-.9701,.2207),(.1045,.7947,-.5979),(.1047,-.5174,-.8493),(.1051,.9592,-.2626),(.1063,.704,-.7022),(.1069,-.9033,-.4154),(.1074,-.991,-.0801),(.112,-.3112,-.9437),(.1188,-.8189,.5615),(.1213,-.79,-.6009),(.1251,.5753,.8083),(.1257,.1639,-.9784),(.126,.9393,.3191),(.1288,.7599,-.6372),(.134,.963,-.2337),(.1358,-.8257,.5475),(.137,-.1067,.9848),(.1377,-.9875,-.0762),(.1389,.9568,-.2554),(.1396,.6915,-.7088),(.1398,-.7462,.6508),(.1409,.1347,-.9808),(.1418,.9609,-.2377),(.1423,.5466,-.8252),(.1432,.6702,-.7283),(.1443,-.9776,.1535),(.1463,.9869,.0687),(.1546,.5281,.835),(.1594,.9868,-.0267),(.161,-.4967,.8529),(.1645,-.8212,-.5464),(.1652,.9602,-.2252),(.1655,-.9058,-.3901),(.1672,.9205,-.3531),(.1672,-.6574,-.7348),(.17,-.6252,-.7617),(.1706,.7172,.6757),(.1729,-.7884,.5903),(.1737,.6204,.7648),(.1738,.8327,.5258),(.1759,-.9842,.0212),(.1766,-.7428,-.6458),(.177,-.392,-.9028),(.1777,-.937,.3009),(.1828,.9381,-.2943),(.1832,-.7594,.6243),(.1843,.4343,.8817),(.1843,-.6152,.7665),(.1863,-.8961,.4028),(.1893,-.6781,.7102),(.1898,-.9776,.0914),(.1938,-.3928,-.899),(.1956,.0126,.9806),(.1961,.2401,.9507),(.1969,-.1101,-.9742),(.2022,.9519,-.2302),(.2046,-.7141,-.6695),(.2106,-.9578,-.1955),(.2112,.877,-.4316),(.2136,.8763,.4318),(.2153,.7036,-.6772),(.2157,-.9737,-.0737),(.2159,-.731,.6473),(.218,.8168,.5341),(.2189,-.4944,-.8412),(.2249,.3579,-.9063),(.2289,.967,.1115),(.2308,-.5021,-.8334),(.2349,.9206,-.3119),(.2352,-.9257,-.2963),(.2354,.9175,-.3206),(.2378,.7985,-.553),(.2381,.7666,.5964),(.2399,-.2272,.9438),(.2466,-.9616,.1206),(.2534,-.8564,-.4498),(.2543,.5175,-.817),(.2551,.6757,.6917),(.2571,-.0406,.9655),(.2608,.6041,.753),(.2647,-.3812,-.8858),(.2652,-.777,-.571),(.2658,.9177,-.2951),(.2662,-.9634,.0331),(.2674,-.6646,-.6977),(.27,-.5384,.7982),(.2705,-.7252,.6332),(.2725,-.9533,.1301),(.2733,-.5119,.8144),(.2775,.4048,.8713),(.2792,.9584,-.0587),(.2848,-.858,-.4274),(.2858,-.3034,-.909),(.2882,-.9072,.3065),(.2883,-.7739,.5639),(.29,.9155,-.279),(.2907,.6366,.7143),(.2996,.4195,-.8569),(.304,.5989,.7409),(.3044,.6584,.6883),(.3068,-.5007,-.8094),(.3128,-.7315,-.6059),(.3146,.4478,-.837),(.3164,-.4494,-.8354),(.317,-.9137,.2545),(.318,-.0254,.9477),(.3185,.9452,.0723),(.3195,.6405,.6983),(.323,-.8778,-.3539),(.3234,.2142,.9217),(.3234,.864,-.3859),(.3262,-.0204,.9451),(.3277,-.369,-.8697),(.3281,.8133,-.4804),(.3286,.8801,-.3428),(.3303,-.7934,.5113),(.3311,-.5432,-.7716),(.3316,-.3961,.8563),(.3357,.7702,-.5423),(.3358,-.7223,-.6045),(.336,-.9308,-.1436),(.3374,-.9187,.2056),(.3378,-.2919,-.8948),(.3398,-.3933,-.8543),(.3399,.809,-.4795),(.3422,-.8596,-.3795),(.3438,-.7461,.5702),(.3439,.9379,.0464),(.3442,.9385,.0283),(.3464,-.6109,-.7119),(.3468,.0853,.934),(.3473,-.2794,-.8952),(.3486,.7591,-.5497),(.3506,.0062,.9365),(.354,-.8911,-.2838),(.354,.4001,-.8453),(.355,.8833,.3061),(.3568,.0793,.9308),(.357,-.0342,-.9335),(.3591,.0994,.928),(.3597,-.3308,.8725),(.3619,-.3116,.8786),(.3624,.9195,.1523),(.3637,.9314,-.0146),(.3639,.4153,.8337),(.3644,-.9208,.1388),(.3648,-.9012,.2342),(.3658,-.886,.285),(.3666,-.9157,-.1645),(.3698,.1044,.9232),(.3709,-.035,.928),(.373,.1517,.9154),(.3756,.7502,-.5441),(.3771,-.5698,-.7302),(.3779,-.9059,.1911),(.3781,.1501,.9135),(.3781,.8154,-.4383),(.3807,-.7431,-.5503),(.3807,-.5132,.7692),(.3812,-.6349,.672),(.3866,-.8665,.3157),(.3873,.144,-.9106),(.3904,.2765,.8782),(.3929,.0905,.9151),(.3936,.899,.1921),(.3937,.2885,.8728),(.3938,.7243,.566),(.3952,-.7899,-.4688),(.3962,.5452,-.7388),(.398,-.5695,-.7192),(.3982,-.4141,.8185),(.3986,-.2024,-.8945),(.3987,-.8551,.3315),(.3988,-.037,-.9163),(.4024,-.9002,-.1664),(.403,-.1587,-.9013),(.4041,.5161,-.7552),(.4055,-.905,.1287),(.4059,.6777,-.6132),(.4061,-.186,.8947),(.4062,-.9056,.1219),(.4074,-.1282,-.9042),(.4157,-.8321,-.3671),(.4162,.4395,.796),(.4173,.5455,-.7268),(.4188,-.873,.2498),(.4201,.6899,-.5895),(.4222,.8871,-.1865),(.4229,.8976,-.1244),(.4251,.4813,-.7666),(.4255,.5504,-.7183),(.4286,.0391,-.9026),(.4299,.8342,.3454),(.4299,.0222,.9026),(.4332,.8304,-.3503),(.4382,-.7186,-.54),(.4392,-.0991,.8929),(.4396,.4608,-.771),(.4398,-.5871,-.6796),(.4414,.0377,.8965),(.4426,-.8432,-.3052),(.4473,-.3333,-.83),(.4481,-.4805,-.7538),(.4499,-.8923,-.0366),(.4514,-.476,-.7548),(.4538,-.5981,-.6606),(.4542,.4667,-.7589),(.4545,-.8535,.255),(.4545,-.7666,.4536),(.4549,-.8725,-.1784),(.455,.8176,.353),(.4631,-.4558,-.7601),(.4644,.6415,.6105),(.4649,.7998,-.3797),(.4651,.5071,-.7256),(.4652,.8376,.2865),(.4692,.4209,.7764),(.4714,-.8801,.0566),(.4714,.0809,.8782),(.4723,.7772,-.4158),(.4747,-.3083,.8244),(.4764,-.8773,.0571),(.4767,.8022,-.3595),(.4768,-.6618,-.5785),(.4796,-.868,.1282),(.4811,-.1275,-.8673),(.4813,-.8671,.1287),(.4826,-.7265,-.4892),(.4829,.4023,.7778),(.4845,.456,-.7465),(.4885,-.8557,.1708),(.4888,-.5018,-.7136),(.489,-.5654,-.6643),(.4949,.3707,.7859),(.4953,.8642,.0892),(.4957,.3979,-.7719),(.4988,-.8486,.1762),(.5009,-.8312,.2414),(.5041,-.4859,-.714),(.5051,-.0856,-.8588),(.5074,-.649,-.5668),(.5076,-.3641,-.7808),(.5078,-.85,.1402),(.5107,-.5629,-.6499),(.5109,.6705,-.5379),(.5113,-.8338,.2083),(.5153,.152,.8434),(.5159,-.8491,.1136),(.5162,-.015,.8563),(.5173,-.8146,.2624),(.5194,.7956,-.3118),(.5198,.7664,-.3774),(.5218,-.045,-.8519),(.5219,-.8321,.1876),(.5229,-.2626,-.8109),(.5272,-.4976,.6888),(.5275,.5895,.6117),(.5299,-.8127,.2423),(.5326,.3327,-.7782),(.534,-.6241,-.5704),(.5363,-.8286,-.1606),(.5373,-.8298,.1509),(.5382,-.5346,-.6516),(.5382,.7776,-.3251),(.5392,-.3793,-.7519),(.5418,-.8379,.0667),(.5459,.1742,.8195),(.5468,.823,.1538),(.5479,-.6962,-.4638),(.5519,.0301,-.8334),(.5521,.0957,.8282),(.5525,-.3136,.7723),(.5552,.0107,-.8316),(.5564,.4711,.6845),(.5571,-.2156,-.8019),(.5591,.6408,.526),(.5603,-.8147,.1495),(.5616,-.2204,-.7975),(.5625,-.7174,.411),(.563,.3932,.7269),(.5639,.1462,.8128),(.5643,-.8019,.196),(.5645,-.2013,.8005),(.565,-.7804,.268),(.5652,.8249,.0126),(.5666,-.8016,.1909),(.5667,-.171,-.806),(.568,.4298,.7019),(.5703,.593,-.5684),(.5704,-.5355,-.6228),(.5713,.5206,-.6345),(.5797,.1184,.8062),(.5813,.7997,-.1502),(.5847,-.8044,.1052),(.5868,-.8083,-.0484),(.5889,.2088,.7808),(.5898,.2886,-.7542),(.5902,.8054,.0538),(.5904,.8007,-.1014),(.5904,.4183,-.6903),(.591,-.7954,.1341),(.5948,-.7998,-.0807),(.5986,-.3064,-.7402),(.5998,-.7978,-.0622),(.6003,-.0379,-.7989),(.6011,.3118,.7358),(.6012,.4626,.6516),(.6016,.7666,.2245),(.6036,-.4757,-.6398),(.6037,.7972,.0077),(.6039,-.7854,.1359),(.6045,-.5203,-.6032),(.605,.7962,-.0029),(.6113,-.7206,-.3272),(.615,.7113,-.3403),(.6152,.3123,-.7239),(.6156,-.2302,.7537),(.6179,.7807,.0927),(.6201,.7792,-.0915),(.6271,.5491,-.5525),(.6272,.1854,.7565),(.6279,.5998,-.496),(.6282,-.5512,.5491),(.6283,-.6837,.3711),(.6315,.3634,-.685),(.6327,.3937,.6669),(.637,-.7583,-.1384),(.6371,-.7636,-.105),(.6387,.762,-.1069),(.6407,.5578,-.5276),(.6414,-.2936,-.7088),(.6426,.0958,-.7602),(.6427,.4174,-.6424),(.644,.197,-.7393),(.645,.0929,.7585),(.6485,.4774,-.5928),(.6494,-.7134,-.2634),(.6499,-.2401,-.7211),(.6547,.5751,-.4905),(.6565,-.1005,.7476),(.6576,-.5088,.5556),(.6615,-.5185,-.5418),(.6625,-.7276,.178),(.664,.5135,-.5435),(.6648,.6498,-.3685),(.6684,-.7421,.051),(.6687,.4928,-.5567),(.67,.663,-.334),(.671,.0882,-.7362),(.6713,.7316,-.1188),(.6715,.514,.5337),(.6721,.7402,-.02),(.6721,.4319,-.6015),(.6748,-.2096,.7076),(.6776,.2636,.6865),(.6791,.3086,-.6661),(.6793,.7305,-.0709),(.6799,.6479,.3436),(.6812,.3104,-.663),(.6813,-.4558,-.5728),(.6837,.7297,-.0085),(.6837,-.7097,-.1699),(.6858,-.5972,.416),(.6875,-.7194,-.0995),(.6876,-.7141,.1316),(.6879,.4831,-.5417),(.6897,.5676,.4496),(.6898,-.0642,-.7211),(.6903,-.6395,-.3385),(.6916,.5388,-.481),(.6956,.5977,-.3986),(.6971,.7127,-.078),(.6978,-.4071,-.5893),(.6987,.4407,.5635),(.7,.4817,-.5273),(.7086,-.5631,-.4251),(.7098,.7043,.014),(.7101,.3402,-.6165),(.711,-.4989,.4956),(.7139,.5513,-.4317),(.7161,.3695,-.5921),(.721,.2749,-.636),(.7213,.6641,-.1968),(.7215,.3068,-.6207),(.7218,-.653,.2294),(.7293,.5341,.4276),(.7296,.6836,-.0187),(.73,.5055,-.46),(.7324,.1676,-.6599),(.7353,-.5143,-.4414),(.7358,.1628,-.6573),(.7385,-.4919,-.4612),(.7391,.1938,-.6452),(.7398,.6227,-.2548),(.7408,-.4315,-.5149),(.7426,.6186,.2565),(.7427,.6186,.2564),(.7442,.5635,-.3587),(.7458,.6662,.0023),(.7489,-.2757,-.6026),(.7546,-.2647,-.6004),(.7571,.6358,-.1503),(.762,.1248,-.6354),(.7631,.6406,-.0849),(.7637,.4381,-.4742),(.7637,.1599,-.6254),(.765,.0129,.6439),(.7663,-.122,-.6308),(.7666,.073,-.6379),(.767,-.4316,-.4748),(.7709,.5951,.2272),(.7721,-.4974,-.3955),(.7722,.0143,-.6352),(.7784,.5992,.187),(.7791,.1164,-.616),(.7811,.6236,-.0315),(.7827,.6132,-.1068),(.7831,.0139,.6218),(.7837,-.1115,-.611),(.7861,-.5588,-.2644),(.787,.4853,-.381),(.7932,.5696,.2154),(.811,.013,-.5849),(.8117,.3946,-.4307),(.8147,-.077,-.5748),(.8148,-.3829,-.4352),(.8175,-.0549,-.5733),(.8189,.475,.3222),(.82,-.5658,.0858),(.8205,-.5712,.0215),(.8205,-.565,.0866),(.8212,-.4691,-.3249),(.8218,.43,.374),(.8229,-.1223,-.5548),(.8264,-.5573,-.081),(.8301,.5566,.0333),(.8326,-.3338,-.442),(.8342,.0544,-.5488),(.8385,.4664,-.2817),(.8397,.5302,.117),(.8409,.5179,-.1573),(.8418,-.5391,.0288),(.8425,.5148,-.1586),(.845,.4844,-.2264),(.8473,-.2275,.4799),(.8506,.4805,-.2136),(.8528,.2605,-.4526),(.854,-.1464,.4993),(.8543,-.1658,.4927),(.8547,.4356,-.2825),(.856,.2368,-.4596),(.8577,-.1266,-.4983),(.8598,.4895,.1456),(.8615,.4812,.1617),(.8639,.0903,-.4955),(.8702,-.4399,-.222),(.8758,-.1348,-.4636),(.8769,.3977,-.2701),(.8783,.034,.477),(.8798,-.0343,-.4741),(.8815,.0432,-.4703),(.8845,-.4349,-.1686),(.8852,-.1272,-.4474),(.8896,.1814,-.4192),(.89,.3802,-.2516),(.8904,.0157,.4549),(.8914,-.2514,-.3771),(.8951,.4149,.1634),(.8965,.4352,-.0835),(.8966,.3485,-.2732),(.8967,.0736,.4364),(.9052,-.4238,.0308),(.9064,-.4008,-.1331),(.9083,-.1159,-.402),(.914,.101,.393),(.9165,.0377,-.3982),(.9172,.1099,-.383),(.9232,-.1556,-.3513),(.9262,-.3368,-.1692),(.9308,.2109,-.2984),(.936,.3077,-.1709),(.941,.2429,-.2357),(.9423,-.1837,-.2799),(.9435,.1968,-.2665),(.945,-.2904,-.1502),(.9465,.2347,-.2214),(.9493,.0826,-.3033),(.952,-.1437,-.2703),(.9553,-.2202,-.197),(.9588,.2805,.0454),(.9597,.0312,-.2794),(.961,.0503,.2721),(.9615,-.2003,-.1881),(.9648,-.203,.1672),(.965,-.2605,.0304),(.9691,-.1793,.1696),(.9761,-.0936,-.1964),(.9804,.0151,-.1963),(.9814,.0808,-.174),(.9826,.0848,-.1652),(.9853,-.0261,-.1687),(.9857,-.0359,.1645),(.9864,.0794,-.1438),(.9873,.1408,-.0729),(.9884,-.142,-.0544),(.9903,-.036,-.1343),(.9904,.1322,-.0407),(.9909,-.084,-.1049),(.9935,-.1137,-.003),(.999,.0447,-.0004)]))),
      Shape(DEF='axis',
        appearance=Appearance(
          material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),shininess=0.050,specularColor=(.349,.349,.349))),
        geometry=IndexedFaceSet(DEF='axis_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,0,10,-1,11,12,13,-1,14,15,16,-1,17,18,13,-1,19,20,21,-1,22,7,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,22,36,37,-1,38,13,18,-1,39,40,41,-1,42,43,15,-1,44,45,46,-1,39,47,48,-1,49,50,51,-1,52,53,54,-1,55,56,52,-1,57,58,59,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,75,76,73,-1,77,73,76,-1,78,79,80,-1,81,79,68,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,91,92,93,-1,94,58,57,-1,95,96,97,-1,98,99,100,-1,96,101,102,-1,103,104,105,-1,106,105,107,-1,108,109,110,-1,111,112,113,-1,114,115,116,-1,117,97,102,-1,118,119,120,-1,117,121,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,141,142,143,-1,127,144,145,-1,121,146,147,-1,148,149,150,-1,151,152,153,-1,154,155,156,-1,157,158,159,-1,160,161,162,-1,160,163,164,-1,161,165,166,-1,167,168,169,-1,59,169,168,-1,170,57,171,-1,172,173,111,-1,174,175,176,-1,177,178,179,-1,180,181,182,-1,183,184,185,-1,186,187,188,-1,189,190,191,-1,192,193,194,-1,195,189,192,-1,196,194,197,-1,119,118,198,-1,199,200,201,-1,202,203,204,-1,205,206,204,-1,207,34,33,-1,208,209,41,-1,210,46,211,-1,212,213,214,-1,215,216,217,-1,218,219,220,-1,221,213,222,-1,223,224,225,-1,224,226,65,-1,227,210,225,-1,228,229,65,-1,230,231,232,-1,231,61,60,-1,233,234,106,-1,234,233,110,-1,235,236,237,-1,238,239,240,-1,241,80,242,-1,243,244,245,-1,246,247,248,-1,249,250,251,-1,252,253,237,-1,126,128,254,-1,255,256,257,-1,258,256,195,-1,258,259,260,-1,261,262,263,-1,217,264,63,-1,265,266,267,-1,268,267,269,-1,270,271,272,-1,270,273,274,-1,158,275,276,-1,277,278,279,-1,279,280,277,-1,281,123,282,-1,283,284,285,-1,286,287,285,-1,288,289,290,-1,291,292,293,-1,294,295,296,-1,297,155,298,-1,299,300,164,-1,301,302,303,-1,299,304,300,-1,305,306,307,-1,308,307,309,-1,310,311,312,-1,313,314,315,-1,316,317,318,-1,319,320,321,-1,319,322,320,-1,323,309,324,-1,325,326,69,-1,84,327,328,-1,329,330,331,-1,0,332,333,-1,38,334,335,-1,334,11,335,-1,334,336,337,-1,338,339,340,-1,341,342,343,-1,344,345,346,-1,347,348,349,-1,350,351,352,-1,353,354,355,-1,356,357,358,-1,37,359,360,-1,361,334,38,-1,362,344,347,-1,363,334,337,-1,364,365,366,-1,367,368,369,-1,370,371,42,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,381,382,383,-1,384,385,386,-1,387,388,389,-1,390,391,392,-1,393,394,395,-1,396,397,398,-1,399,400,401,-1,402,403,404,-1,405,406,407,-1,406,405,367,-1,398,408,409,-1,410,411,412,-1,413,414,415,-1,416,417,418,-1,419,420,421,-1,422,423,382,-1,391,424,425,-1,389,388,426,-1,427,428,429,-1,430,431,432,-1,433,434,435,-1,436,437,434,-1,438,439,440,-1,441,442,443,-1,444,445,446,-1,447,448,449,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,459,460,461,-1,462,463,464,-1,465,466,467,-1,468,469,470,-1,471,472,473,-1,474,475,476,-1,475,477,460,-1,478,479,454,-1,480,481,482,-1,483,484,485,-1,486,487,488,-1,489,490,491,-1,492,493,494,-1,495,496,492,-1,497,498,494,-1,499,500,501,-1,502,391,503,-1,504,505,506,-1,507,449,392,-1,445,409,446,-1,508,509,510,-1,511,512,513,-1,514,515,516,-1,182,517,180,-1,518,519,520,-1,521,522,523,-1,524,525,526,-1,527,528,529,-1,530,531,452,-1,532,533,534,-1,535,536,537,-1,532,536,533,-1,538,539,540,-1,358,357,541,-1,542,363,543,-1,356,544,545,-1,546,547,548,-1,549,550,551,-1,552,553,554,-1,555,556,557,-1,557,558,559,-1,558,560,393,-1,560,548,547,-1,367,560,368,-1,561,562,563,-1,564,565,566,-1,567,568,566,-1,442,441,569,-1,570,443,571,-1,439,570,572,-1,573,574,575,-1,419,411,410,-1,420,415,414,-1,245,576,243,-1,577,578,574,-1,579,580,581,-1,574,582,583,-1,461,584,585,-1,443,586,587,-1,458,587,586,-1,588,589,552,-1,590,591,592,-1,593,590,594,-1,595,596,597,-1,598,599,597,-1,600,601,490,-1,540,602,538,-1,529,603,604,-1,528,605,606,-1,607,606,608,-1,609,610,611,-1,486,612,613,-1,614,615,616,-1,617,618,619,-1,620,621,622,-1,623,495,624,-1,620,625,626,-1,627,628,629,-1,630,627,631,-1,632,633,634,-1,635,636,633,-1,637,638,639,-1,638,640,639,-1,315,314,641,-1,318,317,642,-1,637,322,643,-1,644,636,635,-1,401,400,504,-1,645,646,416,-1,394,393,645,-1,647,648,649,-1,650,651,652,-1,504,390,408,-1,653,654,635,-1,322,318,655,-1,642,628,655,-1,643,638,637,-1,634,636,640,-1,656,630,624,-1,657,629,658,-1,657,626,631,-1,631,626,659,-1,624,495,497,-1,660,488,621,-1,615,602,661,-1,662,614,641,-1,613,663,664,-1,665,666,607,-1,609,667,668,-1,669,670,671,-1,667,606,607,-1,529,528,606,-1,538,602,615,-1,598,672,599,-1,598,673,600,-1,594,674,675,-1,593,676,677,-1,677,678,679,-1,589,680,553,-1,681,584,461,-1,682,586,442,-1,443,442,586,-1,573,632,574,-1,683,623,659,-1,421,580,579,-1,579,581,683,-1,684,577,583,-1,421,625,622,-1,685,580,686,-1,578,575,574,-1,439,687,441,-1,688,569,441,-1,689,568,690,-1,564,566,568,-1,563,562,559,-1,368,560,547,-1,691,560,558,-1,554,395,552,-1,546,692,693,-1,694,695,696,-1,697,362,544,-1,698,536,539,-1,540,699,531,-1,700,536,532,-1,532,701,700,-1,451,702,703,-1,703,702,704,-1,704,527,703,-1,705,526,528,-1,527,706,528,-1,434,437,524,-1,707,452,531,-1,708,709,519,-1,508,710,484,-1,711,712,713,-1,714,715,534,-1,485,716,483,-1,483,513,512,-1,717,718,719,-1,717,511,513,-1,408,392,449,-1,717,720,398,-1,649,500,425,-1,501,721,722,-1,723,724,499,-1,687,438,688,-1,624,497,656,-1,493,725,494,-1,726,578,727,-1,412,592,418,-1,728,666,665,-1,508,709,708,-1,729,730,714,-1,731,485,484,-1,476,460,732,-1,474,733,734,-1,470,469,735,-1,472,736,450,-1,737,472,738,-1,466,465,479,-1,473,450,739,-1,740,741,444,-1,742,608,482,-1,681,477,464,-1,460,459,743,-1,467,744,745,-1,707,450,452,-1,523,739,450,-1,746,702,451,-1,704,747,454,-1,388,748,749,-1,688,750,749,-1,524,432,435,-1,751,433,752,-1,753,754,755,-1,425,500,503,-1,756,576,686,-1,417,757,410,-1,402,399,645,-1,402,645,367,-1,758,367,369,-1,403,383,759,-1,413,396,398,-1,413,720,760,-1,394,588,395,-1,761,690,553,-1,565,762,561,-1,392,391,502,-1,384,763,689,-1,764,378,765,-1,766,547,767,-1,768,374,769,-1,696,765,378,-1,542,366,365,-1,345,355,354,-1,360,359,343,-1,697,358,770,-1,771,772,773,-1,347,344,774,-1,772,774,346,-1,775,776,777,-1,343,342,778,-1,353,779,780,-1,781,343,778,-1,782,87,783,-1,308,323,654,-1,784,318,322,-1,784,785,786,-1,321,312,787,-1,300,312,166,-1,788,786,301,-1,299,789,302,-1,155,303,298,-1,155,154,303,-1,293,292,296,-1,314,313,291,-1,790,290,289,-1,791,792,793,-1,794,795,285,-1,796,797,286,-1,791,283,795,-1,283,282,192,-1,798,293,277,-1,273,799,274,-1,268,800,801,-1,800,802,801,-1,802,803,804,-1,216,263,217,-1,54,805,62,-1,806,256,258,-1,252,237,236,-1,807,248,808,-1,809,789,810,-1,251,250,811,-1,810,249,251,-1,157,239,812,-1,811,159,297,-1,245,244,685,-1,811,240,239,-1,813,814,815,-1,61,816,54,-1,817,816,61,-1,818,819,817,-1,223,232,231,-1,820,227,229,-1,224,229,225,-1,217,65,226,-1,821,822,823,-1,824,825,826,-1,280,206,798,-1,280,204,206,-1,204,827,828,-1,829,203,202,-1,830,831,829,-1,199,828,832,-1,119,833,194,-1,197,194,833,-1,193,834,194,-1,192,189,835,-1,192,836,193,-1,191,837,107,-1,187,838,198,-1,185,184,839,-1,152,840,841,-1,713,842,174,-1,201,150,149,-1,153,843,151,-1,844,845,153,-1,846,847,173,-1,171,848,114,-1,172,66,173,-1,167,92,849,-1,91,850,92,-1,167,851,93,-1,814,852,108,-1,305,236,853,-1,854,807,163,-1,162,855,856,-1,727,246,726,-1,82,857,858,-1,792,859,804,-1,860,839,841,-1,149,148,729,-1,152,151,731,-1,861,127,862,-1,863,138,140,-1,142,864,865,-1,863,865,864,-1,147,866,867,-1,120,868,869,-1,147,134,133,-1,870,120,139,-1,864,113,112,-1,281,871,872,-1,128,127,861,-1,806,125,132,-1,118,120,187,-1,188,187,120,-1,122,121,873,-1,874,108,852,-1,58,875,876,-1,104,100,191,-1,56,93,851,-1,79,81,877,-1,877,83,82,-1,328,70,74,-1,77,74,73,-1,878,77,879,-1,880,75,881,-1,79,882,846,-1,846,66,79,-1,264,84,64,-1,261,216,62,-1,883,884,818,-1,88,885,57,-1,816,52,54,-1,886,39,887,-1,888,46,227,-1,889,890,891,-1,886,821,40,-1,41,40,892,-1,893,30,894,-1,8,7,22,-1,33,35,895,-1,12,209,13,-1,8,896,6,-1,897,7,6,-1,31,5,32,-1,897,898,7,-1,899,900,901,-1,25,24,902,-1,902,903,25,-1,904,905,906,-1,895,907,33,-1,8,22,360,-1,30,208,894,-1,40,39,886,-1,890,374,891,-1,227,820,888,-1,39,48,887,-1,885,908,848,-1,816,55,52,-1,57,59,88,-1,909,331,86,-1,261,62,805,-1,215,60,216,-1,64,63,264,-1,66,68,79,-1,908,910,325,-1,880,51,75,-1,77,76,879,-1,77,328,74,-1,845,846,882,-1,80,79,877,-1,244,911,912,-1,168,913,89,-1,56,914,93,-1,103,105,915,-1,191,107,104,-1,875,852,814,-1,58,94,875,-1,873,916,122,-1,188,120,870,-1,170,101,96,-1,806,258,125,-1,917,128,861,-1,918,281,872,-1,112,863,864,-1,870,139,138,-1,147,146,134,-1,136,139,869,-1,120,869,139,-1,867,873,147,-1,865,143,142,-1,863,140,865,-1,871,793,919,-1,127,141,862,-1,731,920,152,-1,921,149,729,-1,922,923,924,-1,804,793,792,-1,797,925,290,-1,727,247,246,-1,855,926,856,-1,163,927,854,-1,166,165,300,-1,814,108,815,-1,167,169,851,-1,849,913,167,-1,89,913,329,-1,66,846,173,-1,171,885,848,-1,846,845,847,-1,845,843,153,-1,843,928,151,-1,929,201,149,-1,923,839,930,-1,174,176,711,-1,174,711,713,-1,841,931,152,-1,185,839,860,-1,187,198,118,-1,187,186,838,-1,191,190,837,-1,192,835,836,-1,193,916,834,-1,194,834,119,-1,832,200,199,-1,199,204,828,-1,198,838,279,-1,280,827,204,-1,932,933,895,-1,822,212,823,-1,783,818,884,-1,217,63,65,-1,820,229,228,-1,917,254,128,-1,883,818,230,-1,818,934,819,-1,61,230,817,-1,54,62,61,-1,813,935,814,-1,813,815,110,-1,236,235,246,-1,244,250,685,-1,297,936,811,-1,810,937,249,-1,251,809,810,-1,807,808,163,-1,236,305,252,-1,256,938,257,-1,806,938,256,-1,126,939,940,-1,216,261,263,-1,804,941,802,-1,800,269,802,-1,799,158,274,-1,798,277,280,-1,196,283,192,-1,791,282,283,-1,796,286,942,-1,285,287,794,-1,790,943,290,-1,662,314,291,-1,293,296,277,-1,944,945,925,-1,165,164,300,-1,789,809,302,-1,785,787,304,-1,300,787,312,-1,321,787,319,-1,784,786,316,-1,784,322,319,-1,654,946,308,-1,848,908,325,-1,783,947,782,-1,781,896,8,-1,334,363,948,-1,772,771,774,-1,774,348,347,-1,771,773,352,-1,372,949,950,-1,697,356,358,-1,360,343,8,-1,345,543,355,-1,11,951,952,-1,11,948,951,-1,378,366,696,-1,374,890,769,-1,377,766,767,-1,764,379,378,-1,408,390,392,-1,689,953,384,-1,502,389,392,-1,422,647,423,-1,761,553,680,-1,553,567,954,-1,394,416,588,-1,413,398,720,-1,504,955,390,-1,403,407,383,-1,758,406,367,-1,367,405,402,-1,760,720,513,-1,755,956,753,-1,434,524,435,-1,749,426,388,-1,750,438,431,-1,454,453,704,-1,736,746,451,-1,450,707,523,-1,428,755,507,-1,744,682,745,-1,732,460,743,-1,464,957,681,-1,742,958,608,-1,444,959,740,-1,473,472,450,-1,466,479,478,-1,472,737,736,-1,470,735,742,-1,959,734,740,-1,734,959,474,-1,960,665,958,-1,476,475,460,-1,484,920,731,-1,729,714,921,-1,961,962,510,-1,665,679,728,-1,612,963,669,-1,578,577,727,-1,493,964,725,-1,965,574,966,-1,438,750,688,-1,723,499,501,-1,722,967,968,-1,501,500,721,-1,717,398,409,-1,969,408,449,-1,717,513,720,-1,717,445,718,-1,483,716,513,-1,485,970,716,-1,714,534,971,-1,972,709,962,-1,711,176,973,-1,711,973,712,-1,484,509,508,-1,708,519,518,-1,531,699,707,-1,699,521,707,-1,437,525,524,-1,706,705,528,-1,530,703,974,-1,703,530,451,-1,532,975,701,-1,976,831,830,-1,533,535,976,-1,700,539,536,-1,698,539,538,-1,977,698,538,-1,978,979,980,-1,549,694,696,-1,546,548,692,-1,762,565,652,-1,554,393,395,-1,368,547,766,-1,459,585,743,-1,566,565,561,-1,568,689,564,-1,953,689,690,-1,687,688,441,-1,981,419,421,-1,685,686,245,-1,622,489,421,-1,411,981,491,-1,684,982,577,-1,581,983,683,-1,683,659,579,-1,632,966,574,-1,682,442,745,-1,690,761,953,-1,552,589,553,-1,679,984,677,-1,677,985,593,-1,598,596,673,-1,598,490,672,-1,538,615,977,-1,606,603,529,-1,667,603,606,-1,671,611,669,-1,668,610,609,-1,613,612,663,-1,641,314,662,-1,661,616,615,-1,963,986,618,-1,621,620,660,-1,659,623,631,-1,657,631,627,-1,627,630,628,-1,656,638,630,-1,634,633,636,-1,643,630,638,-1,642,629,628,-1,655,643,322,-1,653,946,654,-1,652,987,650,-1,647,649,988,-1,393,367,645,-1,416,394,645,-1,504,408,401,-1,637,320,322,-1,642,655,318,-1,641,989,315,-1,635,633,653,-1,632,634,966,-1,631,624,630,-1,629,657,627,-1,625,659,626,-1,624,631,623,-1,620,622,625,-1,661,617,619,-1,616,641,614,-1,613,990,486,-1,991,992,678,-1,993,994,675,-1,611,671,609,-1,606,457,608,-1,529,604,974,-1,540,995,602,-1,600,490,598,-1,598,597,596,-1,595,673,596,-1,593,985,590,-1,590,592,996,-1,395,588,552,-1,589,957,680,-1,458,586,682,-1,458,605,587,-1,443,587,571,-1,585,459,461,-1,573,997,632,-1,574,965,582,-1,574,583,577,-1,245,686,576,-1,420,419,415,-1,419,981,411,-1,572,751,439,-1,567,566,563,-1,561,563,566,-1,367,393,560,-1,560,691,548,-1,393,554,558,-1,557,691,558,-1,556,692,557,-1,553,954,554,-1,551,694,549,-1,546,767,547,-1,356,697,544,-1,542,365,363,-1,541,998,358,-1,536,698,537,-1,536,535,533,-1,534,975,532,-1,452,451,530,-1,974,703,529,-1,703,527,529,-1,705,524,526,-1,521,523,707,-1,519,999,520,-1,514,1000,515,-1,511,961,512,-1,1001,708,518,-1,445,717,409,-1,392,389,507,-1,955,504,506,-1,503,499,502,-1,499,503,500,-1,722,723,501,-1,684,496,495,-1,494,656,497,-1,496,1002,492,-1,492,494,498,-1,986,486,488,-1,584,589,1003,-1,487,621,488,-1,1004,1005,1000,-1,480,482,456,-1,478,454,747,-1,475,1006,477,-1,476,733,474,-1,470,738,468,-1,466,744,467,-1,464,1007,462,-1,465,753,479,-1,959,1008,474,-1,682,744,458,-1,744,456,458,-1,445,741,718,-1,450,736,451,-1,448,969,449,-1,444,741,445,-1,438,687,439,-1,434,433,436,-1,433,435,752,-1,432,1009,430,-1,429,430,427,-1,426,507,389,-1,425,503,391,-1,987,422,382,-1,416,418,588,-1,396,413,1010,-1,413,1011,414,-1,398,401,408,-1,407,403,405,-1,402,405,403,-1,401,1012,399,-1,987,1013,422,-1,502,387,389,-1,384,386,763,-1,953,1014,384,-1,383,1015,381,-1,380,364,378,-1,377,767,375,-1,371,43,42,-1,366,378,364,-1,347,544,362,-1,37,1016,359,-1,356,1017,357,-1,353,780,354,-1,779,350,352,-1,1018,347,349,-1,344,346,774,-1,341,343,359,-1,340,1019,338,-1,334,361,336,-1,1020,371,380,-1,334,948,11,-1,338,0,333,-1,8,343,781,-1,779,1021,350,-1,2,332,0,-1,331,1022,329,-1,328,64,84,-1,69,848,325,-1,316,318,784,-1,313,315,1023,-1,310,312,321,-1,308,309,323,-1,305,307,252,-1,304,787,300,-1,302,298,303,-1,164,789,299,-1,298,936,297,-1,294,944,295,-1,291,313,292,-1,290,156,288,-1,941,1024,1025,-1,285,942,286,-1,795,283,285,-1,281,282,791,-1,282,259,192,-1,276,274,158,-1,270,1026,273,-1,1026,270,272,-1,268,269,800,-1,265,857,266,-1,217,263,264,-1,258,195,259,-1,255,195,256,-1,254,939,126,-1,248,236,246,-1,243,911,244,-1,80,240,242,-1,238,812,239,-1,110,915,234,-1,106,837,233,-1,255,257,233,-1,935,813,938,-1,231,230,61,-1,230,818,817,-1,232,883,230,-1,228,65,77,-1,227,225,229,-1,65,229,224,-1,223,225,1027,-1,213,212,222,-1,220,1027,218,-1,217,226,215,-1,823,212,214,-1,210,227,46,-1,208,41,892,-1,207,33,1028,-1,279,827,280,-1,202,204,199,-1,205,204,203,-1,201,202,199,-1,198,833,119,-1,259,195,192,-1,196,192,194,-1,189,191,835,-1,188,1029,186,-1,183,1030,184,-1,178,1031,179,-1,922,931,841,-1,1032,172,111,-1,57,885,171,-1,59,168,88,-1,167,913,168,-1,167,93,92,-1,164,163,808,-1,166,162,161,-1,160,927,163,-1,162,856,160,-1,154,156,945,-1,1033,263,939,-1,155,1034,156,-1,1031,1035,1036,-1,150,1037,148,-1,873,121,147,-1,145,141,127,-1,143,862,141,-1,135,137,1038,-1,132,125,133,-1,131,1039,129,-1,146,1040,134,-1,142,1041,864,-1,260,125,258,-1,260,123,125,-1,1042,112,111,-1,119,868,120,-1,121,117,102,-1,171,114,116,-1,1032,111,113,-1,257,938,813,-1,110,815,108,-1,107,837,106,-1,104,107,105,-1,96,102,97,-1,98,100,874,-1,97,98,95,-1,57,170,94,-1,914,91,93,-1,88,168,89,-1,85,909,86,-1,811,242,240,-1,84,264,82,-1,80,241,78,-1,858,812,238,-1,73,881,75,-1,72,881,73,-1,69,326,70,-1,86,1043,87,-1,216,60,62,-1,885,88,908,-1,58,1044,59,-1,56,1045,52,-1,51,85,49,-1,47,14,48,-1,888,44,46,-1,374,373,906,-1,42,15,1046,-1,878,228,77,-1,41,47,39,-1,1047,13,209,-1,37,360,22,-1,34,1048,35,-1,30,893,31,-1,27,1049,28,-1,25,894,26,-1,7,898,23,-1,21,10,19,-1,1047,17,13,-1,335,11,13,-1,335,13,38,-1,9,1,0,-1,1050,1051,1052,-1,1053,1051,1050,-1,36,900,899,-1,36,1054,900,-1,893,1055,31,-1,903,1055,893,-1,1056,28,932,-1,1056,29,28,-1,895,826,907,-1,826,895,933,-1,1050,1057,1058,-1,1050,1052,1057,-1,19,0,1059,-1,0,19,10,-1,1060,4,1061,-1,1060,1058,4,-1,1047,208,30,-1,1047,209,208,-1,900,1062,901,-1,900,1063,1062,-1,933,892,826,-1,933,208,892,-1,888,1064,1065,-1,888,820,1064,-1,16,43,1066,-1,15,43,16,-1,1067,1053,9,-1,1067,1051,1053,-1,1067,1068,1051,-1,1069,1070,1071,-1,1069,1072,1070,-1,1073,1074,1070,-1,1073,1065,1074,-1,49,87,782,-1,49,85,87,-1,1022,909,1075,-1,1022,331,909,-1,934,914,819,-1,934,91,914,-1,876,52,1045,-1,876,53,52,-1,881,1076,880,-1,1076,881,72,-1,1077,1078,1079,-1,1078,1077,1080,-1,328,71,70,-1,328,327,71,-1,882,843,845,-1,843,882,1081,-1,81,83,877,-1,1082,83,81,-1,244,1083,250,-1,244,912,1083,-1,1040,131,134,-1,1084,131,1040,-1,95,875,94,-1,95,852,875,-1,834,873,867,-1,834,916,873,-1,132,1085,806,-1,1085,132,130,-1,917,1086,919,-1,917,861,1086,-1,863,870,138,-1,112,870,863,-1,864,115,113,-1,115,864,1041,-1,145,1087,1041,-1,1087,145,1039,-1,869,137,136,-1,1088,137,869,-1,254,919,793,-1,254,917,919,-1,1088,872,137,-1,1088,918,872,-1,1089,918,1088,-1,124,918,1089,-1,930,924,923,-1,178,924,930,-1,842,182,183,-1,713,182,842,-1,794,859,792,-1,1090,859,794,-1,263,266,264,-1,1033,266,263,-1,158,297,159,-1,158,799,297,-1,1091,856,926,-1,1091,854,856,-1,807,1091,853,-1,854,1091,807,-1,103,110,109,-1,915,110,103,-1,1044,56,851,-1,1044,1045,56,-1,850,849,92,-1,850,1092,849,-1,1076,910,1075,-1,1076,325,910,-1,177,173,847,-1,173,177,1093,-1,920,840,152,-1,840,920,1094,-1,181,148,1037,-1,1095,148,181,-1,839,922,841,-1,923,922,839,-1,174,183,185,-1,174,842,183,-1,924,845,844,-1,845,924,847,-1,201,1096,150,-1,201,200,1096,-1,835,100,99,-1,191,100,835,-1,831,203,829,-1,203,831,1097,-1,827,838,828,-1,827,279,838,-1,40,826,892,-1,824,826,40,-1,1062,895,35,-1,1062,932,895,-1,1098,214,1099,-1,1098,825,214,-1,218,1099,219,-1,1099,218,1100,-1,222,783,884,-1,947,783,222,-1,231,215,223,-1,60,215,231,-1,55,817,819,-1,55,816,817,-1,938,54,935,-1,938,805,54,-1,937,1101,1102,-1,937,1103,1101,-1,239,159,811,-1,157,159,239,-1,789,808,810,-1,789,164,808,-1,802,1104,801,-1,802,941,1104,-1,265,271,276,-1,265,272,271,-1,284,196,197,-1,284,283,196,-1,1105,942,1106,-1,942,1105,796,-1,1107,1108,1104,-1,1109,1108,1107,-1,1109,1110,1108,-1,289,1111,1112,-1,288,1111,289,-1,1025,1104,941,-1,1025,1107,1104,-1,1090,1024,859,-1,1024,1090,1025,-1,273,1034,799,-1,273,1113,1034,-1,303,944,294,-1,154,944,303,-1,154,945,944,-1,809,298,302,-1,809,936,298,-1,786,304,301,-1,786,785,304,-1,785,319,787,-1,319,785,784,-1,911,1081,78,-1,911,1114,1081,-1,1115,782,1116,-1,782,1115,49,-1,778,332,781,-1,1117,332,778,-1,1118,332,1117,-1,1118,333,332,-1,778,1119,1117,-1,342,1119,778,-1,339,1120,1121,-1,339,1122,1120,-1,364,951,365,-1,370,951,364,-1,349,774,771,-1,349,348,774,-1,347,1123,544,-1,347,1018,1123,-1,978,697,770,-1,362,697,978,-1,1124,1125,1126,-1,1124,1127,1125,-1,0,1019,1059,-1,338,1019,0,-1,1021,1128,1129,-1,1021,1126,1128,-1,543,337,355,-1,543,363,337,-1,1130,768,769,-1,1130,376,768,-1,380,1131,1020,-1,1131,380,379,-1,1132,1131,1133,-1,1131,1132,1134,-1,1135,1133,764,-1,1135,1136,1133,-1,695,650,1137,-1,651,650,695,-1,390,424,391,-1,424,390,955,-1,1138,1139,1013,-1,1138,967,1139,-1,762,1140,561,-1,762,1141,1140,-1,505,403,759,-1,404,403,505,-1,1136,1132,1133,-1,1142,1132,1136,-1,1012,645,399,-1,1012,646,645,-1,716,760,513,-1,1143,760,716,-1,759,506,505,-1,423,506,759,-1,428,956,755,-1,427,956,428,-1,440,435,432,-1,435,440,752,-1,747,702,746,-1,747,704,702,-1,1144,467,745,-1,463,467,1144,-1,735,743,960,-1,735,732,743,-1,739,740,473,-1,740,739,741,-1,448,959,444,-1,1008,959,448,-1,1145,1006,1008,-1,1007,1006,1145,-1,470,737,738,-1,737,470,481,-1,960,585,665,-1,960,743,585,-1,742,481,470,-1,742,482,481,-1,509,483,512,-1,483,509,484,-1,1005,1146,1147,-1,1005,1004,1146,-1,182,712,520,-1,712,182,713,-1,728,668,666,-1,668,728,1148,-1,591,589,588,-1,589,591,1003,-1,622,490,489,-1,622,672,490,-1,493,1149,964,-1,493,1150,1149,-1,1149,582,965,-1,582,1149,1150,-1,439,752,440,-1,752,439,751,-1,386,387,724,-1,386,385,387,-1,721,967,722,-1,721,1139,967,-1,408,446,409,-1,446,408,969,-1,522,718,523,-1,719,718,522,-1,731,970,485,-1,731,1151,970,-1,1152,714,971,-1,1152,921,714,-1,708,710,508,-1,708,1001,710,-1,973,1001,518,-1,973,176,1001,-1,1146,534,715,-1,1146,975,534,-1,432,705,1009,-1,705,432,524,-1,587,528,526,-1,528,587,605,-1,976,1152,971,-1,976,830,1152,-1,698,1153,537,-1,1153,698,977,-1,770,979,978,-1,770,1154,979,-1,550,1154,1155,-1,550,979,1154,-1,1155,692,556,-1,693,692,1155,-1,565,1138,652,-1,565,1156,1138,-1,559,555,557,-1,559,562,555,-1,1101,983,1102,-1,1101,982,983,-1,489,981,421,-1,981,489,491,-1,684,623,683,-1,684,495,623,-1,761,745,442,-1,745,761,1144,-1,680,1144,761,-1,957,1144,680,-1,1003,677,984,-1,677,1003,985,-1,674,595,597,-1,674,594,595,-1,1153,615,614,-1,977,615,1153,-1,671,1157,1158,-1,670,1157,671,-1,674,993,675,-1,674,1159,993,-1,599,1160,597,-1,1161,1160,599,-1,993,664,1162,-1,993,1159,664,-1,675,991,678,-1,991,675,994,-1,1162,663,1163,-1,664,663,1162,-1,617,963,618,-1,670,963,617,-1,670,669,963,-1,1002,493,492,-1,493,1002,1150,-1,619,657,658,-1,657,619,660,-1,629,989,658,-1,989,629,642,-1,1143,576,1011,-1,1143,1164,576,-1,1165,1166,1167,-1,1165,1168,1166,-1,760,1011,413,-1,760,1143,1011,-1,639,320,637,-1,639,1169,320,-1,658,641,616,-1,641,658,989,-1,997,633,632,-1,653,633,997,-1,995,670,617,-1,995,1157,670,-1,1161,486,990,-1,486,1161,487,-1,678,728,679,-1,992,728,678,-1,664,1170,613,-1,664,1159,1170,-1,1159,597,1160,-1,1159,674,597,-1,1158,609,671,-1,1158,604,609,-1,530,604,1158,-1,974,604,530,-1,614,1171,1153,-1,614,662,1171,-1,590,1003,591,-1,985,1003,590,-1,1172,997,573,-1,1172,1173,997,-1,727,982,1101,-1,727,577,982,-1,414,1174,420,-1,1174,414,756,-1,525,570,571,-1,525,437,570,-1,565,1175,1156,-1,564,1175,565,-1,555,561,1140,-1,555,562,561,-1,651,694,1141,-1,651,695,694,-1,692,691,557,-1,692,548,691,-1,549,979,550,-1,549,980,979,-1,541,767,546,-1,541,375,767,-1,998,770,358,-1,1154,770,998,-1,1176,1153,1171,-1,1176,537,1153,-1,537,1097,535,-1,537,1176,1097,-1,534,976,971,-1,976,534,533,-1,701,522,521,-1,701,514,522,-1,520,517,182,-1,520,999,517,-1,999,1177,517,-1,1177,999,1147,-1,1001,1094,710,-1,176,1094,1001,-1,1005,709,972,-1,519,709,1005,-1,729,1178,730,-1,729,1179,1178,-1,649,424,988,-1,649,425,424,-1,749,1014,688,-1,749,748,1014,-1,582,1002,496,-1,582,1150,1002,-1,656,725,634,-1,656,494,725,-1,672,621,487,-1,672,622,621,-1,591,418,592,-1,588,418,591,-1,1148,610,668,-1,610,1148,1163,-1,715,1147,1146,-1,1177,1147,715,-1,510,512,961,-1,510,509,512,-1,753,454,479,-1,753,956,454,-1,469,732,735,-1,469,476,732,-1,734,473,740,-1,734,471,473,-1,1180,747,746,-1,1180,478,747,-1,1006,464,477,-1,1006,1007,464,-1,1006,474,1008,-1,474,1006,475,-1,464,1144,957,-1,464,463,1144,-1,447,507,755,-1,447,449,507,-1,741,523,718,-1,741,739,523,-1,750,430,429,-1,750,431,430,-1,724,502,499,-1,724,387,502,-1,410,415,419,-1,410,757,415,-1,756,1011,576,-1,1011,756,414,-1,396,1181,397,-1,396,1010,1181,-1,970,1143,716,-1,1164,1143,970,-1,1015,1142,1136,-1,1182,1142,1015,-1,758,407,406,-1,758,1182,407,-1,400,402,404,-1,399,402,400,-1,386,1175,763,-1,386,1183,1175,-1,647,1013,1139,-1,422,1013,647,-1,388,385,748,-1,388,387,385,-1,696,1137,765,-1,1137,696,695,-1,381,1136,1135,-1,381,1015,1136,-1,764,1131,379,-1,1133,1131,764,-1,1134,1020,1131,-1,1020,1134,1167,-1,376,949,768,-1,375,949,376,-1,1167,1066,1020,-1,1066,1167,1166,-1,766,369,368,-1,1184,369,766,-1,544,1185,545,-1,544,1123,1185,-1,355,336,353,-1,355,337,336,-1,1129,1123,1021,-1,1185,1123,1129,-1,1186,336,340,-1,353,336,1186,-1,1126,1119,1128,-1,1126,1125,1119,-1,950,357,1017,-1,950,949,357,-1,543,344,362,-1,543,345,344,-1,349,350,1018,-1,350,349,351,-1,771,351,349,-1,771,352,351,-1,951,363,365,-1,951,948,363,-1,952,370,42,-1,952,951,370,-1,1125,1117,1119,-1,1125,1118,1117,-1,338,1122,339,-1,338,333,1122,-1,243,1114,911,-1,243,1187,1114,-1,72,325,1076,-1,72,326,325,-1,323,1188,654,-1,1188,323,324,-1,315,316,1023,-1,315,317,316,-1,309,310,324,-1,311,310,309,-1,306,309,307,-1,311,309,306,-1,299,301,304,-1,299,302,301,-1,796,278,295,-1,796,1105,278,-1,156,1113,288,-1,1034,1113,156,-1,859,941,804,-1,941,859,1024,-1,1112,790,289,-1,1112,1110,790,-1,1026,1110,1189,-1,1026,1108,1110,-1,285,1106,942,-1,285,284,1106,-1,284,833,1106,-1,833,284,197,-1,1171,291,1190,-1,1171,662,291,-1,267,272,265,-1,267,268,272,-1,857,276,275,-1,276,857,265,-1,189,255,190,-1,189,195,255,-1,1102,249,937,-1,1191,249,1102,-1,1192,237,1172,-1,235,237,1192,-1,233,813,110,-1,233,257,813,-1,935,53,814,-1,54,53,935,-1,883,220,221,-1,883,232,220,-1,212,947,222,-1,212,822,947,-1,225,218,1027,-1,225,210,218,-1,213,1099,214,-1,213,219,1099,-1,1100,1098,1099,-1,1100,1028,1098,-1,35,901,1062,-1,901,35,1048,-1,34,45,905,-1,207,45,34,-1,1029,832,186,-1,1029,179,832,-1,181,183,182,-1,181,1030,183,-1,1037,1030,181,-1,1193,1030,1037,-1,1094,175,840,-1,175,1094,176,-1,839,1035,930,-1,1035,839,184,-1,1095,729,148,-1,1095,1179,729,-1,1093,179,1029,-1,177,179,1093,-1,330,1092,331,-1,849,1092,330,-1,165,160,164,-1,161,160,165,-1,855,166,306,-1,855,162,166,-1,155,799,1034,-1,155,297,799,-1,82,266,857,-1,266,82,264,-1,287,1090,794,-1,1194,1090,287,-1,1193,150,1096,-1,150,1193,1037,-1,844,922,924,-1,844,931,922,-1,121,1040,146,-1,121,102,1040,-1,861,1038,1086,-1,861,862,1038,-1,866,1088,869,-1,1089,1088,866,-1,130,134,131,-1,130,132,134,-1,1039,1084,1087,-1,1084,1039,131,-1,144,262,129,-1,262,144,940,-1,1085,129,262,-1,1085,130,129,-1,119,867,868,-1,119,834,867,-1,113,114,1032,-1,114,113,115,-1,106,915,105,-1,234,915,106,-1,1084,102,101,-1,1084,1040,102,-1,98,852,95,-1,98,874,852,-1,59,851,169,-1,59,1044,851,-1,783,1043,1195,-1,783,87,1043,-1,250,242,811,-1,250,1083,242,-1,1082,84,83,-1,1082,327,84,-1,1082,68,67,-1,1082,81,68,-1,1081,928,843,-1,928,1081,1114,-1,1080,50,1078,-1,50,1080,1196,-1,75,879,76,-1,75,1196,879,-1,74,326,72,-1,326,74,70,-1,819,56,55,-1,819,914,56,-1,1043,331,1092,-1,331,1043,86,-1,1045,58,876,-1,1045,1044,58,-1,1116,821,886,-1,822,821,1116,-1,1078,49,1115,-1,1078,50,49,-1,1197,887,48,-1,887,1197,1079,-1,16,1071,1197,-1,1069,1071,16,-1,905,44,891,-1,44,905,45,-1,1066,1069,16,-1,1166,1069,1066,-1,878,820,228,-1,820,878,1064,-1,1063,932,1062,-1,1063,1056,932,-1,17,30,32,-1,17,1047,30,-1,1056,1061,4,-1,1061,1056,1063,-1,17,1198,20,-1,1198,17,32,-1,1199,1058,1060,-1,1199,1050,1058,-1,34,904,1048,-1,34,905,904,-1,1200,903,902,-1,1200,1055,903,-1,1055,5,31,-1,1055,1200,5,-1,1049,26,28,-1,1049,24,26,-1,1201,902,27,-1,1201,1200,902,-1,22,1054,36,-1,22,23,1054,-1,17,19,18,-1,17,20,19,-1,1046,14,47,-1,14,1046,15,-1,1052,1068,1202,-1,1051,1068,1052,-1,6,2,1,-1,6,896,2,-1,1058,5,4,-1,1058,1057,5,-1,1067,10,21,-1,1067,9,10,-1,1203,1050,1199,-1,1203,1053,1050,-1,1046,952,42,-1,1046,1204,952,-1,209,1204,41,-1,209,12,1204,-1,894,903,893,-1,25,903,894,-1,3,27,29,-1,1201,27,3,-1,26,208,933,-1,26,894,208,-1,1057,1202,1198,-1,1052,1202,1057,-1,20,1202,21,-1,1202,20,1198,-1,23,1061,1054,-1,1060,1061,23,-1,899,37,36,-1,37,899,1205,-1,4,29,1056,-1,4,3,29,-1,901,1205,899,-1,1205,901,1206,-1,12,952,1204,-1,952,12,11,-1,44,1065,1073,-1,44,888,1065,-1,1168,889,1072,-1,890,889,1168,-1,1206,1048,904,-1,901,1048,1206,-1,1072,1073,1070,-1,889,1073,1072,-1,1071,1074,1077,-1,1071,1070,1074,-1,909,51,880,-1,51,909,85,-1,90,1075,910,-1,1075,90,1022,-1,850,934,1195,-1,934,850,91,-1,66,71,67,-1,66,69,71,-1,1074,1080,1077,-1,1080,1074,1207,-1,1207,1065,1064,-1,1065,1207,1074,-1,67,327,1082,-1,327,67,71,-1,858,877,82,-1,858,238,877,-1,78,912,911,-1,241,912,78,-1,80,238,240,-1,80,877,238,-1,96,94,170,-1,96,95,94,-1,108,100,109,-1,108,874,100,-1,188,112,1042,-1,188,870,112,-1,170,116,101,-1,170,171,116,-1,918,123,281,-1,123,918,124,-1,871,1086,872,-1,871,919,1086,-1,142,145,1041,-1,141,145,142,-1,129,145,144,-1,129,1039,145,-1,137,1086,1038,-1,872,1086,137,-1,1041,116,115,-1,116,1041,1087,-1,125,1089,133,-1,125,124,1089,-1,930,1031,178,-1,1031,930,1035,-1,797,943,286,-1,290,943,797,-1,939,803,1033,-1,803,939,254,-1,157,275,158,-1,275,157,812,-1,925,156,290,-1,925,945,156,-1,853,926,305,-1,1091,926,853,-1,53,875,814,-1,53,876,875,-1,90,329,1022,-1,90,89,329,-1,1093,111,173,-1,1093,1042,111,-1,178,847,924,-1,847,178,177,-1,180,1095,181,-1,1179,1095,180,-1,1036,200,832,-1,1096,200,1036,-1,99,836,835,-1,117,836,99,-1,117,122,836,-1,829,201,929,-1,202,201,829,-1,1097,205,203,-1,1097,1176,205,-1,1190,1176,1171,-1,1190,205,1176,-1,907,1028,33,-1,1028,907,1098,-1,46,207,211,-1,46,45,207,-1,825,823,214,-1,825,824,823,-1,210,1100,218,-1,1100,210,211,-1,219,221,220,-1,219,213,221,-1,226,223,215,-1,226,224,223,-1,233,190,255,-1,233,837,190,-1,1083,241,242,-1,912,241,1083,-1,1103,727,1101,-1,1103,247,727,-1,247,808,248,-1,247,1103,808,-1,253,1172,237,-1,253,1173,1172,-1,1033,267,266,-1,267,1033,269,-1,268,1104,1108,-1,801,1104,268,-1,276,270,274,-1,276,271,270,-1,279,1105,198,-1,279,278,1105,-1,282,260,259,-1,260,282,123,-1,871,791,793,-1,281,791,871,-1,1112,1189,1110,-1,1112,1111,1189,-1,1189,288,1113,-1,1189,1111,288,-1,1208,1107,1025,-1,1208,1109,1107,-1,1194,1025,1090,-1,1025,1194,1208,-1,295,277,296,-1,278,277,295,-1,294,292,788,-1,292,294,296,-1,307,253,252,-1,253,307,308,-1,313,788,292,-1,1023,788,313,-1,320,310,321,-1,320,1169,310,-1,78,882,79,-1,78,1081,882,-1,1166,1072,1069,-1,1166,1168,1072,-1,779,1126,1021,-1,779,1124,1126,-1,2,781,332,-1,2,896,781,-1,1120,1127,1121,-1,1127,1120,1209,-1,380,370,364,-1,371,370,380,-1,1019,336,361,-1,1019,340,336,-1,1210,359,1016,-1,1210,341,359,-1,772,345,354,-1,345,772,346,-1,779,773,780,-1,779,352,773,-1,1121,1124,1186,-1,1124,1121,1127,-1,1121,340,339,-1,1186,340,1121,-1,1129,341,1210,-1,341,1129,1128,-1,777,37,1205,-1,777,1016,37,-1,1018,1021,1123,-1,1018,350,1021,-1,1205,775,777,-1,1206,775,1205,-1,1211,376,1130,-1,1211,377,376,-1,769,1168,1165,-1,1168,769,890,-1,1017,1206,950,-1,1206,1017,775,-1,1130,1165,1212,-1,1165,1130,769,-1,1213,1134,1132,-1,1213,1212,1134,-1,383,423,759,-1,382,423,383,-1,506,424,955,-1,988,424,506,-1,1156,967,1138,-1,968,967,1156,-1,1012,398,397,-1,1012,401,398,-1,1142,1213,1132,-1,1214,1213,1142,-1,1211,1214,1184,-1,1213,1214,1211,-1,646,397,1181,-1,1012,397,646,-1,412,417,410,-1,412,418,417,-1,757,413,415,-1,757,1010,413,-1,416,1181,417,-1,416,646,1181,-1,420,580,421,-1,420,1174,580,-1,1013,652,1138,-1,1013,987,652,-1,724,1183,386,-1,724,723,1183,-1,426,428,507,-1,426,429,428,-1,432,438,440,-1,432,431,438,-1,751,436,433,-1,436,751,572,-1,969,444,446,-1,448,444,969,-1,457,482,608,-1,456,482,457,-1,735,958,742,-1,735,960,958,-1,754,1007,1145,-1,462,1007,754,-1,465,463,462,-1,465,467,463,-1,481,1180,737,-1,1180,481,480,-1,447,1008,448,-1,1145,1008,447,-1,480,744,466,-1,480,456,744,-1,1000,972,515,-1,1005,972,1000,-1,663,669,611,-1,669,663,612,-1,984,584,1003,-1,585,584,984,-1,601,491,490,-1,411,491,601,-1,486,963,612,-1,486,986,963,-1,964,965,966,-1,965,964,1149,-1,492,497,495,-1,497,492,498,-1,1139,648,647,-1,648,1139,721,-1,514,719,522,-1,719,514,516,-1,511,515,961,-1,516,515,511,-1,1178,180,517,-1,180,1178,1179,-1,975,1004,701,-1,1004,975,1146,-1,706,1009,705,-1,706,455,1009,-1,706,453,455,-1,375,357,949,-1,357,375,541,-1,775,356,545,-1,1017,356,775,-1,1154,693,1155,-1,1154,998,693,-1,1155,551,550,-1,1155,556,551,-1,1140,556,555,-1,1140,551,556,-1,559,554,954,-1,559,558,554,-1,1014,569,688,-1,569,1014,953,-1,441,570,439,-1,441,443,570,-1,573,1192,1172,-1,1192,573,575,-1,581,1102,983,-1,1102,581,1191,-1,583,496,684,-1,496,583,582,-1,571,526,525,-1,571,587,526,-1,600,592,601,-1,996,592,600,-1,675,593,594,-1,675,676,593,-1,595,590,996,-1,595,594,590,-1,1157,540,531,-1,1157,995,540,-1,458,606,605,-1,457,606,458,-1,607,958,665,-1,958,607,608,-1,1160,1170,1159,-1,1160,1215,1170,-1,990,1160,1161,-1,990,1215,1160,-1,994,1162,991,-1,994,993,1162,-1,991,1163,1148,-1,1162,1163,991,-1,602,617,661,-1,617,602,995,-1,616,619,658,-1,661,619,616,-1,639,636,644,-1,636,639,640,-1,642,315,989,-1,642,317,315,-1,1188,635,654,-1,644,635,1188,-1,504,404,505,-1,504,400,404,-1,1164,243,576,-1,1164,1187,243,-1,650,1135,1137,-1,381,1135,650,-1,1173,653,997,-1,1173,946,653,-1,644,1169,639,-1,644,1188,1169,-1,643,628,630,-1,655,628,643,-1,634,638,656,-1,640,638,634,-1,626,660,620,-1,660,626,657,-1,618,660,619,-1,618,488,660,-1,618,986,488,-1,487,599,672,-1,487,1161,599,-1,992,1148,728,-1,991,1148,992,-1,1215,613,1170,-1,613,1215,990,-1,666,667,607,-1,666,668,667,-1,604,667,609,-1,604,603,667,-1,531,1158,1157,-1,530,1158,531,-1,673,996,600,-1,673,595,996,-1,675,677,676,-1,675,678,677,-1,659,421,579,-1,659,625,421,-1,683,982,684,-1,683,983,982,-1,578,1192,575,-1,1192,578,726,-1,1191,580,685,-1,1191,581,580,-1,437,572,570,-1,437,436,572,-1,953,442,569,-1,953,761,442,-1,564,763,1175,-1,564,689,763,-1,954,563,559,-1,563,954,567,-1,652,1141,762,-1,1141,652,651,-1,1141,551,1140,-1,1141,694,551,-1,980,696,366,-1,549,696,980,-1,546,998,541,-1,693,998,546,-1,978,366,542,-1,366,978,980,-1,699,539,700,-1,699,540,539,-1,535,831,976,-1,1097,831,535,-1,527,453,706,-1,527,704,453,-1,1000,701,1004,-1,1000,514,701,-1,521,700,701,-1,521,699,700,-1,1147,519,1005,-1,519,1147,999,-1,520,973,518,-1,520,712,973,-1,510,709,508,-1,709,510,962,-1,730,517,1177,-1,517,730,1178,-1,710,920,484,-1,1094,920,710,-1,717,516,511,-1,719,516,717,-1,648,500,649,-1,648,721,500,-1,455,430,1009,-1,455,427,430,-1,634,964,966,-1,634,725,964,-1,412,601,592,-1,412,411,601,-1,984,665,585,-1,665,984,679,-1,1163,611,610,-1,611,1163,663,-1,714,1177,715,-1,730,1177,714,-1,961,972,962,-1,972,961,515,-1,755,1145,447,-1,754,1145,755,-1,471,738,472,-1,471,468,738,-1,471,733,468,-1,733,471,734,-1,737,746,736,-1,737,1180,746,-1,1180,466,478,-1,1180,480,466,-1,468,476,469,-1,468,733,476,-1,681,460,477,-1,460,681,461,-1,589,681,957,-1,589,584,681,-1,427,454,956,-1,427,455,454,-1,749,429,426,-1,749,750,429,-1,462,753,465,-1,753,462,754,-1,723,968,1183,-1,723,722,968,-1,1174,686,580,-1,1174,756,686,-1,417,1010,757,-1,1010,417,1181,-1,970,1187,1164,-1,1187,970,1151,-1,764,1137,1135,-1,764,765,1137,-1,758,1184,1214,-1,758,369,1184,-1,383,1182,1015,-1,407,1182,383,-1,1182,1214,1142,-1,758,1214,1182,-1,690,567,553,-1,690,568,567,-1,384,748,385,-1,384,1014,748,-1,1183,1156,1175,-1,1183,968,1156,-1,423,988,506,-1,423,647,988,-1,987,381,650,-1,987,382,381,-1,1213,1130,1212,-1,1213,1211,1130,-1,1212,1167,1134,-1,1212,1165,1167,-1,1118,1122,333,-1,1209,1122,1118,-1,1209,1120,1122,-1,43,1020,1066,-1,1020,43,371,-1,1184,377,1211,-1,1184,766,377,-1,542,362,978,-1,542,543,362,-1,545,776,775,-1,545,1185,776,-1,353,1124,779,-1,353,1186,1124,-1,1185,1210,776,-1,1210,1185,1129,-1,1059,361,38,-1,1019,361,1059,-1,1128,342,341,-1,342,1128,1119,-1,372,768,949,-1,372,374,768,-1,373,950,1206,-1,373,372,950,-1,773,354,780,-1,354,773,772,-1,776,1016,777,-1,776,1210,1016,-1,1209,1125,1127,-1,1125,1209,1118,-1,328,65,64,-1,328,77,65,-1,308,1173,253,-1,308,946,1173,-1,1169,324,310,-1,1169,1188,324,-1,1023,786,788,-1,316,786,1023,-1,312,306,166,-1,306,312,311,-1,301,294,788,-1,303,294,301,-1,856,927,160,-1,854,927,856,-1,925,295,944,-1,925,796,295,-1,925,797,796,-1,943,1208,1194,-1,1208,943,790,-1,790,1109,1208,-1,790,1110,1109,-1,1189,273,1026,-1,273,1189,1113,-1,795,792,791,-1,795,794,792,-1,1106,198,1105,-1,198,1106,833,-1,293,1190,291,-1,1190,293,798,-1,272,1108,1026,-1,272,268,1108,-1,802,1033,803,-1,269,1033,802,-1,1085,261,805,-1,261,1085,262,-1,806,805,938,-1,1085,805,806,-1,248,853,236,-1,248,807,853,-1,811,809,251,-1,811,936,809,-1,1103,810,808,-1,1103,937,810,-1,1192,246,235,-1,726,246,1192,-1,250,1191,685,-1,250,249,1191,-1,220,223,1027,-1,220,232,223,-1,1195,818,783,-1,1195,934,818,-1,821,824,40,-1,824,821,823,-1,1028,211,207,-1,211,1028,1100,-1,825,907,826,-1,825,1098,907,-1,1190,206,205,-1,798,206,1190,-1,1152,829,929,-1,1152,830,829,-1,122,193,836,-1,122,916,193,-1,832,1031,1036,-1,832,179,1031,-1,828,186,832,-1,828,838,186,-1,184,1193,1035,-1,1030,1193,184,-1,185,175,174,-1,185,860,175,-1,840,860,841,-1,840,175,860,-1,149,1152,929,-1,149,921,1152,-1,928,731,151,-1,928,1151,731,-1,1042,1029,188,-1,1029,1042,1093,-1,1032,848,172,-1,114,848,1032,-1,913,330,329,-1,913,849,330,-1,98,117,99,-1,98,97,117,-1,926,306,305,-1,926,855,306,-1,275,858,857,-1,275,812,858,-1,793,803,254,-1,804,803,793,-1,286,1194,287,-1,943,1194,286,-1,1096,1035,1193,-1,1096,1036,1035,-1,153,931,844,-1,152,931,153,-1,1087,101,116,-1,101,1087,1084,-1,136,140,139,-1,136,135,140,-1,143,140,135,-1,865,140,143,-1,867,869,868,-1,867,866,869,-1,133,866,147,-1,133,1089,866,-1,862,135,1038,-1,862,143,135,-1,127,940,144,-1,126,940,127,-1,940,263,262,-1,940,939,263,-1,104,109,100,-1,103,109,104,-1,1075,880,1076,-1,880,1075,909,-1,172,69,66,-1,172,848,69,-1,1187,928,1114,-1,1151,928,1187,-1,1116,887,1115,-1,1116,886,887,-1,1064,879,1207,-1,1064,878,879,-1,1196,51,50,-1,51,1196,75,-1,1207,1196,1080,-1,1196,1207,879,-1,221,884,883,-1,221,222,884,-1,1092,1195,1043,-1,1092,850,1195,-1,90,908,88,-1,910,908,90,-1,782,822,1116,-1,822,782,947,-1,1079,1115,887,-1,1079,1078,1115,-1,1197,1077,1079,-1,1071,1077,1197,-1,1197,14,16,-1,48,14,1197,-1,891,1073,889,-1,891,44,1073,-1,933,28,26,-1,28,933,932,-1,1057,32,5,-1,1057,1198,32,-1,1054,1063,900,-1,1061,1063,1054,-1,18,1059,38,-1,1059,18,19,-1,898,1060,23,-1,1199,1060,898,-1,891,906,905,-1,891,374,906,-1,904,373,1206,-1,904,906,373,-1,1200,3,5,-1,1200,1201,3,-1,24,27,902,-1,24,1049,27,-1,1204,47,41,-1,47,1204,1046,-1,1068,21,1202,-1,1068,1067,21,-1,1199,897,1203,-1,897,1199,898,-1,1,897,6,-1,1,1203,897,-1,1,1053,1203,-1,1,9,1053,-1],creaseAngle=1.571,normalIndex=[615,900,623,-1,134,33,41,-1,802,315,562,-1,846,615,1103,-1,639,675,1016,-1,787,762,774,-1,972,1145,1016,-1,1156,985,932,-1,165,315,39,-1,55,104,24,-1,201,75,179,-1,440,80,330,-1,180,175,87,-1,165,53,619,-1,606,1016,1145,-1,785,335,541,-1,602,586,762,-1,582,311,266,-1,785,790,982,-1,1170,1190,1158,-1,130,257,108,-1,152,319,130,-1,660,667,502,-1,135,96,74,-1,488,756,636,-1,823,1004,904,-1,1198,1157,1207,-1,1211,1213,1199,-1,1195,1214,1213,-1,1076,1213,1214,-1,525,693,810,-1,920,693,904,-1,824,1035,912,-1,1131,947,808,-1,731,736,931,-1,372,387,401,-1,766,667,660,-1,847,978,1088,-1,1008,890,905,-1,978,730,1021,-1,703,803,464,-1,178,464,646,-1,827,792,262,-1,214,82,263,-1,716,373,462,-1,1063,1088,1021,-1,510,696,422,-1,1063,1206,986,-1,48,673,822,-1,230,403,244,-1,466,739,781,-1,964,1097,1093,-1,690,676,743,-1,241,535,483,-1,389,333,486,-1,403,172,405,-1,1206,1049,1023,-1,384,362,182,-1,683,552,432,-1,499,656,322,-1,698,467,711,-1,36,67,17,-1,36,78,13,-1,67,47,66,-1,435,517,444,-1,502,444,517,-1,791,660,684,-1,843,318,214,-1,662,688,607,-1,144,159,154,-1,620,538,613,-1,833,584,751,-1,216,370,195,-1,267,340,735,-1,187,518,553,-1,109,267,187,-1,280,553,461,-1,696,510,565,-1,117,34,89,-1,215,273,160,-1,360,279,160,-1,237,175,180,-1,381,669,541,-1,256,266,227,-1,186,204,163,-1,236,118,296,-1,245,235,238,-1,228,204,248,-1,278,348,292,-1,348,410,636,-1,393,256,292,-1,854,465,636,-1,147,171,210,-1,171,96,135,-1,5,52,178,-1,52,5,262,-1,300,116,344,-1,951,821,885,-1,520,810,678,-1,581,551,567,-1,376,392,173,-1,316,443,209,-1,79,358,344,-1,230,244,94,-1,69,189,100,-1,284,189,109,-1,284,61,136,-1,60,99,192,-1,296,469,488,-1,441,420,371,-1,359,371,331,-1,155,337,350,-1,155,271,339,-1,467,530,406,-1,463,546,482,-1,482,343,463,-1,110,48,38,-1,133,353,291,-1,430,239,291,-1,261,399,395,-1,427,426,434,-1,429,555,455,-1,728,656,454,-1,58,7,13,-1,196,120,448,-1,58,73,7,-1,59,111,162,-1,338,162,164,-1,272,129,98,-1,484,578,598,-1,407,599,593,-1,342,573,320,-1,342,580,573,-1,243,164,336,-1,1153,1187,1198,-1,912,1192,1077,-1,798,643,861,-1,615,313,365,-1,606,198,610,-1,198,639,610,-1,198,246,317,-1,113,301,233,-1,1176,1105,907,-1,1188,1111,1135,-1,1138,1067,1013,-1,1085,1012,1124,-1,884,1009,754,-1,1130,1040,1036,-1,619,1056,575,-1,71,198,606,-1,1183,1188,1138,-1,561,198,317,-1,425,680,856,-1,145,366,70,-1,400,453,602,-1,767,616,635,-1,896,579,654,-1,413,249,423,-1,44,85,45,-1,1089,726,886,-1,727,544,638,-1,289,485,451,-1,571,460,718,-1,310,212,380,-1,56,27,19,-1,12,26,4,-1,1,2,20,-1,2,1,145,-1,380,188,361,-1,274,475,297,-1,505,706,394,-1,304,170,375,-1,295,536,570,-1,268,63,85,-1,485,285,479,-1,638,544,450,-1,131,242,363,-1,207,312,309,-1,752,569,414,-1,1061,940,569,-1,390,955,424,-1,1031,891,1116,-1,997,974,514,-1,759,836,509,-1,815,549,691,-1,234,8,149,-1,533,1163,1046,-1,969,806,984,-1,431,476,748,-1,125,119,252,-1,527,493,470,-1,750,652,973,-1,869,865,704,-1,865,943,806,-1,206,176,8,-1,229,357,721,-1,780,663,531,-1,878,801,715,-1,503,747,515,-1,1178,1208,1197,-1,1200,1137,1178,-1,1166,1139,1197,-1,765,685,783,-1,710,485,705,-1,62,3,22,-1,459,509,451,-1,974,361,514,-1,707,888,962,-1,1084,1014,975,-1,1065,1054,1074,-1,613,677,620,-1,457,640,382,-1,1000,1039,1019,-1,481,876,948,-1,712,1032,976,-1,649,642,691,-1,1099,1001,1129,-1,941,1052,849,-1,1099,1052,1001,-1,864,908,734,-1,1036,1040,981,-1,928,561,793,-1,1130,1171,1165,-1,983,826,958,-1,1048,1041,1020,-1,945,1109,835,-1,965,994,935,-1,935,873,936,-1,873,741,571,-1,741,958,826,-1,145,741,366,-1,1006,1011,1028,-1,1095,909,1064,-1,1068,1120,1064,-1,891,1031,993,-1,1209,1116,1136,-1,955,1209,1167,-1,868,1100,915,-1,295,475,274,-1,536,394,706,-1,567,637,581,-1,840,919,1100,-1,1005,772,899,-1,1100,1059,1025,-1,984,1062,1125,-1,1116,1053,1122,-1,1046,1122,1053,-1,745,1024,945,-1,832,795,664,-1,819,832,889,-1,860,1060,921,-1,875,949,921,-1,804,686,747,-1,734,729,864,-1,976,1081,872,-1,1032,1149,1173,-1,1189,1173,1107,-1,926,980,773,-1,878,812,880,-1,788,799,786,-1,661,659,782,-1,764,557,490,-1,1204,1200,1210,-1,764,682,1082,-1,1142,1002,857,-1,1098,1142,1168,-1,1126,1034,1113,-1,954,1050,1034,-1,923,1069,942,-1,1069,1091,942,-1,598,578,744,-1,593,599,831,-1,923,580,895,-1,879,1050,954,-1,19,27,62,-1,142,23,304,-1,460,571,142,-1,349,572,419,-1,286,720,784,-1,62,289,188,-1,867,604,954,-1,580,593,881,-1,831,1002,881,-1,895,1069,923,-1,1113,1050,1091,-1,1155,1098,1210,-1,1018,857,820,-1,1018,1082,1168,-1,1168,1082,1072,-1,1210,1200,1166,-1,768,715,557,-1,799,729,760,-1,574,788,744,-1,880,848,870,-1,1202,1194,1189,-1,926,1108,1128,-1,725,658,733,-1,1108,1173,1189,-1,976,1032,1173,-1,864,729,799,-1,875,778,949,-1,875,903,804,-1,889,911,906,-1,819,839,966,-1,966,979,1162,-1,1024,1185,1109,-1,1127,1062,984,-1,794,1053,891,-1,1116,891,1053,-1,868,1126,1100,-1,1078,1204,1072,-1,570,772,1005,-1,1005,899,1078,-1,1045,840,1025,-1,570,682,490,-1,631,772,672,-1,919,915,1100,-1,955,845,1031,-1,740,993,1031,-1,1203,1120,1110,-1,1095,1064,1120,-1,1028,1011,936,-1,366,741,826,-1,929,741,873,-1,835,718,945,-1,983,991,989,-1,1043,805,825,-1,1083,1183,1171,-1,918,1052,908,-1,734,830,642,-1,992,1052,1099,-1,1099,1070,992,-1,549,253,651,-1,651,253,213,-1,213,712,651,-1,559,948,1032,-1,712,697,1032,-1,569,940,481,-1,842,691,642,-1,523,714,640,-1,707,504,663,-1,576,528,583,-1,851,1029,1129,-1,531,694,780,-1,780,975,1014,-1,924,1051,1015,-1,924,1084,975,-1,188,451,509,-1,924,770,380,-1,419,685,479,-1,783,722,829,-1,814,776,765,-1,845,390,740,-1,1210,1166,1155,-1,1208,1151,1197,-1,632,919,629,-1,297,664,375,-1,1112,1194,1202,-1,707,714,523,-1,603,837,851,-1,622,531,663,-1,704,806,723,-1,869,717,897,-1,470,493,679,-1,652,537,815,-1,412,652,543,-1,119,125,176,-1,973,815,1090,-1,1101,1143,997,-1,650,1107,721,-1,1127,943,748,-1,806,969,996,-1,252,385,674,-1,842,815,691,-1,1019,1090,815,-1,181,253,549,-1,213,76,8,-1,544,558,468,-1,740,397,468,-1,481,309,414,-1,917,752,511,-1,346,512,480,-1,479,685,705,-1,713,637,672,-1,170,231,274,-1,12,56,142,-1,12,142,145,-1,14,145,70,-1,26,45,54,-1,505,310,380,-1,505,770,742,-1,460,745,718,-1,1073,1110,1109,-1,909,913,1006,-1,451,485,710,-1,1089,1066,1203,-1,138,413,325,-1,433,826,977,-1,719,635,473,-1,825,325,413,-1,928,856,680,-1,1111,754,1009,-1,575,1056,907,-1,1083,1036,1033,-1,1215,1104,1115,-1,1138,1188,1169,-1,1104,1169,1135,-1,1147,1182,1164,-1,907,1105,807,-1,884,1174,1150,-1,415,907,807,-1,930,808,428,-1,338,243,604,-1,364,593,580,-1,364,200,329,-1,320,98,95,-1,7,98,66,-1,396,329,196,-1,58,16,120,-1,656,448,454,-1,656,499,448,-1,434,426,455,-1,578,484,427,-1,354,395,399,-1,29,21,15,-1,90,103,291,-1,563,498,430,-1,29,133,103,-1,133,38,187,-1,378,434,463,-1,271,437,339,-1,359,404,377,-1,404,251,377,-1,251,132,50,-1,118,192,296,-1,108,137,74,-1,500,189,284,-1,79,344,116,-1,161,173,169,-1,123,16,139,-1,209,443,645,-1,139,316,209,-1,698,821,761,-1,645,711,728,-1,567,551,631,-1,645,885,821,-1,185,474,367,-1,96,11,108,-1,122,11,96,-1,307,258,122,-1,278,210,171,-1,789,393,465,-1,348,465,292,-1,296,636,410,-1,383,416,151,-1,157,124,146,-1,343,279,378,-1,343,160,279,-1,160,341,225,-1,446,273,215,-1,585,587,446,-1,117,225,148,-1,696,594,553,-1,461,553,594,-1,518,939,553,-1,187,267,655,-1,187,516,518,-1,735,281,646,-1,370,386,565,-1,751,584,507,-1,552,709,508,-1,583,749,662,-1,89,182,362,-1,432,521,683,-1,193,222,432,-1,447,141,318,-1,684,1038,716,-1,843,823,318,-1,435,387,494,-1,372,388,387,-1,435,439,401,-1,474,818,827,-1,59,116,140,-1,91,161,78,-1,17,64,6,-1,629,376,632,-1,824,554,887,-1,21,107,50,-1,689,507,508,-1,362,384,603,-1,552,683,622,-1,497,403,540,-1,93,241,483,-1,333,224,326,-1,93,326,224,-1,1023,959,1030,-1,422,653,796,-1,1023,1093,1097,-1,183,422,535,-1,224,263,82,-1,110,217,564,-1,244,403,497,-1,500,822,964,-1,510,422,370,-1,195,370,422,-1,986,1206,1140,-1,901,827,818,-1,667,746,657,-1,803,905,735,-1,319,401,439,-1,693,920,998,-1,998,1035,824,-1,1077,1157,1199,-1,1076,1199,1213,-1,1146,1076,1201,-1,1159,1195,1191,-1,693,472,447,-1,447,823,693,-1,469,912,756,-1,60,118,74,-1,218,303,307,-1,731,753,660,-1,11,130,108,-1,894,785,1080,-1,577,266,393,-1,732,641,489,-1,894,383,335,-1,541,335,232,-1,220,440,106,-1,562,315,165,-1,180,87,127,-1,675,669,1016,-1,562,630,802,-1,411,315,802,-1,80,41,330,-1,411,112,315,-1,46,32,68,-1,104,55,0,-1,0,114,104,-1,190,282,449,-1,127,184,180,-1,562,165,575,-1,440,381,106,-1,335,785,894,-1,641,635,489,-1,393,789,577,-1,785,982,1080,-1,753,925,1038,-1,11,152,130,-1,660,502,731,-1,1152,861,947,-1,60,74,137,-1,236,135,118,-1,756,488,469,-1,823,904,693,-1,925,1055,1153,-1,1159,1158,1195,-1,1076,1214,1201,-1,1076,1077,1199,-1,222,447,472,-1,810,693,998,-1,551,634,501,-1,517,542,736,-1,319,355,401,-1,703,464,298,-1,735,646,803,-1,746,818,474,-1,667,766,746,-1,1140,1003,986,-1,195,422,183,-1,791,730,978,-1,500,284,822,-1,211,244,497,-1,495,110,564,-1,82,93,224,-1,183,535,241,-1,1023,1049,1093,-1,676,535,796,-1,422,796,535,-1,1030,1140,1023,-1,326,486,333,-1,93,483,326,-1,217,15,259,-1,403,389,540,-1,622,614,552,-1,600,362,603,-1,254,264,126,-1,50,15,21,-1,498,458,395,-1,629,392,376,-1,64,97,6,-1,78,51,91,-1,66,47,7,-1,474,827,367,-1,435,444,439,-1,494,542,435,-1,736,542,798,-1,823,447,318,-1,684,753,1038,-1,447,222,141,-1,222,521,432,-1,521,701,683,-1,356,89,362,-1,264,507,288,-1,662,607,576,-1,662,576,583,-1,508,328,552,-1,751,507,689,-1,370,565,510,-1,370,216,386,-1,735,340,281,-1,187,655,516,-1,518,1003,939,-1,553,939,696,-1,148,34,117,-1,117,160,225,-1,565,386,482,-1,343,341,160,-1,43,31,127,-1,416,186,151,-1,428,307,303,-1,296,488,636,-1,789,465,854,-1,211,94,244,-1,218,307,147,-1,307,379,258,-1,96,147,122,-1,108,74,96,-1,185,223,474,-1,185,367,262,-1,116,300,376,-1,551,443,631,-1,728,539,645,-1,139,398,316,-1,209,123,139,-1,161,169,78,-1,116,59,79,-1,189,324,100,-1,500,324,189,-1,230,156,88,-1,118,60,192,-1,50,240,251,-1,404,331,251,-1,437,467,339,-1,378,463,343,-1,280,133,187,-1,29,38,133,-1,563,430,471,-1,291,239,90,-1,354,368,395,-1,574,578,427,-1,434,455,463,-1,556,452,458,-1,47,13,7,-1,16,123,120,-1,200,95,73,-1,7,95,98,-1,320,95,342,-1,364,329,407,-1,364,580,342,-1,604,608,338,-1,1038,925,1153,-1,428,496,930,-1,415,630,562,-1,198,561,522,-1,1104,1215,1169,-1,1169,1067,1138,-1,1215,1115,1124,-1,767,934,1027,-1,1083,1130,1036,-1,575,907,562,-1,1111,793,754,-1,639,526,644,-1,639,522,526,-1,413,856,825,-1,635,641,473,-1,654,433,977,-1,138,249,413,-1,188,289,451,-1,1203,1117,1089,-1,710,638,451,-1,268,349,63,-1,1073,1109,1185,-1,1109,1068,963,-1,460,304,745,-1,505,380,770,-1,62,167,289,-1,26,20,45,-1,14,2,145,-1,145,1,12,-1,742,770,975,-1,480,199,346,-1,569,481,414,-1,468,450,544,-1,397,390,312,-1,8,234,213,-1,537,181,549,-1,815,842,1019,-1,242,480,459,-1,385,794,674,-1,723,806,996,-1,748,1106,1127,-1,650,999,1107,-1,997,968,1101,-1,973,652,815,-1,119,176,206,-1,652,412,537,-1,470,679,650,-1,968,897,1101,-1,897,968,869,-1,956,1202,999,-1,704,865,806,-1,663,614,622,-1,603,851,600,-1,1087,952,962,-1,1202,1162,1112,-1,812,757,725,-1,919,840,629,-1,1208,1121,1151,-1,1079,1100,1161,-1,390,397,740,-1,814,765,783,-1,829,828,841,-1,783,685,722,-1,924,380,361,-1,492,188,509,-1,924,975,770,-1,924,974,1051,-1,780,694,975,-1,531,513,694,-1,851,1129,855,-1,927,714,952,-1,576,607,560,-1,576,560,528,-1,663,888,707,-1,523,640,457,-1,642,830,842,-1,830,1000,842,-1,940,876,481,-1,697,559,1032,-1,649,651,755,-1,651,649,549,-1,1099,1180,1070,-1,769,587,585,-1,1001,941,769,-1,992,908,1052,-1,918,908,864,-1,866,918,864,-1,1071,1094,1058,-1,1048,1043,825,-1,983,958,991,-1,913,909,784,-1,835,571,718,-1,366,826,433,-1,969,1125,996,-1,1064,909,1006,-1,1120,1203,1095,-1,1117,1203,1110,-1,845,740,1031,-1,391,295,570,-1,631,672,567,-1,490,503,570,-1,475,391,515,-1,1045,779,840,-1,899,817,1078,-1,1078,1072,1005,-1,1126,1161,1100,-1,794,891,674,-1,1110,1073,1117,-1,945,1024,1109,-1,1162,1086,966,-1,966,871,819,-1,875,1060,903,-1,875,747,778,-1,864,799,866,-1,1173,1081,976,-1,1108,1081,1173,-1,733,773,725,-1,1128,980,926,-1,880,812,848,-1,744,578,574,-1,760,786,799,-1,757,763,659,-1,557,764,768,-1,1072,1204,1168,-1,1018,1168,1142,-1,1142,1098,1002,-1,1155,1069,1098,-1,1113,1034,1050,-1,895,1098,1069,-1,831,857,1002,-1,881,895,580,-1,867,608,604,-1,784,409,286,-1,349,419,168,-1,571,145,142,-1,304,460,142,-1,62,188,19,-1,923,573,580,-1,831,881,593,-1,744,800,598,-1,954,1034,867,-1,1126,1113,1161,-1,1168,1210,1098,-1,857,1018,1142,-1,682,1072,1082,-1,1210,1168,1204,-1,764,490,682,-1,760,661,782,-1,786,744,788,-1,880,953,878,-1,961,1007,979,-1,902,877,906,-1,773,733,926,-1,1173,1163,1107,-1,976,872,755,-1,734,670,729,-1,804,747,875,-1,875,921,1060,-1,860,903,1060,-1,819,871,832,-1,832,664,775,-1,718,745,945,-1,1024,1106,1185,-1,1046,1053,794,-1,1046,1149,1122,-1,1116,1122,1136,-1,1125,969,984,-1,868,850,1126,-1,1100,1079,1059,-1,1100,1025,840,-1,567,672,637,-1,536,295,394,-1,295,391,475,-1,1167,917,955,-1,1068,1064,1028,-1,1006,1028,1064,-1,145,571,741,-1,741,929,958,-1,571,835,873,-1,935,929,873,-1,994,991,935,-1,1109,963,835,-1,1020,1043,1048,-1,983,977,826,-1,1130,1083,1171,-1,928,680,561,-1,981,1010,1036,-1,1052,918,849,-1,1052,941,1001,-1,1129,1180,1099,-1,691,549,649,-1,755,651,976,-1,651,712,976,-1,559,481,948,-1,1000,1019,842,-1,640,545,382,-1,1065,995,1054,-1,1084,1087,1014,-1,529,523,457,-1,974,924,361,-1,451,638,459,-1,167,62,22,-1,705,765,710,-1,765,705,685,-1,829,814,783,-1,1045,1137,1200,-1,1197,1155,1166,-1,1137,1154,1178,-1,1178,1197,1139,-1,763,878,715,-1,1062,1024,967,-1,801,557,715,-1,990,859,995,-1,229,721,533,-1,206,8,76,-1,865,813,943,-1,704,717,869,-1,470,543,527,-1,119,385,252,-1,748,668,431,-1,125,346,176,-1,968,893,869,-1,794,385,1046,-1,385,533,1046,-1,974,1143,1051,-1,815,537,549,-1,836,492,509,-1,997,1143,974,-1,390,845,955,-1,569,752,1061,-1,752,414,511,-1,309,327,207,-1,363,207,131,-1,450,459,638,-1,479,705,485,-1,409,268,85,-1,304,375,745,-1,310,505,294,-1,505,700,706,-1,380,19,188,-1,20,26,1,-1,12,1,26,-1,19,9,56,-1,409,647,268,-1,710,727,638,-1,1089,886,1066,-1,1117,960,1089,-1,45,25,44,-1,423,425,413,-1,654,977,896,-1,453,586,602,-1,856,413,425,-1,1138,1171,1183,-1,619,1160,1056,-1,1130,1132,1040,-1,884,1150,1009,-1,1174,1085,1124,-1,1037,1138,1013,-1,1188,1135,1169,-1,1176,907,1056,-1,233,57,113,-1,198,71,246,-1,442,453,423,-1,198,522,639,-1,113,615,365,-1,562,907,415,-1,1174,1181,1085,-1,623,313,615,-1,861,1044,798,-1,1077,756,912,-1,1198,1038,1153,-1,407,593,364,-1,484,598,418,-1,272,98,320,-1,338,164,243,-1,59,162,79,-1,73,95,7,-1,120,454,448,-1,13,16,58,-1,454,539,728,-1,429,556,555,-1,427,484,426,-1,395,322,261,-1,240,208,255,-1,291,471,430,-1,103,133,291,-1,110,38,29,-1,38,61,187,-1,406,339,467,-1,155,287,271,-1,287,155,350,-1,359,331,404,-1,441,554,420,-1,296,192,469,-1,284,109,61,-1,69,109,189,-1,94,156,230,-1,173,116,376,-1,581,634,551,-1,810,885,678,-1,951,761,821,-1,262,298,52,-1,178,281,5,-1,69,100,5,-1,223,185,324,-1,171,147,96,-1,147,307,122,-1,210,218,147,-1,854,636,1076,-1,393,292,465,-1,636,465,348,-1,278,292,277,-1,204,186,248,-1,238,277,245,-1,296,410,236,-1,151,186,163,-1,256,393,266,-1,381,541,232,-1,237,180,205,-1,482,341,343,-1,215,160,117,-1,360,160,273,-1,89,215,117,-1,565,594,696,-1,61,109,187,-1,280,187,553,-1,267,735,655,-1,195,177,216,-1,833,671,584,-1,159,221,154,-1,254,328,508,-1,699,843,214,-1,660,753,684,-1,502,517,731,-1,435,542,517,-1,435,401,387,-1,13,78,169,-1,66,17,67,-1,36,51,78,-1,17,6,36,-1,499,322,452,-1,250,192,156,-1,656,417,322,-1,221,351,226,-1,182,269,384,-1,1140,1206,1023,-1,405,389,403,-1,486,540,389,-1,690,743,724,-1,964,822,1097,-1,781,547,466,-1,1049,874,1093,-1,333,321,224,-1,136,822,284,-1,136,48,822,-1,153,82,214,-1,696,653,422,-1,1206,1063,1021,-1,684,716,462,-1,699,214,263,-1,100,324,185,-1,262,367,827,-1,646,281,178,-1,803,646,464,-1,978,1021,1088,-1,1008,905,901,-1,1088,1008,847,-1,660,791,766,-1,355,372,401,-1,731,517,736,-1,1131,1152,947,-1,645,678,885,-1,912,469,824,-1,810,520,525,-1,887,761,951,-1,1213,1191,1195,-1,1211,1191,1213,-1,1198,1187,1157,-1,947,568,808,-1,118,135,74,-1,753,731,925,-1,667,487,502,-1,319,491,130,-1,1158,1131,1170,-1,790,787,982,-1,577,582,266,-1,635,616,449,-1,602,762,816,-1,1146,854,1076,-1,541,790,785,-1,898,1016,669,-1,619,575,165,-1,175,84,87,-1,440,220,80,-1,201,150,75,-1,104,106,24,-1,315,112,39,-1,932,1103,1156,-1,898,972,1016,-1,610,639,1016,-1,610,1016,606,-1,846,900,615,-1,65,334,101,-1,352,334,65,-1,53,32,46,-1,53,35,32,-1,220,86,80,-1,114,86,220,-1,28,75,43,-1,28,179,75,-1,127,146,184,-1,146,127,31,-1,65,10,30,-1,65,101,10,-1,1156,615,605,-1,615,1156,1103,-1,42,33,40,-1,42,30,33,-1,898,381,440,-1,898,669,381,-1,32,49,68,-1,32,37,49,-1,31,232,146,-1,31,381,232,-1,577,1118,1042,-1,577,789,1118,-1,774,586,588,-1,762,586,774,-1,737,352,846,-1,737,334,352,-1,737,519,334,-1,771,938,937,-1,771,777,938,-1,892,1075,938,-1,892,1042,1075,-1,1170,808,930,-1,1170,1131,808,-1,1044,1152,1193,-1,1044,861,1152,-1,379,355,258,-1,379,372,355,-1,657,130,491,-1,657,257,130,-1,1191,1212,1159,-1,1212,1191,1211,-1,1092,1134,1096,-1,1134,1092,1141,-1,1077,1207,1157,-1,1077,1192,1207,-1,472,521,222,-1,521,472,524,-1,920,1035,998,-1,1017,1035,920,-1,551,477,443,-1,551,501,477,-1,874,781,1093,-1,702,781,874,-1,847,746,766,-1,847,818,746,-1,939,1140,1030,-1,939,1003,1140,-1,964,299,500,-1,299,964,739,-1,211,534,259,-1,211,497,534,-1,93,183,241,-1,82,183,93,-1,224,373,263,-1,373,224,321,-1,405,456,321,-1,456,405,547,-1,796,743,676,-1,853,743,796,-1,94,259,15,-1,94,211,259,-1,853,564,743,-1,853,495,564,-1,987,495,853,-1,673,495,987,-1,288,126,264,-1,159,126,288,-1,749,613,833,-1,583,613,749,-1,90,107,21,-1,158,107,90,-1,192,420,469,-1,250,420,192,-1,467,728,711,-1,467,437,728,-1,115,6,97,-1,115,91,6,-1,161,115,140,-1,91,115,161,-1,703,262,792,-1,298,262,703,-1,487,319,439,-1,487,491,319,-1,388,494,387,-1,388,532,494,-1,1212,1055,1193,-1,1212,1153,1055,-1,144,318,141,-1,318,144,202,-1,614,709,552,-1,709,614,609,-1,538,384,269,-1,548,384,538,-1,507,254,508,-1,264,254,507,-1,662,833,751,-1,662,749,833,-1,126,222,193,-1,222,126,141,-1,89,191,182,-1,89,34,191,-1,655,905,890,-1,735,905,655,-1,587,273,446,-1,273,587,590,-1,341,386,225,-1,341,482,386,-1,335,146,232,-1,157,146,335,-1,49,127,87,-1,49,43,127,-1,166,163,194,-1,166,124,163,-1,245,194,235,-1,194,245,219,-1,248,428,303,-1,496,428,248,-1,171,236,278,-1,135,236,171,-1,152,122,258,-1,152,11,122,-1,324,108,223,-1,324,137,108,-1,398,627,626,-1,398,436,627,-1,821,711,645,-1,698,711,821,-1,16,169,139,-1,16,13,169,-1,251,305,377,-1,251,240,305,-1,441,337,406,-1,441,350,337,-1,353,280,461,-1,353,133,280,-1,566,471,506,-1,471,566,563,-1,290,308,305,-1,314,308,290,-1,314,332,308,-1,399,374,369,-1,261,374,399,-1,255,305,240,-1,255,290,305,-1,158,208,107,-1,208,158,255,-1,271,417,437,-1,271,270,417,-1,448,556,429,-1,499,556,448,-1,499,452,556,-1,123,454,120,-1,123,539,454,-1,329,73,196,-1,329,200,73,-1,200,342,95,-1,342,200,364,-1,634,524,525,-1,634,665,524,-1,1114,930,933,-1,930,1114,1170,-1,807,313,415,-1,863,313,807,-1,858,313,863,-1,858,365,313,-1,807,1133,863,-1,1105,1133,807,-1,301,695,811,-1,301,478,695,-1,425,526,680,-1,400,526,425,-1,1013,1169,1215,-1,1013,1067,1169,-1,1138,1186,1171,-1,1138,1037,1186,-1,1071,1083,1033,-1,1183,1083,1071,-1,1205,1148,1184,-1,1205,1119,1148,-1,615,57,605,-1,113,57,615,-1,1181,1172,1175,-1,1181,1184,1172,-1,793,317,754,-1,793,561,317,-1,323,719,473,-1,323,579,719,-1,423,265,442,-1,265,423,249,-1,128,265,121,-1,265,128,276,-1,105,121,138,-1,105,81,121,-1,805,286,283,-1,720,286,805,-1,289,285,485,-1,285,289,167,-1,797,681,647,-1,797,828,681,-1,913,988,1006,-1,913,970,988,-1,3,26,54,-1,4,26,3,-1,81,128,121,-1,77,128,81,-1,9,142,56,-1,9,23,142,-1,694,742,975,-1,692,742,694,-1,54,22,3,-1,63,22,54,-1,242,199,480,-1,131,199,242,-1,424,414,309,-1,414,424,511,-1,76,253,181,-1,76,213,253,-1,916,252,674,-1,476,252,916,-1,679,996,956,-1,679,723,996,-1,1090,1101,973,-1,1101,1090,1143,-1,836,968,997,-1,893,968,836,-1,758,813,893,-1,668,813,758,-1,470,412,543,-1,412,470,357,-1,956,1125,1202,-1,956,996,1125,-1,650,357,470,-1,650,721,357,-1,888,780,1014,-1,780,888,663,-1,859,1026,914,-1,859,990,1026,-1,613,528,382,-1,528,613,583,-1,1112,1128,1194,-1,1128,1112,1057,-1,795,1024,745,-1,1024,795,967,-1,490,747,503,-1,490,778,747,-1,1208,1102,1121,-1,1208,1123,1102,-1,1102,1059,1079,-1,1059,1102,1123,-1,955,511,424,-1,511,955,917,-1,886,727,776,-1,886,726,727,-1,722,828,829,-1,722,681,828,-1,188,514,361,-1,514,188,492,-1,1039,1051,1019,-1,1015,1051,1039,-1,622,513,531,-1,622,628,513,-1,589,851,855,-1,589,600,851,-1,523,504,707,-1,523,529,504,-1,560,529,457,-1,560,607,529,-1,1026,1129,1029,-1,1026,1180,1129,-1,309,559,327,-1,559,309,481,-1,1122,1032,948,-1,1032,1122,1149,-1,769,589,855,-1,769,585,589,-1,918,809,849,-1,809,918,866,-1,1033,1094,1071,-1,1033,1047,1094,-1,1041,1047,1022,-1,1041,1094,1047,-1,1022,991,994,-1,989,991,1022,-1,909,797,784,-1,909,834,797,-1,936,965,935,-1,936,1011,965,-1,627,817,626,-1,627,779,817,-1,503,391,570,-1,391,503,515,-1,1045,1204,1078,-1,1045,1200,1204,-1,1073,674,891,-1,674,1073,916,-1,1185,916,1073,-1,1106,916,1185,-1,967,966,1086,-1,966,967,871,-1,911,860,921,-1,911,889,860,-1,809,799,788,-1,866,799,809,-1,733,648,708,-1,658,648,733,-1,911,902,906,-1,911,883,902,-1,949,910,921,-1,946,910,949,-1,902,870,922,-1,902,883,870,-1,906,961,979,-1,961,906,877,-1,922,848,971,-1,870,848,922,-1,661,757,659,-1,658,757,661,-1,658,725,757,-1,1154,1208,1178,-1,1208,1154,1123,-1,782,1018,820,-1,1018,782,768,-1,857,800,820,-1,800,857,831,-1,692,637,700,-1,692,550,637,-1,438,591,445,-1,438,592,591,-1,742,700,505,-1,742,692,700,-1,942,573,923,-1,942,597,573,-1,820,744,786,-1,744,820,800,-1,850,1034,1126,-1,867,1034,850,-1,670,658,661,-1,670,648,658,-1,946,878,953,-1,878,946,801,-1,979,1112,1162,-1,1007,1112,979,-1,870,844,880,-1,870,883,844,-1,883,921,910,-1,883,911,921,-1,708,926,733,-1,708,872,926,-1,649,872,708,-1,755,872,649,-1,788,595,809,-1,788,574,595,-1,832,967,795,-1,871,967,832,-1,621,850,868,-1,621,611,850,-1,629,779,627,-1,629,840,779,-1,706,738,536,-1,738,706,713,-1,876,1209,1136,-1,876,940,1209,-1,909,957,834,-1,1095,957,909,-1,965,1006,988,-1,965,1011,1006,-1,720,1043,970,-1,720,805,1043,-1,991,929,935,-1,991,958,929,-1,1048,1094,1041,-1,1048,1058,1094,-1,981,977,983,-1,981,896,977,-1,1010,1033,1036,-1,1047,1033,1010,-1,596,809,595,-1,596,849,809,-1,849,590,941,-1,849,596,590,-1,1129,769,855,-1,769,1129,1001,-1,1070,1039,1000,-1,1070,1065,1039,-1,382,677,613,-1,382,545,677,-1,545,944,677,-1,944,545,914,-1,529,609,504,-1,607,609,529,-1,859,714,927,-1,640,714,859,-1,603,666,837,-1,603,612,666,-1,419,285,168,-1,419,479,285,-1,468,960,740,-1,468,558,960,-1,1059,1154,1137,-1,1059,1123,1154,-1,1155,1151,1113,-1,1155,1197,1151,-1,778,557,801,-1,778,490,557,-1,795,375,664,-1,745,375,795,-1,1057,980,1128,-1,980,1057,971,-1,1029,914,1026,-1,944,914,1029,-1,962,1014,1087,-1,962,888,1014,-1,346,8,176,-1,346,199,8,-1,493,723,679,-1,493,704,723,-1,897,973,1101,-1,897,750,973,-1,260,76,181,-1,260,206,76,-1,813,748,943,-1,813,668,748,-1,813,869,893,-1,869,813,865,-1,748,916,1106,-1,748,476,916,-1,759,459,480,-1,759,509,459,-1,1143,1019,1051,-1,1143,1090,1019,-1,397,207,363,-1,397,312,207,-1,776,710,765,-1,776,727,710,-1,274,394,295,-1,274,231,394,-1,713,700,637,-1,700,713,706,-1,310,197,212,-1,310,294,197,-1,513,692,694,-1,550,692,513,-1,25,77,81,-1,18,77,25,-1,14,20,2,-1,14,18,20,-1,27,12,4,-1,56,12,27,-1,886,957,1066,-1,886,852,957,-1,349,647,681,-1,268,647,349,-1,544,726,558,-1,544,727,726,-1,825,283,325,-1,283,825,805,-1,44,81,105,-1,44,25,81,-1,138,265,249,-1,121,265,138,-1,276,442,265,-1,442,276,445,-1,579,934,719,-1,896,934,579,-1,445,588,442,-1,588,445,591,-1,433,70,366,-1,102,70,433,-1,1171,1177,1165,-1,1171,1186,1177,-1,754,246,884,-1,754,317,246,-1,1175,1186,1181,-1,1177,1186,1175,-1,862,246,233,-1,884,246,862,-1,1184,1133,1172,-1,1184,1148,1133,-1,1027,1040,1132,-1,1027,934,1040,-1,793,1188,1183,-1,793,1111,1188,-1,1013,1085,1037,-1,1085,1013,1012,-1,1215,1012,1013,-1,1215,1124,1012,-1,526,561,680,-1,526,522,561,-1,644,400,602,-1,644,526,400,-1,1148,863,1133,-1,1148,858,863,-1,113,478,301,-1,113,365,478,-1,581,665,634,-1,581,625,665,-1,1211,1153,1212,-1,1211,1187,1153,-1,243,601,604,-1,601,243,336,-1,598,407,418,-1,598,599,407,-1,164,272,336,-1,129,272,164,-1,111,164,162,-1,129,164,111,-1,58,196,73,-1,58,120,196,-1,563,546,555,-1,563,566,546,-1,322,270,261,-1,417,270,322,-1,107,240,50,-1,240,107,208,-1,369,354,399,-1,369,332,354,-1,287,332,306,-1,287,308,332,-1,291,506,471,-1,291,353,506,-1,353,594,506,-1,594,353,461,-1,595,427,408,-1,595,574,427,-1,371,350,441,-1,371,359,350,-1,554,406,530,-1,406,554,441,-1,267,69,340,-1,267,109,69,-1,626,316,398,-1,633,316,626,-1,624,344,621,-1,300,344,624,-1,5,185,262,-1,5,100,185,-1,223,257,474,-1,108,257,223,-1,218,238,228,-1,218,210,238,-1,186,496,248,-1,186,416,496,-1,292,245,277,-1,292,256,245,-1,204,194,163,-1,204,235,194,-1,219,166,194,-1,219,205,166,-1,87,68,49,-1,68,87,84,-1,175,311,282,-1,237,311,175,-1,177,148,216,-1,177,154,148,-1,538,833,613,-1,538,671,833,-1,269,671,538,-1,302,671,269,-1,609,688,709,-1,688,609,607,-1,507,351,288,-1,351,507,584,-1,548,603,384,-1,548,612,603,-1,202,154,177,-1,144,154,202,-1,643,532,861,-1,494,532,643,-1,47,36,13,-1,67,36,47,-1,64,66,111,-1,64,17,66,-1,656,437,417,-1,656,728,437,-1,824,420,554,-1,420,824,469,-1,239,158,90,-1,247,158,239,-1,302,182,191,-1,182,302,269,-1,193,254,126,-1,193,328,254,-1,1206,874,1049,-1,1206,1021,874,-1,497,724,534,-1,497,540,724,-1,959,853,796,-1,987,853,959,-1,739,1093,781,-1,739,964,1093,-1,547,702,456,-1,702,547,781,-1,172,99,466,-1,99,172,88,-1,299,466,99,-1,299,739,466,-1,696,1030,653,-1,696,939,1030,-1,263,716,699,-1,716,263,373,-1,178,298,464,-1,52,298,178,-1,702,1021,730,-1,702,874,1021,-1,1008,818,847,-1,1008,901,818,-1,502,439,444,-1,502,487,439,-1,428,568,421,-1,428,808,568,-1,443,678,645,-1,443,477,678,-1,1017,912,1035,-1,1017,1192,912,-1,1017,904,1004,-1,1017,920,904,-1,524,701,521,-1,701,524,665,-1,1141,1190,1134,-1,1190,1141,1196,-1,1195,1201,1214,-1,1195,1196,1201,-1,1199,1187,1211,-1,1187,1199,1157,-1,258,319,152,-1,258,355,319,-1,568,861,532,-1,861,568,947,-1,491,667,657,-1,491,487,667,-1,933,383,894,-1,416,383,933,-1,1134,1170,1114,-1,1134,1190,1170,-1,950,1080,982,-1,1080,950,1096,-1,774,937,950,-1,771,937,774,-1,282,582,489,-1,582,282,311,-1,588,771,774,-1,591,771,588,-1,1146,789,854,-1,789,1146,1118,-1,37,43,49,-1,37,28,43,-1,972,440,330,-1,972,898,440,-1,28,40,33,-1,40,28,37,-1,972,347,985,-1,347,972,330,-1,83,30,42,-1,83,65,30,-1,175,190,84,-1,175,282,190,-1,92,114,0,-1,92,86,114,-1,86,41,80,-1,86,92,41,-1,150,24,75,-1,150,55,24,-1,203,0,201,-1,203,92,0,-1,165,35,53,-1,165,39,35,-1,972,1156,1145,-1,972,985,1156,-1,816,787,790,-1,787,816,762,-1,101,519,402,-1,334,519,101,-1,802,623,900,-1,802,630,623,-1,30,41,33,-1,30,10,41,-1,737,1103,932,-1,737,846,1103,-1,345,65,83,-1,345,352,65,-1,816,644,602,-1,816,687,644,-1,669,687,541,-1,669,675,687,-1,106,114,220,-1,104,114,106,-1,134,201,179,-1,203,201,134,-1,24,381,31,-1,24,106,381,-1,10,402,347,-1,101,402,10,-1,985,402,932,-1,402,985,347,-1,39,40,35,-1,42,40,39,-1,46,619,53,-1,619,46,617,-1,33,179,28,-1,33,134,179,-1,68,617,46,-1,617,68,618,-1,675,644,687,-1,644,675,639,-1,582,1042,892,-1,582,577,1042,-1,592,732,777,-1,641,732,592,-1,618,84,190,-1,68,84,618,-1,777,892,938,-1,732,892,777,-1,937,1075,1092,-1,937,938,1075,-1,1152,1158,1159,-1,1158,1152,1131,-1,931,1193,1055,-1,1193,931,1044,-1,388,379,421,-1,379,388,372,-1,823,1207,1004,-1,823,1198,1207,-1,1075,1141,1092,-1,1141,1075,1144,-1,1144,1042,1118,-1,1042,1144,1075,-1,1004,1192,1017,-1,1192,1004,1207,-1,887,998,824,-1,887,951,998,-1,525,501,634,-1,520,501,525,-1,810,951,885,-1,810,998,951,-1,978,766,791,-1,978,847,766,-1,827,905,792,-1,827,901,905,-1,195,82,153,-1,195,183,82,-1,791,462,730,-1,791,684,462,-1,495,48,110,-1,48,495,673,-1,217,534,564,-1,217,259,534,-1,333,405,321,-1,389,405,333,-1,466,405,172,-1,466,547,405,-1,743,534,724,-1,564,534,743,-1,321,462,373,-1,462,321,456,-1,822,987,1097,-1,822,673,987,-1,288,221,159,-1,221,288,351,-1,498,368,430,-1,395,368,498,-1,156,132,250,-1,132,156,94,-1,698,530,467,-1,530,698,761,-1,458,322,395,-1,458,452,322,-1,140,97,59,-1,115,97,140,-1,257,746,474,-1,257,657,746,-1,931,798,1044,-1,931,736,798,-1,202,214,318,-1,202,153,214,-1,159,141,126,-1,141,159,144,-1,620,548,538,-1,612,548,620,-1,226,34,148,-1,191,34,226,-1,890,516,655,-1,1063,516,890,-1,1063,986,516,-1,446,89,356,-1,215,89,446,-1,590,360,273,-1,590,596,360,-1,408,596,595,-1,408,360,596,-1,184,205,180,-1,205,184,166,-1,266,237,227,-1,266,311,237,-1,124,151,163,-1,124,157,151,-1,256,219,245,-1,219,256,227,-1,235,228,238,-1,235,204,228,-1,410,278,236,-1,410,348,278,-1,5,340,69,-1,5,281,340,-1,477,520,678,-1,501,520,477,-1,436,629,627,-1,436,392,629,-1,392,169,173,-1,392,436,169,-1,358,621,344,-1,358,611,621,-1,250,371,420,-1,371,250,331,-1,359,305,308,-1,377,305,359,-1,406,155,339,-1,406,337,155,-1,482,566,565,-1,482,546,566,-1,38,136,61,-1,136,38,48,-1,217,29,15,-1,110,29,217,-1,369,306,332,-1,369,374,306,-1,306,261,270,-1,306,374,261,-1,293,290,255,-1,293,314,290,-1,247,255,158,-1,255,247,293,-1,555,463,455,-1,546,463,555,-1,429,426,396,-1,426,429,455,-1,162,358,79,-1,358,162,338,-1,484,396,426,-1,418,396,484,-1,573,272,320,-1,573,597,272,-1,525,472,693,-1,525,524,472,-1,591,777,771,-1,591,592,777,-1,1174,1184,1181,-1,1174,1205,1184,-1,623,415,313,-1,623,630,415,-1,695,1119,811,-1,1119,695,882,-1,423,400,425,-1,453,400,423,-1,57,246,71,-1,57,233,246,-1,1179,1056,1160,-1,1179,1176,1056,-1,1104,1111,1009,-1,1111,1104,1135,-1,1174,1115,1150,-1,1174,1124,1115,-1,811,1205,862,-1,1205,811,1119,-1,811,233,301,-1,862,233,811,-1,1175,1176,1179,-1,1176,1175,1172,-1,1164,619,617,-1,1164,1160,619,-1,1037,1181,1186,-1,1037,1085,1181,-1,617,1147,1164,-1,618,1147,617,-1,174,579,323,-1,174,654,579,-1,473,592,438,-1,592,473,641,-1,1132,618,1027,-1,618,1132,1147,-1,323,438,275,-1,438,323,473,-1,143,276,128,-1,143,275,276,-1,45,63,54,-1,85,63,45,-1,22,285,167,-1,168,285,22,-1,834,828,797,-1,841,828,834,-1,9,380,212,-1,9,19,380,-1,77,143,128,-1,72,143,77,-1,174,72,102,-1,143,72,174,-1,23,212,197,-1,9,212,23,-1,297,170,274,-1,297,375,170,-1,231,505,394,-1,231,294,505,-1,304,197,170,-1,304,23,197,-1,536,772,570,-1,536,738,772,-1,647,784,797,-1,647,409,784,-1,776,852,886,-1,776,814,852,-1,450,242,459,-1,450,363,242,-1,309,390,424,-1,309,312,390,-1,917,1061,752,-1,1061,917,1167,-1,492,997,514,-1,836,997,492,-1,1163,721,1107,-1,533,721,1163,-1,679,999,650,-1,679,956,999,-1,512,668,758,-1,431,668,512,-1,125,476,431,-1,125,252,476,-1,357,260,412,-1,260,357,229,-1,759,893,836,-1,758,893,759,-1,229,385,119,-1,229,533,385,-1,995,927,1054,-1,859,927,995,-1,848,725,773,-1,725,848,812,-1,1086,1062,967,-1,1125,1062,1086,-1,686,515,747,-1,475,515,686,-1,878,757,812,-1,878,763,757,-1,1121,1079,1161,-1,1079,1121,1102,-1,1178,1166,1200,-1,1166,1178,1139,-1,681,572,349,-1,572,681,722,-1,1065,1015,1039,-1,1015,1065,1074,-1,1084,1054,1087,-1,1074,1054,1084,-1,666,620,677,-1,620,666,612,-1,1180,990,1070,-1,990,1180,1026,-1,697,327,559,-1,697,149,327,-1,697,234,149,-1,896,1040,934,-1,1040,896,981,-1,1147,1130,1165,-1,1132,1130,1147,-1,1047,989,1022,-1,1047,1010,989,-1,1022,1020,1041,-1,1022,994,1020,-1,988,994,965,-1,988,1020,994,-1,936,835,963,-1,936,873,835,-1,960,993,740,-1,993,960,1117,-1,1031,1209,955,-1,1031,1116,1209,-1,868,624,621,-1,624,868,915,-1,899,626,817,-1,626,899,633,-1,1025,1137,1045,-1,1137,1025,1059,-1,1136,948,876,-1,1136,1122,948,-1,804,664,686,-1,775,664,804,-1,906,819,889,-1,906,839,819,-1,860,832,775,-1,860,889,832,-1,648,734,642,-1,648,670,734,-1,1046,1173,1149,-1,1163,1173,1046,-1,1189,999,1202,-1,999,1189,1107,-1,910,844,883,-1,910,838,844,-1,953,910,946,-1,953,838,910,-1,877,922,961,-1,877,902,922,-1,961,971,1057,-1,922,971,961,-1,729,661,760,-1,661,729,670,-1,786,782,820,-1,760,782,786,-1,942,1050,879,-1,1050,942,1091,-1,831,598,800,-1,831,599,598,-1,601,954,604,-1,879,954,601,-1,62,4,3,-1,62,27,4,-1,550,581,637,-1,550,625,581,-1,286,105,283,-1,44,105,286,-1,611,867,850,-1,611,608,867,-1,879,597,942,-1,879,601,597,-1,895,1002,1098,-1,881,1002,895,-1,1113,1069,1155,-1,1091,1069,1113,-1,1082,768,764,-1,768,1082,1018,-1,659,768,782,-1,659,715,768,-1,659,763,715,-1,801,949,778,-1,801,946,949,-1,1007,1057,1112,-1,961,1057,1007,-1,838,880,844,-1,880,838,953,-1,1194,1108,1189,-1,1194,1128,1108,-1,872,1108,926,-1,872,1081,1108,-1,642,708,648,-1,649,708,642,-1,903,775,804,-1,903,860,775,-1,906,966,839,-1,906,979,966,-1,1072,570,1005,-1,1072,682,570,-1,1078,779,1045,-1,1078,817,779,-1,919,624,915,-1,624,919,632,-1,633,772,631,-1,633,899,772,-1,940,1167,1209,-1,940,1061,1167,-1,1117,891,993,-1,1117,1073,891,-1,1095,1066,957,-1,1095,1203,1066,-1,963,1028,936,-1,1028,963,1068,-1,784,970,913,-1,970,784,720,-1,970,1020,988,-1,970,1043,1020,-1,1058,825,856,-1,1048,825,1058,-1,983,1010,981,-1,989,1010,983,-1,1071,856,928,-1,856,1071,1058,-1,830,908,992,-1,830,734,908,-1,941,587,769,-1,590,587,941,-1,712,234,697,-1,712,213,234,-1,995,1070,990,-1,995,1065,1070,-1,1000,992,1070,-1,1000,830,992,-1,914,640,859,-1,640,914,545,-1,382,560,457,-1,382,528,560,-1,962,714,707,-1,714,962,952,-1,837,677,944,-1,677,837,666,-1,504,614,663,-1,609,614,504,-1,924,1074,1084,-1,1015,1074,924,-1,572,685,419,-1,572,722,685,-1,149,207,327,-1,149,131,207,-1,1113,1121,1161,-1,1113,1151,1121,-1,297,686,664,-1,297,475,686,-1,1086,1202,1125,-1,1202,1086,1162,-1,971,773,980,-1,773,971,848,-1,851,944,1029,-1,837,944,851,-1,1087,927,952,-1,927,1087,1054,-1,480,758,759,-1,512,758,480,-1,750,543,652,-1,750,527,543,-1,750,717,527,-1,717,750,897,-1,412,181,537,-1,412,260,181,-1,260,119,206,-1,260,229,119,-1,527,704,493,-1,527,717,704,-1,1127,806,943,-1,806,1127,984,-1,1024,1127,1106,-1,1024,1062,1127,-1,131,8,199,-1,131,149,8,-1,468,363,450,-1,468,397,363,-1,431,346,125,-1,346,431,512,-1,814,841,852,-1,814,829,841,-1,738,672,772,-1,738,713,672,-1,170,294,231,-1,294,170,197,-1,513,625,550,-1,625,513,628,-1,138,283,105,-1,138,325,283,-1,14,102,72,-1,14,70,102,-1,45,18,25,-1,20,18,45,-1,18,72,77,-1,14,72,18,-1,1110,1068,1109,-1,1110,1120,1068,-1,1089,558,726,-1,1089,960,558,-1,852,834,957,-1,852,841,834,-1,63,168,22,-1,63,349,168,-1,409,44,286,-1,409,85,44,-1,143,323,275,-1,143,174,323,-1,275,445,276,-1,275,438,445,-1,858,478,365,-1,882,478,858,-1,882,695,478,-1,586,442,588,-1,442,586,453,-1,102,654,174,-1,102,433,654,-1,928,1183,1071,-1,928,793,1183,-1,1165,1182,1147,-1,1165,1177,1182,-1,884,1205,1174,-1,884,862,1205,-1,1177,1179,1182,-1,1179,1177,1175,-1,605,71,606,-1,57,71,605,-1,1172,1105,1176,-1,1105,1172,1133,-1,767,719,934,-1,767,635,719,-1,616,1027,618,-1,616,767,1027,-1,1115,1009,1150,-1,1009,1115,1104,-1,1182,1160,1164,-1,1182,1179,1160,-1,882,1148,1119,-1,1148,882,858,-1,1077,636,756,-1,1077,1076,636,-1,338,611,358,-1,338,608,611,-1,597,336,272,-1,597,601,336,-1,418,329,396,-1,407,329,418,-1,98,111,66,-1,111,98,129,-1,196,429,396,-1,448,429,196,-1,6,51,36,-1,91,51,6,-1,458,555,556,-1,458,563,555,-1,458,498,563,-1,368,293,247,-1,293,368,354,-1,354,314,293,-1,354,332,314,-1,306,271,287,-1,271,306,270,-1,103,21,29,-1,103,90,21,-1,506,565,566,-1,565,506,594,-1,434,408,427,-1,408,434,378,-1,350,308,287,-1,350,359,308,-1,251,250,132,-1,331,250,251,-1,299,60,137,-1,60,299,99,-1,500,137,324,-1,299,137,500,-1,173,140,116,-1,173,161,140,-1,645,123,209,-1,645,539,123,-1,436,139,169,-1,436,398,139,-1,624,376,300,-1,632,376,624,-1,443,633,631,-1,443,316,633,-1,238,278,277,-1,238,210,278,-1,421,307,428,-1,421,379,307,-1,383,157,335,-1,157,383,151,-1,205,227,237,-1,227,205,219,-1,124,184,146,-1,124,166,184,-1,408,279,360,-1,378,279,408,-1,589,446,356,-1,589,585,446,-1,986,518,516,-1,986,1003,518,-1,148,221,226,-1,148,154,221,-1,225,216,148,-1,225,386,216,-1,584,302,351,-1,671,302,584,-1,751,688,662,-1,751,689,688,-1,709,689,508,-1,709,688,689,-1,362,589,356,-1,362,600,589,-1,701,622,683,-1,701,628,622,-1,153,177,195,-1,177,153,202,-1,699,1038,843,-1,716,1038,699,-1,542,643,798,-1,542,494,643,-1,1008,1063,890,-1,1008,1088,1063,-1,97,111,59,-1,97,64,111,-1,530,887,554,-1,530,761,887,-1,15,132,94,-1,50,132,15,-1,430,247,239,-1,368,247,430,-1,191,351,302,-1,191,226,351,-1,432,328,193,-1,552,328,432,-1,456,730,462,-1,730,456,702,-1,676,483,535,-1,676,690,483,-1,486,483,690,-1,326,483,486,-1,1030,796,653,-1,1030,959,796,-1,1097,959,1023,-1,1097,987,959,-1,540,690,724,-1,540,486,690,-1,403,88,172,-1,230,88,403,-1,88,192,99,-1,88,156,192,-1,803,792,905,-1,703,792,803,-1,1193,1159,1212,-1,1159,1193,1152,-1,843,1198,823,-1,843,1038,1198,-1,625,701,665,-1,628,701,625,-1,933,1080,1114,-1,933,894,1080,-1,1118,1201,1144,-1,1118,1146,1201,-1,1196,1158,1190,-1,1158,1196,1195,-1,1144,1196,1141,-1,1196,1144,1201,-1,228,303,218,-1,228,248,303,-1,532,421,568,-1,532,388,421,-1,931,925,731,-1,1055,925,931,-1,930,416,933,-1,416,930,496,-1,1096,1114,1080,-1,1096,1134,1114,-1,950,1092,1096,-1,937,1092,950,-1,950,787,774,-1,982,787,950,-1,489,892,732,-1,489,582,892,-1,31,75,24,-1,75,31,43,-1,10,330,41,-1,10,347,330,-1,35,37,32,-1,40,37,35,-1,1145,605,606,-1,605,1145,1156,-1,112,42,39,-1,83,42,112,-1,489,449,282,-1,489,635,449,-1,190,616,618,-1,190,449,616,-1,92,134,41,-1,92,203,134,-1,55,201,0,-1,55,150,201,-1,687,790,541,-1,790,687,816,-1,519,932,402,-1,519,737,932,-1,83,411,345,-1,411,83,112,-1,900,411,802,-1,900,345,411,-1,900,352,345,-1,900,846,352,-1],
          coord=Coordinate(DEF='axis_Coord',point=[(0,54.74915,-2.35768),(-.02328,54.74797,-2.39959),(0,54.78218,-2.38669),(-.12526,54.78897,-2.17927),(-.10023,54.81324,-2.22443),(-.14381,54.73204,-2.18302),(-.02328,54.79874,-2.42156),(-.04422,54.83658,-2.42003),(0,54.86434,-2.40753),(-.03414,54.71598,-2.38575),(-.02043,54.69968,-2.3608),(0,54.78877,-2.02645),(-.04019,54.77467,-2.01348),(-.03907,54.77438,-2.10382),(-.09224,54.83042,-1.88334),(-.06721,54.83371,-1.88895),(-.07805,54.91042,-1.89844),(-.07296,54.68465,-2.16878),(-.03648,54.74237,-2.19376),(-.03106,54.71014,-2.28115),(-.06212,54.65262,-2.25626),(-.04085,54.67392,-2.34965),(-.03074,54.93437,-2.37817),(-.04017,54.90144,-2.3625),(-.15953,54.80649,-2.07294),(-.15581,54.78013,-2.0728),(-.14502,54.80771,-2.05172),(-.14384,54.82466,-2.12582),(-.12861,54.84302,-2.08449),(-.12316,54.83066,-2.12786),(-.12357,54.73244,-2.08568),(-.13639,54.71525,-2.15134),(-.12357,54.6719,-2.16327),(-.11547,55.07348,-2.00871),(-.06917,55.16623,-1.99946),(-.08597,55.05629,-2.05998),(-.02534,55.01472,-2.31161),(0,55.05135,-2.32746),(0,54.80009,-2.21874),(-.21567,54.78023,-1.82636),(-.23329,54.78306,-1.8477),(-.13566,54.76928,-1.9193),(0,54.7987,-1.91854),(0,54.84256,-1.904),(-.15093,55.1964,-1.92718),(-.15749,55.18978,-1.93563),(-.23041,55.20284,-1.86881),(-.10298,54.78126,-1.88009),(-.21014,54.82068,-1.83554),(-.41947,54.90777,-1.56191),(-.39749,54.96906,-1.58021),(-.39393,54.97471,-1.4899),(-.81501,55.08763,-1.32166),(-.81764,55.09024,-1.30889),(-.81693,55.15651,-1.30925),(-.80603,55.04759,-1.36658),(-.79805,55.04441,-1.35949),(-.58284,55.10685,-1.20341),(-.69788,55.09667,-1.25624),(-.57804,55.10047,-1.21436),(-.72701,55.18648,-1.48967),(-.7654,55.14705,-1.42264),(-.79148,55.18418,-1.33601),(-.48416,55.34912,-1.52454),(-.45019,55.35196,-1.52105),(-.41001,55.29207,-1.61262),(-.32018,55.28801,-1.23208),(-.34006,55.34854,-1.29215),(-.30466,55.38043,-1.28622),(-.39594,55.25851,-1.27903),(-.36373,55.27544,-1.43938),(-.41002,55.30886,-1.33939),(-.33327,55.15731,-1.42343),(-.34619,55.19704,-1.54649),(-.34886,55.25242,-1.47072),(-.36972,55.07861,-1.53011),(-.34577,55.18239,-1.57079),(-.3614,55.28139,-1.60318),(-.14825,55.39405,-1.27411),(-.23144,55.4046,-1.26493),(-.23514,55.50676,-1.30089),(-.29981,55.40927,-1.30312),(-.39622,55.50452,-1.43227),(-.37778,55.45985,-1.39915),(-.46113,55.41023,-1.46635),(-.40178,54.9103,-1.46754),(-.35965,54.89048,-1.38372),(-.4183,54.88246,-1.45424),(-.49069,55.09807,-1.20688),(-.40494,55.01117,-1.25961),(-.37705,55.0389,-1.26176),(-.61289,54.93487,-1.43532),(-.552,54.9435,-1.35572),(-.64812,54.99205,-1.34787),(-.69275,55.09204,-1.20533),(-.70563,55.08548,-1.18439),(-.61882,55.11035,-1.15261),(-.68251,55.10246,-1.11578),(-.7227,55.05632,-1.13596),(-.74838,55.04095,-1.10117),(-.81304,54.99566,-1.1381),(-.6093,55.12791,-1.16438),(-.67969,55.11716,-1.11605),(-.89984,54.96509,-1.17011),(-.86619,54.96644,-1.14341),(-.91679,54.96398,-1.15687),(-.95859,54.98768,-1.12297),(-.88133,54.97503,-1.12752),(-.83004,55.03153,-1.20405),(-.86764,55.00244,-1.19191),(-.93174,55.03085,-1.22891),(-.38368,55.23466,-1.04705),(-.39663,55.25421,-1.03857),(-.41936,55.23149,-1.10744),(-.46352,55.18016,-1.15186),(-.47401,55.19508,-1.14681),(-.53199,55.16672,-1.16553),(-.69976,55.0941,-1.04415),(-.44719,55.25963,-.87673),(-.55225,55.27116,-.87714),(-.45034,55.25791,-.89308),(-.70059,55.10738,-1.04354),(-.70186,55.10674,-1.02708),(-.7985,55.32255,-1.05956),(-.79215,55.32085,-1.06304),(-.81283,55.27637,-1.06731),(-.76052,55.35293,-1.2823),(-.7561,55.35771,-1.26472),(-.77541,55.36157,-1.27256),(-.72021,55.28893,-1.25157),(-.73958,55.23311,-1.21417),(-.70232,55.19231,-1.20685),(-.79098,55.22217,-1.16073),(-.77789,55.23503,-1.03561),(-.77453,55.17495,-1.12859),(-.5988,55.40546,-1.09226),(-.61259,55.34262,-.99908),(-.69838,55.36626,-1.05152),(-.44997,55.34925,-1.01902),(-.53083,55.31319,-.95261),(-.53064,55.41121,-1.08234),(-.64703,55.34428,-1.22634),(-.57779,55.32466,-1.19709),(-.58335,55.39076,-1.17204),(-.7295,55.33487,-1.26903),(-.6176,55.25792,-1.23025),(-.73504,55.13891,-1.08583),(-.72514,55.19379,-1.00005),(-.09209,54.97259,-.65103),(-.09657,54.97966,-.6381),(-.1528,55.01839,-.67732),(-.09333,55.05261,-1.19313),(-.1105,55.03562,-1.17802),(-.12019,55.05093,-1.18981),(-.37952,55.73192,-.93446),(-.35269,55.74369,-1.05344),(-.38847,55.72964,-.93868),(-.33625,55.69684,-1.25255),(-.34698,55.69892,-1.24912),(-.33659,55.69949,-1.24901),(-.20466,55.93377,-1.19808),(-.19534,55.96089,-1.14609),(-.20681,56.03334,-1.14822),(-.17665,55.93626,-1.25513),(-.17565,55.89028,-1.19209),(-.16828,55.93445,-1.11949),(-.19156,56.04027,-1.11526),(-.55842,54.98256,-1.30696),(-.47841,55.05062,-1.23751),(-.55462,55.05171,-1.26372),(-.59757,55.11735,-1.16769),(-.52364,55.15,-1.16765),(-.37604,55.22835,-1.15973),(-.32244,55.20759,-1.1049),(-.04076,55.08509,-.94665),(-.04231,55.05455,-1.05414),(0,55.05766,-1.05028),(-.27823,55.13739,-.99614),(-.23613,55.07732,-1.00279),(-.28649,55.12974,-.92947),(0,55.02062,-.71215),(-.09916,55.00714,-.72567),(0,55.10987,-.79856),(-.07641,55.08579,-.8464),(-.16917,55.057,-.9197),(-.11043,55.07109,-.93075),(-.35775,55.21205,-.86571),(-.43017,55.25008,-.88313),(-.39726,55.23893,-.95854),(-.85619,55.14939,-1.01518),(-.90159,55.08174,-1.04708),(-.84478,55.00348,-1.10524),(-.78415,55.22759,-.95607),(-.70712,55.17903,-.93512),(-.6567,55.25805,-.87036),(-.87108,55.18817,-1.06503),(-.70903,55.30205,-.86508),(-.64476,55.32001,-.82816),(-.46659,55.36466,-.81292),(-.2062,55.21756,-.71696),(-.21867,55.11059,-.73643),(-.20621,55.07517,-.65146),(-.16762,55.17948,-.62988),(-.11099,55.27959,-.62295),(-.14199,55.27766,-.69694),(-.08822,55.36712,-.66019),(-.17732,55.39497,-.71234),(-.16986,55.16122,-1.93623),(-.12357,54.77026,-1.99826),(-.08072,54.78106,-2.00293),(-.33516,55.2022,-1.78619),(-.24865,55.17236,-1.86884),(-.42284,54.88063,-1.68792),(-.43653,54.95136,-1.72821),(-.34138,54.91538,-1.79894),(-.65699,55.21427,-1.52987),(-.72988,55.25117,-1.40081),(-.59256,55.31151,-1.50524),(-.38464,55.13251,-1.78344),(-.43349,55.02879,-1.75985),(-.52202,55.05411,-1.70447),(-.51819,54.97993,-1.67497),(-.49145,54.90726,-1.62074),(-.57285,55.1712,-1.63583),(-.44421,55.23844,-1.66961),(-.41304,55.22377,-1.7055),(-.50351,55.28606,-1.59223),(-.30756,55.23407,-1.78242),(-.33964,55.25709,-1.69731),(-.37055,55.25981,-1.69874),(-.73564,55.06748,-1.52918),(-.69016,55.10063,-1.57073),(-.6245,55.08455,-1.63121),(-.96485,55.05473,-1.15134),(-.9671,54.99251,-1.15359),(-.07643,56.15248,-1.3602),(-.10028,56.09657,-1.34407),(-.073,56.19436,-1.33557),(-.32408,55.56197,-1.36033),(-.27037,55.64877,-1.28216),(-.25632,55.60441,-1.31204),(-.15856,55.51844,-1.30256),(-.18519,55.5921,-1.26349),(0,55.38535,-1.26904),(-.05483,55.51065,-1.31886),(0,55.48848,-1.31581),(-.07577,56.06372,-1.37749),(-.07059,55.99156,-1.35525),(-.1363,56.01629,-1.32336),(-.08042,55.69871,-1.26379),(-.06887,55.62192,-1.28475),(-.15029,55.71917,-1.21013),(-.12846,56.20117,-1.25783),(-.05912,56.25938,-1.25279),(-.80943,55.40683,-1.29138),(-.93095,55.13406,-1.10949),(-.87432,55.21879,-1.12959),(-.93005,55.14287,-1.18719),(-.82612,55.26611,-1.08543),(-.82956,55.25469,-1.02712),(-.8226,55.27556,-1.06584),(-.75512,55.28036,-1.33254),(-.73604,55.2946,-1.26411),(-.67654,55.38788,-1.41175),(-.53049,55.43005,-1.46855),(-.48075,55.54168,-1.37522),(-.5341,55.4379,-1.46142),(-.57426,55.47901,-1.3934),(-.59786,55.54831,-1.29698),(-.68602,55.47206,-1.33317),(-.50868,55.64782,-1.18539),(-.52269,55.6168,-1.24549),(-.55564,55.57969,-1.27932),(-.4095,55.70976,-1.14336),(-.42962,55.68312,-1.20311),(-.34214,55.62649,-1.32957),(-.44723,55.6173,-1.29862),(-.2459,55.53051,-.78739),(-.33467,55.49549,-.80178),(-.34069,55.39578,-.80254),(-.25138,55.41316,-.77441),(-.79336,55.36822,-1.08594),(-.78554,55.3262,-.98081),(-.73226,55.36107,-.8805),(-.66993,55.38891,-.83223),(-.68767,55.48042,-.8448),(-.59056,55.5893,-.82618),(-.69916,55.54022,-.86744),(-.4358,55.69419,-.98529),(-.49549,55.65695,-.90967),(-.48161,55.63665,-.84508),(-.06395,55.55014,-.74087),(-.15923,55.64121,-.7833),(-.15251,55.54062,-.77415),(-.24233,55.68621,-.85774),(-.3474,55.59536,-.8158),(-.24668,55.62257,-.80918),(-.34688,55.74863,-1.13891),(-.27548,55.7241,-1.02761),(-.16684,55.85018,-1.06789),(-.15101,55.90346,-1.08052),(-.19192,55.7931,-.94596),(-.22208,55.78414,-1.04915),(-.27338,55.72566,-.9191),(-.14582,55.86581,-.96249),(-.14209,56.13771,-1.23702),(-.16289,56.11998,-1.16151),(-.10347,56.19465,-1.18096),(-.0433,56.24235,-1.17269),(-.09609,56.15737,-1.08587),(-.08305,56.11258,-1.0115),(-.1162,56.10227,-1.05702),(-.13344,56.02791,-1.00754),(-.0648,55.65668,-.77016),(0,55.66096,-.76344),(0,55.76465,-.79721),(-.0598,55.80206,-.86746),(0,55.80909,-.83293),(0,55.85268,-.85825),(-.06363,55.93879,-.92029),(0,56.03521,-.9443),(-.09298,56.03238,-.97116),(0,55.93262,-.88504),(-.04565,56.21804,-1.08962),(-.04754,56.16646,-1.03431),(-.36243,55.14414,-1.29616),(-.36301,55.20334,-1.36074),(-.4241,55.35922,-1.39975),(-.38062,55.32867,-1.49738),(-.36467,54.96259,-1.30835),(-.40143,54.9179,-1.3438),(-.35797,54.8969,-1.36487),(.02328,54.74797,-2.39959),(.03414,54.71598,-2.38575),(.03907,54.77438,-2.10382),(0,54.80487,-2.11702),(.07296,54.68465,-2.16878),(.07815,54.74388,-2.09063),(.02043,54.69968,-2.3608),(.04085,54.67392,-2.34965),(.06212,54.65262,-2.25626),(.04017,54.90144,-2.3625),(.05332,54.81766,-2.41258),(.04422,54.83658,-2.42003),(.14502,54.80771,-2.05172),(.13848,54.77431,-2.06036),(.15581,54.78013,-2.0728),(.12861,54.84302,-2.08449),(.14445,54.83034,-2.09561),(.14384,54.82466,-2.12582),(.12526,54.78897,-2.17927),(.14081,54.79158,-2.16756),(.15835,54.74243,-2.17566),(.12357,54.6719,-2.16327),(.1375,54.74304,-2.08807),(.12357,54.73244,-2.08568),(.08597,55.05629,-2.05998),(.06917,55.16623,-1.99946),(.11547,55.07348,-2.00871),(.03074,54.93437,-2.37817),(0,54.94633,-2.38335),(.03648,54.74237,-2.19376),(.14139,54.81682,-2.01841),(.08072,54.78106,-2.00293),(.10298,54.78126,-1.88009),(.13566,54.76928,-1.9193),(.23329,54.78306,-1.8477),(.3614,55.28139,-1.60318),(.33964,55.25709,-1.69731),(.33218,55.24935,-1.69362),(.05773,54.78503,-1.89517),(.06721,54.83371,-1.88895),(.01227,55.20796,-2.04189),(0,55.19164,-2.08485),(0,55.22117,-2.00188),(.15749,55.18978,-1.93563),(.15093,55.1964,-1.92718),(.224,55.21197,-1.86676),(.21567,54.78023,-1.82636),(.21014,54.82068,-1.83554),(.09224,54.83042,-1.88334),(.41947,54.90777,-1.56191),(.40178,54.9103,-1.46754),(.39393,54.97471,-1.4899),(.81501,55.08763,-1.32166),(.79651,55.08604,-1.31917),(.79805,55.04441,-1.35949),(.69408,55.09303,-1.26725),(.69788,55.09667,-1.25624),(.58284,55.10685,-1.20341),(.47915,55.10387,-1.21152),(.49069,55.09807,-1.20688),(.49547,55.10766,-1.198),(.41001,55.29207,-1.61262),(.45019,55.35196,-1.52105),(.48416,55.34912,-1.52454),(.30466,55.38043,-1.28622),(.34006,55.34854,-1.29215),(.32018,55.28801,-1.23208),(.36373,55.27544,-1.43938),(.36301,55.20334,-1.36074),(.39594,55.25851,-1.27903),(.34886,55.25242,-1.47072),(.345,55.08789,-1.48462),(.33327,55.15731,-1.42343),(.34619,55.19704,-1.54649),(.34577,55.18239,-1.57079),(.36972,55.07861,-1.53011),(.42796,55.18841,-1.1907),(.37604,55.22835,-1.15973),(.32408,55.56197,-1.36033),(.33152,55.62521,-1.33052),(.38267,55.51861,-1.41983),(.23144,55.4046,-1.26493),(.15856,55.51844,-1.30256),(.23514,55.50676,-1.30089),(.46113,55.41023,-1.46635),(.37778,55.45985,-1.39915),(.39622,55.50452,-1.43227),(.25632,55.60441,-1.31204),(.18519,55.5921,-1.26349),(.21183,55.66577,-1.22443),(.35965,54.89048,-1.38372),(.34742,54.90384,-1.3769),(.37705,55.0389,-1.26176),(.40494,55.01117,-1.25961),(.69275,55.09204,-1.20533),(.68251,55.10246,-1.11578),(.61882,55.11035,-1.15261),(.70563,55.08548,-1.18439),(.7227,55.05632,-1.13596),(.80151,55.03812,-1.18594),(.81304,54.99566,-1.1381),(.91679,54.96398,-1.15687),(.88133,54.97503,-1.12752),(.86619,54.96644,-1.14341),(.95859,54.98768,-1.12297),(.9356,55.02419,-1.07964),(.83004,55.03153,-1.20405),(.93174,55.03085,-1.22891),(.86764,55.00244,-1.19191),(.90652,55.12598,-1.24769),(.82676,55.20691,-1.19831),(.93005,55.14287,-1.18719),(.41936,55.23149,-1.10744),(.38368,55.23466,-1.04705),(.40373,55.21723,-1.11114),(.53199,55.16672,-1.16553),(.47401,55.19508,-1.14681),(.52364,55.15,-1.16765),(.45034,55.25791,-.89308),(.55225,55.27116,-.87714),(.44719,55.25963,-.87673),(.70186,55.10674,-1.02708),(.70059,55.10738,-1.04354),(.69976,55.0941,-1.04415),(.79215,55.32085,-1.06304),(.7985,55.32255,-1.05956),(.8226,55.27556,-1.06584),(.77541,55.36157,-1.27256),(.7561,55.35771,-1.26472),(.76052,55.35293,-1.2823),(.70232,55.19231,-1.20685),(.73958,55.23311,-1.21417),(.72021,55.28893,-1.25157),(.77453,55.17495,-1.12859),(.77789,55.23503,-1.03561),(.79098,55.22217,-1.16073),(.5988,55.40546,-1.09226),(.67909,55.39737,-1.1297),(.69838,55.36626,-1.05152),(.53064,55.41121,-1.08234),(.53083,55.31319,-.95261),(.44997,55.34925,-1.01902),(.57779,55.32466,-1.19709),(.64703,55.34428,-1.22634),(.66586,55.38751,-1.19894),(.7295,55.33487,-1.26903),(.72514,55.19379,-1.00005),(.73504,55.13891,-1.08583),(.7507,55.29667,-1.01941),(.71994,55.3353,-1.01542),(.7853,55.36144,-1.08849),(.12019,55.05093,-1.18981),(.1105,55.03562,-1.17802),(.09333,55.05261,-1.19313),(.38847,55.72964,-.93868),(.36221,55.74296,-1.0555),(.37952,55.73192,-.93446),(.33659,55.69949,-1.24901),(.34698,55.69892,-1.24912),(.33625,55.69684,-1.25255),(.20466,55.93377,-1.19808),(.20833,56.02708,-1.20577),(.20681,56.03334,-1.14822),(.17565,55.89028,-1.19209),(.17665,55.93626,-1.25513),(.16828,55.93445,-1.11949),(.19534,55.96089,-1.14609),(.55462,55.05171,-1.26372),(.46911,54.97059,-1.29868),(.55842,54.98256,-1.30696),(.57804,55.10047,-1.21436),(.47841,55.05062,-1.23751),(.36243,55.14414,-1.29616),(.32758,55.07315,-1.3788),(.32793,54.9742,-1.334),(.59757,55.11735,-1.16769),(.14184,55.02936,-1.11399),(.17405,55.03793,-1.13379),(.19984,55.05821,-1.08393),(.26326,55.14175,-1.0835),(.18596,55.05299,-1.14622),(.22218,55.14887,-1.17489),(.28649,55.12974,-.92947),(.23613,55.07732,-1.00279),(.27823,55.13739,-.99614),(.09916,55.00714,-.72567),(.11043,55.07109,-.93075),(.16917,55.057,-.9197),(.07641,55.08579,-.8464),(.35775,55.21205,-.86571),(.3438,55.1958,-.94047),(.39726,55.23893,-.95854),(.84478,55.00348,-1.10524),(.90159,55.08174,-1.04708),(.85619,55.14939,-1.01518),(.70712,55.17903,-.93512),(.78415,55.22759,-.95607),(.70903,55.30205,-.86508),(.57061,55.33678,-.81528),(.46659,55.36466,-.81292),(.2062,55.21756,-.71696),(.16762,55.17948,-.62988),(.20621,55.07517,-.65146),(.11099,55.27959,-.62295),(.14199,55.27766,-.69694),(.08822,55.36712,-.66019),(.25138,55.41316,-.77441),(.26976,55.3553,-.77336),(.34069,55.39578,-.80254),(.16986,55.16122,-1.93623),(.16219,54.78782,-1.95374),(.12357,54.77026,-1.99826),(.11022,54.91313,-2.06436),(.06606,55.02862,-2.11048),(.24865,55.17236,-1.86884),(.30756,55.23407,-1.78242),(.33516,55.2022,-1.78619),(.34439,54.85411,-1.7716),(.34138,54.91538,-1.79894),(.43653,54.95136,-1.72821),(.59256,55.31151,-1.50524),(.72988,55.25117,-1.40081),(.50351,55.28606,-1.59223),(.52202,55.05411,-1.70447),(.43349,55.02879,-1.75985),(.46834,55.15133,-1.70691),(.44421,55.23844,-1.66961),(.57285,55.1712,-1.63583),(.37055,55.25981,-1.69874),(.63009,55.0092,-1.59406),(.6245,55.08455,-1.63121),(.69016,55.10063,-1.57073),(.77873,55.03553,-1.48312),(.62808,54.9486,-1.49996),(.73564,55.06748,-1.52918),(.72701,55.18648,-1.48967),(.7654,55.14705,-1.42264),(.86904,55.13265,-1.27243),(.96485,55.05473,-1.15134),(.93095,55.13406,-1.10949),(.9671,54.99251,-1.15359),(.073,56.19436,-1.33557),(.10028,56.09657,-1.34407),(.07643,56.15248,-1.3602),(.08308,55.39002,-1.27745),(.07059,55.99156,-1.35525),(.07577,56.06372,-1.37749),(.15029,55.71917,-1.21013),(.06887,55.62192,-1.28475),(.08042,55.69871,-1.26379),(.16819,56.0167,-1.28356),(.1363,56.01629,-1.32336),(.68654,55.388,-1.39819),(.80943,55.40683,-1.29138),(.87432,55.21879,-1.12959),(.87108,55.18817,-1.06503),(.53049,55.43005,-1.46855),(.67654,55.38788,-1.41175),(.57426,55.47901,-1.3934),(.5341,55.4379,-1.46142),(.39631,55.51397,-1.42486),(.65161,55.541,-1.24975),(.59786,55.54831,-1.29698),(.55564,55.57969,-1.27932),(.50868,55.64782,-1.18539),(.49864,55.65587,-1.15444),(.42962,55.68312,-1.20311),(.4095,55.70976,-1.14336),(.44723,55.6173,-1.29862),(.34214,55.62649,-1.32957),(.2459,55.53051,-.78739),(.73226,55.36107,-.8805),(.66993,55.38891,-.83223),(.82956,55.25469,-1.02712),(.78554,55.3262,-.98081),(.79342,55.39191,-1.00904),(.79336,55.36822,-1.08594),(.68767,55.48042,-.8448),(.69916,55.54022,-.86744),(.59056,55.5893,-.82618),(.48161,55.63665,-.84508),(.49549,55.65695,-.90967),(.06395,55.55014,-.74087),(.15251,55.54062,-.77415),(.15923,55.64121,-.7833),(.3474,55.59536,-.8158),(.37058,55.66395,-.84718),(.24233,55.68621,-.85774),(.27548,55.7241,-1.02761),(.35269,55.74369,-1.05344),(.34688,55.74863,-1.13891),(.1744,55.82043,-1.15777),(.15101,55.90346,-1.08052),(.24807,55.69759,-1.14209),(.22208,55.78414,-1.04915),(.14582,55.86581,-.96249),(.11312,55.86522,-.91658),(.1235,55.80259,-.88345),(.1344,55.93817,-.96186),(.16684,55.85018,-1.06789),(.12846,56.20117,-1.25783),(.10347,56.19465,-1.18096),(.16289,56.11998,-1.16151),(.04565,56.21804,-1.08962),(.09609,56.15737,-1.08587),(.09298,56.03238,-.97116),(.13344,56.02791,-1.00754),(.08305,56.11258,-1.0115),(.1162,56.10227,-1.05702),(.0648,55.65668,-.77016),(.0598,55.80206,-.86746),(.06363,55.93879,-.92029),(.04754,56.16646,-1.03431),(.38062,55.32867,-1.49738),(.4241,55.35922,-1.39975),(.35797,54.8969,-1.36487),(.40143,54.9179,-1.3438),(.36467,54.96259,-1.30835),(.43732,54.87912,-1.5528),(.44933,54.87199,-1.55934),(.50799,54.89533,-1.4639),(.0433,56.24235,-1.17269),(0,56.24226,-1.08618),(.0639,55.86833,-.8827),(.19156,56.04027,-1.11526),(.19192,55.7931,-.94596),(.15037,55.73603,-.83802),(.21573,55.73383,-1.13634),(.27338,55.72566,-.9191),(.24668,55.62257,-.80918),(0,55.56283,-.7263),(.5923,55.59556,-.83317),(.59167,55.61209,-.91118),(.8532,55.43101,-1.15002),(.82625,55.46336,-1.03463),(.75513,55.43309,-.91038),(.78248,55.49892,-.93259),(.47807,55.62778,-.83284),(.44481,55.55655,-.80713),(.58405,55.51467,-.81478),(.35602,55.74835,-1.13922),(.52269,55.6168,-1.24549),(.5902,55.60359,-1.14956),(.70232,55.5422,-1.15223),(.69041,55.53614,-1.21056),(.7799,55.47772,-1.25099),(.79352,55.48629,-1.16458),(.8522,55.43902,-1.15207),(.75512,55.28036,-1.33254),(.74034,55.3362,-1.28133),(.82612,55.26611,-1.08543),(.1487,55.79468,-1.26192),(.14662,55.88617,-1.30191),(0,55.59769,-1.30375),(.05483,55.51065,-1.31886),(.9107,55.05124,-1.25329),(.86892,55.0659,-1.2696),(.83354,55.08427,-1.39771),(.79148,55.18418,-1.33601),(.41304,55.22377,-1.7055),(.38464,55.13251,-1.78344),(.28948,55.10557,-1.85739),(.42284,54.88063,-1.68792),(.39231,54.83958,-1.65151),(.3293,54.80698,-1.72922),(.12975,54.93547,-2.03097),(.17732,55.39497,-.71234),(.36289,55.29634,-.8263),(.26944,55.2472,-.78266),(.26536,55.12829,-.84092),(.62548,55.23899,-.91507),(.6567,55.25805,-.87036),(.67315,55.15795,-.96872),(.79272,55.05255,-1.06364),(.74396,55.11845,-.99756),(.43017,55.25008,-.88313),(.10254,55.05442,-1.02591),(.17021,55.04762,-1.01664),(.07595,55.0292,-1.12859),(0,55.07729,-.94583),(.02727,55.09233,-.89573),(0,55.10045,-.86946),(.09657,54.97966,-.6381),(.1528,55.01839,-.67732),(.12897,55.16136,-1.22089),(.32244,55.20759,-1.1049),(.38427,55.23357,-1.03397),(.33659,55.1951,-1.01829),(.2819,55.25322,-1.20499),(.46176,54.91066,-1.35052),(.552,54.9435,-1.35572),(.64812,54.99205,-1.34787),(.68354,55.0445,-1.31553),(.18828,56.08484,-1.1781),(0,56.0627,-1.37809),(0,55.98584,-1.37224),(.8245,55.47081,-1.03914),(0,54.97569,-.62117),(.09209,54.97259,-.65103),(0,55.0709,-1.18287),(.7712,55.36848,-1.23203),(.58335,55.39076,-1.17204),(.51592,55.3913,-1.15368),(.78619,55.37643,-1.15946),(.54935,55.27348,-.89192),(.63877,55.30126,-.94468),(.61259,55.34262,-.99908),(.41195,55.25745,-.96425),(.43719,55.34389,-1.09222),(.39663,55.25421,-1.03857),(.7809,55.36487,-1.09147),(.78963,55.37537,-1.24011),(.81283,55.27637,-1.06731),(.80449,55.22487,-1.17188),(.62261,55.24533,-.92607),(.6709,55.16451,-.97827),(.8048,55.08933,-1.3022),(.78794,55.06673,-1.24297),(.79244,55.06062,-1.21618),(.944,54.98139,-1.18715),(.89984,54.96509,-1.17011),(.71057,55.13709,-1.12385),(.65331,55.15214,-1.18753),(.6093,55.12791,-1.16438),(.10669,55.51454,-1.31071),(.31085,55.48477,-1.34444),(.34273,55.16722,-1.65482),(.3438,54.97873,-1.42274),(.22681,55.27674,-1.21991),(.77472,55.21487,-1.26212),(.57944,54.93348,-1.53895),(.80603,55.04759,-1.36658),(.30321,54.84121,-1.7308),(.3154,54.81065,-1.72471),(.29337,55.23898,-1.7758),(.23041,55.20284,-1.86881),(.04182,55.2106,-1.98269),(.03718,55.20549,-1.97529),(.15928,54.95933,-2.00251),(.16599,54.77921,-2.11103),(.1534,54.75569,-2.09345),(.15441,54.73199,-2.14836),(.15953,54.80649,-2.07294),(.02534,55.11309,-2.14661),(.03718,55.03708,-2.21671),(.02534,55.07526,-2.23402),(.04679,54.78873,-2.41723),(.14381,54.73204,-2.18302),(.13639,54.71525,-2.15134),(.02328,54.79874,-2.42156),(-.43732,54.87912,-1.5528),(-.50799,54.89533,-1.4639),(-.0639,55.86833,-.8827),(-.11312,55.86522,-.91658),(-.1235,55.80259,-.88345),(-.1344,55.93817,-.96186),(-.15037,55.73603,-.83802),(-.1744,55.82043,-1.15777),(-.59167,55.61209,-.91118),(-.79342,55.39191,-1.00904),(-.82625,55.46336,-1.03463),(-.8532,55.43101,-1.15002),(-.78248,55.49892,-.93259),(-.75513,55.43309,-.91038),(-.44481,55.55655,-.80713),(-.47807,55.62778,-.83284),(-.16536,55.44532,-.73183),(-.35602,55.74835,-1.13922),(-.65161,55.541,-1.24975),(-.69041,55.53614,-1.21056),(-.7799,55.47772,-1.25099),(-.80869,55.41564,-1.29241),(-.8522,55.43902,-1.15207),(-.77472,55.21487,-1.26212),(-.80449,55.22487,-1.17188),(-.16819,56.0167,-1.28356),(-.14662,55.88617,-1.30191),(-.21573,55.73383,-1.13634),(-.1487,55.79468,-1.26192),(-.21183,55.66577,-1.22443),(-.33152,55.62521,-1.33052),(-.90652,55.12598,-1.24769),(-.86892,55.0659,-1.2696),(-.9107,55.05124,-1.25329),(-.83354,55.08427,-1.39771),(-.77873,55.03553,-1.48312),(-.62808,54.9486,-1.49996),(-.74514,54.98921,-1.41838),(-.29337,55.23898,-1.7758),(-.3293,54.80698,-1.72922),(-.39231,54.83958,-1.65151),(-.34439,54.85411,-1.7716),(-.25196,54.82131,-1.87297),(-.24965,54.87971,-1.89678),(-.18256,54.83689,-1.98342),(-.26976,55.3553,-.77336),(-.26944,55.2472,-.78266),(-.09226,55.14384,-.6045),(0,55.11226,-.58249),(0,55.193,-.59655),(-.26536,55.12829,-.84092),(-.57061,55.33678,-.81528),(-.62548,55.23899,-.91507),(-.79272,55.05255,-1.06364),(-.74396,55.11845,-.99756),(-.9356,55.02419,-1.07964),(-.36289,55.29634,-.8263),(-.17021,55.04762,-1.01664),(-.07595,55.0292,-1.12859),(-.14184,55.02936,-1.11399),(-.02727,55.09233,-.89573),(-.12897,55.16136,-1.22089),(-.18596,55.05299,-1.14622),(-.22218,55.14887,-1.17489),(-.2819,55.25322,-1.20499),(-.26326,55.14175,-1.0835),(-.42796,55.18841,-1.1907),(-.46176,54.91066,-1.35052),(-.5228,54.89882,-1.4058),(-.68354,55.0445,-1.31553),(-.79244,55.06062,-1.21618),(-.14627,56.08168,-1.28158),(-.19687,56.01851,-1.26189),(-.18828,56.08484,-1.1781),(-.20833,56.02708,-1.20577),(-.39631,55.51397,-1.42486),(-.38267,55.51861,-1.41983),(-.8245,55.47081,-1.03914),(-.10254,55.05442,-1.02591),(-.7712,55.36848,-1.23203),(-.66586,55.38751,-1.19894),(-.43719,55.34389,-1.09222),(-.49753,55.27903,-1.1557),(-.51592,55.3913,-1.15368),(-.68737,55.26818,-.96537),(-.62261,55.24533,-.92607),(-.54935,55.27348,-.89192),(-.63877,55.30126,-.94468),(-.41195,55.25745,-.96425),(-.80234,55.37463,-1.10539),(-.7809,55.36487,-1.09147),(-.6709,55.16451,-.97827),(-.80151,55.03812,-1.18594),(-.78794,55.06673,-1.24297),(-.8048,55.08933,-1.3022),(-.31085,55.48477,-1.34444),(-.33218,55.24935,-1.69362),(-.34273,55.16722,-1.65482),(-.3438,54.97873,-1.42274),(-.345,55.08789,-1.48462),(-.22681,55.27674,-1.21991),(-.63009,55.0092,-1.59406),(-.57944,54.93348,-1.53895),(-.49547,55.10766,-1.198),(-.3154,54.81065,-1.72471),(-.30321,54.84121,-1.7308),(-.224,55.21197,-1.86676),(-.03718,55.20549,-1.97529),(0,55.21358,-1.98588),(-.04182,55.2106,-1.98269),(-.16219,54.78782,-1.95374),(-.1375,54.74304,-2.08807),(-.13848,54.77431,-2.06036),(-.12975,54.93547,-2.03097),(0,54.82058,-2.4033),(-.04679,54.78873,-2.41723),(-.05332,54.81766,-2.41258),(-.02534,55.07526,-2.23402),(-.03718,55.03708,-2.21671),(-.02534,55.11309,-2.14661),(-.16599,54.77921,-2.11103),(-.1534,54.75569,-2.09345),(-.02454,55.18236,-2.07654),(-.05464,55.20149,-1.99308),(-.01227,55.20796,-2.04189),(-.15928,54.95933,-2.00251),(-.47915,55.10387,-1.21152),(-.34742,54.90384,-1.3769),(-.37015,55.0495,-1.26592),(-.08308,55.39002,-1.27745),(-.10669,55.51454,-1.31071),(-.46911,54.97059,-1.29868),(-.7405,54.98853,-1.4078),(-.944,54.98139,-1.18715),(-.67315,55.15795,-.96872),(-.78963,55.37537,-1.24011),(-.7853,55.36144,-1.08849),(-.80598,55.38273,-1.16075),(0,55.06053,-1.16348),(0,54.98528,-.60965),(-.19984,55.05821,-1.08393),(-.20783,55.06326,-1.06452),(-.22245,55.07834,-1.08027),(-.4722,55.63488,-.83549),(-.17484,56.0963,-1.2269),(-.19717,55.96613,-1.2386),(-.06135,55.1865,-1.21472),(-.127,55.03455,-.61483),(-.22394,55.06747,-1.00507),(-.17405,55.03793,-1.13379),(-.11022,54.91313,-2.06436),(-.14139,54.81682,-2.01841),(-.61266,54.93392,-1.44735),(-.86904,55.13265,-1.27243),(-.24807,55.69759,-1.14209),(-.07572,55.78925,-1.29674),(-.82676,55.20691,-1.19831),(-.68654,55.388,-1.39819),(-.74034,55.3362,-1.28133),(-.79352,55.48629,-1.16458),(-.58405,55.51467,-.81478),(-.5923,55.59556,-.83317),(-.37058,55.66395,-.84718),(-.38393,55.7272,-.92876),(0,56.25012,-1.16969),(-.44933,54.87199,-1.55934),(.04019,54.77467,-2.01348),(.05464,55.20149,-1.99308),(.02454,55.18236,-2.07654),(.05744,54.7713,-1.96216),(0,54.785,-1.98312),(.81693,55.15651,-1.30925),(.65699,55.21427,-1.52987),(.37015,55.0495,-1.26592),(.67969,55.11716,-1.11605),(.73604,55.2946,-1.26411),(.80234,55.37463,-1.10539),(.49753,55.27903,-1.1557),(.80598,55.38273,-1.16075),(.22245,55.07834,-1.08027),(.20783,55.06326,-1.06452),(.4722,55.63488,-.83549),(.17484,56.0963,-1.2269),(.14627,56.08168,-1.28158),(.14209,56.13771,-1.23702),(.5228,54.89882,-1.4058),(.61289,54.93487,-1.43532),(.46352,55.18016,-1.15186),(.06135,55.1865,-1.21472),(.127,55.03455,-.61483),(.22394,55.06747,-1.00507),(.04076,55.08509,-.94665),(.64476,55.32001,-.82816),(.21867,55.11059,-.73643),(.09226,55.14384,-.6045),(.16536,55.44532,-.73183),(.18256,54.83689,-1.98342),(.24965,54.87971,-1.89678),(.25196,54.82131,-1.87297),(.27037,55.64877,-1.28216),(.07101,55.8798,-1.3297),(.07572,55.78925,-1.29674),(.80869,55.41564,-1.29241),(.68602,55.47206,-1.33317),(.38393,55.7272,-.92876),(.4183,54.88246,-1.45424),(.33547,54.96789,-1.32626),(.06747,55.74589,-.82834),(.4358,55.69419,-.98529),(.73968,55.53693,-.9929),(.77474,55.50459,-1.07443),(.64842,55.5885,-1.03003),(.68252,55.56641,-1.07776),(.33467,55.49549,-.80178),(.48075,55.54168,-1.37522),(.05912,56.25938,-1.25279),(.20521,55.08206,-1.93118),(.122,55.04489,-.81006),(.22301,55.07529,-.91649),(.04231,55.05455,-1.05414),(.19717,55.96613,-1.2386),(.67899,55.39599,-1.4042),(.22019,55.07462,-.90715),(.21134,55.06792,-.91561),(.6176,55.25792,-1.23025),(.65159,55.23497,-1.23027),(.54092,55.22049,-1.19296),(.74838,55.04095,-1.10117),(.29981,55.40927,-1.30312),(.14825,55.39405,-1.27411),(.41002,55.30886,-1.33939),(.43576,54.87718,-1.39343),(.81764,55.09024,-1.30889),(.39749,54.96906,-1.58021),(.02534,55.01472,-2.31161),(.04726,55.13966,-2.07303),(.12316,54.83066,-2.12786),(.03106,54.71014,-2.28115),(.07805,54.91042,-1.89844),(.10023,54.81324,-2.22443),(-.33547,54.96789,-1.32626),(-.06747,55.74589,-.82834),(-.77474,55.50459,-1.07443),(-.73968,55.53693,-.9929),(-.49864,55.65587,-1.15444),(-.46834,55.15133,-1.70691),(-.20521,55.08206,-1.93118),(-.3438,55.1958,-.94047),(-.122,55.04489,-.81006),(-.22301,55.07529,-.91649),(-.40373,55.21723,-1.11114),(-.67899,55.39599,-1.4042),(-.36221,55.74296,-1.0555),(-.21134,55.06792,-.91561),(-.22019,55.07462,-.90715),(-.14305,55.01252,-.68829),(-.67909,55.39737,-1.1297),(-.65159,55.23497,-1.23027),(-.71057,55.13709,-1.12385),(-.54092,55.22049,-1.19296),(-.38427,55.23357,-1.03397),(-.43576,54.87718,-1.39343),(-.69408,55.09303,-1.26725),(-.79651,55.08604,-1.31917),(-.05773,54.78503,-1.89517),(-.07815,54.74388,-2.09063),(-.04726,55.13966,-2.07303),(-.14445,54.83034,-2.09561),(-.08272,54.73301,-2.37521),(-.07849,54.70779,-2.3822),(-.10388,54.68428,-2.35413),(-.06724,54.73369,-2.39341),(-.0372,54.97661,-2.29415),(-.15441,54.73199,-2.14836),(-.10023,54.87378,-2.14684),(-.13066,54.6793,-2.2678),(-.09522,54.7609,-2.30311),(0,54.76767,-2.30604),(-.06631,54.85702,-2.3447),(-.06734,54.92258,-2.27174),(-.06606,55.02862,-2.11048),(-.06828,54.97469,-2.19958),(-.29022,55.23441,-1.77168),(-.22143,55.20841,-1.86197),(0,54.93186,-1.91552),(-.045,54.70229,-2.37982),(-.07362,54.69508,-2.3767),(-.06042,55.01463,-1.92405),(-.16372,55.10601,-1.89889),(-.1826,55.00541,-1.87357),(-.04401,55.11239,-1.95276),(-.1474,55.19213,-1.92215),(-.2403,55.12273,-1.83105),(-.32793,54.9742,-1.334),(-.32758,55.07315,-1.3788),(-.26633,55.013,-1.7929),(-.34936,54.93827,-1.67284),(-.29391,54.9033,-1.75642),(-.32771,55.04306,-1.70721),(-.13861,55.27771,-1.2475),(-.35995,55.40908,-1.35221),(-.10305,55.57197,-1.29236),(-.65331,55.15214,-1.18753),(-.7531,55.23651,-1.22508),(-.78619,55.37643,-1.15946),(-.59228,55.19215,-1.20161),(-.71994,55.3353,-1.01542),(-.7507,55.29667,-1.01941),(-.781,55.50634,-.93781),(-.18417,56.06009,-1.25569),(-.43845,54.87978,-1.38294),(-.33659,55.1951,-1.01829),(0,55.04438,-1.11429),(-.06096,54.96622,-.67714),(-.17229,55.06052,-.76606),(0,55.28601,-.60152),(-.23478,54.97019,-1.92574),(-.33565,55.00423,-1.83437),(-.28948,55.10557,-1.85739),(0,55.86829,-1.33998),(0,55.77766,-1.31474),(-.07101,55.8798,-1.3297),(-.70232,55.5422,-1.15223),(-.43628,55.4691,-.7988),(-.56565,55.41172,-.80704),(-.68252,55.56641,-1.07776),(-.5902,55.60359,-1.14956),(-.64842,55.5885,-1.03003),(-.60205,55.61419,-1.01179),(-.51096,55.65185,-1.03848),(-.539,55.63942,-1.01084),(-.40217,55.71694,-1.06887),(-.07221,55.28826,-1.24609),(-.36408,54.87579,-1.65194),(-.37584,54.84558,-1.64612),(.05659,54.76911,-2.40874),(.06724,54.73369,-2.39341),(.06266,54.79966,-2.40406),(.07362,54.69508,-2.3767),(.09471,54.66034,-2.34377),(.045,54.70229,-2.37982),(.10023,54.87378,-2.14684),(.13066,54.6793,-2.2678),(.08272,54.73301,-2.37521),(.09522,54.7609,-2.30311),(.10388,54.68428,-2.35413),(.06631,54.85702,-2.3447),(.06734,54.92258,-2.27174),(.1474,55.19213,-1.92215),(.19959,54.89797,-1.85308),(.26633,55.013,-1.7929),(.29391,54.9033,-1.75642),(.1826,55.00541,-1.87357),(.36408,54.87579,-1.65194),(.34936,54.93827,-1.67284),(.37584,54.84558,-1.64612),(.52044,54.89628,-1.41714),(.43845,54.87978,-1.38294),(.51819,54.97993,-1.67497),(.49145,54.90726,-1.62074),(.32771,55.04306,-1.70721),(.13861,55.27771,-1.2475),(.7531,55.23651,-1.22508),(.59228,55.19215,-1.20161),(.17229,55.06052,-.76606),(.15993,55.05236,-.77208),(.781,55.50634,-.93781),(.18417,56.06009,-1.25569),(.19687,56.01851,-1.26189),(0,55.19142,-1.20928),(0,55.03881,-.58538),(.08814,55.43782,-.69857),(.23478,54.97019,-1.92574),(.33565,55.00423,-1.83437),(.61266,54.93392,-1.44735),(.43628,55.4691,-.7988),(.56565,55.41172,-.80704),(.60205,55.61419,-1.01179),(.47929,55.66815,-1.08468),(.40217,55.71694,-1.06887),(.6783,55.57374,-.93708),(.69908,55.54726,-.87464),(.07221,55.28826,-1.24609),(.04401,55.11239,-1.95276),(0,55.02946,-1.93532),(.06042,55.01463,-1.92405),(0,55.12123,-1.96292),(0,56.10709,-.9793),(.539,55.63942,-1.01084),(0,55.46272,-.67472),(0,56.20505,-1.3359),(0,56.27007,-1.25312),(.10305,55.57197,-1.29236),(.74514,54.98921,-1.41838),(0,55.37359,-.63918),(.14305,55.01252,-.68829),(.06096,54.96622,-.67714),(0,54.96356,-.66517),(.68737,55.26818,-.96537),(.35995,55.40908,-1.35221),(.36587,55.06626,-1.61786),(.7405,54.98853,-1.4078),(.29022,55.23441,-1.77168),(.06828,54.97469,-2.19958),(.11531,54.63921,-2.25046),(0,55.28838,-1.23916),(0,56.18871,-1.0333),(-.47929,55.66815,-1.08468),(-.08814,55.43782,-.69857),(0,55.69407,-1.29105),(0,56.15008,-1.35961),(-.15993,55.05236,-.77208),(-.69908,55.54726,-.87464),(-.52044,54.89628,-1.41714),(-.36587,55.06626,-1.61786),(-.19959,54.89797,-1.85308),(-.11531,54.63921,-2.25046),(-.06266,54.79966,-2.40406),(-.15835,54.74243,-2.17566),(-.14081,54.79158,-2.16756),(-.09471,54.66034,-2.34377),(-.05659,54.76911,-2.40874),(-.05744,54.7713,-1.96216),(0,55.11189,-2.24987),(0,55.14972,-2.16246),(-.306,55.14748,-1.74168),(-.6783,55.57374,-.93708),(.07849,54.70779,-2.3822),(.0372,54.97661,-2.29415),(.22143,55.20841,-1.86197),(.16372,55.10601,-1.89889),(.2403,55.12273,-1.83105),(.306,55.14748,-1.74168),(.51096,55.65185,-1.03848)]),
          normal=Normal(vector=[(-.9996,.0129,-.0233),(-.9992,.0227,-.0322),(-.9983,-.0399,.0426),(-.9974,.0475,.0533),(-.9907,.1352,.0146),(-.9864,.1641,.008),(-.9818,.154,-.1107),(-.9727,.0913,.2133),(-.9714,.236,-.0243),(-.9708,.0067,-.2398),(-.9692,-.1282,-.2102),(-.9661,-.0178,-.2574),(-.9661,.2499,.0654),(-.9645,-.2596,-.0489),(-.9638,-.0276,.2653),(-.9636,-.267,-.0101),(-.9632,.2073,-.1713),(-.9593,.152,.238),(-.9573,-.1623,.2393),(-.9565,-.2532,-.1451),(-.9554,-.2506,-.1562),(-.9529,.0286,.3021),(-.9522,-.1677,.2553),(-.9516,.123,-.2816),(-.9457,.1442,.2913),(-.944,-.2346,.2318),(-.9395,-.1603,-.3029),(-.9385,.2587,.2287),(-.9364,.2721,-.2218),(-.9355,-.1982,.2924),(-.9354,.2475,-.2526),(-.9344,-.1695,-.3134),(-.9317,.3048,-.1977),(-.9295,.2811,-.2387),(-.9291,-.3288,.1694),(-.928,.2856,-.2394),(-.9274,-.372,-.0379),(-.9259,.3102,-.2156),(-.9253,.1379,.3533),(-.9247,.2799,-.2579),(-.9228,.2909,-.2525),(-.9224,-.1647,-.3493),(-.9162,.2789,-.2877),(-.9151,.1717,-.365),(-.9134,-.3292,.2394),(-.9078,-.2947,-.2986),(-.9073,.3607,-.2161),(-.9064,-.2736,.3217),(-.9048,.1967,-.3778),(-.9029,.2699,-.3345),(-.902,.4167,-.1131),(-.9014,-.1943,-.387),(-.9012,-.4247,-.0861),(-.901,.3243,-.2881),(-.8969,-.2344,-.3751),(-.8967,.3165,.3096),(-.8962,.3942,.2035),(-.894,-.4041,.1933),(-.8937,.4427,.0731),(-.8856,.4166,-.2052),(-.8847,.4502,-.1209),(-.8819,.3334,.3333),(-.8783,.1236,.4619),(-.8777,-.4754,-.0599),(-.8777,.4769,.0469),(-.8755,.1267,-.4662),(-.8724,.2124,.4403),(-.8722,-.2574,.4161),(-.872,.3836,-.304),(-.8713,.3757,.3158),(-.8683,.414,.2733),(-.8682,-.4554,.1971),(-.8677,-.0038,.4971),(-.867,.3552,.3495),(-.8655,.4288,-.259),(-.8646,.4963,-.0787),(-.8637,-.0878,-.4963),(-.8633,-.0241,.5041),(-.8601,-.2703,-.4326),(-.8563,.4978,-.1374),(-.8534,-.5035,.135),(-.8489,-.0273,.5279),(-.8473,-.5169,.1221),(-.8438,.1112,-.525),(-.8436,.3735,-.3857),(-.8415,-.4206,-.339),(-.8399,-.5376,.0753),(-.8394,.2639,-.4752),(-.8349,-.546,-.07),(-.833,-.304,.4623),(-.8323,.1674,.5284),(-.8309,.0659,-.5526),(-.8297,-.1714,-.5312),(-.8281,-.444,.3423),(-.826,-.3308,-.4564),(-.8204,.2349,.5214),(-.8178,.3472,-.4589),(-.8163,.5142,-.263),(-.8146,.2781,.5091),(-.8131,.3806,.4404),(-.813,.5171,-.2678),(-.8125,-.1878,-.5519),(-.812,.4115,.4139),(-.8116,-.0814,.5786),(-.8064,-.3185,.4983),(-.8058,-.0909,.5851),(-.8036,-.4127,.4288),(-.8033,.5896,.0847),(-.798,.4706,-.3764),(-.7971,.4482,.4047),(-.7947,-.5821,-.1722),(-.7936,.5792,.1864),(-.7926,.1542,-.5899),(-.7919,-.5249,-.312),(-.7881,-.5053,.3517),(-.7866,.3853,-.4824),(-.7865,.1971,-.5854),(-.7816,.2346,.578),(-.7809,.3955,-.4834),(-.7796,.2687,-.5657),(-.7791,.6201,-.0924),(-.7732,.0749,.6297),(-.7726,-.3268,-.5443),(-.7714,.4796,-.4182),(-.7706,-.1293,-.6241),(-.7696,.6139,.1755),(-.765,-.6127,-.1984),(-.7641,.086,-.6393),(-.7636,.0312,.6449),(-.7629,.4814,.4316),(-.7596,-.576,.302),(-.759,-.5717,.3115),(-.7581,.313,-.5722),(-.7557,-.0166,.6547),(-.7553,.4231,-.5005),(-.7549,.3873,-.5292),(-.7547,.6015,-.262),(-.7546,.6503,-.0876),(-.7526,-.0132,.6584),(-.7493,-.2191,-.6249),(-.7483,.3708,-.55),(-.7479,-.5989,-.2863),(-.7479,.6549,-.1087),(-.7453,.0561,.6643),(-.7453,-.6445,-.1708),(-.7421,.6559,-.1381),(-.7404,-.2572,-.621),(-.7384,-.0558,-.672),(-.7383,-.5869,.3325),(-.7359,-.5372,.4122),(-.7358,.6771,.0088),(-.7354,-.4358,-.5189),(-.7326,-.6563,.1805),(-.732,-.6759,-.0855),(-.7286,-.6835,.0446),(-.7269,.6826,-.0752),(-.7248,-.2124,-.6554),(-.7241,-.4471,-.5251),(-.7241,.6432,.2488),(-.7192,-.6923,-.0592),(-.7173,.2692,.6426),(-.7147,.0752,-.6953),(-.712,.6537,.2565),(-.7054,-.2506,-.663),(-.7039,.5904,.3949),(-.7015,.3343,-.6294),(-.701,.002,-.7131),(-.7008,.0385,.7123),(-.6966,-.3764,.6108),(-.6957,-.2337,-.6793),(-.6955,-.2479,-.6744),(-.6924,.2203,-.687),(-.6917,-.405,.5979),(-.6907,.02,-.7229),(-.6897,.4898,.5332),(-.6877,.3766,-.6207),(-.6847,.7273,-.0466),(-.6847,-.7288,.0079),(-.6812,-.5755,.4524),(-.6812,.6318,-.3699),(-.6805,.282,-.6763),(-.6781,-.3758,-.6316),(-.6778,-.7352,.0015),(-.6766,-.6691,-.3074),(-.6746,.1033,-.7309),(-.6727,.3905,-.6285),(-.67,-.6084,-.4254),(-.6686,-.17,.724),(-.662,-.6711,.3337),(-.661,.7409,-.1184),(-.6596,.6251,-.4174),(-.6573,-.7531,-.0283),(-.6547,.3495,-.6702),(-.6504,-.6005,-.4651),(-.6502,-.0678,-.7567),(-.6461,-.7544,-.1161),(-.643,.6739,.3639),(-.6421,-.4005,-.6537),(-.6403,-.7533,.1501),(-.639,.4415,.6299),(-.6385,.3754,.6719),(-.6376,.6785,-.3647),(-.6372,-.7579,-.1399),(-.6342,.5116,-.5797),(-.6326,-.3938,-.6669),(-.6326,.1914,-.7505),(-.6318,.3308,-.7011),(-.6219,-.7728,-.1269),(-.6212,.7831,-.0294),(-.6209,.0613,-.7815),(-.6187,.0109,-.7856),(-.6177,-.7864,.0004),(-.6156,-.4524,-.6453),(-.6134,-.7061,.3537),(-.6134,-.787,.067),(-.6131,.2008,.7641),(-.6128,-.6502,.4491),(-.6105,-.792,.0066),(-.6102,-.5276,-.591),(-.608,.1883,-.7713),(-.608,-.6408,.4688),(-.6051,-.789,.106),(-.6048,-.44,-.6638),(-.6042,.3689,-.7063),(-.604,-.1248,.7871),(-.6037,-.1878,.7748),(-.6014,-.7888,.1268),(-.5986,.2926,-.7457),(-.5981,-.4786,-.6428),(-.5979,-.2482,-.7621),(-.5926,-.7859,-.1766),(-.5917,-.1823,-.7853),(-.5893,-.7316,-.3428),(-.5887,-.7962,.1397),(-.5871,-.6969,.4118),(-.587,-.1149,-.8014),(-.5863,.5178,-.623),(-.5855,.2659,-.7658),(-.5852,-.0501,-.8094),(-.5822,.3936,.7114),(-.5792,.8058,-.1232),(-.5764,-.7108,-.4032),(-.5763,-.5495,.6049),(-.5758,.7144,.3977),(-.5749,-.8155,-.0665),(-.5746,.2613,-.7756),(-.5731,-.713,.4041),(-.5725,.7224,.3877),(-.5725,-.7458,-.3405),(-.5724,.1064,.813),(-.568,.4576,-.6841),(-.5668,.727,-.3877),(-.5639,.8186,.1089),(-.5636,-.7954,.2227),(-.5618,-.8272,-.0105),(-.5587,.8293,-.0065),(-.5577,.4371,-.7056),(-.5577,-.6909,-.4601),(-.5542,-.8311,-.0468),(-.554,-.8297,-.0687),(-.5524,-.0794,-.8298),(-.5514,.8333,.0391),(-.5504,-.3658,-.7505),(-.5494,-.5644,.6161),(-.5483,-.8351,-.0448),(-.5474,.1002,.8309),(-.5469,.4432,-.7103),(-.545,-.0872,.8339),(-.5426,-.8353,-.0885),(-.5417,-.8111,-.2204),(-.5417,.8404,-.0182),(-.5414,.8355,-.0944),(-.5387,.5164,.6657),(-.5377,.3389,.772),(-.5373,.1956,-.8204),(-.5361,.1219,.8353),(-.5358,.1026,.8381),(-.5345,.3476,-.7704),(-.5341,.4155,-.7363),(-.5322,.1813,.827),(-.5321,-.2859,.7969),(-.5299,-.3059,.7909),(-.5259,.7141,-.462),(-.5241,-.5949,.6094),(-.5239,.8156,-.2454),(-.5218,-.1909,.8314),(-.521,-.7947,.3115),(-.5193,.8509,-.0785),(-.5104,-.8599,-.0115),(-.5081,-.2665,.819),(-.508,.8555,-.1001),(-.5038,.0946,.8586),(-.5007,.5436,-.6737),(-.4983,.8621,.0919),(-.4975,-.438,-.7488),(-.4959,.3493,-.7951),(-.4934,.4941,-.7158),(-.4932,.2756,-.8252),(-.4912,-.6858,-.5371),(-.4852,.8318,.2697),(-.485,.3535,-.7999),(-.4839,-.8038,-.346),(-.4837,-.8648,-.1347),(-.4836,-.8255,-.291),(-.4823,.4354,-.7602),(-.4797,.8618,-.1648),(-.4789,.8777,-.0135),(-.4781,-.8272,-.2954),(-.4771,.8556,-.201),(-.475,-.8798,-.0166),(-.4742,-.503,-.7226),(-.4737,.5714,-.6702),(-.4729,-.7418,-.4754),(-.472,-.4355,-.7665),(-.4716,.8808,-.0427),(-.4713,.2635,-.8417),(-.4701,-.0762,-.8793),(-.4696,-.7535,.4602),(-.4677,-.8275,-.3108),(-.4643,-.7353,.4937),(-.4632,.4015,.7901),(-.4618,.1203,.8788),(-.4612,.8731,.1583),(-.461,.5149,.7227),(-.4598,.8094,-.3654),(-.4584,-.6307,.6262),(-.4583,-.656,.5997),(-.4582,-.8296,.319),(-.4566,-.8715,-.1789),(-.4552,.524,.7199),(-.4539,-.795,.4024),(-.4496,.6627,-.5989),(-.4475,.8943,.0052),(-.4474,-.2168,.8677),(-.4452,-.2419,-.8621),(-.4452,-.8658,-.2285),(-.4413,.604,.6636),(-.4411,.8115,-.3832),(-.4384,.8674,.2354),(-.4375,.8223,-.364),(-.4375,-.1945,.8779),(-.4373,.0254,.8989),(-.4273,.3942,.8136),(-.4258,.1317,.8952),(-.4258,.5638,-.7077),(-.4208,-.2339,-.8765),(-.4182,.8104,.4104),(-.4171,-.9081,.0373),(-.4166,.6597,-.6255),(-.4164,-.7518,.5112),(-.4163,.7945,-.4421),(-.415,-.9073,.0676),(-.4133,-.2381,-.8789),(-.4126,-.012,.9108),(-.4098,.9025,.1325),(-.4096,-.857,.3129),(-.4088,-.3134,.8571),(-.4054,-.6059,-.6845),(-.3999,.9044,-.149),(-.3993,.7856,-.4726),(-.3976,.36,.844),(-.3957,-.9054,-.1535),(-.3952,-.7298,.5578),(-.3946,-.9083,-.139),(-.3941,.3378,.8548),(-.394,-.4667,-.7918),(-.3911,.9162,-.0875),(-.3904,-.4082,-.8252),(-.3872,.7911,.4735),(-.3854,.9218,.0411),(-.3837,-.8298,.4052),(-.3825,.6792,-.6264),(-.3819,-.8974,.2208),(-.3808,-.2185,.8985),(-.3794,.9227,.0689),(-.3776,.2517,-.8911),(-.3774,.0087,-.926),(-.3771,.9017,-.2117),(-.3747,.3707,.8498),(-.3703,-.927,-.0594),(-.3695,-.64,-.6737),(-.3689,-.9281,.0503),(-.3688,-.9162,-.1567),(-.3672,-.9301,.0115),(-.3628,-.9274,.0914),(-.3597,.4754,-.8029),(-.3595,-.3286,.8734),(-.3593,-.7854,.504),(-.3587,-.8776,.318),(-.3572,-.3682,.8584),(-.3567,-.7419,-.5677),(-.356,.678,-.6431),(-.3551,-.2342,-.905),(-.3542,.7598,-.5452),(-.3503,-.0903,-.9323),(-.3503,.8237,.4459),(-.3485,.5884,.7296),(-.3409,-.871,-.3538),(-.3402,-.2973,-.8921),(-.3389,.913,.2269),(-.3387,-.6286,.7002),(-.3322,-.7547,.5657),(-.3315,-.8199,-.4667),(-.3306,-.8519,.4061),(-.3305,.9074,-.2594),(-.3302,.0657,.9416),(-.3285,.7539,-.569),(-.3285,.419,.8465),(-.3265,.4133,.85),(-.3252,-.9288,-.1779),(-.325,.7449,-.5826),(-.3239,-.184,-.928),(-.3231,-.5405,-.7769),(-.3221,-.7803,.536),(-.3219,-.9451,.056),(-.3216,-.1809,-.9294),(-.321,-.9415,.1024),(-.3201,.9469,.031),(-.3195,.5451,.7751),(-.3182,-.5538,.7694),(-.3171,.6106,-.7257),(-.3151,-.9484,.0367),(-.3132,-.9464,-.0785),(-.3095,.0561,.9492),(-.3077,-.6674,-.6782),(-.2986,-.6537,.6953),(-.2977,.3278,.8966),(-.2916,.3277,.8987),(-.2915,-.9549,-.056),(-.291,.6503,.7018),(-.2872,.4272,.8573),(-.2863,.5867,.7575),(-.286,-.5104,-.811),(-.285,.9549,-.0833),(-.2837,.2596,.9231),(-.2811,-.6449,.7107),(-.2809,-.2784,-.9185),(-.2807,.945,-.1677),(-.2776,.2237,.9343),(-.2762,-.6656,.6934),(-.2687,-.8238,.4992),(-.2636,.7251,-.6362),(-.2627,.1497,.9532),(-.2612,.2572,-.9304),(-.2592,-.631,.7312),(-.2561,.2012,.9455),(-.2533,.0476,.9662),(-.2523,-.5829,-.7723),(-.2513,.873,.418),(-.2498,.9033,-.3487),(-.2483,-.9652,-.0823),(-.244,-.5798,.7774),(-.2438,.819,.5194),(-.2399,.0176,.9706),(-.239,.966,-.0988),(-.2381,.4092,.8808),(-.2354,.4183,.8773),(-.2338,-.962,.1412),(-.2332,.6132,.7547),(-.2315,-.6466,.7269),(-.229,.7628,-.6047),(-.2274,-.3029,.9255),(-.2231,.1347,.9654),(-.2225,.1955,.9551),(-.2166,-.9741,.0648),(-.2146,.8663,-.4511),(-.2064,.4205,.8835),(-.2034,.8254,-.5267),(-.2028,-.9414,-.2697),(-.2,.5229,-.8286),(-.1992,-.8665,-.4577),(-.1991,.0878,.976),(-.1989,-.3055,-.9312),(-.1983,.584,.7871),(-.1968,-.5554,-.808),(-.196,.6211,-.7588),(-.1944,.7055,.6816),(-.1942,.3121,-.93),(-.1938,-.5769,-.7935),(-.1925,-.5027,.8428),(-.1925,.4201,.8868),(-.1922,-.7013,.6864),(-.1919,-.057,.9798),(-.1876,-.9659,-.1783),(-.186,.36,.9142),(-.1793,-.4993,.8477),(-.1758,-.7863,.5923),(-.1722,-.8556,.4881),(-.1714,.6255,-.7612),(-.1708,.9769,.1283),(-.1705,.9705,-.1704),(-.1664,-.8555,.4903),(-.1646,-.788,.5932),(-.1644,-.9841,-.0668),(-.16,-.7385,.655),(-.1575,-.5175,-.841),(-.1567,-.9737,.1653),(-.1536,-.9719,.1782),(-.1525,.5117,.8455),(-.1517,.9323,.3283),(-.1462,.9608,-.2356),(-.1448,.025,-.9891),(-.1438,-.8121,.5656),(-.1378,.8594,-.4925),(-.1361,-.9905,-.0192),(-.1342,-.368,-.9201),(-.132,-.0335,.9907),(-.1318,-.9861,.1012),(-.1306,-.9895,.0616),(-.1305,-.367,.921),(-.1295,-.779,.6135),(-.1275,-.8844,-.449),(-.1269,.6916,.7111),(-.1254,-.2332,-.9643),(-.1243,-.912,.3908),(-.1233,.7736,-.6215),(-.1188,-.6679,.7347),(-.1185,-.5876,.8004),(-.1178,-.6105,.7832),(-.1171,-.5696,-.8135),(-.1168,.1104,-.987),(-.1163,-.2537,-.9603),(-.1161,-.9932,.0006),(-.1148,-.9738,.1965),(-.114,-.2535,-.9606),(-.1129,-.2705,-.9561),(-.1091,-.9937,.0248),(-.1068,-.9752,-.1937),(-.1048,-.9803,.1672),(-.1045,-.9632,.2477),(-.1034,.7021,-.7046),(-.0977,-.507,-.8564),(-.0962,-.8959,.4338),(-.0958,-.31,-.9459),(-.0953,-.9946,-.0399),(-.094,-.7666,-.6352),(-.0939,.3977,-.9127),(-.0922,-.913,-.3975),(-.0919,-.8654,-.4926),(-.0915,.9406,-.3271),(-.0914,-.878,.4699),(-.0901,-.9959,.0018),(-.0881,-.6454,.7588),(-.0881,-.8143,-.5738),(-.0878,-.9941,.0642),(-.0844,-.9518,-.2948),(-.0832,.0557,.995),(-.0828,.3514,.9325),(-.0805,-.9418,-.3265),(-.0786,-.9156,.3943),(-.0777,-.2874,-.9546),(-.0767,-.0341,-.9965),(-.0701,-.8717,-.485),(-.0677,-.6599,.7483),(-.0647,.6563,-.7517),(-.0645,.3045,.9503),(-.0604,.6236,.7794),(-.0572,.9963,.0645),(-.0544,-.9905,-.126),(-.0523,-.6936,.7184),(-.052,-.9807,.1887),(-.0487,-.9945,.0923),(-.0452,.2473,-.9679),(-.0393,.1967,.9797),(-.037,-.9157,-.4002),(-.0353,-.3165,.9479),(-.0304,.0018,.9995),(-.0293,-.1988,-.9796),(-.0277,-.9958,.0869),(-.0276,-.8017,.597),(-.027,.7208,-.6926),(-.024,.8817,-.4711),(-.018,-.6726,.7398),(-.0164,.4651,.8851),(-.0156,.3881,.9215),(-.0142,.4153,-.9096),(-.0142,-.9754,.22),(-.0135,.9494,-.3139),(-.0129,.317,.9483),(-.0114,.9996,-.0242),(-.0106,.4284,.9035),(-.0102,-.3358,-.9419),(-.0072,.9997,-.0213),(-.0046,-.9868,.162),(-.0026,-.9997,.0226),(0,.0444,.999),(0,-.0736,.9973),(0,.1171,.9931),(0,.1761,.9844),(0,-.2275,.9738),(0,.2397,.9708),(0,.2409,.9706),(0,.2529,.9675),(0,.3431,.9393),(0,-.3798,.9251),(0,.4046,.9145),(0,.4075,.9132),(0,.4858,.8741),(0,.5392,.8422),(0,.5741,.8188),(0,-.5822,.813),(0,.6592,.752),(0,-.738,.6748),(0,-.8777,.4791),(0,.8899,.4561),(0,-.9282,.372),(0,-.9548,.2973),(0,-.9731,.2302),(0,.9868,.1618),(0,-1,-.0028),(0,-.999,-.0445),(0,.9792,-.2029),(0,-.9719,-.2354),(0,-.9413,-.3375),(0,-.9209,-.3899),(0,-.9036,-.4285),(0,.8865,-.4627),(0,.864,-.5035),(0,.8418,-.5397),(0,.7249,-.6888),(0,-.6785,-.7346),(0,.6279,-.7783),(0,-.5659,-.8245),(0,-.4841,-.875),(0,.3185,-.9479),(0,-.2915,-.9566),(0,-.2869,-.958),(0,-.2866,-.958),(0,-.2559,-.9667),(0,-.2155,-.9765),(0,-.1996,-.9799),(0,.1906,-.9817),(0,.0649,-.9979),(0,-.0426,-.9991),(.004,-.2849,-.9586),(.004,.9998,.019),(.0058,.8877,-.4603),(.0077,-.2945,-.9556),(.0086,-.9365,.3506),(.0089,-.9988,-.0476),(.0132,-.9992,.0366),(.0147,.6983,.7157),(.0176,-.2928,.956),(.018,-.6726,.7398),(.0222,-.9988,.0446),(.027,.7208,-.6926),(.0276,-.8017,.597),(.0277,-.9958,.0869),(.0304,.0018,.9995),(.0341,-.3597,.9324),(.037,-.9157,-.4002),(.0402,-.644,.764),(.0458,-.8132,-.5802),(.0467,-.9639,-.2621),(.0488,.9596,-.2769),(.0523,-.6936,.7184),(.0543,.9962,.0674),(.0544,-.9905,-.126),(.0548,.2026,.9777),(.0604,.6236,.7794),(.0613,-.8909,.45),(.0645,.3045,.9503),(.0665,-.9769,.2029),(.0701,-.8717,-.485),(.0762,.6557,-.7511),(.0777,-.2874,-.9546),(.0805,-.9418,-.3265),(.0815,-.9945,.0655),(.0828,.3514,.9325),(.083,-.994,.0717),(.0832,.0557,.995),(.0844,-.9518,-.2948),(.0853,-.0164,-.9962),(.0857,-.3176,-.9444),(.0863,.9631,-.2548),(.087,-.9958,-.0282),(.0881,-.8143,-.5738),(.0919,-.8654,-.4926),(.0939,.3977,-.9127),(.0953,-.9946,-.0399),(.0958,-.995,-.0283),(.0962,-.8959,.4338),(.0977,.9336,-.3447),(.0977,-.507,-.8564),(.0996,-.4249,.8998),(.1005,-.6355,.7655),(.1034,.7021,-.7046),(.104,-.9941,.03),(.1045,-.9632,.2477),(.105,-.9725,.2078),(.1068,-.9752,-.1937),(.1083,-.7916,.6014),(.114,-.2535,-.9606),(.1163,-.3875,-.9145),(.1163,-.2537,-.9603),(.1171,-.5696,-.8135),(.1179,-.895,.4302),(.1188,-.6679,.7347),(.1233,.7736,-.6215),(.1243,-.912,.3908),(.1248,-.2575,-.9582),(.1254,-.2332,-.9643),(.1258,.676,.7261),(.1275,-.8844,-.449),(.1289,-.8678,.4799),(.1303,-.599,.7901),(.1304,.0936,-.987),(.1306,-.9895,.0616),(.132,-.0335,.9907),(.1361,-.9905,-.0192),(.1377,-.8055,.5765),(.1378,.8594,-.4925),(.1409,-.6338,.7605),(.1448,.025,-.9891),(.1467,-.9855,.0856),(.1505,.9314,.3315),(.151,-.7894,.595),(.153,-.7703,.619),(.1544,.6639,-.7317),(.1548,.9792,.1315),(.1567,-.9737,.1653),(.1575,-.5175,-.841),(.16,-.7385,.655),(.16,-.9744,.158),(.1644,-.9841,-.0668),(.1646,.4933,.8542),(.1664,-.8555,.4903),(.1692,-.854,.492),(.1705,.9705,-.1704),(.1746,.149,.9733),(.1804,.4218,.8885),(.1871,-.5019,.8445),(.1883,.5725,.798),(.1892,.1017,.9767),(.1919,-.057,.9798),(.1922,-.7013,.6864),(.1925,-.5027,.8428),(.1938,-.5769,-.7935),(.1942,.3121,-.93),(.1944,.7055,.6816),(.1968,-.5554,-.808),(.1986,.8718,-.4479),(.1989,-.3055,-.9312),(.1992,-.8665,-.4577),(.1996,.3735,.9059),(.2,.5229,-.8286),(.2028,-.9414,-.2697),(.2034,.8254,-.5267),(.2107,.4271,.8793),(.2118,-.9731,.0908),(.2136,-.9616,-.1724),(.2163,-.9685,.1234),(.2166,-.9741,.0648),(.2188,-.5599,.7991),(.2245,-.8033,.5516),(.2274,-.3029,.9255),(.229,.7628,-.6047),(.2332,.6132,.7547),(.2354,.4183,.8773),(.2368,.1373,.9618),(.2381,.4092,.8808),(.2391,.6045,-.7599),(.2399,.0176,.9706),(.2438,.819,.5194),(.2461,.9651,-.0893),(.2467,-.6573,.7121),(.2483,-.9652,-.0823),(.2498,.9033,-.3487),(.2513,.873,.418),(.2533,.0476,.9662),(.2534,-.5678,-.7832),(.2561,.2012,.9455),(.2612,.2572,-.9304),(.2617,.417,.8704),(.2627,.1497,.9532),(.2682,.6971,-.6649),(.2737,-.6953,.6646),(.2776,.2237,.9343),(.2807,.945,-.1677),(.2809,-.2784,-.9185),(.286,-.5104,-.811),(.2863,.5867,.7575),(.291,.6503,.7018),(.2914,-.6171,.731),(.2915,-.9549,-.056),(.2919,-.7568,.5848),(.2977,.3278,.8966),(.3014,.0501,.9522),(.3021,.3138,.9002),(.3024,.9504,-.0727),(.3032,-.6387,.7072),(.3043,-.6513,.6952),(.3077,-.6674,-.6782),(.3102,-.8999,.3065),(.311,.8673,-.3888),(.3115,.6275,-.7136),(.3123,-.5402,-.7814),(.3151,-.9484,.0367),(.3182,-.5538,.7694),(.3183,.2202,.9221),(.3195,.5451,.7751),(.3215,.9465,.0269),(.3216,-.1809,-.9294),(.3219,-.9451,.056),(.3221,.7484,-.5798),(.3225,-.9373,.1321),(.3225,-.8514,.4136),(.3239,-.184,-.928),(.3252,-.9288,-.1779),(.3265,.4133,.85),(.3306,-.0721,-.941),(.3315,-.8199,-.4667),(.3348,.8125,.4772),(.335,.0713,.9395),(.3376,-.7267,.5983),(.338,-.9281,-.156),(.3387,-.6286,.7002),(.3402,-.2973,-.8921),(.3409,-.871,-.3538),(.3475,.8823,-.3174),(.3485,.5884,.7296),(.35,.6661,-.6586),(.3512,.4925,-.7963),(.3515,-.6535,-.6704),(.3541,.2519,-.9007),(.3546,-.9349,.0149),(.3549,.763,-.5403),(.3567,-.7419,-.5677),(.3587,-.8776,.318),(.3593,-.7854,.504),(.3595,-.3286,.8734),(.3597,.4496,.8176),(.368,.6871,-.6265),(.3688,-.9162,-.1567),(.3703,-.927,-.0594),(.3739,.6644,-.6471),(.3751,-.2056,.9039),(.3765,-.9217,.0932),(.3794,.9227,.0689),(.38,.9002,-.2125),(.3805,-.1932,-.9044),(.3819,-.8974,.2208),(.3837,-.8298,.4052),(.3839,-.8995,-.2086),(.3854,.9218,.0411),(.3904,-.4082,-.8252),(.394,-.4667,-.7918),(.3946,-.9083,-.139),(.3972,.78,.4836),(.3976,.36,.844),(.3999,.9044,-.149),(.4047,-.7328,.547),(.4048,-.8481,.342),(.4054,-.6059,-.6845),(.4076,.9101,-.0747),(.4088,-.3134,.8571),(.4129,-.8783,-.2409),(.413,.5628,.716),(.4133,-.2381,-.8789),(.415,-.9073,.0676),(.4163,.7945,-.4421),(.4164,-.7518,.5112),(.4171,-.9081,.0373),(.4208,-.2339,-.8765),(.423,.2013,.8835),(.4233,-.4296,.7977),(.4236,.4135,.8059),(.424,.8787,.2195),(.4258,.5638,-.7077),(.4261,-.2419,.8718),(.4267,.897,.1157),(.4287,.6796,-.5953),(.4309,-.0016,.9024),(.4325,.6184,-.6562),(.4337,.8056,.4036),(.4359,.8317,-.3439),(.4375,-.1945,.8779),(.4378,.8871,-.1464),(.4385,.8846,.1589),(.4413,.604,.6636),(.4426,.8783,.181),(.4435,.2844,.85),(.4452,-.2419,-.8621),(.4475,.8943,.0052),(.4502,-.8019,.3928),(.4514,.3733,-.8105),(.4516,-.7427,.4945),(.4516,.3243,-.8312),(.4566,-.8715,-.1789),(.4574,.7386,-.4952),(.4582,-.8296,.319),(.4597,.8012,-.383),(.461,.5149,.7227),(.4618,.1203,.8788),(.4636,-.6529,.5989),(.4662,.3628,.8069),(.4679,.5641,-.6804),(.4695,-.6591,.5875),(.4696,-.7535,.4602),(.4701,-.0762,-.8793),(.472,-.4355,-.7665),(.4729,-.7418,-.4754),(.473,.8797,-.0498),(.4733,.7888,-.3921),(.4742,-.503,-.7226),(.475,-.8798,-.0166),(.4761,.8646,-.1605),(.4761,.2506,-.8429),(.4775,.0068,.8786),(.4781,-.8272,-.2954),(.4789,.8777,-.0135),(.4802,.8543,-.1989),(.4823,.4354,-.7602),(.4836,-.8255,-.291),(.4837,-.8648,-.1347),(.485,.3535,-.7999),(.4852,.8318,.2697),(.4912,-.6858,-.5371),(.4916,.2176,.8432),(.4922,-.0538,-.8688),(.4975,-.438,-.7488),(.4982,.8607,-.105),(.4983,.8621,.0919),(.5037,.3627,.7841),(.5056,-.814,-.286),(.5081,-.2665,.819),(.5094,.0821,.8566),(.5104,-.8599,-.0115),(.5107,-.7795,-.3627),(.515,.5382,-.6672),(.521,-.7947,.3115),(.5218,-.1909,.8314),(.5233,-.7941,-.3092),(.5241,-.5949,.6094),(.5259,.7141,-.462),(.529,.3368,-.7789),(.5302,.4166,-.7385),(.5358,.1026,.8381),(.5361,.1219,.8353),(.5369,-.8122,.2281),(.5372,-.3098,.7845),(.5377,.3389,.772),(.5387,.5164,.6657),(.539,-.272,.7972),(.5391,-.8175,-.2026),(.5399,.3638,-.7591),(.5417,.8404,-.0182),(.5426,-.8353,-.0885),(.545,-.0872,.8339),(.5457,.8323,-.0974),(.5474,.1002,.8309),(.5476,.2209,-.8071),(.5483,-.8351,-.0448),(.549,.8358,-.0107),(.5495,.7203,.4234),(.5504,-.3658,-.7505),(.554,-.8297,-.0687),(.5542,-.8311,-.0468),(.5543,.4743,-.6839),(.5567,-.1019,-.8245),(.5577,-.6909,-.4601),(.5587,.8293,-.0065),(.5618,-.8272,-.0105),(.5621,.5733,-.5961),(.5639,.8186,.1089),(.5648,-.0383,-.8243),(.5668,.727,-.3877),(.568,.4576,-.6841),(.5706,-.1241,.8118),(.5722,-.8188,-.0459),(.5725,-.7458,-.3405),(.5725,.7224,.3877),(.5731,-.713,.4041),(.5736,-.7451,-.3404),(.574,-.8141,.0886),(.5749,-.4452,-.6865),(.5753,-.2537,.7776),(.5762,.4511,-.6815),(.5763,-.5495,.6049),(.5792,.8058,-.1232),(.5822,.3936,.7114),(.5855,.2659,-.7658),(.5868,.0906,.8046),(.5925,.3122,-.7426),(.5926,-.7859,-.1766),(.5932,-.7939,.1336),(.5972,-.6884,.4116),(.5979,-.2482,-.7621),(.5981,-.4786,-.6428),(.6008,.1651,-.7821),(.6014,-.7888,.1268),(.6028,.2468,-.7587),(.6037,-.1878,.7748),(.6042,.3689,-.7063),(.6044,-.0752,-.7931),(.6051,-.789,.106),(.6058,-.7956,-.006),(.6079,-.4181,.675),(.6086,-.1928,-.7697),(.6105,-.792,.0066),(.6128,-.6502,.4491),(.6131,.2008,.7641),(.6143,.3444,.71),(.6156,-.7003,.3615),(.6156,-.4524,-.6453),(.6209,.0613,-.7815),(.6212,-.5139,-.5917),(.6212,.7831,-.0294),(.6219,-.7728,-.1269),(.6247,-.6047,.4941),(.6326,.1914,-.7505),(.6332,.0033,-.774),(.6342,.5116,-.5797),(.6376,.6785,-.3647),(.6382,-.6102,-.4694),(.6397,-.7551,-.1435),(.6403,-.7533,.1501),(.6421,-.4005,-.6537),(.643,.6739,.3639),(.6461,-.7544,-.1161),(.6475,-.3753,-.6632),(.6501,.4793,.5896),(.6502,-.0678,-.7567),(.654,.3364,-.6776),(.6547,.3495,-.6702),(.6567,.0092,-.7541),(.6573,-.7531,-.0283),(.6596,.6251,-.4174),(.6689,.1274,-.7323),(.6697,-.7426,.0016),(.6704,-.3792,-.6378),(.6727,.3905,-.6285),(.673,-.1505,.7242),(.6746,.1033,-.7309),(.6761,.6831,.2761),(.677,-.2865,-.678),(.6805,.282,-.6763),(.6812,.6318,-.3699),(.6828,-.6528,.3281),(.6847,-.7288,.0079),(.6877,.3766,-.6207),(.688,-.2388,-.6853),(.6897,.4898,.5332),(.6943,-.6003,-.397),(.6966,-.3764,.6108),(.6987,-.226,-.6788),(.6996,.6763,-.2304),(.701,.002,-.7131),(.705,-.4565,-.5428),(.7051,.7069,-.0551),(.7092,.5769,.4053),(.7144,-.6916,-.1066),(.7145,.2629,.6484),(.7159,.6886,-.1152),(.7192,-.6923,-.0592),(.7238,.0475,.6884),(.7239,.3629,-.5867),(.7241,.6432,.2488),(.7241,-.4471,-.5251),(.7244,.0286,-.6888),(.7246,.6884,-.034),(.7248,-.519,.4532),(.7248,-.2124,-.6554),(.7277,-.5424,.4197),(.7282,-.1085,-.6767),(.7286,-.6835,.0446),(.7326,-.6563,.1805),(.7353,.6774,-.0202),(.737,.431,-.5207),(.738,.3573,.5724),(.7383,-.5869,.3325),(.7404,-.2572,-.621),(.7414,.5141,-.4314),(.743,.655,-.1375),(.7453,-.6445,-.1708),(.7453,.0561,.6643),(.746,.6545,-.1233),(.7479,.6549,-.1087),(.7493,-.2191,-.6249),(.7516,.3843,-.5361),(.7526,-.0132,.6584),(.7527,-.0461,.6568),(.7529,.6452,-.1297),(.753,.0935,-.6514),(.7531,-.6092,-.2482),(.7553,.4231,-.5005),(.7581,.313,-.5722),(.7582,-.6316,-.1618),(.759,-.5781,.2994),(.7596,-.576,.302),(.7616,-.5879,-.2726),(.7629,.4814,.4316),(.7636,.0312,.6449),(.7696,.6184,.1591),(.7706,-.1293,-.6241),(.7726,-.3268,-.5443),(.7732,.0749,.6297),(.7743,.2894,-.5627),(.7784,.2455,.5778),(.7816,.2346,.578),(.7828,.1443,-.6053),(.7831,-.5366,.3143),(.7866,.3853,-.4824),(.7892,-.5383,-.2956),(.7908,-.4887,.3685),(.7926,.1542,-.5899),(.7927,.4127,.4487),(.7947,-.5821,-.1722),(.7959,-.0647,.602),(.7994,.3918,-.4555),(.7994,.5592,-.2195),(.8036,-.4127,.4288),(.8052,.5872,.0828),(.8056,.5532,.212),(.8058,-.0909,.5851),(.8105,-.5818,.0673),(.8114,.5286,-.2495),(.812,.473,-.342),(.812,.4115,.4139),(.8125,-.1878,-.5519),(.8159,.3525,-.4583),(.8163,.5142,-.263),(.8175,.4289,.3844),(.8231,.0313,-.567),(.8237,-.1715,-.5405),(.826,-.3308,-.4564),(.8276,.5283,-.1895),(.8289,-.556,-.0607),(.8323,.1674,.5284),(.833,-.304,.4623),(.8404,.254,-.4787),(.8415,-.4206,-.339),(.8436,.3735,-.3857),(.8438,.1112,-.525),(.8489,-.0273,.5279),(.8519,-.3047,.426),(.8522,.4316,.2957),(.8545,-.2481,-.4563),(.8581,.5071,-.0807),(.8604,-.2281,.4558),(.863,-.0725,-.5),(.8633,-.0241,.5041),(.865,.3415,.3676),(.8662,-.4946,.0714),(.8677,-.0038,.4971),(.8682,-.4554,.1971),(.8683,.414,.2733),(.872,.3836,-.304),(.8755,.1267,-.4662),(.8757,.3339,.3489),(.8759,-.4758,.0795),(.8777,.4769,.0469),(.8777,-.4754,-.0599),(.8815,.1107,.4591),(.8823,-.1801,-.4349),(.8878,.2178,.4055),(.8889,-.4221,.1782),(.8962,.3942,.2035),(.899,-.3136,-.3058),(.8993,-.2409,-.3649),(.901,.3243,-.2881),(.9015,.2864,-.3243),(.9027,.416,-.1099),(.9045,.211,-.3705),(.9073,.3607,-.2161),(.908,.2647,-.3248),(.9094,-.2666,.3193),(.9099,-.4109,-.0564),(.9105,.4135,-.0005),(.9116,.2822,.2989),(.9134,-.3292,.2394),(.9137,.1863,-.3612),(.9162,.2789,-.2877),(.9215,.0982,.3758),(.9224,-.1647,-.3493),(.9228,.2909,-.2525),(.9247,.2799,-.2579),(.9259,.3102,-.2156),(.9274,-.372,-.0379),(.928,.2856,-.2394),(.9291,-.3288,.1694),(.9295,.2811,-.2387),(.9317,.3048,-.1977),(.9344,-.1695,-.3134),(.9354,.2475,-.2526),(.9357,.3198,-.1486),(.9364,.2721,-.2218),(.9385,.2587,.2287),(.9432,.1391,.3016),(.9433,-.1903,.2719),(.944,-.2346,.2318),(.9446,-.1463,-.2937),(.9516,.123,-.2816),(.9535,-.1548,.2586),(.9536,.0291,.2998),(.955,-.2375,-.1776),(.9573,-.1623,.2393),(.9573,.1354,.2553),(.9596,-.2584,-.1111),(.9598,.2718,.0697),(.9627,-.2688,-.0299),(.9638,-.0276,.2653),(.9642,-.265,-.008),(.9644,-.0345,-.2621),(.9685,.2225,-.1115),(.9692,-.1282,-.2102),(.9697,.2441,-.0106),(.9708,.0067,-.2398),(.9818,.154,-.1107),(.9879,.1544,.0137),(.9896,.0232,.1419),(.9903,.1265,.0576),(.9961,.0417,.0784),(.9977,.0298,-.0615),(.9983,-.0399,.0426),(.9996,.0287,.0032)]))),
      Shape(DEF='c2disc',
        appearance=Appearance(
          material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),shininess=0.050,specularColor=(.9647,.949,.9098))),
        geometry=IndexedFaceSet(DEF='c2disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,8,7,9,-1,10,11,12,-1,13,11,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,16,25,-1,26,16,20,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,33,-1,41,42,43,-1,41,43,40,-1,44,45,46,-1,47,44,48,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,60,-1,59,61,62,-1,63,64,65,-1,4,3,66,-1,67,65,68,-1,52,69,70,-1,71,72,73,-1,70,74,75,-1,13,14,76,-1,76,77,78,-1,9,7,79,-1,23,50,8,-1,80,68,3,-1,81,82,15,-1,81,83,82,-1,83,84,85,-1,6,79,7,-1,86,87,37,-1,37,4,86,-1,88,15,89,-1,63,67,35,-1,34,90,91,-1,92,75,93,-1,71,94,52,-1,71,73,94,-1,95,93,64,-1,96,93,78,-1,97,86,4,-1,4,66,98,-1,3,68,99,-1,54,60,62,-1,69,56,100,-1,94,53,52,-1,101,102,55,-1,79,61,59,-1,0,57,82,-1,1,0,82,-1,103,44,47,-1,44,104,33,-1,44,105,104,-1,45,40,43,-1,106,107,36,-1,108,33,35,-1,38,37,87,-1,109,31,30,-1,110,29,31,-1,111,27,112,-1,12,11,113,-1,81,15,17,-1,23,22,28,-1,88,18,16,-1,114,85,115,-1,91,116,117,-1,91,90,118,-1,89,15,82,-1,98,119,97,-1,119,101,97,-1,101,120,97,-1,82,57,89,-1,116,91,118,-1,19,50,23,-1,115,86,114,-1,18,20,16,-1,121,81,17,-1,111,112,122,-1,27,123,112,-1,11,124,113,-1,17,24,121,-1,24,25,125,-1,87,126,38,-1,108,127,33,-1,106,36,128,-1,39,129,41,-1,45,33,40,-1,44,33,45,-1,130,41,129,-1,41,130,42,-1,103,105,44,-1,82,83,1,-1,8,131,6,-1,101,55,2,-1,132,61,131,-1,94,73,133,-1,94,133,53,-1,62,134,54,-1,68,65,99,-1,98,97,4,-1,117,95,91,-1,52,135,71,-1,92,93,96,-1,91,63,34,-1,63,35,34,-1,67,108,35,-1,88,89,136,-1,4,37,5,-1,137,84,83,-1,85,114,83,-1,86,115,87,-1,81,137,83,-1,3,5,80,-1,21,23,8,-1,79,12,9,-1,76,78,138,-1,139,13,76,-1,70,75,92,-1,100,140,69,-1,117,116,78,-1,70,135,52,-1,67,63,65,-1,59,62,60,-1,54,69,52,-1,136,49,51,-1,141,89,57,-1,49,132,50,-1,142,106,128,-1,38,128,36,-1,127,39,33,-1,39,41,40,-1,36,5,37,-1,33,104,34,-1,30,32,113,-1,123,143,112,-1,26,112,143,-1,22,32,31,-1,27,111,28,-1,26,20,122,-1,112,26,122,-1,24,17,16,-1,21,32,22,-1,19,28,20,-1,15,88,16,-1,32,21,9,-1,13,124,11,-1,12,79,10,-1,9,21,8,-1,19,23,28,-1,99,66,3,-1,84,144,145,-1,144,84,137,-1,123,25,143,-1,123,125,25,-1,123,110,125,-1,29,22,31,-1,29,28,22,-1,9,113,32,-1,9,12,113,-1,110,109,146,-1,110,31,109,-1,124,30,113,-1,147,30,124,-1,148,149,150,-1,151,149,148,-1,152,153,154,-1,155,153,152,-1,85,156,115,-1,157,156,85,-1,127,80,107,-1,127,108,80,-1,130,107,106,-1,130,129,107,-1,38,158,128,-1,158,38,126,-1,159,160,161,-1,159,162,160,-1,163,164,165,-1,164,163,152,-1,166,156,157,-1,166,167,156,-1,114,1,83,-1,120,1,114,-1,6,61,79,-1,61,6,131,-1,54,133,60,-1,54,53,133,-1,55,100,56,-1,100,55,102,-1,93,117,78,-1,95,117,93,-1,71,70,92,-1,71,135,70,-1,75,99,65,-1,74,99,75,-1,51,19,18,-1,19,51,50,-1,51,88,136,-1,18,88,51,-1,138,116,118,-1,138,78,116,-1,140,70,69,-1,140,74,70,-1,66,74,140,-1,99,74,66,-1,58,168,10,-1,73,168,58,-1,49,61,132,-1,62,61,49,-1,132,8,50,-1,132,131,8,-1,159,152,163,-1,152,159,155,-1,158,161,160,-1,161,158,167,-1,47,139,103,-1,139,47,165,-1,48,46,162,-1,48,44,46,-1,105,118,90,-1,118,103,138,-1,105,103,118,-1,107,39,127,-1,39,107,129,-1,104,90,34,-1,104,105,90,-1,145,166,157,-1,145,151,166,-1,164,154,147,-1,152,154,164,-1,150,153,148,-1,150,146,153,-1,149,121,24,-1,144,121,149,-1,123,29,110,-1,123,27,29,-1,111,20,28,-1,111,122,20,-1,145,85,84,-1,85,145,157,-1,14,77,76,-1,168,77,14,-1,137,121,144,-1,137,81,121,-1,16,143,25,-1,16,26,143,-1,125,146,150,-1,125,110,146,-1,109,147,154,-1,109,30,147,-1,151,144,149,-1,145,144,151,-1,155,148,153,-1,169,148,155,-1,5,107,80,-1,36,107,5,-1,106,42,130,-1,142,42,106,-1,142,46,42,-1,160,128,158,-1,160,142,128,-1,163,162,159,-1,163,48,162,-1,165,13,139,-1,13,165,164,-1,167,169,161,-1,169,167,166,-1,49,89,141,-1,49,136,89,-1,141,62,49,-1,62,141,134,-1,91,64,63,-1,91,95,64,-1,170,101,119,-1,170,102,101,-1,93,65,64,-1,65,93,75,-1,168,72,77,-1,72,168,73,-1,100,170,140,-1,102,170,100,-1,10,14,11,-1,10,168,14,-1,67,80,108,-1,67,68,80,-1,92,72,71,-1,92,96,72,-1,77,96,78,-1,77,72,96,-1,140,98,66,-1,119,140,170,-1,119,98,140,-1,97,114,86,-1,114,97,120,-1,54,56,69,-1,54,134,56,-1,134,57,56,-1,57,134,141,-1,133,58,60,-1,133,73,58,-1,59,10,79,-1,59,58,10,-1,0,55,57,-1,0,2,55,-1,161,155,159,-1,155,161,169,-1,126,167,158,-1,167,126,156,-1,165,48,163,-1,165,47,48,-1,162,142,160,-1,162,46,142,-1,139,138,103,-1,139,76,138,-1,45,42,46,-1,45,43,42,-1,126,115,156,-1,87,115,126,-1,169,151,148,-1,166,151,169,-1,13,147,124,-1,164,147,13,-1,146,154,153,-1,146,109,154,-1,24,150,149,-1,24,125,150,-1,120,2,1,-1,101,2,120,-1],creaseAngle=1.571,normalIndex=[84,48,121,-1,150,155,157,-1,110,46,37,-1,37,46,15,-1,69,52,36,-1,83,52,80,-1,10,3,9,-1,8,11,0,-1,6,18,4,-1,20,3,22,-1,5,3,0,-1,29,2,31,-1,41,27,21,-1,167,165,164,-1,163,154,153,-1,169,160,167,-1,159,118,143,-1,159,143,160,-1,145,141,134,-1,117,145,131,-1,119,44,54,-1,81,63,32,-1,101,109,71,-1,66,61,40,-1,61,115,96,-1,137,33,55,-1,155,150,98,-1,132,55,128,-1,81,87,136,-1,99,105,91,-1,136,102,82,-1,83,80,116,-1,116,100,129,-1,15,46,49,-1,4,44,37,-1,158,128,150,-1,14,17,10,-1,14,26,17,-1,26,47,74,-1,110,49,46,-1,142,146,154,-1,154,155,142,-1,12,10,23,-1,137,132,164,-1,165,162,144,-1,125,82,58,-1,99,78,81,-1,99,91,78,-1,25,58,33,-1,108,58,129,-1,120,142,155,-1,155,98,76,-1,150,128,60,-1,32,40,96,-1,87,109,85,-1,78,63,81,-1,77,86,101,-1,49,115,61,-1,84,71,17,-1,48,84,17,-1,133,145,117,-1,145,152,167,-1,145,151,152,-1,141,160,143,-1,147,166,163,-1,161,167,164,-1,153,154,146,-1,38,27,41,-1,35,31,27,-1,7,29,13,-1,36,52,34,-1,14,10,9,-1,4,18,2,-1,12,8,3,-1,75,74,122,-1,144,103,28,-1,144,162,156,-1,23,10,17,-1,76,50,120,-1,50,77,120,-1,77,79,120,-1,17,71,23,-1,103,144,156,-1,11,44,4,-1,122,142,75,-1,8,0,3,-1,16,14,9,-1,7,13,1,-1,29,51,13,-1,52,57,34,-1,9,20,16,-1,20,22,39,-1,146,135,153,-1,161,170,167,-1,147,163,149,-1,169,168,159,-1,141,167,160,-1,145,167,141,-1,148,159,168,-1,159,148,118,-1,133,151,145,-1,17,26,48,-1,37,140,110,-1,77,101,121,-1,138,115,140,-1,78,91,72,-1,78,72,63,-1,96,68,32,-1,128,55,60,-1,76,120,155,-1,28,25,144,-1,81,124,99,-1,125,58,108,-1,144,137,165,-1,137,164,165,-1,132,161,164,-1,12,23,53,-1,155,154,157,-1,24,47,26,-1,74,75,26,-1,142,122,146,-1,14,24,26,-1,150,157,158,-1,6,4,37,-1,49,36,15,-1,116,129,139,-1,112,83,116,-1,136,82,125,-1,85,62,87,-1,28,103,129,-1,136,124,81,-1,132,137,55,-1,61,96,40,-1,32,87,81,-1,53,119,54,-1,111,23,71,-1,119,138,44,-1,130,147,149,-1,153,149,163,-1,170,169,167,-1,169,159,160,-1,163,157,154,-1,167,152,165,-1,41,21,34,-1,51,19,13,-1,5,13,19,-1,18,21,27,-1,29,7,2,-1,5,0,1,-1,13,5,1,-1,20,9,3,-1,6,21,18,-1,11,2,0,-1,10,12,3,-1,21,6,15,-1,83,57,52,-1,36,49,69,-1,15,6,37,-1,11,4,2,-1,60,98,150,-1,47,30,56,-1,30,47,24,-1,51,22,19,-1,51,39,22,-1,51,35,39,-1,31,18,27,-1,31,2,18,-1,15,34,21,-1,15,36,34,-1,35,38,42,-1,35,27,38,-1,57,41,34,-1,59,41,57,-1,64,45,43,-1,73,45,64,-1,93,67,65,-1,92,67,93,-1,74,114,122,-1,95,114,74,-1,170,158,166,-1,170,161,158,-1,148,166,147,-1,148,168,166,-1,153,123,149,-1,123,153,135,-1,104,126,107,-1,104,127,126,-1,106,88,113,-1,88,106,93,-1,89,114,95,-1,89,97,114,-1,75,48,26,-1,79,48,75,-1,110,115,49,-1,115,110,140,-1,32,72,40,-1,32,63,72,-1,101,85,109,-1,85,101,86,-1,58,28,129,-1,25,28,58,-1,99,136,125,-1,99,124,136,-1,82,60,55,-1,102,60,82,-1,54,11,8,-1,11,54,44,-1,54,12,53,-1,8,12,54,-1,139,103,156,-1,139,129,103,-1,62,136,87,-1,62,102,136,-1,98,102,62,-1,60,102,98,-1,66,94,69,-1,91,94,66,-1,119,115,138,-1,96,115,119,-1,138,37,44,-1,138,140,37,-1,104,93,106,-1,93,104,92,-1,123,107,126,-1,107,123,97,-1,117,112,133,-1,112,117,113,-1,131,134,127,-1,131,145,134,-1,151,156,162,-1,156,133,139,-1,151,133,156,-1,166,169,170,-1,169,166,168,-1,152,162,165,-1,152,151,162,-1,56,89,95,-1,56,73,89,-1,88,65,59,-1,93,65,88,-1,43,67,64,-1,43,42,67,-1,45,16,20,-1,30,16,45,-1,51,31,35,-1,51,29,31,-1,7,0,2,-1,7,1,0,-1,56,74,47,-1,74,56,95,-1,80,100,116,-1,94,100,80,-1,24,16,30,-1,24,14,16,-1,3,19,22,-1,3,5,19,-1,39,42,43,-1,39,35,42,-1,38,59,65,-1,38,41,59,-1,73,30,45,-1,56,30,73,-1,92,64,67,-1,90,64,92,-1,157,166,158,-1,163,166,157,-1,147,118,148,-1,130,118,147,-1,130,134,118,-1,126,149,123,-1,126,130,149,-1,106,127,104,-1,106,131,127,-1,113,83,112,-1,83,113,88,-1,97,90,107,-1,90,97,89,-1,119,23,111,-1,119,53,23,-1,111,96,119,-1,96,111,68,-1,144,33,137,-1,144,25,33,-1,70,77,50,-1,70,86,77,-1,58,55,33,-1,55,58,82,-1,94,105,100,-1,105,94,91,-1,85,70,62,-1,86,70,85,-1,69,80,52,-1,69,94,80,-1,132,158,161,-1,132,128,158,-1,125,105,99,-1,125,108,105,-1,100,108,129,-1,100,105,108,-1,62,76,98,-1,50,62,70,-1,50,76,62,-1,120,75,142,-1,75,120,79,-1,32,109,87,-1,32,68,109,-1,68,71,109,-1,71,68,111,-1,72,66,40,-1,72,91,66,-1,61,69,49,-1,61,66,69,-1,84,101,71,-1,84,121,101,-1,107,92,104,-1,92,107,90,-1,135,97,123,-1,97,135,114,-1,113,131,106,-1,113,117,131,-1,127,130,126,-1,127,134,130,-1,112,139,133,-1,112,116,139,-1,141,118,134,-1,141,143,118,-1,135,122,114,-1,146,122,135,-1,90,73,64,-1,89,73,90,-1,83,59,57,-1,88,59,83,-1,42,65,67,-1,42,38,65,-1,20,43,45,-1,20,39,43,-1,79,121,48,-1,77,121,79,-1],
          coord=Coordinate(DEF='c2disc_Coord',point=[(-.10274,54.9724,-.65812),(-.09943,54.95951,-.65651),(-.08404,54.96524,-.66089),(.20682,55.03216,-.75613),(.17272,54.98617,-.69333),(.22825,55.0025,-.75881),(-.19984,55.05656,-1.08393),(-.20947,55.05343,-1.08372),(-.23791,55.07225,-1.05795),(-.21909,55.05031,-1.08352),(-.07595,55.02756,-1.12859),(-.07931,55.01614,-1.13051),(-.14135,55.01943,-1.1133),(0,55.00358,-1.11833),(0,55.01726,-1.12587),(-.2418,54.99968,-.75712),(-.28353,55.0125,-.82505),(-.24082,54.97961,-.76267),(-.29346,55.05125,-.88875),(-.28046,55.06802,-.95595),(-.29488,55.0311,-.89013),(-.25073,55.06406,-1.0496),(-.25558,55.05728,-1.00669),(-.27158,55.0684,-1.00386),(-.21118,54.95672,-.78208),(-.25294,54.98017,-.8468),(-.29157,55.00596,-.8746),(-.26779,55.00679,-.92018),(-.2868,55.05053,-.95059),(-.2494,55.01486,-.93726),(-.12897,55.01328,-1.04961),(-.18128,55.01241,-1.00138),(-.22432,55.05256,-1.05445),(.28662,55.05027,-.95052),(.26569,55.06766,-1.01945),(.2827,55.07234,-.96703),(.24208,54.98058,-.76184),(.17402,54.95196,-.70569),(.17324,54.92991,-.71985),(.29505,55.01987,-.89243),(.28758,55.0202,-.91505),(.2883,55.00073,-.89681),(.24521,54.99316,-.90637),(.26779,55.00679,-.92018),(.18128,55.01241,-1.00138),(.2494,55.01486,-.93726),(.19918,54.98983,-.91432),(.12897,55.01328,-1.04961),(.1341,54.99381,-1.00315),(-.21134,55.06628,-.91561),(-.26306,55.07911,-.98645),(-.25678,55.0673,-.90237),(0,55.0988,-.86946),(-.02727,55.09068,-.89573),(-.07641,55.08415,-.8464),(-.06096,54.96458,-.67714),(-.09916,55.0055,-.72567),(-.14305,55.01088,-.68829),(-.04231,55.05291,-1.05414),(-.10254,55.05278,-1.02591),(-.11043,55.06945,-.93075),(-.17021,55.04598,-1.01664),(-.16917,55.05535,-.9197),(.27211,55.07911,-.98026),(.22394,55.06583,-1.00507),(.21134,55.06628,-.91561),(.14305,55.01088,-.68829),(.26919,55.06497,-.89718),(.2579,55.0592,-.86072),(0,55.09125,-.80454),(.07641,55.08415,-.8464),(.04076,55.08345,-.94665),(.04231,55.05291,-1.05414),(0,55.05601,-1.05028),(.122,55.04324,-.81006),(.16917,55.05535,-.9197),(.07767,55.01611,-1.13202),(.07595,55.02756,-1.12859),(.14184,55.02771,-1.11399),(-.14184,55.02771,-1.11399),(.27633,55.04356,-.84141),(-.19723,54.9597,-.72162),(-.17253,54.98646,-.69317),(-.10713,54.94738,-.66399),(-.06278,54.91393,-.67426),(-.00113,54.91041,-.66839),(.1053,54.95069,-.66295),(.11997,54.92354,-.68772),(-.27798,55.02899,-.82298),(-.2108,55.03431,-.75085),(.238,55.06075,-1.06829),(.23535,55.07204,-1.07142),(.11043,55.06945,-.93075),(.17021,55.04598,-1.01664),(0,55.07565,-.94583),(.20783,55.06162,-1.06452),(.10254,55.05278,-1.02591),(.09862,54.96111,-.65644),(.10253,54.97309,-.65851),(.15993,55.05072,-.77208),(0,55.01897,-.71215),(-.00002,54.95533,-.64593),(0,54.96192,-.66517),(.1503,55.02129,-1.09507),(.24935,55.05701,-1.01661),(.22833,55.05361,-1.05887),(.25294,54.98017,-.8468),(.28133,55.01017,-.82662),(.28837,55.05071,-.89045),(-.1341,54.99381,-1.00315),(-.19918,54.98983,-.91432),(-.28758,55.0202,-.91505),(-.28576,55.00306,-.89577),(-.14992,55.02089,-1.09456),(-.00045,54.92765,-.65239),(.06057,54.91339,-.67329),(.21164,55.05803,-1.09347),(.19984,55.05656,-1.08393),(.22519,55.05565,-1.08735),(.08384,54.96574,-.66117),(-.00017,54.94391,-.64167),(-.20494,54.94676,-.74365),(-.29234,55.01778,-.89288),(-.24521,54.99316,-.90637),(-.07938,55.01261,-1.1168),(-.20161,54.97628,-.85812),(.11797,54.90492,-.70395),(.2974,55.02926,-.89048),(.21118,54.95672,-.78208),(.29157,55.00596,-.8746),(.27288,54.9892,-.87446),(-.20783,55.06162,-1.06452),(-.22394,55.06583,-1.00507),(-.04076,55.08345,-.94665),(-.122,55.04324,-.81006),(.02727,55.09068,-.89573),(-.2423,55.05966,-.85901),(-.11184,54.92341,-.68625),(.14565,55.02205,-1.11004),(.07808,55.0146,-1.12105),(.09916,55.0055,-.72567),(-.15993,55.05072,-.77208),(.20161,54.97628,-.85812),(-.27288,54.9892,-.87446),(-.11694,54.90629,-.70475),(-.05261,54.89561,-.68475),(-.13401,54.96301,-.92299),(-.0721,55.00893,-1.05916),(-.05838,54.93798,-.85018),(-.12128,54.92684,-.77523),(-.13244,54.95263,-.8587),(-.05231,54.91686,-.76796),(0,54.97773,-.99405),(-.06407,54.95763,-.92288),(-.07167,54.98603,-1.00034),(0,54.95281,-.92526),(.05261,54.89561,-.68475),(0,54.89285,-.67654),(.12128,54.92684,-.77523),(.06407,54.95763,-.92288),(.13244,54.95263,-.8587),(.05838,54.93798,-.85018),(.13401,54.96301,-.92299),(.07167,54.98603,-1.00034),(0,54.99827,-1.06566),(.0721,55.00893,-1.05916),(0,54.9167,-.76364),(.05231,54.91686,-.76796),(0,55.03534,-1.12115),(0,54.93377,-.84515),(.06096,54.96458,-.67714)]),
          normal=Normal(vector=[(-.9994,-.027,-.0236),(-.9537,-.2447,-.1747),(-.9311,-.1951,-.3081),(-.9095,-.2383,.3407),(-.9047,.1008,-.414),(-.8924,-.4468,.0629),(-.8593,-.1744,-.4808),(-.8061,-.4478,-.3869),(-.7971,.5806,.166),(-.7807,-.5177,.3501),(-.7567,.1261,.6415),(-.7263,.6874,.0005),(-.7122,.5587,.4249),(-.6688,-.6767,-.3079),(-.6285,-.4079,.6623),(-.6103,-.274,-.7432),(-.5742,-.7947,.1967),(-.5631,.0806,.8225),(-.526,-.7929,-.3075),(-.4523,-.8877,-.0861),(-.4431,-.8849,-.1436),(-.4162,-.9011,-.1215),(-.4114,-.9109,-.0322),(-.4108,.7466,.5232),(-.4079,-.5986,.6895),(-.3853,.9223,-.0304),(-.3838,-.4316,.8163),(-.3758,-.8594,-.3467),(-.3715,.9158,-.1525),(-.37,-.7587,-.5361),(-.3588,-.8999,.2481),(-.3425,-.7917,-.5059),(-.3165,.927,.2013),(-.3076,.9515,-.0023),(-.2983,-.9528,-.0566),(-.2926,-.9068,-.3035),(-.2845,-.7388,-.6109),(-.2445,.8577,-.4523),(-.2415,-.8999,-.3631),(-.2343,-.9422,-.2394),(-.2338,.962,-.1412),(-.2321,-.9432,-.2377),(-.2298,-.9383,-.2584),(-.2274,-.9487,-.2199),(-.2236,.9728,-.0599),(-.2106,-.9444,-.2524),(-.2056,.5824,-.7865),(-.1994,-.5305,.8239),(-.1949,-.0833,.9773),(-.1931,.5307,-.8253),(-.1812,.808,.5606),(-.1797,-.9028,-.3906),(-.1704,-.4907,-.8545),(-.1564,.9554,.2506),(-.1547,.9676,.1998),(-.1543,.9872,.041),(-.1447,-.9235,.3553),(-.1365,-.9771,-.163),(-.1319,.9861,-.1012),(-.126,-.9693,-.2113),(-.1167,.9495,.2914),(-.1148,.9738,-.1965),(-.1071,.863,.4938),(-.1042,.9818,-.1587),(-.1025,-.9633,-.2481),(-.0993,-.9352,-.3399),(-.091,.9597,-.2659),(-.0902,-.9549,-.283),(-.0844,.9518,.2948),(-.0834,.6359,-.7672),(-.0636,.8879,.4556),(-.0541,.7227,.689),(-.052,.9807,-.1887),(-.0499,-.969,-.2421),(-.0294,-.5604,.8277),(-.0195,-.6007,.7993),(-.015,.49,.8716),(-.0148,.6974,.7165),(-.0142,.9754,-.22),(-.0058,-.1455,.9893),(-.0055,-.1244,-.9922),(-.0047,.999,-.0453),(-.0026,.9997,-.0226),(-.0005,-.8697,-.4937),(0,.4454,.8953),(0,.7271,.6866),(0,.8401,.5425),(0,.9182,.3961),(0,-.9787,-.2053),(0,-.9731,-.2304),(0,-.9729,-.2313),(0,.964,-.2661),(0,-.9559,-.2935),(0,-.9508,-.3098),(0,.7244,-.6894),(.0042,-.8869,.4619),(.0132,.9992,-.0366),(.0473,-.9685,-.2445),(.0632,.7258,.685),(.0665,.9769,-.2029),(.0727,.6812,-.7285),(.0742,.8814,.4665),(.0844,.9518,.2948),(.0867,.5223,-.8483),(.0902,-.9549,-.283),(.091,.9597,-.2659),(.0993,-.9352,-.3399),(.1025,-.9633,-.2481),(.105,.9725,-.2078),(.1087,.869,.4827),(.1175,.8473,-.5179),(.1194,.9579,.261),(.1281,-.9851,-.1146),(.1305,-.966,-.2232),(.1317,-.929,.3459),(.1467,.9855,-.0856),(.1468,-.4909,-.8588),(.1478,-.9614,-.2321),(.1631,-.9049,-.3932),(.1676,.9846,.0498),(.1842,-.0555,.9813),(.1855,.7314,.6562),(.2094,-.5579,.8031),(.2109,-.9429,-.2579),(.2112,.974,-.0822),(.2163,.9685,-.1234),(.2274,-.9487,-.2199),(.2298,-.9383,-.2584),(.2301,.9421,.244),(.2311,.4152,-.8799),(.2343,-.9422,-.2394),(.2415,-.8999,-.3631),(.2757,.9407,.1978),(.2831,-.9472,-.1503),(.2926,-.9068,-.3035),(.3163,-.9205,.2295),(.3165,.927,.2013),(.3196,.9413,-.1086),(.3312,.9435,-.0087),(.334,-.7738,-.5382),(.3629,.9305,-.0502),(.3665,-.7704,-.5217),(.3682,-.394,.8421),(.3707,-.6878,-.6241),(.3819,.8001,-.4626),(.3866,-.8727,-.2983),(.3962,-.5567,.7302),(.4089,-.911,-.0532),(.4346,-.8992,-.0511),(.4381,-.8929,-.1044),(.4582,.7027,.5444),(.4771,-.863,-.1662),(.4889,-.8322,-.2615),(.5432,-.7884,.2888),(.6146,-.3327,.7152),(.6156,.1051,.781),(.6587,-.3252,-.6786),(.6662,.331,.6683),(.6765,.6115,.4104),(.6797,-.6723,-.2934),(.7377,-.4686,-.4861),(.7809,.6012,.1699),(.7969,-.4527,-.4001),(.8076,-.2832,.5173),(.8396,.5371,-.0816),(.8932,-.065,-.4449),(.8968,-.1686,.409),(.8973,-.3112,-.3132),(.9011,-.4074,.1487),(.965,-.245,-.0938),(.9966,.0634,.0522)]))),
      Shape(DEF='c3',
        appearance=Appearance(
          material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),shininess=0.050,specularColor=(.349,.349,.349))),
        geometry=IndexedFaceSet(DEF='c3_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,26,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,47,62,63,-1,64,65,66,-1,67,68,60,-1,49,69,62,-1,70,71,72,-1,73,74,75,-1,76,77,78,-1,67,56,79,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,95,-1,100,101,102,-1,103,104,105,-1,106,103,107,-1,108,109,110,-1,111,112,113,-1,112,114,115,-1,116,117,118,-1,119,120,108,-1,121,119,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,141,142,143,-1,142,144,129,-1,145,146,147,-1,148,149,150,-1,151,152,149,-1,51,153,154,-1,36,155,156,-1,157,158,159,-1,160,161,162,-1,2,1,163,-1,164,165,166,-1,167,168,169,-1,170,171,172,-1,173,174,175,-1,176,177,178,-1,179,180,181,-1,182,183,162,-1,184,185,186,-1,187,188,189,-1,190,150,149,-1,191,179,192,-1,193,194,195,-1,196,197,198,-1,199,200,6,-1,201,202,14,-1,203,166,174,-1,204,205,206,-1,207,208,209,-1,210,198,197,-1,211,212,213,-1,214,215,25,-1,216,217,55,-1,53,218,214,-1,11,217,216,-1,219,220,221,-1,222,223,44,-1,224,225,226,-1,227,228,224,-1,229,230,231,-1,229,232,233,-1,234,235,46,-1,66,226,225,-1,61,236,237,-1,238,239,240,-1,241,147,242,-1,195,243,244,-1,245,246,247,-1,241,248,249,-1,250,241,251,-1,252,253,192,-1,254,255,256,-1,257,133,132,-1,258,259,260,-1,185,261,262,-1,263,264,265,-1,106,266,103,-1,58,267,268,-1,269,268,270,-1,271,267,272,-1,269,270,273,-1,82,274,275,-1,118,276,128,-1,277,278,43,-1,279,34,280,-1,281,282,283,-1,165,164,284,-1,168,285,286,-1,287,288,283,-1,289,290,291,-1,292,293,294,-1,295,296,297,-1,298,299,167,-1,300,301,80,-1,302,298,303,-1,303,304,305,-1,306,307,308,-1,100,102,309,-1,310,311,312,-1,313,314,315,-1,316,107,317,-1,305,318,319,-1,319,320,302,-1,321,154,322,-1,323,324,325,-1,326,327,10,-1,328,329,330,-1,331,332,329,-1,333,334,335,-1,336,337,338,-1,339,340,341,-1,342,343,344,-1,345,346,347,-1,348,349,350,-1,351,352,353,-1,354,349,355,-1,356,357,358,-1,359,360,361,-1,362,363,364,-1,338,365,366,-1,69,367,368,-1,369,370,371,-1,372,373,374,-1,375,376,359,-1,377,378,379,-1,380,381,371,-1,359,376,69,-1,382,383,384,-1,385,386,387,-1,388,389,382,-1,390,371,381,-1,391,392,393,-1,394,395,396,-1,397,398,399,-1,400,401,402,-1,403,404,405,-1,406,407,408,-1,409,410,411,-1,412,413,414,-1,415,416,417,-1,418,417,419,-1,420,421,422,-1,423,424,425,-1,422,426,427,-1,428,429,430,-1,431,432,433,-1,434,426,422,-1,426,434,435,-1,436,124,123,-1,437,438,439,-1,440,441,442,-1,443,444,445,-1,446,447,448,-1,449,450,451,-1,452,453,454,-1,453,455,442,-1,456,457,458,-1,459,460,461,-1,461,447,462,-1,364,363,463,-1,464,340,465,-1,466,467,468,-1,469,470,471,-1,163,1,472,-1,473,474,475,-1,476,477,478,-1,479,480,481,-1,482,474,483,-1,484,485,486,-1,487,488,489,-1,469,490,491,-1,492,493,494,-1,495,496,497,-1,461,460,498,-1,499,489,500,-1,501,502,503,-1,368,367,504,-1,202,505,506,-1,368,507,508,-1,473,509,483,-1,510,511,512,-1,513,512,514,-1,515,516,517,-1,518,519,520,-1,436,521,518,-1,522,523,524,-1,522,525,523,-1,526,527,336,-1,352,528,529,-1,338,366,530,-1,531,532,533,-1,534,357,531,-1,535,536,537,-1,537,538,535,-1,539,540,541,-1,542,507,543,-1,544,545,543,-1,377,387,546,-1,536,535,547,-1,548,549,550,-1,551,552,374,-1,553,554,555,-1,489,499,471,-1,556,557,558,-1,559,558,560,-1,499,561,562,-1,560,563,564,-1,443,565,566,-1,567,568,569,-1,493,570,571,-1,572,573,574,-1,417,575,419,-1,576,577,369,-1,578,579,577,-1,580,581,582,-1,583,584,585,-1,586,587,391,-1,588,510,464,-1,589,339,590,-1,591,592,593,-1,594,595,596,-1,597,475,598,-1,599,600,601,-1,591,602,603,-1,604,605,606,-1,607,495,608,-1,609,610,611,-1,612,613,614,-1,612,573,613,-1,615,616,617,-1,393,618,619,-1,620,617,621,-1,622,623,620,-1,624,625,626,-1,627,412,414,-1,628,629,630,-1,631,632,633,-1,634,418,635,-1,636,637,622,-1,638,639,640,-1,481,498,460,-1,641,474,642,-1,643,388,644,-1,645,364,646,-1,636,647,432,-1,435,434,648,-1,409,649,650,-1,413,410,651,-1,411,652,653,-1,654,404,403,-1,655,630,629,-1,656,657,398,-1,402,658,659,-1,660,661,627,-1,662,622,429,-1,615,617,620,-1,663,657,400,-1,664,663,394,-1,665,666,667,-1,613,573,668,-1,669,670,610,-1,615,496,476,-1,604,671,672,-1,603,673,674,-1,675,676,677,-1,678,599,679,-1,674,595,680,-1,679,677,681,-1,682,683,606,-1,684,685,686,-1,687,510,513,-1,655,585,688,-1,689,348,690,-1,530,582,691,-1,690,579,578,-1,577,576,584,-1,390,692,576,-1,577,579,693,-1,694,695,565,-1,448,696,697,-1,454,698,462,-1,699,562,700,-1,560,558,456,-1,701,702,501,-1,487,703,488,-1,502,501,702,-1,557,704,558,-1,705,706,707,-1,708,555,554,-1,379,378,709,-1,710,551,374,-1,550,555,711,-1,712,713,537,-1,534,714,715,-1,716,717,538,-1,693,712,536,-1,716,538,718,-1,719,720,356,-1,721,722,544,-1,723,724,720,-1,365,337,532,-1,202,725,726,-1,327,326,529,-1,352,727,527,-1,728,729,341,-1,687,513,730,-1,731,732,733,-1,514,512,734,-1,735,734,512,-1,473,736,509,-1,737,542,738,-1,504,367,739,-1,740,498,741,-1,642,460,459,-1,742,743,569,-1,744,485,458,-1,468,467,480,-1,593,475,597,-1,745,746,732,-1,598,474,747,-1,566,748,749,-1,466,744,750,-1,751,703,752,-1,471,490,469,-1,744,753,486,-1,744,466,753,-1,687,341,340,-1,598,754,755,-1,515,756,463,-1,757,643,758,-1,759,635,418,-1,442,759,440,-1,696,448,447,-1,760,441,440,-1,451,454,462,-1,761,762,696,-1,648,445,444,-1,446,445,449,-1,763,441,764,-1,755,647,765,-1,572,492,470,-1,766,433,767,-1,433,432,647,-1,768,660,624,-1,769,622,637,-1,425,770,417,-1,634,635,771,-1,772,619,665,-1,411,773,406,-1,774,650,775,-1,407,776,408,-1,777,630,633,-1,404,778,405,-1,396,779,780,-1,392,394,393,-1,586,391,667,-1,546,781,384,-1,782,645,640,-1,373,370,693,-1,546,384,378,-1,383,382,389,-1,386,644,781,-1,370,373,372,-1,693,783,710,-1,784,785,786,-1,580,582,350,-1,691,787,338,-1,584,583,346,-1,788,347,346,-1,789,667,666,-1,465,340,790,-1,791,738,792,-1,793,794,795,-1,335,796,328,-1,506,797,329,-1,798,326,726,-1,726,799,798,-1,800,798,801,-1,802,803,804,-1,793,805,323,-1,806,794,323,-1,807,159,808,-1,809,175,209,-1,810,78,811,-1,812,74,321,-1,813,322,154,-1,319,814,815,-1,107,103,317,-1,816,110,817,-1,818,119,121,-1,819,820,99,-1,821,98,101,-1,822,823,824,-1,94,93,825,-1,826,312,827,-1,828,829,830,-1,831,89,91,-1,832,308,309,-1,115,114,305,-1,303,298,833,-1,301,834,80,-1,835,836,837,-1,838,839,263,-1,293,840,841,-1,169,188,833,-1,842,843,844,-1,845,846,286,-1,843,842,847,-1,848,299,298,-1,849,850,845,-1,851,291,852,-1,853,854,855,-1,204,856,857,-1,858,273,827,-1,859,272,860,-1,220,861,221,-1,272,862,860,-1,270,268,267,-1,863,268,864,-1,865,866,267,-1,266,106,867,-1,868,869,870,-1,257,871,133,-1,872,873,135,-1,151,142,141,-1,162,161,264,-1,256,147,250,-1,874,195,194,-1,241,875,248,-1,876,877,878,-1,240,239,879,-1,880,64,881,-1,882,59,883,-1,884,236,61,-1,225,224,862,-1,885,886,222,-1,227,887,888,-1,862,866,865,-1,889,225,865,-1,890,228,227,-1,891,24,219,-1,892,893,894,-1,202,10,9,-1,895,217,11,-1,54,896,55,-1,33,35,39,-1,204,857,897,-1,170,898,899,-1,212,211,900,-1,901,165,902,-1,903,206,205,-1,208,207,206,-1,174,901,209,-1,368,230,904,-1,19,905,231,-1,63,62,906,-1,906,907,908,-1,195,909,243,-1,910,193,875,-1,152,911,808,-1,912,150,809,-1,260,259,868,-1,839,182,264,-1,913,914,145,-1,158,898,159,-1,164,166,281,-1,284,164,281,-1,915,900,746,-1,916,203,173,-1,917,914,807,-1,918,246,919,-1,184,920,247,-1,183,252,160,-1,176,157,807,-1,33,897,857,-1,118,902,165,-1,197,921,922,-1,923,811,924,-1,316,925,926,-1,926,925,129,-1,136,135,911,-1,151,149,148,-1,131,130,927,-1,903,928,929,-1,809,209,930,-1,138,136,151,-1,917,808,911,-1,931,134,140,-1,140,134,137,-1,133,137,134,-1,932,130,148,-1,320,116,118,-1,161,186,264,-1,276,117,933,-1,116,815,117,-1,832,115,934,-1,305,302,303,-1,817,935,936,-1,104,103,937,-1,105,938,316,-1,836,300,837,-1,939,95,940,-1,819,821,941,-1,96,817,97,-1,313,312,311,-1,92,942,93,-1,943,944,83,-1,80,85,81,-1,835,82,275,-1,71,70,945,-1,813,946,888,-1,57,59,882,-1,64,71,945,-1,76,72,238,-1,70,810,74,-1,59,57,56,-1,882,889,865,-1,947,948,949,-1,950,861,951,-1,219,952,220,-1,32,953,273,-1,953,31,274,-1,37,835,954,-1,38,280,36,-1,219,26,40,-1,905,19,955,-1,956,955,19,-1,957,958,959,-1,16,201,960,-1,961,12,14,-1,961,11,216,-1,15,8,7,-1,957,3,962,-1,963,3,964,-1,472,1,564,-1,1,0,564,-1,963,4,3,-1,957,964,3,-1,15,20,8,-1,892,961,216,-1,961,14,9,-1,9,11,961,-1,16,965,201,-1,960,13,21,-1,959,964,957,-1,19,966,956,-1,952,219,40,-1,280,155,36,-1,37,954,38,-1,28,277,967,-1,32,273,270,-1,26,25,215,-1,234,45,968,-1,224,969,970,-1,971,968,45,-1,25,972,54,-1,947,53,948,-1,56,60,59,-1,238,77,76,-1,64,945,65,-1,865,57,882,-1,322,813,888,-1,70,76,810,-1,76,78,810,-1,865,58,57,-1,835,837,82,-1,85,84,81,-1,86,828,87,-1,83,88,943,-1,942,973,93,-1,311,314,313,-1,817,936,97,-1,941,974,819,-1,940,822,939,-1,831,975,89,-1,105,316,317,-1,104,937,936,-1,817,109,935,-1,934,308,832,-1,105,104,976,-1,815,933,117,-1,109,817,110,-1,276,933,977,-1,148,912,932,-1,133,871,137,-1,137,138,140,-1,931,140,818,-1,911,873,917,-1,151,141,138,-1,208,903,929,-1,130,932,978,-1,144,151,148,-1,136,911,152,-1,131,926,129,-1,107,316,926,-1,923,924,979,-1,197,196,921,-1,165,980,118,-1,155,33,857,-1,176,807,913,-1,160,162,183,-1,247,981,184,-1,257,918,919,-1,914,913,807,-1,869,246,918,-1,901,174,165,-1,746,745,915,-1,284,281,288,-1,898,172,159,-1,145,177,913,-1,839,264,263,-1,868,982,260,-1,152,808,190,-1,193,195,244,-1,193,244,875,-1,907,904,908,-1,203,983,166,-1,206,903,208,-1,205,210,903,-1,900,984,212,-1,899,985,170,-1,897,986,204,-1,39,897,33,-1,54,972,896,-1,327,895,11,-1,202,9,14,-1,22,892,894,-1,891,219,987,-1,234,968,235,-1,233,988,989,-1,45,234,46,-1,890,990,228,-1,225,862,865,-1,227,888,890,-1,885,222,990,-1,224,970,862,-1,61,991,884,-1,883,237,882,-1,881,992,880,-1,878,884,876,-1,241,242,875,-1,147,177,145,-1,195,874,909,-1,147,241,250,-1,151,144,142,-1,873,911,135,-1,257,993,871,-1,869,918,870,-1,994,266,867,-1,865,267,58,-1,863,864,79,-1,267,271,270,-1,272,866,862,-1,860,995,859,-1,858,269,273,-1,856,156,857,-1,27,34,279,-1,853,855,996,-1,849,845,997,-1,848,298,998,-1,847,999,843,-1,845,286,1000,-1,850,1001,1002,-1,844,287,842,-1,1003,290,289,-1,169,833,167,-1,841,294,293,-1,838,263,296,-1,835,37,836,-1,85,834,1004,-1,115,305,1005,-1,309,1006,832,-1,100,309,307,-1,91,1007,831,-1,830,87,828,-1,1008,826,827,-1,822,824,939,-1,1009,821,101,-1,97,315,940,-1,121,931,818,-1,816,817,820,-1,815,116,319,-1,154,153,813,-1,74,923,321,-1,78,927,811,-1,175,174,209,-1,808,917,807,-1,323,1010,806,-1,323,794,793,-1,802,804,331,-1,800,326,798,-1,726,725,799,-1,328,506,329,-1,795,1011,793,-1,792,1012,791,-1,792,738,542,-1,340,339,790,-1,790,789,666,-1,581,1013,344,-1,584,346,345,-1,1014,336,1015,-1,724,356,720,-1,713,358,537,-1,356,724,366,-1,527,727,336,-1,786,1016,784,-1,370,372,371,-1,383,389,553,-1,377,546,378,-1,710,373,693,-1,717,782,640,-1,370,369,693,-1,391,772,667,-1,392,395,394,-1,398,657,399,-1,780,397,396,-1,404,1017,778,-1,633,632,777,-1,407,425,776,-1,774,651,650,-1,411,406,1018,-1,402,1019,658,-1,634,771,415,-1,425,417,416,-1,620,621,622,-1,769,429,622,-1,768,428,660,-1,423,416,415,-1,647,767,433,-1,427,776,420,-1,766,767,1020,-1,764,459,763,-1,446,449,451,-1,648,449,445,-1,696,741,761,-1,462,447,451,-1,1021,641,642,-1,1022,764,441,-1,763,461,698,-1,461,462,698,-1,447,740,696,-1,442,455,759,-1,759,455,635,-1,757,1023,643,-1,463,1024,515,-1,598,755,1025,-1,687,1026,341,-1,471,562,490,-1,494,751,752,-1,466,750,761,-1,483,509,1027,-1,732,1028,745,-1,597,602,593,-1,593,473,475,-1,480,479,468,-1,458,750,744,-1,569,1029,742,-1,741,696,740,-1,1030,501,503,-1,1031,701,501,-1,540,504,739,-1,739,376,375,-1,504,507,368,-1,641,747,474,-1,512,511,735,-1,514,734,517,-1,754,598,747,-1,733,520,731,-1,730,1026,687,-1,341,1026,728,-1,527,528,352,-1,529,895,327,-1,726,10,202,-1,365,338,337,-1,718,1032,716,-1,693,536,783,-1,693,579,712,-1,717,1033,538,-1,715,1032,534,-1,712,537,536,-1,547,535,377,-1,711,548,550,-1,710,374,373,-1,709,1034,379,-1,707,711,705,-1,704,1035,558,-1,458,485,456,-1,487,752,703,-1,560,456,563,-1,572,470,469,-1,562,561,700,-1,454,453,698,-1,696,762,697,-1,694,1036,695,-1,369,577,693,-1,390,576,1037,-1,584,1038,577,-1,690,712,579,-1,689,690,578,-1,655,583,585,-1,687,464,510,-1,1039,590,342,-1,1040,684,686,-1,1041,679,681,-1,1042,617,1043,-1,617,616,1043,-1,674,596,595,-1,679,1044,678,-1,674,680,603,-1,476,478,615,-1,669,610,609,-1,573,1045,668,-1,772,665,667,-1,393,663,618,-1,400,1046,663,-1,662,429,428,-1,660,627,624,-1,625,627,414,-1,659,400,402,-1,656,1047,657,-1,655,629,1048,-1,411,653,773,-1,413,651,1049,-1,406,631,407,-1,648,444,435,-1,634,417,418,-1,432,1050,636,-1,646,640,645,-1,643,760,388,-1,474,482,642,-1,481,480,498,-1,640,646,638,-1,622,621,636,-1,425,631,770,-1,408,776,649,-1,406,1051,631,-1,633,770,631,-1,628,630,777,-1,659,658,412,-1,624,627,625,-1,622,662,623,-1,394,663,393,-1,619,772,393,-1,615,478,616,-1,612,574,573,-1,612,614,497,-1,609,611,614,-1,591,603,680,-1,678,477,1052,-1,679,675,677,-1,598,1025,597,-1,594,596,1053,-1,593,602,591,-1,1054,1040,347,-1,589,590,1039,-1,1040,686,1055,-1,586,788,587,-1,581,691,582,-1,578,577,1038,-1,1037,576,369,-1,417,688,575,-1,574,570,572,-1,571,1056,493,-1,567,569,743,-1,742,749,1057,-1,443,694,565,-1,447,446,451,-1,1058,560,564,-1,562,471,499,-1,499,1059,1060,-1,1030,1031,501,-1,1035,456,558,-1,555,550,553,-1,551,1061,552,-1,547,783,536,-1,719,723,720,-1,543,539,544,-1,542,737,507,-1,539,504,540,-1,537,718,538,-1,531,533,534,-1,1062,1063,721,-1,531,365,532,-1,530,691,338,-1,800,529,326,-1,352,529,800,-1,336,1014,526,-1,524,1064,522,-1,518,520,733,-1,517,1065,515,-1,513,510,512,-1,474,473,483,-1,725,202,506,-1,1066,200,199,-1,499,500,1059,-1,498,740,461,-1,469,491,572,-1,470,752,487,-1,1067,1068,1069,-1,488,500,489,-1,486,1070,484,-1,481,1071,479,-1,683,676,671,-1,476,1052,477,-1,474,598,475,-1,472,1072,163,-1,1057,703,751,-1,466,468,753,-1,485,744,486,-1,464,687,340,-1,463,646,364,-1,1022,441,760,-1,461,740,447,-1,459,461,763,-1,459,1021,642,-1,442,698,453,-1,454,1073,452,-1,446,448,1036,-1,445,694,443,-1,764,1021,459,-1,439,1020,437,-1,525,522,1074,-1,426,435,1075,-1,566,1076,443,-1,434,422,1077,-1,433,1078,431,-1,755,767,647,-1,428,430,660,-1,1046,430,1079,-1,425,416,423,-1,631,425,407,-1,422,427,420,-1,417,634,415,-1,1051,405,778,-1,411,1018,409,-1,406,408,1018,-1,652,411,1019,-1,396,664,394,-1,391,393,772,-1,390,1037,371,-1,388,1080,389,-1,382,384,781,-1,69,49,359,-1,372,380,371,-1,547,377,379,-1,375,359,361,-1,550,383,553,-1,374,552,372,-1,369,371,1037,-1,362,364,360,-1,49,1081,359,-1,719,356,358,-1,356,531,357,-1,354,1082,349,-1,790,666,465,-1,729,590,341,-1,345,347,1083,-1,344,1013,342,-1,341,590,339,-1,438,465,666,-1,338,1015,336,-1,332,330,329,-1,725,796,799,-1,326,10,726,-1,803,802,1066,-1,325,1010,323,-1,322,812,321,-1,319,116,320,-1,319,302,305,-1,937,315,936,-1,820,817,96,-1,315,1084,940,-1,315,937,313,-1,312,826,310,-1,102,831,1007,-1,307,309,308,-1,304,1005,305,-1,80,834,85,-1,80,837,300,-1,167,833,298,-1,297,187,295,-1,294,295,292,-1,1085,189,1086,-1,283,842,287,-1,1087,1088,846,-1,845,850,1002,-1,165,284,980,-1,283,288,281,-1,31,996,1089,-1,279,280,1090,-1,277,43,42,-1,996,1091,1092,-1,156,856,1093,-1,118,117,276,-1,82,1094,274,-1,267,866,272,-1,269,864,268,-1,58,268,863,-1,266,858,103,-1,265,1095,263,-1,185,262,265,-1,260,1096,258,-1,1097,869,868,-1,132,918,257,-1,138,137,136,-1,256,250,254,-1,192,160,252,-1,1098,1099,192,-1,180,245,247,-1,160,192,179,-1,238,1100,239,-1,883,61,237,-1,1100,1101,880,-1,66,225,889,-1,945,73,65,-1,229,233,1102,-1,229,231,905,-1,224,226,227,-1,222,44,1103,-1,989,1104,1105,-1,221,971,219,-1,53,214,54,-1,216,55,896,-1,214,25,54,-1,1106,1107,1108,-1,1109,1110,125,-1,211,213,1109,-1,197,1111,210,-1,209,901,207,-1,206,856,204,-1,206,207,856,-1,174,173,203,-1,508,230,368,-1,201,505,202,-1,904,907,368,-1,218,196,198,-1,1099,191,192,-1,149,152,190,-1,264,182,162,-1,181,920,161,-1,910,1112,245,-1,179,191,180,-1,178,1113,176,-1,898,170,172,-1,290,1001,291,-1,167,285,168,-1,165,174,166,-1,163,1114,2,-1,981,247,1097,-1,157,159,807,-1,176,913,177,-1,155,857,156,-1,154,921,51,-1,927,130,978,-1,151,136,152,-1,148,150,912,-1,809,930,912,-1,142,129,925,-1,142,1115,143,-1,871,135,137,-1,132,134,931,-1,912,930,932,-1,128,276,126,-1,1074,1106,525,-1,1116,121,122,-1,132,870,918,-1,108,122,119,-1,115,832,112,-1,110,122,108,-1,97,936,315,-1,108,1117,109,-1,105,317,103,-1,942,92,1084,-1,95,939,98,-1,95,97,940,-1,975,939,824,-1,85,1004,83,-1,837,80,82,-1,56,863,79,-1,77,1118,78,-1,70,72,76,-1,62,47,49,-1,56,67,60,-1,881,64,66,-1,1119,47,63,-1,238,72,1100,-1,61,883,59,-1,863,56,58,-1,53,55,948,-1,368,907,69,-1,971,987,219,-1,50,153,51,-1,1119,50,47,-1,41,1120,42,-1,26,215,39,-1,1121,896,1122,-1,950,1120,995,-1,31,953,32,-1,27,277,28,-1,37,36,127,-1,26,219,24,-1,18,966,19,-1,17,1123,15,-1,17,16,960,-1,10,327,11,-1,5,1124,3,-1,2,255,0,-1,965,15,7,-1,965,16,15,-1,21,17,960,-1,21,1125,17,-1,963,959,1126,-1,963,964,959,-1,1127,4,1128,-1,5,4,1127,-1,1129,1127,1130,-1,1131,1127,1129,-1,959,18,1123,-1,958,18,959,-1,1132,956,1129,-1,956,1132,955,-1,155,34,33,-1,280,34,155,-1,1133,859,1134,-1,1133,1135,859,-1,1136,25,24,-1,1136,972,25,-1,952,29,28,-1,952,40,29,-1,235,221,970,-1,968,221,235,-1,971,221,968,-1,1137,1136,1138,-1,1136,1137,1122,-1,1105,1139,886,-1,1139,1105,1104,-1,885,890,1140,-1,885,990,890,-1,237,1141,992,-1,1141,237,236,-1,1142,876,1143,-1,1142,877,876,-1,74,945,70,-1,74,73,945,-1,1143,867,1142,-1,1143,994,867,-1,313,827,312,-1,313,858,827,-1,310,1144,1145,-1,310,826,1144,-1,982,1146,260,-1,982,1147,1146,-1,975,102,101,-1,975,831,102,-1,1148,941,1149,-1,1148,974,941,-1,935,104,936,-1,976,104,935,-1,1148,816,974,-1,816,1148,1116,-1,1150,132,1151,-1,1150,870,132,-1,977,126,276,-1,126,977,1152,-1,1153,143,1154,-1,1153,139,143,-1,208,930,209,-1,208,929,930,-1,130,144,148,-1,129,144,130,-1,107,1155,1156,-1,107,926,1155,-1,979,321,923,-1,321,979,922,-1,922,1111,197,-1,1111,922,979,-1,1157,118,128,-1,118,1157,902,-1,1158,1159,1160,-1,1158,1161,1159,-1,993,919,1162,-1,993,257,919,-1,176,1163,157,-1,1163,176,1113,-1,983,916,1164,-1,916,983,203,-1,1165,1166,1167,-1,1166,1165,1168,-1,281,983,282,-1,281,166,983,-1,1086,168,1088,-1,1086,169,168,-1,1169,852,1170,-1,1165,852,1169,-1,875,1171,1172,-1,875,242,1171,-1,1099,909,874,-1,1098,909,1099,-1,1098,249,909,-1,928,979,924,-1,979,928,1111,-1,908,63,906,-1,908,1173,63,-1,6,231,199,-1,6,8,231,-1,907,62,69,-1,62,907,906,-1,211,746,900,-1,1174,746,211,-1,170,213,173,-1,213,170,985,-1,985,1107,1110,-1,985,899,1107,-1,125,1175,1109,-1,125,124,1175,-1,523,1106,1108,-1,523,525,1106,-1,1176,204,986,-1,1176,205,204,-1,1177,948,1178,-1,949,948,1177,-1,40,35,29,-1,39,35,40,-1,988,1122,1137,-1,988,1121,1122,-1,44,891,987,-1,223,891,44,-1,1140,888,946,-1,890,888,1140,-1,1105,1179,989,-1,1179,1105,1180,-1,1100,992,1141,-1,880,992,1100,-1,991,60,68,-1,991,61,60,-1,64,1101,71,-1,64,880,1101,-1,1171,1181,1182,-1,146,1181,1171,-1,1183,1184,1185,-1,1183,251,1184,-1,1186,183,182,-1,1159,183,1186,-1,1187,1188,1185,-1,1188,1187,1189,-1,818,139,1153,-1,140,139,818,-1,135,993,872,-1,993,135,871,-1,1190,1186,1191,-1,1190,1192,1186,-1,79,266,994,-1,79,864,266,-1,967,861,220,-1,861,967,951,-1,1092,853,996,-1,1092,1193,853,-1,1134,1092,1133,-1,1134,1193,1092,-1,279,853,278,-1,1090,853,279,-1,1090,854,853,-1,1001,849,1170,-1,1001,850,849,-1,1194,847,1195,-1,1194,999,847,-1,849,1196,1197,-1,997,1196,849,-1,1198,1169,1197,-1,1199,1169,1198,-1,1200,1201,1202,-1,1203,1201,1200,-1,745,1204,915,-1,745,1205,1204,-1,980,320,118,-1,980,998,320,-1,286,999,1000,-1,843,999,286,-1,1002,846,845,-1,1002,1087,846,-1,1206,293,1207,-1,1206,840,293,-1,169,189,188,-1,169,1086,189,-1,838,841,1208,-1,841,838,294,-1,297,263,1095,-1,296,263,297,-1,1096,115,1005,-1,1096,934,115,-1,301,113,834,-1,301,111,113,-1,91,829,828,-1,91,90,829,-1,81,1094,82,-1,81,1144,1094,-1,823,92,94,-1,92,823,822,-1,1009,941,821,-1,941,1009,1209,-1,820,95,99,-1,820,96,95,-1,1148,121,1116,-1,1148,1151,121,-1,818,815,814,-1,815,818,1153,-1,318,814,319,-1,318,120,814,-1,74,811,923,-1,74,810,811,-1,809,171,175,-1,809,150,171,-1,48,1210,49,-1,48,1177,1210,-1,797,505,1211,-1,797,506,505,-1,506,796,725,-1,506,328,796,-1,806,1212,1213,-1,1010,1212,806,-1,1214,793,1011,-1,1214,805,793,-1,1215,1216,1217,-1,1215,324,1216,-1,1012,1214,791,-1,1012,1217,1214,-1,1218,738,791,-1,804,738,1218,-1,1012,1219,1220,-1,792,1219,1012,-1,1082,350,349,-1,580,350,1082,-1,667,1054,586,-1,667,789,1054,-1,583,1048,346,-1,583,655,1048,-1,1015,728,1014,-1,1221,728,1015,-1,530,723,713,-1,530,724,723,-1,724,530,366,-1,337,1222,532,-1,1223,1222,337,-1,1224,715,1225,-1,1224,1226,715,-1,548,551,1034,-1,1061,551,548,-1,706,1227,1228,-1,706,705,1227,-1,546,386,781,-1,546,387,386,-1,1229,1228,1227,-1,1229,1230,1228,-1,655,633,630,-1,655,688,633,-1,1231,628,1232,-1,1231,629,628,-1,1233,1029,569,-1,1233,1234,1029,-1,412,1019,413,-1,412,658,1019,-1,774,1235,1236,-1,774,775,1235,-1,624,1233,768,-1,1233,624,626,-1,1237,423,415,-1,1238,423,1237,-1,443,1239,1240,-1,443,1076,1239,-1,439,766,1020,-1,1241,766,439,-1,1073,431,1078,-1,1073,450,431,-1,1021,735,641,-1,1021,1242,735,-1,698,441,763,-1,441,698,442,-1,1243,418,1244,-1,1243,759,418,-1,638,757,758,-1,756,757,638,-1,1065,756,515,-1,757,756,1065,-1,755,1245,437,-1,754,1245,755,-1,1246,1158,1160,-1,1246,699,1158,-1,1247,695,1248,-1,1247,565,695,-1,1249,486,753,-1,1070,486,1249,-1,1027,736,1250,-1,509,736,1027,-1,1166,1251,1252,-1,1168,1251,1166,-1,736,593,592,-1,736,473,593,-1,1052,607,600,-1,1052,476,607,-1,682,1253,1254,-1,1253,682,1251,-1,1255,704,1256,-1,1255,1035,704,-1,701,1059,702,-1,701,1060,1059,-1,701,556,1060,-1,516,1024,1257,-1,516,515,1024,-1,619,1258,1238,-1,619,618,1258,-1,805,324,323,-1,805,1216,324,-1,746,733,732,-1,733,746,1174,-1,519,1071,483,-1,1259,1071,519,-1,1064,1259,521,-1,1064,1260,1259,-1,513,1261,730,-1,513,514,1261,-1,527,1257,785,-1,527,526,1257,-1,1262,1210,1263,-1,1262,1264,1210,-1,798,334,801,-1,334,798,799,-1,1265,545,544,-1,1265,1266,545,-1,721,1267,722,-1,1063,1267,721,-1,717,1226,782,-1,1226,717,716,-1,357,1032,718,-1,357,534,1032,-1,1034,710,379,-1,1034,551,710,-1,708,711,555,-1,705,711,708,-1,485,563,456,-1,485,484,563,-1,1068,1248,1256,-1,1068,1247,1248,-1,1268,1269,1270,-1,1268,559,1269,-1,490,1271,491,-1,1271,490,1246,-1,1188,1272,1270,-1,1189,1272,1188,-1,450,648,431,-1,648,450,449,-1,695,448,697,-1,1036,448,695,-1,1271,1190,1273,-1,1271,1192,1190,-1,575,390,1230,-1,575,692,390,-1,713,690,530,-1,713,712,690,-1,1274,1040,1055,-1,1274,1275,1040,-1,1274,1276,1277,-1,1274,1055,1276,-1,686,1039,1278,-1,686,589,1039,-1,686,685,589,-1,681,676,1254,-1,681,677,676,-1,1053,1279,1280,-1,1281,1279,1053,-1,682,1252,1251,-1,1252,682,606,-1,1282,1279,1283,-1,1284,1279,1282,-1,594,1285,1286,-1,594,1287,1285,-1,1288,1289,1286,-1,1290,1289,1288,-1,591,595,1289,-1,680,595,591,-1,599,675,679,-1,599,601,675,-1,1291,1166,1252,-1,1292,1166,1291,-1,670,1293,1294,-1,1293,670,669,-1,1045,1295,668,-1,1045,1273,1295,-1,428,568,662,-1,428,768,568,-1,1046,618,663,-1,1046,1079,618,-1,1047,400,657,-1,1047,401,400,-1,587,392,391,-1,587,1231,392,-1,405,653,403,-1,773,653,405,-1,774,1049,651,-1,1296,1049,774,-1,1018,649,409,-1,1018,408,649,-1,435,1235,1075,-1,435,1240,1235,-1,432,648,1050,-1,431,648,432,-1,1050,637,636,-1,1050,1077,637,-1,1081,1016,362,-1,1264,1016,1081,-1,1242,764,1022,-1,1021,764,1242,-1,467,498,480,-1,467,741,498,-1,741,466,761,-1,467,466,741,-1,617,765,621,-1,617,1042,765,-1,422,1079,769,-1,422,421,1079,-1,1079,1258,618,-1,1079,421,1258,-1,452,1078,1297,-1,452,1073,1078,-1,1051,632,631,-1,1051,778,632,-1,395,1231,1232,-1,1231,395,392,-1,662,567,623,-1,662,568,567,-1,620,1298,615,-1,1298,620,623,-1,609,613,668,-1,614,613,609,-1,497,611,495,-1,614,611,497,-1,1294,1291,670,-1,1291,1294,1292,-1,1043,1025,1042,-1,1043,597,1025,-1,1028,1286,1285,-1,1288,1286,1028,-1,1287,1205,1285,-1,1287,1200,1205,-1,1283,1198,1282,-1,1283,1299,1198,-1,1299,1254,1253,-1,1254,1299,681,-1,1287,1053,1280,-1,1053,1287,594,-1,339,685,790,-1,685,339,589,-1,1275,1277,1083,-1,1275,1274,1277,-1,354,686,1278,-1,355,686,354,-1,355,1055,686,-1,754,511,1245,-1,754,747,511,-1,419,1230,1229,-1,419,575,1230,-1,1271,1045,491,-1,1045,1271,1273,-1,567,1056,571,-1,567,743,1056,-1,566,742,1076,-1,566,749,742,-1,1189,700,1272,-1,1300,700,1189,-1,0,1058,564,-1,1301,1058,0,-1,559,1058,1269,-1,559,560,1058,-1,499,1302,561,-1,499,1060,1302,-1,1303,1256,1248,-1,1256,1303,1255,-1,706,1304,707,-1,380,1304,706,-1,385,377,535,-1,385,387,377,-1,537,357,718,-1,537,358,357,-1,545,542,543,-1,545,792,542,-1,782,1224,375,-1,1226,1224,782,-1,691,344,787,-1,344,691,581,-1,1263,529,1262,-1,529,1263,895,-1,1261,1257,526,-1,1261,516,1257,-1,521,522,1064,-1,522,521,436,-1,1260,524,1305,-1,524,1260,1064,-1,1249,468,1305,-1,1249,753,468,-1,520,1250,731,-1,520,1027,1250,-1,514,516,1261,-1,514,517,516,-1,507,199,508,-1,507,737,199,-1,1211,802,797,-1,1211,1306,802,-1,430,769,1079,-1,429,769,430,-1,786,1257,1024,-1,1257,786,785,-1,701,557,556,-1,701,1031,557,-1,1030,1069,704,-1,1030,503,1069,-1,494,1056,751,-1,493,1056,494,-1,491,573,572,-1,573,491,1045,-1,1069,1256,704,-1,1068,1256,1069,-1,1072,484,1070,-1,472,484,1072,-1,672,601,608,-1,672,675,601,-1,683,1254,676,-1,683,682,1254,-1,673,1043,616,-1,1043,673,603,-1,1288,732,731,-1,732,1288,1028,-1,697,1248,695,-1,1303,1248,697,-1,470,494,752,-1,492,494,470,-1,1023,1242,1022,-1,1023,1307,1242,-1,440,388,760,-1,440,1080,388,-1,1307,735,1242,-1,1307,734,735,-1,750,457,1308,-1,457,750,458,-1,455,452,635,-1,452,455,453,-1,446,694,445,-1,446,1036,694,-1,1237,439,665,-1,1237,1241,439,-1,1029,1076,742,-1,1076,1029,1239,-1,434,1050,648,-1,434,1077,1050,-1,1238,665,619,-1,1238,1237,665,-1,427,1075,1309,-1,426,1075,427,-1,420,425,424,-1,425,420,776,-1,1051,773,405,-1,773,1051,406,-1,401,653,652,-1,401,1047,653,-1,1234,626,1296,-1,1233,626,1234,-1,1231,1048,629,-1,1231,587,1048,-1,656,397,780,-1,398,397,656,-1,402,652,1019,-1,401,652,402,-1,396,399,664,-1,396,397,399,-1,1230,381,1228,-1,1230,390,381,-1,389,1243,1310,-1,1080,1243,389,-1,1033,386,385,-1,1033,639,386,-1,705,1311,1227,-1,1311,705,708,-1,1225,540,1224,-1,1225,541,540,-1,1063,1222,1267,-1,1063,1312,1222,-1,365,356,366,-1,365,531,356,-1,786,362,1016,-1,363,362,786,-1,361,364,645,-1,360,364,361,-1,723,358,713,-1,723,719,358,-1,351,727,352,-1,727,351,1223,-1,347,586,1054,-1,788,586,347,-1,1276,348,689,-1,348,1276,349,-1,729,342,590,-1,729,343,342,-1,1221,338,787,-1,1221,1015,338,-1,1313,1219,333,-1,1219,1313,1220,-1,791,1011,1218,-1,791,1214,1011,-1,1212,1313,1314,-1,1313,1212,1315,-1,1217,805,1214,-1,1217,1216,805,-1,150,172,171,-1,150,190,172,-1,977,1154,1316,-1,1154,977,933,-1,105,1152,938,-1,105,1317,1152,-1,314,1084,315,-1,314,942,1084,-1,1144,84,1145,-1,81,84,1144,-1,834,91,828,-1,834,113,91,-1,833,1095,1318,-1,833,297,1095,-1,1319,1191,1208,-1,1319,1190,1191,-1,1208,1293,1319,-1,1293,1208,841,-1,1207,292,289,-1,1207,293,292,-1,1167,1207,851,-1,1207,1167,1206,-1,286,1088,168,-1,846,1088,286,-1,980,848,998,-1,980,284,848,-1,1320,915,1204,-1,915,1320,1321,-1,1205,1202,1204,-1,1205,1200,1202,-1,1198,1196,1282,-1,1198,1197,1196,-1,1170,1197,1169,-1,849,1197,1170,-1,1194,1202,1201,-1,1195,1202,1194,-1,854,280,38,-1,1090,280,854,-1,1133,1091,30,-1,1133,1092,1091,-1,853,43,278,-1,853,41,43,-1,853,1193,41,-1,207,902,1157,-1,207,901,902,-1,1318,265,262,-1,265,1318,1095,-1,186,265,264,-1,186,185,265,-1,1146,1096,260,-1,1096,1146,934,-1,1322,1189,1187,-1,1189,1322,1300,-1,254,0,255,-1,0,254,1301,-1,1185,1323,1187,-1,1185,1184,1323,-1,251,249,1184,-1,251,241,249,-1,920,180,247,-1,180,920,181,-1,1172,1182,1162,-1,1171,1182,1172,-1,991,876,884,-1,876,991,68,-1,65,226,66,-1,65,75,226,-1,65,73,75,-1,989,1102,233,-1,1102,989,1179,-1,1102,230,229,-1,1102,904,230,-1,886,223,222,-1,886,1139,223,-1,1139,891,223,-1,1139,1138,891,-1,1121,233,893,-1,233,1121,988,-1,217,1263,1178,-1,895,1263,217,-1,218,1176,214,-1,218,198,1176,-1,1106,1110,1107,-1,125,1110,1106,-1,1108,899,1324,-1,1107,899,1108,-1,158,1163,1324,-1,158,157,1163,-1,1132,22,894,-1,23,22,1132,-1,955,894,232,-1,1132,894,955,-1,874,191,1099,-1,874,194,191,-1,261,184,981,-1,184,261,185,-1,146,242,147,-1,1171,242,146,-1,180,910,245,-1,191,910,180,-1,175,170,173,-1,170,175,171,-1,1088,1085,1086,-1,1085,1088,1087,-1,282,1164,1325,-1,282,983,1164,-1,843,285,844,-1,843,286,285,-1,1113,1326,1163,-1,1326,1113,1114,-1,184,161,920,-1,161,184,186,-1,156,127,36,-1,156,1093,127,-1,922,154,321,-1,154,922,921,-1,1316,316,938,-1,1316,1115,316,-1,139,141,143,-1,138,141,139,-1,126,1317,836,-1,126,1152,1317,-1,870,982,868,-1,1150,982,870,-1,814,119,818,-1,814,120,119,-1,836,1327,300,-1,836,1317,1327,-1,1149,1209,1147,-1,941,1209,1149,-1,822,1084,92,-1,940,1084,822,-1,823,90,824,-1,823,829,90,-1,306,1147,1209,-1,1147,306,1146,-1,1008,1144,826,-1,1008,1094,1144,-1,88,830,943,-1,830,88,87,-1,824,89,975,-1,89,824,90,-1,86,83,1004,-1,86,88,83,-1,67,994,1143,-1,67,79,994,-1,1155,77,1328,-1,77,1155,1118,-1,74,887,75,-1,74,812,887,-1,1329,877,1142,-1,879,877,1329,-1,908,1180,1173,-1,908,1179,1180,-1,1138,1104,1137,-1,1138,1139,1104,-1,45,987,971,-1,45,44,987,-1,52,947,949,-1,947,52,51,-1,153,1119,813,-1,1119,153,50,-1,969,235,970,-1,969,46,235,-1,972,1122,896,-1,1136,1122,972,-1,275,31,1089,-1,31,275,274,-1,995,1134,859,-1,1120,1134,995,-1,27,35,34,-1,27,29,35,-1,15,18,20,-1,1123,18,15,-1,1330,1129,956,-1,1330,1131,1129,-1,1131,5,1127,-1,1124,5,1131,-1,1126,1123,17,-1,1126,959,1123,-1,1125,1126,17,-1,1126,1125,1128,-1,6,1306,7,-1,1306,6,200,-1,962,1330,1331,-1,962,1332,1330,-1,1130,1128,1125,-1,1127,1128,1130,-1,958,966,18,-1,958,1331,966,-1,1132,1130,23,-1,1129,1130,1132,-1,1121,216,896,-1,893,216,1121,-1,892,216,893,-1,951,277,42,-1,277,951,967,-1,30,1135,1133,-1,30,32,1135,-1,279,277,27,-1,278,277,279,-1,897,215,986,-1,215,897,39,-1,47,52,48,-1,47,50,52,-1,886,1180,1105,-1,886,885,1180,-1,63,813,1119,-1,813,63,946,-1,236,878,1141,-1,878,236,884,-1,68,1143,876,-1,67,1143,68,-1,1328,238,240,-1,238,1328,77,-1,889,881,66,-1,889,882,881,-1,1156,1142,867,-1,1329,1142,1156,-1,953,1094,1008,-1,1094,953,274,-1,1145,1333,310,-1,1333,1145,944,-1,825,973,1333,-1,825,93,973,-1,101,307,1009,-1,101,100,307,-1,1149,1151,1148,-1,1151,1149,1150,-1,935,1117,1334,-1,1117,935,109,-1,1116,110,816,-1,110,1116,122,-1,318,114,1335,-1,318,305,114,-1,935,1327,976,-1,935,1334,1327,-1,1074,125,1106,-1,1074,123,125,-1,128,1093,1157,-1,128,127,1093,-1,931,1151,132,-1,1151,931,121,-1,1115,925,316,-1,142,925,1115,-1,146,914,1181,-1,145,914,146,-1,78,131,927,-1,78,1118,131,-1,929,924,978,-1,929,928,924,-1,1326,163,1336,-1,1114,163,1326,-1,1162,872,993,-1,872,1162,1182,-1,900,1321,984,-1,915,1321,900,-1,848,844,299,-1,287,844,848,-1,1170,291,1001,-1,1170,852,291,-1,1087,1003,1085,-1,1087,1002,1003,-1,178,1114,1113,-1,1114,178,2,-1,1172,910,875,-1,910,1172,1112,-1,179,161,160,-1,179,181,161,-1,188,297,833,-1,187,297,188,-1,248,909,249,-1,248,243,909,-1,218,947,196,-1,53,947,218,-1,1335,112,111,-1,112,1335,114,-1,7,1211,965,-1,7,1306,1211,-1,8,19,231,-1,19,8,20,-1,199,230,508,-1,199,231,230,-1,198,205,1176,-1,198,210,205,-1,1164,212,984,-1,1164,916,212,-1,985,1109,213,-1,1109,985,1110,-1,1174,1109,1175,-1,1174,211,1109,-1,1336,1108,1326,-1,523,1108,1336,-1,217,948,55,-1,1178,948,217,-1,28,220,952,-1,967,220,28,-1,1173,946,63,-1,946,1173,1140,-1,905,232,229,-1,905,955,232,-1,1103,224,228,-1,1103,969,224,-1,1141,239,1100,-1,878,239,1141,-1,1101,72,71,-1,1101,1100,72,-1,2,256,255,-1,256,2,178,-1,246,1112,919,-1,1112,246,245,-1,1323,192,253,-1,1323,1098,192,-1,254,251,1183,-1,254,250,251,-1,252,1322,253,-1,1322,252,1161,-1,1185,1337,1183,-1,1337,1185,1188,-1,1192,1159,1186,-1,1160,1159,1192,-1,261,258,262,-1,261,259,258,-1,839,1186,182,-1,1191,1186,839,-1,858,864,269,-1,858,266,864,-1,32,271,1135,-1,270,271,32,-1,127,836,37,-1,127,126,836,-1,1120,1193,1134,-1,1120,41,1193,-1,954,854,38,-1,855,854,954,-1,1194,1000,999,-1,1338,1000,1194,-1,1196,1338,1339,-1,1338,1196,997,-1,1165,1199,1168,-1,1169,1199,1165,-1,1201,1284,1339,-1,1284,1201,1203,-1,1340,1195,847,-1,1320,1195,1340,-1,283,1325,1340,-1,1325,283,282,-1,1206,1294,840,-1,1292,1294,1206,-1,292,187,189,-1,187,292,295,-1,296,294,838,-1,294,296,295,-1,1318,303,833,-1,304,303,1318,-1,258,1005,304,-1,258,1096,1005,-1,1006,91,113,-1,1006,1007,91,-1,973,310,1333,-1,973,311,310,-1,1150,1147,982,-1,1149,1147,1150,-1,1154,1115,1316,-1,1154,143,1115,-1,1334,111,301,-1,1334,1117,111,-1,111,108,1335,-1,111,1117,108,-1,320,298,302,-1,320,998,298,-1,1306,1066,802,-1,200,1066,1306,-1,1213,1314,330,-1,1212,1314,1213,-1,332,1213,330,-1,332,795,1213,-1,325,1215,1315,-1,1215,325,324,-1,1220,1217,1012,-1,1220,1215,1217,-1,1218,331,804,-1,331,1218,332,-1,800,353,352,-1,800,1265,353,-1,1265,800,801,-1,1013,580,1082,-1,581,580,1013,-1,1341,1083,1277,-1,1341,345,1083,-1,1013,1039,342,-1,1039,1013,1278,-1,1014,1026,730,-1,728,1026,1014,-1,362,359,1081,-1,362,360,359,-1,1225,714,1062,-1,1225,715,714,-1,645,375,361,-1,782,375,645,-1,711,1061,548,-1,707,1061,711,-1,1228,380,706,-1,380,1228,381,-1,553,1310,554,-1,389,1310,553,-1,379,783,547,-1,379,710,783,-1,388,781,644,-1,388,382,781,-1,1227,1244,1229,-1,1244,1227,1311,-1,587,346,1048,-1,788,346,587,-1,1342,1232,628,-1,779,1232,1342,-1,1017,654,1342,-1,1017,404,654,-1,625,413,1049,-1,625,414,413,-1,1240,1236,1235,-1,1239,1236,1240,-1,421,424,1258,-1,420,424,421,-1,1296,1236,1234,-1,1236,1296,774,-1,1238,424,423,-1,1238,1258,424,-1,436,1074,522,-1,436,123,1074,-1,588,437,1245,-1,588,438,437,-1,1240,444,443,-1,435,444,1240,-1,454,450,1073,-1,450,454,451,-1,635,1297,771,-1,635,452,1297,-1,646,756,638,-1,463,756,646,-1,438,464,465,-1,438,588,464,-1,163,1343,1336,-1,1343,163,1072,-1,748,565,1247,-1,748,566,565,-1,1343,1070,1249,-1,1072,1070,1343,-1,477,674,673,-1,477,678,674,-1,1250,592,1290,-1,1250,736,592,-1,608,600,607,-1,601,600,608,-1,1071,482,483,-1,481,482,1071,-1,1069,488,1067,-1,488,1069,500,-1,1035,457,456,-1,457,1035,1255,-1,470,489,471,-1,470,487,489,-1,612,496,615,-1,496,612,497,-1,500,702,1059,-1,500,502,702,-1,1266,792,545,-1,792,1266,1219,-1,334,1219,1266,-1,1219,334,333,-1,738,803,737,-1,738,804,803,-1,1071,1260,479,-1,1260,1071,1259,-1,518,1259,519,-1,521,1259,518,-1,518,1174,1175,-1,518,733,1174,-1,524,1336,1343,-1,1336,524,523,-1,784,529,528,-1,529,784,1262,-1,1266,801,334,-1,1266,1265,801,-1,544,353,1265,-1,722,353,544,-1,532,1312,533,-1,532,1222,1312,-1,533,714,534,-1,533,1312,714,-1,507,539,543,-1,507,504,539,-1,539,721,544,-1,541,721,539,-1,1304,1061,707,-1,1061,1304,552,-1,383,549,384,-1,383,550,549,-1,563,472,564,-1,484,472,563,-1,1068,748,1247,-1,1067,748,1068,-1,556,559,1268,-1,556,558,559,-1,1302,1270,1272,-1,1302,1268,1270,-1,1337,1270,1269,-1,1188,1270,1337,-1,1246,1192,1271,-1,1192,1246,1160,-1,568,1233,569,-1,768,1233,568,-1,570,492,572,-1,570,493,492,-1,570,1298,571,-1,574,1298,570,-1,692,688,585,-1,692,575,688,-1,1038,345,1341,-1,345,1038,584,-1,665,438,666,-1,665,439,438,-1,1055,349,1276,-1,1055,355,349,-1,685,789,790,-1,789,685,684,-1,1044,1053,596,-1,1053,1044,1281,-1,1281,1283,1279,-1,1041,1283,1281,-1,1199,1251,1168,-1,1251,1199,1253,-1,1284,1280,1279,-1,1203,1280,1284,-1,594,1289,595,-1,1289,594,1286,-1,1290,591,1289,-1,592,591,1290,-1,600,678,1052,-1,678,600,599,-1,605,1252,606,-1,1291,1252,605,-1,611,605,604,-1,611,610,605,-1,1293,1295,1319,-1,669,1295,1293,-1,1273,1319,1295,-1,1273,1190,1319,-1,574,615,1298,-1,574,612,615,-1,400,661,1046,-1,400,659,661,-1,628,1017,1342,-1,628,777,1017,-1,1234,1239,1029,-1,1239,1234,1236,-1,776,1309,649,-1,776,427,1309,-1,1241,415,771,-1,1241,1237,415,-1,1078,766,1297,-1,433,766,1078,-1,758,639,638,-1,758,386,639,-1,1210,1081,49,-1,1210,1264,1081,-1,481,642,482,-1,481,460,642,-1,643,386,758,-1,643,644,386,-1,647,621,765,-1,621,647,636,-1,769,1077,422,-1,769,637,1077,-1,775,649,1309,-1,649,775,650,-1,411,413,1019,-1,411,410,413,-1,770,688,417,-1,770,633,688,-1,396,1232,779,-1,396,395,1232,-1,661,412,627,-1,661,659,412,-1,430,661,660,-1,1046,661,430,-1,623,571,1298,-1,623,567,571,-1,669,668,1295,-1,609,668,669,-1,495,476,496,-1,495,607,476,-1,610,1291,605,-1,610,670,1291,-1,606,671,604,-1,606,683,671,-1,596,678,1044,-1,678,596,674,-1,765,1025,755,-1,765,1042,1025,-1,1285,745,1028,-1,1285,1205,745,-1,1280,1200,1287,-1,1200,1280,1203,-1,1253,1198,1299,-1,1198,1253,1199,-1,1283,681,1299,-1,681,1283,1041,-1,679,1281,1044,-1,1281,679,1041,-1,1083,1040,1275,-1,1040,1083,347,-1,1082,1278,1013,-1,1082,354,1278,-1,437,767,755,-1,437,1020,767,-1,1341,578,1038,-1,1341,689,578,-1,585,576,692,-1,584,576,585,-1,1229,418,419,-1,1229,1244,418,-1,699,1300,1158,-1,699,700,1300,-1,1301,1269,1058,-1,1337,1269,1301,-1,1272,561,1302,-1,700,561,1272,-1,1060,1268,1302,-1,1060,556,1268,-1,1067,703,748,-1,703,1067,488,-1,1308,1255,1303,-1,1255,1308,457,-1,549,378,384,-1,549,709,378,-1,372,1304,380,-1,372,552,1304,-1,1034,549,548,-1,1034,709,549,-1,541,1062,721,-1,1225,1062,541,-1,538,385,535,-1,538,1033,385,-1,351,722,1267,-1,351,353,722,-1,729,1221,343,-1,1221,729,728,-1,784,1264,1262,-1,1264,784,1016,-1,730,526,1014,-1,730,1261,526,-1,1175,436,518,-1,436,1175,124,-1,1343,1305,524,-1,1343,1249,1305,-1,1305,479,1260,-1,1305,468,479,-1,520,483,1027,-1,519,483,520,-1,747,735,511,-1,747,641,735,-1,376,367,69,-1,739,367,376,-1,737,1066,199,-1,737,803,1066,-1,375,540,739,-1,375,1224,540,-1,757,1307,1023,-1,1065,1307,757,-1,557,1030,704,-1,1031,1030,557,-1,503,500,1069,-1,502,500,503,-1,604,495,611,-1,604,608,495,-1,608,604,672,-1,743,751,1056,-1,742,751,743,-1,742,1057,751,-1,675,671,676,-1,675,672,671,-1,597,603,602,-1,597,1043,603,-1,731,1290,1288,-1,731,1250,1290,-1,478,673,616,-1,478,477,673,-1,762,1303,697,-1,762,1308,1303,-1,1057,748,703,-1,748,1057,749,-1,562,1246,490,-1,562,699,1246,-1,1024,363,786,-1,463,363,1024,-1,1022,643,1023,-1,1022,760,643,-1,1080,759,1243,-1,1080,440,759,-1,734,1065,517,-1,1307,1065,734,-1,761,1308,762,-1,1308,761,750,-1,766,771,1297,-1,1241,771,766,-1,510,1245,511,-1,510,588,1245,-1,1309,1235,775,-1,1075,1235,1309,-1,409,651,410,-1,651,409,650,-1,403,1047,656,-1,1047,403,653,-1,1296,625,1049,-1,626,625,1296,-1,780,1342,654,-1,779,1342,780,-1,656,654,403,-1,780,654,656,-1,777,778,1017,-1,777,632,778,-1,664,657,663,-1,664,399,657,-1,789,1040,1054,-1,1040,789,684,-1,1310,1244,1311,-1,1243,1244,1310,-1,717,639,1033,-1,717,640,639,-1,1311,554,1310,-1,1311,708,554,-1,527,784,528,-1,784,527,785,-1,716,715,1226,-1,716,1032,715,-1,1312,1062,714,-1,1063,1062,1312,-1,1223,1267,1222,-1,351,1267,1223,-1,690,582,530,-1,348,582,690,-1,582,348,350,-1,343,787,344,-1,343,1221,787,-1,336,1223,337,-1,336,727,1223,-1,689,1277,1276,-1,689,1341,1277,-1,799,335,334,-1,799,796,335,-1,1314,333,335,-1,1314,1313,333,-1,1218,795,332,-1,795,1218,1011,-1,1315,1220,1313,-1,1220,1315,1215,-1,1010,1315,1212,-1,1315,1010,325,-1,795,806,1213,-1,795,794,806,-1,330,335,328,-1,330,1314,335,-1,331,797,802,-1,331,329,797,-1,190,159,172,-1,190,808,159,-1,932,929,978,-1,929,932,930,-1,949,48,52,-1,48,949,1177,-1,120,1335,108,-1,120,318,1335,-1,820,974,816,-1,819,974,820,-1,101,939,975,-1,101,98,939,-1,858,937,103,-1,858,313,937,-1,1145,83,944,-1,1145,84,83,-1,102,1006,309,-1,102,1007,1006,-1,1006,112,832,-1,112,1006,113,-1,262,304,1318,-1,262,258,304,-1,1208,839,838,-1,1208,1191,839,-1,1293,840,1294,-1,841,840,1293,-1,1166,1206,1167,-1,1206,1166,1292,-1,289,851,1207,-1,291,851,289,-1,847,283,1340,-1,283,847,842,-1,1340,1321,1320,-1,1321,1340,1325,-1,1204,1195,1320,-1,1204,1202,1195,-1,1339,1282,1196,-1,1282,1339,1284,-1,1167,852,1165,-1,851,852,1167,-1,1339,1194,1201,-1,1194,1339,1338,-1,1338,845,1000,-1,997,845,1338,-1,996,30,1091,-1,31,30,996,-1,272,1135,271,-1,272,859,1135,-1,860,970,221,-1,860,862,970,-1,107,867,106,-1,107,1156,867,-1,1300,1161,1158,-1,1300,1322,1161,-1,1183,1301,254,-1,1301,1183,1337,-1,253,1187,1323,-1,1187,253,1322,-1,1184,1098,1323,-1,1184,249,1098,-1,1162,1112,1172,-1,1162,919,1112,-1,256,177,147,-1,256,178,177,-1,878,879,239,-1,879,878,877,-1,882,992,881,-1,882,237,992,-1,990,1103,228,-1,990,222,1103,-1,1179,904,1102,-1,1179,908,904,-1,75,227,226,-1,75,887,227,-1,1137,989,988,-1,989,1137,1104,-1,232,893,233,-1,232,894,893,-1,22,961,892,-1,12,961,22,-1,1210,1178,1263,-1,1210,1177,1178,-1,214,986,215,-1,214,1176,986,-1,1324,1326,1108,-1,1324,1163,1326,-1,898,1324,899,-1,898,158,1324,-1,173,212,916,-1,212,173,213,-1,1124,962,3,-1,1124,1332,962,-1,1334,300,1327,-1,1334,301,300,-1,244,248,875,-1,248,244,243,-1,191,193,910,-1,193,191,194,-1,189,289,292,-1,1085,289,189,-1,1003,289,1085,-1,981,259,261,-1,981,868,259,-1,981,1097,868,-1,290,1002,1001,-1,290,1003,1002,-1,287,284,288,-1,287,848,284,-1,1325,984,1321,-1,1325,1164,984,-1,844,167,299,-1,844,285,167,-1,1182,873,872,-1,1182,1181,873,-1,246,1097,247,-1,869,1097,246,-1,1159,252,183,-1,1159,1161,252,-1,51,196,947,-1,196,51,921,-1,811,978,924,-1,811,927,978,-1,926,1118,1155,-1,926,131,1118,-1,1111,903,210,-1,903,1111,928,-1,1181,917,873,-1,914,917,1181,-1,938,977,1316,-1,977,938,1152,-1,1157,856,207,-1,1157,1093,856,-1,1154,815,1153,-1,815,1154,933,-1,976,1317,105,-1,1317,976,1327,-1,1146,308,934,-1,306,308,1146,-1,821,99,98,-1,819,99,821,-1,829,94,830,-1,823,94,829,-1,307,1209,1009,-1,1209,307,306,-1,1333,943,825,-1,943,1333,944,-1,825,830,94,-1,830,825,943,-1,942,311,973,-1,942,314,311,-1,828,1004,834,-1,828,86,1004,-1,996,954,1089,-1,855,954,996,-1,1156,1328,1329,-1,1328,1156,1155,-1,812,888,887,-1,812,322,888,-1,240,1329,1328,-1,240,879,1329,-1,885,1173,1180,-1,885,1140,1173,-1,1138,24,891,-1,24,1138,1136,-1,46,1103,44,-1,46,969,1103,-1,861,860,221,-1,861,995,860,-1,950,995,861,-1,1008,273,953,-1,1008,827,273,-1,1089,835,275,-1,1089,954,835,-1,950,42,1120,-1,42,950,951,-1,21,12,22,-1,21,13,12,-1,23,1125,21,-1,23,1130,1125,-1,1331,956,966,-1,1331,1330,956,-1,1332,1131,1330,-1,1332,1124,1131,-1,957,1331,958,-1,957,962,1331,-1,1128,963,1126,-1,963,1128,4,-1,13,201,14,-1,13,960,201,-1,505,965,1211,-1,505,201,965,-1],creaseAngle=1.571,normalIndex=[701,700,780,-1,255,451,279,-1,629,864,522,-1,1091,663,1028,-1,1047,1094,1055,-1,1169,1224,1174,-1,964,290,777,-1,1079,706,809,-1,258,1056,1135,-1,591,547,939,-1,123,139,0,-1,1183,831,1059,-1,1013,900,898,-1,1135,1276,1095,-1,355,363,378,-1,164,214,477,-1,977,930,633,-1,1019,1131,994,-1,1145,1164,1063,-1,71,339,225,-1,512,320,783,-1,977,750,708,-1,532,456,697,-1,1,228,320,-1,633,645,750,-1,1234,707,769,-1,537,1233,445,-1,1264,1184,1253,-1,1,71,25,-1,963,600,282,-1,271,433,807,-1,536,366,232,-1,213,153,511,-1,171,35,185,-1,227,481,449,-1,70,167,227,-1,601,190,436,-1,422,1020,888,-1,325,422,721,-1,759,1069,755,-1,1122,879,903,-1,879,725,832,-1,112,206,172,-1,221,235,759,-1,184,221,527,-1,693,694,472,-1,803,885,622,-1,1031,1206,1149,-1,132,134,55,-1,116,276,124,-1,215,108,43,-1,392,609,274,-1,609,870,1031,-1,1075,1058,1082,-1,975,617,627,-1,594,294,617,-1,1131,1124,1199,-1,1013,1098,1071,-1,863,634,457,-1,1022,1064,946,-1,780,700,680,-1,40,76,160,-1,18,44,30,-1,597,614,377,-1,541,288,570,-1,949,1029,828,-1,1163,886,941,-1,432,549,946,-1,317,212,518,-1,152,111,115,-1,375,627,617,-1,1121,1163,1036,-1,1177,1170,1076,-1,1238,1284,1297,-1,684,686,629,-1,1153,666,1055,-1,387,160,288,-1,1279,1319,1281,-1,1045,1317,848,-1,1329,1297,1284,-1,716,616,727,-1,1274,1300,1056,-1,857,1002,1063,-1,1145,1243,1274,-1,1028,1002,857,-1,563,483,504,-1,158,104,164,-1,332,463,336,-1,192,204,332,-1,120,316,298,-1,120,20,39,-1,509,738,477,-1,697,336,463,-1,783,961,878,-1,914,587,763,-1,987,1082,1158,-1,1076,984,1085,-1,910,498,499,-1,987,998,935,-1,855,987,908,-1,735,866,1036,-1,822,825,871,-1,208,134,132,-1,464,493,762,-1,212,198,219,-1,202,417,229,-1,325,81,422,-1,225,162,19,-1,6,19,29,-1,102,162,193,-1,6,29,10,-1,282,170,306,-1,172,454,622,-1,409,400,378,-1,428,831,781,-1,86,180,239,-1,76,40,34,-1,44,74,136,-1,154,95,239,-1,196,109,168,-1,197,360,299,-1,174,151,157,-1,66,53,18,-1,1237,1218,963,-1,128,66,248,-1,248,426,513,-1,1080,943,1050,-1,601,436,960,-1,277,260,188,-1,259,368,519,-1,592,721,590,-1,513,391,62,-1,62,101,128,-1,1305,1199,1060,-1,1089,1265,1062,-1,300,714,663,-1,182,125,165,-1,181,156,125,-1,533,643,265,-1,283,1074,787,-1,555,246,161,-1,753,408,793,-1,1343,1327,1205,-1,1038,1054,978,-1,1127,458,1194,-1,955,1054,956,-1,1106,1133,933,-1,376,302,250,-1,337,224,218,-1,787,1193,966,-1,645,756,682,-1,1119,1007,1277,-1,1005,829,528,-1,641,604,376,-1,887,810,530,-1,1116,1342,1277,-1,376,604,645,-1,83,571,639,-1,896,113,804,-1,89,155,83,-1,1320,1277,1342,-1,1067,745,381,-1,534,911,1073,-1,1114,973,805,-1,830,1187,1065,-1,1155,1306,1175,-1,1012,895,909,-1,1176,1270,1283,-1,907,1152,743,-1,469,297,927,-1,623,927,1006,-1,238,207,583,-1,131,14,373,-1,583,813,585,-1,494,588,465,-1,1301,1280,1115,-1,1123,813,583,-1,813,1123,1156,-1,872,694,693,-1,747,459,538,-1,195,138,314,-1,1213,1288,1304,-1,1219,1061,1217,-1,1296,1235,1132,-1,912,607,893,-1,607,510,314,-1,262,284,270,-1,272,626,703,-1,703,1061,733,-1,218,224,133,-1,273,246,330,-1,605,921,739,-1,397,278,323,-1,680,700,558,-1,1178,1052,1292,-1,1313,1272,1326,-1,821,967,771,-1,802,1052,808,-1,515,315,380,-1,382,460,179,-1,397,791,922,-1,824,1134,1025,-1,1228,1230,1188,-1,703,626,965,-1,308,179,223,-1,269,175,163,-1,682,756,1030,-1,666,677,189,-1,682,1023,683,-1,1178,974,808,-1,176,321,63,-1,65,63,23,-1,60,46,13,-1,649,596,730,-1,872,792,649,-1,877,688,746,-1,877,689,688,-1,64,194,283,-1,458,275,349,-1,787,966,840,-1,1200,1216,1239,-1,1185,1133,1200,-1,1008,882,1011,-1,1011,1150,1008,-1,1192,988,1105,-1,1204,1023,1247,-1,1302,1322,1247,-1,887,804,842,-1,882,1008,650,-1,491,883,801,-1,466,557,528,-1,412,580,765,-1,179,308,323,-1,413,342,352,-1,435,352,471,-1,308,476,610,-1,471,461,525,-1,1213,1118,991,-1,881,546,581,-1,1134,1093,1128,-1,953,1157,1162,-1,927,1267,1006,-1,1323,1181,1119,-1,1130,1099,1181,-1,884,906,890,-1,1338,1318,1336,-1,1048,1215,1067,-1,313,176,273,-1,901,555,502,-1,1108,1161,1258,-1,797,925,1053,-1,1307,1292,1261,-1,1227,1299,1271,-1,1108,1248,1201,-1,1148,986,999,-1,1298,1228,1259,-1,1046,982,1147,-1,1186,1189,1171,-1,1186,1157,1189,-1,1198,1291,1255,-1,381,127,106,-1,1100,1255,1220,-1,852,920,1100,-1,295,401,264,-1,383,907,743,-1,1066,1033,1154,-1,823,972,1086,-1,785,623,749,-1,1278,962,852,-1,37,178,280,-1,771,965,626,-1,390,1052,520,-1,8,89,12,-1,249,218,144,-1,1278,1225,1280,-1,1156,1123,1333,-1,1176,869,928,-1,1152,1270,926,-1,1283,1242,1137,-1,1339,1306,1155,-1,1315,1154,1033,-1,1090,782,973,-1,1065,867,448,-1,427,429,383,-1,598,852,588,-1,1198,1255,1100,-1,398,782,830,-1,644,398,534,-1,351,442,790,-1,1189,1157,1040,-1,876,827,982,-1,1198,1230,1313,-1,1148,1211,1240,-1,1201,1256,1167,-1,1251,1229,1203,-1,1209,1227,1151,-1,1167,925,1044,-1,1151,1203,997,-1,976,1179,999,-1,902,815,916,-1,126,176,65,-1,1315,1336,1289,-1,1214,1038,1003,-1,840,890,858,-1,1003,1099,1130,-1,1181,1323,1318,-1,1320,1337,1323,-1,1181,1099,918,-1,1232,1144,1118,-1,1217,1208,1117,-1,893,489,733,-1,741,610,615,-1,471,352,262,-1,500,310,269,-1,382,860,460,-1,175,269,310,-1,342,242,352,-1,936,1092,569,-1,826,765,580,-1,530,810,758,-1,574,466,528,-1,801,765,573,-1,1026,844,1011,-1,1185,1190,1087,-1,1057,969,1150,-1,918,1026,882,-1,1057,1150,1141,-1,729,834,1106,-1,1231,1282,1302,-1,608,752,834,-1,1193,1074,1216,-1,666,291,261,-1,714,300,349,-1,458,338,194,-1,68,281,161,-1,126,65,36,-1,717,579,647,-1,23,63,17,-1,24,17,63,-1,1178,1107,974,-1,1018,1204,1070,-1,1030,756,794,-1,1084,965,1088,-1,520,626,272,-1,959,847,581,-1,329,315,270,-1,739,921,967,-1,1258,1292,1307,-1,631,642,579,-1,1261,1052,980,-1,991,849,1037,-1,605,329,577,-1,1041,860,841,-1,323,791,397,-1,329,407,380,-1,329,605,407,-1,126,161,246,-1,1261,1143,1172,-1,60,69,133,-1,27,8,15,-1,389,749,623,-1,314,389,195,-1,1208,1217,1061,-1,82,138,195,-1,1132,893,733,-1,995,1125,1208,-1,1333,1304,1288,-1,1219,1304,1296,-1,335,138,118,-1,1172,1225,1246,-1,953,824,278,-1,838,1115,1109,-1,1115,1280,1225,-1,410,427,295,-1,562,852,962,-1,373,875,927,-1,785,749,702,-1,582,106,351,-1,1283,1126,1012,-1,506,928,632,-1,895,490,909,-1,1083,1154,1086,-1,1306,1077,1175,-1,1073,1202,1293,-1,745,534,381,-1,1048,1067,790,-1,842,100,639,-1,819,249,280,-1,829,1007,918,-1,842,639,810,-1,571,83,155,-1,113,12,100,-1,1007,829,1005,-1,918,479,574,-1,289,216,241,-1,884,890,978,-1,858,553,787,-1,1318,1338,1327,-1,1173,1205,1327,-1,856,790,442,-1,330,246,446,-1,880,1070,1269,-1,937,835,347,-1,265,252,182,-1,189,209,125,-1,236,300,261,-1,261,293,236,-1,486,236,713,-1,403,817,628,-1,937,1165,1089,-1,768,835,1089,-1,751,457,256,-1,820,570,848,-1,1331,1253,1334,-1,1166,1233,1305,-1,1096,1060,1199,-1,62,11,67,-1,721,422,590,-1,636,755,850,-1,9,221,184,-1,420,473,167,-1,423,70,190,-1,233,230,96,-1,185,35,5,-1,311,188,33,-1,560,263,254,-1,455,213,511,-1,919,1050,960,-1,832,725,513,-1,248,66,146,-1,1218,945,963,-1,552,989,760,-1,305,367,202,-1,360,516,470,-1,30,111,146,-1,296,169,90,-1,191,117,136,-1,169,296,414,-1,38,53,66,-1,343,140,191,-1,344,168,364,-1,421,524,441,-1,1279,1168,1210,-1,52,10,33,-1,130,193,348,-1,483,452,504,-1,193,345,348,-1,29,19,162,-1,28,19,4,-1,425,247,162,-1,81,325,365,-1,384,354,301,-1,208,122,134,-1,231,253,116,-1,594,609,392,-1,946,1064,417,-1,871,1082,855,-1,1034,1076,1170,-1,987,1102,998,-1,266,405,722,-1,763,587,517,-1,554,532,816,-1,761,512,851,-1,775,961,783,-1,463,332,345,-1,257,150,158,-1,192,327,370,-1,345,247,425,-1,862,463,425,-1,286,204,192,-1,121,258,563,-1,635,135,77,-1,666,663,1091,-1,737,1002,1028,-1,1164,854,1063,-1,1183,1059,1276,-1,1279,1210,1295,-1,597,501,638,-1,616,716,766,-1,361,76,199,-1,1328,1281,1319,-1,1317,1045,1281,-1,288,361,848,-1,682,316,334,-1,290,142,298,-1,708,750,550,-1,550,567,371,-1,1076,843,984,-1,1160,1177,1102,-1,294,143,256,-1,1072,627,820,-1,762,493,384,-1,367,432,417,-1,1009,776,1075,-1,634,501,457,-1,40,160,86,-1,34,40,86,-1,742,766,642,-1,488,387,541,-1,359,776,751,-1,358,498,475,-1,317,496,499,-1,549,735,1022,-1,949,863,751,-1,1183,1295,1210,-1,172,199,76,-1,1284,1221,1275,-1,1330,1334,1325,-1,592,833,952,-1,952,833,1031,-1,276,116,143,-1,594,617,975,-1,1149,1206,1262,-1,1328,1341,1316,-1,820,848,1180,-1,215,276,594,-1,359,256,143,-1,48,55,43,-1,43,55,124,-1,134,124,55,-1,1226,1206,975,-1,101,112,172,-1,1064,518,417,-1,454,206,211,-1,112,67,206,-1,919,832,938,-1,513,128,248,-1,850,1324,985,-1,1020,422,492,-1,888,586,592,-1,989,1237,760,-1,58,227,318,-1,420,423,837,-1,481,850,449,-1,259,188,260,-1,171,268,35,-1,51,141,271,-1,963,807,600,-1,552,282,306,-1,707,1234,503,-1,1096,521,370,-1,339,512,761,-1,532,707,503,-1,1264,769,914,-1,1234,1331,1233,-1,512,339,71,-1,761,862,425,-1,1104,1049,983,-1,362,452,462,-1,563,789,483,-1,0,22,10,-1,22,139,170,-1,900,552,485,-1,898,781,1013,-1,563,1135,1095,-1,142,290,75,-1,129,75,290,-1,411,796,992,-1,1224,1153,1159,-1,1110,1047,1055,-1,1110,1028,857,-1,1169,522,864,-1,411,255,177,-1,575,255,508,-1,558,700,525,-1,700,701,525,-1,575,451,255,-1,411,508,255,-1,1169,777,522,-1,635,1110,857,-1,1110,1055,1091,-1,1091,1028,1110,-1,1224,1138,1153,-1,1159,1094,1079,-1,992,508,411,-1,290,468,129,-1,789,563,1095,-1,781,1098,1013,-1,900,485,898,-1,547,409,437,-1,0,10,29,-1,1135,1056,1300,-1,509,214,593,-1,332,402,497,-1,374,593,214,-1,1056,1004,1164,-1,1104,1145,1049,-1,71,320,512,-1,914,1184,1264,-1,532,503,456,-1,425,339,761,-1,1060,1096,370,-1,1234,1264,1331,-1,1264,1253,1331,-1,425,225,339,-1,552,760,282,-1,807,433,600,-1,536,560,366,-1,271,232,51,-1,268,137,35,-1,260,368,259,-1,850,985,449,-1,837,715,420,-1,318,233,58,-1,455,93,213,-1,888,592,590,-1,1020,492,985,-1,850,1069,1324,-1,938,1050,919,-1,888,1020,1197,-1,67,211,206,-1,1069,850,755,-1,454,211,540,-1,975,1072,1226,-1,134,122,124,-1,124,215,43,-1,48,43,9,-1,143,253,359,-1,594,392,215,-1,1317,1328,1316,-1,1206,1226,1287,-1,870,594,975,-1,276,143,294,-1,1149,952,1031,-1,721,592,952,-1,1330,1325,1314,-1,1284,1238,1221,-1,76,57,172,-1,1098,1183,1210,-1,949,751,1009,-1,1022,946,549,-1,499,312,317,-1,208,358,475,-1,776,1009,751,-1,354,498,358,-1,361,288,76,-1,642,631,742,-1,34,86,95,-1,501,377,457,-1,1075,1029,1009,-1,367,417,202,-1,384,576,762,-1,294,256,375,-1,1177,1076,1085,-1,1177,1085,1102,-1,567,334,371,-1,387,240,160,-1,1281,1328,1317,-1,1319,1329,1328,-1,766,698,616,-1,638,620,597,-1,1295,1312,1279,-1,1276,1295,1183,-1,1164,1004,854,-1,714,737,1028,-1,666,1091,1055,-1,706,635,77,-1,121,563,159,-1,509,593,738,-1,39,61,110,-1,214,509,477,-1,286,237,204,-1,463,345,425,-1,192,370,286,-1,257,158,237,-1,332,497,345,-1,783,612,775,-1,851,878,761,-1,816,786,554,-1,722,775,266,-1,987,1158,1102,-1,1082,1029,1075,-1,1076,1034,843,-1,1082,987,855,-1,594,870,609,-1,253,143,116,-1,208,187,122,-1,354,358,301,-1,99,81,365,-1,425,162,225,-1,28,4,25,-1,162,102,29,-1,193,247,345,-1,348,307,130,-1,52,6,10,-1,1168,1071,1210,-1,591,831,428,-1,421,441,346,-1,343,191,419,-1,38,66,54,-1,414,285,169,-1,191,136,234,-1,140,114,92,-1,90,154,296,-1,103,109,196,-1,30,146,18,-1,470,299,360,-1,305,202,151,-1,552,900,989,-1,807,945,705,-1,832,513,770,-1,960,917,919,-1,601,960,943,-1,511,915,455,-1,254,366,560,-1,31,311,33,-1,233,96,58,-1,699,423,190,-1,449,519,318,-1,184,48,9,-1,636,850,473,-1,67,112,62,-1,1199,1124,1096,-1,1233,1330,1305,-1,1253,1262,1334,-1,570,288,848,-1,256,359,751,-1,1089,891,768,-1,1089,835,937,-1,403,628,181,-1,486,300,236,-1,261,291,293,-1,182,189,125,-1,347,545,937,-1,1269,1195,880,-1,1269,1070,1204,-1,246,555,446,-1,446,856,442,-1,906,942,793,-1,1318,1327,1343,-1,41,283,210,-1,752,1106,834,-1,844,933,1011,-1,1106,752,966,-1,194,338,283,-1,241,357,289,-1,1007,1005,1277,-1,571,155,412,-1,887,842,810,-1,574,829,918,-1,969,819,280,-1,1007,1119,918,-1,1067,582,790,-1,745,911,534,-1,973,782,805,-1,1293,1114,1073,-1,1306,1207,1077,-1,1086,972,1083,-1,895,373,490,-1,506,926,928,-1,1283,1012,1120,-1,1065,1250,867,-1,785,702,469,-1,373,927,297,-1,1100,1220,852,-1,562,588,852,-1,410,494,427,-1,131,297,469,-1,1225,1109,1115,-1,585,490,238,-1,838,1109,923,-1,118,272,335,-1,1219,1296,1132,-1,1333,1296,1304,-1,1208,1088,995,-1,733,1061,1132,-1,166,390,520,-1,56,118,138,-1,335,703,489,-1,703,733,489,-1,1061,1084,1208,-1,314,510,389,-1,389,510,749,-1,27,16,8,-1,133,105,60,-1,1261,1172,1286,-1,126,49,161,-1,323,610,791,-1,1025,1041,841,-1,605,577,995,-1,808,974,853,-1,579,624,631,-1,1307,1248,1258,-1,1258,1178,1292,-1,967,821,739,-1,270,577,329,-1,581,767,959,-1,1088,1208,1084,-1,245,269,163,-1,356,500,269,-1,988,1030,794,-1,794,604,641,-1,1030,1023,682,-1,390,980,1052,-1,63,321,24,-1,23,17,13,-1,1143,1261,980,-1,647,730,717,-1,36,49,126,-1,161,49,68,-1,194,275,458,-1,349,737,714,-1,261,663,666,-1,1193,787,1074,-1,1141,1111,1057,-1,918,882,479,-1,918,1099,1026,-1,969,1016,1150,-1,1087,1111,1185,-1,1026,1011,882,-1,650,1008,887,-1,573,491,801,-1,574,528,829,-1,758,561,530,-1,569,573,936,-1,242,183,352,-1,270,315,262,-1,382,841,860,-1,471,262,461,-1,953,278,397,-1,610,476,615,-1,893,607,489,-1,1208,1125,1117,-1,1232,1223,1144,-1,1119,1181,918,-1,1320,1323,1310,-1,1318,1241,1181,-1,1003,1026,1099,-1,1214,1003,1130,-1,1315,1338,1336,-1,126,273,176,-1,931,502,753,-1,996,902,916,-1,929,1151,997,-1,1290,1255,1303,-1,1255,1291,1303,-1,1167,1053,925,-1,1151,1113,1209,-1,1167,1044,1201,-1,1313,1326,1198,-1,876,982,1046,-1,1157,979,1040,-1,582,351,790,-1,381,398,127,-1,830,440,398,-1,598,588,494,-1,427,383,295,-1,401,383,743,-1,448,830,1065,-1,1090,1081,782,-1,1315,1033,1309,-1,1283,1137,1126,-1,1152,926,648,-1,1012,823,895,-1,1333,1288,1156,-1,785,927,623,-1,1280,1332,1278,-1,144,280,249,-1,8,82,89,-1,1052,802,520,-1,771,967,965,-1,280,144,37,-1,852,1220,1278,-1,373,823,875,-1,909,490,869,-1,1012,865,823,-1,1086,875,823,-1,1066,1154,1083,-1,448,867,907,-1,295,383,401,-1,852,598,920,-1,534,398,381,-1,106,582,381,-1,1198,1326,1291,-1,1186,1162,1157,-1,1186,1171,1188,-1,1046,1147,1171,-1,1108,1201,1044,-1,1209,1272,1311,-1,1151,1251,1203,-1,1261,1286,1307,-1,797,1053,873,-1,1258,1248,1108,-1,1035,996,1205,-1,901,502,931,-1,996,916,958,-1,1048,1173,1215,-1,906,858,890,-1,1130,1181,1241,-1,1310,1323,1119,-1,927,1289,1267,-1,1162,1093,953,-1,1128,1146,1134,-1,881,581,847,-1,959,1037,1021,-1,1213,1232,1118,-1,1061,1219,1132,-1,539,471,525,-1,610,323,308,-1,308,331,439,-1,245,356,269,-1,183,262,352,-1,765,801,412,-1,466,395,557,-1,650,479,882,-1,729,608,834,-1,1247,1192,1302,-1,1204,1018,1023,-1,1192,1030,988,-1,1011,1141,1150,-1,1200,1239,1185,-1,1196,1245,1231,-1,1200,1193,1216,-1,840,858,787,-1,486,349,300,-1,458,349,486,-1,283,41,64,-1,746,806,877,-1,649,730,647,-1,13,7,60,-1,65,176,63,-1,1052,1178,808,-1,291,666,189,-1,719,686,684,-1,308,223,331,-1,965,1084,703,-1,397,922,953,-1,278,841,382,-1,434,406,186,-1,460,223,179,-1,380,542,515,-1,771,744,821,-1,1179,1229,1211,-1,1313,1311,1272,-1,1052,1261,1292,-1,558,611,680,-1,1021,860,1041,-1,605,739,407,-1,315,329,380,-1,273,126,246,-1,133,144,218,-1,56,138,82,-1,703,1084,1061,-1,272,703,335,-1,272,166,520,-1,314,489,607,-1,893,1068,912,-1,1219,1217,1223,-1,1304,1232,1213,-1,118,166,272,-1,538,923,747,-1,689,877,692,-1,813,1156,892,-1,991,1039,1213,-1,1123,583,1112,-1,1115,1136,1301,-1,1172,1109,1225,-1,494,465,427,-1,440,465,222,-1,373,297,131,-1,823,373,895,-1,583,585,238,-1,927,785,469,-1,865,1175,1077,-1,1283,1120,1176,-1,1012,909,1120,-1,1242,1283,1250,-1,1073,644,534,-1,1067,381,582,-1,1320,1310,1277,-1,89,200,155,-1,83,639,100,-1,645,633,376,-1,1005,1116,1277,-1,650,887,530,-1,641,376,250,-1,801,571,412,-1,528,557,1005,-1,1119,1277,1310,-1,337,218,302,-1,633,418,376,-1,729,1106,933,-1,1106,1200,1133,-1,955,981,1054,-1,446,442,330,-1,281,502,161,-1,1343,1205,1222,-1,793,942,753,-1,161,502,555,-1,459,330,442,-1,787,210,283,-1,156,165,125,-1,291,252,293,-1,300,663,261,-1,817,403,719,-1,1062,891,1089,-1,1060,1166,1305,-1,62,112,101,-1,62,128,513,-1,492,519,985,-1,473,850,481,-1,519,478,318,-1,519,492,259,-1,188,311,277,-1,436,455,915,-1,943,960,1050,-1,426,770,513,-1,963,945,807,-1,963,760,1237,-1,18,146,66,-1,157,152,174,-1,299,174,197,-1,85,115,45,-1,239,296,154,-1,73,42,117,-1,191,140,92,-1,76,34,57,-1,239,95,86,-1,139,346,309,-1,428,781,514,-1,409,378,363,-1,346,319,404,-1,1071,1168,1032,-1,172,206,454,-1,282,119,170,-1,162,247,193,-1,6,4,19,-1,225,19,28,-1,81,52,422,-1,229,173,202,-1,212,219,229,-1,762,795,464,-1,324,354,384,-1,132,358,208,-1,215,124,276,-1,871,855,822,-1,1036,1022,735,-1,904,1014,1036,-1,886,910,499,-1,1022,1036,1163,-1,914,551,587,-1,851,783,878,-1,551,430,554,-1,697,463,862,-1,503,537,456,-1,120,39,148,-1,120,298,142,-1,332,336,192,-1,158,164,226,-1,110,97,145,-1,504,374,563,-1,1145,1274,1164,-1,857,1063,854,-1,1274,1056,1164,-1,467,535,599,-1,723,548,472,-1,716,727,723,-1,1284,1335,1329,-1,848,361,1045,-1,1281,1168,1279,-1,1281,1045,1168,-1,288,541,387,-1,683,316,682,-1,1153,677,666,-1,334,567,682,-1,1243,1238,1297,-1,1014,1121,1036,-1,617,294,375,-1,417,432,946,-1,941,496,1064,-1,1160,940,910,-1,1163,1121,886,-1,828,800,949,-1,501,597,377,-1,109,114,168,-1,18,74,44,-1,76,288,160,-1,680,734,780,-1,312,499,324,-1,863,457,751,-1,949,1009,1029,-1,1098,1210,1071,-1,1199,1221,1131,-1,1262,1206,1287,-1,594,276,294,-1,975,627,1072,-1,820,1180,1072,-1,609,1031,833,-1,609,484,274,-1,122,116,124,-1,132,55,48,-1,1072,1180,1226,-1,622,454,803,-1,692,467,689,-1,450,184,527,-1,132,301,358,-1,759,527,221,-1,832,919,879,-1,755,527,759,-1,449,985,519,-1,759,1139,1069,-1,888,590,422,-1,268,171,478,-1,227,58,70,-1,227,449,318,-1,93,58,96,-1,807,705,271,-1,760,963,282,-1,71,28,25,-1,1184,1142,1253,-1,1234,769,1264,-1,750,977,633,-1,71,1,320,-1,816,532,697,-1,1097,977,708,-1,914,769,551,-1,783,851,512,-1,28,71,225,-1,1145,1063,1049,-1,682,567,645,-1,374,159,563,-1,1019,1124,1131,-1,1097,1019,977,-1,355,287,363,-1,1135,1300,1276,-1,147,854,220,-1,362,287,307,-1,139,22,0,-1,591,409,547,-1,900,1013,885,-1,1135,563,258,-1,964,468,290,-1,1174,1182,1169,-1,1174,1224,1159,-1,663,714,1028,-1,279,79,255,-1,780,825,701,-1,1138,1169,864,-1,1138,1224,1169,-1,1079,1174,1159,-1,1079,947,1174,-1,575,992,1001,-1,575,508,992,-1,443,451,818,-1,279,451,443,-1,59,443,507,-1,50,443,59,-1,992,964,1182,-1,796,964,992,-1,87,129,59,-1,129,87,75,-1,1098,831,1183,-1,781,831,1098,-1,149,130,205,-1,149,21,130,-1,243,1056,258,-1,243,1004,1056,-1,789,939,547,-1,789,1095,939,-1,738,504,497,-1,593,504,738,-1,374,504,593,-1,91,243,98,-1,243,91,220,-1,145,107,150,-1,107,145,97,-1,257,286,322,-1,257,237,286,-1,878,845,786,-1,845,878,961,-1,326,266,84,-1,326,405,266,-1,1233,503,1234,-1,1233,537,503,-1,84,365,326,-1,84,99,365,-1,259,33,188,-1,259,52,33,-1,277,415,333,-1,277,311,415,-1,576,948,762,-1,576,868,948,-1,93,436,190,-1,93,455,436,-1,482,837,709,-1,482,715,837,-1,1324,1020,985,-1,1197,1020,1324,-1,482,636,715,-1,636,482,450,-1,399,132,244,-1,399,301,132,-1,540,803,454,-1,803,540,778,-1,47,274,203,-1,47,108,274,-1,1317,1180,848,-1,1317,1316,1180,-1,1206,870,975,-1,1031,870,1206,-1,721,1043,772,-1,721,952,1043,-1,1314,1305,1330,-1,1305,1314,1275,-1,1275,1335,1284,-1,1335,1275,1314,-1,811,172,622,-1,172,811,199,-1,665,564,662,-1,665,602,564,-1,187,475,505,-1,187,208,475,-1,949,799,863,-1,799,949,800,-1,240,488,424,-1,488,240,387,-1,618,660,544,-1,660,618,664,-1,86,240,180,-1,86,160,240,-1,45,44,42,-1,45,30,44,-1,625,364,341,-1,618,364,625,-1,1102,1051,957,-1,1102,1158,1051,-1,1014,843,1034,-1,904,843,1014,-1,904,935,843,-1,1341,1314,1325,-1,1314,1341,1335,-1,371,708,550,-1,371,388,708,-1,629,298,684,-1,629,522,298,-1,567,750,645,-1,750,567,550,-1,716,642,766,-1,690,642,716,-1,597,727,541,-1,727,597,620,-1,620,535,548,-1,620,638,535,-1,472,691,723,-1,472,694,691,-1,688,467,599,-1,688,689,467,-1,1308,1279,1312,-1,1308,1319,1279,-1,932,1049,950,-1,983,1049,932,-1,1095,1059,939,-1,1276,1059,1095,-1,61,220,91,-1,61,147,220,-1,164,121,159,-1,104,121,164,-1,322,370,521,-1,286,370,322,-1,145,201,110,-1,201,145,267,-1,551,786,845,-1,554,786,551,-1,612,320,228,-1,612,783,320,-1,532,430,707,-1,532,554,430,-1,1051,606,595,-1,1058,606,1051,-1,784,897,774,-1,784,908,897,-1,526,549,432,-1,564,549,526,-1,788,668,774,-1,668,788,669,-1,9,108,47,-1,43,108,9,-1,116,187,231,-1,187,116,122,-1,658,526,495,-1,658,661,526,-1,25,81,99,-1,25,4,81,-1,437,452,483,-1,452,437,462,-1,404,421,346,-1,404,385,421,-1,205,404,149,-1,205,385,404,-1,428,421,400,-1,514,421,428,-1,514,524,421,-1,114,343,341,-1,114,140,343,-1,487,414,566,-1,487,285,414,-1,343,584,578,-1,419,584,343,-1,679,625,578,-1,674,625,679,-1,673,630,704,-1,675,630,673,-1,631,696,742,-1,631,672,696,-1,57,101,172,-1,57,54,101,-1,136,285,234,-1,169,285,136,-1,92,117,191,-1,92,73,117,-1,529,360,353,-1,529,516,360,-1,30,115,111,-1,30,45,115,-1,305,470,480,-1,470,305,299,-1,157,202,173,-1,151,202,157,-1,795,832,770,-1,795,938,832,-1,1218,903,945,-1,1218,1122,903,-1,511,263,560,-1,511,153,263,-1,600,119,282,-1,600,415,119,-1,230,171,185,-1,171,230,233,-1,699,837,423,-1,837,699,968,-1,473,227,167,-1,473,481,227,-1,482,184,450,-1,482,244,184,-1,9,67,11,-1,67,9,47,-1,391,11,62,-1,391,235,11,-1,1233,1334,1330,-1,1233,1331,1334,-1,820,614,570,-1,820,627,614,-1,930,656,633,-1,930,932,656,-1,209,677,681,-1,209,189,677,-1,189,252,291,-1,189,182,252,-1,768,523,340,-1,891,523,768,-1,990,937,545,-1,990,1165,937,-1,1294,1273,1266,-1,1294,1265,1273,-1,1195,990,880,-1,1195,1266,990,-1,379,1070,880,-1,628,1070,379,-1,1195,1257,1285,-1,1269,1257,1195,-1,981,978,1054,-1,884,978,981,-1,790,1035,1048,-1,790,856,1035,-1,1338,1309,1327,-1,1338,1315,1309,-1,210,68,41,-1,251,68,210,-1,840,608,844,-1,840,752,608,-1,752,840,966,-1,1074,1244,1216,-1,1103,1244,1074,-1,954,1087,1078,-1,954,1024,1087,-1,491,466,561,-1,395,466,491,-1,1092,1017,1260,-1,1092,936,1017,-1,842,113,100,-1,842,804,113,-1,970,1260,1017,-1,970,1249,1260,-1,1315,1086,1154,-1,1315,1289,1086,-1,934,1066,1010,-1,934,1033,1066,-1,394,767,581,-1,394,474,767,-1,907,1250,1152,-1,907,867,1250,-1,506,859,640,-1,506,632,859,-1,295,394,410,-1,394,295,264,-1,304,131,469,-1,80,131,304,-1,1213,944,1101,-1,1213,1039,944,-1,538,838,923,-1,565,838,538,-1,1068,1301,1136,-1,1068,1235,1301,-1,166,24,390,-1,166,26,24,-1,489,138,335,-1,138,489,314,-1,303,623,572,-1,303,389,623,-1,37,27,15,-1,69,27,37,-1,7,69,60,-1,27,69,7,-1,1172,531,747,-1,1143,531,1172,-1,779,665,662,-1,779,741,665,-1,874,1144,839,-1,874,1118,1144,-1,543,380,407,-1,542,380,543,-1,853,1107,924,-1,974,1107,853,-1,660,728,798,-1,664,728,660,-1,1107,1258,1161,-1,1107,1178,1258,-1,1311,1298,1299,-1,1311,1313,1298,-1,976,720,1000,-1,720,976,728,-1,292,242,386,-1,292,183,242,-1,500,331,310,-1,500,439,331,-1,500,413,439,-1,46,105,94,-1,46,60,105,-1,106,3,80,-1,106,127,3,-1,1165,1265,1089,-1,1165,1273,1265,-1,642,647,579,-1,647,642,690,-1,596,744,808,-1,726,744,596,-1,806,726,792,-1,806,710,726,-1,65,32,36,-1,65,23,32,-1,194,94,216,-1,194,64,94,-1,393,656,659,-1,393,416,656,-1,236,643,713,-1,643,236,293,-1,1212,1322,1302,-1,1212,1268,1322,-1,1231,1252,1282,-1,1245,1252,1231,-1,969,1024,819,-1,1024,969,1057,-1,1133,1111,1141,-1,1133,1185,1111,-1,561,574,530,-1,561,466,574,-1,826,573,765,-1,936,573,826,-1,315,461,262,-1,315,515,461,-1,406,839,386,-1,406,874,839,-1,444,559,568,-1,444,435,559,-1,791,814,922,-1,814,791,779,-1,668,556,568,-1,669,556,668,-1,1235,1333,1301,-1,1333,1235,1296,-1,1144,1217,1117,-1,1223,1217,1144,-1,814,658,846,-1,814,661,658,-1,1267,1320,1249,-1,1267,1337,1320,-1,844,1003,840,-1,844,1026,1003,-1,993,996,958,-1,993,1027,996,-1,993,1140,1191,-1,993,958,1140,-1,916,931,951,-1,916,901,931,-1,916,815,901,-1,997,1229,1000,-1,997,1203,1229,-1,873,732,718,-1,905,732,873,-1,976,798,728,-1,798,976,999,-1,678,732,757,-1,676,732,678,-1,797,651,754,-1,797,646,651,-1,740,913,754,-1,971,913,740,-1,1108,925,913,-1,1044,925,1108,-1,1227,1251,1151,-1,1227,1271,1251,-1,812,660,798,-1,657,660,812,-1,827,653,654,-1,653,827,876,-1,979,861,1040,-1,979,846,861,-1,494,546,598,-1,494,410,546,-1,440,127,398,-1,440,222,127,-1,1081,830,782,-1,1081,1187,830,-1,1215,745,1067,-1,1215,934,745,-1,1175,1137,1155,-1,1126,1137,1175,-1,506,648,926,-1,372,648,506,-1,1120,869,1176,-1,1120,909,869,-1,1156,859,892,-1,1156,1101,859,-1,1280,1333,1332,-1,1301,1333,1280,-1,1332,962,1278,-1,1332,1112,962,-1,418,357,337,-1,416,357,418,-1,26,118,56,-1,166,118,26,-1,921,965,967,-1,921,1088,965,-1,1088,605,995,-1,921,605,1088,-1,1255,1246,1220,-1,1255,1290,1246,-1,583,222,562,-1,583,207,222,-1,222,3,127,-1,222,207,3,-1,912,1136,889,-1,912,1068,1136,-1,865,972,823,-1,865,1077,972,-1,911,934,1010,-1,934,911,745,-1,598,881,920,-1,598,546,881,-1,1100,1129,1198,-1,1129,1100,920,-1,1046,1189,1040,-1,1171,1189,1046,-1,1188,1147,1228,-1,1171,1147,1188,-1,654,812,827,-1,812,654,657,-1,1303,1286,1290,-1,1303,1307,1286,-1,624,754,651,-1,740,754,624,-1,646,672,651,-1,646,673,672,-1,757,679,678,-1,757,764,679,-1,764,1000,720,-1,1000,764,997,-1,646,873,718,-1,873,646,797,-1,555,815,446,-1,815,555,901,-1,1027,1191,1222,-1,1027,993,1191,-1,955,916,951,-1,956,916,955,-1,956,958,916,-1,1143,321,531,-1,1143,980,321,-1,1006,1249,970,-1,1006,1267,1249,-1,814,979,922,-1,979,814,846,-1,881,1146,1128,-1,881,847,1146,-1,991,959,1039,-1,991,1037,959,-1,669,615,556,-1,670,615,669,-1,701,539,525,-1,671,539,701,-1,435,539,559,-1,435,471,539,-1,308,447,476,-1,308,439,447,-1,748,386,839,-1,386,748,292,-1,1092,619,569,-1,1116,619,1092,-1,896,887,1008,-1,896,804,887,-1,1011,1133,1141,-1,1011,933,1133,-1,1322,1204,1247,-1,1322,1269,1204,-1,819,954,641,-1,1024,954,819,-1,858,793,553,-1,793,858,906,-1,659,349,393,-1,349,659,737,-1,32,94,64,-1,32,46,94,-1,792,877,806,-1,877,792,872,-1,710,746,621,-1,746,710,806,-1,543,739,621,-1,543,407,739,-1,730,924,717,-1,730,853,924,-1,23,46,32,-1,23,13,46,-1,1023,684,683,-1,1023,1018,684,-1,681,403,209,-1,681,687,403,-1,465,562,222,-1,588,562,465,-1,241,94,105,-1,94,241,216,-1,500,342,413,-1,500,356,342,-1,245,186,242,-1,245,163,186,-1,1025,1146,1041,-1,1134,1146,1025,-1,922,1157,953,-1,1157,922,979,-1,186,386,242,-1,406,386,186,-1,611,515,542,-1,558,515,611,-1,1240,1271,1259,-1,1240,1251,1271,-1,1179,1000,1229,-1,1179,976,1000,-1,1256,1303,1291,-1,1303,1256,1201,-1,740,579,717,-1,579,740,624,-1,1117,839,1144,-1,748,839,1117,-1,278,1025,841,-1,824,1025,278,-1,16,26,56,-1,16,2,26,-1,195,89,82,-1,195,200,89,-1,2,24,26,-1,2,17,24,-1,577,284,736,-1,284,577,270,-1,510,912,749,-1,912,510,607,-1,1219,1232,1304,-1,1219,1223,1232,-1,304,538,351,-1,304,565,538,-1,767,1039,959,-1,1039,767,944,-1,1123,1332,1333,-1,1123,1112,1332,-1,80,351,106,-1,80,304,351,-1,585,892,712,-1,813,892,585,-1,238,373,14,-1,373,238,490,-1,865,1126,1175,-1,1126,865,1012,-1,1187,1137,1242,-1,1187,1081,1137,-1,474,264,372,-1,394,264,474,-1,934,1309,1033,-1,934,1215,1309,-1,1090,1114,1293,-1,973,1114,1090,-1,1065,1242,1250,-1,1187,1242,1065,-1,1073,805,644,-1,1073,1114,805,-1,1249,1342,1260,-1,1249,1320,1342,-1,155,303,328,-1,200,303,155,-1,1016,113,896,-1,1016,178,113,-1,936,637,1017,-1,637,936,826,-1,1078,988,954,-1,1078,1105,988,-1,1245,1244,1252,-1,1245,1236,1244,-1,1193,1106,966,-1,1193,1200,1106,-1,241,337,357,-1,224,337,241,-1,250,218,249,-1,302,218,250,-1,608,933,844,-1,608,729,933,-1,1127,338,458,-1,338,1127,1103,-1,1205,1048,1035,-1,1173,1048,1205,-1,1140,1038,1214,-1,1038,1140,1054,-1,281,753,502,-1,281,408,753,-1,251,787,553,-1,251,210,787,-1,836,1257,533,-1,1257,836,1285,-1,880,545,379,-1,880,990,545,-1,523,836,396,-1,836,523,899,-1,1266,1165,990,-1,1266,1273,1165,-1,627,377,614,-1,627,375,377,-1,540,203,453,-1,203,540,211,-1,888,778,586,-1,888,1042,778,-1,368,478,519,-1,368,268,478,-1,415,433,333,-1,600,433,415,-1,945,511,560,-1,945,903,511,-1,146,173,217,-1,146,157,173,-1,655,495,480,-1,655,658,495,-1,480,653,655,-1,653,480,470,-1,353,197,196,-1,353,360,197,-1,544,353,344,-1,353,544,529,-1,136,42,44,-1,117,42,136,-1,57,38,54,-1,57,34,38,-1,589,742,696,-1,742,589,603,-1,672,704,696,-1,672,673,704,-1,679,584,678,-1,679,578,584,-1,341,578,625,-1,343,578,341,-1,487,704,630,-1,566,704,487,-1,524,781,898,-1,514,781,524,-1,149,319,123,-1,149,404,319,-1,421,378,400,-1,421,355,378,-1,421,385,355,-1,1045,199,811,-1,1045,361,199,-1,217,229,219,-1,229,217,173,-1,518,229,417,-1,518,212,229,-1,948,795,762,-1,795,948,938,-1,731,669,788,-1,669,731,670,-1,822,701,825,-1,701,822,671,-1,774,894,788,-1,774,897,894,-1,908,935,897,-1,908,987,935,-1,496,886,499,-1,886,496,941,-1,957,595,505,-1,1051,595,957,-1,612,266,775,-1,266,612,228,-1,456,336,697,-1,456,445,336,-1,456,537,445,-1,110,148,39,-1,148,110,201,-1,148,316,120,-1,148,334,316,-1,150,104,158,-1,150,107,104,-1,107,121,104,-1,107,98,121,-1,147,39,135,-1,39,147,61,-1,1002,659,950,-1,737,659,1002,-1,1243,1308,1274,-1,1243,1297,1308,-1,467,548,535,-1,472,548,467,-1,599,638,724,-1,535,638,599,-1,634,799,724,-1,634,863,799,-1,87,706,77,-1,809,706,87,-1,75,77,20,-1,87,77,75,-1,1034,1121,1014,-1,1034,1170,1121,-1,198,317,312,-1,317,198,212,-1,1058,1158,1082,-1,1051,1158,1058,-1,886,1160,910,-1,1121,1160,886,-1,570,597,541,-1,597,570,614,-1,42,85,45,-1,85,42,73,-1,180,424,369,-1,180,240,424,-1,169,74,90,-1,169,136,74,-1,800,695,799,-1,695,800,734,-1,317,1064,496,-1,1064,317,518,-1,1071,885,1013,-1,1071,1032,885,-1,1275,1199,1305,-1,1199,1275,1221,-1,453,592,586,-1,453,484,592,-1,108,392,274,-1,215,392,108,-1,803,1042,989,-1,803,778,1042,-1,301,576,384,-1,399,576,301,-1,11,221,9,-1,11,235,221,-1,989,1263,1237,-1,989,1042,1263,-1,709,968,868,-1,837,968,709,-1,233,478,171,-1,318,478,233,-1,230,153,96,-1,230,263,153,-1,1080,868,968,-1,868,1080,948,-1,31,415,311,-1,31,119,415,-1,232,254,51,-1,254,232,366,-1,96,213,93,-1,213,96,153,-1,536,271,705,-1,536,232,271,-1,1,99,84,-1,1,25,99,-1,1043,1184,1015,-1,1184,1043,1142,-1,1233,327,445,-1,1233,1166,327,-1,711,405,326,-1,517,405,711,-1,371,267,388,-1,371,201,267,-1,98,97,91,-1,98,107,97,-1,214,159,374,-1,214,164,159,-1,994,1104,983,-1,1104,994,1131,-1,1124,1097,1096,-1,1097,1124,1019,-1,402,738,497,-1,402,477,738,-1,1004,220,854,-1,243,220,1004,-1,306,139,309,-1,139,306,170,-1,307,205,130,-1,287,205,307,-1,591,1059,831,-1,591,939,1059,-1,1169,964,777,-1,1182,964,1169,-1,78,59,129,-1,78,50,59,-1,50,279,443,-1,79,279,50,-1,1001,1182,1174,-1,1001,992,1182,-1,947,1001,1174,-1,1001,947,818,-1,629,687,864,-1,687,629,686,-1,177,78,350,-1,177,72,78,-1,507,818,947,-1,443,818,507,-1,796,468,964,-1,796,350,468,-1,87,507,809,-1,59,507,87,-1,147,857,854,-1,135,857,147,-1,635,857,135,-1,462,409,363,-1,409,462,437,-1,123,21,149,-1,123,0,21,-1,428,409,591,-1,400,409,428,-1,1295,1300,1312,-1,1300,1295,1276,-1,977,994,930,-1,977,1019,994,-1,150,267,145,-1,150,257,267,-1,708,1096,1097,-1,1096,708,521,-1,961,722,845,-1,722,961,775,-1,228,84,266,-1,1,84,228,-1,1015,914,763,-1,914,1015,1184,-1,862,816,697,-1,862,761,816,-1,772,326,365,-1,711,326,772,-1,22,119,31,-1,119,22,170,-1,333,88,277,-1,88,333,141,-1,5,137,88,-1,5,35,137,-1,190,943,699,-1,190,601,943,-1,709,244,482,-1,244,709,399,-1,1324,1139,1340,-1,1139,1324,1069,-1,450,755,636,-1,755,450,527,-1,391,725,773,-1,391,513,725,-1,1324,1263,1197,-1,1324,1340,1263,-1,692,472,467,-1,692,693,472,-1,622,1032,811,-1,622,885,1032,-1,48,244,132,-1,244,48,184,-1,484,833,592,-1,609,833,484,-1,1058,776,606,-1,1075,776,1058,-1,1253,1149,1262,-1,1253,1142,1149,-1,1316,1325,1287,-1,1316,1341,1325,-1,695,680,685,-1,734,680,695,-1,505,231,187,-1,231,505,595,-1,766,603,698,-1,742,603,766,-1,38,90,53,-1,154,90,38,-1,341,168,114,-1,341,364,168,-1,73,103,85,-1,73,92,103,-1,828,734,800,-1,734,828,780,-1,957,1160,1102,-1,1160,957,940,-1,1163,1064,1022,-1,1163,941,1064,-1,111,157,146,-1,152,157,111,-1,998,843,935,-1,998,984,843,-1,1243,1104,1238,-1,1145,1104,1243,-1,773,879,1122,-1,879,773,725,-1,864,681,1138,-1,864,687,681,-1,522,290,298,-1,290,522,777,-1,684,316,683,-1,684,298,316,-1,1297,1319,1308,-1,1297,1329,1319,-1,424,616,698,-1,424,488,616,-1,620,723,727,-1,723,620,548,-1,690,723,691,-1,690,716,723,-1,685,599,695,-1,688,599,685,-1,1002,1049,1063,-1,950,1049,1002,-1,547,483,789,-1,437,483,547,-1,388,521,708,-1,521,388,322,-1,142,20,120,-1,142,75,20,-1,226,332,204,-1,226,402,332,-1,845,587,551,-1,722,587,845,-1,430,769,707,-1,430,551,769,-1,780,871,825,-1,871,780,828,-1,498,940,475,-1,940,498,910,-1,894,1036,866,-1,894,904,1036,-1,822,908,784,-1,822,855,908,-1,735,731,866,-1,731,735,602,-1,774,667,784,-1,667,774,668,-1,661,564,526,-1,662,564,661,-1,198,464,219,-1,198,493,464,-1,367,526,432,-1,495,526,367,-1,52,4,6,-1,52,81,4,-1,0,102,21,-1,29,102,0,-1,885,989,900,-1,885,803,989,-1,287,385,205,-1,287,355,385,-1,485,524,898,-1,441,524,485,-1,487,234,285,-1,438,234,487,-1,584,438,613,-1,438,584,419,-1,618,674,664,-1,625,674,618,-1,630,676,613,-1,676,630,675,-1,431,566,414,-1,589,566,431,-1,239,369,431,-1,369,239,180,-1,529,654,516,-1,657,654,529,-1,197,152,115,-1,152,197,174,-1,151,299,305,-1,299,151,174,-1,217,248,146,-1,426,248,217,-1,464,770,426,-1,464,795,770,-1,917,511,903,-1,917,915,511,-1,137,277,88,-1,137,260,277,-1,399,868,576,-1,709,868,399,-1,203,484,453,-1,203,274,484,-1,1340,1122,1218,-1,1340,1139,1122,-1,1122,759,773,-1,1122,1139,759,-1,101,66,128,-1,101,54,66,-1,687,719,403,-1,686,719,687,-1,340,396,165,-1,523,396,340,-1,156,340,165,-1,156,347,340,-1,1062,1294,899,-1,1294,1062,1265,-1,1285,1266,1195,-1,1285,1294,1266,-1,379,181,628,-1,181,379,156,-1,486,1194,458,-1,486,1212,1194,-1,1212,486,713,-1,942,884,981,-1,906,884,942,-1,1321,1222,1191,-1,1321,1343,1222,-1,942,931,753,-1,931,942,951,-1,41,49,36,-1,68,49,41,-1,337,376,418,-1,337,302,376,-1,1078,1190,1196,-1,1078,1087,1190,-1,249,641,250,-1,819,641,249,-1,573,395,491,-1,569,395,573,-1,1260,1116,1092,-1,1116,1260,1342,-1,412,328,580,-1,155,328,412,-1,530,479,650,-1,530,574,479,-1,89,100,12,-1,89,83,100,-1,1017,572,970,-1,572,1017,637,-1,1215,1327,1309,-1,1173,1327,1215,-1,1254,1010,1066,-1,1202,1010,1254,-1,1207,1339,1254,-1,1207,1306,1339,-1,401,1152,648,-1,401,743,1152,-1,1101,640,859,-1,944,640,1101,-1,207,14,3,-1,238,14,207,-1,372,640,474,-1,640,372,506,-1,80,14,131,-1,80,3,14,-1,872,692,877,-1,872,693,692,-1,313,747,531,-1,313,459,747,-1,1101,1288,1213,-1,1156,1288,1101,-1,893,1235,1068,-1,1235,893,1132,-1,749,889,702,-1,749,912,889,-1,144,69,37,-1,133,69,144,-1,459,273,330,-1,459,313,273,-1,680,652,685,-1,652,680,611,-1,849,1118,874,-1,849,991,1118,-1,652,542,543,-1,611,542,652,-1,1272,1167,1256,-1,1272,1209,1167,-1,924,1161,971,-1,924,1107,1161,-1,1259,1299,1298,-1,1271,1299,1259,-1,744,802,808,-1,771,802,744,-1,186,460,434,-1,460,186,223,-1,183,284,262,-1,284,183,292,-1,278,179,323,-1,278,382,179,-1,1186,1230,1198,-1,1230,1186,1188,-1,223,310,331,-1,223,175,310,-1,1268,1269,1322,-1,1269,1268,1257,-1,643,1257,1268,-1,1257,643,533,-1,1070,817,1018,-1,1070,628,817,-1,744,710,821,-1,710,744,726,-1,649,726,596,-1,792,726,649,-1,649,690,691,-1,649,647,690,-1,746,685,652,-1,685,746,688,-1,289,349,275,-1,349,289,393,-1,1268,713,643,-1,1268,1212,713,-1,1302,1194,1212,-1,1282,1194,1302,-1,1216,1236,1239,-1,1216,1244,1236,-1,1239,1190,1185,-1,1239,1236,1190,-1,1023,1192,1247,-1,1023,1030,1192,-1,1192,1231,1302,-1,1105,1231,1192,-1,619,395,569,-1,395,619,557,-1,571,883,639,-1,571,801,883,-1,461,558,525,-1,515,558,461,-1,406,849,874,-1,434,849,406,-1,413,435,444,-1,413,352,435,-1,447,568,556,-1,447,444,568,-1,667,568,559,-1,668,568,667,-1,779,661,814,-1,661,779,662,-1,546,394,581,-1,410,394,546,-1,1093,824,953,-1,1093,1134,824,-1,1093,1129,1128,-1,1162,1129,1093,-1,1337,1289,1336,-1,1337,1267,1289,-1,1241,1343,1321,-1,1343,1241,1318,-1,351,459,442,-1,351,538,459,-1,958,1054,1140,-1,958,956,1054,-1,815,856,446,-1,856,815,902,-1,1113,873,1053,-1,873,1113,905,-1,905,757,732,-1,929,757,905,-1,674,728,664,-1,728,674,720,-1,676,718,732,-1,675,718,676,-1,797,913,925,-1,913,797,754,-1,971,1108,913,-1,1161,1108,971,-1,1299,1209,1311,-1,1209,1299,1227,-1,986,798,999,-1,812,798,986,-1,1147,986,1148,-1,1147,982,986,-1,653,861,655,-1,876,861,653,-1,846,655,861,-1,846,658,655,-1,1162,1198,1129,-1,1162,1186,1198,-1,830,429,440,-1,830,448,429,-1,1066,1207,1254,-1,1066,1083,1207,-1,474,944,767,-1,944,474,640,-1,490,712,869,-1,490,585,712,-1,565,469,702,-1,565,304,469,-1,1136,838,889,-1,1115,838,1136,-1,15,178,37,-1,15,113,178,-1,656,418,633,-1,656,416,418,-1,771,520,802,-1,771,626,520,-1,8,113,15,-1,8,12,113,-1,1225,1220,1246,-1,1220,1225,1278,-1,562,1112,583,-1,562,962,1112,-1,632,869,712,-1,869,632,928,-1,1283,1152,1250,-1,1283,1270,1152,-1,875,1289,927,-1,875,1086,1289,-1,1073,1010,1202,-1,1073,911,1010,-1,429,907,383,-1,429,448,907,-1,465,429,427,-1,440,429,465,-1,920,1128,1129,-1,920,881,1128,-1,876,1040,861,-1,1046,1040,876,-1,1228,1313,1230,-1,1228,1298,1313,-1,982,812,986,-1,982,827,812,-1,999,1211,1148,-1,999,1179,1211,-1,1053,1209,1113,-1,1209,1053,1167,-1,1246,1286,1172,-1,1246,1290,1286,-1,651,631,624,-1,651,672,631,-1,718,673,646,-1,673,718,675,-1,720,679,764,-1,679,720,674,-1,757,997,764,-1,997,757,929,-1,1151,905,1113,-1,905,1151,929,-1,1222,996,1027,-1,996,1222,1205,-1,981,951,942,-1,981,955,951,-1,747,1109,1172,-1,747,923,1109,-1,1321,1130,1241,-1,1321,1214,1130,-1,1336,1323,1337,-1,1318,1323,1336,-1,970,623,1006,-1,970,572,623,-1,741,670,665,-1,741,615,670,-1,671,559,539,-1,667,559,671,-1,556,476,447,-1,615,476,556,-1,439,444,447,-1,439,413,444,-1,434,860,849,-1,860,434,460,-1,736,292,748,-1,292,736,284,-1,883,810,639,-1,883,758,810,-1,1005,619,1116,-1,1005,557,619,-1,561,883,491,-1,561,758,883,-1,1105,1196,1231,-1,1078,1196,1105,-1,1150,896,1008,-1,1150,1016,896,-1,1127,1282,1252,-1,1127,1194,1282,-1,281,251,408,-1,251,281,68,-1,289,416,393,-1,416,289,357,-1,36,64,41,-1,36,32,64,-1,691,872,649,-1,872,691,694,-1,652,621,746,-1,652,543,621,-1,621,821,710,-1,621,739,821,-1,730,808,853,-1,596,808,730,-1,980,24,321,-1,980,390,24,-1,604,756,645,-1,794,756,604,-1,1018,719,684,-1,1018,817,719,-1,641,988,794,-1,641,954,988,-1,27,2,16,-1,7,2,27,-1,342,245,242,-1,356,245,342,-1,163,223,186,-1,175,223,163,-1,1148,1228,1147,-1,1148,1259,1228,-1,1259,1148,1240,-1,847,1041,1146,-1,959,1041,847,-1,959,1021,1041,-1,1251,1211,1229,-1,1251,1240,1211,-1,1307,1201,1248,-1,1307,1303,1201,-1,717,971,740,-1,717,924,971,-1,1326,1256,1291,-1,1326,1272,1256,-1,1125,748,1117,-1,1125,736,748,-1,1021,849,860,-1,849,1021,1037,-1,610,779,791,-1,610,741,779,-1,105,224,241,-1,133,224,105,-1,56,8,16,-1,56,82,8,-1,200,389,303,-1,200,195,389,-1,17,7,13,-1,2,7,17,-1,995,736,1125,-1,736,995,577,-1,838,702,889,-1,565,702,838,-1,176,531,321,-1,176,313,531,-1,712,859,632,-1,892,859,712,-1,1176,926,1270,-1,926,1176,928,-1,1155,1081,1090,-1,1081,1155,1137,-1,372,401,648,-1,264,401,372,-1,1293,1254,1339,-1,1202,1254,1293,-1,1090,1339,1155,-1,1293,1339,1090,-1,1083,1077,1207,-1,1083,972,1077,-1,644,782,398,-1,644,805,782,-1,856,996,1035,-1,996,856,902,-1,328,572,637,-1,303,572,328,-1,969,178,1016,-1,969,280,178,-1,637,580,328,-1,637,826,580,-1,194,289,275,-1,289,194,216,-1,1057,1087,1024,-1,1057,1111,1087,-1,1236,1196,1190,-1,1245,1196,1236,-1,1103,1252,1244,-1,1127,1252,1103,-1,1003,890,840,-1,1038,890,1003,-1,890,1038,978,-1,408,553,793,-1,408,251,553,-1,283,1103,1074,-1,283,338,1103,-1,1214,1191,1140,-1,1214,1321,1191,-1,293,265,643,-1,293,252,265,-1,396,533,265,-1,396,836,533,-1,379,347,156,-1,347,379,545,-1,899,1285,836,-1,1285,899,1294,-1,891,899,523,-1,899,891,1062,-1,347,768,340,-1,347,835,768,-1,165,265,182,-1,165,396,265,-1,181,209,403,-1,181,125,209,-1,375,457,377,-1,375,256,457,-1,1226,1316,1287,-1,1316,1226,1180,-1,983,930,994,-1,930,983,932,-1,235,773,759,-1,235,391,773,-1,473,715,636,-1,420,715,473,-1,190,58,93,-1,190,70,58,-1,52,492,422,-1,52,259,492,-1,333,271,141,-1,333,433,271,-1,436,917,960,-1,436,915,917,-1,917,879,919,-1,879,917,903,-1,219,426,217,-1,219,464,426,-1,480,367,305,-1,480,495,367,-1,653,516,654,-1,470,516,653,-1,660,529,544,-1,529,660,657,-1,196,344,353,-1,168,344,196,-1,414,239,431,-1,239,414,296,-1,431,603,589,-1,603,431,369,-1,696,566,589,-1,696,704,566,-1,613,678,584,-1,678,613,676,-1,544,364,618,-1,344,364,544,-1,613,487,630,-1,487,613,438,-1,438,191,234,-1,419,191,438,-1,346,123,319,-1,139,123,346,-1,193,21,102,-1,193,130,21,-1,348,497,504,-1,348,345,497,-1,721,365,325,-1,721,772,365,-1,670,602,665,-1,670,731,602,-1,784,671,822,-1,671,784,667,-1,866,788,894,-1,788,866,731,-1,897,904,894,-1,897,935,904,-1,505,940,957,-1,505,475,940,-1,871,1029,1082,-1,871,828,1029,-1,722,517,587,-1,517,722,405,-1,761,786,816,-1,761,878,786,-1,237,226,204,-1,237,158,226,-1,201,334,148,-1,201,371,334,-1,445,192,336,-1,445,327,192,-1,91,110,61,-1,110,91,97,-1,20,135,39,-1,20,77,135,-1,706,1110,635,-1,1047,1110,706,-1,656,950,659,-1,656,932,950,-1,1274,1312,1300,-1,1274,1308,1312,-1,724,695,599,-1,724,799,695,-1,501,724,638,-1,501,634,724,-1,541,616,488,-1,616,541,727,-1,79,177,255,-1,79,72,177,-1,1340,1237,1263,-1,1340,1218,1237,-1,1085,998,1102,-1,998,1085,984,-1,1121,1177,1160,-1,1177,1121,1170,-1,115,196,197,-1,85,196,115,-1,103,196,85,-1,312,493,198,-1,312,384,493,-1,312,324,384,-1,109,92,114,-1,109,103,92,-1,154,34,95,-1,154,38,34,-1,369,698,603,-1,369,424,698,-1,90,18,53,-1,90,74,18,-1,595,253,231,-1,595,606,253,-1,498,324,499,-1,354,324,498,-1,564,735,549,-1,564,602,735,-1,1131,1238,1104,-1,1238,1131,1221,-1,1334,1287,1325,-1,1334,1262,1287,-1,952,1142,1043,-1,952,1149,1142,-1,1335,1328,1329,-1,1328,1335,1341,-1,606,359,253,-1,776,359,606,-1,586,540,453,-1,540,586,778,-1,811,1168,1045,-1,811,1032,1168,-1,203,67,47,-1,67,203,211,-1,1197,1042,888,-1,1042,1197,1263,-1,948,1050,938,-1,1080,1050,948,-1,423,167,70,-1,420,167,423,-1,263,185,254,-1,230,185,263,-1,943,968,699,-1,968,943,1080,-1,88,51,5,-1,51,88,141,-1,5,254,185,-1,254,5,51,-1,268,260,137,-1,268,368,260,-1,560,705,945,-1,560,536,705,-1,346,485,309,-1,441,485,346,-1,772,1015,711,-1,1015,772,1043,-1,1166,370,327,-1,1166,1060,370,-1,763,711,1015,-1,763,517,711,-1,257,388,267,-1,257,322,388,-1,98,258,121,-1,258,98,243,-1,477,226,164,-1,477,402,226,-1,452,348,504,-1,452,307,348,-1,362,307,452,-1,31,10,22,-1,31,33,10,-1,309,552,306,-1,309,485,552,-1,362,363,287,-1,363,362,462,-1,1079,1047,706,-1,1079,1094,1047,-1,809,947,1079,-1,809,507,947,-1,350,129,468,-1,350,78,129,-1,72,50,78,-1,72,79,50,-1,411,350,796,-1,411,177,350,-1,818,575,1001,-1,575,818,451,-1,1094,1153,1055,-1,1094,1159,1153,-1,677,1138,681,-1,677,1153,1138,-1],
          coord=Coordinate(DEF='c3_Coord',point=[(0,54.99906,-1.11157),(0,54.99443,-1.12548),(-.1021,55.00642,-1.12684),(-.21434,54.23622,-2.09192),(-.19653,54.21913,-2.07998),(-.22055,54.221,-2.06121),(-.028,54.40435,-2.02718),(-.04036,54.32457,-2.03773),(-.06105,54.38005,-2.03629),(-.07429,54.35682,-1.81269),(0,54.34506,-1.85208),(-.07537,54.36398,-1.80183),(-.06005,54.29091,-1.88123),(-.05796,54.28717,-1.89235),(-.05013,54.29607,-1.8835),(-.05997,54.29375,-2.03339),(-.05406,54.27208,-2.01138),(-.09098,54.23529,-2.06549),(-.11992,54.2907,-2.095),(-.16779,54.34026,-1.99331),(-.08748,54.33217,-2.04562),(-.07654,54.25303,-1.95014),(-.12399,54.26739,-1.86164),(-.11617,54.24666,-1.90716),(-.31441,54.42852,-1.62521),(-.30865,54.42857,-1.6259),(-.35955,54.41014,-1.52858),(-.44227,54.3879,-1.38104),(-.48166,54.37554,-1.42107),(-.43511,54.38572,-1.38791),(-.82452,54.62327,-1.25533),(-.79222,54.67027,-1.14862),(-.82766,54.63004,-1.25917),(-.41149,54.42395,-1.32927),(-.41934,54.42205,-1.32587),(-.41475,54.41577,-1.33996),(-.57046,54.62509,-1.15163),(-.57816,54.6292,-1.14335),(-.58088,54.61811,-1.14824),(-.37719,54.42694,-1.41083),(-.39688,54.39795,-1.44334),(-.62844,54.44644,-1.40428),(-.57086,54.40166,-1.4534),(-.58766,54.44114,-1.38625),(-.38238,54.57061,-1.55772),(-.39847,54.57187,-1.5421),(-.43736,54.60203,-1.54406),(-.11826,54.75617,-1.67847),(-.09898,54.7231,-1.68077),(0,54.73719,-1.70114),(-.17708,54.76557,-1.65366),(-.22608,54.73132,-1.62658),(-.16069,54.7278,-1.65535),(-.21799,54.61947,-1.6327),(-.23869,54.52566,-1.63737),(-.19183,54.48927,-1.68496),(-.78125,54.83178,-1.3434),(-.72372,54.80018,-1.38006),(-.72335,54.77052,-1.37883),(-.71917,54.80848,-1.37845),(-.77511,54.83956,-1.34536),(-.71659,54.86948,-1.32711),(-.12462,54.7529,-1.6852),(-.19524,54.78287,-1.6538),(-.44662,54.83158,-1.33552),(-.44059,54.82828,-1.33712),(-.51724,54.7694,-1.37927),(-.80518,54.90158,-1.26141),(-.8005,54.90726,-1.26554),(0,54.73951,-1.70861),(-.40193,54.89063,-1.29092),(-.40971,54.89254,-1.29287),(-.44262,54.95902,-1.22558),(-.39654,54.82568,-1.37585),(-.38808,54.82172,-1.38001),(-.39567,54.82143,-1.38521),(-.43856,54.95998,-1.21917),(-.45217,54.97477,-1.20083),(-.43983,54.93645,-1.21304),(-.78353,54.87203,-1.22975),(-.70726,54.6576,-.98306),(-.78455,54.66892,-1.01123),(-.72816,54.68693,-1.07087),(-.90658,54.62966,-.9477),(-.8779,54.63796,-.98698),(-.82602,54.60876,-.96617),(-.85359,54.62691,-.90596),(-.87626,54.66828,-.88606),(-.90847,54.64476,-.91834),(-.71924,54.80566,-.76022),(-.7409,54.79618,-.80216),(-.70953,54.77417,-.78426),(-.90878,54.83213,-.94695),(-.94518,54.77313,-.95691),(-.90909,54.75357,-.89347),(-.73598,54.87606,-.84502),(-.71447,54.8711,-.86266),(-.75866,54.84726,-.91214),(-.7192,54.94852,-.78983),(-.71669,54.95096,-.80162),(-.68063,54.89653,-.71065),(-.69066,54.90254,-.71412),(-.68661,54.88619,-.71311),(-.71176,54.85697,-1.04971),(-.66573,54.84564,-.98875),(-.60248,54.8435,-1.02911),(-.69861,54.91619,-1.09514),(-.61119,54.94024,-1.0947),(-.55961,54.83736,-.85891),(-.64388,54.83936,-.87825),(-.57131,54.88292,-.85476),(-.61146,54.74797,-.86192),(-.59535,54.75201,-.84015),(-.66802,54.73998,-.82323),(-.52865,54.76411,-.83291),(-.52355,54.81982,-.80208),(-.43,54.74453,-1.0189),(-.45665,54.75101,-1.03844),(-.39237,54.67787,-1.08048),(-.49499,54.88271,-.86491),(-.48254,54.83131,-.86138),(-.50789,54.93415,-.86115),(-.55545,54.88263,-.85543),(0,54.71655,-1.19025),(0,54.68469,-1.18474),(-.0322,54.7165,-1.18241),(-.53477,54.74425,-1.05593),(-.50515,54.67251,-1.11287),(-.46293,54.70026,-1.09289),(-.45998,54.90479,-1.13905),(-.42081,54.85887,-1.174),(-.48002,54.91534,-1.16053),(-.45951,55.00956,-.88313),(-.43406,55.01818,-.93399),(-.44994,54.9606,-.96323),(-.37142,55.0208,-1.06519),(-.38269,54.94117,-1.08034),(-.4315,54.96247,-1.012),(-.45315,54.93771,-1.0313),(-.46691,54.91824,-1.01282),(-.46019,54.92345,-.98211),(-.46914,54.93113,-1.06309),(-.48274,54.92818,-1.0874),(-.48726,54.91137,-1.04355),(-.44289,54.90796,-1.122),(-.26012,55.06112,-1.10833),(-.27551,55.07889,-1.06881),(-.23863,55.04623,-1.06331),(-.39091,54.85485,-1.15115),(-.36932,54.8855,-1.12657),(-.30666,54.83046,-1.147),(-.41782,54.92348,-1.10136),(-.34188,54.92495,-1.11113),(-.22998,54.77169,-1.62351),(-.30163,54.78606,-1.5634),(-.47928,54.53152,-1.23097),(-.51255,54.62779,-1.18609),(-.23825,55.00169,-1.1523),(-.21909,54.94427,-1.16831),(-.26216,54.96426,-1.15788),(-.21779,54.9338,-.74004),(-.23858,54.93585,-.71367),(-.21839,54.91769,-.73005),(0,54.98828,-1.14173),(-.30953,54.54374,-1.15989),(-.33579,54.60405,-1.14743),(-.2978,54.53224,-1.17798),(-.30051,54.59811,-.81061),(-.29202,54.58312,-.79165),(-.29159,54.59269,-.78227),(-.20446,54.7306,-1.1685),(-.25556,54.78053,-1.15775),(-.2509,54.8782,-1.1518),(-.22714,54.63232,-1.19261),(-.31433,54.61903,-1.16828),(-.27193,54.68516,-1.18362),(-.23507,55.0124,-1.14386),(-.234,55.03301,-1.10912),(-.16897,55.01927,-1.12001),(-.259,54.99529,-.75076),(-.31617,55.03957,-.78897),(-.27429,54.99546,-.72576),(-.13077,54.85068,-.65537),(-.12124,54.89153,-.68992),(-.29593,54.97047,-.71541),(-.29274,54.91981,-.71641),(-.26715,54.92119,-.70617),(-.22906,54.63893,-.70959),(-.25627,54.62207,-.7351),(-.24694,54.5759,-.69749),(-.31062,54.90753,-1.1325),(-.29742,55.02883,-.81518),(-.21118,54.95836,-.78208),(-.30832,55.01731,-.8945),(-.29157,55.00761,-.8746),(-.2883,55.00237,-.89681),(-.28751,54.71146,-1.56545),(-.33953,54.71592,-1.48382),(-.33245,54.65751,-1.48014),(0,54.47397,-1.98459),(0,54.40964,-2.02357),(-.03529,54.27804,-1.99237),(0,54.30637,-1.906),(-.26452,54.53412,-1.19592),(-.41052,54.57918,-1.30145),(-.37686,54.63096,-1.37496),(-.39858,54.6802,-1.28079),(-.39046,54.70015,-1.18437),(-.35862,54.73413,-1.21821),(-.33839,54.71752,-1.17059),(-.36707,54.68917,-1.40749),(-.06946,54.55881,-1.21223),(-.14817,54.55307,-1.21004),(-.14311,54.64061,-1.19345),(-.30992,54.5404,-1.55782),(-.33873,54.45474,-1.52065),(-.15305,54.35504,-1.7605),(-.10241,54.47004,-1.75155),(-.29349,54.62319,-1.5693),(-.38447,54.40438,-1.52998),(-.48278,54.40522,-1.50372),(-.49306,54.49398,-1.53845),(-.34971,54.63329,-1.61786),(-.34323,54.56272,-1.61251),(-.47123,54.69824,-1.53519),(-.5317,54.71885,-1.50219),(-.4564,54.75794,-1.43745),(-.40401,54.78084,-1.50688),(-.41253,54.72237,-1.56827),(-.16155,54.45047,-1.88905),(-.10357,54.57263,-1.88099),(-.09392,54.47146,-1.96246),(-.21138,54.36474,-1.88427),(-.20984,54.43075,-1.81784),(-.42014,54.57038,-1.53143),(-.46665,54.57793,-1.54068),(-.67014,54.87009,-1.29727),(-.6246,54.82151,-1.3431),(-.45362,54.97522,-1.2055),(-.58281,54.96281,-1.20192),(-.5469,55.01419,-1.15852),(-.18128,55.01405,-1.00138),(-.26508,55.06896,-1.02013),(-.26779,55.00843,-.92018),(-.28758,55.02185,-.91505),(-.35351,55.05077,-.86192),(-.38023,55.04469,-.83992),(-.33509,55.03141,-.77249),(-.2494,55.0165,-.93726),(-.19918,54.99148,-.91432),(-.12897,55.01492,-1.04961),(-.1341,54.99545,-1.00315),(-.12005,54.89998,-.70192),(-.12128,54.92849,-.77523),(-.0721,55.01058,-1.05916),(-.09735,55.00993,-1.10372),(-.16444,55.02424,-1.08998),(-.39248,55.06638,-.91178),(-.40781,54.88295,-.7939),(-.41384,54.94742,-.79972),(-.48725,54.9494,-.79407),(-.33195,54.93232,-.76405),(-.32588,54.86327,-.76137),(-.21494,54.7862,-.68279),(-.22044,54.8628,-.696),(-.28268,54.86182,-.72157),(-.75175,54.88351,-1.12788),(-.73184,54.72648,-1.37574),(-.77599,54.77127,-1.30885),(-.77731,54.78256,-1.18211),(-.79131,54.70855,-1.28113),(-.76702,54.66032,-1.36457),(-.71865,54.5797,-1.45339),(-.78189,54.75285,-1.17264),(-.78636,54.6782,-1.14199),(-.74239,54.66106,-1.12775),(-.48331,54.75749,-1.05798),(-.49195,54.37985,-1.41516),(-.54689,54.43584,-1.36821),(-.52536,54.45371,-1.33316),(-.48691,54.52584,-1.23149),(-.30396,54.52462,-1.16606),(-.28184,54.50898,-1.18323),(-.27973,54.50462,-1.10888),(-.32917,54.56453,-1.10677),(-.29699,54.58557,-.81961),(-.26606,54.54791,-.84861),(-.32318,54.5547,-1.03108),(-.32152,54.55265,-1.10297),(-.19784,54.49321,-.66393),(-.19562,54.44064,-.68441),(-.18971,54.43122,-.68255),(-.19476,54.58947,-.64808),(-.13375,54.58969,-.61514),(-.12075,54.65461,-.62321),(-.1826,54.64899,-.66824),(-.19663,54.71401,-.67979),(-.23259,54.70273,-.73303),(-.33323,54.63797,-.9189),(-.32282,54.60764,-.92581),(-.63352,54.71356,-1.00659),(-.65829,54.69577,-.94441),(-.37792,54.69272,-.933),(-.37845,54.71485,-.83169),(-.39394,54.80044,-.81736),(-.46399,54.76451,-.83198),(-.57672,54.93994,-.76027),(-.64135,54.93435,-.7108),(-.57347,54.88389,-.76842),(-.64608,54.8866,-.72231),(-.91907,54.7094,-1.01381),(-.89354,54.76346,-1.0189),(-.81705,54.77641,-1.0503),(-.79857,54.82808,-1.04586),(-.84932,54.82625,-1.01165),(-.79752,54.8489,-.9587),(-.55093,54.91342,-1.06893),(-.60404,54.88849,-1.05274),(-.47286,54.76229,-.85412),(-.426,54.74979,-.94481),(-.38581,54.67543,-1.02076),(-.3693,54.78221,-1.47409),(-.32311,54.82315,-1.53857),(.21434,54.23622,-2.09192),(.24619,54.24016,-2.05899),(.22055,54.221,-2.06121),(.07537,54.36398,-1.80183),(0,54.36893,-1.83472),(.04724,54.26896,-1.98853),(.05406,54.27208,-2.01138),(.09098,54.23529,-2.06549),(.05997,54.29375,-2.03339),(.10334,54.26854,-2.08658),(.11617,54.24666,-1.90716),(.12399,54.26739,-1.86164),(.07654,54.25303,-1.95014),(.30865,54.42857,-1.6259),(.31441,54.42852,-1.62521),(.38447,54.40438,-1.52998),(.48691,54.52584,-1.23149),(.47928,54.53152,-1.23097),(.41149,54.42395,-1.32927),(.44227,54.3879,-1.38104),(.43511,54.38572,-1.38791),(.48166,54.37554,-1.42107),(.82766,54.63004,-1.25917),(.79269,54.68275,-1.15032),(.79222,54.67027,-1.14862),(.65395,54.43847,-1.47892),(.65255,54.4338,-1.47237),(.64174,54.43038,-1.48008),(.25414,54.40988,-1.70293),(.24858,54.41018,-1.70186),(.24988,54.40732,-1.70944),(.58766,54.44114,-1.38625),(.62844,54.44644,-1.40428),(.39847,54.57187,-1.5421),(.394,54.63701,-1.57951),(.452,54.63481,-1.54815),(.11826,54.75617,-1.67847),(.17708,54.76557,-1.65366),(.18667,54.7812,-1.64884),(.16069,54.7278,-1.65535),(.22608,54.73132,-1.62658),(.22998,54.77169,-1.62351),(.39439,54.49175,-1.56261),(.41601,54.48811,-1.54086),(.06026,54.71436,-1.74759),(0,54.66318,-1.8215),(.72335,54.77052,-1.37883),(.72372,54.80018,-1.38006),(.78125,54.83178,-1.3434),(.77511,54.83956,-1.34536),(.71917,54.80848,-1.37845),(.67985,54.83879,-1.34297),(.19524,54.78287,-1.6538),(.12462,54.7529,-1.6852),(.44059,54.82828,-1.33712),(.44662,54.83158,-1.33552),(.5214,54.77549,-1.37758),(.8005,54.90726,-1.26554),(.80518,54.90158,-1.26141),(.43856,54.95998,-1.21917),(.44262,54.95902,-1.22558),(.40971,54.89254,-1.29287),(.39567,54.82143,-1.38521),(.38808,54.82172,-1.38001),(.39654,54.82568,-1.37585),(.43983,54.93645,-1.21304),(.45217,54.97477,-1.20083),(.78353,54.87203,-1.22975),(.72816,54.68693,-1.07087),(.78455,54.66892,-1.01123),(.70726,54.6576,-.98306),(.82602,54.60876,-.96617),(.8779,54.63796,-.98698),(.90658,54.62966,-.9477),(.90847,54.64476,-.91834),(.87626,54.66828,-.88606),(.85359,54.62691,-.90596),(.70953,54.77417,-.78426),(.7409,54.79618,-.80216),(.71924,54.80566,-.76022),(.90909,54.75357,-.89347),(.94518,54.77313,-.95691),(.90878,54.83213,-.94695),(.80211,54.83158,-.88874),(.75866,54.84726,-.91214),(.71447,54.8711,-.86266),(.71669,54.95096,-.80162),(.7192,54.94852,-.78983),(.74602,54.86869,-.82328),(.68661,54.88619,-.71311),(.69066,54.90254,-.71412),(.68063,54.89653,-.71065),(.60248,54.8435,-1.02911),(.66573,54.84564,-.98875),(.71176,54.85697,-1.04971),(.61119,54.94024,-1.0947),(.69861,54.91619,-1.09514),(.64388,54.83936,-.87825),(.63043,54.80145,-.87148),(.55961,54.83736,-.85891),(.64547,54.82325,-.98853),(.66607,54.80331,-.93285),(.692,54.85865,-.94177),(.55545,54.88263,-.85543),(.57131,54.88292,-.85476),(.52355,54.81982,-.80208),(.52865,54.76411,-.83291),(.59535,54.75201,-.84015),(.47718,54.89295,-.9976),(.46358,54.83393,-.99828),(.485,54.82704,-1.02907),(.49499,54.88271,-.86491),(.50789,54.93415,-.86115),(.0322,54.7165,-1.18241),(.46293,54.70026,-1.09289),(.50515,54.67251,-1.11287),(.53477,54.74425,-1.05593),(.48002,54.91534,-1.16053),(.42081,54.85887,-1.174),(.45998,54.90479,-1.13905),(.45951,55.00956,-.88313),(.46474,54.94669,-.91586),(.44994,54.9606,-.96323),(.4315,54.96247,-1.012),(.38269,54.94117,-1.08034),(.37142,55.0208,-1.06519),(.46019,54.92345,-.98211),(.46691,54.91824,-1.01282),(.45315,54.93771,-1.0313),(.51003,54.91663,-1.06094),(.48274,54.92818,-1.0874),(.46914,54.93113,-1.06309),(.50082,54.92958,-1.10432),(.23863,55.04623,-1.06331),(.27551,55.07889,-1.06881),(.26012,55.06112,-1.10833),(.35576,54.80481,-1.163),(.30666,54.83046,-1.147),(.36932,54.8855,-1.12657),(.41782,54.92348,-1.10136),(.29118,54.74728,-1.56348),(.51255,54.62779,-1.18609),(.57046,54.62509,-1.15163),(.26131,55.01505,-1.15558),(.26216,54.96426,-1.15788),(.21909,54.94427,-1.16831),(.21839,54.91769,-.73005),(.23858,54.93585,-.71367),(.21779,54.9338,-.74004),(.1021,55.00642,-1.12684),(.2978,54.53224,-1.17798),(.31433,54.61903,-1.16828),(.30953,54.54374,-1.15989),(.29159,54.59269,-.78227),(.29699,54.58557,-.81961),(.30051,54.59811,-.81061),(.20541,54.85482,-1.17214),(.2509,54.8782,-1.1518),(.25556,54.78053,-1.15775),(.27193,54.68516,-1.18362),(.22714,54.63232,-1.19261),(.16897,55.01927,-1.12001),(.234,55.03301,-1.10912),(.23507,55.0124,-1.14386),(.27429,54.99546,-.72576),(.31617,55.03957,-.78897),(.259,54.99529,-.75076),(.12124,54.89153,-.68992),(.13077,54.85068,-.65537),(.26715,54.92119,-.70617),(.29274,54.91981,-.71641),(.29593,54.97047,-.71541),(.24694,54.5759,-.69749),(.25627,54.62207,-.7351),(.22906,54.63893,-.70959),(.31062,54.90753,-1.1325),(.21118,54.95836,-.78208),(.29742,55.02883,-.81518),(.2883,55.00237,-.89681),(.29157,55.00761,-.8746),(.30832,55.01731,-.8945),(.13071,54.64549,-1.80837),(0,54.30568,-1.98101),(.03529,54.27804,-1.99237),(.10357,54.57263,-1.88099),(0,54.58135,-1.89207),(.26452,54.53412,-1.19592),(.43965,54.65445,-1.22013),(.39046,54.70015,-1.18437),(.39858,54.6802,-1.28079),(.41052,54.57918,-1.30145),(.37686,54.63096,-1.37496),(.33953,54.71592,-1.48382),(.33245,54.65751,-1.48014),(.36707,54.68917,-1.40749),(.06355,54.63954,-1.18207),(.14311,54.64061,-1.19345),(.14817,54.55307,-1.21004),(.06439,54.71646,-1.17456),(.03783,54.79829,-1.1805),(0,54.89303,-1.17219),(.08428,54.90036,-1.17145),(0,54.846,-1.17889),(.30992,54.5404,-1.55782),(.23869,54.52566,-1.63737),(.19183,54.48927,-1.68496),(.10241,54.47004,-1.75155),(.49306,54.49398,-1.53845),(.38238,54.57061,-1.55772),(.33872,54.50115,-1.61866),(.34323,54.56272,-1.61251),(.34971,54.63329,-1.61786),(.4564,54.75794,-1.43745),(.5317,54.71885,-1.50219),(.47123,54.69824,-1.53519),(.40401,54.78084,-1.50688),(.17243,54.56351,-1.81339),(.18542,54.70437,-1.71443),(.20711,54.64836,-1.73639),(.16307,54.38411,-1.95562),(.16155,54.45047,-1.88905),(.20984,54.43075,-1.81784),(.21138,54.36474,-1.88427),(.40954,54.87856,-1.30837),(.51724,54.7694,-1.37927),(.62243,54.87242,-1.26846),(.48637,54.87103,-1.27117),(.51441,54.90618,-1.23314),(.6246,54.82151,-1.3431),(.71659,54.86948,-1.32711),(.45362,54.97522,-1.2055),(.5469,55.01419,-1.15852),(.58281,54.96281,-1.20192),(.19918,54.99148,-.91432),(.2494,55.0165,-.93726),(.18128,55.01405,-1.00138),(.1341,54.99545,-1.00315),(.12897,55.01492,-1.04961),(.12128,54.92849,-.77523),(.12005,54.89998,-.70192),(.16444,55.02424,-1.08998),(.09735,55.00993,-1.10372),(.39248,55.06638,-.91178),(.39443,55.04183,-.84195),(.40781,54.88295,-.7939),(.48475,54.87898,-.79906),(.48725,54.9494,-.79407),(.28268,54.86182,-.72157),(.32588,54.86327,-.76137),(.22044,54.8628,-.696),(.21494,54.7862,-.68279),(.25822,54.78249,-.72965),(.75175,54.88351,-1.12788),(.77599,54.77127,-1.30885),(.73184,54.72648,-1.37574),(.71865,54.5797,-1.45339),(.67554,54.68069,-1.43298),(.56735,54.40054,-1.46303),(.49328,54.3798,-1.42706),(.56942,54.41641,-1.49426),(.78189,54.75285,-1.17264),(.79131,54.70855,-1.28113),(.77731,54.78256,-1.18211),(.74239,54.66106,-1.12775),(.77024,54.71702,-1.08336),(.47878,54.65453,-1.16829),(.53241,54.49251,-1.27638),(.41934,54.42205,-1.32587),(.27973,54.50462,-1.10888),(.28184,54.50898,-1.18323),(.30396,54.52462,-1.16606),(.1301,54.48078,-1.06893),(.22132,54.49378,-1.06183),(.2211,54.49811,-.96745),(.32917,54.56453,-1.10677),(.33579,54.60405,-1.14743),(.25087,54.5162,-.78142),(.27724,54.55982,-.75472),(.24276,54.50067,-.71743),(.32152,54.55265,-1.10297),(.32318,54.5547,-1.03108),(.19784,54.49321,-.66393),(.13725,54.50229,-.62794),(.14146,54.43077,-.64684),(.27728,54.56978,-.7449),(.24224,54.50891,-.70603),(.12075,54.65461,-.62321),(.13375,54.58969,-.61514),(.19476,54.58947,-.64808),(.23259,54.70273,-.73303),(.19663,54.71401,-.67979),(.1826,54.64899,-.66824),(.29407,54.68838,-.78145),(.32282,54.60764,-.92581),(.33323,54.63797,-.9189),(.65829,54.69577,-.94441),(.63352,54.71356,-1.00659),(.37845,54.71485,-.83169),(.37792,54.69272,-.933),(.46399,54.76451,-.83198),(.39394,54.80044,-.81736),(.57347,54.88389,-.76842),(.64135,54.93435,-.7108),(.57672,54.93994,-.76027),(.64608,54.8866,-.72231),(.91907,54.7094,-1.01381),(.83136,54.72997,-1.04014),(.81705,54.77641,-1.0503),(.79752,54.8489,-.9587),(.84932,54.82625,-1.01165),(.79857,54.82808,-1.04586),(.60404,54.88849,-1.05274),(.55093,54.91342,-1.06893),(.426,54.74979,-.94481),(.47286,54.76229,-.85412),(.3693,54.78221,-1.47409),(.36991,54.8203,-1.45469),(.32311,54.82315,-1.53857),(.33839,54.71752,-1.17059),(.32111,54.76142,-1.16888),(.3913,54.84081,-1.31014),(.39353,54.86853,-1.3022),(.24209,54.80322,-1.61497),(.30163,54.78606,-1.5634),(.43,54.74453,-1.0189),(.46293,54.904,-.93249),(.68573,54.91909,-.84564),(.68163,54.98241,-.78756),(.67825,54.98173,-.76821),(.74436,54.80954,-.80404),(.80082,54.79141,-.8536),(.96482,54.70806,-.95851),(.7788,54.78308,-1.10068),(.8964,54.71371,-.88147),(.78882,54.69922,-.85048),(.71296,54.81146,-.75386),(.69678,54.81153,-.75833),(.5782,54.82187,-.79077),(.65273,54.80694,-.77734),(.47211,54.81402,-.81473),(.7452,54.67552,-.8915),(.84327,54.60885,-.92977),(.58623,54.731,-1.05388),(.57816,54.6292,-1.14335),(.68997,54.64165,-1.11129),(.12736,54.72531,-.6296),(.06489,54.65635,-.60178),(.06677,54.58708,-.60117),(.19562,54.44064,-.68441),(.23476,54.49746,-.7007),(.3157,54.59481,-.9249),(.27477,54.5425,-.94499),(.23482,54.49072,-.71265),(.19492,54.43265,-.69547),(.19292,54.4435,-.74566),(.26606,54.54791,-.84861),(.19214,54.46786,-.8081),(.27317,54.5196,-1.04171),(.13371,54.39667,-.77183),(.13244,54.37708,-.68495),(.18971,54.43122,-.68255),(.68451,54.58531,-1.18891),(.60877,54.55935,-1.2195),(.6336,54.53535,-1.27327),(.44472,54.55269,-1.26556),(.76319,54.8256,-1.10605),(.75518,54.48675,-1.43979),(.64619,54.53476,-1.50158),(.48278,54.40522,-1.50372),(.77249,54.83798,-1.20293),(.66282,54.7796,-1.40393),(.43406,55.01818,-.93399),(.36187,55.08938,-.96843),(.34646,55.00629,-1.10435),(.33178,55.09813,-1.03948),(.44289,54.90796,-1.122),(.05261,54.89726,-.68475),(.05231,54.9185,-.76796),(.24521,54.99481,-.90637),(.27288,54.99084,-.87446),(.33509,55.03141,-.77249),(.28551,55.06069,-.94839),(.70132,54.99873,-1.13407),(.77784,54.96295,-1.1775),(.70242,54.93641,-1.23919),(.63534,55.01832,-1.12697),(.50664,54.82484,-1.3147),(.65521,54.78685,-1.40058),(.66199,54.94723,-1.20986),(.59757,54.62382,-1.51505),(.5106,54.58661,-1.54138),(.30641,54.61799,-1.6657),(.28853,54.71251,-1.65842),(.33522,54.78305,-1.57969),(.32818,54.82179,-1.54253),(.41253,54.72237,-1.56827),(.43736,54.60203,-1.54406),(.42014,54.57038,-1.53143),(.2393,54.53348,-1.74356),(.25073,54.4565,-1.7302),(.46665,54.57793,-1.54068),(.41936,54.52868,-1.54042),(.05013,54.29607,-1.8835),(.07429,54.35682,-1.81269),(.27932,54.42212,-1.66282),(.37719,54.42694,-1.41083),(.41475,54.41577,-1.33996),(.37453,54.50153,-1.39047),(.14019,54.47349,-1.21683),(.07073,54.47229,-1.20723),(.06946,54.55881,-1.21223),(.37013,54.72433,-1.31116),(.35862,54.73413,-1.21821),(.27985,54.51685,-1.19111),(.09392,54.47146,-1.96246),(.16779,54.34026,-1.99331),(.13794,54.74639,-1.69479),(.34188,54.92495,-1.11113),(.31261,54.98766,-1.14566),(.41768,54.98855,-.80344),(.41384,54.94742,-.79972),(.25385,55.02326,-1.1485),(0,54.46706,-1.20009),(0,54.48204,-1.20597),(.36222,54.68722,-1.14813),(.38023,55.04469,-.83992),(.39103,55.03782,-.83403),(.28709,55.05651,-1.13562),(.3396,55.01926,-.76743),(.29074,54.98391,-.71796),(.23825,55.00169,-1.1523),(.382,54.67869,-1.11415),(.39237,54.67787,-1.08048),(.35235,54.75067,-1.48309),(.36871,54.75293,-1.41072),(.3842,54.78844,-1.39364),(.54501,54.93946,-1.11976),(.41811,54.8973,-1.20885),(.29796,55.04915,-1.14024),(.31675,55.07332,-1.09177),(.39091,54.85485,-1.15115),(.37096,54.81007,-1.1884),(.38581,54.67543,-1.02076),(.51041,54.8167,-1.04169),(.45665,54.75101,-1.03844),(.53096,54.88155,-.78571),(.53354,54.76465,-.85017),(.75485,54.85737,-1.00268),(.56593,54.8616,-1.0323),(.68607,54.65683,-1.05838),(.80762,54.82158,-.87941),(.58653,54.9652,-.79156),(.59023,54.96365,-.80319),(.66269,54.86899,-.87274),(.89354,54.76346,-1.0189),(.89785,54.8431,-.96731),(.95325,54.67504,-.9762),(.96048,54.67794,-.95655),(.40193,54.89063,-1.29092),(.24379,54.8025,-1.61965),(.6523,54.77636,-1.40539),(.1518,54.61578,-1.67311),(.21799,54.61947,-1.6327),(.21976,54.69992,-1.6324),(.42921,54.38539,-1.47557),(.78636,54.6782,-1.14199),(.69233,54.63155,-1.11824),(.58088,54.61811,-1.14824),(.19961,54.30929,-2.04651),(.20594,54.32902,-1.95016),(.18932,54.25453,-2.11825),(.18342,54.24145,-2.11141),(.13826,54.25454,-2.11372),(.05796,54.28717,-1.89235),(.03963,54.28751,-2.01234),(.08052,54.35339,-1.80585),(.06005,54.29091,-1.88123),(.15305,54.35504,-1.7605),(.15378,54.34963,-1.7711),(.04036,54.32457,-2.03773),(.06105,54.38005,-2.03629),(.08748,54.33217,-2.04562),(.22521,54.26117,-2.09534),(.17752,54.22838,-2.10457),(-.26131,55.01505,-1.15558),(-.31261,54.98766,-1.14566),(-.32111,54.76142,-1.16888),(-.39353,54.86853,-1.3022),(-.3913,54.84081,-1.31014),(-.36991,54.8203,-1.45469),(-.24209,54.80322,-1.61497),(-.44436,54.82944,-.94093),(-.46358,54.83393,-.99828),(-.58186,54.92203,-.84165),(-.66269,54.86899,-.87274),(-.46293,54.904,-.93249),(-.68163,54.98241,-.78756),(-.68573,54.91909,-.84564),(-.67825,54.98173,-.76821),(-.80762,54.82158,-.87941),(-.80082,54.79141,-.8536),(-.74436,54.80954,-.80404),(-.96482,54.70806,-.95851),(-.83136,54.72997,-1.04014),(-.7788,54.78308,-1.10068),(-.78882,54.69922,-.85048),(-.79653,54.77838,-.84902),(-.8964,54.71371,-.88147),(-.71296,54.81146,-.75386),(-.5782,54.82187,-.79077),(-.29407,54.68838,-.78145),(-.7452,54.67552,-.8915),(-.68997,54.64165,-1.11129),(-.58623,54.731,-1.05388),(-.68607,54.65683,-1.05838),(-.12736,54.72531,-.6296),(-.13009,54.78862,-.63854),(-.06677,54.58708,-.60117),(-.06489,54.65635,-.60178),(-.27317,54.5196,-1.04171),(-.27477,54.5425,-.94499),(-.3157,54.59481,-.9249),(-.19214,54.46786,-.8081),(-.25087,54.5162,-.78142),(-.22132,54.49378,-1.06183),(-.3311,54.56654,-1.03325),(-.13371,54.39667,-.77183),(-.19292,54.4435,-.74566),(-.14146,54.43077,-.64684),(-.13244,54.37708,-.68495),(-.6336,54.53535,-1.27327),(-.60877,54.55935,-1.2195),(-.68451,54.58531,-1.18891),(-.43965,54.65445,-1.22013),(-.44472,54.55269,-1.26556),(-.76319,54.8256,-1.10605),(-.75518,54.48675,-1.43979),(-.64619,54.53476,-1.50158),(-.56942,54.41641,-1.49426),(-.59757,54.62382,-1.51505),(-.77596,54.80499,-1.32675),(-.77249,54.83798,-1.20293),(-.66282,54.7796,-1.40393),(-.67554,54.68069,-1.43298),(-.69608,54.956,-1.11931),(-.41768,54.98855,-.80344),(-.39103,55.03782,-.83403),(-.45539,55.00916,-.83837),(-.40729,55.01442,-.99037),(-.33178,55.09813,-1.03948),(-.31675,55.07332,-1.09177),(-.27288,54.99084,-.87446),(-.28551,55.06069,-.94839),(-.77784,54.96295,-1.1775),(-.70132,54.99873,-1.13407),(-.66199,54.94723,-1.20986),(-.63534,55.01832,-1.12697),(-.50664,54.82484,-1.3147),(-.5214,54.77549,-1.37758),(-.65521,54.78685,-1.40058),(-.67985,54.83879,-1.34297),(-.70242,54.93641,-1.23919),(-.28853,54.71251,-1.65842),(-.30641,54.61799,-1.6657),(-.37707,54.81928,-1.4568),(-.32818,54.82179,-1.54253),(-.6523,54.77636,-1.40539),(-.33522,54.78305,-1.57969),(-.33872,54.50115,-1.61866),(-.15378,54.34963,-1.7711),(-.20895,54.35129,-1.79523),(-.21425,54.31475,-1.86174),(0,54.43726,-1.79491),(-.24858,54.41018,-1.70186),(-.38942,54.45535,-1.36299),(-.20541,54.85482,-1.17214),(-.14339,54.80508,-1.16904),(-.07073,54.47229,-1.20723),(-.36222,54.68722,-1.14813),(-.382,54.67869,-1.11415),(-.37013,54.72433,-1.31116),(-.13071,54.64549,-1.80837),(-.16307,54.38411,-1.95562),(-.13794,54.74639,-1.69479),(-.06026,54.71436,-1.74759),(-.18542,54.70437,-1.71443),(-.24521,54.99481,-.90637),(-.32539,55.03648,-.89059),(-.34646,55.00629,-1.10435),(-.35576,54.80481,-1.163),(-.25385,55.02326,-1.1485),(-.28332,55.05716,-1.13181),(-.06996,54.4641,-1.1991),(-.22797,54.53394,-1.20573),(-.29419,55.04979,-1.13643),(-.39443,55.04183,-.84195),(-.38037,55.07068,-.90787),(-.29074,54.98391,-.71796),(-.29118,54.74728,-1.56348),(-.35235,54.75067,-1.48309),(-.3842,54.78844,-1.39364),(-.37793,54.78749,-1.31536),(-.50082,54.92958,-1.10432),(-.54501,54.93946,-1.11976),(-.41811,54.8973,-1.20885),(-.36564,54.74916,-1.31741),(-.36305,54.75602,-1.21741),(-.34613,54.75735,-1.17745),(-.46474,54.94669,-.91586),(-.37096,54.81007,-1.1884),(-.485,54.82704,-1.02907),(-.53096,54.88155,-.78571),(-.66607,54.80331,-.93285),(-.692,54.85865,-.94177),(-.75485,54.85737,-1.00268),(-.56593,54.8616,-1.0323),(-.74602,54.86869,-.82328),(-.80211,54.83158,-.88874),(-.58653,54.9652,-.79156),(-.89785,54.8431,-.96731),(-.96048,54.67794,-.95655),(-.95325,54.67504,-.9762),(-.40954,54.87856,-1.30837),(-.24379,54.8025,-1.61965),(-.21976,54.69992,-1.6324),(-.1518,54.61578,-1.67311),(-.15309,54.69558,-1.65925),(-.64174,54.43038,-1.48008),(-.56735,54.40054,-1.46303),(-.42921,54.38539,-1.47557),(-.79269,54.68275,-1.15032),(-.69233,54.63155,-1.11824),(-.20594,54.32902,-1.95016),(-.23758,54.30932,-2.00574),(-.18932,54.25453,-2.11825),(-.15122,54.27554,-2.11912),(-.13826,54.25454,-2.11372),(-.04724,54.26896,-1.98853),(-.08052,54.35339,-1.80585),(-.22521,54.26117,-2.09534),(-.17752,54.22838,-2.10457),(-.18342,54.24145,-2.11141),(-.03963,54.28751,-2.01234),(-.19961,54.30929,-2.04651),(-.49328,54.3798,-1.42706),(-.41936,54.52868,-1.54042),(-.452,54.63481,-1.54815),(-.5106,54.58661,-1.54138),(-.41601,54.48811,-1.54086),(-.27932,54.42212,-1.66282),(-.93431,54.77098,-.97979),(-.59023,54.96365,-.80319),(-.72187,54.81935,-.75939),(-.64547,54.82325,-.98853),(-.51041,54.8167,-1.04169),(-.38617,54.81534,-1.21381),(-.36871,54.75293,-1.41072),(-.34136,54.6167,-1.1009),(-.3396,55.01926,-.76743),(-.49164,54.96043,-.79964),(-.27985,54.51685,-1.19111),(-.14019,54.47349,-1.21683),(-.13974,54.71984,-1.17726),(-.37453,54.50153,-1.39047),(-.39439,54.49175,-1.56261),(-.25073,54.4565,-1.7302),(-.2393,54.53348,-1.74356),(-.35285,54.72138,-1.61555),(-.73193,54.89815,-1.29452),(-.54625,54.81065,-1.33531),(-.36187,55.08938,-.96843),(-.76614,54.92146,-1.15651),(-.65395,54.43847,-1.47892),(-.72519,54.59753,-1.19884),(-.13471,54.44611,-.82965),(-.34237,54.62414,-1.01568),(-.2211,54.49811,-.96745),(-.21329,54.4922,-.89871),(-.19492,54.43265,-.69547),(-.23482,54.49072,-.71265),(-.23476,54.49746,-.7007),(-.84327,54.60885,-.92977),(-.47211,54.81402,-.81473),(-.65273,54.80694,-.77734),(-.69678,54.81153,-.75833),(-.78066,54.74644,-1.09125),(-.64713,54.94546,-.71349),(.19653,54.21913,-2.07998),(.15122,54.27554,-2.11912),(.23758,54.30932,-2.00574),(.49195,54.37985,-1.41516),(.33873,54.45474,-1.52065),(.35955,54.41014,-1.52858),(.15309,54.69558,-1.65925),(.93431,54.77098,-.97979),(.73598,54.87606,-.84502),(.72187,54.81935,-.75939),(.48331,54.75749,-1.05798),(.34613,54.75735,-1.17745),(.38617,54.81534,-1.21381),(.37793,54.78749,-1.31536),(.28751,54.71146,-1.56545),(.34136,54.6167,-1.1009),(.38942,54.45535,-1.36299),(.22797,54.53394,-1.20573),(.06996,54.4641,-1.1991),(.49164,54.96043,-.79964),(.28758,55.02185,-.91505),(.26779,55.00843,-.92018),(.35285,54.72138,-1.61555),(.37707,54.81928,-1.4568),(.54625,54.81065,-1.33531),(.26508,55.06896,-1.02013),(.40729,55.01442,-.99037),(.77596,54.80499,-1.32675),(.76702,54.66032,-1.36457),(.52536,54.45371,-1.33316),(.72519,54.59753,-1.19884),(.13471,54.44611,-.82965),(.34237,54.62414,-1.01568),(.3311,54.56654,-1.03325),(.21329,54.4922,-.89871),(.13009,54.78862,-.63854),(.66802,54.73998,-.82323),(.79653,54.77838,-.84902),(.78066,54.74644,-1.09125),(.64713,54.94546,-.71349),(.44436,54.82944,-.94093),(.88414,54.84779,-.9568),(.29202,54.58312,-.79165),(.1337,54.47404,-.99003),(.74302,54.65095,-1.1341),(.68717,54.48602,-1.38095),(.33195,54.93232,-.76405),(.34892,55.02465,-.77171),(.0721,55.01058,-1.05916),(.25294,54.98181,-.8468),(.20161,54.97792,-.85812),(.67014,54.87009,-1.29727),(.27286,54.57573,-1.70463),(.2712,54.54054,-1.70127),(.07566,54.79822,-1.17094),(.35855,54.7247,-1.41197),(.028,54.40435,-2.02718),(.35351,55.05077,-.86192),(.35288,55.06356,-.89513),(.32539,55.03648,-.89059),(.1743,55.00289,-1.13678),(.20446,54.7306,-1.1685),(.10628,54.99586,-1.13847),(.48726,54.91137,-1.04355),(0,54.79836,-1.19006),(.55746,54.92307,-.84291),(.45539,55.00916,-.83837),(.48254,54.83131,-.86138),(.50166,54.88435,-1.02477),(.61146,54.74797,-.86192),(.47079,54.94547,-1.18889),(.09898,54.7231,-1.68077),(.57086,54.40166,-1.4534),(.82452,54.62327,-1.25533),(-.88414,54.84779,-.9568),(-.24224,54.50891,-.70603),(-.27728,54.56978,-.7449),(-.24276,54.50067,-.71743),(-.27724,54.55982,-.75472),(-.74302,54.65095,-1.1341),(-.53241,54.49251,-1.27638),(-.72943,54.57011,-1.26021),(-.72363,54.53477,-1.32601),(-.47878,54.65453,-1.16829),(-.77024,54.71702,-1.08336),(-.25822,54.78249,-.72965),(-.48475,54.87898,-.79906),(-.34892,55.02465,-.77171),(-.20161,54.97792,-.85812),(-.25294,54.98181,-.8468),(-.51441,54.90618,-1.23314),(-.48637,54.87103,-1.27117),(-.17243,54.56351,-1.81339),(-.394,54.63701,-1.57951),(-.2712,54.54054,-1.70127),(-.27286,54.57573,-1.70463),(-.03783,54.79829,-1.1805),(-.07566,54.79822,-1.17094),(-.08428,54.90036,-1.17145),(-.06355,54.63954,-1.18207),(-.06439,54.71646,-1.17456),(-.35855,54.7247,-1.41197),(-.35288,55.06356,-.89513),(-.1743,55.00289,-1.13678),(-.10628,54.99586,-1.13847),(-.51003,54.91663,-1.06094),(-.55746,54.92307,-.84291),(-.63043,54.80145,-.87148),(-.47079,54.94547,-1.18889),(-.18667,54.7812,-1.64884),(-.65255,54.4338,-1.47237),(-.24988,54.40732,-1.70944),(-.25414,54.40988,-1.70293),(-.10334,54.26854,-2.08658),(-.24619,54.24016,-2.05899),(-.12526,54.22071,-2.02266),(-.12881,54.22774,-2.09601),(-.18814,54.20977,-2.02547),(-.15675,54.21223,-2.06071),(-.24111,54.27708,-1.97717),(-.16403,54.21883,-1.98074),(-.25001,54.25594,-2.01984),(-.20614,54.29451,-1.91097),(-.80931,54.55796,-1.34308),(-.7529,54.48184,-1.43544),(-.8115,54.56302,-1.34788),(-.28442,54.42113,-1.66558),(-.27469,54.47357,-1.69909),(-.29864,54.49063,-1.66799),(-.30309,54.54761,-1.65899),(-.26279,54.76788,-1.63642),(-.62243,54.87242,-1.26846),(-.70328,54.99599,-1.12744),(-.78073,54.95932,-1.17101),(-.82038,54.70146,-1.03439),(-.91945,54.67899,-1.0073),(-.5318,54.94146,-.78286),(-.53513,54.95283,-.78805),(-.54871,54.96199,-.81398),(-.54411,54.96362,-.80352),(-.50542,54.97133,-.81826),(-.50927,54.9686,-.82833),(-.55007,54.80252,-1.04192),(-.47718,54.89295,-.9976),(-.50166,54.88435,-1.02477),(-.5476,54.97523,-1.14528),(-.62618,54.97764,-1.11631),(-.42695,54.69558,-1.14096),(0,54.8945,-.67654),(-.05343,54.88952,-.67255),(0,54.88636,-.66498),(-.05261,54.89726,-.68475),(-.35068,55.09394,-.96409),(-.17683,54.9907,-1.14443),(-.22348,54.48404,-1.21062),(-.05919,54.37737,-.67023),(0,54.43389,-.62725),(-.07241,54.43524,-.62391),(0,54.3786,-.67445),(-.0592,54.37088,-.71501),(-.13379,54.3734,-.71645),(-.29089,55.09667,-1.02929),(-.31796,55.08775,-.95317),(-.22144,54.74721,-1.6727),(0,54.56086,-1.2102),(0,54.65223,-1.18369),(-.34589,54.58294,-1.45279),(-.09115,54.69166,-1.68447),(-.08572,54.61041,-1.70842),(-.20711,54.64836,-1.73639),(-.24782,54.68044,-1.6974),(-.30569,55.07951,-1.08831),(-.32052,55.10315,-1.03718),(-.07167,54.98768,-1.00034),(-.13401,54.96466,-.92299),(-.06407,54.95928,-.92288),(-.05938,54.84604,-.63744),(-.05838,54.93962,-.85018),(0,54.95446,-.92526),(0,54.93541,-.84515),(0,54.7875,-.61458),(-.0618,54.78723,-.61882),(0,54.84725,-.63457),(-.68717,54.48602,-1.38095),(-.1337,54.47404,-.99003),(-.1301,54.48078,-1.06893),(-.06763,54.44255,-.83507),(-.06765,54.39163,-.78292),(0,54.39064,-.78433),(0,54.36999,-.71913),(0,54.482,-1.08627),(-.05869,54.46722,-1.00181),(-.06252,54.4761,-1.08009),(0,54.47195,-1.00782),(-.0637,54.46362,-1.1451),(0,54.46757,-1.1445),(-.06657,54.50118,-.60954),(-.13725,54.50229,-.62794),(-.06372,54.73315,-.6096),(-.58083,54.95102,-.76464),(0,54.69145,-1.70181),(0,54.31764,-2.0069),(.15675,54.21223,-2.06071),(.12881,54.22774,-2.09601),(.21586,54.29134,-2.08024),(.25001,54.25594,-2.01984),(.24425,54.25791,-2.07472),(.24656,54.28745,-2.04776),(.11992,54.2907,-2.095),(.20614,54.29451,-1.91097),(.24111,54.27708,-1.97717),(.39688,54.39795,-1.44334),(.29864,54.49063,-1.66799),(.28442,54.42113,-1.66558),(.22144,54.74721,-1.6727),(.24782,54.68044,-1.6974),(.26279,54.76788,-1.63642),(.70328,54.99599,-1.12744),(.78073,54.95932,-1.17101),(.69608,54.956,-1.11931),(.76614,54.92146,-1.15651),(.82038,54.70146,-1.03439),(.91945,54.67899,-1.0073),(.5318,54.94146,-.78286),(.53513,54.95283,-.78805),(.54871,54.96199,-.81398),(.54411,54.96362,-.80352),(.59408,54.78685,-1.0393),(.63747,54.76821,-.99524),(.50542,54.97133,-.81826),(.50927,54.9686,-.82833),(.55007,54.80252,-1.04192),(.36305,54.75602,-1.21741),(.5476,54.97523,-1.14528),(.62618,54.97764,-1.11631),(.42695,54.69558,-1.14096),(.05343,54.88952,-.67255),(.38037,55.07068,-.90787),(.35068,55.09394,-.96409),(.17683,54.9907,-1.14443),(.22348,54.48404,-1.21062),(.05919,54.37737,-.67023),(.07241,54.43524,-.62391),(.0592,54.37088,-.71501),(.13379,54.3734,-.71645),(.29089,55.09667,-1.02929),(.31796,55.08775,-.95317),(.29349,54.62319,-1.5693),(.65994,54.74972,-.93878),(.13974,54.71984,-1.17726),(.14339,54.80508,-1.16904),(.34589,54.58294,-1.45279),(.08572,54.61041,-1.70842),(0,54.55391,-1.74865),(.09115,54.69166,-1.68447),(.20895,54.35129,-1.79523),(.21425,54.31475,-1.86174),(.27469,54.47357,-1.69909),(.13401,54.96466,-.92299),(.07167,54.98768,-1.00034),(.06407,54.95928,-.92288),(.05938,54.84604,-.63744),(.05838,54.93962,-.85018),(.0618,54.78723,-.61882),(.72363,54.53477,-1.32601),(.72943,54.57011,-1.26021),(.7529,54.48184,-1.43544),(.80931,54.55796,-1.34308),(.54689,54.43584,-1.36821),(.06012,54.457,-.92127),(.05869,54.46722,-1.00181),(.13435,54.46399,-.91158),(0,54.44417,-.84302),(.06763,54.44255,-.83507),(0,54.46112,-.92838),(.0637,54.46362,-1.1451),(.13249,54.4674,-1.14964),(.06252,54.4761,-1.08009),(.13931,54.46637,-1.20986),(.21834,54.47397,-1.14193),(.22507,54.47648,-1.20314),(.06657,54.50118,-.60954),(0,54.50082,-.60693),(0,54.65505,-.59493),(0,54.58337,-.59664),(.06372,54.73315,-.6096),(.58083,54.95102,-.76464),(.52937,54.87969,-1.03548),(.31077,54.77765,-.77566),(.06765,54.39163,-.78292),(0,54.91834,-.76364),(0,54.99992,-1.06566),(.13244,54.95428,-.8587),(.32052,55.10315,-1.03718),(.73193,54.89815,-1.29452),(.15073,54.9136,-1.16414),(0,54.34274,-2.02972),(.36564,54.74916,-1.31741),(.30569,55.07951,-1.08831),(.58186,54.92203,-.84165),(.5443,55.01286,-1.153),(.63374,55.01689,-1.1207),(.30309,54.54761,-1.65899),(.16403,54.21883,-1.98074),(.12526,54.22071,-2.02266),(.18814,54.20977,-2.02547),(-.52937,54.87969,-1.03548),(-.59408,54.78685,-1.0393),(-.31077,54.77765,-.77566),(0,54.73696,-.60499),(-.13249,54.4674,-1.14964),(-.13931,54.46637,-1.20986),(-.05231,54.9185,-.76796),(-.13244,54.95428,-.8587),(-.15073,54.9136,-1.16414),(-.22507,54.47648,-1.20314),(-.10627,54.9835,-1.14617),(-.63747,54.76821,-.99524),(-.5443,55.01286,-1.153),(-.63374,55.01689,-1.1207),(-.24656,54.28745,-2.04776),(-.21586,54.29134,-2.08024),(-.24425,54.25791,-2.07472),(-.95553,54.70221,-.98274),(-.65994,54.74972,-.93878),(-.53354,54.76465,-.85017),(0,54.9748,-1.1512),(0,54.97937,-.99405),(-.13435,54.46399,-.91158),(-.06012,54.457,-.92127),(-.21834,54.47397,-1.14193),(.8115,54.56302,-1.34788),(.95553,54.70221,-.98274),(.10627,54.9835,-1.14617)]),
          normal=Normal(vector=[(-.9992,.0385,-.0111),(-.9969,.0544,-.0566),(-.9951,.0986,-.0085),(-.9933,.0835,-.0796),(-.9912,.0018,.1323),(-.9895,.0737,.1246),(-.9881,.147,.046),(-.9856,.0588,.1587),(-.9804,.1887,.0563),(-.9798,-.0468,-.1945),(-.9792,.1988,.0402),(-.9703,-.2312,-.0707),(-.9697,.1862,.158),(-.9665,-.0745,.2457),(-.9633,.2525,-.091),(-.9628,.2702,.0069),(-.96,.2798,-.011),(-.9569,-.2807,.074),(-.9561,-.1931,.2202),(-.9543,-.0021,-.2989),(-.9483,.2427,-.2045),(-.9472,-.082,-.3101),(-.9461,.0357,.3219),(-.9419,-.0862,.3247),(-.9395,-.2648,-.2175),(-.9384,-.2513,.237),(-.9353,.2795,-.2172),(-.9348,.3468,.0765),(-.9328,-.2546,-.2551),(-.9277,.2684,-.2597),(-.9268,-.061,.3705),(-.9267,-.152,-.3438),(-.9254,-.0485,.3759),(-.9241,.1922,-.3303),(-.9222,-.3819,-.0609),(-.9203,.3872,.0556),(-.9187,-.0776,.3871),(-.9184,.1156,.3783),(-.9134,-.3975,.0882),(-.9113,.1326,-.3897),(-.9112,-.2475,-.3292),(-.9096,-.2892,.2983),(-.9092,-.3901,.1457),(-.9084,.4176,-.0211),(-.9071,-.3974,.1388),(-.906,-.0255,.4225),(-.9059,.0369,.422),(-.9055,.1863,.3813),(-.9019,.2265,-.3678),(-.9019,-.1078,.4183),(-.9008,-.3642,.2365),(-.9006,-.39,.1921),(-.8969,.4415,-.0241),(-.8958,-.4042,.1848),(-.894,-.4378,.0948),(-.8917,.3608,-.2733),(-.8887,.4486,-.0947),(-.8863,-.4623,.0274),(-.8854,.3902,.2525),(-.8849,-.1986,.4214),(-.8823,.1857,.4325),(-.8709,-.0915,-.4828),(-.8692,-.4916,-.0529),(-.8668,-.4315,.25),(-.8612,-.1672,.4799),(-.858,-.2014,.4725),(-.8574,-.4695,.2106),(-.8557,-.2863,.431),(-.8541,-.4364,.2829),(-.8537,.313,.4162),(-.8536,.4749,.214),(-.8531,-.0297,-.521),(-.8494,-.0281,-.5269),(-.8488,-.5109,.1365),(-.8484,-.518,.1091),(-.8481,.5233,-.0827),(-.8474,-.2799,-.4512),(-.8459,-.4775,.2377),(-.8435,.4761,-.2487),(-.8433,-.5149,-.1542),(-.8392,.0002,.5438),(-.8382,.2773,.4696),(-.8347,.4586,.3049),(-.8285,.5574,.0542),(-.827,.3622,.4301),(-.826,-.2557,.5022),(-.8241,-.4936,-.278),(-.8211,-.4933,.2872),(-.8172,.0135,-.5763),(-.8153,.2285,.5321),(-.814,-.5568,.1654),(-.8097,-.0973,-.5787),(-.8094,-.5811,.0851),(-.8079,-.0752,.5845),(-.8058,-.082,.5865),(-.8049,-.5932,.0145),(-.8042,.0355,.5933),(-.7996,-.0344,-.5995),(-.798,-.0736,-.5982),(-.7979,.0192,.6024),(-.7967,.5798,-.1707),(-.7945,-.5978,.1064),(-.7933,.2966,-.5317),(-.7908,-.3316,.5146),(-.7903,-.0569,-.6101),(-.7876,.0013,.6162),(-.7866,-.4804,.3878),(-.7831,-.0311,-.6211),(-.7807,.5935,.1959),(-.7739,-.3909,.4983),(-.7738,.1319,-.6196),(-.7737,.1858,.6057),(-.7734,-.5517,.3121),(-.7728,.6202,-.1349),(-.7727,-.6318,.0613),(-.7721,.0836,.63),(-.7719,.4085,-.4871),(-.7717,-.629,-.0942),(-.771,.5099,-.3816),(-.7694,-.628,-.1169),(-.7651,.4005,-.5042),(-.762,-.0808,-.6425),(-.7612,.5544,-.3365),(-.761,-.5371,.3638),(-.7578,.5418,-.3636),(-.757,-.4741,-.4497),(-.7539,-.1897,.6289),(-.7536,-.6336,.1752),(-.7524,-.6468,.1247),(-.7511,.6597,-.0237),(-.7503,-.2927,-.5928),(-.7501,.2913,.5937),(-.7492,.6421,-.1626),(-.7486,.1237,.6514),(-.7476,.5809,-.322),(-.7453,-.6184,.2492),(-.7401,-.6723,.0188),(-.7373,.3534,-.5758),(-.7324,.6793,-.0465),(-.7322,-.3537,.5821),(-.7316,-.6472,-.2142),(-.7302,-.5082,-.4567),(-.7268,.5042,-.4663),(-.724,.2458,-.6445),(-.7222,.069,.6883),(-.721,.0583,-.6905),(-.7207,-.1765,.6704),(-.7197,-.6938,-.0255),(-.7149,.3129,-.6253),(-.7147,-.6595,.2328),(-.7142,.0652,-.6969),(-.7078,-.0909,.7006),(-.7066,.2672,.6552),(-.7052,-.215,.6756),(-.7051,-.6822,.1936),(-.704,.5514,.4475),(-.7039,.0092,-.7103),(-.702,-.0452,.7108),(-.7006,-.0563,-.7114),(-.6967,-.0958,-.7109),(-.693,-.1332,-.7086),(-.692,-.4602,.5562),(-.6919,.2168,-.6886),(-.6918,.6633,.2852),(-.6906,-.1344,-.7106),(-.688,-.6156,-.3843),(-.6876,.2,-.698),(-.6852,.6283,-.3684),(-.684,-.536,.4949),(-.6794,-.7252,.1114),(-.6716,-.3736,.6399),(-.6704,.6594,.3403),(-.6637,-.7443,.0747),(-.6571,-.2474,.7121),(-.652,.2033,.7305),(-.648,.7454,-.1562),(-.6462,-.6094,.4595),(-.6413,.0977,-.761),(-.639,.7431,.1988),(-.6343,.724,.271),(-.6318,-.6822,-.3681),(-.6271,-.2511,-.7374),(-.6255,-.7801,.0131),(-.6251,.772,.115),(-.6229,.3122,-.7173),(-.6227,.2429,.7438),(-.6215,.7273,.291),(-.6167,.7816,-.0938),(-.6162,.1728,-.7684),(-.6158,-.7695,-.1692),(-.6143,.199,.7636),(-.6143,-.7549,-.2297),(-.6115,.6999,-.369),(-.6105,.2217,-.7604),(-.6103,-.2909,.7368),(-.6074,.6887,.3959),(-.607,-.1997,.7692),(-.6028,.1174,.7892),(-.6025,-.0189,.7979),(-.598,-.7384,-.3119),(-.5961,.2349,.7677),(-.5946,.3519,-.7229),(-.5939,-.0606,.8022),(-.591,.2616,.7631),(-.5905,.3587,-.723),(-.5869,-.8097,-.0024),(-.585,-.5521,.5942),(-.5848,.0557,-.8093),(-.582,.8119,.0453),(-.5813,-.5767,-.5741),(-.5798,-.8071,.1115),(-.5795,-.2951,.7597),(-.5783,-.0922,.8106),(-.5777,-.4446,.6846),(-.5773,-.2843,-.7655),(-.5766,.8116,-.0937),(-.5759,-.078,.8138),(-.5726,-.2083,.793),(-.5725,.0207,.8197),(-.5715,-.1684,.8031),(-.5709,-.81,-.1343),(-.5687,-.1129,-.8148),(-.5678,-.723,-.3936),(-.5677,.8204,-.0684),(-.5667,-.0196,.8237),(-.5656,-.0351,-.8239),(-.5642,-.1689,-.8082),(-.5638,.7382,-.3705),(-.5624,.6696,-.4851),(-.5622,-.1635,.8107),(-.5615,.2977,.7721),(-.5593,.767,-.3146),(-.5574,-.5882,.5859),(-.5564,.5735,.6013),(-.5549,-.8301,-.0548),(-.5548,-.1826,-.8117),(-.5542,-.548,.6266),(-.5516,.2835,-.7845),(-.5512,.2616,-.7923),(-.5473,-.8296,.1107),(-.5466,-.1868,-.8163),(-.5454,-.0468,.8369),(-.5442,.6842,.4855),(-.5442,-.8089,-.2228),(-.5416,.7668,-.3444),(-.5411,.5267,.6555),(-.5406,-.3015,.7854),(-.54,.3369,-.7713),(-.5363,-.597,.5966),(-.5312,.75,.3941),(-.5308,.6897,.4925),(-.5263,-.8417,.1207),(-.5261,-.7973,.2958),(-.526,.6541,-.5436),(-.5221,-.0921,.8479),(-.522,-.5745,-.6304),(-.5209,.0658,-.8511),(-.5183,.3397,-.7848),(-.5181,-.7283,-.4484),(-.5178,.7129,-.473),(-.515,.2659,-.8149),(-.5147,-.6453,.5646),(-.5143,.8553,-.0635),(-.513,.0292,.8579),(-.5129,.2037,.834),(-.5108,-.8349,.2052),(-.5091,.8368,-.2013),(-.5083,.3269,-.7967),(-.5079,.7982,-.3238),(-.5073,.8026,.314),(-.5055,.7968,-.3311),(-.5013,-.8647,-.0312),(-.5013,.4293,-.7513),(-.4984,-.541,.6774),(-.4982,.7586,.4199),(-.4972,-.3803,.7799),(-.4932,.5778,-.6503),(-.4913,-.0151,-.8709),(-.4858,.386,.7842),(-.4831,-.8664,-.1265),(-.4814,.8205,.3084),(-.4801,-.7942,.3725),(-.4791,-.8772,.0321),(-.4767,-.8017,.3607),(-.4754,.8593,-.1886),(-.475,-.8797,.0215),(-.4736,.6139,-.6315),(-.473,-.8787,-.0648),(-.4728,-.0591,-.8792),(-.4691,-.1926,.8619),(-.4677,.7265,-.5034),(-.4636,-.7343,.4959),(-.4617,.8869,.0133),(-.4606,-.7281,.5077),(-.4602,.2661,-.847),(-.46,-.2203,.8601),(-.4585,-.8569,.2358),(-.4584,.8663,.1985),(-.4567,.5358,-.7102),(-.4549,.1329,.8806),(-.4505,-.4667,.7611),(-.4451,.8194,.3613),(-.444,.0682,.8934),(-.4434,.3331,.8321),(-.4429,-.1227,.8881),(-.4405,.058,.8959),(-.4398,-.6307,.6393),(-.4394,-.4852,-.756),(-.4378,.8522,.2864),(-.4374,-.6196,.6518),(-.4337,.8996,.0519),(-.4301,-.2152,-.8768),(-.4292,.2539,.8668),(-.4284,-.8138,.3927),(-.4278,.8524,-.3005),(-.4261,.8294,-.3614),(-.4259,.5453,-.722),(-.4258,.1245,.8962),(-.4251,.8622,.2754),(-.4246,-.8051,.4142),(-.4246,.4714,-.773),(-.4238,-.8988,-.1119),(-.4237,.5457,-.7229),(-.4229,.662,.6187),(-.4229,.4768,.7706),(-.4207,.5529,.7192),(-.4174,.5671,.71),(-.4158,.8967,-.1517),(-.4146,.6898,.5935),(-.4128,.5766,-.705),(-.4119,-.5461,.7295),(-.4114,.9109,.0322),(-.4097,.4374,-.8005),(-.4092,-.4457,-.7962),(-.4092,.5943,-.6924),(-.407,.6074,-.6822),(-.4068,.8306,-.3802),(-.402,.0467,.9144),(-.401,-.7652,.5037),(-.4,.1447,-.905),(-.397,-.704,-.5889),(-.3968,-.9108,-.1145),(-.3957,.7244,.5645),(-.3956,-.7991,-.4528),(-.3949,-.4153,.8195),(-.3934,.2138,-.8941),(-.3929,-.8087,.4377),(-.3904,-.2116,-.896),(-.3898,-.0434,-.9199),(-.382,-.3298,.8633),(-.3818,.7357,-.5594),(-.38,-.4927,.7828),(-.3754,.8809,.2882),(-.3734,-.1628,.9133),(-.3732,.7624,.5287),(-.3717,-.8327,.4103),(-.3708,.6878,.624),(-.3699,-.0882,.9249),(-.3697,.8417,.3934),(-.3685,.5124,-.7757),(-.3672,.0219,.9299),(-.3637,-.6416,-.6753),(-.3614,-.6924,-.6245),(-.3609,-.9171,.1694),(-.3569,-.8375,.4138),(-.356,.3088,.882),(-.3541,-.396,.8473),(-.3533,.1794,.9181),(-.352,.7309,-.5847),(-.3496,-.85,-.3942),(-.3454,.8581,-.38),(-.3443,.5663,-.7488),(-.3436,.7131,.6111),(-.3426,.9386,-.0394),(-.3415,-.0995,-.9346),(-.3411,.0712,-.9373),(-.3392,.8611,.3786),(-.3389,-.0195,-.9406),(-.3375,-.8086,.4819),(-.3352,.5794,-.7429),(-.3347,.6589,-.6736),(-.3345,-.9422,.0193),(-.3331,.6645,.6689),(-.3321,-.3899,.8589),(-.3314,.4061,.8516),(-.3313,-.8218,.4637),(-.3304,.8609,.3868),(-.3281,.0565,-.943),(-.3273,.5334,-.78),(-.3236,.7712,.5482),(-.3226,-.2761,-.9054),(-.3223,-.889,-.3253),(-.3219,.9464,.0275),(-.3214,-.29,.9014),(-.3158,.2022,.927),(-.3152,.7551,-.5749),(-.3142,-.9471,.0653),(-.3132,.5025,.8058),(-.3131,-.816,.4859),(-.3129,.9041,.291),(-.3116,-.7762,.5481),(-.3088,.1119,.9445),(-.3076,-.0384,-.9507),(-.3072,-.2219,-.9254),(-.3047,-.8304,.4664),(-.3022,.9424,-.1437),(-.3014,.8515,.429),(-.2986,.4205,-.8568),(-.2983,-.9218,.2477),(-.2978,-.8923,.3392),(-.2974,-.1531,.9424),(-.2966,-.0437,-.954),(-.2928,.835,-.466),(-.2926,.9068,.3035),(-.2913,-.9449,.1494),(-.2885,-.5243,-.8012),(-.2865,-.139,.948),(-.2818,.2458,.9275),(-.2815,.0226,.9593),(-.2798,-.8641,-.4183),(-.2772,.9217,-.2714),(-.2772,-.8313,.4817),(-.2741,.9051,.3251),(-.274,.8881,.3692),(-.2728,-.3258,-.9052),(-.2658,.4311,-.8623),(-.2631,-.2592,.9293),(-.2611,-.4843,.835),(-.2606,-.774,.5771),(-.258,-.5759,.7757),(-.2486,.6616,-.7075),(-.2464,-.9646,.0936),(-.2446,.4446,.8617),(-.2442,-.7147,-.6554),(-.2423,.9469,.2115),(-.2415,.8999,.3631),(-.2404,-.3172,.9174),(-.237,-.9588,-.1564),(-.2359,-.9592,-.1557),(-.2343,.9422,.2395),(-.2339,-.7655,.5993),(-.2339,-.8598,.4539),(-.2332,-.6093,.7579),(-.2309,-.9562,.1801),(-.2298,.9383,.2584),(-.2294,.9272,-.2962),(-.2274,-.5663,.7922),(-.2274,.9487,.2199),(-.2268,-.579,.7831),(-.2257,.9738,-.0293),(-.2244,.4551,-.8617),(-.2237,-.9029,-.367),(-.2224,-.6399,-.7356),(-.2218,.3245,.9195),(-.2214,-.4583,.8608),(-.221,-.4504,.8651),(-.2197,.6553,-.7227),(-.2195,.0111,-.9756),(-.2156,-.7593,.6139),(-.2154,-.7473,.6287),(-.2146,.9501,.2264),(-.2143,.9711,-.1052),(-.2143,-.9455,-.2453),(-.2134,.6772,-.7042),(-.2118,-.1236,.9695),(-.2114,-.8824,.4204),(-.2107,.791,-.5744),(-.2088,.0497,-.9767),(-.2083,.8972,-.3893),(-.2074,.3033,.9301),(-.2063,.072,.9758),(-.2035,.9581,.2017),(-.2026,-.0019,-.9793),(-.1994,.5675,-.7989),(-.199,.6856,.7003),(-.1983,.9313,.3054),(-.1968,.9324,.3032),(-.1954,-.309,-.9308),(-.1952,.9761,.0953),(-.194,.7796,-.5954),(-.1935,.1339,.9719),(-.1918,.7775,-.5989),(-.1897,.8716,-.4521),(-.1888,-.7232,-.6643),(-.1867,.8524,.4883),(-.1862,-.6749,.714),(-.1824,-.6758,.7142),(-.1794,-.9803,-.0831),(-.1794,.0982,-.9789),(-.1762,.833,-.5244),(-.1745,.6213,-.7639),(-.1738,.7261,-.6653),(-.1712,.9804,-.0978),(-.1689,.0665,.9834),(-.1688,-.3698,.9136),(-.1685,.2385,.9564),(-.1674,.4384,.883),(-.1667,.0043,-.986),(-.1663,.921,.3523),(-.164,.7955,.5834),(-.1631,.9049,.3932),(-.162,-.006,-.9868),(-.1599,-.7189,.6765),(-.1569,.7531,-.639),(-.1547,-.1743,-.9725),(-.154,.9713,.1815),(-.1525,.9768,.1506),(-.1523,-.925,.3481),(-.1517,-.5111,-.846),(-.1515,-.1016,-.9832),(-.1515,.9884,-.0136),(-.148,-.6068,.7809),(-.1472,.5123,-.8461),(-.146,-.7288,.669),(-.1446,-.8043,.5764),(-.1437,.8797,-.4533),(-.1431,-.0462,.9886),(-.1429,.9783,-.1501),(-.1412,.0686,.9876),(-.1396,.9902,.006),(-.1393,.1796,-.9738),(-.1383,.8515,-.5058),(-.1375,.3181,-.938),(-.1362,-.9801,-.1445),(-.1347,-.8103,.5703),(-.1328,.9847,-.1132),(-.1327,.4674,.874),(-.1324,.153,-.9793),(-.1323,.6758,-.7252),(-.1307,-.1685,.977),(-.1303,.5729,-.8092),(-.1294,-.9855,.1102),(-.1283,.6268,-.7686),(-.1268,-.8985,.4203),(-.1257,-.9428,-.3088),(-.1254,.0153,-.992),(-.1253,-.727,.6752),(-.1246,.8418,-.5252),(-.1244,-.3926,.9112),(-.1222,.9807,.1525),(-.1192,-.2302,.9658),(-.1186,.1491,-.9817),(-.116,.6062,-.7868),(-.1158,.4063,-.9064),(-.1117,-.4144,.9032),(-.1072,.4239,-.8993),(-.1067,-.1482,.9832),(-.1065,-.9934,.0419),(-.1056,.0614,-.9925),(-.1052,.7291,.6763),(-.1052,.7181,-.6879),(-.1052,.5848,-.8043),(-.1051,-.7323,.6729),(-.1039,-.9762,-.1906),(-.1028,.7547,-.648),(-.1025,-.6214,.7767),(-.1025,.9633,.2481),(-.1017,.6923,-.7144),(-.1013,.8874,-.4498),(-.0993,.9352,.3399),(-.0987,-.4868,.8679),(-.0986,.7767,-.6222),(-.0983,-.7204,-.6865),(-.0964,-.8605,-.5003),(-.0956,.7424,.6631),(-.0939,-.1774,.9796),(-.0934,-.9946,.0462),(-.0904,.7957,-.5989),(-.0902,.9549,.283),(-.0881,.8084,-.582),(-.0881,.0941,-.9917),(-.0874,.763,-.6405),(-.087,.3259,.9414),(-.0829,.7533,-.6524),(-.0799,.6149,-.7846),(-.0796,-.7259,-.6831),(-.0773,.6346,.769),(-.0772,.7615,-.6436),(-.076,-.8494,-.5223),(-.0747,-.4118,-.9082),(-.0736,.9479,-.31),(-.0734,.2077,.9754),(-.0729,-.9837,.1642),(-.0724,-.0104,-.9973),(-.0699,-.8892,-.4521),(-.0652,.235,-.9698),(-.0645,.2745,.9594),(-.0638,.6439,-.7625),(-.0618,-.8489,.5249),(-.0604,-.9943,.088),(-.0601,.5371,.8414),(-.056,-.8742,.4823),(-.0556,.7611,.6462),(-.0555,.0398,-.9977),(-.0499,.8195,-.5708),(-.0494,.9833,-.1752),(-.0493,.1983,-.9789),(-.0492,.157,-.9864),(-.0485,-.3095,.9497),(-.0479,.1523,-.9872),(-.0476,-.7484,-.6616),(-.0449,-.0879,.9951),(-.0425,.9153,.4005),(-.0422,-.9149,-.4014),(-.0422,.8428,-.5365),(-.0416,.2955,-.9544),(-.0408,.8941,-.4461),(-.0406,.9962,-.077),(-.0397,-.077,-.9962),(-.0386,.9988,-.031),(-.0379,.8827,.4684),(-.0374,.6328,-.7734),(-.0369,.7831,-.6208),(-.035,-.9876,-.153),(-.0349,.1666,-.9854),(-.0348,.9662,.2555),(-.0313,.1115,-.9933),(-.0294,.4783,-.8777),(-.0281,-.8576,.5136),(-.0266,.78,-.6253),(-.0257,.1303,-.9911),(-.0247,.1572,-.9873),(-.0242,-.7867,.6169),(-.0224,.6238,.7812),(-.0221,-.9305,-.3656),(-.0221,-.9972,-.072),(-.02,.2605,-.9653),(-.0194,.2301,-.973),(-.0191,.4206,-.907),(-.0191,.374,-.9272),(-.0189,-.9923,-.122),(-.0185,-.8245,-.5656),(-.0175,.8781,-.4782),(-.0163,.5936,.8046),(-.0159,.1574,-.9874),(-.0156,-.85,.5265),(-.0155,.5141,-.8576),(-.0151,.6614,.7499),(-.0147,.0342,-.9993),(-.0138,.7346,-.6783),(-.0133,.9753,.2206),(-.0132,.8486,-.5289),(-.0123,-.2103,-.9776),(-.0112,-.8514,.5245),(-.0108,-.9537,.3004),(-.0105,.9796,-.2007),(-.0097,-.9987,.0503),(-.0079,.1703,-.9854),(-.0064,.5957,.8032),(-.004,.1961,-.9806),(-.0031,.738,-.6748),(-.0022,-.9959,.0908),(-.0004,.4046,-.9145),(0,.0519,.9987),(0,-.0675,.9977),(0,.1515,.9885),(0,-.1659,.9861),(0,-.2077,.9782),(0,.2486,.9686),(0,-.3347,.9423),(0,-.4584,.8887),(0,.4772,.8788),(0,.7145,.6996),(0,-.7502,.6612),(0,-.8696,.4937),(0,.8988,.4383),(0,-.9231,.3846),(0,.9508,.3098),(0,.9559,.2935),(0,.9729,.2313),(0,.9731,.2304),(0,.9897,.1435),(0,-.9936,.1128),(0,-.9975,.0712),(0,-.997,-.078),(0,-.9914,-.1308),(0,-.9872,-.1593),(0,-.9762,-.2168),(0,-.9057,-.424),(0,-.8628,-.5055),(0,.7688,-.6395),(0,-.7535,-.6574),(0,.7268,-.6869),(0,.6529,-.7574),(0,.5986,-.8011),(0,.418,-.9085),(0,.3423,-.9396),(0,-.2164,-.9763),(0,.1707,-.9853),(0,.1601,-.9871),(0,.1399,-.9902),(0,.1216,-.9926),(0,.1155,-.9933),(0,-.0832,-.9965),(0,-.0677,-.9977),(.0004,.4046,-.9145),(.0022,-.9959,.0908),(.0042,.7402,-.6723),(.0057,-.3408,-.9401),(.0064,.5957,.8032),(.0071,.944,-.3299),(.0087,.9832,-.1826),(.0088,.2361,.9717),(.0093,.5,-.866),(.0097,-.9987,.0503),(.0108,-.9537,.3004),(.0112,-.8514,.5245),(.0116,.7306,-.6827),(.0132,.8486,-.5289),(.0133,.9753,.2206),(.0147,.0342,-.9993),(.0151,.6614,.7499),(.0155,.5141,-.8576),(.0156,-.85,.5265),(.0172,-.5327,.8461),(.0175,.8781,-.4782),(.0176,.1265,-.9918),(.0188,-.3634,-.9314),(.0189,-.9923,-.122),(.0191,.374,-.9272),(.0221,-.9972,-.072),(.0224,.6238,.7812),(.0229,.7685,-.6394),(.0241,.2153,-.9763),(.0247,.1572,-.9873),(.0254,-.8539,.5198),(.0257,.1303,-.9911),(.0263,.2226,-.9746),(.0281,-.8576,.5136),(.0302,-.2088,-.9775),(.032,.1484,-.9884),(.0348,.9662,.2555),(.035,-.9876,-.153),(.0363,.8301,-.5564),(.0374,.6328,-.7734),(.0379,.8827,.4684),(.0383,.8996,-.4351),(.0383,-.4312,.9015),(.0397,-.077,-.9962),(.0397,.1168,-.9924),(.0422,-.9149,-.4014),(.0425,.9153,.4005),(.0432,-.9244,-.3791),(.0449,-.0879,.9951),(.0462,.1495,-.9877),(.0476,-.7484,-.6616),(.0479,.1523,-.9872),(.0489,-.8122,.5814),(.0494,.9833,-.1752),(.0497,.7663,.6405),(.0499,.8432,-.5352),(.0511,.2863,-.9568),(.0555,.0398,-.9977),(.056,-.8742,.4823),(.0604,-.9943,.088),(.0652,.235,-.9698),(.0691,.7975,-.5993),(.0699,-.8892,-.4521),(.0704,.7338,-.6758),(.0724,-.0104,-.9973),(.0729,-.9837,.1642),(.0729,.6151,-.7851),(.0734,.2077,.9754),(.0736,.9479,-.31),(.076,-.8494,-.5223),(.077,.6093,-.7892),(.0772,-.404,-.9115),(.0773,.6346,.769),(.0796,-.7259,-.6831),(.0797,.7593,-.6458),(.0864,-.2733,.958),(.0865,.1494,-.985),(.087,.3259,.9414),(.0878,-.7181,-.6903),(.0902,.9549,.283),(.0903,.8363,-.5407),(.0906,.7659,-.6365),(.0927,.4284,-.8988),(.0939,-.1774,.9796),(.0956,.7424,.6631),(.0969,.8867,-.452),(.0977,-.6291,.7712),(.0987,-.4868,.8679),(.0988,.7187,-.6882),(.0993,.9352,.3399),(.1013,.5571,.8243),(.1017,.7793,-.6184),(.102,-.8671,-.4875),(.1025,.9633,.2481),(.1039,-.9762,-.1906),(.1051,-.7323,.6729),(.1052,.7291,.6763),(.1056,.0614,-.9925),(.1065,-.9934,.0419),(.1067,.7426,-.6612),(.1067,-.1482,.9832),(.1072,.4239,-.8993),(.1083,-.9922,.0621),(.1117,-.4144,.9032),(.1158,.4063,-.9064),(.116,.6062,-.7868),(.117,.5894,-.7993),(.1227,.0985,-.9875),(.1244,-.3926,.9112),(.1246,.8418,-.5252),(.1253,-.727,.6752),(.1254,.0153,-.992),(.1257,-.9428,-.3088),(.1268,.1416,-.9818),(.1268,-.8985,.4203),(.1276,.6311,-.7651),(.1294,-.9855,.1102),(.1307,-.1685,.977),(.1324,.153,-.9793),(.1327,.4674,.874),(.1347,-.8103,.5703),(.1347,.573,-.8084),(.136,.3352,-.9323),(.1362,-.9801,-.1445),(.1376,.8508,-.5072),(.1378,.1955,-.971),(.1379,.0265,-.9901),(.1389,.9774,.1595),(.1396,.9902,.006),(.1412,.0686,.9876),(.1427,.9798,-.1401),(.1429,.9783,-.1501),(.1431,-.0462,.9886),(.1437,.8797,-.4533),(.1464,.5528,-.8203),(.148,-.6035,.7835),(.1506,-.7183,.6792),(.1507,-.3503,.9244),(.1515,.9884,-.0136),(.1515,-.1016,-.9832),(.1517,-.5111,-.846),(.1523,-.925,.3481),(.1525,.9768,.1506),(.1537,-.2107,.9654),(.154,.9713,.1815),(.1547,-.1743,-.9725),(.1564,.4166,.8956),(.1569,.7531,-.639),(.1631,.9049,.3932),(.1667,.0043,-.986),(.1683,.716,-.6775),(.1685,.2385,.9564),(.1689,.0665,.9834),(.1704,-.283,-.9439),(.171,.9227,.3454),(.1755,.5889,-.7889),(.176,.6729,-.7185),(.1768,-.7136,.6779),(.1794,.0982,-.9789),(.1796,-.7647,.6188),(.1828,.9512,.2487),(.1862,-.6749,.714),(.1877,-.6954,.6937),(.1888,-.7232,-.6643),(.1897,.8716,-.4521),(.1919,.7989,.5701),(.1935,.1339,.9719),(.194,.7796,-.5954),(.1946,.3478,-.9172),(.195,-.2157,-.9568),(.1952,.9761,.0953),(.1968,.9324,.3032),(.1989,-.534,.8217),(.199,.6856,.7003),(.1994,.5675,-.7989),(.2,.804,-.56),(.2023,.9732,-.1092),(.2026,-.0019,-.9793),(.2046,-.9733,-.1041),(.2056,.9271,.3135),(.2063,.9736,-.0977),(.2063,.072,.9758),(.2088,.0497,-.9767),(.2107,.791,-.5744),(.2114,-.8824,.4204),(.2115,.9054,-.3681),(.2118,-.1236,.9695),(.2134,.6772,-.7042),(.2142,.6741,-.707),(.2143,-.9455,-.2453),(.2154,-.7473,.6287),(.2154,.9456,.2437),(.2166,.6565,-.7226),(.2189,.3204,.9217),(.2218,.3245,.9195),(.2224,-.6399,-.7356),(.2237,-.9029,-.367),(.2244,.4551,-.8617),(.2248,.9744,-.005),(.2274,.9487,.2199),(.2275,.9736,.0192),(.2294,.9272,-.2962),(.2298,.9383,.2584),(.2303,-.5672,.7907),(.2309,-.9562,.1801),(.2332,-.6093,.7579),(.2336,-.7706,.593),(.2339,-.8598,.4539),(.2339,-.7655,.5993),(.2343,.9422,.2395),(.2359,-.9592,-.1557),(.237,-.9588,-.1564),(.2404,-.3172,.9174),(.2415,.8999,.3631),(.2417,.7618,-.601),(.2423,.9469,.2115),(.2442,-.7147,-.6554),(.2451,.8377,.4881),(.2464,-.9646,.0936),(.2503,.8522,-.4594),(.2506,-.5652,.786),(.2537,-.834,.4901),(.258,-.5759,.7757),(.2608,.4205,-.869),(.2611,-.4843,.835),(.2631,-.2592,.9293),(.2632,-.0409,-.9639),(.2632,.4316,.8628),(.2704,-.4756,.8371),(.2728,-.3258,-.9052),(.2729,-.9476,.166),(.274,.8881,.3692),(.2769,.9143,.2957),(.2772,.9217,-.2714),(.2798,-.8641,-.4183),(.2815,.0226,.9593),(.2833,-.7863,.549),(.2865,-.139,.948),(.2884,-.0544,-.956),(.2885,-.5243,-.8012),(.2926,.9068,.3035),(.2961,.9468,-.1259),(.2966,-.0437,-.954),(.2974,-.1531,.9424),(.2983,-.9218,.2477),(.3014,.8515,.429),(.3037,.6802,.6672),(.3055,-.8892,.3406),(.3088,.1119,.9445),(.3129,.9041,.291),(.3131,-.816,.4859),(.3132,.5025,.8058),(.3142,-.9471,.0653),(.3158,.2022,.927),(.3203,.6566,-.6828),(.3214,-.29,.9014),(.3219,-.7927,.5177),(.3236,.7712,.5482),(.3255,.1782,.9286),(.3273,.5334,-.78),(.3296,-.8274,.4547),(.3297,-.8671,.3733),(.3304,.8609,.3868),(.3304,-.8272,.4545),(.332,.4117,.8487),(.3321,-.3899,.8589),(.3322,.7466,-.5764),(.3334,-.889,-.3138),(.3345,-.9422,.0193),(.3352,.5794,-.7429),(.3354,.0614,-.9401),(.3415,-.0995,-.9346),(.3433,.0019,-.9392),(.3436,.7131,.6111),(.3469,.8577,-.3795),(.3472,.3208,.8812),(.3496,-.85,-.3942),(.352,.7309,-.5847),(.3541,-.396,.8473),(.3562,.0997,-.9291),(.3562,.6273,-.6925),(.3569,-.8375,.4138),(.3609,.8605,.3596),(.3614,-.6924,-.6245),(.3637,.1893,.9121),(.3647,-.6549,-.6619),(.367,-.9106,.1901),(.3672,.0219,.9299),(.3699,-.0882,.9249),(.3708,.6878,.624),(.3715,.9262,-.0642),(.3734,-.1628,.9133),(.3754,.8809,.2882),(.3754,.5536,-.7434),(.38,-.4927,.7828),(.3818,.7357,-.5594),(.3828,.8247,.4163),(.3904,-.2116,-.896),(.3906,-.815,.428),(.3914,.0543,.9186),(.3914,.487,-.7808),(.3946,-.8054,.4422),(.3956,-.7991,-.4528),(.3957,.7244,.5645),(.3967,-.4148,.8189),(.3968,-.9108,-.1145),(.397,-.704,-.5889),(.4008,-.3116,.8616),(.4008,-.0065,-.9161),(.401,-.7652,.5037),(.4019,.4836,-.7776),(.4044,.5448,.7346),(.405,.135,-.9043),(.4068,.8306,-.3802),(.4084,.5634,-.7182),(.4092,-.4457,-.7962),(.4097,.4374,-.8005),(.4104,.8689,.2768),(.4112,-.5509,.7262),(.4114,.9109,.0322),(.4146,.6898,.5935),(.4158,.8967,-.1517),(.4174,.5671,.71),(.4199,.5323,-.7351),(.42,.0374,.9067),(.4201,.8662,.2706),(.4229,.4768,.7706),(.4229,.662,.6187),(.4236,.5521,-.7182),(.4237,.5457,-.7229),(.4243,.1205,.8975),(.4246,.2046,-.8819),(.4246,-.8051,.4142),(.4248,-.4958,.7575),(.4261,.8294,-.3614),(.4277,.583,-.6908),(.4278,.8524,-.3005),(.4284,-.8138,.3927),(.4301,-.2152,-.8768),(.4337,.8996,.0519),(.4374,-.6196,.6518),(.4378,.8522,.2864),(.439,.7398,.5098),(.4394,-.4852,-.756),(.44,.8212,.3632),(.4405,.058,.8959),(.4417,.2517,.8611),(.4429,-.1227,.8881),(.4434,.3331,.8321),(.447,-.8677,.2175),(.4499,-.8867,-.1063),(.4549,.1329,.8806),(.4562,-.7355,.5009),(.458,-.5994,.6565),(.4589,-.201,.8654),(.46,-.2203,.8601),(.4617,.8869,.0133),(.4622,-.0802,-.8832),(.4658,-.8849,.0084),(.4664,-.8828,-.0564),(.4695,-.7358,.4881),(.4699,-.803,.3665),(.4736,.6139,-.6315),(.4755,.8594,-.1882),(.4801,-.7942,.3725),(.4825,.8207,.3059),(.483,.5101,-.7117),(.4831,-.8664,-.1265),(.4845,-.331,.8097),(.4858,.386,.7842),(.4884,-.4876,.7237),(.4913,-.0151,-.8709),(.492,-.8705,.0139),(.4923,.7261,.48),(.4932,.2776,-.8245),(.4984,.7059,-.5034),(.4984,-.541,.6774),(.5001,.4005,-.7678),(.5013,-.8647,-.0312),(.5031,-.7152,-.4851),(.5055,.7968,-.3311),(.5073,.8026,.314),(.5079,.7982,-.3238),(.5083,.3269,-.7967),(.5108,-.8349,.2052),(.5129,.2037,.834),(.513,.0292,.8579),(.5143,.8553,-.0635),(.515,.2659,-.8149),(.5154,.2453,-.8211),(.5167,.5456,.6599),(.5178,.7129,-.473),(.5183,.3397,-.7848),(.5208,.038,-.8529),(.522,-.5745,-.6304),(.5221,-.0921,.8479),(.5247,-.6286,.5741),(.5251,.8281,-.1961),(.5261,-.1975,.8272),(.5261,-.7973,.2958),(.5263,-.8417,.1207),(.5273,.7523,.395),(.5308,.6897,.4925),(.5361,-.2991,.7894),(.5363,.317,-.7822),(.5363,-.597,.5966),(.5416,.7668,-.3444),(.5436,.683,.4879),(.5442,-.8089,-.2228),(.5454,-.0468,.8369),(.546,.365,-.7541),(.5465,-.1391,-.8258),(.5466,-.1868,-.8163),(.5473,-.8296,.1107),(.5477,-.5101,.6632),(.5497,-.5448,.6333),(.5516,.2835,-.7845),(.5548,-.1826,-.8117),(.5549,-.8301,-.0548),(.5574,-.5882,.5859),(.5575,-.2624,.7876),(.5605,.6732,-.4823),(.5629,.7604,-.324),(.5641,.8199,.098),(.5656,-.0351,-.8239),(.5658,.7059,-.4262),(.5677,.8204,-.0684),(.5678,-.723,-.3936),(.5687,-.1129,-.8148),(.569,-.0051,.8223),(.569,.6515,-.5018),(.5694,.5776,.5849),(.5709,-.81,-.1343),(.5715,-.1684,.8031),(.5726,-.2083,.793),(.5734,.241,-.783),(.5751,.0072,.8181),(.5766,.8116,-.0937),(.5773,-.1899,-.7941),(.5783,-.0922,.8106),(.5791,-.8083,.1061),(.5794,.2499,.7758),(.5811,.2651,.7695),(.5813,-.5767,-.5741),(.5848,.0557,-.8093),(.5869,-.8097,-.0024),(.5905,.3587,-.723),(.5961,.2349,.7677),(.598,-.7384,-.3119),(.599,.7943,-.1015),(.5992,-.0821,.7964),(.6025,-.0189,.7979),(.6028,.1174,.7892),(.6064,-.2018,.7691),(.6074,.6887,.3959),(.6115,.6999,-.369),(.6143,-.7549,-.2297),(.6143,.199,.7636),(.6158,-.7695,-.1692),(.6162,.1728,-.7684),(.6227,.2429,.7438),(.6229,.3122,-.7173),(.6239,-.0065,.7815),(.6251,.772,.115),(.6255,-.7801,.0131),(.6295,.7232,.2841),(.6318,-.6822,-.3681),(.6322,-.1891,.7514),(.6343,.724,.271),(.6391,-.2931,.711),(.6413,.0977,-.761),(.6442,.7319,.222),(.6458,-.7481,.1527),(.6462,-.6094,.4595),(.6462,-.1779,-.7421),(.648,.7454,-.1562),(.652,.2033,.7305),(.6572,-.7502,.0735),(.6581,-.3716,.6548),(.6698,-.6348,-.3853),(.6704,.6594,.3403),(.6738,.6398,-.3698),(.6844,.6813,.2597),(.685,-.0831,-.7238),(.6865,-.5095,.5187),(.6876,.2,-.698),(.6919,.2168,-.6886),(.6925,.0123,-.7213),(.6928,-.4606,.5548),(.6932,.553,.4622),(.7006,-.0563,-.7114),(.702,-.0452,.7108),(.7052,-.215,.6756),(.7066,.2672,.6552),(.7078,-.0909,.7006),(.7142,.0652,-.6969),(.7147,-.6595,.2328),(.7147,.32,-.6219),(.7154,-.0735,-.6949),(.7197,-.6938,-.0255),(.7204,.6933,-.0191),(.721,.0583,-.6905),(.7217,.3064,.6207),(.7243,-.1835,.6646),(.7288,.0614,.6819),(.7293,-.0845,-.6789),(.7298,-.6654,.1567),(.7302,-.5082,-.4567),(.7316,-.6472,-.2142),(.7318,.492,-.4716),(.7322,-.3537,.5821),(.7324,.6793,-.0465),(.7373,.3534,-.5758),(.7391,.2533,-.6241),(.7401,-.6723,.0188),(.7435,-.1864,.6422),(.7451,-.3907,.5405),(.7453,-.6184,.2492),(.7492,.6421,-.1626),(.7503,-.2927,-.5928),(.7511,-.6472,-.1304),(.7511,-.0558,-.6578),(.7512,.4274,-.5031),(.7536,-.6336,.1752),(.7578,.5418,-.3636),(.7602,-.64,.1119),(.7604,.1395,.6343),(.761,-.5371,.3638),(.7633,.5356,-.3611),(.7663,-.4756,-.4319),(.7691,-.5515,.3231),(.771,.5099,-.3816),(.7717,-.629,-.0942),(.7721,.0836,.63),(.7727,-.6318,.0613),(.7737,.1858,.6057),(.7738,.1319,-.6196),(.7741,.5555,-.3037),(.7751,.6154,-.1434),(.7798,.5881,-.2146),(.7807,.5935,.1959),(.7831,-.0311,-.6211),(.7866,-.4804,.3878),(.7876,.0013,.6162),(.7903,-.0569,-.6101),(.7908,-.3316,.5146),(.7933,.2966,-.5317),(.7939,.0278,.6074),(.7952,-.0565,.6038),(.798,-.0736,-.5982),(.7996,-.0344,-.5995),(.8,-.5887,.1162),(.8031,.3863,-.4537),(.8049,-.5932,.0145),(.8063,.0218,.5912),(.8079,-.0752,.5845),(.8094,-.5811,.0851),(.8097,-.0973,-.5787),(.8124,.2275,.5369),(.8172,.0135,-.5763),(.8181,-.5089,.2679),(.8186,-.5461,.178),(.8211,-.4933,.2872),(.8241,-.4936,-.278),(.826,-.2557,.5022),(.827,.3622,.4301),(.8334,-.2942,-.4679),(.8347,.4586,.3049),(.8392,.0002,.5438),(.8404,.5389,.0573),(.8433,-.5149,-.1542),(.8435,.4761,-.2487),(.8449,.257,.4691),(.8459,-.4775,.2377),(.8467,.5213,-.1063),(.8487,.4796,.2228),(.8488,-.5109,.1365),(.849,-.5144,.1206),(.8494,-.0281,-.5269),(.8504,-.1804,.4942),(.8537,.313,.4162),(.8541,-.4364,.2829),(.8561,-.0333,-.5157),(.8597,-.5063,-.0677),(.863,-.1637,.4779),(.8657,-.2838,.4123),(.8668,-.4315,.25),(.8709,-.0915,-.4828),(.8817,.3962,.2562),(.8823,.1857,.4325),(.8849,-.1986,.4214),(.8863,-.4623,.0274),(.8887,.4486,-.0947),(.8907,.2077,-.4044),(.8926,.4506,-.018),(.894,-.4378,.0948),(.8979,-.3781,.2254),(.9005,-.1752,-.398),(.9006,-.39,.1921),(.9008,-.3642,.2365),(.9017,-.1287,.4128),(.9021,.4311,.0205),(.9059,.0369,.422),(.906,-.0255,.4225),(.9092,-.3901,.1457),(.9096,-.2892,.2983),(.9113,.1725,.3739),(.9113,.1326,-.3897),(.9134,-.3975,.0882),(.9147,.3151,-.2532),(.9159,.1188,.3835),(.9203,.3872,.0556),(.9222,-.3819,-.0609),(.9254,-.0485,.3759),(.9267,-.152,-.3438),(.9267,-.2502,-.2804),(.9286,-.3521,.1168),(.9293,-.077,.3612),(.931,-.0646,.3591),(.932,.3528,.0836),(.9335,.1841,-.3078),(.9352,.2641,-.2361),(.9378,-.2546,-.2362),(.941,.2555,-.2219),(.9419,-.0862,.3247),(.942,-.2312,.2432),(.9472,-.082,-.3101),(.9483,.2427,-.2045),(.9517,-.0224,-.3061),(.9538,.2861,-.0915),(.9553,.2934,-.0365),(.9574,-.1945,.2133),(.9588,.0533,.2791),(.9607,-.2617,.0926),(.9665,-.0745,.2457),(.9688,.2412,.0576),(.9702,.1849,.1569),(.9703,-.2312,-.0707),(.9766,-.0033,-.2148),(.9819,.1824,.0514),(.9856,.0588,.1587),(.9877,.1552,.0171),(.9887,.0012,.15),(.9888,.1485,.0127),(.9895,.0737,.1246),(.9933,.0835,-.0796),(.996,.0893,.0092),(.9971,.0551,-.052),(.998,.0633,.002)]))),
      Shape(DEF='c3disc',
        appearance=Appearance(
          material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),shininess=0.050,specularColor=(.9647,.949,.9098))),
        geometry=IndexedFaceSet(DEF='c3disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,0,15,7,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,37,53,-1,54,55,56,-1,43,57,58,-1,59,60,49,-1,61,50,56,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,4,-1,73,74,75,-1,76,77,78,-1,79,77,80,-1,81,82,83,-1,84,85,79,-1,86,87,88,-1,10,89,90,-1,91,92,93,-1,93,92,6,-1,94,95,96,-1,97,98,11,-1,61,67,66,-1,99,100,101,-1,102,69,68,-1,38,103,72,-1,44,104,105,-1,44,42,104,-1,41,106,107,-1,26,108,109,-1,39,38,71,-1,108,26,22,-1,110,111,19,-1,55,112,67,-1,113,114,115,-1,116,117,98,-1,92,7,6,-1,93,118,119,-1,120,121,116,-1,122,123,87,-1,108,88,124,-1,125,126,110,-1,127,128,129,-1,14,130,115,-1,131,132,133,-1,80,134,135,-1,81,136,137,-1,83,138,139,-1,140,135,134,-1,141,74,71,-1,142,143,56,-1,47,144,43,-1,145,146,46,-1,147,64,148,-1,46,146,149,-1,149,103,38,-1,53,39,150,-1,151,102,152,-1,153,154,155,-1,29,28,156,-1,157,114,34,-1,158,159,160,-1,35,113,161,-1,156,162,20,-1,163,34,158,-1,164,31,33,-1,22,26,25,-1,16,165,17,-1,99,166,100,-1,9,167,10,-1,168,169,170,-1,94,6,124,-1,171,3,172,-1,105,104,173,-1,173,172,105,-1,3,5,172,-1,6,8,124,-1,173,171,172,-1,34,163,157,-1,165,21,17,-1,22,25,23,-1,164,174,31,-1,175,176,18,-1,20,24,156,-1,23,25,177,-1,35,114,113,-1,114,35,34,-1,156,177,29,-1,153,155,101,-1,178,151,152,-1,179,53,150,-1,37,149,38,-1,147,62,64,-1,43,48,47,-1,142,56,50,-1,180,67,112,-1,74,73,71,-1,140,134,181,-1,182,83,139,-1,83,3,138,-1,82,183,184,-1,135,84,80,-1,133,185,131,-1,14,186,130,-1,128,9,129,-1,126,111,110,-1,124,109,108,-1,122,87,86,-1,187,15,2,-1,116,97,120,-1,93,96,118,-1,98,97,116,-1,130,113,115,-1,61,55,67,-1,153,101,100,-1,19,165,110,-1,86,108,22,-1,39,71,73,-1,109,27,26,-1,42,41,107,-1,42,107,104,-1,105,45,44,-1,38,72,71,-1,150,39,73,-1,73,75,150,-1,68,152,102,-1,99,101,188,-1,66,189,61,-1,18,113,175,-1,97,11,90,-1,190,191,118,-1,91,93,192,-1,90,11,10,-1,88,108,86,-1,115,132,131,-1,79,80,84,-1,3,171,138,-1,83,193,81,-1,79,78,77,-1,76,78,194,-1,105,172,195,-1,74,196,75,-1,4,141,71,-1,68,70,197,-1,67,180,65,-1,62,52,63,-1,56,55,61,-1,43,144,57,-1,54,100,55,-1,48,145,46,-1,48,43,45,-1,58,40,42,-1,53,37,39,-1,61,51,50,-1,34,36,198,-1,31,199,32,-1,200,201,202,-1,30,203,28,-1,27,204,25,-1,205,22,24,-1,165,19,21,-1,176,16,18,-1,206,207,140,-1,11,129,9,-1,7,15,8,-1,3,184,4,-1,0,2,15,-1,14,89,186,-1,13,89,14,-1,197,85,84,-1,85,197,70,-1,141,137,74,-1,183,137,141,-1,87,191,190,-1,191,87,123,-1,195,208,209,-1,195,210,208,-1,174,211,31,-1,174,212,211,-1,213,198,214,-1,198,213,159,-1,32,202,33,-1,200,202,32,-1,164,202,215,-1,164,33,202,-1,30,201,200,-1,29,201,30,-1,204,201,29,-1,23,156,24,-1,23,177,156,-1,216,217,162,-1,216,36,217,-1,40,218,211,-1,40,219,218,-1,220,221,222,-1,223,221,220,-1,224,225,226,-1,225,224,221,-1,226,159,213,-1,160,159,226,-1,214,28,203,-1,214,216,28,-1,155,178,152,-1,154,178,155,-1,142,227,228,-1,60,227,142,-1,62,37,52,-1,62,149,37,-1,153,54,154,-1,100,54,153,-1,61,229,51,-1,61,189,229,-1,230,231,232,-1,223,231,230,-1,233,234,232,-1,233,59,234,-1,228,143,142,-1,228,235,143,-1,236,112,166,-1,112,236,169,-1,107,173,104,-1,237,173,107,-1,139,171,173,-1,139,138,171,-1,194,238,239,-1,240,238,194,-1,106,237,107,-1,106,241,237,-1,242,239,238,-1,243,239,242,-1,76,244,77,-1,244,76,245,-1,170,134,244,-1,181,134,170,-1,81,183,82,-1,81,137,183,-1,116,191,117,-1,116,118,191,-1,12,115,131,-1,12,14,115,-1,127,125,110,-1,129,125,127,-1,246,9,128,-1,9,246,167,-1,247,119,121,-1,248,119,247,-1,249,248,250,-1,248,249,192,-1,251,252,253,-1,241,252,251,-1,254,255,256,-1,243,255,254,-1,257,258,185,-1,257,259,258,-1,120,90,260,-1,90,120,97,-1,157,115,114,-1,115,157,132,-1,176,127,16,-1,128,127,176,-1,68,155,152,-1,155,68,261,-1,122,22,205,-1,122,86,22,-1,27,262,263,-1,27,109,262,-1,2,174,164,-1,2,1,174,-1,1,212,174,-1,1,264,212,-1,215,2,164,-1,187,2,215,-1,205,111,122,-1,111,205,19,-1,261,101,155,-1,101,261,188,-1,66,265,189,-1,265,66,266,-1,267,132,157,-1,132,267,133,-1,268,185,258,-1,185,268,131,-1,259,256,258,-1,259,254,256,-1,251,249,269,-1,251,253,249,-1,91,249,253,-1,192,249,91,-1,247,120,270,-1,247,121,120,-1,7,91,0,-1,7,92,91,-1,0,264,1,-1,264,0,252,-1,82,3,83,-1,82,184,3,-1,78,81,193,-1,81,78,79,-1,180,244,245,-1,168,244,180,-1,168,170,244,-1,76,271,245,-1,76,272,271,-1,269,238,273,-1,242,238,269,-1,274,173,237,-1,173,274,139,-1,272,194,239,-1,194,272,76,-1,5,72,210,-1,5,4,72,-1,172,210,195,-1,172,5,210,-1,166,206,236,-1,166,99,206,-1,112,168,180,-1,112,169,168,-1,65,266,66,-1,266,65,257,-1,275,276,277,-1,275,278,276,-1,279,144,277,-1,57,144,279,-1,51,59,49,-1,229,59,51,-1,234,59,229,-1,280,232,234,-1,230,232,280,-1,265,229,189,-1,229,265,281,-1,282,178,283,-1,282,151,178,-1,209,48,45,-1,209,145,48,-1,275,46,147,-1,275,47,46,-1,50,60,142,-1,49,60,50,-1,36,214,198,-1,36,216,214,-1,284,226,225,-1,284,160,226,-1,221,230,225,-1,230,221,223,-1,211,199,31,-1,211,218,199,-1,156,216,162,-1,28,216,156,-1,161,18,17,-1,18,161,113,-1,25,29,177,-1,25,204,29,-1,200,285,30,-1,200,32,285,-1,159,34,198,-1,34,159,158,-1,20,205,24,-1,19,205,20,-1,117,123,126,-1,117,191,123,-1,190,88,87,-1,190,95,88,-1,136,74,137,-1,136,196,74,-1,135,207,286,-1,135,140,207,-1,181,169,236,-1,181,170,169,-1,84,286,197,-1,84,135,286,-1,4,183,141,-1,184,183,4,-1,117,125,98,-1,117,126,125,-1,186,10,167,-1,89,10,186,-1,146,209,208,-1,145,209,146,-1,212,40,211,-1,212,41,40,-1,213,203,287,-1,214,203,213,-1,17,217,161,-1,21,217,17,-1,32,288,285,-1,32,199,288,-1,289,157,163,-1,289,267,157,-1,284,281,289,-1,281,284,280,-1,222,219,220,-1,222,218,219,-1,224,222,221,-1,224,288,222,-1,224,213,287,-1,226,213,224,-1,58,44,43,-1,58,42,44,-1,148,227,278,-1,227,148,228,-1,208,149,146,-1,208,103,149,-1,54,143,283,-1,54,56,143,-1,149,147,46,-1,149,62,147,-1,63,53,179,-1,63,52,53,-1,283,235,282,-1,283,143,235,-1,57,40,58,-1,57,219,40,-1,231,220,279,-1,220,231,223,-1,232,276,233,-1,231,276,232,-1,60,233,227,-1,233,60,59,-1,64,228,148,-1,64,235,228,-1,136,79,85,-1,136,81,79,-1,197,261,68,-1,261,197,286,-1,207,99,188,-1,207,206,99,-1,193,194,78,-1,194,193,240,-1,240,273,238,-1,182,273,240,-1,237,251,274,-1,251,237,241,-1,239,254,272,-1,254,239,243,-1,271,257,65,-1,271,259,257,-1,134,77,244,-1,80,77,134,-1,122,126,123,-1,111,126,122,-1,248,93,119,-1,192,93,248,-1,250,247,255,-1,247,250,248,-1,252,106,264,-1,252,241,106,-1,255,242,250,-1,242,255,243,-1,260,270,120,-1,268,270,260,-1,90,13,260,-1,13,90,89,-1,95,118,96,-1,95,190,118,-1,175,128,176,-1,246,128,175,-1,16,110,165,-1,127,110,16,-1,263,187,215,-1,187,263,262,-1,45,195,209,-1,45,105,195,-1,265,133,267,-1,265,266,133,-1,103,210,72,-1,103,208,210,-1,69,150,75,-1,102,150,69,-1,166,55,100,-1,112,55,166,-1,6,96,93,-1,6,94,96,-1,118,121,119,-1,116,121,118,-1,260,131,268,-1,260,12,131,-1,12,260,13,-1,258,270,268,-1,258,256,270,-1,250,269,249,-1,269,250,242,-1,0,253,252,-1,91,253,0,-1,247,256,255,-1,270,256,247,-1,109,8,262,-1,109,124,8,-1,262,15,187,-1,262,8,15,-1,130,167,246,-1,186,167,130,-1,266,185,133,-1,257,185,266,-1,65,245,271,-1,180,245,65,-1,272,259,271,-1,272,254,259,-1,273,251,269,-1,273,274,251,-1,273,139,274,-1,139,273,182,-1,83,240,193,-1,240,83,182,-1,188,286,207,-1,286,188,261,-1,70,75,196,-1,75,70,69,-1,227,276,278,-1,276,227,233,-1,279,276,231,-1,279,277,276,-1,219,279,220,-1,219,57,279,-1,281,234,229,-1,280,234,281,-1,235,63,282,-1,63,235,64,-1,282,179,151,-1,282,63,179,-1,277,47,275,-1,277,144,47,-1,154,283,178,-1,154,54,283,-1,147,278,275,-1,278,147,148,-1,150,151,179,-1,151,150,102,-1,224,285,288,-1,224,287,285,-1,199,222,288,-1,222,199,218,-1,160,163,158,-1,160,289,163,-1,289,160,284,-1,225,280,284,-1,280,225,230,-1,289,265,267,-1,281,265,289,-1,162,21,20,-1,21,162,217,-1,36,161,217,-1,36,35,161,-1,204,263,201,-1,204,27,263,-1,287,30,285,-1,203,30,287,-1,215,201,263,-1,215,202,201,-1,264,41,212,-1,264,106,41,-1,113,246,175,-1,130,246,113,-1,129,98,125,-1,11,98,129,-1,95,124,88,-1,95,94,124,-1,196,85,70,-1,136,85,196,-1,140,236,206,-1,140,181,236,-1],creaseAngle=1.571,normalIndex=[82,188,205,-1,259,171,176,-1,34,52,107,-1,33,28,31,-1,102,80,87,-1,82,121,52,-1,258,286,283,-1,273,288,285,-1,268,287,289,-1,276,240,245,-1,271,281,269,-1,214,217,241,-1,215,244,254,-1,14,51,26,-1,135,138,89,-1,79,68,58,-1,22,74,49,-1,110,76,122,-1,17,14,2,-1,41,64,55,-1,79,181,97,-1,129,90,110,-1,99,76,55,-1,7,15,16,-1,177,183,174,-1,194,98,196,-1,67,63,171,-1,69,170,78,-1,189,212,233,-1,264,212,235,-1,275,282,262,-1,242,255,264,-1,223,118,115,-1,28,50,40,-1,62,12,30,-1,30,12,34,-1,36,27,6,-1,56,48,31,-1,99,174,183,-1,197,53,88,-1,21,98,194,-1,51,46,63,-1,68,101,85,-1,68,89,101,-1,138,154,105,-1,240,222,226,-1,26,51,67,-1,222,240,268,-1,95,193,273,-1,64,187,174,-1,230,221,93,-1,25,38,48,-1,12,52,34,-1,30,11,43,-1,75,57,25,-1,218,100,118,-1,222,115,116,-1,61,91,95,-1,96,72,60,-1,87,70,93,-1,94,113,111,-1,235,250,260,-1,275,246,251,-1,262,274,227,-1,256,260,250,-1,164,170,67,-1,59,32,55,-1,74,163,79,-1,20,19,22,-1,18,16,35,-1,22,19,8,-1,8,46,51,-1,2,26,10,-1,1,21,9,-1,5,4,13,-1,281,271,272,-1,184,221,215,-1,178,199,159,-1,244,230,252,-1,272,265,288,-1,168,215,178,-1,236,214,241,-1,268,240,276,-1,258,277,286,-1,197,200,53,-1,33,37,28,-1,185,201,210,-1,36,34,116,-1,234,259,165,-1,85,101,208,-1,208,165,85,-1,259,176,165,-1,34,107,116,-1,208,234,165,-1,215,168,184,-1,277,285,286,-1,268,276,287,-1,236,219,214,-1,211,225,283,-1,288,289,272,-1,287,276,278,-1,244,221,230,-1,221,244,215,-1,272,278,281,-1,5,13,88,-1,3,1,9,-1,0,2,10,-1,14,8,51,-1,18,7,16,-1,79,49,74,-1,59,55,76,-1,192,174,187,-1,170,69,67,-1,256,250,239,-1,213,262,227,-1,262,259,274,-1,282,263,253,-1,260,242,235,-1,111,114,94,-1,87,54,70,-1,72,33,60,-1,91,193,95,-1,116,226,222,-1,218,118,223,-1,224,121,205,-1,25,56,75,-1,30,6,11,-1,48,56,25,-1,70,230,93,-1,99,64,174,-1,5,88,53,-1,273,277,95,-1,223,222,268,-1,26,67,69,-1,226,245,240,-1,89,138,105,-1,89,105,101,-1,85,58,68,-1,51,63,67,-1,10,26,69,-1,69,78,10,-1,194,9,21,-1,197,88,202,-1,183,173,99,-1,283,230,211,-1,56,31,40,-1,39,45,11,-1,62,30,77,-1,40,31,28,-1,115,222,223,-1,93,113,94,-1,264,235,242,-1,259,234,274,-1,262,248,275,-1,264,233,212,-1,189,233,198,-1,85,165,66,-1,170,190,78,-1,171,164,67,-1,194,196,229,-1,174,192,177,-1,7,17,15,-1,55,64,99,-1,79,163,181,-1,41,53,64,-1,49,20,22,-1,49,79,58,-1,97,135,89,-1,2,14,26,-1,99,122,76,-1,215,254,231,-1,214,123,217,-1,267,284,270,-1,269,257,271,-1,245,279,276,-1,280,268,289,-1,277,273,285,-1,225,258,283,-1,237,232,256,-1,31,60,33,-1,52,121,107,-1,259,253,171,-1,82,205,121,-1,87,50,54,-1,80,50,87,-1,229,255,242,-1,255,229,196,-1,164,251,170,-1,263,251,164,-1,118,45,39,-1,45,118,100,-1,66,44,47,-1,66,65,44,-1,219,191,214,-1,219,203,191,-1,207,231,249,-1,231,207,199,-1,217,270,241,-1,267,270,217,-1,236,270,243,-1,236,241,270,-1,269,284,267,-1,281,284,269,-1,279,284,281,-1,287,272,289,-1,287,278,272,-1,266,261,265,-1,266,254,261,-1,135,104,191,-1,135,151,104,-1,150,119,109,-1,148,119,150,-1,155,126,167,-1,126,155,119,-1,167,199,207,-1,159,199,167,-1,249,271,257,-1,249,266,271,-1,13,3,9,-1,4,3,13,-1,59,83,42,-1,90,83,59,-1,7,14,17,-1,7,8,14,-1,5,41,4,-1,53,41,5,-1,99,161,122,-1,99,173,161,-1,146,172,162,-1,148,172,146,-1,124,158,162,-1,124,129,158,-1,42,32,59,-1,42,24,32,-1,238,187,200,-1,187,238,201,-1,105,208,101,-1,166,208,105,-1,227,234,208,-1,227,274,234,-1,198,169,160,-1,204,169,198,-1,154,166,105,-1,154,141,166,-1,142,160,169,-1,143,160,142,-1,189,206,212,-1,206,189,175,-1,210,250,206,-1,239,250,210,-1,275,263,282,-1,275,251,263,-1,25,45,38,-1,25,11,45,-1,102,93,94,-1,102,87,93,-1,96,61,95,-1,60,61,96,-1,71,33,72,-1,33,71,37,-1,92,43,57,-1,86,43,92,-1,108,86,120,-1,86,108,77,-1,139,125,106,-1,141,125,139,-1,144,128,156,-1,143,128,144,-1,152,153,114,-1,152,145,153,-1,75,40,84,-1,40,75,56,-1,184,93,221,-1,93,184,113,-1,225,96,258,-1,72,96,225,-1,194,13,9,-1,13,194,195,-1,218,268,280,-1,218,223,268,-1,245,220,247,-1,245,226,220,-1,205,219,236,-1,205,188,219,-1,188,203,219,-1,188,186,203,-1,243,205,236,-1,224,205,243,-1,280,193,218,-1,193,280,273,-1,195,88,13,-1,88,195,202,-1,183,137,173,-1,137,183,136,-1,117,113,184,-1,113,117,111,-1,112,114,153,-1,114,112,94,-1,145,156,153,-1,145,144,156,-1,139,108,140,-1,139,106,108,-1,62,108,106,-1,77,108,62,-1,92,75,103,-1,92,57,75,-1,52,62,82,-1,52,12,62,-1,82,186,188,-1,186,82,125,-1,282,259,262,-1,282,253,259,-1,233,275,248,-1,275,233,264,-1,192,206,175,-1,185,206,192,-1,185,210,206,-1,189,134,175,-1,189,132,134,-1,140,169,180,-1,142,169,140,-1,182,208,166,-1,208,182,227,-1,132,198,160,-1,198,132,189,-1,176,63,65,-1,176,171,63,-1,165,65,66,-1,165,176,65,-1,200,237,238,-1,200,197,237,-1,187,185,192,-1,187,201,185,-1,177,136,183,-1,136,177,152,-1,73,133,157,-1,73,81,133,-1,179,163,157,-1,181,163,179,-1,122,129,110,-1,161,129,122,-1,158,129,161,-1,147,162,158,-1,146,162,147,-1,137,161,173,-1,161,137,149,-1,23,3,29,-1,23,1,3,-1,47,49,58,-1,47,20,49,-1,73,22,18,-1,73,74,22,-1,76,90,59,-1,110,90,76,-1,254,249,231,-1,254,266,249,-1,130,167,126,-1,130,159,167,-1,119,146,126,-1,146,119,148,-1,191,123,214,-1,191,104,123,-1,272,266,265,-1,271,266,272,-1,252,283,286,-1,283,252,230,-1,276,281,278,-1,276,279,281,-1,267,216,269,-1,267,217,216,-1,199,215,231,-1,215,199,178,-1,288,280,289,-1,273,280,288,-1,38,100,91,-1,38,45,100,-1,39,115,118,-1,39,27,115,-1,246,170,251,-1,246,190,170,-1,260,232,228,-1,260,256,232,-1,239,201,238,-1,239,210,201,-1,242,228,229,-1,242,260,228,-1,171,263,164,-1,253,263,171,-1,38,61,48,-1,38,91,61,-1,54,28,37,-1,50,28,54,-1,19,47,44,-1,20,47,19,-1,203,135,191,-1,203,138,135,-1,207,257,209,-1,249,257,207,-1,286,261,252,-1,285,261,286,-1,217,131,216,-1,217,123,131,-1,127,184,168,-1,127,117,184,-1,130,149,127,-1,149,130,147,-1,109,151,150,-1,109,104,151,-1,155,109,119,-1,155,131,109,-1,155,207,209,-1,167,207,155,-1,97,68,79,-1,97,89,68,-1,35,83,81,-1,83,35,42,-1,44,8,19,-1,44,46,8,-1,41,32,29,-1,41,55,32,-1,8,18,22,-1,8,7,18,-1,15,2,0,-1,15,17,2,-1,29,24,23,-1,29,32,24,-1,181,135,97,-1,181,151,135,-1,172,150,179,-1,150,172,148,-1,162,133,124,-1,172,133,162,-1,90,124,83,-1,124,90,129,-1,16,42,35,-1,16,24,42,-1,246,264,255,-1,246,275,264,-1,229,195,194,-1,195,229,228,-1,232,197,202,-1,232,237,197,-1,248,198,233,-1,198,248,204,-1,204,180,169,-1,213,180,204,-1,166,139,182,-1,139,166,141,-1,160,144,132,-1,144,160,143,-1,134,152,177,-1,134,145,152,-1,250,212,206,-1,235,212,250,-1,218,91,100,-1,193,91,218,-1,86,30,43,-1,77,30,86,-1,120,92,128,-1,92,120,86,-1,125,154,186,-1,125,141,154,-1,128,142,120,-1,142,128,143,-1,84,103,75,-1,112,103,84,-1,40,80,84,-1,80,40,50,-1,27,11,6,-1,27,39,11,-1,211,72,225,-1,71,72,211,-1,258,95,277,-1,96,95,258,-1,247,224,243,-1,224,247,220,-1,58,66,47,-1,58,85,66,-1,137,111,117,-1,137,136,111,-1,46,65,63,-1,46,44,65,-1,98,10,78,-1,21,10,98,-1,200,64,53,-1,187,64,200,-1,34,6,30,-1,34,36,6,-1,11,57,43,-1,25,57,11,-1,84,94,112,-1,84,102,94,-1,102,84,80,-1,153,103,112,-1,153,156,103,-1,120,140,108,-1,140,120,142,-1,82,106,125,-1,62,106,82,-1,92,156,128,-1,103,156,92,-1,226,107,220,-1,226,116,107,-1,220,121,224,-1,220,107,121,-1,70,37,71,-1,54,37,70,-1,136,114,111,-1,152,114,136,-1,177,175,134,-1,192,175,177,-1,132,145,134,-1,132,144,145,-1,180,139,140,-1,180,182,139,-1,180,227,182,-1,227,180,213,-1,262,204,248,-1,204,262,213,-1,202,228,232,-1,228,202,195,-1,196,78,190,-1,78,196,98,-1,83,133,81,-1,133,83,124,-1,179,133,172,-1,179,157,133,-1,151,179,150,-1,151,181,179,-1,149,158,161,-1,147,158,149,-1,24,15,23,-1,15,24,16,-1,23,0,1,-1,23,15,0,-1,157,74,73,-1,157,163,74,-1,4,29,3,-1,4,41,29,-1,18,81,73,-1,81,18,35,-1,10,1,0,-1,1,10,21,-1,155,216,131,-1,155,209,216,-1,123,109,131,-1,109,123,104,-1,159,168,178,-1,159,127,168,-1,127,159,130,-1,126,147,130,-1,147,126,146,-1,127,137,117,-1,149,137,127,-1,265,285,288,-1,285,265,261,-1,254,252,261,-1,254,244,252,-1,279,247,284,-1,279,245,247,-1,209,269,216,-1,257,269,209,-1,243,284,247,-1,243,270,284,-1,186,138,203,-1,186,154,138,-1,230,71,211,-1,70,71,230,-1,60,48,61,-1,31,48,60,-1,27,116,115,-1,27,36,116,-1,190,255,196,-1,246,255,190,-1,256,238,237,-1,256,239,238,-1],
          coord=Coordinate(DEF='c3disc_Coord',point=[(.13379,54.37176,-.71645),(.14265,54.35487,-.68903),(.21425,54.39606,-.7044),(-.23135,54.48756,-.72327),(-.2514,54.49425,-.71892),(-.24353,54.48221,-.71457),(.23135,54.48756,-.72327),(.19445,54.43357,-.70734),(.24256,54.48229,-.71392),(.31298,54.52943,-1.16522),(.29763,54.51729,-1.15836),(.31316,54.54359,-1.10012),(.21393,54.47352,-1.20401),(.22382,54.47437,-1.19178),(.22879,54.47423,-1.20651),(.20319,54.42305,-.70409),(.39364,54.55997,-1.12219),(.39337,54.54571,-1.12437),(.37067,54.53723,-1.16405),(.43222,54.57453,-.95391),(.43704,54.55127,-.96649),(.41142,54.55194,-1.06962),(.38649,54.53051,-.79237),(.40006,54.51245,-.81359),(.43335,54.53319,-.88201),(.36854,54.47763,-.77995),(.34745,54.50115,-.76471),(.3083,54.44857,-.74553),(.3298,54.43936,-.89508),(.33135,54.43419,-.82866),(.28627,54.36615,-.83663),(.16514,54.30867,-.70486),(.26441,54.34039,-.78124),(.25782,54.33656,-.7505),(.20145,54.42268,-1.13045),(.26427,54.46393,-1.15549),(.29041,54.45913,-1.07599),(-.36854,54.47763,-.77995),(-.35079,54.49795,-.76566),(-.39083,54.52774,-.79284),(0,54.3032,-.6606),(0,54.31938,-.65974),(-.07631,54.32025,-.66825),(-.16401,54.31096,-.70435),(-.15657,54.32682,-.69458),(-.24569,54.35311,-.73241),(-.27605,54.34615,-.77827),(-.26441,54.34039,-.78124),(-.25366,54.34322,-.74306),(-.19325,54.4172,-1.11685),(-.20145,54.42268,-1.13045),(-.18765,54.42024,-1.12748),(-.38127,54.48415,-.81543),(-.40473,54.508,-.81109),(-.34337,54.51257,-1.14957),(-.25706,54.46293,-1.21152),(-.26427,54.46393,-1.15549),(-.07892,54.32259,-.7172),(-.08144,54.30354,-.67541),(-.16505,54.4032,-1.04964),(-.23353,54.41002,-1.05602),(-.18335,54.43247,-1.19146),(-.33135,54.43419,-.82866),(-.40381,54.49682,-.88495),(-.3298,54.43936,-.89508),(-.06996,54.46246,-1.1991),(-.08048,54.44873,-1.19448),(-.15541,54.45523,-1.21037),(-.36862,54.5665,-1.04632),(-.36898,54.59272,-.93767),(-.32714,54.59408,-.92359),(-.30724,54.53953,-.75336),(-.26869,54.4847,-.72189),(-.33221,54.56514,-.7866),(-.30237,54.57727,-.79035),(-.35495,54.57901,-.82947),(-.1301,54.47914,-1.06893),(-.22132,54.49214,-1.06183),(-.2211,54.49646,-.96745),(-.27477,54.54085,-.94499),(-.27317,54.51795,-1.04171),(-.26606,54.54627,-.84861),(-.25087,54.51455,-.78142),(-.19214,54.46622,-.8081),(-.31444,54.54581,-1.02984),(-.30749,54.58503,-.9248),(.33142,54.56564,-.78651),(.30238,54.57731,-.7903),(.28684,54.55233,-.75417),(.27792,54.50466,-1.1729),(.27973,54.50297,-1.10888),(.13371,54.39503,-.77183),(.19292,54.44185,-.74566),(.19214,54.46622,-.8081),(.23923,54.49576,-.72766),(.27315,54.55185,-.76342),(.25087,54.51455,-.78142),(.27317,54.51795,-1.04171),(.31444,54.54581,-1.02984),(-.30976,54.5206,-1.19096),(-.32527,54.51216,-1.19392),(-.37101,54.54251,-1.1708),(-.42915,54.57541,-.95312),(-.30786,54.44928,-.74528),(-.14227,54.35562,-.68888),(-.21461,54.39556,-.70473),(0,54.34395,-.66602),(-.06806,54.34697,-.66921),(.30619,54.54054,-.75306),(.26812,54.48508,-.72154),(.36379,54.5663,-1.04463),(.37027,54.59235,-.938),(-.23718,54.47233,-1.21345),(.32145,54.51207,-1.20328),(.25706,54.46293,-1.21152),(.23624,54.47303,-1.21325),(.27477,54.54085,-.94499),(.30749,54.58503,-.9248),(.26606,54.54627,-.84861),(.21329,54.49055,-.89871),(.22132,54.49214,-1.06183),(.2211,54.49646,-.96745),(.357,54.57835,-.83018),(.3079,54.58187,-.81785),(.25121,54.49438,-.7188),(.3342,54.55606,-1.03143),(.32715,54.59401,-.92358),(.35331,54.56179,-1.11254),(.33102,54.54234,-1.16355),(.33177,54.55448,-1.10606),(.29696,54.51223,-1.19753),(.13931,54.46473,-1.20986),(.1566,54.45393,-1.20987),(.08074,54.44814,-1.19414),(-.27973,54.50297,-1.10888),(-.31305,54.54367,-1.10056),(-.29031,54.57612,-.82148),(-.28571,54.57291,-.79625),(-.19292,54.44185,-.74566),(-.13371,54.39503,-.77183),(-.30246,54.51971,-1.15806),(-.28679,54.55225,-.75428),(-.24593,54.41575,-1.06079),(-.29041,54.45913,-1.07599),(-.15693,54.3241,-.74834),(-.26481,54.35241,-.74579),(-.30832,54.41293,-.7611),(-.28627,54.36615,-.83663),(-.28292,54.38567,-.89576),(-.3289,54.43296,-.76974),(-.42375,54.55696,-.85331),(-.43673,54.552,-.96589),(-.422,54.56878,-1.0649),(-.38,54.54146,-1.16668),(-.39816,54.54925,-1.12241),(-.4018,54.5596,-1.12414),(.40381,54.49682,-.88495),(.18335,54.43247,-1.19146),(.19325,54.4172,-1.11685),(.23353,54.41002,-1.05602),(.16505,54.4032,-1.04964),(.34337,54.51257,-1.14957),(.39815,54.51667,-.97937),(.18765,54.42024,-1.12748),(.24443,54.35483,-.73129),(.41673,54.56855,-1.06306),(-.2972,54.51219,-1.19762),(.31004,54.52616,-1.17032),(-.21393,54.47352,-1.20401),(-.22911,54.474,-1.20657),(-.22382,54.47437,-1.19178),(-.19445,54.43357,-.70734),(-.20321,54.42306,-.70405),(-.13379,54.37176,-.71645),(.15742,54.32509,-.69493),(.34925,54.53468,-1.1798),(.36432,54.54272,-1.16923),(.38127,54.48415,-.81543),(-.41709,54.55717,-1.06837),(-.43669,54.53391,-.88149),(-.13931,54.46473,-1.20986),(-.27822,54.50508,-1.17276),(-.13471,54.44446,-.82965),(-.27315,54.55185,-.76342),(-.23923,54.49576,-.72766),(.06996,54.46246,-1.1991),(.28473,54.50731,-1.18852),(.22426,54.40389,-.70794),(-.34607,54.54167,-1.16737),(-.08918,54.4337,-1.17482),(.28571,54.57291,-.79625),(.29031,54.57612,-.82148),(.13471,54.44446,-.82965),(-.21329,54.49055,-.89871),(-.1337,54.4724,-.99003),(-.22388,54.40436,-.70762),(-.30791,54.58191,-.81784),(-.33424,54.55588,-1.03139),(.24593,54.41575,-1.06079),(.15693,54.3241,-.74834),(.27605,54.34615,-.77827),(.31187,54.40507,-.76777),(.26896,54.34574,-.75323),(.28292,54.38567,-.89576),(.3289,54.43296,-.76974),(.4211,54.5578,-.8524),(-.30949,54.52378,-1.17447),(-.32008,54.53013,-1.16656),(-.29906,54.43347,-.74368),(-.25893,54.3614,-.7364),(-.26197,54.46769,-.71864),(.08144,54.30354,-.67541),(.07662,54.31925,-.66822),(.26153,54.40041,-.98874),(.27446,54.40633,-.99005),(.25598,54.36501,-.73398),(.31439,54.45074,-.99433),(.37166,54.52038,-1.0744),(.07892,54.32259,-.7172),(0,54.32343,-.70543),(0,54.3469,-.78443),(.07781,54.36858,-.87392),(.07951,54.34501,-.79057),(0,54.36749,-.87347),(.15787,54.36508,-.88978),(.07836,54.38582,-.95726),(.15938,54.38839,-.97736),(-.26153,54.40041,-.98874),(-.27446,54.40633,-.99005),(-.08824,54.4211,-1.11765),(0,54.38505,-.95313),(-.07781,54.36858,-.87392),(-.07836,54.38582,-.95726),(-.15938,54.38839,-.97736),(-.08489,54.40429,-1.04178),(-.31439,54.45074,-.99433),(-.2846,54.50699,-1.1886),(-.0592,54.36923,-.71501),(-.06012,54.45536,-.92127),(-.05869,54.46557,-1.00181),(-.13435,54.46235,-.91158),(0,54.36835,-.71913),(0,54.45948,-.92838),(0,54.47031,-1.00782),(-.21834,54.47232,-1.14193),(-.13249,54.46576,-1.14964),(.32219,54.53253,-1.17884),(.1337,54.4724,-.99003),(.13435,54.46235,-.91158),(.06763,54.44091,-.83507),(.06012,54.45536,-.92127),(0,54.38899,-.78433),(.0592,54.36923,-.71501),(.06765,54.38999,-.78292),(0,54.48036,-1.08627),(.05869,54.46557,-1.00181),(.06252,54.47446,-1.08009),(0,54.46542,-1.20009),(.0637,54.46198,-1.1451),(0,54.46592,-1.1445),(.21834,54.47232,-1.14193),(-.3587,54.56155,-1.11383),(.25804,54.46871,-.71646),(.29715,54.43075,-.74307),(.06844,54.34575,-.66916),(0,54.43655,-1.1757),(0,54.44992,-1.19248),(.08918,54.4337,-1.17482),(.13249,54.46576,-1.14964),(0,54.44252,-.84302),(.1301,54.47914,-1.06893),(-.0637,54.46198,-1.1451),(-.06252,54.47446,-1.08009),(-.06763,54.44091,-.83507),(-.06765,54.38999,-.78292),(-.2744,54.35952,-.83715),(-.15787,54.36508,-.88978),(-.15917,54.34106,-.80085),(-.27006,54.37953,-.89539),(-.07951,54.34501,-.79057),(0,54.40217,-1.0319),(0,54.41855,-1.10895),(-.39815,54.51667,-.97937),(-.37166,54.52038,-1.0744),(.08489,54.40429,-1.04178),(.2744,54.35952,-.83715),(-.33194,54.55396,-1.10602),(.27006,54.37953,-.89539),(.15917,54.34106,-.80085),(.08824,54.4211,-1.11765)]),
          normal=Normal(vector=[(-.9786,-.1891,.0816),(-.9746,-.2019,-.0965),(-.8488,-.3413,.4037),(-.8184,-.5351,-.2094),(-.7792,-.5903,-.2104),(-.7761,-.0386,-.6295),(-.7735,.6276,.0879),(-.7664,-.6424,.0017),(-.7652,-.4757,.4338),(-.7566,.5979,-.2645),(-.748,.5543,.3651),(-.738,.6745,-.019),(-.7304,.6488,.2133),(-.7289,.5473,-.4114),(-.7029,-.4371,.5611),(-.6996,-.7118,-.0616),(-.6951,-.7025,-.1527),(-.6942,-.7118,.107),(-.6783,-.7142,-.1727),(-.6778,-.3914,.6224),(-.6725,-.4983,.5471),(-.6724,.7401,.0062),(-.6709,-.735,.0984),(-.6637,-.7248,-.1847),(-.6629,-.715,-.2221),(-.6505,.7437,-.1545),(-.6458,.2761,.7119),(-.6341,.7009,.3266),(-.6213,.7816,-.0546),(-.6148,-.7693,-.1739),(-.614,.7549,.2303),(-.6119,.7836,-.1069),(-.6037,-.7578,-.2475),(-.5976,.7846,-.1651),(-.5936,.652,.4718),(-.5875,-.768,-.2548),(-.5807,.7136,.3919),(-.5804,.8036,-.1315),(-.5765,.8016,-.1584),(-.5717,.8067,.1498),(-.5701,.8103,-.1354),(-.5695,-.8042,-.17),(-.5637,-.7863,-.2529),(-.5549,.8301,.0548),(-.5545,-.2285,.8002),(-.5496,.8354,-.0053),(-.5481,-.1759,.8177),(-.5336,-.3002,.7907),(-.5204,.8395,-.1563),(-.515,-.7004,.4942),(-.5058,.8623,-.0241),(-.5038,.013,.8637),(-.5035,.4676,.7266),(-.5003,-.2092,-.8402),(-.4929,.8618,-.1194),(-.4917,-.8538,-.1711),(-.4769,.8604,-.1796),(-.475,.8797,-.0215),(-.4628,-.3412,.8181),(-.4522,-.8395,-.3013),(-.4353,.8951,-.0963),(-.4305,.8826,-.1888),(-.3942,.7987,.4546),(-.3806,.1226,.9166),(-.3771,-.576,-.7252),(-.371,-.0236,.9283),(-.3626,-.077,.9288),(-.362,.4367,.8235),(-.3524,-.2262,.9081),(-.3479,.7148,.6067),(-.3331,.7829,-.5254),(-.3165,.8452,-.4308),(-.3116,.8942,-.3215),(-.2991,-.9102,-.2866),(-.2949,-.9491,-.1105),(-.2913,.9449,-.1494),(-.2846,-.9175,-.2779),(-.2798,.8641,.4184),(-.279,.9143,.2937),(-.2756,-.8828,.3803),(-.2711,.962,-.0317),(-.2668,-.9223,-.2796),(-.2618,.8219,.5059),(-.2559,-.9375,-.2357),(-.2464,.9646,-.0936),(-.241,-.0707,.9679),(-.2359,.9592,.1557),(-.2325,.9411,-.2454),(-.2227,.6217,-.7509),(-.2161,-.1195,.969),(-.2058,-.9508,-.2314),(-.1876,.9791,-.0783),(-.1794,.9803,.0831),(-.1776,.2725,-.9456),(-.169,.5779,-.7984),(-.1687,.978,-.1228),(-.1659,.9736,-.1567),(-.1513,-.9055,.3964),(-.1497,.9879,-.0406),(-.1137,-.8688,-.4819),(-.1094,.9872,.1157),(-.1084,.4266,.8979),(-.0962,.988,-.1206),(-.0934,.9946,-.0462),(-.0932,-.9305,-.3542),(-.0886,.5492,.831),(-.076,.8494,.5223),(-.0708,.3329,.9403),(-.0699,.8892,.4521),(-.0688,-.9573,-.2808),(-.0688,-.9668,-.2459),(-.0688,-.6294,-.774),(-.0604,.9943,-.088),(-.0578,-.4289,-.9015),(-.0571,.5673,-.8215),(-.0564,.6966,.7153),(-.0504,.4803,.8757),(-.0472,-.9128,-.4058),(-.0468,.9223,.3836),(-.0464,-.9712,-.2338),(-.035,.9876,.153),(-.031,.0702,.9971),(-.0282,-.9727,-.2305),(-.0271,-.9456,-.3241),(-.027,-.9734,-.2274),(-.024,.9272,.3738),(-.0214,-.9761,-.2165),(-.0212,-.9754,-.2193),(-.0189,.9923,.122),(-.0174,-.9794,-.2012),(-.0145,-.9769,-.213),(-.011,-.958,-.2867),(-.0097,.9987,-.0503),(-.0082,-.967,-.2548),(-.0022,.9959,-.0908),(-.0009,-.824,.5665),(-.0007,-.621,-.7838),(-.0007,-.8963,-.4435),(0,.0761,.9971),(0,.8628,.5055),(0,.9057,.424),(0,.9337,.3582),(0,.9872,.1593),(0,.9914,.1308),(0,.9975,-.0712),(0,.9936,-.1128),(0,-.9776,-.2104),(0,-.9776,-.2106),(0,-.9754,-.2203),(0,-.9721,-.2346),(0,-.9634,-.2682),(0,-.9345,-.356),(0,.5419,-.8404),(.0022,.9959,-.0908),(.0029,.6226,.7825),(.0082,-.967,-.2548),(.0097,.9987,-.0503),(.011,-.958,-.2867),(.0145,-.9769,-.213),(.0174,-.9794,-.2012),(.0189,.9923,.122),(.0212,-.9754,-.2193),(.0214,-.9761,-.2165),(.0235,-.9554,-.2943),(.0249,.703,.7108),(.0262,.0902,.9956),(.0268,.93,.3667),(.027,-.9734,-.2274),(.0282,-.9727,-.2305),(.035,.9876,.153),(.0379,.9129,.4065),(.0452,.4654,.884),(.0464,-.9712,-.2338),(.0578,-.9155,-.3982),(.0584,-.3848,-.9212),(.0604,.9943,-.088),(.0613,.2873,.9559),(.0645,.5717,-.818),(.0688,-.9668,-.2459),(.0688,-.9573,-.2808),(.0699,.8892,.4521),(.0713,-.9362,-.3442),(.076,.8494,.5223),(.0874,-.6263,-.7747),(.0891,-.8539,-.5128),(.0912,.9846,-.1493),(.094,.5386,.8373),(.0992,.3673,-.9248),(.1075,.4147,.9036),(.1083,.9922,-.0621),(.1156,.9865,.1163),(.1326,-.9079,.3976),(.1456,.6148,-.7751),(.1537,.9872,-.0432),(.1554,.9797,-.1268),(.1568,.9722,-.1739),(.193,.9779,-.0802),(.2023,.7916,-.5766),(.2046,.9733,.1041),(.2058,-.9508,-.2314),(.2061,.6586,-.7237),(.2112,.9344,-.2867),(.2134,.8936,-.395),(.2165,-.1316,.9674),(.2359,.9592,.1557),(.2362,-.0563,.9701),(.2464,.9646,-.0936),(.2559,-.9375,-.2357),(.2609,.8276,.4969),(.2668,-.9223,-.2796),(.2675,.9628,-.0385),(.2675,.567,-.7791),(.2729,.9476,-.166),(.2798,.8641,.4184),(.2839,-.8853,.3684),(.2979,-.9226,-.2452),(.2991,-.9102,-.2866),(.2992,-.9399,-.1647),(.3064,.8961,.3211),(.3523,-.2251,.9084),(.3525,-.0044,.9358),(.3609,-.5958,-.7174),(.3625,.4177,.8331),(.3702,.7206,.5863),(.3734,-.0778,.9244),(.3839,.584,-.7152),(.3867,.1303,.913),(.3942,.7987,.4546),(.401,.9069,-.1292),(.412,.8903,-.1941),(.4286,-.0512,-.902),(.4599,-.8218,-.3365),(.4603,.8688,-.1827),(.4658,.8849,-.0084),(.4679,.4867,.7377),(.4774,.8602,-.1791),(.478,-.3406,.8096),(.48,.8714,-.1011),(.4911,.8575,-.153),(.4962,.8677,-.0312),(.502,.0676,.8622),(.5066,-.7824,.3622),(.5162,.8419,-.1572),(.5303,-.2865,.7979),(.5328,-.8342,-.1423),(.5372,-.1807,.8239),(.5501,.8351,-.0049),(.5523,-.2334,.8003),(.5549,.8301,.0548),(.5637,-.7863,-.2529),(.5649,.813,-.1413),(.5705,.8073,.1509),(.5712,-.7982,-.1913),(.5758,.7138,.3987),(.576,-.7729,-.2661),(.5775,.8008,-.1589),(.5778,.8125,-.0782),(.5875,-.768,-.2548),(.5878,.6951,-.4138),(.5881,.629,.5084),(.5992,.7906,-.1263),(.6117,-.7717,-.1743),(.614,.7549,.2303),(.6317,.7016,.3296),(.6505,.7437,-.1545),(.655,-.7309,-.1919),(.6629,-.715,-.2221),(.6664,-.7452,.023),(.6675,.2952,.6836),(.6773,-.715,-.1732),(.6822,-.576,.4504),(.6951,-.7025,-.1527),(.7157,-.6979,-.0253),(.7237,.69,-.0131),(.7304,.6488,.2133),(.738,.6745,-.019),(.743,-.3944,.5406),(.7486,.6253,-.2204),(.757,-.6377,.1424),(.7609,-.4927,.4223),(.7647,.5075,.3971),(.7686,-.6397,-.002),(.7735,.6276,.0879),(.7943,-.2946,-.5313),(.8025,-.4613,.3784),(.8497,-.4812,-.2155),(.8516,-.4001,-.3387),(.8854,-.2462,.3943),(.9674,-.2071,-.1456),(.9688,-.208,.1351)]))),
      Shape(DEF='c4',
        appearance=Appearance(
          material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),shininess=0.050,specularColor=(.349,.349,.349))),
        geometry=IndexedFaceSet(DEF='c4_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,3,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,41,42,40,-1,43,44,45,-1,46,47,48,-1,45,49,50,-1,51,52,53,-1,54,55,56,-1,51,53,57,-1,58,59,45,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,70,67,-1,71,72,73,-1,74,75,76,-1,77,78,79,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,104,105,106,-1,107,108,109,-1,105,110,111,-1,112,113,114,-1,115,116,117,-1,118,119,120,-1,121,122,123,-1,121,124,125,-1,126,127,128,-1,129,130,128,-1,129,107,109,-1,128,131,132,-1,133,134,135,-1,107,136,137,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,147,148,119,-1,149,150,151,-1,151,150,152,-1,153,154,11,-1,155,156,157,-1,158,159,160,-1,161,162,163,-1,164,165,166,-1,167,168,169,-1,170,171,172,-1,173,116,174,-1,175,176,177,-1,178,176,179,-1,180,181,182,-1,183,184,185,-1,186,184,183,-1,187,188,189,-1,190,191,192,-1,193,194,195,-1,196,197,198,-1,199,200,201,-1,202,203,204,-1,205,206,207,-1,21,3,5,-1,58,208,64,-1,209,210,211,-1,37,212,213,-1,213,214,35,-1,215,216,217,-1,218,219,220,-1,221,222,223,-1,224,225,226,-1,224,226,33,-1,227,228,229,-1,230,227,231,-1,232,233,9,-1,154,232,9,-1,72,234,235,-1,7,73,236,-1,76,237,238,-1,239,240,241,-1,242,243,244,-1,239,241,245,-1,71,246,247,-1,208,60,64,-1,248,249,250,-1,251,252,253,-1,254,255,227,-1,256,252,257,-1,258,259,260,-1,261,262,263,-1,65,62,81,-1,63,67,70,-1,264,265,266,-1,267,268,269,-1,270,271,50,-1,272,273,51,-1,274,275,276,-1,277,186,278,-1,279,280,281,-1,282,283,284,-1,190,285,281,-1,286,287,196,-1,288,289,290,-1,193,195,291,-1,292,293,294,-1,204,295,296,-1,297,298,299,-1,95,300,301,-1,125,124,302,-1,138,303,145,-1,123,120,124,-1,304,94,93,-1,142,141,170,-1,103,305,306,-1,80,68,67,-1,146,137,136,-1,307,308,274,-1,132,309,310,-1,311,192,191,-1,312,313,189,-1,110,314,315,-1,316,164,134,-1,317,318,319,-1,320,321,322,-1,156,149,157,-1,323,324,325,-1,326,327,328,-1,329,330,331,-1,332,333,334,-1,335,336,337,-1,338,339,340,-1,341,342,336,-1,343,344,345,-1,346,347,348,-1,349,347,350,-1,337,351,348,-1,352,353,354,-1,355,356,357,-1,1,358,354,-1,359,356,360,-1,361,362,363,-1,364,365,366,-1,361,367,368,-1,369,370,371,-1,372,373,374,-1,369,375,376,-1,377,378,379,-1,378,380,381,-1,382,383,384,-1,385,386,387,-1,388,373,387,-1,389,380,390,-1,381,391,392,-1,381,393,394,-1,395,396,397,-1,398,399,400,-1,401,402,403,-1,404,405,406,-1,407,408,409,-1,410,406,411,-1,412,413,414,-1,415,416,417,-1,418,419,420,-1,403,421,422,-1,423,424,425,-1,426,427,428,-1,429,430,431,-1,432,433,434,-1,435,436,437,-1,438,439,440,-1,441,442,443,-1,443,435,434,-1,442,444,445,-1,446,447,448,-1,443,442,436,-1,449,450,451,-1,452,453,454,-1,449,451,455,-1,456,452,457,-1,458,459,460,-1,453,461,462,-1,333,463,464,-1,371,465,466,-1,467,332,334,-1,466,468,469,-1,463,333,470,-1,471,472,469,-1,473,474,475,-1,476,477,478,-1,479,480,481,-1,472,414,413,-1,482,483,484,-1,485,414,486,-1,487,488,489,-1,490,491,492,-1,493,490,492,-1,494,495,496,-1,497,498,499,-1,500,501,455,-1,502,477,503,-1,504,505,382,-1,506,505,507,-1,508,401,509,-1,510,511,512,-1,335,512,513,-1,356,514,515,-1,516,517,229,-1,518,519,329,-1,520,521,522,-1,523,524,525,-1,526,527,528,-1,529,530,531,-1,532,533,534,-1,535,528,536,-1,537,538,539,-1,540,541,542,-1,543,544,405,-1,415,545,546,-1,547,548,492,-1,549,550,551,-1,552,553,489,-1,554,555,556,-1,557,558,554,-1,559,560,561,-1,562,563,564,-1,495,565,566,-1,567,568,569,-1,570,571,572,-1,476,573,574,-1,575,576,577,-1,578,454,459,-1,407,409,406,-1,579,580,581,-1,582,583,584,-1,585,583,582,-1,586,587,588,-1,589,590,586,-1,591,592,448,-1,593,594,595,-1,490,493,412,-1,596,597,366,-1,598,599,600,-1,442,601,602,-1,448,603,604,-1,589,425,590,-1,493,487,605,-1,558,424,489,-1,606,440,581,-1,607,417,416,-1,608,580,609,-1,610,411,611,-1,439,612,613,-1,614,600,591,-1,615,616,617,-1,500,618,437,-1,462,454,453,-1,619,620,621,-1,622,623,624,-1,625,626,627,-1,628,567,629,-1,630,499,631,-1,632,633,495,-1,496,634,635,-1,565,636,637,-1,557,560,583,-1,638,639,559,-1,561,640,559,-1,641,549,642,-1,643,375,644,-1,645,646,647,-1,648,643,649,-1,610,611,394,-1,405,544,387,-1,650,372,651,-1,541,537,542,-1,539,504,652,-1,539,653,654,-1,655,519,656,-1,657,535,536,-1,658,388,659,-1,660,661,522,-1,401,531,543,-1,662,663,664,-1,531,530,543,-1,395,665,529,-1,399,526,528,-1,360,515,666,-1,515,667,668,-1,669,222,335,-1,670,671,672,-1,509,673,674,-1,675,676,420,-1,505,506,382,-1,677,678,507,-1,211,511,510,-1,346,357,679,-1,336,342,337,-1,567,564,680,-1,681,633,632,-1,424,583,585,-1,487,492,488,-1,555,550,549,-1,553,550,555,-1,682,485,683,-1,684,685,686,-1,614,687,685,-1,616,688,600,-1,621,478,689,-1,620,478,621,-1,503,476,603,-1,690,691,481,-1,692,693,694,-1,693,463,694,-1,691,471,695,-1,524,523,696,-1,465,467,468,-1,334,464,469,-1,501,462,461,-1,456,502,449,-1,456,449,453,-1,609,580,697,-1,449,502,450,-1,698,427,699,-1,447,698,448,-1,441,579,581,-1,429,700,500,-1,437,701,429,-1,433,432,702,-1,703,688,430,-1,704,426,428,-1,705,706,697,-1,704,582,707,-1,613,408,439,-1,673,422,431,-1,421,403,404,-1,708,420,615,-1,587,413,588,-1,605,412,493,-1,386,611,405,-1,409,577,709,-1,406,405,611,-1,692,663,710,-1,396,395,711,-1,528,527,661,-1,610,393,392,-1,712,411,610,-1,388,544,543,-1,379,372,374,-1,713,714,715,-1,380,391,381,-1,546,644,375,-1,646,377,379,-1,383,382,506,-1,716,522,521,-1,362,670,511,-1,38,717,363,-1,344,718,507,-1,719,720,721,-1,722,352,355,-1,353,723,1,-1,2,338,0,-1,724,346,725,-1,726,727,728,-1,513,719,729,-1,510,512,335,-1,332,730,470,-1,731,365,364,-1,329,331,732,-1,524,696,365,-1,400,399,733,-1,135,134,164,-1,734,735,736,-1,89,91,737,-1,738,315,89,-1,105,190,739,-1,105,740,190,-1,132,310,136,-1,737,91,275,-1,741,742,82,-1,145,303,743,-1,168,744,164,-1,93,175,304,-1,745,746,747,-1,748,200,749,-1,750,751,752,-1,753,291,195,-1,754,755,756,-1,281,285,283,-1,191,281,280,-1,757,758,759,-1,760,187,311,-1,761,186,277,-1,188,762,763,-1,764,53,52,-1,81,62,239,-1,261,765,257,-1,256,766,37,-1,253,73,767,-1,241,768,245,-1,240,238,237,-1,767,73,6,-1,769,232,234,-1,770,771,230,-1,772,230,231,-1,14,231,229,-1,228,224,32,-1,226,773,774,-1,775,221,20,-1,776,775,19,-1,301,218,98,-1,777,218,245,-1,213,212,778,-1,766,765,779,-1,46,212,766,-1,780,166,165,-1,120,148,124,-1,781,294,782,-1,178,783,784,-1,785,786,787,-1,788,789,752,-1,107,790,108,-1,763,791,325,-1,792,280,183,-1,182,793,87,-1,182,181,794,-1,795,88,325,-1,90,793,796,-1,176,784,177,-1,797,175,93,-1,167,171,165,-1,798,788,799,-1,149,796,800,-1,16,15,159,-1,801,802,149,-1,152,150,803,-1,801,151,804,-1,150,156,159,-1,805,147,138,-1,805,145,806,-1,807,141,143,-1,139,147,119,-1,140,143,303,-1,137,743,142,-1,747,746,798,-1,318,317,127,-1,808,735,734,-1,131,317,809,-1,118,810,127,-1,309,101,144,-1,120,123,810,-1,811,118,812,-1,192,314,739,-1,314,192,313,-1,780,811,813,-1,100,301,98,-1,216,215,814,-1,156,155,159,-1,87,90,323,-1,180,86,795,-1,815,816,817,-1,68,80,742,-1,95,97,82,-1,301,300,245,-1,7,818,114,-1,17,242,153,-1,819,63,54,-1,54,69,820,-1,821,56,55,-1,248,44,822,-1,60,208,61,-1,819,823,59,-1,823,819,54,-1,45,59,49,-1,824,57,825,-1,825,326,328,-1,826,827,828,-1,829,322,10,-1,40,827,830,-1,33,4,34,-1,29,773,831,-1,5,774,832,-1,833,834,835,-1,22,21,836,-1,24,837,833,-1,838,839,36,-1,840,20,835,-1,27,26,260,-1,841,20,221,-1,150,15,803,-1,842,770,772,-1,4,359,34,-1,30,831,28,-1,359,679,357,-1,13,842,772,-1,260,843,27,-1,212,37,766,-1,835,844,840,-1,838,845,839,-1,833,21,24,-1,833,835,841,-1,26,28,831,-1,5,4,774,-1,773,846,831,-1,33,774,4,-1,40,42,827,-1,829,10,847,-1,828,848,826,-1,849,825,57,-1,44,208,58,-1,824,51,57,-1,59,823,49,-1,54,56,823,-1,779,47,46,-1,60,65,64,-1,208,248,61,-1,248,208,44,-1,54,70,69,-1,63,70,54,-1,114,113,76,-1,76,8,114,-1,114,8,7,-1,218,301,245,-1,82,81,95,-1,850,102,741,-1,80,82,742,-1,87,323,88,-1,308,307,764,-1,814,92,216,-1,100,96,301,-1,315,314,313,-1,110,133,111,-1,173,851,116,-1,812,813,811,-1,123,318,810,-1,117,319,122,-1,127,126,118,-1,809,852,131,-1,734,853,808,-1,810,318,127,-1,811,780,139,-1,137,142,854,-1,303,138,140,-1,119,811,139,-1,807,143,140,-1,855,805,806,-1,855,148,805,-1,159,15,150,-1,801,804,849,-1,803,856,152,-1,149,151,801,-1,16,159,158,-1,149,800,157,-1,799,747,798,-1,165,744,167,-1,93,161,797,-1,176,178,784,-1,90,87,793,-1,182,794,857,-1,182,87,86,-1,311,187,189,-1,325,188,763,-1,188,325,324,-1,290,195,194,-1,178,858,783,-1,781,292,294,-1,202,199,859,-1,120,119,148,-1,165,807,780,-1,766,779,46,-1,778,327,213,-1,768,777,245,-1,775,210,209,-1,20,19,775,-1,774,33,226,-1,229,517,14,-1,231,14,772,-1,770,230,772,-1,769,860,232,-1,73,72,236,-1,237,241,240,-1,861,862,863,-1,241,237,768,-1,253,767,864,-1,37,865,256,-1,261,257,262,-1,866,263,822,-1,239,300,81,-1,764,867,53,-1,761,184,186,-1,311,185,760,-1,757,868,758,-1,280,792,191,-1,281,283,282,-1,203,754,756,-1,753,869,291,-1,752,204,750,-1,748,749,789,-1,172,745,747,-1,168,167,744,-1,870,871,305,-1,316,168,164,-1,170,172,747,-1,95,81,300,-1,82,850,741,-1,274,737,275,-1,132,136,129,-1,105,104,740,-1,89,737,738,-1,734,736,316,-1,135,164,166,-1,126,130,872,-1,521,520,873,-1,365,731,524,-1,516,329,732,-1,731,364,873,-1,332,470,333,-1,336,513,729,-1,679,350,347,-1,346,874,725,-1,337,348,347,-1,353,1,354,-1,722,355,357,-1,34,360,32,-1,507,875,344,-1,38,363,39,-1,511,363,362,-1,379,374,876,-1,506,877,383,-1,379,876,646,-1,546,545,644,-1,380,389,391,-1,369,546,375,-1,379,651,372,-1,544,388,387,-1,410,878,407,-1,610,879,712,-1,392,879,610,-1,711,880,396,-1,527,881,882,-1,409,709,406,-1,878,712,883,-1,615,884,708,-1,709,421,404,-1,431,674,673,-1,885,705,697,-1,428,582,704,-1,688,616,430,-1,451,434,455,-1,408,440,439,-1,429,886,700,-1,441,594,579,-1,581,444,441,-1,447,427,698,-1,699,702,698,-1,697,887,609,-1,449,461,453,-1,452,888,457,-1,455,501,461,-1,468,334,469,-1,467,334,468,-1,523,730,696,-1,471,464,695,-1,690,481,480,-1,503,477,476,-1,889,574,573,-1,478,477,689,-1,600,617,616,-1,614,685,479,-1,890,684,686,-1,682,683,484,-1,553,555,558,-1,556,555,549,-1,487,493,492,-1,424,557,583,-1,495,494,632,-1,632,891,681,-1,892,571,893,-1,564,894,680,-1,895,896,897,-1,346,679,347,-1,385,373,372,-1,898,211,510,-1,507,505,875,-1,507,718,677,-1,419,675,420,-1,674,899,509,-1,670,672,727,-1,669,335,337,-1,515,668,666,-1,360,666,32,-1,518,656,519,-1,731,873,520,-1,882,525,527,-1,528,733,399,-1,400,733,665,-1,395,400,665,-1,397,900,398,-1,664,534,901,-1,662,664,902,-1,881,901,903,-1,402,401,543,-1,660,522,716,-1,385,387,373,-1,658,659,904,-1,657,536,653,-1,655,656,905,-1,653,906,654,-1,340,907,908,-1,539,654,504,-1,541,538,537,-1,405,387,386,-1,393,610,394,-1,645,647,909,-1,643,644,649,-1,489,553,558,-1,561,554,640,-1,638,910,639,-1,557,561,560,-1,565,633,636,-1,633,565,495,-1,631,897,630,-1,628,911,567,-1,627,912,625,-1,623,913,624,-1,403,402,404,-1,914,500,700,-1,462,459,454,-1,437,429,500,-1,617,884,615,-1,612,575,613,-1,409,408,613,-1,608,606,580,-1,879,883,712,-1,558,557,424,-1,487,423,605,-1,425,428,590,-1,448,698,603,-1,602,436,442,-1,600,915,598,-1,366,916,596,-1,471,469,464,-1,412,917,490,-1,448,604,591,-1,586,588,589,-1,584,707,582,-1,580,606,581,-1,417,883,879,-1,406,410,407,-1,402,405,404,-1,918,621,689,-1,617,479,884,-1,570,680,571,-1,569,629,567,-1,495,566,919,-1,562,920,563,-1,559,639,560,-1,554,561,557,-1,556,640,554,-1,489,488,552,-1,642,549,551,-1,546,921,415,-1,922,923,924,-1,405,402,543,-1,539,652,537,-1,535,925,528,-1,529,665,530,-1,733,528,925,-1,523,525,882,-1,525,520,522,-1,329,516,518,-1,516,229,518,-1,32,666,228,-1,515,360,356,-1,513,336,335,-1,513,512,726,-1,673,509,403,-1,509,926,508,-1,507,715,506,-1,503,450,502,-1,500,455,618,-1,927,893,894,-1,499,630,497,-1,928,929,930,-1,568,570,474,-1,706,931,697,-1,491,547,492,-1,555,554,558,-1,485,486,683,-1,482,484,683,-1,490,917,932,-1,472,486,414,-1,481,884,479,-1,478,573,476,-1,473,475,918,-1,471,933,472,-1,470,694,463,-1,469,934,466,-1,467,935,332,-1,465,468,466,-1,464,334,333,-1,462,501,460,-1,459,462,460,-1,457,502,456,-1,455,461,449,-1,452,456,453,-1,475,936,918,-1,443,436,435,-1,446,448,592,-1,445,601,442,-1,434,595,443,-1,441,444,442,-1,701,602,703,-1,435,437,618,-1,434,451,432,-1,688,915,600,-1,585,425,424,-1,423,425,589,-1,432,451,450,-1,422,673,403,-1,420,708,418,-1,463,695,464,-1,917,412,414,-1,932,485,682,-1,937,938,939,-1,406,611,411,-1,404,406,709,-1,401,403,509,-1,398,400,397,-1,523,903,730,-1,397,400,395,-1,381,394,650,-1,392,393,381,-1,388,658,373,-1,651,378,650,-1,378,381,650,-1,378,651,379,-1,376,370,369,-1,713,678,370,-1,368,940,361,-1,364,366,597,-1,363,717,361,-1,360,34,359,-1,358,514,354,-1,356,359,357,-1,352,354,355,-1,723,2,1,-1,337,342,351,-1,348,874,346,-1,345,941,343,-1,336,729,341,-1,504,875,505,-1,340,0,338,-1,330,942,331,-1,326,213,327,-1,325,88,323,-1,320,322,829,-1,319,809,317,-1,316,134,734,-1,738,110,315,-1,312,189,324,-1,311,191,792,-1,84,83,66,-1,136,310,146,-1,103,102,850,-1,103,306,101,-1,142,170,943,-1,736,173,944,-1,304,174,94,-1,124,121,123,-1,145,805,138,-1,172,945,745,-1,297,946,298,-1,750,204,296,-1,292,205,293,-1,291,196,193,-1,286,196,291,-1,190,281,191,-1,282,284,947,-1,282,279,281,-1,792,185,311,-1,276,307,274,-1,272,51,267,-1,270,50,265,-1,264,270,265,-1,63,80,67,-1,65,60,62,-1,59,58,819,-1,866,261,263,-1,256,948,252,-1,227,230,254,-1,253,864,251,-1,250,61,248,-1,247,769,71,-1,239,245,300,-1,243,861,949,-1,818,112,114,-1,238,8,76,-1,238,6,8,-1,7,6,73,-1,154,234,232,-1,227,229,231,-1,33,32,224,-1,224,950,225,-1,223,841,221,-1,218,220,98,-1,217,951,215,-1,46,778,212,-1,213,326,214,-1,209,211,898,-1,21,5,24,-1,841,835,20,-1,204,749,202,-1,198,193,196,-1,192,739,190,-1,188,324,189,-1,186,183,952,-1,792,183,185,-1,182,86,180,-1,178,179,953,-1,175,177,944,-1,174,304,173,-1,170,165,171,-1,172,171,945,-1,164,744,165,-1,797,161,163,-1,158,160,79,-1,155,157,162,-1,11,17,153,-1,151,152,804,-1,149,156,150,-1,147,805,148,-1,144,806,145,-1,139,807,140,-1,138,147,139,-1,137,854,107,-1,780,807,139,-1,135,954,133,-1,132,129,128,-1,129,136,107,-1,126,128,130,-1,125,955,121,-1,101,309,102,-1,119,118,811,-1,120,810,118,-1,135,813,812,-1,115,174,116,-1,112,956,113,-1,105,111,106,-1,108,957,109,-1,98,220,99,-1,95,301,96,-1,94,216,92,-1,86,88,795,-1,324,323,312,-1,81,80,65,-1,235,244,72,-1,76,113,74,-1,69,67,66,-1,68,84,66,-1,741,85,742,-1,65,80,63,-1,239,62,61,-1,45,44,58,-1,327,958,328,-1,54,820,55,-1,51,273,52,-1,50,43,45,-1,48,778,46,-1,860,769,247,-1,40,210,41,-1,40,830,38,-1,35,37,213,-1,959,960,18,-1,29,831,30,-1,23,837,24,-1,961,962,776,-1,840,18,20,-1,221,775,209,-1,15,17,803,-1,13,772,14,-1,11,154,9,-1,233,232,860,-1,669,223,222,-1,4,679,359,-1,4,3,679,-1,770,963,964,-1,842,963,770,-1,242,861,243,-1,862,861,242,-1,838,35,965,-1,35,838,36,-1,776,18,961,-1,776,19,18,-1,966,23,25,-1,23,966,967,-1,968,31,30,-1,31,968,969,-1,23,843,837,-1,843,23,27,-1,844,258,970,-1,259,258,844,-1,828,42,971,-1,42,828,827,-1,972,326,825,-1,972,973,326,-1,12,974,975,-1,974,12,976,-1,963,829,847,-1,977,829,963,-1,826,830,827,-1,826,975,830,-1,804,321,972,-1,804,152,321,-1,271,779,978,-1,779,271,47,-1,863,79,78,-1,158,79,863,-1,979,980,981,-1,980,979,982,-1,163,817,816,-1,163,800,817,-1,276,849,867,-1,801,849,276,-1,215,77,814,-1,77,215,983,-1,984,112,985,-1,956,112,984,-1,318,122,319,-1,123,122,318,-1,871,125,305,-1,871,955,125,-1,131,83,132,-1,131,852,83,-1,853,737,808,-1,853,738,737,-1,853,134,133,-1,734,134,853,-1,812,126,872,-1,812,118,126,-1,743,143,142,-1,743,303,143,-1,943,747,799,-1,170,747,943,-1,787,953,815,-1,953,787,786,-1,180,325,791,-1,180,795,325,-1,986,815,987,-1,815,986,787,-1,988,989,990,-1,988,991,989,-1,990,791,992,-1,990,180,791,-1,198,993,994,-1,993,198,197,-1,868,278,758,-1,995,278,868,-1,996,997,998,-1,999,997,996,-1,785,986,287,-1,785,787,986,-1,1000,1001,298,-1,1002,1001,1000,-1,1003,1004,1005,-1,1003,1006,1004,-1,195,289,753,-1,290,289,195,-1,1007,859,781,-1,1007,754,859,-1,292,206,205,-1,292,201,206,-1,785,286,1008,-1,287,286,785,-1,748,1009,200,-1,748,1010,1009,-1,75,777,768,-1,75,981,777,-1,1011,1012,980,-1,951,1012,1011,-1,962,1013,41,-1,962,965,1013,-1,209,222,221,-1,209,898,222,-1,985,949,984,-1,949,985,243,-1,982,1014,1015,-1,1014,982,1016,-1,247,1017,860,-1,1017,247,1018,-1,1019,225,950,-1,225,1019,1020,-1,262,249,263,-1,262,251,249,-1,1021,254,1022,-1,254,1021,960,-1,1021,838,961,-1,845,838,1021,-1,58,63,819,-1,58,64,63,-1,261,43,978,-1,43,261,866,-1,47,1023,48,-1,1023,47,1024,-1,52,69,764,-1,52,820,69,-1,762,1025,763,-1,762,1026,1025,-1,1027,1028,1029,-1,1030,1028,1027,-1,1031,277,1032,-1,1031,761,277,-1,762,187,760,-1,187,762,188,-1,952,759,758,-1,952,279,759,-1,759,1033,757,-1,1033,759,947,-1,284,1034,1035,-1,284,1036,1034,-1,1034,1037,1038,-1,1034,1039,1037,-1,1040,293,1041,-1,293,1040,294,-1,755,1003,756,-1,755,1042,1003,-1,1043,1044,1045,-1,1046,1044,1043,-1,1047,1048,1045,-1,1047,288,1048,-1,1049,869,753,-1,1049,1040,869,-1,798,789,788,-1,798,748,789,-1,953,858,178,-1,953,786,858,-1,298,1050,1000,-1,946,1050,298,-1,1051,799,1052,-1,1051,943,799,-1,1053,799,788,-1,1052,799,1053,-1,135,780,813,-1,135,166,780,-1,1054,371,370,-1,1054,465,371,-1,364,1055,873,-1,1055,364,1056,-1,351,340,339,-1,907,340,351,-1,352,1057,353,-1,1058,1057,352,-1,1059,725,338,-1,1059,1060,725,-1,724,357,346,-1,724,722,357,-1,1061,1062,908,-1,1061,1063,1062,-1,345,875,1064,-1,875,345,344,-1,1065,916,1054,-1,596,916,1065,-1,670,1066,671,-1,670,362,1066,-1,1067,331,367,-1,732,331,1067,-1,974,717,38,-1,974,1067,717,-1,1068,646,876,-1,647,646,1068,-1,527,1069,881,-1,1069,527,526,-1,663,1070,710,-1,663,662,1070,-1,1071,880,711,-1,1071,1072,880,-1,921,369,371,-1,369,921,546,-1,466,1073,1074,-1,1073,466,934,-1,1075,431,430,-1,1075,674,431,-1,1076,463,693,-1,463,1076,695,-1,425,582,428,-1,425,585,582,-1,1077,396,880,-1,396,1077,1078,-1,703,915,688,-1,602,915,703,-1,575,409,613,-1,577,409,575,-1,914,575,612,-1,700,575,914,-1,598,1079,599,-1,598,1080,1079,-1,607,446,1079,-1,607,586,446,-1,593,702,699,-1,433,702,593,-1,887,578,609,-1,887,888,578,-1,889,478,620,-1,889,573,478,-1,574,591,604,-1,614,591,574,-1,685,912,686,-1,687,912,685,-1,486,933,937,-1,486,472,933,-1,1081,681,1082,-1,1083,681,1081,-1,1084,1085,1086,-1,1084,1087,1085,-1,1088,483,1082,-1,1088,1089,483,-1,891,1090,1088,-1,891,1091,1090,-1,1092,1093,1094,-1,1093,1092,1095,-1,1096,584,1097,-1,1096,707,584,-1,1098,891,632,-1,1098,1091,891,-1,929,1099,930,-1,929,1100,1099,-1,622,1101,623,-1,622,895,1101,-1,1102,562,911,-1,1102,1103,562,-1,1104,919,1105,-1,919,1104,634,-1,563,894,564,-1,927,894,563,-1,566,637,1106,-1,566,565,637,-1,1107,1108,1106,-1,1107,1109,1108,-1,624,936,1110,-1,624,619,936,-1,351,874,348,-1,351,339,874,-1,1111,1087,1084,-1,1111,1112,1087,-1,926,1113,1071,-1,926,1114,1113,-1,675,1070,1115,-1,419,1070,675,-1,674,676,899,-1,1075,676,674,-1,356,354,514,-1,356,355,354,-1,519,330,329,-1,519,1116,330,-1,733,530,665,-1,530,733,925,-1,1117,902,664,-1,1117,1118,902,-1,1117,1119,1118,-1,902,1120,662,-1,902,1118,1120,-1,661,536,528,-1,661,660,536,-1,388,530,659,-1,388,543,530,-1,653,660,906,-1,653,536,660,-1,519,1121,1116,-1,1121,519,655,-1,1062,1,0,-1,358,1,1062,-1,538,653,539,-1,538,657,653,-1,941,1121,1122,-1,941,1123,1121,-1,0,908,1062,-1,908,0,340,-1,728,720,719,-1,720,728,1122,-1,374,542,876,-1,540,542,374,-1,1124,922,924,-1,1124,909,922,-1,1125,380,378,-1,390,380,1125,-1,383,909,647,-1,909,383,922,-1,375,648,376,-1,648,375,643,-1,1126,552,548,-1,1126,1127,552,-1,1128,1129,1130,-1,1129,1128,1131,-1,1132,1133,1134,-1,1133,1132,1135,-1,553,1127,1136,-1,553,552,1127,-1,638,640,1137,-1,559,640,638,-1,1138,638,1139,-1,1138,910,638,-1,639,1140,1141,-1,910,1140,639,-1,1142,1140,1143,-1,1142,628,1140,-1,1144,1106,1108,-1,1144,566,1106,-1,1006,1145,1103,-1,1006,1146,1145,-1,1147,1148,1149,-1,1046,1148,1147,-1,1150,1151,1152,-1,1151,1150,1148,-1,1152,634,1104,-1,635,634,1152,-1,1105,499,498,-1,1105,1144,499,-1,474,569,568,-1,569,474,1097,-1,480,685,684,-1,685,480,479,-1,889,913,625,-1,913,889,620,-1,460,500,914,-1,500,460,501,-1,603,574,604,-1,603,476,574,-1,438,612,439,-1,458,612,438,-1,438,606,608,-1,438,440,606,-1,879,415,417,-1,879,392,415,-1,581,878,883,-1,878,581,407,-1,599,591,600,-1,591,599,592,-1,934,472,413,-1,469,472,934,-1,713,507,678,-1,713,715,507,-1,450,702,432,-1,450,503,702,-1,473,1097,474,-1,1097,473,1096,-1,473,1153,1096,-1,473,1154,1153,-1,709,576,421,-1,709,577,576,-1,1100,890,686,-1,1100,929,890,-1,570,475,474,-1,570,572,475,-1,566,1105,919,-1,566,1144,1105,-1,1155,1152,1151,-1,1155,635,1152,-1,1148,1043,1151,-1,1043,1148,1046,-1,1103,920,562,-1,1103,1145,920,-1,631,1144,1108,-1,499,1144,631,-1,1037,1143,1038,-1,1037,1142,1143,-1,1143,910,1138,-1,1143,1140,910,-1,1139,1137,1156,-1,638,1137,1139,-1,1137,556,1157,-1,1137,640,556,-1,488,548,552,-1,492,548,488,-1,642,1134,1133,-1,642,551,1134,-1,1130,1136,1127,-1,1136,1130,1129,-1,1158,548,547,-1,1158,1126,548,-1,1074,607,416,-1,1074,1073,607,-1,648,714,376,-1,924,714,648,-1,377,1125,378,-1,1125,377,1159,-1,876,537,1068,-1,542,537,876,-1,719,1160,729,-1,1160,719,721,-1,1063,1160,1161,-1,1160,1063,1061,-1,1123,345,1162,-1,345,1123,941,-1,906,1064,654,-1,1163,1064,906,-1,1116,1123,1164,-1,1123,1116,1121,-1,659,925,535,-1,659,530,925,-1,508,395,529,-1,711,395,508,-1,1118,1165,1120,-1,1119,1165,1118,-1,664,1166,1117,-1,664,901,1166,-1,527,522,661,-1,525,522,527,-1,524,520,525,-1,731,520,524,-1,1164,330,1116,-1,330,1164,1055,-1,518,228,656,-1,518,229,228,-1,222,510,335,-1,222,898,510,-1,692,418,693,-1,692,710,418,-1,509,1114,926,-1,509,899,1114,-1,1089,1084,1167,-1,1084,1089,1111,-1,622,1110,1168,-1,622,624,1110,-1,1101,1108,1109,-1,1101,631,1108,-1,563,1169,1170,-1,563,920,1169,-1,1106,1099,1107,-1,1106,637,1099,-1,680,568,567,-1,680,570,568,-1,1104,498,1171,-1,1105,498,1104,-1,911,564,567,-1,911,562,564,-1,1168,895,622,-1,1168,896,895,-1,1100,1107,1099,-1,1100,627,1107,-1,1098,1172,1091,-1,1098,1173,1172,-1,1174,1097,584,-1,569,1097,1174,-1,1175,547,491,-1,1158,547,1175,-1,1091,1176,1090,-1,1091,1172,1176,-1,1088,1111,1089,-1,1088,1090,1111,-1,1086,999,1177,-1,999,1086,1085,-1,1081,937,939,-1,1081,482,937,-1,482,486,937,-1,482,683,486,-1,938,480,684,-1,480,938,690,-1,889,614,574,-1,687,614,889,-1,458,608,459,-1,608,458,438,-1,885,699,705,-1,885,593,699,-1,586,447,446,-1,586,590,447,-1,883,444,581,-1,883,445,444,-1,579,697,580,-1,885,697,579,-1,443,594,441,-1,594,443,595,-1,700,576,575,-1,700,886,576,-1,701,436,602,-1,436,701,437,-1,900,1117,1166,-1,1117,900,1078,-1,710,419,418,-1,1070,419,710,-1,371,1074,921,-1,1074,371,466,-1,1113,1072,1071,-1,1165,1072,1113,-1,692,532,663,-1,532,692,694,-1,394,386,385,-1,386,394,611,-1,713,376,714,-1,713,370,376,-1,365,935,366,-1,365,696,935,-1,1178,368,1179,-1,1178,940,368,-1,368,331,942,-1,331,368,367,-1,671,1180,677,-1,671,1066,1180,-1,1065,1178,596,-1,1178,1065,1180,-1,1063,358,1062,-1,1063,667,358,-1,1181,1060,1059,-1,1182,1060,1181,-1,1057,1060,1182,-1,1058,1060,1057,-1,1183,1060,1058,-1,1184,1060,1183,-1,347,669,337,-1,349,669,347,-1,1181,338,2,-1,1181,1059,338,-1,1183,352,722,-1,1183,1058,352,-1,341,351,342,-1,341,907,351,-1,1056,330,1055,-1,330,1056,942,-1,857,993,987,-1,857,794,993,-1,152,322,321,-1,152,856,322,-1,319,1185,809,-1,1185,319,851,-1,85,132,83,-1,741,132,85,-1,310,144,146,-1,310,309,144,-1,306,144,101,-1,144,306,806,-1,174,1186,94,-1,174,115,1186,-1,100,121,955,-1,100,99,121,-1,297,945,946,-1,745,945,297,-1,784,169,177,-1,169,784,1050,-1,751,788,752,-1,1053,788,751,-1,294,1049,782,-1,294,1040,1049,-1,289,1047,1187,-1,1047,289,288,-1,1045,1188,1047,-1,1044,1188,1045,-1,1044,1147,1189,-1,1147,1044,1046,-1,1042,1006,1003,-1,1042,1146,1006,-1,1190,1040,1041,-1,1190,869,1040,-1,1036,1039,1034,-1,1036,296,1039,-1,1036,283,1191,-1,283,1036,284,-1,947,1035,1033,-1,947,284,1035,-1,279,947,759,-1,947,279,282,-1,1029,185,1027,-1,1029,760,185,-1,1032,1132,1031,-1,1135,1132,1032,-1,1030,1128,1028,-1,1131,1128,1030,-1,760,1026,762,-1,760,1029,1026,-1,268,51,824,-1,267,51,268,-1,270,47,271,-1,1024,47,270,-1,56,1192,823,-1,1192,56,821,-1,264,821,272,-1,266,821,264,-1,266,1192,821,-1,765,978,779,-1,978,765,261,-1,960,961,18,-1,1021,961,960,-1,258,26,1193,-1,260,26,258,-1,1022,845,1021,-1,1022,1194,845,-1,252,262,257,-1,252,251,262,-1,831,1193,26,-1,1193,831,846,-1,1022,230,771,-1,254,230,1022,-1,246,252,948,-1,246,253,252,-1,240,61,250,-1,240,239,61,-1,253,71,73,-1,253,246,71,-1,78,861,863,-1,949,861,78,-1,1195,982,979,-1,1016,982,1195,-1,243,1196,244,-1,985,1196,243,-1,234,153,235,-1,234,154,153,-1,160,92,814,-1,92,160,1197,-1,951,219,1012,-1,951,217,219,-1,1087,1198,991,-1,1087,1112,1198,-1,837,834,833,-1,837,843,834,-1,746,297,1010,-1,746,745,297,-1,1041,1199,1190,-1,1041,1002,1199,-1,286,869,1190,-1,286,291,869,-1,781,1200,1007,-1,1200,781,782,-1,199,749,200,-1,749,199,202,-1,206,200,1009,-1,206,201,200,-1,1002,783,1199,-1,1002,1000,783,-1,196,986,197,-1,196,287,986,-1,998,992,1025,-1,997,992,998,-1,758,186,952,-1,278,186,758,-1,1112,1201,1198,-1,1112,1176,1201,-1,997,990,992,-1,988,990,997,-1,180,989,181,-1,180,990,989,-1,815,179,816,-1,179,815,953,-1,736,168,316,-1,168,736,944,-1,171,169,945,-1,171,167,169,-1,957,133,954,-1,133,957,111,-1,738,133,110,-1,853,133,738,-1,852,308,83,-1,852,1202,308,-1,130,109,872,-1,129,109,130,-1,305,302,306,-1,302,305,125,-1,850,305,103,-1,305,850,870,-1,851,117,116,-1,117,851,319,-1,99,122,121,-1,115,122,99,-1,115,117,122,-1,1016,956,984,-1,1195,956,1016,-1,956,1195,1203,-1,216,1186,217,-1,216,94,1186,-1,89,323,90,-1,323,89,312,-1,74,981,75,-1,74,979,981,-1,983,78,77,-1,983,1204,78,-1,1196,72,244,-1,236,72,1196,-1,273,820,52,-1,273,55,820,-1,778,958,327,-1,778,48,958,-1,977,320,829,-1,977,1205,320,-1,842,977,963,-1,848,977,842,-1,39,210,40,-1,39,211,210,-1,973,214,326,-1,973,1206,214,-1,828,1206,1205,-1,971,1206,828,-1,773,225,846,-1,773,226,225,-1,960,255,254,-1,959,255,960,-1,31,832,29,-1,832,31,1207,-1,23,1208,27,-1,23,967,1208,-1,969,1207,31,-1,1207,969,1209,-1,260,834,843,-1,834,260,259,-1,964,847,233,-1,963,847,964,-1,849,972,825,-1,849,804,972,-1,669,836,223,-1,669,349,836,-1,350,836,349,-1,350,22,836,-1,7,1196,818,-1,7,236,1196,-1,11,803,17,-1,11,856,803,-1,517,12,14,-1,976,12,517,-1,16,242,17,-1,16,862,242,-1,965,961,838,-1,965,962,961,-1,1210,966,25,-1,1210,1211,966,-1,1212,30,28,-1,30,1212,968,-1,5,25,24,-1,5,1210,25,-1,1193,970,258,-1,1193,1020,970,-1,37,839,865,-1,36,839,37,-1,321,973,972,-1,973,321,320,-1,971,41,1013,-1,971,42,41,-1,13,975,826,-1,975,13,12,-1,830,974,38,-1,830,975,974,-1,50,978,43,-1,978,50,271,-1,68,85,84,-1,85,68,742,-1,158,862,16,-1,158,863,862,-1,980,1015,1011,-1,980,982,1015,-1,57,867,849,-1,53,867,57,-1,275,801,276,-1,802,801,275,-1,99,1186,115,-1,99,220,1186,-1,159,1197,160,-1,155,1197,159,-1,105,314,110,-1,105,739,314,-1,113,1203,74,-1,956,1203,113,-1,741,309,132,-1,309,741,102,-1,955,96,100,-1,955,871,96,-1,131,127,317,-1,127,131,128,-1,1213,1185,1214,-1,1213,1202,1185,-1,808,274,1213,-1,808,737,274,-1,135,872,954,-1,872,135,812,-1,155,161,1197,-1,155,162,161,-1,170,807,165,-1,141,807,170,-1,304,944,173,-1,304,175,944,-1,800,793,817,-1,800,796,793,-1,197,987,993,-1,987,197,986,-1,1085,991,988,-1,1085,1087,991,-1,794,994,993,-1,794,1215,994,-1,1201,198,994,-1,1201,1216,198,-1,1093,995,868,-1,1095,995,1093,-1,740,1052,1053,-1,740,104,1052,-1,198,1217,193,-1,198,1216,1217,-1,1008,786,785,-1,1008,858,786,-1,1001,299,298,-1,1001,207,299,-1,756,1005,295,-1,756,1003,1005,-1,753,1187,1049,-1,289,1187,753,-1,202,754,203,-1,754,202,859,-1,199,781,859,-1,199,292,781,-1,292,199,201,-1,293,207,1001,-1,293,205,207,-1,181,1215,794,-1,181,989,1215,-1,214,965,35,-1,214,1013,965,-1,980,777,981,-1,980,1012,777,-1,983,951,1011,-1,951,983,215,-1,217,220,219,-1,220,217,1186,-1,29,774,773,-1,29,832,774,-1,1218,233,860,-1,233,1218,964,-1,240,6,238,-1,767,6,240,-1,1219,984,949,-1,1014,984,1219,-1,1014,1016,984,-1,1015,1219,1204,-1,1015,1014,1219,-1,246,1018,247,-1,246,948,1018,-1,249,864,250,-1,251,864,249,-1,1017,1218,860,-1,1194,1218,1017,-1,255,950,227,-1,1019,950,255,-1,248,263,249,-1,263,248,822,-1,1017,865,839,-1,1017,1018,865,-1,959,1019,255,-1,1220,1019,959,-1,840,970,1220,-1,840,844,970,-1,866,44,43,-1,44,866,822,-1,1023,264,269,-1,1024,264,1023,-1,1024,270,264,-1,266,50,49,-1,265,50,266,-1,48,269,958,-1,269,48,1023,-1,55,272,821,-1,55,273,272,-1,1025,1221,998,-1,1025,1026,1221,-1,1029,1221,1026,-1,1029,1028,1221,-1,761,1030,1027,-1,761,1031,1030,-1,1032,278,995,-1,277,278,1032,-1,183,279,952,-1,183,280,279,-1,757,1222,1223,-1,1222,757,1033,-1,1038,1035,1034,-1,1035,1038,1224,-1,190,1225,285,-1,740,1225,190,-1,750,1225,751,-1,750,1191,1225,-1,1173,1226,1217,-1,1226,1173,1227,-1,1228,1045,1048,-1,1043,1045,1228,-1,194,288,290,-1,1226,288,194,-1,1048,288,1226,-1,1189,755,1229,-1,1042,755,1189,-1,1007,1188,1229,-1,1007,1200,1188,-1,1005,1037,1039,-1,1005,1004,1037,-1,176,797,179,-1,175,797,176,-1,946,169,1050,-1,945,169,946,-1,124,855,302,-1,148,855,124,-1,854,943,1051,-1,854,142,943,-1,764,83,308,-1,69,83,764,-1,66,83,69,-1,790,1052,104,-1,790,1051,1052,-1,192,189,313,-1,192,311,189,-1,736,1214,173,-1,735,1214,736,-1,796,802,90,-1,802,796,149,-1,1166,398,900,-1,1166,1069,398,-1,534,903,901,-1,903,534,533,-1,718,343,672,-1,344,343,718,-1,719,726,728,-1,719,513,726,-1,725,1184,724,-1,1060,1184,725,-1,353,1182,723,-1,1057,1182,353,-1,339,725,874,-1,338,725,339,-1,908,341,1061,-1,341,908,907,-1,362,940,1066,-1,361,940,362,-1,678,1054,370,-1,678,1065,1054,-1,974,732,1067,-1,976,732,974,-1,597,1056,364,-1,1056,597,1179,-1,717,367,361,-1,717,1067,367,-1,916,465,1054,-1,916,467,465,-1,384,647,1068,-1,383,647,384,-1,523,881,903,-1,881,523,882,-1,662,1115,1070,-1,662,1120,1115,-1,1072,1077,880,-1,1077,1072,1230,-1,937,690,938,-1,937,933,690,-1,414,932,917,-1,932,414,485,-1,587,934,413,-1,934,587,1073,-1,921,416,415,-1,921,1074,416,-1,884,1076,708,-1,481,1076,884,-1,423,588,605,-1,423,589,588,-1,426,706,705,-1,704,706,426,-1,1078,397,396,-1,397,1078,900,-1,455,435,618,-1,434,435,455,-1,914,458,460,-1,612,458,914,-1,1080,601,445,-1,598,601,1080,-1,1079,417,607,-1,417,1079,1080,-1,1079,592,599,-1,1079,446,592,-1,595,433,593,-1,595,434,433,-1,452,578,888,-1,452,454,578,-1,471,690,933,-1,471,691,690,-1,918,1154,473,-1,1154,918,689,-1,890,928,939,-1,929,928,890,-1,490,682,491,-1,490,932,682,-1,939,1083,1081,-1,928,1083,939,-1,1167,1086,1231,-1,1167,1084,1086,-1,491,1231,1175,-1,491,682,1231,-1,1082,891,1088,-1,681,891,1082,-1,641,1094,1157,-1,1094,641,1092,-1,1177,996,1232,-1,996,1177,999,-1,1083,930,636,-1,1083,928,930,-1,1101,626,623,-1,626,1101,1109,-1,1004,1103,1102,-1,1004,1006,1103,-1,634,495,919,-1,495,634,496,-1,927,1170,497,-1,927,563,1170,-1,896,630,897,-1,896,892,630,-1,637,930,1099,-1,930,637,636,-1,1168,572,571,-1,1168,1110,572,-1,926,711,508,-1,926,1071,711,-1,1114,1115,1113,-1,1115,1114,675,-1,670,512,511,-1,670,726,512,-1,726,670,727,-1,666,656,228,-1,666,668,656,-1,1162,716,521,-1,1163,716,1162,-1,667,1161,668,-1,1063,1161,667,-1,904,538,541,-1,904,657,538,-1,655,1122,1121,-1,720,1122,655,-1,343,1122,728,-1,1122,343,941,-1,394,372,650,-1,394,385,372,-1,645,1124,1159,-1,645,909,1124,-1,648,1124,924,-1,649,1124,648,-1,923,383,877,-1,922,383,923,-1,392,545,415,-1,392,391,545,-1,1232,1233,1234,-1,996,1233,1232,-1,1233,1130,1234,-1,1233,1128,1130,-1,1129,1132,1134,-1,1131,1132,1129,-1,1135,1092,1133,-1,1135,1095,1092,-1,550,1136,551,-1,550,553,1136,-1,1093,1156,1094,-1,1156,1093,1223,-1,1139,1224,1138,-1,1222,1224,1139,-1,1141,560,639,-1,1141,1174,560,-1,1141,628,629,-1,1141,1140,628,-1,1235,632,494,-1,1235,1098,632,-1,1155,1227,1235,-1,1227,1155,1228,-1,1149,1146,1147,-1,1149,1145,1146,-1,1150,1149,1148,-1,1150,1169,1149,-1,1150,1104,1171,-1,1152,1104,1150,-1,1142,911,628,-1,1142,1102,911,-1,1110,475,572,-1,475,1110,936,-1,625,623,626,-1,623,625,913,-1,1154,457,888,-1,1154,689,457,-1,609,459,608,-1,609,578,459,-1,931,887,697,-1,931,1153,887,-1,931,704,707,-1,704,931,706,-1,1082,482,1081,-1,1082,483,482,-1,366,467,916,-1,366,935,467,-1,598,602,601,-1,915,602,598,-1,702,603,698,-1,503,603,702,-1,487,424,423,-1,487,489,424,-1,1096,931,707,-1,1096,1153,931,-1,586,1073,587,-1,1073,586,607,-1,1154,887,1153,-1,1154,888,887,-1,1075,616,615,-1,1075,430,616,-1,429,422,886,-1,429,431,422,-1,620,624,913,-1,624,620,619,-1,889,912,687,-1,625,912,889,-1,936,621,918,-1,936,619,621,-1,1037,1102,1142,-1,1037,1004,1102,-1,1150,1170,1169,-1,1150,1171,1170,-1,920,1149,1169,-1,1149,920,1145,-1,635,494,496,-1,635,1235,494,-1,1235,635,1155,-1,1151,1228,1155,-1,1228,1151,1043,-1,1235,1173,1098,-1,1227,1173,1235,-1,1174,629,569,-1,1174,1141,629,-1,1174,583,560,-1,583,1174,584,-1,1138,1038,1143,-1,1224,1038,1138,-1,1222,1156,1223,-1,1139,1156,1222,-1,1157,1156,1137,-1,1157,1094,1156,-1,641,1133,1092,-1,1133,641,642,-1,1129,551,1136,-1,1129,1134,551,-1,1234,1127,1126,-1,1234,1130,1127,-1,1234,1158,1232,-1,1234,1126,1158,-1,649,389,390,-1,649,644,389,-1,924,877,714,-1,923,877,924,-1,646,1159,377,-1,1159,646,645,-1,390,1124,649,-1,390,1159,1124,-1,390,1125,1159,-1,1068,652,384,-1,537,652,1068,-1,504,1064,875,-1,654,1064,504,-1,1061,729,1160,-1,1061,341,729,-1,1161,721,905,-1,721,1161,1160,-1,1064,1162,345,-1,1064,1163,1162,-1,541,658,904,-1,540,658,541,-1,668,905,656,-1,905,668,1161,-1,1164,1162,521,-1,1162,1164,1123,-1,535,904,659,-1,904,535,657,-1,1163,660,716,-1,1163,906,660,-1,529,401,508,-1,401,529,531,-1,534,663,532,-1,663,534,664,-1,1165,1230,1072,-1,1230,1165,1119,-1,1069,901,881,-1,901,1069,1166,-1,873,1164,521,-1,1055,1164,873,-1,708,693,418,-1,1076,693,708,-1,899,675,1114,-1,899,676,675,-1,382,652,504,-1,382,384,652,-1,672,677,718,-1,672,671,677,-1,1089,484,483,-1,1089,1167,484,-1,895,631,1101,-1,895,897,631,-1,497,893,927,-1,630,893,497,-1,892,893,630,-1,627,686,912,-1,627,1100,686,-1,1171,497,1170,-1,498,497,1171,-1,680,893,571,-1,894,893,680,-1,571,896,1168,-1,571,892,896,-1,627,1109,1107,-1,627,626,1109,-1,1083,633,681,-1,1083,636,633,-1,1175,1232,1158,-1,1232,1175,1177,-1,549,1157,556,-1,1157,549,641,-1,1090,1112,1111,-1,1090,1176,1112,-1,1231,1177,1175,-1,1177,1231,1086,-1,1167,682,484,-1,1167,1231,682,-1,684,939,938,-1,890,939,684,-1,614,617,600,-1,614,479,617,-1,502,689,477,-1,689,502,457,-1,481,695,1076,-1,481,691,695,-1,427,705,699,-1,426,705,427,-1,427,590,428,-1,590,427,447,-1,417,445,883,-1,417,1080,445,-1,885,594,593,-1,594,885,579,-1,421,886,422,-1,421,576,886,-1,440,407,581,-1,408,407,440,-1,701,430,429,-1,701,703,430,-1,1078,1119,1117,-1,1078,1230,1119,-1,1077,1230,1078,-1,1075,420,676,-1,1075,615,420,-1,412,588,413,-1,605,588,412,-1,1120,1113,1115,-1,1120,1165,1113,-1,533,694,470,-1,533,532,694,-1,878,411,712,-1,410,411,878,-1,540,373,658,-1,540,374,373,-1,391,644,545,-1,391,389,644,-1,714,506,715,-1,714,877,506,-1,596,1179,597,-1,596,1178,1179,-1,1179,942,1056,-1,942,1179,368,-1,511,39,363,-1,511,211,39,-1,677,1065,678,-1,677,1180,1065,-1,1180,940,1178,-1,940,1180,1066,-1,667,514,358,-1,667,515,514,-1,905,720,655,-1,720,905,721,-1,723,1181,2,-1,1182,1181,723,-1,1184,722,724,-1,1184,1183,722,-1,728,672,343,-1,728,727,672,-1,903,470,730,-1,903,533,470,-1,732,517,516,-1,517,732,976,-1,332,696,730,-1,332,935,696,-1,1069,399,398,-1,1069,526,399,-1,1214,851,173,-1,1214,1185,851,-1,106,790,104,-1,108,790,106,-1,854,790,107,-1,854,1051,790,-1,145,137,146,-1,145,743,137,-1,871,97,96,-1,871,870,97,-1,1000,784,783,-1,1050,784,1000,-1,798,1010,748,-1,746,1010,798,-1,295,1039,296,-1,295,1005,1039,-1,1187,1188,1200,-1,1188,1187,1047,-1,1189,1188,1044,-1,1189,1229,1188,-1,1146,1189,1147,-1,1146,1042,1189,-1,1227,1048,1226,-1,1228,1048,1227,-1,193,1226,194,-1,193,1217,1226,-1,296,1191,750,-1,296,1036,1191,-1,285,1191,283,-1,285,1225,1191,-1,1224,1033,1035,-1,1033,1224,1222,-1,757,1093,868,-1,1223,1093,757,-1,1027,184,761,-1,1027,185,184,-1,995,1135,1032,-1,995,1095,1135,-1,1132,1030,1031,-1,1030,1132,1131,-1,1028,1233,1221,-1,1028,1128,1233,-1,1233,998,1221,-1,998,1233,996,-1,958,268,824,-1,268,958,269,-1,1192,49,823,-1,266,49,1192,-1,264,267,269,-1,264,272,267,-1,766,257,765,-1,766,256,257,-1,1220,18,840,-1,959,18,1220,-1,1220,1020,1019,-1,970,1020,1220,-1,839,1194,1017,-1,845,1194,839,-1,865,948,256,-1,948,865,1018,-1,1194,771,1218,-1,1022,771,1194,-1,767,250,864,-1,767,240,250,-1,76,768,237,-1,768,76,75,-1,1204,949,78,-1,1219,949,1204,-1,769,72,71,-1,72,769,234,-1,770,1218,771,-1,964,1218,770,-1,227,224,228,-1,227,950,224,-1,775,41,210,-1,776,41,775,-1,962,41,776,-1,814,79,160,-1,814,77,79,-1,1012,218,777,-1,1012,219,218,-1,991,1215,989,-1,1198,1215,991,-1,1010,299,1009,-1,1010,297,299,-1,1041,1001,1002,-1,1041,293,1001,-1,1229,754,1007,-1,1229,755,754,-1,1008,1190,1199,-1,1008,286,1190,-1,752,749,204,-1,752,789,749,-1,782,1187,1200,-1,1187,782,1049,-1,203,295,204,-1,203,756,295,-1,207,1009,299,-1,207,206,1009,-1,1199,858,1008,-1,1199,783,858,-1,1172,1217,1216,-1,1172,1173,1217,-1,1053,1225,740,-1,1225,1053,751,-1,763,992,791,-1,992,763,1025,-1,1176,1216,1201,-1,1176,1172,1216,-1,1198,994,1215,-1,1198,1201,994,-1,999,988,997,-1,1085,988,999,-1,817,987,815,-1,817,857,987,-1,793,857,817,-1,793,182,857,-1,797,816,179,-1,163,816,797,-1,944,169,168,-1,169,944,177,-1,163,157,800,-1,163,162,157,-1,954,109,957,-1,954,872,109,-1,735,1213,1214,-1,735,808,1213,-1,308,1213,274,-1,1202,1213,308,-1,809,1202,852,-1,1202,809,1185,-1,806,302,855,-1,302,806,306,-1,108,111,957,-1,111,108,106,-1,89,313,312,-1,89,315,313,-1,1197,93,92,-1,93,1197,161,-1,307,867,764,-1,307,276,867,-1,802,91,90,-1,275,91,802,-1,870,82,97,-1,82,870,850,-1,1203,979,74,-1,1195,979,1203,-1,1011,1204,983,-1,1011,1015,1204,-1,244,153,242,-1,235,153,244,-1,824,328,958,-1,824,825,328,-1,856,10,322,-1,856,11,10,-1,848,1205,977,-1,848,828,1205,-1,13,848,842,-1,826,848,13,-1,1206,1013,214,-1,1206,971,1013,-1,1205,973,320,-1,1206,973,1205,-1,846,1020,1193,-1,846,225,1020,-1,967,1212,1208,-1,967,968,1212,-1,967,969,968,-1,967,1209,969,-1,967,1211,1209,-1,1211,967,966,-1,832,1210,5,-1,832,1207,1210,-1,841,21,833,-1,223,21,841,-1,836,21,223,-1,27,1212,28,-1,27,1208,1212,-1,1207,1211,1210,-1,1207,1209,1211,-1,834,844,835,-1,834,259,844,-1,10,233,847,-1,233,10,9,-1,818,985,112,-1,818,1196,985,-1,3,350,679,-1,350,3,22,-1],creaseAngle=1.571,normalIndex=[28,332,129,-1,298,446,141,-1,878,517,975,-1,385,97,31,-1,388,246,598,-1,26,11,15,-1,1103,429,722,-1,159,289,298,-1,558,209,262,-1,1208,1079,1106,-1,384,662,299,-1,629,530,630,-1,276,890,693,-1,608,610,297,-1,170,192,297,-1,1147,1233,1113,-1,566,736,520,-1,1113,859,921,-1,484,495,220,-1,753,565,663,-1,484,220,203,-1,1117,970,1113,-1,1133,1221,1112,-1,929,1044,994,-1,810,980,1019,-1,652,841,980,-1,701,402,679,-1,887,1153,1157,-1,263,351,186,-1,1086,1164,1138,-1,196,712,448,-1,1050,1024,1142,-1,1026,751,673,-1,424,953,665,-1,1229,1150,1202,-1,922,541,906,-1,1045,800,1161,-1,872,898,892,-1,411,799,334,-1,898,1028,902,-1,389,818,741,-1,490,820,468,-1,215,586,745,-1,664,371,401,-1,664,907,1008,-1,140,40,29,-1,94,124,29,-1,94,411,334,-1,29,4,103,-1,1051,1054,766,-1,411,243,493,-1,1084,876,910,-1,742,534,789,-1,899,967,719,-1,978,992,586,-1,86,3,22,-1,22,3,35,-1,305,302,31,-1,55,18,146,-1,67,12,153,-1,505,225,682,-1,1065,1137,773,-1,1214,1196,1230,-1,1014,1207,1125,-1,1068,820,806,-1,1192,1194,1223,-1,1159,1194,1102,-1,881,768,947,-1,1134,811,864,-1,986,811,1134,-1,911,1015,1120,-1,1058,1151,1074,-1,391,567,378,-1,281,459,408,-1,116,382,138,-1,261,672,787,-1,198,237,363,-1,159,298,141,-1,1117,1198,1044,-1,271,259,606,-1,693,416,191,-1,191,107,276,-1,323,442,423,-1,926,684,549,-1,300,611,419,-1,831,1005,669,-1,831,669,530,-1,990,649,646,-1,1022,990,874,-1,839,464,385,-1,302,839,385,-1,402,857,325,-1,517,679,403,-1,1157,1226,1128,-1,1193,1170,1183,-1,238,483,344,-1,1193,1183,1077,-1,701,759,879,-1,1198,1133,1044,-1,1190,1052,1162,-1,949,813,832,-1,1124,1155,990,-1,707,813,783,-1,1228,1166,1191,-1,948,934,1035,-1,994,1112,1164,-1,929,980,841,-1,550,533,545,-1,595,501,638,-1,544,769,921,-1,529,536,484,-1,807,415,278,-1,784,986,914,-1,1130,1185,1135,-1,1098,1110,1017,-1,1058,1092,1135,-1,244,294,281,-1,578,435,527,-1,391,378,267,-1,111,201,156,-1,787,896,977,-1,1029,1013,809,-1,1229,1129,1111,-1,1008,907,1037,-1,1084,932,967,-1,401,745,907,-1,1064,665,953,-1,534,742,1014,-1,1161,1216,1181,-1,1086,1019,980,-1,719,493,243,-1,475,473,807,-1,103,447,315,-1,1072,1074,1151,-1,1182,1143,1120,-1,1028,972,1122,-1,1188,1065,1054,-1,27,195,309,-1,104,65,93,-1,18,86,146,-1,1160,1195,1149,-1,78,188,137,-1,637,518,993,-1,1212,1219,1232,-1,955,487,829,-1,157,236,44,-1,70,377,487,-1,296,338,219,-1,1007,1073,795,-1,792,1073,943,-1,829,319,795,-1,1057,950,852,-1,998,884,1062,-1,332,293,852,-1,791,884,709,-1,1009,1053,923,-1,1121,1139,1152,-1,1009,969,1055,-1,1030,1109,1158,-1,118,36,2,-1,1030,761,919,-1,379,462,125,-1,462,564,478,-1,656,503,482,-1,189,247,100,-1,14,36,100,-1,681,564,714,-1,478,655,589,-1,478,396,306,-1,77,407,498,-1,776,720,266,-1,149,105,123,-1,6,71,102,-1,763,439,136,-1,273,102,227,-1,74,469,210,-1,856,764,754,-1,939,933,815,-1,123,83,330,-1,90,150,258,-1,313,185,221,-1,575,733,704,-1,823,842,1021,-1,1063,1038,837,-1,343,187,790,-1,1210,1218,1197,-1,1197,1063,1021,-1,1218,1231,1091,-1,63,21,20,-1,1197,1218,1038,-1,359,502,808,-1,467,147,303,-1,359,808,661,-1,336,467,454,-1,167,257,163,-1,147,255,82,-1,1219,1220,1225,-1,1158,1209,1145,-1,1200,1212,1232,-1,1145,1211,1154,-1,1220,1219,1224,-1,1097,803,1154,-1,327,277,251,-1,52,96,19,-1,50,175,738,-1,803,210,469,-1,362,543,471,-1,193,210,328,-1,114,326,172,-1,91,288,222,-1,41,91,222,-1,670,866,711,-1,1067,1023,1080,-1,321,226,661,-1,361,96,308,-1,579,824,656,-1,871,824,1040,-1,61,149,295,-1,961,966,1002,-1,955,1002,767,-1,884,770,555,-1,596,621,646,-1,350,214,637,-1,399,270,347,-1,930,937,381,-1,835,836,535,-1,10,64,51,-1,952,991,680,-1,268,535,390,-1,286,301,452,-1,59,199,120,-1,42,121,71,-1,856,744,1011,-1,368,507,222,-1,248,427,581,-1,504,372,172,-1,46,101,98,-1,95,88,46,-1,152,130,81,-1,457,828,651,-1,866,987,1020,-1,412,329,217,-1,346,855,395,-1,52,8,39,-1,16,62,13,-1,671,303,257,-1,763,136,102,-1,1140,995,1132,-1,345,200,252,-1,310,200,345,-1,180,563,212,-1,112,66,180,-1,32,49,20,-1,843,1099,1087,-1,91,41,74,-1,1131,1105,1152,-1,695,272,166,-1,1218,1070,928,-1,20,179,48,-1,112,258,66,-1,41,114,53,-1,88,150,172,-1,918,790,1132,-1,431,754,764,-1,492,995,748,-1,260,227,155,-1,187,54,73,-1,1,166,32,-1,571,432,168,-1,321,525,837,-1,82,303,147,-1,142,34,117,-1,428,223,206,-1,25,190,176,-1,256,412,178,-1,1123,1080,1031,-1,819,973,866,-1,711,802,650,-1,987,924,984,-1,95,130,200,-1,239,139,152,-1,81,108,152,-1,320,248,451,-1,532,761,705,-1,706,307,470,-1,659,532,697,-1,260,155,306,-1,71,121,100,-1,335,118,264,-1,199,286,120,-1,452,579,461,-1,452,425,499,-1,110,214,241,-1,285,268,390,-1,43,14,72,-1,485,557,347,-1,149,51,42,-1,865,885,749,-1,51,64,42,-1,77,106,10,-1,720,835,535,-1,709,555,406,-1,555,240,204,-1,821,611,955,-1,1078,1114,985,-1,295,312,685,-1,847,796,815,-1,824,871,656,-1,1127,1156,1040,-1,606,966,961,-1,1007,1062,938,-1,487,377,829,-1,412,651,739,-1,785,973,819,-1,150,200,310,-1,114,222,326,-1,101,427,248,-1,372,427,101,-1,354,193,279,-1,133,30,75,-1,1,17,30,-1,432,420,166,-1,117,19,229,-1,34,19,117,-1,308,52,179,-1,554,1010,738,-1,1046,1082,1168,-1,1082,1220,1168,-1,1010,1097,1180,-1,937,930,1205,-1,1209,1200,1211,-1,1232,1225,1154,-1,226,82,255,-1,336,361,359,-1,336,359,147,-1,748,995,830,-1,359,361,502,-1,184,185,497,-1,21,184,20,-1,1210,1140,1132,-1,575,228,321,-1,837,844,575,-1,842,823,465,-1,771,420,733,-1,322,313,221,-1,486,440,830,-1,322,345,364,-1,73,439,187,-1,312,330,704,-1,83,123,6,-1,814,815,571,-1,563,469,212,-1,53,74,41,-1,247,155,71,-1,136,13,37,-1,102,71,155,-1,1046,885,974,-1,407,77,80,-1,535,836,557,-1,260,396,589,-1,511,227,260,-1,14,121,42,-1,125,118,2,-1,1119,875,1075,-1,564,655,478,-1,1011,705,761,-1,307,379,125,-1,503,656,871,-1,341,347,270,-1,1053,1078,966,-1,608,868,923,-1,338,945,1040,-1,132,60,33,-1,1088,1057,998,-1,950,583,332,-1,129,157,28,-1,976,1007,678,-1,779,883,162,-1,767,132,92,-1,961,1002,955,-1,1212,1222,1224,-1,850,1139,1121,-1,637,993,846,-1,937,1205,1139,-1,266,720,356,-1,766,1054,1065,-1,1217,1186,1204,-1,1026,673,1043,-1,1171,1122,1026,-1,898,1058,927,-1,898,981,1058,-1,103,315,243,-1,1043,673,415,-1,476,959,1138,-1,967,932,584,-1,1196,1184,1065,-1,953,1192,1064,-1,1093,997,960,-1,854,382,474,-1,1041,1032,935,-1,282,267,378,-1,413,694,780,-1,1135,1092,1110,-1,1151,1135,1185,-1,863,996,1004,-1,737,911,1072,-1,647,986,784,-1,1015,734,858,-1,373,220,495,-1,1164,1112,1193,-1,948,777,783,-1,707,597,693,-1,832,679,964,-1,1183,1177,1077,-1,1170,1128,1226,-1,964,679,878,-1,880,839,857,-1,725,1039,1022,-1,639,1022,874,-1,598,874,646,-1,649,831,629,-1,669,466,352,-1,249,300,722,-1,458,249,429,-1,1111,926,922,-1,963,926,1077,-1,191,416,365,-1,597,777,762,-1,566,416,597,-1,752,773,1137,-1,745,992,907,-1,164,156,213,-1,1159,1060,1199,-1,414,903,804,-1,957,893,935,-1,411,758,799,-1,858,941,1149,-1,1163,1185,1134,-1,947,915,1024,-1,947,768,727,-1,1094,1142,1149,-1,751,915,410,-1,1194,1199,1223,-1,1049,1192,953,-1,1214,1207,1137,-1,982,957,908,-1,86,410,522,-1,11,26,12,-1,89,165,86,-1,35,3,23,-1,89,22,24,-1,3,18,12,-1,1141,978,1084,-1,1141,967,1085,-1,904,742,789,-1,876,978,586,-1,910,789,932,-1,493,584,534,-1,960,997,982,-1,195,27,40,-1,1172,1186,1217,-1,4,27,160,-1,215,173,40,-1,447,1045,899,-1,745,401,173,-1,417,215,409,-1,1074,972,927,-1,972,1074,1143,-1,752,417,430,-1,906,1111,922,-1,442,323,292,-1,18,55,12,-1,1024,751,1160,-1,881,1050,1094,-1,917,931,894,-1,1019,1086,959,-1,1229,1202,1138,-1,1111,1129,1077,-1,517,453,741,-1,15,238,305,-1,900,929,753,-1,753,652,582,-1,526,663,565,-1,1190,1233,1174,-1,1133,1198,1221,-1,900,772,970,-1,772,900,753,-1,1113,970,859,-1,314,203,126,-1,126,78,137,-1,253,218,148,-1,122,93,97,-1,297,218,366,-1,530,446,630,-1,384,466,909,-1,141,352,231,-1,437,920,869,-1,289,159,445,-1,209,688,437,-1,936,1016,890,-1,1144,722,869,-1,1079,1208,1191,-1,397,722,300,-1,3,26,23,-1,202,725,639,-1,446,791,630,-1,662,909,1106,-1,791,938,1062,-1,246,202,639,-1,1191,1001,1079,-1,416,693,597,-1,869,1167,1144,-1,936,1108,1016,-1,437,159,209,-1,437,869,397,-1,1208,1106,909,-1,141,446,352,-1,466,944,909,-1,530,352,446,-1,297,192,218,-1,122,97,113,-1,148,182,253,-1,76,126,203,-1,1233,1198,1117,-1,314,484,203,-1,970,772,859,-1,753,663,772,-1,762,736,566,-1,1133,994,1044,-1,1198,1190,1221,-1,1190,1198,1233,-1,753,841,652,-1,929,841,753,-1,741,818,1157,-1,1157,975,741,-1,741,975,517,-1,926,1111,1077,-1,1138,1164,1229,-1,1101,800,476,-1,1086,1138,959,-1,1024,1160,1142,-1,473,475,373,-1,292,424,442,-1,906,1150,1111,-1,1122,972,1143,-1,1028,1051,902,-1,1068,703,820,-1,409,430,417,-1,401,195,173,-1,468,309,371,-1,40,140,215,-1,160,134,4,-1,1217,1213,1172,-1,173,195,40,-1,417,752,876,-1,493,534,508,-1,932,1084,910,-1,586,417,876,-1,904,789,910,-1,1076,1141,1085,-1,1076,992,1141,-1,12,26,3,-1,89,24,76,-1,23,45,35,-1,86,22,89,-1,11,12,67,-1,86,522,146,-1,908,960,982,-1,1137,1184,1214,-1,953,505,1049,-1,1194,1159,1199,-1,751,1024,915,-1,947,727,870,-1,947,1024,1050,-1,1072,911,1120,-1,1149,1015,858,-1,1015,1149,1195,-1,527,378,567,-1,1159,979,1060,-1,164,111,156,-1,261,116,154,-1,745,586,992,-1,1137,904,752,-1,597,762,566,-1,365,188,191,-1,1177,963,1077,-1,249,259,271,-1,722,429,249,-1,352,530,669,-1,646,621,598,-1,874,598,639,-1,725,1022,639,-1,880,962,839,-1,679,402,403,-1,1226,1183,1170,-1,556,245,283,-1,1183,1226,1177,-1,832,964,989,-1,693,886,707,-1,948,783,934,-1,1115,1035,1174,-1,1193,1129,1164,-1,373,169,220,-1,647,811,986,-1,1072,864,737,-1,863,853,996,-1,1185,1163,1151,-1,1135,1110,1098,-1,672,413,780,-1,282,205,267,-1,935,787,1041,-1,854,474,893,-1,1125,1093,960,-1,1196,1214,1184,-1,1215,1173,1216,-1,1188,1196,1065,-1,1014,1125,960,-1,1229,1164,1129,-1,1138,1101,476,-1,807,1043,415,-1,103,243,94,-1,898,872,981,-1,1026,1043,1171,-1,1217,1204,1188,-1,766,1065,773,-1,140,124,393,-1,270,399,774,-1,1139,850,937,-1,596,637,846,-1,850,1121,774,-1,1212,1224,1219,-1,487,767,92,-1,938,943,1073,-1,1007,546,678,-1,829,795,1073,-1,950,332,852,-1,1088,998,1062,-1,630,709,629,-1,1040,585,338,-1,608,923,610,-1,966,923,1053,-1,125,2,85,-1,871,724,503,-1,125,85,307,-1,1011,744,705,-1,564,681,655,-1,1030,1011,761,-1,125,264,118,-1,121,14,100,-1,273,788,763,-1,260,436,511,-1,589,436,260,-1,80,349,407,-1,836,891,912,-1,136,37,102,-1,788,511,1042,-1,571,318,814,-1,37,83,6,-1,704,685,312,-1,901,486,830,-1,221,345,322,-1,420,432,733,-1,808,1021,661,-1,439,790,187,-1,575,311,228,-1,1210,1099,1140,-1,1132,1231,1210,-1,21,185,184,-1,497,465,184,-1,830,713,748,-1,359,255,147,-1,467,692,454,-1,661,226,255,-1,1211,1232,1154,-1,1200,1232,1211,-1,930,1222,1205,-1,1097,1225,1180,-1,554,738,175,-1,308,96,52,-1,5,39,8,-1,19,96,229,-1,166,168,432,-1,1,30,50,-1,183,133,75,-1,354,279,471,-1,372,101,88,-1,98,101,248,-1,114,41,222,-1,150,95,200,-1,866,670,819,-1,819,827,785,-1,1096,855,1118,-1,651,971,739,-1,873,1000,1036,-1,1007,938,1073,-1,189,36,118,-1,609,606,961,-1,1040,824,585,-1,1040,945,1127,-1,933,847,815,-1,685,551,295,-1,1078,985,883,-1,821,955,829,-1,555,204,406,-1,709,406,629,-1,350,241,214,-1,850,774,399,-1,912,381,836,-1,535,356,720,-1,266,356,106,-1,77,266,106,-1,498,888,776,-1,749,680,755,-1,865,749,794,-1,891,755,999,-1,105,149,42,-1,485,347,341,-1,189,100,36,-1,43,72,181,-1,285,390,425,-1,110,241,79,-1,425,463,499,-1,44,68,7,-1,452,499,579,-1,199,301,286,-1,71,100,247,-1,396,260,306,-1,706,470,723,-1,532,705,697,-1,172,372,88,-1,81,46,108,-1,239,211,139,-1,95,81,130,-1,987,973,924,-1,973,987,866,-1,1031,1036,1123,-1,256,339,412,-1,176,38,25,-1,223,47,206,-1,123,105,6,-1,197,321,228,-1,82,257,303,-1,837,575,321,-1,168,318,571,-1,54,16,73,-1,136,439,73,-1,492,918,995,-1,436,1042,511,-1,88,95,150,-1,114,90,53,-1,258,221,66,-1,20,184,179,-1,928,1038,1218,-1,166,500,695,-1,1152,1169,1131,-1,1097,1154,1225,-1,74,87,91,-1,20,48,32,-1,180,212,112,-1,252,364,345,-1,995,918,1132,-1,754,1042,436,-1,102,273,763,-1,105,71,6,-1,274,117,229,-1,168,50,318,-1,346,739,855,-1,217,178,412,-1,866,1020,954,-1,457,540,828,-1,152,139,130,-1,46,81,95,-1,98,108,46,-1,172,326,504,-1,451,248,581,-1,1011,1061,856,-1,553,514,588,-1,71,105,42,-1,452,461,286,-1,268,280,535,-1,10,106,64,-1,356,535,280,-1,930,381,912,-1,381,399,347,-1,637,596,350,-1,596,646,350,-1,629,406,649,-1,555,709,884,-1,767,487,955,-1,767,1002,779,-1,312,295,123,-1,295,265,61,-1,1040,1075,871,-1,308,502,361,-1,321,661,525,-1,1081,1118,971,-1,1080,1123,1067,-1,434,333,826,-1,329,346,277,-1,440,479,830,-1,288,368,222,-1,101,46,88,-1,193,328,279,-1,362,471,279,-1,91,87,158,-1,803,328,210,-1,738,318,50,-1,19,8,52,-1,327,251,274,-1,1097,698,803,-1,1224,1168,1220,-1,1154,1066,1145,-1,1200,1189,1212,-1,1209,1211,1145,-1,1225,1232,1219,-1,82,226,163,-1,257,82,163,-1,454,361,336,-1,661,255,359,-1,467,336,147,-1,251,234,274,-1,1197,1038,1063,-1,63,20,49,-1,1091,1070,1218,-1,1021,1087,1197,-1,1210,1231,1218,-1,844,928,771,-1,1063,837,525,-1,1021,808,823,-1,420,500,166,-1,310,258,150,-1,90,258,112,-1,823,808,502,-1,330,312,123,-1,815,814,939,-1,1220,1180,1225,-1,87,74,210,-1,158,193,354,-1,342,304,316,-1,102,155,227,-1,6,102,37,-1,149,123,295,-1,776,266,498,-1,930,999,1222,-1,498,266,77,-1,478,306,335,-1,589,396,478,-1,14,43,36,-1,264,462,335,-1,462,478,335,-1,462,264,125,-1,919,1109,1030,-1,1119,1156,1109,-1,1055,1095,1009,-1,1121,1152,1105,-1,923,868,1009,-1,709,630,791,-1,293,770,852,-1,884,791,1062,-1,1057,852,998,-1,583,129,332,-1,829,377,319,-1,795,546,1007,-1,219,127,296,-1,487,92,70,-1,579,585,824,-1,44,28,157,-1,518,1034,993,-1,78,191,188,-1,1149,1142,1160,-1,104,93,122,-1,309,160,27,-1,1188,1054,1217,-1,1171,1028,1122,-1,1182,1120,1195,-1,1072,1151,1163,-1,712,196,810,-1,243,315,719,-1,1161,800,1101,-1,1161,1181,1045,-1,534,1014,798,-1,1204,1068,1235,-1,1064,806,665,-1,907,664,401,-1,967,1141,1084,-1,1125,1201,1093,-1,1029,1187,1013,-1,1041,787,977,-1,111,198,201,-1,267,281,391,-1,244,281,267,-1,1058,1135,1151,-1,1098,1017,988,-1,1098,1130,1135,-1,1163,864,1072,-1,278,475,807,-1,529,484,595,-1,544,921,533,-1,550,544,533,-1,929,1086,980,-1,994,1133,1112,-1,970,1117,900,-1,1115,948,1035,-1,707,775,813,-1,990,1022,1124,-1,832,989,949,-1,1162,1221,1190,-1,879,880,701,-1,1193,1077,1129,-1,483,556,488,-1,453,389,741,-1,1128,975,1157,-1,1128,878,975,-1,517,878,679,-1,302,857,839,-1,990,646,874,-1,530,629,831,-1,831,1033,1005,-1,419,397,300,-1,926,549,922,-1,423,370,323,-1,566,365,416,-1,191,78,107,-1,271,606,609,-1,159,141,209,-1,397,869,722,-1,787,474,261,-1,408,391,281,-1,1074,927,1058,-1,1015,1195,1120,-1,986,1134,1146,-1,1163,1134,864,-1,947,1050,881,-1,1159,1102,1048,-1,1192,1223,1235,-1,806,1064,1068,-1,1014,1137,1207,-1,1125,1207,1201,-1,1065,1184,1137,-1,1049,505,682,-1,67,153,186,-1,55,146,225,-1,31,15,305,-1,22,35,24,-1,86,18,3,-1,978,1141,992,-1,899,1085,967,-1,876,904,910,-1,1084,978,876,-1,493,508,411,-1,752,904,876,-1,766,716,1051,-1,103,94,29,-1,94,243,411,-1,140,29,124,-1,1008,925,664,-1,1045,447,800,-1,586,215,417,-1,745,173,215,-1,766,430,409,-1,490,806,820,-1,389,394,818,-1,898,902,892,-1,799,750,334,-1,922,549,541,-1,1229,1111,1150,-1,665,442,424,-1,1050,1142,1094,-1,1195,1160,1182,-1,1164,1086,994,-1,325,344,402,-1,1157,818,887,-1,652,980,810,-1,1019,712,810,-1,476,448,959,-1,994,1086,929,-1,1193,1112,1221,-1,1113,1233,1117,-1,188,360,137,-1,753,582,565,-1,484,536,495,-1,921,1147,1113,-1,520,365,566,-1,962,880,879,-1,297,259,170,-1,297,366,608,-1,276,693,191,-1,1203,1175,1103,-1,384,909,662,-1,558,688,209,-1,1069,355,458,-1,1144,1103,722,-1,300,249,271,-1,26,15,23,-1,246,639,598,-1,31,302,385,-1,464,839,962,-1,821,419,611,-1,446,938,791,-1,446,298,938,-1,725,151,731,-1,202,151,725,-1,238,556,483,-1,245,556,238,-1,936,276,235,-1,276,936,890,-1,458,1103,1069,-1,458,429,1103,-1,324,558,262,-1,558,324,559,-1,548,299,662,-1,299,548,348,-1,558,1001,688,-1,1001,558,1079,-1,1167,1228,1234,-1,1166,1228,1167,-1,148,192,131,-1,192,148,218,-1,69,78,126,-1,69,84,78,-1,388,607,398,-1,607,388,604,-1,151,122,113,-1,135,122,151,-1,253,366,218,-1,253,398,366,-1,24,65,69,-1,24,35,65,-1,769,762,946,-1,762,769,736,-1,283,186,351,-1,67,186,283,-1,740,560,942,-1,560,740,438,-1,682,894,931,-1,682,522,894,-1,278,76,169,-1,89,76,278,-1,323,263,292,-1,263,323,275,-1,418,389,444,-1,394,389,418,-1,195,371,309,-1,401,371,195,-1,1173,1008,1216,-1,1173,925,1008,-1,4,196,103,-1,4,134,196,-1,1213,1043,1172,-1,1213,1171,1043,-1,1213,1054,1051,-1,1217,1054,1213,-1,409,140,393,-1,409,215,140,-1,584,789,534,-1,584,932,789,-1,798,960,908,-1,1014,960,798,-1,804,1048,917,-1,1048,804,903,-1,881,1149,941,-1,881,1094,1149,-1,654,917,816,-1,917,654,804,-1,574,568,667,-1,574,538,568,-1,667,941,715,-1,667,881,941,-1,408,592,481,-1,592,408,459,-1,853,914,996,-1,757,914,853,-1,626,562,521,-1,632,562,626,-1,414,654,294,-1,414,804,654,-1,1047,460,1013,-1,450,460,1047,-1,765,605,812,-1,765,613,605,-1,378,435,282,-1,527,435,378,-1,367,154,164,-1,367,413,154,-1,111,237,198,-1,111,138,237,-1,414,244,433,-1,294,244,414,-1,854,509,382,-1,854,916,509,-1,1153,963,1177,-1,1153,942,963,-1,331,708,560,-1,370,708,331,-1,355,115,170,-1,355,235,115,-1,271,611,300,-1,271,609,611,-1,444,488,418,-1,488,444,483,-1,438,421,353,-1,421,438,404,-1,879,1003,962,-1,1003,879,897,-1,1176,1005,1033,-1,1005,1176,1178,-1,934,1052,1035,-1,934,949,1052,-1,1136,1124,1116,-1,1124,1136,1175,-1,1136,936,1069,-1,1108,936,1136,-1,1117,929,900,-1,1117,1044,929,-1,948,1147,946,-1,1147,948,1115,-1,736,700,520,-1,700,736,690,-1,495,652,373,-1,495,582,652,-1,734,687,858,-1,734,593,687,-1,561,512,552,-1,519,512,561,-1,539,784,653,-1,539,647,784,-1,734,911,737,-1,911,734,1015,-1,1146,1004,996,-1,1146,1130,1004,-1,1004,861,863,-1,861,1004,988,-1,1017,849,862,-1,1017,1025,849,-1,849,602,599,-1,849,848,602,-1,171,201,207,-1,201,171,156,-1,694,765,780,-1,694,735,765,-1,619,691,660,-1,617,691,619,-1,570,648,660,-1,570,578,648,-1,224,205,282,-1,224,171,205,-1,982,893,957,-1,982,854,893,-1,1048,979,1159,-1,1048,903,979,-1,1013,1206,1047,-1,1187,1206,1013,-1,781,908,895,-1,781,798,908,-1,965,908,957,-1,895,908,965,-1,766,752,430,-1,766,773,752,-1,1165,1158,1109,-1,1165,1209,1158,-1,1121,510,774,-1,510,1121,1083,-1,319,44,236,-1,68,44,319,-1,1057,889,950,-1,940,889,1057,-1,380,678,157,-1,380,677,678,-1,976,1062,1007,-1,976,1088,1062,-1,0,56,7,-1,0,57,56,-1,219,585,357,-1,585,219,338,-1,1148,1169,1165,-1,1131,1169,1148,-1,1078,1104,1114,-1,1078,1053,1104,-1,840,993,969,-1,846,993,840,-1,607,868,608,-1,607,840,868,-1,287,307,85,-1,470,307,287,-1,836,833,891,-1,833,836,835,-1,885,958,974,-1,885,865,958,-1,290,349,80,-1,290,496,349,-1,1061,1030,1158,-1,1030,1061,1011,-1,1145,825,956,-1,825,1145,1066,-1,760,704,733,-1,760,685,704,-1,1090,1220,1082,-1,1220,1090,1180,-1,258,345,221,-1,258,310,345,-1,797,407,349,-1,407,797,851,-1,771,500,420,-1,928,500,771,-1,16,136,73,-1,13,136,16,-1,197,16,54,-1,228,16,197,-1,695,284,272,-1,695,747,284,-1,431,63,284,-1,431,180,63,-1,843,465,497,-1,842,465,843,-1,713,671,748,-1,713,692,671,-1,5,19,34,-1,5,8,19,-1,39,32,48,-1,1,32,39,-1,30,38,75,-1,17,38,30,-1,328,698,342,-1,328,803,698,-1,422,785,642,-1,576,785,422,-1,702,634,657,-1,702,633,634,-1,756,543,642,-1,756,726,543,-1,827,743,756,-1,827,728,743,-1,480,612,383,-1,612,480,622,-1,340,252,269,-1,340,364,252,-1,590,827,819,-1,590,728,827,-1,333,805,826,-1,333,254,805,-1,428,778,223,-1,428,873,778,-1,426,457,339,-1,426,472,457,-1,838,954,1012,-1,954,838,802,-1,828,971,651,-1,1081,971,828,-1,1020,984,1018,-1,1020,987,984,-1,746,1027,1018,-1,746,786,1027,-1,206,234,317,-1,206,142,234,-1,319,546,795,-1,319,236,546,-1,729,633,702,-1,729,635,633,-1,265,676,290,-1,265,531,676,-1,847,958,905,-1,933,958,847,-1,685,796,551,-1,760,796,685,-1,884,852,770,-1,884,998,852,-1,214,518,637,-1,214,194,518,-1,356,64,106,-1,64,356,280,-1,822,794,749,-1,822,817,794,-1,822,834,817,-1,794,882,865,-1,794,817,882,-1,557,390,535,-1,557,485,390,-1,14,64,72,-1,14,42,64,-1,425,485,463,-1,425,390,485,-1,214,119,194,-1,119,214,110,-1,56,332,28,-1,293,332,56,-1,301,425,452,-1,301,285,425,-1,127,119,99,-1,127,161,119,-1,28,7,56,-1,7,28,44,-1,162,60,132,-1,60,162,99,-1,2,120,85,-1,59,120,2,-1,696,553,588,-1,696,723,553,-1,640,564,462,-1,714,564,640,-1,503,723,470,-1,723,503,553,-1,761,659,919,-1,659,761,532,-1,641,504,507,-1,641,683,504,-1,623,721,730,-1,721,623,624,-1,627,577,699,-1,577,627,628,-1,372,683,675,-1,372,504,683,-1,239,108,232,-1,152,108,239,-1,375,239,376,-1,375,211,239,-1,139,208,144,-1,211,208,139,-1,387,208,386,-1,387,256,208,-1,1059,1018,1027,-1,1059,1020,1018,-1,613,506,472,-1,613,614,506,-1,615,542,528,-1,617,542,615,-1,643,572,666,-1,572,643,542,-1,666,802,838,-1,650,802,666,-1,1012,1080,1023,-1,1012,1059,1080,-1,277,217,329,-1,217,277,269,-1,175,30,133,-1,30,175,50,-1,5,47,25,-1,47,5,34,-1,163,321,197,-1,321,163,226,-1,179,39,48,-1,179,52,39,-1,343,54,187,-1,167,54,343,-1,343,918,492,-1,343,790,918,-1,436,856,754,-1,436,589,856,-1,1132,788,1042,-1,788,1132,763,-1,272,32,166,-1,32,272,49,-1,1066,803,469,-1,1154,803,1066,-1,1119,1040,1156,-1,1119,1075,1040,-1,502,465,823,-1,502,308,465,-1,327,269,277,-1,269,327,340,-1,327,456,340,-1,327,449,456,-1,37,62,83,-1,37,13,62,-1,254,183,75,-1,254,333,183,-1,346,251,277,-1,346,395,251,-1,1020,1012,954,-1,1020,1059,1012,-1,580,666,572,-1,580,650,666,-1,542,619,572,-1,619,542,617,-1,472,540,457,-1,472,506,540,-1,1031,1059,1027,-1,1080,1059,1031,-1,602,386,599,-1,602,387,386,-1,386,211,375,-1,386,208,211,-1,376,232,374,-1,239,232,376,-1,232,98,242,-1,232,108,98,-1,326,507,504,-1,222,507,326,-1,451,699,577,-1,451,581,699,-1,730,675,683,-1,675,730,721,-1,547,507,368,-1,547,641,507,-1,956,431,764,-1,956,825,431,-1,659,875,919,-1,588,875,659,-1,379,640,462,-1,640,379,689,-1,85,286,287,-1,120,286,85,-1,132,9,92,-1,9,132,33,-1,57,9,58,-1,9,57,0,-1,161,219,233,-1,219,161,127,-1,463,357,499,-1,337,357,463,-1,194,161,230,-1,161,194,119,-1,72,280,268,-1,72,64,280,-1,61,77,10,-1,80,77,61,-1,817,801,882,-1,834,801,817,-1,749,793,822,-1,749,755,793,-1,836,347,557,-1,381,347,836,-1,937,399,381,-1,850,399,937,-1,230,518,194,-1,518,230,510,-1,350,649,241,-1,350,646,649,-1,611,961,955,-1,611,609,961,-1,1046,939,1082,-1,1046,974,939,-1,295,531,265,-1,295,551,531,-1,726,702,668,-1,702,726,729,-1,428,317,732,-1,428,206,317,-1,778,1027,786,-1,778,1031,1027,-1,828,587,867,-1,828,540,587,-1,1018,805,746,-1,1018,984,805,-1,739,329,412,-1,739,346,329,-1,838,1023,845,-1,1012,1023,838,-1,339,651,412,-1,339,457,651,-1,732,873,428,-1,732,1000,873,-1,254,746,805,-1,254,176,746,-1,590,631,728,-1,590,625,631,-1,177,269,252,-1,217,269,177,-1,524,368,288,-1,547,368,524,-1,728,636,743,-1,728,631,636,-1,756,729,726,-1,756,743,729,-1,657,632,674,-1,632,657,634,-1,422,342,316,-1,422,362,342,-1,362,328,342,-1,362,279,328,-1,304,175,133,-1,175,304,554,-1,5,1,39,-1,17,1,5,-1,167,492,257,-1,492,167,343,-1,901,497,486,-1,901,843,497,-1,180,21,63,-1,180,66,21,-1,1042,1231,1132,-1,1042,1091,1231,-1,1140,830,995,-1,901,830,1140,-1,1197,1099,1210,-1,1099,1197,1087,-1,228,62,16,-1,228,311,62,-1,844,1038,928,-1,1038,844,837,-1,888,822,793,-1,822,888,851,-1,974,933,939,-1,958,933,974,-1,1158,956,1061,-1,956,1158,1145,-1,676,496,290,-1,801,496,676,-1,1046,952,885,-1,952,1046,1168,-1,306,247,189,-1,247,306,155,-1,1119,919,875,-1,1119,1109,919,-1,1139,1189,1152,-1,1139,1205,1189,-1,1107,1055,1100,-1,1107,1095,1055,-1,1055,993,1034,-1,993,1055,969,-1,1114,1126,1127,-1,1114,1104,1126,-1,1148,1107,1131,-1,1107,1148,1126,-1,57,293,56,-1,57,240,293,-1,358,677,380,-1,686,677,358,-1,889,677,686,-1,940,677,889,-1,983,677,940,-1,913,677,983,-1,1073,821,829,-1,792,821,1073,-1,358,157,129,-1,358,380,157,-1,983,1057,1088,-1,983,940,1057,-1,70,319,377,-1,70,68,319,-1,1083,518,510,-1,518,1083,1034,-1,870,592,816,-1,870,727,592,-1,35,93,65,-1,35,45,93,-1,309,537,160,-1,537,309,703,-1,448,103,196,-1,476,103,448,-1,315,899,719,-1,315,447,899,-1,1181,899,1045,-1,899,1181,1085,-1,806,477,665,-1,806,490,477,-1,906,664,925,-1,906,541,664,-1,1029,1201,1187,-1,1093,1201,1029,-1,1199,1230,1223,-1,1230,1199,1206,-1,1032,957,935,-1,965,957,1032,-1,156,224,213,-1,156,171,224,-1,435,570,400,-1,570,435,578,-1,660,591,570,-1,691,591,660,-1,691,615,710,-1,615,691,617,-1,735,613,765,-1,735,614,613,-1,216,171,207,-1,216,205,171,-1,1025,848,849,-1,1025,977,848,-1,1025,1110,1089,-1,1110,1025,1017,-1,988,862,861,-1,988,1017,862,-1,1130,988,1004,-1,988,1130,1098,-1,552,864,561,-1,552,737,864,-1,653,627,539,-1,628,627,653,-1,519,623,512,-1,624,623,519,-1,737,593,734,-1,737,552,593,-1,501,484,314,-1,595,484,501,-1,544,736,769,-1,690,736,544,-1,663,594,772,-1,594,663,526,-1,550,526,529,-1,545,526,550,-1,545,594,526,-1,777,946,762,-1,946,777,948,-1,1175,1069,1103,-1,1136,1069,1175,-1,1228,1208,1179,-1,1191,1208,1228,-1,1116,1108,1136,-1,1116,1071,1108,-1,813,934,783,-1,813,949,934,-1,909,1179,1208,-1,1179,909,944,-1,1116,1022,1039,-1,1124,1022,1116,-1,759,813,775,-1,759,832,813,-1,1170,1221,1162,-1,1170,1193,1221,-1,832,701,679,-1,832,759,701,-1,351,556,283,-1,488,556,351,-1,455,438,740,-1,404,438,455,-1,483,405,344,-1,444,405,483,-1,857,305,325,-1,857,302,305,-1,153,424,292,-1,424,153,143,-1,370,684,708,-1,370,423,684,-1,633,513,538,-1,633,635,513,-1,688,920,437,-1,688,1001,920,-1,997,1029,916,-1,997,1093,1029,-1,207,491,216,-1,207,450,491,-1,244,205,216,-1,244,267,205,-1,164,392,367,-1,392,164,213,-1,116,474,382,-1,474,116,261,-1,237,382,509,-1,237,138,382,-1,450,1060,491,-1,450,1047,1060,-1,281,654,459,-1,281,294,654,-1,521,715,687,-1,562,715,521,-1,996,986,1146,-1,914,986,996,-1,635,494,513,-1,635,636,494,-1,562,667,715,-1,574,667,562,-1,881,568,768,-1,881,667,568,-1,917,1102,931,-1,1102,917,1048,-1,1204,1196,1188,-1,1196,1204,1235,-1,1207,1230,1201,-1,1207,1214,1230,-1,750,1051,716,-1,1051,750,902,-1,1171,1051,1028,-1,1213,1051,1171,-1,134,473,196,-1,134,489,473,-1,124,334,393,-1,94,334,124,-1,1216,1037,1181,-1,1037,1216,1008,-1,1101,1216,1161,-1,1216,1101,1215,-1,703,468,820,-1,468,703,309,-1,541,371,664,-1,490,371,541,-1,490,468,371,-1,404,394,418,-1,455,394,404,-1,394,455,441,-1,442,477,423,-1,442,665,477,-1,1026,1160,751,-1,1160,1026,1182,-1,887,942,1153,-1,887,740,942,-1,275,351,263,-1,275,369,351,-1,405,402,344,-1,403,402,405,-1,536,582,495,-1,536,565,582,-1,365,360,188,-1,365,520,360,-1,135,104,122,-1,135,128,104,-1,202,135,151,-1,182,135,202,-1,610,259,297,-1,610,606,259,-1,84,107,78,-1,84,109,107,-1,148,109,128,-1,131,109,148,-1,466,1005,944,-1,466,669,1005,-1,1175,1155,1124,-1,1203,1155,1175,-1,299,231,384,-1,231,299,174,-1,558,860,1079,-1,558,559,860,-1,348,174,299,-1,174,348,291,-1,1191,920,1001,-1,920,1191,1166,-1,731,113,464,-1,151,113,731,-1,76,69,126,-1,76,24,69,-1,821,445,419,-1,821,792,445,-1,943,445,792,-1,943,289,445,-1,517,405,453,-1,517,403,405,-1,31,23,15,-1,31,45,23,-1,621,388,598,-1,604,388,621,-1,11,238,15,-1,11,245,238,-1,235,1069,936,-1,235,355,1069,-1,145,324,262,-1,145,250,324,-1,877,662,1106,-1,662,877,548,-1,141,262,209,-1,141,145,262,-1,1179,1234,1228,-1,1179,1178,1234,-1,693,1016,886,-1,890,1016,693,-1,65,84,69,-1,84,65,104,-1,131,170,115,-1,131,192,170,-1,246,398,253,-1,398,246,388,-1,366,607,608,-1,366,398,607,-1,921,946,1147,-1,946,921,769,-1,1019,448,712,-1,448,1019,959,-1,67,245,11,-1,67,283,245,-1,560,353,331,-1,560,438,353,-1,203,169,76,-1,220,169,203,-1,415,89,278,-1,165,89,415,-1,541,477,490,-1,541,549,477,-1,12,143,153,-1,55,143,12,-1,898,972,1028,-1,898,927,972,-1,818,441,887,-1,394,441,818,-1,476,447,103,-1,447,476,800,-1,925,1150,906,-1,925,1173,1150,-1,4,40,27,-1,40,4,29,-1,951,537,968,-1,951,489,537,-1,1172,807,951,-1,1172,1043,807,-1,766,393,716,-1,393,766,409,-1,55,505,143,-1,55,225,505,-1,1014,904,1137,-1,742,904,1014,-1,1064,1235,1068,-1,1064,1192,1235,-1,522,915,894,-1,522,410,915,-1,459,816,592,-1,816,459,654,-1,634,538,574,-1,634,633,538,-1,727,481,592,-1,727,516,481,-1,494,408,481,-1,494,515,408,-1,612,757,853,-1,622,757,612,-1,981,895,965,-1,981,872,895,-1,408,644,391,-1,408,515,644,-1,433,903,414,-1,433,979,903,-1,460,809,1013,-1,460,363,809,-1,780,812,896,-1,780,765,812,-1,282,400,224,-1,435,400,282,-1,261,413,672,-1,413,261,154,-1,116,164,154,-1,116,111,164,-1,111,116,138,-1,201,363,460,-1,201,198,363,-1,768,516,727,-1,768,568,516,-1,107,235,276,-1,107,115,235,-1,560,963,942,-1,560,708,963,-1,275,370,331,-1,370,275,323,-1,423,549,684,-1,549,423,477,-1,384,352,466,-1,384,231,352,-1,1006,464,962,-1,464,1006,731,-1,1170,878,1128,-1,964,878,1170,-1,443,418,488,-1,421,418,443,-1,421,404,418,-1,353,443,369,-1,353,421,443,-1,759,897,879,-1,759,775,897,-1,1052,989,1162,-1,949,989,1052,-1,1003,1006,962,-1,1071,1006,1003,-1,1155,1033,990,-1,1176,1033,1155,-1,1190,1035,1052,-1,1035,1190,1174,-1,1003,886,1016,-1,1003,897,886,-1,1203,1176,1155,-1,1227,1176,1203,-1,1144,1234,1227,-1,1144,1167,1234,-1,1115,1233,1147,-1,1233,1115,1174,-1,700,550,638,-1,690,550,700,-1,690,544,550,-1,545,921,859,-1,533,921,545,-1,520,638,360,-1,638,520,700,-1,565,529,526,-1,565,536,529,-1,687,523,521,-1,687,593,523,-1,552,523,593,-1,552,512,523,-1,647,519,561,-1,647,539,519,-1,653,914,757,-1,784,914,653,-1,1134,1130,1146,-1,1134,1185,1130,-1,863,601,603,-1,601,863,861,-1,599,862,849,-1,862,599,600,-1,1058,1056,1092,-1,981,1056,1058,-1,1041,1056,1032,-1,1041,1089,1056,-1,625,658,644,-1,658,625,616,-1,618,660,648,-1,619,660,618,-1,567,578,527,-1,658,578,567,-1,648,578,658,-1,710,694,645,-1,735,694,710,-1,367,591,645,-1,367,392,591,-1,812,602,848,-1,812,605,602,-1,1194,1049,1102,-1,1192,1049,1194,-1,1187,1230,1206,-1,1201,1230,1187,-1,907,1076,1037,-1,992,1076,907,-1,508,798,781,-1,508,534,798,-1,373,196,473,-1,652,196,373,-1,810,196,652,-1,758,895,872,-1,758,781,895,-1,1074,1120,1143,-1,1074,1072,1120,-1,1204,968,1068,-1,1186,968,1204,-1,410,165,751,-1,165,410,86,-1,793,776,888,-1,793,833,776,-1,680,999,755,-1,999,680,991,-1,945,296,985,-1,338,296,945,-1,132,779,162,-1,132,767,779,-1,678,913,976,-1,677,913,678,-1,950,686,583,-1,889,686,950,-1,236,678,546,-1,157,678,236,-1,7,70,0,-1,70,7,68,-1,1053,1095,1104,-1,1009,1095,1053,-1,1156,1165,1109,-1,1156,1148,1165,-1,607,846,840,-1,604,846,607,-1,1105,1083,1121,-1,1083,1105,1100,-1,868,969,1009,-1,868,840,969,-1,1169,1209,1165,-1,1169,1200,1209,-1,482,470,287,-1,503,470,482,-1,930,891,999,-1,891,930,912,-1,865,905,958,-1,865,882,905,-1,496,797,349,-1,797,496,782,-1,342,554,304,-1,342,698,554,-1,210,158,87,-1,158,210,193,-1,563,1066,469,-1,1066,563,825,-1,1061,764,856,-1,1061,956,764,-1,318,1090,814,-1,738,1090,318,-1,90,212,53,-1,90,112,212,-1,313,440,486,-1,322,440,313,-1,851,498,407,-1,498,851,888,-1,661,1063,525,-1,1021,1063,661,-1,197,167,163,-1,54,167,197,-1,747,1070,1091,-1,695,1070,747,-1,284,754,431,-1,754,284,747,-1,284,49,272,-1,284,63,49,-1,1087,842,843,-1,1087,1021,842,-1,467,671,692,-1,467,303,671,-1,1097,554,698,-1,1097,1010,554,-1,274,449,327,-1,449,274,229,-1,183,434,316,-1,333,434,183,-1,91,354,288,-1,91,158,354,-1,316,576,422,-1,434,576,316,-1,668,657,569,-1,668,702,657,-1,288,569,524,-1,288,354,569,-1,642,827,756,-1,785,827,642,-1,320,383,242,-1,383,320,480,-1,674,626,718,-1,626,674,632,-1,576,826,924,-1,576,434,826,-1,778,190,223,-1,190,778,786,-1,605,472,426,-1,605,613,472,-1,802,866,954,-1,866,802,711,-1,1081,867,1067,-1,1081,828,867,-1,1000,1123,1036,-1,1000,1096,1123,-1,984,826,805,-1,826,984,924,-1,732,395,855,-1,732,317,395,-1,265,80,61,-1,265,290,80,-1,531,905,676,-1,905,531,847,-1,1078,1002,966,-1,1078,779,1002,-1,779,1078,883,-1,406,241,649,-1,406,204,241,-1,233,341,270,-1,337,341,233,-1,240,58,204,-1,57,58,240,-1,181,301,199,-1,181,285,301,-1,110,99,119,-1,60,99,110,-1,296,99,162,-1,99,296,127,-1,306,118,335,-1,306,189,118,-1,706,696,689,-1,706,723,696,-1,659,696,588,-1,697,696,659,-1,514,503,724,-1,553,503,514,-1,589,744,856,-1,589,655,744,-1,718,620,717,-1,626,620,718,-1,620,730,717,-1,620,623,730,-1,721,627,699,-1,624,627,721,-1,628,480,577,-1,628,622,480,-1,427,675,581,-1,427,372,675,-1,612,374,383,-1,374,612,603,-1,376,600,375,-1,601,600,376,-1,144,130,139,-1,144,177,130,-1,144,256,178,-1,144,208,256,-1,573,819,670,-1,573,590,819,-1,580,616,573,-1,616,580,618,-1,528,614,615,-1,528,506,614,-1,643,528,542,-1,643,587,528,-1,643,838,845,-1,666,838,643,-1,387,339,256,-1,387,426,339,-1,317,251,395,-1,251,317,234,-1,25,223,190,-1,223,25,47,-1,449,454,692,-1,449,229,454,-1,748,257,492,-1,748,671,257,-1,479,713,830,-1,479,456,713,-1,479,322,364,-1,322,479,440,-1,642,362,422,-1,642,543,362,-1,1152,1200,1169,-1,1152,1189,1200,-1,695,928,1070,-1,500,928,695,-1,465,179,184,-1,308,179,465,-1,114,150,90,-1,114,172,150,-1,340,479,364,-1,340,456,479,-1,180,825,563,-1,825,180,431,-1,449,713,456,-1,449,692,713,-1,760,432,571,-1,760,733,432,-1,575,330,311,-1,575,704,330,-1,34,206,47,-1,206,34,142,-1,5,38,17,-1,25,38,5,-1,234,117,274,-1,234,142,117,-1,602,426,387,-1,602,605,426,-1,643,867,587,-1,643,845,867,-1,540,528,587,-1,528,540,506,-1,650,670,711,-1,650,573,670,-1,573,650,580,-1,572,618,580,-1,618,572,619,-1,573,625,590,-1,616,625,573,-1,177,178,217,-1,177,144,178,-1,177,200,130,-1,200,177,252,-1,375,599,386,-1,600,599,375,-1,601,374,603,-1,376,374,601,-1,242,374,232,-1,242,383,374,-1,320,577,480,-1,577,320,451,-1,721,581,675,-1,721,699,581,-1,717,683,641,-1,717,730,683,-1,717,547,718,-1,717,641,547,-1,697,681,714,-1,697,705,681,-1,588,724,875,-1,514,724,588,-1,307,689,379,-1,689,307,706,-1,714,696,697,-1,714,689,696,-1,714,640,689,-1,287,461,482,-1,286,461,287,-1,579,357,585,-1,499,357,579,-1,0,92,9,-1,0,70,92,-1,58,33,79,-1,33,58,9,-1,357,233,219,-1,357,337,233,-1,199,43,181,-1,59,43,199,-1,204,79,241,-1,79,204,58,-1,230,233,270,-1,233,230,161,-1,268,181,72,-1,181,268,285,-1,337,485,341,-1,337,463,485,-1,10,149,61,-1,149,10,51,-1,680,885,952,-1,885,680,749,-1,801,782,496,-1,782,801,834,-1,833,755,891,-1,755,833,793,-1,774,230,270,-1,510,230,774,-1,814,1082,939,-1,1090,1082,814,-1,551,847,531,-1,551,796,847,-1,656,461,579,-1,656,482,461,-1,985,1127,945,-1,985,1114,1127,-1,726,471,543,-1,726,668,471,-1,873,1031,778,-1,873,1036,1031,-1,1067,1118,1081,-1,1123,1118,1067,-1,1096,1118,1123,-1,176,75,38,-1,176,254,75,-1,845,1067,867,-1,1023,1067,845,-1,739,1118,855,-1,971,1118,739,-1,855,1000,732,-1,855,1096,1000,-1,176,786,746,-1,176,190,786,-1,576,973,785,-1,576,924,973,-1,524,718,547,-1,718,524,674,-1,248,242,98,-1,242,248,320,-1,743,635,729,-1,743,636,635,-1,569,674,524,-1,674,569,657,-1,668,354,471,-1,668,569,354,-1,133,316,304,-1,183,316,133,-1,1,168,166,-1,1,50,168,-1,361,229,96,-1,229,361,454,-1,738,1180,1090,-1,738,1010,1180,-1,185,486,497,-1,313,486,185,-1,185,66,221,-1,66,185,21,-1,754,1091,1042,-1,754,747,1091,-1,901,1099,843,-1,1099,901,1140,-1,83,311,330,-1,83,62,311,-1,790,763,1132,-1,439,763,790,-1,844,733,575,-1,844,771,733,-1,851,834,822,-1,851,782,834,-1,797,782,851,-1,760,815,796,-1,760,571,815,-1,74,212,469,-1,53,212,74,-1,882,676,905,-1,882,801,676,-1,991,1168,1224,-1,991,952,1168,-1,788,227,511,-1,273,227,788,-1,59,36,43,-1,59,2,36,-1,655,705,744,-1,655,681,705,-1,875,871,1075,-1,875,724,871,-1,1131,1100,1105,-1,1131,1107,1100,-1,1100,1034,1083,-1,1034,1100,1055,-1,966,610,923,-1,966,606,610,-1,1127,1148,1156,-1,1127,1126,1148,-1,1126,1095,1107,-1,1095,1126,1104,-1,240,770,293,-1,240,555,770,-1,79,60,110,-1,60,79,33,-1,583,358,129,-1,686,358,583,-1,913,1088,976,-1,913,983,1088,-1,162,985,296,-1,162,883,985,-1,999,1224,1222,-1,999,991,1224,-1,846,621,596,-1,621,846,604,-1,1212,1205,1222,-1,1212,1189,1205,-1,833,720,776,-1,833,835,720,-1,968,703,1068,-1,968,537,703,-1,892,758,872,-1,799,758,892,-1,508,758,411,-1,508,781,758,-1,967,493,719,-1,967,584,493,-1,1173,1202,1150,-1,1173,1215,1202,-1,1047,1199,1060,-1,1206,1199,1047,-1,982,916,854,-1,997,916,982,-1,896,848,977,-1,896,812,848,-1,400,591,392,-1,591,400,570,-1,710,591,691,-1,710,645,591,-1,614,710,615,-1,614,735,710,-1,616,648,658,-1,618,648,616,-1,391,658,567,-1,391,644,658,-1,977,1089,1041,-1,977,1025,1089,-1,1092,1089,1110,-1,1092,1056,1089,-1,600,861,862,-1,861,600,601,-1,863,612,853,-1,603,612,863,-1,561,811,647,-1,561,864,811,-1,757,628,653,-1,757,622,628,-1,627,519,539,-1,519,627,624,-1,512,620,523,-1,512,623,620,-1,620,521,523,-1,521,620,626,-1,360,501,314,-1,501,360,638,-1,594,859,772,-1,545,859,594,-1,550,595,638,-1,550,529,595,-1,597,783,777,-1,597,707,783,-1,1227,1103,1144,-1,1203,1103,1227,-1,1227,1178,1176,-1,1234,1178,1227,-1,1016,1071,1003,-1,1108,1071,1016,-1,886,775,707,-1,775,886,897,-1,1071,1039,1006,-1,1116,1039,1071,-1,964,1162,989,-1,964,1170,1162,-1,1157,1177,1226,-1,1177,1157,1153,-1,369,488,351,-1,443,488,369,-1,880,402,701,-1,402,880,857,-1,725,1006,1039,-1,731,1006,725,-1,990,831,649,-1,990,1033,831,-1,249,170,259,-1,458,170,249,-1,355,170,458,-1,292,186,153,-1,292,263,186,-1,708,926,963,-1,708,684,926,-1,538,516,568,-1,513,516,538,-1,916,809,509,-1,916,1029,809,-1,207,460,450,-1,207,201,460,-1,645,413,367,-1,645,694,413,-1,433,216,491,-1,433,244,216,-1,935,474,787,-1,935,893,474,-1,213,400,392,-1,400,213,224,-1,672,896,787,-1,672,780,896,-1,363,509,809,-1,363,237,509,-1,491,979,433,-1,491,1060,979,-1,631,644,515,-1,631,625,644,-1,965,1056,981,-1,1056,965,1032,-1,858,715,941,-1,715,858,687,-1,636,515,494,-1,636,631,515,-1,513,481,516,-1,513,494,481,-1,632,574,562,-1,634,574,632,-1,894,816,917,-1,894,870,816,-1,915,870,894,-1,915,947,870,-1,1049,931,1102,-1,682,931,1049,-1,1235,1230,1196,-1,1230,1235,1223,-1,682,146,522,-1,682,225,146,-1,716,334,750,-1,716,393,334,-1,1186,951,968,-1,1186,1172,951,-1,473,951,807,-1,489,951,473,-1,160,489,134,-1,489,160,537,-1,1085,1037,1076,-1,1037,1085,1181,-1,799,902,750,-1,902,799,892,-1,1026,1143,1182,-1,1026,1122,1143,-1,143,953,424,-1,953,143,505,-1,475,169,373,-1,475,278,169,-1,165,673,751,-1,415,673,165,-1,1215,1138,1202,-1,1138,1215,1101,-1,441,740,887,-1,455,740,441,-1,331,369,275,-1,331,353,369,-1,344,305,238,-1,325,305,344,-1,314,137,360,-1,314,126,137,-1,45,97,93,-1,45,31,97,-1,182,128,135,-1,182,148,128,-1,246,182,202,-1,253,182,246,-1,109,115,107,-1,109,131,115,-1,128,84,104,-1,109,84,128,-1,944,1178,1179,-1,944,1005,1178,-1,559,877,860,-1,559,548,877,-1,559,348,548,-1,559,291,348,-1,559,250,291,-1,250,559,324,-1,231,145,141,-1,231,174,145,-1,397,159,437,-1,419,159,397,-1,445,159,419,-1,1079,877,1106,-1,1079,860,877,-1,174,250,145,-1,174,291,250,-1,920,1167,869,-1,920,1166,1167,-1,97,464,113,-1,464,97,385,-1,453,444,389,-1,453,405,444,-1,298,943,938,-1,943,298,289,-1],
          coord=Coordinate(DEF='c4_Coord',point=[(-.22437,53.79685,-2.11766),(-.18684,53.8298,-2.14655),(-.21356,53.77437,-2.17786),(.00565,53.81727,-2.05914),(.00699,53.83348,-2.06093),(.07212,53.73799,-2.12656),(.78023,54.29529,-1.46957),(.74022,54.37685,-1.44992),(.83868,54.41628,-1.43282),(.41988,54.32903,-1.4452),(.41602,54.32457,-1.44236),(.44186,54.32361,-1.39244),(.08778,54.22777,-1.70959),(.18627,54.24464,-1.66405),(.08885,54.23197,-1.71521),(.48051,54.31519,-1.264),(.44289,54.42374,-1.28841),(.44241,54.39747,-1.31636),(.22019,53.8236,-1.78525),(.21214,53.81995,-1.78603),(.19458,53.77844,-1.88053),(.03477,53.74762,-2.05196),(.00531,53.77223,-2.03547),(.1322,53.7086,-2.15938),(.07046,53.70826,-2.117),(.11926,53.71406,-2.16051),(.22437,53.79685,-2.11766),(.21544,53.72265,-2.16461),(.21356,53.77437,-2.17786),(.17398,53.82843,-2.14598),(.17757,53.79049,-2.18131),(.17045,53.78793,-2.18051),(0,54.05855,-1.93332),(.05582,53.93838,-2.00816),(0,53.93653,-2.00848),(.39364,53.85273,-1.55447),(.40334,53.8559,-1.58133),(.47713,53.85215,-1.53376),(0,54.10121,-1.78156),(0,54.0351,-1.82818),(.1105,54.04751,-1.77692),(.22268,53.95371,-1.72084),(.2135,54.02941,-1.71543),(.87794,53.84084,-1.39909),(.91556,53.97344,-1.34568),(.89405,53.93263,-1.31461),(.66197,53.77147,-1.47585),(.67271,53.77226,-1.47029),(.57567,53.78669,-1.44352),(.88661,53.92725,-1.31299),(.87352,53.83807,-1.39423),(.57463,53.97579,-1.28554),(.63201,54.01498,-1.23959),(.56926,53.98414,-1.28062),(.73543,54.01999,-1.22963),(.68912,54.01252,-1.23617),(.73487,54.01156,-1.23701),(.56876,53.98445,-1.28127),(.88873,54.03593,-1.27883),(.8542,54.00644,-1.25627),(.85205,54.18959,-1.27399),(.85305,54.19541,-1.28601),(.84856,54.19528,-1.27302),(.80917,54.08622,-1.21537),(.83744,54.09823,-1.2316),(.774,54.13306,-1.1964),(.69026,54.06019,-1.17243),(.70503,54.06765,-1.18006),(.71255,54.07681,-1.15943),(.67949,54.04572,-1.19307),(.70534,54.05168,-1.19487),(.57941,54.22123,-1.49312),(.53374,54.35242,-1.40028),(.67143,54.24694,-1.48179),(.89321,54.55823,-1.2147),(.89799,54.55434,-1.21087),(.90755,54.50024,-1.32811),(.51725,54.49329,-1.18674),(.52004,54.49669,-1.19227),(.5166,54.49312,-1.18707),(.75267,54.12628,-1.18748),(.76585,54.14647,-1.18882),(.76267,54.13983,-1.17687),(.65072,54.10835,-1.1175),(.70145,54.0745,-1.15429),(.70741,54.07664,-1.14031),(.3418,54.07939,-1.17008),(.36042,54.08072,-1.15581),(.35609,54.03512,-1.15207),(.40774,54.0823,-1.11874),(.40739,54.09068,-1.12812),(.42136,54.08483,-1.12693),(.51695,54.38733,-1.15673),(.49935,54.37485,-1.14008),(.56354,54.36194,-1.14498),(.79999,54.23929,-1.17418),(.77684,54.32239,-1.13348),(.80146,54.22961,-1.16239),(.7682,54.34489,-1.1339),(.70508,54.33425,-1.12166),(.76436,54.33216,-1.12751),(.80315,54.04964,-.96177),(.77122,54.01381,-1.01765),(.81932,54.06282,-1.02156),(.41634,54.11962,-.88533),(.433,54.07283,-.93808),(.45873,54.08208,-.93622),(.61746,54.10614,-.92731),(.51933,54.10557,-.93397),(.61756,54.10904,-.935),(.44071,54.07523,-.94619),(.45783,54.08362,-.94075),(.78505,54.44696,-1.35317),(.90114,54.50496,-1.32902),(.83272,54.42636,-1.43224),(.65055,54.32055,-1.12898),(.56813,54.28231,-1.11185),(.63238,54.27559,-1.10121),(.65178,54.20936,-.95491),(.65814,54.21713,-.95463),(.68421,54.19875,-.99388),(.7233,54.24313,-1.07184),(.64117,54.26834,-1.09565),(.6801,54.21422,-1.04921),(.7436,54.17388,-1.00644),(.83036,54.1455,-1.01393),(.6497,54.1803,-.95539),(.66795,54.1793,-.98897),(.66493,54.14257,-.9883),(.64882,54.09629,-.95567),(.65048,54.15533,-.95444),(.66905,54.12584,-1.02749),(.67761,54.07106,-1.01731),(.46103,54.13818,-.94505),(.48293,54.20446,-.94775),(.53738,54.22358,-.93118),(.65443,54.07805,-.93927),(.66671,54.14906,-.89387),(.70222,54.25536,-.88585),(.64963,54.25459,-.93085),(.65716,54.28174,-.88621),(.59433,54.29029,-.88293),(.62327,54.22721,-.89184),(.65487,54.28186,-.87721),(.77361,54.07912,-.9267),(.73582,54.18924,-.89657),(.71909,54.11686,-.90024),(.68951,54.23122,-.92096),(.72965,54.17437,-.95457),(.48148,54.19777,-1.1902),(.48888,54.24246,-1.25118),(.5029,54.15894,-1.23856),(.49377,54.18676,-1.32411),(.45277,54.38778,-1.32992),(.44589,54.32713,-1.39629),(.49046,54.35479,-1.17835),(.49041,54.28589,-1.19346),(.48375,54.28863,-1.17938),(.46524,54.46159,-1.24371),(.49513,54.35842,-1.20459),(.51823,54.41622,-1.17105),(.48869,54.37673,-1.15291),(.48166,54.35512,-1.166),(.46,54.35964,-1.15597),(.5034,54.27111,-.94877),(.53717,54.32365,-.8959),(.54591,54.28466,-.92793),(.5136,54.38256,-.94043),(.49536,54.35669,-.98389),(.50842,54.44201,-.97327),(.54077,54.31818,-.88279),(.51543,54.38522,-.89328),(.50514,54.38042,-.867),(.51881,54.30686,-1.08806),(.56598,54.31948,-1.12731),(.48648,54.39031,-1.10688),(.47425,54.42323,-1.10892),(.48504,54.42597,-1.06425),(.45815,54.50691,-1.13007),(.45406,54.43966,-1.15484),(.29093,54.03794,-1.2107),(.28193,54.14311,-1.20727),(.33739,54.17129,-1.18281),(.29037,53.92458,-.86006),(.27706,53.92035,-.86378),(.2702,53.94009,-.95659),(.24985,53.8894,-.77883),(.3352,53.94743,-1.05899),(.34626,53.94324,-1.14164),(.34594,53.95519,-1.05799),(.34708,54.07852,-.86996),(.32672,54.03512,-.88381),(.35725,54.03167,-.95365),(.18335,54.43412,-1.19146),(.18765,54.42188,-1.12748),(.20145,54.42433,-1.13045),(.25706,54.46458,-1.21152),(.25953,54.45756,-1.21805),(.18196,54.42789,-1.1991),(.31187,54.40671,-.76777),(.33522,54.43028,-.76181),(.3289,54.43461,-.76974),(.27592,54.33704,-.76357),(.26478,54.32786,-.76083),(.27263,54.31795,-.75641),(.38127,54.48579,-.81543),(.36854,54.47928,-.77995),(.41848,54.5097,-.8032),(.90463,54.05328,-1.30381),(.06362,53.89364,-1.85132),(.10938,53.97386,-1.81597),(0,53.96788,-1.86823),(.57107,53.7989,-1.4891),(.45959,53.85384,-1.48875),(.36741,53.94525,-1.55457),(.58027,54.44268,-1.14125),(.57047,54.39224,-1.14744),(.66077,54.39596,-1.13497),(.79045,54.40291,-1.14153),(.71899,54.40639,-1.11541),(.70543,54.3482,-1.12462),(.07083,53.82211,-1.89717),(0,53.82912,-1.95153),(.00702,53.78154,-1.98043),(.0903,54.04346,-1.92562),(.16431,53.94449,-2.01224),(.1448,53.94778,-2.01555),(.15692,54.08095,-1.84415),(0,54.13829,-1.86295),(0,54.19572,-1.81361),(.22533,54.13477,-1.75101),(.11659,54.17256,-1.79646),(.43109,54.32382,-1.48035),(.38075,54.30689,-1.49875),(.47028,54.30729,-1.43421),(.5245,54.351,-1.39626),(.66288,54.35554,-1.43886),(.91422,54.37176,-1.31347),(.87052,54.32129,-1.41237),(.85388,54.24466,-1.29321),(.84764,54.22592,-1.38705),(.8889,54.31336,-1.3044),(.44776,54.40608,-1.31884),(.57652,54.42386,-1.32671),(.52941,54.36254,-1.39428),(.86989,54.37316,-1.2046),(.58959,54.1647,-1.50311),(.51473,54.17979,-1.51081),(.90243,54.05815,-1.32757),(.83452,54.06616,-1.40526),(.84893,54.16433,-1.37723),(.73907,54.05442,-1.47439),(.67562,54.06647,-1.49387),(.67398,54.14898,-1.49346),(.24911,54.02154,-1.77206),(.21477,53.99298,-1.83441),(.58152,53.94346,-1.52429),(.66944,53.94648,-1.52413),(.21322,53.78957,-2.01862),(.2084,53.75435,-2.01131),(.21954,53.74386,-2.05702),(.78284,53.86095,-1.49852),(.75998,53.95498,-1.48251),(.85792,53.95702,-1.43237),(.71257,53.88077,-1.368),(.79918,53.86291,-1.37179),(.80671,53.90823,-1.33617),(.63234,53.9308,-1.32722),(.60552,53.9027,-1.35491),(.59762,53.85772,-1.39038),(.74621,53.83548,-1.41751),(.78454,53.78754,-1.45501),(.68004,53.95471,-1.30929),(.63704,54.00763,-1.24663),(.49989,54.10197,-1.14847),(.48316,54.0926,-1.17847),(.51872,54.07786,-1.21536),(.18575,53.8638,-.77509),(.17928,53.84623,-.72385),(.24887,53.94755,-.75738),(.2838,53.96233,-.82448),(.27439,54.02767,-.80054),(.23148,54.01217,-.74302),(.2239,54.06833,-.74318),(.1802,54.05763,-.69441),(.28055,54.08819,-.80212),(.34337,54.51421,-1.14957),(.32145,54.51372,-1.20328),(.16505,54.40484,-1.04964),(.23353,54.41166,-1.05602),(.19325,54.41885,-1.11685),(.26427,54.46558,-1.15549),(.33135,54.43583,-.82866),(.40381,54.49847,-.88495),(.3298,54.441,-.89508),(.17236,54.29663,-.70089),(.19379,54.20345,-.69014),(.44754,54.48013,-.79545),(.47735,54.54141,-.87189),(.42683,54.50643,-.79667),(.82577,54.28771,-1.22298),(.77909,54.33204,-1.1427),(.82504,54.11954,-.97522),(.69986,54.2525,-.87859),(.50762,54.34469,-1.11806),(.83738,54.13638,-1.01602),(.82889,54.1118,-.97194),(.54888,54.0807,-1.18301),(.57799,54.11377,-1.14426),(.74019,54.01904,-.97783),(.69364,54.0504,-.95613),(.31618,53.9665,-.95662),(.37475,54.02801,-1.11314),(.38524,54.03621,-1.03228),(.39695,54.05736,-.95302),(.42076,54.08305,-1.02832),(.47055,54.2646,-.99183),(.66808,54.18142,-1.03955),(.6732,54.20827,-1.0506),(.63158,54.2651,-1.10012),(.40312,54.12608,-1.49069),(.45132,54.12448,-1.41379),(.43317,54.22951,-1.44142),(.36982,54.0289,-1.12671),(.35289,53.95672,-1.13634),(.35147,53.94919,-1.15387),(.41788,53.94212,-1.47615),(.4986,53.84099,-1.40858),(.49963,53.84837,-1.40461),(-.18778,54.24674,-1.66792),(-.27173,54.26602,-1.61062),(-.18627,54.24464,-1.66405),(-.48186,54.30577,-1.28092),(-.48051,54.31519,-1.264),(-.48888,54.24246,-1.25118),(-.07083,53.82211,-1.89717),(-.19458,53.77844,-1.88053),(-.07368,53.7625,-1.96436),(-.21544,53.72265,-2.16461),(-.21387,53.73247,-2.06711),(-.21954,53.74386,-2.05702),(-.19497,53.767,-1.95622),(-.1865,53.75991,-1.95531),(-.33367,53.86681,-1.6318),(-.40334,53.8559,-1.58133),(-.41957,53.96887,-1.58259),(-.07046,53.70826,-2.117),(-.03477,53.74762,-2.05196),(-.07953,53.73064,-2.03458),(-.00599,53.77736,-1.99415),(-.00531,53.77223,-2.03547),(-.2001,53.74614,-2.01123),(-.13702,53.75944,-2.1725),(-.17045,53.78793,-2.18051),(-.17398,53.82843,-2.14598),(-.11215,53.79473,-2.12995),(-.07808,53.86077,-2.06472),(-.07212,53.73799,-2.12656),(-.17116,53.89244,-2.0822),(-.00699,53.83348,-2.06093),(-.05582,53.93838,-2.00816),(-.20431,54.104,-1.70338),(-.2135,54.02941,-1.71543),(-.1105,54.04751,-1.77692),(-.37892,54.3058,-1.49564),(-.41602,54.32457,-1.44236),(-.43317,54.22951,-1.44142),(-.19513,54.17674,-1.68024),(-.27952,54.18814,-1.61395),(-.56876,53.98445,-1.28127),(-.48761,53.9144,-1.35853),(-.54155,54.06076,-1.2612),(-.88873,54.03593,-1.27883),(-.90463,54.05328,-1.30381),(-.91556,53.97344,-1.34568),(-.57463,53.97579,-1.28554),(-.49532,53.90884,-1.35531),(-.88661,53.92725,-1.31299),(-.84653,53.99975,-1.25727),(-.89405,53.93263,-1.31461),(-.73487,54.01156,-1.23701),(-.73543,54.01999,-1.22963),(-.66197,53.77147,-1.47585),(-.67271,53.77226,-1.47029),(-.67218,53.77336,-1.47694),(-.83744,54.09823,-1.2316),(-.774,54.13306,-1.1964),(-.85205,54.18959,-1.27399),(-.85305,54.19541,-1.28601),(-.68912,54.01252,-1.23617),(-.7356,53.95684,-1.29365),(-.68756,54.01962,-1.22755),(-.67949,54.04572,-1.19307),(-.70534,54.05168,-1.19487),(-.80917,54.08622,-1.21537),(-.90755,54.50024,-1.32811),(-.90114,54.50496,-1.32902),(-.83272,54.42636,-1.43224),(-.74123,54.38911,-1.44584),(-.74022,54.37685,-1.44992),(-.83868,54.41628,-1.43282),(-.86989,54.37316,-1.2046),(-.82577,54.28771,-1.22298),(-.77909,54.33204,-1.1427),(-.79999,54.23929,-1.17418),(-.76585,54.14647,-1.18882),(-.76267,54.13983,-1.17687),(-.72989,54.05062,-1.07411),(-.77122,54.01381,-1.01765),(-.82054,54.09776,-1.09483),(-.71771,54.07878,-1.14566),(-.71255,54.07681,-1.15943),(-.36982,54.0289,-1.12671),(-.40739,54.09068,-1.12812),(-.36042,54.08072,-1.15581),(-.59401,54.0471,-1.21366),(-.54888,54.0807,-1.18301),(-.57799,54.11377,-1.14426),(-.52774,54.42028,-1.16649),(-.58027,54.44268,-1.14125),(-.57047,54.39224,-1.14744),(-.77684,54.32239,-1.13348),(-.76436,54.33216,-1.12751),(-.38524,54.03621,-1.03228),(-.35725,54.03167,-.95365),(-.39695,54.05736,-.95302),(-.45783,54.08362,-.94075),(-.46103,54.13818,-.94505),(-.44071,54.07523,-.94619),(-.7233,54.24313,-1.07184),(-.65055,54.32055,-1.12898),(-.70508,54.33425,-1.12166),(-.61025,54.21641,-.93275),(-.61191,54.20529,-.93326),(-.65178,54.20936,-.95491),(-.67808,54.19598,-.99417),(-.6732,54.20827,-1.0506),(-.6801,54.21422,-1.04921),(-.77361,54.07912,-.9267),(-.80315,54.04964,-.96177),(-.74019,54.01904,-.97783),(-.66493,54.14257,-.9883),(-.66808,54.18142,-1.03955),(-.66795,54.1793,-.98897),(-.66905,54.12584,-1.02749),(-.64496,54.16247,-1.11097),(-.46353,54.16475,-1.07455),(-.44268,54.15002,-1.01432),(-.45667,54.20731,-1.00326),(-.64963,54.25459,-.93085),(-.59854,54.27106,-.93094),(-.6526,54.22161,-.95128),(-.65487,54.28186,-.87721),(-.70222,54.25536,-.88585),(-.69986,54.2525,-.87859),(-.65814,54.21713,-.95463),(-.65716,54.28174,-.88621),(-.59433,54.29029,-.88293),(-.79046,54.12682,-.93798),(-.73582,54.18924,-.89657),(-.78453,54.13768,-.94321),(-.68951,54.23122,-.92096),(-.73914,54.19725,-.90415),(-.49513,54.35842,-1.20459),(-.49041,54.28589,-1.19346),(-.51893,54.1204,-1.29098),(-.51102,54.0883,-1.22968),(-.49377,54.18676,-1.32411),(-.5029,54.15894,-1.23856),(-.48148,54.19777,-1.1902),(-.44289,54.42374,-1.28841),(-.48375,54.28863,-1.17938),(-.4308,54.17958,-1.15047),(-.45009,54.26019,-.85376),(-.38109,54.29287,-.81853),(-.416,54.38718,-.80009),(-.51626,54.34017,-.9399),(-.53717,54.32365,-.8959),(-.51543,54.38522,-.89328),(-.48648,54.39031,-1.10688),(-.4695,54.39892,-1.14799),(-.48869,54.37673,-1.15291),(-.33753,54.28723,-1.19579),(-.27459,54.24846,-1.20902),(-.28193,54.14311,-1.20727),(-.3418,54.07939,-1.17008),(-.37062,54.18526,-1.16678),(-.34594,53.95519,-1.05799),(-.3352,53.94743,-1.05899),(-.31618,53.9665,-.95662),(-.35147,53.94919,-1.15387),(-.29872,53.9338,-1.20888),(-.34626,53.94324,-1.14164),(-.35289,53.95672,-1.13634),(-.18765,54.42188,-1.12748),(-.20145,54.42433,-1.13045),(-.19325,54.41885,-1.11685),(-.28627,54.36779,-.83663),(-.28292,54.38732,-.89576),(-.3298,54.441,-.89508),(-.7436,54.17388,-1.00644),(-.72965,54.17437,-.95457),(-.59417,54.29223,-.8922),(-.54591,54.28466,-.92793),(-.58406,53.8458,-1.53576),(-.57107,53.7989,-1.4891),(-.57084,53.78308,-1.45188),(-.45959,53.85384,-1.48875),(-.90803,54.44114,-1.20365),(-.79045,54.40291,-1.14153),(-.06362,53.89364,-1.85132),(-.10938,53.97386,-1.81597),(-.12752,53.88678,-1.82261),(-.21214,53.81995,-1.78603),(-.15245,53.89826,-2.07945),(-.1448,53.94778,-2.01555),(-.08885,54.23197,-1.71521),(0,54.23598,-1.72233),(-.11659,54.17256,-1.79646),(-.22533,54.13477,-1.75101),(-.43109,54.32382,-1.48035),(-.44966,54.21576,-1.54157),(-.50516,54.21917,-1.49724),(-.45277,54.38778,-1.32992),(-.44589,54.32713,-1.39629),(-.47028,54.30729,-1.43421),(-.66288,54.35554,-1.43886),(-.53374,54.35242,-1.40028),(-.67143,54.24694,-1.48179),(-.91422,54.37176,-1.31347),(-.84764,54.22592,-1.38705),(-.8889,54.31336,-1.3044),(-.46902,54.46553,-1.2473),(-.44739,54.42944,-1.29092),(-.56803,54.45165,-1.28266),(-.74579,54.159,-1.45545),(-.67398,54.14898,-1.49346),(-.78284,53.86095,-1.49852),(-.75998,53.95498,-1.48251),(-.66944,53.94648,-1.52413),(-.90924,53.97594,-1.36715),(-.85792,53.95702,-1.43237),(-.8707,53.88662,-1.43288),(-.85388,54.24466,-1.29321),(-.84856,54.19528,-1.27302),(-.63201,54.01498,-1.23959),(-.56926,53.98414,-1.28062),(-.29523,53.92716,-1.2016),(-.2876,53.93529,-1.13933),(-.24985,53.8894,-.77883),(-.27706,53.92035,-.86378),(-.19544,53.91288,-.85463),(-.27165,53.9382,-1.04951),(-.2702,53.94009,-.95659),(-.2838,53.96233,-.82448),(-.29037,53.92458,-.86006),(-.25535,53.89667,-.77227),(-.32672,54.03512,-.88381),(-.308,53.96259,-.91339),(-.23148,54.01217,-.74302),(-.28055,54.08819,-.80212),(-.27439,54.02767,-.80054),(-.16678,54.30671,-.70798),(-.26441,54.34203,-.78124),(-.26478,54.32786,-.76083),(-.26427,54.46558,-1.15549),(-.29041,54.46078,-1.07599),(-.27263,54.31795,-.75641),(-.32404,54.31372,-.76491),(-.31086,54.23058,-.78534),(-.3285,54.32814,-.76292),(-.33522,54.43028,-.76181),(-.36649,54.41095,-.76048),(-.5136,54.38256,-.94043),(-.49536,54.35669,-.98389),(-.83738,54.13638,-1.01602),(-.82065,54.2358,-1.08524),(-.83727,54.17849,-1.09111),(-.67982,54.20751,-.88886),(-.64882,54.09629,-.95567),(-.65443,54.07805,-.93927),(-.67761,54.07106,-1.01731),(-.433,54.07283,-.93808),(-.34708,54.07852,-.86996),(-.35532,54.12507,-.85634),(-.39187,54.05637,-.94319),(-.45399,54.10419,-1.09786),(-.42136,54.08483,-1.12693),(-.40774,54.0823,-1.11874),(-.42076,54.08305,-1.02832),(-.42857,54.09335,-1.02746),(-.4678,54.279,-1.03679),(-.46567,54.22188,-1.05567),(-.61507,54.16834,-.93539),(-.65048,54.15533,-.95444),(-.6497,54.1803,-.95539),(-.40312,54.12608,-1.49069),(-.3857,54.21842,-1.49053),(-.57162,54.2226,-1.12118),(-.51251,54.23857,-1.10819),(-.51881,54.30686,-1.08806),(-.63921,54.21659,-1.10443),(-.63158,54.2651,-1.10012),(-.5034,54.27111,-.94877),(-.47055,54.2646,-.99183),(-.37475,54.02801,-1.11314),(-.69364,54.0504,-.95613),(-.49989,54.10197,-1.14847),(-.71909,54.11686,-.90024),(-.66671,54.14906,-.89387),(-.70503,54.06765,-1.18006),(-.75267,54.12628,-1.18748),(-.82889,54.1118,-.97194),(-.81932,54.06282,-1.02156),(-.48509,54.37791,-1.05635),(-.56354,54.36194,-1.14498),(-.56598,54.31948,-1.12731),(-.50762,54.34469,-1.11806),(-.68421,54.19875,-.99388),(-.47345,54.43111,-.82538),(-.50406,54.44753,-.87791),(-.50514,54.38042,-.867),(-.42683,54.50643,-.79667),(-.47735,54.54141,-.87189),(-.44754,54.48013,-.79545),(-.49948,54.51415,-.96956),(-.47747,54.56316,-.96553),(-.45894,54.572,-1.07776),(-.19379,54.20345,-.69014),(-.25232,54.21716,-.73763),(-.33135,54.43583,-.82866),(-.40381,54.49847,-.88495),(-.18335,54.43412,-1.19146),(-.25706,54.46458,-1.21152),(-.23353,54.41166,-1.05602),(-.16505,54.40484,-1.04964),(-.32145,54.51372,-1.20328),(-.34337,54.51421,-1.14957),(-.17316,53.99063,-.69323),(-.2239,54.06833,-.74318),(-.24887,53.94755,-.75738),(-.17928,53.84623,-.72385),(-.18575,53.8638,-.77509),(-.63234,53.9308,-1.32722),(-.63704,54.00763,-1.24663),(-.79918,53.86291,-1.37179),(-.87352,53.83807,-1.39423),(-.78454,53.78754,-1.45501),(-.60552,53.9027,-1.35491),(-.68004,53.95471,-1.30929),(-.84706,54.00895,-1.25185),(-.8542,54.00644,-1.25627),(-.67149,53.84314,-1.52437),(-.67562,54.06647,-1.49387),(-.58152,53.94346,-1.52429),(-.24911,54.02154,-1.77206),(-.15692,54.08095,-1.84415),(-.73907,54.05442,-1.47439),(-.90243,54.05815,-1.32757),(-.84893,54.16433,-1.37723),(-.58959,54.1647,-1.50311),(-.57941,54.22123,-1.49312),(-.58022,54.5141,-1.16124),(-.52004,54.49669,-1.19227),(-.59945,54.47928,-1.23531),(-.87052,54.32129,-1.41237),(-.0903,54.04346,-1.92562),(-.16431,53.94449,-2.01224),(-.15429,54.01631,-1.91725),(-.00702,53.78154,-1.98043),(-.22268,53.95371,-1.72084),(-.31058,53.94225,-1.62629),(-.32516,53.86702,-1.62721),(-.7682,54.34489,-1.1339),(-.70543,54.3482,-1.12462),(-.65402,54.4584,-1.11091),(-.66077,54.39596,-1.13497),(-.36741,53.94525,-1.55457),(-.41788,53.94212,-1.47615),(-.00565,53.81727,-2.05914),(-.28422,54.33204,-.75717),(-.25953,54.45756,-1.21805),(-.29093,54.03794,-1.2107),(-.33739,54.17129,-1.18281),(-.45406,54.43966,-1.15484),(-.47425,54.42323,-1.10892),(-.45815,54.50691,-1.13007),(-.48504,54.42597,-1.06425),(-.56813,54.28231,-1.11185),(-.54077,54.31818,-.88279),(-.46,54.35964,-1.15597),(-.48166,54.35512,-1.166),(-.5166,54.49312,-1.18707),(-.51823,54.41622,-1.17105),(-.46524,54.46159,-1.24371),(-.49046,54.35479,-1.17835),(-.44186,54.32361,-1.39244),(-.61746,54.10614,-.92731),(-.48293,54.20446,-.94775),(-.52885,54.1625,-.93443),(-.83036,54.1455,-1.01393),(-.64117,54.26834,-1.09565),(-.53738,54.22358,-.93118),(-.63238,54.27559,-1.10121),(-.45873,54.08208,-.93622),(-.52119,54.10768,-.93735),(-.51933,54.10557,-.93397),(-.41634,54.11962,-.88533),(-.51695,54.38733,-1.15673),(-.80146,54.22961,-1.16239),(-.51725,54.49329,-1.18674),(-.89799,54.55434,-1.21087),(-.70145,54.0745,-1.15429),(-.49963,53.84837,-1.40461),(-.50627,53.84291,-1.40147),(-.4986,53.84099,-1.40858),(-.51473,54.17979,-1.51081),(-.10306,54.11105,-1.75343),(-.39364,53.85273,-1.55447),(-.22019,53.8236,-1.78525),(-.24629,53.91348,-1.78285),(-.23784,53.90746,-1.80423),(-.11689,53.73103,-2.16481),(-.17757,53.79049,-2.18131),(-.11926,53.71406,-2.16051),(-.1322,53.7086,-2.15938),(-.24536,53.84988,-1.74018),(-.25153,53.85446,-1.73348),(-.25404,53.85436,-1.73727),(-.2025,53.78334,-1.88053),(-.44241,54.39747,-1.31636),(-.41988,54.32903,-1.4452),(-.08778,54.22777,-1.70959),(-.78023,54.29529,-1.46957),(.45667,54.20731,-1.00326),(.46567,54.22188,-1.05567),(.4678,54.279,-1.03679),(.45399,54.10419,-1.09786),(.42857,54.09335,-1.02746),(.39187,54.05637,-.94319),(.35532,54.12507,-.85634),(.72989,54.05062,-1.07411),(.71771,54.07878,-1.14566),(.67982,54.20751,-.88886),(.51626,54.34017,-.9399),(.47345,54.43111,-.82538),(.44472,54.40915,-.81273),(.48839,54.34248,-.86157),(.36649,54.41095,-.76048),(.28422,54.33204,-.75717),(.25232,54.21716,-.73763),(.31086,54.23058,-.78534),(.32404,54.31372,-.76491),(.24593,54.41739,-1.06079),(.26441,54.34203,-.78124),(.15693,54.32574,-.74834),(.16678,54.30671,-.70798),(.08436,53.88313,-.66532),(.18159,53.85198,-.71457),(.18742,53.91333,-.70478),(.27165,53.9382,-1.04951),(.19544,53.91288,-.85463),(.2876,53.93529,-1.13933),(.29523,53.92716,-1.2016),(.59401,54.0471,-1.21366),(.67149,53.84314,-1.52437),(.58406,53.8458,-1.53576),(.77235,54.23125,-1.45554),(.90803,54.44114,-1.20365),(.50516,54.21917,-1.49724),(.27173,54.26602,-1.61062),(.29259,54.15678,-1.68138),(.18778,54.24674,-1.66792),(.15245,53.89826,-2.07945),(.07808,53.86077,-2.06472),(.12752,53.88678,-1.82261),(.24536,53.84988,-1.74018),(.82219,54.47086,-1.11968),(.57084,53.78308,-1.45188),(.67218,53.77336,-1.47694),(.59854,54.27106,-.93094),(.28627,54.36779,-.83663),(.28292,54.38732,-.89576),(.45894,54.572,-1.07776),(.47944,54.50852,-1.07563),(.39039,54.54566,-1.17534),(.40292,54.54481,-1.17581),(.3932,54.53981,-1.18135),(.38109,54.29287,-.81853),(.3285,54.32814,-.76292),(.51447,54.12593,-.9158),(.29872,53.9338,-1.20888),(.308,53.96259,-.91339),(.37062,54.18526,-1.16678),(.27459,54.24846,-1.20902),(.345,54.04369,-1.1668),(.4308,54.17958,-1.15047),(.4695,54.39892,-1.14799),(.416,54.38718,-.80009),(.45009,54.26019,-.85376),(.44105,54.28562,-1.15751),(.51102,54.0883,-1.22968),(.47601,54.10214,-1.18707),(.48186,54.30577,-1.28092),(.51893,54.1204,-1.29098),(.73914,54.19725,-.90415),(.79046,54.12682,-.93798),(.59417,54.29223,-.8922),(.46353,54.16475,-1.07455),(.63921,54.21659,-1.10443),(.67808,54.19598,-.99417),(.6526,54.22161,-.95128),(.61191,54.20529,-.93326),(.61025,54.21641,-.93275),(.52774,54.42028,-1.16649),(.39172,54.46964,-1.1925),(.4294,54.39293,-1.16653),(.38279,54.30895,-1.18166),(.74123,54.38911,-1.44584),(.84706,54.00895,-1.25185),(.68756,54.01962,-1.22755),(.7356,53.95684,-1.29365),(.90924,53.97594,-1.36715),(.84653,53.99975,-1.25727),(.49532,53.90884,-1.35531),(.48761,53.9144,-1.35853),(.19513,54.17674,-1.68024),(.20431,54.104,-1.70338),(.29096,54.10602,-1.61919),(.3857,54.21842,-1.49053),(.10306,54.11105,-1.75343),(.18684,53.8298,-2.14655),(.11215,53.79473,-2.12995),(.07953,53.73064,-2.03458),(.2001,53.74614,-2.01123),(.1865,53.75991,-1.95531),(.00599,53.77736,-1.99415),(.10191,53.70931,-2.10459),(.33367,53.86681,-1.6318),(.41957,53.96887,-1.58259),(.2025,53.78334,-1.88053),(.07368,53.7625,-1.96436),(.2689,54.2645,-1.60823),(.21387,53.73247,-2.06711),(.19497,53.767,-1.95622),(.34758,53.95242,-1.64732),(.17116,53.89244,-2.0822),(.37892,54.3058,-1.49564),(.27952,54.18814,-1.61395),(.54155,54.06076,-1.2612),(.82054,54.09776,-1.09483),(.56876,54.27148,-1.11081),(.64496,54.16247,-1.11097),(.44268,54.15002,-1.01432),(.61426,54.17259,-.90203),(.78453,54.13768,-.94321),(.4686,54.25312,-1.35724),(.33753,54.28723,-1.19579),(.43413,54.55978,-1.13188),(.27605,54.3478,-.77827),(.44966,54.21576,-1.54157),(.56803,54.45165,-1.28266),(.44739,54.42944,-1.29092),(.46902,54.46553,-1.2473),(.74579,54.159,-1.45545),(.50826,53.97158,-1.53382),(.8707,53.88662,-1.43288),(.5497,54.05326,-1.25289),(.09736,53.83094,-.69018),(.29041,54.46078,-1.07599),(.83727,54.17849,-1.09111),(.82065,54.2358,-1.08524),(.61507,54.16834,-.93539),(-.38075,54.30689,-1.49875),(-.10191,53.70931,-2.10459),(-.47713,53.85215,-1.53376),(-.87794,53.84084,-1.39909),(-.57567,53.78669,-1.44352),(-.70741,54.07664,-1.14031),(-.69026,54.06019,-1.17243),(-.89321,54.55823,-1.2147),(-.52941,54.36254,-1.39428),(-.5245,54.351,-1.39626),(-.65072,54.10835,-1.1175),(-.49935,54.37485,-1.14008),(-.61756,54.10904,-.935),(-.81135,54.2382,-1.07651),(-.61426,54.17259,-.90203),(-.62327,54.22721,-.89184),(-.50842,54.44201,-.97327),(-.43063,54.50268,-1.16862),(-.18196,54.42789,-1.1991),(-.3289,54.43461,-.76974),(-.31187,54.40671,-.76777),(-.27592,54.33704,-.76357),(-.41848,54.5097,-.8032),(-.36854,54.47928,-.77995),(-.38127,54.48579,-.81543),(0,53.89802,-1.90136),(-.71899,54.40639,-1.11541),(-.78505,54.44696,-1.35317),(-.57652,54.42386,-1.32671),(-.64074,54.49945,-1.21621),(-.44776,54.40608,-1.31884),(-.83452,54.06616,-1.40526),(-.21477,53.99298,-1.83441),(-.58064,54.06227,-1.50861),(-.2084,53.75435,-2.01131),(-.21322,53.78957,-2.01862),(-.74621,53.83548,-1.41751),(-.1802,54.05763,-.69441),(-.17236,54.29663,-.70089),(-.47944,54.50852,-1.07563),(-.49924,54.50367,-.87408),(-.82504,54.11954,-.97522),(-.56876,54.27148,-1.11081),(-.45132,54.12448,-1.41379),(-.35609,54.03512,-1.15207),(-.48839,54.34248,-.86157),(-.24593,54.41739,-1.06079),(-.15693,54.32574,-.74834),(-.5497,54.05326,-1.25289),(-.67776,53.81805,-1.42902),(-.62887,53.82965,-1.41528),(-.59762,53.85772,-1.39038),(-.77235,54.23125,-1.45554),(-.82219,54.47086,-1.11968),(-.27605,54.3478,-.77827),(-.3932,54.53981,-1.18135),(-.40292,54.54481,-1.17581),(-.39039,54.54566,-1.17534),(-.51447,54.12593,-.9158),(-.345,54.04369,-1.1668),(-.44105,54.28562,-1.15751),(-.47601,54.10214,-1.18707),(-.4686,54.25312,-1.35724),(-.44472,54.40915,-.81273),(-.38279,54.30895,-1.18166),(-.4294,54.39293,-1.16653),(-.39172,54.46964,-1.1925),(-.29096,54.10602,-1.61919),(-.34758,53.95242,-1.64732),(-.2689,54.2645,-1.60823),(.53113,54.24738,-.88354),(.48509,54.37791,-1.05635),(.50406,54.44753,-.87791),(.49924,54.50367,-.87408),(.17316,53.99063,-.69323),(.58064,54.06227,-1.50861),(.59945,54.47928,-1.23531),(.15429,54.01631,-1.91725),(.65402,54.4584,-1.11091),(.25535,53.89667,-.77227),(.43063,54.50268,-1.16862),(.52885,54.1625,-.93443),(.81135,54.2382,-1.07651),(.80894,54.49926,-1.29573),(.52119,54.10768,-.93735),(.50627,53.84291,-1.40147),(.23784,53.90746,-1.80423),(.24629,53.91348,-1.78285),(.25404,53.85436,-1.73727),(.25153,53.85446,-1.73348),(.33212,54.28011,-1.55032),(.33602,54.2819,-1.55244),(.32516,53.86702,-1.62721),(.12951,53.72102,-2.17492),(.13906,53.717,-2.17408),(.17255,53.77744,-2.19025),(.1673,53.77555,-2.18966),(.2056,53.8447,-1.97249),(.30085,54.02371,-1.62279),(.46946,54.01944,-1.38616),(.41129,54.03337,-1.48446),(0,54.16844,-1.7416),(.09741,54.17488,-1.72554),(0,54.23294,-1.71903),(.34096,54.2008,-1.55159),(.78724,53.78876,-1.46056),(.82098,54.57652,-1.14145),(.7448,54.56475,-1.11263),(.82303,54.57326,-1.13588),(.74362,54.56827,-1.119),(.57771,54.51061,-1.15519),(.72689,54.48428,-1.27399),(.69211,54.41457,-1.36851),(.32579,54.50885,-1.20835),(.33264,54.43368,-1.20845),(.11037,54.03433,-1.21336),(.1999,54.1259,-1.20273),(.20544,54.02742,-1.21106),(.10551,54.13125,-1.20041),(.21155,53.9232,-1.21417),(.26605,54.37111,-1.21878),(.18846,54.3237,-1.19954),(.09689,53.82689,-.70008),(0,53.93291,-1.2056),(.11583,53.93033,-1.22145),(.11651,53.92329,-1.2145),(0,53.93885,-1.21251),(.47747,54.56316,-.96553),(.46758,54.54397,-.87466),(.46727,54.56525,-.96596),(.08144,54.30519,-.67541),(0,54.29413,-.65287),(.08464,54.2949,-.66729),(0,54.30484,-.6606),(.2744,54.36116,-.83715),(.42301,54.56171,-1.13074),(.37568,54.47584,-.77268),(.40392,54.45133,-.77299),(.66357,54.53873,-1.12461),(.73867,54.47383,-1.09352),(.31058,53.94225,-1.62629),(.68651,54.51661,-1.20437),(.66373,54.54211,-1.13151),(.74561,54.53748,-1.19822),(.44697,54.07733,-1.56793),(.5248,54.06768,-1.5187),(.18709,53.95768,-1.91649),(.19036,53.9167,-1.99575),(.29298,53.93733,-1.71962),(.30297,54.046,-1.70129),(.62887,53.82965,-1.41528),(.67776,53.81805,-1.42902),(.21221,53.91743,-1.2071),(.21443,53.93498,-1.13282),(.20611,53.93827,-.9548),(.11861,53.94813,-1.03767),(.21173,53.94028,-1.03879),(.1163,53.94556,-.93786),(.11854,53.91776,-.85179),(.1147,53.85347,-.7645),(.08616,53.97088,-.6529),(.10029,54.12459,-.65382),(.09296,54.03883,-.65443),(.19728,54.12672,-.6977),(0,54.21908,-.63987),(0,54.11483,-.64198),(.10649,54.21124,-.65277),(.31439,54.45239,-.99433),(.39815,54.51831,-.97937),(.07892,54.32423,-.7172),(0,54.3867,-.95313),(.07781,54.37022,-.87392),(.07836,54.38746,-.95726),(0,54.36914,-.87347),(.15938,54.39004,-.97736),(.08489,54.40593,-1.04178),(.27446,54.40797,-.99005),(.49948,54.51415,-.96956),(.51201,54.18317,-.89163),(.42356,54.19502,-.8633),(.36716,54.2101,-.83148),(-.46946,54.01944,-1.38616),(-.33602,54.2819,-1.55244),(-.33212,54.28011,-1.55032),(-.1673,53.77555,-2.18966),(-.14263,53.75452,-2.18376),(-.20051,53.72737,-2.17794),(-.13906,53.717,-2.17408),(-.2056,53.8447,-1.97249),(-.2049,53.86512,-2.06323),(-.19036,53.9167,-1.99575),(-.50826,53.97158,-1.53382),(-.41129,54.03337,-1.48446),(-.30085,54.02371,-1.62279),(-.09741,54.17488,-1.72554),(-.78724,53.78876,-1.46056),(-.66147,54.36734,-1.43464),(-.57771,54.51061,-1.15519),(-.82303,54.57326,-1.13588),(-.82098,54.57652,-1.14145),(-.48316,54.0926,-1.17847),(-.51872,54.07786,-1.21536),(-.65774,54.34884,-1.13612),(-.5043,54.38434,-1.16311),(-.80438,54.52673,-1.24741),(-.80894,54.49926,-1.29573),(-.5062,54.17027,-1.12833),(-.5748,54.16819,-1.13272),(-.33264,54.43368,-1.20845),(-.26605,54.37111,-1.21878),(-.32579,54.50885,-1.20835),(-.10551,54.13125,-1.20041),(0,54.04312,-1.20639),(-.11037,54.03433,-1.21336),(0,54.13604,-1.19018),(-.18846,54.3237,-1.19954),(-.19411,54.22465,-1.19978),(-.09505,54.32591,-1.19066),(-.08959,54.4299,-1.18257),(-.09689,53.82689,-.70008),(0,53.82368,-.66829),(-.09736,53.83094,-.69018),(0,53.81988,-.67822),(-.42356,54.19502,-.8633),(-.36716,54.2101,-.83148),(-.08918,54.43534,-1.17482),(-.42301,54.56171,-1.13074),(-.43413,54.55978,-1.13188),(-.46758,54.54397,-.87466),(-.08464,54.2949,-.66729),(-.08144,54.30519,-.67541),(-.26153,54.40205,-.98874),(-.27446,54.40797,-.99005),(-.37166,54.52203,-1.0744),(-.4498,54.57512,-1.07519),(-.39815,54.51831,-.97937),(-.46727,54.56525,-.96596),(-.40392,54.45133,-.77299),(-.10041,54.22844,-1.19284),(0,54.23073,-1.18462),(-.7448,54.56475,-1.11263),(-.73867,54.47383,-1.09352),(-.66357,54.53873,-1.12461),(-.29259,54.15678,-1.68138),(-.72689,54.48428,-1.27399),(-.68651,54.51661,-1.20437),(-.74561,54.53748,-1.19822),(-.66373,54.54211,-1.13151),(-.30297,54.046,-1.70129),(-.29298,53.93733,-1.71962),(-.35904,54.05145,-1.63327),(-.71257,53.88077,-1.368),(-.79417,53.9448,-1.30529),(-.21443,53.93498,-1.13282),(-.21173,53.94028,-1.03879),(0,53.95711,-1.03358),(-.1163,53.94556,-.93786),(-.11861,53.94813,-1.03767),(0,53.94919,-.93082),(0,53.92098,-.8447),(-.1147,53.85347,-.7645),(-.11854,53.91776,-.85179),(0,53.85247,-.75168),(-.20611,53.93827,-.9548),(-.18742,53.91333,-.70478),(-.09296,54.03883,-.65443),(-.08616,53.97088,-.6529),(-.19728,54.12672,-.6977),(-.24664,54.14102,-.74707),(-.10649,54.21124,-.65277),(-.10029,54.12459,-.65382),(-.31439,54.45239,-.99433),(-.07892,54.32423,-.7172),(0,54.32507,-.70543),(0,54.34855,-.78443),(-.07781,54.37022,-.87392),(-.07951,54.34665,-.79057),(-.15787,54.36672,-.88978),(-.07836,54.38746,-.95726),(-.15938,54.39004,-.97736),(-.51201,54.18317,-.89163),(-.53113,54.24738,-.88354),(-.08489,54.40593,-1.04178),(-.08436,53.88313,-.66532),(-.18159,53.85198,-.71457),(-.21221,53.91743,-1.2071),(-.80671,53.90823,-1.33617),(-.2146,53.88234,-1.89347),(-.18709,53.95768,-1.91649),(-.44697,54.07733,-1.56793),(-.5248,54.06768,-1.5187),(-.34749,54.18503,-1.62172),(-.74362,54.56827,-1.119),(-.69211,54.41457,-1.36851),(-.1999,54.1259,-1.20273),(-.37568,54.47584,-.77268),(-.15917,54.3427,-.80085),(-.2744,54.36116,-.83715),(-.27006,54.38117,-.89539),(0,54.43148,-1.1836),(0,54.43819,-1.1757),(-.30177,54.14829,-.80432),(-.21155,53.9232,-1.21417),(0,54.32543,-1.17906),(-.11583,53.93033,-1.22145),(-.34978,54.11562,-1.55258),(-.34096,54.2008,-1.55159),(-.35859,54.03043,-1.55358),(-.19912,53.76555,-2.18771),(-.17255,53.77744,-2.19025),(-.12776,53.73355,-2.17809),(-.12951,53.72102,-2.17492),(.57162,54.2226,-1.12118),(.65774,54.34884,-1.13612),(.26153,54.40205,-.98874),(.15787,54.36672,-.88978),(.07951,54.34665,-.79057),(.37166,54.52203,-1.0744),(.24664,54.14102,-.74707),(.79417,53.9448,-1.30529),(.2049,53.86512,-2.06323),(.35904,54.05145,-1.63327),(.78684,54.53893,-1.21827),(.66147,54.36734,-1.43464),(.5043,54.38434,-1.16311),(.10041,54.22844,-1.19284),(.4498,54.57512,-1.07519),(.27006,54.38117,-.89539),(.09505,54.32591,-1.19066),(.5748,54.16819,-1.13272),(.80438,54.52673,-1.24741),(.58022,54.5141,-1.16124),(.34978,54.11562,-1.55258),(.35859,54.03043,-1.55358),(.13702,53.75944,-2.1725),(.20051,53.72737,-2.17794),(.14263,53.75452,-2.18376),(.11689,53.73103,-2.16481),(.12776,53.73355,-2.17809),(.19912,53.76555,-2.18771),(.5062,54.17027,-1.12833),(.51251,54.23857,-1.10819),(.19411,54.22465,-1.19978),(.08959,54.4299,-1.18257),(.08918,54.43534,-1.17482),(.34749,54.18503,-1.62172),(.64074,54.49945,-1.21621),(.2146,53.88234,-1.89347),(.12026,53.93727,-1.12943),(0,53.96231,-.63883),(0,53.87227,-.64809),(0,54.02954,-.64007),(.30177,54.14829,-.80432),(.08824,54.42275,-1.11765),(0,54.42019,-1.10895),(0,54.40381,-1.0319),(.15917,54.3427,-.80085),(-.78684,54.53893,-1.21827),(-.20544,54.02742,-1.21106),(-.11651,53.92329,-1.2145),(0,53.9485,-1.1319),(-.12026,53.93727,-1.12943),(-.08824,54.42275,-1.11765)]),
          normal=Normal(vector=[(-.9991,.041,-.011),(-.9987,.0509,.0018),(-.998,-.0503,.0393),(-.9977,-.0677,-.0077),(-.9905,-.0849,.1079),(-.9903,.0446,-.1317),(-.9867,-.114,.1161),(-.9855,.0184,.1685),(-.983,.0202,-.1826),(-.983,.0517,-.1763),(-.9818,-.1855,-.0397),(-.9794,.193,.0588),(-.9791,.0449,.1983),(-.9781,.0506,-.2018),(-.9771,.1772,.1176),(-.9759,.0715,-.206),(-.973,.122,.1959),(-.9704,-.0042,-.2414),(-.97,.078,-.2302),(-.9697,.205,.133),(-.9696,-.1705,-.1753),(-.9684,-.2474,-.0302),(-.9662,-.1918,-.1721),(-.966,-.2174,.1403),(-.9624,-.205,.1782),(-.9602,.2732,-.0582),(-.9599,-.1884,.2077),(-.9595,.1129,.2583),(-.959,.2411,-.1487),(-.9558,.0187,-.2934),(-.9525,.1695,-.2531),(-.9516,.2172,.2174),(-.9512,-.1922,.2413),(-.9489,-.0568,-.3105),(-.948,.101,.3018),(-.9475,-.1533,.2806),(-.9473,.1419,.287),(-.9468,-.0016,-.322),(-.9439,.1784,-.278),(-.9419,-.1273,-.3107),(-.9374,.185,-.2952),(-.9349,-.351,.0519),(-.9288,-.2432,.2797),(-.9243,.2533,-.2855),(-.9227,-.3323,.1956),(-.9162,-.1702,.3629),(-.9139,-.1136,.3897),(-.9098,.2695,.3156),(-.9087,-.1714,-.3807),(-.9072,-.1645,.3871),(-.9024,.431,-.0005),(-.9023,-.3907,.1822),(-.9018,.1156,-.4165),(-.8948,-.4136,-.1684),(-.8893,.0678,.4524),(-.888,.2979,-.3503),(-.8879,.4249,-.1763),(-.8858,.4197,-.198),(-.8816,.3674,-.2962),(-.8807,.1283,-.456),(-.8805,-.1049,-.4623),(-.8761,-.1429,.4605),(-.8723,.457,.1743),(-.8702,-.2438,.4282),(-.8682,-.2101,-.4495),(-.8681,-.0304,.4954),(-.8676,-.4947,.051),(-.8675,.3976,.299),(-.8655,-.3992,.3026),(-.8643,-.0214,.5026),(-.8638,-.4728,.1739),(-.8592,-.2864,.424),(-.856,.0979,-.5076),(-.856,-.511,-.0786),(-.8557,-.2458,-.4552),(-.8547,.2196,-.4703),(-.85,-.4625,.2523),(-.8443,.3811,-.3767),(-.8443,-.2159,.4905),(-.8403,.2621,-.4746),(-.8371,.4795,.2631),(-.837,-.0465,.5452),(-.8357,.5374,.1129),(-.8296,.3987,.3909),(-.8289,-.0372,.5582),(-.8274,-.5387,-.159),(-.8272,-.0237,-.5614),(-.8266,-.0753,-.5578),(-.826,-.5578,.0812),(-.8256,-.4725,-.3085),(-.8248,-.563,.0525),(-.8227,-.4509,-.3463),(-.8224,-.5636,.0779),(-.8215,-.1052,.5605),(-.8189,-.2938,-.493),(-.8184,-.365,.4438),(-.8178,.5288,-.2272),(-.8139,.3898,.4308),(-.8129,-.3942,.4287),(-.8058,-.1051,-.5828),(-.8044,.3119,.5057),(-.8017,-.5973,.0234),(-.7996,-.5217,-.2975),(-.7951,-.5902,-.1397),(-.7918,-.0579,.608),(-.786,-.3272,.5246),(-.783,-.1526,-.603),(-.7771,-.1568,.6095),(-.7768,-.0267,.6292),(-.7747,-.0952,.6251),(-.7733,.1782,-.6085),(-.7686,.6397,.002),(-.7669,-.6412,.0261),(-.7652,.5266,.3703),(-.7633,-.627,.1554),(-.7625,-.1513,.6291),(-.7606,.4685,.4494),(-.7602,.0479,.6479),(-.7562,-.0485,.6526),(-.7562,.1242,-.6425),(-.7557,-.114,-.6449),(-.7515,.259,.6067),(-.7501,-.1053,.6529),(-.7495,.0015,.662),(-.7483,-.0184,-.6631),(-.7479,-.3743,.5483),(-.7463,-.287,.6005),(-.7451,-.1083,-.6581),(-.745,-.0837,.6618),(-.7449,.2495,-.6187),(-.7447,-.1685,.6458),(-.743,-.1194,.6586),(-.7347,-.6759,.0576),(-.734,.0797,-.6744),(-.7337,-.1662,.6589),(-.7332,-.1044,.6719),(-.7328,-.5001,-.4615),(-.7257,-.3685,.581),(-.7237,.5846,.3667),(-.7219,-.0579,.6895),(-.7185,.0205,-.6952),(-.7182,.039,-.6948),(-.7162,-.0802,.6932),(-.7148,.6871,.13),(-.7138,-.1558,.6828),(-.7137,.0195,-.7002),(-.7113,.1136,-.6937),(-.7088,.7044,-.0388),(-.7072,-.1477,.6914),(-.7069,-.3778,.598),(-.7068,-.636,.3097),(-.7045,.5238,.4789),(-.7018,.0511,.7105),(-.6986,.236,.6754),(-.6977,.656,.288),(-.6957,-.4441,.5646),(-.6951,.7025,.1527),(-.6947,-.6469,-.3145),(-.6895,-.0572,-.722),(-.689,-.7231,-.0496),(-.689,-.1616,.7065),(-.6802,.0649,-.7301),(-.679,-.7039,-.2085),(-.6781,.7091,.1933),(-.6773,.715,.1732),(-.6757,-.3792,-.6322),(-.6746,.1425,.7243),(-.6727,.2416,.6993),(-.6711,.5375,.5106),(-.6673,-.6407,.3797),(-.6649,-.2187,.7142),(-.6629,.715,.2221),(-.6621,-.7363,.1396),(-.662,.7326,-.1583),(-.6596,.4246,-.6202),(-.6587,.311,-.6851),(-.6575,.7128,-.2442),(-.6528,-.2382,.7191),(-.6503,-.0753,.7559),(-.6477,-.0984,-.7555),(-.6463,-.6924,.3208),(-.6444,.1912,-.7404),(-.6418,-.1457,.7529),(-.6377,.1819,-.7485),(-.6371,-.1795,-.7496),(-.6359,-.1999,-.7455),(-.6345,.5345,.5584),(-.6314,-.5925,.5003),(-.6314,-.5994,.492),(-.6307,.0602,.7737),(-.6267,.7762,.0696),(-.6224,-.7506,.2217),(-.6219,-.1555,.7675),(-.6219,-.0649,-.7804),(-.6211,.3505,-.701),(-.6195,.4935,.6105),(-.6179,-.6092,.497),(-.6148,.6465,.4517),(-.6148,.786,-.0658),(-.6116,.2347,-.7555),(-.6102,-.4558,.648),(-.61,.787,.0929),(-.6096,.521,.5974),(-.6076,-.4923,.6232),(-.6068,.6121,-.507),(-.6037,.7578,.2475),(-.5999,.164,.7831),(-.5983,.7784,.1902),(-.5945,-.0916,.7988),(-.5943,-.7563,-.2734),(-.5941,-.1893,-.7818),(-.5922,-.0733,.8024),(-.5892,-.7609,-.272),(-.5875,.768,.2548),(-.5833,.4406,-.6824),(-.5819,.2678,-.7679),(-.5747,.8023,.1616),(-.5733,-.1973,.7952),(-.5729,-.2688,.7743),(-.5707,-.0683,-.8183),(-.5702,-.5944,.5671),(-.5671,-.7887,-.2373),(-.5667,-.823,.0394),(-.5645,.7342,.3772),(-.5636,.7863,.2529),(-.5622,.363,-.7431),(-.5593,.8127,-.1634),(-.5591,-.828,.0431),(-.5578,.6062,.5669),(-.5566,.3754,.7411),(-.5548,.3636,-.7483),(-.5521,.4367,-.7102),(-.5519,-.1119,.8263),(-.5514,.0684,-.8314),(-.5491,-.2354,.8019),(-.5485,-.7222,.4214),(-.5446,-.8191,.1802),(-.5439,.7711,.3311),(-.5424,.5627,-.6238),(-.5415,-.0198,.8405),(-.5412,.7035,-.4606),(-.5397,.5397,-.6462),(-.5391,-.5349,.6506),(-.5377,-.7645,.3555),(-.5372,.8288,.1563),(-.5363,.7158,-.4473),(-.5359,.4007,.7431),(-.5359,-.0175,.8441),(-.5328,-.8436,-.0664),(-.5268,-.3873,.7566),(-.5223,-.015,-.8527),(-.5212,-.2587,.8133),(-.5169,-.3444,.7837),(-.516,-.2788,.8099),(-.515,.7077,-.4836),(-.5124,.6112,-.6032),(-.51,.0274,.8597),(-.509,.0424,.8597),(-.5059,-.8612,.0488),(-.5054,-.3003,.8089),(-.5029,-.7123,.4895),(-.4999,.5051,.7036),(-.4984,-.6015,-.6243),(-.4947,.5679,.6579),(-.493,-.2492,.8336),(-.4922,-.1369,.8596),(-.492,.1933,-.8489),(-.4917,.8538,.1711),(-.4904,.0212,-.8712),(-.4892,-.2623,.8318),(-.4812,.3892,-.7855),(-.4778,-.3573,.8025),(-.4754,-.2867,.8317),(-.4753,-.8475,-.2363),(-.473,-.1162,.8734),(-.4716,.5589,.6821),(-.4694,-.7985,.3767),(-.4685,-.2789,.8383),(-.4656,-.8815,.0783),(-.4655,-.0784,-.8816),(-.4588,-.1961,-.8666),(-.4537,.7843,-.4232),(-.4522,.8395,.3013),(-.4522,.851,-.2671),(-.4507,-.269,.8512),(-.4481,.13,-.8845),(-.4475,-.1254,-.8854),(-.4449,-.7516,-.4871),(-.4425,-.3924,-.8064),(-.4381,-.8068,-.3964),(-.4373,.556,.7069),(-.4343,.1654,-.8855),(-.4339,.2152,.8749),(-.4319,.7154,-.5492),(-.4315,.8361,-.3388),(-.4278,-.2698,.8627),(-.4273,-.7882,-.4429),(-.4269,-.3669,.8266),(-.4268,-.2407,-.8717),(-.4263,.5904,-.6854),(-.4257,-.5929,.6836),(-.4251,.2331,-.8747),(-.4243,.8584,-.2882),(-.4222,.2706,.8652),(-.4198,-.0239,-.9073),(-.4113,.5417,-.7331),(-.4106,-.1906,.8917),(-.4102,-.7898,.456),(-.4097,.327,-.8516),(-.4052,.0595,.9123),(-.4052,-.8569,.3185),(-.4028,.5803,.7078),(-.3996,.0999,.9112),(-.3941,-.53,-.7509),(-.3929,-.5114,.7643),(-.3926,-.8313,.3935),(-.3849,.0233,-.9227),(-.3835,.0179,.9234),(-.3797,.8661,.3251),(-.3776,-.8672,.3246),(-.3769,-.9246,.0559),(-.3766,.8361,.3989),(-.373,-.8983,.2324),(-.3726,.018,.9278),(-.372,-.4576,-.8076),(-.3702,.638,-.6752),(-.3696,-.9157,.1578),(-.3654,-.2045,.9081),(-.3649,-.1132,-.9241),(-.3646,-.249,.8973),(-.3621,.452,.8153),(-.3599,.5605,.7459),(-.356,.6836,-.6372),(-.3555,.6136,-.7051),(-.352,-.5297,-.7717),(-.3513,-.3193,.8802),(-.3492,.9109,-.2199),(-.347,.0822,-.9342),(-.347,-.7239,-.5963),(-.3469,.4269,.8351),(-.3455,-.2921,.8918),(-.345,.2424,-.9067),(-.345,-.0958,-.9337),(-.3442,-.3675,.864),(-.3401,.5576,-.7573),(-.3392,-.8617,.3774),(-.3374,-.1962,.9207),(-.3368,.4786,-.8109),(-.3333,.2401,-.9117),(-.332,.9242,-.189),(-.3284,.6707,-.6651),(-.3273,.9407,-.0886),(-.3263,.5307,-.7822),(-.3252,.9452,.0283),(-.3244,.0028,-.9459),(-.3226,-.7713,.5486),(-.3191,-.0293,-.9473),(-.3186,.0272,-.9475),(-.3184,.0297,-.9475),(-.3183,.6664,-.6743),(-.3168,-.6228,.7154),(-.3126,.9304,-.1913),(-.3091,-.0852,-.9472),(-.3067,.8985,.3141),(-.3057,-.5091,.8046),(-.3014,-.9499,.0828),(-.2995,-.3882,.8715),(-.2991,.9102,.2866),(-.296,-.9157,-.272),(-.2916,.9557,-.0408),(-.2905,-.0768,.9538),(-.2896,.4277,.8563),(-.2881,-.954,-.0833),(-.2879,-.7405,.6072),(-.2877,-.2338,.9287),(-.2866,-.0146,.9579),(-.2864,-.0646,.9559),(-.2852,-.9258,.2482),(-.2846,.9175,.2779),(-.2842,-.5964,.7507),(-.2839,-.5288,-.7998),(-.2818,.7785,-.5608),(-.2811,.3246,.9031),(-.2787,-.686,.6721),(-.2774,.6277,-.7274),(-.2764,.9588,.0661),(-.2715,-.0324,.9619),(-.2711,.0892,.9584),(-.2707,.2742,.9228),(-.2706,.8284,-.4905),(-.2697,.0861,-.9591),(-.2673,.9403,-.2108),(-.2668,.9223,.2796),(-.2645,.0041,-.9644),(-.2618,.8,-.5398),(-.2615,-.0702,.9626),(-.2591,-.6265,.735),(-.2586,-.8444,.4691),(-.2585,-.3585,.897),(-.2575,.835,-.4863),(-.2558,.9375,.2357),(-.2547,.7182,.6475),(-.251,.5014,-.828),(-.2497,.3212,-.9135),(-.249,.873,-.4195),(-.2478,.5759,-.7791),(-.2474,.6813,-.689),(-.2465,.8052,-.5394),(-.2463,.3898,-.8874),(-.2449,.0404,-.9687),(-.2443,-.1,-.9645),(-.2426,-.8521,.4638),(-.241,.1518,.9586),(-.24,.8856,.3977),(-.2394,.91,-.3385),(-.2393,-.9684,-.0708),(-.2332,-.8161,-.5288),(-.2331,.3616,-.9027),(-.2331,.8174,-.5268),(-.2322,-.7997,.5537),(-.2308,.2608,.9374),(-.2284,.8675,-.4419),(-.2252,-.0266,-.974),(-.2251,-.1719,.9591),(-.2237,.5763,.7861),(-.2233,.0928,-.9703),(-.2218,.4368,.8718),(-.2203,-.9443,-.2446),(-.2188,.6496,.7282),(-.2184,-.8056,.5507),(-.2151,-.0005,-.9766),(-.2114,-.7818,.5865),(-.2113,.4168,.8841),(-.2108,.9644,-.1595),(-.2084,.4505,-.8681),(-.2058,.9508,.2314),(-.2055,-.8466,.4909),(-.2046,-.9214,.3304),(-.2042,.9704,.1285),(-.2032,-.9637,-.1733),(-.2027,-.9543,.2195),(-.1982,.8649,-.4612),(-.198,.0544,.9787),(-.1929,.8673,-.4589),(-.1928,.844,-.5004),(-.1918,-.9507,.2436),(-.1906,.2903,-.9378),(-.1882,-.9327,.3078),(-.1864,-.9806,-.0611),(-.1851,-.1237,.9749),(-.1846,.9692,.1632),(-.1815,-.8908,-.4166),(-.1808,.1593,-.9705),(-.1807,.6152,-.7674),(-.1798,.5291,.8293),(-.1792,.8813,-.4372),(-.1791,-.2887,.9405),(-.1789,.7858,.592),(-.1753,-.7308,.6597),(-.175,.2703,-.9467),(-.1725,.9471,.2706),(-.1697,-.2911,-.9415),(-.1668,-.5601,.8115),(-.1662,.085,-.9824),(-.1642,.8929,-.4193),(-.1641,.0024,-.9864),(-.1634,.7282,-.6656),(-.1619,.6227,.7655),(-.1608,.3839,.9092),(-.1606,-.5401,-.8261),(-.1563,-.9372,.3118),(-.1525,.0146,-.9882),(-.1522,.7876,.597),(-.1513,-.509,.8473),(-.15,.1268,.9805),(-.1491,-.854,.4985),(-.1482,-.8991,-.4118),(-.1453,.147,.9784),(-.1404,-.6093,.7804),(-.1396,-.5107,.8484),(-.1391,-.9903,-.0069),(-.1375,-.0189,-.9903),(-.1363,-.8144,-.564),(-.1337,.8259,-.5477),(-.1317,-.6486,.7496),(-.131,.1314,-.9826),(-.1293,-.4625,-.8772),(-.1282,-.9317,.3399),(-.1209,.8674,-.4827),(-.1183,-.205,.9716),(-.118,.4074,.9056),(-.1162,.9931,-.0183),(-.1137,-.3417,.9329),(-.1129,-.2679,.9568),(-.1123,.0387,-.9929),(-.1105,-.725,.6799),(-.1059,.9921,.0667),(-.1034,.0106,-.9946),(-.1027,.5839,-.8053),(-.1018,.1404,-.9848),(-.0995,-.0749,.9922),(-.0993,-.6294,.7707),(-.0985,.5581,-.8239),(-.0972,-.944,.3153),(-.0958,-.9926,.075),(-.0941,.7935,-.6013),(-.0932,.9305,.3542),(-.0928,-.9896,.1102),(-.0909,-.2563,.9623),(-.0882,.5054,.8584),(-.0837,.8998,-.4282),(-.0826,-.93,.3582),(-.0825,-.9957,.0412),(-.0809,.0408,-.9959),(-.0809,-.6259,.7757),(-.0803,.4885,-.8689),(-.0791,.0117,-.9968),(-.0768,.2963,-.952),(-.0767,.9334,-.3504),(-.0742,-.9823,-.1717),(-.0731,-.7814,.6198),(-.0724,-.9447,-.3198),(-.0723,-.0059,-.9974),(-.0722,-.9876,.1394),(-.0719,-.4324,-.8988),(-.0714,.9946,-.0752),(-.0712,-.7108,.6997),(-.0689,.9668,.2459),(-.0688,.9573,.2808),(-.0685,-.7011,.7097),(-.0674,.5524,-.8309),(-.0674,-.0586,.996),(-.0653,-.7337,.6763),(-.0621,-.7045,.707),(-.0603,-.156,.9859),(-.0574,.2068,-.9767),(-.0574,-.7437,.666),(-.0568,-.2153,.9749),(-.0561,.1007,-.9933),(-.0516,-.8947,-.4436),(-.049,.9319,.3594),(-.0469,.366,.9294),(-.0464,.9712,.2338),(-.0457,-.029,-.9985),(-.0439,-.7104,.7025),(-.0432,-.6521,.7569),(-.0431,-.9837,.1744),(-.0423,-.9709,-.2357),(-.0422,.2684,-.9624),(-.0418,.0687,.9968),(-.0417,-.6865,.7259),(-.0417,-.2729,.9611),(-.0414,-.9987,.0282),(-.0411,-.6813,.7308),(-.0407,.1571,-.9867),(-.0406,.739,-.6725),(-.0397,.8481,-.5284),(-.0374,.3648,-.9303),(-.0365,-.9607,-.275),(-.0361,-.6478,-.7609),(-.0342,.5689,.8217),(-.0337,-.9912,-.1278),(-.0337,-.3454,-.9378),(-.0326,-.9877,-.1527),(-.0322,-.689,.724),(-.0314,-.7622,.6466),(-.0303,-.9473,-.3189),(-.0282,.9727,.2305),(-.0276,.0561,-.998),(-.0272,.057,-.998),(-.027,.9734,.2274),(-.0255,.3154,.9486),(-.0214,.9761,.2165),(-.0212,.9754,.2193),(-.0208,.0952,-.9952),(-.0194,.5876,.8089),(-.0189,.383,-.9236),(-.018,-.879,-.4765),(-.0174,.9794,.2012),(-.0157,-.3295,-.944),(-.0145,.9769,.213),(-.0142,-.9303,-.3665),(-.0128,-.7853,.619),(-.0125,.6181,-.786),(-.012,-.1519,.9883),(-.0119,-.7301,-.6832),(-.0116,.6358,-.7717),(-.011,.958,.2867),(-.0109,-.6256,.7801),(-.0106,-.7705,.6374),(-.0088,.9842,-.1767),(-.0082,.967,.2548),(-.0077,-.0431,-.999),(-.0045,-.9904,.1383),(-.0041,-.6603,.751),(-.0028,-.6542,.7563),(-.0011,.9995,-.0312),(-.0008,-.3128,-.9498),(-.0005,.9995,-.033),(0,-.0075,1),(0,.0178,.9998),(0,-.0566,.9984),(0,.088,.9961),(0,-.252,.9677),(0,.2721,.9623),(0,.382,.9242),(0,-.3934,.9194),(0,-.4061,.9138),(0,-.5113,.8594),(0,-.5253,.8509),(0,-.528,.8492),(0,-.5861,.8103),(0,-.6988,.7154),(0,.7602,.6497),(0,.9345,.356),(0,.9634,.2682),(0,.9721,.2346),(0,.9754,.2203),(0,.9776,.2106),(0,.9776,.2104),(0,-.9894,.1453),(0,.9913,.1316),(0,-.9996,.027),(0,-.9999,.0147),(0,-.9799,-.1994),(0,.9737,-.2277),(0,-.972,-.235),(0,-.8874,-.461),(0,-.8699,-.4932),(0,.6184,-.7859),(0,.4885,-.8726),(0,.4061,-.9138),(0,-.3766,-.9264),(0,.1169,-.9931),(0,.108,-.9942),(0,.0481,-.9988),(0,.0391,-.9992),(.0006,.9735,-.2286),(.0018,-.6284,.7779),(.0026,.9731,-.2302),(.0041,-.6603,.751),(.0045,-.9904,.1383),(.0077,-.0431,-.999),(.0082,.967,.2548),(.0088,.9842,-.1767),(.011,.958,.2867),(.0128,.7728,-.6345),(.0142,-.9303,-.3665),(.0145,.9769,.213),(.0158,.6713,-.741),(.0174,.9794,.2012),(.0176,.6671,.7447),(.0178,-.7773,.6289),(.018,-.879,-.4765),(.0189,.383,-.9236),(.0198,-.7823,.6226),(.02,-.9381,-.3459),(.0208,.0952,-.9952),(.0212,.9754,.2193),(.0212,-.6481,.7612),(.0214,.9761,.2165),(.0232,.6542,-.756),(.0234,.6051,-.7958),(.0242,-.6846,.7285),(.0248,.582,.8128),(.0255,.3154,.9486),(.027,.9734,.2274),(.0272,.057,-.998),(.0276,.0561,-.998),(.0279,.7214,-.6919),(.0282,.9727,.2305),(.0298,-.1617,.9864),(.0307,.6634,.7476),(.0326,-.9877,-.1527),(.0337,-.3454,-.9378),(.0337,-.9912,-.1278),(.0342,.5689,.8217),(.0361,-.6478,-.7609),(.0365,-.9607,-.275),(.0366,.2289,-.9728),(.0397,.8481,-.5284),(.0407,-.7667,.6407),(.0407,.1571,-.9867),(.0414,-.9987,.0282),(.0417,-.2729,.9611),(.0418,.0687,.9968),(.0422,.2684,-.9624),(.0423,-.9709,-.2357),(.0431,-.9837,.1744),(.0432,-.6521,.7569),(.0459,-.6867,.7255),(.0464,.9712,.2338),(.0467,-.1744,.9836),(.0471,-.7222,-.6901),(.049,.9319,.3594),(.0491,-.2259,.9729),(.0499,-.6848,.727),(.0502,-.7133,.6991),(.0514,-.0335,-.9981),(.0516,-.8947,-.4436),(.0523,-.6562,.7528),(.0537,.3807,-.9231),(.0561,.1007,-.9933),(.0587,-.0987,.9934),(.0607,.3483,.9354),(.0642,-.7337,.6764),(.0658,-.678,.7321),(.0668,.1143,-.9912),(.0674,-.0586,.996),(.0674,.5524,-.8309),(.0688,.9573,.2808),(.0689,.9668,.2459),(.0694,-.9153,.3968),(.0696,-.2448,.9671),(.0712,-.7108,.6997),(.0719,-.4324,-.8988),(.0719,.037,-.9967),(.0722,-.9876,.1394),(.0724,-.9447,-.3198),(.0724,-.3512,.9335),(.0741,.2992,-.9513),(.0742,-.9823,-.1717),(.0747,-.9088,.4104),(.0748,-.7079,.7023),(.0757,-.7787,.6227),(.0785,.9335,-.3499),(.0791,.0117,-.9968),(.0803,-.0517,-.9954),(.0803,.4885,-.8689),(.0809,.0408,-.9959),(.0825,-.9957,.0412),(.0837,.8998,-.4282),(.0882,.5054,.8584),(.0919,.3839,.9188),(.0928,-.9896,.1102),(.0932,.9305,.3542),(.0951,-.9442,.3153),(.0958,-.9926,.075),(.0991,.8459,-.524),(.1023,.1405,.9848),(.1059,.9921,.0667),(.1067,.6015,-.7917),(.1112,.4934,.8627),(.1123,.0387,-.9929),(.1127,-.7286,.6756),(.1149,.9933,.0142),(.1162,.9931,-.0183),(.1183,-.205,.9716),(.1203,-.255,.9594),(.1209,.8674,-.4827),(.1238,-.4588,-.8799),(.1296,-.4937,-.8599),(.1304,.5268,-.84),(.1325,-.6143,.7779),(.1326,-.5216,.8428),(.1337,.8259,-.5477),(.1375,-.0189,-.9903),(.1391,-.9903,-.0069),(.1396,-.5107,.8484),(.1407,.1225,-.9824),(.1453,.147,.9784),(.1463,-.6409,.7536),(.1477,-.8186,-.555),(.1482,-.8991,-.4118),(.1491,-.854,.4985),(.1522,.7876,.597),(.1546,-.0089,-.9879),(.1598,-.7933,.5875),(.1601,.0298,-.9867),(.1604,-.9307,.3288),(.1606,.7257,-.669),(.1608,.3839,.9092),(.1618,-.5584,.8136),(.1643,.4262,-.8896),(.1652,.8899,-.4253),(.1662,.085,-.9824),(.1705,.6129,-.7715),(.1713,-.2888,-.9419),(.1725,.9471,.2706),(.1753,-.7308,.6597),(.1789,.7858,.592),(.1791,-.2887,.9405),(.1792,.8813,-.4372),(.1808,.1593,-.9705),(.1815,-.8908,-.4166),(.1834,.272,-.9447),(.1846,.9692,.1632),(.186,.2624,.9469),(.1864,-.9806,-.0611),(.1867,.6141,.7668),(.1882,-.9327,.3078),(.1906,.2903,-.9378),(.1918,-.9507,.2436),(.1928,.844,-.5004),(.1929,.8673,-.4589),(.1935,-.9189,.3439),(.1954,-.196,.9609),(.1982,.8649,-.4612),(.1992,-.1136,.9733),(.1994,-.9548,.2205),(.2032,-.9637,-.1733),(.2042,.9704,.1285),(.2058,.9508,.2314),(.2082,-.0621,-.9761),(.2084,.4505,-.8681),(.2108,.9644,-.1595),(.2113,.4168,.8841),(.2114,-.7818,.5865),(.2179,.3724,-.9021),(.2188,.6496,.7282),(.2193,-.8513,.4767),(.2203,-.9443,-.2446),(.2218,.4368,.8718),(.2233,.0928,-.9703),(.2237,.5763,.7861),(.2251,.0322,.9738),(.2252,-.0266,-.974),(.2284,.8675,-.4419),(.229,.8027,-.5507),(.2299,.9518,-.2032),(.2308,.2608,.9374),(.2322,-.7997,.5537),(.2331,.8174,-.5268),(.2331,.0102,-.9724),(.2332,-.8161,-.5288),(.2393,-.9684,-.0708),(.2394,.91,-.3385),(.24,.3954,-.8866),(.24,.8856,.3977),(.2424,-.8541,.4601),(.2449,-.852,.4626),(.245,.6835,-.6876),(.2464,.0606,-.9673),(.2478,.5759,-.7791),(.249,.873,-.4195),(.2497,.3212,-.9135),(.251,.5014,-.828),(.2547,.7182,.6475),(.2558,.9375,.2357),(.2575,.835,-.4863),(.2585,-.3585,.897),(.2591,-.6265,.735),(.2617,.0238,-.9649),(.2645,.0041,-.9644),(.2662,.446,.8546),(.2668,.9223,.2796),(.2682,.2758,.923),(.2692,-.0537,.9616),(.2711,.0892,.9584),(.2715,-.0324,.9619),(.273,.9592,.0732),(.2739,.8132,-.5135),(.2751,.6229,-.7324),(.2787,-.686,.6721),(.2794,-.0613,.9582),(.2797,.3097,.9088),(.2806,-.7338,.6187),(.2818,.7785,-.5608),(.2821,-.9195,-.2736),(.2832,-.6004,.7478),(.2839,-.5288,-.7998),(.2864,-.0646,.9559),(.2866,-.0146,.9579),(.2877,-.2338,.9287),(.2881,-.954,-.0833),(.2916,.9557,-.0408),(.2979,.9226,.2452),(.2991,.9102,.2866),(.2995,-.3882,.8715),(.3016,-.9154,.2666),(.3035,-.0965,-.9479),(.3046,-.9489,.0819),(.3057,-.5091,.8046),(.3067,.8985,.3141),(.3129,.6601,-.6829),(.3168,-.6228,.7154),(.3183,.6664,-.6743),(.3184,.0297,-.9475),(.3191,-.0293,-.9473),(.3193,.2196,-.9219),(.3208,.4914,-.8097),(.3244,.0028,-.9459),(.3252,.9452,.0283),(.3262,-.7816,.5317),(.3263,.5307,-.7822),(.3273,.9407,-.0886),(.329,.0064,-.9443),(.3292,.9257,-.1864),(.3308,.8063,-.4904),(.3333,.2401,-.9117),(.3377,-.7177,-.609),(.3401,.5576,-.7573),(.3429,-.9161,.2076),(.3441,-.2166,.9136),(.345,-.0958,-.9337),(.3455,-.2921,.8918),(.3469,.4269,.8351),(.347,.0822,-.9342),(.3489,-.8589,.3749),(.3497,-.3929,.8505),(.3513,-.3193,.8802),(.3541,-.5302,-.7704),(.3552,-.5781,-.7346),(.3555,.6136,-.7051),(.3559,.9241,-.1391),(.3599,.5605,.7459),(.3621,.452,.8153),(.3622,.8379,.4084),(.3654,-.2045,.9081),(.3662,.6787,-.6366),(.369,.9051,-.2112),(.3696,-.9157,.1578),(.3702,.638,-.6752),(.372,-.4576,-.8076),(.3769,-.9246,.0559),(.3813,-.1485,-.9124),(.3835,.0179,.9234),(.3849,.0233,-.9227),(.3926,-.8313,.3935),(.3929,-.5114,.7643),(.3974,-.8637,.31),(.3985,-.7954,.4566),(.3996,.0999,.9112),(.4004,-.3932,.8277),(.4015,.8409,-.3628),(.4028,.5803,.7078),(.4048,-.2804,.8704),(.4052,-.8569,.3185),(.4052,.0595,.9123),(.4106,-.1906,.8917),(.4113,.5417,-.7331),(.4198,-.0239,-.9073),(.4242,.2848,.8596),(.4244,.0702,.9027),(.4251,.2331,-.8747),(.4255,-.1884,.8852),(.4273,-.7882,-.4429),(.4302,.8545,-.2911),(.4318,-.2342,-.871),(.4339,.2152,.8749),(.4343,.1654,-.8855),(.4351,-.3874,-.8128),(.4373,.556,.7069),(.4381,-.8068,-.3964),(.4391,.7198,-.5376),(.4409,-.8129,.3806),(.4449,-.7516,-.4871),(.4473,-.0655,-.892),(.4475,-.1254,-.8854),(.4481,.13,-.8845),(.4505,.6064,-.6552),(.4507,-.269,.8512),(.4522,.851,-.2671),(.4579,.8265,.3275),(.4599,.8218,.3365),(.4618,-.5949,.6579),(.4656,-.8815,.0783),(.4685,-.2789,.8383),(.4716,.5589,.6821),(.4717,-.8523,-.226),(.474,-.1245,.8717),(.4778,-.3573,.8025),(.4812,.3892,-.7855),(.4836,-.1202,.867),(.4854,-.1765,-.8563),(.4892,-.2623,.8318),(.4892,-.2877,.8233),(.4895,.0631,.8697),(.4912,-.2727,.8272),(.4914,-.299,.818),(.4929,-.2457,.8347),(.4939,.5529,.6711),(.4944,-.8672,.0587),(.4945,.764,-.4145),(.4947,.5679,.6579),(.497,.1918,-.8463),(.4984,-.6015,-.6243),(.51,.0274,.8597),(.5124,.6112,-.6032),(.515,.7077,-.4836),(.5158,-.7196,.465),(.5169,-.3444,.7837),(.5212,-.2587,.8133),(.5223,-.015,-.8527),(.5271,.8338,.1643),(.5273,-.7313,.4327),(.5328,-.8436,-.0664),(.5328,.8342,.1423),(.533,-.0314,.8455),(.5339,-.0387,-.8447),(.5355,.5443,-.6458),(.5363,.7158,-.4473),(.5373,.8221,-.1884),(.5374,.403,.7408),(.5375,-.0133,.8432),(.5377,-.7645,.3555),(.5391,-.5349,.6506),(.5394,-.2334,.8091),(.5416,.4359,-.7188),(.5424,.5627,-.6238),(.5439,.7711,.3311),(.5446,-.8191,.1802),(.5496,-.2964,.7811),(.5514,.0684,-.8314),(.5519,-.1119,.8263),(.5525,.6894,-.4684),(.5548,.3636,-.7483),(.557,-.7808,-.283),(.5578,.6062,.5669),(.5621,-.2546,.7869),(.5622,.363,-.7431),(.5632,-.5977,.5706),(.5636,.7863,.2529),(.5645,.7342,.3772),(.5652,.3624,.7411),(.5678,-.8219,.0459),(.5707,-.0683,-.8183),(.5726,-.0511,.8182),(.5747,.8023,.1616),(.5752,-.8163,.0519),(.576,.7729,.2661),(.5797,.2562,-.7735),(.5833,.4406,-.6824),(.5875,.768,.2548),(.5933,-.1669,-.7875),(.5945,-.0916,.7988),(.5951,-.7595,-.2627),(.5983,.7784,.1902),(.5987,-.7807,-.1794),(.5999,.164,.7831),(.6076,-.4923,.6232),(.61,.787,.0929),(.6111,-.2535,.7498),(.6113,.6143,-.4989),(.6114,.5219,.5948),(.6116,.2347,-.7555),(.6148,.786,-.0658),(.6148,.6465,.4517),(.6195,.4935,.6105),(.6211,.3505,-.701),(.6249,-.7477,.2245),(.6283,-.1025,.7712),(.6283,-.6222,.467),(.6299,-.7014,.3335),(.6307,.0602,.7737),(.6314,-.5925,.5003),(.6345,.5345,.5584),(.6346,.771,.0536),(.6377,.1819,-.7485),(.6399,.327,-.6954),(.6414,-.0684,-.7642),(.6422,-.1907,-.7424),(.6444,.1912,-.7404),(.6464,-.1815,.7411),(.6527,-.1884,-.7339),(.6528,-.1629,.7398),(.6528,-.2382,.7191),(.6528,.4469,-.6117),(.657,-.4235,.6237),(.6629,.715,.2221),(.6657,.7081,-.2354),(.6673,-.6407,.3797),(.6692,.0517,-.7413),(.6707,.7186,-.1838),(.6711,.5375,.5106),(.6741,-.0636,-.7359),(.6757,-.3792,-.6322),(.6773,.715,.1732),(.6787,.1354,.7218),(.679,-.7039,-.2085),(.6798,-.1766,.7118),(.6802,.0649,-.7301),(.6803,-.7096,.1833),(.6847,-.7289,.0033),(.687,-.6504,.324),(.6872,-.5479,.4771),(.6876,.7085,.1587),(.6903,-.4034,.6007),(.6905,-.1907,.6977),(.6947,-.6469,-.3145),(.6951,.7025,.1527),(.6977,.656,.288),(.6986,.236,.6754),(.7045,.5238,.4789),(.707,.7068,-.0254),(.7073,.2403,.6648),(.709,-.4448,.5472),(.7094,.0062,-.7048),(.7137,.0195,-.7002),(.7138,-.1558,.6828),(.7148,.6871,.13),(.715,-.1457,.6838),(.7152,-.1437,.684),(.7162,-.0632,.695),(.7208,-.0187,-.6929),(.7208,-.1329,.6803),(.7237,.5846,.3667),(.7245,.0905,-.6833),(.7294,.0509,.6822),(.7332,-.0021,-.68),(.7332,-.1044,.6719),(.734,-.489,-.4713),(.734,.0797,-.6744),(.736,-.6743,.0596),(.743,-.1194,.6586),(.7435,-.0885,.6629),(.7449,.2495,-.6187),(.745,-.0837,.6618),(.7451,-.1083,-.6581),(.7463,-.287,.6005),(.7492,-.0542,.6601),(.7495,.0015,.662),(.7499,.2507,.6122),(.7505,-.3751,.5441),(.7515,-.1324,.6463),(.7557,-.114,-.6449),(.7562,.1242,-.6425),(.7562,-.0485,.6526),(.7606,.4685,.4494),(.7624,-.3774,.5256),(.7633,-.627,.1554),(.7678,.5059,.393),(.7681,-.6291,-.1194),(.7686,.6397,.002),(.7733,.1782,-.6085),(.7745,.0492,.6306),(.7747,-.0952,.6251),(.7771,-.1568,.6095),(.783,-.1526,-.603),(.786,-.3272,.5246),(.788,-.0357,.6147),(.7918,-.0579,.608),(.7951,-.5902,-.1397),(.7992,.3137,.5126),(.8014,-.5969,.0388),(.8016,-.0535,.5954),(.8058,-.1051,-.5828),(.8106,.4989,-.3065),(.8116,-.5096,-.2856),(.8182,.3772,.4338),(.8189,-.2938,-.493),(.8212,.5578,.1205),(.8224,-.0606,-.5657),(.8248,-.563,.0525),(.8253,-.5595,.0768),(.8256,-.4725,-.3085),(.8256,-.3763,.4205),(.8274,-.5387,-.159),(.8289,-.0372,.5582),(.8295,-.441,-.3427),(.8296,.3987,.3909),(.8297,-.4149,.3733),(.832,-.0909,.5472),(.8366,.4789,.2658),(.84,-.0029,-.5426),(.8403,.2621,-.4746),(.8434,-.2176,.4913),(.8446,.379,-.3781),(.85,-.4625,.2523),(.8547,.2196,-.4703),(.8557,-.2458,-.4552),(.856,-.511,-.0786),(.856,.0979,-.5076),(.8568,-.513,.0521),(.8604,-.2863,.4215),(.8643,-.0214,.5026),(.8655,-.3992,.3026),(.8657,-.4713,.1684),(.8675,.3976,.299),(.8681,-.0304,.4954),(.8682,-.2101,-.4495),(.8686,-.4903,-.0718),(.8702,-.2438,.4282),(.8723,.457,.1743),(.8775,.1214,-.4639),(.8805,-.1049,-.4623),(.8816,.3674,-.2962),(.8843,-.1228,.4505),(.8858,.4197,-.198),(.8879,.4249,-.1763),(.888,.2979,-.3503),(.8893,.0678,.4524),(.8948,-.4136,-.1684),(.8985,-.403,.1743),(.899,-.0268,-.4372),(.9014,-.1555,.4041),(.9072,-.1645,.3871),(.9098,.2695,.3156),(.914,-.2098,-.3471),(.9162,-.1702,.3629),(.9185,.2692,-.2896),(.9227,-.3323,.1956),(.9228,.3814,-.0543),(.9288,-.2432,.2797),(.9326,.2064,-.296),(.9349,-.351,.0519),(.9419,-.1273,-.3107),(.9436,.192,-.2699),(.944,.1474,.2953),(.945,.1887,-.2673),(.9475,-.1533,.2806),(.948,.101,.3018),(.9483,-.0137,-.317),(.9489,-.0568,-.3105),(.9512,-.1922,.2413),(.9523,.2187,.2127),(.9561,.2844,-.0711),(.9584,.2341,.1633),(.959,.2411,-.1487),(.9624,-.205,.1782),(.9656,.0087,-.26),(.9662,-.1918,-.1721),(.9681,-.2058,.143),(.9684,-.2474,-.0302),(.9724,.0633,-.2247),(.9726,.0382,-.2295),(.973,.122,.1959),(.975,-.1555,-.159),(.9758,.0867,.2006),(.976,-.1606,.1471),(.9768,.0615,.2051),(.9771,.1772,.1176),(.9785,.0672,-.1951),(.9786,.042,-.2014),(.9805,.188,.0578),(.9821,.057,-.1795),(.9822,-.1753,-.0676),(.983,.0517,-.1763),(.9855,.0184,.1685),(.9867,-.114,.1161),(.9903,.0446,-.1317),(.9918,-.0878,.0928),(.9963,-.0844,-.0144),(.9965,-.0702,.045),(.9991,.041,-.011),(.9993,.0272,.0253)]))),
      Shape(DEF='c4disc',
        appearance=Appearance(
          material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),shininess=0.050,specularColor=(.9647,.949,.9098))),
        geometry=IndexedFaceSet(DEF='c4disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,5,6,-1,7,8,9,-1,10,11,12,-1,13,11,10,-1,14,15,16,-1,17,18,19,-1,12,11,20,-1,21,22,23,-1,10,24,25,-1,16,26,27,-1,28,29,30,-1,31,30,29,-1,32,33,34,-1,35,36,9,-1,23,8,37,-1,38,31,39,-1,40,41,42,-1,43,44,45,-1,46,47,0,-1,48,49,50,-1,51,45,4,-1,1,4,3,-1,52,53,54,-1,54,55,52,-1,53,56,57,-1,58,59,60,-1,61,62,63,-1,64,65,35,-1,66,67,33,-1,57,56,18,-1,14,59,68,-1,69,14,70,-1,70,14,71,-1,72,1,0,-1,46,0,73,-1,49,40,34,-1,56,13,19,-1,20,74,75,-1,65,76,36,-1,77,22,78,-1,60,79,58,-1,53,57,80,-1,81,52,55,-1,82,83,84,-1,62,85,84,-1,54,86,87,-1,88,62,87,-1,68,58,79,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,45,51,98,-1,50,99,100,-1,43,101,102,-1,103,104,105,-1,106,107,101,-1,47,95,97,-1,28,41,40,-1,7,108,109,-1,32,110,33,-1,110,32,111,-1,111,112,110,-1,113,31,73,-1,40,114,34,-1,115,16,116,-1,117,118,119,-1,14,16,115,-1,21,119,120,-1,117,37,8,-1,121,9,112,-1,122,123,69,-1,26,16,15,-1,93,2,3,-1,2,1,3,-1,34,33,67,-1,3,94,93,-1,91,122,69,-1,124,121,112,-1,7,117,8,-1,120,12,21,-1,111,124,112,-1,18,17,125,-1,115,71,14,-1,20,11,13,-1,19,13,25,-1,117,109,118,-1,125,126,127,-1,113,73,128,-1,112,36,110,-1,7,109,117,-1,39,31,113,-1,101,99,106,-1,103,105,129,-1,101,105,102,-1,99,98,100,-1,45,98,43,-1,95,46,96,-1,92,130,93,-1,89,91,70,-1,68,79,131,-1,88,63,62,-1,55,54,87,-1,81,62,84,-1,84,132,82,-1,81,133,52,-1,80,54,53,-1,78,75,77,-1,65,36,35,-1,75,78,20,-1,66,33,110,-1,67,49,34,-1,47,72,0,-1,71,89,70,-1,14,69,59,-1,46,73,29,-1,29,96,46,-1,57,18,80,-1,56,19,18,-1,64,35,134,-1,58,68,59,-1,53,52,56,-1,70,91,69,-1,1,72,4,-1,51,4,72,-1,50,100,48,-1,46,95,47,-1,40,42,114,-1,38,30,31,-1,23,134,8,-1,36,112,9,-1,34,114,32,-1,31,29,73,-1,28,30,41,-1,116,16,27,-1,37,21,23,-1,12,20,78,-1,19,25,17,-1,10,25,13,-1,12,120,10,-1,121,7,9,-1,94,3,6,-1,122,91,135,-1,125,80,18,-1,2,73,0,-1,136,137,138,-1,136,90,137,-1,21,117,119,-1,117,21,37,-1,139,140,24,-1,139,141,140,-1,142,143,144,-1,143,142,145,-1,146,147,148,-1,147,146,149,-1,126,141,150,-1,126,140,141,-1,151,128,152,-1,151,113,128,-1,108,121,153,-1,121,108,7,-1,154,108,153,-1,154,155,108,-1,38,156,157,-1,38,158,156,-1,159,113,151,-1,39,113,159,-1,107,65,129,-1,107,76,65,-1,50,106,99,-1,106,50,160,-1,104,161,162,-1,104,103,161,-1,101,98,99,-1,98,101,43,-1,163,164,165,-1,164,163,166,-1,100,96,48,-1,97,96,100,-1,90,167,137,-1,167,90,89,-1,131,86,168,-1,131,79,86,-1,135,169,61,-1,136,169,135,-1,169,170,85,-1,171,170,169,-1,87,81,55,-1,87,62,81,-1,161,132,162,-1,132,161,82,-1,172,82,161,-1,77,82,172,-1,66,36,76,-1,66,110,36,-1,125,168,80,-1,168,125,127,-1,93,152,128,-1,93,130,152,-1,130,173,152,-1,130,174,173,-1,48,29,28,-1,48,96,29,-1,23,64,134,-1,172,64,23,-1,69,60,59,-1,60,69,123,-1,52,74,56,-1,52,133,74,-1,85,61,169,-1,85,62,61,-1,171,136,138,-1,171,169,136,-1,174,137,167,-1,174,175,137,-1,6,165,164,-1,176,165,6,-1,44,102,176,-1,102,44,43,-1,49,160,50,-1,160,49,67,-1,64,129,65,-1,129,64,103,-1,157,30,38,-1,157,41,30,-1,151,149,159,-1,151,177,149,-1,146,156,158,-1,156,146,145,-1,155,109,108,-1,155,142,109,-1,17,24,140,-1,25,24,17,-1,116,148,147,-1,116,27,148,-1,144,150,141,-1,150,144,143,-1,120,24,10,-1,120,139,24,-1,78,21,12,-1,21,78,22,-1,177,178,179,-1,173,178,177,-1,173,167,178,-1,173,174,167,-1,92,6,164,-1,92,94,6,-1,175,138,137,-1,166,138,175,-1,109,144,118,-1,109,142,144,-1,143,146,148,-1,145,146,143,-1,149,179,147,-1,149,177,179,-1,26,150,27,-1,26,126,150,-1,152,177,151,-1,177,152,173,-1,8,35,9,-1,134,35,8,-1,180,121,124,-1,180,153,121,-1,157,155,154,-1,156,155,157,-1,158,39,159,-1,158,38,39,-1,180,114,42,-1,114,180,32,-1,44,4,45,-1,44,5,4,-1,51,47,97,-1,51,72,47,-1,76,106,66,-1,106,76,107,-1,181,162,182,-1,181,104,162,-1,182,165,181,-1,163,165,182,-1,98,97,100,-1,98,51,97,-1,79,87,86,-1,87,79,88,-1,171,182,170,-1,171,163,182,-1,162,170,182,-1,132,170,162,-1,83,77,75,-1,83,82,77,-1,60,88,79,-1,60,123,88,-1,61,122,135,-1,61,63,122,-1,48,40,49,-1,48,28,40,-1,68,15,14,-1,15,68,131,-1,178,89,71,-1,178,167,89,-1,15,168,127,-1,15,131,168,-1,2,128,73,-1,2,93,128,-1,20,56,74,-1,56,20,13,-1,77,23,22,-1,77,172,23,-1,135,90,136,-1,90,135,91,-1,75,133,83,-1,74,133,75,-1,83,81,84,-1,83,133,81,-1,132,85,170,-1,84,85,132,-1,168,54,80,-1,168,86,54,-1,138,163,171,-1,138,166,163,-1,63,123,122,-1,63,88,123,-1,92,174,130,-1,175,174,92,-1,176,5,44,-1,176,6,5,-1,181,176,102,-1,181,165,176,-1,102,104,181,-1,102,105,104,-1,101,129,105,-1,129,101,107,-1,66,160,67,-1,106,160,66,-1,103,172,161,-1,103,64,172,-1,154,41,157,-1,154,42,41,-1,159,146,158,-1,149,146,159,-1,156,142,155,-1,145,142,156,-1,42,153,180,-1,42,154,153,-1,180,111,32,-1,111,180,124,-1,17,126,125,-1,17,140,126,-1,115,147,179,-1,147,115,116,-1,143,27,150,-1,143,148,27,-1,118,141,139,-1,118,144,141,-1,120,118,139,-1,119,118,120,-1,71,179,178,-1,71,115,179,-1,126,15,127,-1,126,26,15,-1,164,175,92,-1,175,164,166,-1],creaseAngle=1.571,normalIndex=[116,105,36,-1,32,17,33,-1,32,33,51,-1,71,79,45,-1,113,149,135,-1,167,149,113,-1,76,107,104,-1,53,174,179,-1,135,149,155,-1,102,112,96,-1,113,63,142,-1,104,46,78,-1,72,75,129,-1,62,129,75,-1,69,4,38,-1,44,26,45,-1,96,79,82,-1,80,62,127,-1,54,132,115,-1,21,28,13,-1,30,8,116,-1,3,0,14,-1,6,13,17,-1,105,17,32,-1,161,169,165,-1,165,166,161,-1,169,162,176,-1,180,150,178,-1,153,159,168,-1,52,29,44,-1,19,1,4,-1,176,162,174,-1,76,150,164,-1,147,76,156,-1,156,76,148,-1,16,105,116,-1,30,116,57,-1,0,54,38,-1,162,167,179,-1,155,157,152,-1,29,23,26,-1,128,112,136,-1,178,177,180,-1,169,176,182,-1,160,161,166,-1,138,154,145,-1,159,137,145,-1,165,171,170,-1,175,159,170,-1,164,180,177,-1,151,139,146,-1,43,25,37,-1,2,9,5,-1,13,6,10,-1,14,12,7,-1,21,20,40,-1,41,48,34,-1,18,22,20,-1,8,2,5,-1,72,132,54,-1,71,66,100,-1,69,11,4,-1,11,69,61,-1,61,31,11,-1,42,62,57,-1,54,144,38,-1,122,104,47,-1,101,110,111,-1,76,104,122,-1,102,111,124,-1,101,82,79,-1,60,45,31,-1,163,173,147,-1,46,104,107,-1,25,36,32,-1,36,105,32,-1,38,4,1,-1,32,37,25,-1,146,163,147,-1,123,60,31,-1,71,101,79,-1,124,135,102,-1,61,123,31,-1,174,53,119,-1,122,148,76,-1,155,149,167,-1,179,167,142,-1,101,100,110,-1,119,55,109,-1,42,57,24,-1,31,26,11,-1,71,100,101,-1,127,62,42,-1,20,12,18,-1,41,34,27,-1,20,34,40,-1,12,10,7,-1,13,10,21,-1,2,30,9,-1,43,35,25,-1,151,146,156,-1,164,177,172,-1,175,168,159,-1,166,165,170,-1,160,159,145,-1,145,134,138,-1,160,158,161,-1,182,165,169,-1,136,152,128,-1,29,26,44,-1,152,136,155,-1,19,4,11,-1,1,0,38,-1,8,16,116,-1,148,151,156,-1,76,147,150,-1,30,57,75,-1,75,9,30,-1,176,174,182,-1,162,179,174,-1,52,44,68,-1,180,164,150,-1,169,161,162,-1,156,146,147,-1,105,16,17,-1,6,17,16,-1,14,7,3,-1,30,2,8,-1,54,115,144,-1,80,129,62,-1,96,68,79,-1,26,31,45,-1,38,144,69,-1,62,75,57,-1,72,129,132,-1,47,104,78,-1,82,102,96,-1,135,155,136,-1,179,142,53,-1,113,142,167,-1,135,124,113,-1,60,71,45,-1,37,32,51,-1,163,146,143,-1,119,182,174,-1,36,57,116,-1,126,133,125,-1,126,139,133,-1,102,101,111,-1,101,102,82,-1,97,67,63,-1,97,106,67,-1,89,114,117,-1,114,89,88,-1,87,77,108,-1,77,87,86,-1,55,106,103,-1,55,67,106,-1,58,24,39,-1,58,42,24,-1,66,60,81,-1,60,66,71,-1,73,66,81,-1,73,64,66,-1,80,65,74,-1,80,70,65,-1,99,42,58,-1,127,42,99,-1,22,29,27,-1,22,23,29,-1,14,18,12,-1,18,14,15,-1,48,94,93,-1,48,41,94,-1,20,10,12,-1,10,20,21,-1,92,56,59,-1,56,92,90,-1,7,9,3,-1,5,9,7,-1,139,141,133,-1,141,139,151,-1,172,171,181,-1,172,177,171,-1,143,130,153,-1,126,130,143,-1,130,131,137,-1,120,131,130,-1,170,160,166,-1,170,159,160,-1,94,134,93,-1,134,94,138,-1,95,138,94,-1,128,138,95,-1,19,26,23,-1,19,11,26,-1,119,181,182,-1,181,119,109,-1,25,39,24,-1,25,35,39,-1,35,85,39,-1,35,83,85,-1,3,75,72,-1,3,9,75,-1,96,52,68,-1,95,52,96,-1,147,178,150,-1,178,147,173,-1,161,157,162,-1,161,158,157,-1,137,153,130,-1,137,159,153,-1,120,126,125,-1,120,130,126,-1,83,133,141,-1,83,98,133,-1,51,59,56,-1,50,59,51,-1,28,40,50,-1,40,28,21,-1,0,15,14,-1,15,0,1,-1,52,27,29,-1,27,52,41,-1,74,129,80,-1,74,132,129,-1,58,86,99,-1,58,84,86,-1,87,65,70,-1,65,87,88,-1,64,100,66,-1,64,89,100,-1,53,63,67,-1,142,63,53,-1,47,108,77,-1,47,78,108,-1,117,103,106,-1,103,117,114,-1,124,63,113,-1,124,97,63,-1,136,102,135,-1,102,136,112,-1,84,140,121,-1,85,140,84,-1,85,141,140,-1,85,83,141,-1,43,51,56,-1,43,37,51,-1,98,125,133,-1,90,125,98,-1,100,117,110,-1,100,89,117,-1,114,87,108,-1,88,87,114,-1,86,121,77,-1,86,84,121,-1,46,103,78,-1,46,55,103,-1,39,84,58,-1,84,39,85,-1,79,44,45,-1,68,44,79,-1,118,60,123,-1,118,81,60,-1,74,64,73,-1,65,64,74,-1,70,127,99,-1,70,80,127,-1,118,144,115,-1,144,118,69,-1,28,17,13,-1,28,33,17,-1,6,8,5,-1,6,16,8,-1,23,18,19,-1,18,23,22,-1,49,93,91,-1,49,48,93,-1,91,59,49,-1,92,59,91,-1,10,5,7,-1,10,6,5,-1,177,170,171,-1,170,177,175,-1,120,91,131,-1,120,92,91,-1,93,131,91,-1,134,131,93,-1,154,128,152,-1,154,138,128,-1,178,175,177,-1,178,173,175,-1,153,163,143,-1,153,168,163,-1,3,54,0,-1,3,72,54,-1,164,107,76,-1,107,164,172,-1,140,151,148,-1,140,141,151,-1,107,181,109,-1,107,172,181,-1,36,24,57,-1,36,25,24,-1,155,162,157,-1,162,155,167,-1,128,96,112,-1,128,95,96,-1,143,139,126,-1,139,143,146,-1,152,158,154,-1,157,158,152,-1,154,160,145,-1,154,158,160,-1,134,137,131,-1,145,137,134,-1,181,165,182,-1,181,171,165,-1,125,92,120,-1,125,90,92,-1,168,173,163,-1,168,175,173,-1,43,83,35,-1,98,83,43,-1,50,33,28,-1,50,51,33,-1,49,50,40,-1,49,59,50,-1,40,48,49,-1,40,34,48,-1,20,27,34,-1,27,20,22,-1,19,15,1,-1,18,15,19,-1,41,95,94,-1,41,52,95,-1,73,132,74,-1,73,115,132,-1,99,87,70,-1,86,87,99,-1,65,89,64,-1,88,89,65,-1,115,81,118,-1,115,73,81,-1,118,61,69,-1,61,118,123,-1,53,55,119,-1,53,67,55,-1,122,77,121,-1,77,122,47,-1,114,78,103,-1,114,108,78,-1,110,106,97,-1,110,117,106,-1,124,110,97,-1,111,110,124,-1,148,121,140,-1,148,122,121,-1,55,107,109,-1,55,46,107,-1,56,98,43,-1,98,56,90,-1],
          coord=Coordinate(DEF='c4disc_Coord',point=[(-.27309,53.79235,-.73396),(-.24914,53.75068,-.74387),(-.22763,53.74748,-.74604),(-.223,53.70555,-.75947),(-.23941,53.70579,-.76522),(-.22677,53.70134,-.77423),(-.16324,53.69224,-.76181),(-.117,53.92347,-1.20341),(-.10808,53.89732,-1.19871),(-.20861,53.90666,-1.18822),(.29028,53.93079,-1.16121),(.28178,53.92147,-1.17246),(.20922,53.90674,-1.18689),(.31234,53.92787,-1.15583),(.268,53.84321,-.75936),(.32432,53.9249,-.82918),(.24985,53.88776,-.77883),(.31071,53.94223,-1.05534),(.33878,53.94566,-1.05549),(.32972,53.93746,-1.13085),(.2621,53.90567,-1.17308),(.1091,53.89924,-1.19965),(.08822,53.85775,-1.17156),(0,53.8586,-1.17077),(.2876,53.93365,-1.13933),(.31878,53.93787,-1.14056),(.27706,53.91871,-.86378),(.19544,53.91123,-.85463),(-.32286,53.95091,-.90482),(-.316,53.9092,-.82904),(-.27706,53.91871,-.86378),(-.22753,53.87439,-.77621),(-.31917,53.93793,-1.14057),(-.32984,53.93803,-1.13375),(-.34594,53.95355,-1.05799),(-.19074,53.88837,-1.17978),(-.26203,53.90664,-1.17595),(0,53.9016,-1.19138),(-.19544,53.91123,-.85463),(-.18575,53.86215,-.77509),(-.32956,53.95655,-.96166),(-.2702,53.93845,-.95659),(-.27165,53.93655,-1.04951),(-.22115,53.77498,-.92511),(-.22525,53.73963,-.84191),(-.234,53.7452,-.84071),(-.29338,53.8369,-.74314),(-.28801,53.79082,-.73871),(-.35009,53.93251,-.88912),(-.36394,53.93519,-.97461),(-.32994,53.90744,-.97837),(-.26589,53.78492,-.82213),(.28712,53.89407,-1.07416),(.32317,53.90751,-1.04193),(.32994,53.90744,-.97837),(.276,53.86743,-.98934),(.29868,53.91149,-1.11095),(.32471,53.93017,-1.05058),(.29897,53.82527,-.75565),(.29032,53.81412,-.72664),(.28801,53.79082,-.73871),(.22525,53.73963,-.84191),(.22115,53.77498,-.92511),(.234,53.7452,-.84071),(-.07454,53.81864,-1.13736),(-.16815,53.85112,-1.1351),(-.30251,53.91307,-1.10794),(-.35335,53.94523,-1.07256),(.30676,53.84272,-.73788),(.2479,53.74959,-.72815),(.2171,53.73515,-.72361),(.17477,53.79434,-.71052),(-.26723,53.75338,-.74205),(-.24798,53.83816,-.76424),(.22468,53.8756,-1.12783),(.16867,53.85193,-1.13588),(-.22464,53.87552,-1.12765),(.07463,53.81873,-1.13718),(.18616,53.88085,-1.17093),(.31619,53.86719,-.80757),(.36553,53.93649,-.97443),(.2172,53.81059,-1.0006),(.07203,53.79952,-1.10239),(.15667,53.82957,-1.09663),(.15854,53.78328,-.99507),(.16197,53.75755,-.91546),(.32752,53.89497,-.88803),(.27512,53.82644,-.9131),(.26589,53.78492,-.82213),(.16547,53.71784,-.70499),(.16561,53.6941,-.74217),(.21681,53.70268,-.75453),(-.07234,53.67906,-.72613),(-.16646,53.72603,-.70558),(-.16632,53.69502,-.74284),(-.29897,53.82527,-.75565),(-.33055,53.89402,-.80768),(-.31619,53.86719,-.80757),(-.27512,53.82644,-.9131),(-.276,53.86743,-.98934),(-.32752,53.89497,-.88803),(-.2172,53.81059,-1.0006),(-.16197,53.75755,-.91546),(-.07203,53.79952,-1.10239),(-.07547,53.76764,-.99375),(-.15854,53.78328,-.99507),(-.28712,53.89407,-1.07416),(-.21509,53.85649,-1.08336),(-.12026,53.93562,-1.12943),(0,53.94686,-1.1319),(-.31884,53.93122,-1.15496),(-.29893,53.93189,-1.16202),(-.28159,53.92197,-1.17201),(-.17928,53.84458,-.72385),(-.31798,53.94329,-1.05642),(.17928,53.84458,-.72385),(.18575,53.86215,-.77509),(0,53.92568,-1.1848),(.12026,53.93562,-1.12943),(.117,53.92347,-1.20341),(.20983,53.92085,-1.18393),(-.2097,53.92091,-1.18371),(.23632,53.70518,-.75895),(.26723,53.75338,-.74205),(-.29011,53.93098,-1.1598),(.32963,53.95251,-.96292),(.2702,53.93845,-.95659),(.32712,53.94886,-.90259),(-.17517,53.79761,-.71076),(-.15667,53.82957,-1.09663),(-.07783,53.70566,-.68179),(.34349,53.90407,-.80063),(.07547,53.76764,-.99375),(.21509,53.85649,-1.08336),(-.08907,53.86017,-1.17369),(.21441,53.69957,-.77181),(.16324,53.69224,-.76181),(.07249,53.6801,-.7266),(.06947,53.67873,-.74708),(.21443,53.93334,-1.13282),(.27165,53.93655,-1.04951),(.21173,53.93864,-1.03879),(0,53.95546,-1.03358),(.1163,53.94391,-.93786),(.11861,53.94649,-1.03767),(0,53.94755,-.93082),(0,53.91934,-.8447),(.1147,53.85182,-.7645),(.11854,53.91612,-.85179),(0,53.85083,-.75168),(.20611,53.93662,-.9548),(-.09689,53.82525,-.70008),(-.08842,53.77271,-.68634),(-.21443,53.93334,-1.13282),(-.21173,53.93864,-1.03879),(-.11861,53.94649,-1.03767),(-.1163,53.94391,-.93786),(-.20611,53.93662,-.9548),(-.11854,53.91612,-.85179),(-.1147,53.85182,-.7645),(-.32689,53.91935,-1.04721),(0,53.78316,-1.09408),(0,53.75294,-.99226),(0,53.69201,-.8036),(-.06947,53.67873,-.74708),(-.07885,53.70341,-.81955),(0,53.66764,-.73952),(.07735,53.70265,-.68159),(.35971,53.92825,-.88417),(.16444,53.72344,-.83381),(.07771,53.7335,-.9058),(.07885,53.70341,-.81955),(0,53.81252,-1.13694),(0,53.76856,-.6685),(0,53.69521,-.66879),(0,53.66886,-.71904),(-.16444,53.72344,-.83381),(0,53.81823,-.67822),(.08887,53.77551,-.68653),(.09689,53.82525,-.70008),(-.2876,53.93365,-1.13933),(-.07771,53.7335,-.9058),(0,53.71684,-.88501)]),
          normal=Normal(vector=[(-.9991,.0233,.0361),(-.9498,.086,-.3007),(-.9417,-.1617,.2951),(-.9106,.3048,.2792),(-.8793,.2259,-.4193),(-.8671,-.4887,-.0963),(-.8404,-.5047,-.1973),(-.8222,-.5623,-.089),(-.7775,-.3148,.5444),(-.7736,.3397,.5349),(-.7706,-.5856,-.2516),(-.7465,.0122,-.6653),(-.6854,-.7007,-.1981),(-.6746,-.6579,-.3349),(-.641,-.7619,-.0925),(-.6111,-.7757,-.1575),(-.5975,-.5169,.613),(-.5921,-.7676,.2453),(-.5596,-.797,-.2272),(-.5393,-.823,-.1783),(-.5069,-.785,-.3562),(-.4554,-.8007,-.3892),(-.4549,-.812,-.3657),(-.4374,-.8639,-.2499),(-.3959,.1179,.9107),(-.3911,-.3602,.8469),(-.3881,-.5706,-.7237),(-.3748,-.8404,-.3914),(-.3673,-.8309,-.418),(-.3461,-.8398,-.4184),(-.3288,.3948,.8579),(-.3145,.2307,-.9208),(-.3013,-.7416,.5994),(-.2944,-.9423,-.1595),(-.2886,-.898,-.3321),(-.2696,-.4783,.8358),(-.2613,-.1453,.9543),(-.2489,-.8888,.3847),(-.2428,.9669,-.0782),(-.2181,.1161,.969),(-.217,-.9034,-.3698),(-.2105,-.8904,-.4037),(-.1999,.6463,.7364),(-.1979,-.9444,.2626),(-.1924,-.6732,-.714),(-.1923,-.1615,-.968),(-.1844,.9511,.248),(-.1815,.8908,.4165),(-.1802,-.932,-.3144),(-.1648,-.9243,-.3442),(-.1592,-.9042,-.3963),(-.1491,-.9804,-.129),(-.1488,-.7877,-.5978),(-.1399,.988,-.0659),(-.1374,.9892,.0508),(-.1339,.9875,.0827),(-.118,-.9799,-.1608),(-.1133,.4756,.8724),(-.1123,.63,.7684),(-.1115,-.939,-.3252),(-.1082,.7261,-.679),(-.0936,.7778,-.6215),(-.0921,.7621,.6409),(-.0906,.9902,-.1067),(-.0825,.9957,-.0412),(-.0742,.9823,.1717),(-.0718,.9878,-.1384),(-.0606,.9975,-.0367),(-.0571,-.6252,-.7783),(-.0529,.9638,-.2613),(-.0516,.8947,.4436),(-.0489,.5353,-.8433),(-.0449,.9639,.2626),(-.0414,.9987,-.0282),(-.0337,.9912,.1278),(-.0285,.8584,.5122),(-.0186,.5221,.8527),(-.018,.879,.4765),(-.0142,.9303,.3665),(-.01,-.3611,-.9325),(-.0058,.9234,.3837),(-.0039,.9899,-.1417),(-.0033,-.0845,-.9964),(-.0018,-.522,.853),(-.0012,.5853,.8108),(-.0012,.099,.9951),(0,.8699,.4932),(0,.8874,.4611),(0,.9799,.1994),(0,.9999,-.0147),(0,-.9909,-.1346),(0,-.949,-.3152),(0,-.9487,-.3162),(0,-.9486,-.3165),(0,-.9105,-.4136),(.0008,-.7343,-.6788),(.001,-.5446,-.8387),(.0039,.9899,-.1418),(.0046,-.9624,.2717),(.018,.879,.4765),(.0217,.9755,-.2189),(.0285,.6859,-.7271),(.0326,-.3523,-.9353),(.0337,.9912,.1278),(.0354,.7686,.6387),(.0356,-.296,.9545),(.0414,.9987,-.0282),(.0448,.9103,.4115),(.0516,.8947,.4436),(.0541,.9789,.197),(.0542,.9868,-.1526),(.0556,.5444,-.837),(.0698,-.6299,-.7735),(.0729,.87,-.4876),(.0742,.9823,.1717),(.0777,.9955,-.054),(.082,.0695,.9942),(.0825,.9957,-.0412),(.0907,.9901,-.1069),(.1048,.9943,.0193),(.1115,-.939,-.3252),(.1148,.6323,.7662),(.1157,.6491,.7518),(.1203,.9425,-.3118),(.1233,.6709,-.7312),(.1242,-.9825,-.1392),(.1286,-.98,-.1521),(.1417,.8941,.4249),(.1509,-.7865,-.5989),(.1534,.9228,.3534),(.1623,-.9044,-.3945),(.1648,-.9243,-.3442),(.1702,.9816,.0864),(.1731,-.9535,.2466),(.1802,-.932,-.3144),(.1858,-.2225,-.9571),(.2045,-.7129,-.6708),(.2058,-.9118,-.3553),(.2106,-.8897,-.405),(.217,-.9271,.3054),(.2187,.1226,.9681),(.235,-.5051,.8305),(.2381,.8935,-.3808),(.2406,-.9489,-.2043),(.2474,.9654,-.0825),(.2663,-.8972,-.3523),(.2718,-.8597,.4324),(.2898,-.2041,.9351),(.3095,.1361,.9411),(.3227,.1517,-.9343),(.3312,.0892,.9393),(.3338,-.4294,.8391),(.3457,-.8395,-.4191),(.3727,-.8368,-.401),(.3748,-.8395,-.3935),(.3772,-.6601,-.6496),(.3927,-.2992,.8696),(.4341,-.8655,-.2501),(.4544,-.8119,-.3665),(.4924,-.7977,-.3483),(.5162,-.7731,-.3685),(.5198,-.8212,-.2355),(.5668,-.8067,-.1672),(.5674,-.801,.1911),(.5718,.2375,.7852),(.6504,-.7508,-.1154),(.6544,-.7132,-.2511),(.6962,-.1084,-.7096),(.6964,-.6409,-.3231),(.7116,-.6599,-.2414),(.7447,-.6285,-.2244),(.7693,-.6347,-.0731),(.7849,.2742,.5557),(.8004,-.5278,.2844),(.8178,.4635,-.341),(.8219,-.5284,-.2128),(.8265,-.4799,-.2943),(.8352,-.5402,-.1031),(.8543,-.4386,.279),(.9322,.2691,-.2419),(.9407,-.3276,.0881),(.9706,.1875,.1511),(.9875,.1432,-.0666)]))),
      Shape(DEF='c5',
        appearance=Appearance(
          material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),shininess=0.050,specularColor=(.349,.349,.349))),
        geometry=IndexedFaceSet(DEF='c5_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,11,10,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,32,31,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,73,-1,63,62,74,-1,75,76,77,-1,78,79,80,-1,81,82,83,-1,84,85,86,-1,87,88,89,-1,90,91,92,-1,93,94,95,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,106,107,-1,108,109,110,-1,111,112,113,-1,114,115,116,-1,117,109,118,-1,100,119,120,-1,121,122,123,-1,124,125,126,-1,127,128,129,-1,126,125,61,-1,130,131,132,-1,133,134,135,-1,136,132,137,-1,113,138,139,-1,140,141,142,-1,143,144,145,-1,146,147,121,-1,148,149,130,-1,150,151,152,-1,151,146,152,-1,153,146,151,-1,154,155,156,-1,157,158,159,-1,160,161,162,-1,163,164,165,-1,166,98,97,-1,167,168,169,-1,170,171,172,-1,173,174,175,-1,176,177,178,-1,179,180,181,-1,181,101,182,-1,101,183,184,-1,185,186,187,-1,73,79,78,-1,188,189,190,-1,170,191,192,-1,183,193,155,-1,187,194,195,-1,196,197,198,-1,199,200,201,-1,161,202,203,-1,204,198,158,-1,205,206,207,-1,208,209,210,-1,165,211,208,-1,212,213,214,-1,165,215,163,-1,216,217,218,-1,20,24,219,-1,220,221,222,-1,223,9,11,-1,224,225,226,-1,227,27,26,-1,228,229,230,-1,231,232,233,-1,234,235,236,-1,237,30,238,-1,239,240,238,-1,241,22,242,-1,243,225,224,-1,244,245,246,-1,247,248,249,-1,250,251,252,-1,244,253,1,-1,254,255,256,-1,257,241,258,-1,259,260,261,-1,262,244,263,-1,264,2,1,-1,265,42,41,-1,266,39,267,-1,268,41,269,-1,270,271,272,-1,273,274,271,-1,37,275,276,-1,277,278,276,-1,279,280,48,-1,281,282,57,-1,51,283,49,-1,284,285,286,-1,287,65,70,-1,69,62,288,-1,289,64,290,-1,291,292,149,-1,149,292,293,-1,294,66,65,-1,44,46,295,-1,296,297,298,-1,299,72,300,-1,80,301,302,-1,303,304,300,-1,304,305,299,-1,102,111,119,-1,183,101,120,-1,306,90,85,-1,84,307,308,-1,309,310,311,-1,312,313,314,-1,315,316,317,-1,315,318,319,-1,320,321,312,-1,322,323,308,-1,324,325,326,-1,327,328,329,-1,329,330,331,-1,332,333,334,-1,335,336,337,-1,338,339,340,-1,341,342,343,-1,344,345,346,-1,347,348,340,-1,349,350,351,-1,352,353,354,-1,352,355,356,-1,352,357,358,-1,351,359,360,-1,361,362,348,-1,363,344,364,-1,365,366,367,-1,368,369,370,-1,371,360,359,-1,372,373,374,-1,375,361,376,-1,377,375,378,-1,379,380,381,-1,382,383,384,-1,385,386,387,-1,388,389,390,-1,391,392,393,-1,394,395,396,-1,397,398,399,-1,399,400,401,-1,402,403,404,-1,405,406,407,-1,401,403,408,-1,409,410,411,-1,412,413,414,-1,415,416,412,-1,417,418,419,-1,420,421,422,-1,423,424,425,-1,426,427,420,-1,428,429,424,-1,430,431,432,-1,433,0,434,-1,435,436,437,-1,434,431,438,-1,439,440,441,-1,442,443,444,-1,445,446,447,-1,448,449,450,-1,451,452,453,-1,454,455,456,-1,457,458,459,-1,460,461,462,-1,463,464,465,-1,466,467,468,-1,469,470,471,-1,472,473,474,-1,475,476,477,-1,478,479,480,-1,481,482,483,-1,484,485,486,-1,487,484,488,-1,489,490,491,-1,492,493,394,-1,494,495,496,-1,480,497,498,-1,499,500,501,-1,502,503,504,-1,483,505,506,-1,507,508,509,-1,510,511,512,-1,513,514,515,-1,449,448,516,-1,517,518,519,-1,520,486,485,-1,520,333,486,-1,521,522,523,-1,524,469,525,-1,469,526,525,-1,527,498,528,-1,488,529,475,-1,499,504,503,-1,530,375,531,-1,532,533,534,-1,363,535,536,-1,537,538,539,-1,540,541,542,-1,543,544,545,-1,546,508,507,-1,547,548,549,-1,550,410,551,-1,548,547,507,-1,549,548,552,-1,553,554,544,-1,555,506,556,-1,557,558,556,-1,559,560,561,-1,562,563,564,-1,517,564,563,-1,565,508,546,-1,566,567,568,-1,569,570,571,-1,572,449,332,-1,573,574,575,-1,365,367,576,-1,577,578,579,-1,345,344,580,-1,581,582,583,-1,381,380,384,-1,584,585,586,-1,587,588,589,-1,590,591,348,-1,396,404,400,-1,592,593,594,-1,595,596,597,-1,598,599,600,-1,601,584,602,-1,603,601,604,-1,602,605,606,-1,607,608,411,-1,609,610,611,-1,407,422,612,-1,423,573,613,-1,614,615,616,-1,415,617,618,-1,619,620,621,-1,622,623,624,-1,416,415,618,-1,625,626,627,-1,628,626,629,-1,630,631,632,-1,633,634,635,-1,623,636,624,-1,637,638,639,-1,640,641,642,-1,639,643,644,-1,645,646,647,-1,458,648,649,-1,650,651,652,-1,464,463,653,-1,654,655,656,-1,0,657,434,-1,658,659,660,-1,661,662,459,-1,644,467,663,-1,664,665,573,-1,652,651,638,-1,467,637,663,-1,650,466,666,-1,667,653,463,-1,668,669,635,-1,444,445,670,-1,671,672,673,-1,674,675,676,-1,673,416,671,-1,677,678,615,-1,424,429,679,-1,680,679,426,-1,420,616,615,-1,598,681,599,-1,409,682,683,-1,684,600,511,-1,518,685,560,-1,588,587,686,-1,390,687,404,-1,688,689,382,-1,690,686,389,-1,691,585,584,-1,592,692,491,-1,693,694,695,-1,582,696,393,-1,697,580,581,-1,577,698,699,-1,367,697,700,-1,520,365,334,-1,701,613,702,-1,555,703,704,-1,705,706,519,-1,377,532,567,-1,508,565,707,-1,558,708,709,-1,557,710,711,-1,554,712,713,-1,549,552,714,-1,714,715,685,-1,716,541,540,-1,542,538,537,-1,540,551,717,-1,718,719,708,-1,720,721,569,-1,493,722,723,-1,724,396,395,-1,725,712,554,-1,712,378,726,-1,532,377,712,-1,727,728,703,-1,725,535,533,-1,476,482,481,-1,729,730,501,-1,731,355,354,-1,471,732,473,-1,733,734,576,-1,521,735,630,-1,516,448,514,-1,410,550,607,-1,488,484,505,-1,736,737,730,-1,736,729,728,-1,728,481,704,-1,499,528,498,-1,661,650,662,-1,738,342,366,-1,739,597,740,-1,506,505,486,-1,741,636,742,-1,506,555,704,-1,498,743,480,-1,744,500,479,-1,745,746,747,-1,745,477,746,-1,477,476,748,-1,737,504,730,-1,749,750,751,-1,752,753,754,-1,755,756,757,-1,755,758,732,-1,759,760,761,-1,759,471,470,-1,666,468,653,-1,762,763,462,-1,467,655,468,-1,464,764,465,-1,632,631,634,-1,765,766,435,-1,441,442,435,-1,767,667,439,-1,647,640,656,-1,642,768,764,-1,769,770,771,-1,772,773,774,-1,775,776,777,-1,439,257,767,-1,260,259,647,-1,768,263,769,-1,432,434,657,-1,430,778,779,-1,425,424,780,-1,781,428,423,-1,782,783,784,-1,416,673,785,-1,412,416,413,-1,413,786,787,-1,515,788,608,-1,414,789,408,-1,614,407,406,-1,404,401,400,-1,405,790,791,-1,792,724,793,-1,794,713,795,-1,598,796,681,-1,586,797,692,-1,689,383,382,-1,693,798,372,-1,376,381,384,-1,799,375,383,-1,376,591,379,-1,570,706,705,-1,704,703,728,-1,367,366,345,-1,536,344,363,-1,800,364,362,-1,590,801,373,-1,352,356,802,-1,352,354,355,-1,337,801,335,-1,340,344,803,-1,350,804,805,-1,191,806,807,-1,808,322,809,-1,308,323,810,-1,811,812,322,-1,325,320,314,-1,813,328,814,-1,315,815,316,-1,816,813,817,-1,314,313,814,-1,818,819,811,-1,150,310,309,-1,306,820,821,-1,822,823,824,-1,181,99,101,-1,825,301,313,-1,304,826,818,-1,105,305,304,-1,827,826,828,-1,103,829,104,-1,71,830,303,-1,831,67,832,-1,833,834,835,-1,292,291,834,-1,144,836,74,-1,64,837,838,-1,288,62,64,-1,69,839,840,-1,841,289,842,-1,843,283,51,-1,52,51,49,-1,286,276,284,-1,844,845,846,-1,265,847,42,-1,848,849,850,-1,851,852,850,-1,853,854,855,-1,264,856,857,-1,263,244,433,-1,238,240,436,-1,248,858,859,-1,248,247,858,-1,1,253,860,-1,225,861,862,-1,261,863,3,-1,22,241,240,-1,864,865,238,-1,866,867,29,-1,868,869,870,-1,871,222,872,-1,23,221,220,-1,873,163,215,-1,164,874,875,-1,876,212,205,-1,877,878,879,-1,203,202,204,-1,196,880,881,-1,183,882,184,-1,177,176,883,-1,74,836,142,-1,884,885,852,-1,232,886,887,-1,888,889,890,-1,882,155,176,-1,127,108,891,-1,57,892,55,-1,175,280,171,-1,191,170,172,-1,893,894,104,-1,895,883,896,-1,896,883,192,-1,873,215,216,-1,897,898,873,-1,328,326,814,-1,813,816,329,-1,317,899,900,-1,901,902,187,-1,178,203,903,-1,185,902,889,-1,904,905,906,-1,121,907,146,-1,150,307,151,-1,133,908,909,-1,135,148,132,-1,122,910,131,-1,911,912,913,-1,914,891,915,-1,127,916,128,-1,917,173,136,-1,918,916,919,-1,920,914,921,-1,920,922,923,-1,147,924,910,-1,121,123,293,-1,925,60,59,-1,894,926,112,-1,926,894,893,-1,891,110,107,-1,106,927,107,-1,113,928,119,-1,191,870,929,-1,13,93,930,-1,91,90,821,-1,87,931,88,-1,85,84,308,-1,82,932,933,-1,934,829,935,-1,303,830,936,-1,937,938,72,-1,939,940,297,-1,68,145,69,-1,312,811,819,-1,298,297,941,-1,812,321,942,-1,54,925,76,-1,943,934,935,-1,44,58,45,-1,944,945,946,-1,947,282,281,-1,54,53,925,-1,174,917,49,-1,148,144,143,-1,948,949,950,-1,846,951,842,-1,268,952,13,-1,953,845,39,-1,954,887,955,-1,956,957,958,-1,229,959,230,-1,887,954,37,-1,960,961,962,-1,254,962,963,-1,963,237,255,-1,964,236,235,-1,965,966,25,-1,10,967,15,-1,968,969,9,-1,861,225,243,-1,9,969,967,-1,970,261,971,-1,972,973,8,-1,7,6,3,-1,24,23,226,-1,223,862,968,-1,862,861,968,-1,226,219,24,-1,7,3,5,-1,8,974,972,-1,19,5,4,-1,9,967,10,-1,975,960,962,-1,976,861,243,-1,968,9,223,-1,18,10,15,-1,230,959,977,-1,235,25,964,-1,167,234,978,-1,963,28,237,-1,254,963,255,-1,37,31,887,-1,869,979,980,-1,229,981,959,-1,956,982,957,-1,39,38,953,-1,952,93,13,-1,842,983,846,-1,858,984,985,-1,986,987,988,-1,266,267,989,-1,148,135,144,-1,48,174,49,-1,990,947,281,-1,946,991,944,-1,945,947,940,-1,44,992,58,-1,937,943,935,-1,76,75,54,-1,298,941,75,-1,819,825,312,-1,66,993,832,-1,940,941,297,-1,936,828,303,-1,932,994,933,-1,821,166,91,-1,896,192,807,-1,13,930,995,-1,929,806,191,-1,97,96,996,-1,113,115,928,-1,104,894,111,-1,107,915,891,-1,893,927,926,-1,111,894,112,-1,120,119,928,-1,997,927,893,-1,925,53,60,-1,193,156,155,-1,293,998,121,-1,910,122,147,-1,920,124,922,-1,920,999,914,-1,918,128,916,-1,173,909,136,-1,921,124,920,-1,915,921,914,-1,153,911,913,-1,131,130,122,-1,135,132,908,-1,919,133,909,-1,907,1000,146,-1,904,906,304,-1,1001,61,125,-1,921,915,997,-1,902,890,889,-1,901,1002,1003,-1,900,318,317,-1,873,216,897,-1,896,1004,895,-1,104,1001,893,-1,191,172,870,-1,1005,1006,167,-1,55,281,57,-1,127,891,914,-1,175,174,280,-1,170,1007,175,-1,888,180,889,-1,194,187,186,-1,852,1008,884,-1,63,74,142,-1,1009,77,1010,-1,162,178,177,-1,883,895,177,-1,882,159,184,-1,881,194,196,-1,203,204,157,-1,876,205,1011,-1,874,1012,875,-1,873,1013,163,-1,220,226,23,-1,222,1014,872,-1,1015,6,973,-1,1016,1017,1018,-1,172,868,870,-1,980,34,1005,-1,866,29,28,-1,864,238,30,-1,22,240,239,-1,3,971,261,-1,1,860,1019,-1,1020,238,436,-1,433,1,0,-1,264,1019,856,-1,853,1021,854,-1,851,1008,852,-1,269,41,43,-1,267,844,848,-1,268,984,41,-1,844,846,1022,-1,33,270,958,-1,954,275,37,-1,276,275,284,-1,52,49,917,-1,841,842,951,-1,840,70,69,-1,288,64,289,-1,290,64,838,-1,144,74,145,-1,835,1023,833,-1,294,287,843,-1,303,300,71,-1,103,935,829,-1,936,827,828,-1,304,906,105,-1,818,904,304,-1,301,1024,313,-1,822,824,1025,-1,821,90,306,-1,309,308,150,-1,811,311,818,-1,816,817,1026,-1,315,1027,1028,-1,315,317,318,-1,315,319,1029,-1,813,329,328,-1,811,322,309,-1,308,810,85,-1,808,323,322,-1,807,192,191,-1,350,805,1030,-1,350,349,804,-1,340,364,344,-1,337,1031,801,-1,352,358,353,-1,352,1032,357,-1,801,1031,373,-1,364,348,362,-1,536,580,344,-1,345,697,367,-1,705,1033,570,-1,376,361,591,-1,799,378,375,-1,376,384,383,-1,383,375,376,-1,372,374,693,-1,689,799,383,-1,797,1034,692,-1,794,793,713,-1,793,794,792,-1,791,399,405,-1,404,403,401,-1,787,614,406,-1,408,1035,414,-1,1036,411,1037,-1,606,512,600,-1,512,511,600,-1,608,607,515,-1,787,414,413,-1,416,785,413,-1,782,784,1038,-1,419,1039,1038,-1,428,424,423,-1,1040,426,615,-1,424,679,780,-1,430,1041,778,-1,769,433,434,-1,647,658,260,-1,257,258,767,-1,769,434,770,-1,777,1042,775,-1,774,1043,772,-1,771,1044,769,-1,642,641,768,-1,667,440,439,-1,435,437,441,-1,435,444,765,-1,633,632,634,-1,1045,1046,1047,-1,464,642,764,-1,467,644,655,-1,762,465,763,-1,468,1048,653,-1,759,732,471,-1,759,761,752,-1,755,732,754,-1,755,1049,756,-1,752,1050,753,-1,1051,749,751,-1,477,748,744,-1,1052,475,745,-1,744,479,1053,-1,506,704,483,-1,742,1054,741,-1,1055,695,694,-1,661,651,650,-1,499,498,497,-1,728,729,481,-1,736,730,729,-1,488,505,529,-1,1056,516,556,-1,1057,1058,619,-1,550,513,607,-1,516,514,513,-1,521,630,1059,-1,1060,733,576,-1,766,765,1061,-1,354,1030,731,-1,1062,487,1052,-1,748,476,481,-1,1056,556,506,-1,725,1063,535,-1,535,1064,533,-1,377,378,712,-1,724,541,793,-1,541,716,793,-1,725,533,712,-1,394,493,723,-1,569,709,720,-1,531,1065,1066,-1,708,711,718,-1,540,717,543,-1,542,1067,538,-1,540,543,716,-1,714,685,1068,-1,710,1069,1070,-1,507,1071,1072,-1,1072,1073,507,-1,714,1068,549,-1,554,713,545,-1,727,703,570,-1,709,571,558,-1,509,508,707,-1,567,566,377,-1,519,739,705,-1,1074,728,727,-1,613,575,702,-1,365,734,334,-1,700,576,367,-1,699,578,577,-1,697,345,580,-1,582,393,392,-1,695,798,693,-1,491,593,592,-1,1075,492,400,-1,382,1055,688,-1,1076,390,404,-1,686,690,588,-1,400,399,1075,-1,685,561,560,-1,684,1077,600,-1,1078,1079,594,-1,409,1036,682,-1,420,615,426,-1,680,426,1080,-1,495,1081,496,-1,664,573,423,-1,1082,1057,1083,-1,672,417,673,-1,670,765,444,-1,635,1084,668,-1,440,667,463,-1,1085,650,666,-1,638,637,652,-1,665,1086,573,-1,431,434,432,-1,459,458,661,-1,638,651,649,-1,659,1087,660,-1,649,651,661,-1,655,1088,656,-1,464,653,1048,-1,652,466,650,-1,661,458,649,-1,1085,660,1087,-1,644,663,639,-1,1089,626,625,-1,656,640,642,-1,639,663,637,-1,1090,635,1091,-1,634,1084,635,-1,629,1061,628,-1,416,618,671,-1,450,1092,452,-1,622,1093,623,-1,620,418,621,-1,614,677,615,-1,613,781,423,-1,790,407,612,-1,1094,1095,425,-1,1096,1097,1098,-1,1040,1080,426,-1,411,410,607,-1,594,559,1078,-1,605,512,606,-1,604,1099,603,-1,1077,598,600,-1,597,1100,595,-1,593,559,594,-1,347,1101,335,-1,492,396,400,-1,801,590,348,-1,1076,404,396,-1,584,586,1102,-1,596,689,688,-1,380,1103,384,-1,1100,597,1104,-1,1067,542,395,-1,582,392,583,-1,365,576,734,-1,520,334,333,-1,613,573,575,-1,572,332,1105,-1,1060,698,1106,-1,571,709,569,-1,519,706,564,-1,567,565,546,-1,517,563,568,-1,564,706,562,-1,703,571,570,-1,1107,517,568,-1,561,1078,559,-1,558,555,556,-1,554,545,544,-1,548,1108,552,-1,507,1073,548,-1,550,551,1109,-1,1071,1070,1072,-1,507,547,546,-1,716,543,545,-1,542,537,540,-1,539,1109,537,-1,532,712,533,-1,1066,530,531,-1,517,1107,1068,-1,547,1107,546,-1,503,528,499,-1,527,1110,1111,-1,351,350,1112,-1,349,1113,1114,-1,469,1115,526,-1,521,572,522,-1,1116,520,485,-1,519,564,517,-1,516,332,449,-1,1059,630,1117,-1,1079,510,512,-1,509,1071,507,-1,513,515,607,-1,516,513,1118,-1,504,737,502,-1,499,497,500,-1,1047,618,1119,-1,494,1120,495,-1,492,1075,493,-1,505,484,486,-1,483,704,481,-1,478,1121,479,-1,477,745,475,-1,1122,1123,1124,-1,473,1125,474,-1,471,1126,469,-1,466,468,666,-1,463,465,762,-1,462,763,460,-1,451,1127,452,-1,1128,448,450,-1,1092,1059,674,-1,447,670,445,-1,442,444,435,-1,439,441,437,-1,642,654,656,-1,438,770,434,-1,435,1020,436,-1,263,433,769,-1,432,1041,430,-1,779,665,1129,-1,779,778,665,-1,427,1130,1131,-1,780,679,680,-1,422,616,420,-1,414,1035,412,-1,411,1036,409,-1,386,1036,1037,-1,408,789,401,-1,405,407,790,-1,687,402,404,-1,401,405,399,-1,399,791,397,-1,394,396,492,-1,723,391,393,-1,794,1132,792,-1,1132,388,390,-1,691,588,690,-1,382,384,1103,-1,379,381,376,-1,377,531,375,-1,375,530,361,-1,372,590,373,-1,359,1133,371,-1,736,728,1074,-1,368,1134,369,-1,365,738,366,-1,363,364,800,-1,361,348,591,-1,1031,1113,373,-1,351,1112,359,-1,352,802,1032,-1,351,1113,349,-1,1135,1031,337,-1,348,364,340,-1,346,803,344,-1,341,366,342,-1,340,803,338,-1,335,1101,336,-1,1105,332,334,-1,331,327,329,-1,324,326,1136,-1,308,309,322,-1,312,314,320,-1,315,1029,1027,-1,315,1028,815,-1,312,825,313,-1,311,811,309,-1,307,150,308,-1,90,86,85,-1,102,119,1137,-1,299,300,304,-1,80,1024,301,-1,72,71,300,-1,298,1138,296,-1,294,65,287,-1,149,293,123,-1,291,149,143,-1,289,290,842,-1,839,69,288,-1,287,70,840,-1,284,47,285,-1,282,58,57,-1,280,174,48,-1,277,276,286,-1,271,1139,273,-1,269,952,268,-1,41,984,265,-1,244,1,433,-1,260,863,261,-1,241,1140,258,-1,1141,254,256,-1,250,252,1142,-1,247,249,1143,-1,244,246,253,-1,243,224,262,-1,261,861,976,-1,242,1140,241,-1,239,238,865,-1,237,238,1144,-1,236,978,234,-1,228,230,1016,-1,227,26,1145,-1,226,220,224,-1,11,1146,223,-1,220,222,871,-1,1146,20,219,-1,216,218,897,-1,165,214,215,-1,214,205,212,-1,208,206,165,-1,210,1147,208,-1,207,1011,205,-1,180,179,889,-1,158,157,204,-1,199,201,1148,-1,198,1149,196,-1,155,882,183,-1,170,192,154,-1,977,188,190,-1,155,883,176,-1,103,1150,935,-1,820,306,1151,-1,902,185,187,-1,184,182,101,-1,182,179,181,-1,178,903,176,-1,154,156,170,-1,1152,982,1153,-1,173,917,174,-1,170,175,171,-1,169,1005,167,-1,97,91,166,-1,1144,255,237,-1,182,1154,179,-1,158,184,159,-1,911,153,151,-1,100,120,101,-1,152,1155,150,-1,121,998,305,-1,148,143,149,-1,146,153,147,-1,142,836,140,-1,113,139,115,-1,906,905,1156,-1,132,131,137,-1,135,908,133,-1,148,130,132,-1,61,1157,126,-1,129,108,127,-1,129,118,108,-1,124,126,922,-1,121,147,122,-1,1158,117,118,-1,109,108,118,-1,114,928,115,-1,113,119,111,-1,110,891,108,-1,907,105,107,-1,102,104,111,-1,193,183,120,-1,98,1159,96,-1,95,930,93,-1,86,90,92,-1,996,87,89,-1,86,932,84,-1,82,933,83,-1,80,302,78,-1,298,75,77,-1,831,940,939,-1,67,1023,65,-1,72,938,73,-1,70,835,68,-1,66,832,67,-1,61,1001,59,-1,992,56,58,-1,52,1160,50,-1,49,283,47,-1,884,1008,1161,-1,12,268,13,-1,1162,1163,1152,-1,33,1164,31,-1,28,30,237,-1,25,27,964,-1,242,22,24,-1,1165,19,21,-1,18,15,17,-1,14,855,12,-1,1019,264,1,-1,973,6,8,-1,15,974,16,-1,3,863,4,-1,974,8,16,-1,3,1015,971,-1,6,1015,3,-1,863,1166,4,-1,863,260,1166,-1,1167,857,853,-1,857,1167,960,-1,226,862,219,-1,226,225,862,-1,221,865,222,-1,239,865,221,-1,236,1168,1169,-1,236,964,1168,-1,254,975,962,-1,1170,975,254,-1,1171,1172,1173,-1,1172,1171,1174,-1,1175,1176,1177,-1,1175,886,1176,-1,35,190,36,-1,35,1178,190,-1,957,1152,1163,-1,957,982,1152,-1,1179,272,1180,-1,272,1179,1153,-1,951,845,953,-1,951,846,845,-1,989,1143,250,-1,989,847,1143,-1,952,94,93,-1,952,1181,94,-1,838,1182,1183,-1,838,1184,1182,-1,847,267,42,-1,847,989,267,-1,54,281,55,-1,54,990,281,-1,60,1157,61,-1,1157,60,892,-1,943,77,76,-1,1010,77,943,-1,819,301,825,-1,301,819,827,-1,77,1138,298,-1,77,1009,1138,-1,948,1185,931,-1,950,1185,948,-1,821,807,166,-1,821,896,807,-1,166,806,98,-1,806,166,807,-1,1159,995,930,-1,995,1159,1186,-1,14,995,1173,-1,14,13,995,-1,927,915,107,-1,997,915,927,-1,1158,129,156,-1,1158,118,129,-1,916,914,999,-1,127,914,916,-1,52,923,922,-1,137,923,52,-1,112,1156,905,-1,112,926,1156,-1,133,911,134,-1,911,133,912,-1,152,1187,1155,-1,1188,1187,152,-1,919,912,133,-1,916,912,919,-1,1000,110,109,-1,907,110,1000,-1,110,907,107,-1,105,121,305,-1,105,907,121,-1,128,1007,129,-1,918,1007,128,-1,1189,162,177,-1,160,162,1189,-1,203,162,161,-1,203,178,162,-1,902,1003,890,-1,902,901,1003,-1,1190,879,878,-1,1190,1191,879,-1,815,99,181,-1,99,815,1028,-1,319,900,330,-1,900,319,318,-1,1192,1193,1194,-1,1192,1195,1193,-1,324,218,1196,-1,324,1197,218,-1,1198,1199,808,-1,1199,1198,1200,-1,1201,1202,1203,-1,1202,1201,1204,-1,320,324,1196,-1,320,325,324,-1,89,933,994,-1,89,1205,933,-1,1174,866,1206,-1,1207,866,1174,-1,1208,965,959,-1,965,1208,966,-1,82,151,307,-1,151,82,81,-1,934,59,829,-1,59,934,925,-1,235,189,188,-1,235,234,189,-1,877,195,878,-1,877,1002,195,-1,18,21,11,-1,17,21,18,-1,45,991,46,-1,45,944,991,-1,141,1205,1209,-1,1205,141,140,-1,822,177,895,-1,177,822,1189,-1,1210,880,1211,-1,1212,880,1210,-1,1213,202,201,-1,204,202,1213,-1,1214,1215,1216,-1,1214,1003,1215,-1,1147,1204,1201,-1,210,1204,1147,-1,212,1200,1198,-1,1200,212,876,-1,211,164,875,-1,165,164,211,-1,1217,1012,1218,-1,1012,1217,875,-1,1012,1219,1193,-1,874,1219,1012,-1,1220,872,1014,-1,872,1220,1221,-1,1222,1208,1223,-1,1224,1208,1222,-1,872,245,871,-1,245,872,246,-1,1225,1226,1224,-1,1227,1226,1225,-1,228,1228,1229,-1,1228,228,1230,-1,1231,1230,1018,-1,1231,1232,1230,-1,979,1018,35,-1,979,1231,1018,-1,870,980,1005,-1,980,870,869,-1,1207,867,866,-1,1207,978,867,-1,19,7,5,-1,19,1165,7,-1,1233,860,1234,-1,860,1233,1235,-1,1227,249,248,-1,1227,1225,249,-1,854,1236,859,-1,854,1021,1236,-1,238,1237,1144,-1,1237,238,1020,-1,12,854,985,-1,855,854,12,-1,988,850,849,-1,988,851,850,-1,849,844,1022,-1,848,844,849,-1,1182,987,1183,-1,987,1182,1238,-1,957,1239,1164,-1,1240,1239,957,-1,233,887,31,-1,233,232,887,-1,275,279,284,-1,954,279,275,-1,955,279,954,-1,47,840,839,-1,283,840,47,-1,837,1184,838,-1,837,1241,1184,-1,88,1185,1209,-1,88,931,1185,-1,835,291,68,-1,835,834,291,-1,833,292,834,-1,296,292,833,-1,947,941,940,-1,947,990,941,-1,1242,79,1150,-1,1242,1243,79,-1,827,818,826,-1,818,827,819,-1,1244,1245,1216,-1,1245,1244,1246,-1,1247,1025,824,-1,1025,1247,1248,-1,1249,823,1151,-1,1249,824,823,-1,816,1137,99,-1,1026,1137,816,-1,1250,1246,1251,-1,1252,1246,1250,-1,326,314,814,-1,325,314,326,-1,1151,1253,1249,-1,1151,1254,1253,-1,1202,1253,1203,-1,1202,1255,1253,-1,323,1199,810,-1,1199,323,808,-1,25,1226,26,-1,1226,25,966,-1,1256,1257,1258,-1,1256,1259,1257,-1,349,1260,804,-1,1114,1260,349,-1,343,1261,1262,-1,1263,1261,343,-1,1264,1265,1263,-1,1264,1266,1265,-1,1258,1267,1256,-1,1258,1250,1267,-1,536,581,580,-1,582,581,536,-1,1268,1269,1270,-1,1269,1268,1271,-1,1272,1273,1274,-1,1273,1272,1275,-1,555,571,703,-1,558,571,555,-1,693,371,694,-1,371,693,374,-1,489,689,490,-1,489,799,689,-1,1102,594,605,-1,592,594,1102,-1,794,1034,797,-1,795,1034,794,-1,398,1075,399,-1,398,493,1075,-1,699,1276,578,-1,699,391,1276,-1,1037,387,386,-1,387,1037,402,-1,608,1035,408,-1,608,788,1035,-1,1077,683,682,-1,684,683,1077,-1,787,677,614,-1,677,787,786,-1,1038,785,419,-1,1038,784,785,-1,1277,428,781,-1,1277,1120,428,-1,1278,1279,612,-1,1278,1096,1279,-1,496,1130,494,-1,496,1280,1130,-1,768,1281,263,-1,641,1281,768,-1,767,1166,660,-1,767,258,1166,-1,437,257,439,-1,257,437,436,-1,1282,430,779,-1,1283,430,1282,-1,774,775,1042,-1,774,773,775,-1,1284,1042,1285,-1,1284,774,1042,-1,1286,1282,1287,-1,1286,1283,1282,-1,1044,768,769,-1,764,768,1044,-1,646,658,647,-1,658,646,659,-1,443,445,444,-1,443,1288,445,-1,735,631,630,-1,735,1289,631,-1,515,1290,1291,-1,515,514,1290,-1,1292,1293,1294,-1,451,1293,1292,-1,1295,1093,1296,-1,1295,1297,1093,-1,1298,1285,1299,-1,1298,1284,1285,-1,1300,1287,668,-1,1300,1286,1287,-1,764,763,465,-1,764,1044,763,-1,1298,1091,1301,-1,1091,1298,1302,-1,1303,1304,474,-1,1304,1303,1305,-1,760,1306,1307,-1,760,1308,1306,-1,1309,1125,758,-1,1125,1309,1310,-1,754,759,752,-1,754,732,759,-1,757,1311,1312,-1,756,1311,757,-1,761,1050,752,-1,761,1313,1050,-1,1314,753,1315,-1,1314,1049,753,-1,749,1275,750,-1,1275,749,1316,-1,501,744,748,-1,744,501,500,-1,1317,1318,1319,-1,1317,1320,1318,-1,744,746,477,-1,1053,746,744,-1,1321,479,1121,-1,1053,479,1321,-1,482,505,483,-1,505,482,529,-1,1322,1269,1323,-1,1270,1269,1322,-1,639,649,648,-1,639,638,649,-1,1124,1324,478,-1,1124,1190,1324,-1,1057,1325,1058,-1,1057,1082,1325,-1,1326,1325,1082,-1,1326,1327,1325,-1,1328,735,1329,-1,1289,735,1328,-1,1330,1331,1332,-1,1331,1330,1333,-1,1334,1335,1336,-1,1334,1337,1335,-1,1306,336,1101,-1,336,1306,1338,-1,1339,1340,805,-1,1340,1339,1304,-1,473,1126,471,-1,1126,473,472,-1,1030,353,350,-1,1030,354,353,-1,1032,1341,736,-1,1341,1032,802,-1,1316,1111,1110,-1,1316,1122,1111,-1,529,476,475,-1,476,529,482,-1,1320,1342,1318,-1,1320,1343,1342,-1,1343,1323,1342,-1,1343,1322,1323,-1,362,1344,800,-1,362,1345,1344,-1,549,1107,547,-1,549,1068,1107,-1,518,1068,685,-1,1068,518,517,-1,719,1344,720,-1,719,1346,1344,-1,1063,696,535,-1,1067,696,1063,-1,720,708,719,-1,720,709,708,-1,377,1065,531,-1,377,566,1065,-1,1347,1072,1348,-1,1347,1073,1072,-1,1109,540,537,-1,1109,551,540,-1,725,1348,1063,-1,725,1347,1348,-1,683,552,409,-1,683,714,552,-1,1349,1072,1070,-1,1349,539,1072,-1,557,708,558,-1,557,711,708,-1,727,1033,1074,-1,1033,727,570,-1,1350,579,609,-1,579,1350,577,-1,523,1351,1329,-1,574,1351,523,-1,365,1116,738,-1,520,1116,365,-1,393,1067,395,-1,696,1067,393,-1,795,489,1034,-1,726,489,795,-1,798,379,372,-1,380,379,798,-1,596,490,689,-1,596,595,490,-1,389,687,390,-1,389,686,687,-1,347,801,348,-1,335,801,347,-1,796,1036,386,-1,1036,796,682,-1,542,724,395,-1,542,541,724,-1,1352,496,1081,-1,1352,1280,496,-1,1279,397,791,-1,397,1279,1353,-1,1350,1277,701,-1,1350,1354,1277,-1,775,1040,776,-1,1080,1040,775,-1,1117,632,1054,-1,1117,630,632,-1,418,672,621,-1,418,417,672,-1,1355,636,623,-1,1355,742,636,-1,1127,1290,1128,-1,1290,1127,1356,-1,629,1357,1141,-1,1358,1357,629,-1,462,443,442,-1,443,462,461,-1,1085,653,667,-1,1085,666,653,-1,432,625,1041,-1,432,1089,625,-1,1086,778,1359,-1,665,778,1086,-1,457,645,1360,-1,457,646,645,-1,425,664,423,-1,425,1095,664,-1,457,659,646,-1,457,459,659,-1,1166,658,660,-1,260,658,1166,-1,1041,1359,778,-1,1041,625,1359,-1,654,464,1048,-1,464,654,642,-1,442,762,462,-1,442,441,762,-1,1361,634,1362,-1,634,1361,1084,-1,1089,629,626,-1,1089,1358,629,-1,1363,1329,1351,-1,1363,1328,1329,-1,1356,1291,1290,-1,1291,1356,1119,-1,742,676,675,-1,1355,676,742,-1,1057,621,1083,-1,621,1057,619,-1,1039,1325,1364,-1,1039,1058,1325,-1,616,407,614,-1,407,616,422,-1,773,1080,775,-1,680,1080,773,-1,701,781,613,-1,1277,781,701,-1,1365,397,1353,-1,1366,397,1365,-1,796,385,681,-1,386,385,796,-1,604,602,606,-1,601,602,604,-1,604,600,599,-1,604,606,600,-1,559,595,1100,-1,593,595,559,-1,589,691,584,-1,589,588,691,-1,1103,798,695,-1,1103,380,798,-1,596,740,597,-1,596,688,740,-1,581,700,697,-1,581,583,700,-1,1105,734,733,-1,1105,334,734,-1,574,522,575,-1,574,523,522,-1,574,1086,1351,-1,573,1086,574,-1,700,1060,576,-1,700,698,1060,-1,569,706,570,-1,706,569,562,-1,1069,516,1118,-1,1069,556,516,-1,553,1108,548,-1,553,544,1108,-1,550,539,1349,-1,550,1109,539,-1,717,410,409,-1,717,551,410,-1,1070,509,710,-1,1070,1071,509,-1,359,705,1133,-1,359,1033,705,-1,1347,554,553,-1,725,554,1347,-1,553,1073,1347,-1,553,548,1073,-1,565,534,707,-1,565,532,534,-1,565,567,532,-1,363,1344,1346,-1,363,800,1344,-1,510,1078,561,-1,1078,510,1079,-1,1367,1323,1368,-1,1367,1342,1323,-1,1369,1342,1367,-1,1369,1318,1342,-1,501,504,499,-1,501,730,504,-1,749,1122,1316,-1,749,1123,1122,-1,503,1273,1110,-1,1273,503,502,-1,1341,356,1274,-1,1341,802,356,-1,1304,1259,1340,-1,1259,1304,1305,-1,1338,1370,336,-1,1370,1338,526,-1,1336,1371,338,-1,1336,1335,1371,-1,1331,1314,1261,-1,1331,1333,1314,-1,1370,337,336,-1,337,1370,1135,-1,392,699,583,-1,391,699,392,-1,447,1328,1372,-1,447,1289,1328,-1,1090,1302,624,-1,1090,1091,1302,-1,535,582,536,-1,535,696,582,-1,560,1100,1104,-1,560,559,1100,-1,1054,633,741,-1,633,1054,632,-1,743,1122,1124,-1,1111,1122,743,-1,1096,1353,1279,-1,1096,1098,1353,-1,1368,1269,369,-1,1368,1323,1269,-1,1121,1210,1321,-1,1121,1212,1210,-1,1319,1369,747,-1,1319,1318,1369,-1,1333,1049,1314,-1,1333,756,1049,-1,1335,761,1371,-1,1335,1313,761,-1,473,758,1125,-1,473,732,758,-1,474,1310,1303,-1,474,1125,1310,-1,1308,1338,1306,-1,1308,524,1338,-1,1373,1305,1303,-1,1305,1373,1374,-1,1084,1300,668,-1,1361,1300,1084,-1,1364,1327,1375,-1,1327,1364,1325,-1,1300,1376,1286,-1,1377,1376,1300,-1,1301,1284,1298,-1,1301,1378,1284,-1,1294,1297,1295,-1,1294,1293,1297,-1,1093,455,623,-1,1093,1297,455,-1,1047,1294,1045,-1,1047,1292,1294,-1,451,1356,1127,-1,1292,1356,451,-1,514,1128,1290,-1,514,448,1128,-1,449,521,1059,-1,572,521,449,-1,446,1288,1362,-1,446,445,1288,-1,1379,1287,1282,-1,1287,1379,1380,-1,777,1285,1042,-1,1285,777,1381,-1,438,430,1283,-1,438,431,430,-1,1129,1094,1379,-1,1129,1095,1094,-1,1237,435,766,-1,1237,1020,435,-1,429,1130,427,-1,429,494,1130,-1,429,426,679,-1,429,427,426,-1,1097,1352,1098,-1,1097,1280,1352,-1,1278,422,421,-1,422,1278,612,-1,1354,1120,1277,-1,1354,495,1120,-1,418,1039,419,-1,418,620,1039,-1,673,419,785,-1,419,673,417,-1,788,412,1035,-1,788,415,412,-1,788,617,415,-1,598,682,796,-1,598,1077,682,-1,402,408,403,-1,402,1037,408,-1,686,402,687,-1,686,387,402,-1,701,577,1350,-1,701,702,577,-1,493,1382,722,-1,1382,493,398,-1,724,1076,396,-1,1076,724,792,-1,388,690,389,-1,388,691,690,-1,585,691,388,-1,1102,602,584,-1,605,602,1102,-1,694,1133,740,-1,1133,694,371,-1,530,721,1345,-1,721,530,1066,-1,1272,750,1275,-1,1272,1383,750,-1,369,1271,370,-1,369,1269,1271,-1,368,1264,342,-1,370,1264,368,-1,1033,1112,1074,-1,1033,359,1112,-1,1383,1250,1251,-1,1383,1267,1250,-1,1031,1114,1113,-1,1031,1135,1114,-1,1263,342,1264,-1,343,342,1263,-1,1263,1331,1261,-1,1265,1331,1263,-1,1336,803,346,-1,1336,338,803,-1,1114,1370,1260,-1,1135,1370,1114,-1,1259,1384,1340,-1,1384,1259,1256,-1,1345,361,530,-1,361,1345,362,-1,330,1194,331,-1,330,1385,1194,-1,321,1196,942,-1,321,320,1196,-1,1203,1254,1386,-1,1203,1253,1254,-1,1255,1249,1253,-1,1249,1255,1387,-1,1385,900,1388,-1,1385,330,900,-1,1246,1388,1245,-1,1388,1246,1252,-1,1387,824,1249,-1,1387,1247,824,-1,751,1246,1244,-1,751,1251,1246,-1,1242,817,1243,-1,817,1242,1026,-1,1243,80,79,-1,1243,1024,80,-1,296,939,297,-1,296,833,939,-1,66,46,991,-1,294,46,66,-1,63,837,64,-1,142,837,63,-1,1209,89,88,-1,89,1209,1205,-1,839,285,47,-1,839,288,285,-1,277,285,841,-1,286,285,277,-1,279,1175,280,-1,955,1175,279,-1,1139,276,278,-1,1389,276,1139,-1,1164,233,31,-1,1164,1239,233,-1,271,1180,272,-1,271,274,1180,-1,1163,1240,957,-1,1163,1390,1240,-1,1161,1182,949,-1,1238,1182,1161,-1,849,986,988,-1,1022,986,849,-1,1022,1391,986,-1,43,885,269,-1,43,852,885,-1,259,976,1392,-1,259,261,976,-1,256,1144,1237,-1,256,255,1144,-1,252,40,1142,-1,252,273,40,-1,273,1393,274,-1,252,1393,273,-1,248,1145,1227,-1,859,1145,248,-1,246,860,253,-1,246,1234,860,-1,29,864,30,-1,1394,864,29,-1,978,168,167,-1,168,978,1207,-1,1177,280,1175,-1,280,1177,171,-1,231,886,232,-1,886,231,1176,-1,1017,230,1178,-1,1016,230,1017,-1,1230,1016,1018,-1,1230,228,1016,-1,274,1395,1180,-1,1393,1395,274,-1,1145,1226,1227,-1,1145,26,1226,-1,872,1234,246,-1,872,1221,1234,-1,223,219,862,-1,223,1146,219,-1,1395,1223,1396,-1,1222,1223,1395,-1,1221,1168,1397,-1,1221,1220,1168,-1,1193,1218,1012,-1,1193,1195,1218,-1,217,213,1398,-1,213,217,216,-1,875,1399,211,-1,875,1217,1399,-1,214,206,205,-1,165,206,214,-1,1311,209,1312,-1,1311,210,209,-1,876,1400,1200,-1,1400,876,1011,-1,1330,210,1311,-1,1330,1204,210,-1,1148,202,161,-1,1148,201,202,-1,201,1401,1213,-1,201,200,1401,-1,1402,1211,1401,-1,1402,1210,1211,-1,881,195,194,-1,195,881,878,-1,1239,1229,1228,-1,1239,1390,1229,-1,1239,1240,1390,-1,1189,1025,1403,-1,822,1025,1189,-1,1150,73,938,-1,79,73,1150,-1,969,972,967,-1,969,1404,972,-1,1002,187,195,-1,1002,901,187,-1,197,185,1154,-1,186,185,197,-1,1179,1152,1153,-1,1162,1152,1179,-1,1179,1405,1162,-1,1405,1179,1396,-1,168,1174,1171,-1,168,1207,1174,-1,1406,1203,1386,-1,1203,1406,1201,-1,1198,809,1398,-1,808,809,1198,-1,1407,324,1136,-1,324,1407,1197,-1,1374,1192,1257,-1,1192,1374,1195,-1,1408,815,181,-1,1408,316,815,-1,1002,1215,1003,-1,1215,1002,877,-1,157,903,203,-1,157,159,903,-1,1409,1320,199,-1,1320,1409,1343,-1,1410,1343,1409,-1,1343,1410,1322,-1,1411,311,310,-1,1412,311,1411,-1,997,124,921,-1,997,125,124,-1,125,893,1001,-1,125,997,893,-1,1411,1187,139,-1,1187,1411,1155,-1,81,911,151,-1,81,134,911,-1,116,139,1187,-1,139,116,115,-1,1156,105,906,-1,106,105,1156,-1,916,913,912,-1,999,913,916,-1,132,909,908,-1,909,132,136,-1,103,1242,1150,-1,1242,103,102,-1,927,1156,926,-1,927,106,1156,-1,156,114,1158,-1,114,156,193,-1,116,1158,114,-1,1158,116,117,-1,1137,100,99,-1,1137,119,100,-1,931,1413,948,-1,931,87,1413,-1,1173,1186,1171,-1,1173,995,1186,-1,1004,821,820,-1,1004,896,821,-1,71,78,830,-1,71,73,78,-1,145,62,69,-1,145,74,62,-1,56,892,57,-1,56,1157,892,-1,946,66,991,-1,946,993,66,-1,1008,1238,1161,-1,851,1238,1008,-1,838,1414,290,-1,838,1183,1414,-1,1181,1413,94,-1,1413,1181,1415,-1,266,250,1142,-1,266,989,250,-1,234,1006,189,-1,167,1006,234,-1,1164,958,957,-1,33,958,1164,-1,977,1178,230,-1,1178,977,190,-1,1177,1416,868,-1,1177,1176,1416,-1,1357,254,1141,-1,1357,1170,254,-1,1220,1169,1168,-1,1394,1169,1220,-1,23,239,221,-1,22,239,23,-1,960,264,857,-1,975,264,960,-1,853,14,1167,-1,853,855,14,-1,16,21,17,-1,21,16,1165,-1,12,984,268,-1,985,984,12,-1,970,1015,1404,-1,1015,970,971,-1,1170,0,2,-1,1170,1357,0,-1,24,19,242,-1,19,24,20,-1,864,222,865,-1,864,1014,222,-1,1206,1172,1174,-1,961,1172,1206,-1,1167,1173,1172,-1,1167,14,1173,-1,34,979,35,-1,34,980,979,-1,1163,1405,1417,-1,1163,1162,1405,-1,1153,956,272,-1,956,1153,982,-1,1018,1178,35,-1,1018,1017,1178,-1,1143,265,247,-1,847,265,1143,-1,949,1184,950,-1,1184,949,1182,-1,51,295,843,-1,51,50,295,-1,312,812,811,-1,312,321,812,-1,70,1023,835,-1,1023,70,65,-1,1010,937,72,-1,943,937,1010,-1,827,302,301,-1,827,936,302,-1,1009,293,1138,-1,1009,998,293,-1,135,83,144,-1,134,83,135,-1,134,81,83,-1,994,996,89,-1,996,994,92,-1,98,929,1159,-1,806,929,98,-1,930,96,1159,-1,930,95,96,-1,922,1160,52,-1,1160,922,126,-1,146,1188,152,-1,1000,1188,146,-1,137,910,923,-1,137,131,910,-1,109,1188,1000,-1,117,1188,109,-1,905,113,112,-1,905,138,113,-1,140,144,83,-1,140,836,144,-1,123,130,149,-1,123,122,130,-1,998,299,305,-1,1009,299,998,-1,918,175,1007,-1,918,173,175,-1,155,192,883,-1,155,154,192,-1,160,1403,1418,-1,160,1189,1403,-1,1418,161,160,-1,1148,161,1418,-1,182,158,1154,-1,158,182,184,-1,879,1051,1419,-1,1051,879,1191,-1,99,1027,816,-1,99,1028,1027,-1,1029,330,329,-1,330,1029,319,-1,1013,164,163,-1,1013,874,164,-1,1194,1219,331,-1,1194,1193,1219,-1,1196,217,942,-1,1196,218,217,-1,1200,1420,1199,-1,1420,1200,1400,-1,1202,1330,1332,-1,1202,1204,1330,-1,1407,898,1197,-1,1407,873,898,-1,929,1186,1159,-1,929,169,1186,-1,28,1206,866,-1,28,963,1206,-1,981,1208,959,-1,981,1223,1208,-1,1408,180,888,-1,180,1408,181,-1,1324,878,881,-1,1190,878,1324,-1,974,967,972,-1,15,967,974,-1,1248,1322,1410,-1,1248,1270,1322,-1,176,159,882,-1,176,903,159,-1,196,1211,880,-1,196,1149,1211,-1,1213,198,204,-1,1213,1149,198,-1,199,1317,200,-1,1320,1317,199,-1,198,1154,158,-1,198,197,1154,-1,1216,1419,1244,-1,1216,1215,1419,-1,207,1201,1406,-1,1147,1201,207,-1,1147,206,208,-1,207,206,1147,-1,209,211,1399,-1,209,208,211,-1,1398,212,1198,-1,212,1398,213,-1,1218,1421,1217,-1,1373,1421,1218,-1,1013,1407,1422,-1,873,1407,1013,-1,11,20,1146,-1,11,21,20,-1,966,1224,1226,-1,966,1208,1224,-1,871,224,220,-1,224,871,245,-1,227,1397,27,-1,1233,1397,227,-1,1423,1224,1222,-1,1225,1224,1423,-1,229,1229,1417,-1,1229,229,228,-1,1230,231,1228,-1,1230,1232,231,-1,1416,1231,979,-1,1416,1232,1231,-1,978,1169,867,-1,978,236,1169,-1,242,4,1140,-1,242,19,4,-1,262,245,244,-1,262,224,245,-1,1236,1233,227,-1,1235,1233,1236,-1,251,1225,1423,-1,249,1225,251,-1,250,249,251,-1,1143,249,250,-1,856,1236,1021,-1,856,1235,1236,-1,257,240,241,-1,257,436,240,-1,1166,1140,4,-1,258,1140,1166,-1,1281,262,263,-1,1281,243,262,-1,1414,1391,983,-1,1391,1414,986,-1,269,1181,952,-1,885,1181,269,-1,1389,271,270,-1,1139,271,1389,-1,38,277,953,-1,38,278,277,-1,1160,992,50,-1,1160,56,992,-1,284,48,47,-1,279,48,284,-1,287,283,843,-1,287,840,283,-1,1185,1184,1241,-1,1184,1185,950,-1,141,1185,1241,-1,1209,1185,141,-1,1205,83,933,-1,1205,140,83,-1,1138,292,296,-1,1138,293,292,-1,54,941,990,-1,54,75,941,-1,72,1009,1010,-1,1009,72,299,-1,1412,139,138,-1,1411,139,1412,-1,928,193,120,-1,928,114,193,-1,1214,1245,899,-1,1214,1216,1245,-1,1248,1268,1270,-1,1248,1247,1268,-1,932,307,84,-1,932,82,307,-1,1252,1258,1424,-1,1250,1258,1252,-1,306,1254,1151,-1,306,1425,1254,-1,1255,1332,1426,-1,1332,1255,1202,-1,810,1420,1425,-1,1420,810,1199,-1,1136,328,327,-1,1136,326,328,-1,1257,1424,1258,-1,1192,1424,1257,-1,1301,635,669,-1,1301,1091,635,-1,1101,340,339,-1,340,1101,347,-1,1262,341,343,-1,1262,1334,341,-1,1426,1266,1427,-1,1265,1266,1426,-1,345,341,346,-1,345,366,341,-1,1256,1428,1384,-1,1267,1428,1256,-1,1428,1274,731,-1,1274,1428,1272,-1,360,1113,351,-1,373,1113,360,-1,1427,1271,1268,-1,1427,1266,1271,-1,368,485,1134,-1,1116,485,368,-1,1274,502,1341,-1,502,1274,1273,-1,371,373,360,-1,374,373,371,-1,518,1104,519,-1,518,560,1104,-1,584,603,589,-1,603,584,601,-1,587,387,686,-1,587,385,387,-1,794,388,1132,-1,794,797,388,-1,792,390,1076,-1,1132,390,792,-1,1429,578,1276,-1,579,578,1429,-1,1366,398,397,-1,398,1366,1382,-1,401,406,405,-1,401,789,406,-1,783,786,784,-1,678,786,783,-1,678,677,786,-1,618,1046,671,-1,1046,618,1047,-1,1045,621,672,-1,1045,1430,621,-1,1098,1365,1353,-1,1098,1352,1365,-1,420,1131,421,-1,420,427,1131,-1,1130,1097,1131,-1,1097,1130,1280,-1,1129,664,1095,-1,1129,665,664,-1,641,1392,1281,-1,640,1392,641,-1,1061,1141,256,-1,629,1141,1061,-1,1282,1129,1379,-1,779,1129,1282,-1,774,1378,1043,-1,1378,774,1284,-1,438,1286,1376,-1,438,1283,1286,-1,662,1085,1087,-1,650,1085,662,-1,446,1289,447,-1,631,1289,446,-1,1092,449,1059,-1,1092,450,449,-1,456,452,676,-1,453,452,456,-1,1293,453,456,-1,453,1293,451,-1,1431,1296,1083,-1,1431,1295,1296,-1,1299,1381,1375,-1,1299,1285,1381,-1,669,1287,1380,-1,668,1287,669,-1,1044,460,763,-1,1044,771,460,-1,1302,1299,1432,-1,1302,1298,1299,-1,460,1433,461,-1,460,1377,1433,-1,1339,474,1304,-1,1339,472,474,-1,759,1308,760,-1,470,1308,759,-1,1434,1310,1309,-1,1434,1421,1310,-1,1309,1312,1434,-1,1312,1309,757,-1,1315,1050,1337,-1,1315,753,1050,-1,1316,1273,1275,-1,1110,1273,1316,-1,1402,1319,1435,-1,1402,1317,1319,-1,1053,1435,746,-1,1321,1435,1053,-1,478,1212,1121,-1,1324,1212,478,-1,332,1056,333,-1,332,516,1056,-1,484,1134,485,-1,484,1436,1134,-1,391,722,1276,-1,391,723,722,-1,1099,599,681,-1,599,1099,604,-1,466,637,467,-1,466,652,637,-1,500,480,479,-1,497,480,500,-1,683,715,714,-1,715,683,684,-1,1432,1326,622,-1,1326,1432,1327,-1,521,1329,735,-1,521,523,1329,-1,524,526,1338,-1,525,526,524,-1,1339,804,1437,-1,805,804,1339,-1,1262,1337,1334,-1,1262,1315,1337,-1,1101,1307,1306,-1,1101,339,1307,-1,1260,1437,804,-1,1260,1115,1437,-1,1437,472,1339,-1,472,1437,1126,-1,353,1112,350,-1,1112,353,358,-1,1074,1032,736,-1,1074,357,1032,-1,1123,1190,1124,-1,1191,1190,1123,-1,1110,528,503,-1,527,528,1110,-1,487,475,1052,-1,475,487,488,-1,487,1436,484,-1,487,1062,1436,-1,1118,1070,1069,-1,1118,1349,1070,-1,1346,535,363,-1,1346,1064,535,-1,1348,539,538,-1,1348,1072,539,-1,719,1064,1346,-1,719,718,1064,-1,1063,538,1067,-1,1063,1348,538,-1,1065,562,1066,-1,563,562,1065,-1,1108,409,552,-1,1108,717,409,-1,1069,557,556,-1,710,557,1069,-1,710,707,711,-1,707,710,509,-1,546,568,567,-1,546,1107,568,-1,522,1060,1106,-1,1060,522,733,-1,611,495,1354,-1,611,1081,495,-1,577,1106,698,-1,577,702,1106,-1,738,368,342,-1,1116,368,738,-1,1429,609,579,-1,1429,610,609,-1,1034,491,692,-1,489,491,1034,-1,372,591,590,-1,372,379,591,-1,491,595,593,-1,491,490,595,-1,715,561,685,-1,715,510,561,-1,512,594,1079,-1,605,594,512,-1,1037,608,408,-1,608,1037,411,-1,612,791,790,-1,791,612,1279,-1,609,1354,1350,-1,609,611,1354,-1,1094,780,772,-1,425,780,1094,-1,776,615,678,-1,1040,615,776,-1,675,1054,742,-1,675,1117,1054,-1,1117,674,1059,-1,675,674,1117,-1,1119,617,1291,-1,617,1119,618,-1,1296,622,1326,-1,1296,1093,622,-1,452,1128,450,-1,1128,452,1127,-1,625,1363,1359,-1,625,627,1363,-1,626,1372,627,-1,626,628,1372,-1,741,635,1090,-1,635,741,633,-1,461,1288,443,-1,1288,461,1433,-1,636,1090,624,-1,636,741,1090,-1,656,645,647,-1,645,656,1088,-1,657,1089,432,-1,657,1358,1089,-1,648,457,1360,-1,458,457,648,-1,1360,1088,643,-1,1088,1360,645,-1,1087,459,662,-1,459,1087,659,-1,0,1358,657,-1,1357,1358,0,-1,655,643,1088,-1,643,655,644,-1,441,463,762,-1,441,440,463,-1,1362,1433,1361,-1,1362,1288,1433,-1,1061,670,628,-1,670,1061,765,-1,1363,1372,1328,-1,1363,627,1372,-1,1351,1359,1363,-1,1086,1359,1351,-1,452,674,676,-1,1092,674,452,-1,1326,1083,1296,-1,1083,1326,1082,-1,620,1058,1039,-1,620,619,1058,-1,1355,456,676,-1,456,1355,454,-1,780,773,772,-1,780,680,773,-1,1366,611,610,-1,1366,1365,611,-1,587,603,1099,-1,589,603,587,-1,510,684,511,-1,715,684,510,-1,586,592,1102,-1,586,692,592,-1,695,382,1103,-1,382,695,1055,-1,698,583,699,-1,698,700,583,-1,572,733,522,-1,572,1105,733,-1,1106,575,522,-1,702,575,1106,-1,726,713,712,-1,726,795,713,-1,1065,568,563,-1,568,1065,566,-1,1133,739,740,-1,1133,705,739,-1,718,533,1064,-1,718,534,533,-1,544,717,1108,-1,543,717,544,-1,718,707,534,-1,718,711,707,-1,569,1066,562,-1,1066,569,721,-1,395,723,393,-1,394,723,395,-1,716,713,793,-1,545,713,716,-1,799,726,378,-1,799,489,726,-1,513,1349,1118,-1,1349,513,550,-1,333,506,486,-1,506,333,1056,-1,1368,1062,1367,-1,1062,1368,1436,-1,1052,1367,1062,-1,1052,1369,1367,-1,748,729,501,-1,748,481,729,-1,1051,1123,749,-1,1051,1191,1123,-1,358,1074,1112,-1,1074,358,357,-1,356,731,1274,-1,731,356,355,-1,1259,1374,1257,-1,1259,1305,1374,-1,1370,1115,1260,-1,1370,526,1115,-1,339,1371,1307,-1,339,338,1371,-1,1261,1315,1262,-1,1261,1314,1315,-1,470,524,1308,-1,524,470,469,-1,1372,670,447,-1,670,1372,628,-1,1302,622,624,-1,622,1302,1432,-1,737,1341,502,-1,737,736,1341,-1,498,1111,743,-1,1111,498,527,-1,648,643,639,-1,643,648,1360,-1,1055,740,688,-1,1055,694,740,-1,369,1436,1368,-1,369,1134,1436,-1,1295,1045,1294,-1,1431,1045,1295,-1,1431,1430,1045,-1,743,478,480,-1,743,1124,478,-1,1321,1402,1435,-1,1210,1402,1321,-1,1435,747,746,-1,747,1435,1319,-1,745,1369,1052,-1,747,1369,745,-1,756,1330,1311,-1,1330,756,1333,-1,1337,1313,1335,-1,1337,1050,1313,-1,754,1049,755,-1,754,753,1049,-1,758,757,1309,-1,757,758,755,-1,761,1307,1371,-1,761,760,1307,-1,1421,1303,1310,-1,1421,1373,1303,-1,1115,1126,1437,-1,1115,469,1126,-1,1361,1377,1300,-1,1433,1377,1361,-1,1432,1375,1327,-1,1432,1299,1375,-1,1048,655,654,-1,468,655,1048,-1,1376,460,771,-1,460,1376,1377,-1,1301,1380,1378,-1,669,1380,1301,-1,1375,782,1364,-1,1375,1381,782,-1,455,1293,456,-1,455,1297,1293,-1,623,454,1355,-1,623,455,454,-1,1119,1292,1047,-1,1119,1356,1292,-1,1362,631,446,-1,634,631,1362,-1,660,667,767,-1,667,660,1085,-1,438,771,770,-1,771,438,1376,-1,1380,1043,1378,-1,1380,1379,1043,-1,1381,783,782,-1,1381,777,783,-1,678,777,776,-1,777,678,783,-1,772,1379,1094,-1,772,1043,1379,-1,766,256,1237,-1,1061,256,766,-1,640,259,1392,-1,647,259,640,-1,1120,429,428,-1,1120,494,429,-1,1096,1131,1097,-1,1096,421,1131,-1,1278,421,1096,-1,1365,1081,611,-1,1365,1352,1081,-1,1430,1083,621,-1,1083,1430,1431,-1,1364,1038,1039,-1,1038,1364,782,-1,1046,672,671,-1,672,1046,1045,-1,413,784,786,-1,413,785,784,-1,1291,788,515,-1,1291,617,788,-1,789,787,406,-1,789,414,787,-1,1366,1429,1382,-1,1366,610,1429,-1,1429,722,1382,-1,1429,1276,722,-1,681,587,1099,-1,681,385,587,-1,585,797,586,-1,797,585,388,-1,597,519,1104,-1,597,739,519,-1,720,1345,721,-1,720,1344,1345,-1,1383,751,750,-1,751,1383,1251,-1,370,1266,1264,-1,1271,1266,370,-1,1428,1383,1272,-1,1428,1267,1383,-1,731,1384,1428,-1,1384,731,1030,-1,1332,1265,1426,-1,1332,1331,1265,-1,1334,346,341,-1,1334,1336,346,-1,1340,1030,805,-1,1030,1340,1384,-1,818,1412,904,-1,818,311,1412,-1,1385,1192,1194,-1,1385,1424,1192,-1,322,942,809,-1,322,812,942,-1,1425,1386,1254,-1,1386,1425,1420,-1,1387,1426,1427,-1,1387,1255,1426,-1,1425,85,810,-1,85,1425,306,-1,1388,1424,1385,-1,1388,1252,1424,-1,899,1388,900,-1,899,1245,1388,-1,814,817,813,-1,814,313,817,-1,1247,1427,1268,-1,1427,1247,1387,-1,895,823,822,-1,895,1004,823,-1,888,899,1408,-1,888,1214,899,-1,313,1243,817,-1,313,1024,1243,-1,138,904,1412,-1,138,905,904,-1,828,304,303,-1,828,826,304,-1,829,1001,104,-1,59,1001,829,-1,946,940,993,-1,946,945,940,-1,67,833,1023,-1,831,833,67,-1,831,939,833,-1,68,143,145,-1,68,291,143,-1,1241,142,141,-1,1241,837,142,-1,87,94,1413,-1,95,94,87,-1,841,288,289,-1,285,288,841,-1,953,841,951,-1,953,277,841,-1,50,44,295,-1,44,50,992,-1,278,273,1139,-1,278,40,273,-1,40,278,38,-1,1389,37,276,-1,1389,32,37,-1,270,32,1389,-1,270,33,32,-1,272,958,270,-1,272,956,958,-1,885,1415,1181,-1,884,1415,885,-1,846,1391,1022,-1,846,983,1391,-1,1238,988,987,-1,988,1238,851,-1,267,43,42,-1,43,267,848,-1,850,43,848,-1,852,43,850,-1,856,853,857,-1,856,1021,853,-1,1392,243,1281,-1,1392,976,243,-1,858,854,859,-1,985,854,858,-1,856,860,1235,-1,1019,860,856,-1,1423,252,251,-1,1423,1393,252,-1,227,859,1236,-1,227,1145,859,-1,1394,867,1169,-1,867,1394,29,-1,169,870,1005,-1,169,929,870,-1,868,171,1177,-1,171,868,172,-1,1176,1232,1416,-1,1176,231,1232,-1,233,1228,231,-1,233,1239,1228,-1,1417,1390,1163,-1,1390,1417,1229,-1,1393,1222,1395,-1,1423,1222,1393,-1,1234,1397,1233,-1,1234,1221,1397,-1,1396,1180,1395,-1,1396,1179,1180,-1,1397,964,27,-1,1397,1168,964,-1,1195,1373,1218,-1,1195,1374,1373,-1,216,214,213,-1,216,215,214,-1,1217,1434,1399,-1,1434,1217,1421,-1,1312,1399,1434,-1,1312,209,1399,-1,1011,1406,1400,-1,207,1406,1011,-1,1051,1244,1419,-1,1051,751,1244,-1,200,1402,1401,-1,1402,200,1317,-1,1401,1149,1213,-1,1401,1211,1149,-1,1212,881,880,-1,1212,1324,881,-1,1248,1403,1025,-1,1403,1248,1410,-1,1183,986,1414,-1,987,986,1183,-1,8,1165,16,-1,8,7,1165,-1,194,197,196,-1,194,186,197,-1,1157,1160,126,-1,1157,56,1160,-1,1405,1223,981,-1,1405,1396,1223,-1,1171,169,168,-1,169,1171,1186,-1,1197,897,218,-1,1197,898,897,-1,327,1219,1422,-1,327,331,1219,-1,1400,1386,1420,-1,1386,1400,1406,-1,1398,942,217,-1,809,942,1398,-1,1422,1136,327,-1,1136,1422,1407,-1,874,1422,1219,-1,874,1013,1422,-1,816,1029,329,-1,816,1027,1029,-1,317,1408,899,-1,1408,317,316,-1,1214,890,1003,-1,1214,888,890,-1,877,1419,1215,-1,1419,877,879,-1,889,1154,185,-1,1154,889,179,-1,1409,1148,1418,-1,199,1148,1409,-1,1410,1418,1403,-1,1409,1418,1410,-1,53,892,60,-1,53,55,892,-1,1411,150,1155,-1,310,150,1411,-1,1187,117,116,-1,1187,1188,117,-1,999,924,913,-1,920,924,999,-1,147,913,924,-1,147,153,913,-1,102,1026,1242,-1,1026,102,1137,-1,917,137,52,-1,137,917,136,-1,919,173,918,-1,173,919,909,-1,923,924,920,-1,924,923,910,-1,170,129,1007,-1,129,170,156,-1,97,92,91,-1,996,92,97,-1,884,949,1415,-1,1161,949,884,-1,96,87,996,-1,95,87,96,-1,823,820,1151,-1,823,1004,820,-1,92,932,86,-1,932,92,994,-1,1150,937,935,-1,938,937,1150,-1,302,830,78,-1,936,830,302,-1,831,993,940,-1,993,831,832,-1,943,925,934,-1,943,76,925,-1,58,944,45,-1,944,58,282,-1,947,944,282,-1,947,945,944,-1,294,295,46,-1,294,843,295,-1,39,844,267,-1,845,844,39,-1,290,983,842,-1,290,1414,983,-1,1415,948,1413,-1,948,1415,949,-1,265,858,247,-1,265,984,858,-1,39,1142,40,-1,39,266,1142,-1,189,36,190,-1,1006,36,189,-1,34,1006,1005,-1,34,36,1006,-1,955,886,1175,-1,955,887,886,-1,981,1417,1405,-1,229,1417,981,-1,868,979,869,-1,868,1416,979,-1,1172,960,1167,-1,960,1172,961,-1,1206,962,961,-1,962,1206,963,-1,25,188,965,-1,25,235,188,-1,1394,1014,864,-1,1394,1220,1014,-1,965,977,959,-1,188,977,965,-1,970,861,261,-1,970,968,861,-1,975,2,264,-1,1170,2,975,-1,1015,972,1404,-1,1015,973,972,-1,968,1404,969,-1,968,970,1404,-1],creaseAngle=1.571,normalIndex=[719,354,682,-1,1319,1274,1317,-1,1355,1361,1329,-1,29,1,105,-1,691,1347,1262,-1,243,1064,479,-1,105,1,52,-1,1059,203,333,-1,638,78,179,-1,499,318,123,-1,1189,1228,1154,-1,321,26,50,-1,1181,1047,1205,-1,26,321,227,-1,81,297,194,-1,391,661,613,-1,367,316,86,-1,36,323,543,-1,554,566,1196,-1,398,322,386,-1,868,557,410,-1,651,644,1187,-1,296,500,252,-1,261,62,615,-1,778,166,210,-1,23,3,76,-1,500,296,619,-1,172,112,30,-1,173,622,773,-1,514,493,952,-1,218,204,650,-1,1298,1246,1129,-1,597,1116,1098,-1,1422,1358,1395,-1,1391,1404,1431,-1,340,355,80,-1,1050,1021,1208,-1,1390,1423,1370,-1,996,1071,1149,-1,1096,834,276,-1,152,39,87,-1,511,1071,624,-1,355,452,275,-1,670,508,495,-1,1289,1364,1311,-1,435,262,441,-1,1311,1364,1187,-1,1095,1349,1110,-1,241,379,902,-1,1273,1110,1432,-1,276,98,0,-1,1053,1062,858,-1,869,939,458,-1,856,327,670,-1,983,544,1095,-1,42,338,679,-1,338,856,679,-1,216,856,338,-1,474,214,325,-1,403,259,235,-1,438,412,270,-1,1259,1057,1132,-1,1215,1431,1404,-1,1296,1350,1327,-1,610,569,915,-1,490,445,450,-1,158,279,222,-1,28,34,68,-1,68,80,44,-1,80,136,100,-1,200,547,582,-1,76,622,173,-1,1137,1224,1125,-1,610,1099,894,-1,136,205,214,-1,582,936,909,-1,836,563,464,-1,656,689,608,-1,412,480,351,-1,466,464,259,-1,1203,1159,1133,-1,987,917,966,-1,1132,938,987,-1,1236,1294,1279,-1,1132,1332,1259,-1,1323,1076,1184,-1,203,179,10,-1,15,83,168,-1,33,29,105,-1,55,61,6,-1,128,123,318,-1,853,835,897,-1,823,793,842,-1,1212,1042,1012,-1,1123,1154,1018,-1,634,1034,1018,-1,1139,638,995,-1,346,61,55,-1,271,56,85,-1,535,520,515,-1,578,476,461,-1,271,159,354,-1,1027,1080,692,-1,683,1139,671,-1,731,735,880,-1,263,271,725,-1,601,682,354,-1,583,661,391,-1,534,297,745,-1,826,391,537,-1,38,126,65,-1,277,303,126,-1,227,113,18,-1,54,92,18,-1,429,550,323,-1,516,396,557,-1,566,242,543,-1,93,11,5,-1,188,261,210,-1,166,296,37,-1,13,252,223,-1,904,759,544,-1,544,759,417,-1,51,62,261,-1,367,86,370,-1,666,424,121,-1,129,3,211,-1,773,873,463,-1,253,545,211,-1,545,611,129,-1,1050,1096,452,-1,136,80,275,-1,427,597,204,-1,218,229,47,-1,17,2,143,-1,181,843,234,-1,244,185,190,-1,244,127,184,-1,196,146,181,-1,59,77,47,-1,629,256,309,-1,576,420,404,-1,404,257,395,-1,284,526,219,-1,1291,884,1240,-1,1202,1145,1378,-1,971,782,572,-1,1388,1233,1269,-1,1324,1315,1378,-1,1011,1030,905,-1,1193,1101,1253,-1,1193,1310,1247,-1,1193,1066,1015,-1,905,593,590,-1,1074,1295,1315,-1,1394,1388,1421,-1,484,1028,841,-1,870,684,625,-1,344,590,593,-1,565,595,343,-1,928,1074,970,-1,45,928,827,-1,923,1087,986,-1,1414,1206,1162,-1,1384,1151,1256,-1,332,659,509,-1,326,483,471,-1,530,519,969,-1,690,587,1183,-1,1183,1140,1400,-1,1369,1411,1272,-1,1428,1418,1338,-1,1400,1411,1407,-1,238,482,882,-1,1328,1419,1435,-1,1035,1210,1328,-1,1385,1427,1399,-1,696,660,1070,-1,607,1044,953,-1,697,575,696,-1,903,824,1044,-1,1250,1218,837,-1,726,719,1085,-1,425,710,409,-1,1085,1218,1285,-1,329,787,764,-1,460,497,282,-1,209,150,151,-1,606,148,267,-1,635,433,639,-1,517,585,579,-1,246,175,89,-1,1377,1219,1264,-1,1359,1430,1420,-1,1113,1320,1398,-1,70,94,189,-1,453,388,672,-1,1089,1037,967,-1,588,602,496,-1,1337,1195,1346,-1,1158,1001,1016,-1,1168,1158,1216,-1,1293,1425,1408,-1,813,581,530,-1,879,840,832,-1,496,889,857,-1,1235,877,1226,-1,1290,1305,1393,-1,1346,1281,1225,-1,860,335,447,-1,831,893,973,-1,985,871,885,-1,148,606,862,-1,71,154,237,-1,454,1016,1001,-1,454,526,1016,-1,106,25,58,-1,72,70,96,-1,70,230,96,-1,1040,857,1200,-1,1216,1213,1089,-1,1235,1393,1305,-1,1013,928,301,-1,124,570,376,-1,1394,1083,1209,-1,559,1185,1292,-1,328,451,580,-1,90,331,948,-1,63,335,860,-1,193,373,149,-1,940,482,165,-1,373,193,860,-1,149,373,186,-1,678,1141,331,-1,1231,1225,1114,-1,1090,1286,1114,-1,1135,790,796,-1,604,290,310,-1,71,310,290,-1,298,335,63,-1,14,64,48,-1,1160,984,1297,-1,66,148,284,-1,95,53,22,-1,484,841,300,-1,140,192,180,-1,1233,1388,1222,-1,962,935,540,-1,986,1087,1162,-1,742,430,992,-1,1376,998,1188,-1,830,1112,1315,-1,969,1272,1140,-1,1275,1322,1118,-1,1299,1301,920,-1,1073,1122,1017,-1,1009,742,991,-1,1237,1009,1121,-1,991,1019,1014,-1,989,1104,882,-1,162,268,397,-1,1338,1070,1117,-1,607,95,16,-1,1267,1138,1092,-1,1035,1024,828,-1,1343,1417,1088,-1,820,529,653,-1,1210,1035,828,-1,236,305,183,-1,286,305,413,-1,142,157,226,-1,392,421,931,-1,529,381,653,-1,1386,1198,1220,-1,1023,1086,1374,-1,1220,1134,1406,-1,525,250,558,-1,175,556,487,-1,258,374,957,-1,1430,1359,1241,-1,1367,1401,1072,-1,719,758,1085,-1,163,117,164,-1,114,84,89,-1,1406,1320,1436,-1,760,988,95,-1,957,374,1198,-1,1320,1386,1436,-1,258,1113,1227,-1,443,1241,1359,-1,1313,1120,931,-1,282,209,254,-1,1124,1060,1412,-1,255,231,389,-1,1412,1210,1124,-1,1354,1242,1138,-1,1044,824,780,-1,789,780,697,-1,696,1092,1138,-1,1073,1351,1122,-1,238,883,362,-1,571,1017,893,-1,154,249,790,-1,998,1376,1182,-1,509,1239,1272,-1,1318,1433,1414,-1,771,1182,659,-1,488,430,742,-1,1275,1321,1408,-1,668,814,1265,-1,935,921,471,-1,791,1222,962,-1,140,202,307,-1,841,791,339,-1,454,484,219,-1,79,16,40,-1,1231,1161,1303,-1,387,341,237,-1,45,124,64,-1,335,298,365,-1,1286,1348,1397,-1,1090,833,954,-1,1141,744,993,-1,149,186,125,-1,125,357,249,-1,342,451,328,-1,580,1185,559,-1,328,165,4,-1,752,1230,1348,-1,1437,1342,1160,-1,581,375,383,-1,560,969,519,-1,1217,744,1141,-1,744,827,1164,-1,124,45,744,-1,1084,1357,1161,-1,1217,1083,570,-1,1037,1195,1337,-1,1392,1410,1226,-1,1238,1310,1253,-1,189,313,388,-1,8,212,300,-1,106,88,142,-1,862,606,871,-1,482,940,989,-1,1216,1158,1281,-1,1368,1403,1410,-1,1368,1392,1357,-1,1357,1337,1303,-1,1235,1200,857,-1,114,258,84,-1,794,782,1028,-1,440,920,845,-1,1225,1281,1016,-1,299,381,312,-1,1225,1231,1303,-1,857,533,496,-1,974,877,602,-1,949,863,817,-1,949,967,863,-1,967,1037,1180,-1,1403,1393,1410,-1,891,951,688,-1,228,304,278,-1,448,467,518,-1,448,492,313,-1,155,144,208,-1,155,189,94,-1,1227,1398,1241,-1,1341,1415,1264,-1,1320,1401,1398,-1,1430,1389,1420,-1,226,157,421,-1,311,390,425,-1,764,460,425,-1,195,443,329,-1,558,1023,1072,-1,1374,1169,1389,-1,1167,1278,1352,-1,876,821,919,-1,861,929,977,-1,329,683,195,-1,735,731,558,-1,1169,725,1167,-1,837,1085,758,-1,1250,1058,1280,-1,953,1044,852,-1,330,903,607,-1,1148,1170,1314,-1,1210,1412,1380,-1,1328,1210,1419,-1,1419,1345,1382,-1,885,1005,1104,-1,1435,1424,1407,-1,1267,1338,1418,-1,1272,1400,1140,-1,1428,1396,1214,-1,536,560,898,-1,652,993,1032,-1,1073,1067,1351,-1,992,774,1321,-1,1433,1206,1414,-1,668,975,565,-1,970,986,1162,-1,1308,928,1206,-1,970,1112,923,-1,984,341,387,-1,1303,1161,1357,-1,841,1028,1233,-1,1209,1388,1394,-1,1434,1421,1295,-1,830,1258,595,-1,1193,1247,1252,-1,1193,1253,1310,-1,1240,1258,1291,-1,1378,1388,1360,-1,1030,864,1039,-1,1099,1402,1221,-1,233,59,291,-1,47,77,170,-1,122,111,59,-1,256,196,234,-1,513,420,384,-1,244,245,185,-1,528,513,846,-1,234,843,384,-1,359,314,122,-1,42,2,17,-1,427,647,945,-1,502,586,786,-1,68,340,80,-1,603,873,843,-1,545,485,359,-1,1390,611,545,-1,531,485,449,-1,1021,753,1208,-1,23,102,253,-1,943,615,437,-1,1106,1166,922,-1,759,904,1166,-1,939,946,619,-1,252,850,755,-1,37,296,252,-1,166,19,75,-1,21,13,46,-1,288,242,566,-1,1196,566,543,-1,5,18,93,-1,747,347,366,-1,583,654,661,-1,865,914,812,-1,746,551,812,-1,407,178,446,-1,601,187,510,-1,725,271,726,-1,1018,1034,710,-1,520,337,315,-1,520,535,337,-1,354,159,153,-1,61,350,67,-1,880,1266,1319,-1,638,1139,1034,-1,907,972,1018,-1,1287,1288,1228,-1,1043,1163,1268,-1,24,168,60,-1,78,83,15,-1,1356,1259,1332,-1,1057,999,895,-1,1186,1236,1203,-1,632,807,693,-1,351,480,466,-1,836,779,849,-1,136,91,100,-1,279,158,415,-1,619,946,858,-1,598,591,551,-1,793,816,609,-1,147,41,134,-1,91,214,158,-1,435,996,1108,-1,557,567,386,-1,450,550,569,-1,1099,610,915,-1,1365,1127,1208,-1,434,415,982,-1,982,415,894,-1,1356,1332,1323,-1,1375,1344,1356,-1,420,309,384,-1,513,528,404,-1,190,264,197,-1,394,240,582,-1,222,351,225,-1,200,240,41,-1,418,505,1136,-1,670,1312,856,-1,42,229,338,-1,241,892,667,-1,902,983,1110,-1,508,1107,1349,-1,207,27,191,-1,523,1108,1373,-1,435,131,262,-1,947,490,1273,-1,324,131,135,-1,1063,523,1244,-1,1063,1251,1255,-1,327,762,1107,-1,670,495,417,-1,302,644,651,-1,1127,1146,834,-1,1146,1127,1365,-1,1108,1149,1370,-1,1423,1387,1370,-1,276,141,452,-1,1099,1268,1379,-1,1347,1422,1416,-1,1116,597,945,-1,1298,1257,1246,-1,204,218,47,-1,493,481,930,-1,273,753,512,-1,253,102,353,-1,137,120,3,-1,1004,698,424,-1,778,458,166,-1,181,122,314,-1,121,424,377,-1,111,146,358,-1,322,302,112,-1,139,273,512,-1,367,410,316,-1,317,422,198,-1,436,396,516,-1,322,398,302,-1,445,947,543,-1,983,939,869,-1,1276,1038,1172,-1,366,132,46,-1,826,1105,1347,-1,171,347,297,-1,399,609,411,-1,20,352,9,-1,835,788,897,-1,609,399,227,-1,1197,1254,1131,-1,1027,1131,1155,-1,1155,1123,1080,-1,295,1012,1042,-1,932,673,499,-1,1,224,243,-1,294,306,29,-1,350,61,346,-1,29,306,224,-1,913,880,1199,-1,875,1263,1329,-1,1361,1355,1319,-1,179,78,6,-1,33,67,294,-1,67,350,294,-1,6,10,179,-1,1361,1319,1317,-1,1329,941,875,-1,1059,1317,1274,-1,29,224,1,-1,1100,1197,1131,-1,442,350,346,-1,294,29,33,-1,52,1,243,-1,897,788,1056,-1,1042,499,295,-1,1296,1212,1282,-1,1155,1189,1123,-1,1027,1155,1080,-1,227,321,609,-1,1163,1010,1190,-1,835,618,788,-1,20,97,352,-1,297,81,171,-1,1105,1422,1347,-1,46,320,366,-1,337,478,269,-1,686,792,848,-1,534,745,640,-1,983,902,939,-1,323,445,543,-1,419,436,516,-1,198,99,317,-1,422,436,698,-1,367,475,410,-1,137,139,512,-1,112,172,322,-1,121,377,172,-1,314,603,181,-1,62,248,437,-1,698,377,424,-1,353,449,253,-1,481,900,930,-1,945,1215,1116,-1,982,894,1221,-1,1347,1416,1383,-1,1379,1402,1099,-1,1404,1391,1234,-1,276,39,141,-1,1208,1127,1096,-1,1370,1373,1108,-1,1365,1387,1146,-1,1096,1127,834,-1,275,452,141,-1,1405,1387,1365,-1,302,398,644,-1,205,325,214,-1,417,274,670,-1,1107,508,327,-1,1063,1289,1251,-1,1063,459,523,-1,324,262,131,-1,490,667,1273,-1,1244,1289,1063,-1,1373,1244,523,-1,216,207,191,-1,1349,1095,508,-1,902,1110,892,-1,135,241,667,-1,1312,1061,856,-1,418,1136,545,-1,1284,1187,1364,-1,1244,1373,1405,-1,240,134,41,-1,394,532,265,-1,197,127,190,-1,1356,1323,1375,-1,982,636,434,-1,1208,1284,1365,-1,1099,915,1268,-1,1260,1271,1296,-1,386,516,557,-1,435,1108,523,-1,450,445,550,-1,610,439,450,-1,147,34,41,-1,936,582,547,-1,551,562,598,-1,500,619,858,-1,145,30,12,-1,270,222,279,-1,415,434,279,-1,91,235,100,-1,849,936,836,-1,351,466,403,-1,1186,1203,1126,-1,999,761,895,-1,1356,1277,1259,-1,15,6,78,-1,168,220,60,-1,1191,1355,1263,-1,822,918,859,-1,915,1043,1268,-1,1190,1181,1260,-1,1287,1228,1189,-1,907,1018,1154,-1,638,1034,634,-1,1319,1199,880,-1,354,153,221,-1,709,1018,710,-1,726,354,719,-1,601,221,187,-1,407,161,178,-1,746,562,551,-1,537,391,613,-1,745,747,865,-1,826,478,391,-1,747,366,781,-1,50,38,9,-1,399,113,227,-1,18,113,93,-1,1196,543,947,-1,21,46,132,-1,75,210,166,-1,37,252,13,-1,223,252,755,-1,939,619,458,-1,922,783,1106,-1,51,188,288,-1,253,211,23,-1,1021,512,753,-1,353,531,449,-1,545,1136,1390,-1,359,418,545,-1,873,1094,843,-1,502,786,741,-1,945,597,427,-1,17,47,42,-1,122,143,359,-1,528,846,867,-1,244,416,371,-1,244,190,127,-1,244,184,334,-1,513,404,420,-1,122,59,17,-1,47,170,204,-1,233,77,59,-1,1221,894,1099,-1,1030,1039,1178,-1,1030,1011,864,-1,1378,1421,1388,-1,1240,1201,1258,-1,1193,1015,1101,-1,1193,1192,1066,-1,1258,1201,595,-1,1421,1315,1295,-1,1209,1222,1388,-1,1233,791,841,-1,387,646,984,-1,970,1074,1112,-1,1308,827,928,-1,970,1162,1206,-1,1206,928,970,-1,565,343,668,-1,1433,1308,1206,-1,774,1194,1321,-1,652,898,993,-1,898,652,536,-1,1214,1183,1428,-1,1272,1411,1400,-1,1382,1267,1418,-1,1407,1339,1435,-1,872,882,1207,-1,1014,973,1017,-1,973,893,1017,-1,1104,989,885,-1,1382,1435,1419,-1,1210,1380,1419,-1,1148,1314,1302,-1,1399,1371,1302,-1,903,1044,607,-1,906,697,1138,-1,1044,780,852,-1,1250,924,1058,-1,1167,726,1085,-1,558,163,735,-1,683,671,195,-1,1167,1085,1278,-1,977,958,861,-1,919,886,876,-1,1352,1381,1167,-1,1374,1086,1169,-1,443,787,329,-1,425,409,764,-1,425,282,311,-1,392,226,421,-1,541,648,645,-1,1430,1374,1389,-1,1320,1406,1401,-1,1341,1420,1415,-1,1398,1426,1241,-1,155,313,189,-1,155,208,228,-1,448,313,278,-1,448,368,467,-1,228,308,304,-1,687,891,688,-1,967,1180,974,-1,1022,1089,949,-1,974,602,815,-1,1225,1303,1346,-1,312,215,299,-1,1363,1265,814,-1,114,374,258,-1,1235,857,889,-1,1357,1392,1337,-1,1368,1410,1392,-1,1216,1281,1213,-1,955,862,1114,-1,1283,1353,1343,-1,940,985,989,-1,862,871,985,-1,106,142,177,-1,31,8,300,-1,390,311,356,-1,1253,1178,1238,-1,997,1168,1022,-1,1180,1037,1337,-1,955,1114,1225,-1,1217,1229,1083,-1,1083,754,570,-1,45,827,744,-1,560,451,898,-1,451,342,898,-1,1217,570,744,-1,530,581,383,-1,1160,1397,1437,-1,301,292,926,-1,1348,954,752,-1,328,4,90,-1,580,1048,1185,-1,328,90,342,-1,125,249,73,-1,833,1000,1103,-1,860,961,1306,-1,1306,978,860,-1,125,73,149,-1,1141,993,948,-1,1084,1161,984,-1,1397,1297,1286,-1,447,335,365,-1,64,14,45,-1,237,440,387,-1,1097,1357,1084,-1,16,22,40,-1,484,212,219,-1,339,300,841,-1,307,192,140,-1,791,1233,1222,-1,935,471,483,-1,1265,975,668,-1,1408,1322,1275,-1,933,813,1140,-1,1414,1363,1318,-1,633,509,1272,-1,1182,771,998,-1,1140,1183,933,-1,249,796,790,-1,571,959,1017,-1,1036,1046,1118,-1,238,872,883,-1,696,1138,697,-1,789,697,800,-1,840,797,832,-1,760,95,607,-1,1143,1283,942,-1,1060,1385,1412,-1,254,311,282,-1,931,1142,1313,-1,787,443,1359,-1,380,258,1227,-1,1198,1386,957,-1,988,174,95,-1,1218,1085,837,-1,89,175,114,-1,1198,374,487,-1,117,116,164,-1,487,374,114,-1,1401,1150,1072,-1,1430,1241,1426,-1,957,1113,258,-1,114,175,487,-1,380,164,116,-1,1406,1436,1220,-1,336,305,236,-1,1072,1023,1374,-1,1220,1436,1386,-1,501,931,769,-1,421,1142,931,-1,413,356,286,-1,1210,828,1124,-1,267,247,433,-1,820,623,529,-1,1417,1427,1088,-1,1267,1354,1138,-1,16,330,607,-1,1396,1338,1117,-1,1109,1171,953,-1,756,589,649,-1,906,800,697,-1,882,482,989,-1,1118,1135,1036,-1,1019,973,1014,-1,1121,1340,1237,-1,959,1073,1017,-1,920,1165,1299,-1,1322,1135,1118,-1,1324,1081,1291,-1,813,969,1140,-1,1258,830,1315,-1,633,1272,969,-1,742,992,1054,-1,1301,1433,1318,-1,1087,1335,1162,-1,1165,920,680,-1,1048,580,519,-1,935,483,540,-1,484,300,212,-1,454,219,526,-1,16,95,22,-1,66,284,35,-1,31,202,43,-1,1297,1397,1160,-1,237,341,310,-1,64,298,63,-1,71,290,48,-1,310,341,604,-1,1161,1297,984,-1,32,71,48,-1,796,1036,1135,-1,1286,1231,1114,-1,1141,948,331,-1,373,182,186,-1,860,978,373,-1,940,165,801,-1,961,1103,1306,-1,860,193,63,-1,342,90,948,-1,580,559,328,-1,1292,801,559,-1,124,744,570,-1,926,1013,301,-1,71,32,73,-1,193,32,63,-1,1305,1200,1235,-1,1040,1174,910,-1,905,1030,908,-1,1011,1052,1128,-1,70,206,230,-1,106,66,25,-1,804,454,1001,-1,237,310,71,-1,862,284,148,-1,177,142,167,-1,1046,831,973,-1,447,961,860,-1,985,885,989,-1,862,985,994,-1,1393,1403,1290,-1,1235,889,877,-1,645,828,620,-1,879,847,840,-1,813,933,581,-1,1281,1158,1016,-1,1346,1303,1337,-1,588,662,602,-1,967,949,1089,-1,805,750,630,-1,388,522,672,-1,189,160,70,-1,1113,1398,1227,-1,1359,1420,1341,-1,1264,1415,1377,-1,635,498,433,-1,507,606,267,-1,247,177,255,-1,151,254,209,-1,460,282,425,-1,329,764,409,-1,1374,1367,1072,-1,1285,1278,1085,-1,425,709,710,-1,725,726,1167,-1,837,924,1250,-1,1280,988,1245,-1,1280,1058,988,-1,575,637,524,-1,852,780,789,-1,1070,1092,696,-1,1435,1339,1328,-1,882,872,238,-1,1151,872,1207,-1,1407,1424,1400,-1,1428,1338,1396,-1,1239,1369,1272,-1,1400,1428,1183,-1,1183,1214,690,-1,530,969,813,-1,383,326,471,-1,652,272,536,-1,272,332,509,-1,488,998,771,-1,1414,1162,1335,-1,923,986,970,-1,45,301,928,-1,928,1013,1074,-1,565,830,595,-1,593,401,344,-1,1368,1357,1097,-1,870,950,684,-1,484,794,1028,-1,1394,1421,1434,-1,1074,1315,1112,-1,1201,1052,595,-1,905,908,593,-1,1193,1252,1192,-1,905,1052,1011,-1,1179,1201,1240,-1,1315,1421,1378,-1,1269,1360,1388,-1,971,1028,782,-1,1378,1360,1202,-1,1291,1081,884,-1,35,284,219,-1,395,576,404,-1,629,309,785,-1,47,17,59,-1,181,234,196,-1,244,334,416,-1,244,371,245,-1,181,603,843,-1,143,122,17,-1,229,42,47,-1,597,650,204,-1,1050,452,795,-1,129,211,545,-1,773,1094,873,-1,3,23,211,-1,121,239,666,-1,51,261,188,-1,544,417,495,-1,904,544,869,-1,13,223,46,-1,19,166,37,-1,188,210,75,-1,93,36,11,-1,396,410,557,-1,550,445,323,-1,54,18,5,-1,126,118,277,-1,537,1105,826,-1,391,478,583,-1,271,354,726,-1,735,1266,880,-1,1139,1248,671,-1,681,1027,692,-1,578,461,503,-1,535,515,614,-1,271,85,159,-1,346,55,263,-1,880,350,442,-1,995,1248,1139,-1,634,1018,972,-1,1123,1018,1045,-1,1012,1282,1212,-1,853,897,822,-1,128,318,372,-1,6,15,55,-1,105,49,33,-1,15,168,24,-1,49,203,10,-1,1323,1184,1375,-1,1132,1279,1332,-1,1279,1203,1236,-1,987,1159,1132,-1,966,1069,987,-1,1133,1126,1203,-1,34,28,41,-1,259,403,466,-1,656,608,568,-1,464,621,836,-1,214,91,136,-1,610,894,474,-1,1056,1137,1125,-1,214,415,158,-1,1021,592,512,-1,647,427,655,-1,240,200,582,-1,100,44,80,-1,44,28,68,-1,222,225,158,-1,474,325,610,-1,156,97,82,-1,490,947,445,-1,610,450,569,-1,1327,1260,1296,-1,1404,1116,1215,-1,1045,1080,1123,-1,44,213,28,-1,259,100,235,-1,207,216,338,-1,355,275,80,-1,679,201,42,-1,670,274,611,-1,983,869,544,-1,856,216,327,-1,858,946,1053,-1,276,0,39,-1,1136,505,1144,-1,1110,1349,1432,-1,902,892,241,-1,983,1095,1110,-1,1187,1082,1311,-1,441,996,435,-1,441,624,996,-1,1289,1311,1251,-1,670,327,508,-1,349,511,624,-1,1071,996,624,-1,152,141,39,-1,276,452,1096,-1,1149,1108,996,-1,1312,1390,1370,-1,1050,1208,1096,-1,205,136,275,-1,1431,1413,1391,-1,1395,1416,1422,-1,650,597,1098,-1,1234,1298,1129,-1,650,481,218,-1,493,930,952,-1,773,463,173,-1,121,172,30,-1,943,698,1004,-1,615,783,261,-1,3,120,76,-1,210,922,778,-1,62,437,615,-1,1187,1284,651,-1,475,868,410,-1,1196,1077,554,-1,543,242,36,-1,598,562,643,-1,691,826,1347,-1,293,489,156,-1,50,378,321,-1,1189,1154,1123,-1,499,123,295,-1,995,638,179,-1,1176,1059,333,-1,52,243,479,-1,1262,446,691,-1,221,601,354,-1,1263,1355,1329,-1,243,941,1064,-1,1319,1266,1274,-1,941,1329,1064,-1,1319,1191,1199,-1,1355,1191,1319,-1,1266,723,1274,-1,1266,735,723,-1,1223,510,407,-1,510,1223,1197,-1,6,67,10,-1,6,61,67,-1,83,972,168,-1,634,972,83,-1,1012,260,1029,-1,1012,295,260,-1,1027,1100,1131,-1,964,1100,1027,-1,1366,1326,1362,-1,1326,1366,1334,-1,811,878,881,-1,811,816,878,-1,1047,1125,1205,-1,1047,1008,1125,-1,352,156,489,-1,352,97,156,-1,289,65,281,-1,65,289,82,-1,132,347,171,-1,132,366,347,-1,640,614,578,-1,640,654,614,-1,1105,1358,1422,-1,1105,1091,1358,-1,755,916,675,-1,755,1007,916,-1,654,745,661,-1,654,640,745,-1,322,516,386,-1,322,419,516,-1,644,1082,1187,-1,1082,644,567,-1,139,30,112,-1,12,30,139,-1,314,873,603,-1,873,314,531,-1,30,239,121,-1,30,145,239,-1,1276,1157,1257,-1,1172,1157,1276,-1,945,1221,1215,-1,945,982,1221,-1,1215,1402,1431,-1,1402,1215,1221,-1,1413,1383,1416,-1,1383,1413,1372,-1,1262,1383,1362,-1,1262,1347,1383,-1,1387,1373,1370,-1,1405,1373,1387,-1,349,441,325,-1,349,624,441,-1,131,523,459,-1,435,523,131,-1,1196,1255,1251,-1,1432,1255,1196,-1,834,1144,505,-1,834,1146,1144,-1,241,207,379,-1,207,241,27,-1,679,199,201,-1,751,199,679,-1,135,27,241,-1,131,27,135,-1,1061,1149,1071,-1,1312,1149,1061,-1,1149,1312,1370,-1,1390,670,611,-1,1390,1312,670,-1,262,439,441,-1,324,439,262,-1,468,270,279,-1,438,270,468,-1,351,270,412,-1,351,222,270,-1,240,265,134,-1,240,394,265,-1,724,693,807,-1,724,715,693,-1,245,340,68,-1,340,245,371,-1,184,197,257,-1,197,184,127,-1,539,546,400,-1,539,612,546,-1,629,1184,552,-1,629,1211,1184,-1,925,319,233,-1,319,925,963,-1,1078,888,990,-1,888,1078,956,-1,196,629,552,-1,196,256,629,-1,1129,930,900,-1,1129,1111,930,-1,1334,1287,1261,-1,1330,1287,1334,-1,600,932,788,-1,932,600,673,-1,493,338,229,-1,338,493,514,-1,273,651,753,-1,651,273,302,-1,1042,1224,1137,-1,1042,1212,1224,-1,632,909,807,-1,632,532,909,-1,52,333,105,-1,479,333,52,-1,316,99,86,-1,316,317,99,-1,1062,1111,1153,-1,1111,1062,1053,-1,502,279,434,-1,279,502,468,-1,720,779,763,-1,721,779,720,-1,577,480,608,-1,466,480,577,-1,266,402,382,-1,266,265,402,-1,1069,956,1078,-1,966,956,1069,-1,1236,963,925,-1,963,1236,1186,-1,938,1057,895,-1,1132,1057,938,-1,851,761,775,-1,761,851,895,-1,761,740,546,-1,999,740,761,-1,232,60,220,-1,60,232,101,-1,494,600,542,-1,549,600,494,-1,60,56,24,-1,56,60,85,-1,486,616,549,-1,594,616,486,-1,853,854,874,-1,854,853,809,-1,802,809,859,-1,802,770,809,-1,1010,859,1047,-1,1010,802,859,-1,1268,1190,1260,-1,1190,1268,1163,-1,1330,1288,1287,-1,1330,1282,1288,-1,1059,1361,1317,-1,1059,1176,1361,-1,107,153,119,-1,153,107,130,-1,594,515,520,-1,594,486,515,-1,178,138,315,-1,178,161,138,-1,1018,707,1045,-1,707,1018,709,-1,691,178,269,-1,446,178,691,-1,848,812,914,-1,848,746,812,-1,914,747,781,-1,865,747,914,-1,916,792,675,-1,792,916,776,-1,352,911,378,-1,912,911,352,-1,842,609,321,-1,842,793,609,-1,113,429,93,-1,399,429,113,-1,411,429,399,-1,36,75,19,-1,242,75,36,-1,850,1007,755,-1,850,1020,1007,-1,1246,1157,1153,-1,1246,1257,1157,-1,922,904,778,-1,922,1166,904,-1,1106,759,1166,-1,666,759,1106,-1,436,377,698,-1,436,419,377,-1,1049,622,592,-1,1049,1102,622,-1,531,359,485,-1,359,531,314,-1,491,385,382,-1,385,491,465,-1,767,741,786,-1,741,767,765,-1,806,586,655,-1,806,786,586,-1,528,795,340,-1,867,795,528,-1,702,465,701,-1,428,465,702,-1,309,234,384,-1,256,234,309,-1,655,839,806,-1,655,829,839,-1,888,839,990,-1,888,810,839,-1,77,319,170,-1,319,77,233,-1,499,616,318,-1,616,499,673,-1,960,704,703,-1,960,899,704,-1,1011,657,864,-1,1128,657,1011,-1,572,444,431,-1,599,444,572,-1,631,627,599,-1,631,658,627,-1,703,1006,960,-1,703,702,1006,-1,1209,962,1222,-1,935,962,1209,-1,734,676,736,-1,676,734,674,-1,1051,1173,1175,-1,1173,1051,1055,-1,1231,1297,1161,-1,1286,1297,1231,-1,668,344,814,-1,344,668,343,-1,1293,1433,1425,-1,1293,1308,1433,-1,1054,1118,1019,-1,1275,1118,1054,-1,652,1194,774,-1,1032,1194,652,-1,587,933,1183,-1,587,581,933,-1,307,285,192,-1,307,326,285,-1,1207,1256,1151,-1,1256,1207,1369,-1,1104,1339,1407,-1,1104,1005,1339,-1,959,362,883,-1,571,362,959,-1,1382,1354,1267,-1,1354,1382,1345,-1,1302,1380,1399,-1,1302,1314,1380,-1,348,903,330,-1,348,847,903,-1,798,1041,1117,-1,798,756,1041,-1,832,637,879,-1,832,743,637,-1,1169,728,725,-1,1086,728,1169,-1,195,723,164,-1,195,671,723,-1,409,683,329,-1,683,409,710,-1,1300,1250,1280,-1,1307,1250,1300,-1,919,861,958,-1,919,821,861,-1,944,958,976,-1,944,919,958,-1,1331,1300,1309,-1,1331,1307,1300,-1,1381,1169,1167,-1,1389,1169,1381,-1,250,163,558,-1,163,250,117,-1,497,209,282,-1,497,432,209,-1,88,157,142,-1,88,108,157,-1,885,555,626,-1,885,871,555,-1,605,628,573,-1,635,628,605,-1,564,623,685,-1,564,596,623,-1,887,976,937,-1,887,944,976,-1,1333,1309,1313,-1,1333,1331,1309,-1,1389,1415,1420,-1,1389,1381,1415,-1,887,769,819,-1,769,887,838,-1,665,890,672,-1,890,665,825,-1,144,363,408,-1,144,115,363,-1,538,522,492,-1,522,538,584,-1,278,155,228,-1,278,313,155,-1,518,714,711,-1,467,714,518,-1,208,308,228,-1,208,283,308,-1,361,304,345,-1,361,368,304,-1,891,1055,951,-1,1055,891,1031,-1,1226,974,1180,-1,974,1226,877,-1,716,803,768,-1,716,722,803,-1,974,863,967,-1,815,863,974,-1,677,602,662,-1,815,602,677,-1,1195,1281,1346,-1,1281,1195,1213,-1,738,676,748,-1,736,676,738,-1,1220,487,556,-1,1220,1198,487,-1,630,727,588,-1,630,724,727,-1,1283,1147,1353,-1,1283,1143,1147,-1,927,1147,1143,-1,927,981,1147,-1,103,88,69,-1,108,88,103,-1,718,548,729,-1,548,718,477,-1,818,472,1119,-1,818,406,472,-1,363,884,1081,-1,884,363,251,-1,699,1033,1039,-1,1033,699,890,-1,388,160,189,-1,160,388,453,-1,1178,1101,1030,-1,1178,1253,1101,-1,1192,1270,1368,-1,1270,1192,1252,-1,1031,910,1174,-1,1031,805,910,-1,1213,1037,1089,-1,1037,1213,1195,-1,722,777,803,-1,722,733,777,-1,733,748,777,-1,733,738,748,-1,1295,1429,1434,-1,1295,1325,1429,-1,149,32,193,-1,149,73,32,-1,154,73,249,-1,73,154,71,-1,1230,1429,1437,-1,1230,1243,1429,-1,1229,921,1083,-1,1048,921,1229,-1,1437,1348,1230,-1,1437,1397,1348,-1,45,292,301,-1,45,14,292,-1,1249,1306,1409,-1,1249,978,1306,-1,801,328,559,-1,801,165,328,-1,1217,1409,1229,-1,1217,1249,1409,-1,362,186,238,-1,362,125,186,-1,1115,1306,1103,-1,1115,1292,1306,-1,1090,1348,1286,-1,1090,954,1348,-1,1084,646,1097,-1,646,1084,984,-1,133,180,162,-1,180,133,140,-1,58,74,69,-1,53,74,58,-1,484,804,794,-1,454,804,484,-1,471,1048,519,-1,921,1048,471,-1,1032,1293,1194,-1,1164,1293,1032,-1,975,923,565,-1,1087,923,975,-1,1301,1425,1433,-1,1301,1299,1425,-1,659,1239,509,-1,659,1182,1239,-1,1324,1258,1315,-1,1291,1258,1324,-1,1067,872,1151,-1,872,1067,883,-1,580,560,519,-1,580,451,560,-1,664,832,797,-1,664,743,832,-1,1041,690,1214,-1,690,1041,766,-1,133,348,79,-1,133,369,348,-1,861,906,929,-1,800,906,861,-1,167,226,215,-1,167,142,226,-1,1427,1060,1088,-1,1427,1385,1060,-1,423,381,529,-1,423,312,381,-1,498,555,507,-1,555,498,561,-1,413,706,681,-1,470,706,413,-1,1264,497,460,-1,497,1264,1219,-1,380,1241,443,-1,380,1227,1241,-1,837,236,924,-1,837,336,236,-1,174,1058,217,-1,988,1058,174,-1,246,525,669,-1,246,250,525,-1,953,760,607,-1,953,1171,760,-1,246,117,250,-1,246,89,117,-1,723,163,164,-1,735,163,723,-1,924,217,1058,-1,924,236,217,-1,1367,1430,1426,-1,1430,1367,1374,-1,460,1341,1264,-1,460,764,1341,-1,1177,421,405,-1,421,1177,1142,-1,336,413,305,-1,336,470,413,-1,109,69,74,-1,109,103,69,-1,561,626,555,-1,626,561,620,-1,312,389,231,-1,423,389,312,-1,1283,1088,942,-1,1088,1283,1343,-1,1371,1147,1156,-1,1371,1353,1147,-1,1092,1338,1267,-1,1338,1092,1070,-1,821,800,861,-1,789,800,821,-1,79,330,16,-1,348,330,79,-1,521,690,766,-1,426,690,521,-1,1067,1384,1351,-1,1151,1384,1067,-1,1121,991,1014,-1,1009,991,1121,-1,1121,1017,1122,-1,1121,1014,1017,-1,1135,1299,1165,-1,1322,1299,1135,-1,1188,488,742,-1,1188,998,488,-1,1335,975,1265,-1,1335,1087,975,-1,1301,845,920,-1,1301,1318,845,-1,962,339,791,-1,962,540,339,-1,35,212,8,-1,35,219,212,-1,53,25,22,-1,53,58,25,-1,53,174,74,-1,95,174,53,-1,339,31,300,-1,339,202,31,-1,1160,341,984,-1,341,1160,604,-1,1000,862,994,-1,1000,1114,862,-1,678,182,373,-1,678,331,182,-1,940,1292,1115,-1,940,801,1292,-1,4,482,238,-1,4,165,482,-1,1103,447,833,-1,1103,961,447,-1,593,387,401,-1,593,646,387,-1,1249,1141,678,-1,1217,1141,1249,-1,678,978,1249,-1,678,373,978,-1,298,376,365,-1,298,124,376,-1,298,64,124,-1,1394,1429,1243,-1,1394,1434,1429,-1,831,1036,796,-1,1036,831,1046,-1,799,748,739,-1,799,777,748,-1,855,777,799,-1,855,803,777,-1,1226,1393,1235,-1,1226,1410,1393,-1,891,805,1031,-1,891,750,805,-1,1305,1173,1174,-1,1173,1305,1290,-1,1270,1247,1175,-1,1270,1252,1247,-1,890,899,1033,-1,899,890,825,-1,251,808,884,-1,808,251,230,-1,1119,506,1202,-1,1119,472,506,-1,548,361,444,-1,548,477,361,-1,808,1240,884,-1,1240,808,1179,-1,483,307,540,-1,326,307,483,-1,151,103,176,-1,151,108,103,-1,501,838,653,-1,501,769,838,-1,1083,935,1209,-1,1083,921,935,-1,790,1165,680,-1,790,1135,1165,-1,215,392,299,-1,392,215,226,-1,533,805,630,-1,910,805,533,-1,756,766,1041,-1,756,649,766,-1,739,676,684,-1,739,748,676,-1,662,720,677,-1,662,721,720,-1,768,855,817,-1,768,803,855,-1,477,368,361,-1,477,467,368,-1,472,208,506,-1,472,283,208,-1,388,492,522,-1,388,313,492,-1,672,584,665,-1,672,522,584,-1,115,251,363,-1,115,72,251,-1,708,825,665,-1,825,708,705,-1,1142,1333,1313,-1,1177,1333,1142,-1,1156,981,979,-1,981,1156,1147,-1,1333,1316,1331,-1,1336,1316,1333,-1,819,944,887,-1,819,844,944,-1,573,596,564,-1,573,628,596,-1,623,585,529,-1,623,596,585,-1,645,573,541,-1,645,605,573,-1,635,561,498,-1,605,561,635,-1,871,507,555,-1,871,606,507,-1,148,106,177,-1,66,106,148,-1,150,432,405,-1,150,209,432,-1,1130,1309,1300,-1,1309,1130,1065,-1,977,976,958,-1,976,977,980,-1,1285,1250,1307,-1,1285,1218,1250,-1,1245,1109,1130,-1,1245,1171,1109,-1,707,425,390,-1,707,709,425,-1,824,637,575,-1,824,879,637,-1,824,697,780,-1,824,575,697,-1,589,664,649,-1,589,743,664,-1,798,1070,660,-1,1070,798,1117,-1,369,847,348,-1,369,840,847,-1,1427,1371,1399,-1,1427,1417,1371,-1,1412,1399,1380,-1,1399,1412,1385,-1,1005,1328,1339,-1,1005,1035,1328,-1,1005,1024,1035,-1,1073,883,1067,-1,1073,959,883,-1,1369,1407,1411,-1,1369,1207,1407,-1,1182,1369,1239,-1,1182,1256,1369,-1,79,140,133,-1,79,40,140,-1,581,414,375,-1,414,581,587,-1,560,633,969,-1,633,560,536,-1,332,771,659,-1,332,488,771,-1,430,488,332,-1,1054,991,742,-1,1019,991,1054,-1,814,401,845,-1,401,814,344,-1,1013,1342,1325,-1,1342,1013,926,-1,1051,951,1055,-1,1051,968,951,-1,684,674,625,-1,684,676,674,-1,870,631,782,-1,625,631,870,-1,646,908,1097,-1,646,593,908,-1,968,702,701,-1,968,1006,702,-1,1201,1128,1052,-1,1201,1179,1128,-1,599,782,631,-1,572,782,599,-1,599,548,444,-1,627,548,599,-1,1119,1360,1269,-1,1119,1202,1360,-1,1128,808,657,-1,1179,808,1128,-1,899,1079,1033,-1,1079,899,960,-1,1325,1074,1013,-1,1074,1325,1295,-1,257,400,395,-1,257,360,400,-1,146,552,358,-1,146,196,552,-1,990,829,1003,-1,990,839,829,-1,810,806,839,-1,806,810,784,-1,360,197,364,-1,360,257,197,-1,465,364,385,-1,364,465,428,-1,784,786,806,-1,784,767,786,-1,688,465,491,-1,688,701,465,-1,1049,846,1102,-1,846,1049,867,-1,1102,773,622,-1,1102,1094,773,-1,666,1004,424,-1,666,1106,1004,-1,62,86,99,-1,51,86,62,-1,500,850,252,-1,858,850,500,-1,1153,1129,1246,-1,1129,1153,1111,-1,19,11,36,-1,19,37,11,-1,54,11,21,-1,5,11,54,-1,429,811,550,-1,411,811,429,-1,118,18,92,-1,57,18,118,-1,378,842,321,-1,378,911,842,-1,126,281,65,-1,126,303,281,-1,489,912,352,-1,489,866,912,-1,643,916,1038,-1,776,916,643,-1,914,686,848,-1,781,686,914,-1,781,642,686,-1,613,591,537,-1,613,551,591,-1,731,442,730,-1,731,880,442,-1,692,1045,707,-1,692,1080,1045,-1,461,194,503,-1,461,277,194,-1,277,456,303,-1,461,456,277,-1,520,372,594,-1,315,372,520,-1,85,153,159,-1,85,119,153,-1,1228,907,1154,-1,1002,907,1228,-1,1282,1350,1296,-1,1350,1282,1330,-1,881,550,811,-1,550,881,569,-1,823,816,793,-1,816,823,878,-1,918,897,1008,-1,822,897,918,-1,809,822,859,-1,809,853,822,-1,303,457,281,-1,456,457,303,-1,372,616,594,-1,372,318,616,-1,60,119,85,-1,60,101,119,-1,33,10,67,-1,33,49,10,-1,457,542,455,-1,494,542,457,-1,101,260,104,-1,101,232,260,-1,546,775,761,-1,546,612,775,-1,1076,1294,1025,-1,1294,1076,1323,-1,895,901,938,-1,895,851,901,-1,1279,1159,1203,-1,1132,1159,1279,-1,714,917,711,-1,714,966,917,-1,1186,1026,963,-1,1026,1186,1126,-1,718,966,714,-1,718,956,966,-1,568,480,412,-1,568,608,480,-1,608,694,577,-1,608,689,694,-1,717,763,694,-1,717,720,763,-1,849,909,936,-1,909,849,807,-1,911,874,854,-1,911,866,874,-1,911,912,866,-1,468,741,700,-1,502,741,468,-1,592,76,120,-1,622,76,592,-1,306,875,224,-1,306,772,875,-1,532,582,909,-1,532,394,582,-1,563,200,213,-1,547,200,563,-1,289,156,82,-1,293,156,289,-1,289,504,293,-1,504,289,455,-1,1350,1334,1366,-1,1350,1330,1334,-1,1093,990,1003,-1,990,1093,1078,-1,925,291,1025,-1,233,291,925,-1,1232,629,785,-1,629,1232,1211,-1,705,539,704,-1,539,705,612,-1,169,245,68,-1,169,185,245,-1,532,402,265,-1,402,532,632,-1,403,225,351,-1,403,235,225,-1,663,722,656,-1,722,663,733,-1,695,733,663,-1,733,695,738,-1,7,143,2,-1,110,143,7,-1,1405,1289,1244,-1,1405,1364,1289,-1,1364,1365,1284,-1,1364,1405,1365,-1,7,199,0,-1,199,7,201,-1,514,207,338,-1,514,379,207,-1,87,0,199,-1,0,87,39,-1,1144,1390,1136,-1,1423,1390,1144,-1,131,191,27,-1,459,191,131,-1,1110,667,892,-1,667,1110,1273,-1,1021,1049,592,-1,1049,1021,1050,-1,1387,1144,1146,-1,1387,1423,1144,-1,325,152,349,-1,152,325,205,-1,87,349,152,-1,349,87,511,-1,795,355,340,-1,795,452,355,-1,1257,1304,1276,-1,1257,1298,1304,-1,1362,1372,1366,-1,1362,1383,1372,-1,636,945,647,-1,636,982,945,-1,23,173,102,-1,23,76,173,-1,458,296,166,-1,458,619,296,-1,868,567,557,-1,868,1082,567,-1,198,62,99,-1,198,248,62,-1,562,776,643,-1,746,776,562,-1,755,393,223,-1,755,675,393,-1,1091,1304,1358,-1,1304,1091,1068,-1,534,578,503,-1,534,640,578,-1,1212,1271,1224,-1,1296,1271,1212,-1,378,9,352,-1,50,9,378,-1,1056,1008,897,-1,1008,1056,1125,-1,881,934,1043,-1,881,878,934,-1,706,1027,681,-1,706,964,1027,-1,232,1029,260,-1,1002,1029,232,-1,78,634,83,-1,638,634,78,-1,1197,601,510,-1,1100,601,1197,-1,407,1262,1223,-1,407,446,1262,-1,1064,333,479,-1,333,1064,1176,-1,691,478,826,-1,269,478,691,-1,913,1191,772,-1,1191,913,1199,-1,964,719,682,-1,964,706,719,-1,179,1059,995,-1,1059,179,203,-1,907,168,972,-1,907,220,168,-1,1261,1326,1334,-1,1254,1326,1261,-1,1223,1362,1326,-1,1223,1262,1362,-1,1181,1010,1047,-1,1181,1190,1010,-1,489,504,757,-1,489,293,504,-1,82,20,65,-1,20,82,97,-1,859,1008,1047,-1,859,918,1008,-1,614,583,535,-1,654,583,614,-1,1038,1007,1172,-1,1007,1038,916,-1,566,370,288,-1,566,554,370,-1,181,111,122,-1,181,146,111,-1,210,783,922,-1,783,210,261,-1,12,137,3,-1,139,137,12,-1,531,463,873,-1,531,353,463,-1,145,417,239,-1,145,274,417,-1,902,952,939,-1,379,952,902,-1,379,514,952,-1,900,1234,1129,-1,1234,900,1098,-1,1431,1379,1413,-1,1402,1379,1431,-1,1416,1391,1413,-1,1416,1395,1391,-1,1251,1077,1196,-1,1077,1251,1311,-1,856,751,679,-1,1061,751,856,-1,1432,1107,1255,-1,1432,1349,1107,-1,1071,751,1061,-1,511,751,1071,-1,505,276,834,-1,505,98,276,-1,1053,939,952,-1,1053,946,939,-1,495,1095,544,-1,495,508,1095,-1,274,129,611,-1,145,129,274,-1,324,450,439,-1,324,490,450,-1,214,894,415,-1,214,474,894,-1,438,700,641,-1,438,468,700,-1,641,412,438,-1,568,412,641,-1,44,259,213,-1,259,44,100,-1,693,687,553,-1,687,693,715,-1,340,416,528,-1,340,371,416,-1,334,257,404,-1,257,334,184,-1,1277,1057,1259,-1,1277,999,1057,-1,400,740,395,-1,400,546,740,-1,552,1076,358,-1,552,1184,1076,-1,963,617,319,-1,617,963,1026,-1,888,718,729,-1,888,956,718,-1,1232,1344,1211,-1,1232,1356,1344,-1,1379,1372,1413,-1,1379,1327,1372,-1,1189,1261,1287,-1,1189,1155,1261,-1,618,600,788,-1,618,542,600,-1,169,34,147,-1,34,169,68,-1,727,807,849,-1,724,807,727,-1,941,224,875,-1,243,224,941,-1,765,738,695,-1,765,736,738,-1,158,235,91,-1,158,225,235,-1,836,763,779,-1,836,621,763,-1,577,464,466,-1,577,621,464,-1,656,716,689,-1,722,716,656,-1,464,213,259,-1,464,563,213,-1,382,553,491,-1,382,402,553,-1,1133,1078,1093,-1,1069,1078,1133,-1,1069,1159,987,-1,1133,1159,1069,-1,917,938,901,-1,917,987,938,-1,1025,1236,925,-1,1236,1025,1294,-1,775,712,851,-1,708,712,775,-1,1277,1232,1152,-1,1356,1232,1277,-1,105,203,49,-1,105,333,203,-1,673,549,616,-1,673,600,549,-1,24,55,15,-1,55,24,56,-1,128,104,123,-1,107,104,128,-1,462,549,494,-1,486,549,462,-1,835,874,757,-1,874,835,853,-1,809,823,854,-1,809,770,823,-1,934,802,1010,-1,934,770,802,-1,1282,1029,1288,-1,1282,1012,1029,-1,995,1274,1248,-1,995,1059,1274,-1,263,56,271,-1,263,55,56,-1,138,107,128,-1,130,107,138,-1,476,486,462,-1,515,486,476,-1,578,515,476,-1,614,515,578,-1,187,138,161,-1,187,130,138,-1,683,1034,1139,-1,683,710,1034,-1,723,1248,1274,-1,671,1248,723,-1,728,263,725,-1,728,346,263,-1,393,642,320,-1,642,393,686,-1,537,1091,1105,-1,591,1091,537,-1,57,126,38,-1,118,126,57,-1,81,54,171,-1,81,92,54,-1,1077,475,554,-1,1077,868,475,-1,93,323,36,-1,429,323,93,-1,188,242,288,-1,188,75,242,-1,1157,1007,1020,-1,1007,1157,1172,-1,1062,1157,1020,-1,1153,1157,1062,-1,1111,952,930,-1,1111,1053,952,-1,239,759,666,-1,239,417,759,-1,322,377,419,-1,322,172,377,-1,3,145,12,-1,145,3,129,-1,110,0,98,-1,7,0,110,-1,141,205,275,-1,141,152,205,-1,266,385,264,-1,266,382,385,-1,765,734,736,-1,765,767,734,-1,481,229,218,-1,481,493,229,-1,428,703,473,-1,702,703,428,-1,427,829,655,-1,427,469,829,-1,810,729,732,-1,729,810,888,-1,170,617,469,-1,617,170,319,-1,785,420,576,-1,785,309,420,-1,704,473,703,-1,539,473,704,-1,819,931,1120,-1,819,769,931,-1,1081,1378,1145,-1,1378,1081,1324,-1,431,971,572,-1,431,818,971,-1,732,658,737,-1,627,658,732,-1,1233,971,1269,-1,1233,1028,971,-1,960,1075,1079,-1,1006,1075,960,-1,1075,1175,1238,-1,1175,1075,1051,-1,590,1052,905,-1,595,1052,590,-1,737,674,734,-1,737,658,674,-1,870,1001,950,-1,804,1001,870,-1,1175,1290,1270,-1,1290,1175,1173,-1,344,595,590,-1,343,595,344,-1,154,680,237,-1,154,790,680,-1,742,1237,1188,-1,1237,742,1009,-1,1376,1256,1182,-1,1376,1384,1256,-1,652,332,272,-1,652,774,332,-1,536,509,633,-1,272,509,536,-1,280,192,285,-1,180,192,280,-1,426,587,690,-1,587,426,414,-1,1400,1418,1428,-1,1400,1424,1418,-1,1170,1345,1314,-1,1242,1345,1170,-1,1242,1354,1345,-1,828,648,1124,-1,648,828,645,-1,541,1088,1060,-1,541,527,1088,-1,649,521,766,-1,649,664,521,-1,696,524,660,-1,696,575,524,-1,637,589,524,-1,589,637,743,-1,1245,760,1171,-1,1245,988,760,-1,1086,730,728,-1,1023,730,1086,-1,356,681,692,-1,413,681,356,-1,1300,1245,1130,-1,1280,1245,1300,-1,919,844,886,-1,844,919,944,-1,1285,1331,1316,-1,1285,1307,1331,-1,84,380,116,-1,258,380,84,-1,150,108,151,-1,157,108,150,-1,247,148,177,-1,247,267,148,-1,579,433,389,-1,639,433,579,-1,628,639,579,-1,639,628,635,-1,574,685,942,-1,574,564,685,-1,937,980,979,-1,937,976,980,-1,1120,1309,1065,-1,1313,1309,1120,-1,1381,1377,1415,-1,1381,1352,1377,-1,838,937,896,-1,838,887,937,-1,1377,1204,1219,-1,1377,1336,1204,-1,699,672,890,-1,699,453,672,-1,155,115,144,-1,94,115,155,-1,713,584,538,-1,713,712,584,-1,538,711,713,-1,711,538,518,-1,345,308,406,-1,345,304,308,-1,1031,1173,1055,-1,1174,1173,1031,-1,717,768,749,-1,717,716,768,-1,815,749,863,-1,677,749,815,-1,588,721,662,-1,727,721,588,-1,284,955,526,-1,284,862,955,-1,1158,950,1001,-1,1158,965,950,-1,326,375,285,-1,326,383,375,-1,1340,1122,1351,-1,1122,1340,1121,-1,1113,1386,1320,-1,1113,957,1386,-1,877,496,602,-1,889,496,877,-1,362,357,125,-1,357,362,571,-1,896,927,820,-1,927,896,981,-1,106,69,88,-1,106,58,69,-1,72,230,251,-1,96,230,72,-1,699,864,287,-1,1039,864,699,-1,431,406,818,-1,431,345,406,-1,1081,408,363,-1,1081,1145,408,-1,657,287,864,-1,657,206,287,-1,287,453,699,-1,453,287,160,-1,1101,908,1030,-1,908,1101,1015,-1,1097,1192,1368,-1,1097,1066,1192,-1,750,724,630,-1,715,724,750,-1,1174,1200,1305,-1,1040,1200,1174,-1,1168,1089,1022,-1,1089,1168,1216,-1,1168,965,1158,-1,1168,997,965,-1,994,1103,1000,-1,994,1115,1103,-1,1243,1083,1394,-1,1243,754,1083,-1,1409,1292,1185,-1,1409,1306,1292,-1,1230,754,1243,-1,1230,752,754,-1,1229,1185,1048,-1,1229,1409,1185,-1,292,604,926,-1,290,604,292,-1,182,238,186,-1,182,4,238,-1,1000,1090,1114,-1,833,1090,1000,-1,833,365,954,-1,365,833,447,-1,63,48,64,-1,63,32,48,-1,25,31,43,-1,31,25,8,-1,397,840,369,-1,397,797,840,-1,140,43,202,-1,140,40,43,-1,794,870,782,-1,804,870,794,-1,280,162,180,-1,280,268,162,-1,1194,1408,1321,-1,1293,1408,1194,-1,565,1112,830,-1,565,923,1112,-1,1408,1299,1322,-1,1408,1425,1299,-1,357,796,249,-1,357,831,796,-1,973,1118,1046,-1,1019,1118,973,-1,1207,1104,1407,-1,1104,1207,882,-1,1117,1214,1396,-1,1214,1117,1041,-1,162,369,133,-1,162,397,369,-1,1109,852,876,-1,953,852,1109,-1,929,1138,1242,-1,906,1138,929,-1,231,215,312,-1,231,167,215,-1,167,255,177,-1,231,255,167,-1,620,1024,626,-1,1024,620,828,-1,685,820,927,-1,685,623,820,-1,433,507,267,-1,507,433,498,-1,236,109,217,-1,236,183,109,-1,305,176,183,-1,305,286,176,-1,299,931,501,-1,931,299,392,-1,1219,432,497,-1,432,1219,1204,-1,381,501,653,-1,381,299,501,-1,1072,525,558,-1,525,1072,1150,-1,758,336,837,-1,758,470,336,-1,556,246,669,-1,175,246,556,-1,669,1150,1134,-1,1150,669,525,-1,116,89,84,-1,89,116,117,-1,719,470,758,-1,706,470,719,-1,1401,1134,1150,-1,1134,1401,1406,-1,764,1359,1341,-1,764,787,1359,-1,405,1204,1177,-1,405,432,1204,-1,356,254,286,-1,254,356,311,-1,109,176,103,-1,109,183,176,-1,74,217,109,-1,174,217,74,-1,433,255,389,-1,247,255,433,-1,927,942,685,-1,942,927,1143,-1,1417,1353,1371,-1,1417,1343,1353,-1,423,579,389,-1,579,423,517,-1,852,821,876,-1,852,789,821,-1,426,397,268,-1,426,521,397,-1,1376,1237,1340,-1,1188,1237,1376,-1,831,571,893,-1,357,571,831,-1,992,1275,1054,-1,992,1321,1275,-1,1265,1414,1335,-1,1414,1265,1363,-1,202,540,307,-1,202,339,540,-1,66,8,25,-1,66,35,8,-1,43,22,25,-1,40,22,43,-1,1164,993,744,-1,1164,1032,993,-1,292,48,290,-1,48,292,14,-1,401,440,845,-1,401,387,440,-1,752,570,754,-1,752,376,570,-1,331,4,182,-1,90,4,331,-1,752,365,376,-1,752,954,365,-1,1160,926,604,-1,926,1160,1342,-1,519,383,471,-1,530,383,519,-1,342,993,898,-1,948,993,342,-1,1308,1164,827,-1,1308,1293,1164,-1,985,1115,994,-1,1115,985,940,-1,526,1225,1016,-1,1225,526,955,-1,739,997,799,-1,997,739,965,-1,1022,799,997,-1,1022,855,799,-1,1180,1392,1226,-1,1180,1337,1392,-1,687,750,891,-1,687,715,750,-1,1015,1097,908,-1,1097,1015,1066,-1,1247,1238,1175,-1,1238,1247,1310,-1,899,705,704,-1,899,825,705,-1,808,206,657,-1,808,230,206,-1,1145,506,408,-1,1145,1202,506,-1,444,345,431,-1,444,361,345,-1,94,72,115,-1,72,94,70,-1,176,254,151,-1,254,176,286,-1,838,820,653,-1,820,838,896,-1,1403,1270,1290,-1,1403,1368,1270,-1,857,910,533,-1,910,857,1040,-1,556,1134,1220,-1,1134,556,669,-1,1363,845,1318,-1,1363,814,845,-1,684,965,739,-1,684,950,965,-1,564,541,573,-1,574,541,564,-1,574,527,541,-1,533,588,496,-1,533,630,588,-1,677,717,749,-1,720,717,677,-1,749,817,863,-1,817,749,768,-1,949,855,1022,-1,817,855,949,-1,467,718,714,-1,718,467,477,-1,406,283,472,-1,406,308,283,-1,278,368,448,-1,278,304,368,-1,492,518,538,-1,518,492,448,-1,208,408,506,-1,208,144,408,-1,712,665,584,-1,712,708,665,-1,206,160,287,-1,206,70,160,-1,1177,1336,1333,-1,1204,1336,1177,-1,896,979,981,-1,896,937,979,-1,1426,1401,1367,-1,1398,1401,1426,-1,1316,1377,1352,-1,1377,1316,1336,-1,819,1065,844,-1,1120,1065,819,-1,979,1148,1156,-1,979,980,1148,-1,585,628,579,-1,585,596,628,-1,529,517,423,-1,529,585,517,-1,620,605,645,-1,620,561,605,-1,405,157,150,-1,421,157,405,-1,164,443,195,-1,443,164,380,-1,1285,1352,1278,-1,1352,1285,1316,-1,1065,886,844,-1,1065,1130,886,-1,980,1170,1148,-1,980,977,1170,-1,1242,977,929,-1,977,1242,1170,-1,876,1130,1109,-1,876,886,1130,-1,390,692,707,-1,356,692,390,-1,1023,731,730,-1,558,731,1023,-1,847,824,903,-1,847,879,824,-1,756,524,589,-1,756,660,524,-1,798,660,756,-1,521,797,397,-1,521,664,797,-1,527,942,1088,-1,942,527,574,-1,1156,1302,1371,-1,1302,1156,1148,-1,648,1060,1124,-1,1060,648,541,-1,1419,1314,1345,-1,1419,1380,1314,-1,626,1005,885,-1,626,1024,1005,-1,1424,1382,1418,-1,1424,1435,1382,-1,426,280,414,-1,426,268,280,-1,280,375,414,-1,280,285,375,-1,1351,1376,1340,-1,1351,1384,1376,-1,430,774,992,-1,774,430,332,-1,920,237,680,-1,920,440,237,-1,1437,1325,1342,-1,1437,1429,1325,-1,968,688,951,-1,688,968,701,-1,625,658,631,-1,674,658,625,-1,1075,968,1051,-1,1075,1006,968,-1,1238,1079,1075,-1,1079,1238,1178,-1,729,627,732,-1,729,548,627,-1,818,1269,971,-1,818,1119,1269,-1,1033,1178,1039,-1,1178,1033,1079,-1,359,110,418,-1,359,143,110,-1,360,539,400,-1,360,473,539,-1,59,358,291,-1,59,111,358,-1,469,1003,829,-1,1003,469,617,-1,784,732,737,-1,784,810,732,-1,469,204,170,-1,204,469,427,-1,364,473,360,-1,364,428,473,-1,264,364,197,-1,264,385,364,-1,384,846,513,-1,384,843,846,-1,767,737,734,-1,737,767,784,-1,434,586,502,-1,434,636,586,-1,147,264,169,-1,147,266,264,-1,843,1102,846,-1,843,1094,1102,-1,98,418,110,-1,98,505,418,-1,449,545,253,-1,449,485,545,-1,753,1284,1208,-1,651,1284,753,-1,198,698,248,-1,198,422,698,-1,615,1106,783,-1,943,1106,615,-1,943,1004,1106,-1,778,869,458,-1,778,904,869,-1,1020,858,1062,-1,1020,850,858,-1,1298,1358,1304,-1,1395,1358,1298,-1,21,37,13,-1,11,37,21,-1,171,21,132,-1,171,54,21,-1,554,367,370,-1,367,554,475,-1,92,277,118,-1,92,194,277,-1,194,92,81,-1,57,227,18,-1,57,26,227,-1,38,26,57,-1,38,50,26,-1,65,9,38,-1,65,20,9,-1,591,1068,1091,-1,598,1068,591,-1,366,642,781,-1,366,320,642,-1,776,848,792,-1,848,776,746,-1,745,613,661,-1,613,745,865,-1,812,613,865,-1,551,613,812,-1,187,407,510,-1,187,161,407,-1,730,346,728,-1,730,442,346,-1,337,178,315,-1,269,178,337,-1,187,153,130,-1,221,153,187,-1,462,461,476,-1,462,456,461,-1,128,315,138,-1,128,372,315,-1,1002,1288,1029,-1,1288,1002,1228,-1,1327,1268,1260,-1,1327,1379,1268,-1,1043,569,881,-1,569,1043,915,-1,878,770,934,-1,878,823,770,-1,842,854,823,-1,842,911,854,-1,757,866,489,-1,866,757,874,-1,456,494,457,-1,462,494,456,-1,119,104,107,-1,119,101,104,-1,455,281,457,-1,455,289,281,-1,104,295,123,-1,104,260,295,-1,612,708,775,-1,612,705,708,-1,1323,1279,1294,-1,1323,1332,1279,-1,851,713,901,-1,713,851,712,-1,711,901,713,-1,711,917,901,-1,1126,1093,1026,-1,1133,1093,1126,-1,687,491,553,-1,687,688,491,-1,689,717,694,-1,717,689,716,-1,694,621,577,-1,694,763,621,-1,721,849,779,-1,721,727,849,-1,765,700,741,-1,700,765,695,-1,675,686,393,-1,792,686,675,-1,1329,1176,1064,-1,1329,1361,1176,-1,936,563,836,-1,936,547,563,-1,1082,1077,1311,-1,1082,868,1077,-1,504,542,618,-1,504,455,542,-1,1366,1327,1350,-1,1327,1366,1372,-1,1211,1375,1184,-1,1211,1344,1375,-1,576,740,1152,-1,576,395,740,-1,1026,1003,617,-1,1003,1026,1093,-1,1025,358,1076,-1,291,358,1025,-1,1152,785,576,-1,785,1152,1232,-1,999,1152,740,-1,999,1277,1152,-1,528,334,404,-1,528,416,334,-1,190,169,264,-1,169,190,185,-1,266,134,265,-1,266,147,134,-1,632,553,402,-1,553,632,693,-1,41,213,200,-1,213,41,28,-1,663,568,641,-1,656,568,663,-1,695,641,700,-1,663,641,695,-1,398,567,644,-1,398,386,567,-1,7,42,201,-1,2,42,7,-1,199,511,87,-1,199,751,511,-1,459,762,191,-1,1063,762,459,-1,327,191,762,-1,327,216,191,-1,1050,867,1049,-1,867,1050,795,-1,947,1432,1196,-1,1432,947,1273,-1,135,490,324,-1,490,135,667,-1,1255,762,1063,-1,762,1255,1107,-1,610,441,439,-1,441,610,325,-1,1404,1098,1116,-1,1234,1098,1404,-1,598,1038,1068,-1,643,1038,598,-1,1391,1298,1234,-1,1395,1298,1391,-1,586,647,655,-1,586,636,647,-1,1098,481,650,-1,481,1098,900,-1,592,137,512,-1,120,137,592,-1,463,102,173,-1,353,102,463,-1,943,248,698,-1,248,943,437,-1,139,302,273,-1,139,112,302,-1,410,317,316,-1,317,410,396,-1,436,317,396,-1,436,422,317,-1,51,370,86,-1,51,288,370,-1,297,747,745,-1,347,747,297,-1,223,320,46,-1,223,393,320,-1,1068,1276,1304,-1,1276,1068,1038,-1,583,337,535,-1,583,478,337,-1,297,503,194,-1,297,534,503,-1,1224,1205,1125,-1,1271,1205,1224,-1,1181,1271,1260,-1,1181,1205,1271,-1,411,816,811,-1,411,609,816,-1,618,757,504,-1,835,757,618,-1,1043,1010,1163,-1,1043,934,1010,-1,1326,1197,1223,-1,1197,1326,1254,-1,1261,1131,1254,-1,1131,1261,1155,-1,499,1137,932,-1,499,1042,1137,-1,1002,220,907,-1,1002,232,220,-1,932,1056,788,-1,1137,1056,932,-1,913,350,880,-1,913,294,350,-1,1100,682,601,-1,964,682,1100,-1,1191,875,772,-1,1191,1263,875,-1,294,772,306,-1,294,913,772,-1],
          coord=Coordinate(DEF='c5_Coord',point=[(0,53.82202,-1.76814),(-.12786,53.76951,-1.82154),(-.06137,53.82115,-1.75411),(-.08286,53.41889,-2.27255),(-.04873,53.41271,-2.19331),(-.07927,53.39055,-2.24244),(-.11143,53.39068,-2.31553),(-.1141,53.3685,-2.28827),(-.14578,53.31215,-2.35443),(-.19636,53.42911,-2.29284),(-.20165,53.35865,-2.31984),(-.1703,53.36728,-2.27368),(-.39331,53.86847,-1.41602),(-.38895,53.86957,-1.40898),(-.33645,53.85249,-1.49252),(-.18802,53.29708,-2.33971),(-.16601,53.28234,-2.31909),(-.16967,53.28137,-2.31577),(-.19295,53.29934,-2.33048),(-.11456,53.33898,-2.18953),(-.11727,53.3396,-2.18899),(-.13675,53.32764,-2.24788),(-.13166,53.3707,-2.03615),(-.13447,53.372,-2.03761),(-.1115,53.33491,-2.12926),(-.39925,53.43061,-1.59222),(-.40039,53.54354,-1.58035),(-.35008,53.54131,-1.64526),(-.15501,53.60473,-1.72153),(-.18938,53.51729,-1.74443),(-.11624,53.5213,-1.81352),(-.8711,53.5544,-1.2363),(-.87101,53.55887,-1.23886),(-.91568,53.50623,-1.29032),(-.44296,53.44075,-1.44379),(-.44746,53.43586,-1.44524),(-.4411,53.43844,-1.44744),(-.87021,53.56177,-1.23459),(-.76994,53.76449,-1.40872),(-.76463,53.77596,-1.41509),(-.76791,53.76269,-1.41461),(-.46941,53.84153,-1.38102),(-.54377,53.82169,-1.39125),(-.56967,53.87369,-1.32172),(-.91011,53.46552,-1.0376),(-.91371,53.45016,-1.00778),(-.98407,53.49584,-1.0115),(-.83985,53.69188,-1.17363),(-.76688,53.63233,-1.16361),(-.78839,53.60219,-1.11407),(-.84563,53.50541,-1.06692),(-.84143,53.54998,-1.08749),(-.69549,53.55652,-1.06593),(-.76556,53.41705,-.93737),(-.77379,53.4271,-.93291),(-.76832,53.41696,-.94048),(-.74822,53.41197,-1.04821),(-.77785,53.40243,-.99959),(-.86081,53.42675,-1.01835),(-.70473,53.39801,-.92386),(-.72077,53.39575,-.95967),(-.69299,53.40241,-.96685),(-.78263,53.85071,-1.07101),(-.77722,53.86683,-1.06404),(-.82341,53.94666,-1.06099),(-.91961,53.65889,-.98848),(-.97315,53.57491,-.9677),(-.91406,53.65139,-.97874),(-.80532,53.76443,-1.06361),(-.81271,53.77835,-1.07104),(-.83815,53.71308,-1.04501),(-.75128,53.63351,-.77925),(-.74635,53.53984,-.82364),(-.75007,53.62903,-.76958),(-.76951,53.84924,-1.06622),(-.78297,53.4591,-.92671),(-.77085,53.46268,-.90582),(-.77331,53.47409,-.90549),(-.71902,53.68152,-.74735),(-.68119,53.63396,-.7144),(-.65973,53.71424,-.72283),(-.56627,53.69607,-1.10756),(-.50634,53.73443,-1.1248),(-.58099,53.73474,-1.11063),(-.43788,53.77051,-1.11354),(-.39256,53.80573,-1.14105),(-.42144,53.78056,-1.17648),(-.4619,53.90598,-1.1916),(-.50687,53.87216,-1.15403),(-.51256,53.79211,-1.1646),(-.37329,53.74569,-1.22187),(-.41256,53.74584,-1.22692),(-.45171,53.7863,-1.18542),(-.40945,53.90757,-1.31026),(-.43256,53.94493,-1.25071),(-.42736,53.90136,-1.24839),(-.43337,53.82995,-1.24253),(-.43792,53.7759,-1.23809),(-.42757,53.72432,-1.27449),(-.38227,53.47528,-.894),(-.41278,53.47489,-.92652),(-.37273,53.43765,-.94311),(-.57357,53.5035,-.85942),(-.65335,53.47577,-.83905),(-.63646,53.43353,-.88542),(-.65586,53.58668,-.92095),(-.65631,53.53939,-.92789),(-.64285,53.5367,-.99842),(-.58098,53.56186,-1.03428),(-.581,53.56654,-1.03062),(-.61258,53.55131,-1.01432),(-.56665,53.48412,-.88781),(-.56665,53.48655,-.89199),(-.50411,53.50115,-.9201),(-.49167,53.5352,-1.03039),(-.48045,53.52986,-.96954),(-.49315,53.54432,-1.02407),(-.53475,53.56719,-1.04291),(-.5397,53.56123,-1.04771),(-.49979,53.4972,-.91831),(-.43886,53.48472,-.96239),(-.66325,53.57934,-1.00412),(-.68888,53.5851,-1.02685),(-.69582,53.57888,-1.01875),(-.64801,53.527,-1.01454),(-.67544,53.46827,-.9884),(-.69608,53.46056,-1.03478),(-.58341,53.56376,-1.0414),(-.58044,53.56521,-1.05143),(-.55844,53.56101,-1.07391),(-.70127,53.59869,-1.05577),(-.69527,53.5957,-1.06142),(-.67953,53.63669,-1.08001),(-.59623,53.66915,-1.0967),(-.59007,53.67944,-1.0987),(-.63221,53.6857,-1.09841),(-.67973,53.58969,-1.08566),(-.69251,53.56706,-1.06262),(-.49982,53.57825,-.92031),(-.48624,53.58779,-.97595),(-.59571,53.7734,-1.1137),(-.6057,53.84227,-1.09404),(-.68146,53.83675,-1.06852),(-.71129,53.66971,-1.08182),(-.63907,53.73196,-1.10128),(-.80357,53.77944,-1.06419),(-.61416,53.62355,-1.02238),(-.65635,53.59337,-1.01451),(-.68509,53.64733,-1.08004),(-.71575,53.58485,-1.04447),(-.48229,53.74154,-1.01967),(-.56096,53.68843,-1.04382),(-.55356,53.65473,-1.03936),(-.62528,53.62534,-1.02397),(-.49373,53.5419,-1.16718),(-.47965,53.52643,-1.14995),(-.52076,53.54171,-1.10475),(-.37498,53.39404,-1.15261),(-.3756,53.39349,-1.03515),(-.38456,53.39896,-1.15212),(-.29718,53.37563,-1.28089),(-.29666,53.36994,-1.27553),(-.30674,53.37789,-1.27716),(-.234,53.74684,-.84071),(-.22525,53.74127,-.84191),(-.22115,53.77663,-.92511),(-.40718,53.70589,-1.24602),(-.35806,53.5096,-1.49957),(-.33963,53.58503,-1.50039),(-.39038,53.66177,-1.38836),(-.53754,53.56,-1.21874),(-.63878,53.58674,-1.21681),(-.54287,53.56463,-1.25822),(-.62901,53.58155,-1.10999),(-.69914,53.60147,-1.15355),(-.62958,53.57888,-1.15109),(-.41528,53.44554,-1.20215),(-.37231,53.44782,-1.23569),(-.37035,53.40207,-1.22319),(-.35237,53.34352,-.92879),(-.34674,53.32371,-.88504),(-.35552,53.40125,-.89784),(-.35587,53.35679,-.94409),(-.41056,53.464,-1.02947),(-.38284,53.40067,-1.03331),(-.33728,53.2835,-.88119),(-.26309,53.27578,-.92061),(-.25313,53.24362,-.88283),(-.46102,53.38649,-1.57165),(-.42031,53.43039,-1.53094),(-.48657,53.37804,-1.525),(-.49052,53.57951,-1.25985),(-.45087,53.58072,-1.23716),(-.47868,53.51751,-1.04378),(-.19005,53.27108,-.89973),(-.17517,53.23647,-.84531),(-.19044,53.32223,-.97368),(-.25761,53.30521,-.96929),(-.26688,53.35101,-1.05499),(-.11181,53.34152,-1.27828),(-.11496,53.35716,-1.21968),(-.20144,53.35985,-1.21925),(-.27646,53.36751,-1.22065),(-.36427,53.39576,-1.21776),(-.27363,53.37478,-1.15211),(-.276,53.86907,-.98934),(-.2172,53.81223,-1.0006),(-.21509,53.85813,-1.08336),(-.15854,53.78492,-.99507),(-.07547,53.76929,-.99375),(-.07203,53.80117,-1.10239),(-.16197,53.75919,-.91546),(-.32994,53.90908,-.97837),(-.32752,53.89662,-.88803),(-.27512,53.82808,-.9131),(-.26589,53.78657,-.82213),(-.31619,53.86883,-.80757),(-.37028,53.9292,-.78738),(-.33122,53.86734,-.7065),(-.12546,53.44961,-2.14259),(-.15084,53.5023,-2.00856),(-.14081,53.41841,-1.96784),(-.14239,53.43447,-1.92091),(-.15642,53.4766,-2.22155),(-.13935,53.58472,-2.0226),(-.13287,53.56954,-2.08568),(-.13,53.47398,-2.06982),(-.33893,53.6206,-1.62835),(-.65512,53.38889,-1.46799),(-.65615,53.3323,-1.5324),(-.56067,53.33827,-1.55355),(-.69252,53.50485,-1.32129),(-.76673,53.50864,-1.30146),(-.82721,53.4935,-1.31928),(-.37617,53.4667,-1.54379),(-.39784,53.42924,-1.58978),(-.33583,53.42871,-1.63333),(-.08481,53.59214,-1.77353),(-.05754,53.5112,-1.87389),(-.137,53.4166,-1.96683),(-.04003,53.46401,-1.95477),(-.0421,53.42813,-2.04108),(-.10859,53.3342,-2.12835),(-.07812,53.614,-2.09559),(-.10474,53.70433,-1.92573),(-.16035,53.5956,-1.94031),(-.18228,53.60721,-1.86916),(-.5064,53.75375,-1.46156),(-.49467,53.71418,-1.51059),(-.59221,53.69659,-1.49759),(-.64507,53.75252,-1.45031),(-.6514,53.68857,-1.48625),(-.72539,53.67853,-1.47124),(-.15641,53.69819,-1.85662),(-.06238,53.74344,-1.73724),(-.0681,53.66574,-1.75338),(0,53.65995,-1.78296),(0,53.44627,-2.03341),(0,53.4455,-2.10664),(0,53.54024,-2.1998),(0,53.4773,-2.20334),(-.0577,53.50646,-2.22004),(-.09451,53.65486,-2.01848),(0,53.71472,-1.96947),(-.14035,53.82291,-1.72363),(-.50913,53.76588,-1.45779),(-.68726,53.76927,-1.44781),(-.66288,53.83682,-1.38115),(-.39908,53.87774,-1.40965),(-.46615,53.90741,-1.32217),(-.91784,53.53939,-1.36675),(-.87908,53.5723,-1.43083),(-.90924,53.44833,-1.44543),(-.78792,53.67218,-1.45545),(-.8209,53.59329,-1.48201),(-.85402,53.61476,-1.24939),(-.85316,53.66637,-1.3107),(-.84591,53.77846,-1.30062),(-.81121,53.72191,-1.361),(-.77155,53.61118,-1.18919),(-.69118,53.60049,-1.20069),(-.80696,53.41009,-.97112),(-.86203,53.42016,-.97975),(-.84465,53.62157,-1.10688),(-.83535,53.66255,-1.20367),(-.86944,53.77221,-1.21368),(-.84913,53.73767,-1.25932),(-.92378,53.6456,-1.02047),(-.86506,53.82487,-1.15211),(-.85826,53.90294,-1.17802),(-.82042,54.02045,-1.11883),(-.74465,53.64612,-1.07907),(-.74543,53.56595,-1.03101),(-.72466,53.56419,-.99343),(-.98692,53.56986,-1.01861),(-.91236,53.51981,-1.05128),(-.78016,53.53779,-.98395),(-.80849,53.46954,-.94948),(-.78323,53.47175,-.92556),(-.71415,53.58752,-.88295),(-.70194,53.64691,-.84381),(-.59147,53.74413,-.77965),(-.67012,53.7405,-.74436),(-.69584,53.70126,-.81799),(-.63614,53.66351,-.86789),(-.66496,53.62691,-.9085),(-.31696,53.78423,-1.21857),(-.48319,53.7353,-1.08603),(-.46231,53.82011,-1.00828),(-.45875,53.81613,-.92562),(-.46385,53.73399,-.95244),(-.49267,53.71712,-.88517),(-.45308,53.82309,-.81003),(-.51155,53.70916,-.78931),(-.42417,53.78113,-.77478),(-.27549,53.48448,-.84121),(-.28668,53.43685,-.83538),(-.25709,53.42728,-.80399),(-.24055,53.4683,-.80533),(-.25268,53.52178,-.79458),(-.39371,53.82705,-.72637),(-.42508,53.86657,-.80097),(-.4362,53.88727,-.91103),(-.42188,53.89269,-.99951),(-.31856,53.79936,-.68836),(-.37215,53.78889,-.71916),(-.36536,53.73406,-.72901),(-.24778,53.6643,-.73483),(-.35418,53.67233,-.76237),(-.32346,53.60667,-.79401),(-.22987,53.55908,-.74808),(-.24116,53.6578,-.73415),(.49052,53.57951,-1.25985),(.45087,53.58072,-1.23716),(.41003,53.66698,-1.25762),(.42508,53.86657,-.80097),(.33811,53.86635,-.70335),(.39371,53.82705,-.72637),(.39664,53.95627,-.97139),(.38958,53.95284,-.88133),(.4362,53.88727,-.91103),(.30534,53.84864,-1.20658),(.24279,53.72722,-1.24578),(.23137,53.80291,-1.22002),(.46231,53.82011,-1.00828),(.39256,53.80573,-1.14105),(.39004,53.87934,-1.12314),(.4283,53.8711,-.81457),(.45898,53.8208,-.819),(.35418,53.67233,-.76237),(.32346,53.60667,-.79401),(.40377,53.63624,-.7932),(.27549,53.48448,-.84121),(.29947,53.54558,-.81754),(.25268,53.52178,-.79458),(.24055,53.4683,-.80533),(.25709,53.42728,-.80399),(.32888,53.47988,-.8676),(.32968,53.50737,-.84796),(.49382,53.57386,-.83252),(.49447,53.64451,-.80295),(.53896,53.72793,-.84709),(.49267,53.71712,-.88517),(.48229,53.74154,-1.01967),(.45875,53.81613,-.92562),(.37719,53.70105,-1.23577),(.31696,53.78423,-1.21857),(.37329,53.74569,-1.22187),(.26609,53.61057,-1.26564),(.18253,53.49668,-1.28441),(.17337,53.58838,-1.25814),(.60882,53.64701,-.7545),(.59147,53.74413,-.77965),(.51155,53.70916,-.78931),(.60456,53.70275,-.7514),(.63614,53.66351,-.86789),(.61474,53.71663,-.82401),(.65586,53.58668,-.92095),(.66496,53.62691,-.9085),(.59355,53.74593,-.78557),(.6729,53.74405,-.75496),(.66326,53.72881,-.80055),(.75128,53.63351,-.77925),(.70194,53.64691,-.84381),(.69584,53.70126,-.81799),(.98692,53.56986,-1.01861),(.9146,53.5741,-1.06505),(.92378,53.6456,-1.02047),(.82217,53.57649,-.98418),(.91187,53.65522,-.98155),(.82991,53.71144,-1.04013),(.55153,53.77263,-1.13971),(.53115,53.75263,-1.13701),(.58099,53.73474,-1.11063),(.64592,53.77821,-1.10416),(.63907,53.73196,-1.10128),(.80357,53.77944,-1.06419),(.72728,54.03577,-1.09942),(.70583,53.92016,-1.05579),(.82341,53.94666,-1.06099),(.78263,53.85071,-1.07101),(.86506,53.82487,-1.15211),(.85399,53.67522,-1.07104),(.84064,53.7525,-1.1425),(.81271,53.77835,-1.07104),(.85826,53.90294,-1.17802),(.8755,53.83091,-1.26626),(.85319,53.91442,-1.28002),(.83985,53.69188,-1.17363),(.69549,53.55652,-1.06593),(.67922,53.58514,-1.09291),(.78839,53.60219,-1.11407),(.85402,53.61476,-1.24939),(.85316,53.66637,-1.3107),(.84913,53.73767,-1.25932),(.79129,53.57018,-1.23461),(.87021,53.56177,-1.23459),(.91568,53.50623,-1.29032),(.92947,53.42214,-1.37768),(.91784,53.53939,-1.36675),(.72166,53.88106,-1.34364),(.75877,53.9401,-1.27024),(.84612,53.91985,-1.28278),(.39908,53.87774,-1.40965),(.46941,53.84153,-1.38102),(.4304,53.80317,-1.4558),(.66288,53.83682,-1.38115),(.65004,53.88438,-1.31034),(.46615,53.90741,-1.32217),(.56967,53.87369,-1.32172),(.26104,53.76883,-1.67585),(.20419,53.76112,-1.76449),(.14035,53.82291,-1.72363),(0,53.76693,-1.87148),(.12786,53.76951,-1.82154),(.05754,53.5112,-1.87389),(0,53.48298,-1.94557),(.04003,53.46401,-1.95477),(.21821,53.69458,-1.77329),(.0421,53.42813,-2.04108),(.13166,53.3707,-2.03615),(.137,53.4166,-1.96683),(.13515,53.4319,-1.9182),(.17492,53.43321,-1.8607),(.11624,53.5213,-1.81352),(.18938,53.51729,-1.74443),(.24103,53.51804,-1.67666),(.23703,53.59586,-1.65115),(.54287,53.56463,-1.25822),(.46216,53.58164,-1.34391),(.48867,53.49802,-1.36504),(.60932,53.49085,-1.35429),(.49297,53.49265,-1.36732),(.55139,53.45994,-1.39302),(.54139,53.40152,-1.46981),(.59001,53.38495,-1.47767),(.52421,53.43001,-1.4331),(.13056,53.42983,-2.31765),(.13679,53.36828,-2.34892),(.11143,53.39068,-2.31553),(.19349,53.53464,-1.87814),(.18036,53.43504,-1.86506),(.14239,53.43447,-1.92091),(.13447,53.372,-2.03761),(.13,53.47398,-2.06982),(.15084,53.5023,-2.00856),(.13675,53.32764,-2.24788),(.1703,53.36728,-2.27368),(.14885,53.41816,-2.20421),(.26723,53.75503,-.74205),(.26589,53.78657,-.82213),(.234,53.74684,-.84071),(.23398,53.69832,-.76557),(.22525,53.74127,-.84191),(.16564,53.68969,-.75165),(.36427,53.39576,-1.21776),(.37498,53.39404,-1.15261),(.27363,53.37478,-1.15211),(.09677,53.28842,-.88253),(.19044,53.32223,-.97368),(.19005,53.27108,-.89973),(.38284,53.40067,-1.03331),(.38456,53.39896,-1.15212),(.44373,53.45777,-1.13721),(.37231,53.44782,-1.23569),(.35096,53.5585,-1.243),(.40753,53.55834,-1.22754),(.30674,53.37789,-1.27716),(.37035,53.40207,-1.22319),(.74211,53.53759,-.92144),(.76852,53.47895,-.87151),(.77331,53.47409,-.90549),(.76951,53.84924,-1.06622),(.68146,53.83675,-1.06852),(.56893,53.92049,-1.2592),(.52444,53.96413,-1.23503),(.58739,53.94216,-1.23713),(.26309,53.27578,-.92061),(.25313,53.24362,-.88283),(.33728,53.2835,-.88119),(.25761,53.30521,-.96929),(.34918,53.34852,-.94534),(.3026,53.28913,-.81751),(.29556,53.24528,-.81665),(.3414,53.2885,-.87495),(.41528,53.44554,-1.20215),(.47965,53.52643,-1.14995),(.61218,53.55206,-1.02033),(.61178,53.54689,-1.0169),(.58098,53.56186,-1.03428),(.7475,53.39853,-.97803),(.77785,53.40243,-.99959),(.80696,53.41009,-.97112),(.62958,53.57888,-1.15109),(.63878,53.58674,-1.21681),(.69118,53.60049,-1.20069),(.53754,53.56,-1.21874),(.65795,53.47301,-.93594),(.66757,53.42136,-.92688),(.63646,53.43353,-.88542),(.38277,53.6616,-1.244),(.39038,53.66177,-1.38836),(.41659,53.76718,-1.33069),(.38714,53.74161,-1.39267),(.29897,53.82691,-.75565),(.28801,53.79246,-.73871),(.31174,53.80094,-.69095),(.2423,53.20698,-.78127),(.29379,53.24058,-.82374),(.37408,53.40087,-1.21658),(.54313,53.65055,-.87201),(.63663,53.59389,-.89304),(.65073,53.55884,-.99617),(.61416,53.62355,-1.02238),(.60229,53.59215,-1.02414),(.56096,53.68843,-1.04382),(.48319,53.7353,-1.08603),(.63096,53.67092,-1.09929),(.59623,53.66915,-1.0967),(.59362,53.57926,-1.09052),(.67953,53.63669,-1.08001),(.68509,53.64733,-1.08004),(.63221,53.6857,-1.09841),(.69527,53.5957,-1.06142),(.68127,53.58796,-1.03515),(.68888,53.5851,-1.02685),(.64475,53.53012,-1.00337),(.64429,53.53169,-1.01125),(.6467,53.53736,-1.01688),(.64801,53.527,-1.01454),(.62901,53.58155,-1.10999),(.67973,53.58969,-1.08566),(.67701,53.53263,-1.03559),(.65567,53.58984,-1.01872),(.65635,53.59337,-1.01451),(.47868,53.51751,-1.04378),(.52076,53.54171,-1.10475),(.53491,53.55962,-1.04806),(.49167,53.5352,-1.03039),(.74126,53.42648,-.91847),(.70473,53.39801,-.92386),(.72077,53.39575,-.95967),(.56665,53.48655,-.89199),(.63259,53.47305,-.91172),(.63443,53.46262,-.90979),(.61258,53.55131,-1.01432),(.65631,53.53939,-.92789),(.64285,53.5367,-.99842),(.65625,53.48407,-.93356),(.50411,53.50115,-.9201),(.49979,53.4972,-.91831),(.47515,53.52101,-.97284),(.4218,53.67298,-1.3442),(.38895,53.86957,-1.40898),(.38925,53.82223,-1.40129),(.41987,53.86177,-1.32049),(.41256,53.74584,-1.22692),(.4619,53.90598,-1.1916),(.50687,53.87216,-1.15403),(.50135,53.91607,-1.15421),(.43788,53.77051,-1.11354),(.46382,53.76222,-1.1474),(.50634,53.73443,-1.1248),(.49026,53.77355,-1.16113),(.86727,53.52043,-.9442),(.85964,53.53143,-.94593),(.80849,53.46954,-.94948),(.97315,53.57491,-.9677),(.9551,53.57843,-.94374),(.96606,53.56806,-.94294),(.53002,53.76455,-.79124),(.53285,53.7661,-.79664),(.78297,53.4591,-.92671),(.77085,53.46268,-.90582),(.77379,53.4271,-.93291),(.76462,53.46873,-.86578),(.74384,53.52993,-.8174),(.70698,53.49207,-.81158),(.91011,53.46552,-1.0376),(.91371,53.45016,-1.00778),(.86081,53.42675,-1.01835),(.9086,53.44972,-.97205),(.8614,53.42542,-.96998),(.97425,53.49029,-.96513),(.91252,53.44504,-.98184),(.81058,53.41854,-.96177),(.86203,53.42016,-.97975),(.69914,53.60147,-1.15355),(.76688,53.63233,-1.16361),(.51196,53.99716,-1.15276),(.5146,53.99844,-1.15033),(.51558,54.00144,-1.1571),(.85531,53.97947,-1.20671),(.40945,53.90757,-1.31026),(.81652,53.8364,-1.3438),(.76463,53.77596,-1.41509),(.80924,53.84283,-1.34673),(.78596,53.5702,-1.23043),(.7867,53.56357,-1.23434),(.92711,53.41376,-1.38575),(.92883,53.41682,-1.38272),(.92678,53.41537,-1.3783),(.65688,53.33286,-1.53711),(.56067,53.33827,-1.55355),(.56015,53.33965,-1.55802),(.22325,53.83898,-1.643),(.14159,53.7431,-1.70988),(.2258,53.76277,-1.6421),(.14338,53.6825,-1.70963),(.06238,53.74344,-1.73724),(.35806,53.5096,-1.49957),(.29711,53.50795,-1.59765),(.37617,53.4667,-1.54379),(.39784,53.42924,-1.58978),(.33583,53.42871,-1.63333),(.39925,53.43061,-1.59222),(.54803,53.34243,-1.55585),(.19295,53.29934,-2.33048),(.18802,53.29708,-2.33971),(.19462,53.36087,-2.32772),(.07299,53.56251,-2.15704),(.07812,53.614,-2.09559),(.13287,53.56954,-2.08568),(.1852,53.43551,-2.2982),(.19636,53.42911,-2.29284),(.10034,53.4708,-2.27171),(.09459,53.46458,-2.27211),(.0577,53.50646,-2.22004),(.14424,53.36389,-2.35642),(.15321,53.30447,-2.35934),(.13295,53.3274,-2.24918),(.16601,53.28234,-2.31909),(.16967,53.28137,-2.31577),(.1115,53.33491,-2.12926),(.13612,53.53585,-2.15199),(.15642,53.4766,-2.22155),(.12553,53.54236,-2.15303),(.06137,53.82115,-1.75411),(.04879,53.43952,-2.23936),(.08286,53.41889,-2.27255),(.04873,53.41271,-2.19331),(.14578,53.31215,-2.35443),(.1141,53.3685,-2.28827),(.20165,53.35865,-2.31984),(.39331,53.86847,-1.41602),(.34203,53.85411,-1.49493),(.11727,53.3396,-2.18899),(.10859,53.3342,-2.12835),(.35008,53.54131,-1.64526),(.40039,53.54354,-1.58035),(.15501,53.60473,-1.72153),(.8711,53.5544,-1.2363),(.91194,53.50289,-1.28758),(.87101,53.55887,-1.23886),(.44296,53.44075,-1.44379),(.4411,53.43844,-1.44744),(.44746,53.43586,-1.44524),(.76994,53.76449,-1.40872),(.76791,53.76269,-1.41461),(.54377,53.82169,-1.39125),(.59539,53.76778,-1.45393),(.98407,53.49584,-1.0115),(.84563,53.50541,-1.06692),(.71945,53.45757,-1.07119),(.74822,53.41197,-1.04821),(.69299,53.40241,-.96685),(.91961,53.65889,-.98848),(.83815,53.71308,-1.04501),(.7434,53.5376,-.81254),(.74635,53.53984,-.82364),(.91406,53.65139,-.97874),(.86753,53.53611,-.94461),(.78323,53.47175,-.92556),(.65973,53.71424,-.72283),(.68119,53.63396,-.7144),(.71902,53.68152,-.74735),(.56627,53.69607,-1.10756),(.42144,53.78056,-1.17648),(.47359,53.81159,-1.18948),(.51256,53.79211,-1.1646),(.45171,53.7863,-1.18542),(.43256,53.94493,-1.25071),(.42736,53.90136,-1.24839),(.43886,53.48472,-.96239),(.41056,53.464,-1.02947),(.57357,53.5035,-.85942),(.56665,53.48412,-.88781),(.581,53.56654,-1.03062),(.49315,53.54432,-1.02407),(.48045,53.52986,-.96954),(.5397,53.56123,-1.04771),(.53475,53.56719,-1.04291),(.66325,53.57934,-1.00412),(.69582,53.57888,-1.01875),(.69608,53.46056,-1.03478),(.7206,53.40719,-1.00753),(.70127,53.59869,-1.05577),(.69251,53.56706,-1.06262),(.54591,53.60799,-1.04218),(.50411,53.61345,-1.02949),(.48624,53.58779,-.97595),(.49982,53.57825,-.92031),(.6057,53.84227,-1.09404),(.59571,53.7734,-1.1137),(.71129,53.66971,-1.08182),(.62528,53.62534,-1.02397),(.70388,53.56242,-.95586),(.41278,53.47489,-.92652),(.37273,53.43765,-.94311),(.35587,53.35679,-.94409),(.35237,53.34352,-.92879),(.22178,53.45725,-.77524),(.22115,53.77663,-.92511),(.42757,53.72432,-1.27449),(.40718,53.70589,-1.24602),(.33963,53.58503,-1.50039),(.35552,53.40125,-.89784),(.34674,53.32371,-.88504),(.32863,53.71393,-1.22802),(.65335,53.47577,-.83905),(.69242,53.55568,-.76291),(.46102,53.38649,-1.57165),(.48657,53.37804,-1.525),(.17517,53.23647,-.84531),(.26688,53.35101,-1.05499),(.27646,53.36751,-1.22065),(.20492,53.36052,-1.15258),(.20144,53.35985,-1.21925),(.3756,53.39349,-1.03515),(.07505,53.20563,-.70068),(.05998,53.28462,-.69011),(0,53.28306,-.68145),(.276,53.86907,-.98934),(.21509,53.85813,-1.08336),(.2172,53.81223,-1.0006),(.15854,53.78492,-.99507),(.07203,53.80117,-1.10239),(.07547,53.76929,-.99375),(.16197,53.75919,-.91546),(.27512,53.82808,-.9131),(.32752,53.89662,-.88803),(.32994,53.90908,-.97837),(.14081,53.41841,-1.96784),(.16865,53.52138,-1.94057),(.13935,53.58472,-2.0226),(.08481,53.59214,-1.77353),(.06106,53.58788,-1.79113),(.03586,53.41741,-2.11679),(.09451,53.65486,-2.01848),(.10474,53.70433,-1.92573),(.15641,53.69819,-1.85662),(.18228,53.60721,-1.86916),(.5064,53.75375,-1.46156),(.59515,53.75459,-1.4561),(.59221,53.69659,-1.49759),(.64507,53.75252,-1.45031),(.68925,53.75589,-1.44789),(.72539,53.67853,-1.47124),(.30024,53.85092,-1.5637),(.31279,53.78553,-1.59338),(.50913,53.76588,-1.45779),(.41384,53.91215,-1.31341),(.8209,53.59329,-1.48201),(.78792,53.67218,-1.45545),(.83563,53.63784,-1.40079),(.87355,53.60674,-1.33257),(.81121,53.72191,-1.361),(.84591,53.77846,-1.30062),(.77155,53.61118,-1.18919),(.86944,53.77221,-1.21368),(.861,53.97512,-1.20192),(.82042,54.02045,-1.11883),(.74465,53.64612,-1.07907),(.71575,53.58485,-1.04447),(.74543,53.56595,-1.03101),(.72466,53.56419,-.99343),(.91236,53.51981,-1.05128),(.78016,53.53779,-.98395),(.67012,53.7405,-.74436),(.71415,53.58752,-.88295),(.46385,53.73399,-.95244),(.45308,53.82309,-.81003),(.28668,53.43685,-.83538),(.42188,53.89269,-.99951),(.24778,53.6643,-.73483),(.24116,53.6578,-.73415),(-.42731,53.67197,-1.29071),(-.41003,53.66698,-1.25762),(-.39664,53.95627,-.97139),(-.38958,53.95284,-.88133),(-.39004,53.87934,-1.12314),(-.45898,53.8208,-.819),(-.4283,53.8711,-.81457),(-.40377,53.63624,-.7932),(-.4142,53.71475,-.77342),(-.31551,53.44287,-.86946),(-.38386,53.53026,-.85472),(-.49447,53.64451,-.80295),(-.53896,53.72793,-.84709),(-.53285,53.7661,-.79664),(-.32863,53.71393,-1.22802),(-.37719,53.70105,-1.23577),(-.27219,53.51967,-1.27759),(-.26609,53.61057,-1.26564),(-.17337,53.58838,-1.25814),(-.53002,53.76455,-.79124),(-.61474,53.71663,-.82401),(-.59355,53.74593,-.78557),(-.66326,53.72881,-.80055),(-.69575,53.39564,-.88943),(-.72032,53.68636,-.75799),(-.86753,53.53611,-.94461),(-.9551,53.57843,-.94374),(-.82217,53.57649,-.98418),(-.78701,53.62871,-1.04916),(-.82991,53.71144,-1.04013),(-.64592,53.77821,-1.10416),(-.70583,53.92016,-1.05579),(-.72728,54.03577,-1.09942),(-.84064,53.7525,-1.1425),(-.85399,53.67522,-1.07104),(-.8755,53.83091,-1.26626),(-.861,53.97512,-1.20192),(-.9146,53.5741,-1.06505),(-.72166,53.88106,-1.34364),(-.80924,53.84283,-1.34673),(-.84612,53.91985,-1.28278),(-.59539,53.76778,-1.45393),(-.65004,53.88438,-1.31034),(-.6907,53.92775,-1.26624),(-.63581,53.91428,-1.27207),(-.62158,53.94936,-1.22596),(-.56893,53.92049,-1.2592),(-.30024,53.85092,-1.5637),(-.36546,53.78859,-1.53019),(-.34203,53.85411,-1.49493),(-.26104,53.76883,-1.67585),(-.22737,53.84065,-1.64699),(-.42285,53.79226,-1.45924),(-.40554,53.71717,-1.52247),(-.21821,53.69458,-1.77329),(-.12553,53.54236,-2.15303),(-.13612,53.53585,-2.15199),(-.04879,53.43952,-2.23936),(-.17492,53.43321,-1.8607),(-.13515,53.4319,-1.9182),(-.23703,53.59586,-1.65115),(-.24103,53.51804,-1.67666),(-.56032,53.53357,-1.29969),(-.48867,53.49802,-1.36504),(-.46216,53.58164,-1.34391),(-.16865,53.52138,-1.94057),(-.19349,53.53464,-1.87814),(-.26723,53.75503,-.74205),(-.23398,53.69832,-.76557),(-.16444,53.72508,-.83381),(-.32317,53.90915,-1.04193),(-.15636,53.19932,-.73402),(-.08824,53.23472,-.80468),(-.07381,53.20176,-.70669),(-.10451,53.32227,-.96478),(-.09677,53.28842,-.88253),(-.44373,53.45777,-1.13721),(-.40753,53.55834,-1.22754),(-.52444,53.96413,-1.23503),(-.4901,53.93851,-1.27737),(-.72315,53.56365,-1.23162),(-.7867,53.56357,-1.23434),(-.3026,53.28913,-.81751),(-.3414,53.2885,-.87495),(-.29556,53.24528,-.81665),(-.61178,53.54689,-1.0169),(-.7475,53.39853,-.97803),(-.65795,53.47301,-.93594),(-.63443,53.46262,-.90979),(-.35096,53.5585,-1.243),(-.38277,53.6616,-1.244),(-.29897,53.82691,-.75565),(-.28801,53.79246,-.73871),(-.23869,53.37009,-.76683),(-.22178,53.45725,-.77524),(-.2423,53.20698,-.78127),(-.29379,53.24058,-.82374),(-.37408,53.40087,-1.21658),(-.54313,53.65055,-.87201),(-.55571,53.56689,-.88517),(-.63663,53.59389,-.89304),(-.65073,53.55884,-.99617),(-.63096,53.67092,-1.09929),(-.62906,53.58753,-1.10404),(-.68127,53.58796,-1.03515),(-.58672,53.67474,-1.05162),(-.59283,53.66509,-1.05991),(-.62381,53.62208,-1.02974),(-.61218,53.55206,-1.02033),(-.64475,53.53012,-1.00337),(-.58565,53.57074,-1.04746),(-.67922,53.58514,-1.09291),(-.58956,53.57256,-1.09407),(-.59362,53.57926,-1.09052),(-.6467,53.53736,-1.01688),(-.64429,53.53169,-1.01125),(-.67701,53.53263,-1.03559),(-.67558,53.54461,-1.03399),(-.65567,53.58984,-1.01872),(-.74126,53.42648,-.91847),(-.63259,53.47305,-.91172),(-.65625,53.48407,-.93356),(-.47515,53.52101,-.97284),(-.4218,53.67298,-1.3442),(-.41987,53.86177,-1.32049),(-.50135,53.91607,-1.15421),(-.46382,53.76222,-1.1474),(-.53115,53.75263,-1.13701),(-.73264,53.42916,-.87532),(-.70698,53.49207,-.81158),(-.6729,53.74405,-.75496),(-.74384,53.52993,-.8174),(-.7434,53.5376,-.81254),(-.85964,53.53143,-.94593),(-.86727,53.52043,-.9442),(-.81333,53.4555,-.95031),(-.3776,53.92903,-.78594),(-.76462,53.46873,-.86578),(-.91252,53.44504,-.98184),(-.9086,53.44972,-.97205),(-.97425,53.49029,-.96513),(-.8614,53.42542,-.96998),(-.51196,53.99716,-1.15276),(-.51558,54.00144,-1.1571),(-.5146,53.99844,-1.15033),(-.85319,53.91442,-1.28002),(-.41384,53.91215,-1.31341),(-.81652,53.8364,-1.3438),(-.79129,53.57018,-1.23461),(-.78596,53.5702,-1.23043),(-.92883,53.41682,-1.38272),(-.92678,53.41537,-1.3783),(-.92947,53.42214,-1.37768),(-.56015,53.33965,-1.55802),(-.22325,53.83898,-1.643),(-.2258,53.76277,-1.6421),(-.14159,53.7431,-1.70988),(-.14338,53.6825,-1.70963),(-.34011,53.43048,-1.63705),(-.4637,53.38802,-1.5762),(-.46662,53.42726,-1.59118),(-.19462,53.36087,-2.32772),(-.14804,53.48529,-2.22816),(-.1852,53.43551,-2.2982),(-.10034,53.4708,-2.27171),(-.09459,53.46458,-2.27211),(-.14424,53.36389,-2.35642),(-.13679,53.36828,-2.34892),(-.15321,53.30447,-2.35934),(-.13395,53.81897,-1.71782),(-.07299,53.56251,-2.15704),(-.54803,53.34243,-1.55585),(-.29711,53.50795,-1.59765),(-.49297,53.49265,-1.36732),(-.48727,53.49686,-1.36745),(-.65688,53.33286,-1.53711),(-.92711,53.41376,-1.38575),(-.85531,53.97947,-1.20671),(-.4304,53.80317,-1.4558),(-.42065,53.79632,-1.46049),(-.75711,54.00213,-1.18565),(-.68591,54.01129,-1.16485),(-.66836,53.94512,-1.2338),(-.64436,53.76582,-1.44916),(-.81058,53.41854,-.96177),(-.97747,53.48589,-.98083),(-.85119,53.45761,-1.0522),(-.96606,53.56806,-.94294),(-.49026,53.77355,-1.16113),(-.38925,53.82223,-1.40129),(-.47359,53.81159,-1.18948),(-.65907,53.47748,-.94299),(-.70388,53.56242,-.95586),(-.61677,53.55804,-1.02291),(-.60229,53.59215,-1.02414),(-.66757,53.42136,-.92688),(-.23773,53.20589,-.77727),(-.2414,53.20962,-.77218),(-.34031,53.64363,-1.23771),(-.42146,53.55988,-1.40318),(-.3835,53.48751,-1.48067),(-.57835,53.56943,-1.10538),(-.58739,53.94216,-1.23713),(-.74211,53.53759,-.92144),(-.76852,53.47895,-.87151),(-.28712,53.89571,-1.07416),(-.16564,53.68969,-.75165),(-.2422,53.70304,-.76377),(-.18036,53.43504,-1.86506),(-.13056,53.42983,-2.31765),(-.59001,53.38495,-1.47767),(-.54139,53.40152,-1.46981),(-.52421,53.43001,-1.4331),(-.20419,53.76112,-1.76449),(0,53.50903,-1.88269),(-.31279,53.78553,-1.59338),(-.75877,53.9401,-1.27024),(-.91187,53.65522,-.98155),(-.60456,53.70275,-.7514),(-.18253,53.49668,-1.28441),(-.49382,53.57386,-.83252),(-.32968,53.50737,-.84796),(-.32888,53.47988,-.8676),(-.29947,53.54558,-.81754),(.22987,53.55908,-.74808),(.42417,53.78113,-.77478),(.31551,53.44287,-.86946),(.5027,53.51215,-.87434),(.76114,53.53769,-.95269),(.83535,53.66255,-1.20367),(.84143,53.54998,-1.08749),(.84465,53.62157,-1.10688),(.87908,53.5723,-1.43083),(.90924,53.44833,-1.44543),(.68726,53.76927,-1.44781),(.22737,53.84065,-1.64699),(.6514,53.68857,-1.48625),(.49467,53.71418,-1.51059),(.16035,53.5956,-1.94031),(.85342,53.46401,-1.35263),(.82721,53.4935,-1.31928),(.76673,53.50864,-1.30146),(.12546,53.44961,-2.14259),(.15667,53.83121,-1.09663),(.28712,53.89571,-1.07416),(0,53.20964,-.69727),(.29666,53.36994,-1.27553),(.1992,53.34589,-1.06445),(.42031,53.43039,-1.53094),(.75007,53.62903,-.76958),(.49373,53.5419,-1.16718),(.87235,53.35308,-1.47183),(.89849,53.40608,-1.46269),(.42146,53.55988,-1.40318),(.43792,53.7759,-1.23809),(.0681,53.66574,-1.75338),(.29718,53.37563,-1.28089),(.58672,53.67474,-1.05162),(.55356,53.65473,-1.03936),(.6348,53.53905,-.90144),(.55571,53.56689,-.88517),(.59007,53.67944,-1.0987),(.67544,53.46827,-.9884),(.55844,53.56101,-1.07391),(.58044,53.56521,-1.05143),(.58341,53.56376,-1.0414),(.58565,53.57074,-1.04746),(.61677,53.55804,-1.02291),(.38227,53.47528,-.894),(.77722,53.86683,-1.06404),(.80532,53.76443,-1.06361),(.85119,53.45761,-1.0522),(.76556,53.41705,-.93737),(.76832,53.41696,-.94048),(.64436,53.76582,-1.44916),(.54919,53.97729,-1.21063),(.86817,53.34997,-1.47448),(.86717,53.34965,-1.46977),(.34011,53.43048,-1.63705),(.11456,53.33898,-2.18953),(.33645,53.85249,-1.49252),(.07927,53.39055,-2.24244),(.14804,53.48529,-2.22816),(.13395,53.81897,-1.71782),(.4637,53.38802,-1.5762),(.46662,53.42726,-1.59118),(.48727,53.49686,-1.36745),(.65615,53.3323,-1.5324),(.42285,53.79226,-1.45924),(.42065,53.79632,-1.46049),(.75711,54.00213,-1.18565),(.66836,53.94512,-1.2338),(.68591,54.01129,-1.16485),(.97747,53.48589,-.98083),(.73264,53.42916,-.87532),(.3776,53.92903,-.78594),(.81333,53.4555,-.95031),(.72032,53.68636,-.75799),(.69575,53.39564,-.88943),(.42731,53.67197,-1.29071),(.43337,53.82995,-1.24253),(.65907,53.47748,-.94299),(.67558,53.54461,-1.03399),(.62906,53.58753,-1.10404),(.2414,53.20962,-.77218),(.23773,53.20589,-.77727),(.38386,53.53026,-.85472),(.4142,53.71475,-.77342),(.36536,53.73406,-.72901),(.27775,53.72975,-.70455),(.34031,53.64363,-1.23771),(.3835,53.48751,-1.48067),(.57835,53.56943,-1.10538),(.72315,53.56365,-1.23162),(.4901,53.93851,-1.27737),(.10451,53.32227,-.96478),(.15636,53.19932,-.73402),(.07381,53.20176,-.70669),(.08824,53.23472,-.80468),(.16444,53.72508,-.83381),(.2422,53.70304,-.76377),(.56444,53.5272,-1.30286),(.56032,53.53357,-1.29969),(.36546,53.78859,-1.53019),(.63581,53.91428,-1.27207),(.6907,53.92775,-1.26624),(.78701,53.62871,-1.04916),(.5965,53.56211,-.80941),(.27219,53.51967,-1.27759),(.37215,53.78889,-.71916),(-.2838,53.72509,-.70263),(-.5027,53.51215,-.87434),(-.76114,53.53769,-.95269),(-.83563,53.63784,-1.40079),(-.03586,53.41741,-2.11679),(0,53.74001,-1.75504),(-.68925,53.75589,-1.44789),(-.59515,53.75459,-1.4561),(-.06106,53.58788,-1.79113),(-.41076,53.62175,-1.55702),(-.14885,53.41816,-2.20421),(-.15667,53.83121,-1.09663),(-.18747,53.35058,-1.28498),(-.1992,53.34589,-1.06445),(-.69242,53.55568,-.76291),(-.24279,53.72722,-1.24578),(-.87235,53.35308,-1.47183),(-.89849,53.40608,-1.46269),(-.34918,53.34852,-.94534),(-.49385,53.67843,-1.02653),(-.6348,53.53905,-.90144),(-.7206,53.40719,-1.00753),(-.53491,53.55962,-1.04806),(-.41659,53.76718,-1.33069),(-.71945,53.45757,-1.07119),(-.54919,53.97729,-1.21063),(-.86817,53.34997,-1.47448),(-.86717,53.34965,-1.46977),(-.91194,53.50289,-1.28758),(-.13295,53.3274,-2.24918),(0,53.45373,-2.17146),(-.29529,53.84964,-1.56131),(-.28406,53.43966,-1.71382),(-.27919,53.43799,-1.71065),(-.05973,53.81608,-1.7438),(-.33282,53.6912,-1.49314),(-.29326,53.7724,-1.56307),(-.33525,53.79921,-1.49259),(-.29053,53.66856,-1.56587),(-.72166,53.57044,-1.22765),(-.65962,53.54887,-1.25931),(-.65696,53.55507,-1.25526),(-.49105,53.37856,-1.5192),(-.8432,53.39921,-1.5254),(-.84291,53.46892,-1.51672),(-.43679,53.94897,-1.25527),(-.61628,54.02291,-1.12347),(-.72801,54.03864,-1.10668),(-.61567,54.01996,-1.11619),(-.54079,53.92616,-1.11681),(-.38714,53.74161,-1.39267),(-.50411,53.61345,-1.02949),(-.54591,53.60799,-1.04218),(-.27889,53.44479,-1.2817),(0,53.23075,-.81171),(0,53.20542,-.70397),(-.06436,53.60727,-.67249),(-.15471,53.63105,-.69859),(-.15815,53.62164,-.69638),(-.06356,53.61698,-.67567),(-.33811,53.86635,-.70335),(-.31174,53.80094,-.69095),(-.38954,53.95774,-.97178),(-.36812,53.9451,-1.08253),(-.36148,53.94662,-1.07865),(-.16832,53.85656,-1.1567),(-.06642,53.81564,-1.18172),(-.17036,53.85411,-1.16532),(-.06553,53.81882,-1.17317),(-.55153,53.77263,-1.13971),(-.22822,53.69047,-1.64149),(-.29329,53.57368,-1.57288),(-.5763,53.41506,-1.58513),(-.55026,53.85087,-1.11651),(0,53.35407,-1.07687),(-.11465,53.34413,-1.069),(0,53.33167,-.97957),(-.20492,53.36052,-1.15258),(-.24081,53.28075,-.75878),(-.15811,53.20288,-.72848),(-.1531,53.2822,-.71884),(-.07885,53.70506,-.81955),(-.07141,53.67673,-.73661),(-.23608,53.66629,-.73512),(-.23445,53.44726,-1.77825),(-.24499,53.53925,-1.79838),(-.67508,53.49369,-1.5552),(-.67201,53.40223,-1.57372),(-.58464,53.50203,-1.57112),(-.58547,53.60008,-1.54626),(-.48039,53.5284,-1.57691),(-.49747,53.61628,-1.55883),(-.72742,53.45275,-1.39141),(-.74001,53.39578,-1.44387),(-.64226,53.43836,-1.4215),(-.55139,53.45994,-1.39302),(-.60932,53.49085,-1.35429),(-.30068,53.62008,-1.69867),(-.23114,53.60731,-1.78982),(-.2818,53.70717,-1.68807),(-.3239,53.71125,-1.61377),(0,53.57331,-1.819),(-.60638,53.9979,-1.17885),(-.85342,53.46401,-1.35263),(-.85628,53.43129,-1.38772),(-.63321,53.92819,-1.07479),(-.5965,53.56211,-.80941),(-.60882,53.64701,-.7545),(-.05998,53.28462,-.69011),(-.14668,53.34854,-.72559),(-.0547,53.34596,-.69432),(-.08787,53.57795,-1.26078),(-.10116,53.48477,-1.28151),(-.17158,53.68217,-1.24834),(0,53.41348,-.68582),(0,53.34179,-.68629),(-.05457,53.41259,-.69759),(-.16142,53.78213,-1.22112),(-.23137,53.80291,-1.22002),(-.07093,53.74801,-1.23249),(.05966,53.51239,-.67913),(0,53.60304,-.66533),(0,53.50524,-.6686),(.06436,53.60727,-.67249),(.2838,53.72509,-.70263),(.17036,53.85411,-1.16532),(.23239,53.88562,-1.16165),(.16142,53.78213,-1.22112),(.17158,53.68217,-1.24834),(.07093,53.74801,-1.23249),(.07864,53.6635,-1.24532),(.05457,53.41259,-.69759),(0,53.5642,-1.25963),(.10116,53.48477,-1.28151),(0,53.4752,-1.28314),(.08787,53.57795,-1.26078),(.14668,53.34854,-.72559),(.24081,53.28075,-.75878),(.23869,53.37009,-.76683),(.1531,53.2822,-.71884),(.55026,53.85087,-1.11651),(.43679,53.94897,-1.25527),(.78869,53.97355,-1.2259),(.81639,54.02348,-1.12616),(.62158,53.94936,-1.22596),(0,53.647,-2.07887),(.3239,53.71125,-1.61377),(.2818,53.70717,-1.68807),(.58547,53.60008,-1.54626),(.66857,53.60088,-1.52259),(.30068,53.62008,-1.69867),(.33893,53.6206,-1.62835),(.22929,53.44532,-1.7744),(.29329,53.57368,-1.57288),(.65696,53.55507,-1.25526),(.72166,53.57044,-1.22765),(.69252,53.50485,-1.32129),(.64226,53.43836,-1.4215),(.72742,53.45275,-1.39141),(.74001,53.39578,-1.44387),(.76321,53.33291,-1.50818),(.65512,53.38889,-1.46799),(.58464,53.50203,-1.57112),(.67508,53.49369,-1.5552),(.30317,53.5416,-1.71586),(.48039,53.5284,-1.57691),(.5763,53.41506,-1.58513),(.07141,53.67673,-.73661),(.15471,53.63105,-.69859),(.06356,53.61698,-.67567),(.37028,53.9292,-.78738),(.38257,53.95352,-.88144),(.31619,53.86883,-.80757),(.07771,53.73515,-.9058),(.07885,53.70506,-.81955),(0,53.7848,-1.09408),(0,53.75458,-.99226),(.32317,53.90915,-1.04193),(.16832,53.85656,-1.1567),(.23005,53.88796,-1.15276),(.15811,53.20288,-.72848),(0,53.35346,-1.23146),(.11181,53.34152,-1.27828),(.11496,53.35716,-1.21968),(0,53.34334,-1.29195),(.11465,53.34413,-1.069),(0,53.4116,-1.28998),(.10614,53.41522,-1.2825),(0,53.28611,-.87877),(.8432,53.39921,-1.5254),(.7642,53.3332,-1.5129),(.76402,53.38827,-1.55017),(.29053,53.66856,-1.56587),(.33282,53.6912,-1.49314),(0,53.80935,-1.17292),(.06642,53.81564,-1.18172),(0,53.80628,-1.1821),(.06553,53.81882,-1.17317),(.30692,53.91808,-1.14514),(.36148,53.94662,-1.07865),(.36812,53.9451,-1.08253),(.30218,53.92057,-1.13726),(.33122,53.86734,-.7065),(.23608,53.66629,-.73512),(.15815,53.62164,-.69638),(.29788,53.38921,-.82962),(.11111,53.34567,-1.28367),(0,53.348,-1.29698),(.47589,53.68264,-.96672),(.49662,53.67981,-.90062),(.49385,53.67843,-1.02653),(.62381,53.62208,-1.02974),(.59283,53.66509,-1.05991),(.58956,53.57256,-1.09407),(.46877,53.97149,-1.20037),(.33525,53.79921,-1.49259),(.60638,53.9979,-1.17885),(.72801,54.03864,-1.10668),(.47282,53.97559,-1.20527),(.49105,53.37856,-1.5192),(.65962,53.54887,-1.25931),(0,53.81611,-1.75774),(.05973,53.81608,-1.7438),(.29529,53.84964,-1.56131),(.13999,53.43832,-2.31993),(.28406,53.43966,-1.71382),(.27919,53.43799,-1.71065),(.29326,53.7724,-1.56307),(.84291,53.46892,-1.51672),(.61628,54.02291,-1.12347),(.61567,54.01996,-1.11619),(.18736,53.35549,-1.29039),(.18495,53.42608,-1.2873),(.18747,53.35058,-1.28498),(.31856,53.79936,-.68836),(.38954,53.95774,-.97178),(.22822,53.69047,-1.64149),(0,53.66528,-.72901),(0,53.61271,-.66912),(.76035,53.48139,-1.53823),(.23114,53.60731,-1.78982),(.24499,53.53925,-1.79838),(.49747,53.61628,-1.55883),(.40554,53.71717,-1.52247),(.41076,53.62175,-1.55702),(.74115,53.5982,-1.50243),(.63321,53.92819,-1.07479),(.0547,53.34596,-.69432),(.14822,53.53124,-.70084),(-.14822,53.53124,-.70084),(-.23239,53.88562,-1.16165),(-.07864,53.6635,-1.24532),(-.13389,53.42428,-.72862),(-.87355,53.60674,-1.33257),(-.81281,53.4037,-1.42386),(-.78869,53.97355,-1.2259),(0,53.59386,-2.15187),(-.74115,53.5982,-1.50243),(-.22929,53.44532,-1.7744),(-.76035,53.48139,-1.53823),(-.76402,53.38827,-1.55017),(-.30317,53.5416,-1.71586),(-.38257,53.95352,-.88144),(-.07771,53.73515,-.9058),(-.30218,53.92057,-1.13726),(-.11808,53.35482,-1.15722),(0,53.35888,-1.15748),(-.18495,53.42608,-1.2873),(-.13999,53.43832,-2.31993),(-.7642,53.3332,-1.5129),(-.23005,53.88796,-1.15276),(-.27775,53.72975,-.70455),(-.29788,53.38921,-.82962),(-.11111,53.34567,-1.28367),(-.10614,53.41522,-1.2825),(-.47589,53.68264,-.96672),(-.49662,53.67981,-.90062),(-.46877,53.97149,-1.20037),(-.81639,54.02348,-1.12616),(-.47282,53.97559,-1.20527),(-.56444,53.5272,-1.30286),(-.76321,53.33291,-1.50818),(-.18736,53.35549,-1.29039),(-.07505,53.20563,-.70068),(-.30692,53.91808,-1.14514),(0,53.69365,-.8036),(-.24402,53.67271,-.73478),(-.66857,53.60088,-1.52259),(-.05966,53.51239,-.67913),(-.30534,53.84864,-1.20658),(0,53.73691,-1.23102),(0,53.65028,-1.24416),(.13389,53.42428,-.72862),(.54079,53.92616,-1.11681),(.85628,53.43129,-1.38772),(.81281,53.4037,-1.42386),(.67201,53.40223,-1.57372),(.23445,53.44726,-1.77825),(0,53.71849,-.88501),(.11808,53.35482,-1.15722),(.27889,53.44479,-1.2817),(.24402,53.67271,-.73478)]),
          normal=Normal(vector=[(-.9999,-.0018,.0122),(-.998,-.0115,-.0622),(-.9886,.148,-.028),(-.9883,.1419,.0565),(-.9876,-.094,-.1259),(-.9871,-.1299,-.0934),(-.9862,-.0521,-.1573),(-.9854,.1696,.0117),(-.9826,.1307,-.1316),(-.982,-.1324,.1345),(-.9795,-.1208,.161),(-.9775,-.2092,.0264),(-.9768,.0592,.2059),(-.9724,.1062,.2079),(-.9711,.0246,-.2373),(-.9707,-.0386,-.237),(-.9678,.2304,.1015),(-.9672,.2542,-.0012),(-.9668,.2325,-.1057),(-.9663,-.0621,.2497),(-.9624,-.2693,-.0371),(-.9601,-.0242,-.2786),(-.9593,-.1149,.2579),(-.956,.2648,-.1266),(-.9532,-.1129,-.2806),(-.952,-.0121,.3059),(-.9514,.2243,.2112),(-.9489,.3133,-.0363),(-.947,-.3042,-.1032),(-.9455,.3161,-.0782),(-.9438,.1394,.2995),(-.9421,.2973,.1554),(-.9405,-.2748,-.1997),(-.9403,.3078,.1455),(-.9392,-.0365,.3415),(-.939,-.3011,-.1664),(-.9379,-.3451,.0339),(-.9369,-.0407,.3472),(-.9326,.3523,-.0787),(-.93,-.2729,-.2463),(-.9276,.0141,.3733),(-.9254,-.3205,.2021),(-.9248,.3084,.2226),(-.9207,-.0451,.3876),(-.9206,-.3903,.0104),(-.9189,.2011,-.3394),(-.9161,.4005,-.021),(-.9139,.3775,-.1494),(-.913,-.0414,-.4058),(-.9091,-.1341,.3945),(-.9058,.0323,.4224),(-.9041,.21,-.3721),(-.9039,-.4252,.0456),(-.9,.0514,.4329),(-.897,-.0555,-.4386),(-.8959,.3386,-.2875),(-.8957,.3095,-.3192),(-.8953,.4453,-.0075),(-.8918,.0228,.4519),(-.8907,.4525,.0448),(-.8905,-.021,-.4545),(-.8899,.4135,-.1927),(-.8865,.349,.3039),(-.8858,-.4577,.0769),(-.8839,-.1863,.4289),(-.8779,.1027,-.4678),(-.8769,-.2542,.408),(-.8767,.4469,-.178),(-.8737,-.1147,.4727),(-.8713,-.0316,.4897),(-.8711,.3591,.335),(-.8673,-.1817,-.4633),(-.8666,.4539,.2074),(-.8665,-.4073,-.2887),(-.8659,.0232,.4998),(-.8658,.3514,-.3563),(-.8639,-.0351,.5024),(-.8624,.4658,-.1983),(-.8622,-.4994,.0848),(-.8607,.4571,.2241),(-.8567,-.4754,.1999),(-.8503,.1943,-.4891),(-.8495,-.1617,-.5023),(-.8483,-.4928,.1935),(-.8482,-.4911,-.1984),(-.848,.2702,-.4559),(-.8466,-.3695,-.383),(-.8444,-.2743,.4602),(-.8427,-.1525,.5163),(-.8418,-.0245,-.5392),(-.8406,.2749,.4667),(-.839,-.5441,.0077),(-.838,.255,-.4824),(-.8378,-.3691,.4024),(-.8374,.5173,.1767),(-.8371,.5407,.0837),(-.8352,.433,.3391),(-.8338,-.5488,-.0602),(-.8317,.0971,-.5467),(-.8301,-.5383,.1451),(-.8279,-.5505,.1077),(-.8249,.0189,-.5649),(-.8237,.5581,.0997),(-.823,-.0489,.5659),(-.8208,.0192,-.5709),(-.8202,-.221,.5276),(-.8197,-.1655,.5484),(-.8194,.1891,-.5411),(-.8175,-.1661,.5514),(-.8143,.0038,.5804),(-.8137,.2239,-.5364),(-.813,.5263,.2491),(-.8127,-.4142,.4098),(-.8118,.135,.5681),(-.8108,-.3377,-.4781),(-.8088,.5757,.1203),(-.8059,-.515,-.2919),(-.8055,-.0786,-.5873),(-.8046,.5197,-.2874),(-.8012,.2162,-.5579),(-.7994,-.302,.5193),(-.7987,.23,.556),(-.7961,.6032,.0487),(-.7942,.0857,-.6016),(-.7913,.3746,.4832),(-.7911,-.4049,-.4584),(-.7904,.4404,-.4257),(-.7895,.0071,.6138),(-.7878,.209,-.5794),(-.7844,.5539,-.2791),(-.7841,.3029,-.5417),(-.7835,-.4576,-.4204),(-.7824,.3344,-.5254),(-.778,.4877,.3961),(-.7778,-.3971,.4872),(-.7775,-.3742,.5054),(-.777,-.6127,.1443),(-.7739,-.2506,.5817),(-.7733,.2673,-.5749),(-.7721,-.423,.4742),(-.7714,.0353,.6354),(-.7708,-.6052,-.1992),(-.7698,-.4077,.4911),(-.7684,.3787,-.5159),(-.7666,.637,.0817),(-.766,.6364,.0904),(-.7654,.4522,.4579),(-.7638,-.0047,.6454),(-.7578,-.4194,.4998),(-.7572,-.3683,-.5394),(-.7565,-.3887,.526),(-.7533,-.1953,.628),(-.7528,-.611,.2448),(-.7528,.2863,-.5927),(-.7525,-.5932,-.2861),(-.7524,.616,.2333),(-.7524,-.6009,-.2699),(-.7522,-.4185,.5089),(-.7484,-.41,-.5214),(-.7442,.4107,-.5267),(-.7407,.4902,.4595),(-.7405,.3397,-.5799),(-.7398,.4554,.4952),(-.7368,-.219,-.6396),(-.7333,-.6448,-.2158),(-.7332,-.3043,.6082),(-.7314,.2427,.6373),(-.7272,-.495,.4756),(-.7256,-.6795,-.1087),(-.7243,.1689,.6685),(-.7236,.3998,-.5626),(-.7227,.1668,-.6707),(-.7205,-.2157,.659),(-.7162,.3382,.6105),(-.7122,.6033,.3588),(-.711,.1184,-.6932),(-.7072,-.0757,.7029),(-.7042,-.3295,.629),(-.7027,.409,-.5821),(-.6998,-.7124,.0535),(-.6993,.0134,.7147),(-.6982,.4492,.5574),(-.6963,.034,-.7169),(-.6953,-.0159,.7185),(-.6936,-.3695,.6183),(-.6933,.2453,.6776),(-.6926,-.1045,-.7137),(-.6914,.4487,-.5662),(-.6898,.5784,-.4355),(-.6888,.646,.3291),(-.6849,.2467,.6856),(-.6845,.1855,-.705),(-.6842,-.114,.7203),(-.6818,-.6121,-.4006),(-.6811,.3031,-.6665),(-.6754,-.7374,.0124),(-.6719,.1505,.7251),(-.6699,-.023,.7421),(-.6684,-.3833,.6374),(-.6684,-.0222,.7435),(-.6642,-.6847,-.3001),(-.6641,.0495,.746),(-.6634,.1913,.7234),(-.6632,-.7086,.2409),(-.6629,.5137,-.5446),(-.6588,-.7511,.0421),(-.6581,.0827,.7484),(-.6562,.712,.2498),(-.6561,.7458,.1152),(-.6471,-.4949,.5799),(-.6462,.6919,.3222),(-.6435,.4187,-.6408),(-.6434,.2968,-.7057),(-.642,-.684,-.3464),(-.6409,-.6992,-.3168),(-.64,-.7277,.2468),(-.64,.6534,.4043),(-.6389,.6523,.4078),(-.6378,.7493,-.178),(-.6365,-.1986,-.7453),(-.6339,-.6824,-.364),(-.6339,.5039,-.5867),(-.6334,-.5316,-.5623),(-.6321,.6698,.3897),(-.6319,.2145,-.7448),(-.6265,-.7192,-.3004),(-.6238,-.6837,.3787),(-.6238,.1011,.775),(-.6229,.7233,.2981),(-.6222,.7828,.0055),(-.6174,.263,.7414),(-.6151,-.6386,.4624),(-.6146,-.6655,-.4235),(-.6119,.7861,-.0876),(-.6102,.0148,.7921),(-.6069,-.7918,-.0689),(-.6058,.6166,.5028),(-.6056,-.7842,.1348),(-.6037,-.3376,-.7222),(-.6036,.7093,.3642),(-.6025,-.7977,-.0273),(-.6016,.212,.7701),(-.6011,-.2035,-.7728),(-.5998,-.5015,-.6234),(-.5983,-.1799,.7808),(-.5955,.0264,.8029),(-.5934,.3376,-.7307),(-.5927,-.4874,.6411),(-.5885,.1899,.7858),(-.5851,-.7693,-.2566),(-.5796,.3525,-.7348),(-.5783,.597,.556),(-.5781,.1833,.7951),(-.576,.6128,-.5411),(-.5728,-.3366,.7474),(-.5712,-.4926,.6566),(-.5697,-.1903,.7995),(-.5695,-.25,.783),(-.5669,-.814,.127),(-.5658,-.8155,-.1217),(-.5655,-.6625,-.4912),(-.565,.7663,.3059),(-.5629,-.8106,-.1614),(-.5616,.6962,-.4472),(-.5609,.1401,.816),(-.5608,-.5505,.6184),(-.5565,-.018,.8306),(-.5555,-.5268,.6434),(-.5549,.5485,.6254),(-.5541,.3369,-.7612),(-.5511,-.3906,-.7374),(-.5489,.6773,-.4898),(-.5469,.3597,.756),(-.5462,-.6899,.475),(-.5423,.8364,-.0796),(-.5386,-.8397,-.0699),(-.5386,-.3939,-.7448),(-.537,.4679,-.702),(-.5361,.7492,.3888),(-.5345,-.0931,-.84),(-.5322,.0801,.8429),(-.5316,.2039,-.8221),(-.5295,-.6097,.5898),(-.5275,.8433,.1029),(-.525,-.8362,-.1585),(-.5248,-.145,.8388),(-.5216,-.1328,.8428),(-.5209,.1861,.8331),(-.5197,.0224,-.854),(-.5146,-.1852,-.8372),(-.512,-.0661,-.8564),(-.5114,.8407,.1782),(-.5091,.116,-.8528),(-.5091,-.7736,-.3773),(-.5086,.7775,-.37),(-.5043,-.6756,-.5379),(-.5026,-.0622,.8623),(-.5023,.3226,-.8023),(-.502,-.1403,.8534),(-.5007,-.8524,-.1507),(-.5004,.6098,-.6146),(-.4987,.2075,-.8416),(-.498,-.7566,.4237),(-.4971,.3921,-.774),(-.4939,.8099,.3164),(-.4914,.011,.8708),(-.4902,.6573,-.5724),(-.4876,.1687,.8566),(-.4871,.8491,.2043),(-.4853,-.3357,.8074),(-.4821,-.4732,-.7373),(-.4803,-.4762,.7366),(-.4787,-.8421,.2485),(-.4779,.7989,.3652),(-.4778,.8779,-.0313),(-.4746,.4024,-.7828),(-.4731,-.8312,-.292),(-.4724,-.8627,.1802),(-.4722,.1687,-.8652),(-.4698,.7902,-.3936),(-.467,.7725,-.4304),(-.466,-.3291,.8213),(-.4649,-.5243,.7134),(-.4612,-.8862,-.0433),(-.4606,-.8791,.1231),(-.4604,-.8875,-.0196),(-.4529,.1291,.8822),(-.4525,.867,.2089),(-.4517,.0857,.888),(-.4476,-.8396,.3077),(-.4457,.8465,-.2911),(-.4434,.8354,-.3248),(-.443,.4275,.788),(-.44,-.7615,.476),(-.4383,-.4683,.7672),(-.4373,-.8989,-.0296),(-.4366,.5715,.6949),(-.4364,.3192,-.8412),(-.4363,.6336,.6389),(-.4362,.8404,.3216),(-.4347,-.6144,.6584),(-.4341,-.895,.1027),(-.4332,.556,.7094),(-.4322,.1541,.8885),(-.4312,-.2476,.8676),(-.4312,.901,-.0487),(-.4307,.751,-.5004),(-.427,.4679,-.7738),(-.4235,.8631,-.2751),(-.4223,-.7704,.4777),(-.4189,.7614,-.4948),(-.4184,-.8959,-.1492),(-.4182,-.7217,.5517),(-.4177,.9052,.0781),(-.4154,.7261,-.5479),(-.4153,-.8753,.2479),(-.412,-.2864,.865),(-.4106,-.832,-.3731),(-.4099,.7803,.4723),(-.4071,.5904,-.6969),(-.4034,-.1824,.8966),(-.4026,.9152,-.0175),(-.4014,-.3269,-.8556),(-.4014,.8625,.3082),(-.3999,-.0648,.9143),(-.3975,-.2307,.8881),(-.3954,.6124,-.6845),(-.3948,-.5403,-.7431),(-.3903,.8543,.3433),(-.386,.905,-.1788),(-.3849,-.2368,-.8921),(-.3826,-.3832,.8407),(-.3792,.2883,-.8793),(-.3764,-.268,-.8868),(-.3761,-.911,-.1692),(-.3733,-.1539,.9148),(-.3717,.0793,.9249),(-.3678,-.1874,.9108),(-.365,-.5757,.7317),(-.3603,.5657,.7417),(-.3597,-.9321,-.0434),(-.358,-.9236,-.1372),(-.3578,.0219,.9335),(-.3562,-.0282,.934),(-.3547,-.2061,.912),(-.3543,.1056,.9292),(-.353,-.8289,.4339),(-.3518,-.6345,.6882),(-.3493,.8381,.419),(-.3477,-.7537,.5577),(-.346,-.5431,.765),(-.3455,.6818,-.6448),(-.3443,-.9385,-.0256),(-.3426,.9336,-.1052),(-.3426,-.9385,-.0423),(-.3403,-.045,.9392),(-.3394,-.9278,.1548),(-.3378,.9403,-.0406),(-.3353,-.7802,.528),(-.3351,-.2328,.913),(-.335,.0801,.9388),(-.3338,-.5183,.7874),(-.3329,-.5333,.7777),(-.3319,-.9423,-.0445),(-.3303,-.454,.8275),(-.3292,-.9345,.1357),(-.3263,.9353,-.1366),(-.3255,.8929,-.3111),(-.3229,.9387,.1211),(-.3218,-.837,.4426),(-.3213,-.8484,-.4206),(-.3202,-.5412,.7775),(-.3193,-.8797,-.3525),(-.3158,-.0546,.9473),(-.3148,.1447,.9381),(-.3122,-.2516,-.9161),(-.3121,-.5004,.8076),(-.3103,.9166,.2521),(-.3076,.2552,-.9166),(-.3059,-.5948,.7434),(-.3036,-.4662,.8309),(-.3035,-.9353,.182),(-.2963,-.564,.7708),(-.2949,-.8415,.4526),(-.2927,.2428,.9249),(-.2924,-.764,.5752),(-.2921,.6701,.6824),(-.2911,.3248,-.8999),(-.2908,-.0644,.9546),(-.2907,-.6608,.692),(-.2893,.2268,.93),(-.2886,.7592,-.5833),(-.2869,-.9307,.2269),(-.2846,-.6815,.6742),(-.2842,.0218,-.9585),(-.2832,-.8631,-.4183),(-.2826,-.615,.7361),(-.2815,.4445,.8504),(-.2791,-.3283,-.9024),(-.2765,-.9608,-.0198),(-.2763,-.6267,.7286),(-.276,-.9611,.0137),(-.2755,.6982,-.6607),(-.2755,-.9524,.1304),(-.2725,.7677,-.58),(-.2709,-.9499,-.1557),(-.2705,.9197,-.2845),(-.2663,-.9287,.2579),(-.2663,.8972,.3522),(-.2638,.8164,-.5136),(-.2621,-.965,.0015),(-.2614,.2588,.9299),(-.2607,-.9491,-.1767),(-.26,.7526,.605),(-.2576,-.0055,-.9662),(-.2556,-.2495,-.934),(-.2549,.3551,-.8994),(-.2549,.2315,-.9389),(-.2524,.1006,.9624),(-.2513,-.2975,-.9211),(-.25,-.9344,.2537),(-.2495,.4148,-.875),(-.2483,.3448,-.9052),(-.2482,.7602,.6004),(-.248,-.9291,-.2745),(-.2419,.0637,.9682),(-.2409,-.9698,-.0392),(-.2395,.9259,.292),(-.2392,.0642,-.9688),(-.2384,.449,-.8611),(-.2381,.5628,.7915),(-.238,.2347,.9425),(-.2368,.967,-.0936),(-.2343,-.142,.9617),(-.2338,-.9051,-.3552),(-.2338,-.4669,-.8529),(-.2336,.4554,-.8591),(-.2332,.9701,-.0671),(-.2293,.5091,-.8296),(-.2272,-.9378,.2625),(-.2195,-.9729,.0728),(-.2195,.8901,.3995),(-.214,-.976,-.0412),(-.2131,.5625,.7988),(-.213,.2252,-.9507),(-.2122,.7468,-.6303),(-.2117,.3177,-.9243),(-.2104,-.4829,-.85),(-.2099,.2157,.9536),(-.2088,-.9127,.3512),(-.2072,-.9293,.3056),(-.2065,-.0153,.9783),(-.2058,.9118,.3553),(-.2049,.7963,.5691),(-.2045,.242,-.9485),(-.2031,.8933,.401),(-.203,-.7973,-.5685),(-.2011,-.9535,.2244),(-.2001,-.7111,.674),(-.1995,-.4819,-.8532),(-.1977,-.184,.9628),(-.196,-.6276,-.7534),(-.1938,.1149,-.9743),(-.1936,.2021,-.96),(-.1931,-.8575,-.4768),(-.1927,.1312,-.9724),(-.1925,.9811,-.0192),(-.1922,-.7175,.6695),(-.1902,.8988,.395),(-.1898,.4612,.8667),(-.1891,.9188,-.3466),(-.1883,-.2971,.9361),(-.1882,-.5712,.799),(-.1866,-.4217,.8873),(-.1864,.6544,.7329),(-.1829,.5099,-.8406),(-.1822,-.9241,.3359),(-.1822,-.8124,.5539),(-.1802,.932,.3144),(-.1802,.0991,.9786),(-.1798,.5694,-.8021),(-.1796,.9837,-.0096),(-.1794,.9076,.3795),(-.1788,-.5489,-.8166),(-.1771,.8003,-.5728),(-.1766,.7243,-.6665),(-.1764,-.6302,-.7562),(-.1757,-.721,.6703),(-.1755,-.5244,.8332),(-.1743,-.9771,.1223),(-.1738,-.1772,.9687),(-.1728,.9762,-.1313),(-.1704,-.9847,.036),(-.1702,-.8735,-.4562),(-.1682,.3946,-.9033),(-.168,.5313,-.8303),(-.166,.2714,.9481),(-.1656,.7898,-.5905),(-.1648,.9243,.3442),(-.1644,.1175,.9794),(-.1625,.6202,.7675),(-.1617,-.753,.6378),(-.16,-.166,-.9731),(-.1591,-.6515,-.7418),(-.1576,.7235,.6721),(-.155,.5403,-.827),(-.1518,.4883,.8594),(-.1518,-.8127,-.5626),(-.1517,.7738,-.615),(-.1508,.1964,-.9689),(-.1496,-.9164,.3712),(-.1471,.7413,-.6548),(-.1447,.498,.855),(-.1442,-.5118,.8469),(-.1427,-.2941,-.9451),(-.1425,-.6901,.7095),(-.1417,.1857,-.9723),(-.1414,-.9871,-.0747),(-.141,.5875,-.7968),(-.1376,-.0251,.9902),(-.136,.1591,.9779),(-.1358,-.7234,.6769),(-.1356,.6744,-.7258),(-.135,-.846,-.5158),(-.1324,-.7148,.6867),(-.1316,.7463,.6524),(-.1306,-.3744,-.918),(-.1306,-.9907,.0384),(-.1292,-.9354,-.3293),(-.1265,-.9507,.2832),(-.1238,.2468,.9611),(-.1197,-.7715,-.6249),(-.1183,.4446,-.8879),(-.1163,-.7606,.6387),(-.1159,-.7223,.6818),(-.1155,.7978,-.5918),(-.1152,-.2823,.9524),(-.1148,-.9905,-.0754),(-.1146,.2886,-.9506),(-.1142,-.7819,.6128),(-.1142,.0562,.9919),(-.1142,-.3076,.9447),(-.1142,-.862,-.4939),(-.1117,.5068,-.8548),(-.1106,.9382,.3279),(-.1096,-.7671,.632),(-.109,.141,-.984),(-.1089,.1113,.9878),(-.1064,-.8561,-.5057),(-.1059,.7758,-.622),(-.1049,-.2913,.9509),(-.1049,.8129,-.5729),(-.1009,-.5306,.8416),(-.1007,-.5022,.8588),(-.1,.3174,-.943),(-.0996,.0138,.9949),(-.0972,-.7223,.6847),(-.0964,.5245,-.8459),(-.096,.8143,-.5725),(-.095,.4573,-.8842),(-.0947,-.1127,-.9891),(-.094,.9796,-.1777),(-.0934,-.9081,-.4082),(-.0902,.5078,.8567),(-.0891,-.481,-.8722),(-.0878,-.8214,.5636),(-.0873,-.9667,.2405),(-.0869,.8252,-.5581),(-.0859,-.9939,.0692),(-.0856,-.5738,.8145),(-.0853,-.9826,-.1651),(-.0848,.7991,-.5951),(-.0825,.5285,.8449),(-.0815,.7819,-.618),(-.0801,.377,-.9227),(-.08,.5252,.8472),(-.0796,.173,-.9817),(-.0775,.7886,-.61),(-.0771,-.8251,-.5597),(-.0765,-.1022,.9918),(-.0738,-.654,.7529),(-.0721,-.978,-.1957),(-.0713,-.2092,.9753),(-.0703,-.9585,.2761),(-.0701,-.8764,.4765),(-.0677,.1976,-.9779),(-.0671,-.6299,.7738),(-.0671,.3776,-.9235),(-.0665,-.751,.657),(-.0657,-.0021,.9978),(-.0655,-.8928,-.4456),(-.0654,.1671,-.9838),(-.0651,-.9929,.0991),(-.0637,.2012,.9775),(-.0637,-.8815,.4678),(-.0629,-.8093,.5841),(-.0626,.1166,-.9912),(-.0623,.7863,-.6147),(-.0612,-.8966,.4387),(-.0612,-.76,.6471),(-.0605,.4048,-.9124),(-.0605,-.3826,-.9219),(-.0601,.8183,-.5717),(-.0597,.8314,-.5525),(-.0591,-.9963,.0627),(-.0587,-.8012,.5955),(-.0573,-.7875,.6137),(-.0564,.1508,-.987),(-.0556,-.7679,.6382),(-.0549,.8495,-.5247),(-.0546,.9715,-.2306),(-.0509,-.9956,.0783),(-.0491,.7818,.6216),(-.0489,-.7399,-.6709),(-.0481,.4742,-.8791),(-.0445,.2366,-.9706),(-.0435,-.981,-.1892),(-.0435,-.3212,.946),(-.0419,.1509,-.9877),(-.0418,.6217,.7822),(-.0402,.788,-.6144),(-.0401,.7662,-.6414),(-.039,-.9512,-.306),(-.0381,-.4585,-.8879),(-.0381,.8383,-.5439),(-.0377,.8433,.5361),(-.0373,.7047,.7085),(-.0366,-.4039,.9141),(-.0358,.3459,.9376),(-.0349,.6233,-.7812),(-.0348,.8608,.5077),(-.0321,-.9994,-.0126),(-.0294,.8102,.5854),(-.0285,-.1081,-.9937),(-.0279,.2022,-.9789),(-.0265,.9993,.0262),(-.025,.1276,-.9915),(-.0214,-.986,-.1656),(-.0207,.3475,-.9375),(-.0204,.0359,.9991),(-.0172,-.9474,.3197),(-.0171,-.1444,.9894),(-.0159,.9973,-.0711),(-.0152,-.9676,.252),(-.0152,.1303,-.9914),(-.0146,-.9459,.3241),(-.0142,.8547,-.5189),(-.0142,-.5476,.8366),(-.0138,-.0531,.9985),(-.0124,-.9931,.1168),(-.0117,.7302,.6832),(-.0096,.8025,-.5966),(-.0089,-.3579,.9337),(-.0082,-.9858,.1675),(-.0082,-.9969,-.0786),(-.0078,.0272,-.9996),(-.0069,.7155,-.6985),(-.0042,.7356,-.6775),(-.0033,-.1019,.9948),(-.0022,.4327,.9015),(-.002,.0348,-.9994),(0,.0401,.9992),(0,-.0825,.9966),(0,-.1165,.9932),(0,.1452,.9894),(0,.5584,.8295),(0,.5629,.8265),(0,-.6114,.7913),(0,.8373,.5468),(0,-.8404,.542),(0,-.8911,.4539),(0,.9486,.3166),(0,.9487,.3163),(0,.949,.3152),(0,.9567,.2911),(0,-.9844,.1762),(0,-.9905,.1376),(0,-.9997,-.0234),(0,.9997,-.024),(0,.9974,-.072),(0,-.9908,-.1353),(0,-.9528,-.3037),(0,-.9484,-.3171),(0,-.9474,-.3199),(0,-.8813,-.4725),(0,.8691,-.4947),(0,.8666,-.4991),(0,-.8587,-.5125),(0,.838,-.5457),(0,.7961,-.6052),(0,.7392,-.6735),(0,.5204,-.8539),(0,.3533,-.9355),(0,-.348,-.9375),(0,.2082,-.9781),(0,-.1953,-.9807),(0,.1771,-.9842),(0,.1638,-.9865),(0,.0918,-.9958),(.002,.0348,-.9994),(.0022,.4327,.9015),(.0029,.1476,-.989),(.0033,-.1019,.9948),(.004,.7402,-.6724),(.0041,.8465,.5324),(.0042,.7356,-.6775),(.0049,.7311,-.6822),(.0069,.7155,-.6985),(.0078,.0272,-.9996),(.0082,-.9969,-.0786),(.0082,-.9858,.1675),(.009,-.038,.9992),(.0099,-.0227,.9997),(.0103,-.9506,.3101),(.0112,.0512,.9986),(.0117,.7302,.6832),(.0142,.8547,-.5189),(.0146,-.9459,.3241),(.0159,.9973,-.0711),(.017,.7843,.6202),(.0183,.8035,-.5951),(.0192,.8187,.5739),(.0207,.3475,-.9375),(.0214,-.986,-.1656),(.0238,-.8963,.4428),(.025,.1276,-.9915),(.0265,.9993,.0262),(.0279,.2022,-.9789),(.0281,-.9945,.1011),(.0285,-.1081,-.9937),(.0337,-.8116,.5833),(.0341,.5355,.8439),(.0349,.6233,-.7812),(.0358,.3459,.9376),(.0373,.7047,.7085),(.0377,.8433,.5361),(.0381,.8383,-.5439),(.0381,-.4585,-.8879),(.0389,.1957,.9799),(.039,-.9512,-.306),(.0401,.7662,-.6414),(.0402,.788,-.6144),(.0404,.2272,-.973),(.0418,.6217,.7822),(.0419,.1509,-.9877),(.0435,-.3212,.946),(.0444,.1813,-.9824),(.0448,-.8868,.4599),(.0472,-.7408,-.6701),(.0481,.4742,-.8791),(.0509,-.9956,.0783),(.0546,.9715,-.2306),(.0549,.8495,-.5247),(.0558,-.8285,.5571),(.0564,.1508,-.987),(.0573,-.7875,.6137),(.0591,-.9963,.0627),(.0597,.8314,-.5525),(.0601,.8183,-.5717),(.0605,-.3826,-.9219),(.0605,.4048,-.9124),(.0606,-.4294,.9011),(.0608,-.7834,.6185),(.0624,-.9824,-.1759),(.0626,.1166,-.9912),(.0651,-.9929,.0991),(.0654,.1671,-.9838),(.0655,-.8928,-.4456),(.0657,-.0021,.9978),(.0665,-.751,.657),(.0671,.3776,-.9235),(.0671,-.6299,.7738),(.0676,.7891,-.6105),(.0713,-.1137,.991),(.0713,-.2092,.9753),(.0721,-.978,-.1957),(.0738,-.654,.7529),(.074,-.9954,.0601),(.0775,.7886,-.61),(.0796,.173,-.9817),(.0797,-.8244,-.5604),(.0801,.377,-.9227),(.081,-.7904,.6072),(.0813,-.8232,.5619),(.0815,.7819,-.618),(.0825,.5285,.8449),(.0843,.823,-.5617),(.0848,.7991,-.5951),(.0856,-.5738,.8145),(.0857,.4345,-.8966),(.086,.5165,.8519),(.0878,-.9957,.0311),(.0879,.7175,-.691),(.0885,-.8769,.4725),(.0891,-.481,-.8722),(.092,-.9529,.2889),(.0934,-.9081,-.4082),(.094,.9796,-.1777),(.0947,-.1127,-.9891),(.095,.4573,-.8842),(.096,.8143,-.5725),(.0964,.5245,-.8459),(.0988,-.7923,.6021),(.0996,.0138,.9949),(.1,.3174,-.943),(.1009,-.5306,.8416),(.1028,-.327,.9394),(.1049,.8129,-.5729),(.1059,.7758,-.622),(.1064,-.8561,-.5057),(.1089,.1113,.9878),(.1106,.9382,.3279),(.1117,.5068,-.8548),(.112,-.7326,.6714),(.1123,-.7567,.6441),(.1135,-.9433,-.312),(.1135,.2428,.9634),(.1142,-.862,-.4939),(.1142,-.3076,.9447),(.1142,-.7819,.6128),(.1145,-.5678,-.8152),(.1146,.2886,-.9506),(.1147,-.9825,-.1468),(.1148,-.9905,-.0754),(.1152,-.2823,.9524),(.1155,.7978,-.5918),(.1159,-.7223,.6818),(.1184,-.4662,.8767),(.1197,-.7715,-.6249),(.1208,.1583,.98),(.1219,.1584,-.9798),(.1265,-.9507,.2832),(.1306,-.3744,-.918),(.1316,.7463,.6524),(.1324,-.7148,.6867),(.1331,.1969,-.9713),(.1336,.5188,-.8444),(.135,-.846,-.5158),(.1358,-.7234,.6769),(.1361,.7384,-.6604),(.1396,.5819,-.8012),(.1425,-.6901,.7095),(.1427,-.676,-.7229),(.1427,-.2941,-.9451),(.1447,.498,.855),(.1496,-.9164,.3712),(.1502,.6013,-.7848),(.1508,.1964,-.9689),(.1517,.7738,-.615),(.1518,-.8127,-.5626),(.1518,.4883,.8594),(.1541,-.5189,.8408),(.1547,-.0477,.9868),(.1552,-.9801,-.124),(.1555,-.6384,-.7538),(.1572,.9035,.3986),(.16,-.166,-.9731),(.1619,-.9783,.1294),(.1621,.6939,.7016),(.1644,.1175,.9794),(.1647,.6467,.7447),(.1648,.9243,.3442),(.1653,.0723,.9836),(.1656,.7898,-.5905),(.166,.2714,.9481),(.1674,-.4051,.8988),(.1682,.3946,-.9033),(.1693,-.9584,.2297),(.1695,-.5313,.83),(.1702,-.8735,-.4562),(.1704,-.9847,.036),(.1719,-.7484,.6406),(.1757,-.721,.6703),(.1766,.7243,-.6665),(.1771,.8003,-.5728),(.1792,-.9646,.1937),(.1796,.9837,-.0096),(.1802,.932,.3144),(.1822,-.8124,.5539),(.1829,.5099,-.8406),(.1832,-.5783,.795),(.1864,.6544,.7329),(.1874,.4753,.8596),(.188,.9765,-.1057),(.1891,.9188,-.3466),(.1925,.9811,-.0192),(.1927,.1312,-.9724),(.1931,-.8575,-.4768),(.1936,.5765,-.7938),(.1936,.2021,-.96),(.1947,.5643,.8023),(.1958,-.4829,-.8535),(.196,-.6276,-.7534),(.1977,-.184,.9628),(.1978,-.6981,.6881),(.2008,.8131,.5464),(.203,-.7973,-.5685),(.2045,.242,-.9485),(.2058,.9118,.3553),(.2064,.0835,.9749),(.2072,-.9293,.3056),(.2073,-.487,-.8484),(.2088,-.9127,.3512),(.2099,.2157,.9536),(.2117,.3177,-.9243),(.213,.2252,-.9507),(.2133,-.1586,.964),(.214,-.976,-.0412),(.2156,.9137,.3445),(.2195,-.9729,.0728),(.2197,.0949,-.9709),(.2204,.0028,.9754),(.2281,.2258,.9471),(.2293,.5091,-.8296),(.2306,-.34,.9117),(.2331,-.9092,-.3451),(.2332,.9701,-.0671),(.2334,-.9375,.258),(.2336,.4554,-.8591),(.2338,-.4669,-.8529),(.2343,-.142,.9617),(.2345,-.8806,-.4119),(.2367,.8858,.3991),(.2368,.967,-.0936),(.2381,.5628,.7915),(.2392,.0642,-.9688),(.2395,.9259,.292),(.2409,-.9698,-.0392),(.2419,.0637,.9682),(.2424,.1046,.9645),(.2439,.7266,-.6423),(.2442,.4618,-.8527),(.2451,-.9434,.2233),(.2454,-.9236,.2946),(.248,-.9291,-.2745),(.2482,.7602,.6004),(.2483,.3448,-.9052),(.2495,.4148,-.875),(.2513,-.2975,-.9211),(.2549,.2315,-.9389),(.2549,.3551,-.8994),(.2556,-.2495,-.934),(.2576,-.0055,-.9662),(.2584,.2359,.9368),(.2607,-.9491,-.1767),(.2621,-.965,.0015),(.2639,.8166,-.5134),(.2663,.8972,.3522),(.2686,.9111,-.3126),(.2709,-.9499,-.1557),(.2725,.7677,-.58),(.2736,-.6224,.7334),(.2739,.2171,.9369),(.2745,.8911,.3614),(.2765,-.9608,-.0198),(.2769,-.9522,.1287),(.2777,-.9119,.302),(.2791,-.3283,-.9024),(.2802,.4327,.8569),(.2802,.7581,.5889),(.2811,-.9589,.0384),(.2842,.0218,-.9585),(.2869,-.9307,.2269),(.2886,.7592,-.5833),(.2893,.2268,.93),(.2907,-.6608,.692),(.2908,-.0644,.9546),(.2921,.6701,.6824),(.2949,-.8415,.4526),(.2963,-.564,.7708),(.3033,-.6784,.6691),(.3036,-.4662,.8309),(.305,-.9349,.1816),(.3076,.2552,-.9166),(.3114,-.9389,.1467),(.3121,-.5004,.8076),(.3122,-.2516,-.9161),(.3127,-.8565,-.4107),(.3129,-.7575,.573),(.3143,-.5989,.7366),(.3148,.1447,.9381),(.3183,-.5858,.7453),(.3193,-.8797,-.3525),(.3198,.7124,-.6247),(.3202,-.5412,.7775),(.3229,.9387,.1211),(.3263,.9353,-.1366),(.3282,-.0689,.9421),(.329,.3088,-.8924),(.3292,-.9345,.1357),(.3303,-.454,.8275),(.3329,-.5333,.7777),(.3336,.9152,.2261),(.335,.0801,.9388),(.335,-.8242,.4565),(.3351,-.2328,.913),(.3353,-.7802,.528),(.3356,-.9412,-.0384),(.3378,.9403,-.0406),(.3403,-.045,.9392),(.3426,-.9385,-.0423),(.3426,.9336,-.1052),(.3429,-.9391,-.0228),(.343,-.6651,.6634),(.3455,.6818,-.6448),(.346,-.5431,.765),(.3468,-.8184,.4582),(.3477,-.7537,.5577),(.3488,.553,.7566),(.3497,-.5015,.7913),(.3518,-.6345,.6882),(.3543,.1056,.9292),(.3547,-.2061,.912),(.3562,-.0282,.934),(.3573,-.179,.9167),(.3578,.0219,.9335),(.358,-.9236,-.1372),(.3598,.8269,.4322),(.3619,.882,-.3018),(.3621,-.9312,-.041),(.3664,-.5654,.739),(.3717,.0793,.9249),(.3733,-.1539,.9148),(.3764,-.268,-.8868),(.3768,-.9117,-.1639),(.3792,.2883,-.8793),(.3826,-.3832,.8407),(.3849,-.2368,-.8921),(.386,.905,-.1788),(.3903,.8543,.3433),(.3927,.611,-.6874),(.393,-.2364,.8886),(.3946,.7906,-.4683),(.3948,-.5403,-.7431),(.3984,.5857,-.7058),(.3999,-.0648,.9143),(.4014,.8625,.3082),(.4014,-.3269,-.8556),(.4026,.9152,-.0175),(.4034,-.1824,.8966),(.4065,-.2862,.8676),(.4099,.7803,.4723),(.4106,-.832,-.3731),(.4128,.6315,.6564),(.4153,-.8753,.2479),(.4154,.7261,-.5479),(.4168,.7279,-.5445),(.4177,.9052,.0781),(.4182,-.7217,.5517),(.4184,-.8959,-.1492),(.4223,-.7704,.4777),(.4235,.8631,-.2751),(.427,.4679,-.7738),(.4312,.901,-.0487),(.4322,.1541,.8885),(.4332,.556,.7094),(.4341,-.895,.1027),(.4347,-.6144,.6584),(.4362,.8404,.3216),(.4364,-.8826,-.1751),(.4366,.5715,.6949),(.4383,-.4683,.7672),(.4398,-.2541,.8614),(.4407,-.8918,-.1024),(.4413,-.8954,-.059),(.4413,.8503,-.2868),(.443,.4275,.788),(.4434,.8354,-.3248),(.4434,-.8959,-.0275),(.4451,.2985,-.8443),(.4517,.0857,.888),(.4529,.1291,.8822),(.458,.8887,-.0229),(.4592,-.7212,.5186),(.4604,-.8875,-.0196),(.4606,-.8791,.1231),(.4618,.5883,-.6639),(.4641,.7758,-.4274),(.4649,-.5243,.7134),(.4698,.7902,-.3936),(.4722,.1687,-.8652),(.4724,-.8627,.1802),(.4731,-.8312,-.292),(.4734,-.4631,.7493),(.4784,-.3322,.8129),(.4787,-.8421,.2485),(.481,.849,.2188),(.4821,-.4732,-.7373),(.4853,-.3357,.8074),(.4876,.1687,.8566),(.4894,.4098,-.7698),(.4914,.011,.8708),(.4924,.7977,.3483),(.4939,.8099,.3164),(.4956,.6636,-.5604),(.498,-.7566,.4237),(.4987,.2075,-.8416),(.5007,-.8524,-.1507),(.5023,.3226,-.8023),(.5023,-.8272,.252),(.5026,-.0622,.8623),(.5044,.8531,.1332),(.5053,-.6764,-.5359),(.5091,-.7736,-.3773),(.5091,.116,-.8528),(.5114,.8407,.1782),(.512,-.0661,-.8564),(.5146,-.1852,-.8372),(.518,.4247,-.7425),(.5182,-.1268,.8458),(.5188,.7757,-.3594),(.5197,.0224,-.854),(.5209,.1861,.8331),(.5248,-.145,.8388),(.5274,-.5939,.6076),(.5307,-.1473,.8347),(.5316,.2039,-.8221),(.5322,.0801,.8429),(.5345,-.0931,-.84),(.5361,.7492,.3888),(.5386,-.3939,-.7448),(.5386,-.8397,-.0699),(.5427,.5934,-.5944),(.5441,-.4947,.6777),(.5448,.8358,-.0675),(.5462,-.6899,.475),(.5469,.3597,.756),(.5489,.6773,-.4898),(.5511,-.3906,-.7374),(.5526,.7137,-.4304),(.553,.4521,-.6998),(.5541,.3369,-.7612),(.5549,.5485,.6254),(.5565,-.018,.8306),(.5608,-.5505,.6184),(.5609,.1401,.816),(.5623,-.8179,.1214),(.5655,-.6625,-.4912),(.5695,-.25,.783),(.5697,-.1903,.7995),(.57,-.8115,-.1291),(.5712,-.4926,.6566),(.5755,.7755,.2596),(.5781,.1833,.7951),(.5783,.597,.556),(.5805,.2441,.7768),(.583,.7999,.1422),(.5851,-.7693,-.2566),(.5885,.1899,.7858),(.5913,-.3214,.7396),(.5927,-.4874,.6411),(.5934,.3376,-.7307),(.5955,.0264,.8029),(.5983,-.1799,.7808),(.6036,.7093,.3642),(.6036,-.7949,-.0625),(.6037,-.3376,-.7222),(.6058,.6166,.5028),(.6062,-.4963,-.6215),(.6065,.3409,-.7183),(.6075,-.7939,-.0279),(.6102,.0148,.7921),(.6119,.7861,-.0876),(.6134,.7351,.2887),(.6146,-.6655,-.4235),(.6151,-.6386,.4624),(.6182,.4536,-.642),(.6197,-.2095,-.7563),(.6204,-.7759,.1145),(.6222,.7828,.0055),(.6238,.1011,.775),(.6238,.2582,.7377),(.6238,-.6837,.3787),(.6265,-.7192,-.3004),(.6321,.6698,.3897),(.6321,.3176,-.7068),(.6334,-.5316,-.5623),(.6338,.67,.3867),(.6339,.5039,-.5867),(.6339,-.6824,-.364),(.6363,.2053,-.7436),(.6365,-.1986,-.7453),(.6378,.7493,-.178),(.6389,.6523,.4078),(.64,-.7277,.2468),(.6409,-.6992,-.3168),(.642,-.684,-.3464),(.6443,-.7472,.163),(.6471,-.4949,.5799),(.6513,.7167,.2493),(.658,-.0013,.753),(.6588,-.7511,.0421),(.6592,.0951,.7459),(.6629,.5137,-.5446),(.6634,.1913,.7234),(.6644,-.6866,-.2951),(.6654,.7397,.1005),(.6684,-.3833,.6374),(.6699,-.023,.7421),(.6705,.6681,.3227),(.6719,.1505,.7251),(.6759,-.7317,.0881),(.6811,.3031,-.6665),(.6815,.0675,.7287),(.6818,-.6121,-.4006),(.683,.4286,-.5914),(.6842,-.114,.7203),(.6849,.2467,.6856),(.6861,-.7268,.0327),(.6906,.1595,-.7054),(.6914,.4487,-.5662),(.6926,-.1045,-.7137),(.6933,.2453,.6776),(.6936,-.3695,.6183),(.6953,-.0159,.7185),(.6963,.034,-.7169),(.6964,.5981,-.3966),(.6993,.0134,.7147),(.7009,.4467,.556),(.7027,.6211,.347),(.7042,-.3295,.629),(.7072,-.0757,.7029),(.7078,.6062,.3626),(.7122,.1218,-.6913),(.7145,-.6959,-.0722),(.7162,.3382,.6105),(.7178,-.2014,-.6664),(.7227,.1668,-.6707),(.7228,-.4528,.5221),(.7236,.3998,-.5626),(.7243,.1689,.6685),(.7272,-.495,.4756),(.7314,.247,.6356),(.7332,-.3043,.6082),(.7333,-.6448,-.2158),(.738,-.1988,.6449),(.7398,.4554,.4952),(.7407,.4902,.4595),(.7442,.4107,-.5267),(.7447,.6285,.2244),(.7461,.3508,-.566),(.7484,-.41,-.5214),(.7522,-.4185,.5089),(.7524,-.6009,-.2699),(.7525,-.5932,-.2861),(.7528,.2863,-.5927),(.7528,-.611,.2448),(.7533,-.1953,.628),(.7565,-.3887,.526),(.7572,-.3683,-.5394),(.7638,-.0047,.6454),(.7654,.4522,.4579),(.7655,-.3923,.51),(.766,.6364,.0904),(.7666,.637,.0817),(.7684,.3787,-.5159),(.7698,-.4077,.4911),(.7708,-.6052,-.1992),(.7714,.0353,.6354),(.7721,-.423,.4742),(.7733,.2673,-.5749),(.7739,-.2506,.5817),(.7763,.459,-.4321),(.777,-.6127,.1443),(.778,.4877,.3961),(.7802,-.397,.4834),(.7835,-.4576,-.4204),(.7841,.3029,-.5417),(.7844,.5539,-.2791),(.7878,.209,-.5794),(.7895,.0071,.6138),(.7911,-.4049,-.4584),(.7913,.3746,.4832),(.7942,.0857,-.6016),(.7977,.498,-.3401),(.7987,.5992,.0556),(.8012,.2162,-.5579),(.8013,-.5138,-.3065),(.802,-.2965,.5186),(.805,-.0922,-.586),(.8075,-.2237,.5458),(.8111,.2158,.5437),(.8127,-.4142,.4098),(.8129,.5691,.1236),(.813,.5263,.2491),(.8137,.2239,-.5364),(.8143,.0038,.5804),(.8147,-.1474,.5609),(.8167,.0892,.5701),(.8168,-.3514,-.4575),(.8175,-.1661,.5514),(.8194,.1891,-.5411),(.8204,.5294,.216),(.8208,.0192,-.5709),(.823,-.0489,.5659),(.8237,.5581,.0997),(.8249,.0189,-.5649),(.8265,-.5536,.102),(.8272,.3172,-.4638),(.8287,-.3395,.445),(.8301,-.5383,.1451),(.8315,-.5269,.1761),(.8317,.0971,-.5467),(.8338,-.5488,-.0602),(.8375,.4097,.3616),(.838,.255,-.4824),(.839,-.5441,.0077),(.8391,.5383,.0779),(.8399,-.2827,.4633),(.8406,.2749,.4667),(.8427,-.1525,.5163),(.8466,-.3695,-.383),(.848,.2702,-.4559),(.8495,-.1617,-.5023),(.8503,.1943,-.4891),(.8528,-.0262,-.5216),(.8557,.378,.3534),(.8567,-.4754,.1999),(.8607,.4571,.2241),(.8614,-.5011,.0835),(.8624,.4658,-.1983),(.8658,-.4602,-.1964),(.8659,.0232,.4998),(.8661,-.0383,.4984),(.8665,-.4073,-.2887),(.8673,-.1817,-.4633),(.8713,-.0316,.4897),(.8719,.4448,-.2046),(.8737,-.1147,.4727),(.8753,.357,-.3262),(.8775,-.1843,.4428),(.8779,.1027,-.4678),(.8804,.0041,.4741),(.882,-.4649,.0769),(.8837,.3838,-.2679),(.8874,.4322,.1602),(.8893,.3596,.2827),(.8905,-.021,-.4545),(.8907,.4525,.0448),(.8922,-.2303,.3884),(.8953,.4453,-.0075),(.8957,.3095,-.3192),(.897,-.0555,-.4386),(.9,.0514,.4329),(.9024,.2314,-.3636),(.9026,.0339,.4291),(.9108,-.4115,.0345),(.913,-.0414,-.4058),(.9139,.3775,-.1494),(.9178,.3123,-.2451),(.9189,.2011,-.3394),(.9199,-.038,.3904),(.9206,-.3903,.0104),(.9236,-.325,.2034),(.9266,.3041,.2214),(.9276,.0141,.3733),(.9288,.3693,-.0303),(.93,-.2729,-.2463),(.9309,-.1199,.3451),(.9326,.3523,-.0787),(.9365,-.0327,.3491),(.9384,.3178,.1356),(.939,-.3011,-.1664),(.9392,-.0365,.3415),(.9397,.2773,.2003),(.9405,-.2748,-.1997),(.9425,.3258,-.0741),(.9429,-.3323,-.0213),(.9438,.1394,.2995),(.9468,.3173,-.0544),(.947,-.3042,-.1032),(.951,-.0688,.3014),(.9535,.217,.2092),(.9561,-.0221,.2921),(.9575,.2596,-.1259),(.9585,-.0924,-.2699),(.9593,-.1149,.2579),(.9624,-.2693,-.0371),(.9625,-.0014,-.2714),(.9631,.2277,-.1438),(.9662,-.0276,-.2562),(.9672,.2542,-.0012),(.9673,.2296,.1077),(.9711,.0246,-.2373),(.9744,-.2247,.0077),(.9768,.0592,.2059),(.9801,-.093,.1752),(.982,-.1324,.1345),(.9821,.1235,.1419),(.9854,.1696,.0117),(.9862,-.0521,-.1573),(.9866,.1241,-.1063),(.9876,-.094,-.1259),(.9877,.1442,.0597),(.9886,.148,-.028),(.9913,-.1141,-.0662),(.9973,-.0208,-.0702),(.9999,-.0018,.0122)]))),
      Shape(DEF='c5disc',
        appearance=Appearance(
          material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),shininess=0.050,specularColor=(.9647,.949,.9098))),
        geometry=IndexedFaceSet(DEF='c5disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,0,2,12,-1,13,14,15,-1,14,16,15,-1,17,18,19,-1,20,21,22,-1,23,14,24,-1,5,25,13,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,46,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,57,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,64,69,70,-1,71,72,73,-1,74,75,76,-1,77,78,79,-1,80,81,75,-1,82,83,84,-1,85,83,86,-1,87,88,89,-1,90,91,76,-1,92,93,94,-1,95,61,60,-1,96,97,8,-1,53,65,6,-1,98,99,100,-1,101,63,52,-1,102,89,103,-1,102,32,34,-1,102,103,32,-1,104,105,101,-1,53,52,63,-1,106,6,97,-1,107,108,96,-1,22,93,92,-1,19,109,110,-1,110,12,76,-1,89,102,86,-1,111,82,84,-1,112,113,114,-1,115,66,116,-1,7,117,118,-1,119,120,121,-1,122,71,123,-1,123,70,69,-1,124,125,126,-1,101,105,127,-1,128,11,10,-1,129,57,56,-1,56,41,129,-1,49,96,108,-1,130,95,131,-1,132,42,41,-1,48,133,44,-1,46,45,134,-1,50,135,51,-1,57,59,104,-1,136,137,138,-1,104,52,55,-1,139,39,38,-1,4,25,5,-1,140,36,35,-1,25,24,14,-1,44,28,27,-1,18,30,20,-1,141,142,143,-1,144,100,99,-1,20,19,18,-1,145,13,15,-1,146,147,29,-1,148,10,9,-1,149,79,78,-1,103,145,32,-1,8,97,6,-1,30,18,31,-1,91,90,150,-1,78,151,149,-1,15,32,145,-1,16,33,15,-1,99,33,144,-1,152,31,18,-1,27,153,44,-1,14,13,25,-1,140,154,36,-1,4,37,25,-1,139,155,39,-1,136,138,156,-1,104,55,57,-1,46,134,47,-1,48,44,46,-1,132,157,42,-1,131,50,130,-1,56,158,41,-1,128,107,11,-1,101,127,69,-1,8,11,107,-1,123,127,126,-1,123,69,127,-1,121,159,119,-1,160,161,9,-1,7,121,117,-1,74,12,2,-1,112,80,113,-1,83,82,112,-1,111,81,82,-1,111,98,90,-1,102,85,86,-1,91,110,76,-1,162,149,151,-1,151,163,162,-1,17,19,110,-1,22,164,93,-1,107,96,8,-1,165,17,110,-1,100,150,90,-1,63,65,53,-1,104,59,105,-1,59,166,105,-1,34,167,102,-1,89,168,103,-1,52,104,101,-1,100,90,98,-1,106,53,6,-1,150,165,91,-1,60,169,95,-1,19,163,109,-1,92,94,170,-1,76,111,90,-1,171,87,89,-1,171,89,86,-1,83,85,84,-1,112,172,83,-1,173,80,75,-1,76,12,74,-1,174,175,87,-1,73,119,71,-1,70,123,71,-1,70,159,64,-1,66,115,67,-1,8,7,118,-1,61,148,62,-1,176,177,135,-1,58,57,129,-1,108,130,49,-1,54,55,52,-1,178,179,158,-1,50,49,130,-1,47,169,48,-1,44,153,45,-1,41,43,129,-1,38,40,43,-1,35,37,4,-1,99,34,33,-1,32,15,33,-1,28,180,26,-1,13,145,5,-1,24,181,23,-1,20,30,21,-1,143,16,14,-1,12,110,0,-1,149,170,79,-1,11,160,9,-1,110,91,165,-1,182,49,51,-1,168,3,5,-1,58,166,59,-1,183,35,184,-1,140,35,183,-1,185,58,40,-1,185,166,58,-1,170,186,79,-1,170,94,186,-1,62,187,188,-1,189,187,62,-1,21,29,190,-1,21,30,29,-1,23,191,147,-1,23,181,191,-1,33,142,144,-1,16,142,33,-1,143,142,16,-1,21,164,22,-1,21,180,164,-1,190,192,26,-1,190,191,192,-1,193,194,195,-1,193,196,194,-1,24,37,195,-1,24,25,37,-1,139,140,155,-1,154,140,139,-1,138,157,156,-1,138,42,157,-1,134,197,198,-1,134,45,197,-1,106,182,199,-1,97,182,106,-1,47,200,131,-1,47,134,200,-1,136,201,202,-1,136,197,201,-1,177,178,203,-1,179,178,177,-1,158,132,41,-1,158,179,132,-1,204,205,188,-1,206,205,204,-1,63,69,64,-1,63,101,69,-1,207,116,208,-1,115,116,207,-1,123,125,122,-1,123,126,125,-1,122,72,71,-1,66,72,122,-1,209,210,211,-1,209,212,210,-1,211,213,214,-1,211,215,213,-1,161,189,9,-1,161,213,189,-1,64,121,7,-1,64,159,121,-1,216,210,217,-1,216,218,210,-1,217,173,219,-1,173,217,220,-1,221,114,113,-1,114,221,222,-1,87,172,174,-1,172,87,171,-1,109,151,1,-1,151,109,163,-1,84,102,167,-1,102,84,85,-1,223,204,224,-1,223,206,204,-1,92,20,22,-1,20,92,162,-1,206,48,205,-1,133,48,206,-1,167,99,98,-1,34,99,167,-1,3,89,88,-1,89,3,168,-1,183,207,225,-1,183,226,207,-1,124,227,208,-1,185,227,124,-1,130,61,95,-1,130,128,61,-1,228,206,223,-1,228,133,206,-1,93,224,94,-1,93,223,224,-1,84,98,111,-1,167,98,84,-1,170,162,92,-1,170,149,162,-1,68,175,174,-1,175,68,67,-1,171,83,172,-1,86,83,171,-1,114,172,112,-1,114,174,172,-1,210,220,217,-1,220,210,212,-1,229,217,219,-1,216,217,229,-1,186,77,79,-1,77,186,229,-1,78,74,2,-1,74,78,77,-1,215,189,213,-1,189,215,187,-1,161,214,213,-1,214,161,117,-1,73,212,209,-1,212,73,221,-1,159,71,119,-1,159,70,71,-1,226,115,207,-1,67,115,226,-1,6,64,7,-1,6,65,64,-1,135,131,200,-1,131,135,50,-1,230,132,176,-1,157,132,230,-1,178,55,54,-1,178,56,55,-1,178,158,56,-1,40,129,43,-1,58,129,40,-1,198,200,134,-1,200,198,230,-1,137,154,139,-1,137,231,154,-1,181,195,194,-1,195,181,24,-1,232,26,192,-1,27,26,232,-1,152,150,233,-1,152,165,150,-1,190,180,21,-1,26,180,190,-1,191,194,192,-1,181,194,191,-1,100,233,150,-1,100,144,233,-1,189,148,9,-1,189,62,148,-1,234,94,224,-1,94,234,186,-1,118,11,8,-1,118,160,11,-1,227,40,39,-1,227,185,40,-1,184,4,3,-1,184,35,4,-1,145,168,5,-1,103,168,145,-1,155,183,225,-1,183,155,140,-1,235,188,187,-1,235,204,188,-1,151,2,1,-1,2,151,78,-1,236,183,184,-1,236,226,183,-1,23,143,14,-1,141,143,23,-1,142,146,237,-1,142,141,146,-1,201,196,202,-1,196,201,232,-1,180,228,164,-1,180,28,228,-1,17,152,18,-1,17,165,152,-1,147,190,29,-1,190,147,191,-1,231,196,193,-1,231,202,196,-1,36,195,37,-1,195,36,193,-1,38,42,138,-1,43,42,38,-1,45,201,197,-1,45,153,201,-1,51,199,182,-1,199,51,203,-1,169,131,95,-1,131,169,47,-1,203,135,177,-1,135,203,51,-1,198,136,156,-1,136,198,197,-1,54,203,178,-1,54,199,203,-1,179,176,132,-1,176,179,177,-1,188,60,62,-1,205,60,188,-1,208,125,124,-1,116,125,208,-1,122,116,66,-1,122,125,116,-1,72,221,73,-1,72,222,221,-1,120,211,214,-1,120,209,211,-1,210,215,211,-1,218,215,210,-1,75,111,76,-1,81,111,75,-1,234,218,216,-1,234,235,218,-1,219,75,74,-1,75,219,173,-1,80,220,113,-1,220,80,173,-1,222,174,114,-1,222,68,174,-1,87,236,88,-1,87,175,236,-1,19,162,163,-1,19,20,162,-1,205,169,60,-1,48,169,205,-1,225,208,227,-1,225,207,208,-1,88,184,3,-1,88,236,184,-1,166,124,105,-1,166,185,124,-1,128,108,107,-1,130,108,128,-1,164,223,93,-1,164,228,223,-1,109,0,110,-1,109,1,0,-1,175,226,236,-1,175,67,226,-1,112,81,80,-1,81,112,82,-1,212,113,220,-1,212,221,113,-1,219,77,229,-1,219,74,77,-1,186,216,229,-1,186,234,216,-1,117,160,118,-1,117,161,160,-1,218,187,215,-1,187,218,235,-1,121,214,117,-1,121,120,214,-1,209,119,73,-1,209,120,119,-1,66,222,72,-1,222,66,68,-1,128,148,61,-1,128,10,148,-1,124,127,105,-1,124,126,127,-1,53,199,54,-1,53,106,199,-1,156,230,198,-1,156,157,230,-1,182,96,49,-1,96,182,97,-1,200,176,135,-1,200,230,176,-1,136,231,137,-1,202,231,136,-1,138,139,38,-1,138,137,139,-1,154,193,36,-1,231,193,154,-1,201,27,232,-1,153,27,201,-1,233,31,152,-1,233,237,31,-1,133,28,44,-1,133,228,28,-1,29,237,146,-1,29,31,237,-1,196,192,194,-1,196,232,192,-1,237,144,142,-1,144,237,233,-1,147,141,23,-1,147,146,141,-1,224,235,234,-1,224,204,235,-1,39,225,227,-1,225,39,155,-1],creaseAngle=1.571,normalIndex=[223,202,67,-1,201,178,196,-1,23,54,4,-1,89,34,6,-1,223,67,48,-1,184,191,221,-1,191,215,221,-1,230,218,213,-1,200,195,185,-1,205,191,174,-1,196,147,184,-1,167,154,152,-1,217,210,224,-1,232,231,235,-1,171,162,133,-1,91,51,42,-1,44,62,101,-1,129,87,81,-1,76,103,81,-1,19,25,13,-1,5,2,9,-1,8,21,16,-1,26,7,16,-1,58,56,88,-1,73,187,74,-1,93,130,128,-1,187,190,172,-1,66,78,98,-1,55,53,59,-1,57,80,164,-1,142,72,53,-1,63,86,46,-1,102,86,180,-1,186,197,203,-1,84,193,59,-1,181,177,155,-1,49,56,58,-1,18,1,4,-1,2,74,23,-1,79,236,233,-1,109,73,5,-1,198,203,211,-1,198,232,235,-1,198,211,232,-1,3,39,109,-1,2,5,73,-1,0,23,1,-1,30,24,18,-1,185,177,181,-1,213,207,225,-1,225,48,59,-1,203,198,180,-1,36,63,46,-1,170,143,159,-1,75,93,47,-1,54,182,148,-1,99,145,183,-1,68,66,156,-1,156,172,190,-1,32,52,64,-1,109,39,150,-1,37,6,34,-1,50,16,21,-1,21,44,50,-1,19,18,24,-1,35,49,40,-1,31,62,44,-1,103,132,129,-1,81,87,71,-1,25,20,13,-1,16,7,3,-1,104,92,82,-1,3,5,8,-1,83,51,91,-1,178,147,196,-1,116,162,171,-1,147,174,191,-1,129,152,154,-1,218,210,200,-1,219,229,214,-1,226,233,236,-1,200,213,218,-1,212,184,221,-1,220,209,217,-1,65,34,89,-1,204,164,80,-1,211,212,232,-1,4,1,23,-1,210,218,224,-1,193,84,234,-1,80,216,204,-1,221,232,212,-1,215,231,221,-1,236,231,226,-1,222,224,218,-1,154,120,129,-1,191,184,147,-1,116,123,162,-1,178,133,147,-1,83,69,51,-1,104,82,90,-1,3,8,16,-1,81,71,76,-1,103,129,81,-1,31,45,62,-1,40,25,35,-1,21,22,44,-1,37,30,6,-1,109,150,190,-1,4,6,30,-1,156,150,64,-1,156,190,150,-1,183,165,99,-1,151,179,89,-1,54,183,182,-1,55,48,67,-1,170,142,143,-1,86,63,170,-1,36,72,63,-1,36,79,84,-1,198,102,180,-1,193,225,59,-1,199,204,216,-1,216,206,199,-1,230,213,225,-1,185,176,177,-1,30,18,4,-1,237,230,225,-1,233,234,84,-1,73,74,2,-1,3,7,39,-1,7,27,39,-1,235,166,198,-1,203,208,211,-1,5,3,109,-1,233,84,79,-1,0,2,23,-1,234,237,193,-1,58,60,49,-1,213,206,207,-1,181,155,173,-1,59,36,84,-1,189,186,203,-1,189,203,180,-1,86,102,46,-1,170,169,86,-1,96,142,53,-1,59,48,55,-1,140,158,186,-1,98,99,66,-1,172,156,66,-1,172,165,187,-1,93,75,130,-1,4,54,148,-1,56,65,88,-1,28,15,20,-1,26,16,50,-1,24,35,19,-1,9,8,5,-1,10,17,22,-1,25,19,35,-1,76,60,103,-1,129,120,87,-1,44,101,50,-1,91,42,101,-1,171,133,178,-1,236,235,231,-1,232,221,231,-1,152,161,167,-1,184,212,196,-1,174,188,205,-1,200,210,195,-1,214,215,191,-1,48,225,223,-1,204,173,164,-1,6,151,89,-1,225,193,237,-1,14,19,13,-1,208,201,196,-1,26,27,7,-1,112,171,175,-1,116,171,112,-1,29,26,42,-1,29,27,26,-1,173,97,164,-1,173,155,97,-1,88,135,105,-1,144,135,88,-1,195,217,194,-1,195,210,217,-1,205,192,209,-1,205,188,192,-1,231,229,226,-1,215,229,231,-1,214,229,215,-1,195,176,185,-1,195,161,176,-1,194,160,167,-1,194,192,160,-1,139,153,163,-1,139,136,153,-1,174,133,163,-1,174,147,133,-1,83,116,69,-1,123,116,83,-1,82,45,90,-1,82,62,45,-1,71,94,77,-1,71,87,94,-1,0,14,12,-1,1,14,0,-1,76,41,40,-1,76,71,41,-1,104,119,121,-1,104,94,119,-1,15,10,11,-1,17,10,15,-1,22,31,44,-1,22,17,31,-1,125,100,105,-1,126,100,125,-1,73,190,187,-1,73,109,190,-1,70,47,38,-1,75,47,70,-1,156,52,68,-1,156,64,52,-1,68,78,66,-1,93,78,68,-1,108,117,127,-1,108,115,117,-1,127,146,157,-1,127,134,146,-1,179,144,89,-1,179,146,144,-1,187,183,54,-1,187,165,183,-1,107,117,110,-1,107,118,117,-1,110,96,85,-1,96,110,131,-1,114,159,143,-1,159,114,113,-1,186,169,140,-1,169,186,189,-1,207,216,202,-1,216,207,206,-1,46,198,166,-1,198,46,102,-1,141,125,138,-1,141,126,125,-1,181,200,185,-1,200,181,199,-1,126,103,100,-1,132,103,126,-1,166,236,79,-1,235,236,166,-1,201,203,197,-1,203,201,208,-1,112,70,61,-1,112,111,70,-1,32,33,38,-1,29,33,32,-1,35,56,49,-1,35,37,56,-1,137,126,141,-1,137,132,126,-1,177,138,155,-1,177,141,138,-1,46,79,36,-1,166,79,46,-1,173,199,181,-1,173,204,199,-1,128,158,140,-1,158,128,130,-1,189,86,169,-1,180,86,189,-1,159,169,170,-1,159,140,169,-1,117,131,110,-1,131,117,115,-1,95,110,85,-1,107,110,95,-1,97,57,164,-1,57,97,95,-1,80,55,67,-1,55,80,57,-1,134,144,146,-1,144,134,135,-1,179,157,146,-1,157,179,182,-1,98,115,108,-1,115,98,114,-1,165,66,99,-1,165,172,66,-1,111,75,70,-1,130,75,111,-1,23,187,54,-1,23,74,187,-1,20,40,41,-1,40,20,25,-1,43,31,28,-1,45,31,43,-1,10,8,9,-1,10,21,8,-1,10,22,21,-1,42,50,101,-1,26,50,42,-1,77,41,71,-1,41,77,43,-1,92,123,83,-1,92,122,123,-1,188,163,153,-1,163,188,174,-1,149,167,160,-1,154,167,149,-1,222,234,227,-1,222,237,234,-1,194,161,195,-1,167,161,194,-1,192,153,160,-1,188,153,192,-1,233,227,234,-1,233,226,227,-1,144,65,89,-1,144,88,65,-1,106,155,138,-1,155,106,97,-1,148,6,4,-1,148,151,6,-1,33,42,51,-1,33,29,42,-1,175,178,201,-1,175,171,178,-1,212,208,196,-1,211,208,212,-1,69,112,61,-1,112,69,116,-1,124,105,135,-1,124,125,105,-1,216,67,202,-1,67,216,80,-1,168,112,175,-1,168,111,112,-1,205,214,191,-1,219,214,205,-1,229,220,228,-1,229,219,220,-1,119,136,121,-1,136,119,149,-1,161,137,176,-1,161,152,137,-1,230,222,218,-1,230,237,222,-1,209,194,217,-1,194,209,192,-1,122,136,139,-1,122,121,136,-1,162,163,133,-1,163,162,139,-1,91,62,82,-1,101,62,91,-1,87,119,94,-1,87,120,119,-1,13,12,14,-1,12,13,11,-1,60,40,49,-1,40,60,76,-1,11,20,15,-1,20,11,13,-1,77,104,90,-1,104,77,94,-1,9,11,10,-1,9,12,11,-1,17,28,31,-1,28,17,15,-1,105,58,88,-1,100,58,105,-1,38,52,32,-1,47,52,38,-1,68,47,93,-1,68,52,47,-1,78,114,98,-1,78,113,114,-1,145,127,157,-1,145,108,127,-1,117,134,127,-1,118,134,117,-1,53,36,59,-1,72,36,53,-1,106,118,107,-1,106,124,118,-1,85,53,55,-1,53,85,96,-1,142,131,143,-1,131,142,96,-1,113,140,159,-1,113,128,140,-1,186,168,197,-1,186,158,168,-1,213,199,206,-1,213,200,199,-1,100,60,58,-1,103,60,100,-1,61,38,33,-1,61,70,38,-1,197,175,201,-1,197,168,175,-1,27,32,39,-1,27,29,32,-1,37,24,30,-1,35,24,37,-1,176,141,177,-1,176,137,141,-1,207,223,225,-1,207,202,223,-1,158,111,168,-1,158,130,111,-1,170,72,142,-1,72,170,63,-1,115,143,131,-1,115,114,143,-1,85,57,95,-1,85,55,57,-1,97,107,95,-1,97,106,107,-1,182,151,148,-1,182,179,151,-1,118,135,134,-1,135,118,124,-1,183,157,182,-1,183,145,157,-1,108,99,98,-1,108,145,99,-1,93,113,78,-1,113,93,128,-1,37,65,56,-1,37,34,65,-1,32,150,39,-1,32,64,150,-1,2,12,9,-1,2,0,12,-1,90,43,77,-1,90,45,43,-1,14,18,19,-1,18,14,1,-1,41,28,20,-1,41,43,28,-1,104,122,92,-1,121,122,104,-1,82,83,91,-1,82,92,83,-1,123,139,162,-1,122,139,123,-1,119,154,149,-1,120,154,119,-1,227,224,222,-1,227,228,224,-1,132,152,129,-1,132,137,152,-1,217,228,220,-1,217,224,228,-1,136,160,153,-1,136,149,160,-1,228,226,229,-1,226,228,227,-1,209,219,205,-1,209,220,219,-1,138,124,106,-1,138,125,124,-1,51,61,33,-1,61,51,69,-1],
          coord=Coordinate(DEF='c5disc_Coord',point=[(.36761,53.39464,-1.20697),(.36172,53.39094,-1.20919),(.35549,53.3918,-1.20656),(.21867,53.11637,-.77273),(.21548,53.10974,-.78514),(.27812,53.13169,-.81766),(-.38467,53.3772,-1.005),(-.3756,53.39185,-1.03517),(-.38196,53.39062,-1.13309),(-.29275,53.36783,-1.26494),(-.29441,53.36302,-1.26538),(-.35363,53.38834,-1.21808),(.36612,53.39071,-1.15259),(.33064,53.16346,-.87776),(.3128,53.19157,-.91986),(.34045,53.17208,-.88105),(.32465,53.19867,-.91701),(.38522,53.38868,-1.10599),(.33954,53.34176,-1.12005),(.3377,53.36867,-1.16526),(.28214,53.34041,-1.22714),(.21705,53.25802,-1.14806),(.2107,53.32167,-1.22544),(.29111,53.21212,-.95727),(.25736,53.15516,-.87728),(.26815,53.13768,-.83376),(.15178,53.20794,-1.06964),(.08072,53.19635,-1.07228),(.07405,53.2385,-1.1493),(.2935,53.26666,-1.06172),(.27922,53.29603,-1.13256),(.32668,53.30337,-1.04082),(.34703,53.17149,-.8433),(.35785,53.24323,-.89434),(.37086,53.24444,-.86221),(.11547,53.08989,-.75634),(.10699,53.10384,-.80274),(.21318,53.12383,-.80371),(-.21318,53.12383,-.80371),(-.21548,53.10974,-.78514),(-.27812,53.13169,-.81766),(-.3128,53.19157,-.91986),(-.25736,53.15516,-.87728),(-.26815,53.13768,-.83376),(0,53.22053,-1.14741),(-.08072,53.19635,-1.07228),(-.07405,53.2385,-1.1493),(-.14389,53.24003,-1.15015),(-.06749,53.27947,-1.22579),(-.33954,53.34176,-1.12005),(-.27922,53.29603,-1.13256),(-.32668,53.30337,-1.04082),(-.38299,53.29899,-.88368),(-.38336,53.32798,-.9204),(-.36218,53.29839,-.92219),(-.35785,53.24323,-.89434),(-.32465,53.19867,-.91701),(-.34045,53.17208,-.88105),(-.33827,53.15679,-.85154),(-.34781,53.17045,-.8437),(-.15234,53.30584,-1.24117),(-.23442,53.33602,-1.24066),(-.18852,53.34215,-1.27608),(-.37472,53.31915,-.89757),(-.34918,53.34687,-.94536),(-.37053,53.34225,-.93199),(-.08824,53.23308,-.80471),(0,53.20377,-.70399),(0,53.2291,-.81173),(-.33728,53.28186,-.88121),(-.26309,53.27414,-.92063),(-.19005,53.26943,-.89975),(-.09677,53.28678,-.88255),(-.10451,53.32063,-.9648),(.27363,53.37313,-1.15213),(.26688,53.34937,-1.05501),(.3756,53.39185,-1.03517),(.27646,53.36587,-1.22068),(.3387,53.38589,-1.21863),(.29275,53.36783,-1.26494),(.19044,53.32058,-.9737),(.25761,53.30357,-.96931),(.26309,53.27414,-.92063),(.25313,53.24198,-.88285),(.33728,53.28186,-.88121),(.29379,53.23894,-.82376),(.2423,53.20534,-.78129),(.15636,53.19768,-.73404),(.17106,53.18136,-.73829),(.24852,53.19445,-.77856),(.36727,53.35211,-.93697),(.38185,53.39195,-1.03429),(.23156,53.33429,-1.23882),(.15391,53.30799,-1.24337),(.18852,53.34216,-1.27607),(-.2107,53.32167,-1.22544),(-.37149,53.37457,-1.11021),(-.38717,53.3714,-1.02809),(.36307,53.32265,-.91144),(.37637,53.27698,-.88358),(.38658,53.33248,-.92013),(-.35024,53.27667,-.87065),(.30145,53.23214,-.81972),(.33639,53.16389,-.83793),(-.37242,53.24481,-.86127),(-.30161,53.23182,-.8198),(-.38674,53.35245,-.97287),(-.35011,53.38361,-1.20331),(-.3377,53.36867,-1.16526),(.35664,53.38458,-1.19199),(.38434,53.39754,-1.13647),(.34918,53.34687,-.94536),(.19005,53.26943,-.89975),(.10451,53.32063,-.9648),(.09677,53.28678,-.88255),(-.07381,53.20011,-.70671),(-.15636,53.19768,-.73404),(-.27363,53.37313,-1.15213),(-.36459,53.39042,-1.15258),(-.19044,53.32058,-.9737),(-.1992,53.34425,-1.06448),(-.26688,53.34937,-1.05501),(-.17517,53.23483,-.84533),(-.25313,53.24198,-.88285),(-.2469,53.19752,-.77711),(-.23773,53.20425,-.77729),(-.2423,53.20534,-.78129),(-.29379,53.23894,-.82376),(-.28909,53.35053,-1.24127),(-.33064,53.16346,-.87776),(-.28214,53.34041,-1.22714),(-.21705,53.25802,-1.14806),(-.29111,53.21212,-.95727),(0,53.27448,-1.22045),(-.15178,53.20794,-1.06964),(-.2935,53.26666,-1.06172),(-.08594,53.16508,-.94824),(-.09492,53.13594,-.87845),(-.18906,53.14679,-.87666),(-.10699,53.10384,-.80274),(0,53.07409,-.76564),(.30215,53.22169,-.95506),(.32718,53.25233,-.94051),(.31974,53.20493,-.9265),(.36218,53.29839,-.92219),(.33827,53.15679,-.85154),(.29862,53.24593,-1.00619),(.28831,53.23726,-1.00857),(-.28129,53.36033,-1.26694),(.29459,53.3631,-1.26523),(.39546,53.36417,-.97208),(.34574,53.38414,-1.22108),(.37127,53.35276,-1.02723),(0,53.19506,-1.06837),(0,53.09517,-.8043),(-.11547,53.08989,-.75634),(-.16789,53.16526,-.95161),(-.23666,53.17961,-.95253),(-.31974,53.20493,-.9265),(-.25761,53.30357,-.96931),(-.34639,53.38837,-1.21837),(-.27646,53.36587,-1.22068),(.29028,53.35226,-1.2437),(.34572,53.37944,-1.19574),(.14317,53.29326,-1.22826),(.39317,53.37843,-1.02842),(-.33639,53.16389,-.83793),(.35081,53.276,-.87037),(.2802,53.13928,-.80693),(-.14317,53.29326,-1.22826),(.2814,53.36032,-1.26694),(.23773,53.20425,-.77729),(.17517,53.23483,-.84533),(.1992,53.34425,-1.06448),(.08824,53.23308,-.80471),(.07381,53.20011,-.70671),(-.28831,53.23726,-1.00857),(-.29862,53.24593,-1.00619),(-.32718,53.25233,-.94051),(-.30215,53.22169,-.95506),(.14389,53.24003,-1.15015),(.23666,53.17961,-.95253),(-.37127,53.35276,-1.02723),(0,53.08494,-.74888),(.11599,53.09742,-.7418),(-.28021,53.13928,-.80692),(.18731,53.35035,-1.27367),(-.1124,53.34282,-1.26731),(-.11209,53.3319,-1.27033),(-.18731,53.35035,-1.27367),(.22179,53.22626,-1.07451),(.22968,53.19991,-1.0065),(.15983,53.1866,-1.01063),(.09492,53.13594,-.87845),(.16789,53.16526,-.95161),(.18906,53.14679,-.87666),(.08594,53.16508,-.94824),(-.08364,53.17879,-1.00675),(-.15983,53.1866,-1.01063),(-.36673,53.32557,-.97471),(-.22179,53.22626,-1.07451),(0,53.17494,-1.00723),(0,53.15747,-.94927),(-.3327,53.28351,-.98669),(0,53.33403,-1.28382),(-.07681,53.29327,-1.23817),(0,53.28577,-1.23248),(-.08243,53.18356,-.70848),(-.17044,53.18231,-.73782),(-.11465,53.34249,-1.06903),(0,53.35724,-1.15751),(-.11808,53.35318,-1.15724),(0,53.35242,-1.07689),(-.20144,53.3582,-1.21928),(-.20492,53.35887,-1.15261),(-.11496,53.35551,-1.21971),(.11496,53.35551,-1.21971),(.11808,53.35318,-1.15724),(0,53.35182,-1.23148),(.20492,53.35887,-1.15261),(.11465,53.34249,-1.06903),(0,53.33002,-.97959),(0,53.28446,-.87879),(.07818,53.2953,-1.23999),(.11209,53.3319,-1.27033),(-.11599,53.09742,-.7418),(0,53.18185,-.70818),(-.21868,53.11637,-.77273),(.06749,53.27947,-1.22579),(.20144,53.3582,-1.21928),(-.22968,53.19991,-1.0065),(0,53.12977,-.87191),(.08364,53.17879,-1.00675),(.36673,53.32557,-.97471),(.1124,53.34282,-1.26731),(0,53.34358,-1.28075),(.08385,53.17961,-.70998),(.3327,53.28351,-.98669)]),
          normal=Normal(vector=[(-.9934,-.1145,.0058),(-.9816,-.1692,-.0884),(-.9664,.1983,.1634),(-.9139,.0127,.4057),(-.8938,.3606,-.2667),(-.852,.2113,.479),(-.8337,.2804,-.4757),(-.8293,-.3412,.4426),(-.8275,-.3064,-.4705),(-.8042,-.4704,-.3633),(-.7913,-.4251,-.4395),(-.788,-.552,-.2726),(-.7838,-.5744,-.2362),(-.757,-.5954,-.2692),(-.7504,-.6285,-.2048),(-.7221,-.6168,-.3133),(-.6999,-.5458,-.4608),(-.6993,-.519,-.4915),(-.6982,-.6855,-.2063),(-.6904,-.6639,-.2875),(-.6678,-.651,-.3608),(-.6504,-.4501,-.6118),(-.6488,-.4364,-.6234),(-.6337,.7087,.3101),(-.609,-.7439,-.2752),(-.5979,-.7227,-.3468),(-.5973,-.8018,-.0181),(-.5893,-.396,.7042),(-.5698,-.7352,-.3671),(-.5639,-.4729,.6771),(-.5271,-.8359,-.1532),(-.4967,-.7313,-.4675),(-.456,.2174,.863),(-.4489,-.5639,.6932),(-.4482,-.3892,-.8047),(-.4428,-.7953,-.414),(-.4286,.7754,.4637),(-.426,-.8399,-.3363),(-.3928,-.0293,.9192),(-.387,.3849,.8379),(-.3601,-.808,-.4663),(-.3581,-.8534,-.3788),(-.3387,-.9408,.0117),(-.3384,-.8627,-.3758),(-.3292,-.7329,-.5954),(-.3078,-.8812,-.359),(-.2921,.7461,.5984),(-.2889,.5825,.7598),(-.2852,.9577,.0387),(-.2834,-.8169,-.5024),(-.2768,-.8281,-.4874),(-.2623,-.961,-.0873),(-.2568,.7479,.6121),(-.2481,.9291,.2745),(-.2417,.9518,.1889),(-.2407,.9698,.0391),(-.2358,-.8609,-.4508),(-.2181,.9734,-.0704),(-.2001,-.7657,-.6113),(-.199,.957,.211),(-.1943,-.7743,-.6023),(-.1925,-.6206,.7602),(-.1882,-.9018,-.3891),(-.1819,.7946,.5792),(-.1796,.8012,.5708),(-.1779,-.443,-.8787),(-.1777,.8155,.5508),(-.1716,.965,-.1981),(-.1702,.8735,.4562),(-.1689,-.9783,.1197),(-.1646,-.1607,.9732),(-.1596,-.9151,-.3704),(-.1496,.8516,.5025),(-.1397,.7356,.6628),(-.1317,.8486,.5124),(-.1275,.5252,.8414),(-.1273,-.8796,-.4583),(-.1265,-.9308,-.3428),(-.1264,.8639,.4875),(-.126,.6484,.7508),(-.1252,.9482,-.292),(-.1207,-.8765,-.4661),(-.1197,-.9347,-.3348),(-.1173,-.9221,-.3688),(-.1159,.816,.5664),(-.1148,.9905,.0754),(-.1142,.862,.4939),(-.1115,-.9266,-.3592),(-.1113,-.3249,-.9392),(-.0936,.7064,-.7016),(-.0868,-.9481,-.3058),(-.0822,-.8676,-.4905),(-.0792,-.912,-.4026),(-.0777,.8969,.4354),(-.0761,-.9638,-.2555),(-.0745,.9954,-.0599),(-.0721,.978,.1957),(-.0713,.7338,-.6756),(-.0711,.9397,.3346),(-.0711,.8996,.4309),(-.0696,-.6949,-.7158),(-.0668,-.9146,-.3989),(-.066,.8244,.5622),(-.0648,-.7701,-.6346),(-.0561,-.95,-.3072),(-.0487,-.2732,-.9607),(-.0329,.7237,-.6894),(-.0267,.9943,-.1033),(-.0214,.986,.1656),(-.0147,.6104,.792),(-.0082,.9969,.0786),(0,-.2842,.9588),(0,-.6581,.7529),(0,.8587,.5125),(0,.9528,.3037),(0,.9908,.1353),(0,-.9994,.0347),(0,.9997,.0234),(0,.9909,-.1349),(0,-.9606,-.2778),(0,-.9508,-.3097),(0,-.9497,-.3132),(0,-.9114,-.4116),(0,-.8903,-.4554),(0,.7376,-.6752),(.0001,-.223,-.9748),(.0005,-.7241,-.6897),(.0082,.9969,.0786),(.0108,.8869,.4618),(.0135,-.8771,-.4801),(.0181,.5401,.8414),(.0214,.986,.1656),(.0224,-.7835,-.6209),(.0242,-.8782,-.4777),(.0267,.9943,-.1033),(.0329,.7236,-.6894),(.0386,-.9463,-.321),(.0482,-.7841,-.6188),(.0483,-.2716,-.9612),(.0623,-.9207,-.3853),(.0655,.8928,.4456),(.0697,-.6947,-.7159),(.0711,.8996,.4309),(.0711,.9397,.3346),(.0713,.734,-.6754),(.0721,.978,.1957),(.0745,.9954,-.0599),(.0751,-.9057,-.4172),(.0759,.9971,-.0111),(.0761,-.9638,-.2555),(.0858,.8115,.5781),(.0962,.9762,-.1944),(.1,-.8698,-.4832),(.1059,-.9385,-.3288),(.1115,-.9266,-.3592),(.1123,-.3272,-.9382),(.1142,.862,.4939),(.1148,.9905,.0754),(.1167,.5225,.8446),(.1264,.8639,.4875),(.1265,-.9308,-.3428),(.1273,-.8796,-.4583),(.1326,-.9234,-.3601),(.1332,-.9363,-.3248),(.1395,.7041,-.6963),(.1496,.8516,.5025),(.1539,.6385,.7541),(.1596,-.9151,-.3704),(.1639,-.1913,.9677),(.1702,.8735,.4562),(.1777,.8155,.5508),(.1816,-.9775,.107),(.1819,.7946,.5792),(.1833,-.4454,-.8764),(.1882,-.9018,-.3891),(.1925,-.6206,.7601),(.1936,-.7739,-.603),(.1982,-.7654,-.6123),(.2085,-.9729,-.0998),(.2181,.9734,-.0704),(.2347,.7489,.6197),(.2369,-.8603,-.4515),(.2388,.9703,.0382),(.2481,.9291,.2745),(.275,-.8326,-.4808),(.2801,-.8146,-.5078),(.2853,.5716,.7694),(.2987,.8283,.4739),(.3078,-.8812,-.359),(.3081,.7038,.6401),(.3224,.7441,.5851),(.3229,-.7312,-.6009),(.3384,-.8627,-.3758),(.3524,.9176,.1837),(.3581,-.8534,-.3788),(.3601,-.808,-.4663),(.3611,-.9324,.0151),(.3869,-.0476,.9209),(.3906,.4082,.8251),(.4294,-.8397,-.3325),(.4425,-.7953,-.4145),(.4489,-.5637,.6933),(.4719,-.1226,-.8731),(.4848,.1307,.8648),(.488,-.3694,-.7908),(.4967,-.7313,-.4675),(.4999,-.8507,-.1627),(.532,-.836,-.1346),(.5639,-.473,.677),(.5698,-.7352,-.3671),(.5979,-.7227,-.3468),(.6034,-.3938,.6934),(.6186,-.7856,-.0153),(.6465,-.7162,-.2628),(.6488,-.4364,-.6234),(.6525,-.4396,-.6172),(.6526,.042,-.7566),(.6678,-.651,-.3608),(.6904,-.6639,-.2875),(.6993,-.519,-.4915),(.7221,-.6168,-.3133),(.7339,-.5255,-.4304),(.7527,-.6271,-.2005),(.7537,.397,-.5238),(.757,-.5954,-.2692),(.7574,.5071,-.4112),(.7832,-.4789,-.3965),(.7839,-.5743,-.2359),(.788,-.552,-.2726),(.7913,-.4251,-.4395),(.8075,-.5568,-.195),(.8298,-.3299,-.4501),(.8452,-.293,.4469),(.8489,.1929,.492),(.9154,.3471,.2039),(.9189,.0004,.3945),(.9521,.1342,.2747),(.9987,.0322,-.0398)]))),
      Shape(DEF='c6',
        appearance=Appearance(
          material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),shininess=0.050,specularColor=(.349,.349,.349))),
        geometry=IndexedFaceSet(DEF='c6_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,11,30,31,-1,11,32,30,-1,33,34,35,-1,36,37,38,-1,37,36,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,57,59,-1,14,60,61,-1,62,63,64,-1,65,66,67,-1,68,66,65,-1,69,70,71,-1,72,73,74,-1,75,76,77,-1,78,79,80,-1,81,82,83,-1,84,83,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,36,-1,103,104,61,-1,105,106,107,-1,108,109,110,-1,110,111,108,-1,112,113,114,-1,108,115,109,-1,116,117,118,-1,119,120,121,-1,122,123,124,-1,125,126,96,-1,127,128,129,-1,130,14,13,-1,106,131,132,-1,133,134,135,-1,54,136,137,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,147,148,149,-1,150,148,27,-1,151,152,153,-1,154,155,156,-1,157,158,159,-1,160,161,162,-1,163,164,165,-1,166,167,168,-1,109,169,110,-1,170,142,171,-1,143,142,170,-1,172,173,9,-1,174,175,63,-1,176,177,178,-1,179,180,181,-1,182,183,184,-1,15,185,186,-1,187,188,189,-1,190,191,192,-1,193,183,182,-1,194,195,196,-1,197,191,190,-1,198,199,200,-1,46,201,62,-1,180,202,203,-1,180,204,205,-1,206,207,208,-1,209,210,160,-1,26,25,211,-1,212,213,214,-1,215,216,217,-1,218,219,220,-1,221,222,223,-1,224,225,158,-1,226,227,228,-1,229,102,55,-1,39,230,231,-1,232,233,52,-1,234,235,236,-1,237,238,239,-1,240,241,242,-1,243,244,245,-1,246,247,248,-1,249,250,251,-1,252,253,254,-1,255,256,129,-1,257,128,12,-1,258,259,260,-1,261,262,263,-1,92,264,265,-1,81,83,86,-1,266,267,268,-1,198,200,11,-1,269,270,271,-1,272,270,269,-1,273,274,275,-1,276,277,38,-1,278,279,280,-1,281,282,283,-1,284,122,285,-1,286,287,288,-1,122,78,285,-1,289,124,290,-1,291,292,293,-1,294,127,295,-1,296,130,297,-1,298,299,300,-1,301,302,284,-1,303,304,305,-1,306,307,308,-1,309,310,311,-1,312,313,314,-1,315,217,216,-1,218,316,26,-1,317,318,216,-1,319,220,320,-1,320,321,322,-1,223,323,324,-1,216,8,317,-1,325,326,152,-1,327,236,328,-1,329,330,331,-1,332,333,334,-1,335,336,332,-1,337,338,339,-1,338,340,341,-1,342,343,344,-1,345,346,347,-1,348,349,350,-1,351,352,353,-1,354,42,355,-1,356,357,358,-1,257,359,360,-1,58,361,362,-1,363,364,365,-1,366,361,364,-1,367,368,369,-1,370,371,372,-1,227,226,373,-1,374,375,68,-1,95,376,377,-1,378,379,76,-1,197,380,381,-1,382,383,94,-1,384,385,386,-1,387,388,389,-1,390,391,387,-1,345,392,393,-1,45,394,395,-1,243,396,397,-1,398,384,246,-1,399,400,401,-1,402,403,404,-1,405,406,64,-1,19,240,407,-1,408,409,410,-1,47,411,48,-1,234,20,407,-1,412,413,235,-1,414,415,416,-1,105,417,418,-1,419,240,245,-1,420,421,422,-1,120,423,144,-1,424,425,426,-1,427,7,428,-1,429,430,431,-1,432,433,434,-1,435,436,437,-1,438,439,440,-1,441,442,443,-1,444,445,446,-1,447,448,449,-1,450,451,452,-1,453,454,455,-1,454,456,455,-1,457,458,459,-1,460,461,462,-1,463,464,465,-1,466,467,468,-1,469,470,471,-1,472,473,474,-1,475,476,477,-1,478,479,460,-1,480,481,482,-1,483,484,485,-1,486,487,488,-1,484,489,490,-1,491,492,493,-1,494,492,491,-1,491,495,496,-1,497,498,499,-1,500,501,502,-1,503,504,505,-1,506,507,508,-1,509,510,511,-1,512,503,513,-1,514,515,516,-1,517,518,519,-1,520,521,522,-1,458,523,524,-1,525,526,527,-1,528,529,530,-1,531,532,533,-1,534,535,536,-1,537,538,539,-1,540,541,542,-1,543,533,544,-1,545,546,1,-1,547,548,549,-1,550,551,552,-1,553,554,555,-1,556,557,558,-1,559,560,561,-1,562,563,564,-1,565,566,567,-1,566,568,569,-1,570,566,571,-1,572,6,559,-1,573,574,575,-1,576,577,578,-1,579,580,581,-1,582,583,584,-1,585,586,587,-1,582,584,588,-1,589,590,591,-1,592,593,594,-1,595,596,588,-1,597,598,599,-1,600,601,602,-1,603,604,605,-1,606,607,3,-1,608,609,610,-1,611,612,613,-1,614,615,616,-1,617,618,619,-1,620,621,622,-1,602,601,619,-1,623,624,625,-1,626,627,280,-1,628,629,630,-1,631,632,275,-1,633,513,503,-1,634,635,636,-1,637,638,639,-1,634,640,641,-1,642,643,644,-1,645,646,647,-1,648,649,650,-1,651,652,653,-1,518,654,655,-1,656,657,519,-1,658,659,660,-1,661,662,663,-1,664,461,665,-1,666,667,668,-1,669,450,670,-1,671,430,429,-1,672,673,432,-1,624,628,674,-1,675,676,677,-1,678,679,680,-1,516,498,500,-1,681,682,683,-1,684,685,686,-1,562,687,685,-1,571,688,575,-1,565,689,690,-1,691,692,559,-1,557,693,694,-1,573,695,696,-1,568,697,698,-1,699,436,700,-1,446,701,702,-1,703,701,445,-1,704,705,706,-1,707,435,708,-1,635,709,710,-1,711,706,712,-1,713,714,715,-1,716,717,718,-1,640,719,720,-1,448,467,721,-1,713,722,723,-1,724,722,702,-1,725,726,727,-1,728,729,730,-1,662,441,725,-1,731,732,733,-1,734,704,731,-1,735,443,442,-1,736,737,738,-1,595,739,740,-1,741,742,743,-1,744,562,685,-1,745,746,747,-1,557,748,749,-1,750,751,752,-1,753,754,752,-1,755,593,756,-1,732,757,758,-1,759,760,761,-1,762,763,675,-1,469,471,764,-1,765,766,767,-1,768,608,610,-1,769,770,771,-1,553,772,773,-1,553,774,772,-1,539,775,536,-1,776,777,778,-1,779,780,781,-1,782,783,679,-1,784,785,786,-1,645,487,787,-1,788,789,790,-1,643,791,792,-1,426,793,644,-1,495,794,496,-1,795,791,796,-1,539,536,535,-1,502,797,798,-1,799,800,801,-1,785,802,786,-1,803,728,730,-1,804,672,805,-1,806,5,807,-1,808,809,810,-1,811,810,678,-1,812,813,676,-1,669,805,814,-1,815,816,504,-1,817,818,440,-1,819,664,820,-1,821,822,527,-1,782,628,630,-1,630,783,782,-1,823,824,825,-1,28,826,751,-1,573,579,827,-1,828,2,553,-1,804,438,829,-1,448,830,449,-1,704,734,831,-1,584,590,595,-1,497,501,500,-1,832,833,834,-1,832,777,776,-1,835,836,837,-1,838,826,28,-1,839,840,841,-1,808,674,809,-1,453,842,454,-1,482,843,819,-1,844,456,454,-1,845,846,847,-1,543,818,848,-1,815,504,512,-1,849,850,801,-1,851,852,786,-1,853,763,637,-1,854,714,648,-1,855,624,674,-1,856,587,857,-1,857,587,858,-1,669,438,804,-1,859,860,786,-1,861,862,863,-1,864,797,501,-1,849,800,865,-1,866,867,868,-1,869,870,871,-1,872,796,873,-1,495,874,861,-1,494,875,876,-1,642,796,791,-1,873,796,877,-1,644,643,426,-1,463,646,645,-1,784,860,770,-1,786,802,878,-1,879,789,792,-1,880,596,740,-1,881,882,835,-1,551,550,539,-1,883,884,885,-1,536,531,886,-1,549,2,1,-1,587,586,858,-1,769,615,887,-1,653,888,889,-1,608,768,4,-1,610,656,890,-1,891,892,893,-1,704,757,731,-1,894,895,896,-1,647,897,898,-1,899,900,485,-1,901,636,635,-1,902,455,456,-1,555,554,903,-1,752,754,556,-1,750,691,904,-1,556,754,748,-1,905,567,906,-1,907,742,698,-1,737,908,738,-1,607,909,910,-1,613,911,912,-1,613,612,911,-1,735,442,913,-1,894,914,915,-1,661,915,914,-1,700,704,845,-1,733,916,917,-1,436,699,803,-1,661,464,788,-1,790,789,913,-1,918,919,920,-1,921,662,725,-1,708,730,919,-1,850,500,799,-1,445,444,922,-1,854,715,714,-1,717,716,720,-1,641,923,711,-1,924,919,729,-1,925,921,874,-1,636,926,719,-1,490,927,928,-1,929,930,854,-1,854,650,929,-1,441,707,708,-1,730,435,437,-1,705,449,712,-1,931,703,896,-1,847,846,720,-1,435,707,848,-1,932,933,697,-1,690,689,428,-1,575,688,934,-1,935,742,936,-1,937,689,687,-1,685,684,744,-1,938,514,939,-1,816,476,475,-1,630,629,940,-1,941,432,942,-1,943,944,945,-1,429,946,947,-1,669,668,450,-1,451,842,453,-1,948,949,950,-1,475,764,471,-1,951,952,470,-1,953,954,955,-1,791,956,879,-1,907,933,957,-1,519,518,890,-1,869,958,870,-1,649,520,650,-1,900,899,487,-1,853,959,866,-1,960,488,901,-1,961,828,745,-1,811,503,808,-1,868,962,963,-1,964,631,274,-1,965,966,632,-1,967,823,675,-1,968,969,970,-1,971,625,627,-1,972,973,555,-1,974,956,785,-1,975,976,977,-1,908,737,978,-1,979,883,980,-1,981,982,614,-1,983,616,615,-1,611,610,609,-1,606,856,857,-1,593,903,756,-1,586,588,596,-1,984,985,986,-1,586,585,987,-1,806,856,5,-1,988,827,579,-1,583,989,591,-1,692,558,990,-1,690,7,6,-1,991,568,570,-1,906,686,905,-1,742,935,992,-1,686,906,993,-1,687,686,685,-1,560,6,8,-1,749,994,995,-1,996,673,0,-1,997,548,547,-1,829,545,0,-1,998,546,545,-1,541,533,532,-1,534,999,1000,-1,1001,1002,1003,-1,1001,1004,1002,-1,527,822,524,-1,681,472,521,-1,808,505,1005,-1,1006,1007,511,-1,955,509,1008,-1,1009,1010,509,-1,498,497,500,-1,876,875,798,-1,1011,859,852,-1,1012,495,491,-1,484,490,926,-1,487,486,1013,-1,1014,481,480,-1,1015,1016,478,-1,1017,473,472,-1,683,1018,927,-1,952,479,478,-1,913,1000,999,-1,459,1019,821,-1,1020,454,842,-1,667,1021,1022,-1,479,917,665,-1,470,705,831,-1,914,894,1023,-1,915,803,895,-1,804,805,669,-1,758,438,732,-1,1024,848,818,-1,432,805,672,-1,1025,433,1026,-1,961,947,1027,-1,814,1028,666,-1,773,756,903,-1,84,421,93,-1,7,427,1029,-1,1030,1031,239,-1,1032,1033,235,-1,46,1034,1035,-1,408,410,18,-1,1036,1037,143,-1,206,64,406,-1,1038,201,110,-1,1039,1040,205,-1,15,1041,399,-1,1042,242,1037,-1,394,243,1043,-1,1044,1045,248,-1,385,1046,386,-1,1047,91,90,-1,1048,1049,186,-1,133,1050,399,-1,1051,1052,358,-1,1053,1054,1055,-1,387,385,384,-1,385,1056,372,-1,1057,1058,1046,-1,1059,352,1060,-1,1061,381,1062,-1,383,1063,94,-1,1064,381,1065,-1,378,1066,1067,-1,379,1067,1068,-1,1069,76,379,-1,373,1070,227,-1,226,1071,67,-1,271,1072,50,-1,1056,366,1073,-1,371,370,369,-1,1074,367,1075,-1,1076,369,1077,-1,1078,1079,257,-1,357,356,1080,-1,1044,42,354,-1,354,350,1044,-1,353,348,354,-1,111,1081,108,-1,1082,117,346,-1,331,330,343,-1,111,341,340,-1,338,1083,1084,-1,339,1084,1085,-1,1086,331,334,-1,329,112,116,-1,22,1087,1088,-1,1089,1090,213,-1,1091,561,560,-1,317,8,7,-1,225,324,323,-1,1092,225,224,-1,162,1093,1094,-1,1095,324,225,-1,1029,317,7,-1,217,1096,1090,-1,1097,1098,1099,-1,1100,988,1101,-1,1102,313,312,-1,1103,1104,1105,-1,1106,1107,313,-1,299,130,296,-1,1108,295,291,-1,1109,1110,289,-1,1111,290,123,-1,1112,1113,1114,-1,1115,166,1116,-1,347,1117,80,-1,98,1118,1119,-1,283,1120,278,-1,283,282,1120,-1,1121,1122,1123,-1,274,273,1124,-1,1125,1123,137,-1,271,57,58,-1,415,1126,21,-1,1127,268,267,-1,264,94,1128,-1,356,263,1080,-1,1129,957,933,-1,1118,87,392,-1,1074,1130,1131,-1,1132,400,399,-1,1055,391,1050,-1,1133,1134,1135,-1,1136,1042,1137,-1,1043,245,240,-1,239,1138,416,-1,1139,1140,1141,-1,234,1142,1032,-1,37,1143,1144,-1,51,1145,1055,-1,356,1146,1147,-1,157,1148,224,-1,222,1149,323,-1,1094,936,162,-1,1150,218,1151,-1,1029,221,223,-1,933,1152,1153,-1,48,110,201,-1,1154,189,188,-1,1155,202,192,-1,16,401,194,-1,62,1034,46,-1,1038,176,1156,-1,1157,184,183,-1,1065,380,190,-1,197,200,191,-1,172,1158,77,-1,1159,1160,174,-1,1161,1162,194,-1,191,189,192,-1,262,1163,193,-1,1164,1039,204,-1,1165,226,1166,-1,174,62,1156,-1,172,177,176,-1,1159,174,1167,-1,393,1168,250,-1,89,91,251,-1,64,206,1035,-1,1036,1169,1132,-1,1170,1171,408,-1,251,404,405,-1,1172,1039,1164,-1,115,1082,109,-1,293,1173,1174,-1,293,1175,1176,-1,1177,1178,1179,-1,166,1180,1116,-1,1129,209,162,-1,324,1095,321,-1,1091,215,150,-1,1089,149,148,-1,423,1088,1087,-1,1181,1104,1182,-1,143,241,410,-1,32,11,200,-1,264,1128,1061,-1,265,1183,1184,-1,406,403,1155,-1,1185,1186,1187,-1,12,128,13,-1,97,126,292,-1,125,96,79,-1,1188,1189,313,-1,1084,327,23,-1,118,117,115,-1,1113,113,1190,-1,112,114,1191,-1,1192,1193,1194,-1,1106,302,301,-1,87,1168,393,-1,100,1195,1196,-1,1197,79,96,-1,90,93,92,-1,83,84,1198,-1,74,1199,1200,-1,74,69,81,-1,1068,252,375,-1,76,1201,1202,-1,74,73,1199,-1,1200,1203,383,-1,117,1082,115,-1,1204,71,70,-1,1205,1127,1206,-1,1207,1208,1209,-1,66,1210,67,-1,1202,1201,1211,-1,257,360,1078,-1,1189,1188,299,-1,60,1188,1102,-1,60,130,299,-1,1212,365,58,-1,262,261,1163,-1,1213,1214,1142,-1,267,266,1215,-1,1216,1217,1166,-1,50,49,139,-1,1218,175,10,-1,48,411,111,-1,1219,45,395,-1,1044,40,42,-1,1046,385,372,-1,1209,198,1165,-1,841,417,1220,-1,28,1221,1222,-1,837,836,1194,-1,1223,1224,1225,-1,1226,1192,107,-1,1226,1227,1098,-1,373,226,67,-1,314,1107,163,-1,171,401,400,-1,297,13,128,-1,393,169,109,-1,1228,1229,1215,-1,1,0,545,-1,853,639,638,-1,655,4,768,-1,886,735,999,-1,638,959,853,-1,1215,266,1228,-1,393,109,1082,-1,127,297,128,-1,171,400,170,-1,314,163,311,-1,22,1088,120,-1,1098,1230,1226,-1,1192,1231,107,-1,1225,1232,1223,-1,1194,1233,837,-1,1222,1234,28,-1,1220,1235,841,-1,58,59,1212,-1,1137,395,394,-1,395,1236,1219,-1,1154,188,207,-1,110,48,111,-1,411,341,111,-1,1218,63,175,-1,139,1237,50,-1,1216,1207,1217,-1,1195,100,377,-1,1215,1238,267,-1,1213,1239,1214,-1,1212,281,365,-1,60,299,1188,-1,60,1102,61,-1,1189,299,298,-1,240,19,410,-1,95,100,99,-1,1202,1211,1240,-1,1210,373,67,-1,1209,1217,1207,-1,1206,373,1205,-1,70,422,1204,-1,1200,383,382,-1,1118,72,88,-1,73,1241,1199,-1,1202,77,76,-1,375,374,1068,-1,81,88,74,-1,74,1200,69,-1,86,83,1198,-1,90,92,1242,-1,96,99,1197,-1,1196,1243,100,-1,393,392,87,-1,71,1244,69,-1,301,164,1106,-1,1192,1194,1232,-1,1191,116,112,-1,1190,1114,1113,-1,118,115,108,-1,121,120,144,-1,1110,125,79,-1,259,97,292,-1,295,129,256,-1,1185,1187,1245,-1,171,142,141,-1,1155,1154,406,-1,1184,402,265,-1,1061,1183,264,-1,200,197,32,-1,1246,1236,1247,-1,1087,1248,423,-1,148,150,1089,-1,150,27,1091,-1,212,153,149,-1,149,1089,212,-1,1249,1148,157,-1,160,1250,161,-1,1179,294,1177,-1,1176,1173,293,-1,289,1251,1109,-1,406,405,403,-1,405,404,403,-1,1036,1132,398,-1,1035,1034,64,-1,251,250,89,-1,250,1038,393,-1,1159,1167,1240,-1,249,172,176,-1,1156,1167,174,-1,1166,1217,1165,-1,204,203,1164,-1,193,1252,262,-1,191,199,189,-1,1162,195,194,-1,1160,175,174,-1,77,177,172,-1,200,199,191,-1,190,1253,1065,-1,1157,1254,184,-1,1156,201,1038,-1,194,196,16,-1,1155,203,202,-1,201,46,48,-1,1153,1255,933,-1,1150,219,218,-1,222,323,223,-1,224,158,157,-1,1256,1094,1093,-1,1146,1257,1147,-1,51,1055,1054,-1,1144,276,37,-1,138,1237,139,-1,234,1213,1142,-1,1139,238,1140,-1,239,416,1258,-1,240,242,1043,-1,1136,1137,394,-1,1172,1133,1135,-1,1050,135,1055,-1,399,390,1132,-1,1074,1259,1130,-1,1118,88,87,-1,210,1250,160,-1,257,129,128,-1,257,1079,129,-1,71,1204,1244,-1,356,1147,263,-1,264,92,94,-1,267,1238,1127,-1,30,32,1063,-1,415,414,1126,-1,58,1072,271,-1,1125,137,136,-1,274,1124,1260,-1,1123,273,1121,-1,1261,232,33,-1,102,56,55,-1,1248,1087,1182,-1,98,1119,1197,-1,1262,347,80,-1,1116,1263,1115,-1,1102,103,61,-1,1102,1264,103,-1,1112,1265,1113,-1,290,124,123,-1,1109,125,1110,-1,1108,291,1174,-1,296,300,299,-1,306,144,423,-1,1106,313,1189,-1,1103,309,1104,-1,1102,312,1264,-1,60,14,130,-1,1100,1101,24,-1,1266,310,1099,-1,217,1267,1096,-1,1029,318,317,-1,321,1250,322,-1,324,320,223,-1,1268,1256,1093,-1,1092,1095,225,-1,323,158,225,-1,222,1269,1149,-1,216,1091,560,-1,1089,150,1090,-1,213,212,1089,-1,1181,214,213,-1,22,155,1087,-1,329,116,330,-1,1086,334,333,-1,339,1085,1270,-1,338,1084,339,-1,111,340,1081,-1,331,343,342,-1,1271,1191,114,-1,117,1272,346,-1,1081,344,108,-1,353,354,351,-1,351,355,1060,-1,1246,1219,1236,-1,357,1080,1187,-1,1078,254,1079,-1,1076,1273,369,-1,1074,1075,1274,-1,371,369,368,-1,1056,1073,370,-1,50,1237,271,-1,1071,65,67,-1,373,1206,1070,-1,379,374,1069,-1,1068,374,379,-1,379,378,1067,-1,381,380,1065,-1,1062,1183,1061,-1,1059,1060,1275,-1,1057,1276,1058,-1,385,389,1056,-1,1055,135,1053,-1,358,357,1051,-1,1277,1278,1279,-1,399,1041,133,-1,1242,1047,90,-1,355,41,1280,-1,248,40,1044,-1,394,1281,243,-1,1042,1136,242,-1,399,16,15,-1,205,204,1039,-1,110,169,1038,-1,1036,143,1169,-1,1170,408,18,-1,1035,47,46,-1,1032,235,234,-1,1030,239,1258,-1,427,221,1029,-1,85,83,82,-1,93,90,84,-1,666,669,814,-1,961,1282,947,-1,1025,434,433,-1,432,941,805,-1,758,439,438,-1,670,450,732,-1,450,1283,732,-1,465,914,1023,-1,470,449,705,-1,665,461,479,-1,451,450,668,-1,1022,1284,667,-1,842,1284,1020,-1,459,821,664,-1,913,879,1000,-1,1285,952,478,-1,478,1286,1015,-1,479,461,460,-1,1014,1287,481,-1,1013,787,487,-1,484,926,485,-1,1012,1288,495,-1,786,852,859,-1,852,1289,1011,-1,875,496,798,-1,497,867,864,-1,1290,759,761,-1,1009,508,1010,-1,955,510,509,-1,511,510,1006,-1,1005,1291,808,-1,518,1292,654,-1,472,522,521,-1,524,525,527,-1,1000,975,534,-1,532,542,541,-1,998,544,546,-1,997,547,546,-1,996,0,1293,-1,555,973,1294,-1,995,1295,749,-1,560,559,6,-1,937,564,563,-1,687,905,686,-1,993,684,686,-1,1296,992,1297,-1,905,689,565,-1,567,566,569,-1,568,566,570,-1,6,572,690,-1,990,1298,692,-1,1299,989,834,-1,988,579,1101,-1,586,987,582,-1,986,589,984,-1,596,858,586,-1,606,857,603,-1,609,612,611,-1,615,769,983,-1,982,1300,614,-1,980,1301,979,-1,908,978,1302,-1,975,977,621,-1,785,784,974,-1,971,627,626,-1,679,678,810,-1,968,1303,969,-1,965,632,631,-1,274,1260,964,-1,963,866,868,-1,503,505,808,-1,961,1027,828,-1,853,866,963,-1,487,645,900,-1,649,521,520,-1,518,768,890,-1,568,741,569,-1,791,879,792,-1,953,955,1304,-1,951,470,831,-1,1285,475,471,-1,1305,949,948,-1,453,452,451,-1,669,666,668,-1,947,1282,429,-1,943,945,1306,-1,941,942,1307,-1,760,1308,512,-1,630,940,1309,-1,475,1016,816,-1,938,515,514,-1,1297,992,935,-1,684,1310,744,-1,687,564,937,-1,934,577,575,-1,932,1152,933,-1,707,443,848,-1,896,716,931,-1,705,712,706,-1,441,708,725,-1,928,718,490,-1,926,717,719,-1,921,727,874,-1,924,920,919,-1,923,706,711,-1,720,719,717,-1,854,1311,715,-1,703,445,922,-1,850,799,801,-1,918,708,919,-1,921,725,727,-1,920,862,918,-1,790,913,441,-1,661,788,790,-1,437,436,803,-1,733,917,951,-1,440,439,817,-1,700,757,704,-1,915,895,894,-1,1305,922,444,-1,735,913,999,-1,616,983,1312,-1,613,912,1313,-1,607,1314,909,-1,741,743,569,-1,1315,744,1310,-1,557,556,748,-1,750,904,751,-1,750,752,556,-1,555,903,972,-1,1316,973,986,-1,732,438,670,-1,901,926,636,-1,900,898,485,-1,647,1023,897,-1,895,847,896,-1,893,1317,891,-1,608,4,3,-1,889,771,653,-1,887,770,769,-1,772,756,773,-1,536,775,531,-1,980,883,885,-1,551,539,538,-1,835,1318,881,-1,880,600,596,-1,869,877,958,-1,879,913,789,-1,786,878,851,-1,784,770,887,-1,645,424,463,-1,643,1319,426,-1,877,1320,873,-1,642,877,796,-1,494,876,658,-1,495,861,794,-1,872,873,1321,-1,956,791,795,-1,536,886,999,-1,871,1322,869,-1,867,497,868,-1,849,801,800,-1,501,497,864,-1,794,861,863,-1,518,517,1292,-1,858,604,857,-1,856,806,587,-1,674,808,855,-1,639,853,637,-1,849,1290,850,-1,512,1308,815,-1,848,443,543,-1,543,998,818,-1,844,454,1020,-1,819,820,482,-1,458,822,1019,-1,462,1010,460,-1,800,799,634,-1,839,841,1235,-1,838,28,1234,-1,835,837,581,-1,881,832,776,-1,832,834,1323,-1,553,773,554,-1,595,588,584,-1,831,705,704,-1,829,672,804,-1,2,1293,0,-1,500,1324,799,-1,596,600,858,-1,573,696,579,-1,751,29,28,-1,489,1325,927,-1,460,1286,478,-1,630,1326,783,-1,821,1019,822,-1,664,821,820,-1,435,848,1024,-1,815,476,816,-1,676,763,812,-1,633,811,678,-1,810,811,808,-1,806,807,781,-1,730,437,803,-1,502,501,797,-1,502,798,863,-1,877,869,1322,-1,872,795,796,-1,642,644,1327,-1,426,425,793,-1,643,642,791,-1,788,464,463,-1,787,424,645,-1,784,786,860,-1,872,1321,802,-1,779,781,807,-1,777,765,778,-1,531,735,886,-1,539,550,775,-1,545,829,440,-1,771,889,769,-1,890,768,610,-1,4,655,5,-1,764,1328,469,-1,762,1329,763,-1,759,1308,760,-1,732,731,757,-1,647,898,900,-1,756,1330,755,-1,670,438,669,-1,554,773,903,-1,559,904,691,-1,693,557,749,-1,747,1295,745,-1,992,743,742,-1,741,698,742,-1,684,993,1310,-1,736,605,737,-1,983,1313,912,-1,441,913,442,-1,731,733,734,-1,788,1319,789,-1,662,790,441,-1,729,919,730,-1,931,724,701,-1,702,701,724,-1,713,1331,722,-1,448,447,467,-1,640,720,846,-1,718,931,716,-1,715,1331,713,-1,711,712,930,-1,1332,635,710,-1,435,730,708,-1,704,706,923,-1,703,931,701,-1,446,445,701,-1,845,699,700,-1,698,741,568,-1,557,694,1333,-1,1334,935,936,-1,690,571,565,-1,571,575,570,-1,428,689,937,-1,562,564,687,-1,683,1335,681,-1,500,850,516,-1,678,680,1336,-1,1326,1337,1338,-1,677,967,675,-1,624,623,628,-1,673,433,432,-1,671,429,943,-1,805,941,1339,-1,666,1340,667,-1,668,842,451,-1,665,459,664,-1,950,949,1341,-1,661,790,662,-1,956,795,785,-1,494,658,660,-1,656,519,890,-1,518,655,768,-1,1011,651,653,-1,648,650,854,-1,647,900,645,-1,800,634,641,-1,637,1342,638,-1,634,924,635,-1,503,811,633,-1,763,676,675,-1,631,275,274,-1,628,623,629,-1,626,280,279,-1,623,625,971,-1,603,1343,606,-1,602,619,618,-1,622,1344,620,-1,617,619,977,-1,616,981,614,-1,613,888,611,-1,608,910,609,-1,3,856,606,-1,603,857,604,-1,600,880,601,-1,595,740,596,-1,593,1345,594,-1,591,984,589,-1,588,586,582,-1,1346,559,692,-1,575,577,573,-1,559,1346,572,-1,566,565,571,-1,567,905,565,-1,689,905,687,-1,904,559,561,-1,556,558,750,-1,557,1333,558,-1,1316,1333,694,-1,555,746,553,-1,552,1347,550,-1,549,1,547,-1,546,547,1,-1,544,998,543,-1,542,1347,540,-1,536,999,534,-1,533,543,531,-1,528,530,1348,-1,458,524,822,-1,902,456,844,-1,522,891,520,-1,519,659,517,-1,761,514,516,-1,512,513,760,-1,1009,509,511,-1,508,1009,506,-1,503,512,504,-1,502,1324,500,-1,499,868,497,-1,875,491,496,-1,494,491,875,-1,1012,491,493,-1,489,927,490,-1,483,485,898,-1,480,482,526,-1,475,477,764,-1,522,472,474,-1,1349,1017,1350,-1,469,447,470,-1,465,646,463,-1,527,820,821,-1,458,1019,459,-1,452,1283,450,-1,447,449,470,-1,444,446,1351,-1,441,443,707,-1,699,895,803,-1,440,829,438,-1,435,1024,436,-1,434,942,432,-1,431,946,429,-1,7,690,428,-1,793,1327,644,-1,463,424,426,-1,420,93,421,-1,419,245,1352,-1,105,1220,417,-1,416,1138,414,-1,235,1033,412,-1,407,1213,234,-1,409,143,410,-1,404,1047,402,-1,401,16,399,-1,384,386,246,-1,1136,1043,242,-1,243,1281,396,-1,45,1281,394,-1,393,1082,345,-1,387,384,390,-1,1353,1065,1254,-1,1279,358,1052,-1,387,1145,388,-1,382,94,420,-1,381,1061,197,-1,76,1354,378,-1,100,95,377,-1,376,1355,377,-1,68,1069,374,-1,373,1210,1205,-1,1216,1356,140,-1,372,1056,370,-1,367,369,1273,-1,366,364,1073,-1,1357,363,365,-1,58,362,1072,-1,358,1146,356,-1,355,351,354,-1,351,1060,352,-1,350,354,348,-1,345,1082,346,-1,342,344,1081,-1,341,1083,338,-1,327,1084,1083,-1,339,1270,337,-1,335,332,1358,-1,332,334,1358,-1,331,1086,329,-1,328,1359,327,-1,1087,1360,1182,-1,325,152,156,-1,216,560,8,-1,159,1149,1269,-1,320,324,321,-1,322,1250,210,-1,320,322,319,-1,318,315,216,-1,218,26,1151,-1,1361,1362,1151,-1,24,1233,1363,-1,312,314,1266,-1,1102,1188,313,-1,313,1107,314,-1,309,1103,310,-1,308,1364,306,-1,301,284,1365,-1,300,167,298,-1,296,297,1179,-1,294,295,1108,-1,1174,291,293,-1,289,1110,124,-1,78,80,285,-1,286,1117,287,-1,285,1365,284,-1,300,296,1366,-1,281,277,282,-1,278,1120,279,-1,38,37,276,-1,275,1121,273,-1,54,232,52,-1,272,1367,270,-1,270,57,271,-1,11,1160,198,-1,268,1228,266,-1,1242,92,265,-1,263,1147,261,-1,258,376,259,-1,12,359,257,-1,129,1079,255,-1,252,1068,253,-1,1118,98,72,-1,251,173,249,-1,1134,1368,1135,-1,246,386,247,-1,1043,1136,394,-1,245,1043,243,-1,407,1239,1213,-1,239,1031,237,-1,236,20,234,-1,232,1261,233,-1,55,1369,229,-1,226,228,1166,-1,220,319,218,-1,1370,936,1094,-1,214,151,212,-1,209,1255,210,-1,208,1035,206,-1,205,181,180,-1,203,204,180,-1,201,1156,62,-1,198,187,199,-1,380,197,190,-1,30,9,31,-1,195,1371,196,-1,193,1163,183,-1,192,202,190,-1,189,199,187,-1,1041,15,186,-1,182,184,1372,-1,179,181,1372,-1,202,180,179,-1,63,62,174,-1,172,249,173,-1,89,1168,1198,-1,170,1169,143,-1,1038,169,393,-1,1109,1176,1175,-1,168,1180,166,-1,224,1148,1092,-1,209,160,162,-1,1093,162,161,-1,155,1126,156,-1,153,212,151,-1,216,215,1091,-1,1088,423,120,-1,241,240,410,-1,144,306,145,-1,265,264,1183,-1,143,409,141,-1,140,1356,138,-1,137,232,54,-1,133,135,1050,-1,297,130,13,-1,129,295,127,-1,126,97,96,-1,124,78,122,-1,1083,1170,18,-1,119,22,120,-1,116,1191,117,-1,113,1113,114,-1,107,1231,105,-1,103,1373,104,-1,73,1243,1241,-1,98,1197,99,-1,95,99,96,-1,93,420,94,-1,89,250,1168,-1,88,81,86,-1,85,421,84,-1,76,1069,1201,-1,79,1262,80,-1,75,1354,76,-1,72,74,88,-1,1191,1272,117,-1,65,1211,68,-1,1165,1217,1209,-1,98,100,1243,-1,1034,62,64,-1,19,407,20,-1,14,61,104,-1,57,56,59,-1,57,270,55,-1,53,52,1374,-1,240,419,407,-1,51,1054,49,-1,1171,1170,411,-1,1219,43,45,-1,41,355,42,-1,101,36,38,-1,385,387,389,-1,1064,1065,1375,-1,27,1221,28,-1,26,1100,24,-1,1106,1189,302,-1,226,1165,1071,-1,23,327,1359,-1,18,410,19,-1,1085,1084,23,-1,11,31,9,-1,18,327,1083,-1,960,1332,710,-1,5,856,3,-1,1363,25,24,-1,1363,1376,25,-1,1231,1232,1225,-1,1192,1232,1231,-1,836,1232,1194,-1,1232,836,1223,-1,1235,1225,1224,-1,1220,1225,1235,-1,33,137,1377,-1,33,232,137,-1,1275,1130,1059,-1,1275,1276,1130,-1,1378,1379,1380,-1,1378,1381,1379,-1,139,1382,140,-1,1382,139,1245,-1,1383,1277,1384,-1,1385,1277,1383,-1,1214,1228,268,-1,1228,1214,1239,-1,278,1386,1387,-1,278,280,1386,-1,1388,1367,1389,-1,1388,1369,1367,-1,1390,1125,1391,-1,1390,1124,1125,-1,14,359,12,-1,1392,359,14,-1,1033,360,412,-1,360,1033,1078,-1,1167,1202,1240,-1,178,1202,1167,-1,1071,198,1160,-1,1165,198,1071,-1,1393,1199,1241,-1,1393,1394,1199,-1,1395,1394,75,-1,1395,1203,1394,-1,1226,1373,103,-1,1226,107,1373,-1,298,302,1189,-1,298,1115,302,-1,414,1139,325,-1,414,1138,1139,-1,1185,1396,1186,-1,1396,1185,1053,-1,229,1397,230,-1,1398,1397,229,-1,1399,1400,1401,-1,1399,1402,1400,-1,1184,403,402,-1,403,1184,1155,-1,197,1128,32,-1,1128,197,1061,-1,1181,1360,214,-1,1181,1182,1360,-1,1116,1403,1111,-1,1180,1403,1116,-1,1177,1404,1178,-1,1404,1177,1405,-1,1173,1406,1407,-1,1173,1176,1406,-1,1174,1407,1108,-1,1173,1407,1174,-1,1408,288,287,-1,288,1408,1409,-1,1049,1040,1135,-1,1049,1048,1040,-1,1169,400,1132,-1,1169,170,400,-1,249,1038,250,-1,249,176,1038,-1,405,173,251,-1,405,1218,173,-1,188,1162,1161,-1,188,187,1162,-1,193,17,1252,-1,17,193,1410,-1,1202,177,77,-1,1202,178,177,-1,1253,1254,1065,-1,1254,1253,184,-1,1411,195,1208,-1,1411,1371,195,-1,194,171,1161,-1,401,171,194,-1,192,1154,1155,-1,1154,192,189,-1,1382,1208,1207,-1,1208,1382,1411,-1,1206,1412,1070,-1,1206,1413,1412,-1,1414,1415,1416,-1,1414,418,1415,-1,238,131,1140,-1,237,131,238,-1,244,1352,245,-1,1417,1352,244,-1,1418,1417,1419,-1,1417,1418,1420,-1,1421,1137,1042,-1,1421,1045,1137,-1,391,399,1050,-1,391,390,399,-1,1158,75,77,-1,1158,1395,75,-1,1255,1129,933,-1,1255,209,1129,-1,1127,1214,268,-1,1205,1214,1127,-1,1422,1423,1424,-1,1422,1390,1423,-1,1124,1123,1125,-1,1124,273,1123,-1,233,1374,52,-1,233,1425,1374,-1,1377,34,33,-1,1426,34,1377,-1,1400,1427,1428,-1,1400,1429,1427,-1,1430,1120,282,-1,1428,1120,1430,-1,1119,347,1262,-1,1119,345,347,-1,1251,1176,1109,-1,1251,1406,1176,-1,1406,1431,1405,-1,1406,1251,1431,-1,1117,346,287,-1,1117,347,346,-1,1365,286,305,-1,1365,285,286,-1,1364,145,306,-1,1364,1432,145,-1,1107,164,163,-1,164,1107,1106,-1,1181,1105,1104,-1,1105,1181,213,-1,103,1227,1226,-1,1264,1227,103,-1,1193,1376,1363,-1,1193,1230,1376,-1,1433,1100,1434,-1,1433,988,1100,-1,310,1435,1099,-1,310,1103,1435,-1,1361,1097,1099,-1,1361,211,1097,-1,220,318,1029,-1,219,318,220,-1,321,1268,1250,-1,1095,1268,321,-1,1093,1250,1268,-1,1250,1093,161,-1,1092,1249,1370,-1,1249,1092,1148,-1,561,27,29,-1,561,1091,27,-1,149,1436,147,-1,1436,149,153,-1,1415,1436,1416,-1,1415,147,1436,-1,1360,155,154,-1,1360,1087,155,-1,329,113,112,-1,1086,113,329,-1,335,1085,119,-1,335,1270,1085,-1,1437,1081,340,-1,1437,342,1081,-1,1265,114,1113,-1,1271,114,1265,-1,108,343,118,-1,108,344,343,-1,528,1438,1439,-1,1438,528,1440,-1,1441,529,1442,-1,1441,1443,529,-1,1444,1219,1246,-1,1444,43,1219,-1,1205,1142,1214,-1,1205,1210,1142,-1,1386,1445,1387,-1,1446,1445,1386,-1,1077,370,1073,-1,1077,369,370,-1,1057,368,1131,-1,368,1057,371,-1,51,1072,362,-1,50,1072,51,-1,65,1160,1159,-1,1160,65,1071,-1,258,253,1447,-1,258,255,253,-1,378,1195,1066,-1,378,1196,1195,-1,1060,1280,1275,-1,1060,355,1280,-1,1276,1131,1130,-1,1276,1057,1131,-1,1382,1187,1080,-1,1245,1187,1382,-1,1385,1448,1368,-1,1385,1383,1448,-1,1146,1279,1449,-1,1146,358,1279,-1,1133,1450,1134,-1,1133,1064,1450,-1,265,1047,1242,-1,265,402,1047,-1,1046,247,386,-1,1058,247,1046,-1,1137,1044,1247,-1,1137,1045,1044,-1,1451,1452,1453,-1,1452,1451,1454,-1,1036,1042,1037,-1,1421,1042,1036,-1,382,69,1200,-1,382,70,69,-1,871,1013,1322,-1,787,1013,871,-1,953,1274,954,-1,1455,1274,953,-1,1456,818,817,-1,818,1456,1024,-1,1283,733,732,-1,1283,916,733,-1,951,479,952,-1,951,917,479,-1,1284,668,667,-1,1284,842,668,-1,1457,1451,1379,-1,1458,1451,1457,-1,1350,489,1459,-1,489,1350,1325,-1,1017,1460,473,-1,1017,1349,1460,-1,474,891,522,-1,474,892,891,-1,1008,819,843,-1,1008,462,819,-1,795,802,785,-1,802,795,872,-1,1011,1461,651,-1,1289,1461,1011,-1,797,876,798,-1,797,864,876,-1,1006,1274,1075,-1,1006,954,1274,-1,511,1462,1463,-1,1007,1462,511,-1,1464,506,1463,-1,1465,506,1464,-1,1466,1464,1467,-1,1466,1468,1464,-1,864,942,876,-1,1307,942,864,-1,1003,1469,1001,-1,1469,1003,1470,-1,1471,525,524,-1,1471,1472,525,-1,1001,1440,1004,-1,1473,1440,1001,-1,1474,541,540,-1,1475,541,1474,-1,1476,772,774,-1,772,1476,1477,-1,1478,884,1479,-1,1478,1480,884,-1,1347,775,550,-1,1347,542,775,-1,1295,961,745,-1,1295,995,961,-1,994,1481,945,-1,994,1482,1481,-1,826,752,751,-1,826,753,752,-1,1483,428,937,-1,427,428,1483,-1,906,1297,993,-1,906,1296,1297,-1,1334,1484,1315,-1,1484,1334,936,-1,1298,1485,578,-1,1298,990,1485,-1,834,583,1323,-1,834,989,583,-1,1333,990,558,-1,985,990,1333,-1,986,972,592,-1,986,973,972,-1,755,1345,593,-1,1486,1345,755,-1,622,601,598,-1,619,601,622,-1,534,621,620,-1,621,534,975,-1,1487,1488,1489,-1,1488,1487,1312,-1,912,1312,983,-1,1312,912,1488,-1,975,974,976,-1,1000,974,975,-1,626,1303,971,-1,626,969,1303,-1,1427,970,969,-1,970,1427,1429,-1,825,1490,823,-1,825,1491,1490,-1,813,677,676,-1,1492,677,813,-1,965,964,1493,-1,631,964,965,-1,513,939,514,-1,939,513,633,-1,1494,1495,1496,-1,1494,1497,1495,-1,907,697,933,-1,698,697,907,-1,1498,925,874,-1,1499,925,1498,-1,470,1285,471,-1,952,1285,470,-1,453,1500,452,-1,1500,453,457,-1,1501,1497,1502,-1,1501,1495,1497,-1,1028,1340,666,-1,1028,1501,1340,-1,767,943,1306,-1,767,671,943,-1,1503,1504,1481,-1,1504,1503,1505,-1,1016,1285,478,-1,1016,475,1285,-1,865,1506,849,-1,865,929,1506,-1,847,716,896,-1,847,720,716,-1,803,1507,728,-1,803,915,1507,-1,711,929,865,-1,929,711,930,-1,1018,928,927,-1,1018,723,928,-1,727,861,874,-1,861,727,726,-1,830,715,1311,-1,830,1508,715,-1,641,846,923,-1,640,846,641,-1,710,662,921,-1,662,710,663,-1,863,920,502,-1,920,863,862,-1,831,733,951,-1,734,733,831,-1,1351,468,949,-1,466,468,1351,-1,1344,1509,620,-1,1344,1510,1509,-1,1511,612,609,-1,1511,911,612,-1,1488,911,1511,-1,911,1488,912,-1,1512,909,1314,-1,1512,1489,909,-1,1513,908,982,-1,1513,738,908,-1,1294,1316,694,-1,1316,1294,973,-1,899,926,901,-1,899,485,926,-1,894,897,1023,-1,894,896,897,-1,970,1514,968,-1,1515,1514,970,-1,1516,680,1338,-1,1516,1517,680,-1,1518,893,892,-1,1518,477,893,-1,944,961,995,-1,1282,961,944,-1,611,653,652,-1,653,611,888,-1,600,604,858,-1,978,604,600,-1,883,1479,884,-1,883,1330,1479,-1,543,735,531,-1,543,443,735,-1,779,832,780,-1,832,779,777,-1,1519,1499,1498,-1,1520,1499,1519,-1,770,859,771,-1,860,859,770,-1,1498,495,1288,-1,1498,874,495,-1,486,1499,1520,-1,1499,486,488,-1,496,863,798,-1,496,794,863,-1,763,1496,637,-1,1329,1496,763,-1,962,1492,813,-1,962,1521,1492,-1,1468,624,855,-1,625,624,1468,-1,947,1026,996,-1,1026,947,946,-1,1459,1349,1350,-1,1349,1459,1522,-1,850,761,516,-1,1290,761,850,-1,1523,844,1020,-1,1470,844,1523,-1,482,1304,843,-1,482,481,1304,-1,762,823,1490,-1,675,823,762,-1,1332,901,635,-1,901,1332,960,-1,1524,1235,1224,-1,1524,839,1235,-1,882,836,835,-1,882,1223,836,-1,882,776,1524,-1,882,881,776,-1,696,580,579,-1,580,696,1525,-1,774,2,549,-1,774,553,2,-1,835,580,1318,-1,580,835,581,-1,563,1483,937,-1,1483,563,1526,-1,1325,683,927,-1,683,1325,1335,-1,467,1527,468,-1,1527,467,1528,-1,674,782,809,-1,628,782,674,-1,1470,1457,1469,-1,1470,1523,1457,-1,728,709,729,-1,728,1507,709,-1,946,1025,1026,-1,1025,946,431,-1,1339,814,805,-1,638,814,1339,-1,633,1336,939,-1,678,1336,633,-1,1494,1329,1493,-1,1494,1496,1329,-1,963,813,812,-1,963,962,813,-1,1017,1325,1350,-1,1017,1335,1325,-1,486,1320,1013,-1,1520,1320,486,-1,1519,1288,1529,-1,1288,1519,1498,-1,1327,877,642,-1,1327,958,877,-1,1519,1320,1520,-1,1320,1519,873,-1,618,1302,602,-1,618,1300,1302,-1,777,766,765,-1,777,779,766,-1,772,1330,756,-1,1330,772,1479,-1,431,1530,654,-1,431,430,1530,-1,1293,828,1027,-1,1293,2,828,-1,1317,815,1308,-1,1317,893,815,-1,1338,824,1516,-1,824,1338,1337,-1,1531,970,1429,-1,1531,1515,970,-1,1295,693,749,-1,747,693,1295,-1,584,591,590,-1,584,583,591,-1,1489,1513,1487,-1,1512,1513,1489,-1,1344,1532,1510,-1,1344,597,1532,-1,922,948,483,-1,922,1305,948,-1,709,663,710,-1,709,1507,663,-1,722,928,723,-1,724,928,722,-1,1331,702,722,-1,1331,1533,702,-1,1508,448,721,-1,830,448,1508,-1,854,712,1311,-1,930,712,854,-1,1533,715,1508,-1,1533,1331,715,-1,1534,573,827,-1,1534,574,573,-1,681,649,682,-1,681,521,649,-1,682,1018,683,-1,1018,682,1535,-1,823,1516,824,-1,967,1516,823,-1,638,1028,814,-1,638,1342,1028,-1,767,1504,765,-1,1504,767,1306,-1,1502,1340,1501,-1,1502,1536,1340,-1,1536,667,1340,-1,1536,1021,667,-1,1537,1538,1539,-1,1538,1537,1424,-1,660,519,657,-1,660,659,519,-1,1327,870,958,-1,1327,793,870,-1,637,1495,1342,-1,1496,1495,637,-1,1517,967,677,-1,1516,967,1517,-1,1531,632,1515,-1,1531,275,632,-1,629,971,1303,-1,971,629,623,-1,981,1312,1487,-1,1312,981,616,-1,781,987,585,-1,987,781,780,-1,982,1302,1300,-1,982,908,1302,-1,621,619,622,-1,977,619,621,-1,607,608,3,-1,607,910,608,-1,880,598,601,-1,599,598,880,-1,1345,595,594,-1,1345,739,595,-1,986,594,589,-1,594,986,592,-1,881,833,832,-1,881,1318,833,-1,1534,1152,932,-1,1433,1152,1534,-1,989,578,1485,-1,578,989,576,-1,576,573,577,-1,573,576,695,-1,688,1346,934,-1,688,572,1346,-1,1526,1315,1484,-1,1526,563,1315,-1,751,561,29,-1,904,561,751,-1,1482,754,753,-1,1482,748,754,-1,1482,1503,1481,-1,1503,1482,753,-1,746,1294,747,-1,555,1294,746,-1,540,552,1540,-1,540,1347,552,-1,884,1540,885,-1,884,1480,1540,-1,1541,1477,1476,-1,1477,1541,1478,-1,1475,1541,997,-1,1475,1474,1541,-1,539,1509,537,-1,539,535,1509,-1,1002,524,523,-1,1471,524,1002,-1,529,1014,530,-1,1014,529,1443,-1,523,455,902,-1,458,455,523,-1,1381,1001,1469,-1,1381,1473,1001,-1,517,658,434,-1,658,517,659,-1,761,513,514,-1,760,513,761,-1,1467,1386,1466,-1,1467,1446,1386,-1,507,1465,1291,-1,507,506,1465,-1,1542,1462,1007,-1,1542,1543,1462,-1,505,816,1005,-1,505,504,816,-1,924,502,920,-1,924,1324,502,-1,660,651,1461,-1,657,651,660,-1,851,1012,493,-1,1012,851,878,-1,820,526,482,-1,526,820,527,-1,462,509,1010,-1,462,1008,509,-1,815,477,476,-1,815,893,477,-1,1544,1328,1518,-1,1545,1328,1544,-1,468,1341,949,-1,468,1527,1341,-1,483,897,922,-1,897,483,898,-1,458,453,455,-1,453,458,457,-1,1546,1451,1458,-1,1546,1454,1451,-1,452,916,1283,-1,452,1500,916,-1,1537,1502,1497,-1,1539,1502,1537,-1,787,425,424,-1,787,871,425,-1,382,422,70,-1,382,420,422,-1,1274,1259,1074,-1,1274,1455,1259,-1,411,1547,1171,-1,411,47,1547,-1,1421,398,246,-1,1421,1036,398,-1,1451,1380,1379,-1,1451,1453,1380,-1,1247,395,1137,-1,395,1247,1236,-1,1064,1278,1450,-1,1064,1375,1278,-1,1384,1279,1052,-1,1277,1279,1384,-1,1187,1051,357,-1,1186,1051,1187,-1,1243,72,98,-1,1243,73,72,-1,1447,376,258,-1,1447,1355,376,-1,375,66,68,-1,1210,66,375,-1,1542,367,1273,-1,1542,1075,367,-1,363,1073,364,-1,1073,363,1077,-1,1387,363,1357,-1,1387,1445,363,-1,271,138,269,-1,271,1237,138,-1,1032,1210,375,-1,1032,1142,1210,-1,1378,1444,1548,-1,1378,43,1444,-1,1442,352,1441,-1,353,352,1442,-1,1439,349,348,-1,349,1439,1438,-1,349,1246,350,-1,349,1444,1246,-1,340,337,1437,-1,338,337,340,-1,337,335,1358,-1,337,1270,335,-1,1549,336,121,-1,332,336,1549,-1,118,330,116,-1,343,330,118,-1,414,156,1126,-1,156,414,325,-1,1416,326,1141,-1,1436,326,1416,-1,148,1221,27,-1,1221,148,147,-1,1249,1526,1484,-1,1526,1249,1269,-1,210,319,322,-1,210,1550,319,-1,218,1550,316,-1,319,1550,218,-1,1150,1362,1267,-1,1151,1362,1150,-1,1096,1103,1105,-1,1435,1103,1096,-1,1101,1233,24,-1,1101,837,1233,-1,1227,312,1266,-1,1227,1264,312,-1,163,309,311,-1,163,308,309,-1,1248,306,423,-1,1248,307,306,-1,304,1364,165,-1,304,1432,1364,-1,145,1551,1112,-1,145,1432,1551,-1,167,1115,298,-1,167,166,1115,-1,1175,292,126,-1,293,292,1175,-1,1409,1271,1265,-1,1409,1408,1271,-1,288,305,286,-1,305,288,303,-1,168,1178,1404,-1,168,1366,1178,-1,345,1118,392,-1,1119,1118,345,-1,282,276,1430,-1,282,277,276,-1,1401,1428,1430,-1,1401,1400,1428,-1,1399,1377,1122,-1,1399,1426,1377,-1,102,59,56,-1,102,101,59,-1,1413,1127,1238,-1,1413,1206,1127,-1,1390,1418,1423,-1,1390,1391,1418,-1,1128,1063,32,-1,1128,94,1063,-1,1184,203,1155,-1,1184,1164,203,-1,255,260,256,-1,255,258,260,-1,1079,253,255,-1,254,253,1079,-1,1538,1423,1552,-1,1538,1424,1423,-1,243,1553,244,-1,1553,243,397,-1,244,1419,1417,-1,1419,244,1553,-1,1414,131,106,-1,1414,1140,131,-1,1352,1228,419,-1,1228,1352,1229,-1,1397,33,35,-1,1397,1261,33,-1,1554,1367,272,-1,1554,1389,1367,-1,1080,1411,1382,-1,1411,1080,263,-1,26,1434,1100,-1,1434,26,316,-1,193,1555,1410,-1,182,1555,193,-1,1371,263,262,-1,1411,263,1371,-1,190,179,1253,-1,179,190,202,-1,1556,1041,186,-1,133,1041,1556,-1,1048,205,1040,-1,1048,1557,205,-1,172,30,1158,-1,172,9,30,-1,1551,288,1409,-1,303,288,1551,-1,1403,1405,1431,-1,1403,1404,1405,-1,310,314,311,-1,1266,314,310,-1,151,156,152,-1,151,154,156,-1,1554,227,1070,-1,1554,228,227,-1,1401,1426,1399,-1,1426,1401,1144,-1,1369,1398,229,-1,1388,1398,1369,-1,135,1396,1053,-1,134,1396,135,-1,238,1138,239,-1,1138,238,1139,-1,237,132,131,-1,237,1558,132,-1,146,121,144,-1,146,1549,121,-1,132,107,106,-1,1373,107,132,-1,1263,122,284,-1,122,1263,123,-1,1200,1394,1203,-1,1200,1199,1394,-1,69,82,81,-1,82,69,1244,-1,1354,1394,1393,-1,1354,75,1394,-1,178,1156,176,-1,178,1167,1156,-1,1374,1238,53,-1,1238,1374,1413,-1,136,1391,1125,-1,1559,1391,136,-1,1369,270,1367,-1,1369,55,270,-1,1215,53,1238,-1,1215,54,53,-1,415,328,416,-1,1359,328,415,-1,1051,1384,1052,-1,1051,1560,1384,-1,206,1154,207,-1,206,406,1154,-1,1380,43,1378,-1,43,1380,44,-1,1280,1276,1275,-1,1280,1058,1276,-1,39,1143,37,-1,1143,39,231,-1,1384,1561,1383,-1,1384,1560,1561,-1,1363,1194,1193,-1,1363,1233,1194,-1,23,119,1085,-1,22,119,23,-1,327,20,236,-1,327,18,20,-1,211,1376,1097,-1,25,1376,211,-1,1483,1269,222,-1,1483,1526,1269,-1,1353,1375,1065,-1,1353,1449,1375,-1,1448,186,1049,-1,1448,1556,186,-1,101,1212,59,-1,101,38,1212,-1,1259,1059,1130,-1,1259,1562,1059,-1,412,1258,413,-1,412,1030,1258,-1,419,1239,407,-1,419,1228,1239,-1,283,1387,1357,-1,283,278,1387,-1,1388,1412,1425,-1,1389,1412,1388,-1,1124,1422,1260,-1,1390,1422,1124,-1,1375,1279,1278,-1,1449,1279,1375,-1,1033,375,252,-1,1032,375,1033,-1,376,97,259,-1,376,95,97,-1,1392,104,1558,-1,104,1392,14,-1,1231,1220,105,-1,1231,1225,1220,-1,411,1083,341,-1,411,1170,1083,-1,260,295,256,-1,260,291,295,-1,1392,1030,359,-1,1031,1030,1392,-1,21,1359,415,-1,23,1359,21,-1,49,1245,139,-1,1185,1245,49,-1,35,230,1397,-1,35,231,230,-1,1400,1531,1429,-1,1402,1531,1400,-1,21,155,22,-1,155,21,1126,-1,167,1366,168,-1,167,300,1366,-1,1180,1404,1403,-1,1180,168,1404,-1,1407,1405,1177,-1,1407,1406,1405,-1,1272,287,346,-1,287,1272,1408,-1,1133,1164,1062,-1,1164,1133,1172,-1,171,208,207,-1,141,208,171,-1,173,10,9,-1,1218,10,173,-1,1253,1372,184,-1,1253,179,1372,-1,181,182,1372,-1,1555,182,181,-1,15,1410,185,-1,15,17,1410,-1,196,262,1252,-1,196,1371,262,-1,1208,1162,1209,-1,1208,195,1162,-1,207,1161,171,-1,207,188,1161,-1,1410,1557,185,-1,1557,1410,1555,-1,1153,210,1255,-1,1153,1550,210,-1,1370,1256,1092,-1,1370,1094,1256,-1,217,1150,1267,-1,217,315,1150,-1,1254,1257,1353,-1,1254,1157,1257,-1,230,102,229,-1,230,36,102,-1,36,230,39,-1,418,106,105,-1,1414,106,418,-1,1563,1552,1564,-1,1538,1552,1563,-1,1454,1564,1452,-1,1563,1564,1454,-1,1229,1417,1420,-1,1352,1417,1229,-1,1045,246,248,-1,1421,246,1045,-1,1204,82,1244,-1,82,1204,85,-1,1420,1215,1229,-1,1420,1559,1215,-1,1261,1398,233,-1,1261,1397,1398,-1,1121,1531,1402,-1,1531,1121,275,-1,1428,279,1120,-1,279,1428,1427,-1,1251,290,1431,-1,1251,289,290,-1,1263,1111,123,-1,1116,1111,1263,-1,285,1117,286,-1,285,80,1117,-1,127,1179,297,-1,1179,127,294,-1,305,301,1365,-1,305,304,301,-1,163,1364,308,-1,1364,163,165,-1,308,1104,309,-1,308,307,1104,-1,1230,1192,1226,-1,1193,1192,1230,-1,1152,1434,1153,-1,1152,1433,1434,-1,1362,1099,1435,-1,1362,1361,1099,-1,26,1361,1151,-1,26,211,1361,-1,315,219,1150,-1,318,219,315,-1,1415,1221,147,-1,1415,1222,1221,-1,214,154,151,-1,154,214,1360,-1,1190,332,1549,-1,332,1190,333,-1,121,335,119,-1,121,336,335,-1,342,334,331,-1,342,1437,334,-1,1440,1548,1438,-1,1440,1473,1548,-1,529,1439,1442,-1,529,528,1439,-1,359,412,360,-1,359,1030,412,-1,228,272,1356,-1,272,228,1554,-1,361,365,364,-1,365,361,58,-1,1446,1076,1445,-1,1076,1446,1543,-1,361,388,362,-1,388,361,366,-1,1145,362,388,-1,51,362,1145,-1,1447,1068,1067,-1,1447,253,1068,-1,377,1066,1195,-1,377,1355,1066,-1,378,1393,1196,-1,1393,378,1354,-1,1562,1443,1441,-1,1565,1443,1562,-1,1207,140,1382,-1,140,1207,1216,-1,1561,133,1556,-1,1561,134,133,-1,1368,1450,1385,-1,1368,1134,1450,-1,1135,1039,1172,-1,1039,1135,1040,-1,45,396,1281,-1,44,396,45,-1,1452,396,1453,-1,397,396,1452,-1,384,1132,390,-1,1132,384,398,-1,208,409,1547,-1,141,409,208,-1,1416,1140,1414,-1,1416,1141,1140,-1,87,1198,1168,-1,87,86,1198,-1,1319,463,426,-1,788,463,1319,-1,877,1013,1320,-1,1013,877,1322,-1,840,778,1505,-1,839,778,840,-1,1456,436,1024,-1,1456,700,436,-1,1566,467,466,-1,1566,721,467,-1,1458,1523,1022,-1,1458,1457,1523,-1,664,462,461,-1,664,819,462,-1,465,647,646,-1,1023,647,465,-1,1459,948,950,-1,948,1459,489,-1,1017,681,1335,-1,681,1017,472,-1,1527,1522,1341,-1,1522,1527,1567,-1,891,1506,520,-1,891,1317,1506,-1,955,843,1304,-1,1008,843,955,-1,878,1321,1529,-1,1321,878,802,-1,492,1289,493,-1,492,1461,1289,-1,507,1286,508,-1,1015,1286,507,-1,1009,1463,506,-1,511,1463,1009,-1,1463,1467,1464,-1,1463,1462,1467,-1,1468,1465,1464,-1,1468,855,1465,-1,1307,867,1568,-1,864,867,1307,-1,844,1003,902,-1,1470,1003,844,-1,526,1472,480,-1,526,525,1472,-1,1471,530,1472,-1,1348,530,1471,-1,1004,528,1348,-1,1004,1440,528,-1,542,531,775,-1,532,531,542,-1,538,1301,980,-1,538,537,1301,-1,533,1475,544,-1,1475,533,541,-1,549,1476,774,-1,548,1476,549,-1,1474,1478,1541,-1,1480,1478,1474,-1,885,552,551,-1,885,1540,552,-1,748,994,749,-1,748,1482,994,-1,840,1503,838,-1,1503,840,1505,-1,692,750,558,-1,750,692,691,-1,991,575,574,-1,991,570,575,-1,578,934,1298,-1,578,577,934,-1,984,990,985,-1,984,1485,990,-1,581,1101,579,-1,1101,581,837,-1,582,1323,583,-1,1323,582,987,-1,589,595,590,-1,595,589,594,-1,593,972,903,-1,592,972,593,-1,1345,599,739,-1,599,1345,1486,-1,1532,755,979,-1,755,1532,1486,-1,978,605,604,-1,605,978,737,-1,888,1313,889,-1,888,613,1313,-1,537,1510,1301,-1,1509,1510,537,-1,598,1344,622,-1,598,597,1344,-1,1314,736,1512,-1,1343,736,1314,-1,956,1000,879,-1,956,974,1000,-1,279,969,626,-1,279,1427,969,-1,1490,1514,966,-1,1491,1514,1490,-1,809,679,810,-1,679,809,782,-1,762,1493,1329,-1,965,1493,762,-1,1497,1569,1537,-1,1569,1497,1494,-1,488,899,901,-1,899,488,487,-1,703,897,896,-1,897,703,922,-1,652,657,656,-1,651,657,652,-1,665,457,459,-1,665,1500,457,-1,1501,1342,1495,-1,1501,1028,1342,-1,1570,1454,1546,-1,1570,1563,1454,-1,1539,1563,1570,-1,1539,1538,1563,-1,765,1505,778,-1,765,1504,1505,-1,679,1338,680,-1,783,1338,679,-1,783,1326,1338,-1,929,520,1506,-1,929,650,520,-1,934,692,1298,-1,1346,692,934,-1,1297,1334,993,-1,1334,1297,935,-1,568,932,697,-1,932,568,991,-1,1566,1508,721,-1,1566,1533,1508,-1,923,845,704,-1,845,923,846,-1,641,865,800,-1,865,641,711,-1,723,1535,713,-1,1018,1535,723,-1,724,718,928,-1,724,931,718,-1,447,1528,467,-1,447,469,1528,-1,446,466,1351,-1,1566,466,446,-1,960,921,925,-1,921,960,710,-1,620,535,534,-1,620,1509,535,-1,1489,1511,909,-1,1511,1489,1488,-1,1512,738,1513,-1,738,1512,736,-1,1343,605,736,-1,603,605,1343,-1,746,828,553,-1,746,745,828,-1,498,515,499,-1,516,515,498,-1,1491,968,1514,-1,1491,940,968,-1,1517,1336,680,-1,1517,1571,1336,-1,1518,764,477,-1,1518,1328,764,-1,1282,943,429,-1,1282,944,943,-1,766,671,767,-1,671,766,1572,-1,610,652,656,-1,652,610,611,-1,545,818,998,-1,818,545,440,-1,839,776,778,-1,1524,776,839,-1,807,1530,1572,-1,807,5,1530,-1,771,1011,653,-1,859,1011,771,-1,876,434,658,-1,876,942,434,-1,708,726,725,-1,726,708,918,-1,585,806,781,-1,587,806,585,-1,1422,964,1260,-1,1422,1569,964,-1,1521,1571,1492,-1,1521,938,1571,-1,1466,625,1468,-1,627,625,1466,-1,1339,1307,1568,-1,1339,941,1307,-1,853,812,763,-1,853,963,812,-1,996,1027,947,-1,996,1293,1027,-1,1460,474,473,-1,474,1460,1544,-1,847,699,845,-1,847,895,699,-1,481,953,1304,-1,953,481,1287,-1,1309,1326,630,-1,1309,1337,1326,-1,1545,1460,1567,-1,1460,1545,1544,-1,1524,1223,882,-1,1524,1224,1223,-1,1525,695,1299,-1,1525,696,695,-1,672,0,673,-1,0,672,829,-1,1525,834,833,-1,1525,1299,834,-1,838,841,840,-1,838,1234,841,-1,1528,1567,1527,-1,1567,1528,1545,-1,825,1337,1309,-1,824,1337,825,-1,1287,1455,953,-1,1287,1565,1455,-1,1379,1469,1457,-1,1381,1469,1379,-1,1506,1308,759,-1,1506,1317,1308,-1,1349,1567,1460,-1,1349,1522,1567,-1,638,1568,959,-1,638,1339,1568,-1,1386,627,1466,-1,280,627,1386,-1,939,1571,938,-1,1336,1571,939,-1,1493,1569,1494,-1,1569,1493,964,-1,654,5,655,-1,654,1530,5,-1,1292,434,1025,-1,1292,517,434,-1,861,918,862,-1,861,726,918,-1,634,1324,924,-1,634,799,1324,-1,873,1529,1321,-1,1529,873,1519,-1,617,976,887,-1,617,977,976,-1,976,784,887,-1,976,974,784,-1,1302,600,602,-1,600,1302,978,-1,1572,779,807,-1,779,1572,766,-1,551,980,885,-1,551,538,980,-1,1300,617,614,-1,618,617,1300,-1,430,1572,1530,-1,430,671,1572,-1,433,996,1026,-1,433,673,996,-1,1518,474,1544,-1,892,474,1518,-1,1309,1491,825,-1,1491,1309,940,-1,938,499,515,-1,938,1521,499,-1,907,936,742,-1,907,957,936,-1,1487,982,981,-1,1513,982,1487,-1,607,1343,1314,-1,606,1343,607,-1,1486,597,599,-1,597,1486,1532,-1,489,483,948,-1,484,483,489,-1,661,465,464,-1,914,465,661,-1,1456,439,758,-1,1456,817,439,-1,663,915,661,-1,1507,915,663,-1,960,1499,488,-1,960,925,1499,-1,1533,446,702,-1,1533,1566,446,-1,729,635,924,-1,635,729,709,-1,717,490,718,-1,926,490,717,-1,648,713,1535,-1,648,714,713,-1,719,634,636,-1,640,634,719,-1,449,1311,712,-1,830,1311,449,-1,574,932,991,-1,1534,932,574,-1,649,1535,682,-1,649,648,1535,-1,1521,868,499,-1,868,1521,962,-1,995,945,944,-1,995,994,945,-1,1539,1536,1502,-1,1539,1570,1536,-1,1570,1021,1536,-1,1570,1546,1021,-1,955,1006,510,-1,954,1006,955,-1,793,871,870,-1,425,871,793,-1,1568,866,959,-1,1568,867,866,-1,1537,1422,1424,-1,1569,1422,1537,-1,1490,965,762,-1,1490,966,965,-1,677,1571,1517,-1,1571,677,1492,-1,1515,966,1514,-1,1515,632,966,-1,940,1303,968,-1,940,629,1303,-1,563,744,1315,-1,563,562,744,-1,887,614,617,-1,614,887,615,-1,909,609,910,-1,909,1511,609,-1,1510,979,1301,-1,1510,1532,979,-1,889,983,769,-1,889,1313,983,-1,1330,979,755,-1,1330,883,979,-1,740,599,880,-1,740,739,599,-1,985,1316,986,-1,985,1333,1316,-1,1323,780,832,-1,1323,987,780,-1,1525,1318,580,-1,1318,1525,833,-1,827,1433,1534,-1,1433,827,988,-1,1485,591,989,-1,591,1485,984,-1,1299,576,989,-1,576,1299,695,-1,572,571,690,-1,572,688,571,-1,1296,567,569,-1,1296,906,567,-1,569,992,1296,-1,569,743,992,-1,1315,993,1334,-1,1315,1310,993,-1,826,1503,753,-1,1503,826,838,-1,747,694,693,-1,747,1294,694,-1,1474,1540,1480,-1,540,1540,1474,-1,1477,1479,772,-1,1477,1478,1479,-1,1476,997,1541,-1,997,1476,548,-1,997,544,1475,-1,997,546,544,-1,902,1002,523,-1,1002,902,1003,-1,1002,1348,1471,-1,1002,1004,1348,-1,480,530,1014,-1,480,1472,530,-1,1025,654,1292,-1,654,1025,431,-1,855,1291,1465,-1,855,808,1291,-1,1462,1446,1467,-1,1462,1543,1446,-1,1015,1291,1005,-1,1015,507,1291,-1,1075,1007,1006,-1,1542,1007,1075,-1,1005,1016,1015,-1,1005,816,1016,-1,494,1461,492,-1,660,1461,494,-1,493,852,851,-1,852,493,1289,-1,1529,1012,878,-1,1529,1288,1012,-1,1443,1287,1014,-1,1443,1565,1287,-1,460,508,1286,-1,460,1010,508,-1,759,849,1506,-1,759,1290,849,-1,469,1545,1528,-1,1545,469,1328,-1,1459,1341,1522,-1,950,1341,1459,-1,444,949,1305,-1,444,1351,949,-1,1022,1020,1284,-1,1022,1523,1020,-1,1022,1546,1458,-1,1022,1021,1546,-1,917,1500,665,-1,1500,917,916,-1,758,700,1456,-1,758,757,700,-1,1306,1481,1504,-1,1481,1306,945,-1,1319,792,789,-1,643,792,1319,-1,90,1198,84,-1,90,89,1198,-1,1419,1423,1418,-1,1419,1552,1423,-1,1035,1547,47,-1,208,1547,1035,-1,242,143,1037,-1,242,241,143,-1,186,1557,1048,-1,1557,186,185,-1,44,1453,396,-1,1380,1453,44,-1,248,41,40,-1,248,247,41,-1,1184,1062,1164,-1,1184,1183,1062,-1,1368,1049,1135,-1,1049,1368,1448,-1,134,1560,1396,-1,134,1561,1560,-1,1053,49,1054,-1,1185,49,1053,-1,371,1046,372,-1,1046,371,1057,-1,1441,1059,1562,-1,1441,352,1059,-1,1241,1196,1393,-1,1241,1243,1196,-1,1355,1067,1066,-1,1067,1355,1447,-1,389,366,1056,-1,389,388,366,-1,1273,1543,1542,-1,1273,1076,1543,-1,1445,1077,363,-1,1077,1445,1076,-1,269,1356,272,-1,269,138,1356,-1,252,1078,1033,-1,252,254,1078,-1,1548,1381,1378,-1,1381,1548,1473,-1,1247,350,1246,-1,1247,1044,350,-1,348,1442,1439,-1,1442,348,353,-1,1438,1444,349,-1,1438,1548,1444,-1,1408,1191,1271,-1,1272,1191,1408,-1,1358,1437,337,-1,334,1437,1358,-1,1086,1190,113,-1,333,1190,1086,-1,326,153,152,-1,153,326,1436,-1,1415,417,1222,-1,1415,418,417,-1,150,217,1090,-1,150,215,217,-1,222,427,1483,-1,221,427,222,-1,1256,1095,1092,-1,1095,1256,1268,-1,1484,1370,1249,-1,1484,936,1370,-1,1435,1267,1362,-1,1096,1267,1435,-1,1266,1098,1227,-1,1099,1098,1266,-1,1096,213,1090,-1,1096,1105,213,-1,1248,1104,307,-1,1104,1248,1182,-1,304,164,301,-1,164,304,165,-1,1112,146,145,-1,146,1112,1114,-1,1109,126,125,-1,1175,126,1109,-1,1112,1409,1265,-1,1551,1409,1112,-1,1108,1177,294,-1,1407,1177,1108,-1,124,79,78,-1,124,1110,79,-1,157,1269,1249,-1,159,1269,157,-1,1430,1144,1401,-1,276,1144,1430,-1,1122,1402,1399,-1,1402,1122,1121,-1,1388,233,1398,-1,1388,1425,233,-1,1123,1377,137,-1,1377,1123,1122,-1,1420,1391,1559,-1,1418,1391,1420,-1,1162,198,1209,-1,198,1162,187,-1,422,85,1204,-1,422,421,85,-1,367,1131,368,-1,367,1074,1131,-1,397,1564,1553,-1,1564,397,1452,-1,1553,1552,1419,-1,1552,1553,1564,-1,1141,325,1139,-1,325,1141,326,-1,281,38,277,-1,281,1212,38,-1,391,1145,387,-1,1145,391,1055,-1,1257,1449,1353,-1,1449,1257,1146,-1,1157,1147,1257,-1,261,1147,1157,-1,159,323,1149,-1,159,158,323,-1,223,220,1029,-1,223,320,220,-1,1153,316,1550,-1,1153,1434,316,-1,1252,16,196,-1,1252,17,16,-1,1218,64,63,-1,405,64,1218,-1,183,261,1157,-1,261,183,1163,-1,11,175,1160,-1,11,10,175,-1,205,1555,181,-1,1557,1555,205,-1,1395,30,1063,-1,1158,30,1395,-1,1159,1211,65,-1,1159,1240,1211,-1,408,1547,409,-1,1171,1547,408,-1,1047,251,91,-1,1047,404,251,-1,1062,1064,1133,-1,1062,381,1064,-1,303,1432,304,-1,303,1551,1432,-1,1366,1179,1178,-1,1366,296,1179,-1,1111,1431,290,-1,1111,1403,1431,-1,936,1129,162,-1,957,1129,936,-1,1070,1389,1554,-1,1389,1070,1412,-1,1426,1143,34,-1,1426,1144,1143,-1,1051,1396,1560,-1,1051,1186,1396,-1,328,235,413,-1,236,235,328,-1,1558,1031,1392,-1,237,1031,1558,-1,259,291,260,-1,259,292,291,-1,1549,1114,1190,-1,146,1114,1549,-1,1373,1558,104,-1,1373,132,1558,-1,302,1263,284,-1,302,1115,1263,-1,1197,1262,79,-1,1119,1262,1197,-1,1395,383,1203,-1,1395,1063,383,-1,1211,1069,68,-1,1201,1069,1211,-1,1559,54,1215,-1,1559,136,54,-1,1425,1413,1374,-1,1412,1413,1425,-1,281,1357,365,-1,281,283,1357,-1,413,416,328,-1,413,1258,416,-1,1277,1450,1278,-1,1277,1385,1450,-1,1356,1166,228,-1,1356,1216,1166,-1,1455,1562,1259,-1,1565,1562,1455,-1,1058,41,247,-1,1058,1280,41,-1,231,34,1143,-1,231,35,34,-1,1383,1556,1448,-1,1383,1561,1556,-1,841,1222,417,-1,1222,841,1234,-1,1098,1376,1230,-1,1376,1098,1097,-1],creaseAngle=1.571,normalIndex=[1521,1572,1321,-1,1026,1202,1544,-1,895,907,749,-1,204,952,1116,-1,126,364,27,-1,1301,1303,1351,-1,264,515,58,-1,63,237,252,-1,1221,1196,1401,-1,177,771,776,-1,1116,671,936,-1,1116,938,671,-1,193,243,153,-1,203,385,454,-1,385,203,205,-1,803,668,532,-1,941,768,1074,-1,1306,1148,1177,-1,889,1198,996,-1,186,239,351,-1,290,84,358,-1,1043,358,194,-1,27,307,922,-1,1512,1510,1181,-1,1365,1292,1346,-1,1088,1292,1365,-1,1142,652,1373,-1,1569,1442,1265,-1,509,477,389,-1,1466,1556,1457,-1,1248,1518,1163,-1,1084,1163,1340,-1,1281,1450,1553,-1,1164,1228,1050,-1,1325,1092,1079,-1,1275,1511,1277,-1,1549,1454,1384,-1,185,90,203,-1,1014,226,922,-1,420,210,247,-1,1434,1356,1290,-1,1290,1150,1434,-1,1075,993,1514,-1,1434,1487,1356,-1,631,1475,1240,-1,569,315,573,-1,1225,1273,1354,-1,1366,1153,1511,-1,694,183,255,-1,305,27,364,-1,210,130,99,-1,321,267,382,-1,351,468,412,-1,1425,1285,1414,-1,1239,1339,1276,-1,644,1037,994,-1,277,316,261,-1,348,316,177,-1,164,142,176,-1,213,151,184,-1,433,1293,340,-1,1209,1190,546,-1,1199,918,859,-1,900,1071,975,-1,1356,1235,1290,-1,1405,1339,1424,-1,1276,1339,1405,-1,42,160,204,-1,1517,1481,1510,-1,291,161,514,-1,405,217,388,-1,553,963,874,-1,1301,1032,347,-1,1069,923,445,-1,174,270,75,-1,1047,963,553,-1,1539,1558,1415,-1,762,270,174,-1,1274,481,716,-1,1306,1138,1512,-1,217,74,175,-1,217,251,421,-1,965,1226,1243,-1,1101,1383,1209,-1,1401,1196,1326,-1,218,688,404,-1,375,266,982,-1,1559,1438,1476,-1,733,435,1269,-1,1217,1537,1293,-1,1467,1508,1530,-1,89,90,290,-1,205,105,167,-1,230,137,186,-1,83,17,53,-1,72,64,34,-1,829,1007,1260,-1,660,572,699,-1,1501,1387,1231,-1,25,443,401,-1,274,314,234,-1,214,378,255,-1,77,183,126,-1,286,678,330,-1,1124,1246,1157,-1,1325,1404,1420,-1,1248,1163,1281,-1,752,498,751,-1,1274,716,1116,-1,1324,817,1187,-1,1308,817,1324,-1,661,778,775,-1,612,692,454,-1,637,745,746,-1,657,643,669,-1,1134,1225,1242,-1,1312,1452,1304,-1,1225,1466,1242,-1,958,1354,928,-1,737,969,1096,-1,1117,694,766,-1,1238,305,565,-1,1041,1264,1255,-1,1005,1045,1134,-1,1220,1000,1207,-1,1073,1318,1218,-1,1439,1480,1411,-1,1419,1316,1429,-1,1135,982,266,-1,1559,1456,1401,-1,674,1355,266,-1,1566,1476,1500,-1,1500,1533,1542,-1,1269,1328,1532,-1,266,749,674,-1,111,119,142,-1,51,53,65,-1,557,599,633,-1,562,575,623,-1,686,698,562,-1,656,681,810,-1,681,888,968,-1,590,496,611,-1,1536,1562,1554,-1,863,896,827,-1,677,712,696,-1,594,532,475,-1,820,343,731,-1,77,23,52,-1,1043,1305,1180,-1,1172,1286,1121,-1,1315,1305,1286,-1,761,925,1023,-1,1193,1174,1344,-1,1508,1467,1377,-1,636,525,1088,-1,1275,617,1107,-1,381,383,477,-1,762,1156,1571,-1,646,508,1079,-1,1534,1486,1548,-1,1272,1205,1279,-1,1253,1030,1272,-1,1536,1477,1284,-1,1074,1342,1320,-1,660,659,603,-1,1440,1534,1501,-1,1085,1437,1529,-1,1018,326,462,-1,361,494,1181,-1,515,829,547,-1,807,1089,559,-1,1148,1049,1177,-1,83,58,547,-1,46,47,17,-1,107,82,56,-1,420,537,368,-1,608,829,699,-1,890,974,880,-1,315,625,644,-1,461,598,484,-1,931,907,816,-1,1538,1540,1552,-1,1498,1555,1468,-1,250,406,152,-1,1011,770,830,-1,583,339,280,-1,452,1322,1149,-1,1065,249,285,-1,313,196,123,-1,223,253,570,-1,253,522,570,-1,254,689,336,-1,101,21,172,-1,346,523,478,-1,1106,1229,1111,-1,1251,563,976,-1,838,1165,1267,-1,837,946,1161,-1,301,39,101,-1,929,934,722,-1,30,3,146,-1,1066,511,909,-1,3,6,337,-1,1176,1166,1154,-1,1120,1166,1176,-1,1176,1098,813,-1,197,62,300,-1,100,216,209,-1,402,387,438,-1,296,259,302,-1,413,680,554,-1,195,402,263,-1,268,248,44,-1,1413,1493,1403,-1,821,742,1233,-1,689,726,898,-1,765,940,1013,-1,858,914,856,-1,165,956,653,-1,10,9,98,-1,68,60,79,-1,933,984,1072,-1,418,653,673,-1,987,884,1572,-1,759,808,875,-1,966,500,1015,-1,1337,1302,1249,-1,1155,1378,632,-1,1309,767,815,-1,1234,1407,1210,-1,94,31,40,-1,31,188,78,-1,4,31,87,-1,215,895,1309,-1,169,118,12,-1,127,48,76,-1,371,434,446,-1,170,122,149,-1,257,246,311,-1,170,149,279,-1,134,158,96,-1,256,497,356,-1,372,487,279,-1,353,369,571,-1,549,430,416,-1,318,531,499,-1,334,457,1026,-1,899,518,804,-1,833,540,479,-1,212,129,610,-1,88,349,329,-1,124,97,262,-1,416,430,329,-1,881,932,844,-1,962,951,746,-1,1119,954,1186,-1,901,885,775,-1,728,263,402,-1,299,458,842,-1,1055,1021,706,-1,299,502,190,-1,325,287,419,-1,265,201,154,-1,451,439,429,-1,1289,1241,882,-1,1493,1547,1447,-1,1278,1358,1403,-1,1299,1336,1259,-1,1173,1550,1408,-1,156,21,71,-1,865,910,577,-1,744,313,567,-1,1499,1540,1538,-1,1513,1519,1498,-1,932,1119,1022,-1,1343,1386,1436,-1,1282,1484,1485,-1,44,62,100,-1,470,386,181,-1,357,282,35,-1,1234,244,282,-1,87,133,12,-1,94,304,328,-1,1197,591,1309,-1,1378,1410,1170,-1,169,245,376,-1,188,391,472,-1,604,406,327,-1,1149,1352,1189,-1,1397,1352,1322,-1,148,36,33,-1,504,250,495,-1,458,647,1372,-1,15,33,168,-1,622,539,527,-1,1496,1331,1416,-1,502,1090,1129,-1,249,1229,541,-1,622,959,655,-1,1169,959,1189,-1,1280,1059,1406,-1,80,85,54,-1,1550,583,1280,-1,208,293,187,-1,140,148,208,-1,219,280,339,-1,597,663,819,-1,372,710,697,-1,367,1027,384,-1,1140,1234,282,-1,1431,1399,1369,-1,1378,1393,1435,-1,1227,1394,1257,-1,1295,1298,1257,-1,536,497,919,-1,293,333,486,-1,155,139,45,-1,1160,1223,1343,-1,1251,976,1191,-1,1359,1473,1443,-1,1388,899,804,-1,202,59,298,-1,1337,995,1256,-1,1337,1002,995,-1,79,345,98,-1,1046,1323,1151,-1,1360,543,627,-1,1395,1367,1484,-1,13,24,166,-1,265,511,651,-1,407,409,1130,-1,287,20,102,-1,484,233,419,-1,1098,685,813,-1,2,20,308,-1,79,98,9,-1,209,283,485,-1,145,26,95,-1,24,359,166,-1,394,80,54,-1,1058,1513,1025,-1,1195,1544,1445,-1,528,1363,1488,-1,1224,1488,1282,-1,1333,1258,1386,-1,744,1025,961,-1,645,578,387,-1,505,524,830,-1,231,156,723,-1,822,1010,1013,-1,1395,1119,1186,-1,1186,1367,1395,-1,1381,1418,1330,-1,771,1262,1394,-1,169,371,332,-1,1491,1321,1337,-1,1058,1011,1310,-1,249,220,285,-1,148,140,136,-1,149,158,372,-1,197,216,100,-1,516,393,224,-1,516,1323,1046,-1,501,788,790,-1,1132,1262,771,-1,921,1035,773,-1,528,1022,1363,-1,223,228,253,-1,722,424,231,-1,535,522,253,-1,350,638,1044,-1,418,524,399,-1,645,387,195,-1,121,49,95,-1,548,465,166,-1,1031,1223,1055,-1,331,539,451,-1,442,932,1022,-1,1270,311,324,-1,324,311,466,-1,744,1011,1058,-1,295,114,166,-1,1012,444,395,-1,510,283,216,-1,121,26,5,-1,709,469,476,-1,192,297,711,-1,131,308,1056,-1,1098,1188,1012,-1,1120,924,1048,-1,325,308,20,-1,1056,308,441,-1,419,287,484,-1,346,201,265,-1,13,114,59,-1,166,359,1184,-1,73,409,102,-1,580,487,697,-1,639,715,501,-1,500,966,79,-1,417,702,584,-1,98,165,92,-1,875,1321,1572,-1,311,246,466,-1,202,129,16,-1,882,601,426,-1,899,1388,1202,-1,804,1278,1311,-1,1294,1341,1178,-1,148,333,208,-1,1244,1076,1422,-1,154,503,69,-1,235,162,146,-1,628,842,458,-1,700,570,522,-1,1249,1302,945,-1,1257,1298,1155,-1,1227,1197,1396,-1,1155,1298,1393,-1,41,40,11,-1,886,1027,472,-1,663,670,819,-1,457,473,456,-1,479,463,586,-1,479,540,463,-1,219,339,303,-1,1244,1109,1214,-1,1173,1214,1109,-1,327,148,350,-1,187,182,138,-1,406,604,394,-1,1173,523,407,-1,1130,409,303,-1,432,57,110,-1,1528,1550,1280,-1,495,54,57,-1,49,100,145,-1,1322,452,354,-1,331,527,539,-1,1331,1496,1129,-1,190,143,15,-1,198,57,85,-1,1215,1528,1188,-1,842,703,1090,-1,337,180,1009,-1,132,91,331,-1,331,429,132,-1,583,504,495,-1,54,250,152,-1,36,285,168,-1,1497,1397,1422,-1,1044,638,1129,-1,250,504,399,-1,338,785,391,-1,328,304,816,-1,12,133,117,-1,1200,1027,792,-1,1146,304,244,-1,282,357,1140,-1,764,268,841,-1,578,946,837,-1,1186,954,1091,-1,1094,1498,1417,-1,1509,1515,1446,-1,1538,1535,1516,-1,744,577,313,-1,196,228,223,-1,28,492,288,-1,837,1191,976,-1,189,320,563,-1,913,809,593,-1,20,1,73,-1,886,785,791,-1,1403,1493,1311,-1,192,8,297,-1,439,821,429,-1,162,235,511,-1,1031,823,709,-1,893,909,628,-1,1478,1491,1431,-1,1224,402,528,-1,476,871,1017,-1,930,901,778,-1,972,998,885,-1,1449,1381,1343,-1,926,877,847,-1,854,844,951,-1,691,448,1249,-1,7,1,24,-1,18,22,113,-1,670,663,587,-1,362,417,236,-1,642,626,212,-1,568,610,129,-1,833,804,518,-1,334,1270,324,-1,497,945,919,-1,246,279,487,-1,70,178,173,-1,246,257,227,-1,1195,1270,1544,-1,743,332,371,-1,122,116,96,-1,591,632,147,-1,328,907,895,-1,103,188,4,-1,11,35,41,-1,1027,1200,519,-1,35,11,763,-1,244,35,282,-1,767,895,749,-1,1435,1455,1462,-1,1507,1519,1521,-1,905,808,759,-1,1310,987,1521,-1,602,884,987,-1,984,653,956,-1,10,222,37,-1,649,658,605,-1,649,729,658,-1,1013,1010,898,-1,470,838,742,-1,528,438,396,-1,708,666,554,-1,593,413,344,-1,400,241,413,-1,62,197,100,-1,1048,924,485,-1,949,295,465,-1,1203,1098,1176,-1,3,337,703,-1,511,1066,917,-1,978,934,929,-1,370,507,301,-1,449,1165,838,-1,181,544,180,-1,320,39,301,-1,303,37,222,-1,336,740,822,-1,513,253,228,-1,910,970,902,-1,39,138,71,-1,563,36,136,-1,1109,1244,556,-1,1214,394,1076,-1,1058,1025,744,-1,486,1011,293,-1,422,399,524,-1,1498,1025,1513,-1,1526,1555,1525,-1,1478,1516,1482,-1,961,1042,865,-1,1256,919,945,-1,1084,974,1092,-1,907,931,1168,-1,19,32,34,-1,128,106,17,-1,1306,1421,1167,-1,807,559,264,-1,1400,1392,1276,-1,965,1181,494,-1,990,1138,1290,-1,1123,825,421,-1,1301,480,1085,-1,1451,1260,1392,-1,1342,660,983,-1,872,1319,1231,-1,1486,1382,1548,-1,1097,1050,1228,-1,467,460,347,-1,321,596,1085,-1,306,408,731,-1,410,620,734,-1,1272,1486,1534,-1,1486,1287,1344,-1,1204,1300,1382,-1,718,712,561,-1,1426,1571,1541,-1,508,648,1079,-1,1564,1571,1385,-1,381,423,390,-1,383,390,455,-1,755,477,383,-1,1377,1271,1508,-1,1467,1353,1346,-1,1187,1133,1198,-1,1287,1315,1268,-1,1174,1193,1023,-1,732,761,693,-1,911,1023,1112,-1,157,163,77,-1,343,820,850,-1,872,532,594,-1,594,827,872,-1,696,863,594,-1,1150,906,1434,-1,1350,1475,1562,-1,633,599,496,-1,1150,968,888,-1,681,588,0,-1,810,0,690,-1,595,633,623,-1,557,1075,631,-1,237,323,273,-1,355,927,688,-1,171,815,767,-1,674,749,907,-1,1537,1532,1328,-1,806,1537,1217,-1,546,1054,374,-1,1560,1532,1537,-1,1168,674,907,-1,982,1427,927,-1,1334,1348,1459,-1,1247,743,754,-1,1327,1316,1419,-1,1502,1398,1391,-1,1087,1252,1316,-1,1264,305,1238,-1,1020,766,737,-1,1004,1444,958,-1,979,928,1273,-1,1213,1338,1152,-1,988,900,894,-1,1554,1479,1457,-1,1549,1570,1567,-1,669,641,637,-1,669,643,641,-1,679,574,600,-1,778,661,634,-1,490,600,412,-1,1187,358,1043,-1,82,141,63,-1,861,751,498,-1,1404,1079,1335,-1,820,1157,850,-1,676,791,785,-1,1570,1450,1477,-1,732,870,967,-1,1371,1437,1085,-1,734,1030,596,-1,1545,1288,1078,-1,1379,1451,1349,-1,983,699,829,-1,34,50,56,-1,61,135,120,-1,83,735,128,-1,385,284,482,-1,996,1064,734,-1,820,1113,1115,-1,433,352,1217,-1,435,366,1328,-1,374,792,546,-1,1458,1559,1523,-1,1168,733,1269,-1,785,786,1236,-1,1177,1290,1138,-1,529,445,923,-1,150,74,75,-1,1303,1529,1539,-1,1512,1421,1306,-1,990,291,1086,-1,1122,874,963,-1,1385,1156,174,-1,762,716,270,-1,42,360,389,-1,1464,1376,1517,-1,1433,1412,1539,-1,270,445,75,-1,1246,1034,1047,-1,1219,1123,251,-1,1428,1467,1524,-1,1517,1512,1086,-1,42,161,291,-1,1464,1517,1141,-1,1284,1175,443,-1,1164,1050,401,-1,1181,965,1167,-1,1400,1389,1371,-1,845,1067,807,-1,401,462,361,-1,1490,1123,1219,-1,1487,1350,1356,-1,1096,1108,1033,-1,1096,1016,989,-1,1100,1125,1118,-1,900,750,894,-1,676,1101,546,-1,1532,1560,1533,-1,171,375,348,-1,355,261,316,-1,625,273,323,-1,1114,1398,1127,-1,1276,1007,559,-1,938,1116,716,-1,1404,1335,1426,-1,1420,1503,1068,-1,494,326,150,-1,398,232,281,-1,126,183,364,-1,1277,1153,969,-1,1366,1511,1556,-1,1263,1105,1316,-1,0,51,252,-1,1240,1475,1487,-1,1338,993,846,-1,1075,1514,1489,-1,920,1162,1070,-1,1087,1045,1005,-1,1450,1175,1284,-1,1384,1024,392,-1,1561,1556,1511,-1,1228,1092,1325,-1,1163,1084,1179,-1,1265,488,579,-1,1265,1142,1248,-1,455,274,525,-1,477,878,560,-1,1265,1442,488,-1,579,483,508,-1,1475,1350,1487,-1,1245,1373,652,-1,1104,861,1110,-1,1441,1568,1546,-1,1292,1062,1346,-1,560,878,1182,-1,77,52,157,-1,1105,1263,1264,-1,307,1263,1327,-1,307,305,1264,-1,551,1121,1043,-1,1246,1124,1034,-1,506,868,735,-1,498,752,521,-1,1495,1474,1524,-1,1198,889,1285,-1,705,1481,952,-1,1177,1049,1150,-1,1053,1074,1320,-1,872,803,532,-1,1382,1486,1344,-1,1546,1274,1428,-1,773,537,640,-1,771,310,440,-1,790,788,1070,-1,783,781,727,-1,1061,920,247,-1,1061,1390,1348,-1,1377,1467,1346,-1,1429,1252,1199,-1,1424,1529,1437,-1,565,364,183,-1,1284,1235,1356,-1,552,489,521,-1,1572,1521,987,-1,1031,706,1021,-1,1447,1202,1388,-1,92,219,222,-1,1021,823,1031,-1,521,752,552,-1,1284,1356,1350,-1,694,565,183,-1,1424,1437,1405,-1,1429,1199,1411,-1,237,273,315,-1,1348,1183,1061,-1,920,526,247,-1,727,852,783,-1,1070,1128,790,-1,440,772,771,-1,640,782,773,-1,1043,194,551,-1,1349,1320,1342,-1,1320,1051,1053,-1,529,923,1226,-1,1290,1177,1150,-1,1049,968,1150,-1,705,1510,1481,-1,1285,1368,1198,-1,1495,1441,1474,-1,1024,1384,1107,-1,521,550,498,-1,506,618,868,-1,551,657,1121,-1,307,1264,1263,-1,307,1327,922,-1,1105,1264,1041,-1,829,515,559,-1,1275,1384,1454,-1,560,1182,1131,-1,1062,1377,1346,-1,1546,1474,1441,-1,1110,1377,1104,-1,652,880,1245,-1,579,508,646,-1,1570,1569,1553,-1,1442,736,488,-1,560,389,477,-1,525,636,455,-1,1248,1553,1265,-1,1265,579,1142,-1,1281,1163,1179,-1,1228,1325,1370,-1,1511,1454,1561,-1,392,1216,1384,-1,1284,1477,1450,-1,1373,1565,1142,-1,1005,918,1087,-1,920,1070,852,-1,1489,631,1075,-1,846,1152,1338,-1,1240,1487,1434,-1,573,315,644,-1,1444,1366,1556,-1,678,1277,969,-1,766,255,378,-1,398,281,606,-1,1424,1339,1239,-1,150,529,494,-1,1068,1018,1420,-1,1426,1503,1404,-1,716,762,938,-1,862,1051,1003,-1,323,876,625,-1,316,348,355,-1,348,177,171,-1,218,176,261,-1,261,355,218,-1,200,352,433,-1,1209,1492,1190,-1,1118,1117,1100,-1,989,1108,1096,-1,958,843,1004,-1,494,361,326,-1,361,462,326,-1,1400,1371,1440,-1,1167,1421,1181,-1,401,443,1164,-1,443,990,1284,-1,1464,1141,1131,-1,25,42,291,-1,1086,1141,1517,-1,1524,1474,1428,-1,251,175,1219,-1,1047,1362,1246,-1,270,481,445,-1,1412,1558,1539,-1,1376,1481,1517,-1,389,161,42,-1,716,481,270,-1,174,609,1385,-1,1122,1029,874,-1,1086,1138,990,-1,1539,1415,1303,-1,150,175,74,-1,1138,1306,1177,-1,1236,1185,785,-1,1458,1438,1559,-1,435,1328,1269,-1,1217,1293,433,-1,992,374,1054,-1,1113,1208,1115,-1,996,734,620,-1,482,612,385,-1,1425,1368,1285,-1,83,506,735,-1,61,64,135,-1,34,56,38,-1,829,1260,983,-1,1379,1349,1342,-1,1490,1545,1078,-1,596,382,734,-1,1085,1253,1371,-1,732,814,870,-1,1570,1553,1450,-1,1383,1492,1209,-1,77,255,183,-1,77,163,255,-1,1373,1245,1565,-1,820,1115,1157,-1,1404,1325,1079,-1,498,550,861,-1,671,938,648,-1,82,107,141,-1,1043,1133,1187,-1,490,412,468,-1,778,634,780,-1,600,661,679,-1,125,230,193,-1,90,84,290,-1,876,323,1127,-1,1549,1567,1561,-1,1551,1554,1457,-1,894,1143,988,-1,1327,1014,922,-1,1327,1357,1014,-1,1213,1332,1338,-1,928,1354,1273,-1,1004,1366,1444,-1,1020,737,1033,-1,1238,1255,1264,-1,1073,644,625,-1,1087,1316,1105,-1,1502,1439,1398,-1,1327,1419,1357,-1,307,27,305,-1,1247,754,1221,-1,1453,1480,1459,-1,982,1430,1427,-1,1168,1355,674,-1,1533,1492,1542,-1,1532,1500,1269,-1,1531,992,1054,-1,806,1560,1537,-1,1328,1293,1537,-1,435,159,366,-1,266,171,767,-1,355,348,927,-1,688,218,355,-1,1114,404,688,-1,237,151,323,-1,557,631,599,-1,595,623,575,-1,810,690,760,-1,681,0,810,-1,1150,888,906,-1,633,496,590,-1,1504,1489,1514,-1,1475,1563,1562,-1,906,611,1434,-1,696,594,677,-1,677,475,561,-1,862,1053,1051,-1,343,850,281,-1,157,234,163,-1,911,879,1023,-1,732,693,704,-1,1174,1023,925,-1,1287,1268,1193,-1,1198,1368,1187,-1,1353,1365,1346,-1,1377,1110,1271,-1,383,636,755,-1,455,636,383,-1,383,381,390,-1,1571,1156,1385,-1,1541,1503,1426,-1,718,561,664,-1,1204,1082,1300,-1,1486,1279,1287,-1,734,382,410,-1,731,343,306,-1,566,1361,1126,-1,1085,480,321,-1,1370,1097,1228,-1,475,668,654,-1,1231,803,872,-1,1342,912,660,-1,1451,1379,1260,-1,1085,1303,1301,-1,421,251,1123,-1,1290,1235,990,-1,1400,1276,1389,-1,845,807,264,-1,1167,1148,1306,-1,128,17,83,-1,19,34,38,-1,931,733,1168,-1,1340,1163,1518,-1,1092,1228,1084,-1,865,744,961,-1,1478,1522,1516,-1,1526,1468,1555,-1,1498,1094,1025,-1,486,770,1011,-1,567,313,293,-1,313,191,293,-1,478,1109,556,-1,563,285,36,-1,71,21,39,-1,196,313,577,-1,902,667,910,-1,228,667,513,-1,336,822,156,-1,303,73,37,-1,542,320,301,-1,301,294,370,-1,39,21,101,-1,978,980,934,-1,917,651,511,-1,3,703,146,-1,1203,1137,1098,-1,166,465,295,-1,465,1099,949,-1,924,813,485,-1,197,469,510,-1,86,155,45,-1,400,302,241,-1,593,680,413,-1,554,680,708,-1,396,271,528,-1,1493,1520,1547,-1,838,1233,742,-1,898,765,1013,-1,37,18,10,-1,956,1072,984,-1,602,673,884,-1,905,759,884,-1,1507,1521,1470,-1,1249,448,1060,-1,1462,1409,1435,-1,767,1309,895,-1,1146,1210,1407,-1,244,41,35,-1,763,357,35,-1,43,519,582,-1,41,304,94,-1,40,31,78,-1,188,31,4,-1,895,215,328,-1,147,144,591,-1,238,116,224,-1,743,371,754,-1,246,227,170,-1,173,134,70,-1,487,466,246,-1,334,324,318,-1,518,540,833,-1,129,202,568,-1,626,292,212,-1,236,240,362,-1,670,587,431,-1,18,113,97,-1,24,13,7,-1,854,951,962,-1,1484,1282,1488,-1,926,960,877,-1,972,885,901,-1,778,780,930,-1,1017,709,476,-1,402,438,528,-1,1478,1482,1491,-1,1031,709,1017,-1,511,265,162,-1,439,742,821,-1,1493,1388,1311,-1,188,367,78,-1,20,73,102,-1,913,593,682,-1,189,563,136,-1,542,837,976,-1,81,492,28,-1,223,123,196,-1,744,865,577,-1,1516,1522,1538,-1,1509,1446,1423,-1,1094,1417,860,-1,139,278,195,-1,1186,1091,1291,-1,837,507,578,-1,764,248,268,-1,582,519,1200,-1,357,1222,1140,-1,244,1210,1146,-1,117,48,12,-1,338,786,785,-1,504,280,399,-1,1422,1496,1497,-1,36,168,33,-1,583,495,1280,-1,1009,1416,337,-1,703,1331,1090,-1,1528,1406,1188,-1,198,110,57,-1,143,33,15,-1,1129,1090,1331,-1,331,206,527,-1,1397,1322,354,-1,49,145,95,-1,432,495,57,-1,1528,1280,1406,-1,110,444,432,-1,1130,303,583,-1,1173,407,1130,-1,152,406,394,-1,187,138,189,-1,830,770,505,-1,327,333,148,-1,1214,1076,1244,-1,81,354,452,-1,219,303,222,-1,610,568,724,-1,479,586,558,-1,457,450,473,-1,367,384,78,-1,1374,1140,1222,-1,1378,1155,1393,-1,1227,1396,1394,-1,1227,1257,1155,-1,1249,945,691,-1,459,448,173,-1,293,1011,567,-1,628,703,842,-1,162,69,146,-1,154,556,503,-1,1076,1044,1422,-1,1178,964,1294,-1,899,1202,1026,-1,426,298,882,-1,16,59,202,-1,995,919,1256,-1,98,345,165,-1,236,417,584,-1,500,79,60,-1,501,411,639,-1,580,549,487,-1,192,441,8,-1,73,303,409,-1,166,1184,548,-1,13,59,16,-1,265,461,346,-1,287,377,484,-1,441,985,1056,-1,325,441,308,-1,1120,1048,1299,-1,1098,1012,685,-1,131,1056,836,-1,1,20,2,-1,98,92,222,-1,711,939,192,-1,469,197,476,-1,121,95,26,-1,216,197,510,-1,685,1012,395,-1,1493,1413,1520,-1,466,531,324,-1,1270,1195,311,-1,1022,528,442,-1,706,1031,1055,-1,121,86,49,-1,195,278,645,-1,399,280,418,-1,418,602,524,-1,535,253,513,-1,231,723,722,-1,689,1010,740,-1,172,241,101,-1,26,145,299,-1,921,773,782,-1,1132,771,772,-1,501,790,446,-1,639,516,1046,-1,516,224,179,-1,1337,1256,1302,-1,372,279,149,-1,136,36,148,-1,1310,1513,1058,-1,1321,1470,1521,-1,100,221,145,-1,487,549,466,-1,169,376,371,-1,1394,776,771,-1,6,14,180,-1,101,294,301,-1,1186,1364,1367,-1,822,740,1010,-1,156,822,723,-1,250,399,422,-1,645,946,578,-1,1386,1223,1333,-1,728,1224,1282,-1,1488,1224,528,-1,1195,1445,627,-1,54,152,394,-1,209,216,283,-1,209,485,395,-1,441,192,939,-1,131,2,308,-1,325,419,55,-1,484,598,233,-1,287,325,20,-1,407,523,346,-1,651,461,265,-1,13,166,114,-1,131,836,359,-1,1360,627,1445,-1,1323,1359,1151,-1,165,219,92,-1,79,966,345,-1,987,1310,830,-1,298,426,202,-1,1311,1388,804,-1,1202,1447,1544,-1,1191,1307,1251,-1,1160,1103,1223,-1,155,278,139,-1,293,208,333,-1,154,69,162,-1,919,581,536,-1,567,1011,744,-1,1302,1256,945,-1,1309,1396,1197,-1,1410,1378,1435,-1,1369,1409,1431,-1,519,384,1027,-1,367,472,1027,-1,357,763,1222,-1,597,499,663,-1,568,558,586,-1,583,303,339,-1,208,187,140,-1,407,377,409,-1,1550,1130,583,-1,85,57,54,-1,1497,1169,1352,-1,1189,1352,1169,-1,622,1039,959,-1,249,1065,1229,-1,502,1129,638,-1,1416,1497,1496,-1,527,1039,622,-1,15,168,91,-1,630,458,1372,-1,250,54,495,-1,148,33,143,-1,1397,1497,1352,-1,1149,1322,1352,-1,350,604,327,-1,472,367,188,-1,1378,1170,916,-1,1283,1200,792,-1,328,87,94,-1,87,12,4,-1,816,304,1146,-1,1234,1210,244,-1,181,108,470,-1,100,49,44,-1,1282,1485,1266,-1,1364,1402,1469,-1,1436,1449,1343,-1,932,881,1119,-1,1519,1555,1498,-1,1499,1538,1509,-1,1025,1094,915,-1,865,1001,910,-1,577,228,196,-1,71,336,156,-1,288,492,1052,-1,1173,1130,1550,-1,1,2,24,-1,1120,1299,1259,-1,1278,1403,1311,-1,1493,1447,1388,-1,949,1289,882,-1,451,429,331,-1,154,162,265,-1,26,299,190,-1,1055,1083,1021,-1,299,198,458,-1,402,1224,728,-1,1223,1386,1343,-1,901,775,778,-1,1119,881,954,-1,962,746,745,-1,881,844,854,-1,318,425,334,-1,416,329,349,-1,262,272,124,-1,88,329,113,-1,610,642,212,-1,479,601,833,-1,899,456,518,-1,1026,1270,334,-1,318,324,531,-1,549,580,430,-1,372,697,487,-1,497,675,356,-1,96,70,134,-1,279,246,170,-1,436,1309,591,-1,12,48,169,-1,1309,436,215,-1,31,94,87,-1,40,41,94,-1,304,41,244,-1,1396,1309,815,-1,1155,632,1227,-1,1378,916,632,-1,459,916,1170,-1,1249,1399,1337,-1,1015,973,966,-1,875,1572,759,-1,884,759,1572,-1,673,602,418,-1,1072,973,933,-1,98,222,10,-1,653,418,165,-1,858,856,701,-1,689,898,1010,-1,700,522,535,-1,1233,1294,821,-1,1403,1336,1413,-1,45,268,44,-1,195,263,139,-1,400,413,554,-1,302,400,296,-1,402,195,387,-1,209,221,100,-1,300,476,197,-1,924,1176,813,-1,1120,1176,924,-1,1203,1176,1154,-1,6,180,337,-1,30,146,69,-1,929,722,940,-1,837,1161,1191,-1,1233,838,1267,-1,1008,449,207,-1,1251,1065,563,-1,478,201,346,-1,1013,723,822,-1,689,740,336,-1,123,191,313,-1,1065,285,563,-1,452,1149,747,-1,583,280,504,-1,604,1076,394,-1,830,1310,1011,-1,250,422,406,-1,1468,1417,1498,-1,1552,1535,1538,-1,907,328,816,-1,233,55,419,-1,346,461,484,-1,890,1092,974,-1,608,699,530,-1,420,640,537,-1,56,50,107,-1,17,106,46,-1,547,506,83,-1,1089,1276,559,-1,462,1097,1018,-1,1529,1303,1085,-1,1534,1548,1501,-1,1379,983,1260,-1,660,912,659,-1,1074,912,1342,-1,1284,1350,1536,-1,1272,1534,1253,-1,1380,1385,1029,-1,1126,731,408,-1,1272,1064,1205,-1,646,1079,890,-1,1571,1426,762,-1,477,437,381,-1,1384,1275,1107,-1,617,474,1107,-1,1088,755,636,-1,1377,1062,1104,-1,1495,1527,1414,-1,1344,1287,1193,-1,761,1023,879,-1,1315,1286,1268,-1,1136,1172,1121,-1,1043,1180,1133,-1,731,1113,820,-1,475,677,594,-1,677,561,712,-1,827,594,863,-1,1536,1350,1562,-1,590,611,906,-1,968,588,681,-1,51,0,588,-1,810,760,656,-1,686,562,615,-1,562,623,615,-1,633,595,557,-1,65,104,51,-1,323,512,1127,-1,111,142,184,-1,266,767,749,-1,340,366,159,-1,1500,1532,1533,-1,1542,1492,1383,-1,1500,1542,1566,-1,1355,1135,266,-1,1559,1401,1523,-1,1448,1494,1523,-1,1221,1128,1139,-1,1419,1429,1453,-1,1327,1263,1316,-1,1316,1252,1429,-1,1439,1502,1480,-1,1218,887,1073,-1,1005,1134,1095,-1,1255,1071,1041,-1,1238,565,1118,-1,1117,766,1020,-1,1033,737,1096,-1,958,1444,1354,-1,1466,1457,1242,-1,1312,1479,1452,-1,1242,1095,1134,-1,1255,1238,1147,-1,657,692,643,-1,637,641,745,-1,454,385,612,-1,775,679,661,-1,351,230,186,-1,1308,717,817,-1,817,358,1187,-1,1116,1376,1274,-1,751,552,752,-1,1370,1325,1420,-1,1157,1115,1124,-1,286,617,678,-1,126,23,77,-1,255,163,214,-1,274,455,314,-1,1570,1549,1569,-1,401,160,25,-1,1288,520,1078,-1,1501,1548,1387,-1,983,1379,1342,-1,699,983,660,-1,547,618,506,-1,34,32,72,-1,53,58,83,-1,230,125,137,-1,290,309,89,-1,1467,1530,1524,-1,1476,1566,1559,-1,289,792,374,-1,404,164,218,-1,1101,1185,1383,-1,1243,1167,965,-1,421,388,217,-1,175,251,217,-1,1138,1086,1512,-1,1274,1069,481,-1,1156,762,174,-1,671,204,936,-1,1558,1472,1415,-1,1047,1034,963,-1,75,74,174,-1,445,481,1069,-1,480,1301,347,-1,553,874,564,-1,405,388,564,-1,74,217,405,-1,1510,1512,1517,-1,42,25,160,-1,1164,1175,1179,-1,1405,1389,1276,-1,990,1235,1284,-1,1004,989,1016,-1,975,750,900,-1,1217,352,806,-1,1101,1209,546,-1,1054,546,1190,-1,151,141,184,-1,176,218,164,-1,266,375,171,-1,273,625,315,-1,1007,829,559,-1,644,1073,1037,-1,1420,1404,1503,-1,1276,1089,1239,-1,1414,1527,1425,-1,412,230,351,-1,321,382,596,-1,565,305,364,-1,255,766,694,-1,1153,1277,1511,-1,1354,1466,1225,-1,588,845,264,-1,569,237,315,-1,631,1489,1475,-1,993,1338,1514,-1,247,526,420,-1,1014,211,226,-1,1442,1216,736,-1,1549,1561,1454,-1,1275,1454,1511,-1,1092,890,1079,-1,1164,443,1175,-1,1553,1248,1281,-1,1340,974,1084,-1,477,755,878,-1,1556,1551,1457,-1,509,437,477,-1,1569,1265,1553,-1,1489,1563,1475,-1,1365,1182,1088,-1,1428,1474,1546,-1,1549,1384,1216,-1,1421,1512,1181,-1,515,547,58,-1,27,922,226,-1,358,84,194,-1,358,817,290,-1,239,186,317,-1,829,608,547,-1,996,620,889,-1,1067,845,1049,-1,1053,941,1074,-1,668,475,532,-1,185,203,454,-1,1486,1272,1279,-1,1564,1385,1557,-1,177,310,771,-1,1401,1247,1221,-1,1087,1105,1045,-1,1467,1428,1353,-1,252,51,104,-1,264,559,515,-1,690,0,252,-1,1116,936,204,-1,264,51,588,-1,893,630,1372,-1,1544,1270,1026,-1,1139,1196,1221,-1,1139,1201,1196,-1,526,852,727,-1,920,852,526,-1,788,852,1070,-1,852,788,783,-1,782,727,781,-1,640,727,782,-1,193,412,415,-1,193,230,412,-1,664,870,718,-1,664,1082,870,-1,873,801,730,-1,873,795,801,-1,1285,1250,1414,-1,1250,1285,606,-1,363,566,414,-1,517,566,363,-1,868,552,751,-1,552,868,618,-1,637,818,855,-1,637,746,818,-1,312,717,831,-1,312,309,717,-1,613,490,534,-1,613,634,490,-1,27,23,126,-1,29,23,27,-1,106,52,46,-1,52,106,157,-1,1141,560,1131,-1,514,560,1141,-1,1353,1274,1376,-1,1428,1274,1353,-1,403,488,736,-1,403,471,488,-1,576,471,509,-1,576,483,471,-1,1061,211,1014,-1,1061,247,211,-1,1041,1045,1105,-1,1041,988,1045,-1,107,61,111,-1,107,50,61,-1,398,242,232,-1,242,398,410,-1,89,109,105,-1,112,109,89,-1,616,721,635,-1,616,672,721,-1,1068,326,1018,-1,326,1068,150,-1,762,1335,938,-1,1335,762,1426,-1,1114,512,404,-1,1114,1127,512,-1,894,769,979,-1,750,769,894,-1,1100,944,1125,-1,944,1100,986,-1,1108,981,1077,-1,1108,989,981,-1,1033,1077,1020,-1,1108,1077,1033,-1,1483,1304,1452,-1,1304,1483,1314,-1,460,825,1078,-1,460,467,825,-1,1389,1437,1371,-1,1389,1405,1437,-1,25,990,443,-1,25,291,990,-1,361,160,401,-1,361,705,160,-1,923,1412,1433,-1,923,1069,1412,-1,1047,1351,1362,-1,1351,1047,1036,-1,560,161,389,-1,560,514,161,-1,609,1029,1385,-1,1029,609,874,-1,1432,1558,1568,-1,1432,1472,1558,-1,1539,1424,1433,-1,1529,1424,1539,-1,75,529,150,-1,529,75,445,-1,1250,1568,1441,-1,1568,1250,1432,-1,1110,812,1271,-1,1110,683,812,-1,225,335,229,-1,225,368,335,-1,64,130,135,-1,72,130,64,-1,572,530,699,-1,585,530,572,-1,665,585,650,-1,585,665,619,-1,1460,1349,1451,-1,1460,1319,1349,-1,1030,1085,596,-1,1030,1253,1085,-1,360,509,389,-1,360,576,509,-1,1185,676,785,-1,1185,1101,676,-1,861,868,751,-1,1104,868,861,-1,794,714,796,-1,794,613,714,-1,634,600,490,-1,634,661,600,-1,137,317,186,-1,137,341,317,-1,415,243,193,-1,427,243,415,-1,721,774,687,-1,721,777,774,-1,607,641,643,-1,687,641,607,-1,1567,1554,1551,-1,1567,1536,1554,-1,843,989,1004,-1,843,981,989,-1,981,849,986,-1,981,843,849,-1,1479,1562,1452,-1,1479,1554,1562,-1,1095,1312,1207,-1,1095,1242,1312,-1,887,1037,1073,-1,887,1028,1037,-1,1252,918,1199,-1,918,1252,1087,-1,1114,1391,1398,-1,1391,1114,688,-1,1014,1390,1061,-1,1357,1390,1014,-1,1162,1201,1139,-1,1162,1183,1201,-1,787,1247,1230,-1,787,743,1247,-1,1480,1505,1459,-1,1480,1502,1505,-1,1448,1334,1459,-1,1448,1326,1334,-1,1476,1355,1168,-1,1438,1355,1476,-1,1533,1531,1492,-1,1560,1531,1533,-1,1054,1492,1531,-1,1492,1054,1190,-1,806,200,289,-1,200,806,352,-1,815,177,776,-1,815,171,177,-1,261,199,277,-1,199,261,176,-1,335,199,229,-1,335,277,199,-1,512,151,213,-1,512,323,151,-1,557,993,1075,-1,595,993,557,-1,686,690,569,-1,686,760,690,-1,720,906,888,-1,720,590,906,-1,1332,1514,1338,-1,1504,1514,1332,-1,1434,496,1240,-1,1434,611,496,-1,858,867,903,-1,867,858,805,-1,826,914,851,-1,826,957,914,-1,948,1053,862,-1,948,941,1053,-1,1104,735,868,-1,1104,1062,735,-1,818,955,855,-1,834,955,818,-1,1112,1193,1268,-1,1112,1023,1193,-1,1204,925,967,-1,925,1204,1174,-1,996,1133,1180,-1,1198,1133,996,-1,1365,1376,1464,-1,1376,1365,1353,-1,286,314,379,-1,286,214,314,-1,381,1024,423,-1,381,392,1024,-1,561,654,664,-1,561,475,654,-1,1082,967,870,-1,1082,1204,967,-1,1250,281,850,-1,606,281,1250,-1,517,380,520,-1,517,363,380,-1,1113,1126,1461,-1,1113,731,1126,-1,1545,1313,1288,-1,1545,1564,1313,-1,1420,1097,1370,-1,1420,1018,1097,-1,1382,1387,1548,-1,1300,1387,1382,-1,1349,872,1003,-1,1349,1319,872,-1,800,828,713,-1,828,800,799,-1,1400,1451,1392,-1,1460,1451,1400,-1,646,1142,579,-1,646,652,1142,-1,711,917,939,-1,651,917,711,-1,913,704,809,-1,891,704,913,-1,428,524,505,-1,524,428,422,-1,191,187,293,-1,191,182,187,-1,189,39,320,-1,189,138,39,-1,667,577,910,-1,667,228,577,-1,839,800,801,-1,857,800,839,-1,207,6,260,-1,6,207,14,-1,449,1159,1165,-1,449,1008,1159,-1,1267,1294,1233,-1,1267,1341,1294,-1,344,231,424,-1,344,172,231,-1,2,359,24,-1,359,2,131,-1,949,1194,1289,-1,1099,1194,949,-1,283,1048,485,-1,283,510,1048,-1,708,704,693,-1,708,809,704,-1,554,662,447,-1,666,662,554,-1,397,296,447,-1,269,296,397,-1,707,397,624,-1,707,464,397,-1,510,1417,1048,-1,860,1417,510,-1,605,695,649,-1,695,605,614,-1,725,765,898,-1,725,869,765,-1,649,805,729,-1,784,805,649,-1,942,984,933,-1,848,984,942,-1,883,995,1002,-1,995,883,904,-1,1006,702,738,-1,1006,997,702,-1,973,345,966,-1,973,1072,345,-1,1409,1478,1431,-1,1409,1462,1478,-1,1455,1345,1446,-1,1455,1375,1345,-1,1262,1257,1394,-1,1262,1295,1257,-1,741,816,1146,-1,931,816,741,-1,11,582,763,-1,11,43,582,-1,1283,793,1374,-1,793,1283,792,-1,144,67,76,-1,144,147,67,-1,224,122,179,-1,224,116,122,-1,916,147,632,-1,178,147,916,-1,173,691,256,-1,173,448,691,-1,536,675,497,-1,545,675,536,-1,262,430,369,-1,329,430,262,-1,10,97,124,-1,97,10,18,-1,719,592,589,-1,592,719,724,-1,586,724,568,-1,724,586,592,-1,18,7,22,-1,37,7,18,-1,962,960,854,-1,962,877,960,-1,774,847,877,-1,847,774,777,-1,1330,1158,1381,-1,1330,1145,1158,-1,1258,1436,1386,-1,1232,1436,1258,-1,972,930,1080,-1,901,930,972,-1,263,841,268,-1,841,263,728,-1,1038,947,1081,-1,1038,897,947,-1,886,391,785,-1,472,391,886,-1,1063,1215,1188,-1,999,1215,1063,-1,563,542,976,-1,320,542,563,-1,223,115,123,-1,115,223,254,-1,991,897,908,-1,991,947,897,-1,1042,1001,865,-1,1042,991,1001,-1,1443,1509,1423,-1,1443,1499,1509,-1,1237,1347,1345,-1,1347,1237,1206,-1,507,542,301,-1,507,837,542,-1,5,322,121,-1,5,132,322,-1,1044,1496,1422,-1,1044,1129,1496,-1,394,866,80,-1,394,1214,866,-1,15,132,5,-1,132,15,91,-1,544,1009,180,-1,544,655,1009,-1,1406,1012,1188,-1,1012,1406,1059,-1,220,527,206,-1,220,538,527,-1,190,638,143,-1,502,638,190,-1,1372,1550,1528,-1,1550,1372,1408,-1,395,110,209,-1,110,395,444,-1,136,187,189,-1,140,187,136,-1,747,1111,492,-1,1106,1111,747,-1,272,93,124,-1,272,258,93,-1,493,540,518,-1,493,463,540,-1,592,463,493,-1,463,592,586,-1,621,473,450,-1,621,589,473,-1,802,670,626,-1,802,819,670,-1,1060,459,1170,-1,459,1060,448,-1,235,703,628,-1,235,146,703,-1,1244,503,556,-1,1244,1422,503,-1,847,950,926,-1,892,950,847,-1,1465,1485,1469,-1,1465,1463,1485,-1,1329,1178,1341,-1,1329,1161,1178,-1,1515,1478,1462,-1,1522,1478,1515,-1,833,882,1241,-1,882,833,601,-1,549,531,466,-1,587,531,549,-1,417,738,702,-1,417,581,738,-1,418,219,165,-1,418,280,219,-1,1360,516,543,-1,516,1360,1323,-1,1102,999,1063,-1,1093,999,1102,-1,59,295,298,-1,114,295,59,-1,1063,1098,1137,-1,1063,1188,1098,-1,1066,999,1093,-1,999,1066,909,-1,813,395,485,-1,813,685,395,-1,1223,1081,1055,-1,1103,1081,1223,-1,871,1232,1258,-1,871,757,1232,-1,464,932,442,-1,844,932,464,-1,1516,1525,1507,-1,1525,1516,1535,-1,260,1008,207,-1,1008,260,1057,-1,49,45,44,-1,86,45,49,-1,753,535,513,-1,614,535,753,-1,722,682,424,-1,722,934,682,-1,1160,1381,1158,-1,1343,1381,1160,-1,630,628,458,-1,628,630,893,-1,840,782,781,-1,840,921,782,-1,715,788,501,-1,715,783,788,-1,715,1046,840,-1,715,639,1046,-1,376,434,371,-1,434,376,373,-1,1002,1321,875,-1,1002,1337,1321,-1,501,434,411,-1,434,501,446,-1,1407,741,1146,-1,741,1407,789,-1,14,181,180,-1,181,14,108,-1,1229,1192,1111,-1,1192,1229,1297,-1,1022,1395,1363,-1,1119,1395,1022,-1,614,839,695,-1,614,753,839,-1,80,647,85,-1,80,866,647,-1,1535,1526,1525,-1,1526,1535,1552,-1,915,961,1025,-1,1021,961,915,-1,728,1266,841,-1,1282,1266,728,-1,1038,1103,1080,-1,1038,1081,1103,-1,1017,1258,1333,-1,1017,871,1258,-1,449,14,207,-1,449,108,14,-1,1066,985,917,-1,1093,985,1066,-1,1102,1137,1171,-1,1137,1102,1063,-1,55,441,325,-1,55,8,441,-1,1102,985,1093,-1,985,1102,1056,-1,349,431,416,-1,349,292,431,-1,1323,1473,1359,-1,1323,1360,1473,-1,995,581,919,-1,581,995,738,-1,1552,1543,1547,-1,1552,1540,1543,-1,1470,1491,1482,-1,1470,1321,1491,-1,964,645,278,-1,964,1178,645,-1,1469,1418,1465,-1,1418,1469,1402,-1,779,847,777,-1,779,892,847,-1,1409,1410,1435,-1,1369,1410,1409,-1,149,96,158,-1,149,122,96,-1,589,802,719,-1,621,802,589,-1,272,365,258,-1,272,353,365,-1,354,28,30,-1,354,81,28,-1,647,1408,1372,-1,647,866,1408,-1,959,1009,655,-1,1169,1009,959,-1,1039,1189,959,-1,1039,1040,1189,-1,538,249,541,-1,220,249,538,-1,331,168,206,-1,91,168,331,-1,1040,527,538,-1,1040,1039,527,-1,342,169,332,-1,342,118,169,-1,470,439,386,-1,470,742,439,-1,386,544,181,-1,544,386,453,-1,1381,1465,1418,-1,1449,1465,1381,-1,1021,1042,961,-1,1021,1083,1042,-1,1443,1347,1359,-1,1347,1443,1423,-1,908,1001,991,-1,908,937,1001,-1,937,910,1001,-1,937,970,910,-1,853,797,835,-1,797,853,796,-1,1259,1403,1358,-1,1259,1336,1403,-1,55,297,8,-1,55,233,297,-1,1055,947,1083,-1,1081,947,1055,-1,1463,1449,1436,-1,1465,1449,1463,-1,779,885,892,-1,779,775,885,-1,954,854,960,-1,854,954,881,-1,642,724,719,-1,724,642,610,-1,627,227,257,-1,227,627,543,-1,626,431,292,-1,626,670,431,-1,97,329,262,-1,113,329,97,-1,457,899,1026,-1,457,456,899,-1,580,369,430,-1,571,369,580,-1,675,372,356,-1,675,710,372,-1,173,356,134,-1,356,173,256,-1,639,393,516,-1,639,411,393,-1,342,786,338,-1,787,786,342,-1,116,76,67,-1,76,116,127,-1,127,169,48,-1,169,127,245,-1,133,436,117,-1,133,215,436,-1,789,1374,793,-1,789,1407,1374,-1,1394,815,776,-1,1396,815,1394,-1,1375,1298,1295,-1,1375,1393,1298,-1,1375,1237,1345,-1,1237,1375,1295,-1,1399,1060,1369,-1,1249,1060,1399,-1,933,1015,977,-1,933,973,1015,-1,702,977,584,-1,702,997,977,-1,943,904,883,-1,904,943,1006,-1,848,943,905,-1,848,942,943,-1,79,93,68,-1,79,9,93,-1,658,898,726,-1,725,898,658,-1,914,978,856,-1,978,914,957,-1,726,570,700,-1,689,570,726,-1,795,649,695,-1,795,784,649,-1,1413,1299,1468,-1,1299,1413,1336,-1,45,263,268,-1,139,263,45,-1,624,818,707,-1,624,834,818,-1,259,269,271,-1,259,296,269,-1,756,662,666,-1,756,824,662,-1,438,578,396,-1,438,387,578,-1,198,209,110,-1,198,221,209,-1,1259,1289,1194,-1,1358,1289,1259,-1,548,1203,1154,-1,1203,548,1184,-1,723,940,722,-1,940,723,1013,-1,172,413,241,-1,172,344,413,-1,645,1161,946,-1,645,1178,1161,-1,1254,1307,1329,-1,1296,1307,1254,-1,1111,1052,492,-1,1111,1192,1052,-1,30,503,354,-1,503,30,69,-1,689,223,570,-1,223,689,254,-1,748,800,857,-1,748,799,800,-1,123,182,191,-1,123,115,182,-1,853,908,897,-1,835,908,853,-1,651,598,461,-1,651,711,598,-1,646,880,652,-1,646,890,880,-1,704,814,732,-1,704,891,814,-1,1049,1144,1067,-1,1049,1148,1144,-1,1460,1440,1501,-1,1460,1400,1440,-1,800,730,801,-1,800,713,730,-1,1003,1320,1349,-1,1320,1003,1051,-1,1564,1361,1313,-1,1564,1557,1361,-1,414,1126,408,-1,566,1126,414,-1,281,306,343,-1,232,306,281,-1,1216,1569,1549,-1,1216,1442,1569,-1,379,617,286,-1,379,474,617,-1,525,1292,1088,-1,1062,1292,525,-1,756,761,879,-1,756,693,761,-1,1172,1268,1286,-1,1268,1172,1112,-1,855,1172,1136,-1,855,955,1172,-1,1187,1425,1324,-1,1187,1368,1425,-1,128,1062,525,-1,128,735,1062,-1,873,948,935,-1,873,941,948,-1,851,712,826,-1,696,712,851,-1,903,896,863,-1,896,903,867,-1,896,862,827,-1,896,948,862,-1,888,656,720,-1,681,656,888,-1,656,686,615,-1,656,760,686,-1,832,698,573,-1,562,698,832,-1,1240,599,631,-1,496,599,1240,-1,107,184,141,-1,184,107,111,-1,229,119,120,-1,199,119,229,-1,316,310,177,-1,310,316,277,-1,200,789,793,-1,789,200,159,-1,1383,1566,1542,-1,1383,1471,1566,-1,1559,1471,1456,-1,1566,1471,1559,-1,1458,1494,1430,-1,1523,1494,1458,-1,1427,1502,1391,-1,1505,1502,1427,-1,754,1128,1221,-1,754,790,1128,-1,1390,1419,1453,-1,1390,1357,1419,-1,1199,1439,1411,-1,1199,1218,1439,-1,876,1073,625,-1,876,1318,1073,-1,1000,887,859,-1,1000,1028,887,-1,1037,1211,1213,-1,1037,1028,1211,-1,1071,988,1041,-1,1071,900,988,-1,1016,969,1153,-1,1096,969,1016,-1,1314,1504,1332,-1,1314,1483,1504,-1,1304,1207,1312,-1,1207,1304,1220,-1,975,1125,944,-1,975,1147,1125,-1,1536,1570,1477,-1,1567,1570,1536,-1,643,612,607,-1,643,692,612,-1,635,687,607,-1,635,721,687,-1,616,415,574,-1,616,427,415,-1,90,194,84,-1,90,185,194,-1,683,861,550,-1,683,1110,861,-1,613,665,714,-1,613,534,665,-1,1335,648,938,-1,1335,1079,648,-1,1068,175,150,-1,1068,1219,175,-1,214,330,378,-1,214,286,330,-1,163,314,214,-1,234,314,163,-1,797,714,739,-1,797,796,714,-1,660,629,572,-1,629,660,603,-1,572,650,585,-1,650,572,629,-1,225,130,210,-1,225,135,130,-1,530,552,608,-1,552,530,489,-1,109,193,153,-1,109,125,193,-1,1317,717,1308,-1,1317,831,717,-1,850,1432,1250,-1,1432,850,1157,-1,1401,1230,1247,-1,1230,1401,1456,-1,1047,533,1036,-1,553,533,1047,-1,1472,1157,1246,-1,1432,1157,1472,-1,174,405,609,-1,405,174,74,-1,275,480,347,-1,321,480,275,-1,467,421,825,-1,467,555,421,-1,42,671,360,-1,42,204,671,-1,1211,1304,1314,-1,1220,1304,1211,-1,769,986,849,-1,769,944,986,-1,1480,1429,1411,-1,1453,1429,1480,-1,164,184,142,-1,164,213,184,-1,1317,1508,1271,-1,1317,1530,1508,-1,635,427,616,-1,427,635,482,-1,309,112,89,-1,312,112,309,-1,382,242,410,-1,267,242,382,-1,64,50,34,-1,50,64,61,-1,72,99,130,-1,72,66,99,-1,994,573,644,-1,994,832,573,-1,99,247,210,-1,211,247,99,-1,1143,1225,1134,-1,1225,1143,1273,-1,579,471,483,-1,579,488,471,-1,1142,1518,1248,-1,1518,1142,1565,-1,437,471,403,-1,437,509,471,-1,514,1086,291,-1,514,1141,1086,-1,317,550,239,-1,550,317,683,-1,468,534,490,-1,491,534,468,-1,309,817,717,-1,309,290,817,-1,521,239,550,-1,521,351,239,-1,82,65,56,-1,104,65,82,-1,306,414,408,-1,306,319,414,-1,965,529,1226,-1,965,494,529,-1,730,941,873,-1,941,730,768,-1,654,1082,664,-1,654,1300,1082,-1,205,284,385,-1,284,205,167,-1,414,276,363,-1,414,319,276,-1,1139,1070,1162,-1,1139,1128,1070,-1,252,569,690,-1,237,569,252,-1,51,58,53,-1,51,264,58,-1,1326,1201,1334,-1,1196,1201,1326,-1,741,159,435,-1,741,789,159,-1,1380,1557,1385,-1,1380,1461,1557,-1,380,347,460,-1,380,275,347,-1,185,551,194,-1,185,454,551,-1,814,718,870,-1,814,864,718,-1,46,38,47,-1,46,19,38,-1,608,618,547,-1,608,552,618,-1,669,855,1136,-1,669,637,855,-1,312,812,341,-1,831,812,312,-1,634,794,780,-1,613,794,634,-1,1557,1126,1361,-1,1461,1126,1557,-1,106,525,274,-1,128,525,106,-1,617,1277,678,-1,617,1275,1277,-1,29,226,66,-1,226,29,27,-1,526,640,420,-1,526,727,640,-1,1049,588,968,-1,1049,845,588,-1,330,766,378,-1,330,737,766,-1,29,19,23,-1,32,19,29,-1,63,104,82,-1,252,104,63,-1,889,606,1285,-1,398,606,889,-1,153,105,109,-1,153,167,105,-1,721,779,777,-1,672,779,721,-1,63,151,237,-1,151,63,141,-1,1071,1147,975,-1,1071,1255,1147,-1,750,944,769,-1,750,975,944,-1,1077,986,1100,-1,1077,981,986,-1,1563,1452,1562,-1,1452,1563,1483,-1,1545,1219,1541,-1,1219,1545,1490,-1,1424,1243,1226,-1,1239,1243,1424,-1,160,952,204,-1,705,952,160,-1,609,564,874,-1,609,405,564,-1,388,553,564,-1,533,553,388,-1,1301,1036,1032,-1,1301,1351,1036,-1,1415,1246,1362,-1,1415,1472,1246,-1,1568,1412,1546,-1,1568,1558,1412,-1,1226,1433,1424,-1,1226,923,1433,-1,1036,555,1032,-1,555,1036,533,-1,1236,1383,1185,-1,1236,1471,1383,-1,289,992,806,-1,289,374,992,-1,982,1458,1430,-1,982,1135,1458,-1,1029,1208,1380,-1,1029,1122,1208,-1,105,90,89,-1,105,203,90,-1,203,105,205,-1,368,210,420,-1,225,210,368,-1,798,739,811,-1,797,739,798,-1,799,811,828,-1,798,811,799,-1,489,585,619,-1,530,585,489,-1,1319,1501,1231,-1,1460,1501,1319,-1,1245,1518,1565,-1,1518,1245,1340,-1,619,521,489,-1,619,491,521,-1,125,112,137,-1,125,109,112,-1,679,779,672,-1,779,679,775,-1,687,745,641,-1,745,687,774,-1,843,928,849,-1,843,958,928,-1,1143,979,1273,-1,894,979,1143,-1,1242,1479,1312,-1,1242,1457,1479,-1,694,1118,565,-1,1118,694,1117,-1,1207,1005,1095,-1,1207,1000,1005,-1,1199,887,1218,-1,887,1199,859,-1,1218,1398,1439,-1,1218,1318,1398,-1,1183,920,1061,-1,1162,920,1183,-1,786,1230,1236,-1,786,787,1230,-1,1494,1459,1505,-1,1494,1448,1459,-1,1401,1448,1523,-1,1401,1326,1448,-1,1135,1438,1458,-1,1355,1438,1135,-1,335,310,277,-1,335,440,310,-1,404,213,164,-1,213,404,512,-1,846,562,832,-1,562,846,575,-1,573,686,569,-1,573,698,686,-1,590,623,633,-1,590,720,623,-1,805,935,867,-1,805,784,935,-1,914,903,851,-1,914,858,903,-1,23,46,52,-1,23,19,46,-1,1530,1308,1527,-1,1308,1530,1317,-1,1305,1121,1286,-1,1121,1305,1043,-1,834,911,955,-1,911,834,824,-1,1305,1205,1180,-1,1205,1305,1315,-1,1064,1180,1205,-1,996,1180,1064,-1,379,455,390,-1,379,314,455,-1,1107,423,1024,-1,1107,474,423,-1,381,403,392,-1,403,381,437,-1,864,957,826,-1,971,957,864,-1,1441,1414,1250,-1,1414,1441,1495,-1,276,321,275,-1,276,267,321,-1,520,1313,517,-1,520,1288,1313,-1,1078,1123,1490,-1,1123,1078,825,-1,1074,659,912,-1,768,659,1074,-1,828,659,713,-1,603,659,828,-1,1534,1371,1253,-1,1371,1534,1440,-1,1243,1089,1144,-1,1239,1089,1243,-1,229,135,225,-1,229,120,135,-1,1450,1179,1175,-1,1450,1281,1179,-1,377,346,484,-1,407,346,377,-1,441,917,985,-1,917,441,939,-1,1035,1151,1206,-1,921,1151,1035,-1,428,406,422,-1,428,327,406,-1,1019,1229,1106,-1,1019,541,1229,-1,857,753,902,-1,857,839,753,-1,156,172,21,-1,156,231,172,-1,478,154,201,-1,556,154,478,-1,260,28,288,-1,28,260,6,-1,449,470,108,-1,470,449,838,-1,1192,1057,1052,-1,1057,1192,1212,-1,1294,322,821,-1,1294,964,322,-1,593,424,682,-1,344,424,593,-1,1184,836,1171,-1,836,1184,359,-1,1166,1099,1154,-1,1166,1194,1099,-1,259,294,302,-1,370,294,259,-1,400,447,296,-1,554,447,400,-1,447,624,397,-1,447,662,624,-1,464,269,397,-1,464,442,269,-1,860,469,684,-1,510,469,860,-1,535,605,700,-1,614,605,535,-1,940,869,929,-1,940,765,869,-1,725,856,869,-1,701,856,725,-1,729,858,701,-1,729,805,858,-1,1072,165,345,-1,956,165,1072,-1,60,240,236,-1,60,68,240,-1,653,848,673,-1,848,653,984,-1,875,883,1002,-1,808,883,875,-1,942,1006,943,-1,997,1006,942,-1,584,1015,500,-1,584,977,1015,-1,1393,1455,1435,-1,1393,1375,1455,-1,1035,1237,1132,-1,1237,1035,1206,-1,591,1227,632,-1,1227,591,1197,-1,103,12,118,-1,103,4,12,-1,76,117,144,-1,76,48,117,-1,70,147,178,-1,70,67,147,-1,446,754,371,-1,754,446,790,-1,170,179,122,-1,179,170,227,-1,134,372,158,-1,372,134,356,-1,497,691,945,-1,256,691,497,-1,675,571,710,-1,571,675,545,-1,365,536,362,-1,536,365,545,-1,587,499,531,-1,499,587,663,-1,601,558,426,-1,601,479,558,-1,68,258,240,-1,93,258,68,-1,369,272,262,-1,369,353,272,-1,450,597,621,-1,425,597,450,-1,1,37,73,-1,1,7,37,-1,745,877,962,-1,745,774,877,-1,1158,950,998,-1,1145,950,1158,-1,1363,1484,1488,-1,1484,1363,1395,-1,1160,1080,1103,-1,972,1080,1160,-1,897,953,853,-1,953,897,1038,-1,909,235,628,-1,235,909,511,-1,1397,503,1422,-1,503,1397,354,-1,1241,1358,1278,-1,1289,1358,1241,-1,71,254,336,-1,71,115,254,-1,991,1083,947,-1,991,1042,1083,-1,758,799,748,-1,758,798,799,-1,835,798,758,-1,835,797,798,-1,1359,1206,1151,-1,1359,1347,1206,-1,1484,1469,1485,-1,1367,1469,1484,-1,1367,1364,1469,-1,132,821,322,-1,132,429,821,-1,117,591,144,-1,436,591,117,-1,582,1283,763,-1,1283,582,1200,-1,188,338,391,-1,338,188,103,-1,1019,538,541,-1,1019,1040,538,-1,143,350,148,-1,350,143,638,-1,190,5,26,-1,5,190,15,-1,655,453,622,-1,544,453,655,-1,1169,1416,1009,-1,1169,1497,1416,-1,1065,1297,1229,-1,1065,1251,1297,-1,1149,1106,747,-1,1019,1106,1149,-1,893,1528,1215,-1,1528,893,1372,-1,124,9,10,-1,124,93,9,-1,589,493,473,-1,493,589,592,-1,621,819,802,-1,819,621,597,-1,425,499,597,-1,318,499,425,-1,1399,1491,1337,-1,1399,1431,1491,-1,62,248,300,-1,44,248,62,-1,1145,926,950,-1,1145,1091,926,-1,1463,1266,1485,-1,1463,1261,1266,-1,1329,1191,1161,-1,1329,1307,1191,-1,1522,1509,1538,-1,1522,1515,1509,-1,1473,1499,1443,-1,1499,1473,1506,-1,804,1241,1278,-1,1241,804,833,-1,987,524,602,-1,524,987,830,-1,921,1046,1151,-1,840,1046,921,-1,1445,1543,1506,-1,1445,1544,1543,-1,298,949,882,-1,295,949,298,-1,1048,1468,1299,-1,1048,1417,1468,-1,495,1059,1280,-1,1059,495,432,-1,257,1195,627,-1,311,1195,257,-1,794,930,780,-1,794,953,930,-1,757,1261,1232,-1,757,764,1261,-1,707,844,464,-1,951,844,707,-1,915,860,684,-1,915,1094,860,-1,1031,1333,1223,-1,1031,1017,1333,-1,1507,1482,1516,-1,1507,1470,1482,-1,1159,1267,1165,-1,1267,1159,1254,-1,1044,604,350,-1,1044,1076,604,-1,934,913,682,-1,913,934,980,-1,1291,1364,1186,-1,1291,1402,1364,-1,1296,1159,1212,-1,1159,1296,1254,-1,840,783,715,-1,840,781,783,-1,373,245,238,-1,373,376,245,-1,1513,1521,1519,-1,1521,1513,1310,-1,373,224,393,-1,373,238,224,-1,1132,773,1035,-1,1132,772,773,-1,1297,1212,1192,-1,1212,1297,1296,-1,1330,1402,1291,-1,1418,1402,1330,-1,980,891,913,-1,980,971,891,-1,801,695,839,-1,795,695,801,-1,322,278,155,-1,322,964,278,-1,1008,1212,1159,-1,1008,1057,1212,-1,1021,684,823,-1,1021,915,684,-1,818,951,707,-1,746,951,818,-1,841,1261,764,-1,1266,1261,841,-1,1080,953,1038,-1,953,1080,930,-1,1547,1544,1447,-1,1547,1543,1544,-1,1520,1468,1526,-1,1520,1413,1468,-1,1012,432,444,-1,1012,1059,432,-1,299,221,198,-1,299,145,221,-1,1056,1171,836,-1,1171,1056,1102,-1,88,22,16,-1,88,113,22,-1,22,13,16,-1,22,7,13,-1,431,549,416,-1,549,431,587,-1,1506,1360,1445,-1,1360,1506,1473,-1,500,236,584,-1,500,60,236,-1,292,88,212,-1,349,88,292,-1,1540,1506,1543,-1,1540,1499,1506,-1,1555,1507,1525,-1,1555,1519,1507,-1,1329,1267,1254,-1,1341,1267,1329,-1,1291,1145,1330,-1,1145,1291,1091,-1,764,300,248,-1,764,757,300,-1,886,792,1027,-1,886,791,792,-1,719,626,642,-1,802,626,719,-1,457,425,450,-1,334,425,457,-1,545,353,571,-1,353,545,365,-1,6,30,28,-1,3,30,6,-1,1173,478,523,-1,1109,478,1173,-1,428,770,486,-1,428,505,770,-1,1408,1214,1173,-1,866,1214,1408,-1,893,999,909,-1,893,1215,999,-1,1040,1149,1189,-1,1040,1019,1149,-1,85,458,198,-1,458,85,647,-1,1331,337,1416,-1,703,337,1331,-1,451,622,453,-1,451,539,622,-1,1090,299,842,-1,502,299,1090,-1,285,206,168,-1,220,206,285,-1,118,338,103,-1,342,338,118,-1,439,453,386,-1,439,451,453,-1,757,476,300,-1,476,757,871,-1,1462,1446,1515,-1,1462,1455,1446,-1,835,937,908,-1,835,758,937,-1,758,970,937,-1,758,748,970,-1,593,708,680,-1,809,708,593,-1,233,711,297,-1,598,711,233,-1,684,709,823,-1,684,469,709,-1,853,794,796,-1,953,794,853,-1,1158,972,1160,-1,1158,998,972,-1,1436,1261,1463,-1,1261,1436,1232,-1,892,998,950,-1,892,885,998,-1,1091,960,926,-1,1091,954,960,-1,1407,1140,1374,-1,1407,1234,1140,-1,16,212,88,-1,212,16,129,-1,473,518,456,-1,473,493,518,-1,258,362,240,-1,258,365,362,-1,426,568,202,-1,426,558,568,-1,581,362,536,-1,581,417,362,-1,697,571,580,-1,697,710,571,-1,178,459,173,-1,178,916,459,-1,179,543,516,-1,179,227,543,-1,373,411,434,-1,411,373,393,-1,332,787,342,-1,787,332,743,-1,67,96,116,-1,96,67,70,-1,238,127,116,-1,127,238,245,-1,215,87,328,-1,215,133,87,-1,43,40,78,-1,43,11,40,-1,78,519,43,-1,78,384,519,-1,1374,763,1283,-1,1374,1222,763,-1,1262,1237,1295,-1,1237,1262,1132,-1,1369,1170,1410,-1,1369,1060,1170,-1,942,977,997,-1,933,977,942,-1,904,738,995,-1,904,1006,738,-1,883,905,943,-1,905,883,808,-1,905,673,848,-1,905,884,673,-1,700,658,726,-1,658,700,605,-1,658,701,725,-1,658,729,701,-1,929,856,978,-1,929,869,856,-1,1526,1547,1520,-1,1547,1526,1552,-1,442,271,269,-1,442,528,271,-1,662,834,624,-1,662,824,834,-1,370,271,396,-1,370,259,271,-1,693,666,708,-1,756,666,693,-1,396,507,370,-1,396,578,507,-1,1120,1194,1166,-1,1259,1194,1120,-1,1154,465,548,-1,465,1154,1099,-1,1171,1203,1184,-1,1171,1137,1203,-1,957,980,978,-1,957,971,980,-1,101,302,294,-1,101,241,302,-1,155,121,322,-1,155,86,121,-1,1251,1296,1297,-1,1296,1251,1307,-1,260,1052,1057,-1,288,1052,260,-1,452,492,81,-1,452,747,492,-1,902,513,667,-1,902,753,513,-1,902,748,857,-1,902,970,748,-1,138,115,71,-1,115,138,182,-1,486,327,428,-1,486,333,327,-1,1423,1345,1347,-1,1345,1423,1446,-1,377,102,409,-1,287,102,377,-1,1228,1179,1084,-1,1228,1164,1179,-1,650,714,665,-1,650,739,714,-1,1167,1144,1148,-1,1243,1144,1167,-1,1260,1276,1392,-1,1260,1007,1276,-1,347,555,467,-1,555,347,1032,-1,768,713,659,-1,730,713,768,-1,1231,668,803,-1,1231,1387,668,-1,1068,1541,1219,-1,1068,1503,1541,-1,520,460,1078,-1,460,520,380,-1,267,319,242,-1,267,276,319,-1,410,889,620,-1,398,889,410,-1,1174,1382,1344,-1,1382,1174,1204,-1,826,718,864,-1,826,712,718,-1,736,392,403,-1,736,1216,392,-1,474,390,423,-1,390,474,379,-1,1279,1315,1287,-1,1279,1205,1315,-1,879,824,756,-1,879,911,824,-1,955,1112,1172,-1,1112,955,911,-1,1324,1527,1308,-1,1324,1425,1527,-1,274,157,106,-1,274,234,157,-1,935,795,873,-1,795,935,784,-1,1003,827,862,-1,1003,872,827,-1,863,851,903,-1,851,863,696,-1,867,948,896,-1,867,935,948,-1,1483,1489,1504,-1,1563,1489,1483,-1,615,720,656,-1,623,720,615,-1,595,846,993,-1,575,846,595,-1,119,176,142,-1,176,119,199,-1,335,537,440,-1,335,368,537,-1,348,982,927,-1,348,375,982,-1,435,931,741,-1,733,931,435,-1,992,1560,806,-1,1560,992,1531,-1,793,289,200,-1,793,792,289,-1,1505,1430,1494,-1,1427,1430,1505,-1,1453,1348,1390,-1,1459,1348,1453,-1,1427,688,927,-1,1427,1391,688,-1,876,1398,1318,-1,1398,876,1127,-1,1000,918,1005,-1,918,1000,859,-1,1213,994,1037,-1,994,1213,1152,-1,1004,1153,1366,-1,1016,1153,1004,-1,1213,1314,1332,-1,1211,1314,1213,-1,1020,1100,1117,-1,1077,1100,1020,-1,1354,1556,1466,-1,1354,1444,1556,-1,433,159,200,-1,340,159,433,-1,607,482,635,-1,612,482,607,-1,574,672,616,-1,672,574,679,-1,312,137,112,-1,312,341,137,-1,600,415,412,-1,415,600,574,-1,619,534,491,-1,665,534,619,-1,1412,1274,1546,-1,1274,1412,1069,-1,880,1340,1245,-1,880,974,1340,-1,761,967,925,-1,761,732,967,-1,603,811,629,-1,811,603,828,-1,629,739,650,-1,739,629,811,-1,120,111,61,-1,111,120,119,-1,657,454,692,-1,657,551,454,-1,1030,1064,1272,-1,1064,1030,734,-1,1208,1461,1380,-1,1461,1208,1113,-1,1122,1115,1208,-1,1124,1115,1122,-1,340,1328,366,-1,340,1293,1328,-1,1269,1476,1168,-1,1269,1500,1476,-1,1236,1456,1471,-1,1236,1230,1456,-1,1362,1303,1415,-1,1362,1351,1303,-1,705,1181,1510,-1,361,1181,705,-1,963,1124,1122,-1,1124,963,1034,-1,1116,1481,1376,-1,1116,952,1481,-1,421,533,388,-1,555,533,421,-1,576,671,648,-1,360,671,576,-1,1464,1182,1365,-1,1464,1131,1182,-1,807,1144,1089,-1,1067,1144,807,-1,1097,401,1050,-1,1097,462,401,-1,1541,1564,1545,-1,1541,1571,1564,-1,1220,1028,1000,-1,1220,1211,1028,-1,1147,1118,1125,-1,1147,1238,1118,-1,979,849,928,-1,979,769,849,-1,792,676,546,-1,791,676,792,-1,1271,831,1317,-1,831,1271,812,-1,427,284,243,-1,427,482,284,-1,306,242,319,-1,306,232,242,-1,65,17,47,-1,53,17,65,-1,66,32,29,-1,72,32,66,-1,678,737,330,-1,678,969,737,-1,832,1152,846,-1,994,1152,832,-1,211,66,226,-1,211,99,66,-1,1045,1143,1134,-1,1045,988,1143,-1,1561,1551,1556,-1,1567,1551,1561,-1,576,508,483,-1,576,648,508,-1,1182,755,1088,-1,878,755,1182,-1,491,351,521,-1,491,468,351,-1,341,683,317,-1,812,683,341,-1,657,1136,1121,-1,657,669,1136,-1,47,56,65,-1,47,38,56,-1,566,1313,1361,-1,566,517,1313,-1,1527,1524,1530,-1,1527,1495,1524,-1,891,864,814,-1,971,864,891,-1,1300,668,1387,-1,1300,654,668,-1,167,243,284,-1,167,153,243,-1,363,275,380,-1,363,276,275,-1,773,440,537,-1,440,773,772,-1,1348,1201,1183,-1,1201,1348,1334,-1],
          coord=Coordinate(DEF='c6_Coord',point=[(-.50283,53.06068,-1.44633),(-.49849,53.0575,-1.4496),(-.44375,52.98255,-1.55065),(-.4424,53.45789,-1.42165),(-.43874,53.45551,-1.41829),(-.41996,53.42117,-1.49292),(-.01728,52.967,-2.24353),(0,52.97641,-2.33182),(0,52.98638,-2.23863),(.74475,53.1478,-1.15171),(.70296,53.12849,-1.14318),(.696,53.15044,-1.12451),(.43773,53.45548,-1.41775),(.43874,53.45551,-1.41829),(.41996,53.42117,-1.49292),(.56177,52.98213,-1.01962),(.53831,52.99806,-1.03641),(.5654,52.99894,-1.0145),(.53465,53.07633,-1.36371),(.45732,53.09985,-1.32307),(.51375,53.13973,-1.34694),(.41254,52.98489,-1.60272),(.4304,52.92897,-1.62361),(.44375,52.98255,-1.55001),(.06238,53.26434,-2.05039),(.13422,53.23251,-2.0418),(.12434,53.18552,-2.14522),(.01551,53.03897,-1.98106),(0,53.10747,-1.94721),(0,53.06159,-1.98862),(.76531,53.14226,-1.1245),(.73066,53.14635,-1.12451),(.78067,53.13188,-1.09989),(.2935,53.2683,-1.06214),(.28831,53.2389,-1.00916),(.29862,53.24757,-1.0067),(.32465,53.20032,-.91774),(.3128,53.19322,-.92067),(.33064,53.16511,-.87872),(.31974,53.20658,-.9272),(.33666,52.82638,-1.10073),(.36529,52.77494,-1.0279),(.31179,52.82535,-1.09868),(.17002,52.86192,-1.37376),(.171,52.88125,-1.38913),(.24581,52.89329,-1.38495),(.69308,53.10036,-1.2529),(.61898,53.0732,-1.27288),(.66656,53.09241,-1.28122),(.50796,53.17181,-.89299),(.46592,53.17157,-.87469),(.46401,53.10572,-.90634),(.33954,53.34341,-1.12011),(.3377,53.37032,-1.16527),(.28214,53.34205,-1.22725),(.40147,53.32437,-.86911),(.37822,53.24605,-.85726),(.38299,53.2436,-.84827),(.35412,53.15212,-.83815),(.35161,53.16705,-.84653),(.41005,53.42708,-1.51058),(.36289,53.41366,-1.59287),(.68507,53.13626,-1.20419),(.67687,53.13704,-1.16034),(.6728,53.09681,-1.18136),(.61279,53.25845,-1.15588),(.57449,53.30582,-1.16502),(.55933,53.3061,-1.12016),(.59104,53.2982,-1.22169),(.97922,53.20918,-1.12249),(.98447,53.17203,-1.10323),(1.05288,53.17865,-1.09723),(.91633,53.28399,-1.15792),(.91355,53.27949,-1.13655),(.91766,53.23962,-1.1354),(.79997,53.21933,-1.16307),(.74464,53.25649,-1.19279),(.75288,53.21705,-1.1748),(.85596,53.35705,-1.38828),(.91857,53.41917,-1.27617),(.85416,53.28355,-1.43354),(.96349,53.19238,-1.14703),(1.05113,53.14938,-1.12468),(.97514,53.148,-1.16236),(.93149,53.12591,-1.16015),(1.03574,53.11094,-1.12975),(.94315,53.16067,-1.17528),(.91294,53.1826,-1.20704),(.91768,53.23976,-1.15077),(.86236,53.12215,-1.19242),(.88587,53.10076,-1.1608),(.8373,53.0825,-1.18105),(.86839,53.07427,-1.11723),(.91673,53.08866,-1.12114),(.85051,53.10465,-1.08869),(.82231,53.51072,-1.14573),(.89474,53.48604,-1.21769),(.82032,53.54276,-1.17104),(.90778,53.36524,-1.17478),(.87982,53.45362,-1.1823),(.86756,53.42696,-1.1532),(.34045,53.17372,-.88192),(.35785,53.24487,-.89468),(.31463,53.40097,-1.66962),(.37134,53.41498,-1.57228),(.13599,53.32782,-1.81936),(.21855,53.3154,-1.77419),(.24108,53.38118,-1.7537),(.80824,53.11931,-1.33987),(.79352,53.13002,-1.33279),(.70469,53.11668,-1.29067),(.70278,53.10414,-1.29206),(.90314,52.9184,-1.52284),(.83438,52.87013,-1.58692),(.90661,52.91855,-1.53),(.79811,53.12827,-1.34336),(.9144,52.99317,-1.45669),(.88073,53.06616,-1.39019),(.87628,53.06196,-1.38135),(.44316,52.92928,-1.61902),(.51057,52.8649,-1.65723),(.53126,52.85532,-1.65354),(.79052,53.30586,-1.46473),(.78703,53.32185,-1.46668),(.85394,53.3719,-1.39416),(.89342,53.48965,-1.22421),(.81895,53.54362,-1.1765),(.50153,53.50745,-1.34444),(.4966,53.50615,-1.33956),(.55468,53.54744,-1.26606),(.41962,53.43229,-1.49293),(.29005,53.30524,-1.68705),(.29864,53.34305,-1.66986),(.55678,52.98974,-.95113),(.56473,53.0427,-.90921),(.53741,53.04326,-.92572),(.2107,53.32332,-1.22568),(.21705,53.25967,-1.14867),(.48586,53.27118,-.91708),(.5171,53.23524,-.91711),(.52201,53.24835,-.9462),(.51782,53.03646,-1.19649),(.49677,53.01991,-1.17304),(.45716,53.01064,-1.23548),(.52363,52.86527,-1.66542),(.63701,52.96741,-1.70154),(.65615,52.86245,-1.66691),(.13292,53.07624,-1.88169),(.10046,53.02281,-1.92725),(.1509,53.01784,-1.89394),(.08187,52.98906,-1.96008),(.26906,52.97311,-1.79164),(.26219,53.0097,-1.77861),(.20633,53.01478,-1.84919),(.34152,52.96054,-1.71783),(.39472,52.96087,-1.67546),(.33831,52.99616,-1.70744),(.13189,52.93144,-2.60105),(.18508,52.92704,-2.5806),(.115,52.92333,-2.56301),(.14602,53.1553,-2.4767),(.17055,53.15145,-2.53923),(.11763,53.15043,-2.53891),(.48614,53.16161,-1.65674),(.54382,53.19632,-1.62895),(.5439,53.15996,-1.65124),(.6154,53.33031,-1.49073),(.56592,53.34492,-1.48465),(.60053,53.37368,-1.4245),(.75456,53.14113,-1.28031),(.47573,53.00336,-1.14959),(.51148,53.03848,-1.14425),(.75144,53.17274,-1.16872),(.74757,53.12926,-1.16854),(.67209,53.1696,-1.18088),(.66285,53.15946,-1.14444),(.73562,53.16655,-1.20391),(.74692,53.19054,-1.18811),(.72151,53.18435,-1.19859),(.70209,53.04679,-.9922),(.69244,53.00498,-1.01838),(.66992,53.01567,-.99149),(.64592,53.0536,-.97445),(.66418,53.10986,-.94633),(.69948,53.0989,-.94956),(.59979,52.9563,-.9924),(.59197,52.90813,-.99839),(.60588,53.1532,-1.09657),(.5821,53.11252,-1.12214),(.66601,53.10229,-1.11319),(.74206,53.05901,-1.00649),(.74556,53.09858,-1.06355),(.73136,53.08148,-1.07552),(.61445,53.04591,-.96909),(.52622,53.10677,-1.04143),(.54746,53.16996,-1.01678),(.55297,53.08767,-1.01317),(.76003,53.10229,-1.05988),(.61729,53.17815,-1.09918),(.6806,53.12364,-1.10756),(.69407,53.14311,-1.10045),(.71413,53.11497,-1.24835),(.73015,53.03866,-1.02233),(.71929,52.99157,-1.05327),(.69461,52.98116,-1.02051),(.66273,52.97168,-1.00293),(.63504,53.12728,-1.16269),(.577,53.07954,-1.14945),(.56936,53.05788,-1.21224),(.08919,53.16544,-2.46645),(.12876,53.14354,-2.41208),(.16571,53.21856,-2.03803),(.21406,52.98025,-1.87114),(.23926,52.94539,-1.90352),(.29563,52.92949,-1.80524),(.06728,52.97145,-2.03127),(.01273,52.97146,-2.11885),(.13456,52.94679,-2.03686),(.13804,53.10409,-2.23444),(.10244,53.0481,-2.23088),(.1103,53.03669,-2.33092),(.06649,52.94326,-2.40364),(.06649,52.93831,-2.45962),(.12366,52.96444,-2.4257),(.17735,52.96452,-2.61849),(.20241,52.97146,-2.58109),(.53432,53.29023,-1.08484),(.49736,53.34786,-1.05102),(.50325,53.33799,-.99533),(.36218,53.30003,-.9223),(.32718,53.25397,-.94088),(.30215,53.22333,-.95569),(.27922,53.29767,-1.13286),(.37127,53.3544,-1.02723),(.4662,53.23132,-1.32856),(.46987,53.24347,-1.3647),(.49568,53.14987,-1.38462),(.35708,53.31384,-1.59841),(.35987,53.25544,-1.62079),(.39747,53.26467,-1.53228),(.39601,53.07886,-1.31335),(.42816,53.04993,-1.30553),(.38663,53.01709,-1.30423),(.23851,53.03241,-1.32891),(.23776,53.10403,-1.30384),(.30922,53.09897,-1.31992),(.38887,52.86705,-1.0907),(.39457,52.78069,-1.0309),(.36293,52.82806,-1.1027),(.75045,53.1591,-1.18293),(.76965,53.10824,-1.21873),(.76901,53.09855,-1.18842),(.55001,53.34951,-1.27622),(.6008,53.43555,-1.2282),(.5405,53.42829,-1.27332),(.58283,53.52316,-1.22722),(.55902,53.54778,-1.26327),(.49175,53.47913,-1.31732),(.65037,53.54304,-1.1792),(.72335,53.56813,-1.14916),(.63432,53.56711,-1.20226),(.64668,53.16242,-.92932),(.59851,53.13726,-.9532),(.60186,53.19437,-.92827),(.8229,53.06894,-1.08551),(.82649,53.04033,-1.0965),(.28323,53.34256,-1.23828),(.28416,53.34333,-1.23766),(.33621,53.33319,-1.24709),(.45215,53.31736,-.87675),(.40999,53.32432,-.86735),(.43354,53.2518,-.84996),(.47007,53.37394,-.91906),(.07405,53.24014,-1.1502),(0,53.22217,-1.14852),(0,53.1967,-1.06967),(.25736,53.1568,-.87843),(.26815,53.13933,-.83499),(.11742,53.08835,-.7475),(0,53.09681,-.80625),(0,53.07052,-.75804),(.2831,53.13034,-.81086),(.21318,53.12547,-.8051),(.22042,53.10719,-.77732),(.71542,53.28666,-1.50456),(.80488,53.26598,-1.49865),(.80599,53.20126,-1.54353),(.87481,53.15064,-1.51595),(.80605,53.1341,-1.57489),(.78932,53.42979,-1.35186),(.77963,53.40242,-1.38056),(.63685,53.56841,-1.20616),(.7244,53.56922,-1.15479),(.6939,53.52298,-1.256),(.54015,53.47898,-1.35475),(.55995,53.54803,-1.26906),(.49257,53.41489,-1.43541),(.4424,53.45789,-1.42165),(.52015,53.33341,-1.54036),(.46231,53.38602,-1.53318),(.51238,53.37448,-1.4706),(.64846,53.22308,-1.61559),(.62191,53.30132,-1.53213),(.70945,53.14099,-1.63126),(.64421,53.15389,-1.65442),(.71317,53.17878,-1.61576),(.51516,52.96693,-1.71826),(.47598,52.97892,-1.73885),(.47676,53.06705,-1.69348),(.40391,53.07704,-1.76188),(.32854,53.16528,-1.83836),(.40849,53.17219,-1.73484),(.38718,53.2643,-1.70997),(.47008,53.31047,-1.60623),(.39032,53.22444,-1.7146),(.08869,52.97864,-2.133),(.11546,53.16895,-2.24933),(.01728,52.967,-2.24351),(.05113,52.99709,-2.23435),(.13122,53.0972,-2.33188),(.14901,53.02777,-2.39926),(.18846,53.05486,-2.49009),(.15758,53.08155,-2.40392),(.19127,52.90794,-2.53183),(.2074,52.99038,-2.49092),(.32841,53.06472,-1.67911),(.26101,53.07084,-1.76547),(.50283,53.06068,-1.44576),(.46481,53.15951,-1.4378),(.83282,52.98116,-1.50717),(.83354,53.00328,-1.4747),(.7916,52.98917,-1.49908),(.66852,52.91468,-1.60226),(.72848,52.91244,-1.57933),(.71559,52.97801,-1.52356),(.53283,52.9584,-1.58082),(.57513,52.92911,-1.59799),(.58609,53.02289,-1.49728),(.57706,53.04761,-1.44978),(.52156,53.03551,-1.49141),(.6456,53.06607,-1.40518),(.62222,53.07615,-1.32648),(.77121,53.04728,-1.44866),(.81481,53.03582,-1.43353),(.79254,53.07395,-1.39844),(.89243,53.22555,-1.32517),(.90255,53.16286,-1.40897),(.88878,53.22518,-1.38229),(.17619,52.84187,-1.08678),(.1696,52.85451,-1.16793),(.26615,52.86812,-1.17284),(.2577,52.79449,-1.01156),(.17122,52.75232,-.94317),(.18186,52.80303,-1.0008),(.2647,52.84069,-1.08832),(.31659,52.79263,-1.009),(.64122,53.2048,-.86601),(.61589,53.19194,-.83206),(.67122,53.19628,-.80677),(.43272,53.40633,-1.40947),(.45769,53.4127,-1.35648),(.35006,53.06339,-.86869),(.40471,53.08976,-.89523),(.21474,53.0117,-.80576),(.28769,53.03116,-.84033),(.28591,53.12597,-.80247),(.33908,52.9942,-.88843),(.10679,52.81972,-.83374),(.2149,52.82481,-.83584),(.21776,52.89759,-.83683),(.2874,52.91037,-.86029),(.2908,52.83787,-.84506),(.35538,52.85315,-.89057),(.50716,53.34267,-1.11417),(.63675,53.3212,-1.24006),(.55124,53.31431,-1.25881),(.73285,53.54239,-1.13627),(.82826,53.47134,-1.1278),(.80726,53.32232,-1.17589),(.72684,53.31766,-1.22113),(.76906,53.09076,-.98998),(.78035,53.05359,-.9833),(.91607,53.16541,-1.10929),(.85664,53.15914,-1.11826),(.42682,52.87651,-.9894),(.41228,52.86746,-.94117),(.40442,52.80787,-1.01708),(.46077,52.97039,-.95184),(.39878,53.0114,-.92223),(.40212,52.94181,-.92341),(.47953,52.94532,-1.0142),(.50259,52.98367,-.95949),(.90117,53.20905,-1.25761),(.81398,53.1693,-1.26233),(.32451,52.92932,-1.35046),(.30414,52.89463,-1.34465),(.17051,52.92878,-1.36563),(.16726,53.02348,-1.31366),(.41667,52.90888,-1.08525),(.51947,52.94742,-1.0273),(.47748,52.96934,-1.07007),(.49441,53.02605,-1.06603),(.80141,53.01801,-1.12256),(.73998,53.04893,-1.12998),(.74858,53.05835,-1.15663),(.71478,53.08463,-1.16447),(.66486,53.1181,-1.14653),(.42104,53.14266,-1.32616),(.53131,53.05217,-1.30979),(.51923,53.03536,-1.24721),(.47422,53.07202,-1.31929),(.61831,53.07683,-1.31594),(.44358,53.33025,-1.38078),(.45028,53.25243,-1.41004),(.36988,53.07337,-1.61828),(.41349,53.06554,-1.56702),(.42866,53.16863,-1.49909),(.06395,53.26445,-1.85641),(.14018,53.25866,-1.83065),(.36161,53.15791,-1.31379),(.92363,53.11398,-1.09369),(.97811,53.10265,-1.12172),(.97614,53.12144,-1.09186),(.49403,52.89104,-1.68758),(-.91673,53.08866,-1.12168),(-.97811,53.10265,-1.12217),(-.93149,53.12591,-1.16058),(0,52.98755,-2.38432),(-.06649,52.94326,-2.4037),(-.39747,53.26467,-1.53248),(-.40532,53.31645,-1.51942),(-.42868,53.32603,-1.42128),(-.4662,53.23132,-1.32884),(-.46987,53.24347,-1.36496),(-.47943,53.33214,-1.3257),(-.69308,53.10036,-1.25348),(-.60801,53.07387,-1.22667),(-.67383,53.11061,-1.21248),(-.47422,53.07202,-1.31983),(-.53131,53.05217,-1.31041),(-.54694,53.07186,-1.35426),(-.75615,53.11932,-1.2501),(-.75456,53.14113,-1.2808),(-.70469,53.11668,-1.29122),(-.72004,52.91766,-1.02617),(-.69461,52.98116,-1.02131),(-.66273,52.97168,-1.00374),(-.53958,52.93517,-1.02385),(-.56177,52.98213,-1.02035),(-.53831,52.99806,-1.03708),(-.38663,53.01709,-1.30476),(-.35317,52.97391,-1.32475),(-.37237,52.92483,-1.24882),(-.34578,52.89673,-1.26788),(-.30414,52.89463,-1.34521),(-.30503,52.88555,-1.27468),(-.28024,52.87944,-1.32329),(-.34956,52.87774,-1.18674),(-.31409,52.86875,-1.18625),(-.36293,52.82806,-1.10342),(-.41228,52.86711,-.94305),(-.40442,52.80756,-1.01857),(-.35959,52.75839,-.92409),(-.88587,53.10076,-1.16133),(-.8373,53.0825,-1.18166),(-.8178,53.03413,-1.14949),(-.63726,52.89628,-1.00764),(-.59197,52.90813,-.99928),(-.64399,52.89605,-.98419),(-.55678,52.98974,-.95181),(-.51947,52.94742,-1.02805),(-.53628,52.99284,-.95713),(-.67122,53.19628,-.807),(-.66896,53.16652,-.81341),(-.61375,53.16949,-.83082),(-.50586,53.03606,-.94243),(-.50553,53.11281,-.90157),(-.53632,53.11702,-.89437),(-.46077,52.97039,-.95247),(-.42682,52.87651,-.99014),(-.17122,52.72393,-.95945),(-.16664,52.69371,-.92647),(-.26755,52.70215,-.9573),(-.77384,53.01145,-1.01271),(-.78035,53.05359,-.98393),(-.7876,53.07337,-1.03529),(-.85664,53.15914,-1.11863),(-.85051,53.10465,-1.08921),(-.81519,53.14421,-1.12507),(-.77233,53.06229,-.91552),(-.76906,53.09076,-.99052),(-.72684,53.31766,-1.22118),(-.70594,53.37513,-1.20423),(-.79573,53.39017,-1.16196),(-.62481,53.36,-1.24724),(-.74464,53.25649,-1.19298),(-.65989,53.2882,-1.23356),(-.50716,53.34267,-1.11424),(-.49736,53.34786,-1.05108),(-.46138,53.40024,-1.03629),(-.53432,53.29023,-1.08499),(-.55933,53.3061,-1.12029),(-.61279,53.25845,-1.1561),(-.43354,53.2518,-.85012),(-.46592,53.17157,-.87499),(-.4208,53.16356,-.8631),(-.28909,52.97183,-.8545),(-.33908,52.99408,-.88889),(-.34058,52.92174,-.88708),(-.2908,52.8188,-.86011),(-.2149,52.79511,-.85531),(-.21776,52.8762,-.84615),(-.47119,53.24398,-.88915),(-.45215,53.31736,-.87682),(-.47007,53.37394,-.91906),(-.46906,53.38926,-.97733),(-.50325,53.33799,-.99539),(-.48937,53.4153,-1.31195),(-.49175,53.47913,-1.31732),(-.53718,53.50012,-1.26729),(-.60017,53.20665,-.90124),(-.64122,53.2048,-.86626),(-.61589,53.19194,-.83232),(-.26615,52.86812,-1.17336),(-.2647,52.83752,-1.09001),(-.2577,52.77986,-1.0207),(-.27045,52.74344,-.97956),(-.31659,52.78469,-1.01645),(0,52.82316,-1.08817),(0,52.79843,-1.0089),(-.11051,52.78781,-1.01229),(-.80824,53.11931,-1.3404),(-.79254,53.07395,-1.3991),(-.75077,53.07369,-1.39598),(-.90255,53.16286,-1.40933),(-.91417,53.08273,-1.44321),(-.88073,53.06616,-1.39085),(-.90042,52.97886,-1.53723),(-.90661,52.91855,-1.53106),(-.92588,52.99055,-1.45976),(-.7916,52.98917,-1.49994),(-.77121,53.04728,-1.44938),(-.81481,53.03582,-1.43428),(-.70278,53.10414,-1.29264),(-.6456,53.06607,-1.40583),(-.54628,53.07211,-1.36743),(-.57706,53.04761,-1.45043),(-.52156,53.03551,-1.49204),(-.51136,53.00319,-1.52516),(-.45918,52.98332,-1.54578),(-.9144,52.99317,-1.45754),(-.90314,52.9184,-1.5239),(-.83282,52.98116,-1.50806),(-.4304,52.92897,-1.6243),(-.46048,52.90837,-1.65549),(-.40497,52.92388,-1.69372),(-.17189,52.97504,-1.93006),(-.21406,52.98025,-1.87144),(-.18408,52.96044,-1.96806),(-.01273,52.97146,-2.11887),(0,52.99791,-2.12516),(0,53.02356,-2.04228),(-.115,52.92333,-2.5631),(-.06678,52.94883,-2.51002),(-.10071,52.91497,-2.52591),(-.14901,53.02777,-2.39936),(-.15758,53.08155,-2.404),(-.18846,53.05486,-2.49017),(-.12876,53.14354,-2.41212),(-.17827,53.12853,-2.49164),(-.13122,53.0972,-2.33194),(-.1103,53.03669,-2.331),(-.05113,52.99709,-2.2344),(-.12434,53.18552,-2.14528),(-.11546,53.16895,-2.24937),(-.13804,53.10409,-2.23452),(-.21596,53.15803,-2.02983),(-.16086,53.12019,-2.14684),(-.23041,53.11522,-2.02943),(-.06238,53.26434,-2.05041),(-.10151,53.30064,-1.95936),(-.06359,53.31514,-1.95633),(-.38718,53.2643,-1.71014),(-.31336,53.20437,-1.83468),(-.39032,53.22444,-1.71482),(-.4155,53.35963,-1.60671),(-.47008,53.31047,-1.60636),(-.44523,53.37604,-1.55407),(-.48335,53.25096,-1.62118),(-.40391,53.07704,-1.7623),(-.40849,53.17219,-1.73514),(-.32854,53.16528,-1.8386),(-.47598,52.97892,-1.73949),(-.51516,52.96693,-1.71896),(-.47676,53.06705,-1.69398),(-.48614,53.16161,-1.6571),(-.54145,53.27766,-1.58449),(-.70945,53.14099,-1.63172),(-.71317,53.17878,-1.61613),(-.64421,53.15389,-1.65483),(-.62191,53.30132,-1.53227),(-.72615,53.25046,-1.56337),(-.71542,53.28666,-1.50469),(-.51238,53.37448,-1.47063),(-.52015,53.33341,-1.54045),(-.56592,53.34492,-1.48472),(-.49257,53.41489,-1.43541),(-.49935,53.44898,-1.41087),(-.50153,53.50745,-1.34444),(-.58671,53.50848,-1.30988),(-.55995,53.54803,-1.26906),(-.63685,53.56841,-1.20616),(-.65296,53.53466,-1.27201),(-.6939,53.52298,-1.256),(-.85394,53.3719,-1.39416),(-.91456,53.42468,-1.28567),(-.78932,53.42979,-1.35186),(-.85596,53.35705,-1.38828),(-.79052,53.30586,-1.46477),(-.80488,53.26598,-1.49878),(-.87481,53.15064,-1.51635),(-.87056,53.21465,-1.47282),(-.80599,53.20126,-1.54382),(-.26815,53.13933,-.83521),(-.2831,53.13034,-.81109),(-.22042,53.10719,-.77752),(-.10699,53.10548,-.80459),(-.11742,53.08832,-.74756),(-.33064,53.16511,-.87897),(-.25736,53.1568,-.87864),(-.3128,53.19322,-.92088),(-.07405,53.24014,-1.15025),(-.08072,53.198,-1.07359),(-.40999,53.32432,-.86741),(-.61729,53.17815,-1.09955),(-.696,53.15044,-1.12496),(-.69407,53.14311,-1.10091),(-.28231,53.34234,-1.23852),(-.33707,53.24211,-1.28651),(-.28323,53.34256,-1.23836),(-.60588,53.1532,-1.097),(-.56094,53.16901,-1.06294),(-.96349,53.19238,-1.14722),(-.94315,53.16067,-1.1756),(-.97514,53.148,-1.16268),(-.86839,53.07427,-1.11783),(-.85052,53.06063,-1.13658),(-.82649,53.04033,-1.0972),(-.64668,53.16242,-.92968),(-.65701,53.19298,-.90375),(-.60186,53.19437,-.92857),(-.65037,53.54304,-1.1792),(-.63432,53.56711,-1.20226),(-.72335,53.56813,-1.14916),(-.43272,53.40633,-1.40948),(-.43773,53.45548,-1.41775),(-.55902,53.54778,-1.26327),(-.58283,53.52316,-1.22722),(-.55001,53.34951,-1.27628),(-.5405,53.42829,-1.27332),(-.6008,53.43555,-1.2282),(-.76901,53.09855,-1.189),(-.75045,53.1591,-1.18336),(-.74757,53.12926,-1.16903),(-.39457,52.78004,-1.03293),(-.38887,52.86705,-1.09141),(-.30922,53.09897,-1.32027),(-.23851,53.03241,-1.32924),(-.31827,53.02339,-1.32703),(-.39601,53.07886,-1.31381),(-.42816,53.04993,-1.30606),(-.35708,53.31384,-1.59853),(-.51375,53.13973,-1.34739),(-.49568,53.14987,-1.38505),(-.34146,53.15564,-.8418),(-.27922,53.29767,-1.13298),(-.33954,53.34341,-1.12019),(-.37127,53.3544,-1.02729),(-.40147,53.32437,-.86917),(-.35785,53.24487,-.89485),(-.36218,53.30003,-.9224),(-.68194,53.20139,-.84844),(-.70086,53.18497,-.88089),(-.75295,53.16124,-.87655),(-.17735,52.96452,-2.61858),(-.18508,52.92704,-2.58072),(-.20241,52.97146,-2.5812),(-.19127,52.90794,-2.53198),(-.10244,53.0481,-2.23097),(-.12366,52.96444,-2.4258),(-.06109,52.98255,-2.33373),(-.06728,52.97145,-2.03136),(-.13456,52.94679,-2.03704),(-.26906,52.97311,-1.79203),(-.29563,52.92949,-1.80571),(-.16571,53.21856,-2.03811),(-.13422,53.23251,-2.04185),(-.06075,53.18044,-2.39401),(-.08919,53.16544,-2.46646),(-.63504,53.12728,-1.16318),(-.56936,53.05788,-1.21286),(-.69244,53.00498,-1.01913),(-.66992,53.01567,-.9922),(-.71929,52.99157,-1.05408),(-.51148,53.03848,-1.14486),(-.49441,53.02605,-1.06663),(-.52622,53.10677,-1.0419),(-.71413,53.11497,-1.2489),(-.7063,53.16233,-1.21324),(-.70296,53.12849,-1.14368),(-.74475,53.1478,-1.15216),(-.54746,53.16996,-1.01714),(-.55297,53.08767,-1.01369),(-.66418,53.10986,-.94681),(-.63038,53.127,-.94987),(-.61445,53.04591,-.96971),(-.73136,53.08148,-1.07611),(-.74556,53.09858,-1.0641),(-.74206,53.05901,-1.00712),(-.6806,53.12364,-1.10806),(-.66601,53.10229,-1.11374),(-.59979,52.9563,-.9932),(-.67786,53.06242,-.97783),(-.69948,53.0989,-.95007),(-.70209,53.04679,-.99284),(-.73562,53.16655,-1.20433),(-.72151,53.18435,-1.19897),(-.74692,53.19054,-1.18846),(-.67687,53.13704,-1.16083),(-.66285,53.15946,-1.14486),(-.68507,53.13626,-1.20468),(-.49677,53.01991,-1.17367),(-.45716,53.01064,-1.23609),(-.45212,52.97487,-1.15724),(-.47573,53.00336,-1.15023),(-.79352,53.13002,-1.3333),(-.60053,53.37368,-1.42451),(-.6154,53.33031,-1.49081),(-.6426,53.36135,-1.44157),(-.5439,53.15996,-1.65163),(-.54382,53.19632,-1.62927),(-.14602,53.1553,-2.47672),(-.11763,53.15043,-2.53892),(-.17055,53.15145,-2.53923),(-.13189,52.93144,-2.60114),(-.3821,52.99206,-1.6572),(-.39472,52.96087,-1.67605),(-.34152,52.96054,-1.71834),(-.20633,53.01478,-1.84946),(-.26219,53.0097,-1.77896),(-.08187,52.98906,-1.96019),(-.01551,53.03897,-1.98107),(-.10046,53.02281,-1.92737),(-.13292,53.07624,-1.88183),(-.1509,53.01784,-1.89413),(-.63701,52.96741,-1.70234),(-.52363,52.86527,-1.66633),(-.51782,53.03646,-1.19711),(-.51923,53.03536,-1.24784),(-.52201,53.24835,-.9464),(-.48586,53.27118,-.91723),(-.503,53.31098,-.95233),(-.21705,53.25967,-1.1488),(-.28214,53.34205,-1.22734),(-.53741,53.04326,-.92628),(-.21855,53.3154,-1.77425),(-.29864,53.34305,-1.66992),(-.29005,53.30524,-1.68716),(-.4966,53.50615,-1.33956),(-.89342,53.48965,-1.22421),(-.89474,53.48604,-1.21769),(-.82032,53.54276,-1.17104),(-.53126,52.85532,-1.65447),(-.51057,52.8649,-1.65812),(-.44316,52.92928,-1.61973),(-.87628,53.06196,-1.38202),(-.13142,53.38115,-1.80373),(-.24108,53.38118,-1.75372),(-.13599,53.32782,-1.8194),(-.3122,53.40022,-1.66782),(-.31463,53.40097,-1.66963),(-.36289,53.41366,-1.59287),(-.34045,53.17372,-.88216),(-.32465,53.20032,-.91795),(-.91985,53.39573,-1.22607),(-.90778,53.36524,-1.17478),(-.86756,53.42696,-1.1532),(-.92363,53.11398,-1.09414),(-.86236,53.12215,-1.19291),(-.84948,53.14158,-1.21611),(-.76965,53.10824,-1.21928),(-.91768,53.23976,-1.15086),(-.91294,53.1826,-1.20732),(-1.03574,53.11094,-1.13012),(-.68751,53.25492,-1.19797),(-.91633,53.28399,-1.15793),(-.91766,53.23962,-1.13549),(-.57449,53.30582,-1.16516),(-.59104,53.2982,-1.22184),(-.56587,53.22711,-1.08748),(-.57017,53.21623,-1.03984),(-.55209,53.24422,-1.03254),(-.90363,53.34022,-1.12956),(-.6728,53.09681,-1.18194),(-.45732,53.09985,-1.32355),(-.42104,53.14266,-1.32655),(-.41005,53.42708,-1.51058),(-.37134,53.41498,-1.57228),(-.35412,53.15212,-.83841),(-.35161,53.16705,-.84677),(-.37822,53.24605,-.85742),(-.38299,53.2436,-.84844),(-.3377,53.37032,-1.16532),(-.39327,53.39858,-1.10352),(-.36161,53.15791,-1.31412),(-.50796,53.17181,-.8933),(-.46401,53.10572,-.90675),(-.57181,53.06438,-1.31644),(-.61831,53.07683,-1.31656),(-.35818,52.73503,-.97271),(-.33492,52.73679,-.99392),(-.36529,52.77242,-1.03181),(-.31179,52.82444,-1.0999),(-.2935,53.2683,-1.06229),(-.29862,53.24757,-1.00686),(-.28831,53.2389,-1.00933),(-.05251,53.09216,-1.92385),(-.06186,53.2361,-2.14764),(-.41254,52.98489,-1.60331),(-.53465,53.07633,-1.36429),(-.5654,52.99894,-1.01519),(-.47748,52.96934,-1.07075),(-.24416,53.38239,-1.75873),(-.19275,53.3042,-1.88849),(-.237,53.2643,-1.90743),(-.08177,53.35805,-1.88657),(0,53.36783,-1.90074),(0,53.33806,-1.96691),(-.05755,53.16497,-1.89428),(-.06284,53.33016,-1.83426),(-.06395,53.26445,-1.85644),(0,53.26641,-1.86391),(-.32451,52.92932,-1.35102),(-.2838,52.7019,-.9288),(-.23878,52.87319,-1.36515),(-.577,53.07954,-1.15003),(-.5821,53.11252,-1.12264),(-.65832,53.08944,-1.12611),(-.66656,53.09241,-1.28181),(-.54377,53.24143,-.97855),(-.52925,53.27139,-1.02676),(-.8545,53.39179,-1.13913),(-.82826,53.47134,-1.1278),(-.28416,53.34333,-1.23774),(-.59851,53.13726,-.95362),(-.28591,53.12597,-.80271),(-.41962,53.43229,-1.49293),(-.46231,53.38602,-1.53319),(-.5147,53.32443,-1.54141),(-.82231,53.51072,-1.14573),(-.87982,53.45362,-1.1823),(-.71444,53.21292,-1.18616),(-.68523,53.20923,-1.19494),(-.64782,53.25641,-1.18884),(-.50562,53.32277,-1.2087),(-.55614,53.21076,-.99278),(-.39651,53.36712,-1.19089),(-.44674,53.35609,-1.19918),(-.43319,53.39599,-1.11529),(-1.05288,53.17865,-1.09735),(-1.03746,53.13455,-1.09671),(-.97614,53.12144,-1.09224),(-.91355,53.27949,-1.13657),(-.89265,53.22965,-1.13694),(-.75288,53.21705,-1.17508),(-.63675,53.3212,-1.24015),(-.55124,53.31431,-1.25895),(-.97922,53.20918,-1.1226),(-.86646,53.33138,-1.14868),(-.90117,53.20905,-1.25784),(-.64846,53.22308,-1.61587),(-.14127,53.38409,-1.80745),(-.07508,53.38759,-1.8181),(-.71413,52.86357,-1.64372),(-.72036,52.85123,-1.62623),(-.83438,52.87013,-1.58809),(-.79811,53.12827,-1.34387),(-.91857,53.41917,-1.27617),(-.7244,53.56922,-1.15479),(-.81895,53.54362,-1.1765),(-.55468,53.54744,-1.26606),(-.57315,53.183,-.86547),(-.5713,53.17048,-.86404),(-.53912,53.17193,-.88739),(-.73998,53.04893,-1.13067),(-.66486,53.1181,-1.14705),(-.73139,53.03951,-1.10403),(-.78228,53.00895,-1.09312),(-.8002,53.03649,-1.05824),(-.81547,53.08832,-1.06187),(-.8229,53.06894,-1.08613),(-.78067,53.13188,-1.10036),(-.24698,52.88533,-1.27766),(-.49403,52.89104,-1.6884),(-.01523,53.0057,-2.02959),(-.2074,52.99038,-2.49105),(-.22606,53.05614,-2.56871),(-.05881,53.17609,-2.45636),(-.70381,53.34566,-1.47171),(-.58424,53.44687,-1.36616),(-.54015,53.47898,-1.35475),(-.66658,53.51186,-1.28326),(-.7154,53.48468,-1.28655),(-.81398,53.1693,-1.26272),(-.74858,53.05835,-1.1573),(-.71478,53.08463,-1.16507),(-.40215,52.93968,-1.1666),(-.41667,52.90888,-1.08595),(-.69611,53.17816,-1.20948),(-.67209,53.1696,-1.18129),(-.66508,53.20063,-1.16229),(-.75144,53.17274,-1.16911),(-.74625,52.96108,-1.03981),(-.52877,53.10973,-1.10236),(-.63986,53.20108,-1.12654),(-.76999,53.18246,-1.15235),(-.76003,53.10229,-1.06042),(-.7647,53.121,-.92656),(-.72211,53.08235,-.96144),(-.57008,53.19479,-.95007),(-.56516,53.15399,-.97671),(-.73015,53.03866,-1.02301),(-.06308,53.17965,-2.33361),(0,53.20174,-2.3738),(-.16416,53.04447,-2.13541),(-.10681,53.11709,-2.56912),(0,53.08985,-2.52503),(-.06649,52.93831,-2.45968),(-.42529,53.39567,-.97038),(-.42396,53.3755,-.91679),(-.23666,53.18125,-.95379),(-.42217,53.2331,-1.30155),(-.48646,53.29737,-1.29766),(-.35987,53.25544,-1.62098),(-.34816,53.16557,-1.64104),(-.28006,53.16685,-1.74633),(-.42621,53.25937,-1.45282),(-.42866,53.16863,-1.49944),(-.76692,52.99911,-.96726),(-.69602,52.88397,-.96906),(-.73164,52.93555,-.89782),(-.44707,52.93911,-1.07831),(-.47953,52.94532,-1.0149),(-.08011,52.70503,-.87292),(-.0948,52.73676,-.85164),(-.20249,52.72353,-.85907),(-.91352,53.27553,-1.2192),(0,53.1458,-2.44933),(-1.05698,53.16505,-1.10578),(-.33621,53.33319,-1.24719),(-.76531,53.14226,-1.12495),(-.36988,53.07337,-1.6187),(-.4019,53.40007,-1.11248),(-.34303,53.3717,-1.17501),(-.06749,53.28112,-1.22642),(-.14389,53.24168,-1.15108),(-.15178,53.20958,-1.07081),(-.32668,53.30502,-1.04111),(-.16789,53.16691,-.95307),(-.09492,53.13758,-.88011),(-.08594,53.16672,-.94971),(-.21318,53.12547,-.80529),(-.43882,52.92005,-1.71587),(-.38079,52.92956,-1.76411),(-.90799,53.28762,-1.29095),(-.88878,53.22518,-1.38248),(-.90422,53.29028,-1.34724),(-.85416,53.28355,-1.4336),(-.6227,53.31407,-1.5326),(-.71012,52.96096,-1.66833),(-.83971,52.8756,-1.59732),(-.77963,53.40242,-1.38056),(-.74564,53.37391,-1.43111),(-.77366,53.46567,-1.29787),(-.33987,53.08619,-1.86375),(-.31762,52.9909,-1.89634),(-.40826,52.98604,-1.79757),(-.359,53.33314,-1.69056),(0,53.25369,-2.14894),(-.26685,53.17807,-1.94395),(-.26539,53.01904,-1.98261),(-.11584,53.14719,-2.33036),(-.18147,53.14941,-2.57318),(-.15907,53.01884,-2.62586),(-.26101,53.07084,-1.76577),(-.32841,53.06472,-1.6795),(-.46481,53.15951,-1.43819),(-.58609,53.02289,-1.49798),(-.62222,53.07615,-1.3271),(-.83647,53.16313,-1.34902),(-.89243,53.22555,-1.32535),(-.09277,52.86324,-1.26288),(-.1696,52.85405,-1.16916),(-.16547,52.87833,-1.27333),(-.09585,52.85037,-1.16501),(-.40471,53.08976,-.89562),(-.10679,52.79565,-.84991),(-.11453,52.87009,-.83069),(-.29459,52.7396,-.88307),(-.2874,52.89949,-.8664),(-.35538,52.84646,-.89803),(-.73285,53.54239,-1.13627),(-.80726,53.32232,-1.1759),(-.91607,53.16541,-1.1096),(-.09362,52.73296,-.95158),(-.39878,53.0114,-.92272),(-.46121,53.03202,-.93198),(-.72688,53.15349,-.78788),(-.71779,53.13775,-.91751),(-.33666,52.8262,-1.10161),(-.24581,52.89329,-1.38542),(-.16726,53.02348,-1.3139),(-.17051,52.92878,-1.36594),(-.80141,53.01801,-1.12332),(-.61898,53.0732,-1.27351),(-.44358,53.33025,-1.3809),(-.45028,53.25243,-1.41027),(-.41349,53.06554,-1.5675),(-.29067,53.16892,-1.29628),(.06109,52.98255,-2.33368),(.42868,53.32603,-1.42115),(.40532,53.31645,-1.51929),(.48646,53.29737,-1.29749),(.47943,53.33214,-1.32558),(.67383,53.11061,-1.21193),(.60801,53.07387,-1.22606),(.40215,52.93968,-1.16595),(.40729,52.96404,-1.24056),(.75615,53.11932,-1.24956),(.72004,52.91766,-1.0252),(.68255,52.88443,-1.01497),(.53958,52.93517,-1.02306),(.37237,52.92483,-1.24818),(.31827,53.02339,-1.32659),(.31409,52.86875,-1.18565),(.34956,52.87774,-1.18609),(.35959,52.76794,-.91166),(.8178,53.03413,-1.14875),(.63726,52.89628,-1.00669),(.64399,52.89605,-.98324),(.53628,52.99284,-.95647),(.61375,53.16949,-.83051),(.66896,53.16652,-.81312),(.53632,53.11702,-.89395),(.50553,53.11281,-.90115),(.50586,53.03606,-.94187),(.34058,52.92503,-.88413),(.29459,52.76246,-.86214),(.35818,52.7427,-.96226),(.16664,52.72414,-.90696),(.27045,52.76335,-.96452),(.7876,53.07337,-1.03469),(.77384,53.01145,-1.01197),(.81519,53.14421,-1.12464),(.77233,53.06229,-.91494),(.7647,53.121,-.92612),(.79573,53.39017,-1.16196),(.70594,53.37513,-1.20423),(.62481,53.36,-1.24722),(.65989,53.2882,-1.2334),(.46138,53.40024,-1.03629),(.58626,53.24777,-1.10976),(.4208,53.16356,-.86281),(.28909,52.97535,-.85339),(.0948,52.76029,-.83476),(0,52.82119,-.84119),(.10877,52.94401,-.80124),(.21247,52.96103,-.82232),(.48937,53.4153,-1.31195),(.53718,53.50012,-1.26729),(.60017,53.20665,-.90098),(.75077,53.07369,-1.39532),(.83647,53.16313,-1.34862),(.54628,53.07211,-1.36684),(.49849,53.0575,-1.44902),(.45918,52.98332,-1.54513),(.78975,52.94634,-1.5483),(.40497,52.92388,-1.69307),(.46048,52.90837,-1.65474),(.17189,52.97504,-1.92983),(.18408,52.96044,-1.96781),(.01523,53.0057,-2.02957),(.15907,53.01884,-2.62581),(.18147,53.14941,-2.57318),(.10681,53.11709,-2.56911),(.22606,53.05614,-2.56865),(.26539,53.01904,-1.98231),(.21128,53.24302,-1.95832),(.237,53.2643,-1.90734),(.26685,53.17807,-1.94379),(.06186,53.2361,-2.14762),(0,53.29584,-2.0512),(.4155,53.35963,-1.60665),(.33987,53.08619,-1.86342),(.40826,52.98604,-1.79703),(.31762,52.9909,-1.89593),(.54145,53.27766,-1.58431),(.48335,53.25096,-1.62096),(.58671,53.50848,-1.30988),(.77366,53.46567,-1.29787),(.91456,53.42468,-1.28567),(.74564,53.37391,-1.43111),(.71012,52.96096,-1.66746),(.83971,52.8756,-1.59616),(.71413,52.86357,-1.64261),(.6227,53.31407,-1.53249),(.70381,53.34566,-1.47169),(.87056,53.21465,-1.4726),(.91352,53.27553,-1.21917),(.90799,53.28762,-1.29093),(.10699,53.10548,-.80449),(.08072,53.198,-1.07353),(.15178,53.20958,-1.0707),(.14389,53.24168,-1.15098),(.06749,53.28112,-1.22639),(.14317,53.29491,-1.22871),(.3821,52.99206,-1.65666),(.39651,53.36712,-1.19083),(.81547,53.08832,-1.06131),(.05881,53.17609,-2.45635),(.18429,52.72411,-.87202),(.20249,52.75643,-.83485),(.44707,52.93911,-1.07762),(.76692,52.99911,-.9665),(.73164,52.93555,-.89694),(.69602,52.88397,-.96806),(.35317,52.97391,-1.32421),(.34578,52.89673,-1.26725),(.38915,53.16917,-1.56631),(.34816,53.16557,-1.64075),(.28193,53.24455,-1.71567),(.28006,53.16685,-1.74611),(.44747,53.30042,-1.25854),(.29111,53.21377,-.95799),(.23666,53.18125,-.95361),(.46121,53.03202,-.93145),(.68194,53.20139,-.8482),(.65701,53.19298,-.90347),(.14548,52.97514,-2.61336),(.10071,52.91497,-2.52583),(.16416,53.04447,-2.13526),(.16086,53.12019,-2.14674),(0,53.20965,-2.31864),(.06308,53.17965,-2.33359),(.65832,53.08944,-1.12553),(.73139,53.03951,-1.10333),(.7063,53.16233,-1.21281),(.68208,53.15001,-.92045),(.76999,53.18246,-1.152),(.66508,53.20063,-1.16195),(.63986,53.20108,-1.12621),(.52877,53.10973,-1.10187),(.56094,53.16901,-1.06256),(.63038,53.127,-.94942),(.74625,52.96108,-1.03893),(.56587,53.22711,-1.08721),(.52925,53.27139,-1.02658),(.69611,53.17816,-1.20909),(.84948,53.14158,-1.21567),(.45212,52.97487,-1.15658),(.54694,53.07186,-1.35367),(.57181,53.06438,-1.31582),(.72849,52.9242,-1.01298),(.66658,53.51186,-1.28326),(.65296,53.53466,-1.27201),(.74657,53.50617,-1.26222),(.7154,53.48468,-1.28655),(.58424,53.44687,-1.36616),(.5607,53.42009,-1.39656),(.49935,53.44898,-1.41087),(.6426,53.36135,-1.44155),(.32605,52.934,-1.81694),(.38079,52.92956,-1.76352),(.8002,53.03649,-1.05754),(.78228,53.00895,-1.09234),(.53912,53.17193,-.88707),(.5713,53.17048,-.86373),(.57315,53.183,-.86518),(.44523,53.37604,-1.55403),(.5147,53.32443,-1.5413),(.72036,52.85123,-1.62508),(.92588,52.99055,-1.45891),(.14127,53.38409,-1.80744),(.12807,53.34184,-1.88115),(.08177,53.35805,-1.88657),(.8545,53.39179,-1.13913),(.86646,53.33138,-1.14868),(.91985,53.39573,-1.22607),(.90276,53.14141,-1.18381),(.89265,53.22965,-1.13679),(.90309,53.20035,-1.12389),(.68751,53.25492,-1.19775),(.71444,53.21292,-1.18585),(.85468,53.18955,-1.13414),(1.03746,53.13455,-1.09643),(.44674,53.35609,-1.19911),(.43319,53.39599,-1.11529),(.54377,53.24143,-.97833),(.55614,53.21076,-.9925),(.57017,53.21623,-1.03956),(.50562,53.32277,-1.20858),(.64782,53.25641,-1.18862),(.34146,53.15564,-.84155),(.42217,53.2331,-1.30129),(.38827,53.32306,-1.25651),(.28231,53.34234,-1.23843),(.52456,53.25647,-.97453),(.55209,53.24422,-1.03231),(.71205,53.1162,-1.1551),(.23878,52.87319,-1.36468),(.06284,53.33016,-1.83424),(.05251,53.09216,-1.9238),(.05755,53.16497,-1.89423),(0,53.39351,-1.81875),(0,53.38998,-1.81507),(.05933,53.38487,-1.81611),(.24416,53.38239,-1.75871),(.28064,53.2945,-1.81094),(.33707,53.24211,-1.2863),(.29123,53.23612,-1.27193),(.19275,53.3042,-1.88844),(.13142,53.38115,-1.80372),(.07508,53.38759,-1.8181),(.06359,53.31514,-1.95632),(0,53.16345,-1.90923),(0,53.32994,-1.83225),(.28024,52.87944,-1.32275),(.47119,53.24398,-.88897),(.34303,53.3717,-1.17495),(.38043,53.24355,-1.2934),(.68523,53.20923,-1.19462),(.90226,53.27955,-1.13258),(.85052,53.06063,-1.13593),(.90363,53.34022,-1.12956),(1.05698,53.16505,-1.10562),(.54932,53.19252,-.89272),(.24698,52.88533,-1.27719),(.30503,52.88555,-1.27411),(.43882,52.92005,-1.71517),(.07587,52.98992,-2.55884),(.17827,53.12853,-2.49161),(.73145,53.43521,-1.34109),(.58371,53.06679,-.99114),(.72211,53.08235,-.96089),(.71779,53.13775,-.91711),(.06075,53.18044,-2.394),(.1857,53.10097,-2.61242),(.70086,53.18497,-.88061),(.42621,53.25937,-1.4526),(.08011,52.7253,-.85848),(0,53.27612,-1.22111),(.32668,53.30502,-1.04099),(.90422,53.29028,-1.34722),(.71399,53.30824,-1.50863),(.359,53.33314,-1.69048),(.8304,52.9607,-1.60385),(.31336,53.20437,-1.83449),(.22405,53.02215,-2.03833),(.22662,53.11179,-2.58002),(.06678,52.94883,-2.50997),(.51136,53.00319,-1.52448),(.90042,52.97886,-1.53635),(.91417,53.08273,-1.44262),(.11453,52.88989,-.82164),(0,52.74661,-.85321),(.26755,52.7256,-.93886),(.2838,52.72505,-.90842),(.71038,53.0788,-.81431),(.75263,53.08826,-.81072),(.72688,53.15349,-.78758),(.33492,52.74602,-.98313),(.24955,52.93801,-1.36169),(-.38915,53.16917,-1.56663),(-.40729,52.96404,-1.24119),(-.24955,52.93801,-1.36212),(-.50259,52.98367,-.96014),(-.40212,52.94181,-.92401),(-.07606,52.70527,-.90499),(-.80402,53.26336,-1.17146),(-.76994,53.46532,-1.14357),(-.52456,53.25647,-.97472),(-.35006,53.06339,-.86906),(-.45769,53.4127,-1.35648),(-.44502,53.05873,-1.51106),(-.36651,52.91916,-1.72864),(-.33831,52.99616,-1.70791),(-.22662,53.11179,-2.58004),(-.1857,53.10097,-2.61243),(-.22405,53.02215,-2.03857),(-.21128,53.24302,-1.95841),(-.78703,53.32185,-1.46669),(-.8304,52.9607,-1.60477),(-.71399,53.30824,-1.50871),(-.18906,53.14843,-.87816),(-.18429,52.69182,-.8946),(-.72849,52.9242,-1.01393),(-.28193,53.24455,-1.71583),(-.44747,53.30042,-1.25871),(-.5171,53.23524,-.91732),(-.29111,53.21377,-.95817),(-.14548,52.97514,-2.61343),(-.58371,53.06679,-.9917),(-.73145,53.43521,-1.34109),(-.74657,53.50617,-1.26222),(-.5607,53.42009,-1.39656),(-.07587,52.98992,-2.55888),(-.32605,52.934,-1.81744),(-.54932,53.19252,-.89301),(-.12807,53.34184,-1.88117),(-.90276,53.14141,-1.18422),(-.90309,53.20035,-1.12411),(-.90226,53.27955,-1.1326),(-.98447,53.17203,-1.10345),(-.28064,53.2945,-1.81103),(-.58626,53.24777,-1.11),(-.76646,53.12443,-.8667),(-.31974,53.20658,-.9274),(-1.05113,53.14938,-1.1249),(-.56473,53.0427,-.90978),(-.2107,53.32332,-1.22576),(-.65615,52.86245,-1.66797),(-.64592,53.0536,-.97506),(-.73066,53.14635,-1.12496),(-.23926,52.94539,-1.90387),(-.08913,53.05148,-2.57507),(-.75166,53.16155,-.84066),(-.41529,53.37423,-.91777),(-.30215,53.22333,-.95587),(-.32718,53.25397,-.94104),(-.38043,53.24355,-1.29363),(-.23776,53.10403,-1.30412),(-.69285,52.94439,-.89527),(-.29123,53.23612,-1.27213),(-.53926,53.39733,-1.42226),(-.80605,53.1341,-1.57536),(-.54522,53.06658,-1.68823),(-.08869,52.97864,-2.13311),(-.83354,53.00328,-1.47554),(-.10115,52.82594,-1.08732),(-.71038,53.0788,-.8148),(-.75263,53.08826,-.81119),(-.68255,52.88443,-1.01598),(.29067,53.16892,-1.29602),(.75295,53.16124,-.87623),(.80402,53.26336,-1.17133),(.76994,53.46532,-1.14357),(.503,53.31098,-.95223),(.22393,53.10012,-.76177),(.64627,52.96665,-1.55086),(.44502,53.05873,-1.51053),(.36651,52.91916,-1.72804),(.21596,53.15803,-2.02969),(.23041,53.11522,-2.02925),(.10151,53.30064,-1.95934),(.54522,53.06658,-1.68768),(.72615,53.25046,-1.56316),(.53926,53.39733,-1.42225),(.42396,53.3755,-.91679),(.69285,52.94439,-.89444),(.41529,53.37423,-.91777),(.08913,53.05148,-2.57504),(.56516,53.15399,-.97633),(.67786,53.06242,-.97723),(.3122,53.40022,-1.66781),(.39327,53.39858,-1.10351),(.76646,53.12443,-.8663),(.17123,53.26616,-1.96),(.22179,53.22791,-1.07532),(.0981,52.85321,-1.36622),(0,52.87177,-1.38207),(.0996,52.87315,-1.38236),(0,52.85109,-1.36323),(.56398,53.20806,-.92725),(.64874,53.02286,-.86081),(.65953,53.0948,-.82847),(.69449,53.01108,-.84564),(0,53.06325,-.74243),(.12028,53.08142,-.73181),(.41669,53.39432,-.97016),(.42529,53.39567,-.97038),(.06745,53.28141,-1.23741),(.14338,53.29543,-1.23966),(.41793,53.38116,-1.49732),(.86105,53.26827,-1.15048),(.85271,53.21996,-1.15006),(.80544,53.17753,-1.14404),(.56617,53.11416,-.87654),(.3327,53.28516,-.98693),(.36673,53.32722,-.97476),(.15983,53.18824,-1.01183),(.08594,53.16672,-.94964),(.16789,53.16691,-.95293),(.08364,53.18044,-1.00809),(.66924,53.38222,-1.41313),(.62159,53.39428,-1.39947),(.64361,53.42081,-1.36795),(.67596,53.45334,-1.32601),(.62184,53.482,-1.31728),(.89004,53.07824,-1.53537),(.8193,53.0632,-1.60027),(.60698,53.00029,-.98087),(.57008,53.19479,-.94976),(.42261,53.4056,-1.02996),(.4019,53.40007,-1.11247),(.21102,53.25248,-1.78995),(.13727,53.1636,-1.85665),(.21572,53.16252,-1.81605),(.23683,53.17468,-1.27945),(.15318,53.22577,-1.25522),(.15796,53.1587,-1.27599),(.22903,53.2428,-1.25771),(.37534,52.90626,-1.16848),(0,53.27681,-1.23215),(.07242,53.20746,-1.25389),(0,53.20323,-1.2561),(.41388,53.40434,-1.02955),(.22968,53.20155,-1.00747),(0,53.13141,-.87361),(.09492,53.13758,-.88002),(0,53.15911,-.95081),(.18906,53.14843,-.878),(.70212,53.40834,-1.37517),(.64598,53.06455,-1.68217),(0,53.22639,-2.24206),(.06388,53.2041,-2.2468),(.28145,53.09818,-1.96499),(.20575,53.07468,-1.83292),(.69416,53.03307,-1.46775),(.09585,52.8515,-1.1638),(.10115,52.83373,-1.08766),(0,52.84785,-1.16286),(.09362,52.7537,-.93944),(.11051,52.80448,-1.00732),(0,52.74906,-.95438),(.16547,52.87833,-1.27301),(.11104,52.99355,-.78467),(0,52.98449,-.78608),(.68156,53.4527,-1.18625),(.6451,52.95844,-.90668),(.75166,53.16155,-.84036),(.74415,53.00135,-.84626),(0,52.91823,-1.36509),(.09575,53.01378,-1.31478),(.09979,52.91831,-1.36011),(0,53.01461,-1.32559),(0,52.71713,-.87425),(-.57483,53.05676,-1.26111),(-.0996,52.87315,-1.38256),(-.09979,52.91831,-1.36029),(-.74415,53.00135,-.84695),(-.65953,53.0948,-.82894),(-.68156,53.4527,-1.18625),(-.10877,52.93037,-.80278),(-.21247,52.94922,-.82347),(-.21474,53.00751,-.80484),(-.28769,53.0309,-.84057),(-.12028,53.08135,-.73182),(-.11104,52.98522,-.78192),(-.22393,53.10012,-.76198),(-.0981,52.85321,-1.36643),(-.17002,52.86192,-1.37411),(-.17619,52.83396,-1.08813),(-.18186,52.78206,-1.00905),(0,52.86097,-1.25713),(-.71559,52.97801,-1.52443),(-.69416,53.03307,-1.46849),(-.53283,52.9584,-1.58159),(-.57513,52.92911,-1.59885),(-.66852,52.91468,-1.60323),(-.65847,52.84681,-1.65165),(-.72848,52.91244,-1.58035),(-.21572,53.16252,-1.81622),(-.20575,53.07468,-1.83314),(0,52.99081,-2.43204),(0,53.04592,-2.52094),(-.28145,53.09818,-1.96524),(-.64598,53.06455,-1.68278),(-.70212,53.40834,-1.37517),(-.67596,53.45334,-1.32601),(-.64361,53.42081,-1.36795),(-.22179,53.22791,-1.07547),(-.22968,53.20155,-1.00764),(-.41388,53.40434,-1.02955),(-.14317,53.29491,-1.22878),(-.14338,53.29543,-1.23973),(-.22903,53.2428,-1.25786),(-.2109,53.32411,-1.2367),(-.15318,53.22577,-1.25533),(-.79997,53.21933,-1.16332),(-.80544,53.17753,-1.1444),(-.37534,52.90626,-1.16914),(-.23683,53.17468,-1.27967),(-.15796,53.1587,-1.27615),(-.13727,53.1636,-1.85676),(-.21102,53.25248,-1.79006),(-.14018,53.25866,-1.83072),(-.56398,53.20806,-.92752),(-.71205,53.1162,-1.15563),(-.60698,53.00029,-.98158),(-.89004,53.07824,-1.53597),(-.8193,53.0632,-1.60091),(-.62184,53.482,-1.31728),(-.62159,53.39428,-1.39947),(-.66924,53.38222,-1.41313),(-.15983,53.18824,-1.01195),(-.08364,53.18044,-1.00816),(-.3327,53.28516,-.98706),(-.36673,53.32722,-.97484),(-.56617,53.11416,-.87697),(-.85271,53.21996,-1.15027),(-.85468,53.18955,-1.13443),(-.42261,53.4056,-1.02996),(-.69449,53.01108,-.8463),(-.171,52.88125,-1.38947),(-.05933,53.38487,-1.81612),(-.17123,53.26616,-1.96006),(0,52.99408,-2.47977),(-.6451,52.95844,-.90746),(-.59931,52.97316,-.92516),(-.86105,53.26827,-1.15055),(-.41793,53.38116,-1.49735),(0,53.17658,-1.00867),(-.71065,53.06005,-1.65849),(-.63845,53.00798,-.98689),(-.06388,53.2041,-2.24682),(-.68208,53.15001,-.92083),(-.16265,53.09129,-1.29478),(-.07242,53.20746,-1.25395),(0,53.14243,-1.27604),(-.08016,53.1432,-1.27561),(-.78975,52.94634,-1.54926),(-.64627,52.96665,-1.55171),(0,52.87822,-.83047),(0,52.93485,-.80802),(-.60909,53.10442,-.84489),(-.60268,53.03514,-.88289),(-.09575,53.01378,-1.31492),(.57483,53.05676,-1.26048),(.09277,52.86324,-1.26269),(.65847,52.84681,-1.65055),(.11584,53.14719,-2.33032),(.71065,53.06005,-1.65786),(.08016,53.1432,-1.27552),(.16265,53.09129,-1.29459),(.46906,53.38926,-.97733),(.63845,53.00798,-.98618),(.59931,52.97316,-.92442),(.63126,52.96399,-.99767),(.3584,53.35617,-1.58403),(.2109,53.32411,-1.23663),(.60909,53.10442,-.84445),(.60268,53.03514,-.8823),(.07606,52.72429,-.89209),(0,53.07818,-1.29807),(.08784,53.07861,-1.29494),(0,52.71606,-.90518),(-.63126,52.96399,-.99847),(-.64874,53.02286,-.86143),(-.38827,53.32306,-1.25663),(-.06745,53.28141,-1.23745),(-.08784,53.07861,-1.29505),(-.41669,53.39432,-.97016),(-.3584,53.35617,-1.58409)]),
          normal=Normal(vector=[(-.9991,-.0386,-.0189),(-.9961,-.0121,-.088),(-.995,.0891,.0457),(-.9942,.0328,.1024),(-.993,.0206,.1167),(-.9923,.1197,.0321),(-.9912,-.0556,.1198),(-.991,-.116,-.0665),(-.99,.1369,-.0329),(-.987,.1073,.1197),(-.9818,.0522,.1829),(-.9811,-.0501,-.1868),(-.9811,-.0408,-.1893),(-.9779,.0806,.1928),(-.9766,.1621,.1413),(-.9743,-.2058,-.0912),(-.9732,.1599,-.1652),(-.9694,-.1352,.205),(-.9632,.1624,-.2141),(-.955,-.0344,.2947),(-.9536,.2574,-.1561),(-.9523,-.2997,-.0574),(-.9495,.0228,-.3129),(-.9493,.086,.3022),(-.9489,.2195,.2269),(-.9466,-.2917,.1373),(-.9423,.1953,.272),(-.9379,.0142,.3465),(-.9371,-.3382,.0863),(-.9337,.0331,.3566),(-.9233,-.3643,.1221),(-.9194,.1178,.3752),(-.9184,.0288,.3945),(-.9167,-.1945,-.3491),(-.9142,-.0776,.3979),(-.9119,-.1886,-.3646),(-.9048,-.2516,-.3436),(-.904,-.427,.0215),(-.9038,-.1917,.3825),(-.8997,-.436,.0217),(-.8989,.1612,.4074),(-.8988,-.162,.4073),(-.8969,.1698,.4083),(-.8959,.3504,-.273),(-.8952,.4301,.1163),(-.8912,.2678,.366),(-.89,-.0854,.4479),(-.8843,-.24,.4006),(-.8834,.2367,-.4045),(-.8789,.4466,.1677),(-.8733,-.0763,.4812),(-.8724,.1334,.4702),(-.8706,.0988,.4819),(-.8706,-.3598,.3356),(-.8696,-.2893,.4003),(-.8671,.0095,-.4981),(-.8631,-.1872,.4691),(-.8593,.0066,.5115),(-.8506,-.2803,-.4449),(-.8482,.4242,.3173),(-.8419,-.495,-.215),(-.8402,-.0585,.5391),(-.8402,.5406,.0432),(-.8395,-.3226,.4373),(-.8385,-.131,.5289),(-.838,-.2875,.4638),(-.8367,-.0221,.5472),(-.8357,.1168,-.5366),(-.8341,.0658,-.5477),(-.8334,-.3719,.4088),(-.8322,.1671,-.5288),(-.831,-.4012,-.3853),(-.8281,-.1714,.5337),(-.8253,-.4639,-.3219),(-.8249,.4824,-.2947),(-.8245,-.0438,.5641),(-.8234,.145,-.5486),(-.8228,.2616,.5045),(-.8215,.4641,.3313),(-.8209,-.4063,.4013),(-.8188,.5036,-.2758),(-.8179,-.5726,-.0569),(-.817,-.2443,.5223),(-.817,.2114,-.5365),(-.8156,.326,.4781),(-.8141,.5463,-.1971),(-.8126,.5367,.2272),(-.8123,-.5108,.2815),(-.8116,.1133,-.5731),(-.8096,.4618,.3624),(-.8095,.3132,.4967),(-.8094,.2103,-.5483),(-.8093,.0779,.5821),(-.8093,.2198,-.5447),(-.8092,-.2791,.5171),(-.8073,.5843,.0828),(-.807,.3055,-.5055),(-.8057,.3927,-.4434),(-.8028,.0774,.5912),(-.8003,.0259,.599),(-.7989,.4676,.3783),(-.7985,-.2763,.5348),(-.7969,-.2362,-.5561),(-.7964,.6038,-.0346),(-.7961,-.2487,.5516),(-.7925,.4228,.4396),(-.792,.0409,.6091),(-.7912,-.2383,.5632),(-.7895,.5522,.2678),(-.7887,.551,.2726),(-.7885,.1751,.5895),(-.7856,-.1833,.591),(-.7853,.5729,.2348),(-.7819,.3411,-.5219),(-.781,.2604,.5677),(-.7807,-.5563,-.2848),(-.78,.3792,-.4978),(-.7794,-.3983,-.4836),(-.7785,.6055,-.1652),(-.7774,-.0717,.6249),(-.7751,-.1123,.6218),(-.7743,.607,.1789),(-.7716,.38,-.5101),(-.7714,-.5454,-.3278),(-.7713,.3419,-.5369),(-.7682,.5596,.3109),(-.7668,.6418,.0039),(-.7667,.389,-.5107),(-.7643,.6444,.0244),(-.764,.4099,-.4983),(-.7634,-.1526,.6276),(-.7625,.0306,.6463),(-.7592,.4886,-.43),(-.7537,-.6355,-.1672),(-.7537,.2271,-.6168),(-.751,-.192,.6318),(-.7484,-.4278,-.5069),(-.7475,.6311,.2073),(-.7465,-.5887,-.3101),(-.7452,.2811,.6048),(-.7451,-.6641,-.0619),(-.7435,-.4482,.4964),(-.7412,-.2669,.6159),(-.7387,-.518,.4313),(-.7358,-.3864,-.5561),(-.7336,.5094,.4499),(-.7329,.4183,.5366),(-.7328,-.3911,-.5568),(-.7296,-.6624,.1701),(-.7291,.2774,-.6256),(-.7268,-.6364,-.2584),(-.7262,-.4695,.5022),(-.7252,-.6765,.128),(-.7232,.6154,.3134),(-.7232,-.5925,.3549),(-.7194,.5896,.3671),(-.7186,-.6105,-.333),(-.7169,-.0078,.6971),(-.7152,.3182,-.6223),(-.7103,-.6174,-.3382),(-.7101,.1662,-.6842),(-.708,-.163,.6871),(-.7046,-.2803,.6519),(-.7031,.0913,.7052),(-.7027,-.4585,.5441),(-.7017,.0521,.7105),(-.7017,.235,.6726),(-.7011,.5163,.4918),(-.7008,.0954,-.707),(-.7,.6356,-.3257),(-.6994,.3061,-.6459),(-.6964,-.6441,.3164),(-.6948,-.4994,.5175),(-.6932,-.2088,-.6898),(-.6914,.6982,-.1856),(-.6911,-.2999,-.6576),(-.6893,-.3447,.6372),(-.6878,-.4998,.5264),(-.6846,-.4034,-.6071),(-.6843,.4962,-.5343),(-.6839,.5951,-.4221),(-.6817,.6868,-.2521),(-.6816,-.678,-.275),(-.6815,.7264,.0894),(-.6813,-.3467,.6447),(-.6777,.54,.4991),(-.6771,.6918,.2507),(-.6769,-.6929,-.2482),(-.6757,.7093,.2011),(-.6727,-.6716,-.3104),(-.672,-.522,.5253),(-.6718,-.6098,-.4204),(-.6717,.6163,.4111),(-.669,.6496,.3611),(-.6686,.457,.5866),(-.6679,.1791,.7224),(-.6675,-.0901,-.7392),(-.6653,.7455,-.0403),(-.665,.4829,.5698),(-.6631,-.1634,.7304),(-.6623,-.2726,-.6978),(-.6565,-.7451,-.1173),(-.6537,.715,-.248),(-.6524,.4465,.6124),(-.6521,.7508,-.1058),(-.6507,.4326,.624),(-.6475,.171,-.7426),(-.6472,-.1895,.7384),(-.6466,-.7623,-.0302),(-.6456,.6223,.4427),(-.6436,-.0789,.7613),(-.6433,.685,.3419),(-.641,.3698,-.6726),(-.6402,-.3999,.6559),(-.6362,.1122,.7633),(-.6327,-.7743,-.015),(-.6319,.6699,.3897),(-.6284,.3326,-.7032),(-.6252,-.6336,.4557),(-.6252,-.4381,.646),(-.6233,.1017,-.7753),(-.6221,.4389,.6484),(-.6205,-.5385,.5701),(-.6185,-.7294,-.2922),(-.6173,.5879,-.5228),(-.6168,-.189,.7641),(-.6155,.7144,.3329),(-.6124,.5304,-.5862),(-.6119,-.1303,-.7802),(-.6103,-.1554,.7768),(-.6086,.7174,.3391),(-.605,-.796,-.0185),(-.6017,.0262,.7983),(-.5997,-.7473,-.2864),(-.5863,-.0974,.8042),(-.5852,.211,.783),(-.5842,-.5331,-.6119),(-.5832,-.6827,.4402),(-.5826,.6129,-.5337),(-.5815,.7974,.1612),(-.5808,.0385,-.8131),(-.5716,-.0882,.8158),(-.5715,-.2215,.7902),(-.5713,.7339,.3675),(-.565,-.8205,.0866),(-.5638,.669,-.4844),(-.5637,.5258,-.637),(-.5584,.6519,.5131),(-.5576,.8174,.1448),(-.5575,-.0082,-.8302),(-.5573,-.8228,.1117),(-.5546,-.1278,-.8222),(-.5532,-.5655,.6117),(-.5519,-.6966,-.4584),(-.5502,-.7604,-.345),(-.5498,.7838,.2887),(-.5494,-.0725,-.8324),(-.5464,.6493,-.5291),(-.5453,.2255,-.8074),(-.5443,-.13,.8287),(-.5439,-.4785,.6894),(-.5437,-.4989,.6749),(-.5423,.4361,-.7181),(-.5419,.3335,.7714),(-.5416,-.833,-.1132),(-.54,-.7857,.3018),(-.5389,-.8419,.0286),(-.5358,-.4104,.738),(-.5352,.6567,.5313),(-.5348,-.2747,.799),(-.5321,.4485,.7181),(-.5289,-.306,.7916),(-.5259,.3482,-.776),(-.5253,-.8509,-.0024),(-.5233,.1116,.8448),(-.5205,-.5418,.6599),(-.5198,-.4046,.7524),(-.5194,-.2821,.8066),(-.5187,.557,.6486),(-.5184,.3212,-.7925),(-.5166,-.7285,.4499),(-.516,.5668,.6422),(-.5155,-.7202,-.4643),(-.5154,.8481,.1229),(-.5149,.6932,.5044),(-.5149,-.0749,-.854),(-.5125,.1156,.8509),(-.5114,-.0606,-.8572),(-.5109,-.7048,.4922),(-.5059,.0656,-.8601),(-.5054,.5088,.6969),(-.5045,-.5377,.6756),(-.5013,.3433,-.7942),(-.4997,-.768,-.4006),(-.4969,-.0698,.865),(-.4964,.4744,.727),(-.4961,-.1494,.8553),(-.4956,-.4423,.7475),(-.4944,.7759,.3917),(-.4936,.2095,.8441),(-.4928,.87,-.0142),(-.4927,-.4124,.7662),(-.4921,-.0463,.8693),(-.4909,-.8292,-.2672),(-.4895,-.6998,.5203),(-.4888,.8667,-.0997),(-.4883,-.0367,.8719),(-.4868,.8733,.0182),(-.4867,.3657,.7934),(-.486,.7576,.4356),(-.4823,-.3586,.7993),(-.4816,.6777,-.5557),(-.48,.8425,.2445),(-.4792,-.3227,-.8162),(-.4791,-.2123,.8517),(-.479,-.8773,-.0298),(-.4782,-.466,.7444),(-.4782,.8766,.0544),(-.4758,.7467,-.4648),(-.4755,-.267,.8382),(-.4737,-.854,.2153),(-.4722,-.571,.6715),(-.4707,.8737,.123),(-.4707,-.8448,.2547),(-.4697,.6961,-.543),(-.4681,.493,-.7334),(-.4647,-.7799,-.4194),(-.4631,-.8726,.1554),(-.4622,-.8267,.3207),(-.4574,.5901,-.6653),(-.4569,.7335,.5032),(-.4567,.3139,-.8324),(-.4527,.8544,-.2549),(-.4526,-.8916,.0156),(-.4523,.6497,-.611),(-.4513,-.235,.8608),(-.4505,-.6825,-.5755),(-.4503,.87,-.201),(-.4471,.8862,-.1215),(-.447,-.893,-.0522),(-.4455,-.8086,-.3843),(-.4452,.8885,.1111),(-.4451,.8639,-.2359),(-.445,.611,.6547),(-.444,-.5167,.732),(-.4435,-.2949,.8464),(-.4427,-.6802,-.5842),(-.4426,-.8237,-.3544),(-.4415,-.7116,.5466),(-.4395,.4203,-.7938),(-.4388,-.797,.4151),(-.4327,.8806,.1931),(-.4326,-.1188,-.8937),(-.4315,.2959,-.8522),(-.4311,-.6976,-.5723),(-.4298,-.8093,.4004),(-.4296,.3064,-.8495),(-.4288,-.2355,-.8721),(-.4282,.2674,.8632),(-.4272,.1891,.8842),(-.4243,.4279,.798),(-.4237,-.4653,-.7771),(-.4237,-.054,-.9042),(-.4232,-.4106,.8076),(-.4223,.8717,-.2486),(-.4209,.2036,-.8839),(-.4202,-.9014,-.1044),(-.4192,.8964,.1438),(-.4182,-.1981,.8865),(-.4176,.4023,-.8147),(-.417,-.1991,.8868),(-.4138,.8195,-.3965),(-.4129,.3642,-.8348),(-.4118,.7563,-.5084),(-.4103,.4774,-.777),(-.4058,-.8726,.2718),(-.4036,.7961,-.451),(-.4008,-.5342,-.7443),(-.4007,.8296,.3888),(-.4004,-.2768,.8735),(-.4002,-.6122,.682),(-.3995,-.0769,.9135),(-.3976,-.4324,.8093),(-.3965,-.0316,.9175),(-.3943,.9157,.0773),(-.3929,.7082,.5866),(-.3924,.8039,-.447),(-.3919,-.1967,.8987),(-.3918,.3533,-.8495),(-.3897,.2099,.8967),(-.3869,-.3427,.8561),(-.3862,.922,-.0289),(-.386,-.047,.9213),(-.3855,.7436,-.5463),(-.3854,-.921,.0557),(-.3852,.6532,.6518),(-.3852,-.3587,.8502),(-.3848,-.3538,.8525),(-.3842,.1442,.9119),(-.3819,-.9236,-.0321),(-.3803,-.0698,.9222),(-.3783,-.539,-.7526),(-.3764,.0969,.9214),(-.3752,.0386,.9262),(-.3749,-.9096,.1793),(-.3742,.5884,-.7167),(-.3715,-.8934,.2525),(-.3676,-.5698,-.735),(-.3673,-.1582,.9166),(-.3662,-.645,-.6708),(-.3616,-.2476,.8989),(-.3612,.7756,-.5177),(-.3612,.8069,.4673),(-.36,-.0896,.9286),(-.3599,-.2712,.8927),(-.3594,.8525,.3795),(-.3585,.4611,-.8117),(-.3534,-.4945,-.7941),(-.3528,-.6171,.7033),(-.3502,-.048,-.9355),(-.3499,-.2344,.907),(-.3451,.1413,-.9279),(-.3446,-.9387,-.0092),(-.3422,-.2739,.8988),(-.342,-.9147,.2152),(-.3416,.654,-.675),(-.3409,.9097,-.2373),(-.3398,.8619,.3764),(-.3394,-.94,-.0355),(-.339,.6926,-.6366),(-.339,.6704,-.66),(-.3387,.2807,-.898),(-.3375,-.1596,.9277),(-.336,-.6372,-.6936),(-.3357,.7937,-.5073),(-.3344,-.9378,.0933),(-.3343,-.8649,-.3744),(-.3341,.1304,.9335),(-.3334,-.3135,.8891),(-.3328,.7824,-.5264),(-.3319,-.3614,.8713),(-.3315,.9241,.1899),(-.3305,.3998,.8549),(-.3277,-.887,-.3255),(-.3274,-.1181,.9375),(-.3266,-.3479,.8788),(-.326,.8004,-.503),(-.3248,-.2732,.9055),(-.3231,-.8436,-.4288),(-.3215,.2792,.9048),(-.3211,.5696,-.7566),(-.3205,.4505,-.8333),(-.3186,-.5284,-.787),(-.3183,.5349,-.7827),(-.3176,.8192,.4776),(-.3163,-.1303,.9397),(-.3153,.671,-.6711),(-.3151,.6085,-.7283),(-.3135,.94,-.1345),(-.3125,-.8635,-.396),(-.3077,-.888,.3418),(-.3076,-.9509,.0344),(-.3068,-.7077,-.6365),(-.3059,.6028,-.7369),(-.3036,.3231,.8964),(-.303,.1107,.9466),(-.3025,.4873,-.8192),(-.3019,-.6501,-.6973),(-.3013,.8817,.3631),(-.3011,.8314,-.467),(-.3011,.9533,.0218),(-.2999,.2566,.9188),(-.2996,.9538,-.0201),(-.2992,.6386,-.709),(-.2991,-.2738,.9141),(-.2976,-.7794,-.5514),(-.2973,.9158,-.2701),(-.2964,.2986,.9072),(-.2944,-.8069,-.512),(-.2932,.7844,-.5466),(-.289,-.8202,-.4937),(-.2872,-.073,.9551),(-.2781,.883,.3781),(-.2779,.4308,.8586),(-.2769,-.6089,-.7434),(-.2733,.8746,.4006),(-.2732,-.9458,-.1754),(-.2657,.6106,-.746),(-.2634,.1709,.9494),(-.2622,.2924,-.9197),(-.2607,.9094,.324),(-.2606,.7816,-.5668),(-.2603,-.9291,.2628),(-.2585,.6128,-.7468),(-.2561,-.9087,-.3298),(-.2561,-.4446,.8583),(-.2529,-.7597,.5991),(-.2527,-.1134,-.9609),(-.2526,.8856,-.3898),(-.2526,.8551,-.4528),(-.2524,-.7703,.5855),(-.2517,.8484,-.4658),(-.2514,-.3326,.909),(-.2507,-.9311,-.265),(-.2501,-.8571,.4503),(-.2493,-.9366,-.2464),(-.2482,.402,-.8813),(-.2466,-.3197,.9149),(-.2466,.4437,.8616),(-.2449,.32,.9152),(-.2447,.9411,-.2334),(-.2441,.0993,.9646),(-.2437,-.9296,.2763),(-.2436,-.1821,-.9526),(-.2414,-.4361,.8669),(-.2401,-.2002,-.9499),(-.24,.9183,-.3148),(-.2399,-.4625,.8535),(-.2396,.7011,-.6715),(-.2373,.8932,-.3819),(-.2364,-.664,.7094),(-.236,.7537,-.6134),(-.2352,-.9713,-.0349),(-.2351,-.5084,-.8284),(-.2344,-.972,-.0186),(-.2335,.8444,.4821),(-.2325,.3721,.8986),(-.2315,.2665,-.9356),(-.2297,.0476,.9721),(-.2293,-.9728,-.0326),(-.2274,.2922,-.9289),(-.226,.4593,-.859),(-.2259,-.8774,-.4233),(-.2256,.2788,-.9335),(-.2238,.7381,-.6365),(-.2238,-.9221,-.3156),(-.223,-.0662,-.9726),(-.2218,-.2964,.929),(-.2214,.2132,-.9516),(-.2199,.3009,-.928),(-.2198,.7799,-.5861),(-.2192,.1384,-.9658),(-.2184,-.6318,.7437),(-.2175,.9218,-.321),(-.217,.6541,-.7246),(-.215,.2362,-.9476),(-.2142,.8854,-.4127),(-.2114,.0027,-.9774),(-.2113,-.1107,.9711),(-.2109,.4195,-.8829),(-.2099,.9486,-.237),(-.2095,.7986,.5642),(-.2086,.3208,-.9239),(-.2078,.4107,-.8878),(-.2058,-.1808,.9617),(-.2049,.2028,-.9575),(-.2039,-.9379,-.2806),(-.1981,-.7114,.6744),(-.1978,.7648,-.6132),(-.1963,-.6626,-.7228),(-.1945,-.1418,.9706),(-.1934,-.6871,-.7003),(-.1865,-.6204,.7618),(-.1821,-.9234,-.3378),(-.1815,.5518,-.814),(-.1808,.9052,-.3847),(-.18,-.3355,.9247),(-.1791,-.543,-.8204),(-.1787,.7787,-.6015),(-.1784,-.7128,.6783),(-.1777,-.9773,-.1154),(-.1763,.3889,-.9043),(-.176,.3055,-.9358),(-.176,-.9752,.1343),(-.1759,.9176,.3565),(-.1758,-.6119,.7712),(-.1752,.4508,.8752),(-.1742,.1514,-.973),(-.174,-.3745,.9107),(-.1735,.3456,.9222),(-.1717,.5826,-.7944),(-.1709,-.4939,-.8526),(-.1699,.2939,-.9406),(-.1697,-.978,-.1213),(-.169,-.9472,.2725),(-.1689,.3083,-.9362),(-.168,.6889,-.7051),(-.1646,.4885,-.8569),(-.1643,-.9726,.1643),(-.1637,.7158,-.6788),(-.1625,-.7909,.5899),(-.1577,-.9811,-.1121),(-.1577,.6934,-.7031),(-.1574,-.4832,.8612),(-.1558,-.9082,-.3884),(-.1505,-.6348,.7579),(-.1504,-.6406,.753),(-.1495,.7671,-.6239),(-.1475,-.9891,.0046),(-.1469,-.8031,.5774),(-.1444,.8674,.4761),(-.1443,.9877,-.0598),(-.1411,-.9772,.1585),(-.1408,.3677,-.9192),(-.1366,-.9904,-.0216),(-.1366,-.9897,-.0424),(-.1363,.6894,.7115),(-.1341,.936,.3253),(-.1341,.1677,-.9767),(-.1328,.7107,-.6908),(-.1326,.7871,-.6024),(-.1317,-.7963,.5904),(-.1309,.912,.3887),(-.13,.7651,-.6306),(-.1293,-.9144,-.3836),(-.1289,-.7338,.667),(-.1273,.9305,.3435),(-.1259,.1908,.9735),(-.1252,.353,-.9272),(-.1242,.264,-.9565),(-.1226,-.303,.9451),(-.1218,.718,-.6853),(-.1217,.4312,-.894),(-.1217,-.708,.6956),(-.1213,-.4105,.9037),(-.1212,-.7336,-.6687),(-.1204,.784,-.609),(-.1163,.9631,-.2428),(-.1156,.8296,.5463),(-.1142,.2707,-.9559),(-.1142,.9685,.2214),(-.1137,-.6951,.7098),(-.1128,-.9935,-.0175),(-.1106,-.7462,.6564),(-.1092,.9501,.2923),(-.1066,.9382,.3294),(-.1056,.246,.9635),(-.1053,.9196,.3785),(-.105,-.6182,.779),(-.1021,.9884,-.1128),(-.1009,-.3334,.9374),(-.1007,.9283,.3579),(-.1002,.77,-.6301),(-.0997,.8816,.4614),(-.099,-.6896,-.7174),(-.0978,.0243,.9949),(-.0977,.3438,.934),(-.0971,.7159,-.6914),(-.0938,.6028,.7924),(-.0932,-.995,-.0367),(-.093,.2848,-.9541),(-.092,-.2828,.9547),(-.0902,.3184,.9436),(-.0895,-.8917,.4437),(-.0888,-.8375,-.5392),(-.0887,.5807,-.8092),(-.0884,-.8161,.5711),(-.0882,.8931,.4412),(-.0855,-.9679,-.2365),(-.0847,.431,-.8984),(-.0846,.3023,-.9495),(-.0842,.8842,.4595),(-.0839,-.3739,.9237),(-.0836,.9021,-.4233),(-.0829,-.8861,-.4561),(-.0814,.2495,-.965),(-.0807,-.33,.9405),(-.0806,.3787,-.922),(-.0799,-.855,-.5125),(-.0785,.8797,.4691),(-.0777,.7917,-.6059),(-.0765,.8607,.5032),(-.0765,.9637,.2559),(-.0755,-.9445,.3197),(-.0732,-.9948,.071),(-.0732,.2967,-.9522),(-.0722,.9368,-.3424),(-.0714,-.8326,-.5492),(-.0713,.7438,.6645),(-.0712,.9278,.3663),(-.0702,-.087,.9937),(-.0701,-.9307,.359),(-.0701,-.9478,.3112),(-.067,.977,-.2023),(-.0651,.6225,-.7799),(-.0638,.5604,.8258),(-.063,-.7051,.7063),(-.0629,.9203,.3862),(-.0629,-.9856,-.157),(-.0621,-.9423,-.329),(-.062,-.7773,.626),(-.0616,-.8315,-.5521),(-.0614,.9211,.3844),(-.0599,-.1661,.9843),(-.0596,.8837,-.4643),(-.0588,-.9318,-.3582),(-.0583,-.8233,-.5645),(-.0559,.4971,-.8659),(-.0555,-.5674,.8216),(-.055,.1801,-.9821),(-.0535,-.9983,-.025),(-.0535,-.9254,-.3753),(-.0524,-.9863,.1562),(-.0511,.8375,.5441),(-.0501,-.3696,.9278),(-.0501,.4445,-.8944),(-.0497,.551,-.833),(-.0494,.2962,.9539),(-.0491,-.1396,.989),(-.0485,.8905,-.4525),(-.0482,.4481,-.8927),(-.0474,-.3818,.923),(-.0466,-.7821,-.6214),(-.0458,.4345,-.8995),(-.0415,.2763,-.9602),(-.0414,.9902,.1336),(-.0412,.594,.8034),(-.0409,.8437,.5352),(-.0403,-.9467,-.3197),(-.04,.7977,-.6017),(-.04,-.8162,.5764),(-.039,.9461,.3216),(-.0371,-.8555,-.5165),(-.0358,-.7623,-.6462),(-.0351,.7713,-.6356),(-.0318,-.915,-.4021),(-.0317,-.9628,-.2685),(-.031,.116,.9928),(-.0301,.4968,.8674),(-.03,-.9751,-.2197),(-.0288,-.1378,-.99),(-.0286,.6446,.7639),(-.0285,-.3163,.9482),(-.0276,-.9563,.2911),(-.0259,-.3985,.9168),(-.0247,.7403,-.6719),(-.0245,-.0592,.9979),(-.0238,.9884,-.1498),(-.0236,-.9997,.0108),(-.0232,.3017,-.9531),(-.0226,-.8432,-.5371),(-.0197,-.9972,-.0724),(-.0197,.9996,.0189),(-.0188,.9464,-.3226),(-.0183,-.1186,-.9928),(-.0178,.8963,.4431),(-.0168,.8988,.4381),(-.0162,-.7509,-.6602),(-.0162,.3684,-.9295),(-.0161,-.9969,.0765),(-.0143,.8279,-.5607),(-.0135,.6373,-.7705),(-.0133,.5596,-.8286),(-.0125,-.1214,-.9925),(-.0117,.9068,-.4214),(-.011,.4696,.8828),(-.0104,-.2795,.9601),(-.01,.9986,.0528),(-.0085,.3,-.9539),(-.0081,-.8254,.5645),(-.0078,-.7462,.6656),(-.0069,-.0725,.9973),(-.0066,.7795,.6264),(-.0061,.0315,-.9995),(-.0037,.9695,.2449),(-.0032,-.7732,-.6342),(-.0032,.9323,-.3617),(-.0029,-.9818,.19),(-.0018,-.113,-.9936),(-.0015,.8107,-.5854),(-.0007,-.9481,-.3179),(-.0003,-.4991,.8665),(-.0003,-.4916,.8708),(-.0002,-.3735,.9276),(-.0002,.9109,.4126),(-.0002,.9337,.358),(-.0001,-.7302,.6832),(-.0001,.9495,.3137),(-.0001,.9092,.4163),(-.0001,.9605,.2782),(-.0001,.9328,.3604),(0,.2847,.9586),(0,-.3706,.9288),(0,.9737,.2277),(0,-.9996,-.0273),(0,.9819,-.1894),(0,.9785,-.2061),(0,.9661,-.2581),(0,.9258,-.378),(0,-.9043,-.427),(0,.8793,-.4763),(0,.8039,-.5947),(0,.4402,-.8979),(.0001,-.3052,-.9523),(.0002,.8166,-.5772),(.0004,-.9367,-.3501),(.0004,.3106,-.9505),(.0005,.3199,-.9474),(.0006,.3544,-.9351),(.0007,.3694,-.9293),(.0008,.3896,-.921),(.001,-.193,-.9812),(.0014,.8108,-.5853),(.0044,-.8577,-.514),(.0048,.9356,-.3529),(.0057,-.9744,-.2248),(.0063,.031,-.9995),(.0065,-.9532,-.3024),(.0071,-.7467,.6651),(.0074,-.2972,.9548),(.0077,-.8251,.565),(.0097,.2997,-.954),(.01,.9986,.0528),(.0113,.4683,.8835),(.0116,-.8544,.5194),(.0125,-.8933,.4493),(.0126,-.9721,.234),(.0126,.4843,.8748),(.0137,.252,.9676),(.0142,.8281,-.5604),(.0143,.9999,.0033),(.0146,.9997,-.0189),(.0158,-.7859,-.6182),(.0158,.6371,-.7706),(.0161,-.385,.9228),(.0166,-.7517,-.6593),(.0168,-.817,-.5764),(.0175,-.9723,-.2332),(.0176,.3681,-.9296),(.0193,-.1199,-.9926),(.0195,-.9795,-.2004),(.0215,.9648,.2619),(.0234,-.9997,.0121),(.0238,.9884,-.1498),(.0239,-.4336,.9008),(.0243,.3019,-.953),(.0249,-.0606,.9979),(.0253,-.4,.9162),(.0288,.6439,.7646),(.0307,-.1375,-.99),(.0309,.1158,.9928),(.0342,.8197,.5717),(.0349,.5782,.8152),(.0351,.7713,-.6356),(.0353,.8795,.4746),(.0359,-.9755,-.2172),(.037,-.9862,.1614),(.0387,.9461,.3216),(.0397,-.8166,.5758),(.04,.7977,-.6017),(.0401,.9986,-.034),(.041,-.8696,-.4921),(.0415,.9902,.1335),(.0423,.2765,-.9601),(.0438,.8951,.4437),(.0463,.2723,.9611),(.0466,-.8081,-.5871),(.0474,.4347,-.8993),(.0475,-.9487,-.3125),(.0485,.4468,-.8933),(.0498,.745,-.6652),(.052,.8848,-.463),(.0528,-.9983,-.024),(.0548,-.9529,-.2982),(.0558,-.97,-.2368),(.0559,.1811,-.9819),(.0559,.4511,-.8907),(.0565,-.978,-.2009),(.0569,.6335,-.7717),(.0571,-.7541,-.6542),(.0575,-.9289,.3658),(.0588,.971,-.2319),(.059,-.9447,-.3227),(.0595,-.9318,-.3581),(.0602,.5673,-.8213),(.0612,-.7777,.6256),(.0621,-.8318,-.5515),(.0626,.9203,.3862),(.064,.5616,.8249),(.0652,-.2653,.9619),(.0654,-.3673,.9278),(.0689,.9124,.4035),(.0695,.7446,.6639),(.0696,-.7041,.7067),(.0699,-.9308,.3588),(.071,.9278,.3663),(.0722,.9368,-.3424),(.0738,.2952,-.9526),(.0754,-.9444,.3199),(.0755,.0553,.9956),(.076,-.2948,.9525),(.076,-.8897,.4502),(.0763,.9637,.2559),(.0769,.8604,.5038),(.0779,.7914,-.6063),(.0807,-.9929,.0879),(.0817,-.9772,-.1958),(.082,.2499,-.9648),(.0823,-.8813,-.4653),(.083,.8801,-.4675),(.0835,.902,-.4237),(.0839,.8842,.4595),(.0862,.4314,-.898),(.0876,-.9572,-.2759),(.0878,-.619,.7805),(.0879,-.8165,.5707),(.0896,-.8915,.4441),(.0929,-.9942,-.0549),(.0938,.2852,-.9539),(.0942,.6015,.7933),(.0951,.3122,-.9452),(.0952,-.3282,.9398),(.0964,.3925,-.9147),(.097,-.868,.4871),(.0974,-.8666,-.4894),(.0975,.3749,-.9219),(.0982,-.9811,-.1668),(.0985,.3414,.9347),(.0998,.4733,-.8752),(.0998,-.6887,-.7181),(.1006,.9879,-.1183),(.1007,-.3336,.9373),(.1008,.9719,-.2127),(.1048,-.6172,.7798),(.106,.2442,.9639),(.106,-.0271,.994),(.1064,.9382,.3294),(.1065,-.9935,-.0414),(.1068,.7529,-.6494),(.1074,-.6807,-.7246),(.1091,.9501,.2923),(.1094,-.9938,-.0219),(.1102,.8925,.4374),(.1104,-.747,.6557),(.1125,-.9288,-.353),(.1127,-.9935,-.0155),(.1145,.9714,.2079),(.1153,.2712,-.9556),(.1156,.8299,.5458),(.1164,.3387,.9337),(.1169,-.5767,-.8085),(.1173,-.9188,-.3769),(.1213,-.7089,.6948),(.1214,-.7283,.6744),(.1218,.7179,-.6854),(.122,-.7328,-.6695),(.1221,-.3045,.9446),(.1247,.2648,-.9562),(.1257,-.9917,-.0254),(.1259,.1908,.9735),(.1271,.9305,.3435),(.1294,.9144,.3836),(.1296,.735,-.6656),(.1304,.7652,-.6305),(.1306,.912,.3888),(.1314,-.4189,.8985),(.1315,-.7969,.5897),(.1316,-.783,-.608),(.1326,.7871,-.6024),(.1337,.4943,-.859),(.1339,.9361,.3253),(.1347,.1689,-.9764),(.1355,.9218,.3633),(.1356,.4001,-.9064),(.1363,.6888,.712),(.1364,-.9904,-.0206),(.1375,-.7228,.6772),(.1393,-.433,.8906),(.1411,-.9772,.1586),(.1411,.9881,-.0616),(.142,.3681,-.9189),(.1432,-.9471,-.2873),(.1441,.8674,.4762),(.1468,-.8036,.5767),(.1476,-.989,.0055),(.1495,.7669,-.6241),(.1497,-.6416,.7523),(.1501,-.6359,.7571),(.1508,-.7645,-.6267),(.155,.7822,-.6035),(.1571,-.9523,-.2618),(.1577,.6934,-.7031),(.1577,-.9811,-.1119),(.1605,.1356,-.9777),(.1623,-.7915,.5893),(.1629,.3633,.9173),(.1637,.7158,-.6788),(.1642,-.9727,.1642),(.1644,.4875,-.8575),(.168,.6889,-.7051),(.1691,-.9782,-.1207),(.1696,.3089,-.9358),(.17,.2936,-.9407),(.1706,-.9428,.2863),(.1715,-.4952,-.8517),(.1727,-.976,.1328),(.1736,-.3733,.9113),(.1752,-.613,.7704),(.1757,.9176,.3566),(.1758,.449,.8761),(.1765,.3874,-.9049),(.1769,.3061,-.9354),(.1772,-.701,.6908),(.1778,-.9773,-.1155),(.1787,.7787,-.6015),(.1789,.5928,-.7852),(.1796,-.6254,.7593),(.1797,-.5437,-.8198),(.18,-.3375,.924),(.1829,.7112,-.6788),(.187,-.8647,-.4662),(.1915,-.6621,-.7245),(.1947,-.1439,.9702),(.1958,-.728,-.657),(.1969,.9243,-.3268),(.1978,-.7122,.6735),(.1978,.7648,-.6132),(.2032,.9506,-.2348),(.2041,-.938,-.2802),(.2055,.2048,-.957),(.2058,.7079,-.6757),(.209,.3219,-.9234),(.2093,.7985,.5644),(.2093,-.0882,.9739),(.2113,-.1107,.9711),(.212,.0041,-.9773),(.2125,.8899,-.4036),(.2142,.8854,-.4127),(.2155,.2343,-.948),(.2171,.653,-.7256),(.2179,-.6311,.7445),(.2188,.849,-.4809),(.2197,.1365,-.966),(.2198,.7799,-.5861),(.2201,.2991,-.9285),(.2214,-.2966,.929),(.2218,.2112,-.9519),(.2236,-.0681,-.9723),(.2241,.7382,-.6363),(.2247,.396,-.8903),(.226,.2807,-.9328),(.226,.4583,-.8596),(.228,.293,-.9285),(.2289,.0459,.9724),(.2291,-.9728,-.0338),(.2296,.4036,-.8857),(.2311,.3721,.899),(.2318,.2646,-.9361),(.2339,.844,.4826),(.2344,-.972,-.0186),(.2346,-.5101,-.8275),(.2351,-.9713,-.0349),(.2359,-.6651,.7085),(.2365,-.9235,-.3019),(.2372,.8932,-.382),(.2384,.7517,-.6149),(.2389,.1593,.9579),(.2396,-.4642,.8527),(.2408,-.1987,-.95),(.2414,-.4378,.8661),(.2433,-.9298,.2762),(.2434,.9174,-.3148),(.2448,.941,-.2335),(.2456,.3179,.9158),(.2459,-.3185,.9155),(.2465,-.8608,-.4453),(.2474,.4418,.8623),(.2493,-.9366,-.2463),(.251,-.9311,-.2646),(.2513,-.3309,.9096),(.2517,.8483,-.4658),(.2526,.8549,-.4531),(.2527,-.7603,.5984),(.2536,-.1148,-.9605),(.2537,-.1755,-.9512),(.2547,-.7629,.5942),(.2561,-.9084,-.3306),(.2585,.6128,-.7468),(.26,-.929,.2634),(.2602,.0968,.9607),(.2606,.9094,.3241),(.2607,.7818,-.5665),(.2617,-.9313,.2532),(.2626,.2931,-.9193),(.2633,-.6555,-.7078),(.2642,-.9037,-.337),(.2658,-.4122,.8715),(.2704,.6174,-.7387),(.2733,.8747,.4002),(.2733,-.9458,-.1752),(.2777,-.0734,.9579),(.278,.883,.3782),(.2785,-.9581,.0672),(.2787,.4289,.8593),(.2823,.4092,-.8676),(.2856,.7005,-.654),(.2932,.7844,-.5466),(.2943,-.8075,-.5112),(.297,.2966,.9076),(.2991,-.2738,.9141),(.2992,.6386,-.709),(.2996,.9538,-.0201),(.3008,.2543,.9192),(.3012,.8817,.3632),(.3012,.8312,-.4674),(.3025,.4863,-.8197),(.3028,-.6492,-.6977),(.303,.1107,.9466),(.3059,.6028,-.7369),(.3071,-.7069,-.6372),(.3072,.9146,-.2631),(.3073,-.8883,.3414),(.3093,-.2423,.9196),(.3104,.9504,.0176),(.3128,-.8635,-.3956),(.3132,.7918,-.5243),(.3136,.9399,-.1349),(.3142,.6911,-.6509),(.3151,.6085,-.7283),(.3157,.8236,.4712),(.3165,-.1313,.9394),(.3183,.379,.8689),(.3184,.5335,-.7836),(.3186,-.5295,-.7862),(.3206,.449,-.834),(.3211,.5695,-.7567),(.3213,.2804,.9045),(.3234,-.8437,-.4284),(.3261,.8004,-.503),(.3264,-.3497,.8782),(.3272,-.887,-.3259),(.3273,-.116,.9378),(.3313,-.3616,.8715),(.3331,-.3123,.8897),(.3332,.4419,-.8329),(.3346,-.8649,-.3743),(.3346,.2997,.8934),(.3348,.1282,.9335),(.3357,-.8623,.3792),(.3358,.7936,-.5073),(.3363,-.637,-.6937),(.3374,-.1578,.928),(.3375,.9223,.1884),(.3385,.2793,-.8985),(.3394,-.94,-.0354),(.3397,.8619,.3765),(.3406,-.9346,.1022),(.3417,.6538,-.6751),(.3446,-.9387,-.0092),(.3456,.1433,-.9274),(.3491,-.6181,.7043),(.3497,-.2348,.907),(.3497,-.4948,-.7955),(.3499,.906,-.2382),(.3518,-.2871,.8909),(.3528,-.8363,.4196),(.3539,.9056,-.2338),(.3593,.7059,-.6104),(.3593,.8525,.3796),(.3597,-.2731,.8922),(.3611,.8069,.4675),(.3613,-.2491,.8986),(.3614,.7755,-.5177),(.3668,-.0489,-.929),(.3668,-.5712,-.7343),(.3675,-.1602,.9161),(.37,-.3533,.8592),(.3715,-.8933,.2528),(.3733,-.8922,.2542),(.3741,.5895,-.7159),(.3746,-.9097,.1793),(.3758,.0367,.926),(.3776,-.3584,.8538),(.3786,-.538,-.7531),(.3793,-.0188,.9251),(.3812,-.6098,-.6948),(.3813,-.0142,.9243),(.3819,-.9236,-.0322),(.3843,.1426,.9121),(.3846,-.5369,-.7509),(.3848,-.3577,.8509),(.3849,-.9213,.0558),(.385,.654,.6513),(.3857,.7435,-.5463),(.386,-.0474,.9213),(.3862,.922,-.0289),(.3867,.7067,.5925),(.3888,.1056,.9152),(.3902,.208,.8969),(.3918,.3551,-.8488),(.3942,.9158,.0772),(.397,-.4338,.8088),(.3996,-.6133,.6813),(.3999,.0162,.9164),(.4004,-.2768,.8735),(.4026,.9144,.0409),(.4038,.796,-.451),(.4054,-.8728,.2718),(.4079,-.1816,.8948),(.4088,.3538,-.8413),(.4103,.4775,-.777),(.4121,.7561,-.5084),(.4145,.8685,-.272),(.4152,-.0653,.9074),(.4156,-.4808,.7721),(.4163,-.198,.8874),(.4178,-.1985,.8866),(.4179,.4007,-.8153),(.4187,.8071,-.4163),(.4192,.8965,.1437),(.4203,-.9014,-.1044),(.4213,.2016,-.8842),(.4229,-.4122,.807),(.4241,-.0561,-.9039),(.4242,-.464,-.7777),(.4249,.4263,.7986),(.4272,.1892,.8841),(.4291,-.2359,-.8719),(.4303,.3051,-.8496),(.4312,-.6981,-.5716),(.4318,.2941,-.8527),(.4324,.8193,-.3765),(.4328,-.1183,-.8937),(.4336,.88,.1938),(.4359,.2599,.8617),(.4376,.4134,-.7985),(.4388,-.7967,.4156),(.4409,-.7118,.5468),(.4419,-.6811,-.5838),(.4426,-.8233,-.3553),(.4452,.8638,-.2358),(.4452,-.6961,-.5633),(.4453,.8885,.1111),(.4455,.6103,.655),(.4458,-.8084,-.3844),(.4468,-.8931,-.0517),(.4471,.8862,-.1214),(.4507,-.2355,.861),(.4523,.6496,-.6111),(.4526,-.8916,.0156),(.4543,-.2806,.8455),(.4569,.7335,.5032),(.4575,.5892,-.666),(.4632,-.8725,.1555),(.4651,-.7795,-.4196),(.4652,-.4047,.7873),(.4659,.2973,-.8334),(.4664,.8422,-.2706),(.4679,.4914,-.7346),(.4701,-.845,.2547),(.4707,.8737,.1228),(.4715,-.5721,.6711),(.4726,.355,-.8066),(.4736,-.854,.2156),(.4753,-.2686,.8378),(.4759,.7465,-.465),(.4762,-.8772,-.0611),(.4775,-.4664,.7446),(.4783,.8765,.0544),(.4791,-.2125,.8516),(.4797,-.3235,-.8156),(.4801,.8424,.2446),(.4816,-.3588,.7996),(.4819,.6716,-.5627),(.4855,.687,-.5407),(.4856,.4288,.7617),(.4861,.7575,.4358),(.4885,-.0384,.8717),(.4892,-.1266,.863),(.4903,-.7073,.5093),(.4912,.8671,-.0821),(.4928,.87,-.0142),(.4931,-.4109,.7669),(.4931,.3558,-.7939),(.4933,.2112,.8438),(.4964,.4744,.727),(.4969,-.7791,-.3822),(.5003,.7741,.388),(.5009,.7461,.4388),(.5021,-.0584,.8629),(.5043,-.5389,.6748),(.5045,.0393,-.8625),(.5056,.5082,.6972),(.5061,.0658,-.86),(.5064,-.8238,-.2549),(.5084,.5493,.6632),(.5097,-.2643,.8187),(.5107,.0004,.8598),(.5108,-.7043,.493),(.5125,.1156,.8509),(.5134,-.7268,.4563),(.5149,.6931,.5046),(.5153,.8482,.1228),(.5157,-.7203,-.464),(.5164,.5662,.6425),(.5187,-.2825,.8069),(.5194,-.406,.7519),(.52,-.5429,.6595),(.5203,-.5168,.6799),(.5235,.1105,.8448),(.5239,-.8516,.0145),(.525,-.0272,-.8507),(.5253,-.8509,-.0024),(.5256,-.1182,-.8425),(.5262,.3465,-.7766),(.5278,-.3056,.7925),(.5319,-.8426,.0839),(.5353,-.4117,.7376),(.5372,.679,.5004),(.5377,-.8431,.0048),(.5388,-.8398,-.0662),(.5392,.7603,.3622),(.5425,.4347,-.7188),(.5439,-.4773,.6902),(.5455,.2236,-.8077),(.5467,-.1167,.8292),(.5474,.523,-.6533),(.5479,.8207,.162),(.5501,-.0736,-.8318),(.5504,-.7603,-.3448),(.5523,-.6967,-.4579),(.5526,-.5662,.6116),(.5552,-.1259,-.8221),(.5609,.6525,.5095),(.5614,.285,.7769),(.5631,-.7619,.3201),(.564,.6688,-.4843),(.565,.6206,-.5437),(.565,-.8205,.0869),(.5713,-.2229,.7899),(.5714,.7338,.3676),(.5748,.5425,.6126),(.5811,.0363,-.813),(.5815,.7973,.1616),(.5829,.6127,-.5337),(.5852,.2122,.7826),(.5863,-.0977,.8042),(.5867,-.6799,.4399),(.5876,-.5252,-.6156),(.5947,-.8033,-.0332),(.5993,-.748,-.2853),(.6018,.0247,.7982),(.6062,-.1183,-.7865),(.6087,.7173,.3392),(.6094,-.0331,.7922),(.6098,-.156,.777),(.6118,.6993,.3697),(.6165,-.1896,.7642),(.6175,.5876,-.5228),(.6185,-.7295,-.2921),(.6213,-.5371,.5706),(.6237,.1001,-.7753),(.6283,.334,-.7027),(.6303,.4038,.6631),(.6323,.3789,-.6757),(.6327,-.7743,-.0149),(.633,-.4259,.6465),(.6363,.5057,-.5826),(.6387,.1129,.7611),(.6434,-.0794,.7614),(.6452,.6837,.3409),(.6472,-.1879,.7388),(.6478,.1696,-.7427),(.6496,.4647,.6017),(.6508,.4322,.6243),(.6516,.6206,.4361),(.6523,.7177,-.2437),(.6546,.4354,.618),(.6549,.2231,.722),(.6554,-.4217,.6265),(.6564,-.7453,-.1173),(.6573,-.6752,-.3349),(.6604,.7473,-.073),(.6614,.6144,.4302),(.6625,-.2724,-.6978),(.6626,-.164,.7308),(.6647,.4837,.5694),(.6652,.7455,-.0404),(.6653,-.6082,.433),(.6679,-.0908,-.7387),(.669,.7037,-.2392),(.6691,.6495,.3612),(.6748,-.5151,.5284),(.6756,.7093,.201),(.6759,.2402,.6967),(.6765,.6031,-.4227),(.6773,.6917,.2507),(.6794,-.6609,-.3188),(.6798,.7282,.0872),(.6813,-.6786,-.2744),(.6846,.4958,-.5343),(.6848,-.4038,-.6066),(.6854,-.6065,-.403),(.687,-.3736,.6233),(.6875,-.5,.5267),(.6877,.5377,.4879),(.691,-.6445,.3274),(.6915,-.299,-.6576),(.6936,-.2094,-.6892),(.6942,-.5015,.5163),(.6988,-.6627,-.2693),(.7001,.6354,-.3257),(.7012,.516,.492),(.7015,.0941,.7064),(.7049,-.2787,.6523),(.7075,-.6766,-.204),(.7081,-.1645,.6867),(.7104,-.6172,-.3382),(.7112,.1524,-.6863),(.7126,-.3138,.6274),(.7143,-.448,.5376),(.7156,.3174,-.6222),(.7158,-.4806,.5066),(.7169,-.0083,.6972),(.7191,.59,.3671),(.7198,.1088,-.6856),(.7204,.6663,-.1923),(.7218,.6871,.0832),(.7233,.6153,.3135),(.7235,.304,-.6198),(.7237,-.5916,.3553),(.7253,-.6764,.1282),(.7268,-.6362,-.2589),(.7276,-.2227,.6488),(.7297,-.6622,.1702),(.7303,.2801,.6231),(.7325,.4191,.5364),(.733,-.3914,-.5563),(.7333,.51,.4497),(.7345,.2872,-.6148),(.736,-.3866,-.5557),(.737,-.4424,.5109),(.7379,.519,-.4314),(.7386,-.5316,.4146),(.7425,.0538,.6677),(.7467,-.2752,.6056),(.7476,.6309,.2073),(.7483,-.4283,-.5066),(.7538,-.6355,-.1671),(.7541,.2262,-.6166),(.755,-.57,-.3242),(.7611,.6304,.1526),(.7627,.0316,.646),(.7632,-.1532,.6277),(.764,.4099,-.4983),(.7652,.5121,.3902),(.766,-.1023,.6346),(.7668,.6418,.0039),(.767,.3887,-.5106),(.7684,.5594,.311),(.7705,-.2796,-.5728),(.7714,-.5455,-.3275),(.7715,.3406,-.5374),(.7719,.3795,-.51),(.7738,.2903,.563),(.7771,-.0723,.6252),(.7786,.6055,-.1652),(.7789,.3351,-.5301),(.7795,-.3984,-.4834),(.7803,.3788,-.4977),(.7807,-.5564,-.2846),(.784,.5661,.2548),(.7852,-.184,.5912),(.7854,.5727,.2348),(.7884,.1763,.5894),(.7888,.5508,.2726),(.7897,.1509,-.5947),(.7915,.4721,.3881),(.7919,.0623,.6075),(.7926,.4224,.4397),(.7958,-.2496,.5518),(.7964,.6038,-.0346),(.7999,.2019,-.5651),(.8003,.0252,.5991),(.8003,.5919,.0963),(.8009,.0449,.5971),(.8011,-.5075,.3173),(.803,-.4974,-.3282),(.8045,-.2136,.5542),(.8059,.3918,-.4438),(.8073,.3049,-.5054),(.8091,.5598,-.1788),(.8095,-.2339,.5385),(.8095,.2183,-.5449),(.8096,.3127,.4967),(.8098,.4615,.3624),(.8114,-.266,.5205),(.8124,.0732,.5784),(.8159,.3199,.4817),(.8165,-.399,.4172),(.8178,-.5727,-.0568),(.821,-.3541,.4478),(.8214,.4643,.3312),(.8228,.2616,.5045),(.8236,.1446,-.5484),(.8242,.5284,.2038),(.8246,-.0451,.5639),(.8248,.4827,-.2943),(.8249,.148,-.5455),(.828,-.1721,.5337),(.8283,-.2862,.4817),(.8307,-.4032,-.3839),(.8324,.1664,-.5285),(.8337,-.371,.409),(.8342,.0642,-.5477),(.8359,.1163,-.5364),(.8367,-.0227,.5473),(.8378,-.2882,.4638),(.8401,.5407,.0432),(.8444,-.1418,.5167),(.8447,.4569,-.2787),(.846,.4286,.3173),(.8461,-.2949,.444),(.8508,-.2796,-.4449),(.8511,-.4802,-.2123),(.8523,-.0347,.5218),(.8629,-.1879,.4692),(.8646,.0461,.5004),(.8665,.0083,-.4991),(.8704,-.3603,.3356),(.8706,.0985,.482),(.8724,.1328,.4704),(.8732,-.0769,.4813),(.8835,.2365,-.4044),(.8841,.4307,.1814),(.8841,-.2406,.4006),(.8899,-.0861,.4479),(.8911,.2684,.366),(.8921,.1913,.4093),(.8941,-.2648,-.3611),(.8952,.4303,.1163),(.8959,.3503,-.2731),(.8988,-.1619,.4073),(.8989,.1615,.4073),(.8998,-.4359,.0205),(.9037,-.1923,.3825),(.9041,-.4268,.0218),(.9119,-.1888,-.3645),(.9141,-.0782,.398),(.9164,-.215,-.3377),(.9184,.0283,.3946),(.9234,-.364,.122),(.9275,.1353,.3485),(.9337,.0327,.3567),(.9347,.022,.3548),(.9372,-.338,.0864),(.9421,.1958,.2722),(.9494,.0858,.3023),(.9504,-.3063,-.0542),(.952,.1987,.2329),(.953,-.2862,.0994),(.9544,-.0017,-.2984),(.955,-.0348,.2947),(.9554,.26,-.1402),(.9633,.1617,-.2141),(.9731,-.153,.1723),(.9733,.1623,-.1623),(.9765,.1624,.1413),(.9799,-.1886,-.0653),(.9811,-.0409,-.1892),(.9811,-.0502,-.1866),(.9815,.0767,.1756),(.9818,.0527,.1826),(.987,.1076,.1195),(.9885,-.0656,.1363),(.99,.137,-.0336),(.9903,.0405,.1331),(.991,-.1161,-.0665),(.9923,.1197,.0322),(.995,.0891,.0457),(.9956,.0109,-.0936),(.9963,.0112,.0849),(.9991,-.039,-.0193)]))),
      Shape(DEF='c6disc',
        appearance=Appearance(
          material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),shininess=0.050,specularColor=(.9647,.949,.9098))),
        geometry=IndexedFaceSet(DEF='c6disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,4,10,-1,11,12,13,-1,14,15,16,-1,0,2,17,-1,18,19,20,-1,21,18,20,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,6,35,-1,36,37,33,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,45,-1,47,49,48,-1,50,51,52,-1,53,54,55,-1,56,47,45,-1,57,58,59,-1,60,61,58,-1,62,63,64,-1,65,66,67,-1,65,68,69,-1,70,71,72,-1,72,73,74,-1,73,75,76,-1,77,78,79,-1,80,81,82,-1,83,14,84,-1,85,86,82,-1,81,80,87,-1,88,89,90,-1,20,91,21,-1,92,93,94,-1,40,19,95,-1,96,97,98,-1,61,99,43,-1,59,61,100,-1,101,102,22,-1,103,104,23,-1,105,106,104,-1,55,107,0,-1,85,108,40,-1,54,109,110,-1,54,111,107,-1,100,55,0,-1,102,103,23,-1,43,99,112,-1,96,44,64,-1,98,113,114,-1,20,19,40,-1,92,115,93,-1,116,117,118,-1,90,89,91,-1,90,119,120,-1,86,121,80,-1,85,82,81,-1,16,122,87,-1,86,95,19,-1,14,123,124,-1,125,102,126,-1,127,93,128,-1,76,75,129,-1,68,127,69,-1,60,130,62,-1,63,131,64,-1,98,97,131,-1,66,57,59,-1,132,130,69,-1,56,133,134,-1,100,42,135,-1,134,136,49,-1,96,133,44,-1,38,137,138,-1,33,37,138,-1,6,36,35,-1,104,27,24,-1,36,39,38,-1,139,140,20,-1,17,59,141,-1,89,21,91,-1,142,128,93,-1,11,13,4,-1,6,143,144,-1,12,145,92,-1,5,4,13,-1,125,103,102,-1,40,39,139,-1,13,92,5,-1,146,143,116,-1,92,13,12,-1,144,36,6,-1,4,9,11,-1,96,98,114,-1,139,20,40,-1,37,36,38,-1,23,104,24,-1,35,32,34,-1,35,33,32,-1,33,138,31,-1,29,24,30,-1,38,108,137,-1,133,56,44,-1,134,49,47,-1,9,136,11,-1,9,147,136,-1,42,41,148,-1,55,100,135,-1,134,47,56,-1,58,61,59,-1,149,67,2,-1,131,63,130,-1,127,128,69,-1,150,2,1,-1,131,97,64,-1,60,151,130,-1,74,127,70,-1,76,129,152,-1,153,80,121,-1,14,16,154,-1,126,155,156,-1,80,82,86,-1,153,21,89,-1,126,157,125,-1,87,154,16,-1,81,158,85,-1,155,124,159,-1,153,160,159,-1,90,120,88,-1,90,161,119,-1,91,118,90,-1,117,162,118,-1,115,142,93,-1,96,64,97,-1,46,43,112,-1,15,101,22,-1,163,105,104,-1,100,0,141,-1,107,55,54,-1,54,110,164,-1,95,85,40,-1,54,164,111,-1,100,141,59,-1,106,25,104,-1,103,163,104,-1,102,23,22,-1,122,16,165,-1,94,5,92,-1,153,89,160,-1,80,166,87,-1,85,95,86,-1,14,154,123,-1,126,84,155,-1,73,76,167,-1,70,72,74,-1,130,132,131,-1,64,112,62,-1,60,99,61,-1,63,62,130,-1,79,168,169,-1,67,17,2,-1,133,96,115,-1,55,135,53,-1,50,170,51,-1,134,11,136,-1,135,42,148,-1,44,56,45,-1,42,100,43,-1,40,108,38,-1,33,35,36,-1,34,7,6,-1,31,171,32,-1,104,25,27,-1,22,24,29,-1,37,38,138,-1,17,141,0,-1,101,83,102,-1,43,100,61,-1,11,134,12,-1,10,172,9,-1,6,8,143,-1,173,145,12,-1,139,144,140,-1,115,92,145,-1,107,1,0,-1,111,1,107,-1,111,150,1,-1,174,175,176,-1,174,106,175,-1,8,116,143,-1,8,117,116,-1,3,10,4,-1,10,3,177,-1,178,179,180,-1,178,181,179,-1,182,52,183,-1,184,52,182,-1,51,180,185,-1,51,178,180,-1,24,186,30,-1,24,27,186,-1,165,138,137,-1,138,165,28,-1,187,188,189,-1,53,188,187,-1,170,9,172,-1,170,147,9,-1,50,190,191,-1,50,192,190,-1,190,148,48,-1,188,148,190,-1,115,173,133,-1,115,145,173,-1,193,127,68,-1,127,193,70,-1,112,60,62,-1,99,60,112,-1,149,194,195,-1,149,2,194,-1,131,113,98,-1,113,131,132,-1,194,196,169,-1,194,197,196,-1,168,198,199,-1,198,168,79,-1,200,70,193,-1,200,71,70,-1,127,94,93,-1,127,74,94,-1,89,201,160,-1,88,201,89,-1,202,157,126,-1,202,203,157,-1,84,124,155,-1,84,14,124,-1,204,120,205,-1,120,204,206,-1,156,159,207,-1,155,159,156,-1,198,204,208,-1,198,209,204,-1,166,153,159,-1,166,80,153,-1,205,208,204,-1,208,205,210,-1,152,211,212,-1,152,129,211,-1,177,152,213,-1,177,76,152,-1,106,214,25,-1,106,174,214,-1,165,15,22,-1,16,15,165,-1,213,212,215,-1,213,152,212,-1,211,216,217,-1,211,129,216,-1,216,205,217,-1,216,210,205,-1,206,209,218,-1,204,209,206,-1,207,219,156,-1,207,218,219,-1,166,154,87,-1,154,166,123,-1,77,176,175,-1,79,176,77,-1,77,219,78,-1,77,202,219,-1,207,160,201,-1,207,159,160,-1,73,220,75,-1,220,73,72,-1,221,72,71,-1,72,221,220,-1,222,193,223,-1,193,222,200,-1,168,222,195,-1,168,199,222,-1,151,66,65,-1,66,151,57,-1,176,169,196,-1,169,176,79,-1,195,169,168,-1,195,194,169,-1,150,194,2,-1,150,197,194,-1,54,187,109,-1,54,53,187,-1,192,188,190,-1,188,192,189,-1,49,190,48,-1,190,49,191,-1,172,51,170,-1,178,51,172,-1,41,48,148,-1,48,41,45,-1,189,224,187,-1,189,225,224,-1,22,28,165,-1,29,28,22,-1,186,26,226,-1,186,27,26,-1,183,51,185,-1,183,52,51,-1,171,183,32,-1,182,183,171,-1,30,171,31,-1,30,186,171,-1,214,110,109,-1,214,174,110,-1,8,180,179,-1,7,180,8,-1,213,10,177,-1,181,10,213,-1,146,144,143,-1,144,146,140,-1,103,157,163,-1,103,125,157,-1,196,174,176,-1,196,110,174,-1,150,164,197,-1,111,164,150,-1,106,203,175,-1,106,105,203,-1,8,215,117,-1,8,179,215,-1,10,178,172,-1,178,10,181,-1,14,101,15,-1,101,14,83,-1,167,5,94,-1,3,5,167,-1,224,25,214,-1,25,224,26,-1,226,184,182,-1,226,225,184,-1,7,185,180,-1,185,7,34,-1,144,39,36,-1,144,139,39,-1,45,43,46,-1,45,41,43,-1,188,135,148,-1,135,188,53,-1,170,191,147,-1,191,170,50,-1,52,192,50,-1,52,184,192,-1,142,113,128,-1,114,113,142,-1,68,223,193,-1,68,65,223,-1,65,149,223,-1,149,65,67,-1,227,198,208,-1,227,199,198,-1,69,151,65,-1,69,130,151,-1,208,221,227,-1,210,221,208,-1,167,74,73,-1,94,74,167,-1,102,84,126,-1,84,102,83,-1,198,78,209,-1,79,78,198,-1,88,206,201,-1,88,120,206,-1,212,161,162,-1,212,211,161,-1,167,177,3,-1,177,167,76,-1,108,158,137,-1,85,158,108,-1,137,122,165,-1,158,122,137,-1,112,44,46,-1,112,64,44,-1,114,115,96,-1,115,114,142,-1,140,91,20,-1,140,146,91,-1,215,162,117,-1,215,212,162,-1,90,162,161,-1,162,90,118,-1,217,161,211,-1,119,161,217,-1,119,205,120,-1,217,205,119,-1,201,218,207,-1,206,218,201,-1,218,78,219,-1,218,209,78,-1,124,166,159,-1,123,166,124,-1,175,202,77,-1,175,203,202,-1,18,86,19,-1,121,86,18,-1,202,156,219,-1,202,126,156,-1,87,158,81,-1,158,87,122,-1,121,21,153,-1,21,121,18,-1,216,75,220,-1,216,129,75,-1,221,216,220,-1,221,210,216,-1,199,200,222,-1,200,199,227,-1,195,223,149,-1,195,222,223,-1,58,151,60,-1,57,151,58,-1,71,227,221,-1,200,227,71,-1,66,17,67,-1,66,59,17,-1,128,132,69,-1,113,132,128,-1,109,224,214,-1,109,187,224,-1,184,189,192,-1,189,184,225,-1,136,191,49,-1,136,147,191,-1,133,12,134,-1,133,173,12,-1,224,226,26,-1,225,226,224,-1,31,28,30,-1,31,138,28,-1,185,32,183,-1,34,32,185,-1,186,182,171,-1,186,226,182,-1,146,118,91,-1,116,118,146,-1,181,215,179,-1,181,213,215,-1,105,157,203,-1,105,163,157,-1,197,110,196,-1,164,110,197,-1],creaseAngle=1.571,normalIndex=[13,46,32,-1,38,43,34,-1,188,135,173,-1,70,43,54,-1,57,40,31,-1,213,216,220,-1,13,32,11,-1,201,223,202,-1,182,201,202,-1,184,152,87,-1,92,75,71,-1,97,103,95,-1,108,101,169,-1,137,188,146,-1,189,176,169,-1,178,206,221,-1,126,66,36,-1,30,102,47,-1,60,120,102,-1,60,77,120,-1,132,86,104,-1,170,161,44,-1,67,60,102,-1,17,14,20,-1,7,12,14,-1,6,8,1,-1,29,16,26,-1,29,80,41,-1,96,91,128,-1,128,151,109,-1,151,122,133,-1,174,168,116,-1,212,222,218,-1,217,213,215,-1,226,205,218,-1,222,212,219,-1,140,88,98,-1,202,187,182,-1,28,35,39,-1,221,223,227,-1,5,0,2,-1,12,3,36,-1,20,12,24,-1,196,204,184,-1,164,78,152,-1,160,166,78,-1,44,55,13,-1,226,193,221,-1,161,142,64,-1,161,171,55,-1,24,44,13,-1,204,164,152,-1,36,3,4,-1,5,30,1,-1,2,23,9,-1,202,223,221,-1,28,18,35,-1,199,185,183,-1,98,88,187,-1,98,123,141,-1,205,195,212,-1,226,218,222,-1,220,224,219,-1,205,227,223,-1,213,210,211,-1,180,204,192,-1,100,35,42,-1,133,122,159,-1,80,100,41,-1,7,15,6,-1,8,21,1,-1,2,0,21,-1,16,17,20,-1,27,15,41,-1,67,25,50,-1,24,66,107,-1,50,127,77,-1,5,25,30,-1,178,190,139,-1,169,176,139,-1,188,189,146,-1,78,71,87,-1,189,206,178,-1,209,203,202,-1,11,20,10,-1,88,182,187,-1,22,42,35,-1,57,31,43,-1,188,197,200,-1,40,37,28,-1,34,43,31,-1,180,164,204,-1,221,206,209,-1,31,28,34,-1,207,197,199,-1,28,31,40,-1,200,189,188,-1,43,70,57,-1,5,2,9,-1,209,202,221,-1,176,189,178,-1,152,78,87,-1,146,101,137,-1,146,169,101,-1,169,139,108,-1,103,87,95,-1,178,193,190,-1,25,67,30,-1,50,77,60,-1,70,127,57,-1,70,85,127,-1,66,126,138,-1,44,24,107,-1,50,60,67,-1,14,12,20,-1,49,26,32,-1,21,8,15,-1,100,42,41,-1,111,32,46,-1,21,0,1,-1,7,19,15,-1,109,100,96,-1,133,159,143,-1,186,212,195,-1,213,220,214,-1,192,198,177,-1,212,218,205,-1,186,182,88,-1,192,125,180,-1,219,214,220,-1,222,225,226,-1,198,211,194,-1,186,149,194,-1,98,141,140,-1,98,131,123,-1,187,183,98,-1,185,175,183,-1,18,22,35,-1,5,1,0,-1,47,36,4,-1,216,196,184,-1,53,160,78,-1,24,13,10,-1,55,44,161,-1,161,64,73,-1,227,226,221,-1,161,73,171,-1,24,10,20,-1,166,92,78,-1,164,53,78,-1,204,152,184,-1,224,220,191,-1,39,34,28,-1,186,88,149,-1,212,208,219,-1,226,227,205,-1,213,214,210,-1,192,215,198,-1,151,133,81,-1,96,128,109,-1,15,27,21,-1,1,4,6,-1,7,3,12,-1,8,6,15,-1,116,56,51,-1,26,11,32,-1,25,5,18,-1,44,107,170,-1,132,90,86,-1,50,57,127,-1,107,66,138,-1,30,67,102,-1,66,24,36,-1,221,193,178,-1,169,146,189,-1,137,135,188,-1,108,84,101,-1,78,92,71,-1,184,87,103,-1,176,178,139,-1,11,10,13,-1,196,217,204,-1,36,24,12,-1,57,50,40,-1,54,62,70,-1,188,173,197,-1,33,37,40,-1,209,200,203,-1,18,28,37,-1,55,46,13,-1,171,46,55,-1,171,111,46,-1,118,181,117,-1,118,166,181,-1,173,199,197,-1,173,185,199,-1,38,54,43,-1,54,38,72,-1,61,94,106,-1,61,59,94,-1,93,104,82,-1,112,104,93,-1,86,106,99,-1,86,61,106,-1,87,65,95,-1,87,71,65,-1,191,139,190,-1,139,191,97,-1,155,163,156,-1,170,163,155,-1,90,70,62,-1,90,85,70,-1,132,145,130,-1,132,134,145,-1,145,138,120,-1,163,138,145,-1,18,33,25,-1,18,37,33,-1,76,100,80,-1,100,76,96,-1,4,7,6,-1,3,7,4,-1,49,52,58,-1,49,32,52,-1,21,23,2,-1,23,21,27,-1,52,45,51,-1,52,48,45,-1,56,119,79,-1,119,56,116,-1,74,96,76,-1,74,91,96,-1,100,39,35,-1,100,109,39,-1,88,147,149,-1,140,147,88,-1,172,125,192,-1,172,179,125,-1,215,211,198,-1,215,213,211,-1,148,141,150,-1,141,148,154,-1,177,194,162,-1,198,194,177,-1,119,148,124,-1,119,153,148,-1,208,186,194,-1,208,212,186,-1,150,124,148,-1,124,150,136,-1,143,165,129,-1,143,159,165,-1,72,143,83,-1,72,133,143,-1,166,114,92,-1,166,118,114,-1,191,216,184,-1,220,216,191,-1,83,129,105,-1,83,143,129,-1,165,144,158,-1,165,159,144,-1,144,150,158,-1,144,136,150,-1,154,153,157,-1,148,153,154,-1,162,167,177,-1,162,157,167,-1,208,214,219,-1,214,208,210,-1,174,117,181,-1,116,117,174,-1,174,167,168,-1,174,172,167,-1,162,149,147,-1,162,194,149,-1,151,121,122,-1,121,151,128,-1,110,128,91,-1,128,110,121,-1,68,76,63,-1,76,68,74,-1,56,68,58,-1,56,79,68,-1,19,16,29,-1,16,19,17,-1,117,51,45,-1,51,117,116,-1,58,51,56,-1,58,52,51,-1,111,52,32,-1,111,48,52,-1,161,155,142,-1,161,170,155,-1,134,163,145,-1,163,134,156,-1,77,145,120,-1,145,77,130,-1,62,86,90,-1,61,86,62,-1,126,120,138,-1,120,126,102,-1,156,113,155,-1,156,115,113,-1,184,97,191,-1,103,97,184,-1,65,75,69,-1,65,71,75,-1,82,86,99,-1,82,104,86,-1,84,82,101,-1,93,82,84,-1,95,84,108,-1,95,65,84,-1,114,64,142,-1,114,118,64,-1,173,106,94,-1,135,106,173,-1,83,54,72,-1,59,54,83,-1,207,200,197,-1,200,207,203,-1,164,125,53,-1,164,180,125,-1,45,118,117,-1,45,64,118,-1,111,73,48,-1,171,73,111,-1,166,179,181,-1,166,160,179,-1,173,105,185,-1,173,94,105,-1,54,61,62,-1,61,54,59,-1,213,196,216,-1,196,213,217,-1,81,34,39,-1,38,34,81,-1,113,92,114,-1,92,113,75,-1,69,112,93,-1,69,115,112,-1,135,99,106,-1,99,135,137,-1,200,206,189,-1,200,209,206,-1,102,36,47,-1,102,126,36,-1,163,107,138,-1,107,163,170,-1,90,130,85,-1,130,90,132,-1,104,134,132,-1,104,112,134,-1,22,23,42,-1,9,23,22,-1,80,63,76,-1,80,29,63,-1,29,49,63,-1,49,29,26,-1,89,119,124,-1,89,79,119,-1,41,19,29,-1,41,15,19,-1,124,110,89,-1,136,110,124,-1,81,109,151,-1,39,109,81,-1,204,215,192,-1,215,204,217,-1,119,168,153,-1,116,168,119,-1,140,154,147,-1,140,141,154,-1,129,131,175,-1,129,165,131,-1,81,72,38,-1,72,81,133,-1,193,225,190,-1,226,225,193,-1,190,224,191,-1,225,224,190,-1,4,30,47,-1,4,1,30,-1,9,18,5,-1,18,9,22,-1,203,187,202,-1,203,207,187,-1,105,175,185,-1,105,129,175,-1,98,175,131,-1,175,98,183,-1,158,131,165,-1,123,131,158,-1,123,150,141,-1,158,150,123,-1,147,157,162,-1,154,157,147,-1,157,168,167,-1,157,153,168,-1,211,208,194,-1,210,208,211,-1,181,172,174,-1,181,179,172,-1,201,205,223,-1,195,205,201,-1,172,177,167,-1,172,192,177,-1,219,225,222,-1,225,219,224,-1,195,182,186,-1,182,195,201,-1,144,122,121,-1,144,159,122,-1,110,144,121,-1,110,136,144,-1,79,74,68,-1,74,79,89,-1,58,63,49,-1,58,68,63,-1,14,19,7,-1,17,19,14,-1,91,89,110,-1,74,89,91,-1,16,11,26,-1,16,20,11,-1,42,27,41,-1,23,27,42,-1,142,113,114,-1,142,155,113,-1,112,156,134,-1,156,112,115,-1,127,130,77,-1,127,85,130,-1,25,40,50,-1,25,33,40,-1,113,69,75,-1,115,69,113,-1,108,97,95,-1,108,139,97,-1,99,101,82,-1,137,101,99,-1,65,93,84,-1,65,69,93,-1,207,183,187,-1,199,183,207,-1,59,105,94,-1,59,83,105,-1,160,125,179,-1,160,53,125,-1,48,64,45,-1,73,64,48,-1],
          coord=Coordinate(DEF='c6disc_Coord',point=[(-.27147,52.80947,-1.40805),(-.24473,52.79464,-1.41642),(-.25321,52.76124,-1.36298),(-.16048,52.67988,-.93298),(-.1654,52.69153,-.93699),(-.17855,52.67758,-.94078),(.27045,52.76175,-.96456),(.17122,52.7507,-.94317),(.16214,52.72752,-.91763),(-.17122,52.72229,-.95949),(-.07389,52.70771,-.91907),(-.27045,52.74179,-.97967),(-.33291,52.74515,-1.00047),(-.2699,52.7048,-.9684),(.31128,52.807,-1.33049),(.32661,52.84766,-1.37257),(.36135,52.849,-1.30352),(-.28224,52.78412,-1.34706),(.39066,52.72523,-1.15698),(.41458,52.74423,-1.15603),(.36461,52.67932,-1.08374),(.33947,52.68457,-1.15789),(.30729,52.8757,-1.35656),(.2447,52.85262,-1.40224),(.23878,52.87155,-1.36478),(.0969,52.83368,-1.39738),(.0981,52.85157,-1.36632),(.17002,52.86027,-1.37386),(.30503,52.8839,-1.2742),(.28024,52.8778,-1.32285),(.24698,52.88368,-1.27728),(.26615,52.86648,-1.17293),(.17619,52.84033,-1.08684),(.2647,52.83911,-1.08838),(.18186,52.80149,-1.00087),(.2577,52.79293,-1.01162),(.31659,52.79104,-1.00906),(.31179,52.82374,-1.09874),(.33666,52.82475,-1.1008),(.36529,52.77332,-1.02797),(.40323,52.77201,-1.08038),(-.30503,52.8839,-1.27478),(-.28024,52.8778,-1.32339),(-.35234,52.88579,-1.27017),(-.37595,52.82536,-1.12085),(-.31409,52.86711,-1.18634),(-.36461,52.87123,-1.19426),(-.31179,52.8228,-1.1),(-.26615,52.86648,-1.17345),(-.2647,52.83587,-1.09013),(-.10115,52.82434,-1.0874),(0,52.79688,-1.00902),(0,52.8216,-1.08824),(-.17002,52.86027,-1.37421),(-.17296,52.8456,-1.3975),(-.25143,52.86006,-1.39622),(-.33666,52.82456,-1.1017),(-.32483,52.79445,-1.29601),(-.3438,52.8199,-1.29856),(-.31128,52.807,-1.33116),(-.37622,52.82614,-1.25821),(-.36135,52.849,-1.30424),(-.38594,52.81652,-1.21456),(-.37788,52.79504,-1.18573),(-.4077,52.8228,-1.16312),(-.28823,52.71709,-1.25174),(-.29695,52.76561,-1.29689),(-.2676,52.73756,-1.30817),(-.28161,52.69451,-1.1853),(-.3193,52.69794,-1.18591),(-.20491,52.67099,-1.1013),(-.13192,52.66371,-1.10428),(-.12692,52.65989,-1.04131),(-.12785,52.65449,-1.00485),(-.21469,52.65822,-1.06142),(-.06038,52.65337,-.99223),(-.06888,52.64606,-.92627),(.06835,52.72473,-1.34997),(.06265,52.72182,-1.34509),(0,52.71562,-1.35581),(.35917,52.76121,-1.21226),(.38594,52.81652,-1.21377),(.37788,52.79504,-1.18493),(.29039,52.80847,-1.36807),(.28224,52.78412,-1.34642),(.4077,52.8228,-1.1623),(.3837,52.75529,-1.19102),(.37622,52.82614,-1.25744),(.20491,52.68096,-1.09624),(.26683,52.6794,-1.0893),(.21469,52.67308,-1.05382),(.29022,52.65895,-1.02315),(-.27252,52.69199,-.97483),(-.286,52.65798,-1.01913),(-.21552,52.63621,-.97288),(.41681,52.77488,-1.15011),(-.39879,52.76581,-1.06682),(-.41681,52.77488,-1.15101),(-.41397,52.74506,-1.1535),(-.38685,52.85808,-1.25449),(-.29777,52.86134,-1.34574),(.29854,52.83283,-1.38974),(.27147,52.80947,-1.40746),(.24353,52.81118,-1.42062),(.17472,52.84111,-1.39853),(.15513,52.79014,-1.40567),(.08946,52.77429,-1.42167),(-.24468,52.81109,-1.42062),(.37806,52.82519,-1.1229),(-.09676,52.83165,-1.39839),(-.08946,52.77429,-1.42188),(-.18613,52.79913,-1.41083),(-.40131,52.85935,-1.21238),(-.39066,52.72523,-1.15793),(-.39067,52.71082,-1.12273),(-.36146,52.71789,-1.00283),(.25927,52.71003,-.94796),(.16451,52.71117,-.91545),(.24224,52.66225,-.96696),(.12692,52.67635,-1.03649),(.13192,52.67414,-1.10227),(.37296,52.74573,-1.19002),(.38685,52.85808,-1.25375),(.32483,52.79445,-1.2953),(.29695,52.76561,-1.2962),(.24473,52.79464,-1.41588),(.25321,52.76124,-1.36239),(-.26683,52.67295,-1.09557),(-.33947,52.68457,-1.16003),(0,52.65534,-.99386),(-.35917,52.76121,-1.21307),(-.3837,52.75529,-1.19189),(-.36856,52.74181,-1.19047),(-.36529,52.77078,-1.03193),(-.31659,52.78304,-1.0166),(-.23878,52.87155,-1.36525),(-.2577,52.77822,-1.02084),(.37115,52.86911,-1.19679),(.31409,52.86711,-1.18574),(.35572,52.75203,-1.01231),(.33969,52.73434,-1.0082),(-.2878,52.81178,-1.34655),(-.3699,52.67798,-1.08274),(.26379,52.72272,-.9514),(.33393,52.74802,-.9995),(-.33966,52.73535,-.99832),(.27112,52.70966,-.96095),(-.18186,52.78044,-1.00921),(-.24698,52.88368,-1.27775),(-.25171,52.73465,-1.31255),(-.19246,52.78303,-1.40481),(-.33828,52.77525,-1.25309),(0,52.66082,-.92412),(.3193,52.69794,-1.18406),(.3438,52.8199,-1.29784),(.2676,52.73756,-1.30753),(.25171,52.73465,-1.31194),(.19231,52.78375,-1.40418),(.39921,52.85349,-1.21191),(.28823,52.71709,-1.25086),(.28161,52.69453,-1.18241),(.12785,52.6744,-.9967),(.15082,52.66938,-.92238),(.18603,52.79993,-1.41021),(-.15526,52.79018,-1.40603),(.34817,52.888,-1.27289),(.33828,52.77525,-1.25233),(-.14739,52.63195,-.94005),(-.06265,52.72182,-1.34526),(-.06835,52.72473,-1.35014),(-.11051,52.78622,-1.01243),(.1696,52.85289,-1.16799),(-.09362,52.73132,-.95159),(-.34504,52.74702,-1.00638),(0,52.76106,-1.42949),(.09129,52.75868,-1.41528),(0,52.74594,-1.42393),(-.07374,52.69276,-.91492),(0,52.74744,-.95439),(.0739,52.72581,-.90697),(.09362,52.75207,-.93943),(0,52.71802,-.91953),(.09585,52.8499,-1.16385),(.10115,52.83219,-1.08773),(0,52.84624,-1.1629),(.11051,52.80295,-1.00741),(.16547,52.87669,-1.2731),(-.0981,52.85157,-1.36653),(-.16547,52.87669,-1.27343),(-.09277,52.86159,-1.26298),(-.1696,52.85241,-1.16925),(-.17619,52.83231,-1.08822),(-.09585,52.84872,-1.16508),(-.21205,52.68817,-1.18302),(-.15704,52.74171,-1.34853),(-.15415,52.73052,-1.32584),(-.09129,52.75868,-1.41549),(-.15804,52.77347,-1.39959),(0,52.69713,-1.29402),(-.06537,52.7011,-1.28807),(-.13209,52.67942,-1.19483),(.21205,52.68942,-1.1789),(.15704,52.74171,-1.34815),(.15804,52.77347,-1.39922),(.06595,52.67792,-1.20079),(.06485,52.66979,-1.1148),(.13209,52.68109,-1.19145),(.23549,52.71056,-1.26502),(0,52.67337,-1.20996),(.06537,52.7011,-1.28722),(0,52.66415,-1.12529),(.06038,52.6648,-.98719),(.06902,52.66256,-.91622),(0,52.70479,-.91477),(0,52.82301,-1.40251),(.07378,52.71129,-.90287),(0,52.66252,-1.05684),(.06515,52.67278,-1.04888),(.14827,52.70775,-1.27805),(.15415,52.73052,-1.32543),(-.06515,52.66358,-1.05035),(-.06485,52.66405,-1.1153),(-.14827,52.70775,-1.2795),(-.23549,52.71056,-1.26616),(0,52.84945,-1.36333),(0,52.85933,-1.25723),(.09277,52.86159,-1.26279),(-.06595,52.67679,-1.2027)]),
          normal=Normal(vector=[(-.9832,.0432,-.1771),(-.9489,.3149,.019),(-.8988,-.3504,-.2634),(-.8938,.243,-.3769),(-.8919,.4514,-.027),(-.8887,.1699,.4258),(-.8755,-.4073,-.2601),(-.8229,-.4053,-.3983),(-.7997,-.1976,-.5669),(-.7996,-.5988,-.0451),(-.7974,-.1502,-.5844),(-.7571,-.473,-.4506),(-.7555,.087,-.6494),(-.7213,-.1368,-.6789),(-.6946,-.5374,-.4783),(-.681,-.4648,-.5659),(-.6761,-.58,-.4544),(-.6657,-.5822,-.4668),(-.662,-.2185,.717),(-.6538,-.5707,-.4969),(-.6404,-.3558,-.6806),(-.6369,-.2413,-.7323),(-.6321,-.7711,.0763),(-.5883,-.6573,-.471),(-.5705,.5292,-.6281),(-.5264,.5668,.6337),(-.4978,-.7438,-.446),(-.4665,-.5872,-.6615),(-.4624,-.4248,.7783),(-.4411,-.7917,-.4227),(-.4135,.7806,.4688),(-.3946,-.0484,.9176),(-.3942,-.7779,-.4894),(-.3933,.4678,.7915),(-.3636,-.1442,.9203),(-.3438,-.9136,.2171),(-.3425,.9194,-.1934),(-.3039,.2764,.9117),(-.292,-.0099,.9564),(-.2894,-.8793,.3782),(-.286,.4072,.8674),(-.277,-.8341,-.477),(-.2643,-.8651,-.4263),(-.2624,.3231,.9093),(-.2496,.7105,-.6579),(-.2201,-.6558,-.7222),(-.2163,-.552,-.8053),(-.2032,.9194,.3366),(-.1929,-.6407,-.7432),(-.1895,-.8809,-.4337),(-.1842,.7121,.6775),(-.1644,-.9084,-.3845),(-.1568,-.8734,-.461),(-.1433,-.0712,-.9871),(-.1413,.5191,.843),(-.14,.0924,-.9858),(-.1396,-.9256,-.3519),(-.1366,.522,.842),(-.1358,-.8959,-.4231),(-.1347,.5723,.8089),(-.1323,.8989,.4178),(-.1307,.7508,.6474),(-.1306,.7423,.6572),(-.1301,-.9322,-.3378),(-.129,-.0108,-.9916),(-.1257,.9917,.0252),(-.1215,.9523,-.2799),(-.1209,.8768,.4655),(-.1149,-.9308,-.347),(-.1127,.9935,.0153),(-.1074,.6356,.7645),(-.1072,.905,-.4116),(-.1041,.0176,.9944),(-.1033,-.1164,-.9878),(-.102,-.9674,-.232),(-.1002,.9449,-.3117),(-.099,-.9687,-.2274),(-.0977,.8888,.4477),(-.0947,.5577,-.8246),(-.0938,-.9455,-.3119),(-.0937,-.9631,-.2524),(-.0917,-.8556,.5094),(-.0877,.9573,.2755),(-.0818,.0674,.9944),(-.0815,.9774,.1952),(-.08,.7401,.6678),(-.0789,.8596,.5049),(-.0752,.9472,-.3117),(-.0669,-.9755,-.2096),(-.0657,-.9749,-.2126),(-.0632,.7992,.5977),(-.0621,-.9923,-.1076),(-.0593,.6515,-.7563),(-.0565,.9781,.2004),(-.0564,.5487,.8341),(-.0528,.9983,.024),(-.0513,-.9743,-.2192),(-.0494,.9981,.0377),(-.0444,-.9905,-.1302),(-.0411,.8695,.4922),(-.0411,-.9727,-.2282),(-.039,.9492,.3123),(-.0347,.9425,.3324),(-.0291,.993,-.1148),(-.0286,.9549,.2956),(-.0232,.015,.9996),(-.0201,.7825,.6224),(-.0179,.9642,-.2646),(-.0174,.9724,.2328),(-.0111,-.964,-.2658),(-.0103,-.9968,-.0796),(-.0096,-.6381,-.7699),(-.0059,.9745,.2244),(-.0021,.9445,-.3286),(-.002,.6211,-.7837),(0,.9996,.0271),(.0004,-.9364,-.351),(.0008,-.6882,-.7256),(.0012,-.0065,-1),(.0033,-.9562,-.2927),(.0047,.9559,.2937),(.0094,-.9962,-.0864),(.0119,-.9913,-.1307),(.0123,-.9999,-.0116),(.017,-.9798,-.1993),(.0176,-.6281,-.7779),(.0221,.9993,.0305),(.0228,.7569,.6531),(.0239,-.9929,-.1169),(.0272,-.7937,.6077),(.0314,.915,.4022),(.0319,-.9974,-.0653),(.0328,.9339,.3561),(.0389,-.8046,.5926),(.0424,.9713,.2342),(.0439,.7458,.6647),(.0442,-.9966,-.0701),(.0519,.845,.5322),(.0536,.9983,.025),(.0541,.9517,.3022),(.055,-.988,-.1443),(.0597,-.9975,-.0387),(.0634,.6396,-.7661),(.0666,-.753,.6546),(.0687,-.9958,-.061),(.0708,.9655,.2505),(.0737,.8583,.5078),(.0805,-.982,-.1706),(.0824,-.9809,-.1761),(.0835,-.9738,-.2114),(.089,-.9953,-.037),(.0921,-.9745,-.2048),(.0949,.6464,-.7571),(.0971,-.9485,-.3016),(.0998,-.9796,-.1747),(.1,.9387,-.3299),(.1105,.9937,.0204),(.1132,-.9362,-.3327),(.1158,-.9929,-.0283),(.1161,-.9923,-.0437),(.1168,-.1297,-.9847),(.1225,.5915,-.7969),(.126,-.9361,-.3285),(.1261,.9916,.0293),(.1273,.0677,-.9896),(.1274,-.9901,-.0589),(.1307,-.011,-.9914),(.1359,-.8976,-.4194),(.1411,-.926,-.3501),(.1412,.9043,.4028),(.1444,.9205,-.3629),(.1498,-.0697,-.9863),(.1589,-.8725,-.4621),(.1613,.4483,.8792),(.1653,-.9084,-.3841),(.1707,-.7653,.6206),(.184,.904,.3859),(.1898,-.8816,-.4322),(.1912,.8684,.4575),(.2038,-.6398,-.741),(.2079,-.5579,-.8035),(.2217,-.6556,-.7218),(.2429,-.8792,-.41),(.2588,-.8553,.4488),(.2615,.8534,-.4509),(.2623,-.0582,.9632),(.2642,-.8497,-.4563),(.2992,-.9267,.2271),(.3005,.5391,.7868),(.3174,.7172,.6203),(.3396,.899,.2764),(.3462,.9303,-.1215),(.3931,-.7776,-.4907),(.4378,.7443,.5043),(.4404,-.7944,-.4182),(.4635,-.5916,-.6596),(.4918,.0345,-.87),(.4932,.0779,.8664),(.4984,-.744,-.4451),(.5078,-.2013,.8376),(.549,.0659,.8332),(.5614,-.6912,-.4551),(.6159,-.771,.1617),(.6173,-.408,.6727),(.6209,-.2016,-.7575),(.6292,-.2387,-.7397),(.6453,.4742,.599),(.6491,-.3565,.672),(.6537,-.5719,-.4956),(.6587,-.0307,.7518),(.666,-.5822,-.4663),(.6764,-.5803,-.4537),(.6793,-.4681,-.5652),(.6828,-.5985,-.4191),(.6948,-.5375,-.4778),(.6984,-.5896,-.4057),(.7048,.0626,-.7066),(.7135,-.5836,-.3877),(.8,-.1983,-.5663),(.8233,-.4051,-.3977),(.8654,.0135,-.501),(.8714,.189,.4526),(.8755,-.4074,-.2599),(.8827,-.3585,-.3037),(.8987,.334,-.2843),(.912,.404,-.0715),(.9295,.3689,.0012),(.982,.0524,-.1816)]))),
      Shape(DEF='c7',
        appearance=Appearance(
          material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),shininess=0.050,specularColor=(.349,.349,.349))),
        geometry=IndexedFaceSet(DEF='c7_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,22,21,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,0,43,44,-1,1,0,44,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,57,58,59,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,75,53,25,-1,76,43,0,-1,77,78,70,-1,79,80,81,-1,82,78,77,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,104,105,106,-1,107,105,108,-1,86,96,101,-1,109,110,111,-1,88,87,112,-1,113,114,115,-1,116,117,118,-1,119,120,121,-1,122,123,124,-1,125,126,127,-1,128,129,130,-1,130,131,132,-1,124,133,114,-1,134,135,121,-1,92,136,93,-1,137,138,139,-1,140,119,141,-1,142,143,144,-1,145,146,9,-1,147,148,149,-1,14,150,151,-1,152,153,154,-1,155,156,157,-1,158,159,160,-1,161,146,162,-1,163,156,164,-1,165,145,9,-1,166,167,168,-1,169,170,171,-1,172,173,174,-1,175,176,22,-1,177,178,179,-1,180,181,182,-1,183,184,185,-1,186,187,183,-1,154,188,189,-1,154,190,191,-1,192,114,113,-1,115,193,113,-1,194,195,196,-1,187,197,198,-1,199,200,201,-1,202,203,204,-1,205,206,207,-1,208,102,209,-1,210,95,211,-1,66,212,67,-1,213,214,215,-1,216,106,217,-1,218,219,220,-1,221,222,223,-1,224,225,226,-1,227,228,229,-1,230,231,232,-1,233,234,235,-1,236,237,238,-1,239,240,241,-1,242,243,8,-1,244,245,246,-1,247,248,249,-1,250,251,252,-1,253,254,211,-1,255,256,257,-1,258,259,260,-1,261,262,263,-1,8,7,261,-1,264,265,266,-1,267,268,269,-1,97,270,271,-1,210,96,95,-1,272,273,274,-1,275,276,277,-1,236,238,278,-1,238,279,278,-1,6,280,281,-1,265,282,283,-1,284,263,285,-1,267,286,285,-1,287,288,289,-1,287,290,288,-1,291,292,293,-1,294,295,42,-1,296,297,298,-1,299,300,301,-1,302,303,304,-1,305,306,307,-1,276,308,309,-1,180,310,186,-1,186,183,311,-1,188,312,126,-1,193,313,202,-1,192,314,315,-1,125,127,313,-1,170,316,300,-1,74,118,72,-1,221,182,317,-1,318,319,320,-1,321,131,130,-1,322,323,324,-1,325,323,322,-1,326,327,328,-1,329,326,330,-1,331,332,59,-1,333,334,332,-1,335,336,337,-1,338,339,340,-1,339,341,342,-1,343,344,345,-1,346,347,348,-1,349,350,351,-1,348,352,353,-1,354,353,355,-1,356,357,358,-1,359,360,361,-1,362,176,363,-1,22,364,23,-1,365,366,367,-1,159,368,160,-1,369,370,371,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,381,382,383,-1,384,385,386,-1,387,380,388,-1,389,390,391,-1,392,393,5,-1,394,47,395,-1,396,397,398,-1,399,210,400,-1,249,401,254,-1,402,249,403,-1,404,403,405,-1,406,55,407,-1,407,55,54,-1,408,409,410,-1,411,409,62,-1,409,412,413,-1,414,415,416,-1,417,418,416,-1,417,419,420,-1,420,421,417,-1,422,423,424,-1,425,426,427,-1,166,428,424,-1,429,430,156,-1,431,432,433,-1,1,434,2,-1,435,436,437,-1,438,212,66,-1,439,440,441,-1,442,443,78,-1,444,32,445,-1,446,447,448,-1,449,20,19,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,459,460,461,-1,462,463,464,-1,465,466,467,-1,467,85,468,-1,469,470,471,-1,472,473,373,-1,474,475,476,-1,476,477,478,-1,479,480,477,-1,245,218,481,-1,229,228,482,-1,483,484,485,-1,486,487,488,-1,489,392,490,-1,491,492,493,-1,494,495,496,-1,497,498,499,-1,500,501,502,-1,503,504,505,-1,506,507,508,-1,507,506,509,-1,510,511,512,-1,513,514,515,-1,516,517,518,-1,519,520,521,-1,522,523,524,-1,525,526,527,-1,528,529,530,-1,528,530,487,-1,531,532,533,-1,534,535,536,-1,537,538,539,-1,540,541,542,-1,543,544,545,-1,546,547,548,-1,549,550,547,-1,551,552,553,-1,554,555,556,-1,557,558,559,-1,486,488,560,-1,561,562,563,-1,512,537,564,-1,565,566,567,-1,568,560,488,-1,569,570,558,-1,571,572,573,-1,570,569,574,-1,572,571,575,-1,576,577,578,-1,579,580,581,-1,582,583,584,-1,585,586,587,-1,588,589,590,-1,591,592,593,-1,594,595,596,-1,597,593,587,-1,598,599,600,-1,601,602,603,-1,604,605,606,-1,607,563,608,-1,609,610,611,-1,612,613,614,-1,615,616,617,-1,618,619,620,-1,621,622,623,-1,612,614,599,-1,624,611,625,-1,626,627,628,-1,593,629,591,-1,609,615,630,-1,631,632,633,-1,634,635,636,-1,637,638,639,-1,640,641,497,-1,574,642,568,-1,643,644,645,-1,646,647,631,-1,648,649,650,-1,651,496,652,-1,653,654,655,-1,656,657,658,-1,659,509,506,-1,660,661,662,-1,663,662,664,-1,665,666,667,-1,668,667,666,-1,666,669,668,-1,670,671,672,-1,673,671,670,-1,674,599,614,-1,674,675,676,-1,677,678,679,-1,680,681,669,-1,682,683,684,-1,685,686,687,-1,688,565,689,-1,690,691,692,-1,691,685,693,-1,694,695,592,-1,696,697,698,-1,553,699,700,-1,518,701,516,-1,702,703,704,-1,705,219,706,-1,707,708,709,-1,710,711,709,-1,595,710,708,-1,712,713,714,-1,715,716,595,-1,617,717,718,-1,719,720,721,-1,722,723,724,-1,725,726,727,-1,491,493,728,-1,729,730,244,-1,731,732,733,-1,734,697,735,-1,736,737,722,-1,738,739,740,-1,741,742,738,-1,734,743,585,-1,744,745,746,-1,575,747,748,-1,749,688,689,-1,750,492,751,-1,752,739,753,-1,754,755,737,-1,754,756,757,-1,758,759,760,-1,761,762,758,-1,763,764,765,-1,527,766,767,-1,765,768,769,-1,770,683,771,-1,566,772,773,-1,774,775,688,-1,668,776,663,-1,667,668,663,-1,686,685,777,-1,614,613,778,-1,676,675,779,-1,780,561,563,-1,781,782,711,-1,623,622,783,-1,784,785,637,-1,786,787,788,-1,789,786,790,-1,548,791,792,-1,79